/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/discoveryengine/v1/recommendation_service.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.discoveryengine.v1;

/**
 *
 *
 * <pre>
 * Response message for Recommend method.
 * </pre>
 *
 * Protobuf type {@code google.cloud.discoveryengine.v1.RecommendResponse}
 */
public final class RecommendResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1.RecommendResponse)
    RecommendResponseOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use RecommendResponse.newBuilder() to construct.
  private RecommendResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private RecommendResponse() {
    results_ = java.util.Collections.emptyList();
    attributionToken_ = "";
    missingIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new RecommendResponse();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.discoveryengine.v1.RecommendationServiceProto
        .internal_static_google_cloud_discoveryengine_v1_RecommendResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.discoveryengine.v1.RecommendationServiceProto
        .internal_static_google_cloud_discoveryengine_v1_RecommendResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.discoveryengine.v1.RecommendResponse.class,
            com.google.cloud.discoveryengine.v1.RecommendResponse.Builder.class);
  }

  public interface RecommendationResultOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1.RecommendResponse.RecommendationResult)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Resource ID of the recommended Document.
     * </pre>
     *
     * <code>string id = 1;</code>
     *
     * @return The id.
     */
    java.lang.String getId();

    /**
     *
     *
     * <pre>
     * Resource ID of the recommended Document.
     * </pre>
     *
     * <code>string id = 1;</code>
     *
     * @return The bytes for id.
     */
    com.google.protobuf.ByteString getIdBytes();

    /**
     *
     *
     * <pre>
     * Set if `returnDocument` is set to true in
     * [RecommendRequest.params][google.cloud.discoveryengine.v1.RecommendRequest.params].
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.Document document = 2;</code>
     *
     * @return Whether the document field is set.
     */
    boolean hasDocument();

    /**
     *
     *
     * <pre>
     * Set if `returnDocument` is set to true in
     * [RecommendRequest.params][google.cloud.discoveryengine.v1.RecommendRequest.params].
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.Document document = 2;</code>
     *
     * @return The document.
     */
    com.google.cloud.discoveryengine.v1.Document getDocument();

    /**
     *
     *
     * <pre>
     * Set if `returnDocument` is set to true in
     * [RecommendRequest.params][google.cloud.discoveryengine.v1.RecommendRequest.params].
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.Document document = 2;</code>
     */
    com.google.cloud.discoveryengine.v1.DocumentOrBuilder getDocumentOrBuilder();

    /**
     *
     *
     * <pre>
     * Additional Document metadata or annotations.
     *
     * Possible values:
     *
     * * `score`: Recommendation score in double value. Is set if
     *   `returnScore` is set to true in
     *   [RecommendRequest.params][google.cloud.discoveryengine.v1.RecommendRequest.params].
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Value&gt; metadata = 3;</code>
     */
    int getMetadataCount();

    /**
     *
     *
     * <pre>
     * Additional Document metadata or annotations.
     *
     * Possible values:
     *
     * * `score`: Recommendation score in double value. Is set if
     *   `returnScore` is set to true in
     *   [RecommendRequest.params][google.cloud.discoveryengine.v1.RecommendRequest.params].
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Value&gt; metadata = 3;</code>
     */
    boolean containsMetadata(java.lang.String key);

    /** Use {@link #getMetadataMap()} instead. */
    @java.lang.Deprecated
    java.util.Map<java.lang.String, com.google.protobuf.Value> getMetadata();

    /**
     *
     *
     * <pre>
     * Additional Document metadata or annotations.
     *
     * Possible values:
     *
     * * `score`: Recommendation score in double value. Is set if
     *   `returnScore` is set to true in
     *   [RecommendRequest.params][google.cloud.discoveryengine.v1.RecommendRequest.params].
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Value&gt; metadata = 3;</code>
     */
    java.util.Map<java.lang.String, com.google.protobuf.Value> getMetadataMap();

    /**
     *
     *
     * <pre>
     * Additional Document metadata or annotations.
     *
     * Possible values:
     *
     * * `score`: Recommendation score in double value. Is set if
     *   `returnScore` is set to true in
     *   [RecommendRequest.params][google.cloud.discoveryengine.v1.RecommendRequest.params].
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Value&gt; metadata = 3;</code>
     */
    /* nullable */
    com.google.protobuf.Value getMetadataOrDefault(
        java.lang.String key,
        /* nullable */
        com.google.protobuf.Value defaultValue);

    /**
     *
     *
     * <pre>
     * Additional Document metadata or annotations.
     *
     * Possible values:
     *
     * * `score`: Recommendation score in double value. Is set if
     *   `returnScore` is set to true in
     *   [RecommendRequest.params][google.cloud.discoveryengine.v1.RecommendRequest.params].
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Value&gt; metadata = 3;</code>
     */
    com.google.protobuf.Value getMetadataOrThrow(java.lang.String key);
  }

  /**
   *
   *
   * <pre>
   * RecommendationResult represents a generic recommendation result with
   * associated metadata.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1.RecommendResponse.RecommendationResult}
   */
  public static final class RecommendationResult extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1.RecommendResponse.RecommendationResult)
      RecommendationResultOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use RecommendationResult.newBuilder() to construct.
    private RecommendationResult(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private RecommendationResult() {
      id_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new RecommendationResult();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1.RecommendationServiceProto
          .internal_static_google_cloud_discoveryengine_v1_RecommendResponse_RecommendationResult_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    @java.lang.Override
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 3:
          return internalGetMetadata();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1.RecommendationServiceProto
          .internal_static_google_cloud_discoveryengine_v1_RecommendResponse_RecommendationResult_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1.RecommendResponse.RecommendationResult.class,
              com.google.cloud.discoveryengine.v1.RecommendResponse.RecommendationResult.Builder
                  .class);
    }

    private int bitField0_;
    public static final int ID_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object id_ = "";

    /**
     *
     *
     * <pre>
     * Resource ID of the recommended Document.
     * </pre>
     *
     * <code>string id = 1;</code>
     *
     * @return The id.
     */
    @java.lang.Override
    public java.lang.String getId() {
      java.lang.Object ref = id_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        id_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Resource ID of the recommended Document.
     * </pre>
     *
     * <code>string id = 1;</code>
     *
     * @return The bytes for id.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getIdBytes() {
      java.lang.Object ref = id_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        id_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int DOCUMENT_FIELD_NUMBER = 2;
    private com.google.cloud.discoveryengine.v1.Document document_;

    /**
     *
     *
     * <pre>
     * Set if `returnDocument` is set to true in
     * [RecommendRequest.params][google.cloud.discoveryengine.v1.RecommendRequest.params].
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.Document document = 2;</code>
     *
     * @return Whether the document field is set.
     */
    @java.lang.Override
    public boolean hasDocument() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * Set if `returnDocument` is set to true in
     * [RecommendRequest.params][google.cloud.discoveryengine.v1.RecommendRequest.params].
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.Document document = 2;</code>
     *
     * @return The document.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.Document getDocument() {
      return document_ == null
          ? com.google.cloud.discoveryengine.v1.Document.getDefaultInstance()
          : document_;
    }

    /**
     *
     *
     * <pre>
     * Set if `returnDocument` is set to true in
     * [RecommendRequest.params][google.cloud.discoveryengine.v1.RecommendRequest.params].
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.Document document = 2;</code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.DocumentOrBuilder getDocumentOrBuilder() {
      return document_ == null
          ? com.google.cloud.discoveryengine.v1.Document.getDefaultInstance()
          : document_;
    }

    public static final int METADATA_FIELD_NUMBER = 3;

    private static final class MetadataDefaultEntryHolder {
      static final com.google.protobuf.MapEntry<java.lang.String, com.google.protobuf.Value>
          defaultEntry =
              com.google.protobuf.MapEntry
                  .<java.lang.String, com.google.protobuf.Value>newDefaultInstance(
                      com.google.cloud.discoveryengine.v1.RecommendationServiceProto
                          .internal_static_google_cloud_discoveryengine_v1_RecommendResponse_RecommendationResult_MetadataEntry_descriptor,
                      com.google.protobuf.WireFormat.FieldType.STRING,
                      "",
                      com.google.protobuf.WireFormat.FieldType.MESSAGE,
                      com.google.protobuf.Value.getDefaultInstance());
    }

    @SuppressWarnings("serial")
    private com.google.protobuf.MapField<java.lang.String, com.google.protobuf.Value> metadata_;

    private com.google.protobuf.MapField<java.lang.String, com.google.protobuf.Value>
        internalGetMetadata() {
      if (metadata_ == null) {
        return com.google.protobuf.MapField.emptyMapField(MetadataDefaultEntryHolder.defaultEntry);
      }
      return metadata_;
    }

    public int getMetadataCount() {
      return internalGetMetadata().getMap().size();
    }

    /**
     *
     *
     * <pre>
     * Additional Document metadata or annotations.
     *
     * Possible values:
     *
     * * `score`: Recommendation score in double value. Is set if
     *   `returnScore` is set to true in
     *   [RecommendRequest.params][google.cloud.discoveryengine.v1.RecommendRequest.params].
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Value&gt; metadata = 3;</code>
     */
    @java.lang.Override
    public boolean containsMetadata(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetMetadata().getMap().containsKey(key);
    }

    /** Use {@link #getMetadataMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.protobuf.Value> getMetadata() {
      return getMetadataMap();
    }

    /**
     *
     *
     * <pre>
     * Additional Document metadata or annotations.
     *
     * Possible values:
     *
     * * `score`: Recommendation score in double value. Is set if
     *   `returnScore` is set to true in
     *   [RecommendRequest.params][google.cloud.discoveryengine.v1.RecommendRequest.params].
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Value&gt; metadata = 3;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, com.google.protobuf.Value> getMetadataMap() {
      return internalGetMetadata().getMap();
    }

    /**
     *
     *
     * <pre>
     * Additional Document metadata or annotations.
     *
     * Possible values:
     *
     * * `score`: Recommendation score in double value. Is set if
     *   `returnScore` is set to true in
     *   [RecommendRequest.params][google.cloud.discoveryengine.v1.RecommendRequest.params].
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Value&gt; metadata = 3;</code>
     */
    @java.lang.Override
    public /* nullable */ com.google.protobuf.Value getMetadataOrDefault(
        java.lang.String key,
        /* nullable */
        com.google.protobuf.Value defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.protobuf.Value> map =
          internalGetMetadata().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }

    /**
     *
     *
     * <pre>
     * Additional Document metadata or annotations.
     *
     * Possible values:
     *
     * * `score`: Recommendation score in double value. Is set if
     *   `returnScore` is set to true in
     *   [RecommendRequest.params][google.cloud.discoveryengine.v1.RecommendRequest.params].
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Value&gt; metadata = 3;</code>
     */
    @java.lang.Override
    public com.google.protobuf.Value getMetadataOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.protobuf.Value> map =
          internalGetMetadata().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, id_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(2, getDocument());
      }
      com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
          output, internalGetMetadata(), MetadataDefaultEntryHolder.defaultEntry, 3);
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, id_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getDocument());
      }
      for (java.util.Map.Entry<java.lang.String, com.google.protobuf.Value> entry :
          internalGetMetadata().getMap().entrySet()) {
        com.google.protobuf.MapEntry<java.lang.String, com.google.protobuf.Value> metadata__ =
            MetadataDefaultEntryHolder.defaultEntry
                .newBuilderForType()
                .setKey(entry.getKey())
                .setValue(entry.getValue())
                .build();
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, metadata__);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.discoveryengine.v1.RecommendResponse.RecommendationResult)) {
        return super.equals(obj);
      }
      com.google.cloud.discoveryengine.v1.RecommendResponse.RecommendationResult other =
          (com.google.cloud.discoveryengine.v1.RecommendResponse.RecommendationResult) obj;

      if (!getId().equals(other.getId())) return false;
      if (hasDocument() != other.hasDocument()) return false;
      if (hasDocument()) {
        if (!getDocument().equals(other.getDocument())) return false;
      }
      if (!internalGetMetadata().equals(other.internalGetMetadata())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ID_FIELD_NUMBER;
      hash = (53 * hash) + getId().hashCode();
      if (hasDocument()) {
        hash = (37 * hash) + DOCUMENT_FIELD_NUMBER;
        hash = (53 * hash) + getDocument().hashCode();
      }
      if (!internalGetMetadata().getMap().isEmpty()) {
        hash = (37 * hash) + METADATA_FIELD_NUMBER;
        hash = (53 * hash) + internalGetMetadata().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.discoveryengine.v1.RecommendResponse.RecommendationResult
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1.RecommendResponse.RecommendationResult
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.RecommendResponse.RecommendationResult
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1.RecommendResponse.RecommendationResult
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.RecommendResponse.RecommendationResult
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1.RecommendResponse.RecommendationResult
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.RecommendResponse.RecommendationResult
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1.RecommendResponse.RecommendationResult
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.RecommendResponse.RecommendationResult
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1.RecommendResponse.RecommendationResult
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.RecommendResponse.RecommendationResult
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1.RecommendResponse.RecommendationResult
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.discoveryengine.v1.RecommendResponse.RecommendationResult prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * RecommendationResult represents a generic recommendation result with
     * associated metadata.
     * </pre>
     *
     * Protobuf type {@code google.cloud.discoveryengine.v1.RecommendResponse.RecommendationResult}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1.RecommendResponse.RecommendationResult)
        com.google.cloud.discoveryengine.v1.RecommendResponse.RecommendationResultOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1.RecommendationServiceProto
            .internal_static_google_cloud_discoveryengine_v1_RecommendResponse_RecommendationResult_descriptor;
      }

      @SuppressWarnings({"rawtypes"})
      protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
          int number) {
        switch (number) {
          case 3:
            return internalGetMetadata();
          default:
            throw new RuntimeException("Invalid map field number: " + number);
        }
      }

      @SuppressWarnings({"rawtypes"})
      protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
          int number) {
        switch (number) {
          case 3:
            return internalGetMutableMetadata();
          default:
            throw new RuntimeException("Invalid map field number: " + number);
        }
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1.RecommendationServiceProto
            .internal_static_google_cloud_discoveryengine_v1_RecommendResponse_RecommendationResult_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1.RecommendResponse.RecommendationResult.class,
                com.google.cloud.discoveryengine.v1.RecommendResponse.RecommendationResult.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.discoveryengine.v1.RecommendResponse.RecommendationResult.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getDocumentFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        id_ = "";
        document_ = null;
        if (documentBuilder_ != null) {
          documentBuilder_.dispose();
          documentBuilder_ = null;
        }
        internalGetMutableMetadata().clear();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.discoveryengine.v1.RecommendationServiceProto
            .internal_static_google_cloud_discoveryengine_v1_RecommendResponse_RecommendationResult_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.RecommendResponse.RecommendationResult
          getDefaultInstanceForType() {
        return com.google.cloud.discoveryengine.v1.RecommendResponse.RecommendationResult
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.RecommendResponse.RecommendationResult build() {
        com.google.cloud.discoveryengine.v1.RecommendResponse.RecommendationResult result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.RecommendResponse.RecommendationResult
          buildPartial() {
        com.google.cloud.discoveryengine.v1.RecommendResponse.RecommendationResult result =
            new com.google.cloud.discoveryengine.v1.RecommendResponse.RecommendationResult(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.discoveryengine.v1.RecommendResponse.RecommendationResult result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.id_ = id_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.document_ = documentBuilder_ == null ? document_ : documentBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.metadata_ = internalGetMetadata().build(MetadataDefaultEntryHolder.defaultEntry);
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.discoveryengine.v1.RecommendResponse.RecommendationResult) {
          return mergeFrom(
              (com.google.cloud.discoveryengine.v1.RecommendResponse.RecommendationResult) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.discoveryengine.v1.RecommendResponse.RecommendationResult other) {
        if (other
            == com.google.cloud.discoveryengine.v1.RecommendResponse.RecommendationResult
                .getDefaultInstance()) return this;
        if (!other.getId().isEmpty()) {
          id_ = other.id_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (other.hasDocument()) {
          mergeDocument(other.getDocument());
        }
        internalGetMutableMetadata().mergeFrom(other.internalGetMetadata());
        bitField0_ |= 0x00000004;
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  id_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(getDocumentFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  com.google.protobuf.MapEntry<java.lang.String, com.google.protobuf.Value>
                      metadata__ =
                          input.readMessage(
                              MetadataDefaultEntryHolder.defaultEntry.getParserForType(),
                              extensionRegistry);
                  internalGetMutableMetadata()
                      .ensureBuilderMap()
                      .put(metadata__.getKey(), metadata__.getValue());
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object id_ = "";

      /**
       *
       *
       * <pre>
       * Resource ID of the recommended Document.
       * </pre>
       *
       * <code>string id = 1;</code>
       *
       * @return The id.
       */
      public java.lang.String getId() {
        java.lang.Object ref = id_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          id_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Resource ID of the recommended Document.
       * </pre>
       *
       * <code>string id = 1;</code>
       *
       * @return The bytes for id.
       */
      public com.google.protobuf.ByteString getIdBytes() {
        java.lang.Object ref = id_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          id_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Resource ID of the recommended Document.
       * </pre>
       *
       * <code>string id = 1;</code>
       *
       * @param value The id to set.
       * @return This builder for chaining.
       */
      public Builder setId(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        id_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Resource ID of the recommended Document.
       * </pre>
       *
       * <code>string id = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearId() {
        id_ = getDefaultInstance().getId();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Resource ID of the recommended Document.
       * </pre>
       *
       * <code>string id = 1;</code>
       *
       * @param value The bytes for id to set.
       * @return This builder for chaining.
       */
      public Builder setIdBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        id_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private com.google.cloud.discoveryengine.v1.Document document_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.discoveryengine.v1.Document,
              com.google.cloud.discoveryengine.v1.Document.Builder,
              com.google.cloud.discoveryengine.v1.DocumentOrBuilder>
          documentBuilder_;

      /**
       *
       *
       * <pre>
       * Set if `returnDocument` is set to true in
       * [RecommendRequest.params][google.cloud.discoveryengine.v1.RecommendRequest.params].
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1.Document document = 2;</code>
       *
       * @return Whether the document field is set.
       */
      public boolean hasDocument() {
        return ((bitField0_ & 0x00000002) != 0);
      }

      /**
       *
       *
       * <pre>
       * Set if `returnDocument` is set to true in
       * [RecommendRequest.params][google.cloud.discoveryengine.v1.RecommendRequest.params].
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1.Document document = 2;</code>
       *
       * @return The document.
       */
      public com.google.cloud.discoveryengine.v1.Document getDocument() {
        if (documentBuilder_ == null) {
          return document_ == null
              ? com.google.cloud.discoveryengine.v1.Document.getDefaultInstance()
              : document_;
        } else {
          return documentBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * Set if `returnDocument` is set to true in
       * [RecommendRequest.params][google.cloud.discoveryengine.v1.RecommendRequest.params].
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1.Document document = 2;</code>
       */
      public Builder setDocument(com.google.cloud.discoveryengine.v1.Document value) {
        if (documentBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          document_ = value;
        } else {
          documentBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Set if `returnDocument` is set to true in
       * [RecommendRequest.params][google.cloud.discoveryengine.v1.RecommendRequest.params].
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1.Document document = 2;</code>
       */
      public Builder setDocument(
          com.google.cloud.discoveryengine.v1.Document.Builder builderForValue) {
        if (documentBuilder_ == null) {
          document_ = builderForValue.build();
        } else {
          documentBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Set if `returnDocument` is set to true in
       * [RecommendRequest.params][google.cloud.discoveryengine.v1.RecommendRequest.params].
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1.Document document = 2;</code>
       */
      public Builder mergeDocument(com.google.cloud.discoveryengine.v1.Document value) {
        if (documentBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && document_ != null
              && document_ != com.google.cloud.discoveryengine.v1.Document.getDefaultInstance()) {
            getDocumentBuilder().mergeFrom(value);
          } else {
            document_ = value;
          }
        } else {
          documentBuilder_.mergeFrom(value);
        }
        if (document_ != null) {
          bitField0_ |= 0x00000002;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Set if `returnDocument` is set to true in
       * [RecommendRequest.params][google.cloud.discoveryengine.v1.RecommendRequest.params].
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1.Document document = 2;</code>
       */
      public Builder clearDocument() {
        bitField0_ = (bitField0_ & ~0x00000002);
        document_ = null;
        if (documentBuilder_ != null) {
          documentBuilder_.dispose();
          documentBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Set if `returnDocument` is set to true in
       * [RecommendRequest.params][google.cloud.discoveryengine.v1.RecommendRequest.params].
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1.Document document = 2;</code>
       */
      public com.google.cloud.discoveryengine.v1.Document.Builder getDocumentBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getDocumentFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Set if `returnDocument` is set to true in
       * [RecommendRequest.params][google.cloud.discoveryengine.v1.RecommendRequest.params].
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1.Document document = 2;</code>
       */
      public com.google.cloud.discoveryengine.v1.DocumentOrBuilder getDocumentOrBuilder() {
        if (documentBuilder_ != null) {
          return documentBuilder_.getMessageOrBuilder();
        } else {
          return document_ == null
              ? com.google.cloud.discoveryengine.v1.Document.getDefaultInstance()
              : document_;
        }
      }

      /**
       *
       *
       * <pre>
       * Set if `returnDocument` is set to true in
       * [RecommendRequest.params][google.cloud.discoveryengine.v1.RecommendRequest.params].
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1.Document document = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.discoveryengine.v1.Document,
              com.google.cloud.discoveryengine.v1.Document.Builder,
              com.google.cloud.discoveryengine.v1.DocumentOrBuilder>
          getDocumentFieldBuilder() {
        if (documentBuilder_ == null) {
          documentBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.discoveryengine.v1.Document,
                  com.google.cloud.discoveryengine.v1.Document.Builder,
                  com.google.cloud.discoveryengine.v1.DocumentOrBuilder>(
                  getDocument(), getParentForChildren(), isClean());
          document_ = null;
        }
        return documentBuilder_;
      }

      private static final class MetadataConverter
          implements com.google.protobuf.MapFieldBuilder.Converter<
              java.lang.String, com.google.protobuf.ValueOrBuilder, com.google.protobuf.Value> {
        @java.lang.Override
        public com.google.protobuf.Value build(com.google.protobuf.ValueOrBuilder val) {
          if (val instanceof com.google.protobuf.Value) {
            return (com.google.protobuf.Value) val;
          }
          return ((com.google.protobuf.Value.Builder) val).build();
        }

        @java.lang.Override
        public com.google.protobuf.MapEntry<java.lang.String, com.google.protobuf.Value>
            defaultEntry() {
          return MetadataDefaultEntryHolder.defaultEntry;
        }
      }
      ;

      private static final MetadataConverter metadataConverter = new MetadataConverter();

      private com.google.protobuf.MapFieldBuilder<
              java.lang.String,
              com.google.protobuf.ValueOrBuilder,
              com.google.protobuf.Value,
              com.google.protobuf.Value.Builder>
          metadata_;

      private com.google.protobuf.MapFieldBuilder<
              java.lang.String,
              com.google.protobuf.ValueOrBuilder,
              com.google.protobuf.Value,
              com.google.protobuf.Value.Builder>
          internalGetMetadata() {
        if (metadata_ == null) {
          return new com.google.protobuf.MapFieldBuilder<>(metadataConverter);
        }
        return metadata_;
      }

      private com.google.protobuf.MapFieldBuilder<
              java.lang.String,
              com.google.protobuf.ValueOrBuilder,
              com.google.protobuf.Value,
              com.google.protobuf.Value.Builder>
          internalGetMutableMetadata() {
        if (metadata_ == null) {
          metadata_ = new com.google.protobuf.MapFieldBuilder<>(metadataConverter);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return metadata_;
      }

      public int getMetadataCount() {
        return internalGetMetadata().ensureBuilderMap().size();
      }

      /**
       *
       *
       * <pre>
       * Additional Document metadata or annotations.
       *
       * Possible values:
       *
       * * `score`: Recommendation score in double value. Is set if
       *   `returnScore` is set to true in
       *   [RecommendRequest.params][google.cloud.discoveryengine.v1.RecommendRequest.params].
       * </pre>
       *
       * <code>map&lt;string, .google.protobuf.Value&gt; metadata = 3;</code>
       */
      @java.lang.Override
      public boolean containsMetadata(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        return internalGetMetadata().ensureBuilderMap().containsKey(key);
      }

      /** Use {@link #getMetadataMap()} instead. */
      @java.lang.Override
      @java.lang.Deprecated
      public java.util.Map<java.lang.String, com.google.protobuf.Value> getMetadata() {
        return getMetadataMap();
      }

      /**
       *
       *
       * <pre>
       * Additional Document metadata or annotations.
       *
       * Possible values:
       *
       * * `score`: Recommendation score in double value. Is set if
       *   `returnScore` is set to true in
       *   [RecommendRequest.params][google.cloud.discoveryengine.v1.RecommendRequest.params].
       * </pre>
       *
       * <code>map&lt;string, .google.protobuf.Value&gt; metadata = 3;</code>
       */
      @java.lang.Override
      public java.util.Map<java.lang.String, com.google.protobuf.Value> getMetadataMap() {
        return internalGetMetadata().getImmutableMap();
      }

      /**
       *
       *
       * <pre>
       * Additional Document metadata or annotations.
       *
       * Possible values:
       *
       * * `score`: Recommendation score in double value. Is set if
       *   `returnScore` is set to true in
       *   [RecommendRequest.params][google.cloud.discoveryengine.v1.RecommendRequest.params].
       * </pre>
       *
       * <code>map&lt;string, .google.protobuf.Value&gt; metadata = 3;</code>
       */
      @java.lang.Override
      public /* nullable */ com.google.protobuf.Value getMetadataOrDefault(
          java.lang.String key,
          /* nullable */
          com.google.protobuf.Value defaultValue) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<java.lang.String, com.google.protobuf.ValueOrBuilder> map =
            internalGetMutableMetadata().ensureBuilderMap();
        return map.containsKey(key) ? metadataConverter.build(map.get(key)) : defaultValue;
      }

      /**
       *
       *
       * <pre>
       * Additional Document metadata or annotations.
       *
       * Possible values:
       *
       * * `score`: Recommendation score in double value. Is set if
       *   `returnScore` is set to true in
       *   [RecommendRequest.params][google.cloud.discoveryengine.v1.RecommendRequest.params].
       * </pre>
       *
       * <code>map&lt;string, .google.protobuf.Value&gt; metadata = 3;</code>
       */
      @java.lang.Override
      public com.google.protobuf.Value getMetadataOrThrow(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<java.lang.String, com.google.protobuf.ValueOrBuilder> map =
            internalGetMutableMetadata().ensureBuilderMap();
        if (!map.containsKey(key)) {
          throw new java.lang.IllegalArgumentException();
        }
        return metadataConverter.build(map.get(key));
      }

      public Builder clearMetadata() {
        bitField0_ = (bitField0_ & ~0x00000004);
        internalGetMutableMetadata().clear();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Additional Document metadata or annotations.
       *
       * Possible values:
       *
       * * `score`: Recommendation score in double value. Is set if
       *   `returnScore` is set to true in
       *   [RecommendRequest.params][google.cloud.discoveryengine.v1.RecommendRequest.params].
       * </pre>
       *
       * <code>map&lt;string, .google.protobuf.Value&gt; metadata = 3;</code>
       */
      public Builder removeMetadata(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        internalGetMutableMetadata().ensureBuilderMap().remove(key);
        return this;
      }

      /** Use alternate mutation accessors instead. */
      @java.lang.Deprecated
      public java.util.Map<java.lang.String, com.google.protobuf.Value> getMutableMetadata() {
        bitField0_ |= 0x00000004;
        return internalGetMutableMetadata().ensureMessageMap();
      }

      /**
       *
       *
       * <pre>
       * Additional Document metadata or annotations.
       *
       * Possible values:
       *
       * * `score`: Recommendation score in double value. Is set if
       *   `returnScore` is set to true in
       *   [RecommendRequest.params][google.cloud.discoveryengine.v1.RecommendRequest.params].
       * </pre>
       *
       * <code>map&lt;string, .google.protobuf.Value&gt; metadata = 3;</code>
       */
      public Builder putMetadata(java.lang.String key, com.google.protobuf.Value value) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        if (value == null) {
          throw new NullPointerException("map value");
        }
        internalGetMutableMetadata().ensureBuilderMap().put(key, value);
        bitField0_ |= 0x00000004;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Additional Document metadata or annotations.
       *
       * Possible values:
       *
       * * `score`: Recommendation score in double value. Is set if
       *   `returnScore` is set to true in
       *   [RecommendRequest.params][google.cloud.discoveryengine.v1.RecommendRequest.params].
       * </pre>
       *
       * <code>map&lt;string, .google.protobuf.Value&gt; metadata = 3;</code>
       */
      public Builder putAllMetadata(
          java.util.Map<java.lang.String, com.google.protobuf.Value> values) {
        for (java.util.Map.Entry<java.lang.String, com.google.protobuf.Value> e :
            values.entrySet()) {
          if (e.getKey() == null || e.getValue() == null) {
            throw new NullPointerException();
          }
        }
        internalGetMutableMetadata().ensureBuilderMap().putAll(values);
        bitField0_ |= 0x00000004;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Additional Document metadata or annotations.
       *
       * Possible values:
       *
       * * `score`: Recommendation score in double value. Is set if
       *   `returnScore` is set to true in
       *   [RecommendRequest.params][google.cloud.discoveryengine.v1.RecommendRequest.params].
       * </pre>
       *
       * <code>map&lt;string, .google.protobuf.Value&gt; metadata = 3;</code>
       */
      public com.google.protobuf.Value.Builder putMetadataBuilderIfAbsent(java.lang.String key) {
        java.util.Map<java.lang.String, com.google.protobuf.ValueOrBuilder> builderMap =
            internalGetMutableMetadata().ensureBuilderMap();
        com.google.protobuf.ValueOrBuilder entry = builderMap.get(key);
        if (entry == null) {
          entry = com.google.protobuf.Value.newBuilder();
          builderMap.put(key, entry);
        }
        if (entry instanceof com.google.protobuf.Value) {
          entry = ((com.google.protobuf.Value) entry).toBuilder();
          builderMap.put(key, entry);
        }
        return (com.google.protobuf.Value.Builder) entry;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1.RecommendResponse.RecommendationResult)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1.RecommendResponse.RecommendationResult)
    private static final com.google.cloud.discoveryengine.v1.RecommendResponse.RecommendationResult
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.discoveryengine.v1.RecommendResponse.RecommendationResult();
    }

    public static com.google.cloud.discoveryengine.v1.RecommendResponse.RecommendationResult
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<RecommendationResult> PARSER =
        new com.google.protobuf.AbstractParser<RecommendationResult>() {
          @java.lang.Override
          public RecommendationResult parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<RecommendationResult> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<RecommendationResult> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.RecommendResponse.RecommendationResult
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int RESULTS_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.discoveryengine.v1.RecommendResponse.RecommendationResult>
      results_;

  /**
   *
   *
   * <pre>
   * A list of recommended Documents. The order represents the ranking (from the
   * most relevant Document to the least).
   * </pre>
   *
   * <code>
   * repeated .google.cloud.discoveryengine.v1.RecommendResponse.RecommendationResult results = 1;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.discoveryengine.v1.RecommendResponse.RecommendationResult>
      getResultsList() {
    return results_;
  }

  /**
   *
   *
   * <pre>
   * A list of recommended Documents. The order represents the ranking (from the
   * most relevant Document to the least).
   * </pre>
   *
   * <code>
   * repeated .google.cloud.discoveryengine.v1.RecommendResponse.RecommendationResult results = 1;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends
              com.google.cloud.discoveryengine.v1.RecommendResponse.RecommendationResultOrBuilder>
      getResultsOrBuilderList() {
    return results_;
  }

  /**
   *
   *
   * <pre>
   * A list of recommended Documents. The order represents the ranking (from the
   * most relevant Document to the least).
   * </pre>
   *
   * <code>
   * repeated .google.cloud.discoveryengine.v1.RecommendResponse.RecommendationResult results = 1;
   * </code>
   */
  @java.lang.Override
  public int getResultsCount() {
    return results_.size();
  }

  /**
   *
   *
   * <pre>
   * A list of recommended Documents. The order represents the ranking (from the
   * most relevant Document to the least).
   * </pre>
   *
   * <code>
   * repeated .google.cloud.discoveryengine.v1.RecommendResponse.RecommendationResult results = 1;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.RecommendResponse.RecommendationResult getResults(
      int index) {
    return results_.get(index);
  }

  /**
   *
   *
   * <pre>
   * A list of recommended Documents. The order represents the ranking (from the
   * most relevant Document to the least).
   * </pre>
   *
   * <code>
   * repeated .google.cloud.discoveryengine.v1.RecommendResponse.RecommendationResult results = 1;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.RecommendResponse.RecommendationResultOrBuilder
      getResultsOrBuilder(int index) {
    return results_.get(index);
  }

  public static final int ATTRIBUTION_TOKEN_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object attributionToken_ = "";

  /**
   *
   *
   * <pre>
   * A unique attribution token. This should be included in the
   * [UserEvent][google.cloud.discoveryengine.v1.UserEvent] logs resulting from
   * this recommendation, which enables accurate attribution of recommendation
   * model performance.
   * </pre>
   *
   * <code>string attribution_token = 2;</code>
   *
   * @return The attributionToken.
   */
  @java.lang.Override
  public java.lang.String getAttributionToken() {
    java.lang.Object ref = attributionToken_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      attributionToken_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * A unique attribution token. This should be included in the
   * [UserEvent][google.cloud.discoveryengine.v1.UserEvent] logs resulting from
   * this recommendation, which enables accurate attribution of recommendation
   * model performance.
   * </pre>
   *
   * <code>string attribution_token = 2;</code>
   *
   * @return The bytes for attributionToken.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getAttributionTokenBytes() {
    java.lang.Object ref = attributionToken_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      attributionToken_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MISSING_IDS_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList missingIds_ =
      com.google.protobuf.LazyStringArrayList.emptyList();

  /**
   *
   *
   * <pre>
   * IDs of documents in the request that were missing from the default Branch
   * associated with the requested ServingConfig.
   * </pre>
   *
   * <code>repeated string missing_ids = 3;</code>
   *
   * @return A list containing the missingIds.
   */
  public com.google.protobuf.ProtocolStringList getMissingIdsList() {
    return missingIds_;
  }

  /**
   *
   *
   * <pre>
   * IDs of documents in the request that were missing from the default Branch
   * associated with the requested ServingConfig.
   * </pre>
   *
   * <code>repeated string missing_ids = 3;</code>
   *
   * @return The count of missingIds.
   */
  public int getMissingIdsCount() {
    return missingIds_.size();
  }

  /**
   *
   *
   * <pre>
   * IDs of documents in the request that were missing from the default Branch
   * associated with the requested ServingConfig.
   * </pre>
   *
   * <code>repeated string missing_ids = 3;</code>
   *
   * @param index The index of the element to return.
   * @return The missingIds at the given index.
   */
  public java.lang.String getMissingIds(int index) {
    return missingIds_.get(index);
  }

  /**
   *
   *
   * <pre>
   * IDs of documents in the request that were missing from the default Branch
   * associated with the requested ServingConfig.
   * </pre>
   *
   * <code>repeated string missing_ids = 3;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the missingIds at the given index.
   */
  public com.google.protobuf.ByteString getMissingIdsBytes(int index) {
    return missingIds_.getByteString(index);
  }

  public static final int VALIDATE_ONLY_FIELD_NUMBER = 4;
  private boolean validateOnly_ = false;

  /**
   *
   *
   * <pre>
   * True if
   * [RecommendRequest.validate_only][google.cloud.discoveryengine.v1.RecommendRequest.validate_only]
   * was set.
   * </pre>
   *
   * <code>bool validate_only = 4;</code>
   *
   * @return The validateOnly.
   */
  @java.lang.Override
  public boolean getValidateOnly() {
    return validateOnly_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < results_.size(); i++) {
      output.writeMessage(1, results_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(attributionToken_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, attributionToken_);
    }
    for (int i = 0; i < missingIds_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, missingIds_.getRaw(i));
    }
    if (validateOnly_ != false) {
      output.writeBool(4, validateOnly_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < results_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, results_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(attributionToken_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, attributionToken_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < missingIds_.size(); i++) {
        dataSize += computeStringSizeNoTag(missingIds_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getMissingIdsList().size();
    }
    if (validateOnly_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(4, validateOnly_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.discoveryengine.v1.RecommendResponse)) {
      return super.equals(obj);
    }
    com.google.cloud.discoveryengine.v1.RecommendResponse other =
        (com.google.cloud.discoveryengine.v1.RecommendResponse) obj;

    if (!getResultsList().equals(other.getResultsList())) return false;
    if (!getAttributionToken().equals(other.getAttributionToken())) return false;
    if (!getMissingIdsList().equals(other.getMissingIdsList())) return false;
    if (getValidateOnly() != other.getValidateOnly()) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getResultsCount() > 0) {
      hash = (37 * hash) + RESULTS_FIELD_NUMBER;
      hash = (53 * hash) + getResultsList().hashCode();
    }
    hash = (37 * hash) + ATTRIBUTION_TOKEN_FIELD_NUMBER;
    hash = (53 * hash) + getAttributionToken().hashCode();
    if (getMissingIdsCount() > 0) {
      hash = (37 * hash) + MISSING_IDS_FIELD_NUMBER;
      hash = (53 * hash) + getMissingIdsList().hashCode();
    }
    hash = (37 * hash) + VALIDATE_ONLY_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getValidateOnly());
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.discoveryengine.v1.RecommendResponse parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1.RecommendResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.RecommendResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1.RecommendResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.RecommendResponse parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1.RecommendResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.RecommendResponse parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1.RecommendResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.RecommendResponse parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1.RecommendResponse parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.RecommendResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1.RecommendResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.discoveryengine.v1.RecommendResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Response message for Recommend method.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1.RecommendResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1.RecommendResponse)
      com.google.cloud.discoveryengine.v1.RecommendResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1.RecommendationServiceProto
          .internal_static_google_cloud_discoveryengine_v1_RecommendResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1.RecommendationServiceProto
          .internal_static_google_cloud_discoveryengine_v1_RecommendResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1.RecommendResponse.class,
              com.google.cloud.discoveryengine.v1.RecommendResponse.Builder.class);
    }

    // Construct using com.google.cloud.discoveryengine.v1.RecommendResponse.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (resultsBuilder_ == null) {
        results_ = java.util.Collections.emptyList();
      } else {
        results_ = null;
        resultsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      attributionToken_ = "";
      missingIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
      validateOnly_ = false;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.discoveryengine.v1.RecommendationServiceProto
          .internal_static_google_cloud_discoveryengine_v1_RecommendResponse_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.RecommendResponse getDefaultInstanceForType() {
      return com.google.cloud.discoveryengine.v1.RecommendResponse.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.RecommendResponse build() {
      com.google.cloud.discoveryengine.v1.RecommendResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.RecommendResponse buildPartial() {
      com.google.cloud.discoveryengine.v1.RecommendResponse result =
          new com.google.cloud.discoveryengine.v1.RecommendResponse(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.discoveryengine.v1.RecommendResponse result) {
      if (resultsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          results_ = java.util.Collections.unmodifiableList(results_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.results_ = results_;
      } else {
        result.results_ = resultsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.discoveryengine.v1.RecommendResponse result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.attributionToken_ = attributionToken_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        missingIds_.makeImmutable();
        result.missingIds_ = missingIds_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.validateOnly_ = validateOnly_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.discoveryengine.v1.RecommendResponse) {
        return mergeFrom((com.google.cloud.discoveryengine.v1.RecommendResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.discoveryengine.v1.RecommendResponse other) {
      if (other == com.google.cloud.discoveryengine.v1.RecommendResponse.getDefaultInstance())
        return this;
      if (resultsBuilder_ == null) {
        if (!other.results_.isEmpty()) {
          if (results_.isEmpty()) {
            results_ = other.results_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureResultsIsMutable();
            results_.addAll(other.results_);
          }
          onChanged();
        }
      } else {
        if (!other.results_.isEmpty()) {
          if (resultsBuilder_.isEmpty()) {
            resultsBuilder_.dispose();
            resultsBuilder_ = null;
            results_ = other.results_;
            bitField0_ = (bitField0_ & ~0x00000001);
            resultsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getResultsFieldBuilder()
                    : null;
          } else {
            resultsBuilder_.addAllMessages(other.results_);
          }
        }
      }
      if (!other.getAttributionToken().isEmpty()) {
        attributionToken_ = other.attributionToken_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.missingIds_.isEmpty()) {
        if (missingIds_.isEmpty()) {
          missingIds_ = other.missingIds_;
          bitField0_ |= 0x00000004;
        } else {
          ensureMissingIdsIsMutable();
          missingIds_.addAll(other.missingIds_);
        }
        onChanged();
      }
      if (other.getValidateOnly() != false) {
        setValidateOnly(other.getValidateOnly());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.cloud.discoveryengine.v1.RecommendResponse.RecommendationResult m =
                    input.readMessage(
                        com.google.cloud.discoveryengine.v1.RecommendResponse.RecommendationResult
                            .parser(),
                        extensionRegistry);
                if (resultsBuilder_ == null) {
                  ensureResultsIsMutable();
                  results_.add(m);
                } else {
                  resultsBuilder_.addMessage(m);
                }
                break;
              } // case 10
            case 18:
              {
                attributionToken_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureMissingIdsIsMutable();
                missingIds_.add(s);
                break;
              } // case 26
            case 32:
              {
                validateOnly_ = input.readBool();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<
            com.google.cloud.discoveryengine.v1.RecommendResponse.RecommendationResult>
        results_ = java.util.Collections.emptyList();

    private void ensureResultsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        results_ =
            new java.util.ArrayList<
                com.google.cloud.discoveryengine.v1.RecommendResponse.RecommendationResult>(
                results_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.discoveryengine.v1.RecommendResponse.RecommendationResult,
            com.google.cloud.discoveryengine.v1.RecommendResponse.RecommendationResult.Builder,
            com.google.cloud.discoveryengine.v1.RecommendResponse.RecommendationResultOrBuilder>
        resultsBuilder_;

    /**
     *
     *
     * <pre>
     * A list of recommended Documents. The order represents the ranking (from the
     * most relevant Document to the least).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.RecommendResponse.RecommendationResult results = 1;
     * </code>
     */
    public java.util.List<
            com.google.cloud.discoveryengine.v1.RecommendResponse.RecommendationResult>
        getResultsList() {
      if (resultsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(results_);
      } else {
        return resultsBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * A list of recommended Documents. The order represents the ranking (from the
     * most relevant Document to the least).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.RecommendResponse.RecommendationResult results = 1;
     * </code>
     */
    public int getResultsCount() {
      if (resultsBuilder_ == null) {
        return results_.size();
      } else {
        return resultsBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * A list of recommended Documents. The order represents the ranking (from the
     * most relevant Document to the least).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.RecommendResponse.RecommendationResult results = 1;
     * </code>
     */
    public com.google.cloud.discoveryengine.v1.RecommendResponse.RecommendationResult getResults(
        int index) {
      if (resultsBuilder_ == null) {
        return results_.get(index);
      } else {
        return resultsBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * A list of recommended Documents. The order represents the ranking (from the
     * most relevant Document to the least).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.RecommendResponse.RecommendationResult results = 1;
     * </code>
     */
    public Builder setResults(
        int index,
        com.google.cloud.discoveryengine.v1.RecommendResponse.RecommendationResult value) {
      if (resultsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureResultsIsMutable();
        results_.set(index, value);
        onChanged();
      } else {
        resultsBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of recommended Documents. The order represents the ranking (from the
     * most relevant Document to the least).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.RecommendResponse.RecommendationResult results = 1;
     * </code>
     */
    public Builder setResults(
        int index,
        com.google.cloud.discoveryengine.v1.RecommendResponse.RecommendationResult.Builder
            builderForValue) {
      if (resultsBuilder_ == null) {
        ensureResultsIsMutable();
        results_.set(index, builderForValue.build());
        onChanged();
      } else {
        resultsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of recommended Documents. The order represents the ranking (from the
     * most relevant Document to the least).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.RecommendResponse.RecommendationResult results = 1;
     * </code>
     */
    public Builder addResults(
        com.google.cloud.discoveryengine.v1.RecommendResponse.RecommendationResult value) {
      if (resultsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureResultsIsMutable();
        results_.add(value);
        onChanged();
      } else {
        resultsBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of recommended Documents. The order represents the ranking (from the
     * most relevant Document to the least).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.RecommendResponse.RecommendationResult results = 1;
     * </code>
     */
    public Builder addResults(
        int index,
        com.google.cloud.discoveryengine.v1.RecommendResponse.RecommendationResult value) {
      if (resultsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureResultsIsMutable();
        results_.add(index, value);
        onChanged();
      } else {
        resultsBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of recommended Documents. The order represents the ranking (from the
     * most relevant Document to the least).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.RecommendResponse.RecommendationResult results = 1;
     * </code>
     */
    public Builder addResults(
        com.google.cloud.discoveryengine.v1.RecommendResponse.RecommendationResult.Builder
            builderForValue) {
      if (resultsBuilder_ == null) {
        ensureResultsIsMutable();
        results_.add(builderForValue.build());
        onChanged();
      } else {
        resultsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of recommended Documents. The order represents the ranking (from the
     * most relevant Document to the least).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.RecommendResponse.RecommendationResult results = 1;
     * </code>
     */
    public Builder addResults(
        int index,
        com.google.cloud.discoveryengine.v1.RecommendResponse.RecommendationResult.Builder
            builderForValue) {
      if (resultsBuilder_ == null) {
        ensureResultsIsMutable();
        results_.add(index, builderForValue.build());
        onChanged();
      } else {
        resultsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of recommended Documents. The order represents the ranking (from the
     * most relevant Document to the least).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.RecommendResponse.RecommendationResult results = 1;
     * </code>
     */
    public Builder addAllResults(
        java.lang.Iterable<
                ? extends
                    com.google.cloud.discoveryengine.v1.RecommendResponse.RecommendationResult>
            values) {
      if (resultsBuilder_ == null) {
        ensureResultsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, results_);
        onChanged();
      } else {
        resultsBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of recommended Documents. The order represents the ranking (from the
     * most relevant Document to the least).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.RecommendResponse.RecommendationResult results = 1;
     * </code>
     */
    public Builder clearResults() {
      if (resultsBuilder_ == null) {
        results_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        resultsBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of recommended Documents. The order represents the ranking (from the
     * most relevant Document to the least).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.RecommendResponse.RecommendationResult results = 1;
     * </code>
     */
    public Builder removeResults(int index) {
      if (resultsBuilder_ == null) {
        ensureResultsIsMutable();
        results_.remove(index);
        onChanged();
      } else {
        resultsBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of recommended Documents. The order represents the ranking (from the
     * most relevant Document to the least).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.RecommendResponse.RecommendationResult results = 1;
     * </code>
     */
    public com.google.cloud.discoveryengine.v1.RecommendResponse.RecommendationResult.Builder
        getResultsBuilder(int index) {
      return getResultsFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * A list of recommended Documents. The order represents the ranking (from the
     * most relevant Document to the least).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.RecommendResponse.RecommendationResult results = 1;
     * </code>
     */
    public com.google.cloud.discoveryengine.v1.RecommendResponse.RecommendationResultOrBuilder
        getResultsOrBuilder(int index) {
      if (resultsBuilder_ == null) {
        return results_.get(index);
      } else {
        return resultsBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * A list of recommended Documents. The order represents the ranking (from the
     * most relevant Document to the least).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.RecommendResponse.RecommendationResult results = 1;
     * </code>
     */
    public java.util.List<
            ? extends
                com.google.cloud.discoveryengine.v1.RecommendResponse.RecommendationResultOrBuilder>
        getResultsOrBuilderList() {
      if (resultsBuilder_ != null) {
        return resultsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(results_);
      }
    }

    /**
     *
     *
     * <pre>
     * A list of recommended Documents. The order represents the ranking (from the
     * most relevant Document to the least).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.RecommendResponse.RecommendationResult results = 1;
     * </code>
     */
    public com.google.cloud.discoveryengine.v1.RecommendResponse.RecommendationResult.Builder
        addResultsBuilder() {
      return getResultsFieldBuilder()
          .addBuilder(
              com.google.cloud.discoveryengine.v1.RecommendResponse.RecommendationResult
                  .getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * A list of recommended Documents. The order represents the ranking (from the
     * most relevant Document to the least).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.RecommendResponse.RecommendationResult results = 1;
     * </code>
     */
    public com.google.cloud.discoveryengine.v1.RecommendResponse.RecommendationResult.Builder
        addResultsBuilder(int index) {
      return getResultsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.discoveryengine.v1.RecommendResponse.RecommendationResult
                  .getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * A list of recommended Documents. The order represents the ranking (from the
     * most relevant Document to the least).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.RecommendResponse.RecommendationResult results = 1;
     * </code>
     */
    public java.util.List<
            com.google.cloud.discoveryengine.v1.RecommendResponse.RecommendationResult.Builder>
        getResultsBuilderList() {
      return getResultsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.discoveryengine.v1.RecommendResponse.RecommendationResult,
            com.google.cloud.discoveryengine.v1.RecommendResponse.RecommendationResult.Builder,
            com.google.cloud.discoveryengine.v1.RecommendResponse.RecommendationResultOrBuilder>
        getResultsFieldBuilder() {
      if (resultsBuilder_ == null) {
        resultsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.discoveryengine.v1.RecommendResponse.RecommendationResult,
                com.google.cloud.discoveryengine.v1.RecommendResponse.RecommendationResult.Builder,
                com.google.cloud.discoveryengine.v1.RecommendResponse
                    .RecommendationResultOrBuilder>(
                results_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        results_ = null;
      }
      return resultsBuilder_;
    }

    private java.lang.Object attributionToken_ = "";

    /**
     *
     *
     * <pre>
     * A unique attribution token. This should be included in the
     * [UserEvent][google.cloud.discoveryengine.v1.UserEvent] logs resulting from
     * this recommendation, which enables accurate attribution of recommendation
     * model performance.
     * </pre>
     *
     * <code>string attribution_token = 2;</code>
     *
     * @return The attributionToken.
     */
    public java.lang.String getAttributionToken() {
      java.lang.Object ref = attributionToken_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        attributionToken_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * A unique attribution token. This should be included in the
     * [UserEvent][google.cloud.discoveryengine.v1.UserEvent] logs resulting from
     * this recommendation, which enables accurate attribution of recommendation
     * model performance.
     * </pre>
     *
     * <code>string attribution_token = 2;</code>
     *
     * @return The bytes for attributionToken.
     */
    public com.google.protobuf.ByteString getAttributionTokenBytes() {
      java.lang.Object ref = attributionToken_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        attributionToken_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * A unique attribution token. This should be included in the
     * [UserEvent][google.cloud.discoveryengine.v1.UserEvent] logs resulting from
     * this recommendation, which enables accurate attribution of recommendation
     * model performance.
     * </pre>
     *
     * <code>string attribution_token = 2;</code>
     *
     * @param value The attributionToken to set.
     * @return This builder for chaining.
     */
    public Builder setAttributionToken(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      attributionToken_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A unique attribution token. This should be included in the
     * [UserEvent][google.cloud.discoveryengine.v1.UserEvent] logs resulting from
     * this recommendation, which enables accurate attribution of recommendation
     * model performance.
     * </pre>
     *
     * <code>string attribution_token = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAttributionToken() {
      attributionToken_ = getDefaultInstance().getAttributionToken();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A unique attribution token. This should be included in the
     * [UserEvent][google.cloud.discoveryengine.v1.UserEvent] logs resulting from
     * this recommendation, which enables accurate attribution of recommendation
     * model performance.
     * </pre>
     *
     * <code>string attribution_token = 2;</code>
     *
     * @param value The bytes for attributionToken to set.
     * @return This builder for chaining.
     */
    public Builder setAttributionTokenBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      attributionToken_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList missingIds_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureMissingIdsIsMutable() {
      if (!missingIds_.isModifiable()) {
        missingIds_ = new com.google.protobuf.LazyStringArrayList(missingIds_);
      }
      bitField0_ |= 0x00000004;
    }

    /**
     *
     *
     * <pre>
     * IDs of documents in the request that were missing from the default Branch
     * associated with the requested ServingConfig.
     * </pre>
     *
     * <code>repeated string missing_ids = 3;</code>
     *
     * @return A list containing the missingIds.
     */
    public com.google.protobuf.ProtocolStringList getMissingIdsList() {
      missingIds_.makeImmutable();
      return missingIds_;
    }

    /**
     *
     *
     * <pre>
     * IDs of documents in the request that were missing from the default Branch
     * associated with the requested ServingConfig.
     * </pre>
     *
     * <code>repeated string missing_ids = 3;</code>
     *
     * @return The count of missingIds.
     */
    public int getMissingIdsCount() {
      return missingIds_.size();
    }

    /**
     *
     *
     * <pre>
     * IDs of documents in the request that were missing from the default Branch
     * associated with the requested ServingConfig.
     * </pre>
     *
     * <code>repeated string missing_ids = 3;</code>
     *
     * @param index The index of the element to return.
     * @return The missingIds at the given index.
     */
    public java.lang.String getMissingIds(int index) {
      return missingIds_.get(index);
    }

    /**
     *
     *
     * <pre>
     * IDs of documents in the request that were missing from the default Branch
     * associated with the requested ServingConfig.
     * </pre>
     *
     * <code>repeated string missing_ids = 3;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the missingIds at the given index.
     */
    public com.google.protobuf.ByteString getMissingIdsBytes(int index) {
      return missingIds_.getByteString(index);
    }

    /**
     *
     *
     * <pre>
     * IDs of documents in the request that were missing from the default Branch
     * associated with the requested ServingConfig.
     * </pre>
     *
     * <code>repeated string missing_ids = 3;</code>
     *
     * @param index The index to set the value at.
     * @param value The missingIds to set.
     * @return This builder for chaining.
     */
    public Builder setMissingIds(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureMissingIdsIsMutable();
      missingIds_.set(index, value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * IDs of documents in the request that were missing from the default Branch
     * associated with the requested ServingConfig.
     * </pre>
     *
     * <code>repeated string missing_ids = 3;</code>
     *
     * @param value The missingIds to add.
     * @return This builder for chaining.
     */
    public Builder addMissingIds(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureMissingIdsIsMutable();
      missingIds_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * IDs of documents in the request that were missing from the default Branch
     * associated with the requested ServingConfig.
     * </pre>
     *
     * <code>repeated string missing_ids = 3;</code>
     *
     * @param values The missingIds to add.
     * @return This builder for chaining.
     */
    public Builder addAllMissingIds(java.lang.Iterable<java.lang.String> values) {
      ensureMissingIdsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, missingIds_);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * IDs of documents in the request that were missing from the default Branch
     * associated with the requested ServingConfig.
     * </pre>
     *
     * <code>repeated string missing_ids = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMissingIds() {
      missingIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000004);
      ;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * IDs of documents in the request that were missing from the default Branch
     * associated with the requested ServingConfig.
     * </pre>
     *
     * <code>repeated string missing_ids = 3;</code>
     *
     * @param value The bytes of the missingIds to add.
     * @return This builder for chaining.
     */
    public Builder addMissingIdsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureMissingIdsIsMutable();
      missingIds_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private boolean validateOnly_;

    /**
     *
     *
     * <pre>
     * True if
     * [RecommendRequest.validate_only][google.cloud.discoveryengine.v1.RecommendRequest.validate_only]
     * was set.
     * </pre>
     *
     * <code>bool validate_only = 4;</code>
     *
     * @return The validateOnly.
     */
    @java.lang.Override
    public boolean getValidateOnly() {
      return validateOnly_;
    }

    /**
     *
     *
     * <pre>
     * True if
     * [RecommendRequest.validate_only][google.cloud.discoveryengine.v1.RecommendRequest.validate_only]
     * was set.
     * </pre>
     *
     * <code>bool validate_only = 4;</code>
     *
     * @param value The validateOnly to set.
     * @return This builder for chaining.
     */
    public Builder setValidateOnly(boolean value) {

      validateOnly_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * True if
     * [RecommendRequest.validate_only][google.cloud.discoveryengine.v1.RecommendRequest.validate_only]
     * was set.
     * </pre>
     *
     * <code>bool validate_only = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearValidateOnly() {
      bitField0_ = (bitField0_ & ~0x00000008);
      validateOnly_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1.RecommendResponse)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1.RecommendResponse)
  private static final com.google.cloud.discoveryengine.v1.RecommendResponse DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.discoveryengine.v1.RecommendResponse();
  }

  public static com.google.cloud.discoveryengine.v1.RecommendResponse getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<RecommendResponse> PARSER =
      new com.google.protobuf.AbstractParser<RecommendResponse>() {
        @java.lang.Override
        public RecommendResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<RecommendResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<RecommendResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.RecommendResponse getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
