/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/discoveryengine/v1/site_search_engine_service.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.discoveryengine.v1;

/**
 *
 *
 * <pre>
 * Metadata related to the progress of the
 * [SiteSearchEngineService.RecrawlUris][google.cloud.discoveryengine.v1.SiteSearchEngineService.RecrawlUris]
 * operation. This will be returned by the google.longrunning.Operation.metadata
 * field.
 * </pre>
 *
 * Protobuf type {@code google.cloud.discoveryengine.v1.RecrawlUrisMetadata}
 */
public final class RecrawlUrisMetadata extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1.RecrawlUrisMetadata)
    RecrawlUrisMetadataOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use RecrawlUrisMetadata.newBuilder() to construct.
  private RecrawlUrisMetadata(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private RecrawlUrisMetadata() {
    invalidUris3_ = com.google.protobuf.LazyStringArrayList.emptyList();
    noindexUris11_ = com.google.protobuf.LazyStringArrayList.emptyList();
    urisNotMatchingTargetSites9_ = com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new RecrawlUrisMetadata();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.discoveryengine.v1.SiteSearchEngineServiceProto
        .internal_static_google_cloud_discoveryengine_v1_RecrawlUrisMetadata_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.discoveryengine.v1.SiteSearchEngineServiceProto
        .internal_static_google_cloud_discoveryengine_v1_RecrawlUrisMetadata_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.discoveryengine.v1.RecrawlUrisMetadata.class,
            com.google.cloud.discoveryengine.v1.RecrawlUrisMetadata.Builder.class);
  }

  private int bitField0_;
  public static final int CREATE_TIME_FIELD_NUMBER = 1;
  private com.google.protobuf.Timestamp createTime_;

  /**
   *
   *
   * <pre>
   * Operation create time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 1;</code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Operation create time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 1;</code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  /**
   *
   *
   * <pre>
   * Operation create time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 1;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 2;
  private com.google.protobuf.Timestamp updateTime_;

  /**
   *
   *
   * <pre>
   * Operation last update time. If the operation is done, this is also the
   * finish time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 2;</code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Operation last update time. If the operation is done, this is also the
   * finish time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 2;</code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  /**
   *
   *
   * <pre>
   * Operation last update time. If the operation is done, this is also the
   * finish time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 2;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int INVALID_URIS_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList invalidUris3_ =
      com.google.protobuf.LazyStringArrayList.emptyList();

  // An alternative name is used for field "invalid_uris" because:
  //     both repeated field "invalid_uris" and singular field "invalid_uris_count" generate the
  // method "getInvalidUrisCount()"
  /**
   *
   *
   * <pre>
   * Unique URIs in the request that have invalid format. Sample limited to
   * 1000.
   * </pre>
   *
   * <code>repeated string invalid_uris = 3;</code>
   *
   * @return A list containing the invalidUris.
   */
  public com.google.protobuf.ProtocolStringList getInvalidUris3List() {
    return invalidUris3_;
  }

  /**
   *
   *
   * <pre>
   * Unique URIs in the request that have invalid format. Sample limited to
   * 1000.
   * </pre>
   *
   * <code>repeated string invalid_uris = 3;</code>
   *
   * @return The count of invalidUris.
   */
  public int getInvalidUris3Count() {
    return invalidUris3_.size();
  }

  /**
   *
   *
   * <pre>
   * Unique URIs in the request that have invalid format. Sample limited to
   * 1000.
   * </pre>
   *
   * <code>repeated string invalid_uris = 3;</code>
   *
   * @param index The index of the element to return.
   * @return The invalidUris at the given index.
   */
  public java.lang.String getInvalidUris3(int index) {
    return invalidUris3_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Unique URIs in the request that have invalid format. Sample limited to
   * 1000.
   * </pre>
   *
   * <code>repeated string invalid_uris = 3;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the invalidUris at the given index.
   */
  public com.google.protobuf.ByteString getInvalidUris3Bytes(int index) {
    return invalidUris3_.getByteString(index);
  }

  public static final int INVALID_URIS_COUNT_FIELD_NUMBER = 8;
  private int invalidUrisCount8_ = 0;

  // An alternative name is used for field "invalid_uris_count" because:
  //     both repeated field "invalid_uris" and singular field "invalid_uris_count" generate the
  // method "getInvalidUrisCount()"
  /**
   *
   *
   * <pre>
   * Total number of unique URIs in the request that have invalid format.
   * </pre>
   *
   * <code>int32 invalid_uris_count = 8;</code>
   *
   * @return The invalidUrisCount.
   */
  @java.lang.Override
  public int getInvalidUrisCount8() {
    return invalidUrisCount8_;
  }

  public static final int NOINDEX_URIS_FIELD_NUMBER = 11;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList noindexUris11_ =
      com.google.protobuf.LazyStringArrayList.emptyList();

  // An alternative name is used for field "noindex_uris" because:
  //     both repeated field "noindex_uris" and singular field "noindex_uris_count" generate the
  // method "getNoindexUrisCount()"
  /**
   *
   *
   * <pre>
   * URIs that have no index meta tag. Sample limited to 1000.
   * </pre>
   *
   * <code>repeated string noindex_uris = 11;</code>
   *
   * @return A list containing the noindexUris.
   */
  public com.google.protobuf.ProtocolStringList getNoindexUris11List() {
    return noindexUris11_;
  }

  /**
   *
   *
   * <pre>
   * URIs that have no index meta tag. Sample limited to 1000.
   * </pre>
   *
   * <code>repeated string noindex_uris = 11;</code>
   *
   * @return The count of noindexUris.
   */
  public int getNoindexUris11Count() {
    return noindexUris11_.size();
  }

  /**
   *
   *
   * <pre>
   * URIs that have no index meta tag. Sample limited to 1000.
   * </pre>
   *
   * <code>repeated string noindex_uris = 11;</code>
   *
   * @param index The index of the element to return.
   * @return The noindexUris at the given index.
   */
  public java.lang.String getNoindexUris11(int index) {
    return noindexUris11_.get(index);
  }

  /**
   *
   *
   * <pre>
   * URIs that have no index meta tag. Sample limited to 1000.
   * </pre>
   *
   * <code>repeated string noindex_uris = 11;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the noindexUris at the given index.
   */
  public com.google.protobuf.ByteString getNoindexUris11Bytes(int index) {
    return noindexUris11_.getByteString(index);
  }

  public static final int NOINDEX_URIS_COUNT_FIELD_NUMBER = 12;
  private int noindexUrisCount12_ = 0;

  // An alternative name is used for field "noindex_uris_count" because:
  //     both repeated field "noindex_uris" and singular field "noindex_uris_count" generate the
  // method "getNoindexUrisCount()"
  /**
   *
   *
   * <pre>
   * Total number of URIs that have no index meta tag.
   * </pre>
   *
   * <code>int32 noindex_uris_count = 12;</code>
   *
   * @return The noindexUrisCount.
   */
  @java.lang.Override
  public int getNoindexUrisCount12() {
    return noindexUrisCount12_;
  }

  public static final int URIS_NOT_MATCHING_TARGET_SITES_FIELD_NUMBER = 9;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList urisNotMatchingTargetSites9_ =
      com.google.protobuf.LazyStringArrayList.emptyList();

  // An alternative name is used for field "uris_not_matching_target_sites" because:
  //     both repeated field "uris_not_matching_target_sites" and singular field
  // "uris_not_matching_target_sites_count" generate the method
  // "getUrisNotMatchingTargetSitesCount()"
  /**
   *
   *
   * <pre>
   * Unique URIs in the request that don't match any TargetSite in the
   * DataStore, only match TargetSites that haven't been fully indexed, or match
   * a TargetSite with type EXCLUDE. Sample limited to 1000.
   * </pre>
   *
   * <code>repeated string uris_not_matching_target_sites = 9;</code>
   *
   * @return A list containing the urisNotMatchingTargetSites.
   */
  public com.google.protobuf.ProtocolStringList getUrisNotMatchingTargetSites9List() {
    return urisNotMatchingTargetSites9_;
  }

  /**
   *
   *
   * <pre>
   * Unique URIs in the request that don't match any TargetSite in the
   * DataStore, only match TargetSites that haven't been fully indexed, or match
   * a TargetSite with type EXCLUDE. Sample limited to 1000.
   * </pre>
   *
   * <code>repeated string uris_not_matching_target_sites = 9;</code>
   *
   * @return The count of urisNotMatchingTargetSites.
   */
  public int getUrisNotMatchingTargetSites9Count() {
    return urisNotMatchingTargetSites9_.size();
  }

  /**
   *
   *
   * <pre>
   * Unique URIs in the request that don't match any TargetSite in the
   * DataStore, only match TargetSites that haven't been fully indexed, or match
   * a TargetSite with type EXCLUDE. Sample limited to 1000.
   * </pre>
   *
   * <code>repeated string uris_not_matching_target_sites = 9;</code>
   *
   * @param index The index of the element to return.
   * @return The urisNotMatchingTargetSites at the given index.
   */
  public java.lang.String getUrisNotMatchingTargetSites9(int index) {
    return urisNotMatchingTargetSites9_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Unique URIs in the request that don't match any TargetSite in the
   * DataStore, only match TargetSites that haven't been fully indexed, or match
   * a TargetSite with type EXCLUDE. Sample limited to 1000.
   * </pre>
   *
   * <code>repeated string uris_not_matching_target_sites = 9;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the urisNotMatchingTargetSites at the given index.
   */
  public com.google.protobuf.ByteString getUrisNotMatchingTargetSites9Bytes(int index) {
    return urisNotMatchingTargetSites9_.getByteString(index);
  }

  public static final int URIS_NOT_MATCHING_TARGET_SITES_COUNT_FIELD_NUMBER = 10;
  private int urisNotMatchingTargetSitesCount10_ = 0;

  // An alternative name is used for field "uris_not_matching_target_sites_count" because:
  //     both repeated field "uris_not_matching_target_sites" and singular field
  // "uris_not_matching_target_sites_count" generate the method
  // "getUrisNotMatchingTargetSitesCount()"
  /**
   *
   *
   * <pre>
   * Total number of URIs that don't match any TargetSites.
   * </pre>
   *
   * <code>int32 uris_not_matching_target_sites_count = 10;</code>
   *
   * @return The urisNotMatchingTargetSitesCount.
   */
  @java.lang.Override
  public int getUrisNotMatchingTargetSitesCount10() {
    return urisNotMatchingTargetSitesCount10_;
  }

  public static final int VALID_URIS_COUNT_FIELD_NUMBER = 4;
  private int validUrisCount_ = 0;

  /**
   *
   *
   * <pre>
   * Total number of unique URIs in the request that are not in invalid_uris.
   * </pre>
   *
   * <code>int32 valid_uris_count = 4;</code>
   *
   * @return The validUrisCount.
   */
  @java.lang.Override
  public int getValidUrisCount() {
    return validUrisCount_;
  }

  public static final int SUCCESS_COUNT_FIELD_NUMBER = 5;
  private int successCount_ = 0;

  /**
   *
   *
   * <pre>
   * Total number of URIs that have been crawled so far.
   * </pre>
   *
   * <code>int32 success_count = 5;</code>
   *
   * @return The successCount.
   */
  @java.lang.Override
  public int getSuccessCount() {
    return successCount_;
  }

  public static final int PENDING_COUNT_FIELD_NUMBER = 6;
  private int pendingCount_ = 0;

  /**
   *
   *
   * <pre>
   * Total number of URIs that have yet to be crawled.
   * </pre>
   *
   * <code>int32 pending_count = 6;</code>
   *
   * @return The pendingCount.
   */
  @java.lang.Override
  public int getPendingCount() {
    return pendingCount_;
  }

  public static final int QUOTA_EXCEEDED_COUNT_FIELD_NUMBER = 7;
  private int quotaExceededCount_ = 0;

  /**
   *
   *
   * <pre>
   * Total number of URIs that were rejected due to insufficient indexing
   * resources.
   * </pre>
   *
   * <code>int32 quota_exceeded_count = 7;</code>
   *
   * @return The quotaExceededCount.
   */
  @java.lang.Override
  public int getQuotaExceededCount() {
    return quotaExceededCount_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(2, getUpdateTime());
    }
    for (int i = 0; i < invalidUris3_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, invalidUris3_.getRaw(i));
    }
    if (validUrisCount_ != 0) {
      output.writeInt32(4, validUrisCount_);
    }
    if (successCount_ != 0) {
      output.writeInt32(5, successCount_);
    }
    if (pendingCount_ != 0) {
      output.writeInt32(6, pendingCount_);
    }
    if (quotaExceededCount_ != 0) {
      output.writeInt32(7, quotaExceededCount_);
    }
    if (invalidUrisCount8_ != 0) {
      output.writeInt32(8, invalidUrisCount8_);
    }
    for (int i = 0; i < urisNotMatchingTargetSites9_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 9, urisNotMatchingTargetSites9_.getRaw(i));
    }
    if (urisNotMatchingTargetSitesCount10_ != 0) {
      output.writeInt32(10, urisNotMatchingTargetSitesCount10_);
    }
    for (int i = 0; i < noindexUris11_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 11, noindexUris11_.getRaw(i));
    }
    if (noindexUrisCount12_ != 0) {
      output.writeInt32(12, noindexUrisCount12_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getUpdateTime());
    }
    {
      int dataSize = 0;
      for (int i = 0; i < invalidUris3_.size(); i++) {
        dataSize += computeStringSizeNoTag(invalidUris3_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getInvalidUris3List().size();
    }
    if (validUrisCount_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(4, validUrisCount_);
    }
    if (successCount_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(5, successCount_);
    }
    if (pendingCount_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(6, pendingCount_);
    }
    if (quotaExceededCount_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(7, quotaExceededCount_);
    }
    if (invalidUrisCount8_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(8, invalidUrisCount8_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < urisNotMatchingTargetSites9_.size(); i++) {
        dataSize += computeStringSizeNoTag(urisNotMatchingTargetSites9_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getUrisNotMatchingTargetSites9List().size();
    }
    if (urisNotMatchingTargetSitesCount10_ != 0) {
      size +=
          com.google.protobuf.CodedOutputStream.computeInt32Size(
              10, urisNotMatchingTargetSitesCount10_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < noindexUris11_.size(); i++) {
        dataSize += computeStringSizeNoTag(noindexUris11_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getNoindexUris11List().size();
    }
    if (noindexUrisCount12_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(12, noindexUrisCount12_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.discoveryengine.v1.RecrawlUrisMetadata)) {
      return super.equals(obj);
    }
    com.google.cloud.discoveryengine.v1.RecrawlUrisMetadata other =
        (com.google.cloud.discoveryengine.v1.RecrawlUrisMetadata) obj;

    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (!getInvalidUris3List().equals(other.getInvalidUris3List())) return false;
    if (getInvalidUrisCount8() != other.getInvalidUrisCount8()) return false;
    if (!getNoindexUris11List().equals(other.getNoindexUris11List())) return false;
    if (getNoindexUrisCount12() != other.getNoindexUrisCount12()) return false;
    if (!getUrisNotMatchingTargetSites9List().equals(other.getUrisNotMatchingTargetSites9List()))
      return false;
    if (getUrisNotMatchingTargetSitesCount10() != other.getUrisNotMatchingTargetSitesCount10())
      return false;
    if (getValidUrisCount() != other.getValidUrisCount()) return false;
    if (getSuccessCount() != other.getSuccessCount()) return false;
    if (getPendingCount() != other.getPendingCount()) return false;
    if (getQuotaExceededCount() != other.getQuotaExceededCount()) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    if (getInvalidUris3Count() > 0) {
      hash = (37 * hash) + INVALID_URIS_FIELD_NUMBER;
      hash = (53 * hash) + getInvalidUris3List().hashCode();
    }
    hash = (37 * hash) + INVALID_URIS_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + getInvalidUrisCount8();
    if (getNoindexUris11Count() > 0) {
      hash = (37 * hash) + NOINDEX_URIS_FIELD_NUMBER;
      hash = (53 * hash) + getNoindexUris11List().hashCode();
    }
    hash = (37 * hash) + NOINDEX_URIS_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + getNoindexUrisCount12();
    if (getUrisNotMatchingTargetSites9Count() > 0) {
      hash = (37 * hash) + URIS_NOT_MATCHING_TARGET_SITES_FIELD_NUMBER;
      hash = (53 * hash) + getUrisNotMatchingTargetSites9List().hashCode();
    }
    hash = (37 * hash) + URIS_NOT_MATCHING_TARGET_SITES_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + getUrisNotMatchingTargetSitesCount10();
    hash = (37 * hash) + VALID_URIS_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + getValidUrisCount();
    hash = (37 * hash) + SUCCESS_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + getSuccessCount();
    hash = (37 * hash) + PENDING_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + getPendingCount();
    hash = (37 * hash) + QUOTA_EXCEEDED_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + getQuotaExceededCount();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.discoveryengine.v1.RecrawlUrisMetadata parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1.RecrawlUrisMetadata parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.RecrawlUrisMetadata parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1.RecrawlUrisMetadata parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.RecrawlUrisMetadata parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1.RecrawlUrisMetadata parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.RecrawlUrisMetadata parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1.RecrawlUrisMetadata parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.RecrawlUrisMetadata parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1.RecrawlUrisMetadata parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.RecrawlUrisMetadata parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1.RecrawlUrisMetadata parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.discoveryengine.v1.RecrawlUrisMetadata prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Metadata related to the progress of the
   * [SiteSearchEngineService.RecrawlUris][google.cloud.discoveryengine.v1.SiteSearchEngineService.RecrawlUris]
   * operation. This will be returned by the google.longrunning.Operation.metadata
   * field.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1.RecrawlUrisMetadata}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1.RecrawlUrisMetadata)
      com.google.cloud.discoveryengine.v1.RecrawlUrisMetadataOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1.SiteSearchEngineServiceProto
          .internal_static_google_cloud_discoveryengine_v1_RecrawlUrisMetadata_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1.SiteSearchEngineServiceProto
          .internal_static_google_cloud_discoveryengine_v1_RecrawlUrisMetadata_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1.RecrawlUrisMetadata.class,
              com.google.cloud.discoveryengine.v1.RecrawlUrisMetadata.Builder.class);
    }

    // Construct using com.google.cloud.discoveryengine.v1.RecrawlUrisMetadata.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getCreateTimeFieldBuilder();
        getUpdateTimeFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      invalidUris3_ = com.google.protobuf.LazyStringArrayList.emptyList();
      invalidUrisCount8_ = 0;
      noindexUris11_ = com.google.protobuf.LazyStringArrayList.emptyList();
      noindexUrisCount12_ = 0;
      urisNotMatchingTargetSites9_ = com.google.protobuf.LazyStringArrayList.emptyList();
      urisNotMatchingTargetSitesCount10_ = 0;
      validUrisCount_ = 0;
      successCount_ = 0;
      pendingCount_ = 0;
      quotaExceededCount_ = 0;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.discoveryengine.v1.SiteSearchEngineServiceProto
          .internal_static_google_cloud_discoveryengine_v1_RecrawlUrisMetadata_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.RecrawlUrisMetadata getDefaultInstanceForType() {
      return com.google.cloud.discoveryengine.v1.RecrawlUrisMetadata.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.RecrawlUrisMetadata build() {
      com.google.cloud.discoveryengine.v1.RecrawlUrisMetadata result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.RecrawlUrisMetadata buildPartial() {
      com.google.cloud.discoveryengine.v1.RecrawlUrisMetadata result =
          new com.google.cloud.discoveryengine.v1.RecrawlUrisMetadata(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.discoveryengine.v1.RecrawlUrisMetadata result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        invalidUris3_.makeImmutable();
        result.invalidUris3_ = invalidUris3_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.invalidUrisCount8_ = invalidUrisCount8_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        noindexUris11_.makeImmutable();
        result.noindexUris11_ = noindexUris11_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.noindexUrisCount12_ = noindexUrisCount12_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        urisNotMatchingTargetSites9_.makeImmutable();
        result.urisNotMatchingTargetSites9_ = urisNotMatchingTargetSites9_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.urisNotMatchingTargetSitesCount10_ = urisNotMatchingTargetSitesCount10_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.validUrisCount_ = validUrisCount_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.successCount_ = successCount_;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.pendingCount_ = pendingCount_;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.quotaExceededCount_ = quotaExceededCount_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.discoveryengine.v1.RecrawlUrisMetadata) {
        return mergeFrom((com.google.cloud.discoveryengine.v1.RecrawlUrisMetadata) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.discoveryengine.v1.RecrawlUrisMetadata other) {
      if (other == com.google.cloud.discoveryengine.v1.RecrawlUrisMetadata.getDefaultInstance())
        return this;
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      if (!other.invalidUris3_.isEmpty()) {
        if (invalidUris3_.isEmpty()) {
          invalidUris3_ = other.invalidUris3_;
          bitField0_ |= 0x00000004;
        } else {
          ensureInvalidUris3IsMutable();
          invalidUris3_.addAll(other.invalidUris3_);
        }
        onChanged();
      }
      if (other.getInvalidUrisCount8() != 0) {
        setInvalidUrisCount8(other.getInvalidUrisCount8());
      }
      if (!other.noindexUris11_.isEmpty()) {
        if (noindexUris11_.isEmpty()) {
          noindexUris11_ = other.noindexUris11_;
          bitField0_ |= 0x00000010;
        } else {
          ensureNoindexUris11IsMutable();
          noindexUris11_.addAll(other.noindexUris11_);
        }
        onChanged();
      }
      if (other.getNoindexUrisCount12() != 0) {
        setNoindexUrisCount12(other.getNoindexUrisCount12());
      }
      if (!other.urisNotMatchingTargetSites9_.isEmpty()) {
        if (urisNotMatchingTargetSites9_.isEmpty()) {
          urisNotMatchingTargetSites9_ = other.urisNotMatchingTargetSites9_;
          bitField0_ |= 0x00000040;
        } else {
          ensureUrisNotMatchingTargetSites9IsMutable();
          urisNotMatchingTargetSites9_.addAll(other.urisNotMatchingTargetSites9_);
        }
        onChanged();
      }
      if (other.getUrisNotMatchingTargetSitesCount10() != 0) {
        setUrisNotMatchingTargetSitesCount10(other.getUrisNotMatchingTargetSitesCount10());
      }
      if (other.getValidUrisCount() != 0) {
        setValidUrisCount(other.getValidUrisCount());
      }
      if (other.getSuccessCount() != 0) {
        setSuccessCount(other.getSuccessCount());
      }
      if (other.getPendingCount() != 0) {
        setPendingCount(other.getPendingCount());
      }
      if (other.getQuotaExceededCount() != 0) {
        setQuotaExceededCount(other.getQuotaExceededCount());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureInvalidUris3IsMutable();
                invalidUris3_.add(s);
                break;
              } // case 26
            case 32:
              {
                validUrisCount_ = input.readInt32();
                bitField0_ |= 0x00000100;
                break;
              } // case 32
            case 40:
              {
                successCount_ = input.readInt32();
                bitField0_ |= 0x00000200;
                break;
              } // case 40
            case 48:
              {
                pendingCount_ = input.readInt32();
                bitField0_ |= 0x00000400;
                break;
              } // case 48
            case 56:
              {
                quotaExceededCount_ = input.readInt32();
                bitField0_ |= 0x00000800;
                break;
              } // case 56
            case 64:
              {
                invalidUrisCount8_ = input.readInt32();
                bitField0_ |= 0x00000008;
                break;
              } // case 64
            case 74:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureUrisNotMatchingTargetSites9IsMutable();
                urisNotMatchingTargetSites9_.add(s);
                break;
              } // case 74
            case 80:
              {
                urisNotMatchingTargetSitesCount10_ = input.readInt32();
                bitField0_ |= 0x00000080;
                break;
              } // case 80
            case 90:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureNoindexUris11IsMutable();
                noindexUris11_.add(s);
                break;
              } // case 90
            case 96:
              {
                noindexUrisCount12_ = input.readInt32();
                bitField0_ |= 0x00000020;
                break;
              } // case 96
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;

    /**
     *
     *
     * <pre>
     * Operation create time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 1;</code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * Operation create time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 1;</code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Operation create time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 1;</code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Operation create time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 1;</code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Operation create time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 1;</code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Operation create time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 1;</code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000001);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Operation create time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 1;</code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Operation create time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 1;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * Operation create time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;

    /**
     *
     *
     * <pre>
     * Operation last update time. If the operation is done, this is also the
     * finish time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 2;</code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * Operation last update time. If the operation is done, this is also the
     * finish time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 2;</code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Operation last update time. If the operation is done, this is also the
     * finish time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 2;</code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Operation last update time. If the operation is done, this is also the
     * finish time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 2;</code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Operation last update time. If the operation is done, this is also the
     * finish time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 2;</code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      if (updateTime_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Operation last update time. If the operation is done, this is also the
     * finish time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 2;</code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000002);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Operation last update time. If the operation is done, this is also the
     * finish time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 2;</code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Operation last update time. If the operation is done, this is also the
     * finish time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 2;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * Operation last update time. If the operation is done, this is also the
     * finish time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private com.google.protobuf.LazyStringArrayList invalidUris3_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureInvalidUris3IsMutable() {
      if (!invalidUris3_.isModifiable()) {
        invalidUris3_ = new com.google.protobuf.LazyStringArrayList(invalidUris3_);
      }
      bitField0_ |= 0x00000004;
    }

    /**
     *
     *
     * <pre>
     * Unique URIs in the request that have invalid format. Sample limited to
     * 1000.
     * </pre>
     *
     * <code>repeated string invalid_uris = 3;</code>
     *
     * @return A list containing the invalidUris.
     */
    public com.google.protobuf.ProtocolStringList getInvalidUris3List() {
      invalidUris3_.makeImmutable();
      return invalidUris3_;
    }

    /**
     *
     *
     * <pre>
     * Unique URIs in the request that have invalid format. Sample limited to
     * 1000.
     * </pre>
     *
     * <code>repeated string invalid_uris = 3;</code>
     *
     * @return The count of invalidUris.
     */
    public int getInvalidUris3Count() {
      return invalidUris3_.size();
    }

    /**
     *
     *
     * <pre>
     * Unique URIs in the request that have invalid format. Sample limited to
     * 1000.
     * </pre>
     *
     * <code>repeated string invalid_uris = 3;</code>
     *
     * @param index The index of the element to return.
     * @return The invalidUris at the given index.
     */
    public java.lang.String getInvalidUris3(int index) {
      return invalidUris3_.get(index);
    }

    /**
     *
     *
     * <pre>
     * Unique URIs in the request that have invalid format. Sample limited to
     * 1000.
     * </pre>
     *
     * <code>repeated string invalid_uris = 3;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the invalidUris at the given index.
     */
    public com.google.protobuf.ByteString getInvalidUris3Bytes(int index) {
      return invalidUris3_.getByteString(index);
    }

    /**
     *
     *
     * <pre>
     * Unique URIs in the request that have invalid format. Sample limited to
     * 1000.
     * </pre>
     *
     * <code>repeated string invalid_uris = 3;</code>
     *
     * @param index The index to set the value at.
     * @param value The invalidUris to set.
     * @return This builder for chaining.
     */
    public Builder setInvalidUris3(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureInvalidUris3IsMutable();
      invalidUris3_.set(index, value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Unique URIs in the request that have invalid format. Sample limited to
     * 1000.
     * </pre>
     *
     * <code>repeated string invalid_uris = 3;</code>
     *
     * @param value The invalidUris to add.
     * @return This builder for chaining.
     */
    public Builder addInvalidUris3(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureInvalidUris3IsMutable();
      invalidUris3_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Unique URIs in the request that have invalid format. Sample limited to
     * 1000.
     * </pre>
     *
     * <code>repeated string invalid_uris = 3;</code>
     *
     * @param values The invalidUris to add.
     * @return This builder for chaining.
     */
    public Builder addAllInvalidUris3(java.lang.Iterable<java.lang.String> values) {
      ensureInvalidUris3IsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, invalidUris3_);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Unique URIs in the request that have invalid format. Sample limited to
     * 1000.
     * </pre>
     *
     * <code>repeated string invalid_uris = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInvalidUris3() {
      invalidUris3_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000004);
      ;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Unique URIs in the request that have invalid format. Sample limited to
     * 1000.
     * </pre>
     *
     * <code>repeated string invalid_uris = 3;</code>
     *
     * @param value The bytes of the invalidUris to add.
     * @return This builder for chaining.
     */
    public Builder addInvalidUris3Bytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureInvalidUris3IsMutable();
      invalidUris3_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private int invalidUrisCount8_;

    /**
     *
     *
     * <pre>
     * Total number of unique URIs in the request that have invalid format.
     * </pre>
     *
     * <code>int32 invalid_uris_count = 8;</code>
     *
     * @return The invalidUrisCount.
     */
    @java.lang.Override
    public int getInvalidUrisCount8() {
      return invalidUrisCount8_;
    }

    /**
     *
     *
     * <pre>
     * Total number of unique URIs in the request that have invalid format.
     * </pre>
     *
     * <code>int32 invalid_uris_count = 8;</code>
     *
     * @param value The invalidUrisCount to set.
     * @return This builder for chaining.
     */
    public Builder setInvalidUrisCount8(int value) {

      invalidUrisCount8_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Total number of unique URIs in the request that have invalid format.
     * </pre>
     *
     * <code>int32 invalid_uris_count = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInvalidUrisCount8() {
      bitField0_ = (bitField0_ & ~0x00000008);
      invalidUrisCount8_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList noindexUris11_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureNoindexUris11IsMutable() {
      if (!noindexUris11_.isModifiable()) {
        noindexUris11_ = new com.google.protobuf.LazyStringArrayList(noindexUris11_);
      }
      bitField0_ |= 0x00000010;
    }

    /**
     *
     *
     * <pre>
     * URIs that have no index meta tag. Sample limited to 1000.
     * </pre>
     *
     * <code>repeated string noindex_uris = 11;</code>
     *
     * @return A list containing the noindexUris.
     */
    public com.google.protobuf.ProtocolStringList getNoindexUris11List() {
      noindexUris11_.makeImmutable();
      return noindexUris11_;
    }

    /**
     *
     *
     * <pre>
     * URIs that have no index meta tag. Sample limited to 1000.
     * </pre>
     *
     * <code>repeated string noindex_uris = 11;</code>
     *
     * @return The count of noindexUris.
     */
    public int getNoindexUris11Count() {
      return noindexUris11_.size();
    }

    /**
     *
     *
     * <pre>
     * URIs that have no index meta tag. Sample limited to 1000.
     * </pre>
     *
     * <code>repeated string noindex_uris = 11;</code>
     *
     * @param index The index of the element to return.
     * @return The noindexUris at the given index.
     */
    public java.lang.String getNoindexUris11(int index) {
      return noindexUris11_.get(index);
    }

    /**
     *
     *
     * <pre>
     * URIs that have no index meta tag. Sample limited to 1000.
     * </pre>
     *
     * <code>repeated string noindex_uris = 11;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the noindexUris at the given index.
     */
    public com.google.protobuf.ByteString getNoindexUris11Bytes(int index) {
      return noindexUris11_.getByteString(index);
    }

    /**
     *
     *
     * <pre>
     * URIs that have no index meta tag. Sample limited to 1000.
     * </pre>
     *
     * <code>repeated string noindex_uris = 11;</code>
     *
     * @param index The index to set the value at.
     * @param value The noindexUris to set.
     * @return This builder for chaining.
     */
    public Builder setNoindexUris11(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureNoindexUris11IsMutable();
      noindexUris11_.set(index, value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * URIs that have no index meta tag. Sample limited to 1000.
     * </pre>
     *
     * <code>repeated string noindex_uris = 11;</code>
     *
     * @param value The noindexUris to add.
     * @return This builder for chaining.
     */
    public Builder addNoindexUris11(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureNoindexUris11IsMutable();
      noindexUris11_.add(value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * URIs that have no index meta tag. Sample limited to 1000.
     * </pre>
     *
     * <code>repeated string noindex_uris = 11;</code>
     *
     * @param values The noindexUris to add.
     * @return This builder for chaining.
     */
    public Builder addAllNoindexUris11(java.lang.Iterable<java.lang.String> values) {
      ensureNoindexUris11IsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, noindexUris11_);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * URIs that have no index meta tag. Sample limited to 1000.
     * </pre>
     *
     * <code>repeated string noindex_uris = 11;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNoindexUris11() {
      noindexUris11_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000010);
      ;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * URIs that have no index meta tag. Sample limited to 1000.
     * </pre>
     *
     * <code>repeated string noindex_uris = 11;</code>
     *
     * @param value The bytes of the noindexUris to add.
     * @return This builder for chaining.
     */
    public Builder addNoindexUris11Bytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureNoindexUris11IsMutable();
      noindexUris11_.add(value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private int noindexUrisCount12_;

    /**
     *
     *
     * <pre>
     * Total number of URIs that have no index meta tag.
     * </pre>
     *
     * <code>int32 noindex_uris_count = 12;</code>
     *
     * @return The noindexUrisCount.
     */
    @java.lang.Override
    public int getNoindexUrisCount12() {
      return noindexUrisCount12_;
    }

    /**
     *
     *
     * <pre>
     * Total number of URIs that have no index meta tag.
     * </pre>
     *
     * <code>int32 noindex_uris_count = 12;</code>
     *
     * @param value The noindexUrisCount to set.
     * @return This builder for chaining.
     */
    public Builder setNoindexUrisCount12(int value) {

      noindexUrisCount12_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Total number of URIs that have no index meta tag.
     * </pre>
     *
     * <code>int32 noindex_uris_count = 12;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNoindexUrisCount12() {
      bitField0_ = (bitField0_ & ~0x00000020);
      noindexUrisCount12_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList urisNotMatchingTargetSites9_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureUrisNotMatchingTargetSites9IsMutable() {
      if (!urisNotMatchingTargetSites9_.isModifiable()) {
        urisNotMatchingTargetSites9_ =
            new com.google.protobuf.LazyStringArrayList(urisNotMatchingTargetSites9_);
      }
      bitField0_ |= 0x00000040;
    }

    /**
     *
     *
     * <pre>
     * Unique URIs in the request that don't match any TargetSite in the
     * DataStore, only match TargetSites that haven't been fully indexed, or match
     * a TargetSite with type EXCLUDE. Sample limited to 1000.
     * </pre>
     *
     * <code>repeated string uris_not_matching_target_sites = 9;</code>
     *
     * @return A list containing the urisNotMatchingTargetSites.
     */
    public com.google.protobuf.ProtocolStringList getUrisNotMatchingTargetSites9List() {
      urisNotMatchingTargetSites9_.makeImmutable();
      return urisNotMatchingTargetSites9_;
    }

    /**
     *
     *
     * <pre>
     * Unique URIs in the request that don't match any TargetSite in the
     * DataStore, only match TargetSites that haven't been fully indexed, or match
     * a TargetSite with type EXCLUDE. Sample limited to 1000.
     * </pre>
     *
     * <code>repeated string uris_not_matching_target_sites = 9;</code>
     *
     * @return The count of urisNotMatchingTargetSites.
     */
    public int getUrisNotMatchingTargetSites9Count() {
      return urisNotMatchingTargetSites9_.size();
    }

    /**
     *
     *
     * <pre>
     * Unique URIs in the request that don't match any TargetSite in the
     * DataStore, only match TargetSites that haven't been fully indexed, or match
     * a TargetSite with type EXCLUDE. Sample limited to 1000.
     * </pre>
     *
     * <code>repeated string uris_not_matching_target_sites = 9;</code>
     *
     * @param index The index of the element to return.
     * @return The urisNotMatchingTargetSites at the given index.
     */
    public java.lang.String getUrisNotMatchingTargetSites9(int index) {
      return urisNotMatchingTargetSites9_.get(index);
    }

    /**
     *
     *
     * <pre>
     * Unique URIs in the request that don't match any TargetSite in the
     * DataStore, only match TargetSites that haven't been fully indexed, or match
     * a TargetSite with type EXCLUDE. Sample limited to 1000.
     * </pre>
     *
     * <code>repeated string uris_not_matching_target_sites = 9;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the urisNotMatchingTargetSites at the given index.
     */
    public com.google.protobuf.ByteString getUrisNotMatchingTargetSites9Bytes(int index) {
      return urisNotMatchingTargetSites9_.getByteString(index);
    }

    /**
     *
     *
     * <pre>
     * Unique URIs in the request that don't match any TargetSite in the
     * DataStore, only match TargetSites that haven't been fully indexed, or match
     * a TargetSite with type EXCLUDE. Sample limited to 1000.
     * </pre>
     *
     * <code>repeated string uris_not_matching_target_sites = 9;</code>
     *
     * @param index The index to set the value at.
     * @param value The urisNotMatchingTargetSites to set.
     * @return This builder for chaining.
     */
    public Builder setUrisNotMatchingTargetSites9(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureUrisNotMatchingTargetSites9IsMutable();
      urisNotMatchingTargetSites9_.set(index, value);
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Unique URIs in the request that don't match any TargetSite in the
     * DataStore, only match TargetSites that haven't been fully indexed, or match
     * a TargetSite with type EXCLUDE. Sample limited to 1000.
     * </pre>
     *
     * <code>repeated string uris_not_matching_target_sites = 9;</code>
     *
     * @param value The urisNotMatchingTargetSites to add.
     * @return This builder for chaining.
     */
    public Builder addUrisNotMatchingTargetSites9(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureUrisNotMatchingTargetSites9IsMutable();
      urisNotMatchingTargetSites9_.add(value);
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Unique URIs in the request that don't match any TargetSite in the
     * DataStore, only match TargetSites that haven't been fully indexed, or match
     * a TargetSite with type EXCLUDE. Sample limited to 1000.
     * </pre>
     *
     * <code>repeated string uris_not_matching_target_sites = 9;</code>
     *
     * @param values The urisNotMatchingTargetSites to add.
     * @return This builder for chaining.
     */
    public Builder addAllUrisNotMatchingTargetSites9(java.lang.Iterable<java.lang.String> values) {
      ensureUrisNotMatchingTargetSites9IsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, urisNotMatchingTargetSites9_);
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Unique URIs in the request that don't match any TargetSite in the
     * DataStore, only match TargetSites that haven't been fully indexed, or match
     * a TargetSite with type EXCLUDE. Sample limited to 1000.
     * </pre>
     *
     * <code>repeated string uris_not_matching_target_sites = 9;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUrisNotMatchingTargetSites9() {
      urisNotMatchingTargetSites9_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000040);
      ;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Unique URIs in the request that don't match any TargetSite in the
     * DataStore, only match TargetSites that haven't been fully indexed, or match
     * a TargetSite with type EXCLUDE. Sample limited to 1000.
     * </pre>
     *
     * <code>repeated string uris_not_matching_target_sites = 9;</code>
     *
     * @param value The bytes of the urisNotMatchingTargetSites to add.
     * @return This builder for chaining.
     */
    public Builder addUrisNotMatchingTargetSites9Bytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureUrisNotMatchingTargetSites9IsMutable();
      urisNotMatchingTargetSites9_.add(value);
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private int urisNotMatchingTargetSitesCount10_;

    /**
     *
     *
     * <pre>
     * Total number of URIs that don't match any TargetSites.
     * </pre>
     *
     * <code>int32 uris_not_matching_target_sites_count = 10;</code>
     *
     * @return The urisNotMatchingTargetSitesCount.
     */
    @java.lang.Override
    public int getUrisNotMatchingTargetSitesCount10() {
      return urisNotMatchingTargetSitesCount10_;
    }

    /**
     *
     *
     * <pre>
     * Total number of URIs that don't match any TargetSites.
     * </pre>
     *
     * <code>int32 uris_not_matching_target_sites_count = 10;</code>
     *
     * @param value The urisNotMatchingTargetSitesCount to set.
     * @return This builder for chaining.
     */
    public Builder setUrisNotMatchingTargetSitesCount10(int value) {

      urisNotMatchingTargetSitesCount10_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Total number of URIs that don't match any TargetSites.
     * </pre>
     *
     * <code>int32 uris_not_matching_target_sites_count = 10;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUrisNotMatchingTargetSitesCount10() {
      bitField0_ = (bitField0_ & ~0x00000080);
      urisNotMatchingTargetSitesCount10_ = 0;
      onChanged();
      return this;
    }

    private int validUrisCount_;

    /**
     *
     *
     * <pre>
     * Total number of unique URIs in the request that are not in invalid_uris.
     * </pre>
     *
     * <code>int32 valid_uris_count = 4;</code>
     *
     * @return The validUrisCount.
     */
    @java.lang.Override
    public int getValidUrisCount() {
      return validUrisCount_;
    }

    /**
     *
     *
     * <pre>
     * Total number of unique URIs in the request that are not in invalid_uris.
     * </pre>
     *
     * <code>int32 valid_uris_count = 4;</code>
     *
     * @param value The validUrisCount to set.
     * @return This builder for chaining.
     */
    public Builder setValidUrisCount(int value) {

      validUrisCount_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Total number of unique URIs in the request that are not in invalid_uris.
     * </pre>
     *
     * <code>int32 valid_uris_count = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearValidUrisCount() {
      bitField0_ = (bitField0_ & ~0x00000100);
      validUrisCount_ = 0;
      onChanged();
      return this;
    }

    private int successCount_;

    /**
     *
     *
     * <pre>
     * Total number of URIs that have been crawled so far.
     * </pre>
     *
     * <code>int32 success_count = 5;</code>
     *
     * @return The successCount.
     */
    @java.lang.Override
    public int getSuccessCount() {
      return successCount_;
    }

    /**
     *
     *
     * <pre>
     * Total number of URIs that have been crawled so far.
     * </pre>
     *
     * <code>int32 success_count = 5;</code>
     *
     * @param value The successCount to set.
     * @return This builder for chaining.
     */
    public Builder setSuccessCount(int value) {

      successCount_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Total number of URIs that have been crawled so far.
     * </pre>
     *
     * <code>int32 success_count = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSuccessCount() {
      bitField0_ = (bitField0_ & ~0x00000200);
      successCount_ = 0;
      onChanged();
      return this;
    }

    private int pendingCount_;

    /**
     *
     *
     * <pre>
     * Total number of URIs that have yet to be crawled.
     * </pre>
     *
     * <code>int32 pending_count = 6;</code>
     *
     * @return The pendingCount.
     */
    @java.lang.Override
    public int getPendingCount() {
      return pendingCount_;
    }

    /**
     *
     *
     * <pre>
     * Total number of URIs that have yet to be crawled.
     * </pre>
     *
     * <code>int32 pending_count = 6;</code>
     *
     * @param value The pendingCount to set.
     * @return This builder for chaining.
     */
    public Builder setPendingCount(int value) {

      pendingCount_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Total number of URIs that have yet to be crawled.
     * </pre>
     *
     * <code>int32 pending_count = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPendingCount() {
      bitField0_ = (bitField0_ & ~0x00000400);
      pendingCount_ = 0;
      onChanged();
      return this;
    }

    private int quotaExceededCount_;

    /**
     *
     *
     * <pre>
     * Total number of URIs that were rejected due to insufficient indexing
     * resources.
     * </pre>
     *
     * <code>int32 quota_exceeded_count = 7;</code>
     *
     * @return The quotaExceededCount.
     */
    @java.lang.Override
    public int getQuotaExceededCount() {
      return quotaExceededCount_;
    }

    /**
     *
     *
     * <pre>
     * Total number of URIs that were rejected due to insufficient indexing
     * resources.
     * </pre>
     *
     * <code>int32 quota_exceeded_count = 7;</code>
     *
     * @param value The quotaExceededCount to set.
     * @return This builder for chaining.
     */
    public Builder setQuotaExceededCount(int value) {

      quotaExceededCount_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Total number of URIs that were rejected due to insufficient indexing
     * resources.
     * </pre>
     *
     * <code>int32 quota_exceeded_count = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearQuotaExceededCount() {
      bitField0_ = (bitField0_ & ~0x00000800);
      quotaExceededCount_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1.RecrawlUrisMetadata)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1.RecrawlUrisMetadata)
  private static final com.google.cloud.discoveryengine.v1.RecrawlUrisMetadata DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.discoveryengine.v1.RecrawlUrisMetadata();
  }

  public static com.google.cloud.discoveryengine.v1.RecrawlUrisMetadata getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<RecrawlUrisMetadata> PARSER =
      new com.google.protobuf.AbstractParser<RecrawlUrisMetadata>() {
        @java.lang.Override
        public RecrawlUrisMetadata parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<RecrawlUrisMetadata> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<RecrawlUrisMetadata> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.RecrawlUrisMetadata getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
