/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/discoveryengine/v1/search_tuning_service.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.discoveryengine.v1;

/**
 *
 *
 * <pre>
 * Request message for
 * [SearchTuningService.TrainCustomModel][google.cloud.discoveryengine.v1.SearchTuningService.TrainCustomModel]
 * method.
 * </pre>
 *
 * Protobuf type {@code google.cloud.discoveryengine.v1.TrainCustomModelRequest}
 */
public final class TrainCustomModelRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1.TrainCustomModelRequest)
    TrainCustomModelRequestOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use TrainCustomModelRequest.newBuilder() to construct.
  private TrainCustomModelRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private TrainCustomModelRequest() {
    dataStore_ = "";
    modelType_ = "";
    modelId_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new TrainCustomModelRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.discoveryengine.v1.SearchTuningServiceProto
        .internal_static_google_cloud_discoveryengine_v1_TrainCustomModelRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.discoveryengine.v1.SearchTuningServiceProto
        .internal_static_google_cloud_discoveryengine_v1_TrainCustomModelRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.discoveryengine.v1.TrainCustomModelRequest.class,
            com.google.cloud.discoveryengine.v1.TrainCustomModelRequest.Builder.class);
  }

  public interface GcsTrainingInputOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1.TrainCustomModelRequest.GcsTrainingInput)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The Cloud Storage corpus data which could be associated in train data.
     * The data path format is `gs://&lt;bucket_to_data&gt;/&lt;jsonl_file_name&gt;`.
     * A newline delimited jsonl/ndjson file.
     *
     * For search-tuning model, each line should have the _id, title
     * and text. Example:
     * `{"_id": "doc1", title: "relevant doc", "text": "relevant text"}`
     * </pre>
     *
     * <code>string corpus_data_path = 1;</code>
     *
     * @return The corpusDataPath.
     */
    java.lang.String getCorpusDataPath();

    /**
     *
     *
     * <pre>
     * The Cloud Storage corpus data which could be associated in train data.
     * The data path format is `gs://&lt;bucket_to_data&gt;/&lt;jsonl_file_name&gt;`.
     * A newline delimited jsonl/ndjson file.
     *
     * For search-tuning model, each line should have the _id, title
     * and text. Example:
     * `{"_id": "doc1", title: "relevant doc", "text": "relevant text"}`
     * </pre>
     *
     * <code>string corpus_data_path = 1;</code>
     *
     * @return The bytes for corpusDataPath.
     */
    com.google.protobuf.ByteString getCorpusDataPathBytes();

    /**
     *
     *
     * <pre>
     * The gcs query data which could be associated in train data.
     * The data path format is `gs://&lt;bucket_to_data&gt;/&lt;jsonl_file_name&gt;`.
     * A newline delimited jsonl/ndjson file.
     *
     * For search-tuning model, each line should have the _id
     * and text. Example: {"_id": "query1",  "text": "example query"}
     * </pre>
     *
     * <code>string query_data_path = 2;</code>
     *
     * @return The queryDataPath.
     */
    java.lang.String getQueryDataPath();

    /**
     *
     *
     * <pre>
     * The gcs query data which could be associated in train data.
     * The data path format is `gs://&lt;bucket_to_data&gt;/&lt;jsonl_file_name&gt;`.
     * A newline delimited jsonl/ndjson file.
     *
     * For search-tuning model, each line should have the _id
     * and text. Example: {"_id": "query1",  "text": "example query"}
     * </pre>
     *
     * <code>string query_data_path = 2;</code>
     *
     * @return The bytes for queryDataPath.
     */
    com.google.protobuf.ByteString getQueryDataPathBytes();

    /**
     *
     *
     * <pre>
     * Cloud Storage training data path whose format should be
     * `gs://&lt;bucket_to_data&gt;/&lt;tsv_file_name&gt;`. The file should be in tsv
     * format. Each line should have the doc_id and query_id and score (number).
     *
     * For search-tuning model, it should have the query-id corpus-id
     * score as tsv file header. The score should be a number in `[0, inf+)`.
     * The larger the number is, the more relevant the pair is. Example:
     *
     * * `query-id&#92;tcorpus-id&#92;tscore`
     * * `query1&#92;tdoc1&#92;t1`
     * </pre>
     *
     * <code>string train_data_path = 3;</code>
     *
     * @return The trainDataPath.
     */
    java.lang.String getTrainDataPath();

    /**
     *
     *
     * <pre>
     * Cloud Storage training data path whose format should be
     * `gs://&lt;bucket_to_data&gt;/&lt;tsv_file_name&gt;`. The file should be in tsv
     * format. Each line should have the doc_id and query_id and score (number).
     *
     * For search-tuning model, it should have the query-id corpus-id
     * score as tsv file header. The score should be a number in `[0, inf+)`.
     * The larger the number is, the more relevant the pair is. Example:
     *
     * * `query-id&#92;tcorpus-id&#92;tscore`
     * * `query1&#92;tdoc1&#92;t1`
     * </pre>
     *
     * <code>string train_data_path = 3;</code>
     *
     * @return The bytes for trainDataPath.
     */
    com.google.protobuf.ByteString getTrainDataPathBytes();

    /**
     *
     *
     * <pre>
     * Cloud Storage test data. Same format as train_data_path. If not provided,
     * a random 80/20 train/test split will be performed on train_data_path.
     * </pre>
     *
     * <code>string test_data_path = 4;</code>
     *
     * @return The testDataPath.
     */
    java.lang.String getTestDataPath();

    /**
     *
     *
     * <pre>
     * Cloud Storage test data. Same format as train_data_path. If not provided,
     * a random 80/20 train/test split will be performed on train_data_path.
     * </pre>
     *
     * <code>string test_data_path = 4;</code>
     *
     * @return The bytes for testDataPath.
     */
    com.google.protobuf.ByteString getTestDataPathBytes();
  }

  /**
   *
   *
   * <pre>
   * Cloud Storage training data input.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1.TrainCustomModelRequest.GcsTrainingInput}
   */
  public static final class GcsTrainingInput extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1.TrainCustomModelRequest.GcsTrainingInput)
      GcsTrainingInputOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use GcsTrainingInput.newBuilder() to construct.
    private GcsTrainingInput(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private GcsTrainingInput() {
      corpusDataPath_ = "";
      queryDataPath_ = "";
      trainDataPath_ = "";
      testDataPath_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new GcsTrainingInput();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1.SearchTuningServiceProto
          .internal_static_google_cloud_discoveryengine_v1_TrainCustomModelRequest_GcsTrainingInput_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1.SearchTuningServiceProto
          .internal_static_google_cloud_discoveryengine_v1_TrainCustomModelRequest_GcsTrainingInput_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1.TrainCustomModelRequest.GcsTrainingInput.class,
              com.google.cloud.discoveryengine.v1.TrainCustomModelRequest.GcsTrainingInput.Builder
                  .class);
    }

    public static final int CORPUS_DATA_PATH_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object corpusDataPath_ = "";

    /**
     *
     *
     * <pre>
     * The Cloud Storage corpus data which could be associated in train data.
     * The data path format is `gs://&lt;bucket_to_data&gt;/&lt;jsonl_file_name&gt;`.
     * A newline delimited jsonl/ndjson file.
     *
     * For search-tuning model, each line should have the _id, title
     * and text. Example:
     * `{"_id": "doc1", title: "relevant doc", "text": "relevant text"}`
     * </pre>
     *
     * <code>string corpus_data_path = 1;</code>
     *
     * @return The corpusDataPath.
     */
    @java.lang.Override
    public java.lang.String getCorpusDataPath() {
      java.lang.Object ref = corpusDataPath_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        corpusDataPath_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * The Cloud Storage corpus data which could be associated in train data.
     * The data path format is `gs://&lt;bucket_to_data&gt;/&lt;jsonl_file_name&gt;`.
     * A newline delimited jsonl/ndjson file.
     *
     * For search-tuning model, each line should have the _id, title
     * and text. Example:
     * `{"_id": "doc1", title: "relevant doc", "text": "relevant text"}`
     * </pre>
     *
     * <code>string corpus_data_path = 1;</code>
     *
     * @return The bytes for corpusDataPath.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getCorpusDataPathBytes() {
      java.lang.Object ref = corpusDataPath_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        corpusDataPath_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int QUERY_DATA_PATH_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object queryDataPath_ = "";

    /**
     *
     *
     * <pre>
     * The gcs query data which could be associated in train data.
     * The data path format is `gs://&lt;bucket_to_data&gt;/&lt;jsonl_file_name&gt;`.
     * A newline delimited jsonl/ndjson file.
     *
     * For search-tuning model, each line should have the _id
     * and text. Example: {"_id": "query1",  "text": "example query"}
     * </pre>
     *
     * <code>string query_data_path = 2;</code>
     *
     * @return The queryDataPath.
     */
    @java.lang.Override
    public java.lang.String getQueryDataPath() {
      java.lang.Object ref = queryDataPath_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        queryDataPath_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * The gcs query data which could be associated in train data.
     * The data path format is `gs://&lt;bucket_to_data&gt;/&lt;jsonl_file_name&gt;`.
     * A newline delimited jsonl/ndjson file.
     *
     * For search-tuning model, each line should have the _id
     * and text. Example: {"_id": "query1",  "text": "example query"}
     * </pre>
     *
     * <code>string query_data_path = 2;</code>
     *
     * @return The bytes for queryDataPath.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getQueryDataPathBytes() {
      java.lang.Object ref = queryDataPath_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        queryDataPath_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int TRAIN_DATA_PATH_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private volatile java.lang.Object trainDataPath_ = "";

    /**
     *
     *
     * <pre>
     * Cloud Storage training data path whose format should be
     * `gs://&lt;bucket_to_data&gt;/&lt;tsv_file_name&gt;`. The file should be in tsv
     * format. Each line should have the doc_id and query_id and score (number).
     *
     * For search-tuning model, it should have the query-id corpus-id
     * score as tsv file header. The score should be a number in `[0, inf+)`.
     * The larger the number is, the more relevant the pair is. Example:
     *
     * * `query-id&#92;tcorpus-id&#92;tscore`
     * * `query1&#92;tdoc1&#92;t1`
     * </pre>
     *
     * <code>string train_data_path = 3;</code>
     *
     * @return The trainDataPath.
     */
    @java.lang.Override
    public java.lang.String getTrainDataPath() {
      java.lang.Object ref = trainDataPath_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        trainDataPath_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Cloud Storage training data path whose format should be
     * `gs://&lt;bucket_to_data&gt;/&lt;tsv_file_name&gt;`. The file should be in tsv
     * format. Each line should have the doc_id and query_id and score (number).
     *
     * For search-tuning model, it should have the query-id corpus-id
     * score as tsv file header. The score should be a number in `[0, inf+)`.
     * The larger the number is, the more relevant the pair is. Example:
     *
     * * `query-id&#92;tcorpus-id&#92;tscore`
     * * `query1&#92;tdoc1&#92;t1`
     * </pre>
     *
     * <code>string train_data_path = 3;</code>
     *
     * @return The bytes for trainDataPath.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getTrainDataPathBytes() {
      java.lang.Object ref = trainDataPath_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        trainDataPath_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int TEST_DATA_PATH_FIELD_NUMBER = 4;

    @SuppressWarnings("serial")
    private volatile java.lang.Object testDataPath_ = "";

    /**
     *
     *
     * <pre>
     * Cloud Storage test data. Same format as train_data_path. If not provided,
     * a random 80/20 train/test split will be performed on train_data_path.
     * </pre>
     *
     * <code>string test_data_path = 4;</code>
     *
     * @return The testDataPath.
     */
    @java.lang.Override
    public java.lang.String getTestDataPath() {
      java.lang.Object ref = testDataPath_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        testDataPath_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Cloud Storage test data. Same format as train_data_path. If not provided,
     * a random 80/20 train/test split will be performed on train_data_path.
     * </pre>
     *
     * <code>string test_data_path = 4;</code>
     *
     * @return The bytes for testDataPath.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getTestDataPathBytes() {
      java.lang.Object ref = testDataPath_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        testDataPath_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(corpusDataPath_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, corpusDataPath_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(queryDataPath_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, queryDataPath_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(trainDataPath_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, trainDataPath_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(testDataPath_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, testDataPath_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(corpusDataPath_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, corpusDataPath_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(queryDataPath_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, queryDataPath_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(trainDataPath_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, trainDataPath_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(testDataPath_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, testDataPath_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.discoveryengine.v1.TrainCustomModelRequest.GcsTrainingInput)) {
        return super.equals(obj);
      }
      com.google.cloud.discoveryengine.v1.TrainCustomModelRequest.GcsTrainingInput other =
          (com.google.cloud.discoveryengine.v1.TrainCustomModelRequest.GcsTrainingInput) obj;

      if (!getCorpusDataPath().equals(other.getCorpusDataPath())) return false;
      if (!getQueryDataPath().equals(other.getQueryDataPath())) return false;
      if (!getTrainDataPath().equals(other.getTrainDataPath())) return false;
      if (!getTestDataPath().equals(other.getTestDataPath())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + CORPUS_DATA_PATH_FIELD_NUMBER;
      hash = (53 * hash) + getCorpusDataPath().hashCode();
      hash = (37 * hash) + QUERY_DATA_PATH_FIELD_NUMBER;
      hash = (53 * hash) + getQueryDataPath().hashCode();
      hash = (37 * hash) + TRAIN_DATA_PATH_FIELD_NUMBER;
      hash = (53 * hash) + getTrainDataPath().hashCode();
      hash = (37 * hash) + TEST_DATA_PATH_FIELD_NUMBER;
      hash = (53 * hash) + getTestDataPath().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.discoveryengine.v1.TrainCustomModelRequest.GcsTrainingInput
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1.TrainCustomModelRequest.GcsTrainingInput
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.TrainCustomModelRequest.GcsTrainingInput
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1.TrainCustomModelRequest.GcsTrainingInput
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.TrainCustomModelRequest.GcsTrainingInput
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1.TrainCustomModelRequest.GcsTrainingInput
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.TrainCustomModelRequest.GcsTrainingInput
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1.TrainCustomModelRequest.GcsTrainingInput
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.TrainCustomModelRequest.GcsTrainingInput
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1.TrainCustomModelRequest.GcsTrainingInput
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.TrainCustomModelRequest.GcsTrainingInput
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1.TrainCustomModelRequest.GcsTrainingInput
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.discoveryengine.v1.TrainCustomModelRequest.GcsTrainingInput prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Cloud Storage training data input.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.discoveryengine.v1.TrainCustomModelRequest.GcsTrainingInput}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1.TrainCustomModelRequest.GcsTrainingInput)
        com.google.cloud.discoveryengine.v1.TrainCustomModelRequest.GcsTrainingInputOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1.SearchTuningServiceProto
            .internal_static_google_cloud_discoveryengine_v1_TrainCustomModelRequest_GcsTrainingInput_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1.SearchTuningServiceProto
            .internal_static_google_cloud_discoveryengine_v1_TrainCustomModelRequest_GcsTrainingInput_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1.TrainCustomModelRequest.GcsTrainingInput.class,
                com.google.cloud.discoveryengine.v1.TrainCustomModelRequest.GcsTrainingInput.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.discoveryengine.v1.TrainCustomModelRequest.GcsTrainingInput.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        corpusDataPath_ = "";
        queryDataPath_ = "";
        trainDataPath_ = "";
        testDataPath_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.discoveryengine.v1.SearchTuningServiceProto
            .internal_static_google_cloud_discoveryengine_v1_TrainCustomModelRequest_GcsTrainingInput_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.TrainCustomModelRequest.GcsTrainingInput
          getDefaultInstanceForType() {
        return com.google.cloud.discoveryengine.v1.TrainCustomModelRequest.GcsTrainingInput
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.TrainCustomModelRequest.GcsTrainingInput build() {
        com.google.cloud.discoveryengine.v1.TrainCustomModelRequest.GcsTrainingInput result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.TrainCustomModelRequest.GcsTrainingInput
          buildPartial() {
        com.google.cloud.discoveryengine.v1.TrainCustomModelRequest.GcsTrainingInput result =
            new com.google.cloud.discoveryengine.v1.TrainCustomModelRequest.GcsTrainingInput(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.discoveryengine.v1.TrainCustomModelRequest.GcsTrainingInput result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.corpusDataPath_ = corpusDataPath_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.queryDataPath_ = queryDataPath_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.trainDataPath_ = trainDataPath_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.testDataPath_ = testDataPath_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.discoveryengine.v1.TrainCustomModelRequest.GcsTrainingInput) {
          return mergeFrom(
              (com.google.cloud.discoveryengine.v1.TrainCustomModelRequest.GcsTrainingInput) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.discoveryengine.v1.TrainCustomModelRequest.GcsTrainingInput other) {
        if (other
            == com.google.cloud.discoveryengine.v1.TrainCustomModelRequest.GcsTrainingInput
                .getDefaultInstance()) return this;
        if (!other.getCorpusDataPath().isEmpty()) {
          corpusDataPath_ = other.corpusDataPath_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getQueryDataPath().isEmpty()) {
          queryDataPath_ = other.queryDataPath_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (!other.getTrainDataPath().isEmpty()) {
          trainDataPath_ = other.trainDataPath_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        if (!other.getTestDataPath().isEmpty()) {
          testDataPath_ = other.testDataPath_;
          bitField0_ |= 0x00000008;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  corpusDataPath_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  queryDataPath_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  trainDataPath_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              case 34:
                {
                  testDataPath_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 34
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object corpusDataPath_ = "";

      /**
       *
       *
       * <pre>
       * The Cloud Storage corpus data which could be associated in train data.
       * The data path format is `gs://&lt;bucket_to_data&gt;/&lt;jsonl_file_name&gt;`.
       * A newline delimited jsonl/ndjson file.
       *
       * For search-tuning model, each line should have the _id, title
       * and text. Example:
       * `{"_id": "doc1", title: "relevant doc", "text": "relevant text"}`
       * </pre>
       *
       * <code>string corpus_data_path = 1;</code>
       *
       * @return The corpusDataPath.
       */
      public java.lang.String getCorpusDataPath() {
        java.lang.Object ref = corpusDataPath_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          corpusDataPath_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The Cloud Storage corpus data which could be associated in train data.
       * The data path format is `gs://&lt;bucket_to_data&gt;/&lt;jsonl_file_name&gt;`.
       * A newline delimited jsonl/ndjson file.
       *
       * For search-tuning model, each line should have the _id, title
       * and text. Example:
       * `{"_id": "doc1", title: "relevant doc", "text": "relevant text"}`
       * </pre>
       *
       * <code>string corpus_data_path = 1;</code>
       *
       * @return The bytes for corpusDataPath.
       */
      public com.google.protobuf.ByteString getCorpusDataPathBytes() {
        java.lang.Object ref = corpusDataPath_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          corpusDataPath_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The Cloud Storage corpus data which could be associated in train data.
       * The data path format is `gs://&lt;bucket_to_data&gt;/&lt;jsonl_file_name&gt;`.
       * A newline delimited jsonl/ndjson file.
       *
       * For search-tuning model, each line should have the _id, title
       * and text. Example:
       * `{"_id": "doc1", title: "relevant doc", "text": "relevant text"}`
       * </pre>
       *
       * <code>string corpus_data_path = 1;</code>
       *
       * @param value The corpusDataPath to set.
       * @return This builder for chaining.
       */
      public Builder setCorpusDataPath(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        corpusDataPath_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The Cloud Storage corpus data which could be associated in train data.
       * The data path format is `gs://&lt;bucket_to_data&gt;/&lt;jsonl_file_name&gt;`.
       * A newline delimited jsonl/ndjson file.
       *
       * For search-tuning model, each line should have the _id, title
       * and text. Example:
       * `{"_id": "doc1", title: "relevant doc", "text": "relevant text"}`
       * </pre>
       *
       * <code>string corpus_data_path = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearCorpusDataPath() {
        corpusDataPath_ = getDefaultInstance().getCorpusDataPath();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The Cloud Storage corpus data which could be associated in train data.
       * The data path format is `gs://&lt;bucket_to_data&gt;/&lt;jsonl_file_name&gt;`.
       * A newline delimited jsonl/ndjson file.
       *
       * For search-tuning model, each line should have the _id, title
       * and text. Example:
       * `{"_id": "doc1", title: "relevant doc", "text": "relevant text"}`
       * </pre>
       *
       * <code>string corpus_data_path = 1;</code>
       *
       * @param value The bytes for corpusDataPath to set.
       * @return This builder for chaining.
       */
      public Builder setCorpusDataPathBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        corpusDataPath_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object queryDataPath_ = "";

      /**
       *
       *
       * <pre>
       * The gcs query data which could be associated in train data.
       * The data path format is `gs://&lt;bucket_to_data&gt;/&lt;jsonl_file_name&gt;`.
       * A newline delimited jsonl/ndjson file.
       *
       * For search-tuning model, each line should have the _id
       * and text. Example: {"_id": "query1",  "text": "example query"}
       * </pre>
       *
       * <code>string query_data_path = 2;</code>
       *
       * @return The queryDataPath.
       */
      public java.lang.String getQueryDataPath() {
        java.lang.Object ref = queryDataPath_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          queryDataPath_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The gcs query data which could be associated in train data.
       * The data path format is `gs://&lt;bucket_to_data&gt;/&lt;jsonl_file_name&gt;`.
       * A newline delimited jsonl/ndjson file.
       *
       * For search-tuning model, each line should have the _id
       * and text. Example: {"_id": "query1",  "text": "example query"}
       * </pre>
       *
       * <code>string query_data_path = 2;</code>
       *
       * @return The bytes for queryDataPath.
       */
      public com.google.protobuf.ByteString getQueryDataPathBytes() {
        java.lang.Object ref = queryDataPath_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          queryDataPath_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The gcs query data which could be associated in train data.
       * The data path format is `gs://&lt;bucket_to_data&gt;/&lt;jsonl_file_name&gt;`.
       * A newline delimited jsonl/ndjson file.
       *
       * For search-tuning model, each line should have the _id
       * and text. Example: {"_id": "query1",  "text": "example query"}
       * </pre>
       *
       * <code>string query_data_path = 2;</code>
       *
       * @param value The queryDataPath to set.
       * @return This builder for chaining.
       */
      public Builder setQueryDataPath(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        queryDataPath_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The gcs query data which could be associated in train data.
       * The data path format is `gs://&lt;bucket_to_data&gt;/&lt;jsonl_file_name&gt;`.
       * A newline delimited jsonl/ndjson file.
       *
       * For search-tuning model, each line should have the _id
       * and text. Example: {"_id": "query1",  "text": "example query"}
       * </pre>
       *
       * <code>string query_data_path = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearQueryDataPath() {
        queryDataPath_ = getDefaultInstance().getQueryDataPath();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The gcs query data which could be associated in train data.
       * The data path format is `gs://&lt;bucket_to_data&gt;/&lt;jsonl_file_name&gt;`.
       * A newline delimited jsonl/ndjson file.
       *
       * For search-tuning model, each line should have the _id
       * and text. Example: {"_id": "query1",  "text": "example query"}
       * </pre>
       *
       * <code>string query_data_path = 2;</code>
       *
       * @param value The bytes for queryDataPath to set.
       * @return This builder for chaining.
       */
      public Builder setQueryDataPathBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        queryDataPath_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private java.lang.Object trainDataPath_ = "";

      /**
       *
       *
       * <pre>
       * Cloud Storage training data path whose format should be
       * `gs://&lt;bucket_to_data&gt;/&lt;tsv_file_name&gt;`. The file should be in tsv
       * format. Each line should have the doc_id and query_id and score (number).
       *
       * For search-tuning model, it should have the query-id corpus-id
       * score as tsv file header. The score should be a number in `[0, inf+)`.
       * The larger the number is, the more relevant the pair is. Example:
       *
       * * `query-id&#92;tcorpus-id&#92;tscore`
       * * `query1&#92;tdoc1&#92;t1`
       * </pre>
       *
       * <code>string train_data_path = 3;</code>
       *
       * @return The trainDataPath.
       */
      public java.lang.String getTrainDataPath() {
        java.lang.Object ref = trainDataPath_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          trainDataPath_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Cloud Storage training data path whose format should be
       * `gs://&lt;bucket_to_data&gt;/&lt;tsv_file_name&gt;`. The file should be in tsv
       * format. Each line should have the doc_id and query_id and score (number).
       *
       * For search-tuning model, it should have the query-id corpus-id
       * score as tsv file header. The score should be a number in `[0, inf+)`.
       * The larger the number is, the more relevant the pair is. Example:
       *
       * * `query-id&#92;tcorpus-id&#92;tscore`
       * * `query1&#92;tdoc1&#92;t1`
       * </pre>
       *
       * <code>string train_data_path = 3;</code>
       *
       * @return The bytes for trainDataPath.
       */
      public com.google.protobuf.ByteString getTrainDataPathBytes() {
        java.lang.Object ref = trainDataPath_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          trainDataPath_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Cloud Storage training data path whose format should be
       * `gs://&lt;bucket_to_data&gt;/&lt;tsv_file_name&gt;`. The file should be in tsv
       * format. Each line should have the doc_id and query_id and score (number).
       *
       * For search-tuning model, it should have the query-id corpus-id
       * score as tsv file header. The score should be a number in `[0, inf+)`.
       * The larger the number is, the more relevant the pair is. Example:
       *
       * * `query-id&#92;tcorpus-id&#92;tscore`
       * * `query1&#92;tdoc1&#92;t1`
       * </pre>
       *
       * <code>string train_data_path = 3;</code>
       *
       * @param value The trainDataPath to set.
       * @return This builder for chaining.
       */
      public Builder setTrainDataPath(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        trainDataPath_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Cloud Storage training data path whose format should be
       * `gs://&lt;bucket_to_data&gt;/&lt;tsv_file_name&gt;`. The file should be in tsv
       * format. Each line should have the doc_id and query_id and score (number).
       *
       * For search-tuning model, it should have the query-id corpus-id
       * score as tsv file header. The score should be a number in `[0, inf+)`.
       * The larger the number is, the more relevant the pair is. Example:
       *
       * * `query-id&#92;tcorpus-id&#92;tscore`
       * * `query1&#92;tdoc1&#92;t1`
       * </pre>
       *
       * <code>string train_data_path = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTrainDataPath() {
        trainDataPath_ = getDefaultInstance().getTrainDataPath();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Cloud Storage training data path whose format should be
       * `gs://&lt;bucket_to_data&gt;/&lt;tsv_file_name&gt;`. The file should be in tsv
       * format. Each line should have the doc_id and query_id and score (number).
       *
       * For search-tuning model, it should have the query-id corpus-id
       * score as tsv file header. The score should be a number in `[0, inf+)`.
       * The larger the number is, the more relevant the pair is. Example:
       *
       * * `query-id&#92;tcorpus-id&#92;tscore`
       * * `query1&#92;tdoc1&#92;t1`
       * </pre>
       *
       * <code>string train_data_path = 3;</code>
       *
       * @param value The bytes for trainDataPath to set.
       * @return This builder for chaining.
       */
      public Builder setTrainDataPathBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        trainDataPath_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      private java.lang.Object testDataPath_ = "";

      /**
       *
       *
       * <pre>
       * Cloud Storage test data. Same format as train_data_path. If not provided,
       * a random 80/20 train/test split will be performed on train_data_path.
       * </pre>
       *
       * <code>string test_data_path = 4;</code>
       *
       * @return The testDataPath.
       */
      public java.lang.String getTestDataPath() {
        java.lang.Object ref = testDataPath_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          testDataPath_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Cloud Storage test data. Same format as train_data_path. If not provided,
       * a random 80/20 train/test split will be performed on train_data_path.
       * </pre>
       *
       * <code>string test_data_path = 4;</code>
       *
       * @return The bytes for testDataPath.
       */
      public com.google.protobuf.ByteString getTestDataPathBytes() {
        java.lang.Object ref = testDataPath_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          testDataPath_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Cloud Storage test data. Same format as train_data_path. If not provided,
       * a random 80/20 train/test split will be performed on train_data_path.
       * </pre>
       *
       * <code>string test_data_path = 4;</code>
       *
       * @param value The testDataPath to set.
       * @return This builder for chaining.
       */
      public Builder setTestDataPath(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        testDataPath_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Cloud Storage test data. Same format as train_data_path. If not provided,
       * a random 80/20 train/test split will be performed on train_data_path.
       * </pre>
       *
       * <code>string test_data_path = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTestDataPath() {
        testDataPath_ = getDefaultInstance().getTestDataPath();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Cloud Storage test data. Same format as train_data_path. If not provided,
       * a random 80/20 train/test split will be performed on train_data_path.
       * </pre>
       *
       * <code>string test_data_path = 4;</code>
       *
       * @param value The bytes for testDataPath to set.
       * @return This builder for chaining.
       */
      public Builder setTestDataPathBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        testDataPath_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1.TrainCustomModelRequest.GcsTrainingInput)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1.TrainCustomModelRequest.GcsTrainingInput)
    private static final com.google.cloud.discoveryengine.v1.TrainCustomModelRequest
            .GcsTrainingInput
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.discoveryengine.v1.TrainCustomModelRequest.GcsTrainingInput();
    }

    public static com.google.cloud.discoveryengine.v1.TrainCustomModelRequest.GcsTrainingInput
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<GcsTrainingInput> PARSER =
        new com.google.protobuf.AbstractParser<GcsTrainingInput>() {
          @java.lang.Override
          public GcsTrainingInput parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<GcsTrainingInput> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<GcsTrainingInput> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.TrainCustomModelRequest.GcsTrainingInput
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  private int trainingInputCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object trainingInput_;

  public enum TrainingInputCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    GCS_TRAINING_INPUT(2),
    TRAININGINPUT_NOT_SET(0);
    private final int value;

    private TrainingInputCase(int value) {
      this.value = value;
    }

    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static TrainingInputCase valueOf(int value) {
      return forNumber(value);
    }

    public static TrainingInputCase forNumber(int value) {
      switch (value) {
        case 2:
          return GCS_TRAINING_INPUT;
        case 0:
          return TRAININGINPUT_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public TrainingInputCase getTrainingInputCase() {
    return TrainingInputCase.forNumber(trainingInputCase_);
  }

  public static final int GCS_TRAINING_INPUT_FIELD_NUMBER = 2;

  /**
   *
   *
   * <pre>
   * Cloud Storage training input.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1.TrainCustomModelRequest.GcsTrainingInput gcs_training_input = 2;
   * </code>
   *
   * @return Whether the gcsTrainingInput field is set.
   */
  @java.lang.Override
  public boolean hasGcsTrainingInput() {
    return trainingInputCase_ == 2;
  }

  /**
   *
   *
   * <pre>
   * Cloud Storage training input.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1.TrainCustomModelRequest.GcsTrainingInput gcs_training_input = 2;
   * </code>
   *
   * @return The gcsTrainingInput.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.TrainCustomModelRequest.GcsTrainingInput
      getGcsTrainingInput() {
    if (trainingInputCase_ == 2) {
      return (com.google.cloud.discoveryengine.v1.TrainCustomModelRequest.GcsTrainingInput)
          trainingInput_;
    }
    return com.google.cloud.discoveryengine.v1.TrainCustomModelRequest.GcsTrainingInput
        .getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Cloud Storage training input.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1.TrainCustomModelRequest.GcsTrainingInput gcs_training_input = 2;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.TrainCustomModelRequest.GcsTrainingInputOrBuilder
      getGcsTrainingInputOrBuilder() {
    if (trainingInputCase_ == 2) {
      return (com.google.cloud.discoveryengine.v1.TrainCustomModelRequest.GcsTrainingInput)
          trainingInput_;
    }
    return com.google.cloud.discoveryengine.v1.TrainCustomModelRequest.GcsTrainingInput
        .getDefaultInstance();
  }

  public static final int DATA_STORE_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object dataStore_ = "";

  /**
   *
   *
   * <pre>
   * Required. The resource name of the Data Store, such as
   * `projects/&#42;&#47;locations/global/collections/default_collection/dataStores/default_data_store`.
   * This field is used to identify the data store where to train the models.
   * </pre>
   *
   * <code>
   * string data_store = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The dataStore.
   */
  @java.lang.Override
  public java.lang.String getDataStore() {
    java.lang.Object ref = dataStore_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      dataStore_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. The resource name of the Data Store, such as
   * `projects/&#42;&#47;locations/global/collections/default_collection/dataStores/default_data_store`.
   * This field is used to identify the data store where to train the models.
   * </pre>
   *
   * <code>
   * string data_store = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for dataStore.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDataStoreBytes() {
    java.lang.Object ref = dataStore_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      dataStore_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MODEL_TYPE_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object modelType_ = "";

  /**
   *
   *
   * <pre>
   * Model to be trained. Supported values are:
   *
   *  * **search-tuning**: Fine tuning the search system based on data provided.
   * </pre>
   *
   * <code>string model_type = 3;</code>
   *
   * @return The modelType.
   */
  @java.lang.Override
  public java.lang.String getModelType() {
    java.lang.Object ref = modelType_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      modelType_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Model to be trained. Supported values are:
   *
   *  * **search-tuning**: Fine tuning the search system based on data provided.
   * </pre>
   *
   * <code>string model_type = 3;</code>
   *
   * @return The bytes for modelType.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getModelTypeBytes() {
    java.lang.Object ref = modelType_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      modelType_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ERROR_CONFIG_FIELD_NUMBER = 4;
  private com.google.cloud.discoveryengine.v1.ImportErrorConfig errorConfig_;

  /**
   *
   *
   * <pre>
   * The desired location of errors incurred during the data ingestion and
   * training.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1.ImportErrorConfig error_config = 4;</code>
   *
   * @return Whether the errorConfig field is set.
   */
  @java.lang.Override
  public boolean hasErrorConfig() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * The desired location of errors incurred during the data ingestion and
   * training.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1.ImportErrorConfig error_config = 4;</code>
   *
   * @return The errorConfig.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.ImportErrorConfig getErrorConfig() {
    return errorConfig_ == null
        ? com.google.cloud.discoveryengine.v1.ImportErrorConfig.getDefaultInstance()
        : errorConfig_;
  }

  /**
   *
   *
   * <pre>
   * The desired location of errors incurred during the data ingestion and
   * training.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1.ImportErrorConfig error_config = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.ImportErrorConfigOrBuilder getErrorConfigOrBuilder() {
    return errorConfig_ == null
        ? com.google.cloud.discoveryengine.v1.ImportErrorConfig.getDefaultInstance()
        : errorConfig_;
  }

  public static final int MODEL_ID_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object modelId_ = "";

  /**
   *
   *
   * <pre>
   * If not provided, a UUID will be generated.
   * </pre>
   *
   * <code>string model_id = 5;</code>
   *
   * @return The modelId.
   */
  @java.lang.Override
  public java.lang.String getModelId() {
    java.lang.Object ref = modelId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      modelId_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * If not provided, a UUID will be generated.
   * </pre>
   *
   * <code>string model_id = 5;</code>
   *
   * @return The bytes for modelId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getModelIdBytes() {
    java.lang.Object ref = modelId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      modelId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dataStore_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, dataStore_);
    }
    if (trainingInputCase_ == 2) {
      output.writeMessage(
          2,
          (com.google.cloud.discoveryengine.v1.TrainCustomModelRequest.GcsTrainingInput)
              trainingInput_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(modelType_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, modelType_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(4, getErrorConfig());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(modelId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, modelId_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dataStore_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, dataStore_);
    }
    if (trainingInputCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2,
              (com.google.cloud.discoveryengine.v1.TrainCustomModelRequest.GcsTrainingInput)
                  trainingInput_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(modelType_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, modelType_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getErrorConfig());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(modelId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, modelId_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.discoveryengine.v1.TrainCustomModelRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.discoveryengine.v1.TrainCustomModelRequest other =
        (com.google.cloud.discoveryengine.v1.TrainCustomModelRequest) obj;

    if (!getDataStore().equals(other.getDataStore())) return false;
    if (!getModelType().equals(other.getModelType())) return false;
    if (hasErrorConfig() != other.hasErrorConfig()) return false;
    if (hasErrorConfig()) {
      if (!getErrorConfig().equals(other.getErrorConfig())) return false;
    }
    if (!getModelId().equals(other.getModelId())) return false;
    if (!getTrainingInputCase().equals(other.getTrainingInputCase())) return false;
    switch (trainingInputCase_) {
      case 2:
        if (!getGcsTrainingInput().equals(other.getGcsTrainingInput())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + DATA_STORE_FIELD_NUMBER;
    hash = (53 * hash) + getDataStore().hashCode();
    hash = (37 * hash) + MODEL_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + getModelType().hashCode();
    if (hasErrorConfig()) {
      hash = (37 * hash) + ERROR_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getErrorConfig().hashCode();
    }
    hash = (37 * hash) + MODEL_ID_FIELD_NUMBER;
    hash = (53 * hash) + getModelId().hashCode();
    switch (trainingInputCase_) {
      case 2:
        hash = (37 * hash) + GCS_TRAINING_INPUT_FIELD_NUMBER;
        hash = (53 * hash) + getGcsTrainingInput().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.discoveryengine.v1.TrainCustomModelRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1.TrainCustomModelRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.TrainCustomModelRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1.TrainCustomModelRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.TrainCustomModelRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1.TrainCustomModelRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.TrainCustomModelRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1.TrainCustomModelRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.TrainCustomModelRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1.TrainCustomModelRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.TrainCustomModelRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1.TrainCustomModelRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.discoveryengine.v1.TrainCustomModelRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Request message for
   * [SearchTuningService.TrainCustomModel][google.cloud.discoveryengine.v1.SearchTuningService.TrainCustomModel]
   * method.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1.TrainCustomModelRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1.TrainCustomModelRequest)
      com.google.cloud.discoveryengine.v1.TrainCustomModelRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1.SearchTuningServiceProto
          .internal_static_google_cloud_discoveryengine_v1_TrainCustomModelRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1.SearchTuningServiceProto
          .internal_static_google_cloud_discoveryengine_v1_TrainCustomModelRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1.TrainCustomModelRequest.class,
              com.google.cloud.discoveryengine.v1.TrainCustomModelRequest.Builder.class);
    }

    // Construct using com.google.cloud.discoveryengine.v1.TrainCustomModelRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getErrorConfigFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (gcsTrainingInputBuilder_ != null) {
        gcsTrainingInputBuilder_.clear();
      }
      dataStore_ = "";
      modelType_ = "";
      errorConfig_ = null;
      if (errorConfigBuilder_ != null) {
        errorConfigBuilder_.dispose();
        errorConfigBuilder_ = null;
      }
      modelId_ = "";
      trainingInputCase_ = 0;
      trainingInput_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.discoveryengine.v1.SearchTuningServiceProto
          .internal_static_google_cloud_discoveryengine_v1_TrainCustomModelRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.TrainCustomModelRequest getDefaultInstanceForType() {
      return com.google.cloud.discoveryengine.v1.TrainCustomModelRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.TrainCustomModelRequest build() {
      com.google.cloud.discoveryengine.v1.TrainCustomModelRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.TrainCustomModelRequest buildPartial() {
      com.google.cloud.discoveryengine.v1.TrainCustomModelRequest result =
          new com.google.cloud.discoveryengine.v1.TrainCustomModelRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.discoveryengine.v1.TrainCustomModelRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.dataStore_ = dataStore_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.modelType_ = modelType_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.errorConfig_ =
            errorConfigBuilder_ == null ? errorConfig_ : errorConfigBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.modelId_ = modelId_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(
        com.google.cloud.discoveryengine.v1.TrainCustomModelRequest result) {
      result.trainingInputCase_ = trainingInputCase_;
      result.trainingInput_ = this.trainingInput_;
      if (trainingInputCase_ == 2 && gcsTrainingInputBuilder_ != null) {
        result.trainingInput_ = gcsTrainingInputBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.discoveryengine.v1.TrainCustomModelRequest) {
        return mergeFrom((com.google.cloud.discoveryengine.v1.TrainCustomModelRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.discoveryengine.v1.TrainCustomModelRequest other) {
      if (other == com.google.cloud.discoveryengine.v1.TrainCustomModelRequest.getDefaultInstance())
        return this;
      if (!other.getDataStore().isEmpty()) {
        dataStore_ = other.dataStore_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getModelType().isEmpty()) {
        modelType_ = other.modelType_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasErrorConfig()) {
        mergeErrorConfig(other.getErrorConfig());
      }
      if (!other.getModelId().isEmpty()) {
        modelId_ = other.modelId_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      switch (other.getTrainingInputCase()) {
        case GCS_TRAINING_INPUT:
          {
            mergeGcsTrainingInput(other.getGcsTrainingInput());
            break;
          }
        case TRAININGINPUT_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                dataStore_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(
                    getGcsTrainingInputFieldBuilder().getBuilder(), extensionRegistry);
                trainingInputCase_ = 2;
                break;
              } // case 18
            case 26:
              {
                modelType_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getErrorConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                modelId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int trainingInputCase_ = 0;
    private java.lang.Object trainingInput_;

    public TrainingInputCase getTrainingInputCase() {
      return TrainingInputCase.forNumber(trainingInputCase_);
    }

    public Builder clearTrainingInput() {
      trainingInputCase_ = 0;
      trainingInput_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1.TrainCustomModelRequest.GcsTrainingInput,
            com.google.cloud.discoveryengine.v1.TrainCustomModelRequest.GcsTrainingInput.Builder,
            com.google.cloud.discoveryengine.v1.TrainCustomModelRequest.GcsTrainingInputOrBuilder>
        gcsTrainingInputBuilder_;

    /**
     *
     *
     * <pre>
     * Cloud Storage training input.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.TrainCustomModelRequest.GcsTrainingInput gcs_training_input = 2;
     * </code>
     *
     * @return Whether the gcsTrainingInput field is set.
     */
    @java.lang.Override
    public boolean hasGcsTrainingInput() {
      return trainingInputCase_ == 2;
    }

    /**
     *
     *
     * <pre>
     * Cloud Storage training input.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.TrainCustomModelRequest.GcsTrainingInput gcs_training_input = 2;
     * </code>
     *
     * @return The gcsTrainingInput.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.TrainCustomModelRequest.GcsTrainingInput
        getGcsTrainingInput() {
      if (gcsTrainingInputBuilder_ == null) {
        if (trainingInputCase_ == 2) {
          return (com.google.cloud.discoveryengine.v1.TrainCustomModelRequest.GcsTrainingInput)
              trainingInput_;
        }
        return com.google.cloud.discoveryengine.v1.TrainCustomModelRequest.GcsTrainingInput
            .getDefaultInstance();
      } else {
        if (trainingInputCase_ == 2) {
          return gcsTrainingInputBuilder_.getMessage();
        }
        return com.google.cloud.discoveryengine.v1.TrainCustomModelRequest.GcsTrainingInput
            .getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Cloud Storage training input.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.TrainCustomModelRequest.GcsTrainingInput gcs_training_input = 2;
     * </code>
     */
    public Builder setGcsTrainingInput(
        com.google.cloud.discoveryengine.v1.TrainCustomModelRequest.GcsTrainingInput value) {
      if (gcsTrainingInputBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        trainingInput_ = value;
        onChanged();
      } else {
        gcsTrainingInputBuilder_.setMessage(value);
      }
      trainingInputCase_ = 2;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Cloud Storage training input.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.TrainCustomModelRequest.GcsTrainingInput gcs_training_input = 2;
     * </code>
     */
    public Builder setGcsTrainingInput(
        com.google.cloud.discoveryengine.v1.TrainCustomModelRequest.GcsTrainingInput.Builder
            builderForValue) {
      if (gcsTrainingInputBuilder_ == null) {
        trainingInput_ = builderForValue.build();
        onChanged();
      } else {
        gcsTrainingInputBuilder_.setMessage(builderForValue.build());
      }
      trainingInputCase_ = 2;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Cloud Storage training input.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.TrainCustomModelRequest.GcsTrainingInput gcs_training_input = 2;
     * </code>
     */
    public Builder mergeGcsTrainingInput(
        com.google.cloud.discoveryengine.v1.TrainCustomModelRequest.GcsTrainingInput value) {
      if (gcsTrainingInputBuilder_ == null) {
        if (trainingInputCase_ == 2
            && trainingInput_
                != com.google.cloud.discoveryengine.v1.TrainCustomModelRequest.GcsTrainingInput
                    .getDefaultInstance()) {
          trainingInput_ =
              com.google.cloud.discoveryengine.v1.TrainCustomModelRequest.GcsTrainingInput
                  .newBuilder(
                      (com.google.cloud.discoveryengine.v1.TrainCustomModelRequest.GcsTrainingInput)
                          trainingInput_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          trainingInput_ = value;
        }
        onChanged();
      } else {
        if (trainingInputCase_ == 2) {
          gcsTrainingInputBuilder_.mergeFrom(value);
        } else {
          gcsTrainingInputBuilder_.setMessage(value);
        }
      }
      trainingInputCase_ = 2;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Cloud Storage training input.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.TrainCustomModelRequest.GcsTrainingInput gcs_training_input = 2;
     * </code>
     */
    public Builder clearGcsTrainingInput() {
      if (gcsTrainingInputBuilder_ == null) {
        if (trainingInputCase_ == 2) {
          trainingInputCase_ = 0;
          trainingInput_ = null;
          onChanged();
        }
      } else {
        if (trainingInputCase_ == 2) {
          trainingInputCase_ = 0;
          trainingInput_ = null;
        }
        gcsTrainingInputBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Cloud Storage training input.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.TrainCustomModelRequest.GcsTrainingInput gcs_training_input = 2;
     * </code>
     */
    public com.google.cloud.discoveryengine.v1.TrainCustomModelRequest.GcsTrainingInput.Builder
        getGcsTrainingInputBuilder() {
      return getGcsTrainingInputFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Cloud Storage training input.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.TrainCustomModelRequest.GcsTrainingInput gcs_training_input = 2;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.TrainCustomModelRequest.GcsTrainingInputOrBuilder
        getGcsTrainingInputOrBuilder() {
      if ((trainingInputCase_ == 2) && (gcsTrainingInputBuilder_ != null)) {
        return gcsTrainingInputBuilder_.getMessageOrBuilder();
      } else {
        if (trainingInputCase_ == 2) {
          return (com.google.cloud.discoveryengine.v1.TrainCustomModelRequest.GcsTrainingInput)
              trainingInput_;
        }
        return com.google.cloud.discoveryengine.v1.TrainCustomModelRequest.GcsTrainingInput
            .getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Cloud Storage training input.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.TrainCustomModelRequest.GcsTrainingInput gcs_training_input = 2;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1.TrainCustomModelRequest.GcsTrainingInput,
            com.google.cloud.discoveryengine.v1.TrainCustomModelRequest.GcsTrainingInput.Builder,
            com.google.cloud.discoveryengine.v1.TrainCustomModelRequest.GcsTrainingInputOrBuilder>
        getGcsTrainingInputFieldBuilder() {
      if (gcsTrainingInputBuilder_ == null) {
        if (!(trainingInputCase_ == 2)) {
          trainingInput_ =
              com.google.cloud.discoveryengine.v1.TrainCustomModelRequest.GcsTrainingInput
                  .getDefaultInstance();
        }
        gcsTrainingInputBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1.TrainCustomModelRequest.GcsTrainingInput,
                com.google.cloud.discoveryengine.v1.TrainCustomModelRequest.GcsTrainingInput
                    .Builder,
                com.google.cloud.discoveryengine.v1.TrainCustomModelRequest
                    .GcsTrainingInputOrBuilder>(
                (com.google.cloud.discoveryengine.v1.TrainCustomModelRequest.GcsTrainingInput)
                    trainingInput_,
                getParentForChildren(),
                isClean());
        trainingInput_ = null;
      }
      trainingInputCase_ = 2;
      onChanged();
      return gcsTrainingInputBuilder_;
    }

    private java.lang.Object dataStore_ = "";

    /**
     *
     *
     * <pre>
     * Required. The resource name of the Data Store, such as
     * `projects/&#42;&#47;locations/global/collections/default_collection/dataStores/default_data_store`.
     * This field is used to identify the data store where to train the models.
     * </pre>
     *
     * <code>
     * string data_store = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The dataStore.
     */
    public java.lang.String getDataStore() {
      java.lang.Object ref = dataStore_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        dataStore_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The resource name of the Data Store, such as
     * `projects/&#42;&#47;locations/global/collections/default_collection/dataStores/default_data_store`.
     * This field is used to identify the data store where to train the models.
     * </pre>
     *
     * <code>
     * string data_store = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for dataStore.
     */
    public com.google.protobuf.ByteString getDataStoreBytes() {
      java.lang.Object ref = dataStore_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        dataStore_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The resource name of the Data Store, such as
     * `projects/&#42;&#47;locations/global/collections/default_collection/dataStores/default_data_store`.
     * This field is used to identify the data store where to train the models.
     * </pre>
     *
     * <code>
     * string data_store = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The dataStore to set.
     * @return This builder for chaining.
     */
    public Builder setDataStore(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      dataStore_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The resource name of the Data Store, such as
     * `projects/&#42;&#47;locations/global/collections/default_collection/dataStores/default_data_store`.
     * This field is used to identify the data store where to train the models.
     * </pre>
     *
     * <code>
     * string data_store = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDataStore() {
      dataStore_ = getDefaultInstance().getDataStore();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The resource name of the Data Store, such as
     * `projects/&#42;&#47;locations/global/collections/default_collection/dataStores/default_data_store`.
     * This field is used to identify the data store where to train the models.
     * </pre>
     *
     * <code>
     * string data_store = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for dataStore to set.
     * @return This builder for chaining.
     */
    public Builder setDataStoreBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      dataStore_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object modelType_ = "";

    /**
     *
     *
     * <pre>
     * Model to be trained. Supported values are:
     *
     *  * **search-tuning**: Fine tuning the search system based on data provided.
     * </pre>
     *
     * <code>string model_type = 3;</code>
     *
     * @return The modelType.
     */
    public java.lang.String getModelType() {
      java.lang.Object ref = modelType_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        modelType_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Model to be trained. Supported values are:
     *
     *  * **search-tuning**: Fine tuning the search system based on data provided.
     * </pre>
     *
     * <code>string model_type = 3;</code>
     *
     * @return The bytes for modelType.
     */
    public com.google.protobuf.ByteString getModelTypeBytes() {
      java.lang.Object ref = modelType_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        modelType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Model to be trained. Supported values are:
     *
     *  * **search-tuning**: Fine tuning the search system based on data provided.
     * </pre>
     *
     * <code>string model_type = 3;</code>
     *
     * @param value The modelType to set.
     * @return This builder for chaining.
     */
    public Builder setModelType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      modelType_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Model to be trained. Supported values are:
     *
     *  * **search-tuning**: Fine tuning the search system based on data provided.
     * </pre>
     *
     * <code>string model_type = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearModelType() {
      modelType_ = getDefaultInstance().getModelType();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Model to be trained. Supported values are:
     *
     *  * **search-tuning**: Fine tuning the search system based on data provided.
     * </pre>
     *
     * <code>string model_type = 3;</code>
     *
     * @param value The bytes for modelType to set.
     * @return This builder for chaining.
     */
    public Builder setModelTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      modelType_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.cloud.discoveryengine.v1.ImportErrorConfig errorConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1.ImportErrorConfig,
            com.google.cloud.discoveryengine.v1.ImportErrorConfig.Builder,
            com.google.cloud.discoveryengine.v1.ImportErrorConfigOrBuilder>
        errorConfigBuilder_;

    /**
     *
     *
     * <pre>
     * The desired location of errors incurred during the data ingestion and
     * training.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.ImportErrorConfig error_config = 4;</code>
     *
     * @return Whether the errorConfig field is set.
     */
    public boolean hasErrorConfig() {
      return ((bitField0_ & 0x00000008) != 0);
    }

    /**
     *
     *
     * <pre>
     * The desired location of errors incurred during the data ingestion and
     * training.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.ImportErrorConfig error_config = 4;</code>
     *
     * @return The errorConfig.
     */
    public com.google.cloud.discoveryengine.v1.ImportErrorConfig getErrorConfig() {
      if (errorConfigBuilder_ == null) {
        return errorConfig_ == null
            ? com.google.cloud.discoveryengine.v1.ImportErrorConfig.getDefaultInstance()
            : errorConfig_;
      } else {
        return errorConfigBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * The desired location of errors incurred during the data ingestion and
     * training.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.ImportErrorConfig error_config = 4;</code>
     */
    public Builder setErrorConfig(com.google.cloud.discoveryengine.v1.ImportErrorConfig value) {
      if (errorConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        errorConfig_ = value;
      } else {
        errorConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The desired location of errors incurred during the data ingestion and
     * training.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.ImportErrorConfig error_config = 4;</code>
     */
    public Builder setErrorConfig(
        com.google.cloud.discoveryengine.v1.ImportErrorConfig.Builder builderForValue) {
      if (errorConfigBuilder_ == null) {
        errorConfig_ = builderForValue.build();
      } else {
        errorConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The desired location of errors incurred during the data ingestion and
     * training.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.ImportErrorConfig error_config = 4;</code>
     */
    public Builder mergeErrorConfig(com.google.cloud.discoveryengine.v1.ImportErrorConfig value) {
      if (errorConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && errorConfig_ != null
            && errorConfig_
                != com.google.cloud.discoveryengine.v1.ImportErrorConfig.getDefaultInstance()) {
          getErrorConfigBuilder().mergeFrom(value);
        } else {
          errorConfig_ = value;
        }
      } else {
        errorConfigBuilder_.mergeFrom(value);
      }
      if (errorConfig_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The desired location of errors incurred during the data ingestion and
     * training.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.ImportErrorConfig error_config = 4;</code>
     */
    public Builder clearErrorConfig() {
      bitField0_ = (bitField0_ & ~0x00000008);
      errorConfig_ = null;
      if (errorConfigBuilder_ != null) {
        errorConfigBuilder_.dispose();
        errorConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The desired location of errors incurred during the data ingestion and
     * training.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.ImportErrorConfig error_config = 4;</code>
     */
    public com.google.cloud.discoveryengine.v1.ImportErrorConfig.Builder getErrorConfigBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getErrorConfigFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * The desired location of errors incurred during the data ingestion and
     * training.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.ImportErrorConfig error_config = 4;</code>
     */
    public com.google.cloud.discoveryengine.v1.ImportErrorConfigOrBuilder
        getErrorConfigOrBuilder() {
      if (errorConfigBuilder_ != null) {
        return errorConfigBuilder_.getMessageOrBuilder();
      } else {
        return errorConfig_ == null
            ? com.google.cloud.discoveryengine.v1.ImportErrorConfig.getDefaultInstance()
            : errorConfig_;
      }
    }

    /**
     *
     *
     * <pre>
     * The desired location of errors incurred during the data ingestion and
     * training.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.ImportErrorConfig error_config = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1.ImportErrorConfig,
            com.google.cloud.discoveryengine.v1.ImportErrorConfig.Builder,
            com.google.cloud.discoveryengine.v1.ImportErrorConfigOrBuilder>
        getErrorConfigFieldBuilder() {
      if (errorConfigBuilder_ == null) {
        errorConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1.ImportErrorConfig,
                com.google.cloud.discoveryengine.v1.ImportErrorConfig.Builder,
                com.google.cloud.discoveryengine.v1.ImportErrorConfigOrBuilder>(
                getErrorConfig(), getParentForChildren(), isClean());
        errorConfig_ = null;
      }
      return errorConfigBuilder_;
    }

    private java.lang.Object modelId_ = "";

    /**
     *
     *
     * <pre>
     * If not provided, a UUID will be generated.
     * </pre>
     *
     * <code>string model_id = 5;</code>
     *
     * @return The modelId.
     */
    public java.lang.String getModelId() {
      java.lang.Object ref = modelId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        modelId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * If not provided, a UUID will be generated.
     * </pre>
     *
     * <code>string model_id = 5;</code>
     *
     * @return The bytes for modelId.
     */
    public com.google.protobuf.ByteString getModelIdBytes() {
      java.lang.Object ref = modelId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        modelId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * If not provided, a UUID will be generated.
     * </pre>
     *
     * <code>string model_id = 5;</code>
     *
     * @param value The modelId to set.
     * @return This builder for chaining.
     */
    public Builder setModelId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      modelId_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * If not provided, a UUID will be generated.
     * </pre>
     *
     * <code>string model_id = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearModelId() {
      modelId_ = getDefaultInstance().getModelId();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * If not provided, a UUID will be generated.
     * </pre>
     *
     * <code>string model_id = 5;</code>
     *
     * @param value The bytes for modelId to set.
     * @return This builder for chaining.
     */
    public Builder setModelIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      modelId_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1.TrainCustomModelRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1.TrainCustomModelRequest)
  private static final com.google.cloud.discoveryengine.v1.TrainCustomModelRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.discoveryengine.v1.TrainCustomModelRequest();
  }

  public static com.google.cloud.discoveryengine.v1.TrainCustomModelRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<TrainCustomModelRequest> PARSER =
      new com.google.protobuf.AbstractParser<TrainCustomModelRequest>() {
        @java.lang.Override
        public TrainCustomModelRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<TrainCustomModelRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<TrainCustomModelRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.TrainCustomModelRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
