/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/discoveryengine/v1/user_event.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.discoveryengine.v1;

/**
 *
 *
 * <pre>
 * A transaction represents the entire purchase transaction.
 * </pre>
 *
 * Protobuf type {@code google.cloud.discoveryengine.v1.TransactionInfo}
 */
public final class TransactionInfo extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1.TransactionInfo)
    TransactionInfoOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use TransactionInfo.newBuilder() to construct.
  private TransactionInfo(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private TransactionInfo() {
    currency_ = "";
    transactionId_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new TransactionInfo();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.discoveryengine.v1.UserEventProto
        .internal_static_google_cloud_discoveryengine_v1_TransactionInfo_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.discoveryengine.v1.UserEventProto
        .internal_static_google_cloud_discoveryengine_v1_TransactionInfo_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.discoveryengine.v1.TransactionInfo.class,
            com.google.cloud.discoveryengine.v1.TransactionInfo.Builder.class);
  }

  private int bitField0_;
  public static final int VALUE_FIELD_NUMBER = 1;
  private float value_ = 0F;

  /**
   *
   *
   * <pre>
   * Required. Total non-zero value associated with the transaction. This value
   * may include shipping, tax, or other adjustments to the total value that you
   * want to include.
   * </pre>
   *
   * <code>optional float value = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return Whether the value field is set.
   */
  @java.lang.Override
  public boolean hasValue() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Required. Total non-zero value associated with the transaction. This value
   * may include shipping, tax, or other adjustments to the total value that you
   * want to include.
   * </pre>
   *
   * <code>optional float value = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The value.
   */
  @java.lang.Override
  public float getValue() {
    return value_;
  }

  public static final int CURRENCY_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object currency_ = "";

  /**
   *
   *
   * <pre>
   * Required. Currency code. Use three-character ISO-4217 code.
   * </pre>
   *
   * <code>string currency = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The currency.
   */
  @java.lang.Override
  public java.lang.String getCurrency() {
    java.lang.Object ref = currency_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      currency_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. Currency code. Use three-character ISO-4217 code.
   * </pre>
   *
   * <code>string currency = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for currency.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCurrencyBytes() {
    java.lang.Object ref = currency_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      currency_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TRANSACTION_ID_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object transactionId_ = "";

  /**
   *
   *
   * <pre>
   * The transaction ID with a length limit of 128 characters.
   * </pre>
   *
   * <code>string transaction_id = 3;</code>
   *
   * @return The transactionId.
   */
  @java.lang.Override
  public java.lang.String getTransactionId() {
    java.lang.Object ref = transactionId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      transactionId_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The transaction ID with a length limit of 128 characters.
   * </pre>
   *
   * <code>string transaction_id = 3;</code>
   *
   * @return The bytes for transactionId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTransactionIdBytes() {
    java.lang.Object ref = transactionId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      transactionId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TAX_FIELD_NUMBER = 4;
  private float tax_ = 0F;

  /**
   *
   *
   * <pre>
   * All the taxes associated with the transaction.
   * </pre>
   *
   * <code>optional float tax = 4;</code>
   *
   * @return Whether the tax field is set.
   */
  @java.lang.Override
  public boolean hasTax() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * All the taxes associated with the transaction.
   * </pre>
   *
   * <code>optional float tax = 4;</code>
   *
   * @return The tax.
   */
  @java.lang.Override
  public float getTax() {
    return tax_;
  }

  public static final int COST_FIELD_NUMBER = 5;
  private float cost_ = 0F;

  /**
   *
   *
   * <pre>
   * All the costs associated with the products. These can be manufacturing
   * costs, shipping expenses not borne by the end user, or any other costs,
   * such that:
   *
   * * Profit = [value][google.cloud.discoveryengine.v1.TransactionInfo.value] -
   * [tax][google.cloud.discoveryengine.v1.TransactionInfo.tax] -
   * [cost][google.cloud.discoveryengine.v1.TransactionInfo.cost]
   * </pre>
   *
   * <code>optional float cost = 5;</code>
   *
   * @return Whether the cost field is set.
   */
  @java.lang.Override
  public boolean hasCost() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * All the costs associated with the products. These can be manufacturing
   * costs, shipping expenses not borne by the end user, or any other costs,
   * such that:
   *
   * * Profit = [value][google.cloud.discoveryengine.v1.TransactionInfo.value] -
   * [tax][google.cloud.discoveryengine.v1.TransactionInfo.tax] -
   * [cost][google.cloud.discoveryengine.v1.TransactionInfo.cost]
   * </pre>
   *
   * <code>optional float cost = 5;</code>
   *
   * @return The cost.
   */
  @java.lang.Override
  public float getCost() {
    return cost_;
  }

  public static final int DISCOUNT_VALUE_FIELD_NUMBER = 6;
  private float discountValue_ = 0F;

  /**
   *
   *
   * <pre>
   * The total discount(s) value applied to this transaction.
   * This figure should be excluded from
   * [TransactionInfo.value][google.cloud.discoveryengine.v1.TransactionInfo.value]
   *
   * For example, if a user paid
   * [TransactionInfo.value][google.cloud.discoveryengine.v1.TransactionInfo.value]
   * amount, then nominal (pre-discount) value of the transaction is the sum of
   * [TransactionInfo.value][google.cloud.discoveryengine.v1.TransactionInfo.value]
   * and
   * [TransactionInfo.discount_value][google.cloud.discoveryengine.v1.TransactionInfo.discount_value]
   *
   * This means that profit is calculated the same way, regardless of the
   * discount value, and that
   * [TransactionInfo.discount_value][google.cloud.discoveryengine.v1.TransactionInfo.discount_value]
   * can be larger than
   * [TransactionInfo.value][google.cloud.discoveryengine.v1.TransactionInfo.value]:
   *
   * * Profit = [value][google.cloud.discoveryengine.v1.TransactionInfo.value] -
   * [tax][google.cloud.discoveryengine.v1.TransactionInfo.tax] -
   * [cost][google.cloud.discoveryengine.v1.TransactionInfo.cost]
   * </pre>
   *
   * <code>optional float discount_value = 6;</code>
   *
   * @return Whether the discountValue field is set.
   */
  @java.lang.Override
  public boolean hasDiscountValue() {
    return ((bitField0_ & 0x00000008) != 0);
  }

  /**
   *
   *
   * <pre>
   * The total discount(s) value applied to this transaction.
   * This figure should be excluded from
   * [TransactionInfo.value][google.cloud.discoveryengine.v1.TransactionInfo.value]
   *
   * For example, if a user paid
   * [TransactionInfo.value][google.cloud.discoveryengine.v1.TransactionInfo.value]
   * amount, then nominal (pre-discount) value of the transaction is the sum of
   * [TransactionInfo.value][google.cloud.discoveryengine.v1.TransactionInfo.value]
   * and
   * [TransactionInfo.discount_value][google.cloud.discoveryengine.v1.TransactionInfo.discount_value]
   *
   * This means that profit is calculated the same way, regardless of the
   * discount value, and that
   * [TransactionInfo.discount_value][google.cloud.discoveryengine.v1.TransactionInfo.discount_value]
   * can be larger than
   * [TransactionInfo.value][google.cloud.discoveryengine.v1.TransactionInfo.value]:
   *
   * * Profit = [value][google.cloud.discoveryengine.v1.TransactionInfo.value] -
   * [tax][google.cloud.discoveryengine.v1.TransactionInfo.tax] -
   * [cost][google.cloud.discoveryengine.v1.TransactionInfo.cost]
   * </pre>
   *
   * <code>optional float discount_value = 6;</code>
   *
   * @return The discountValue.
   */
  @java.lang.Override
  public float getDiscountValue() {
    return discountValue_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeFloat(1, value_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(currency_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, currency_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(transactionId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, transactionId_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeFloat(4, tax_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeFloat(5, cost_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeFloat(6, discountValue_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeFloatSize(1, value_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(currency_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, currency_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(transactionId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, transactionId_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeFloatSize(4, tax_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeFloatSize(5, cost_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeFloatSize(6, discountValue_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.discoveryengine.v1.TransactionInfo)) {
      return super.equals(obj);
    }
    com.google.cloud.discoveryengine.v1.TransactionInfo other =
        (com.google.cloud.discoveryengine.v1.TransactionInfo) obj;

    if (hasValue() != other.hasValue()) return false;
    if (hasValue()) {
      if (java.lang.Float.floatToIntBits(getValue())
          != java.lang.Float.floatToIntBits(other.getValue())) return false;
    }
    if (!getCurrency().equals(other.getCurrency())) return false;
    if (!getTransactionId().equals(other.getTransactionId())) return false;
    if (hasTax() != other.hasTax()) return false;
    if (hasTax()) {
      if (java.lang.Float.floatToIntBits(getTax())
          != java.lang.Float.floatToIntBits(other.getTax())) return false;
    }
    if (hasCost() != other.hasCost()) return false;
    if (hasCost()) {
      if (java.lang.Float.floatToIntBits(getCost())
          != java.lang.Float.floatToIntBits(other.getCost())) return false;
    }
    if (hasDiscountValue() != other.hasDiscountValue()) return false;
    if (hasDiscountValue()) {
      if (java.lang.Float.floatToIntBits(getDiscountValue())
          != java.lang.Float.floatToIntBits(other.getDiscountValue())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasValue()) {
      hash = (37 * hash) + VALUE_FIELD_NUMBER;
      hash = (53 * hash) + java.lang.Float.floatToIntBits(getValue());
    }
    hash = (37 * hash) + CURRENCY_FIELD_NUMBER;
    hash = (53 * hash) + getCurrency().hashCode();
    hash = (37 * hash) + TRANSACTION_ID_FIELD_NUMBER;
    hash = (53 * hash) + getTransactionId().hashCode();
    if (hasTax()) {
      hash = (37 * hash) + TAX_FIELD_NUMBER;
      hash = (53 * hash) + java.lang.Float.floatToIntBits(getTax());
    }
    if (hasCost()) {
      hash = (37 * hash) + COST_FIELD_NUMBER;
      hash = (53 * hash) + java.lang.Float.floatToIntBits(getCost());
    }
    if (hasDiscountValue()) {
      hash = (37 * hash) + DISCOUNT_VALUE_FIELD_NUMBER;
      hash = (53 * hash) + java.lang.Float.floatToIntBits(getDiscountValue());
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.discoveryengine.v1.TransactionInfo parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1.TransactionInfo parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.TransactionInfo parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1.TransactionInfo parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.TransactionInfo parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1.TransactionInfo parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.TransactionInfo parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1.TransactionInfo parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.TransactionInfo parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1.TransactionInfo parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.TransactionInfo parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1.TransactionInfo parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.discoveryengine.v1.TransactionInfo prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * A transaction represents the entire purchase transaction.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1.TransactionInfo}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1.TransactionInfo)
      com.google.cloud.discoveryengine.v1.TransactionInfoOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1.UserEventProto
          .internal_static_google_cloud_discoveryengine_v1_TransactionInfo_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1.UserEventProto
          .internal_static_google_cloud_discoveryengine_v1_TransactionInfo_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1.TransactionInfo.class,
              com.google.cloud.discoveryengine.v1.TransactionInfo.Builder.class);
    }

    // Construct using com.google.cloud.discoveryengine.v1.TransactionInfo.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      value_ = 0F;
      currency_ = "";
      transactionId_ = "";
      tax_ = 0F;
      cost_ = 0F;
      discountValue_ = 0F;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.discoveryengine.v1.UserEventProto
          .internal_static_google_cloud_discoveryengine_v1_TransactionInfo_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.TransactionInfo getDefaultInstanceForType() {
      return com.google.cloud.discoveryengine.v1.TransactionInfo.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.TransactionInfo build() {
      com.google.cloud.discoveryengine.v1.TransactionInfo result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.TransactionInfo buildPartial() {
      com.google.cloud.discoveryengine.v1.TransactionInfo result =
          new com.google.cloud.discoveryengine.v1.TransactionInfo(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.discoveryengine.v1.TransactionInfo result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.value_ = value_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.currency_ = currency_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.transactionId_ = transactionId_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.tax_ = tax_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.cost_ = cost_;
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.discountValue_ = discountValue_;
        to_bitField0_ |= 0x00000008;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.discoveryengine.v1.TransactionInfo) {
        return mergeFrom((com.google.cloud.discoveryengine.v1.TransactionInfo) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.discoveryengine.v1.TransactionInfo other) {
      if (other == com.google.cloud.discoveryengine.v1.TransactionInfo.getDefaultInstance())
        return this;
      if (other.hasValue()) {
        setValue(other.getValue());
      }
      if (!other.getCurrency().isEmpty()) {
        currency_ = other.currency_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getTransactionId().isEmpty()) {
        transactionId_ = other.transactionId_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasTax()) {
        setTax(other.getTax());
      }
      if (other.hasCost()) {
        setCost(other.getCost());
      }
      if (other.hasDiscountValue()) {
        setDiscountValue(other.getDiscountValue());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 13:
              {
                value_ = input.readFloat();
                bitField0_ |= 0x00000001;
                break;
              } // case 13
            case 18:
              {
                currency_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                transactionId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 37:
              {
                tax_ = input.readFloat();
                bitField0_ |= 0x00000008;
                break;
              } // case 37
            case 45:
              {
                cost_ = input.readFloat();
                bitField0_ |= 0x00000010;
                break;
              } // case 45
            case 53:
              {
                discountValue_ = input.readFloat();
                bitField0_ |= 0x00000020;
                break;
              } // case 53
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private float value_;

    /**
     *
     *
     * <pre>
     * Required. Total non-zero value associated with the transaction. This value
     * may include shipping, tax, or other adjustments to the total value that you
     * want to include.
     * </pre>
     *
     * <code>optional float value = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return Whether the value field is set.
     */
    @java.lang.Override
    public boolean hasValue() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * Required. Total non-zero value associated with the transaction. This value
     * may include shipping, tax, or other adjustments to the total value that you
     * want to include.
     * </pre>
     *
     * <code>optional float value = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The value.
     */
    @java.lang.Override
    public float getValue() {
      return value_;
    }

    /**
     *
     *
     * <pre>
     * Required. Total non-zero value associated with the transaction. This value
     * may include shipping, tax, or other adjustments to the total value that you
     * want to include.
     * </pre>
     *
     * <code>optional float value = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The value to set.
     * @return This builder for chaining.
     */
    public Builder setValue(float value) {

      value_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Total non-zero value associated with the transaction. This value
     * may include shipping, tax, or other adjustments to the total value that you
     * want to include.
     * </pre>
     *
     * <code>optional float value = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearValue() {
      bitField0_ = (bitField0_ & ~0x00000001);
      value_ = 0F;
      onChanged();
      return this;
    }

    private java.lang.Object currency_ = "";

    /**
     *
     *
     * <pre>
     * Required. Currency code. Use three-character ISO-4217 code.
     * </pre>
     *
     * <code>string currency = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The currency.
     */
    public java.lang.String getCurrency() {
      java.lang.Object ref = currency_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        currency_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Currency code. Use three-character ISO-4217 code.
     * </pre>
     *
     * <code>string currency = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for currency.
     */
    public com.google.protobuf.ByteString getCurrencyBytes() {
      java.lang.Object ref = currency_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        currency_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Currency code. Use three-character ISO-4217 code.
     * </pre>
     *
     * <code>string currency = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The currency to set.
     * @return This builder for chaining.
     */
    public Builder setCurrency(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      currency_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Currency code. Use three-character ISO-4217 code.
     * </pre>
     *
     * <code>string currency = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCurrency() {
      currency_ = getDefaultInstance().getCurrency();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Currency code. Use three-character ISO-4217 code.
     * </pre>
     *
     * <code>string currency = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for currency to set.
     * @return This builder for chaining.
     */
    public Builder setCurrencyBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      currency_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object transactionId_ = "";

    /**
     *
     *
     * <pre>
     * The transaction ID with a length limit of 128 characters.
     * </pre>
     *
     * <code>string transaction_id = 3;</code>
     *
     * @return The transactionId.
     */
    public java.lang.String getTransactionId() {
      java.lang.Object ref = transactionId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        transactionId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The transaction ID with a length limit of 128 characters.
     * </pre>
     *
     * <code>string transaction_id = 3;</code>
     *
     * @return The bytes for transactionId.
     */
    public com.google.protobuf.ByteString getTransactionIdBytes() {
      java.lang.Object ref = transactionId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        transactionId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The transaction ID with a length limit of 128 characters.
     * </pre>
     *
     * <code>string transaction_id = 3;</code>
     *
     * @param value The transactionId to set.
     * @return This builder for chaining.
     */
    public Builder setTransactionId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      transactionId_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The transaction ID with a length limit of 128 characters.
     * </pre>
     *
     * <code>string transaction_id = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTransactionId() {
      transactionId_ = getDefaultInstance().getTransactionId();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The transaction ID with a length limit of 128 characters.
     * </pre>
     *
     * <code>string transaction_id = 3;</code>
     *
     * @param value The bytes for transactionId to set.
     * @return This builder for chaining.
     */
    public Builder setTransactionIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      transactionId_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private float tax_;

    /**
     *
     *
     * <pre>
     * All the taxes associated with the transaction.
     * </pre>
     *
     * <code>optional float tax = 4;</code>
     *
     * @return Whether the tax field is set.
     */
    @java.lang.Override
    public boolean hasTax() {
      return ((bitField0_ & 0x00000008) != 0);
    }

    /**
     *
     *
     * <pre>
     * All the taxes associated with the transaction.
     * </pre>
     *
     * <code>optional float tax = 4;</code>
     *
     * @return The tax.
     */
    @java.lang.Override
    public float getTax() {
      return tax_;
    }

    /**
     *
     *
     * <pre>
     * All the taxes associated with the transaction.
     * </pre>
     *
     * <code>optional float tax = 4;</code>
     *
     * @param value The tax to set.
     * @return This builder for chaining.
     */
    public Builder setTax(float value) {

      tax_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * All the taxes associated with the transaction.
     * </pre>
     *
     * <code>optional float tax = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTax() {
      bitField0_ = (bitField0_ & ~0x00000008);
      tax_ = 0F;
      onChanged();
      return this;
    }

    private float cost_;

    /**
     *
     *
     * <pre>
     * All the costs associated with the products. These can be manufacturing
     * costs, shipping expenses not borne by the end user, or any other costs,
     * such that:
     *
     * * Profit = [value][google.cloud.discoveryengine.v1.TransactionInfo.value] -
     * [tax][google.cloud.discoveryengine.v1.TransactionInfo.tax] -
     * [cost][google.cloud.discoveryengine.v1.TransactionInfo.cost]
     * </pre>
     *
     * <code>optional float cost = 5;</code>
     *
     * @return Whether the cost field is set.
     */
    @java.lang.Override
    public boolean hasCost() {
      return ((bitField0_ & 0x00000010) != 0);
    }

    /**
     *
     *
     * <pre>
     * All the costs associated with the products. These can be manufacturing
     * costs, shipping expenses not borne by the end user, or any other costs,
     * such that:
     *
     * * Profit = [value][google.cloud.discoveryengine.v1.TransactionInfo.value] -
     * [tax][google.cloud.discoveryengine.v1.TransactionInfo.tax] -
     * [cost][google.cloud.discoveryengine.v1.TransactionInfo.cost]
     * </pre>
     *
     * <code>optional float cost = 5;</code>
     *
     * @return The cost.
     */
    @java.lang.Override
    public float getCost() {
      return cost_;
    }

    /**
     *
     *
     * <pre>
     * All the costs associated with the products. These can be manufacturing
     * costs, shipping expenses not borne by the end user, or any other costs,
     * such that:
     *
     * * Profit = [value][google.cloud.discoveryengine.v1.TransactionInfo.value] -
     * [tax][google.cloud.discoveryengine.v1.TransactionInfo.tax] -
     * [cost][google.cloud.discoveryengine.v1.TransactionInfo.cost]
     * </pre>
     *
     * <code>optional float cost = 5;</code>
     *
     * @param value The cost to set.
     * @return This builder for chaining.
     */
    public Builder setCost(float value) {

      cost_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * All the costs associated with the products. These can be manufacturing
     * costs, shipping expenses not borne by the end user, or any other costs,
     * such that:
     *
     * * Profit = [value][google.cloud.discoveryengine.v1.TransactionInfo.value] -
     * [tax][google.cloud.discoveryengine.v1.TransactionInfo.tax] -
     * [cost][google.cloud.discoveryengine.v1.TransactionInfo.cost]
     * </pre>
     *
     * <code>optional float cost = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCost() {
      bitField0_ = (bitField0_ & ~0x00000010);
      cost_ = 0F;
      onChanged();
      return this;
    }

    private float discountValue_;

    /**
     *
     *
     * <pre>
     * The total discount(s) value applied to this transaction.
     * This figure should be excluded from
     * [TransactionInfo.value][google.cloud.discoveryengine.v1.TransactionInfo.value]
     *
     * For example, if a user paid
     * [TransactionInfo.value][google.cloud.discoveryengine.v1.TransactionInfo.value]
     * amount, then nominal (pre-discount) value of the transaction is the sum of
     * [TransactionInfo.value][google.cloud.discoveryengine.v1.TransactionInfo.value]
     * and
     * [TransactionInfo.discount_value][google.cloud.discoveryengine.v1.TransactionInfo.discount_value]
     *
     * This means that profit is calculated the same way, regardless of the
     * discount value, and that
     * [TransactionInfo.discount_value][google.cloud.discoveryengine.v1.TransactionInfo.discount_value]
     * can be larger than
     * [TransactionInfo.value][google.cloud.discoveryengine.v1.TransactionInfo.value]:
     *
     * * Profit = [value][google.cloud.discoveryengine.v1.TransactionInfo.value] -
     * [tax][google.cloud.discoveryengine.v1.TransactionInfo.tax] -
     * [cost][google.cloud.discoveryengine.v1.TransactionInfo.cost]
     * </pre>
     *
     * <code>optional float discount_value = 6;</code>
     *
     * @return Whether the discountValue field is set.
     */
    @java.lang.Override
    public boolean hasDiscountValue() {
      return ((bitField0_ & 0x00000020) != 0);
    }

    /**
     *
     *
     * <pre>
     * The total discount(s) value applied to this transaction.
     * This figure should be excluded from
     * [TransactionInfo.value][google.cloud.discoveryengine.v1.TransactionInfo.value]
     *
     * For example, if a user paid
     * [TransactionInfo.value][google.cloud.discoveryengine.v1.TransactionInfo.value]
     * amount, then nominal (pre-discount) value of the transaction is the sum of
     * [TransactionInfo.value][google.cloud.discoveryengine.v1.TransactionInfo.value]
     * and
     * [TransactionInfo.discount_value][google.cloud.discoveryengine.v1.TransactionInfo.discount_value]
     *
     * This means that profit is calculated the same way, regardless of the
     * discount value, and that
     * [TransactionInfo.discount_value][google.cloud.discoveryengine.v1.TransactionInfo.discount_value]
     * can be larger than
     * [TransactionInfo.value][google.cloud.discoveryengine.v1.TransactionInfo.value]:
     *
     * * Profit = [value][google.cloud.discoveryengine.v1.TransactionInfo.value] -
     * [tax][google.cloud.discoveryengine.v1.TransactionInfo.tax] -
     * [cost][google.cloud.discoveryengine.v1.TransactionInfo.cost]
     * </pre>
     *
     * <code>optional float discount_value = 6;</code>
     *
     * @return The discountValue.
     */
    @java.lang.Override
    public float getDiscountValue() {
      return discountValue_;
    }

    /**
     *
     *
     * <pre>
     * The total discount(s) value applied to this transaction.
     * This figure should be excluded from
     * [TransactionInfo.value][google.cloud.discoveryengine.v1.TransactionInfo.value]
     *
     * For example, if a user paid
     * [TransactionInfo.value][google.cloud.discoveryengine.v1.TransactionInfo.value]
     * amount, then nominal (pre-discount) value of the transaction is the sum of
     * [TransactionInfo.value][google.cloud.discoveryengine.v1.TransactionInfo.value]
     * and
     * [TransactionInfo.discount_value][google.cloud.discoveryengine.v1.TransactionInfo.discount_value]
     *
     * This means that profit is calculated the same way, regardless of the
     * discount value, and that
     * [TransactionInfo.discount_value][google.cloud.discoveryengine.v1.TransactionInfo.discount_value]
     * can be larger than
     * [TransactionInfo.value][google.cloud.discoveryengine.v1.TransactionInfo.value]:
     *
     * * Profit = [value][google.cloud.discoveryengine.v1.TransactionInfo.value] -
     * [tax][google.cloud.discoveryengine.v1.TransactionInfo.tax] -
     * [cost][google.cloud.discoveryengine.v1.TransactionInfo.cost]
     * </pre>
     *
     * <code>optional float discount_value = 6;</code>
     *
     * @param value The discountValue to set.
     * @return This builder for chaining.
     */
    public Builder setDiscountValue(float value) {

      discountValue_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The total discount(s) value applied to this transaction.
     * This figure should be excluded from
     * [TransactionInfo.value][google.cloud.discoveryengine.v1.TransactionInfo.value]
     *
     * For example, if a user paid
     * [TransactionInfo.value][google.cloud.discoveryengine.v1.TransactionInfo.value]
     * amount, then nominal (pre-discount) value of the transaction is the sum of
     * [TransactionInfo.value][google.cloud.discoveryengine.v1.TransactionInfo.value]
     * and
     * [TransactionInfo.discount_value][google.cloud.discoveryengine.v1.TransactionInfo.discount_value]
     *
     * This means that profit is calculated the same way, regardless of the
     * discount value, and that
     * [TransactionInfo.discount_value][google.cloud.discoveryengine.v1.TransactionInfo.discount_value]
     * can be larger than
     * [TransactionInfo.value][google.cloud.discoveryengine.v1.TransactionInfo.value]:
     *
     * * Profit = [value][google.cloud.discoveryengine.v1.TransactionInfo.value] -
     * [tax][google.cloud.discoveryengine.v1.TransactionInfo.tax] -
     * [cost][google.cloud.discoveryengine.v1.TransactionInfo.cost]
     * </pre>
     *
     * <code>optional float discount_value = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDiscountValue() {
      bitField0_ = (bitField0_ & ~0x00000020);
      discountValue_ = 0F;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1.TransactionInfo)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1.TransactionInfo)
  private static final com.google.cloud.discoveryengine.v1.TransactionInfo DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.discoveryengine.v1.TransactionInfo();
  }

  public static com.google.cloud.discoveryengine.v1.TransactionInfo getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<TransactionInfo> PARSER =
      new com.google.protobuf.AbstractParser<TransactionInfo>() {
        @java.lang.Override
        public TransactionInfo parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<TransactionInfo> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<TransactionInfo> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.TransactionInfo getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
