/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/discoveryengine/v1/user_event.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.discoveryengine.v1;

/**
 *
 *
 * <pre>
 * UserEvent captures all metadata information Discovery Engine API needs to
 * know about how end users interact with your website.
 * </pre>
 *
 * Protobuf type {@code google.cloud.discoveryengine.v1.UserEvent}
 */
public final class UserEvent extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1.UserEvent)
    UserEventOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use UserEvent.newBuilder() to construct.
  private UserEvent(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private UserEvent() {
    eventType_ = "";
    conversionType_ = "";
    userPseudoId_ = "";
    engine_ = "";
    dataStore_ = "";
    sessionId_ = "";
    attributionToken_ = "";
    filter_ = "";
    documents_ = java.util.Collections.emptyList();
    tagIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
    promotionIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
    panels_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new UserEvent();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.discoveryengine.v1.UserEventProto
        .internal_static_google_cloud_discoveryengine_v1_UserEvent_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 17:
        return internalGetAttributes();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.discoveryengine.v1.UserEventProto
        .internal_static_google_cloud_discoveryengine_v1_UserEvent_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.discoveryengine.v1.UserEvent.class,
            com.google.cloud.discoveryengine.v1.UserEvent.Builder.class);
  }

  private int bitField0_;
  public static final int EVENT_TYPE_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object eventType_ = "";

  /**
   *
   *
   * <pre>
   * Required. User event type. Allowed values are:
   *
   * Generic values:
   *
   * * `search`: Search for Documents.
   * * `view-item`: Detailed page view of a Document.
   * * `view-item-list`: View of a panel or ordered list of Documents.
   * * `view-home-page`: View of the home page.
   * * `view-category-page`: View of a category page, e.g. Home &gt; Men &gt; Jeans
   * * `add-feedback`: Add a user feedback.
   *
   * Retail-related values:
   *
   * * `add-to-cart`: Add an item(s) to cart, e.g. in Retail online shopping
   * * `purchase`: Purchase an item(s)
   *
   * Media-related values:
   *
   * * `media-play`: Start/resume watching a video, playing a song, etc.
   * * `media-complete`: Finished or stopped midway through a video, song, etc.
   *
   * Custom conversion value:
   *
   * * `conversion`: Customer defined conversion event.
   * </pre>
   *
   * <code>string event_type = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The eventType.
   */
  @java.lang.Override
  public java.lang.String getEventType() {
    java.lang.Object ref = eventType_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      eventType_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. User event type. Allowed values are:
   *
   * Generic values:
   *
   * * `search`: Search for Documents.
   * * `view-item`: Detailed page view of a Document.
   * * `view-item-list`: View of a panel or ordered list of Documents.
   * * `view-home-page`: View of the home page.
   * * `view-category-page`: View of a category page, e.g. Home &gt; Men &gt; Jeans
   * * `add-feedback`: Add a user feedback.
   *
   * Retail-related values:
   *
   * * `add-to-cart`: Add an item(s) to cart, e.g. in Retail online shopping
   * * `purchase`: Purchase an item(s)
   *
   * Media-related values:
   *
   * * `media-play`: Start/resume watching a video, playing a song, etc.
   * * `media-complete`: Finished or stopped midway through a video, song, etc.
   *
   * Custom conversion value:
   *
   * * `conversion`: Customer defined conversion event.
   * </pre>
   *
   * <code>string event_type = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for eventType.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEventTypeBytes() {
    java.lang.Object ref = eventType_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      eventType_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CONVERSION_TYPE_FIELD_NUMBER = 21;

  @SuppressWarnings("serial")
  private volatile java.lang.Object conversionType_ = "";

  /**
   *
   *
   * <pre>
   * Optional. Conversion type.
   *
   * Required if
   * [UserEvent.event_type][google.cloud.discoveryengine.v1.UserEvent.event_type]
   * is `conversion`. This is a customer-defined conversion name in lowercase
   * letters or numbers separated by "-", such as "watch", "good-visit" etc.
   *
   * Do not set the field if
   * [UserEvent.event_type][google.cloud.discoveryengine.v1.UserEvent.event_type]
   * is not `conversion`. This mixes the custom conversion event with predefined
   * events like `search`, `view-item` etc.
   * </pre>
   *
   * <code>string conversion_type = 21 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The conversionType.
   */
  @java.lang.Override
  public java.lang.String getConversionType() {
    java.lang.Object ref = conversionType_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      conversionType_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. Conversion type.
   *
   * Required if
   * [UserEvent.event_type][google.cloud.discoveryengine.v1.UserEvent.event_type]
   * is `conversion`. This is a customer-defined conversion name in lowercase
   * letters or numbers separated by "-", such as "watch", "good-visit" etc.
   *
   * Do not set the field if
   * [UserEvent.event_type][google.cloud.discoveryengine.v1.UserEvent.event_type]
   * is not `conversion`. This mixes the custom conversion event with predefined
   * events like `search`, `view-item` etc.
   * </pre>
   *
   * <code>string conversion_type = 21 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for conversionType.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getConversionTypeBytes() {
    java.lang.Object ref = conversionType_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      conversionType_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int USER_PSEUDO_ID_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object userPseudoId_ = "";

  /**
   *
   *
   * <pre>
   * Required. A unique identifier for tracking visitors.
   *
   * For example, this could be implemented with an HTTP cookie, which should be
   * able to uniquely identify a visitor on a single device. This unique
   * identifier should not change if the visitor log in/out of the website.
   *
   * Do not set the field to the same fixed ID for different users. This mixes
   * the event history of those users together, which results in degraded model
   * quality.
   *
   * The field must be a UTF-8 encoded string with a length limit of 128
   * characters. Otherwise, an `INVALID_ARGUMENT` error is returned.
   *
   * The field should not contain PII or user-data. We recommend to use Google
   * Analytics [Client
   * ID](https://developers.google.com/analytics/devguides/collection/analyticsjs/field-reference#clientId)
   * for this field.
   * </pre>
   *
   * <code>string user_pseudo_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The userPseudoId.
   */
  @java.lang.Override
  public java.lang.String getUserPseudoId() {
    java.lang.Object ref = userPseudoId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      userPseudoId_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. A unique identifier for tracking visitors.
   *
   * For example, this could be implemented with an HTTP cookie, which should be
   * able to uniquely identify a visitor on a single device. This unique
   * identifier should not change if the visitor log in/out of the website.
   *
   * Do not set the field to the same fixed ID for different users. This mixes
   * the event history of those users together, which results in degraded model
   * quality.
   *
   * The field must be a UTF-8 encoded string with a length limit of 128
   * characters. Otherwise, an `INVALID_ARGUMENT` error is returned.
   *
   * The field should not contain PII or user-data. We recommend to use Google
   * Analytics [Client
   * ID](https://developers.google.com/analytics/devguides/collection/analyticsjs/field-reference#clientId)
   * for this field.
   * </pre>
   *
   * <code>string user_pseudo_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for userPseudoId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getUserPseudoIdBytes() {
    java.lang.Object ref = userPseudoId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      userPseudoId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ENGINE_FIELD_NUMBER = 19;

  @SuppressWarnings("serial")
  private volatile java.lang.Object engine_ = "";

  /**
   *
   *
   * <pre>
   * The [Engine][google.cloud.discoveryengine.v1.Engine] resource name, in the
   * form of
   * `projects/{project}/locations/{location}/collections/{collection_id}/engines/{engine_id}`.
   *
   * Optional. Only required for
   * [Engine][google.cloud.discoveryengine.v1.Engine] produced user events. For
   * example, user events from blended search.
   * </pre>
   *
   * <code>string engine = 19 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The engine.
   */
  @java.lang.Override
  public java.lang.String getEngine() {
    java.lang.Object ref = engine_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      engine_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The [Engine][google.cloud.discoveryengine.v1.Engine] resource name, in the
   * form of
   * `projects/{project}/locations/{location}/collections/{collection_id}/engines/{engine_id}`.
   *
   * Optional. Only required for
   * [Engine][google.cloud.discoveryengine.v1.Engine] produced user events. For
   * example, user events from blended search.
   * </pre>
   *
   * <code>string engine = 19 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for engine.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEngineBytes() {
    java.lang.Object ref = engine_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      engine_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DATA_STORE_FIELD_NUMBER = 20;

  @SuppressWarnings("serial")
  private volatile java.lang.Object dataStore_ = "";

  /**
   *
   *
   * <pre>
   * The [DataStore][google.cloud.discoveryengine.v1.DataStore] resource full
   * name, of the form
   * `projects/{project}/locations/{location}/collections/{collection_id}/dataStores/{data_store_id}`.
   *
   * Optional. Only required for user events whose data store can't by
   * determined by
   * [UserEvent.engine][google.cloud.discoveryengine.v1.UserEvent.engine] or
   * [UserEvent.documents][google.cloud.discoveryengine.v1.UserEvent.documents].
   * If data store is set in the parent of write/import/collect user event
   * requests, this field can be omitted.
   * </pre>
   *
   * <code>string data_store = 20 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The dataStore.
   */
  @java.lang.Override
  public java.lang.String getDataStore() {
    java.lang.Object ref = dataStore_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      dataStore_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The [DataStore][google.cloud.discoveryengine.v1.DataStore] resource full
   * name, of the form
   * `projects/{project}/locations/{location}/collections/{collection_id}/dataStores/{data_store_id}`.
   *
   * Optional. Only required for user events whose data store can't by
   * determined by
   * [UserEvent.engine][google.cloud.discoveryengine.v1.UserEvent.engine] or
   * [UserEvent.documents][google.cloud.discoveryengine.v1.UserEvent.documents].
   * If data store is set in the parent of write/import/collect user event
   * requests, this field can be omitted.
   * </pre>
   *
   * <code>string data_store = 20 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for dataStore.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDataStoreBytes() {
    java.lang.Object ref = dataStore_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      dataStore_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int EVENT_TIME_FIELD_NUMBER = 3;
  private com.google.protobuf.Timestamp eventTime_;

  /**
   *
   *
   * <pre>
   * Only required for
   * [UserEventService.ImportUserEvents][google.cloud.discoveryengine.v1.UserEventService.ImportUserEvents]
   * method. Timestamp of when the user event happened.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp event_time = 3;</code>
   *
   * @return Whether the eventTime field is set.
   */
  @java.lang.Override
  public boolean hasEventTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Only required for
   * [UserEventService.ImportUserEvents][google.cloud.discoveryengine.v1.UserEventService.ImportUserEvents]
   * method. Timestamp of when the user event happened.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp event_time = 3;</code>
   *
   * @return The eventTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getEventTime() {
    return eventTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : eventTime_;
  }

  /**
   *
   *
   * <pre>
   * Only required for
   * [UserEventService.ImportUserEvents][google.cloud.discoveryengine.v1.UserEventService.ImportUserEvents]
   * method. Timestamp of when the user event happened.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp event_time = 3;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getEventTimeOrBuilder() {
    return eventTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : eventTime_;
  }

  public static final int USER_INFO_FIELD_NUMBER = 4;
  private com.google.cloud.discoveryengine.v1.UserInfo userInfo_;

  /**
   *
   *
   * <pre>
   * Information about the end user.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1.UserInfo user_info = 4;</code>
   *
   * @return Whether the userInfo field is set.
   */
  @java.lang.Override
  public boolean hasUserInfo() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Information about the end user.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1.UserInfo user_info = 4;</code>
   *
   * @return The userInfo.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.UserInfo getUserInfo() {
    return userInfo_ == null
        ? com.google.cloud.discoveryengine.v1.UserInfo.getDefaultInstance()
        : userInfo_;
  }

  /**
   *
   *
   * <pre>
   * Information about the end user.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1.UserInfo user_info = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.UserInfoOrBuilder getUserInfoOrBuilder() {
    return userInfo_ == null
        ? com.google.cloud.discoveryengine.v1.UserInfo.getDefaultInstance()
        : userInfo_;
  }

  public static final int DIRECT_USER_REQUEST_FIELD_NUMBER = 5;
  private boolean directUserRequest_ = false;

  /**
   *
   *
   * <pre>
   * Should set to true if the request is made directly from the end user, in
   * which case the
   * [UserEvent.user_info.user_agent][google.cloud.discoveryengine.v1.UserInfo.user_agent]
   * can be populated from the HTTP request.
   *
   * This flag should be set only if the API request is made directly from the
   * end user such as a mobile app (and not if a gateway or a server is
   * processing and pushing the user events).
   *
   * This should not be set when using the JavaScript tag in
   * [UserEventService.CollectUserEvent][google.cloud.discoveryengine.v1.UserEventService.CollectUserEvent].
   * </pre>
   *
   * <code>bool direct_user_request = 5;</code>
   *
   * @return The directUserRequest.
   */
  @java.lang.Override
  public boolean getDirectUserRequest() {
    return directUserRequest_;
  }

  public static final int SESSION_ID_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object sessionId_ = "";

  /**
   *
   *
   * <pre>
   * A unique identifier for tracking a visitor session with a length limit of
   * 128 bytes. A session is an aggregation of an end user behavior in a time
   * span.
   *
   * A general guideline to populate the session_id:
   *
   * 1. If user has no activity for 30 min, a new session_id should be assigned.
   * 2. The session_id should be unique across users, suggest use uuid or add
   * [UserEvent.user_pseudo_id][google.cloud.discoveryengine.v1.UserEvent.user_pseudo_id]
   * as prefix.
   * </pre>
   *
   * <code>string session_id = 6;</code>
   *
   * @return The sessionId.
   */
  @java.lang.Override
  public java.lang.String getSessionId() {
    java.lang.Object ref = sessionId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      sessionId_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * A unique identifier for tracking a visitor session with a length limit of
   * 128 bytes. A session is an aggregation of an end user behavior in a time
   * span.
   *
   * A general guideline to populate the session_id:
   *
   * 1. If user has no activity for 30 min, a new session_id should be assigned.
   * 2. The session_id should be unique across users, suggest use uuid or add
   * [UserEvent.user_pseudo_id][google.cloud.discoveryengine.v1.UserEvent.user_pseudo_id]
   * as prefix.
   * </pre>
   *
   * <code>string session_id = 6;</code>
   *
   * @return The bytes for sessionId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSessionIdBytes() {
    java.lang.Object ref = sessionId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      sessionId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PAGE_INFO_FIELD_NUMBER = 7;
  private com.google.cloud.discoveryengine.v1.PageInfo pageInfo_;

  /**
   *
   *
   * <pre>
   * Page metadata such as categories and other critical information for certain
   * event types such as `view-category-page`.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1.PageInfo page_info = 7;</code>
   *
   * @return Whether the pageInfo field is set.
   */
  @java.lang.Override
  public boolean hasPageInfo() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * Page metadata such as categories and other critical information for certain
   * event types such as `view-category-page`.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1.PageInfo page_info = 7;</code>
   *
   * @return The pageInfo.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.PageInfo getPageInfo() {
    return pageInfo_ == null
        ? com.google.cloud.discoveryengine.v1.PageInfo.getDefaultInstance()
        : pageInfo_;
  }

  /**
   *
   *
   * <pre>
   * Page metadata such as categories and other critical information for certain
   * event types such as `view-category-page`.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1.PageInfo page_info = 7;</code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.PageInfoOrBuilder getPageInfoOrBuilder() {
    return pageInfo_ == null
        ? com.google.cloud.discoveryengine.v1.PageInfo.getDefaultInstance()
        : pageInfo_;
  }

  public static final int ATTRIBUTION_TOKEN_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private volatile java.lang.Object attributionToken_ = "";

  /**
   *
   *
   * <pre>
   * Token to attribute an API response to user action(s) to trigger the event.
   *
   * Highly recommended for user events that are the result of
   * [RecommendationService.Recommend][google.cloud.discoveryengine.v1.RecommendationService.Recommend].
   * This field enables accurate attribution of recommendation model
   * performance.
   *
   * The value must be one of:
   *
   * * [RecommendResponse.attribution_token][google.cloud.discoveryengine.v1.RecommendResponse.attribution_token] for events that are the result of
   * [RecommendationService.Recommend][google.cloud.discoveryengine.v1.RecommendationService.Recommend].
   * * [SearchResponse.attribution_token][google.cloud.discoveryengine.v1.SearchResponse.attribution_token] for events that are the result of
   * [SearchService.Search][google.cloud.discoveryengine.v1.SearchService.Search].
   *
   * This token enables us to accurately attribute page view or conversion
   * completion back to the event and the particular predict response containing
   * this clicked/purchased product. If user clicks on product K in the
   * recommendation results, pass
   * [RecommendResponse.attribution_token][google.cloud.discoveryengine.v1.RecommendResponse.attribution_token]
   * as a URL parameter to product K's page. When recording events on product
   * K's page, log the
   * [RecommendResponse.attribution_token][google.cloud.discoveryengine.v1.RecommendResponse.attribution_token]
   * to this field.
   * </pre>
   *
   * <code>string attribution_token = 8;</code>
   *
   * @return The attributionToken.
   */
  @java.lang.Override
  public java.lang.String getAttributionToken() {
    java.lang.Object ref = attributionToken_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      attributionToken_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Token to attribute an API response to user action(s) to trigger the event.
   *
   * Highly recommended for user events that are the result of
   * [RecommendationService.Recommend][google.cloud.discoveryengine.v1.RecommendationService.Recommend].
   * This field enables accurate attribution of recommendation model
   * performance.
   *
   * The value must be one of:
   *
   * * [RecommendResponse.attribution_token][google.cloud.discoveryengine.v1.RecommendResponse.attribution_token] for events that are the result of
   * [RecommendationService.Recommend][google.cloud.discoveryengine.v1.RecommendationService.Recommend].
   * * [SearchResponse.attribution_token][google.cloud.discoveryengine.v1.SearchResponse.attribution_token] for events that are the result of
   * [SearchService.Search][google.cloud.discoveryengine.v1.SearchService.Search].
   *
   * This token enables us to accurately attribute page view or conversion
   * completion back to the event and the particular predict response containing
   * this clicked/purchased product. If user clicks on product K in the
   * recommendation results, pass
   * [RecommendResponse.attribution_token][google.cloud.discoveryengine.v1.RecommendResponse.attribution_token]
   * as a URL parameter to product K's page. When recording events on product
   * K's page, log the
   * [RecommendResponse.attribution_token][google.cloud.discoveryengine.v1.RecommendResponse.attribution_token]
   * to this field.
   * </pre>
   *
   * <code>string attribution_token = 8;</code>
   *
   * @return The bytes for attributionToken.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getAttributionTokenBytes() {
    java.lang.Object ref = attributionToken_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      attributionToken_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FILTER_FIELD_NUMBER = 9;

  @SuppressWarnings("serial")
  private volatile java.lang.Object filter_ = "";

  /**
   *
   *
   * <pre>
   * The filter syntax consists of an expression language for constructing a
   * predicate from one or more fields of the documents being filtered.
   *
   * One example is for `search` events, the associated
   * [SearchRequest][google.cloud.discoveryengine.v1.SearchRequest] may contain
   * a filter expression in
   * [SearchRequest.filter][google.cloud.discoveryengine.v1.SearchRequest.filter]
   * conforming to https://google.aip.dev/160#filtering.
   *
   * Similarly, for `view-item-list` events that are generated from a
   * [RecommendRequest][google.cloud.discoveryengine.v1.RecommendRequest], this
   * field may be populated directly from
   * [RecommendRequest.filter][google.cloud.discoveryengine.v1.RecommendRequest.filter]
   * conforming to https://google.aip.dev/160#filtering.
   *
   * The value must be a UTF-8 encoded string with a length limit of 1,000
   * characters. Otherwise, an `INVALID_ARGUMENT` error is returned.
   * </pre>
   *
   * <code>string filter = 9;</code>
   *
   * @return The filter.
   */
  @java.lang.Override
  public java.lang.String getFilter() {
    java.lang.Object ref = filter_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      filter_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The filter syntax consists of an expression language for constructing a
   * predicate from one or more fields of the documents being filtered.
   *
   * One example is for `search` events, the associated
   * [SearchRequest][google.cloud.discoveryengine.v1.SearchRequest] may contain
   * a filter expression in
   * [SearchRequest.filter][google.cloud.discoveryengine.v1.SearchRequest.filter]
   * conforming to https://google.aip.dev/160#filtering.
   *
   * Similarly, for `view-item-list` events that are generated from a
   * [RecommendRequest][google.cloud.discoveryengine.v1.RecommendRequest], this
   * field may be populated directly from
   * [RecommendRequest.filter][google.cloud.discoveryengine.v1.RecommendRequest.filter]
   * conforming to https://google.aip.dev/160#filtering.
   *
   * The value must be a UTF-8 encoded string with a length limit of 1,000
   * characters. Otherwise, an `INVALID_ARGUMENT` error is returned.
   * </pre>
   *
   * <code>string filter = 9;</code>
   *
   * @return The bytes for filter.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFilterBytes() {
    java.lang.Object ref = filter_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      filter_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DOCUMENTS_FIELD_NUMBER = 10;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.discoveryengine.v1.DocumentInfo> documents_;

  /**
   *
   *
   * <pre>
   * List of [Document][google.cloud.discoveryengine.v1.Document]s associated
   * with this user event.
   *
   * This field is optional except for the following event types:
   *
   * * `view-item`
   * * `add-to-cart`
   * * `purchase`
   * * `media-play`
   * * `media-complete`
   *
   * In a `search` event, this field represents the documents returned to the
   * end user on the current page (the end user may have not finished browsing
   * the whole page yet). When a new page is returned to the end user, after
   * pagination/filtering/ordering even for the same query, a new `search` event
   * with different
   * [UserEvent.documents][google.cloud.discoveryengine.v1.UserEvent.documents]
   * is desired.
   * </pre>
   *
   * <code>repeated .google.cloud.discoveryengine.v1.DocumentInfo documents = 10;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.discoveryengine.v1.DocumentInfo> getDocumentsList() {
    return documents_;
  }

  /**
   *
   *
   * <pre>
   * List of [Document][google.cloud.discoveryengine.v1.Document]s associated
   * with this user event.
   *
   * This field is optional except for the following event types:
   *
   * * `view-item`
   * * `add-to-cart`
   * * `purchase`
   * * `media-play`
   * * `media-complete`
   *
   * In a `search` event, this field represents the documents returned to the
   * end user on the current page (the end user may have not finished browsing
   * the whole page yet). When a new page is returned to the end user, after
   * pagination/filtering/ordering even for the same query, a new `search` event
   * with different
   * [UserEvent.documents][google.cloud.discoveryengine.v1.UserEvent.documents]
   * is desired.
   * </pre>
   *
   * <code>repeated .google.cloud.discoveryengine.v1.DocumentInfo documents = 10;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.discoveryengine.v1.DocumentInfoOrBuilder>
      getDocumentsOrBuilderList() {
    return documents_;
  }

  /**
   *
   *
   * <pre>
   * List of [Document][google.cloud.discoveryengine.v1.Document]s associated
   * with this user event.
   *
   * This field is optional except for the following event types:
   *
   * * `view-item`
   * * `add-to-cart`
   * * `purchase`
   * * `media-play`
   * * `media-complete`
   *
   * In a `search` event, this field represents the documents returned to the
   * end user on the current page (the end user may have not finished browsing
   * the whole page yet). When a new page is returned to the end user, after
   * pagination/filtering/ordering even for the same query, a new `search` event
   * with different
   * [UserEvent.documents][google.cloud.discoveryengine.v1.UserEvent.documents]
   * is desired.
   * </pre>
   *
   * <code>repeated .google.cloud.discoveryengine.v1.DocumentInfo documents = 10;</code>
   */
  @java.lang.Override
  public int getDocumentsCount() {
    return documents_.size();
  }

  /**
   *
   *
   * <pre>
   * List of [Document][google.cloud.discoveryengine.v1.Document]s associated
   * with this user event.
   *
   * This field is optional except for the following event types:
   *
   * * `view-item`
   * * `add-to-cart`
   * * `purchase`
   * * `media-play`
   * * `media-complete`
   *
   * In a `search` event, this field represents the documents returned to the
   * end user on the current page (the end user may have not finished browsing
   * the whole page yet). When a new page is returned to the end user, after
   * pagination/filtering/ordering even for the same query, a new `search` event
   * with different
   * [UserEvent.documents][google.cloud.discoveryengine.v1.UserEvent.documents]
   * is desired.
   * </pre>
   *
   * <code>repeated .google.cloud.discoveryengine.v1.DocumentInfo documents = 10;</code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.DocumentInfo getDocuments(int index) {
    return documents_.get(index);
  }

  /**
   *
   *
   * <pre>
   * List of [Document][google.cloud.discoveryengine.v1.Document]s associated
   * with this user event.
   *
   * This field is optional except for the following event types:
   *
   * * `view-item`
   * * `add-to-cart`
   * * `purchase`
   * * `media-play`
   * * `media-complete`
   *
   * In a `search` event, this field represents the documents returned to the
   * end user on the current page (the end user may have not finished browsing
   * the whole page yet). When a new page is returned to the end user, after
   * pagination/filtering/ordering even for the same query, a new `search` event
   * with different
   * [UserEvent.documents][google.cloud.discoveryengine.v1.UserEvent.documents]
   * is desired.
   * </pre>
   *
   * <code>repeated .google.cloud.discoveryengine.v1.DocumentInfo documents = 10;</code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.DocumentInfoOrBuilder getDocumentsOrBuilder(
      int index) {
    return documents_.get(index);
  }

  public static final int PANEL_FIELD_NUMBER = 11;
  private com.google.cloud.discoveryengine.v1.PanelInfo panel_;

  /**
   *
   *
   * <pre>
   * Panel metadata associated with this user event.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1.PanelInfo panel = 11;</code>
   *
   * @return Whether the panel field is set.
   */
  @java.lang.Override
  public boolean hasPanel() {
    return ((bitField0_ & 0x00000008) != 0);
  }

  /**
   *
   *
   * <pre>
   * Panel metadata associated with this user event.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1.PanelInfo panel = 11;</code>
   *
   * @return The panel.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.PanelInfo getPanel() {
    return panel_ == null
        ? com.google.cloud.discoveryengine.v1.PanelInfo.getDefaultInstance()
        : panel_;
  }

  /**
   *
   *
   * <pre>
   * Panel metadata associated with this user event.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1.PanelInfo panel = 11;</code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.PanelInfoOrBuilder getPanelOrBuilder() {
    return panel_ == null
        ? com.google.cloud.discoveryengine.v1.PanelInfo.getDefaultInstance()
        : panel_;
  }

  public static final int SEARCH_INFO_FIELD_NUMBER = 12;
  private com.google.cloud.discoveryengine.v1.SearchInfo searchInfo_;

  /**
   *
   *
   * <pre>
   * [SearchService.Search][google.cloud.discoveryengine.v1.SearchService.Search]
   * details related to the event.
   *
   * This field should be set for `search` event.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1.SearchInfo search_info = 12;</code>
   *
   * @return Whether the searchInfo field is set.
   */
  @java.lang.Override
  public boolean hasSearchInfo() {
    return ((bitField0_ & 0x00000010) != 0);
  }

  /**
   *
   *
   * <pre>
   * [SearchService.Search][google.cloud.discoveryengine.v1.SearchService.Search]
   * details related to the event.
   *
   * This field should be set for `search` event.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1.SearchInfo search_info = 12;</code>
   *
   * @return The searchInfo.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.SearchInfo getSearchInfo() {
    return searchInfo_ == null
        ? com.google.cloud.discoveryengine.v1.SearchInfo.getDefaultInstance()
        : searchInfo_;
  }

  /**
   *
   *
   * <pre>
   * [SearchService.Search][google.cloud.discoveryengine.v1.SearchService.Search]
   * details related to the event.
   *
   * This field should be set for `search` event.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1.SearchInfo search_info = 12;</code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.SearchInfoOrBuilder getSearchInfoOrBuilder() {
    return searchInfo_ == null
        ? com.google.cloud.discoveryengine.v1.SearchInfo.getDefaultInstance()
        : searchInfo_;
  }

  public static final int COMPLETION_INFO_FIELD_NUMBER = 13;
  private com.google.cloud.discoveryengine.v1.CompletionInfo completionInfo_;

  /**
   *
   *
   * <pre>
   * [CompletionService.CompleteQuery][google.cloud.discoveryengine.v1.CompletionService.CompleteQuery]
   * details related to the event.
   *
   * This field should be set for `search` event when autocomplete function is
   * enabled and the user clicks a suggestion for search.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1.CompletionInfo completion_info = 13;</code>
   *
   * @return Whether the completionInfo field is set.
   */
  @java.lang.Override
  public boolean hasCompletionInfo() {
    return ((bitField0_ & 0x00000020) != 0);
  }

  /**
   *
   *
   * <pre>
   * [CompletionService.CompleteQuery][google.cloud.discoveryengine.v1.CompletionService.CompleteQuery]
   * details related to the event.
   *
   * This field should be set for `search` event when autocomplete function is
   * enabled and the user clicks a suggestion for search.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1.CompletionInfo completion_info = 13;</code>
   *
   * @return The completionInfo.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.CompletionInfo getCompletionInfo() {
    return completionInfo_ == null
        ? com.google.cloud.discoveryengine.v1.CompletionInfo.getDefaultInstance()
        : completionInfo_;
  }

  /**
   *
   *
   * <pre>
   * [CompletionService.CompleteQuery][google.cloud.discoveryengine.v1.CompletionService.CompleteQuery]
   * details related to the event.
   *
   * This field should be set for `search` event when autocomplete function is
   * enabled and the user clicks a suggestion for search.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1.CompletionInfo completion_info = 13;</code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.CompletionInfoOrBuilder getCompletionInfoOrBuilder() {
    return completionInfo_ == null
        ? com.google.cloud.discoveryengine.v1.CompletionInfo.getDefaultInstance()
        : completionInfo_;
  }

  public static final int TRANSACTION_INFO_FIELD_NUMBER = 14;
  private com.google.cloud.discoveryengine.v1.TransactionInfo transactionInfo_;

  /**
   *
   *
   * <pre>
   * The transaction metadata (if any) associated with this user event.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1.TransactionInfo transaction_info = 14;</code>
   *
   * @return Whether the transactionInfo field is set.
   */
  @java.lang.Override
  public boolean hasTransactionInfo() {
    return ((bitField0_ & 0x00000040) != 0);
  }

  /**
   *
   *
   * <pre>
   * The transaction metadata (if any) associated with this user event.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1.TransactionInfo transaction_info = 14;</code>
   *
   * @return The transactionInfo.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.TransactionInfo getTransactionInfo() {
    return transactionInfo_ == null
        ? com.google.cloud.discoveryengine.v1.TransactionInfo.getDefaultInstance()
        : transactionInfo_;
  }

  /**
   *
   *
   * <pre>
   * The transaction metadata (if any) associated with this user event.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1.TransactionInfo transaction_info = 14;</code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.TransactionInfoOrBuilder
      getTransactionInfoOrBuilder() {
    return transactionInfo_ == null
        ? com.google.cloud.discoveryengine.v1.TransactionInfo.getDefaultInstance()
        : transactionInfo_;
  }

  public static final int TAG_IDS_FIELD_NUMBER = 15;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList tagIds_ =
      com.google.protobuf.LazyStringArrayList.emptyList();

  /**
   *
   *
   * <pre>
   * A list of identifiers for the independent experiment groups this user event
   * belongs to. This is used to distinguish between user events associated with
   * different experiment setups.
   * </pre>
   *
   * <code>repeated string tag_ids = 15;</code>
   *
   * @return A list containing the tagIds.
   */
  public com.google.protobuf.ProtocolStringList getTagIdsList() {
    return tagIds_;
  }

  /**
   *
   *
   * <pre>
   * A list of identifiers for the independent experiment groups this user event
   * belongs to. This is used to distinguish between user events associated with
   * different experiment setups.
   * </pre>
   *
   * <code>repeated string tag_ids = 15;</code>
   *
   * @return The count of tagIds.
   */
  public int getTagIdsCount() {
    return tagIds_.size();
  }

  /**
   *
   *
   * <pre>
   * A list of identifiers for the independent experiment groups this user event
   * belongs to. This is used to distinguish between user events associated with
   * different experiment setups.
   * </pre>
   *
   * <code>repeated string tag_ids = 15;</code>
   *
   * @param index The index of the element to return.
   * @return The tagIds at the given index.
   */
  public java.lang.String getTagIds(int index) {
    return tagIds_.get(index);
  }

  /**
   *
   *
   * <pre>
   * A list of identifiers for the independent experiment groups this user event
   * belongs to. This is used to distinguish between user events associated with
   * different experiment setups.
   * </pre>
   *
   * <code>repeated string tag_ids = 15;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the tagIds at the given index.
   */
  public com.google.protobuf.ByteString getTagIdsBytes(int index) {
    return tagIds_.getByteString(index);
  }

  public static final int PROMOTION_IDS_FIELD_NUMBER = 16;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList promotionIds_ =
      com.google.protobuf.LazyStringArrayList.emptyList();

  /**
   *
   *
   * <pre>
   * The promotion IDs if this is an event associated with promotions.
   * Currently, this field is restricted to at most one ID.
   * </pre>
   *
   * <code>repeated string promotion_ids = 16;</code>
   *
   * @return A list containing the promotionIds.
   */
  public com.google.protobuf.ProtocolStringList getPromotionIdsList() {
    return promotionIds_;
  }

  /**
   *
   *
   * <pre>
   * The promotion IDs if this is an event associated with promotions.
   * Currently, this field is restricted to at most one ID.
   * </pre>
   *
   * <code>repeated string promotion_ids = 16;</code>
   *
   * @return The count of promotionIds.
   */
  public int getPromotionIdsCount() {
    return promotionIds_.size();
  }

  /**
   *
   *
   * <pre>
   * The promotion IDs if this is an event associated with promotions.
   * Currently, this field is restricted to at most one ID.
   * </pre>
   *
   * <code>repeated string promotion_ids = 16;</code>
   *
   * @param index The index of the element to return.
   * @return The promotionIds at the given index.
   */
  public java.lang.String getPromotionIds(int index) {
    return promotionIds_.get(index);
  }

  /**
   *
   *
   * <pre>
   * The promotion IDs if this is an event associated with promotions.
   * Currently, this field is restricted to at most one ID.
   * </pre>
   *
   * <code>repeated string promotion_ids = 16;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the promotionIds at the given index.
   */
  public com.google.protobuf.ByteString getPromotionIdsBytes(int index) {
    return promotionIds_.getByteString(index);
  }

  public static final int ATTRIBUTES_FIELD_NUMBER = 17;

  private static final class AttributesDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<
            java.lang.String, com.google.cloud.discoveryengine.v1.CustomAttribute>
        defaultEntry =
            com.google.protobuf.MapEntry
                .<java.lang.String, com.google.cloud.discoveryengine.v1.CustomAttribute>
                    newDefaultInstance(
                        com.google.cloud.discoveryengine.v1.UserEventProto
                            .internal_static_google_cloud_discoveryengine_v1_UserEvent_AttributesEntry_descriptor,
                        com.google.protobuf.WireFormat.FieldType.STRING,
                        "",
                        com.google.protobuf.WireFormat.FieldType.MESSAGE,
                        com.google.cloud.discoveryengine.v1.CustomAttribute.getDefaultInstance());
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<
          java.lang.String, com.google.cloud.discoveryengine.v1.CustomAttribute>
      attributes_;

  private com.google.protobuf.MapField<
          java.lang.String, com.google.cloud.discoveryengine.v1.CustomAttribute>
      internalGetAttributes() {
    if (attributes_ == null) {
      return com.google.protobuf.MapField.emptyMapField(AttributesDefaultEntryHolder.defaultEntry);
    }
    return attributes_;
  }

  public int getAttributesCount() {
    return internalGetAttributes().getMap().size();
  }

  /**
   *
   *
   * <pre>
   * Extra user event features to include in the recommendation model.
   * These attributes must NOT contain data that needs to be parsed or processed
   * further, e.g. JSON or other encodings.
   *
   * If you provide custom attributes for ingested user events, also include
   * them in the user events that you associate with prediction requests. Custom
   * attribute formatting must be consistent between imported events and events
   * provided with prediction requests. This lets the Discovery Engine API use
   * those custom attributes when training models and serving predictions, which
   * helps improve recommendation quality.
   *
   * This field needs to pass all below criteria, otherwise an
   * `INVALID_ARGUMENT` error is returned:
   *
   * * The key must be a UTF-8 encoded string with a length limit of 5,000
   *   characters.
   * * For text attributes, at most 400 values are allowed. Empty values are not
   *   allowed. Each value must be a UTF-8 encoded string with a length limit of
   *   256 characters.
   * * For number attributes, at most 400 values are allowed.
   *
   * For product recommendations, an example of extra user information is
   * `traffic_channel`, which is how a user arrives at the site. Users can
   * arrive
   * at the site by coming to the site directly, coming through Google
   * search, or in other ways.
   * </pre>
   *
   * <code>map&lt;string, .google.cloud.discoveryengine.v1.CustomAttribute&gt; attributes = 17;
   * </code>
   */
  @java.lang.Override
  public boolean containsAttributes(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetAttributes().getMap().containsKey(key);
  }

  /** Use {@link #getAttributesMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, com.google.cloud.discoveryengine.v1.CustomAttribute>
      getAttributes() {
    return getAttributesMap();
  }

  /**
   *
   *
   * <pre>
   * Extra user event features to include in the recommendation model.
   * These attributes must NOT contain data that needs to be parsed or processed
   * further, e.g. JSON or other encodings.
   *
   * If you provide custom attributes for ingested user events, also include
   * them in the user events that you associate with prediction requests. Custom
   * attribute formatting must be consistent between imported events and events
   * provided with prediction requests. This lets the Discovery Engine API use
   * those custom attributes when training models and serving predictions, which
   * helps improve recommendation quality.
   *
   * This field needs to pass all below criteria, otherwise an
   * `INVALID_ARGUMENT` error is returned:
   *
   * * The key must be a UTF-8 encoded string with a length limit of 5,000
   *   characters.
   * * For text attributes, at most 400 values are allowed. Empty values are not
   *   allowed. Each value must be a UTF-8 encoded string with a length limit of
   *   256 characters.
   * * For number attributes, at most 400 values are allowed.
   *
   * For product recommendations, an example of extra user information is
   * `traffic_channel`, which is how a user arrives at the site. Users can
   * arrive
   * at the site by coming to the site directly, coming through Google
   * search, or in other ways.
   * </pre>
   *
   * <code>map&lt;string, .google.cloud.discoveryengine.v1.CustomAttribute&gt; attributes = 17;
   * </code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, com.google.cloud.discoveryengine.v1.CustomAttribute>
      getAttributesMap() {
    return internalGetAttributes().getMap();
  }

  /**
   *
   *
   * <pre>
   * Extra user event features to include in the recommendation model.
   * These attributes must NOT contain data that needs to be parsed or processed
   * further, e.g. JSON or other encodings.
   *
   * If you provide custom attributes for ingested user events, also include
   * them in the user events that you associate with prediction requests. Custom
   * attribute formatting must be consistent between imported events and events
   * provided with prediction requests. This lets the Discovery Engine API use
   * those custom attributes when training models and serving predictions, which
   * helps improve recommendation quality.
   *
   * This field needs to pass all below criteria, otherwise an
   * `INVALID_ARGUMENT` error is returned:
   *
   * * The key must be a UTF-8 encoded string with a length limit of 5,000
   *   characters.
   * * For text attributes, at most 400 values are allowed. Empty values are not
   *   allowed. Each value must be a UTF-8 encoded string with a length limit of
   *   256 characters.
   * * For number attributes, at most 400 values are allowed.
   *
   * For product recommendations, an example of extra user information is
   * `traffic_channel`, which is how a user arrives at the site. Users can
   * arrive
   * at the site by coming to the site directly, coming through Google
   * search, or in other ways.
   * </pre>
   *
   * <code>map&lt;string, .google.cloud.discoveryengine.v1.CustomAttribute&gt; attributes = 17;
   * </code>
   */
  @java.lang.Override
  public /* nullable */ com.google.cloud.discoveryengine.v1.CustomAttribute getAttributesOrDefault(
      java.lang.String key,
      /* nullable */
      com.google.cloud.discoveryengine.v1.CustomAttribute defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.cloud.discoveryengine.v1.CustomAttribute> map =
        internalGetAttributes().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }

  /**
   *
   *
   * <pre>
   * Extra user event features to include in the recommendation model.
   * These attributes must NOT contain data that needs to be parsed or processed
   * further, e.g. JSON or other encodings.
   *
   * If you provide custom attributes for ingested user events, also include
   * them in the user events that you associate with prediction requests. Custom
   * attribute formatting must be consistent between imported events and events
   * provided with prediction requests. This lets the Discovery Engine API use
   * those custom attributes when training models and serving predictions, which
   * helps improve recommendation quality.
   *
   * This field needs to pass all below criteria, otherwise an
   * `INVALID_ARGUMENT` error is returned:
   *
   * * The key must be a UTF-8 encoded string with a length limit of 5,000
   *   characters.
   * * For text attributes, at most 400 values are allowed. Empty values are not
   *   allowed. Each value must be a UTF-8 encoded string with a length limit of
   *   256 characters.
   * * For number attributes, at most 400 values are allowed.
   *
   * For product recommendations, an example of extra user information is
   * `traffic_channel`, which is how a user arrives at the site. Users can
   * arrive
   * at the site by coming to the site directly, coming through Google
   * search, or in other ways.
   * </pre>
   *
   * <code>map&lt;string, .google.cloud.discoveryengine.v1.CustomAttribute&gt; attributes = 17;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.CustomAttribute getAttributesOrThrow(
      java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.cloud.discoveryengine.v1.CustomAttribute> map =
        internalGetAttributes().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int MEDIA_INFO_FIELD_NUMBER = 18;
  private com.google.cloud.discoveryengine.v1.MediaInfo mediaInfo_;

  /**
   *
   *
   * <pre>
   * Media-specific info.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1.MediaInfo media_info = 18;</code>
   *
   * @return Whether the mediaInfo field is set.
   */
  @java.lang.Override
  public boolean hasMediaInfo() {
    return ((bitField0_ & 0x00000080) != 0);
  }

  /**
   *
   *
   * <pre>
   * Media-specific info.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1.MediaInfo media_info = 18;</code>
   *
   * @return The mediaInfo.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.MediaInfo getMediaInfo() {
    return mediaInfo_ == null
        ? com.google.cloud.discoveryengine.v1.MediaInfo.getDefaultInstance()
        : mediaInfo_;
  }

  /**
   *
   *
   * <pre>
   * Media-specific info.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1.MediaInfo media_info = 18;</code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.MediaInfoOrBuilder getMediaInfoOrBuilder() {
    return mediaInfo_ == null
        ? com.google.cloud.discoveryengine.v1.MediaInfo.getDefaultInstance()
        : mediaInfo_;
  }

  public static final int PANELS_FIELD_NUMBER = 22;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.discoveryengine.v1.PanelInfo> panels_;

  /**
   *
   *
   * <pre>
   * Optional. List of panels associated with this event.
   * Used for page-level impression data.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.discoveryengine.v1.PanelInfo panels = 22 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.discoveryengine.v1.PanelInfo> getPanelsList() {
    return panels_;
  }

  /**
   *
   *
   * <pre>
   * Optional. List of panels associated with this event.
   * Used for page-level impression data.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.discoveryengine.v1.PanelInfo panels = 22 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.discoveryengine.v1.PanelInfoOrBuilder>
      getPanelsOrBuilderList() {
    return panels_;
  }

  /**
   *
   *
   * <pre>
   * Optional. List of panels associated with this event.
   * Used for page-level impression data.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.discoveryengine.v1.PanelInfo panels = 22 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public int getPanelsCount() {
    return panels_.size();
  }

  /**
   *
   *
   * <pre>
   * Optional. List of panels associated with this event.
   * Used for page-level impression data.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.discoveryengine.v1.PanelInfo panels = 22 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.PanelInfo getPanels(int index) {
    return panels_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Optional. List of panels associated with this event.
   * Used for page-level impression data.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.discoveryengine.v1.PanelInfo panels = 22 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.PanelInfoOrBuilder getPanelsOrBuilder(int index) {
    return panels_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(eventType_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, eventType_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(userPseudoId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, userPseudoId_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3, getEventTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(4, getUserInfo());
    }
    if (directUserRequest_ != false) {
      output.writeBool(5, directUserRequest_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sessionId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, sessionId_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(7, getPageInfo());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(attributionToken_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, attributionToken_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(filter_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 9, filter_);
    }
    for (int i = 0; i < documents_.size(); i++) {
      output.writeMessage(10, documents_.get(i));
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(11, getPanel());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeMessage(12, getSearchInfo());
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      output.writeMessage(13, getCompletionInfo());
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      output.writeMessage(14, getTransactionInfo());
    }
    for (int i = 0; i < tagIds_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 15, tagIds_.getRaw(i));
    }
    for (int i = 0; i < promotionIds_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 16, promotionIds_.getRaw(i));
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetAttributes(), AttributesDefaultEntryHolder.defaultEntry, 17);
    if (((bitField0_ & 0x00000080) != 0)) {
      output.writeMessage(18, getMediaInfo());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(engine_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 19, engine_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dataStore_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 20, dataStore_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(conversionType_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 21, conversionType_);
    }
    for (int i = 0; i < panels_.size(); i++) {
      output.writeMessage(22, panels_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(eventType_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, eventType_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(userPseudoId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, userPseudoId_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getEventTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getUserInfo());
    }
    if (directUserRequest_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(5, directUserRequest_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sessionId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, sessionId_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getPageInfo());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(attributionToken_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, attributionToken_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(filter_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(9, filter_);
    }
    for (int i = 0; i < documents_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, documents_.get(i));
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(11, getPanel());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(12, getSearchInfo());
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(13, getCompletionInfo());
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(14, getTransactionInfo());
    }
    {
      int dataSize = 0;
      for (int i = 0; i < tagIds_.size(); i++) {
        dataSize += computeStringSizeNoTag(tagIds_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getTagIdsList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < promotionIds_.size(); i++) {
        dataSize += computeStringSizeNoTag(promotionIds_.getRaw(i));
      }
      size += dataSize;
      size += 2 * getPromotionIdsList().size();
    }
    for (java.util.Map.Entry<java.lang.String, com.google.cloud.discoveryengine.v1.CustomAttribute>
        entry : internalGetAttributes().getMap().entrySet()) {
      com.google.protobuf.MapEntry<
              java.lang.String, com.google.cloud.discoveryengine.v1.CustomAttribute>
          attributes__ =
              AttributesDefaultEntryHolder.defaultEntry
                  .newBuilderForType()
                  .setKey(entry.getKey())
                  .setValue(entry.getValue())
                  .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(17, attributes__);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(18, getMediaInfo());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(engine_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(19, engine_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dataStore_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(20, dataStore_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(conversionType_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(21, conversionType_);
    }
    for (int i = 0; i < panels_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(22, panels_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.discoveryengine.v1.UserEvent)) {
      return super.equals(obj);
    }
    com.google.cloud.discoveryengine.v1.UserEvent other =
        (com.google.cloud.discoveryengine.v1.UserEvent) obj;

    if (!getEventType().equals(other.getEventType())) return false;
    if (!getConversionType().equals(other.getConversionType())) return false;
    if (!getUserPseudoId().equals(other.getUserPseudoId())) return false;
    if (!getEngine().equals(other.getEngine())) return false;
    if (!getDataStore().equals(other.getDataStore())) return false;
    if (hasEventTime() != other.hasEventTime()) return false;
    if (hasEventTime()) {
      if (!getEventTime().equals(other.getEventTime())) return false;
    }
    if (hasUserInfo() != other.hasUserInfo()) return false;
    if (hasUserInfo()) {
      if (!getUserInfo().equals(other.getUserInfo())) return false;
    }
    if (getDirectUserRequest() != other.getDirectUserRequest()) return false;
    if (!getSessionId().equals(other.getSessionId())) return false;
    if (hasPageInfo() != other.hasPageInfo()) return false;
    if (hasPageInfo()) {
      if (!getPageInfo().equals(other.getPageInfo())) return false;
    }
    if (!getAttributionToken().equals(other.getAttributionToken())) return false;
    if (!getFilter().equals(other.getFilter())) return false;
    if (!getDocumentsList().equals(other.getDocumentsList())) return false;
    if (hasPanel() != other.hasPanel()) return false;
    if (hasPanel()) {
      if (!getPanel().equals(other.getPanel())) return false;
    }
    if (hasSearchInfo() != other.hasSearchInfo()) return false;
    if (hasSearchInfo()) {
      if (!getSearchInfo().equals(other.getSearchInfo())) return false;
    }
    if (hasCompletionInfo() != other.hasCompletionInfo()) return false;
    if (hasCompletionInfo()) {
      if (!getCompletionInfo().equals(other.getCompletionInfo())) return false;
    }
    if (hasTransactionInfo() != other.hasTransactionInfo()) return false;
    if (hasTransactionInfo()) {
      if (!getTransactionInfo().equals(other.getTransactionInfo())) return false;
    }
    if (!getTagIdsList().equals(other.getTagIdsList())) return false;
    if (!getPromotionIdsList().equals(other.getPromotionIdsList())) return false;
    if (!internalGetAttributes().equals(other.internalGetAttributes())) return false;
    if (hasMediaInfo() != other.hasMediaInfo()) return false;
    if (hasMediaInfo()) {
      if (!getMediaInfo().equals(other.getMediaInfo())) return false;
    }
    if (!getPanelsList().equals(other.getPanelsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + EVENT_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + getEventType().hashCode();
    hash = (37 * hash) + CONVERSION_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + getConversionType().hashCode();
    hash = (37 * hash) + USER_PSEUDO_ID_FIELD_NUMBER;
    hash = (53 * hash) + getUserPseudoId().hashCode();
    hash = (37 * hash) + ENGINE_FIELD_NUMBER;
    hash = (53 * hash) + getEngine().hashCode();
    hash = (37 * hash) + DATA_STORE_FIELD_NUMBER;
    hash = (53 * hash) + getDataStore().hashCode();
    if (hasEventTime()) {
      hash = (37 * hash) + EVENT_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getEventTime().hashCode();
    }
    if (hasUserInfo()) {
      hash = (37 * hash) + USER_INFO_FIELD_NUMBER;
      hash = (53 * hash) + getUserInfo().hashCode();
    }
    hash = (37 * hash) + DIRECT_USER_REQUEST_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getDirectUserRequest());
    hash = (37 * hash) + SESSION_ID_FIELD_NUMBER;
    hash = (53 * hash) + getSessionId().hashCode();
    if (hasPageInfo()) {
      hash = (37 * hash) + PAGE_INFO_FIELD_NUMBER;
      hash = (53 * hash) + getPageInfo().hashCode();
    }
    hash = (37 * hash) + ATTRIBUTION_TOKEN_FIELD_NUMBER;
    hash = (53 * hash) + getAttributionToken().hashCode();
    hash = (37 * hash) + FILTER_FIELD_NUMBER;
    hash = (53 * hash) + getFilter().hashCode();
    if (getDocumentsCount() > 0) {
      hash = (37 * hash) + DOCUMENTS_FIELD_NUMBER;
      hash = (53 * hash) + getDocumentsList().hashCode();
    }
    if (hasPanel()) {
      hash = (37 * hash) + PANEL_FIELD_NUMBER;
      hash = (53 * hash) + getPanel().hashCode();
    }
    if (hasSearchInfo()) {
      hash = (37 * hash) + SEARCH_INFO_FIELD_NUMBER;
      hash = (53 * hash) + getSearchInfo().hashCode();
    }
    if (hasCompletionInfo()) {
      hash = (37 * hash) + COMPLETION_INFO_FIELD_NUMBER;
      hash = (53 * hash) + getCompletionInfo().hashCode();
    }
    if (hasTransactionInfo()) {
      hash = (37 * hash) + TRANSACTION_INFO_FIELD_NUMBER;
      hash = (53 * hash) + getTransactionInfo().hashCode();
    }
    if (getTagIdsCount() > 0) {
      hash = (37 * hash) + TAG_IDS_FIELD_NUMBER;
      hash = (53 * hash) + getTagIdsList().hashCode();
    }
    if (getPromotionIdsCount() > 0) {
      hash = (37 * hash) + PROMOTION_IDS_FIELD_NUMBER;
      hash = (53 * hash) + getPromotionIdsList().hashCode();
    }
    if (!internalGetAttributes().getMap().isEmpty()) {
      hash = (37 * hash) + ATTRIBUTES_FIELD_NUMBER;
      hash = (53 * hash) + internalGetAttributes().hashCode();
    }
    if (hasMediaInfo()) {
      hash = (37 * hash) + MEDIA_INFO_FIELD_NUMBER;
      hash = (53 * hash) + getMediaInfo().hashCode();
    }
    if (getPanelsCount() > 0) {
      hash = (37 * hash) + PANELS_FIELD_NUMBER;
      hash = (53 * hash) + getPanelsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.discoveryengine.v1.UserEvent parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1.UserEvent parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.UserEvent parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1.UserEvent parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.UserEvent parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1.UserEvent parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.UserEvent parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1.UserEvent parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.UserEvent parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1.UserEvent parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.UserEvent parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1.UserEvent parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.discoveryengine.v1.UserEvent prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * UserEvent captures all metadata information Discovery Engine API needs to
   * know about how end users interact with your website.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1.UserEvent}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1.UserEvent)
      com.google.cloud.discoveryengine.v1.UserEventOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1.UserEventProto
          .internal_static_google_cloud_discoveryengine_v1_UserEvent_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 17:
          return internalGetAttributes();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 17:
          return internalGetMutableAttributes();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1.UserEventProto
          .internal_static_google_cloud_discoveryengine_v1_UserEvent_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1.UserEvent.class,
              com.google.cloud.discoveryengine.v1.UserEvent.Builder.class);
    }

    // Construct using com.google.cloud.discoveryengine.v1.UserEvent.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getEventTimeFieldBuilder();
        getUserInfoFieldBuilder();
        getPageInfoFieldBuilder();
        getDocumentsFieldBuilder();
        getPanelFieldBuilder();
        getSearchInfoFieldBuilder();
        getCompletionInfoFieldBuilder();
        getTransactionInfoFieldBuilder();
        getMediaInfoFieldBuilder();
        getPanelsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      eventType_ = "";
      conversionType_ = "";
      userPseudoId_ = "";
      engine_ = "";
      dataStore_ = "";
      eventTime_ = null;
      if (eventTimeBuilder_ != null) {
        eventTimeBuilder_.dispose();
        eventTimeBuilder_ = null;
      }
      userInfo_ = null;
      if (userInfoBuilder_ != null) {
        userInfoBuilder_.dispose();
        userInfoBuilder_ = null;
      }
      directUserRequest_ = false;
      sessionId_ = "";
      pageInfo_ = null;
      if (pageInfoBuilder_ != null) {
        pageInfoBuilder_.dispose();
        pageInfoBuilder_ = null;
      }
      attributionToken_ = "";
      filter_ = "";
      if (documentsBuilder_ == null) {
        documents_ = java.util.Collections.emptyList();
      } else {
        documents_ = null;
        documentsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00001000);
      panel_ = null;
      if (panelBuilder_ != null) {
        panelBuilder_.dispose();
        panelBuilder_ = null;
      }
      searchInfo_ = null;
      if (searchInfoBuilder_ != null) {
        searchInfoBuilder_.dispose();
        searchInfoBuilder_ = null;
      }
      completionInfo_ = null;
      if (completionInfoBuilder_ != null) {
        completionInfoBuilder_.dispose();
        completionInfoBuilder_ = null;
      }
      transactionInfo_ = null;
      if (transactionInfoBuilder_ != null) {
        transactionInfoBuilder_.dispose();
        transactionInfoBuilder_ = null;
      }
      tagIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
      promotionIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
      internalGetMutableAttributes().clear();
      mediaInfo_ = null;
      if (mediaInfoBuilder_ != null) {
        mediaInfoBuilder_.dispose();
        mediaInfoBuilder_ = null;
      }
      if (panelsBuilder_ == null) {
        panels_ = java.util.Collections.emptyList();
      } else {
        panels_ = null;
        panelsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00200000);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.discoveryengine.v1.UserEventProto
          .internal_static_google_cloud_discoveryengine_v1_UserEvent_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.UserEvent getDefaultInstanceForType() {
      return com.google.cloud.discoveryengine.v1.UserEvent.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.UserEvent build() {
      com.google.cloud.discoveryengine.v1.UserEvent result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.UserEvent buildPartial() {
      com.google.cloud.discoveryengine.v1.UserEvent result =
          new com.google.cloud.discoveryengine.v1.UserEvent(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.discoveryengine.v1.UserEvent result) {
      if (documentsBuilder_ == null) {
        if (((bitField0_ & 0x00001000) != 0)) {
          documents_ = java.util.Collections.unmodifiableList(documents_);
          bitField0_ = (bitField0_ & ~0x00001000);
        }
        result.documents_ = documents_;
      } else {
        result.documents_ = documentsBuilder_.build();
      }
      if (panelsBuilder_ == null) {
        if (((bitField0_ & 0x00200000) != 0)) {
          panels_ = java.util.Collections.unmodifiableList(panels_);
          bitField0_ = (bitField0_ & ~0x00200000);
        }
        result.panels_ = panels_;
      } else {
        result.panels_ = panelsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.discoveryengine.v1.UserEvent result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.eventType_ = eventType_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.conversionType_ = conversionType_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.userPseudoId_ = userPseudoId_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.engine_ = engine_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.dataStore_ = dataStore_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.eventTime_ = eventTimeBuilder_ == null ? eventTime_ : eventTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.userInfo_ = userInfoBuilder_ == null ? userInfo_ : userInfoBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.directUserRequest_ = directUserRequest_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.sessionId_ = sessionId_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.pageInfo_ = pageInfoBuilder_ == null ? pageInfo_ : pageInfoBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.attributionToken_ = attributionToken_;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.filter_ = filter_;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.panel_ = panelBuilder_ == null ? panel_ : panelBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.searchInfo_ = searchInfoBuilder_ == null ? searchInfo_ : searchInfoBuilder_.build();
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00008000) != 0)) {
        result.completionInfo_ =
            completionInfoBuilder_ == null ? completionInfo_ : completionInfoBuilder_.build();
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00010000) != 0)) {
        result.transactionInfo_ =
            transactionInfoBuilder_ == null ? transactionInfo_ : transactionInfoBuilder_.build();
        to_bitField0_ |= 0x00000040;
      }
      if (((from_bitField0_ & 0x00020000) != 0)) {
        tagIds_.makeImmutable();
        result.tagIds_ = tagIds_;
      }
      if (((from_bitField0_ & 0x00040000) != 0)) {
        promotionIds_.makeImmutable();
        result.promotionIds_ = promotionIds_;
      }
      if (((from_bitField0_ & 0x00080000) != 0)) {
        result.attributes_ =
            internalGetAttributes().build(AttributesDefaultEntryHolder.defaultEntry);
      }
      if (((from_bitField0_ & 0x00100000) != 0)) {
        result.mediaInfo_ = mediaInfoBuilder_ == null ? mediaInfo_ : mediaInfoBuilder_.build();
        to_bitField0_ |= 0x00000080;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.discoveryengine.v1.UserEvent) {
        return mergeFrom((com.google.cloud.discoveryengine.v1.UserEvent) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.discoveryengine.v1.UserEvent other) {
      if (other == com.google.cloud.discoveryengine.v1.UserEvent.getDefaultInstance()) return this;
      if (!other.getEventType().isEmpty()) {
        eventType_ = other.eventType_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getConversionType().isEmpty()) {
        conversionType_ = other.conversionType_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getUserPseudoId().isEmpty()) {
        userPseudoId_ = other.userPseudoId_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getEngine().isEmpty()) {
        engine_ = other.engine_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.getDataStore().isEmpty()) {
        dataStore_ = other.dataStore_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (other.hasEventTime()) {
        mergeEventTime(other.getEventTime());
      }
      if (other.hasUserInfo()) {
        mergeUserInfo(other.getUserInfo());
      }
      if (other.getDirectUserRequest() != false) {
        setDirectUserRequest(other.getDirectUserRequest());
      }
      if (!other.getSessionId().isEmpty()) {
        sessionId_ = other.sessionId_;
        bitField0_ |= 0x00000100;
        onChanged();
      }
      if (other.hasPageInfo()) {
        mergePageInfo(other.getPageInfo());
      }
      if (!other.getAttributionToken().isEmpty()) {
        attributionToken_ = other.attributionToken_;
        bitField0_ |= 0x00000400;
        onChanged();
      }
      if (!other.getFilter().isEmpty()) {
        filter_ = other.filter_;
        bitField0_ |= 0x00000800;
        onChanged();
      }
      if (documentsBuilder_ == null) {
        if (!other.documents_.isEmpty()) {
          if (documents_.isEmpty()) {
            documents_ = other.documents_;
            bitField0_ = (bitField0_ & ~0x00001000);
          } else {
            ensureDocumentsIsMutable();
            documents_.addAll(other.documents_);
          }
          onChanged();
        }
      } else {
        if (!other.documents_.isEmpty()) {
          if (documentsBuilder_.isEmpty()) {
            documentsBuilder_.dispose();
            documentsBuilder_ = null;
            documents_ = other.documents_;
            bitField0_ = (bitField0_ & ~0x00001000);
            documentsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getDocumentsFieldBuilder()
                    : null;
          } else {
            documentsBuilder_.addAllMessages(other.documents_);
          }
        }
      }
      if (other.hasPanel()) {
        mergePanel(other.getPanel());
      }
      if (other.hasSearchInfo()) {
        mergeSearchInfo(other.getSearchInfo());
      }
      if (other.hasCompletionInfo()) {
        mergeCompletionInfo(other.getCompletionInfo());
      }
      if (other.hasTransactionInfo()) {
        mergeTransactionInfo(other.getTransactionInfo());
      }
      if (!other.tagIds_.isEmpty()) {
        if (tagIds_.isEmpty()) {
          tagIds_ = other.tagIds_;
          bitField0_ |= 0x00020000;
        } else {
          ensureTagIdsIsMutable();
          tagIds_.addAll(other.tagIds_);
        }
        onChanged();
      }
      if (!other.promotionIds_.isEmpty()) {
        if (promotionIds_.isEmpty()) {
          promotionIds_ = other.promotionIds_;
          bitField0_ |= 0x00040000;
        } else {
          ensurePromotionIdsIsMutable();
          promotionIds_.addAll(other.promotionIds_);
        }
        onChanged();
      }
      internalGetMutableAttributes().mergeFrom(other.internalGetAttributes());
      bitField0_ |= 0x00080000;
      if (other.hasMediaInfo()) {
        mergeMediaInfo(other.getMediaInfo());
      }
      if (panelsBuilder_ == null) {
        if (!other.panels_.isEmpty()) {
          if (panels_.isEmpty()) {
            panels_ = other.panels_;
            bitField0_ = (bitField0_ & ~0x00200000);
          } else {
            ensurePanelsIsMutable();
            panels_.addAll(other.panels_);
          }
          onChanged();
        }
      } else {
        if (!other.panels_.isEmpty()) {
          if (panelsBuilder_.isEmpty()) {
            panelsBuilder_.dispose();
            panelsBuilder_ = null;
            panels_ = other.panels_;
            bitField0_ = (bitField0_ & ~0x00200000);
            panelsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getPanelsFieldBuilder()
                    : null;
          } else {
            panelsBuilder_.addAllMessages(other.panels_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                eventType_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                userPseudoId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getEventTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getUserInfoFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 34
            case 40:
              {
                directUserRequest_ = input.readBool();
                bitField0_ |= 0x00000080;
                break;
              } // case 40
            case 50:
              {
                sessionId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000100;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getPageInfoFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000200;
                break;
              } // case 58
            case 66:
              {
                attributionToken_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000400;
                break;
              } // case 66
            case 74:
              {
                filter_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000800;
                break;
              } // case 74
            case 82:
              {
                com.google.cloud.discoveryengine.v1.DocumentInfo m =
                    input.readMessage(
                        com.google.cloud.discoveryengine.v1.DocumentInfo.parser(),
                        extensionRegistry);
                if (documentsBuilder_ == null) {
                  ensureDocumentsIsMutable();
                  documents_.add(m);
                } else {
                  documentsBuilder_.addMessage(m);
                }
                break;
              } // case 82
            case 90:
              {
                input.readMessage(getPanelFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00002000;
                break;
              } // case 90
            case 98:
              {
                input.readMessage(getSearchInfoFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00004000;
                break;
              } // case 98
            case 106:
              {
                input.readMessage(getCompletionInfoFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00008000;
                break;
              } // case 106
            case 114:
              {
                input.readMessage(getTransactionInfoFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00010000;
                break;
              } // case 114
            case 122:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureTagIdsIsMutable();
                tagIds_.add(s);
                break;
              } // case 122
            case 130:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensurePromotionIdsIsMutable();
                promotionIds_.add(s);
                break;
              } // case 130
            case 138:
              {
                com.google.protobuf.MapEntry<
                        java.lang.String, com.google.cloud.discoveryengine.v1.CustomAttribute>
                    attributes__ =
                        input.readMessage(
                            AttributesDefaultEntryHolder.defaultEntry.getParserForType(),
                            extensionRegistry);
                internalGetMutableAttributes()
                    .ensureBuilderMap()
                    .put(attributes__.getKey(), attributes__.getValue());
                bitField0_ |= 0x00080000;
                break;
              } // case 138
            case 146:
              {
                input.readMessage(getMediaInfoFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00100000;
                break;
              } // case 146
            case 154:
              {
                engine_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 154
            case 162:
              {
                dataStore_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 162
            case 170:
              {
                conversionType_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 170
            case 178:
              {
                com.google.cloud.discoveryengine.v1.PanelInfo m =
                    input.readMessage(
                        com.google.cloud.discoveryengine.v1.PanelInfo.parser(), extensionRegistry);
                if (panelsBuilder_ == null) {
                  ensurePanelsIsMutable();
                  panels_.add(m);
                } else {
                  panelsBuilder_.addMessage(m);
                }
                break;
              } // case 178
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object eventType_ = "";

    /**
     *
     *
     * <pre>
     * Required. User event type. Allowed values are:
     *
     * Generic values:
     *
     * * `search`: Search for Documents.
     * * `view-item`: Detailed page view of a Document.
     * * `view-item-list`: View of a panel or ordered list of Documents.
     * * `view-home-page`: View of the home page.
     * * `view-category-page`: View of a category page, e.g. Home &gt; Men &gt; Jeans
     * * `add-feedback`: Add a user feedback.
     *
     * Retail-related values:
     *
     * * `add-to-cart`: Add an item(s) to cart, e.g. in Retail online shopping
     * * `purchase`: Purchase an item(s)
     *
     * Media-related values:
     *
     * * `media-play`: Start/resume watching a video, playing a song, etc.
     * * `media-complete`: Finished or stopped midway through a video, song, etc.
     *
     * Custom conversion value:
     *
     * * `conversion`: Customer defined conversion event.
     * </pre>
     *
     * <code>string event_type = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The eventType.
     */
    public java.lang.String getEventType() {
      java.lang.Object ref = eventType_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        eventType_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. User event type. Allowed values are:
     *
     * Generic values:
     *
     * * `search`: Search for Documents.
     * * `view-item`: Detailed page view of a Document.
     * * `view-item-list`: View of a panel or ordered list of Documents.
     * * `view-home-page`: View of the home page.
     * * `view-category-page`: View of a category page, e.g. Home &gt; Men &gt; Jeans
     * * `add-feedback`: Add a user feedback.
     *
     * Retail-related values:
     *
     * * `add-to-cart`: Add an item(s) to cart, e.g. in Retail online shopping
     * * `purchase`: Purchase an item(s)
     *
     * Media-related values:
     *
     * * `media-play`: Start/resume watching a video, playing a song, etc.
     * * `media-complete`: Finished or stopped midway through a video, song, etc.
     *
     * Custom conversion value:
     *
     * * `conversion`: Customer defined conversion event.
     * </pre>
     *
     * <code>string event_type = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for eventType.
     */
    public com.google.protobuf.ByteString getEventTypeBytes() {
      java.lang.Object ref = eventType_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        eventType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. User event type. Allowed values are:
     *
     * Generic values:
     *
     * * `search`: Search for Documents.
     * * `view-item`: Detailed page view of a Document.
     * * `view-item-list`: View of a panel or ordered list of Documents.
     * * `view-home-page`: View of the home page.
     * * `view-category-page`: View of a category page, e.g. Home &gt; Men &gt; Jeans
     * * `add-feedback`: Add a user feedback.
     *
     * Retail-related values:
     *
     * * `add-to-cart`: Add an item(s) to cart, e.g. in Retail online shopping
     * * `purchase`: Purchase an item(s)
     *
     * Media-related values:
     *
     * * `media-play`: Start/resume watching a video, playing a song, etc.
     * * `media-complete`: Finished or stopped midway through a video, song, etc.
     *
     * Custom conversion value:
     *
     * * `conversion`: Customer defined conversion event.
     * </pre>
     *
     * <code>string event_type = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The eventType to set.
     * @return This builder for chaining.
     */
    public Builder setEventType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      eventType_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. User event type. Allowed values are:
     *
     * Generic values:
     *
     * * `search`: Search for Documents.
     * * `view-item`: Detailed page view of a Document.
     * * `view-item-list`: View of a panel or ordered list of Documents.
     * * `view-home-page`: View of the home page.
     * * `view-category-page`: View of a category page, e.g. Home &gt; Men &gt; Jeans
     * * `add-feedback`: Add a user feedback.
     *
     * Retail-related values:
     *
     * * `add-to-cart`: Add an item(s) to cart, e.g. in Retail online shopping
     * * `purchase`: Purchase an item(s)
     *
     * Media-related values:
     *
     * * `media-play`: Start/resume watching a video, playing a song, etc.
     * * `media-complete`: Finished or stopped midway through a video, song, etc.
     *
     * Custom conversion value:
     *
     * * `conversion`: Customer defined conversion event.
     * </pre>
     *
     * <code>string event_type = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEventType() {
      eventType_ = getDefaultInstance().getEventType();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. User event type. Allowed values are:
     *
     * Generic values:
     *
     * * `search`: Search for Documents.
     * * `view-item`: Detailed page view of a Document.
     * * `view-item-list`: View of a panel or ordered list of Documents.
     * * `view-home-page`: View of the home page.
     * * `view-category-page`: View of a category page, e.g. Home &gt; Men &gt; Jeans
     * * `add-feedback`: Add a user feedback.
     *
     * Retail-related values:
     *
     * * `add-to-cart`: Add an item(s) to cart, e.g. in Retail online shopping
     * * `purchase`: Purchase an item(s)
     *
     * Media-related values:
     *
     * * `media-play`: Start/resume watching a video, playing a song, etc.
     * * `media-complete`: Finished or stopped midway through a video, song, etc.
     *
     * Custom conversion value:
     *
     * * `conversion`: Customer defined conversion event.
     * </pre>
     *
     * <code>string event_type = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for eventType to set.
     * @return This builder for chaining.
     */
    public Builder setEventTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      eventType_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object conversionType_ = "";

    /**
     *
     *
     * <pre>
     * Optional. Conversion type.
     *
     * Required if
     * [UserEvent.event_type][google.cloud.discoveryengine.v1.UserEvent.event_type]
     * is `conversion`. This is a customer-defined conversion name in lowercase
     * letters or numbers separated by "-", such as "watch", "good-visit" etc.
     *
     * Do not set the field if
     * [UserEvent.event_type][google.cloud.discoveryengine.v1.UserEvent.event_type]
     * is not `conversion`. This mixes the custom conversion event with predefined
     * events like `search`, `view-item` etc.
     * </pre>
     *
     * <code>string conversion_type = 21 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The conversionType.
     */
    public java.lang.String getConversionType() {
      java.lang.Object ref = conversionType_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        conversionType_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Conversion type.
     *
     * Required if
     * [UserEvent.event_type][google.cloud.discoveryengine.v1.UserEvent.event_type]
     * is `conversion`. This is a customer-defined conversion name in lowercase
     * letters or numbers separated by "-", such as "watch", "good-visit" etc.
     *
     * Do not set the field if
     * [UserEvent.event_type][google.cloud.discoveryengine.v1.UserEvent.event_type]
     * is not `conversion`. This mixes the custom conversion event with predefined
     * events like `search`, `view-item` etc.
     * </pre>
     *
     * <code>string conversion_type = 21 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for conversionType.
     */
    public com.google.protobuf.ByteString getConversionTypeBytes() {
      java.lang.Object ref = conversionType_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        conversionType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Conversion type.
     *
     * Required if
     * [UserEvent.event_type][google.cloud.discoveryengine.v1.UserEvent.event_type]
     * is `conversion`. This is a customer-defined conversion name in lowercase
     * letters or numbers separated by "-", such as "watch", "good-visit" etc.
     *
     * Do not set the field if
     * [UserEvent.event_type][google.cloud.discoveryengine.v1.UserEvent.event_type]
     * is not `conversion`. This mixes the custom conversion event with predefined
     * events like `search`, `view-item` etc.
     * </pre>
     *
     * <code>string conversion_type = 21 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The conversionType to set.
     * @return This builder for chaining.
     */
    public Builder setConversionType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      conversionType_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Conversion type.
     *
     * Required if
     * [UserEvent.event_type][google.cloud.discoveryengine.v1.UserEvent.event_type]
     * is `conversion`. This is a customer-defined conversion name in lowercase
     * letters or numbers separated by "-", such as "watch", "good-visit" etc.
     *
     * Do not set the field if
     * [UserEvent.event_type][google.cloud.discoveryengine.v1.UserEvent.event_type]
     * is not `conversion`. This mixes the custom conversion event with predefined
     * events like `search`, `view-item` etc.
     * </pre>
     *
     * <code>string conversion_type = 21 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearConversionType() {
      conversionType_ = getDefaultInstance().getConversionType();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Conversion type.
     *
     * Required if
     * [UserEvent.event_type][google.cloud.discoveryengine.v1.UserEvent.event_type]
     * is `conversion`. This is a customer-defined conversion name in lowercase
     * letters or numbers separated by "-", such as "watch", "good-visit" etc.
     *
     * Do not set the field if
     * [UserEvent.event_type][google.cloud.discoveryengine.v1.UserEvent.event_type]
     * is not `conversion`. This mixes the custom conversion event with predefined
     * events like `search`, `view-item` etc.
     * </pre>
     *
     * <code>string conversion_type = 21 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for conversionType to set.
     * @return This builder for chaining.
     */
    public Builder setConversionTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      conversionType_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object userPseudoId_ = "";

    /**
     *
     *
     * <pre>
     * Required. A unique identifier for tracking visitors.
     *
     * For example, this could be implemented with an HTTP cookie, which should be
     * able to uniquely identify a visitor on a single device. This unique
     * identifier should not change if the visitor log in/out of the website.
     *
     * Do not set the field to the same fixed ID for different users. This mixes
     * the event history of those users together, which results in degraded model
     * quality.
     *
     * The field must be a UTF-8 encoded string with a length limit of 128
     * characters. Otherwise, an `INVALID_ARGUMENT` error is returned.
     *
     * The field should not contain PII or user-data. We recommend to use Google
     * Analytics [Client
     * ID](https://developers.google.com/analytics/devguides/collection/analyticsjs/field-reference#clientId)
     * for this field.
     * </pre>
     *
     * <code>string user_pseudo_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The userPseudoId.
     */
    public java.lang.String getUserPseudoId() {
      java.lang.Object ref = userPseudoId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        userPseudoId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. A unique identifier for tracking visitors.
     *
     * For example, this could be implemented with an HTTP cookie, which should be
     * able to uniquely identify a visitor on a single device. This unique
     * identifier should not change if the visitor log in/out of the website.
     *
     * Do not set the field to the same fixed ID for different users. This mixes
     * the event history of those users together, which results in degraded model
     * quality.
     *
     * The field must be a UTF-8 encoded string with a length limit of 128
     * characters. Otherwise, an `INVALID_ARGUMENT` error is returned.
     *
     * The field should not contain PII or user-data. We recommend to use Google
     * Analytics [Client
     * ID](https://developers.google.com/analytics/devguides/collection/analyticsjs/field-reference#clientId)
     * for this field.
     * </pre>
     *
     * <code>string user_pseudo_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for userPseudoId.
     */
    public com.google.protobuf.ByteString getUserPseudoIdBytes() {
      java.lang.Object ref = userPseudoId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        userPseudoId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. A unique identifier for tracking visitors.
     *
     * For example, this could be implemented with an HTTP cookie, which should be
     * able to uniquely identify a visitor on a single device. This unique
     * identifier should not change if the visitor log in/out of the website.
     *
     * Do not set the field to the same fixed ID for different users. This mixes
     * the event history of those users together, which results in degraded model
     * quality.
     *
     * The field must be a UTF-8 encoded string with a length limit of 128
     * characters. Otherwise, an `INVALID_ARGUMENT` error is returned.
     *
     * The field should not contain PII or user-data. We recommend to use Google
     * Analytics [Client
     * ID](https://developers.google.com/analytics/devguides/collection/analyticsjs/field-reference#clientId)
     * for this field.
     * </pre>
     *
     * <code>string user_pseudo_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The userPseudoId to set.
     * @return This builder for chaining.
     */
    public Builder setUserPseudoId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      userPseudoId_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. A unique identifier for tracking visitors.
     *
     * For example, this could be implemented with an HTTP cookie, which should be
     * able to uniquely identify a visitor on a single device. This unique
     * identifier should not change if the visitor log in/out of the website.
     *
     * Do not set the field to the same fixed ID for different users. This mixes
     * the event history of those users together, which results in degraded model
     * quality.
     *
     * The field must be a UTF-8 encoded string with a length limit of 128
     * characters. Otherwise, an `INVALID_ARGUMENT` error is returned.
     *
     * The field should not contain PII or user-data. We recommend to use Google
     * Analytics [Client
     * ID](https://developers.google.com/analytics/devguides/collection/analyticsjs/field-reference#clientId)
     * for this field.
     * </pre>
     *
     * <code>string user_pseudo_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUserPseudoId() {
      userPseudoId_ = getDefaultInstance().getUserPseudoId();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. A unique identifier for tracking visitors.
     *
     * For example, this could be implemented with an HTTP cookie, which should be
     * able to uniquely identify a visitor on a single device. This unique
     * identifier should not change if the visitor log in/out of the website.
     *
     * Do not set the field to the same fixed ID for different users. This mixes
     * the event history of those users together, which results in degraded model
     * quality.
     *
     * The field must be a UTF-8 encoded string with a length limit of 128
     * characters. Otherwise, an `INVALID_ARGUMENT` error is returned.
     *
     * The field should not contain PII or user-data. We recommend to use Google
     * Analytics [Client
     * ID](https://developers.google.com/analytics/devguides/collection/analyticsjs/field-reference#clientId)
     * for this field.
     * </pre>
     *
     * <code>string user_pseudo_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for userPseudoId to set.
     * @return This builder for chaining.
     */
    public Builder setUserPseudoIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      userPseudoId_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object engine_ = "";

    /**
     *
     *
     * <pre>
     * The [Engine][google.cloud.discoveryengine.v1.Engine] resource name, in the
     * form of
     * `projects/{project}/locations/{location}/collections/{collection_id}/engines/{engine_id}`.
     *
     * Optional. Only required for
     * [Engine][google.cloud.discoveryengine.v1.Engine] produced user events. For
     * example, user events from blended search.
     * </pre>
     *
     * <code>string engine = 19 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The engine.
     */
    public java.lang.String getEngine() {
      java.lang.Object ref = engine_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        engine_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The [Engine][google.cloud.discoveryengine.v1.Engine] resource name, in the
     * form of
     * `projects/{project}/locations/{location}/collections/{collection_id}/engines/{engine_id}`.
     *
     * Optional. Only required for
     * [Engine][google.cloud.discoveryengine.v1.Engine] produced user events. For
     * example, user events from blended search.
     * </pre>
     *
     * <code>string engine = 19 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for engine.
     */
    public com.google.protobuf.ByteString getEngineBytes() {
      java.lang.Object ref = engine_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        engine_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The [Engine][google.cloud.discoveryengine.v1.Engine] resource name, in the
     * form of
     * `projects/{project}/locations/{location}/collections/{collection_id}/engines/{engine_id}`.
     *
     * Optional. Only required for
     * [Engine][google.cloud.discoveryengine.v1.Engine] produced user events. For
     * example, user events from blended search.
     * </pre>
     *
     * <code>string engine = 19 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The engine to set.
     * @return This builder for chaining.
     */
    public Builder setEngine(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      engine_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The [Engine][google.cloud.discoveryengine.v1.Engine] resource name, in the
     * form of
     * `projects/{project}/locations/{location}/collections/{collection_id}/engines/{engine_id}`.
     *
     * Optional. Only required for
     * [Engine][google.cloud.discoveryengine.v1.Engine] produced user events. For
     * example, user events from blended search.
     * </pre>
     *
     * <code>string engine = 19 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEngine() {
      engine_ = getDefaultInstance().getEngine();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The [Engine][google.cloud.discoveryengine.v1.Engine] resource name, in the
     * form of
     * `projects/{project}/locations/{location}/collections/{collection_id}/engines/{engine_id}`.
     *
     * Optional. Only required for
     * [Engine][google.cloud.discoveryengine.v1.Engine] produced user events. For
     * example, user events from blended search.
     * </pre>
     *
     * <code>string engine = 19 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The bytes for engine to set.
     * @return This builder for chaining.
     */
    public Builder setEngineBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      engine_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object dataStore_ = "";

    /**
     *
     *
     * <pre>
     * The [DataStore][google.cloud.discoveryengine.v1.DataStore] resource full
     * name, of the form
     * `projects/{project}/locations/{location}/collections/{collection_id}/dataStores/{data_store_id}`.
     *
     * Optional. Only required for user events whose data store can't by
     * determined by
     * [UserEvent.engine][google.cloud.discoveryengine.v1.UserEvent.engine] or
     * [UserEvent.documents][google.cloud.discoveryengine.v1.UserEvent.documents].
     * If data store is set in the parent of write/import/collect user event
     * requests, this field can be omitted.
     * </pre>
     *
     * <code>string data_store = 20 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The dataStore.
     */
    public java.lang.String getDataStore() {
      java.lang.Object ref = dataStore_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        dataStore_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The [DataStore][google.cloud.discoveryengine.v1.DataStore] resource full
     * name, of the form
     * `projects/{project}/locations/{location}/collections/{collection_id}/dataStores/{data_store_id}`.
     *
     * Optional. Only required for user events whose data store can't by
     * determined by
     * [UserEvent.engine][google.cloud.discoveryengine.v1.UserEvent.engine] or
     * [UserEvent.documents][google.cloud.discoveryengine.v1.UserEvent.documents].
     * If data store is set in the parent of write/import/collect user event
     * requests, this field can be omitted.
     * </pre>
     *
     * <code>string data_store = 20 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for dataStore.
     */
    public com.google.protobuf.ByteString getDataStoreBytes() {
      java.lang.Object ref = dataStore_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        dataStore_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The [DataStore][google.cloud.discoveryengine.v1.DataStore] resource full
     * name, of the form
     * `projects/{project}/locations/{location}/collections/{collection_id}/dataStores/{data_store_id}`.
     *
     * Optional. Only required for user events whose data store can't by
     * determined by
     * [UserEvent.engine][google.cloud.discoveryengine.v1.UserEvent.engine] or
     * [UserEvent.documents][google.cloud.discoveryengine.v1.UserEvent.documents].
     * If data store is set in the parent of write/import/collect user event
     * requests, this field can be omitted.
     * </pre>
     *
     * <code>string data_store = 20 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The dataStore to set.
     * @return This builder for chaining.
     */
    public Builder setDataStore(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      dataStore_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The [DataStore][google.cloud.discoveryengine.v1.DataStore] resource full
     * name, of the form
     * `projects/{project}/locations/{location}/collections/{collection_id}/dataStores/{data_store_id}`.
     *
     * Optional. Only required for user events whose data store can't by
     * determined by
     * [UserEvent.engine][google.cloud.discoveryengine.v1.UserEvent.engine] or
     * [UserEvent.documents][google.cloud.discoveryengine.v1.UserEvent.documents].
     * If data store is set in the parent of write/import/collect user event
     * requests, this field can be omitted.
     * </pre>
     *
     * <code>string data_store = 20 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDataStore() {
      dataStore_ = getDefaultInstance().getDataStore();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The [DataStore][google.cloud.discoveryengine.v1.DataStore] resource full
     * name, of the form
     * `projects/{project}/locations/{location}/collections/{collection_id}/dataStores/{data_store_id}`.
     *
     * Optional. Only required for user events whose data store can't by
     * determined by
     * [UserEvent.engine][google.cloud.discoveryengine.v1.UserEvent.engine] or
     * [UserEvent.documents][google.cloud.discoveryengine.v1.UserEvent.documents].
     * If data store is set in the parent of write/import/collect user event
     * requests, this field can be omitted.
     * </pre>
     *
     * <code>string data_store = 20 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The bytes for dataStore to set.
     * @return This builder for chaining.
     */
    public Builder setDataStoreBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      dataStore_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp eventTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        eventTimeBuilder_;

    /**
     *
     *
     * <pre>
     * Only required for
     * [UserEventService.ImportUserEvents][google.cloud.discoveryengine.v1.UserEventService.ImportUserEvents]
     * method. Timestamp of when the user event happened.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp event_time = 3;</code>
     *
     * @return Whether the eventTime field is set.
     */
    public boolean hasEventTime() {
      return ((bitField0_ & 0x00000020) != 0);
    }

    /**
     *
     *
     * <pre>
     * Only required for
     * [UserEventService.ImportUserEvents][google.cloud.discoveryengine.v1.UserEventService.ImportUserEvents]
     * method. Timestamp of when the user event happened.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp event_time = 3;</code>
     *
     * @return The eventTime.
     */
    public com.google.protobuf.Timestamp getEventTime() {
      if (eventTimeBuilder_ == null) {
        return eventTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : eventTime_;
      } else {
        return eventTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Only required for
     * [UserEventService.ImportUserEvents][google.cloud.discoveryengine.v1.UserEventService.ImportUserEvents]
     * method. Timestamp of when the user event happened.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp event_time = 3;</code>
     */
    public Builder setEventTime(com.google.protobuf.Timestamp value) {
      if (eventTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        eventTime_ = value;
      } else {
        eventTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Only required for
     * [UserEventService.ImportUserEvents][google.cloud.discoveryengine.v1.UserEventService.ImportUserEvents]
     * method. Timestamp of when the user event happened.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp event_time = 3;</code>
     */
    public Builder setEventTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (eventTimeBuilder_ == null) {
        eventTime_ = builderForValue.build();
      } else {
        eventTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Only required for
     * [UserEventService.ImportUserEvents][google.cloud.discoveryengine.v1.UserEventService.ImportUserEvents]
     * method. Timestamp of when the user event happened.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp event_time = 3;</code>
     */
    public Builder mergeEventTime(com.google.protobuf.Timestamp value) {
      if (eventTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && eventTime_ != null
            && eventTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getEventTimeBuilder().mergeFrom(value);
        } else {
          eventTime_ = value;
        }
      } else {
        eventTimeBuilder_.mergeFrom(value);
      }
      if (eventTime_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Only required for
     * [UserEventService.ImportUserEvents][google.cloud.discoveryengine.v1.UserEventService.ImportUserEvents]
     * method. Timestamp of when the user event happened.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp event_time = 3;</code>
     */
    public Builder clearEventTime() {
      bitField0_ = (bitField0_ & ~0x00000020);
      eventTime_ = null;
      if (eventTimeBuilder_ != null) {
        eventTimeBuilder_.dispose();
        eventTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Only required for
     * [UserEventService.ImportUserEvents][google.cloud.discoveryengine.v1.UserEventService.ImportUserEvents]
     * method. Timestamp of when the user event happened.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp event_time = 3;</code>
     */
    public com.google.protobuf.Timestamp.Builder getEventTimeBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getEventTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Only required for
     * [UserEventService.ImportUserEvents][google.cloud.discoveryengine.v1.UserEventService.ImportUserEvents]
     * method. Timestamp of when the user event happened.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp event_time = 3;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getEventTimeOrBuilder() {
      if (eventTimeBuilder_ != null) {
        return eventTimeBuilder_.getMessageOrBuilder();
      } else {
        return eventTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : eventTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * Only required for
     * [UserEventService.ImportUserEvents][google.cloud.discoveryengine.v1.UserEventService.ImportUserEvents]
     * method. Timestamp of when the user event happened.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp event_time = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getEventTimeFieldBuilder() {
      if (eventTimeBuilder_ == null) {
        eventTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getEventTime(), getParentForChildren(), isClean());
        eventTime_ = null;
      }
      return eventTimeBuilder_;
    }

    private com.google.cloud.discoveryengine.v1.UserInfo userInfo_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1.UserInfo,
            com.google.cloud.discoveryengine.v1.UserInfo.Builder,
            com.google.cloud.discoveryengine.v1.UserInfoOrBuilder>
        userInfoBuilder_;

    /**
     *
     *
     * <pre>
     * Information about the end user.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.UserInfo user_info = 4;</code>
     *
     * @return Whether the userInfo field is set.
     */
    public boolean hasUserInfo() {
      return ((bitField0_ & 0x00000040) != 0);
    }

    /**
     *
     *
     * <pre>
     * Information about the end user.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.UserInfo user_info = 4;</code>
     *
     * @return The userInfo.
     */
    public com.google.cloud.discoveryengine.v1.UserInfo getUserInfo() {
      if (userInfoBuilder_ == null) {
        return userInfo_ == null
            ? com.google.cloud.discoveryengine.v1.UserInfo.getDefaultInstance()
            : userInfo_;
      } else {
        return userInfoBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Information about the end user.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.UserInfo user_info = 4;</code>
     */
    public Builder setUserInfo(com.google.cloud.discoveryengine.v1.UserInfo value) {
      if (userInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        userInfo_ = value;
      } else {
        userInfoBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Information about the end user.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.UserInfo user_info = 4;</code>
     */
    public Builder setUserInfo(
        com.google.cloud.discoveryengine.v1.UserInfo.Builder builderForValue) {
      if (userInfoBuilder_ == null) {
        userInfo_ = builderForValue.build();
      } else {
        userInfoBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Information about the end user.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.UserInfo user_info = 4;</code>
     */
    public Builder mergeUserInfo(com.google.cloud.discoveryengine.v1.UserInfo value) {
      if (userInfoBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && userInfo_ != null
            && userInfo_ != com.google.cloud.discoveryengine.v1.UserInfo.getDefaultInstance()) {
          getUserInfoBuilder().mergeFrom(value);
        } else {
          userInfo_ = value;
        }
      } else {
        userInfoBuilder_.mergeFrom(value);
      }
      if (userInfo_ != null) {
        bitField0_ |= 0x00000040;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Information about the end user.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.UserInfo user_info = 4;</code>
     */
    public Builder clearUserInfo() {
      bitField0_ = (bitField0_ & ~0x00000040);
      userInfo_ = null;
      if (userInfoBuilder_ != null) {
        userInfoBuilder_.dispose();
        userInfoBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Information about the end user.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.UserInfo user_info = 4;</code>
     */
    public com.google.cloud.discoveryengine.v1.UserInfo.Builder getUserInfoBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getUserInfoFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Information about the end user.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.UserInfo user_info = 4;</code>
     */
    public com.google.cloud.discoveryengine.v1.UserInfoOrBuilder getUserInfoOrBuilder() {
      if (userInfoBuilder_ != null) {
        return userInfoBuilder_.getMessageOrBuilder();
      } else {
        return userInfo_ == null
            ? com.google.cloud.discoveryengine.v1.UserInfo.getDefaultInstance()
            : userInfo_;
      }
    }

    /**
     *
     *
     * <pre>
     * Information about the end user.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.UserInfo user_info = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1.UserInfo,
            com.google.cloud.discoveryengine.v1.UserInfo.Builder,
            com.google.cloud.discoveryengine.v1.UserInfoOrBuilder>
        getUserInfoFieldBuilder() {
      if (userInfoBuilder_ == null) {
        userInfoBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1.UserInfo,
                com.google.cloud.discoveryengine.v1.UserInfo.Builder,
                com.google.cloud.discoveryengine.v1.UserInfoOrBuilder>(
                getUserInfo(), getParentForChildren(), isClean());
        userInfo_ = null;
      }
      return userInfoBuilder_;
    }

    private boolean directUserRequest_;

    /**
     *
     *
     * <pre>
     * Should set to true if the request is made directly from the end user, in
     * which case the
     * [UserEvent.user_info.user_agent][google.cloud.discoveryengine.v1.UserInfo.user_agent]
     * can be populated from the HTTP request.
     *
     * This flag should be set only if the API request is made directly from the
     * end user such as a mobile app (and not if a gateway or a server is
     * processing and pushing the user events).
     *
     * This should not be set when using the JavaScript tag in
     * [UserEventService.CollectUserEvent][google.cloud.discoveryengine.v1.UserEventService.CollectUserEvent].
     * </pre>
     *
     * <code>bool direct_user_request = 5;</code>
     *
     * @return The directUserRequest.
     */
    @java.lang.Override
    public boolean getDirectUserRequest() {
      return directUserRequest_;
    }

    /**
     *
     *
     * <pre>
     * Should set to true if the request is made directly from the end user, in
     * which case the
     * [UserEvent.user_info.user_agent][google.cloud.discoveryengine.v1.UserInfo.user_agent]
     * can be populated from the HTTP request.
     *
     * This flag should be set only if the API request is made directly from the
     * end user such as a mobile app (and not if a gateway or a server is
     * processing and pushing the user events).
     *
     * This should not be set when using the JavaScript tag in
     * [UserEventService.CollectUserEvent][google.cloud.discoveryengine.v1.UserEventService.CollectUserEvent].
     * </pre>
     *
     * <code>bool direct_user_request = 5;</code>
     *
     * @param value The directUserRequest to set.
     * @return This builder for chaining.
     */
    public Builder setDirectUserRequest(boolean value) {

      directUserRequest_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Should set to true if the request is made directly from the end user, in
     * which case the
     * [UserEvent.user_info.user_agent][google.cloud.discoveryengine.v1.UserInfo.user_agent]
     * can be populated from the HTTP request.
     *
     * This flag should be set only if the API request is made directly from the
     * end user such as a mobile app (and not if a gateway or a server is
     * processing and pushing the user events).
     *
     * This should not be set when using the JavaScript tag in
     * [UserEventService.CollectUserEvent][google.cloud.discoveryengine.v1.UserEventService.CollectUserEvent].
     * </pre>
     *
     * <code>bool direct_user_request = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDirectUserRequest() {
      bitField0_ = (bitField0_ & ~0x00000080);
      directUserRequest_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object sessionId_ = "";

    /**
     *
     *
     * <pre>
     * A unique identifier for tracking a visitor session with a length limit of
     * 128 bytes. A session is an aggregation of an end user behavior in a time
     * span.
     *
     * A general guideline to populate the session_id:
     *
     * 1. If user has no activity for 30 min, a new session_id should be assigned.
     * 2. The session_id should be unique across users, suggest use uuid or add
     * [UserEvent.user_pseudo_id][google.cloud.discoveryengine.v1.UserEvent.user_pseudo_id]
     * as prefix.
     * </pre>
     *
     * <code>string session_id = 6;</code>
     *
     * @return The sessionId.
     */
    public java.lang.String getSessionId() {
      java.lang.Object ref = sessionId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        sessionId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * A unique identifier for tracking a visitor session with a length limit of
     * 128 bytes. A session is an aggregation of an end user behavior in a time
     * span.
     *
     * A general guideline to populate the session_id:
     *
     * 1. If user has no activity for 30 min, a new session_id should be assigned.
     * 2. The session_id should be unique across users, suggest use uuid or add
     * [UserEvent.user_pseudo_id][google.cloud.discoveryengine.v1.UserEvent.user_pseudo_id]
     * as prefix.
     * </pre>
     *
     * <code>string session_id = 6;</code>
     *
     * @return The bytes for sessionId.
     */
    public com.google.protobuf.ByteString getSessionIdBytes() {
      java.lang.Object ref = sessionId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        sessionId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * A unique identifier for tracking a visitor session with a length limit of
     * 128 bytes. A session is an aggregation of an end user behavior in a time
     * span.
     *
     * A general guideline to populate the session_id:
     *
     * 1. If user has no activity for 30 min, a new session_id should be assigned.
     * 2. The session_id should be unique across users, suggest use uuid or add
     * [UserEvent.user_pseudo_id][google.cloud.discoveryengine.v1.UserEvent.user_pseudo_id]
     * as prefix.
     * </pre>
     *
     * <code>string session_id = 6;</code>
     *
     * @param value The sessionId to set.
     * @return This builder for chaining.
     */
    public Builder setSessionId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      sessionId_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A unique identifier for tracking a visitor session with a length limit of
     * 128 bytes. A session is an aggregation of an end user behavior in a time
     * span.
     *
     * A general guideline to populate the session_id:
     *
     * 1. If user has no activity for 30 min, a new session_id should be assigned.
     * 2. The session_id should be unique across users, suggest use uuid or add
     * [UserEvent.user_pseudo_id][google.cloud.discoveryengine.v1.UserEvent.user_pseudo_id]
     * as prefix.
     * </pre>
     *
     * <code>string session_id = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSessionId() {
      sessionId_ = getDefaultInstance().getSessionId();
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A unique identifier for tracking a visitor session with a length limit of
     * 128 bytes. A session is an aggregation of an end user behavior in a time
     * span.
     *
     * A general guideline to populate the session_id:
     *
     * 1. If user has no activity for 30 min, a new session_id should be assigned.
     * 2. The session_id should be unique across users, suggest use uuid or add
     * [UserEvent.user_pseudo_id][google.cloud.discoveryengine.v1.UserEvent.user_pseudo_id]
     * as prefix.
     * </pre>
     *
     * <code>string session_id = 6;</code>
     *
     * @param value The bytes for sessionId to set.
     * @return This builder for chaining.
     */
    public Builder setSessionIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      sessionId_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    private com.google.cloud.discoveryengine.v1.PageInfo pageInfo_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1.PageInfo,
            com.google.cloud.discoveryengine.v1.PageInfo.Builder,
            com.google.cloud.discoveryengine.v1.PageInfoOrBuilder>
        pageInfoBuilder_;

    /**
     *
     *
     * <pre>
     * Page metadata such as categories and other critical information for certain
     * event types such as `view-category-page`.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.PageInfo page_info = 7;</code>
     *
     * @return Whether the pageInfo field is set.
     */
    public boolean hasPageInfo() {
      return ((bitField0_ & 0x00000200) != 0);
    }

    /**
     *
     *
     * <pre>
     * Page metadata such as categories and other critical information for certain
     * event types such as `view-category-page`.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.PageInfo page_info = 7;</code>
     *
     * @return The pageInfo.
     */
    public com.google.cloud.discoveryengine.v1.PageInfo getPageInfo() {
      if (pageInfoBuilder_ == null) {
        return pageInfo_ == null
            ? com.google.cloud.discoveryengine.v1.PageInfo.getDefaultInstance()
            : pageInfo_;
      } else {
        return pageInfoBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Page metadata such as categories and other critical information for certain
     * event types such as `view-category-page`.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.PageInfo page_info = 7;</code>
     */
    public Builder setPageInfo(com.google.cloud.discoveryengine.v1.PageInfo value) {
      if (pageInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        pageInfo_ = value;
      } else {
        pageInfoBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Page metadata such as categories and other critical information for certain
     * event types such as `view-category-page`.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.PageInfo page_info = 7;</code>
     */
    public Builder setPageInfo(
        com.google.cloud.discoveryengine.v1.PageInfo.Builder builderForValue) {
      if (pageInfoBuilder_ == null) {
        pageInfo_ = builderForValue.build();
      } else {
        pageInfoBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Page metadata such as categories and other critical information for certain
     * event types such as `view-category-page`.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.PageInfo page_info = 7;</code>
     */
    public Builder mergePageInfo(com.google.cloud.discoveryengine.v1.PageInfo value) {
      if (pageInfoBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)
            && pageInfo_ != null
            && pageInfo_ != com.google.cloud.discoveryengine.v1.PageInfo.getDefaultInstance()) {
          getPageInfoBuilder().mergeFrom(value);
        } else {
          pageInfo_ = value;
        }
      } else {
        pageInfoBuilder_.mergeFrom(value);
      }
      if (pageInfo_ != null) {
        bitField0_ |= 0x00000200;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Page metadata such as categories and other critical information for certain
     * event types such as `view-category-page`.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.PageInfo page_info = 7;</code>
     */
    public Builder clearPageInfo() {
      bitField0_ = (bitField0_ & ~0x00000200);
      pageInfo_ = null;
      if (pageInfoBuilder_ != null) {
        pageInfoBuilder_.dispose();
        pageInfoBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Page metadata such as categories and other critical information for certain
     * event types such as `view-category-page`.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.PageInfo page_info = 7;</code>
     */
    public com.google.cloud.discoveryengine.v1.PageInfo.Builder getPageInfoBuilder() {
      bitField0_ |= 0x00000200;
      onChanged();
      return getPageInfoFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Page metadata such as categories and other critical information for certain
     * event types such as `view-category-page`.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.PageInfo page_info = 7;</code>
     */
    public com.google.cloud.discoveryengine.v1.PageInfoOrBuilder getPageInfoOrBuilder() {
      if (pageInfoBuilder_ != null) {
        return pageInfoBuilder_.getMessageOrBuilder();
      } else {
        return pageInfo_ == null
            ? com.google.cloud.discoveryengine.v1.PageInfo.getDefaultInstance()
            : pageInfo_;
      }
    }

    /**
     *
     *
     * <pre>
     * Page metadata such as categories and other critical information for certain
     * event types such as `view-category-page`.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.PageInfo page_info = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1.PageInfo,
            com.google.cloud.discoveryengine.v1.PageInfo.Builder,
            com.google.cloud.discoveryengine.v1.PageInfoOrBuilder>
        getPageInfoFieldBuilder() {
      if (pageInfoBuilder_ == null) {
        pageInfoBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1.PageInfo,
                com.google.cloud.discoveryengine.v1.PageInfo.Builder,
                com.google.cloud.discoveryengine.v1.PageInfoOrBuilder>(
                getPageInfo(), getParentForChildren(), isClean());
        pageInfo_ = null;
      }
      return pageInfoBuilder_;
    }

    private java.lang.Object attributionToken_ = "";

    /**
     *
     *
     * <pre>
     * Token to attribute an API response to user action(s) to trigger the event.
     *
     * Highly recommended for user events that are the result of
     * [RecommendationService.Recommend][google.cloud.discoveryengine.v1.RecommendationService.Recommend].
     * This field enables accurate attribution of recommendation model
     * performance.
     *
     * The value must be one of:
     *
     * * [RecommendResponse.attribution_token][google.cloud.discoveryengine.v1.RecommendResponse.attribution_token] for events that are the result of
     * [RecommendationService.Recommend][google.cloud.discoveryengine.v1.RecommendationService.Recommend].
     * * [SearchResponse.attribution_token][google.cloud.discoveryengine.v1.SearchResponse.attribution_token] for events that are the result of
     * [SearchService.Search][google.cloud.discoveryengine.v1.SearchService.Search].
     *
     * This token enables us to accurately attribute page view or conversion
     * completion back to the event and the particular predict response containing
     * this clicked/purchased product. If user clicks on product K in the
     * recommendation results, pass
     * [RecommendResponse.attribution_token][google.cloud.discoveryengine.v1.RecommendResponse.attribution_token]
     * as a URL parameter to product K's page. When recording events on product
     * K's page, log the
     * [RecommendResponse.attribution_token][google.cloud.discoveryengine.v1.RecommendResponse.attribution_token]
     * to this field.
     * </pre>
     *
     * <code>string attribution_token = 8;</code>
     *
     * @return The attributionToken.
     */
    public java.lang.String getAttributionToken() {
      java.lang.Object ref = attributionToken_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        attributionToken_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Token to attribute an API response to user action(s) to trigger the event.
     *
     * Highly recommended for user events that are the result of
     * [RecommendationService.Recommend][google.cloud.discoveryengine.v1.RecommendationService.Recommend].
     * This field enables accurate attribution of recommendation model
     * performance.
     *
     * The value must be one of:
     *
     * * [RecommendResponse.attribution_token][google.cloud.discoveryengine.v1.RecommendResponse.attribution_token] for events that are the result of
     * [RecommendationService.Recommend][google.cloud.discoveryengine.v1.RecommendationService.Recommend].
     * * [SearchResponse.attribution_token][google.cloud.discoveryengine.v1.SearchResponse.attribution_token] for events that are the result of
     * [SearchService.Search][google.cloud.discoveryengine.v1.SearchService.Search].
     *
     * This token enables us to accurately attribute page view or conversion
     * completion back to the event and the particular predict response containing
     * this clicked/purchased product. If user clicks on product K in the
     * recommendation results, pass
     * [RecommendResponse.attribution_token][google.cloud.discoveryengine.v1.RecommendResponse.attribution_token]
     * as a URL parameter to product K's page. When recording events on product
     * K's page, log the
     * [RecommendResponse.attribution_token][google.cloud.discoveryengine.v1.RecommendResponse.attribution_token]
     * to this field.
     * </pre>
     *
     * <code>string attribution_token = 8;</code>
     *
     * @return The bytes for attributionToken.
     */
    public com.google.protobuf.ByteString getAttributionTokenBytes() {
      java.lang.Object ref = attributionToken_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        attributionToken_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Token to attribute an API response to user action(s) to trigger the event.
     *
     * Highly recommended for user events that are the result of
     * [RecommendationService.Recommend][google.cloud.discoveryengine.v1.RecommendationService.Recommend].
     * This field enables accurate attribution of recommendation model
     * performance.
     *
     * The value must be one of:
     *
     * * [RecommendResponse.attribution_token][google.cloud.discoveryengine.v1.RecommendResponse.attribution_token] for events that are the result of
     * [RecommendationService.Recommend][google.cloud.discoveryengine.v1.RecommendationService.Recommend].
     * * [SearchResponse.attribution_token][google.cloud.discoveryengine.v1.SearchResponse.attribution_token] for events that are the result of
     * [SearchService.Search][google.cloud.discoveryengine.v1.SearchService.Search].
     *
     * This token enables us to accurately attribute page view or conversion
     * completion back to the event and the particular predict response containing
     * this clicked/purchased product. If user clicks on product K in the
     * recommendation results, pass
     * [RecommendResponse.attribution_token][google.cloud.discoveryengine.v1.RecommendResponse.attribution_token]
     * as a URL parameter to product K's page. When recording events on product
     * K's page, log the
     * [RecommendResponse.attribution_token][google.cloud.discoveryengine.v1.RecommendResponse.attribution_token]
     * to this field.
     * </pre>
     *
     * <code>string attribution_token = 8;</code>
     *
     * @param value The attributionToken to set.
     * @return This builder for chaining.
     */
    public Builder setAttributionToken(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      attributionToken_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Token to attribute an API response to user action(s) to trigger the event.
     *
     * Highly recommended for user events that are the result of
     * [RecommendationService.Recommend][google.cloud.discoveryengine.v1.RecommendationService.Recommend].
     * This field enables accurate attribution of recommendation model
     * performance.
     *
     * The value must be one of:
     *
     * * [RecommendResponse.attribution_token][google.cloud.discoveryengine.v1.RecommendResponse.attribution_token] for events that are the result of
     * [RecommendationService.Recommend][google.cloud.discoveryengine.v1.RecommendationService.Recommend].
     * * [SearchResponse.attribution_token][google.cloud.discoveryengine.v1.SearchResponse.attribution_token] for events that are the result of
     * [SearchService.Search][google.cloud.discoveryengine.v1.SearchService.Search].
     *
     * This token enables us to accurately attribute page view or conversion
     * completion back to the event and the particular predict response containing
     * this clicked/purchased product. If user clicks on product K in the
     * recommendation results, pass
     * [RecommendResponse.attribution_token][google.cloud.discoveryengine.v1.RecommendResponse.attribution_token]
     * as a URL parameter to product K's page. When recording events on product
     * K's page, log the
     * [RecommendResponse.attribution_token][google.cloud.discoveryengine.v1.RecommendResponse.attribution_token]
     * to this field.
     * </pre>
     *
     * <code>string attribution_token = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAttributionToken() {
      attributionToken_ = getDefaultInstance().getAttributionToken();
      bitField0_ = (bitField0_ & ~0x00000400);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Token to attribute an API response to user action(s) to trigger the event.
     *
     * Highly recommended for user events that are the result of
     * [RecommendationService.Recommend][google.cloud.discoveryengine.v1.RecommendationService.Recommend].
     * This field enables accurate attribution of recommendation model
     * performance.
     *
     * The value must be one of:
     *
     * * [RecommendResponse.attribution_token][google.cloud.discoveryengine.v1.RecommendResponse.attribution_token] for events that are the result of
     * [RecommendationService.Recommend][google.cloud.discoveryengine.v1.RecommendationService.Recommend].
     * * [SearchResponse.attribution_token][google.cloud.discoveryengine.v1.SearchResponse.attribution_token] for events that are the result of
     * [SearchService.Search][google.cloud.discoveryengine.v1.SearchService.Search].
     *
     * This token enables us to accurately attribute page view or conversion
     * completion back to the event and the particular predict response containing
     * this clicked/purchased product. If user clicks on product K in the
     * recommendation results, pass
     * [RecommendResponse.attribution_token][google.cloud.discoveryengine.v1.RecommendResponse.attribution_token]
     * as a URL parameter to product K's page. When recording events on product
     * K's page, log the
     * [RecommendResponse.attribution_token][google.cloud.discoveryengine.v1.RecommendResponse.attribution_token]
     * to this field.
     * </pre>
     *
     * <code>string attribution_token = 8;</code>
     *
     * @param value The bytes for attributionToken to set.
     * @return This builder for chaining.
     */
    public Builder setAttributionTokenBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      attributionToken_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    private java.lang.Object filter_ = "";

    /**
     *
     *
     * <pre>
     * The filter syntax consists of an expression language for constructing a
     * predicate from one or more fields of the documents being filtered.
     *
     * One example is for `search` events, the associated
     * [SearchRequest][google.cloud.discoveryengine.v1.SearchRequest] may contain
     * a filter expression in
     * [SearchRequest.filter][google.cloud.discoveryengine.v1.SearchRequest.filter]
     * conforming to https://google.aip.dev/160#filtering.
     *
     * Similarly, for `view-item-list` events that are generated from a
     * [RecommendRequest][google.cloud.discoveryengine.v1.RecommendRequest], this
     * field may be populated directly from
     * [RecommendRequest.filter][google.cloud.discoveryengine.v1.RecommendRequest.filter]
     * conforming to https://google.aip.dev/160#filtering.
     *
     * The value must be a UTF-8 encoded string with a length limit of 1,000
     * characters. Otherwise, an `INVALID_ARGUMENT` error is returned.
     * </pre>
     *
     * <code>string filter = 9;</code>
     *
     * @return The filter.
     */
    public java.lang.String getFilter() {
      java.lang.Object ref = filter_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        filter_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The filter syntax consists of an expression language for constructing a
     * predicate from one or more fields of the documents being filtered.
     *
     * One example is for `search` events, the associated
     * [SearchRequest][google.cloud.discoveryengine.v1.SearchRequest] may contain
     * a filter expression in
     * [SearchRequest.filter][google.cloud.discoveryengine.v1.SearchRequest.filter]
     * conforming to https://google.aip.dev/160#filtering.
     *
     * Similarly, for `view-item-list` events that are generated from a
     * [RecommendRequest][google.cloud.discoveryengine.v1.RecommendRequest], this
     * field may be populated directly from
     * [RecommendRequest.filter][google.cloud.discoveryengine.v1.RecommendRequest.filter]
     * conforming to https://google.aip.dev/160#filtering.
     *
     * The value must be a UTF-8 encoded string with a length limit of 1,000
     * characters. Otherwise, an `INVALID_ARGUMENT` error is returned.
     * </pre>
     *
     * <code>string filter = 9;</code>
     *
     * @return The bytes for filter.
     */
    public com.google.protobuf.ByteString getFilterBytes() {
      java.lang.Object ref = filter_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        filter_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The filter syntax consists of an expression language for constructing a
     * predicate from one or more fields of the documents being filtered.
     *
     * One example is for `search` events, the associated
     * [SearchRequest][google.cloud.discoveryengine.v1.SearchRequest] may contain
     * a filter expression in
     * [SearchRequest.filter][google.cloud.discoveryengine.v1.SearchRequest.filter]
     * conforming to https://google.aip.dev/160#filtering.
     *
     * Similarly, for `view-item-list` events that are generated from a
     * [RecommendRequest][google.cloud.discoveryengine.v1.RecommendRequest], this
     * field may be populated directly from
     * [RecommendRequest.filter][google.cloud.discoveryengine.v1.RecommendRequest.filter]
     * conforming to https://google.aip.dev/160#filtering.
     *
     * The value must be a UTF-8 encoded string with a length limit of 1,000
     * characters. Otherwise, an `INVALID_ARGUMENT` error is returned.
     * </pre>
     *
     * <code>string filter = 9;</code>
     *
     * @param value The filter to set.
     * @return This builder for chaining.
     */
    public Builder setFilter(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      filter_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The filter syntax consists of an expression language for constructing a
     * predicate from one or more fields of the documents being filtered.
     *
     * One example is for `search` events, the associated
     * [SearchRequest][google.cloud.discoveryengine.v1.SearchRequest] may contain
     * a filter expression in
     * [SearchRequest.filter][google.cloud.discoveryengine.v1.SearchRequest.filter]
     * conforming to https://google.aip.dev/160#filtering.
     *
     * Similarly, for `view-item-list` events that are generated from a
     * [RecommendRequest][google.cloud.discoveryengine.v1.RecommendRequest], this
     * field may be populated directly from
     * [RecommendRequest.filter][google.cloud.discoveryengine.v1.RecommendRequest.filter]
     * conforming to https://google.aip.dev/160#filtering.
     *
     * The value must be a UTF-8 encoded string with a length limit of 1,000
     * characters. Otherwise, an `INVALID_ARGUMENT` error is returned.
     * </pre>
     *
     * <code>string filter = 9;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFilter() {
      filter_ = getDefaultInstance().getFilter();
      bitField0_ = (bitField0_ & ~0x00000800);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The filter syntax consists of an expression language for constructing a
     * predicate from one or more fields of the documents being filtered.
     *
     * One example is for `search` events, the associated
     * [SearchRequest][google.cloud.discoveryengine.v1.SearchRequest] may contain
     * a filter expression in
     * [SearchRequest.filter][google.cloud.discoveryengine.v1.SearchRequest.filter]
     * conforming to https://google.aip.dev/160#filtering.
     *
     * Similarly, for `view-item-list` events that are generated from a
     * [RecommendRequest][google.cloud.discoveryengine.v1.RecommendRequest], this
     * field may be populated directly from
     * [RecommendRequest.filter][google.cloud.discoveryengine.v1.RecommendRequest.filter]
     * conforming to https://google.aip.dev/160#filtering.
     *
     * The value must be a UTF-8 encoded string with a length limit of 1,000
     * characters. Otherwise, an `INVALID_ARGUMENT` error is returned.
     * </pre>
     *
     * <code>string filter = 9;</code>
     *
     * @param value The bytes for filter to set.
     * @return This builder for chaining.
     */
    public Builder setFilterBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      filter_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.discoveryengine.v1.DocumentInfo> documents_ =
        java.util.Collections.emptyList();

    private void ensureDocumentsIsMutable() {
      if (!((bitField0_ & 0x00001000) != 0)) {
        documents_ =
            new java.util.ArrayList<com.google.cloud.discoveryengine.v1.DocumentInfo>(documents_);
        bitField0_ |= 0x00001000;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.discoveryengine.v1.DocumentInfo,
            com.google.cloud.discoveryengine.v1.DocumentInfo.Builder,
            com.google.cloud.discoveryengine.v1.DocumentInfoOrBuilder>
        documentsBuilder_;

    /**
     *
     *
     * <pre>
     * List of [Document][google.cloud.discoveryengine.v1.Document]s associated
     * with this user event.
     *
     * This field is optional except for the following event types:
     *
     * * `view-item`
     * * `add-to-cart`
     * * `purchase`
     * * `media-play`
     * * `media-complete`
     *
     * In a `search` event, this field represents the documents returned to the
     * end user on the current page (the end user may have not finished browsing
     * the whole page yet). When a new page is returned to the end user, after
     * pagination/filtering/ordering even for the same query, a new `search` event
     * with different
     * [UserEvent.documents][google.cloud.discoveryengine.v1.UserEvent.documents]
     * is desired.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.DocumentInfo documents = 10;</code>
     */
    public java.util.List<com.google.cloud.discoveryengine.v1.DocumentInfo> getDocumentsList() {
      if (documentsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(documents_);
      } else {
        return documentsBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * List of [Document][google.cloud.discoveryengine.v1.Document]s associated
     * with this user event.
     *
     * This field is optional except for the following event types:
     *
     * * `view-item`
     * * `add-to-cart`
     * * `purchase`
     * * `media-play`
     * * `media-complete`
     *
     * In a `search` event, this field represents the documents returned to the
     * end user on the current page (the end user may have not finished browsing
     * the whole page yet). When a new page is returned to the end user, after
     * pagination/filtering/ordering even for the same query, a new `search` event
     * with different
     * [UserEvent.documents][google.cloud.discoveryengine.v1.UserEvent.documents]
     * is desired.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.DocumentInfo documents = 10;</code>
     */
    public int getDocumentsCount() {
      if (documentsBuilder_ == null) {
        return documents_.size();
      } else {
        return documentsBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * List of [Document][google.cloud.discoveryengine.v1.Document]s associated
     * with this user event.
     *
     * This field is optional except for the following event types:
     *
     * * `view-item`
     * * `add-to-cart`
     * * `purchase`
     * * `media-play`
     * * `media-complete`
     *
     * In a `search` event, this field represents the documents returned to the
     * end user on the current page (the end user may have not finished browsing
     * the whole page yet). When a new page is returned to the end user, after
     * pagination/filtering/ordering even for the same query, a new `search` event
     * with different
     * [UserEvent.documents][google.cloud.discoveryengine.v1.UserEvent.documents]
     * is desired.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.DocumentInfo documents = 10;</code>
     */
    public com.google.cloud.discoveryengine.v1.DocumentInfo getDocuments(int index) {
      if (documentsBuilder_ == null) {
        return documents_.get(index);
      } else {
        return documentsBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * List of [Document][google.cloud.discoveryengine.v1.Document]s associated
     * with this user event.
     *
     * This field is optional except for the following event types:
     *
     * * `view-item`
     * * `add-to-cart`
     * * `purchase`
     * * `media-play`
     * * `media-complete`
     *
     * In a `search` event, this field represents the documents returned to the
     * end user on the current page (the end user may have not finished browsing
     * the whole page yet). When a new page is returned to the end user, after
     * pagination/filtering/ordering even for the same query, a new `search` event
     * with different
     * [UserEvent.documents][google.cloud.discoveryengine.v1.UserEvent.documents]
     * is desired.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.DocumentInfo documents = 10;</code>
     */
    public Builder setDocuments(int index, com.google.cloud.discoveryengine.v1.DocumentInfo value) {
      if (documentsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDocumentsIsMutable();
        documents_.set(index, value);
        onChanged();
      } else {
        documentsBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * List of [Document][google.cloud.discoveryengine.v1.Document]s associated
     * with this user event.
     *
     * This field is optional except for the following event types:
     *
     * * `view-item`
     * * `add-to-cart`
     * * `purchase`
     * * `media-play`
     * * `media-complete`
     *
     * In a `search` event, this field represents the documents returned to the
     * end user on the current page (the end user may have not finished browsing
     * the whole page yet). When a new page is returned to the end user, after
     * pagination/filtering/ordering even for the same query, a new `search` event
     * with different
     * [UserEvent.documents][google.cloud.discoveryengine.v1.UserEvent.documents]
     * is desired.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.DocumentInfo documents = 10;</code>
     */
    public Builder setDocuments(
        int index, com.google.cloud.discoveryengine.v1.DocumentInfo.Builder builderForValue) {
      if (documentsBuilder_ == null) {
        ensureDocumentsIsMutable();
        documents_.set(index, builderForValue.build());
        onChanged();
      } else {
        documentsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * List of [Document][google.cloud.discoveryengine.v1.Document]s associated
     * with this user event.
     *
     * This field is optional except for the following event types:
     *
     * * `view-item`
     * * `add-to-cart`
     * * `purchase`
     * * `media-play`
     * * `media-complete`
     *
     * In a `search` event, this field represents the documents returned to the
     * end user on the current page (the end user may have not finished browsing
     * the whole page yet). When a new page is returned to the end user, after
     * pagination/filtering/ordering even for the same query, a new `search` event
     * with different
     * [UserEvent.documents][google.cloud.discoveryengine.v1.UserEvent.documents]
     * is desired.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.DocumentInfo documents = 10;</code>
     */
    public Builder addDocuments(com.google.cloud.discoveryengine.v1.DocumentInfo value) {
      if (documentsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDocumentsIsMutable();
        documents_.add(value);
        onChanged();
      } else {
        documentsBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * List of [Document][google.cloud.discoveryengine.v1.Document]s associated
     * with this user event.
     *
     * This field is optional except for the following event types:
     *
     * * `view-item`
     * * `add-to-cart`
     * * `purchase`
     * * `media-play`
     * * `media-complete`
     *
     * In a `search` event, this field represents the documents returned to the
     * end user on the current page (the end user may have not finished browsing
     * the whole page yet). When a new page is returned to the end user, after
     * pagination/filtering/ordering even for the same query, a new `search` event
     * with different
     * [UserEvent.documents][google.cloud.discoveryengine.v1.UserEvent.documents]
     * is desired.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.DocumentInfo documents = 10;</code>
     */
    public Builder addDocuments(int index, com.google.cloud.discoveryengine.v1.DocumentInfo value) {
      if (documentsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDocumentsIsMutable();
        documents_.add(index, value);
        onChanged();
      } else {
        documentsBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * List of [Document][google.cloud.discoveryengine.v1.Document]s associated
     * with this user event.
     *
     * This field is optional except for the following event types:
     *
     * * `view-item`
     * * `add-to-cart`
     * * `purchase`
     * * `media-play`
     * * `media-complete`
     *
     * In a `search` event, this field represents the documents returned to the
     * end user on the current page (the end user may have not finished browsing
     * the whole page yet). When a new page is returned to the end user, after
     * pagination/filtering/ordering even for the same query, a new `search` event
     * with different
     * [UserEvent.documents][google.cloud.discoveryengine.v1.UserEvent.documents]
     * is desired.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.DocumentInfo documents = 10;</code>
     */
    public Builder addDocuments(
        com.google.cloud.discoveryengine.v1.DocumentInfo.Builder builderForValue) {
      if (documentsBuilder_ == null) {
        ensureDocumentsIsMutable();
        documents_.add(builderForValue.build());
        onChanged();
      } else {
        documentsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * List of [Document][google.cloud.discoveryengine.v1.Document]s associated
     * with this user event.
     *
     * This field is optional except for the following event types:
     *
     * * `view-item`
     * * `add-to-cart`
     * * `purchase`
     * * `media-play`
     * * `media-complete`
     *
     * In a `search` event, this field represents the documents returned to the
     * end user on the current page (the end user may have not finished browsing
     * the whole page yet). When a new page is returned to the end user, after
     * pagination/filtering/ordering even for the same query, a new `search` event
     * with different
     * [UserEvent.documents][google.cloud.discoveryengine.v1.UserEvent.documents]
     * is desired.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.DocumentInfo documents = 10;</code>
     */
    public Builder addDocuments(
        int index, com.google.cloud.discoveryengine.v1.DocumentInfo.Builder builderForValue) {
      if (documentsBuilder_ == null) {
        ensureDocumentsIsMutable();
        documents_.add(index, builderForValue.build());
        onChanged();
      } else {
        documentsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * List of [Document][google.cloud.discoveryengine.v1.Document]s associated
     * with this user event.
     *
     * This field is optional except for the following event types:
     *
     * * `view-item`
     * * `add-to-cart`
     * * `purchase`
     * * `media-play`
     * * `media-complete`
     *
     * In a `search` event, this field represents the documents returned to the
     * end user on the current page (the end user may have not finished browsing
     * the whole page yet). When a new page is returned to the end user, after
     * pagination/filtering/ordering even for the same query, a new `search` event
     * with different
     * [UserEvent.documents][google.cloud.discoveryengine.v1.UserEvent.documents]
     * is desired.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.DocumentInfo documents = 10;</code>
     */
    public Builder addAllDocuments(
        java.lang.Iterable<? extends com.google.cloud.discoveryengine.v1.DocumentInfo> values) {
      if (documentsBuilder_ == null) {
        ensureDocumentsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, documents_);
        onChanged();
      } else {
        documentsBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * List of [Document][google.cloud.discoveryengine.v1.Document]s associated
     * with this user event.
     *
     * This field is optional except for the following event types:
     *
     * * `view-item`
     * * `add-to-cart`
     * * `purchase`
     * * `media-play`
     * * `media-complete`
     *
     * In a `search` event, this field represents the documents returned to the
     * end user on the current page (the end user may have not finished browsing
     * the whole page yet). When a new page is returned to the end user, after
     * pagination/filtering/ordering even for the same query, a new `search` event
     * with different
     * [UserEvent.documents][google.cloud.discoveryengine.v1.UserEvent.documents]
     * is desired.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.DocumentInfo documents = 10;</code>
     */
    public Builder clearDocuments() {
      if (documentsBuilder_ == null) {
        documents_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00001000);
        onChanged();
      } else {
        documentsBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * List of [Document][google.cloud.discoveryengine.v1.Document]s associated
     * with this user event.
     *
     * This field is optional except for the following event types:
     *
     * * `view-item`
     * * `add-to-cart`
     * * `purchase`
     * * `media-play`
     * * `media-complete`
     *
     * In a `search` event, this field represents the documents returned to the
     * end user on the current page (the end user may have not finished browsing
     * the whole page yet). When a new page is returned to the end user, after
     * pagination/filtering/ordering even for the same query, a new `search` event
     * with different
     * [UserEvent.documents][google.cloud.discoveryengine.v1.UserEvent.documents]
     * is desired.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.DocumentInfo documents = 10;</code>
     */
    public Builder removeDocuments(int index) {
      if (documentsBuilder_ == null) {
        ensureDocumentsIsMutable();
        documents_.remove(index);
        onChanged();
      } else {
        documentsBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * List of [Document][google.cloud.discoveryengine.v1.Document]s associated
     * with this user event.
     *
     * This field is optional except for the following event types:
     *
     * * `view-item`
     * * `add-to-cart`
     * * `purchase`
     * * `media-play`
     * * `media-complete`
     *
     * In a `search` event, this field represents the documents returned to the
     * end user on the current page (the end user may have not finished browsing
     * the whole page yet). When a new page is returned to the end user, after
     * pagination/filtering/ordering even for the same query, a new `search` event
     * with different
     * [UserEvent.documents][google.cloud.discoveryengine.v1.UserEvent.documents]
     * is desired.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.DocumentInfo documents = 10;</code>
     */
    public com.google.cloud.discoveryengine.v1.DocumentInfo.Builder getDocumentsBuilder(int index) {
      return getDocumentsFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * List of [Document][google.cloud.discoveryengine.v1.Document]s associated
     * with this user event.
     *
     * This field is optional except for the following event types:
     *
     * * `view-item`
     * * `add-to-cart`
     * * `purchase`
     * * `media-play`
     * * `media-complete`
     *
     * In a `search` event, this field represents the documents returned to the
     * end user on the current page (the end user may have not finished browsing
     * the whole page yet). When a new page is returned to the end user, after
     * pagination/filtering/ordering even for the same query, a new `search` event
     * with different
     * [UserEvent.documents][google.cloud.discoveryengine.v1.UserEvent.documents]
     * is desired.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.DocumentInfo documents = 10;</code>
     */
    public com.google.cloud.discoveryengine.v1.DocumentInfoOrBuilder getDocumentsOrBuilder(
        int index) {
      if (documentsBuilder_ == null) {
        return documents_.get(index);
      } else {
        return documentsBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * List of [Document][google.cloud.discoveryengine.v1.Document]s associated
     * with this user event.
     *
     * This field is optional except for the following event types:
     *
     * * `view-item`
     * * `add-to-cart`
     * * `purchase`
     * * `media-play`
     * * `media-complete`
     *
     * In a `search` event, this field represents the documents returned to the
     * end user on the current page (the end user may have not finished browsing
     * the whole page yet). When a new page is returned to the end user, after
     * pagination/filtering/ordering even for the same query, a new `search` event
     * with different
     * [UserEvent.documents][google.cloud.discoveryengine.v1.UserEvent.documents]
     * is desired.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.DocumentInfo documents = 10;</code>
     */
    public java.util.List<? extends com.google.cloud.discoveryengine.v1.DocumentInfoOrBuilder>
        getDocumentsOrBuilderList() {
      if (documentsBuilder_ != null) {
        return documentsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(documents_);
      }
    }

    /**
     *
     *
     * <pre>
     * List of [Document][google.cloud.discoveryengine.v1.Document]s associated
     * with this user event.
     *
     * This field is optional except for the following event types:
     *
     * * `view-item`
     * * `add-to-cart`
     * * `purchase`
     * * `media-play`
     * * `media-complete`
     *
     * In a `search` event, this field represents the documents returned to the
     * end user on the current page (the end user may have not finished browsing
     * the whole page yet). When a new page is returned to the end user, after
     * pagination/filtering/ordering even for the same query, a new `search` event
     * with different
     * [UserEvent.documents][google.cloud.discoveryengine.v1.UserEvent.documents]
     * is desired.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.DocumentInfo documents = 10;</code>
     */
    public com.google.cloud.discoveryengine.v1.DocumentInfo.Builder addDocumentsBuilder() {
      return getDocumentsFieldBuilder()
          .addBuilder(com.google.cloud.discoveryengine.v1.DocumentInfo.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * List of [Document][google.cloud.discoveryengine.v1.Document]s associated
     * with this user event.
     *
     * This field is optional except for the following event types:
     *
     * * `view-item`
     * * `add-to-cart`
     * * `purchase`
     * * `media-play`
     * * `media-complete`
     *
     * In a `search` event, this field represents the documents returned to the
     * end user on the current page (the end user may have not finished browsing
     * the whole page yet). When a new page is returned to the end user, after
     * pagination/filtering/ordering even for the same query, a new `search` event
     * with different
     * [UserEvent.documents][google.cloud.discoveryengine.v1.UserEvent.documents]
     * is desired.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.DocumentInfo documents = 10;</code>
     */
    public com.google.cloud.discoveryengine.v1.DocumentInfo.Builder addDocumentsBuilder(int index) {
      return getDocumentsFieldBuilder()
          .addBuilder(index, com.google.cloud.discoveryengine.v1.DocumentInfo.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * List of [Document][google.cloud.discoveryengine.v1.Document]s associated
     * with this user event.
     *
     * This field is optional except for the following event types:
     *
     * * `view-item`
     * * `add-to-cart`
     * * `purchase`
     * * `media-play`
     * * `media-complete`
     *
     * In a `search` event, this field represents the documents returned to the
     * end user on the current page (the end user may have not finished browsing
     * the whole page yet). When a new page is returned to the end user, after
     * pagination/filtering/ordering even for the same query, a new `search` event
     * with different
     * [UserEvent.documents][google.cloud.discoveryengine.v1.UserEvent.documents]
     * is desired.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.DocumentInfo documents = 10;</code>
     */
    public java.util.List<com.google.cloud.discoveryengine.v1.DocumentInfo.Builder>
        getDocumentsBuilderList() {
      return getDocumentsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.discoveryengine.v1.DocumentInfo,
            com.google.cloud.discoveryengine.v1.DocumentInfo.Builder,
            com.google.cloud.discoveryengine.v1.DocumentInfoOrBuilder>
        getDocumentsFieldBuilder() {
      if (documentsBuilder_ == null) {
        documentsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.discoveryengine.v1.DocumentInfo,
                com.google.cloud.discoveryengine.v1.DocumentInfo.Builder,
                com.google.cloud.discoveryengine.v1.DocumentInfoOrBuilder>(
                documents_, ((bitField0_ & 0x00001000) != 0), getParentForChildren(), isClean());
        documents_ = null;
      }
      return documentsBuilder_;
    }

    private com.google.cloud.discoveryengine.v1.PanelInfo panel_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1.PanelInfo,
            com.google.cloud.discoveryengine.v1.PanelInfo.Builder,
            com.google.cloud.discoveryengine.v1.PanelInfoOrBuilder>
        panelBuilder_;

    /**
     *
     *
     * <pre>
     * Panel metadata associated with this user event.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.PanelInfo panel = 11;</code>
     *
     * @return Whether the panel field is set.
     */
    public boolean hasPanel() {
      return ((bitField0_ & 0x00002000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Panel metadata associated with this user event.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.PanelInfo panel = 11;</code>
     *
     * @return The panel.
     */
    public com.google.cloud.discoveryengine.v1.PanelInfo getPanel() {
      if (panelBuilder_ == null) {
        return panel_ == null
            ? com.google.cloud.discoveryengine.v1.PanelInfo.getDefaultInstance()
            : panel_;
      } else {
        return panelBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Panel metadata associated with this user event.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.PanelInfo panel = 11;</code>
     */
    public Builder setPanel(com.google.cloud.discoveryengine.v1.PanelInfo value) {
      if (panelBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        panel_ = value;
      } else {
        panelBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Panel metadata associated with this user event.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.PanelInfo panel = 11;</code>
     */
    public Builder setPanel(com.google.cloud.discoveryengine.v1.PanelInfo.Builder builderForValue) {
      if (panelBuilder_ == null) {
        panel_ = builderForValue.build();
      } else {
        panelBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Panel metadata associated with this user event.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.PanelInfo panel = 11;</code>
     */
    public Builder mergePanel(com.google.cloud.discoveryengine.v1.PanelInfo value) {
      if (panelBuilder_ == null) {
        if (((bitField0_ & 0x00002000) != 0)
            && panel_ != null
            && panel_ != com.google.cloud.discoveryengine.v1.PanelInfo.getDefaultInstance()) {
          getPanelBuilder().mergeFrom(value);
        } else {
          panel_ = value;
        }
      } else {
        panelBuilder_.mergeFrom(value);
      }
      if (panel_ != null) {
        bitField0_ |= 0x00002000;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Panel metadata associated with this user event.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.PanelInfo panel = 11;</code>
     */
    public Builder clearPanel() {
      bitField0_ = (bitField0_ & ~0x00002000);
      panel_ = null;
      if (panelBuilder_ != null) {
        panelBuilder_.dispose();
        panelBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Panel metadata associated with this user event.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.PanelInfo panel = 11;</code>
     */
    public com.google.cloud.discoveryengine.v1.PanelInfo.Builder getPanelBuilder() {
      bitField0_ |= 0x00002000;
      onChanged();
      return getPanelFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Panel metadata associated with this user event.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.PanelInfo panel = 11;</code>
     */
    public com.google.cloud.discoveryengine.v1.PanelInfoOrBuilder getPanelOrBuilder() {
      if (panelBuilder_ != null) {
        return panelBuilder_.getMessageOrBuilder();
      } else {
        return panel_ == null
            ? com.google.cloud.discoveryengine.v1.PanelInfo.getDefaultInstance()
            : panel_;
      }
    }

    /**
     *
     *
     * <pre>
     * Panel metadata associated with this user event.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.PanelInfo panel = 11;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1.PanelInfo,
            com.google.cloud.discoveryengine.v1.PanelInfo.Builder,
            com.google.cloud.discoveryengine.v1.PanelInfoOrBuilder>
        getPanelFieldBuilder() {
      if (panelBuilder_ == null) {
        panelBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1.PanelInfo,
                com.google.cloud.discoveryengine.v1.PanelInfo.Builder,
                com.google.cloud.discoveryengine.v1.PanelInfoOrBuilder>(
                getPanel(), getParentForChildren(), isClean());
        panel_ = null;
      }
      return panelBuilder_;
    }

    private com.google.cloud.discoveryengine.v1.SearchInfo searchInfo_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1.SearchInfo,
            com.google.cloud.discoveryengine.v1.SearchInfo.Builder,
            com.google.cloud.discoveryengine.v1.SearchInfoOrBuilder>
        searchInfoBuilder_;

    /**
     *
     *
     * <pre>
     * [SearchService.Search][google.cloud.discoveryengine.v1.SearchService.Search]
     * details related to the event.
     *
     * This field should be set for `search` event.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.SearchInfo search_info = 12;</code>
     *
     * @return Whether the searchInfo field is set.
     */
    public boolean hasSearchInfo() {
      return ((bitField0_ & 0x00004000) != 0);
    }

    /**
     *
     *
     * <pre>
     * [SearchService.Search][google.cloud.discoveryengine.v1.SearchService.Search]
     * details related to the event.
     *
     * This field should be set for `search` event.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.SearchInfo search_info = 12;</code>
     *
     * @return The searchInfo.
     */
    public com.google.cloud.discoveryengine.v1.SearchInfo getSearchInfo() {
      if (searchInfoBuilder_ == null) {
        return searchInfo_ == null
            ? com.google.cloud.discoveryengine.v1.SearchInfo.getDefaultInstance()
            : searchInfo_;
      } else {
        return searchInfoBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * [SearchService.Search][google.cloud.discoveryengine.v1.SearchService.Search]
     * details related to the event.
     *
     * This field should be set for `search` event.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.SearchInfo search_info = 12;</code>
     */
    public Builder setSearchInfo(com.google.cloud.discoveryengine.v1.SearchInfo value) {
      if (searchInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        searchInfo_ = value;
      } else {
        searchInfoBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [SearchService.Search][google.cloud.discoveryengine.v1.SearchService.Search]
     * details related to the event.
     *
     * This field should be set for `search` event.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.SearchInfo search_info = 12;</code>
     */
    public Builder setSearchInfo(
        com.google.cloud.discoveryengine.v1.SearchInfo.Builder builderForValue) {
      if (searchInfoBuilder_ == null) {
        searchInfo_ = builderForValue.build();
      } else {
        searchInfoBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [SearchService.Search][google.cloud.discoveryengine.v1.SearchService.Search]
     * details related to the event.
     *
     * This field should be set for `search` event.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.SearchInfo search_info = 12;</code>
     */
    public Builder mergeSearchInfo(com.google.cloud.discoveryengine.v1.SearchInfo value) {
      if (searchInfoBuilder_ == null) {
        if (((bitField0_ & 0x00004000) != 0)
            && searchInfo_ != null
            && searchInfo_ != com.google.cloud.discoveryengine.v1.SearchInfo.getDefaultInstance()) {
          getSearchInfoBuilder().mergeFrom(value);
        } else {
          searchInfo_ = value;
        }
      } else {
        searchInfoBuilder_.mergeFrom(value);
      }
      if (searchInfo_ != null) {
        bitField0_ |= 0x00004000;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * [SearchService.Search][google.cloud.discoveryengine.v1.SearchService.Search]
     * details related to the event.
     *
     * This field should be set for `search` event.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.SearchInfo search_info = 12;</code>
     */
    public Builder clearSearchInfo() {
      bitField0_ = (bitField0_ & ~0x00004000);
      searchInfo_ = null;
      if (searchInfoBuilder_ != null) {
        searchInfoBuilder_.dispose();
        searchInfoBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [SearchService.Search][google.cloud.discoveryengine.v1.SearchService.Search]
     * details related to the event.
     *
     * This field should be set for `search` event.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.SearchInfo search_info = 12;</code>
     */
    public com.google.cloud.discoveryengine.v1.SearchInfo.Builder getSearchInfoBuilder() {
      bitField0_ |= 0x00004000;
      onChanged();
      return getSearchInfoFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * [SearchService.Search][google.cloud.discoveryengine.v1.SearchService.Search]
     * details related to the event.
     *
     * This field should be set for `search` event.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.SearchInfo search_info = 12;</code>
     */
    public com.google.cloud.discoveryengine.v1.SearchInfoOrBuilder getSearchInfoOrBuilder() {
      if (searchInfoBuilder_ != null) {
        return searchInfoBuilder_.getMessageOrBuilder();
      } else {
        return searchInfo_ == null
            ? com.google.cloud.discoveryengine.v1.SearchInfo.getDefaultInstance()
            : searchInfo_;
      }
    }

    /**
     *
     *
     * <pre>
     * [SearchService.Search][google.cloud.discoveryengine.v1.SearchService.Search]
     * details related to the event.
     *
     * This field should be set for `search` event.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.SearchInfo search_info = 12;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1.SearchInfo,
            com.google.cloud.discoveryengine.v1.SearchInfo.Builder,
            com.google.cloud.discoveryengine.v1.SearchInfoOrBuilder>
        getSearchInfoFieldBuilder() {
      if (searchInfoBuilder_ == null) {
        searchInfoBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1.SearchInfo,
                com.google.cloud.discoveryengine.v1.SearchInfo.Builder,
                com.google.cloud.discoveryengine.v1.SearchInfoOrBuilder>(
                getSearchInfo(), getParentForChildren(), isClean());
        searchInfo_ = null;
      }
      return searchInfoBuilder_;
    }

    private com.google.cloud.discoveryengine.v1.CompletionInfo completionInfo_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1.CompletionInfo,
            com.google.cloud.discoveryengine.v1.CompletionInfo.Builder,
            com.google.cloud.discoveryengine.v1.CompletionInfoOrBuilder>
        completionInfoBuilder_;

    /**
     *
     *
     * <pre>
     * [CompletionService.CompleteQuery][google.cloud.discoveryengine.v1.CompletionService.CompleteQuery]
     * details related to the event.
     *
     * This field should be set for `search` event when autocomplete function is
     * enabled and the user clicks a suggestion for search.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.CompletionInfo completion_info = 13;</code>
     *
     * @return Whether the completionInfo field is set.
     */
    public boolean hasCompletionInfo() {
      return ((bitField0_ & 0x00008000) != 0);
    }

    /**
     *
     *
     * <pre>
     * [CompletionService.CompleteQuery][google.cloud.discoveryengine.v1.CompletionService.CompleteQuery]
     * details related to the event.
     *
     * This field should be set for `search` event when autocomplete function is
     * enabled and the user clicks a suggestion for search.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.CompletionInfo completion_info = 13;</code>
     *
     * @return The completionInfo.
     */
    public com.google.cloud.discoveryengine.v1.CompletionInfo getCompletionInfo() {
      if (completionInfoBuilder_ == null) {
        return completionInfo_ == null
            ? com.google.cloud.discoveryengine.v1.CompletionInfo.getDefaultInstance()
            : completionInfo_;
      } else {
        return completionInfoBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * [CompletionService.CompleteQuery][google.cloud.discoveryengine.v1.CompletionService.CompleteQuery]
     * details related to the event.
     *
     * This field should be set for `search` event when autocomplete function is
     * enabled and the user clicks a suggestion for search.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.CompletionInfo completion_info = 13;</code>
     */
    public Builder setCompletionInfo(com.google.cloud.discoveryengine.v1.CompletionInfo value) {
      if (completionInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        completionInfo_ = value;
      } else {
        completionInfoBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [CompletionService.CompleteQuery][google.cloud.discoveryengine.v1.CompletionService.CompleteQuery]
     * details related to the event.
     *
     * This field should be set for `search` event when autocomplete function is
     * enabled and the user clicks a suggestion for search.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.CompletionInfo completion_info = 13;</code>
     */
    public Builder setCompletionInfo(
        com.google.cloud.discoveryengine.v1.CompletionInfo.Builder builderForValue) {
      if (completionInfoBuilder_ == null) {
        completionInfo_ = builderForValue.build();
      } else {
        completionInfoBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [CompletionService.CompleteQuery][google.cloud.discoveryengine.v1.CompletionService.CompleteQuery]
     * details related to the event.
     *
     * This field should be set for `search` event when autocomplete function is
     * enabled and the user clicks a suggestion for search.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.CompletionInfo completion_info = 13;</code>
     */
    public Builder mergeCompletionInfo(com.google.cloud.discoveryengine.v1.CompletionInfo value) {
      if (completionInfoBuilder_ == null) {
        if (((bitField0_ & 0x00008000) != 0)
            && completionInfo_ != null
            && completionInfo_
                != com.google.cloud.discoveryengine.v1.CompletionInfo.getDefaultInstance()) {
          getCompletionInfoBuilder().mergeFrom(value);
        } else {
          completionInfo_ = value;
        }
      } else {
        completionInfoBuilder_.mergeFrom(value);
      }
      if (completionInfo_ != null) {
        bitField0_ |= 0x00008000;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * [CompletionService.CompleteQuery][google.cloud.discoveryengine.v1.CompletionService.CompleteQuery]
     * details related to the event.
     *
     * This field should be set for `search` event when autocomplete function is
     * enabled and the user clicks a suggestion for search.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.CompletionInfo completion_info = 13;</code>
     */
    public Builder clearCompletionInfo() {
      bitField0_ = (bitField0_ & ~0x00008000);
      completionInfo_ = null;
      if (completionInfoBuilder_ != null) {
        completionInfoBuilder_.dispose();
        completionInfoBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [CompletionService.CompleteQuery][google.cloud.discoveryengine.v1.CompletionService.CompleteQuery]
     * details related to the event.
     *
     * This field should be set for `search` event when autocomplete function is
     * enabled and the user clicks a suggestion for search.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.CompletionInfo completion_info = 13;</code>
     */
    public com.google.cloud.discoveryengine.v1.CompletionInfo.Builder getCompletionInfoBuilder() {
      bitField0_ |= 0x00008000;
      onChanged();
      return getCompletionInfoFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * [CompletionService.CompleteQuery][google.cloud.discoveryengine.v1.CompletionService.CompleteQuery]
     * details related to the event.
     *
     * This field should be set for `search` event when autocomplete function is
     * enabled and the user clicks a suggestion for search.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.CompletionInfo completion_info = 13;</code>
     */
    public com.google.cloud.discoveryengine.v1.CompletionInfoOrBuilder
        getCompletionInfoOrBuilder() {
      if (completionInfoBuilder_ != null) {
        return completionInfoBuilder_.getMessageOrBuilder();
      } else {
        return completionInfo_ == null
            ? com.google.cloud.discoveryengine.v1.CompletionInfo.getDefaultInstance()
            : completionInfo_;
      }
    }

    /**
     *
     *
     * <pre>
     * [CompletionService.CompleteQuery][google.cloud.discoveryengine.v1.CompletionService.CompleteQuery]
     * details related to the event.
     *
     * This field should be set for `search` event when autocomplete function is
     * enabled and the user clicks a suggestion for search.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.CompletionInfo completion_info = 13;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1.CompletionInfo,
            com.google.cloud.discoveryengine.v1.CompletionInfo.Builder,
            com.google.cloud.discoveryengine.v1.CompletionInfoOrBuilder>
        getCompletionInfoFieldBuilder() {
      if (completionInfoBuilder_ == null) {
        completionInfoBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1.CompletionInfo,
                com.google.cloud.discoveryengine.v1.CompletionInfo.Builder,
                com.google.cloud.discoveryengine.v1.CompletionInfoOrBuilder>(
                getCompletionInfo(), getParentForChildren(), isClean());
        completionInfo_ = null;
      }
      return completionInfoBuilder_;
    }

    private com.google.cloud.discoveryengine.v1.TransactionInfo transactionInfo_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1.TransactionInfo,
            com.google.cloud.discoveryengine.v1.TransactionInfo.Builder,
            com.google.cloud.discoveryengine.v1.TransactionInfoOrBuilder>
        transactionInfoBuilder_;

    /**
     *
     *
     * <pre>
     * The transaction metadata (if any) associated with this user event.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.TransactionInfo transaction_info = 14;</code>
     *
     * @return Whether the transactionInfo field is set.
     */
    public boolean hasTransactionInfo() {
      return ((bitField0_ & 0x00010000) != 0);
    }

    /**
     *
     *
     * <pre>
     * The transaction metadata (if any) associated with this user event.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.TransactionInfo transaction_info = 14;</code>
     *
     * @return The transactionInfo.
     */
    public com.google.cloud.discoveryengine.v1.TransactionInfo getTransactionInfo() {
      if (transactionInfoBuilder_ == null) {
        return transactionInfo_ == null
            ? com.google.cloud.discoveryengine.v1.TransactionInfo.getDefaultInstance()
            : transactionInfo_;
      } else {
        return transactionInfoBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * The transaction metadata (if any) associated with this user event.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.TransactionInfo transaction_info = 14;</code>
     */
    public Builder setTransactionInfo(com.google.cloud.discoveryengine.v1.TransactionInfo value) {
      if (transactionInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        transactionInfo_ = value;
      } else {
        transactionInfoBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The transaction metadata (if any) associated with this user event.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.TransactionInfo transaction_info = 14;</code>
     */
    public Builder setTransactionInfo(
        com.google.cloud.discoveryengine.v1.TransactionInfo.Builder builderForValue) {
      if (transactionInfoBuilder_ == null) {
        transactionInfo_ = builderForValue.build();
      } else {
        transactionInfoBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The transaction metadata (if any) associated with this user event.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.TransactionInfo transaction_info = 14;</code>
     */
    public Builder mergeTransactionInfo(com.google.cloud.discoveryengine.v1.TransactionInfo value) {
      if (transactionInfoBuilder_ == null) {
        if (((bitField0_ & 0x00010000) != 0)
            && transactionInfo_ != null
            && transactionInfo_
                != com.google.cloud.discoveryengine.v1.TransactionInfo.getDefaultInstance()) {
          getTransactionInfoBuilder().mergeFrom(value);
        } else {
          transactionInfo_ = value;
        }
      } else {
        transactionInfoBuilder_.mergeFrom(value);
      }
      if (transactionInfo_ != null) {
        bitField0_ |= 0x00010000;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The transaction metadata (if any) associated with this user event.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.TransactionInfo transaction_info = 14;</code>
     */
    public Builder clearTransactionInfo() {
      bitField0_ = (bitField0_ & ~0x00010000);
      transactionInfo_ = null;
      if (transactionInfoBuilder_ != null) {
        transactionInfoBuilder_.dispose();
        transactionInfoBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The transaction metadata (if any) associated with this user event.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.TransactionInfo transaction_info = 14;</code>
     */
    public com.google.cloud.discoveryengine.v1.TransactionInfo.Builder getTransactionInfoBuilder() {
      bitField0_ |= 0x00010000;
      onChanged();
      return getTransactionInfoFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * The transaction metadata (if any) associated with this user event.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.TransactionInfo transaction_info = 14;</code>
     */
    public com.google.cloud.discoveryengine.v1.TransactionInfoOrBuilder
        getTransactionInfoOrBuilder() {
      if (transactionInfoBuilder_ != null) {
        return transactionInfoBuilder_.getMessageOrBuilder();
      } else {
        return transactionInfo_ == null
            ? com.google.cloud.discoveryengine.v1.TransactionInfo.getDefaultInstance()
            : transactionInfo_;
      }
    }

    /**
     *
     *
     * <pre>
     * The transaction metadata (if any) associated with this user event.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.TransactionInfo transaction_info = 14;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1.TransactionInfo,
            com.google.cloud.discoveryengine.v1.TransactionInfo.Builder,
            com.google.cloud.discoveryengine.v1.TransactionInfoOrBuilder>
        getTransactionInfoFieldBuilder() {
      if (transactionInfoBuilder_ == null) {
        transactionInfoBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1.TransactionInfo,
                com.google.cloud.discoveryengine.v1.TransactionInfo.Builder,
                com.google.cloud.discoveryengine.v1.TransactionInfoOrBuilder>(
                getTransactionInfo(), getParentForChildren(), isClean());
        transactionInfo_ = null;
      }
      return transactionInfoBuilder_;
    }

    private com.google.protobuf.LazyStringArrayList tagIds_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureTagIdsIsMutable() {
      if (!tagIds_.isModifiable()) {
        tagIds_ = new com.google.protobuf.LazyStringArrayList(tagIds_);
      }
      bitField0_ |= 0x00020000;
    }

    /**
     *
     *
     * <pre>
     * A list of identifiers for the independent experiment groups this user event
     * belongs to. This is used to distinguish between user events associated with
     * different experiment setups.
     * </pre>
     *
     * <code>repeated string tag_ids = 15;</code>
     *
     * @return A list containing the tagIds.
     */
    public com.google.protobuf.ProtocolStringList getTagIdsList() {
      tagIds_.makeImmutable();
      return tagIds_;
    }

    /**
     *
     *
     * <pre>
     * A list of identifiers for the independent experiment groups this user event
     * belongs to. This is used to distinguish between user events associated with
     * different experiment setups.
     * </pre>
     *
     * <code>repeated string tag_ids = 15;</code>
     *
     * @return The count of tagIds.
     */
    public int getTagIdsCount() {
      return tagIds_.size();
    }

    /**
     *
     *
     * <pre>
     * A list of identifiers for the independent experiment groups this user event
     * belongs to. This is used to distinguish between user events associated with
     * different experiment setups.
     * </pre>
     *
     * <code>repeated string tag_ids = 15;</code>
     *
     * @param index The index of the element to return.
     * @return The tagIds at the given index.
     */
    public java.lang.String getTagIds(int index) {
      return tagIds_.get(index);
    }

    /**
     *
     *
     * <pre>
     * A list of identifiers for the independent experiment groups this user event
     * belongs to. This is used to distinguish between user events associated with
     * different experiment setups.
     * </pre>
     *
     * <code>repeated string tag_ids = 15;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the tagIds at the given index.
     */
    public com.google.protobuf.ByteString getTagIdsBytes(int index) {
      return tagIds_.getByteString(index);
    }

    /**
     *
     *
     * <pre>
     * A list of identifiers for the independent experiment groups this user event
     * belongs to. This is used to distinguish between user events associated with
     * different experiment setups.
     * </pre>
     *
     * <code>repeated string tag_ids = 15;</code>
     *
     * @param index The index to set the value at.
     * @param value The tagIds to set.
     * @return This builder for chaining.
     */
    public Builder setTagIds(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureTagIdsIsMutable();
      tagIds_.set(index, value);
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of identifiers for the independent experiment groups this user event
     * belongs to. This is used to distinguish between user events associated with
     * different experiment setups.
     * </pre>
     *
     * <code>repeated string tag_ids = 15;</code>
     *
     * @param value The tagIds to add.
     * @return This builder for chaining.
     */
    public Builder addTagIds(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureTagIdsIsMutable();
      tagIds_.add(value);
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of identifiers for the independent experiment groups this user event
     * belongs to. This is used to distinguish between user events associated with
     * different experiment setups.
     * </pre>
     *
     * <code>repeated string tag_ids = 15;</code>
     *
     * @param values The tagIds to add.
     * @return This builder for chaining.
     */
    public Builder addAllTagIds(java.lang.Iterable<java.lang.String> values) {
      ensureTagIdsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, tagIds_);
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of identifiers for the independent experiment groups this user event
     * belongs to. This is used to distinguish between user events associated with
     * different experiment setups.
     * </pre>
     *
     * <code>repeated string tag_ids = 15;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTagIds() {
      tagIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00020000);
      ;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of identifiers for the independent experiment groups this user event
     * belongs to. This is used to distinguish between user events associated with
     * different experiment setups.
     * </pre>
     *
     * <code>repeated string tag_ids = 15;</code>
     *
     * @param value The bytes of the tagIds to add.
     * @return This builder for chaining.
     */
    public Builder addTagIdsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureTagIdsIsMutable();
      tagIds_.add(value);
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList promotionIds_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensurePromotionIdsIsMutable() {
      if (!promotionIds_.isModifiable()) {
        promotionIds_ = new com.google.protobuf.LazyStringArrayList(promotionIds_);
      }
      bitField0_ |= 0x00040000;
    }

    /**
     *
     *
     * <pre>
     * The promotion IDs if this is an event associated with promotions.
     * Currently, this field is restricted to at most one ID.
     * </pre>
     *
     * <code>repeated string promotion_ids = 16;</code>
     *
     * @return A list containing the promotionIds.
     */
    public com.google.protobuf.ProtocolStringList getPromotionIdsList() {
      promotionIds_.makeImmutable();
      return promotionIds_;
    }

    /**
     *
     *
     * <pre>
     * The promotion IDs if this is an event associated with promotions.
     * Currently, this field is restricted to at most one ID.
     * </pre>
     *
     * <code>repeated string promotion_ids = 16;</code>
     *
     * @return The count of promotionIds.
     */
    public int getPromotionIdsCount() {
      return promotionIds_.size();
    }

    /**
     *
     *
     * <pre>
     * The promotion IDs if this is an event associated with promotions.
     * Currently, this field is restricted to at most one ID.
     * </pre>
     *
     * <code>repeated string promotion_ids = 16;</code>
     *
     * @param index The index of the element to return.
     * @return The promotionIds at the given index.
     */
    public java.lang.String getPromotionIds(int index) {
      return promotionIds_.get(index);
    }

    /**
     *
     *
     * <pre>
     * The promotion IDs if this is an event associated with promotions.
     * Currently, this field is restricted to at most one ID.
     * </pre>
     *
     * <code>repeated string promotion_ids = 16;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the promotionIds at the given index.
     */
    public com.google.protobuf.ByteString getPromotionIdsBytes(int index) {
      return promotionIds_.getByteString(index);
    }

    /**
     *
     *
     * <pre>
     * The promotion IDs if this is an event associated with promotions.
     * Currently, this field is restricted to at most one ID.
     * </pre>
     *
     * <code>repeated string promotion_ids = 16;</code>
     *
     * @param index The index to set the value at.
     * @param value The promotionIds to set.
     * @return This builder for chaining.
     */
    public Builder setPromotionIds(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensurePromotionIdsIsMutable();
      promotionIds_.set(index, value);
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The promotion IDs if this is an event associated with promotions.
     * Currently, this field is restricted to at most one ID.
     * </pre>
     *
     * <code>repeated string promotion_ids = 16;</code>
     *
     * @param value The promotionIds to add.
     * @return This builder for chaining.
     */
    public Builder addPromotionIds(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensurePromotionIdsIsMutable();
      promotionIds_.add(value);
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The promotion IDs if this is an event associated with promotions.
     * Currently, this field is restricted to at most one ID.
     * </pre>
     *
     * <code>repeated string promotion_ids = 16;</code>
     *
     * @param values The promotionIds to add.
     * @return This builder for chaining.
     */
    public Builder addAllPromotionIds(java.lang.Iterable<java.lang.String> values) {
      ensurePromotionIdsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, promotionIds_);
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The promotion IDs if this is an event associated with promotions.
     * Currently, this field is restricted to at most one ID.
     * </pre>
     *
     * <code>repeated string promotion_ids = 16;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPromotionIds() {
      promotionIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00040000);
      ;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The promotion IDs if this is an event associated with promotions.
     * Currently, this field is restricted to at most one ID.
     * </pre>
     *
     * <code>repeated string promotion_ids = 16;</code>
     *
     * @param value The bytes of the promotionIds to add.
     * @return This builder for chaining.
     */
    public Builder addPromotionIdsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensurePromotionIdsIsMutable();
      promotionIds_.add(value);
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }

    private static final class AttributesConverter
        implements com.google.protobuf.MapFieldBuilder.Converter<
            java.lang.String,
            com.google.cloud.discoveryengine.v1.CustomAttributeOrBuilder,
            com.google.cloud.discoveryengine.v1.CustomAttribute> {
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.CustomAttribute build(
          com.google.cloud.discoveryengine.v1.CustomAttributeOrBuilder val) {
        if (val instanceof com.google.cloud.discoveryengine.v1.CustomAttribute) {
          return (com.google.cloud.discoveryengine.v1.CustomAttribute) val;
        }
        return ((com.google.cloud.discoveryengine.v1.CustomAttribute.Builder) val).build();
      }

      @java.lang.Override
      public com.google.protobuf.MapEntry<
              java.lang.String, com.google.cloud.discoveryengine.v1.CustomAttribute>
          defaultEntry() {
        return AttributesDefaultEntryHolder.defaultEntry;
      }
    }
    ;

    private static final AttributesConverter attributesConverter = new AttributesConverter();

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.cloud.discoveryengine.v1.CustomAttributeOrBuilder,
            com.google.cloud.discoveryengine.v1.CustomAttribute,
            com.google.cloud.discoveryengine.v1.CustomAttribute.Builder>
        attributes_;

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.cloud.discoveryengine.v1.CustomAttributeOrBuilder,
            com.google.cloud.discoveryengine.v1.CustomAttribute,
            com.google.cloud.discoveryengine.v1.CustomAttribute.Builder>
        internalGetAttributes() {
      if (attributes_ == null) {
        return new com.google.protobuf.MapFieldBuilder<>(attributesConverter);
      }
      return attributes_;
    }

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.cloud.discoveryengine.v1.CustomAttributeOrBuilder,
            com.google.cloud.discoveryengine.v1.CustomAttribute,
            com.google.cloud.discoveryengine.v1.CustomAttribute.Builder>
        internalGetMutableAttributes() {
      if (attributes_ == null) {
        attributes_ = new com.google.protobuf.MapFieldBuilder<>(attributesConverter);
      }
      bitField0_ |= 0x00080000;
      onChanged();
      return attributes_;
    }

    public int getAttributesCount() {
      return internalGetAttributes().ensureBuilderMap().size();
    }

    /**
     *
     *
     * <pre>
     * Extra user event features to include in the recommendation model.
     * These attributes must NOT contain data that needs to be parsed or processed
     * further, e.g. JSON or other encodings.
     *
     * If you provide custom attributes for ingested user events, also include
     * them in the user events that you associate with prediction requests. Custom
     * attribute formatting must be consistent between imported events and events
     * provided with prediction requests. This lets the Discovery Engine API use
     * those custom attributes when training models and serving predictions, which
     * helps improve recommendation quality.
     *
     * This field needs to pass all below criteria, otherwise an
     * `INVALID_ARGUMENT` error is returned:
     *
     * * The key must be a UTF-8 encoded string with a length limit of 5,000
     *   characters.
     * * For text attributes, at most 400 values are allowed. Empty values are not
     *   allowed. Each value must be a UTF-8 encoded string with a length limit of
     *   256 characters.
     * * For number attributes, at most 400 values are allowed.
     *
     * For product recommendations, an example of extra user information is
     * `traffic_channel`, which is how a user arrives at the site. Users can
     * arrive
     * at the site by coming to the site directly, coming through Google
     * search, or in other ways.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.discoveryengine.v1.CustomAttribute&gt; attributes = 17;
     * </code>
     */
    @java.lang.Override
    public boolean containsAttributes(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetAttributes().ensureBuilderMap().containsKey(key);
    }

    /** Use {@link #getAttributesMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.cloud.discoveryengine.v1.CustomAttribute>
        getAttributes() {
      return getAttributesMap();
    }

    /**
     *
     *
     * <pre>
     * Extra user event features to include in the recommendation model.
     * These attributes must NOT contain data that needs to be parsed or processed
     * further, e.g. JSON or other encodings.
     *
     * If you provide custom attributes for ingested user events, also include
     * them in the user events that you associate with prediction requests. Custom
     * attribute formatting must be consistent between imported events and events
     * provided with prediction requests. This lets the Discovery Engine API use
     * those custom attributes when training models and serving predictions, which
     * helps improve recommendation quality.
     *
     * This field needs to pass all below criteria, otherwise an
     * `INVALID_ARGUMENT` error is returned:
     *
     * * The key must be a UTF-8 encoded string with a length limit of 5,000
     *   characters.
     * * For text attributes, at most 400 values are allowed. Empty values are not
     *   allowed. Each value must be a UTF-8 encoded string with a length limit of
     *   256 characters.
     * * For number attributes, at most 400 values are allowed.
     *
     * For product recommendations, an example of extra user information is
     * `traffic_channel`, which is how a user arrives at the site. Users can
     * arrive
     * at the site by coming to the site directly, coming through Google
     * search, or in other ways.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.discoveryengine.v1.CustomAttribute&gt; attributes = 17;
     * </code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, com.google.cloud.discoveryengine.v1.CustomAttribute>
        getAttributesMap() {
      return internalGetAttributes().getImmutableMap();
    }

    /**
     *
     *
     * <pre>
     * Extra user event features to include in the recommendation model.
     * These attributes must NOT contain data that needs to be parsed or processed
     * further, e.g. JSON or other encodings.
     *
     * If you provide custom attributes for ingested user events, also include
     * them in the user events that you associate with prediction requests. Custom
     * attribute formatting must be consistent between imported events and events
     * provided with prediction requests. This lets the Discovery Engine API use
     * those custom attributes when training models and serving predictions, which
     * helps improve recommendation quality.
     *
     * This field needs to pass all below criteria, otherwise an
     * `INVALID_ARGUMENT` error is returned:
     *
     * * The key must be a UTF-8 encoded string with a length limit of 5,000
     *   characters.
     * * For text attributes, at most 400 values are allowed. Empty values are not
     *   allowed. Each value must be a UTF-8 encoded string with a length limit of
     *   256 characters.
     * * For number attributes, at most 400 values are allowed.
     *
     * For product recommendations, an example of extra user information is
     * `traffic_channel`, which is how a user arrives at the site. Users can
     * arrive
     * at the site by coming to the site directly, coming through Google
     * search, or in other ways.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.discoveryengine.v1.CustomAttribute&gt; attributes = 17;
     * </code>
     */
    @java.lang.Override
    public /* nullable */ com.google.cloud.discoveryengine.v1.CustomAttribute
        getAttributesOrDefault(
            java.lang.String key,
            /* nullable */
            com.google.cloud.discoveryengine.v1.CustomAttribute defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.cloud.discoveryengine.v1.CustomAttributeOrBuilder>
          map = internalGetMutableAttributes().ensureBuilderMap();
      return map.containsKey(key) ? attributesConverter.build(map.get(key)) : defaultValue;
    }

    /**
     *
     *
     * <pre>
     * Extra user event features to include in the recommendation model.
     * These attributes must NOT contain data that needs to be parsed or processed
     * further, e.g. JSON or other encodings.
     *
     * If you provide custom attributes for ingested user events, also include
     * them in the user events that you associate with prediction requests. Custom
     * attribute formatting must be consistent between imported events and events
     * provided with prediction requests. This lets the Discovery Engine API use
     * those custom attributes when training models and serving predictions, which
     * helps improve recommendation quality.
     *
     * This field needs to pass all below criteria, otherwise an
     * `INVALID_ARGUMENT` error is returned:
     *
     * * The key must be a UTF-8 encoded string with a length limit of 5,000
     *   characters.
     * * For text attributes, at most 400 values are allowed. Empty values are not
     *   allowed. Each value must be a UTF-8 encoded string with a length limit of
     *   256 characters.
     * * For number attributes, at most 400 values are allowed.
     *
     * For product recommendations, an example of extra user information is
     * `traffic_channel`, which is how a user arrives at the site. Users can
     * arrive
     * at the site by coming to the site directly, coming through Google
     * search, or in other ways.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.discoveryengine.v1.CustomAttribute&gt; attributes = 17;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.CustomAttribute getAttributesOrThrow(
        java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.cloud.discoveryengine.v1.CustomAttributeOrBuilder>
          map = internalGetMutableAttributes().ensureBuilderMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return attributesConverter.build(map.get(key));
    }

    public Builder clearAttributes() {
      bitField0_ = (bitField0_ & ~0x00080000);
      internalGetMutableAttributes().clear();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Extra user event features to include in the recommendation model.
     * These attributes must NOT contain data that needs to be parsed or processed
     * further, e.g. JSON or other encodings.
     *
     * If you provide custom attributes for ingested user events, also include
     * them in the user events that you associate with prediction requests. Custom
     * attribute formatting must be consistent between imported events and events
     * provided with prediction requests. This lets the Discovery Engine API use
     * those custom attributes when training models and serving predictions, which
     * helps improve recommendation quality.
     *
     * This field needs to pass all below criteria, otherwise an
     * `INVALID_ARGUMENT` error is returned:
     *
     * * The key must be a UTF-8 encoded string with a length limit of 5,000
     *   characters.
     * * For text attributes, at most 400 values are allowed. Empty values are not
     *   allowed. Each value must be a UTF-8 encoded string with a length limit of
     *   256 characters.
     * * For number attributes, at most 400 values are allowed.
     *
     * For product recommendations, an example of extra user information is
     * `traffic_channel`, which is how a user arrives at the site. Users can
     * arrive
     * at the site by coming to the site directly, coming through Google
     * search, or in other ways.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.discoveryengine.v1.CustomAttribute&gt; attributes = 17;
     * </code>
     */
    public Builder removeAttributes(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableAttributes().ensureBuilderMap().remove(key);
      return this;
    }

    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.cloud.discoveryengine.v1.CustomAttribute>
        getMutableAttributes() {
      bitField0_ |= 0x00080000;
      return internalGetMutableAttributes().ensureMessageMap();
    }

    /**
     *
     *
     * <pre>
     * Extra user event features to include in the recommendation model.
     * These attributes must NOT contain data that needs to be parsed or processed
     * further, e.g. JSON or other encodings.
     *
     * If you provide custom attributes for ingested user events, also include
     * them in the user events that you associate with prediction requests. Custom
     * attribute formatting must be consistent between imported events and events
     * provided with prediction requests. This lets the Discovery Engine API use
     * those custom attributes when training models and serving predictions, which
     * helps improve recommendation quality.
     *
     * This field needs to pass all below criteria, otherwise an
     * `INVALID_ARGUMENT` error is returned:
     *
     * * The key must be a UTF-8 encoded string with a length limit of 5,000
     *   characters.
     * * For text attributes, at most 400 values are allowed. Empty values are not
     *   allowed. Each value must be a UTF-8 encoded string with a length limit of
     *   256 characters.
     * * For number attributes, at most 400 values are allowed.
     *
     * For product recommendations, an example of extra user information is
     * `traffic_channel`, which is how a user arrives at the site. Users can
     * arrive
     * at the site by coming to the site directly, coming through Google
     * search, or in other ways.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.discoveryengine.v1.CustomAttribute&gt; attributes = 17;
     * </code>
     */
    public Builder putAttributes(
        java.lang.String key, com.google.cloud.discoveryengine.v1.CustomAttribute value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableAttributes().ensureBuilderMap().put(key, value);
      bitField0_ |= 0x00080000;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Extra user event features to include in the recommendation model.
     * These attributes must NOT contain data that needs to be parsed or processed
     * further, e.g. JSON or other encodings.
     *
     * If you provide custom attributes for ingested user events, also include
     * them in the user events that you associate with prediction requests. Custom
     * attribute formatting must be consistent between imported events and events
     * provided with prediction requests. This lets the Discovery Engine API use
     * those custom attributes when training models and serving predictions, which
     * helps improve recommendation quality.
     *
     * This field needs to pass all below criteria, otherwise an
     * `INVALID_ARGUMENT` error is returned:
     *
     * * The key must be a UTF-8 encoded string with a length limit of 5,000
     *   characters.
     * * For text attributes, at most 400 values are allowed. Empty values are not
     *   allowed. Each value must be a UTF-8 encoded string with a length limit of
     *   256 characters.
     * * For number attributes, at most 400 values are allowed.
     *
     * For product recommendations, an example of extra user information is
     * `traffic_channel`, which is how a user arrives at the site. Users can
     * arrive
     * at the site by coming to the site directly, coming through Google
     * search, or in other ways.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.discoveryengine.v1.CustomAttribute&gt; attributes = 17;
     * </code>
     */
    public Builder putAllAttributes(
        java.util.Map<java.lang.String, com.google.cloud.discoveryengine.v1.CustomAttribute>
            values) {
      for (java.util.Map.Entry<
              java.lang.String, com.google.cloud.discoveryengine.v1.CustomAttribute>
          e : values.entrySet()) {
        if (e.getKey() == null || e.getValue() == null) {
          throw new NullPointerException();
        }
      }
      internalGetMutableAttributes().ensureBuilderMap().putAll(values);
      bitField0_ |= 0x00080000;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Extra user event features to include in the recommendation model.
     * These attributes must NOT contain data that needs to be parsed or processed
     * further, e.g. JSON or other encodings.
     *
     * If you provide custom attributes for ingested user events, also include
     * them in the user events that you associate with prediction requests. Custom
     * attribute formatting must be consistent between imported events and events
     * provided with prediction requests. This lets the Discovery Engine API use
     * those custom attributes when training models and serving predictions, which
     * helps improve recommendation quality.
     *
     * This field needs to pass all below criteria, otherwise an
     * `INVALID_ARGUMENT` error is returned:
     *
     * * The key must be a UTF-8 encoded string with a length limit of 5,000
     *   characters.
     * * For text attributes, at most 400 values are allowed. Empty values are not
     *   allowed. Each value must be a UTF-8 encoded string with a length limit of
     *   256 characters.
     * * For number attributes, at most 400 values are allowed.
     *
     * For product recommendations, an example of extra user information is
     * `traffic_channel`, which is how a user arrives at the site. Users can
     * arrive
     * at the site by coming to the site directly, coming through Google
     * search, or in other ways.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.discoveryengine.v1.CustomAttribute&gt; attributes = 17;
     * </code>
     */
    public com.google.cloud.discoveryengine.v1.CustomAttribute.Builder putAttributesBuilderIfAbsent(
        java.lang.String key) {
      java.util.Map<java.lang.String, com.google.cloud.discoveryengine.v1.CustomAttributeOrBuilder>
          builderMap = internalGetMutableAttributes().ensureBuilderMap();
      com.google.cloud.discoveryengine.v1.CustomAttributeOrBuilder entry = builderMap.get(key);
      if (entry == null) {
        entry = com.google.cloud.discoveryengine.v1.CustomAttribute.newBuilder();
        builderMap.put(key, entry);
      }
      if (entry instanceof com.google.cloud.discoveryengine.v1.CustomAttribute) {
        entry = ((com.google.cloud.discoveryengine.v1.CustomAttribute) entry).toBuilder();
        builderMap.put(key, entry);
      }
      return (com.google.cloud.discoveryengine.v1.CustomAttribute.Builder) entry;
    }

    private com.google.cloud.discoveryengine.v1.MediaInfo mediaInfo_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1.MediaInfo,
            com.google.cloud.discoveryengine.v1.MediaInfo.Builder,
            com.google.cloud.discoveryengine.v1.MediaInfoOrBuilder>
        mediaInfoBuilder_;

    /**
     *
     *
     * <pre>
     * Media-specific info.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.MediaInfo media_info = 18;</code>
     *
     * @return Whether the mediaInfo field is set.
     */
    public boolean hasMediaInfo() {
      return ((bitField0_ & 0x00100000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Media-specific info.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.MediaInfo media_info = 18;</code>
     *
     * @return The mediaInfo.
     */
    public com.google.cloud.discoveryengine.v1.MediaInfo getMediaInfo() {
      if (mediaInfoBuilder_ == null) {
        return mediaInfo_ == null
            ? com.google.cloud.discoveryengine.v1.MediaInfo.getDefaultInstance()
            : mediaInfo_;
      } else {
        return mediaInfoBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Media-specific info.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.MediaInfo media_info = 18;</code>
     */
    public Builder setMediaInfo(com.google.cloud.discoveryengine.v1.MediaInfo value) {
      if (mediaInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        mediaInfo_ = value;
      } else {
        mediaInfoBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00100000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Media-specific info.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.MediaInfo media_info = 18;</code>
     */
    public Builder setMediaInfo(
        com.google.cloud.discoveryengine.v1.MediaInfo.Builder builderForValue) {
      if (mediaInfoBuilder_ == null) {
        mediaInfo_ = builderForValue.build();
      } else {
        mediaInfoBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00100000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Media-specific info.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.MediaInfo media_info = 18;</code>
     */
    public Builder mergeMediaInfo(com.google.cloud.discoveryengine.v1.MediaInfo value) {
      if (mediaInfoBuilder_ == null) {
        if (((bitField0_ & 0x00100000) != 0)
            && mediaInfo_ != null
            && mediaInfo_ != com.google.cloud.discoveryengine.v1.MediaInfo.getDefaultInstance()) {
          getMediaInfoBuilder().mergeFrom(value);
        } else {
          mediaInfo_ = value;
        }
      } else {
        mediaInfoBuilder_.mergeFrom(value);
      }
      if (mediaInfo_ != null) {
        bitField0_ |= 0x00100000;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Media-specific info.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.MediaInfo media_info = 18;</code>
     */
    public Builder clearMediaInfo() {
      bitField0_ = (bitField0_ & ~0x00100000);
      mediaInfo_ = null;
      if (mediaInfoBuilder_ != null) {
        mediaInfoBuilder_.dispose();
        mediaInfoBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Media-specific info.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.MediaInfo media_info = 18;</code>
     */
    public com.google.cloud.discoveryengine.v1.MediaInfo.Builder getMediaInfoBuilder() {
      bitField0_ |= 0x00100000;
      onChanged();
      return getMediaInfoFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Media-specific info.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.MediaInfo media_info = 18;</code>
     */
    public com.google.cloud.discoveryengine.v1.MediaInfoOrBuilder getMediaInfoOrBuilder() {
      if (mediaInfoBuilder_ != null) {
        return mediaInfoBuilder_.getMessageOrBuilder();
      } else {
        return mediaInfo_ == null
            ? com.google.cloud.discoveryengine.v1.MediaInfo.getDefaultInstance()
            : mediaInfo_;
      }
    }

    /**
     *
     *
     * <pre>
     * Media-specific info.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.MediaInfo media_info = 18;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1.MediaInfo,
            com.google.cloud.discoveryengine.v1.MediaInfo.Builder,
            com.google.cloud.discoveryengine.v1.MediaInfoOrBuilder>
        getMediaInfoFieldBuilder() {
      if (mediaInfoBuilder_ == null) {
        mediaInfoBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1.MediaInfo,
                com.google.cloud.discoveryengine.v1.MediaInfo.Builder,
                com.google.cloud.discoveryengine.v1.MediaInfoOrBuilder>(
                getMediaInfo(), getParentForChildren(), isClean());
        mediaInfo_ = null;
      }
      return mediaInfoBuilder_;
    }

    private java.util.List<com.google.cloud.discoveryengine.v1.PanelInfo> panels_ =
        java.util.Collections.emptyList();

    private void ensurePanelsIsMutable() {
      if (!((bitField0_ & 0x00200000) != 0)) {
        panels_ = new java.util.ArrayList<com.google.cloud.discoveryengine.v1.PanelInfo>(panels_);
        bitField0_ |= 0x00200000;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.discoveryengine.v1.PanelInfo,
            com.google.cloud.discoveryengine.v1.PanelInfo.Builder,
            com.google.cloud.discoveryengine.v1.PanelInfoOrBuilder>
        panelsBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. List of panels associated with this event.
     * Used for page-level impression data.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.PanelInfo panels = 22 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.discoveryengine.v1.PanelInfo> getPanelsList() {
      if (panelsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(panels_);
      } else {
        return panelsBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. List of panels associated with this event.
     * Used for page-level impression data.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.PanelInfo panels = 22 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public int getPanelsCount() {
      if (panelsBuilder_ == null) {
        return panels_.size();
      } else {
        return panelsBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. List of panels associated with this event.
     * Used for page-level impression data.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.PanelInfo panels = 22 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.discoveryengine.v1.PanelInfo getPanels(int index) {
      if (panelsBuilder_ == null) {
        return panels_.get(index);
      } else {
        return panelsBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. List of panels associated with this event.
     * Used for page-level impression data.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.PanelInfo panels = 22 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setPanels(int index, com.google.cloud.discoveryengine.v1.PanelInfo value) {
      if (panelsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePanelsIsMutable();
        panels_.set(index, value);
        onChanged();
      } else {
        panelsBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. List of panels associated with this event.
     * Used for page-level impression data.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.PanelInfo panels = 22 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setPanels(
        int index, com.google.cloud.discoveryengine.v1.PanelInfo.Builder builderForValue) {
      if (panelsBuilder_ == null) {
        ensurePanelsIsMutable();
        panels_.set(index, builderForValue.build());
        onChanged();
      } else {
        panelsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. List of panels associated with this event.
     * Used for page-level impression data.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.PanelInfo panels = 22 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addPanels(com.google.cloud.discoveryengine.v1.PanelInfo value) {
      if (panelsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePanelsIsMutable();
        panels_.add(value);
        onChanged();
      } else {
        panelsBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. List of panels associated with this event.
     * Used for page-level impression data.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.PanelInfo panels = 22 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addPanels(int index, com.google.cloud.discoveryengine.v1.PanelInfo value) {
      if (panelsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePanelsIsMutable();
        panels_.add(index, value);
        onChanged();
      } else {
        panelsBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. List of panels associated with this event.
     * Used for page-level impression data.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.PanelInfo panels = 22 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addPanels(
        com.google.cloud.discoveryengine.v1.PanelInfo.Builder builderForValue) {
      if (panelsBuilder_ == null) {
        ensurePanelsIsMutable();
        panels_.add(builderForValue.build());
        onChanged();
      } else {
        panelsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. List of panels associated with this event.
     * Used for page-level impression data.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.PanelInfo panels = 22 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addPanels(
        int index, com.google.cloud.discoveryengine.v1.PanelInfo.Builder builderForValue) {
      if (panelsBuilder_ == null) {
        ensurePanelsIsMutable();
        panels_.add(index, builderForValue.build());
        onChanged();
      } else {
        panelsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. List of panels associated with this event.
     * Used for page-level impression data.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.PanelInfo panels = 22 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAllPanels(
        java.lang.Iterable<? extends com.google.cloud.discoveryengine.v1.PanelInfo> values) {
      if (panelsBuilder_ == null) {
        ensurePanelsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, panels_);
        onChanged();
      } else {
        panelsBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. List of panels associated with this event.
     * Used for page-level impression data.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.PanelInfo panels = 22 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearPanels() {
      if (panelsBuilder_ == null) {
        panels_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00200000);
        onChanged();
      } else {
        panelsBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. List of panels associated with this event.
     * Used for page-level impression data.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.PanelInfo panels = 22 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removePanels(int index) {
      if (panelsBuilder_ == null) {
        ensurePanelsIsMutable();
        panels_.remove(index);
        onChanged();
      } else {
        panelsBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. List of panels associated with this event.
     * Used for page-level impression data.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.PanelInfo panels = 22 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.discoveryengine.v1.PanelInfo.Builder getPanelsBuilder(int index) {
      return getPanelsFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * Optional. List of panels associated with this event.
     * Used for page-level impression data.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.PanelInfo panels = 22 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.discoveryengine.v1.PanelInfoOrBuilder getPanelsOrBuilder(int index) {
      if (panelsBuilder_ == null) {
        return panels_.get(index);
      } else {
        return panelsBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. List of panels associated with this event.
     * Used for page-level impression data.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.PanelInfo panels = 22 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.discoveryengine.v1.PanelInfoOrBuilder>
        getPanelsOrBuilderList() {
      if (panelsBuilder_ != null) {
        return panelsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(panels_);
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. List of panels associated with this event.
     * Used for page-level impression data.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.PanelInfo panels = 22 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.discoveryengine.v1.PanelInfo.Builder addPanelsBuilder() {
      return getPanelsFieldBuilder()
          .addBuilder(com.google.cloud.discoveryengine.v1.PanelInfo.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Optional. List of panels associated with this event.
     * Used for page-level impression data.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.PanelInfo panels = 22 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.discoveryengine.v1.PanelInfo.Builder addPanelsBuilder(int index) {
      return getPanelsFieldBuilder()
          .addBuilder(index, com.google.cloud.discoveryengine.v1.PanelInfo.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Optional. List of panels associated with this event.
     * Used for page-level impression data.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.PanelInfo panels = 22 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.discoveryengine.v1.PanelInfo.Builder>
        getPanelsBuilderList() {
      return getPanelsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.discoveryengine.v1.PanelInfo,
            com.google.cloud.discoveryengine.v1.PanelInfo.Builder,
            com.google.cloud.discoveryengine.v1.PanelInfoOrBuilder>
        getPanelsFieldBuilder() {
      if (panelsBuilder_ == null) {
        panelsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.discoveryengine.v1.PanelInfo,
                com.google.cloud.discoveryengine.v1.PanelInfo.Builder,
                com.google.cloud.discoveryengine.v1.PanelInfoOrBuilder>(
                panels_, ((bitField0_ & 0x00200000) != 0), getParentForChildren(), isClean());
        panels_ = null;
      }
      return panelsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1.UserEvent)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1.UserEvent)
  private static final com.google.cloud.discoveryengine.v1.UserEvent DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.discoveryengine.v1.UserEvent();
  }

  public static com.google.cloud.discoveryengine.v1.UserEvent getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<UserEvent> PARSER =
      new com.google.protobuf.AbstractParser<UserEvent>() {
        @java.lang.Override
        public UserEvent parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<UserEvent> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<UserEvent> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.UserEvent getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
