/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/discoveryengine/v1/user_license.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.discoveryengine.v1;

/**
 *
 *
 * <pre>
 * User License information assigned by the admin.
 * </pre>
 *
 * Protobuf type {@code google.cloud.discoveryengine.v1.UserLicense}
 */
public final class UserLicense extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1.UserLicense)
    UserLicenseOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use UserLicense.newBuilder() to construct.
  private UserLicense(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private UserLicense() {
    userPrincipal_ = "";
    userProfile_ = "";
    licenseAssignmentState_ = 0;
    licenseConfig_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new UserLicense();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.discoveryengine.v1.UserLicenseProto
        .internal_static_google_cloud_discoveryengine_v1_UserLicense_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.discoveryengine.v1.UserLicenseProto
        .internal_static_google_cloud_discoveryengine_v1_UserLicense_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.discoveryengine.v1.UserLicense.class,
            com.google.cloud.discoveryengine.v1.UserLicense.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * License assignment state enumeration.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.discoveryengine.v1.UserLicense.LicenseAssignmentState}
   */
  public enum LicenseAssignmentState implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Default value.
     * </pre>
     *
     * <code>LICENSE_ASSIGNMENT_STATE_UNSPECIFIED = 0;</code>
     */
    LICENSE_ASSIGNMENT_STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * License assigned to the user.
     * </pre>
     *
     * <code>ASSIGNED = 1;</code>
     */
    ASSIGNED(1),
    /**
     *
     *
     * <pre>
     * No license assigned to the user.
     * Deprecated, translated to NO_LICENSE.
     * </pre>
     *
     * <code>UNASSIGNED = 2;</code>
     */
    UNASSIGNED(2),
    /**
     *
     *
     * <pre>
     * No license assigned to the user.
     * </pre>
     *
     * <code>NO_LICENSE = 3;</code>
     */
    NO_LICENSE(3),
    /**
     *
     *
     * <pre>
     * User attempted to login but no license assigned to the user.
     * This state is only used for no user first time login attempt but cannot
     * get license assigned.
     * Users already logged in but cannot get license assigned will be assigned
     * NO_LICENSE state(License could be unassigned by admin).
     * </pre>
     *
     * <code>NO_LICENSE_ATTEMPTED_LOGIN = 4;</code>
     */
    NO_LICENSE_ATTEMPTED_LOGIN(4),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Default value.
     * </pre>
     *
     * <code>LICENSE_ASSIGNMENT_STATE_UNSPECIFIED = 0;</code>
     */
    public static final int LICENSE_ASSIGNMENT_STATE_UNSPECIFIED_VALUE = 0;

    /**
     *
     *
     * <pre>
     * License assigned to the user.
     * </pre>
     *
     * <code>ASSIGNED = 1;</code>
     */
    public static final int ASSIGNED_VALUE = 1;

    /**
     *
     *
     * <pre>
     * No license assigned to the user.
     * Deprecated, translated to NO_LICENSE.
     * </pre>
     *
     * <code>UNASSIGNED = 2;</code>
     */
    public static final int UNASSIGNED_VALUE = 2;

    /**
     *
     *
     * <pre>
     * No license assigned to the user.
     * </pre>
     *
     * <code>NO_LICENSE = 3;</code>
     */
    public static final int NO_LICENSE_VALUE = 3;

    /**
     *
     *
     * <pre>
     * User attempted to login but no license assigned to the user.
     * This state is only used for no user first time login attempt but cannot
     * get license assigned.
     * Users already logged in but cannot get license assigned will be assigned
     * NO_LICENSE state(License could be unassigned by admin).
     * </pre>
     *
     * <code>NO_LICENSE_ATTEMPTED_LOGIN = 4;</code>
     */
    public static final int NO_LICENSE_ATTEMPTED_LOGIN_VALUE = 4;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static LicenseAssignmentState valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static LicenseAssignmentState forNumber(int value) {
      switch (value) {
        case 0:
          return LICENSE_ASSIGNMENT_STATE_UNSPECIFIED;
        case 1:
          return ASSIGNED;
        case 2:
          return UNASSIGNED;
        case 3:
          return NO_LICENSE;
        case 4:
          return NO_LICENSE_ATTEMPTED_LOGIN;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<LicenseAssignmentState>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<LicenseAssignmentState>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<LicenseAssignmentState>() {
              public LicenseAssignmentState findValueByNumber(int number) {
                return LicenseAssignmentState.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1.UserLicense.getDescriptor().getEnumTypes().get(0);
    }

    private static final LicenseAssignmentState[] VALUES = values();

    public static LicenseAssignmentState valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private LicenseAssignmentState(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.discoveryengine.v1.UserLicense.LicenseAssignmentState)
  }

  private int bitField0_;
  public static final int USER_PRINCIPAL_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object userPrincipal_ = "";

  /**
   *
   *
   * <pre>
   * Required. Immutable. The user principal of the User, could be email address
   * or other prinical identifier. This field is immutable. Admin assign
   * licenses based on the user principal.
   * </pre>
   *
   * <code>
   * string user_principal = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The userPrincipal.
   */
  @java.lang.Override
  public java.lang.String getUserPrincipal() {
    java.lang.Object ref = userPrincipal_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      userPrincipal_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. Immutable. The user principal of the User, could be email address
   * or other prinical identifier. This field is immutable. Admin assign
   * licenses based on the user principal.
   * </pre>
   *
   * <code>
   * string user_principal = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The bytes for userPrincipal.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getUserPrincipalBytes() {
    java.lang.Object ref = userPrincipal_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      userPrincipal_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int USER_PROFILE_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object userProfile_ = "";

  /**
   *
   *
   * <pre>
   * Optional. The user profile.
   * We user user full name(First name + Last name) as user profile.
   * </pre>
   *
   * <code>string user_profile = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The userProfile.
   */
  @java.lang.Override
  public java.lang.String getUserProfile() {
    java.lang.Object ref = userProfile_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      userProfile_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. The user profile.
   * We user user full name(First name + Last name) as user profile.
   * </pre>
   *
   * <code>string user_profile = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for userProfile.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getUserProfileBytes() {
    java.lang.Object ref = userProfile_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      userProfile_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LICENSE_ASSIGNMENT_STATE_FIELD_NUMBER = 4;
  private int licenseAssignmentState_ = 0;

  /**
   *
   *
   * <pre>
   * Output only. License assignment state of the user.
   * If the user is assigned with a license config, the user loggin will be
   * assigned with the license;
   * If the user's license assignment state is unassigned or unspecified, no
   * license config will be associated to the user;
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1.UserLicense.LicenseAssignmentState license_assignment_state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for licenseAssignmentState.
   */
  @java.lang.Override
  public int getLicenseAssignmentStateValue() {
    return licenseAssignmentState_;
  }

  /**
   *
   *
   * <pre>
   * Output only. License assignment state of the user.
   * If the user is assigned with a license config, the user loggin will be
   * assigned with the license;
   * If the user's license assignment state is unassigned or unspecified, no
   * license config will be associated to the user;
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1.UserLicense.LicenseAssignmentState license_assignment_state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The licenseAssignmentState.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.UserLicense.LicenseAssignmentState
      getLicenseAssignmentState() {
    com.google.cloud.discoveryengine.v1.UserLicense.LicenseAssignmentState result =
        com.google.cloud.discoveryengine.v1.UserLicense.LicenseAssignmentState.forNumber(
            licenseAssignmentState_);
    return result == null
        ? com.google.cloud.discoveryengine.v1.UserLicense.LicenseAssignmentState.UNRECOGNIZED
        : result;
  }

  public static final int LICENSE_CONFIG_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object licenseConfig_ = "";

  /**
   *
   *
   * <pre>
   * Optional. The full resource name of the Subscription(LicenseConfig)
   * assigned to the user.
   * </pre>
   *
   * <code>
   * string license_config = 5 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The licenseConfig.
   */
  @java.lang.Override
  public java.lang.String getLicenseConfig() {
    java.lang.Object ref = licenseConfig_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      licenseConfig_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. The full resource name of the Subscription(LicenseConfig)
   * assigned to the user.
   * </pre>
   *
   * <code>
   * string license_config = 5 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for licenseConfig.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLicenseConfigBytes() {
    java.lang.Object ref = licenseConfig_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      licenseConfig_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 6;
  private com.google.protobuf.Timestamp createTime_;

  /**
   *
   *
   * <pre>
   * Output only. User created timestamp.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. User created timestamp.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  /**
   *
   *
   * <pre>
   * Output only. User created timestamp.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 7;
  private com.google.protobuf.Timestamp updateTime_;

  /**
   *
   *
   * <pre>
   * Output only. User update timestamp.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. User update timestamp.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  /**
   *
   *
   * <pre>
   * Output only. User update timestamp.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int LAST_LOGIN_TIME_FIELD_NUMBER = 8;
  private com.google.protobuf.Timestamp lastLoginTime_;

  /**
   *
   *
   * <pre>
   * Output only. User last logged in time.
   * If the user has not logged in yet, this field will be empty.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp last_login_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the lastLoginTime field is set.
   */
  @java.lang.Override
  public boolean hasLastLoginTime() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. User last logged in time.
   * If the user has not logged in yet, this field will be empty.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp last_login_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The lastLoginTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getLastLoginTime() {
    return lastLoginTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : lastLoginTime_;
  }

  /**
   *
   *
   * <pre>
   * Output only. User last logged in time.
   * If the user has not logged in yet, this field will be empty.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp last_login_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getLastLoginTimeOrBuilder() {
    return lastLoginTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : lastLoginTime_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(userPrincipal_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, userPrincipal_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(userProfile_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, userProfile_);
    }
    if (licenseAssignmentState_
        != com.google.cloud.discoveryengine.v1.UserLicense.LicenseAssignmentState
            .LICENSE_ASSIGNMENT_STATE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(4, licenseAssignmentState_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(licenseConfig_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, licenseConfig_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(6, getCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(7, getUpdateTime());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(8, getLastLoginTime());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(userPrincipal_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, userPrincipal_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(userProfile_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, userProfile_);
    }
    if (licenseAssignmentState_
        != com.google.cloud.discoveryengine.v1.UserLicense.LicenseAssignmentState
            .LICENSE_ASSIGNMENT_STATE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, licenseAssignmentState_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(licenseConfig_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, licenseConfig_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getUpdateTime());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getLastLoginTime());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.discoveryengine.v1.UserLicense)) {
      return super.equals(obj);
    }
    com.google.cloud.discoveryengine.v1.UserLicense other =
        (com.google.cloud.discoveryengine.v1.UserLicense) obj;

    if (!getUserPrincipal().equals(other.getUserPrincipal())) return false;
    if (!getUserProfile().equals(other.getUserProfile())) return false;
    if (licenseAssignmentState_ != other.licenseAssignmentState_) return false;
    if (!getLicenseConfig().equals(other.getLicenseConfig())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (hasLastLoginTime() != other.hasLastLoginTime()) return false;
    if (hasLastLoginTime()) {
      if (!getLastLoginTime().equals(other.getLastLoginTime())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + USER_PRINCIPAL_FIELD_NUMBER;
    hash = (53 * hash) + getUserPrincipal().hashCode();
    hash = (37 * hash) + USER_PROFILE_FIELD_NUMBER;
    hash = (53 * hash) + getUserProfile().hashCode();
    hash = (37 * hash) + LICENSE_ASSIGNMENT_STATE_FIELD_NUMBER;
    hash = (53 * hash) + licenseAssignmentState_;
    hash = (37 * hash) + LICENSE_CONFIG_FIELD_NUMBER;
    hash = (53 * hash) + getLicenseConfig().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    if (hasLastLoginTime()) {
      hash = (37 * hash) + LAST_LOGIN_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getLastLoginTime().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.discoveryengine.v1.UserLicense parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1.UserLicense parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.UserLicense parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1.UserLicense parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.UserLicense parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1.UserLicense parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.UserLicense parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1.UserLicense parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.UserLicense parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1.UserLicense parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.UserLicense parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1.UserLicense parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.discoveryengine.v1.UserLicense prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * User License information assigned by the admin.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1.UserLicense}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1.UserLicense)
      com.google.cloud.discoveryengine.v1.UserLicenseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1.UserLicenseProto
          .internal_static_google_cloud_discoveryengine_v1_UserLicense_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1.UserLicenseProto
          .internal_static_google_cloud_discoveryengine_v1_UserLicense_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1.UserLicense.class,
              com.google.cloud.discoveryengine.v1.UserLicense.Builder.class);
    }

    // Construct using com.google.cloud.discoveryengine.v1.UserLicense.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getCreateTimeFieldBuilder();
        getUpdateTimeFieldBuilder();
        getLastLoginTimeFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      userPrincipal_ = "";
      userProfile_ = "";
      licenseAssignmentState_ = 0;
      licenseConfig_ = "";
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      lastLoginTime_ = null;
      if (lastLoginTimeBuilder_ != null) {
        lastLoginTimeBuilder_.dispose();
        lastLoginTimeBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.discoveryengine.v1.UserLicenseProto
          .internal_static_google_cloud_discoveryengine_v1_UserLicense_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.UserLicense getDefaultInstanceForType() {
      return com.google.cloud.discoveryengine.v1.UserLicense.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.UserLicense build() {
      com.google.cloud.discoveryengine.v1.UserLicense result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.UserLicense buildPartial() {
      com.google.cloud.discoveryengine.v1.UserLicense result =
          new com.google.cloud.discoveryengine.v1.UserLicense(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.discoveryengine.v1.UserLicense result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.userPrincipal_ = userPrincipal_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.userProfile_ = userProfile_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.licenseAssignmentState_ = licenseAssignmentState_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.licenseConfig_ = licenseConfig_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.lastLoginTime_ =
            lastLoginTimeBuilder_ == null ? lastLoginTime_ : lastLoginTimeBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.discoveryengine.v1.UserLicense) {
        return mergeFrom((com.google.cloud.discoveryengine.v1.UserLicense) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.discoveryengine.v1.UserLicense other) {
      if (other == com.google.cloud.discoveryengine.v1.UserLicense.getDefaultInstance())
        return this;
      if (!other.getUserPrincipal().isEmpty()) {
        userPrincipal_ = other.userPrincipal_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getUserProfile().isEmpty()) {
        userProfile_ = other.userProfile_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.licenseAssignmentState_ != 0) {
        setLicenseAssignmentStateValue(other.getLicenseAssignmentStateValue());
      }
      if (!other.getLicenseConfig().isEmpty()) {
        licenseConfig_ = other.licenseConfig_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      if (other.hasLastLoginTime()) {
        mergeLastLoginTime(other.getLastLoginTime());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                userPrincipal_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 26:
              {
                userProfile_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 26
            case 32:
              {
                licenseAssignmentState_ = input.readEnum();
                bitField0_ |= 0x00000004;
                break;
              } // case 32
            case 42:
              {
                licenseConfig_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 58
            case 66:
              {
                input.readMessage(getLastLoginTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 66
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object userPrincipal_ = "";

    /**
     *
     *
     * <pre>
     * Required. Immutable. The user principal of the User, could be email address
     * or other prinical identifier. This field is immutable. Admin assign
     * licenses based on the user principal.
     * </pre>
     *
     * <code>
     * string user_principal = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The userPrincipal.
     */
    public java.lang.String getUserPrincipal() {
      java.lang.Object ref = userPrincipal_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        userPrincipal_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Immutable. The user principal of the User, could be email address
     * or other prinical identifier. This field is immutable. Admin assign
     * licenses based on the user principal.
     * </pre>
     *
     * <code>
     * string user_principal = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The bytes for userPrincipal.
     */
    public com.google.protobuf.ByteString getUserPrincipalBytes() {
      java.lang.Object ref = userPrincipal_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        userPrincipal_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Immutable. The user principal of the User, could be email address
     * or other prinical identifier. This field is immutable. Admin assign
     * licenses based on the user principal.
     * </pre>
     *
     * <code>
     * string user_principal = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The userPrincipal to set.
     * @return This builder for chaining.
     */
    public Builder setUserPrincipal(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      userPrincipal_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Immutable. The user principal of the User, could be email address
     * or other prinical identifier. This field is immutable. Admin assign
     * licenses based on the user principal.
     * </pre>
     *
     * <code>
     * string user_principal = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUserPrincipal() {
      userPrincipal_ = getDefaultInstance().getUserPrincipal();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Immutable. The user principal of the User, could be email address
     * or other prinical identifier. This field is immutable. Admin assign
     * licenses based on the user principal.
     * </pre>
     *
     * <code>
     * string user_principal = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The bytes for userPrincipal to set.
     * @return This builder for chaining.
     */
    public Builder setUserPrincipalBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      userPrincipal_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object userProfile_ = "";

    /**
     *
     *
     * <pre>
     * Optional. The user profile.
     * We user user full name(First name + Last name) as user profile.
     * </pre>
     *
     * <code>string user_profile = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The userProfile.
     */
    public java.lang.String getUserProfile() {
      java.lang.Object ref = userProfile_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        userProfile_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The user profile.
     * We user user full name(First name + Last name) as user profile.
     * </pre>
     *
     * <code>string user_profile = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for userProfile.
     */
    public com.google.protobuf.ByteString getUserProfileBytes() {
      java.lang.Object ref = userProfile_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        userProfile_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The user profile.
     * We user user full name(First name + Last name) as user profile.
     * </pre>
     *
     * <code>string user_profile = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The userProfile to set.
     * @return This builder for chaining.
     */
    public Builder setUserProfile(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      userProfile_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The user profile.
     * We user user full name(First name + Last name) as user profile.
     * </pre>
     *
     * <code>string user_profile = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUserProfile() {
      userProfile_ = getDefaultInstance().getUserProfile();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The user profile.
     * We user user full name(First name + Last name) as user profile.
     * </pre>
     *
     * <code>string user_profile = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for userProfile to set.
     * @return This builder for chaining.
     */
    public Builder setUserProfileBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      userProfile_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private int licenseAssignmentState_ = 0;

    /**
     *
     *
     * <pre>
     * Output only. License assignment state of the user.
     * If the user is assigned with a license config, the user loggin will be
     * assigned with the license;
     * If the user's license assignment state is unassigned or unspecified, no
     * license config will be associated to the user;
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.UserLicense.LicenseAssignmentState license_assignment_state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for licenseAssignmentState.
     */
    @java.lang.Override
    public int getLicenseAssignmentStateValue() {
      return licenseAssignmentState_;
    }

    /**
     *
     *
     * <pre>
     * Output only. License assignment state of the user.
     * If the user is assigned with a license config, the user loggin will be
     * assigned with the license;
     * If the user's license assignment state is unassigned or unspecified, no
     * license config will be associated to the user;
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.UserLicense.LicenseAssignmentState license_assignment_state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for licenseAssignmentState to set.
     * @return This builder for chaining.
     */
    public Builder setLicenseAssignmentStateValue(int value) {
      licenseAssignmentState_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. License assignment state of the user.
     * If the user is assigned with a license config, the user loggin will be
     * assigned with the license;
     * If the user's license assignment state is unassigned or unspecified, no
     * license config will be associated to the user;
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.UserLicense.LicenseAssignmentState license_assignment_state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The licenseAssignmentState.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.UserLicense.LicenseAssignmentState
        getLicenseAssignmentState() {
      com.google.cloud.discoveryengine.v1.UserLicense.LicenseAssignmentState result =
          com.google.cloud.discoveryengine.v1.UserLicense.LicenseAssignmentState.forNumber(
              licenseAssignmentState_);
      return result == null
          ? com.google.cloud.discoveryengine.v1.UserLicense.LicenseAssignmentState.UNRECOGNIZED
          : result;
    }

    /**
     *
     *
     * <pre>
     * Output only. License assignment state of the user.
     * If the user is assigned with a license config, the user loggin will be
     * assigned with the license;
     * If the user's license assignment state is unassigned or unspecified, no
     * license config will be associated to the user;
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.UserLicense.LicenseAssignmentState license_assignment_state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The licenseAssignmentState to set.
     * @return This builder for chaining.
     */
    public Builder setLicenseAssignmentState(
        com.google.cloud.discoveryengine.v1.UserLicense.LicenseAssignmentState value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000004;
      licenseAssignmentState_ = value.getNumber();
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. License assignment state of the user.
     * If the user is assigned with a license config, the user loggin will be
     * assigned with the license;
     * If the user's license assignment state is unassigned or unspecified, no
     * license config will be associated to the user;
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.UserLicense.LicenseAssignmentState license_assignment_state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLicenseAssignmentState() {
      bitField0_ = (bitField0_ & ~0x00000004);
      licenseAssignmentState_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object licenseConfig_ = "";

    /**
     *
     *
     * <pre>
     * Optional. The full resource name of the Subscription(LicenseConfig)
     * assigned to the user.
     * </pre>
     *
     * <code>
     * string license_config = 5 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The licenseConfig.
     */
    public java.lang.String getLicenseConfig() {
      java.lang.Object ref = licenseConfig_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        licenseConfig_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The full resource name of the Subscription(LicenseConfig)
     * assigned to the user.
     * </pre>
     *
     * <code>
     * string license_config = 5 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for licenseConfig.
     */
    public com.google.protobuf.ByteString getLicenseConfigBytes() {
      java.lang.Object ref = licenseConfig_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        licenseConfig_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The full resource name of the Subscription(LicenseConfig)
     * assigned to the user.
     * </pre>
     *
     * <code>
     * string license_config = 5 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The licenseConfig to set.
     * @return This builder for chaining.
     */
    public Builder setLicenseConfig(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      licenseConfig_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The full resource name of the Subscription(LicenseConfig)
     * assigned to the user.
     * </pre>
     *
     * <code>
     * string license_config = 5 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLicenseConfig() {
      licenseConfig_ = getDefaultInstance().getLicenseConfig();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The full resource name of the Subscription(LicenseConfig)
     * assigned to the user.
     * </pre>
     *
     * <code>
     * string license_config = 5 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for licenseConfig to set.
     * @return This builder for chaining.
     */
    public Builder setLicenseConfigBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      licenseConfig_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. User created timestamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000010) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. User created timestamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. User created timestamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. User created timestamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. User created timestamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. User created timestamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000010);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. User created timestamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. User created timestamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. User created timestamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. User update timestamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000020) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. User update timestamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. User update timestamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. User update timestamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. User update timestamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      if (updateTime_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. User update timestamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000020);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. User update timestamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. User update timestamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. User update timestamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private com.google.protobuf.Timestamp lastLoginTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        lastLoginTimeBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. User last logged in time.
     * If the user has not logged in yet, this field will be empty.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_login_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the lastLoginTime field is set.
     */
    public boolean hasLastLoginTime() {
      return ((bitField0_ & 0x00000040) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. User last logged in time.
     * If the user has not logged in yet, this field will be empty.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_login_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The lastLoginTime.
     */
    public com.google.protobuf.Timestamp getLastLoginTime() {
      if (lastLoginTimeBuilder_ == null) {
        return lastLoginTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : lastLoginTime_;
      } else {
        return lastLoginTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. User last logged in time.
     * If the user has not logged in yet, this field will be empty.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_login_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setLastLoginTime(com.google.protobuf.Timestamp value) {
      if (lastLoginTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        lastLoginTime_ = value;
      } else {
        lastLoginTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. User last logged in time.
     * If the user has not logged in yet, this field will be empty.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_login_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setLastLoginTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (lastLoginTimeBuilder_ == null) {
        lastLoginTime_ = builderForValue.build();
      } else {
        lastLoginTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. User last logged in time.
     * If the user has not logged in yet, this field will be empty.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_login_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeLastLoginTime(com.google.protobuf.Timestamp value) {
      if (lastLoginTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && lastLoginTime_ != null
            && lastLoginTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getLastLoginTimeBuilder().mergeFrom(value);
        } else {
          lastLoginTime_ = value;
        }
      } else {
        lastLoginTimeBuilder_.mergeFrom(value);
      }
      if (lastLoginTime_ != null) {
        bitField0_ |= 0x00000040;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. User last logged in time.
     * If the user has not logged in yet, this field will be empty.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_login_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearLastLoginTime() {
      bitField0_ = (bitField0_ & ~0x00000040);
      lastLoginTime_ = null;
      if (lastLoginTimeBuilder_ != null) {
        lastLoginTimeBuilder_.dispose();
        lastLoginTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. User last logged in time.
     * If the user has not logged in yet, this field will be empty.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_login_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getLastLoginTimeBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getLastLoginTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. User last logged in time.
     * If the user has not logged in yet, this field will be empty.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_login_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getLastLoginTimeOrBuilder() {
      if (lastLoginTimeBuilder_ != null) {
        return lastLoginTimeBuilder_.getMessageOrBuilder();
      } else {
        return lastLoginTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : lastLoginTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. User last logged in time.
     * If the user has not logged in yet, this field will be empty.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_login_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getLastLoginTimeFieldBuilder() {
      if (lastLoginTimeBuilder_ == null) {
        lastLoginTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getLastLoginTime(), getParentForChildren(), isClean());
        lastLoginTime_ = null;
      }
      return lastLoginTimeBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1.UserLicense)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1.UserLicense)
  private static final com.google.cloud.discoveryengine.v1.UserLicense DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.discoveryengine.v1.UserLicense();
  }

  public static com.google.cloud.discoveryengine.v1.UserLicense getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<UserLicense> PARSER =
      new com.google.protobuf.AbstractParser<UserLicense>() {
        @java.lang.Override
        public UserLicense parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<UserLicense> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<UserLicense> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.UserLicense getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
