/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/discoveryengine/v1alpha/schema.proto

// Protobuf Java Version: 3.25.4
package com.google.cloud.discoveryengine.v1alpha;

/**
 *
 *
 * <pre>
 * Configurations for fields of a schema. For example, configuring a field is
 * indexable, or searchable.
 * </pre>
 *
 * Protobuf type {@code google.cloud.discoveryengine.v1alpha.FieldConfig}
 */
public final class FieldConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1alpha.FieldConfig)
    FieldConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use FieldConfig.newBuilder() to construct.
  private FieldConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private FieldConfig() {
    fieldPath_ = "";
    fieldType_ = 0;
    indexableOption_ = 0;
    dynamicFacetableOption_ = 0;
    searchableOption_ = 0;
    retrievableOption_ = 0;
    completableOption_ = 0;
    recsFilterableOption_ = 0;
    keyPropertyType_ = "";
    advancedSiteSearchDataSources_ = java.util.Collections.emptyList();
    schemaOrgPaths_ = com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new FieldConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.discoveryengine.v1alpha.SchemaProto
        .internal_static_google_cloud_discoveryengine_v1alpha_FieldConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.discoveryengine.v1alpha.SchemaProto
        .internal_static_google_cloud_discoveryengine_v1alpha_FieldConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.discoveryengine.v1alpha.FieldConfig.class,
            com.google.cloud.discoveryengine.v1alpha.FieldConfig.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Field value type in the Schema.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.discoveryengine.v1alpha.FieldConfig.FieldType}
   */
  public enum FieldType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Field type is unspecified.
     * </pre>
     *
     * <code>FIELD_TYPE_UNSPECIFIED = 0;</code>
     */
    FIELD_TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Field value type is Object.
     * </pre>
     *
     * <code>OBJECT = 1;</code>
     */
    OBJECT(1),
    /**
     *
     *
     * <pre>
     * Field value type is String.
     * </pre>
     *
     * <code>STRING = 2;</code>
     */
    STRING(2),
    /**
     *
     *
     * <pre>
     * Field value type is Number.
     * </pre>
     *
     * <code>NUMBER = 3;</code>
     */
    NUMBER(3),
    /**
     *
     *
     * <pre>
     * Field value type is Integer.
     * </pre>
     *
     * <code>INTEGER = 4;</code>
     */
    INTEGER(4),
    /**
     *
     *
     * <pre>
     * Field value type is Boolean.
     * </pre>
     *
     * <code>BOOLEAN = 5;</code>
     */
    BOOLEAN(5),
    /**
     *
     *
     * <pre>
     * Field value type is Geolocation. Geolocation is expressed as an object
     * with the following keys:
     *
     * * `id`: a string representing the location id
     * * `longitude`: a number representing the longitude coordinate of the
     * location
     * * `latitude`: a number repesenting the latitude coordinate of the
     * location
     * * `address`: a string representing the full address of the location
     *
     * `latitude` and `longitude` must always be provided together. At least one
     * of a) `address` or b) `latitude`-`longitude` pair must be provided.
     * </pre>
     *
     * <code>GEOLOCATION = 6;</code>
     */
    GEOLOCATION(6),
    /**
     *
     *
     * <pre>
     * Field value type is Datetime. Datetime can be expressed as either:
     *
     * * a number representing milliseconds-since-the-epoch
     * * a string representing milliseconds-since-the-epoch. e.g.
     * `"1420070400001"`
     * * a string representing the [ISO
     * 8601](https://en.wikipedia.org/wiki/ISO_8601) date or date and time. e.g.
     * `"2015-01-01"` or `"2015-01-01T12:10:30Z"`
     * </pre>
     *
     * <code>DATETIME = 7;</code>
     */
    DATETIME(7),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Field type is unspecified.
     * </pre>
     *
     * <code>FIELD_TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int FIELD_TYPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Field value type is Object.
     * </pre>
     *
     * <code>OBJECT = 1;</code>
     */
    public static final int OBJECT_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Field value type is String.
     * </pre>
     *
     * <code>STRING = 2;</code>
     */
    public static final int STRING_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Field value type is Number.
     * </pre>
     *
     * <code>NUMBER = 3;</code>
     */
    public static final int NUMBER_VALUE = 3;
    /**
     *
     *
     * <pre>
     * Field value type is Integer.
     * </pre>
     *
     * <code>INTEGER = 4;</code>
     */
    public static final int INTEGER_VALUE = 4;
    /**
     *
     *
     * <pre>
     * Field value type is Boolean.
     * </pre>
     *
     * <code>BOOLEAN = 5;</code>
     */
    public static final int BOOLEAN_VALUE = 5;
    /**
     *
     *
     * <pre>
     * Field value type is Geolocation. Geolocation is expressed as an object
     * with the following keys:
     *
     * * `id`: a string representing the location id
     * * `longitude`: a number representing the longitude coordinate of the
     * location
     * * `latitude`: a number repesenting the latitude coordinate of the
     * location
     * * `address`: a string representing the full address of the location
     *
     * `latitude` and `longitude` must always be provided together. At least one
     * of a) `address` or b) `latitude`-`longitude` pair must be provided.
     * </pre>
     *
     * <code>GEOLOCATION = 6;</code>
     */
    public static final int GEOLOCATION_VALUE = 6;
    /**
     *
     *
     * <pre>
     * Field value type is Datetime. Datetime can be expressed as either:
     *
     * * a number representing milliseconds-since-the-epoch
     * * a string representing milliseconds-since-the-epoch. e.g.
     * `"1420070400001"`
     * * a string representing the [ISO
     * 8601](https://en.wikipedia.org/wiki/ISO_8601) date or date and time. e.g.
     * `"2015-01-01"` or `"2015-01-01T12:10:30Z"`
     * </pre>
     *
     * <code>DATETIME = 7;</code>
     */
    public static final int DATETIME_VALUE = 7;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static FieldType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static FieldType forNumber(int value) {
      switch (value) {
        case 0:
          return FIELD_TYPE_UNSPECIFIED;
        case 1:
          return OBJECT;
        case 2:
          return STRING;
        case 3:
          return NUMBER;
        case 4:
          return INTEGER;
        case 5:
          return BOOLEAN;
        case 6:
          return GEOLOCATION;
        case 7:
          return DATETIME;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<FieldType> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<FieldType> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<FieldType>() {
          public FieldType findValueByNumber(int number) {
            return FieldType.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1alpha.FieldConfig.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final FieldType[] VALUES = values();

    public static FieldType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private FieldType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.discoveryengine.v1alpha.FieldConfig.FieldType)
  }

  /**
   *
   *
   * <pre>
   * The setting of Indexable options in schema.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.discoveryengine.v1alpha.FieldConfig.IndexableOption}
   */
  public enum IndexableOption implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Value used when unset.
     * </pre>
     *
     * <code>INDEXABLE_OPTION_UNSPECIFIED = 0;</code>
     */
    INDEXABLE_OPTION_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Indexable option enabled for a schema field.
     * </pre>
     *
     * <code>INDEXABLE_ENABLED = 1;</code>
     */
    INDEXABLE_ENABLED(1),
    /**
     *
     *
     * <pre>
     * Indexable option disabled for a schema field.
     * </pre>
     *
     * <code>INDEXABLE_DISABLED = 2;</code>
     */
    INDEXABLE_DISABLED(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Value used when unset.
     * </pre>
     *
     * <code>INDEXABLE_OPTION_UNSPECIFIED = 0;</code>
     */
    public static final int INDEXABLE_OPTION_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Indexable option enabled for a schema field.
     * </pre>
     *
     * <code>INDEXABLE_ENABLED = 1;</code>
     */
    public static final int INDEXABLE_ENABLED_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Indexable option disabled for a schema field.
     * </pre>
     *
     * <code>INDEXABLE_DISABLED = 2;</code>
     */
    public static final int INDEXABLE_DISABLED_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static IndexableOption valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static IndexableOption forNumber(int value) {
      switch (value) {
        case 0:
          return INDEXABLE_OPTION_UNSPECIFIED;
        case 1:
          return INDEXABLE_ENABLED;
        case 2:
          return INDEXABLE_DISABLED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<IndexableOption> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<IndexableOption>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<IndexableOption>() {
              public IndexableOption findValueByNumber(int number) {
                return IndexableOption.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1alpha.FieldConfig.getDescriptor()
          .getEnumTypes()
          .get(1);
    }

    private static final IndexableOption[] VALUES = values();

    public static IndexableOption valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private IndexableOption(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.discoveryengine.v1alpha.FieldConfig.IndexableOption)
  }

  /**
   *
   *
   * <pre>
   * The status of the dynamic facetable option of a schema field.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.discoveryengine.v1alpha.FieldConfig.DynamicFacetableOption}
   */
  public enum DynamicFacetableOption implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Value used when unset.
     * </pre>
     *
     * <code>DYNAMIC_FACETABLE_OPTION_UNSPECIFIED = 0;</code>
     */
    DYNAMIC_FACETABLE_OPTION_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Dynamic facetable option enabled for a schema field.
     * </pre>
     *
     * <code>DYNAMIC_FACETABLE_ENABLED = 1;</code>
     */
    DYNAMIC_FACETABLE_ENABLED(1),
    /**
     *
     *
     * <pre>
     * Dynamic facetable option disabled for a schema field.
     * </pre>
     *
     * <code>DYNAMIC_FACETABLE_DISABLED = 2;</code>
     */
    DYNAMIC_FACETABLE_DISABLED(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Value used when unset.
     * </pre>
     *
     * <code>DYNAMIC_FACETABLE_OPTION_UNSPECIFIED = 0;</code>
     */
    public static final int DYNAMIC_FACETABLE_OPTION_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Dynamic facetable option enabled for a schema field.
     * </pre>
     *
     * <code>DYNAMIC_FACETABLE_ENABLED = 1;</code>
     */
    public static final int DYNAMIC_FACETABLE_ENABLED_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Dynamic facetable option disabled for a schema field.
     * </pre>
     *
     * <code>DYNAMIC_FACETABLE_DISABLED = 2;</code>
     */
    public static final int DYNAMIC_FACETABLE_DISABLED_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static DynamicFacetableOption valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static DynamicFacetableOption forNumber(int value) {
      switch (value) {
        case 0:
          return DYNAMIC_FACETABLE_OPTION_UNSPECIFIED;
        case 1:
          return DYNAMIC_FACETABLE_ENABLED;
        case 2:
          return DYNAMIC_FACETABLE_DISABLED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<DynamicFacetableOption>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<DynamicFacetableOption>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<DynamicFacetableOption>() {
              public DynamicFacetableOption findValueByNumber(int number) {
                return DynamicFacetableOption.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1alpha.FieldConfig.getDescriptor()
          .getEnumTypes()
          .get(2);
    }

    private static final DynamicFacetableOption[] VALUES = values();

    public static DynamicFacetableOption valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private DynamicFacetableOption(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.discoveryengine.v1alpha.FieldConfig.DynamicFacetableOption)
  }

  /**
   *
   *
   * <pre>
   * The setting of Searchable options in schema.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.discoveryengine.v1alpha.FieldConfig.SearchableOption}
   */
  public enum SearchableOption implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Value used when unset.
     * </pre>
     *
     * <code>SEARCHABLE_OPTION_UNSPECIFIED = 0;</code>
     */
    SEARCHABLE_OPTION_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Searchable option enabled for a schema field.
     * </pre>
     *
     * <code>SEARCHABLE_ENABLED = 1;</code>
     */
    SEARCHABLE_ENABLED(1),
    /**
     *
     *
     * <pre>
     * Searchable option disabled for a schema field.
     * </pre>
     *
     * <code>SEARCHABLE_DISABLED = 2;</code>
     */
    SEARCHABLE_DISABLED(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Value used when unset.
     * </pre>
     *
     * <code>SEARCHABLE_OPTION_UNSPECIFIED = 0;</code>
     */
    public static final int SEARCHABLE_OPTION_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Searchable option enabled for a schema field.
     * </pre>
     *
     * <code>SEARCHABLE_ENABLED = 1;</code>
     */
    public static final int SEARCHABLE_ENABLED_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Searchable option disabled for a schema field.
     * </pre>
     *
     * <code>SEARCHABLE_DISABLED = 2;</code>
     */
    public static final int SEARCHABLE_DISABLED_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SearchableOption valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static SearchableOption forNumber(int value) {
      switch (value) {
        case 0:
          return SEARCHABLE_OPTION_UNSPECIFIED;
        case 1:
          return SEARCHABLE_ENABLED;
        case 2:
          return SEARCHABLE_DISABLED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<SearchableOption> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<SearchableOption>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<SearchableOption>() {
              public SearchableOption findValueByNumber(int number) {
                return SearchableOption.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1alpha.FieldConfig.getDescriptor()
          .getEnumTypes()
          .get(3);
    }

    private static final SearchableOption[] VALUES = values();

    public static SearchableOption valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private SearchableOption(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.discoveryengine.v1alpha.FieldConfig.SearchableOption)
  }

  /**
   *
   *
   * <pre>
   * The setting of Retrievable options in schema.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.discoveryengine.v1alpha.FieldConfig.RetrievableOption}
   */
  public enum RetrievableOption implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Value used when unset.
     * </pre>
     *
     * <code>RETRIEVABLE_OPTION_UNSPECIFIED = 0;</code>
     */
    RETRIEVABLE_OPTION_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Retrievable option enabled for a schema field.
     * </pre>
     *
     * <code>RETRIEVABLE_ENABLED = 1;</code>
     */
    RETRIEVABLE_ENABLED(1),
    /**
     *
     *
     * <pre>
     * Retrievable option disabled for a schema field.
     * </pre>
     *
     * <code>RETRIEVABLE_DISABLED = 2;</code>
     */
    RETRIEVABLE_DISABLED(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Value used when unset.
     * </pre>
     *
     * <code>RETRIEVABLE_OPTION_UNSPECIFIED = 0;</code>
     */
    public static final int RETRIEVABLE_OPTION_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Retrievable option enabled for a schema field.
     * </pre>
     *
     * <code>RETRIEVABLE_ENABLED = 1;</code>
     */
    public static final int RETRIEVABLE_ENABLED_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Retrievable option disabled for a schema field.
     * </pre>
     *
     * <code>RETRIEVABLE_DISABLED = 2;</code>
     */
    public static final int RETRIEVABLE_DISABLED_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static RetrievableOption valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static RetrievableOption forNumber(int value) {
      switch (value) {
        case 0:
          return RETRIEVABLE_OPTION_UNSPECIFIED;
        case 1:
          return RETRIEVABLE_ENABLED;
        case 2:
          return RETRIEVABLE_DISABLED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<RetrievableOption>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<RetrievableOption>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<RetrievableOption>() {
              public RetrievableOption findValueByNumber(int number) {
                return RetrievableOption.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1alpha.FieldConfig.getDescriptor()
          .getEnumTypes()
          .get(4);
    }

    private static final RetrievableOption[] VALUES = values();

    public static RetrievableOption valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private RetrievableOption(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.discoveryengine.v1alpha.FieldConfig.RetrievableOption)
  }

  /**
   *
   *
   * <pre>
   * The setting of Completable options in schema.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.discoveryengine.v1alpha.FieldConfig.CompletableOption}
   */
  public enum CompletableOption implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Value used when unset.
     * </pre>
     *
     * <code>COMPLETABLE_OPTION_UNSPECIFIED = 0;</code>
     */
    COMPLETABLE_OPTION_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Completable option enabled for a schema field.
     * </pre>
     *
     * <code>COMPLETABLE_ENABLED = 1;</code>
     */
    COMPLETABLE_ENABLED(1),
    /**
     *
     *
     * <pre>
     * Completable option disabled for a schema field.
     * </pre>
     *
     * <code>COMPLETABLE_DISABLED = 2;</code>
     */
    COMPLETABLE_DISABLED(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Value used when unset.
     * </pre>
     *
     * <code>COMPLETABLE_OPTION_UNSPECIFIED = 0;</code>
     */
    public static final int COMPLETABLE_OPTION_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Completable option enabled for a schema field.
     * </pre>
     *
     * <code>COMPLETABLE_ENABLED = 1;</code>
     */
    public static final int COMPLETABLE_ENABLED_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Completable option disabled for a schema field.
     * </pre>
     *
     * <code>COMPLETABLE_DISABLED = 2;</code>
     */
    public static final int COMPLETABLE_DISABLED_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static CompletableOption valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static CompletableOption forNumber(int value) {
      switch (value) {
        case 0:
          return COMPLETABLE_OPTION_UNSPECIFIED;
        case 1:
          return COMPLETABLE_ENABLED;
        case 2:
          return COMPLETABLE_DISABLED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<CompletableOption>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<CompletableOption>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<CompletableOption>() {
              public CompletableOption findValueByNumber(int number) {
                return CompletableOption.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1alpha.FieldConfig.getDescriptor()
          .getEnumTypes()
          .get(5);
    }

    private static final CompletableOption[] VALUES = values();

    public static CompletableOption valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private CompletableOption(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.discoveryengine.v1alpha.FieldConfig.CompletableOption)
  }

  /**
   *
   *
   * <pre>
   * Sets the filterable option for schema fields.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.discoveryengine.v1alpha.FieldConfig.FilterableOption}
   */
  public enum FilterableOption implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Value used when unset.
     * </pre>
     *
     * <code>FILTERABLE_OPTION_UNSPECIFIED = 0;</code>
     */
    FILTERABLE_OPTION_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Filterable option enabled for a schema field.
     * </pre>
     *
     * <code>FILTERABLE_ENABLED = 1;</code>
     */
    FILTERABLE_ENABLED(1),
    /**
     *
     *
     * <pre>
     * Filterable option disabled for a schema field.
     * </pre>
     *
     * <code>FILTERABLE_DISABLED = 2;</code>
     */
    FILTERABLE_DISABLED(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Value used when unset.
     * </pre>
     *
     * <code>FILTERABLE_OPTION_UNSPECIFIED = 0;</code>
     */
    public static final int FILTERABLE_OPTION_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Filterable option enabled for a schema field.
     * </pre>
     *
     * <code>FILTERABLE_ENABLED = 1;</code>
     */
    public static final int FILTERABLE_ENABLED_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Filterable option disabled for a schema field.
     * </pre>
     *
     * <code>FILTERABLE_DISABLED = 2;</code>
     */
    public static final int FILTERABLE_DISABLED_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static FilterableOption valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static FilterableOption forNumber(int value) {
      switch (value) {
        case 0:
          return FILTERABLE_OPTION_UNSPECIFIED;
        case 1:
          return FILTERABLE_ENABLED;
        case 2:
          return FILTERABLE_DISABLED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<FilterableOption> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<FilterableOption>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<FilterableOption>() {
              public FilterableOption findValueByNumber(int number) {
                return FilterableOption.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1alpha.FieldConfig.getDescriptor()
          .getEnumTypes()
          .get(6);
    }

    private static final FilterableOption[] VALUES = values();

    public static FilterableOption valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private FilterableOption(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.discoveryengine.v1alpha.FieldConfig.FilterableOption)
  }

  /**
   *
   *
   * <pre>
   * Optional source of the advanced site search field.
   * </pre>
   *
   * Protobuf enum {@code
   * google.cloud.discoveryengine.v1alpha.FieldConfig.AdvancedSiteSearchDataSource}
   */
  public enum AdvancedSiteSearchDataSource implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Value used when unset.
     * </pre>
     *
     * <code>ADVANCED_SITE_SEARCH_DATA_SOURCE_UNSPECIFIED = 0;</code>
     */
    ADVANCED_SITE_SEARCH_DATA_SOURCE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Retrieve value from meta tag.
     * </pre>
     *
     * <code>METATAGS = 1;</code>
     */
    METATAGS(1),
    /**
     *
     *
     * <pre>
     * Retrieve value from page map.
     * </pre>
     *
     * <code>PAGEMAP = 2;</code>
     */
    PAGEMAP(2),
    /**
     *
     *
     * <pre>
     * Retrieve value from the attributes set by
     * [SiteSearchEngineService.SetUriPatternDocumentData][google.cloud.discoveryengine.v1alpha.SiteSearchEngineService.SetUriPatternDocumentData]
     * API.
     * </pre>
     *
     * <code>URI_PATTERN_MAPPING = 3;</code>
     */
    URI_PATTERN_MAPPING(3),
    /**
     *
     *
     * <pre>
     * Retrieve value from schema.org data.
     * </pre>
     *
     * <code>SCHEMA_ORG = 4;</code>
     */
    SCHEMA_ORG(4),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Value used when unset.
     * </pre>
     *
     * <code>ADVANCED_SITE_SEARCH_DATA_SOURCE_UNSPECIFIED = 0;</code>
     */
    public static final int ADVANCED_SITE_SEARCH_DATA_SOURCE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Retrieve value from meta tag.
     * </pre>
     *
     * <code>METATAGS = 1;</code>
     */
    public static final int METATAGS_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Retrieve value from page map.
     * </pre>
     *
     * <code>PAGEMAP = 2;</code>
     */
    public static final int PAGEMAP_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Retrieve value from the attributes set by
     * [SiteSearchEngineService.SetUriPatternDocumentData][google.cloud.discoveryengine.v1alpha.SiteSearchEngineService.SetUriPatternDocumentData]
     * API.
     * </pre>
     *
     * <code>URI_PATTERN_MAPPING = 3;</code>
     */
    public static final int URI_PATTERN_MAPPING_VALUE = 3;
    /**
     *
     *
     * <pre>
     * Retrieve value from schema.org data.
     * </pre>
     *
     * <code>SCHEMA_ORG = 4;</code>
     */
    public static final int SCHEMA_ORG_VALUE = 4;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static AdvancedSiteSearchDataSource valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static AdvancedSiteSearchDataSource forNumber(int value) {
      switch (value) {
        case 0:
          return ADVANCED_SITE_SEARCH_DATA_SOURCE_UNSPECIFIED;
        case 1:
          return METATAGS;
        case 2:
          return PAGEMAP;
        case 3:
          return URI_PATTERN_MAPPING;
        case 4:
          return SCHEMA_ORG;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<AdvancedSiteSearchDataSource>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<AdvancedSiteSearchDataSource>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<AdvancedSiteSearchDataSource>() {
              public AdvancedSiteSearchDataSource findValueByNumber(int number) {
                return AdvancedSiteSearchDataSource.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1alpha.FieldConfig.getDescriptor()
          .getEnumTypes()
          .get(7);
    }

    private static final AdvancedSiteSearchDataSource[] VALUES = values();

    public static AdvancedSiteSearchDataSource valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private AdvancedSiteSearchDataSource(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.discoveryengine.v1alpha.FieldConfig.AdvancedSiteSearchDataSource)
  }

  public static final int FIELD_PATH_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object fieldPath_ = "";
  /**
   *
   *
   * <pre>
   * Required. Field path of the schema field.
   * For example: `title`, `description`, `release_info.release_year`.
   * </pre>
   *
   * <code>string field_path = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The fieldPath.
   */
  @java.lang.Override
  public java.lang.String getFieldPath() {
    java.lang.Object ref = fieldPath_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      fieldPath_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Field path of the schema field.
   * For example: `title`, `description`, `release_info.release_year`.
   * </pre>
   *
   * <code>string field_path = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for fieldPath.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFieldPathBytes() {
    java.lang.Object ref = fieldPath_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      fieldPath_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FIELD_TYPE_FIELD_NUMBER = 2;
  private int fieldType_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. Raw type of the field.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1alpha.FieldConfig.FieldType field_type = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for fieldType.
   */
  @java.lang.Override
  public int getFieldTypeValue() {
    return fieldType_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Raw type of the field.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1alpha.FieldConfig.FieldType field_type = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The fieldType.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1alpha.FieldConfig.FieldType getFieldType() {
    com.google.cloud.discoveryengine.v1alpha.FieldConfig.FieldType result =
        com.google.cloud.discoveryengine.v1alpha.FieldConfig.FieldType.forNumber(fieldType_);
    return result == null
        ? com.google.cloud.discoveryengine.v1alpha.FieldConfig.FieldType.UNRECOGNIZED
        : result;
  }

  public static final int INDEXABLE_OPTION_FIELD_NUMBER = 3;
  private int indexableOption_ = 0;
  /**
   *
   *
   * <pre>
   * If
   * [indexable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.indexable_option]
   * is
   * [INDEXABLE_ENABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.IndexableOption.INDEXABLE_ENABLED],
   * field values are indexed so that it can be filtered or faceted in
   * [SearchService.Search][google.cloud.discoveryengine.v1alpha.SearchService.Search].
   *
   * If
   * [indexable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.indexable_option]
   * is unset, the server behavior defaults to
   * [INDEXABLE_DISABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.IndexableOption.INDEXABLE_DISABLED]
   * for fields that support setting indexable options. For those fields that do
   * not support setting indexable options, such as `object` and `boolean` and
   * key properties, the server will skip
   * [indexable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.indexable_option]
   * setting, and setting
   * [indexable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.indexable_option]
   * for those fields will throw `INVALID_ARGUMENT` error.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1alpha.FieldConfig.IndexableOption indexable_option = 3;
   * </code>
   *
   * @return The enum numeric value on the wire for indexableOption.
   */
  @java.lang.Override
  public int getIndexableOptionValue() {
    return indexableOption_;
  }
  /**
   *
   *
   * <pre>
   * If
   * [indexable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.indexable_option]
   * is
   * [INDEXABLE_ENABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.IndexableOption.INDEXABLE_ENABLED],
   * field values are indexed so that it can be filtered or faceted in
   * [SearchService.Search][google.cloud.discoveryengine.v1alpha.SearchService.Search].
   *
   * If
   * [indexable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.indexable_option]
   * is unset, the server behavior defaults to
   * [INDEXABLE_DISABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.IndexableOption.INDEXABLE_DISABLED]
   * for fields that support setting indexable options. For those fields that do
   * not support setting indexable options, such as `object` and `boolean` and
   * key properties, the server will skip
   * [indexable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.indexable_option]
   * setting, and setting
   * [indexable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.indexable_option]
   * for those fields will throw `INVALID_ARGUMENT` error.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1alpha.FieldConfig.IndexableOption indexable_option = 3;
   * </code>
   *
   * @return The indexableOption.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1alpha.FieldConfig.IndexableOption getIndexableOption() {
    com.google.cloud.discoveryengine.v1alpha.FieldConfig.IndexableOption result =
        com.google.cloud.discoveryengine.v1alpha.FieldConfig.IndexableOption.forNumber(
            indexableOption_);
    return result == null
        ? com.google.cloud.discoveryengine.v1alpha.FieldConfig.IndexableOption.UNRECOGNIZED
        : result;
  }

  public static final int DYNAMIC_FACETABLE_OPTION_FIELD_NUMBER = 4;
  private int dynamicFacetableOption_ = 0;
  /**
   *
   *
   * <pre>
   * If
   * [dynamic_facetable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.dynamic_facetable_option]
   * is
   * [DYNAMIC_FACETABLE_ENABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.DynamicFacetableOption.DYNAMIC_FACETABLE_ENABLED],
   * field values are available for dynamic facet. Could only be
   * [DYNAMIC_FACETABLE_DISABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.DynamicFacetableOption.DYNAMIC_FACETABLE_DISABLED]
   * if
   * [FieldConfig.indexable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.indexable_option]
   * is
   * [INDEXABLE_DISABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.IndexableOption.INDEXABLE_DISABLED].
   * Otherwise, an `INVALID_ARGUMENT` error will be returned.
   *
   * If
   * [dynamic_facetable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.dynamic_facetable_option]
   * is unset, the server behavior defaults to
   * [DYNAMIC_FACETABLE_DISABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.DynamicFacetableOption.DYNAMIC_FACETABLE_DISABLED]
   * for fields that support setting dynamic facetable options. For those fields
   * that do not support setting dynamic facetable options, such as `object` and
   * `boolean`, the server will skip dynamic facetable option setting, and
   * setting
   * [dynamic_facetable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.dynamic_facetable_option]
   * for those fields will throw `INVALID_ARGUMENT` error.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1alpha.FieldConfig.DynamicFacetableOption dynamic_facetable_option = 4;
   * </code>
   *
   * @return The enum numeric value on the wire for dynamicFacetableOption.
   */
  @java.lang.Override
  public int getDynamicFacetableOptionValue() {
    return dynamicFacetableOption_;
  }
  /**
   *
   *
   * <pre>
   * If
   * [dynamic_facetable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.dynamic_facetable_option]
   * is
   * [DYNAMIC_FACETABLE_ENABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.DynamicFacetableOption.DYNAMIC_FACETABLE_ENABLED],
   * field values are available for dynamic facet. Could only be
   * [DYNAMIC_FACETABLE_DISABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.DynamicFacetableOption.DYNAMIC_FACETABLE_DISABLED]
   * if
   * [FieldConfig.indexable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.indexable_option]
   * is
   * [INDEXABLE_DISABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.IndexableOption.INDEXABLE_DISABLED].
   * Otherwise, an `INVALID_ARGUMENT` error will be returned.
   *
   * If
   * [dynamic_facetable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.dynamic_facetable_option]
   * is unset, the server behavior defaults to
   * [DYNAMIC_FACETABLE_DISABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.DynamicFacetableOption.DYNAMIC_FACETABLE_DISABLED]
   * for fields that support setting dynamic facetable options. For those fields
   * that do not support setting dynamic facetable options, such as `object` and
   * `boolean`, the server will skip dynamic facetable option setting, and
   * setting
   * [dynamic_facetable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.dynamic_facetable_option]
   * for those fields will throw `INVALID_ARGUMENT` error.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1alpha.FieldConfig.DynamicFacetableOption dynamic_facetable_option = 4;
   * </code>
   *
   * @return The dynamicFacetableOption.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1alpha.FieldConfig.DynamicFacetableOption
      getDynamicFacetableOption() {
    com.google.cloud.discoveryengine.v1alpha.FieldConfig.DynamicFacetableOption result =
        com.google.cloud.discoveryengine.v1alpha.FieldConfig.DynamicFacetableOption.forNumber(
            dynamicFacetableOption_);
    return result == null
        ? com.google.cloud.discoveryengine.v1alpha.FieldConfig.DynamicFacetableOption.UNRECOGNIZED
        : result;
  }

  public static final int SEARCHABLE_OPTION_FIELD_NUMBER = 5;
  private int searchableOption_ = 0;
  /**
   *
   *
   * <pre>
   * If
   * [searchable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.searchable_option]
   * is
   * [SEARCHABLE_ENABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.SearchableOption.SEARCHABLE_ENABLED],
   * field values are searchable by text queries in
   * [SearchService.Search][google.cloud.discoveryengine.v1alpha.SearchService.Search].
   *
   * If
   * [SEARCHABLE_ENABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.SearchableOption.SEARCHABLE_ENABLED]
   * but field type is numerical, field values will not be searchable by text
   * queries in
   * [SearchService.Search][google.cloud.discoveryengine.v1alpha.SearchService.Search],
   * as there are no text values associated to numerical fields.
   *
   * If
   * [searchable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.searchable_option]
   * is unset, the server behavior defaults to
   * [SEARCHABLE_DISABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.SearchableOption.SEARCHABLE_DISABLED]
   * for fields that support setting searchable options. Only `string` fields
   * that have no key property mapping support setting
   * [searchable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.searchable_option].
   *
   * For those fields that do not support setting searchable options, the server
   * will skip searchable option setting, and setting
   * [searchable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.searchable_option]
   * for those fields will throw `INVALID_ARGUMENT` error.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1alpha.FieldConfig.SearchableOption searchable_option = 5;
   * </code>
   *
   * @return The enum numeric value on the wire for searchableOption.
   */
  @java.lang.Override
  public int getSearchableOptionValue() {
    return searchableOption_;
  }
  /**
   *
   *
   * <pre>
   * If
   * [searchable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.searchable_option]
   * is
   * [SEARCHABLE_ENABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.SearchableOption.SEARCHABLE_ENABLED],
   * field values are searchable by text queries in
   * [SearchService.Search][google.cloud.discoveryengine.v1alpha.SearchService.Search].
   *
   * If
   * [SEARCHABLE_ENABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.SearchableOption.SEARCHABLE_ENABLED]
   * but field type is numerical, field values will not be searchable by text
   * queries in
   * [SearchService.Search][google.cloud.discoveryengine.v1alpha.SearchService.Search],
   * as there are no text values associated to numerical fields.
   *
   * If
   * [searchable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.searchable_option]
   * is unset, the server behavior defaults to
   * [SEARCHABLE_DISABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.SearchableOption.SEARCHABLE_DISABLED]
   * for fields that support setting searchable options. Only `string` fields
   * that have no key property mapping support setting
   * [searchable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.searchable_option].
   *
   * For those fields that do not support setting searchable options, the server
   * will skip searchable option setting, and setting
   * [searchable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.searchable_option]
   * for those fields will throw `INVALID_ARGUMENT` error.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1alpha.FieldConfig.SearchableOption searchable_option = 5;
   * </code>
   *
   * @return The searchableOption.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1alpha.FieldConfig.SearchableOption
      getSearchableOption() {
    com.google.cloud.discoveryengine.v1alpha.FieldConfig.SearchableOption result =
        com.google.cloud.discoveryengine.v1alpha.FieldConfig.SearchableOption.forNumber(
            searchableOption_);
    return result == null
        ? com.google.cloud.discoveryengine.v1alpha.FieldConfig.SearchableOption.UNRECOGNIZED
        : result;
  }

  public static final int RETRIEVABLE_OPTION_FIELD_NUMBER = 6;
  private int retrievableOption_ = 0;
  /**
   *
   *
   * <pre>
   * If
   * [retrievable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.retrievable_option]
   * is
   * [RETRIEVABLE_ENABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.RetrievableOption.RETRIEVABLE_ENABLED],
   * field values are included in the search results.
   *
   * If
   * [retrievable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.retrievable_option]
   * is unset, the server behavior defaults to
   * [RETRIEVABLE_DISABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.RetrievableOption.RETRIEVABLE_DISABLED]
   * for fields that support setting retrievable options. For those fields
   * that do not support setting retrievable options, such as `object` and
   * `boolean`, the server will skip retrievable option setting, and setting
   * [retrievable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.retrievable_option]
   * for those fields will throw `INVALID_ARGUMENT` error.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1alpha.FieldConfig.RetrievableOption retrievable_option = 6;
   * </code>
   *
   * @return The enum numeric value on the wire for retrievableOption.
   */
  @java.lang.Override
  public int getRetrievableOptionValue() {
    return retrievableOption_;
  }
  /**
   *
   *
   * <pre>
   * If
   * [retrievable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.retrievable_option]
   * is
   * [RETRIEVABLE_ENABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.RetrievableOption.RETRIEVABLE_ENABLED],
   * field values are included in the search results.
   *
   * If
   * [retrievable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.retrievable_option]
   * is unset, the server behavior defaults to
   * [RETRIEVABLE_DISABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.RetrievableOption.RETRIEVABLE_DISABLED]
   * for fields that support setting retrievable options. For those fields
   * that do not support setting retrievable options, such as `object` and
   * `boolean`, the server will skip retrievable option setting, and setting
   * [retrievable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.retrievable_option]
   * for those fields will throw `INVALID_ARGUMENT` error.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1alpha.FieldConfig.RetrievableOption retrievable_option = 6;
   * </code>
   *
   * @return The retrievableOption.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1alpha.FieldConfig.RetrievableOption
      getRetrievableOption() {
    com.google.cloud.discoveryengine.v1alpha.FieldConfig.RetrievableOption result =
        com.google.cloud.discoveryengine.v1alpha.FieldConfig.RetrievableOption.forNumber(
            retrievableOption_);
    return result == null
        ? com.google.cloud.discoveryengine.v1alpha.FieldConfig.RetrievableOption.UNRECOGNIZED
        : result;
  }

  public static final int COMPLETABLE_OPTION_FIELD_NUMBER = 8;
  private int completableOption_ = 0;
  /**
   *
   *
   * <pre>
   * If
   * [completable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.completable_option]
   * is
   * [COMPLETABLE_ENABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.CompletableOption.COMPLETABLE_ENABLED],
   * field values are directly used and returned as suggestions for Autocomplete
   * in
   * [CompletionService.CompleteQuery][google.cloud.discoveryengine.v1alpha.CompletionService.CompleteQuery].
   *
   * If
   * [completable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.completable_option]
   * is unset, the server behavior defaults to
   * [COMPLETABLE_DISABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.CompletableOption.COMPLETABLE_DISABLED]
   * for fields that support setting completable options, which are just
   * `string` fields. For those fields that do not support setting completable
   * options, the server will skip completable option setting, and setting
   * [completable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.completable_option]
   * for those fields will throw `INVALID_ARGUMENT` error.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1alpha.FieldConfig.CompletableOption completable_option = 8;
   * </code>
   *
   * @return The enum numeric value on the wire for completableOption.
   */
  @java.lang.Override
  public int getCompletableOptionValue() {
    return completableOption_;
  }
  /**
   *
   *
   * <pre>
   * If
   * [completable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.completable_option]
   * is
   * [COMPLETABLE_ENABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.CompletableOption.COMPLETABLE_ENABLED],
   * field values are directly used and returned as suggestions for Autocomplete
   * in
   * [CompletionService.CompleteQuery][google.cloud.discoveryengine.v1alpha.CompletionService.CompleteQuery].
   *
   * If
   * [completable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.completable_option]
   * is unset, the server behavior defaults to
   * [COMPLETABLE_DISABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.CompletableOption.COMPLETABLE_DISABLED]
   * for fields that support setting completable options, which are just
   * `string` fields. For those fields that do not support setting completable
   * options, the server will skip completable option setting, and setting
   * [completable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.completable_option]
   * for those fields will throw `INVALID_ARGUMENT` error.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1alpha.FieldConfig.CompletableOption completable_option = 8;
   * </code>
   *
   * @return The completableOption.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1alpha.FieldConfig.CompletableOption
      getCompletableOption() {
    com.google.cloud.discoveryengine.v1alpha.FieldConfig.CompletableOption result =
        com.google.cloud.discoveryengine.v1alpha.FieldConfig.CompletableOption.forNumber(
            completableOption_);
    return result == null
        ? com.google.cloud.discoveryengine.v1alpha.FieldConfig.CompletableOption.UNRECOGNIZED
        : result;
  }

  public static final int RECS_FILTERABLE_OPTION_FIELD_NUMBER = 9;
  private int recsFilterableOption_ = 0;
  /**
   *
   *
   * <pre>
   * If
   * [recs_filterable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.recs_filterable_option]
   * is
   * [FILTERABLE_ENABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.FilterableOption.FILTERABLE_ENABLED],
   * field values are filterable by filter expression in
   * [RecommendationService.Recommend][google.cloud.discoveryengine.v1alpha.RecommendationService.Recommend].
   *
   * If
   * [FILTERABLE_ENABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.FilterableOption.FILTERABLE_ENABLED]
   * but the field type is numerical, field values are not filterable by text
   * queries in
   * [RecommendationService.Recommend][google.cloud.discoveryengine.v1alpha.RecommendationService.Recommend].
   * Only textual fields are supported.
   *
   * If
   * [recs_filterable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.recs_filterable_option]
   * is unset, the default setting is
   * [FILTERABLE_DISABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.FilterableOption.FILTERABLE_DISABLED]
   * for fields that support setting filterable options.
   *
   * When a field set to [FILTERABLE_DISABLED] is filtered, a warning is
   * generated and an empty result is returned.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1alpha.FieldConfig.FilterableOption recs_filterable_option = 9;
   * </code>
   *
   * @return The enum numeric value on the wire for recsFilterableOption.
   */
  @java.lang.Override
  public int getRecsFilterableOptionValue() {
    return recsFilterableOption_;
  }
  /**
   *
   *
   * <pre>
   * If
   * [recs_filterable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.recs_filterable_option]
   * is
   * [FILTERABLE_ENABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.FilterableOption.FILTERABLE_ENABLED],
   * field values are filterable by filter expression in
   * [RecommendationService.Recommend][google.cloud.discoveryengine.v1alpha.RecommendationService.Recommend].
   *
   * If
   * [FILTERABLE_ENABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.FilterableOption.FILTERABLE_ENABLED]
   * but the field type is numerical, field values are not filterable by text
   * queries in
   * [RecommendationService.Recommend][google.cloud.discoveryengine.v1alpha.RecommendationService.Recommend].
   * Only textual fields are supported.
   *
   * If
   * [recs_filterable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.recs_filterable_option]
   * is unset, the default setting is
   * [FILTERABLE_DISABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.FilterableOption.FILTERABLE_DISABLED]
   * for fields that support setting filterable options.
   *
   * When a field set to [FILTERABLE_DISABLED] is filtered, a warning is
   * generated and an empty result is returned.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1alpha.FieldConfig.FilterableOption recs_filterable_option = 9;
   * </code>
   *
   * @return The recsFilterableOption.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1alpha.FieldConfig.FilterableOption
      getRecsFilterableOption() {
    com.google.cloud.discoveryengine.v1alpha.FieldConfig.FilterableOption result =
        com.google.cloud.discoveryengine.v1alpha.FieldConfig.FilterableOption.forNumber(
            recsFilterableOption_);
    return result == null
        ? com.google.cloud.discoveryengine.v1alpha.FieldConfig.FilterableOption.UNRECOGNIZED
        : result;
  }

  public static final int KEY_PROPERTY_TYPE_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private volatile java.lang.Object keyPropertyType_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Type of the key property that this field is mapped to. Empty
   * string if this is not annotated as mapped to a key property.
   *
   * Example types are `title`, `description`. Full list is defined
   * by `keyPropertyMapping` in the schema field annotation.
   *
   * If the schema field has a `KeyPropertyMapping` annotation,
   * `indexable_option` and `searchable_option` of this field cannot be
   * modified.
   * </pre>
   *
   * <code>string key_property_type = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The keyPropertyType.
   */
  @java.lang.Override
  public java.lang.String getKeyPropertyType() {
    java.lang.Object ref = keyPropertyType_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      keyPropertyType_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Type of the key property that this field is mapped to. Empty
   * string if this is not annotated as mapped to a key property.
   *
   * Example types are `title`, `description`. Full list is defined
   * by `keyPropertyMapping` in the schema field annotation.
   *
   * If the schema field has a `KeyPropertyMapping` annotation,
   * `indexable_option` and `searchable_option` of this field cannot be
   * modified.
   * </pre>
   *
   * <code>string key_property_type = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for keyPropertyType.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getKeyPropertyTypeBytes() {
    java.lang.Object ref = keyPropertyType_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      keyPropertyType_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ADVANCED_SITE_SEARCH_DATA_SOURCES_FIELD_NUMBER = 10;

  @SuppressWarnings("serial")
  private java.util.List<java.lang.Integer> advancedSiteSearchDataSources_;

  private static final com.google.protobuf.Internal.ListAdapter.Converter<
          java.lang.Integer,
          com.google.cloud.discoveryengine.v1alpha.FieldConfig.AdvancedSiteSearchDataSource>
      advancedSiteSearchDataSources_converter_ =
          new com.google.protobuf.Internal.ListAdapter.Converter<
              java.lang.Integer,
              com.google.cloud.discoveryengine.v1alpha.FieldConfig.AdvancedSiteSearchDataSource>() {
            public com.google.cloud.discoveryengine.v1alpha.FieldConfig.AdvancedSiteSearchDataSource
                convert(java.lang.Integer from) {
              com.google.cloud.discoveryengine.v1alpha.FieldConfig.AdvancedSiteSearchDataSource
                  result =
                      com.google.cloud.discoveryengine.v1alpha.FieldConfig
                          .AdvancedSiteSearchDataSource.forNumber(from);
              return result == null
                  ? com.google.cloud.discoveryengine.v1alpha.FieldConfig
                      .AdvancedSiteSearchDataSource.UNRECOGNIZED
                  : result;
            }
          };
  /**
   *
   *
   * <pre>
   * If this field is set, only the corresponding source will be indexed for
   * this field. Otherwise, the values from different sources are merged.
   *
   * Assuming a page with `&lt;author, a&gt;` in meta tag, and `&lt;author, b&gt;` in page
   * map:
   *  if this enum is set to METATAGS, we will only index `&lt;author, a&gt;`;
   *  if this enum is not set, we will merge them and index `&lt;author, [a, b]&gt;`.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.discoveryengine.v1alpha.FieldConfig.AdvancedSiteSearchDataSource advanced_site_search_data_sources = 10;
   * </code>
   *
   * @return A list containing the advancedSiteSearchDataSources.
   */
  @java.lang.Override
  public java.util.List<
          com.google.cloud.discoveryengine.v1alpha.FieldConfig.AdvancedSiteSearchDataSource>
      getAdvancedSiteSearchDataSourcesList() {
    return new com.google.protobuf.Internal.ListAdapter<
        java.lang.Integer,
        com.google.cloud.discoveryengine.v1alpha.FieldConfig.AdvancedSiteSearchDataSource>(
        advancedSiteSearchDataSources_, advancedSiteSearchDataSources_converter_);
  }
  /**
   *
   *
   * <pre>
   * If this field is set, only the corresponding source will be indexed for
   * this field. Otherwise, the values from different sources are merged.
   *
   * Assuming a page with `&lt;author, a&gt;` in meta tag, and `&lt;author, b&gt;` in page
   * map:
   *  if this enum is set to METATAGS, we will only index `&lt;author, a&gt;`;
   *  if this enum is not set, we will merge them and index `&lt;author, [a, b]&gt;`.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.discoveryengine.v1alpha.FieldConfig.AdvancedSiteSearchDataSource advanced_site_search_data_sources = 10;
   * </code>
   *
   * @return The count of advancedSiteSearchDataSources.
   */
  @java.lang.Override
  public int getAdvancedSiteSearchDataSourcesCount() {
    return advancedSiteSearchDataSources_.size();
  }
  /**
   *
   *
   * <pre>
   * If this field is set, only the corresponding source will be indexed for
   * this field. Otherwise, the values from different sources are merged.
   *
   * Assuming a page with `&lt;author, a&gt;` in meta tag, and `&lt;author, b&gt;` in page
   * map:
   *  if this enum is set to METATAGS, we will only index `&lt;author, a&gt;`;
   *  if this enum is not set, we will merge them and index `&lt;author, [a, b]&gt;`.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.discoveryengine.v1alpha.FieldConfig.AdvancedSiteSearchDataSource advanced_site_search_data_sources = 10;
   * </code>
   *
   * @param index The index of the element to return.
   * @return The advancedSiteSearchDataSources at the given index.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1alpha.FieldConfig.AdvancedSiteSearchDataSource
      getAdvancedSiteSearchDataSources(int index) {
    return advancedSiteSearchDataSources_converter_.convert(
        advancedSiteSearchDataSources_.get(index));
  }
  /**
   *
   *
   * <pre>
   * If this field is set, only the corresponding source will be indexed for
   * this field. Otherwise, the values from different sources are merged.
   *
   * Assuming a page with `&lt;author, a&gt;` in meta tag, and `&lt;author, b&gt;` in page
   * map:
   *  if this enum is set to METATAGS, we will only index `&lt;author, a&gt;`;
   *  if this enum is not set, we will merge them and index `&lt;author, [a, b]&gt;`.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.discoveryengine.v1alpha.FieldConfig.AdvancedSiteSearchDataSource advanced_site_search_data_sources = 10;
   * </code>
   *
   * @return A list containing the enum numeric values on the wire for
   *     advancedSiteSearchDataSources.
   */
  @java.lang.Override
  public java.util.List<java.lang.Integer> getAdvancedSiteSearchDataSourcesValueList() {
    return advancedSiteSearchDataSources_;
  }
  /**
   *
   *
   * <pre>
   * If this field is set, only the corresponding source will be indexed for
   * this field. Otherwise, the values from different sources are merged.
   *
   * Assuming a page with `&lt;author, a&gt;` in meta tag, and `&lt;author, b&gt;` in page
   * map:
   *  if this enum is set to METATAGS, we will only index `&lt;author, a&gt;`;
   *  if this enum is not set, we will merge them and index `&lt;author, [a, b]&gt;`.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.discoveryengine.v1alpha.FieldConfig.AdvancedSiteSearchDataSource advanced_site_search_data_sources = 10;
   * </code>
   *
   * @param index The index of the value to return.
   * @return The enum numeric value on the wire of advancedSiteSearchDataSources at the given index.
   */
  @java.lang.Override
  public int getAdvancedSiteSearchDataSourcesValue(int index) {
    return advancedSiteSearchDataSources_.get(index);
  }

  private int advancedSiteSearchDataSourcesMemoizedSerializedSize;

  public static final int SCHEMA_ORG_PATHS_FIELD_NUMBER = 11;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList schemaOrgPaths_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Field paths for indexing custom attribute from schema.org data. More
   * details of schema.org and its defined types can be found at
   * [schema.org](https://schema.org).
   *
   * It is only used on advanced site search schema.
   *
   * Currently only support full path from root. The full path to a field is
   * constructed by concatenating field names, starting from `_root`, with
   * a period `.` as the delimiter. Examples:
   *
   * * Publish date of the root: _root.datePublished
   * * Publish date of the reviews: _root.review.datePublished
   * </pre>
   *
   * <code>repeated string schema_org_paths = 11;</code>
   *
   * @return A list containing the schemaOrgPaths.
   */
  public com.google.protobuf.ProtocolStringList getSchemaOrgPathsList() {
    return schemaOrgPaths_;
  }
  /**
   *
   *
   * <pre>
   * Field paths for indexing custom attribute from schema.org data. More
   * details of schema.org and its defined types can be found at
   * [schema.org](https://schema.org).
   *
   * It is only used on advanced site search schema.
   *
   * Currently only support full path from root. The full path to a field is
   * constructed by concatenating field names, starting from `_root`, with
   * a period `.` as the delimiter. Examples:
   *
   * * Publish date of the root: _root.datePublished
   * * Publish date of the reviews: _root.review.datePublished
   * </pre>
   *
   * <code>repeated string schema_org_paths = 11;</code>
   *
   * @return The count of schemaOrgPaths.
   */
  public int getSchemaOrgPathsCount() {
    return schemaOrgPaths_.size();
  }
  /**
   *
   *
   * <pre>
   * Field paths for indexing custom attribute from schema.org data. More
   * details of schema.org and its defined types can be found at
   * [schema.org](https://schema.org).
   *
   * It is only used on advanced site search schema.
   *
   * Currently only support full path from root. The full path to a field is
   * constructed by concatenating field names, starting from `_root`, with
   * a period `.` as the delimiter. Examples:
   *
   * * Publish date of the root: _root.datePublished
   * * Publish date of the reviews: _root.review.datePublished
   * </pre>
   *
   * <code>repeated string schema_org_paths = 11;</code>
   *
   * @param index The index of the element to return.
   * @return The schemaOrgPaths at the given index.
   */
  public java.lang.String getSchemaOrgPaths(int index) {
    return schemaOrgPaths_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Field paths for indexing custom attribute from schema.org data. More
   * details of schema.org and its defined types can be found at
   * [schema.org](https://schema.org).
   *
   * It is only used on advanced site search schema.
   *
   * Currently only support full path from root. The full path to a field is
   * constructed by concatenating field names, starting from `_root`, with
   * a period `.` as the delimiter. Examples:
   *
   * * Publish date of the root: _root.datePublished
   * * Publish date of the reviews: _root.review.datePublished
   * </pre>
   *
   * <code>repeated string schema_org_paths = 11;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the schemaOrgPaths at the given index.
   */
  public com.google.protobuf.ByteString getSchemaOrgPathsBytes(int index) {
    return schemaOrgPaths_.getByteString(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    getSerializedSize();
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(fieldPath_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, fieldPath_);
    }
    if (fieldType_
        != com.google.cloud.discoveryengine.v1alpha.FieldConfig.FieldType.FIELD_TYPE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(2, fieldType_);
    }
    if (indexableOption_
        != com.google.cloud.discoveryengine.v1alpha.FieldConfig.IndexableOption
            .INDEXABLE_OPTION_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(3, indexableOption_);
    }
    if (dynamicFacetableOption_
        != com.google.cloud.discoveryengine.v1alpha.FieldConfig.DynamicFacetableOption
            .DYNAMIC_FACETABLE_OPTION_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(4, dynamicFacetableOption_);
    }
    if (searchableOption_
        != com.google.cloud.discoveryengine.v1alpha.FieldConfig.SearchableOption
            .SEARCHABLE_OPTION_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(5, searchableOption_);
    }
    if (retrievableOption_
        != com.google.cloud.discoveryengine.v1alpha.FieldConfig.RetrievableOption
            .RETRIEVABLE_OPTION_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(6, retrievableOption_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(keyPropertyType_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, keyPropertyType_);
    }
    if (completableOption_
        != com.google.cloud.discoveryengine.v1alpha.FieldConfig.CompletableOption
            .COMPLETABLE_OPTION_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(8, completableOption_);
    }
    if (recsFilterableOption_
        != com.google.cloud.discoveryengine.v1alpha.FieldConfig.FilterableOption
            .FILTERABLE_OPTION_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(9, recsFilterableOption_);
    }
    if (getAdvancedSiteSearchDataSourcesList().size() > 0) {
      output.writeUInt32NoTag(82);
      output.writeUInt32NoTag(advancedSiteSearchDataSourcesMemoizedSerializedSize);
    }
    for (int i = 0; i < advancedSiteSearchDataSources_.size(); i++) {
      output.writeEnumNoTag(advancedSiteSearchDataSources_.get(i));
    }
    for (int i = 0; i < schemaOrgPaths_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 11, schemaOrgPaths_.getRaw(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(fieldPath_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, fieldPath_);
    }
    if (fieldType_
        != com.google.cloud.discoveryengine.v1alpha.FieldConfig.FieldType.FIELD_TYPE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, fieldType_);
    }
    if (indexableOption_
        != com.google.cloud.discoveryengine.v1alpha.FieldConfig.IndexableOption
            .INDEXABLE_OPTION_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, indexableOption_);
    }
    if (dynamicFacetableOption_
        != com.google.cloud.discoveryengine.v1alpha.FieldConfig.DynamicFacetableOption
            .DYNAMIC_FACETABLE_OPTION_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, dynamicFacetableOption_);
    }
    if (searchableOption_
        != com.google.cloud.discoveryengine.v1alpha.FieldConfig.SearchableOption
            .SEARCHABLE_OPTION_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(5, searchableOption_);
    }
    if (retrievableOption_
        != com.google.cloud.discoveryengine.v1alpha.FieldConfig.RetrievableOption
            .RETRIEVABLE_OPTION_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(6, retrievableOption_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(keyPropertyType_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, keyPropertyType_);
    }
    if (completableOption_
        != com.google.cloud.discoveryengine.v1alpha.FieldConfig.CompletableOption
            .COMPLETABLE_OPTION_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(8, completableOption_);
    }
    if (recsFilterableOption_
        != com.google.cloud.discoveryengine.v1alpha.FieldConfig.FilterableOption
            .FILTERABLE_OPTION_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(9, recsFilterableOption_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < advancedSiteSearchDataSources_.size(); i++) {
        dataSize +=
            com.google.protobuf.CodedOutputStream.computeEnumSizeNoTag(
                advancedSiteSearchDataSources_.get(i));
      }
      size += dataSize;
      if (!getAdvancedSiteSearchDataSourcesList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(dataSize);
      }
      advancedSiteSearchDataSourcesMemoizedSerializedSize = dataSize;
    }
    {
      int dataSize = 0;
      for (int i = 0; i < schemaOrgPaths_.size(); i++) {
        dataSize += computeStringSizeNoTag(schemaOrgPaths_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getSchemaOrgPathsList().size();
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.discoveryengine.v1alpha.FieldConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.discoveryengine.v1alpha.FieldConfig other =
        (com.google.cloud.discoveryengine.v1alpha.FieldConfig) obj;

    if (!getFieldPath().equals(other.getFieldPath())) return false;
    if (fieldType_ != other.fieldType_) return false;
    if (indexableOption_ != other.indexableOption_) return false;
    if (dynamicFacetableOption_ != other.dynamicFacetableOption_) return false;
    if (searchableOption_ != other.searchableOption_) return false;
    if (retrievableOption_ != other.retrievableOption_) return false;
    if (completableOption_ != other.completableOption_) return false;
    if (recsFilterableOption_ != other.recsFilterableOption_) return false;
    if (!getKeyPropertyType().equals(other.getKeyPropertyType())) return false;
    if (!advancedSiteSearchDataSources_.equals(other.advancedSiteSearchDataSources_)) return false;
    if (!getSchemaOrgPathsList().equals(other.getSchemaOrgPathsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + FIELD_PATH_FIELD_NUMBER;
    hash = (53 * hash) + getFieldPath().hashCode();
    hash = (37 * hash) + FIELD_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + fieldType_;
    hash = (37 * hash) + INDEXABLE_OPTION_FIELD_NUMBER;
    hash = (53 * hash) + indexableOption_;
    hash = (37 * hash) + DYNAMIC_FACETABLE_OPTION_FIELD_NUMBER;
    hash = (53 * hash) + dynamicFacetableOption_;
    hash = (37 * hash) + SEARCHABLE_OPTION_FIELD_NUMBER;
    hash = (53 * hash) + searchableOption_;
    hash = (37 * hash) + RETRIEVABLE_OPTION_FIELD_NUMBER;
    hash = (53 * hash) + retrievableOption_;
    hash = (37 * hash) + COMPLETABLE_OPTION_FIELD_NUMBER;
    hash = (53 * hash) + completableOption_;
    hash = (37 * hash) + RECS_FILTERABLE_OPTION_FIELD_NUMBER;
    hash = (53 * hash) + recsFilterableOption_;
    hash = (37 * hash) + KEY_PROPERTY_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + getKeyPropertyType().hashCode();
    if (getAdvancedSiteSearchDataSourcesCount() > 0) {
      hash = (37 * hash) + ADVANCED_SITE_SEARCH_DATA_SOURCES_FIELD_NUMBER;
      hash = (53 * hash) + advancedSiteSearchDataSources_.hashCode();
    }
    if (getSchemaOrgPathsCount() > 0) {
      hash = (37 * hash) + SCHEMA_ORG_PATHS_FIELD_NUMBER;
      hash = (53 * hash) + getSchemaOrgPathsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.discoveryengine.v1alpha.FieldConfig parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1alpha.FieldConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1alpha.FieldConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1alpha.FieldConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1alpha.FieldConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1alpha.FieldConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1alpha.FieldConfig parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1alpha.FieldConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1alpha.FieldConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1alpha.FieldConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1alpha.FieldConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1alpha.FieldConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.discoveryengine.v1alpha.FieldConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Configurations for fields of a schema. For example, configuring a field is
   * indexable, or searchable.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1alpha.FieldConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1alpha.FieldConfig)
      com.google.cloud.discoveryengine.v1alpha.FieldConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1alpha.SchemaProto
          .internal_static_google_cloud_discoveryengine_v1alpha_FieldConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1alpha.SchemaProto
          .internal_static_google_cloud_discoveryengine_v1alpha_FieldConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1alpha.FieldConfig.class,
              com.google.cloud.discoveryengine.v1alpha.FieldConfig.Builder.class);
    }

    // Construct using com.google.cloud.discoveryengine.v1alpha.FieldConfig.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      fieldPath_ = "";
      fieldType_ = 0;
      indexableOption_ = 0;
      dynamicFacetableOption_ = 0;
      searchableOption_ = 0;
      retrievableOption_ = 0;
      completableOption_ = 0;
      recsFilterableOption_ = 0;
      keyPropertyType_ = "";
      advancedSiteSearchDataSources_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000200);
      schemaOrgPaths_ = com.google.protobuf.LazyStringArrayList.emptyList();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.discoveryengine.v1alpha.SchemaProto
          .internal_static_google_cloud_discoveryengine_v1alpha_FieldConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1alpha.FieldConfig getDefaultInstanceForType() {
      return com.google.cloud.discoveryengine.v1alpha.FieldConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1alpha.FieldConfig build() {
      com.google.cloud.discoveryengine.v1alpha.FieldConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1alpha.FieldConfig buildPartial() {
      com.google.cloud.discoveryengine.v1alpha.FieldConfig result =
          new com.google.cloud.discoveryengine.v1alpha.FieldConfig(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.discoveryengine.v1alpha.FieldConfig result) {
      if (((bitField0_ & 0x00000200) != 0)) {
        advancedSiteSearchDataSources_ =
            java.util.Collections.unmodifiableList(advancedSiteSearchDataSources_);
        bitField0_ = (bitField0_ & ~0x00000200);
      }
      result.advancedSiteSearchDataSources_ = advancedSiteSearchDataSources_;
    }

    private void buildPartial0(com.google.cloud.discoveryengine.v1alpha.FieldConfig result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.fieldPath_ = fieldPath_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.fieldType_ = fieldType_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.indexableOption_ = indexableOption_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.dynamicFacetableOption_ = dynamicFacetableOption_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.searchableOption_ = searchableOption_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.retrievableOption_ = retrievableOption_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.completableOption_ = completableOption_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.recsFilterableOption_ = recsFilterableOption_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.keyPropertyType_ = keyPropertyType_;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        schemaOrgPaths_.makeImmutable();
        result.schemaOrgPaths_ = schemaOrgPaths_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.discoveryengine.v1alpha.FieldConfig) {
        return mergeFrom((com.google.cloud.discoveryengine.v1alpha.FieldConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.discoveryengine.v1alpha.FieldConfig other) {
      if (other == com.google.cloud.discoveryengine.v1alpha.FieldConfig.getDefaultInstance())
        return this;
      if (!other.getFieldPath().isEmpty()) {
        fieldPath_ = other.fieldPath_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.fieldType_ != 0) {
        setFieldTypeValue(other.getFieldTypeValue());
      }
      if (other.indexableOption_ != 0) {
        setIndexableOptionValue(other.getIndexableOptionValue());
      }
      if (other.dynamicFacetableOption_ != 0) {
        setDynamicFacetableOptionValue(other.getDynamicFacetableOptionValue());
      }
      if (other.searchableOption_ != 0) {
        setSearchableOptionValue(other.getSearchableOptionValue());
      }
      if (other.retrievableOption_ != 0) {
        setRetrievableOptionValue(other.getRetrievableOptionValue());
      }
      if (other.completableOption_ != 0) {
        setCompletableOptionValue(other.getCompletableOptionValue());
      }
      if (other.recsFilterableOption_ != 0) {
        setRecsFilterableOptionValue(other.getRecsFilterableOptionValue());
      }
      if (!other.getKeyPropertyType().isEmpty()) {
        keyPropertyType_ = other.keyPropertyType_;
        bitField0_ |= 0x00000100;
        onChanged();
      }
      if (!other.advancedSiteSearchDataSources_.isEmpty()) {
        if (advancedSiteSearchDataSources_.isEmpty()) {
          advancedSiteSearchDataSources_ = other.advancedSiteSearchDataSources_;
          bitField0_ = (bitField0_ & ~0x00000200);
        } else {
          ensureAdvancedSiteSearchDataSourcesIsMutable();
          advancedSiteSearchDataSources_.addAll(other.advancedSiteSearchDataSources_);
        }
        onChanged();
      }
      if (!other.schemaOrgPaths_.isEmpty()) {
        if (schemaOrgPaths_.isEmpty()) {
          schemaOrgPaths_ = other.schemaOrgPaths_;
          bitField0_ |= 0x00000400;
        } else {
          ensureSchemaOrgPathsIsMutable();
          schemaOrgPaths_.addAll(other.schemaOrgPaths_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                fieldPath_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                fieldType_ = input.readEnum();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 24:
              {
                indexableOption_ = input.readEnum();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 32:
              {
                dynamicFacetableOption_ = input.readEnum();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            case 40:
              {
                searchableOption_ = input.readEnum();
                bitField0_ |= 0x00000010;
                break;
              } // case 40
            case 48:
              {
                retrievableOption_ = input.readEnum();
                bitField0_ |= 0x00000020;
                break;
              } // case 48
            case 58:
              {
                keyPropertyType_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000100;
                break;
              } // case 58
            case 64:
              {
                completableOption_ = input.readEnum();
                bitField0_ |= 0x00000040;
                break;
              } // case 64
            case 72:
              {
                recsFilterableOption_ = input.readEnum();
                bitField0_ |= 0x00000080;
                break;
              } // case 72
            case 80:
              {
                int tmpRaw = input.readEnum();
                ensureAdvancedSiteSearchDataSourcesIsMutable();
                advancedSiteSearchDataSources_.add(tmpRaw);
                break;
              } // case 80
            case 82:
              {
                int length = input.readRawVarint32();
                int oldLimit = input.pushLimit(length);
                while (input.getBytesUntilLimit() > 0) {
                  int tmpRaw = input.readEnum();
                  ensureAdvancedSiteSearchDataSourcesIsMutable();
                  advancedSiteSearchDataSources_.add(tmpRaw);
                }
                input.popLimit(oldLimit);
                break;
              } // case 82
            case 90:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureSchemaOrgPathsIsMutable();
                schemaOrgPaths_.add(s);
                break;
              } // case 90
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object fieldPath_ = "";
    /**
     *
     *
     * <pre>
     * Required. Field path of the schema field.
     * For example: `title`, `description`, `release_info.release_year`.
     * </pre>
     *
     * <code>string field_path = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The fieldPath.
     */
    public java.lang.String getFieldPath() {
      java.lang.Object ref = fieldPath_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        fieldPath_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Field path of the schema field.
     * For example: `title`, `description`, `release_info.release_year`.
     * </pre>
     *
     * <code>string field_path = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for fieldPath.
     */
    public com.google.protobuf.ByteString getFieldPathBytes() {
      java.lang.Object ref = fieldPath_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        fieldPath_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Field path of the schema field.
     * For example: `title`, `description`, `release_info.release_year`.
     * </pre>
     *
     * <code>string field_path = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The fieldPath to set.
     * @return This builder for chaining.
     */
    public Builder setFieldPath(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      fieldPath_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Field path of the schema field.
     * For example: `title`, `description`, `release_info.release_year`.
     * </pre>
     *
     * <code>string field_path = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFieldPath() {
      fieldPath_ = getDefaultInstance().getFieldPath();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Field path of the schema field.
     * For example: `title`, `description`, `release_info.release_year`.
     * </pre>
     *
     * <code>string field_path = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for fieldPath to set.
     * @return This builder for chaining.
     */
    public Builder setFieldPathBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      fieldPath_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private int fieldType_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. Raw type of the field.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1alpha.FieldConfig.FieldType field_type = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for fieldType.
     */
    @java.lang.Override
    public int getFieldTypeValue() {
      return fieldType_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Raw type of the field.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1alpha.FieldConfig.FieldType field_type = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for fieldType to set.
     * @return This builder for chaining.
     */
    public Builder setFieldTypeValue(int value) {
      fieldType_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Raw type of the field.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1alpha.FieldConfig.FieldType field_type = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The fieldType.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1alpha.FieldConfig.FieldType getFieldType() {
      com.google.cloud.discoveryengine.v1alpha.FieldConfig.FieldType result =
          com.google.cloud.discoveryengine.v1alpha.FieldConfig.FieldType.forNumber(fieldType_);
      return result == null
          ? com.google.cloud.discoveryengine.v1alpha.FieldConfig.FieldType.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. Raw type of the field.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1alpha.FieldConfig.FieldType field_type = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The fieldType to set.
     * @return This builder for chaining.
     */
    public Builder setFieldType(
        com.google.cloud.discoveryengine.v1alpha.FieldConfig.FieldType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000002;
      fieldType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Raw type of the field.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1alpha.FieldConfig.FieldType field_type = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFieldType() {
      bitField0_ = (bitField0_ & ~0x00000002);
      fieldType_ = 0;
      onChanged();
      return this;
    }

    private int indexableOption_ = 0;
    /**
     *
     *
     * <pre>
     * If
     * [indexable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.indexable_option]
     * is
     * [INDEXABLE_ENABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.IndexableOption.INDEXABLE_ENABLED],
     * field values are indexed so that it can be filtered or faceted in
     * [SearchService.Search][google.cloud.discoveryengine.v1alpha.SearchService.Search].
     *
     * If
     * [indexable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.indexable_option]
     * is unset, the server behavior defaults to
     * [INDEXABLE_DISABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.IndexableOption.INDEXABLE_DISABLED]
     * for fields that support setting indexable options. For those fields that do
     * not support setting indexable options, such as `object` and `boolean` and
     * key properties, the server will skip
     * [indexable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.indexable_option]
     * setting, and setting
     * [indexable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.indexable_option]
     * for those fields will throw `INVALID_ARGUMENT` error.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.FieldConfig.IndexableOption indexable_option = 3;
     * </code>
     *
     * @return The enum numeric value on the wire for indexableOption.
     */
    @java.lang.Override
    public int getIndexableOptionValue() {
      return indexableOption_;
    }
    /**
     *
     *
     * <pre>
     * If
     * [indexable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.indexable_option]
     * is
     * [INDEXABLE_ENABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.IndexableOption.INDEXABLE_ENABLED],
     * field values are indexed so that it can be filtered or faceted in
     * [SearchService.Search][google.cloud.discoveryengine.v1alpha.SearchService.Search].
     *
     * If
     * [indexable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.indexable_option]
     * is unset, the server behavior defaults to
     * [INDEXABLE_DISABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.IndexableOption.INDEXABLE_DISABLED]
     * for fields that support setting indexable options. For those fields that do
     * not support setting indexable options, such as `object` and `boolean` and
     * key properties, the server will skip
     * [indexable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.indexable_option]
     * setting, and setting
     * [indexable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.indexable_option]
     * for those fields will throw `INVALID_ARGUMENT` error.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.FieldConfig.IndexableOption indexable_option = 3;
     * </code>
     *
     * @param value The enum numeric value on the wire for indexableOption to set.
     * @return This builder for chaining.
     */
    public Builder setIndexableOptionValue(int value) {
      indexableOption_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If
     * [indexable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.indexable_option]
     * is
     * [INDEXABLE_ENABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.IndexableOption.INDEXABLE_ENABLED],
     * field values are indexed so that it can be filtered or faceted in
     * [SearchService.Search][google.cloud.discoveryengine.v1alpha.SearchService.Search].
     *
     * If
     * [indexable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.indexable_option]
     * is unset, the server behavior defaults to
     * [INDEXABLE_DISABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.IndexableOption.INDEXABLE_DISABLED]
     * for fields that support setting indexable options. For those fields that do
     * not support setting indexable options, such as `object` and `boolean` and
     * key properties, the server will skip
     * [indexable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.indexable_option]
     * setting, and setting
     * [indexable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.indexable_option]
     * for those fields will throw `INVALID_ARGUMENT` error.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.FieldConfig.IndexableOption indexable_option = 3;
     * </code>
     *
     * @return The indexableOption.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1alpha.FieldConfig.IndexableOption
        getIndexableOption() {
      com.google.cloud.discoveryengine.v1alpha.FieldConfig.IndexableOption result =
          com.google.cloud.discoveryengine.v1alpha.FieldConfig.IndexableOption.forNumber(
              indexableOption_);
      return result == null
          ? com.google.cloud.discoveryengine.v1alpha.FieldConfig.IndexableOption.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * If
     * [indexable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.indexable_option]
     * is
     * [INDEXABLE_ENABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.IndexableOption.INDEXABLE_ENABLED],
     * field values are indexed so that it can be filtered or faceted in
     * [SearchService.Search][google.cloud.discoveryengine.v1alpha.SearchService.Search].
     *
     * If
     * [indexable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.indexable_option]
     * is unset, the server behavior defaults to
     * [INDEXABLE_DISABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.IndexableOption.INDEXABLE_DISABLED]
     * for fields that support setting indexable options. For those fields that do
     * not support setting indexable options, such as `object` and `boolean` and
     * key properties, the server will skip
     * [indexable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.indexable_option]
     * setting, and setting
     * [indexable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.indexable_option]
     * for those fields will throw `INVALID_ARGUMENT` error.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.FieldConfig.IndexableOption indexable_option = 3;
     * </code>
     *
     * @param value The indexableOption to set.
     * @return This builder for chaining.
     */
    public Builder setIndexableOption(
        com.google.cloud.discoveryengine.v1alpha.FieldConfig.IndexableOption value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000004;
      indexableOption_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If
     * [indexable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.indexable_option]
     * is
     * [INDEXABLE_ENABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.IndexableOption.INDEXABLE_ENABLED],
     * field values are indexed so that it can be filtered or faceted in
     * [SearchService.Search][google.cloud.discoveryengine.v1alpha.SearchService.Search].
     *
     * If
     * [indexable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.indexable_option]
     * is unset, the server behavior defaults to
     * [INDEXABLE_DISABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.IndexableOption.INDEXABLE_DISABLED]
     * for fields that support setting indexable options. For those fields that do
     * not support setting indexable options, such as `object` and `boolean` and
     * key properties, the server will skip
     * [indexable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.indexable_option]
     * setting, and setting
     * [indexable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.indexable_option]
     * for those fields will throw `INVALID_ARGUMENT` error.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.FieldConfig.IndexableOption indexable_option = 3;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIndexableOption() {
      bitField0_ = (bitField0_ & ~0x00000004);
      indexableOption_ = 0;
      onChanged();
      return this;
    }

    private int dynamicFacetableOption_ = 0;
    /**
     *
     *
     * <pre>
     * If
     * [dynamic_facetable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.dynamic_facetable_option]
     * is
     * [DYNAMIC_FACETABLE_ENABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.DynamicFacetableOption.DYNAMIC_FACETABLE_ENABLED],
     * field values are available for dynamic facet. Could only be
     * [DYNAMIC_FACETABLE_DISABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.DynamicFacetableOption.DYNAMIC_FACETABLE_DISABLED]
     * if
     * [FieldConfig.indexable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.indexable_option]
     * is
     * [INDEXABLE_DISABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.IndexableOption.INDEXABLE_DISABLED].
     * Otherwise, an `INVALID_ARGUMENT` error will be returned.
     *
     * If
     * [dynamic_facetable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.dynamic_facetable_option]
     * is unset, the server behavior defaults to
     * [DYNAMIC_FACETABLE_DISABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.DynamicFacetableOption.DYNAMIC_FACETABLE_DISABLED]
     * for fields that support setting dynamic facetable options. For those fields
     * that do not support setting dynamic facetable options, such as `object` and
     * `boolean`, the server will skip dynamic facetable option setting, and
     * setting
     * [dynamic_facetable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.dynamic_facetable_option]
     * for those fields will throw `INVALID_ARGUMENT` error.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1alpha.FieldConfig.DynamicFacetableOption dynamic_facetable_option = 4;
     * </code>
     *
     * @return The enum numeric value on the wire for dynamicFacetableOption.
     */
    @java.lang.Override
    public int getDynamicFacetableOptionValue() {
      return dynamicFacetableOption_;
    }
    /**
     *
     *
     * <pre>
     * If
     * [dynamic_facetable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.dynamic_facetable_option]
     * is
     * [DYNAMIC_FACETABLE_ENABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.DynamicFacetableOption.DYNAMIC_FACETABLE_ENABLED],
     * field values are available for dynamic facet. Could only be
     * [DYNAMIC_FACETABLE_DISABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.DynamicFacetableOption.DYNAMIC_FACETABLE_DISABLED]
     * if
     * [FieldConfig.indexable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.indexable_option]
     * is
     * [INDEXABLE_DISABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.IndexableOption.INDEXABLE_DISABLED].
     * Otherwise, an `INVALID_ARGUMENT` error will be returned.
     *
     * If
     * [dynamic_facetable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.dynamic_facetable_option]
     * is unset, the server behavior defaults to
     * [DYNAMIC_FACETABLE_DISABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.DynamicFacetableOption.DYNAMIC_FACETABLE_DISABLED]
     * for fields that support setting dynamic facetable options. For those fields
     * that do not support setting dynamic facetable options, such as `object` and
     * `boolean`, the server will skip dynamic facetable option setting, and
     * setting
     * [dynamic_facetable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.dynamic_facetable_option]
     * for those fields will throw `INVALID_ARGUMENT` error.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1alpha.FieldConfig.DynamicFacetableOption dynamic_facetable_option = 4;
     * </code>
     *
     * @param value The enum numeric value on the wire for dynamicFacetableOption to set.
     * @return This builder for chaining.
     */
    public Builder setDynamicFacetableOptionValue(int value) {
      dynamicFacetableOption_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If
     * [dynamic_facetable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.dynamic_facetable_option]
     * is
     * [DYNAMIC_FACETABLE_ENABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.DynamicFacetableOption.DYNAMIC_FACETABLE_ENABLED],
     * field values are available for dynamic facet. Could only be
     * [DYNAMIC_FACETABLE_DISABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.DynamicFacetableOption.DYNAMIC_FACETABLE_DISABLED]
     * if
     * [FieldConfig.indexable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.indexable_option]
     * is
     * [INDEXABLE_DISABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.IndexableOption.INDEXABLE_DISABLED].
     * Otherwise, an `INVALID_ARGUMENT` error will be returned.
     *
     * If
     * [dynamic_facetable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.dynamic_facetable_option]
     * is unset, the server behavior defaults to
     * [DYNAMIC_FACETABLE_DISABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.DynamicFacetableOption.DYNAMIC_FACETABLE_DISABLED]
     * for fields that support setting dynamic facetable options. For those fields
     * that do not support setting dynamic facetable options, such as `object` and
     * `boolean`, the server will skip dynamic facetable option setting, and
     * setting
     * [dynamic_facetable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.dynamic_facetable_option]
     * for those fields will throw `INVALID_ARGUMENT` error.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1alpha.FieldConfig.DynamicFacetableOption dynamic_facetable_option = 4;
     * </code>
     *
     * @return The dynamicFacetableOption.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1alpha.FieldConfig.DynamicFacetableOption
        getDynamicFacetableOption() {
      com.google.cloud.discoveryengine.v1alpha.FieldConfig.DynamicFacetableOption result =
          com.google.cloud.discoveryengine.v1alpha.FieldConfig.DynamicFacetableOption.forNumber(
              dynamicFacetableOption_);
      return result == null
          ? com.google.cloud.discoveryengine.v1alpha.FieldConfig.DynamicFacetableOption.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * If
     * [dynamic_facetable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.dynamic_facetable_option]
     * is
     * [DYNAMIC_FACETABLE_ENABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.DynamicFacetableOption.DYNAMIC_FACETABLE_ENABLED],
     * field values are available for dynamic facet. Could only be
     * [DYNAMIC_FACETABLE_DISABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.DynamicFacetableOption.DYNAMIC_FACETABLE_DISABLED]
     * if
     * [FieldConfig.indexable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.indexable_option]
     * is
     * [INDEXABLE_DISABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.IndexableOption.INDEXABLE_DISABLED].
     * Otherwise, an `INVALID_ARGUMENT` error will be returned.
     *
     * If
     * [dynamic_facetable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.dynamic_facetable_option]
     * is unset, the server behavior defaults to
     * [DYNAMIC_FACETABLE_DISABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.DynamicFacetableOption.DYNAMIC_FACETABLE_DISABLED]
     * for fields that support setting dynamic facetable options. For those fields
     * that do not support setting dynamic facetable options, such as `object` and
     * `boolean`, the server will skip dynamic facetable option setting, and
     * setting
     * [dynamic_facetable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.dynamic_facetable_option]
     * for those fields will throw `INVALID_ARGUMENT` error.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1alpha.FieldConfig.DynamicFacetableOption dynamic_facetable_option = 4;
     * </code>
     *
     * @param value The dynamicFacetableOption to set.
     * @return This builder for chaining.
     */
    public Builder setDynamicFacetableOption(
        com.google.cloud.discoveryengine.v1alpha.FieldConfig.DynamicFacetableOption value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000008;
      dynamicFacetableOption_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If
     * [dynamic_facetable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.dynamic_facetable_option]
     * is
     * [DYNAMIC_FACETABLE_ENABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.DynamicFacetableOption.DYNAMIC_FACETABLE_ENABLED],
     * field values are available for dynamic facet. Could only be
     * [DYNAMIC_FACETABLE_DISABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.DynamicFacetableOption.DYNAMIC_FACETABLE_DISABLED]
     * if
     * [FieldConfig.indexable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.indexable_option]
     * is
     * [INDEXABLE_DISABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.IndexableOption.INDEXABLE_DISABLED].
     * Otherwise, an `INVALID_ARGUMENT` error will be returned.
     *
     * If
     * [dynamic_facetable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.dynamic_facetable_option]
     * is unset, the server behavior defaults to
     * [DYNAMIC_FACETABLE_DISABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.DynamicFacetableOption.DYNAMIC_FACETABLE_DISABLED]
     * for fields that support setting dynamic facetable options. For those fields
     * that do not support setting dynamic facetable options, such as `object` and
     * `boolean`, the server will skip dynamic facetable option setting, and
     * setting
     * [dynamic_facetable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.dynamic_facetable_option]
     * for those fields will throw `INVALID_ARGUMENT` error.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1alpha.FieldConfig.DynamicFacetableOption dynamic_facetable_option = 4;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDynamicFacetableOption() {
      bitField0_ = (bitField0_ & ~0x00000008);
      dynamicFacetableOption_ = 0;
      onChanged();
      return this;
    }

    private int searchableOption_ = 0;
    /**
     *
     *
     * <pre>
     * If
     * [searchable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.searchable_option]
     * is
     * [SEARCHABLE_ENABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.SearchableOption.SEARCHABLE_ENABLED],
     * field values are searchable by text queries in
     * [SearchService.Search][google.cloud.discoveryengine.v1alpha.SearchService.Search].
     *
     * If
     * [SEARCHABLE_ENABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.SearchableOption.SEARCHABLE_ENABLED]
     * but field type is numerical, field values will not be searchable by text
     * queries in
     * [SearchService.Search][google.cloud.discoveryengine.v1alpha.SearchService.Search],
     * as there are no text values associated to numerical fields.
     *
     * If
     * [searchable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.searchable_option]
     * is unset, the server behavior defaults to
     * [SEARCHABLE_DISABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.SearchableOption.SEARCHABLE_DISABLED]
     * for fields that support setting searchable options. Only `string` fields
     * that have no key property mapping support setting
     * [searchable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.searchable_option].
     *
     * For those fields that do not support setting searchable options, the server
     * will skip searchable option setting, and setting
     * [searchable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.searchable_option]
     * for those fields will throw `INVALID_ARGUMENT` error.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1alpha.FieldConfig.SearchableOption searchable_option = 5;
     * </code>
     *
     * @return The enum numeric value on the wire for searchableOption.
     */
    @java.lang.Override
    public int getSearchableOptionValue() {
      return searchableOption_;
    }
    /**
     *
     *
     * <pre>
     * If
     * [searchable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.searchable_option]
     * is
     * [SEARCHABLE_ENABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.SearchableOption.SEARCHABLE_ENABLED],
     * field values are searchable by text queries in
     * [SearchService.Search][google.cloud.discoveryengine.v1alpha.SearchService.Search].
     *
     * If
     * [SEARCHABLE_ENABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.SearchableOption.SEARCHABLE_ENABLED]
     * but field type is numerical, field values will not be searchable by text
     * queries in
     * [SearchService.Search][google.cloud.discoveryengine.v1alpha.SearchService.Search],
     * as there are no text values associated to numerical fields.
     *
     * If
     * [searchable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.searchable_option]
     * is unset, the server behavior defaults to
     * [SEARCHABLE_DISABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.SearchableOption.SEARCHABLE_DISABLED]
     * for fields that support setting searchable options. Only `string` fields
     * that have no key property mapping support setting
     * [searchable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.searchable_option].
     *
     * For those fields that do not support setting searchable options, the server
     * will skip searchable option setting, and setting
     * [searchable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.searchable_option]
     * for those fields will throw `INVALID_ARGUMENT` error.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1alpha.FieldConfig.SearchableOption searchable_option = 5;
     * </code>
     *
     * @param value The enum numeric value on the wire for searchableOption to set.
     * @return This builder for chaining.
     */
    public Builder setSearchableOptionValue(int value) {
      searchableOption_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If
     * [searchable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.searchable_option]
     * is
     * [SEARCHABLE_ENABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.SearchableOption.SEARCHABLE_ENABLED],
     * field values are searchable by text queries in
     * [SearchService.Search][google.cloud.discoveryengine.v1alpha.SearchService.Search].
     *
     * If
     * [SEARCHABLE_ENABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.SearchableOption.SEARCHABLE_ENABLED]
     * but field type is numerical, field values will not be searchable by text
     * queries in
     * [SearchService.Search][google.cloud.discoveryengine.v1alpha.SearchService.Search],
     * as there are no text values associated to numerical fields.
     *
     * If
     * [searchable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.searchable_option]
     * is unset, the server behavior defaults to
     * [SEARCHABLE_DISABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.SearchableOption.SEARCHABLE_DISABLED]
     * for fields that support setting searchable options. Only `string` fields
     * that have no key property mapping support setting
     * [searchable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.searchable_option].
     *
     * For those fields that do not support setting searchable options, the server
     * will skip searchable option setting, and setting
     * [searchable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.searchable_option]
     * for those fields will throw `INVALID_ARGUMENT` error.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1alpha.FieldConfig.SearchableOption searchable_option = 5;
     * </code>
     *
     * @return The searchableOption.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1alpha.FieldConfig.SearchableOption
        getSearchableOption() {
      com.google.cloud.discoveryengine.v1alpha.FieldConfig.SearchableOption result =
          com.google.cloud.discoveryengine.v1alpha.FieldConfig.SearchableOption.forNumber(
              searchableOption_);
      return result == null
          ? com.google.cloud.discoveryengine.v1alpha.FieldConfig.SearchableOption.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * If
     * [searchable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.searchable_option]
     * is
     * [SEARCHABLE_ENABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.SearchableOption.SEARCHABLE_ENABLED],
     * field values are searchable by text queries in
     * [SearchService.Search][google.cloud.discoveryengine.v1alpha.SearchService.Search].
     *
     * If
     * [SEARCHABLE_ENABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.SearchableOption.SEARCHABLE_ENABLED]
     * but field type is numerical, field values will not be searchable by text
     * queries in
     * [SearchService.Search][google.cloud.discoveryengine.v1alpha.SearchService.Search],
     * as there are no text values associated to numerical fields.
     *
     * If
     * [searchable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.searchable_option]
     * is unset, the server behavior defaults to
     * [SEARCHABLE_DISABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.SearchableOption.SEARCHABLE_DISABLED]
     * for fields that support setting searchable options. Only `string` fields
     * that have no key property mapping support setting
     * [searchable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.searchable_option].
     *
     * For those fields that do not support setting searchable options, the server
     * will skip searchable option setting, and setting
     * [searchable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.searchable_option]
     * for those fields will throw `INVALID_ARGUMENT` error.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1alpha.FieldConfig.SearchableOption searchable_option = 5;
     * </code>
     *
     * @param value The searchableOption to set.
     * @return This builder for chaining.
     */
    public Builder setSearchableOption(
        com.google.cloud.discoveryengine.v1alpha.FieldConfig.SearchableOption value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000010;
      searchableOption_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If
     * [searchable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.searchable_option]
     * is
     * [SEARCHABLE_ENABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.SearchableOption.SEARCHABLE_ENABLED],
     * field values are searchable by text queries in
     * [SearchService.Search][google.cloud.discoveryengine.v1alpha.SearchService.Search].
     *
     * If
     * [SEARCHABLE_ENABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.SearchableOption.SEARCHABLE_ENABLED]
     * but field type is numerical, field values will not be searchable by text
     * queries in
     * [SearchService.Search][google.cloud.discoveryengine.v1alpha.SearchService.Search],
     * as there are no text values associated to numerical fields.
     *
     * If
     * [searchable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.searchable_option]
     * is unset, the server behavior defaults to
     * [SEARCHABLE_DISABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.SearchableOption.SEARCHABLE_DISABLED]
     * for fields that support setting searchable options. Only `string` fields
     * that have no key property mapping support setting
     * [searchable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.searchable_option].
     *
     * For those fields that do not support setting searchable options, the server
     * will skip searchable option setting, and setting
     * [searchable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.searchable_option]
     * for those fields will throw `INVALID_ARGUMENT` error.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1alpha.FieldConfig.SearchableOption searchable_option = 5;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSearchableOption() {
      bitField0_ = (bitField0_ & ~0x00000010);
      searchableOption_ = 0;
      onChanged();
      return this;
    }

    private int retrievableOption_ = 0;
    /**
     *
     *
     * <pre>
     * If
     * [retrievable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.retrievable_option]
     * is
     * [RETRIEVABLE_ENABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.RetrievableOption.RETRIEVABLE_ENABLED],
     * field values are included in the search results.
     *
     * If
     * [retrievable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.retrievable_option]
     * is unset, the server behavior defaults to
     * [RETRIEVABLE_DISABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.RetrievableOption.RETRIEVABLE_DISABLED]
     * for fields that support setting retrievable options. For those fields
     * that do not support setting retrievable options, such as `object` and
     * `boolean`, the server will skip retrievable option setting, and setting
     * [retrievable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.retrievable_option]
     * for those fields will throw `INVALID_ARGUMENT` error.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1alpha.FieldConfig.RetrievableOption retrievable_option = 6;
     * </code>
     *
     * @return The enum numeric value on the wire for retrievableOption.
     */
    @java.lang.Override
    public int getRetrievableOptionValue() {
      return retrievableOption_;
    }
    /**
     *
     *
     * <pre>
     * If
     * [retrievable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.retrievable_option]
     * is
     * [RETRIEVABLE_ENABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.RetrievableOption.RETRIEVABLE_ENABLED],
     * field values are included in the search results.
     *
     * If
     * [retrievable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.retrievable_option]
     * is unset, the server behavior defaults to
     * [RETRIEVABLE_DISABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.RetrievableOption.RETRIEVABLE_DISABLED]
     * for fields that support setting retrievable options. For those fields
     * that do not support setting retrievable options, such as `object` and
     * `boolean`, the server will skip retrievable option setting, and setting
     * [retrievable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.retrievable_option]
     * for those fields will throw `INVALID_ARGUMENT` error.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1alpha.FieldConfig.RetrievableOption retrievable_option = 6;
     * </code>
     *
     * @param value The enum numeric value on the wire for retrievableOption to set.
     * @return This builder for chaining.
     */
    public Builder setRetrievableOptionValue(int value) {
      retrievableOption_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If
     * [retrievable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.retrievable_option]
     * is
     * [RETRIEVABLE_ENABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.RetrievableOption.RETRIEVABLE_ENABLED],
     * field values are included in the search results.
     *
     * If
     * [retrievable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.retrievable_option]
     * is unset, the server behavior defaults to
     * [RETRIEVABLE_DISABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.RetrievableOption.RETRIEVABLE_DISABLED]
     * for fields that support setting retrievable options. For those fields
     * that do not support setting retrievable options, such as `object` and
     * `boolean`, the server will skip retrievable option setting, and setting
     * [retrievable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.retrievable_option]
     * for those fields will throw `INVALID_ARGUMENT` error.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1alpha.FieldConfig.RetrievableOption retrievable_option = 6;
     * </code>
     *
     * @return The retrievableOption.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1alpha.FieldConfig.RetrievableOption
        getRetrievableOption() {
      com.google.cloud.discoveryengine.v1alpha.FieldConfig.RetrievableOption result =
          com.google.cloud.discoveryengine.v1alpha.FieldConfig.RetrievableOption.forNumber(
              retrievableOption_);
      return result == null
          ? com.google.cloud.discoveryengine.v1alpha.FieldConfig.RetrievableOption.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * If
     * [retrievable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.retrievable_option]
     * is
     * [RETRIEVABLE_ENABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.RetrievableOption.RETRIEVABLE_ENABLED],
     * field values are included in the search results.
     *
     * If
     * [retrievable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.retrievable_option]
     * is unset, the server behavior defaults to
     * [RETRIEVABLE_DISABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.RetrievableOption.RETRIEVABLE_DISABLED]
     * for fields that support setting retrievable options. For those fields
     * that do not support setting retrievable options, such as `object` and
     * `boolean`, the server will skip retrievable option setting, and setting
     * [retrievable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.retrievable_option]
     * for those fields will throw `INVALID_ARGUMENT` error.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1alpha.FieldConfig.RetrievableOption retrievable_option = 6;
     * </code>
     *
     * @param value The retrievableOption to set.
     * @return This builder for chaining.
     */
    public Builder setRetrievableOption(
        com.google.cloud.discoveryengine.v1alpha.FieldConfig.RetrievableOption value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000020;
      retrievableOption_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If
     * [retrievable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.retrievable_option]
     * is
     * [RETRIEVABLE_ENABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.RetrievableOption.RETRIEVABLE_ENABLED],
     * field values are included in the search results.
     *
     * If
     * [retrievable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.retrievable_option]
     * is unset, the server behavior defaults to
     * [RETRIEVABLE_DISABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.RetrievableOption.RETRIEVABLE_DISABLED]
     * for fields that support setting retrievable options. For those fields
     * that do not support setting retrievable options, such as `object` and
     * `boolean`, the server will skip retrievable option setting, and setting
     * [retrievable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.retrievable_option]
     * for those fields will throw `INVALID_ARGUMENT` error.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1alpha.FieldConfig.RetrievableOption retrievable_option = 6;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRetrievableOption() {
      bitField0_ = (bitField0_ & ~0x00000020);
      retrievableOption_ = 0;
      onChanged();
      return this;
    }

    private int completableOption_ = 0;
    /**
     *
     *
     * <pre>
     * If
     * [completable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.completable_option]
     * is
     * [COMPLETABLE_ENABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.CompletableOption.COMPLETABLE_ENABLED],
     * field values are directly used and returned as suggestions for Autocomplete
     * in
     * [CompletionService.CompleteQuery][google.cloud.discoveryengine.v1alpha.CompletionService.CompleteQuery].
     *
     * If
     * [completable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.completable_option]
     * is unset, the server behavior defaults to
     * [COMPLETABLE_DISABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.CompletableOption.COMPLETABLE_DISABLED]
     * for fields that support setting completable options, which are just
     * `string` fields. For those fields that do not support setting completable
     * options, the server will skip completable option setting, and setting
     * [completable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.completable_option]
     * for those fields will throw `INVALID_ARGUMENT` error.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1alpha.FieldConfig.CompletableOption completable_option = 8;
     * </code>
     *
     * @return The enum numeric value on the wire for completableOption.
     */
    @java.lang.Override
    public int getCompletableOptionValue() {
      return completableOption_;
    }
    /**
     *
     *
     * <pre>
     * If
     * [completable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.completable_option]
     * is
     * [COMPLETABLE_ENABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.CompletableOption.COMPLETABLE_ENABLED],
     * field values are directly used and returned as suggestions for Autocomplete
     * in
     * [CompletionService.CompleteQuery][google.cloud.discoveryengine.v1alpha.CompletionService.CompleteQuery].
     *
     * If
     * [completable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.completable_option]
     * is unset, the server behavior defaults to
     * [COMPLETABLE_DISABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.CompletableOption.COMPLETABLE_DISABLED]
     * for fields that support setting completable options, which are just
     * `string` fields. For those fields that do not support setting completable
     * options, the server will skip completable option setting, and setting
     * [completable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.completable_option]
     * for those fields will throw `INVALID_ARGUMENT` error.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1alpha.FieldConfig.CompletableOption completable_option = 8;
     * </code>
     *
     * @param value The enum numeric value on the wire for completableOption to set.
     * @return This builder for chaining.
     */
    public Builder setCompletableOptionValue(int value) {
      completableOption_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If
     * [completable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.completable_option]
     * is
     * [COMPLETABLE_ENABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.CompletableOption.COMPLETABLE_ENABLED],
     * field values are directly used and returned as suggestions for Autocomplete
     * in
     * [CompletionService.CompleteQuery][google.cloud.discoveryengine.v1alpha.CompletionService.CompleteQuery].
     *
     * If
     * [completable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.completable_option]
     * is unset, the server behavior defaults to
     * [COMPLETABLE_DISABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.CompletableOption.COMPLETABLE_DISABLED]
     * for fields that support setting completable options, which are just
     * `string` fields. For those fields that do not support setting completable
     * options, the server will skip completable option setting, and setting
     * [completable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.completable_option]
     * for those fields will throw `INVALID_ARGUMENT` error.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1alpha.FieldConfig.CompletableOption completable_option = 8;
     * </code>
     *
     * @return The completableOption.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1alpha.FieldConfig.CompletableOption
        getCompletableOption() {
      com.google.cloud.discoveryengine.v1alpha.FieldConfig.CompletableOption result =
          com.google.cloud.discoveryengine.v1alpha.FieldConfig.CompletableOption.forNumber(
              completableOption_);
      return result == null
          ? com.google.cloud.discoveryengine.v1alpha.FieldConfig.CompletableOption.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * If
     * [completable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.completable_option]
     * is
     * [COMPLETABLE_ENABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.CompletableOption.COMPLETABLE_ENABLED],
     * field values are directly used and returned as suggestions for Autocomplete
     * in
     * [CompletionService.CompleteQuery][google.cloud.discoveryengine.v1alpha.CompletionService.CompleteQuery].
     *
     * If
     * [completable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.completable_option]
     * is unset, the server behavior defaults to
     * [COMPLETABLE_DISABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.CompletableOption.COMPLETABLE_DISABLED]
     * for fields that support setting completable options, which are just
     * `string` fields. For those fields that do not support setting completable
     * options, the server will skip completable option setting, and setting
     * [completable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.completable_option]
     * for those fields will throw `INVALID_ARGUMENT` error.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1alpha.FieldConfig.CompletableOption completable_option = 8;
     * </code>
     *
     * @param value The completableOption to set.
     * @return This builder for chaining.
     */
    public Builder setCompletableOption(
        com.google.cloud.discoveryengine.v1alpha.FieldConfig.CompletableOption value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000040;
      completableOption_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If
     * [completable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.completable_option]
     * is
     * [COMPLETABLE_ENABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.CompletableOption.COMPLETABLE_ENABLED],
     * field values are directly used and returned as suggestions for Autocomplete
     * in
     * [CompletionService.CompleteQuery][google.cloud.discoveryengine.v1alpha.CompletionService.CompleteQuery].
     *
     * If
     * [completable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.completable_option]
     * is unset, the server behavior defaults to
     * [COMPLETABLE_DISABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.CompletableOption.COMPLETABLE_DISABLED]
     * for fields that support setting completable options, which are just
     * `string` fields. For those fields that do not support setting completable
     * options, the server will skip completable option setting, and setting
     * [completable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.completable_option]
     * for those fields will throw `INVALID_ARGUMENT` error.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1alpha.FieldConfig.CompletableOption completable_option = 8;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCompletableOption() {
      bitField0_ = (bitField0_ & ~0x00000040);
      completableOption_ = 0;
      onChanged();
      return this;
    }

    private int recsFilterableOption_ = 0;
    /**
     *
     *
     * <pre>
     * If
     * [recs_filterable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.recs_filterable_option]
     * is
     * [FILTERABLE_ENABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.FilterableOption.FILTERABLE_ENABLED],
     * field values are filterable by filter expression in
     * [RecommendationService.Recommend][google.cloud.discoveryengine.v1alpha.RecommendationService.Recommend].
     *
     * If
     * [FILTERABLE_ENABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.FilterableOption.FILTERABLE_ENABLED]
     * but the field type is numerical, field values are not filterable by text
     * queries in
     * [RecommendationService.Recommend][google.cloud.discoveryengine.v1alpha.RecommendationService.Recommend].
     * Only textual fields are supported.
     *
     * If
     * [recs_filterable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.recs_filterable_option]
     * is unset, the default setting is
     * [FILTERABLE_DISABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.FilterableOption.FILTERABLE_DISABLED]
     * for fields that support setting filterable options.
     *
     * When a field set to [FILTERABLE_DISABLED] is filtered, a warning is
     * generated and an empty result is returned.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1alpha.FieldConfig.FilterableOption recs_filterable_option = 9;
     * </code>
     *
     * @return The enum numeric value on the wire for recsFilterableOption.
     */
    @java.lang.Override
    public int getRecsFilterableOptionValue() {
      return recsFilterableOption_;
    }
    /**
     *
     *
     * <pre>
     * If
     * [recs_filterable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.recs_filterable_option]
     * is
     * [FILTERABLE_ENABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.FilterableOption.FILTERABLE_ENABLED],
     * field values are filterable by filter expression in
     * [RecommendationService.Recommend][google.cloud.discoveryengine.v1alpha.RecommendationService.Recommend].
     *
     * If
     * [FILTERABLE_ENABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.FilterableOption.FILTERABLE_ENABLED]
     * but the field type is numerical, field values are not filterable by text
     * queries in
     * [RecommendationService.Recommend][google.cloud.discoveryengine.v1alpha.RecommendationService.Recommend].
     * Only textual fields are supported.
     *
     * If
     * [recs_filterable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.recs_filterable_option]
     * is unset, the default setting is
     * [FILTERABLE_DISABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.FilterableOption.FILTERABLE_DISABLED]
     * for fields that support setting filterable options.
     *
     * When a field set to [FILTERABLE_DISABLED] is filtered, a warning is
     * generated and an empty result is returned.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1alpha.FieldConfig.FilterableOption recs_filterable_option = 9;
     * </code>
     *
     * @param value The enum numeric value on the wire for recsFilterableOption to set.
     * @return This builder for chaining.
     */
    public Builder setRecsFilterableOptionValue(int value) {
      recsFilterableOption_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If
     * [recs_filterable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.recs_filterable_option]
     * is
     * [FILTERABLE_ENABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.FilterableOption.FILTERABLE_ENABLED],
     * field values are filterable by filter expression in
     * [RecommendationService.Recommend][google.cloud.discoveryengine.v1alpha.RecommendationService.Recommend].
     *
     * If
     * [FILTERABLE_ENABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.FilterableOption.FILTERABLE_ENABLED]
     * but the field type is numerical, field values are not filterable by text
     * queries in
     * [RecommendationService.Recommend][google.cloud.discoveryengine.v1alpha.RecommendationService.Recommend].
     * Only textual fields are supported.
     *
     * If
     * [recs_filterable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.recs_filterable_option]
     * is unset, the default setting is
     * [FILTERABLE_DISABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.FilterableOption.FILTERABLE_DISABLED]
     * for fields that support setting filterable options.
     *
     * When a field set to [FILTERABLE_DISABLED] is filtered, a warning is
     * generated and an empty result is returned.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1alpha.FieldConfig.FilterableOption recs_filterable_option = 9;
     * </code>
     *
     * @return The recsFilterableOption.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1alpha.FieldConfig.FilterableOption
        getRecsFilterableOption() {
      com.google.cloud.discoveryengine.v1alpha.FieldConfig.FilterableOption result =
          com.google.cloud.discoveryengine.v1alpha.FieldConfig.FilterableOption.forNumber(
              recsFilterableOption_);
      return result == null
          ? com.google.cloud.discoveryengine.v1alpha.FieldConfig.FilterableOption.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * If
     * [recs_filterable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.recs_filterable_option]
     * is
     * [FILTERABLE_ENABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.FilterableOption.FILTERABLE_ENABLED],
     * field values are filterable by filter expression in
     * [RecommendationService.Recommend][google.cloud.discoveryengine.v1alpha.RecommendationService.Recommend].
     *
     * If
     * [FILTERABLE_ENABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.FilterableOption.FILTERABLE_ENABLED]
     * but the field type is numerical, field values are not filterable by text
     * queries in
     * [RecommendationService.Recommend][google.cloud.discoveryengine.v1alpha.RecommendationService.Recommend].
     * Only textual fields are supported.
     *
     * If
     * [recs_filterable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.recs_filterable_option]
     * is unset, the default setting is
     * [FILTERABLE_DISABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.FilterableOption.FILTERABLE_DISABLED]
     * for fields that support setting filterable options.
     *
     * When a field set to [FILTERABLE_DISABLED] is filtered, a warning is
     * generated and an empty result is returned.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1alpha.FieldConfig.FilterableOption recs_filterable_option = 9;
     * </code>
     *
     * @param value The recsFilterableOption to set.
     * @return This builder for chaining.
     */
    public Builder setRecsFilterableOption(
        com.google.cloud.discoveryengine.v1alpha.FieldConfig.FilterableOption value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000080;
      recsFilterableOption_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If
     * [recs_filterable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.recs_filterable_option]
     * is
     * [FILTERABLE_ENABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.FilterableOption.FILTERABLE_ENABLED],
     * field values are filterable by filter expression in
     * [RecommendationService.Recommend][google.cloud.discoveryengine.v1alpha.RecommendationService.Recommend].
     *
     * If
     * [FILTERABLE_ENABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.FilterableOption.FILTERABLE_ENABLED]
     * but the field type is numerical, field values are not filterable by text
     * queries in
     * [RecommendationService.Recommend][google.cloud.discoveryengine.v1alpha.RecommendationService.Recommend].
     * Only textual fields are supported.
     *
     * If
     * [recs_filterable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.recs_filterable_option]
     * is unset, the default setting is
     * [FILTERABLE_DISABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.FilterableOption.FILTERABLE_DISABLED]
     * for fields that support setting filterable options.
     *
     * When a field set to [FILTERABLE_DISABLED] is filtered, a warning is
     * generated and an empty result is returned.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1alpha.FieldConfig.FilterableOption recs_filterable_option = 9;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRecsFilterableOption() {
      bitField0_ = (bitField0_ & ~0x00000080);
      recsFilterableOption_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object keyPropertyType_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Type of the key property that this field is mapped to. Empty
     * string if this is not annotated as mapped to a key property.
     *
     * Example types are `title`, `description`. Full list is defined
     * by `keyPropertyMapping` in the schema field annotation.
     *
     * If the schema field has a `KeyPropertyMapping` annotation,
     * `indexable_option` and `searchable_option` of this field cannot be
     * modified.
     * </pre>
     *
     * <code>string key_property_type = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The keyPropertyType.
     */
    public java.lang.String getKeyPropertyType() {
      java.lang.Object ref = keyPropertyType_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        keyPropertyType_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Type of the key property that this field is mapped to. Empty
     * string if this is not annotated as mapped to a key property.
     *
     * Example types are `title`, `description`. Full list is defined
     * by `keyPropertyMapping` in the schema field annotation.
     *
     * If the schema field has a `KeyPropertyMapping` annotation,
     * `indexable_option` and `searchable_option` of this field cannot be
     * modified.
     * </pre>
     *
     * <code>string key_property_type = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for keyPropertyType.
     */
    public com.google.protobuf.ByteString getKeyPropertyTypeBytes() {
      java.lang.Object ref = keyPropertyType_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        keyPropertyType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Type of the key property that this field is mapped to. Empty
     * string if this is not annotated as mapped to a key property.
     *
     * Example types are `title`, `description`. Full list is defined
     * by `keyPropertyMapping` in the schema field annotation.
     *
     * If the schema field has a `KeyPropertyMapping` annotation,
     * `indexable_option` and `searchable_option` of this field cannot be
     * modified.
     * </pre>
     *
     * <code>string key_property_type = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The keyPropertyType to set.
     * @return This builder for chaining.
     */
    public Builder setKeyPropertyType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      keyPropertyType_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Type of the key property that this field is mapped to. Empty
     * string if this is not annotated as mapped to a key property.
     *
     * Example types are `title`, `description`. Full list is defined
     * by `keyPropertyMapping` in the schema field annotation.
     *
     * If the schema field has a `KeyPropertyMapping` annotation,
     * `indexable_option` and `searchable_option` of this field cannot be
     * modified.
     * </pre>
     *
     * <code>string key_property_type = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearKeyPropertyType() {
      keyPropertyType_ = getDefaultInstance().getKeyPropertyType();
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Type of the key property that this field is mapped to. Empty
     * string if this is not annotated as mapped to a key property.
     *
     * Example types are `title`, `description`. Full list is defined
     * by `keyPropertyMapping` in the schema field annotation.
     *
     * If the schema field has a `KeyPropertyMapping` annotation,
     * `indexable_option` and `searchable_option` of this field cannot be
     * modified.
     * </pre>
     *
     * <code>string key_property_type = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for keyPropertyType to set.
     * @return This builder for chaining.
     */
    public Builder setKeyPropertyTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      keyPropertyType_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    private java.util.List<java.lang.Integer> advancedSiteSearchDataSources_ =
        java.util.Collections.emptyList();

    private void ensureAdvancedSiteSearchDataSourcesIsMutable() {
      if (!((bitField0_ & 0x00000200) != 0)) {
        advancedSiteSearchDataSources_ =
            new java.util.ArrayList<java.lang.Integer>(advancedSiteSearchDataSources_);
        bitField0_ |= 0x00000200;
      }
    }
    /**
     *
     *
     * <pre>
     * If this field is set, only the corresponding source will be indexed for
     * this field. Otherwise, the values from different sources are merged.
     *
     * Assuming a page with `&lt;author, a&gt;` in meta tag, and `&lt;author, b&gt;` in page
     * map:
     *  if this enum is set to METATAGS, we will only index `&lt;author, a&gt;`;
     *  if this enum is not set, we will merge them and index `&lt;author, [a, b]&gt;`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1alpha.FieldConfig.AdvancedSiteSearchDataSource advanced_site_search_data_sources = 10;
     * </code>
     *
     * @return A list containing the advancedSiteSearchDataSources.
     */
    public java.util.List<
            com.google.cloud.discoveryengine.v1alpha.FieldConfig.AdvancedSiteSearchDataSource>
        getAdvancedSiteSearchDataSourcesList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer,
          com.google.cloud.discoveryengine.v1alpha.FieldConfig.AdvancedSiteSearchDataSource>(
          advancedSiteSearchDataSources_, advancedSiteSearchDataSources_converter_);
    }
    /**
     *
     *
     * <pre>
     * If this field is set, only the corresponding source will be indexed for
     * this field. Otherwise, the values from different sources are merged.
     *
     * Assuming a page with `&lt;author, a&gt;` in meta tag, and `&lt;author, b&gt;` in page
     * map:
     *  if this enum is set to METATAGS, we will only index `&lt;author, a&gt;`;
     *  if this enum is not set, we will merge them and index `&lt;author, [a, b]&gt;`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1alpha.FieldConfig.AdvancedSiteSearchDataSource advanced_site_search_data_sources = 10;
     * </code>
     *
     * @return The count of advancedSiteSearchDataSources.
     */
    public int getAdvancedSiteSearchDataSourcesCount() {
      return advancedSiteSearchDataSources_.size();
    }
    /**
     *
     *
     * <pre>
     * If this field is set, only the corresponding source will be indexed for
     * this field. Otherwise, the values from different sources are merged.
     *
     * Assuming a page with `&lt;author, a&gt;` in meta tag, and `&lt;author, b&gt;` in page
     * map:
     *  if this enum is set to METATAGS, we will only index `&lt;author, a&gt;`;
     *  if this enum is not set, we will merge them and index `&lt;author, [a, b]&gt;`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1alpha.FieldConfig.AdvancedSiteSearchDataSource advanced_site_search_data_sources = 10;
     * </code>
     *
     * @param index The index of the element to return.
     * @return The advancedSiteSearchDataSources at the given index.
     */
    public com.google.cloud.discoveryengine.v1alpha.FieldConfig.AdvancedSiteSearchDataSource
        getAdvancedSiteSearchDataSources(int index) {
      return advancedSiteSearchDataSources_converter_.convert(
          advancedSiteSearchDataSources_.get(index));
    }
    /**
     *
     *
     * <pre>
     * If this field is set, only the corresponding source will be indexed for
     * this field. Otherwise, the values from different sources are merged.
     *
     * Assuming a page with `&lt;author, a&gt;` in meta tag, and `&lt;author, b&gt;` in page
     * map:
     *  if this enum is set to METATAGS, we will only index `&lt;author, a&gt;`;
     *  if this enum is not set, we will merge them and index `&lt;author, [a, b]&gt;`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1alpha.FieldConfig.AdvancedSiteSearchDataSource advanced_site_search_data_sources = 10;
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The advancedSiteSearchDataSources to set.
     * @return This builder for chaining.
     */
    public Builder setAdvancedSiteSearchDataSources(
        int index,
        com.google.cloud.discoveryengine.v1alpha.FieldConfig.AdvancedSiteSearchDataSource value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureAdvancedSiteSearchDataSourcesIsMutable();
      advancedSiteSearchDataSources_.set(index, value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If this field is set, only the corresponding source will be indexed for
     * this field. Otherwise, the values from different sources are merged.
     *
     * Assuming a page with `&lt;author, a&gt;` in meta tag, and `&lt;author, b&gt;` in page
     * map:
     *  if this enum is set to METATAGS, we will only index `&lt;author, a&gt;`;
     *  if this enum is not set, we will merge them and index `&lt;author, [a, b]&gt;`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1alpha.FieldConfig.AdvancedSiteSearchDataSource advanced_site_search_data_sources = 10;
     * </code>
     *
     * @param value The advancedSiteSearchDataSources to add.
     * @return This builder for chaining.
     */
    public Builder addAdvancedSiteSearchDataSources(
        com.google.cloud.discoveryengine.v1alpha.FieldConfig.AdvancedSiteSearchDataSource value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureAdvancedSiteSearchDataSourcesIsMutable();
      advancedSiteSearchDataSources_.add(value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If this field is set, only the corresponding source will be indexed for
     * this field. Otherwise, the values from different sources are merged.
     *
     * Assuming a page with `&lt;author, a&gt;` in meta tag, and `&lt;author, b&gt;` in page
     * map:
     *  if this enum is set to METATAGS, we will only index `&lt;author, a&gt;`;
     *  if this enum is not set, we will merge them and index `&lt;author, [a, b]&gt;`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1alpha.FieldConfig.AdvancedSiteSearchDataSource advanced_site_search_data_sources = 10;
     * </code>
     *
     * @param values The advancedSiteSearchDataSources to add.
     * @return This builder for chaining.
     */
    public Builder addAllAdvancedSiteSearchDataSources(
        java.lang.Iterable<
                ? extends
                    com.google.cloud.discoveryengine.v1alpha.FieldConfig
                        .AdvancedSiteSearchDataSource>
            values) {
      ensureAdvancedSiteSearchDataSourcesIsMutable();
      for (com.google.cloud.discoveryengine.v1alpha.FieldConfig.AdvancedSiteSearchDataSource value :
          values) {
        advancedSiteSearchDataSources_.add(value.getNumber());
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If this field is set, only the corresponding source will be indexed for
     * this field. Otherwise, the values from different sources are merged.
     *
     * Assuming a page with `&lt;author, a&gt;` in meta tag, and `&lt;author, b&gt;` in page
     * map:
     *  if this enum is set to METATAGS, we will only index `&lt;author, a&gt;`;
     *  if this enum is not set, we will merge them and index `&lt;author, [a, b]&gt;`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1alpha.FieldConfig.AdvancedSiteSearchDataSource advanced_site_search_data_sources = 10;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAdvancedSiteSearchDataSources() {
      advancedSiteSearchDataSources_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000200);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If this field is set, only the corresponding source will be indexed for
     * this field. Otherwise, the values from different sources are merged.
     *
     * Assuming a page with `&lt;author, a&gt;` in meta tag, and `&lt;author, b&gt;` in page
     * map:
     *  if this enum is set to METATAGS, we will only index `&lt;author, a&gt;`;
     *  if this enum is not set, we will merge them and index `&lt;author, [a, b]&gt;`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1alpha.FieldConfig.AdvancedSiteSearchDataSource advanced_site_search_data_sources = 10;
     * </code>
     *
     * @return A list containing the enum numeric values on the wire for
     *     advancedSiteSearchDataSources.
     */
    public java.util.List<java.lang.Integer> getAdvancedSiteSearchDataSourcesValueList() {
      return java.util.Collections.unmodifiableList(advancedSiteSearchDataSources_);
    }
    /**
     *
     *
     * <pre>
     * If this field is set, only the corresponding source will be indexed for
     * this field. Otherwise, the values from different sources are merged.
     *
     * Assuming a page with `&lt;author, a&gt;` in meta tag, and `&lt;author, b&gt;` in page
     * map:
     *  if this enum is set to METATAGS, we will only index `&lt;author, a&gt;`;
     *  if this enum is not set, we will merge them and index `&lt;author, [a, b]&gt;`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1alpha.FieldConfig.AdvancedSiteSearchDataSource advanced_site_search_data_sources = 10;
     * </code>
     *
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of advancedSiteSearchDataSources at the given
     *     index.
     */
    public int getAdvancedSiteSearchDataSourcesValue(int index) {
      return advancedSiteSearchDataSources_.get(index);
    }
    /**
     *
     *
     * <pre>
     * If this field is set, only the corresponding source will be indexed for
     * this field. Otherwise, the values from different sources are merged.
     *
     * Assuming a page with `&lt;author, a&gt;` in meta tag, and `&lt;author, b&gt;` in page
     * map:
     *  if this enum is set to METATAGS, we will only index `&lt;author, a&gt;`;
     *  if this enum is not set, we will merge them and index `&lt;author, [a, b]&gt;`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1alpha.FieldConfig.AdvancedSiteSearchDataSource advanced_site_search_data_sources = 10;
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The enum numeric value on the wire for advancedSiteSearchDataSources to set.
     * @return This builder for chaining.
     */
    public Builder setAdvancedSiteSearchDataSourcesValue(int index, int value) {
      ensureAdvancedSiteSearchDataSourcesIsMutable();
      advancedSiteSearchDataSources_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If this field is set, only the corresponding source will be indexed for
     * this field. Otherwise, the values from different sources are merged.
     *
     * Assuming a page with `&lt;author, a&gt;` in meta tag, and `&lt;author, b&gt;` in page
     * map:
     *  if this enum is set to METATAGS, we will only index `&lt;author, a&gt;`;
     *  if this enum is not set, we will merge them and index `&lt;author, [a, b]&gt;`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1alpha.FieldConfig.AdvancedSiteSearchDataSource advanced_site_search_data_sources = 10;
     * </code>
     *
     * @param value The enum numeric value on the wire for advancedSiteSearchDataSources to add.
     * @return This builder for chaining.
     */
    public Builder addAdvancedSiteSearchDataSourcesValue(int value) {
      ensureAdvancedSiteSearchDataSourcesIsMutable();
      advancedSiteSearchDataSources_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If this field is set, only the corresponding source will be indexed for
     * this field. Otherwise, the values from different sources are merged.
     *
     * Assuming a page with `&lt;author, a&gt;` in meta tag, and `&lt;author, b&gt;` in page
     * map:
     *  if this enum is set to METATAGS, we will only index `&lt;author, a&gt;`;
     *  if this enum is not set, we will merge them and index `&lt;author, [a, b]&gt;`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1alpha.FieldConfig.AdvancedSiteSearchDataSource advanced_site_search_data_sources = 10;
     * </code>
     *
     * @param values The enum numeric values on the wire for advancedSiteSearchDataSources to add.
     * @return This builder for chaining.
     */
    public Builder addAllAdvancedSiteSearchDataSourcesValue(
        java.lang.Iterable<java.lang.Integer> values) {
      ensureAdvancedSiteSearchDataSourcesIsMutable();
      for (int value : values) {
        advancedSiteSearchDataSources_.add(value);
      }
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList schemaOrgPaths_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureSchemaOrgPathsIsMutable() {
      if (!schemaOrgPaths_.isModifiable()) {
        schemaOrgPaths_ = new com.google.protobuf.LazyStringArrayList(schemaOrgPaths_);
      }
      bitField0_ |= 0x00000400;
    }
    /**
     *
     *
     * <pre>
     * Field paths for indexing custom attribute from schema.org data. More
     * details of schema.org and its defined types can be found at
     * [schema.org](https://schema.org).
     *
     * It is only used on advanced site search schema.
     *
     * Currently only support full path from root. The full path to a field is
     * constructed by concatenating field names, starting from `_root`, with
     * a period `.` as the delimiter. Examples:
     *
     * * Publish date of the root: _root.datePublished
     * * Publish date of the reviews: _root.review.datePublished
     * </pre>
     *
     * <code>repeated string schema_org_paths = 11;</code>
     *
     * @return A list containing the schemaOrgPaths.
     */
    public com.google.protobuf.ProtocolStringList getSchemaOrgPathsList() {
      schemaOrgPaths_.makeImmutable();
      return schemaOrgPaths_;
    }
    /**
     *
     *
     * <pre>
     * Field paths for indexing custom attribute from schema.org data. More
     * details of schema.org and its defined types can be found at
     * [schema.org](https://schema.org).
     *
     * It is only used on advanced site search schema.
     *
     * Currently only support full path from root. The full path to a field is
     * constructed by concatenating field names, starting from `_root`, with
     * a period `.` as the delimiter. Examples:
     *
     * * Publish date of the root: _root.datePublished
     * * Publish date of the reviews: _root.review.datePublished
     * </pre>
     *
     * <code>repeated string schema_org_paths = 11;</code>
     *
     * @return The count of schemaOrgPaths.
     */
    public int getSchemaOrgPathsCount() {
      return schemaOrgPaths_.size();
    }
    /**
     *
     *
     * <pre>
     * Field paths for indexing custom attribute from schema.org data. More
     * details of schema.org and its defined types can be found at
     * [schema.org](https://schema.org).
     *
     * It is only used on advanced site search schema.
     *
     * Currently only support full path from root. The full path to a field is
     * constructed by concatenating field names, starting from `_root`, with
     * a period `.` as the delimiter. Examples:
     *
     * * Publish date of the root: _root.datePublished
     * * Publish date of the reviews: _root.review.datePublished
     * </pre>
     *
     * <code>repeated string schema_org_paths = 11;</code>
     *
     * @param index The index of the element to return.
     * @return The schemaOrgPaths at the given index.
     */
    public java.lang.String getSchemaOrgPaths(int index) {
      return schemaOrgPaths_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Field paths for indexing custom attribute from schema.org data. More
     * details of schema.org and its defined types can be found at
     * [schema.org](https://schema.org).
     *
     * It is only used on advanced site search schema.
     *
     * Currently only support full path from root. The full path to a field is
     * constructed by concatenating field names, starting from `_root`, with
     * a period `.` as the delimiter. Examples:
     *
     * * Publish date of the root: _root.datePublished
     * * Publish date of the reviews: _root.review.datePublished
     * </pre>
     *
     * <code>repeated string schema_org_paths = 11;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the schemaOrgPaths at the given index.
     */
    public com.google.protobuf.ByteString getSchemaOrgPathsBytes(int index) {
      return schemaOrgPaths_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Field paths for indexing custom attribute from schema.org data. More
     * details of schema.org and its defined types can be found at
     * [schema.org](https://schema.org).
     *
     * It is only used on advanced site search schema.
     *
     * Currently only support full path from root. The full path to a field is
     * constructed by concatenating field names, starting from `_root`, with
     * a period `.` as the delimiter. Examples:
     *
     * * Publish date of the root: _root.datePublished
     * * Publish date of the reviews: _root.review.datePublished
     * </pre>
     *
     * <code>repeated string schema_org_paths = 11;</code>
     *
     * @param index The index to set the value at.
     * @param value The schemaOrgPaths to set.
     * @return This builder for chaining.
     */
    public Builder setSchemaOrgPaths(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSchemaOrgPathsIsMutable();
      schemaOrgPaths_.set(index, value);
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Field paths for indexing custom attribute from schema.org data. More
     * details of schema.org and its defined types can be found at
     * [schema.org](https://schema.org).
     *
     * It is only used on advanced site search schema.
     *
     * Currently only support full path from root. The full path to a field is
     * constructed by concatenating field names, starting from `_root`, with
     * a period `.` as the delimiter. Examples:
     *
     * * Publish date of the root: _root.datePublished
     * * Publish date of the reviews: _root.review.datePublished
     * </pre>
     *
     * <code>repeated string schema_org_paths = 11;</code>
     *
     * @param value The schemaOrgPaths to add.
     * @return This builder for chaining.
     */
    public Builder addSchemaOrgPaths(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSchemaOrgPathsIsMutable();
      schemaOrgPaths_.add(value);
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Field paths for indexing custom attribute from schema.org data. More
     * details of schema.org and its defined types can be found at
     * [schema.org](https://schema.org).
     *
     * It is only used on advanced site search schema.
     *
     * Currently only support full path from root. The full path to a field is
     * constructed by concatenating field names, starting from `_root`, with
     * a period `.` as the delimiter. Examples:
     *
     * * Publish date of the root: _root.datePublished
     * * Publish date of the reviews: _root.review.datePublished
     * </pre>
     *
     * <code>repeated string schema_org_paths = 11;</code>
     *
     * @param values The schemaOrgPaths to add.
     * @return This builder for chaining.
     */
    public Builder addAllSchemaOrgPaths(java.lang.Iterable<java.lang.String> values) {
      ensureSchemaOrgPathsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, schemaOrgPaths_);
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Field paths for indexing custom attribute from schema.org data. More
     * details of schema.org and its defined types can be found at
     * [schema.org](https://schema.org).
     *
     * It is only used on advanced site search schema.
     *
     * Currently only support full path from root. The full path to a field is
     * constructed by concatenating field names, starting from `_root`, with
     * a period `.` as the delimiter. Examples:
     *
     * * Publish date of the root: _root.datePublished
     * * Publish date of the reviews: _root.review.datePublished
     * </pre>
     *
     * <code>repeated string schema_org_paths = 11;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSchemaOrgPaths() {
      schemaOrgPaths_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000400);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Field paths for indexing custom attribute from schema.org data. More
     * details of schema.org and its defined types can be found at
     * [schema.org](https://schema.org).
     *
     * It is only used on advanced site search schema.
     *
     * Currently only support full path from root. The full path to a field is
     * constructed by concatenating field names, starting from `_root`, with
     * a period `.` as the delimiter. Examples:
     *
     * * Publish date of the root: _root.datePublished
     * * Publish date of the reviews: _root.review.datePublished
     * </pre>
     *
     * <code>repeated string schema_org_paths = 11;</code>
     *
     * @param value The bytes of the schemaOrgPaths to add.
     * @return This builder for chaining.
     */
    public Builder addSchemaOrgPathsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureSchemaOrgPathsIsMutable();
      schemaOrgPaths_.add(value);
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1alpha.FieldConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1alpha.FieldConfig)
  private static final com.google.cloud.discoveryengine.v1alpha.FieldConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.discoveryengine.v1alpha.FieldConfig();
  }

  public static com.google.cloud.discoveryengine.v1alpha.FieldConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<FieldConfig> PARSER =
      new com.google.protobuf.AbstractParser<FieldConfig>() {
        @java.lang.Override
        public FieldConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<FieldConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<FieldConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.discoveryengine.v1alpha.FieldConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
