/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/discoveryengine/v1alpha/site_search_engine_service.proto

// Protobuf Java Version: 3.25.4
package com.google.cloud.discoveryengine.v1alpha;

/**
 *
 *
 * <pre>
 * Response message for
 * [SiteSearchEngineService.RecrawlUris][google.cloud.discoveryengine.v1alpha.SiteSearchEngineService.RecrawlUris]
 * method.
 * </pre>
 *
 * Protobuf type {@code google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse}
 */
public final class RecrawlUrisResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse)
    RecrawlUrisResponseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use RecrawlUrisResponse.newBuilder() to construct.
  private RecrawlUrisResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private RecrawlUrisResponse() {
    failureSamples_ = java.util.Collections.emptyList();
    failedUris_ = com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new RecrawlUrisResponse();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.discoveryengine.v1alpha.SiteSearchEngineServiceProto
        .internal_static_google_cloud_discoveryengine_v1alpha_RecrawlUrisResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.discoveryengine.v1alpha.SiteSearchEngineServiceProto
        .internal_static_google_cloud_discoveryengine_v1alpha_RecrawlUrisResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.class,
            com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.Builder.class);
  }

  public interface FailureInfoOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * URI that failed to be crawled.
     * </pre>
     *
     * <code>string uri = 1;</code>
     *
     * @return The uri.
     */
    java.lang.String getUri();
    /**
     *
     *
     * <pre>
     * URI that failed to be crawled.
     * </pre>
     *
     * <code>string uri = 1;</code>
     *
     * @return The bytes for uri.
     */
    com.google.protobuf.ByteString getUriBytes();

    /**
     *
     *
     * <pre>
     * List of failure reasons by corpus type (e.g. desktop, mobile).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo.FailureReason failure_reasons = 2;
     * </code>
     */
    java.util.List<
            com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo.FailureReason>
        getFailureReasonsList();
    /**
     *
     *
     * <pre>
     * List of failure reasons by corpus type (e.g. desktop, mobile).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo.FailureReason failure_reasons = 2;
     * </code>
     */
    com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo.FailureReason
        getFailureReasons(int index);
    /**
     *
     *
     * <pre>
     * List of failure reasons by corpus type (e.g. desktop, mobile).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo.FailureReason failure_reasons = 2;
     * </code>
     */
    int getFailureReasonsCount();
    /**
     *
     *
     * <pre>
     * List of failure reasons by corpus type (e.g. desktop, mobile).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo.FailureReason failure_reasons = 2;
     * </code>
     */
    java.util.List<
            ? extends
                com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo
                    .FailureReasonOrBuilder>
        getFailureReasonsOrBuilderList();
    /**
     *
     *
     * <pre>
     * List of failure reasons by corpus type (e.g. desktop, mobile).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo.FailureReason failure_reasons = 2;
     * </code>
     */
    com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo.FailureReasonOrBuilder
        getFailureReasonsOrBuilder(int index);
  }
  /**
   *
   *
   * <pre>
   * Details about why a particular URI failed to be crawled. Each FailureInfo
   * contains one FailureReason per CorpusType.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo}
   */
  public static final class FailureInfo extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo)
      FailureInfoOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use FailureInfo.newBuilder() to construct.
    private FailureInfo(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private FailureInfo() {
      uri_ = "";
      failureReasons_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new FailureInfo();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1alpha.SiteSearchEngineServiceProto
          .internal_static_google_cloud_discoveryengine_v1alpha_RecrawlUrisResponse_FailureInfo_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1alpha.SiteSearchEngineServiceProto
          .internal_static_google_cloud_discoveryengine_v1alpha_RecrawlUrisResponse_FailureInfo_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo.class,
              com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo.Builder
                  .class);
    }

    public interface FailureReasonOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo.FailureReason)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * DESKTOP, MOBILE, or CORPUS_TYPE_UNSPECIFIED.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo.FailureReason.CorpusType corpus_type = 1;
       * </code>
       *
       * @return The enum numeric value on the wire for corpusType.
       */
      int getCorpusTypeValue();
      /**
       *
       *
       * <pre>
       * DESKTOP, MOBILE, or CORPUS_TYPE_UNSPECIFIED.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo.FailureReason.CorpusType corpus_type = 1;
       * </code>
       *
       * @return The corpusType.
       */
      com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo.FailureReason
              .CorpusType
          getCorpusType();

      /**
       *
       *
       * <pre>
       * Reason why the URI was not crawled.
       * </pre>
       *
       * <code>string error_message = 2;</code>
       *
       * @return The errorMessage.
       */
      java.lang.String getErrorMessage();
      /**
       *
       *
       * <pre>
       * Reason why the URI was not crawled.
       * </pre>
       *
       * <code>string error_message = 2;</code>
       *
       * @return The bytes for errorMessage.
       */
      com.google.protobuf.ByteString getErrorMessageBytes();
    }
    /**
     *
     *
     * <pre>
     * Details about why crawling failed for a particular CorpusType, e.g.,
     * DESKTOP and MOBILE crawling may fail for different reasons.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo.FailureReason}
     */
    public static final class FailureReason extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo.FailureReason)
        FailureReasonOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use FailureReason.newBuilder() to construct.
      private FailureReason(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private FailureReason() {
        corpusType_ = 0;
        errorMessage_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new FailureReason();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1alpha.SiteSearchEngineServiceProto
            .internal_static_google_cloud_discoveryengine_v1alpha_RecrawlUrisResponse_FailureInfo_FailureReason_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1alpha.SiteSearchEngineServiceProto
            .internal_static_google_cloud_discoveryengine_v1alpha_RecrawlUrisResponse_FailureInfo_FailureReason_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo
                    .FailureReason.class,
                com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo
                    .FailureReason.Builder.class);
      }

      /**
       *
       *
       * <pre>
       * CorpusType for the failed crawling operation.
       * </pre>
       *
       * Protobuf enum {@code
       * google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo.FailureReason.CorpusType}
       */
      public enum CorpusType implements com.google.protobuf.ProtocolMessageEnum {
        /**
         *
         *
         * <pre>
         * Default value.
         * </pre>
         *
         * <code>CORPUS_TYPE_UNSPECIFIED = 0;</code>
         */
        CORPUS_TYPE_UNSPECIFIED(0),
        /**
         *
         *
         * <pre>
         * Denotes a crawling attempt for the desktop version of a page.
         * </pre>
         *
         * <code>DESKTOP = 1;</code>
         */
        DESKTOP(1),
        /**
         *
         *
         * <pre>
         * Denotes a crawling attempt for the mobile version of a page.
         * </pre>
         *
         * <code>MOBILE = 2;</code>
         */
        MOBILE(2),
        UNRECOGNIZED(-1),
        ;

        /**
         *
         *
         * <pre>
         * Default value.
         * </pre>
         *
         * <code>CORPUS_TYPE_UNSPECIFIED = 0;</code>
         */
        public static final int CORPUS_TYPE_UNSPECIFIED_VALUE = 0;
        /**
         *
         *
         * <pre>
         * Denotes a crawling attempt for the desktop version of a page.
         * </pre>
         *
         * <code>DESKTOP = 1;</code>
         */
        public static final int DESKTOP_VALUE = 1;
        /**
         *
         *
         * <pre>
         * Denotes a crawling attempt for the mobile version of a page.
         * </pre>
         *
         * <code>MOBILE = 2;</code>
         */
        public static final int MOBILE_VALUE = 2;

        public final int getNumber() {
          if (this == UNRECOGNIZED) {
            throw new java.lang.IllegalArgumentException(
                "Can't get the number of an unknown enum value.");
          }
          return value;
        }

        /**
         * @param value The numeric wire value of the corresponding enum entry.
         * @return The enum associated with the given numeric wire value.
         * @deprecated Use {@link #forNumber(int)} instead.
         */
        @java.lang.Deprecated
        public static CorpusType valueOf(int value) {
          return forNumber(value);
        }

        /**
         * @param value The numeric wire value of the corresponding enum entry.
         * @return The enum associated with the given numeric wire value.
         */
        public static CorpusType forNumber(int value) {
          switch (value) {
            case 0:
              return CORPUS_TYPE_UNSPECIFIED;
            case 1:
              return DESKTOP;
            case 2:
              return MOBILE;
            default:
              return null;
          }
        }

        public static com.google.protobuf.Internal.EnumLiteMap<CorpusType> internalGetValueMap() {
          return internalValueMap;
        }

        private static final com.google.protobuf.Internal.EnumLiteMap<CorpusType> internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<CorpusType>() {
              public CorpusType findValueByNumber(int number) {
                return CorpusType.forNumber(number);
              }
            };

        public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
          if (this == UNRECOGNIZED) {
            throw new java.lang.IllegalStateException(
                "Can't get the descriptor of an unrecognized enum value.");
          }
          return getDescriptor().getValues().get(ordinal());
        }

        public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
          return getDescriptor();
        }

        public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
          return com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo
              .FailureReason.getDescriptor()
              .getEnumTypes()
              .get(0);
        }

        private static final CorpusType[] VALUES = values();

        public static CorpusType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
          if (desc.getType() != getDescriptor()) {
            throw new java.lang.IllegalArgumentException(
                "EnumValueDescriptor is not for this type.");
          }
          if (desc.getIndex() == -1) {
            return UNRECOGNIZED;
          }
          return VALUES[desc.getIndex()];
        }

        private final int value;

        private CorpusType(int value) {
          this.value = value;
        }

        // @@protoc_insertion_point(enum_scope:google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo.FailureReason.CorpusType)
      }

      public static final int CORPUS_TYPE_FIELD_NUMBER = 1;
      private int corpusType_ = 0;
      /**
       *
       *
       * <pre>
       * DESKTOP, MOBILE, or CORPUS_TYPE_UNSPECIFIED.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo.FailureReason.CorpusType corpus_type = 1;
       * </code>
       *
       * @return The enum numeric value on the wire for corpusType.
       */
      @java.lang.Override
      public int getCorpusTypeValue() {
        return corpusType_;
      }
      /**
       *
       *
       * <pre>
       * DESKTOP, MOBILE, or CORPUS_TYPE_UNSPECIFIED.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo.FailureReason.CorpusType corpus_type = 1;
       * </code>
       *
       * @return The corpusType.
       */
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo.FailureReason
              .CorpusType
          getCorpusType() {
        com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo.FailureReason
                .CorpusType
            result =
                com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo
                    .FailureReason.CorpusType.forNumber(corpusType_);
        return result == null
            ? com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo.FailureReason
                .CorpusType.UNRECOGNIZED
            : result;
      }

      public static final int ERROR_MESSAGE_FIELD_NUMBER = 2;

      @SuppressWarnings("serial")
      private volatile java.lang.Object errorMessage_ = "";
      /**
       *
       *
       * <pre>
       * Reason why the URI was not crawled.
       * </pre>
       *
       * <code>string error_message = 2;</code>
       *
       * @return The errorMessage.
       */
      @java.lang.Override
      public java.lang.String getErrorMessage() {
        java.lang.Object ref = errorMessage_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          errorMessage_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Reason why the URI was not crawled.
       * </pre>
       *
       * <code>string error_message = 2;</code>
       *
       * @return The bytes for errorMessage.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getErrorMessageBytes() {
        java.lang.Object ref = errorMessage_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          errorMessage_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (corpusType_
            != com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo
                .FailureReason.CorpusType.CORPUS_TYPE_UNSPECIFIED
                .getNumber()) {
          output.writeEnum(1, corpusType_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(errorMessage_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 2, errorMessage_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (corpusType_
            != com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo
                .FailureReason.CorpusType.CORPUS_TYPE_UNSPECIFIED
                .getNumber()) {
          size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, corpusType_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(errorMessage_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, errorMessage_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo
                .FailureReason)) {
          return super.equals(obj);
        }
        com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo.FailureReason
            other =
                (com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo
                        .FailureReason)
                    obj;

        if (corpusType_ != other.corpusType_) return false;
        if (!getErrorMessage().equals(other.getErrorMessage())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + CORPUS_TYPE_FIELD_NUMBER;
        hash = (53 * hash) + corpusType_;
        hash = (37 * hash) + ERROR_MESSAGE_FIELD_NUMBER;
        hash = (53 * hash) + getErrorMessage().hashCode();
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo
              .FailureReason
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo
              .FailureReason
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo
              .FailureReason
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo
              .FailureReason
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo
              .FailureReason
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo
              .FailureReason
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo
              .FailureReason
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo
              .FailureReason
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo
              .FailureReason
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo
              .FailureReason
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo
              .FailureReason
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo
              .FailureReason
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo.FailureReason
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Details about why crawling failed for a particular CorpusType, e.g.,
       * DESKTOP and MOBILE crawling may fail for different reasons.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo.FailureReason}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo.FailureReason)
          com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo
              .FailureReasonOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.discoveryengine.v1alpha.SiteSearchEngineServiceProto
              .internal_static_google_cloud_discoveryengine_v1alpha_RecrawlUrisResponse_FailureInfo_FailureReason_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.discoveryengine.v1alpha.SiteSearchEngineServiceProto
              .internal_static_google_cloud_discoveryengine_v1alpha_RecrawlUrisResponse_FailureInfo_FailureReason_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo
                      .FailureReason.class,
                  com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo
                      .FailureReason.Builder.class);
        }

        // Construct using
        // com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo.FailureReason.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          corpusType_ = 0;
          errorMessage_ = "";
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.discoveryengine.v1alpha.SiteSearchEngineServiceProto
              .internal_static_google_cloud_discoveryengine_v1alpha_RecrawlUrisResponse_FailureInfo_FailureReason_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo
                .FailureReason
            getDefaultInstanceForType() {
          return com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo
              .FailureReason.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo
                .FailureReason
            build() {
          com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo.FailureReason
              result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo
                .FailureReason
            buildPartial() {
          com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo.FailureReason
              result =
                  new com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo
                      .FailureReason(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo.FailureReason
                result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.corpusType_ = corpusType_;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.errorMessage_ = errorMessage_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo
                  .FailureReason) {
            return mergeFrom(
                (com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo
                        .FailureReason)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo.FailureReason
                other) {
          if (other
              == com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo
                  .FailureReason.getDefaultInstance()) return this;
          if (other.corpusType_ != 0) {
            setCorpusTypeValue(other.getCorpusTypeValue());
          }
          if (!other.getErrorMessage().isEmpty()) {
            errorMessage_ = other.errorMessage_;
            bitField0_ |= 0x00000002;
            onChanged();
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 8:
                  {
                    corpusType_ = input.readEnum();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 8
                case 18:
                  {
                    errorMessage_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 18
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private int corpusType_ = 0;
        /**
         *
         *
         * <pre>
         * DESKTOP, MOBILE, or CORPUS_TYPE_UNSPECIFIED.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo.FailureReason.CorpusType corpus_type = 1;
         * </code>
         *
         * @return The enum numeric value on the wire for corpusType.
         */
        @java.lang.Override
        public int getCorpusTypeValue() {
          return corpusType_;
        }
        /**
         *
         *
         * <pre>
         * DESKTOP, MOBILE, or CORPUS_TYPE_UNSPECIFIED.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo.FailureReason.CorpusType corpus_type = 1;
         * </code>
         *
         * @param value The enum numeric value on the wire for corpusType to set.
         * @return This builder for chaining.
         */
        public Builder setCorpusTypeValue(int value) {
          corpusType_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * DESKTOP, MOBILE, or CORPUS_TYPE_UNSPECIFIED.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo.FailureReason.CorpusType corpus_type = 1;
         * </code>
         *
         * @return The corpusType.
         */
        @java.lang.Override
        public com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo
                .FailureReason.CorpusType
            getCorpusType() {
          com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo.FailureReason
                  .CorpusType
              result =
                  com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo
                      .FailureReason.CorpusType.forNumber(corpusType_);
          return result == null
              ? com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo
                  .FailureReason.CorpusType.UNRECOGNIZED
              : result;
        }
        /**
         *
         *
         * <pre>
         * DESKTOP, MOBILE, or CORPUS_TYPE_UNSPECIFIED.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo.FailureReason.CorpusType corpus_type = 1;
         * </code>
         *
         * @param value The corpusType to set.
         * @return This builder for chaining.
         */
        public Builder setCorpusType(
            com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo.FailureReason
                    .CorpusType
                value) {
          if (value == null) {
            throw new NullPointerException();
          }
          bitField0_ |= 0x00000001;
          corpusType_ = value.getNumber();
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * DESKTOP, MOBILE, or CORPUS_TYPE_UNSPECIFIED.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo.FailureReason.CorpusType corpus_type = 1;
         * </code>
         *
         * @return This builder for chaining.
         */
        public Builder clearCorpusType() {
          bitField0_ = (bitField0_ & ~0x00000001);
          corpusType_ = 0;
          onChanged();
          return this;
        }

        private java.lang.Object errorMessage_ = "";
        /**
         *
         *
         * <pre>
         * Reason why the URI was not crawled.
         * </pre>
         *
         * <code>string error_message = 2;</code>
         *
         * @return The errorMessage.
         */
        public java.lang.String getErrorMessage() {
          java.lang.Object ref = errorMessage_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            errorMessage_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Reason why the URI was not crawled.
         * </pre>
         *
         * <code>string error_message = 2;</code>
         *
         * @return The bytes for errorMessage.
         */
        public com.google.protobuf.ByteString getErrorMessageBytes() {
          java.lang.Object ref = errorMessage_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            errorMessage_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Reason why the URI was not crawled.
         * </pre>
         *
         * <code>string error_message = 2;</code>
         *
         * @param value The errorMessage to set.
         * @return This builder for chaining.
         */
        public Builder setErrorMessage(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          errorMessage_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Reason why the URI was not crawled.
         * </pre>
         *
         * <code>string error_message = 2;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearErrorMessage() {
          errorMessage_ = getDefaultInstance().getErrorMessage();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Reason why the URI was not crawled.
         * </pre>
         *
         * <code>string error_message = 2;</code>
         *
         * @param value The bytes for errorMessage to set.
         * @return This builder for chaining.
         */
        public Builder setErrorMessageBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          errorMessage_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo.FailureReason)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo.FailureReason)
      private static final com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo
              .FailureReason
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo
                .FailureReason();
      }

      public static com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo
              .FailureReason
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<FailureReason> PARSER =
          new com.google.protobuf.AbstractParser<FailureReason>() {
            @java.lang.Override
            public FailureReason parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<FailureReason> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<FailureReason> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo.FailureReason
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public static final int URI_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object uri_ = "";
    /**
     *
     *
     * <pre>
     * URI that failed to be crawled.
     * </pre>
     *
     * <code>string uri = 1;</code>
     *
     * @return The uri.
     */
    @java.lang.Override
    public java.lang.String getUri() {
      java.lang.Object ref = uri_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        uri_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * URI that failed to be crawled.
     * </pre>
     *
     * <code>string uri = 1;</code>
     *
     * @return The bytes for uri.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getUriBytes() {
      java.lang.Object ref = uri_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        uri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int FAILURE_REASONS_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private java.util.List<
            com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo.FailureReason>
        failureReasons_;
    /**
     *
     *
     * <pre>
     * List of failure reasons by corpus type (e.g. desktop, mobile).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo.FailureReason failure_reasons = 2;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo.FailureReason>
        getFailureReasonsList() {
      return failureReasons_;
    }
    /**
     *
     *
     * <pre>
     * List of failure reasons by corpus type (e.g. desktop, mobile).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo.FailureReason failure_reasons = 2;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends
                com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo
                    .FailureReasonOrBuilder>
        getFailureReasonsOrBuilderList() {
      return failureReasons_;
    }
    /**
     *
     *
     * <pre>
     * List of failure reasons by corpus type (e.g. desktop, mobile).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo.FailureReason failure_reasons = 2;
     * </code>
     */
    @java.lang.Override
    public int getFailureReasonsCount() {
      return failureReasons_.size();
    }
    /**
     *
     *
     * <pre>
     * List of failure reasons by corpus type (e.g. desktop, mobile).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo.FailureReason failure_reasons = 2;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo.FailureReason
        getFailureReasons(int index) {
      return failureReasons_.get(index);
    }
    /**
     *
     *
     * <pre>
     * List of failure reasons by corpus type (e.g. desktop, mobile).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo.FailureReason failure_reasons = 2;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo
            .FailureReasonOrBuilder
        getFailureReasonsOrBuilder(int index) {
      return failureReasons_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uri_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, uri_);
      }
      for (int i = 0; i < failureReasons_.size(); i++) {
        output.writeMessage(2, failureReasons_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uri_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, uri_);
      }
      for (int i = 0; i < failureReasons_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, failureReasons_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo)) {
        return super.equals(obj);
      }
      com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo other =
          (com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo) obj;

      if (!getUri().equals(other.getUri())) return false;
      if (!getFailureReasonsList().equals(other.getFailureReasonsList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + URI_FIELD_NUMBER;
      hash = (53 * hash) + getUri().hashCode();
      if (getFailureReasonsCount() > 0) {
        hash = (37 * hash) + FAILURE_REASONS_FIELD_NUMBER;
        hash = (53 * hash) + getFailureReasonsList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Details about why a particular URI failed to be crawled. Each FailureInfo
     * contains one FailureReason per CorpusType.
     * </pre>
     *
     * Protobuf type {@code google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo)
        com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfoOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1alpha.SiteSearchEngineServiceProto
            .internal_static_google_cloud_discoveryengine_v1alpha_RecrawlUrisResponse_FailureInfo_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1alpha.SiteSearchEngineServiceProto
            .internal_static_google_cloud_discoveryengine_v1alpha_RecrawlUrisResponse_FailureInfo_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo.class,
                com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        uri_ = "";
        if (failureReasonsBuilder_ == null) {
          failureReasons_ = java.util.Collections.emptyList();
        } else {
          failureReasons_ = null;
          failureReasonsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.discoveryengine.v1alpha.SiteSearchEngineServiceProto
            .internal_static_google_cloud_discoveryengine_v1alpha_RecrawlUrisResponse_FailureInfo_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo
          getDefaultInstanceForType() {
        return com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo build() {
        com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo
          buildPartial() {
        com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo result =
            new com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo result) {
        if (failureReasonsBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)) {
            failureReasons_ = java.util.Collections.unmodifiableList(failureReasons_);
            bitField0_ = (bitField0_ & ~0x00000002);
          }
          result.failureReasons_ = failureReasons_;
        } else {
          result.failureReasons_ = failureReasonsBuilder_.build();
        }
      }

      private void buildPartial0(
          com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.uri_ = uri_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo) {
          return mergeFrom(
              (com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo other) {
        if (other
            == com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo
                .getDefaultInstance()) return this;
        if (!other.getUri().isEmpty()) {
          uri_ = other.uri_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (failureReasonsBuilder_ == null) {
          if (!other.failureReasons_.isEmpty()) {
            if (failureReasons_.isEmpty()) {
              failureReasons_ = other.failureReasons_;
              bitField0_ = (bitField0_ & ~0x00000002);
            } else {
              ensureFailureReasonsIsMutable();
              failureReasons_.addAll(other.failureReasons_);
            }
            onChanged();
          }
        } else {
          if (!other.failureReasons_.isEmpty()) {
            if (failureReasonsBuilder_.isEmpty()) {
              failureReasonsBuilder_.dispose();
              failureReasonsBuilder_ = null;
              failureReasons_ = other.failureReasons_;
              bitField0_ = (bitField0_ & ~0x00000002);
              failureReasonsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getFailureReasonsFieldBuilder()
                      : null;
            } else {
              failureReasonsBuilder_.addAllMessages(other.failureReasons_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  uri_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo
                          .FailureReason
                      m =
                          input.readMessage(
                              com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse
                                  .FailureInfo.FailureReason.parser(),
                              extensionRegistry);
                  if (failureReasonsBuilder_ == null) {
                    ensureFailureReasonsIsMutable();
                    failureReasons_.add(m);
                  } else {
                    failureReasonsBuilder_.addMessage(m);
                  }
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object uri_ = "";
      /**
       *
       *
       * <pre>
       * URI that failed to be crawled.
       * </pre>
       *
       * <code>string uri = 1;</code>
       *
       * @return The uri.
       */
      public java.lang.String getUri() {
        java.lang.Object ref = uri_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          uri_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * URI that failed to be crawled.
       * </pre>
       *
       * <code>string uri = 1;</code>
       *
       * @return The bytes for uri.
       */
      public com.google.protobuf.ByteString getUriBytes() {
        java.lang.Object ref = uri_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          uri_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * URI that failed to be crawled.
       * </pre>
       *
       * <code>string uri = 1;</code>
       *
       * @param value The uri to set.
       * @return This builder for chaining.
       */
      public Builder setUri(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        uri_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * URI that failed to be crawled.
       * </pre>
       *
       * <code>string uri = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearUri() {
        uri_ = getDefaultInstance().getUri();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * URI that failed to be crawled.
       * </pre>
       *
       * <code>string uri = 1;</code>
       *
       * @param value The bytes for uri to set.
       * @return This builder for chaining.
       */
      public Builder setUriBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        uri_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.util.List<
              com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo
                  .FailureReason>
          failureReasons_ = java.util.Collections.emptyList();

      private void ensureFailureReasonsIsMutable() {
        if (!((bitField0_ & 0x00000002) != 0)) {
          failureReasons_ =
              new java.util.ArrayList<
                  com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo
                      .FailureReason>(failureReasons_);
          bitField0_ |= 0x00000002;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo
                  .FailureReason,
              com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo.FailureReason
                  .Builder,
              com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo
                  .FailureReasonOrBuilder>
          failureReasonsBuilder_;

      /**
       *
       *
       * <pre>
       * List of failure reasons by corpus type (e.g. desktop, mobile).
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo.FailureReason failure_reasons = 2;
       * </code>
       */
      public java.util.List<
              com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo
                  .FailureReason>
          getFailureReasonsList() {
        if (failureReasonsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(failureReasons_);
        } else {
          return failureReasonsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * List of failure reasons by corpus type (e.g. desktop, mobile).
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo.FailureReason failure_reasons = 2;
       * </code>
       */
      public int getFailureReasonsCount() {
        if (failureReasonsBuilder_ == null) {
          return failureReasons_.size();
        } else {
          return failureReasonsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * List of failure reasons by corpus type (e.g. desktop, mobile).
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo.FailureReason failure_reasons = 2;
       * </code>
       */
      public com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo.FailureReason
          getFailureReasons(int index) {
        if (failureReasonsBuilder_ == null) {
          return failureReasons_.get(index);
        } else {
          return failureReasonsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * List of failure reasons by corpus type (e.g. desktop, mobile).
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo.FailureReason failure_reasons = 2;
       * </code>
       */
      public Builder setFailureReasons(
          int index,
          com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo.FailureReason
              value) {
        if (failureReasonsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureFailureReasonsIsMutable();
          failureReasons_.set(index, value);
          onChanged();
        } else {
          failureReasonsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of failure reasons by corpus type (e.g. desktop, mobile).
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo.FailureReason failure_reasons = 2;
       * </code>
       */
      public Builder setFailureReasons(
          int index,
          com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo.FailureReason
                  .Builder
              builderForValue) {
        if (failureReasonsBuilder_ == null) {
          ensureFailureReasonsIsMutable();
          failureReasons_.set(index, builderForValue.build());
          onChanged();
        } else {
          failureReasonsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of failure reasons by corpus type (e.g. desktop, mobile).
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo.FailureReason failure_reasons = 2;
       * </code>
       */
      public Builder addFailureReasons(
          com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo.FailureReason
              value) {
        if (failureReasonsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureFailureReasonsIsMutable();
          failureReasons_.add(value);
          onChanged();
        } else {
          failureReasonsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of failure reasons by corpus type (e.g. desktop, mobile).
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo.FailureReason failure_reasons = 2;
       * </code>
       */
      public Builder addFailureReasons(
          int index,
          com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo.FailureReason
              value) {
        if (failureReasonsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureFailureReasonsIsMutable();
          failureReasons_.add(index, value);
          onChanged();
        } else {
          failureReasonsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of failure reasons by corpus type (e.g. desktop, mobile).
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo.FailureReason failure_reasons = 2;
       * </code>
       */
      public Builder addFailureReasons(
          com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo.FailureReason
                  .Builder
              builderForValue) {
        if (failureReasonsBuilder_ == null) {
          ensureFailureReasonsIsMutable();
          failureReasons_.add(builderForValue.build());
          onChanged();
        } else {
          failureReasonsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of failure reasons by corpus type (e.g. desktop, mobile).
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo.FailureReason failure_reasons = 2;
       * </code>
       */
      public Builder addFailureReasons(
          int index,
          com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo.FailureReason
                  .Builder
              builderForValue) {
        if (failureReasonsBuilder_ == null) {
          ensureFailureReasonsIsMutable();
          failureReasons_.add(index, builderForValue.build());
          onChanged();
        } else {
          failureReasonsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of failure reasons by corpus type (e.g. desktop, mobile).
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo.FailureReason failure_reasons = 2;
       * </code>
       */
      public Builder addAllFailureReasons(
          java.lang.Iterable<
                  ? extends
                      com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo
                          .FailureReason>
              values) {
        if (failureReasonsBuilder_ == null) {
          ensureFailureReasonsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, failureReasons_);
          onChanged();
        } else {
          failureReasonsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of failure reasons by corpus type (e.g. desktop, mobile).
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo.FailureReason failure_reasons = 2;
       * </code>
       */
      public Builder clearFailureReasons() {
        if (failureReasonsBuilder_ == null) {
          failureReasons_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
        } else {
          failureReasonsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of failure reasons by corpus type (e.g. desktop, mobile).
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo.FailureReason failure_reasons = 2;
       * </code>
       */
      public Builder removeFailureReasons(int index) {
        if (failureReasonsBuilder_ == null) {
          ensureFailureReasonsIsMutable();
          failureReasons_.remove(index);
          onChanged();
        } else {
          failureReasonsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of failure reasons by corpus type (e.g. desktop, mobile).
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo.FailureReason failure_reasons = 2;
       * </code>
       */
      public com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo.FailureReason
              .Builder
          getFailureReasonsBuilder(int index) {
        return getFailureReasonsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * List of failure reasons by corpus type (e.g. desktop, mobile).
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo.FailureReason failure_reasons = 2;
       * </code>
       */
      public com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo
              .FailureReasonOrBuilder
          getFailureReasonsOrBuilder(int index) {
        if (failureReasonsBuilder_ == null) {
          return failureReasons_.get(index);
        } else {
          return failureReasonsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * List of failure reasons by corpus type (e.g. desktop, mobile).
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo.FailureReason failure_reasons = 2;
       * </code>
       */
      public java.util.List<
              ? extends
                  com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo
                      .FailureReasonOrBuilder>
          getFailureReasonsOrBuilderList() {
        if (failureReasonsBuilder_ != null) {
          return failureReasonsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(failureReasons_);
        }
      }
      /**
       *
       *
       * <pre>
       * List of failure reasons by corpus type (e.g. desktop, mobile).
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo.FailureReason failure_reasons = 2;
       * </code>
       */
      public com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo.FailureReason
              .Builder
          addFailureReasonsBuilder() {
        return getFailureReasonsFieldBuilder()
            .addBuilder(
                com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo
                    .FailureReason.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * List of failure reasons by corpus type (e.g. desktop, mobile).
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo.FailureReason failure_reasons = 2;
       * </code>
       */
      public com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo.FailureReason
              .Builder
          addFailureReasonsBuilder(int index) {
        return getFailureReasonsFieldBuilder()
            .addBuilder(
                index,
                com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo
                    .FailureReason.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * List of failure reasons by corpus type (e.g. desktop, mobile).
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo.FailureReason failure_reasons = 2;
       * </code>
       */
      public java.util.List<
              com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo.FailureReason
                  .Builder>
          getFailureReasonsBuilderList() {
        return getFailureReasonsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo
                  .FailureReason,
              com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo.FailureReason
                  .Builder,
              com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo
                  .FailureReasonOrBuilder>
          getFailureReasonsFieldBuilder() {
        if (failureReasonsBuilder_ == null) {
          failureReasonsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo
                      .FailureReason,
                  com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo
                      .FailureReason.Builder,
                  com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo
                      .FailureReasonOrBuilder>(
                  failureReasons_,
                  ((bitField0_ & 0x00000002) != 0),
                  getParentForChildren(),
                  isClean());
          failureReasons_ = null;
        }
        return failureReasonsBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo)
    private static final com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo();
    }

    public static com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<FailureInfo> PARSER =
        new com.google.protobuf.AbstractParser<FailureInfo>() {
          @java.lang.Override
          public FailureInfo parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<FailureInfo> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<FailureInfo> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int FAILURE_SAMPLES_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo>
      failureSamples_;
  /**
   *
   *
   * <pre>
   * Details for a sample of up to 10 `failed_uris`.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo failure_samples = 1;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo>
      getFailureSamplesList() {
    return failureSamples_;
  }
  /**
   *
   *
   * <pre>
   * Details for a sample of up to 10 `failed_uris`.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo failure_samples = 1;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends
              com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfoOrBuilder>
      getFailureSamplesOrBuilderList() {
    return failureSamples_;
  }
  /**
   *
   *
   * <pre>
   * Details for a sample of up to 10 `failed_uris`.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo failure_samples = 1;
   * </code>
   */
  @java.lang.Override
  public int getFailureSamplesCount() {
    return failureSamples_.size();
  }
  /**
   *
   *
   * <pre>
   * Details for a sample of up to 10 `failed_uris`.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo failure_samples = 1;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo getFailureSamples(
      int index) {
    return failureSamples_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Details for a sample of up to 10 `failed_uris`.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo failure_samples = 1;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfoOrBuilder
      getFailureSamplesOrBuilder(int index) {
    return failureSamples_.get(index);
  }

  public static final int FAILED_URIS_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList failedUris_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * URIs that were not crawled before the LRO terminated.
   * </pre>
   *
   * <code>repeated string failed_uris = 2;</code>
   *
   * @return A list containing the failedUris.
   */
  public com.google.protobuf.ProtocolStringList getFailedUrisList() {
    return failedUris_;
  }
  /**
   *
   *
   * <pre>
   * URIs that were not crawled before the LRO terminated.
   * </pre>
   *
   * <code>repeated string failed_uris = 2;</code>
   *
   * @return The count of failedUris.
   */
  public int getFailedUrisCount() {
    return failedUris_.size();
  }
  /**
   *
   *
   * <pre>
   * URIs that were not crawled before the LRO terminated.
   * </pre>
   *
   * <code>repeated string failed_uris = 2;</code>
   *
   * @param index The index of the element to return.
   * @return The failedUris at the given index.
   */
  public java.lang.String getFailedUris(int index) {
    return failedUris_.get(index);
  }
  /**
   *
   *
   * <pre>
   * URIs that were not crawled before the LRO terminated.
   * </pre>
   *
   * <code>repeated string failed_uris = 2;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the failedUris at the given index.
   */
  public com.google.protobuf.ByteString getFailedUrisBytes(int index) {
    return failedUris_.getByteString(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < failureSamples_.size(); i++) {
      output.writeMessage(1, failureSamples_.get(i));
    }
    for (int i = 0; i < failedUris_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, failedUris_.getRaw(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < failureSamples_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, failureSamples_.get(i));
    }
    {
      int dataSize = 0;
      for (int i = 0; i < failedUris_.size(); i++) {
        dataSize += computeStringSizeNoTag(failedUris_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getFailedUrisList().size();
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse)) {
      return super.equals(obj);
    }
    com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse other =
        (com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse) obj;

    if (!getFailureSamplesList().equals(other.getFailureSamplesList())) return false;
    if (!getFailedUrisList().equals(other.getFailedUrisList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getFailureSamplesCount() > 0) {
      hash = (37 * hash) + FAILURE_SAMPLES_FIELD_NUMBER;
      hash = (53 * hash) + getFailureSamplesList().hashCode();
    }
    if (getFailedUrisCount() > 0) {
      hash = (37 * hash) + FAILED_URIS_FIELD_NUMBER;
      hash = (53 * hash) + getFailedUrisList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Response message for
   * [SiteSearchEngineService.RecrawlUris][google.cloud.discoveryengine.v1alpha.SiteSearchEngineService.RecrawlUris]
   * method.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse)
      com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1alpha.SiteSearchEngineServiceProto
          .internal_static_google_cloud_discoveryengine_v1alpha_RecrawlUrisResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1alpha.SiteSearchEngineServiceProto
          .internal_static_google_cloud_discoveryengine_v1alpha_RecrawlUrisResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.class,
              com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.Builder.class);
    }

    // Construct using com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (failureSamplesBuilder_ == null) {
        failureSamples_ = java.util.Collections.emptyList();
      } else {
        failureSamples_ = null;
        failureSamplesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      failedUris_ = com.google.protobuf.LazyStringArrayList.emptyList();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.discoveryengine.v1alpha.SiteSearchEngineServiceProto
          .internal_static_google_cloud_discoveryengine_v1alpha_RecrawlUrisResponse_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse
        getDefaultInstanceForType() {
      return com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse build() {
      com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse buildPartial() {
      com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse result =
          new com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse result) {
      if (failureSamplesBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          failureSamples_ = java.util.Collections.unmodifiableList(failureSamples_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.failureSamples_ = failureSamples_;
      } else {
        result.failureSamples_ = failureSamplesBuilder_.build();
      }
    }

    private void buildPartial0(
        com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        failedUris_.makeImmutable();
        result.failedUris_ = failedUris_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse) {
        return mergeFrom((com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse other) {
      if (other
          == com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.getDefaultInstance())
        return this;
      if (failureSamplesBuilder_ == null) {
        if (!other.failureSamples_.isEmpty()) {
          if (failureSamples_.isEmpty()) {
            failureSamples_ = other.failureSamples_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureFailureSamplesIsMutable();
            failureSamples_.addAll(other.failureSamples_);
          }
          onChanged();
        }
      } else {
        if (!other.failureSamples_.isEmpty()) {
          if (failureSamplesBuilder_.isEmpty()) {
            failureSamplesBuilder_.dispose();
            failureSamplesBuilder_ = null;
            failureSamples_ = other.failureSamples_;
            bitField0_ = (bitField0_ & ~0x00000001);
            failureSamplesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getFailureSamplesFieldBuilder()
                    : null;
          } else {
            failureSamplesBuilder_.addAllMessages(other.failureSamples_);
          }
        }
      }
      if (!other.failedUris_.isEmpty()) {
        if (failedUris_.isEmpty()) {
          failedUris_ = other.failedUris_;
          bitField0_ |= 0x00000002;
        } else {
          ensureFailedUrisIsMutable();
          failedUris_.addAll(other.failedUris_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo m =
                    input.readMessage(
                        com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo
                            .parser(),
                        extensionRegistry);
                if (failureSamplesBuilder_ == null) {
                  ensureFailureSamplesIsMutable();
                  failureSamples_.add(m);
                } else {
                  failureSamplesBuilder_.addMessage(m);
                }
                break;
              } // case 10
            case 18:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureFailedUrisIsMutable();
                failedUris_.add(s);
                break;
              } // case 18
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo>
        failureSamples_ = java.util.Collections.emptyList();

    private void ensureFailureSamplesIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        failureSamples_ =
            new java.util.ArrayList<
                com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo>(
                failureSamples_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo,
            com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo.Builder,
            com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfoOrBuilder>
        failureSamplesBuilder_;

    /**
     *
     *
     * <pre>
     * Details for a sample of up to 10 `failed_uris`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo failure_samples = 1;
     * </code>
     */
    public java.util.List<com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo>
        getFailureSamplesList() {
      if (failureSamplesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(failureSamples_);
      } else {
        return failureSamplesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Details for a sample of up to 10 `failed_uris`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo failure_samples = 1;
     * </code>
     */
    public int getFailureSamplesCount() {
      if (failureSamplesBuilder_ == null) {
        return failureSamples_.size();
      } else {
        return failureSamplesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Details for a sample of up to 10 `failed_uris`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo failure_samples = 1;
     * </code>
     */
    public com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo
        getFailureSamples(int index) {
      if (failureSamplesBuilder_ == null) {
        return failureSamples_.get(index);
      } else {
        return failureSamplesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Details for a sample of up to 10 `failed_uris`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo failure_samples = 1;
     * </code>
     */
    public Builder setFailureSamples(
        int index, com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo value) {
      if (failureSamplesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFailureSamplesIsMutable();
        failureSamples_.set(index, value);
        onChanged();
      } else {
        failureSamplesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details for a sample of up to 10 `failed_uris`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo failure_samples = 1;
     * </code>
     */
    public Builder setFailureSamples(
        int index,
        com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo.Builder
            builderForValue) {
      if (failureSamplesBuilder_ == null) {
        ensureFailureSamplesIsMutable();
        failureSamples_.set(index, builderForValue.build());
        onChanged();
      } else {
        failureSamplesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details for a sample of up to 10 `failed_uris`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo failure_samples = 1;
     * </code>
     */
    public Builder addFailureSamples(
        com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo value) {
      if (failureSamplesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFailureSamplesIsMutable();
        failureSamples_.add(value);
        onChanged();
      } else {
        failureSamplesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details for a sample of up to 10 `failed_uris`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo failure_samples = 1;
     * </code>
     */
    public Builder addFailureSamples(
        int index, com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo value) {
      if (failureSamplesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFailureSamplesIsMutable();
        failureSamples_.add(index, value);
        onChanged();
      } else {
        failureSamplesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details for a sample of up to 10 `failed_uris`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo failure_samples = 1;
     * </code>
     */
    public Builder addFailureSamples(
        com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo.Builder
            builderForValue) {
      if (failureSamplesBuilder_ == null) {
        ensureFailureSamplesIsMutable();
        failureSamples_.add(builderForValue.build());
        onChanged();
      } else {
        failureSamplesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details for a sample of up to 10 `failed_uris`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo failure_samples = 1;
     * </code>
     */
    public Builder addFailureSamples(
        int index,
        com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo.Builder
            builderForValue) {
      if (failureSamplesBuilder_ == null) {
        ensureFailureSamplesIsMutable();
        failureSamples_.add(index, builderForValue.build());
        onChanged();
      } else {
        failureSamplesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details for a sample of up to 10 `failed_uris`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo failure_samples = 1;
     * </code>
     */
    public Builder addAllFailureSamples(
        java.lang.Iterable<
                ? extends com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo>
            values) {
      if (failureSamplesBuilder_ == null) {
        ensureFailureSamplesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, failureSamples_);
        onChanged();
      } else {
        failureSamplesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details for a sample of up to 10 `failed_uris`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo failure_samples = 1;
     * </code>
     */
    public Builder clearFailureSamples() {
      if (failureSamplesBuilder_ == null) {
        failureSamples_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        failureSamplesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details for a sample of up to 10 `failed_uris`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo failure_samples = 1;
     * </code>
     */
    public Builder removeFailureSamples(int index) {
      if (failureSamplesBuilder_ == null) {
        ensureFailureSamplesIsMutable();
        failureSamples_.remove(index);
        onChanged();
      } else {
        failureSamplesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details for a sample of up to 10 `failed_uris`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo failure_samples = 1;
     * </code>
     */
    public com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo.Builder
        getFailureSamplesBuilder(int index) {
      return getFailureSamplesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Details for a sample of up to 10 `failed_uris`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo failure_samples = 1;
     * </code>
     */
    public com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfoOrBuilder
        getFailureSamplesOrBuilder(int index) {
      if (failureSamplesBuilder_ == null) {
        return failureSamples_.get(index);
      } else {
        return failureSamplesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Details for a sample of up to 10 `failed_uris`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo failure_samples = 1;
     * </code>
     */
    public java.util.List<
            ? extends
                com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfoOrBuilder>
        getFailureSamplesOrBuilderList() {
      if (failureSamplesBuilder_ != null) {
        return failureSamplesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(failureSamples_);
      }
    }
    /**
     *
     *
     * <pre>
     * Details for a sample of up to 10 `failed_uris`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo failure_samples = 1;
     * </code>
     */
    public com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo.Builder
        addFailureSamplesBuilder() {
      return getFailureSamplesFieldBuilder()
          .addBuilder(
              com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Details for a sample of up to 10 `failed_uris`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo failure_samples = 1;
     * </code>
     */
    public com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo.Builder
        addFailureSamplesBuilder(int index) {
      return getFailureSamplesFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Details for a sample of up to 10 `failed_uris`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo failure_samples = 1;
     * </code>
     */
    public java.util.List<
            com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo.Builder>
        getFailureSamplesBuilderList() {
      return getFailureSamplesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo,
            com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo.Builder,
            com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfoOrBuilder>
        getFailureSamplesFieldBuilder() {
      if (failureSamplesBuilder_ == null) {
        failureSamplesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo,
                com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo.Builder,
                com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfoOrBuilder>(
                failureSamples_,
                ((bitField0_ & 0x00000001) != 0),
                getParentForChildren(),
                isClean());
        failureSamples_ = null;
      }
      return failureSamplesBuilder_;
    }

    private com.google.protobuf.LazyStringArrayList failedUris_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureFailedUrisIsMutable() {
      if (!failedUris_.isModifiable()) {
        failedUris_ = new com.google.protobuf.LazyStringArrayList(failedUris_);
      }
      bitField0_ |= 0x00000002;
    }
    /**
     *
     *
     * <pre>
     * URIs that were not crawled before the LRO terminated.
     * </pre>
     *
     * <code>repeated string failed_uris = 2;</code>
     *
     * @return A list containing the failedUris.
     */
    public com.google.protobuf.ProtocolStringList getFailedUrisList() {
      failedUris_.makeImmutable();
      return failedUris_;
    }
    /**
     *
     *
     * <pre>
     * URIs that were not crawled before the LRO terminated.
     * </pre>
     *
     * <code>repeated string failed_uris = 2;</code>
     *
     * @return The count of failedUris.
     */
    public int getFailedUrisCount() {
      return failedUris_.size();
    }
    /**
     *
     *
     * <pre>
     * URIs that were not crawled before the LRO terminated.
     * </pre>
     *
     * <code>repeated string failed_uris = 2;</code>
     *
     * @param index The index of the element to return.
     * @return The failedUris at the given index.
     */
    public java.lang.String getFailedUris(int index) {
      return failedUris_.get(index);
    }
    /**
     *
     *
     * <pre>
     * URIs that were not crawled before the LRO terminated.
     * </pre>
     *
     * <code>repeated string failed_uris = 2;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the failedUris at the given index.
     */
    public com.google.protobuf.ByteString getFailedUrisBytes(int index) {
      return failedUris_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * URIs that were not crawled before the LRO terminated.
     * </pre>
     *
     * <code>repeated string failed_uris = 2;</code>
     *
     * @param index The index to set the value at.
     * @param value The failedUris to set.
     * @return This builder for chaining.
     */
    public Builder setFailedUris(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureFailedUrisIsMutable();
      failedUris_.set(index, value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URIs that were not crawled before the LRO terminated.
     * </pre>
     *
     * <code>repeated string failed_uris = 2;</code>
     *
     * @param value The failedUris to add.
     * @return This builder for chaining.
     */
    public Builder addFailedUris(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureFailedUrisIsMutable();
      failedUris_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URIs that were not crawled before the LRO terminated.
     * </pre>
     *
     * <code>repeated string failed_uris = 2;</code>
     *
     * @param values The failedUris to add.
     * @return This builder for chaining.
     */
    public Builder addAllFailedUris(java.lang.Iterable<java.lang.String> values) {
      ensureFailedUrisIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, failedUris_);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URIs that were not crawled before the LRO terminated.
     * </pre>
     *
     * <code>repeated string failed_uris = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFailedUris() {
      failedUris_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000002);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URIs that were not crawled before the LRO terminated.
     * </pre>
     *
     * <code>repeated string failed_uris = 2;</code>
     *
     * @param value The bytes of the failedUris to add.
     * @return This builder for chaining.
     */
    public Builder addFailedUrisBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureFailedUrisIsMutable();
      failedUris_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse)
  private static final com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse();
  }

  public static com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<RecrawlUrisResponse> PARSER =
      new com.google.protobuf.AbstractParser<RecrawlUrisResponse>() {
        @java.lang.Override
        public RecrawlUrisResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<RecrawlUrisResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<RecrawlUrisResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
