/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/discoveryengine/v1alpha/site_search_engine_service.proto

// Protobuf Java Version: 3.25.4
package com.google.cloud.discoveryengine.v1alpha;

/**
 *
 *
 * <pre>
 * Request message for
 * [SiteSearchEngineService.SetUriPatternDocumentData][google.cloud.discoveryengine.v1alpha.SiteSearchEngineService.SetUriPatternDocumentData]
 * method.
 * </pre>
 *
 * Protobuf type {@code google.cloud.discoveryengine.v1alpha.SetUriPatternDocumentDataRequest}
 */
public final class SetUriPatternDocumentDataRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1alpha.SetUriPatternDocumentDataRequest)
    SetUriPatternDocumentDataRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use SetUriPatternDocumentDataRequest.newBuilder() to construct.
  private SetUriPatternDocumentDataRequest(
      com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private SetUriPatternDocumentDataRequest() {
    siteSearchEngine_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new SetUriPatternDocumentDataRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.discoveryengine.v1alpha.SiteSearchEngineServiceProto
        .internal_static_google_cloud_discoveryengine_v1alpha_SetUriPatternDocumentDataRequest_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 2:
        return internalGetDocumentDataMap();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.discoveryengine.v1alpha.SiteSearchEngineServiceProto
        .internal_static_google_cloud_discoveryengine_v1alpha_SetUriPatternDocumentDataRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.discoveryengine.v1alpha.SetUriPatternDocumentDataRequest.class,
            com.google.cloud.discoveryengine.v1alpha.SetUriPatternDocumentDataRequest.Builder
                .class);
  }

  private int bitField0_;
  public static final int SITE_SEARCH_ENGINE_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object siteSearchEngine_ = "";
  /**
   *
   *
   * <pre>
   * Required. Full resource name of the
   * [SiteSearchEngine][google.cloud.discoveryengine.v1alpha.SiteSearchEngine],
   * such as
   * `projects/&#42;&#47;locations/&#42;&#47;collections/&#42;&#47;dataStores/&#42;&#47;siteSearchEngine`.
   * </pre>
   *
   * <code>
   * string site_search_engine = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The siteSearchEngine.
   */
  @java.lang.Override
  public java.lang.String getSiteSearchEngine() {
    java.lang.Object ref = siteSearchEngine_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      siteSearchEngine_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Full resource name of the
   * [SiteSearchEngine][google.cloud.discoveryengine.v1alpha.SiteSearchEngine],
   * such as
   * `projects/&#42;&#47;locations/&#42;&#47;collections/&#42;&#47;dataStores/&#42;&#47;siteSearchEngine`.
   * </pre>
   *
   * <code>
   * string site_search_engine = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for siteSearchEngine.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSiteSearchEngineBytes() {
    java.lang.Object ref = siteSearchEngine_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      siteSearchEngine_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DOCUMENT_DATA_MAP_FIELD_NUMBER = 2;

  private static final class DocumentDataMapDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, com.google.protobuf.Struct>
        defaultEntry =
            com.google.protobuf.MapEntry
                .<java.lang.String, com.google.protobuf.Struct>newDefaultInstance(
                    com.google.cloud.discoveryengine.v1alpha.SiteSearchEngineServiceProto
                        .internal_static_google_cloud_discoveryengine_v1alpha_SetUriPatternDocumentDataRequest_DocumentDataMapEntry_descriptor,
                    com.google.protobuf.WireFormat.FieldType.STRING,
                    "",
                    com.google.protobuf.WireFormat.FieldType.MESSAGE,
                    com.google.protobuf.Struct.getDefaultInstance());
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, com.google.protobuf.Struct>
      documentDataMap_;

  private com.google.protobuf.MapField<java.lang.String, com.google.protobuf.Struct>
      internalGetDocumentDataMap() {
    if (documentDataMap_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          DocumentDataMapDefaultEntryHolder.defaultEntry);
    }
    return documentDataMap_;
  }

  public int getDocumentDataMapCount() {
    return internalGetDocumentDataMap().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Document data keyed by URI pattern. Each entry must be consistent with
   * the [Schema][google.cloud.discoveryengine.v1alpha.Schema]. For example:
   * [Schema][google.cloud.discoveryengine.v1alpha.Schema] = {
   * "type": "object",
   * "properties": {
   *   "Categories": {
   *     "type": "array",
   *     "items": {
   *       "retrievable": true,
   *       "type": "string"
   *     }
   *   }
   * }
   *
   * document_data_map = {
   *   "www.url1.com/&#42;": {
   *     "Categories": ["category1", "category2"]
   *   },
   *   "www.url2.com/&#42;": {
   *     "Categories": ["category3"]
   *   }
   * }
   * </pre>
   *
   * <code>map&lt;string, .google.protobuf.Struct&gt; document_data_map = 2;</code>
   */
  @java.lang.Override
  public boolean containsDocumentDataMap(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetDocumentDataMap().getMap().containsKey(key);
  }
  /** Use {@link #getDocumentDataMapMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, com.google.protobuf.Struct> getDocumentDataMap() {
    return getDocumentDataMapMap();
  }
  /**
   *
   *
   * <pre>
   * Document data keyed by URI pattern. Each entry must be consistent with
   * the [Schema][google.cloud.discoveryengine.v1alpha.Schema]. For example:
   * [Schema][google.cloud.discoveryengine.v1alpha.Schema] = {
   * "type": "object",
   * "properties": {
   *   "Categories": {
   *     "type": "array",
   *     "items": {
   *       "retrievable": true,
   *       "type": "string"
   *     }
   *   }
   * }
   *
   * document_data_map = {
   *   "www.url1.com/&#42;": {
   *     "Categories": ["category1", "category2"]
   *   },
   *   "www.url2.com/&#42;": {
   *     "Categories": ["category3"]
   *   }
   * }
   * </pre>
   *
   * <code>map&lt;string, .google.protobuf.Struct&gt; document_data_map = 2;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, com.google.protobuf.Struct> getDocumentDataMapMap() {
    return internalGetDocumentDataMap().getMap();
  }
  /**
   *
   *
   * <pre>
   * Document data keyed by URI pattern. Each entry must be consistent with
   * the [Schema][google.cloud.discoveryengine.v1alpha.Schema]. For example:
   * [Schema][google.cloud.discoveryengine.v1alpha.Schema] = {
   * "type": "object",
   * "properties": {
   *   "Categories": {
   *     "type": "array",
   *     "items": {
   *       "retrievable": true,
   *       "type": "string"
   *     }
   *   }
   * }
   *
   * document_data_map = {
   *   "www.url1.com/&#42;": {
   *     "Categories": ["category1", "category2"]
   *   },
   *   "www.url2.com/&#42;": {
   *     "Categories": ["category3"]
   *   }
   * }
   * </pre>
   *
   * <code>map&lt;string, .google.protobuf.Struct&gt; document_data_map = 2;</code>
   */
  @java.lang.Override
  public /* nullable */ com.google.protobuf.Struct getDocumentDataMapOrDefault(
      java.lang.String key,
      /* nullable */
      com.google.protobuf.Struct defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.protobuf.Struct> map =
        internalGetDocumentDataMap().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Document data keyed by URI pattern. Each entry must be consistent with
   * the [Schema][google.cloud.discoveryengine.v1alpha.Schema]. For example:
   * [Schema][google.cloud.discoveryengine.v1alpha.Schema] = {
   * "type": "object",
   * "properties": {
   *   "Categories": {
   *     "type": "array",
   *     "items": {
   *       "retrievable": true,
   *       "type": "string"
   *     }
   *   }
   * }
   *
   * document_data_map = {
   *   "www.url1.com/&#42;": {
   *     "Categories": ["category1", "category2"]
   *   },
   *   "www.url2.com/&#42;": {
   *     "Categories": ["category3"]
   *   }
   * }
   * </pre>
   *
   * <code>map&lt;string, .google.protobuf.Struct&gt; document_data_map = 2;</code>
   */
  @java.lang.Override
  public com.google.protobuf.Struct getDocumentDataMapOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.protobuf.Struct> map =
        internalGetDocumentDataMap().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int EMPTY_DOCUMENT_DATA_MAP_FIELD_NUMBER = 4;
  private boolean emptyDocumentDataMap_ = false;
  /**
   *
   *
   * <pre>
   * If true, clears the document data map. If true,
   * [SetUriPatternDocumentDataRequest.document_data_map][google.cloud.discoveryengine.v1alpha.SetUriPatternDocumentDataRequest.document_data_map]
   * must be empty.
   * </pre>
   *
   * <code>bool empty_document_data_map = 4;</code>
   *
   * @return The emptyDocumentDataMap.
   */
  @java.lang.Override
  public boolean getEmptyDocumentDataMap() {
    return emptyDocumentDataMap_;
  }

  public static final int SCHEMA_FIELD_NUMBER = 3;
  private com.google.protobuf.Struct schema_;
  /**
   *
   *
   * <pre>
   * Optional. If not provided, the current
   * [Schema][google.cloud.discoveryengine.v1alpha.Schema] is used. If provided,
   * validates and updates the
   * [Schema][google.cloud.discoveryengine.v1alpha.Schema]. If validation fails,
   * an error is returned.
   * </pre>
   *
   * <code>.google.protobuf.Struct schema = 3;</code>
   *
   * @return Whether the schema field is set.
   */
  @java.lang.Override
  public boolean hasSchema() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. If not provided, the current
   * [Schema][google.cloud.discoveryengine.v1alpha.Schema] is used. If provided,
   * validates and updates the
   * [Schema][google.cloud.discoveryengine.v1alpha.Schema]. If validation fails,
   * an error is returned.
   * </pre>
   *
   * <code>.google.protobuf.Struct schema = 3;</code>
   *
   * @return The schema.
   */
  @java.lang.Override
  public com.google.protobuf.Struct getSchema() {
    return schema_ == null ? com.google.protobuf.Struct.getDefaultInstance() : schema_;
  }
  /**
   *
   *
   * <pre>
   * Optional. If not provided, the current
   * [Schema][google.cloud.discoveryengine.v1alpha.Schema] is used. If provided,
   * validates and updates the
   * [Schema][google.cloud.discoveryengine.v1alpha.Schema]. If validation fails,
   * an error is returned.
   * </pre>
   *
   * <code>.google.protobuf.Struct schema = 3;</code>
   */
  @java.lang.Override
  public com.google.protobuf.StructOrBuilder getSchemaOrBuilder() {
    return schema_ == null ? com.google.protobuf.Struct.getDefaultInstance() : schema_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(siteSearchEngine_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, siteSearchEngine_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetDocumentDataMap(), DocumentDataMapDefaultEntryHolder.defaultEntry, 2);
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3, getSchema());
    }
    if (emptyDocumentDataMap_ != false) {
      output.writeBool(4, emptyDocumentDataMap_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(siteSearchEngine_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, siteSearchEngine_);
    }
    for (java.util.Map.Entry<java.lang.String, com.google.protobuf.Struct> entry :
        internalGetDocumentDataMap().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, com.google.protobuf.Struct> documentDataMap__ =
          DocumentDataMapDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, documentDataMap__);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getSchema());
    }
    if (emptyDocumentDataMap_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(4, emptyDocumentDataMap_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj
        instanceof com.google.cloud.discoveryengine.v1alpha.SetUriPatternDocumentDataRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.discoveryengine.v1alpha.SetUriPatternDocumentDataRequest other =
        (com.google.cloud.discoveryengine.v1alpha.SetUriPatternDocumentDataRequest) obj;

    if (!getSiteSearchEngine().equals(other.getSiteSearchEngine())) return false;
    if (!internalGetDocumentDataMap().equals(other.internalGetDocumentDataMap())) return false;
    if (getEmptyDocumentDataMap() != other.getEmptyDocumentDataMap()) return false;
    if (hasSchema() != other.hasSchema()) return false;
    if (hasSchema()) {
      if (!getSchema().equals(other.getSchema())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + SITE_SEARCH_ENGINE_FIELD_NUMBER;
    hash = (53 * hash) + getSiteSearchEngine().hashCode();
    if (!internalGetDocumentDataMap().getMap().isEmpty()) {
      hash = (37 * hash) + DOCUMENT_DATA_MAP_FIELD_NUMBER;
      hash = (53 * hash) + internalGetDocumentDataMap().hashCode();
    }
    hash = (37 * hash) + EMPTY_DOCUMENT_DATA_MAP_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEmptyDocumentDataMap());
    if (hasSchema()) {
      hash = (37 * hash) + SCHEMA_FIELD_NUMBER;
      hash = (53 * hash) + getSchema().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.discoveryengine.v1alpha.SetUriPatternDocumentDataRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1alpha.SetUriPatternDocumentDataRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1alpha.SetUriPatternDocumentDataRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1alpha.SetUriPatternDocumentDataRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1alpha.SetUriPatternDocumentDataRequest parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1alpha.SetUriPatternDocumentDataRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1alpha.SetUriPatternDocumentDataRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1alpha.SetUriPatternDocumentDataRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1alpha.SetUriPatternDocumentDataRequest
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1alpha.SetUriPatternDocumentDataRequest
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1alpha.SetUriPatternDocumentDataRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1alpha.SetUriPatternDocumentDataRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.discoveryengine.v1alpha.SetUriPatternDocumentDataRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request message for
   * [SiteSearchEngineService.SetUriPatternDocumentData][google.cloud.discoveryengine.v1alpha.SiteSearchEngineService.SetUriPatternDocumentData]
   * method.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1alpha.SetUriPatternDocumentDataRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1alpha.SetUriPatternDocumentDataRequest)
      com.google.cloud.discoveryengine.v1alpha.SetUriPatternDocumentDataRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1alpha.SiteSearchEngineServiceProto
          .internal_static_google_cloud_discoveryengine_v1alpha_SetUriPatternDocumentDataRequest_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 2:
          return internalGetDocumentDataMap();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 2:
          return internalGetMutableDocumentDataMap();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1alpha.SiteSearchEngineServiceProto
          .internal_static_google_cloud_discoveryengine_v1alpha_SetUriPatternDocumentDataRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1alpha.SetUriPatternDocumentDataRequest.class,
              com.google.cloud.discoveryengine.v1alpha.SetUriPatternDocumentDataRequest.Builder
                  .class);
    }

    // Construct using
    // com.google.cloud.discoveryengine.v1alpha.SetUriPatternDocumentDataRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getSchemaFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      siteSearchEngine_ = "";
      internalGetMutableDocumentDataMap().clear();
      emptyDocumentDataMap_ = false;
      schema_ = null;
      if (schemaBuilder_ != null) {
        schemaBuilder_.dispose();
        schemaBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.discoveryengine.v1alpha.SiteSearchEngineServiceProto
          .internal_static_google_cloud_discoveryengine_v1alpha_SetUriPatternDocumentDataRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1alpha.SetUriPatternDocumentDataRequest
        getDefaultInstanceForType() {
      return com.google.cloud.discoveryengine.v1alpha.SetUriPatternDocumentDataRequest
          .getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1alpha.SetUriPatternDocumentDataRequest build() {
      com.google.cloud.discoveryengine.v1alpha.SetUriPatternDocumentDataRequest result =
          buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1alpha.SetUriPatternDocumentDataRequest
        buildPartial() {
      com.google.cloud.discoveryengine.v1alpha.SetUriPatternDocumentDataRequest result =
          new com.google.cloud.discoveryengine.v1alpha.SetUriPatternDocumentDataRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.discoveryengine.v1alpha.SetUriPatternDocumentDataRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.siteSearchEngine_ = siteSearchEngine_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.documentDataMap_ =
            internalGetDocumentDataMap().build(DocumentDataMapDefaultEntryHolder.defaultEntry);
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.emptyDocumentDataMap_ = emptyDocumentDataMap_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.schema_ = schemaBuilder_ == null ? schema_ : schemaBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other
          instanceof com.google.cloud.discoveryengine.v1alpha.SetUriPatternDocumentDataRequest) {
        return mergeFrom(
            (com.google.cloud.discoveryengine.v1alpha.SetUriPatternDocumentDataRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.discoveryengine.v1alpha.SetUriPatternDocumentDataRequest other) {
      if (other
          == com.google.cloud.discoveryengine.v1alpha.SetUriPatternDocumentDataRequest
              .getDefaultInstance()) return this;
      if (!other.getSiteSearchEngine().isEmpty()) {
        siteSearchEngine_ = other.siteSearchEngine_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      internalGetMutableDocumentDataMap().mergeFrom(other.internalGetDocumentDataMap());
      bitField0_ |= 0x00000002;
      if (other.getEmptyDocumentDataMap() != false) {
        setEmptyDocumentDataMap(other.getEmptyDocumentDataMap());
      }
      if (other.hasSchema()) {
        mergeSchema(other.getSchema());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                siteSearchEngine_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                com.google.protobuf.MapEntry<java.lang.String, com.google.protobuf.Struct>
                    documentDataMap__ =
                        input.readMessage(
                            DocumentDataMapDefaultEntryHolder.defaultEntry.getParserForType(),
                            extensionRegistry);
                internalGetMutableDocumentDataMap()
                    .ensureBuilderMap()
                    .put(documentDataMap__.getKey(), documentDataMap__.getValue());
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getSchemaFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 26
            case 32:
              {
                emptyDocumentDataMap_ = input.readBool();
                bitField0_ |= 0x00000004;
                break;
              } // case 32
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object siteSearchEngine_ = "";
    /**
     *
     *
     * <pre>
     * Required. Full resource name of the
     * [SiteSearchEngine][google.cloud.discoveryengine.v1alpha.SiteSearchEngine],
     * such as
     * `projects/&#42;&#47;locations/&#42;&#47;collections/&#42;&#47;dataStores/&#42;&#47;siteSearchEngine`.
     * </pre>
     *
     * <code>
     * string site_search_engine = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The siteSearchEngine.
     */
    public java.lang.String getSiteSearchEngine() {
      java.lang.Object ref = siteSearchEngine_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        siteSearchEngine_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Full resource name of the
     * [SiteSearchEngine][google.cloud.discoveryengine.v1alpha.SiteSearchEngine],
     * such as
     * `projects/&#42;&#47;locations/&#42;&#47;collections/&#42;&#47;dataStores/&#42;&#47;siteSearchEngine`.
     * </pre>
     *
     * <code>
     * string site_search_engine = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for siteSearchEngine.
     */
    public com.google.protobuf.ByteString getSiteSearchEngineBytes() {
      java.lang.Object ref = siteSearchEngine_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        siteSearchEngine_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Full resource name of the
     * [SiteSearchEngine][google.cloud.discoveryengine.v1alpha.SiteSearchEngine],
     * such as
     * `projects/&#42;&#47;locations/&#42;&#47;collections/&#42;&#47;dataStores/&#42;&#47;siteSearchEngine`.
     * </pre>
     *
     * <code>
     * string site_search_engine = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The siteSearchEngine to set.
     * @return This builder for chaining.
     */
    public Builder setSiteSearchEngine(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      siteSearchEngine_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Full resource name of the
     * [SiteSearchEngine][google.cloud.discoveryengine.v1alpha.SiteSearchEngine],
     * such as
     * `projects/&#42;&#47;locations/&#42;&#47;collections/&#42;&#47;dataStores/&#42;&#47;siteSearchEngine`.
     * </pre>
     *
     * <code>
     * string site_search_engine = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSiteSearchEngine() {
      siteSearchEngine_ = getDefaultInstance().getSiteSearchEngine();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Full resource name of the
     * [SiteSearchEngine][google.cloud.discoveryengine.v1alpha.SiteSearchEngine],
     * such as
     * `projects/&#42;&#47;locations/&#42;&#47;collections/&#42;&#47;dataStores/&#42;&#47;siteSearchEngine`.
     * </pre>
     *
     * <code>
     * string site_search_engine = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for siteSearchEngine to set.
     * @return This builder for chaining.
     */
    public Builder setSiteSearchEngineBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      siteSearchEngine_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private static final class DocumentDataMapConverter
        implements com.google.protobuf.MapFieldBuilder.Converter<
            java.lang.String, com.google.protobuf.StructOrBuilder, com.google.protobuf.Struct> {
      @java.lang.Override
      public com.google.protobuf.Struct build(com.google.protobuf.StructOrBuilder val) {
        if (val instanceof com.google.protobuf.Struct) {
          return (com.google.protobuf.Struct) val;
        }
        return ((com.google.protobuf.Struct.Builder) val).build();
      }

      @java.lang.Override
      public com.google.protobuf.MapEntry<java.lang.String, com.google.protobuf.Struct>
          defaultEntry() {
        return DocumentDataMapDefaultEntryHolder.defaultEntry;
      }
    };

    private static final DocumentDataMapConverter documentDataMapConverter =
        new DocumentDataMapConverter();

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.protobuf.StructOrBuilder,
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder>
        documentDataMap_;

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.protobuf.StructOrBuilder,
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder>
        internalGetDocumentDataMap() {
      if (documentDataMap_ == null) {
        return new com.google.protobuf.MapFieldBuilder<>(documentDataMapConverter);
      }
      return documentDataMap_;
    }

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.protobuf.StructOrBuilder,
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder>
        internalGetMutableDocumentDataMap() {
      if (documentDataMap_ == null) {
        documentDataMap_ = new com.google.protobuf.MapFieldBuilder<>(documentDataMapConverter);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return documentDataMap_;
    }

    public int getDocumentDataMapCount() {
      return internalGetDocumentDataMap().ensureBuilderMap().size();
    }
    /**
     *
     *
     * <pre>
     * Document data keyed by URI pattern. Each entry must be consistent with
     * the [Schema][google.cloud.discoveryengine.v1alpha.Schema]. For example:
     * [Schema][google.cloud.discoveryengine.v1alpha.Schema] = {
     * "type": "object",
     * "properties": {
     *   "Categories": {
     *     "type": "array",
     *     "items": {
     *       "retrievable": true,
     *       "type": "string"
     *     }
     *   }
     * }
     *
     * document_data_map = {
     *   "www.url1.com/&#42;": {
     *     "Categories": ["category1", "category2"]
     *   },
     *   "www.url2.com/&#42;": {
     *     "Categories": ["category3"]
     *   }
     * }
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Struct&gt; document_data_map = 2;</code>
     */
    @java.lang.Override
    public boolean containsDocumentDataMap(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetDocumentDataMap().ensureBuilderMap().containsKey(key);
    }
    /** Use {@link #getDocumentDataMapMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.protobuf.Struct> getDocumentDataMap() {
      return getDocumentDataMapMap();
    }
    /**
     *
     *
     * <pre>
     * Document data keyed by URI pattern. Each entry must be consistent with
     * the [Schema][google.cloud.discoveryengine.v1alpha.Schema]. For example:
     * [Schema][google.cloud.discoveryengine.v1alpha.Schema] = {
     * "type": "object",
     * "properties": {
     *   "Categories": {
     *     "type": "array",
     *     "items": {
     *       "retrievable": true,
     *       "type": "string"
     *     }
     *   }
     * }
     *
     * document_data_map = {
     *   "www.url1.com/&#42;": {
     *     "Categories": ["category1", "category2"]
     *   },
     *   "www.url2.com/&#42;": {
     *     "Categories": ["category3"]
     *   }
     * }
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Struct&gt; document_data_map = 2;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, com.google.protobuf.Struct> getDocumentDataMapMap() {
      return internalGetDocumentDataMap().getImmutableMap();
    }
    /**
     *
     *
     * <pre>
     * Document data keyed by URI pattern. Each entry must be consistent with
     * the [Schema][google.cloud.discoveryengine.v1alpha.Schema]. For example:
     * [Schema][google.cloud.discoveryengine.v1alpha.Schema] = {
     * "type": "object",
     * "properties": {
     *   "Categories": {
     *     "type": "array",
     *     "items": {
     *       "retrievable": true,
     *       "type": "string"
     *     }
     *   }
     * }
     *
     * document_data_map = {
     *   "www.url1.com/&#42;": {
     *     "Categories": ["category1", "category2"]
     *   },
     *   "www.url2.com/&#42;": {
     *     "Categories": ["category3"]
     *   }
     * }
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Struct&gt; document_data_map = 2;</code>
     */
    @java.lang.Override
    public /* nullable */ com.google.protobuf.Struct getDocumentDataMapOrDefault(
        java.lang.String key,
        /* nullable */
        com.google.protobuf.Struct defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.protobuf.StructOrBuilder> map =
          internalGetMutableDocumentDataMap().ensureBuilderMap();
      return map.containsKey(key) ? documentDataMapConverter.build(map.get(key)) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Document data keyed by URI pattern. Each entry must be consistent with
     * the [Schema][google.cloud.discoveryengine.v1alpha.Schema]. For example:
     * [Schema][google.cloud.discoveryengine.v1alpha.Schema] = {
     * "type": "object",
     * "properties": {
     *   "Categories": {
     *     "type": "array",
     *     "items": {
     *       "retrievable": true,
     *       "type": "string"
     *     }
     *   }
     * }
     *
     * document_data_map = {
     *   "www.url1.com/&#42;": {
     *     "Categories": ["category1", "category2"]
     *   },
     *   "www.url2.com/&#42;": {
     *     "Categories": ["category3"]
     *   }
     * }
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Struct&gt; document_data_map = 2;</code>
     */
    @java.lang.Override
    public com.google.protobuf.Struct getDocumentDataMapOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.protobuf.StructOrBuilder> map =
          internalGetMutableDocumentDataMap().ensureBuilderMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return documentDataMapConverter.build(map.get(key));
    }

    public Builder clearDocumentDataMap() {
      bitField0_ = (bitField0_ & ~0x00000002);
      internalGetMutableDocumentDataMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Document data keyed by URI pattern. Each entry must be consistent with
     * the [Schema][google.cloud.discoveryengine.v1alpha.Schema]. For example:
     * [Schema][google.cloud.discoveryengine.v1alpha.Schema] = {
     * "type": "object",
     * "properties": {
     *   "Categories": {
     *     "type": "array",
     *     "items": {
     *       "retrievable": true,
     *       "type": "string"
     *     }
     *   }
     * }
     *
     * document_data_map = {
     *   "www.url1.com/&#42;": {
     *     "Categories": ["category1", "category2"]
     *   },
     *   "www.url2.com/&#42;": {
     *     "Categories": ["category3"]
     *   }
     * }
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Struct&gt; document_data_map = 2;</code>
     */
    public Builder removeDocumentDataMap(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableDocumentDataMap().ensureBuilderMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.protobuf.Struct> getMutableDocumentDataMap() {
      bitField0_ |= 0x00000002;
      return internalGetMutableDocumentDataMap().ensureMessageMap();
    }
    /**
     *
     *
     * <pre>
     * Document data keyed by URI pattern. Each entry must be consistent with
     * the [Schema][google.cloud.discoveryengine.v1alpha.Schema]. For example:
     * [Schema][google.cloud.discoveryengine.v1alpha.Schema] = {
     * "type": "object",
     * "properties": {
     *   "Categories": {
     *     "type": "array",
     *     "items": {
     *       "retrievable": true,
     *       "type": "string"
     *     }
     *   }
     * }
     *
     * document_data_map = {
     *   "www.url1.com/&#42;": {
     *     "Categories": ["category1", "category2"]
     *   },
     *   "www.url2.com/&#42;": {
     *     "Categories": ["category3"]
     *   }
     * }
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Struct&gt; document_data_map = 2;</code>
     */
    public Builder putDocumentDataMap(java.lang.String key, com.google.protobuf.Struct value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableDocumentDataMap().ensureBuilderMap().put(key, value);
      bitField0_ |= 0x00000002;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Document data keyed by URI pattern. Each entry must be consistent with
     * the [Schema][google.cloud.discoveryengine.v1alpha.Schema]. For example:
     * [Schema][google.cloud.discoveryengine.v1alpha.Schema] = {
     * "type": "object",
     * "properties": {
     *   "Categories": {
     *     "type": "array",
     *     "items": {
     *       "retrievable": true,
     *       "type": "string"
     *     }
     *   }
     * }
     *
     * document_data_map = {
     *   "www.url1.com/&#42;": {
     *     "Categories": ["category1", "category2"]
     *   },
     *   "www.url2.com/&#42;": {
     *     "Categories": ["category3"]
     *   }
     * }
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Struct&gt; document_data_map = 2;</code>
     */
    public Builder putAllDocumentDataMap(
        java.util.Map<java.lang.String, com.google.protobuf.Struct> values) {
      for (java.util.Map.Entry<java.lang.String, com.google.protobuf.Struct> e :
          values.entrySet()) {
        if (e.getKey() == null || e.getValue() == null) {
          throw new NullPointerException();
        }
      }
      internalGetMutableDocumentDataMap().ensureBuilderMap().putAll(values);
      bitField0_ |= 0x00000002;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Document data keyed by URI pattern. Each entry must be consistent with
     * the [Schema][google.cloud.discoveryengine.v1alpha.Schema]. For example:
     * [Schema][google.cloud.discoveryengine.v1alpha.Schema] = {
     * "type": "object",
     * "properties": {
     *   "Categories": {
     *     "type": "array",
     *     "items": {
     *       "retrievable": true,
     *       "type": "string"
     *     }
     *   }
     * }
     *
     * document_data_map = {
     *   "www.url1.com/&#42;": {
     *     "Categories": ["category1", "category2"]
     *   },
     *   "www.url2.com/&#42;": {
     *     "Categories": ["category3"]
     *   }
     * }
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Struct&gt; document_data_map = 2;</code>
     */
    public com.google.protobuf.Struct.Builder putDocumentDataMapBuilderIfAbsent(
        java.lang.String key) {
      java.util.Map<java.lang.String, com.google.protobuf.StructOrBuilder> builderMap =
          internalGetMutableDocumentDataMap().ensureBuilderMap();
      com.google.protobuf.StructOrBuilder entry = builderMap.get(key);
      if (entry == null) {
        entry = com.google.protobuf.Struct.newBuilder();
        builderMap.put(key, entry);
      }
      if (entry instanceof com.google.protobuf.Struct) {
        entry = ((com.google.protobuf.Struct) entry).toBuilder();
        builderMap.put(key, entry);
      }
      return (com.google.protobuf.Struct.Builder) entry;
    }

    private boolean emptyDocumentDataMap_;
    /**
     *
     *
     * <pre>
     * If true, clears the document data map. If true,
     * [SetUriPatternDocumentDataRequest.document_data_map][google.cloud.discoveryengine.v1alpha.SetUriPatternDocumentDataRequest.document_data_map]
     * must be empty.
     * </pre>
     *
     * <code>bool empty_document_data_map = 4;</code>
     *
     * @return The emptyDocumentDataMap.
     */
    @java.lang.Override
    public boolean getEmptyDocumentDataMap() {
      return emptyDocumentDataMap_;
    }
    /**
     *
     *
     * <pre>
     * If true, clears the document data map. If true,
     * [SetUriPatternDocumentDataRequest.document_data_map][google.cloud.discoveryengine.v1alpha.SetUriPatternDocumentDataRequest.document_data_map]
     * must be empty.
     * </pre>
     *
     * <code>bool empty_document_data_map = 4;</code>
     *
     * @param value The emptyDocumentDataMap to set.
     * @return This builder for chaining.
     */
    public Builder setEmptyDocumentDataMap(boolean value) {

      emptyDocumentDataMap_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If true, clears the document data map. If true,
     * [SetUriPatternDocumentDataRequest.document_data_map][google.cloud.discoveryengine.v1alpha.SetUriPatternDocumentDataRequest.document_data_map]
     * must be empty.
     * </pre>
     *
     * <code>bool empty_document_data_map = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEmptyDocumentDataMap() {
      bitField0_ = (bitField0_ & ~0x00000004);
      emptyDocumentDataMap_ = false;
      onChanged();
      return this;
    }

    private com.google.protobuf.Struct schema_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder,
            com.google.protobuf.StructOrBuilder>
        schemaBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. If not provided, the current
     * [Schema][google.cloud.discoveryengine.v1alpha.Schema] is used. If provided,
     * validates and updates the
     * [Schema][google.cloud.discoveryengine.v1alpha.Schema]. If validation fails,
     * an error is returned.
     * </pre>
     *
     * <code>.google.protobuf.Struct schema = 3;</code>
     *
     * @return Whether the schema field is set.
     */
    public boolean hasSchema() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. If not provided, the current
     * [Schema][google.cloud.discoveryengine.v1alpha.Schema] is used. If provided,
     * validates and updates the
     * [Schema][google.cloud.discoveryengine.v1alpha.Schema]. If validation fails,
     * an error is returned.
     * </pre>
     *
     * <code>.google.protobuf.Struct schema = 3;</code>
     *
     * @return The schema.
     */
    public com.google.protobuf.Struct getSchema() {
      if (schemaBuilder_ == null) {
        return schema_ == null ? com.google.protobuf.Struct.getDefaultInstance() : schema_;
      } else {
        return schemaBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. If not provided, the current
     * [Schema][google.cloud.discoveryengine.v1alpha.Schema] is used. If provided,
     * validates and updates the
     * [Schema][google.cloud.discoveryengine.v1alpha.Schema]. If validation fails,
     * an error is returned.
     * </pre>
     *
     * <code>.google.protobuf.Struct schema = 3;</code>
     */
    public Builder setSchema(com.google.protobuf.Struct value) {
      if (schemaBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        schema_ = value;
      } else {
        schemaBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. If not provided, the current
     * [Schema][google.cloud.discoveryengine.v1alpha.Schema] is used. If provided,
     * validates and updates the
     * [Schema][google.cloud.discoveryengine.v1alpha.Schema]. If validation fails,
     * an error is returned.
     * </pre>
     *
     * <code>.google.protobuf.Struct schema = 3;</code>
     */
    public Builder setSchema(com.google.protobuf.Struct.Builder builderForValue) {
      if (schemaBuilder_ == null) {
        schema_ = builderForValue.build();
      } else {
        schemaBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. If not provided, the current
     * [Schema][google.cloud.discoveryengine.v1alpha.Schema] is used. If provided,
     * validates and updates the
     * [Schema][google.cloud.discoveryengine.v1alpha.Schema]. If validation fails,
     * an error is returned.
     * </pre>
     *
     * <code>.google.protobuf.Struct schema = 3;</code>
     */
    public Builder mergeSchema(com.google.protobuf.Struct value) {
      if (schemaBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && schema_ != null
            && schema_ != com.google.protobuf.Struct.getDefaultInstance()) {
          getSchemaBuilder().mergeFrom(value);
        } else {
          schema_ = value;
        }
      } else {
        schemaBuilder_.mergeFrom(value);
      }
      if (schema_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. If not provided, the current
     * [Schema][google.cloud.discoveryengine.v1alpha.Schema] is used. If provided,
     * validates and updates the
     * [Schema][google.cloud.discoveryengine.v1alpha.Schema]. If validation fails,
     * an error is returned.
     * </pre>
     *
     * <code>.google.protobuf.Struct schema = 3;</code>
     */
    public Builder clearSchema() {
      bitField0_ = (bitField0_ & ~0x00000008);
      schema_ = null;
      if (schemaBuilder_ != null) {
        schemaBuilder_.dispose();
        schemaBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. If not provided, the current
     * [Schema][google.cloud.discoveryengine.v1alpha.Schema] is used. If provided,
     * validates and updates the
     * [Schema][google.cloud.discoveryengine.v1alpha.Schema]. If validation fails,
     * an error is returned.
     * </pre>
     *
     * <code>.google.protobuf.Struct schema = 3;</code>
     */
    public com.google.protobuf.Struct.Builder getSchemaBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getSchemaFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. If not provided, the current
     * [Schema][google.cloud.discoveryengine.v1alpha.Schema] is used. If provided,
     * validates and updates the
     * [Schema][google.cloud.discoveryengine.v1alpha.Schema]. If validation fails,
     * an error is returned.
     * </pre>
     *
     * <code>.google.protobuf.Struct schema = 3;</code>
     */
    public com.google.protobuf.StructOrBuilder getSchemaOrBuilder() {
      if (schemaBuilder_ != null) {
        return schemaBuilder_.getMessageOrBuilder();
      } else {
        return schema_ == null ? com.google.protobuf.Struct.getDefaultInstance() : schema_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. If not provided, the current
     * [Schema][google.cloud.discoveryengine.v1alpha.Schema] is used. If provided,
     * validates and updates the
     * [Schema][google.cloud.discoveryengine.v1alpha.Schema]. If validation fails,
     * an error is returned.
     * </pre>
     *
     * <code>.google.protobuf.Struct schema = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder,
            com.google.protobuf.StructOrBuilder>
        getSchemaFieldBuilder() {
      if (schemaBuilder_ == null) {
        schemaBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Struct,
                com.google.protobuf.Struct.Builder,
                com.google.protobuf.StructOrBuilder>(
                getSchema(), getParentForChildren(), isClean());
        schema_ = null;
      }
      return schemaBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1alpha.SetUriPatternDocumentDataRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1alpha.SetUriPatternDocumentDataRequest)
  private static final com.google.cloud.discoveryengine.v1alpha.SetUriPatternDocumentDataRequest
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE =
        new com.google.cloud.discoveryengine.v1alpha.SetUriPatternDocumentDataRequest();
  }

  public static com.google.cloud.discoveryengine.v1alpha.SetUriPatternDocumentDataRequest
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<SetUriPatternDocumentDataRequest> PARSER =
      new com.google.protobuf.AbstractParser<SetUriPatternDocumentDataRequest>() {
        @java.lang.Override
        public SetUriPatternDocumentDataRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<SetUriPatternDocumentDataRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SetUriPatternDocumentDataRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.discoveryengine.v1alpha.SetUriPatternDocumentDataRequest
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
