/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/discoveryengine/v1beta/conversational_search_service.proto

package com.google.cloud.discoveryengine.v1beta;

/**
 *
 *
 * <pre>
 * Request message for
 * [ConversationalSearchService.ConverseConversation][google.cloud.discoveryengine.v1beta.ConversationalSearchService.ConverseConversation]
 * method.
 * </pre>
 *
 * Protobuf type {@code google.cloud.discoveryengine.v1beta.ConverseConversationRequest}
 */
public final class ConverseConversationRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.ConverseConversationRequest)
    ConverseConversationRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ConverseConversationRequest.newBuilder() to construct.
  private ConverseConversationRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ConverseConversationRequest() {
    name_ = "";
    servingConfig_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ConverseConversationRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.discoveryengine.v1beta.ConversationalSearchServiceProto
        .internal_static_google_cloud_discoveryengine_v1beta_ConverseConversationRequest_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 7:
        return internalGetUserLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.discoveryengine.v1beta.ConversationalSearchServiceProto
        .internal_static_google_cloud_discoveryengine_v1beta_ConverseConversationRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.discoveryengine.v1beta.ConverseConversationRequest.class,
            com.google.cloud.discoveryengine.v1beta.ConverseConversationRequest.Builder.class);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Required. The resource name of the Conversation to get. Format:
   * `projects/{project_number}/locations/{location_id}/collections/{collection}/dataStores/{data_store_id}/conversations/{conversation_id}`.
   * Use
   * `projects/{project_number}/locations/{location_id}/collections/{collection}/dataStores/{data_store_id}/conversations/-`
   * to activate auto session mode, which automatically creates a new
   * conversation inside a ConverseConversation session.
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The resource name of the Conversation to get. Format:
   * `projects/{project_number}/locations/{location_id}/collections/{collection}/dataStores/{data_store_id}/conversations/{conversation_id}`.
   * Use
   * `projects/{project_number}/locations/{location_id}/collections/{collection}/dataStores/{data_store_id}/conversations/-`
   * to activate auto session mode, which automatically creates a new
   * conversation inside a ConverseConversation session.
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int QUERY_FIELD_NUMBER = 2;
  private com.google.cloud.discoveryengine.v1beta.TextInput query_;
  /**
   *
   *
   * <pre>
   * Required. Current user input.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1beta.TextInput query = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the query field is set.
   */
  @java.lang.Override
  public boolean hasQuery() {
    return query_ != null;
  }
  /**
   *
   *
   * <pre>
   * Required. Current user input.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1beta.TextInput query = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The query.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.TextInput getQuery() {
    return query_ == null
        ? com.google.cloud.discoveryengine.v1beta.TextInput.getDefaultInstance()
        : query_;
  }
  /**
   *
   *
   * <pre>
   * Required. Current user input.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1beta.TextInput query = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.TextInputOrBuilder getQueryOrBuilder() {
    return query_ == null
        ? com.google.cloud.discoveryengine.v1beta.TextInput.getDefaultInstance()
        : query_;
  }

  public static final int SERVING_CONFIG_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object servingConfig_ = "";
  /**
   *
   *
   * <pre>
   * The resource name of the Serving Config to use. Format:
   * `projects/{project_number}/locations/{location_id}/collections/{collection}/dataStores/{data_store_id}/servingConfigs/{serving_config_id}`
   * If this is not set, the default serving config will be used.
   * </pre>
   *
   * <code>string serving_config = 3 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The servingConfig.
   */
  @java.lang.Override
  public java.lang.String getServingConfig() {
    java.lang.Object ref = servingConfig_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      servingConfig_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The resource name of the Serving Config to use. Format:
   * `projects/{project_number}/locations/{location_id}/collections/{collection}/dataStores/{data_store_id}/servingConfigs/{serving_config_id}`
   * If this is not set, the default serving config will be used.
   * </pre>
   *
   * <code>string serving_config = 3 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for servingConfig.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getServingConfigBytes() {
    java.lang.Object ref = servingConfig_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      servingConfig_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CONVERSATION_FIELD_NUMBER = 5;
  private com.google.cloud.discoveryengine.v1beta.Conversation conversation_;
  /**
   *
   *
   * <pre>
   * The conversation to be used by auto session only. The name field will be
   * ignored as we automatically assign new name for the conversation in auto
   * session.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.Conversation conversation = 5;</code>
   *
   * @return Whether the conversation field is set.
   */
  @java.lang.Override
  public boolean hasConversation() {
    return conversation_ != null;
  }
  /**
   *
   *
   * <pre>
   * The conversation to be used by auto session only. The name field will be
   * ignored as we automatically assign new name for the conversation in auto
   * session.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.Conversation conversation = 5;</code>
   *
   * @return The conversation.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.Conversation getConversation() {
    return conversation_ == null
        ? com.google.cloud.discoveryengine.v1beta.Conversation.getDefaultInstance()
        : conversation_;
  }
  /**
   *
   *
   * <pre>
   * The conversation to be used by auto session only. The name field will be
   * ignored as we automatically assign new name for the conversation in auto
   * session.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.Conversation conversation = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.ConversationOrBuilder getConversationOrBuilder() {
    return conversation_ == null
        ? com.google.cloud.discoveryengine.v1beta.Conversation.getDefaultInstance()
        : conversation_;
  }

  public static final int SAFE_SEARCH_FIELD_NUMBER = 6;
  private boolean safeSearch_ = false;
  /**
   *
   *
   * <pre>
   * Whether to turn on safe search.
   * </pre>
   *
   * <code>bool safe_search = 6;</code>
   *
   * @return The safeSearch.
   */
  @java.lang.Override
  public boolean getSafeSearch() {
    return safeSearch_;
  }

  public static final int USER_LABELS_FIELD_NUMBER = 7;

  private static final class UserLabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.discoveryengine.v1beta.ConversationalSearchServiceProto
                .internal_static_google_cloud_discoveryengine_v1beta_ConverseConversationRequest_UserLabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> userLabels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetUserLabels() {
    if (userLabels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(UserLabelsDefaultEntryHolder.defaultEntry);
    }
    return userLabels_;
  }

  public int getUserLabelsCount() {
    return internalGetUserLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * The user labels applied to a resource must meet the following requirements:
   *
   * * Each resource can have multiple labels, up to a maximum of 64.
   * * Each label must be a key-value pair.
   * * Keys have a minimum length of 1 character and a maximum length of 63
   *   characters and cannot be empty. Values can be empty and have a maximum
   *   length of 63 characters.
   * * Keys and values can contain only lowercase letters, numeric characters,
   *   underscores, and dashes. All characters must use UTF-8 encoding, and
   *   international characters are allowed.
   * * The key portion of a label must be unique. However, you can use the same
   *   key with multiple resources.
   * * Keys must start with a lowercase letter or international character.
   *
   * See [Google Cloud
   * Document](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
   * for more details.
   * </pre>
   *
   * <code>map&lt;string, string&gt; user_labels = 7;</code>
   */
  @java.lang.Override
  public boolean containsUserLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetUserLabels().getMap().containsKey(key);
  }
  /** Use {@link #getUserLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getUserLabels() {
    return getUserLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * The user labels applied to a resource must meet the following requirements:
   *
   * * Each resource can have multiple labels, up to a maximum of 64.
   * * Each label must be a key-value pair.
   * * Keys have a minimum length of 1 character and a maximum length of 63
   *   characters and cannot be empty. Values can be empty and have a maximum
   *   length of 63 characters.
   * * Keys and values can contain only lowercase letters, numeric characters,
   *   underscores, and dashes. All characters must use UTF-8 encoding, and
   *   international characters are allowed.
   * * The key portion of a label must be unique. However, you can use the same
   *   key with multiple resources.
   * * Keys must start with a lowercase letter or international character.
   *
   * See [Google Cloud
   * Document](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
   * for more details.
   * </pre>
   *
   * <code>map&lt;string, string&gt; user_labels = 7;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getUserLabelsMap() {
    return internalGetUserLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * The user labels applied to a resource must meet the following requirements:
   *
   * * Each resource can have multiple labels, up to a maximum of 64.
   * * Each label must be a key-value pair.
   * * Keys have a minimum length of 1 character and a maximum length of 63
   *   characters and cannot be empty. Values can be empty and have a maximum
   *   length of 63 characters.
   * * Keys and values can contain only lowercase letters, numeric characters,
   *   underscores, and dashes. All characters must use UTF-8 encoding, and
   *   international characters are allowed.
   * * The key portion of a label must be unique. However, you can use the same
   *   key with multiple resources.
   * * Keys must start with a lowercase letter or international character.
   *
   * See [Google Cloud
   * Document](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
   * for more details.
   * </pre>
   *
   * <code>map&lt;string, string&gt; user_labels = 7;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getUserLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetUserLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * The user labels applied to a resource must meet the following requirements:
   *
   * * Each resource can have multiple labels, up to a maximum of 64.
   * * Each label must be a key-value pair.
   * * Keys have a minimum length of 1 character and a maximum length of 63
   *   characters and cannot be empty. Values can be empty and have a maximum
   *   length of 63 characters.
   * * Keys and values can contain only lowercase letters, numeric characters,
   *   underscores, and dashes. All characters must use UTF-8 encoding, and
   *   international characters are allowed.
   * * The key portion of a label must be unique. However, you can use the same
   *   key with multiple resources.
   * * Keys must start with a lowercase letter or international character.
   *
   * See [Google Cloud
   * Document](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
   * for more details.
   * </pre>
   *
   * <code>map&lt;string, string&gt; user_labels = 7;</code>
   */
  @java.lang.Override
  public java.lang.String getUserLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetUserLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int SUMMARY_SPEC_FIELD_NUMBER = 8;
  private com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec
      summarySpec_;
  /**
   *
   *
   * <pre>
   * A specification for configuring the summary returned in the response.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec summary_spec = 8;
   * </code>
   *
   * @return Whether the summarySpec field is set.
   */
  @java.lang.Override
  public boolean hasSummarySpec() {
    return summarySpec_ != null;
  }
  /**
   *
   *
   * <pre>
   * A specification for configuring the summary returned in the response.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec summary_spec = 8;
   * </code>
   *
   * @return The summarySpec.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec
      getSummarySpec() {
    return summarySpec_ == null
        ? com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec
            .getDefaultInstance()
        : summarySpec_;
  }
  /**
   *
   *
   * <pre>
   * A specification for configuring the summary returned in the response.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec summary_spec = 8;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
          .SummarySpecOrBuilder
      getSummarySpecOrBuilder() {
    return summarySpec_ == null
        ? com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec
            .getDefaultInstance()
        : summarySpec_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (query_ != null) {
      output.writeMessage(2, getQuery());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(servingConfig_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, servingConfig_);
    }
    if (conversation_ != null) {
      output.writeMessage(5, getConversation());
    }
    if (safeSearch_ != false) {
      output.writeBool(6, safeSearch_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetUserLabels(), UserLabelsDefaultEntryHolder.defaultEntry, 7);
    if (summarySpec_ != null) {
      output.writeMessage(8, getSummarySpec());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (query_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getQuery());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(servingConfig_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, servingConfig_);
    }
    if (conversation_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getConversation());
    }
    if (safeSearch_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(6, safeSearch_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetUserLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> userLabels__ =
          UserLabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, userLabels__);
    }
    if (summarySpec_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getSummarySpec());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.discoveryengine.v1beta.ConverseConversationRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.discoveryengine.v1beta.ConverseConversationRequest other =
        (com.google.cloud.discoveryengine.v1beta.ConverseConversationRequest) obj;

    if (!getName().equals(other.getName())) return false;
    if (hasQuery() != other.hasQuery()) return false;
    if (hasQuery()) {
      if (!getQuery().equals(other.getQuery())) return false;
    }
    if (!getServingConfig().equals(other.getServingConfig())) return false;
    if (hasConversation() != other.hasConversation()) return false;
    if (hasConversation()) {
      if (!getConversation().equals(other.getConversation())) return false;
    }
    if (getSafeSearch() != other.getSafeSearch()) return false;
    if (!internalGetUserLabels().equals(other.internalGetUserLabels())) return false;
    if (hasSummarySpec() != other.hasSummarySpec()) return false;
    if (hasSummarySpec()) {
      if (!getSummarySpec().equals(other.getSummarySpec())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasQuery()) {
      hash = (37 * hash) + QUERY_FIELD_NUMBER;
      hash = (53 * hash) + getQuery().hashCode();
    }
    hash = (37 * hash) + SERVING_CONFIG_FIELD_NUMBER;
    hash = (53 * hash) + getServingConfig().hashCode();
    if (hasConversation()) {
      hash = (37 * hash) + CONVERSATION_FIELD_NUMBER;
      hash = (53 * hash) + getConversation().hashCode();
    }
    hash = (37 * hash) + SAFE_SEARCH_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getSafeSearch());
    if (!internalGetUserLabels().getMap().isEmpty()) {
      hash = (37 * hash) + USER_LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetUserLabels().hashCode();
    }
    if (hasSummarySpec()) {
      hash = (37 * hash) + SUMMARY_SPEC_FIELD_NUMBER;
      hash = (53 * hash) + getSummarySpec().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.discoveryengine.v1beta.ConverseConversationRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1beta.ConverseConversationRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.ConverseConversationRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1beta.ConverseConversationRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.ConverseConversationRequest parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1beta.ConverseConversationRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.ConverseConversationRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1beta.ConverseConversationRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.ConverseConversationRequest
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1beta.ConverseConversationRequest
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.ConverseConversationRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1beta.ConverseConversationRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.discoveryengine.v1beta.ConverseConversationRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request message for
   * [ConversationalSearchService.ConverseConversation][google.cloud.discoveryengine.v1beta.ConversationalSearchService.ConverseConversation]
   * method.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1beta.ConverseConversationRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.ConverseConversationRequest)
      com.google.cloud.discoveryengine.v1beta.ConverseConversationRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1beta.ConversationalSearchServiceProto
          .internal_static_google_cloud_discoveryengine_v1beta_ConverseConversationRequest_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 7:
          return internalGetUserLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 7:
          return internalGetMutableUserLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1beta.ConversationalSearchServiceProto
          .internal_static_google_cloud_discoveryengine_v1beta_ConverseConversationRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1beta.ConverseConversationRequest.class,
              com.google.cloud.discoveryengine.v1beta.ConverseConversationRequest.Builder.class);
    }

    // Construct using
    // com.google.cloud.discoveryengine.v1beta.ConverseConversationRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      query_ = null;
      if (queryBuilder_ != null) {
        queryBuilder_.dispose();
        queryBuilder_ = null;
      }
      servingConfig_ = "";
      conversation_ = null;
      if (conversationBuilder_ != null) {
        conversationBuilder_.dispose();
        conversationBuilder_ = null;
      }
      safeSearch_ = false;
      internalGetMutableUserLabels().clear();
      summarySpec_ = null;
      if (summarySpecBuilder_ != null) {
        summarySpecBuilder_.dispose();
        summarySpecBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.discoveryengine.v1beta.ConversationalSearchServiceProto
          .internal_static_google_cloud_discoveryengine_v1beta_ConverseConversationRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.ConverseConversationRequest
        getDefaultInstanceForType() {
      return com.google.cloud.discoveryengine.v1beta.ConverseConversationRequest
          .getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.ConverseConversationRequest build() {
      com.google.cloud.discoveryengine.v1beta.ConverseConversationRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.ConverseConversationRequest buildPartial() {
      com.google.cloud.discoveryengine.v1beta.ConverseConversationRequest result =
          new com.google.cloud.discoveryengine.v1beta.ConverseConversationRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.discoveryengine.v1beta.ConverseConversationRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.query_ = queryBuilder_ == null ? query_ : queryBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.servingConfig_ = servingConfig_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.conversation_ =
            conversationBuilder_ == null ? conversation_ : conversationBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.safeSearch_ = safeSearch_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.userLabels_ = internalGetUserLabels();
        result.userLabels_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.summarySpec_ =
            summarySpecBuilder_ == null ? summarySpec_ : summarySpecBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.discoveryengine.v1beta.ConverseConversationRequest) {
        return mergeFrom(
            (com.google.cloud.discoveryengine.v1beta.ConverseConversationRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.discoveryengine.v1beta.ConverseConversationRequest other) {
      if (other
          == com.google.cloud.discoveryengine.v1beta.ConverseConversationRequest
              .getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasQuery()) {
        mergeQuery(other.getQuery());
      }
      if (!other.getServingConfig().isEmpty()) {
        servingConfig_ = other.servingConfig_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasConversation()) {
        mergeConversation(other.getConversation());
      }
      if (other.getSafeSearch() != false) {
        setSafeSearch(other.getSafeSearch());
      }
      internalGetMutableUserLabels().mergeFrom(other.internalGetUserLabels());
      bitField0_ |= 0x00000020;
      if (other.hasSummarySpec()) {
        mergeSummarySpec(other.getSummarySpec());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getQueryFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                servingConfig_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 42:
              {
                input.readMessage(getConversationFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 42
            case 48:
              {
                safeSearch_ = input.readBool();
                bitField0_ |= 0x00000010;
                break;
              } // case 48
            case 58:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> userLabels__ =
                    input.readMessage(
                        UserLabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableUserLabels()
                    .getMutableMap()
                    .put(userLabels__.getKey(), userLabels__.getValue());
                bitField0_ |= 0x00000020;
                break;
              } // case 58
            case 66:
              {
                input.readMessage(getSummarySpecFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 66
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Required. The resource name of the Conversation to get. Format:
     * `projects/{project_number}/locations/{location_id}/collections/{collection}/dataStores/{data_store_id}/conversations/{conversation_id}`.
     * Use
     * `projects/{project_number}/locations/{location_id}/collections/{collection}/dataStores/{data_store_id}/conversations/-`
     * to activate auto session mode, which automatically creates a new
     * conversation inside a ConverseConversation session.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the Conversation to get. Format:
     * `projects/{project_number}/locations/{location_id}/collections/{collection}/dataStores/{data_store_id}/conversations/{conversation_id}`.
     * Use
     * `projects/{project_number}/locations/{location_id}/collections/{collection}/dataStores/{data_store_id}/conversations/-`
     * to activate auto session mode, which automatically creates a new
     * conversation inside a ConverseConversation session.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the Conversation to get. Format:
     * `projects/{project_number}/locations/{location_id}/collections/{collection}/dataStores/{data_store_id}/conversations/{conversation_id}`.
     * Use
     * `projects/{project_number}/locations/{location_id}/collections/{collection}/dataStores/{data_store_id}/conversations/-`
     * to activate auto session mode, which automatically creates a new
     * conversation inside a ConverseConversation session.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the Conversation to get. Format:
     * `projects/{project_number}/locations/{location_id}/collections/{collection}/dataStores/{data_store_id}/conversations/{conversation_id}`.
     * Use
     * `projects/{project_number}/locations/{location_id}/collections/{collection}/dataStores/{data_store_id}/conversations/-`
     * to activate auto session mode, which automatically creates a new
     * conversation inside a ConverseConversation session.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the Conversation to get. Format:
     * `projects/{project_number}/locations/{location_id}/collections/{collection}/dataStores/{data_store_id}/conversations/{conversation_id}`.
     * Use
     * `projects/{project_number}/locations/{location_id}/collections/{collection}/dataStores/{data_store_id}/conversations/-`
     * to activate auto session mode, which automatically creates a new
     * conversation inside a ConverseConversation session.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.cloud.discoveryengine.v1beta.TextInput query_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1beta.TextInput,
            com.google.cloud.discoveryengine.v1beta.TextInput.Builder,
            com.google.cloud.discoveryengine.v1beta.TextInputOrBuilder>
        queryBuilder_;
    /**
     *
     *
     * <pre>
     * Required. Current user input.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.TextInput query = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the query field is set.
     */
    public boolean hasQuery() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. Current user input.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.TextInput query = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The query.
     */
    public com.google.cloud.discoveryengine.v1beta.TextInput getQuery() {
      if (queryBuilder_ == null) {
        return query_ == null
            ? com.google.cloud.discoveryengine.v1beta.TextInput.getDefaultInstance()
            : query_;
      } else {
        return queryBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Current user input.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.TextInput query = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setQuery(com.google.cloud.discoveryengine.v1beta.TextInput value) {
      if (queryBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        query_ = value;
      } else {
        queryBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Current user input.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.TextInput query = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setQuery(
        com.google.cloud.discoveryengine.v1beta.TextInput.Builder builderForValue) {
      if (queryBuilder_ == null) {
        query_ = builderForValue.build();
      } else {
        queryBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Current user input.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.TextInput query = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeQuery(com.google.cloud.discoveryengine.v1beta.TextInput value) {
      if (queryBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && query_ != null
            && query_ != com.google.cloud.discoveryengine.v1beta.TextInput.getDefaultInstance()) {
          getQueryBuilder().mergeFrom(value);
        } else {
          query_ = value;
        }
      } else {
        queryBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Current user input.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.TextInput query = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearQuery() {
      bitField0_ = (bitField0_ & ~0x00000002);
      query_ = null;
      if (queryBuilder_ != null) {
        queryBuilder_.dispose();
        queryBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Current user input.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.TextInput query = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.discoveryengine.v1beta.TextInput.Builder getQueryBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getQueryFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. Current user input.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.TextInput query = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.discoveryengine.v1beta.TextInputOrBuilder getQueryOrBuilder() {
      if (queryBuilder_ != null) {
        return queryBuilder_.getMessageOrBuilder();
      } else {
        return query_ == null
            ? com.google.cloud.discoveryengine.v1beta.TextInput.getDefaultInstance()
            : query_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Current user input.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.TextInput query = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1beta.TextInput,
            com.google.cloud.discoveryengine.v1beta.TextInput.Builder,
            com.google.cloud.discoveryengine.v1beta.TextInputOrBuilder>
        getQueryFieldBuilder() {
      if (queryBuilder_ == null) {
        queryBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1beta.TextInput,
                com.google.cloud.discoveryengine.v1beta.TextInput.Builder,
                com.google.cloud.discoveryengine.v1beta.TextInputOrBuilder>(
                getQuery(), getParentForChildren(), isClean());
        query_ = null;
      }
      return queryBuilder_;
    }

    private java.lang.Object servingConfig_ = "";
    /**
     *
     *
     * <pre>
     * The resource name of the Serving Config to use. Format:
     * `projects/{project_number}/locations/{location_id}/collections/{collection}/dataStores/{data_store_id}/servingConfigs/{serving_config_id}`
     * If this is not set, the default serving config will be used.
     * </pre>
     *
     * <code>string serving_config = 3 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The servingConfig.
     */
    public java.lang.String getServingConfig() {
      java.lang.Object ref = servingConfig_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        servingConfig_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of the Serving Config to use. Format:
     * `projects/{project_number}/locations/{location_id}/collections/{collection}/dataStores/{data_store_id}/servingConfigs/{serving_config_id}`
     * If this is not set, the default serving config will be used.
     * </pre>
     *
     * <code>string serving_config = 3 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for servingConfig.
     */
    public com.google.protobuf.ByteString getServingConfigBytes() {
      java.lang.Object ref = servingConfig_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        servingConfig_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of the Serving Config to use. Format:
     * `projects/{project_number}/locations/{location_id}/collections/{collection}/dataStores/{data_store_id}/servingConfigs/{serving_config_id}`
     * If this is not set, the default serving config will be used.
     * </pre>
     *
     * <code>string serving_config = 3 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The servingConfig to set.
     * @return This builder for chaining.
     */
    public Builder setServingConfig(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      servingConfig_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name of the Serving Config to use. Format:
     * `projects/{project_number}/locations/{location_id}/collections/{collection}/dataStores/{data_store_id}/servingConfigs/{serving_config_id}`
     * If this is not set, the default serving config will be used.
     * </pre>
     *
     * <code>string serving_config = 3 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearServingConfig() {
      servingConfig_ = getDefaultInstance().getServingConfig();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name of the Serving Config to use. Format:
     * `projects/{project_number}/locations/{location_id}/collections/{collection}/dataStores/{data_store_id}/servingConfigs/{serving_config_id}`
     * If this is not set, the default serving config will be used.
     * </pre>
     *
     * <code>string serving_config = 3 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The bytes for servingConfig to set.
     * @return This builder for chaining.
     */
    public Builder setServingConfigBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      servingConfig_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.cloud.discoveryengine.v1beta.Conversation conversation_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1beta.Conversation,
            com.google.cloud.discoveryengine.v1beta.Conversation.Builder,
            com.google.cloud.discoveryengine.v1beta.ConversationOrBuilder>
        conversationBuilder_;
    /**
     *
     *
     * <pre>
     * The conversation to be used by auto session only. The name field will be
     * ignored as we automatically assign new name for the conversation in auto
     * session.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.Conversation conversation = 5;</code>
     *
     * @return Whether the conversation field is set.
     */
    public boolean hasConversation() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * The conversation to be used by auto session only. The name field will be
     * ignored as we automatically assign new name for the conversation in auto
     * session.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.Conversation conversation = 5;</code>
     *
     * @return The conversation.
     */
    public com.google.cloud.discoveryengine.v1beta.Conversation getConversation() {
      if (conversationBuilder_ == null) {
        return conversation_ == null
            ? com.google.cloud.discoveryengine.v1beta.Conversation.getDefaultInstance()
            : conversation_;
      } else {
        return conversationBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The conversation to be used by auto session only. The name field will be
     * ignored as we automatically assign new name for the conversation in auto
     * session.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.Conversation conversation = 5;</code>
     */
    public Builder setConversation(com.google.cloud.discoveryengine.v1beta.Conversation value) {
      if (conversationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        conversation_ = value;
      } else {
        conversationBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The conversation to be used by auto session only. The name field will be
     * ignored as we automatically assign new name for the conversation in auto
     * session.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.Conversation conversation = 5;</code>
     */
    public Builder setConversation(
        com.google.cloud.discoveryengine.v1beta.Conversation.Builder builderForValue) {
      if (conversationBuilder_ == null) {
        conversation_ = builderForValue.build();
      } else {
        conversationBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The conversation to be used by auto session only. The name field will be
     * ignored as we automatically assign new name for the conversation in auto
     * session.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.Conversation conversation = 5;</code>
     */
    public Builder mergeConversation(com.google.cloud.discoveryengine.v1beta.Conversation value) {
      if (conversationBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && conversation_ != null
            && conversation_
                != com.google.cloud.discoveryengine.v1beta.Conversation.getDefaultInstance()) {
          getConversationBuilder().mergeFrom(value);
        } else {
          conversation_ = value;
        }
      } else {
        conversationBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The conversation to be used by auto session only. The name field will be
     * ignored as we automatically assign new name for the conversation in auto
     * session.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.Conversation conversation = 5;</code>
     */
    public Builder clearConversation() {
      bitField0_ = (bitField0_ & ~0x00000008);
      conversation_ = null;
      if (conversationBuilder_ != null) {
        conversationBuilder_.dispose();
        conversationBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The conversation to be used by auto session only. The name field will be
     * ignored as we automatically assign new name for the conversation in auto
     * session.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.Conversation conversation = 5;</code>
     */
    public com.google.cloud.discoveryengine.v1beta.Conversation.Builder getConversationBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getConversationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The conversation to be used by auto session only. The name field will be
     * ignored as we automatically assign new name for the conversation in auto
     * session.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.Conversation conversation = 5;</code>
     */
    public com.google.cloud.discoveryengine.v1beta.ConversationOrBuilder
        getConversationOrBuilder() {
      if (conversationBuilder_ != null) {
        return conversationBuilder_.getMessageOrBuilder();
      } else {
        return conversation_ == null
            ? com.google.cloud.discoveryengine.v1beta.Conversation.getDefaultInstance()
            : conversation_;
      }
    }
    /**
     *
     *
     * <pre>
     * The conversation to be used by auto session only. The name field will be
     * ignored as we automatically assign new name for the conversation in auto
     * session.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.Conversation conversation = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1beta.Conversation,
            com.google.cloud.discoveryengine.v1beta.Conversation.Builder,
            com.google.cloud.discoveryengine.v1beta.ConversationOrBuilder>
        getConversationFieldBuilder() {
      if (conversationBuilder_ == null) {
        conversationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1beta.Conversation,
                com.google.cloud.discoveryengine.v1beta.Conversation.Builder,
                com.google.cloud.discoveryengine.v1beta.ConversationOrBuilder>(
                getConversation(), getParentForChildren(), isClean());
        conversation_ = null;
      }
      return conversationBuilder_;
    }

    private boolean safeSearch_;
    /**
     *
     *
     * <pre>
     * Whether to turn on safe search.
     * </pre>
     *
     * <code>bool safe_search = 6;</code>
     *
     * @return The safeSearch.
     */
    @java.lang.Override
    public boolean getSafeSearch() {
      return safeSearch_;
    }
    /**
     *
     *
     * <pre>
     * Whether to turn on safe search.
     * </pre>
     *
     * <code>bool safe_search = 6;</code>
     *
     * @param value The safeSearch to set.
     * @return This builder for chaining.
     */
    public Builder setSafeSearch(boolean value) {

      safeSearch_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Whether to turn on safe search.
     * </pre>
     *
     * <code>bool safe_search = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSafeSearch() {
      bitField0_ = (bitField0_ & ~0x00000010);
      safeSearch_ = false;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> userLabels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetUserLabels() {
      if (userLabels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            UserLabelsDefaultEntryHolder.defaultEntry);
      }
      return userLabels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableUserLabels() {
      if (userLabels_ == null) {
        userLabels_ =
            com.google.protobuf.MapField.newMapField(UserLabelsDefaultEntryHolder.defaultEntry);
      }
      if (!userLabels_.isMutable()) {
        userLabels_ = userLabels_.copy();
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return userLabels_;
    }

    public int getUserLabelsCount() {
      return internalGetUserLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * The user labels applied to a resource must meet the following requirements:
     *
     * * Each resource can have multiple labels, up to a maximum of 64.
     * * Each label must be a key-value pair.
     * * Keys have a minimum length of 1 character and a maximum length of 63
     *   characters and cannot be empty. Values can be empty and have a maximum
     *   length of 63 characters.
     * * Keys and values can contain only lowercase letters, numeric characters,
     *   underscores, and dashes. All characters must use UTF-8 encoding, and
     *   international characters are allowed.
     * * The key portion of a label must be unique. However, you can use the same
     *   key with multiple resources.
     * * Keys must start with a lowercase letter or international character.
     *
     * See [Google Cloud
     * Document](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
     * for more details.
     * </pre>
     *
     * <code>map&lt;string, string&gt; user_labels = 7;</code>
     */
    @java.lang.Override
    public boolean containsUserLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetUserLabels().getMap().containsKey(key);
    }
    /** Use {@link #getUserLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getUserLabels() {
      return getUserLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * The user labels applied to a resource must meet the following requirements:
     *
     * * Each resource can have multiple labels, up to a maximum of 64.
     * * Each label must be a key-value pair.
     * * Keys have a minimum length of 1 character and a maximum length of 63
     *   characters and cannot be empty. Values can be empty and have a maximum
     *   length of 63 characters.
     * * Keys and values can contain only lowercase letters, numeric characters,
     *   underscores, and dashes. All characters must use UTF-8 encoding, and
     *   international characters are allowed.
     * * The key portion of a label must be unique. However, you can use the same
     *   key with multiple resources.
     * * Keys must start with a lowercase letter or international character.
     *
     * See [Google Cloud
     * Document](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
     * for more details.
     * </pre>
     *
     * <code>map&lt;string, string&gt; user_labels = 7;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getUserLabelsMap() {
      return internalGetUserLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * The user labels applied to a resource must meet the following requirements:
     *
     * * Each resource can have multiple labels, up to a maximum of 64.
     * * Each label must be a key-value pair.
     * * Keys have a minimum length of 1 character and a maximum length of 63
     *   characters and cannot be empty. Values can be empty and have a maximum
     *   length of 63 characters.
     * * Keys and values can contain only lowercase letters, numeric characters,
     *   underscores, and dashes. All characters must use UTF-8 encoding, and
     *   international characters are allowed.
     * * The key portion of a label must be unique. However, you can use the same
     *   key with multiple resources.
     * * Keys must start with a lowercase letter or international character.
     *
     * See [Google Cloud
     * Document](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
     * for more details.
     * </pre>
     *
     * <code>map&lt;string, string&gt; user_labels = 7;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getUserLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetUserLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * The user labels applied to a resource must meet the following requirements:
     *
     * * Each resource can have multiple labels, up to a maximum of 64.
     * * Each label must be a key-value pair.
     * * Keys have a minimum length of 1 character and a maximum length of 63
     *   characters and cannot be empty. Values can be empty and have a maximum
     *   length of 63 characters.
     * * Keys and values can contain only lowercase letters, numeric characters,
     *   underscores, and dashes. All characters must use UTF-8 encoding, and
     *   international characters are allowed.
     * * The key portion of a label must be unique. However, you can use the same
     *   key with multiple resources.
     * * Keys must start with a lowercase letter or international character.
     *
     * See [Google Cloud
     * Document](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
     * for more details.
     * </pre>
     *
     * <code>map&lt;string, string&gt; user_labels = 7;</code>
     */
    @java.lang.Override
    public java.lang.String getUserLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetUserLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearUserLabels() {
      bitField0_ = (bitField0_ & ~0x00000020);
      internalGetMutableUserLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The user labels applied to a resource must meet the following requirements:
     *
     * * Each resource can have multiple labels, up to a maximum of 64.
     * * Each label must be a key-value pair.
     * * Keys have a minimum length of 1 character and a maximum length of 63
     *   characters and cannot be empty. Values can be empty and have a maximum
     *   length of 63 characters.
     * * Keys and values can contain only lowercase letters, numeric characters,
     *   underscores, and dashes. All characters must use UTF-8 encoding, and
     *   international characters are allowed.
     * * The key portion of a label must be unique. However, you can use the same
     *   key with multiple resources.
     * * Keys must start with a lowercase letter or international character.
     *
     * See [Google Cloud
     * Document](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
     * for more details.
     * </pre>
     *
     * <code>map&lt;string, string&gt; user_labels = 7;</code>
     */
    public Builder removeUserLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableUserLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableUserLabels() {
      bitField0_ |= 0x00000020;
      return internalGetMutableUserLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * The user labels applied to a resource must meet the following requirements:
     *
     * * Each resource can have multiple labels, up to a maximum of 64.
     * * Each label must be a key-value pair.
     * * Keys have a minimum length of 1 character and a maximum length of 63
     *   characters and cannot be empty. Values can be empty and have a maximum
     *   length of 63 characters.
     * * Keys and values can contain only lowercase letters, numeric characters,
     *   underscores, and dashes. All characters must use UTF-8 encoding, and
     *   international characters are allowed.
     * * The key portion of a label must be unique. However, you can use the same
     *   key with multiple resources.
     * * Keys must start with a lowercase letter or international character.
     *
     * See [Google Cloud
     * Document](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
     * for more details.
     * </pre>
     *
     * <code>map&lt;string, string&gt; user_labels = 7;</code>
     */
    public Builder putUserLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableUserLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00000020;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The user labels applied to a resource must meet the following requirements:
     *
     * * Each resource can have multiple labels, up to a maximum of 64.
     * * Each label must be a key-value pair.
     * * Keys have a minimum length of 1 character and a maximum length of 63
     *   characters and cannot be empty. Values can be empty and have a maximum
     *   length of 63 characters.
     * * Keys and values can contain only lowercase letters, numeric characters,
     *   underscores, and dashes. All characters must use UTF-8 encoding, and
     *   international characters are allowed.
     * * The key portion of a label must be unique. However, you can use the same
     *   key with multiple resources.
     * * Keys must start with a lowercase letter or international character.
     *
     * See [Google Cloud
     * Document](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
     * for more details.
     * </pre>
     *
     * <code>map&lt;string, string&gt; user_labels = 7;</code>
     */
    public Builder putAllUserLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableUserLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00000020;
      return this;
    }

    private com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec
        summarySpec_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec,
            com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec
                .Builder,
            com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                .SummarySpecOrBuilder>
        summarySpecBuilder_;
    /**
     *
     *
     * <pre>
     * A specification for configuring the summary returned in the response.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec summary_spec = 8;
     * </code>
     *
     * @return Whether the summarySpec field is set.
     */
    public boolean hasSummarySpec() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * A specification for configuring the summary returned in the response.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec summary_spec = 8;
     * </code>
     *
     * @return The summarySpec.
     */
    public com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec
        getSummarySpec() {
      if (summarySpecBuilder_ == null) {
        return summarySpec_ == null
            ? com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec
                .getDefaultInstance()
            : summarySpec_;
      } else {
        return summarySpecBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * A specification for configuring the summary returned in the response.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec summary_spec = 8;
     * </code>
     */
    public Builder setSummarySpec(
        com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec value) {
      if (summarySpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        summarySpec_ = value;
      } else {
        summarySpecBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A specification for configuring the summary returned in the response.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec summary_spec = 8;
     * </code>
     */
    public Builder setSummarySpec(
        com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec.Builder
            builderForValue) {
      if (summarySpecBuilder_ == null) {
        summarySpec_ = builderForValue.build();
      } else {
        summarySpecBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A specification for configuring the summary returned in the response.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec summary_spec = 8;
     * </code>
     */
    public Builder mergeSummarySpec(
        com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec value) {
      if (summarySpecBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && summarySpec_ != null
            && summarySpec_
                != com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                    .SummarySpec.getDefaultInstance()) {
          getSummarySpecBuilder().mergeFrom(value);
        } else {
          summarySpec_ = value;
        }
      } else {
        summarySpecBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A specification for configuring the summary returned in the response.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec summary_spec = 8;
     * </code>
     */
    public Builder clearSummarySpec() {
      bitField0_ = (bitField0_ & ~0x00000040);
      summarySpec_ = null;
      if (summarySpecBuilder_ != null) {
        summarySpecBuilder_.dispose();
        summarySpecBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A specification for configuring the summary returned in the response.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec summary_spec = 8;
     * </code>
     */
    public com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec
            .Builder
        getSummarySpecBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getSummarySpecFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A specification for configuring the summary returned in the response.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec summary_spec = 8;
     * </code>
     */
    public com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
            .SummarySpecOrBuilder
        getSummarySpecOrBuilder() {
      if (summarySpecBuilder_ != null) {
        return summarySpecBuilder_.getMessageOrBuilder();
      } else {
        return summarySpec_ == null
            ? com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec
                .getDefaultInstance()
            : summarySpec_;
      }
    }
    /**
     *
     *
     * <pre>
     * A specification for configuring the summary returned in the response.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec summary_spec = 8;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec,
            com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec
                .Builder,
            com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                .SummarySpecOrBuilder>
        getSummarySpecFieldBuilder() {
      if (summarySpecBuilder_ == null) {
        summarySpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec,
                com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec
                    .Builder,
                com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                    .SummarySpecOrBuilder>(getSummarySpec(), getParentForChildren(), isClean());
        summarySpec_ = null;
      }
      return summarySpecBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.ConverseConversationRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.ConverseConversationRequest)
  private static final com.google.cloud.discoveryengine.v1beta.ConverseConversationRequest
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.discoveryengine.v1beta.ConverseConversationRequest();
  }

  public static com.google.cloud.discoveryengine.v1beta.ConverseConversationRequest
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ConverseConversationRequest> PARSER =
      new com.google.protobuf.AbstractParser<ConverseConversationRequest>() {
        @java.lang.Override
        public ConverseConversationRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ConverseConversationRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ConverseConversationRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.ConverseConversationRequest
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
