/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/discoveryengine/v1beta/document.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.discoveryengine.v1beta;

/**
 *
 *
 * <pre>
 * Document captures all raw metadata information of items to be recommended or
 * searched.
 * </pre>
 *
 * Protobuf type {@code google.cloud.discoveryengine.v1beta.Document}
 */
public final class Document extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.Document)
    DocumentOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Document.newBuilder() to construct.
  private Document(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Document() {
    name_ = "";
    id_ = "";
    schemaId_ = "";
    parentDocumentId_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Document();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.discoveryengine.v1beta.DocumentProto
        .internal_static_google_cloud_discoveryengine_v1beta_Document_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.discoveryengine.v1beta.DocumentProto
        .internal_static_google_cloud_discoveryengine_v1beta_Document_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.discoveryengine.v1beta.Document.class,
            com.google.cloud.discoveryengine.v1beta.Document.Builder.class);
  }

  public interface ContentOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1beta.Document.Content)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The content represented as a stream of bytes. The maximum length is
     * 1,000,000 bytes (1 MB / ~0.95 MiB).
     *
     * Note: As with all `bytes` fields, this field is represented as pure
     * binary in Protocol Buffers and base64-encoded string in JSON. For
     * example, `abc123!?$*&amp;()'-=&#64;~` should be represented as
     * `YWJjMTIzIT8kKiYoKSctPUB+` in JSON. See
     * https://developers.google.com/protocol-buffers/docs/proto3#json.
     * </pre>
     *
     * <code>bytes raw_bytes = 2;</code>
     *
     * @return Whether the rawBytes field is set.
     */
    boolean hasRawBytes();
    /**
     *
     *
     * <pre>
     * The content represented as a stream of bytes. The maximum length is
     * 1,000,000 bytes (1 MB / ~0.95 MiB).
     *
     * Note: As with all `bytes` fields, this field is represented as pure
     * binary in Protocol Buffers and base64-encoded string in JSON. For
     * example, `abc123!?$*&amp;()'-=&#64;~` should be represented as
     * `YWJjMTIzIT8kKiYoKSctPUB+` in JSON. See
     * https://developers.google.com/protocol-buffers/docs/proto3#json.
     * </pre>
     *
     * <code>bytes raw_bytes = 2;</code>
     *
     * @return The rawBytes.
     */
    com.google.protobuf.ByteString getRawBytes();

    /**
     *
     *
     * <pre>
     * The URI of the content. Only Cloud Storage URIs (e.g.
     * `gs://bucket-name/path/to/file`) are supported. The maximum file size
     * is 2.5 MB for text-based formats, 100 MB for other formats.
     * </pre>
     *
     * <code>string uri = 3;</code>
     *
     * @return Whether the uri field is set.
     */
    boolean hasUri();
    /**
     *
     *
     * <pre>
     * The URI of the content. Only Cloud Storage URIs (e.g.
     * `gs://bucket-name/path/to/file`) are supported. The maximum file size
     * is 2.5 MB for text-based formats, 100 MB for other formats.
     * </pre>
     *
     * <code>string uri = 3;</code>
     *
     * @return The uri.
     */
    java.lang.String getUri();
    /**
     *
     *
     * <pre>
     * The URI of the content. Only Cloud Storage URIs (e.g.
     * `gs://bucket-name/path/to/file`) are supported. The maximum file size
     * is 2.5 MB for text-based formats, 100 MB for other formats.
     * </pre>
     *
     * <code>string uri = 3;</code>
     *
     * @return The bytes for uri.
     */
    com.google.protobuf.ByteString getUriBytes();

    /**
     *
     *
     * <pre>
     * The MIME type of the content. Supported types:
     *
     * * `application/pdf` (PDF, only native PDFs are supported for now)
     * * `text/html` (HTML)
     * * `application/vnd.openxmlformats-officedocument.wordprocessingml.document` (DOCX)
     * * `application/vnd.openxmlformats-officedocument.presentationml.presentation` (PPTX)
     * * `text/plain` (TXT)
     *
     * See https://www.iana.org/assignments/media-types/media-types.xhtml.
     * </pre>
     *
     * <code>string mime_type = 1;</code>
     *
     * @return The mimeType.
     */
    java.lang.String getMimeType();
    /**
     *
     *
     * <pre>
     * The MIME type of the content. Supported types:
     *
     * * `application/pdf` (PDF, only native PDFs are supported for now)
     * * `text/html` (HTML)
     * * `application/vnd.openxmlformats-officedocument.wordprocessingml.document` (DOCX)
     * * `application/vnd.openxmlformats-officedocument.presentationml.presentation` (PPTX)
     * * `text/plain` (TXT)
     *
     * See https://www.iana.org/assignments/media-types/media-types.xhtml.
     * </pre>
     *
     * <code>string mime_type = 1;</code>
     *
     * @return The bytes for mimeType.
     */
    com.google.protobuf.ByteString getMimeTypeBytes();

    com.google.cloud.discoveryengine.v1beta.Document.Content.ContentCase getContentCase();
  }
  /**
   *
   *
   * <pre>
   * Unstructured data linked to this document.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1beta.Document.Content}
   */
  public static final class Content extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.Document.Content)
      ContentOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Content.newBuilder() to construct.
    private Content(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Content() {
      mimeType_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Content();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1beta.DocumentProto
          .internal_static_google_cloud_discoveryengine_v1beta_Document_Content_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1beta.DocumentProto
          .internal_static_google_cloud_discoveryengine_v1beta_Document_Content_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1beta.Document.Content.class,
              com.google.cloud.discoveryengine.v1beta.Document.Content.Builder.class);
    }

    private int contentCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object content_;

    public enum ContentCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      RAW_BYTES(2),
      URI(3),
      CONTENT_NOT_SET(0);
      private final int value;

      private ContentCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static ContentCase valueOf(int value) {
        return forNumber(value);
      }

      public static ContentCase forNumber(int value) {
        switch (value) {
          case 2:
            return RAW_BYTES;
          case 3:
            return URI;
          case 0:
            return CONTENT_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public ContentCase getContentCase() {
      return ContentCase.forNumber(contentCase_);
    }

    public static final int RAW_BYTES_FIELD_NUMBER = 2;
    /**
     *
     *
     * <pre>
     * The content represented as a stream of bytes. The maximum length is
     * 1,000,000 bytes (1 MB / ~0.95 MiB).
     *
     * Note: As with all `bytes` fields, this field is represented as pure
     * binary in Protocol Buffers and base64-encoded string in JSON. For
     * example, `abc123!?$*&amp;()'-=&#64;~` should be represented as
     * `YWJjMTIzIT8kKiYoKSctPUB+` in JSON. See
     * https://developers.google.com/protocol-buffers/docs/proto3#json.
     * </pre>
     *
     * <code>bytes raw_bytes = 2;</code>
     *
     * @return Whether the rawBytes field is set.
     */
    @java.lang.Override
    public boolean hasRawBytes() {
      return contentCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * The content represented as a stream of bytes. The maximum length is
     * 1,000,000 bytes (1 MB / ~0.95 MiB).
     *
     * Note: As with all `bytes` fields, this field is represented as pure
     * binary in Protocol Buffers and base64-encoded string in JSON. For
     * example, `abc123!?$*&amp;()'-=&#64;~` should be represented as
     * `YWJjMTIzIT8kKiYoKSctPUB+` in JSON. See
     * https://developers.google.com/protocol-buffers/docs/proto3#json.
     * </pre>
     *
     * <code>bytes raw_bytes = 2;</code>
     *
     * @return The rawBytes.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getRawBytes() {
      if (contentCase_ == 2) {
        return (com.google.protobuf.ByteString) content_;
      }
      return com.google.protobuf.ByteString.EMPTY;
    }

    public static final int URI_FIELD_NUMBER = 3;
    /**
     *
     *
     * <pre>
     * The URI of the content. Only Cloud Storage URIs (e.g.
     * `gs://bucket-name/path/to/file`) are supported. The maximum file size
     * is 2.5 MB for text-based formats, 100 MB for other formats.
     * </pre>
     *
     * <code>string uri = 3;</code>
     *
     * @return Whether the uri field is set.
     */
    public boolean hasUri() {
      return contentCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * The URI of the content. Only Cloud Storage URIs (e.g.
     * `gs://bucket-name/path/to/file`) are supported. The maximum file size
     * is 2.5 MB for text-based formats, 100 MB for other formats.
     * </pre>
     *
     * <code>string uri = 3;</code>
     *
     * @return The uri.
     */
    public java.lang.String getUri() {
      java.lang.Object ref = "";
      if (contentCase_ == 3) {
        ref = content_;
      }
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (contentCase_ == 3) {
          content_ = s;
        }
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The URI of the content. Only Cloud Storage URIs (e.g.
     * `gs://bucket-name/path/to/file`) are supported. The maximum file size
     * is 2.5 MB for text-based formats, 100 MB for other formats.
     * </pre>
     *
     * <code>string uri = 3;</code>
     *
     * @return The bytes for uri.
     */
    public com.google.protobuf.ByteString getUriBytes() {
      java.lang.Object ref = "";
      if (contentCase_ == 3) {
        ref = content_;
      }
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (contentCase_ == 3) {
          content_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int MIME_TYPE_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object mimeType_ = "";
    /**
     *
     *
     * <pre>
     * The MIME type of the content. Supported types:
     *
     * * `application/pdf` (PDF, only native PDFs are supported for now)
     * * `text/html` (HTML)
     * * `application/vnd.openxmlformats-officedocument.wordprocessingml.document` (DOCX)
     * * `application/vnd.openxmlformats-officedocument.presentationml.presentation` (PPTX)
     * * `text/plain` (TXT)
     *
     * See https://www.iana.org/assignments/media-types/media-types.xhtml.
     * </pre>
     *
     * <code>string mime_type = 1;</code>
     *
     * @return The mimeType.
     */
    @java.lang.Override
    public java.lang.String getMimeType() {
      java.lang.Object ref = mimeType_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        mimeType_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The MIME type of the content. Supported types:
     *
     * * `application/pdf` (PDF, only native PDFs are supported for now)
     * * `text/html` (HTML)
     * * `application/vnd.openxmlformats-officedocument.wordprocessingml.document` (DOCX)
     * * `application/vnd.openxmlformats-officedocument.presentationml.presentation` (PPTX)
     * * `text/plain` (TXT)
     *
     * See https://www.iana.org/assignments/media-types/media-types.xhtml.
     * </pre>
     *
     * <code>string mime_type = 1;</code>
     *
     * @return The bytes for mimeType.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getMimeTypeBytes() {
      java.lang.Object ref = mimeType_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        mimeType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(mimeType_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, mimeType_);
      }
      if (contentCase_ == 2) {
        output.writeBytes(2, (com.google.protobuf.ByteString) content_);
      }
      if (contentCase_ == 3) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, content_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(mimeType_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, mimeType_);
      }
      if (contentCase_ == 2) {
        size +=
            com.google.protobuf.CodedOutputStream.computeBytesSize(
                2, (com.google.protobuf.ByteString) content_);
      }
      if (contentCase_ == 3) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, content_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.discoveryengine.v1beta.Document.Content)) {
        return super.equals(obj);
      }
      com.google.cloud.discoveryengine.v1beta.Document.Content other =
          (com.google.cloud.discoveryengine.v1beta.Document.Content) obj;

      if (!getMimeType().equals(other.getMimeType())) return false;
      if (!getContentCase().equals(other.getContentCase())) return false;
      switch (contentCase_) {
        case 2:
          if (!getRawBytes().equals(other.getRawBytes())) return false;
          break;
        case 3:
          if (!getUri().equals(other.getUri())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + MIME_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + getMimeType().hashCode();
      switch (contentCase_) {
        case 2:
          hash = (37 * hash) + RAW_BYTES_FIELD_NUMBER;
          hash = (53 * hash) + getRawBytes().hashCode();
          break;
        case 3:
          hash = (37 * hash) + URI_FIELD_NUMBER;
          hash = (53 * hash) + getUri().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.discoveryengine.v1beta.Document.Content parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.Document.Content parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.Document.Content parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.Document.Content parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.Document.Content parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.Document.Content parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.Document.Content parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.Document.Content parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.Document.Content parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.Document.Content parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.Document.Content parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.Document.Content parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.discoveryengine.v1beta.Document.Content prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Unstructured data linked to this document.
     * </pre>
     *
     * Protobuf type {@code google.cloud.discoveryengine.v1beta.Document.Content}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.Document.Content)
        com.google.cloud.discoveryengine.v1beta.Document.ContentOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1beta.DocumentProto
            .internal_static_google_cloud_discoveryengine_v1beta_Document_Content_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1beta.DocumentProto
            .internal_static_google_cloud_discoveryengine_v1beta_Document_Content_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1beta.Document.Content.class,
                com.google.cloud.discoveryengine.v1beta.Document.Content.Builder.class);
      }

      // Construct using com.google.cloud.discoveryengine.v1beta.Document.Content.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        mimeType_ = "";
        contentCase_ = 0;
        content_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.discoveryengine.v1beta.DocumentProto
            .internal_static_google_cloud_discoveryengine_v1beta_Document_Content_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.Document.Content getDefaultInstanceForType() {
        return com.google.cloud.discoveryengine.v1beta.Document.Content.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.Document.Content build() {
        com.google.cloud.discoveryengine.v1beta.Document.Content result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.Document.Content buildPartial() {
        com.google.cloud.discoveryengine.v1beta.Document.Content result =
            new com.google.cloud.discoveryengine.v1beta.Document.Content(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.discoveryengine.v1beta.Document.Content result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.mimeType_ = mimeType_;
        }
      }

      private void buildPartialOneofs(
          com.google.cloud.discoveryengine.v1beta.Document.Content result) {
        result.contentCase_ = contentCase_;
        result.content_ = this.content_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.discoveryengine.v1beta.Document.Content) {
          return mergeFrom((com.google.cloud.discoveryengine.v1beta.Document.Content) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.discoveryengine.v1beta.Document.Content other) {
        if (other == com.google.cloud.discoveryengine.v1beta.Document.Content.getDefaultInstance())
          return this;
        if (!other.getMimeType().isEmpty()) {
          mimeType_ = other.mimeType_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        switch (other.getContentCase()) {
          case RAW_BYTES:
            {
              setRawBytes(other.getRawBytes());
              break;
            }
          case URI:
            {
              contentCase_ = 3;
              content_ = other.content_;
              onChanged();
              break;
            }
          case CONTENT_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  mimeType_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 10
              case 18:
                {
                  content_ = input.readBytes();
                  contentCase_ = 2;
                  break;
                } // case 18
              case 26:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  contentCase_ = 3;
                  content_ = s;
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int contentCase_ = 0;
      private java.lang.Object content_;

      public ContentCase getContentCase() {
        return ContentCase.forNumber(contentCase_);
      }

      public Builder clearContent() {
        contentCase_ = 0;
        content_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      /**
       *
       *
       * <pre>
       * The content represented as a stream of bytes. The maximum length is
       * 1,000,000 bytes (1 MB / ~0.95 MiB).
       *
       * Note: As with all `bytes` fields, this field is represented as pure
       * binary in Protocol Buffers and base64-encoded string in JSON. For
       * example, `abc123!?$*&amp;()'-=&#64;~` should be represented as
       * `YWJjMTIzIT8kKiYoKSctPUB+` in JSON. See
       * https://developers.google.com/protocol-buffers/docs/proto3#json.
       * </pre>
       *
       * <code>bytes raw_bytes = 2;</code>
       *
       * @return Whether the rawBytes field is set.
       */
      public boolean hasRawBytes() {
        return contentCase_ == 2;
      }
      /**
       *
       *
       * <pre>
       * The content represented as a stream of bytes. The maximum length is
       * 1,000,000 bytes (1 MB / ~0.95 MiB).
       *
       * Note: As with all `bytes` fields, this field is represented as pure
       * binary in Protocol Buffers and base64-encoded string in JSON. For
       * example, `abc123!?$*&amp;()'-=&#64;~` should be represented as
       * `YWJjMTIzIT8kKiYoKSctPUB+` in JSON. See
       * https://developers.google.com/protocol-buffers/docs/proto3#json.
       * </pre>
       *
       * <code>bytes raw_bytes = 2;</code>
       *
       * @return The rawBytes.
       */
      public com.google.protobuf.ByteString getRawBytes() {
        if (contentCase_ == 2) {
          return (com.google.protobuf.ByteString) content_;
        }
        return com.google.protobuf.ByteString.EMPTY;
      }
      /**
       *
       *
       * <pre>
       * The content represented as a stream of bytes. The maximum length is
       * 1,000,000 bytes (1 MB / ~0.95 MiB).
       *
       * Note: As with all `bytes` fields, this field is represented as pure
       * binary in Protocol Buffers and base64-encoded string in JSON. For
       * example, `abc123!?$*&amp;()'-=&#64;~` should be represented as
       * `YWJjMTIzIT8kKiYoKSctPUB+` in JSON. See
       * https://developers.google.com/protocol-buffers/docs/proto3#json.
       * </pre>
       *
       * <code>bytes raw_bytes = 2;</code>
       *
       * @param value The rawBytes to set.
       * @return This builder for chaining.
       */
      public Builder setRawBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        contentCase_ = 2;
        content_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The content represented as a stream of bytes. The maximum length is
       * 1,000,000 bytes (1 MB / ~0.95 MiB).
       *
       * Note: As with all `bytes` fields, this field is represented as pure
       * binary in Protocol Buffers and base64-encoded string in JSON. For
       * example, `abc123!?$*&amp;()'-=&#64;~` should be represented as
       * `YWJjMTIzIT8kKiYoKSctPUB+` in JSON. See
       * https://developers.google.com/protocol-buffers/docs/proto3#json.
       * </pre>
       *
       * <code>bytes raw_bytes = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearRawBytes() {
        if (contentCase_ == 2) {
          contentCase_ = 0;
          content_ = null;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * The URI of the content. Only Cloud Storage URIs (e.g.
       * `gs://bucket-name/path/to/file`) are supported. The maximum file size
       * is 2.5 MB for text-based formats, 100 MB for other formats.
       * </pre>
       *
       * <code>string uri = 3;</code>
       *
       * @return Whether the uri field is set.
       */
      @java.lang.Override
      public boolean hasUri() {
        return contentCase_ == 3;
      }
      /**
       *
       *
       * <pre>
       * The URI of the content. Only Cloud Storage URIs (e.g.
       * `gs://bucket-name/path/to/file`) are supported. The maximum file size
       * is 2.5 MB for text-based formats, 100 MB for other formats.
       * </pre>
       *
       * <code>string uri = 3;</code>
       *
       * @return The uri.
       */
      @java.lang.Override
      public java.lang.String getUri() {
        java.lang.Object ref = "";
        if (contentCase_ == 3) {
          ref = content_;
        }
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (contentCase_ == 3) {
            content_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The URI of the content. Only Cloud Storage URIs (e.g.
       * `gs://bucket-name/path/to/file`) are supported. The maximum file size
       * is 2.5 MB for text-based formats, 100 MB for other formats.
       * </pre>
       *
       * <code>string uri = 3;</code>
       *
       * @return The bytes for uri.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getUriBytes() {
        java.lang.Object ref = "";
        if (contentCase_ == 3) {
          ref = content_;
        }
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          if (contentCase_ == 3) {
            content_ = b;
          }
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The URI of the content. Only Cloud Storage URIs (e.g.
       * `gs://bucket-name/path/to/file`) are supported. The maximum file size
       * is 2.5 MB for text-based formats, 100 MB for other formats.
       * </pre>
       *
       * <code>string uri = 3;</code>
       *
       * @param value The uri to set.
       * @return This builder for chaining.
       */
      public Builder setUri(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        contentCase_ = 3;
        content_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The URI of the content. Only Cloud Storage URIs (e.g.
       * `gs://bucket-name/path/to/file`) are supported. The maximum file size
       * is 2.5 MB for text-based formats, 100 MB for other formats.
       * </pre>
       *
       * <code>string uri = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearUri() {
        if (contentCase_ == 3) {
          contentCase_ = 0;
          content_ = null;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The URI of the content. Only Cloud Storage URIs (e.g.
       * `gs://bucket-name/path/to/file`) are supported. The maximum file size
       * is 2.5 MB for text-based formats, 100 MB for other formats.
       * </pre>
       *
       * <code>string uri = 3;</code>
       *
       * @param value The bytes for uri to set.
       * @return This builder for chaining.
       */
      public Builder setUriBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        contentCase_ = 3;
        content_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object mimeType_ = "";
      /**
       *
       *
       * <pre>
       * The MIME type of the content. Supported types:
       *
       * * `application/pdf` (PDF, only native PDFs are supported for now)
       * * `text/html` (HTML)
       * * `application/vnd.openxmlformats-officedocument.wordprocessingml.document` (DOCX)
       * * `application/vnd.openxmlformats-officedocument.presentationml.presentation` (PPTX)
       * * `text/plain` (TXT)
       *
       * See https://www.iana.org/assignments/media-types/media-types.xhtml.
       * </pre>
       *
       * <code>string mime_type = 1;</code>
       *
       * @return The mimeType.
       */
      public java.lang.String getMimeType() {
        java.lang.Object ref = mimeType_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          mimeType_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The MIME type of the content. Supported types:
       *
       * * `application/pdf` (PDF, only native PDFs are supported for now)
       * * `text/html` (HTML)
       * * `application/vnd.openxmlformats-officedocument.wordprocessingml.document` (DOCX)
       * * `application/vnd.openxmlformats-officedocument.presentationml.presentation` (PPTX)
       * * `text/plain` (TXT)
       *
       * See https://www.iana.org/assignments/media-types/media-types.xhtml.
       * </pre>
       *
       * <code>string mime_type = 1;</code>
       *
       * @return The bytes for mimeType.
       */
      public com.google.protobuf.ByteString getMimeTypeBytes() {
        java.lang.Object ref = mimeType_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          mimeType_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The MIME type of the content. Supported types:
       *
       * * `application/pdf` (PDF, only native PDFs are supported for now)
       * * `text/html` (HTML)
       * * `application/vnd.openxmlformats-officedocument.wordprocessingml.document` (DOCX)
       * * `application/vnd.openxmlformats-officedocument.presentationml.presentation` (PPTX)
       * * `text/plain` (TXT)
       *
       * See https://www.iana.org/assignments/media-types/media-types.xhtml.
       * </pre>
       *
       * <code>string mime_type = 1;</code>
       *
       * @param value The mimeType to set.
       * @return This builder for chaining.
       */
      public Builder setMimeType(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        mimeType_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The MIME type of the content. Supported types:
       *
       * * `application/pdf` (PDF, only native PDFs are supported for now)
       * * `text/html` (HTML)
       * * `application/vnd.openxmlformats-officedocument.wordprocessingml.document` (DOCX)
       * * `application/vnd.openxmlformats-officedocument.presentationml.presentation` (PPTX)
       * * `text/plain` (TXT)
       *
       * See https://www.iana.org/assignments/media-types/media-types.xhtml.
       * </pre>
       *
       * <code>string mime_type = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMimeType() {
        mimeType_ = getDefaultInstance().getMimeType();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The MIME type of the content. Supported types:
       *
       * * `application/pdf` (PDF, only native PDFs are supported for now)
       * * `text/html` (HTML)
       * * `application/vnd.openxmlformats-officedocument.wordprocessingml.document` (DOCX)
       * * `application/vnd.openxmlformats-officedocument.presentationml.presentation` (PPTX)
       * * `text/plain` (TXT)
       *
       * See https://www.iana.org/assignments/media-types/media-types.xhtml.
       * </pre>
       *
       * <code>string mime_type = 1;</code>
       *
       * @param value The bytes for mimeType to set.
       * @return This builder for chaining.
       */
      public Builder setMimeTypeBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        mimeType_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.Document.Content)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.Document.Content)
    private static final com.google.cloud.discoveryengine.v1beta.Document.Content DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.discoveryengine.v1beta.Document.Content();
    }

    public static com.google.cloud.discoveryengine.v1beta.Document.Content getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Content> PARSER =
        new com.google.protobuf.AbstractParser<Content>() {
          @java.lang.Override
          public Content parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Content> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Content> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.Document.Content getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  private int dataCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object data_;

  public enum DataCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    STRUCT_DATA(4),
    JSON_DATA(5),
    DATA_NOT_SET(0);
    private final int value;

    private DataCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static DataCase valueOf(int value) {
      return forNumber(value);
    }

    public static DataCase forNumber(int value) {
      switch (value) {
        case 4:
          return STRUCT_DATA;
        case 5:
          return JSON_DATA;
        case 0:
          return DATA_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public DataCase getDataCase() {
    return DataCase.forNumber(dataCase_);
  }

  public static final int STRUCT_DATA_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * The structured JSON data for the document. It should conform to the
   * registered [Schema][google.cloud.discoveryengine.v1beta.Schema] or an
   * `INVALID_ARGUMENT` error is thrown.
   * </pre>
   *
   * <code>.google.protobuf.Struct struct_data = 4;</code>
   *
   * @return Whether the structData field is set.
   */
  @java.lang.Override
  public boolean hasStructData() {
    return dataCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * The structured JSON data for the document. It should conform to the
   * registered [Schema][google.cloud.discoveryengine.v1beta.Schema] or an
   * `INVALID_ARGUMENT` error is thrown.
   * </pre>
   *
   * <code>.google.protobuf.Struct struct_data = 4;</code>
   *
   * @return The structData.
   */
  @java.lang.Override
  public com.google.protobuf.Struct getStructData() {
    if (dataCase_ == 4) {
      return (com.google.protobuf.Struct) data_;
    }
    return com.google.protobuf.Struct.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The structured JSON data for the document. It should conform to the
   * registered [Schema][google.cloud.discoveryengine.v1beta.Schema] or an
   * `INVALID_ARGUMENT` error is thrown.
   * </pre>
   *
   * <code>.google.protobuf.Struct struct_data = 4;</code>
   */
  @java.lang.Override
  public com.google.protobuf.StructOrBuilder getStructDataOrBuilder() {
    if (dataCase_ == 4) {
      return (com.google.protobuf.Struct) data_;
    }
    return com.google.protobuf.Struct.getDefaultInstance();
  }

  public static final int JSON_DATA_FIELD_NUMBER = 5;
  /**
   *
   *
   * <pre>
   * The JSON string representation of the document. It should conform to the
   * registered [Schema][google.cloud.discoveryengine.v1beta.Schema] or an
   * `INVALID_ARGUMENT` error is thrown.
   * </pre>
   *
   * <code>string json_data = 5;</code>
   *
   * @return Whether the jsonData field is set.
   */
  public boolean hasJsonData() {
    return dataCase_ == 5;
  }
  /**
   *
   *
   * <pre>
   * The JSON string representation of the document. It should conform to the
   * registered [Schema][google.cloud.discoveryengine.v1beta.Schema] or an
   * `INVALID_ARGUMENT` error is thrown.
   * </pre>
   *
   * <code>string json_data = 5;</code>
   *
   * @return The jsonData.
   */
  public java.lang.String getJsonData() {
    java.lang.Object ref = "";
    if (dataCase_ == 5) {
      ref = data_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (dataCase_ == 5) {
        data_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The JSON string representation of the document. It should conform to the
   * registered [Schema][google.cloud.discoveryengine.v1beta.Schema] or an
   * `INVALID_ARGUMENT` error is thrown.
   * </pre>
   *
   * <code>string json_data = 5;</code>
   *
   * @return The bytes for jsonData.
   */
  public com.google.protobuf.ByteString getJsonDataBytes() {
    java.lang.Object ref = "";
    if (dataCase_ == 5) {
      ref = data_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (dataCase_ == 5) {
        data_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Immutable. The full resource name of the document.
   * Format:
   * `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/branches/{branch}/documents/{document_id}`.
   *
   * This field must be a UTF-8 encoded string with a length limit of 1024
   * characters.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Immutable. The full resource name of the document.
   * Format:
   * `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/branches/{branch}/documents/{document_id}`.
   *
   * This field must be a UTF-8 encoded string with a length limit of 1024
   * characters.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ID_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object id_ = "";
  /**
   *
   *
   * <pre>
   * Immutable. The identifier of the document.
   *
   * Id should conform to [RFC-1034](https://tools.ietf.org/html/rfc1034)
   * standard with a length limit of 63 characters.
   * </pre>
   *
   * <code>string id = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The id.
   */
  @java.lang.Override
  public java.lang.String getId() {
    java.lang.Object ref = id_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      id_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Immutable. The identifier of the document.
   *
   * Id should conform to [RFC-1034](https://tools.ietf.org/html/rfc1034)
   * standard with a length limit of 63 characters.
   * </pre>
   *
   * <code>string id = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The bytes for id.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getIdBytes() {
    java.lang.Object ref = id_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      id_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SCHEMA_ID_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object schemaId_ = "";
  /**
   *
   *
   * <pre>
   * The identifier of the schema located in the same data store.
   * </pre>
   *
   * <code>string schema_id = 3;</code>
   *
   * @return The schemaId.
   */
  @java.lang.Override
  public java.lang.String getSchemaId() {
    java.lang.Object ref = schemaId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      schemaId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The identifier of the schema located in the same data store.
   * </pre>
   *
   * <code>string schema_id = 3;</code>
   *
   * @return The bytes for schemaId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSchemaIdBytes() {
    java.lang.Object ref = schemaId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      schemaId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CONTENT_FIELD_NUMBER = 10;
  private com.google.cloud.discoveryengine.v1beta.Document.Content content_;
  /**
   *
   *
   * <pre>
   * The unstructured data linked to this document. Content must be set if this
   * document is under a
   * `CONTENT_REQUIRED` data store.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.Document.Content content = 10;</code>
   *
   * @return Whether the content field is set.
   */
  @java.lang.Override
  public boolean hasContent() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * The unstructured data linked to this document. Content must be set if this
   * document is under a
   * `CONTENT_REQUIRED` data store.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.Document.Content content = 10;</code>
   *
   * @return The content.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.Document.Content getContent() {
    return content_ == null
        ? com.google.cloud.discoveryengine.v1beta.Document.Content.getDefaultInstance()
        : content_;
  }
  /**
   *
   *
   * <pre>
   * The unstructured data linked to this document. Content must be set if this
   * document is under a
   * `CONTENT_REQUIRED` data store.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.Document.Content content = 10;</code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.Document.ContentOrBuilder getContentOrBuilder() {
    return content_ == null
        ? com.google.cloud.discoveryengine.v1beta.Document.Content.getDefaultInstance()
        : content_;
  }

  public static final int PARENT_DOCUMENT_ID_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private volatile java.lang.Object parentDocumentId_ = "";
  /**
   *
   *
   * <pre>
   * The identifier of the parent document. Currently supports at most two level
   * document hierarchy.
   *
   * Id should conform to [RFC-1034](https://tools.ietf.org/html/rfc1034)
   * standard with a length limit of 63 characters.
   * </pre>
   *
   * <code>string parent_document_id = 7;</code>
   *
   * @return The parentDocumentId.
   */
  @java.lang.Override
  public java.lang.String getParentDocumentId() {
    java.lang.Object ref = parentDocumentId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parentDocumentId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The identifier of the parent document. Currently supports at most two level
   * document hierarchy.
   *
   * Id should conform to [RFC-1034](https://tools.ietf.org/html/rfc1034)
   * standard with a length limit of 63 characters.
   * </pre>
   *
   * <code>string parent_document_id = 7;</code>
   *
   * @return The bytes for parentDocumentId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentDocumentIdBytes() {
    java.lang.Object ref = parentDocumentId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parentDocumentId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DERIVED_STRUCT_DATA_FIELD_NUMBER = 6;
  private com.google.protobuf.Struct derivedStructData_;
  /**
   *
   *
   * <pre>
   * Output only. This field is OUTPUT_ONLY.
   * It contains derived data that are not in the original input document.
   * </pre>
   *
   * <code>
   * .google.protobuf.Struct derived_struct_data = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the derivedStructData field is set.
   */
  @java.lang.Override
  public boolean hasDerivedStructData() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. This field is OUTPUT_ONLY.
   * It contains derived data that are not in the original input document.
   * </pre>
   *
   * <code>
   * .google.protobuf.Struct derived_struct_data = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The derivedStructData.
   */
  @java.lang.Override
  public com.google.protobuf.Struct getDerivedStructData() {
    return derivedStructData_ == null
        ? com.google.protobuf.Struct.getDefaultInstance()
        : derivedStructData_;
  }
  /**
   *
   *
   * <pre>
   * Output only. This field is OUTPUT_ONLY.
   * It contains derived data that are not in the original input document.
   * </pre>
   *
   * <code>
   * .google.protobuf.Struct derived_struct_data = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.StructOrBuilder getDerivedStructDataOrBuilder() {
    return derivedStructData_ == null
        ? com.google.protobuf.Struct.getDefaultInstance()
        : derivedStructData_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, id_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(schemaId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, schemaId_);
    }
    if (dataCase_ == 4) {
      output.writeMessage(4, (com.google.protobuf.Struct) data_);
    }
    if (dataCase_ == 5) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, data_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(6, getDerivedStructData());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parentDocumentId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, parentDocumentId_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(10, getContent());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, id_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(schemaId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, schemaId_);
    }
    if (dataCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, (com.google.protobuf.Struct) data_);
    }
    if (dataCase_ == 5) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, data_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getDerivedStructData());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parentDocumentId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, parentDocumentId_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, getContent());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.discoveryengine.v1beta.Document)) {
      return super.equals(obj);
    }
    com.google.cloud.discoveryengine.v1beta.Document other =
        (com.google.cloud.discoveryengine.v1beta.Document) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getId().equals(other.getId())) return false;
    if (!getSchemaId().equals(other.getSchemaId())) return false;
    if (hasContent() != other.hasContent()) return false;
    if (hasContent()) {
      if (!getContent().equals(other.getContent())) return false;
    }
    if (!getParentDocumentId().equals(other.getParentDocumentId())) return false;
    if (hasDerivedStructData() != other.hasDerivedStructData()) return false;
    if (hasDerivedStructData()) {
      if (!getDerivedStructData().equals(other.getDerivedStructData())) return false;
    }
    if (!getDataCase().equals(other.getDataCase())) return false;
    switch (dataCase_) {
      case 4:
        if (!getStructData().equals(other.getStructData())) return false;
        break;
      case 5:
        if (!getJsonData().equals(other.getJsonData())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + ID_FIELD_NUMBER;
    hash = (53 * hash) + getId().hashCode();
    hash = (37 * hash) + SCHEMA_ID_FIELD_NUMBER;
    hash = (53 * hash) + getSchemaId().hashCode();
    if (hasContent()) {
      hash = (37 * hash) + CONTENT_FIELD_NUMBER;
      hash = (53 * hash) + getContent().hashCode();
    }
    hash = (37 * hash) + PARENT_DOCUMENT_ID_FIELD_NUMBER;
    hash = (53 * hash) + getParentDocumentId().hashCode();
    if (hasDerivedStructData()) {
      hash = (37 * hash) + DERIVED_STRUCT_DATA_FIELD_NUMBER;
      hash = (53 * hash) + getDerivedStructData().hashCode();
    }
    switch (dataCase_) {
      case 4:
        hash = (37 * hash) + STRUCT_DATA_FIELD_NUMBER;
        hash = (53 * hash) + getStructData().hashCode();
        break;
      case 5:
        hash = (37 * hash) + JSON_DATA_FIELD_NUMBER;
        hash = (53 * hash) + getJsonData().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.discoveryengine.v1beta.Document parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1beta.Document parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.Document parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1beta.Document parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.Document parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1beta.Document parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.Document parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1beta.Document parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.Document parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1beta.Document parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.Document parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1beta.Document parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.discoveryengine.v1beta.Document prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Document captures all raw metadata information of items to be recommended or
   * searched.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1beta.Document}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.Document)
      com.google.cloud.discoveryengine.v1beta.DocumentOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1beta.DocumentProto
          .internal_static_google_cloud_discoveryengine_v1beta_Document_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1beta.DocumentProto
          .internal_static_google_cloud_discoveryengine_v1beta_Document_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1beta.Document.class,
              com.google.cloud.discoveryengine.v1beta.Document.Builder.class);
    }

    // Construct using com.google.cloud.discoveryengine.v1beta.Document.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getContentFieldBuilder();
        getDerivedStructDataFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (structDataBuilder_ != null) {
        structDataBuilder_.clear();
      }
      name_ = "";
      id_ = "";
      schemaId_ = "";
      content_ = null;
      if (contentBuilder_ != null) {
        contentBuilder_.dispose();
        contentBuilder_ = null;
      }
      parentDocumentId_ = "";
      derivedStructData_ = null;
      if (derivedStructDataBuilder_ != null) {
        derivedStructDataBuilder_.dispose();
        derivedStructDataBuilder_ = null;
      }
      dataCase_ = 0;
      data_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.discoveryengine.v1beta.DocumentProto
          .internal_static_google_cloud_discoveryengine_v1beta_Document_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.Document getDefaultInstanceForType() {
      return com.google.cloud.discoveryengine.v1beta.Document.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.Document build() {
      com.google.cloud.discoveryengine.v1beta.Document result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.Document buildPartial() {
      com.google.cloud.discoveryengine.v1beta.Document result =
          new com.google.cloud.discoveryengine.v1beta.Document(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.discoveryengine.v1beta.Document result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.id_ = id_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.schemaId_ = schemaId_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.content_ = contentBuilder_ == null ? content_ : contentBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.parentDocumentId_ = parentDocumentId_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.derivedStructData_ =
            derivedStructDataBuilder_ == null
                ? derivedStructData_
                : derivedStructDataBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.cloud.discoveryengine.v1beta.Document result) {
      result.dataCase_ = dataCase_;
      result.data_ = this.data_;
      if (dataCase_ == 4 && structDataBuilder_ != null) {
        result.data_ = structDataBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.discoveryengine.v1beta.Document) {
        return mergeFrom((com.google.cloud.discoveryengine.v1beta.Document) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.discoveryengine.v1beta.Document other) {
      if (other == com.google.cloud.discoveryengine.v1beta.Document.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getId().isEmpty()) {
        id_ = other.id_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.getSchemaId().isEmpty()) {
        schemaId_ = other.schemaId_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (other.hasContent()) {
        mergeContent(other.getContent());
      }
      if (!other.getParentDocumentId().isEmpty()) {
        parentDocumentId_ = other.parentDocumentId_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (other.hasDerivedStructData()) {
        mergeDerivedStructData(other.getDerivedStructData());
      }
      switch (other.getDataCase()) {
        case STRUCT_DATA:
          {
            mergeStructData(other.getStructData());
            break;
          }
        case JSON_DATA:
          {
            dataCase_ = 5;
            data_ = other.data_;
            onChanged();
            break;
          }
        case DATA_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 10
            case 18:
              {
                id_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 18
            case 26:
              {
                schemaId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getStructDataFieldBuilder().getBuilder(), extensionRegistry);
                dataCase_ = 4;
                break;
              } // case 34
            case 42:
              {
                java.lang.String s = input.readStringRequireUtf8();
                dataCase_ = 5;
                data_ = s;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(
                    getDerivedStructDataFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 50
            case 58:
              {
                parentDocumentId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            case 82:
              {
                input.readMessage(getContentFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 82
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int dataCase_ = 0;
    private java.lang.Object data_;

    public DataCase getDataCase() {
      return DataCase.forNumber(dataCase_);
    }

    public Builder clearData() {
      dataCase_ = 0;
      data_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder,
            com.google.protobuf.StructOrBuilder>
        structDataBuilder_;
    /**
     *
     *
     * <pre>
     * The structured JSON data for the document. It should conform to the
     * registered [Schema][google.cloud.discoveryengine.v1beta.Schema] or an
     * `INVALID_ARGUMENT` error is thrown.
     * </pre>
     *
     * <code>.google.protobuf.Struct struct_data = 4;</code>
     *
     * @return Whether the structData field is set.
     */
    @java.lang.Override
    public boolean hasStructData() {
      return dataCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * The structured JSON data for the document. It should conform to the
     * registered [Schema][google.cloud.discoveryengine.v1beta.Schema] or an
     * `INVALID_ARGUMENT` error is thrown.
     * </pre>
     *
     * <code>.google.protobuf.Struct struct_data = 4;</code>
     *
     * @return The structData.
     */
    @java.lang.Override
    public com.google.protobuf.Struct getStructData() {
      if (structDataBuilder_ == null) {
        if (dataCase_ == 4) {
          return (com.google.protobuf.Struct) data_;
        }
        return com.google.protobuf.Struct.getDefaultInstance();
      } else {
        if (dataCase_ == 4) {
          return structDataBuilder_.getMessage();
        }
        return com.google.protobuf.Struct.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The structured JSON data for the document. It should conform to the
     * registered [Schema][google.cloud.discoveryengine.v1beta.Schema] or an
     * `INVALID_ARGUMENT` error is thrown.
     * </pre>
     *
     * <code>.google.protobuf.Struct struct_data = 4;</code>
     */
    public Builder setStructData(com.google.protobuf.Struct value) {
      if (structDataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        data_ = value;
        onChanged();
      } else {
        structDataBuilder_.setMessage(value);
      }
      dataCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The structured JSON data for the document. It should conform to the
     * registered [Schema][google.cloud.discoveryengine.v1beta.Schema] or an
     * `INVALID_ARGUMENT` error is thrown.
     * </pre>
     *
     * <code>.google.protobuf.Struct struct_data = 4;</code>
     */
    public Builder setStructData(com.google.protobuf.Struct.Builder builderForValue) {
      if (structDataBuilder_ == null) {
        data_ = builderForValue.build();
        onChanged();
      } else {
        structDataBuilder_.setMessage(builderForValue.build());
      }
      dataCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The structured JSON data for the document. It should conform to the
     * registered [Schema][google.cloud.discoveryengine.v1beta.Schema] or an
     * `INVALID_ARGUMENT` error is thrown.
     * </pre>
     *
     * <code>.google.protobuf.Struct struct_data = 4;</code>
     */
    public Builder mergeStructData(com.google.protobuf.Struct value) {
      if (structDataBuilder_ == null) {
        if (dataCase_ == 4 && data_ != com.google.protobuf.Struct.getDefaultInstance()) {
          data_ =
              com.google.protobuf.Struct.newBuilder((com.google.protobuf.Struct) data_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          data_ = value;
        }
        onChanged();
      } else {
        if (dataCase_ == 4) {
          structDataBuilder_.mergeFrom(value);
        } else {
          structDataBuilder_.setMessage(value);
        }
      }
      dataCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The structured JSON data for the document. It should conform to the
     * registered [Schema][google.cloud.discoveryengine.v1beta.Schema] or an
     * `INVALID_ARGUMENT` error is thrown.
     * </pre>
     *
     * <code>.google.protobuf.Struct struct_data = 4;</code>
     */
    public Builder clearStructData() {
      if (structDataBuilder_ == null) {
        if (dataCase_ == 4) {
          dataCase_ = 0;
          data_ = null;
          onChanged();
        }
      } else {
        if (dataCase_ == 4) {
          dataCase_ = 0;
          data_ = null;
        }
        structDataBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The structured JSON data for the document. It should conform to the
     * registered [Schema][google.cloud.discoveryengine.v1beta.Schema] or an
     * `INVALID_ARGUMENT` error is thrown.
     * </pre>
     *
     * <code>.google.protobuf.Struct struct_data = 4;</code>
     */
    public com.google.protobuf.Struct.Builder getStructDataBuilder() {
      return getStructDataFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The structured JSON data for the document. It should conform to the
     * registered [Schema][google.cloud.discoveryengine.v1beta.Schema] or an
     * `INVALID_ARGUMENT` error is thrown.
     * </pre>
     *
     * <code>.google.protobuf.Struct struct_data = 4;</code>
     */
    @java.lang.Override
    public com.google.protobuf.StructOrBuilder getStructDataOrBuilder() {
      if ((dataCase_ == 4) && (structDataBuilder_ != null)) {
        return structDataBuilder_.getMessageOrBuilder();
      } else {
        if (dataCase_ == 4) {
          return (com.google.protobuf.Struct) data_;
        }
        return com.google.protobuf.Struct.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The structured JSON data for the document. It should conform to the
     * registered [Schema][google.cloud.discoveryengine.v1beta.Schema] or an
     * `INVALID_ARGUMENT` error is thrown.
     * </pre>
     *
     * <code>.google.protobuf.Struct struct_data = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder,
            com.google.protobuf.StructOrBuilder>
        getStructDataFieldBuilder() {
      if (structDataBuilder_ == null) {
        if (!(dataCase_ == 4)) {
          data_ = com.google.protobuf.Struct.getDefaultInstance();
        }
        structDataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Struct,
                com.google.protobuf.Struct.Builder,
                com.google.protobuf.StructOrBuilder>(
                (com.google.protobuf.Struct) data_, getParentForChildren(), isClean());
        data_ = null;
      }
      dataCase_ = 4;
      onChanged();
      return structDataBuilder_;
    }

    /**
     *
     *
     * <pre>
     * The JSON string representation of the document. It should conform to the
     * registered [Schema][google.cloud.discoveryengine.v1beta.Schema] or an
     * `INVALID_ARGUMENT` error is thrown.
     * </pre>
     *
     * <code>string json_data = 5;</code>
     *
     * @return Whether the jsonData field is set.
     */
    @java.lang.Override
    public boolean hasJsonData() {
      return dataCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * The JSON string representation of the document. It should conform to the
     * registered [Schema][google.cloud.discoveryengine.v1beta.Schema] or an
     * `INVALID_ARGUMENT` error is thrown.
     * </pre>
     *
     * <code>string json_data = 5;</code>
     *
     * @return The jsonData.
     */
    @java.lang.Override
    public java.lang.String getJsonData() {
      java.lang.Object ref = "";
      if (dataCase_ == 5) {
        ref = data_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (dataCase_ == 5) {
          data_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The JSON string representation of the document. It should conform to the
     * registered [Schema][google.cloud.discoveryengine.v1beta.Schema] or an
     * `INVALID_ARGUMENT` error is thrown.
     * </pre>
     *
     * <code>string json_data = 5;</code>
     *
     * @return The bytes for jsonData.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getJsonDataBytes() {
      java.lang.Object ref = "";
      if (dataCase_ == 5) {
        ref = data_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (dataCase_ == 5) {
          data_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The JSON string representation of the document. It should conform to the
     * registered [Schema][google.cloud.discoveryengine.v1beta.Schema] or an
     * `INVALID_ARGUMENT` error is thrown.
     * </pre>
     *
     * <code>string json_data = 5;</code>
     *
     * @param value The jsonData to set.
     * @return This builder for chaining.
     */
    public Builder setJsonData(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      dataCase_ = 5;
      data_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The JSON string representation of the document. It should conform to the
     * registered [Schema][google.cloud.discoveryengine.v1beta.Schema] or an
     * `INVALID_ARGUMENT` error is thrown.
     * </pre>
     *
     * <code>string json_data = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearJsonData() {
      if (dataCase_ == 5) {
        dataCase_ = 0;
        data_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The JSON string representation of the document. It should conform to the
     * registered [Schema][google.cloud.discoveryengine.v1beta.Schema] or an
     * `INVALID_ARGUMENT` error is thrown.
     * </pre>
     *
     * <code>string json_data = 5;</code>
     *
     * @param value The bytes for jsonData to set.
     * @return This builder for chaining.
     */
    public Builder setJsonDataBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      dataCase_ = 5;
      data_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Immutable. The full resource name of the document.
     * Format:
     * `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/branches/{branch}/documents/{document_id}`.
     *
     * This field must be a UTF-8 encoded string with a length limit of 1024
     * characters.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. The full resource name of the document.
     * Format:
     * `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/branches/{branch}/documents/{document_id}`.
     *
     * This field must be a UTF-8 encoded string with a length limit of 1024
     * characters.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. The full resource name of the document.
     * Format:
     * `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/branches/{branch}/documents/{document_id}`.
     *
     * This field must be a UTF-8 encoded string with a length limit of 1024
     * characters.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The full resource name of the document.
     * Format:
     * `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/branches/{branch}/documents/{document_id}`.
     *
     * This field must be a UTF-8 encoded string with a length limit of 1024
     * characters.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The full resource name of the document.
     * Format:
     * `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/branches/{branch}/documents/{document_id}`.
     *
     * This field must be a UTF-8 encoded string with a length limit of 1024
     * characters.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object id_ = "";
    /**
     *
     *
     * <pre>
     * Immutable. The identifier of the document.
     *
     * Id should conform to [RFC-1034](https://tools.ietf.org/html/rfc1034)
     * standard with a length limit of 63 characters.
     * </pre>
     *
     * <code>string id = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The id.
     */
    public java.lang.String getId() {
      java.lang.Object ref = id_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        id_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. The identifier of the document.
     *
     * Id should conform to [RFC-1034](https://tools.ietf.org/html/rfc1034)
     * standard with a length limit of 63 characters.
     * </pre>
     *
     * <code>string id = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The bytes for id.
     */
    public com.google.protobuf.ByteString getIdBytes() {
      java.lang.Object ref = id_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        id_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. The identifier of the document.
     *
     * Id should conform to [RFC-1034](https://tools.ietf.org/html/rfc1034)
     * standard with a length limit of 63 characters.
     * </pre>
     *
     * <code>string id = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The id to set.
     * @return This builder for chaining.
     */
    public Builder setId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      id_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The identifier of the document.
     *
     * Id should conform to [RFC-1034](https://tools.ietf.org/html/rfc1034)
     * standard with a length limit of 63 characters.
     * </pre>
     *
     * <code>string id = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearId() {
      id_ = getDefaultInstance().getId();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The identifier of the document.
     *
     * Id should conform to [RFC-1034](https://tools.ietf.org/html/rfc1034)
     * standard with a length limit of 63 characters.
     * </pre>
     *
     * <code>string id = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The bytes for id to set.
     * @return This builder for chaining.
     */
    public Builder setIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      id_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object schemaId_ = "";
    /**
     *
     *
     * <pre>
     * The identifier of the schema located in the same data store.
     * </pre>
     *
     * <code>string schema_id = 3;</code>
     *
     * @return The schemaId.
     */
    public java.lang.String getSchemaId() {
      java.lang.Object ref = schemaId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        schemaId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The identifier of the schema located in the same data store.
     * </pre>
     *
     * <code>string schema_id = 3;</code>
     *
     * @return The bytes for schemaId.
     */
    public com.google.protobuf.ByteString getSchemaIdBytes() {
      java.lang.Object ref = schemaId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        schemaId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The identifier of the schema located in the same data store.
     * </pre>
     *
     * <code>string schema_id = 3;</code>
     *
     * @param value The schemaId to set.
     * @return This builder for chaining.
     */
    public Builder setSchemaId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      schemaId_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The identifier of the schema located in the same data store.
     * </pre>
     *
     * <code>string schema_id = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSchemaId() {
      schemaId_ = getDefaultInstance().getSchemaId();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The identifier of the schema located in the same data store.
     * </pre>
     *
     * <code>string schema_id = 3;</code>
     *
     * @param value The bytes for schemaId to set.
     * @return This builder for chaining.
     */
    public Builder setSchemaIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      schemaId_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private com.google.cloud.discoveryengine.v1beta.Document.Content content_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1beta.Document.Content,
            com.google.cloud.discoveryengine.v1beta.Document.Content.Builder,
            com.google.cloud.discoveryengine.v1beta.Document.ContentOrBuilder>
        contentBuilder_;
    /**
     *
     *
     * <pre>
     * The unstructured data linked to this document. Content must be set if this
     * document is under a
     * `CONTENT_REQUIRED` data store.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.Document.Content content = 10;</code>
     *
     * @return Whether the content field is set.
     */
    public boolean hasContent() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * The unstructured data linked to this document. Content must be set if this
     * document is under a
     * `CONTENT_REQUIRED` data store.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.Document.Content content = 10;</code>
     *
     * @return The content.
     */
    public com.google.cloud.discoveryengine.v1beta.Document.Content getContent() {
      if (contentBuilder_ == null) {
        return content_ == null
            ? com.google.cloud.discoveryengine.v1beta.Document.Content.getDefaultInstance()
            : content_;
      } else {
        return contentBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The unstructured data linked to this document. Content must be set if this
     * document is under a
     * `CONTENT_REQUIRED` data store.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.Document.Content content = 10;</code>
     */
    public Builder setContent(com.google.cloud.discoveryengine.v1beta.Document.Content value) {
      if (contentBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        content_ = value;
      } else {
        contentBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The unstructured data linked to this document. Content must be set if this
     * document is under a
     * `CONTENT_REQUIRED` data store.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.Document.Content content = 10;</code>
     */
    public Builder setContent(
        com.google.cloud.discoveryengine.v1beta.Document.Content.Builder builderForValue) {
      if (contentBuilder_ == null) {
        content_ = builderForValue.build();
      } else {
        contentBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The unstructured data linked to this document. Content must be set if this
     * document is under a
     * `CONTENT_REQUIRED` data store.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.Document.Content content = 10;</code>
     */
    public Builder mergeContent(com.google.cloud.discoveryengine.v1beta.Document.Content value) {
      if (contentBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && content_ != null
            && content_
                != com.google.cloud.discoveryengine.v1beta.Document.Content.getDefaultInstance()) {
          getContentBuilder().mergeFrom(value);
        } else {
          content_ = value;
        }
      } else {
        contentBuilder_.mergeFrom(value);
      }
      if (content_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The unstructured data linked to this document. Content must be set if this
     * document is under a
     * `CONTENT_REQUIRED` data store.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.Document.Content content = 10;</code>
     */
    public Builder clearContent() {
      bitField0_ = (bitField0_ & ~0x00000020);
      content_ = null;
      if (contentBuilder_ != null) {
        contentBuilder_.dispose();
        contentBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The unstructured data linked to this document. Content must be set if this
     * document is under a
     * `CONTENT_REQUIRED` data store.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.Document.Content content = 10;</code>
     */
    public com.google.cloud.discoveryengine.v1beta.Document.Content.Builder getContentBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getContentFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The unstructured data linked to this document. Content must be set if this
     * document is under a
     * `CONTENT_REQUIRED` data store.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.Document.Content content = 10;</code>
     */
    public com.google.cloud.discoveryengine.v1beta.Document.ContentOrBuilder getContentOrBuilder() {
      if (contentBuilder_ != null) {
        return contentBuilder_.getMessageOrBuilder();
      } else {
        return content_ == null
            ? com.google.cloud.discoveryengine.v1beta.Document.Content.getDefaultInstance()
            : content_;
      }
    }
    /**
     *
     *
     * <pre>
     * The unstructured data linked to this document. Content must be set if this
     * document is under a
     * `CONTENT_REQUIRED` data store.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.Document.Content content = 10;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1beta.Document.Content,
            com.google.cloud.discoveryengine.v1beta.Document.Content.Builder,
            com.google.cloud.discoveryengine.v1beta.Document.ContentOrBuilder>
        getContentFieldBuilder() {
      if (contentBuilder_ == null) {
        contentBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1beta.Document.Content,
                com.google.cloud.discoveryengine.v1beta.Document.Content.Builder,
                com.google.cloud.discoveryengine.v1beta.Document.ContentOrBuilder>(
                getContent(), getParentForChildren(), isClean());
        content_ = null;
      }
      return contentBuilder_;
    }

    private java.lang.Object parentDocumentId_ = "";
    /**
     *
     *
     * <pre>
     * The identifier of the parent document. Currently supports at most two level
     * document hierarchy.
     *
     * Id should conform to [RFC-1034](https://tools.ietf.org/html/rfc1034)
     * standard with a length limit of 63 characters.
     * </pre>
     *
     * <code>string parent_document_id = 7;</code>
     *
     * @return The parentDocumentId.
     */
    public java.lang.String getParentDocumentId() {
      java.lang.Object ref = parentDocumentId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parentDocumentId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The identifier of the parent document. Currently supports at most two level
     * document hierarchy.
     *
     * Id should conform to [RFC-1034](https://tools.ietf.org/html/rfc1034)
     * standard with a length limit of 63 characters.
     * </pre>
     *
     * <code>string parent_document_id = 7;</code>
     *
     * @return The bytes for parentDocumentId.
     */
    public com.google.protobuf.ByteString getParentDocumentIdBytes() {
      java.lang.Object ref = parentDocumentId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parentDocumentId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The identifier of the parent document. Currently supports at most two level
     * document hierarchy.
     *
     * Id should conform to [RFC-1034](https://tools.ietf.org/html/rfc1034)
     * standard with a length limit of 63 characters.
     * </pre>
     *
     * <code>string parent_document_id = 7;</code>
     *
     * @param value The parentDocumentId to set.
     * @return This builder for chaining.
     */
    public Builder setParentDocumentId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      parentDocumentId_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The identifier of the parent document. Currently supports at most two level
     * document hierarchy.
     *
     * Id should conform to [RFC-1034](https://tools.ietf.org/html/rfc1034)
     * standard with a length limit of 63 characters.
     * </pre>
     *
     * <code>string parent_document_id = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParentDocumentId() {
      parentDocumentId_ = getDefaultInstance().getParentDocumentId();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The identifier of the parent document. Currently supports at most two level
     * document hierarchy.
     *
     * Id should conform to [RFC-1034](https://tools.ietf.org/html/rfc1034)
     * standard with a length limit of 63 characters.
     * </pre>
     *
     * <code>string parent_document_id = 7;</code>
     *
     * @param value The bytes for parentDocumentId to set.
     * @return This builder for chaining.
     */
    public Builder setParentDocumentIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      parentDocumentId_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private com.google.protobuf.Struct derivedStructData_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder,
            com.google.protobuf.StructOrBuilder>
        derivedStructDataBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. This field is OUTPUT_ONLY.
     * It contains derived data that are not in the original input document.
     * </pre>
     *
     * <code>
     * .google.protobuf.Struct derived_struct_data = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the derivedStructData field is set.
     */
    public boolean hasDerivedStructData() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. This field is OUTPUT_ONLY.
     * It contains derived data that are not in the original input document.
     * </pre>
     *
     * <code>
     * .google.protobuf.Struct derived_struct_data = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The derivedStructData.
     */
    public com.google.protobuf.Struct getDerivedStructData() {
      if (derivedStructDataBuilder_ == null) {
        return derivedStructData_ == null
            ? com.google.protobuf.Struct.getDefaultInstance()
            : derivedStructData_;
      } else {
        return derivedStructDataBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. This field is OUTPUT_ONLY.
     * It contains derived data that are not in the original input document.
     * </pre>
     *
     * <code>
     * .google.protobuf.Struct derived_struct_data = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setDerivedStructData(com.google.protobuf.Struct value) {
      if (derivedStructDataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        derivedStructData_ = value;
      } else {
        derivedStructDataBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. This field is OUTPUT_ONLY.
     * It contains derived data that are not in the original input document.
     * </pre>
     *
     * <code>
     * .google.protobuf.Struct derived_struct_data = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setDerivedStructData(com.google.protobuf.Struct.Builder builderForValue) {
      if (derivedStructDataBuilder_ == null) {
        derivedStructData_ = builderForValue.build();
      } else {
        derivedStructDataBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. This field is OUTPUT_ONLY.
     * It contains derived data that are not in the original input document.
     * </pre>
     *
     * <code>
     * .google.protobuf.Struct derived_struct_data = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeDerivedStructData(com.google.protobuf.Struct value) {
      if (derivedStructDataBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && derivedStructData_ != null
            && derivedStructData_ != com.google.protobuf.Struct.getDefaultInstance()) {
          getDerivedStructDataBuilder().mergeFrom(value);
        } else {
          derivedStructData_ = value;
        }
      } else {
        derivedStructDataBuilder_.mergeFrom(value);
      }
      if (derivedStructData_ != null) {
        bitField0_ |= 0x00000080;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. This field is OUTPUT_ONLY.
     * It contains derived data that are not in the original input document.
     * </pre>
     *
     * <code>
     * .google.protobuf.Struct derived_struct_data = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearDerivedStructData() {
      bitField0_ = (bitField0_ & ~0x00000080);
      derivedStructData_ = null;
      if (derivedStructDataBuilder_ != null) {
        derivedStructDataBuilder_.dispose();
        derivedStructDataBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. This field is OUTPUT_ONLY.
     * It contains derived data that are not in the original input document.
     * </pre>
     *
     * <code>
     * .google.protobuf.Struct derived_struct_data = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Struct.Builder getDerivedStructDataBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getDerivedStructDataFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. This field is OUTPUT_ONLY.
     * It contains derived data that are not in the original input document.
     * </pre>
     *
     * <code>
     * .google.protobuf.Struct derived_struct_data = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.StructOrBuilder getDerivedStructDataOrBuilder() {
      if (derivedStructDataBuilder_ != null) {
        return derivedStructDataBuilder_.getMessageOrBuilder();
      } else {
        return derivedStructData_ == null
            ? com.google.protobuf.Struct.getDefaultInstance()
            : derivedStructData_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. This field is OUTPUT_ONLY.
     * It contains derived data that are not in the original input document.
     * </pre>
     *
     * <code>
     * .google.protobuf.Struct derived_struct_data = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder,
            com.google.protobuf.StructOrBuilder>
        getDerivedStructDataFieldBuilder() {
      if (derivedStructDataBuilder_ == null) {
        derivedStructDataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Struct,
                com.google.protobuf.Struct.Builder,
                com.google.protobuf.StructOrBuilder>(
                getDerivedStructData(), getParentForChildren(), isClean());
        derivedStructData_ = null;
      }
      return derivedStructDataBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.Document)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.Document)
  private static final com.google.cloud.discoveryengine.v1beta.Document DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.discoveryengine.v1beta.Document();
  }

  public static com.google.cloud.discoveryengine.v1beta.Document getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Document> PARSER =
      new com.google.protobuf.AbstractParser<Document>() {
        @java.lang.Override
        public Document parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Document> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Document> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.Document getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
