/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/discoveryengine/v1beta/import_config.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.discoveryengine.v1beta;

/**
 *
 *
 * <pre>
 * Request message for Import methods.
 * </pre>
 *
 * Protobuf type {@code google.cloud.discoveryengine.v1beta.ImportDocumentsRequest}
 */
public final class ImportDocumentsRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.ImportDocumentsRequest)
    ImportDocumentsRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ImportDocumentsRequest.newBuilder() to construct.
  private ImportDocumentsRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ImportDocumentsRequest() {
    parent_ = "";
    reconciliationMode_ = 0;
    idField_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ImportDocumentsRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.discoveryengine.v1beta.ImportConfigProto
        .internal_static_google_cloud_discoveryengine_v1beta_ImportDocumentsRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.discoveryengine.v1beta.ImportConfigProto
        .internal_static_google_cloud_discoveryengine_v1beta_ImportDocumentsRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.class,
            com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Indicates how imported documents are reconciled with the existing documents
   * created or imported before.
   * </pre>
   *
   * Protobuf enum {@code
   * google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.ReconciliationMode}
   */
  public enum ReconciliationMode implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Defaults to `INCREMENTAL`.
     * </pre>
     *
     * <code>RECONCILIATION_MODE_UNSPECIFIED = 0;</code>
     */
    RECONCILIATION_MODE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Inserts new documents or updates existing documents.
     * </pre>
     *
     * <code>INCREMENTAL = 1;</code>
     */
    INCREMENTAL(1),
    /**
     *
     *
     * <pre>
     * Calculates diff and replaces the entire document dataset. Existing
     * documents may be deleted if they are not present in the source location.
     * </pre>
     *
     * <code>FULL = 2;</code>
     */
    FULL(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Defaults to `INCREMENTAL`.
     * </pre>
     *
     * <code>RECONCILIATION_MODE_UNSPECIFIED = 0;</code>
     */
    public static final int RECONCILIATION_MODE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Inserts new documents or updates existing documents.
     * </pre>
     *
     * <code>INCREMENTAL = 1;</code>
     */
    public static final int INCREMENTAL_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Calculates diff and replaces the entire document dataset. Existing
     * documents may be deleted if they are not present in the source location.
     * </pre>
     *
     * <code>FULL = 2;</code>
     */
    public static final int FULL_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ReconciliationMode valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static ReconciliationMode forNumber(int value) {
      switch (value) {
        case 0:
          return RECONCILIATION_MODE_UNSPECIFIED;
        case 1:
          return INCREMENTAL;
        case 2:
          return FULL;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ReconciliationMode>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<ReconciliationMode>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<ReconciliationMode>() {
              public ReconciliationMode findValueByNumber(int number) {
                return ReconciliationMode.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final ReconciliationMode[] VALUES = values();

    public static ReconciliationMode valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ReconciliationMode(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.ReconciliationMode)
  }

  public interface InlineSourceOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.InlineSource)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. A list of documents to update/create. Each document must have a
     * valid [Document.id][google.cloud.discoveryengine.v1beta.Document.id].
     * Recommended max of 100 items.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.Document documents = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    java.util.List<com.google.cloud.discoveryengine.v1beta.Document> getDocumentsList();
    /**
     *
     *
     * <pre>
     * Required. A list of documents to update/create. Each document must have a
     * valid [Document.id][google.cloud.discoveryengine.v1beta.Document.id].
     * Recommended max of 100 items.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.Document documents = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    com.google.cloud.discoveryengine.v1beta.Document getDocuments(int index);
    /**
     *
     *
     * <pre>
     * Required. A list of documents to update/create. Each document must have a
     * valid [Document.id][google.cloud.discoveryengine.v1beta.Document.id].
     * Recommended max of 100 items.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.Document documents = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    int getDocumentsCount();
    /**
     *
     *
     * <pre>
     * Required. A list of documents to update/create. Each document must have a
     * valid [Document.id][google.cloud.discoveryengine.v1beta.Document.id].
     * Recommended max of 100 items.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.Document documents = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    java.util.List<? extends com.google.cloud.discoveryengine.v1beta.DocumentOrBuilder>
        getDocumentsOrBuilderList();
    /**
     *
     *
     * <pre>
     * Required. A list of documents to update/create. Each document must have a
     * valid [Document.id][google.cloud.discoveryengine.v1beta.Document.id].
     * Recommended max of 100 items.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.Document documents = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    com.google.cloud.discoveryengine.v1beta.DocumentOrBuilder getDocumentsOrBuilder(int index);
  }
  /**
   *
   *
   * <pre>
   * The inline source for the input config for ImportDocuments method.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.InlineSource}
   */
  public static final class InlineSource extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.InlineSource)
      InlineSourceOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use InlineSource.newBuilder() to construct.
    private InlineSource(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private InlineSource() {
      documents_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new InlineSource();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1beta.ImportConfigProto
          .internal_static_google_cloud_discoveryengine_v1beta_ImportDocumentsRequest_InlineSource_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1beta.ImportConfigProto
          .internal_static_google_cloud_discoveryengine_v1beta_ImportDocumentsRequest_InlineSource_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.InlineSource.class,
              com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.InlineSource.Builder
                  .class);
    }

    public static final int DOCUMENTS_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private java.util.List<com.google.cloud.discoveryengine.v1beta.Document> documents_;
    /**
     *
     *
     * <pre>
     * Required. A list of documents to update/create. Each document must have a
     * valid [Document.id][google.cloud.discoveryengine.v1beta.Document.id].
     * Recommended max of 100 items.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.Document documents = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.discoveryengine.v1beta.Document> getDocumentsList() {
      return documents_;
    }
    /**
     *
     *
     * <pre>
     * Required. A list of documents to update/create. Each document must have a
     * valid [Document.id][google.cloud.discoveryengine.v1beta.Document.id].
     * Recommended max of 100 items.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.Document documents = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public java.util.List<? extends com.google.cloud.discoveryengine.v1beta.DocumentOrBuilder>
        getDocumentsOrBuilderList() {
      return documents_;
    }
    /**
     *
     *
     * <pre>
     * Required. A list of documents to update/create. Each document must have a
     * valid [Document.id][google.cloud.discoveryengine.v1beta.Document.id].
     * Recommended max of 100 items.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.Document documents = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public int getDocumentsCount() {
      return documents_.size();
    }
    /**
     *
     *
     * <pre>
     * Required. A list of documents to update/create. Each document must have a
     * valid [Document.id][google.cloud.discoveryengine.v1beta.Document.id].
     * Recommended max of 100 items.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.Document documents = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.Document getDocuments(int index) {
      return documents_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Required. A list of documents to update/create. Each document must have a
     * valid [Document.id][google.cloud.discoveryengine.v1beta.Document.id].
     * Recommended max of 100 items.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.Document documents = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.DocumentOrBuilder getDocumentsOrBuilder(
        int index) {
      return documents_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < documents_.size(); i++) {
        output.writeMessage(1, documents_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < documents_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, documents_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.InlineSource)) {
        return super.equals(obj);
      }
      com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.InlineSource other =
          (com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.InlineSource) obj;

      if (!getDocumentsList().equals(other.getDocumentsList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getDocumentsCount() > 0) {
        hash = (37 * hash) + DOCUMENTS_FIELD_NUMBER;
        hash = (53 * hash) + getDocumentsList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.InlineSource
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.InlineSource
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.InlineSource
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.InlineSource
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.InlineSource
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.InlineSource
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.InlineSource
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.InlineSource
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.InlineSource
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.InlineSource
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.InlineSource
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.InlineSource
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.InlineSource prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * The inline source for the input config for ImportDocuments method.
     * </pre>
     *
     * Protobuf type {@code google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.InlineSource}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.InlineSource)
        com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.InlineSourceOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1beta.ImportConfigProto
            .internal_static_google_cloud_discoveryengine_v1beta_ImportDocumentsRequest_InlineSource_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1beta.ImportConfigProto
            .internal_static_google_cloud_discoveryengine_v1beta_ImportDocumentsRequest_InlineSource_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.InlineSource.class,
                com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.InlineSource.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.InlineSource.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (documentsBuilder_ == null) {
          documents_ = java.util.Collections.emptyList();
        } else {
          documents_ = null;
          documentsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.discoveryengine.v1beta.ImportConfigProto
            .internal_static_google_cloud_discoveryengine_v1beta_ImportDocumentsRequest_InlineSource_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.InlineSource
          getDefaultInstanceForType() {
        return com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.InlineSource
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.InlineSource build() {
        com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.InlineSource result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.InlineSource
          buildPartial() {
        com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.InlineSource result =
            new com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.InlineSource(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.InlineSource result) {
        if (documentsBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            documents_ = java.util.Collections.unmodifiableList(documents_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.documents_ = documents_;
        } else {
          result.documents_ = documentsBuilder_.build();
        }
      }

      private void buildPartial0(
          com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.InlineSource result) {
        int from_bitField0_ = bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.InlineSource) {
          return mergeFrom(
              (com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.InlineSource) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.InlineSource other) {
        if (other
            == com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.InlineSource
                .getDefaultInstance()) return this;
        if (documentsBuilder_ == null) {
          if (!other.documents_.isEmpty()) {
            if (documents_.isEmpty()) {
              documents_ = other.documents_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureDocumentsIsMutable();
              documents_.addAll(other.documents_);
            }
            onChanged();
          }
        } else {
          if (!other.documents_.isEmpty()) {
            if (documentsBuilder_.isEmpty()) {
              documentsBuilder_.dispose();
              documentsBuilder_ = null;
              documents_ = other.documents_;
              bitField0_ = (bitField0_ & ~0x00000001);
              documentsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getDocumentsFieldBuilder()
                      : null;
            } else {
              documentsBuilder_.addAllMessages(other.documents_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  com.google.cloud.discoveryengine.v1beta.Document m =
                      input.readMessage(
                          com.google.cloud.discoveryengine.v1beta.Document.parser(),
                          extensionRegistry);
                  if (documentsBuilder_ == null) {
                    ensureDocumentsIsMutable();
                    documents_.add(m);
                  } else {
                    documentsBuilder_.addMessage(m);
                  }
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.util.List<com.google.cloud.discoveryengine.v1beta.Document> documents_ =
          java.util.Collections.emptyList();

      private void ensureDocumentsIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          documents_ =
              new java.util.ArrayList<com.google.cloud.discoveryengine.v1beta.Document>(documents_);
          bitField0_ |= 0x00000001;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.discoveryengine.v1beta.Document,
              com.google.cloud.discoveryengine.v1beta.Document.Builder,
              com.google.cloud.discoveryengine.v1beta.DocumentOrBuilder>
          documentsBuilder_;

      /**
       *
       *
       * <pre>
       * Required. A list of documents to update/create. Each document must have a
       * valid [Document.id][google.cloud.discoveryengine.v1beta.Document.id].
       * Recommended max of 100 items.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.Document documents = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public java.util.List<com.google.cloud.discoveryengine.v1beta.Document> getDocumentsList() {
        if (documentsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(documents_);
        } else {
          return documentsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * Required. A list of documents to update/create. Each document must have a
       * valid [Document.id][google.cloud.discoveryengine.v1beta.Document.id].
       * Recommended max of 100 items.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.Document documents = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public int getDocumentsCount() {
        if (documentsBuilder_ == null) {
          return documents_.size();
        } else {
          return documentsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * Required. A list of documents to update/create. Each document must have a
       * valid [Document.id][google.cloud.discoveryengine.v1beta.Document.id].
       * Recommended max of 100 items.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.Document documents = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.discoveryengine.v1beta.Document getDocuments(int index) {
        if (documentsBuilder_ == null) {
          return documents_.get(index);
        } else {
          return documentsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Required. A list of documents to update/create. Each document must have a
       * valid [Document.id][google.cloud.discoveryengine.v1beta.Document.id].
       * Recommended max of 100 items.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.Document documents = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setDocuments(
          int index, com.google.cloud.discoveryengine.v1beta.Document value) {
        if (documentsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureDocumentsIsMutable();
          documents_.set(index, value);
          onChanged();
        } else {
          documentsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. A list of documents to update/create. Each document must have a
       * valid [Document.id][google.cloud.discoveryengine.v1beta.Document.id].
       * Recommended max of 100 items.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.Document documents = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setDocuments(
          int index, com.google.cloud.discoveryengine.v1beta.Document.Builder builderForValue) {
        if (documentsBuilder_ == null) {
          ensureDocumentsIsMutable();
          documents_.set(index, builderForValue.build());
          onChanged();
        } else {
          documentsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. A list of documents to update/create. Each document must have a
       * valid [Document.id][google.cloud.discoveryengine.v1beta.Document.id].
       * Recommended max of 100 items.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.Document documents = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder addDocuments(com.google.cloud.discoveryengine.v1beta.Document value) {
        if (documentsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureDocumentsIsMutable();
          documents_.add(value);
          onChanged();
        } else {
          documentsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. A list of documents to update/create. Each document must have a
       * valid [Document.id][google.cloud.discoveryengine.v1beta.Document.id].
       * Recommended max of 100 items.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.Document documents = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder addDocuments(
          int index, com.google.cloud.discoveryengine.v1beta.Document value) {
        if (documentsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureDocumentsIsMutable();
          documents_.add(index, value);
          onChanged();
        } else {
          documentsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. A list of documents to update/create. Each document must have a
       * valid [Document.id][google.cloud.discoveryengine.v1beta.Document.id].
       * Recommended max of 100 items.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.Document documents = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder addDocuments(
          com.google.cloud.discoveryengine.v1beta.Document.Builder builderForValue) {
        if (documentsBuilder_ == null) {
          ensureDocumentsIsMutable();
          documents_.add(builderForValue.build());
          onChanged();
        } else {
          documentsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. A list of documents to update/create. Each document must have a
       * valid [Document.id][google.cloud.discoveryengine.v1beta.Document.id].
       * Recommended max of 100 items.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.Document documents = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder addDocuments(
          int index, com.google.cloud.discoveryengine.v1beta.Document.Builder builderForValue) {
        if (documentsBuilder_ == null) {
          ensureDocumentsIsMutable();
          documents_.add(index, builderForValue.build());
          onChanged();
        } else {
          documentsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. A list of documents to update/create. Each document must have a
       * valid [Document.id][google.cloud.discoveryengine.v1beta.Document.id].
       * Recommended max of 100 items.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.Document documents = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder addAllDocuments(
          java.lang.Iterable<? extends com.google.cloud.discoveryengine.v1beta.Document> values) {
        if (documentsBuilder_ == null) {
          ensureDocumentsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, documents_);
          onChanged();
        } else {
          documentsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. A list of documents to update/create. Each document must have a
       * valid [Document.id][google.cloud.discoveryengine.v1beta.Document.id].
       * Recommended max of 100 items.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.Document documents = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder clearDocuments() {
        if (documentsBuilder_ == null) {
          documents_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          documentsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. A list of documents to update/create. Each document must have a
       * valid [Document.id][google.cloud.discoveryengine.v1beta.Document.id].
       * Recommended max of 100 items.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.Document documents = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder removeDocuments(int index) {
        if (documentsBuilder_ == null) {
          ensureDocumentsIsMutable();
          documents_.remove(index);
          onChanged();
        } else {
          documentsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. A list of documents to update/create. Each document must have a
       * valid [Document.id][google.cloud.discoveryengine.v1beta.Document.id].
       * Recommended max of 100 items.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.Document documents = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.discoveryengine.v1beta.Document.Builder getDocumentsBuilder(
          int index) {
        return getDocumentsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * Required. A list of documents to update/create. Each document must have a
       * valid [Document.id][google.cloud.discoveryengine.v1beta.Document.id].
       * Recommended max of 100 items.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.Document documents = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.discoveryengine.v1beta.DocumentOrBuilder getDocumentsOrBuilder(
          int index) {
        if (documentsBuilder_ == null) {
          return documents_.get(index);
        } else {
          return documentsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Required. A list of documents to update/create. Each document must have a
       * valid [Document.id][google.cloud.discoveryengine.v1beta.Document.id].
       * Recommended max of 100 items.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.Document documents = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public java.util.List<? extends com.google.cloud.discoveryengine.v1beta.DocumentOrBuilder>
          getDocumentsOrBuilderList() {
        if (documentsBuilder_ != null) {
          return documentsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(documents_);
        }
      }
      /**
       *
       *
       * <pre>
       * Required. A list of documents to update/create. Each document must have a
       * valid [Document.id][google.cloud.discoveryengine.v1beta.Document.id].
       * Recommended max of 100 items.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.Document documents = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.discoveryengine.v1beta.Document.Builder addDocumentsBuilder() {
        return getDocumentsFieldBuilder()
            .addBuilder(com.google.cloud.discoveryengine.v1beta.Document.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Required. A list of documents to update/create. Each document must have a
       * valid [Document.id][google.cloud.discoveryengine.v1beta.Document.id].
       * Recommended max of 100 items.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.Document documents = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.discoveryengine.v1beta.Document.Builder addDocumentsBuilder(
          int index) {
        return getDocumentsFieldBuilder()
            .addBuilder(
                index, com.google.cloud.discoveryengine.v1beta.Document.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Required. A list of documents to update/create. Each document must have a
       * valid [Document.id][google.cloud.discoveryengine.v1beta.Document.id].
       * Recommended max of 100 items.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.Document documents = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public java.util.List<com.google.cloud.discoveryengine.v1beta.Document.Builder>
          getDocumentsBuilderList() {
        return getDocumentsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.discoveryengine.v1beta.Document,
              com.google.cloud.discoveryengine.v1beta.Document.Builder,
              com.google.cloud.discoveryengine.v1beta.DocumentOrBuilder>
          getDocumentsFieldBuilder() {
        if (documentsBuilder_ == null) {
          documentsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.discoveryengine.v1beta.Document,
                  com.google.cloud.discoveryengine.v1beta.Document.Builder,
                  com.google.cloud.discoveryengine.v1beta.DocumentOrBuilder>(
                  documents_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
          documents_ = null;
        }
        return documentsBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.InlineSource)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.InlineSource)
    private static final com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.InlineSource
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.InlineSource();
    }

    public static com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.InlineSource
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<InlineSource> PARSER =
        new com.google.protobuf.AbstractParser<InlineSource>() {
          @java.lang.Override
          public InlineSource parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<InlineSource> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<InlineSource> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.InlineSource
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  private int sourceCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object source_;

  public enum SourceCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    INLINE_SOURCE(2),
    GCS_SOURCE(3),
    BIGQUERY_SOURCE(4),
    SOURCE_NOT_SET(0);
    private final int value;

    private SourceCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SourceCase valueOf(int value) {
      return forNumber(value);
    }

    public static SourceCase forNumber(int value) {
      switch (value) {
        case 2:
          return INLINE_SOURCE;
        case 3:
          return GCS_SOURCE;
        case 4:
          return BIGQUERY_SOURCE;
        case 0:
          return SOURCE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public SourceCase getSourceCase() {
    return SourceCase.forNumber(sourceCase_);
  }

  public static final int INLINE_SOURCE_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * The Inline source for the input content for documents.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.InlineSource inline_source = 2;
   * </code>
   *
   * @return Whether the inlineSource field is set.
   */
  @java.lang.Override
  public boolean hasInlineSource() {
    return sourceCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * The Inline source for the input content for documents.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.InlineSource inline_source = 2;
   * </code>
   *
   * @return The inlineSource.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.InlineSource
      getInlineSource() {
    if (sourceCase_ == 2) {
      return (com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.InlineSource) source_;
    }
    return com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.InlineSource
        .getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The Inline source for the input content for documents.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.InlineSource inline_source = 2;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.InlineSourceOrBuilder
      getInlineSourceOrBuilder() {
    if (sourceCase_ == 2) {
      return (com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.InlineSource) source_;
    }
    return com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.InlineSource
        .getDefaultInstance();
  }

  public static final int GCS_SOURCE_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * Cloud Storage location for the input content.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.GcsSource gcs_source = 3;</code>
   *
   * @return Whether the gcsSource field is set.
   */
  @java.lang.Override
  public boolean hasGcsSource() {
    return sourceCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * Cloud Storage location for the input content.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.GcsSource gcs_source = 3;</code>
   *
   * @return The gcsSource.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.GcsSource getGcsSource() {
    if (sourceCase_ == 3) {
      return (com.google.cloud.discoveryengine.v1beta.GcsSource) source_;
    }
    return com.google.cloud.discoveryengine.v1beta.GcsSource.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Cloud Storage location for the input content.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.GcsSource gcs_source = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.GcsSourceOrBuilder getGcsSourceOrBuilder() {
    if (sourceCase_ == 3) {
      return (com.google.cloud.discoveryengine.v1beta.GcsSource) source_;
    }
    return com.google.cloud.discoveryengine.v1beta.GcsSource.getDefaultInstance();
  }

  public static final int BIGQUERY_SOURCE_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * BigQuery input source.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.BigQuerySource bigquery_source = 4;</code>
   *
   * @return Whether the bigquerySource field is set.
   */
  @java.lang.Override
  public boolean hasBigquerySource() {
    return sourceCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * BigQuery input source.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.BigQuerySource bigquery_source = 4;</code>
   *
   * @return The bigquerySource.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.BigQuerySource getBigquerySource() {
    if (sourceCase_ == 4) {
      return (com.google.cloud.discoveryengine.v1beta.BigQuerySource) source_;
    }
    return com.google.cloud.discoveryengine.v1beta.BigQuerySource.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * BigQuery input source.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.BigQuerySource bigquery_source = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.BigQuerySourceOrBuilder
      getBigquerySourceOrBuilder() {
    if (sourceCase_ == 4) {
      return (com.google.cloud.discoveryengine.v1beta.BigQuerySource) source_;
    }
    return com.google.cloud.discoveryengine.v1beta.BigQuerySource.getDefaultInstance();
  }

  public static final int PARENT_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object parent_ = "";
  /**
   *
   *
   * <pre>
   * Required. The parent branch resource name, such as
   * `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/branches/{branch}`.
   * Requires create/update permission.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The parent.
   */
  @java.lang.Override
  public java.lang.String getParent() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parent_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The parent branch resource name, such as
   * `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/branches/{branch}`.
   * Requires create/update permission.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for parent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentBytes() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ERROR_CONFIG_FIELD_NUMBER = 5;
  private com.google.cloud.discoveryengine.v1beta.ImportErrorConfig errorConfig_;
  /**
   *
   *
   * <pre>
   * The desired location of errors incurred during the Import.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.ImportErrorConfig error_config = 5;</code>
   *
   * @return Whether the errorConfig field is set.
   */
  @java.lang.Override
  public boolean hasErrorConfig() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * The desired location of errors incurred during the Import.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.ImportErrorConfig error_config = 5;</code>
   *
   * @return The errorConfig.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.ImportErrorConfig getErrorConfig() {
    return errorConfig_ == null
        ? com.google.cloud.discoveryengine.v1beta.ImportErrorConfig.getDefaultInstance()
        : errorConfig_;
  }
  /**
   *
   *
   * <pre>
   * The desired location of errors incurred during the Import.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.ImportErrorConfig error_config = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.ImportErrorConfigOrBuilder
      getErrorConfigOrBuilder() {
    return errorConfig_ == null
        ? com.google.cloud.discoveryengine.v1beta.ImportErrorConfig.getDefaultInstance()
        : errorConfig_;
  }

  public static final int RECONCILIATION_MODE_FIELD_NUMBER = 6;
  private int reconciliationMode_ = 0;
  /**
   *
   *
   * <pre>
   * The mode of reconciliation between existing documents and the documents to
   * be imported. Defaults to
   * [ReconciliationMode.INCREMENTAL][google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.ReconciliationMode.INCREMENTAL].
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.ReconciliationMode reconciliation_mode = 6;
   * </code>
   *
   * @return The enum numeric value on the wire for reconciliationMode.
   */
  @java.lang.Override
  public int getReconciliationModeValue() {
    return reconciliationMode_;
  }
  /**
   *
   *
   * <pre>
   * The mode of reconciliation between existing documents and the documents to
   * be imported. Defaults to
   * [ReconciliationMode.INCREMENTAL][google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.ReconciliationMode.INCREMENTAL].
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.ReconciliationMode reconciliation_mode = 6;
   * </code>
   *
   * @return The reconciliationMode.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.ReconciliationMode
      getReconciliationMode() {
    com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.ReconciliationMode result =
        com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.ReconciliationMode.forNumber(
            reconciliationMode_);
    return result == null
        ? com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.ReconciliationMode
            .UNRECOGNIZED
        : result;
  }

  public static final int AUTO_GENERATE_IDS_FIELD_NUMBER = 8;
  private boolean autoGenerateIds_ = false;
  /**
   *
   *
   * <pre>
   * Whether to automatically generate IDs for the documents if absent.
   *
   * If set to `true`,
   * [Document.id][google.cloud.discoveryengine.v1beta.Document.id]s are
   * automatically generated based on the hash of the payload, where IDs may not
   * be consistent during multiple imports. In which case
   * [ReconciliationMode.FULL][google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.ReconciliationMode.FULL]
   * is highly recommended to avoid duplicate contents. If unset or set to
   * `false`, [Document.id][google.cloud.discoveryengine.v1beta.Document.id]s
   * have to be specified using
   * [id_field][google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.id_field],
   * otherwise, documents without IDs fail to be imported.
   *
   * Only set this field when using
   * [GcsSource][google.cloud.discoveryengine.v1beta.GcsSource] or
   * [BigQuerySource][google.cloud.discoveryengine.v1beta.BigQuerySource], and
   * when
   * [GcsSource.data_schema][google.cloud.discoveryengine.v1beta.GcsSource.data_schema]
   * or
   * [BigQuerySource.data_schema][google.cloud.discoveryengine.v1beta.BigQuerySource.data_schema]
   * is `custom` or `csv`. Otherwise, an INVALID_ARGUMENT error is thrown.
   * </pre>
   *
   * <code>bool auto_generate_ids = 8;</code>
   *
   * @return The autoGenerateIds.
   */
  @java.lang.Override
  public boolean getAutoGenerateIds() {
    return autoGenerateIds_;
  }

  public static final int ID_FIELD_FIELD_NUMBER = 9;

  @SuppressWarnings("serial")
  private volatile java.lang.Object idField_ = "";
  /**
   *
   *
   * <pre>
   * The field in the Cloud Storage and BigQuery sources that indicates the
   * unique IDs of the documents.
   *
   * For [GcsSource][google.cloud.discoveryengine.v1beta.GcsSource] it is the
   * key of the JSON field. For instance, `my_id` for JSON `{"my_id":
   * "some_uuid"}`. For
   * [BigQuerySource][google.cloud.discoveryengine.v1beta.BigQuerySource] it is
   * the column name of the BigQuery table where the unique ids are stored.
   *
   * The values of the JSON field or the BigQuery column are used as the
   * [Document.id][google.cloud.discoveryengine.v1beta.Document.id]s. The JSON
   * field or the BigQuery column must be of string type, and the values must be
   * set as valid strings conform to
   * [RFC-1034](https://tools.ietf.org/html/rfc1034) with 1-63 characters.
   * Otherwise, documents without valid IDs fail to be imported.
   *
   * Only set this field when using
   * [GcsSource][google.cloud.discoveryengine.v1beta.GcsSource] or
   * [BigQuerySource][google.cloud.discoveryengine.v1beta.BigQuerySource], and
   * when
   * [GcsSource.data_schema][google.cloud.discoveryengine.v1beta.GcsSource.data_schema]
   * or
   * [BigQuerySource.data_schema][google.cloud.discoveryengine.v1beta.BigQuerySource.data_schema]
   * is `custom`. And only set this field when
   * [auto_generate_ids][google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.auto_generate_ids]
   * is unset or set as `false`. Otherwise, an INVALID_ARGUMENT error is thrown.
   *
   * If it is unset, a default value `_id` is used when importing from the
   * allowed data sources.
   * </pre>
   *
   * <code>string id_field = 9;</code>
   *
   * @return The idField.
   */
  @java.lang.Override
  public java.lang.String getIdField() {
    java.lang.Object ref = idField_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      idField_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The field in the Cloud Storage and BigQuery sources that indicates the
   * unique IDs of the documents.
   *
   * For [GcsSource][google.cloud.discoveryengine.v1beta.GcsSource] it is the
   * key of the JSON field. For instance, `my_id` for JSON `{"my_id":
   * "some_uuid"}`. For
   * [BigQuerySource][google.cloud.discoveryengine.v1beta.BigQuerySource] it is
   * the column name of the BigQuery table where the unique ids are stored.
   *
   * The values of the JSON field or the BigQuery column are used as the
   * [Document.id][google.cloud.discoveryengine.v1beta.Document.id]s. The JSON
   * field or the BigQuery column must be of string type, and the values must be
   * set as valid strings conform to
   * [RFC-1034](https://tools.ietf.org/html/rfc1034) with 1-63 characters.
   * Otherwise, documents without valid IDs fail to be imported.
   *
   * Only set this field when using
   * [GcsSource][google.cloud.discoveryengine.v1beta.GcsSource] or
   * [BigQuerySource][google.cloud.discoveryengine.v1beta.BigQuerySource], and
   * when
   * [GcsSource.data_schema][google.cloud.discoveryengine.v1beta.GcsSource.data_schema]
   * or
   * [BigQuerySource.data_schema][google.cloud.discoveryengine.v1beta.BigQuerySource.data_schema]
   * is `custom`. And only set this field when
   * [auto_generate_ids][google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.auto_generate_ids]
   * is unset or set as `false`. Otherwise, an INVALID_ARGUMENT error is thrown.
   *
   * If it is unset, a default value `_id` is used when importing from the
   * allowed data sources.
   * </pre>
   *
   * <code>string id_field = 9;</code>
   *
   * @return The bytes for idField.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getIdFieldBytes() {
    java.lang.Object ref = idField_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      idField_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parent_);
    }
    if (sourceCase_ == 2) {
      output.writeMessage(
          2, (com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.InlineSource) source_);
    }
    if (sourceCase_ == 3) {
      output.writeMessage(3, (com.google.cloud.discoveryengine.v1beta.GcsSource) source_);
    }
    if (sourceCase_ == 4) {
      output.writeMessage(4, (com.google.cloud.discoveryengine.v1beta.BigQuerySource) source_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(5, getErrorConfig());
    }
    if (reconciliationMode_
        != com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.ReconciliationMode
            .RECONCILIATION_MODE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(6, reconciliationMode_);
    }
    if (autoGenerateIds_ != false) {
      output.writeBool(8, autoGenerateIds_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(idField_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 9, idField_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parent_);
    }
    if (sourceCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2,
              (com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.InlineSource)
                  source_);
    }
    if (sourceCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.cloud.discoveryengine.v1beta.GcsSource) source_);
    }
    if (sourceCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, (com.google.cloud.discoveryengine.v1beta.BigQuerySource) source_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getErrorConfig());
    }
    if (reconciliationMode_
        != com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.ReconciliationMode
            .RECONCILIATION_MODE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(6, reconciliationMode_);
    }
    if (autoGenerateIds_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(8, autoGenerateIds_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(idField_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(9, idField_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest other =
        (com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest) obj;

    if (!getParent().equals(other.getParent())) return false;
    if (hasErrorConfig() != other.hasErrorConfig()) return false;
    if (hasErrorConfig()) {
      if (!getErrorConfig().equals(other.getErrorConfig())) return false;
    }
    if (reconciliationMode_ != other.reconciliationMode_) return false;
    if (getAutoGenerateIds() != other.getAutoGenerateIds()) return false;
    if (!getIdField().equals(other.getIdField())) return false;
    if (!getSourceCase().equals(other.getSourceCase())) return false;
    switch (sourceCase_) {
      case 2:
        if (!getInlineSource().equals(other.getInlineSource())) return false;
        break;
      case 3:
        if (!getGcsSource().equals(other.getGcsSource())) return false;
        break;
      case 4:
        if (!getBigquerySource().equals(other.getBigquerySource())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PARENT_FIELD_NUMBER;
    hash = (53 * hash) + getParent().hashCode();
    if (hasErrorConfig()) {
      hash = (37 * hash) + ERROR_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getErrorConfig().hashCode();
    }
    hash = (37 * hash) + RECONCILIATION_MODE_FIELD_NUMBER;
    hash = (53 * hash) + reconciliationMode_;
    hash = (37 * hash) + AUTO_GENERATE_IDS_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getAutoGenerateIds());
    hash = (37 * hash) + ID_FIELD_FIELD_NUMBER;
    hash = (53 * hash) + getIdField().hashCode();
    switch (sourceCase_) {
      case 2:
        hash = (37 * hash) + INLINE_SOURCE_FIELD_NUMBER;
        hash = (53 * hash) + getInlineSource().hashCode();
        break;
      case 3:
        hash = (37 * hash) + GCS_SOURCE_FIELD_NUMBER;
        hash = (53 * hash) + getGcsSource().hashCode();
        break;
      case 4:
        hash = (37 * hash) + BIGQUERY_SOURCE_FIELD_NUMBER;
        hash = (53 * hash) + getBigquerySource().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request message for Import methods.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1beta.ImportDocumentsRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.ImportDocumentsRequest)
      com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1beta.ImportConfigProto
          .internal_static_google_cloud_discoveryengine_v1beta_ImportDocumentsRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1beta.ImportConfigProto
          .internal_static_google_cloud_discoveryengine_v1beta_ImportDocumentsRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.class,
              com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.Builder.class);
    }

    // Construct using com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getErrorConfigFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (inlineSourceBuilder_ != null) {
        inlineSourceBuilder_.clear();
      }
      if (gcsSourceBuilder_ != null) {
        gcsSourceBuilder_.clear();
      }
      if (bigquerySourceBuilder_ != null) {
        bigquerySourceBuilder_.clear();
      }
      parent_ = "";
      errorConfig_ = null;
      if (errorConfigBuilder_ != null) {
        errorConfigBuilder_.dispose();
        errorConfigBuilder_ = null;
      }
      reconciliationMode_ = 0;
      autoGenerateIds_ = false;
      idField_ = "";
      sourceCase_ = 0;
      source_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.discoveryengine.v1beta.ImportConfigProto
          .internal_static_google_cloud_discoveryengine_v1beta_ImportDocumentsRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest
        getDefaultInstanceForType() {
      return com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest build() {
      com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest buildPartial() {
      com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest result =
          new com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.parent_ = parent_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.errorConfig_ =
            errorConfigBuilder_ == null ? errorConfig_ : errorConfigBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.reconciliationMode_ = reconciliationMode_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.autoGenerateIds_ = autoGenerateIds_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.idField_ = idField_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(
        com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest result) {
      result.sourceCase_ = sourceCase_;
      result.source_ = this.source_;
      if (sourceCase_ == 2 && inlineSourceBuilder_ != null) {
        result.source_ = inlineSourceBuilder_.build();
      }
      if (sourceCase_ == 3 && gcsSourceBuilder_ != null) {
        result.source_ = gcsSourceBuilder_.build();
      }
      if (sourceCase_ == 4 && bigquerySourceBuilder_ != null) {
        result.source_ = bigquerySourceBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest) {
        return mergeFrom((com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest other) {
      if (other
          == com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.getDefaultInstance())
        return this;
      if (!other.getParent().isEmpty()) {
        parent_ = other.parent_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.hasErrorConfig()) {
        mergeErrorConfig(other.getErrorConfig());
      }
      if (other.reconciliationMode_ != 0) {
        setReconciliationModeValue(other.getReconciliationModeValue());
      }
      if (other.getAutoGenerateIds() != false) {
        setAutoGenerateIds(other.getAutoGenerateIds());
      }
      if (!other.getIdField().isEmpty()) {
        idField_ = other.idField_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      switch (other.getSourceCase()) {
        case INLINE_SOURCE:
          {
            mergeInlineSource(other.getInlineSource());
            break;
          }
        case GCS_SOURCE:
          {
            mergeGcsSource(other.getGcsSource());
            break;
          }
        case BIGQUERY_SOURCE:
          {
            mergeBigquerySource(other.getBigquerySource());
            break;
          }
        case SOURCE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                parent_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getInlineSourceFieldBuilder().getBuilder(), extensionRegistry);
                sourceCase_ = 2;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getGcsSourceFieldBuilder().getBuilder(), extensionRegistry);
                sourceCase_ = 3;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getBigquerySourceFieldBuilder().getBuilder(), extensionRegistry);
                sourceCase_ = 4;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getErrorConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 48:
              {
                reconciliationMode_ = input.readEnum();
                bitField0_ |= 0x00000020;
                break;
              } // case 48
            case 64:
              {
                autoGenerateIds_ = input.readBool();
                bitField0_ |= 0x00000040;
                break;
              } // case 64
            case 74:
              {
                idField_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000080;
                break;
              } // case 74
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int sourceCase_ = 0;
    private java.lang.Object source_;

    public SourceCase getSourceCase() {
      return SourceCase.forNumber(sourceCase_);
    }

    public Builder clearSource() {
      sourceCase_ = 0;
      source_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.InlineSource,
            com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.InlineSource.Builder,
            com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.InlineSourceOrBuilder>
        inlineSourceBuilder_;
    /**
     *
     *
     * <pre>
     * The Inline source for the input content for documents.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.InlineSource inline_source = 2;
     * </code>
     *
     * @return Whether the inlineSource field is set.
     */
    @java.lang.Override
    public boolean hasInlineSource() {
      return sourceCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * The Inline source for the input content for documents.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.InlineSource inline_source = 2;
     * </code>
     *
     * @return The inlineSource.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.InlineSource
        getInlineSource() {
      if (inlineSourceBuilder_ == null) {
        if (sourceCase_ == 2) {
          return (com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.InlineSource)
              source_;
        }
        return com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.InlineSource
            .getDefaultInstance();
      } else {
        if (sourceCase_ == 2) {
          return inlineSourceBuilder_.getMessage();
        }
        return com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.InlineSource
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The Inline source for the input content for documents.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.InlineSource inline_source = 2;
     * </code>
     */
    public Builder setInlineSource(
        com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.InlineSource value) {
      if (inlineSourceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        source_ = value;
        onChanged();
      } else {
        inlineSourceBuilder_.setMessage(value);
      }
      sourceCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Inline source for the input content for documents.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.InlineSource inline_source = 2;
     * </code>
     */
    public Builder setInlineSource(
        com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.InlineSource.Builder
            builderForValue) {
      if (inlineSourceBuilder_ == null) {
        source_ = builderForValue.build();
        onChanged();
      } else {
        inlineSourceBuilder_.setMessage(builderForValue.build());
      }
      sourceCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Inline source for the input content for documents.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.InlineSource inline_source = 2;
     * </code>
     */
    public Builder mergeInlineSource(
        com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.InlineSource value) {
      if (inlineSourceBuilder_ == null) {
        if (sourceCase_ == 2
            && source_
                != com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.InlineSource
                    .getDefaultInstance()) {
          source_ =
              com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.InlineSource
                  .newBuilder(
                      (com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.InlineSource)
                          source_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          source_ = value;
        }
        onChanged();
      } else {
        if (sourceCase_ == 2) {
          inlineSourceBuilder_.mergeFrom(value);
        } else {
          inlineSourceBuilder_.setMessage(value);
        }
      }
      sourceCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Inline source for the input content for documents.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.InlineSource inline_source = 2;
     * </code>
     */
    public Builder clearInlineSource() {
      if (inlineSourceBuilder_ == null) {
        if (sourceCase_ == 2) {
          sourceCase_ = 0;
          source_ = null;
          onChanged();
        }
      } else {
        if (sourceCase_ == 2) {
          sourceCase_ = 0;
          source_ = null;
        }
        inlineSourceBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Inline source for the input content for documents.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.InlineSource inline_source = 2;
     * </code>
     */
    public com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.InlineSource.Builder
        getInlineSourceBuilder() {
      return getInlineSourceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The Inline source for the input content for documents.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.InlineSource inline_source = 2;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.InlineSourceOrBuilder
        getInlineSourceOrBuilder() {
      if ((sourceCase_ == 2) && (inlineSourceBuilder_ != null)) {
        return inlineSourceBuilder_.getMessageOrBuilder();
      } else {
        if (sourceCase_ == 2) {
          return (com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.InlineSource)
              source_;
        }
        return com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.InlineSource
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The Inline source for the input content for documents.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.InlineSource inline_source = 2;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.InlineSource,
            com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.InlineSource.Builder,
            com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.InlineSourceOrBuilder>
        getInlineSourceFieldBuilder() {
      if (inlineSourceBuilder_ == null) {
        if (!(sourceCase_ == 2)) {
          source_ =
              com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.InlineSource
                  .getDefaultInstance();
        }
        inlineSourceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.InlineSource,
                com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.InlineSource.Builder,
                com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest
                    .InlineSourceOrBuilder>(
                (com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.InlineSource)
                    source_,
                getParentForChildren(),
                isClean());
        source_ = null;
      }
      sourceCase_ = 2;
      onChanged();
      return inlineSourceBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1beta.GcsSource,
            com.google.cloud.discoveryengine.v1beta.GcsSource.Builder,
            com.google.cloud.discoveryengine.v1beta.GcsSourceOrBuilder>
        gcsSourceBuilder_;
    /**
     *
     *
     * <pre>
     * Cloud Storage location for the input content.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.GcsSource gcs_source = 3;</code>
     *
     * @return Whether the gcsSource field is set.
     */
    @java.lang.Override
    public boolean hasGcsSource() {
      return sourceCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * Cloud Storage location for the input content.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.GcsSource gcs_source = 3;</code>
     *
     * @return The gcsSource.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.GcsSource getGcsSource() {
      if (gcsSourceBuilder_ == null) {
        if (sourceCase_ == 3) {
          return (com.google.cloud.discoveryengine.v1beta.GcsSource) source_;
        }
        return com.google.cloud.discoveryengine.v1beta.GcsSource.getDefaultInstance();
      } else {
        if (sourceCase_ == 3) {
          return gcsSourceBuilder_.getMessage();
        }
        return com.google.cloud.discoveryengine.v1beta.GcsSource.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Cloud Storage location for the input content.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.GcsSource gcs_source = 3;</code>
     */
    public Builder setGcsSource(com.google.cloud.discoveryengine.v1beta.GcsSource value) {
      if (gcsSourceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        source_ = value;
        onChanged();
      } else {
        gcsSourceBuilder_.setMessage(value);
      }
      sourceCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cloud Storage location for the input content.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.GcsSource gcs_source = 3;</code>
     */
    public Builder setGcsSource(
        com.google.cloud.discoveryengine.v1beta.GcsSource.Builder builderForValue) {
      if (gcsSourceBuilder_ == null) {
        source_ = builderForValue.build();
        onChanged();
      } else {
        gcsSourceBuilder_.setMessage(builderForValue.build());
      }
      sourceCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cloud Storage location for the input content.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.GcsSource gcs_source = 3;</code>
     */
    public Builder mergeGcsSource(com.google.cloud.discoveryengine.v1beta.GcsSource value) {
      if (gcsSourceBuilder_ == null) {
        if (sourceCase_ == 3
            && source_ != com.google.cloud.discoveryengine.v1beta.GcsSource.getDefaultInstance()) {
          source_ =
              com.google.cloud.discoveryengine.v1beta.GcsSource.newBuilder(
                      (com.google.cloud.discoveryengine.v1beta.GcsSource) source_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          source_ = value;
        }
        onChanged();
      } else {
        if (sourceCase_ == 3) {
          gcsSourceBuilder_.mergeFrom(value);
        } else {
          gcsSourceBuilder_.setMessage(value);
        }
      }
      sourceCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cloud Storage location for the input content.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.GcsSource gcs_source = 3;</code>
     */
    public Builder clearGcsSource() {
      if (gcsSourceBuilder_ == null) {
        if (sourceCase_ == 3) {
          sourceCase_ = 0;
          source_ = null;
          onChanged();
        }
      } else {
        if (sourceCase_ == 3) {
          sourceCase_ = 0;
          source_ = null;
        }
        gcsSourceBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cloud Storage location for the input content.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.GcsSource gcs_source = 3;</code>
     */
    public com.google.cloud.discoveryengine.v1beta.GcsSource.Builder getGcsSourceBuilder() {
      return getGcsSourceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Cloud Storage location for the input content.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.GcsSource gcs_source = 3;</code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.GcsSourceOrBuilder getGcsSourceOrBuilder() {
      if ((sourceCase_ == 3) && (gcsSourceBuilder_ != null)) {
        return gcsSourceBuilder_.getMessageOrBuilder();
      } else {
        if (sourceCase_ == 3) {
          return (com.google.cloud.discoveryengine.v1beta.GcsSource) source_;
        }
        return com.google.cloud.discoveryengine.v1beta.GcsSource.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Cloud Storage location for the input content.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.GcsSource gcs_source = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1beta.GcsSource,
            com.google.cloud.discoveryengine.v1beta.GcsSource.Builder,
            com.google.cloud.discoveryengine.v1beta.GcsSourceOrBuilder>
        getGcsSourceFieldBuilder() {
      if (gcsSourceBuilder_ == null) {
        if (!(sourceCase_ == 3)) {
          source_ = com.google.cloud.discoveryengine.v1beta.GcsSource.getDefaultInstance();
        }
        gcsSourceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1beta.GcsSource,
                com.google.cloud.discoveryengine.v1beta.GcsSource.Builder,
                com.google.cloud.discoveryengine.v1beta.GcsSourceOrBuilder>(
                (com.google.cloud.discoveryengine.v1beta.GcsSource) source_,
                getParentForChildren(),
                isClean());
        source_ = null;
      }
      sourceCase_ = 3;
      onChanged();
      return gcsSourceBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1beta.BigQuerySource,
            com.google.cloud.discoveryengine.v1beta.BigQuerySource.Builder,
            com.google.cloud.discoveryengine.v1beta.BigQuerySourceOrBuilder>
        bigquerySourceBuilder_;
    /**
     *
     *
     * <pre>
     * BigQuery input source.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.BigQuerySource bigquery_source = 4;</code>
     *
     * @return Whether the bigquerySource field is set.
     */
    @java.lang.Override
    public boolean hasBigquerySource() {
      return sourceCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * BigQuery input source.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.BigQuerySource bigquery_source = 4;</code>
     *
     * @return The bigquerySource.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.BigQuerySource getBigquerySource() {
      if (bigquerySourceBuilder_ == null) {
        if (sourceCase_ == 4) {
          return (com.google.cloud.discoveryengine.v1beta.BigQuerySource) source_;
        }
        return com.google.cloud.discoveryengine.v1beta.BigQuerySource.getDefaultInstance();
      } else {
        if (sourceCase_ == 4) {
          return bigquerySourceBuilder_.getMessage();
        }
        return com.google.cloud.discoveryengine.v1beta.BigQuerySource.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * BigQuery input source.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.BigQuerySource bigquery_source = 4;</code>
     */
    public Builder setBigquerySource(com.google.cloud.discoveryengine.v1beta.BigQuerySource value) {
      if (bigquerySourceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        source_ = value;
        onChanged();
      } else {
        bigquerySourceBuilder_.setMessage(value);
      }
      sourceCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * BigQuery input source.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.BigQuerySource bigquery_source = 4;</code>
     */
    public Builder setBigquerySource(
        com.google.cloud.discoveryengine.v1beta.BigQuerySource.Builder builderForValue) {
      if (bigquerySourceBuilder_ == null) {
        source_ = builderForValue.build();
        onChanged();
      } else {
        bigquerySourceBuilder_.setMessage(builderForValue.build());
      }
      sourceCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * BigQuery input source.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.BigQuerySource bigquery_source = 4;</code>
     */
    public Builder mergeBigquerySource(
        com.google.cloud.discoveryengine.v1beta.BigQuerySource value) {
      if (bigquerySourceBuilder_ == null) {
        if (sourceCase_ == 4
            && source_
                != com.google.cloud.discoveryengine.v1beta.BigQuerySource.getDefaultInstance()) {
          source_ =
              com.google.cloud.discoveryengine.v1beta.BigQuerySource.newBuilder(
                      (com.google.cloud.discoveryengine.v1beta.BigQuerySource) source_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          source_ = value;
        }
        onChanged();
      } else {
        if (sourceCase_ == 4) {
          bigquerySourceBuilder_.mergeFrom(value);
        } else {
          bigquerySourceBuilder_.setMessage(value);
        }
      }
      sourceCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * BigQuery input source.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.BigQuerySource bigquery_source = 4;</code>
     */
    public Builder clearBigquerySource() {
      if (bigquerySourceBuilder_ == null) {
        if (sourceCase_ == 4) {
          sourceCase_ = 0;
          source_ = null;
          onChanged();
        }
      } else {
        if (sourceCase_ == 4) {
          sourceCase_ = 0;
          source_ = null;
        }
        bigquerySourceBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * BigQuery input source.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.BigQuerySource bigquery_source = 4;</code>
     */
    public com.google.cloud.discoveryengine.v1beta.BigQuerySource.Builder
        getBigquerySourceBuilder() {
      return getBigquerySourceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * BigQuery input source.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.BigQuerySource bigquery_source = 4;</code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.BigQuerySourceOrBuilder
        getBigquerySourceOrBuilder() {
      if ((sourceCase_ == 4) && (bigquerySourceBuilder_ != null)) {
        return bigquerySourceBuilder_.getMessageOrBuilder();
      } else {
        if (sourceCase_ == 4) {
          return (com.google.cloud.discoveryengine.v1beta.BigQuerySource) source_;
        }
        return com.google.cloud.discoveryengine.v1beta.BigQuerySource.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * BigQuery input source.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.BigQuerySource bigquery_source = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1beta.BigQuerySource,
            com.google.cloud.discoveryengine.v1beta.BigQuerySource.Builder,
            com.google.cloud.discoveryengine.v1beta.BigQuerySourceOrBuilder>
        getBigquerySourceFieldBuilder() {
      if (bigquerySourceBuilder_ == null) {
        if (!(sourceCase_ == 4)) {
          source_ = com.google.cloud.discoveryengine.v1beta.BigQuerySource.getDefaultInstance();
        }
        bigquerySourceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1beta.BigQuerySource,
                com.google.cloud.discoveryengine.v1beta.BigQuerySource.Builder,
                com.google.cloud.discoveryengine.v1beta.BigQuerySourceOrBuilder>(
                (com.google.cloud.discoveryengine.v1beta.BigQuerySource) source_,
                getParentForChildren(),
                isClean());
        source_ = null;
      }
      sourceCase_ = 4;
      onChanged();
      return bigquerySourceBuilder_;
    }

    private java.lang.Object parent_ = "";
    /**
     *
     *
     * <pre>
     * Required. The parent branch resource name, such as
     * `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/branches/{branch}`.
     * Requires create/update permission.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The parent.
     */
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The parent branch resource name, such as
     * `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/branches/{branch}`.
     * Requires create/update permission.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for parent.
     */
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The parent branch resource name, such as
     * `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/branches/{branch}`.
     * Requires create/update permission.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The parent to set.
     * @return This builder for chaining.
     */
    public Builder setParent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      parent_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The parent branch resource name, such as
     * `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/branches/{branch}`.
     * Requires create/update permission.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParent() {
      parent_ = getDefaultInstance().getParent();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The parent branch resource name, such as
     * `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/branches/{branch}`.
     * Requires create/update permission.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for parent to set.
     * @return This builder for chaining.
     */
    public Builder setParentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      parent_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private com.google.cloud.discoveryengine.v1beta.ImportErrorConfig errorConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1beta.ImportErrorConfig,
            com.google.cloud.discoveryengine.v1beta.ImportErrorConfig.Builder,
            com.google.cloud.discoveryengine.v1beta.ImportErrorConfigOrBuilder>
        errorConfigBuilder_;
    /**
     *
     *
     * <pre>
     * The desired location of errors incurred during the Import.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.ImportErrorConfig error_config = 5;</code>
     *
     * @return Whether the errorConfig field is set.
     */
    public boolean hasErrorConfig() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * The desired location of errors incurred during the Import.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.ImportErrorConfig error_config = 5;</code>
     *
     * @return The errorConfig.
     */
    public com.google.cloud.discoveryengine.v1beta.ImportErrorConfig getErrorConfig() {
      if (errorConfigBuilder_ == null) {
        return errorConfig_ == null
            ? com.google.cloud.discoveryengine.v1beta.ImportErrorConfig.getDefaultInstance()
            : errorConfig_;
      } else {
        return errorConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The desired location of errors incurred during the Import.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.ImportErrorConfig error_config = 5;</code>
     */
    public Builder setErrorConfig(com.google.cloud.discoveryengine.v1beta.ImportErrorConfig value) {
      if (errorConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        errorConfig_ = value;
      } else {
        errorConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired location of errors incurred during the Import.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.ImportErrorConfig error_config = 5;</code>
     */
    public Builder setErrorConfig(
        com.google.cloud.discoveryengine.v1beta.ImportErrorConfig.Builder builderForValue) {
      if (errorConfigBuilder_ == null) {
        errorConfig_ = builderForValue.build();
      } else {
        errorConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired location of errors incurred during the Import.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.ImportErrorConfig error_config = 5;</code>
     */
    public Builder mergeErrorConfig(
        com.google.cloud.discoveryengine.v1beta.ImportErrorConfig value) {
      if (errorConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && errorConfig_ != null
            && errorConfig_
                != com.google.cloud.discoveryengine.v1beta.ImportErrorConfig.getDefaultInstance()) {
          getErrorConfigBuilder().mergeFrom(value);
        } else {
          errorConfig_ = value;
        }
      } else {
        errorConfigBuilder_.mergeFrom(value);
      }
      if (errorConfig_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired location of errors incurred during the Import.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.ImportErrorConfig error_config = 5;</code>
     */
    public Builder clearErrorConfig() {
      bitField0_ = (bitField0_ & ~0x00000010);
      errorConfig_ = null;
      if (errorConfigBuilder_ != null) {
        errorConfigBuilder_.dispose();
        errorConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired location of errors incurred during the Import.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.ImportErrorConfig error_config = 5;</code>
     */
    public com.google.cloud.discoveryengine.v1beta.ImportErrorConfig.Builder
        getErrorConfigBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getErrorConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The desired location of errors incurred during the Import.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.ImportErrorConfig error_config = 5;</code>
     */
    public com.google.cloud.discoveryengine.v1beta.ImportErrorConfigOrBuilder
        getErrorConfigOrBuilder() {
      if (errorConfigBuilder_ != null) {
        return errorConfigBuilder_.getMessageOrBuilder();
      } else {
        return errorConfig_ == null
            ? com.google.cloud.discoveryengine.v1beta.ImportErrorConfig.getDefaultInstance()
            : errorConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * The desired location of errors incurred during the Import.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.ImportErrorConfig error_config = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1beta.ImportErrorConfig,
            com.google.cloud.discoveryengine.v1beta.ImportErrorConfig.Builder,
            com.google.cloud.discoveryengine.v1beta.ImportErrorConfigOrBuilder>
        getErrorConfigFieldBuilder() {
      if (errorConfigBuilder_ == null) {
        errorConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1beta.ImportErrorConfig,
                com.google.cloud.discoveryengine.v1beta.ImportErrorConfig.Builder,
                com.google.cloud.discoveryengine.v1beta.ImportErrorConfigOrBuilder>(
                getErrorConfig(), getParentForChildren(), isClean());
        errorConfig_ = null;
      }
      return errorConfigBuilder_;
    }

    private int reconciliationMode_ = 0;
    /**
     *
     *
     * <pre>
     * The mode of reconciliation between existing documents and the documents to
     * be imported. Defaults to
     * [ReconciliationMode.INCREMENTAL][google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.ReconciliationMode.INCREMENTAL].
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.ReconciliationMode reconciliation_mode = 6;
     * </code>
     *
     * @return The enum numeric value on the wire for reconciliationMode.
     */
    @java.lang.Override
    public int getReconciliationModeValue() {
      return reconciliationMode_;
    }
    /**
     *
     *
     * <pre>
     * The mode of reconciliation between existing documents and the documents to
     * be imported. Defaults to
     * [ReconciliationMode.INCREMENTAL][google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.ReconciliationMode.INCREMENTAL].
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.ReconciliationMode reconciliation_mode = 6;
     * </code>
     *
     * @param value The enum numeric value on the wire for reconciliationMode to set.
     * @return This builder for chaining.
     */
    public Builder setReconciliationModeValue(int value) {
      reconciliationMode_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The mode of reconciliation between existing documents and the documents to
     * be imported. Defaults to
     * [ReconciliationMode.INCREMENTAL][google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.ReconciliationMode.INCREMENTAL].
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.ReconciliationMode reconciliation_mode = 6;
     * </code>
     *
     * @return The reconciliationMode.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.ReconciliationMode
        getReconciliationMode() {
      com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.ReconciliationMode result =
          com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.ReconciliationMode
              .forNumber(reconciliationMode_);
      return result == null
          ? com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.ReconciliationMode
              .UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * The mode of reconciliation between existing documents and the documents to
     * be imported. Defaults to
     * [ReconciliationMode.INCREMENTAL][google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.ReconciliationMode.INCREMENTAL].
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.ReconciliationMode reconciliation_mode = 6;
     * </code>
     *
     * @param value The reconciliationMode to set.
     * @return This builder for chaining.
     */
    public Builder setReconciliationMode(
        com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.ReconciliationMode value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000020;
      reconciliationMode_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The mode of reconciliation between existing documents and the documents to
     * be imported. Defaults to
     * [ReconciliationMode.INCREMENTAL][google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.ReconciliationMode.INCREMENTAL].
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.ReconciliationMode reconciliation_mode = 6;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearReconciliationMode() {
      bitField0_ = (bitField0_ & ~0x00000020);
      reconciliationMode_ = 0;
      onChanged();
      return this;
    }

    private boolean autoGenerateIds_;
    /**
     *
     *
     * <pre>
     * Whether to automatically generate IDs for the documents if absent.
     *
     * If set to `true`,
     * [Document.id][google.cloud.discoveryengine.v1beta.Document.id]s are
     * automatically generated based on the hash of the payload, where IDs may not
     * be consistent during multiple imports. In which case
     * [ReconciliationMode.FULL][google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.ReconciliationMode.FULL]
     * is highly recommended to avoid duplicate contents. If unset or set to
     * `false`, [Document.id][google.cloud.discoveryengine.v1beta.Document.id]s
     * have to be specified using
     * [id_field][google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.id_field],
     * otherwise, documents without IDs fail to be imported.
     *
     * Only set this field when using
     * [GcsSource][google.cloud.discoveryengine.v1beta.GcsSource] or
     * [BigQuerySource][google.cloud.discoveryengine.v1beta.BigQuerySource], and
     * when
     * [GcsSource.data_schema][google.cloud.discoveryengine.v1beta.GcsSource.data_schema]
     * or
     * [BigQuerySource.data_schema][google.cloud.discoveryengine.v1beta.BigQuerySource.data_schema]
     * is `custom` or `csv`. Otherwise, an INVALID_ARGUMENT error is thrown.
     * </pre>
     *
     * <code>bool auto_generate_ids = 8;</code>
     *
     * @return The autoGenerateIds.
     */
    @java.lang.Override
    public boolean getAutoGenerateIds() {
      return autoGenerateIds_;
    }
    /**
     *
     *
     * <pre>
     * Whether to automatically generate IDs for the documents if absent.
     *
     * If set to `true`,
     * [Document.id][google.cloud.discoveryengine.v1beta.Document.id]s are
     * automatically generated based on the hash of the payload, where IDs may not
     * be consistent during multiple imports. In which case
     * [ReconciliationMode.FULL][google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.ReconciliationMode.FULL]
     * is highly recommended to avoid duplicate contents. If unset or set to
     * `false`, [Document.id][google.cloud.discoveryengine.v1beta.Document.id]s
     * have to be specified using
     * [id_field][google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.id_field],
     * otherwise, documents without IDs fail to be imported.
     *
     * Only set this field when using
     * [GcsSource][google.cloud.discoveryengine.v1beta.GcsSource] or
     * [BigQuerySource][google.cloud.discoveryengine.v1beta.BigQuerySource], and
     * when
     * [GcsSource.data_schema][google.cloud.discoveryengine.v1beta.GcsSource.data_schema]
     * or
     * [BigQuerySource.data_schema][google.cloud.discoveryengine.v1beta.BigQuerySource.data_schema]
     * is `custom` or `csv`. Otherwise, an INVALID_ARGUMENT error is thrown.
     * </pre>
     *
     * <code>bool auto_generate_ids = 8;</code>
     *
     * @param value The autoGenerateIds to set.
     * @return This builder for chaining.
     */
    public Builder setAutoGenerateIds(boolean value) {

      autoGenerateIds_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Whether to automatically generate IDs for the documents if absent.
     *
     * If set to `true`,
     * [Document.id][google.cloud.discoveryengine.v1beta.Document.id]s are
     * automatically generated based on the hash of the payload, where IDs may not
     * be consistent during multiple imports. In which case
     * [ReconciliationMode.FULL][google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.ReconciliationMode.FULL]
     * is highly recommended to avoid duplicate contents. If unset or set to
     * `false`, [Document.id][google.cloud.discoveryengine.v1beta.Document.id]s
     * have to be specified using
     * [id_field][google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.id_field],
     * otherwise, documents without IDs fail to be imported.
     *
     * Only set this field when using
     * [GcsSource][google.cloud.discoveryengine.v1beta.GcsSource] or
     * [BigQuerySource][google.cloud.discoveryengine.v1beta.BigQuerySource], and
     * when
     * [GcsSource.data_schema][google.cloud.discoveryengine.v1beta.GcsSource.data_schema]
     * or
     * [BigQuerySource.data_schema][google.cloud.discoveryengine.v1beta.BigQuerySource.data_schema]
     * is `custom` or `csv`. Otherwise, an INVALID_ARGUMENT error is thrown.
     * </pre>
     *
     * <code>bool auto_generate_ids = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAutoGenerateIds() {
      bitField0_ = (bitField0_ & ~0x00000040);
      autoGenerateIds_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object idField_ = "";
    /**
     *
     *
     * <pre>
     * The field in the Cloud Storage and BigQuery sources that indicates the
     * unique IDs of the documents.
     *
     * For [GcsSource][google.cloud.discoveryengine.v1beta.GcsSource] it is the
     * key of the JSON field. For instance, `my_id` for JSON `{"my_id":
     * "some_uuid"}`. For
     * [BigQuerySource][google.cloud.discoveryengine.v1beta.BigQuerySource] it is
     * the column name of the BigQuery table where the unique ids are stored.
     *
     * The values of the JSON field or the BigQuery column are used as the
     * [Document.id][google.cloud.discoveryengine.v1beta.Document.id]s. The JSON
     * field or the BigQuery column must be of string type, and the values must be
     * set as valid strings conform to
     * [RFC-1034](https://tools.ietf.org/html/rfc1034) with 1-63 characters.
     * Otherwise, documents without valid IDs fail to be imported.
     *
     * Only set this field when using
     * [GcsSource][google.cloud.discoveryengine.v1beta.GcsSource] or
     * [BigQuerySource][google.cloud.discoveryengine.v1beta.BigQuerySource], and
     * when
     * [GcsSource.data_schema][google.cloud.discoveryengine.v1beta.GcsSource.data_schema]
     * or
     * [BigQuerySource.data_schema][google.cloud.discoveryengine.v1beta.BigQuerySource.data_schema]
     * is `custom`. And only set this field when
     * [auto_generate_ids][google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.auto_generate_ids]
     * is unset or set as `false`. Otherwise, an INVALID_ARGUMENT error is thrown.
     *
     * If it is unset, a default value `_id` is used when importing from the
     * allowed data sources.
     * </pre>
     *
     * <code>string id_field = 9;</code>
     *
     * @return The idField.
     */
    public java.lang.String getIdField() {
      java.lang.Object ref = idField_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        idField_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The field in the Cloud Storage and BigQuery sources that indicates the
     * unique IDs of the documents.
     *
     * For [GcsSource][google.cloud.discoveryengine.v1beta.GcsSource] it is the
     * key of the JSON field. For instance, `my_id` for JSON `{"my_id":
     * "some_uuid"}`. For
     * [BigQuerySource][google.cloud.discoveryengine.v1beta.BigQuerySource] it is
     * the column name of the BigQuery table where the unique ids are stored.
     *
     * The values of the JSON field or the BigQuery column are used as the
     * [Document.id][google.cloud.discoveryengine.v1beta.Document.id]s. The JSON
     * field or the BigQuery column must be of string type, and the values must be
     * set as valid strings conform to
     * [RFC-1034](https://tools.ietf.org/html/rfc1034) with 1-63 characters.
     * Otherwise, documents without valid IDs fail to be imported.
     *
     * Only set this field when using
     * [GcsSource][google.cloud.discoveryengine.v1beta.GcsSource] or
     * [BigQuerySource][google.cloud.discoveryengine.v1beta.BigQuerySource], and
     * when
     * [GcsSource.data_schema][google.cloud.discoveryengine.v1beta.GcsSource.data_schema]
     * or
     * [BigQuerySource.data_schema][google.cloud.discoveryengine.v1beta.BigQuerySource.data_schema]
     * is `custom`. And only set this field when
     * [auto_generate_ids][google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.auto_generate_ids]
     * is unset or set as `false`. Otherwise, an INVALID_ARGUMENT error is thrown.
     *
     * If it is unset, a default value `_id` is used when importing from the
     * allowed data sources.
     * </pre>
     *
     * <code>string id_field = 9;</code>
     *
     * @return The bytes for idField.
     */
    public com.google.protobuf.ByteString getIdFieldBytes() {
      java.lang.Object ref = idField_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        idField_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The field in the Cloud Storage and BigQuery sources that indicates the
     * unique IDs of the documents.
     *
     * For [GcsSource][google.cloud.discoveryengine.v1beta.GcsSource] it is the
     * key of the JSON field. For instance, `my_id` for JSON `{"my_id":
     * "some_uuid"}`. For
     * [BigQuerySource][google.cloud.discoveryengine.v1beta.BigQuerySource] it is
     * the column name of the BigQuery table where the unique ids are stored.
     *
     * The values of the JSON field or the BigQuery column are used as the
     * [Document.id][google.cloud.discoveryengine.v1beta.Document.id]s. The JSON
     * field or the BigQuery column must be of string type, and the values must be
     * set as valid strings conform to
     * [RFC-1034](https://tools.ietf.org/html/rfc1034) with 1-63 characters.
     * Otherwise, documents without valid IDs fail to be imported.
     *
     * Only set this field when using
     * [GcsSource][google.cloud.discoveryengine.v1beta.GcsSource] or
     * [BigQuerySource][google.cloud.discoveryengine.v1beta.BigQuerySource], and
     * when
     * [GcsSource.data_schema][google.cloud.discoveryengine.v1beta.GcsSource.data_schema]
     * or
     * [BigQuerySource.data_schema][google.cloud.discoveryengine.v1beta.BigQuerySource.data_schema]
     * is `custom`. And only set this field when
     * [auto_generate_ids][google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.auto_generate_ids]
     * is unset or set as `false`. Otherwise, an INVALID_ARGUMENT error is thrown.
     *
     * If it is unset, a default value `_id` is used when importing from the
     * allowed data sources.
     * </pre>
     *
     * <code>string id_field = 9;</code>
     *
     * @param value The idField to set.
     * @return This builder for chaining.
     */
    public Builder setIdField(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      idField_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The field in the Cloud Storage and BigQuery sources that indicates the
     * unique IDs of the documents.
     *
     * For [GcsSource][google.cloud.discoveryengine.v1beta.GcsSource] it is the
     * key of the JSON field. For instance, `my_id` for JSON `{"my_id":
     * "some_uuid"}`. For
     * [BigQuerySource][google.cloud.discoveryengine.v1beta.BigQuerySource] it is
     * the column name of the BigQuery table where the unique ids are stored.
     *
     * The values of the JSON field or the BigQuery column are used as the
     * [Document.id][google.cloud.discoveryengine.v1beta.Document.id]s. The JSON
     * field or the BigQuery column must be of string type, and the values must be
     * set as valid strings conform to
     * [RFC-1034](https://tools.ietf.org/html/rfc1034) with 1-63 characters.
     * Otherwise, documents without valid IDs fail to be imported.
     *
     * Only set this field when using
     * [GcsSource][google.cloud.discoveryengine.v1beta.GcsSource] or
     * [BigQuerySource][google.cloud.discoveryengine.v1beta.BigQuerySource], and
     * when
     * [GcsSource.data_schema][google.cloud.discoveryengine.v1beta.GcsSource.data_schema]
     * or
     * [BigQuerySource.data_schema][google.cloud.discoveryengine.v1beta.BigQuerySource.data_schema]
     * is `custom`. And only set this field when
     * [auto_generate_ids][google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.auto_generate_ids]
     * is unset or set as `false`. Otherwise, an INVALID_ARGUMENT error is thrown.
     *
     * If it is unset, a default value `_id` is used when importing from the
     * allowed data sources.
     * </pre>
     *
     * <code>string id_field = 9;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIdField() {
      idField_ = getDefaultInstance().getIdField();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The field in the Cloud Storage and BigQuery sources that indicates the
     * unique IDs of the documents.
     *
     * For [GcsSource][google.cloud.discoveryengine.v1beta.GcsSource] it is the
     * key of the JSON field. For instance, `my_id` for JSON `{"my_id":
     * "some_uuid"}`. For
     * [BigQuerySource][google.cloud.discoveryengine.v1beta.BigQuerySource] it is
     * the column name of the BigQuery table where the unique ids are stored.
     *
     * The values of the JSON field or the BigQuery column are used as the
     * [Document.id][google.cloud.discoveryengine.v1beta.Document.id]s. The JSON
     * field or the BigQuery column must be of string type, and the values must be
     * set as valid strings conform to
     * [RFC-1034](https://tools.ietf.org/html/rfc1034) with 1-63 characters.
     * Otherwise, documents without valid IDs fail to be imported.
     *
     * Only set this field when using
     * [GcsSource][google.cloud.discoveryengine.v1beta.GcsSource] or
     * [BigQuerySource][google.cloud.discoveryengine.v1beta.BigQuerySource], and
     * when
     * [GcsSource.data_schema][google.cloud.discoveryengine.v1beta.GcsSource.data_schema]
     * or
     * [BigQuerySource.data_schema][google.cloud.discoveryengine.v1beta.BigQuerySource.data_schema]
     * is `custom`. And only set this field when
     * [auto_generate_ids][google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.auto_generate_ids]
     * is unset or set as `false`. Otherwise, an INVALID_ARGUMENT error is thrown.
     *
     * If it is unset, a default value `_id` is used when importing from the
     * allowed data sources.
     * </pre>
     *
     * <code>string id_field = 9;</code>
     *
     * @param value The bytes for idField to set.
     * @return This builder for chaining.
     */
    public Builder setIdFieldBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      idField_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.ImportDocumentsRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.ImportDocumentsRequest)
  private static final com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest();
  }

  public static com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ImportDocumentsRequest> PARSER =
      new com.google.protobuf.AbstractParser<ImportDocumentsRequest>() {
        @java.lang.Override
        public ImportDocumentsRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ImportDocumentsRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ImportDocumentsRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.ImportDocumentsRequest
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
