/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/discoveryengine/v1beta/recommendation_service.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.discoveryengine.v1beta;

/**
 *
 *
 * <pre>
 * Request message for Recommend method.
 * </pre>
 *
 * Protobuf type {@code google.cloud.discoveryengine.v1beta.RecommendRequest}
 */
public final class RecommendRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.RecommendRequest)
    RecommendRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use RecommendRequest.newBuilder() to construct.
  private RecommendRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private RecommendRequest() {
    servingConfig_ = "";
    filter_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new RecommendRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.discoveryengine.v1beta.RecommendationServiceProto
        .internal_static_google_cloud_discoveryengine_v1beta_RecommendRequest_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 6:
        return internalGetParams();
      case 8:
        return internalGetUserLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.discoveryengine.v1beta.RecommendationServiceProto
        .internal_static_google_cloud_discoveryengine_v1beta_RecommendRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.discoveryengine.v1beta.RecommendRequest.class,
            com.google.cloud.discoveryengine.v1beta.RecommendRequest.Builder.class);
  }

  private int bitField0_;
  public static final int SERVING_CONFIG_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object servingConfig_ = "";
  /**
   *
   *
   * <pre>
   * Required. Full resource name of a
   * [ServingConfig][google.cloud.discoveryengine.v1beta.ServingConfig]:
   * `projects/&#42;&#47;locations/global/collections/&#42;&#47;engines/&#42;&#47;servingConfigs/&#42;`, or
   * `projects/&#42;&#47;locations/global/collections/&#42;&#47;dataStores/&#42;&#47;servingConfigs/&#42;`
   *
   * One default serving config is created along with your recommendation engine
   * creation. The engine ID will be used as the ID of the default serving
   * config. For example, for Engine
   * `projects/&#42;&#47;locations/global/collections/&#42;&#47;engines/my-engine`, you can use
   * `projects/&#42;&#47;locations/global/collections/&#42;&#47;engines/my-engine/servingConfigs/my-engine`
   * for your
   * [RecommendationService.Recommend][google.cloud.discoveryengine.v1beta.RecommendationService.Recommend]
   * requests.
   * </pre>
   *
   * <code>
   * string serving_config = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The servingConfig.
   */
  @java.lang.Override
  public java.lang.String getServingConfig() {
    java.lang.Object ref = servingConfig_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      servingConfig_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Full resource name of a
   * [ServingConfig][google.cloud.discoveryengine.v1beta.ServingConfig]:
   * `projects/&#42;&#47;locations/global/collections/&#42;&#47;engines/&#42;&#47;servingConfigs/&#42;`, or
   * `projects/&#42;&#47;locations/global/collections/&#42;&#47;dataStores/&#42;&#47;servingConfigs/&#42;`
   *
   * One default serving config is created along with your recommendation engine
   * creation. The engine ID will be used as the ID of the default serving
   * config. For example, for Engine
   * `projects/&#42;&#47;locations/global/collections/&#42;&#47;engines/my-engine`, you can use
   * `projects/&#42;&#47;locations/global/collections/&#42;&#47;engines/my-engine/servingConfigs/my-engine`
   * for your
   * [RecommendationService.Recommend][google.cloud.discoveryengine.v1beta.RecommendationService.Recommend]
   * requests.
   * </pre>
   *
   * <code>
   * string serving_config = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for servingConfig.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getServingConfigBytes() {
    java.lang.Object ref = servingConfig_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      servingConfig_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int USER_EVENT_FIELD_NUMBER = 2;
  private com.google.cloud.discoveryengine.v1beta.UserEvent userEvent_;
  /**
   *
   *
   * <pre>
   * Required. Context about the user, what they are looking at and what action
   * they took to trigger the Recommend request. Note that this user event
   * detail won't be ingested to userEvent logs. Thus, a separate userEvent
   * write request is required for event logging.
   *
   * Don't set
   * [UserEvent.user_pseudo_id][google.cloud.discoveryengine.v1beta.UserEvent.user_pseudo_id]
   * or
   * [UserEvent.user_info.user_id][google.cloud.discoveryengine.v1beta.UserInfo.user_id]
   * to the same fixed ID for different users. If you are trying to receive
   * non-personalized recommendations (not recommended; this can negatively
   * impact model performance), instead set
   * [UserEvent.user_pseudo_id][google.cloud.discoveryengine.v1beta.UserEvent.user_pseudo_id]
   * to a random unique ID and leave
   * [UserEvent.user_info.user_id][google.cloud.discoveryengine.v1beta.UserInfo.user_id]
   * unset.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1beta.UserEvent user_event = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the userEvent field is set.
   */
  @java.lang.Override
  public boolean hasUserEvent() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Required. Context about the user, what they are looking at and what action
   * they took to trigger the Recommend request. Note that this user event
   * detail won't be ingested to userEvent logs. Thus, a separate userEvent
   * write request is required for event logging.
   *
   * Don't set
   * [UserEvent.user_pseudo_id][google.cloud.discoveryengine.v1beta.UserEvent.user_pseudo_id]
   * or
   * [UserEvent.user_info.user_id][google.cloud.discoveryengine.v1beta.UserInfo.user_id]
   * to the same fixed ID for different users. If you are trying to receive
   * non-personalized recommendations (not recommended; this can negatively
   * impact model performance), instead set
   * [UserEvent.user_pseudo_id][google.cloud.discoveryengine.v1beta.UserEvent.user_pseudo_id]
   * to a random unique ID and leave
   * [UserEvent.user_info.user_id][google.cloud.discoveryengine.v1beta.UserInfo.user_id]
   * unset.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1beta.UserEvent user_event = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The userEvent.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.UserEvent getUserEvent() {
    return userEvent_ == null
        ? com.google.cloud.discoveryengine.v1beta.UserEvent.getDefaultInstance()
        : userEvent_;
  }
  /**
   *
   *
   * <pre>
   * Required. Context about the user, what they are looking at and what action
   * they took to trigger the Recommend request. Note that this user event
   * detail won't be ingested to userEvent logs. Thus, a separate userEvent
   * write request is required for event logging.
   *
   * Don't set
   * [UserEvent.user_pseudo_id][google.cloud.discoveryengine.v1beta.UserEvent.user_pseudo_id]
   * or
   * [UserEvent.user_info.user_id][google.cloud.discoveryengine.v1beta.UserInfo.user_id]
   * to the same fixed ID for different users. If you are trying to receive
   * non-personalized recommendations (not recommended; this can negatively
   * impact model performance), instead set
   * [UserEvent.user_pseudo_id][google.cloud.discoveryengine.v1beta.UserEvent.user_pseudo_id]
   * to a random unique ID and leave
   * [UserEvent.user_info.user_id][google.cloud.discoveryengine.v1beta.UserInfo.user_id]
   * unset.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1beta.UserEvent user_event = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.UserEventOrBuilder getUserEventOrBuilder() {
    return userEvent_ == null
        ? com.google.cloud.discoveryengine.v1beta.UserEvent.getDefaultInstance()
        : userEvent_;
  }

  public static final int PAGE_SIZE_FIELD_NUMBER = 3;
  private int pageSize_ = 0;
  /**
   *
   *
   * <pre>
   * Maximum number of results to return. Set this property
   * to the number of recommendation results needed. If zero, the service will
   * choose a reasonable default. The maximum allowed value is 100. Values
   * above 100 will be coerced to 100.
   * </pre>
   *
   * <code>int32 page_size = 3;</code>
   *
   * @return The pageSize.
   */
  @java.lang.Override
  public int getPageSize() {
    return pageSize_;
  }

  public static final int FILTER_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object filter_ = "";
  /**
   *
   *
   * <pre>
   * Filter for restricting recommendation results with a length limit of 5,000
   * characters. Currently, only filter expressions on the `filter_tags`
   * attribute is supported.
   *
   *
   * Examples:
   *
   *  * `(filter_tags: ANY("Red", "Blue") OR filter_tags: ANY("Hot", "Cold"))`
   *  * `(filter_tags: ANY("Red", "Blue")) AND NOT (filter_tags: ANY("Green"))`
   *
   * If `attributeFilteringSyntax` is set to true under the `params` field, then
   * attribute-based expressions are expected instead of the above described
   * tag-based syntax. Examples:
   *
   *  * (launguage: ANY("en", "es")) AND NOT (categories: ANY("Movie"))
   *  * (available: true) AND
   *    (launguage: ANY("en", "es")) OR (categories: ANY("Movie"))
   *
   * If your filter blocks all results, the API will return generic
   * (unfiltered) popular Documents. If you only want results strictly matching
   * the filters, set `strictFiltering` to True in
   * [RecommendRequest.params][google.cloud.discoveryengine.v1beta.RecommendRequest.params]
   * to receive empty results instead.
   *
   * Note that the API will never return
   * [Document][google.cloud.discoveryengine.v1beta.Document]s with
   * `storageStatus` of `EXPIRED` or `DELETED` regardless of filter choices.
   * </pre>
   *
   * <code>string filter = 4;</code>
   *
   * @return The filter.
   */
  @java.lang.Override
  public java.lang.String getFilter() {
    java.lang.Object ref = filter_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      filter_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Filter for restricting recommendation results with a length limit of 5,000
   * characters. Currently, only filter expressions on the `filter_tags`
   * attribute is supported.
   *
   *
   * Examples:
   *
   *  * `(filter_tags: ANY("Red", "Blue") OR filter_tags: ANY("Hot", "Cold"))`
   *  * `(filter_tags: ANY("Red", "Blue")) AND NOT (filter_tags: ANY("Green"))`
   *
   * If `attributeFilteringSyntax` is set to true under the `params` field, then
   * attribute-based expressions are expected instead of the above described
   * tag-based syntax. Examples:
   *
   *  * (launguage: ANY("en", "es")) AND NOT (categories: ANY("Movie"))
   *  * (available: true) AND
   *    (launguage: ANY("en", "es")) OR (categories: ANY("Movie"))
   *
   * If your filter blocks all results, the API will return generic
   * (unfiltered) popular Documents. If you only want results strictly matching
   * the filters, set `strictFiltering` to True in
   * [RecommendRequest.params][google.cloud.discoveryengine.v1beta.RecommendRequest.params]
   * to receive empty results instead.
   *
   * Note that the API will never return
   * [Document][google.cloud.discoveryengine.v1beta.Document]s with
   * `storageStatus` of `EXPIRED` or `DELETED` regardless of filter choices.
   * </pre>
   *
   * <code>string filter = 4;</code>
   *
   * @return The bytes for filter.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFilterBytes() {
    java.lang.Object ref = filter_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      filter_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int VALIDATE_ONLY_FIELD_NUMBER = 5;
  private boolean validateOnly_ = false;
  /**
   *
   *
   * <pre>
   * Use validate only mode for this recommendation query. If set to true, a
   * fake model will be used that returns arbitrary Document IDs.
   * Note that the validate only mode should only be used for testing the API,
   * or if the model is not ready.
   * </pre>
   *
   * <code>bool validate_only = 5;</code>
   *
   * @return The validateOnly.
   */
  @java.lang.Override
  public boolean getValidateOnly() {
    return validateOnly_;
  }

  public static final int PARAMS_FIELD_NUMBER = 6;

  private static final class ParamsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, com.google.protobuf.Value>
        defaultEntry =
            com.google.protobuf.MapEntry
                .<java.lang.String, com.google.protobuf.Value>newDefaultInstance(
                    com.google.cloud.discoveryengine.v1beta.RecommendationServiceProto
                        .internal_static_google_cloud_discoveryengine_v1beta_RecommendRequest_ParamsEntry_descriptor,
                    com.google.protobuf.WireFormat.FieldType.STRING,
                    "",
                    com.google.protobuf.WireFormat.FieldType.MESSAGE,
                    com.google.protobuf.Value.getDefaultInstance());
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, com.google.protobuf.Value> params_;

  private com.google.protobuf.MapField<java.lang.String, com.google.protobuf.Value>
      internalGetParams() {
    if (params_ == null) {
      return com.google.protobuf.MapField.emptyMapField(ParamsDefaultEntryHolder.defaultEntry);
    }
    return params_;
  }

  public int getParamsCount() {
    return internalGetParams().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Additional domain specific parameters for the recommendations.
   *
   * Allowed values:
   *
   * * `returnDocument`: Boolean. If set to true, the associated Document
   *    object will be returned in
   *    [RecommendResponse.RecommendationResult.document][google.cloud.discoveryengine.v1beta.RecommendResponse.RecommendationResult.document].
   * * `returnScore`: Boolean. If set to true, the recommendation 'score'
   *    corresponding to each returned Document will be set in
   *    [RecommendResponse.RecommendationResult.metadata][google.cloud.discoveryengine.v1beta.RecommendResponse.RecommendationResult.metadata].
   *    The given 'score' indicates the probability of a Document conversion
   *    given the user's context and history.
   * * `strictFiltering`: Boolean. True by default. If set to false, the service
   *    will return generic (unfiltered) popular Documents instead of empty if
   *    your filter blocks all recommendation results.
   * * `diversityLevel`: String. Default empty. If set to be non-empty, then
   *    it needs to be one of:
   *     *  `no-diversity`
   *     *  `low-diversity`
   *     *  `medium-diversity`
   *     *  `high-diversity`
   *     *  `auto-diversity`
   *    This gives request-level control and adjusts recommendation results
   *    based on Document category.
   * * `attributeFilteringSyntax`: Boolean. False by default. If set to true,
   *    the `filter` field is interpreted according to the new,
   *    attribute-based syntax.
   * </pre>
   *
   * <code>map&lt;string, .google.protobuf.Value&gt; params = 6;</code>
   */
  @java.lang.Override
  public boolean containsParams(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetParams().getMap().containsKey(key);
  }
  /** Use {@link #getParamsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, com.google.protobuf.Value> getParams() {
    return getParamsMap();
  }
  /**
   *
   *
   * <pre>
   * Additional domain specific parameters for the recommendations.
   *
   * Allowed values:
   *
   * * `returnDocument`: Boolean. If set to true, the associated Document
   *    object will be returned in
   *    [RecommendResponse.RecommendationResult.document][google.cloud.discoveryengine.v1beta.RecommendResponse.RecommendationResult.document].
   * * `returnScore`: Boolean. If set to true, the recommendation 'score'
   *    corresponding to each returned Document will be set in
   *    [RecommendResponse.RecommendationResult.metadata][google.cloud.discoveryengine.v1beta.RecommendResponse.RecommendationResult.metadata].
   *    The given 'score' indicates the probability of a Document conversion
   *    given the user's context and history.
   * * `strictFiltering`: Boolean. True by default. If set to false, the service
   *    will return generic (unfiltered) popular Documents instead of empty if
   *    your filter blocks all recommendation results.
   * * `diversityLevel`: String. Default empty. If set to be non-empty, then
   *    it needs to be one of:
   *     *  `no-diversity`
   *     *  `low-diversity`
   *     *  `medium-diversity`
   *     *  `high-diversity`
   *     *  `auto-diversity`
   *    This gives request-level control and adjusts recommendation results
   *    based on Document category.
   * * `attributeFilteringSyntax`: Boolean. False by default. If set to true,
   *    the `filter` field is interpreted according to the new,
   *    attribute-based syntax.
   * </pre>
   *
   * <code>map&lt;string, .google.protobuf.Value&gt; params = 6;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, com.google.protobuf.Value> getParamsMap() {
    return internalGetParams().getMap();
  }
  /**
   *
   *
   * <pre>
   * Additional domain specific parameters for the recommendations.
   *
   * Allowed values:
   *
   * * `returnDocument`: Boolean. If set to true, the associated Document
   *    object will be returned in
   *    [RecommendResponse.RecommendationResult.document][google.cloud.discoveryengine.v1beta.RecommendResponse.RecommendationResult.document].
   * * `returnScore`: Boolean. If set to true, the recommendation 'score'
   *    corresponding to each returned Document will be set in
   *    [RecommendResponse.RecommendationResult.metadata][google.cloud.discoveryengine.v1beta.RecommendResponse.RecommendationResult.metadata].
   *    The given 'score' indicates the probability of a Document conversion
   *    given the user's context and history.
   * * `strictFiltering`: Boolean. True by default. If set to false, the service
   *    will return generic (unfiltered) popular Documents instead of empty if
   *    your filter blocks all recommendation results.
   * * `diversityLevel`: String. Default empty. If set to be non-empty, then
   *    it needs to be one of:
   *     *  `no-diversity`
   *     *  `low-diversity`
   *     *  `medium-diversity`
   *     *  `high-diversity`
   *     *  `auto-diversity`
   *    This gives request-level control and adjusts recommendation results
   *    based on Document category.
   * * `attributeFilteringSyntax`: Boolean. False by default. If set to true,
   *    the `filter` field is interpreted according to the new,
   *    attribute-based syntax.
   * </pre>
   *
   * <code>map&lt;string, .google.protobuf.Value&gt; params = 6;</code>
   */
  @java.lang.Override
  public /* nullable */ com.google.protobuf.Value getParamsOrDefault(
      java.lang.String key,
      /* nullable */
      com.google.protobuf.Value defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.protobuf.Value> map = internalGetParams().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Additional domain specific parameters for the recommendations.
   *
   * Allowed values:
   *
   * * `returnDocument`: Boolean. If set to true, the associated Document
   *    object will be returned in
   *    [RecommendResponse.RecommendationResult.document][google.cloud.discoveryengine.v1beta.RecommendResponse.RecommendationResult.document].
   * * `returnScore`: Boolean. If set to true, the recommendation 'score'
   *    corresponding to each returned Document will be set in
   *    [RecommendResponse.RecommendationResult.metadata][google.cloud.discoveryengine.v1beta.RecommendResponse.RecommendationResult.metadata].
   *    The given 'score' indicates the probability of a Document conversion
   *    given the user's context and history.
   * * `strictFiltering`: Boolean. True by default. If set to false, the service
   *    will return generic (unfiltered) popular Documents instead of empty if
   *    your filter blocks all recommendation results.
   * * `diversityLevel`: String. Default empty. If set to be non-empty, then
   *    it needs to be one of:
   *     *  `no-diversity`
   *     *  `low-diversity`
   *     *  `medium-diversity`
   *     *  `high-diversity`
   *     *  `auto-diversity`
   *    This gives request-level control and adjusts recommendation results
   *    based on Document category.
   * * `attributeFilteringSyntax`: Boolean. False by default. If set to true,
   *    the `filter` field is interpreted according to the new,
   *    attribute-based syntax.
   * </pre>
   *
   * <code>map&lt;string, .google.protobuf.Value&gt; params = 6;</code>
   */
  @java.lang.Override
  public com.google.protobuf.Value getParamsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.protobuf.Value> map = internalGetParams().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int USER_LABELS_FIELD_NUMBER = 8;

  private static final class UserLabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.discoveryengine.v1beta.RecommendationServiceProto
                .internal_static_google_cloud_discoveryengine_v1beta_RecommendRequest_UserLabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> userLabels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetUserLabels() {
    if (userLabels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(UserLabelsDefaultEntryHolder.defaultEntry);
    }
    return userLabels_;
  }

  public int getUserLabelsCount() {
    return internalGetUserLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * The user labels applied to a resource must meet the following requirements:
   *
   * * Each resource can have multiple labels, up to a maximum of 64.
   * * Each label must be a key-value pair.
   * * Keys have a minimum length of 1 character and a maximum length of 63
   *   characters and cannot be empty. Values can be empty and have a maximum
   *   length of 63 characters.
   * * Keys and values can contain only lowercase letters, numeric characters,
   *   underscores, and dashes. All characters must use UTF-8 encoding, and
   *   international characters are allowed.
   * * The key portion of a label must be unique. However, you can use the same
   *   key with multiple resources.
   * * Keys must start with a lowercase letter or international character.
   *
   * See [Requirements for
   * labels](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
   * for more details.
   * </pre>
   *
   * <code>map&lt;string, string&gt; user_labels = 8;</code>
   */
  @java.lang.Override
  public boolean containsUserLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetUserLabels().getMap().containsKey(key);
  }
  /** Use {@link #getUserLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getUserLabels() {
    return getUserLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * The user labels applied to a resource must meet the following requirements:
   *
   * * Each resource can have multiple labels, up to a maximum of 64.
   * * Each label must be a key-value pair.
   * * Keys have a minimum length of 1 character and a maximum length of 63
   *   characters and cannot be empty. Values can be empty and have a maximum
   *   length of 63 characters.
   * * Keys and values can contain only lowercase letters, numeric characters,
   *   underscores, and dashes. All characters must use UTF-8 encoding, and
   *   international characters are allowed.
   * * The key portion of a label must be unique. However, you can use the same
   *   key with multiple resources.
   * * Keys must start with a lowercase letter or international character.
   *
   * See [Requirements for
   * labels](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
   * for more details.
   * </pre>
   *
   * <code>map&lt;string, string&gt; user_labels = 8;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getUserLabelsMap() {
    return internalGetUserLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * The user labels applied to a resource must meet the following requirements:
   *
   * * Each resource can have multiple labels, up to a maximum of 64.
   * * Each label must be a key-value pair.
   * * Keys have a minimum length of 1 character and a maximum length of 63
   *   characters and cannot be empty. Values can be empty and have a maximum
   *   length of 63 characters.
   * * Keys and values can contain only lowercase letters, numeric characters,
   *   underscores, and dashes. All characters must use UTF-8 encoding, and
   *   international characters are allowed.
   * * The key portion of a label must be unique. However, you can use the same
   *   key with multiple resources.
   * * Keys must start with a lowercase letter or international character.
   *
   * See [Requirements for
   * labels](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
   * for more details.
   * </pre>
   *
   * <code>map&lt;string, string&gt; user_labels = 8;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getUserLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetUserLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * The user labels applied to a resource must meet the following requirements:
   *
   * * Each resource can have multiple labels, up to a maximum of 64.
   * * Each label must be a key-value pair.
   * * Keys have a minimum length of 1 character and a maximum length of 63
   *   characters and cannot be empty. Values can be empty and have a maximum
   *   length of 63 characters.
   * * Keys and values can contain only lowercase letters, numeric characters,
   *   underscores, and dashes. All characters must use UTF-8 encoding, and
   *   international characters are allowed.
   * * The key portion of a label must be unique. However, you can use the same
   *   key with multiple resources.
   * * Keys must start with a lowercase letter or international character.
   *
   * See [Requirements for
   * labels](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
   * for more details.
   * </pre>
   *
   * <code>map&lt;string, string&gt; user_labels = 8;</code>
   */
  @java.lang.Override
  public java.lang.String getUserLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetUserLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(servingConfig_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, servingConfig_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(2, getUserEvent());
    }
    if (pageSize_ != 0) {
      output.writeInt32(3, pageSize_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(filter_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, filter_);
    }
    if (validateOnly_ != false) {
      output.writeBool(5, validateOnly_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetParams(), ParamsDefaultEntryHolder.defaultEntry, 6);
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetUserLabels(), UserLabelsDefaultEntryHolder.defaultEntry, 8);
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(servingConfig_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, servingConfig_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getUserEvent());
    }
    if (pageSize_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(3, pageSize_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(filter_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, filter_);
    }
    if (validateOnly_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(5, validateOnly_);
    }
    for (java.util.Map.Entry<java.lang.String, com.google.protobuf.Value> entry :
        internalGetParams().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, com.google.protobuf.Value> params__ =
          ParamsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, params__);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetUserLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> userLabels__ =
          UserLabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, userLabels__);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.discoveryengine.v1beta.RecommendRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.discoveryengine.v1beta.RecommendRequest other =
        (com.google.cloud.discoveryengine.v1beta.RecommendRequest) obj;

    if (!getServingConfig().equals(other.getServingConfig())) return false;
    if (hasUserEvent() != other.hasUserEvent()) return false;
    if (hasUserEvent()) {
      if (!getUserEvent().equals(other.getUserEvent())) return false;
    }
    if (getPageSize() != other.getPageSize()) return false;
    if (!getFilter().equals(other.getFilter())) return false;
    if (getValidateOnly() != other.getValidateOnly()) return false;
    if (!internalGetParams().equals(other.internalGetParams())) return false;
    if (!internalGetUserLabels().equals(other.internalGetUserLabels())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + SERVING_CONFIG_FIELD_NUMBER;
    hash = (53 * hash) + getServingConfig().hashCode();
    if (hasUserEvent()) {
      hash = (37 * hash) + USER_EVENT_FIELD_NUMBER;
      hash = (53 * hash) + getUserEvent().hashCode();
    }
    hash = (37 * hash) + PAGE_SIZE_FIELD_NUMBER;
    hash = (53 * hash) + getPageSize();
    hash = (37 * hash) + FILTER_FIELD_NUMBER;
    hash = (53 * hash) + getFilter().hashCode();
    hash = (37 * hash) + VALIDATE_ONLY_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getValidateOnly());
    if (!internalGetParams().getMap().isEmpty()) {
      hash = (37 * hash) + PARAMS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetParams().hashCode();
    }
    if (!internalGetUserLabels().getMap().isEmpty()) {
      hash = (37 * hash) + USER_LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetUserLabels().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.discoveryengine.v1beta.RecommendRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1beta.RecommendRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.RecommendRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1beta.RecommendRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.RecommendRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1beta.RecommendRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.RecommendRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1beta.RecommendRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.RecommendRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1beta.RecommendRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.RecommendRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1beta.RecommendRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.discoveryengine.v1beta.RecommendRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request message for Recommend method.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1beta.RecommendRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.RecommendRequest)
      com.google.cloud.discoveryengine.v1beta.RecommendRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1beta.RecommendationServiceProto
          .internal_static_google_cloud_discoveryengine_v1beta_RecommendRequest_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 6:
          return internalGetParams();
        case 8:
          return internalGetUserLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 6:
          return internalGetMutableParams();
        case 8:
          return internalGetMutableUserLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1beta.RecommendationServiceProto
          .internal_static_google_cloud_discoveryengine_v1beta_RecommendRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1beta.RecommendRequest.class,
              com.google.cloud.discoveryengine.v1beta.RecommendRequest.Builder.class);
    }

    // Construct using com.google.cloud.discoveryengine.v1beta.RecommendRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getUserEventFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      servingConfig_ = "";
      userEvent_ = null;
      if (userEventBuilder_ != null) {
        userEventBuilder_.dispose();
        userEventBuilder_ = null;
      }
      pageSize_ = 0;
      filter_ = "";
      validateOnly_ = false;
      internalGetMutableParams().clear();
      internalGetMutableUserLabels().clear();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.discoveryengine.v1beta.RecommendationServiceProto
          .internal_static_google_cloud_discoveryengine_v1beta_RecommendRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.RecommendRequest getDefaultInstanceForType() {
      return com.google.cloud.discoveryengine.v1beta.RecommendRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.RecommendRequest build() {
      com.google.cloud.discoveryengine.v1beta.RecommendRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.RecommendRequest buildPartial() {
      com.google.cloud.discoveryengine.v1beta.RecommendRequest result =
          new com.google.cloud.discoveryengine.v1beta.RecommendRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.discoveryengine.v1beta.RecommendRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.servingConfig_ = servingConfig_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.userEvent_ = userEventBuilder_ == null ? userEvent_ : userEventBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.pageSize_ = pageSize_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.filter_ = filter_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.validateOnly_ = validateOnly_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.params_ = internalGetParams().build(ParamsDefaultEntryHolder.defaultEntry);
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.userLabels_ = internalGetUserLabels();
        result.userLabels_.makeImmutable();
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.discoveryengine.v1beta.RecommendRequest) {
        return mergeFrom((com.google.cloud.discoveryengine.v1beta.RecommendRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.discoveryengine.v1beta.RecommendRequest other) {
      if (other == com.google.cloud.discoveryengine.v1beta.RecommendRequest.getDefaultInstance())
        return this;
      if (!other.getServingConfig().isEmpty()) {
        servingConfig_ = other.servingConfig_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasUserEvent()) {
        mergeUserEvent(other.getUserEvent());
      }
      if (other.getPageSize() != 0) {
        setPageSize(other.getPageSize());
      }
      if (!other.getFilter().isEmpty()) {
        filter_ = other.filter_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.getValidateOnly() != false) {
        setValidateOnly(other.getValidateOnly());
      }
      internalGetMutableParams().mergeFrom(other.internalGetParams());
      bitField0_ |= 0x00000020;
      internalGetMutableUserLabels().mergeFrom(other.internalGetUserLabels());
      bitField0_ |= 0x00000040;
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                servingConfig_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getUserEventFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 24:
              {
                pageSize_ = input.readInt32();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 34:
              {
                filter_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 40:
              {
                validateOnly_ = input.readBool();
                bitField0_ |= 0x00000010;
                break;
              } // case 40
            case 50:
              {
                com.google.protobuf.MapEntry<java.lang.String, com.google.protobuf.Value> params__ =
                    input.readMessage(
                        ParamsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableParams()
                    .ensureBuilderMap()
                    .put(params__.getKey(), params__.getValue());
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 66:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> userLabels__ =
                    input.readMessage(
                        UserLabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableUserLabels()
                    .getMutableMap()
                    .put(userLabels__.getKey(), userLabels__.getValue());
                bitField0_ |= 0x00000040;
                break;
              } // case 66
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object servingConfig_ = "";
    /**
     *
     *
     * <pre>
     * Required. Full resource name of a
     * [ServingConfig][google.cloud.discoveryengine.v1beta.ServingConfig]:
     * `projects/&#42;&#47;locations/global/collections/&#42;&#47;engines/&#42;&#47;servingConfigs/&#42;`, or
     * `projects/&#42;&#47;locations/global/collections/&#42;&#47;dataStores/&#42;&#47;servingConfigs/&#42;`
     *
     * One default serving config is created along with your recommendation engine
     * creation. The engine ID will be used as the ID of the default serving
     * config. For example, for Engine
     * `projects/&#42;&#47;locations/global/collections/&#42;&#47;engines/my-engine`, you can use
     * `projects/&#42;&#47;locations/global/collections/&#42;&#47;engines/my-engine/servingConfigs/my-engine`
     * for your
     * [RecommendationService.Recommend][google.cloud.discoveryengine.v1beta.RecommendationService.Recommend]
     * requests.
     * </pre>
     *
     * <code>
     * string serving_config = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The servingConfig.
     */
    public java.lang.String getServingConfig() {
      java.lang.Object ref = servingConfig_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        servingConfig_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Full resource name of a
     * [ServingConfig][google.cloud.discoveryengine.v1beta.ServingConfig]:
     * `projects/&#42;&#47;locations/global/collections/&#42;&#47;engines/&#42;&#47;servingConfigs/&#42;`, or
     * `projects/&#42;&#47;locations/global/collections/&#42;&#47;dataStores/&#42;&#47;servingConfigs/&#42;`
     *
     * One default serving config is created along with your recommendation engine
     * creation. The engine ID will be used as the ID of the default serving
     * config. For example, for Engine
     * `projects/&#42;&#47;locations/global/collections/&#42;&#47;engines/my-engine`, you can use
     * `projects/&#42;&#47;locations/global/collections/&#42;&#47;engines/my-engine/servingConfigs/my-engine`
     * for your
     * [RecommendationService.Recommend][google.cloud.discoveryengine.v1beta.RecommendationService.Recommend]
     * requests.
     * </pre>
     *
     * <code>
     * string serving_config = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for servingConfig.
     */
    public com.google.protobuf.ByteString getServingConfigBytes() {
      java.lang.Object ref = servingConfig_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        servingConfig_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Full resource name of a
     * [ServingConfig][google.cloud.discoveryengine.v1beta.ServingConfig]:
     * `projects/&#42;&#47;locations/global/collections/&#42;&#47;engines/&#42;&#47;servingConfigs/&#42;`, or
     * `projects/&#42;&#47;locations/global/collections/&#42;&#47;dataStores/&#42;&#47;servingConfigs/&#42;`
     *
     * One default serving config is created along with your recommendation engine
     * creation. The engine ID will be used as the ID of the default serving
     * config. For example, for Engine
     * `projects/&#42;&#47;locations/global/collections/&#42;&#47;engines/my-engine`, you can use
     * `projects/&#42;&#47;locations/global/collections/&#42;&#47;engines/my-engine/servingConfigs/my-engine`
     * for your
     * [RecommendationService.Recommend][google.cloud.discoveryengine.v1beta.RecommendationService.Recommend]
     * requests.
     * </pre>
     *
     * <code>
     * string serving_config = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The servingConfig to set.
     * @return This builder for chaining.
     */
    public Builder setServingConfig(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      servingConfig_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Full resource name of a
     * [ServingConfig][google.cloud.discoveryengine.v1beta.ServingConfig]:
     * `projects/&#42;&#47;locations/global/collections/&#42;&#47;engines/&#42;&#47;servingConfigs/&#42;`, or
     * `projects/&#42;&#47;locations/global/collections/&#42;&#47;dataStores/&#42;&#47;servingConfigs/&#42;`
     *
     * One default serving config is created along with your recommendation engine
     * creation. The engine ID will be used as the ID of the default serving
     * config. For example, for Engine
     * `projects/&#42;&#47;locations/global/collections/&#42;&#47;engines/my-engine`, you can use
     * `projects/&#42;&#47;locations/global/collections/&#42;&#47;engines/my-engine/servingConfigs/my-engine`
     * for your
     * [RecommendationService.Recommend][google.cloud.discoveryengine.v1beta.RecommendationService.Recommend]
     * requests.
     * </pre>
     *
     * <code>
     * string serving_config = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearServingConfig() {
      servingConfig_ = getDefaultInstance().getServingConfig();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Full resource name of a
     * [ServingConfig][google.cloud.discoveryengine.v1beta.ServingConfig]:
     * `projects/&#42;&#47;locations/global/collections/&#42;&#47;engines/&#42;&#47;servingConfigs/&#42;`, or
     * `projects/&#42;&#47;locations/global/collections/&#42;&#47;dataStores/&#42;&#47;servingConfigs/&#42;`
     *
     * One default serving config is created along with your recommendation engine
     * creation. The engine ID will be used as the ID of the default serving
     * config. For example, for Engine
     * `projects/&#42;&#47;locations/global/collections/&#42;&#47;engines/my-engine`, you can use
     * `projects/&#42;&#47;locations/global/collections/&#42;&#47;engines/my-engine/servingConfigs/my-engine`
     * for your
     * [RecommendationService.Recommend][google.cloud.discoveryengine.v1beta.RecommendationService.Recommend]
     * requests.
     * </pre>
     *
     * <code>
     * string serving_config = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for servingConfig to set.
     * @return This builder for chaining.
     */
    public Builder setServingConfigBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      servingConfig_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.cloud.discoveryengine.v1beta.UserEvent userEvent_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1beta.UserEvent,
            com.google.cloud.discoveryengine.v1beta.UserEvent.Builder,
            com.google.cloud.discoveryengine.v1beta.UserEventOrBuilder>
        userEventBuilder_;
    /**
     *
     *
     * <pre>
     * Required. Context about the user, what they are looking at and what action
     * they took to trigger the Recommend request. Note that this user event
     * detail won't be ingested to userEvent logs. Thus, a separate userEvent
     * write request is required for event logging.
     *
     * Don't set
     * [UserEvent.user_pseudo_id][google.cloud.discoveryengine.v1beta.UserEvent.user_pseudo_id]
     * or
     * [UserEvent.user_info.user_id][google.cloud.discoveryengine.v1beta.UserInfo.user_id]
     * to the same fixed ID for different users. If you are trying to receive
     * non-personalized recommendations (not recommended; this can negatively
     * impact model performance), instead set
     * [UserEvent.user_pseudo_id][google.cloud.discoveryengine.v1beta.UserEvent.user_pseudo_id]
     * to a random unique ID and leave
     * [UserEvent.user_info.user_id][google.cloud.discoveryengine.v1beta.UserInfo.user_id]
     * unset.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.UserEvent user_event = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the userEvent field is set.
     */
    public boolean hasUserEvent() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. Context about the user, what they are looking at and what action
     * they took to trigger the Recommend request. Note that this user event
     * detail won't be ingested to userEvent logs. Thus, a separate userEvent
     * write request is required for event logging.
     *
     * Don't set
     * [UserEvent.user_pseudo_id][google.cloud.discoveryengine.v1beta.UserEvent.user_pseudo_id]
     * or
     * [UserEvent.user_info.user_id][google.cloud.discoveryengine.v1beta.UserInfo.user_id]
     * to the same fixed ID for different users. If you are trying to receive
     * non-personalized recommendations (not recommended; this can negatively
     * impact model performance), instead set
     * [UserEvent.user_pseudo_id][google.cloud.discoveryengine.v1beta.UserEvent.user_pseudo_id]
     * to a random unique ID and leave
     * [UserEvent.user_info.user_id][google.cloud.discoveryengine.v1beta.UserInfo.user_id]
     * unset.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.UserEvent user_event = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The userEvent.
     */
    public com.google.cloud.discoveryengine.v1beta.UserEvent getUserEvent() {
      if (userEventBuilder_ == null) {
        return userEvent_ == null
            ? com.google.cloud.discoveryengine.v1beta.UserEvent.getDefaultInstance()
            : userEvent_;
      } else {
        return userEventBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Context about the user, what they are looking at and what action
     * they took to trigger the Recommend request. Note that this user event
     * detail won't be ingested to userEvent logs. Thus, a separate userEvent
     * write request is required for event logging.
     *
     * Don't set
     * [UserEvent.user_pseudo_id][google.cloud.discoveryengine.v1beta.UserEvent.user_pseudo_id]
     * or
     * [UserEvent.user_info.user_id][google.cloud.discoveryengine.v1beta.UserInfo.user_id]
     * to the same fixed ID for different users. If you are trying to receive
     * non-personalized recommendations (not recommended; this can negatively
     * impact model performance), instead set
     * [UserEvent.user_pseudo_id][google.cloud.discoveryengine.v1beta.UserEvent.user_pseudo_id]
     * to a random unique ID and leave
     * [UserEvent.user_info.user_id][google.cloud.discoveryengine.v1beta.UserInfo.user_id]
     * unset.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.UserEvent user_event = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setUserEvent(com.google.cloud.discoveryengine.v1beta.UserEvent value) {
      if (userEventBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        userEvent_ = value;
      } else {
        userEventBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Context about the user, what they are looking at and what action
     * they took to trigger the Recommend request. Note that this user event
     * detail won't be ingested to userEvent logs. Thus, a separate userEvent
     * write request is required for event logging.
     *
     * Don't set
     * [UserEvent.user_pseudo_id][google.cloud.discoveryengine.v1beta.UserEvent.user_pseudo_id]
     * or
     * [UserEvent.user_info.user_id][google.cloud.discoveryengine.v1beta.UserInfo.user_id]
     * to the same fixed ID for different users. If you are trying to receive
     * non-personalized recommendations (not recommended; this can negatively
     * impact model performance), instead set
     * [UserEvent.user_pseudo_id][google.cloud.discoveryengine.v1beta.UserEvent.user_pseudo_id]
     * to a random unique ID and leave
     * [UserEvent.user_info.user_id][google.cloud.discoveryengine.v1beta.UserInfo.user_id]
     * unset.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.UserEvent user_event = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setUserEvent(
        com.google.cloud.discoveryengine.v1beta.UserEvent.Builder builderForValue) {
      if (userEventBuilder_ == null) {
        userEvent_ = builderForValue.build();
      } else {
        userEventBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Context about the user, what they are looking at and what action
     * they took to trigger the Recommend request. Note that this user event
     * detail won't be ingested to userEvent logs. Thus, a separate userEvent
     * write request is required for event logging.
     *
     * Don't set
     * [UserEvent.user_pseudo_id][google.cloud.discoveryengine.v1beta.UserEvent.user_pseudo_id]
     * or
     * [UserEvent.user_info.user_id][google.cloud.discoveryengine.v1beta.UserInfo.user_id]
     * to the same fixed ID for different users. If you are trying to receive
     * non-personalized recommendations (not recommended; this can negatively
     * impact model performance), instead set
     * [UserEvent.user_pseudo_id][google.cloud.discoveryengine.v1beta.UserEvent.user_pseudo_id]
     * to a random unique ID and leave
     * [UserEvent.user_info.user_id][google.cloud.discoveryengine.v1beta.UserInfo.user_id]
     * unset.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.UserEvent user_event = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeUserEvent(com.google.cloud.discoveryengine.v1beta.UserEvent value) {
      if (userEventBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && userEvent_ != null
            && userEvent_
                != com.google.cloud.discoveryengine.v1beta.UserEvent.getDefaultInstance()) {
          getUserEventBuilder().mergeFrom(value);
        } else {
          userEvent_ = value;
        }
      } else {
        userEventBuilder_.mergeFrom(value);
      }
      if (userEvent_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Context about the user, what they are looking at and what action
     * they took to trigger the Recommend request. Note that this user event
     * detail won't be ingested to userEvent logs. Thus, a separate userEvent
     * write request is required for event logging.
     *
     * Don't set
     * [UserEvent.user_pseudo_id][google.cloud.discoveryengine.v1beta.UserEvent.user_pseudo_id]
     * or
     * [UserEvent.user_info.user_id][google.cloud.discoveryengine.v1beta.UserInfo.user_id]
     * to the same fixed ID for different users. If you are trying to receive
     * non-personalized recommendations (not recommended; this can negatively
     * impact model performance), instead set
     * [UserEvent.user_pseudo_id][google.cloud.discoveryengine.v1beta.UserEvent.user_pseudo_id]
     * to a random unique ID and leave
     * [UserEvent.user_info.user_id][google.cloud.discoveryengine.v1beta.UserInfo.user_id]
     * unset.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.UserEvent user_event = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearUserEvent() {
      bitField0_ = (bitField0_ & ~0x00000002);
      userEvent_ = null;
      if (userEventBuilder_ != null) {
        userEventBuilder_.dispose();
        userEventBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Context about the user, what they are looking at and what action
     * they took to trigger the Recommend request. Note that this user event
     * detail won't be ingested to userEvent logs. Thus, a separate userEvent
     * write request is required for event logging.
     *
     * Don't set
     * [UserEvent.user_pseudo_id][google.cloud.discoveryengine.v1beta.UserEvent.user_pseudo_id]
     * or
     * [UserEvent.user_info.user_id][google.cloud.discoveryengine.v1beta.UserInfo.user_id]
     * to the same fixed ID for different users. If you are trying to receive
     * non-personalized recommendations (not recommended; this can negatively
     * impact model performance), instead set
     * [UserEvent.user_pseudo_id][google.cloud.discoveryengine.v1beta.UserEvent.user_pseudo_id]
     * to a random unique ID and leave
     * [UserEvent.user_info.user_id][google.cloud.discoveryengine.v1beta.UserInfo.user_id]
     * unset.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.UserEvent user_event = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.discoveryengine.v1beta.UserEvent.Builder getUserEventBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getUserEventFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. Context about the user, what they are looking at and what action
     * they took to trigger the Recommend request. Note that this user event
     * detail won't be ingested to userEvent logs. Thus, a separate userEvent
     * write request is required for event logging.
     *
     * Don't set
     * [UserEvent.user_pseudo_id][google.cloud.discoveryengine.v1beta.UserEvent.user_pseudo_id]
     * or
     * [UserEvent.user_info.user_id][google.cloud.discoveryengine.v1beta.UserInfo.user_id]
     * to the same fixed ID for different users. If you are trying to receive
     * non-personalized recommendations (not recommended; this can negatively
     * impact model performance), instead set
     * [UserEvent.user_pseudo_id][google.cloud.discoveryengine.v1beta.UserEvent.user_pseudo_id]
     * to a random unique ID and leave
     * [UserEvent.user_info.user_id][google.cloud.discoveryengine.v1beta.UserInfo.user_id]
     * unset.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.UserEvent user_event = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.discoveryengine.v1beta.UserEventOrBuilder getUserEventOrBuilder() {
      if (userEventBuilder_ != null) {
        return userEventBuilder_.getMessageOrBuilder();
      } else {
        return userEvent_ == null
            ? com.google.cloud.discoveryengine.v1beta.UserEvent.getDefaultInstance()
            : userEvent_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Context about the user, what they are looking at and what action
     * they took to trigger the Recommend request. Note that this user event
     * detail won't be ingested to userEvent logs. Thus, a separate userEvent
     * write request is required for event logging.
     *
     * Don't set
     * [UserEvent.user_pseudo_id][google.cloud.discoveryengine.v1beta.UserEvent.user_pseudo_id]
     * or
     * [UserEvent.user_info.user_id][google.cloud.discoveryengine.v1beta.UserInfo.user_id]
     * to the same fixed ID for different users. If you are trying to receive
     * non-personalized recommendations (not recommended; this can negatively
     * impact model performance), instead set
     * [UserEvent.user_pseudo_id][google.cloud.discoveryengine.v1beta.UserEvent.user_pseudo_id]
     * to a random unique ID and leave
     * [UserEvent.user_info.user_id][google.cloud.discoveryengine.v1beta.UserInfo.user_id]
     * unset.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.UserEvent user_event = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1beta.UserEvent,
            com.google.cloud.discoveryengine.v1beta.UserEvent.Builder,
            com.google.cloud.discoveryengine.v1beta.UserEventOrBuilder>
        getUserEventFieldBuilder() {
      if (userEventBuilder_ == null) {
        userEventBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1beta.UserEvent,
                com.google.cloud.discoveryengine.v1beta.UserEvent.Builder,
                com.google.cloud.discoveryengine.v1beta.UserEventOrBuilder>(
                getUserEvent(), getParentForChildren(), isClean());
        userEvent_ = null;
      }
      return userEventBuilder_;
    }

    private int pageSize_;
    /**
     *
     *
     * <pre>
     * Maximum number of results to return. Set this property
     * to the number of recommendation results needed. If zero, the service will
     * choose a reasonable default. The maximum allowed value is 100. Values
     * above 100 will be coerced to 100.
     * </pre>
     *
     * <code>int32 page_size = 3;</code>
     *
     * @return The pageSize.
     */
    @java.lang.Override
    public int getPageSize() {
      return pageSize_;
    }
    /**
     *
     *
     * <pre>
     * Maximum number of results to return. Set this property
     * to the number of recommendation results needed. If zero, the service will
     * choose a reasonable default. The maximum allowed value is 100. Values
     * above 100 will be coerced to 100.
     * </pre>
     *
     * <code>int32 page_size = 3;</code>
     *
     * @param value The pageSize to set.
     * @return This builder for chaining.
     */
    public Builder setPageSize(int value) {

      pageSize_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Maximum number of results to return. Set this property
     * to the number of recommendation results needed. If zero, the service will
     * choose a reasonable default. The maximum allowed value is 100. Values
     * above 100 will be coerced to 100.
     * </pre>
     *
     * <code>int32 page_size = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPageSize() {
      bitField0_ = (bitField0_ & ~0x00000004);
      pageSize_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object filter_ = "";
    /**
     *
     *
     * <pre>
     * Filter for restricting recommendation results with a length limit of 5,000
     * characters. Currently, only filter expressions on the `filter_tags`
     * attribute is supported.
     *
     *
     * Examples:
     *
     *  * `(filter_tags: ANY("Red", "Blue") OR filter_tags: ANY("Hot", "Cold"))`
     *  * `(filter_tags: ANY("Red", "Blue")) AND NOT (filter_tags: ANY("Green"))`
     *
     * If `attributeFilteringSyntax` is set to true under the `params` field, then
     * attribute-based expressions are expected instead of the above described
     * tag-based syntax. Examples:
     *
     *  * (launguage: ANY("en", "es")) AND NOT (categories: ANY("Movie"))
     *  * (available: true) AND
     *    (launguage: ANY("en", "es")) OR (categories: ANY("Movie"))
     *
     * If your filter blocks all results, the API will return generic
     * (unfiltered) popular Documents. If you only want results strictly matching
     * the filters, set `strictFiltering` to True in
     * [RecommendRequest.params][google.cloud.discoveryengine.v1beta.RecommendRequest.params]
     * to receive empty results instead.
     *
     * Note that the API will never return
     * [Document][google.cloud.discoveryengine.v1beta.Document]s with
     * `storageStatus` of `EXPIRED` or `DELETED` regardless of filter choices.
     * </pre>
     *
     * <code>string filter = 4;</code>
     *
     * @return The filter.
     */
    public java.lang.String getFilter() {
      java.lang.Object ref = filter_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        filter_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Filter for restricting recommendation results with a length limit of 5,000
     * characters. Currently, only filter expressions on the `filter_tags`
     * attribute is supported.
     *
     *
     * Examples:
     *
     *  * `(filter_tags: ANY("Red", "Blue") OR filter_tags: ANY("Hot", "Cold"))`
     *  * `(filter_tags: ANY("Red", "Blue")) AND NOT (filter_tags: ANY("Green"))`
     *
     * If `attributeFilteringSyntax` is set to true under the `params` field, then
     * attribute-based expressions are expected instead of the above described
     * tag-based syntax. Examples:
     *
     *  * (launguage: ANY("en", "es")) AND NOT (categories: ANY("Movie"))
     *  * (available: true) AND
     *    (launguage: ANY("en", "es")) OR (categories: ANY("Movie"))
     *
     * If your filter blocks all results, the API will return generic
     * (unfiltered) popular Documents. If you only want results strictly matching
     * the filters, set `strictFiltering` to True in
     * [RecommendRequest.params][google.cloud.discoveryengine.v1beta.RecommendRequest.params]
     * to receive empty results instead.
     *
     * Note that the API will never return
     * [Document][google.cloud.discoveryengine.v1beta.Document]s with
     * `storageStatus` of `EXPIRED` or `DELETED` regardless of filter choices.
     * </pre>
     *
     * <code>string filter = 4;</code>
     *
     * @return The bytes for filter.
     */
    public com.google.protobuf.ByteString getFilterBytes() {
      java.lang.Object ref = filter_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        filter_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Filter for restricting recommendation results with a length limit of 5,000
     * characters. Currently, only filter expressions on the `filter_tags`
     * attribute is supported.
     *
     *
     * Examples:
     *
     *  * `(filter_tags: ANY("Red", "Blue") OR filter_tags: ANY("Hot", "Cold"))`
     *  * `(filter_tags: ANY("Red", "Blue")) AND NOT (filter_tags: ANY("Green"))`
     *
     * If `attributeFilteringSyntax` is set to true under the `params` field, then
     * attribute-based expressions are expected instead of the above described
     * tag-based syntax. Examples:
     *
     *  * (launguage: ANY("en", "es")) AND NOT (categories: ANY("Movie"))
     *  * (available: true) AND
     *    (launguage: ANY("en", "es")) OR (categories: ANY("Movie"))
     *
     * If your filter blocks all results, the API will return generic
     * (unfiltered) popular Documents. If you only want results strictly matching
     * the filters, set `strictFiltering` to True in
     * [RecommendRequest.params][google.cloud.discoveryengine.v1beta.RecommendRequest.params]
     * to receive empty results instead.
     *
     * Note that the API will never return
     * [Document][google.cloud.discoveryengine.v1beta.Document]s with
     * `storageStatus` of `EXPIRED` or `DELETED` regardless of filter choices.
     * </pre>
     *
     * <code>string filter = 4;</code>
     *
     * @param value The filter to set.
     * @return This builder for chaining.
     */
    public Builder setFilter(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      filter_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Filter for restricting recommendation results with a length limit of 5,000
     * characters. Currently, only filter expressions on the `filter_tags`
     * attribute is supported.
     *
     *
     * Examples:
     *
     *  * `(filter_tags: ANY("Red", "Blue") OR filter_tags: ANY("Hot", "Cold"))`
     *  * `(filter_tags: ANY("Red", "Blue")) AND NOT (filter_tags: ANY("Green"))`
     *
     * If `attributeFilteringSyntax` is set to true under the `params` field, then
     * attribute-based expressions are expected instead of the above described
     * tag-based syntax. Examples:
     *
     *  * (launguage: ANY("en", "es")) AND NOT (categories: ANY("Movie"))
     *  * (available: true) AND
     *    (launguage: ANY("en", "es")) OR (categories: ANY("Movie"))
     *
     * If your filter blocks all results, the API will return generic
     * (unfiltered) popular Documents. If you only want results strictly matching
     * the filters, set `strictFiltering` to True in
     * [RecommendRequest.params][google.cloud.discoveryengine.v1beta.RecommendRequest.params]
     * to receive empty results instead.
     *
     * Note that the API will never return
     * [Document][google.cloud.discoveryengine.v1beta.Document]s with
     * `storageStatus` of `EXPIRED` or `DELETED` regardless of filter choices.
     * </pre>
     *
     * <code>string filter = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFilter() {
      filter_ = getDefaultInstance().getFilter();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Filter for restricting recommendation results with a length limit of 5,000
     * characters. Currently, only filter expressions on the `filter_tags`
     * attribute is supported.
     *
     *
     * Examples:
     *
     *  * `(filter_tags: ANY("Red", "Blue") OR filter_tags: ANY("Hot", "Cold"))`
     *  * `(filter_tags: ANY("Red", "Blue")) AND NOT (filter_tags: ANY("Green"))`
     *
     * If `attributeFilteringSyntax` is set to true under the `params` field, then
     * attribute-based expressions are expected instead of the above described
     * tag-based syntax. Examples:
     *
     *  * (launguage: ANY("en", "es")) AND NOT (categories: ANY("Movie"))
     *  * (available: true) AND
     *    (launguage: ANY("en", "es")) OR (categories: ANY("Movie"))
     *
     * If your filter blocks all results, the API will return generic
     * (unfiltered) popular Documents. If you only want results strictly matching
     * the filters, set `strictFiltering` to True in
     * [RecommendRequest.params][google.cloud.discoveryengine.v1beta.RecommendRequest.params]
     * to receive empty results instead.
     *
     * Note that the API will never return
     * [Document][google.cloud.discoveryengine.v1beta.Document]s with
     * `storageStatus` of `EXPIRED` or `DELETED` regardless of filter choices.
     * </pre>
     *
     * <code>string filter = 4;</code>
     *
     * @param value The bytes for filter to set.
     * @return This builder for chaining.
     */
    public Builder setFilterBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      filter_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private boolean validateOnly_;
    /**
     *
     *
     * <pre>
     * Use validate only mode for this recommendation query. If set to true, a
     * fake model will be used that returns arbitrary Document IDs.
     * Note that the validate only mode should only be used for testing the API,
     * or if the model is not ready.
     * </pre>
     *
     * <code>bool validate_only = 5;</code>
     *
     * @return The validateOnly.
     */
    @java.lang.Override
    public boolean getValidateOnly() {
      return validateOnly_;
    }
    /**
     *
     *
     * <pre>
     * Use validate only mode for this recommendation query. If set to true, a
     * fake model will be used that returns arbitrary Document IDs.
     * Note that the validate only mode should only be used for testing the API,
     * or if the model is not ready.
     * </pre>
     *
     * <code>bool validate_only = 5;</code>
     *
     * @param value The validateOnly to set.
     * @return This builder for chaining.
     */
    public Builder setValidateOnly(boolean value) {

      validateOnly_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Use validate only mode for this recommendation query. If set to true, a
     * fake model will be used that returns arbitrary Document IDs.
     * Note that the validate only mode should only be used for testing the API,
     * or if the model is not ready.
     * </pre>
     *
     * <code>bool validate_only = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearValidateOnly() {
      bitField0_ = (bitField0_ & ~0x00000010);
      validateOnly_ = false;
      onChanged();
      return this;
    }

    private static final class ParamsConverter
        implements com.google.protobuf.MapFieldBuilder.Converter<
            java.lang.String, com.google.protobuf.ValueOrBuilder, com.google.protobuf.Value> {
      @java.lang.Override
      public com.google.protobuf.Value build(com.google.protobuf.ValueOrBuilder val) {
        if (val instanceof com.google.protobuf.Value) {
          return (com.google.protobuf.Value) val;
        }
        return ((com.google.protobuf.Value.Builder) val).build();
      }

      @java.lang.Override
      public com.google.protobuf.MapEntry<java.lang.String, com.google.protobuf.Value>
          defaultEntry() {
        return ParamsDefaultEntryHolder.defaultEntry;
      }
    };

    private static final ParamsConverter paramsConverter = new ParamsConverter();

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.protobuf.ValueOrBuilder,
            com.google.protobuf.Value,
            com.google.protobuf.Value.Builder>
        params_;

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.protobuf.ValueOrBuilder,
            com.google.protobuf.Value,
            com.google.protobuf.Value.Builder>
        internalGetParams() {
      if (params_ == null) {
        return new com.google.protobuf.MapFieldBuilder<>(paramsConverter);
      }
      return params_;
    }

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.protobuf.ValueOrBuilder,
            com.google.protobuf.Value,
            com.google.protobuf.Value.Builder>
        internalGetMutableParams() {
      if (params_ == null) {
        params_ = new com.google.protobuf.MapFieldBuilder<>(paramsConverter);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return params_;
    }

    public int getParamsCount() {
      return internalGetParams().ensureBuilderMap().size();
    }
    /**
     *
     *
     * <pre>
     * Additional domain specific parameters for the recommendations.
     *
     * Allowed values:
     *
     * * `returnDocument`: Boolean. If set to true, the associated Document
     *    object will be returned in
     *    [RecommendResponse.RecommendationResult.document][google.cloud.discoveryengine.v1beta.RecommendResponse.RecommendationResult.document].
     * * `returnScore`: Boolean. If set to true, the recommendation 'score'
     *    corresponding to each returned Document will be set in
     *    [RecommendResponse.RecommendationResult.metadata][google.cloud.discoveryengine.v1beta.RecommendResponse.RecommendationResult.metadata].
     *    The given 'score' indicates the probability of a Document conversion
     *    given the user's context and history.
     * * `strictFiltering`: Boolean. True by default. If set to false, the service
     *    will return generic (unfiltered) popular Documents instead of empty if
     *    your filter blocks all recommendation results.
     * * `diversityLevel`: String. Default empty. If set to be non-empty, then
     *    it needs to be one of:
     *     *  `no-diversity`
     *     *  `low-diversity`
     *     *  `medium-diversity`
     *     *  `high-diversity`
     *     *  `auto-diversity`
     *    This gives request-level control and adjusts recommendation results
     *    based on Document category.
     * * `attributeFilteringSyntax`: Boolean. False by default. If set to true,
     *    the `filter` field is interpreted according to the new,
     *    attribute-based syntax.
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Value&gt; params = 6;</code>
     */
    @java.lang.Override
    public boolean containsParams(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetParams().ensureBuilderMap().containsKey(key);
    }
    /** Use {@link #getParamsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.protobuf.Value> getParams() {
      return getParamsMap();
    }
    /**
     *
     *
     * <pre>
     * Additional domain specific parameters for the recommendations.
     *
     * Allowed values:
     *
     * * `returnDocument`: Boolean. If set to true, the associated Document
     *    object will be returned in
     *    [RecommendResponse.RecommendationResult.document][google.cloud.discoveryengine.v1beta.RecommendResponse.RecommendationResult.document].
     * * `returnScore`: Boolean. If set to true, the recommendation 'score'
     *    corresponding to each returned Document will be set in
     *    [RecommendResponse.RecommendationResult.metadata][google.cloud.discoveryengine.v1beta.RecommendResponse.RecommendationResult.metadata].
     *    The given 'score' indicates the probability of a Document conversion
     *    given the user's context and history.
     * * `strictFiltering`: Boolean. True by default. If set to false, the service
     *    will return generic (unfiltered) popular Documents instead of empty if
     *    your filter blocks all recommendation results.
     * * `diversityLevel`: String. Default empty. If set to be non-empty, then
     *    it needs to be one of:
     *     *  `no-diversity`
     *     *  `low-diversity`
     *     *  `medium-diversity`
     *     *  `high-diversity`
     *     *  `auto-diversity`
     *    This gives request-level control and adjusts recommendation results
     *    based on Document category.
     * * `attributeFilteringSyntax`: Boolean. False by default. If set to true,
     *    the `filter` field is interpreted according to the new,
     *    attribute-based syntax.
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Value&gt; params = 6;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, com.google.protobuf.Value> getParamsMap() {
      return internalGetParams().getImmutableMap();
    }
    /**
     *
     *
     * <pre>
     * Additional domain specific parameters for the recommendations.
     *
     * Allowed values:
     *
     * * `returnDocument`: Boolean. If set to true, the associated Document
     *    object will be returned in
     *    [RecommendResponse.RecommendationResult.document][google.cloud.discoveryengine.v1beta.RecommendResponse.RecommendationResult.document].
     * * `returnScore`: Boolean. If set to true, the recommendation 'score'
     *    corresponding to each returned Document will be set in
     *    [RecommendResponse.RecommendationResult.metadata][google.cloud.discoveryengine.v1beta.RecommendResponse.RecommendationResult.metadata].
     *    The given 'score' indicates the probability of a Document conversion
     *    given the user's context and history.
     * * `strictFiltering`: Boolean. True by default. If set to false, the service
     *    will return generic (unfiltered) popular Documents instead of empty if
     *    your filter blocks all recommendation results.
     * * `diversityLevel`: String. Default empty. If set to be non-empty, then
     *    it needs to be one of:
     *     *  `no-diversity`
     *     *  `low-diversity`
     *     *  `medium-diversity`
     *     *  `high-diversity`
     *     *  `auto-diversity`
     *    This gives request-level control and adjusts recommendation results
     *    based on Document category.
     * * `attributeFilteringSyntax`: Boolean. False by default. If set to true,
     *    the `filter` field is interpreted according to the new,
     *    attribute-based syntax.
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Value&gt; params = 6;</code>
     */
    @java.lang.Override
    public /* nullable */ com.google.protobuf.Value getParamsOrDefault(
        java.lang.String key,
        /* nullable */
        com.google.protobuf.Value defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.protobuf.ValueOrBuilder> map =
          internalGetMutableParams().ensureBuilderMap();
      return map.containsKey(key) ? paramsConverter.build(map.get(key)) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Additional domain specific parameters for the recommendations.
     *
     * Allowed values:
     *
     * * `returnDocument`: Boolean. If set to true, the associated Document
     *    object will be returned in
     *    [RecommendResponse.RecommendationResult.document][google.cloud.discoveryengine.v1beta.RecommendResponse.RecommendationResult.document].
     * * `returnScore`: Boolean. If set to true, the recommendation 'score'
     *    corresponding to each returned Document will be set in
     *    [RecommendResponse.RecommendationResult.metadata][google.cloud.discoveryengine.v1beta.RecommendResponse.RecommendationResult.metadata].
     *    The given 'score' indicates the probability of a Document conversion
     *    given the user's context and history.
     * * `strictFiltering`: Boolean. True by default. If set to false, the service
     *    will return generic (unfiltered) popular Documents instead of empty if
     *    your filter blocks all recommendation results.
     * * `diversityLevel`: String. Default empty. If set to be non-empty, then
     *    it needs to be one of:
     *     *  `no-diversity`
     *     *  `low-diversity`
     *     *  `medium-diversity`
     *     *  `high-diversity`
     *     *  `auto-diversity`
     *    This gives request-level control and adjusts recommendation results
     *    based on Document category.
     * * `attributeFilteringSyntax`: Boolean. False by default. If set to true,
     *    the `filter` field is interpreted according to the new,
     *    attribute-based syntax.
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Value&gt; params = 6;</code>
     */
    @java.lang.Override
    public com.google.protobuf.Value getParamsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.protobuf.ValueOrBuilder> map =
          internalGetMutableParams().ensureBuilderMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return paramsConverter.build(map.get(key));
    }

    public Builder clearParams() {
      bitField0_ = (bitField0_ & ~0x00000020);
      internalGetMutableParams().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional domain specific parameters for the recommendations.
     *
     * Allowed values:
     *
     * * `returnDocument`: Boolean. If set to true, the associated Document
     *    object will be returned in
     *    [RecommendResponse.RecommendationResult.document][google.cloud.discoveryengine.v1beta.RecommendResponse.RecommendationResult.document].
     * * `returnScore`: Boolean. If set to true, the recommendation 'score'
     *    corresponding to each returned Document will be set in
     *    [RecommendResponse.RecommendationResult.metadata][google.cloud.discoveryengine.v1beta.RecommendResponse.RecommendationResult.metadata].
     *    The given 'score' indicates the probability of a Document conversion
     *    given the user's context and history.
     * * `strictFiltering`: Boolean. True by default. If set to false, the service
     *    will return generic (unfiltered) popular Documents instead of empty if
     *    your filter blocks all recommendation results.
     * * `diversityLevel`: String. Default empty. If set to be non-empty, then
     *    it needs to be one of:
     *     *  `no-diversity`
     *     *  `low-diversity`
     *     *  `medium-diversity`
     *     *  `high-diversity`
     *     *  `auto-diversity`
     *    This gives request-level control and adjusts recommendation results
     *    based on Document category.
     * * `attributeFilteringSyntax`: Boolean. False by default. If set to true,
     *    the `filter` field is interpreted according to the new,
     *    attribute-based syntax.
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Value&gt; params = 6;</code>
     */
    public Builder removeParams(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableParams().ensureBuilderMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.protobuf.Value> getMutableParams() {
      bitField0_ |= 0x00000020;
      return internalGetMutableParams().ensureMessageMap();
    }
    /**
     *
     *
     * <pre>
     * Additional domain specific parameters for the recommendations.
     *
     * Allowed values:
     *
     * * `returnDocument`: Boolean. If set to true, the associated Document
     *    object will be returned in
     *    [RecommendResponse.RecommendationResult.document][google.cloud.discoveryengine.v1beta.RecommendResponse.RecommendationResult.document].
     * * `returnScore`: Boolean. If set to true, the recommendation 'score'
     *    corresponding to each returned Document will be set in
     *    [RecommendResponse.RecommendationResult.metadata][google.cloud.discoveryengine.v1beta.RecommendResponse.RecommendationResult.metadata].
     *    The given 'score' indicates the probability of a Document conversion
     *    given the user's context and history.
     * * `strictFiltering`: Boolean. True by default. If set to false, the service
     *    will return generic (unfiltered) popular Documents instead of empty if
     *    your filter blocks all recommendation results.
     * * `diversityLevel`: String. Default empty. If set to be non-empty, then
     *    it needs to be one of:
     *     *  `no-diversity`
     *     *  `low-diversity`
     *     *  `medium-diversity`
     *     *  `high-diversity`
     *     *  `auto-diversity`
     *    This gives request-level control and adjusts recommendation results
     *    based on Document category.
     * * `attributeFilteringSyntax`: Boolean. False by default. If set to true,
     *    the `filter` field is interpreted according to the new,
     *    attribute-based syntax.
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Value&gt; params = 6;</code>
     */
    public Builder putParams(java.lang.String key, com.google.protobuf.Value value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableParams().ensureBuilderMap().put(key, value);
      bitField0_ |= 0x00000020;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional domain specific parameters for the recommendations.
     *
     * Allowed values:
     *
     * * `returnDocument`: Boolean. If set to true, the associated Document
     *    object will be returned in
     *    [RecommendResponse.RecommendationResult.document][google.cloud.discoveryengine.v1beta.RecommendResponse.RecommendationResult.document].
     * * `returnScore`: Boolean. If set to true, the recommendation 'score'
     *    corresponding to each returned Document will be set in
     *    [RecommendResponse.RecommendationResult.metadata][google.cloud.discoveryengine.v1beta.RecommendResponse.RecommendationResult.metadata].
     *    The given 'score' indicates the probability of a Document conversion
     *    given the user's context and history.
     * * `strictFiltering`: Boolean. True by default. If set to false, the service
     *    will return generic (unfiltered) popular Documents instead of empty if
     *    your filter blocks all recommendation results.
     * * `diversityLevel`: String. Default empty. If set to be non-empty, then
     *    it needs to be one of:
     *     *  `no-diversity`
     *     *  `low-diversity`
     *     *  `medium-diversity`
     *     *  `high-diversity`
     *     *  `auto-diversity`
     *    This gives request-level control and adjusts recommendation results
     *    based on Document category.
     * * `attributeFilteringSyntax`: Boolean. False by default. If set to true,
     *    the `filter` field is interpreted according to the new,
     *    attribute-based syntax.
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Value&gt; params = 6;</code>
     */
    public Builder putAllParams(java.util.Map<java.lang.String, com.google.protobuf.Value> values) {
      for (java.util.Map.Entry<java.lang.String, com.google.protobuf.Value> e : values.entrySet()) {
        if (e.getKey() == null || e.getValue() == null) {
          throw new NullPointerException();
        }
      }
      internalGetMutableParams().ensureBuilderMap().putAll(values);
      bitField0_ |= 0x00000020;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional domain specific parameters for the recommendations.
     *
     * Allowed values:
     *
     * * `returnDocument`: Boolean. If set to true, the associated Document
     *    object will be returned in
     *    [RecommendResponse.RecommendationResult.document][google.cloud.discoveryengine.v1beta.RecommendResponse.RecommendationResult.document].
     * * `returnScore`: Boolean. If set to true, the recommendation 'score'
     *    corresponding to each returned Document will be set in
     *    [RecommendResponse.RecommendationResult.metadata][google.cloud.discoveryengine.v1beta.RecommendResponse.RecommendationResult.metadata].
     *    The given 'score' indicates the probability of a Document conversion
     *    given the user's context and history.
     * * `strictFiltering`: Boolean. True by default. If set to false, the service
     *    will return generic (unfiltered) popular Documents instead of empty if
     *    your filter blocks all recommendation results.
     * * `diversityLevel`: String. Default empty. If set to be non-empty, then
     *    it needs to be one of:
     *     *  `no-diversity`
     *     *  `low-diversity`
     *     *  `medium-diversity`
     *     *  `high-diversity`
     *     *  `auto-diversity`
     *    This gives request-level control and adjusts recommendation results
     *    based on Document category.
     * * `attributeFilteringSyntax`: Boolean. False by default. If set to true,
     *    the `filter` field is interpreted according to the new,
     *    attribute-based syntax.
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Value&gt; params = 6;</code>
     */
    public com.google.protobuf.Value.Builder putParamsBuilderIfAbsent(java.lang.String key) {
      java.util.Map<java.lang.String, com.google.protobuf.ValueOrBuilder> builderMap =
          internalGetMutableParams().ensureBuilderMap();
      com.google.protobuf.ValueOrBuilder entry = builderMap.get(key);
      if (entry == null) {
        entry = com.google.protobuf.Value.newBuilder();
        builderMap.put(key, entry);
      }
      if (entry instanceof com.google.protobuf.Value) {
        entry = ((com.google.protobuf.Value) entry).toBuilder();
        builderMap.put(key, entry);
      }
      return (com.google.protobuf.Value.Builder) entry;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> userLabels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetUserLabels() {
      if (userLabels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            UserLabelsDefaultEntryHolder.defaultEntry);
      }
      return userLabels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableUserLabels() {
      if (userLabels_ == null) {
        userLabels_ =
            com.google.protobuf.MapField.newMapField(UserLabelsDefaultEntryHolder.defaultEntry);
      }
      if (!userLabels_.isMutable()) {
        userLabels_ = userLabels_.copy();
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return userLabels_;
    }

    public int getUserLabelsCount() {
      return internalGetUserLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * The user labels applied to a resource must meet the following requirements:
     *
     * * Each resource can have multiple labels, up to a maximum of 64.
     * * Each label must be a key-value pair.
     * * Keys have a minimum length of 1 character and a maximum length of 63
     *   characters and cannot be empty. Values can be empty and have a maximum
     *   length of 63 characters.
     * * Keys and values can contain only lowercase letters, numeric characters,
     *   underscores, and dashes. All characters must use UTF-8 encoding, and
     *   international characters are allowed.
     * * The key portion of a label must be unique. However, you can use the same
     *   key with multiple resources.
     * * Keys must start with a lowercase letter or international character.
     *
     * See [Requirements for
     * labels](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
     * for more details.
     * </pre>
     *
     * <code>map&lt;string, string&gt; user_labels = 8;</code>
     */
    @java.lang.Override
    public boolean containsUserLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetUserLabels().getMap().containsKey(key);
    }
    /** Use {@link #getUserLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getUserLabels() {
      return getUserLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * The user labels applied to a resource must meet the following requirements:
     *
     * * Each resource can have multiple labels, up to a maximum of 64.
     * * Each label must be a key-value pair.
     * * Keys have a minimum length of 1 character and a maximum length of 63
     *   characters and cannot be empty. Values can be empty and have a maximum
     *   length of 63 characters.
     * * Keys and values can contain only lowercase letters, numeric characters,
     *   underscores, and dashes. All characters must use UTF-8 encoding, and
     *   international characters are allowed.
     * * The key portion of a label must be unique. However, you can use the same
     *   key with multiple resources.
     * * Keys must start with a lowercase letter or international character.
     *
     * See [Requirements for
     * labels](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
     * for more details.
     * </pre>
     *
     * <code>map&lt;string, string&gt; user_labels = 8;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getUserLabelsMap() {
      return internalGetUserLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * The user labels applied to a resource must meet the following requirements:
     *
     * * Each resource can have multiple labels, up to a maximum of 64.
     * * Each label must be a key-value pair.
     * * Keys have a minimum length of 1 character and a maximum length of 63
     *   characters and cannot be empty. Values can be empty and have a maximum
     *   length of 63 characters.
     * * Keys and values can contain only lowercase letters, numeric characters,
     *   underscores, and dashes. All characters must use UTF-8 encoding, and
     *   international characters are allowed.
     * * The key portion of a label must be unique. However, you can use the same
     *   key with multiple resources.
     * * Keys must start with a lowercase letter or international character.
     *
     * See [Requirements for
     * labels](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
     * for more details.
     * </pre>
     *
     * <code>map&lt;string, string&gt; user_labels = 8;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getUserLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetUserLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * The user labels applied to a resource must meet the following requirements:
     *
     * * Each resource can have multiple labels, up to a maximum of 64.
     * * Each label must be a key-value pair.
     * * Keys have a minimum length of 1 character and a maximum length of 63
     *   characters and cannot be empty. Values can be empty and have a maximum
     *   length of 63 characters.
     * * Keys and values can contain only lowercase letters, numeric characters,
     *   underscores, and dashes. All characters must use UTF-8 encoding, and
     *   international characters are allowed.
     * * The key portion of a label must be unique. However, you can use the same
     *   key with multiple resources.
     * * Keys must start with a lowercase letter or international character.
     *
     * See [Requirements for
     * labels](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
     * for more details.
     * </pre>
     *
     * <code>map&lt;string, string&gt; user_labels = 8;</code>
     */
    @java.lang.Override
    public java.lang.String getUserLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetUserLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearUserLabels() {
      bitField0_ = (bitField0_ & ~0x00000040);
      internalGetMutableUserLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The user labels applied to a resource must meet the following requirements:
     *
     * * Each resource can have multiple labels, up to a maximum of 64.
     * * Each label must be a key-value pair.
     * * Keys have a minimum length of 1 character and a maximum length of 63
     *   characters and cannot be empty. Values can be empty and have a maximum
     *   length of 63 characters.
     * * Keys and values can contain only lowercase letters, numeric characters,
     *   underscores, and dashes. All characters must use UTF-8 encoding, and
     *   international characters are allowed.
     * * The key portion of a label must be unique. However, you can use the same
     *   key with multiple resources.
     * * Keys must start with a lowercase letter or international character.
     *
     * See [Requirements for
     * labels](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
     * for more details.
     * </pre>
     *
     * <code>map&lt;string, string&gt; user_labels = 8;</code>
     */
    public Builder removeUserLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableUserLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableUserLabels() {
      bitField0_ |= 0x00000040;
      return internalGetMutableUserLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * The user labels applied to a resource must meet the following requirements:
     *
     * * Each resource can have multiple labels, up to a maximum of 64.
     * * Each label must be a key-value pair.
     * * Keys have a minimum length of 1 character and a maximum length of 63
     *   characters and cannot be empty. Values can be empty and have a maximum
     *   length of 63 characters.
     * * Keys and values can contain only lowercase letters, numeric characters,
     *   underscores, and dashes. All characters must use UTF-8 encoding, and
     *   international characters are allowed.
     * * The key portion of a label must be unique. However, you can use the same
     *   key with multiple resources.
     * * Keys must start with a lowercase letter or international character.
     *
     * See [Requirements for
     * labels](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
     * for more details.
     * </pre>
     *
     * <code>map&lt;string, string&gt; user_labels = 8;</code>
     */
    public Builder putUserLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableUserLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00000040;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The user labels applied to a resource must meet the following requirements:
     *
     * * Each resource can have multiple labels, up to a maximum of 64.
     * * Each label must be a key-value pair.
     * * Keys have a minimum length of 1 character and a maximum length of 63
     *   characters and cannot be empty. Values can be empty and have a maximum
     *   length of 63 characters.
     * * Keys and values can contain only lowercase letters, numeric characters,
     *   underscores, and dashes. All characters must use UTF-8 encoding, and
     *   international characters are allowed.
     * * The key portion of a label must be unique. However, you can use the same
     *   key with multiple resources.
     * * Keys must start with a lowercase letter or international character.
     *
     * See [Requirements for
     * labels](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
     * for more details.
     * </pre>
     *
     * <code>map&lt;string, string&gt; user_labels = 8;</code>
     */
    public Builder putAllUserLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableUserLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00000040;
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.RecommendRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.RecommendRequest)
  private static final com.google.cloud.discoveryengine.v1beta.RecommendRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.discoveryengine.v1beta.RecommendRequest();
  }

  public static com.google.cloud.discoveryengine.v1beta.RecommendRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<RecommendRequest> PARSER =
      new com.google.protobuf.AbstractParser<RecommendRequest>() {
        @java.lang.Override
        public RecommendRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<RecommendRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<RecommendRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.RecommendRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
