/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/discoveryengine/v1beta/grounded_generation_service.proto

// Protobuf Java Version: 3.25.3
package com.google.cloud.discoveryengine.v1beta;

/**
 *
 *
 * <pre>
 * Request message for
 * [GroundedGenerationService.CheckGrounding][google.cloud.discoveryengine.v1beta.GroundedGenerationService.CheckGrounding]
 * method.
 * </pre>
 *
 * Protobuf type {@code google.cloud.discoveryengine.v1beta.CheckGroundingRequest}
 */
public final class CheckGroundingRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.CheckGroundingRequest)
    CheckGroundingRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use CheckGroundingRequest.newBuilder() to construct.
  private CheckGroundingRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private CheckGroundingRequest() {
    groundingConfig_ = "";
    answerCandidate_ = "";
    facts_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new CheckGroundingRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.discoveryengine.v1beta.GroundedGenerationServiceProto
        .internal_static_google_cloud_discoveryengine_v1beta_CheckGroundingRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.discoveryengine.v1beta.GroundedGenerationServiceProto
        .internal_static_google_cloud_discoveryengine_v1beta_CheckGroundingRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.discoveryengine.v1beta.CheckGroundingRequest.class,
            com.google.cloud.discoveryengine.v1beta.CheckGroundingRequest.Builder.class);
  }

  private int bitField0_;
  public static final int GROUNDING_CONFIG_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object groundingConfig_ = "";
  /**
   *
   *
   * <pre>
   * Required. The resource name of the grounding config, such as
   * `projects/&#42;&#47;locations/global/groundingConfigs/default_grounding_config`.
   * </pre>
   *
   * <code>
   * string grounding_config = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The groundingConfig.
   */
  @java.lang.Override
  public java.lang.String getGroundingConfig() {
    java.lang.Object ref = groundingConfig_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      groundingConfig_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The resource name of the grounding config, such as
   * `projects/&#42;&#47;locations/global/groundingConfigs/default_grounding_config`.
   * </pre>
   *
   * <code>
   * string grounding_config = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for groundingConfig.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getGroundingConfigBytes() {
    java.lang.Object ref = groundingConfig_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      groundingConfig_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ANSWER_CANDIDATE_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object answerCandidate_ = "";
  /**
   *
   *
   * <pre>
   * Answer candidate to check.
   * </pre>
   *
   * <code>string answer_candidate = 2;</code>
   *
   * @return The answerCandidate.
   */
  @java.lang.Override
  public java.lang.String getAnswerCandidate() {
    java.lang.Object ref = answerCandidate_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      answerCandidate_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Answer candidate to check.
   * </pre>
   *
   * <code>string answer_candidate = 2;</code>
   *
   * @return The bytes for answerCandidate.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getAnswerCandidateBytes() {
    java.lang.Object ref = answerCandidate_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      answerCandidate_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FACTS_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.discoveryengine.v1beta.GroundingFact> facts_;
  /**
   *
   *
   * <pre>
   * List of facts for the grounding check.
   * We support up to 200 facts.
   * </pre>
   *
   * <code>repeated .google.cloud.discoveryengine.v1beta.GroundingFact facts = 3;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.discoveryengine.v1beta.GroundingFact> getFactsList() {
    return facts_;
  }
  /**
   *
   *
   * <pre>
   * List of facts for the grounding check.
   * We support up to 200 facts.
   * </pre>
   *
   * <code>repeated .google.cloud.discoveryengine.v1beta.GroundingFact facts = 3;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.discoveryengine.v1beta.GroundingFactOrBuilder>
      getFactsOrBuilderList() {
    return facts_;
  }
  /**
   *
   *
   * <pre>
   * List of facts for the grounding check.
   * We support up to 200 facts.
   * </pre>
   *
   * <code>repeated .google.cloud.discoveryengine.v1beta.GroundingFact facts = 3;</code>
   */
  @java.lang.Override
  public int getFactsCount() {
    return facts_.size();
  }
  /**
   *
   *
   * <pre>
   * List of facts for the grounding check.
   * We support up to 200 facts.
   * </pre>
   *
   * <code>repeated .google.cloud.discoveryengine.v1beta.GroundingFact facts = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.GroundingFact getFacts(int index) {
    return facts_.get(index);
  }
  /**
   *
   *
   * <pre>
   * List of facts for the grounding check.
   * We support up to 200 facts.
   * </pre>
   *
   * <code>repeated .google.cloud.discoveryengine.v1beta.GroundingFact facts = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.GroundingFactOrBuilder getFactsOrBuilder(
      int index) {
    return facts_.get(index);
  }

  public static final int GROUNDING_SPEC_FIELD_NUMBER = 4;
  private com.google.cloud.discoveryengine.v1beta.CheckGroundingSpec groundingSpec_;
  /**
   *
   *
   * <pre>
   * Configuration of the grounding check.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.CheckGroundingSpec grounding_spec = 4;</code>
   *
   * @return Whether the groundingSpec field is set.
   */
  @java.lang.Override
  public boolean hasGroundingSpec() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Configuration of the grounding check.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.CheckGroundingSpec grounding_spec = 4;</code>
   *
   * @return The groundingSpec.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.CheckGroundingSpec getGroundingSpec() {
    return groundingSpec_ == null
        ? com.google.cloud.discoveryengine.v1beta.CheckGroundingSpec.getDefaultInstance()
        : groundingSpec_;
  }
  /**
   *
   *
   * <pre>
   * Configuration of the grounding check.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.CheckGroundingSpec grounding_spec = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.CheckGroundingSpecOrBuilder
      getGroundingSpecOrBuilder() {
    return groundingSpec_ == null
        ? com.google.cloud.discoveryengine.v1beta.CheckGroundingSpec.getDefaultInstance()
        : groundingSpec_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(groundingConfig_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, groundingConfig_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(answerCandidate_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, answerCandidate_);
    }
    for (int i = 0; i < facts_.size(); i++) {
      output.writeMessage(3, facts_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(4, getGroundingSpec());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(groundingConfig_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, groundingConfig_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(answerCandidate_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, answerCandidate_);
    }
    for (int i = 0; i < facts_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, facts_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getGroundingSpec());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.discoveryengine.v1beta.CheckGroundingRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.discoveryengine.v1beta.CheckGroundingRequest other =
        (com.google.cloud.discoveryengine.v1beta.CheckGroundingRequest) obj;

    if (!getGroundingConfig().equals(other.getGroundingConfig())) return false;
    if (!getAnswerCandidate().equals(other.getAnswerCandidate())) return false;
    if (!getFactsList().equals(other.getFactsList())) return false;
    if (hasGroundingSpec() != other.hasGroundingSpec()) return false;
    if (hasGroundingSpec()) {
      if (!getGroundingSpec().equals(other.getGroundingSpec())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + GROUNDING_CONFIG_FIELD_NUMBER;
    hash = (53 * hash) + getGroundingConfig().hashCode();
    hash = (37 * hash) + ANSWER_CANDIDATE_FIELD_NUMBER;
    hash = (53 * hash) + getAnswerCandidate().hashCode();
    if (getFactsCount() > 0) {
      hash = (37 * hash) + FACTS_FIELD_NUMBER;
      hash = (53 * hash) + getFactsList().hashCode();
    }
    if (hasGroundingSpec()) {
      hash = (37 * hash) + GROUNDING_SPEC_FIELD_NUMBER;
      hash = (53 * hash) + getGroundingSpec().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.discoveryengine.v1beta.CheckGroundingRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1beta.CheckGroundingRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.CheckGroundingRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1beta.CheckGroundingRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.CheckGroundingRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1beta.CheckGroundingRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.CheckGroundingRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1beta.CheckGroundingRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.CheckGroundingRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1beta.CheckGroundingRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.CheckGroundingRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1beta.CheckGroundingRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.discoveryengine.v1beta.CheckGroundingRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request message for
   * [GroundedGenerationService.CheckGrounding][google.cloud.discoveryengine.v1beta.GroundedGenerationService.CheckGrounding]
   * method.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1beta.CheckGroundingRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.CheckGroundingRequest)
      com.google.cloud.discoveryengine.v1beta.CheckGroundingRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1beta.GroundedGenerationServiceProto
          .internal_static_google_cloud_discoveryengine_v1beta_CheckGroundingRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1beta.GroundedGenerationServiceProto
          .internal_static_google_cloud_discoveryengine_v1beta_CheckGroundingRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1beta.CheckGroundingRequest.class,
              com.google.cloud.discoveryengine.v1beta.CheckGroundingRequest.Builder.class);
    }

    // Construct using com.google.cloud.discoveryengine.v1beta.CheckGroundingRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getFactsFieldBuilder();
        getGroundingSpecFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      groundingConfig_ = "";
      answerCandidate_ = "";
      if (factsBuilder_ == null) {
        facts_ = java.util.Collections.emptyList();
      } else {
        facts_ = null;
        factsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      groundingSpec_ = null;
      if (groundingSpecBuilder_ != null) {
        groundingSpecBuilder_.dispose();
        groundingSpecBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.discoveryengine.v1beta.GroundedGenerationServiceProto
          .internal_static_google_cloud_discoveryengine_v1beta_CheckGroundingRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.CheckGroundingRequest
        getDefaultInstanceForType() {
      return com.google.cloud.discoveryengine.v1beta.CheckGroundingRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.CheckGroundingRequest build() {
      com.google.cloud.discoveryengine.v1beta.CheckGroundingRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.CheckGroundingRequest buildPartial() {
      com.google.cloud.discoveryengine.v1beta.CheckGroundingRequest result =
          new com.google.cloud.discoveryengine.v1beta.CheckGroundingRequest(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.discoveryengine.v1beta.CheckGroundingRequest result) {
      if (factsBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          facts_ = java.util.Collections.unmodifiableList(facts_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.facts_ = facts_;
      } else {
        result.facts_ = factsBuilder_.build();
      }
    }

    private void buildPartial0(
        com.google.cloud.discoveryengine.v1beta.CheckGroundingRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.groundingConfig_ = groundingConfig_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.answerCandidate_ = answerCandidate_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.groundingSpec_ =
            groundingSpecBuilder_ == null ? groundingSpec_ : groundingSpecBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.discoveryengine.v1beta.CheckGroundingRequest) {
        return mergeFrom((com.google.cloud.discoveryengine.v1beta.CheckGroundingRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.discoveryengine.v1beta.CheckGroundingRequest other) {
      if (other
          == com.google.cloud.discoveryengine.v1beta.CheckGroundingRequest.getDefaultInstance())
        return this;
      if (!other.getGroundingConfig().isEmpty()) {
        groundingConfig_ = other.groundingConfig_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getAnswerCandidate().isEmpty()) {
        answerCandidate_ = other.answerCandidate_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (factsBuilder_ == null) {
        if (!other.facts_.isEmpty()) {
          if (facts_.isEmpty()) {
            facts_ = other.facts_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureFactsIsMutable();
            facts_.addAll(other.facts_);
          }
          onChanged();
        }
      } else {
        if (!other.facts_.isEmpty()) {
          if (factsBuilder_.isEmpty()) {
            factsBuilder_.dispose();
            factsBuilder_ = null;
            facts_ = other.facts_;
            bitField0_ = (bitField0_ & ~0x00000004);
            factsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getFactsFieldBuilder()
                    : null;
          } else {
            factsBuilder_.addAllMessages(other.facts_);
          }
        }
      }
      if (other.hasGroundingSpec()) {
        mergeGroundingSpec(other.getGroundingSpec());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                groundingConfig_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                answerCandidate_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                com.google.cloud.discoveryengine.v1beta.GroundingFact m =
                    input.readMessage(
                        com.google.cloud.discoveryengine.v1beta.GroundingFact.parser(),
                        extensionRegistry);
                if (factsBuilder_ == null) {
                  ensureFactsIsMutable();
                  facts_.add(m);
                } else {
                  factsBuilder_.addMessage(m);
                }
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getGroundingSpecFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object groundingConfig_ = "";
    /**
     *
     *
     * <pre>
     * Required. The resource name of the grounding config, such as
     * `projects/&#42;&#47;locations/global/groundingConfigs/default_grounding_config`.
     * </pre>
     *
     * <code>
     * string grounding_config = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The groundingConfig.
     */
    public java.lang.String getGroundingConfig() {
      java.lang.Object ref = groundingConfig_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        groundingConfig_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the grounding config, such as
     * `projects/&#42;&#47;locations/global/groundingConfigs/default_grounding_config`.
     * </pre>
     *
     * <code>
     * string grounding_config = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for groundingConfig.
     */
    public com.google.protobuf.ByteString getGroundingConfigBytes() {
      java.lang.Object ref = groundingConfig_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        groundingConfig_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the grounding config, such as
     * `projects/&#42;&#47;locations/global/groundingConfigs/default_grounding_config`.
     * </pre>
     *
     * <code>
     * string grounding_config = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The groundingConfig to set.
     * @return This builder for chaining.
     */
    public Builder setGroundingConfig(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      groundingConfig_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the grounding config, such as
     * `projects/&#42;&#47;locations/global/groundingConfigs/default_grounding_config`.
     * </pre>
     *
     * <code>
     * string grounding_config = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearGroundingConfig() {
      groundingConfig_ = getDefaultInstance().getGroundingConfig();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the grounding config, such as
     * `projects/&#42;&#47;locations/global/groundingConfigs/default_grounding_config`.
     * </pre>
     *
     * <code>
     * string grounding_config = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for groundingConfig to set.
     * @return This builder for chaining.
     */
    public Builder setGroundingConfigBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      groundingConfig_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object answerCandidate_ = "";
    /**
     *
     *
     * <pre>
     * Answer candidate to check.
     * </pre>
     *
     * <code>string answer_candidate = 2;</code>
     *
     * @return The answerCandidate.
     */
    public java.lang.String getAnswerCandidate() {
      java.lang.Object ref = answerCandidate_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        answerCandidate_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Answer candidate to check.
     * </pre>
     *
     * <code>string answer_candidate = 2;</code>
     *
     * @return The bytes for answerCandidate.
     */
    public com.google.protobuf.ByteString getAnswerCandidateBytes() {
      java.lang.Object ref = answerCandidate_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        answerCandidate_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Answer candidate to check.
     * </pre>
     *
     * <code>string answer_candidate = 2;</code>
     *
     * @param value The answerCandidate to set.
     * @return This builder for chaining.
     */
    public Builder setAnswerCandidate(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      answerCandidate_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Answer candidate to check.
     * </pre>
     *
     * <code>string answer_candidate = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAnswerCandidate() {
      answerCandidate_ = getDefaultInstance().getAnswerCandidate();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Answer candidate to check.
     * </pre>
     *
     * <code>string answer_candidate = 2;</code>
     *
     * @param value The bytes for answerCandidate to set.
     * @return This builder for chaining.
     */
    public Builder setAnswerCandidateBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      answerCandidate_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.discoveryengine.v1beta.GroundingFact> facts_ =
        java.util.Collections.emptyList();

    private void ensureFactsIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        facts_ =
            new java.util.ArrayList<com.google.cloud.discoveryengine.v1beta.GroundingFact>(facts_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.discoveryengine.v1beta.GroundingFact,
            com.google.cloud.discoveryengine.v1beta.GroundingFact.Builder,
            com.google.cloud.discoveryengine.v1beta.GroundingFactOrBuilder>
        factsBuilder_;

    /**
     *
     *
     * <pre>
     * List of facts for the grounding check.
     * We support up to 200 facts.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.GroundingFact facts = 3;</code>
     */
    public java.util.List<com.google.cloud.discoveryengine.v1beta.GroundingFact> getFactsList() {
      if (factsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(facts_);
      } else {
        return factsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * List of facts for the grounding check.
     * We support up to 200 facts.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.GroundingFact facts = 3;</code>
     */
    public int getFactsCount() {
      if (factsBuilder_ == null) {
        return facts_.size();
      } else {
        return factsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * List of facts for the grounding check.
     * We support up to 200 facts.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.GroundingFact facts = 3;</code>
     */
    public com.google.cloud.discoveryengine.v1beta.GroundingFact getFacts(int index) {
      if (factsBuilder_ == null) {
        return facts_.get(index);
      } else {
        return factsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * List of facts for the grounding check.
     * We support up to 200 facts.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.GroundingFact facts = 3;</code>
     */
    public Builder setFacts(
        int index, com.google.cloud.discoveryengine.v1beta.GroundingFact value) {
      if (factsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFactsIsMutable();
        facts_.set(index, value);
        onChanged();
      } else {
        factsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of facts for the grounding check.
     * We support up to 200 facts.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.GroundingFact facts = 3;</code>
     */
    public Builder setFacts(
        int index, com.google.cloud.discoveryengine.v1beta.GroundingFact.Builder builderForValue) {
      if (factsBuilder_ == null) {
        ensureFactsIsMutable();
        facts_.set(index, builderForValue.build());
        onChanged();
      } else {
        factsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of facts for the grounding check.
     * We support up to 200 facts.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.GroundingFact facts = 3;</code>
     */
    public Builder addFacts(com.google.cloud.discoveryengine.v1beta.GroundingFact value) {
      if (factsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFactsIsMutable();
        facts_.add(value);
        onChanged();
      } else {
        factsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of facts for the grounding check.
     * We support up to 200 facts.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.GroundingFact facts = 3;</code>
     */
    public Builder addFacts(
        int index, com.google.cloud.discoveryengine.v1beta.GroundingFact value) {
      if (factsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFactsIsMutable();
        facts_.add(index, value);
        onChanged();
      } else {
        factsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of facts for the grounding check.
     * We support up to 200 facts.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.GroundingFact facts = 3;</code>
     */
    public Builder addFacts(
        com.google.cloud.discoveryengine.v1beta.GroundingFact.Builder builderForValue) {
      if (factsBuilder_ == null) {
        ensureFactsIsMutable();
        facts_.add(builderForValue.build());
        onChanged();
      } else {
        factsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of facts for the grounding check.
     * We support up to 200 facts.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.GroundingFact facts = 3;</code>
     */
    public Builder addFacts(
        int index, com.google.cloud.discoveryengine.v1beta.GroundingFact.Builder builderForValue) {
      if (factsBuilder_ == null) {
        ensureFactsIsMutable();
        facts_.add(index, builderForValue.build());
        onChanged();
      } else {
        factsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of facts for the grounding check.
     * We support up to 200 facts.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.GroundingFact facts = 3;</code>
     */
    public Builder addAllFacts(
        java.lang.Iterable<? extends com.google.cloud.discoveryengine.v1beta.GroundingFact>
            values) {
      if (factsBuilder_ == null) {
        ensureFactsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, facts_);
        onChanged();
      } else {
        factsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of facts for the grounding check.
     * We support up to 200 facts.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.GroundingFact facts = 3;</code>
     */
    public Builder clearFacts() {
      if (factsBuilder_ == null) {
        facts_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        factsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of facts for the grounding check.
     * We support up to 200 facts.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.GroundingFact facts = 3;</code>
     */
    public Builder removeFacts(int index) {
      if (factsBuilder_ == null) {
        ensureFactsIsMutable();
        facts_.remove(index);
        onChanged();
      } else {
        factsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of facts for the grounding check.
     * We support up to 200 facts.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.GroundingFact facts = 3;</code>
     */
    public com.google.cloud.discoveryengine.v1beta.GroundingFact.Builder getFactsBuilder(
        int index) {
      return getFactsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * List of facts for the grounding check.
     * We support up to 200 facts.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.GroundingFact facts = 3;</code>
     */
    public com.google.cloud.discoveryengine.v1beta.GroundingFactOrBuilder getFactsOrBuilder(
        int index) {
      if (factsBuilder_ == null) {
        return facts_.get(index);
      } else {
        return factsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * List of facts for the grounding check.
     * We support up to 200 facts.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.GroundingFact facts = 3;</code>
     */
    public java.util.List<? extends com.google.cloud.discoveryengine.v1beta.GroundingFactOrBuilder>
        getFactsOrBuilderList() {
      if (factsBuilder_ != null) {
        return factsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(facts_);
      }
    }
    /**
     *
     *
     * <pre>
     * List of facts for the grounding check.
     * We support up to 200 facts.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.GroundingFact facts = 3;</code>
     */
    public com.google.cloud.discoveryengine.v1beta.GroundingFact.Builder addFactsBuilder() {
      return getFactsFieldBuilder()
          .addBuilder(com.google.cloud.discoveryengine.v1beta.GroundingFact.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * List of facts for the grounding check.
     * We support up to 200 facts.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.GroundingFact facts = 3;</code>
     */
    public com.google.cloud.discoveryengine.v1beta.GroundingFact.Builder addFactsBuilder(
        int index) {
      return getFactsFieldBuilder()
          .addBuilder(
              index, com.google.cloud.discoveryengine.v1beta.GroundingFact.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * List of facts for the grounding check.
     * We support up to 200 facts.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.GroundingFact facts = 3;</code>
     */
    public java.util.List<com.google.cloud.discoveryengine.v1beta.GroundingFact.Builder>
        getFactsBuilderList() {
      return getFactsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.discoveryengine.v1beta.GroundingFact,
            com.google.cloud.discoveryengine.v1beta.GroundingFact.Builder,
            com.google.cloud.discoveryengine.v1beta.GroundingFactOrBuilder>
        getFactsFieldBuilder() {
      if (factsBuilder_ == null) {
        factsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.discoveryengine.v1beta.GroundingFact,
                com.google.cloud.discoveryengine.v1beta.GroundingFact.Builder,
                com.google.cloud.discoveryengine.v1beta.GroundingFactOrBuilder>(
                facts_, ((bitField0_ & 0x00000004) != 0), getParentForChildren(), isClean());
        facts_ = null;
      }
      return factsBuilder_;
    }

    private com.google.cloud.discoveryengine.v1beta.CheckGroundingSpec groundingSpec_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1beta.CheckGroundingSpec,
            com.google.cloud.discoveryengine.v1beta.CheckGroundingSpec.Builder,
            com.google.cloud.discoveryengine.v1beta.CheckGroundingSpecOrBuilder>
        groundingSpecBuilder_;
    /**
     *
     *
     * <pre>
     * Configuration of the grounding check.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.CheckGroundingSpec grounding_spec = 4;</code>
     *
     * @return Whether the groundingSpec field is set.
     */
    public boolean hasGroundingSpec() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Configuration of the grounding check.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.CheckGroundingSpec grounding_spec = 4;</code>
     *
     * @return The groundingSpec.
     */
    public com.google.cloud.discoveryengine.v1beta.CheckGroundingSpec getGroundingSpec() {
      if (groundingSpecBuilder_ == null) {
        return groundingSpec_ == null
            ? com.google.cloud.discoveryengine.v1beta.CheckGroundingSpec.getDefaultInstance()
            : groundingSpec_;
      } else {
        return groundingSpecBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration of the grounding check.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.CheckGroundingSpec grounding_spec = 4;</code>
     */
    public Builder setGroundingSpec(
        com.google.cloud.discoveryengine.v1beta.CheckGroundingSpec value) {
      if (groundingSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        groundingSpec_ = value;
      } else {
        groundingSpecBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration of the grounding check.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.CheckGroundingSpec grounding_spec = 4;</code>
     */
    public Builder setGroundingSpec(
        com.google.cloud.discoveryengine.v1beta.CheckGroundingSpec.Builder builderForValue) {
      if (groundingSpecBuilder_ == null) {
        groundingSpec_ = builderForValue.build();
      } else {
        groundingSpecBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration of the grounding check.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.CheckGroundingSpec grounding_spec = 4;</code>
     */
    public Builder mergeGroundingSpec(
        com.google.cloud.discoveryengine.v1beta.CheckGroundingSpec value) {
      if (groundingSpecBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && groundingSpec_ != null
            && groundingSpec_
                != com.google.cloud.discoveryengine.v1beta.CheckGroundingSpec
                    .getDefaultInstance()) {
          getGroundingSpecBuilder().mergeFrom(value);
        } else {
          groundingSpec_ = value;
        }
      } else {
        groundingSpecBuilder_.mergeFrom(value);
      }
      if (groundingSpec_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration of the grounding check.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.CheckGroundingSpec grounding_spec = 4;</code>
     */
    public Builder clearGroundingSpec() {
      bitField0_ = (bitField0_ & ~0x00000008);
      groundingSpec_ = null;
      if (groundingSpecBuilder_ != null) {
        groundingSpecBuilder_.dispose();
        groundingSpecBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration of the grounding check.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.CheckGroundingSpec grounding_spec = 4;</code>
     */
    public com.google.cloud.discoveryengine.v1beta.CheckGroundingSpec.Builder
        getGroundingSpecBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getGroundingSpecFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configuration of the grounding check.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.CheckGroundingSpec grounding_spec = 4;</code>
     */
    public com.google.cloud.discoveryengine.v1beta.CheckGroundingSpecOrBuilder
        getGroundingSpecOrBuilder() {
      if (groundingSpecBuilder_ != null) {
        return groundingSpecBuilder_.getMessageOrBuilder();
      } else {
        return groundingSpec_ == null
            ? com.google.cloud.discoveryengine.v1beta.CheckGroundingSpec.getDefaultInstance()
            : groundingSpec_;
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration of the grounding check.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.CheckGroundingSpec grounding_spec = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1beta.CheckGroundingSpec,
            com.google.cloud.discoveryengine.v1beta.CheckGroundingSpec.Builder,
            com.google.cloud.discoveryengine.v1beta.CheckGroundingSpecOrBuilder>
        getGroundingSpecFieldBuilder() {
      if (groundingSpecBuilder_ == null) {
        groundingSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1beta.CheckGroundingSpec,
                com.google.cloud.discoveryengine.v1beta.CheckGroundingSpec.Builder,
                com.google.cloud.discoveryengine.v1beta.CheckGroundingSpecOrBuilder>(
                getGroundingSpec(), getParentForChildren(), isClean());
        groundingSpec_ = null;
      }
      return groundingSpecBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.CheckGroundingRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.CheckGroundingRequest)
  private static final com.google.cloud.discoveryengine.v1beta.CheckGroundingRequest
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.discoveryengine.v1beta.CheckGroundingRequest();
  }

  public static com.google.cloud.discoveryengine.v1beta.CheckGroundingRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CheckGroundingRequest> PARSER =
      new com.google.protobuf.AbstractParser<CheckGroundingRequest>() {
        @java.lang.Override
        public CheckGroundingRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<CheckGroundingRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CheckGroundingRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.CheckGroundingRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
