/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/discoveryengine/v1beta/document_processing_config.proto

// Protobuf Java Version: 3.25.3
package com.google.cloud.discoveryengine.v1beta;

/**
 *
 *
 * <pre>
 * A singleton resource of
 * [DataStore][google.cloud.discoveryengine.v1beta.DataStore]. It's empty when
 * [DataStore][google.cloud.discoveryengine.v1beta.DataStore] is created, which
 * defaults to digital parser. The first call to
 * [DataStoreService.UpdateDocumentProcessingConfig][] method will initialize
 * the config.
 * </pre>
 *
 * Protobuf type {@code google.cloud.discoveryengine.v1beta.DocumentProcessingConfig}
 */
public final class DocumentProcessingConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.DocumentProcessingConfig)
    DocumentProcessingConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use DocumentProcessingConfig.newBuilder() to construct.
  private DocumentProcessingConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private DocumentProcessingConfig() {
    name_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new DocumentProcessingConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfigProto
        .internal_static_google_cloud_discoveryengine_v1beta_DocumentProcessingConfig_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 5:
        return internalGetParsingConfigOverrides();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfigProto
        .internal_static_google_cloud_discoveryengine_v1beta_DocumentProcessingConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.class,
            com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.Builder.class);
  }

  public interface ParsingConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Configurations applied to digital parser.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig.DigitalParsingConfig digital_parsing_config = 1;
     * </code>
     *
     * @return Whether the digitalParsingConfig field is set.
     */
    boolean hasDigitalParsingConfig();
    /**
     *
     *
     * <pre>
     * Configurations applied to digital parser.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig.DigitalParsingConfig digital_parsing_config = 1;
     * </code>
     *
     * @return The digitalParsingConfig.
     */
    com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
            .DigitalParsingConfig
        getDigitalParsingConfig();
    /**
     *
     *
     * <pre>
     * Configurations applied to digital parser.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig.DigitalParsingConfig digital_parsing_config = 1;
     * </code>
     */
    com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
            .DigitalParsingConfigOrBuilder
        getDigitalParsingConfigOrBuilder();

    /**
     *
     *
     * <pre>
     * Configurations applied to OCR parser. Currently it only applies to
     * PDFs.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig.OcrParsingConfig ocr_parsing_config = 2;
     * </code>
     *
     * @return Whether the ocrParsingConfig field is set.
     */
    boolean hasOcrParsingConfig();
    /**
     *
     *
     * <pre>
     * Configurations applied to OCR parser. Currently it only applies to
     * PDFs.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig.OcrParsingConfig ocr_parsing_config = 2;
     * </code>
     *
     * @return The ocrParsingConfig.
     */
    com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig.OcrParsingConfig
        getOcrParsingConfig();
    /**
     *
     *
     * <pre>
     * Configurations applied to OCR parser. Currently it only applies to
     * PDFs.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig.OcrParsingConfig ocr_parsing_config = 2;
     * </code>
     */
    com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
            .OcrParsingConfigOrBuilder
        getOcrParsingConfigOrBuilder();

    com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
            .TypeDedicatedConfigCase
        getTypeDedicatedConfigCase();
  }
  /**
   *
   *
   * <pre>
   * Related configurations applied to a specific type of document parser.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig}
   */
  public static final class ParsingConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig)
      ParsingConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ParsingConfig.newBuilder() to construct.
    private ParsingConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ParsingConfig() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ParsingConfig();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfigProto
          .internal_static_google_cloud_discoveryengine_v1beta_DocumentProcessingConfig_ParsingConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfigProto
          .internal_static_google_cloud_discoveryengine_v1beta_DocumentProcessingConfig_ParsingConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig.class,
              com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig.Builder
                  .class);
    }

    public interface DigitalParsingConfigOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig.DigitalParsingConfig)
        com.google.protobuf.MessageOrBuilder {}
    /**
     *
     *
     * <pre>
     * The digital parsing configurations for documents.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig.DigitalParsingConfig}
     */
    public static final class DigitalParsingConfig extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig.DigitalParsingConfig)
        DigitalParsingConfigOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use DigitalParsingConfig.newBuilder() to construct.
      private DigitalParsingConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private DigitalParsingConfig() {}

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new DigitalParsingConfig();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfigProto
            .internal_static_google_cloud_discoveryengine_v1beta_DocumentProcessingConfig_ParsingConfig_DigitalParsingConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfigProto
            .internal_static_google_cloud_discoveryengine_v1beta_DocumentProcessingConfig_ParsingConfig_DigitalParsingConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
                    .DigitalParsingConfig.class,
                com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
                    .DigitalParsingConfig.Builder.class);
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
                .DigitalParsingConfig)) {
          return super.equals(obj);
        }
        com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
                .DigitalParsingConfig
            other =
                (com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
                        .DigitalParsingConfig)
                    obj;

        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
              .DigitalParsingConfig
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
              .DigitalParsingConfig
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
              .DigitalParsingConfig
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
              .DigitalParsingConfig
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
              .DigitalParsingConfig
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
              .DigitalParsingConfig
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
              .DigitalParsingConfig
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
              .DigitalParsingConfig
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
              .DigitalParsingConfig
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
              .DigitalParsingConfig
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
              .DigitalParsingConfig
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
              .DigitalParsingConfig
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
                  .DigitalParsingConfig
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * The digital parsing configurations for documents.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig.DigitalParsingConfig}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig.DigitalParsingConfig)
          com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
              .DigitalParsingConfigOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfigProto
              .internal_static_google_cloud_discoveryengine_v1beta_DocumentProcessingConfig_ParsingConfig_DigitalParsingConfig_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfigProto
              .internal_static_google_cloud_discoveryengine_v1beta_DocumentProcessingConfig_ParsingConfig_DigitalParsingConfig_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
                      .DigitalParsingConfig.class,
                  com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
                      .DigitalParsingConfig.Builder.class);
        }

        // Construct using
        // com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig.DigitalParsingConfig.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfigProto
              .internal_static_google_cloud_discoveryengine_v1beta_DocumentProcessingConfig_ParsingConfig_DigitalParsingConfig_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
                .DigitalParsingConfig
            getDefaultInstanceForType() {
          return com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
              .DigitalParsingConfig.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
                .DigitalParsingConfig
            build() {
          com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
                  .DigitalParsingConfig
              result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
                .DigitalParsingConfig
            buildPartial() {
          com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
                  .DigitalParsingConfig
              result =
                  new com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
                      .DigitalParsingConfig(this);
          onBuilt();
          return result;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
                  .DigitalParsingConfig) {
            return mergeFrom(
                (com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
                        .DigitalParsingConfig)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
                    .DigitalParsingConfig
                other) {
          if (other
              == com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
                  .DigitalParsingConfig.getDefaultInstance()) return this;
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig.DigitalParsingConfig)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig.DigitalParsingConfig)
      private static final com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig
              .ParsingConfig.DigitalParsingConfig
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
                .DigitalParsingConfig();
      }

      public static com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
              .DigitalParsingConfig
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<DigitalParsingConfig> PARSER =
          new com.google.protobuf.AbstractParser<DigitalParsingConfig>() {
            @java.lang.Override
            public DigitalParsingConfig parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<DigitalParsingConfig> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<DigitalParsingConfig> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
              .DigitalParsingConfig
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface OcrParsingConfigOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig.OcrParsingConfig)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * [DEPRECATED] This field is deprecated. To use the additional enhanced
       * document elements processing, please switch to `layout_parsing_config`.
       * </pre>
       *
       * <code>repeated string enhanced_document_elements = 1 [deprecated = true];</code>
       *
       * @deprecated
       *     google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig.OcrParsingConfig.enhanced_document_elements
       *     is deprecated. See
       *     google/cloud/discoveryengine/v1beta/document_processing_config.proto;l=52
       * @return A list containing the enhancedDocumentElements.
       */
      @java.lang.Deprecated
      java.util.List<java.lang.String> getEnhancedDocumentElementsList();
      /**
       *
       *
       * <pre>
       * [DEPRECATED] This field is deprecated. To use the additional enhanced
       * document elements processing, please switch to `layout_parsing_config`.
       * </pre>
       *
       * <code>repeated string enhanced_document_elements = 1 [deprecated = true];</code>
       *
       * @deprecated
       *     google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig.OcrParsingConfig.enhanced_document_elements
       *     is deprecated. See
       *     google/cloud/discoveryengine/v1beta/document_processing_config.proto;l=52
       * @return The count of enhancedDocumentElements.
       */
      @java.lang.Deprecated
      int getEnhancedDocumentElementsCount();
      /**
       *
       *
       * <pre>
       * [DEPRECATED] This field is deprecated. To use the additional enhanced
       * document elements processing, please switch to `layout_parsing_config`.
       * </pre>
       *
       * <code>repeated string enhanced_document_elements = 1 [deprecated = true];</code>
       *
       * @deprecated
       *     google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig.OcrParsingConfig.enhanced_document_elements
       *     is deprecated. See
       *     google/cloud/discoveryengine/v1beta/document_processing_config.proto;l=52
       * @param index The index of the element to return.
       * @return The enhancedDocumentElements at the given index.
       */
      @java.lang.Deprecated
      java.lang.String getEnhancedDocumentElements(int index);
      /**
       *
       *
       * <pre>
       * [DEPRECATED] This field is deprecated. To use the additional enhanced
       * document elements processing, please switch to `layout_parsing_config`.
       * </pre>
       *
       * <code>repeated string enhanced_document_elements = 1 [deprecated = true];</code>
       *
       * @deprecated
       *     google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig.OcrParsingConfig.enhanced_document_elements
       *     is deprecated. See
       *     google/cloud/discoveryengine/v1beta/document_processing_config.proto;l=52
       * @param index The index of the value to return.
       * @return The bytes of the enhancedDocumentElements at the given index.
       */
      @java.lang.Deprecated
      com.google.protobuf.ByteString getEnhancedDocumentElementsBytes(int index);

      /**
       *
       *
       * <pre>
       * If true, will use native text instead of OCR text on pages containing
       * native text.
       * </pre>
       *
       * <code>bool use_native_text = 2;</code>
       *
       * @return The useNativeText.
       */
      boolean getUseNativeText();
    }
    /**
     *
     *
     * <pre>
     * The OCR parsing configurations for documents.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig.OcrParsingConfig}
     */
    public static final class OcrParsingConfig extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig.OcrParsingConfig)
        OcrParsingConfigOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use OcrParsingConfig.newBuilder() to construct.
      private OcrParsingConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private OcrParsingConfig() {
        enhancedDocumentElements_ = com.google.protobuf.LazyStringArrayList.emptyList();
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new OcrParsingConfig();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfigProto
            .internal_static_google_cloud_discoveryengine_v1beta_DocumentProcessingConfig_ParsingConfig_OcrParsingConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfigProto
            .internal_static_google_cloud_discoveryengine_v1beta_DocumentProcessingConfig_ParsingConfig_OcrParsingConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
                    .OcrParsingConfig.class,
                com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
                    .OcrParsingConfig.Builder.class);
      }

      public static final int ENHANCED_DOCUMENT_ELEMENTS_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private com.google.protobuf.LazyStringArrayList enhancedDocumentElements_ =
          com.google.protobuf.LazyStringArrayList.emptyList();
      /**
       *
       *
       * <pre>
       * [DEPRECATED] This field is deprecated. To use the additional enhanced
       * document elements processing, please switch to `layout_parsing_config`.
       * </pre>
       *
       * <code>repeated string enhanced_document_elements = 1 [deprecated = true];</code>
       *
       * @deprecated
       *     google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig.OcrParsingConfig.enhanced_document_elements
       *     is deprecated. See
       *     google/cloud/discoveryengine/v1beta/document_processing_config.proto;l=52
       * @return A list containing the enhancedDocumentElements.
       */
      @java.lang.Deprecated
      public com.google.protobuf.ProtocolStringList getEnhancedDocumentElementsList() {
        return enhancedDocumentElements_;
      }
      /**
       *
       *
       * <pre>
       * [DEPRECATED] This field is deprecated. To use the additional enhanced
       * document elements processing, please switch to `layout_parsing_config`.
       * </pre>
       *
       * <code>repeated string enhanced_document_elements = 1 [deprecated = true];</code>
       *
       * @deprecated
       *     google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig.OcrParsingConfig.enhanced_document_elements
       *     is deprecated. See
       *     google/cloud/discoveryengine/v1beta/document_processing_config.proto;l=52
       * @return The count of enhancedDocumentElements.
       */
      @java.lang.Deprecated
      public int getEnhancedDocumentElementsCount() {
        return enhancedDocumentElements_.size();
      }
      /**
       *
       *
       * <pre>
       * [DEPRECATED] This field is deprecated. To use the additional enhanced
       * document elements processing, please switch to `layout_parsing_config`.
       * </pre>
       *
       * <code>repeated string enhanced_document_elements = 1 [deprecated = true];</code>
       *
       * @deprecated
       *     google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig.OcrParsingConfig.enhanced_document_elements
       *     is deprecated. See
       *     google/cloud/discoveryengine/v1beta/document_processing_config.proto;l=52
       * @param index The index of the element to return.
       * @return The enhancedDocumentElements at the given index.
       */
      @java.lang.Deprecated
      public java.lang.String getEnhancedDocumentElements(int index) {
        return enhancedDocumentElements_.get(index);
      }
      /**
       *
       *
       * <pre>
       * [DEPRECATED] This field is deprecated. To use the additional enhanced
       * document elements processing, please switch to `layout_parsing_config`.
       * </pre>
       *
       * <code>repeated string enhanced_document_elements = 1 [deprecated = true];</code>
       *
       * @deprecated
       *     google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig.OcrParsingConfig.enhanced_document_elements
       *     is deprecated. See
       *     google/cloud/discoveryengine/v1beta/document_processing_config.proto;l=52
       * @param index The index of the value to return.
       * @return The bytes of the enhancedDocumentElements at the given index.
       */
      @java.lang.Deprecated
      public com.google.protobuf.ByteString getEnhancedDocumentElementsBytes(int index) {
        return enhancedDocumentElements_.getByteString(index);
      }

      public static final int USE_NATIVE_TEXT_FIELD_NUMBER = 2;
      private boolean useNativeText_ = false;
      /**
       *
       *
       * <pre>
       * If true, will use native text instead of OCR text on pages containing
       * native text.
       * </pre>
       *
       * <code>bool use_native_text = 2;</code>
       *
       * @return The useNativeText.
       */
      @java.lang.Override
      public boolean getUseNativeText() {
        return useNativeText_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        for (int i = 0; i < enhancedDocumentElements_.size(); i++) {
          com.google.protobuf.GeneratedMessageV3.writeString(
              output, 1, enhancedDocumentElements_.getRaw(i));
        }
        if (useNativeText_ != false) {
          output.writeBool(2, useNativeText_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        {
          int dataSize = 0;
          for (int i = 0; i < enhancedDocumentElements_.size(); i++) {
            dataSize += computeStringSizeNoTag(enhancedDocumentElements_.getRaw(i));
          }
          size += dataSize;
          size += 1 * getEnhancedDocumentElementsList().size();
        }
        if (useNativeText_ != false) {
          size += com.google.protobuf.CodedOutputStream.computeBoolSize(2, useNativeText_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
                .OcrParsingConfig)) {
          return super.equals(obj);
        }
        com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
                .OcrParsingConfig
            other =
                (com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
                        .OcrParsingConfig)
                    obj;

        if (!getEnhancedDocumentElementsList().equals(other.getEnhancedDocumentElementsList()))
          return false;
        if (getUseNativeText() != other.getUseNativeText()) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (getEnhancedDocumentElementsCount() > 0) {
          hash = (37 * hash) + ENHANCED_DOCUMENT_ELEMENTS_FIELD_NUMBER;
          hash = (53 * hash) + getEnhancedDocumentElementsList().hashCode();
        }
        hash = (37 * hash) + USE_NATIVE_TEXT_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getUseNativeText());
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
              .OcrParsingConfig
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
              .OcrParsingConfig
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
              .OcrParsingConfig
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
              .OcrParsingConfig
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
              .OcrParsingConfig
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
              .OcrParsingConfig
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
              .OcrParsingConfig
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
              .OcrParsingConfig
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
              .OcrParsingConfig
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
              .OcrParsingConfig
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
              .OcrParsingConfig
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
              .OcrParsingConfig
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
                  .OcrParsingConfig
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * The OCR parsing configurations for documents.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig.OcrParsingConfig}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig.OcrParsingConfig)
          com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
              .OcrParsingConfigOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfigProto
              .internal_static_google_cloud_discoveryengine_v1beta_DocumentProcessingConfig_ParsingConfig_OcrParsingConfig_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfigProto
              .internal_static_google_cloud_discoveryengine_v1beta_DocumentProcessingConfig_ParsingConfig_OcrParsingConfig_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
                      .OcrParsingConfig.class,
                  com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
                      .OcrParsingConfig.Builder.class);
        }

        // Construct using
        // com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig.OcrParsingConfig.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          enhancedDocumentElements_ = com.google.protobuf.LazyStringArrayList.emptyList();
          useNativeText_ = false;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfigProto
              .internal_static_google_cloud_discoveryengine_v1beta_DocumentProcessingConfig_ParsingConfig_OcrParsingConfig_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
                .OcrParsingConfig
            getDefaultInstanceForType() {
          return com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
              .OcrParsingConfig.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
                .OcrParsingConfig
            build() {
          com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
                  .OcrParsingConfig
              result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
                .OcrParsingConfig
            buildPartial() {
          com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
                  .OcrParsingConfig
              result =
                  new com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
                      .OcrParsingConfig(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
                    .OcrParsingConfig
                result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            enhancedDocumentElements_.makeImmutable();
            result.enhancedDocumentElements_ = enhancedDocumentElements_;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.useNativeText_ = useNativeText_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
                  .OcrParsingConfig) {
            return mergeFrom(
                (com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
                        .OcrParsingConfig)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
                    .OcrParsingConfig
                other) {
          if (other
              == com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
                  .OcrParsingConfig.getDefaultInstance()) return this;
          if (!other.enhancedDocumentElements_.isEmpty()) {
            if (enhancedDocumentElements_.isEmpty()) {
              enhancedDocumentElements_ = other.enhancedDocumentElements_;
              bitField0_ |= 0x00000001;
            } else {
              ensureEnhancedDocumentElementsIsMutable();
              enhancedDocumentElements_.addAll(other.enhancedDocumentElements_);
            }
            onChanged();
          }
          if (other.getUseNativeText() != false) {
            setUseNativeText(other.getUseNativeText());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    java.lang.String s = input.readStringRequireUtf8();
                    ensureEnhancedDocumentElementsIsMutable();
                    enhancedDocumentElements_.add(s);
                    break;
                  } // case 10
                case 16:
                  {
                    useNativeText_ = input.readBool();
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 16
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private com.google.protobuf.LazyStringArrayList enhancedDocumentElements_ =
            com.google.protobuf.LazyStringArrayList.emptyList();

        private void ensureEnhancedDocumentElementsIsMutable() {
          if (!enhancedDocumentElements_.isModifiable()) {
            enhancedDocumentElements_ =
                new com.google.protobuf.LazyStringArrayList(enhancedDocumentElements_);
          }
          bitField0_ |= 0x00000001;
        }
        /**
         *
         *
         * <pre>
         * [DEPRECATED] This field is deprecated. To use the additional enhanced
         * document elements processing, please switch to `layout_parsing_config`.
         * </pre>
         *
         * <code>repeated string enhanced_document_elements = 1 [deprecated = true];</code>
         *
         * @deprecated
         *     google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig.OcrParsingConfig.enhanced_document_elements
         *     is deprecated. See
         *     google/cloud/discoveryengine/v1beta/document_processing_config.proto;l=52
         * @return A list containing the enhancedDocumentElements.
         */
        @java.lang.Deprecated
        public com.google.protobuf.ProtocolStringList getEnhancedDocumentElementsList() {
          enhancedDocumentElements_.makeImmutable();
          return enhancedDocumentElements_;
        }
        /**
         *
         *
         * <pre>
         * [DEPRECATED] This field is deprecated. To use the additional enhanced
         * document elements processing, please switch to `layout_parsing_config`.
         * </pre>
         *
         * <code>repeated string enhanced_document_elements = 1 [deprecated = true];</code>
         *
         * @deprecated
         *     google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig.OcrParsingConfig.enhanced_document_elements
         *     is deprecated. See
         *     google/cloud/discoveryengine/v1beta/document_processing_config.proto;l=52
         * @return The count of enhancedDocumentElements.
         */
        @java.lang.Deprecated
        public int getEnhancedDocumentElementsCount() {
          return enhancedDocumentElements_.size();
        }
        /**
         *
         *
         * <pre>
         * [DEPRECATED] This field is deprecated. To use the additional enhanced
         * document elements processing, please switch to `layout_parsing_config`.
         * </pre>
         *
         * <code>repeated string enhanced_document_elements = 1 [deprecated = true];</code>
         *
         * @deprecated
         *     google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig.OcrParsingConfig.enhanced_document_elements
         *     is deprecated. See
         *     google/cloud/discoveryengine/v1beta/document_processing_config.proto;l=52
         * @param index The index of the element to return.
         * @return The enhancedDocumentElements at the given index.
         */
        @java.lang.Deprecated
        public java.lang.String getEnhancedDocumentElements(int index) {
          return enhancedDocumentElements_.get(index);
        }
        /**
         *
         *
         * <pre>
         * [DEPRECATED] This field is deprecated. To use the additional enhanced
         * document elements processing, please switch to `layout_parsing_config`.
         * </pre>
         *
         * <code>repeated string enhanced_document_elements = 1 [deprecated = true];</code>
         *
         * @deprecated
         *     google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig.OcrParsingConfig.enhanced_document_elements
         *     is deprecated. See
         *     google/cloud/discoveryengine/v1beta/document_processing_config.proto;l=52
         * @param index The index of the value to return.
         * @return The bytes of the enhancedDocumentElements at the given index.
         */
        @java.lang.Deprecated
        public com.google.protobuf.ByteString getEnhancedDocumentElementsBytes(int index) {
          return enhancedDocumentElements_.getByteString(index);
        }
        /**
         *
         *
         * <pre>
         * [DEPRECATED] This field is deprecated. To use the additional enhanced
         * document elements processing, please switch to `layout_parsing_config`.
         * </pre>
         *
         * <code>repeated string enhanced_document_elements = 1 [deprecated = true];</code>
         *
         * @deprecated
         *     google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig.OcrParsingConfig.enhanced_document_elements
         *     is deprecated. See
         *     google/cloud/discoveryengine/v1beta/document_processing_config.proto;l=52
         * @param index The index to set the value at.
         * @param value The enhancedDocumentElements to set.
         * @return This builder for chaining.
         */
        @java.lang.Deprecated
        public Builder setEnhancedDocumentElements(int index, java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureEnhancedDocumentElementsIsMutable();
          enhancedDocumentElements_.set(index, value);
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * [DEPRECATED] This field is deprecated. To use the additional enhanced
         * document elements processing, please switch to `layout_parsing_config`.
         * </pre>
         *
         * <code>repeated string enhanced_document_elements = 1 [deprecated = true];</code>
         *
         * @deprecated
         *     google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig.OcrParsingConfig.enhanced_document_elements
         *     is deprecated. See
         *     google/cloud/discoveryengine/v1beta/document_processing_config.proto;l=52
         * @param value The enhancedDocumentElements to add.
         * @return This builder for chaining.
         */
        @java.lang.Deprecated
        public Builder addEnhancedDocumentElements(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureEnhancedDocumentElementsIsMutable();
          enhancedDocumentElements_.add(value);
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * [DEPRECATED] This field is deprecated. To use the additional enhanced
         * document elements processing, please switch to `layout_parsing_config`.
         * </pre>
         *
         * <code>repeated string enhanced_document_elements = 1 [deprecated = true];</code>
         *
         * @deprecated
         *     google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig.OcrParsingConfig.enhanced_document_elements
         *     is deprecated. See
         *     google/cloud/discoveryengine/v1beta/document_processing_config.proto;l=52
         * @param values The enhancedDocumentElements to add.
         * @return This builder for chaining.
         */
        @java.lang.Deprecated
        public Builder addAllEnhancedDocumentElements(java.lang.Iterable<java.lang.String> values) {
          ensureEnhancedDocumentElementsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, enhancedDocumentElements_);
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * [DEPRECATED] This field is deprecated. To use the additional enhanced
         * document elements processing, please switch to `layout_parsing_config`.
         * </pre>
         *
         * <code>repeated string enhanced_document_elements = 1 [deprecated = true];</code>
         *
         * @deprecated
         *     google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig.OcrParsingConfig.enhanced_document_elements
         *     is deprecated. See
         *     google/cloud/discoveryengine/v1beta/document_processing_config.proto;l=52
         * @return This builder for chaining.
         */
        @java.lang.Deprecated
        public Builder clearEnhancedDocumentElements() {
          enhancedDocumentElements_ = com.google.protobuf.LazyStringArrayList.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          ;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * [DEPRECATED] This field is deprecated. To use the additional enhanced
         * document elements processing, please switch to `layout_parsing_config`.
         * </pre>
         *
         * <code>repeated string enhanced_document_elements = 1 [deprecated = true];</code>
         *
         * @deprecated
         *     google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig.OcrParsingConfig.enhanced_document_elements
         *     is deprecated. See
         *     google/cloud/discoveryengine/v1beta/document_processing_config.proto;l=52
         * @param value The bytes of the enhancedDocumentElements to add.
         * @return This builder for chaining.
         */
        @java.lang.Deprecated
        public Builder addEnhancedDocumentElementsBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          ensureEnhancedDocumentElementsIsMutable();
          enhancedDocumentElements_.add(value);
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        private boolean useNativeText_;
        /**
         *
         *
         * <pre>
         * If true, will use native text instead of OCR text on pages containing
         * native text.
         * </pre>
         *
         * <code>bool use_native_text = 2;</code>
         *
         * @return The useNativeText.
         */
        @java.lang.Override
        public boolean getUseNativeText() {
          return useNativeText_;
        }
        /**
         *
         *
         * <pre>
         * If true, will use native text instead of OCR text on pages containing
         * native text.
         * </pre>
         *
         * <code>bool use_native_text = 2;</code>
         *
         * @param value The useNativeText to set.
         * @return This builder for chaining.
         */
        public Builder setUseNativeText(boolean value) {

          useNativeText_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * If true, will use native text instead of OCR text on pages containing
         * native text.
         * </pre>
         *
         * <code>bool use_native_text = 2;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearUseNativeText() {
          bitField0_ = (bitField0_ & ~0x00000002);
          useNativeText_ = false;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig.OcrParsingConfig)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig.OcrParsingConfig)
      private static final com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig
              .ParsingConfig.OcrParsingConfig
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
                .OcrParsingConfig();
      }

      public static com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
              .OcrParsingConfig
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<OcrParsingConfig> PARSER =
          new com.google.protobuf.AbstractParser<OcrParsingConfig>() {
            @java.lang.Override
            public OcrParsingConfig parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<OcrParsingConfig> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<OcrParsingConfig> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
              .OcrParsingConfig
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    private int typeDedicatedConfigCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object typeDedicatedConfig_;

    public enum TypeDedicatedConfigCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      DIGITAL_PARSING_CONFIG(1),
      OCR_PARSING_CONFIG(2),
      TYPEDEDICATEDCONFIG_NOT_SET(0);
      private final int value;

      private TypeDedicatedConfigCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static TypeDedicatedConfigCase valueOf(int value) {
        return forNumber(value);
      }

      public static TypeDedicatedConfigCase forNumber(int value) {
        switch (value) {
          case 1:
            return DIGITAL_PARSING_CONFIG;
          case 2:
            return OCR_PARSING_CONFIG;
          case 0:
            return TYPEDEDICATEDCONFIG_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public TypeDedicatedConfigCase getTypeDedicatedConfigCase() {
      return TypeDedicatedConfigCase.forNumber(typeDedicatedConfigCase_);
    }

    public static final int DIGITAL_PARSING_CONFIG_FIELD_NUMBER = 1;
    /**
     *
     *
     * <pre>
     * Configurations applied to digital parser.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig.DigitalParsingConfig digital_parsing_config = 1;
     * </code>
     *
     * @return Whether the digitalParsingConfig field is set.
     */
    @java.lang.Override
    public boolean hasDigitalParsingConfig() {
      return typeDedicatedConfigCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * Configurations applied to digital parser.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig.DigitalParsingConfig digital_parsing_config = 1;
     * </code>
     *
     * @return The digitalParsingConfig.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
            .DigitalParsingConfig
        getDigitalParsingConfig() {
      if (typeDedicatedConfigCase_ == 1) {
        return (com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
                .DigitalParsingConfig)
            typeDedicatedConfig_;
      }
      return com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
          .DigitalParsingConfig.getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * Configurations applied to digital parser.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig.DigitalParsingConfig digital_parsing_config = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
            .DigitalParsingConfigOrBuilder
        getDigitalParsingConfigOrBuilder() {
      if (typeDedicatedConfigCase_ == 1) {
        return (com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
                .DigitalParsingConfig)
            typeDedicatedConfig_;
      }
      return com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
          .DigitalParsingConfig.getDefaultInstance();
    }

    public static final int OCR_PARSING_CONFIG_FIELD_NUMBER = 2;
    /**
     *
     *
     * <pre>
     * Configurations applied to OCR parser. Currently it only applies to
     * PDFs.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig.OcrParsingConfig ocr_parsing_config = 2;
     * </code>
     *
     * @return Whether the ocrParsingConfig field is set.
     */
    @java.lang.Override
    public boolean hasOcrParsingConfig() {
      return typeDedicatedConfigCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Configurations applied to OCR parser. Currently it only applies to
     * PDFs.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig.OcrParsingConfig ocr_parsing_config = 2;
     * </code>
     *
     * @return The ocrParsingConfig.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
            .OcrParsingConfig
        getOcrParsingConfig() {
      if (typeDedicatedConfigCase_ == 2) {
        return (com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
                .OcrParsingConfig)
            typeDedicatedConfig_;
      }
      return com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
          .OcrParsingConfig.getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * Configurations applied to OCR parser. Currently it only applies to
     * PDFs.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig.OcrParsingConfig ocr_parsing_config = 2;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
            .OcrParsingConfigOrBuilder
        getOcrParsingConfigOrBuilder() {
      if (typeDedicatedConfigCase_ == 2) {
        return (com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
                .OcrParsingConfig)
            typeDedicatedConfig_;
      }
      return com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
          .OcrParsingConfig.getDefaultInstance();
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (typeDedicatedConfigCase_ == 1) {
        output.writeMessage(
            1,
            (com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
                    .DigitalParsingConfig)
                typeDedicatedConfig_);
      }
      if (typeDedicatedConfigCase_ == 2) {
        output.writeMessage(
            2,
            (com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
                    .OcrParsingConfig)
                typeDedicatedConfig_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (typeDedicatedConfigCase_ == 1) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                1,
                (com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
                        .DigitalParsingConfig)
                    typeDedicatedConfig_);
      }
      if (typeDedicatedConfigCase_ == 2) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                2,
                (com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
                        .OcrParsingConfig)
                    typeDedicatedConfig_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig)) {
        return super.equals(obj);
      }
      com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig other =
          (com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig) obj;

      if (!getTypeDedicatedConfigCase().equals(other.getTypeDedicatedConfigCase())) return false;
      switch (typeDedicatedConfigCase_) {
        case 1:
          if (!getDigitalParsingConfig().equals(other.getDigitalParsingConfig())) return false;
          break;
        case 2:
          if (!getOcrParsingConfig().equals(other.getOcrParsingConfig())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      switch (typeDedicatedConfigCase_) {
        case 1:
          hash = (37 * hash) + DIGITAL_PARSING_CONFIG_FIELD_NUMBER;
          hash = (53 * hash) + getDigitalParsingConfig().hashCode();
          break;
        case 2:
          hash = (37 * hash) + OCR_PARSING_CONFIG_FIELD_NUMBER;
          hash = (53 * hash) + getOcrParsingConfig().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Related configurations applied to a specific type of document parser.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig)
        com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfigProto
            .internal_static_google_cloud_discoveryengine_v1beta_DocumentProcessingConfig_ParsingConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfigProto
            .internal_static_google_cloud_discoveryengine_v1beta_DocumentProcessingConfig_ParsingConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
                    .class,
                com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
                    .Builder.class);
      }

      // Construct using
      // com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (digitalParsingConfigBuilder_ != null) {
          digitalParsingConfigBuilder_.clear();
        }
        if (ocrParsingConfigBuilder_ != null) {
          ocrParsingConfigBuilder_.clear();
        }
        typeDedicatedConfigCase_ = 0;
        typeDedicatedConfig_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfigProto
            .internal_static_google_cloud_discoveryengine_v1beta_DocumentProcessingConfig_ParsingConfig_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
          getDefaultInstanceForType() {
        return com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
          build() {
        com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
          buildPartial() {
        com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig result =
            new com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig(
                this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig result) {
        int from_bitField0_ = bitField0_;
      }

      private void buildPartialOneofs(
          com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig result) {
        result.typeDedicatedConfigCase_ = typeDedicatedConfigCase_;
        result.typeDedicatedConfig_ = this.typeDedicatedConfig_;
        if (typeDedicatedConfigCase_ == 1 && digitalParsingConfigBuilder_ != null) {
          result.typeDedicatedConfig_ = digitalParsingConfigBuilder_.build();
        }
        if (typeDedicatedConfigCase_ == 2 && ocrParsingConfigBuilder_ != null) {
          result.typeDedicatedConfig_ = ocrParsingConfigBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig) {
          return mergeFrom(
              (com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig other) {
        if (other
            == com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
                .getDefaultInstance()) return this;
        switch (other.getTypeDedicatedConfigCase()) {
          case DIGITAL_PARSING_CONFIG:
            {
              mergeDigitalParsingConfig(other.getDigitalParsingConfig());
              break;
            }
          case OCR_PARSING_CONFIG:
            {
              mergeOcrParsingConfig(other.getOcrParsingConfig());
              break;
            }
          case TYPEDEDICATEDCONFIG_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(
                      getDigitalParsingConfigFieldBuilder().getBuilder(), extensionRegistry);
                  typeDedicatedConfigCase_ = 1;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(
                      getOcrParsingConfigFieldBuilder().getBuilder(), extensionRegistry);
                  typeDedicatedConfigCase_ = 2;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int typeDedicatedConfigCase_ = 0;
      private java.lang.Object typeDedicatedConfig_;

      public TypeDedicatedConfigCase getTypeDedicatedConfigCase() {
        return TypeDedicatedConfigCase.forNumber(typeDedicatedConfigCase_);
      }

      public Builder clearTypeDedicatedConfig() {
        typeDedicatedConfigCase_ = 0;
        typeDedicatedConfig_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
                  .DigitalParsingConfig,
              com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
                  .DigitalParsingConfig.Builder,
              com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
                  .DigitalParsingConfigOrBuilder>
          digitalParsingConfigBuilder_;
      /**
       *
       *
       * <pre>
       * Configurations applied to digital parser.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig.DigitalParsingConfig digital_parsing_config = 1;
       * </code>
       *
       * @return Whether the digitalParsingConfig field is set.
       */
      @java.lang.Override
      public boolean hasDigitalParsingConfig() {
        return typeDedicatedConfigCase_ == 1;
      }
      /**
       *
       *
       * <pre>
       * Configurations applied to digital parser.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig.DigitalParsingConfig digital_parsing_config = 1;
       * </code>
       *
       * @return The digitalParsingConfig.
       */
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
              .DigitalParsingConfig
          getDigitalParsingConfig() {
        if (digitalParsingConfigBuilder_ == null) {
          if (typeDedicatedConfigCase_ == 1) {
            return (com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
                    .DigitalParsingConfig)
                typeDedicatedConfig_;
          }
          return com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
              .DigitalParsingConfig.getDefaultInstance();
        } else {
          if (typeDedicatedConfigCase_ == 1) {
            return digitalParsingConfigBuilder_.getMessage();
          }
          return com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
              .DigitalParsingConfig.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Configurations applied to digital parser.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig.DigitalParsingConfig digital_parsing_config = 1;
       * </code>
       */
      public Builder setDigitalParsingConfig(
          com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
                  .DigitalParsingConfig
              value) {
        if (digitalParsingConfigBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          typeDedicatedConfig_ = value;
          onChanged();
        } else {
          digitalParsingConfigBuilder_.setMessage(value);
        }
        typeDedicatedConfigCase_ = 1;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Configurations applied to digital parser.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig.DigitalParsingConfig digital_parsing_config = 1;
       * </code>
       */
      public Builder setDigitalParsingConfig(
          com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
                  .DigitalParsingConfig.Builder
              builderForValue) {
        if (digitalParsingConfigBuilder_ == null) {
          typeDedicatedConfig_ = builderForValue.build();
          onChanged();
        } else {
          digitalParsingConfigBuilder_.setMessage(builderForValue.build());
        }
        typeDedicatedConfigCase_ = 1;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Configurations applied to digital parser.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig.DigitalParsingConfig digital_parsing_config = 1;
       * </code>
       */
      public Builder mergeDigitalParsingConfig(
          com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
                  .DigitalParsingConfig
              value) {
        if (digitalParsingConfigBuilder_ == null) {
          if (typeDedicatedConfigCase_ == 1
              && typeDedicatedConfig_
                  != com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
                      .DigitalParsingConfig.getDefaultInstance()) {
            typeDedicatedConfig_ =
                com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
                    .DigitalParsingConfig.newBuilder(
                        (com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig
                                .ParsingConfig.DigitalParsingConfig)
                            typeDedicatedConfig_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            typeDedicatedConfig_ = value;
          }
          onChanged();
        } else {
          if (typeDedicatedConfigCase_ == 1) {
            digitalParsingConfigBuilder_.mergeFrom(value);
          } else {
            digitalParsingConfigBuilder_.setMessage(value);
          }
        }
        typeDedicatedConfigCase_ = 1;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Configurations applied to digital parser.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig.DigitalParsingConfig digital_parsing_config = 1;
       * </code>
       */
      public Builder clearDigitalParsingConfig() {
        if (digitalParsingConfigBuilder_ == null) {
          if (typeDedicatedConfigCase_ == 1) {
            typeDedicatedConfigCase_ = 0;
            typeDedicatedConfig_ = null;
            onChanged();
          }
        } else {
          if (typeDedicatedConfigCase_ == 1) {
            typeDedicatedConfigCase_ = 0;
            typeDedicatedConfig_ = null;
          }
          digitalParsingConfigBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Configurations applied to digital parser.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig.DigitalParsingConfig digital_parsing_config = 1;
       * </code>
       */
      public com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
              .DigitalParsingConfig.Builder
          getDigitalParsingConfigBuilder() {
        return getDigitalParsingConfigFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Configurations applied to digital parser.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig.DigitalParsingConfig digital_parsing_config = 1;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
              .DigitalParsingConfigOrBuilder
          getDigitalParsingConfigOrBuilder() {
        if ((typeDedicatedConfigCase_ == 1) && (digitalParsingConfigBuilder_ != null)) {
          return digitalParsingConfigBuilder_.getMessageOrBuilder();
        } else {
          if (typeDedicatedConfigCase_ == 1) {
            return (com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
                    .DigitalParsingConfig)
                typeDedicatedConfig_;
          }
          return com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
              .DigitalParsingConfig.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Configurations applied to digital parser.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig.DigitalParsingConfig digital_parsing_config = 1;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
                  .DigitalParsingConfig,
              com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
                  .DigitalParsingConfig.Builder,
              com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
                  .DigitalParsingConfigOrBuilder>
          getDigitalParsingConfigFieldBuilder() {
        if (digitalParsingConfigBuilder_ == null) {
          if (!(typeDedicatedConfigCase_ == 1)) {
            typeDedicatedConfig_ =
                com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
                    .DigitalParsingConfig.getDefaultInstance();
          }
          digitalParsingConfigBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
                      .DigitalParsingConfig,
                  com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
                      .DigitalParsingConfig.Builder,
                  com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
                      .DigitalParsingConfigOrBuilder>(
                  (com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
                          .DigitalParsingConfig)
                      typeDedicatedConfig_,
                  getParentForChildren(),
                  isClean());
          typeDedicatedConfig_ = null;
        }
        typeDedicatedConfigCase_ = 1;
        onChanged();
        return digitalParsingConfigBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
                  .OcrParsingConfig,
              com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
                  .OcrParsingConfig.Builder,
              com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
                  .OcrParsingConfigOrBuilder>
          ocrParsingConfigBuilder_;
      /**
       *
       *
       * <pre>
       * Configurations applied to OCR parser. Currently it only applies to
       * PDFs.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig.OcrParsingConfig ocr_parsing_config = 2;
       * </code>
       *
       * @return Whether the ocrParsingConfig field is set.
       */
      @java.lang.Override
      public boolean hasOcrParsingConfig() {
        return typeDedicatedConfigCase_ == 2;
      }
      /**
       *
       *
       * <pre>
       * Configurations applied to OCR parser. Currently it only applies to
       * PDFs.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig.OcrParsingConfig ocr_parsing_config = 2;
       * </code>
       *
       * @return The ocrParsingConfig.
       */
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
              .OcrParsingConfig
          getOcrParsingConfig() {
        if (ocrParsingConfigBuilder_ == null) {
          if (typeDedicatedConfigCase_ == 2) {
            return (com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
                    .OcrParsingConfig)
                typeDedicatedConfig_;
          }
          return com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
              .OcrParsingConfig.getDefaultInstance();
        } else {
          if (typeDedicatedConfigCase_ == 2) {
            return ocrParsingConfigBuilder_.getMessage();
          }
          return com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
              .OcrParsingConfig.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Configurations applied to OCR parser. Currently it only applies to
       * PDFs.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig.OcrParsingConfig ocr_parsing_config = 2;
       * </code>
       */
      public Builder setOcrParsingConfig(
          com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
                  .OcrParsingConfig
              value) {
        if (ocrParsingConfigBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          typeDedicatedConfig_ = value;
          onChanged();
        } else {
          ocrParsingConfigBuilder_.setMessage(value);
        }
        typeDedicatedConfigCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Configurations applied to OCR parser. Currently it only applies to
       * PDFs.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig.OcrParsingConfig ocr_parsing_config = 2;
       * </code>
       */
      public Builder setOcrParsingConfig(
          com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
                  .OcrParsingConfig.Builder
              builderForValue) {
        if (ocrParsingConfigBuilder_ == null) {
          typeDedicatedConfig_ = builderForValue.build();
          onChanged();
        } else {
          ocrParsingConfigBuilder_.setMessage(builderForValue.build());
        }
        typeDedicatedConfigCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Configurations applied to OCR parser. Currently it only applies to
       * PDFs.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig.OcrParsingConfig ocr_parsing_config = 2;
       * </code>
       */
      public Builder mergeOcrParsingConfig(
          com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
                  .OcrParsingConfig
              value) {
        if (ocrParsingConfigBuilder_ == null) {
          if (typeDedicatedConfigCase_ == 2
              && typeDedicatedConfig_
                  != com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
                      .OcrParsingConfig.getDefaultInstance()) {
            typeDedicatedConfig_ =
                com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
                    .OcrParsingConfig.newBuilder(
                        (com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig
                                .ParsingConfig.OcrParsingConfig)
                            typeDedicatedConfig_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            typeDedicatedConfig_ = value;
          }
          onChanged();
        } else {
          if (typeDedicatedConfigCase_ == 2) {
            ocrParsingConfigBuilder_.mergeFrom(value);
          } else {
            ocrParsingConfigBuilder_.setMessage(value);
          }
        }
        typeDedicatedConfigCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Configurations applied to OCR parser. Currently it only applies to
       * PDFs.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig.OcrParsingConfig ocr_parsing_config = 2;
       * </code>
       */
      public Builder clearOcrParsingConfig() {
        if (ocrParsingConfigBuilder_ == null) {
          if (typeDedicatedConfigCase_ == 2) {
            typeDedicatedConfigCase_ = 0;
            typeDedicatedConfig_ = null;
            onChanged();
          }
        } else {
          if (typeDedicatedConfigCase_ == 2) {
            typeDedicatedConfigCase_ = 0;
            typeDedicatedConfig_ = null;
          }
          ocrParsingConfigBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Configurations applied to OCR parser. Currently it only applies to
       * PDFs.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig.OcrParsingConfig ocr_parsing_config = 2;
       * </code>
       */
      public com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
              .OcrParsingConfig.Builder
          getOcrParsingConfigBuilder() {
        return getOcrParsingConfigFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Configurations applied to OCR parser. Currently it only applies to
       * PDFs.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig.OcrParsingConfig ocr_parsing_config = 2;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
              .OcrParsingConfigOrBuilder
          getOcrParsingConfigOrBuilder() {
        if ((typeDedicatedConfigCase_ == 2) && (ocrParsingConfigBuilder_ != null)) {
          return ocrParsingConfigBuilder_.getMessageOrBuilder();
        } else {
          if (typeDedicatedConfigCase_ == 2) {
            return (com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
                    .OcrParsingConfig)
                typeDedicatedConfig_;
          }
          return com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
              .OcrParsingConfig.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Configurations applied to OCR parser. Currently it only applies to
       * PDFs.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig.OcrParsingConfig ocr_parsing_config = 2;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
                  .OcrParsingConfig,
              com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
                  .OcrParsingConfig.Builder,
              com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
                  .OcrParsingConfigOrBuilder>
          getOcrParsingConfigFieldBuilder() {
        if (ocrParsingConfigBuilder_ == null) {
          if (!(typeDedicatedConfigCase_ == 2)) {
            typeDedicatedConfig_ =
                com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
                    .OcrParsingConfig.getDefaultInstance();
          }
          ocrParsingConfigBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
                      .OcrParsingConfig,
                  com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
                      .OcrParsingConfig.Builder,
                  com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
                      .OcrParsingConfigOrBuilder>(
                  (com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
                          .OcrParsingConfig)
                      typeDedicatedConfig_,
                  getParentForChildren(),
                  isClean());
          typeDedicatedConfig_ = null;
        }
        typeDedicatedConfigCase_ = 2;
        onChanged();
        return ocrParsingConfigBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig)
    private static final com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig
            .ParsingConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig();
    }

    public static com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ParsingConfig> PARSER =
        new com.google.protobuf.AbstractParser<ParsingConfig>() {
          @java.lang.Override
          public ParsingConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ParsingConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ParsingConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * The full resource name of the Document Processing Config.
   * Format:
   * `projects/&#42;&#47;locations/&#42;&#47;collections/&#42;&#47;dataStores/&#42;&#47;documentProcessingConfig`.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The full resource name of the Document Processing Config.
   * Format:
   * `projects/&#42;&#47;locations/&#42;&#47;collections/&#42;&#47;dataStores/&#42;&#47;documentProcessingConfig`.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DEFAULT_PARSING_CONFIG_FIELD_NUMBER = 4;
  private com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
      defaultParsingConfig_;
  /**
   *
   *
   * <pre>
   * Configurations for default Document parser.
   * If not specified, we will configure it as default DigitalParsingConfig, and
   * the default parsing config will be applied to all file types for Document
   * parsing.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig default_parsing_config = 4;
   * </code>
   *
   * @return Whether the defaultParsingConfig field is set.
   */
  @java.lang.Override
  public boolean hasDefaultParsingConfig() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Configurations for default Document parser.
   * If not specified, we will configure it as default DigitalParsingConfig, and
   * the default parsing config will be applied to all file types for Document
   * parsing.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig default_parsing_config = 4;
   * </code>
   *
   * @return The defaultParsingConfig.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
      getDefaultParsingConfig() {
    return defaultParsingConfig_ == null
        ? com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
            .getDefaultInstance()
        : defaultParsingConfig_;
  }
  /**
   *
   *
   * <pre>
   * Configurations for default Document parser.
   * If not specified, we will configure it as default DigitalParsingConfig, and
   * the default parsing config will be applied to all file types for Document
   * parsing.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig default_parsing_config = 4;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfigOrBuilder
      getDefaultParsingConfigOrBuilder() {
    return defaultParsingConfig_ == null
        ? com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
            .getDefaultInstance()
        : defaultParsingConfig_;
  }

  public static final int PARSING_CONFIG_OVERRIDES_FIELD_NUMBER = 5;

  private static final class ParsingConfigOverridesDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<
            java.lang.String,
            com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig>
        defaultEntry =
            com.google.protobuf.MapEntry
                .<java.lang.String,
                    com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig>
                    newDefaultInstance(
                        com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfigProto
                            .internal_static_google_cloud_discoveryengine_v1beta_DocumentProcessingConfig_ParsingConfigOverridesEntry_descriptor,
                        com.google.protobuf.WireFormat.FieldType.STRING,
                        "",
                        com.google.protobuf.WireFormat.FieldType.MESSAGE,
                        com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig
                            .ParsingConfig.getDefaultInstance());
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<
          java.lang.String,
          com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig>
      parsingConfigOverrides_;

  private com.google.protobuf.MapField<
          java.lang.String,
          com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig>
      internalGetParsingConfigOverrides() {
    if (parsingConfigOverrides_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          ParsingConfigOverridesDefaultEntryHolder.defaultEntry);
    }
    return parsingConfigOverrides_;
  }

  public int getParsingConfigOverridesCount() {
    return internalGetParsingConfigOverrides().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Map from file type to override the default parsing configuration based on
   * the file type. Supported keys:
   * * `pdf`: Override parsing config for PDF files, either digital parsing, ocr
   * parsing or layout parsing is supported.
   * * `html`: Override parsing config for HTML files, only digital parsing and
   * or layout parsing are supported.
   * * `docx`: Override parsing config for DOCX files, only digital parsing and
   * or layout parsing are supported.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig&gt; parsing_config_overrides = 5;
   * </code>
   */
  @java.lang.Override
  public boolean containsParsingConfigOverrides(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetParsingConfigOverrides().getMap().containsKey(key);
  }
  /** Use {@link #getParsingConfigOverridesMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<
          java.lang.String,
          com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig>
      getParsingConfigOverrides() {
    return getParsingConfigOverridesMap();
  }
  /**
   *
   *
   * <pre>
   * Map from file type to override the default parsing configuration based on
   * the file type. Supported keys:
   * * `pdf`: Override parsing config for PDF files, either digital parsing, ocr
   * parsing or layout parsing is supported.
   * * `html`: Override parsing config for HTML files, only digital parsing and
   * or layout parsing are supported.
   * * `docx`: Override parsing config for DOCX files, only digital parsing and
   * or layout parsing are supported.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig&gt; parsing_config_overrides = 5;
   * </code>
   */
  @java.lang.Override
  public java.util.Map<
          java.lang.String,
          com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig>
      getParsingConfigOverridesMap() {
    return internalGetParsingConfigOverrides().getMap();
  }
  /**
   *
   *
   * <pre>
   * Map from file type to override the default parsing configuration based on
   * the file type. Supported keys:
   * * `pdf`: Override parsing config for PDF files, either digital parsing, ocr
   * parsing or layout parsing is supported.
   * * `html`: Override parsing config for HTML files, only digital parsing and
   * or layout parsing are supported.
   * * `docx`: Override parsing config for DOCX files, only digital parsing and
   * or layout parsing are supported.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig&gt; parsing_config_overrides = 5;
   * </code>
   */
  @java.lang.Override
  public /* nullable */ com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig
          .ParsingConfig
      getParsingConfigOverridesOrDefault(
          java.lang.String key,
          /* nullable */
          com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
              defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<
            java.lang.String,
            com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig>
        map = internalGetParsingConfigOverrides().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Map from file type to override the default parsing configuration based on
   * the file type. Supported keys:
   * * `pdf`: Override parsing config for PDF files, either digital parsing, ocr
   * parsing or layout parsing is supported.
   * * `html`: Override parsing config for HTML files, only digital parsing and
   * or layout parsing are supported.
   * * `docx`: Override parsing config for DOCX files, only digital parsing and
   * or layout parsing are supported.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig&gt; parsing_config_overrides = 5;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
      getParsingConfigOverridesOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<
            java.lang.String,
            com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig>
        map = internalGetParsingConfigOverrides().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(4, getDefaultParsingConfig());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output,
        internalGetParsingConfigOverrides(),
        ParsingConfigOverridesDefaultEntryHolder.defaultEntry,
        5);
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(4, getDefaultParsingConfig());
    }
    for (java.util.Map.Entry<
            java.lang.String,
            com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig>
        entry : internalGetParsingConfigOverrides().getMap().entrySet()) {
      com.google.protobuf.MapEntry<
              java.lang.String,
              com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig>
          parsingConfigOverrides__ =
              ParsingConfigOverridesDefaultEntryHolder.defaultEntry
                  .newBuilderForType()
                  .setKey(entry.getKey())
                  .setValue(entry.getValue())
                  .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, parsingConfigOverrides__);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig other =
        (com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig) obj;

    if (!getName().equals(other.getName())) return false;
    if (hasDefaultParsingConfig() != other.hasDefaultParsingConfig()) return false;
    if (hasDefaultParsingConfig()) {
      if (!getDefaultParsingConfig().equals(other.getDefaultParsingConfig())) return false;
    }
    if (!internalGetParsingConfigOverrides().equals(other.internalGetParsingConfigOverrides()))
      return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasDefaultParsingConfig()) {
      hash = (37 * hash) + DEFAULT_PARSING_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getDefaultParsingConfig().hashCode();
    }
    if (!internalGetParsingConfigOverrides().getMap().isEmpty()) {
      hash = (37 * hash) + PARSING_CONFIG_OVERRIDES_FIELD_NUMBER;
      hash = (53 * hash) + internalGetParsingConfigOverrides().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A singleton resource of
   * [DataStore][google.cloud.discoveryengine.v1beta.DataStore]. It's empty when
   * [DataStore][google.cloud.discoveryengine.v1beta.DataStore] is created, which
   * defaults to digital parser. The first call to
   * [DataStoreService.UpdateDocumentProcessingConfig][] method will initialize
   * the config.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1beta.DocumentProcessingConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.DocumentProcessingConfig)
      com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfigProto
          .internal_static_google_cloud_discoveryengine_v1beta_DocumentProcessingConfig_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 5:
          return internalGetParsingConfigOverrides();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 5:
          return internalGetMutableParsingConfigOverrides();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfigProto
          .internal_static_google_cloud_discoveryengine_v1beta_DocumentProcessingConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.class,
              com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.Builder.class);
    }

    // Construct using com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getDefaultParsingConfigFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      defaultParsingConfig_ = null;
      if (defaultParsingConfigBuilder_ != null) {
        defaultParsingConfigBuilder_.dispose();
        defaultParsingConfigBuilder_ = null;
      }
      internalGetMutableParsingConfigOverrides().clear();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfigProto
          .internal_static_google_cloud_discoveryengine_v1beta_DocumentProcessingConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig
        getDefaultInstanceForType() {
      return com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig build() {
      com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig buildPartial() {
      com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig result =
          new com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.defaultParsingConfig_ =
            defaultParsingConfigBuilder_ == null
                ? defaultParsingConfig_
                : defaultParsingConfigBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.parsingConfigOverrides_ =
            internalGetParsingConfigOverrides()
                .build(ParsingConfigOverridesDefaultEntryHolder.defaultEntry);
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig) {
        return mergeFrom((com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig other) {
      if (other
          == com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasDefaultParsingConfig()) {
        mergeDefaultParsingConfig(other.getDefaultParsingConfig());
      }
      internalGetMutableParsingConfigOverrides()
          .mergeFrom(other.internalGetParsingConfigOverrides());
      bitField0_ |= 0x00000004;
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 34:
              {
                input.readMessage(
                    getDefaultParsingConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 34
            case 42:
              {
                com.google.protobuf.MapEntry<
                        java.lang.String,
                        com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig
                            .ParsingConfig>
                    parsingConfigOverrides__ =
                        input.readMessage(
                            ParsingConfigOverridesDefaultEntryHolder.defaultEntry
                                .getParserForType(),
                            extensionRegistry);
                internalGetMutableParsingConfigOverrides()
                    .ensureBuilderMap()
                    .put(parsingConfigOverrides__.getKey(), parsingConfigOverrides__.getValue());
                bitField0_ |= 0x00000004;
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The full resource name of the Document Processing Config.
     * Format:
     * `projects/&#42;&#47;locations/&#42;&#47;collections/&#42;&#47;dataStores/&#42;&#47;documentProcessingConfig`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The full resource name of the Document Processing Config.
     * Format:
     * `projects/&#42;&#47;locations/&#42;&#47;collections/&#42;&#47;dataStores/&#42;&#47;documentProcessingConfig`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The full resource name of the Document Processing Config.
     * Format:
     * `projects/&#42;&#47;locations/&#42;&#47;collections/&#42;&#47;dataStores/&#42;&#47;documentProcessingConfig`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The full resource name of the Document Processing Config.
     * Format:
     * `projects/&#42;&#47;locations/&#42;&#47;collections/&#42;&#47;dataStores/&#42;&#47;documentProcessingConfig`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The full resource name of the Document Processing Config.
     * Format:
     * `projects/&#42;&#47;locations/&#42;&#47;collections/&#42;&#47;dataStores/&#42;&#47;documentProcessingConfig`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
        defaultParsingConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig,
            com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig.Builder,
            com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfigOrBuilder>
        defaultParsingConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Configurations for default Document parser.
     * If not specified, we will configure it as default DigitalParsingConfig, and
     * the default parsing config will be applied to all file types for Document
     * parsing.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig default_parsing_config = 4;
     * </code>
     *
     * @return Whether the defaultParsingConfig field is set.
     */
    public boolean hasDefaultParsingConfig() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Configurations for default Document parser.
     * If not specified, we will configure it as default DigitalParsingConfig, and
     * the default parsing config will be applied to all file types for Document
     * parsing.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig default_parsing_config = 4;
     * </code>
     *
     * @return The defaultParsingConfig.
     */
    public com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
        getDefaultParsingConfig() {
      if (defaultParsingConfigBuilder_ == null) {
        return defaultParsingConfig_ == null
            ? com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
                .getDefaultInstance()
            : defaultParsingConfig_;
      } else {
        return defaultParsingConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Configurations for default Document parser.
     * If not specified, we will configure it as default DigitalParsingConfig, and
     * the default parsing config will be applied to all file types for Document
     * parsing.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig default_parsing_config = 4;
     * </code>
     */
    public Builder setDefaultParsingConfig(
        com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig value) {
      if (defaultParsingConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        defaultParsingConfig_ = value;
      } else {
        defaultParsingConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configurations for default Document parser.
     * If not specified, we will configure it as default DigitalParsingConfig, and
     * the default parsing config will be applied to all file types for Document
     * parsing.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig default_parsing_config = 4;
     * </code>
     */
    public Builder setDefaultParsingConfig(
        com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig.Builder
            builderForValue) {
      if (defaultParsingConfigBuilder_ == null) {
        defaultParsingConfig_ = builderForValue.build();
      } else {
        defaultParsingConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configurations for default Document parser.
     * If not specified, we will configure it as default DigitalParsingConfig, and
     * the default parsing config will be applied to all file types for Document
     * parsing.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig default_parsing_config = 4;
     * </code>
     */
    public Builder mergeDefaultParsingConfig(
        com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig value) {
      if (defaultParsingConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && defaultParsingConfig_ != null
            && defaultParsingConfig_
                != com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
                    .getDefaultInstance()) {
          getDefaultParsingConfigBuilder().mergeFrom(value);
        } else {
          defaultParsingConfig_ = value;
        }
      } else {
        defaultParsingConfigBuilder_.mergeFrom(value);
      }
      if (defaultParsingConfig_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configurations for default Document parser.
     * If not specified, we will configure it as default DigitalParsingConfig, and
     * the default parsing config will be applied to all file types for Document
     * parsing.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig default_parsing_config = 4;
     * </code>
     */
    public Builder clearDefaultParsingConfig() {
      bitField0_ = (bitField0_ & ~0x00000002);
      defaultParsingConfig_ = null;
      if (defaultParsingConfigBuilder_ != null) {
        defaultParsingConfigBuilder_.dispose();
        defaultParsingConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configurations for default Document parser.
     * If not specified, we will configure it as default DigitalParsingConfig, and
     * the default parsing config will be applied to all file types for Document
     * parsing.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig default_parsing_config = 4;
     * </code>
     */
    public com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig.Builder
        getDefaultParsingConfigBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getDefaultParsingConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configurations for default Document parser.
     * If not specified, we will configure it as default DigitalParsingConfig, and
     * the default parsing config will be applied to all file types for Document
     * parsing.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig default_parsing_config = 4;
     * </code>
     */
    public com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfigOrBuilder
        getDefaultParsingConfigOrBuilder() {
      if (defaultParsingConfigBuilder_ != null) {
        return defaultParsingConfigBuilder_.getMessageOrBuilder();
      } else {
        return defaultParsingConfig_ == null
            ? com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
                .getDefaultInstance()
            : defaultParsingConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Configurations for default Document parser.
     * If not specified, we will configure it as default DigitalParsingConfig, and
     * the default parsing config will be applied to all file types for Document
     * parsing.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig default_parsing_config = 4;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig,
            com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig.Builder,
            com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfigOrBuilder>
        getDefaultParsingConfigFieldBuilder() {
      if (defaultParsingConfigBuilder_ == null) {
        defaultParsingConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig,
                com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
                    .Builder,
                com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig
                    .ParsingConfigOrBuilder>(
                getDefaultParsingConfig(), getParentForChildren(), isClean());
        defaultParsingConfig_ = null;
      }
      return defaultParsingConfigBuilder_;
    }

    private static final class ParsingConfigOverridesConverter
        implements com.google.protobuf.MapFieldBuilder.Converter<
            java.lang.String,
            com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfigOrBuilder,
            com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig> {
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig build(
          com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfigOrBuilder
              val) {
        if (val
            instanceof
            com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig) {
          return (com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig)
              val;
        }
        return ((com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
                    .Builder)
                val)
            .build();
      }

      @java.lang.Override
      public com.google.protobuf.MapEntry<
              java.lang.String,
              com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig>
          defaultEntry() {
        return ParsingConfigOverridesDefaultEntryHolder.defaultEntry;
      }
    };

    private static final ParsingConfigOverridesConverter parsingConfigOverridesConverter =
        new ParsingConfigOverridesConverter();

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfigOrBuilder,
            com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig,
            com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig.Builder>
        parsingConfigOverrides_;

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfigOrBuilder,
            com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig,
            com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig.Builder>
        internalGetParsingConfigOverrides() {
      if (parsingConfigOverrides_ == null) {
        return new com.google.protobuf.MapFieldBuilder<>(parsingConfigOverridesConverter);
      }
      return parsingConfigOverrides_;
    }

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfigOrBuilder,
            com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig,
            com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig.Builder>
        internalGetMutableParsingConfigOverrides() {
      if (parsingConfigOverrides_ == null) {
        parsingConfigOverrides_ =
            new com.google.protobuf.MapFieldBuilder<>(parsingConfigOverridesConverter);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return parsingConfigOverrides_;
    }

    public int getParsingConfigOverridesCount() {
      return internalGetParsingConfigOverrides().ensureBuilderMap().size();
    }
    /**
     *
     *
     * <pre>
     * Map from file type to override the default parsing configuration based on
     * the file type. Supported keys:
     * * `pdf`: Override parsing config for PDF files, either digital parsing, ocr
     * parsing or layout parsing is supported.
     * * `html`: Override parsing config for HTML files, only digital parsing and
     * or layout parsing are supported.
     * * `docx`: Override parsing config for DOCX files, only digital parsing and
     * or layout parsing are supported.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig&gt; parsing_config_overrides = 5;
     * </code>
     */
    @java.lang.Override
    public boolean containsParsingConfigOverrides(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetParsingConfigOverrides().ensureBuilderMap().containsKey(key);
    }
    /** Use {@link #getParsingConfigOverridesMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<
            java.lang.String,
            com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig>
        getParsingConfigOverrides() {
      return getParsingConfigOverridesMap();
    }
    /**
     *
     *
     * <pre>
     * Map from file type to override the default parsing configuration based on
     * the file type. Supported keys:
     * * `pdf`: Override parsing config for PDF files, either digital parsing, ocr
     * parsing or layout parsing is supported.
     * * `html`: Override parsing config for HTML files, only digital parsing and
     * or layout parsing are supported.
     * * `docx`: Override parsing config for DOCX files, only digital parsing and
     * or layout parsing are supported.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig&gt; parsing_config_overrides = 5;
     * </code>
     */
    @java.lang.Override
    public java.util.Map<
            java.lang.String,
            com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig>
        getParsingConfigOverridesMap() {
      return internalGetParsingConfigOverrides().getImmutableMap();
    }
    /**
     *
     *
     * <pre>
     * Map from file type to override the default parsing configuration based on
     * the file type. Supported keys:
     * * `pdf`: Override parsing config for PDF files, either digital parsing, ocr
     * parsing or layout parsing is supported.
     * * `html`: Override parsing config for HTML files, only digital parsing and
     * or layout parsing are supported.
     * * `docx`: Override parsing config for DOCX files, only digital parsing and
     * or layout parsing are supported.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig&gt; parsing_config_overrides = 5;
     * </code>
     */
    @java.lang.Override
    public /* nullable */ com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig
            .ParsingConfig
        getParsingConfigOverridesOrDefault(
            java.lang.String key,
            /* nullable */
            com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
                defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<
              java.lang.String,
              com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig
                  .ParsingConfigOrBuilder>
          map = internalGetMutableParsingConfigOverrides().ensureBuilderMap();
      return map.containsKey(key)
          ? parsingConfigOverridesConverter.build(map.get(key))
          : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Map from file type to override the default parsing configuration based on
     * the file type. Supported keys:
     * * `pdf`: Override parsing config for PDF files, either digital parsing, ocr
     * parsing or layout parsing is supported.
     * * `html`: Override parsing config for HTML files, only digital parsing and
     * or layout parsing are supported.
     * * `docx`: Override parsing config for DOCX files, only digital parsing and
     * or layout parsing are supported.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig&gt; parsing_config_overrides = 5;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
        getParsingConfigOverridesOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<
              java.lang.String,
              com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig
                  .ParsingConfigOrBuilder>
          map = internalGetMutableParsingConfigOverrides().ensureBuilderMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return parsingConfigOverridesConverter.build(map.get(key));
    }

    public Builder clearParsingConfigOverrides() {
      bitField0_ = (bitField0_ & ~0x00000004);
      internalGetMutableParsingConfigOverrides().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Map from file type to override the default parsing configuration based on
     * the file type. Supported keys:
     * * `pdf`: Override parsing config for PDF files, either digital parsing, ocr
     * parsing or layout parsing is supported.
     * * `html`: Override parsing config for HTML files, only digital parsing and
     * or layout parsing are supported.
     * * `docx`: Override parsing config for DOCX files, only digital parsing and
     * or layout parsing are supported.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig&gt; parsing_config_overrides = 5;
     * </code>
     */
    public Builder removeParsingConfigOverrides(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableParsingConfigOverrides().ensureBuilderMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<
            java.lang.String,
            com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig>
        getMutableParsingConfigOverrides() {
      bitField0_ |= 0x00000004;
      return internalGetMutableParsingConfigOverrides().ensureMessageMap();
    }
    /**
     *
     *
     * <pre>
     * Map from file type to override the default parsing configuration based on
     * the file type. Supported keys:
     * * `pdf`: Override parsing config for PDF files, either digital parsing, ocr
     * parsing or layout parsing is supported.
     * * `html`: Override parsing config for HTML files, only digital parsing and
     * or layout parsing are supported.
     * * `docx`: Override parsing config for DOCX files, only digital parsing and
     * or layout parsing are supported.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig&gt; parsing_config_overrides = 5;
     * </code>
     */
    public Builder putParsingConfigOverrides(
        java.lang.String key,
        com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableParsingConfigOverrides().ensureBuilderMap().put(key, value);
      bitField0_ |= 0x00000004;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Map from file type to override the default parsing configuration based on
     * the file type. Supported keys:
     * * `pdf`: Override parsing config for PDF files, either digital parsing, ocr
     * parsing or layout parsing is supported.
     * * `html`: Override parsing config for HTML files, only digital parsing and
     * or layout parsing are supported.
     * * `docx`: Override parsing config for DOCX files, only digital parsing and
     * or layout parsing are supported.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig&gt; parsing_config_overrides = 5;
     * </code>
     */
    public Builder putAllParsingConfigOverrides(
        java.util.Map<
                java.lang.String,
                com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig>
            values) {
      for (java.util.Map.Entry<
              java.lang.String,
              com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig>
          e : values.entrySet()) {
        if (e.getKey() == null || e.getValue() == null) {
          throw new NullPointerException();
        }
      }
      internalGetMutableParsingConfigOverrides().ensureBuilderMap().putAll(values);
      bitField0_ |= 0x00000004;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Map from file type to override the default parsing configuration based on
     * the file type. Supported keys:
     * * `pdf`: Override parsing config for PDF files, either digital parsing, ocr
     * parsing or layout parsing is supported.
     * * `html`: Override parsing config for HTML files, only digital parsing and
     * or layout parsing are supported.
     * * `docx`: Override parsing config for DOCX files, only digital parsing and
     * or layout parsing are supported.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig&gt; parsing_config_overrides = 5;
     * </code>
     */
    public com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig.Builder
        putParsingConfigOverridesBuilderIfAbsent(java.lang.String key) {
      java.util.Map<
              java.lang.String,
              com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig
                  .ParsingConfigOrBuilder>
          builderMap = internalGetMutableParsingConfigOverrides().ensureBuilderMap();
      com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfigOrBuilder
          entry = builderMap.get(key);
      if (entry == null) {
        entry =
            com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
                .newBuilder();
        builderMap.put(key, entry);
      }
      if (entry
          instanceof
          com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig) {
        entry =
            ((com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig) entry)
                .toBuilder();
        builderMap.put(key, entry);
      }
      return (com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.ParsingConfig
              .Builder)
          entry;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.DocumentProcessingConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.DocumentProcessingConfig)
  private static final com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig();
  }

  public static com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<DocumentProcessingConfig> PARSER =
      new com.google.protobuf.AbstractParser<DocumentProcessingConfig>() {
        @java.lang.Override
        public DocumentProcessingConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<DocumentProcessingConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<DocumentProcessingConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
