/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/discoveryengine/v1beta/engine.proto

// Protobuf Java Version: 3.25.3
package com.google.cloud.discoveryengine.v1beta;

/**
 *
 *
 * <pre>
 * Metadata that describes the training and serving parameters of an
 * [Engine][google.cloud.discoveryengine.v1beta.Engine].
 * </pre>
 *
 * Protobuf type {@code google.cloud.discoveryengine.v1beta.Engine}
 */
public final class Engine extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.Engine)
    EngineOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Engine.newBuilder() to construct.
  private Engine(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Engine() {
    name_ = "";
    displayName_ = "";
    dataStoreIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
    solutionType_ = 0;
    industryVertical_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Engine();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.discoveryengine.v1beta.EngineProto
        .internal_static_google_cloud_discoveryengine_v1beta_Engine_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.discoveryengine.v1beta.EngineProto
        .internal_static_google_cloud_discoveryengine_v1beta_Engine_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.discoveryengine.v1beta.Engine.class,
            com.google.cloud.discoveryengine.v1beta.Engine.Builder.class);
  }

  public interface SearchEngineConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1beta.Engine.SearchEngineConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The search feature tier of this engine.
     *
     * Different tiers might have different
     * pricing. To learn more, check the pricing documentation.
     *
     * Defaults to
     * [SearchTier.SEARCH_TIER_STANDARD][google.cloud.discoveryengine.v1beta.SearchTier.SEARCH_TIER_STANDARD]
     * if not specified.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.SearchTier search_tier = 1;</code>
     *
     * @return The enum numeric value on the wire for searchTier.
     */
    int getSearchTierValue();
    /**
     *
     *
     * <pre>
     * The search feature tier of this engine.
     *
     * Different tiers might have different
     * pricing. To learn more, check the pricing documentation.
     *
     * Defaults to
     * [SearchTier.SEARCH_TIER_STANDARD][google.cloud.discoveryengine.v1beta.SearchTier.SEARCH_TIER_STANDARD]
     * if not specified.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.SearchTier search_tier = 1;</code>
     *
     * @return The searchTier.
     */
    com.google.cloud.discoveryengine.v1beta.SearchTier getSearchTier();

    /**
     *
     *
     * <pre>
     * The add-on that this search engine enables.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.SearchAddOn search_add_ons = 2;</code>
     *
     * @return A list containing the searchAddOns.
     */
    java.util.List<com.google.cloud.discoveryengine.v1beta.SearchAddOn> getSearchAddOnsList();
    /**
     *
     *
     * <pre>
     * The add-on that this search engine enables.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.SearchAddOn search_add_ons = 2;</code>
     *
     * @return The count of searchAddOns.
     */
    int getSearchAddOnsCount();
    /**
     *
     *
     * <pre>
     * The add-on that this search engine enables.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.SearchAddOn search_add_ons = 2;</code>
     *
     * @param index The index of the element to return.
     * @return The searchAddOns at the given index.
     */
    com.google.cloud.discoveryengine.v1beta.SearchAddOn getSearchAddOns(int index);
    /**
     *
     *
     * <pre>
     * The add-on that this search engine enables.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.SearchAddOn search_add_ons = 2;</code>
     *
     * @return A list containing the enum numeric values on the wire for searchAddOns.
     */
    java.util.List<java.lang.Integer> getSearchAddOnsValueList();
    /**
     *
     *
     * <pre>
     * The add-on that this search engine enables.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.SearchAddOn search_add_ons = 2;</code>
     *
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of searchAddOns at the given index.
     */
    int getSearchAddOnsValue(int index);
  }
  /**
   *
   *
   * <pre>
   * Configurations for a Search Engine.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1beta.Engine.SearchEngineConfig}
   */
  public static final class SearchEngineConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.Engine.SearchEngineConfig)
      SearchEngineConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use SearchEngineConfig.newBuilder() to construct.
    private SearchEngineConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private SearchEngineConfig() {
      searchTier_ = 0;
      searchAddOns_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new SearchEngineConfig();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1beta.EngineProto
          .internal_static_google_cloud_discoveryengine_v1beta_Engine_SearchEngineConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1beta.EngineProto
          .internal_static_google_cloud_discoveryengine_v1beta_Engine_SearchEngineConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1beta.Engine.SearchEngineConfig.class,
              com.google.cloud.discoveryengine.v1beta.Engine.SearchEngineConfig.Builder.class);
    }

    public static final int SEARCH_TIER_FIELD_NUMBER = 1;
    private int searchTier_ = 0;
    /**
     *
     *
     * <pre>
     * The search feature tier of this engine.
     *
     * Different tiers might have different
     * pricing. To learn more, check the pricing documentation.
     *
     * Defaults to
     * [SearchTier.SEARCH_TIER_STANDARD][google.cloud.discoveryengine.v1beta.SearchTier.SEARCH_TIER_STANDARD]
     * if not specified.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.SearchTier search_tier = 1;</code>
     *
     * @return The enum numeric value on the wire for searchTier.
     */
    @java.lang.Override
    public int getSearchTierValue() {
      return searchTier_;
    }
    /**
     *
     *
     * <pre>
     * The search feature tier of this engine.
     *
     * Different tiers might have different
     * pricing. To learn more, check the pricing documentation.
     *
     * Defaults to
     * [SearchTier.SEARCH_TIER_STANDARD][google.cloud.discoveryengine.v1beta.SearchTier.SEARCH_TIER_STANDARD]
     * if not specified.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.SearchTier search_tier = 1;</code>
     *
     * @return The searchTier.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.SearchTier getSearchTier() {
      com.google.cloud.discoveryengine.v1beta.SearchTier result =
          com.google.cloud.discoveryengine.v1beta.SearchTier.forNumber(searchTier_);
      return result == null
          ? com.google.cloud.discoveryengine.v1beta.SearchTier.UNRECOGNIZED
          : result;
    }

    public static final int SEARCH_ADD_ONS_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private java.util.List<java.lang.Integer> searchAddOns_;

    private static final com.google.protobuf.Internal.ListAdapter.Converter<
            java.lang.Integer, com.google.cloud.discoveryengine.v1beta.SearchAddOn>
        searchAddOns_converter_ =
            new com.google.protobuf.Internal.ListAdapter.Converter<
                java.lang.Integer, com.google.cloud.discoveryengine.v1beta.SearchAddOn>() {
              public com.google.cloud.discoveryengine.v1beta.SearchAddOn convert(
                  java.lang.Integer from) {
                com.google.cloud.discoveryengine.v1beta.SearchAddOn result =
                    com.google.cloud.discoveryengine.v1beta.SearchAddOn.forNumber(from);
                return result == null
                    ? com.google.cloud.discoveryengine.v1beta.SearchAddOn.UNRECOGNIZED
                    : result;
              }
            };
    /**
     *
     *
     * <pre>
     * The add-on that this search engine enables.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.SearchAddOn search_add_ons = 2;</code>
     *
     * @return A list containing the searchAddOns.
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.discoveryengine.v1beta.SearchAddOn>
        getSearchAddOnsList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer, com.google.cloud.discoveryengine.v1beta.SearchAddOn>(
          searchAddOns_, searchAddOns_converter_);
    }
    /**
     *
     *
     * <pre>
     * The add-on that this search engine enables.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.SearchAddOn search_add_ons = 2;</code>
     *
     * @return The count of searchAddOns.
     */
    @java.lang.Override
    public int getSearchAddOnsCount() {
      return searchAddOns_.size();
    }
    /**
     *
     *
     * <pre>
     * The add-on that this search engine enables.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.SearchAddOn search_add_ons = 2;</code>
     *
     * @param index The index of the element to return.
     * @return The searchAddOns at the given index.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.SearchAddOn getSearchAddOns(int index) {
      return searchAddOns_converter_.convert(searchAddOns_.get(index));
    }
    /**
     *
     *
     * <pre>
     * The add-on that this search engine enables.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.SearchAddOn search_add_ons = 2;</code>
     *
     * @return A list containing the enum numeric values on the wire for searchAddOns.
     */
    @java.lang.Override
    public java.util.List<java.lang.Integer> getSearchAddOnsValueList() {
      return searchAddOns_;
    }
    /**
     *
     *
     * <pre>
     * The add-on that this search engine enables.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.SearchAddOn search_add_ons = 2;</code>
     *
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of searchAddOns at the given index.
     */
    @java.lang.Override
    public int getSearchAddOnsValue(int index) {
      return searchAddOns_.get(index);
    }

    private int searchAddOnsMemoizedSerializedSize;

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      getSerializedSize();
      if (searchTier_
          != com.google.cloud.discoveryengine.v1beta.SearchTier.SEARCH_TIER_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(1, searchTier_);
      }
      if (getSearchAddOnsList().size() > 0) {
        output.writeUInt32NoTag(18);
        output.writeUInt32NoTag(searchAddOnsMemoizedSerializedSize);
      }
      for (int i = 0; i < searchAddOns_.size(); i++) {
        output.writeEnumNoTag(searchAddOns_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (searchTier_
          != com.google.cloud.discoveryengine.v1beta.SearchTier.SEARCH_TIER_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, searchTier_);
      }
      {
        int dataSize = 0;
        for (int i = 0; i < searchAddOns_.size(); i++) {
          dataSize +=
              com.google.protobuf.CodedOutputStream.computeEnumSizeNoTag(searchAddOns_.get(i));
        }
        size += dataSize;
        if (!getSearchAddOnsList().isEmpty()) {
          size += 1;
          size += com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(dataSize);
        }
        searchAddOnsMemoizedSerializedSize = dataSize;
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.discoveryengine.v1beta.Engine.SearchEngineConfig)) {
        return super.equals(obj);
      }
      com.google.cloud.discoveryengine.v1beta.Engine.SearchEngineConfig other =
          (com.google.cloud.discoveryengine.v1beta.Engine.SearchEngineConfig) obj;

      if (searchTier_ != other.searchTier_) return false;
      if (!searchAddOns_.equals(other.searchAddOns_)) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + SEARCH_TIER_FIELD_NUMBER;
      hash = (53 * hash) + searchTier_;
      if (getSearchAddOnsCount() > 0) {
        hash = (37 * hash) + SEARCH_ADD_ONS_FIELD_NUMBER;
        hash = (53 * hash) + searchAddOns_.hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.discoveryengine.v1beta.Engine.SearchEngineConfig parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.Engine.SearchEngineConfig parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.Engine.SearchEngineConfig parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.Engine.SearchEngineConfig parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.Engine.SearchEngineConfig parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.Engine.SearchEngineConfig parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.Engine.SearchEngineConfig parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.Engine.SearchEngineConfig parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.Engine.SearchEngineConfig
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.Engine.SearchEngineConfig
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.Engine.SearchEngineConfig parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.Engine.SearchEngineConfig parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.discoveryengine.v1beta.Engine.SearchEngineConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Configurations for a Search Engine.
     * </pre>
     *
     * Protobuf type {@code google.cloud.discoveryengine.v1beta.Engine.SearchEngineConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.Engine.SearchEngineConfig)
        com.google.cloud.discoveryengine.v1beta.Engine.SearchEngineConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1beta.EngineProto
            .internal_static_google_cloud_discoveryengine_v1beta_Engine_SearchEngineConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1beta.EngineProto
            .internal_static_google_cloud_discoveryengine_v1beta_Engine_SearchEngineConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1beta.Engine.SearchEngineConfig.class,
                com.google.cloud.discoveryengine.v1beta.Engine.SearchEngineConfig.Builder.class);
      }

      // Construct using
      // com.google.cloud.discoveryengine.v1beta.Engine.SearchEngineConfig.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        searchTier_ = 0;
        searchAddOns_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.discoveryengine.v1beta.EngineProto
            .internal_static_google_cloud_discoveryengine_v1beta_Engine_SearchEngineConfig_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.Engine.SearchEngineConfig
          getDefaultInstanceForType() {
        return com.google.cloud.discoveryengine.v1beta.Engine.SearchEngineConfig
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.Engine.SearchEngineConfig build() {
        com.google.cloud.discoveryengine.v1beta.Engine.SearchEngineConfig result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.Engine.SearchEngineConfig buildPartial() {
        com.google.cloud.discoveryengine.v1beta.Engine.SearchEngineConfig result =
            new com.google.cloud.discoveryengine.v1beta.Engine.SearchEngineConfig(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.discoveryengine.v1beta.Engine.SearchEngineConfig result) {
        if (((bitField0_ & 0x00000002) != 0)) {
          searchAddOns_ = java.util.Collections.unmodifiableList(searchAddOns_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.searchAddOns_ = searchAddOns_;
      }

      private void buildPartial0(
          com.google.cloud.discoveryengine.v1beta.Engine.SearchEngineConfig result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.searchTier_ = searchTier_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.discoveryengine.v1beta.Engine.SearchEngineConfig) {
          return mergeFrom(
              (com.google.cloud.discoveryengine.v1beta.Engine.SearchEngineConfig) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.discoveryengine.v1beta.Engine.SearchEngineConfig other) {
        if (other
            == com.google.cloud.discoveryengine.v1beta.Engine.SearchEngineConfig
                .getDefaultInstance()) return this;
        if (other.searchTier_ != 0) {
          setSearchTierValue(other.getSearchTierValue());
        }
        if (!other.searchAddOns_.isEmpty()) {
          if (searchAddOns_.isEmpty()) {
            searchAddOns_ = other.searchAddOns_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureSearchAddOnsIsMutable();
            searchAddOns_.addAll(other.searchAddOns_);
          }
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  searchTier_ = input.readEnum();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 16:
                {
                  int tmpRaw = input.readEnum();
                  ensureSearchAddOnsIsMutable();
                  searchAddOns_.add(tmpRaw);
                  break;
                } // case 16
              case 18:
                {
                  int length = input.readRawVarint32();
                  int oldLimit = input.pushLimit(length);
                  while (input.getBytesUntilLimit() > 0) {
                    int tmpRaw = input.readEnum();
                    ensureSearchAddOnsIsMutable();
                    searchAddOns_.add(tmpRaw);
                  }
                  input.popLimit(oldLimit);
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int searchTier_ = 0;
      /**
       *
       *
       * <pre>
       * The search feature tier of this engine.
       *
       * Different tiers might have different
       * pricing. To learn more, check the pricing documentation.
       *
       * Defaults to
       * [SearchTier.SEARCH_TIER_STANDARD][google.cloud.discoveryengine.v1beta.SearchTier.SEARCH_TIER_STANDARD]
       * if not specified.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1beta.SearchTier search_tier = 1;</code>
       *
       * @return The enum numeric value on the wire for searchTier.
       */
      @java.lang.Override
      public int getSearchTierValue() {
        return searchTier_;
      }
      /**
       *
       *
       * <pre>
       * The search feature tier of this engine.
       *
       * Different tiers might have different
       * pricing. To learn more, check the pricing documentation.
       *
       * Defaults to
       * [SearchTier.SEARCH_TIER_STANDARD][google.cloud.discoveryengine.v1beta.SearchTier.SEARCH_TIER_STANDARD]
       * if not specified.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1beta.SearchTier search_tier = 1;</code>
       *
       * @param value The enum numeric value on the wire for searchTier to set.
       * @return This builder for chaining.
       */
      public Builder setSearchTierValue(int value) {
        searchTier_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The search feature tier of this engine.
       *
       * Different tiers might have different
       * pricing. To learn more, check the pricing documentation.
       *
       * Defaults to
       * [SearchTier.SEARCH_TIER_STANDARD][google.cloud.discoveryengine.v1beta.SearchTier.SEARCH_TIER_STANDARD]
       * if not specified.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1beta.SearchTier search_tier = 1;</code>
       *
       * @return The searchTier.
       */
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.SearchTier getSearchTier() {
        com.google.cloud.discoveryengine.v1beta.SearchTier result =
            com.google.cloud.discoveryengine.v1beta.SearchTier.forNumber(searchTier_);
        return result == null
            ? com.google.cloud.discoveryengine.v1beta.SearchTier.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * The search feature tier of this engine.
       *
       * Different tiers might have different
       * pricing. To learn more, check the pricing documentation.
       *
       * Defaults to
       * [SearchTier.SEARCH_TIER_STANDARD][google.cloud.discoveryengine.v1beta.SearchTier.SEARCH_TIER_STANDARD]
       * if not specified.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1beta.SearchTier search_tier = 1;</code>
       *
       * @param value The searchTier to set.
       * @return This builder for chaining.
       */
      public Builder setSearchTier(com.google.cloud.discoveryengine.v1beta.SearchTier value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        searchTier_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The search feature tier of this engine.
       *
       * Different tiers might have different
       * pricing. To learn more, check the pricing documentation.
       *
       * Defaults to
       * [SearchTier.SEARCH_TIER_STANDARD][google.cloud.discoveryengine.v1beta.SearchTier.SEARCH_TIER_STANDARD]
       * if not specified.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1beta.SearchTier search_tier = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearSearchTier() {
        bitField0_ = (bitField0_ & ~0x00000001);
        searchTier_ = 0;
        onChanged();
        return this;
      }

      private java.util.List<java.lang.Integer> searchAddOns_ = java.util.Collections.emptyList();

      private void ensureSearchAddOnsIsMutable() {
        if (!((bitField0_ & 0x00000002) != 0)) {
          searchAddOns_ = new java.util.ArrayList<java.lang.Integer>(searchAddOns_);
          bitField0_ |= 0x00000002;
        }
      }
      /**
       *
       *
       * <pre>
       * The add-on that this search engine enables.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1beta.SearchAddOn search_add_ons = 2;</code>
       *
       * @return A list containing the searchAddOns.
       */
      public java.util.List<com.google.cloud.discoveryengine.v1beta.SearchAddOn>
          getSearchAddOnsList() {
        return new com.google.protobuf.Internal.ListAdapter<
            java.lang.Integer, com.google.cloud.discoveryengine.v1beta.SearchAddOn>(
            searchAddOns_, searchAddOns_converter_);
      }
      /**
       *
       *
       * <pre>
       * The add-on that this search engine enables.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1beta.SearchAddOn search_add_ons = 2;</code>
       *
       * @return The count of searchAddOns.
       */
      public int getSearchAddOnsCount() {
        return searchAddOns_.size();
      }
      /**
       *
       *
       * <pre>
       * The add-on that this search engine enables.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1beta.SearchAddOn search_add_ons = 2;</code>
       *
       * @param index The index of the element to return.
       * @return The searchAddOns at the given index.
       */
      public com.google.cloud.discoveryengine.v1beta.SearchAddOn getSearchAddOns(int index) {
        return searchAddOns_converter_.convert(searchAddOns_.get(index));
      }
      /**
       *
       *
       * <pre>
       * The add-on that this search engine enables.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1beta.SearchAddOn search_add_ons = 2;</code>
       *
       * @param index The index to set the value at.
       * @param value The searchAddOns to set.
       * @return This builder for chaining.
       */
      public Builder setSearchAddOns(
          int index, com.google.cloud.discoveryengine.v1beta.SearchAddOn value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSearchAddOnsIsMutable();
        searchAddOns_.set(index, value.getNumber());
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The add-on that this search engine enables.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1beta.SearchAddOn search_add_ons = 2;</code>
       *
       * @param value The searchAddOns to add.
       * @return This builder for chaining.
       */
      public Builder addSearchAddOns(com.google.cloud.discoveryengine.v1beta.SearchAddOn value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSearchAddOnsIsMutable();
        searchAddOns_.add(value.getNumber());
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The add-on that this search engine enables.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1beta.SearchAddOn search_add_ons = 2;</code>
       *
       * @param values The searchAddOns to add.
       * @return This builder for chaining.
       */
      public Builder addAllSearchAddOns(
          java.lang.Iterable<? extends com.google.cloud.discoveryengine.v1beta.SearchAddOn>
              values) {
        ensureSearchAddOnsIsMutable();
        for (com.google.cloud.discoveryengine.v1beta.SearchAddOn value : values) {
          searchAddOns_.add(value.getNumber());
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The add-on that this search engine enables.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1beta.SearchAddOn search_add_ons = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearSearchAddOns() {
        searchAddOns_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The add-on that this search engine enables.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1beta.SearchAddOn search_add_ons = 2;</code>
       *
       * @return A list containing the enum numeric values on the wire for searchAddOns.
       */
      public java.util.List<java.lang.Integer> getSearchAddOnsValueList() {
        return java.util.Collections.unmodifiableList(searchAddOns_);
      }
      /**
       *
       *
       * <pre>
       * The add-on that this search engine enables.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1beta.SearchAddOn search_add_ons = 2;</code>
       *
       * @param index The index of the value to return.
       * @return The enum numeric value on the wire of searchAddOns at the given index.
       */
      public int getSearchAddOnsValue(int index) {
        return searchAddOns_.get(index);
      }
      /**
       *
       *
       * <pre>
       * The add-on that this search engine enables.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1beta.SearchAddOn search_add_ons = 2;</code>
       *
       * @param index The index to set the value at.
       * @param value The enum numeric value on the wire for searchAddOns to set.
       * @return This builder for chaining.
       */
      public Builder setSearchAddOnsValue(int index, int value) {
        ensureSearchAddOnsIsMutable();
        searchAddOns_.set(index, value);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The add-on that this search engine enables.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1beta.SearchAddOn search_add_ons = 2;</code>
       *
       * @param value The enum numeric value on the wire for searchAddOns to add.
       * @return This builder for chaining.
       */
      public Builder addSearchAddOnsValue(int value) {
        ensureSearchAddOnsIsMutable();
        searchAddOns_.add(value);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The add-on that this search engine enables.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1beta.SearchAddOn search_add_ons = 2;</code>
       *
       * @param values The enum numeric values on the wire for searchAddOns to add.
       * @return This builder for chaining.
       */
      public Builder addAllSearchAddOnsValue(java.lang.Iterable<java.lang.Integer> values) {
        ensureSearchAddOnsIsMutable();
        for (int value : values) {
          searchAddOns_.add(value);
        }
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.Engine.SearchEngineConfig)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.Engine.SearchEngineConfig)
    private static final com.google.cloud.discoveryengine.v1beta.Engine.SearchEngineConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.discoveryengine.v1beta.Engine.SearchEngineConfig();
    }

    public static com.google.cloud.discoveryengine.v1beta.Engine.SearchEngineConfig
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<SearchEngineConfig> PARSER =
        new com.google.protobuf.AbstractParser<SearchEngineConfig>() {
          @java.lang.Override
          public SearchEngineConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<SearchEngineConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<SearchEngineConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.Engine.SearchEngineConfig
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ChatEngineConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The configurationt generate the Dialogflow agent that is associated to
     * this Engine.
     *
     * Note that these configurations are one-time consumed by
     * and passed to Dialogflow service. It means they cannot be retrieved using
     * [EngineService.GetEngine][google.cloud.discoveryengine.v1beta.EngineService.GetEngine]
     * or
     * [EngineService.ListEngines][google.cloud.discoveryengine.v1beta.EngineService.ListEngines]
     * API after engine creation.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig.AgentCreationConfig agent_creation_config = 1;
     * </code>
     *
     * @return Whether the agentCreationConfig field is set.
     */
    boolean hasAgentCreationConfig();
    /**
     *
     *
     * <pre>
     * The configurationt generate the Dialogflow agent that is associated to
     * this Engine.
     *
     * Note that these configurations are one-time consumed by
     * and passed to Dialogflow service. It means they cannot be retrieved using
     * [EngineService.GetEngine][google.cloud.discoveryengine.v1beta.EngineService.GetEngine]
     * or
     * [EngineService.ListEngines][google.cloud.discoveryengine.v1beta.EngineService.ListEngines]
     * API after engine creation.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig.AgentCreationConfig agent_creation_config = 1;
     * </code>
     *
     * @return The agentCreationConfig.
     */
    com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig.AgentCreationConfig
        getAgentCreationConfig();
    /**
     *
     *
     * <pre>
     * The configurationt generate the Dialogflow agent that is associated to
     * this Engine.
     *
     * Note that these configurations are one-time consumed by
     * and passed to Dialogflow service. It means they cannot be retrieved using
     * [EngineService.GetEngine][google.cloud.discoveryengine.v1beta.EngineService.GetEngine]
     * or
     * [EngineService.ListEngines][google.cloud.discoveryengine.v1beta.EngineService.ListEngines]
     * API after engine creation.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig.AgentCreationConfig agent_creation_config = 1;
     * </code>
     */
    com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig.AgentCreationConfigOrBuilder
        getAgentCreationConfigOrBuilder();

    /**
     *
     *
     * <pre>
     * The resource name of an exist Dialogflow agent to link to this Chat
     * Engine. Customers can either provide `agent_creation_config` to create
     * agent or provide an agent name that links the agent with the Chat engine.
     *
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;`.
     *
     * Note that the `dialogflow_agent_to_link` are one-time consumed by and
     * passed to Dialogflow service. It means they cannot be retrieved using
     * [EngineService.GetEngine][google.cloud.discoveryengine.v1beta.EngineService.GetEngine]
     * or
     * [EngineService.ListEngines][google.cloud.discoveryengine.v1beta.EngineService.ListEngines]
     * API after engine creation. Use
     * [ChatEngineMetadata.dialogflow_agent][google.cloud.discoveryengine.v1beta.Engine.ChatEngineMetadata.dialogflow_agent]
     * for actual agent association after Engine is created.
     * </pre>
     *
     * <code>string dialogflow_agent_to_link = 2;</code>
     *
     * @return The dialogflowAgentToLink.
     */
    java.lang.String getDialogflowAgentToLink();
    /**
     *
     *
     * <pre>
     * The resource name of an exist Dialogflow agent to link to this Chat
     * Engine. Customers can either provide `agent_creation_config` to create
     * agent or provide an agent name that links the agent with the Chat engine.
     *
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;`.
     *
     * Note that the `dialogflow_agent_to_link` are one-time consumed by and
     * passed to Dialogflow service. It means they cannot be retrieved using
     * [EngineService.GetEngine][google.cloud.discoveryengine.v1beta.EngineService.GetEngine]
     * or
     * [EngineService.ListEngines][google.cloud.discoveryengine.v1beta.EngineService.ListEngines]
     * API after engine creation. Use
     * [ChatEngineMetadata.dialogflow_agent][google.cloud.discoveryengine.v1beta.Engine.ChatEngineMetadata.dialogflow_agent]
     * for actual agent association after Engine is created.
     * </pre>
     *
     * <code>string dialogflow_agent_to_link = 2;</code>
     *
     * @return The bytes for dialogflowAgentToLink.
     */
    com.google.protobuf.ByteString getDialogflowAgentToLinkBytes();
  }
  /**
   *
   *
   * <pre>
   * Configurations for a Chat Engine.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig}
   */
  public static final class ChatEngineConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig)
      ChatEngineConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ChatEngineConfig.newBuilder() to construct.
    private ChatEngineConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ChatEngineConfig() {
      dialogflowAgentToLink_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ChatEngineConfig();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1beta.EngineProto
          .internal_static_google_cloud_discoveryengine_v1beta_Engine_ChatEngineConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1beta.EngineProto
          .internal_static_google_cloud_discoveryengine_v1beta_Engine_ChatEngineConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig.class,
              com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig.Builder.class);
    }

    public interface AgentCreationConfigOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig.AgentCreationConfig)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Name of the company, organization or other entity that the agent
       * represents. Used for knowledge connector LLM prompt and for knowledge
       * search.
       * </pre>
       *
       * <code>string business = 1;</code>
       *
       * @return The business.
       */
      java.lang.String getBusiness();
      /**
       *
       *
       * <pre>
       * Name of the company, organization or other entity that the agent
       * represents. Used for knowledge connector LLM prompt and for knowledge
       * search.
       * </pre>
       *
       * <code>string business = 1;</code>
       *
       * @return The bytes for business.
       */
      com.google.protobuf.ByteString getBusinessBytes();

      /**
       *
       *
       * <pre>
       * Required. The default language of the agent as a language tag.
       * See [Language
       * Support](https://cloud.google.com/dialogflow/docs/reference/language)
       * for a list of the currently supported language codes.
       * </pre>
       *
       * <code>string default_language_code = 2;</code>
       *
       * @return The defaultLanguageCode.
       */
      java.lang.String getDefaultLanguageCode();
      /**
       *
       *
       * <pre>
       * Required. The default language of the agent as a language tag.
       * See [Language
       * Support](https://cloud.google.com/dialogflow/docs/reference/language)
       * for a list of the currently supported language codes.
       * </pre>
       *
       * <code>string default_language_code = 2;</code>
       *
       * @return The bytes for defaultLanguageCode.
       */
      com.google.protobuf.ByteString getDefaultLanguageCodeBytes();

      /**
       *
       *
       * <pre>
       * Required. The time zone of the agent from the [time zone
       * database](https://www.iana.org/time-zones), e.g., America/New_York,
       * Europe/Paris.
       * </pre>
       *
       * <code>string time_zone = 3 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The timeZone.
       */
      java.lang.String getTimeZone();
      /**
       *
       *
       * <pre>
       * Required. The time zone of the agent from the [time zone
       * database](https://www.iana.org/time-zones), e.g., America/New_York,
       * Europe/Paris.
       * </pre>
       *
       * <code>string time_zone = 3 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for timeZone.
       */
      com.google.protobuf.ByteString getTimeZoneBytes();

      /**
       *
       *
       * <pre>
       * Agent location for Agent creation, supported values: global/us/eu.
       * If not provided, us Engine will create Agent using us-central-1 by
       * default; eu Engine will create Agent using eu-west-1 by default.
       * </pre>
       *
       * <code>string location = 4;</code>
       *
       * @return The location.
       */
      java.lang.String getLocation();
      /**
       *
       *
       * <pre>
       * Agent location for Agent creation, supported values: global/us/eu.
       * If not provided, us Engine will create Agent using us-central-1 by
       * default; eu Engine will create Agent using eu-west-1 by default.
       * </pre>
       *
       * <code>string location = 4;</code>
       *
       * @return The bytes for location.
       */
      com.google.protobuf.ByteString getLocationBytes();
    }
    /**
     *
     *
     * <pre>
     * Configurations for generating a Dialogflow agent.
     *
     * Note that these configurations are one-time consumed by
     * and passed to Dialogflow service. It means they cannot be retrieved using
     * [EngineService.GetEngine][google.cloud.discoveryengine.v1beta.EngineService.GetEngine]
     * or
     * [EngineService.ListEngines][google.cloud.discoveryengine.v1beta.EngineService.ListEngines]
     * API after engine creation.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig.AgentCreationConfig}
     */
    public static final class AgentCreationConfig extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig.AgentCreationConfig)
        AgentCreationConfigOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use AgentCreationConfig.newBuilder() to construct.
      private AgentCreationConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private AgentCreationConfig() {
        business_ = "";
        defaultLanguageCode_ = "";
        timeZone_ = "";
        location_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new AgentCreationConfig();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1beta.EngineProto
            .internal_static_google_cloud_discoveryengine_v1beta_Engine_ChatEngineConfig_AgentCreationConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1beta.EngineProto
            .internal_static_google_cloud_discoveryengine_v1beta_Engine_ChatEngineConfig_AgentCreationConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig.AgentCreationConfig
                    .class,
                com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig.AgentCreationConfig
                    .Builder.class);
      }

      public static final int BUSINESS_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private volatile java.lang.Object business_ = "";
      /**
       *
       *
       * <pre>
       * Name of the company, organization or other entity that the agent
       * represents. Used for knowledge connector LLM prompt and for knowledge
       * search.
       * </pre>
       *
       * <code>string business = 1;</code>
       *
       * @return The business.
       */
      @java.lang.Override
      public java.lang.String getBusiness() {
        java.lang.Object ref = business_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          business_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Name of the company, organization or other entity that the agent
       * represents. Used for knowledge connector LLM prompt and for knowledge
       * search.
       * </pre>
       *
       * <code>string business = 1;</code>
       *
       * @return The bytes for business.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getBusinessBytes() {
        java.lang.Object ref = business_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          business_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int DEFAULT_LANGUAGE_CODE_FIELD_NUMBER = 2;

      @SuppressWarnings("serial")
      private volatile java.lang.Object defaultLanguageCode_ = "";
      /**
       *
       *
       * <pre>
       * Required. The default language of the agent as a language tag.
       * See [Language
       * Support](https://cloud.google.com/dialogflow/docs/reference/language)
       * for a list of the currently supported language codes.
       * </pre>
       *
       * <code>string default_language_code = 2;</code>
       *
       * @return The defaultLanguageCode.
       */
      @java.lang.Override
      public java.lang.String getDefaultLanguageCode() {
        java.lang.Object ref = defaultLanguageCode_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          defaultLanguageCode_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The default language of the agent as a language tag.
       * See [Language
       * Support](https://cloud.google.com/dialogflow/docs/reference/language)
       * for a list of the currently supported language codes.
       * </pre>
       *
       * <code>string default_language_code = 2;</code>
       *
       * @return The bytes for defaultLanguageCode.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getDefaultLanguageCodeBytes() {
        java.lang.Object ref = defaultLanguageCode_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          defaultLanguageCode_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int TIME_ZONE_FIELD_NUMBER = 3;

      @SuppressWarnings("serial")
      private volatile java.lang.Object timeZone_ = "";
      /**
       *
       *
       * <pre>
       * Required. The time zone of the agent from the [time zone
       * database](https://www.iana.org/time-zones), e.g., America/New_York,
       * Europe/Paris.
       * </pre>
       *
       * <code>string time_zone = 3 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The timeZone.
       */
      @java.lang.Override
      public java.lang.String getTimeZone() {
        java.lang.Object ref = timeZone_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          timeZone_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The time zone of the agent from the [time zone
       * database](https://www.iana.org/time-zones), e.g., America/New_York,
       * Europe/Paris.
       * </pre>
       *
       * <code>string time_zone = 3 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for timeZone.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getTimeZoneBytes() {
        java.lang.Object ref = timeZone_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          timeZone_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int LOCATION_FIELD_NUMBER = 4;

      @SuppressWarnings("serial")
      private volatile java.lang.Object location_ = "";
      /**
       *
       *
       * <pre>
       * Agent location for Agent creation, supported values: global/us/eu.
       * If not provided, us Engine will create Agent using us-central-1 by
       * default; eu Engine will create Agent using eu-west-1 by default.
       * </pre>
       *
       * <code>string location = 4;</code>
       *
       * @return The location.
       */
      @java.lang.Override
      public java.lang.String getLocation() {
        java.lang.Object ref = location_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          location_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Agent location for Agent creation, supported values: global/us/eu.
       * If not provided, us Engine will create Agent using us-central-1 by
       * default; eu Engine will create Agent using eu-west-1 by default.
       * </pre>
       *
       * <code>string location = 4;</code>
       *
       * @return The bytes for location.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getLocationBytes() {
        java.lang.Object ref = location_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          location_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(business_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, business_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(defaultLanguageCode_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 2, defaultLanguageCode_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(timeZone_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 3, timeZone_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(location_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 4, location_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(business_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, business_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(defaultLanguageCode_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, defaultLanguageCode_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(timeZone_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, timeZone_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(location_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, location_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig.AgentCreationConfig)) {
          return super.equals(obj);
        }
        com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig.AgentCreationConfig other =
            (com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig.AgentCreationConfig)
                obj;

        if (!getBusiness().equals(other.getBusiness())) return false;
        if (!getDefaultLanguageCode().equals(other.getDefaultLanguageCode())) return false;
        if (!getTimeZone().equals(other.getTimeZone())) return false;
        if (!getLocation().equals(other.getLocation())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + BUSINESS_FIELD_NUMBER;
        hash = (53 * hash) + getBusiness().hashCode();
        hash = (37 * hash) + DEFAULT_LANGUAGE_CODE_FIELD_NUMBER;
        hash = (53 * hash) + getDefaultLanguageCode().hashCode();
        hash = (37 * hash) + TIME_ZONE_FIELD_NUMBER;
        hash = (53 * hash) + getTimeZone().hashCode();
        hash = (37 * hash) + LOCATION_FIELD_NUMBER;
        hash = (53 * hash) + getLocation().hashCode();
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig
              .AgentCreationConfig
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig
              .AgentCreationConfig
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig
              .AgentCreationConfig
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig
              .AgentCreationConfig
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig
              .AgentCreationConfig
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig
              .AgentCreationConfig
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig
              .AgentCreationConfig
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig
              .AgentCreationConfig
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig
              .AgentCreationConfig
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig
              .AgentCreationConfig
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig
              .AgentCreationConfig
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig
              .AgentCreationConfig
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig.AgentCreationConfig
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Configurations for generating a Dialogflow agent.
       *
       * Note that these configurations are one-time consumed by
       * and passed to Dialogflow service. It means they cannot be retrieved using
       * [EngineService.GetEngine][google.cloud.discoveryengine.v1beta.EngineService.GetEngine]
       * or
       * [EngineService.ListEngines][google.cloud.discoveryengine.v1beta.EngineService.ListEngines]
       * API after engine creation.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig.AgentCreationConfig}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig.AgentCreationConfig)
          com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig
              .AgentCreationConfigOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.discoveryengine.v1beta.EngineProto
              .internal_static_google_cloud_discoveryengine_v1beta_Engine_ChatEngineConfig_AgentCreationConfig_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.discoveryengine.v1beta.EngineProto
              .internal_static_google_cloud_discoveryengine_v1beta_Engine_ChatEngineConfig_AgentCreationConfig_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig
                      .AgentCreationConfig.class,
                  com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig
                      .AgentCreationConfig.Builder.class);
        }

        // Construct using
        // com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig.AgentCreationConfig.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          business_ = "";
          defaultLanguageCode_ = "";
          timeZone_ = "";
          location_ = "";
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.discoveryengine.v1beta.EngineProto
              .internal_static_google_cloud_discoveryengine_v1beta_Engine_ChatEngineConfig_AgentCreationConfig_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig.AgentCreationConfig
            getDefaultInstanceForType() {
          return com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig.AgentCreationConfig
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig.AgentCreationConfig
            build() {
          com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig.AgentCreationConfig
              result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig.AgentCreationConfig
            buildPartial() {
          com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig.AgentCreationConfig
              result =
                  new com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig
                      .AgentCreationConfig(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig.AgentCreationConfig
                result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.business_ = business_;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.defaultLanguageCode_ = defaultLanguageCode_;
          }
          if (((from_bitField0_ & 0x00000004) != 0)) {
            result.timeZone_ = timeZone_;
          }
          if (((from_bitField0_ & 0x00000008) != 0)) {
            result.location_ = location_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig.AgentCreationConfig) {
            return mergeFrom(
                (com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig
                        .AgentCreationConfig)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig.AgentCreationConfig
                other) {
          if (other
              == com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig.AgentCreationConfig
                  .getDefaultInstance()) return this;
          if (!other.getBusiness().isEmpty()) {
            business_ = other.business_;
            bitField0_ |= 0x00000001;
            onChanged();
          }
          if (!other.getDefaultLanguageCode().isEmpty()) {
            defaultLanguageCode_ = other.defaultLanguageCode_;
            bitField0_ |= 0x00000002;
            onChanged();
          }
          if (!other.getTimeZone().isEmpty()) {
            timeZone_ = other.timeZone_;
            bitField0_ |= 0x00000004;
            onChanged();
          }
          if (!other.getLocation().isEmpty()) {
            location_ = other.location_;
            bitField0_ |= 0x00000008;
            onChanged();
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    business_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                case 18:
                  {
                    defaultLanguageCode_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 18
                case 26:
                  {
                    timeZone_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000004;
                    break;
                  } // case 26
                case 34:
                  {
                    location_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000008;
                    break;
                  } // case 34
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.lang.Object business_ = "";
        /**
         *
         *
         * <pre>
         * Name of the company, organization or other entity that the agent
         * represents. Used for knowledge connector LLM prompt and for knowledge
         * search.
         * </pre>
         *
         * <code>string business = 1;</code>
         *
         * @return The business.
         */
        public java.lang.String getBusiness() {
          java.lang.Object ref = business_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            business_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Name of the company, organization or other entity that the agent
         * represents. Used for knowledge connector LLM prompt and for knowledge
         * search.
         * </pre>
         *
         * <code>string business = 1;</code>
         *
         * @return The bytes for business.
         */
        public com.google.protobuf.ByteString getBusinessBytes() {
          java.lang.Object ref = business_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            business_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Name of the company, organization or other entity that the agent
         * represents. Used for knowledge connector LLM prompt and for knowledge
         * search.
         * </pre>
         *
         * <code>string business = 1;</code>
         *
         * @param value The business to set.
         * @return This builder for chaining.
         */
        public Builder setBusiness(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          business_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Name of the company, organization or other entity that the agent
         * represents. Used for knowledge connector LLM prompt and for knowledge
         * search.
         * </pre>
         *
         * <code>string business = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearBusiness() {
          business_ = getDefaultInstance().getBusiness();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Name of the company, organization or other entity that the agent
         * represents. Used for knowledge connector LLM prompt and for knowledge
         * search.
         * </pre>
         *
         * <code>string business = 1;</code>
         *
         * @param value The bytes for business to set.
         * @return This builder for chaining.
         */
        public Builder setBusinessBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          business_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        private java.lang.Object defaultLanguageCode_ = "";
        /**
         *
         *
         * <pre>
         * Required. The default language of the agent as a language tag.
         * See [Language
         * Support](https://cloud.google.com/dialogflow/docs/reference/language)
         * for a list of the currently supported language codes.
         * </pre>
         *
         * <code>string default_language_code = 2;</code>
         *
         * @return The defaultLanguageCode.
         */
        public java.lang.String getDefaultLanguageCode() {
          java.lang.Object ref = defaultLanguageCode_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            defaultLanguageCode_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. The default language of the agent as a language tag.
         * See [Language
         * Support](https://cloud.google.com/dialogflow/docs/reference/language)
         * for a list of the currently supported language codes.
         * </pre>
         *
         * <code>string default_language_code = 2;</code>
         *
         * @return The bytes for defaultLanguageCode.
         */
        public com.google.protobuf.ByteString getDefaultLanguageCodeBytes() {
          java.lang.Object ref = defaultLanguageCode_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            defaultLanguageCode_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. The default language of the agent as a language tag.
         * See [Language
         * Support](https://cloud.google.com/dialogflow/docs/reference/language)
         * for a list of the currently supported language codes.
         * </pre>
         *
         * <code>string default_language_code = 2;</code>
         *
         * @param value The defaultLanguageCode to set.
         * @return This builder for chaining.
         */
        public Builder setDefaultLanguageCode(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          defaultLanguageCode_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The default language of the agent as a language tag.
         * See [Language
         * Support](https://cloud.google.com/dialogflow/docs/reference/language)
         * for a list of the currently supported language codes.
         * </pre>
         *
         * <code>string default_language_code = 2;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearDefaultLanguageCode() {
          defaultLanguageCode_ = getDefaultInstance().getDefaultLanguageCode();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The default language of the agent as a language tag.
         * See [Language
         * Support](https://cloud.google.com/dialogflow/docs/reference/language)
         * for a list of the currently supported language codes.
         * </pre>
         *
         * <code>string default_language_code = 2;</code>
         *
         * @param value The bytes for defaultLanguageCode to set.
         * @return This builder for chaining.
         */
        public Builder setDefaultLanguageCodeBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          defaultLanguageCode_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }

        private java.lang.Object timeZone_ = "";
        /**
         *
         *
         * <pre>
         * Required. The time zone of the agent from the [time zone
         * database](https://www.iana.org/time-zones), e.g., America/New_York,
         * Europe/Paris.
         * </pre>
         *
         * <code>string time_zone = 3 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The timeZone.
         */
        public java.lang.String getTimeZone() {
          java.lang.Object ref = timeZone_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            timeZone_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. The time zone of the agent from the [time zone
         * database](https://www.iana.org/time-zones), e.g., America/New_York,
         * Europe/Paris.
         * </pre>
         *
         * <code>string time_zone = 3 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The bytes for timeZone.
         */
        public com.google.protobuf.ByteString getTimeZoneBytes() {
          java.lang.Object ref = timeZone_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            timeZone_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. The time zone of the agent from the [time zone
         * database](https://www.iana.org/time-zones), e.g., America/New_York,
         * Europe/Paris.
         * </pre>
         *
         * <code>string time_zone = 3 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param value The timeZone to set.
         * @return This builder for chaining.
         */
        public Builder setTimeZone(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          timeZone_ = value;
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The time zone of the agent from the [time zone
         * database](https://www.iana.org/time-zones), e.g., America/New_York,
         * Europe/Paris.
         * </pre>
         *
         * <code>string time_zone = 3 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearTimeZone() {
          timeZone_ = getDefaultInstance().getTimeZone();
          bitField0_ = (bitField0_ & ~0x00000004);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The time zone of the agent from the [time zone
         * database](https://www.iana.org/time-zones), e.g., America/New_York,
         * Europe/Paris.
         * </pre>
         *
         * <code>string time_zone = 3 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param value The bytes for timeZone to set.
         * @return This builder for chaining.
         */
        public Builder setTimeZoneBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          timeZone_ = value;
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }

        private java.lang.Object location_ = "";
        /**
         *
         *
         * <pre>
         * Agent location for Agent creation, supported values: global/us/eu.
         * If not provided, us Engine will create Agent using us-central-1 by
         * default; eu Engine will create Agent using eu-west-1 by default.
         * </pre>
         *
         * <code>string location = 4;</code>
         *
         * @return The location.
         */
        public java.lang.String getLocation() {
          java.lang.Object ref = location_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            location_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Agent location for Agent creation, supported values: global/us/eu.
         * If not provided, us Engine will create Agent using us-central-1 by
         * default; eu Engine will create Agent using eu-west-1 by default.
         * </pre>
         *
         * <code>string location = 4;</code>
         *
         * @return The bytes for location.
         */
        public com.google.protobuf.ByteString getLocationBytes() {
          java.lang.Object ref = location_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            location_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Agent location for Agent creation, supported values: global/us/eu.
         * If not provided, us Engine will create Agent using us-central-1 by
         * default; eu Engine will create Agent using eu-west-1 by default.
         * </pre>
         *
         * <code>string location = 4;</code>
         *
         * @param value The location to set.
         * @return This builder for chaining.
         */
        public Builder setLocation(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          location_ = value;
          bitField0_ |= 0x00000008;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Agent location for Agent creation, supported values: global/us/eu.
         * If not provided, us Engine will create Agent using us-central-1 by
         * default; eu Engine will create Agent using eu-west-1 by default.
         * </pre>
         *
         * <code>string location = 4;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearLocation() {
          location_ = getDefaultInstance().getLocation();
          bitField0_ = (bitField0_ & ~0x00000008);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Agent location for Agent creation, supported values: global/us/eu.
         * If not provided, us Engine will create Agent using us-central-1 by
         * default; eu Engine will create Agent using eu-west-1 by default.
         * </pre>
         *
         * <code>string location = 4;</code>
         *
         * @param value The bytes for location to set.
         * @return This builder for chaining.
         */
        public Builder setLocationBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          location_ = value;
          bitField0_ |= 0x00000008;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig.AgentCreationConfig)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig.AgentCreationConfig)
      private static final com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig
              .AgentCreationConfig
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig
                .AgentCreationConfig();
      }

      public static com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig
              .AgentCreationConfig
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<AgentCreationConfig> PARSER =
          new com.google.protobuf.AbstractParser<AgentCreationConfig>() {
            @java.lang.Override
            public AgentCreationConfig parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<AgentCreationConfig> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<AgentCreationConfig> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig.AgentCreationConfig
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    private int bitField0_;
    public static final int AGENT_CREATION_CONFIG_FIELD_NUMBER = 1;
    private com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig.AgentCreationConfig
        agentCreationConfig_;
    /**
     *
     *
     * <pre>
     * The configurationt generate the Dialogflow agent that is associated to
     * this Engine.
     *
     * Note that these configurations are one-time consumed by
     * and passed to Dialogflow service. It means they cannot be retrieved using
     * [EngineService.GetEngine][google.cloud.discoveryengine.v1beta.EngineService.GetEngine]
     * or
     * [EngineService.ListEngines][google.cloud.discoveryengine.v1beta.EngineService.ListEngines]
     * API after engine creation.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig.AgentCreationConfig agent_creation_config = 1;
     * </code>
     *
     * @return Whether the agentCreationConfig field is set.
     */
    @java.lang.Override
    public boolean hasAgentCreationConfig() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * The configurationt generate the Dialogflow agent that is associated to
     * this Engine.
     *
     * Note that these configurations are one-time consumed by
     * and passed to Dialogflow service. It means they cannot be retrieved using
     * [EngineService.GetEngine][google.cloud.discoveryengine.v1beta.EngineService.GetEngine]
     * or
     * [EngineService.ListEngines][google.cloud.discoveryengine.v1beta.EngineService.ListEngines]
     * API after engine creation.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig.AgentCreationConfig agent_creation_config = 1;
     * </code>
     *
     * @return The agentCreationConfig.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig.AgentCreationConfig
        getAgentCreationConfig() {
      return agentCreationConfig_ == null
          ? com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig.AgentCreationConfig
              .getDefaultInstance()
          : agentCreationConfig_;
    }
    /**
     *
     *
     * <pre>
     * The configurationt generate the Dialogflow agent that is associated to
     * this Engine.
     *
     * Note that these configurations are one-time consumed by
     * and passed to Dialogflow service. It means they cannot be retrieved using
     * [EngineService.GetEngine][google.cloud.discoveryengine.v1beta.EngineService.GetEngine]
     * or
     * [EngineService.ListEngines][google.cloud.discoveryengine.v1beta.EngineService.ListEngines]
     * API after engine creation.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig.AgentCreationConfig agent_creation_config = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig
            .AgentCreationConfigOrBuilder
        getAgentCreationConfigOrBuilder() {
      return agentCreationConfig_ == null
          ? com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig.AgentCreationConfig
              .getDefaultInstance()
          : agentCreationConfig_;
    }

    public static final int DIALOGFLOW_AGENT_TO_LINK_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object dialogflowAgentToLink_ = "";
    /**
     *
     *
     * <pre>
     * The resource name of an exist Dialogflow agent to link to this Chat
     * Engine. Customers can either provide `agent_creation_config` to create
     * agent or provide an agent name that links the agent with the Chat engine.
     *
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;`.
     *
     * Note that the `dialogflow_agent_to_link` are one-time consumed by and
     * passed to Dialogflow service. It means they cannot be retrieved using
     * [EngineService.GetEngine][google.cloud.discoveryengine.v1beta.EngineService.GetEngine]
     * or
     * [EngineService.ListEngines][google.cloud.discoveryengine.v1beta.EngineService.ListEngines]
     * API after engine creation. Use
     * [ChatEngineMetadata.dialogflow_agent][google.cloud.discoveryengine.v1beta.Engine.ChatEngineMetadata.dialogflow_agent]
     * for actual agent association after Engine is created.
     * </pre>
     *
     * <code>string dialogflow_agent_to_link = 2;</code>
     *
     * @return The dialogflowAgentToLink.
     */
    @java.lang.Override
    public java.lang.String getDialogflowAgentToLink() {
      java.lang.Object ref = dialogflowAgentToLink_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        dialogflowAgentToLink_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of an exist Dialogflow agent to link to this Chat
     * Engine. Customers can either provide `agent_creation_config` to create
     * agent or provide an agent name that links the agent with the Chat engine.
     *
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;`.
     *
     * Note that the `dialogflow_agent_to_link` are one-time consumed by and
     * passed to Dialogflow service. It means they cannot be retrieved using
     * [EngineService.GetEngine][google.cloud.discoveryengine.v1beta.EngineService.GetEngine]
     * or
     * [EngineService.ListEngines][google.cloud.discoveryengine.v1beta.EngineService.ListEngines]
     * API after engine creation. Use
     * [ChatEngineMetadata.dialogflow_agent][google.cloud.discoveryengine.v1beta.Engine.ChatEngineMetadata.dialogflow_agent]
     * for actual agent association after Engine is created.
     * </pre>
     *
     * <code>string dialogflow_agent_to_link = 2;</code>
     *
     * @return The bytes for dialogflowAgentToLink.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getDialogflowAgentToLinkBytes() {
      java.lang.Object ref = dialogflowAgentToLink_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        dialogflowAgentToLink_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getAgentCreationConfig());
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dialogflowAgentToLink_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, dialogflowAgentToLink_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(1, getAgentCreationConfig());
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dialogflowAgentToLink_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, dialogflowAgentToLink_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig)) {
        return super.equals(obj);
      }
      com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig other =
          (com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig) obj;

      if (hasAgentCreationConfig() != other.hasAgentCreationConfig()) return false;
      if (hasAgentCreationConfig()) {
        if (!getAgentCreationConfig().equals(other.getAgentCreationConfig())) return false;
      }
      if (!getDialogflowAgentToLink().equals(other.getDialogflowAgentToLink())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasAgentCreationConfig()) {
        hash = (37 * hash) + AGENT_CREATION_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getAgentCreationConfig().hashCode();
      }
      hash = (37 * hash) + DIALOGFLOW_AGENT_TO_LINK_FIELD_NUMBER;
      hash = (53 * hash) + getDialogflowAgentToLink().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Configurations for a Chat Engine.
     * </pre>
     *
     * Protobuf type {@code google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig)
        com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1beta.EngineProto
            .internal_static_google_cloud_discoveryengine_v1beta_Engine_ChatEngineConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1beta.EngineProto
            .internal_static_google_cloud_discoveryengine_v1beta_Engine_ChatEngineConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig.class,
                com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig.Builder.class);
      }

      // Construct using
      // com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getAgentCreationConfigFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        agentCreationConfig_ = null;
        if (agentCreationConfigBuilder_ != null) {
          agentCreationConfigBuilder_.dispose();
          agentCreationConfigBuilder_ = null;
        }
        dialogflowAgentToLink_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.discoveryengine.v1beta.EngineProto
            .internal_static_google_cloud_discoveryengine_v1beta_Engine_ChatEngineConfig_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig
          getDefaultInstanceForType() {
        return com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig build() {
        com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig buildPartial() {
        com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig result =
            new com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.agentCreationConfig_ =
              agentCreationConfigBuilder_ == null
                  ? agentCreationConfig_
                  : agentCreationConfigBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.dialogflowAgentToLink_ = dialogflowAgentToLink_;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig) {
          return mergeFrom((com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig other) {
        if (other
            == com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig.getDefaultInstance())
          return this;
        if (other.hasAgentCreationConfig()) {
          mergeAgentCreationConfig(other.getAgentCreationConfig());
        }
        if (!other.getDialogflowAgentToLink().isEmpty()) {
          dialogflowAgentToLink_ = other.dialogflowAgentToLink_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(
                      getAgentCreationConfigFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  dialogflowAgentToLink_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig.AgentCreationConfig
          agentCreationConfig_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig.AgentCreationConfig,
              com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig.AgentCreationConfig
                  .Builder,
              com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig
                  .AgentCreationConfigOrBuilder>
          agentCreationConfigBuilder_;
      /**
       *
       *
       * <pre>
       * The configurationt generate the Dialogflow agent that is associated to
       * this Engine.
       *
       * Note that these configurations are one-time consumed by
       * and passed to Dialogflow service. It means they cannot be retrieved using
       * [EngineService.GetEngine][google.cloud.discoveryengine.v1beta.EngineService.GetEngine]
       * or
       * [EngineService.ListEngines][google.cloud.discoveryengine.v1beta.EngineService.ListEngines]
       * API after engine creation.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig.AgentCreationConfig agent_creation_config = 1;
       * </code>
       *
       * @return Whether the agentCreationConfig field is set.
       */
      public boolean hasAgentCreationConfig() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * The configurationt generate the Dialogflow agent that is associated to
       * this Engine.
       *
       * Note that these configurations are one-time consumed by
       * and passed to Dialogflow service. It means they cannot be retrieved using
       * [EngineService.GetEngine][google.cloud.discoveryengine.v1beta.EngineService.GetEngine]
       * or
       * [EngineService.ListEngines][google.cloud.discoveryengine.v1beta.EngineService.ListEngines]
       * API after engine creation.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig.AgentCreationConfig agent_creation_config = 1;
       * </code>
       *
       * @return The agentCreationConfig.
       */
      public com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig.AgentCreationConfig
          getAgentCreationConfig() {
        if (agentCreationConfigBuilder_ == null) {
          return agentCreationConfig_ == null
              ? com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig.AgentCreationConfig
                  .getDefaultInstance()
              : agentCreationConfig_;
        } else {
          return agentCreationConfigBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The configurationt generate the Dialogflow agent that is associated to
       * this Engine.
       *
       * Note that these configurations are one-time consumed by
       * and passed to Dialogflow service. It means they cannot be retrieved using
       * [EngineService.GetEngine][google.cloud.discoveryengine.v1beta.EngineService.GetEngine]
       * or
       * [EngineService.ListEngines][google.cloud.discoveryengine.v1beta.EngineService.ListEngines]
       * API after engine creation.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig.AgentCreationConfig agent_creation_config = 1;
       * </code>
       */
      public Builder setAgentCreationConfig(
          com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig.AgentCreationConfig
              value) {
        if (agentCreationConfigBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          agentCreationConfig_ = value;
        } else {
          agentCreationConfigBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The configurationt generate the Dialogflow agent that is associated to
       * this Engine.
       *
       * Note that these configurations are one-time consumed by
       * and passed to Dialogflow service. It means they cannot be retrieved using
       * [EngineService.GetEngine][google.cloud.discoveryengine.v1beta.EngineService.GetEngine]
       * or
       * [EngineService.ListEngines][google.cloud.discoveryengine.v1beta.EngineService.ListEngines]
       * API after engine creation.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig.AgentCreationConfig agent_creation_config = 1;
       * </code>
       */
      public Builder setAgentCreationConfig(
          com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig.AgentCreationConfig
                  .Builder
              builderForValue) {
        if (agentCreationConfigBuilder_ == null) {
          agentCreationConfig_ = builderForValue.build();
        } else {
          agentCreationConfigBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The configurationt generate the Dialogflow agent that is associated to
       * this Engine.
       *
       * Note that these configurations are one-time consumed by
       * and passed to Dialogflow service. It means they cannot be retrieved using
       * [EngineService.GetEngine][google.cloud.discoveryengine.v1beta.EngineService.GetEngine]
       * or
       * [EngineService.ListEngines][google.cloud.discoveryengine.v1beta.EngineService.ListEngines]
       * API after engine creation.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig.AgentCreationConfig agent_creation_config = 1;
       * </code>
       */
      public Builder mergeAgentCreationConfig(
          com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig.AgentCreationConfig
              value) {
        if (agentCreationConfigBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && agentCreationConfig_ != null
              && agentCreationConfig_
                  != com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig
                      .AgentCreationConfig.getDefaultInstance()) {
            getAgentCreationConfigBuilder().mergeFrom(value);
          } else {
            agentCreationConfig_ = value;
          }
        } else {
          agentCreationConfigBuilder_.mergeFrom(value);
        }
        if (agentCreationConfig_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The configurationt generate the Dialogflow agent that is associated to
       * this Engine.
       *
       * Note that these configurations are one-time consumed by
       * and passed to Dialogflow service. It means they cannot be retrieved using
       * [EngineService.GetEngine][google.cloud.discoveryengine.v1beta.EngineService.GetEngine]
       * or
       * [EngineService.ListEngines][google.cloud.discoveryengine.v1beta.EngineService.ListEngines]
       * API after engine creation.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig.AgentCreationConfig agent_creation_config = 1;
       * </code>
       */
      public Builder clearAgentCreationConfig() {
        bitField0_ = (bitField0_ & ~0x00000001);
        agentCreationConfig_ = null;
        if (agentCreationConfigBuilder_ != null) {
          agentCreationConfigBuilder_.dispose();
          agentCreationConfigBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The configurationt generate the Dialogflow agent that is associated to
       * this Engine.
       *
       * Note that these configurations are one-time consumed by
       * and passed to Dialogflow service. It means they cannot be retrieved using
       * [EngineService.GetEngine][google.cloud.discoveryengine.v1beta.EngineService.GetEngine]
       * or
       * [EngineService.ListEngines][google.cloud.discoveryengine.v1beta.EngineService.ListEngines]
       * API after engine creation.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig.AgentCreationConfig agent_creation_config = 1;
       * </code>
       */
      public com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig.AgentCreationConfig
              .Builder
          getAgentCreationConfigBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getAgentCreationConfigFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The configurationt generate the Dialogflow agent that is associated to
       * this Engine.
       *
       * Note that these configurations are one-time consumed by
       * and passed to Dialogflow service. It means they cannot be retrieved using
       * [EngineService.GetEngine][google.cloud.discoveryengine.v1beta.EngineService.GetEngine]
       * or
       * [EngineService.ListEngines][google.cloud.discoveryengine.v1beta.EngineService.ListEngines]
       * API after engine creation.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig.AgentCreationConfig agent_creation_config = 1;
       * </code>
       */
      public com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig
              .AgentCreationConfigOrBuilder
          getAgentCreationConfigOrBuilder() {
        if (agentCreationConfigBuilder_ != null) {
          return agentCreationConfigBuilder_.getMessageOrBuilder();
        } else {
          return agentCreationConfig_ == null
              ? com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig.AgentCreationConfig
                  .getDefaultInstance()
              : agentCreationConfig_;
        }
      }
      /**
       *
       *
       * <pre>
       * The configurationt generate the Dialogflow agent that is associated to
       * this Engine.
       *
       * Note that these configurations are one-time consumed by
       * and passed to Dialogflow service. It means they cannot be retrieved using
       * [EngineService.GetEngine][google.cloud.discoveryengine.v1beta.EngineService.GetEngine]
       * or
       * [EngineService.ListEngines][google.cloud.discoveryengine.v1beta.EngineService.ListEngines]
       * API after engine creation.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig.AgentCreationConfig agent_creation_config = 1;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig.AgentCreationConfig,
              com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig.AgentCreationConfig
                  .Builder,
              com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig
                  .AgentCreationConfigOrBuilder>
          getAgentCreationConfigFieldBuilder() {
        if (agentCreationConfigBuilder_ == null) {
          agentCreationConfigBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig
                      .AgentCreationConfig,
                  com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig
                      .AgentCreationConfig.Builder,
                  com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig
                      .AgentCreationConfigOrBuilder>(
                  getAgentCreationConfig(), getParentForChildren(), isClean());
          agentCreationConfig_ = null;
        }
        return agentCreationConfigBuilder_;
      }

      private java.lang.Object dialogflowAgentToLink_ = "";
      /**
       *
       *
       * <pre>
       * The resource name of an exist Dialogflow agent to link to this Chat
       * Engine. Customers can either provide `agent_creation_config` to create
       * agent or provide an agent name that links the agent with the Chat engine.
       *
       * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
       * ID&gt;`.
       *
       * Note that the `dialogflow_agent_to_link` are one-time consumed by and
       * passed to Dialogflow service. It means they cannot be retrieved using
       * [EngineService.GetEngine][google.cloud.discoveryengine.v1beta.EngineService.GetEngine]
       * or
       * [EngineService.ListEngines][google.cloud.discoveryengine.v1beta.EngineService.ListEngines]
       * API after engine creation. Use
       * [ChatEngineMetadata.dialogflow_agent][google.cloud.discoveryengine.v1beta.Engine.ChatEngineMetadata.dialogflow_agent]
       * for actual agent association after Engine is created.
       * </pre>
       *
       * <code>string dialogflow_agent_to_link = 2;</code>
       *
       * @return The dialogflowAgentToLink.
       */
      public java.lang.String getDialogflowAgentToLink() {
        java.lang.Object ref = dialogflowAgentToLink_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          dialogflowAgentToLink_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The resource name of an exist Dialogflow agent to link to this Chat
       * Engine. Customers can either provide `agent_creation_config` to create
       * agent or provide an agent name that links the agent with the Chat engine.
       *
       * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
       * ID&gt;`.
       *
       * Note that the `dialogflow_agent_to_link` are one-time consumed by and
       * passed to Dialogflow service. It means they cannot be retrieved using
       * [EngineService.GetEngine][google.cloud.discoveryengine.v1beta.EngineService.GetEngine]
       * or
       * [EngineService.ListEngines][google.cloud.discoveryengine.v1beta.EngineService.ListEngines]
       * API after engine creation. Use
       * [ChatEngineMetadata.dialogflow_agent][google.cloud.discoveryengine.v1beta.Engine.ChatEngineMetadata.dialogflow_agent]
       * for actual agent association after Engine is created.
       * </pre>
       *
       * <code>string dialogflow_agent_to_link = 2;</code>
       *
       * @return The bytes for dialogflowAgentToLink.
       */
      public com.google.protobuf.ByteString getDialogflowAgentToLinkBytes() {
        java.lang.Object ref = dialogflowAgentToLink_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          dialogflowAgentToLink_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The resource name of an exist Dialogflow agent to link to this Chat
       * Engine. Customers can either provide `agent_creation_config` to create
       * agent or provide an agent name that links the agent with the Chat engine.
       *
       * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
       * ID&gt;`.
       *
       * Note that the `dialogflow_agent_to_link` are one-time consumed by and
       * passed to Dialogflow service. It means they cannot be retrieved using
       * [EngineService.GetEngine][google.cloud.discoveryengine.v1beta.EngineService.GetEngine]
       * or
       * [EngineService.ListEngines][google.cloud.discoveryengine.v1beta.EngineService.ListEngines]
       * API after engine creation. Use
       * [ChatEngineMetadata.dialogflow_agent][google.cloud.discoveryengine.v1beta.Engine.ChatEngineMetadata.dialogflow_agent]
       * for actual agent association after Engine is created.
       * </pre>
       *
       * <code>string dialogflow_agent_to_link = 2;</code>
       *
       * @param value The dialogflowAgentToLink to set.
       * @return This builder for chaining.
       */
      public Builder setDialogflowAgentToLink(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        dialogflowAgentToLink_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The resource name of an exist Dialogflow agent to link to this Chat
       * Engine. Customers can either provide `agent_creation_config` to create
       * agent or provide an agent name that links the agent with the Chat engine.
       *
       * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
       * ID&gt;`.
       *
       * Note that the `dialogflow_agent_to_link` are one-time consumed by and
       * passed to Dialogflow service. It means they cannot be retrieved using
       * [EngineService.GetEngine][google.cloud.discoveryengine.v1beta.EngineService.GetEngine]
       * or
       * [EngineService.ListEngines][google.cloud.discoveryengine.v1beta.EngineService.ListEngines]
       * API after engine creation. Use
       * [ChatEngineMetadata.dialogflow_agent][google.cloud.discoveryengine.v1beta.Engine.ChatEngineMetadata.dialogflow_agent]
       * for actual agent association after Engine is created.
       * </pre>
       *
       * <code>string dialogflow_agent_to_link = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDialogflowAgentToLink() {
        dialogflowAgentToLink_ = getDefaultInstance().getDialogflowAgentToLink();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The resource name of an exist Dialogflow agent to link to this Chat
       * Engine. Customers can either provide `agent_creation_config` to create
       * agent or provide an agent name that links the agent with the Chat engine.
       *
       * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
       * ID&gt;`.
       *
       * Note that the `dialogflow_agent_to_link` are one-time consumed by and
       * passed to Dialogflow service. It means they cannot be retrieved using
       * [EngineService.GetEngine][google.cloud.discoveryengine.v1beta.EngineService.GetEngine]
       * or
       * [EngineService.ListEngines][google.cloud.discoveryengine.v1beta.EngineService.ListEngines]
       * API after engine creation. Use
       * [ChatEngineMetadata.dialogflow_agent][google.cloud.discoveryengine.v1beta.Engine.ChatEngineMetadata.dialogflow_agent]
       * for actual agent association after Engine is created.
       * </pre>
       *
       * <code>string dialogflow_agent_to_link = 2;</code>
       *
       * @param value The bytes for dialogflowAgentToLink to set.
       * @return This builder for chaining.
       */
      public Builder setDialogflowAgentToLinkBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        dialogflowAgentToLink_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig)
    private static final com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig();
    }

    public static com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ChatEngineConfig> PARSER =
        new com.google.protobuf.AbstractParser<ChatEngineConfig>() {
          @java.lang.Override
          public ChatEngineConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ChatEngineConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ChatEngineConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface CommonConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1beta.Engine.CommonConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Immutable. The name of the company, business or entity that is associated
     * with the engine. Setting this may help improve LLM related features.
     * </pre>
     *
     * <code>string company_name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The companyName.
     */
    java.lang.String getCompanyName();
    /**
     *
     *
     * <pre>
     * Immutable. The name of the company, business or entity that is associated
     * with the engine. Setting this may help improve LLM related features.
     * </pre>
     *
     * <code>string company_name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The bytes for companyName.
     */
    com.google.protobuf.ByteString getCompanyNameBytes();
  }
  /**
   *
   *
   * <pre>
   * Common configurations for an Engine.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1beta.Engine.CommonConfig}
   */
  public static final class CommonConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.Engine.CommonConfig)
      CommonConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use CommonConfig.newBuilder() to construct.
    private CommonConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private CommonConfig() {
      companyName_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new CommonConfig();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1beta.EngineProto
          .internal_static_google_cloud_discoveryengine_v1beta_Engine_CommonConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1beta.EngineProto
          .internal_static_google_cloud_discoveryengine_v1beta_Engine_CommonConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1beta.Engine.CommonConfig.class,
              com.google.cloud.discoveryengine.v1beta.Engine.CommonConfig.Builder.class);
    }

    public static final int COMPANY_NAME_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object companyName_ = "";
    /**
     *
     *
     * <pre>
     * Immutable. The name of the company, business or entity that is associated
     * with the engine. Setting this may help improve LLM related features.
     * </pre>
     *
     * <code>string company_name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The companyName.
     */
    @java.lang.Override
    public java.lang.String getCompanyName() {
      java.lang.Object ref = companyName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        companyName_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. The name of the company, business or entity that is associated
     * with the engine. Setting this may help improve LLM related features.
     * </pre>
     *
     * <code>string company_name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The bytes for companyName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getCompanyNameBytes() {
      java.lang.Object ref = companyName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        companyName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(companyName_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, companyName_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(companyName_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, companyName_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.discoveryengine.v1beta.Engine.CommonConfig)) {
        return super.equals(obj);
      }
      com.google.cloud.discoveryengine.v1beta.Engine.CommonConfig other =
          (com.google.cloud.discoveryengine.v1beta.Engine.CommonConfig) obj;

      if (!getCompanyName().equals(other.getCompanyName())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + COMPANY_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getCompanyName().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.discoveryengine.v1beta.Engine.CommonConfig parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.Engine.CommonConfig parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.Engine.CommonConfig parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.Engine.CommonConfig parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.Engine.CommonConfig parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.Engine.CommonConfig parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.Engine.CommonConfig parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.Engine.CommonConfig parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.Engine.CommonConfig parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.Engine.CommonConfig parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.Engine.CommonConfig parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.Engine.CommonConfig parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.discoveryengine.v1beta.Engine.CommonConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Common configurations for an Engine.
     * </pre>
     *
     * Protobuf type {@code google.cloud.discoveryengine.v1beta.Engine.CommonConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.Engine.CommonConfig)
        com.google.cloud.discoveryengine.v1beta.Engine.CommonConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1beta.EngineProto
            .internal_static_google_cloud_discoveryengine_v1beta_Engine_CommonConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1beta.EngineProto
            .internal_static_google_cloud_discoveryengine_v1beta_Engine_CommonConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1beta.Engine.CommonConfig.class,
                com.google.cloud.discoveryengine.v1beta.Engine.CommonConfig.Builder.class);
      }

      // Construct using com.google.cloud.discoveryengine.v1beta.Engine.CommonConfig.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        companyName_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.discoveryengine.v1beta.EngineProto
            .internal_static_google_cloud_discoveryengine_v1beta_Engine_CommonConfig_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.Engine.CommonConfig
          getDefaultInstanceForType() {
        return com.google.cloud.discoveryengine.v1beta.Engine.CommonConfig.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.Engine.CommonConfig build() {
        com.google.cloud.discoveryengine.v1beta.Engine.CommonConfig result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.Engine.CommonConfig buildPartial() {
        com.google.cloud.discoveryengine.v1beta.Engine.CommonConfig result =
            new com.google.cloud.discoveryengine.v1beta.Engine.CommonConfig(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.discoveryengine.v1beta.Engine.CommonConfig result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.companyName_ = companyName_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.discoveryengine.v1beta.Engine.CommonConfig) {
          return mergeFrom((com.google.cloud.discoveryengine.v1beta.Engine.CommonConfig) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.discoveryengine.v1beta.Engine.CommonConfig other) {
        if (other
            == com.google.cloud.discoveryengine.v1beta.Engine.CommonConfig.getDefaultInstance())
          return this;
        if (!other.getCompanyName().isEmpty()) {
          companyName_ = other.companyName_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  companyName_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object companyName_ = "";
      /**
       *
       *
       * <pre>
       * Immutable. The name of the company, business or entity that is associated
       * with the engine. Setting this may help improve LLM related features.
       * </pre>
       *
       * <code>string company_name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
       *
       * @return The companyName.
       */
      public java.lang.String getCompanyName() {
        java.lang.Object ref = companyName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          companyName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Immutable. The name of the company, business or entity that is associated
       * with the engine. Setting this may help improve LLM related features.
       * </pre>
       *
       * <code>string company_name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
       *
       * @return The bytes for companyName.
       */
      public com.google.protobuf.ByteString getCompanyNameBytes() {
        java.lang.Object ref = companyName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          companyName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Immutable. The name of the company, business or entity that is associated
       * with the engine. Setting this may help improve LLM related features.
       * </pre>
       *
       * <code>string company_name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
       *
       * @param value The companyName to set.
       * @return This builder for chaining.
       */
      public Builder setCompanyName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        companyName_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Immutable. The name of the company, business or entity that is associated
       * with the engine. Setting this may help improve LLM related features.
       * </pre>
       *
       * <code>string company_name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearCompanyName() {
        companyName_ = getDefaultInstance().getCompanyName();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Immutable. The name of the company, business or entity that is associated
       * with the engine. Setting this may help improve LLM related features.
       * </pre>
       *
       * <code>string company_name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
       *
       * @param value The bytes for companyName to set.
       * @return This builder for chaining.
       */
      public Builder setCompanyNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        companyName_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.Engine.CommonConfig)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.Engine.CommonConfig)
    private static final com.google.cloud.discoveryengine.v1beta.Engine.CommonConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.discoveryengine.v1beta.Engine.CommonConfig();
    }

    public static com.google.cloud.discoveryengine.v1beta.Engine.CommonConfig getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<CommonConfig> PARSER =
        new com.google.protobuf.AbstractParser<CommonConfig>() {
          @java.lang.Override
          public CommonConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<CommonConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<CommonConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.Engine.CommonConfig getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ChatEngineMetadataOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1beta.Engine.ChatEngineMetadata)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The resource name of a Dialogflow agent, that this Chat Engine refers
     * to.
     *
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;`.
     * </pre>
     *
     * <code>string dialogflow_agent = 1;</code>
     *
     * @return The dialogflowAgent.
     */
    java.lang.String getDialogflowAgent();
    /**
     *
     *
     * <pre>
     * The resource name of a Dialogflow agent, that this Chat Engine refers
     * to.
     *
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;`.
     * </pre>
     *
     * <code>string dialogflow_agent = 1;</code>
     *
     * @return The bytes for dialogflowAgent.
     */
    com.google.protobuf.ByteString getDialogflowAgentBytes();
  }
  /**
   *
   *
   * <pre>
   * Additional information of a Chat Engine.
   * Fields in this message are output only.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1beta.Engine.ChatEngineMetadata}
   */
  public static final class ChatEngineMetadata extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.Engine.ChatEngineMetadata)
      ChatEngineMetadataOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ChatEngineMetadata.newBuilder() to construct.
    private ChatEngineMetadata(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ChatEngineMetadata() {
      dialogflowAgent_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ChatEngineMetadata();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1beta.EngineProto
          .internal_static_google_cloud_discoveryengine_v1beta_Engine_ChatEngineMetadata_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1beta.EngineProto
          .internal_static_google_cloud_discoveryengine_v1beta_Engine_ChatEngineMetadata_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineMetadata.class,
              com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineMetadata.Builder.class);
    }

    public static final int DIALOGFLOW_AGENT_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object dialogflowAgent_ = "";
    /**
     *
     *
     * <pre>
     * The resource name of a Dialogflow agent, that this Chat Engine refers
     * to.
     *
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;`.
     * </pre>
     *
     * <code>string dialogflow_agent = 1;</code>
     *
     * @return The dialogflowAgent.
     */
    @java.lang.Override
    public java.lang.String getDialogflowAgent() {
      java.lang.Object ref = dialogflowAgent_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        dialogflowAgent_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of a Dialogflow agent, that this Chat Engine refers
     * to.
     *
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;`.
     * </pre>
     *
     * <code>string dialogflow_agent = 1;</code>
     *
     * @return The bytes for dialogflowAgent.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getDialogflowAgentBytes() {
      java.lang.Object ref = dialogflowAgent_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        dialogflowAgent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dialogflowAgent_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, dialogflowAgent_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dialogflowAgent_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, dialogflowAgent_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineMetadata)) {
        return super.equals(obj);
      }
      com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineMetadata other =
          (com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineMetadata) obj;

      if (!getDialogflowAgent().equals(other.getDialogflowAgent())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + DIALOGFLOW_AGENT_FIELD_NUMBER;
      hash = (53 * hash) + getDialogflowAgent().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineMetadata parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineMetadata parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineMetadata parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineMetadata parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineMetadata parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineMetadata parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineMetadata parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineMetadata parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineMetadata
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineMetadata
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineMetadata parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineMetadata parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineMetadata prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Additional information of a Chat Engine.
     * Fields in this message are output only.
     * </pre>
     *
     * Protobuf type {@code google.cloud.discoveryengine.v1beta.Engine.ChatEngineMetadata}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.Engine.ChatEngineMetadata)
        com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineMetadataOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1beta.EngineProto
            .internal_static_google_cloud_discoveryengine_v1beta_Engine_ChatEngineMetadata_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1beta.EngineProto
            .internal_static_google_cloud_discoveryengine_v1beta_Engine_ChatEngineMetadata_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineMetadata.class,
                com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineMetadata.Builder.class);
      }

      // Construct using
      // com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineMetadata.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        dialogflowAgent_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.discoveryengine.v1beta.EngineProto
            .internal_static_google_cloud_discoveryengine_v1beta_Engine_ChatEngineMetadata_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineMetadata
          getDefaultInstanceForType() {
        return com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineMetadata
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineMetadata build() {
        com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineMetadata result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineMetadata buildPartial() {
        com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineMetadata result =
            new com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineMetadata(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineMetadata result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.dialogflowAgent_ = dialogflowAgent_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineMetadata) {
          return mergeFrom(
              (com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineMetadata) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineMetadata other) {
        if (other
            == com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineMetadata
                .getDefaultInstance()) return this;
        if (!other.getDialogflowAgent().isEmpty()) {
          dialogflowAgent_ = other.dialogflowAgent_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  dialogflowAgent_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object dialogflowAgent_ = "";
      /**
       *
       *
       * <pre>
       * The resource name of a Dialogflow agent, that this Chat Engine refers
       * to.
       *
       * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
       * ID&gt;`.
       * </pre>
       *
       * <code>string dialogflow_agent = 1;</code>
       *
       * @return The dialogflowAgent.
       */
      public java.lang.String getDialogflowAgent() {
        java.lang.Object ref = dialogflowAgent_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          dialogflowAgent_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The resource name of a Dialogflow agent, that this Chat Engine refers
       * to.
       *
       * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
       * ID&gt;`.
       * </pre>
       *
       * <code>string dialogflow_agent = 1;</code>
       *
       * @return The bytes for dialogflowAgent.
       */
      public com.google.protobuf.ByteString getDialogflowAgentBytes() {
        java.lang.Object ref = dialogflowAgent_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          dialogflowAgent_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The resource name of a Dialogflow agent, that this Chat Engine refers
       * to.
       *
       * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
       * ID&gt;`.
       * </pre>
       *
       * <code>string dialogflow_agent = 1;</code>
       *
       * @param value The dialogflowAgent to set.
       * @return This builder for chaining.
       */
      public Builder setDialogflowAgent(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        dialogflowAgent_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The resource name of a Dialogflow agent, that this Chat Engine refers
       * to.
       *
       * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
       * ID&gt;`.
       * </pre>
       *
       * <code>string dialogflow_agent = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDialogflowAgent() {
        dialogflowAgent_ = getDefaultInstance().getDialogflowAgent();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The resource name of a Dialogflow agent, that this Chat Engine refers
       * to.
       *
       * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
       * ID&gt;`.
       * </pre>
       *
       * <code>string dialogflow_agent = 1;</code>
       *
       * @param value The bytes for dialogflowAgent to set.
       * @return This builder for chaining.
       */
      public Builder setDialogflowAgentBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        dialogflowAgent_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.Engine.ChatEngineMetadata)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.Engine.ChatEngineMetadata)
    private static final com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineMetadata
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineMetadata();
    }

    public static com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineMetadata
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ChatEngineMetadata> PARSER =
        new com.google.protobuf.AbstractParser<ChatEngineMetadata>() {
          @java.lang.Override
          public ChatEngineMetadata parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ChatEngineMetadata> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ChatEngineMetadata> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineMetadata
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  private int engineConfigCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object engineConfig_;

  public enum EngineConfigCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    CHAT_ENGINE_CONFIG(11),
    SEARCH_ENGINE_CONFIG(13),
    ENGINECONFIG_NOT_SET(0);
    private final int value;

    private EngineConfigCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static EngineConfigCase valueOf(int value) {
      return forNumber(value);
    }

    public static EngineConfigCase forNumber(int value) {
      switch (value) {
        case 11:
          return CHAT_ENGINE_CONFIG;
        case 13:
          return SEARCH_ENGINE_CONFIG;
        case 0:
          return ENGINECONFIG_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public EngineConfigCase getEngineConfigCase() {
    return EngineConfigCase.forNumber(engineConfigCase_);
  }

  private int engineMetadataCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object engineMetadata_;

  public enum EngineMetadataCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    CHAT_ENGINE_METADATA(12),
    ENGINEMETADATA_NOT_SET(0);
    private final int value;

    private EngineMetadataCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static EngineMetadataCase valueOf(int value) {
      return forNumber(value);
    }

    public static EngineMetadataCase forNumber(int value) {
      switch (value) {
        case 12:
          return CHAT_ENGINE_METADATA;
        case 0:
          return ENGINEMETADATA_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public EngineMetadataCase getEngineMetadataCase() {
    return EngineMetadataCase.forNumber(engineMetadataCase_);
  }

  public static final int CHAT_ENGINE_CONFIG_FIELD_NUMBER = 11;
  /**
   *
   *
   * <pre>
   * Configurations for the Chat Engine. Only applicable if
   * [solution_type][google.cloud.discoveryengine.v1beta.Engine.solution_type]
   * is
   * [SOLUTION_TYPE_CHAT][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_CHAT].
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig chat_engine_config = 11;
   * </code>
   *
   * @return Whether the chatEngineConfig field is set.
   */
  @java.lang.Override
  public boolean hasChatEngineConfig() {
    return engineConfigCase_ == 11;
  }
  /**
   *
   *
   * <pre>
   * Configurations for the Chat Engine. Only applicable if
   * [solution_type][google.cloud.discoveryengine.v1beta.Engine.solution_type]
   * is
   * [SOLUTION_TYPE_CHAT][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_CHAT].
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig chat_engine_config = 11;
   * </code>
   *
   * @return The chatEngineConfig.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig getChatEngineConfig() {
    if (engineConfigCase_ == 11) {
      return (com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig) engineConfig_;
    }
    return com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Configurations for the Chat Engine. Only applicable if
   * [solution_type][google.cloud.discoveryengine.v1beta.Engine.solution_type]
   * is
   * [SOLUTION_TYPE_CHAT][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_CHAT].
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig chat_engine_config = 11;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfigOrBuilder
      getChatEngineConfigOrBuilder() {
    if (engineConfigCase_ == 11) {
      return (com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig) engineConfig_;
    }
    return com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig.getDefaultInstance();
  }

  public static final int SEARCH_ENGINE_CONFIG_FIELD_NUMBER = 13;
  /**
   *
   *
   * <pre>
   * Configurations for the Search Engine. Only applicable if
   * [solution_type][google.cloud.discoveryengine.v1beta.Engine.solution_type]
   * is
   * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH].
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.Engine.SearchEngineConfig search_engine_config = 13;
   * </code>
   *
   * @return Whether the searchEngineConfig field is set.
   */
  @java.lang.Override
  public boolean hasSearchEngineConfig() {
    return engineConfigCase_ == 13;
  }
  /**
   *
   *
   * <pre>
   * Configurations for the Search Engine. Only applicable if
   * [solution_type][google.cloud.discoveryengine.v1beta.Engine.solution_type]
   * is
   * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH].
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.Engine.SearchEngineConfig search_engine_config = 13;
   * </code>
   *
   * @return The searchEngineConfig.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.Engine.SearchEngineConfig getSearchEngineConfig() {
    if (engineConfigCase_ == 13) {
      return (com.google.cloud.discoveryengine.v1beta.Engine.SearchEngineConfig) engineConfig_;
    }
    return com.google.cloud.discoveryengine.v1beta.Engine.SearchEngineConfig.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Configurations for the Search Engine. Only applicable if
   * [solution_type][google.cloud.discoveryengine.v1beta.Engine.solution_type]
   * is
   * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH].
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.Engine.SearchEngineConfig search_engine_config = 13;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.Engine.SearchEngineConfigOrBuilder
      getSearchEngineConfigOrBuilder() {
    if (engineConfigCase_ == 13) {
      return (com.google.cloud.discoveryengine.v1beta.Engine.SearchEngineConfig) engineConfig_;
    }
    return com.google.cloud.discoveryengine.v1beta.Engine.SearchEngineConfig.getDefaultInstance();
  }

  public static final int CHAT_ENGINE_METADATA_FIELD_NUMBER = 12;
  /**
   *
   *
   * <pre>
   * Output only. Additional information of the Chat Engine. Only applicable
   * if
   * [solution_type][google.cloud.discoveryengine.v1beta.Engine.solution_type]
   * is
   * [SOLUTION_TYPE_CHAT][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_CHAT].
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1beta.Engine.ChatEngineMetadata chat_engine_metadata = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the chatEngineMetadata field is set.
   */
  @java.lang.Override
  public boolean hasChatEngineMetadata() {
    return engineMetadataCase_ == 12;
  }
  /**
   *
   *
   * <pre>
   * Output only. Additional information of the Chat Engine. Only applicable
   * if
   * [solution_type][google.cloud.discoveryengine.v1beta.Engine.solution_type]
   * is
   * [SOLUTION_TYPE_CHAT][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_CHAT].
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1beta.Engine.ChatEngineMetadata chat_engine_metadata = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The chatEngineMetadata.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineMetadata getChatEngineMetadata() {
    if (engineMetadataCase_ == 12) {
      return (com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineMetadata) engineMetadata_;
    }
    return com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineMetadata.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Output only. Additional information of the Chat Engine. Only applicable
   * if
   * [solution_type][google.cloud.discoveryengine.v1beta.Engine.solution_type]
   * is
   * [SOLUTION_TYPE_CHAT][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_CHAT].
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1beta.Engine.ChatEngineMetadata chat_engine_metadata = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineMetadataOrBuilder
      getChatEngineMetadataOrBuilder() {
    if (engineMetadataCase_ == 12) {
      return (com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineMetadata) engineMetadata_;
    }
    return com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineMetadata.getDefaultInstance();
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Immutable. The fully qualified resource name of the engine.
   *
   * This field must be a UTF-8 encoded string with a length limit of 1024
   * characters.
   *
   * Format:
   * `projects/{project_number}/locations/{location}/collections/{collection}/engines/{engine}`
   * engine should be 1-63 characters, and valid characters are
   * /[a-z0-9][a-z0-9-_]*&#47;. Otherwise, an INVALID_ARGUMENT error is returned.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Immutable. The fully qualified resource name of the engine.
   *
   * This field must be a UTF-8 encoded string with a length limit of 1024
   * characters.
   *
   * Format:
   * `projects/{project_number}/locations/{location}/collections/{collection}/engines/{engine}`
   * engine should be 1-63 characters, and valid characters are
   * /[a-z0-9][a-z0-9-_]*&#47;. Otherwise, an INVALID_ARGUMENT error is returned.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";
  /**
   *
   *
   * <pre>
   * Required. The display name of the engine. Should be human readable. UTF-8
   * encoded string with limit of 1024 characters.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The display name of the engine. Should be human readable. UTF-8
   * encoded string with limit of 1024 characters.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 3;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. Timestamp the Recommendation Engine was created at.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp the Recommendation Engine was created at.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp the Recommendation Engine was created at.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 4;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. Timestamp the Recommendation Engine was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp the Recommendation Engine was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp the Recommendation Engine was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int DATA_STORE_IDS_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList dataStoreIds_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * The data stores associated with this engine.
   *
   * For
   * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH]
   * and
   * [SOLUTION_TYPE_RECOMMENDATION][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_RECOMMENDATION]
   * type of engines, they can only associate with at most one data store.
   *
   * If
   * [solution_type][google.cloud.discoveryengine.v1beta.Engine.solution_type]
   * is
   * [SOLUTION_TYPE_CHAT][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_CHAT],
   * multiple [DataStore][google.cloud.discoveryengine.v1beta.DataStore]s in the
   * same [Collection][google.cloud.discoveryengine.v1beta.Collection] can be
   * associated here.
   *
   * Note that when used in
   * [CreateEngineRequest][google.cloud.discoveryengine.v1beta.CreateEngineRequest],
   * one DataStore id must be provided as the system will use it for necessary
   * initializations.
   * </pre>
   *
   * <code>repeated string data_store_ids = 5;</code>
   *
   * @return A list containing the dataStoreIds.
   */
  public com.google.protobuf.ProtocolStringList getDataStoreIdsList() {
    return dataStoreIds_;
  }
  /**
   *
   *
   * <pre>
   * The data stores associated with this engine.
   *
   * For
   * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH]
   * and
   * [SOLUTION_TYPE_RECOMMENDATION][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_RECOMMENDATION]
   * type of engines, they can only associate with at most one data store.
   *
   * If
   * [solution_type][google.cloud.discoveryengine.v1beta.Engine.solution_type]
   * is
   * [SOLUTION_TYPE_CHAT][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_CHAT],
   * multiple [DataStore][google.cloud.discoveryengine.v1beta.DataStore]s in the
   * same [Collection][google.cloud.discoveryengine.v1beta.Collection] can be
   * associated here.
   *
   * Note that when used in
   * [CreateEngineRequest][google.cloud.discoveryengine.v1beta.CreateEngineRequest],
   * one DataStore id must be provided as the system will use it for necessary
   * initializations.
   * </pre>
   *
   * <code>repeated string data_store_ids = 5;</code>
   *
   * @return The count of dataStoreIds.
   */
  public int getDataStoreIdsCount() {
    return dataStoreIds_.size();
  }
  /**
   *
   *
   * <pre>
   * The data stores associated with this engine.
   *
   * For
   * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH]
   * and
   * [SOLUTION_TYPE_RECOMMENDATION][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_RECOMMENDATION]
   * type of engines, they can only associate with at most one data store.
   *
   * If
   * [solution_type][google.cloud.discoveryengine.v1beta.Engine.solution_type]
   * is
   * [SOLUTION_TYPE_CHAT][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_CHAT],
   * multiple [DataStore][google.cloud.discoveryengine.v1beta.DataStore]s in the
   * same [Collection][google.cloud.discoveryengine.v1beta.Collection] can be
   * associated here.
   *
   * Note that when used in
   * [CreateEngineRequest][google.cloud.discoveryengine.v1beta.CreateEngineRequest],
   * one DataStore id must be provided as the system will use it for necessary
   * initializations.
   * </pre>
   *
   * <code>repeated string data_store_ids = 5;</code>
   *
   * @param index The index of the element to return.
   * @return The dataStoreIds at the given index.
   */
  public java.lang.String getDataStoreIds(int index) {
    return dataStoreIds_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The data stores associated with this engine.
   *
   * For
   * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH]
   * and
   * [SOLUTION_TYPE_RECOMMENDATION][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_RECOMMENDATION]
   * type of engines, they can only associate with at most one data store.
   *
   * If
   * [solution_type][google.cloud.discoveryengine.v1beta.Engine.solution_type]
   * is
   * [SOLUTION_TYPE_CHAT][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_CHAT],
   * multiple [DataStore][google.cloud.discoveryengine.v1beta.DataStore]s in the
   * same [Collection][google.cloud.discoveryengine.v1beta.Collection] can be
   * associated here.
   *
   * Note that when used in
   * [CreateEngineRequest][google.cloud.discoveryengine.v1beta.CreateEngineRequest],
   * one DataStore id must be provided as the system will use it for necessary
   * initializations.
   * </pre>
   *
   * <code>repeated string data_store_ids = 5;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the dataStoreIds at the given index.
   */
  public com.google.protobuf.ByteString getDataStoreIdsBytes(int index) {
    return dataStoreIds_.getByteString(index);
  }

  public static final int SOLUTION_TYPE_FIELD_NUMBER = 6;
  private int solutionType_ = 0;
  /**
   *
   *
   * <pre>
   * Required. The solutions of the engine.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1beta.SolutionType solution_type = 6 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The enum numeric value on the wire for solutionType.
   */
  @java.lang.Override
  public int getSolutionTypeValue() {
    return solutionType_;
  }
  /**
   *
   *
   * <pre>
   * Required. The solutions of the engine.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1beta.SolutionType solution_type = 6 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The solutionType.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.SolutionType getSolutionType() {
    com.google.cloud.discoveryengine.v1beta.SolutionType result =
        com.google.cloud.discoveryengine.v1beta.SolutionType.forNumber(solutionType_);
    return result == null
        ? com.google.cloud.discoveryengine.v1beta.SolutionType.UNRECOGNIZED
        : result;
  }

  public static final int INDUSTRY_VERTICAL_FIELD_NUMBER = 16;
  private int industryVertical_ = 0;
  /**
   *
   *
   * <pre>
   * The industry vertical that the engine registers.
   * The restriction of the Engine industry vertical is based on
   * [DataStore][google.cloud.discoveryengine.v1beta.DataStore]: If unspecified,
   * default to `GENERIC`. Vertical on Engine has to match vertical of the
   * DataStore liniked to the engine.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.IndustryVertical industry_vertical = 16;</code>
   *
   * @return The enum numeric value on the wire for industryVertical.
   */
  @java.lang.Override
  public int getIndustryVerticalValue() {
    return industryVertical_;
  }
  /**
   *
   *
   * <pre>
   * The industry vertical that the engine registers.
   * The restriction of the Engine industry vertical is based on
   * [DataStore][google.cloud.discoveryengine.v1beta.DataStore]: If unspecified,
   * default to `GENERIC`. Vertical on Engine has to match vertical of the
   * DataStore liniked to the engine.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.IndustryVertical industry_vertical = 16;</code>
   *
   * @return The industryVertical.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.IndustryVertical getIndustryVertical() {
    com.google.cloud.discoveryengine.v1beta.IndustryVertical result =
        com.google.cloud.discoveryengine.v1beta.IndustryVertical.forNumber(industryVertical_);
    return result == null
        ? com.google.cloud.discoveryengine.v1beta.IndustryVertical.UNRECOGNIZED
        : result;
  }

  public static final int COMMON_CONFIG_FIELD_NUMBER = 15;
  private com.google.cloud.discoveryengine.v1beta.Engine.CommonConfig commonConfig_;
  /**
   *
   *
   * <pre>
   * Common config spec that specifies the metadata of the engine.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.Engine.CommonConfig common_config = 15;</code>
   *
   * @return Whether the commonConfig field is set.
   */
  @java.lang.Override
  public boolean hasCommonConfig() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Common config spec that specifies the metadata of the engine.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.Engine.CommonConfig common_config = 15;</code>
   *
   * @return The commonConfig.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.Engine.CommonConfig getCommonConfig() {
    return commonConfig_ == null
        ? com.google.cloud.discoveryengine.v1beta.Engine.CommonConfig.getDefaultInstance()
        : commonConfig_;
  }
  /**
   *
   *
   * <pre>
   * Common config spec that specifies the metadata of the engine.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.Engine.CommonConfig common_config = 15;</code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.Engine.CommonConfigOrBuilder
      getCommonConfigOrBuilder() {
    return commonConfig_ == null
        ? com.google.cloud.discoveryengine.v1beta.Engine.CommonConfig.getDefaultInstance()
        : commonConfig_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, displayName_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3, getCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(4, getUpdateTime());
    }
    for (int i = 0; i < dataStoreIds_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, dataStoreIds_.getRaw(i));
    }
    if (solutionType_
        != com.google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(6, solutionType_);
    }
    if (engineConfigCase_ == 11) {
      output.writeMessage(
          11, (com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig) engineConfig_);
    }
    if (engineMetadataCase_ == 12) {
      output.writeMessage(
          12, (com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineMetadata) engineMetadata_);
    }
    if (engineConfigCase_ == 13) {
      output.writeMessage(
          13, (com.google.cloud.discoveryengine.v1beta.Engine.SearchEngineConfig) engineConfig_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(15, getCommonConfig());
    }
    if (industryVertical_
        != com.google.cloud.discoveryengine.v1beta.IndustryVertical.INDUSTRY_VERTICAL_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(16, industryVertical_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, displayName_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getUpdateTime());
    }
    {
      int dataSize = 0;
      for (int i = 0; i < dataStoreIds_.size(); i++) {
        dataSize += computeStringSizeNoTag(dataStoreIds_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getDataStoreIdsList().size();
    }
    if (solutionType_
        != com.google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(6, solutionType_);
    }
    if (engineConfigCase_ == 11) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              11, (com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig) engineConfig_);
    }
    if (engineMetadataCase_ == 12) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              12,
              (com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineMetadata) engineMetadata_);
    }
    if (engineConfigCase_ == 13) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              13,
              (com.google.cloud.discoveryengine.v1beta.Engine.SearchEngineConfig) engineConfig_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(15, getCommonConfig());
    }
    if (industryVertical_
        != com.google.cloud.discoveryengine.v1beta.IndustryVertical.INDUSTRY_VERTICAL_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(16, industryVertical_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.discoveryengine.v1beta.Engine)) {
      return super.equals(obj);
    }
    com.google.cloud.discoveryengine.v1beta.Engine other =
        (com.google.cloud.discoveryengine.v1beta.Engine) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (!getDataStoreIdsList().equals(other.getDataStoreIdsList())) return false;
    if (solutionType_ != other.solutionType_) return false;
    if (industryVertical_ != other.industryVertical_) return false;
    if (hasCommonConfig() != other.hasCommonConfig()) return false;
    if (hasCommonConfig()) {
      if (!getCommonConfig().equals(other.getCommonConfig())) return false;
    }
    if (!getEngineConfigCase().equals(other.getEngineConfigCase())) return false;
    switch (engineConfigCase_) {
      case 11:
        if (!getChatEngineConfig().equals(other.getChatEngineConfig())) return false;
        break;
      case 13:
        if (!getSearchEngineConfig().equals(other.getSearchEngineConfig())) return false;
        break;
      case 0:
      default:
    }
    if (!getEngineMetadataCase().equals(other.getEngineMetadataCase())) return false;
    switch (engineMetadataCase_) {
      case 12:
        if (!getChatEngineMetadata().equals(other.getChatEngineMetadata())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    if (getDataStoreIdsCount() > 0) {
      hash = (37 * hash) + DATA_STORE_IDS_FIELD_NUMBER;
      hash = (53 * hash) + getDataStoreIdsList().hashCode();
    }
    hash = (37 * hash) + SOLUTION_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + solutionType_;
    hash = (37 * hash) + INDUSTRY_VERTICAL_FIELD_NUMBER;
    hash = (53 * hash) + industryVertical_;
    if (hasCommonConfig()) {
      hash = (37 * hash) + COMMON_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getCommonConfig().hashCode();
    }
    switch (engineConfigCase_) {
      case 11:
        hash = (37 * hash) + CHAT_ENGINE_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getChatEngineConfig().hashCode();
        break;
      case 13:
        hash = (37 * hash) + SEARCH_ENGINE_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getSearchEngineConfig().hashCode();
        break;
      case 0:
      default:
    }
    switch (engineMetadataCase_) {
      case 12:
        hash = (37 * hash) + CHAT_ENGINE_METADATA_FIELD_NUMBER;
        hash = (53 * hash) + getChatEngineMetadata().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.discoveryengine.v1beta.Engine parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1beta.Engine parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.Engine parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1beta.Engine parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.Engine parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1beta.Engine parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.Engine parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1beta.Engine parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.Engine parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1beta.Engine parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.Engine parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1beta.Engine parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.discoveryengine.v1beta.Engine prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Metadata that describes the training and serving parameters of an
   * [Engine][google.cloud.discoveryengine.v1beta.Engine].
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1beta.Engine}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.Engine)
      com.google.cloud.discoveryengine.v1beta.EngineOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1beta.EngineProto
          .internal_static_google_cloud_discoveryengine_v1beta_Engine_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1beta.EngineProto
          .internal_static_google_cloud_discoveryengine_v1beta_Engine_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1beta.Engine.class,
              com.google.cloud.discoveryengine.v1beta.Engine.Builder.class);
    }

    // Construct using com.google.cloud.discoveryengine.v1beta.Engine.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getCreateTimeFieldBuilder();
        getUpdateTimeFieldBuilder();
        getCommonConfigFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (chatEngineConfigBuilder_ != null) {
        chatEngineConfigBuilder_.clear();
      }
      if (searchEngineConfigBuilder_ != null) {
        searchEngineConfigBuilder_.clear();
      }
      if (chatEngineMetadataBuilder_ != null) {
        chatEngineMetadataBuilder_.clear();
      }
      name_ = "";
      displayName_ = "";
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      dataStoreIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
      solutionType_ = 0;
      industryVertical_ = 0;
      commonConfig_ = null;
      if (commonConfigBuilder_ != null) {
        commonConfigBuilder_.dispose();
        commonConfigBuilder_ = null;
      }
      engineConfigCase_ = 0;
      engineConfig_ = null;
      engineMetadataCase_ = 0;
      engineMetadata_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.discoveryengine.v1beta.EngineProto
          .internal_static_google_cloud_discoveryengine_v1beta_Engine_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.Engine getDefaultInstanceForType() {
      return com.google.cloud.discoveryengine.v1beta.Engine.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.Engine build() {
      com.google.cloud.discoveryengine.v1beta.Engine result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.Engine buildPartial() {
      com.google.cloud.discoveryengine.v1beta.Engine result =
          new com.google.cloud.discoveryengine.v1beta.Engine(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.discoveryengine.v1beta.Engine result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.displayName_ = displayName_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        dataStoreIds_.makeImmutable();
        result.dataStoreIds_ = dataStoreIds_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.solutionType_ = solutionType_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.industryVertical_ = industryVertical_;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.commonConfig_ =
            commonConfigBuilder_ == null ? commonConfig_ : commonConfigBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.cloud.discoveryengine.v1beta.Engine result) {
      result.engineConfigCase_ = engineConfigCase_;
      result.engineConfig_ = this.engineConfig_;
      if (engineConfigCase_ == 11 && chatEngineConfigBuilder_ != null) {
        result.engineConfig_ = chatEngineConfigBuilder_.build();
      }
      if (engineConfigCase_ == 13 && searchEngineConfigBuilder_ != null) {
        result.engineConfig_ = searchEngineConfigBuilder_.build();
      }
      result.engineMetadataCase_ = engineMetadataCase_;
      result.engineMetadata_ = this.engineMetadata_;
      if (engineMetadataCase_ == 12 && chatEngineMetadataBuilder_ != null) {
        result.engineMetadata_ = chatEngineMetadataBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.discoveryengine.v1beta.Engine) {
        return mergeFrom((com.google.cloud.discoveryengine.v1beta.Engine) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.discoveryengine.v1beta.Engine other) {
      if (other == com.google.cloud.discoveryengine.v1beta.Engine.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      if (!other.dataStoreIds_.isEmpty()) {
        if (dataStoreIds_.isEmpty()) {
          dataStoreIds_ = other.dataStoreIds_;
          bitField0_ |= 0x00000080;
        } else {
          ensureDataStoreIdsIsMutable();
          dataStoreIds_.addAll(other.dataStoreIds_);
        }
        onChanged();
      }
      if (other.solutionType_ != 0) {
        setSolutionTypeValue(other.getSolutionTypeValue());
      }
      if (other.industryVertical_ != 0) {
        setIndustryVerticalValue(other.getIndustryVerticalValue());
      }
      if (other.hasCommonConfig()) {
        mergeCommonConfig(other.getCommonConfig());
      }
      switch (other.getEngineConfigCase()) {
        case CHAT_ENGINE_CONFIG:
          {
            mergeChatEngineConfig(other.getChatEngineConfig());
            break;
          }
        case SEARCH_ENGINE_CONFIG:
          {
            mergeSearchEngineConfig(other.getSearchEngineConfig());
            break;
          }
        case ENGINECONFIG_NOT_SET:
          {
            break;
          }
      }
      switch (other.getEngineMetadataCase()) {
        case CHAT_ENGINE_METADATA:
          {
            mergeChatEngineMetadata(other.getChatEngineMetadata());
            break;
          }
        case ENGINEMETADATA_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 10
            case 18:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 34
            case 42:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureDataStoreIdsIsMutable();
                dataStoreIds_.add(s);
                break;
              } // case 42
            case 48:
              {
                solutionType_ = input.readEnum();
                bitField0_ |= 0x00000100;
                break;
              } // case 48
            case 90:
              {
                input.readMessage(
                    getChatEngineConfigFieldBuilder().getBuilder(), extensionRegistry);
                engineConfigCase_ = 11;
                break;
              } // case 90
            case 98:
              {
                input.readMessage(
                    getChatEngineMetadataFieldBuilder().getBuilder(), extensionRegistry);
                engineMetadataCase_ = 12;
                break;
              } // case 98
            case 106:
              {
                input.readMessage(
                    getSearchEngineConfigFieldBuilder().getBuilder(), extensionRegistry);
                engineConfigCase_ = 13;
                break;
              } // case 106
            case 122:
              {
                input.readMessage(getCommonConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000400;
                break;
              } // case 122
            case 128:
              {
                industryVertical_ = input.readEnum();
                bitField0_ |= 0x00000200;
                break;
              } // case 128
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int engineConfigCase_ = 0;
    private java.lang.Object engineConfig_;

    public EngineConfigCase getEngineConfigCase() {
      return EngineConfigCase.forNumber(engineConfigCase_);
    }

    public Builder clearEngineConfig() {
      engineConfigCase_ = 0;
      engineConfig_ = null;
      onChanged();
      return this;
    }

    private int engineMetadataCase_ = 0;
    private java.lang.Object engineMetadata_;

    public EngineMetadataCase getEngineMetadataCase() {
      return EngineMetadataCase.forNumber(engineMetadataCase_);
    }

    public Builder clearEngineMetadata() {
      engineMetadataCase_ = 0;
      engineMetadata_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig,
            com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig.Builder,
            com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfigOrBuilder>
        chatEngineConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Configurations for the Chat Engine. Only applicable if
     * [solution_type][google.cloud.discoveryengine.v1beta.Engine.solution_type]
     * is
     * [SOLUTION_TYPE_CHAT][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_CHAT].
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig chat_engine_config = 11;
     * </code>
     *
     * @return Whether the chatEngineConfig field is set.
     */
    @java.lang.Override
    public boolean hasChatEngineConfig() {
      return engineConfigCase_ == 11;
    }
    /**
     *
     *
     * <pre>
     * Configurations for the Chat Engine. Only applicable if
     * [solution_type][google.cloud.discoveryengine.v1beta.Engine.solution_type]
     * is
     * [SOLUTION_TYPE_CHAT][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_CHAT].
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig chat_engine_config = 11;
     * </code>
     *
     * @return The chatEngineConfig.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig getChatEngineConfig() {
      if (chatEngineConfigBuilder_ == null) {
        if (engineConfigCase_ == 11) {
          return (com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig) engineConfig_;
        }
        return com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig.getDefaultInstance();
      } else {
        if (engineConfigCase_ == 11) {
          return chatEngineConfigBuilder_.getMessage();
        }
        return com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Configurations for the Chat Engine. Only applicable if
     * [solution_type][google.cloud.discoveryengine.v1beta.Engine.solution_type]
     * is
     * [SOLUTION_TYPE_CHAT][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_CHAT].
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig chat_engine_config = 11;
     * </code>
     */
    public Builder setChatEngineConfig(
        com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig value) {
      if (chatEngineConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        engineConfig_ = value;
        onChanged();
      } else {
        chatEngineConfigBuilder_.setMessage(value);
      }
      engineConfigCase_ = 11;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configurations for the Chat Engine. Only applicable if
     * [solution_type][google.cloud.discoveryengine.v1beta.Engine.solution_type]
     * is
     * [SOLUTION_TYPE_CHAT][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_CHAT].
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig chat_engine_config = 11;
     * </code>
     */
    public Builder setChatEngineConfig(
        com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig.Builder builderForValue) {
      if (chatEngineConfigBuilder_ == null) {
        engineConfig_ = builderForValue.build();
        onChanged();
      } else {
        chatEngineConfigBuilder_.setMessage(builderForValue.build());
      }
      engineConfigCase_ = 11;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configurations for the Chat Engine. Only applicable if
     * [solution_type][google.cloud.discoveryengine.v1beta.Engine.solution_type]
     * is
     * [SOLUTION_TYPE_CHAT][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_CHAT].
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig chat_engine_config = 11;
     * </code>
     */
    public Builder mergeChatEngineConfig(
        com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig value) {
      if (chatEngineConfigBuilder_ == null) {
        if (engineConfigCase_ == 11
            && engineConfig_
                != com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig
                    .getDefaultInstance()) {
          engineConfig_ =
              com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig.newBuilder(
                      (com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig)
                          engineConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          engineConfig_ = value;
        }
        onChanged();
      } else {
        if (engineConfigCase_ == 11) {
          chatEngineConfigBuilder_.mergeFrom(value);
        } else {
          chatEngineConfigBuilder_.setMessage(value);
        }
      }
      engineConfigCase_ = 11;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configurations for the Chat Engine. Only applicable if
     * [solution_type][google.cloud.discoveryengine.v1beta.Engine.solution_type]
     * is
     * [SOLUTION_TYPE_CHAT][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_CHAT].
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig chat_engine_config = 11;
     * </code>
     */
    public Builder clearChatEngineConfig() {
      if (chatEngineConfigBuilder_ == null) {
        if (engineConfigCase_ == 11) {
          engineConfigCase_ = 0;
          engineConfig_ = null;
          onChanged();
        }
      } else {
        if (engineConfigCase_ == 11) {
          engineConfigCase_ = 0;
          engineConfig_ = null;
        }
        chatEngineConfigBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configurations for the Chat Engine. Only applicable if
     * [solution_type][google.cloud.discoveryengine.v1beta.Engine.solution_type]
     * is
     * [SOLUTION_TYPE_CHAT][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_CHAT].
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig chat_engine_config = 11;
     * </code>
     */
    public com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig.Builder
        getChatEngineConfigBuilder() {
      return getChatEngineConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configurations for the Chat Engine. Only applicable if
     * [solution_type][google.cloud.discoveryengine.v1beta.Engine.solution_type]
     * is
     * [SOLUTION_TYPE_CHAT][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_CHAT].
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig chat_engine_config = 11;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfigOrBuilder
        getChatEngineConfigOrBuilder() {
      if ((engineConfigCase_ == 11) && (chatEngineConfigBuilder_ != null)) {
        return chatEngineConfigBuilder_.getMessageOrBuilder();
      } else {
        if (engineConfigCase_ == 11) {
          return (com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig) engineConfig_;
        }
        return com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Configurations for the Chat Engine. Only applicable if
     * [solution_type][google.cloud.discoveryengine.v1beta.Engine.solution_type]
     * is
     * [SOLUTION_TYPE_CHAT][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_CHAT].
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig chat_engine_config = 11;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig,
            com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig.Builder,
            com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfigOrBuilder>
        getChatEngineConfigFieldBuilder() {
      if (chatEngineConfigBuilder_ == null) {
        if (!(engineConfigCase_ == 11)) {
          engineConfig_ =
              com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig.getDefaultInstance();
        }
        chatEngineConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig,
                com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig.Builder,
                com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfigOrBuilder>(
                (com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig) engineConfig_,
                getParentForChildren(),
                isClean());
        engineConfig_ = null;
      }
      engineConfigCase_ = 11;
      onChanged();
      return chatEngineConfigBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1beta.Engine.SearchEngineConfig,
            com.google.cloud.discoveryengine.v1beta.Engine.SearchEngineConfig.Builder,
            com.google.cloud.discoveryengine.v1beta.Engine.SearchEngineConfigOrBuilder>
        searchEngineConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Configurations for the Search Engine. Only applicable if
     * [solution_type][google.cloud.discoveryengine.v1beta.Engine.solution_type]
     * is
     * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.Engine.SearchEngineConfig search_engine_config = 13;
     * </code>
     *
     * @return Whether the searchEngineConfig field is set.
     */
    @java.lang.Override
    public boolean hasSearchEngineConfig() {
      return engineConfigCase_ == 13;
    }
    /**
     *
     *
     * <pre>
     * Configurations for the Search Engine. Only applicable if
     * [solution_type][google.cloud.discoveryengine.v1beta.Engine.solution_type]
     * is
     * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.Engine.SearchEngineConfig search_engine_config = 13;
     * </code>
     *
     * @return The searchEngineConfig.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.Engine.SearchEngineConfig
        getSearchEngineConfig() {
      if (searchEngineConfigBuilder_ == null) {
        if (engineConfigCase_ == 13) {
          return (com.google.cloud.discoveryengine.v1beta.Engine.SearchEngineConfig) engineConfig_;
        }
        return com.google.cloud.discoveryengine.v1beta.Engine.SearchEngineConfig
            .getDefaultInstance();
      } else {
        if (engineConfigCase_ == 13) {
          return searchEngineConfigBuilder_.getMessage();
        }
        return com.google.cloud.discoveryengine.v1beta.Engine.SearchEngineConfig
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Configurations for the Search Engine. Only applicable if
     * [solution_type][google.cloud.discoveryengine.v1beta.Engine.solution_type]
     * is
     * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.Engine.SearchEngineConfig search_engine_config = 13;
     * </code>
     */
    public Builder setSearchEngineConfig(
        com.google.cloud.discoveryengine.v1beta.Engine.SearchEngineConfig value) {
      if (searchEngineConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        engineConfig_ = value;
        onChanged();
      } else {
        searchEngineConfigBuilder_.setMessage(value);
      }
      engineConfigCase_ = 13;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configurations for the Search Engine. Only applicable if
     * [solution_type][google.cloud.discoveryengine.v1beta.Engine.solution_type]
     * is
     * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.Engine.SearchEngineConfig search_engine_config = 13;
     * </code>
     */
    public Builder setSearchEngineConfig(
        com.google.cloud.discoveryengine.v1beta.Engine.SearchEngineConfig.Builder builderForValue) {
      if (searchEngineConfigBuilder_ == null) {
        engineConfig_ = builderForValue.build();
        onChanged();
      } else {
        searchEngineConfigBuilder_.setMessage(builderForValue.build());
      }
      engineConfigCase_ = 13;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configurations for the Search Engine. Only applicable if
     * [solution_type][google.cloud.discoveryengine.v1beta.Engine.solution_type]
     * is
     * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.Engine.SearchEngineConfig search_engine_config = 13;
     * </code>
     */
    public Builder mergeSearchEngineConfig(
        com.google.cloud.discoveryengine.v1beta.Engine.SearchEngineConfig value) {
      if (searchEngineConfigBuilder_ == null) {
        if (engineConfigCase_ == 13
            && engineConfig_
                != com.google.cloud.discoveryengine.v1beta.Engine.SearchEngineConfig
                    .getDefaultInstance()) {
          engineConfig_ =
              com.google.cloud.discoveryengine.v1beta.Engine.SearchEngineConfig.newBuilder(
                      (com.google.cloud.discoveryengine.v1beta.Engine.SearchEngineConfig)
                          engineConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          engineConfig_ = value;
        }
        onChanged();
      } else {
        if (engineConfigCase_ == 13) {
          searchEngineConfigBuilder_.mergeFrom(value);
        } else {
          searchEngineConfigBuilder_.setMessage(value);
        }
      }
      engineConfigCase_ = 13;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configurations for the Search Engine. Only applicable if
     * [solution_type][google.cloud.discoveryengine.v1beta.Engine.solution_type]
     * is
     * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.Engine.SearchEngineConfig search_engine_config = 13;
     * </code>
     */
    public Builder clearSearchEngineConfig() {
      if (searchEngineConfigBuilder_ == null) {
        if (engineConfigCase_ == 13) {
          engineConfigCase_ = 0;
          engineConfig_ = null;
          onChanged();
        }
      } else {
        if (engineConfigCase_ == 13) {
          engineConfigCase_ = 0;
          engineConfig_ = null;
        }
        searchEngineConfigBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configurations for the Search Engine. Only applicable if
     * [solution_type][google.cloud.discoveryengine.v1beta.Engine.solution_type]
     * is
     * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.Engine.SearchEngineConfig search_engine_config = 13;
     * </code>
     */
    public com.google.cloud.discoveryengine.v1beta.Engine.SearchEngineConfig.Builder
        getSearchEngineConfigBuilder() {
      return getSearchEngineConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configurations for the Search Engine. Only applicable if
     * [solution_type][google.cloud.discoveryengine.v1beta.Engine.solution_type]
     * is
     * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.Engine.SearchEngineConfig search_engine_config = 13;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.Engine.SearchEngineConfigOrBuilder
        getSearchEngineConfigOrBuilder() {
      if ((engineConfigCase_ == 13) && (searchEngineConfigBuilder_ != null)) {
        return searchEngineConfigBuilder_.getMessageOrBuilder();
      } else {
        if (engineConfigCase_ == 13) {
          return (com.google.cloud.discoveryengine.v1beta.Engine.SearchEngineConfig) engineConfig_;
        }
        return com.google.cloud.discoveryengine.v1beta.Engine.SearchEngineConfig
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Configurations for the Search Engine. Only applicable if
     * [solution_type][google.cloud.discoveryengine.v1beta.Engine.solution_type]
     * is
     * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.Engine.SearchEngineConfig search_engine_config = 13;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1beta.Engine.SearchEngineConfig,
            com.google.cloud.discoveryengine.v1beta.Engine.SearchEngineConfig.Builder,
            com.google.cloud.discoveryengine.v1beta.Engine.SearchEngineConfigOrBuilder>
        getSearchEngineConfigFieldBuilder() {
      if (searchEngineConfigBuilder_ == null) {
        if (!(engineConfigCase_ == 13)) {
          engineConfig_ =
              com.google.cloud.discoveryengine.v1beta.Engine.SearchEngineConfig
                  .getDefaultInstance();
        }
        searchEngineConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1beta.Engine.SearchEngineConfig,
                com.google.cloud.discoveryengine.v1beta.Engine.SearchEngineConfig.Builder,
                com.google.cloud.discoveryengine.v1beta.Engine.SearchEngineConfigOrBuilder>(
                (com.google.cloud.discoveryengine.v1beta.Engine.SearchEngineConfig) engineConfig_,
                getParentForChildren(),
                isClean());
        engineConfig_ = null;
      }
      engineConfigCase_ = 13;
      onChanged();
      return searchEngineConfigBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineMetadata,
            com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineMetadata.Builder,
            com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineMetadataOrBuilder>
        chatEngineMetadataBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Additional information of the Chat Engine. Only applicable
     * if
     * [solution_type][google.cloud.discoveryengine.v1beta.Engine.solution_type]
     * is
     * [SOLUTION_TYPE_CHAT][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_CHAT].
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.Engine.ChatEngineMetadata chat_engine_metadata = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the chatEngineMetadata field is set.
     */
    @java.lang.Override
    public boolean hasChatEngineMetadata() {
      return engineMetadataCase_ == 12;
    }
    /**
     *
     *
     * <pre>
     * Output only. Additional information of the Chat Engine. Only applicable
     * if
     * [solution_type][google.cloud.discoveryengine.v1beta.Engine.solution_type]
     * is
     * [SOLUTION_TYPE_CHAT][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_CHAT].
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.Engine.ChatEngineMetadata chat_engine_metadata = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The chatEngineMetadata.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineMetadata
        getChatEngineMetadata() {
      if (chatEngineMetadataBuilder_ == null) {
        if (engineMetadataCase_ == 12) {
          return (com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineMetadata)
              engineMetadata_;
        }
        return com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineMetadata
            .getDefaultInstance();
      } else {
        if (engineMetadataCase_ == 12) {
          return chatEngineMetadataBuilder_.getMessage();
        }
        return com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineMetadata
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Additional information of the Chat Engine. Only applicable
     * if
     * [solution_type][google.cloud.discoveryengine.v1beta.Engine.solution_type]
     * is
     * [SOLUTION_TYPE_CHAT][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_CHAT].
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.Engine.ChatEngineMetadata chat_engine_metadata = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setChatEngineMetadata(
        com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineMetadata value) {
      if (chatEngineMetadataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        engineMetadata_ = value;
        onChanged();
      } else {
        chatEngineMetadataBuilder_.setMessage(value);
      }
      engineMetadataCase_ = 12;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Additional information of the Chat Engine. Only applicable
     * if
     * [solution_type][google.cloud.discoveryengine.v1beta.Engine.solution_type]
     * is
     * [SOLUTION_TYPE_CHAT][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_CHAT].
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.Engine.ChatEngineMetadata chat_engine_metadata = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setChatEngineMetadata(
        com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineMetadata.Builder builderForValue) {
      if (chatEngineMetadataBuilder_ == null) {
        engineMetadata_ = builderForValue.build();
        onChanged();
      } else {
        chatEngineMetadataBuilder_.setMessage(builderForValue.build());
      }
      engineMetadataCase_ = 12;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Additional information of the Chat Engine. Only applicable
     * if
     * [solution_type][google.cloud.discoveryengine.v1beta.Engine.solution_type]
     * is
     * [SOLUTION_TYPE_CHAT][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_CHAT].
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.Engine.ChatEngineMetadata chat_engine_metadata = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeChatEngineMetadata(
        com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineMetadata value) {
      if (chatEngineMetadataBuilder_ == null) {
        if (engineMetadataCase_ == 12
            && engineMetadata_
                != com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineMetadata
                    .getDefaultInstance()) {
          engineMetadata_ =
              com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineMetadata.newBuilder(
                      (com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineMetadata)
                          engineMetadata_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          engineMetadata_ = value;
        }
        onChanged();
      } else {
        if (engineMetadataCase_ == 12) {
          chatEngineMetadataBuilder_.mergeFrom(value);
        } else {
          chatEngineMetadataBuilder_.setMessage(value);
        }
      }
      engineMetadataCase_ = 12;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Additional information of the Chat Engine. Only applicable
     * if
     * [solution_type][google.cloud.discoveryengine.v1beta.Engine.solution_type]
     * is
     * [SOLUTION_TYPE_CHAT][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_CHAT].
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.Engine.ChatEngineMetadata chat_engine_metadata = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearChatEngineMetadata() {
      if (chatEngineMetadataBuilder_ == null) {
        if (engineMetadataCase_ == 12) {
          engineMetadataCase_ = 0;
          engineMetadata_ = null;
          onChanged();
        }
      } else {
        if (engineMetadataCase_ == 12) {
          engineMetadataCase_ = 0;
          engineMetadata_ = null;
        }
        chatEngineMetadataBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Additional information of the Chat Engine. Only applicable
     * if
     * [solution_type][google.cloud.discoveryengine.v1beta.Engine.solution_type]
     * is
     * [SOLUTION_TYPE_CHAT][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_CHAT].
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.Engine.ChatEngineMetadata chat_engine_metadata = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineMetadata.Builder
        getChatEngineMetadataBuilder() {
      return getChatEngineMetadataFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Additional information of the Chat Engine. Only applicable
     * if
     * [solution_type][google.cloud.discoveryengine.v1beta.Engine.solution_type]
     * is
     * [SOLUTION_TYPE_CHAT][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_CHAT].
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.Engine.ChatEngineMetadata chat_engine_metadata = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineMetadataOrBuilder
        getChatEngineMetadataOrBuilder() {
      if ((engineMetadataCase_ == 12) && (chatEngineMetadataBuilder_ != null)) {
        return chatEngineMetadataBuilder_.getMessageOrBuilder();
      } else {
        if (engineMetadataCase_ == 12) {
          return (com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineMetadata)
              engineMetadata_;
        }
        return com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineMetadata
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Additional information of the Chat Engine. Only applicable
     * if
     * [solution_type][google.cloud.discoveryengine.v1beta.Engine.solution_type]
     * is
     * [SOLUTION_TYPE_CHAT][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_CHAT].
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.Engine.ChatEngineMetadata chat_engine_metadata = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineMetadata,
            com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineMetadata.Builder,
            com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineMetadataOrBuilder>
        getChatEngineMetadataFieldBuilder() {
      if (chatEngineMetadataBuilder_ == null) {
        if (!(engineMetadataCase_ == 12)) {
          engineMetadata_ =
              com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineMetadata
                  .getDefaultInstance();
        }
        chatEngineMetadataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineMetadata,
                com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineMetadata.Builder,
                com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineMetadataOrBuilder>(
                (com.google.cloud.discoveryengine.v1beta.Engine.ChatEngineMetadata) engineMetadata_,
                getParentForChildren(),
                isClean());
        engineMetadata_ = null;
      }
      engineMetadataCase_ = 12;
      onChanged();
      return chatEngineMetadataBuilder_;
    }

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Immutable. The fully qualified resource name of the engine.
     *
     * This field must be a UTF-8 encoded string with a length limit of 1024
     * characters.
     *
     * Format:
     * `projects/{project_number}/locations/{location}/collections/{collection}/engines/{engine}`
     * engine should be 1-63 characters, and valid characters are
     * /[a-z0-9][a-z0-9-_]*&#47;. Otherwise, an INVALID_ARGUMENT error is returned.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. The fully qualified resource name of the engine.
     *
     * This field must be a UTF-8 encoded string with a length limit of 1024
     * characters.
     *
     * Format:
     * `projects/{project_number}/locations/{location}/collections/{collection}/engines/{engine}`
     * engine should be 1-63 characters, and valid characters are
     * /[a-z0-9][a-z0-9-_]*&#47;. Otherwise, an INVALID_ARGUMENT error is returned.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. The fully qualified resource name of the engine.
     *
     * This field must be a UTF-8 encoded string with a length limit of 1024
     * characters.
     *
     * Format:
     * `projects/{project_number}/locations/{location}/collections/{collection}/engines/{engine}`
     * engine should be 1-63 characters, and valid characters are
     * /[a-z0-9][a-z0-9-_]*&#47;. Otherwise, an INVALID_ARGUMENT error is returned.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The fully qualified resource name of the engine.
     *
     * This field must be a UTF-8 encoded string with a length limit of 1024
     * characters.
     *
     * Format:
     * `projects/{project_number}/locations/{location}/collections/{collection}/engines/{engine}`
     * engine should be 1-63 characters, and valid characters are
     * /[a-z0-9][a-z0-9-_]*&#47;. Otherwise, an INVALID_ARGUMENT error is returned.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The fully qualified resource name of the engine.
     *
     * This field must be a UTF-8 encoded string with a length limit of 1024
     * characters.
     *
     * Format:
     * `projects/{project_number}/locations/{location}/collections/{collection}/engines/{engine}`
     * engine should be 1-63 characters, and valid characters are
     * /[a-z0-9][a-z0-9-_]*&#47;. Otherwise, an INVALID_ARGUMENT error is returned.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * Required. The display name of the engine. Should be human readable. UTF-8
     * encoded string with limit of 1024 characters.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The display name of the engine. Should be human readable. UTF-8
     * encoded string with limit of 1024 characters.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The display name of the engine. Should be human readable. UTF-8
     * encoded string with limit of 1024 characters.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The display name of the engine. Should be human readable. UTF-8
     * encoded string with limit of 1024 characters.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The display name of the engine. Should be human readable. UTF-8
     * encoded string with limit of 1024 characters.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Timestamp the Recommendation Engine was created at.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp the Recommendation Engine was created at.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp the Recommendation Engine was created at.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp the Recommendation Engine was created at.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp the Recommendation Engine was created at.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp the Recommendation Engine was created at.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000020);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp the Recommendation Engine was created at.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp the Recommendation Engine was created at.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp the Recommendation Engine was created at.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Timestamp the Recommendation Engine was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp the Recommendation Engine was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp the Recommendation Engine was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp the Recommendation Engine was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp the Recommendation Engine was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      if (updateTime_ != null) {
        bitField0_ |= 0x00000040;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp the Recommendation Engine was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000040);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp the Recommendation Engine was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp the Recommendation Engine was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp the Recommendation Engine was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private com.google.protobuf.LazyStringArrayList dataStoreIds_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureDataStoreIdsIsMutable() {
      if (!dataStoreIds_.isModifiable()) {
        dataStoreIds_ = new com.google.protobuf.LazyStringArrayList(dataStoreIds_);
      }
      bitField0_ |= 0x00000080;
    }
    /**
     *
     *
     * <pre>
     * The data stores associated with this engine.
     *
     * For
     * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH]
     * and
     * [SOLUTION_TYPE_RECOMMENDATION][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_RECOMMENDATION]
     * type of engines, they can only associate with at most one data store.
     *
     * If
     * [solution_type][google.cloud.discoveryengine.v1beta.Engine.solution_type]
     * is
     * [SOLUTION_TYPE_CHAT][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_CHAT],
     * multiple [DataStore][google.cloud.discoveryengine.v1beta.DataStore]s in the
     * same [Collection][google.cloud.discoveryengine.v1beta.Collection] can be
     * associated here.
     *
     * Note that when used in
     * [CreateEngineRequest][google.cloud.discoveryengine.v1beta.CreateEngineRequest],
     * one DataStore id must be provided as the system will use it for necessary
     * initializations.
     * </pre>
     *
     * <code>repeated string data_store_ids = 5;</code>
     *
     * @return A list containing the dataStoreIds.
     */
    public com.google.protobuf.ProtocolStringList getDataStoreIdsList() {
      dataStoreIds_.makeImmutable();
      return dataStoreIds_;
    }
    /**
     *
     *
     * <pre>
     * The data stores associated with this engine.
     *
     * For
     * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH]
     * and
     * [SOLUTION_TYPE_RECOMMENDATION][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_RECOMMENDATION]
     * type of engines, they can only associate with at most one data store.
     *
     * If
     * [solution_type][google.cloud.discoveryengine.v1beta.Engine.solution_type]
     * is
     * [SOLUTION_TYPE_CHAT][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_CHAT],
     * multiple [DataStore][google.cloud.discoveryengine.v1beta.DataStore]s in the
     * same [Collection][google.cloud.discoveryengine.v1beta.Collection] can be
     * associated here.
     *
     * Note that when used in
     * [CreateEngineRequest][google.cloud.discoveryengine.v1beta.CreateEngineRequest],
     * one DataStore id must be provided as the system will use it for necessary
     * initializations.
     * </pre>
     *
     * <code>repeated string data_store_ids = 5;</code>
     *
     * @return The count of dataStoreIds.
     */
    public int getDataStoreIdsCount() {
      return dataStoreIds_.size();
    }
    /**
     *
     *
     * <pre>
     * The data stores associated with this engine.
     *
     * For
     * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH]
     * and
     * [SOLUTION_TYPE_RECOMMENDATION][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_RECOMMENDATION]
     * type of engines, they can only associate with at most one data store.
     *
     * If
     * [solution_type][google.cloud.discoveryengine.v1beta.Engine.solution_type]
     * is
     * [SOLUTION_TYPE_CHAT][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_CHAT],
     * multiple [DataStore][google.cloud.discoveryengine.v1beta.DataStore]s in the
     * same [Collection][google.cloud.discoveryengine.v1beta.Collection] can be
     * associated here.
     *
     * Note that when used in
     * [CreateEngineRequest][google.cloud.discoveryengine.v1beta.CreateEngineRequest],
     * one DataStore id must be provided as the system will use it for necessary
     * initializations.
     * </pre>
     *
     * <code>repeated string data_store_ids = 5;</code>
     *
     * @param index The index of the element to return.
     * @return The dataStoreIds at the given index.
     */
    public java.lang.String getDataStoreIds(int index) {
      return dataStoreIds_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The data stores associated with this engine.
     *
     * For
     * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH]
     * and
     * [SOLUTION_TYPE_RECOMMENDATION][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_RECOMMENDATION]
     * type of engines, they can only associate with at most one data store.
     *
     * If
     * [solution_type][google.cloud.discoveryengine.v1beta.Engine.solution_type]
     * is
     * [SOLUTION_TYPE_CHAT][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_CHAT],
     * multiple [DataStore][google.cloud.discoveryengine.v1beta.DataStore]s in the
     * same [Collection][google.cloud.discoveryengine.v1beta.Collection] can be
     * associated here.
     *
     * Note that when used in
     * [CreateEngineRequest][google.cloud.discoveryengine.v1beta.CreateEngineRequest],
     * one DataStore id must be provided as the system will use it for necessary
     * initializations.
     * </pre>
     *
     * <code>repeated string data_store_ids = 5;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the dataStoreIds at the given index.
     */
    public com.google.protobuf.ByteString getDataStoreIdsBytes(int index) {
      return dataStoreIds_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * The data stores associated with this engine.
     *
     * For
     * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH]
     * and
     * [SOLUTION_TYPE_RECOMMENDATION][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_RECOMMENDATION]
     * type of engines, they can only associate with at most one data store.
     *
     * If
     * [solution_type][google.cloud.discoveryengine.v1beta.Engine.solution_type]
     * is
     * [SOLUTION_TYPE_CHAT][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_CHAT],
     * multiple [DataStore][google.cloud.discoveryengine.v1beta.DataStore]s in the
     * same [Collection][google.cloud.discoveryengine.v1beta.Collection] can be
     * associated here.
     *
     * Note that when used in
     * [CreateEngineRequest][google.cloud.discoveryengine.v1beta.CreateEngineRequest],
     * one DataStore id must be provided as the system will use it for necessary
     * initializations.
     * </pre>
     *
     * <code>repeated string data_store_ids = 5;</code>
     *
     * @param index The index to set the value at.
     * @param value The dataStoreIds to set.
     * @return This builder for chaining.
     */
    public Builder setDataStoreIds(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureDataStoreIdsIsMutable();
      dataStoreIds_.set(index, value);
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The data stores associated with this engine.
     *
     * For
     * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH]
     * and
     * [SOLUTION_TYPE_RECOMMENDATION][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_RECOMMENDATION]
     * type of engines, they can only associate with at most one data store.
     *
     * If
     * [solution_type][google.cloud.discoveryengine.v1beta.Engine.solution_type]
     * is
     * [SOLUTION_TYPE_CHAT][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_CHAT],
     * multiple [DataStore][google.cloud.discoveryengine.v1beta.DataStore]s in the
     * same [Collection][google.cloud.discoveryengine.v1beta.Collection] can be
     * associated here.
     *
     * Note that when used in
     * [CreateEngineRequest][google.cloud.discoveryengine.v1beta.CreateEngineRequest],
     * one DataStore id must be provided as the system will use it for necessary
     * initializations.
     * </pre>
     *
     * <code>repeated string data_store_ids = 5;</code>
     *
     * @param value The dataStoreIds to add.
     * @return This builder for chaining.
     */
    public Builder addDataStoreIds(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureDataStoreIdsIsMutable();
      dataStoreIds_.add(value);
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The data stores associated with this engine.
     *
     * For
     * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH]
     * and
     * [SOLUTION_TYPE_RECOMMENDATION][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_RECOMMENDATION]
     * type of engines, they can only associate with at most one data store.
     *
     * If
     * [solution_type][google.cloud.discoveryengine.v1beta.Engine.solution_type]
     * is
     * [SOLUTION_TYPE_CHAT][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_CHAT],
     * multiple [DataStore][google.cloud.discoveryengine.v1beta.DataStore]s in the
     * same [Collection][google.cloud.discoveryengine.v1beta.Collection] can be
     * associated here.
     *
     * Note that when used in
     * [CreateEngineRequest][google.cloud.discoveryengine.v1beta.CreateEngineRequest],
     * one DataStore id must be provided as the system will use it for necessary
     * initializations.
     * </pre>
     *
     * <code>repeated string data_store_ids = 5;</code>
     *
     * @param values The dataStoreIds to add.
     * @return This builder for chaining.
     */
    public Builder addAllDataStoreIds(java.lang.Iterable<java.lang.String> values) {
      ensureDataStoreIdsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, dataStoreIds_);
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The data stores associated with this engine.
     *
     * For
     * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH]
     * and
     * [SOLUTION_TYPE_RECOMMENDATION][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_RECOMMENDATION]
     * type of engines, they can only associate with at most one data store.
     *
     * If
     * [solution_type][google.cloud.discoveryengine.v1beta.Engine.solution_type]
     * is
     * [SOLUTION_TYPE_CHAT][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_CHAT],
     * multiple [DataStore][google.cloud.discoveryengine.v1beta.DataStore]s in the
     * same [Collection][google.cloud.discoveryengine.v1beta.Collection] can be
     * associated here.
     *
     * Note that when used in
     * [CreateEngineRequest][google.cloud.discoveryengine.v1beta.CreateEngineRequest],
     * one DataStore id must be provided as the system will use it for necessary
     * initializations.
     * </pre>
     *
     * <code>repeated string data_store_ids = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDataStoreIds() {
      dataStoreIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000080);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The data stores associated with this engine.
     *
     * For
     * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH]
     * and
     * [SOLUTION_TYPE_RECOMMENDATION][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_RECOMMENDATION]
     * type of engines, they can only associate with at most one data store.
     *
     * If
     * [solution_type][google.cloud.discoveryengine.v1beta.Engine.solution_type]
     * is
     * [SOLUTION_TYPE_CHAT][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_CHAT],
     * multiple [DataStore][google.cloud.discoveryengine.v1beta.DataStore]s in the
     * same [Collection][google.cloud.discoveryengine.v1beta.Collection] can be
     * associated here.
     *
     * Note that when used in
     * [CreateEngineRequest][google.cloud.discoveryengine.v1beta.CreateEngineRequest],
     * one DataStore id must be provided as the system will use it for necessary
     * initializations.
     * </pre>
     *
     * <code>repeated string data_store_ids = 5;</code>
     *
     * @param value The bytes of the dataStoreIds to add.
     * @return This builder for chaining.
     */
    public Builder addDataStoreIdsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureDataStoreIdsIsMutable();
      dataStoreIds_.add(value);
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private int solutionType_ = 0;
    /**
     *
     *
     * <pre>
     * Required. The solutions of the engine.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.SolutionType solution_type = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The enum numeric value on the wire for solutionType.
     */
    @java.lang.Override
    public int getSolutionTypeValue() {
      return solutionType_;
    }
    /**
     *
     *
     * <pre>
     * Required. The solutions of the engine.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.SolutionType solution_type = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The enum numeric value on the wire for solutionType to set.
     * @return This builder for chaining.
     */
    public Builder setSolutionTypeValue(int value) {
      solutionType_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The solutions of the engine.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.SolutionType solution_type = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The solutionType.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.SolutionType getSolutionType() {
      com.google.cloud.discoveryengine.v1beta.SolutionType result =
          com.google.cloud.discoveryengine.v1beta.SolutionType.forNumber(solutionType_);
      return result == null
          ? com.google.cloud.discoveryengine.v1beta.SolutionType.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Required. The solutions of the engine.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.SolutionType solution_type = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The solutionType to set.
     * @return This builder for chaining.
     */
    public Builder setSolutionType(com.google.cloud.discoveryengine.v1beta.SolutionType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000100;
      solutionType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The solutions of the engine.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.SolutionType solution_type = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSolutionType() {
      bitField0_ = (bitField0_ & ~0x00000100);
      solutionType_ = 0;
      onChanged();
      return this;
    }

    private int industryVertical_ = 0;
    /**
     *
     *
     * <pre>
     * The industry vertical that the engine registers.
     * The restriction of the Engine industry vertical is based on
     * [DataStore][google.cloud.discoveryengine.v1beta.DataStore]: If unspecified,
     * default to `GENERIC`. Vertical on Engine has to match vertical of the
     * DataStore liniked to the engine.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.IndustryVertical industry_vertical = 16;</code>
     *
     * @return The enum numeric value on the wire for industryVertical.
     */
    @java.lang.Override
    public int getIndustryVerticalValue() {
      return industryVertical_;
    }
    /**
     *
     *
     * <pre>
     * The industry vertical that the engine registers.
     * The restriction of the Engine industry vertical is based on
     * [DataStore][google.cloud.discoveryengine.v1beta.DataStore]: If unspecified,
     * default to `GENERIC`. Vertical on Engine has to match vertical of the
     * DataStore liniked to the engine.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.IndustryVertical industry_vertical = 16;</code>
     *
     * @param value The enum numeric value on the wire for industryVertical to set.
     * @return This builder for chaining.
     */
    public Builder setIndustryVerticalValue(int value) {
      industryVertical_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The industry vertical that the engine registers.
     * The restriction of the Engine industry vertical is based on
     * [DataStore][google.cloud.discoveryengine.v1beta.DataStore]: If unspecified,
     * default to `GENERIC`. Vertical on Engine has to match vertical of the
     * DataStore liniked to the engine.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.IndustryVertical industry_vertical = 16;</code>
     *
     * @return The industryVertical.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.IndustryVertical getIndustryVertical() {
      com.google.cloud.discoveryengine.v1beta.IndustryVertical result =
          com.google.cloud.discoveryengine.v1beta.IndustryVertical.forNumber(industryVertical_);
      return result == null
          ? com.google.cloud.discoveryengine.v1beta.IndustryVertical.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * The industry vertical that the engine registers.
     * The restriction of the Engine industry vertical is based on
     * [DataStore][google.cloud.discoveryengine.v1beta.DataStore]: If unspecified,
     * default to `GENERIC`. Vertical on Engine has to match vertical of the
     * DataStore liniked to the engine.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.IndustryVertical industry_vertical = 16;</code>
     *
     * @param value The industryVertical to set.
     * @return This builder for chaining.
     */
    public Builder setIndustryVertical(
        com.google.cloud.discoveryengine.v1beta.IndustryVertical value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000200;
      industryVertical_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The industry vertical that the engine registers.
     * The restriction of the Engine industry vertical is based on
     * [DataStore][google.cloud.discoveryengine.v1beta.DataStore]: If unspecified,
     * default to `GENERIC`. Vertical on Engine has to match vertical of the
     * DataStore liniked to the engine.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.IndustryVertical industry_vertical = 16;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIndustryVertical() {
      bitField0_ = (bitField0_ & ~0x00000200);
      industryVertical_ = 0;
      onChanged();
      return this;
    }

    private com.google.cloud.discoveryengine.v1beta.Engine.CommonConfig commonConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1beta.Engine.CommonConfig,
            com.google.cloud.discoveryengine.v1beta.Engine.CommonConfig.Builder,
            com.google.cloud.discoveryengine.v1beta.Engine.CommonConfigOrBuilder>
        commonConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Common config spec that specifies the metadata of the engine.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.Engine.CommonConfig common_config = 15;</code>
     *
     * @return Whether the commonConfig field is set.
     */
    public boolean hasCommonConfig() {
      return ((bitField0_ & 0x00000400) != 0);
    }
    /**
     *
     *
     * <pre>
     * Common config spec that specifies the metadata of the engine.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.Engine.CommonConfig common_config = 15;</code>
     *
     * @return The commonConfig.
     */
    public com.google.cloud.discoveryengine.v1beta.Engine.CommonConfig getCommonConfig() {
      if (commonConfigBuilder_ == null) {
        return commonConfig_ == null
            ? com.google.cloud.discoveryengine.v1beta.Engine.CommonConfig.getDefaultInstance()
            : commonConfig_;
      } else {
        return commonConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Common config spec that specifies the metadata of the engine.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.Engine.CommonConfig common_config = 15;</code>
     */
    public Builder setCommonConfig(
        com.google.cloud.discoveryengine.v1beta.Engine.CommonConfig value) {
      if (commonConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        commonConfig_ = value;
      } else {
        commonConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Common config spec that specifies the metadata of the engine.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.Engine.CommonConfig common_config = 15;</code>
     */
    public Builder setCommonConfig(
        com.google.cloud.discoveryengine.v1beta.Engine.CommonConfig.Builder builderForValue) {
      if (commonConfigBuilder_ == null) {
        commonConfig_ = builderForValue.build();
      } else {
        commonConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Common config spec that specifies the metadata of the engine.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.Engine.CommonConfig common_config = 15;</code>
     */
    public Builder mergeCommonConfig(
        com.google.cloud.discoveryengine.v1beta.Engine.CommonConfig value) {
      if (commonConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000400) != 0)
            && commonConfig_ != null
            && commonConfig_
                != com.google.cloud.discoveryengine.v1beta.Engine.CommonConfig
                    .getDefaultInstance()) {
          getCommonConfigBuilder().mergeFrom(value);
        } else {
          commonConfig_ = value;
        }
      } else {
        commonConfigBuilder_.mergeFrom(value);
      }
      if (commonConfig_ != null) {
        bitField0_ |= 0x00000400;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Common config spec that specifies the metadata of the engine.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.Engine.CommonConfig common_config = 15;</code>
     */
    public Builder clearCommonConfig() {
      bitField0_ = (bitField0_ & ~0x00000400);
      commonConfig_ = null;
      if (commonConfigBuilder_ != null) {
        commonConfigBuilder_.dispose();
        commonConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Common config spec that specifies the metadata of the engine.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.Engine.CommonConfig common_config = 15;</code>
     */
    public com.google.cloud.discoveryengine.v1beta.Engine.CommonConfig.Builder
        getCommonConfigBuilder() {
      bitField0_ |= 0x00000400;
      onChanged();
      return getCommonConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Common config spec that specifies the metadata of the engine.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.Engine.CommonConfig common_config = 15;</code>
     */
    public com.google.cloud.discoveryengine.v1beta.Engine.CommonConfigOrBuilder
        getCommonConfigOrBuilder() {
      if (commonConfigBuilder_ != null) {
        return commonConfigBuilder_.getMessageOrBuilder();
      } else {
        return commonConfig_ == null
            ? com.google.cloud.discoveryengine.v1beta.Engine.CommonConfig.getDefaultInstance()
            : commonConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Common config spec that specifies the metadata of the engine.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.Engine.CommonConfig common_config = 15;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1beta.Engine.CommonConfig,
            com.google.cloud.discoveryengine.v1beta.Engine.CommonConfig.Builder,
            com.google.cloud.discoveryengine.v1beta.Engine.CommonConfigOrBuilder>
        getCommonConfigFieldBuilder() {
      if (commonConfigBuilder_ == null) {
        commonConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1beta.Engine.CommonConfig,
                com.google.cloud.discoveryengine.v1beta.Engine.CommonConfig.Builder,
                com.google.cloud.discoveryengine.v1beta.Engine.CommonConfigOrBuilder>(
                getCommonConfig(), getParentForChildren(), isClean());
        commonConfig_ = null;
      }
      return commonConfigBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.Engine)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.Engine)
  private static final com.google.cloud.discoveryengine.v1beta.Engine DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.discoveryengine.v1beta.Engine();
  }

  public static com.google.cloud.discoveryengine.v1beta.Engine getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Engine> PARSER =
      new com.google.protobuf.AbstractParser<Engine>() {
        @java.lang.Override
        public Engine parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Engine> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Engine> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.Engine getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
