/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/discoveryengine/v1beta/search_service.proto

// Protobuf Java Version: 3.25.3
package com.google.cloud.discoveryengine.v1beta;

/**
 *
 *
 * <pre>
 * Request message for
 * [SearchService.Search][google.cloud.discoveryengine.v1beta.SearchService.Search]
 * method.
 * </pre>
 *
 * Protobuf type {@code google.cloud.discoveryengine.v1beta.SearchRequest}
 */
public final class SearchRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.SearchRequest)
    SearchRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use SearchRequest.newBuilder() to construct.
  private SearchRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private SearchRequest() {
    servingConfig_ = "";
    branch_ = "";
    query_ = "";
    pageToken_ = "";
    dataStoreSpecs_ = java.util.Collections.emptyList();
    filter_ = "";
    canonicalFilter_ = "";
    orderBy_ = "";
    facetSpecs_ = java.util.Collections.emptyList();
    userPseudoId_ = "";
    rankingExpression_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new SearchRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
        .internal_static_google_cloud_discoveryengine_v1beta_SearchRequest_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 11:
        return internalGetParams();
      case 22:
        return internalGetUserLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
        .internal_static_google_cloud_discoveryengine_v1beta_SearchRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.discoveryengine.v1beta.SearchRequest.class,
            com.google.cloud.discoveryengine.v1beta.SearchRequest.Builder.class);
  }

  public interface ImageQueryOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1beta.SearchRequest.ImageQuery)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Base64 encoded image bytes. Supported image formats: JPEG, PNG, and
     * BMP.
     * </pre>
     *
     * <code>string image_bytes = 1;</code>
     *
     * @return Whether the imageBytes field is set.
     */
    boolean hasImageBytes();
    /**
     *
     *
     * <pre>
     * Base64 encoded image bytes. Supported image formats: JPEG, PNG, and
     * BMP.
     * </pre>
     *
     * <code>string image_bytes = 1;</code>
     *
     * @return The imageBytes.
     */
    java.lang.String getImageBytes();
    /**
     *
     *
     * <pre>
     * Base64 encoded image bytes. Supported image formats: JPEG, PNG, and
     * BMP.
     * </pre>
     *
     * <code>string image_bytes = 1;</code>
     *
     * @return The bytes for imageBytes.
     */
    com.google.protobuf.ByteString getImageBytesBytes();

    com.google.cloud.discoveryengine.v1beta.SearchRequest.ImageQuery.ImageCase getImageCase();
  }
  /**
   *
   *
   * <pre>
   * Specifies the image query input.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1beta.SearchRequest.ImageQuery}
   */
  public static final class ImageQuery extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.SearchRequest.ImageQuery)
      ImageQueryOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ImageQuery.newBuilder() to construct.
    private ImageQuery(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ImageQuery() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ImageQuery();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
          .internal_static_google_cloud_discoveryengine_v1beta_SearchRequest_ImageQuery_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
          .internal_static_google_cloud_discoveryengine_v1beta_SearchRequest_ImageQuery_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1beta.SearchRequest.ImageQuery.class,
              com.google.cloud.discoveryengine.v1beta.SearchRequest.ImageQuery.Builder.class);
    }

    private int imageCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object image_;

    public enum ImageCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      IMAGE_BYTES(1),
      IMAGE_NOT_SET(0);
      private final int value;

      private ImageCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static ImageCase valueOf(int value) {
        return forNumber(value);
      }

      public static ImageCase forNumber(int value) {
        switch (value) {
          case 1:
            return IMAGE_BYTES;
          case 0:
            return IMAGE_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public ImageCase getImageCase() {
      return ImageCase.forNumber(imageCase_);
    }

    public static final int IMAGE_BYTES_FIELD_NUMBER = 1;
    /**
     *
     *
     * <pre>
     * Base64 encoded image bytes. Supported image formats: JPEG, PNG, and
     * BMP.
     * </pre>
     *
     * <code>string image_bytes = 1;</code>
     *
     * @return Whether the imageBytes field is set.
     */
    public boolean hasImageBytes() {
      return imageCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * Base64 encoded image bytes. Supported image formats: JPEG, PNG, and
     * BMP.
     * </pre>
     *
     * <code>string image_bytes = 1;</code>
     *
     * @return The imageBytes.
     */
    public java.lang.String getImageBytes() {
      java.lang.Object ref = "";
      if (imageCase_ == 1) {
        ref = image_;
      }
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (imageCase_ == 1) {
          image_ = s;
        }
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Base64 encoded image bytes. Supported image formats: JPEG, PNG, and
     * BMP.
     * </pre>
     *
     * <code>string image_bytes = 1;</code>
     *
     * @return The bytes for imageBytes.
     */
    public com.google.protobuf.ByteString getImageBytesBytes() {
      java.lang.Object ref = "";
      if (imageCase_ == 1) {
        ref = image_;
      }
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (imageCase_ == 1) {
          image_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (imageCase_ == 1) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, image_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (imageCase_ == 1) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, image_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.discoveryengine.v1beta.SearchRequest.ImageQuery)) {
        return super.equals(obj);
      }
      com.google.cloud.discoveryengine.v1beta.SearchRequest.ImageQuery other =
          (com.google.cloud.discoveryengine.v1beta.SearchRequest.ImageQuery) obj;

      if (!getImageCase().equals(other.getImageCase())) return false;
      switch (imageCase_) {
        case 1:
          if (!getImageBytes().equals(other.getImageBytes())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      switch (imageCase_) {
        case 1:
          hash = (37 * hash) + IMAGE_BYTES_FIELD_NUMBER;
          hash = (53 * hash) + getImageBytes().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchRequest.ImageQuery parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchRequest.ImageQuery parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchRequest.ImageQuery parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchRequest.ImageQuery parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchRequest.ImageQuery parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchRequest.ImageQuery parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchRequest.ImageQuery parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchRequest.ImageQuery parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchRequest.ImageQuery
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchRequest.ImageQuery
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchRequest.ImageQuery parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchRequest.ImageQuery parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.discoveryengine.v1beta.SearchRequest.ImageQuery prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Specifies the image query input.
     * </pre>
     *
     * Protobuf type {@code google.cloud.discoveryengine.v1beta.SearchRequest.ImageQuery}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.SearchRequest.ImageQuery)
        com.google.cloud.discoveryengine.v1beta.SearchRequest.ImageQueryOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_SearchRequest_ImageQuery_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_SearchRequest_ImageQuery_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1beta.SearchRequest.ImageQuery.class,
                com.google.cloud.discoveryengine.v1beta.SearchRequest.ImageQuery.Builder.class);
      }

      // Construct using
      // com.google.cloud.discoveryengine.v1beta.SearchRequest.ImageQuery.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        imageCase_ = 0;
        image_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_SearchRequest_ImageQuery_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.SearchRequest.ImageQuery
          getDefaultInstanceForType() {
        return com.google.cloud.discoveryengine.v1beta.SearchRequest.ImageQuery
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.SearchRequest.ImageQuery build() {
        com.google.cloud.discoveryengine.v1beta.SearchRequest.ImageQuery result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.SearchRequest.ImageQuery buildPartial() {
        com.google.cloud.discoveryengine.v1beta.SearchRequest.ImageQuery result =
            new com.google.cloud.discoveryengine.v1beta.SearchRequest.ImageQuery(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.discoveryengine.v1beta.SearchRequest.ImageQuery result) {
        int from_bitField0_ = bitField0_;
      }

      private void buildPartialOneofs(
          com.google.cloud.discoveryengine.v1beta.SearchRequest.ImageQuery result) {
        result.imageCase_ = imageCase_;
        result.image_ = this.image_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.discoveryengine.v1beta.SearchRequest.ImageQuery) {
          return mergeFrom(
              (com.google.cloud.discoveryengine.v1beta.SearchRequest.ImageQuery) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.discoveryengine.v1beta.SearchRequest.ImageQuery other) {
        if (other
            == com.google.cloud.discoveryengine.v1beta.SearchRequest.ImageQuery
                .getDefaultInstance()) return this;
        switch (other.getImageCase()) {
          case IMAGE_BYTES:
            {
              imageCase_ = 1;
              image_ = other.image_;
              onChanged();
              break;
            }
          case IMAGE_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  imageCase_ = 1;
                  image_ = s;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int imageCase_ = 0;
      private java.lang.Object image_;

      public ImageCase getImageCase() {
        return ImageCase.forNumber(imageCase_);
      }

      public Builder clearImage() {
        imageCase_ = 0;
        image_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      /**
       *
       *
       * <pre>
       * Base64 encoded image bytes. Supported image formats: JPEG, PNG, and
       * BMP.
       * </pre>
       *
       * <code>string image_bytes = 1;</code>
       *
       * @return Whether the imageBytes field is set.
       */
      @java.lang.Override
      public boolean hasImageBytes() {
        return imageCase_ == 1;
      }
      /**
       *
       *
       * <pre>
       * Base64 encoded image bytes. Supported image formats: JPEG, PNG, and
       * BMP.
       * </pre>
       *
       * <code>string image_bytes = 1;</code>
       *
       * @return The imageBytes.
       */
      @java.lang.Override
      public java.lang.String getImageBytes() {
        java.lang.Object ref = "";
        if (imageCase_ == 1) {
          ref = image_;
        }
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (imageCase_ == 1) {
            image_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Base64 encoded image bytes. Supported image formats: JPEG, PNG, and
       * BMP.
       * </pre>
       *
       * <code>string image_bytes = 1;</code>
       *
       * @return The bytes for imageBytes.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getImageBytesBytes() {
        java.lang.Object ref = "";
        if (imageCase_ == 1) {
          ref = image_;
        }
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          if (imageCase_ == 1) {
            image_ = b;
          }
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Base64 encoded image bytes. Supported image formats: JPEG, PNG, and
       * BMP.
       * </pre>
       *
       * <code>string image_bytes = 1;</code>
       *
       * @param value The imageBytes to set.
       * @return This builder for chaining.
       */
      public Builder setImageBytes(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        imageCase_ = 1;
        image_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Base64 encoded image bytes. Supported image formats: JPEG, PNG, and
       * BMP.
       * </pre>
       *
       * <code>string image_bytes = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearImageBytes() {
        if (imageCase_ == 1) {
          imageCase_ = 0;
          image_ = null;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Base64 encoded image bytes. Supported image formats: JPEG, PNG, and
       * BMP.
       * </pre>
       *
       * <code>string image_bytes = 1;</code>
       *
       * @param value The bytes for imageBytes to set.
       * @return This builder for chaining.
       */
      public Builder setImageBytesBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        imageCase_ = 1;
        image_ = value;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.SearchRequest.ImageQuery)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.SearchRequest.ImageQuery)
    private static final com.google.cloud.discoveryengine.v1beta.SearchRequest.ImageQuery
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.discoveryengine.v1beta.SearchRequest.ImageQuery();
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchRequest.ImageQuery
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ImageQuery> PARSER =
        new com.google.protobuf.AbstractParser<ImageQuery>() {
          @java.lang.Override
          public ImageQuery parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ImageQuery> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ImageQuery> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.SearchRequest.ImageQuery
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface DataStoreSpecOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpec)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. Full resource name of
     * [DataStore][google.cloud.discoveryengine.v1beta.DataStore], such as
     * `projects/{project}/locations/{location}/collections/{collection_id}/dataStores/{data_store_id}`.
     * </pre>
     *
     * <code>
     * string data_store = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The dataStore.
     */
    java.lang.String getDataStore();
    /**
     *
     *
     * <pre>
     * Required. Full resource name of
     * [DataStore][google.cloud.discoveryengine.v1beta.DataStore], such as
     * `projects/{project}/locations/{location}/collections/{collection_id}/dataStores/{data_store_id}`.
     * </pre>
     *
     * <code>
     * string data_store = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for dataStore.
     */
    com.google.protobuf.ByteString getDataStoreBytes();
  }
  /**
   *
   *
   * <pre>
   * A struct to define data stores to filter on in a search call.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpec}
   */
  public static final class DataStoreSpec extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpec)
      DataStoreSpecOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use DataStoreSpec.newBuilder() to construct.
    private DataStoreSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private DataStoreSpec() {
      dataStore_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new DataStoreSpec();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
          .internal_static_google_cloud_discoveryengine_v1beta_SearchRequest_DataStoreSpec_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
          .internal_static_google_cloud_discoveryengine_v1beta_SearchRequest_DataStoreSpec_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpec.class,
              com.google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpec.Builder.class);
    }

    public static final int DATA_STORE_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object dataStore_ = "";
    /**
     *
     *
     * <pre>
     * Required. Full resource name of
     * [DataStore][google.cloud.discoveryengine.v1beta.DataStore], such as
     * `projects/{project}/locations/{location}/collections/{collection_id}/dataStores/{data_store_id}`.
     * </pre>
     *
     * <code>
     * string data_store = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The dataStore.
     */
    @java.lang.Override
    public java.lang.String getDataStore() {
      java.lang.Object ref = dataStore_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        dataStore_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Full resource name of
     * [DataStore][google.cloud.discoveryengine.v1beta.DataStore], such as
     * `projects/{project}/locations/{location}/collections/{collection_id}/dataStores/{data_store_id}`.
     * </pre>
     *
     * <code>
     * string data_store = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for dataStore.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getDataStoreBytes() {
      java.lang.Object ref = dataStore_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        dataStore_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dataStore_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, dataStore_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dataStore_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, dataStore_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpec)) {
        return super.equals(obj);
      }
      com.google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpec other =
          (com.google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpec) obj;

      if (!getDataStore().equals(other.getDataStore())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + DATA_STORE_FIELD_NUMBER;
      hash = (53 * hash) + getDataStore().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpec parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpec parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpec parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpec parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpec parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpec parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpec parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpec parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpec
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpec
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpec parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpec parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpec prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A struct to define data stores to filter on in a search call.
     * </pre>
     *
     * Protobuf type {@code google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpec}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpec)
        com.google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpecOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_SearchRequest_DataStoreSpec_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_SearchRequest_DataStoreSpec_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpec.class,
                com.google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpec.Builder.class);
      }

      // Construct using
      // com.google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpec.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        dataStore_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_SearchRequest_DataStoreSpec_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpec
          getDefaultInstanceForType() {
        return com.google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpec
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpec build() {
        com.google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpec result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpec buildPartial() {
        com.google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpec result =
            new com.google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpec(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpec result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.dataStore_ = dataStore_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpec) {
          return mergeFrom(
              (com.google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpec) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpec other) {
        if (other
            == com.google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpec
                .getDefaultInstance()) return this;
        if (!other.getDataStore().isEmpty()) {
          dataStore_ = other.dataStore_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  dataStore_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object dataStore_ = "";
      /**
       *
       *
       * <pre>
       * Required. Full resource name of
       * [DataStore][google.cloud.discoveryengine.v1beta.DataStore], such as
       * `projects/{project}/locations/{location}/collections/{collection_id}/dataStores/{data_store_id}`.
       * </pre>
       *
       * <code>
       * string data_store = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The dataStore.
       */
      public java.lang.String getDataStore() {
        java.lang.Object ref = dataStore_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          dataStore_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Full resource name of
       * [DataStore][google.cloud.discoveryengine.v1beta.DataStore], such as
       * `projects/{project}/locations/{location}/collections/{collection_id}/dataStores/{data_store_id}`.
       * </pre>
       *
       * <code>
       * string data_store = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The bytes for dataStore.
       */
      public com.google.protobuf.ByteString getDataStoreBytes() {
        java.lang.Object ref = dataStore_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          dataStore_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Full resource name of
       * [DataStore][google.cloud.discoveryengine.v1beta.DataStore], such as
       * `projects/{project}/locations/{location}/collections/{collection_id}/dataStores/{data_store_id}`.
       * </pre>
       *
       * <code>
       * string data_store = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The dataStore to set.
       * @return This builder for chaining.
       */
      public Builder setDataStore(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        dataStore_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Full resource name of
       * [DataStore][google.cloud.discoveryengine.v1beta.DataStore], such as
       * `projects/{project}/locations/{location}/collections/{collection_id}/dataStores/{data_store_id}`.
       * </pre>
       *
       * <code>
       * string data_store = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDataStore() {
        dataStore_ = getDefaultInstance().getDataStore();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Full resource name of
       * [DataStore][google.cloud.discoveryengine.v1beta.DataStore], such as
       * `projects/{project}/locations/{location}/collections/{collection_id}/dataStores/{data_store_id}`.
       * </pre>
       *
       * <code>
       * string data_store = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The bytes for dataStore to set.
       * @return This builder for chaining.
       */
      public Builder setDataStoreBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        dataStore_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpec)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpec)
    private static final com.google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpec
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpec();
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpec
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<DataStoreSpec> PARSER =
        new com.google.protobuf.AbstractParser<DataStoreSpec>() {
          @java.lang.Override
          public DataStoreSpec parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<DataStoreSpec> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<DataStoreSpec> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpec
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface FacetSpecOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. The facet key specification.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey facet_key = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the facetKey field is set.
     */
    boolean hasFacetKey();
    /**
     *
     *
     * <pre>
     * Required. The facet key specification.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey facet_key = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The facetKey.
     */
    com.google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey getFacetKey();
    /**
     *
     *
     * <pre>
     * Required. The facet key specification.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey facet_key = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    com.google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKeyOrBuilder
        getFacetKeyOrBuilder();

    /**
     *
     *
     * <pre>
     * Maximum of facet values that should be returned for this facet. If
     * unspecified, defaults to 20. The maximum allowed value is 300. Values
     * above 300 are coerced to 300.
     *
     * If this field is negative, an  `INVALID_ARGUMENT`  is returned.
     * </pre>
     *
     * <code>int32 limit = 2;</code>
     *
     * @return The limit.
     */
    int getLimit();

    /**
     *
     *
     * <pre>
     * List of keys to exclude when faceting.
     *
     *
     * By default,
     * [FacetKey.key][google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey.key]
     * is not excluded from the filter unless it is listed in this field.
     *
     * Listing a facet key in this field allows its values to appear as facet
     * results, even when they are filtered out of search results. Using this
     * field does not affect what search results are returned.
     *
     * For example, suppose there are 100 documents with the color facet "Red"
     * and 200 documents with the color facet "Blue". A query containing the
     * filter "color:ANY("Red")" and having "color" as
     * [FacetKey.key][google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey.key]
     * would by default return only "Red" documents in the search results, and
     * also return "Red" with count 100 as the only color facet. Although there
     * are also blue documents available, "Blue" would not be shown as an
     * available facet value.
     *
     * If "color" is listed in "excludedFilterKeys", then the query returns the
     * facet values "Red" with count 100 and "Blue" with count 200, because the
     * "color" key is now excluded from the filter. Because this field doesn't
     * affect search results, the search results are still correctly filtered to
     * return only "Red" documents.
     *
     * A maximum of 100 values are allowed. Otherwise, an  `INVALID_ARGUMENT`
     * error is returned.
     * </pre>
     *
     * <code>repeated string excluded_filter_keys = 3;</code>
     *
     * @return A list containing the excludedFilterKeys.
     */
    java.util.List<java.lang.String> getExcludedFilterKeysList();
    /**
     *
     *
     * <pre>
     * List of keys to exclude when faceting.
     *
     *
     * By default,
     * [FacetKey.key][google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey.key]
     * is not excluded from the filter unless it is listed in this field.
     *
     * Listing a facet key in this field allows its values to appear as facet
     * results, even when they are filtered out of search results. Using this
     * field does not affect what search results are returned.
     *
     * For example, suppose there are 100 documents with the color facet "Red"
     * and 200 documents with the color facet "Blue". A query containing the
     * filter "color:ANY("Red")" and having "color" as
     * [FacetKey.key][google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey.key]
     * would by default return only "Red" documents in the search results, and
     * also return "Red" with count 100 as the only color facet. Although there
     * are also blue documents available, "Blue" would not be shown as an
     * available facet value.
     *
     * If "color" is listed in "excludedFilterKeys", then the query returns the
     * facet values "Red" with count 100 and "Blue" with count 200, because the
     * "color" key is now excluded from the filter. Because this field doesn't
     * affect search results, the search results are still correctly filtered to
     * return only "Red" documents.
     *
     * A maximum of 100 values are allowed. Otherwise, an  `INVALID_ARGUMENT`
     * error is returned.
     * </pre>
     *
     * <code>repeated string excluded_filter_keys = 3;</code>
     *
     * @return The count of excludedFilterKeys.
     */
    int getExcludedFilterKeysCount();
    /**
     *
     *
     * <pre>
     * List of keys to exclude when faceting.
     *
     *
     * By default,
     * [FacetKey.key][google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey.key]
     * is not excluded from the filter unless it is listed in this field.
     *
     * Listing a facet key in this field allows its values to appear as facet
     * results, even when they are filtered out of search results. Using this
     * field does not affect what search results are returned.
     *
     * For example, suppose there are 100 documents with the color facet "Red"
     * and 200 documents with the color facet "Blue". A query containing the
     * filter "color:ANY("Red")" and having "color" as
     * [FacetKey.key][google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey.key]
     * would by default return only "Red" documents in the search results, and
     * also return "Red" with count 100 as the only color facet. Although there
     * are also blue documents available, "Blue" would not be shown as an
     * available facet value.
     *
     * If "color" is listed in "excludedFilterKeys", then the query returns the
     * facet values "Red" with count 100 and "Blue" with count 200, because the
     * "color" key is now excluded from the filter. Because this field doesn't
     * affect search results, the search results are still correctly filtered to
     * return only "Red" documents.
     *
     * A maximum of 100 values are allowed. Otherwise, an  `INVALID_ARGUMENT`
     * error is returned.
     * </pre>
     *
     * <code>repeated string excluded_filter_keys = 3;</code>
     *
     * @param index The index of the element to return.
     * @return The excludedFilterKeys at the given index.
     */
    java.lang.String getExcludedFilterKeys(int index);
    /**
     *
     *
     * <pre>
     * List of keys to exclude when faceting.
     *
     *
     * By default,
     * [FacetKey.key][google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey.key]
     * is not excluded from the filter unless it is listed in this field.
     *
     * Listing a facet key in this field allows its values to appear as facet
     * results, even when they are filtered out of search results. Using this
     * field does not affect what search results are returned.
     *
     * For example, suppose there are 100 documents with the color facet "Red"
     * and 200 documents with the color facet "Blue". A query containing the
     * filter "color:ANY("Red")" and having "color" as
     * [FacetKey.key][google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey.key]
     * would by default return only "Red" documents in the search results, and
     * also return "Red" with count 100 as the only color facet. Although there
     * are also blue documents available, "Blue" would not be shown as an
     * available facet value.
     *
     * If "color" is listed in "excludedFilterKeys", then the query returns the
     * facet values "Red" with count 100 and "Blue" with count 200, because the
     * "color" key is now excluded from the filter. Because this field doesn't
     * affect search results, the search results are still correctly filtered to
     * return only "Red" documents.
     *
     * A maximum of 100 values are allowed. Otherwise, an  `INVALID_ARGUMENT`
     * error is returned.
     * </pre>
     *
     * <code>repeated string excluded_filter_keys = 3;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the excludedFilterKeys at the given index.
     */
    com.google.protobuf.ByteString getExcludedFilterKeysBytes(int index);

    /**
     *
     *
     * <pre>
     * Enables dynamic position for this facet. If set to true, the position of
     * this facet among all facets in the response is determined automatically.
     * If dynamic facets are enabled, it is ordered together.
     * If set to false, the position of this facet in the
     * response is the same as in the request, and it is ranked before
     * the facets with dynamic position enable and all dynamic facets.
     *
     * For example, you may always want to have rating facet returned in
     * the response, but it's not necessarily to always display the rating facet
     * at the top. In that case, you can set enable_dynamic_position to true so
     * that the position of rating facet in response is determined
     * automatically.
     *
     * Another example, assuming you have the following facets in the request:
     *
     * * "rating", enable_dynamic_position = true
     *
     * * "price", enable_dynamic_position = false
     *
     * * "brands", enable_dynamic_position = false
     *
     * And also you have a dynamic facets enabled, which generates a facet
     * `gender`. Then the final order of the facets in the response can be
     * ("price", "brands", "rating", "gender") or ("price", "brands", "gender",
     * "rating") depends on how API orders "gender" and "rating" facets.
     * However, notice that "price" and "brands" are always
     * ranked at first and second position because their enable_dynamic_position
     * is false.
     * </pre>
     *
     * <code>bool enable_dynamic_position = 4;</code>
     *
     * @return The enableDynamicPosition.
     */
    boolean getEnableDynamicPosition();
  }
  /**
   *
   *
   * <pre>
   * A facet specification to perform faceted search.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec}
   */
  public static final class FacetSpec extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec)
      FacetSpecOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use FacetSpec.newBuilder() to construct.
    private FacetSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private FacetSpec() {
      excludedFilterKeys_ = com.google.protobuf.LazyStringArrayList.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new FacetSpec();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
          .internal_static_google_cloud_discoveryengine_v1beta_SearchRequest_FacetSpec_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
          .internal_static_google_cloud_discoveryengine_v1beta_SearchRequest_FacetSpec_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.class,
              com.google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.Builder.class);
    }

    public interface FacetKeyOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Required. Supported textual and numerical facet keys in
       * [Document][google.cloud.discoveryengine.v1beta.Document] object, over
       * which the facet values are computed. Facet key is case-sensitive.
       * </pre>
       *
       * <code>string key = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The key.
       */
      java.lang.String getKey();
      /**
       *
       *
       * <pre>
       * Required. Supported textual and numerical facet keys in
       * [Document][google.cloud.discoveryengine.v1beta.Document] object, over
       * which the facet values are computed. Facet key is case-sensitive.
       * </pre>
       *
       * <code>string key = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for key.
       */
      com.google.protobuf.ByteString getKeyBytes();

      /**
       *
       *
       * <pre>
       * Set only if values should be bucketed into intervals. Must be set
       * for facets with numerical values. Must not be set for facet with text
       * values. Maximum number of intervals is 30.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1beta.Interval intervals = 2;</code>
       */
      java.util.List<com.google.cloud.discoveryengine.v1beta.Interval> getIntervalsList();
      /**
       *
       *
       * <pre>
       * Set only if values should be bucketed into intervals. Must be set
       * for facets with numerical values. Must not be set for facet with text
       * values. Maximum number of intervals is 30.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1beta.Interval intervals = 2;</code>
       */
      com.google.cloud.discoveryengine.v1beta.Interval getIntervals(int index);
      /**
       *
       *
       * <pre>
       * Set only if values should be bucketed into intervals. Must be set
       * for facets with numerical values. Must not be set for facet with text
       * values. Maximum number of intervals is 30.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1beta.Interval intervals = 2;</code>
       */
      int getIntervalsCount();
      /**
       *
       *
       * <pre>
       * Set only if values should be bucketed into intervals. Must be set
       * for facets with numerical values. Must not be set for facet with text
       * values. Maximum number of intervals is 30.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1beta.Interval intervals = 2;</code>
       */
      java.util.List<? extends com.google.cloud.discoveryengine.v1beta.IntervalOrBuilder>
          getIntervalsOrBuilderList();
      /**
       *
       *
       * <pre>
       * Set only if values should be bucketed into intervals. Must be set
       * for facets with numerical values. Must not be set for facet with text
       * values. Maximum number of intervals is 30.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1beta.Interval intervals = 2;</code>
       */
      com.google.cloud.discoveryengine.v1beta.IntervalOrBuilder getIntervalsOrBuilder(int index);

      /**
       *
       *
       * <pre>
       * Only get facet for the given restricted values. Only supported on
       * textual fields. For example, suppose "category" has three values
       * "Action &gt; 2022", "Action &gt; 2021" and "Sci-Fi &gt; 2022". If set
       * "restricted_values" to "Action &gt; 2022", the "category" facet only
       * contains "Action &gt; 2022". Only supported on textual fields. Maximum
       * is 10.
       * </pre>
       *
       * <code>repeated string restricted_values = 3;</code>
       *
       * @return A list containing the restrictedValues.
       */
      java.util.List<java.lang.String> getRestrictedValuesList();
      /**
       *
       *
       * <pre>
       * Only get facet for the given restricted values. Only supported on
       * textual fields. For example, suppose "category" has three values
       * "Action &gt; 2022", "Action &gt; 2021" and "Sci-Fi &gt; 2022". If set
       * "restricted_values" to "Action &gt; 2022", the "category" facet only
       * contains "Action &gt; 2022". Only supported on textual fields. Maximum
       * is 10.
       * </pre>
       *
       * <code>repeated string restricted_values = 3;</code>
       *
       * @return The count of restrictedValues.
       */
      int getRestrictedValuesCount();
      /**
       *
       *
       * <pre>
       * Only get facet for the given restricted values. Only supported on
       * textual fields. For example, suppose "category" has three values
       * "Action &gt; 2022", "Action &gt; 2021" and "Sci-Fi &gt; 2022". If set
       * "restricted_values" to "Action &gt; 2022", the "category" facet only
       * contains "Action &gt; 2022". Only supported on textual fields. Maximum
       * is 10.
       * </pre>
       *
       * <code>repeated string restricted_values = 3;</code>
       *
       * @param index The index of the element to return.
       * @return The restrictedValues at the given index.
       */
      java.lang.String getRestrictedValues(int index);
      /**
       *
       *
       * <pre>
       * Only get facet for the given restricted values. Only supported on
       * textual fields. For example, suppose "category" has three values
       * "Action &gt; 2022", "Action &gt; 2021" and "Sci-Fi &gt; 2022". If set
       * "restricted_values" to "Action &gt; 2022", the "category" facet only
       * contains "Action &gt; 2022". Only supported on textual fields. Maximum
       * is 10.
       * </pre>
       *
       * <code>repeated string restricted_values = 3;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the restrictedValues at the given index.
       */
      com.google.protobuf.ByteString getRestrictedValuesBytes(int index);

      /**
       *
       *
       * <pre>
       * Only get facet values that start with the given string prefix. For
       * example, suppose "category" has three values "Action &gt; 2022",
       * "Action &gt; 2021" and "Sci-Fi &gt; 2022". If set "prefixes" to "Action", the
       * "category" facet only contains "Action &gt; 2022" and "Action &gt; 2021".
       * Only supported on textual fields. Maximum is 10.
       * </pre>
       *
       * <code>repeated string prefixes = 4;</code>
       *
       * @return A list containing the prefixes.
       */
      java.util.List<java.lang.String> getPrefixesList();
      /**
       *
       *
       * <pre>
       * Only get facet values that start with the given string prefix. For
       * example, suppose "category" has three values "Action &gt; 2022",
       * "Action &gt; 2021" and "Sci-Fi &gt; 2022". If set "prefixes" to "Action", the
       * "category" facet only contains "Action &gt; 2022" and "Action &gt; 2021".
       * Only supported on textual fields. Maximum is 10.
       * </pre>
       *
       * <code>repeated string prefixes = 4;</code>
       *
       * @return The count of prefixes.
       */
      int getPrefixesCount();
      /**
       *
       *
       * <pre>
       * Only get facet values that start with the given string prefix. For
       * example, suppose "category" has three values "Action &gt; 2022",
       * "Action &gt; 2021" and "Sci-Fi &gt; 2022". If set "prefixes" to "Action", the
       * "category" facet only contains "Action &gt; 2022" and "Action &gt; 2021".
       * Only supported on textual fields. Maximum is 10.
       * </pre>
       *
       * <code>repeated string prefixes = 4;</code>
       *
       * @param index The index of the element to return.
       * @return The prefixes at the given index.
       */
      java.lang.String getPrefixes(int index);
      /**
       *
       *
       * <pre>
       * Only get facet values that start with the given string prefix. For
       * example, suppose "category" has three values "Action &gt; 2022",
       * "Action &gt; 2021" and "Sci-Fi &gt; 2022". If set "prefixes" to "Action", the
       * "category" facet only contains "Action &gt; 2022" and "Action &gt; 2021".
       * Only supported on textual fields. Maximum is 10.
       * </pre>
       *
       * <code>repeated string prefixes = 4;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the prefixes at the given index.
       */
      com.google.protobuf.ByteString getPrefixesBytes(int index);

      /**
       *
       *
       * <pre>
       * Only get facet values that contains the given strings. For example,
       * suppose "category" has three values "Action &gt; 2022",
       * "Action &gt; 2021" and "Sci-Fi &gt; 2022". If set "contains" to "2022", the
       * "category" facet only contains "Action &gt; 2022" and "Sci-Fi &gt; 2022".
       * Only supported on textual fields. Maximum is 10.
       * </pre>
       *
       * <code>repeated string contains = 5;</code>
       *
       * @return A list containing the contains.
       */
      java.util.List<java.lang.String> getContainsList();
      /**
       *
       *
       * <pre>
       * Only get facet values that contains the given strings. For example,
       * suppose "category" has three values "Action &gt; 2022",
       * "Action &gt; 2021" and "Sci-Fi &gt; 2022". If set "contains" to "2022", the
       * "category" facet only contains "Action &gt; 2022" and "Sci-Fi &gt; 2022".
       * Only supported on textual fields. Maximum is 10.
       * </pre>
       *
       * <code>repeated string contains = 5;</code>
       *
       * @return The count of contains.
       */
      int getContainsCount();
      /**
       *
       *
       * <pre>
       * Only get facet values that contains the given strings. For example,
       * suppose "category" has three values "Action &gt; 2022",
       * "Action &gt; 2021" and "Sci-Fi &gt; 2022". If set "contains" to "2022", the
       * "category" facet only contains "Action &gt; 2022" and "Sci-Fi &gt; 2022".
       * Only supported on textual fields. Maximum is 10.
       * </pre>
       *
       * <code>repeated string contains = 5;</code>
       *
       * @param index The index of the element to return.
       * @return The contains at the given index.
       */
      java.lang.String getContains(int index);
      /**
       *
       *
       * <pre>
       * Only get facet values that contains the given strings. For example,
       * suppose "category" has three values "Action &gt; 2022",
       * "Action &gt; 2021" and "Sci-Fi &gt; 2022". If set "contains" to "2022", the
       * "category" facet only contains "Action &gt; 2022" and "Sci-Fi &gt; 2022".
       * Only supported on textual fields. Maximum is 10.
       * </pre>
       *
       * <code>repeated string contains = 5;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the contains at the given index.
       */
      com.google.protobuf.ByteString getContainsBytes(int index);

      /**
       *
       *
       * <pre>
       * True to make facet keys case insensitive when getting faceting
       * values with prefixes or contains; false otherwise.
       * </pre>
       *
       * <code>bool case_insensitive = 6;</code>
       *
       * @return The caseInsensitive.
       */
      boolean getCaseInsensitive();

      /**
       *
       *
       * <pre>
       * The order in which documents are returned.
       *
       * Allowed values are:
       *
       * * "count desc", which means order by
       * [SearchResponse.Facet.values.count][google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue.count]
       * descending.
       *
       * * "value desc", which means order by
       * [SearchResponse.Facet.values.value][google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue.value]
       * descending.
       *   Only applies to textual facets.
       *
       * If not set, textual values are sorted in [natural
       * order](https://en.wikipedia.org/wiki/Natural_sort_order); numerical
       * intervals are sorted in the order given by
       * [FacetSpec.FacetKey.intervals][google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey.intervals].
       * </pre>
       *
       * <code>string order_by = 7;</code>
       *
       * @return The orderBy.
       */
      java.lang.String getOrderBy();
      /**
       *
       *
       * <pre>
       * The order in which documents are returned.
       *
       * Allowed values are:
       *
       * * "count desc", which means order by
       * [SearchResponse.Facet.values.count][google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue.count]
       * descending.
       *
       * * "value desc", which means order by
       * [SearchResponse.Facet.values.value][google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue.value]
       * descending.
       *   Only applies to textual facets.
       *
       * If not set, textual values are sorted in [natural
       * order](https://en.wikipedia.org/wiki/Natural_sort_order); numerical
       * intervals are sorted in the order given by
       * [FacetSpec.FacetKey.intervals][google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey.intervals].
       * </pre>
       *
       * <code>string order_by = 7;</code>
       *
       * @return The bytes for orderBy.
       */
      com.google.protobuf.ByteString getOrderByBytes();
    }
    /**
     *
     *
     * <pre>
     * Specifies how a facet is computed.
     * </pre>
     *
     * Protobuf type {@code google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey}
     */
    public static final class FacetKey extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey)
        FacetKeyOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use FacetKey.newBuilder() to construct.
      private FacetKey(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private FacetKey() {
        key_ = "";
        intervals_ = java.util.Collections.emptyList();
        restrictedValues_ = com.google.protobuf.LazyStringArrayList.emptyList();
        prefixes_ = com.google.protobuf.LazyStringArrayList.emptyList();
        contains_ = com.google.protobuf.LazyStringArrayList.emptyList();
        orderBy_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new FacetKey();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_SearchRequest_FacetSpec_FacetKey_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_SearchRequest_FacetSpec_FacetKey_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey.class,
                com.google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey.Builder
                    .class);
      }

      public static final int KEY_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private volatile java.lang.Object key_ = "";
      /**
       *
       *
       * <pre>
       * Required. Supported textual and numerical facet keys in
       * [Document][google.cloud.discoveryengine.v1beta.Document] object, over
       * which the facet values are computed. Facet key is case-sensitive.
       * </pre>
       *
       * <code>string key = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The key.
       */
      @java.lang.Override
      public java.lang.String getKey() {
        java.lang.Object ref = key_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          key_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Supported textual and numerical facet keys in
       * [Document][google.cloud.discoveryengine.v1beta.Document] object, over
       * which the facet values are computed. Facet key is case-sensitive.
       * </pre>
       *
       * <code>string key = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for key.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getKeyBytes() {
        java.lang.Object ref = key_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          key_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int INTERVALS_FIELD_NUMBER = 2;

      @SuppressWarnings("serial")
      private java.util.List<com.google.cloud.discoveryengine.v1beta.Interval> intervals_;
      /**
       *
       *
       * <pre>
       * Set only if values should be bucketed into intervals. Must be set
       * for facets with numerical values. Must not be set for facet with text
       * values. Maximum number of intervals is 30.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1beta.Interval intervals = 2;</code>
       */
      @java.lang.Override
      public java.util.List<com.google.cloud.discoveryengine.v1beta.Interval> getIntervalsList() {
        return intervals_;
      }
      /**
       *
       *
       * <pre>
       * Set only if values should be bucketed into intervals. Must be set
       * for facets with numerical values. Must not be set for facet with text
       * values. Maximum number of intervals is 30.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1beta.Interval intervals = 2;</code>
       */
      @java.lang.Override
      public java.util.List<? extends com.google.cloud.discoveryengine.v1beta.IntervalOrBuilder>
          getIntervalsOrBuilderList() {
        return intervals_;
      }
      /**
       *
       *
       * <pre>
       * Set only if values should be bucketed into intervals. Must be set
       * for facets with numerical values. Must not be set for facet with text
       * values. Maximum number of intervals is 30.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1beta.Interval intervals = 2;</code>
       */
      @java.lang.Override
      public int getIntervalsCount() {
        return intervals_.size();
      }
      /**
       *
       *
       * <pre>
       * Set only if values should be bucketed into intervals. Must be set
       * for facets with numerical values. Must not be set for facet with text
       * values. Maximum number of intervals is 30.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1beta.Interval intervals = 2;</code>
       */
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.Interval getIntervals(int index) {
        return intervals_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Set only if values should be bucketed into intervals. Must be set
       * for facets with numerical values. Must not be set for facet with text
       * values. Maximum number of intervals is 30.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1beta.Interval intervals = 2;</code>
       */
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.IntervalOrBuilder getIntervalsOrBuilder(
          int index) {
        return intervals_.get(index);
      }

      public static final int RESTRICTED_VALUES_FIELD_NUMBER = 3;

      @SuppressWarnings("serial")
      private com.google.protobuf.LazyStringArrayList restrictedValues_ =
          com.google.protobuf.LazyStringArrayList.emptyList();
      /**
       *
       *
       * <pre>
       * Only get facet for the given restricted values. Only supported on
       * textual fields. For example, suppose "category" has three values
       * "Action &gt; 2022", "Action &gt; 2021" and "Sci-Fi &gt; 2022". If set
       * "restricted_values" to "Action &gt; 2022", the "category" facet only
       * contains "Action &gt; 2022". Only supported on textual fields. Maximum
       * is 10.
       * </pre>
       *
       * <code>repeated string restricted_values = 3;</code>
       *
       * @return A list containing the restrictedValues.
       */
      public com.google.protobuf.ProtocolStringList getRestrictedValuesList() {
        return restrictedValues_;
      }
      /**
       *
       *
       * <pre>
       * Only get facet for the given restricted values. Only supported on
       * textual fields. For example, suppose "category" has three values
       * "Action &gt; 2022", "Action &gt; 2021" and "Sci-Fi &gt; 2022". If set
       * "restricted_values" to "Action &gt; 2022", the "category" facet only
       * contains "Action &gt; 2022". Only supported on textual fields. Maximum
       * is 10.
       * </pre>
       *
       * <code>repeated string restricted_values = 3;</code>
       *
       * @return The count of restrictedValues.
       */
      public int getRestrictedValuesCount() {
        return restrictedValues_.size();
      }
      /**
       *
       *
       * <pre>
       * Only get facet for the given restricted values. Only supported on
       * textual fields. For example, suppose "category" has three values
       * "Action &gt; 2022", "Action &gt; 2021" and "Sci-Fi &gt; 2022". If set
       * "restricted_values" to "Action &gt; 2022", the "category" facet only
       * contains "Action &gt; 2022". Only supported on textual fields. Maximum
       * is 10.
       * </pre>
       *
       * <code>repeated string restricted_values = 3;</code>
       *
       * @param index The index of the element to return.
       * @return The restrictedValues at the given index.
       */
      public java.lang.String getRestrictedValues(int index) {
        return restrictedValues_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Only get facet for the given restricted values. Only supported on
       * textual fields. For example, suppose "category" has three values
       * "Action &gt; 2022", "Action &gt; 2021" and "Sci-Fi &gt; 2022". If set
       * "restricted_values" to "Action &gt; 2022", the "category" facet only
       * contains "Action &gt; 2022". Only supported on textual fields. Maximum
       * is 10.
       * </pre>
       *
       * <code>repeated string restricted_values = 3;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the restrictedValues at the given index.
       */
      public com.google.protobuf.ByteString getRestrictedValuesBytes(int index) {
        return restrictedValues_.getByteString(index);
      }

      public static final int PREFIXES_FIELD_NUMBER = 4;

      @SuppressWarnings("serial")
      private com.google.protobuf.LazyStringArrayList prefixes_ =
          com.google.protobuf.LazyStringArrayList.emptyList();
      /**
       *
       *
       * <pre>
       * Only get facet values that start with the given string prefix. For
       * example, suppose "category" has three values "Action &gt; 2022",
       * "Action &gt; 2021" and "Sci-Fi &gt; 2022". If set "prefixes" to "Action", the
       * "category" facet only contains "Action &gt; 2022" and "Action &gt; 2021".
       * Only supported on textual fields. Maximum is 10.
       * </pre>
       *
       * <code>repeated string prefixes = 4;</code>
       *
       * @return A list containing the prefixes.
       */
      public com.google.protobuf.ProtocolStringList getPrefixesList() {
        return prefixes_;
      }
      /**
       *
       *
       * <pre>
       * Only get facet values that start with the given string prefix. For
       * example, suppose "category" has three values "Action &gt; 2022",
       * "Action &gt; 2021" and "Sci-Fi &gt; 2022". If set "prefixes" to "Action", the
       * "category" facet only contains "Action &gt; 2022" and "Action &gt; 2021".
       * Only supported on textual fields. Maximum is 10.
       * </pre>
       *
       * <code>repeated string prefixes = 4;</code>
       *
       * @return The count of prefixes.
       */
      public int getPrefixesCount() {
        return prefixes_.size();
      }
      /**
       *
       *
       * <pre>
       * Only get facet values that start with the given string prefix. For
       * example, suppose "category" has three values "Action &gt; 2022",
       * "Action &gt; 2021" and "Sci-Fi &gt; 2022". If set "prefixes" to "Action", the
       * "category" facet only contains "Action &gt; 2022" and "Action &gt; 2021".
       * Only supported on textual fields. Maximum is 10.
       * </pre>
       *
       * <code>repeated string prefixes = 4;</code>
       *
       * @param index The index of the element to return.
       * @return The prefixes at the given index.
       */
      public java.lang.String getPrefixes(int index) {
        return prefixes_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Only get facet values that start with the given string prefix. For
       * example, suppose "category" has three values "Action &gt; 2022",
       * "Action &gt; 2021" and "Sci-Fi &gt; 2022". If set "prefixes" to "Action", the
       * "category" facet only contains "Action &gt; 2022" and "Action &gt; 2021".
       * Only supported on textual fields. Maximum is 10.
       * </pre>
       *
       * <code>repeated string prefixes = 4;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the prefixes at the given index.
       */
      public com.google.protobuf.ByteString getPrefixesBytes(int index) {
        return prefixes_.getByteString(index);
      }

      public static final int CONTAINS_FIELD_NUMBER = 5;

      @SuppressWarnings("serial")
      private com.google.protobuf.LazyStringArrayList contains_ =
          com.google.protobuf.LazyStringArrayList.emptyList();
      /**
       *
       *
       * <pre>
       * Only get facet values that contains the given strings. For example,
       * suppose "category" has three values "Action &gt; 2022",
       * "Action &gt; 2021" and "Sci-Fi &gt; 2022". If set "contains" to "2022", the
       * "category" facet only contains "Action &gt; 2022" and "Sci-Fi &gt; 2022".
       * Only supported on textual fields. Maximum is 10.
       * </pre>
       *
       * <code>repeated string contains = 5;</code>
       *
       * @return A list containing the contains.
       */
      public com.google.protobuf.ProtocolStringList getContainsList() {
        return contains_;
      }
      /**
       *
       *
       * <pre>
       * Only get facet values that contains the given strings. For example,
       * suppose "category" has three values "Action &gt; 2022",
       * "Action &gt; 2021" and "Sci-Fi &gt; 2022". If set "contains" to "2022", the
       * "category" facet only contains "Action &gt; 2022" and "Sci-Fi &gt; 2022".
       * Only supported on textual fields. Maximum is 10.
       * </pre>
       *
       * <code>repeated string contains = 5;</code>
       *
       * @return The count of contains.
       */
      public int getContainsCount() {
        return contains_.size();
      }
      /**
       *
       *
       * <pre>
       * Only get facet values that contains the given strings. For example,
       * suppose "category" has three values "Action &gt; 2022",
       * "Action &gt; 2021" and "Sci-Fi &gt; 2022". If set "contains" to "2022", the
       * "category" facet only contains "Action &gt; 2022" and "Sci-Fi &gt; 2022".
       * Only supported on textual fields. Maximum is 10.
       * </pre>
       *
       * <code>repeated string contains = 5;</code>
       *
       * @param index The index of the element to return.
       * @return The contains at the given index.
       */
      public java.lang.String getContains(int index) {
        return contains_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Only get facet values that contains the given strings. For example,
       * suppose "category" has three values "Action &gt; 2022",
       * "Action &gt; 2021" and "Sci-Fi &gt; 2022". If set "contains" to "2022", the
       * "category" facet only contains "Action &gt; 2022" and "Sci-Fi &gt; 2022".
       * Only supported on textual fields. Maximum is 10.
       * </pre>
       *
       * <code>repeated string contains = 5;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the contains at the given index.
       */
      public com.google.protobuf.ByteString getContainsBytes(int index) {
        return contains_.getByteString(index);
      }

      public static final int CASE_INSENSITIVE_FIELD_NUMBER = 6;
      private boolean caseInsensitive_ = false;
      /**
       *
       *
       * <pre>
       * True to make facet keys case insensitive when getting faceting
       * values with prefixes or contains; false otherwise.
       * </pre>
       *
       * <code>bool case_insensitive = 6;</code>
       *
       * @return The caseInsensitive.
       */
      @java.lang.Override
      public boolean getCaseInsensitive() {
        return caseInsensitive_;
      }

      public static final int ORDER_BY_FIELD_NUMBER = 7;

      @SuppressWarnings("serial")
      private volatile java.lang.Object orderBy_ = "";
      /**
       *
       *
       * <pre>
       * The order in which documents are returned.
       *
       * Allowed values are:
       *
       * * "count desc", which means order by
       * [SearchResponse.Facet.values.count][google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue.count]
       * descending.
       *
       * * "value desc", which means order by
       * [SearchResponse.Facet.values.value][google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue.value]
       * descending.
       *   Only applies to textual facets.
       *
       * If not set, textual values are sorted in [natural
       * order](https://en.wikipedia.org/wiki/Natural_sort_order); numerical
       * intervals are sorted in the order given by
       * [FacetSpec.FacetKey.intervals][google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey.intervals].
       * </pre>
       *
       * <code>string order_by = 7;</code>
       *
       * @return The orderBy.
       */
      @java.lang.Override
      public java.lang.String getOrderBy() {
        java.lang.Object ref = orderBy_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          orderBy_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * The order in which documents are returned.
       *
       * Allowed values are:
       *
       * * "count desc", which means order by
       * [SearchResponse.Facet.values.count][google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue.count]
       * descending.
       *
       * * "value desc", which means order by
       * [SearchResponse.Facet.values.value][google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue.value]
       * descending.
       *   Only applies to textual facets.
       *
       * If not set, textual values are sorted in [natural
       * order](https://en.wikipedia.org/wiki/Natural_sort_order); numerical
       * intervals are sorted in the order given by
       * [FacetSpec.FacetKey.intervals][google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey.intervals].
       * </pre>
       *
       * <code>string order_by = 7;</code>
       *
       * @return The bytes for orderBy.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getOrderByBytes() {
        java.lang.Object ref = orderBy_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          orderBy_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(key_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, key_);
        }
        for (int i = 0; i < intervals_.size(); i++) {
          output.writeMessage(2, intervals_.get(i));
        }
        for (int i = 0; i < restrictedValues_.size(); i++) {
          com.google.protobuf.GeneratedMessageV3.writeString(
              output, 3, restrictedValues_.getRaw(i));
        }
        for (int i = 0; i < prefixes_.size(); i++) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 4, prefixes_.getRaw(i));
        }
        for (int i = 0; i < contains_.size(); i++) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 5, contains_.getRaw(i));
        }
        if (caseInsensitive_ != false) {
          output.writeBool(6, caseInsensitive_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(orderBy_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 7, orderBy_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(key_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, key_);
        }
        for (int i = 0; i < intervals_.size(); i++) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, intervals_.get(i));
        }
        {
          int dataSize = 0;
          for (int i = 0; i < restrictedValues_.size(); i++) {
            dataSize += computeStringSizeNoTag(restrictedValues_.getRaw(i));
          }
          size += dataSize;
          size += 1 * getRestrictedValuesList().size();
        }
        {
          int dataSize = 0;
          for (int i = 0; i < prefixes_.size(); i++) {
            dataSize += computeStringSizeNoTag(prefixes_.getRaw(i));
          }
          size += dataSize;
          size += 1 * getPrefixesList().size();
        }
        {
          int dataSize = 0;
          for (int i = 0; i < contains_.size(); i++) {
            dataSize += computeStringSizeNoTag(contains_.getRaw(i));
          }
          size += dataSize;
          size += 1 * getContainsList().size();
        }
        if (caseInsensitive_ != false) {
          size += com.google.protobuf.CodedOutputStream.computeBoolSize(6, caseInsensitive_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(orderBy_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, orderBy_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof com.google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey)) {
          return super.equals(obj);
        }
        com.google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey other =
            (com.google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey) obj;

        if (!getKey().equals(other.getKey())) return false;
        if (!getIntervalsList().equals(other.getIntervalsList())) return false;
        if (!getRestrictedValuesList().equals(other.getRestrictedValuesList())) return false;
        if (!getPrefixesList().equals(other.getPrefixesList())) return false;
        if (!getContainsList().equals(other.getContainsList())) return false;
        if (getCaseInsensitive() != other.getCaseInsensitive()) return false;
        if (!getOrderBy().equals(other.getOrderBy())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + KEY_FIELD_NUMBER;
        hash = (53 * hash) + getKey().hashCode();
        if (getIntervalsCount() > 0) {
          hash = (37 * hash) + INTERVALS_FIELD_NUMBER;
          hash = (53 * hash) + getIntervalsList().hashCode();
        }
        if (getRestrictedValuesCount() > 0) {
          hash = (37 * hash) + RESTRICTED_VALUES_FIELD_NUMBER;
          hash = (53 * hash) + getRestrictedValuesList().hashCode();
        }
        if (getPrefixesCount() > 0) {
          hash = (37 * hash) + PREFIXES_FIELD_NUMBER;
          hash = (53 * hash) + getPrefixesList().hashCode();
        }
        if (getContainsCount() > 0) {
          hash = (37 * hash) + CONTAINS_FIELD_NUMBER;
          hash = (53 * hash) + getContainsList().hashCode();
        }
        hash = (37 * hash) + CASE_INSENSITIVE_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getCaseInsensitive());
        hash = (37 * hash) + ORDER_BY_FIELD_NUMBER;
        hash = (53 * hash) + getOrderBy().hashCode();
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Specifies how a facet is computed.
       * </pre>
       *
       * Protobuf type {@code google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey)
          com.google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKeyOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
              .internal_static_google_cloud_discoveryengine_v1beta_SearchRequest_FacetSpec_FacetKey_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
              .internal_static_google_cloud_discoveryengine_v1beta_SearchRequest_FacetSpec_FacetKey_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey.class,
                  com.google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey.Builder
                      .class);
        }

        // Construct using
        // com.google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          key_ = "";
          if (intervalsBuilder_ == null) {
            intervals_ = java.util.Collections.emptyList();
          } else {
            intervals_ = null;
            intervalsBuilder_.clear();
          }
          bitField0_ = (bitField0_ & ~0x00000002);
          restrictedValues_ = com.google.protobuf.LazyStringArrayList.emptyList();
          prefixes_ = com.google.protobuf.LazyStringArrayList.emptyList();
          contains_ = com.google.protobuf.LazyStringArrayList.emptyList();
          caseInsensitive_ = false;
          orderBy_ = "";
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
              .internal_static_google_cloud_discoveryengine_v1beta_SearchRequest_FacetSpec_FacetKey_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey
            getDefaultInstanceForType() {
          return com.google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey build() {
          com.google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey
            buildPartial() {
          com.google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey result =
              new com.google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey(this);
          buildPartialRepeatedFields(result);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartialRepeatedFields(
            com.google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey result) {
          if (intervalsBuilder_ == null) {
            if (((bitField0_ & 0x00000002) != 0)) {
              intervals_ = java.util.Collections.unmodifiableList(intervals_);
              bitField0_ = (bitField0_ & ~0x00000002);
            }
            result.intervals_ = intervals_;
          } else {
            result.intervals_ = intervalsBuilder_.build();
          }
        }

        private void buildPartial0(
            com.google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.key_ = key_;
          }
          if (((from_bitField0_ & 0x00000004) != 0)) {
            restrictedValues_.makeImmutable();
            result.restrictedValues_ = restrictedValues_;
          }
          if (((from_bitField0_ & 0x00000008) != 0)) {
            prefixes_.makeImmutable();
            result.prefixes_ = prefixes_;
          }
          if (((from_bitField0_ & 0x00000010) != 0)) {
            contains_.makeImmutable();
            result.contains_ = contains_;
          }
          if (((from_bitField0_ & 0x00000020) != 0)) {
            result.caseInsensitive_ = caseInsensitive_;
          }
          if (((from_bitField0_ & 0x00000040) != 0)) {
            result.orderBy_ = orderBy_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof com.google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey) {
            return mergeFrom(
                (com.google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey other) {
          if (other
              == com.google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey
                  .getDefaultInstance()) return this;
          if (!other.getKey().isEmpty()) {
            key_ = other.key_;
            bitField0_ |= 0x00000001;
            onChanged();
          }
          if (intervalsBuilder_ == null) {
            if (!other.intervals_.isEmpty()) {
              if (intervals_.isEmpty()) {
                intervals_ = other.intervals_;
                bitField0_ = (bitField0_ & ~0x00000002);
              } else {
                ensureIntervalsIsMutable();
                intervals_.addAll(other.intervals_);
              }
              onChanged();
            }
          } else {
            if (!other.intervals_.isEmpty()) {
              if (intervalsBuilder_.isEmpty()) {
                intervalsBuilder_.dispose();
                intervalsBuilder_ = null;
                intervals_ = other.intervals_;
                bitField0_ = (bitField0_ & ~0x00000002);
                intervalsBuilder_ =
                    com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                        ? getIntervalsFieldBuilder()
                        : null;
              } else {
                intervalsBuilder_.addAllMessages(other.intervals_);
              }
            }
          }
          if (!other.restrictedValues_.isEmpty()) {
            if (restrictedValues_.isEmpty()) {
              restrictedValues_ = other.restrictedValues_;
              bitField0_ |= 0x00000004;
            } else {
              ensureRestrictedValuesIsMutable();
              restrictedValues_.addAll(other.restrictedValues_);
            }
            onChanged();
          }
          if (!other.prefixes_.isEmpty()) {
            if (prefixes_.isEmpty()) {
              prefixes_ = other.prefixes_;
              bitField0_ |= 0x00000008;
            } else {
              ensurePrefixesIsMutable();
              prefixes_.addAll(other.prefixes_);
            }
            onChanged();
          }
          if (!other.contains_.isEmpty()) {
            if (contains_.isEmpty()) {
              contains_ = other.contains_;
              bitField0_ |= 0x00000010;
            } else {
              ensureContainsIsMutable();
              contains_.addAll(other.contains_);
            }
            onChanged();
          }
          if (other.getCaseInsensitive() != false) {
            setCaseInsensitive(other.getCaseInsensitive());
          }
          if (!other.getOrderBy().isEmpty()) {
            orderBy_ = other.orderBy_;
            bitField0_ |= 0x00000040;
            onChanged();
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    key_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                case 18:
                  {
                    com.google.cloud.discoveryengine.v1beta.Interval m =
                        input.readMessage(
                            com.google.cloud.discoveryengine.v1beta.Interval.parser(),
                            extensionRegistry);
                    if (intervalsBuilder_ == null) {
                      ensureIntervalsIsMutable();
                      intervals_.add(m);
                    } else {
                      intervalsBuilder_.addMessage(m);
                    }
                    break;
                  } // case 18
                case 26:
                  {
                    java.lang.String s = input.readStringRequireUtf8();
                    ensureRestrictedValuesIsMutable();
                    restrictedValues_.add(s);
                    break;
                  } // case 26
                case 34:
                  {
                    java.lang.String s = input.readStringRequireUtf8();
                    ensurePrefixesIsMutable();
                    prefixes_.add(s);
                    break;
                  } // case 34
                case 42:
                  {
                    java.lang.String s = input.readStringRequireUtf8();
                    ensureContainsIsMutable();
                    contains_.add(s);
                    break;
                  } // case 42
                case 48:
                  {
                    caseInsensitive_ = input.readBool();
                    bitField0_ |= 0x00000020;
                    break;
                  } // case 48
                case 58:
                  {
                    orderBy_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000040;
                    break;
                  } // case 58
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.lang.Object key_ = "";
        /**
         *
         *
         * <pre>
         * Required. Supported textual and numerical facet keys in
         * [Document][google.cloud.discoveryengine.v1beta.Document] object, over
         * which the facet values are computed. Facet key is case-sensitive.
         * </pre>
         *
         * <code>string key = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The key.
         */
        public java.lang.String getKey() {
          java.lang.Object ref = key_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            key_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. Supported textual and numerical facet keys in
         * [Document][google.cloud.discoveryengine.v1beta.Document] object, over
         * which the facet values are computed. Facet key is case-sensitive.
         * </pre>
         *
         * <code>string key = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The bytes for key.
         */
        public com.google.protobuf.ByteString getKeyBytes() {
          java.lang.Object ref = key_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            key_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. Supported textual and numerical facet keys in
         * [Document][google.cloud.discoveryengine.v1beta.Document] object, over
         * which the facet values are computed. Facet key is case-sensitive.
         * </pre>
         *
         * <code>string key = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param value The key to set.
         * @return This builder for chaining.
         */
        public Builder setKey(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          key_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. Supported textual and numerical facet keys in
         * [Document][google.cloud.discoveryengine.v1beta.Document] object, over
         * which the facet values are computed. Facet key is case-sensitive.
         * </pre>
         *
         * <code>string key = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearKey() {
          key_ = getDefaultInstance().getKey();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. Supported textual and numerical facet keys in
         * [Document][google.cloud.discoveryengine.v1beta.Document] object, over
         * which the facet values are computed. Facet key is case-sensitive.
         * </pre>
         *
         * <code>string key = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param value The bytes for key to set.
         * @return This builder for chaining.
         */
        public Builder setKeyBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          key_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        private java.util.List<com.google.cloud.discoveryengine.v1beta.Interval> intervals_ =
            java.util.Collections.emptyList();

        private void ensureIntervalsIsMutable() {
          if (!((bitField0_ & 0x00000002) != 0)) {
            intervals_ =
                new java.util.ArrayList<com.google.cloud.discoveryengine.v1beta.Interval>(
                    intervals_);
            bitField0_ |= 0x00000002;
          }
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.discoveryengine.v1beta.Interval,
                com.google.cloud.discoveryengine.v1beta.Interval.Builder,
                com.google.cloud.discoveryengine.v1beta.IntervalOrBuilder>
            intervalsBuilder_;

        /**
         *
         *
         * <pre>
         * Set only if values should be bucketed into intervals. Must be set
         * for facets with numerical values. Must not be set for facet with text
         * values. Maximum number of intervals is 30.
         * </pre>
         *
         * <code>repeated .google.cloud.discoveryengine.v1beta.Interval intervals = 2;</code>
         */
        public java.util.List<com.google.cloud.discoveryengine.v1beta.Interval> getIntervalsList() {
          if (intervalsBuilder_ == null) {
            return java.util.Collections.unmodifiableList(intervals_);
          } else {
            return intervalsBuilder_.getMessageList();
          }
        }
        /**
         *
         *
         * <pre>
         * Set only if values should be bucketed into intervals. Must be set
         * for facets with numerical values. Must not be set for facet with text
         * values. Maximum number of intervals is 30.
         * </pre>
         *
         * <code>repeated .google.cloud.discoveryengine.v1beta.Interval intervals = 2;</code>
         */
        public int getIntervalsCount() {
          if (intervalsBuilder_ == null) {
            return intervals_.size();
          } else {
            return intervalsBuilder_.getCount();
          }
        }
        /**
         *
         *
         * <pre>
         * Set only if values should be bucketed into intervals. Must be set
         * for facets with numerical values. Must not be set for facet with text
         * values. Maximum number of intervals is 30.
         * </pre>
         *
         * <code>repeated .google.cloud.discoveryengine.v1beta.Interval intervals = 2;</code>
         */
        public com.google.cloud.discoveryengine.v1beta.Interval getIntervals(int index) {
          if (intervalsBuilder_ == null) {
            return intervals_.get(index);
          } else {
            return intervalsBuilder_.getMessage(index);
          }
        }
        /**
         *
         *
         * <pre>
         * Set only if values should be bucketed into intervals. Must be set
         * for facets with numerical values. Must not be set for facet with text
         * values. Maximum number of intervals is 30.
         * </pre>
         *
         * <code>repeated .google.cloud.discoveryengine.v1beta.Interval intervals = 2;</code>
         */
        public Builder setIntervals(
            int index, com.google.cloud.discoveryengine.v1beta.Interval value) {
          if (intervalsBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureIntervalsIsMutable();
            intervals_.set(index, value);
            onChanged();
          } else {
            intervalsBuilder_.setMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Set only if values should be bucketed into intervals. Must be set
         * for facets with numerical values. Must not be set for facet with text
         * values. Maximum number of intervals is 30.
         * </pre>
         *
         * <code>repeated .google.cloud.discoveryengine.v1beta.Interval intervals = 2;</code>
         */
        public Builder setIntervals(
            int index, com.google.cloud.discoveryengine.v1beta.Interval.Builder builderForValue) {
          if (intervalsBuilder_ == null) {
            ensureIntervalsIsMutable();
            intervals_.set(index, builderForValue.build());
            onChanged();
          } else {
            intervalsBuilder_.setMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Set only if values should be bucketed into intervals. Must be set
         * for facets with numerical values. Must not be set for facet with text
         * values. Maximum number of intervals is 30.
         * </pre>
         *
         * <code>repeated .google.cloud.discoveryengine.v1beta.Interval intervals = 2;</code>
         */
        public Builder addIntervals(com.google.cloud.discoveryengine.v1beta.Interval value) {
          if (intervalsBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureIntervalsIsMutable();
            intervals_.add(value);
            onChanged();
          } else {
            intervalsBuilder_.addMessage(value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Set only if values should be bucketed into intervals. Must be set
         * for facets with numerical values. Must not be set for facet with text
         * values. Maximum number of intervals is 30.
         * </pre>
         *
         * <code>repeated .google.cloud.discoveryengine.v1beta.Interval intervals = 2;</code>
         */
        public Builder addIntervals(
            int index, com.google.cloud.discoveryengine.v1beta.Interval value) {
          if (intervalsBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureIntervalsIsMutable();
            intervals_.add(index, value);
            onChanged();
          } else {
            intervalsBuilder_.addMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Set only if values should be bucketed into intervals. Must be set
         * for facets with numerical values. Must not be set for facet with text
         * values. Maximum number of intervals is 30.
         * </pre>
         *
         * <code>repeated .google.cloud.discoveryengine.v1beta.Interval intervals = 2;</code>
         */
        public Builder addIntervals(
            com.google.cloud.discoveryengine.v1beta.Interval.Builder builderForValue) {
          if (intervalsBuilder_ == null) {
            ensureIntervalsIsMutable();
            intervals_.add(builderForValue.build());
            onChanged();
          } else {
            intervalsBuilder_.addMessage(builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Set only if values should be bucketed into intervals. Must be set
         * for facets with numerical values. Must not be set for facet with text
         * values. Maximum number of intervals is 30.
         * </pre>
         *
         * <code>repeated .google.cloud.discoveryengine.v1beta.Interval intervals = 2;</code>
         */
        public Builder addIntervals(
            int index, com.google.cloud.discoveryengine.v1beta.Interval.Builder builderForValue) {
          if (intervalsBuilder_ == null) {
            ensureIntervalsIsMutable();
            intervals_.add(index, builderForValue.build());
            onChanged();
          } else {
            intervalsBuilder_.addMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Set only if values should be bucketed into intervals. Must be set
         * for facets with numerical values. Must not be set for facet with text
         * values. Maximum number of intervals is 30.
         * </pre>
         *
         * <code>repeated .google.cloud.discoveryengine.v1beta.Interval intervals = 2;</code>
         */
        public Builder addAllIntervals(
            java.lang.Iterable<? extends com.google.cloud.discoveryengine.v1beta.Interval> values) {
          if (intervalsBuilder_ == null) {
            ensureIntervalsIsMutable();
            com.google.protobuf.AbstractMessageLite.Builder.addAll(values, intervals_);
            onChanged();
          } else {
            intervalsBuilder_.addAllMessages(values);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Set only if values should be bucketed into intervals. Must be set
         * for facets with numerical values. Must not be set for facet with text
         * values. Maximum number of intervals is 30.
         * </pre>
         *
         * <code>repeated .google.cloud.discoveryengine.v1beta.Interval intervals = 2;</code>
         */
        public Builder clearIntervals() {
          if (intervalsBuilder_ == null) {
            intervals_ = java.util.Collections.emptyList();
            bitField0_ = (bitField0_ & ~0x00000002);
            onChanged();
          } else {
            intervalsBuilder_.clear();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Set only if values should be bucketed into intervals. Must be set
         * for facets with numerical values. Must not be set for facet with text
         * values. Maximum number of intervals is 30.
         * </pre>
         *
         * <code>repeated .google.cloud.discoveryengine.v1beta.Interval intervals = 2;</code>
         */
        public Builder removeIntervals(int index) {
          if (intervalsBuilder_ == null) {
            ensureIntervalsIsMutable();
            intervals_.remove(index);
            onChanged();
          } else {
            intervalsBuilder_.remove(index);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Set only if values should be bucketed into intervals. Must be set
         * for facets with numerical values. Must not be set for facet with text
         * values. Maximum number of intervals is 30.
         * </pre>
         *
         * <code>repeated .google.cloud.discoveryengine.v1beta.Interval intervals = 2;</code>
         */
        public com.google.cloud.discoveryengine.v1beta.Interval.Builder getIntervalsBuilder(
            int index) {
          return getIntervalsFieldBuilder().getBuilder(index);
        }
        /**
         *
         *
         * <pre>
         * Set only if values should be bucketed into intervals. Must be set
         * for facets with numerical values. Must not be set for facet with text
         * values. Maximum number of intervals is 30.
         * </pre>
         *
         * <code>repeated .google.cloud.discoveryengine.v1beta.Interval intervals = 2;</code>
         */
        public com.google.cloud.discoveryengine.v1beta.IntervalOrBuilder getIntervalsOrBuilder(
            int index) {
          if (intervalsBuilder_ == null) {
            return intervals_.get(index);
          } else {
            return intervalsBuilder_.getMessageOrBuilder(index);
          }
        }
        /**
         *
         *
         * <pre>
         * Set only if values should be bucketed into intervals. Must be set
         * for facets with numerical values. Must not be set for facet with text
         * values. Maximum number of intervals is 30.
         * </pre>
         *
         * <code>repeated .google.cloud.discoveryengine.v1beta.Interval intervals = 2;</code>
         */
        public java.util.List<? extends com.google.cloud.discoveryengine.v1beta.IntervalOrBuilder>
            getIntervalsOrBuilderList() {
          if (intervalsBuilder_ != null) {
            return intervalsBuilder_.getMessageOrBuilderList();
          } else {
            return java.util.Collections.unmodifiableList(intervals_);
          }
        }
        /**
         *
         *
         * <pre>
         * Set only if values should be bucketed into intervals. Must be set
         * for facets with numerical values. Must not be set for facet with text
         * values. Maximum number of intervals is 30.
         * </pre>
         *
         * <code>repeated .google.cloud.discoveryengine.v1beta.Interval intervals = 2;</code>
         */
        public com.google.cloud.discoveryengine.v1beta.Interval.Builder addIntervalsBuilder() {
          return getIntervalsFieldBuilder()
              .addBuilder(com.google.cloud.discoveryengine.v1beta.Interval.getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * Set only if values should be bucketed into intervals. Must be set
         * for facets with numerical values. Must not be set for facet with text
         * values. Maximum number of intervals is 30.
         * </pre>
         *
         * <code>repeated .google.cloud.discoveryengine.v1beta.Interval intervals = 2;</code>
         */
        public com.google.cloud.discoveryengine.v1beta.Interval.Builder addIntervalsBuilder(
            int index) {
          return getIntervalsFieldBuilder()
              .addBuilder(
                  index, com.google.cloud.discoveryengine.v1beta.Interval.getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * Set only if values should be bucketed into intervals. Must be set
         * for facets with numerical values. Must not be set for facet with text
         * values. Maximum number of intervals is 30.
         * </pre>
         *
         * <code>repeated .google.cloud.discoveryengine.v1beta.Interval intervals = 2;</code>
         */
        public java.util.List<com.google.cloud.discoveryengine.v1beta.Interval.Builder>
            getIntervalsBuilderList() {
          return getIntervalsFieldBuilder().getBuilderList();
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.discoveryengine.v1beta.Interval,
                com.google.cloud.discoveryengine.v1beta.Interval.Builder,
                com.google.cloud.discoveryengine.v1beta.IntervalOrBuilder>
            getIntervalsFieldBuilder() {
          if (intervalsBuilder_ == null) {
            intervalsBuilder_ =
                new com.google.protobuf.RepeatedFieldBuilderV3<
                    com.google.cloud.discoveryengine.v1beta.Interval,
                    com.google.cloud.discoveryengine.v1beta.Interval.Builder,
                    com.google.cloud.discoveryengine.v1beta.IntervalOrBuilder>(
                    intervals_,
                    ((bitField0_ & 0x00000002) != 0),
                    getParentForChildren(),
                    isClean());
            intervals_ = null;
          }
          return intervalsBuilder_;
        }

        private com.google.protobuf.LazyStringArrayList restrictedValues_ =
            com.google.protobuf.LazyStringArrayList.emptyList();

        private void ensureRestrictedValuesIsMutable() {
          if (!restrictedValues_.isModifiable()) {
            restrictedValues_ = new com.google.protobuf.LazyStringArrayList(restrictedValues_);
          }
          bitField0_ |= 0x00000004;
        }
        /**
         *
         *
         * <pre>
         * Only get facet for the given restricted values. Only supported on
         * textual fields. For example, suppose "category" has three values
         * "Action &gt; 2022", "Action &gt; 2021" and "Sci-Fi &gt; 2022". If set
         * "restricted_values" to "Action &gt; 2022", the "category" facet only
         * contains "Action &gt; 2022". Only supported on textual fields. Maximum
         * is 10.
         * </pre>
         *
         * <code>repeated string restricted_values = 3;</code>
         *
         * @return A list containing the restrictedValues.
         */
        public com.google.protobuf.ProtocolStringList getRestrictedValuesList() {
          restrictedValues_.makeImmutable();
          return restrictedValues_;
        }
        /**
         *
         *
         * <pre>
         * Only get facet for the given restricted values. Only supported on
         * textual fields. For example, suppose "category" has three values
         * "Action &gt; 2022", "Action &gt; 2021" and "Sci-Fi &gt; 2022". If set
         * "restricted_values" to "Action &gt; 2022", the "category" facet only
         * contains "Action &gt; 2022". Only supported on textual fields. Maximum
         * is 10.
         * </pre>
         *
         * <code>repeated string restricted_values = 3;</code>
         *
         * @return The count of restrictedValues.
         */
        public int getRestrictedValuesCount() {
          return restrictedValues_.size();
        }
        /**
         *
         *
         * <pre>
         * Only get facet for the given restricted values. Only supported on
         * textual fields. For example, suppose "category" has three values
         * "Action &gt; 2022", "Action &gt; 2021" and "Sci-Fi &gt; 2022". If set
         * "restricted_values" to "Action &gt; 2022", the "category" facet only
         * contains "Action &gt; 2022". Only supported on textual fields. Maximum
         * is 10.
         * </pre>
         *
         * <code>repeated string restricted_values = 3;</code>
         *
         * @param index The index of the element to return.
         * @return The restrictedValues at the given index.
         */
        public java.lang.String getRestrictedValues(int index) {
          return restrictedValues_.get(index);
        }
        /**
         *
         *
         * <pre>
         * Only get facet for the given restricted values. Only supported on
         * textual fields. For example, suppose "category" has three values
         * "Action &gt; 2022", "Action &gt; 2021" and "Sci-Fi &gt; 2022". If set
         * "restricted_values" to "Action &gt; 2022", the "category" facet only
         * contains "Action &gt; 2022". Only supported on textual fields. Maximum
         * is 10.
         * </pre>
         *
         * <code>repeated string restricted_values = 3;</code>
         *
         * @param index The index of the value to return.
         * @return The bytes of the restrictedValues at the given index.
         */
        public com.google.protobuf.ByteString getRestrictedValuesBytes(int index) {
          return restrictedValues_.getByteString(index);
        }
        /**
         *
         *
         * <pre>
         * Only get facet for the given restricted values. Only supported on
         * textual fields. For example, suppose "category" has three values
         * "Action &gt; 2022", "Action &gt; 2021" and "Sci-Fi &gt; 2022". If set
         * "restricted_values" to "Action &gt; 2022", the "category" facet only
         * contains "Action &gt; 2022". Only supported on textual fields. Maximum
         * is 10.
         * </pre>
         *
         * <code>repeated string restricted_values = 3;</code>
         *
         * @param index The index to set the value at.
         * @param value The restrictedValues to set.
         * @return This builder for chaining.
         */
        public Builder setRestrictedValues(int index, java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureRestrictedValuesIsMutable();
          restrictedValues_.set(index, value);
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Only get facet for the given restricted values. Only supported on
         * textual fields. For example, suppose "category" has three values
         * "Action &gt; 2022", "Action &gt; 2021" and "Sci-Fi &gt; 2022". If set
         * "restricted_values" to "Action &gt; 2022", the "category" facet only
         * contains "Action &gt; 2022". Only supported on textual fields. Maximum
         * is 10.
         * </pre>
         *
         * <code>repeated string restricted_values = 3;</code>
         *
         * @param value The restrictedValues to add.
         * @return This builder for chaining.
         */
        public Builder addRestrictedValues(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureRestrictedValuesIsMutable();
          restrictedValues_.add(value);
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Only get facet for the given restricted values. Only supported on
         * textual fields. For example, suppose "category" has three values
         * "Action &gt; 2022", "Action &gt; 2021" and "Sci-Fi &gt; 2022". If set
         * "restricted_values" to "Action &gt; 2022", the "category" facet only
         * contains "Action &gt; 2022". Only supported on textual fields. Maximum
         * is 10.
         * </pre>
         *
         * <code>repeated string restricted_values = 3;</code>
         *
         * @param values The restrictedValues to add.
         * @return This builder for chaining.
         */
        public Builder addAllRestrictedValues(java.lang.Iterable<java.lang.String> values) {
          ensureRestrictedValuesIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, restrictedValues_);
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Only get facet for the given restricted values. Only supported on
         * textual fields. For example, suppose "category" has three values
         * "Action &gt; 2022", "Action &gt; 2021" and "Sci-Fi &gt; 2022". If set
         * "restricted_values" to "Action &gt; 2022", the "category" facet only
         * contains "Action &gt; 2022". Only supported on textual fields. Maximum
         * is 10.
         * </pre>
         *
         * <code>repeated string restricted_values = 3;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearRestrictedValues() {
          restrictedValues_ = com.google.protobuf.LazyStringArrayList.emptyList();
          bitField0_ = (bitField0_ & ~0x00000004);
          ;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Only get facet for the given restricted values. Only supported on
         * textual fields. For example, suppose "category" has three values
         * "Action &gt; 2022", "Action &gt; 2021" and "Sci-Fi &gt; 2022". If set
         * "restricted_values" to "Action &gt; 2022", the "category" facet only
         * contains "Action &gt; 2022". Only supported on textual fields. Maximum
         * is 10.
         * </pre>
         *
         * <code>repeated string restricted_values = 3;</code>
         *
         * @param value The bytes of the restrictedValues to add.
         * @return This builder for chaining.
         */
        public Builder addRestrictedValuesBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          ensureRestrictedValuesIsMutable();
          restrictedValues_.add(value);
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }

        private com.google.protobuf.LazyStringArrayList prefixes_ =
            com.google.protobuf.LazyStringArrayList.emptyList();

        private void ensurePrefixesIsMutable() {
          if (!prefixes_.isModifiable()) {
            prefixes_ = new com.google.protobuf.LazyStringArrayList(prefixes_);
          }
          bitField0_ |= 0x00000008;
        }
        /**
         *
         *
         * <pre>
         * Only get facet values that start with the given string prefix. For
         * example, suppose "category" has three values "Action &gt; 2022",
         * "Action &gt; 2021" and "Sci-Fi &gt; 2022". If set "prefixes" to "Action", the
         * "category" facet only contains "Action &gt; 2022" and "Action &gt; 2021".
         * Only supported on textual fields. Maximum is 10.
         * </pre>
         *
         * <code>repeated string prefixes = 4;</code>
         *
         * @return A list containing the prefixes.
         */
        public com.google.protobuf.ProtocolStringList getPrefixesList() {
          prefixes_.makeImmutable();
          return prefixes_;
        }
        /**
         *
         *
         * <pre>
         * Only get facet values that start with the given string prefix. For
         * example, suppose "category" has three values "Action &gt; 2022",
         * "Action &gt; 2021" and "Sci-Fi &gt; 2022". If set "prefixes" to "Action", the
         * "category" facet only contains "Action &gt; 2022" and "Action &gt; 2021".
         * Only supported on textual fields. Maximum is 10.
         * </pre>
         *
         * <code>repeated string prefixes = 4;</code>
         *
         * @return The count of prefixes.
         */
        public int getPrefixesCount() {
          return prefixes_.size();
        }
        /**
         *
         *
         * <pre>
         * Only get facet values that start with the given string prefix. For
         * example, suppose "category" has three values "Action &gt; 2022",
         * "Action &gt; 2021" and "Sci-Fi &gt; 2022". If set "prefixes" to "Action", the
         * "category" facet only contains "Action &gt; 2022" and "Action &gt; 2021".
         * Only supported on textual fields. Maximum is 10.
         * </pre>
         *
         * <code>repeated string prefixes = 4;</code>
         *
         * @param index The index of the element to return.
         * @return The prefixes at the given index.
         */
        public java.lang.String getPrefixes(int index) {
          return prefixes_.get(index);
        }
        /**
         *
         *
         * <pre>
         * Only get facet values that start with the given string prefix. For
         * example, suppose "category" has three values "Action &gt; 2022",
         * "Action &gt; 2021" and "Sci-Fi &gt; 2022". If set "prefixes" to "Action", the
         * "category" facet only contains "Action &gt; 2022" and "Action &gt; 2021".
         * Only supported on textual fields. Maximum is 10.
         * </pre>
         *
         * <code>repeated string prefixes = 4;</code>
         *
         * @param index The index of the value to return.
         * @return The bytes of the prefixes at the given index.
         */
        public com.google.protobuf.ByteString getPrefixesBytes(int index) {
          return prefixes_.getByteString(index);
        }
        /**
         *
         *
         * <pre>
         * Only get facet values that start with the given string prefix. For
         * example, suppose "category" has three values "Action &gt; 2022",
         * "Action &gt; 2021" and "Sci-Fi &gt; 2022". If set "prefixes" to "Action", the
         * "category" facet only contains "Action &gt; 2022" and "Action &gt; 2021".
         * Only supported on textual fields. Maximum is 10.
         * </pre>
         *
         * <code>repeated string prefixes = 4;</code>
         *
         * @param index The index to set the value at.
         * @param value The prefixes to set.
         * @return This builder for chaining.
         */
        public Builder setPrefixes(int index, java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensurePrefixesIsMutable();
          prefixes_.set(index, value);
          bitField0_ |= 0x00000008;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Only get facet values that start with the given string prefix. For
         * example, suppose "category" has three values "Action &gt; 2022",
         * "Action &gt; 2021" and "Sci-Fi &gt; 2022". If set "prefixes" to "Action", the
         * "category" facet only contains "Action &gt; 2022" and "Action &gt; 2021".
         * Only supported on textual fields. Maximum is 10.
         * </pre>
         *
         * <code>repeated string prefixes = 4;</code>
         *
         * @param value The prefixes to add.
         * @return This builder for chaining.
         */
        public Builder addPrefixes(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensurePrefixesIsMutable();
          prefixes_.add(value);
          bitField0_ |= 0x00000008;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Only get facet values that start with the given string prefix. For
         * example, suppose "category" has three values "Action &gt; 2022",
         * "Action &gt; 2021" and "Sci-Fi &gt; 2022". If set "prefixes" to "Action", the
         * "category" facet only contains "Action &gt; 2022" and "Action &gt; 2021".
         * Only supported on textual fields. Maximum is 10.
         * </pre>
         *
         * <code>repeated string prefixes = 4;</code>
         *
         * @param values The prefixes to add.
         * @return This builder for chaining.
         */
        public Builder addAllPrefixes(java.lang.Iterable<java.lang.String> values) {
          ensurePrefixesIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, prefixes_);
          bitField0_ |= 0x00000008;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Only get facet values that start with the given string prefix. For
         * example, suppose "category" has three values "Action &gt; 2022",
         * "Action &gt; 2021" and "Sci-Fi &gt; 2022". If set "prefixes" to "Action", the
         * "category" facet only contains "Action &gt; 2022" and "Action &gt; 2021".
         * Only supported on textual fields. Maximum is 10.
         * </pre>
         *
         * <code>repeated string prefixes = 4;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearPrefixes() {
          prefixes_ = com.google.protobuf.LazyStringArrayList.emptyList();
          bitField0_ = (bitField0_ & ~0x00000008);
          ;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Only get facet values that start with the given string prefix. For
         * example, suppose "category" has three values "Action &gt; 2022",
         * "Action &gt; 2021" and "Sci-Fi &gt; 2022". If set "prefixes" to "Action", the
         * "category" facet only contains "Action &gt; 2022" and "Action &gt; 2021".
         * Only supported on textual fields. Maximum is 10.
         * </pre>
         *
         * <code>repeated string prefixes = 4;</code>
         *
         * @param value The bytes of the prefixes to add.
         * @return This builder for chaining.
         */
        public Builder addPrefixesBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          ensurePrefixesIsMutable();
          prefixes_.add(value);
          bitField0_ |= 0x00000008;
          onChanged();
          return this;
        }

        private com.google.protobuf.LazyStringArrayList contains_ =
            com.google.protobuf.LazyStringArrayList.emptyList();

        private void ensureContainsIsMutable() {
          if (!contains_.isModifiable()) {
            contains_ = new com.google.protobuf.LazyStringArrayList(contains_);
          }
          bitField0_ |= 0x00000010;
        }
        /**
         *
         *
         * <pre>
         * Only get facet values that contains the given strings. For example,
         * suppose "category" has three values "Action &gt; 2022",
         * "Action &gt; 2021" and "Sci-Fi &gt; 2022". If set "contains" to "2022", the
         * "category" facet only contains "Action &gt; 2022" and "Sci-Fi &gt; 2022".
         * Only supported on textual fields. Maximum is 10.
         * </pre>
         *
         * <code>repeated string contains = 5;</code>
         *
         * @return A list containing the contains.
         */
        public com.google.protobuf.ProtocolStringList getContainsList() {
          contains_.makeImmutable();
          return contains_;
        }
        /**
         *
         *
         * <pre>
         * Only get facet values that contains the given strings. For example,
         * suppose "category" has three values "Action &gt; 2022",
         * "Action &gt; 2021" and "Sci-Fi &gt; 2022". If set "contains" to "2022", the
         * "category" facet only contains "Action &gt; 2022" and "Sci-Fi &gt; 2022".
         * Only supported on textual fields. Maximum is 10.
         * </pre>
         *
         * <code>repeated string contains = 5;</code>
         *
         * @return The count of contains.
         */
        public int getContainsCount() {
          return contains_.size();
        }
        /**
         *
         *
         * <pre>
         * Only get facet values that contains the given strings. For example,
         * suppose "category" has three values "Action &gt; 2022",
         * "Action &gt; 2021" and "Sci-Fi &gt; 2022". If set "contains" to "2022", the
         * "category" facet only contains "Action &gt; 2022" and "Sci-Fi &gt; 2022".
         * Only supported on textual fields. Maximum is 10.
         * </pre>
         *
         * <code>repeated string contains = 5;</code>
         *
         * @param index The index of the element to return.
         * @return The contains at the given index.
         */
        public java.lang.String getContains(int index) {
          return contains_.get(index);
        }
        /**
         *
         *
         * <pre>
         * Only get facet values that contains the given strings. For example,
         * suppose "category" has three values "Action &gt; 2022",
         * "Action &gt; 2021" and "Sci-Fi &gt; 2022". If set "contains" to "2022", the
         * "category" facet only contains "Action &gt; 2022" and "Sci-Fi &gt; 2022".
         * Only supported on textual fields. Maximum is 10.
         * </pre>
         *
         * <code>repeated string contains = 5;</code>
         *
         * @param index The index of the value to return.
         * @return The bytes of the contains at the given index.
         */
        public com.google.protobuf.ByteString getContainsBytes(int index) {
          return contains_.getByteString(index);
        }
        /**
         *
         *
         * <pre>
         * Only get facet values that contains the given strings. For example,
         * suppose "category" has three values "Action &gt; 2022",
         * "Action &gt; 2021" and "Sci-Fi &gt; 2022". If set "contains" to "2022", the
         * "category" facet only contains "Action &gt; 2022" and "Sci-Fi &gt; 2022".
         * Only supported on textual fields. Maximum is 10.
         * </pre>
         *
         * <code>repeated string contains = 5;</code>
         *
         * @param index The index to set the value at.
         * @param value The contains to set.
         * @return This builder for chaining.
         */
        public Builder setContains(int index, java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureContainsIsMutable();
          contains_.set(index, value);
          bitField0_ |= 0x00000010;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Only get facet values that contains the given strings. For example,
         * suppose "category" has three values "Action &gt; 2022",
         * "Action &gt; 2021" and "Sci-Fi &gt; 2022". If set "contains" to "2022", the
         * "category" facet only contains "Action &gt; 2022" and "Sci-Fi &gt; 2022".
         * Only supported on textual fields. Maximum is 10.
         * </pre>
         *
         * <code>repeated string contains = 5;</code>
         *
         * @param value The contains to add.
         * @return This builder for chaining.
         */
        public Builder addContains(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureContainsIsMutable();
          contains_.add(value);
          bitField0_ |= 0x00000010;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Only get facet values that contains the given strings. For example,
         * suppose "category" has three values "Action &gt; 2022",
         * "Action &gt; 2021" and "Sci-Fi &gt; 2022". If set "contains" to "2022", the
         * "category" facet only contains "Action &gt; 2022" and "Sci-Fi &gt; 2022".
         * Only supported on textual fields. Maximum is 10.
         * </pre>
         *
         * <code>repeated string contains = 5;</code>
         *
         * @param values The contains to add.
         * @return This builder for chaining.
         */
        public Builder addAllContains(java.lang.Iterable<java.lang.String> values) {
          ensureContainsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, contains_);
          bitField0_ |= 0x00000010;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Only get facet values that contains the given strings. For example,
         * suppose "category" has three values "Action &gt; 2022",
         * "Action &gt; 2021" and "Sci-Fi &gt; 2022". If set "contains" to "2022", the
         * "category" facet only contains "Action &gt; 2022" and "Sci-Fi &gt; 2022".
         * Only supported on textual fields. Maximum is 10.
         * </pre>
         *
         * <code>repeated string contains = 5;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearContains() {
          contains_ = com.google.protobuf.LazyStringArrayList.emptyList();
          bitField0_ = (bitField0_ & ~0x00000010);
          ;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Only get facet values that contains the given strings. For example,
         * suppose "category" has three values "Action &gt; 2022",
         * "Action &gt; 2021" and "Sci-Fi &gt; 2022". If set "contains" to "2022", the
         * "category" facet only contains "Action &gt; 2022" and "Sci-Fi &gt; 2022".
         * Only supported on textual fields. Maximum is 10.
         * </pre>
         *
         * <code>repeated string contains = 5;</code>
         *
         * @param value The bytes of the contains to add.
         * @return This builder for chaining.
         */
        public Builder addContainsBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          ensureContainsIsMutable();
          contains_.add(value);
          bitField0_ |= 0x00000010;
          onChanged();
          return this;
        }

        private boolean caseInsensitive_;
        /**
         *
         *
         * <pre>
         * True to make facet keys case insensitive when getting faceting
         * values with prefixes or contains; false otherwise.
         * </pre>
         *
         * <code>bool case_insensitive = 6;</code>
         *
         * @return The caseInsensitive.
         */
        @java.lang.Override
        public boolean getCaseInsensitive() {
          return caseInsensitive_;
        }
        /**
         *
         *
         * <pre>
         * True to make facet keys case insensitive when getting faceting
         * values with prefixes or contains; false otherwise.
         * </pre>
         *
         * <code>bool case_insensitive = 6;</code>
         *
         * @param value The caseInsensitive to set.
         * @return This builder for chaining.
         */
        public Builder setCaseInsensitive(boolean value) {

          caseInsensitive_ = value;
          bitField0_ |= 0x00000020;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * True to make facet keys case insensitive when getting faceting
         * values with prefixes or contains; false otherwise.
         * </pre>
         *
         * <code>bool case_insensitive = 6;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearCaseInsensitive() {
          bitField0_ = (bitField0_ & ~0x00000020);
          caseInsensitive_ = false;
          onChanged();
          return this;
        }

        private java.lang.Object orderBy_ = "";
        /**
         *
         *
         * <pre>
         * The order in which documents are returned.
         *
         * Allowed values are:
         *
         * * "count desc", which means order by
         * [SearchResponse.Facet.values.count][google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue.count]
         * descending.
         *
         * * "value desc", which means order by
         * [SearchResponse.Facet.values.value][google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue.value]
         * descending.
         *   Only applies to textual facets.
         *
         * If not set, textual values are sorted in [natural
         * order](https://en.wikipedia.org/wiki/Natural_sort_order); numerical
         * intervals are sorted in the order given by
         * [FacetSpec.FacetKey.intervals][google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey.intervals].
         * </pre>
         *
         * <code>string order_by = 7;</code>
         *
         * @return The orderBy.
         */
        public java.lang.String getOrderBy() {
          java.lang.Object ref = orderBy_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            orderBy_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * The order in which documents are returned.
         *
         * Allowed values are:
         *
         * * "count desc", which means order by
         * [SearchResponse.Facet.values.count][google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue.count]
         * descending.
         *
         * * "value desc", which means order by
         * [SearchResponse.Facet.values.value][google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue.value]
         * descending.
         *   Only applies to textual facets.
         *
         * If not set, textual values are sorted in [natural
         * order](https://en.wikipedia.org/wiki/Natural_sort_order); numerical
         * intervals are sorted in the order given by
         * [FacetSpec.FacetKey.intervals][google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey.intervals].
         * </pre>
         *
         * <code>string order_by = 7;</code>
         *
         * @return The bytes for orderBy.
         */
        public com.google.protobuf.ByteString getOrderByBytes() {
          java.lang.Object ref = orderBy_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            orderBy_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * The order in which documents are returned.
         *
         * Allowed values are:
         *
         * * "count desc", which means order by
         * [SearchResponse.Facet.values.count][google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue.count]
         * descending.
         *
         * * "value desc", which means order by
         * [SearchResponse.Facet.values.value][google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue.value]
         * descending.
         *   Only applies to textual facets.
         *
         * If not set, textual values are sorted in [natural
         * order](https://en.wikipedia.org/wiki/Natural_sort_order); numerical
         * intervals are sorted in the order given by
         * [FacetSpec.FacetKey.intervals][google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey.intervals].
         * </pre>
         *
         * <code>string order_by = 7;</code>
         *
         * @param value The orderBy to set.
         * @return This builder for chaining.
         */
        public Builder setOrderBy(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          orderBy_ = value;
          bitField0_ |= 0x00000040;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The order in which documents are returned.
         *
         * Allowed values are:
         *
         * * "count desc", which means order by
         * [SearchResponse.Facet.values.count][google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue.count]
         * descending.
         *
         * * "value desc", which means order by
         * [SearchResponse.Facet.values.value][google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue.value]
         * descending.
         *   Only applies to textual facets.
         *
         * If not set, textual values are sorted in [natural
         * order](https://en.wikipedia.org/wiki/Natural_sort_order); numerical
         * intervals are sorted in the order given by
         * [FacetSpec.FacetKey.intervals][google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey.intervals].
         * </pre>
         *
         * <code>string order_by = 7;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearOrderBy() {
          orderBy_ = getDefaultInstance().getOrderBy();
          bitField0_ = (bitField0_ & ~0x00000040);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The order in which documents are returned.
         *
         * Allowed values are:
         *
         * * "count desc", which means order by
         * [SearchResponse.Facet.values.count][google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue.count]
         * descending.
         *
         * * "value desc", which means order by
         * [SearchResponse.Facet.values.value][google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue.value]
         * descending.
         *   Only applies to textual facets.
         *
         * If not set, textual values are sorted in [natural
         * order](https://en.wikipedia.org/wiki/Natural_sort_order); numerical
         * intervals are sorted in the order given by
         * [FacetSpec.FacetKey.intervals][google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey.intervals].
         * </pre>
         *
         * <code>string order_by = 7;</code>
         *
         * @param value The bytes for orderBy to set.
         * @return This builder for chaining.
         */
        public Builder setOrderByBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          orderBy_ = value;
          bitField0_ |= 0x00000040;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey)
      private static final com.google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey();
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<FacetKey> PARSER =
          new com.google.protobuf.AbstractParser<FacetKey>() {
            @java.lang.Override
            public FacetKey parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<FacetKey> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<FacetKey> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    private int bitField0_;
    public static final int FACET_KEY_FIELD_NUMBER = 1;
    private com.google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey facetKey_;
    /**
     *
     *
     * <pre>
     * Required. The facet key specification.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey facet_key = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the facetKey field is set.
     */
    @java.lang.Override
    public boolean hasFacetKey() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. The facet key specification.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey facet_key = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The facetKey.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey getFacetKey() {
      return facetKey_ == null
          ? com.google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey
              .getDefaultInstance()
          : facetKey_;
    }
    /**
     *
     *
     * <pre>
     * Required. The facet key specification.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey facet_key = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKeyOrBuilder
        getFacetKeyOrBuilder() {
      return facetKey_ == null
          ? com.google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey
              .getDefaultInstance()
          : facetKey_;
    }

    public static final int LIMIT_FIELD_NUMBER = 2;
    private int limit_ = 0;
    /**
     *
     *
     * <pre>
     * Maximum of facet values that should be returned for this facet. If
     * unspecified, defaults to 20. The maximum allowed value is 300. Values
     * above 300 are coerced to 300.
     *
     * If this field is negative, an  `INVALID_ARGUMENT`  is returned.
     * </pre>
     *
     * <code>int32 limit = 2;</code>
     *
     * @return The limit.
     */
    @java.lang.Override
    public int getLimit() {
      return limit_;
    }

    public static final int EXCLUDED_FILTER_KEYS_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList excludedFilterKeys_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    /**
     *
     *
     * <pre>
     * List of keys to exclude when faceting.
     *
     *
     * By default,
     * [FacetKey.key][google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey.key]
     * is not excluded from the filter unless it is listed in this field.
     *
     * Listing a facet key in this field allows its values to appear as facet
     * results, even when they are filtered out of search results. Using this
     * field does not affect what search results are returned.
     *
     * For example, suppose there are 100 documents with the color facet "Red"
     * and 200 documents with the color facet "Blue". A query containing the
     * filter "color:ANY("Red")" and having "color" as
     * [FacetKey.key][google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey.key]
     * would by default return only "Red" documents in the search results, and
     * also return "Red" with count 100 as the only color facet. Although there
     * are also blue documents available, "Blue" would not be shown as an
     * available facet value.
     *
     * If "color" is listed in "excludedFilterKeys", then the query returns the
     * facet values "Red" with count 100 and "Blue" with count 200, because the
     * "color" key is now excluded from the filter. Because this field doesn't
     * affect search results, the search results are still correctly filtered to
     * return only "Red" documents.
     *
     * A maximum of 100 values are allowed. Otherwise, an  `INVALID_ARGUMENT`
     * error is returned.
     * </pre>
     *
     * <code>repeated string excluded_filter_keys = 3;</code>
     *
     * @return A list containing the excludedFilterKeys.
     */
    public com.google.protobuf.ProtocolStringList getExcludedFilterKeysList() {
      return excludedFilterKeys_;
    }
    /**
     *
     *
     * <pre>
     * List of keys to exclude when faceting.
     *
     *
     * By default,
     * [FacetKey.key][google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey.key]
     * is not excluded from the filter unless it is listed in this field.
     *
     * Listing a facet key in this field allows its values to appear as facet
     * results, even when they are filtered out of search results. Using this
     * field does not affect what search results are returned.
     *
     * For example, suppose there are 100 documents with the color facet "Red"
     * and 200 documents with the color facet "Blue". A query containing the
     * filter "color:ANY("Red")" and having "color" as
     * [FacetKey.key][google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey.key]
     * would by default return only "Red" documents in the search results, and
     * also return "Red" with count 100 as the only color facet. Although there
     * are also blue documents available, "Blue" would not be shown as an
     * available facet value.
     *
     * If "color" is listed in "excludedFilterKeys", then the query returns the
     * facet values "Red" with count 100 and "Blue" with count 200, because the
     * "color" key is now excluded from the filter. Because this field doesn't
     * affect search results, the search results are still correctly filtered to
     * return only "Red" documents.
     *
     * A maximum of 100 values are allowed. Otherwise, an  `INVALID_ARGUMENT`
     * error is returned.
     * </pre>
     *
     * <code>repeated string excluded_filter_keys = 3;</code>
     *
     * @return The count of excludedFilterKeys.
     */
    public int getExcludedFilterKeysCount() {
      return excludedFilterKeys_.size();
    }
    /**
     *
     *
     * <pre>
     * List of keys to exclude when faceting.
     *
     *
     * By default,
     * [FacetKey.key][google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey.key]
     * is not excluded from the filter unless it is listed in this field.
     *
     * Listing a facet key in this field allows its values to appear as facet
     * results, even when they are filtered out of search results. Using this
     * field does not affect what search results are returned.
     *
     * For example, suppose there are 100 documents with the color facet "Red"
     * and 200 documents with the color facet "Blue". A query containing the
     * filter "color:ANY("Red")" and having "color" as
     * [FacetKey.key][google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey.key]
     * would by default return only "Red" documents in the search results, and
     * also return "Red" with count 100 as the only color facet. Although there
     * are also blue documents available, "Blue" would not be shown as an
     * available facet value.
     *
     * If "color" is listed in "excludedFilterKeys", then the query returns the
     * facet values "Red" with count 100 and "Blue" with count 200, because the
     * "color" key is now excluded from the filter. Because this field doesn't
     * affect search results, the search results are still correctly filtered to
     * return only "Red" documents.
     *
     * A maximum of 100 values are allowed. Otherwise, an  `INVALID_ARGUMENT`
     * error is returned.
     * </pre>
     *
     * <code>repeated string excluded_filter_keys = 3;</code>
     *
     * @param index The index of the element to return.
     * @return The excludedFilterKeys at the given index.
     */
    public java.lang.String getExcludedFilterKeys(int index) {
      return excludedFilterKeys_.get(index);
    }
    /**
     *
     *
     * <pre>
     * List of keys to exclude when faceting.
     *
     *
     * By default,
     * [FacetKey.key][google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey.key]
     * is not excluded from the filter unless it is listed in this field.
     *
     * Listing a facet key in this field allows its values to appear as facet
     * results, even when they are filtered out of search results. Using this
     * field does not affect what search results are returned.
     *
     * For example, suppose there are 100 documents with the color facet "Red"
     * and 200 documents with the color facet "Blue". A query containing the
     * filter "color:ANY("Red")" and having "color" as
     * [FacetKey.key][google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey.key]
     * would by default return only "Red" documents in the search results, and
     * also return "Red" with count 100 as the only color facet. Although there
     * are also blue documents available, "Blue" would not be shown as an
     * available facet value.
     *
     * If "color" is listed in "excludedFilterKeys", then the query returns the
     * facet values "Red" with count 100 and "Blue" with count 200, because the
     * "color" key is now excluded from the filter. Because this field doesn't
     * affect search results, the search results are still correctly filtered to
     * return only "Red" documents.
     *
     * A maximum of 100 values are allowed. Otherwise, an  `INVALID_ARGUMENT`
     * error is returned.
     * </pre>
     *
     * <code>repeated string excluded_filter_keys = 3;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the excludedFilterKeys at the given index.
     */
    public com.google.protobuf.ByteString getExcludedFilterKeysBytes(int index) {
      return excludedFilterKeys_.getByteString(index);
    }

    public static final int ENABLE_DYNAMIC_POSITION_FIELD_NUMBER = 4;
    private boolean enableDynamicPosition_ = false;
    /**
     *
     *
     * <pre>
     * Enables dynamic position for this facet. If set to true, the position of
     * this facet among all facets in the response is determined automatically.
     * If dynamic facets are enabled, it is ordered together.
     * If set to false, the position of this facet in the
     * response is the same as in the request, and it is ranked before
     * the facets with dynamic position enable and all dynamic facets.
     *
     * For example, you may always want to have rating facet returned in
     * the response, but it's not necessarily to always display the rating facet
     * at the top. In that case, you can set enable_dynamic_position to true so
     * that the position of rating facet in response is determined
     * automatically.
     *
     * Another example, assuming you have the following facets in the request:
     *
     * * "rating", enable_dynamic_position = true
     *
     * * "price", enable_dynamic_position = false
     *
     * * "brands", enable_dynamic_position = false
     *
     * And also you have a dynamic facets enabled, which generates a facet
     * `gender`. Then the final order of the facets in the response can be
     * ("price", "brands", "rating", "gender") or ("price", "brands", "gender",
     * "rating") depends on how API orders "gender" and "rating" facets.
     * However, notice that "price" and "brands" are always
     * ranked at first and second position because their enable_dynamic_position
     * is false.
     * </pre>
     *
     * <code>bool enable_dynamic_position = 4;</code>
     *
     * @return The enableDynamicPosition.
     */
    @java.lang.Override
    public boolean getEnableDynamicPosition() {
      return enableDynamicPosition_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getFacetKey());
      }
      if (limit_ != 0) {
        output.writeInt32(2, limit_);
      }
      for (int i = 0; i < excludedFilterKeys_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(
            output, 3, excludedFilterKeys_.getRaw(i));
      }
      if (enableDynamicPosition_ != false) {
        output.writeBool(4, enableDynamicPosition_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getFacetKey());
      }
      if (limit_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, limit_);
      }
      {
        int dataSize = 0;
        for (int i = 0; i < excludedFilterKeys_.size(); i++) {
          dataSize += computeStringSizeNoTag(excludedFilterKeys_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getExcludedFilterKeysList().size();
      }
      if (enableDynamicPosition_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(4, enableDynamicPosition_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec)) {
        return super.equals(obj);
      }
      com.google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec other =
          (com.google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec) obj;

      if (hasFacetKey() != other.hasFacetKey()) return false;
      if (hasFacetKey()) {
        if (!getFacetKey().equals(other.getFacetKey())) return false;
      }
      if (getLimit() != other.getLimit()) return false;
      if (!getExcludedFilterKeysList().equals(other.getExcludedFilterKeysList())) return false;
      if (getEnableDynamicPosition() != other.getEnableDynamicPosition()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasFacetKey()) {
        hash = (37 * hash) + FACET_KEY_FIELD_NUMBER;
        hash = (53 * hash) + getFacetKey().hashCode();
      }
      hash = (37 * hash) + LIMIT_FIELD_NUMBER;
      hash = (53 * hash) + getLimit();
      if (getExcludedFilterKeysCount() > 0) {
        hash = (37 * hash) + EXCLUDED_FILTER_KEYS_FIELD_NUMBER;
        hash = (53 * hash) + getExcludedFilterKeysList().hashCode();
      }
      hash = (37 * hash) + ENABLE_DYNAMIC_POSITION_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnableDynamicPosition());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A facet specification to perform faceted search.
     * </pre>
     *
     * Protobuf type {@code google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec)
        com.google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpecOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_SearchRequest_FacetSpec_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_SearchRequest_FacetSpec_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.class,
                com.google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.Builder.class);
      }

      // Construct using
      // com.google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getFacetKeyFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        facetKey_ = null;
        if (facetKeyBuilder_ != null) {
          facetKeyBuilder_.dispose();
          facetKeyBuilder_ = null;
        }
        limit_ = 0;
        excludedFilterKeys_ = com.google.protobuf.LazyStringArrayList.emptyList();
        enableDynamicPosition_ = false;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_SearchRequest_FacetSpec_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec
          getDefaultInstanceForType() {
        return com.google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec build() {
        com.google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec buildPartial() {
        com.google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec result =
            new com.google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.facetKey_ = facetKeyBuilder_ == null ? facetKey_ : facetKeyBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.limit_ = limit_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          excludedFilterKeys_.makeImmutable();
          result.excludedFilterKeys_ = excludedFilterKeys_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.enableDynamicPosition_ = enableDynamicPosition_;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec) {
          return mergeFrom((com.google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec other) {
        if (other
            == com.google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.getDefaultInstance())
          return this;
        if (other.hasFacetKey()) {
          mergeFacetKey(other.getFacetKey());
        }
        if (other.getLimit() != 0) {
          setLimit(other.getLimit());
        }
        if (!other.excludedFilterKeys_.isEmpty()) {
          if (excludedFilterKeys_.isEmpty()) {
            excludedFilterKeys_ = other.excludedFilterKeys_;
            bitField0_ |= 0x00000004;
          } else {
            ensureExcludedFilterKeysIsMutable();
            excludedFilterKeys_.addAll(other.excludedFilterKeys_);
          }
          onChanged();
        }
        if (other.getEnableDynamicPosition() != false) {
          setEnableDynamicPosition(other.getEnableDynamicPosition());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getFacetKeyFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 16:
                {
                  limit_ = input.readInt32();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              case 26:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureExcludedFilterKeysIsMutable();
                  excludedFilterKeys_.add(s);
                  break;
                } // case 26
              case 32:
                {
                  enableDynamicPosition_ = input.readBool();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 32
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey facetKey_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey,
              com.google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey.Builder,
              com.google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKeyOrBuilder>
          facetKeyBuilder_;
      /**
       *
       *
       * <pre>
       * Required. The facet key specification.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey facet_key = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return Whether the facetKey field is set.
       */
      public boolean hasFacetKey() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * Required. The facet key specification.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey facet_key = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The facetKey.
       */
      public com.google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey
          getFacetKey() {
        if (facetKeyBuilder_ == null) {
          return facetKey_ == null
              ? com.google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey
                  .getDefaultInstance()
              : facetKey_;
        } else {
          return facetKeyBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The facet key specification.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey facet_key = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setFacetKey(
          com.google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey value) {
        if (facetKeyBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          facetKey_ = value;
        } else {
          facetKeyBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The facet key specification.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey facet_key = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setFacetKey(
          com.google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey.Builder
              builderForValue) {
        if (facetKeyBuilder_ == null) {
          facetKey_ = builderForValue.build();
        } else {
          facetKeyBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The facet key specification.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey facet_key = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder mergeFacetKey(
          com.google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey value) {
        if (facetKeyBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && facetKey_ != null
              && facetKey_
                  != com.google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey
                      .getDefaultInstance()) {
            getFacetKeyBuilder().mergeFrom(value);
          } else {
            facetKey_ = value;
          }
        } else {
          facetKeyBuilder_.mergeFrom(value);
        }
        if (facetKey_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The facet key specification.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey facet_key = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder clearFacetKey() {
        bitField0_ = (bitField0_ & ~0x00000001);
        facetKey_ = null;
        if (facetKeyBuilder_ != null) {
          facetKeyBuilder_.dispose();
          facetKeyBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The facet key specification.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey facet_key = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey.Builder
          getFacetKeyBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getFacetKeyFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Required. The facet key specification.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey facet_key = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKeyOrBuilder
          getFacetKeyOrBuilder() {
        if (facetKeyBuilder_ != null) {
          return facetKeyBuilder_.getMessageOrBuilder();
        } else {
          return facetKey_ == null
              ? com.google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey
                  .getDefaultInstance()
              : facetKey_;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The facet key specification.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey facet_key = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey,
              com.google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey.Builder,
              com.google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKeyOrBuilder>
          getFacetKeyFieldBuilder() {
        if (facetKeyBuilder_ == null) {
          facetKeyBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey,
                  com.google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey.Builder,
                  com.google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec
                      .FacetKeyOrBuilder>(getFacetKey(), getParentForChildren(), isClean());
          facetKey_ = null;
        }
        return facetKeyBuilder_;
      }

      private int limit_;
      /**
       *
       *
       * <pre>
       * Maximum of facet values that should be returned for this facet. If
       * unspecified, defaults to 20. The maximum allowed value is 300. Values
       * above 300 are coerced to 300.
       *
       * If this field is negative, an  `INVALID_ARGUMENT`  is returned.
       * </pre>
       *
       * <code>int32 limit = 2;</code>
       *
       * @return The limit.
       */
      @java.lang.Override
      public int getLimit() {
        return limit_;
      }
      /**
       *
       *
       * <pre>
       * Maximum of facet values that should be returned for this facet. If
       * unspecified, defaults to 20. The maximum allowed value is 300. Values
       * above 300 are coerced to 300.
       *
       * If this field is negative, an  `INVALID_ARGUMENT`  is returned.
       * </pre>
       *
       * <code>int32 limit = 2;</code>
       *
       * @param value The limit to set.
       * @return This builder for chaining.
       */
      public Builder setLimit(int value) {

        limit_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Maximum of facet values that should be returned for this facet. If
       * unspecified, defaults to 20. The maximum allowed value is 300. Values
       * above 300 are coerced to 300.
       *
       * If this field is negative, an  `INVALID_ARGUMENT`  is returned.
       * </pre>
       *
       * <code>int32 limit = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearLimit() {
        bitField0_ = (bitField0_ & ~0x00000002);
        limit_ = 0;
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringArrayList excludedFilterKeys_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureExcludedFilterKeysIsMutable() {
        if (!excludedFilterKeys_.isModifiable()) {
          excludedFilterKeys_ = new com.google.protobuf.LazyStringArrayList(excludedFilterKeys_);
        }
        bitField0_ |= 0x00000004;
      }
      /**
       *
       *
       * <pre>
       * List of keys to exclude when faceting.
       *
       *
       * By default,
       * [FacetKey.key][google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey.key]
       * is not excluded from the filter unless it is listed in this field.
       *
       * Listing a facet key in this field allows its values to appear as facet
       * results, even when they are filtered out of search results. Using this
       * field does not affect what search results are returned.
       *
       * For example, suppose there are 100 documents with the color facet "Red"
       * and 200 documents with the color facet "Blue". A query containing the
       * filter "color:ANY("Red")" and having "color" as
       * [FacetKey.key][google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey.key]
       * would by default return only "Red" documents in the search results, and
       * also return "Red" with count 100 as the only color facet. Although there
       * are also blue documents available, "Blue" would not be shown as an
       * available facet value.
       *
       * If "color" is listed in "excludedFilterKeys", then the query returns the
       * facet values "Red" with count 100 and "Blue" with count 200, because the
       * "color" key is now excluded from the filter. Because this field doesn't
       * affect search results, the search results are still correctly filtered to
       * return only "Red" documents.
       *
       * A maximum of 100 values are allowed. Otherwise, an  `INVALID_ARGUMENT`
       * error is returned.
       * </pre>
       *
       * <code>repeated string excluded_filter_keys = 3;</code>
       *
       * @return A list containing the excludedFilterKeys.
       */
      public com.google.protobuf.ProtocolStringList getExcludedFilterKeysList() {
        excludedFilterKeys_.makeImmutable();
        return excludedFilterKeys_;
      }
      /**
       *
       *
       * <pre>
       * List of keys to exclude when faceting.
       *
       *
       * By default,
       * [FacetKey.key][google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey.key]
       * is not excluded from the filter unless it is listed in this field.
       *
       * Listing a facet key in this field allows its values to appear as facet
       * results, even when they are filtered out of search results. Using this
       * field does not affect what search results are returned.
       *
       * For example, suppose there are 100 documents with the color facet "Red"
       * and 200 documents with the color facet "Blue". A query containing the
       * filter "color:ANY("Red")" and having "color" as
       * [FacetKey.key][google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey.key]
       * would by default return only "Red" documents in the search results, and
       * also return "Red" with count 100 as the only color facet. Although there
       * are also blue documents available, "Blue" would not be shown as an
       * available facet value.
       *
       * If "color" is listed in "excludedFilterKeys", then the query returns the
       * facet values "Red" with count 100 and "Blue" with count 200, because the
       * "color" key is now excluded from the filter. Because this field doesn't
       * affect search results, the search results are still correctly filtered to
       * return only "Red" documents.
       *
       * A maximum of 100 values are allowed. Otherwise, an  `INVALID_ARGUMENT`
       * error is returned.
       * </pre>
       *
       * <code>repeated string excluded_filter_keys = 3;</code>
       *
       * @return The count of excludedFilterKeys.
       */
      public int getExcludedFilterKeysCount() {
        return excludedFilterKeys_.size();
      }
      /**
       *
       *
       * <pre>
       * List of keys to exclude when faceting.
       *
       *
       * By default,
       * [FacetKey.key][google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey.key]
       * is not excluded from the filter unless it is listed in this field.
       *
       * Listing a facet key in this field allows its values to appear as facet
       * results, even when they are filtered out of search results. Using this
       * field does not affect what search results are returned.
       *
       * For example, suppose there are 100 documents with the color facet "Red"
       * and 200 documents with the color facet "Blue". A query containing the
       * filter "color:ANY("Red")" and having "color" as
       * [FacetKey.key][google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey.key]
       * would by default return only "Red" documents in the search results, and
       * also return "Red" with count 100 as the only color facet. Although there
       * are also blue documents available, "Blue" would not be shown as an
       * available facet value.
       *
       * If "color" is listed in "excludedFilterKeys", then the query returns the
       * facet values "Red" with count 100 and "Blue" with count 200, because the
       * "color" key is now excluded from the filter. Because this field doesn't
       * affect search results, the search results are still correctly filtered to
       * return only "Red" documents.
       *
       * A maximum of 100 values are allowed. Otherwise, an  `INVALID_ARGUMENT`
       * error is returned.
       * </pre>
       *
       * <code>repeated string excluded_filter_keys = 3;</code>
       *
       * @param index The index of the element to return.
       * @return The excludedFilterKeys at the given index.
       */
      public java.lang.String getExcludedFilterKeys(int index) {
        return excludedFilterKeys_.get(index);
      }
      /**
       *
       *
       * <pre>
       * List of keys to exclude when faceting.
       *
       *
       * By default,
       * [FacetKey.key][google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey.key]
       * is not excluded from the filter unless it is listed in this field.
       *
       * Listing a facet key in this field allows its values to appear as facet
       * results, even when they are filtered out of search results. Using this
       * field does not affect what search results are returned.
       *
       * For example, suppose there are 100 documents with the color facet "Red"
       * and 200 documents with the color facet "Blue". A query containing the
       * filter "color:ANY("Red")" and having "color" as
       * [FacetKey.key][google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey.key]
       * would by default return only "Red" documents in the search results, and
       * also return "Red" with count 100 as the only color facet. Although there
       * are also blue documents available, "Blue" would not be shown as an
       * available facet value.
       *
       * If "color" is listed in "excludedFilterKeys", then the query returns the
       * facet values "Red" with count 100 and "Blue" with count 200, because the
       * "color" key is now excluded from the filter. Because this field doesn't
       * affect search results, the search results are still correctly filtered to
       * return only "Red" documents.
       *
       * A maximum of 100 values are allowed. Otherwise, an  `INVALID_ARGUMENT`
       * error is returned.
       * </pre>
       *
       * <code>repeated string excluded_filter_keys = 3;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the excludedFilterKeys at the given index.
       */
      public com.google.protobuf.ByteString getExcludedFilterKeysBytes(int index) {
        return excludedFilterKeys_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * List of keys to exclude when faceting.
       *
       *
       * By default,
       * [FacetKey.key][google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey.key]
       * is not excluded from the filter unless it is listed in this field.
       *
       * Listing a facet key in this field allows its values to appear as facet
       * results, even when they are filtered out of search results. Using this
       * field does not affect what search results are returned.
       *
       * For example, suppose there are 100 documents with the color facet "Red"
       * and 200 documents with the color facet "Blue". A query containing the
       * filter "color:ANY("Red")" and having "color" as
       * [FacetKey.key][google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey.key]
       * would by default return only "Red" documents in the search results, and
       * also return "Red" with count 100 as the only color facet. Although there
       * are also blue documents available, "Blue" would not be shown as an
       * available facet value.
       *
       * If "color" is listed in "excludedFilterKeys", then the query returns the
       * facet values "Red" with count 100 and "Blue" with count 200, because the
       * "color" key is now excluded from the filter. Because this field doesn't
       * affect search results, the search results are still correctly filtered to
       * return only "Red" documents.
       *
       * A maximum of 100 values are allowed. Otherwise, an  `INVALID_ARGUMENT`
       * error is returned.
       * </pre>
       *
       * <code>repeated string excluded_filter_keys = 3;</code>
       *
       * @param index The index to set the value at.
       * @param value The excludedFilterKeys to set.
       * @return This builder for chaining.
       */
      public Builder setExcludedFilterKeys(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureExcludedFilterKeysIsMutable();
        excludedFilterKeys_.set(index, value);
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of keys to exclude when faceting.
       *
       *
       * By default,
       * [FacetKey.key][google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey.key]
       * is not excluded from the filter unless it is listed in this field.
       *
       * Listing a facet key in this field allows its values to appear as facet
       * results, even when they are filtered out of search results. Using this
       * field does not affect what search results are returned.
       *
       * For example, suppose there are 100 documents with the color facet "Red"
       * and 200 documents with the color facet "Blue". A query containing the
       * filter "color:ANY("Red")" and having "color" as
       * [FacetKey.key][google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey.key]
       * would by default return only "Red" documents in the search results, and
       * also return "Red" with count 100 as the only color facet. Although there
       * are also blue documents available, "Blue" would not be shown as an
       * available facet value.
       *
       * If "color" is listed in "excludedFilterKeys", then the query returns the
       * facet values "Red" with count 100 and "Blue" with count 200, because the
       * "color" key is now excluded from the filter. Because this field doesn't
       * affect search results, the search results are still correctly filtered to
       * return only "Red" documents.
       *
       * A maximum of 100 values are allowed. Otherwise, an  `INVALID_ARGUMENT`
       * error is returned.
       * </pre>
       *
       * <code>repeated string excluded_filter_keys = 3;</code>
       *
       * @param value The excludedFilterKeys to add.
       * @return This builder for chaining.
       */
      public Builder addExcludedFilterKeys(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureExcludedFilterKeysIsMutable();
        excludedFilterKeys_.add(value);
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of keys to exclude when faceting.
       *
       *
       * By default,
       * [FacetKey.key][google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey.key]
       * is not excluded from the filter unless it is listed in this field.
       *
       * Listing a facet key in this field allows its values to appear as facet
       * results, even when they are filtered out of search results. Using this
       * field does not affect what search results are returned.
       *
       * For example, suppose there are 100 documents with the color facet "Red"
       * and 200 documents with the color facet "Blue". A query containing the
       * filter "color:ANY("Red")" and having "color" as
       * [FacetKey.key][google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey.key]
       * would by default return only "Red" documents in the search results, and
       * also return "Red" with count 100 as the only color facet. Although there
       * are also blue documents available, "Blue" would not be shown as an
       * available facet value.
       *
       * If "color" is listed in "excludedFilterKeys", then the query returns the
       * facet values "Red" with count 100 and "Blue" with count 200, because the
       * "color" key is now excluded from the filter. Because this field doesn't
       * affect search results, the search results are still correctly filtered to
       * return only "Red" documents.
       *
       * A maximum of 100 values are allowed. Otherwise, an  `INVALID_ARGUMENT`
       * error is returned.
       * </pre>
       *
       * <code>repeated string excluded_filter_keys = 3;</code>
       *
       * @param values The excludedFilterKeys to add.
       * @return This builder for chaining.
       */
      public Builder addAllExcludedFilterKeys(java.lang.Iterable<java.lang.String> values) {
        ensureExcludedFilterKeysIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, excludedFilterKeys_);
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of keys to exclude when faceting.
       *
       *
       * By default,
       * [FacetKey.key][google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey.key]
       * is not excluded from the filter unless it is listed in this field.
       *
       * Listing a facet key in this field allows its values to appear as facet
       * results, even when they are filtered out of search results. Using this
       * field does not affect what search results are returned.
       *
       * For example, suppose there are 100 documents with the color facet "Red"
       * and 200 documents with the color facet "Blue". A query containing the
       * filter "color:ANY("Red")" and having "color" as
       * [FacetKey.key][google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey.key]
       * would by default return only "Red" documents in the search results, and
       * also return "Red" with count 100 as the only color facet. Although there
       * are also blue documents available, "Blue" would not be shown as an
       * available facet value.
       *
       * If "color" is listed in "excludedFilterKeys", then the query returns the
       * facet values "Red" with count 100 and "Blue" with count 200, because the
       * "color" key is now excluded from the filter. Because this field doesn't
       * affect search results, the search results are still correctly filtered to
       * return only "Red" documents.
       *
       * A maximum of 100 values are allowed. Otherwise, an  `INVALID_ARGUMENT`
       * error is returned.
       * </pre>
       *
       * <code>repeated string excluded_filter_keys = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearExcludedFilterKeys() {
        excludedFilterKeys_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        ;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of keys to exclude when faceting.
       *
       *
       * By default,
       * [FacetKey.key][google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey.key]
       * is not excluded from the filter unless it is listed in this field.
       *
       * Listing a facet key in this field allows its values to appear as facet
       * results, even when they are filtered out of search results. Using this
       * field does not affect what search results are returned.
       *
       * For example, suppose there are 100 documents with the color facet "Red"
       * and 200 documents with the color facet "Blue". A query containing the
       * filter "color:ANY("Red")" and having "color" as
       * [FacetKey.key][google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey.key]
       * would by default return only "Red" documents in the search results, and
       * also return "Red" with count 100 as the only color facet. Although there
       * are also blue documents available, "Blue" would not be shown as an
       * available facet value.
       *
       * If "color" is listed in "excludedFilterKeys", then the query returns the
       * facet values "Red" with count 100 and "Blue" with count 200, because the
       * "color" key is now excluded from the filter. Because this field doesn't
       * affect search results, the search results are still correctly filtered to
       * return only "Red" documents.
       *
       * A maximum of 100 values are allowed. Otherwise, an  `INVALID_ARGUMENT`
       * error is returned.
       * </pre>
       *
       * <code>repeated string excluded_filter_keys = 3;</code>
       *
       * @param value The bytes of the excludedFilterKeys to add.
       * @return This builder for chaining.
       */
      public Builder addExcludedFilterKeysBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureExcludedFilterKeysIsMutable();
        excludedFilterKeys_.add(value);
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      private boolean enableDynamicPosition_;
      /**
       *
       *
       * <pre>
       * Enables dynamic position for this facet. If set to true, the position of
       * this facet among all facets in the response is determined automatically.
       * If dynamic facets are enabled, it is ordered together.
       * If set to false, the position of this facet in the
       * response is the same as in the request, and it is ranked before
       * the facets with dynamic position enable and all dynamic facets.
       *
       * For example, you may always want to have rating facet returned in
       * the response, but it's not necessarily to always display the rating facet
       * at the top. In that case, you can set enable_dynamic_position to true so
       * that the position of rating facet in response is determined
       * automatically.
       *
       * Another example, assuming you have the following facets in the request:
       *
       * * "rating", enable_dynamic_position = true
       *
       * * "price", enable_dynamic_position = false
       *
       * * "brands", enable_dynamic_position = false
       *
       * And also you have a dynamic facets enabled, which generates a facet
       * `gender`. Then the final order of the facets in the response can be
       * ("price", "brands", "rating", "gender") or ("price", "brands", "gender",
       * "rating") depends on how API orders "gender" and "rating" facets.
       * However, notice that "price" and "brands" are always
       * ranked at first and second position because their enable_dynamic_position
       * is false.
       * </pre>
       *
       * <code>bool enable_dynamic_position = 4;</code>
       *
       * @return The enableDynamicPosition.
       */
      @java.lang.Override
      public boolean getEnableDynamicPosition() {
        return enableDynamicPosition_;
      }
      /**
       *
       *
       * <pre>
       * Enables dynamic position for this facet. If set to true, the position of
       * this facet among all facets in the response is determined automatically.
       * If dynamic facets are enabled, it is ordered together.
       * If set to false, the position of this facet in the
       * response is the same as in the request, and it is ranked before
       * the facets with dynamic position enable and all dynamic facets.
       *
       * For example, you may always want to have rating facet returned in
       * the response, but it's not necessarily to always display the rating facet
       * at the top. In that case, you can set enable_dynamic_position to true so
       * that the position of rating facet in response is determined
       * automatically.
       *
       * Another example, assuming you have the following facets in the request:
       *
       * * "rating", enable_dynamic_position = true
       *
       * * "price", enable_dynamic_position = false
       *
       * * "brands", enable_dynamic_position = false
       *
       * And also you have a dynamic facets enabled, which generates a facet
       * `gender`. Then the final order of the facets in the response can be
       * ("price", "brands", "rating", "gender") or ("price", "brands", "gender",
       * "rating") depends on how API orders "gender" and "rating" facets.
       * However, notice that "price" and "brands" are always
       * ranked at first and second position because their enable_dynamic_position
       * is false.
       * </pre>
       *
       * <code>bool enable_dynamic_position = 4;</code>
       *
       * @param value The enableDynamicPosition to set.
       * @return This builder for chaining.
       */
      public Builder setEnableDynamicPosition(boolean value) {

        enableDynamicPosition_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Enables dynamic position for this facet. If set to true, the position of
       * this facet among all facets in the response is determined automatically.
       * If dynamic facets are enabled, it is ordered together.
       * If set to false, the position of this facet in the
       * response is the same as in the request, and it is ranked before
       * the facets with dynamic position enable and all dynamic facets.
       *
       * For example, you may always want to have rating facet returned in
       * the response, but it's not necessarily to always display the rating facet
       * at the top. In that case, you can set enable_dynamic_position to true so
       * that the position of rating facet in response is determined
       * automatically.
       *
       * Another example, assuming you have the following facets in the request:
       *
       * * "rating", enable_dynamic_position = true
       *
       * * "price", enable_dynamic_position = false
       *
       * * "brands", enable_dynamic_position = false
       *
       * And also you have a dynamic facets enabled, which generates a facet
       * `gender`. Then the final order of the facets in the response can be
       * ("price", "brands", "rating", "gender") or ("price", "brands", "gender",
       * "rating") depends on how API orders "gender" and "rating" facets.
       * However, notice that "price" and "brands" are always
       * ranked at first and second position because their enable_dynamic_position
       * is false.
       * </pre>
       *
       * <code>bool enable_dynamic_position = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearEnableDynamicPosition() {
        bitField0_ = (bitField0_ & ~0x00000008);
        enableDynamicPosition_ = false;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec)
    private static final com.google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec();
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<FacetSpec> PARSER =
        new com.google.protobuf.AbstractParser<FacetSpec>() {
          @java.lang.Override
          public FacetSpec parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<FacetSpec> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<FacetSpec> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface BoostSpecOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Condition boost specifications. If a document matches multiple conditions
     * in the specifictions, boost scores from these specifications are all
     * applied and combined in a non-linear way. Maximum number of
     * specifications is 20.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec condition_boost_specs = 1;
     * </code>
     */
    java.util.List<
            com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec>
        getConditionBoostSpecsList();
    /**
     *
     *
     * <pre>
     * Condition boost specifications. If a document matches multiple conditions
     * in the specifictions, boost scores from these specifications are all
     * applied and combined in a non-linear way. Maximum number of
     * specifications is 20.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec condition_boost_specs = 1;
     * </code>
     */
    com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
        getConditionBoostSpecs(int index);
    /**
     *
     *
     * <pre>
     * Condition boost specifications. If a document matches multiple conditions
     * in the specifictions, boost scores from these specifications are all
     * applied and combined in a non-linear way. Maximum number of
     * specifications is 20.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec condition_boost_specs = 1;
     * </code>
     */
    int getConditionBoostSpecsCount();
    /**
     *
     *
     * <pre>
     * Condition boost specifications. If a document matches multiple conditions
     * in the specifictions, boost scores from these specifications are all
     * applied and combined in a non-linear way. Maximum number of
     * specifications is 20.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec condition_boost_specs = 1;
     * </code>
     */
    java.util.List<
            ? extends
                com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec
                    .ConditionBoostSpecOrBuilder>
        getConditionBoostSpecsOrBuilderList();
    /**
     *
     *
     * <pre>
     * Condition boost specifications. If a document matches multiple conditions
     * in the specifictions, boost scores from these specifications are all
     * applied and combined in a non-linear way. Maximum number of
     * specifications is 20.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec condition_boost_specs = 1;
     * </code>
     */
    com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpecOrBuilder
        getConditionBoostSpecsOrBuilder(int index);
  }
  /**
   *
   *
   * <pre>
   * Boost specification to boost certain documents.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec}
   */
  public static final class BoostSpec extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec)
      BoostSpecOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use BoostSpec.newBuilder() to construct.
    private BoostSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private BoostSpec() {
      conditionBoostSpecs_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new BoostSpec();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
          .internal_static_google_cloud_discoveryengine_v1beta_SearchRequest_BoostSpec_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
          .internal_static_google_cloud_discoveryengine_v1beta_SearchRequest_BoostSpec_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.class,
              com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.Builder.class);
    }

    public interface ConditionBoostSpecOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * An expression which specifies a boost condition. The syntax and
       * supported fields are the same as a filter expression. See
       * [SearchRequest.filter][google.cloud.discoveryengine.v1beta.SearchRequest.filter]
       * for detail syntax and limitations.
       *
       * Examples:
       *
       * * To boost documents with document ID "doc_1" or "doc_2", and
       * color "Red" or "Blue":
       * `(document_id: ANY("doc_1", "doc_2")) AND (color: ANY("Red", "Blue"))`
       * </pre>
       *
       * <code>string condition = 1;</code>
       *
       * @return The condition.
       */
      java.lang.String getCondition();
      /**
       *
       *
       * <pre>
       * An expression which specifies a boost condition. The syntax and
       * supported fields are the same as a filter expression. See
       * [SearchRequest.filter][google.cloud.discoveryengine.v1beta.SearchRequest.filter]
       * for detail syntax and limitations.
       *
       * Examples:
       *
       * * To boost documents with document ID "doc_1" or "doc_2", and
       * color "Red" or "Blue":
       * `(document_id: ANY("doc_1", "doc_2")) AND (color: ANY("Red", "Blue"))`
       * </pre>
       *
       * <code>string condition = 1;</code>
       *
       * @return The bytes for condition.
       */
      com.google.protobuf.ByteString getConditionBytes();

      /**
       *
       *
       * <pre>
       * Strength of the condition boost, which should be in [-1, 1]. Negative
       * boost means demotion. Default is 0.0.
       *
       * Setting to 1.0 gives the document a big promotion. However, it does
       * not necessarily mean that the boosted document will be the top result
       * at all times, nor that other documents will be excluded. Results
       * could still be shown even when none of them matches the condition.
       * And results that are significantly more relevant to the search query
       * can still trump your heavily favored but irrelevant documents.
       *
       * Setting to -1.0 gives the document a big demotion. However, results
       * that are deeply relevant might still be shown. The document will have
       * an upstream battle to get a fairly high ranking, but it is not
       * blocked out completely.
       *
       * Setting to 0.0 means no boost applied. The boosting condition is
       * ignored. Only one of the (condition, boost) combination or the
       * boost_control_spec below are set. If both are set then the global boost
       * is ignored and the more fine-grained boost_control_spec is applied.
       * </pre>
       *
       * <code>float boost = 2;</code>
       *
       * @return The boost.
       */
      float getBoost();

      /**
       *
       *
       * <pre>
       * Complex specification for custom ranking based on customer defined
       * attribute value.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec.BoostControlSpec boost_control_spec = 3;
       * </code>
       *
       * @return Whether the boostControlSpec field is set.
       */
      boolean hasBoostControlSpec();
      /**
       *
       *
       * <pre>
       * Complex specification for custom ranking based on customer defined
       * attribute value.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec.BoostControlSpec boost_control_spec = 3;
       * </code>
       *
       * @return The boostControlSpec.
       */
      com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
              .BoostControlSpec
          getBoostControlSpec();
      /**
       *
       *
       * <pre>
       * Complex specification for custom ranking based on customer defined
       * attribute value.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec.BoostControlSpec boost_control_spec = 3;
       * </code>
       */
      com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
              .BoostControlSpecOrBuilder
          getBoostControlSpecOrBuilder();
    }
    /**
     *
     *
     * <pre>
     * Boost applies to documents which match a condition.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec}
     */
    public static final class ConditionBoostSpec extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec)
        ConditionBoostSpecOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use ConditionBoostSpec.newBuilder() to construct.
      private ConditionBoostSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private ConditionBoostSpec() {
        condition_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new ConditionBoostSpec();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_SearchRequest_BoostSpec_ConditionBoostSpec_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_SearchRequest_BoostSpec_ConditionBoostSpec_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
                    .class,
                com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
                    .Builder.class);
      }

      public interface BoostControlSpecOrBuilder
          extends
          // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec.BoostControlSpec)
          com.google.protobuf.MessageOrBuilder {

        /**
         *
         *
         * <pre>
         * The name of the field whose value will be used to determine the
         * boost amount.
         * </pre>
         *
         * <code>string field_name = 1;</code>
         *
         * @return The fieldName.
         */
        java.lang.String getFieldName();
        /**
         *
         *
         * <pre>
         * The name of the field whose value will be used to determine the
         * boost amount.
         * </pre>
         *
         * <code>string field_name = 1;</code>
         *
         * @return The bytes for fieldName.
         */
        com.google.protobuf.ByteString getFieldNameBytes();

        /**
         *
         *
         * <pre>
         * The attribute type to be used to determine the boost amount. The
         * attribute value can be derived from the field value of the specified
         * field_name. In the case of numerical it is straightforward i.e.
         * attribute_value = numerical_field_value. In the case of freshness
         * however, attribute_value = (time.now() - datetime_field_value).
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec.BoostControlSpec.AttributeType attribute_type = 2;
         * </code>
         *
         * @return The enum numeric value on the wire for attributeType.
         */
        int getAttributeTypeValue();
        /**
         *
         *
         * <pre>
         * The attribute type to be used to determine the boost amount. The
         * attribute value can be derived from the field value of the specified
         * field_name. In the case of numerical it is straightforward i.e.
         * attribute_value = numerical_field_value. In the case of freshness
         * however, attribute_value = (time.now() - datetime_field_value).
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec.BoostControlSpec.AttributeType attribute_type = 2;
         * </code>
         *
         * @return The attributeType.
         */
        com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
                .BoostControlSpec.AttributeType
            getAttributeType();

        /**
         *
         *
         * <pre>
         * The interpolation type to be applied to connect the control points
         * listed below.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec.BoostControlSpec.InterpolationType interpolation_type = 3;
         * </code>
         *
         * @return The enum numeric value on the wire for interpolationType.
         */
        int getInterpolationTypeValue();
        /**
         *
         *
         * <pre>
         * The interpolation type to be applied to connect the control points
         * listed below.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec.BoostControlSpec.InterpolationType interpolation_type = 3;
         * </code>
         *
         * @return The interpolationType.
         */
        com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
                .BoostControlSpec.InterpolationType
            getInterpolationType();

        /**
         *
         *
         * <pre>
         * The control points used to define the curve. The monotonic function
         * (defined through the interpolation_type above) passes through the
         * control points listed here.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec.BoostControlSpec.ControlPoint control_points = 4;
         * </code>
         */
        java.util.List<
                com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
                    .BoostControlSpec.ControlPoint>
            getControlPointsList();
        /**
         *
         *
         * <pre>
         * The control points used to define the curve. The monotonic function
         * (defined through the interpolation_type above) passes through the
         * control points listed here.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec.BoostControlSpec.ControlPoint control_points = 4;
         * </code>
         */
        com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
                .BoostControlSpec.ControlPoint
            getControlPoints(int index);
        /**
         *
         *
         * <pre>
         * The control points used to define the curve. The monotonic function
         * (defined through the interpolation_type above) passes through the
         * control points listed here.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec.BoostControlSpec.ControlPoint control_points = 4;
         * </code>
         */
        int getControlPointsCount();
        /**
         *
         *
         * <pre>
         * The control points used to define the curve. The monotonic function
         * (defined through the interpolation_type above) passes through the
         * control points listed here.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec.BoostControlSpec.ControlPoint control_points = 4;
         * </code>
         */
        java.util.List<
                ? extends
                    com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec
                        .ConditionBoostSpec.BoostControlSpec.ControlPointOrBuilder>
            getControlPointsOrBuilderList();
        /**
         *
         *
         * <pre>
         * The control points used to define the curve. The monotonic function
         * (defined through the interpolation_type above) passes through the
         * control points listed here.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec.BoostControlSpec.ControlPoint control_points = 4;
         * </code>
         */
        com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
                .BoostControlSpec.ControlPointOrBuilder
            getControlPointsOrBuilder(int index);
      }
      /**
       *
       *
       * <pre>
       * Specification for custom ranking based on customer specified attribute
       * value. It provides more controls for customized ranking than the simple
       * (condition, boost) combination above.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec.BoostControlSpec}
       */
      public static final class BoostControlSpec extends com.google.protobuf.GeneratedMessageV3
          implements
          // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec.BoostControlSpec)
          BoostControlSpecOrBuilder {
        private static final long serialVersionUID = 0L;
        // Use BoostControlSpec.newBuilder() to construct.
        private BoostControlSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
          super(builder);
        }

        private BoostControlSpec() {
          fieldName_ = "";
          attributeType_ = 0;
          interpolationType_ = 0;
          controlPoints_ = java.util.Collections.emptyList();
        }

        @java.lang.Override
        @SuppressWarnings({"unused"})
        protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
          return new BoostControlSpec();
        }

        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
              .internal_static_google_cloud_discoveryengine_v1beta_SearchRequest_BoostSpec_ConditionBoostSpec_BoostControlSpec_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
              .internal_static_google_cloud_discoveryengine_v1beta_SearchRequest_BoostSpec_ConditionBoostSpec_BoostControlSpec_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
                      .BoostControlSpec.class,
                  com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
                      .BoostControlSpec.Builder.class);
        }

        /**
         *
         *
         * <pre>
         * The attribute(or function) for which the custom ranking is to be
         * applied.
         * </pre>
         *
         * Protobuf enum {@code
         * google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec.BoostControlSpec.AttributeType}
         */
        public enum AttributeType implements com.google.protobuf.ProtocolMessageEnum {
          /**
           *
           *
           * <pre>
           * Unspecified AttributeType.
           * </pre>
           *
           * <code>ATTRIBUTE_TYPE_UNSPECIFIED = 0;</code>
           */
          ATTRIBUTE_TYPE_UNSPECIFIED(0),
          /**
           *
           *
           * <pre>
           * The value of the numerical field will be used to dynamically update
           * the boost amount. In this case, the attribute_value (the x value)
           * of the control point will be the actual value of the numerical
           * field for which the boost_amount is specified.
           * </pre>
           *
           * <code>NUMERICAL = 1;</code>
           */
          NUMERICAL(1),
          /**
           *
           *
           * <pre>
           * For the freshness use case the attribute value will be the duration
           * between the current time and the date in the datetime field
           * specified. The value must be formatted as an XSD `dayTimeDuration`
           * value (a restricted subset of an ISO 8601 duration value). The
           * pattern for this is: `[nD][T[nH][nM][nS]]`.
           * E.g. `5D`, `3DT12H30M`, `T24H`.
           * </pre>
           *
           * <code>FRESHNESS = 2;</code>
           */
          FRESHNESS(2),
          UNRECOGNIZED(-1),
          ;

          /**
           *
           *
           * <pre>
           * Unspecified AttributeType.
           * </pre>
           *
           * <code>ATTRIBUTE_TYPE_UNSPECIFIED = 0;</code>
           */
          public static final int ATTRIBUTE_TYPE_UNSPECIFIED_VALUE = 0;
          /**
           *
           *
           * <pre>
           * The value of the numerical field will be used to dynamically update
           * the boost amount. In this case, the attribute_value (the x value)
           * of the control point will be the actual value of the numerical
           * field for which the boost_amount is specified.
           * </pre>
           *
           * <code>NUMERICAL = 1;</code>
           */
          public static final int NUMERICAL_VALUE = 1;
          /**
           *
           *
           * <pre>
           * For the freshness use case the attribute value will be the duration
           * between the current time and the date in the datetime field
           * specified. The value must be formatted as an XSD `dayTimeDuration`
           * value (a restricted subset of an ISO 8601 duration value). The
           * pattern for this is: `[nD][T[nH][nM][nS]]`.
           * E.g. `5D`, `3DT12H30M`, `T24H`.
           * </pre>
           *
           * <code>FRESHNESS = 2;</code>
           */
          public static final int FRESHNESS_VALUE = 2;

          public final int getNumber() {
            if (this == UNRECOGNIZED) {
              throw new java.lang.IllegalArgumentException(
                  "Can't get the number of an unknown enum value.");
            }
            return value;
          }

          /**
           * @param value The numeric wire value of the corresponding enum entry.
           * @return The enum associated with the given numeric wire value.
           * @deprecated Use {@link #forNumber(int)} instead.
           */
          @java.lang.Deprecated
          public static AttributeType valueOf(int value) {
            return forNumber(value);
          }

          /**
           * @param value The numeric wire value of the corresponding enum entry.
           * @return The enum associated with the given numeric wire value.
           */
          public static AttributeType forNumber(int value) {
            switch (value) {
              case 0:
                return ATTRIBUTE_TYPE_UNSPECIFIED;
              case 1:
                return NUMERICAL;
              case 2:
                return FRESHNESS;
              default:
                return null;
            }
          }

          public static com.google.protobuf.Internal.EnumLiteMap<AttributeType>
              internalGetValueMap() {
            return internalValueMap;
          }

          private static final com.google.protobuf.Internal.EnumLiteMap<AttributeType>
              internalValueMap =
                  new com.google.protobuf.Internal.EnumLiteMap<AttributeType>() {
                    public AttributeType findValueByNumber(int number) {
                      return AttributeType.forNumber(number);
                    }
                  };

          public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
            if (this == UNRECOGNIZED) {
              throw new java.lang.IllegalStateException(
                  "Can't get the descriptor of an unrecognized enum value.");
            }
            return getDescriptor().getValues().get(ordinal());
          }

          public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
            return getDescriptor();
          }

          public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
            return com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec
                .ConditionBoostSpec.BoostControlSpec.getDescriptor()
                .getEnumTypes()
                .get(0);
          }

          private static final AttributeType[] VALUES = values();

          public static AttributeType valueOf(
              com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
            if (desc.getType() != getDescriptor()) {
              throw new java.lang.IllegalArgumentException(
                  "EnumValueDescriptor is not for this type.");
            }
            if (desc.getIndex() == -1) {
              return UNRECOGNIZED;
            }
            return VALUES[desc.getIndex()];
          }

          private final int value;

          private AttributeType(int value) {
            this.value = value;
          }

          // @@protoc_insertion_point(enum_scope:google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec.BoostControlSpec.AttributeType)
        }

        /**
         *
         *
         * <pre>
         * The interpolation type to be applied. Default will be linear
         * (Piecewise Linear).
         * </pre>
         *
         * Protobuf enum {@code
         * google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec.BoostControlSpec.InterpolationType}
         */
        public enum InterpolationType implements com.google.protobuf.ProtocolMessageEnum {
          /**
           *
           *
           * <pre>
           * Interpolation type is unspecified. In this case, it defaults to
           * Linear.
           * </pre>
           *
           * <code>INTERPOLATION_TYPE_UNSPECIFIED = 0;</code>
           */
          INTERPOLATION_TYPE_UNSPECIFIED(0),
          /**
           *
           *
           * <pre>
           * Piecewise linear interpolation will be applied.
           * </pre>
           *
           * <code>LINEAR = 1;</code>
           */
          LINEAR(1),
          UNRECOGNIZED(-1),
          ;

          /**
           *
           *
           * <pre>
           * Interpolation type is unspecified. In this case, it defaults to
           * Linear.
           * </pre>
           *
           * <code>INTERPOLATION_TYPE_UNSPECIFIED = 0;</code>
           */
          public static final int INTERPOLATION_TYPE_UNSPECIFIED_VALUE = 0;
          /**
           *
           *
           * <pre>
           * Piecewise linear interpolation will be applied.
           * </pre>
           *
           * <code>LINEAR = 1;</code>
           */
          public static final int LINEAR_VALUE = 1;

          public final int getNumber() {
            if (this == UNRECOGNIZED) {
              throw new java.lang.IllegalArgumentException(
                  "Can't get the number of an unknown enum value.");
            }
            return value;
          }

          /**
           * @param value The numeric wire value of the corresponding enum entry.
           * @return The enum associated with the given numeric wire value.
           * @deprecated Use {@link #forNumber(int)} instead.
           */
          @java.lang.Deprecated
          public static InterpolationType valueOf(int value) {
            return forNumber(value);
          }

          /**
           * @param value The numeric wire value of the corresponding enum entry.
           * @return The enum associated with the given numeric wire value.
           */
          public static InterpolationType forNumber(int value) {
            switch (value) {
              case 0:
                return INTERPOLATION_TYPE_UNSPECIFIED;
              case 1:
                return LINEAR;
              default:
                return null;
            }
          }

          public static com.google.protobuf.Internal.EnumLiteMap<InterpolationType>
              internalGetValueMap() {
            return internalValueMap;
          }

          private static final com.google.protobuf.Internal.EnumLiteMap<InterpolationType>
              internalValueMap =
                  new com.google.protobuf.Internal.EnumLiteMap<InterpolationType>() {
                    public InterpolationType findValueByNumber(int number) {
                      return InterpolationType.forNumber(number);
                    }
                  };

          public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
            if (this == UNRECOGNIZED) {
              throw new java.lang.IllegalStateException(
                  "Can't get the descriptor of an unrecognized enum value.");
            }
            return getDescriptor().getValues().get(ordinal());
          }

          public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
            return getDescriptor();
          }

          public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
            return com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec
                .ConditionBoostSpec.BoostControlSpec.getDescriptor()
                .getEnumTypes()
                .get(1);
          }

          private static final InterpolationType[] VALUES = values();

          public static InterpolationType valueOf(
              com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
            if (desc.getType() != getDescriptor()) {
              throw new java.lang.IllegalArgumentException(
                  "EnumValueDescriptor is not for this type.");
            }
            if (desc.getIndex() == -1) {
              return UNRECOGNIZED;
            }
            return VALUES[desc.getIndex()];
          }

          private final int value;

          private InterpolationType(int value) {
            this.value = value;
          }

          // @@protoc_insertion_point(enum_scope:google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec.BoostControlSpec.InterpolationType)
        }

        public interface ControlPointOrBuilder
            extends
            // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec.BoostControlSpec.ControlPoint)
            com.google.protobuf.MessageOrBuilder {

          /**
           *
           *
           * <pre>
           * Can be one of:
           * 1. The numerical field value.
           * 2. The duration spec for freshness:
           * The value must be formatted as an XSD `dayTimeDuration` value (a
           * restricted subset of an ISO 8601 duration value). The pattern for
           * this is: `[nD][T[nH][nM][nS]]`.
           * </pre>
           *
           * <code>string attribute_value = 1;</code>
           *
           * @return The attributeValue.
           */
          java.lang.String getAttributeValue();
          /**
           *
           *
           * <pre>
           * Can be one of:
           * 1. The numerical field value.
           * 2. The duration spec for freshness:
           * The value must be formatted as an XSD `dayTimeDuration` value (a
           * restricted subset of an ISO 8601 duration value). The pattern for
           * this is: `[nD][T[nH][nM][nS]]`.
           * </pre>
           *
           * <code>string attribute_value = 1;</code>
           *
           * @return The bytes for attributeValue.
           */
          com.google.protobuf.ByteString getAttributeValueBytes();

          /**
           *
           *
           * <pre>
           * The value between -1 to 1 by which to boost the score if the
           * attribute_value evaluates to the value specified above.
           * </pre>
           *
           * <code>float boost_amount = 2;</code>
           *
           * @return The boostAmount.
           */
          float getBoostAmount();
        }
        /**
         *
         *
         * <pre>
         * The control points used to define the curve. The curve defined
         * through these control points can only be monotonically increasing
         * or decreasing(constant values are acceptable).
         * </pre>
         *
         * Protobuf type {@code
         * google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec.BoostControlSpec.ControlPoint}
         */
        public static final class ControlPoint extends com.google.protobuf.GeneratedMessageV3
            implements
            // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec.BoostControlSpec.ControlPoint)
            ControlPointOrBuilder {
          private static final long serialVersionUID = 0L;
          // Use ControlPoint.newBuilder() to construct.
          private ControlPoint(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
            super(builder);
          }

          private ControlPoint() {
            attributeValue_ = "";
          }

          @java.lang.Override
          @SuppressWarnings({"unused"})
          protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
            return new ControlPoint();
          }

          public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
            return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
                .internal_static_google_cloud_discoveryengine_v1beta_SearchRequest_BoostSpec_ConditionBoostSpec_BoostControlSpec_ControlPoint_descriptor;
          }

          @java.lang.Override
          protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
              internalGetFieldAccessorTable() {
            return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
                .internal_static_google_cloud_discoveryengine_v1beta_SearchRequest_BoostSpec_ConditionBoostSpec_BoostControlSpec_ControlPoint_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec
                        .ConditionBoostSpec.BoostControlSpec.ControlPoint.class,
                    com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec
                        .ConditionBoostSpec.BoostControlSpec.ControlPoint.Builder.class);
          }

          public static final int ATTRIBUTE_VALUE_FIELD_NUMBER = 1;

          @SuppressWarnings("serial")
          private volatile java.lang.Object attributeValue_ = "";
          /**
           *
           *
           * <pre>
           * Can be one of:
           * 1. The numerical field value.
           * 2. The duration spec for freshness:
           * The value must be formatted as an XSD `dayTimeDuration` value (a
           * restricted subset of an ISO 8601 duration value). The pattern for
           * this is: `[nD][T[nH][nM][nS]]`.
           * </pre>
           *
           * <code>string attribute_value = 1;</code>
           *
           * @return The attributeValue.
           */
          @java.lang.Override
          public java.lang.String getAttributeValue() {
            java.lang.Object ref = attributeValue_;
            if (ref instanceof java.lang.String) {
              return (java.lang.String) ref;
            } else {
              com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
              java.lang.String s = bs.toStringUtf8();
              attributeValue_ = s;
              return s;
            }
          }
          /**
           *
           *
           * <pre>
           * Can be one of:
           * 1. The numerical field value.
           * 2. The duration spec for freshness:
           * The value must be formatted as an XSD `dayTimeDuration` value (a
           * restricted subset of an ISO 8601 duration value). The pattern for
           * this is: `[nD][T[nH][nM][nS]]`.
           * </pre>
           *
           * <code>string attribute_value = 1;</code>
           *
           * @return The bytes for attributeValue.
           */
          @java.lang.Override
          public com.google.protobuf.ByteString getAttributeValueBytes() {
            java.lang.Object ref = attributeValue_;
            if (ref instanceof java.lang.String) {
              com.google.protobuf.ByteString b =
                  com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
              attributeValue_ = b;
              return b;
            } else {
              return (com.google.protobuf.ByteString) ref;
            }
          }

          public static final int BOOST_AMOUNT_FIELD_NUMBER = 2;
          private float boostAmount_ = 0F;
          /**
           *
           *
           * <pre>
           * The value between -1 to 1 by which to boost the score if the
           * attribute_value evaluates to the value specified above.
           * </pre>
           *
           * <code>float boost_amount = 2;</code>
           *
           * @return The boostAmount.
           */
          @java.lang.Override
          public float getBoostAmount() {
            return boostAmount_;
          }

          private byte memoizedIsInitialized = -1;

          @java.lang.Override
          public final boolean isInitialized() {
            byte isInitialized = memoizedIsInitialized;
            if (isInitialized == 1) return true;
            if (isInitialized == 0) return false;

            memoizedIsInitialized = 1;
            return true;
          }

          @java.lang.Override
          public void writeTo(com.google.protobuf.CodedOutputStream output)
              throws java.io.IOException {
            if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(attributeValue_)) {
              com.google.protobuf.GeneratedMessageV3.writeString(output, 1, attributeValue_);
            }
            if (java.lang.Float.floatToRawIntBits(boostAmount_) != 0) {
              output.writeFloat(2, boostAmount_);
            }
            getUnknownFields().writeTo(output);
          }

          @java.lang.Override
          public int getSerializedSize() {
            int size = memoizedSize;
            if (size != -1) return size;

            size = 0;
            if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(attributeValue_)) {
              size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, attributeValue_);
            }
            if (java.lang.Float.floatToRawIntBits(boostAmount_) != 0) {
              size += com.google.protobuf.CodedOutputStream.computeFloatSize(2, boostAmount_);
            }
            size += getUnknownFields().getSerializedSize();
            memoizedSize = size;
            return size;
          }

          @java.lang.Override
          public boolean equals(final java.lang.Object obj) {
            if (obj == this) {
              return true;
            }
            if (!(obj
                instanceof
                com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
                    .BoostControlSpec.ControlPoint)) {
              return super.equals(obj);
            }
            com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
                    .BoostControlSpec.ControlPoint
                other =
                    (com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec
                            .ConditionBoostSpec.BoostControlSpec.ControlPoint)
                        obj;

            if (!getAttributeValue().equals(other.getAttributeValue())) return false;
            if (java.lang.Float.floatToIntBits(getBoostAmount())
                != java.lang.Float.floatToIntBits(other.getBoostAmount())) return false;
            if (!getUnknownFields().equals(other.getUnknownFields())) return false;
            return true;
          }

          @java.lang.Override
          public int hashCode() {
            if (memoizedHashCode != 0) {
              return memoizedHashCode;
            }
            int hash = 41;
            hash = (19 * hash) + getDescriptor().hashCode();
            hash = (37 * hash) + ATTRIBUTE_VALUE_FIELD_NUMBER;
            hash = (53 * hash) + getAttributeValue().hashCode();
            hash = (37 * hash) + BOOST_AMOUNT_FIELD_NUMBER;
            hash = (53 * hash) + java.lang.Float.floatToIntBits(getBoostAmount());
            hash = (29 * hash) + getUnknownFields().hashCode();
            memoizedHashCode = hash;
            return hash;
          }

          public static com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec
                  .ConditionBoostSpec.BoostControlSpec.ControlPoint
              parseFrom(java.nio.ByteBuffer data)
                  throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data);
          }

          public static com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec
                  .ConditionBoostSpec.BoostControlSpec.ControlPoint
              parseFrom(
                  java.nio.ByteBuffer data,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data, extensionRegistry);
          }

          public static com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec
                  .ConditionBoostSpec.BoostControlSpec.ControlPoint
              parseFrom(com.google.protobuf.ByteString data)
                  throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data);
          }

          public static com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec
                  .ConditionBoostSpec.BoostControlSpec.ControlPoint
              parseFrom(
                  com.google.protobuf.ByteString data,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data, extensionRegistry);
          }

          public static com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec
                  .ConditionBoostSpec.BoostControlSpec.ControlPoint
              parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data);
          }

          public static com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec
                  .ConditionBoostSpec.BoostControlSpec.ControlPoint
              parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data, extensionRegistry);
          }

          public static com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec
                  .ConditionBoostSpec.BoostControlSpec.ControlPoint
              parseFrom(java.io.InputStream input) throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
          }

          public static com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec
                  .ConditionBoostSpec.BoostControlSpec.ControlPoint
              parseFrom(
                  java.io.InputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
                PARSER, input, extensionRegistry);
          }

          public static com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec
                  .ConditionBoostSpec.BoostControlSpec.ControlPoint
              parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
                PARSER, input);
          }

          public static com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec
                  .ConditionBoostSpec.BoostControlSpec.ControlPoint
              parseDelimitedFrom(
                  java.io.InputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
                PARSER, input, extensionRegistry);
          }

          public static com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec
                  .ConditionBoostSpec.BoostControlSpec.ControlPoint
              parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
          }

          public static com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec
                  .ConditionBoostSpec.BoostControlSpec.ControlPoint
              parseFrom(
                  com.google.protobuf.CodedInputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
                PARSER, input, extensionRegistry);
          }

          @java.lang.Override
          public Builder newBuilderForType() {
            return newBuilder();
          }

          public static Builder newBuilder() {
            return DEFAULT_INSTANCE.toBuilder();
          }

          public static Builder newBuilder(
              com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
                      .BoostControlSpec.ControlPoint
                  prototype) {
            return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
          }

          @java.lang.Override
          public Builder toBuilder() {
            return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
          }

          @java.lang.Override
          protected Builder newBuilderForType(
              com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            Builder builder = new Builder(parent);
            return builder;
          }
          /**
           *
           *
           * <pre>
           * The control points used to define the curve. The curve defined
           * through these control points can only be monotonically increasing
           * or decreasing(constant values are acceptable).
           * </pre>
           *
           * Protobuf type {@code
           * google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec.BoostControlSpec.ControlPoint}
           */
          public static final class Builder
              extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
              implements
              // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec.BoostControlSpec.ControlPoint)
              com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
                  .BoostControlSpec.ControlPointOrBuilder {
            public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
              return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
                  .internal_static_google_cloud_discoveryengine_v1beta_SearchRequest_BoostSpec_ConditionBoostSpec_BoostControlSpec_ControlPoint_descriptor;
            }

            @java.lang.Override
            protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
                internalGetFieldAccessorTable() {
              return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
                  .internal_static_google_cloud_discoveryengine_v1beta_SearchRequest_BoostSpec_ConditionBoostSpec_BoostControlSpec_ControlPoint_fieldAccessorTable
                  .ensureFieldAccessorsInitialized(
                      com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec
                          .ConditionBoostSpec.BoostControlSpec.ControlPoint.class,
                      com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec
                          .ConditionBoostSpec.BoostControlSpec.ControlPoint.Builder.class);
            }

            // Construct using
            // com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec.BoostControlSpec.ControlPoint.newBuilder()
            private Builder() {}

            private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
              super(parent);
            }

            @java.lang.Override
            public Builder clear() {
              super.clear();
              bitField0_ = 0;
              attributeValue_ = "";
              boostAmount_ = 0F;
              return this;
            }

            @java.lang.Override
            public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
              return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
                  .internal_static_google_cloud_discoveryengine_v1beta_SearchRequest_BoostSpec_ConditionBoostSpec_BoostControlSpec_ControlPoint_descriptor;
            }

            @java.lang.Override
            public com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec
                    .ConditionBoostSpec.BoostControlSpec.ControlPoint
                getDefaultInstanceForType() {
              return com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec
                  .ConditionBoostSpec.BoostControlSpec.ControlPoint.getDefaultInstance();
            }

            @java.lang.Override
            public com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec
                    .ConditionBoostSpec.BoostControlSpec.ControlPoint
                build() {
              com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
                      .BoostControlSpec.ControlPoint
                  result = buildPartial();
              if (!result.isInitialized()) {
                throw newUninitializedMessageException(result);
              }
              return result;
            }

            @java.lang.Override
            public com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec
                    .ConditionBoostSpec.BoostControlSpec.ControlPoint
                buildPartial() {
              com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
                      .BoostControlSpec.ControlPoint
                  result =
                      new com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec
                          .ConditionBoostSpec.BoostControlSpec.ControlPoint(this);
              if (bitField0_ != 0) {
                buildPartial0(result);
              }
              onBuilt();
              return result;
            }

            private void buildPartial0(
                com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
                        .BoostControlSpec.ControlPoint
                    result) {
              int from_bitField0_ = bitField0_;
              if (((from_bitField0_ & 0x00000001) != 0)) {
                result.attributeValue_ = attributeValue_;
              }
              if (((from_bitField0_ & 0x00000002) != 0)) {
                result.boostAmount_ = boostAmount_;
              }
            }

            @java.lang.Override
            public Builder clone() {
              return super.clone();
            }

            @java.lang.Override
            public Builder setField(
                com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
              return super.setField(field, value);
            }

            @java.lang.Override
            public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
              return super.clearField(field);
            }

            @java.lang.Override
            public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
              return super.clearOneof(oneof);
            }

            @java.lang.Override
            public Builder setRepeatedField(
                com.google.protobuf.Descriptors.FieldDescriptor field,
                int index,
                java.lang.Object value) {
              return super.setRepeatedField(field, index, value);
            }

            @java.lang.Override
            public Builder addRepeatedField(
                com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
              return super.addRepeatedField(field, value);
            }

            @java.lang.Override
            public Builder mergeFrom(com.google.protobuf.Message other) {
              if (other
                  instanceof
                  com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
                      .BoostControlSpec.ControlPoint) {
                return mergeFrom(
                    (com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec
                            .ConditionBoostSpec.BoostControlSpec.ControlPoint)
                        other);
              } else {
                super.mergeFrom(other);
                return this;
              }
            }

            public Builder mergeFrom(
                com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
                        .BoostControlSpec.ControlPoint
                    other) {
              if (other
                  == com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec
                      .ConditionBoostSpec.BoostControlSpec.ControlPoint.getDefaultInstance())
                return this;
              if (!other.getAttributeValue().isEmpty()) {
                attributeValue_ = other.attributeValue_;
                bitField0_ |= 0x00000001;
                onChanged();
              }
              if (other.getBoostAmount() != 0F) {
                setBoostAmount(other.getBoostAmount());
              }
              this.mergeUnknownFields(other.getUnknownFields());
              onChanged();
              return this;
            }

            @java.lang.Override
            public final boolean isInitialized() {
              return true;
            }

            @java.lang.Override
            public Builder mergeFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
              if (extensionRegistry == null) {
                throw new java.lang.NullPointerException();
              }
              try {
                boolean done = false;
                while (!done) {
                  int tag = input.readTag();
                  switch (tag) {
                    case 0:
                      done = true;
                      break;
                    case 10:
                      {
                        attributeValue_ = input.readStringRequireUtf8();
                        bitField0_ |= 0x00000001;
                        break;
                      } // case 10
                    case 21:
                      {
                        boostAmount_ = input.readFloat();
                        bitField0_ |= 0x00000002;
                        break;
                      } // case 21
                    default:
                      {
                        if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                          done = true; // was an endgroup tag
                        }
                        break;
                      } // default:
                  } // switch (tag)
                } // while (!done)
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
              } finally {
                onChanged();
              } // finally
              return this;
            }

            private int bitField0_;

            private java.lang.Object attributeValue_ = "";
            /**
             *
             *
             * <pre>
             * Can be one of:
             * 1. The numerical field value.
             * 2. The duration spec for freshness:
             * The value must be formatted as an XSD `dayTimeDuration` value (a
             * restricted subset of an ISO 8601 duration value). The pattern for
             * this is: `[nD][T[nH][nM][nS]]`.
             * </pre>
             *
             * <code>string attribute_value = 1;</code>
             *
             * @return The attributeValue.
             */
            public java.lang.String getAttributeValue() {
              java.lang.Object ref = attributeValue_;
              if (!(ref instanceof java.lang.String)) {
                com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
                java.lang.String s = bs.toStringUtf8();
                attributeValue_ = s;
                return s;
              } else {
                return (java.lang.String) ref;
              }
            }
            /**
             *
             *
             * <pre>
             * Can be one of:
             * 1. The numerical field value.
             * 2. The duration spec for freshness:
             * The value must be formatted as an XSD `dayTimeDuration` value (a
             * restricted subset of an ISO 8601 duration value). The pattern for
             * this is: `[nD][T[nH][nM][nS]]`.
             * </pre>
             *
             * <code>string attribute_value = 1;</code>
             *
             * @return The bytes for attributeValue.
             */
            public com.google.protobuf.ByteString getAttributeValueBytes() {
              java.lang.Object ref = attributeValue_;
              if (ref instanceof String) {
                com.google.protobuf.ByteString b =
                    com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
                attributeValue_ = b;
                return b;
              } else {
                return (com.google.protobuf.ByteString) ref;
              }
            }
            /**
             *
             *
             * <pre>
             * Can be one of:
             * 1. The numerical field value.
             * 2. The duration spec for freshness:
             * The value must be formatted as an XSD `dayTimeDuration` value (a
             * restricted subset of an ISO 8601 duration value). The pattern for
             * this is: `[nD][T[nH][nM][nS]]`.
             * </pre>
             *
             * <code>string attribute_value = 1;</code>
             *
             * @param value The attributeValue to set.
             * @return This builder for chaining.
             */
            public Builder setAttributeValue(java.lang.String value) {
              if (value == null) {
                throw new NullPointerException();
              }
              attributeValue_ = value;
              bitField0_ |= 0x00000001;
              onChanged();
              return this;
            }
            /**
             *
             *
             * <pre>
             * Can be one of:
             * 1. The numerical field value.
             * 2. The duration spec for freshness:
             * The value must be formatted as an XSD `dayTimeDuration` value (a
             * restricted subset of an ISO 8601 duration value). The pattern for
             * this is: `[nD][T[nH][nM][nS]]`.
             * </pre>
             *
             * <code>string attribute_value = 1;</code>
             *
             * @return This builder for chaining.
             */
            public Builder clearAttributeValue() {
              attributeValue_ = getDefaultInstance().getAttributeValue();
              bitField0_ = (bitField0_ & ~0x00000001);
              onChanged();
              return this;
            }
            /**
             *
             *
             * <pre>
             * Can be one of:
             * 1. The numerical field value.
             * 2. The duration spec for freshness:
             * The value must be formatted as an XSD `dayTimeDuration` value (a
             * restricted subset of an ISO 8601 duration value). The pattern for
             * this is: `[nD][T[nH][nM][nS]]`.
             * </pre>
             *
             * <code>string attribute_value = 1;</code>
             *
             * @param value The bytes for attributeValue to set.
             * @return This builder for chaining.
             */
            public Builder setAttributeValueBytes(com.google.protobuf.ByteString value) {
              if (value == null) {
                throw new NullPointerException();
              }
              checkByteStringIsUtf8(value);
              attributeValue_ = value;
              bitField0_ |= 0x00000001;
              onChanged();
              return this;
            }

            private float boostAmount_;
            /**
             *
             *
             * <pre>
             * The value between -1 to 1 by which to boost the score if the
             * attribute_value evaluates to the value specified above.
             * </pre>
             *
             * <code>float boost_amount = 2;</code>
             *
             * @return The boostAmount.
             */
            @java.lang.Override
            public float getBoostAmount() {
              return boostAmount_;
            }
            /**
             *
             *
             * <pre>
             * The value between -1 to 1 by which to boost the score if the
             * attribute_value evaluates to the value specified above.
             * </pre>
             *
             * <code>float boost_amount = 2;</code>
             *
             * @param value The boostAmount to set.
             * @return This builder for chaining.
             */
            public Builder setBoostAmount(float value) {

              boostAmount_ = value;
              bitField0_ |= 0x00000002;
              onChanged();
              return this;
            }
            /**
             *
             *
             * <pre>
             * The value between -1 to 1 by which to boost the score if the
             * attribute_value evaluates to the value specified above.
             * </pre>
             *
             * <code>float boost_amount = 2;</code>
             *
             * @return This builder for chaining.
             */
            public Builder clearBoostAmount() {
              bitField0_ = (bitField0_ & ~0x00000002);
              boostAmount_ = 0F;
              onChanged();
              return this;
            }

            @java.lang.Override
            public final Builder setUnknownFields(
                final com.google.protobuf.UnknownFieldSet unknownFields) {
              return super.setUnknownFields(unknownFields);
            }

            @java.lang.Override
            public final Builder mergeUnknownFields(
                final com.google.protobuf.UnknownFieldSet unknownFields) {
              return super.mergeUnknownFields(unknownFields);
            }

            // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec.BoostControlSpec.ControlPoint)
          }

          // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec.BoostControlSpec.ControlPoint)
          private static final com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec
                  .ConditionBoostSpec.BoostControlSpec.ControlPoint
              DEFAULT_INSTANCE;

          static {
            DEFAULT_INSTANCE =
                new com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec
                    .ConditionBoostSpec.BoostControlSpec.ControlPoint();
          }

          public static com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec
                  .ConditionBoostSpec.BoostControlSpec.ControlPoint
              getDefaultInstance() {
            return DEFAULT_INSTANCE;
          }

          private static final com.google.protobuf.Parser<ControlPoint> PARSER =
              new com.google.protobuf.AbstractParser<ControlPoint>() {
                @java.lang.Override
                public ControlPoint parsePartialFrom(
                    com.google.protobuf.CodedInputStream input,
                    com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                    throws com.google.protobuf.InvalidProtocolBufferException {
                  Builder builder = newBuilder();
                  try {
                    builder.mergeFrom(input, extensionRegistry);
                  } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                    throw e.setUnfinishedMessage(builder.buildPartial());
                  } catch (com.google.protobuf.UninitializedMessageException e) {
                    throw e.asInvalidProtocolBufferException()
                        .setUnfinishedMessage(builder.buildPartial());
                  } catch (java.io.IOException e) {
                    throw new com.google.protobuf.InvalidProtocolBufferException(e)
                        .setUnfinishedMessage(builder.buildPartial());
                  }
                  return builder.buildPartial();
                }
              };

          public static com.google.protobuf.Parser<ControlPoint> parser() {
            return PARSER;
          }

          @java.lang.Override
          public com.google.protobuf.Parser<ControlPoint> getParserForType() {
            return PARSER;
          }

          @java.lang.Override
          public com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
                  .BoostControlSpec.ControlPoint
              getDefaultInstanceForType() {
            return DEFAULT_INSTANCE;
          }
        }

        public static final int FIELD_NAME_FIELD_NUMBER = 1;

        @SuppressWarnings("serial")
        private volatile java.lang.Object fieldName_ = "";
        /**
         *
         *
         * <pre>
         * The name of the field whose value will be used to determine the
         * boost amount.
         * </pre>
         *
         * <code>string field_name = 1;</code>
         *
         * @return The fieldName.
         */
        @java.lang.Override
        public java.lang.String getFieldName() {
          java.lang.Object ref = fieldName_;
          if (ref instanceof java.lang.String) {
            return (java.lang.String) ref;
          } else {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            fieldName_ = s;
            return s;
          }
        }
        /**
         *
         *
         * <pre>
         * The name of the field whose value will be used to determine the
         * boost amount.
         * </pre>
         *
         * <code>string field_name = 1;</code>
         *
         * @return The bytes for fieldName.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString getFieldNameBytes() {
          java.lang.Object ref = fieldName_;
          if (ref instanceof java.lang.String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            fieldName_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        public static final int ATTRIBUTE_TYPE_FIELD_NUMBER = 2;
        private int attributeType_ = 0;
        /**
         *
         *
         * <pre>
         * The attribute type to be used to determine the boost amount. The
         * attribute value can be derived from the field value of the specified
         * field_name. In the case of numerical it is straightforward i.e.
         * attribute_value = numerical_field_value. In the case of freshness
         * however, attribute_value = (time.now() - datetime_field_value).
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec.BoostControlSpec.AttributeType attribute_type = 2;
         * </code>
         *
         * @return The enum numeric value on the wire for attributeType.
         */
        @java.lang.Override
        public int getAttributeTypeValue() {
          return attributeType_;
        }
        /**
         *
         *
         * <pre>
         * The attribute type to be used to determine the boost amount. The
         * attribute value can be derived from the field value of the specified
         * field_name. In the case of numerical it is straightforward i.e.
         * attribute_value = numerical_field_value. In the case of freshness
         * however, attribute_value = (time.now() - datetime_field_value).
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec.BoostControlSpec.AttributeType attribute_type = 2;
         * </code>
         *
         * @return The attributeType.
         */
        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
                .BoostControlSpec.AttributeType
            getAttributeType() {
          com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
                  .BoostControlSpec.AttributeType
              result =
                  com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
                      .BoostControlSpec.AttributeType.forNumber(attributeType_);
          return result == null
              ? com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
                  .BoostControlSpec.AttributeType.UNRECOGNIZED
              : result;
        }

        public static final int INTERPOLATION_TYPE_FIELD_NUMBER = 3;
        private int interpolationType_ = 0;
        /**
         *
         *
         * <pre>
         * The interpolation type to be applied to connect the control points
         * listed below.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec.BoostControlSpec.InterpolationType interpolation_type = 3;
         * </code>
         *
         * @return The enum numeric value on the wire for interpolationType.
         */
        @java.lang.Override
        public int getInterpolationTypeValue() {
          return interpolationType_;
        }
        /**
         *
         *
         * <pre>
         * The interpolation type to be applied to connect the control points
         * listed below.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec.BoostControlSpec.InterpolationType interpolation_type = 3;
         * </code>
         *
         * @return The interpolationType.
         */
        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
                .BoostControlSpec.InterpolationType
            getInterpolationType() {
          com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
                  .BoostControlSpec.InterpolationType
              result =
                  com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
                      .BoostControlSpec.InterpolationType.forNumber(interpolationType_);
          return result == null
              ? com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
                  .BoostControlSpec.InterpolationType.UNRECOGNIZED
              : result;
        }

        public static final int CONTROL_POINTS_FIELD_NUMBER = 4;

        @SuppressWarnings("serial")
        private java.util.List<
                com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
                    .BoostControlSpec.ControlPoint>
            controlPoints_;
        /**
         *
         *
         * <pre>
         * The control points used to define the curve. The monotonic function
         * (defined through the interpolation_type above) passes through the
         * control points listed here.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec.BoostControlSpec.ControlPoint control_points = 4;
         * </code>
         */
        @java.lang.Override
        public java.util.List<
                com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
                    .BoostControlSpec.ControlPoint>
            getControlPointsList() {
          return controlPoints_;
        }
        /**
         *
         *
         * <pre>
         * The control points used to define the curve. The monotonic function
         * (defined through the interpolation_type above) passes through the
         * control points listed here.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec.BoostControlSpec.ControlPoint control_points = 4;
         * </code>
         */
        @java.lang.Override
        public java.util.List<
                ? extends
                    com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec
                        .ConditionBoostSpec.BoostControlSpec.ControlPointOrBuilder>
            getControlPointsOrBuilderList() {
          return controlPoints_;
        }
        /**
         *
         *
         * <pre>
         * The control points used to define the curve. The monotonic function
         * (defined through the interpolation_type above) passes through the
         * control points listed here.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec.BoostControlSpec.ControlPoint control_points = 4;
         * </code>
         */
        @java.lang.Override
        public int getControlPointsCount() {
          return controlPoints_.size();
        }
        /**
         *
         *
         * <pre>
         * The control points used to define the curve. The monotonic function
         * (defined through the interpolation_type above) passes through the
         * control points listed here.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec.BoostControlSpec.ControlPoint control_points = 4;
         * </code>
         */
        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
                .BoostControlSpec.ControlPoint
            getControlPoints(int index) {
          return controlPoints_.get(index);
        }
        /**
         *
         *
         * <pre>
         * The control points used to define the curve. The monotonic function
         * (defined through the interpolation_type above) passes through the
         * control points listed here.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec.BoostControlSpec.ControlPoint control_points = 4;
         * </code>
         */
        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
                .BoostControlSpec.ControlPointOrBuilder
            getControlPointsOrBuilder(int index) {
          return controlPoints_.get(index);
        }

        private byte memoizedIsInitialized = -1;

        @java.lang.Override
        public final boolean isInitialized() {
          byte isInitialized = memoizedIsInitialized;
          if (isInitialized == 1) return true;
          if (isInitialized == 0) return false;

          memoizedIsInitialized = 1;
          return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
            throws java.io.IOException {
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(fieldName_)) {
            com.google.protobuf.GeneratedMessageV3.writeString(output, 1, fieldName_);
          }
          if (attributeType_
              != com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
                  .BoostControlSpec.AttributeType.ATTRIBUTE_TYPE_UNSPECIFIED
                  .getNumber()) {
            output.writeEnum(2, attributeType_);
          }
          if (interpolationType_
              != com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
                  .BoostControlSpec.InterpolationType.INTERPOLATION_TYPE_UNSPECIFIED
                  .getNumber()) {
            output.writeEnum(3, interpolationType_);
          }
          for (int i = 0; i < controlPoints_.size(); i++) {
            output.writeMessage(4, controlPoints_.get(i));
          }
          getUnknownFields().writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
          int size = memoizedSize;
          if (size != -1) return size;

          size = 0;
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(fieldName_)) {
            size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, fieldName_);
          }
          if (attributeType_
              != com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
                  .BoostControlSpec.AttributeType.ATTRIBUTE_TYPE_UNSPECIFIED
                  .getNumber()) {
            size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, attributeType_);
          }
          if (interpolationType_
              != com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
                  .BoostControlSpec.InterpolationType.INTERPOLATION_TYPE_UNSPECIFIED
                  .getNumber()) {
            size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, interpolationType_);
          }
          for (int i = 0; i < controlPoints_.size(); i++) {
            size +=
                com.google.protobuf.CodedOutputStream.computeMessageSize(4, controlPoints_.get(i));
          }
          size += getUnknownFields().getSerializedSize();
          memoizedSize = size;
          return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
          if (obj == this) {
            return true;
          }
          if (!(obj
              instanceof
              com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
                  .BoostControlSpec)) {
            return super.equals(obj);
          }
          com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
                  .BoostControlSpec
              other =
                  (com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec
                          .ConditionBoostSpec.BoostControlSpec)
                      obj;

          if (!getFieldName().equals(other.getFieldName())) return false;
          if (attributeType_ != other.attributeType_) return false;
          if (interpolationType_ != other.interpolationType_) return false;
          if (!getControlPointsList().equals(other.getControlPointsList())) return false;
          if (!getUnknownFields().equals(other.getUnknownFields())) return false;
          return true;
        }

        @java.lang.Override
        public int hashCode() {
          if (memoizedHashCode != 0) {
            return memoizedHashCode;
          }
          int hash = 41;
          hash = (19 * hash) + getDescriptor().hashCode();
          hash = (37 * hash) + FIELD_NAME_FIELD_NUMBER;
          hash = (53 * hash) + getFieldName().hashCode();
          hash = (37 * hash) + ATTRIBUTE_TYPE_FIELD_NUMBER;
          hash = (53 * hash) + attributeType_;
          hash = (37 * hash) + INTERPOLATION_TYPE_FIELD_NUMBER;
          hash = (53 * hash) + interpolationType_;
          if (getControlPointsCount() > 0) {
            hash = (37 * hash) + CONTROL_POINTS_FIELD_NUMBER;
            hash = (53 * hash) + getControlPointsList().hashCode();
          }
          hash = (29 * hash) + getUnknownFields().hashCode();
          memoizedHashCode = hash;
          return hash;
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec
                .ConditionBoostSpec.BoostControlSpec
            parseFrom(java.nio.ByteBuffer data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec
                .ConditionBoostSpec.BoostControlSpec
            parseFrom(
                java.nio.ByteBuffer data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec
                .ConditionBoostSpec.BoostControlSpec
            parseFrom(com.google.protobuf.ByteString data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec
                .ConditionBoostSpec.BoostControlSpec
            parseFrom(
                com.google.protobuf.ByteString data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec
                .ConditionBoostSpec.BoostControlSpec
            parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec
                .ConditionBoostSpec.BoostControlSpec
            parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec
                .ConditionBoostSpec.BoostControlSpec
            parseFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec
                .ConditionBoostSpec.BoostControlSpec
            parseFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec
                .ConditionBoostSpec.BoostControlSpec
            parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input);
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec
                .ConditionBoostSpec.BoostControlSpec
            parseDelimitedFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec
                .ConditionBoostSpec.BoostControlSpec
            parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec
                .ConditionBoostSpec.BoostControlSpec
            parseFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() {
          return newBuilder();
        }

        public static Builder newBuilder() {
          return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(
            com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
                    .BoostControlSpec
                prototype) {
          return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @java.lang.Override
        public Builder toBuilder() {
          return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          Builder builder = new Builder(parent);
          return builder;
        }
        /**
         *
         *
         * <pre>
         * Specification for custom ranking based on customer specified attribute
         * value. It provides more controls for customized ranking than the simple
         * (condition, boost) combination above.
         * </pre>
         *
         * Protobuf type {@code
         * google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec.BoostControlSpec}
         */
        public static final class Builder
            extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
            implements
            // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec.BoostControlSpec)
            com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
                .BoostControlSpecOrBuilder {
          public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
            return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
                .internal_static_google_cloud_discoveryengine_v1beta_SearchRequest_BoostSpec_ConditionBoostSpec_BoostControlSpec_descriptor;
          }

          @java.lang.Override
          protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
              internalGetFieldAccessorTable() {
            return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
                .internal_static_google_cloud_discoveryengine_v1beta_SearchRequest_BoostSpec_ConditionBoostSpec_BoostControlSpec_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec
                        .ConditionBoostSpec.BoostControlSpec.class,
                    com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec
                        .ConditionBoostSpec.BoostControlSpec.Builder.class);
          }

          // Construct using
          // com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec.BoostControlSpec.newBuilder()
          private Builder() {}

          private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            super(parent);
          }

          @java.lang.Override
          public Builder clear() {
            super.clear();
            bitField0_ = 0;
            fieldName_ = "";
            attributeType_ = 0;
            interpolationType_ = 0;
            if (controlPointsBuilder_ == null) {
              controlPoints_ = java.util.Collections.emptyList();
            } else {
              controlPoints_ = null;
              controlPointsBuilder_.clear();
            }
            bitField0_ = (bitField0_ & ~0x00000008);
            return this;
          }

          @java.lang.Override
          public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
            return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
                .internal_static_google_cloud_discoveryengine_v1beta_SearchRequest_BoostSpec_ConditionBoostSpec_BoostControlSpec_descriptor;
          }

          @java.lang.Override
          public com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
                  .BoostControlSpec
              getDefaultInstanceForType() {
            return com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec
                .ConditionBoostSpec.BoostControlSpec.getDefaultInstance();
          }

          @java.lang.Override
          public com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
                  .BoostControlSpec
              build() {
            com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
                    .BoostControlSpec
                result = buildPartial();
            if (!result.isInitialized()) {
              throw newUninitializedMessageException(result);
            }
            return result;
          }

          @java.lang.Override
          public com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
                  .BoostControlSpec
              buildPartial() {
            com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
                    .BoostControlSpec
                result =
                    new com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec
                        .ConditionBoostSpec.BoostControlSpec(this);
            buildPartialRepeatedFields(result);
            if (bitField0_ != 0) {
              buildPartial0(result);
            }
            onBuilt();
            return result;
          }

          private void buildPartialRepeatedFields(
              com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
                      .BoostControlSpec
                  result) {
            if (controlPointsBuilder_ == null) {
              if (((bitField0_ & 0x00000008) != 0)) {
                controlPoints_ = java.util.Collections.unmodifiableList(controlPoints_);
                bitField0_ = (bitField0_ & ~0x00000008);
              }
              result.controlPoints_ = controlPoints_;
            } else {
              result.controlPoints_ = controlPointsBuilder_.build();
            }
          }

          private void buildPartial0(
              com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
                      .BoostControlSpec
                  result) {
            int from_bitField0_ = bitField0_;
            if (((from_bitField0_ & 0x00000001) != 0)) {
              result.fieldName_ = fieldName_;
            }
            if (((from_bitField0_ & 0x00000002) != 0)) {
              result.attributeType_ = attributeType_;
            }
            if (((from_bitField0_ & 0x00000004) != 0)) {
              result.interpolationType_ = interpolationType_;
            }
          }

          @java.lang.Override
          public Builder clone() {
            return super.clone();
          }

          @java.lang.Override
          public Builder setField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.setField(field, value);
          }

          @java.lang.Override
          public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
            return super.clearField(field);
          }

          @java.lang.Override
          public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
            return super.clearOneof(oneof);
          }

          @java.lang.Override
          public Builder setRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field,
              int index,
              java.lang.Object value) {
            return super.setRepeatedField(field, index, value);
          }

          @java.lang.Override
          public Builder addRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.addRepeatedField(field, value);
          }

          @java.lang.Override
          public Builder mergeFrom(com.google.protobuf.Message other) {
            if (other
                instanceof
                com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
                    .BoostControlSpec) {
              return mergeFrom(
                  (com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec
                          .ConditionBoostSpec.BoostControlSpec)
                      other);
            } else {
              super.mergeFrom(other);
              return this;
            }
          }

          public Builder mergeFrom(
              com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
                      .BoostControlSpec
                  other) {
            if (other
                == com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec
                    .ConditionBoostSpec.BoostControlSpec.getDefaultInstance()) return this;
            if (!other.getFieldName().isEmpty()) {
              fieldName_ = other.fieldName_;
              bitField0_ |= 0x00000001;
              onChanged();
            }
            if (other.attributeType_ != 0) {
              setAttributeTypeValue(other.getAttributeTypeValue());
            }
            if (other.interpolationType_ != 0) {
              setInterpolationTypeValue(other.getInterpolationTypeValue());
            }
            if (controlPointsBuilder_ == null) {
              if (!other.controlPoints_.isEmpty()) {
                if (controlPoints_.isEmpty()) {
                  controlPoints_ = other.controlPoints_;
                  bitField0_ = (bitField0_ & ~0x00000008);
                } else {
                  ensureControlPointsIsMutable();
                  controlPoints_.addAll(other.controlPoints_);
                }
                onChanged();
              }
            } else {
              if (!other.controlPoints_.isEmpty()) {
                if (controlPointsBuilder_.isEmpty()) {
                  controlPointsBuilder_.dispose();
                  controlPointsBuilder_ = null;
                  controlPoints_ = other.controlPoints_;
                  bitField0_ = (bitField0_ & ~0x00000008);
                  controlPointsBuilder_ =
                      com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                          ? getControlPointsFieldBuilder()
                          : null;
                } else {
                  controlPointsBuilder_.addAllMessages(other.controlPoints_);
                }
              }
            }
            this.mergeUnknownFields(other.getUnknownFields());
            onChanged();
            return this;
          }

          @java.lang.Override
          public final boolean isInitialized() {
            return true;
          }

          @java.lang.Override
          public Builder mergeFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
            if (extensionRegistry == null) {
              throw new java.lang.NullPointerException();
            }
            try {
              boolean done = false;
              while (!done) {
                int tag = input.readTag();
                switch (tag) {
                  case 0:
                    done = true;
                    break;
                  case 10:
                    {
                      fieldName_ = input.readStringRequireUtf8();
                      bitField0_ |= 0x00000001;
                      break;
                    } // case 10
                  case 16:
                    {
                      attributeType_ = input.readEnum();
                      bitField0_ |= 0x00000002;
                      break;
                    } // case 16
                  case 24:
                    {
                      interpolationType_ = input.readEnum();
                      bitField0_ |= 0x00000004;
                      break;
                    } // case 24
                  case 34:
                    {
                      com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec
                              .ConditionBoostSpec.BoostControlSpec.ControlPoint
                          m =
                              input.readMessage(
                                  com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec
                                      .ConditionBoostSpec.BoostControlSpec.ControlPoint.parser(),
                                  extensionRegistry);
                      if (controlPointsBuilder_ == null) {
                        ensureControlPointsIsMutable();
                        controlPoints_.add(m);
                      } else {
                        controlPointsBuilder_.addMessage(m);
                      }
                      break;
                    } // case 34
                  default:
                    {
                      if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                        done = true; // was an endgroup tag
                      }
                      break;
                    } // default:
                } // switch (tag)
              } // while (!done)
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.unwrapIOException();
            } finally {
              onChanged();
            } // finally
            return this;
          }

          private int bitField0_;

          private java.lang.Object fieldName_ = "";
          /**
           *
           *
           * <pre>
           * The name of the field whose value will be used to determine the
           * boost amount.
           * </pre>
           *
           * <code>string field_name = 1;</code>
           *
           * @return The fieldName.
           */
          public java.lang.String getFieldName() {
            java.lang.Object ref = fieldName_;
            if (!(ref instanceof java.lang.String)) {
              com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
              java.lang.String s = bs.toStringUtf8();
              fieldName_ = s;
              return s;
            } else {
              return (java.lang.String) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * The name of the field whose value will be used to determine the
           * boost amount.
           * </pre>
           *
           * <code>string field_name = 1;</code>
           *
           * @return The bytes for fieldName.
           */
          public com.google.protobuf.ByteString getFieldNameBytes() {
            java.lang.Object ref = fieldName_;
            if (ref instanceof String) {
              com.google.protobuf.ByteString b =
                  com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
              fieldName_ = b;
              return b;
            } else {
              return (com.google.protobuf.ByteString) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * The name of the field whose value will be used to determine the
           * boost amount.
           * </pre>
           *
           * <code>string field_name = 1;</code>
           *
           * @param value The fieldName to set.
           * @return This builder for chaining.
           */
          public Builder setFieldName(java.lang.String value) {
            if (value == null) {
              throw new NullPointerException();
            }
            fieldName_ = value;
            bitField0_ |= 0x00000001;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * The name of the field whose value will be used to determine the
           * boost amount.
           * </pre>
           *
           * <code>string field_name = 1;</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearFieldName() {
            fieldName_ = getDefaultInstance().getFieldName();
            bitField0_ = (bitField0_ & ~0x00000001);
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * The name of the field whose value will be used to determine the
           * boost amount.
           * </pre>
           *
           * <code>string field_name = 1;</code>
           *
           * @param value The bytes for fieldName to set.
           * @return This builder for chaining.
           */
          public Builder setFieldNameBytes(com.google.protobuf.ByteString value) {
            if (value == null) {
              throw new NullPointerException();
            }
            checkByteStringIsUtf8(value);
            fieldName_ = value;
            bitField0_ |= 0x00000001;
            onChanged();
            return this;
          }

          private int attributeType_ = 0;
          /**
           *
           *
           * <pre>
           * The attribute type to be used to determine the boost amount. The
           * attribute value can be derived from the field value of the specified
           * field_name. In the case of numerical it is straightforward i.e.
           * attribute_value = numerical_field_value. In the case of freshness
           * however, attribute_value = (time.now() - datetime_field_value).
           * </pre>
           *
           * <code>
           * .google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec.BoostControlSpec.AttributeType attribute_type = 2;
           * </code>
           *
           * @return The enum numeric value on the wire for attributeType.
           */
          @java.lang.Override
          public int getAttributeTypeValue() {
            return attributeType_;
          }
          /**
           *
           *
           * <pre>
           * The attribute type to be used to determine the boost amount. The
           * attribute value can be derived from the field value of the specified
           * field_name. In the case of numerical it is straightforward i.e.
           * attribute_value = numerical_field_value. In the case of freshness
           * however, attribute_value = (time.now() - datetime_field_value).
           * </pre>
           *
           * <code>
           * .google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec.BoostControlSpec.AttributeType attribute_type = 2;
           * </code>
           *
           * @param value The enum numeric value on the wire for attributeType to set.
           * @return This builder for chaining.
           */
          public Builder setAttributeTypeValue(int value) {
            attributeType_ = value;
            bitField0_ |= 0x00000002;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * The attribute type to be used to determine the boost amount. The
           * attribute value can be derived from the field value of the specified
           * field_name. In the case of numerical it is straightforward i.e.
           * attribute_value = numerical_field_value. In the case of freshness
           * however, attribute_value = (time.now() - datetime_field_value).
           * </pre>
           *
           * <code>
           * .google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec.BoostControlSpec.AttributeType attribute_type = 2;
           * </code>
           *
           * @return The attributeType.
           */
          @java.lang.Override
          public com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
                  .BoostControlSpec.AttributeType
              getAttributeType() {
            com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
                    .BoostControlSpec.AttributeType
                result =
                    com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec
                        .ConditionBoostSpec.BoostControlSpec.AttributeType.forNumber(
                        attributeType_);
            return result == null
                ? com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
                    .BoostControlSpec.AttributeType.UNRECOGNIZED
                : result;
          }
          /**
           *
           *
           * <pre>
           * The attribute type to be used to determine the boost amount. The
           * attribute value can be derived from the field value of the specified
           * field_name. In the case of numerical it is straightforward i.e.
           * attribute_value = numerical_field_value. In the case of freshness
           * however, attribute_value = (time.now() - datetime_field_value).
           * </pre>
           *
           * <code>
           * .google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec.BoostControlSpec.AttributeType attribute_type = 2;
           * </code>
           *
           * @param value The attributeType to set.
           * @return This builder for chaining.
           */
          public Builder setAttributeType(
              com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
                      .BoostControlSpec.AttributeType
                  value) {
            if (value == null) {
              throw new NullPointerException();
            }
            bitField0_ |= 0x00000002;
            attributeType_ = value.getNumber();
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * The attribute type to be used to determine the boost amount. The
           * attribute value can be derived from the field value of the specified
           * field_name. In the case of numerical it is straightforward i.e.
           * attribute_value = numerical_field_value. In the case of freshness
           * however, attribute_value = (time.now() - datetime_field_value).
           * </pre>
           *
           * <code>
           * .google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec.BoostControlSpec.AttributeType attribute_type = 2;
           * </code>
           *
           * @return This builder for chaining.
           */
          public Builder clearAttributeType() {
            bitField0_ = (bitField0_ & ~0x00000002);
            attributeType_ = 0;
            onChanged();
            return this;
          }

          private int interpolationType_ = 0;
          /**
           *
           *
           * <pre>
           * The interpolation type to be applied to connect the control points
           * listed below.
           * </pre>
           *
           * <code>
           * .google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec.BoostControlSpec.InterpolationType interpolation_type = 3;
           * </code>
           *
           * @return The enum numeric value on the wire for interpolationType.
           */
          @java.lang.Override
          public int getInterpolationTypeValue() {
            return interpolationType_;
          }
          /**
           *
           *
           * <pre>
           * The interpolation type to be applied to connect the control points
           * listed below.
           * </pre>
           *
           * <code>
           * .google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec.BoostControlSpec.InterpolationType interpolation_type = 3;
           * </code>
           *
           * @param value The enum numeric value on the wire for interpolationType to set.
           * @return This builder for chaining.
           */
          public Builder setInterpolationTypeValue(int value) {
            interpolationType_ = value;
            bitField0_ |= 0x00000004;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * The interpolation type to be applied to connect the control points
           * listed below.
           * </pre>
           *
           * <code>
           * .google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec.BoostControlSpec.InterpolationType interpolation_type = 3;
           * </code>
           *
           * @return The interpolationType.
           */
          @java.lang.Override
          public com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
                  .BoostControlSpec.InterpolationType
              getInterpolationType() {
            com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
                    .BoostControlSpec.InterpolationType
                result =
                    com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec
                        .ConditionBoostSpec.BoostControlSpec.InterpolationType.forNumber(
                        interpolationType_);
            return result == null
                ? com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
                    .BoostControlSpec.InterpolationType.UNRECOGNIZED
                : result;
          }
          /**
           *
           *
           * <pre>
           * The interpolation type to be applied to connect the control points
           * listed below.
           * </pre>
           *
           * <code>
           * .google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec.BoostControlSpec.InterpolationType interpolation_type = 3;
           * </code>
           *
           * @param value The interpolationType to set.
           * @return This builder for chaining.
           */
          public Builder setInterpolationType(
              com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
                      .BoostControlSpec.InterpolationType
                  value) {
            if (value == null) {
              throw new NullPointerException();
            }
            bitField0_ |= 0x00000004;
            interpolationType_ = value.getNumber();
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * The interpolation type to be applied to connect the control points
           * listed below.
           * </pre>
           *
           * <code>
           * .google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec.BoostControlSpec.InterpolationType interpolation_type = 3;
           * </code>
           *
           * @return This builder for chaining.
           */
          public Builder clearInterpolationType() {
            bitField0_ = (bitField0_ & ~0x00000004);
            interpolationType_ = 0;
            onChanged();
            return this;
          }

          private java.util.List<
                  com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
                      .BoostControlSpec.ControlPoint>
              controlPoints_ = java.util.Collections.emptyList();

          private void ensureControlPointsIsMutable() {
            if (!((bitField0_ & 0x00000008) != 0)) {
              controlPoints_ =
                  new java.util.ArrayList<
                      com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec
                          .ConditionBoostSpec.BoostControlSpec.ControlPoint>(controlPoints_);
              bitField0_ |= 0x00000008;
            }
          }

          private com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
                      .BoostControlSpec.ControlPoint,
                  com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
                      .BoostControlSpec.ControlPoint.Builder,
                  com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
                      .BoostControlSpec.ControlPointOrBuilder>
              controlPointsBuilder_;

          /**
           *
           *
           * <pre>
           * The control points used to define the curve. The monotonic function
           * (defined through the interpolation_type above) passes through the
           * control points listed here.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec.BoostControlSpec.ControlPoint control_points = 4;
           * </code>
           */
          public java.util.List<
                  com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
                      .BoostControlSpec.ControlPoint>
              getControlPointsList() {
            if (controlPointsBuilder_ == null) {
              return java.util.Collections.unmodifiableList(controlPoints_);
            } else {
              return controlPointsBuilder_.getMessageList();
            }
          }
          /**
           *
           *
           * <pre>
           * The control points used to define the curve. The monotonic function
           * (defined through the interpolation_type above) passes through the
           * control points listed here.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec.BoostControlSpec.ControlPoint control_points = 4;
           * </code>
           */
          public int getControlPointsCount() {
            if (controlPointsBuilder_ == null) {
              return controlPoints_.size();
            } else {
              return controlPointsBuilder_.getCount();
            }
          }
          /**
           *
           *
           * <pre>
           * The control points used to define the curve. The monotonic function
           * (defined through the interpolation_type above) passes through the
           * control points listed here.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec.BoostControlSpec.ControlPoint control_points = 4;
           * </code>
           */
          public com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
                  .BoostControlSpec.ControlPoint
              getControlPoints(int index) {
            if (controlPointsBuilder_ == null) {
              return controlPoints_.get(index);
            } else {
              return controlPointsBuilder_.getMessage(index);
            }
          }
          /**
           *
           *
           * <pre>
           * The control points used to define the curve. The monotonic function
           * (defined through the interpolation_type above) passes through the
           * control points listed here.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec.BoostControlSpec.ControlPoint control_points = 4;
           * </code>
           */
          public Builder setControlPoints(
              int index,
              com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
                      .BoostControlSpec.ControlPoint
                  value) {
            if (controlPointsBuilder_ == null) {
              if (value == null) {
                throw new NullPointerException();
              }
              ensureControlPointsIsMutable();
              controlPoints_.set(index, value);
              onChanged();
            } else {
              controlPointsBuilder_.setMessage(index, value);
            }
            return this;
          }
          /**
           *
           *
           * <pre>
           * The control points used to define the curve. The monotonic function
           * (defined through the interpolation_type above) passes through the
           * control points listed here.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec.BoostControlSpec.ControlPoint control_points = 4;
           * </code>
           */
          public Builder setControlPoints(
              int index,
              com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
                      .BoostControlSpec.ControlPoint.Builder
                  builderForValue) {
            if (controlPointsBuilder_ == null) {
              ensureControlPointsIsMutable();
              controlPoints_.set(index, builderForValue.build());
              onChanged();
            } else {
              controlPointsBuilder_.setMessage(index, builderForValue.build());
            }
            return this;
          }
          /**
           *
           *
           * <pre>
           * The control points used to define the curve. The monotonic function
           * (defined through the interpolation_type above) passes through the
           * control points listed here.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec.BoostControlSpec.ControlPoint control_points = 4;
           * </code>
           */
          public Builder addControlPoints(
              com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
                      .BoostControlSpec.ControlPoint
                  value) {
            if (controlPointsBuilder_ == null) {
              if (value == null) {
                throw new NullPointerException();
              }
              ensureControlPointsIsMutable();
              controlPoints_.add(value);
              onChanged();
            } else {
              controlPointsBuilder_.addMessage(value);
            }
            return this;
          }
          /**
           *
           *
           * <pre>
           * The control points used to define the curve. The monotonic function
           * (defined through the interpolation_type above) passes through the
           * control points listed here.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec.BoostControlSpec.ControlPoint control_points = 4;
           * </code>
           */
          public Builder addControlPoints(
              int index,
              com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
                      .BoostControlSpec.ControlPoint
                  value) {
            if (controlPointsBuilder_ == null) {
              if (value == null) {
                throw new NullPointerException();
              }
              ensureControlPointsIsMutable();
              controlPoints_.add(index, value);
              onChanged();
            } else {
              controlPointsBuilder_.addMessage(index, value);
            }
            return this;
          }
          /**
           *
           *
           * <pre>
           * The control points used to define the curve. The monotonic function
           * (defined through the interpolation_type above) passes through the
           * control points listed here.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec.BoostControlSpec.ControlPoint control_points = 4;
           * </code>
           */
          public Builder addControlPoints(
              com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
                      .BoostControlSpec.ControlPoint.Builder
                  builderForValue) {
            if (controlPointsBuilder_ == null) {
              ensureControlPointsIsMutable();
              controlPoints_.add(builderForValue.build());
              onChanged();
            } else {
              controlPointsBuilder_.addMessage(builderForValue.build());
            }
            return this;
          }
          /**
           *
           *
           * <pre>
           * The control points used to define the curve. The monotonic function
           * (defined through the interpolation_type above) passes through the
           * control points listed here.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec.BoostControlSpec.ControlPoint control_points = 4;
           * </code>
           */
          public Builder addControlPoints(
              int index,
              com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
                      .BoostControlSpec.ControlPoint.Builder
                  builderForValue) {
            if (controlPointsBuilder_ == null) {
              ensureControlPointsIsMutable();
              controlPoints_.add(index, builderForValue.build());
              onChanged();
            } else {
              controlPointsBuilder_.addMessage(index, builderForValue.build());
            }
            return this;
          }
          /**
           *
           *
           * <pre>
           * The control points used to define the curve. The monotonic function
           * (defined through the interpolation_type above) passes through the
           * control points listed here.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec.BoostControlSpec.ControlPoint control_points = 4;
           * </code>
           */
          public Builder addAllControlPoints(
              java.lang.Iterable<
                      ? extends
                          com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec
                              .ConditionBoostSpec.BoostControlSpec.ControlPoint>
                  values) {
            if (controlPointsBuilder_ == null) {
              ensureControlPointsIsMutable();
              com.google.protobuf.AbstractMessageLite.Builder.addAll(values, controlPoints_);
              onChanged();
            } else {
              controlPointsBuilder_.addAllMessages(values);
            }
            return this;
          }
          /**
           *
           *
           * <pre>
           * The control points used to define the curve. The monotonic function
           * (defined through the interpolation_type above) passes through the
           * control points listed here.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec.BoostControlSpec.ControlPoint control_points = 4;
           * </code>
           */
          public Builder clearControlPoints() {
            if (controlPointsBuilder_ == null) {
              controlPoints_ = java.util.Collections.emptyList();
              bitField0_ = (bitField0_ & ~0x00000008);
              onChanged();
            } else {
              controlPointsBuilder_.clear();
            }
            return this;
          }
          /**
           *
           *
           * <pre>
           * The control points used to define the curve. The monotonic function
           * (defined through the interpolation_type above) passes through the
           * control points listed here.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec.BoostControlSpec.ControlPoint control_points = 4;
           * </code>
           */
          public Builder removeControlPoints(int index) {
            if (controlPointsBuilder_ == null) {
              ensureControlPointsIsMutable();
              controlPoints_.remove(index);
              onChanged();
            } else {
              controlPointsBuilder_.remove(index);
            }
            return this;
          }
          /**
           *
           *
           * <pre>
           * The control points used to define the curve. The monotonic function
           * (defined through the interpolation_type above) passes through the
           * control points listed here.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec.BoostControlSpec.ControlPoint control_points = 4;
           * </code>
           */
          public com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
                  .BoostControlSpec.ControlPoint.Builder
              getControlPointsBuilder(int index) {
            return getControlPointsFieldBuilder().getBuilder(index);
          }
          /**
           *
           *
           * <pre>
           * The control points used to define the curve. The monotonic function
           * (defined through the interpolation_type above) passes through the
           * control points listed here.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec.BoostControlSpec.ControlPoint control_points = 4;
           * </code>
           */
          public com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
                  .BoostControlSpec.ControlPointOrBuilder
              getControlPointsOrBuilder(int index) {
            if (controlPointsBuilder_ == null) {
              return controlPoints_.get(index);
            } else {
              return controlPointsBuilder_.getMessageOrBuilder(index);
            }
          }
          /**
           *
           *
           * <pre>
           * The control points used to define the curve. The monotonic function
           * (defined through the interpolation_type above) passes through the
           * control points listed here.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec.BoostControlSpec.ControlPoint control_points = 4;
           * </code>
           */
          public java.util.List<
                  ? extends
                      com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec
                          .ConditionBoostSpec.BoostControlSpec.ControlPointOrBuilder>
              getControlPointsOrBuilderList() {
            if (controlPointsBuilder_ != null) {
              return controlPointsBuilder_.getMessageOrBuilderList();
            } else {
              return java.util.Collections.unmodifiableList(controlPoints_);
            }
          }
          /**
           *
           *
           * <pre>
           * The control points used to define the curve. The monotonic function
           * (defined through the interpolation_type above) passes through the
           * control points listed here.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec.BoostControlSpec.ControlPoint control_points = 4;
           * </code>
           */
          public com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
                  .BoostControlSpec.ControlPoint.Builder
              addControlPointsBuilder() {
            return getControlPointsFieldBuilder()
                .addBuilder(
                    com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec
                        .ConditionBoostSpec.BoostControlSpec.ControlPoint.getDefaultInstance());
          }
          /**
           *
           *
           * <pre>
           * The control points used to define the curve. The monotonic function
           * (defined through the interpolation_type above) passes through the
           * control points listed here.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec.BoostControlSpec.ControlPoint control_points = 4;
           * </code>
           */
          public com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
                  .BoostControlSpec.ControlPoint.Builder
              addControlPointsBuilder(int index) {
            return getControlPointsFieldBuilder()
                .addBuilder(
                    index,
                    com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec
                        .ConditionBoostSpec.BoostControlSpec.ControlPoint.getDefaultInstance());
          }
          /**
           *
           *
           * <pre>
           * The control points used to define the curve. The monotonic function
           * (defined through the interpolation_type above) passes through the
           * control points listed here.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec.BoostControlSpec.ControlPoint control_points = 4;
           * </code>
           */
          public java.util.List<
                  com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
                      .BoostControlSpec.ControlPoint.Builder>
              getControlPointsBuilderList() {
            return getControlPointsFieldBuilder().getBuilderList();
          }

          private com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
                      .BoostControlSpec.ControlPoint,
                  com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
                      .BoostControlSpec.ControlPoint.Builder,
                  com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
                      .BoostControlSpec.ControlPointOrBuilder>
              getControlPointsFieldBuilder() {
            if (controlPointsBuilder_ == null) {
              controlPointsBuilder_ =
                  new com.google.protobuf.RepeatedFieldBuilderV3<
                      com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec
                          .ConditionBoostSpec.BoostControlSpec.ControlPoint,
                      com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec
                          .ConditionBoostSpec.BoostControlSpec.ControlPoint.Builder,
                      com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec
                          .ConditionBoostSpec.BoostControlSpec.ControlPointOrBuilder>(
                      controlPoints_,
                      ((bitField0_ & 0x00000008) != 0),
                      getParentForChildren(),
                      isClean());
              controlPoints_ = null;
            }
            return controlPointsBuilder_;
          }

          @java.lang.Override
          public final Builder setUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.setUnknownFields(unknownFields);
          }

          @java.lang.Override
          public final Builder mergeUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.mergeUnknownFields(unknownFields);
          }

          // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec.BoostControlSpec)
        }

        // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec.BoostControlSpec)
        private static final com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec
                .ConditionBoostSpec.BoostControlSpec
            DEFAULT_INSTANCE;

        static {
          DEFAULT_INSTANCE =
              new com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
                  .BoostControlSpec();
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec
                .ConditionBoostSpec.BoostControlSpec
            getDefaultInstance() {
          return DEFAULT_INSTANCE;
        }

        private static final com.google.protobuf.Parser<BoostControlSpec> PARSER =
            new com.google.protobuf.AbstractParser<BoostControlSpec>() {
              @java.lang.Override
              public BoostControlSpec parsePartialFrom(
                  com.google.protobuf.CodedInputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
                Builder builder = newBuilder();
                try {
                  builder.mergeFrom(input, extensionRegistry);
                } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                  throw e.setUnfinishedMessage(builder.buildPartial());
                } catch (com.google.protobuf.UninitializedMessageException e) {
                  throw e.asInvalidProtocolBufferException()
                      .setUnfinishedMessage(builder.buildPartial());
                } catch (java.io.IOException e) {
                  throw new com.google.protobuf.InvalidProtocolBufferException(e)
                      .setUnfinishedMessage(builder.buildPartial());
                }
                return builder.buildPartial();
              }
            };

        public static com.google.protobuf.Parser<BoostControlSpec> parser() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.protobuf.Parser<BoostControlSpec> getParserForType() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
                .BoostControlSpec
            getDefaultInstanceForType() {
          return DEFAULT_INSTANCE;
        }
      }

      private int bitField0_;
      public static final int CONDITION_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private volatile java.lang.Object condition_ = "";
      /**
       *
       *
       * <pre>
       * An expression which specifies a boost condition. The syntax and
       * supported fields are the same as a filter expression. See
       * [SearchRequest.filter][google.cloud.discoveryengine.v1beta.SearchRequest.filter]
       * for detail syntax and limitations.
       *
       * Examples:
       *
       * * To boost documents with document ID "doc_1" or "doc_2", and
       * color "Red" or "Blue":
       * `(document_id: ANY("doc_1", "doc_2")) AND (color: ANY("Red", "Blue"))`
       * </pre>
       *
       * <code>string condition = 1;</code>
       *
       * @return The condition.
       */
      @java.lang.Override
      public java.lang.String getCondition() {
        java.lang.Object ref = condition_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          condition_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * An expression which specifies a boost condition. The syntax and
       * supported fields are the same as a filter expression. See
       * [SearchRequest.filter][google.cloud.discoveryengine.v1beta.SearchRequest.filter]
       * for detail syntax and limitations.
       *
       * Examples:
       *
       * * To boost documents with document ID "doc_1" or "doc_2", and
       * color "Red" or "Blue":
       * `(document_id: ANY("doc_1", "doc_2")) AND (color: ANY("Red", "Blue"))`
       * </pre>
       *
       * <code>string condition = 1;</code>
       *
       * @return The bytes for condition.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getConditionBytes() {
        java.lang.Object ref = condition_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          condition_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int BOOST_FIELD_NUMBER = 2;
      private float boost_ = 0F;
      /**
       *
       *
       * <pre>
       * Strength of the condition boost, which should be in [-1, 1]. Negative
       * boost means demotion. Default is 0.0.
       *
       * Setting to 1.0 gives the document a big promotion. However, it does
       * not necessarily mean that the boosted document will be the top result
       * at all times, nor that other documents will be excluded. Results
       * could still be shown even when none of them matches the condition.
       * And results that are significantly more relevant to the search query
       * can still trump your heavily favored but irrelevant documents.
       *
       * Setting to -1.0 gives the document a big demotion. However, results
       * that are deeply relevant might still be shown. The document will have
       * an upstream battle to get a fairly high ranking, but it is not
       * blocked out completely.
       *
       * Setting to 0.0 means no boost applied. The boosting condition is
       * ignored. Only one of the (condition, boost) combination or the
       * boost_control_spec below are set. If both are set then the global boost
       * is ignored and the more fine-grained boost_control_spec is applied.
       * </pre>
       *
       * <code>float boost = 2;</code>
       *
       * @return The boost.
       */
      @java.lang.Override
      public float getBoost() {
        return boost_;
      }

      public static final int BOOST_CONTROL_SPEC_FIELD_NUMBER = 3;
      private com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
              .BoostControlSpec
          boostControlSpec_;
      /**
       *
       *
       * <pre>
       * Complex specification for custom ranking based on customer defined
       * attribute value.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec.BoostControlSpec boost_control_spec = 3;
       * </code>
       *
       * @return Whether the boostControlSpec field is set.
       */
      @java.lang.Override
      public boolean hasBoostControlSpec() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * Complex specification for custom ranking based on customer defined
       * attribute value.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec.BoostControlSpec boost_control_spec = 3;
       * </code>
       *
       * @return The boostControlSpec.
       */
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
              .BoostControlSpec
          getBoostControlSpec() {
        return boostControlSpec_ == null
            ? com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
                .BoostControlSpec.getDefaultInstance()
            : boostControlSpec_;
      }
      /**
       *
       *
       * <pre>
       * Complex specification for custom ranking based on customer defined
       * attribute value.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec.BoostControlSpec boost_control_spec = 3;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
              .BoostControlSpecOrBuilder
          getBoostControlSpecOrBuilder() {
        return boostControlSpec_ == null
            ? com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
                .BoostControlSpec.getDefaultInstance()
            : boostControlSpec_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(condition_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, condition_);
        }
        if (java.lang.Float.floatToRawIntBits(boost_) != 0) {
          output.writeFloat(2, boost_);
        }
        if (((bitField0_ & 0x00000001) != 0)) {
          output.writeMessage(3, getBoostControlSpec());
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(condition_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, condition_);
        }
        if (java.lang.Float.floatToRawIntBits(boost_) != 0) {
          size += com.google.protobuf.CodedOutputStream.computeFloatSize(2, boost_);
        }
        if (((bitField0_ & 0x00000001) != 0)) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(3, getBoostControlSpec());
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec)) {
          return super.equals(obj);
        }
        com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec other =
            (com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec)
                obj;

        if (!getCondition().equals(other.getCondition())) return false;
        if (java.lang.Float.floatToIntBits(getBoost())
            != java.lang.Float.floatToIntBits(other.getBoost())) return false;
        if (hasBoostControlSpec() != other.hasBoostControlSpec()) return false;
        if (hasBoostControlSpec()) {
          if (!getBoostControlSpec().equals(other.getBoostControlSpec())) return false;
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + CONDITION_FIELD_NUMBER;
        hash = (53 * hash) + getCondition().hashCode();
        hash = (37 * hash) + BOOST_FIELD_NUMBER;
        hash = (53 * hash) + java.lang.Float.floatToIntBits(getBoost());
        if (hasBoostControlSpec()) {
          hash = (37 * hash) + BOOST_CONTROL_SPEC_FIELD_NUMBER;
          hash = (53 * hash) + getBoostControlSpec().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec
              .ConditionBoostSpec
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec
              .ConditionBoostSpec
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec
              .ConditionBoostSpec
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec
              .ConditionBoostSpec
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec
              .ConditionBoostSpec
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec
              .ConditionBoostSpec
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec
              .ConditionBoostSpec
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec
              .ConditionBoostSpec
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec
              .ConditionBoostSpec
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec
              .ConditionBoostSpec
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec
              .ConditionBoostSpec
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec
              .ConditionBoostSpec
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Boost applies to documents which match a condition.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec)
          com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec
              .ConditionBoostSpecOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
              .internal_static_google_cloud_discoveryengine_v1beta_SearchRequest_BoostSpec_ConditionBoostSpec_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
              .internal_static_google_cloud_discoveryengine_v1beta_SearchRequest_BoostSpec_ConditionBoostSpec_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
                      .class,
                  com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
                      .Builder.class);
        }

        // Construct using
        // com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
            getBoostControlSpecFieldBuilder();
          }
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          condition_ = "";
          boost_ = 0F;
          boostControlSpec_ = null;
          if (boostControlSpecBuilder_ != null) {
            boostControlSpecBuilder_.dispose();
            boostControlSpecBuilder_ = null;
          }
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
              .internal_static_google_cloud_discoveryengine_v1beta_SearchRequest_BoostSpec_ConditionBoostSpec_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
            getDefaultInstanceForType() {
          return com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
            build() {
          com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
              result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
            buildPartial() {
          com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
              result =
                  new com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec
                      .ConditionBoostSpec(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
                result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.condition_ = condition_;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.boost_ = boost_;
          }
          int to_bitField0_ = 0;
          if (((from_bitField0_ & 0x00000004) != 0)) {
            result.boostControlSpec_ =
                boostControlSpecBuilder_ == null
                    ? boostControlSpec_
                    : boostControlSpecBuilder_.build();
            to_bitField0_ |= 0x00000001;
          }
          result.bitField0_ |= to_bitField0_;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec) {
            return mergeFrom(
                (com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
                other) {
          if (other
              == com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
                  .getDefaultInstance()) return this;
          if (!other.getCondition().isEmpty()) {
            condition_ = other.condition_;
            bitField0_ |= 0x00000001;
            onChanged();
          }
          if (other.getBoost() != 0F) {
            setBoost(other.getBoost());
          }
          if (other.hasBoostControlSpec()) {
            mergeBoostControlSpec(other.getBoostControlSpec());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    condition_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                case 21:
                  {
                    boost_ = input.readFloat();
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 21
                case 26:
                  {
                    input.readMessage(
                        getBoostControlSpecFieldBuilder().getBuilder(), extensionRegistry);
                    bitField0_ |= 0x00000004;
                    break;
                  } // case 26
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.lang.Object condition_ = "";
        /**
         *
         *
         * <pre>
         * An expression which specifies a boost condition. The syntax and
         * supported fields are the same as a filter expression. See
         * [SearchRequest.filter][google.cloud.discoveryengine.v1beta.SearchRequest.filter]
         * for detail syntax and limitations.
         *
         * Examples:
         *
         * * To boost documents with document ID "doc_1" or "doc_2", and
         * color "Red" or "Blue":
         * `(document_id: ANY("doc_1", "doc_2")) AND (color: ANY("Red", "Blue"))`
         * </pre>
         *
         * <code>string condition = 1;</code>
         *
         * @return The condition.
         */
        public java.lang.String getCondition() {
          java.lang.Object ref = condition_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            condition_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * An expression which specifies a boost condition. The syntax and
         * supported fields are the same as a filter expression. See
         * [SearchRequest.filter][google.cloud.discoveryengine.v1beta.SearchRequest.filter]
         * for detail syntax and limitations.
         *
         * Examples:
         *
         * * To boost documents with document ID "doc_1" or "doc_2", and
         * color "Red" or "Blue":
         * `(document_id: ANY("doc_1", "doc_2")) AND (color: ANY("Red", "Blue"))`
         * </pre>
         *
         * <code>string condition = 1;</code>
         *
         * @return The bytes for condition.
         */
        public com.google.protobuf.ByteString getConditionBytes() {
          java.lang.Object ref = condition_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            condition_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * An expression which specifies a boost condition. The syntax and
         * supported fields are the same as a filter expression. See
         * [SearchRequest.filter][google.cloud.discoveryengine.v1beta.SearchRequest.filter]
         * for detail syntax and limitations.
         *
         * Examples:
         *
         * * To boost documents with document ID "doc_1" or "doc_2", and
         * color "Red" or "Blue":
         * `(document_id: ANY("doc_1", "doc_2")) AND (color: ANY("Red", "Blue"))`
         * </pre>
         *
         * <code>string condition = 1;</code>
         *
         * @param value The condition to set.
         * @return This builder for chaining.
         */
        public Builder setCondition(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          condition_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * An expression which specifies a boost condition. The syntax and
         * supported fields are the same as a filter expression. See
         * [SearchRequest.filter][google.cloud.discoveryengine.v1beta.SearchRequest.filter]
         * for detail syntax and limitations.
         *
         * Examples:
         *
         * * To boost documents with document ID "doc_1" or "doc_2", and
         * color "Red" or "Blue":
         * `(document_id: ANY("doc_1", "doc_2")) AND (color: ANY("Red", "Blue"))`
         * </pre>
         *
         * <code>string condition = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearCondition() {
          condition_ = getDefaultInstance().getCondition();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * An expression which specifies a boost condition. The syntax and
         * supported fields are the same as a filter expression. See
         * [SearchRequest.filter][google.cloud.discoveryengine.v1beta.SearchRequest.filter]
         * for detail syntax and limitations.
         *
         * Examples:
         *
         * * To boost documents with document ID "doc_1" or "doc_2", and
         * color "Red" or "Blue":
         * `(document_id: ANY("doc_1", "doc_2")) AND (color: ANY("Red", "Blue"))`
         * </pre>
         *
         * <code>string condition = 1;</code>
         *
         * @param value The bytes for condition to set.
         * @return This builder for chaining.
         */
        public Builder setConditionBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          condition_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        private float boost_;
        /**
         *
         *
         * <pre>
         * Strength of the condition boost, which should be in [-1, 1]. Negative
         * boost means demotion. Default is 0.0.
         *
         * Setting to 1.0 gives the document a big promotion. However, it does
         * not necessarily mean that the boosted document will be the top result
         * at all times, nor that other documents will be excluded. Results
         * could still be shown even when none of them matches the condition.
         * And results that are significantly more relevant to the search query
         * can still trump your heavily favored but irrelevant documents.
         *
         * Setting to -1.0 gives the document a big demotion. However, results
         * that are deeply relevant might still be shown. The document will have
         * an upstream battle to get a fairly high ranking, but it is not
         * blocked out completely.
         *
         * Setting to 0.0 means no boost applied. The boosting condition is
         * ignored. Only one of the (condition, boost) combination or the
         * boost_control_spec below are set. If both are set then the global boost
         * is ignored and the more fine-grained boost_control_spec is applied.
         * </pre>
         *
         * <code>float boost = 2;</code>
         *
         * @return The boost.
         */
        @java.lang.Override
        public float getBoost() {
          return boost_;
        }
        /**
         *
         *
         * <pre>
         * Strength of the condition boost, which should be in [-1, 1]. Negative
         * boost means demotion. Default is 0.0.
         *
         * Setting to 1.0 gives the document a big promotion. However, it does
         * not necessarily mean that the boosted document will be the top result
         * at all times, nor that other documents will be excluded. Results
         * could still be shown even when none of them matches the condition.
         * And results that are significantly more relevant to the search query
         * can still trump your heavily favored but irrelevant documents.
         *
         * Setting to -1.0 gives the document a big demotion. However, results
         * that are deeply relevant might still be shown. The document will have
         * an upstream battle to get a fairly high ranking, but it is not
         * blocked out completely.
         *
         * Setting to 0.0 means no boost applied. The boosting condition is
         * ignored. Only one of the (condition, boost) combination or the
         * boost_control_spec below are set. If both are set then the global boost
         * is ignored and the more fine-grained boost_control_spec is applied.
         * </pre>
         *
         * <code>float boost = 2;</code>
         *
         * @param value The boost to set.
         * @return This builder for chaining.
         */
        public Builder setBoost(float value) {

          boost_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Strength of the condition boost, which should be in [-1, 1]. Negative
         * boost means demotion. Default is 0.0.
         *
         * Setting to 1.0 gives the document a big promotion. However, it does
         * not necessarily mean that the boosted document will be the top result
         * at all times, nor that other documents will be excluded. Results
         * could still be shown even when none of them matches the condition.
         * And results that are significantly more relevant to the search query
         * can still trump your heavily favored but irrelevant documents.
         *
         * Setting to -1.0 gives the document a big demotion. However, results
         * that are deeply relevant might still be shown. The document will have
         * an upstream battle to get a fairly high ranking, but it is not
         * blocked out completely.
         *
         * Setting to 0.0 means no boost applied. The boosting condition is
         * ignored. Only one of the (condition, boost) combination or the
         * boost_control_spec below are set. If both are set then the global boost
         * is ignored and the more fine-grained boost_control_spec is applied.
         * </pre>
         *
         * <code>float boost = 2;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearBoost() {
          bitField0_ = (bitField0_ & ~0x00000002);
          boost_ = 0F;
          onChanged();
          return this;
        }

        private com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
                .BoostControlSpec
            boostControlSpec_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
                    .BoostControlSpec,
                com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
                    .BoostControlSpec.Builder,
                com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
                    .BoostControlSpecOrBuilder>
            boostControlSpecBuilder_;
        /**
         *
         *
         * <pre>
         * Complex specification for custom ranking based on customer defined
         * attribute value.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec.BoostControlSpec boost_control_spec = 3;
         * </code>
         *
         * @return Whether the boostControlSpec field is set.
         */
        public boolean hasBoostControlSpec() {
          return ((bitField0_ & 0x00000004) != 0);
        }
        /**
         *
         *
         * <pre>
         * Complex specification for custom ranking based on customer defined
         * attribute value.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec.BoostControlSpec boost_control_spec = 3;
         * </code>
         *
         * @return The boostControlSpec.
         */
        public com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
                .BoostControlSpec
            getBoostControlSpec() {
          if (boostControlSpecBuilder_ == null) {
            return boostControlSpec_ == null
                ? com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
                    .BoostControlSpec.getDefaultInstance()
                : boostControlSpec_;
          } else {
            return boostControlSpecBuilder_.getMessage();
          }
        }
        /**
         *
         *
         * <pre>
         * Complex specification for custom ranking based on customer defined
         * attribute value.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec.BoostControlSpec boost_control_spec = 3;
         * </code>
         */
        public Builder setBoostControlSpec(
            com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
                    .BoostControlSpec
                value) {
          if (boostControlSpecBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            boostControlSpec_ = value;
          } else {
            boostControlSpecBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Complex specification for custom ranking based on customer defined
         * attribute value.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec.BoostControlSpec boost_control_spec = 3;
         * </code>
         */
        public Builder setBoostControlSpec(
            com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
                    .BoostControlSpec.Builder
                builderForValue) {
          if (boostControlSpecBuilder_ == null) {
            boostControlSpec_ = builderForValue.build();
          } else {
            boostControlSpecBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Complex specification for custom ranking based on customer defined
         * attribute value.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec.BoostControlSpec boost_control_spec = 3;
         * </code>
         */
        public Builder mergeBoostControlSpec(
            com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
                    .BoostControlSpec
                value) {
          if (boostControlSpecBuilder_ == null) {
            if (((bitField0_ & 0x00000004) != 0)
                && boostControlSpec_ != null
                && boostControlSpec_
                    != com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec
                        .ConditionBoostSpec.BoostControlSpec.getDefaultInstance()) {
              getBoostControlSpecBuilder().mergeFrom(value);
            } else {
              boostControlSpec_ = value;
            }
          } else {
            boostControlSpecBuilder_.mergeFrom(value);
          }
          if (boostControlSpec_ != null) {
            bitField0_ |= 0x00000004;
            onChanged();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Complex specification for custom ranking based on customer defined
         * attribute value.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec.BoostControlSpec boost_control_spec = 3;
         * </code>
         */
        public Builder clearBoostControlSpec() {
          bitField0_ = (bitField0_ & ~0x00000004);
          boostControlSpec_ = null;
          if (boostControlSpecBuilder_ != null) {
            boostControlSpecBuilder_.dispose();
            boostControlSpecBuilder_ = null;
          }
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Complex specification for custom ranking based on customer defined
         * attribute value.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec.BoostControlSpec boost_control_spec = 3;
         * </code>
         */
        public com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
                .BoostControlSpec.Builder
            getBoostControlSpecBuilder() {
          bitField0_ |= 0x00000004;
          onChanged();
          return getBoostControlSpecFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * Complex specification for custom ranking based on customer defined
         * attribute value.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec.BoostControlSpec boost_control_spec = 3;
         * </code>
         */
        public com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
                .BoostControlSpecOrBuilder
            getBoostControlSpecOrBuilder() {
          if (boostControlSpecBuilder_ != null) {
            return boostControlSpecBuilder_.getMessageOrBuilder();
          } else {
            return boostControlSpec_ == null
                ? com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
                    .BoostControlSpec.getDefaultInstance()
                : boostControlSpec_;
          }
        }
        /**
         *
         *
         * <pre>
         * Complex specification for custom ranking based on customer defined
         * attribute value.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec.BoostControlSpec boost_control_spec = 3;
         * </code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
                    .BoostControlSpec,
                com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
                    .BoostControlSpec.Builder,
                com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
                    .BoostControlSpecOrBuilder>
            getBoostControlSpecFieldBuilder() {
          if (boostControlSpecBuilder_ == null) {
            boostControlSpecBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec
                        .ConditionBoostSpec.BoostControlSpec,
                    com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec
                        .ConditionBoostSpec.BoostControlSpec.Builder,
                    com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec
                        .ConditionBoostSpec.BoostControlSpecOrBuilder>(
                    getBoostControlSpec(), getParentForChildren(), isClean());
            boostControlSpec_ = null;
          }
          return boostControlSpecBuilder_;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec)
      private static final com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec
              .ConditionBoostSpec
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec
                .ConditionBoostSpec();
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec
              .ConditionBoostSpec
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<ConditionBoostSpec> PARSER =
          new com.google.protobuf.AbstractParser<ConditionBoostSpec>() {
            @java.lang.Override
            public ConditionBoostSpec parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<ConditionBoostSpec> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<ConditionBoostSpec> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public static final int CONDITION_BOOST_SPECS_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private java.util.List<
            com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec>
        conditionBoostSpecs_;
    /**
     *
     *
     * <pre>
     * Condition boost specifications. If a document matches multiple conditions
     * in the specifictions, boost scores from these specifications are all
     * applied and combined in a non-linear way. Maximum number of
     * specifications is 20.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec condition_boost_specs = 1;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec>
        getConditionBoostSpecsList() {
      return conditionBoostSpecs_;
    }
    /**
     *
     *
     * <pre>
     * Condition boost specifications. If a document matches multiple conditions
     * in the specifictions, boost scores from these specifications are all
     * applied and combined in a non-linear way. Maximum number of
     * specifications is 20.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec condition_boost_specs = 1;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends
                com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec
                    .ConditionBoostSpecOrBuilder>
        getConditionBoostSpecsOrBuilderList() {
      return conditionBoostSpecs_;
    }
    /**
     *
     *
     * <pre>
     * Condition boost specifications. If a document matches multiple conditions
     * in the specifictions, boost scores from these specifications are all
     * applied and combined in a non-linear way. Maximum number of
     * specifications is 20.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec condition_boost_specs = 1;
     * </code>
     */
    @java.lang.Override
    public int getConditionBoostSpecsCount() {
      return conditionBoostSpecs_.size();
    }
    /**
     *
     *
     * <pre>
     * Condition boost specifications. If a document matches multiple conditions
     * in the specifictions, boost scores from these specifications are all
     * applied and combined in a non-linear way. Maximum number of
     * specifications is 20.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec condition_boost_specs = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
        getConditionBoostSpecs(int index) {
      return conditionBoostSpecs_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Condition boost specifications. If a document matches multiple conditions
     * in the specifictions, boost scores from these specifications are all
     * applied and combined in a non-linear way. Maximum number of
     * specifications is 20.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec condition_boost_specs = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec
            .ConditionBoostSpecOrBuilder
        getConditionBoostSpecsOrBuilder(int index) {
      return conditionBoostSpecs_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < conditionBoostSpecs_.size(); i++) {
        output.writeMessage(1, conditionBoostSpecs_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < conditionBoostSpecs_.size(); i++) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                1, conditionBoostSpecs_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec)) {
        return super.equals(obj);
      }
      com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec other =
          (com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec) obj;

      if (!getConditionBoostSpecsList().equals(other.getConditionBoostSpecsList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getConditionBoostSpecsCount() > 0) {
        hash = (37 * hash) + CONDITION_BOOST_SPECS_FIELD_NUMBER;
        hash = (53 * hash) + getConditionBoostSpecsList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Boost specification to boost certain documents.
     * </pre>
     *
     * Protobuf type {@code google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec)
        com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpecOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_SearchRequest_BoostSpec_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_SearchRequest_BoostSpec_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.class,
                com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.Builder.class);
      }

      // Construct using
      // com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (conditionBoostSpecsBuilder_ == null) {
          conditionBoostSpecs_ = java.util.Collections.emptyList();
        } else {
          conditionBoostSpecs_ = null;
          conditionBoostSpecsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_SearchRequest_BoostSpec_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec
          getDefaultInstanceForType() {
        return com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec build() {
        com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec buildPartial() {
        com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec result =
            new com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec result) {
        if (conditionBoostSpecsBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            conditionBoostSpecs_ = java.util.Collections.unmodifiableList(conditionBoostSpecs_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.conditionBoostSpecs_ = conditionBoostSpecs_;
        } else {
          result.conditionBoostSpecs_ = conditionBoostSpecsBuilder_.build();
        }
      }

      private void buildPartial0(
          com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec result) {
        int from_bitField0_ = bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec) {
          return mergeFrom((com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec other) {
        if (other
            == com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.getDefaultInstance())
          return this;
        if (conditionBoostSpecsBuilder_ == null) {
          if (!other.conditionBoostSpecs_.isEmpty()) {
            if (conditionBoostSpecs_.isEmpty()) {
              conditionBoostSpecs_ = other.conditionBoostSpecs_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureConditionBoostSpecsIsMutable();
              conditionBoostSpecs_.addAll(other.conditionBoostSpecs_);
            }
            onChanged();
          }
        } else {
          if (!other.conditionBoostSpecs_.isEmpty()) {
            if (conditionBoostSpecsBuilder_.isEmpty()) {
              conditionBoostSpecsBuilder_.dispose();
              conditionBoostSpecsBuilder_ = null;
              conditionBoostSpecs_ = other.conditionBoostSpecs_;
              bitField0_ = (bitField0_ & ~0x00000001);
              conditionBoostSpecsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getConditionBoostSpecsFieldBuilder()
                      : null;
            } else {
              conditionBoostSpecsBuilder_.addAllMessages(other.conditionBoostSpecs_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
                      m =
                          input.readMessage(
                              com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec
                                  .ConditionBoostSpec.parser(),
                              extensionRegistry);
                  if (conditionBoostSpecsBuilder_ == null) {
                    ensureConditionBoostSpecsIsMutable();
                    conditionBoostSpecs_.add(m);
                  } else {
                    conditionBoostSpecsBuilder_.addMessage(m);
                  }
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.util.List<
              com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec>
          conditionBoostSpecs_ = java.util.Collections.emptyList();

      private void ensureConditionBoostSpecsIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          conditionBoostSpecs_ =
              new java.util.ArrayList<
                  com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec
                      .ConditionBoostSpec>(conditionBoostSpecs_);
          bitField0_ |= 0x00000001;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec,
              com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
                  .Builder,
              com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec
                  .ConditionBoostSpecOrBuilder>
          conditionBoostSpecsBuilder_;

      /**
       *
       *
       * <pre>
       * Condition boost specifications. If a document matches multiple conditions
       * in the specifictions, boost scores from these specifications are all
       * applied and combined in a non-linear way. Maximum number of
       * specifications is 20.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec condition_boost_specs = 1;
       * </code>
       */
      public java.util.List<
              com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec>
          getConditionBoostSpecsList() {
        if (conditionBoostSpecsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(conditionBoostSpecs_);
        } else {
          return conditionBoostSpecsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * Condition boost specifications. If a document matches multiple conditions
       * in the specifictions, boost scores from these specifications are all
       * applied and combined in a non-linear way. Maximum number of
       * specifications is 20.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec condition_boost_specs = 1;
       * </code>
       */
      public int getConditionBoostSpecsCount() {
        if (conditionBoostSpecsBuilder_ == null) {
          return conditionBoostSpecs_.size();
        } else {
          return conditionBoostSpecsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * Condition boost specifications. If a document matches multiple conditions
       * in the specifictions, boost scores from these specifications are all
       * applied and combined in a non-linear way. Maximum number of
       * specifications is 20.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec condition_boost_specs = 1;
       * </code>
       */
      public com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
          getConditionBoostSpecs(int index) {
        if (conditionBoostSpecsBuilder_ == null) {
          return conditionBoostSpecs_.get(index);
        } else {
          return conditionBoostSpecsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Condition boost specifications. If a document matches multiple conditions
       * in the specifictions, boost scores from these specifications are all
       * applied and combined in a non-linear way. Maximum number of
       * specifications is 20.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec condition_boost_specs = 1;
       * </code>
       */
      public Builder setConditionBoostSpecs(
          int index,
          com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
              value) {
        if (conditionBoostSpecsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureConditionBoostSpecsIsMutable();
          conditionBoostSpecs_.set(index, value);
          onChanged();
        } else {
          conditionBoostSpecsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Condition boost specifications. If a document matches multiple conditions
       * in the specifictions, boost scores from these specifications are all
       * applied and combined in a non-linear way. Maximum number of
       * specifications is 20.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec condition_boost_specs = 1;
       * </code>
       */
      public Builder setConditionBoostSpecs(
          int index,
          com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec.Builder
              builderForValue) {
        if (conditionBoostSpecsBuilder_ == null) {
          ensureConditionBoostSpecsIsMutable();
          conditionBoostSpecs_.set(index, builderForValue.build());
          onChanged();
        } else {
          conditionBoostSpecsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Condition boost specifications. If a document matches multiple conditions
       * in the specifictions, boost scores from these specifications are all
       * applied and combined in a non-linear way. Maximum number of
       * specifications is 20.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec condition_boost_specs = 1;
       * </code>
       */
      public Builder addConditionBoostSpecs(
          com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
              value) {
        if (conditionBoostSpecsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureConditionBoostSpecsIsMutable();
          conditionBoostSpecs_.add(value);
          onChanged();
        } else {
          conditionBoostSpecsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Condition boost specifications. If a document matches multiple conditions
       * in the specifictions, boost scores from these specifications are all
       * applied and combined in a non-linear way. Maximum number of
       * specifications is 20.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec condition_boost_specs = 1;
       * </code>
       */
      public Builder addConditionBoostSpecs(
          int index,
          com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
              value) {
        if (conditionBoostSpecsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureConditionBoostSpecsIsMutable();
          conditionBoostSpecs_.add(index, value);
          onChanged();
        } else {
          conditionBoostSpecsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Condition boost specifications. If a document matches multiple conditions
       * in the specifictions, boost scores from these specifications are all
       * applied and combined in a non-linear way. Maximum number of
       * specifications is 20.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec condition_boost_specs = 1;
       * </code>
       */
      public Builder addConditionBoostSpecs(
          com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec.Builder
              builderForValue) {
        if (conditionBoostSpecsBuilder_ == null) {
          ensureConditionBoostSpecsIsMutable();
          conditionBoostSpecs_.add(builderForValue.build());
          onChanged();
        } else {
          conditionBoostSpecsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Condition boost specifications. If a document matches multiple conditions
       * in the specifictions, boost scores from these specifications are all
       * applied and combined in a non-linear way. Maximum number of
       * specifications is 20.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec condition_boost_specs = 1;
       * </code>
       */
      public Builder addConditionBoostSpecs(
          int index,
          com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec.Builder
              builderForValue) {
        if (conditionBoostSpecsBuilder_ == null) {
          ensureConditionBoostSpecsIsMutable();
          conditionBoostSpecs_.add(index, builderForValue.build());
          onChanged();
        } else {
          conditionBoostSpecsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Condition boost specifications. If a document matches multiple conditions
       * in the specifictions, boost scores from these specifications are all
       * applied and combined in a non-linear way. Maximum number of
       * specifications is 20.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec condition_boost_specs = 1;
       * </code>
       */
      public Builder addAllConditionBoostSpecs(
          java.lang.Iterable<
                  ? extends
                      com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec
                          .ConditionBoostSpec>
              values) {
        if (conditionBoostSpecsBuilder_ == null) {
          ensureConditionBoostSpecsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, conditionBoostSpecs_);
          onChanged();
        } else {
          conditionBoostSpecsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Condition boost specifications. If a document matches multiple conditions
       * in the specifictions, boost scores from these specifications are all
       * applied and combined in a non-linear way. Maximum number of
       * specifications is 20.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec condition_boost_specs = 1;
       * </code>
       */
      public Builder clearConditionBoostSpecs() {
        if (conditionBoostSpecsBuilder_ == null) {
          conditionBoostSpecs_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          conditionBoostSpecsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Condition boost specifications. If a document matches multiple conditions
       * in the specifictions, boost scores from these specifications are all
       * applied and combined in a non-linear way. Maximum number of
       * specifications is 20.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec condition_boost_specs = 1;
       * </code>
       */
      public Builder removeConditionBoostSpecs(int index) {
        if (conditionBoostSpecsBuilder_ == null) {
          ensureConditionBoostSpecsIsMutable();
          conditionBoostSpecs_.remove(index);
          onChanged();
        } else {
          conditionBoostSpecsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Condition boost specifications. If a document matches multiple conditions
       * in the specifictions, boost scores from these specifications are all
       * applied and combined in a non-linear way. Maximum number of
       * specifications is 20.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec condition_boost_specs = 1;
       * </code>
       */
      public com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
              .Builder
          getConditionBoostSpecsBuilder(int index) {
        return getConditionBoostSpecsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * Condition boost specifications. If a document matches multiple conditions
       * in the specifictions, boost scores from these specifications are all
       * applied and combined in a non-linear way. Maximum number of
       * specifications is 20.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec condition_boost_specs = 1;
       * </code>
       */
      public com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec
              .ConditionBoostSpecOrBuilder
          getConditionBoostSpecsOrBuilder(int index) {
        if (conditionBoostSpecsBuilder_ == null) {
          return conditionBoostSpecs_.get(index);
        } else {
          return conditionBoostSpecsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Condition boost specifications. If a document matches multiple conditions
       * in the specifictions, boost scores from these specifications are all
       * applied and combined in a non-linear way. Maximum number of
       * specifications is 20.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec condition_boost_specs = 1;
       * </code>
       */
      public java.util.List<
              ? extends
                  com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec
                      .ConditionBoostSpecOrBuilder>
          getConditionBoostSpecsOrBuilderList() {
        if (conditionBoostSpecsBuilder_ != null) {
          return conditionBoostSpecsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(conditionBoostSpecs_);
        }
      }
      /**
       *
       *
       * <pre>
       * Condition boost specifications. If a document matches multiple conditions
       * in the specifictions, boost scores from these specifications are all
       * applied and combined in a non-linear way. Maximum number of
       * specifications is 20.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec condition_boost_specs = 1;
       * </code>
       */
      public com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
              .Builder
          addConditionBoostSpecsBuilder() {
        return getConditionBoostSpecsFieldBuilder()
            .addBuilder(
                com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Condition boost specifications. If a document matches multiple conditions
       * in the specifictions, boost scores from these specifications are all
       * applied and combined in a non-linear way. Maximum number of
       * specifications is 20.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec condition_boost_specs = 1;
       * </code>
       */
      public com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
              .Builder
          addConditionBoostSpecsBuilder(int index) {
        return getConditionBoostSpecsFieldBuilder()
            .addBuilder(
                index,
                com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Condition boost specifications. If a document matches multiple conditions
       * in the specifictions, boost scores from these specifications are all
       * applied and combined in a non-linear way. Maximum number of
       * specifications is 20.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec condition_boost_specs = 1;
       * </code>
       */
      public java.util.List<
              com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
                  .Builder>
          getConditionBoostSpecsBuilderList() {
        return getConditionBoostSpecsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec,
              com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
                  .Builder,
              com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec
                  .ConditionBoostSpecOrBuilder>
          getConditionBoostSpecsFieldBuilder() {
        if (conditionBoostSpecsBuilder_ == null) {
          conditionBoostSpecsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec
                      .ConditionBoostSpec,
                  com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
                      .Builder,
                  com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec
                      .ConditionBoostSpecOrBuilder>(
                  conditionBoostSpecs_,
                  ((bitField0_ & 0x00000001) != 0),
                  getParentForChildren(),
                  isClean());
          conditionBoostSpecs_ = null;
        }
        return conditionBoostSpecsBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec)
    private static final com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec();
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<BoostSpec> PARSER =
        new com.google.protobuf.AbstractParser<BoostSpec>() {
          @java.lang.Override
          public BoostSpec parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<BoostSpec> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<BoostSpec> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface QueryExpansionSpecOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1beta.SearchRequest.QueryExpansionSpec)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The condition under which query expansion should occur. Default to
     * [Condition.DISABLED][google.cloud.discoveryengine.v1beta.SearchRequest.QueryExpansionSpec.Condition.DISABLED].
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.SearchRequest.QueryExpansionSpec.Condition condition = 1;
     * </code>
     *
     * @return The enum numeric value on the wire for condition.
     */
    int getConditionValue();
    /**
     *
     *
     * <pre>
     * The condition under which query expansion should occur. Default to
     * [Condition.DISABLED][google.cloud.discoveryengine.v1beta.SearchRequest.QueryExpansionSpec.Condition.DISABLED].
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.SearchRequest.QueryExpansionSpec.Condition condition = 1;
     * </code>
     *
     * @return The condition.
     */
    com.google.cloud.discoveryengine.v1beta.SearchRequest.QueryExpansionSpec.Condition
        getCondition();

    /**
     *
     *
     * <pre>
     * Whether to pin unexpanded results. If this field is set to true,
     * unexpanded products are always at the top of the search results, followed
     * by the expanded results.
     * </pre>
     *
     * <code>bool pin_unexpanded_results = 2;</code>
     *
     * @return The pinUnexpandedResults.
     */
    boolean getPinUnexpandedResults();
  }
  /**
   *
   *
   * <pre>
   * Specification to determine under which conditions query expansion should
   * occur.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1beta.SearchRequest.QueryExpansionSpec}
   */
  public static final class QueryExpansionSpec extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.SearchRequest.QueryExpansionSpec)
      QueryExpansionSpecOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use QueryExpansionSpec.newBuilder() to construct.
    private QueryExpansionSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private QueryExpansionSpec() {
      condition_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new QueryExpansionSpec();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
          .internal_static_google_cloud_discoveryengine_v1beta_SearchRequest_QueryExpansionSpec_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
          .internal_static_google_cloud_discoveryengine_v1beta_SearchRequest_QueryExpansionSpec_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1beta.SearchRequest.QueryExpansionSpec.class,
              com.google.cloud.discoveryengine.v1beta.SearchRequest.QueryExpansionSpec.Builder
                  .class);
    }

    /**
     *
     *
     * <pre>
     * Enum describing under which condition query expansion should occur.
     * </pre>
     *
     * Protobuf enum {@code
     * google.cloud.discoveryengine.v1beta.SearchRequest.QueryExpansionSpec.Condition}
     */
    public enum Condition implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Unspecified query expansion condition. In this case, server behavior
       * defaults to
       * [Condition.DISABLED][google.cloud.discoveryengine.v1beta.SearchRequest.QueryExpansionSpec.Condition.DISABLED].
       * </pre>
       *
       * <code>CONDITION_UNSPECIFIED = 0;</code>
       */
      CONDITION_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * Disabled query expansion. Only the exact search query is used, even if
       * [SearchResponse.total_size][google.cloud.discoveryengine.v1beta.SearchResponse.total_size]
       * is zero.
       * </pre>
       *
       * <code>DISABLED = 1;</code>
       */
      DISABLED(1),
      /**
       *
       *
       * <pre>
       * Automatic query expansion built by the Search API.
       * </pre>
       *
       * <code>AUTO = 2;</code>
       */
      AUTO(2),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Unspecified query expansion condition. In this case, server behavior
       * defaults to
       * [Condition.DISABLED][google.cloud.discoveryengine.v1beta.SearchRequest.QueryExpansionSpec.Condition.DISABLED].
       * </pre>
       *
       * <code>CONDITION_UNSPECIFIED = 0;</code>
       */
      public static final int CONDITION_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * Disabled query expansion. Only the exact search query is used, even if
       * [SearchResponse.total_size][google.cloud.discoveryengine.v1beta.SearchResponse.total_size]
       * is zero.
       * </pre>
       *
       * <code>DISABLED = 1;</code>
       */
      public static final int DISABLED_VALUE = 1;
      /**
       *
       *
       * <pre>
       * Automatic query expansion built by the Search API.
       * </pre>
       *
       * <code>AUTO = 2;</code>
       */
      public static final int AUTO_VALUE = 2;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static Condition valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static Condition forNumber(int value) {
        switch (value) {
          case 0:
            return CONDITION_UNSPECIFIED;
          case 1:
            return DISABLED;
          case 2:
            return AUTO;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<Condition> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<Condition> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<Condition>() {
            public Condition findValueByNumber(int number) {
              return Condition.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1beta.SearchRequest.QueryExpansionSpec
            .getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final Condition[] VALUES = values();

      public static Condition valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private Condition(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.cloud.discoveryengine.v1beta.SearchRequest.QueryExpansionSpec.Condition)
    }

    public static final int CONDITION_FIELD_NUMBER = 1;
    private int condition_ = 0;
    /**
     *
     *
     * <pre>
     * The condition under which query expansion should occur. Default to
     * [Condition.DISABLED][google.cloud.discoveryengine.v1beta.SearchRequest.QueryExpansionSpec.Condition.DISABLED].
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.SearchRequest.QueryExpansionSpec.Condition condition = 1;
     * </code>
     *
     * @return The enum numeric value on the wire for condition.
     */
    @java.lang.Override
    public int getConditionValue() {
      return condition_;
    }
    /**
     *
     *
     * <pre>
     * The condition under which query expansion should occur. Default to
     * [Condition.DISABLED][google.cloud.discoveryengine.v1beta.SearchRequest.QueryExpansionSpec.Condition.DISABLED].
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.SearchRequest.QueryExpansionSpec.Condition condition = 1;
     * </code>
     *
     * @return The condition.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.SearchRequest.QueryExpansionSpec.Condition
        getCondition() {
      com.google.cloud.discoveryengine.v1beta.SearchRequest.QueryExpansionSpec.Condition result =
          com.google.cloud.discoveryengine.v1beta.SearchRequest.QueryExpansionSpec.Condition
              .forNumber(condition_);
      return result == null
          ? com.google.cloud.discoveryengine.v1beta.SearchRequest.QueryExpansionSpec.Condition
              .UNRECOGNIZED
          : result;
    }

    public static final int PIN_UNEXPANDED_RESULTS_FIELD_NUMBER = 2;
    private boolean pinUnexpandedResults_ = false;
    /**
     *
     *
     * <pre>
     * Whether to pin unexpanded results. If this field is set to true,
     * unexpanded products are always at the top of the search results, followed
     * by the expanded results.
     * </pre>
     *
     * <code>bool pin_unexpanded_results = 2;</code>
     *
     * @return The pinUnexpandedResults.
     */
    @java.lang.Override
    public boolean getPinUnexpandedResults() {
      return pinUnexpandedResults_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (condition_
          != com.google.cloud.discoveryengine.v1beta.SearchRequest.QueryExpansionSpec.Condition
              .CONDITION_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(1, condition_);
      }
      if (pinUnexpandedResults_ != false) {
        output.writeBool(2, pinUnexpandedResults_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (condition_
          != com.google.cloud.discoveryengine.v1beta.SearchRequest.QueryExpansionSpec.Condition
              .CONDITION_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, condition_);
      }
      if (pinUnexpandedResults_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(2, pinUnexpandedResults_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.discoveryengine.v1beta.SearchRequest.QueryExpansionSpec)) {
        return super.equals(obj);
      }
      com.google.cloud.discoveryengine.v1beta.SearchRequest.QueryExpansionSpec other =
          (com.google.cloud.discoveryengine.v1beta.SearchRequest.QueryExpansionSpec) obj;

      if (condition_ != other.condition_) return false;
      if (getPinUnexpandedResults() != other.getPinUnexpandedResults()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + CONDITION_FIELD_NUMBER;
      hash = (53 * hash) + condition_;
      hash = (37 * hash) + PIN_UNEXPANDED_RESULTS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getPinUnexpandedResults());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchRequest.QueryExpansionSpec
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchRequest.QueryExpansionSpec
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchRequest.QueryExpansionSpec
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchRequest.QueryExpansionSpec
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchRequest.QueryExpansionSpec
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchRequest.QueryExpansionSpec
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchRequest.QueryExpansionSpec
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchRequest.QueryExpansionSpec
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchRequest.QueryExpansionSpec
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchRequest.QueryExpansionSpec
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchRequest.QueryExpansionSpec
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchRequest.QueryExpansionSpec
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.discoveryengine.v1beta.SearchRequest.QueryExpansionSpec prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Specification to determine under which conditions query expansion should
     * occur.
     * </pre>
     *
     * Protobuf type {@code google.cloud.discoveryengine.v1beta.SearchRequest.QueryExpansionSpec}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.SearchRequest.QueryExpansionSpec)
        com.google.cloud.discoveryengine.v1beta.SearchRequest.QueryExpansionSpecOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_SearchRequest_QueryExpansionSpec_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_SearchRequest_QueryExpansionSpec_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1beta.SearchRequest.QueryExpansionSpec.class,
                com.google.cloud.discoveryengine.v1beta.SearchRequest.QueryExpansionSpec.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.discoveryengine.v1beta.SearchRequest.QueryExpansionSpec.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        condition_ = 0;
        pinUnexpandedResults_ = false;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_SearchRequest_QueryExpansionSpec_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.SearchRequest.QueryExpansionSpec
          getDefaultInstanceForType() {
        return com.google.cloud.discoveryengine.v1beta.SearchRequest.QueryExpansionSpec
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.SearchRequest.QueryExpansionSpec build() {
        com.google.cloud.discoveryengine.v1beta.SearchRequest.QueryExpansionSpec result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.SearchRequest.QueryExpansionSpec
          buildPartial() {
        com.google.cloud.discoveryengine.v1beta.SearchRequest.QueryExpansionSpec result =
            new com.google.cloud.discoveryengine.v1beta.SearchRequest.QueryExpansionSpec(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.discoveryengine.v1beta.SearchRequest.QueryExpansionSpec result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.condition_ = condition_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.pinUnexpandedResults_ = pinUnexpandedResults_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.discoveryengine.v1beta.SearchRequest.QueryExpansionSpec) {
          return mergeFrom(
              (com.google.cloud.discoveryengine.v1beta.SearchRequest.QueryExpansionSpec) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.discoveryengine.v1beta.SearchRequest.QueryExpansionSpec other) {
        if (other
            == com.google.cloud.discoveryengine.v1beta.SearchRequest.QueryExpansionSpec
                .getDefaultInstance()) return this;
        if (other.condition_ != 0) {
          setConditionValue(other.getConditionValue());
        }
        if (other.getPinUnexpandedResults() != false) {
          setPinUnexpandedResults(other.getPinUnexpandedResults());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  condition_ = input.readEnum();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 16:
                {
                  pinUnexpandedResults_ = input.readBool();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int condition_ = 0;
      /**
       *
       *
       * <pre>
       * The condition under which query expansion should occur. Default to
       * [Condition.DISABLED][google.cloud.discoveryengine.v1beta.SearchRequest.QueryExpansionSpec.Condition.DISABLED].
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.SearchRequest.QueryExpansionSpec.Condition condition = 1;
       * </code>
       *
       * @return The enum numeric value on the wire for condition.
       */
      @java.lang.Override
      public int getConditionValue() {
        return condition_;
      }
      /**
       *
       *
       * <pre>
       * The condition under which query expansion should occur. Default to
       * [Condition.DISABLED][google.cloud.discoveryengine.v1beta.SearchRequest.QueryExpansionSpec.Condition.DISABLED].
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.SearchRequest.QueryExpansionSpec.Condition condition = 1;
       * </code>
       *
       * @param value The enum numeric value on the wire for condition to set.
       * @return This builder for chaining.
       */
      public Builder setConditionValue(int value) {
        condition_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The condition under which query expansion should occur. Default to
       * [Condition.DISABLED][google.cloud.discoveryengine.v1beta.SearchRequest.QueryExpansionSpec.Condition.DISABLED].
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.SearchRequest.QueryExpansionSpec.Condition condition = 1;
       * </code>
       *
       * @return The condition.
       */
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.SearchRequest.QueryExpansionSpec.Condition
          getCondition() {
        com.google.cloud.discoveryengine.v1beta.SearchRequest.QueryExpansionSpec.Condition result =
            com.google.cloud.discoveryengine.v1beta.SearchRequest.QueryExpansionSpec.Condition
                .forNumber(condition_);
        return result == null
            ? com.google.cloud.discoveryengine.v1beta.SearchRequest.QueryExpansionSpec.Condition
                .UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * The condition under which query expansion should occur. Default to
       * [Condition.DISABLED][google.cloud.discoveryengine.v1beta.SearchRequest.QueryExpansionSpec.Condition.DISABLED].
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.SearchRequest.QueryExpansionSpec.Condition condition = 1;
       * </code>
       *
       * @param value The condition to set.
       * @return This builder for chaining.
       */
      public Builder setCondition(
          com.google.cloud.discoveryengine.v1beta.SearchRequest.QueryExpansionSpec.Condition
              value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        condition_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The condition under which query expansion should occur. Default to
       * [Condition.DISABLED][google.cloud.discoveryengine.v1beta.SearchRequest.QueryExpansionSpec.Condition.DISABLED].
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.SearchRequest.QueryExpansionSpec.Condition condition = 1;
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearCondition() {
        bitField0_ = (bitField0_ & ~0x00000001);
        condition_ = 0;
        onChanged();
        return this;
      }

      private boolean pinUnexpandedResults_;
      /**
       *
       *
       * <pre>
       * Whether to pin unexpanded results. If this field is set to true,
       * unexpanded products are always at the top of the search results, followed
       * by the expanded results.
       * </pre>
       *
       * <code>bool pin_unexpanded_results = 2;</code>
       *
       * @return The pinUnexpandedResults.
       */
      @java.lang.Override
      public boolean getPinUnexpandedResults() {
        return pinUnexpandedResults_;
      }
      /**
       *
       *
       * <pre>
       * Whether to pin unexpanded results. If this field is set to true,
       * unexpanded products are always at the top of the search results, followed
       * by the expanded results.
       * </pre>
       *
       * <code>bool pin_unexpanded_results = 2;</code>
       *
       * @param value The pinUnexpandedResults to set.
       * @return This builder for chaining.
       */
      public Builder setPinUnexpandedResults(boolean value) {

        pinUnexpandedResults_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Whether to pin unexpanded results. If this field is set to true,
       * unexpanded products are always at the top of the search results, followed
       * by the expanded results.
       * </pre>
       *
       * <code>bool pin_unexpanded_results = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPinUnexpandedResults() {
        bitField0_ = (bitField0_ & ~0x00000002);
        pinUnexpandedResults_ = false;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.SearchRequest.QueryExpansionSpec)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.SearchRequest.QueryExpansionSpec)
    private static final com.google.cloud.discoveryengine.v1beta.SearchRequest.QueryExpansionSpec
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.discoveryengine.v1beta.SearchRequest.QueryExpansionSpec();
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchRequest.QueryExpansionSpec
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<QueryExpansionSpec> PARSER =
        new com.google.protobuf.AbstractParser<QueryExpansionSpec>() {
          @java.lang.Override
          public QueryExpansionSpec parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<QueryExpansionSpec> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<QueryExpansionSpec> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.SearchRequest.QueryExpansionSpec
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface SpellCorrectionSpecOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1beta.SearchRequest.SpellCorrectionSpec)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The mode under which spell correction should take effect to
     * replace the original search query. Default to
     * [Mode.AUTO][google.cloud.discoveryengine.v1beta.SearchRequest.SpellCorrectionSpec.Mode.AUTO].
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.SearchRequest.SpellCorrectionSpec.Mode mode = 1;
     * </code>
     *
     * @return The enum numeric value on the wire for mode.
     */
    int getModeValue();
    /**
     *
     *
     * <pre>
     * The mode under which spell correction should take effect to
     * replace the original search query. Default to
     * [Mode.AUTO][google.cloud.discoveryengine.v1beta.SearchRequest.SpellCorrectionSpec.Mode.AUTO].
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.SearchRequest.SpellCorrectionSpec.Mode mode = 1;
     * </code>
     *
     * @return The mode.
     */
    com.google.cloud.discoveryengine.v1beta.SearchRequest.SpellCorrectionSpec.Mode getMode();
  }
  /**
   *
   *
   * <pre>
   * The specification for query spell correction.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1beta.SearchRequest.SpellCorrectionSpec}
   */
  public static final class SpellCorrectionSpec extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.SearchRequest.SpellCorrectionSpec)
      SpellCorrectionSpecOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use SpellCorrectionSpec.newBuilder() to construct.
    private SpellCorrectionSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private SpellCorrectionSpec() {
      mode_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new SpellCorrectionSpec();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
          .internal_static_google_cloud_discoveryengine_v1beta_SearchRequest_SpellCorrectionSpec_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
          .internal_static_google_cloud_discoveryengine_v1beta_SearchRequest_SpellCorrectionSpec_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1beta.SearchRequest.SpellCorrectionSpec.class,
              com.google.cloud.discoveryengine.v1beta.SearchRequest.SpellCorrectionSpec.Builder
                  .class);
    }

    /**
     *
     *
     * <pre>
     * Enum describing under which mode spell correction should occur.
     * </pre>
     *
     * Protobuf enum {@code
     * google.cloud.discoveryengine.v1beta.SearchRequest.SpellCorrectionSpec.Mode}
     */
    public enum Mode implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Unspecified spell correction mode. In this case, server behavior
       * defaults to
       * [Mode.AUTO][google.cloud.discoveryengine.v1beta.SearchRequest.SpellCorrectionSpec.Mode.AUTO].
       * </pre>
       *
       * <code>MODE_UNSPECIFIED = 0;</code>
       */
      MODE_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * Search API will try to find a spell suggestion if there
       * is any and put in the
       * [SearchResponse.corrected_query][google.cloud.discoveryengine.v1beta.SearchResponse.corrected_query].
       * The spell suggestion will not be used as the search query.
       * </pre>
       *
       * <code>SUGGESTION_ONLY = 1;</code>
       */
      SUGGESTION_ONLY(1),
      /**
       *
       *
       * <pre>
       * Automatic spell correction built by the Search API. Search will
       * be based on the corrected query if found.
       * </pre>
       *
       * <code>AUTO = 2;</code>
       */
      AUTO(2),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Unspecified spell correction mode. In this case, server behavior
       * defaults to
       * [Mode.AUTO][google.cloud.discoveryengine.v1beta.SearchRequest.SpellCorrectionSpec.Mode.AUTO].
       * </pre>
       *
       * <code>MODE_UNSPECIFIED = 0;</code>
       */
      public static final int MODE_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * Search API will try to find a spell suggestion if there
       * is any and put in the
       * [SearchResponse.corrected_query][google.cloud.discoveryengine.v1beta.SearchResponse.corrected_query].
       * The spell suggestion will not be used as the search query.
       * </pre>
       *
       * <code>SUGGESTION_ONLY = 1;</code>
       */
      public static final int SUGGESTION_ONLY_VALUE = 1;
      /**
       *
       *
       * <pre>
       * Automatic spell correction built by the Search API. Search will
       * be based on the corrected query if found.
       * </pre>
       *
       * <code>AUTO = 2;</code>
       */
      public static final int AUTO_VALUE = 2;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static Mode valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static Mode forNumber(int value) {
        switch (value) {
          case 0:
            return MODE_UNSPECIFIED;
          case 1:
            return SUGGESTION_ONLY;
          case 2:
            return AUTO;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<Mode> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<Mode> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<Mode>() {
            public Mode findValueByNumber(int number) {
              return Mode.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1beta.SearchRequest.SpellCorrectionSpec
            .getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final Mode[] VALUES = values();

      public static Mode valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private Mode(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.cloud.discoveryengine.v1beta.SearchRequest.SpellCorrectionSpec.Mode)
    }

    public static final int MODE_FIELD_NUMBER = 1;
    private int mode_ = 0;
    /**
     *
     *
     * <pre>
     * The mode under which spell correction should take effect to
     * replace the original search query. Default to
     * [Mode.AUTO][google.cloud.discoveryengine.v1beta.SearchRequest.SpellCorrectionSpec.Mode.AUTO].
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.SearchRequest.SpellCorrectionSpec.Mode mode = 1;
     * </code>
     *
     * @return The enum numeric value on the wire for mode.
     */
    @java.lang.Override
    public int getModeValue() {
      return mode_;
    }
    /**
     *
     *
     * <pre>
     * The mode under which spell correction should take effect to
     * replace the original search query. Default to
     * [Mode.AUTO][google.cloud.discoveryengine.v1beta.SearchRequest.SpellCorrectionSpec.Mode.AUTO].
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.SearchRequest.SpellCorrectionSpec.Mode mode = 1;
     * </code>
     *
     * @return The mode.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.SearchRequest.SpellCorrectionSpec.Mode
        getMode() {
      com.google.cloud.discoveryengine.v1beta.SearchRequest.SpellCorrectionSpec.Mode result =
          com.google.cloud.discoveryengine.v1beta.SearchRequest.SpellCorrectionSpec.Mode.forNumber(
              mode_);
      return result == null
          ? com.google.cloud.discoveryengine.v1beta.SearchRequest.SpellCorrectionSpec.Mode
              .UNRECOGNIZED
          : result;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (mode_
          != com.google.cloud.discoveryengine.v1beta.SearchRequest.SpellCorrectionSpec.Mode
              .MODE_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(1, mode_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (mode_
          != com.google.cloud.discoveryengine.v1beta.SearchRequest.SpellCorrectionSpec.Mode
              .MODE_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, mode_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.discoveryengine.v1beta.SearchRequest.SpellCorrectionSpec)) {
        return super.equals(obj);
      }
      com.google.cloud.discoveryengine.v1beta.SearchRequest.SpellCorrectionSpec other =
          (com.google.cloud.discoveryengine.v1beta.SearchRequest.SpellCorrectionSpec) obj;

      if (mode_ != other.mode_) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + MODE_FIELD_NUMBER;
      hash = (53 * hash) + mode_;
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchRequest.SpellCorrectionSpec
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchRequest.SpellCorrectionSpec
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchRequest.SpellCorrectionSpec
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchRequest.SpellCorrectionSpec
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchRequest.SpellCorrectionSpec
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchRequest.SpellCorrectionSpec
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchRequest.SpellCorrectionSpec
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchRequest.SpellCorrectionSpec
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchRequest.SpellCorrectionSpec
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchRequest.SpellCorrectionSpec
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchRequest.SpellCorrectionSpec
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchRequest.SpellCorrectionSpec
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.discoveryengine.v1beta.SearchRequest.SpellCorrectionSpec prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * The specification for query spell correction.
     * </pre>
     *
     * Protobuf type {@code google.cloud.discoveryengine.v1beta.SearchRequest.SpellCorrectionSpec}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.SearchRequest.SpellCorrectionSpec)
        com.google.cloud.discoveryengine.v1beta.SearchRequest.SpellCorrectionSpecOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_SearchRequest_SpellCorrectionSpec_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_SearchRequest_SpellCorrectionSpec_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1beta.SearchRequest.SpellCorrectionSpec.class,
                com.google.cloud.discoveryengine.v1beta.SearchRequest.SpellCorrectionSpec.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.discoveryengine.v1beta.SearchRequest.SpellCorrectionSpec.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        mode_ = 0;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_SearchRequest_SpellCorrectionSpec_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.SearchRequest.SpellCorrectionSpec
          getDefaultInstanceForType() {
        return com.google.cloud.discoveryengine.v1beta.SearchRequest.SpellCorrectionSpec
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.SearchRequest.SpellCorrectionSpec build() {
        com.google.cloud.discoveryengine.v1beta.SearchRequest.SpellCorrectionSpec result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.SearchRequest.SpellCorrectionSpec
          buildPartial() {
        com.google.cloud.discoveryengine.v1beta.SearchRequest.SpellCorrectionSpec result =
            new com.google.cloud.discoveryengine.v1beta.SearchRequest.SpellCorrectionSpec(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.discoveryengine.v1beta.SearchRequest.SpellCorrectionSpec result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.mode_ = mode_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.discoveryengine.v1beta.SearchRequest.SpellCorrectionSpec) {
          return mergeFrom(
              (com.google.cloud.discoveryengine.v1beta.SearchRequest.SpellCorrectionSpec) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.discoveryengine.v1beta.SearchRequest.SpellCorrectionSpec other) {
        if (other
            == com.google.cloud.discoveryengine.v1beta.SearchRequest.SpellCorrectionSpec
                .getDefaultInstance()) return this;
        if (other.mode_ != 0) {
          setModeValue(other.getModeValue());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  mode_ = input.readEnum();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int mode_ = 0;
      /**
       *
       *
       * <pre>
       * The mode under which spell correction should take effect to
       * replace the original search query. Default to
       * [Mode.AUTO][google.cloud.discoveryengine.v1beta.SearchRequest.SpellCorrectionSpec.Mode.AUTO].
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1beta.SearchRequest.SpellCorrectionSpec.Mode mode = 1;
       * </code>
       *
       * @return The enum numeric value on the wire for mode.
       */
      @java.lang.Override
      public int getModeValue() {
        return mode_;
      }
      /**
       *
       *
       * <pre>
       * The mode under which spell correction should take effect to
       * replace the original search query. Default to
       * [Mode.AUTO][google.cloud.discoveryengine.v1beta.SearchRequest.SpellCorrectionSpec.Mode.AUTO].
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1beta.SearchRequest.SpellCorrectionSpec.Mode mode = 1;
       * </code>
       *
       * @param value The enum numeric value on the wire for mode to set.
       * @return This builder for chaining.
       */
      public Builder setModeValue(int value) {
        mode_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The mode under which spell correction should take effect to
       * replace the original search query. Default to
       * [Mode.AUTO][google.cloud.discoveryengine.v1beta.SearchRequest.SpellCorrectionSpec.Mode.AUTO].
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1beta.SearchRequest.SpellCorrectionSpec.Mode mode = 1;
       * </code>
       *
       * @return The mode.
       */
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.SearchRequest.SpellCorrectionSpec.Mode
          getMode() {
        com.google.cloud.discoveryengine.v1beta.SearchRequest.SpellCorrectionSpec.Mode result =
            com.google.cloud.discoveryengine.v1beta.SearchRequest.SpellCorrectionSpec.Mode
                .forNumber(mode_);
        return result == null
            ? com.google.cloud.discoveryengine.v1beta.SearchRequest.SpellCorrectionSpec.Mode
                .UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * The mode under which spell correction should take effect to
       * replace the original search query. Default to
       * [Mode.AUTO][google.cloud.discoveryengine.v1beta.SearchRequest.SpellCorrectionSpec.Mode.AUTO].
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1beta.SearchRequest.SpellCorrectionSpec.Mode mode = 1;
       * </code>
       *
       * @param value The mode to set.
       * @return This builder for chaining.
       */
      public Builder setMode(
          com.google.cloud.discoveryengine.v1beta.SearchRequest.SpellCorrectionSpec.Mode value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        mode_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The mode under which spell correction should take effect to
       * replace the original search query. Default to
       * [Mode.AUTO][google.cloud.discoveryengine.v1beta.SearchRequest.SpellCorrectionSpec.Mode.AUTO].
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1beta.SearchRequest.SpellCorrectionSpec.Mode mode = 1;
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMode() {
        bitField0_ = (bitField0_ & ~0x00000001);
        mode_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.SearchRequest.SpellCorrectionSpec)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.SearchRequest.SpellCorrectionSpec)
    private static final com.google.cloud.discoveryengine.v1beta.SearchRequest.SpellCorrectionSpec
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.discoveryengine.v1beta.SearchRequest.SpellCorrectionSpec();
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchRequest.SpellCorrectionSpec
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<SpellCorrectionSpec> PARSER =
        new com.google.protobuf.AbstractParser<SpellCorrectionSpec>() {
          @java.lang.Override
          public SpellCorrectionSpec parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<SpellCorrectionSpec> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<SpellCorrectionSpec> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.SearchRequest.SpellCorrectionSpec
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ContentSearchSpecOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * If `snippetSpec` is not specified, snippets are not included in the
     * search response.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SnippetSpec snippet_spec = 1;
     * </code>
     *
     * @return Whether the snippetSpec field is set.
     */
    boolean hasSnippetSpec();
    /**
     *
     *
     * <pre>
     * If `snippetSpec` is not specified, snippets are not included in the
     * search response.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SnippetSpec snippet_spec = 1;
     * </code>
     *
     * @return The snippetSpec.
     */
    com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SnippetSpec
        getSnippetSpec();
    /**
     *
     *
     * <pre>
     * If `snippetSpec` is not specified, snippets are not included in the
     * search response.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SnippetSpec snippet_spec = 1;
     * </code>
     */
    com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SnippetSpecOrBuilder
        getSnippetSpecOrBuilder();

    /**
     *
     *
     * <pre>
     * If `summarySpec` is not specified, summaries are not included in the
     * search response.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec summary_spec = 2;
     * </code>
     *
     * @return Whether the summarySpec field is set.
     */
    boolean hasSummarySpec();
    /**
     *
     *
     * <pre>
     * If `summarySpec` is not specified, summaries are not included in the
     * search response.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec summary_spec = 2;
     * </code>
     *
     * @return The summarySpec.
     */
    com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec
        getSummarySpec();
    /**
     *
     *
     * <pre>
     * If `summarySpec` is not specified, summaries are not included in the
     * search response.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec summary_spec = 2;
     * </code>
     */
    com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpecOrBuilder
        getSummarySpecOrBuilder();

    /**
     *
     *
     * <pre>
     * If there is no extractive_content_spec provided, there will be no
     * extractive answer in the search response.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.ExtractiveContentSpec extractive_content_spec = 3;
     * </code>
     *
     * @return Whether the extractiveContentSpec field is set.
     */
    boolean hasExtractiveContentSpec();
    /**
     *
     *
     * <pre>
     * If there is no extractive_content_spec provided, there will be no
     * extractive answer in the search response.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.ExtractiveContentSpec extractive_content_spec = 3;
     * </code>
     *
     * @return The extractiveContentSpec.
     */
    com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.ExtractiveContentSpec
        getExtractiveContentSpec();
    /**
     *
     *
     * <pre>
     * If there is no extractive_content_spec provided, there will be no
     * extractive answer in the search response.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.ExtractiveContentSpec extractive_content_spec = 3;
     * </code>
     */
    com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
            .ExtractiveContentSpecOrBuilder
        getExtractiveContentSpecOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * A specification for configuring the behavior of content search.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec}
   */
  public static final class ContentSearchSpec extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec)
      ContentSearchSpecOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ContentSearchSpec.newBuilder() to construct.
    private ContentSearchSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ContentSearchSpec() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ContentSearchSpec();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
          .internal_static_google_cloud_discoveryengine_v1beta_SearchRequest_ContentSearchSpec_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
          .internal_static_google_cloud_discoveryengine_v1beta_SearchRequest_ContentSearchSpec_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.class,
              com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.Builder
                  .class);
    }

    public interface SnippetSpecOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SnippetSpec)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * [DEPRECATED] This field is deprecated. To control snippet return, use
       * `return_snippet` field. For backwards compatibility, we will return
       * snippet if max_snippet_count &gt; 0.
       * </pre>
       *
       * <code>int32 max_snippet_count = 1 [deprecated = true];</code>
       *
       * @deprecated
       *     google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SnippetSpec.max_snippet_count
       *     is deprecated. See google/cloud/discoveryengine/v1beta/search_service.proto;l=400
       * @return The maxSnippetCount.
       */
      @java.lang.Deprecated
      int getMaxSnippetCount();

      /**
       *
       *
       * <pre>
       * [DEPRECATED] This field is deprecated and will have no affect on the
       * snippet.
       * </pre>
       *
       * <code>bool reference_only = 2 [deprecated = true];</code>
       *
       * @deprecated
       *     google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SnippetSpec.reference_only
       *     is deprecated. See google/cloud/discoveryengine/v1beta/search_service.proto;l=404
       * @return The referenceOnly.
       */
      @java.lang.Deprecated
      boolean getReferenceOnly();

      /**
       *
       *
       * <pre>
       * If `true`, then return snippet. If no snippet can be generated, we
       * return "No snippet is available for this page." A `snippet_status` with
       * `SUCCESS` or `NO_SNIPPET_AVAILABLE` will also be returned.
       * </pre>
       *
       * <code>bool return_snippet = 3;</code>
       *
       * @return The returnSnippet.
       */
      boolean getReturnSnippet();
    }
    /**
     *
     *
     * <pre>
     * A specification for configuring snippets in a search response.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SnippetSpec}
     */
    public static final class SnippetSpec extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SnippetSpec)
        SnippetSpecOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use SnippetSpec.newBuilder() to construct.
      private SnippetSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private SnippetSpec() {}

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new SnippetSpec();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_SearchRequest_ContentSearchSpec_SnippetSpec_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_SearchRequest_ContentSearchSpec_SnippetSpec_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SnippetSpec
                    .class,
                com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SnippetSpec
                    .Builder.class);
      }

      public static final int MAX_SNIPPET_COUNT_FIELD_NUMBER = 1;
      private int maxSnippetCount_ = 0;
      /**
       *
       *
       * <pre>
       * [DEPRECATED] This field is deprecated. To control snippet return, use
       * `return_snippet` field. For backwards compatibility, we will return
       * snippet if max_snippet_count &gt; 0.
       * </pre>
       *
       * <code>int32 max_snippet_count = 1 [deprecated = true];</code>
       *
       * @deprecated
       *     google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SnippetSpec.max_snippet_count
       *     is deprecated. See google/cloud/discoveryengine/v1beta/search_service.proto;l=400
       * @return The maxSnippetCount.
       */
      @java.lang.Override
      @java.lang.Deprecated
      public int getMaxSnippetCount() {
        return maxSnippetCount_;
      }

      public static final int REFERENCE_ONLY_FIELD_NUMBER = 2;
      private boolean referenceOnly_ = false;
      /**
       *
       *
       * <pre>
       * [DEPRECATED] This field is deprecated and will have no affect on the
       * snippet.
       * </pre>
       *
       * <code>bool reference_only = 2 [deprecated = true];</code>
       *
       * @deprecated
       *     google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SnippetSpec.reference_only
       *     is deprecated. See google/cloud/discoveryengine/v1beta/search_service.proto;l=404
       * @return The referenceOnly.
       */
      @java.lang.Override
      @java.lang.Deprecated
      public boolean getReferenceOnly() {
        return referenceOnly_;
      }

      public static final int RETURN_SNIPPET_FIELD_NUMBER = 3;
      private boolean returnSnippet_ = false;
      /**
       *
       *
       * <pre>
       * If `true`, then return snippet. If no snippet can be generated, we
       * return "No snippet is available for this page." A `snippet_status` with
       * `SUCCESS` or `NO_SNIPPET_AVAILABLE` will also be returned.
       * </pre>
       *
       * <code>bool return_snippet = 3;</code>
       *
       * @return The returnSnippet.
       */
      @java.lang.Override
      public boolean getReturnSnippet() {
        return returnSnippet_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (maxSnippetCount_ != 0) {
          output.writeInt32(1, maxSnippetCount_);
        }
        if (referenceOnly_ != false) {
          output.writeBool(2, referenceOnly_);
        }
        if (returnSnippet_ != false) {
          output.writeBool(3, returnSnippet_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (maxSnippetCount_ != 0) {
          size += com.google.protobuf.CodedOutputStream.computeInt32Size(1, maxSnippetCount_);
        }
        if (referenceOnly_ != false) {
          size += com.google.protobuf.CodedOutputStream.computeBoolSize(2, referenceOnly_);
        }
        if (returnSnippet_ != false) {
          size += com.google.protobuf.CodedOutputStream.computeBoolSize(3, returnSnippet_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SnippetSpec)) {
          return super.equals(obj);
        }
        com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SnippetSpec other =
            (com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SnippetSpec)
                obj;

        if (getMaxSnippetCount() != other.getMaxSnippetCount()) return false;
        if (getReferenceOnly() != other.getReferenceOnly()) return false;
        if (getReturnSnippet() != other.getReturnSnippet()) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + MAX_SNIPPET_COUNT_FIELD_NUMBER;
        hash = (53 * hash) + getMaxSnippetCount();
        hash = (37 * hash) + REFERENCE_ONLY_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getReferenceOnly());
        hash = (37 * hash) + RETURN_SNIPPET_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getReturnSnippet());
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
              .SnippetSpec
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
              .SnippetSpec
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
              .SnippetSpec
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
              .SnippetSpec
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
              .SnippetSpec
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
              .SnippetSpec
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
              .SnippetSpec
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
              .SnippetSpec
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
              .SnippetSpec
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
              .SnippetSpec
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
              .SnippetSpec
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
              .SnippetSpec
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SnippetSpec
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * A specification for configuring snippets in a search response.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SnippetSpec}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SnippetSpec)
          com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
              .SnippetSpecOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
              .internal_static_google_cloud_discoveryengine_v1beta_SearchRequest_ContentSearchSpec_SnippetSpec_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
              .internal_static_google_cloud_discoveryengine_v1beta_SearchRequest_ContentSearchSpec_SnippetSpec_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                      .SnippetSpec.class,
                  com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                      .SnippetSpec.Builder.class);
        }

        // Construct using
        // com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SnippetSpec.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          maxSnippetCount_ = 0;
          referenceOnly_ = false;
          returnSnippet_ = false;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
              .internal_static_google_cloud_discoveryengine_v1beta_SearchRequest_ContentSearchSpec_SnippetSpec_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SnippetSpec
            getDefaultInstanceForType() {
          return com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SnippetSpec
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SnippetSpec
            build() {
          com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SnippetSpec
              result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SnippetSpec
            buildPartial() {
          com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SnippetSpec
              result =
                  new com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                      .SnippetSpec(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SnippetSpec
                result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.maxSnippetCount_ = maxSnippetCount_;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.referenceOnly_ = referenceOnly_;
          }
          if (((from_bitField0_ & 0x00000004) != 0)) {
            result.returnSnippet_ = returnSnippet_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SnippetSpec) {
            return mergeFrom(
                (com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                        .SnippetSpec)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SnippetSpec
                other) {
          if (other
              == com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SnippetSpec
                  .getDefaultInstance()) return this;
          if (other.getMaxSnippetCount() != 0) {
            setMaxSnippetCount(other.getMaxSnippetCount());
          }
          if (other.getReferenceOnly() != false) {
            setReferenceOnly(other.getReferenceOnly());
          }
          if (other.getReturnSnippet() != false) {
            setReturnSnippet(other.getReturnSnippet());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 8:
                  {
                    maxSnippetCount_ = input.readInt32();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 8
                case 16:
                  {
                    referenceOnly_ = input.readBool();
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 16
                case 24:
                  {
                    returnSnippet_ = input.readBool();
                    bitField0_ |= 0x00000004;
                    break;
                  } // case 24
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private int maxSnippetCount_;
        /**
         *
         *
         * <pre>
         * [DEPRECATED] This field is deprecated. To control snippet return, use
         * `return_snippet` field. For backwards compatibility, we will return
         * snippet if max_snippet_count &gt; 0.
         * </pre>
         *
         * <code>int32 max_snippet_count = 1 [deprecated = true];</code>
         *
         * @deprecated
         *     google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SnippetSpec.max_snippet_count
         *     is deprecated. See google/cloud/discoveryengine/v1beta/search_service.proto;l=400
         * @return The maxSnippetCount.
         */
        @java.lang.Override
        @java.lang.Deprecated
        public int getMaxSnippetCount() {
          return maxSnippetCount_;
        }
        /**
         *
         *
         * <pre>
         * [DEPRECATED] This field is deprecated. To control snippet return, use
         * `return_snippet` field. For backwards compatibility, we will return
         * snippet if max_snippet_count &gt; 0.
         * </pre>
         *
         * <code>int32 max_snippet_count = 1 [deprecated = true];</code>
         *
         * @deprecated
         *     google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SnippetSpec.max_snippet_count
         *     is deprecated. See google/cloud/discoveryengine/v1beta/search_service.proto;l=400
         * @param value The maxSnippetCount to set.
         * @return This builder for chaining.
         */
        @java.lang.Deprecated
        public Builder setMaxSnippetCount(int value) {

          maxSnippetCount_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * [DEPRECATED] This field is deprecated. To control snippet return, use
         * `return_snippet` field. For backwards compatibility, we will return
         * snippet if max_snippet_count &gt; 0.
         * </pre>
         *
         * <code>int32 max_snippet_count = 1 [deprecated = true];</code>
         *
         * @deprecated
         *     google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SnippetSpec.max_snippet_count
         *     is deprecated. See google/cloud/discoveryengine/v1beta/search_service.proto;l=400
         * @return This builder for chaining.
         */
        @java.lang.Deprecated
        public Builder clearMaxSnippetCount() {
          bitField0_ = (bitField0_ & ~0x00000001);
          maxSnippetCount_ = 0;
          onChanged();
          return this;
        }

        private boolean referenceOnly_;
        /**
         *
         *
         * <pre>
         * [DEPRECATED] This field is deprecated and will have no affect on the
         * snippet.
         * </pre>
         *
         * <code>bool reference_only = 2 [deprecated = true];</code>
         *
         * @deprecated
         *     google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SnippetSpec.reference_only
         *     is deprecated. See google/cloud/discoveryengine/v1beta/search_service.proto;l=404
         * @return The referenceOnly.
         */
        @java.lang.Override
        @java.lang.Deprecated
        public boolean getReferenceOnly() {
          return referenceOnly_;
        }
        /**
         *
         *
         * <pre>
         * [DEPRECATED] This field is deprecated and will have no affect on the
         * snippet.
         * </pre>
         *
         * <code>bool reference_only = 2 [deprecated = true];</code>
         *
         * @deprecated
         *     google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SnippetSpec.reference_only
         *     is deprecated. See google/cloud/discoveryengine/v1beta/search_service.proto;l=404
         * @param value The referenceOnly to set.
         * @return This builder for chaining.
         */
        @java.lang.Deprecated
        public Builder setReferenceOnly(boolean value) {

          referenceOnly_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * [DEPRECATED] This field is deprecated and will have no affect on the
         * snippet.
         * </pre>
         *
         * <code>bool reference_only = 2 [deprecated = true];</code>
         *
         * @deprecated
         *     google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SnippetSpec.reference_only
         *     is deprecated. See google/cloud/discoveryengine/v1beta/search_service.proto;l=404
         * @return This builder for chaining.
         */
        @java.lang.Deprecated
        public Builder clearReferenceOnly() {
          bitField0_ = (bitField0_ & ~0x00000002);
          referenceOnly_ = false;
          onChanged();
          return this;
        }

        private boolean returnSnippet_;
        /**
         *
         *
         * <pre>
         * If `true`, then return snippet. If no snippet can be generated, we
         * return "No snippet is available for this page." A `snippet_status` with
         * `SUCCESS` or `NO_SNIPPET_AVAILABLE` will also be returned.
         * </pre>
         *
         * <code>bool return_snippet = 3;</code>
         *
         * @return The returnSnippet.
         */
        @java.lang.Override
        public boolean getReturnSnippet() {
          return returnSnippet_;
        }
        /**
         *
         *
         * <pre>
         * If `true`, then return snippet. If no snippet can be generated, we
         * return "No snippet is available for this page." A `snippet_status` with
         * `SUCCESS` or `NO_SNIPPET_AVAILABLE` will also be returned.
         * </pre>
         *
         * <code>bool return_snippet = 3;</code>
         *
         * @param value The returnSnippet to set.
         * @return This builder for chaining.
         */
        public Builder setReturnSnippet(boolean value) {

          returnSnippet_ = value;
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * If `true`, then return snippet. If no snippet can be generated, we
         * return "No snippet is available for this page." A `snippet_status` with
         * `SUCCESS` or `NO_SNIPPET_AVAILABLE` will also be returned.
         * </pre>
         *
         * <code>bool return_snippet = 3;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearReturnSnippet() {
          bitField0_ = (bitField0_ & ~0x00000004);
          returnSnippet_ = false;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SnippetSpec)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SnippetSpec)
      private static final com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
              .SnippetSpec
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                .SnippetSpec();
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
              .SnippetSpec
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<SnippetSpec> PARSER =
          new com.google.protobuf.AbstractParser<SnippetSpec>() {
            @java.lang.Override
            public SnippetSpec parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<SnippetSpec> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<SnippetSpec> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SnippetSpec
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface SummarySpecOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * The number of top results to generate the summary from. If the number
       * of results returned is less than `summaryResultCount`, the summary is
       * generated from all of the results.
       *
       * At most 10 results can be used to generate a summary.
       * </pre>
       *
       * <code>int32 summary_result_count = 1;</code>
       *
       * @return The summaryResultCount.
       */
      int getSummaryResultCount();

      /**
       *
       *
       * <pre>
       * Specifies whether to include citations in the summary. The default
       * value is `false`.
       *
       * When this field is set to `true`, summaries include in-line citation
       * numbers.
       *
       * Example summary including citations:
       *
       * BigQuery is Google Cloud's fully managed and completely serverless
       * enterprise data warehouse [1]. BigQuery supports all data types, works
       * across clouds, and has built-in machine learning and business
       * intelligence, all within a unified platform [2, 3].
       *
       * The citation numbers refer to the returned search results and are
       * 1-indexed. For example, [1] means that the sentence is attributed to
       * the first search result. [2, 3] means that the sentence is attributed
       * to both the second and third search results.
       * </pre>
       *
       * <code>bool include_citations = 2;</code>
       *
       * @return The includeCitations.
       */
      boolean getIncludeCitations();

      /**
       *
       *
       * <pre>
       * Specifies whether to filter out adversarial queries. The default value
       * is `false`.
       *
       * Google employs search-query classification to detect adversarial
       * queries. No summary is returned if the search query is classified as an
       * adversarial query. For example, a user might ask a question regarding
       * negative comments about the company or submit a query designed to
       * generate unsafe, policy-violating output. If this field is set to
       * `true`, we skip generating summaries for adversarial queries and return
       * fallback messages instead.
       * </pre>
       *
       * <code>bool ignore_adversarial_query = 3;</code>
       *
       * @return The ignoreAdversarialQuery.
       */
      boolean getIgnoreAdversarialQuery();

      /**
       *
       *
       * <pre>
       * Specifies whether to filter out queries that are not summary-seeking.
       * The default value is `false`.
       *
       * Google employs search-query classification to detect summary-seeking
       * queries. No summary is returned if the search query is classified as a
       * non-summary seeking query. For example, `why is the sky blue` and `Who
       * is the best soccer player in the world?` are summary-seeking queries,
       * but `SFO airport` and `world cup 2026` are not. They are most likely
       * navigational queries. If this field is set to `true`, we skip
       * generating summaries for non-summary seeking queries and return
       * fallback messages instead.
       * </pre>
       *
       * <code>bool ignore_non_summary_seeking_query = 4;</code>
       *
       * @return The ignoreNonSummarySeekingQuery.
       */
      boolean getIgnoreNonSummarySeekingQuery();

      /**
       *
       *
       * <pre>
       * If specified, the spec will be used to modify the prompt provided to
       * the LLM.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec.ModelPromptSpec model_prompt_spec = 5;
       * </code>
       *
       * @return Whether the modelPromptSpec field is set.
       */
      boolean hasModelPromptSpec();
      /**
       *
       *
       * <pre>
       * If specified, the spec will be used to modify the prompt provided to
       * the LLM.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec.ModelPromptSpec model_prompt_spec = 5;
       * </code>
       *
       * @return The modelPromptSpec.
       */
      com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec
              .ModelPromptSpec
          getModelPromptSpec();
      /**
       *
       *
       * <pre>
       * If specified, the spec will be used to modify the prompt provided to
       * the LLM.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec.ModelPromptSpec model_prompt_spec = 5;
       * </code>
       */
      com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec
              .ModelPromptSpecOrBuilder
          getModelPromptSpecOrBuilder();

      /**
       *
       *
       * <pre>
       * Language code for Summary. Use language tags defined by
       * [BCP47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt).
       * Note: This is an experimental feature.
       * </pre>
       *
       * <code>string language_code = 6;</code>
       *
       * @return The languageCode.
       */
      java.lang.String getLanguageCode();
      /**
       *
       *
       * <pre>
       * Language code for Summary. Use language tags defined by
       * [BCP47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt).
       * Note: This is an experimental feature.
       * </pre>
       *
       * <code>string language_code = 6;</code>
       *
       * @return The bytes for languageCode.
       */
      com.google.protobuf.ByteString getLanguageCodeBytes();

      /**
       *
       *
       * <pre>
       * If specified, the spec will be used to modify the model specification
       * provided to the LLM.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec.ModelSpec model_spec = 7;
       * </code>
       *
       * @return Whether the modelSpec field is set.
       */
      boolean hasModelSpec();
      /**
       *
       *
       * <pre>
       * If specified, the spec will be used to modify the model specification
       * provided to the LLM.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec.ModelSpec model_spec = 7;
       * </code>
       *
       * @return The modelSpec.
       */
      com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec.ModelSpec
          getModelSpec();
      /**
       *
       *
       * <pre>
       * If specified, the spec will be used to modify the model specification
       * provided to the LLM.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec.ModelSpec model_spec = 7;
       * </code>
       */
      com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec
              .ModelSpecOrBuilder
          getModelSpecOrBuilder();

      /**
       *
       *
       * <pre>
       * If true, answer will be generated from most relevant chunks from top
       * search results. This feature will improve summary quality.
       * Note that with this feature enabled, not all top search results
       * will be referenced and included in the reference list, so the citation
       * source index only points to the search results listed in the reference
       * list.
       * </pre>
       *
       * <code>bool use_semantic_chunks = 8;</code>
       *
       * @return The useSemanticChunks.
       */
      boolean getUseSemanticChunks();
    }
    /**
     *
     *
     * <pre>
     * A specification for configuring a summary returned in a search
     * response.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec}
     */
    public static final class SummarySpec extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec)
        SummarySpecOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use SummarySpec.newBuilder() to construct.
      private SummarySpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private SummarySpec() {
        languageCode_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new SummarySpec();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_SearchRequest_ContentSearchSpec_SummarySpec_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_SearchRequest_ContentSearchSpec_SummarySpec_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec
                    .class,
                com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec
                    .Builder.class);
      }

      public interface ModelPromptSpecOrBuilder
          extends
          // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec.ModelPromptSpec)
          com.google.protobuf.MessageOrBuilder {

        /**
         *
         *
         * <pre>
         * Text at the beginning of the prompt that instructs the assistant.
         * Examples are available in the user guide.
         * </pre>
         *
         * <code>string preamble = 1;</code>
         *
         * @return The preamble.
         */
        java.lang.String getPreamble();
        /**
         *
         *
         * <pre>
         * Text at the beginning of the prompt that instructs the assistant.
         * Examples are available in the user guide.
         * </pre>
         *
         * <code>string preamble = 1;</code>
         *
         * @return The bytes for preamble.
         */
        com.google.protobuf.ByteString getPreambleBytes();
      }
      /**
       *
       *
       * <pre>
       * Specification of the prompt to use with the model.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec.ModelPromptSpec}
       */
      public static final class ModelPromptSpec extends com.google.protobuf.GeneratedMessageV3
          implements
          // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec.ModelPromptSpec)
          ModelPromptSpecOrBuilder {
        private static final long serialVersionUID = 0L;
        // Use ModelPromptSpec.newBuilder() to construct.
        private ModelPromptSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
          super(builder);
        }

        private ModelPromptSpec() {
          preamble_ = "";
        }

        @java.lang.Override
        @SuppressWarnings({"unused"})
        protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
          return new ModelPromptSpec();
        }

        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
              .internal_static_google_cloud_discoveryengine_v1beta_SearchRequest_ContentSearchSpec_SummarySpec_ModelPromptSpec_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
              .internal_static_google_cloud_discoveryengine_v1beta_SearchRequest_ContentSearchSpec_SummarySpec_ModelPromptSpec_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                      .SummarySpec.ModelPromptSpec.class,
                  com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                      .SummarySpec.ModelPromptSpec.Builder.class);
        }

        public static final int PREAMBLE_FIELD_NUMBER = 1;

        @SuppressWarnings("serial")
        private volatile java.lang.Object preamble_ = "";
        /**
         *
         *
         * <pre>
         * Text at the beginning of the prompt that instructs the assistant.
         * Examples are available in the user guide.
         * </pre>
         *
         * <code>string preamble = 1;</code>
         *
         * @return The preamble.
         */
        @java.lang.Override
        public java.lang.String getPreamble() {
          java.lang.Object ref = preamble_;
          if (ref instanceof java.lang.String) {
            return (java.lang.String) ref;
          } else {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            preamble_ = s;
            return s;
          }
        }
        /**
         *
         *
         * <pre>
         * Text at the beginning of the prompt that instructs the assistant.
         * Examples are available in the user guide.
         * </pre>
         *
         * <code>string preamble = 1;</code>
         *
         * @return The bytes for preamble.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString getPreambleBytes() {
          java.lang.Object ref = preamble_;
          if (ref instanceof java.lang.String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            preamble_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        private byte memoizedIsInitialized = -1;

        @java.lang.Override
        public final boolean isInitialized() {
          byte isInitialized = memoizedIsInitialized;
          if (isInitialized == 1) return true;
          if (isInitialized == 0) return false;

          memoizedIsInitialized = 1;
          return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
            throws java.io.IOException {
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(preamble_)) {
            com.google.protobuf.GeneratedMessageV3.writeString(output, 1, preamble_);
          }
          getUnknownFields().writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
          int size = memoizedSize;
          if (size != -1) return size;

          size = 0;
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(preamble_)) {
            size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, preamble_);
          }
          size += getUnknownFields().getSerializedSize();
          memoizedSize = size;
          return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
          if (obj == this) {
            return true;
          }
          if (!(obj
              instanceof
              com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec
                  .ModelPromptSpec)) {
            return super.equals(obj);
          }
          com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec
                  .ModelPromptSpec
              other =
                  (com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                          .SummarySpec.ModelPromptSpec)
                      obj;

          if (!getPreamble().equals(other.getPreamble())) return false;
          if (!getUnknownFields().equals(other.getUnknownFields())) return false;
          return true;
        }

        @java.lang.Override
        public int hashCode() {
          if (memoizedHashCode != 0) {
            return memoizedHashCode;
          }
          int hash = 41;
          hash = (19 * hash) + getDescriptor().hashCode();
          hash = (37 * hash) + PREAMBLE_FIELD_NUMBER;
          hash = (53 * hash) + getPreamble().hashCode();
          hash = (29 * hash) + getUnknownFields().hashCode();
          memoizedHashCode = hash;
          return hash;
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                .SummarySpec.ModelPromptSpec
            parseFrom(java.nio.ByteBuffer data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                .SummarySpec.ModelPromptSpec
            parseFrom(
                java.nio.ByteBuffer data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                .SummarySpec.ModelPromptSpec
            parseFrom(com.google.protobuf.ByteString data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                .SummarySpec.ModelPromptSpec
            parseFrom(
                com.google.protobuf.ByteString data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                .SummarySpec.ModelPromptSpec
            parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                .SummarySpec.ModelPromptSpec
            parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                .SummarySpec.ModelPromptSpec
            parseFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                .SummarySpec.ModelPromptSpec
            parseFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                .SummarySpec.ModelPromptSpec
            parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input);
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                .SummarySpec.ModelPromptSpec
            parseDelimitedFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                .SummarySpec.ModelPromptSpec
            parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                .SummarySpec.ModelPromptSpec
            parseFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() {
          return newBuilder();
        }

        public static Builder newBuilder() {
          return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(
            com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec
                    .ModelPromptSpec
                prototype) {
          return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @java.lang.Override
        public Builder toBuilder() {
          return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          Builder builder = new Builder(parent);
          return builder;
        }
        /**
         *
         *
         * <pre>
         * Specification of the prompt to use with the model.
         * </pre>
         *
         * Protobuf type {@code
         * google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec.ModelPromptSpec}
         */
        public static final class Builder
            extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
            implements
            // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec.ModelPromptSpec)
            com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec
                .ModelPromptSpecOrBuilder {
          public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
            return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
                .internal_static_google_cloud_discoveryengine_v1beta_SearchRequest_ContentSearchSpec_SummarySpec_ModelPromptSpec_descriptor;
          }

          @java.lang.Override
          protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
              internalGetFieldAccessorTable() {
            return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
                .internal_static_google_cloud_discoveryengine_v1beta_SearchRequest_ContentSearchSpec_SummarySpec_ModelPromptSpec_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                        .SummarySpec.ModelPromptSpec.class,
                    com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                        .SummarySpec.ModelPromptSpec.Builder.class);
          }

          // Construct using
          // com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec.ModelPromptSpec.newBuilder()
          private Builder() {}

          private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            super(parent);
          }

          @java.lang.Override
          public Builder clear() {
            super.clear();
            bitField0_ = 0;
            preamble_ = "";
            return this;
          }

          @java.lang.Override
          public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
            return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
                .internal_static_google_cloud_discoveryengine_v1beta_SearchRequest_ContentSearchSpec_SummarySpec_ModelPromptSpec_descriptor;
          }

          @java.lang.Override
          public com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec
                  .ModelPromptSpec
              getDefaultInstanceForType() {
            return com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                .SummarySpec.ModelPromptSpec.getDefaultInstance();
          }

          @java.lang.Override
          public com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec
                  .ModelPromptSpec
              build() {
            com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec
                    .ModelPromptSpec
                result = buildPartial();
            if (!result.isInitialized()) {
              throw newUninitializedMessageException(result);
            }
            return result;
          }

          @java.lang.Override
          public com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec
                  .ModelPromptSpec
              buildPartial() {
            com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec
                    .ModelPromptSpec
                result =
                    new com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                        .SummarySpec.ModelPromptSpec(this);
            if (bitField0_ != 0) {
              buildPartial0(result);
            }
            onBuilt();
            return result;
          }

          private void buildPartial0(
              com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec
                      .ModelPromptSpec
                  result) {
            int from_bitField0_ = bitField0_;
            if (((from_bitField0_ & 0x00000001) != 0)) {
              result.preamble_ = preamble_;
            }
          }

          @java.lang.Override
          public Builder clone() {
            return super.clone();
          }

          @java.lang.Override
          public Builder setField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.setField(field, value);
          }

          @java.lang.Override
          public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
            return super.clearField(field);
          }

          @java.lang.Override
          public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
            return super.clearOneof(oneof);
          }

          @java.lang.Override
          public Builder setRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field,
              int index,
              java.lang.Object value) {
            return super.setRepeatedField(field, index, value);
          }

          @java.lang.Override
          public Builder addRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.addRepeatedField(field, value);
          }

          @java.lang.Override
          public Builder mergeFrom(com.google.protobuf.Message other) {
            if (other
                instanceof
                com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec
                    .ModelPromptSpec) {
              return mergeFrom(
                  (com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                          .SummarySpec.ModelPromptSpec)
                      other);
            } else {
              super.mergeFrom(other);
              return this;
            }
          }

          public Builder mergeFrom(
              com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec
                      .ModelPromptSpec
                  other) {
            if (other
                == com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                    .SummarySpec.ModelPromptSpec.getDefaultInstance()) return this;
            if (!other.getPreamble().isEmpty()) {
              preamble_ = other.preamble_;
              bitField0_ |= 0x00000001;
              onChanged();
            }
            this.mergeUnknownFields(other.getUnknownFields());
            onChanged();
            return this;
          }

          @java.lang.Override
          public final boolean isInitialized() {
            return true;
          }

          @java.lang.Override
          public Builder mergeFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
            if (extensionRegistry == null) {
              throw new java.lang.NullPointerException();
            }
            try {
              boolean done = false;
              while (!done) {
                int tag = input.readTag();
                switch (tag) {
                  case 0:
                    done = true;
                    break;
                  case 10:
                    {
                      preamble_ = input.readStringRequireUtf8();
                      bitField0_ |= 0x00000001;
                      break;
                    } // case 10
                  default:
                    {
                      if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                        done = true; // was an endgroup tag
                      }
                      break;
                    } // default:
                } // switch (tag)
              } // while (!done)
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.unwrapIOException();
            } finally {
              onChanged();
            } // finally
            return this;
          }

          private int bitField0_;

          private java.lang.Object preamble_ = "";
          /**
           *
           *
           * <pre>
           * Text at the beginning of the prompt that instructs the assistant.
           * Examples are available in the user guide.
           * </pre>
           *
           * <code>string preamble = 1;</code>
           *
           * @return The preamble.
           */
          public java.lang.String getPreamble() {
            java.lang.Object ref = preamble_;
            if (!(ref instanceof java.lang.String)) {
              com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
              java.lang.String s = bs.toStringUtf8();
              preamble_ = s;
              return s;
            } else {
              return (java.lang.String) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * Text at the beginning of the prompt that instructs the assistant.
           * Examples are available in the user guide.
           * </pre>
           *
           * <code>string preamble = 1;</code>
           *
           * @return The bytes for preamble.
           */
          public com.google.protobuf.ByteString getPreambleBytes() {
            java.lang.Object ref = preamble_;
            if (ref instanceof String) {
              com.google.protobuf.ByteString b =
                  com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
              preamble_ = b;
              return b;
            } else {
              return (com.google.protobuf.ByteString) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * Text at the beginning of the prompt that instructs the assistant.
           * Examples are available in the user guide.
           * </pre>
           *
           * <code>string preamble = 1;</code>
           *
           * @param value The preamble to set.
           * @return This builder for chaining.
           */
          public Builder setPreamble(java.lang.String value) {
            if (value == null) {
              throw new NullPointerException();
            }
            preamble_ = value;
            bitField0_ |= 0x00000001;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Text at the beginning of the prompt that instructs the assistant.
           * Examples are available in the user guide.
           * </pre>
           *
           * <code>string preamble = 1;</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearPreamble() {
            preamble_ = getDefaultInstance().getPreamble();
            bitField0_ = (bitField0_ & ~0x00000001);
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Text at the beginning of the prompt that instructs the assistant.
           * Examples are available in the user guide.
           * </pre>
           *
           * <code>string preamble = 1;</code>
           *
           * @param value The bytes for preamble to set.
           * @return This builder for chaining.
           */
          public Builder setPreambleBytes(com.google.protobuf.ByteString value) {
            if (value == null) {
              throw new NullPointerException();
            }
            checkByteStringIsUtf8(value);
            preamble_ = value;
            bitField0_ |= 0x00000001;
            onChanged();
            return this;
          }

          @java.lang.Override
          public final Builder setUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.setUnknownFields(unknownFields);
          }

          @java.lang.Override
          public final Builder mergeUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.mergeUnknownFields(unknownFields);
          }

          // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec.ModelPromptSpec)
        }

        // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec.ModelPromptSpec)
        private static final com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                .SummarySpec.ModelPromptSpec
            DEFAULT_INSTANCE;

        static {
          DEFAULT_INSTANCE =
              new com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                  .SummarySpec.ModelPromptSpec();
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                .SummarySpec.ModelPromptSpec
            getDefaultInstance() {
          return DEFAULT_INSTANCE;
        }

        private static final com.google.protobuf.Parser<ModelPromptSpec> PARSER =
            new com.google.protobuf.AbstractParser<ModelPromptSpec>() {
              @java.lang.Override
              public ModelPromptSpec parsePartialFrom(
                  com.google.protobuf.CodedInputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
                Builder builder = newBuilder();
                try {
                  builder.mergeFrom(input, extensionRegistry);
                } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                  throw e.setUnfinishedMessage(builder.buildPartial());
                } catch (com.google.protobuf.UninitializedMessageException e) {
                  throw e.asInvalidProtocolBufferException()
                      .setUnfinishedMessage(builder.buildPartial());
                } catch (java.io.IOException e) {
                  throw new com.google.protobuf.InvalidProtocolBufferException(e)
                      .setUnfinishedMessage(builder.buildPartial());
                }
                return builder.buildPartial();
              }
            };

        public static com.google.protobuf.Parser<ModelPromptSpec> parser() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.protobuf.Parser<ModelPromptSpec> getParserForType() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec
                .ModelPromptSpec
            getDefaultInstanceForType() {
          return DEFAULT_INSTANCE;
        }
      }

      public interface ModelSpecOrBuilder
          extends
          // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec.ModelSpec)
          com.google.protobuf.MessageOrBuilder {

        /**
         *
         *
         * <pre>
         * The model version used to generate the summary.
         *
         * Supported values are:
         *
         * * `stable`: string. Default value when no value is specified. Uses a
         *    generally available, fine-tuned model. For more information, see
         *    [Answer generation model versions and
         *    lifecycle](https://cloud.google.com/generative-ai-app-builder/docs/answer-generation-models).
         * * `preview`: string. (Public preview) Uses a preview model. For more
         *    information, see
         *    [Answer generation model versions and
         *    lifecycle](https://cloud.google.com/generative-ai-app-builder/docs/answer-generation-models).
         * </pre>
         *
         * <code>string version = 1;</code>
         *
         * @return The version.
         */
        java.lang.String getVersion();
        /**
         *
         *
         * <pre>
         * The model version used to generate the summary.
         *
         * Supported values are:
         *
         * * `stable`: string. Default value when no value is specified. Uses a
         *    generally available, fine-tuned model. For more information, see
         *    [Answer generation model versions and
         *    lifecycle](https://cloud.google.com/generative-ai-app-builder/docs/answer-generation-models).
         * * `preview`: string. (Public preview) Uses a preview model. For more
         *    information, see
         *    [Answer generation model versions and
         *    lifecycle](https://cloud.google.com/generative-ai-app-builder/docs/answer-generation-models).
         * </pre>
         *
         * <code>string version = 1;</code>
         *
         * @return The bytes for version.
         */
        com.google.protobuf.ByteString getVersionBytes();
      }
      /**
       *
       *
       * <pre>
       * Specification of the model.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec.ModelSpec}
       */
      public static final class ModelSpec extends com.google.protobuf.GeneratedMessageV3
          implements
          // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec.ModelSpec)
          ModelSpecOrBuilder {
        private static final long serialVersionUID = 0L;
        // Use ModelSpec.newBuilder() to construct.
        private ModelSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
          super(builder);
        }

        private ModelSpec() {
          version_ = "";
        }

        @java.lang.Override
        @SuppressWarnings({"unused"})
        protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
          return new ModelSpec();
        }

        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
              .internal_static_google_cloud_discoveryengine_v1beta_SearchRequest_ContentSearchSpec_SummarySpec_ModelSpec_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
              .internal_static_google_cloud_discoveryengine_v1beta_SearchRequest_ContentSearchSpec_SummarySpec_ModelSpec_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                      .SummarySpec.ModelSpec.class,
                  com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                      .SummarySpec.ModelSpec.Builder.class);
        }

        public static final int VERSION_FIELD_NUMBER = 1;

        @SuppressWarnings("serial")
        private volatile java.lang.Object version_ = "";
        /**
         *
         *
         * <pre>
         * The model version used to generate the summary.
         *
         * Supported values are:
         *
         * * `stable`: string. Default value when no value is specified. Uses a
         *    generally available, fine-tuned model. For more information, see
         *    [Answer generation model versions and
         *    lifecycle](https://cloud.google.com/generative-ai-app-builder/docs/answer-generation-models).
         * * `preview`: string. (Public preview) Uses a preview model. For more
         *    information, see
         *    [Answer generation model versions and
         *    lifecycle](https://cloud.google.com/generative-ai-app-builder/docs/answer-generation-models).
         * </pre>
         *
         * <code>string version = 1;</code>
         *
         * @return The version.
         */
        @java.lang.Override
        public java.lang.String getVersion() {
          java.lang.Object ref = version_;
          if (ref instanceof java.lang.String) {
            return (java.lang.String) ref;
          } else {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            version_ = s;
            return s;
          }
        }
        /**
         *
         *
         * <pre>
         * The model version used to generate the summary.
         *
         * Supported values are:
         *
         * * `stable`: string. Default value when no value is specified. Uses a
         *    generally available, fine-tuned model. For more information, see
         *    [Answer generation model versions and
         *    lifecycle](https://cloud.google.com/generative-ai-app-builder/docs/answer-generation-models).
         * * `preview`: string. (Public preview) Uses a preview model. For more
         *    information, see
         *    [Answer generation model versions and
         *    lifecycle](https://cloud.google.com/generative-ai-app-builder/docs/answer-generation-models).
         * </pre>
         *
         * <code>string version = 1;</code>
         *
         * @return The bytes for version.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString getVersionBytes() {
          java.lang.Object ref = version_;
          if (ref instanceof java.lang.String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            version_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        private byte memoizedIsInitialized = -1;

        @java.lang.Override
        public final boolean isInitialized() {
          byte isInitialized = memoizedIsInitialized;
          if (isInitialized == 1) return true;
          if (isInitialized == 0) return false;

          memoizedIsInitialized = 1;
          return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
            throws java.io.IOException {
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(version_)) {
            com.google.protobuf.GeneratedMessageV3.writeString(output, 1, version_);
          }
          getUnknownFields().writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
          int size = memoizedSize;
          if (size != -1) return size;

          size = 0;
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(version_)) {
            size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, version_);
          }
          size += getUnknownFields().getSerializedSize();
          memoizedSize = size;
          return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
          if (obj == this) {
            return true;
          }
          if (!(obj
              instanceof
              com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec
                  .ModelSpec)) {
            return super.equals(obj);
          }
          com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec
                  .ModelSpec
              other =
                  (com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                          .SummarySpec.ModelSpec)
                      obj;

          if (!getVersion().equals(other.getVersion())) return false;
          if (!getUnknownFields().equals(other.getUnknownFields())) return false;
          return true;
        }

        @java.lang.Override
        public int hashCode() {
          if (memoizedHashCode != 0) {
            return memoizedHashCode;
          }
          int hash = 41;
          hash = (19 * hash) + getDescriptor().hashCode();
          hash = (37 * hash) + VERSION_FIELD_NUMBER;
          hash = (53 * hash) + getVersion().hashCode();
          hash = (29 * hash) + getUnknownFields().hashCode();
          memoizedHashCode = hash;
          return hash;
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                .SummarySpec.ModelSpec
            parseFrom(java.nio.ByteBuffer data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                .SummarySpec.ModelSpec
            parseFrom(
                java.nio.ByteBuffer data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                .SummarySpec.ModelSpec
            parseFrom(com.google.protobuf.ByteString data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                .SummarySpec.ModelSpec
            parseFrom(
                com.google.protobuf.ByteString data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                .SummarySpec.ModelSpec
            parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                .SummarySpec.ModelSpec
            parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                .SummarySpec.ModelSpec
            parseFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                .SummarySpec.ModelSpec
            parseFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                .SummarySpec.ModelSpec
            parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input);
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                .SummarySpec.ModelSpec
            parseDelimitedFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                .SummarySpec.ModelSpec
            parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                .SummarySpec.ModelSpec
            parseFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() {
          return newBuilder();
        }

        public static Builder newBuilder() {
          return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(
            com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec
                    .ModelSpec
                prototype) {
          return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @java.lang.Override
        public Builder toBuilder() {
          return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          Builder builder = new Builder(parent);
          return builder;
        }
        /**
         *
         *
         * <pre>
         * Specification of the model.
         * </pre>
         *
         * Protobuf type {@code
         * google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec.ModelSpec}
         */
        public static final class Builder
            extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
            implements
            // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec.ModelSpec)
            com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec
                .ModelSpecOrBuilder {
          public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
            return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
                .internal_static_google_cloud_discoveryengine_v1beta_SearchRequest_ContentSearchSpec_SummarySpec_ModelSpec_descriptor;
          }

          @java.lang.Override
          protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
              internalGetFieldAccessorTable() {
            return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
                .internal_static_google_cloud_discoveryengine_v1beta_SearchRequest_ContentSearchSpec_SummarySpec_ModelSpec_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                        .SummarySpec.ModelSpec.class,
                    com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                        .SummarySpec.ModelSpec.Builder.class);
          }

          // Construct using
          // com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec.ModelSpec.newBuilder()
          private Builder() {}

          private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            super(parent);
          }

          @java.lang.Override
          public Builder clear() {
            super.clear();
            bitField0_ = 0;
            version_ = "";
            return this;
          }

          @java.lang.Override
          public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
            return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
                .internal_static_google_cloud_discoveryengine_v1beta_SearchRequest_ContentSearchSpec_SummarySpec_ModelSpec_descriptor;
          }

          @java.lang.Override
          public com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec
                  .ModelSpec
              getDefaultInstanceForType() {
            return com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                .SummarySpec.ModelSpec.getDefaultInstance();
          }

          @java.lang.Override
          public com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec
                  .ModelSpec
              build() {
            com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec
                    .ModelSpec
                result = buildPartial();
            if (!result.isInitialized()) {
              throw newUninitializedMessageException(result);
            }
            return result;
          }

          @java.lang.Override
          public com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec
                  .ModelSpec
              buildPartial() {
            com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec
                    .ModelSpec
                result =
                    new com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                        .SummarySpec.ModelSpec(this);
            if (bitField0_ != 0) {
              buildPartial0(result);
            }
            onBuilt();
            return result;
          }

          private void buildPartial0(
              com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec
                      .ModelSpec
                  result) {
            int from_bitField0_ = bitField0_;
            if (((from_bitField0_ & 0x00000001) != 0)) {
              result.version_ = version_;
            }
          }

          @java.lang.Override
          public Builder clone() {
            return super.clone();
          }

          @java.lang.Override
          public Builder setField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.setField(field, value);
          }

          @java.lang.Override
          public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
            return super.clearField(field);
          }

          @java.lang.Override
          public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
            return super.clearOneof(oneof);
          }

          @java.lang.Override
          public Builder setRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field,
              int index,
              java.lang.Object value) {
            return super.setRepeatedField(field, index, value);
          }

          @java.lang.Override
          public Builder addRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.addRepeatedField(field, value);
          }

          @java.lang.Override
          public Builder mergeFrom(com.google.protobuf.Message other) {
            if (other
                instanceof
                com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec
                    .ModelSpec) {
              return mergeFrom(
                  (com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                          .SummarySpec.ModelSpec)
                      other);
            } else {
              super.mergeFrom(other);
              return this;
            }
          }

          public Builder mergeFrom(
              com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec
                      .ModelSpec
                  other) {
            if (other
                == com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                    .SummarySpec.ModelSpec.getDefaultInstance()) return this;
            if (!other.getVersion().isEmpty()) {
              version_ = other.version_;
              bitField0_ |= 0x00000001;
              onChanged();
            }
            this.mergeUnknownFields(other.getUnknownFields());
            onChanged();
            return this;
          }

          @java.lang.Override
          public final boolean isInitialized() {
            return true;
          }

          @java.lang.Override
          public Builder mergeFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
            if (extensionRegistry == null) {
              throw new java.lang.NullPointerException();
            }
            try {
              boolean done = false;
              while (!done) {
                int tag = input.readTag();
                switch (tag) {
                  case 0:
                    done = true;
                    break;
                  case 10:
                    {
                      version_ = input.readStringRequireUtf8();
                      bitField0_ |= 0x00000001;
                      break;
                    } // case 10
                  default:
                    {
                      if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                        done = true; // was an endgroup tag
                      }
                      break;
                    } // default:
                } // switch (tag)
              } // while (!done)
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.unwrapIOException();
            } finally {
              onChanged();
            } // finally
            return this;
          }

          private int bitField0_;

          private java.lang.Object version_ = "";
          /**
           *
           *
           * <pre>
           * The model version used to generate the summary.
           *
           * Supported values are:
           *
           * * `stable`: string. Default value when no value is specified. Uses a
           *    generally available, fine-tuned model. For more information, see
           *    [Answer generation model versions and
           *    lifecycle](https://cloud.google.com/generative-ai-app-builder/docs/answer-generation-models).
           * * `preview`: string. (Public preview) Uses a preview model. For more
           *    information, see
           *    [Answer generation model versions and
           *    lifecycle](https://cloud.google.com/generative-ai-app-builder/docs/answer-generation-models).
           * </pre>
           *
           * <code>string version = 1;</code>
           *
           * @return The version.
           */
          public java.lang.String getVersion() {
            java.lang.Object ref = version_;
            if (!(ref instanceof java.lang.String)) {
              com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
              java.lang.String s = bs.toStringUtf8();
              version_ = s;
              return s;
            } else {
              return (java.lang.String) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * The model version used to generate the summary.
           *
           * Supported values are:
           *
           * * `stable`: string. Default value when no value is specified. Uses a
           *    generally available, fine-tuned model. For more information, see
           *    [Answer generation model versions and
           *    lifecycle](https://cloud.google.com/generative-ai-app-builder/docs/answer-generation-models).
           * * `preview`: string. (Public preview) Uses a preview model. For more
           *    information, see
           *    [Answer generation model versions and
           *    lifecycle](https://cloud.google.com/generative-ai-app-builder/docs/answer-generation-models).
           * </pre>
           *
           * <code>string version = 1;</code>
           *
           * @return The bytes for version.
           */
          public com.google.protobuf.ByteString getVersionBytes() {
            java.lang.Object ref = version_;
            if (ref instanceof String) {
              com.google.protobuf.ByteString b =
                  com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
              version_ = b;
              return b;
            } else {
              return (com.google.protobuf.ByteString) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * The model version used to generate the summary.
           *
           * Supported values are:
           *
           * * `stable`: string. Default value when no value is specified. Uses a
           *    generally available, fine-tuned model. For more information, see
           *    [Answer generation model versions and
           *    lifecycle](https://cloud.google.com/generative-ai-app-builder/docs/answer-generation-models).
           * * `preview`: string. (Public preview) Uses a preview model. For more
           *    information, see
           *    [Answer generation model versions and
           *    lifecycle](https://cloud.google.com/generative-ai-app-builder/docs/answer-generation-models).
           * </pre>
           *
           * <code>string version = 1;</code>
           *
           * @param value The version to set.
           * @return This builder for chaining.
           */
          public Builder setVersion(java.lang.String value) {
            if (value == null) {
              throw new NullPointerException();
            }
            version_ = value;
            bitField0_ |= 0x00000001;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * The model version used to generate the summary.
           *
           * Supported values are:
           *
           * * `stable`: string. Default value when no value is specified. Uses a
           *    generally available, fine-tuned model. For more information, see
           *    [Answer generation model versions and
           *    lifecycle](https://cloud.google.com/generative-ai-app-builder/docs/answer-generation-models).
           * * `preview`: string. (Public preview) Uses a preview model. For more
           *    information, see
           *    [Answer generation model versions and
           *    lifecycle](https://cloud.google.com/generative-ai-app-builder/docs/answer-generation-models).
           * </pre>
           *
           * <code>string version = 1;</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearVersion() {
            version_ = getDefaultInstance().getVersion();
            bitField0_ = (bitField0_ & ~0x00000001);
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * The model version used to generate the summary.
           *
           * Supported values are:
           *
           * * `stable`: string. Default value when no value is specified. Uses a
           *    generally available, fine-tuned model. For more information, see
           *    [Answer generation model versions and
           *    lifecycle](https://cloud.google.com/generative-ai-app-builder/docs/answer-generation-models).
           * * `preview`: string. (Public preview) Uses a preview model. For more
           *    information, see
           *    [Answer generation model versions and
           *    lifecycle](https://cloud.google.com/generative-ai-app-builder/docs/answer-generation-models).
           * </pre>
           *
           * <code>string version = 1;</code>
           *
           * @param value The bytes for version to set.
           * @return This builder for chaining.
           */
          public Builder setVersionBytes(com.google.protobuf.ByteString value) {
            if (value == null) {
              throw new NullPointerException();
            }
            checkByteStringIsUtf8(value);
            version_ = value;
            bitField0_ |= 0x00000001;
            onChanged();
            return this;
          }

          @java.lang.Override
          public final Builder setUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.setUnknownFields(unknownFields);
          }

          @java.lang.Override
          public final Builder mergeUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.mergeUnknownFields(unknownFields);
          }

          // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec.ModelSpec)
        }

        // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec.ModelSpec)
        private static final com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                .SummarySpec.ModelSpec
            DEFAULT_INSTANCE;

        static {
          DEFAULT_INSTANCE =
              new com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                  .SummarySpec.ModelSpec();
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                .SummarySpec.ModelSpec
            getDefaultInstance() {
          return DEFAULT_INSTANCE;
        }

        private static final com.google.protobuf.Parser<ModelSpec> PARSER =
            new com.google.protobuf.AbstractParser<ModelSpec>() {
              @java.lang.Override
              public ModelSpec parsePartialFrom(
                  com.google.protobuf.CodedInputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
                Builder builder = newBuilder();
                try {
                  builder.mergeFrom(input, extensionRegistry);
                } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                  throw e.setUnfinishedMessage(builder.buildPartial());
                } catch (com.google.protobuf.UninitializedMessageException e) {
                  throw e.asInvalidProtocolBufferException()
                      .setUnfinishedMessage(builder.buildPartial());
                } catch (java.io.IOException e) {
                  throw new com.google.protobuf.InvalidProtocolBufferException(e)
                      .setUnfinishedMessage(builder.buildPartial());
                }
                return builder.buildPartial();
              }
            };

        public static com.google.protobuf.Parser<ModelSpec> parser() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.protobuf.Parser<ModelSpec> getParserForType() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec
                .ModelSpec
            getDefaultInstanceForType() {
          return DEFAULT_INSTANCE;
        }
      }

      private int bitField0_;
      public static final int SUMMARY_RESULT_COUNT_FIELD_NUMBER = 1;
      private int summaryResultCount_ = 0;
      /**
       *
       *
       * <pre>
       * The number of top results to generate the summary from. If the number
       * of results returned is less than `summaryResultCount`, the summary is
       * generated from all of the results.
       *
       * At most 10 results can be used to generate a summary.
       * </pre>
       *
       * <code>int32 summary_result_count = 1;</code>
       *
       * @return The summaryResultCount.
       */
      @java.lang.Override
      public int getSummaryResultCount() {
        return summaryResultCount_;
      }

      public static final int INCLUDE_CITATIONS_FIELD_NUMBER = 2;
      private boolean includeCitations_ = false;
      /**
       *
       *
       * <pre>
       * Specifies whether to include citations in the summary. The default
       * value is `false`.
       *
       * When this field is set to `true`, summaries include in-line citation
       * numbers.
       *
       * Example summary including citations:
       *
       * BigQuery is Google Cloud's fully managed and completely serverless
       * enterprise data warehouse [1]. BigQuery supports all data types, works
       * across clouds, and has built-in machine learning and business
       * intelligence, all within a unified platform [2, 3].
       *
       * The citation numbers refer to the returned search results and are
       * 1-indexed. For example, [1] means that the sentence is attributed to
       * the first search result. [2, 3] means that the sentence is attributed
       * to both the second and third search results.
       * </pre>
       *
       * <code>bool include_citations = 2;</code>
       *
       * @return The includeCitations.
       */
      @java.lang.Override
      public boolean getIncludeCitations() {
        return includeCitations_;
      }

      public static final int IGNORE_ADVERSARIAL_QUERY_FIELD_NUMBER = 3;
      private boolean ignoreAdversarialQuery_ = false;
      /**
       *
       *
       * <pre>
       * Specifies whether to filter out adversarial queries. The default value
       * is `false`.
       *
       * Google employs search-query classification to detect adversarial
       * queries. No summary is returned if the search query is classified as an
       * adversarial query. For example, a user might ask a question regarding
       * negative comments about the company or submit a query designed to
       * generate unsafe, policy-violating output. If this field is set to
       * `true`, we skip generating summaries for adversarial queries and return
       * fallback messages instead.
       * </pre>
       *
       * <code>bool ignore_adversarial_query = 3;</code>
       *
       * @return The ignoreAdversarialQuery.
       */
      @java.lang.Override
      public boolean getIgnoreAdversarialQuery() {
        return ignoreAdversarialQuery_;
      }

      public static final int IGNORE_NON_SUMMARY_SEEKING_QUERY_FIELD_NUMBER = 4;
      private boolean ignoreNonSummarySeekingQuery_ = false;
      /**
       *
       *
       * <pre>
       * Specifies whether to filter out queries that are not summary-seeking.
       * The default value is `false`.
       *
       * Google employs search-query classification to detect summary-seeking
       * queries. No summary is returned if the search query is classified as a
       * non-summary seeking query. For example, `why is the sky blue` and `Who
       * is the best soccer player in the world?` are summary-seeking queries,
       * but `SFO airport` and `world cup 2026` are not. They are most likely
       * navigational queries. If this field is set to `true`, we skip
       * generating summaries for non-summary seeking queries and return
       * fallback messages instead.
       * </pre>
       *
       * <code>bool ignore_non_summary_seeking_query = 4;</code>
       *
       * @return The ignoreNonSummarySeekingQuery.
       */
      @java.lang.Override
      public boolean getIgnoreNonSummarySeekingQuery() {
        return ignoreNonSummarySeekingQuery_;
      }

      public static final int MODEL_PROMPT_SPEC_FIELD_NUMBER = 5;
      private com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec
              .ModelPromptSpec
          modelPromptSpec_;
      /**
       *
       *
       * <pre>
       * If specified, the spec will be used to modify the prompt provided to
       * the LLM.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec.ModelPromptSpec model_prompt_spec = 5;
       * </code>
       *
       * @return Whether the modelPromptSpec field is set.
       */
      @java.lang.Override
      public boolean hasModelPromptSpec() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * If specified, the spec will be used to modify the prompt provided to
       * the LLM.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec.ModelPromptSpec model_prompt_spec = 5;
       * </code>
       *
       * @return The modelPromptSpec.
       */
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec
              .ModelPromptSpec
          getModelPromptSpec() {
        return modelPromptSpec_ == null
            ? com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec
                .ModelPromptSpec.getDefaultInstance()
            : modelPromptSpec_;
      }
      /**
       *
       *
       * <pre>
       * If specified, the spec will be used to modify the prompt provided to
       * the LLM.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec.ModelPromptSpec model_prompt_spec = 5;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec
              .ModelPromptSpecOrBuilder
          getModelPromptSpecOrBuilder() {
        return modelPromptSpec_ == null
            ? com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec
                .ModelPromptSpec.getDefaultInstance()
            : modelPromptSpec_;
      }

      public static final int LANGUAGE_CODE_FIELD_NUMBER = 6;

      @SuppressWarnings("serial")
      private volatile java.lang.Object languageCode_ = "";
      /**
       *
       *
       * <pre>
       * Language code for Summary. Use language tags defined by
       * [BCP47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt).
       * Note: This is an experimental feature.
       * </pre>
       *
       * <code>string language_code = 6;</code>
       *
       * @return The languageCode.
       */
      @java.lang.Override
      public java.lang.String getLanguageCode() {
        java.lang.Object ref = languageCode_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          languageCode_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Language code for Summary. Use language tags defined by
       * [BCP47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt).
       * Note: This is an experimental feature.
       * </pre>
       *
       * <code>string language_code = 6;</code>
       *
       * @return The bytes for languageCode.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getLanguageCodeBytes() {
        java.lang.Object ref = languageCode_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          languageCode_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int MODEL_SPEC_FIELD_NUMBER = 7;
      private com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec
              .ModelSpec
          modelSpec_;
      /**
       *
       *
       * <pre>
       * If specified, the spec will be used to modify the model specification
       * provided to the LLM.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec.ModelSpec model_spec = 7;
       * </code>
       *
       * @return Whether the modelSpec field is set.
       */
      @java.lang.Override
      public boolean hasModelSpec() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * If specified, the spec will be used to modify the model specification
       * provided to the LLM.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec.ModelSpec model_spec = 7;
       * </code>
       *
       * @return The modelSpec.
       */
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec
              .ModelSpec
          getModelSpec() {
        return modelSpec_ == null
            ? com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec
                .ModelSpec.getDefaultInstance()
            : modelSpec_;
      }
      /**
       *
       *
       * <pre>
       * If specified, the spec will be used to modify the model specification
       * provided to the LLM.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec.ModelSpec model_spec = 7;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec
              .ModelSpecOrBuilder
          getModelSpecOrBuilder() {
        return modelSpec_ == null
            ? com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec
                .ModelSpec.getDefaultInstance()
            : modelSpec_;
      }

      public static final int USE_SEMANTIC_CHUNKS_FIELD_NUMBER = 8;
      private boolean useSemanticChunks_ = false;
      /**
       *
       *
       * <pre>
       * If true, answer will be generated from most relevant chunks from top
       * search results. This feature will improve summary quality.
       * Note that with this feature enabled, not all top search results
       * will be referenced and included in the reference list, so the citation
       * source index only points to the search results listed in the reference
       * list.
       * </pre>
       *
       * <code>bool use_semantic_chunks = 8;</code>
       *
       * @return The useSemanticChunks.
       */
      @java.lang.Override
      public boolean getUseSemanticChunks() {
        return useSemanticChunks_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (summaryResultCount_ != 0) {
          output.writeInt32(1, summaryResultCount_);
        }
        if (includeCitations_ != false) {
          output.writeBool(2, includeCitations_);
        }
        if (ignoreAdversarialQuery_ != false) {
          output.writeBool(3, ignoreAdversarialQuery_);
        }
        if (ignoreNonSummarySeekingQuery_ != false) {
          output.writeBool(4, ignoreNonSummarySeekingQuery_);
        }
        if (((bitField0_ & 0x00000001) != 0)) {
          output.writeMessage(5, getModelPromptSpec());
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(languageCode_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 6, languageCode_);
        }
        if (((bitField0_ & 0x00000002) != 0)) {
          output.writeMessage(7, getModelSpec());
        }
        if (useSemanticChunks_ != false) {
          output.writeBool(8, useSemanticChunks_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (summaryResultCount_ != 0) {
          size += com.google.protobuf.CodedOutputStream.computeInt32Size(1, summaryResultCount_);
        }
        if (includeCitations_ != false) {
          size += com.google.protobuf.CodedOutputStream.computeBoolSize(2, includeCitations_);
        }
        if (ignoreAdversarialQuery_ != false) {
          size += com.google.protobuf.CodedOutputStream.computeBoolSize(3, ignoreAdversarialQuery_);
        }
        if (ignoreNonSummarySeekingQuery_ != false) {
          size +=
              com.google.protobuf.CodedOutputStream.computeBoolSize(
                  4, ignoreNonSummarySeekingQuery_);
        }
        if (((bitField0_ & 0x00000001) != 0)) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getModelPromptSpec());
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(languageCode_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, languageCode_);
        }
        if (((bitField0_ & 0x00000002) != 0)) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getModelSpec());
        }
        if (useSemanticChunks_ != false) {
          size += com.google.protobuf.CodedOutputStream.computeBoolSize(8, useSemanticChunks_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec)) {
          return super.equals(obj);
        }
        com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec other =
            (com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec)
                obj;

        if (getSummaryResultCount() != other.getSummaryResultCount()) return false;
        if (getIncludeCitations() != other.getIncludeCitations()) return false;
        if (getIgnoreAdversarialQuery() != other.getIgnoreAdversarialQuery()) return false;
        if (getIgnoreNonSummarySeekingQuery() != other.getIgnoreNonSummarySeekingQuery())
          return false;
        if (hasModelPromptSpec() != other.hasModelPromptSpec()) return false;
        if (hasModelPromptSpec()) {
          if (!getModelPromptSpec().equals(other.getModelPromptSpec())) return false;
        }
        if (!getLanguageCode().equals(other.getLanguageCode())) return false;
        if (hasModelSpec() != other.hasModelSpec()) return false;
        if (hasModelSpec()) {
          if (!getModelSpec().equals(other.getModelSpec())) return false;
        }
        if (getUseSemanticChunks() != other.getUseSemanticChunks()) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + SUMMARY_RESULT_COUNT_FIELD_NUMBER;
        hash = (53 * hash) + getSummaryResultCount();
        hash = (37 * hash) + INCLUDE_CITATIONS_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getIncludeCitations());
        hash = (37 * hash) + IGNORE_ADVERSARIAL_QUERY_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getIgnoreAdversarialQuery());
        hash = (37 * hash) + IGNORE_NON_SUMMARY_SEEKING_QUERY_FIELD_NUMBER;
        hash =
            (53 * hash)
                + com.google.protobuf.Internal.hashBoolean(getIgnoreNonSummarySeekingQuery());
        if (hasModelPromptSpec()) {
          hash = (37 * hash) + MODEL_PROMPT_SPEC_FIELD_NUMBER;
          hash = (53 * hash) + getModelPromptSpec().hashCode();
        }
        hash = (37 * hash) + LANGUAGE_CODE_FIELD_NUMBER;
        hash = (53 * hash) + getLanguageCode().hashCode();
        if (hasModelSpec()) {
          hash = (37 * hash) + MODEL_SPEC_FIELD_NUMBER;
          hash = (53 * hash) + getModelSpec().hashCode();
        }
        hash = (37 * hash) + USE_SEMANTIC_CHUNKS_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getUseSemanticChunks());
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
              .SummarySpec
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
              .SummarySpec
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
              .SummarySpec
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
              .SummarySpec
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
              .SummarySpec
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
              .SummarySpec
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
              .SummarySpec
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
              .SummarySpec
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
              .SummarySpec
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
              .SummarySpec
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
              .SummarySpec
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
              .SummarySpec
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * A specification for configuring a summary returned in a search
       * response.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec)
          com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
              .SummarySpecOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
              .internal_static_google_cloud_discoveryengine_v1beta_SearchRequest_ContentSearchSpec_SummarySpec_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
              .internal_static_google_cloud_discoveryengine_v1beta_SearchRequest_ContentSearchSpec_SummarySpec_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                      .SummarySpec.class,
                  com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                      .SummarySpec.Builder.class);
        }

        // Construct using
        // com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
            getModelPromptSpecFieldBuilder();
            getModelSpecFieldBuilder();
          }
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          summaryResultCount_ = 0;
          includeCitations_ = false;
          ignoreAdversarialQuery_ = false;
          ignoreNonSummarySeekingQuery_ = false;
          modelPromptSpec_ = null;
          if (modelPromptSpecBuilder_ != null) {
            modelPromptSpecBuilder_.dispose();
            modelPromptSpecBuilder_ = null;
          }
          languageCode_ = "";
          modelSpec_ = null;
          if (modelSpecBuilder_ != null) {
            modelSpecBuilder_.dispose();
            modelSpecBuilder_ = null;
          }
          useSemanticChunks_ = false;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
              .internal_static_google_cloud_discoveryengine_v1beta_SearchRequest_ContentSearchSpec_SummarySpec_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec
            getDefaultInstanceForType() {
          return com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec
            build() {
          com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec
              result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec
            buildPartial() {
          com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec
              result =
                  new com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                      .SummarySpec(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec
                result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.summaryResultCount_ = summaryResultCount_;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.includeCitations_ = includeCitations_;
          }
          if (((from_bitField0_ & 0x00000004) != 0)) {
            result.ignoreAdversarialQuery_ = ignoreAdversarialQuery_;
          }
          if (((from_bitField0_ & 0x00000008) != 0)) {
            result.ignoreNonSummarySeekingQuery_ = ignoreNonSummarySeekingQuery_;
          }
          int to_bitField0_ = 0;
          if (((from_bitField0_ & 0x00000010) != 0)) {
            result.modelPromptSpec_ =
                modelPromptSpecBuilder_ == null
                    ? modelPromptSpec_
                    : modelPromptSpecBuilder_.build();
            to_bitField0_ |= 0x00000001;
          }
          if (((from_bitField0_ & 0x00000020) != 0)) {
            result.languageCode_ = languageCode_;
          }
          if (((from_bitField0_ & 0x00000040) != 0)) {
            result.modelSpec_ = modelSpecBuilder_ == null ? modelSpec_ : modelSpecBuilder_.build();
            to_bitField0_ |= 0x00000002;
          }
          if (((from_bitField0_ & 0x00000080) != 0)) {
            result.useSemanticChunks_ = useSemanticChunks_;
          }
          result.bitField0_ |= to_bitField0_;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec) {
            return mergeFrom(
                (com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                        .SummarySpec)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec
                other) {
          if (other
              == com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec
                  .getDefaultInstance()) return this;
          if (other.getSummaryResultCount() != 0) {
            setSummaryResultCount(other.getSummaryResultCount());
          }
          if (other.getIncludeCitations() != false) {
            setIncludeCitations(other.getIncludeCitations());
          }
          if (other.getIgnoreAdversarialQuery() != false) {
            setIgnoreAdversarialQuery(other.getIgnoreAdversarialQuery());
          }
          if (other.getIgnoreNonSummarySeekingQuery() != false) {
            setIgnoreNonSummarySeekingQuery(other.getIgnoreNonSummarySeekingQuery());
          }
          if (other.hasModelPromptSpec()) {
            mergeModelPromptSpec(other.getModelPromptSpec());
          }
          if (!other.getLanguageCode().isEmpty()) {
            languageCode_ = other.languageCode_;
            bitField0_ |= 0x00000020;
            onChanged();
          }
          if (other.hasModelSpec()) {
            mergeModelSpec(other.getModelSpec());
          }
          if (other.getUseSemanticChunks() != false) {
            setUseSemanticChunks(other.getUseSemanticChunks());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 8:
                  {
                    summaryResultCount_ = input.readInt32();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 8
                case 16:
                  {
                    includeCitations_ = input.readBool();
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 16
                case 24:
                  {
                    ignoreAdversarialQuery_ = input.readBool();
                    bitField0_ |= 0x00000004;
                    break;
                  } // case 24
                case 32:
                  {
                    ignoreNonSummarySeekingQuery_ = input.readBool();
                    bitField0_ |= 0x00000008;
                    break;
                  } // case 32
                case 42:
                  {
                    input.readMessage(
                        getModelPromptSpecFieldBuilder().getBuilder(), extensionRegistry);
                    bitField0_ |= 0x00000010;
                    break;
                  } // case 42
                case 50:
                  {
                    languageCode_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000020;
                    break;
                  } // case 50
                case 58:
                  {
                    input.readMessage(getModelSpecFieldBuilder().getBuilder(), extensionRegistry);
                    bitField0_ |= 0x00000040;
                    break;
                  } // case 58
                case 64:
                  {
                    useSemanticChunks_ = input.readBool();
                    bitField0_ |= 0x00000080;
                    break;
                  } // case 64
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private int summaryResultCount_;
        /**
         *
         *
         * <pre>
         * The number of top results to generate the summary from. If the number
         * of results returned is less than `summaryResultCount`, the summary is
         * generated from all of the results.
         *
         * At most 10 results can be used to generate a summary.
         * </pre>
         *
         * <code>int32 summary_result_count = 1;</code>
         *
         * @return The summaryResultCount.
         */
        @java.lang.Override
        public int getSummaryResultCount() {
          return summaryResultCount_;
        }
        /**
         *
         *
         * <pre>
         * The number of top results to generate the summary from. If the number
         * of results returned is less than `summaryResultCount`, the summary is
         * generated from all of the results.
         *
         * At most 10 results can be used to generate a summary.
         * </pre>
         *
         * <code>int32 summary_result_count = 1;</code>
         *
         * @param value The summaryResultCount to set.
         * @return This builder for chaining.
         */
        public Builder setSummaryResultCount(int value) {

          summaryResultCount_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The number of top results to generate the summary from. If the number
         * of results returned is less than `summaryResultCount`, the summary is
         * generated from all of the results.
         *
         * At most 10 results can be used to generate a summary.
         * </pre>
         *
         * <code>int32 summary_result_count = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearSummaryResultCount() {
          bitField0_ = (bitField0_ & ~0x00000001);
          summaryResultCount_ = 0;
          onChanged();
          return this;
        }

        private boolean includeCitations_;
        /**
         *
         *
         * <pre>
         * Specifies whether to include citations in the summary. The default
         * value is `false`.
         *
         * When this field is set to `true`, summaries include in-line citation
         * numbers.
         *
         * Example summary including citations:
         *
         * BigQuery is Google Cloud's fully managed and completely serverless
         * enterprise data warehouse [1]. BigQuery supports all data types, works
         * across clouds, and has built-in machine learning and business
         * intelligence, all within a unified platform [2, 3].
         *
         * The citation numbers refer to the returned search results and are
         * 1-indexed. For example, [1] means that the sentence is attributed to
         * the first search result. [2, 3] means that the sentence is attributed
         * to both the second and third search results.
         * </pre>
         *
         * <code>bool include_citations = 2;</code>
         *
         * @return The includeCitations.
         */
        @java.lang.Override
        public boolean getIncludeCitations() {
          return includeCitations_;
        }
        /**
         *
         *
         * <pre>
         * Specifies whether to include citations in the summary. The default
         * value is `false`.
         *
         * When this field is set to `true`, summaries include in-line citation
         * numbers.
         *
         * Example summary including citations:
         *
         * BigQuery is Google Cloud's fully managed and completely serverless
         * enterprise data warehouse [1]. BigQuery supports all data types, works
         * across clouds, and has built-in machine learning and business
         * intelligence, all within a unified platform [2, 3].
         *
         * The citation numbers refer to the returned search results and are
         * 1-indexed. For example, [1] means that the sentence is attributed to
         * the first search result. [2, 3] means that the sentence is attributed
         * to both the second and third search results.
         * </pre>
         *
         * <code>bool include_citations = 2;</code>
         *
         * @param value The includeCitations to set.
         * @return This builder for chaining.
         */
        public Builder setIncludeCitations(boolean value) {

          includeCitations_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Specifies whether to include citations in the summary. The default
         * value is `false`.
         *
         * When this field is set to `true`, summaries include in-line citation
         * numbers.
         *
         * Example summary including citations:
         *
         * BigQuery is Google Cloud's fully managed and completely serverless
         * enterprise data warehouse [1]. BigQuery supports all data types, works
         * across clouds, and has built-in machine learning and business
         * intelligence, all within a unified platform [2, 3].
         *
         * The citation numbers refer to the returned search results and are
         * 1-indexed. For example, [1] means that the sentence is attributed to
         * the first search result. [2, 3] means that the sentence is attributed
         * to both the second and third search results.
         * </pre>
         *
         * <code>bool include_citations = 2;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearIncludeCitations() {
          bitField0_ = (bitField0_ & ~0x00000002);
          includeCitations_ = false;
          onChanged();
          return this;
        }

        private boolean ignoreAdversarialQuery_;
        /**
         *
         *
         * <pre>
         * Specifies whether to filter out adversarial queries. The default value
         * is `false`.
         *
         * Google employs search-query classification to detect adversarial
         * queries. No summary is returned if the search query is classified as an
         * adversarial query. For example, a user might ask a question regarding
         * negative comments about the company or submit a query designed to
         * generate unsafe, policy-violating output. If this field is set to
         * `true`, we skip generating summaries for adversarial queries and return
         * fallback messages instead.
         * </pre>
         *
         * <code>bool ignore_adversarial_query = 3;</code>
         *
         * @return The ignoreAdversarialQuery.
         */
        @java.lang.Override
        public boolean getIgnoreAdversarialQuery() {
          return ignoreAdversarialQuery_;
        }
        /**
         *
         *
         * <pre>
         * Specifies whether to filter out adversarial queries. The default value
         * is `false`.
         *
         * Google employs search-query classification to detect adversarial
         * queries. No summary is returned if the search query is classified as an
         * adversarial query. For example, a user might ask a question regarding
         * negative comments about the company or submit a query designed to
         * generate unsafe, policy-violating output. If this field is set to
         * `true`, we skip generating summaries for adversarial queries and return
         * fallback messages instead.
         * </pre>
         *
         * <code>bool ignore_adversarial_query = 3;</code>
         *
         * @param value The ignoreAdversarialQuery to set.
         * @return This builder for chaining.
         */
        public Builder setIgnoreAdversarialQuery(boolean value) {

          ignoreAdversarialQuery_ = value;
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Specifies whether to filter out adversarial queries. The default value
         * is `false`.
         *
         * Google employs search-query classification to detect adversarial
         * queries. No summary is returned if the search query is classified as an
         * adversarial query. For example, a user might ask a question regarding
         * negative comments about the company or submit a query designed to
         * generate unsafe, policy-violating output. If this field is set to
         * `true`, we skip generating summaries for adversarial queries and return
         * fallback messages instead.
         * </pre>
         *
         * <code>bool ignore_adversarial_query = 3;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearIgnoreAdversarialQuery() {
          bitField0_ = (bitField0_ & ~0x00000004);
          ignoreAdversarialQuery_ = false;
          onChanged();
          return this;
        }

        private boolean ignoreNonSummarySeekingQuery_;
        /**
         *
         *
         * <pre>
         * Specifies whether to filter out queries that are not summary-seeking.
         * The default value is `false`.
         *
         * Google employs search-query classification to detect summary-seeking
         * queries. No summary is returned if the search query is classified as a
         * non-summary seeking query. For example, `why is the sky blue` and `Who
         * is the best soccer player in the world?` are summary-seeking queries,
         * but `SFO airport` and `world cup 2026` are not. They are most likely
         * navigational queries. If this field is set to `true`, we skip
         * generating summaries for non-summary seeking queries and return
         * fallback messages instead.
         * </pre>
         *
         * <code>bool ignore_non_summary_seeking_query = 4;</code>
         *
         * @return The ignoreNonSummarySeekingQuery.
         */
        @java.lang.Override
        public boolean getIgnoreNonSummarySeekingQuery() {
          return ignoreNonSummarySeekingQuery_;
        }
        /**
         *
         *
         * <pre>
         * Specifies whether to filter out queries that are not summary-seeking.
         * The default value is `false`.
         *
         * Google employs search-query classification to detect summary-seeking
         * queries. No summary is returned if the search query is classified as a
         * non-summary seeking query. For example, `why is the sky blue` and `Who
         * is the best soccer player in the world?` are summary-seeking queries,
         * but `SFO airport` and `world cup 2026` are not. They are most likely
         * navigational queries. If this field is set to `true`, we skip
         * generating summaries for non-summary seeking queries and return
         * fallback messages instead.
         * </pre>
         *
         * <code>bool ignore_non_summary_seeking_query = 4;</code>
         *
         * @param value The ignoreNonSummarySeekingQuery to set.
         * @return This builder for chaining.
         */
        public Builder setIgnoreNonSummarySeekingQuery(boolean value) {

          ignoreNonSummarySeekingQuery_ = value;
          bitField0_ |= 0x00000008;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Specifies whether to filter out queries that are not summary-seeking.
         * The default value is `false`.
         *
         * Google employs search-query classification to detect summary-seeking
         * queries. No summary is returned if the search query is classified as a
         * non-summary seeking query. For example, `why is the sky blue` and `Who
         * is the best soccer player in the world?` are summary-seeking queries,
         * but `SFO airport` and `world cup 2026` are not. They are most likely
         * navigational queries. If this field is set to `true`, we skip
         * generating summaries for non-summary seeking queries and return
         * fallback messages instead.
         * </pre>
         *
         * <code>bool ignore_non_summary_seeking_query = 4;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearIgnoreNonSummarySeekingQuery() {
          bitField0_ = (bitField0_ & ~0x00000008);
          ignoreNonSummarySeekingQuery_ = false;
          onChanged();
          return this;
        }

        private com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec
                .ModelPromptSpec
            modelPromptSpec_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec
                    .ModelPromptSpec,
                com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec
                    .ModelPromptSpec.Builder,
                com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec
                    .ModelPromptSpecOrBuilder>
            modelPromptSpecBuilder_;
        /**
         *
         *
         * <pre>
         * If specified, the spec will be used to modify the prompt provided to
         * the LLM.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec.ModelPromptSpec model_prompt_spec = 5;
         * </code>
         *
         * @return Whether the modelPromptSpec field is set.
         */
        public boolean hasModelPromptSpec() {
          return ((bitField0_ & 0x00000010) != 0);
        }
        /**
         *
         *
         * <pre>
         * If specified, the spec will be used to modify the prompt provided to
         * the LLM.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec.ModelPromptSpec model_prompt_spec = 5;
         * </code>
         *
         * @return The modelPromptSpec.
         */
        public com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec
                .ModelPromptSpec
            getModelPromptSpec() {
          if (modelPromptSpecBuilder_ == null) {
            return modelPromptSpec_ == null
                ? com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                    .SummarySpec.ModelPromptSpec.getDefaultInstance()
                : modelPromptSpec_;
          } else {
            return modelPromptSpecBuilder_.getMessage();
          }
        }
        /**
         *
         *
         * <pre>
         * If specified, the spec will be used to modify the prompt provided to
         * the LLM.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec.ModelPromptSpec model_prompt_spec = 5;
         * </code>
         */
        public Builder setModelPromptSpec(
            com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec
                    .ModelPromptSpec
                value) {
          if (modelPromptSpecBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            modelPromptSpec_ = value;
          } else {
            modelPromptSpecBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000010;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * If specified, the spec will be used to modify the prompt provided to
         * the LLM.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec.ModelPromptSpec model_prompt_spec = 5;
         * </code>
         */
        public Builder setModelPromptSpec(
            com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec
                    .ModelPromptSpec.Builder
                builderForValue) {
          if (modelPromptSpecBuilder_ == null) {
            modelPromptSpec_ = builderForValue.build();
          } else {
            modelPromptSpecBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000010;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * If specified, the spec will be used to modify the prompt provided to
         * the LLM.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec.ModelPromptSpec model_prompt_spec = 5;
         * </code>
         */
        public Builder mergeModelPromptSpec(
            com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec
                    .ModelPromptSpec
                value) {
          if (modelPromptSpecBuilder_ == null) {
            if (((bitField0_ & 0x00000010) != 0)
                && modelPromptSpec_ != null
                && modelPromptSpec_
                    != com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                        .SummarySpec.ModelPromptSpec.getDefaultInstance()) {
              getModelPromptSpecBuilder().mergeFrom(value);
            } else {
              modelPromptSpec_ = value;
            }
          } else {
            modelPromptSpecBuilder_.mergeFrom(value);
          }
          if (modelPromptSpec_ != null) {
            bitField0_ |= 0x00000010;
            onChanged();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * If specified, the spec will be used to modify the prompt provided to
         * the LLM.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec.ModelPromptSpec model_prompt_spec = 5;
         * </code>
         */
        public Builder clearModelPromptSpec() {
          bitField0_ = (bitField0_ & ~0x00000010);
          modelPromptSpec_ = null;
          if (modelPromptSpecBuilder_ != null) {
            modelPromptSpecBuilder_.dispose();
            modelPromptSpecBuilder_ = null;
          }
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * If specified, the spec will be used to modify the prompt provided to
         * the LLM.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec.ModelPromptSpec model_prompt_spec = 5;
         * </code>
         */
        public com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec
                .ModelPromptSpec.Builder
            getModelPromptSpecBuilder() {
          bitField0_ |= 0x00000010;
          onChanged();
          return getModelPromptSpecFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * If specified, the spec will be used to modify the prompt provided to
         * the LLM.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec.ModelPromptSpec model_prompt_spec = 5;
         * </code>
         */
        public com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec
                .ModelPromptSpecOrBuilder
            getModelPromptSpecOrBuilder() {
          if (modelPromptSpecBuilder_ != null) {
            return modelPromptSpecBuilder_.getMessageOrBuilder();
          } else {
            return modelPromptSpec_ == null
                ? com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                    .SummarySpec.ModelPromptSpec.getDefaultInstance()
                : modelPromptSpec_;
          }
        }
        /**
         *
         *
         * <pre>
         * If specified, the spec will be used to modify the prompt provided to
         * the LLM.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec.ModelPromptSpec model_prompt_spec = 5;
         * </code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec
                    .ModelPromptSpec,
                com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec
                    .ModelPromptSpec.Builder,
                com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec
                    .ModelPromptSpecOrBuilder>
            getModelPromptSpecFieldBuilder() {
          if (modelPromptSpecBuilder_ == null) {
            modelPromptSpecBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                        .SummarySpec.ModelPromptSpec,
                    com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                        .SummarySpec.ModelPromptSpec.Builder,
                    com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                        .SummarySpec.ModelPromptSpecOrBuilder>(
                    getModelPromptSpec(), getParentForChildren(), isClean());
            modelPromptSpec_ = null;
          }
          return modelPromptSpecBuilder_;
        }

        private java.lang.Object languageCode_ = "";
        /**
         *
         *
         * <pre>
         * Language code for Summary. Use language tags defined by
         * [BCP47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt).
         * Note: This is an experimental feature.
         * </pre>
         *
         * <code>string language_code = 6;</code>
         *
         * @return The languageCode.
         */
        public java.lang.String getLanguageCode() {
          java.lang.Object ref = languageCode_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            languageCode_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Language code for Summary. Use language tags defined by
         * [BCP47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt).
         * Note: This is an experimental feature.
         * </pre>
         *
         * <code>string language_code = 6;</code>
         *
         * @return The bytes for languageCode.
         */
        public com.google.protobuf.ByteString getLanguageCodeBytes() {
          java.lang.Object ref = languageCode_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            languageCode_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Language code for Summary. Use language tags defined by
         * [BCP47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt).
         * Note: This is an experimental feature.
         * </pre>
         *
         * <code>string language_code = 6;</code>
         *
         * @param value The languageCode to set.
         * @return This builder for chaining.
         */
        public Builder setLanguageCode(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          languageCode_ = value;
          bitField0_ |= 0x00000020;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Language code for Summary. Use language tags defined by
         * [BCP47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt).
         * Note: This is an experimental feature.
         * </pre>
         *
         * <code>string language_code = 6;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearLanguageCode() {
          languageCode_ = getDefaultInstance().getLanguageCode();
          bitField0_ = (bitField0_ & ~0x00000020);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Language code for Summary. Use language tags defined by
         * [BCP47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt).
         * Note: This is an experimental feature.
         * </pre>
         *
         * <code>string language_code = 6;</code>
         *
         * @param value The bytes for languageCode to set.
         * @return This builder for chaining.
         */
        public Builder setLanguageCodeBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          languageCode_ = value;
          bitField0_ |= 0x00000020;
          onChanged();
          return this;
        }

        private com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec
                .ModelSpec
            modelSpec_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec
                    .ModelSpec,
                com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec
                    .ModelSpec.Builder,
                com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec
                    .ModelSpecOrBuilder>
            modelSpecBuilder_;
        /**
         *
         *
         * <pre>
         * If specified, the spec will be used to modify the model specification
         * provided to the LLM.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec.ModelSpec model_spec = 7;
         * </code>
         *
         * @return Whether the modelSpec field is set.
         */
        public boolean hasModelSpec() {
          return ((bitField0_ & 0x00000040) != 0);
        }
        /**
         *
         *
         * <pre>
         * If specified, the spec will be used to modify the model specification
         * provided to the LLM.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec.ModelSpec model_spec = 7;
         * </code>
         *
         * @return The modelSpec.
         */
        public com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec
                .ModelSpec
            getModelSpec() {
          if (modelSpecBuilder_ == null) {
            return modelSpec_ == null
                ? com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                    .SummarySpec.ModelSpec.getDefaultInstance()
                : modelSpec_;
          } else {
            return modelSpecBuilder_.getMessage();
          }
        }
        /**
         *
         *
         * <pre>
         * If specified, the spec will be used to modify the model specification
         * provided to the LLM.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec.ModelSpec model_spec = 7;
         * </code>
         */
        public Builder setModelSpec(
            com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec
                    .ModelSpec
                value) {
          if (modelSpecBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            modelSpec_ = value;
          } else {
            modelSpecBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000040;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * If specified, the spec will be used to modify the model specification
         * provided to the LLM.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec.ModelSpec model_spec = 7;
         * </code>
         */
        public Builder setModelSpec(
            com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec
                    .ModelSpec.Builder
                builderForValue) {
          if (modelSpecBuilder_ == null) {
            modelSpec_ = builderForValue.build();
          } else {
            modelSpecBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000040;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * If specified, the spec will be used to modify the model specification
         * provided to the LLM.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec.ModelSpec model_spec = 7;
         * </code>
         */
        public Builder mergeModelSpec(
            com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec
                    .ModelSpec
                value) {
          if (modelSpecBuilder_ == null) {
            if (((bitField0_ & 0x00000040) != 0)
                && modelSpec_ != null
                && modelSpec_
                    != com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                        .SummarySpec.ModelSpec.getDefaultInstance()) {
              getModelSpecBuilder().mergeFrom(value);
            } else {
              modelSpec_ = value;
            }
          } else {
            modelSpecBuilder_.mergeFrom(value);
          }
          if (modelSpec_ != null) {
            bitField0_ |= 0x00000040;
            onChanged();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * If specified, the spec will be used to modify the model specification
         * provided to the LLM.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec.ModelSpec model_spec = 7;
         * </code>
         */
        public Builder clearModelSpec() {
          bitField0_ = (bitField0_ & ~0x00000040);
          modelSpec_ = null;
          if (modelSpecBuilder_ != null) {
            modelSpecBuilder_.dispose();
            modelSpecBuilder_ = null;
          }
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * If specified, the spec will be used to modify the model specification
         * provided to the LLM.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec.ModelSpec model_spec = 7;
         * </code>
         */
        public com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec
                .ModelSpec.Builder
            getModelSpecBuilder() {
          bitField0_ |= 0x00000040;
          onChanged();
          return getModelSpecFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * If specified, the spec will be used to modify the model specification
         * provided to the LLM.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec.ModelSpec model_spec = 7;
         * </code>
         */
        public com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec
                .ModelSpecOrBuilder
            getModelSpecOrBuilder() {
          if (modelSpecBuilder_ != null) {
            return modelSpecBuilder_.getMessageOrBuilder();
          } else {
            return modelSpec_ == null
                ? com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                    .SummarySpec.ModelSpec.getDefaultInstance()
                : modelSpec_;
          }
        }
        /**
         *
         *
         * <pre>
         * If specified, the spec will be used to modify the model specification
         * provided to the LLM.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec.ModelSpec model_spec = 7;
         * </code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec
                    .ModelSpec,
                com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec
                    .ModelSpec.Builder,
                com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec
                    .ModelSpecOrBuilder>
            getModelSpecFieldBuilder() {
          if (modelSpecBuilder_ == null) {
            modelSpecBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                        .SummarySpec.ModelSpec,
                    com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                        .SummarySpec.ModelSpec.Builder,
                    com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                        .SummarySpec.ModelSpecOrBuilder>(
                    getModelSpec(), getParentForChildren(), isClean());
            modelSpec_ = null;
          }
          return modelSpecBuilder_;
        }

        private boolean useSemanticChunks_;
        /**
         *
         *
         * <pre>
         * If true, answer will be generated from most relevant chunks from top
         * search results. This feature will improve summary quality.
         * Note that with this feature enabled, not all top search results
         * will be referenced and included in the reference list, so the citation
         * source index only points to the search results listed in the reference
         * list.
         * </pre>
         *
         * <code>bool use_semantic_chunks = 8;</code>
         *
         * @return The useSemanticChunks.
         */
        @java.lang.Override
        public boolean getUseSemanticChunks() {
          return useSemanticChunks_;
        }
        /**
         *
         *
         * <pre>
         * If true, answer will be generated from most relevant chunks from top
         * search results. This feature will improve summary quality.
         * Note that with this feature enabled, not all top search results
         * will be referenced and included in the reference list, so the citation
         * source index only points to the search results listed in the reference
         * list.
         * </pre>
         *
         * <code>bool use_semantic_chunks = 8;</code>
         *
         * @param value The useSemanticChunks to set.
         * @return This builder for chaining.
         */
        public Builder setUseSemanticChunks(boolean value) {

          useSemanticChunks_ = value;
          bitField0_ |= 0x00000080;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * If true, answer will be generated from most relevant chunks from top
         * search results. This feature will improve summary quality.
         * Note that with this feature enabled, not all top search results
         * will be referenced and included in the reference list, so the citation
         * source index only points to the search results listed in the reference
         * list.
         * </pre>
         *
         * <code>bool use_semantic_chunks = 8;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearUseSemanticChunks() {
          bitField0_ = (bitField0_ & ~0x00000080);
          useSemanticChunks_ = false;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec)
      private static final com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
              .SummarySpec
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                .SummarySpec();
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
              .SummarySpec
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<SummarySpec> PARSER =
          new com.google.protobuf.AbstractParser<SummarySpec>() {
            @java.lang.Override
            public SummarySpec parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<SummarySpec> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<SummarySpec> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface ExtractiveContentSpecOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.ExtractiveContentSpec)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * The maximum number of extractive answers returned in each search
       * result.
       *
       * An extractive answer is a verbatim answer extracted from the original
       * document, which provides a precise and contextually relevant answer to
       * the search query.
       *
       * If the number of matching answers is less than the
       * `max_extractive_answer_count`, return all of the answers. Otherwise,
       * return the `max_extractive_answer_count`.
       *
       * At most five answers are returned for each
       * [SearchResult][google.cloud.discoveryengine.v1beta.SearchResponse.SearchResult].
       * </pre>
       *
       * <code>int32 max_extractive_answer_count = 1;</code>
       *
       * @return The maxExtractiveAnswerCount.
       */
      int getMaxExtractiveAnswerCount();

      /**
       *
       *
       * <pre>
       * The max number of extractive segments returned in each search result.
       * Only applied if the
       * [DataStore][google.cloud.discoveryengine.v1beta.DataStore] is set to
       * [DataStore.ContentConfig.CONTENT_REQUIRED][google.cloud.discoveryengine.v1beta.DataStore.ContentConfig.CONTENT_REQUIRED]
       * or
       * [DataStore.solution_types][google.cloud.discoveryengine.v1beta.DataStore.solution_types]
       * is
       * [SOLUTION_TYPE_CHAT][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_CHAT].
       *
       * An extractive segment is a text segment extracted from the original
       * document that is relevant to the search query, and, in general, more
       * verbose than an extractive answer. The segment could then be used as
       * input for LLMs to generate summaries and answers.
       *
       * If the number of matching segments is less than
       * `max_extractive_segment_count`, return all of the segments. Otherwise,
       * return the `max_extractive_segment_count`.
       * </pre>
       *
       * <code>int32 max_extractive_segment_count = 2;</code>
       *
       * @return The maxExtractiveSegmentCount.
       */
      int getMaxExtractiveSegmentCount();

      /**
       *
       *
       * <pre>
       * Specifies whether to return the confidence score from the extractive
       * segments in each search result. This feature is available only for new
       * or allowlisted data stores. To allowlist your data store,
       * contact your Customer Engineer. The default value is `false`.
       * </pre>
       *
       * <code>bool return_extractive_segment_score = 3;</code>
       *
       * @return The returnExtractiveSegmentScore.
       */
      boolean getReturnExtractiveSegmentScore();

      /**
       *
       *
       * <pre>
       * Specifies whether to also include the adjacent from each selected
       * segments.
       * Return at most `num_previous_segments` segments before each selected
       * segments.
       * </pre>
       *
       * <code>int32 num_previous_segments = 4;</code>
       *
       * @return The numPreviousSegments.
       */
      int getNumPreviousSegments();

      /**
       *
       *
       * <pre>
       * Return at most `num_next_segments` segments after each selected
       * segments.
       * </pre>
       *
       * <code>int32 num_next_segments = 5;</code>
       *
       * @return The numNextSegments.
       */
      int getNumNextSegments();
    }
    /**
     *
     *
     * <pre>
     * A specification for configuring the extractive content in a search
     * response.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.ExtractiveContentSpec}
     */
    public static final class ExtractiveContentSpec extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.ExtractiveContentSpec)
        ExtractiveContentSpecOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use ExtractiveContentSpec.newBuilder() to construct.
      private ExtractiveContentSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private ExtractiveContentSpec() {}

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new ExtractiveContentSpec();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_SearchRequest_ContentSearchSpec_ExtractiveContentSpec_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_SearchRequest_ContentSearchSpec_ExtractiveContentSpec_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                    .ExtractiveContentSpec.class,
                com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                    .ExtractiveContentSpec.Builder.class);
      }

      public static final int MAX_EXTRACTIVE_ANSWER_COUNT_FIELD_NUMBER = 1;
      private int maxExtractiveAnswerCount_ = 0;
      /**
       *
       *
       * <pre>
       * The maximum number of extractive answers returned in each search
       * result.
       *
       * An extractive answer is a verbatim answer extracted from the original
       * document, which provides a precise and contextually relevant answer to
       * the search query.
       *
       * If the number of matching answers is less than the
       * `max_extractive_answer_count`, return all of the answers. Otherwise,
       * return the `max_extractive_answer_count`.
       *
       * At most five answers are returned for each
       * [SearchResult][google.cloud.discoveryengine.v1beta.SearchResponse.SearchResult].
       * </pre>
       *
       * <code>int32 max_extractive_answer_count = 1;</code>
       *
       * @return The maxExtractiveAnswerCount.
       */
      @java.lang.Override
      public int getMaxExtractiveAnswerCount() {
        return maxExtractiveAnswerCount_;
      }

      public static final int MAX_EXTRACTIVE_SEGMENT_COUNT_FIELD_NUMBER = 2;
      private int maxExtractiveSegmentCount_ = 0;
      /**
       *
       *
       * <pre>
       * The max number of extractive segments returned in each search result.
       * Only applied if the
       * [DataStore][google.cloud.discoveryengine.v1beta.DataStore] is set to
       * [DataStore.ContentConfig.CONTENT_REQUIRED][google.cloud.discoveryengine.v1beta.DataStore.ContentConfig.CONTENT_REQUIRED]
       * or
       * [DataStore.solution_types][google.cloud.discoveryengine.v1beta.DataStore.solution_types]
       * is
       * [SOLUTION_TYPE_CHAT][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_CHAT].
       *
       * An extractive segment is a text segment extracted from the original
       * document that is relevant to the search query, and, in general, more
       * verbose than an extractive answer. The segment could then be used as
       * input for LLMs to generate summaries and answers.
       *
       * If the number of matching segments is less than
       * `max_extractive_segment_count`, return all of the segments. Otherwise,
       * return the `max_extractive_segment_count`.
       * </pre>
       *
       * <code>int32 max_extractive_segment_count = 2;</code>
       *
       * @return The maxExtractiveSegmentCount.
       */
      @java.lang.Override
      public int getMaxExtractiveSegmentCount() {
        return maxExtractiveSegmentCount_;
      }

      public static final int RETURN_EXTRACTIVE_SEGMENT_SCORE_FIELD_NUMBER = 3;
      private boolean returnExtractiveSegmentScore_ = false;
      /**
       *
       *
       * <pre>
       * Specifies whether to return the confidence score from the extractive
       * segments in each search result. This feature is available only for new
       * or allowlisted data stores. To allowlist your data store,
       * contact your Customer Engineer. The default value is `false`.
       * </pre>
       *
       * <code>bool return_extractive_segment_score = 3;</code>
       *
       * @return The returnExtractiveSegmentScore.
       */
      @java.lang.Override
      public boolean getReturnExtractiveSegmentScore() {
        return returnExtractiveSegmentScore_;
      }

      public static final int NUM_PREVIOUS_SEGMENTS_FIELD_NUMBER = 4;
      private int numPreviousSegments_ = 0;
      /**
       *
       *
       * <pre>
       * Specifies whether to also include the adjacent from each selected
       * segments.
       * Return at most `num_previous_segments` segments before each selected
       * segments.
       * </pre>
       *
       * <code>int32 num_previous_segments = 4;</code>
       *
       * @return The numPreviousSegments.
       */
      @java.lang.Override
      public int getNumPreviousSegments() {
        return numPreviousSegments_;
      }

      public static final int NUM_NEXT_SEGMENTS_FIELD_NUMBER = 5;
      private int numNextSegments_ = 0;
      /**
       *
       *
       * <pre>
       * Return at most `num_next_segments` segments after each selected
       * segments.
       * </pre>
       *
       * <code>int32 num_next_segments = 5;</code>
       *
       * @return The numNextSegments.
       */
      @java.lang.Override
      public int getNumNextSegments() {
        return numNextSegments_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (maxExtractiveAnswerCount_ != 0) {
          output.writeInt32(1, maxExtractiveAnswerCount_);
        }
        if (maxExtractiveSegmentCount_ != 0) {
          output.writeInt32(2, maxExtractiveSegmentCount_);
        }
        if (returnExtractiveSegmentScore_ != false) {
          output.writeBool(3, returnExtractiveSegmentScore_);
        }
        if (numPreviousSegments_ != 0) {
          output.writeInt32(4, numPreviousSegments_);
        }
        if (numNextSegments_ != 0) {
          output.writeInt32(5, numNextSegments_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (maxExtractiveAnswerCount_ != 0) {
          size +=
              com.google.protobuf.CodedOutputStream.computeInt32Size(1, maxExtractiveAnswerCount_);
        }
        if (maxExtractiveSegmentCount_ != 0) {
          size +=
              com.google.protobuf.CodedOutputStream.computeInt32Size(2, maxExtractiveSegmentCount_);
        }
        if (returnExtractiveSegmentScore_ != false) {
          size +=
              com.google.protobuf.CodedOutputStream.computeBoolSize(
                  3, returnExtractiveSegmentScore_);
        }
        if (numPreviousSegments_ != 0) {
          size += com.google.protobuf.CodedOutputStream.computeInt32Size(4, numPreviousSegments_);
        }
        if (numNextSegments_ != 0) {
          size += com.google.protobuf.CodedOutputStream.computeInt32Size(5, numNextSegments_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                .ExtractiveContentSpec)) {
          return super.equals(obj);
        }
        com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                .ExtractiveContentSpec
            other =
                (com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                        .ExtractiveContentSpec)
                    obj;

        if (getMaxExtractiveAnswerCount() != other.getMaxExtractiveAnswerCount()) return false;
        if (getMaxExtractiveSegmentCount() != other.getMaxExtractiveSegmentCount()) return false;
        if (getReturnExtractiveSegmentScore() != other.getReturnExtractiveSegmentScore())
          return false;
        if (getNumPreviousSegments() != other.getNumPreviousSegments()) return false;
        if (getNumNextSegments() != other.getNumNextSegments()) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + MAX_EXTRACTIVE_ANSWER_COUNT_FIELD_NUMBER;
        hash = (53 * hash) + getMaxExtractiveAnswerCount();
        hash = (37 * hash) + MAX_EXTRACTIVE_SEGMENT_COUNT_FIELD_NUMBER;
        hash = (53 * hash) + getMaxExtractiveSegmentCount();
        hash = (37 * hash) + RETURN_EXTRACTIVE_SEGMENT_SCORE_FIELD_NUMBER;
        hash =
            (53 * hash)
                + com.google.protobuf.Internal.hashBoolean(getReturnExtractiveSegmentScore());
        hash = (37 * hash) + NUM_PREVIOUS_SEGMENTS_FIELD_NUMBER;
        hash = (53 * hash) + getNumPreviousSegments();
        hash = (37 * hash) + NUM_NEXT_SEGMENTS_FIELD_NUMBER;
        hash = (53 * hash) + getNumNextSegments();
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
              .ExtractiveContentSpec
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
              .ExtractiveContentSpec
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
              .ExtractiveContentSpec
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
              .ExtractiveContentSpec
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
              .ExtractiveContentSpec
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
              .ExtractiveContentSpec
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
              .ExtractiveContentSpec
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
              .ExtractiveContentSpec
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
              .ExtractiveContentSpec
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
              .ExtractiveContentSpec
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
              .ExtractiveContentSpec
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
              .ExtractiveContentSpec
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                  .ExtractiveContentSpec
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * A specification for configuring the extractive content in a search
       * response.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.ExtractiveContentSpec}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.ExtractiveContentSpec)
          com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
              .ExtractiveContentSpecOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
              .internal_static_google_cloud_discoveryengine_v1beta_SearchRequest_ContentSearchSpec_ExtractiveContentSpec_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
              .internal_static_google_cloud_discoveryengine_v1beta_SearchRequest_ContentSearchSpec_ExtractiveContentSpec_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                      .ExtractiveContentSpec.class,
                  com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                      .ExtractiveContentSpec.Builder.class);
        }

        // Construct using
        // com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.ExtractiveContentSpec.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          maxExtractiveAnswerCount_ = 0;
          maxExtractiveSegmentCount_ = 0;
          returnExtractiveSegmentScore_ = false;
          numPreviousSegments_ = 0;
          numNextSegments_ = 0;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
              .internal_static_google_cloud_discoveryengine_v1beta_SearchRequest_ContentSearchSpec_ExtractiveContentSpec_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                .ExtractiveContentSpec
            getDefaultInstanceForType() {
          return com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
              .ExtractiveContentSpec.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                .ExtractiveContentSpec
            build() {
          com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                  .ExtractiveContentSpec
              result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                .ExtractiveContentSpec
            buildPartial() {
          com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                  .ExtractiveContentSpec
              result =
                  new com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                      .ExtractiveContentSpec(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                    .ExtractiveContentSpec
                result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.maxExtractiveAnswerCount_ = maxExtractiveAnswerCount_;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.maxExtractiveSegmentCount_ = maxExtractiveSegmentCount_;
          }
          if (((from_bitField0_ & 0x00000004) != 0)) {
            result.returnExtractiveSegmentScore_ = returnExtractiveSegmentScore_;
          }
          if (((from_bitField0_ & 0x00000008) != 0)) {
            result.numPreviousSegments_ = numPreviousSegments_;
          }
          if (((from_bitField0_ & 0x00000010) != 0)) {
            result.numNextSegments_ = numNextSegments_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                  .ExtractiveContentSpec) {
            return mergeFrom(
                (com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                        .ExtractiveContentSpec)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                    .ExtractiveContentSpec
                other) {
          if (other
              == com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                  .ExtractiveContentSpec.getDefaultInstance()) return this;
          if (other.getMaxExtractiveAnswerCount() != 0) {
            setMaxExtractiveAnswerCount(other.getMaxExtractiveAnswerCount());
          }
          if (other.getMaxExtractiveSegmentCount() != 0) {
            setMaxExtractiveSegmentCount(other.getMaxExtractiveSegmentCount());
          }
          if (other.getReturnExtractiveSegmentScore() != false) {
            setReturnExtractiveSegmentScore(other.getReturnExtractiveSegmentScore());
          }
          if (other.getNumPreviousSegments() != 0) {
            setNumPreviousSegments(other.getNumPreviousSegments());
          }
          if (other.getNumNextSegments() != 0) {
            setNumNextSegments(other.getNumNextSegments());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 8:
                  {
                    maxExtractiveAnswerCount_ = input.readInt32();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 8
                case 16:
                  {
                    maxExtractiveSegmentCount_ = input.readInt32();
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 16
                case 24:
                  {
                    returnExtractiveSegmentScore_ = input.readBool();
                    bitField0_ |= 0x00000004;
                    break;
                  } // case 24
                case 32:
                  {
                    numPreviousSegments_ = input.readInt32();
                    bitField0_ |= 0x00000008;
                    break;
                  } // case 32
                case 40:
                  {
                    numNextSegments_ = input.readInt32();
                    bitField0_ |= 0x00000010;
                    break;
                  } // case 40
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private int maxExtractiveAnswerCount_;
        /**
         *
         *
         * <pre>
         * The maximum number of extractive answers returned in each search
         * result.
         *
         * An extractive answer is a verbatim answer extracted from the original
         * document, which provides a precise and contextually relevant answer to
         * the search query.
         *
         * If the number of matching answers is less than the
         * `max_extractive_answer_count`, return all of the answers. Otherwise,
         * return the `max_extractive_answer_count`.
         *
         * At most five answers are returned for each
         * [SearchResult][google.cloud.discoveryengine.v1beta.SearchResponse.SearchResult].
         * </pre>
         *
         * <code>int32 max_extractive_answer_count = 1;</code>
         *
         * @return The maxExtractiveAnswerCount.
         */
        @java.lang.Override
        public int getMaxExtractiveAnswerCount() {
          return maxExtractiveAnswerCount_;
        }
        /**
         *
         *
         * <pre>
         * The maximum number of extractive answers returned in each search
         * result.
         *
         * An extractive answer is a verbatim answer extracted from the original
         * document, which provides a precise and contextually relevant answer to
         * the search query.
         *
         * If the number of matching answers is less than the
         * `max_extractive_answer_count`, return all of the answers. Otherwise,
         * return the `max_extractive_answer_count`.
         *
         * At most five answers are returned for each
         * [SearchResult][google.cloud.discoveryengine.v1beta.SearchResponse.SearchResult].
         * </pre>
         *
         * <code>int32 max_extractive_answer_count = 1;</code>
         *
         * @param value The maxExtractiveAnswerCount to set.
         * @return This builder for chaining.
         */
        public Builder setMaxExtractiveAnswerCount(int value) {

          maxExtractiveAnswerCount_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The maximum number of extractive answers returned in each search
         * result.
         *
         * An extractive answer is a verbatim answer extracted from the original
         * document, which provides a precise and contextually relevant answer to
         * the search query.
         *
         * If the number of matching answers is less than the
         * `max_extractive_answer_count`, return all of the answers. Otherwise,
         * return the `max_extractive_answer_count`.
         *
         * At most five answers are returned for each
         * [SearchResult][google.cloud.discoveryengine.v1beta.SearchResponse.SearchResult].
         * </pre>
         *
         * <code>int32 max_extractive_answer_count = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearMaxExtractiveAnswerCount() {
          bitField0_ = (bitField0_ & ~0x00000001);
          maxExtractiveAnswerCount_ = 0;
          onChanged();
          return this;
        }

        private int maxExtractiveSegmentCount_;
        /**
         *
         *
         * <pre>
         * The max number of extractive segments returned in each search result.
         * Only applied if the
         * [DataStore][google.cloud.discoveryengine.v1beta.DataStore] is set to
         * [DataStore.ContentConfig.CONTENT_REQUIRED][google.cloud.discoveryengine.v1beta.DataStore.ContentConfig.CONTENT_REQUIRED]
         * or
         * [DataStore.solution_types][google.cloud.discoveryengine.v1beta.DataStore.solution_types]
         * is
         * [SOLUTION_TYPE_CHAT][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_CHAT].
         *
         * An extractive segment is a text segment extracted from the original
         * document that is relevant to the search query, and, in general, more
         * verbose than an extractive answer. The segment could then be used as
         * input for LLMs to generate summaries and answers.
         *
         * If the number of matching segments is less than
         * `max_extractive_segment_count`, return all of the segments. Otherwise,
         * return the `max_extractive_segment_count`.
         * </pre>
         *
         * <code>int32 max_extractive_segment_count = 2;</code>
         *
         * @return The maxExtractiveSegmentCount.
         */
        @java.lang.Override
        public int getMaxExtractiveSegmentCount() {
          return maxExtractiveSegmentCount_;
        }
        /**
         *
         *
         * <pre>
         * The max number of extractive segments returned in each search result.
         * Only applied if the
         * [DataStore][google.cloud.discoveryengine.v1beta.DataStore] is set to
         * [DataStore.ContentConfig.CONTENT_REQUIRED][google.cloud.discoveryengine.v1beta.DataStore.ContentConfig.CONTENT_REQUIRED]
         * or
         * [DataStore.solution_types][google.cloud.discoveryengine.v1beta.DataStore.solution_types]
         * is
         * [SOLUTION_TYPE_CHAT][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_CHAT].
         *
         * An extractive segment is a text segment extracted from the original
         * document that is relevant to the search query, and, in general, more
         * verbose than an extractive answer. The segment could then be used as
         * input for LLMs to generate summaries and answers.
         *
         * If the number of matching segments is less than
         * `max_extractive_segment_count`, return all of the segments. Otherwise,
         * return the `max_extractive_segment_count`.
         * </pre>
         *
         * <code>int32 max_extractive_segment_count = 2;</code>
         *
         * @param value The maxExtractiveSegmentCount to set.
         * @return This builder for chaining.
         */
        public Builder setMaxExtractiveSegmentCount(int value) {

          maxExtractiveSegmentCount_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The max number of extractive segments returned in each search result.
         * Only applied if the
         * [DataStore][google.cloud.discoveryengine.v1beta.DataStore] is set to
         * [DataStore.ContentConfig.CONTENT_REQUIRED][google.cloud.discoveryengine.v1beta.DataStore.ContentConfig.CONTENT_REQUIRED]
         * or
         * [DataStore.solution_types][google.cloud.discoveryengine.v1beta.DataStore.solution_types]
         * is
         * [SOLUTION_TYPE_CHAT][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_CHAT].
         *
         * An extractive segment is a text segment extracted from the original
         * document that is relevant to the search query, and, in general, more
         * verbose than an extractive answer. The segment could then be used as
         * input for LLMs to generate summaries and answers.
         *
         * If the number of matching segments is less than
         * `max_extractive_segment_count`, return all of the segments. Otherwise,
         * return the `max_extractive_segment_count`.
         * </pre>
         *
         * <code>int32 max_extractive_segment_count = 2;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearMaxExtractiveSegmentCount() {
          bitField0_ = (bitField0_ & ~0x00000002);
          maxExtractiveSegmentCount_ = 0;
          onChanged();
          return this;
        }

        private boolean returnExtractiveSegmentScore_;
        /**
         *
         *
         * <pre>
         * Specifies whether to return the confidence score from the extractive
         * segments in each search result. This feature is available only for new
         * or allowlisted data stores. To allowlist your data store,
         * contact your Customer Engineer. The default value is `false`.
         * </pre>
         *
         * <code>bool return_extractive_segment_score = 3;</code>
         *
         * @return The returnExtractiveSegmentScore.
         */
        @java.lang.Override
        public boolean getReturnExtractiveSegmentScore() {
          return returnExtractiveSegmentScore_;
        }
        /**
         *
         *
         * <pre>
         * Specifies whether to return the confidence score from the extractive
         * segments in each search result. This feature is available only for new
         * or allowlisted data stores. To allowlist your data store,
         * contact your Customer Engineer. The default value is `false`.
         * </pre>
         *
         * <code>bool return_extractive_segment_score = 3;</code>
         *
         * @param value The returnExtractiveSegmentScore to set.
         * @return This builder for chaining.
         */
        public Builder setReturnExtractiveSegmentScore(boolean value) {

          returnExtractiveSegmentScore_ = value;
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Specifies whether to return the confidence score from the extractive
         * segments in each search result. This feature is available only for new
         * or allowlisted data stores. To allowlist your data store,
         * contact your Customer Engineer. The default value is `false`.
         * </pre>
         *
         * <code>bool return_extractive_segment_score = 3;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearReturnExtractiveSegmentScore() {
          bitField0_ = (bitField0_ & ~0x00000004);
          returnExtractiveSegmentScore_ = false;
          onChanged();
          return this;
        }

        private int numPreviousSegments_;
        /**
         *
         *
         * <pre>
         * Specifies whether to also include the adjacent from each selected
         * segments.
         * Return at most `num_previous_segments` segments before each selected
         * segments.
         * </pre>
         *
         * <code>int32 num_previous_segments = 4;</code>
         *
         * @return The numPreviousSegments.
         */
        @java.lang.Override
        public int getNumPreviousSegments() {
          return numPreviousSegments_;
        }
        /**
         *
         *
         * <pre>
         * Specifies whether to also include the adjacent from each selected
         * segments.
         * Return at most `num_previous_segments` segments before each selected
         * segments.
         * </pre>
         *
         * <code>int32 num_previous_segments = 4;</code>
         *
         * @param value The numPreviousSegments to set.
         * @return This builder for chaining.
         */
        public Builder setNumPreviousSegments(int value) {

          numPreviousSegments_ = value;
          bitField0_ |= 0x00000008;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Specifies whether to also include the adjacent from each selected
         * segments.
         * Return at most `num_previous_segments` segments before each selected
         * segments.
         * </pre>
         *
         * <code>int32 num_previous_segments = 4;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearNumPreviousSegments() {
          bitField0_ = (bitField0_ & ~0x00000008);
          numPreviousSegments_ = 0;
          onChanged();
          return this;
        }

        private int numNextSegments_;
        /**
         *
         *
         * <pre>
         * Return at most `num_next_segments` segments after each selected
         * segments.
         * </pre>
         *
         * <code>int32 num_next_segments = 5;</code>
         *
         * @return The numNextSegments.
         */
        @java.lang.Override
        public int getNumNextSegments() {
          return numNextSegments_;
        }
        /**
         *
         *
         * <pre>
         * Return at most `num_next_segments` segments after each selected
         * segments.
         * </pre>
         *
         * <code>int32 num_next_segments = 5;</code>
         *
         * @param value The numNextSegments to set.
         * @return This builder for chaining.
         */
        public Builder setNumNextSegments(int value) {

          numNextSegments_ = value;
          bitField0_ |= 0x00000010;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Return at most `num_next_segments` segments after each selected
         * segments.
         * </pre>
         *
         * <code>int32 num_next_segments = 5;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearNumNextSegments() {
          bitField0_ = (bitField0_ & ~0x00000010);
          numNextSegments_ = 0;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.ExtractiveContentSpec)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.ExtractiveContentSpec)
      private static final com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
              .ExtractiveContentSpec
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                .ExtractiveContentSpec();
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
              .ExtractiveContentSpec
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<ExtractiveContentSpec> PARSER =
          new com.google.protobuf.AbstractParser<ExtractiveContentSpec>() {
            @java.lang.Override
            public ExtractiveContentSpec parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<ExtractiveContentSpec> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<ExtractiveContentSpec> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
              .ExtractiveContentSpec
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    private int bitField0_;
    public static final int SNIPPET_SPEC_FIELD_NUMBER = 1;
    private com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SnippetSpec
        snippetSpec_;
    /**
     *
     *
     * <pre>
     * If `snippetSpec` is not specified, snippets are not included in the
     * search response.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SnippetSpec snippet_spec = 1;
     * </code>
     *
     * @return Whether the snippetSpec field is set.
     */
    @java.lang.Override
    public boolean hasSnippetSpec() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * If `snippetSpec` is not specified, snippets are not included in the
     * search response.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SnippetSpec snippet_spec = 1;
     * </code>
     *
     * @return The snippetSpec.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SnippetSpec
        getSnippetSpec() {
      return snippetSpec_ == null
          ? com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SnippetSpec
              .getDefaultInstance()
          : snippetSpec_;
    }
    /**
     *
     *
     * <pre>
     * If `snippetSpec` is not specified, snippets are not included in the
     * search response.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SnippetSpec snippet_spec = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
            .SnippetSpecOrBuilder
        getSnippetSpecOrBuilder() {
      return snippetSpec_ == null
          ? com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SnippetSpec
              .getDefaultInstance()
          : snippetSpec_;
    }

    public static final int SUMMARY_SPEC_FIELD_NUMBER = 2;
    private com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec
        summarySpec_;
    /**
     *
     *
     * <pre>
     * If `summarySpec` is not specified, summaries are not included in the
     * search response.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec summary_spec = 2;
     * </code>
     *
     * @return Whether the summarySpec field is set.
     */
    @java.lang.Override
    public boolean hasSummarySpec() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * If `summarySpec` is not specified, summaries are not included in the
     * search response.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec summary_spec = 2;
     * </code>
     *
     * @return The summarySpec.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec
        getSummarySpec() {
      return summarySpec_ == null
          ? com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec
              .getDefaultInstance()
          : summarySpec_;
    }
    /**
     *
     *
     * <pre>
     * If `summarySpec` is not specified, summaries are not included in the
     * search response.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec summary_spec = 2;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
            .SummarySpecOrBuilder
        getSummarySpecOrBuilder() {
      return summarySpec_ == null
          ? com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec
              .getDefaultInstance()
          : summarySpec_;
    }

    public static final int EXTRACTIVE_CONTENT_SPEC_FIELD_NUMBER = 3;
    private com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
            .ExtractiveContentSpec
        extractiveContentSpec_;
    /**
     *
     *
     * <pre>
     * If there is no extractive_content_spec provided, there will be no
     * extractive answer in the search response.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.ExtractiveContentSpec extractive_content_spec = 3;
     * </code>
     *
     * @return Whether the extractiveContentSpec field is set.
     */
    @java.lang.Override
    public boolean hasExtractiveContentSpec() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * If there is no extractive_content_spec provided, there will be no
     * extractive answer in the search response.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.ExtractiveContentSpec extractive_content_spec = 3;
     * </code>
     *
     * @return The extractiveContentSpec.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
            .ExtractiveContentSpec
        getExtractiveContentSpec() {
      return extractiveContentSpec_ == null
          ? com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
              .ExtractiveContentSpec.getDefaultInstance()
          : extractiveContentSpec_;
    }
    /**
     *
     *
     * <pre>
     * If there is no extractive_content_spec provided, there will be no
     * extractive answer in the search response.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.ExtractiveContentSpec extractive_content_spec = 3;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
            .ExtractiveContentSpecOrBuilder
        getExtractiveContentSpecOrBuilder() {
      return extractiveContentSpec_ == null
          ? com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
              .ExtractiveContentSpec.getDefaultInstance()
          : extractiveContentSpec_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getSnippetSpec());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeMessage(2, getSummarySpec());
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        output.writeMessage(3, getExtractiveContentSpec());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getSnippetSpec());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getSummarySpec());
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(3, getExtractiveContentSpec());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec)) {
        return super.equals(obj);
      }
      com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec other =
          (com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec) obj;

      if (hasSnippetSpec() != other.hasSnippetSpec()) return false;
      if (hasSnippetSpec()) {
        if (!getSnippetSpec().equals(other.getSnippetSpec())) return false;
      }
      if (hasSummarySpec() != other.hasSummarySpec()) return false;
      if (hasSummarySpec()) {
        if (!getSummarySpec().equals(other.getSummarySpec())) return false;
      }
      if (hasExtractiveContentSpec() != other.hasExtractiveContentSpec()) return false;
      if (hasExtractiveContentSpec()) {
        if (!getExtractiveContentSpec().equals(other.getExtractiveContentSpec())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasSnippetSpec()) {
        hash = (37 * hash) + SNIPPET_SPEC_FIELD_NUMBER;
        hash = (53 * hash) + getSnippetSpec().hashCode();
      }
      if (hasSummarySpec()) {
        hash = (37 * hash) + SUMMARY_SPEC_FIELD_NUMBER;
        hash = (53 * hash) + getSummarySpec().hashCode();
      }
      if (hasExtractiveContentSpec()) {
        hash = (37 * hash) + EXTRACTIVE_CONTENT_SPEC_FIELD_NUMBER;
        hash = (53 * hash) + getExtractiveContentSpec().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A specification for configuring the behavior of content search.
     * </pre>
     *
     * Protobuf type {@code google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec)
        com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpecOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_SearchRequest_ContentSearchSpec_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_SearchRequest_ContentSearchSpec_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.class,
                com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getSnippetSpecFieldBuilder();
          getSummarySpecFieldBuilder();
          getExtractiveContentSpecFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        snippetSpec_ = null;
        if (snippetSpecBuilder_ != null) {
          snippetSpecBuilder_.dispose();
          snippetSpecBuilder_ = null;
        }
        summarySpec_ = null;
        if (summarySpecBuilder_ != null) {
          summarySpecBuilder_.dispose();
          summarySpecBuilder_ = null;
        }
        extractiveContentSpec_ = null;
        if (extractiveContentSpecBuilder_ != null) {
          extractiveContentSpecBuilder_.dispose();
          extractiveContentSpecBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_SearchRequest_ContentSearchSpec_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
          getDefaultInstanceForType() {
        return com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec build() {
        com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
          buildPartial() {
        com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec result =
            new com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.snippetSpec_ =
              snippetSpecBuilder_ == null ? snippetSpec_ : snippetSpecBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.summarySpec_ =
              summarySpecBuilder_ == null ? summarySpec_ : summarySpecBuilder_.build();
          to_bitField0_ |= 0x00000002;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.extractiveContentSpec_ =
              extractiveContentSpecBuilder_ == null
                  ? extractiveContentSpec_
                  : extractiveContentSpecBuilder_.build();
          to_bitField0_ |= 0x00000004;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec) {
          return mergeFrom(
              (com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec other) {
        if (other
            == com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                .getDefaultInstance()) return this;
        if (other.hasSnippetSpec()) {
          mergeSnippetSpec(other.getSnippetSpec());
        }
        if (other.hasSummarySpec()) {
          mergeSummarySpec(other.getSummarySpec());
        }
        if (other.hasExtractiveContentSpec()) {
          mergeExtractiveContentSpec(other.getExtractiveContentSpec());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getSnippetSpecFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(getSummarySpecFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  input.readMessage(
                      getExtractiveContentSpecFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SnippetSpec
          snippetSpec_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SnippetSpec,
              com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SnippetSpec
                  .Builder,
              com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                  .SnippetSpecOrBuilder>
          snippetSpecBuilder_;
      /**
       *
       *
       * <pre>
       * If `snippetSpec` is not specified, snippets are not included in the
       * search response.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SnippetSpec snippet_spec = 1;
       * </code>
       *
       * @return Whether the snippetSpec field is set.
       */
      public boolean hasSnippetSpec() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * If `snippetSpec` is not specified, snippets are not included in the
       * search response.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SnippetSpec snippet_spec = 1;
       * </code>
       *
       * @return The snippetSpec.
       */
      public com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SnippetSpec
          getSnippetSpec() {
        if (snippetSpecBuilder_ == null) {
          return snippetSpec_ == null
              ? com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SnippetSpec
                  .getDefaultInstance()
              : snippetSpec_;
        } else {
          return snippetSpecBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * If `snippetSpec` is not specified, snippets are not included in the
       * search response.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SnippetSpec snippet_spec = 1;
       * </code>
       */
      public Builder setSnippetSpec(
          com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SnippetSpec
              value) {
        if (snippetSpecBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          snippetSpec_ = value;
        } else {
          snippetSpecBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * If `snippetSpec` is not specified, snippets are not included in the
       * search response.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SnippetSpec snippet_spec = 1;
       * </code>
       */
      public Builder setSnippetSpec(
          com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SnippetSpec
                  .Builder
              builderForValue) {
        if (snippetSpecBuilder_ == null) {
          snippetSpec_ = builderForValue.build();
        } else {
          snippetSpecBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * If `snippetSpec` is not specified, snippets are not included in the
       * search response.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SnippetSpec snippet_spec = 1;
       * </code>
       */
      public Builder mergeSnippetSpec(
          com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SnippetSpec
              value) {
        if (snippetSpecBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && snippetSpec_ != null
              && snippetSpec_
                  != com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                      .SnippetSpec.getDefaultInstance()) {
            getSnippetSpecBuilder().mergeFrom(value);
          } else {
            snippetSpec_ = value;
          }
        } else {
          snippetSpecBuilder_.mergeFrom(value);
        }
        if (snippetSpec_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * If `snippetSpec` is not specified, snippets are not included in the
       * search response.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SnippetSpec snippet_spec = 1;
       * </code>
       */
      public Builder clearSnippetSpec() {
        bitField0_ = (bitField0_ & ~0x00000001);
        snippetSpec_ = null;
        if (snippetSpecBuilder_ != null) {
          snippetSpecBuilder_.dispose();
          snippetSpecBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * If `snippetSpec` is not specified, snippets are not included in the
       * search response.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SnippetSpec snippet_spec = 1;
       * </code>
       */
      public com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SnippetSpec
              .Builder
          getSnippetSpecBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getSnippetSpecFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * If `snippetSpec` is not specified, snippets are not included in the
       * search response.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SnippetSpec snippet_spec = 1;
       * </code>
       */
      public com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
              .SnippetSpecOrBuilder
          getSnippetSpecOrBuilder() {
        if (snippetSpecBuilder_ != null) {
          return snippetSpecBuilder_.getMessageOrBuilder();
        } else {
          return snippetSpec_ == null
              ? com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SnippetSpec
                  .getDefaultInstance()
              : snippetSpec_;
        }
      }
      /**
       *
       *
       * <pre>
       * If `snippetSpec` is not specified, snippets are not included in the
       * search response.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SnippetSpec snippet_spec = 1;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SnippetSpec,
              com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SnippetSpec
                  .Builder,
              com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                  .SnippetSpecOrBuilder>
          getSnippetSpecFieldBuilder() {
        if (snippetSpecBuilder_ == null) {
          snippetSpecBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                      .SnippetSpec,
                  com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                      .SnippetSpec.Builder,
                  com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                      .SnippetSpecOrBuilder>(getSnippetSpec(), getParentForChildren(), isClean());
          snippetSpec_ = null;
        }
        return snippetSpecBuilder_;
      }

      private com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec
          summarySpec_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec,
              com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec
                  .Builder,
              com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                  .SummarySpecOrBuilder>
          summarySpecBuilder_;
      /**
       *
       *
       * <pre>
       * If `summarySpec` is not specified, summaries are not included in the
       * search response.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec summary_spec = 2;
       * </code>
       *
       * @return Whether the summarySpec field is set.
       */
      public boolean hasSummarySpec() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * If `summarySpec` is not specified, summaries are not included in the
       * search response.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec summary_spec = 2;
       * </code>
       *
       * @return The summarySpec.
       */
      public com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec
          getSummarySpec() {
        if (summarySpecBuilder_ == null) {
          return summarySpec_ == null
              ? com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec
                  .getDefaultInstance()
              : summarySpec_;
        } else {
          return summarySpecBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * If `summarySpec` is not specified, summaries are not included in the
       * search response.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec summary_spec = 2;
       * </code>
       */
      public Builder setSummarySpec(
          com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec
              value) {
        if (summarySpecBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          summarySpec_ = value;
        } else {
          summarySpecBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * If `summarySpec` is not specified, summaries are not included in the
       * search response.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec summary_spec = 2;
       * </code>
       */
      public Builder setSummarySpec(
          com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec
                  .Builder
              builderForValue) {
        if (summarySpecBuilder_ == null) {
          summarySpec_ = builderForValue.build();
        } else {
          summarySpecBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * If `summarySpec` is not specified, summaries are not included in the
       * search response.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec summary_spec = 2;
       * </code>
       */
      public Builder mergeSummarySpec(
          com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec
              value) {
        if (summarySpecBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && summarySpec_ != null
              && summarySpec_
                  != com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                      .SummarySpec.getDefaultInstance()) {
            getSummarySpecBuilder().mergeFrom(value);
          } else {
            summarySpec_ = value;
          }
        } else {
          summarySpecBuilder_.mergeFrom(value);
        }
        if (summarySpec_ != null) {
          bitField0_ |= 0x00000002;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * If `summarySpec` is not specified, summaries are not included in the
       * search response.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec summary_spec = 2;
       * </code>
       */
      public Builder clearSummarySpec() {
        bitField0_ = (bitField0_ & ~0x00000002);
        summarySpec_ = null;
        if (summarySpecBuilder_ != null) {
          summarySpecBuilder_.dispose();
          summarySpecBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * If `summarySpec` is not specified, summaries are not included in the
       * search response.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec summary_spec = 2;
       * </code>
       */
      public com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec
              .Builder
          getSummarySpecBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getSummarySpecFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * If `summarySpec` is not specified, summaries are not included in the
       * search response.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec summary_spec = 2;
       * </code>
       */
      public com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
              .SummarySpecOrBuilder
          getSummarySpecOrBuilder() {
        if (summarySpecBuilder_ != null) {
          return summarySpecBuilder_.getMessageOrBuilder();
        } else {
          return summarySpec_ == null
              ? com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec
                  .getDefaultInstance()
              : summarySpec_;
        }
      }
      /**
       *
       *
       * <pre>
       * If `summarySpec` is not specified, summaries are not included in the
       * search response.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec summary_spec = 2;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec,
              com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec
                  .Builder,
              com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                  .SummarySpecOrBuilder>
          getSummarySpecFieldBuilder() {
        if (summarySpecBuilder_ == null) {
          summarySpecBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                      .SummarySpec,
                  com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                      .SummarySpec.Builder,
                  com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                      .SummarySpecOrBuilder>(getSummarySpec(), getParentForChildren(), isClean());
          summarySpec_ = null;
        }
        return summarySpecBuilder_;
      }

      private com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
              .ExtractiveContentSpec
          extractiveContentSpec_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                  .ExtractiveContentSpec,
              com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                  .ExtractiveContentSpec.Builder,
              com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                  .ExtractiveContentSpecOrBuilder>
          extractiveContentSpecBuilder_;
      /**
       *
       *
       * <pre>
       * If there is no extractive_content_spec provided, there will be no
       * extractive answer in the search response.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.ExtractiveContentSpec extractive_content_spec = 3;
       * </code>
       *
       * @return Whether the extractiveContentSpec field is set.
       */
      public boolean hasExtractiveContentSpec() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       *
       *
       * <pre>
       * If there is no extractive_content_spec provided, there will be no
       * extractive answer in the search response.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.ExtractiveContentSpec extractive_content_spec = 3;
       * </code>
       *
       * @return The extractiveContentSpec.
       */
      public com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
              .ExtractiveContentSpec
          getExtractiveContentSpec() {
        if (extractiveContentSpecBuilder_ == null) {
          return extractiveContentSpec_ == null
              ? com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                  .ExtractiveContentSpec.getDefaultInstance()
              : extractiveContentSpec_;
        } else {
          return extractiveContentSpecBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * If there is no extractive_content_spec provided, there will be no
       * extractive answer in the search response.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.ExtractiveContentSpec extractive_content_spec = 3;
       * </code>
       */
      public Builder setExtractiveContentSpec(
          com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                  .ExtractiveContentSpec
              value) {
        if (extractiveContentSpecBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          extractiveContentSpec_ = value;
        } else {
          extractiveContentSpecBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * If there is no extractive_content_spec provided, there will be no
       * extractive answer in the search response.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.ExtractiveContentSpec extractive_content_spec = 3;
       * </code>
       */
      public Builder setExtractiveContentSpec(
          com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                  .ExtractiveContentSpec.Builder
              builderForValue) {
        if (extractiveContentSpecBuilder_ == null) {
          extractiveContentSpec_ = builderForValue.build();
        } else {
          extractiveContentSpecBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * If there is no extractive_content_spec provided, there will be no
       * extractive answer in the search response.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.ExtractiveContentSpec extractive_content_spec = 3;
       * </code>
       */
      public Builder mergeExtractiveContentSpec(
          com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                  .ExtractiveContentSpec
              value) {
        if (extractiveContentSpecBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)
              && extractiveContentSpec_ != null
              && extractiveContentSpec_
                  != com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                      .ExtractiveContentSpec.getDefaultInstance()) {
            getExtractiveContentSpecBuilder().mergeFrom(value);
          } else {
            extractiveContentSpec_ = value;
          }
        } else {
          extractiveContentSpecBuilder_.mergeFrom(value);
        }
        if (extractiveContentSpec_ != null) {
          bitField0_ |= 0x00000004;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * If there is no extractive_content_spec provided, there will be no
       * extractive answer in the search response.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.ExtractiveContentSpec extractive_content_spec = 3;
       * </code>
       */
      public Builder clearExtractiveContentSpec() {
        bitField0_ = (bitField0_ & ~0x00000004);
        extractiveContentSpec_ = null;
        if (extractiveContentSpecBuilder_ != null) {
          extractiveContentSpecBuilder_.dispose();
          extractiveContentSpecBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * If there is no extractive_content_spec provided, there will be no
       * extractive answer in the search response.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.ExtractiveContentSpec extractive_content_spec = 3;
       * </code>
       */
      public com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
              .ExtractiveContentSpec.Builder
          getExtractiveContentSpecBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getExtractiveContentSpecFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * If there is no extractive_content_spec provided, there will be no
       * extractive answer in the search response.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.ExtractiveContentSpec extractive_content_spec = 3;
       * </code>
       */
      public com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
              .ExtractiveContentSpecOrBuilder
          getExtractiveContentSpecOrBuilder() {
        if (extractiveContentSpecBuilder_ != null) {
          return extractiveContentSpecBuilder_.getMessageOrBuilder();
        } else {
          return extractiveContentSpec_ == null
              ? com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                  .ExtractiveContentSpec.getDefaultInstance()
              : extractiveContentSpec_;
        }
      }
      /**
       *
       *
       * <pre>
       * If there is no extractive_content_spec provided, there will be no
       * extractive answer in the search response.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.ExtractiveContentSpec extractive_content_spec = 3;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                  .ExtractiveContentSpec,
              com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                  .ExtractiveContentSpec.Builder,
              com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                  .ExtractiveContentSpecOrBuilder>
          getExtractiveContentSpecFieldBuilder() {
        if (extractiveContentSpecBuilder_ == null) {
          extractiveContentSpecBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                      .ExtractiveContentSpec,
                  com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                      .ExtractiveContentSpec.Builder,
                  com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                      .ExtractiveContentSpecOrBuilder>(
                  getExtractiveContentSpec(), getParentForChildren(), isClean());
          extractiveContentSpec_ = null;
        }
        return extractiveContentSpecBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec)
    private static final com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec();
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ContentSearchSpec> PARSER =
        new com.google.protobuf.AbstractParser<ContentSearchSpec>() {
          @java.lang.Override
          public ContentSearchSpec parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ContentSearchSpec> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ContentSearchSpec> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface EmbeddingSpecOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The embedding vector used for retrieval. Limit to 1.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.EmbeddingVector embedding_vectors = 1;
     * </code>
     */
    java.util.List<
            com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.EmbeddingVector>
        getEmbeddingVectorsList();
    /**
     *
     *
     * <pre>
     * The embedding vector used for retrieval. Limit to 1.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.EmbeddingVector embedding_vectors = 1;
     * </code>
     */
    com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.EmbeddingVector
        getEmbeddingVectors(int index);
    /**
     *
     *
     * <pre>
     * The embedding vector used for retrieval. Limit to 1.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.EmbeddingVector embedding_vectors = 1;
     * </code>
     */
    int getEmbeddingVectorsCount();
    /**
     *
     *
     * <pre>
     * The embedding vector used for retrieval. Limit to 1.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.EmbeddingVector embedding_vectors = 1;
     * </code>
     */
    java.util.List<
            ? extends
                com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec
                    .EmbeddingVectorOrBuilder>
        getEmbeddingVectorsOrBuilderList();
    /**
     *
     *
     * <pre>
     * The embedding vector used for retrieval. Limit to 1.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.EmbeddingVector embedding_vectors = 1;
     * </code>
     */
    com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.EmbeddingVectorOrBuilder
        getEmbeddingVectorsOrBuilder(int index);
  }
  /**
   *
   *
   * <pre>
   * The specification that uses customized query embedding vector to do
   * semantic document retrieval.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec}
   */
  public static final class EmbeddingSpec extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec)
      EmbeddingSpecOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use EmbeddingSpec.newBuilder() to construct.
    private EmbeddingSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private EmbeddingSpec() {
      embeddingVectors_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new EmbeddingSpec();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
          .internal_static_google_cloud_discoveryengine_v1beta_SearchRequest_EmbeddingSpec_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
          .internal_static_google_cloud_discoveryengine_v1beta_SearchRequest_EmbeddingSpec_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.class,
              com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.Builder.class);
    }

    public interface EmbeddingVectorOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.EmbeddingVector)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Embedding field path in schema.
       * </pre>
       *
       * <code>string field_path = 1;</code>
       *
       * @return The fieldPath.
       */
      java.lang.String getFieldPath();
      /**
       *
       *
       * <pre>
       * Embedding field path in schema.
       * </pre>
       *
       * <code>string field_path = 1;</code>
       *
       * @return The bytes for fieldPath.
       */
      com.google.protobuf.ByteString getFieldPathBytes();

      /**
       *
       *
       * <pre>
       * Query embedding vector.
       * </pre>
       *
       * <code>repeated float vector = 2;</code>
       *
       * @return A list containing the vector.
       */
      java.util.List<java.lang.Float> getVectorList();
      /**
       *
       *
       * <pre>
       * Query embedding vector.
       * </pre>
       *
       * <code>repeated float vector = 2;</code>
       *
       * @return The count of vector.
       */
      int getVectorCount();
      /**
       *
       *
       * <pre>
       * Query embedding vector.
       * </pre>
       *
       * <code>repeated float vector = 2;</code>
       *
       * @param index The index of the element to return.
       * @return The vector at the given index.
       */
      float getVector(int index);
    }
    /**
     *
     *
     * <pre>
     * Embedding vector.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.EmbeddingVector}
     */
    public static final class EmbeddingVector extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.EmbeddingVector)
        EmbeddingVectorOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use EmbeddingVector.newBuilder() to construct.
      private EmbeddingVector(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private EmbeddingVector() {
        fieldPath_ = "";
        vector_ = emptyFloatList();
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new EmbeddingVector();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_SearchRequest_EmbeddingSpec_EmbeddingVector_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_SearchRequest_EmbeddingSpec_EmbeddingVector_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.EmbeddingVector
                    .class,
                com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.EmbeddingVector
                    .Builder.class);
      }

      public static final int FIELD_PATH_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private volatile java.lang.Object fieldPath_ = "";
      /**
       *
       *
       * <pre>
       * Embedding field path in schema.
       * </pre>
       *
       * <code>string field_path = 1;</code>
       *
       * @return The fieldPath.
       */
      @java.lang.Override
      public java.lang.String getFieldPath() {
        java.lang.Object ref = fieldPath_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          fieldPath_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Embedding field path in schema.
       * </pre>
       *
       * <code>string field_path = 1;</code>
       *
       * @return The bytes for fieldPath.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getFieldPathBytes() {
        java.lang.Object ref = fieldPath_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          fieldPath_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int VECTOR_FIELD_NUMBER = 2;

      @SuppressWarnings("serial")
      private com.google.protobuf.Internal.FloatList vector_ = emptyFloatList();
      /**
       *
       *
       * <pre>
       * Query embedding vector.
       * </pre>
       *
       * <code>repeated float vector = 2;</code>
       *
       * @return A list containing the vector.
       */
      @java.lang.Override
      public java.util.List<java.lang.Float> getVectorList() {
        return vector_;
      }
      /**
       *
       *
       * <pre>
       * Query embedding vector.
       * </pre>
       *
       * <code>repeated float vector = 2;</code>
       *
       * @return The count of vector.
       */
      public int getVectorCount() {
        return vector_.size();
      }
      /**
       *
       *
       * <pre>
       * Query embedding vector.
       * </pre>
       *
       * <code>repeated float vector = 2;</code>
       *
       * @param index The index of the element to return.
       * @return The vector at the given index.
       */
      public float getVector(int index) {
        return vector_.getFloat(index);
      }

      private int vectorMemoizedSerializedSize = -1;

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        getSerializedSize();
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(fieldPath_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, fieldPath_);
        }
        if (getVectorList().size() > 0) {
          output.writeUInt32NoTag(18);
          output.writeUInt32NoTag(vectorMemoizedSerializedSize);
        }
        for (int i = 0; i < vector_.size(); i++) {
          output.writeFloatNoTag(vector_.getFloat(i));
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(fieldPath_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, fieldPath_);
        }
        {
          int dataSize = 0;
          dataSize = 4 * getVectorList().size();
          size += dataSize;
          if (!getVectorList().isEmpty()) {
            size += 1;
            size += com.google.protobuf.CodedOutputStream.computeInt32SizeNoTag(dataSize);
          }
          vectorMemoizedSerializedSize = dataSize;
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.EmbeddingVector)) {
          return super.equals(obj);
        }
        com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.EmbeddingVector other =
            (com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.EmbeddingVector)
                obj;

        if (!getFieldPath().equals(other.getFieldPath())) return false;
        if (!getVectorList().equals(other.getVectorList())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + FIELD_PATH_FIELD_NUMBER;
        hash = (53 * hash) + getFieldPath().hashCode();
        if (getVectorCount() > 0) {
          hash = (37 * hash) + VECTOR_FIELD_NUMBER;
          hash = (53 * hash) + getVectorList().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec
              .EmbeddingVector
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec
              .EmbeddingVector
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec
              .EmbeddingVector
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec
              .EmbeddingVector
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec
              .EmbeddingVector
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec
              .EmbeddingVector
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec
              .EmbeddingVector
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec
              .EmbeddingVector
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec
              .EmbeddingVector
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec
              .EmbeddingVector
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec
              .EmbeddingVector
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec
              .EmbeddingVector
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.EmbeddingVector
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Embedding vector.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.EmbeddingVector}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.EmbeddingVector)
          com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec
              .EmbeddingVectorOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
              .internal_static_google_cloud_discoveryengine_v1beta_SearchRequest_EmbeddingSpec_EmbeddingVector_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
              .internal_static_google_cloud_discoveryengine_v1beta_SearchRequest_EmbeddingSpec_EmbeddingVector_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec
                      .EmbeddingVector.class,
                  com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec
                      .EmbeddingVector.Builder.class);
        }

        // Construct using
        // com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.EmbeddingVector.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          fieldPath_ = "";
          vector_ = emptyFloatList();
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
              .internal_static_google_cloud_discoveryengine_v1beta_SearchRequest_EmbeddingSpec_EmbeddingVector_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.EmbeddingVector
            getDefaultInstanceForType() {
          return com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.EmbeddingVector
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.EmbeddingVector
            build() {
          com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.EmbeddingVector
              result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.EmbeddingVector
            buildPartial() {
          com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.EmbeddingVector
              result =
                  new com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec
                      .EmbeddingVector(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.EmbeddingVector
                result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.fieldPath_ = fieldPath_;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            vector_.makeImmutable();
            result.vector_ = vector_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.EmbeddingVector) {
            return mergeFrom(
                (com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec
                        .EmbeddingVector)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.EmbeddingVector
                other) {
          if (other
              == com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.EmbeddingVector
                  .getDefaultInstance()) return this;
          if (!other.getFieldPath().isEmpty()) {
            fieldPath_ = other.fieldPath_;
            bitField0_ |= 0x00000001;
            onChanged();
          }
          if (!other.vector_.isEmpty()) {
            if (vector_.isEmpty()) {
              vector_ = other.vector_;
              vector_.makeImmutable();
              bitField0_ |= 0x00000002;
            } else {
              ensureVectorIsMutable();
              vector_.addAll(other.vector_);
            }
            onChanged();
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    fieldPath_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                case 21:
                  {
                    float v = input.readFloat();
                    ensureVectorIsMutable();
                    vector_.addFloat(v);
                    break;
                  } // case 21
                case 18:
                  {
                    int length = input.readRawVarint32();
                    int limit = input.pushLimit(length);
                    int alloc = length > 4096 ? 4096 : length;
                    ensureVectorIsMutable(alloc / 4);
                    while (input.getBytesUntilLimit() > 0) {
                      vector_.addFloat(input.readFloat());
                    }
                    input.popLimit(limit);
                    break;
                  } // case 18
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.lang.Object fieldPath_ = "";
        /**
         *
         *
         * <pre>
         * Embedding field path in schema.
         * </pre>
         *
         * <code>string field_path = 1;</code>
         *
         * @return The fieldPath.
         */
        public java.lang.String getFieldPath() {
          java.lang.Object ref = fieldPath_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            fieldPath_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Embedding field path in schema.
         * </pre>
         *
         * <code>string field_path = 1;</code>
         *
         * @return The bytes for fieldPath.
         */
        public com.google.protobuf.ByteString getFieldPathBytes() {
          java.lang.Object ref = fieldPath_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            fieldPath_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Embedding field path in schema.
         * </pre>
         *
         * <code>string field_path = 1;</code>
         *
         * @param value The fieldPath to set.
         * @return This builder for chaining.
         */
        public Builder setFieldPath(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          fieldPath_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Embedding field path in schema.
         * </pre>
         *
         * <code>string field_path = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearFieldPath() {
          fieldPath_ = getDefaultInstance().getFieldPath();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Embedding field path in schema.
         * </pre>
         *
         * <code>string field_path = 1;</code>
         *
         * @param value The bytes for fieldPath to set.
         * @return This builder for chaining.
         */
        public Builder setFieldPathBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          fieldPath_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        private com.google.protobuf.Internal.FloatList vector_ = emptyFloatList();

        private void ensureVectorIsMutable() {
          if (!vector_.isModifiable()) {
            vector_ = makeMutableCopy(vector_);
          }
          bitField0_ |= 0x00000002;
        }

        private void ensureVectorIsMutable(int capacity) {
          if (!vector_.isModifiable()) {
            vector_ = makeMutableCopy(vector_, capacity);
          }
          bitField0_ |= 0x00000002;
        }
        /**
         *
         *
         * <pre>
         * Query embedding vector.
         * </pre>
         *
         * <code>repeated float vector = 2;</code>
         *
         * @return A list containing the vector.
         */
        public java.util.List<java.lang.Float> getVectorList() {
          vector_.makeImmutable();
          return vector_;
        }
        /**
         *
         *
         * <pre>
         * Query embedding vector.
         * </pre>
         *
         * <code>repeated float vector = 2;</code>
         *
         * @return The count of vector.
         */
        public int getVectorCount() {
          return vector_.size();
        }
        /**
         *
         *
         * <pre>
         * Query embedding vector.
         * </pre>
         *
         * <code>repeated float vector = 2;</code>
         *
         * @param index The index of the element to return.
         * @return The vector at the given index.
         */
        public float getVector(int index) {
          return vector_.getFloat(index);
        }
        /**
         *
         *
         * <pre>
         * Query embedding vector.
         * </pre>
         *
         * <code>repeated float vector = 2;</code>
         *
         * @param index The index to set the value at.
         * @param value The vector to set.
         * @return This builder for chaining.
         */
        public Builder setVector(int index, float value) {

          ensureVectorIsMutable();
          vector_.setFloat(index, value);
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Query embedding vector.
         * </pre>
         *
         * <code>repeated float vector = 2;</code>
         *
         * @param value The vector to add.
         * @return This builder for chaining.
         */
        public Builder addVector(float value) {

          ensureVectorIsMutable();
          vector_.addFloat(value);
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Query embedding vector.
         * </pre>
         *
         * <code>repeated float vector = 2;</code>
         *
         * @param values The vector to add.
         * @return This builder for chaining.
         */
        public Builder addAllVector(java.lang.Iterable<? extends java.lang.Float> values) {
          ensureVectorIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, vector_);
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Query embedding vector.
         * </pre>
         *
         * <code>repeated float vector = 2;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearVector() {
          vector_ = emptyFloatList();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.EmbeddingVector)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.EmbeddingVector)
      private static final com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec
              .EmbeddingVector
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec
                .EmbeddingVector();
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec
              .EmbeddingVector
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<EmbeddingVector> PARSER =
          new com.google.protobuf.AbstractParser<EmbeddingVector>() {
            @java.lang.Override
            public EmbeddingVector parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<EmbeddingVector> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<EmbeddingVector> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.EmbeddingVector
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public static final int EMBEDDING_VECTORS_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private java.util.List<
            com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.EmbeddingVector>
        embeddingVectors_;
    /**
     *
     *
     * <pre>
     * The embedding vector used for retrieval. Limit to 1.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.EmbeddingVector embedding_vectors = 1;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.EmbeddingVector>
        getEmbeddingVectorsList() {
      return embeddingVectors_;
    }
    /**
     *
     *
     * <pre>
     * The embedding vector used for retrieval. Limit to 1.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.EmbeddingVector embedding_vectors = 1;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends
                com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec
                    .EmbeddingVectorOrBuilder>
        getEmbeddingVectorsOrBuilderList() {
      return embeddingVectors_;
    }
    /**
     *
     *
     * <pre>
     * The embedding vector used for retrieval. Limit to 1.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.EmbeddingVector embedding_vectors = 1;
     * </code>
     */
    @java.lang.Override
    public int getEmbeddingVectorsCount() {
      return embeddingVectors_.size();
    }
    /**
     *
     *
     * <pre>
     * The embedding vector used for retrieval. Limit to 1.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.EmbeddingVector embedding_vectors = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.EmbeddingVector
        getEmbeddingVectors(int index) {
      return embeddingVectors_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The embedding vector used for retrieval. Limit to 1.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.EmbeddingVector embedding_vectors = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec
            .EmbeddingVectorOrBuilder
        getEmbeddingVectorsOrBuilder(int index) {
      return embeddingVectors_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < embeddingVectors_.size(); i++) {
        output.writeMessage(1, embeddingVectors_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < embeddingVectors_.size(); i++) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(1, embeddingVectors_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec)) {
        return super.equals(obj);
      }
      com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec other =
          (com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec) obj;

      if (!getEmbeddingVectorsList().equals(other.getEmbeddingVectorsList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getEmbeddingVectorsCount() > 0) {
        hash = (37 * hash) + EMBEDDING_VECTORS_FIELD_NUMBER;
        hash = (53 * hash) + getEmbeddingVectorsList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * The specification that uses customized query embedding vector to do
     * semantic document retrieval.
     * </pre>
     *
     * Protobuf type {@code google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec)
        com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpecOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_SearchRequest_EmbeddingSpec_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_SearchRequest_EmbeddingSpec_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.class,
                com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.Builder.class);
      }

      // Construct using
      // com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (embeddingVectorsBuilder_ == null) {
          embeddingVectors_ = java.util.Collections.emptyList();
        } else {
          embeddingVectors_ = null;
          embeddingVectorsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_SearchRequest_EmbeddingSpec_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec
          getDefaultInstanceForType() {
        return com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec build() {
        com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec buildPartial() {
        com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec result =
            new com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec result) {
        if (embeddingVectorsBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            embeddingVectors_ = java.util.Collections.unmodifiableList(embeddingVectors_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.embeddingVectors_ = embeddingVectors_;
        } else {
          result.embeddingVectors_ = embeddingVectorsBuilder_.build();
        }
      }

      private void buildPartial0(
          com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec result) {
        int from_bitField0_ = bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec) {
          return mergeFrom(
              (com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec other) {
        if (other
            == com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec
                .getDefaultInstance()) return this;
        if (embeddingVectorsBuilder_ == null) {
          if (!other.embeddingVectors_.isEmpty()) {
            if (embeddingVectors_.isEmpty()) {
              embeddingVectors_ = other.embeddingVectors_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureEmbeddingVectorsIsMutable();
              embeddingVectors_.addAll(other.embeddingVectors_);
            }
            onChanged();
          }
        } else {
          if (!other.embeddingVectors_.isEmpty()) {
            if (embeddingVectorsBuilder_.isEmpty()) {
              embeddingVectorsBuilder_.dispose();
              embeddingVectorsBuilder_ = null;
              embeddingVectors_ = other.embeddingVectors_;
              bitField0_ = (bitField0_ & ~0x00000001);
              embeddingVectorsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getEmbeddingVectorsFieldBuilder()
                      : null;
            } else {
              embeddingVectorsBuilder_.addAllMessages(other.embeddingVectors_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec
                          .EmbeddingVector
                      m =
                          input.readMessage(
                              com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec
                                  .EmbeddingVector.parser(),
                              extensionRegistry);
                  if (embeddingVectorsBuilder_ == null) {
                    ensureEmbeddingVectorsIsMutable();
                    embeddingVectors_.add(m);
                  } else {
                    embeddingVectorsBuilder_.addMessage(m);
                  }
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.util.List<
              com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.EmbeddingVector>
          embeddingVectors_ = java.util.Collections.emptyList();

      private void ensureEmbeddingVectorsIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          embeddingVectors_ =
              new java.util.ArrayList<
                  com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec
                      .EmbeddingVector>(embeddingVectors_);
          bitField0_ |= 0x00000001;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.EmbeddingVector,
              com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.EmbeddingVector
                  .Builder,
              com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec
                  .EmbeddingVectorOrBuilder>
          embeddingVectorsBuilder_;

      /**
       *
       *
       * <pre>
       * The embedding vector used for retrieval. Limit to 1.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.EmbeddingVector embedding_vectors = 1;
       * </code>
       */
      public java.util.List<
              com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.EmbeddingVector>
          getEmbeddingVectorsList() {
        if (embeddingVectorsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(embeddingVectors_);
        } else {
          return embeddingVectorsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * The embedding vector used for retrieval. Limit to 1.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.EmbeddingVector embedding_vectors = 1;
       * </code>
       */
      public int getEmbeddingVectorsCount() {
        if (embeddingVectorsBuilder_ == null) {
          return embeddingVectors_.size();
        } else {
          return embeddingVectorsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * The embedding vector used for retrieval. Limit to 1.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.EmbeddingVector embedding_vectors = 1;
       * </code>
       */
      public com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.EmbeddingVector
          getEmbeddingVectors(int index) {
        if (embeddingVectorsBuilder_ == null) {
          return embeddingVectors_.get(index);
        } else {
          return embeddingVectorsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * The embedding vector used for retrieval. Limit to 1.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.EmbeddingVector embedding_vectors = 1;
       * </code>
       */
      public Builder setEmbeddingVectors(
          int index,
          com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.EmbeddingVector
              value) {
        if (embeddingVectorsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureEmbeddingVectorsIsMutable();
          embeddingVectors_.set(index, value);
          onChanged();
        } else {
          embeddingVectorsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The embedding vector used for retrieval. Limit to 1.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.EmbeddingVector embedding_vectors = 1;
       * </code>
       */
      public Builder setEmbeddingVectors(
          int index,
          com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.EmbeddingVector
                  .Builder
              builderForValue) {
        if (embeddingVectorsBuilder_ == null) {
          ensureEmbeddingVectorsIsMutable();
          embeddingVectors_.set(index, builderForValue.build());
          onChanged();
        } else {
          embeddingVectorsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The embedding vector used for retrieval. Limit to 1.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.EmbeddingVector embedding_vectors = 1;
       * </code>
       */
      public Builder addEmbeddingVectors(
          com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.EmbeddingVector
              value) {
        if (embeddingVectorsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureEmbeddingVectorsIsMutable();
          embeddingVectors_.add(value);
          onChanged();
        } else {
          embeddingVectorsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The embedding vector used for retrieval. Limit to 1.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.EmbeddingVector embedding_vectors = 1;
       * </code>
       */
      public Builder addEmbeddingVectors(
          int index,
          com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.EmbeddingVector
              value) {
        if (embeddingVectorsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureEmbeddingVectorsIsMutable();
          embeddingVectors_.add(index, value);
          onChanged();
        } else {
          embeddingVectorsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The embedding vector used for retrieval. Limit to 1.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.EmbeddingVector embedding_vectors = 1;
       * </code>
       */
      public Builder addEmbeddingVectors(
          com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.EmbeddingVector
                  .Builder
              builderForValue) {
        if (embeddingVectorsBuilder_ == null) {
          ensureEmbeddingVectorsIsMutable();
          embeddingVectors_.add(builderForValue.build());
          onChanged();
        } else {
          embeddingVectorsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The embedding vector used for retrieval. Limit to 1.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.EmbeddingVector embedding_vectors = 1;
       * </code>
       */
      public Builder addEmbeddingVectors(
          int index,
          com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.EmbeddingVector
                  .Builder
              builderForValue) {
        if (embeddingVectorsBuilder_ == null) {
          ensureEmbeddingVectorsIsMutable();
          embeddingVectors_.add(index, builderForValue.build());
          onChanged();
        } else {
          embeddingVectorsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The embedding vector used for retrieval. Limit to 1.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.EmbeddingVector embedding_vectors = 1;
       * </code>
       */
      public Builder addAllEmbeddingVectors(
          java.lang.Iterable<
                  ? extends
                      com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec
                          .EmbeddingVector>
              values) {
        if (embeddingVectorsBuilder_ == null) {
          ensureEmbeddingVectorsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, embeddingVectors_);
          onChanged();
        } else {
          embeddingVectorsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The embedding vector used for retrieval. Limit to 1.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.EmbeddingVector embedding_vectors = 1;
       * </code>
       */
      public Builder clearEmbeddingVectors() {
        if (embeddingVectorsBuilder_ == null) {
          embeddingVectors_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          embeddingVectorsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The embedding vector used for retrieval. Limit to 1.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.EmbeddingVector embedding_vectors = 1;
       * </code>
       */
      public Builder removeEmbeddingVectors(int index) {
        if (embeddingVectorsBuilder_ == null) {
          ensureEmbeddingVectorsIsMutable();
          embeddingVectors_.remove(index);
          onChanged();
        } else {
          embeddingVectorsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The embedding vector used for retrieval. Limit to 1.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.EmbeddingVector embedding_vectors = 1;
       * </code>
       */
      public com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.EmbeddingVector
              .Builder
          getEmbeddingVectorsBuilder(int index) {
        return getEmbeddingVectorsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * The embedding vector used for retrieval. Limit to 1.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.EmbeddingVector embedding_vectors = 1;
       * </code>
       */
      public com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec
              .EmbeddingVectorOrBuilder
          getEmbeddingVectorsOrBuilder(int index) {
        if (embeddingVectorsBuilder_ == null) {
          return embeddingVectors_.get(index);
        } else {
          return embeddingVectorsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * The embedding vector used for retrieval. Limit to 1.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.EmbeddingVector embedding_vectors = 1;
       * </code>
       */
      public java.util.List<
              ? extends
                  com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec
                      .EmbeddingVectorOrBuilder>
          getEmbeddingVectorsOrBuilderList() {
        if (embeddingVectorsBuilder_ != null) {
          return embeddingVectorsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(embeddingVectors_);
        }
      }
      /**
       *
       *
       * <pre>
       * The embedding vector used for retrieval. Limit to 1.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.EmbeddingVector embedding_vectors = 1;
       * </code>
       */
      public com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.EmbeddingVector
              .Builder
          addEmbeddingVectorsBuilder() {
        return getEmbeddingVectorsFieldBuilder()
            .addBuilder(
                com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.EmbeddingVector
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * The embedding vector used for retrieval. Limit to 1.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.EmbeddingVector embedding_vectors = 1;
       * </code>
       */
      public com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.EmbeddingVector
              .Builder
          addEmbeddingVectorsBuilder(int index) {
        return getEmbeddingVectorsFieldBuilder()
            .addBuilder(
                index,
                com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.EmbeddingVector
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * The embedding vector used for retrieval. Limit to 1.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.EmbeddingVector embedding_vectors = 1;
       * </code>
       */
      public java.util.List<
              com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.EmbeddingVector
                  .Builder>
          getEmbeddingVectorsBuilderList() {
        return getEmbeddingVectorsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.EmbeddingVector,
              com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.EmbeddingVector
                  .Builder,
              com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec
                  .EmbeddingVectorOrBuilder>
          getEmbeddingVectorsFieldBuilder() {
        if (embeddingVectorsBuilder_ == null) {
          embeddingVectorsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec
                      .EmbeddingVector,
                  com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec
                      .EmbeddingVector.Builder,
                  com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec
                      .EmbeddingVectorOrBuilder>(
                  embeddingVectors_,
                  ((bitField0_ & 0x00000001) != 0),
                  getParentForChildren(),
                  isClean());
          embeddingVectors_ = null;
        }
        return embeddingVectorsBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec)
    private static final com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec();
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<EmbeddingSpec> PARSER =
        new com.google.protobuf.AbstractParser<EmbeddingSpec>() {
          @java.lang.Override
          public EmbeddingSpec parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<EmbeddingSpec> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<EmbeddingSpec> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int SERVING_CONFIG_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object servingConfig_ = "";
  /**
   *
   *
   * <pre>
   * Required. The resource name of the Search serving config, such as
   * `projects/&#42;&#47;locations/global/collections/default_collection/engines/&#42;&#47;servingConfigs/default_serving_config`,
   * or
   * `projects/&#42;&#47;locations/global/collections/default_collection/dataStores/default_data_store/servingConfigs/default_serving_config`.
   * This field is used to identify the serving configuration name, set
   * of models used to make the search.
   * </pre>
   *
   * <code>
   * string serving_config = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The servingConfig.
   */
  @java.lang.Override
  public java.lang.String getServingConfig() {
    java.lang.Object ref = servingConfig_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      servingConfig_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The resource name of the Search serving config, such as
   * `projects/&#42;&#47;locations/global/collections/default_collection/engines/&#42;&#47;servingConfigs/default_serving_config`,
   * or
   * `projects/&#42;&#47;locations/global/collections/default_collection/dataStores/default_data_store/servingConfigs/default_serving_config`.
   * This field is used to identify the serving configuration name, set
   * of models used to make the search.
   * </pre>
   *
   * <code>
   * string serving_config = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for servingConfig.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getServingConfigBytes() {
    java.lang.Object ref = servingConfig_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      servingConfig_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int BRANCH_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object branch_ = "";
  /**
   *
   *
   * <pre>
   * The branch resource name, such as
   * `projects/&#42;&#47;locations/global/collections/default_collection/dataStores/default_data_store/branches/0`.
   *
   * Use `default_branch` as the branch ID or leave this field empty, to search
   * documents under the default branch.
   * </pre>
   *
   * <code>string branch = 2 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The branch.
   */
  @java.lang.Override
  public java.lang.String getBranch() {
    java.lang.Object ref = branch_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      branch_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The branch resource name, such as
   * `projects/&#42;&#47;locations/global/collections/default_collection/dataStores/default_data_store/branches/0`.
   *
   * Use `default_branch` as the branch ID or leave this field empty, to search
   * documents under the default branch.
   * </pre>
   *
   * <code>string branch = 2 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for branch.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getBranchBytes() {
    java.lang.Object ref = branch_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      branch_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int QUERY_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object query_ = "";
  /**
   *
   *
   * <pre>
   * Raw search query.
   * </pre>
   *
   * <code>string query = 3;</code>
   *
   * @return The query.
   */
  @java.lang.Override
  public java.lang.String getQuery() {
    java.lang.Object ref = query_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      query_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Raw search query.
   * </pre>
   *
   * <code>string query = 3;</code>
   *
   * @return The bytes for query.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getQueryBytes() {
    java.lang.Object ref = query_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      query_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int IMAGE_QUERY_FIELD_NUMBER = 19;
  private com.google.cloud.discoveryengine.v1beta.SearchRequest.ImageQuery imageQuery_;
  /**
   *
   *
   * <pre>
   * Raw image query.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.SearchRequest.ImageQuery image_query = 19;</code>
   *
   * @return Whether the imageQuery field is set.
   */
  @java.lang.Override
  public boolean hasImageQuery() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Raw image query.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.SearchRequest.ImageQuery image_query = 19;</code>
   *
   * @return The imageQuery.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.SearchRequest.ImageQuery getImageQuery() {
    return imageQuery_ == null
        ? com.google.cloud.discoveryengine.v1beta.SearchRequest.ImageQuery.getDefaultInstance()
        : imageQuery_;
  }
  /**
   *
   *
   * <pre>
   * Raw image query.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.SearchRequest.ImageQuery image_query = 19;</code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.SearchRequest.ImageQueryOrBuilder
      getImageQueryOrBuilder() {
    return imageQuery_ == null
        ? com.google.cloud.discoveryengine.v1beta.SearchRequest.ImageQuery.getDefaultInstance()
        : imageQuery_;
  }

  public static final int PAGE_SIZE_FIELD_NUMBER = 4;
  private int pageSize_ = 0;
  /**
   *
   *
   * <pre>
   * Maximum number of [Document][google.cloud.discoveryengine.v1beta.Document]s
   * to return. The maximum allowed value depends on the data type. Values above
   * the maximum value are coerced to the maximum value.
   *
   * * Websites with basic indexing: Default `10`, Maximum `25`.
   * * Websites with advanced indexing: Default `25`, Maximum `50`.
   * * Other: Default `50`, Maximum `100`.
   *
   * If this field is negative, an  `INVALID_ARGUMENT` is returned.
   * </pre>
   *
   * <code>int32 page_size = 4;</code>
   *
   * @return The pageSize.
   */
  @java.lang.Override
  public int getPageSize() {
    return pageSize_;
  }

  public static final int PAGE_TOKEN_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object pageToken_ = "";
  /**
   *
   *
   * <pre>
   * A page token received from a previous
   * [SearchService.Search][google.cloud.discoveryengine.v1beta.SearchService.Search]
   * call. Provide this to retrieve the subsequent page.
   *
   * When paginating, all other parameters provided to
   * [SearchService.Search][google.cloud.discoveryengine.v1beta.SearchService.Search]
   * must match the call that provided the page token. Otherwise, an
   *  `INVALID_ARGUMENT`  error is returned.
   * </pre>
   *
   * <code>string page_token = 5;</code>
   *
   * @return The pageToken.
   */
  @java.lang.Override
  public java.lang.String getPageToken() {
    java.lang.Object ref = pageToken_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      pageToken_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A page token received from a previous
   * [SearchService.Search][google.cloud.discoveryengine.v1beta.SearchService.Search]
   * call. Provide this to retrieve the subsequent page.
   *
   * When paginating, all other parameters provided to
   * [SearchService.Search][google.cloud.discoveryengine.v1beta.SearchService.Search]
   * must match the call that provided the page token. Otherwise, an
   *  `INVALID_ARGUMENT`  error is returned.
   * </pre>
   *
   * <code>string page_token = 5;</code>
   *
   * @return The bytes for pageToken.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPageTokenBytes() {
    java.lang.Object ref = pageToken_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      pageToken_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int OFFSET_FIELD_NUMBER = 6;
  private int offset_ = 0;
  /**
   *
   *
   * <pre>
   * A 0-indexed integer that specifies the current offset (that is, starting
   * result location, amongst the
   * [Document][google.cloud.discoveryengine.v1beta.Document]s deemed by the API
   * as relevant) in search results. This field is only considered if
   * [page_token][google.cloud.discoveryengine.v1beta.SearchRequest.page_token]
   * is unset.
   *
   * If this field is negative, an  `INVALID_ARGUMENT`  is returned.
   * </pre>
   *
   * <code>int32 offset = 6;</code>
   *
   * @return The offset.
   */
  @java.lang.Override
  public int getOffset() {
    return offset_;
  }

  public static final int DATA_STORE_SPECS_FIELD_NUMBER = 32;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpec>
      dataStoreSpecs_;
  /**
   *
   *
   * <pre>
   * A list of data store specs to apply on a search call.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpec data_store_specs = 32;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpec>
      getDataStoreSpecsList() {
    return dataStoreSpecs_;
  }
  /**
   *
   *
   * <pre>
   * A list of data store specs to apply on a search call.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpec data_store_specs = 32;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpecOrBuilder>
      getDataStoreSpecsOrBuilderList() {
    return dataStoreSpecs_;
  }
  /**
   *
   *
   * <pre>
   * A list of data store specs to apply on a search call.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpec data_store_specs = 32;
   * </code>
   */
  @java.lang.Override
  public int getDataStoreSpecsCount() {
    return dataStoreSpecs_.size();
  }
  /**
   *
   *
   * <pre>
   * A list of data store specs to apply on a search call.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpec data_store_specs = 32;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpec getDataStoreSpecs(
      int index) {
    return dataStoreSpecs_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A list of data store specs to apply on a search call.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpec data_store_specs = 32;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpecOrBuilder
      getDataStoreSpecsOrBuilder(int index) {
    return dataStoreSpecs_.get(index);
  }

  public static final int FILTER_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private volatile java.lang.Object filter_ = "";
  /**
   *
   *
   * <pre>
   * The filter syntax consists of an expression language for constructing a
   * predicate from one or more fields of the documents being filtered. Filter
   * expression is case-sensitive.
   *
   * If this field is unrecognizable, an  `INVALID_ARGUMENT`  is returned.
   *
   * Filtering in Vertex AI Search is done by mapping the LHS filter key to a
   * key property defined in the Vertex AI Search backend -- this mapping is
   * defined by the customer in their schema. For example a media customer might
   * have a field 'name' in their schema. In this case the filter would look
   * like this: filter --&gt; name:'ANY("king kong")'
   *
   * For more information about filtering including syntax and filter
   * operators, see
   * [Filter](https://cloud.google.com/generative-ai-app-builder/docs/filter-search-metadata)
   * </pre>
   *
   * <code>string filter = 7;</code>
   *
   * @return The filter.
   */
  @java.lang.Override
  public java.lang.String getFilter() {
    java.lang.Object ref = filter_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      filter_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The filter syntax consists of an expression language for constructing a
   * predicate from one or more fields of the documents being filtered. Filter
   * expression is case-sensitive.
   *
   * If this field is unrecognizable, an  `INVALID_ARGUMENT`  is returned.
   *
   * Filtering in Vertex AI Search is done by mapping the LHS filter key to a
   * key property defined in the Vertex AI Search backend -- this mapping is
   * defined by the customer in their schema. For example a media customer might
   * have a field 'name' in their schema. In this case the filter would look
   * like this: filter --&gt; name:'ANY("king kong")'
   *
   * For more information about filtering including syntax and filter
   * operators, see
   * [Filter](https://cloud.google.com/generative-ai-app-builder/docs/filter-search-metadata)
   * </pre>
   *
   * <code>string filter = 7;</code>
   *
   * @return The bytes for filter.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFilterBytes() {
    java.lang.Object ref = filter_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      filter_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CANONICAL_FILTER_FIELD_NUMBER = 29;

  @SuppressWarnings("serial")
  private volatile java.lang.Object canonicalFilter_ = "";
  /**
   *
   *
   * <pre>
   * The default filter that is applied when a user performs a search without
   * checking any filters on the search page.
   *
   * The filter applied to every search request when quality improvement such as
   * query expansion is needed. In the case a query does not have a sufficient
   * amount of results this filter will be used to determine whether or not to
   * enable the query expansion flow. The original filter will still be used for
   * the query expanded search.
   * This field is strongly recommended to achieve high search quality.
   *
   * For more information about filter syntax, see
   * [SearchRequest.filter][google.cloud.discoveryengine.v1beta.SearchRequest.filter].
   * </pre>
   *
   * <code>string canonical_filter = 29;</code>
   *
   * @return The canonicalFilter.
   */
  @java.lang.Override
  public java.lang.String getCanonicalFilter() {
    java.lang.Object ref = canonicalFilter_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      canonicalFilter_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The default filter that is applied when a user performs a search without
   * checking any filters on the search page.
   *
   * The filter applied to every search request when quality improvement such as
   * query expansion is needed. In the case a query does not have a sufficient
   * amount of results this filter will be used to determine whether or not to
   * enable the query expansion flow. The original filter will still be used for
   * the query expanded search.
   * This field is strongly recommended to achieve high search quality.
   *
   * For more information about filter syntax, see
   * [SearchRequest.filter][google.cloud.discoveryengine.v1beta.SearchRequest.filter].
   * </pre>
   *
   * <code>string canonical_filter = 29;</code>
   *
   * @return The bytes for canonicalFilter.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCanonicalFilterBytes() {
    java.lang.Object ref = canonicalFilter_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      canonicalFilter_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ORDER_BY_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private volatile java.lang.Object orderBy_ = "";
  /**
   *
   *
   * <pre>
   * The order in which documents are returned. Documents can be ordered by
   * a field in an [Document][google.cloud.discoveryengine.v1beta.Document]
   * object. Leave it unset if ordered by relevance. `order_by` expression is
   * case-sensitive. For more information on ordering, see
   * [Ordering](https://cloud.google.com/retail/docs/filter-and-order#order)
   *
   * If this field is unrecognizable, an `INVALID_ARGUMENT` is returned.
   * </pre>
   *
   * <code>string order_by = 8;</code>
   *
   * @return The orderBy.
   */
  @java.lang.Override
  public java.lang.String getOrderBy() {
    java.lang.Object ref = orderBy_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      orderBy_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The order in which documents are returned. Documents can be ordered by
   * a field in an [Document][google.cloud.discoveryengine.v1beta.Document]
   * object. Leave it unset if ordered by relevance. `order_by` expression is
   * case-sensitive. For more information on ordering, see
   * [Ordering](https://cloud.google.com/retail/docs/filter-and-order#order)
   *
   * If this field is unrecognizable, an `INVALID_ARGUMENT` is returned.
   * </pre>
   *
   * <code>string order_by = 8;</code>
   *
   * @return The bytes for orderBy.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getOrderByBytes() {
    java.lang.Object ref = orderBy_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      orderBy_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int USER_INFO_FIELD_NUMBER = 21;
  private com.google.cloud.discoveryengine.v1beta.UserInfo userInfo_;
  /**
   *
   *
   * <pre>
   * Information about the end user.
   * Highly recommended for analytics.
   * [UserInfo.user_agent][google.cloud.discoveryengine.v1beta.UserInfo.user_agent]
   * is used to deduce `device_type` for analytics.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.UserInfo user_info = 21;</code>
   *
   * @return Whether the userInfo field is set.
   */
  @java.lang.Override
  public boolean hasUserInfo() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Information about the end user.
   * Highly recommended for analytics.
   * [UserInfo.user_agent][google.cloud.discoveryengine.v1beta.UserInfo.user_agent]
   * is used to deduce `device_type` for analytics.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.UserInfo user_info = 21;</code>
   *
   * @return The userInfo.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.UserInfo getUserInfo() {
    return userInfo_ == null
        ? com.google.cloud.discoveryengine.v1beta.UserInfo.getDefaultInstance()
        : userInfo_;
  }
  /**
   *
   *
   * <pre>
   * Information about the end user.
   * Highly recommended for analytics.
   * [UserInfo.user_agent][google.cloud.discoveryengine.v1beta.UserInfo.user_agent]
   * is used to deduce `device_type` for analytics.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.UserInfo user_info = 21;</code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.UserInfoOrBuilder getUserInfoOrBuilder() {
    return userInfo_ == null
        ? com.google.cloud.discoveryengine.v1beta.UserInfo.getDefaultInstance()
        : userInfo_;
  }

  public static final int FACET_SPECS_FIELD_NUMBER = 9;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec>
      facetSpecs_;
  /**
   *
   *
   * <pre>
   * Facet specifications for faceted search. If empty, no facets are returned.
   *
   * A maximum of 100 values are allowed. Otherwise, an  `INVALID_ARGUMENT`
   * error is returned.
   * </pre>
   *
   * <code>repeated .google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec facet_specs = 9;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec>
      getFacetSpecsList() {
    return facetSpecs_;
  }
  /**
   *
   *
   * <pre>
   * Facet specifications for faceted search. If empty, no facets are returned.
   *
   * A maximum of 100 values are allowed. Otherwise, an  `INVALID_ARGUMENT`
   * error is returned.
   * </pre>
   *
   * <code>repeated .google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec facet_specs = 9;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpecOrBuilder>
      getFacetSpecsOrBuilderList() {
    return facetSpecs_;
  }
  /**
   *
   *
   * <pre>
   * Facet specifications for faceted search. If empty, no facets are returned.
   *
   * A maximum of 100 values are allowed. Otherwise, an  `INVALID_ARGUMENT`
   * error is returned.
   * </pre>
   *
   * <code>repeated .google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec facet_specs = 9;
   * </code>
   */
  @java.lang.Override
  public int getFacetSpecsCount() {
    return facetSpecs_.size();
  }
  /**
   *
   *
   * <pre>
   * Facet specifications for faceted search. If empty, no facets are returned.
   *
   * A maximum of 100 values are allowed. Otherwise, an  `INVALID_ARGUMENT`
   * error is returned.
   * </pre>
   *
   * <code>repeated .google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec facet_specs = 9;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec getFacetSpecs(int index) {
    return facetSpecs_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Facet specifications for faceted search. If empty, no facets are returned.
   *
   * A maximum of 100 values are allowed. Otherwise, an  `INVALID_ARGUMENT`
   * error is returned.
   * </pre>
   *
   * <code>repeated .google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec facet_specs = 9;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpecOrBuilder
      getFacetSpecsOrBuilder(int index) {
    return facetSpecs_.get(index);
  }

  public static final int BOOST_SPEC_FIELD_NUMBER = 10;
  private com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec boostSpec_;
  /**
   *
   *
   * <pre>
   * Boost specification to boost certain documents.
   * For more information on boosting, see
   * [Boosting](https://cloud.google.com/retail/docs/boosting#boost)
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec boost_spec = 10;</code>
   *
   * @return Whether the boostSpec field is set.
   */
  @java.lang.Override
  public boolean hasBoostSpec() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Boost specification to boost certain documents.
   * For more information on boosting, see
   * [Boosting](https://cloud.google.com/retail/docs/boosting#boost)
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec boost_spec = 10;</code>
   *
   * @return The boostSpec.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec getBoostSpec() {
    return boostSpec_ == null
        ? com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.getDefaultInstance()
        : boostSpec_;
  }
  /**
   *
   *
   * <pre>
   * Boost specification to boost certain documents.
   * For more information on boosting, see
   * [Boosting](https://cloud.google.com/retail/docs/boosting#boost)
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec boost_spec = 10;</code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpecOrBuilder
      getBoostSpecOrBuilder() {
    return boostSpec_ == null
        ? com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.getDefaultInstance()
        : boostSpec_;
  }

  public static final int PARAMS_FIELD_NUMBER = 11;

  private static final class ParamsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, com.google.protobuf.Value>
        defaultEntry =
            com.google.protobuf.MapEntry
                .<java.lang.String, com.google.protobuf.Value>newDefaultInstance(
                    com.google.cloud.discoveryengine.v1beta.SearchServiceProto
                        .internal_static_google_cloud_discoveryengine_v1beta_SearchRequest_ParamsEntry_descriptor,
                    com.google.protobuf.WireFormat.FieldType.STRING,
                    "",
                    com.google.protobuf.WireFormat.FieldType.MESSAGE,
                    com.google.protobuf.Value.getDefaultInstance());
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, com.google.protobuf.Value> params_;

  private com.google.protobuf.MapField<java.lang.String, com.google.protobuf.Value>
      internalGetParams() {
    if (params_ == null) {
      return com.google.protobuf.MapField.emptyMapField(ParamsDefaultEntryHolder.defaultEntry);
    }
    return params_;
  }

  public int getParamsCount() {
    return internalGetParams().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Additional search parameters.
   *
   * For public website search only, supported values are:
   *
   * * `user_country_code`: string. Default empty. If set to non-empty, results
   *    are restricted or boosted based on the location provided.
   *    Example:
   *    user_country_code: "au"
   *
   *    For available codes see [Country
   *    Codes](https://developers.google.com/custom-search/docs/json_api_reference#countryCodes)
   *
   * * `search_type`: double. Default empty. Enables non-webpage searching
   *    depending on the value. The only valid non-default value is 1,
   *    which enables image searching.
   *    Example:
   *    search_type: 1
   * </pre>
   *
   * <code>map&lt;string, .google.protobuf.Value&gt; params = 11;</code>
   */
  @java.lang.Override
  public boolean containsParams(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetParams().getMap().containsKey(key);
  }
  /** Use {@link #getParamsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, com.google.protobuf.Value> getParams() {
    return getParamsMap();
  }
  /**
   *
   *
   * <pre>
   * Additional search parameters.
   *
   * For public website search only, supported values are:
   *
   * * `user_country_code`: string. Default empty. If set to non-empty, results
   *    are restricted or boosted based on the location provided.
   *    Example:
   *    user_country_code: "au"
   *
   *    For available codes see [Country
   *    Codes](https://developers.google.com/custom-search/docs/json_api_reference#countryCodes)
   *
   * * `search_type`: double. Default empty. Enables non-webpage searching
   *    depending on the value. The only valid non-default value is 1,
   *    which enables image searching.
   *    Example:
   *    search_type: 1
   * </pre>
   *
   * <code>map&lt;string, .google.protobuf.Value&gt; params = 11;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, com.google.protobuf.Value> getParamsMap() {
    return internalGetParams().getMap();
  }
  /**
   *
   *
   * <pre>
   * Additional search parameters.
   *
   * For public website search only, supported values are:
   *
   * * `user_country_code`: string. Default empty. If set to non-empty, results
   *    are restricted or boosted based on the location provided.
   *    Example:
   *    user_country_code: "au"
   *
   *    For available codes see [Country
   *    Codes](https://developers.google.com/custom-search/docs/json_api_reference#countryCodes)
   *
   * * `search_type`: double. Default empty. Enables non-webpage searching
   *    depending on the value. The only valid non-default value is 1,
   *    which enables image searching.
   *    Example:
   *    search_type: 1
   * </pre>
   *
   * <code>map&lt;string, .google.protobuf.Value&gt; params = 11;</code>
   */
  @java.lang.Override
  public /* nullable */ com.google.protobuf.Value getParamsOrDefault(
      java.lang.String key,
      /* nullable */
      com.google.protobuf.Value defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.protobuf.Value> map = internalGetParams().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Additional search parameters.
   *
   * For public website search only, supported values are:
   *
   * * `user_country_code`: string. Default empty. If set to non-empty, results
   *    are restricted or boosted based on the location provided.
   *    Example:
   *    user_country_code: "au"
   *
   *    For available codes see [Country
   *    Codes](https://developers.google.com/custom-search/docs/json_api_reference#countryCodes)
   *
   * * `search_type`: double. Default empty. Enables non-webpage searching
   *    depending on the value. The only valid non-default value is 1,
   *    which enables image searching.
   *    Example:
   *    search_type: 1
   * </pre>
   *
   * <code>map&lt;string, .google.protobuf.Value&gt; params = 11;</code>
   */
  @java.lang.Override
  public com.google.protobuf.Value getParamsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.protobuf.Value> map = internalGetParams().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int QUERY_EXPANSION_SPEC_FIELD_NUMBER = 13;
  private com.google.cloud.discoveryengine.v1beta.SearchRequest.QueryExpansionSpec
      queryExpansionSpec_;
  /**
   *
   *
   * <pre>
   * The query expansion specification that specifies the conditions under which
   * query expansion occurs.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1beta.SearchRequest.QueryExpansionSpec query_expansion_spec = 13;
   * </code>
   *
   * @return Whether the queryExpansionSpec field is set.
   */
  @java.lang.Override
  public boolean hasQueryExpansionSpec() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * The query expansion specification that specifies the conditions under which
   * query expansion occurs.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1beta.SearchRequest.QueryExpansionSpec query_expansion_spec = 13;
   * </code>
   *
   * @return The queryExpansionSpec.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.SearchRequest.QueryExpansionSpec
      getQueryExpansionSpec() {
    return queryExpansionSpec_ == null
        ? com.google.cloud.discoveryengine.v1beta.SearchRequest.QueryExpansionSpec
            .getDefaultInstance()
        : queryExpansionSpec_;
  }
  /**
   *
   *
   * <pre>
   * The query expansion specification that specifies the conditions under which
   * query expansion occurs.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1beta.SearchRequest.QueryExpansionSpec query_expansion_spec = 13;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.SearchRequest.QueryExpansionSpecOrBuilder
      getQueryExpansionSpecOrBuilder() {
    return queryExpansionSpec_ == null
        ? com.google.cloud.discoveryengine.v1beta.SearchRequest.QueryExpansionSpec
            .getDefaultInstance()
        : queryExpansionSpec_;
  }

  public static final int SPELL_CORRECTION_SPEC_FIELD_NUMBER = 14;
  private com.google.cloud.discoveryengine.v1beta.SearchRequest.SpellCorrectionSpec
      spellCorrectionSpec_;
  /**
   *
   *
   * <pre>
   * The spell correction specification that specifies the mode under
   * which spell correction takes effect.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1beta.SearchRequest.SpellCorrectionSpec spell_correction_spec = 14;
   * </code>
   *
   * @return Whether the spellCorrectionSpec field is set.
   */
  @java.lang.Override
  public boolean hasSpellCorrectionSpec() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   *
   *
   * <pre>
   * The spell correction specification that specifies the mode under
   * which spell correction takes effect.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1beta.SearchRequest.SpellCorrectionSpec spell_correction_spec = 14;
   * </code>
   *
   * @return The spellCorrectionSpec.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.SearchRequest.SpellCorrectionSpec
      getSpellCorrectionSpec() {
    return spellCorrectionSpec_ == null
        ? com.google.cloud.discoveryengine.v1beta.SearchRequest.SpellCorrectionSpec
            .getDefaultInstance()
        : spellCorrectionSpec_;
  }
  /**
   *
   *
   * <pre>
   * The spell correction specification that specifies the mode under
   * which spell correction takes effect.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1beta.SearchRequest.SpellCorrectionSpec spell_correction_spec = 14;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.SearchRequest.SpellCorrectionSpecOrBuilder
      getSpellCorrectionSpecOrBuilder() {
    return spellCorrectionSpec_ == null
        ? com.google.cloud.discoveryengine.v1beta.SearchRequest.SpellCorrectionSpec
            .getDefaultInstance()
        : spellCorrectionSpec_;
  }

  public static final int USER_PSEUDO_ID_FIELD_NUMBER = 15;

  @SuppressWarnings("serial")
  private volatile java.lang.Object userPseudoId_ = "";
  /**
   *
   *
   * <pre>
   * A unique identifier for tracking visitors. For example, this could be
   * implemented with an HTTP cookie, which should be able to uniquely identify
   * a visitor on a single device. This unique identifier should not change if
   * the visitor logs in or out of the website.
   *
   * This field should NOT have a fixed value such as `unknown_visitor`.
   *
   * This should be the same identifier as
   * [UserEvent.user_pseudo_id][google.cloud.discoveryengine.v1beta.UserEvent.user_pseudo_id]
   * and
   * [CompleteQueryRequest.user_pseudo_id][google.cloud.discoveryengine.v1beta.CompleteQueryRequest.user_pseudo_id]
   *
   * The field must be a UTF-8 encoded string with a length limit of 128
   * characters. Otherwise, an  `INVALID_ARGUMENT`  error is returned.
   * </pre>
   *
   * <code>string user_pseudo_id = 15;</code>
   *
   * @return The userPseudoId.
   */
  @java.lang.Override
  public java.lang.String getUserPseudoId() {
    java.lang.Object ref = userPseudoId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      userPseudoId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A unique identifier for tracking visitors. For example, this could be
   * implemented with an HTTP cookie, which should be able to uniquely identify
   * a visitor on a single device. This unique identifier should not change if
   * the visitor logs in or out of the website.
   *
   * This field should NOT have a fixed value such as `unknown_visitor`.
   *
   * This should be the same identifier as
   * [UserEvent.user_pseudo_id][google.cloud.discoveryengine.v1beta.UserEvent.user_pseudo_id]
   * and
   * [CompleteQueryRequest.user_pseudo_id][google.cloud.discoveryengine.v1beta.CompleteQueryRequest.user_pseudo_id]
   *
   * The field must be a UTF-8 encoded string with a length limit of 128
   * characters. Otherwise, an  `INVALID_ARGUMENT`  error is returned.
   * </pre>
   *
   * <code>string user_pseudo_id = 15;</code>
   *
   * @return The bytes for userPseudoId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getUserPseudoIdBytes() {
    java.lang.Object ref = userPseudoId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      userPseudoId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CONTENT_SEARCH_SPEC_FIELD_NUMBER = 24;
  private com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
      contentSearchSpec_;
  /**
   *
   *
   * <pre>
   * A specification for configuring the behavior of content search.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec content_search_spec = 24;
   * </code>
   *
   * @return Whether the contentSearchSpec field is set.
   */
  @java.lang.Override
  public boolean hasContentSearchSpec() {
    return ((bitField0_ & 0x00000020) != 0);
  }
  /**
   *
   *
   * <pre>
   * A specification for configuring the behavior of content search.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec content_search_spec = 24;
   * </code>
   *
   * @return The contentSearchSpec.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
      getContentSearchSpec() {
    return contentSearchSpec_ == null
        ? com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
            .getDefaultInstance()
        : contentSearchSpec_;
  }
  /**
   *
   *
   * <pre>
   * A specification for configuring the behavior of content search.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec content_search_spec = 24;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpecOrBuilder
      getContentSearchSpecOrBuilder() {
    return contentSearchSpec_ == null
        ? com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
            .getDefaultInstance()
        : contentSearchSpec_;
  }

  public static final int EMBEDDING_SPEC_FIELD_NUMBER = 23;
  private com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec embeddingSpec_;
  /**
   *
   *
   * <pre>
   * Uses the provided embedding to do additional semantic document retrieval.
   * The retrieval is based on the dot product of
   * [SearchRequest.EmbeddingSpec.EmbeddingVector.vector][google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.EmbeddingVector.vector]
   * and the document embedding that is provided in
   * [SearchRequest.EmbeddingSpec.EmbeddingVector.field_path][google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.EmbeddingVector.field_path].
   *
   * If
   * [SearchRequest.EmbeddingSpec.EmbeddingVector.field_path][google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.EmbeddingVector.field_path]
   * is not provided, it will use
   * [ServingConfig.EmbeddingConfig.field_path][google.cloud.discoveryengine.v1beta.ServingConfig.embedding_config].
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec embedding_spec = 23;
   * </code>
   *
   * @return Whether the embeddingSpec field is set.
   */
  @java.lang.Override
  public boolean hasEmbeddingSpec() {
    return ((bitField0_ & 0x00000040) != 0);
  }
  /**
   *
   *
   * <pre>
   * Uses the provided embedding to do additional semantic document retrieval.
   * The retrieval is based on the dot product of
   * [SearchRequest.EmbeddingSpec.EmbeddingVector.vector][google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.EmbeddingVector.vector]
   * and the document embedding that is provided in
   * [SearchRequest.EmbeddingSpec.EmbeddingVector.field_path][google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.EmbeddingVector.field_path].
   *
   * If
   * [SearchRequest.EmbeddingSpec.EmbeddingVector.field_path][google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.EmbeddingVector.field_path]
   * is not provided, it will use
   * [ServingConfig.EmbeddingConfig.field_path][google.cloud.discoveryengine.v1beta.ServingConfig.embedding_config].
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec embedding_spec = 23;
   * </code>
   *
   * @return The embeddingSpec.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec getEmbeddingSpec() {
    return embeddingSpec_ == null
        ? com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.getDefaultInstance()
        : embeddingSpec_;
  }
  /**
   *
   *
   * <pre>
   * Uses the provided embedding to do additional semantic document retrieval.
   * The retrieval is based on the dot product of
   * [SearchRequest.EmbeddingSpec.EmbeddingVector.vector][google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.EmbeddingVector.vector]
   * and the document embedding that is provided in
   * [SearchRequest.EmbeddingSpec.EmbeddingVector.field_path][google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.EmbeddingVector.field_path].
   *
   * If
   * [SearchRequest.EmbeddingSpec.EmbeddingVector.field_path][google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.EmbeddingVector.field_path]
   * is not provided, it will use
   * [ServingConfig.EmbeddingConfig.field_path][google.cloud.discoveryengine.v1beta.ServingConfig.embedding_config].
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec embedding_spec = 23;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpecOrBuilder
      getEmbeddingSpecOrBuilder() {
    return embeddingSpec_ == null
        ? com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.getDefaultInstance()
        : embeddingSpec_;
  }

  public static final int RANKING_EXPRESSION_FIELD_NUMBER = 26;

  @SuppressWarnings("serial")
  private volatile java.lang.Object rankingExpression_ = "";
  /**
   *
   *
   * <pre>
   * The ranking expression controls the customized ranking on retrieval
   * documents. This overrides
   * [ServingConfig.ranking_expression][google.cloud.discoveryengine.v1beta.ServingConfig.ranking_expression].
   * The ranking expression is a single function or multiple functions that are
   * joint by "+".
   *   * ranking_expression = function, { " + ", function };
   * Supported functions:
   *   * double * relevance_score
   *   * double * dotProduct(embedding_field_path)
   * Function variables:
   *   `relevance_score`: pre-defined keywords, used for measure relevance
   *   between query and document.
   *   `embedding_field_path`: the document embedding field
   *   used with query embedding vector.
   *   `dotProduct`: embedding function between embedding_field_path and query
   *   embedding vector.
   *
   *  Example ranking expression:
   *    If document has an embedding field doc_embedding, the ranking expression
   *    could be `0.5 * relevance_score + 0.3 * dotProduct(doc_embedding)`.
   * </pre>
   *
   * <code>string ranking_expression = 26;</code>
   *
   * @return The rankingExpression.
   */
  @java.lang.Override
  public java.lang.String getRankingExpression() {
    java.lang.Object ref = rankingExpression_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      rankingExpression_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The ranking expression controls the customized ranking on retrieval
   * documents. This overrides
   * [ServingConfig.ranking_expression][google.cloud.discoveryengine.v1beta.ServingConfig.ranking_expression].
   * The ranking expression is a single function or multiple functions that are
   * joint by "+".
   *   * ranking_expression = function, { " + ", function };
   * Supported functions:
   *   * double * relevance_score
   *   * double * dotProduct(embedding_field_path)
   * Function variables:
   *   `relevance_score`: pre-defined keywords, used for measure relevance
   *   between query and document.
   *   `embedding_field_path`: the document embedding field
   *   used with query embedding vector.
   *   `dotProduct`: embedding function between embedding_field_path and query
   *   embedding vector.
   *
   *  Example ranking expression:
   *    If document has an embedding field doc_embedding, the ranking expression
   *    could be `0.5 * relevance_score + 0.3 * dotProduct(doc_embedding)`.
   * </pre>
   *
   * <code>string ranking_expression = 26;</code>
   *
   * @return The bytes for rankingExpression.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRankingExpressionBytes() {
    java.lang.Object ref = rankingExpression_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      rankingExpression_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SAFE_SEARCH_FIELD_NUMBER = 20;
  private boolean safeSearch_ = false;
  /**
   *
   *
   * <pre>
   * Whether to turn on safe search. This is only supported for
   * website search.
   * </pre>
   *
   * <code>bool safe_search = 20;</code>
   *
   * @return The safeSearch.
   */
  @java.lang.Override
  public boolean getSafeSearch() {
    return safeSearch_;
  }

  public static final int USER_LABELS_FIELD_NUMBER = 22;

  private static final class UserLabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.discoveryengine.v1beta.SearchServiceProto
                .internal_static_google_cloud_discoveryengine_v1beta_SearchRequest_UserLabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> userLabels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetUserLabels() {
    if (userLabels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(UserLabelsDefaultEntryHolder.defaultEntry);
    }
    return userLabels_;
  }

  public int getUserLabelsCount() {
    return internalGetUserLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * The user labels applied to a resource must meet the following requirements:
   *
   * * Each resource can have multiple labels, up to a maximum of 64.
   * * Each label must be a key-value pair.
   * * Keys have a minimum length of 1 character and a maximum length of 63
   *   characters and cannot be empty. Values can be empty and have a maximum
   *   length of 63 characters.
   * * Keys and values can contain only lowercase letters, numeric characters,
   *   underscores, and dashes. All characters must use UTF-8 encoding, and
   *   international characters are allowed.
   * * The key portion of a label must be unique. However, you can use the same
   *   key with multiple resources.
   * * Keys must start with a lowercase letter or international character.
   *
   * See [Google Cloud
   * Document](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
   * for more details.
   * </pre>
   *
   * <code>map&lt;string, string&gt; user_labels = 22;</code>
   */
  @java.lang.Override
  public boolean containsUserLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetUserLabels().getMap().containsKey(key);
  }
  /** Use {@link #getUserLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getUserLabels() {
    return getUserLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * The user labels applied to a resource must meet the following requirements:
   *
   * * Each resource can have multiple labels, up to a maximum of 64.
   * * Each label must be a key-value pair.
   * * Keys have a minimum length of 1 character and a maximum length of 63
   *   characters and cannot be empty. Values can be empty and have a maximum
   *   length of 63 characters.
   * * Keys and values can contain only lowercase letters, numeric characters,
   *   underscores, and dashes. All characters must use UTF-8 encoding, and
   *   international characters are allowed.
   * * The key portion of a label must be unique. However, you can use the same
   *   key with multiple resources.
   * * Keys must start with a lowercase letter or international character.
   *
   * See [Google Cloud
   * Document](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
   * for more details.
   * </pre>
   *
   * <code>map&lt;string, string&gt; user_labels = 22;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getUserLabelsMap() {
    return internalGetUserLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * The user labels applied to a resource must meet the following requirements:
   *
   * * Each resource can have multiple labels, up to a maximum of 64.
   * * Each label must be a key-value pair.
   * * Keys have a minimum length of 1 character and a maximum length of 63
   *   characters and cannot be empty. Values can be empty and have a maximum
   *   length of 63 characters.
   * * Keys and values can contain only lowercase letters, numeric characters,
   *   underscores, and dashes. All characters must use UTF-8 encoding, and
   *   international characters are allowed.
   * * The key portion of a label must be unique. However, you can use the same
   *   key with multiple resources.
   * * Keys must start with a lowercase letter or international character.
   *
   * See [Google Cloud
   * Document](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
   * for more details.
   * </pre>
   *
   * <code>map&lt;string, string&gt; user_labels = 22;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getUserLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetUserLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * The user labels applied to a resource must meet the following requirements:
   *
   * * Each resource can have multiple labels, up to a maximum of 64.
   * * Each label must be a key-value pair.
   * * Keys have a minimum length of 1 character and a maximum length of 63
   *   characters and cannot be empty. Values can be empty and have a maximum
   *   length of 63 characters.
   * * Keys and values can contain only lowercase letters, numeric characters,
   *   underscores, and dashes. All characters must use UTF-8 encoding, and
   *   international characters are allowed.
   * * The key portion of a label must be unique. However, you can use the same
   *   key with multiple resources.
   * * Keys must start with a lowercase letter or international character.
   *
   * See [Google Cloud
   * Document](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
   * for more details.
   * </pre>
   *
   * <code>map&lt;string, string&gt; user_labels = 22;</code>
   */
  @java.lang.Override
  public java.lang.String getUserLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetUserLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(servingConfig_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, servingConfig_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(branch_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, branch_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(query_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, query_);
    }
    if (pageSize_ != 0) {
      output.writeInt32(4, pageSize_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pageToken_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, pageToken_);
    }
    if (offset_ != 0) {
      output.writeInt32(6, offset_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(filter_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, filter_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(orderBy_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, orderBy_);
    }
    for (int i = 0; i < facetSpecs_.size(); i++) {
      output.writeMessage(9, facetSpecs_.get(i));
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(10, getBoostSpec());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetParams(), ParamsDefaultEntryHolder.defaultEntry, 11);
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(13, getQueryExpansionSpec());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeMessage(14, getSpellCorrectionSpec());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(userPseudoId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 15, userPseudoId_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(19, getImageQuery());
    }
    if (safeSearch_ != false) {
      output.writeBool(20, safeSearch_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(21, getUserInfo());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetUserLabels(), UserLabelsDefaultEntryHolder.defaultEntry, 22);
    if (((bitField0_ & 0x00000040) != 0)) {
      output.writeMessage(23, getEmbeddingSpec());
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      output.writeMessage(24, getContentSearchSpec());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(rankingExpression_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 26, rankingExpression_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(canonicalFilter_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 29, canonicalFilter_);
    }
    for (int i = 0; i < dataStoreSpecs_.size(); i++) {
      output.writeMessage(32, dataStoreSpecs_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(servingConfig_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, servingConfig_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(branch_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, branch_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(query_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, query_);
    }
    if (pageSize_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(4, pageSize_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pageToken_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, pageToken_);
    }
    if (offset_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(6, offset_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(filter_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, filter_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(orderBy_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, orderBy_);
    }
    for (int i = 0; i < facetSpecs_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, facetSpecs_.get(i));
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, getBoostSpec());
    }
    for (java.util.Map.Entry<java.lang.String, com.google.protobuf.Value> entry :
        internalGetParams().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, com.google.protobuf.Value> params__ =
          ParamsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(11, params__);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(13, getQueryExpansionSpec());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(14, getSpellCorrectionSpec());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(userPseudoId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(15, userPseudoId_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(19, getImageQuery());
    }
    if (safeSearch_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(20, safeSearch_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(21, getUserInfo());
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetUserLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> userLabels__ =
          UserLabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(22, userLabels__);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(23, getEmbeddingSpec());
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(24, getContentSearchSpec());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(rankingExpression_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(26, rankingExpression_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(canonicalFilter_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(29, canonicalFilter_);
    }
    for (int i = 0; i < dataStoreSpecs_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(32, dataStoreSpecs_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.discoveryengine.v1beta.SearchRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.discoveryengine.v1beta.SearchRequest other =
        (com.google.cloud.discoveryengine.v1beta.SearchRequest) obj;

    if (!getServingConfig().equals(other.getServingConfig())) return false;
    if (!getBranch().equals(other.getBranch())) return false;
    if (!getQuery().equals(other.getQuery())) return false;
    if (hasImageQuery() != other.hasImageQuery()) return false;
    if (hasImageQuery()) {
      if (!getImageQuery().equals(other.getImageQuery())) return false;
    }
    if (getPageSize() != other.getPageSize()) return false;
    if (!getPageToken().equals(other.getPageToken())) return false;
    if (getOffset() != other.getOffset()) return false;
    if (!getDataStoreSpecsList().equals(other.getDataStoreSpecsList())) return false;
    if (!getFilter().equals(other.getFilter())) return false;
    if (!getCanonicalFilter().equals(other.getCanonicalFilter())) return false;
    if (!getOrderBy().equals(other.getOrderBy())) return false;
    if (hasUserInfo() != other.hasUserInfo()) return false;
    if (hasUserInfo()) {
      if (!getUserInfo().equals(other.getUserInfo())) return false;
    }
    if (!getFacetSpecsList().equals(other.getFacetSpecsList())) return false;
    if (hasBoostSpec() != other.hasBoostSpec()) return false;
    if (hasBoostSpec()) {
      if (!getBoostSpec().equals(other.getBoostSpec())) return false;
    }
    if (!internalGetParams().equals(other.internalGetParams())) return false;
    if (hasQueryExpansionSpec() != other.hasQueryExpansionSpec()) return false;
    if (hasQueryExpansionSpec()) {
      if (!getQueryExpansionSpec().equals(other.getQueryExpansionSpec())) return false;
    }
    if (hasSpellCorrectionSpec() != other.hasSpellCorrectionSpec()) return false;
    if (hasSpellCorrectionSpec()) {
      if (!getSpellCorrectionSpec().equals(other.getSpellCorrectionSpec())) return false;
    }
    if (!getUserPseudoId().equals(other.getUserPseudoId())) return false;
    if (hasContentSearchSpec() != other.hasContentSearchSpec()) return false;
    if (hasContentSearchSpec()) {
      if (!getContentSearchSpec().equals(other.getContentSearchSpec())) return false;
    }
    if (hasEmbeddingSpec() != other.hasEmbeddingSpec()) return false;
    if (hasEmbeddingSpec()) {
      if (!getEmbeddingSpec().equals(other.getEmbeddingSpec())) return false;
    }
    if (!getRankingExpression().equals(other.getRankingExpression())) return false;
    if (getSafeSearch() != other.getSafeSearch()) return false;
    if (!internalGetUserLabels().equals(other.internalGetUserLabels())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + SERVING_CONFIG_FIELD_NUMBER;
    hash = (53 * hash) + getServingConfig().hashCode();
    hash = (37 * hash) + BRANCH_FIELD_NUMBER;
    hash = (53 * hash) + getBranch().hashCode();
    hash = (37 * hash) + QUERY_FIELD_NUMBER;
    hash = (53 * hash) + getQuery().hashCode();
    if (hasImageQuery()) {
      hash = (37 * hash) + IMAGE_QUERY_FIELD_NUMBER;
      hash = (53 * hash) + getImageQuery().hashCode();
    }
    hash = (37 * hash) + PAGE_SIZE_FIELD_NUMBER;
    hash = (53 * hash) + getPageSize();
    hash = (37 * hash) + PAGE_TOKEN_FIELD_NUMBER;
    hash = (53 * hash) + getPageToken().hashCode();
    hash = (37 * hash) + OFFSET_FIELD_NUMBER;
    hash = (53 * hash) + getOffset();
    if (getDataStoreSpecsCount() > 0) {
      hash = (37 * hash) + DATA_STORE_SPECS_FIELD_NUMBER;
      hash = (53 * hash) + getDataStoreSpecsList().hashCode();
    }
    hash = (37 * hash) + FILTER_FIELD_NUMBER;
    hash = (53 * hash) + getFilter().hashCode();
    hash = (37 * hash) + CANONICAL_FILTER_FIELD_NUMBER;
    hash = (53 * hash) + getCanonicalFilter().hashCode();
    hash = (37 * hash) + ORDER_BY_FIELD_NUMBER;
    hash = (53 * hash) + getOrderBy().hashCode();
    if (hasUserInfo()) {
      hash = (37 * hash) + USER_INFO_FIELD_NUMBER;
      hash = (53 * hash) + getUserInfo().hashCode();
    }
    if (getFacetSpecsCount() > 0) {
      hash = (37 * hash) + FACET_SPECS_FIELD_NUMBER;
      hash = (53 * hash) + getFacetSpecsList().hashCode();
    }
    if (hasBoostSpec()) {
      hash = (37 * hash) + BOOST_SPEC_FIELD_NUMBER;
      hash = (53 * hash) + getBoostSpec().hashCode();
    }
    if (!internalGetParams().getMap().isEmpty()) {
      hash = (37 * hash) + PARAMS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetParams().hashCode();
    }
    if (hasQueryExpansionSpec()) {
      hash = (37 * hash) + QUERY_EXPANSION_SPEC_FIELD_NUMBER;
      hash = (53 * hash) + getQueryExpansionSpec().hashCode();
    }
    if (hasSpellCorrectionSpec()) {
      hash = (37 * hash) + SPELL_CORRECTION_SPEC_FIELD_NUMBER;
      hash = (53 * hash) + getSpellCorrectionSpec().hashCode();
    }
    hash = (37 * hash) + USER_PSEUDO_ID_FIELD_NUMBER;
    hash = (53 * hash) + getUserPseudoId().hashCode();
    if (hasContentSearchSpec()) {
      hash = (37 * hash) + CONTENT_SEARCH_SPEC_FIELD_NUMBER;
      hash = (53 * hash) + getContentSearchSpec().hashCode();
    }
    if (hasEmbeddingSpec()) {
      hash = (37 * hash) + EMBEDDING_SPEC_FIELD_NUMBER;
      hash = (53 * hash) + getEmbeddingSpec().hashCode();
    }
    hash = (37 * hash) + RANKING_EXPRESSION_FIELD_NUMBER;
    hash = (53 * hash) + getRankingExpression().hashCode();
    hash = (37 * hash) + SAFE_SEARCH_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getSafeSearch());
    if (!internalGetUserLabels().getMap().isEmpty()) {
      hash = (37 * hash) + USER_LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetUserLabels().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.discoveryengine.v1beta.SearchRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1beta.SearchRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.SearchRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1beta.SearchRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.SearchRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1beta.SearchRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.SearchRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1beta.SearchRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.SearchRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1beta.SearchRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.SearchRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1beta.SearchRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.discoveryengine.v1beta.SearchRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request message for
   * [SearchService.Search][google.cloud.discoveryengine.v1beta.SearchService.Search]
   * method.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1beta.SearchRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.SearchRequest)
      com.google.cloud.discoveryengine.v1beta.SearchRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
          .internal_static_google_cloud_discoveryengine_v1beta_SearchRequest_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 11:
          return internalGetParams();
        case 22:
          return internalGetUserLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 11:
          return internalGetMutableParams();
        case 22:
          return internalGetMutableUserLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
          .internal_static_google_cloud_discoveryengine_v1beta_SearchRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1beta.SearchRequest.class,
              com.google.cloud.discoveryengine.v1beta.SearchRequest.Builder.class);
    }

    // Construct using com.google.cloud.discoveryengine.v1beta.SearchRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getImageQueryFieldBuilder();
        getDataStoreSpecsFieldBuilder();
        getUserInfoFieldBuilder();
        getFacetSpecsFieldBuilder();
        getBoostSpecFieldBuilder();
        getQueryExpansionSpecFieldBuilder();
        getSpellCorrectionSpecFieldBuilder();
        getContentSearchSpecFieldBuilder();
        getEmbeddingSpecFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      servingConfig_ = "";
      branch_ = "";
      query_ = "";
      imageQuery_ = null;
      if (imageQueryBuilder_ != null) {
        imageQueryBuilder_.dispose();
        imageQueryBuilder_ = null;
      }
      pageSize_ = 0;
      pageToken_ = "";
      offset_ = 0;
      if (dataStoreSpecsBuilder_ == null) {
        dataStoreSpecs_ = java.util.Collections.emptyList();
      } else {
        dataStoreSpecs_ = null;
        dataStoreSpecsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000080);
      filter_ = "";
      canonicalFilter_ = "";
      orderBy_ = "";
      userInfo_ = null;
      if (userInfoBuilder_ != null) {
        userInfoBuilder_.dispose();
        userInfoBuilder_ = null;
      }
      if (facetSpecsBuilder_ == null) {
        facetSpecs_ = java.util.Collections.emptyList();
      } else {
        facetSpecs_ = null;
        facetSpecsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00001000);
      boostSpec_ = null;
      if (boostSpecBuilder_ != null) {
        boostSpecBuilder_.dispose();
        boostSpecBuilder_ = null;
      }
      internalGetMutableParams().clear();
      queryExpansionSpec_ = null;
      if (queryExpansionSpecBuilder_ != null) {
        queryExpansionSpecBuilder_.dispose();
        queryExpansionSpecBuilder_ = null;
      }
      spellCorrectionSpec_ = null;
      if (spellCorrectionSpecBuilder_ != null) {
        spellCorrectionSpecBuilder_.dispose();
        spellCorrectionSpecBuilder_ = null;
      }
      userPseudoId_ = "";
      contentSearchSpec_ = null;
      if (contentSearchSpecBuilder_ != null) {
        contentSearchSpecBuilder_.dispose();
        contentSearchSpecBuilder_ = null;
      }
      embeddingSpec_ = null;
      if (embeddingSpecBuilder_ != null) {
        embeddingSpecBuilder_.dispose();
        embeddingSpecBuilder_ = null;
      }
      rankingExpression_ = "";
      safeSearch_ = false;
      internalGetMutableUserLabels().clear();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
          .internal_static_google_cloud_discoveryengine_v1beta_SearchRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.SearchRequest getDefaultInstanceForType() {
      return com.google.cloud.discoveryengine.v1beta.SearchRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.SearchRequest build() {
      com.google.cloud.discoveryengine.v1beta.SearchRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.SearchRequest buildPartial() {
      com.google.cloud.discoveryengine.v1beta.SearchRequest result =
          new com.google.cloud.discoveryengine.v1beta.SearchRequest(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.discoveryengine.v1beta.SearchRequest result) {
      if (dataStoreSpecsBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)) {
          dataStoreSpecs_ = java.util.Collections.unmodifiableList(dataStoreSpecs_);
          bitField0_ = (bitField0_ & ~0x00000080);
        }
        result.dataStoreSpecs_ = dataStoreSpecs_;
      } else {
        result.dataStoreSpecs_ = dataStoreSpecsBuilder_.build();
      }
      if (facetSpecsBuilder_ == null) {
        if (((bitField0_ & 0x00001000) != 0)) {
          facetSpecs_ = java.util.Collections.unmodifiableList(facetSpecs_);
          bitField0_ = (bitField0_ & ~0x00001000);
        }
        result.facetSpecs_ = facetSpecs_;
      } else {
        result.facetSpecs_ = facetSpecsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.discoveryengine.v1beta.SearchRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.servingConfig_ = servingConfig_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.branch_ = branch_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.query_ = query_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.imageQuery_ = imageQueryBuilder_ == null ? imageQuery_ : imageQueryBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.pageSize_ = pageSize_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.pageToken_ = pageToken_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.offset_ = offset_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.filter_ = filter_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.canonicalFilter_ = canonicalFilter_;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.orderBy_ = orderBy_;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.userInfo_ = userInfoBuilder_ == null ? userInfo_ : userInfoBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.boostSpec_ = boostSpecBuilder_ == null ? boostSpec_ : boostSpecBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.params_ = internalGetParams().build(ParamsDefaultEntryHolder.defaultEntry);
      }
      if (((from_bitField0_ & 0x00008000) != 0)) {
        result.queryExpansionSpec_ =
            queryExpansionSpecBuilder_ == null
                ? queryExpansionSpec_
                : queryExpansionSpecBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00010000) != 0)) {
        result.spellCorrectionSpec_ =
            spellCorrectionSpecBuilder_ == null
                ? spellCorrectionSpec_
                : spellCorrectionSpecBuilder_.build();
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00020000) != 0)) {
        result.userPseudoId_ = userPseudoId_;
      }
      if (((from_bitField0_ & 0x00040000) != 0)) {
        result.contentSearchSpec_ =
            contentSearchSpecBuilder_ == null
                ? contentSearchSpec_
                : contentSearchSpecBuilder_.build();
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00080000) != 0)) {
        result.embeddingSpec_ =
            embeddingSpecBuilder_ == null ? embeddingSpec_ : embeddingSpecBuilder_.build();
        to_bitField0_ |= 0x00000040;
      }
      if (((from_bitField0_ & 0x00100000) != 0)) {
        result.rankingExpression_ = rankingExpression_;
      }
      if (((from_bitField0_ & 0x00200000) != 0)) {
        result.safeSearch_ = safeSearch_;
      }
      if (((from_bitField0_ & 0x00400000) != 0)) {
        result.userLabels_ = internalGetUserLabels();
        result.userLabels_.makeImmutable();
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.discoveryengine.v1beta.SearchRequest) {
        return mergeFrom((com.google.cloud.discoveryengine.v1beta.SearchRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.discoveryengine.v1beta.SearchRequest other) {
      if (other == com.google.cloud.discoveryengine.v1beta.SearchRequest.getDefaultInstance())
        return this;
      if (!other.getServingConfig().isEmpty()) {
        servingConfig_ = other.servingConfig_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getBranch().isEmpty()) {
        branch_ = other.branch_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getQuery().isEmpty()) {
        query_ = other.query_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasImageQuery()) {
        mergeImageQuery(other.getImageQuery());
      }
      if (other.getPageSize() != 0) {
        setPageSize(other.getPageSize());
      }
      if (!other.getPageToken().isEmpty()) {
        pageToken_ = other.pageToken_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (other.getOffset() != 0) {
        setOffset(other.getOffset());
      }
      if (dataStoreSpecsBuilder_ == null) {
        if (!other.dataStoreSpecs_.isEmpty()) {
          if (dataStoreSpecs_.isEmpty()) {
            dataStoreSpecs_ = other.dataStoreSpecs_;
            bitField0_ = (bitField0_ & ~0x00000080);
          } else {
            ensureDataStoreSpecsIsMutable();
            dataStoreSpecs_.addAll(other.dataStoreSpecs_);
          }
          onChanged();
        }
      } else {
        if (!other.dataStoreSpecs_.isEmpty()) {
          if (dataStoreSpecsBuilder_.isEmpty()) {
            dataStoreSpecsBuilder_.dispose();
            dataStoreSpecsBuilder_ = null;
            dataStoreSpecs_ = other.dataStoreSpecs_;
            bitField0_ = (bitField0_ & ~0x00000080);
            dataStoreSpecsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getDataStoreSpecsFieldBuilder()
                    : null;
          } else {
            dataStoreSpecsBuilder_.addAllMessages(other.dataStoreSpecs_);
          }
        }
      }
      if (!other.getFilter().isEmpty()) {
        filter_ = other.filter_;
        bitField0_ |= 0x00000100;
        onChanged();
      }
      if (!other.getCanonicalFilter().isEmpty()) {
        canonicalFilter_ = other.canonicalFilter_;
        bitField0_ |= 0x00000200;
        onChanged();
      }
      if (!other.getOrderBy().isEmpty()) {
        orderBy_ = other.orderBy_;
        bitField0_ |= 0x00000400;
        onChanged();
      }
      if (other.hasUserInfo()) {
        mergeUserInfo(other.getUserInfo());
      }
      if (facetSpecsBuilder_ == null) {
        if (!other.facetSpecs_.isEmpty()) {
          if (facetSpecs_.isEmpty()) {
            facetSpecs_ = other.facetSpecs_;
            bitField0_ = (bitField0_ & ~0x00001000);
          } else {
            ensureFacetSpecsIsMutable();
            facetSpecs_.addAll(other.facetSpecs_);
          }
          onChanged();
        }
      } else {
        if (!other.facetSpecs_.isEmpty()) {
          if (facetSpecsBuilder_.isEmpty()) {
            facetSpecsBuilder_.dispose();
            facetSpecsBuilder_ = null;
            facetSpecs_ = other.facetSpecs_;
            bitField0_ = (bitField0_ & ~0x00001000);
            facetSpecsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getFacetSpecsFieldBuilder()
                    : null;
          } else {
            facetSpecsBuilder_.addAllMessages(other.facetSpecs_);
          }
        }
      }
      if (other.hasBoostSpec()) {
        mergeBoostSpec(other.getBoostSpec());
      }
      internalGetMutableParams().mergeFrom(other.internalGetParams());
      bitField0_ |= 0x00004000;
      if (other.hasQueryExpansionSpec()) {
        mergeQueryExpansionSpec(other.getQueryExpansionSpec());
      }
      if (other.hasSpellCorrectionSpec()) {
        mergeSpellCorrectionSpec(other.getSpellCorrectionSpec());
      }
      if (!other.getUserPseudoId().isEmpty()) {
        userPseudoId_ = other.userPseudoId_;
        bitField0_ |= 0x00020000;
        onChanged();
      }
      if (other.hasContentSearchSpec()) {
        mergeContentSearchSpec(other.getContentSearchSpec());
      }
      if (other.hasEmbeddingSpec()) {
        mergeEmbeddingSpec(other.getEmbeddingSpec());
      }
      if (!other.getRankingExpression().isEmpty()) {
        rankingExpression_ = other.rankingExpression_;
        bitField0_ |= 0x00100000;
        onChanged();
      }
      if (other.getSafeSearch() != false) {
        setSafeSearch(other.getSafeSearch());
      }
      internalGetMutableUserLabels().mergeFrom(other.internalGetUserLabels());
      bitField0_ |= 0x00400000;
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                servingConfig_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                branch_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                query_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 32:
              {
                pageSize_ = input.readInt32();
                bitField0_ |= 0x00000010;
                break;
              } // case 32
            case 42:
              {
                pageToken_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 42
            case 48:
              {
                offset_ = input.readInt32();
                bitField0_ |= 0x00000040;
                break;
              } // case 48
            case 58:
              {
                filter_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000100;
                break;
              } // case 58
            case 66:
              {
                orderBy_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000400;
                break;
              } // case 66
            case 74:
              {
                com.google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec m =
                    input.readMessage(
                        com.google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.parser(),
                        extensionRegistry);
                if (facetSpecsBuilder_ == null) {
                  ensureFacetSpecsIsMutable();
                  facetSpecs_.add(m);
                } else {
                  facetSpecsBuilder_.addMessage(m);
                }
                break;
              } // case 74
            case 82:
              {
                input.readMessage(getBoostSpecFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00002000;
                break;
              } // case 82
            case 90:
              {
                com.google.protobuf.MapEntry<java.lang.String, com.google.protobuf.Value> params__ =
                    input.readMessage(
                        ParamsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableParams()
                    .ensureBuilderMap()
                    .put(params__.getKey(), params__.getValue());
                bitField0_ |= 0x00004000;
                break;
              } // case 90
            case 106:
              {
                input.readMessage(
                    getQueryExpansionSpecFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00008000;
                break;
              } // case 106
            case 114:
              {
                input.readMessage(
                    getSpellCorrectionSpecFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00010000;
                break;
              } // case 114
            case 122:
              {
                userPseudoId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00020000;
                break;
              } // case 122
            case 154:
              {
                input.readMessage(getImageQueryFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 154
            case 160:
              {
                safeSearch_ = input.readBool();
                bitField0_ |= 0x00200000;
                break;
              } // case 160
            case 170:
              {
                input.readMessage(getUserInfoFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000800;
                break;
              } // case 170
            case 178:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> userLabels__ =
                    input.readMessage(
                        UserLabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableUserLabels()
                    .getMutableMap()
                    .put(userLabels__.getKey(), userLabels__.getValue());
                bitField0_ |= 0x00400000;
                break;
              } // case 178
            case 186:
              {
                input.readMessage(getEmbeddingSpecFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00080000;
                break;
              } // case 186
            case 194:
              {
                input.readMessage(
                    getContentSearchSpecFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00040000;
                break;
              } // case 194
            case 210:
              {
                rankingExpression_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00100000;
                break;
              } // case 210
            case 234:
              {
                canonicalFilter_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000200;
                break;
              } // case 234
            case 258:
              {
                com.google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpec m =
                    input.readMessage(
                        com.google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpec
                            .parser(),
                        extensionRegistry);
                if (dataStoreSpecsBuilder_ == null) {
                  ensureDataStoreSpecsIsMutable();
                  dataStoreSpecs_.add(m);
                } else {
                  dataStoreSpecsBuilder_.addMessage(m);
                }
                break;
              } // case 258
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object servingConfig_ = "";
    /**
     *
     *
     * <pre>
     * Required. The resource name of the Search serving config, such as
     * `projects/&#42;&#47;locations/global/collections/default_collection/engines/&#42;&#47;servingConfigs/default_serving_config`,
     * or
     * `projects/&#42;&#47;locations/global/collections/default_collection/dataStores/default_data_store/servingConfigs/default_serving_config`.
     * This field is used to identify the serving configuration name, set
     * of models used to make the search.
     * </pre>
     *
     * <code>
     * string serving_config = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The servingConfig.
     */
    public java.lang.String getServingConfig() {
      java.lang.Object ref = servingConfig_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        servingConfig_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the Search serving config, such as
     * `projects/&#42;&#47;locations/global/collections/default_collection/engines/&#42;&#47;servingConfigs/default_serving_config`,
     * or
     * `projects/&#42;&#47;locations/global/collections/default_collection/dataStores/default_data_store/servingConfigs/default_serving_config`.
     * This field is used to identify the serving configuration name, set
     * of models used to make the search.
     * </pre>
     *
     * <code>
     * string serving_config = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for servingConfig.
     */
    public com.google.protobuf.ByteString getServingConfigBytes() {
      java.lang.Object ref = servingConfig_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        servingConfig_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the Search serving config, such as
     * `projects/&#42;&#47;locations/global/collections/default_collection/engines/&#42;&#47;servingConfigs/default_serving_config`,
     * or
     * `projects/&#42;&#47;locations/global/collections/default_collection/dataStores/default_data_store/servingConfigs/default_serving_config`.
     * This field is used to identify the serving configuration name, set
     * of models used to make the search.
     * </pre>
     *
     * <code>
     * string serving_config = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The servingConfig to set.
     * @return This builder for chaining.
     */
    public Builder setServingConfig(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      servingConfig_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the Search serving config, such as
     * `projects/&#42;&#47;locations/global/collections/default_collection/engines/&#42;&#47;servingConfigs/default_serving_config`,
     * or
     * `projects/&#42;&#47;locations/global/collections/default_collection/dataStores/default_data_store/servingConfigs/default_serving_config`.
     * This field is used to identify the serving configuration name, set
     * of models used to make the search.
     * </pre>
     *
     * <code>
     * string serving_config = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearServingConfig() {
      servingConfig_ = getDefaultInstance().getServingConfig();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the Search serving config, such as
     * `projects/&#42;&#47;locations/global/collections/default_collection/engines/&#42;&#47;servingConfigs/default_serving_config`,
     * or
     * `projects/&#42;&#47;locations/global/collections/default_collection/dataStores/default_data_store/servingConfigs/default_serving_config`.
     * This field is used to identify the serving configuration name, set
     * of models used to make the search.
     * </pre>
     *
     * <code>
     * string serving_config = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for servingConfig to set.
     * @return This builder for chaining.
     */
    public Builder setServingConfigBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      servingConfig_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object branch_ = "";
    /**
     *
     *
     * <pre>
     * The branch resource name, such as
     * `projects/&#42;&#47;locations/global/collections/default_collection/dataStores/default_data_store/branches/0`.
     *
     * Use `default_branch` as the branch ID or leave this field empty, to search
     * documents under the default branch.
     * </pre>
     *
     * <code>string branch = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The branch.
     */
    public java.lang.String getBranch() {
      java.lang.Object ref = branch_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        branch_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The branch resource name, such as
     * `projects/&#42;&#47;locations/global/collections/default_collection/dataStores/default_data_store/branches/0`.
     *
     * Use `default_branch` as the branch ID or leave this field empty, to search
     * documents under the default branch.
     * </pre>
     *
     * <code>string branch = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for branch.
     */
    public com.google.protobuf.ByteString getBranchBytes() {
      java.lang.Object ref = branch_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        branch_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The branch resource name, such as
     * `projects/&#42;&#47;locations/global/collections/default_collection/dataStores/default_data_store/branches/0`.
     *
     * Use `default_branch` as the branch ID or leave this field empty, to search
     * documents under the default branch.
     * </pre>
     *
     * <code>string branch = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The branch to set.
     * @return This builder for chaining.
     */
    public Builder setBranch(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      branch_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The branch resource name, such as
     * `projects/&#42;&#47;locations/global/collections/default_collection/dataStores/default_data_store/branches/0`.
     *
     * Use `default_branch` as the branch ID or leave this field empty, to search
     * documents under the default branch.
     * </pre>
     *
     * <code>string branch = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBranch() {
      branch_ = getDefaultInstance().getBranch();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The branch resource name, such as
     * `projects/&#42;&#47;locations/global/collections/default_collection/dataStores/default_data_store/branches/0`.
     *
     * Use `default_branch` as the branch ID or leave this field empty, to search
     * documents under the default branch.
     * </pre>
     *
     * <code>string branch = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The bytes for branch to set.
     * @return This builder for chaining.
     */
    public Builder setBranchBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      branch_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object query_ = "";
    /**
     *
     *
     * <pre>
     * Raw search query.
     * </pre>
     *
     * <code>string query = 3;</code>
     *
     * @return The query.
     */
    public java.lang.String getQuery() {
      java.lang.Object ref = query_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        query_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Raw search query.
     * </pre>
     *
     * <code>string query = 3;</code>
     *
     * @return The bytes for query.
     */
    public com.google.protobuf.ByteString getQueryBytes() {
      java.lang.Object ref = query_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        query_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Raw search query.
     * </pre>
     *
     * <code>string query = 3;</code>
     *
     * @param value The query to set.
     * @return This builder for chaining.
     */
    public Builder setQuery(java.lang.St