/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/discoveryengine/v1beta/control.proto

// Protobuf Java Version: 3.25.3
package com.google.cloud.discoveryengine.v1beta;

/**
 *
 *
 * <pre>
 * Defines a conditioned behavior to employ during serving.
 * Must be attached to a
 * [ServingConfig][google.cloud.discoveryengine.v1beta.ServingConfig] to be
 * considered at serving time. Permitted actions dependent on `SolutionType`.
 * </pre>
 *
 * Protobuf type {@code google.cloud.discoveryengine.v1beta.Control}
 */
public final class Control extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.Control)
    ControlOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Control.newBuilder() to construct.
  private Control(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Control() {
    name_ = "";
    displayName_ = "";
    associatedServingConfigIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
    solutionType_ = 0;
    useCases_ = java.util.Collections.emptyList();
    conditions_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Control();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.discoveryengine.v1beta.ControlProto
        .internal_static_google_cloud_discoveryengine_v1beta_Control_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.discoveryengine.v1beta.ControlProto
        .internal_static_google_cloud_discoveryengine_v1beta_Control_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.discoveryengine.v1beta.Control.class,
            com.google.cloud.discoveryengine.v1beta.Control.Builder.class);
  }

  public interface BoostActionOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1beta.Control.BoostAction)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. Strength of the boost, which should be in [-1, 1]. Negative
     * boost means demotion. Default is 0.0 (No-op).
     * </pre>
     *
     * <code>float boost = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The boost.
     */
    float getBoost();

    /**
     *
     *
     * <pre>
     * Required. Specifies which products to apply the boost to.
     *
     * If no filter is provided all products will be boosted (No-op).
     * Syntax documentation:
     * https://cloud.google.com/retail/docs/filter-and-order
     * Maximum length is 5000 characters.
     * Otherwise an INVALID ARGUMENT error is thrown.
     * </pre>
     *
     * <code>string filter = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The filter.
     */
    java.lang.String getFilter();
    /**
     *
     *
     * <pre>
     * Required. Specifies which products to apply the boost to.
     *
     * If no filter is provided all products will be boosted (No-op).
     * Syntax documentation:
     * https://cloud.google.com/retail/docs/filter-and-order
     * Maximum length is 5000 characters.
     * Otherwise an INVALID ARGUMENT error is thrown.
     * </pre>
     *
     * <code>string filter = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for filter.
     */
    com.google.protobuf.ByteString getFilterBytes();

    /**
     *
     *
     * <pre>
     * Required. Specifies which data store's documents can be boosted by this
     * control. Full data store name e.g.
     * projects/123/locations/global/collections/default_collection/dataStores/default_data_store
     * </pre>
     *
     * <code>
     * string data_store = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The dataStore.
     */
    java.lang.String getDataStore();
    /**
     *
     *
     * <pre>
     * Required. Specifies which data store's documents can be boosted by this
     * control. Full data store name e.g.
     * projects/123/locations/global/collections/default_collection/dataStores/default_data_store
     * </pre>
     *
     * <code>
     * string data_store = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for dataStore.
     */
    com.google.protobuf.ByteString getDataStoreBytes();
  }
  /**
   *
   *
   * <pre>
   * Adjusts order of products in returned list.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1beta.Control.BoostAction}
   */
  public static final class BoostAction extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.Control.BoostAction)
      BoostActionOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use BoostAction.newBuilder() to construct.
    private BoostAction(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private BoostAction() {
      filter_ = "";
      dataStore_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new BoostAction();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1beta.ControlProto
          .internal_static_google_cloud_discoveryengine_v1beta_Control_BoostAction_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1beta.ControlProto
          .internal_static_google_cloud_discoveryengine_v1beta_Control_BoostAction_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1beta.Control.BoostAction.class,
              com.google.cloud.discoveryengine.v1beta.Control.BoostAction.Builder.class);
    }

    public static final int BOOST_FIELD_NUMBER = 1;
    private float boost_ = 0F;
    /**
     *
     *
     * <pre>
     * Required. Strength of the boost, which should be in [-1, 1]. Negative
     * boost means demotion. Default is 0.0 (No-op).
     * </pre>
     *
     * <code>float boost = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The boost.
     */
    @java.lang.Override
    public float getBoost() {
      return boost_;
    }

    public static final int FILTER_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object filter_ = "";
    /**
     *
     *
     * <pre>
     * Required. Specifies which products to apply the boost to.
     *
     * If no filter is provided all products will be boosted (No-op).
     * Syntax documentation:
     * https://cloud.google.com/retail/docs/filter-and-order
     * Maximum length is 5000 characters.
     * Otherwise an INVALID ARGUMENT error is thrown.
     * </pre>
     *
     * <code>string filter = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The filter.
     */
    @java.lang.Override
    public java.lang.String getFilter() {
      java.lang.Object ref = filter_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        filter_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Specifies which products to apply the boost to.
     *
     * If no filter is provided all products will be boosted (No-op).
     * Syntax documentation:
     * https://cloud.google.com/retail/docs/filter-and-order
     * Maximum length is 5000 characters.
     * Otherwise an INVALID ARGUMENT error is thrown.
     * </pre>
     *
     * <code>string filter = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for filter.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getFilterBytes() {
      java.lang.Object ref = filter_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        filter_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int DATA_STORE_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private volatile java.lang.Object dataStore_ = "";
    /**
     *
     *
     * <pre>
     * Required. Specifies which data store's documents can be boosted by this
     * control. Full data store name e.g.
     * projects/123/locations/global/collections/default_collection/dataStores/default_data_store
     * </pre>
     *
     * <code>
     * string data_store = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The dataStore.
     */
    @java.lang.Override
    public java.lang.String getDataStore() {
      java.lang.Object ref = dataStore_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        dataStore_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Specifies which data store's documents can be boosted by this
     * control. Full data store name e.g.
     * projects/123/locations/global/collections/default_collection/dataStores/default_data_store
     * </pre>
     *
     * <code>
     * string data_store = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for dataStore.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getDataStoreBytes() {
      java.lang.Object ref = dataStore_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        dataStore_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (java.lang.Float.floatToRawIntBits(boost_) != 0) {
        output.writeFloat(1, boost_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(filter_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, filter_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dataStore_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, dataStore_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (java.lang.Float.floatToRawIntBits(boost_) != 0) {
        size += com.google.protobuf.CodedOutputStream.computeFloatSize(1, boost_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(filter_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, filter_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dataStore_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, dataStore_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.discoveryengine.v1beta.Control.BoostAction)) {
        return super.equals(obj);
      }
      com.google.cloud.discoveryengine.v1beta.Control.BoostAction other =
          (com.google.cloud.discoveryengine.v1beta.Control.BoostAction) obj;

      if (java.lang.Float.floatToIntBits(getBoost())
          != java.lang.Float.floatToIntBits(other.getBoost())) return false;
      if (!getFilter().equals(other.getFilter())) return false;
      if (!getDataStore().equals(other.getDataStore())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + BOOST_FIELD_NUMBER;
      hash = (53 * hash) + java.lang.Float.floatToIntBits(getBoost());
      hash = (37 * hash) + FILTER_FIELD_NUMBER;
      hash = (53 * hash) + getFilter().hashCode();
      hash = (37 * hash) + DATA_STORE_FIELD_NUMBER;
      hash = (53 * hash) + getDataStore().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.discoveryengine.v1beta.Control.BoostAction parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.Control.BoostAction parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.Control.BoostAction parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.Control.BoostAction parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.Control.BoostAction parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.Control.BoostAction parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.Control.BoostAction parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.Control.BoostAction parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.Control.BoostAction parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.Control.BoostAction parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.Control.BoostAction parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.Control.BoostAction parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.discoveryengine.v1beta.Control.BoostAction prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Adjusts order of products in returned list.
     * </pre>
     *
     * Protobuf type {@code google.cloud.discoveryengine.v1beta.Control.BoostAction}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.Control.BoostAction)
        com.google.cloud.discoveryengine.v1beta.Control.BoostActionOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1beta.ControlProto
            .internal_static_google_cloud_discoveryengine_v1beta_Control_BoostAction_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1beta.ControlProto
            .internal_static_google_cloud_discoveryengine_v1beta_Control_BoostAction_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1beta.Control.BoostAction.class,
                com.google.cloud.discoveryengine.v1beta.Control.BoostAction.Builder.class);
      }

      // Construct using com.google.cloud.discoveryengine.v1beta.Control.BoostAction.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        boost_ = 0F;
        filter_ = "";
        dataStore_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.discoveryengine.v1beta.ControlProto
            .internal_static_google_cloud_discoveryengine_v1beta_Control_BoostAction_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.Control.BoostAction
          getDefaultInstanceForType() {
        return com.google.cloud.discoveryengine.v1beta.Control.BoostAction.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.Control.BoostAction build() {
        com.google.cloud.discoveryengine.v1beta.Control.BoostAction result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.Control.BoostAction buildPartial() {
        com.google.cloud.discoveryengine.v1beta.Control.BoostAction result =
            new com.google.cloud.discoveryengine.v1beta.Control.BoostAction(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.discoveryengine.v1beta.Control.BoostAction result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.boost_ = boost_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.filter_ = filter_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.dataStore_ = dataStore_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.discoveryengine.v1beta.Control.BoostAction) {
          return mergeFrom((com.google.cloud.discoveryengine.v1beta.Control.BoostAction) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.discoveryengine.v1beta.Control.BoostAction other) {
        if (other
            == com.google.cloud.discoveryengine.v1beta.Control.BoostAction.getDefaultInstance())
          return this;
        if (other.getBoost() != 0F) {
          setBoost(other.getBoost());
        }
        if (!other.getFilter().isEmpty()) {
          filter_ = other.filter_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (!other.getDataStore().isEmpty()) {
          dataStore_ = other.dataStore_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 13:
                {
                  boost_ = input.readFloat();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 13
              case 18:
                {
                  filter_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  dataStore_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private float boost_;
      /**
       *
       *
       * <pre>
       * Required. Strength of the boost, which should be in [-1, 1]. Negative
       * boost means demotion. Default is 0.0 (No-op).
       * </pre>
       *
       * <code>float boost = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The boost.
       */
      @java.lang.Override
      public float getBoost() {
        return boost_;
      }
      /**
       *
       *
       * <pre>
       * Required. Strength of the boost, which should be in [-1, 1]. Negative
       * boost means demotion. Default is 0.0 (No-op).
       * </pre>
       *
       * <code>float boost = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The boost to set.
       * @return This builder for chaining.
       */
      public Builder setBoost(float value) {

        boost_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Strength of the boost, which should be in [-1, 1]. Negative
       * boost means demotion. Default is 0.0 (No-op).
       * </pre>
       *
       * <code>float boost = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearBoost() {
        bitField0_ = (bitField0_ & ~0x00000001);
        boost_ = 0F;
        onChanged();
        return this;
      }

      private java.lang.Object filter_ = "";
      /**
       *
       *
       * <pre>
       * Required. Specifies which products to apply the boost to.
       *
       * If no filter is provided all products will be boosted (No-op).
       * Syntax documentation:
       * https://cloud.google.com/retail/docs/filter-and-order
       * Maximum length is 5000 characters.
       * Otherwise an INVALID ARGUMENT error is thrown.
       * </pre>
       *
       * <code>string filter = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The filter.
       */
      public java.lang.String getFilter() {
        java.lang.Object ref = filter_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          filter_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Specifies which products to apply the boost to.
       *
       * If no filter is provided all products will be boosted (No-op).
       * Syntax documentation:
       * https://cloud.google.com/retail/docs/filter-and-order
       * Maximum length is 5000 characters.
       * Otherwise an INVALID ARGUMENT error is thrown.
       * </pre>
       *
       * <code>string filter = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for filter.
       */
      public com.google.protobuf.ByteString getFilterBytes() {
        java.lang.Object ref = filter_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          filter_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Specifies which products to apply the boost to.
       *
       * If no filter is provided all products will be boosted (No-op).
       * Syntax documentation:
       * https://cloud.google.com/retail/docs/filter-and-order
       * Maximum length is 5000 characters.
       * Otherwise an INVALID ARGUMENT error is thrown.
       * </pre>
       *
       * <code>string filter = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The filter to set.
       * @return This builder for chaining.
       */
      public Builder setFilter(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        filter_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Specifies which products to apply the boost to.
       *
       * If no filter is provided all products will be boosted (No-op).
       * Syntax documentation:
       * https://cloud.google.com/retail/docs/filter-and-order
       * Maximum length is 5000 characters.
       * Otherwise an INVALID ARGUMENT error is thrown.
       * </pre>
       *
       * <code>string filter = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearFilter() {
        filter_ = getDefaultInstance().getFilter();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Specifies which products to apply the boost to.
       *
       * If no filter is provided all products will be boosted (No-op).
       * Syntax documentation:
       * https://cloud.google.com/retail/docs/filter-and-order
       * Maximum length is 5000 characters.
       * Otherwise an INVALID ARGUMENT error is thrown.
       * </pre>
       *
       * <code>string filter = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for filter to set.
       * @return This builder for chaining.
       */
      public Builder setFilterBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        filter_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private java.lang.Object dataStore_ = "";
      /**
       *
       *
       * <pre>
       * Required. Specifies which data store's documents can be boosted by this
       * control. Full data store name e.g.
       * projects/123/locations/global/collections/default_collection/dataStores/default_data_store
       * </pre>
       *
       * <code>
       * string data_store = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The dataStore.
       */
      public java.lang.String getDataStore() {
        java.lang.Object ref = dataStore_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          dataStore_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Specifies which data store's documents can be boosted by this
       * control. Full data store name e.g.
       * projects/123/locations/global/collections/default_collection/dataStores/default_data_store
       * </pre>
       *
       * <code>
       * string data_store = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The bytes for dataStore.
       */
      public com.google.protobuf.ByteString getDataStoreBytes() {
        java.lang.Object ref = dataStore_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          dataStore_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Specifies which data store's documents can be boosted by this
       * control. Full data store name e.g.
       * projects/123/locations/global/collections/default_collection/dataStores/default_data_store
       * </pre>
       *
       * <code>
       * string data_store = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The dataStore to set.
       * @return This builder for chaining.
       */
      public Builder setDataStore(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        dataStore_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Specifies which data store's documents can be boosted by this
       * control. Full data store name e.g.
       * projects/123/locations/global/collections/default_collection/dataStores/default_data_store
       * </pre>
       *
       * <code>
       * string data_store = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDataStore() {
        dataStore_ = getDefaultInstance().getDataStore();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Specifies which data store's documents can be boosted by this
       * control. Full data store name e.g.
       * projects/123/locations/global/collections/default_collection/dataStores/default_data_store
       * </pre>
       *
       * <code>
       * string data_store = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The bytes for dataStore to set.
       * @return This builder for chaining.
       */
      public Builder setDataStoreBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        dataStore_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.Control.BoostAction)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.Control.BoostAction)
    private static final com.google.cloud.discoveryengine.v1beta.Control.BoostAction
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.discoveryengine.v1beta.Control.BoostAction();
    }

    public static com.google.cloud.discoveryengine.v1beta.Control.BoostAction getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<BoostAction> PARSER =
        new com.google.protobuf.AbstractParser<BoostAction>() {
          @java.lang.Override
          public BoostAction parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<BoostAction> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<BoostAction> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.Control.BoostAction getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface FilterActionOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1beta.Control.FilterAction)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. A filter to apply on the matching condition results.
     *
     * Required
     * Syntax documentation:
     * https://cloud.google.com/retail/docs/filter-and-order
     * Maximum length is 5000 characters. Otherwise an INVALID
     * ARGUMENT error is thrown.
     * </pre>
     *
     * <code>string filter = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The filter.
     */
    java.lang.String getFilter();
    /**
     *
     *
     * <pre>
     * Required. A filter to apply on the matching condition results.
     *
     * Required
     * Syntax documentation:
     * https://cloud.google.com/retail/docs/filter-and-order
     * Maximum length is 5000 characters. Otherwise an INVALID
     * ARGUMENT error is thrown.
     * </pre>
     *
     * <code>string filter = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for filter.
     */
    com.google.protobuf.ByteString getFilterBytes();

    /**
     *
     *
     * <pre>
     * Required. Specifies which data store's documents can be filtered by this
     * control. Full data store name e.g.
     * projects/123/locations/global/collections/default_collection/dataStores/default_data_store
     * </pre>
     *
     * <code>
     * string data_store = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The dataStore.
     */
    java.lang.String getDataStore();
    /**
     *
     *
     * <pre>
     * Required. Specifies which data store's documents can be filtered by this
     * control. Full data store name e.g.
     * projects/123/locations/global/collections/default_collection/dataStores/default_data_store
     * </pre>
     *
     * <code>
     * string data_store = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for dataStore.
     */
    com.google.protobuf.ByteString getDataStoreBytes();
  }
  /**
   *
   *
   * <pre>
   * Specified which products may be included in results.
   * Uses same filter as boost.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1beta.Control.FilterAction}
   */
  public static final class FilterAction extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.Control.FilterAction)
      FilterActionOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use FilterAction.newBuilder() to construct.
    private FilterAction(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private FilterAction() {
      filter_ = "";
      dataStore_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new FilterAction();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1beta.ControlProto
          .internal_static_google_cloud_discoveryengine_v1beta_Control_FilterAction_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1beta.ControlProto
          .internal_static_google_cloud_discoveryengine_v1beta_Control_FilterAction_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1beta.Control.FilterAction.class,
              com.google.cloud.discoveryengine.v1beta.Control.FilterAction.Builder.class);
    }

    public static final int FILTER_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object filter_ = "";
    /**
     *
     *
     * <pre>
     * Required. A filter to apply on the matching condition results.
     *
     * Required
     * Syntax documentation:
     * https://cloud.google.com/retail/docs/filter-and-order
     * Maximum length is 5000 characters. Otherwise an INVALID
     * ARGUMENT error is thrown.
     * </pre>
     *
     * <code>string filter = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The filter.
     */
    @java.lang.Override
    public java.lang.String getFilter() {
      java.lang.Object ref = filter_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        filter_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. A filter to apply on the matching condition results.
     *
     * Required
     * Syntax documentation:
     * https://cloud.google.com/retail/docs/filter-and-order
     * Maximum length is 5000 characters. Otherwise an INVALID
     * ARGUMENT error is thrown.
     * </pre>
     *
     * <code>string filter = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for filter.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getFilterBytes() {
      java.lang.Object ref = filter_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        filter_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int DATA_STORE_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object dataStore_ = "";
    /**
     *
     *
     * <pre>
     * Required. Specifies which data store's documents can be filtered by this
     * control. Full data store name e.g.
     * projects/123/locations/global/collections/default_collection/dataStores/default_data_store
     * </pre>
     *
     * <code>
     * string data_store = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The dataStore.
     */
    @java.lang.Override
    public java.lang.String getDataStore() {
      java.lang.Object ref = dataStore_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        dataStore_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Specifies which data store's documents can be filtered by this
     * control. Full data store name e.g.
     * projects/123/locations/global/collections/default_collection/dataStores/default_data_store
     * </pre>
     *
     * <code>
     * string data_store = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for dataStore.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getDataStoreBytes() {
      java.lang.Object ref = dataStore_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        dataStore_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(filter_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, filter_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dataStore_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, dataStore_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(filter_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, filter_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dataStore_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, dataStore_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.discoveryengine.v1beta.Control.FilterAction)) {
        return super.equals(obj);
      }
      com.google.cloud.discoveryengine.v1beta.Control.FilterAction other =
          (com.google.cloud.discoveryengine.v1beta.Control.FilterAction) obj;

      if (!getFilter().equals(other.getFilter())) return false;
      if (!getDataStore().equals(other.getDataStore())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + FILTER_FIELD_NUMBER;
      hash = (53 * hash) + getFilter().hashCode();
      hash = (37 * hash) + DATA_STORE_FIELD_NUMBER;
      hash = (53 * hash) + getDataStore().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.discoveryengine.v1beta.Control.FilterAction parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.Control.FilterAction parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.Control.FilterAction parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.Control.FilterAction parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.Control.FilterAction parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.Control.FilterAction parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.Control.FilterAction parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.Control.FilterAction parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.Control.FilterAction parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.Control.FilterAction parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.Control.FilterAction parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.Control.FilterAction parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.discoveryengine.v1beta.Control.FilterAction prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Specified which products may be included in results.
     * Uses same filter as boost.
     * </pre>
     *
     * Protobuf type {@code google.cloud.discoveryengine.v1beta.Control.FilterAction}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.Control.FilterAction)
        com.google.cloud.discoveryengine.v1beta.Control.FilterActionOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1beta.ControlProto
            .internal_static_google_cloud_discoveryengine_v1beta_Control_FilterAction_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1beta.ControlProto
            .internal_static_google_cloud_discoveryengine_v1beta_Control_FilterAction_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1beta.Control.FilterAction.class,
                com.google.cloud.discoveryengine.v1beta.Control.FilterAction.Builder.class);
      }

      // Construct using com.google.cloud.discoveryengine.v1beta.Control.FilterAction.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        filter_ = "";
        dataStore_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.discoveryengine.v1beta.ControlProto
            .internal_static_google_cloud_discoveryengine_v1beta_Control_FilterAction_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.Control.FilterAction
          getDefaultInstanceForType() {
        return com.google.cloud.discoveryengine.v1beta.Control.FilterAction.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.Control.FilterAction build() {
        com.google.cloud.discoveryengine.v1beta.Control.FilterAction result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.Control.FilterAction buildPartial() {
        com.google.cloud.discoveryengine.v1beta.Control.FilterAction result =
            new com.google.cloud.discoveryengine.v1beta.Control.FilterAction(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.discoveryengine.v1beta.Control.FilterAction result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.filter_ = filter_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.dataStore_ = dataStore_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.discoveryengine.v1beta.Control.FilterAction) {
          return mergeFrom((com.google.cloud.discoveryengine.v1beta.Control.FilterAction) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.discoveryengine.v1beta.Control.FilterAction other) {
        if (other
            == com.google.cloud.discoveryengine.v1beta.Control.FilterAction.getDefaultInstance())
          return this;
        if (!other.getFilter().isEmpty()) {
          filter_ = other.filter_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getDataStore().isEmpty()) {
          dataStore_ = other.dataStore_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  filter_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  dataStore_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object filter_ = "";
      /**
       *
       *
       * <pre>
       * Required. A filter to apply on the matching condition results.
       *
       * Required
       * Syntax documentation:
       * https://cloud.google.com/retail/docs/filter-and-order
       * Maximum length is 5000 characters. Otherwise an INVALID
       * ARGUMENT error is thrown.
       * </pre>
       *
       * <code>string filter = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The filter.
       */
      public java.lang.String getFilter() {
        java.lang.Object ref = filter_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          filter_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. A filter to apply on the matching condition results.
       *
       * Required
       * Syntax documentation:
       * https://cloud.google.com/retail/docs/filter-and-order
       * Maximum length is 5000 characters. Otherwise an INVALID
       * ARGUMENT error is thrown.
       * </pre>
       *
       * <code>string filter = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for filter.
       */
      public com.google.protobuf.ByteString getFilterBytes() {
        java.lang.Object ref = filter_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          filter_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. A filter to apply on the matching condition results.
       *
       * Required
       * Syntax documentation:
       * https://cloud.google.com/retail/docs/filter-and-order
       * Maximum length is 5000 characters. Otherwise an INVALID
       * ARGUMENT error is thrown.
       * </pre>
       *
       * <code>string filter = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The filter to set.
       * @return This builder for chaining.
       */
      public Builder setFilter(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        filter_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. A filter to apply on the matching condition results.
       *
       * Required
       * Syntax documentation:
       * https://cloud.google.com/retail/docs/filter-and-order
       * Maximum length is 5000 characters. Otherwise an INVALID
       * ARGUMENT error is thrown.
       * </pre>
       *
       * <code>string filter = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearFilter() {
        filter_ = getDefaultInstance().getFilter();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. A filter to apply on the matching condition results.
       *
       * Required
       * Syntax documentation:
       * https://cloud.google.com/retail/docs/filter-and-order
       * Maximum length is 5000 characters. Otherwise an INVALID
       * ARGUMENT error is thrown.
       * </pre>
       *
       * <code>string filter = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for filter to set.
       * @return This builder for chaining.
       */
      public Builder setFilterBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        filter_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object dataStore_ = "";
      /**
       *
       *
       * <pre>
       * Required. Specifies which data store's documents can be filtered by this
       * control. Full data store name e.g.
       * projects/123/locations/global/collections/default_collection/dataStores/default_data_store
       * </pre>
       *
       * <code>
       * string data_store = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The dataStore.
       */
      public java.lang.String getDataStore() {
        java.lang.Object ref = dataStore_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          dataStore_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Specifies which data store's documents can be filtered by this
       * control. Full data store name e.g.
       * projects/123/locations/global/collections/default_collection/dataStores/default_data_store
       * </pre>
       *
       * <code>
       * string data_store = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The bytes for dataStore.
       */
      public com.google.protobuf.ByteString getDataStoreBytes() {
        java.lang.Object ref = dataStore_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          dataStore_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Specifies which data store's documents can be filtered by this
       * control. Full data store name e.g.
       * projects/123/locations/global/collections/default_collection/dataStores/default_data_store
       * </pre>
       *
       * <code>
       * string data_store = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The dataStore to set.
       * @return This builder for chaining.
       */
      public Builder setDataStore(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        dataStore_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Specifies which data store's documents can be filtered by this
       * control. Full data store name e.g.
       * projects/123/locations/global/collections/default_collection/dataStores/default_data_store
       * </pre>
       *
       * <code>
       * string data_store = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDataStore() {
        dataStore_ = getDefaultInstance().getDataStore();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Specifies which data store's documents can be filtered by this
       * control. Full data store name e.g.
       * projects/123/locations/global/collections/default_collection/dataStores/default_data_store
       * </pre>
       *
       * <code>
       * string data_store = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The bytes for dataStore to set.
       * @return This builder for chaining.
       */
      public Builder setDataStoreBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        dataStore_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.Control.FilterAction)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.Control.FilterAction)
    private static final com.google.cloud.discoveryengine.v1beta.Control.FilterAction
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.discoveryengine.v1beta.Control.FilterAction();
    }

    public static com.google.cloud.discoveryengine.v1beta.Control.FilterAction
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<FilterAction> PARSER =
        new com.google.protobuf.AbstractParser<FilterAction>() {
          @java.lang.Override
          public FilterAction parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<FilterAction> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<FilterAction> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.Control.FilterAction
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface RedirectActionOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1beta.Control.RedirectAction)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. The URI to which the shopper will be redirected.
     *
     * Required.
     * URI must have length equal or less than 2000 characters.
     * Otherwise an INVALID ARGUMENT error is thrown.
     * </pre>
     *
     * <code>string redirect_uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The redirectUri.
     */
    java.lang.String getRedirectUri();
    /**
     *
     *
     * <pre>
     * Required. The URI to which the shopper will be redirected.
     *
     * Required.
     * URI must have length equal or less than 2000 characters.
     * Otherwise an INVALID ARGUMENT error is thrown.
     * </pre>
     *
     * <code>string redirect_uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for redirectUri.
     */
    com.google.protobuf.ByteString getRedirectUriBytes();
  }
  /**
   *
   *
   * <pre>
   * Redirects a shopper to the provided URI.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1beta.Control.RedirectAction}
   */
  public static final class RedirectAction extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.Control.RedirectAction)
      RedirectActionOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use RedirectAction.newBuilder() to construct.
    private RedirectAction(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private RedirectAction() {
      redirectUri_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new RedirectAction();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1beta.ControlProto
          .internal_static_google_cloud_discoveryengine_v1beta_Control_RedirectAction_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1beta.ControlProto
          .internal_static_google_cloud_discoveryengine_v1beta_Control_RedirectAction_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1beta.Control.RedirectAction.class,
              com.google.cloud.discoveryengine.v1beta.Control.RedirectAction.Builder.class);
    }

    public static final int REDIRECT_URI_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object redirectUri_ = "";
    /**
     *
     *
     * <pre>
     * Required. The URI to which the shopper will be redirected.
     *
     * Required.
     * URI must have length equal or less than 2000 characters.
     * Otherwise an INVALID ARGUMENT error is thrown.
     * </pre>
     *
     * <code>string redirect_uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The redirectUri.
     */
    @java.lang.Override
    public java.lang.String getRedirectUri() {
      java.lang.Object ref = redirectUri_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        redirectUri_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The URI to which the shopper will be redirected.
     *
     * Required.
     * URI must have length equal or less than 2000 characters.
     * Otherwise an INVALID ARGUMENT error is thrown.
     * </pre>
     *
     * <code>string redirect_uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for redirectUri.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getRedirectUriBytes() {
      java.lang.Object ref = redirectUri_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        redirectUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(redirectUri_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, redirectUri_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(redirectUri_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, redirectUri_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.discoveryengine.v1beta.Control.RedirectAction)) {
        return super.equals(obj);
      }
      com.google.cloud.discoveryengine.v1beta.Control.RedirectAction other =
          (com.google.cloud.discoveryengine.v1beta.Control.RedirectAction) obj;

      if (!getRedirectUri().equals(other.getRedirectUri())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + REDIRECT_URI_FIELD_NUMBER;
      hash = (53 * hash) + getRedirectUri().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.discoveryengine.v1beta.Control.RedirectAction parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.Control.RedirectAction parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.Control.RedirectAction parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.Control.RedirectAction parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.Control.RedirectAction parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.Control.RedirectAction parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.Control.RedirectAction parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.Control.RedirectAction parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.Control.RedirectAction parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.Control.RedirectAction parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.Control.RedirectAction parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.Control.RedirectAction parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.discoveryengine.v1beta.Control.RedirectAction prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Redirects a shopper to the provided URI.
     * </pre>
     *
     * Protobuf type {@code google.cloud.discoveryengine.v1beta.Control.RedirectAction}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.Control.RedirectAction)
        com.google.cloud.discoveryengine.v1beta.Control.RedirectActionOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1beta.ControlProto
            .internal_static_google_cloud_discoveryengine_v1beta_Control_RedirectAction_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1beta.ControlProto
            .internal_static_google_cloud_discoveryengine_v1beta_Control_RedirectAction_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1beta.Control.RedirectAction.class,
                com.google.cloud.discoveryengine.v1beta.Control.RedirectAction.Builder.class);
      }

      // Construct using com.google.cloud.discoveryengine.v1beta.Control.RedirectAction.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        redirectUri_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.discoveryengine.v1beta.ControlProto
            .internal_static_google_cloud_discoveryengine_v1beta_Control_RedirectAction_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.Control.RedirectAction
          getDefaultInstanceForType() {
        return com.google.cloud.discoveryengine.v1beta.Control.RedirectAction.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.Control.RedirectAction build() {
        com.google.cloud.discoveryengine.v1beta.Control.RedirectAction result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.Control.RedirectAction buildPartial() {
        com.google.cloud.discoveryengine.v1beta.Control.RedirectAction result =
            new com.google.cloud.discoveryengine.v1beta.Control.RedirectAction(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.discoveryengine.v1beta.Control.RedirectAction result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.redirectUri_ = redirectUri_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.discoveryengine.v1beta.Control.RedirectAction) {
          return mergeFrom((com.google.cloud.discoveryengine.v1beta.Control.RedirectAction) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.discoveryengine.v1beta.Control.RedirectAction other) {
        if (other
            == com.google.cloud.discoveryengine.v1beta.Control.RedirectAction.getDefaultInstance())
          return this;
        if (!other.getRedirectUri().isEmpty()) {
          redirectUri_ = other.redirectUri_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  redirectUri_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object redirectUri_ = "";
      /**
       *
       *
       * <pre>
       * Required. The URI to which the shopper will be redirected.
       *
       * Required.
       * URI must have length equal or less than 2000 characters.
       * Otherwise an INVALID ARGUMENT error is thrown.
       * </pre>
       *
       * <code>string redirect_uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The redirectUri.
       */
      public java.lang.String getRedirectUri() {
        java.lang.Object ref = redirectUri_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          redirectUri_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The URI to which the shopper will be redirected.
       *
       * Required.
       * URI must have length equal or less than 2000 characters.
       * Otherwise an INVALID ARGUMENT error is thrown.
       * </pre>
       *
       * <code>string redirect_uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for redirectUri.
       */
      public com.google.protobuf.ByteString getRedirectUriBytes() {
        java.lang.Object ref = redirectUri_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          redirectUri_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The URI to which the shopper will be redirected.
       *
       * Required.
       * URI must have length equal or less than 2000 characters.
       * Otherwise an INVALID ARGUMENT error is thrown.
       * </pre>
       *
       * <code>string redirect_uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The redirectUri to set.
       * @return This builder for chaining.
       */
      public Builder setRedirectUri(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        redirectUri_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The URI to which the shopper will be redirected.
       *
       * Required.
       * URI must have length equal or less than 2000 characters.
       * Otherwise an INVALID ARGUMENT error is thrown.
       * </pre>
       *
       * <code>string redirect_uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearRedirectUri() {
        redirectUri_ = getDefaultInstance().getRedirectUri();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The URI to which the shopper will be redirected.
       *
       * Required.
       * URI must have length equal or less than 2000 characters.
       * Otherwise an INVALID ARGUMENT error is thrown.
       * </pre>
       *
       * <code>string redirect_uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for redirectUri to set.
       * @return This builder for chaining.
       */
      public Builder setRedirectUriBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        redirectUri_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.Control.RedirectAction)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.Control.RedirectAction)
    private static final com.google.cloud.discoveryengine.v1beta.Control.RedirectAction
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.discoveryengine.v1beta.Control.RedirectAction();
    }

    public static com.google.cloud.discoveryengine.v1beta.Control.RedirectAction
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<RedirectAction> PARSER =
        new com.google.protobuf.AbstractParser<RedirectAction>() {
          @java.lang.Override
          public RedirectAction parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<RedirectAction> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<RedirectAction> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.Control.RedirectAction
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface SynonymsActionOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1beta.Control.SynonymsAction)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Defines a set of synonyms.
     * Can specify up to 100 synonyms.
     * Must specify at least 2 synonyms. Otherwise an INVALID ARGUMENT error is
     * thrown.
     * </pre>
     *
     * <code>repeated string synonyms = 1;</code>
     *
     * @return A list containing the synonyms.
     */
    java.util.List<java.lang.String> getSynonymsList();
    /**
     *
     *
     * <pre>
     * Defines a set of synonyms.
     * Can specify up to 100 synonyms.
     * Must specify at least 2 synonyms. Otherwise an INVALID ARGUMENT error is
     * thrown.
     * </pre>
     *
     * <code>repeated string synonyms = 1;</code>
     *
     * @return The count of synonyms.
     */
    int getSynonymsCount();
    /**
     *
     *
     * <pre>
     * Defines a set of synonyms.
     * Can specify up to 100 synonyms.
     * Must specify at least 2 synonyms. Otherwise an INVALID ARGUMENT error is
     * thrown.
     * </pre>
     *
     * <code>repeated string synonyms = 1;</code>
     *
     * @param index The index of the element to return.
     * @return The synonyms at the given index.
     */
    java.lang.String getSynonyms(int index);
    /**
     *
     *
     * <pre>
     * Defines a set of synonyms.
     * Can specify up to 100 synonyms.
     * Must specify at least 2 synonyms. Otherwise an INVALID ARGUMENT error is
     * thrown.
     * </pre>
     *
     * <code>repeated string synonyms = 1;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the synonyms at the given index.
     */
    com.google.protobuf.ByteString getSynonymsBytes(int index);
  }
  /**
   *
   *
   * <pre>
   * Creates a set of terms that will act as synonyms of one another.
   *
   * Example: "happy" will also be considered as "glad", "glad" will also be
   * considered as "happy".
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1beta.Control.SynonymsAction}
   */
  public static final class SynonymsAction extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.Control.SynonymsAction)
      SynonymsActionOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use SynonymsAction.newBuilder() to construct.
    private SynonymsAction(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private SynonymsAction() {
      synonyms_ = com.google.protobuf.LazyStringArrayList.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new SynonymsAction();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1beta.ControlProto
          .internal_static_google_cloud_discoveryengine_v1beta_Control_SynonymsAction_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1beta.ControlProto
          .internal_static_google_cloud_discoveryengine_v1beta_Control_SynonymsAction_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1beta.Control.SynonymsAction.class,
              com.google.cloud.discoveryengine.v1beta.Control.SynonymsAction.Builder.class);
    }

    public static final int SYNONYMS_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList synonyms_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    /**
     *
     *
     * <pre>
     * Defines a set of synonyms.
     * Can specify up to 100 synonyms.
     * Must specify at least 2 synonyms. Otherwise an INVALID ARGUMENT error is
     * thrown.
     * </pre>
     *
     * <code>repeated string synonyms = 1;</code>
     *
     * @return A list containing the synonyms.
     */
    public com.google.protobuf.ProtocolStringList getSynonymsList() {
      return synonyms_;
    }
    /**
     *
     *
     * <pre>
     * Defines a set of synonyms.
     * Can specify up to 100 synonyms.
     * Must specify at least 2 synonyms. Otherwise an INVALID ARGUMENT error is
     * thrown.
     * </pre>
     *
     * <code>repeated string synonyms = 1;</code>
     *
     * @return The count of synonyms.
     */
    public int getSynonymsCount() {
      return synonyms_.size();
    }
    /**
     *
     *
     * <pre>
     * Defines a set of synonyms.
     * Can specify up to 100 synonyms.
     * Must specify at least 2 synonyms. Otherwise an INVALID ARGUMENT error is
     * thrown.
     * </pre>
     *
     * <code>repeated string synonyms = 1;</code>
     *
     * @param index The index of the element to return.
     * @return The synonyms at the given index.
     */
    public java.lang.String getSynonyms(int index) {
      return synonyms_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Defines a set of synonyms.
     * Can specify up to 100 synonyms.
     * Must specify at least 2 synonyms. Otherwise an INVALID ARGUMENT error is
     * thrown.
     * </pre>
     *
     * <code>repeated string synonyms = 1;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the synonyms at the given index.
     */
    public com.google.protobuf.ByteString getSynonymsBytes(int index) {
      return synonyms_.getByteString(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < synonyms_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, synonyms_.getRaw(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      {
        int dataSize = 0;
        for (int i = 0; i < synonyms_.size(); i++) {
          dataSize += computeStringSizeNoTag(synonyms_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getSynonymsList().size();
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.discoveryengine.v1beta.Control.SynonymsAction)) {
        return super.equals(obj);
      }
      com.google.cloud.discoveryengine.v1beta.Control.SynonymsAction other =
          (com.google.cloud.discoveryengine.v1beta.Control.SynonymsAction) obj;

      if (!getSynonymsList().equals(other.getSynonymsList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getSynonymsCount() > 0) {
        hash = (37 * hash) + SYNONYMS_FIELD_NUMBER;
        hash = (53 * hash) + getSynonymsList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.discoveryengine.v1beta.Control.SynonymsAction parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.Control.SynonymsAction parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.Control.SynonymsAction parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.Control.SynonymsAction parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.Control.SynonymsAction parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.Control.SynonymsAction parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.Control.SynonymsAction parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.Control.SynonymsAction parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.Control.SynonymsAction parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.Control.SynonymsAction parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.Control.SynonymsAction parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.Control.SynonymsAction parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.discoveryengine.v1beta.Control.SynonymsAction prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Creates a set of terms that will act as synonyms of one another.
     *
     * Example: "happy" will also be considered as "glad", "glad" will also be
     * considered as "happy".
     * </pre>
     *
     * Protobuf type {@code google.cloud.discoveryengine.v1beta.Control.SynonymsAction}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.Control.SynonymsAction)
        com.google.cloud.discoveryengine.v1beta.Control.SynonymsActionOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1beta.ControlProto
            .internal_static_google_cloud_discoveryengine_v1beta_Control_SynonymsAction_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1beta.ControlProto
            .internal_static_google_cloud_discoveryengine_v1beta_Control_SynonymsAction_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1beta.Control.SynonymsAction.class,
                com.google.cloud.discoveryengine.v1beta.Control.SynonymsAction.Builder.class);
      }

      // Construct using com.google.cloud.discoveryengine.v1beta.Control.SynonymsAction.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        synonyms_ = com.google.protobuf.LazyStringArrayList.emptyList();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.discoveryengine.v1beta.ControlProto
            .internal_static_google_cloud_discoveryengine_v1beta_Control_SynonymsAction_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.Control.SynonymsAction
          getDefaultInstanceForType() {
        return com.google.cloud.discoveryengine.v1beta.Control.SynonymsAction.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.Control.SynonymsAction build() {
        com.google.cloud.discoveryengine.v1beta.Control.SynonymsAction result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.Control.SynonymsAction buildPartial() {
        com.google.cloud.discoveryengine.v1beta.Control.SynonymsAction result =
            new com.google.cloud.discoveryengine.v1beta.Control.SynonymsAction(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.discoveryengine.v1beta.Control.SynonymsAction result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          synonyms_.makeImmutable();
          result.synonyms_ = synonyms_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.discoveryengine.v1beta.Control.SynonymsAction) {
          return mergeFrom((com.google.cloud.discoveryengine.v1beta.Control.SynonymsAction) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.discoveryengine.v1beta.Control.SynonymsAction other) {
        if (other
            == com.google.cloud.discoveryengine.v1beta.Control.SynonymsAction.getDefaultInstance())
          return this;
        if (!other.synonyms_.isEmpty()) {
          if (synonyms_.isEmpty()) {
            synonyms_ = other.synonyms_;
            bitField0_ |= 0x00000001;
          } else {
            ensureSynonymsIsMutable();
            synonyms_.addAll(other.synonyms_);
          }
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureSynonymsIsMutable();
                  synonyms_.add(s);
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.LazyStringArrayList synonyms_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureSynonymsIsMutable() {
        if (!synonyms_.isModifiable()) {
          synonyms_ = new com.google.protobuf.LazyStringArrayList(synonyms_);
        }
        bitField0_ |= 0x00000001;
      }
      /**
       *
       *
       * <pre>
       * Defines a set of synonyms.
       * Can specify up to 100 synonyms.
       * Must specify at least 2 synonyms. Otherwise an INVALID ARGUMENT error is
       * thrown.
       * </pre>
       *
       * <code>repeated string synonyms = 1;</code>
       *
       * @return A list containing the synonyms.
       */
      public com.google.protobuf.ProtocolStringList getSynonymsList() {
        synonyms_.makeImmutable();
        return synonyms_;
      }
      /**
       *
       *
       * <pre>
       * Defines a set of synonyms.
       * Can specify up to 100 synonyms.
       * Must specify at least 2 synonyms. Otherwise an INVALID ARGUMENT error is
       * thrown.
       * </pre>
       *
       * <code>repeated string synonyms = 1;</code>
       *
       * @return The count of synonyms.
       */
      public int getSynonymsCount() {
        return synonyms_.size();
      }
      /**
       *
       *
       * <pre>
       * Defines a set of synonyms.
       * Can specify up to 100 synonyms.
       * Must specify at least 2 synonyms. Otherwise an INVALID ARGUMENT error is
       * thrown.
       * </pre>
       *
       * <code>repeated string synonyms = 1;</code>
       *
       * @param index The index of the element to return.
       * @return The synonyms at the given index.
       */
      public java.lang.String getSynonyms(int index) {
        return synonyms_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Defines a set of synonyms.
       * Can specify up to 100 synonyms.
       * Must specify at least 2 synonyms. Otherwise an INVALID ARGUMENT error is
       * thrown.
       * </pre>
       *
       * <code>repeated string synonyms = 1;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the synonyms at the given index.
       */
      public com.google.protobuf.ByteString getSynonymsBytes(int index) {
        return synonyms_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * Defines a set of synonyms.
       * Can specify up to 100 synonyms.
       * Must specify at least 2 synonyms. Otherwise an INVALID ARGUMENT error is
       * thrown.
       * </pre>
       *
       * <code>repeated string synonyms = 1;</code>
       *
       * @param index The index to set the value at.
       * @param value The synonyms to set.
       * @return This builder for chaining.
       */
      public Builder setSynonyms(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSynonymsIsMutable();
        synonyms_.set(index, value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Defines a set of synonyms.
       * Can specify up to 100 synonyms.
       * Must specify at least 2 synonyms. Otherwise an INVALID ARGUMENT error is
       * thrown.
       * </pre>
       *
       * <code>repeated string synonyms = 1;</code>
       *
       * @param value The synonyms to add.
       * @return This builder for chaining.
       */
      public Builder addSynonyms(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSynonymsIsMutable();
        synonyms_.add(value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Defines a set of synonyms.
       * Can specify up to 100 synonyms.
       * Must specify at least 2 synonyms. Otherwise an INVALID ARGUMENT error is
       * thrown.
       * </pre>
       *
       * <code>repeated string synonyms = 1;</code>
       *
       * @param values The synonyms to add.
       * @return This builder for chaining.
       */
      public Builder addAllSynonyms(java.lang.Iterable<java.lang.String> values) {
        ensureSynonymsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, synonyms_);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Defines a set of synonyms.
       * Can specify up to 100 synonyms.
       * Must specify at least 2 synonyms. Otherwise an INVALID ARGUMENT error is
       * thrown.
       * </pre>
       *
       * <code>repeated string synonyms = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearSynonyms() {
        synonyms_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        ;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Defines a set of synonyms.
       * Can specify up to 100 synonyms.
       * Must specify at least 2 synonyms. Otherwise an INVALID ARGUMENT error is
       * thrown.
       * </pre>
       *
       * <code>repeated string synonyms = 1;</code>
       *
       * @param value The bytes of the synonyms to add.
       * @return This builder for chaining.
       */
      public Builder addSynonymsBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureSynonymsIsMutable();
        synonyms_.add(value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.Control.SynonymsAction)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.Control.SynonymsAction)
    private static final com.google.cloud.discoveryengine.v1beta.Control.SynonymsAction
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.discoveryengine.v1beta.Control.SynonymsAction();
    }

    public static com.google.cloud.discoveryengine.v1beta.Control.SynonymsAction
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<SynonymsAction> PARSER =
        new com.google.protobuf.AbstractParser<SynonymsAction>() {
          @java.lang.Override
          public SynonymsAction parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<SynonymsAction> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<SynonymsAction> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.Control.SynonymsAction
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int actionCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object action_;

  public enum ActionCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    BOOST_ACTION(6),
    FILTER_ACTION(7),
    REDIRECT_ACTION(9),
    SYNONYMS_ACTION(10),
    ACTION_NOT_SET(0);
    private final int value;

    private ActionCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ActionCase valueOf(int value) {
      return forNumber(value);
    }

    public static ActionCase forNumber(int value) {
      switch (value) {
        case 6:
          return BOOST_ACTION;
        case 7:
          return FILTER_ACTION;
        case 9:
          return REDIRECT_ACTION;
        case 10:
          return SYNONYMS_ACTION;
        case 0:
          return ACTION_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public ActionCase getActionCase() {
    return ActionCase.forNumber(actionCase_);
  }

  public static final int BOOST_ACTION_FIELD_NUMBER = 6;
  /**
   *
   *
   * <pre>
   * Defines a boost-type control
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.Control.BoostAction boost_action = 6;</code>
   *
   * @return Whether the boostAction field is set.
   */
  @java.lang.Override
  public boolean hasBoostAction() {
    return actionCase_ == 6;
  }
  /**
   *
   *
   * <pre>
   * Defines a boost-type control
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.Control.BoostAction boost_action = 6;</code>
   *
   * @return The boostAction.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.Control.BoostAction getBoostAction() {
    if (actionCase_ == 6) {
      return (com.google.cloud.discoveryengine.v1beta.Control.BoostAction) action_;
    }
    return com.google.cloud.discoveryengine.v1beta.Control.BoostAction.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Defines a boost-type control
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.Control.BoostAction boost_action = 6;</code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.Control.BoostActionOrBuilder
      getBoostActionOrBuilder() {
    if (actionCase_ == 6) {
      return (com.google.cloud.discoveryengine.v1beta.Control.BoostAction) action_;
    }
    return com.google.cloud.discoveryengine.v1beta.Control.BoostAction.getDefaultInstance();
  }

  public static final int FILTER_ACTION_FIELD_NUMBER = 7;
  /**
   *
   *
   * <pre>
   * Defines a filter-type control
   * Currently not supported by Recommendation
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.Control.FilterAction filter_action = 7;</code>
   *
   * @return Whether the filterAction field is set.
   */
  @java.lang.Override
  public boolean hasFilterAction() {
    return actionCase_ == 7;
  }
  /**
   *
   *
   * <pre>
   * Defines a filter-type control
   * Currently not supported by Recommendation
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.Control.FilterAction filter_action = 7;</code>
   *
   * @return The filterAction.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.Control.FilterAction getFilterAction() {
    if (actionCase_ == 7) {
      return (com.google.cloud.discoveryengine.v1beta.Control.FilterAction) action_;
    }
    return com.google.cloud.discoveryengine.v1beta.Control.FilterAction.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Defines a filter-type control
   * Currently not supported by Recommendation
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.Control.FilterAction filter_action = 7;</code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.Control.FilterActionOrBuilder
      getFilterActionOrBuilder() {
    if (actionCase_ == 7) {
      return (com.google.cloud.discoveryengine.v1beta.Control.FilterAction) action_;
    }
    return com.google.cloud.discoveryengine.v1beta.Control.FilterAction.getDefaultInstance();
  }

  public static final int REDIRECT_ACTION_FIELD_NUMBER = 9;
  /**
   *
   *
   * <pre>
   * Defines a redirect-type control.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.Control.RedirectAction redirect_action = 9;</code>
   *
   * @return Whether the redirectAction field is set.
   */
  @java.lang.Override
  public boolean hasRedirectAction() {
    return actionCase_ == 9;
  }
  /**
   *
   *
   * <pre>
   * Defines a redirect-type control.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.Control.RedirectAction redirect_action = 9;</code>
   *
   * @return The redirectAction.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.Control.RedirectAction getRedirectAction() {
    if (actionCase_ == 9) {
      return (com.google.cloud.discoveryengine.v1beta.Control.RedirectAction) action_;
    }
    return com.google.cloud.discoveryengine.v1beta.Control.RedirectAction.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Defines a redirect-type control.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.Control.RedirectAction redirect_action = 9;</code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.Control.RedirectActionOrBuilder
      getRedirectActionOrBuilder() {
    if (actionCase_ == 9) {
      return (com.google.cloud.discoveryengine.v1beta.Control.RedirectAction) action_;
    }
    return com.google.cloud.discoveryengine.v1beta.Control.RedirectAction.getDefaultInstance();
  }

  public static final int SYNONYMS_ACTION_FIELD_NUMBER = 10;
  /**
   *
   *
   * <pre>
   * Treats a group of terms as synonyms of one another.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.Control.SynonymsAction synonyms_action = 10;</code>
   *
   * @return Whether the synonymsAction field is set.
   */
  @java.lang.Override
  public boolean hasSynonymsAction() {
    return actionCase_ == 10;
  }
  /**
   *
   *
   * <pre>
   * Treats a group of terms as synonyms of one another.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.Control.SynonymsAction synonyms_action = 10;</code>
   *
   * @return The synonymsAction.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.Control.SynonymsAction getSynonymsAction() {
    if (actionCase_ == 10) {
      return (com.google.cloud.discoveryengine.v1beta.Control.SynonymsAction) action_;
    }
    return com.google.cloud.discoveryengine.v1beta.Control.SynonymsAction.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Treats a group of terms as synonyms of one another.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.Control.SynonymsAction synonyms_action = 10;</code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.Control.SynonymsActionOrBuilder
      getSynonymsActionOrBuilder() {
    if (actionCase_ == 10) {
      return (com.google.cloud.discoveryengine.v1beta.Control.SynonymsAction) action_;
    }
    return com.google.cloud.discoveryengine.v1beta.Control.SynonymsAction.getDefaultInstance();
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Immutable. Fully qualified name
   * `projects/&#42;&#47;locations/global/dataStore/&#42;&#47;controls/&#42;`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Immutable. Fully qualified name
   * `projects/&#42;&#47;locations/global/dataStore/&#42;&#47;controls/&#42;`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";
  /**
   *
   *
   * <pre>
   * Required. Human readable name. The identifier used in UI views.
   *
   * Must be UTF-8 encoded string. Length limit is 128 characters.
   * Otherwise an INVALID ARGUMENT error is thrown.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Human readable name. The identifier used in UI views.
   *
   * Must be UTF-8 encoded string. Length limit is 128 characters.
   * Otherwise an INVALID ARGUMENT error is thrown.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ASSOCIATED_SERVING_CONFIG_IDS_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList associatedServingConfigIds_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Output only. List of all
   * [ServingConfig][google.cloud.discoveryengine.v1beta.ServingConfig] ids this
   * control is attached to. May take up to 10 minutes to update after changes.
   * </pre>
   *
   * <code>
   * repeated string associated_serving_config_ids = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return A list containing the associatedServingConfigIds.
   */
  public com.google.protobuf.ProtocolStringList getAssociatedServingConfigIdsList() {
    return associatedServingConfigIds_;
  }
  /**
   *
   *
   * <pre>
   * Output only. List of all
   * [ServingConfig][google.cloud.discoveryengine.v1beta.ServingConfig] ids this
   * control is attached to. May take up to 10 minutes to update after changes.
   * </pre>
   *
   * <code>
   * repeated string associated_serving_config_ids = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The count of associatedServingConfigIds.
   */
  public int getAssociatedServingConfigIdsCount() {
    return associatedServingConfigIds_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. List of all
   * [ServingConfig][google.cloud.discoveryengine.v1beta.ServingConfig] ids this
   * control is attached to. May take up to 10 minutes to update after changes.
   * </pre>
   *
   * <code>
   * repeated string associated_serving_config_ids = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @param index The index of the element to return.
   * @return The associatedServingConfigIds at the given index.
   */
  public java.lang.String getAssociatedServingConfigIds(int index) {
    return associatedServingConfigIds_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. List of all
   * [ServingConfig][google.cloud.discoveryengine.v1beta.ServingConfig] ids this
   * control is attached to. May take up to 10 minutes to update after changes.
   * </pre>
   *
   * <code>
   * repeated string associated_serving_config_ids = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the associatedServingConfigIds at the given index.
   */
  public com.google.protobuf.ByteString getAssociatedServingConfigIdsBytes(int index) {
    return associatedServingConfigIds_.getByteString(index);
  }

  public static final int SOLUTION_TYPE_FIELD_NUMBER = 4;
  private int solutionType_ = 0;
  /**
   *
   *
   * <pre>
   * Required. Immutable. What solution the control belongs to.
   *
   * Must be compatible with vertical of resource.
   * Otherwise an INVALID ARGUMENT error is thrown.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1beta.SolutionType solution_type = 4 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The enum numeric value on the wire for solutionType.
   */
  @java.lang.Override
  public int getSolutionTypeValue() {
    return solutionType_;
  }
  /**
   *
   *
   * <pre>
   * Required. Immutable. What solution the control belongs to.
   *
   * Must be compatible with vertical of resource.
   * Otherwise an INVALID ARGUMENT error is thrown.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1beta.SolutionType solution_type = 4 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The solutionType.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.SolutionType getSolutionType() {
    com.google.cloud.discoveryengine.v1beta.SolutionType result =
        com.google.cloud.discoveryengine.v1beta.SolutionType.forNumber(solutionType_);
    return result == null
        ? com.google.cloud.discoveryengine.v1beta.SolutionType.UNRECOGNIZED
        : result;
  }

  public static final int USE_CASES_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private java.util.List<java.lang.Integer> useCases_;

  private static final com.google.protobuf.Internal.ListAdapter.Converter<
          java.lang.Integer, com.google.cloud.discoveryengine.v1beta.SearchUseCase>
      useCases_converter_ =
          new com.google.protobuf.Internal.ListAdapter.Converter<
              java.lang.Integer, com.google.cloud.discoveryengine.v1beta.SearchUseCase>() {
            public com.google.cloud.discoveryengine.v1beta.SearchUseCase convert(
                java.lang.Integer from) {
              com.google.cloud.discoveryengine.v1beta.SearchUseCase result =
                  com.google.cloud.discoveryengine.v1beta.SearchUseCase.forNumber(from);
              return result == null
                  ? com.google.cloud.discoveryengine.v1beta.SearchUseCase.UNRECOGNIZED
                  : result;
            }
          };
  /**
   *
   *
   * <pre>
   * Specifies the use case for the control.
   * Affects what condition fields can be set.
   * Only applies to
   * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH].
   * Currently only allow one use case per control.
   * Must be set when solution_type is
   * [SolutionType.SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH].
   * </pre>
   *
   * <code>repeated .google.cloud.discoveryengine.v1beta.SearchUseCase use_cases = 8;</code>
   *
   * @return A list containing the useCases.
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.discoveryengine.v1beta.SearchUseCase> getUseCasesList() {
    return new com.google.protobuf.Internal.ListAdapter<
        java.lang.Integer, com.google.cloud.discoveryengine.v1beta.SearchUseCase>(
        useCases_, useCases_converter_);
  }
  /**
   *
   *
   * <pre>
   * Specifies the use case for the control.
   * Affects what condition fields can be set.
   * Only applies to
   * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH].
   * Currently only allow one use case per control.
   * Must be set when solution_type is
   * [SolutionType.SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH].
   * </pre>
   *
   * <code>repeated .google.cloud.discoveryengine.v1beta.SearchUseCase use_cases = 8;</code>
   *
   * @return The count of useCases.
   */
  @java.lang.Override
  public int getUseCasesCount() {
    return useCases_.size();
  }
  /**
   *
   *
   * <pre>
   * Specifies the use case for the control.
   * Affects what condition fields can be set.
   * Only applies to
   * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH].
   * Currently only allow one use case per control.
   * Must be set when solution_type is
   * [SolutionType.SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH].
   * </pre>
   *
   * <code>repeated .google.cloud.discoveryengine.v1beta.SearchUseCase use_cases = 8;</code>
   *
   * @param index The index of the element to return.
   * @return The useCases at the given index.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.SearchUseCase getUseCases(int index) {
    return useCases_converter_.convert(useCases_.get(index));
  }
  /**
   *
   *
   * <pre>
   * Specifies the use case for the control.
   * Affects what condition fields can be set.
   * Only applies to
   * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH].
   * Currently only allow one use case per control.
   * Must be set when solution_type is
   * [SolutionType.SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH].
   * </pre>
   *
   * <code>repeated .google.cloud.discoveryengine.v1beta.SearchUseCase use_cases = 8;</code>
   *
   * @return A list containing the enum numeric values on the wire for useCases.
   */
  @java.lang.Override
  public java.util.List<java.lang.Integer> getUseCasesValueList() {
    return useCases_;
  }
  /**
   *
   *
   * <pre>
   * Specifies the use case for the control.
   * Affects what condition fields can be set.
   * Only applies to
   * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH].
   * Currently only allow one use case per control.
   * Must be set when solution_type is
   * [SolutionType.SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH].
   * </pre>
   *
   * <code>repeated .google.cloud.discoveryengine.v1beta.SearchUseCase use_cases = 8;</code>
   *
   * @param index The index of the value to return.
   * @return The enum numeric value on the wire of useCases at the given index.
   */
  @java.lang.Override
  public int getUseCasesValue(int index) {
    return useCases_.get(index);
  }

  private int useCasesMemoizedSerializedSize;

  public static final int CONDITIONS_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.discoveryengine.v1beta.Condition> conditions_;
  /**
   *
   *
   * <pre>
   * Determines when the associated action will trigger.
   *
   * Omit to always apply the action.
   * Currently only a single condition may be specified.
   * Otherwise an INVALID ARGUMENT error is thrown.
   * </pre>
   *
   * <code>repeated .google.cloud.discoveryengine.v1beta.Condition conditions = 5;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.discoveryengine.v1beta.Condition> getConditionsList() {
    return conditions_;
  }
  /**
   *
   *
   * <pre>
   * Determines when the associated action will trigger.
   *
   * Omit to always apply the action.
   * Currently only a single condition may be specified.
   * Otherwise an INVALID ARGUMENT error is thrown.
   * </pre>
   *
   * <code>repeated .google.cloud.discoveryengine.v1beta.Condition conditions = 5;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.discoveryengine.v1beta.ConditionOrBuilder>
      getConditionsOrBuilderList() {
    return conditions_;
  }
  /**
   *
   *
   * <pre>
   * Determines when the associated action will trigger.
   *
   * Omit to always apply the action.
   * Currently only a single condition may be specified.
   * Otherwise an INVALID ARGUMENT error is thrown.
   * </pre>
   *
   * <code>repeated .google.cloud.discoveryengine.v1beta.Condition conditions = 5;</code>
   */
  @java.lang.Override
  public int getConditionsCount() {
    return conditions_.size();
  }
  /**
   *
   *
   * <pre>
   * Determines when the associated action will trigger.
   *
   * Omit to always apply the action.
   * Currently only a single condition may be specified.
   * Otherwise an INVALID ARGUMENT error is thrown.
   * </pre>
   *
   * <code>repeated .google.cloud.discoveryengine.v1beta.Condition conditions = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.Condition getConditions(int index) {
    return conditions_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Determines when the associated action will trigger.
   *
   * Omit to always apply the action.
   * Currently only a single condition may be specified.
   * Otherwise an INVALID ARGUMENT error is thrown.
   * </pre>
   *
   * <code>repeated .google.cloud.discoveryengine.v1beta.Condition conditions = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.ConditionOrBuilder getConditionsOrBuilder(
      int index) {
    return conditions_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    getSerializedSize();
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, displayName_);
    }
    for (int i = 0; i < associatedServingConfigIds_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 3, associatedServingConfigIds_.getRaw(i));
    }
    if (solutionType_
        != com.google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(4, solutionType_);
    }
    for (int i = 0; i < conditions_.size(); i++) {
      output.writeMessage(5, conditions_.get(i));
    }
    if (actionCase_ == 6) {
      output.writeMessage(6, (com.google.cloud.discoveryengine.v1beta.Control.BoostAction) action_);
    }
    if (actionCase_ == 7) {
      output.writeMessage(
          7, (com.google.cloud.discoveryengine.v1beta.Control.FilterAction) action_);
    }
    if (getUseCasesList().size() > 0) {
      output.writeUInt32NoTag(66);
      output.writeUInt32NoTag(useCasesMemoizedSerializedSize);
    }
    for (int i = 0; i < useCases_.size(); i++) {
      output.writeEnumNoTag(useCases_.get(i));
    }
    if (actionCase_ == 9) {
      output.writeMessage(
          9, (com.google.cloud.discoveryengine.v1beta.Control.RedirectAction) action_);
    }
    if (actionCase_ == 10) {
      output.writeMessage(
          10, (com.google.cloud.discoveryengine.v1beta.Control.SynonymsAction) action_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, displayName_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < associatedServingConfigIds_.size(); i++) {
        dataSize += computeStringSizeNoTag(associatedServingConfigIds_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getAssociatedServingConfigIdsList().size();
    }
    if (solutionType_
        != com.google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, solutionType_);
    }
    for (int i = 0; i < conditions_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, conditions_.get(i));
    }
    if (actionCase_ == 6) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              6, (com.google.cloud.discoveryengine.v1beta.Control.BoostAction) action_);
    }
    if (actionCase_ == 7) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              7, (com.google.cloud.discoveryengine.v1beta.Control.FilterAction) action_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < useCases_.size(); i++) {
        dataSize += com.google.protobuf.CodedOutputStream.computeEnumSizeNoTag(useCases_.get(i));
      }
      size += dataSize;
      if (!getUseCasesList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(dataSize);
      }
      useCasesMemoizedSerializedSize = dataSize;
    }
    if (actionCase_ == 9) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              9, (com.google.cloud.discoveryengine.v1beta.Control.RedirectAction) action_);
    }
    if (actionCase_ == 10) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              10, (com.google.cloud.discoveryengine.v1beta.Control.SynonymsAction) action_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.discoveryengine.v1beta.Control)) {
      return super.equals(obj);
    }
    com.google.cloud.discoveryengine.v1beta.Control other =
        (com.google.cloud.discoveryengine.v1beta.Control) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (!getAssociatedServingConfigIdsList().equals(other.getAssociatedServingConfigIdsList()))
      return false;
    if (solutionType_ != other.solutionType_) return false;
    if (!useCases_.equals(other.useCases_)) return false;
    if (!getConditionsList().equals(other.getConditionsList())) return false;
    if (!getActionCase().equals(other.getActionCase())) return false;
    switch (actionCase_) {
      case 6:
        if (!getBoostAction().equals(other.getBoostAction())) return false;
        break;
      case 7:
        if (!getFilterAction().equals(other.getFilterAction())) return false;
        break;
      case 9:
        if (!getRedirectAction().equals(other.getRedirectAction())) return false;
        break;
      case 10:
        if (!getSynonymsAction().equals(other.getSynonymsAction())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    if (getAssociatedServingConfigIdsCount() > 0) {
      hash = (37 * hash) + ASSOCIATED_SERVING_CONFIG_IDS_FIELD_NUMBER;
      hash = (53 * hash) + getAssociatedServingConfigIdsList().hashCode();
    }
    hash = (37 * hash) + SOLUTION_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + solutionType_;
    if (getUseCasesCount() > 0) {
      hash = (37 * hash) + USE_CASES_FIELD_NUMBER;
      hash = (53 * hash) + useCases_.hashCode();
    }
    if (getConditionsCount() > 0) {
      hash = (37 * hash) + CONDITIONS_FIELD_NUMBER;
      hash = (53 * hash) + getConditionsList().hashCode();
    }
    switch (actionCase_) {
      case 6:
        hash = (37 * hash) + BOOST_ACTION_FIELD_NUMBER;
        hash = (53 * hash) + getBoostAction().hashCode();
        break;
      case 7:
        hash = (37 * hash) + FILTER_ACTION_FIELD_NUMBER;
        hash = (53 * hash) + getFilterAction().hashCode();
        break;
      case 9:
        hash = (37 * hash) + REDIRECT_ACTION_FIELD_NUMBER;
        hash = (53 * hash) + getRedirectAction().hashCode();
        break;
      case 10:
        hash = (37 * hash) + SYNONYMS_ACTION_FIELD_NUMBER;
        hash = (53 * hash) + getSynonymsAction().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.discoveryengine.v1beta.Control parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1beta.Control parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.Control parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1beta.Control parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.Control parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1beta.Control parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.Control parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1beta.Control parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.Control parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1beta.Control parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.Control parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1beta.Control parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.discoveryengine.v1beta.Control prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Defines a conditioned behavior to employ during serving.
   * Must be attached to a
   * [ServingConfig][google.cloud.discoveryengine.v1beta.ServingConfig] to be
   * considered at serving time. Permitted actions dependent on `SolutionType`.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1beta.Control}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.Control)
      com.google.cloud.discoveryengine.v1beta.ControlOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1beta.ControlProto
          .internal_static_google_cloud_discoveryengine_v1beta_Control_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1beta.ControlProto
          .internal_static_google_cloud_discoveryengine_v1beta_Control_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1beta.Control.class,
              com.google.cloud.discoveryengine.v1beta.Control.Builder.class);
    }

    // Construct using com.google.cloud.discoveryengine.v1beta.Control.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (boostActionBuilder_ != null) {
        boostActionBuilder_.clear();
      }
      if (filterActionBuilder_ != null) {
        filterActionBuilder_.clear();
      }
      if (redirectActionBuilder_ != null) {
        redirectActionBuilder_.clear();
      }
      if (synonymsActionBuilder_ != null) {
        synonymsActionBuilder_.clear();
      }
      name_ = "";
      displayName_ = "";
      associatedServingConfigIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
      solutionType_ = 0;
      useCases_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000100);
      if (conditionsBuilder_ == null) {
        conditions_ = java.util.Collections.emptyList();
      } else {
        conditions_ = null;
        conditionsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000200);
      actionCase_ = 0;
      action_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.discoveryengine.v1beta.ControlProto
          .internal_static_google_cloud_discoveryengine_v1beta_Control_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.Control getDefaultInstanceForType() {
      return com.google.cloud.discoveryengine.v1beta.Control.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.Control build() {
      com.google.cloud.discoveryengine.v1beta.Control result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.Control buildPartial() {
      com.google.cloud.discoveryengine.v1beta.Control result =
          new com.google.cloud.discoveryengine.v1beta.Control(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.discoveryengine.v1beta.Control result) {
      if (((bitField0_ & 0x00000100) != 0)) {
        useCases_ = java.util.Collections.unmodifiableList(useCases_);
        bitField0_ = (bitField0_ & ~0x00000100);
      }
      result.useCases_ = useCases_;
      if (conditionsBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)) {
          conditions_ = java.util.Collections.unmodifiableList(conditions_);
          bitField0_ = (bitField0_ & ~0x00000200);
        }
        result.conditions_ = conditions_;
      } else {
        result.conditions_ = conditionsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.discoveryengine.v1beta.Control result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.displayName_ = displayName_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        associatedServingConfigIds_.makeImmutable();
        result.associatedServingConfigIds_ = associatedServingConfigIds_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.solutionType_ = solutionType_;
      }
    }

    private void buildPartialOneofs(com.google.cloud.discoveryengine.v1beta.Control result) {
      result.actionCase_ = actionCase_;
      result.action_ = this.action_;
      if (actionCase_ == 6 && boostActionBuilder_ != null) {
        result.action_ = boostActionBuilder_.build();
      }
      if (actionCase_ == 7 && filterActionBuilder_ != null) {
        result.action_ = filterActionBuilder_.build();
      }
      if (actionCase_ == 9 && redirectActionBuilder_ != null) {
        result.action_ = redirectActionBuilder_.build();
      }
      if (actionCase_ == 10 && synonymsActionBuilder_ != null) {
        result.action_ = synonymsActionBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.discoveryengine.v1beta.Control) {
        return mergeFrom((com.google.cloud.discoveryengine.v1beta.Control) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.discoveryengine.v1beta.Control other) {
      if (other == com.google.cloud.discoveryengine.v1beta.Control.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (!other.associatedServingConfigIds_.isEmpty()) {
        if (associatedServingConfigIds_.isEmpty()) {
          associatedServingConfigIds_ = other.associatedServingConfigIds_;
          bitField0_ |= 0x00000040;
        } else {
          ensureAssociatedServingConfigIdsIsMutable();
          associatedServingConfigIds_.addAll(other.associatedServingConfigIds_);
        }
        onChanged();
      }
      if (other.solutionType_ != 0) {
        setSolutionTypeValue(other.getSolutionTypeValue());
      }
      if (!other.useCases_.isEmpty()) {
        if (useCases_.isEmpty()) {
          useCases_ = other.useCases_;
          bitField0_ = (bitField0_ & ~0x00000100);
        } else {
          ensureUseCasesIsMutable();
          useCases_.addAll(other.useCases_);
        }
        onChanged();
      }
      if (conditionsBuilder_ == null) {
        if (!other.conditions_.isEmpty()) {
          if (conditions_.isEmpty()) {
            conditions_ = other.conditions_;
            bitField0_ = (bitField0_ & ~0x00000200);
          } else {
            ensureConditionsIsMutable();
            conditions_.addAll(other.conditions_);
          }
          onChanged();
        }
      } else {
        if (!other.conditions_.isEmpty()) {
          if (conditionsBuilder_.isEmpty()) {
            conditionsBuilder_.dispose();
            conditionsBuilder_ = null;
            conditions_ = other.conditions_;
            bitField0_ = (bitField0_ & ~0x00000200);
            conditionsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getConditionsFieldBuilder()
                    : null;
          } else {
            conditionsBuilder_.addAllMessages(other.conditions_);
          }
        }
      }
      switch (other.getActionCase()) {
        case BOOST_ACTION:
          {
            mergeBoostAction(other.getBoostAction());
            break;
          }
        case FILTER_ACTION:
          {
            mergeFilterAction(other.getFilterAction());
            break;
          }
        case REDIRECT_ACTION:
          {
            mergeRedirectAction(other.getRedirectAction());
            break;
          }
        case SYNONYMS_ACTION:
          {
            mergeSynonymsAction(other.getSynonymsAction());
            break;
          }
        case ACTION_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 10
            case 18:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 18
            case 26:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureAssociatedServingConfigIdsIsMutable();
                associatedServingConfigIds_.add(s);
                break;
              } // case 26
            case 32:
              {
                solutionType_ = input.readEnum();
                bitField0_ |= 0x00000080;
                break;
              } // case 32
            case 42:
              {
                com.google.cloud.discoveryengine.v1beta.Condition m =
                    input.readMessage(
                        com.google.cloud.discoveryengine.v1beta.Condition.parser(),
                        extensionRegistry);
                if (conditionsBuilder_ == null) {
                  ensureConditionsIsMutable();
                  conditions_.add(m);
                } else {
                  conditionsBuilder_.addMessage(m);
                }
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getBoostActionFieldBuilder().getBuilder(), extensionRegistry);
                actionCase_ = 6;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getFilterActionFieldBuilder().getBuilder(), extensionRegistry);
                actionCase_ = 7;
                break;
              } // case 58
            case 64:
              {
                int tmpRaw = input.readEnum();
                ensureUseCasesIsMutable();
                useCases_.add(tmpRaw);
                break;
              } // case 64
            case 66:
              {
                int length = input.readRawVarint32();
                int oldLimit = input.pushLimit(length);
                while (input.getBytesUntilLimit() > 0) {
                  int tmpRaw = input.readEnum();
                  ensureUseCasesIsMutable();
                  useCases_.add(tmpRaw);
                }
                input.popLimit(oldLimit);
                break;
              } // case 66
            case 74:
              {
                input.readMessage(getRedirectActionFieldBuilder().getBuilder(), extensionRegistry);
                actionCase_ = 9;
                break;
              } // case 74
            case 82:
              {
                input.readMessage(getSynonymsActionFieldBuilder().getBuilder(), extensionRegistry);
                actionCase_ = 10;
                break;
              } // case 82
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int actionCase_ = 0;
    private java.lang.Object action_;

    public ActionCase getActionCase() {
      return ActionCase.forNumber(actionCase_);
    }

    public Builder clearAction() {
      actionCase_ = 0;
      action_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1beta.Control.BoostAction,
            com.google.cloud.discoveryengine.v1beta.Control.BoostAction.Builder,
            com.google.cloud.discoveryengine.v1beta.Control.BoostActionOrBuilder>
        boostActionBuilder_;
    /**
     *
     *
     * <pre>
     * Defines a boost-type control
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.Control.BoostAction boost_action = 6;</code>
     *
     * @return Whether the boostAction field is set.
     */
    @java.lang.Override
    public boolean hasBoostAction() {
      return actionCase_ == 6;
    }
    /**
     *
     *
     * <pre>
     * Defines a boost-type control
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.Control.BoostAction boost_action = 6;</code>
     *
     * @return The boostAction.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.Control.BoostAction getBoostAction() {
      if (boostActionBuilder_ == null) {
        if (actionCase_ == 6) {
          return (com.google.cloud.discoveryengine.v1beta.Control.BoostAction) action_;
        }
        return com.google.cloud.discoveryengine.v1beta.Control.BoostAction.getDefaultInstance();
      } else {
        if (actionCase_ == 6) {
          return boostActionBuilder_.getMessage();
        }
        return com.google.cloud.discoveryengine.v1beta.Control.BoostAction.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Defines a boost-type control
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.Control.BoostAction boost_action = 6;</code>
     */
    public Builder setBoostAction(
        com.google.cloud.discoveryengine.v1beta.Control.BoostAction value) {
      if (boostActionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        action_ = value;
        onChanged();
      } else {
        boostActionBuilder_.setMessage(value);
      }
      actionCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Defines a boost-type control
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.Control.BoostAction boost_action = 6;</code>
     */
    public Builder setBoostAction(
        com.google.cloud.discoveryengine.v1beta.Control.BoostAction.Builder builderForValue) {
      if (boostActionBuilder_ == null) {
        action_ = builderForValue.build();
        onChanged();
      } else {
        boostActionBuilder_.setMessage(builderForValue.build());
      }
      actionCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Defines a boost-type control
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.Control.BoostAction boost_action = 6;</code>
     */
    public Builder mergeBoostAction(
        com.google.cloud.discoveryengine.v1beta.Control.BoostAction value) {
      if (boostActionBuilder_ == null) {
        if (actionCase_ == 6
            && action_
                != com.google.cloud.discoveryengine.v1beta.Control.BoostAction
                    .getDefaultInstance()) {
          action_ =
              com.google.cloud.discoveryengine.v1beta.Control.BoostAction.newBuilder(
                      (com.google.cloud.discoveryengine.v1beta.Control.BoostAction) action_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          action_ = value;
        }
        onChanged();
      } else {
        if (actionCase_ == 6) {
          boostActionBuilder_.mergeFrom(value);
        } else {
          boostActionBuilder_.setMessage(value);
        }
      }
      actionCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Defines a boost-type control
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.Control.BoostAction boost_action = 6;</code>
     */
    public Builder clearBoostAction() {
      if (boostActionBuilder_ == null) {
        if (actionCase_ == 6) {
          actionCase_ = 0;
          action_ = null;
          onChanged();
        }
      } else {
        if (actionCase_ == 6) {
          actionCase_ = 0;
          action_ = null;
        }
        boostActionBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Defines a boost-type control
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.Control.BoostAction boost_action = 6;</code>
     */
    public com.google.cloud.discoveryengine.v1beta.Control.BoostAction.Builder
        getBoostActionBuilder() {
      return getBoostActionFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Defines a boost-type control
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.Control.BoostAction boost_action = 6;</code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.Control.BoostActionOrBuilder
        getBoostActionOrBuilder() {
      if ((actionCase_ == 6) && (boostActionBuilder_ != null)) {
        return boostActionBuilder_.getMessageOrBuilder();
      } else {
        if (actionCase_ == 6) {
          return (com.google.cloud.discoveryengine.v1beta.Control.BoostAction) action_;
        }
        return com.google.cloud.discoveryengine.v1beta.Control.BoostAction.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Defines a boost-type control
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.Control.BoostAction boost_action = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1beta.Control.BoostAction,
            com.google.cloud.discoveryengine.v1beta.Control.BoostAction.Builder,
            com.google.cloud.discoveryengine.v1beta.Control.BoostActionOrBuilder>
        getBoostActionFieldBuilder() {
      if (boostActionBuilder_ == null) {
        if (!(actionCase_ == 6)) {
          action_ =
              com.google.cloud.discoveryengine.v1beta.Control.BoostAction.getDefaultInstance();
        }
        boostActionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1beta.Control.BoostAction,
                com.google.cloud.discoveryengine.v1beta.Control.BoostAction.Builder,
                com.google.cloud.discoveryengine.v1beta.Control.BoostActionOrBuilder>(
                (com.google.cloud.discoveryengine.v1beta.Control.BoostAction) action_,
                getParentForChildren(),
                isClean());
        action_ = null;
      }
      actionCase_ = 6;
      onChanged();
      return boostActionBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1beta.Control.FilterAction,
            com.google.cloud.discoveryengine.v1beta.Control.FilterAction.Builder,
            com.google.cloud.discoveryengine.v1beta.Control.FilterActionOrBuilder>
        filterActionBuilder_;
    /**
     *
     *
     * <pre>
     * Defines a filter-type control
     * Currently not supported by Recommendation
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.Control.FilterAction filter_action = 7;</code>
     *
     * @return Whether the filterAction field is set.
     */
    @java.lang.Override
    public boolean hasFilterAction() {
      return actionCase_ == 7;
    }
    /**
     *
     *
     * <pre>
     * Defines a filter-type control
     * Currently not supported by Recommendation
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.Control.FilterAction filter_action = 7;</code>
     *
     * @return The filterAction.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.Control.FilterAction getFilterAction() {
      if (filterActionBuilder_ == null) {
        if (actionCase_ == 7) {
          return (com.google.cloud.discoveryengine.v1beta.Control.FilterAction) action_;
        }
        return com.google.cloud.discoveryengine.v1beta.Control.FilterAction.getDefaultInstance();
      } else {
        if (actionCase_ == 7) {
          return filterActionBuilder_.getMessage();
        }
        return com.google.cloud.discoveryengine.v1beta.Control.FilterAction.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Defines a filter-type control
     * Currently not supported by Recommendation
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.Control.FilterAction filter_action = 7;</code>
     */
    public Builder setFilterAction(
        com.google.cloud.discoveryengine.v1beta.Control.FilterAction value) {
      if (filterActionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        action_ = value;
        onChanged();
      } else {
        filterActionBuilder_.setMessage(value);
      }
      actionCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Defines a filter-type control
     * Currently not supported by Recommendation
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.Control.FilterAction filter_action = 7;</code>
     */
    public Builder setFilterAction(
        com.google.cloud.discoveryengine.v1beta.Control.FilterAction.Builder builderForValue) {
      if (filterActionBuilder_ == null) {
        action_ = builderForValue.build();
        onChanged();
      } else {
        filterActionBuilder_.setMessage(builderForValue.build());
      }
      actionCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Defines a filter-type control
     * Currently not supported by Recommendation
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.Control.FilterAction filter_action = 7;</code>
     */
    public Builder mergeFilterAction(
        com.google.cloud.discoveryengine.v1beta.Control.FilterAction value) {
      if (filterActionBuilder_ == null) {
        if (actionCase_ == 7
            && action_
                != com.google.cloud.discoveryengine.v1beta.Control.FilterAction
                    .getDefaultInstance()) {
          action_ =
              com.google.cloud.discoveryengine.v1beta.Control.FilterAction.newBuilder(
                      (com.google.cloud.discoveryengine.v1beta.Control.FilterAction) action_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          action_ = value;
        }
        onChanged();
      } else {
        if (actionCase_ == 7) {
          filterActionBuilder_.mergeFrom(value);
        } else {
          filterActionBuilder_.setMessage(value);
        }
      }
      actionCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Defines a filter-type control
     * Currently not supported by Recommendation
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.Control.FilterAction filter_action = 7;</code>
     */
    public Builder clearFilterAction() {
      if (filterActionBuilder_ == null) {
        if (actionCase_ == 7) {
          actionCase_ = 0;
          action_ = null;
          onChanged();
        }
      } else {
        if (actionCase_ == 7) {
          actionCase_ = 0;
          action_ = null;
        }
        filterActionBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Defines a filter-type control
     * Currently not supported by Recommendation
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.Control.FilterAction filter_action = 7;</code>
     */
    public com.google.cloud.discoveryengine.v1beta.Control.FilterAction.Builder
        getFilterActionBuilder() {
      return getFilterActionFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Defines a filter-type control
     * Currently not supported by Recommendation
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.Control.FilterAction filter_action = 7;</code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.Control.FilterActionOrBuilder
        getFilterActionOrBuilder() {
      if ((actionCase_ == 7) && (filterActionBuilder_ != null)) {
        return filterActionBuilder_.getMessageOrBuilder();
      } else {
        if (actionCase_ == 7) {
          return (com.google.cloud.discoveryengine.v1beta.Control.FilterAction) action_;
        }
        return com.google.cloud.discoveryengine.v1beta.Control.FilterAction.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Defines a filter-type control
     * Currently not supported by Recommendation
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.Control.FilterAction filter_action = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1beta.Control.FilterAction,
            com.google.cloud.discoveryengine.v1beta.Control.FilterAction.Builder,
            com.google.cloud.discoveryengine.v1beta.Control.FilterActionOrBuilder>
        getFilterActionFieldBuilder() {
      if (filterActionBuilder_ == null) {
        if (!(actionCase_ == 7)) {
          action_ =
              com.google.cloud.discoveryengine.v1beta.Control.FilterAction.getDefaultInstance();
        }
        filterActionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1beta.Control.FilterAction,
                com.google.cloud.discoveryengine.v1beta.Control.FilterAction.Builder,
                com.google.cloud.discoveryengine.v1beta.Control.FilterActionOrBuilder>(
                (com.google.cloud.discoveryengine.v1beta.Control.FilterAction) action_,
                getParentForChildren(),
                isClean());
        action_ = null;
      }
      actionCase_ = 7;
      onChanged();
      return filterActionBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1beta.Control.RedirectAction,
            com.google.cloud.discoveryengine.v1beta.Control.RedirectAction.Builder,
            com.google.cloud.discoveryengine.v1beta.Control.RedirectActionOrBuilder>
        redirectActionBuilder_;
    /**
     *
     *
     * <pre>
     * Defines a redirect-type control.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.Control.RedirectAction redirect_action = 9;</code>
     *
     * @return Whether the redirectAction field is set.
     */
    @java.lang.Override
    public boolean hasRedirectAction() {
      return actionCase_ == 9;
    }
    /**
     *
     *
     * <pre>
     * Defines a redirect-type control.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.Control.RedirectAction redirect_action = 9;</code>
     *
     * @return The redirectAction.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.Control.RedirectAction getRedirectAction() {
      if (redirectActionBuilder_ == null) {
        if (actionCase_ == 9) {
          return (com.google.cloud.discoveryengine.v1beta.Control.RedirectAction) action_;
        }
        return com.google.cloud.discoveryengine.v1beta.Control.RedirectAction.getDefaultInstance();
      } else {
        if (actionCase_ == 9) {
          return redirectActionBuilder_.getMessage();
        }
        return com.google.cloud.discoveryengine.v1beta.Control.RedirectAction.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Defines a redirect-type control.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.Control.RedirectAction redirect_action = 9;</code>
     */
    public Builder setRedirectAction(
        com.google.cloud.discoveryengine.v1beta.Control.RedirectAction value) {
      if (redirectActionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        action_ = value;
        onChanged();
      } else {
        redirectActionBuilder_.setMessage(value);
      }
      actionCase_ = 9;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Defines a redirect-type control.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.Control.RedirectAction redirect_action = 9;</code>
     */
    public Builder setRedirectAction(
        com.google.cloud.discoveryengine.v1beta.Control.RedirectAction.Builder builderForValue) {
      if (redirectActionBuilder_ == null) {
        action_ = builderForValue.build();
        onChanged();
      } else {
        redirectActionBuilder_.setMessage(builderForValue.build());
      }
      actionCase_ = 9;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Defines a redirect-type control.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.Control.RedirectAction redirect_action = 9;</code>
     */
    public Builder mergeRedirectAction(
        com.google.cloud.discoveryengine.v1beta.Control.RedirectAction value) {
      if (redirectActionBuilder_ == null) {
        if (actionCase_ == 9
            && action_
                != com.google.cloud.discoveryengine.v1beta.Control.RedirectAction
                    .getDefaultInstance()) {
          action_ =
              com.google.cloud.discoveryengine.v1beta.Control.RedirectAction.newBuilder(
                      (com.google.cloud.discoveryengine.v1beta.Control.RedirectAction) action_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          action_ = value;
        }
        onChanged();
      } else {
        if (actionCase_ == 9) {
          redirectActionBuilder_.mergeFrom(value);
        } else {
          redirectActionBuilder_.setMessage(value);
        }
      }
      actionCase_ = 9;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Defines a redirect-type control.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.Control.RedirectAction redirect_action = 9;</code>
     */
    public Builder clearRedirectAction() {
      if (redirectActionBuilder_ == null) {
        if (actionCase_ == 9) {
          actionCase_ = 0;
          action_ = null;
          onChanged();
        }
      } else {
        if (actionCase_ == 9) {
          actionCase_ = 0;
          action_ = null;
        }
        redirectActionBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Defines a redirect-type control.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.Control.RedirectAction redirect_action = 9;</code>
     */
    public com.google.cloud.discoveryengine.v1beta.Control.RedirectAction.Builder
        getRedirectActionBuilder() {
      return getRedirectActionFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Defines a redirect-type control.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.Control.RedirectAction redirect_action = 9;</code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.Control.RedirectActionOrBuilder
        getRedirectActionOrBuilder() {
      if ((actionCase_ == 9) && (redirectActionBuilder_ != null)) {
        return redirectActionBuilder_.getMessageOrBuilder();
      } else {
        if (actionCase_ == 9) {
          return (com.google.cloud.discoveryengine.v1beta.Control.RedirectAction) action_;
        }
        return com.google.cloud.discoveryengine.v1beta.Control.RedirectAction.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Defines a redirect-type control.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.Control.RedirectAction redirect_action = 9;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1beta.Control.RedirectAction,
            com.google.cloud.discoveryengine.v1beta.Control.RedirectAction.Builder,
            com.google.cloud.discoveryengine.v1beta.Control.RedirectActionOrBuilder>
        getRedirectActionFieldBuilder() {
      if (redirectActionBuilder_ == null) {
        if (!(actionCase_ == 9)) {
          action_ =
              com.google.cloud.discoveryengine.v1beta.Control.RedirectAction.getDefaultInstance();
        }
        redirectActionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1beta.Control.RedirectAction,
                com.google.cloud.discoveryengine.v1beta.Control.RedirectAction.Builder,
                com.google.cloud.discoveryengine.v1beta.Control.RedirectActionOrBuilder>(
                (com.google.cloud.discoveryengine.v1beta.Control.RedirectAction) action_,
                getParentForChildren(),
                isClean());
        action_ = null;
      }
      actionCase_ = 9;
      onChanged();
      return redirectActionBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1beta.Control.SynonymsAction,
            com.google.cloud.discoveryengine.v1beta.Control.SynonymsAction.Builder,
            com.google.cloud.discoveryengine.v1beta.Control.SynonymsActionOrBuilder>
        synonymsActionBuilder_;
    /**
     *
     *
     * <pre>
     * Treats a group of terms as synonyms of one another.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.Control.SynonymsAction synonyms_action = 10;
     * </code>
     *
     * @return Whether the synonymsAction field is set.
     */
    @java.lang.Override
    public boolean hasSynonymsAction() {
      return actionCase_ == 10;
    }
    /**
     *
     *
     * <pre>
     * Treats a group of terms as synonyms of one another.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.Control.SynonymsAction synonyms_action = 10;
     * </code>
     *
     * @return The synonymsAction.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.Control.SynonymsAction getSynonymsAction() {
      if (synonymsActionBuilder_ == null) {
        if (actionCase_ == 10) {
          return (com.google.cloud.discoveryengine.v1beta.Control.SynonymsAction) action_;
        }
        return com.google.cloud.discoveryengine.v1beta.Control.SynonymsAction.getDefaultInstance();
      } else {
        if (actionCase_ == 10) {
          return synonymsActionBuilder_.getMessage();
        }
        return com.google.cloud.discoveryengine.v1beta.Control.SynonymsAction.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Treats a group of terms as synonyms of one another.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.Control.SynonymsAction synonyms_action = 10;
     * </code>
     */
    public Builder setSynonymsAction(
        com.google.cloud.discoveryengine.v1beta.Control.SynonymsAction value) {
      if (synonymsActionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        action_ = value;
        onChanged();
      } else {
        synonymsActionBuilder_.setMessage(value);
      }
      actionCase_ = 10;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Treats a group of terms as synonyms of one another.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.Control.SynonymsAction synonyms_action = 10;
     * </code>
     */
    public Builder setSynonymsAction(
        com.google.cloud.discoveryengine.v1beta.Control.SynonymsAction.Builder builderForValue) {
      if (synonymsActionBuilder_ == null) {
        action_ = builderForValue.build();
        onChanged();
      } else {
        synonymsActionBuilder_.setMessage(builderForValue.build());
      }
      actionCase_ = 10;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Treats a group of terms as synonyms of one another.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.Control.SynonymsAction synonyms_action = 10;
     * </code>
     */
    public Builder mergeSynonymsAction(
        com.google.cloud.discoveryengine.v1beta.Control.SynonymsAction value) {
      if (synonymsActionBuilder_ == null) {
        if (actionCase_ == 10
            && action_
                != com.google.cloud.discoveryengine.v1beta.Control.SynonymsAction
                    .getDefaultInstance()) {
          action_ =
              com.google.cloud.discoveryengine.v1beta.Control.SynonymsAction.newBuilder(
                      (com.google.cloud.discoveryengine.v1beta.Control.SynonymsAction) action_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          action_ = value;
        }
        onChanged();
      } else {
        if (actionCase_ == 10) {
          synonymsActionBuilder_.mergeFrom(value);
        } else {
          synonymsActionBuilder_.setMessage(value);
        }
      }
      actionCase_ = 10;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Treats a group of terms as synonyms of one another.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.Control.SynonymsAction synonyms_action = 10;
     * </code>
     */
    public Builder clearSynonymsAction() {
      if (synonymsActionBuilder_ == null) {
        if (actionCase_ == 10) {
          actionCase_ = 0;
          action_ = null;
          onChanged();
        }
      } else {
        if (actionCase_ == 10) {
          actionCase_ = 0;
          action_ = null;
        }
        synonymsActionBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Treats a group of terms as synonyms of one another.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.Control.SynonymsAction synonyms_action = 10;
     * </code>
     */
    public com.google.cloud.discoveryengine.v1beta.Control.SynonymsAction.Builder
        getSynonymsActionBuilder() {
      return getSynonymsActionFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Treats a group of terms as synonyms of one another.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.Control.SynonymsAction synonyms_action = 10;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.Control.SynonymsActionOrBuilder
        getSynonymsActionOrBuilder() {
      if ((actionCase_ == 10) && (synonymsActionBuilder_ != null)) {
        return synonymsActionBuilder_.getMessageOrBuilder();
      } else {
        if (actionCase_ == 10) {
          return (com.google.cloud.discoveryengine.v1beta.Control.SynonymsAction) action_;
        }
        return com.google.cloud.discoveryengine.v1beta.Control.SynonymsAction.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Treats a group of terms as synonyms of one another.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.Control.SynonymsAction synonyms_action = 10;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1beta.Control.SynonymsAction,
            com.google.cloud.discoveryengine.v1beta.Control.SynonymsAction.Builder,
            com.google.cloud.discoveryengine.v1beta.Control.SynonymsActionOrBuilder>
        getSynonymsActionFieldBuilder() {
      if (synonymsActionBuilder_ == null) {
        if (!(actionCase_ == 10)) {
          action_ =
              com.google.cloud.discoveryengine.v1beta.Control.SynonymsAction.getDefaultInstance();
        }
        synonymsActionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1beta.Control.SynonymsAction,
                com.google.cloud.discoveryengine.v1beta.Control.SynonymsAction.Builder,
                com.google.cloud.discoveryengine.v1beta.Control.SynonymsActionOrBuilder>(
                (com.google.cloud.discoveryengine.v1beta.Control.SynonymsAction) action_,
                getParentForChildren(),
                isClean());
        action_ = null;
      }
      actionCase_ = 10;
      onChanged();
      return synonymsActionBuilder_;
    }

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Immutable. Fully qualified name
     * `projects/&#42;&#47;locations/global/dataStore/&#42;&#47;controls/&#42;`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. Fully qualified name
     * `projects/&#42;&#47;locations/global/dataStore/&#42;&#47;controls/&#42;`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. Fully qualified name
     * `projects/&#42;&#47;locations/global/dataStore/&#42;&#47;controls/&#42;`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. Fully qualified name
     * `projects/&#42;&#47;locations/global/dataStore/&#42;&#47;controls/&#42;`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. Fully qualified name
     * `projects/&#42;&#47;locations/global/dataStore/&#42;&#47;controls/&#42;`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * Required. Human readable name. The identifier used in UI views.
     *
     * Must be UTF-8 encoded string. Length limit is 128 characters.
     * Otherwise an INVALID ARGUMENT error is thrown.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Human readable name. The identifier used in UI views.
     *
     * Must be UTF-8 encoded string. Length limit is 128 characters.
     * Otherwise an INVALID ARGUMENT error is thrown.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Human readable name. The identifier used in UI views.
     *
     * Must be UTF-8 encoded string. Length limit is 128 characters.
     * Otherwise an INVALID ARGUMENT error is thrown.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Human readable name. The identifier used in UI views.
     *
     * Must be UTF-8 encoded string. Length limit is 128 characters.
     * Otherwise an INVALID ARGUMENT error is thrown.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Human readable name. The identifier used in UI views.
     *
     * Must be UTF-8 encoded string. Length limit is 128 characters.
     * Otherwise an INVALID ARGUMENT error is thrown.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList associatedServingConfigIds_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureAssociatedServingConfigIdsIsMutable() {
      if (!associatedServingConfigIds_.isModifiable()) {
        associatedServingConfigIds_ =
            new com.google.protobuf.LazyStringArrayList(associatedServingConfigIds_);
      }
      bitField0_ |= 0x00000040;
    }
    /**
     *
     *
     * <pre>
     * Output only. List of all
     * [ServingConfig][google.cloud.discoveryengine.v1beta.ServingConfig] ids this
     * control is attached to. May take up to 10 minutes to update after changes.
     * </pre>
     *
     * <code>
     * repeated string associated_serving_config_ids = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return A list containing the associatedServingConfigIds.
     */
    public com.google.protobuf.ProtocolStringList getAssociatedServingConfigIdsList() {
      associatedServingConfigIds_.makeImmutable();
      return associatedServingConfigIds_;
    }
    /**
     *
     *
     * <pre>
     * Output only. List of all
     * [ServingConfig][google.cloud.discoveryengine.v1beta.ServingConfig] ids this
     * control is attached to. May take up to 10 minutes to update after changes.
     * </pre>
     *
     * <code>
     * repeated string associated_serving_config_ids = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The count of associatedServingConfigIds.
     */
    public int getAssociatedServingConfigIdsCount() {
      return associatedServingConfigIds_.size();
    }
    /**
     *
     *
     * <pre>
     * Output only. List of all
     * [ServingConfig][google.cloud.discoveryengine.v1beta.ServingConfig] ids this
     * control is attached to. May take up to 10 minutes to update after changes.
     * </pre>
     *
     * <code>
     * repeated string associated_serving_config_ids = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param index The index of the element to return.
     * @return The associatedServingConfigIds at the given index.
     */
    public java.lang.String getAssociatedServingConfigIds(int index) {
      return associatedServingConfigIds_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. List of all
     * [ServingConfig][google.cloud.discoveryengine.v1beta.ServingConfig] ids this
     * control is attached to. May take up to 10 minutes to update after changes.
     * </pre>
     *
     * <code>
     * repeated string associated_serving_config_ids = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the associatedServingConfigIds at the given index.
     */
    public com.google.protobuf.ByteString getAssociatedServingConfigIdsBytes(int index) {
      return associatedServingConfigIds_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. List of all
     * [ServingConfig][google.cloud.discoveryengine.v1beta.ServingConfig] ids this
     * control is attached to. May take up to 10 minutes to update after changes.
     * </pre>
     *
     * <code>
     * repeated string associated_serving_config_ids = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The associatedServingConfigIds to set.
     * @return This builder for chaining.
     */
    public Builder setAssociatedServingConfigIds(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureAssociatedServingConfigIdsIsMutable();
      associatedServingConfigIds_.set(index, value);
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. List of all
     * [ServingConfig][google.cloud.discoveryengine.v1beta.ServingConfig] ids this
     * control is attached to. May take up to 10 minutes to update after changes.
     * </pre>
     *
     * <code>
     * repeated string associated_serving_config_ids = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The associatedServingConfigIds to add.
     * @return This builder for chaining.
     */
    public Builder addAssociatedServingConfigIds(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureAssociatedServingConfigIdsIsMutable();
      associatedServingConfigIds_.add(value);
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. List of all
     * [ServingConfig][google.cloud.discoveryengine.v1beta.ServingConfig] ids this
     * control is attached to. May take up to 10 minutes to update after changes.
     * </pre>
     *
     * <code>
     * repeated string associated_serving_config_ids = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param values The associatedServingConfigIds to add.
     * @return This builder for chaining.
     */
    public Builder addAllAssociatedServingConfigIds(java.lang.Iterable<java.lang.String> values) {
      ensureAssociatedServingConfigIdsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, associatedServingConfigIds_);
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. List of all
     * [ServingConfig][google.cloud.discoveryengine.v1beta.ServingConfig] ids this
     * control is attached to. May take up to 10 minutes to update after changes.
     * </pre>
     *
     * <code>
     * repeated string associated_serving_config_ids = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAssociatedServingConfigIds() {
      associatedServingConfigIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000040);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. List of all
     * [ServingConfig][google.cloud.discoveryengine.v1beta.ServingConfig] ids this
     * control is attached to. May take up to 10 minutes to update after changes.
     * </pre>
     *
     * <code>
     * repeated string associated_serving_config_ids = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The bytes of the associatedServingConfigIds to add.
     * @return This builder for chaining.
     */
    public Builder addAssociatedServingConfigIdsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureAssociatedServingConfigIdsIsMutable();
      associatedServingConfigIds_.add(value);
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private int solutionType_ = 0;
    /**
     *
     *
     * <pre>
     * Required. Immutable. What solution the control belongs to.
     *
     * Must be compatible with vertical of resource.
     * Otherwise an INVALID ARGUMENT error is thrown.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.SolutionType solution_type = 4 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The enum numeric value on the wire for solutionType.
     */
    @java.lang.Override
    public int getSolutionTypeValue() {
      return solutionType_;
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. What solution the control belongs to.
     *
     * Must be compatible with vertical of resource.
     * Otherwise an INVALID ARGUMENT error is thrown.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.SolutionType solution_type = 4 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param value The enum numeric value on the wire for solutionType to set.
     * @return This builder for chaining.
     */
    public Builder setSolutionTypeValue(int value) {
      solutionType_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. What solution the control belongs to.
     *
     * Must be compatible with vertical of resource.
     * Otherwise an INVALID ARGUMENT error is thrown.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.SolutionType solution_type = 4 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The solutionType.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.SolutionType getSolutionType() {
      com.google.cloud.discoveryengine.v1beta.SolutionType result =
          com.google.cloud.discoveryengine.v1beta.SolutionType.forNumber(solutionType_);
      return result == null
          ? com.google.cloud.discoveryengine.v1beta.SolutionType.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. What solution the control belongs to.
     *
     * Must be compatible with vertical of resource.
     * Otherwise an INVALID ARGUMENT error is thrown.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.SolutionType solution_type = 4 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param value The solutionType to set.
     * @return This builder for chaining.
     */
    public Builder setSolutionType(com.google.cloud.discoveryengine.v1beta.SolutionType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000080;
      solutionType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. What solution the control belongs to.
     *
     * Must be compatible with vertical of resource.
     * Otherwise an INVALID ARGUMENT error is thrown.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.SolutionType solution_type = 4 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSolutionType() {
      bitField0_ = (bitField0_ & ~0x00000080);
      solutionType_ = 0;
      onChanged();
      return this;
    }

    private java.util.List<java.lang.Integer> useCases_ = java.util.Collections.emptyList();

    private void ensureUseCasesIsMutable() {
      if (!((bitField0_ & 0x00000100) != 0)) {
        useCases_ = new java.util.ArrayList<java.lang.Integer>(useCases_);
        bitField0_ |= 0x00000100;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies the use case for the control.
     * Affects what condition fields can be set.
     * Only applies to
     * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH].
     * Currently only allow one use case per control.
     * Must be set when solution_type is
     * [SolutionType.SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.SearchUseCase use_cases = 8;</code>
     *
     * @return A list containing the useCases.
     */
    public java.util.List<com.google.cloud.discoveryengine.v1beta.SearchUseCase> getUseCasesList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer, com.google.cloud.discoveryengine.v1beta.SearchUseCase>(
          useCases_, useCases_converter_);
    }
    /**
     *
     *
     * <pre>
     * Specifies the use case for the control.
     * Affects what condition fields can be set.
     * Only applies to
     * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH].
     * Currently only allow one use case per control.
     * Must be set when solution_type is
     * [SolutionType.SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.SearchUseCase use_cases = 8;</code>
     *
     * @return The count of useCases.
     */
    public int getUseCasesCount() {
      return useCases_.size();
    }
    /**
     *
     *
     * <pre>
     * Specifies the use case for the control.
     * Affects what condition fields can be set.
     * Only applies to
     * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH].
     * Currently only allow one use case per control.
     * Must be set when solution_type is
     * [SolutionType.SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.SearchUseCase use_cases = 8;</code>
     *
     * @param index The index of the element to return.
     * @return The useCases at the given index.
     */
    public com.google.cloud.discoveryengine.v1beta.SearchUseCase getUseCases(int index) {
      return useCases_converter_.convert(useCases_.get(index));
    }
    /**
     *
     *
     * <pre>
     * Specifies the use case for the control.
     * Affects what condition fields can be set.
     * Only applies to
     * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH].
     * Currently only allow one use case per control.
     * Must be set when solution_type is
     * [SolutionType.SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.SearchUseCase use_cases = 8;</code>
     *
     * @param index The index to set the value at.
     * @param value The useCases to set.
     * @return This builder for chaining.
     */
    public Builder setUseCases(
        int index, com.google.cloud.discoveryengine.v1beta.SearchUseCase value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureUseCasesIsMutable();
      useCases_.set(index, value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the use case for the control.
     * Affects what condition fields can be set.
     * Only applies to
     * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH].
     * Currently only allow one use case per control.
     * Must be set when solution_type is
     * [SolutionType.SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.SearchUseCase use_cases = 8;</code>
     *
     * @param value The useCases to add.
     * @return This builder for chaining.
     */
    public Builder addUseCases(com.google.cloud.discoveryengine.v1beta.SearchUseCase value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureUseCasesIsMutable();
      useCases_.add(value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the use case for the control.
     * Affects what condition fields can be set.
     * Only applies to
     * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH].
     * Currently only allow one use case per control.
     * Must be set when solution_type is
     * [SolutionType.SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.SearchUseCase use_cases = 8;</code>
     *
     * @param values The useCases to add.
     * @return This builder for chaining.
     */
    public Builder addAllUseCases(
        java.lang.Iterable<? extends com.google.cloud.discoveryengine.v1beta.SearchUseCase>
            values) {
      ensureUseCasesIsMutable();
      for (com.google.cloud.discoveryengine.v1beta.SearchUseCase value : values) {
        useCases_.add(value.getNumber());
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the use case for the control.
     * Affects what condition fields can be set.
     * Only applies to
     * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH].
     * Currently only allow one use case per control.
     * Must be set when solution_type is
     * [SolutionType.SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.SearchUseCase use_cases = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUseCases() {
      useCases_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the use case for the control.
     * Affects what condition fields can be set.
     * Only applies to
     * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH].
     * Currently only allow one use case per control.
     * Must be set when solution_type is
     * [SolutionType.SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.SearchUseCase use_cases = 8;</code>
     *
     * @return A list containing the enum numeric values on the wire for useCases.
     */
    public java.util.List<java.lang.Integer> getUseCasesValueList() {
      return java.util.Collections.unmodifiableList(useCases_);
    }
    /**
     *
     *
     * <pre>
     * Specifies the use case for the control.
     * Affects what condition fields can be set.
     * Only applies to
     * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH].
     * Currently only allow one use case per control.
     * Must be set when solution_type is
     * [SolutionType.SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.SearchUseCase use_cases = 8;</code>
     *
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of useCases at the given index.
     */
    public int getUseCasesValue(int index) {
      return useCases_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Specifies the use case for the control.
     * Affects what condition fields can be set.
     * Only applies to
     * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH].
     * Currently only allow one use case per control.
     * Must be set when solution_type is
     * [SolutionType.SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.SearchUseCase use_cases = 8;</code>
     *
     * @param index The index to set the value at.
     * @param value The enum numeric value on the wire for useCases to set.
     * @return This builder for chaining.
     */
    public Builder setUseCasesValue(int index, int value) {
      ensureUseCasesIsMutable();
      useCases_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the use case for the control.
     * Affects what condition fields can be set.
     * Only applies to
     * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH].
     * Currently only allow one use case per control.
     * Must be set when solution_type is
     * [SolutionType.SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.SearchUseCase use_cases = 8;</code>
     *
     * @param value The enum numeric value on the wire for useCases to add.
     * @return This builder for chaining.
     */
    public Builder addUseCasesValue(int value) {
      ensureUseCasesIsMutable();
      useCases_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the use case for the control.
     * Affects what condition fields can be set.
     * Only applies to
     * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH].
     * Currently only allow one use case per control.
     * Must be set when solution_type is
     * [SolutionType.SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.SearchUseCase use_cases = 8;</code>
     *
     * @param values The enum numeric values on the wire for useCases to add.
     * @return This builder for chaining.
     */
    public Builder addAllUseCasesValue(java.lang.Iterable<java.lang.Integer> values) {
      ensureUseCasesIsMutable();
      for (int value : values) {
        useCases_.add(value);
      }
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.discoveryengine.v1beta.Condition> conditions_ =
        java.util.Collections.emptyList();

    private void ensureConditionsIsMutable() {
      if (!((bitField0_ & 0x00000200) != 0)) {
        conditions_ =
            new java.util.ArrayList<com.google.cloud.discoveryengine.v1beta.Condition>(conditions_);
        bitField0_ |= 0x00000200;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.discoveryengine.v1beta.Condition,
            com.google.cloud.discoveryengine.v1beta.Condition.Builder,
            com.google.cloud.discoveryengine.v1beta.ConditionOrBuilder>
        conditionsBuilder_;

    /**
     *
     *
     * <pre>
     * Determines when the associated action will trigger.
     *
     * Omit to always apply the action.
     * Currently only a single condition may be specified.
     * Otherwise an INVALID ARGUMENT error is thrown.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.Condition conditions = 5;</code>
     */
    public java.util.List<com.google.cloud.discoveryengine.v1beta.Condition> getConditionsList() {
      if (conditionsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(conditions_);
      } else {
        return conditionsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Determines when the associated action will trigger.
     *
     * Omit to always apply the action.
     * Currently only a single condition may be specified.
     * Otherwise an INVALID ARGUMENT error is thrown.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.Condition conditions = 5;</code>
     */
    public int getConditionsCount() {
      if (conditionsBuilder_ == null) {
        return conditions_.size();
      } else {
        return conditionsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Determines when the associated action will trigger.
     *
     * Omit to always apply the action.
     * Currently only a single condition may be specified.
     * Otherwise an INVALID ARGUMENT error is thrown.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.Condition conditions = 5;</code>
     */
    public com.google.cloud.discoveryengine.v1beta.Condition getConditions(int index) {
      if (conditionsBuilder_ == null) {
        return conditions_.get(index);
      } else {
        return conditionsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Determines when the associated action will trigger.
     *
     * Omit to always apply the action.
     * Currently only a single condition may be specified.
     * Otherwise an INVALID ARGUMENT error is thrown.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.Condition conditions = 5;</code>
     */
    public Builder setConditions(
        int index, com.google.cloud.discoveryengine.v1beta.Condition value) {
      if (conditionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureConditionsIsMutable();
        conditions_.set(index, value);
        onChanged();
      } else {
        conditionsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Determines when the associated action will trigger.
     *
     * Omit to always apply the action.
     * Currently only a single condition may be specified.
     * Otherwise an INVALID ARGUMENT error is thrown.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.Condition conditions = 5;</code>
     */
    public Builder setConditions(
        int index, com.google.cloud.discoveryengine.v1beta.Condition.Builder builderForValue) {
      if (conditionsBuilder_ == null) {
        ensureConditionsIsMutable();
        conditions_.set(index, builderForValue.build());
        onChanged();
      } else {
        conditionsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Determines when the associated action will trigger.
     *
     * Omit to always apply the action.
     * Currently only a single condition may be specified.
     * Otherwise an INVALID ARGUMENT error is thrown.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.Condition conditions = 5;</code>
     */
    public Builder addConditions(com.google.cloud.discoveryengine.v1beta.Condition value) {
      if (conditionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureConditionsIsMutable();
        conditions_.add(value);
        onChanged();
      } else {
        conditionsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Determines when the associated action will trigger.
     *
     * Omit to always apply the action.
     * Currently only a single condition may be specified.
     * Otherwise an INVALID ARGUMENT error is thrown.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.Condition conditions = 5;</code>
     */
    public Builder addConditions(
        int index, com.google.cloud.discoveryengine.v1beta.Condition value) {
      if (conditionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureConditionsIsMutable();
        conditions_.add(index, value);
        onChanged();
      } else {
        conditionsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Determines when the associated action will trigger.
     *
     * Omit to always apply the action.
     * Currently only a single condition may be specified.
     * Otherwise an INVALID ARGUMENT error is thrown.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.Condition conditions = 5;</code>
     */
    public Builder addConditions(
        com.google.cloud.discoveryengine.v1beta.Condition.Builder builderForValue) {
      if (conditionsBuilder_ == null) {
        ensureConditionsIsMutable();
        conditions_.add(builderForValue.build());
        onChanged();
      } else {
        conditionsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Determines when the associated action will trigger.
     *
     * Omit to always apply the action.
     * Currently only a single condition may be specified.
     * Otherwise an INVALID ARGUMENT error is thrown.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.Condition conditions = 5;</code>
     */
    public Builder addConditions(
        int index, com.google.cloud.discoveryengine.v1beta.Condition.Builder builderForValue) {
      if (conditionsBuilder_ == null) {
        ensureConditionsIsMutable();
        conditions_.add(index, builderForValue.build());
        onChanged();
      } else {
        conditionsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Determines when the associated action will trigger.
     *
     * Omit to always apply the action.
     * Currently only a single condition may be specified.
     * Otherwise an INVALID ARGUMENT error is thrown.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.Condition conditions = 5;</code>
     */
    public Builder addAllConditions(
        java.lang.Iterable<? extends com.google.cloud.discoveryengine.v1beta.Condition> values) {
      if (conditionsBuilder_ == null) {
        ensureConditionsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, conditions_);
        onChanged();
      } else {
        conditionsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Determines when the associated action will trigger.
     *
     * Omit to always apply the action.
     * Currently only a single condition may be specified.
     * Otherwise an INVALID ARGUMENT error is thrown.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.Condition conditions = 5;</code>
     */
    public Builder clearConditions() {
      if (conditionsBuilder_ == null) {
        conditions_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000200);
        onChanged();
      } else {
        conditionsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Determines when the associated action will trigger.
     *
     * Omit to always apply the action.
     * Currently only a single condition may be specified.
     * Otherwise an INVALID ARGUMENT error is thrown.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.Condition conditions = 5;</code>
     */
    public Builder removeConditions(int index) {
      if (conditionsBuilder_ == null) {
        ensureConditionsIsMutable();
        conditions_.remove(index);
        onChanged();
      } else {
        conditionsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Determines when the associated action will trigger.
     *
     * Omit to always apply the action.
     * Currently only a single condition may be specified.
     * Otherwise an INVALID ARGUMENT error is thrown.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.Condition conditions = 5;</code>
     */
    public com.google.cloud.discoveryengine.v1beta.Condition.Builder getConditionsBuilder(
        int index) {
      return getConditionsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Determines when the associated action will trigger.
     *
     * Omit to always apply the action.
     * Currently only a single condition may be specified.
     * Otherwise an INVALID ARGUMENT error is thrown.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.Condition conditions = 5;</code>
     */
    public com.google.cloud.discoveryengine.v1beta.ConditionOrBuilder getConditionsOrBuilder(
        int index) {
      if (conditionsBuilder_ == null) {
        return conditions_.get(index);
      } else {
        return conditionsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Determines when the associated action will trigger.
     *
     * Omit to always apply the action.
     * Currently only a single condition may be specified.
     * Otherwise an INVALID ARGUMENT error is thrown.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.Condition conditions = 5;</code>
     */
    public java.util.List<? extends com.google.cloud.discoveryengine.v1beta.ConditionOrBuilder>
        getConditionsOrBuilderList() {
      if (conditionsBuilder_ != null) {
        return conditionsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(conditions_);
      }
    }
    /**
     *
     *
     * <pre>
     * Determines when the associated action will trigger.
     *
     * Omit to always apply the action.
     * Currently only a single condition may be specified.
     * Otherwise an INVALID ARGUMENT error is thrown.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.Condition conditions = 5;</code>
     */
    public com.google.cloud.discoveryengine.v1beta.Condition.Builder addConditionsBuilder() {
      return getConditionsFieldBuilder()
          .addBuilder(com.google.cloud.discoveryengine.v1beta.Condition.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Determines when the associated action will trigger.
     *
     * Omit to always apply the action.
     * Currently only a single condition may be specified.
     * Otherwise an INVALID ARGUMENT error is thrown.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.Condition conditions = 5;</code>
     */
    public com.google.cloud.discoveryengine.v1beta.Condition.Builder addConditionsBuilder(
        int index) {
      return getConditionsFieldBuilder()
          .addBuilder(
              index, com.google.cloud.discoveryengine.v1beta.Condition.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Determines when the associated action will trigger.
     *
     * Omit to always apply the action.
     * Currently only a single condition may be specified.
     * Otherwise an INVALID ARGUMENT error is thrown.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.Condition conditions = 5;</code>
     */
    public java.util.List<com.google.cloud.discoveryengine.v1beta.Condition.Builder>
        getConditionsBuilderList() {
      return getConditionsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.discoveryengine.v1beta.Condition,
            com.google.cloud.discoveryengine.v1beta.Condition.Builder,
            com.google.cloud.discoveryengine.v1beta.ConditionOrBuilder>
        getConditionsFieldBuilder() {
      if (conditionsBuilder_ == null) {
        conditionsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.discoveryengine.v1beta.Condition,
                com.google.cloud.discoveryengine.v1beta.Condition.Builder,
                com.google.cloud.discoveryengine.v1beta.ConditionOrBuilder>(
                conditions_, ((bitField0_ & 0x00000200) != 0), getParentForChildren(), isClean());
        conditions_ = null;
      }
      return conditionsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.Control)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.Control)
  private static final com.google.cloud.discoveryengine.v1beta.Control DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.discoveryengine.v1beta.Control();
  }

  public static com.google.cloud.discoveryengine.v1beta.Control getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Control> PARSER =
      new com.google.protobuf.AbstractParser<Control>() {
        @java.lang.Override
        public Control parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Control> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Control> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.Control getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
