/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/discoveryengine/v1beta/grounded_generation_service.proto

// Protobuf Java Version: 3.25.4
package com.google.cloud.discoveryengine.v1beta;

/**
 *
 *
 * <pre>
 * Response message for the
 * [GroundedGenerationService.CheckGrounding][google.cloud.discoveryengine.v1beta.GroundedGenerationService.CheckGrounding]
 * method.
 * </pre>
 *
 * Protobuf type {@code google.cloud.discoveryengine.v1beta.CheckGroundingResponse}
 */
public final class CheckGroundingResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.CheckGroundingResponse)
    CheckGroundingResponseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use CheckGroundingResponse.newBuilder() to construct.
  private CheckGroundingResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private CheckGroundingResponse() {
    citedChunks_ = java.util.Collections.emptyList();
    claims_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new CheckGroundingResponse();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.discoveryengine.v1beta.GroundedGenerationServiceProto
        .internal_static_google_cloud_discoveryengine_v1beta_CheckGroundingResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.discoveryengine.v1beta.GroundedGenerationServiceProto
        .internal_static_google_cloud_discoveryengine_v1beta_CheckGroundingResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.discoveryengine.v1beta.CheckGroundingResponse.class,
            com.google.cloud.discoveryengine.v1beta.CheckGroundingResponse.Builder.class);
  }

  public interface ClaimOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1beta.CheckGroundingResponse.Claim)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Position indicating the start of the claim in the answer candidate,
     * measured in bytes.
     * </pre>
     *
     * <code>optional int32 start_pos = 1;</code>
     *
     * @return Whether the startPos field is set.
     */
    boolean hasStartPos();
    /**
     *
     *
     * <pre>
     * Position indicating the start of the claim in the answer candidate,
     * measured in bytes.
     * </pre>
     *
     * <code>optional int32 start_pos = 1;</code>
     *
     * @return The startPos.
     */
    int getStartPos();

    /**
     *
     *
     * <pre>
     * Position indicating the end of the claim in the answer candidate,
     * exclusive.
     * </pre>
     *
     * <code>optional int32 end_pos = 2;</code>
     *
     * @return Whether the endPos field is set.
     */
    boolean hasEndPos();
    /**
     *
     *
     * <pre>
     * Position indicating the end of the claim in the answer candidate,
     * exclusive.
     * </pre>
     *
     * <code>optional int32 end_pos = 2;</code>
     *
     * @return The endPos.
     */
    int getEndPos();

    /**
     *
     *
     * <pre>
     * Text for the claim in the answer candidate. Always provided regardless of
     * whether citations or anti-citations are found.
     * </pre>
     *
     * <code>string claim_text = 3;</code>
     *
     * @return The claimText.
     */
    java.lang.String getClaimText();
    /**
     *
     *
     * <pre>
     * Text for the claim in the answer candidate. Always provided regardless of
     * whether citations or anti-citations are found.
     * </pre>
     *
     * <code>string claim_text = 3;</code>
     *
     * @return The bytes for claimText.
     */
    com.google.protobuf.ByteString getClaimTextBytes();

    /**
     *
     *
     * <pre>
     * A list of indices (into 'cited_chunks') specifying the citations
     * associated with the claim. For instance [1,3,4] means that
     * cited_chunks[1], cited_chunks[3], cited_chunks[4] are the facts cited
     * supporting for the claim. A citation to a fact indicates that the claim
     * is supported by the fact.
     * </pre>
     *
     * <code>repeated int32 citation_indices = 4;</code>
     *
     * @return A list containing the citationIndices.
     */
    java.util.List<java.lang.Integer> getCitationIndicesList();
    /**
     *
     *
     * <pre>
     * A list of indices (into 'cited_chunks') specifying the citations
     * associated with the claim. For instance [1,3,4] means that
     * cited_chunks[1], cited_chunks[3], cited_chunks[4] are the facts cited
     * supporting for the claim. A citation to a fact indicates that the claim
     * is supported by the fact.
     * </pre>
     *
     * <code>repeated int32 citation_indices = 4;</code>
     *
     * @return The count of citationIndices.
     */
    int getCitationIndicesCount();
    /**
     *
     *
     * <pre>
     * A list of indices (into 'cited_chunks') specifying the citations
     * associated with the claim. For instance [1,3,4] means that
     * cited_chunks[1], cited_chunks[3], cited_chunks[4] are the facts cited
     * supporting for the claim. A citation to a fact indicates that the claim
     * is supported by the fact.
     * </pre>
     *
     * <code>repeated int32 citation_indices = 4;</code>
     *
     * @param index The index of the element to return.
     * @return The citationIndices at the given index.
     */
    int getCitationIndices(int index);

    /**
     *
     *
     * <pre>
     * Indicates that this claim required grounding check. When the system
     * decided this claim doesn't require attribution/grounding check, this
     * field will be set to false. In that case, no grounding check was done for
     * the claim and therefore
     * [citation_indices][google.cloud.discoveryengine.v1beta.CheckGroundingResponse.Claim.citation_indices],
     * and
     * [anti_citation_indices][google.cloud.discoveryengine.v1beta.CheckGroundingResponse.Claim.anti_citation_indices]
     * should not be returned.
     * </pre>
     *
     * <code>optional bool grounding_check_required = 6;</code>
     *
     * @return Whether the groundingCheckRequired field is set.
     */
    boolean hasGroundingCheckRequired();
    /**
     *
     *
     * <pre>
     * Indicates that this claim required grounding check. When the system
     * decided this claim doesn't require attribution/grounding check, this
     * field will be set to false. In that case, no grounding check was done for
     * the claim and therefore
     * [citation_indices][google.cloud.discoveryengine.v1beta.CheckGroundingResponse.Claim.citation_indices],
     * and
     * [anti_citation_indices][google.cloud.discoveryengine.v1beta.CheckGroundingResponse.Claim.anti_citation_indices]
     * should not be returned.
     * </pre>
     *
     * <code>optional bool grounding_check_required = 6;</code>
     *
     * @return The groundingCheckRequired.
     */
    boolean getGroundingCheckRequired();
  }
  /**
   *
   *
   * <pre>
   * Text and citation info for a claim in the answer candidate.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1beta.CheckGroundingResponse.Claim}
   */
  public static final class Claim extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.CheckGroundingResponse.Claim)
      ClaimOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Claim.newBuilder() to construct.
    private Claim(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Claim() {
      claimText_ = "";
      citationIndices_ = emptyIntList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Claim();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1beta.GroundedGenerationServiceProto
          .internal_static_google_cloud_discoveryengine_v1beta_CheckGroundingResponse_Claim_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1beta.GroundedGenerationServiceProto
          .internal_static_google_cloud_discoveryengine_v1beta_CheckGroundingResponse_Claim_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1beta.CheckGroundingResponse.Claim.class,
              com.google.cloud.discoveryengine.v1beta.CheckGroundingResponse.Claim.Builder.class);
    }

    private int bitField0_;
    public static final int START_POS_FIELD_NUMBER = 1;
    private int startPos_ = 0;
    /**
     *
     *
     * <pre>
     * Position indicating the start of the claim in the answer candidate,
     * measured in bytes.
     * </pre>
     *
     * <code>optional int32 start_pos = 1;</code>
     *
     * @return Whether the startPos field is set.
     */
    @java.lang.Override
    public boolean hasStartPos() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Position indicating the start of the claim in the answer candidate,
     * measured in bytes.
     * </pre>
     *
     * <code>optional int32 start_pos = 1;</code>
     *
     * @return The startPos.
     */
    @java.lang.Override
    public int getStartPos() {
      return startPos_;
    }

    public static final int END_POS_FIELD_NUMBER = 2;
    private int endPos_ = 0;
    /**
     *
     *
     * <pre>
     * Position indicating the end of the claim in the answer candidate,
     * exclusive.
     * </pre>
     *
     * <code>optional int32 end_pos = 2;</code>
     *
     * @return Whether the endPos field is set.
     */
    @java.lang.Override
    public boolean hasEndPos() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Position indicating the end of the claim in the answer candidate,
     * exclusive.
     * </pre>
     *
     * <code>optional int32 end_pos = 2;</code>
     *
     * @return The endPos.
     */
    @java.lang.Override
    public int getEndPos() {
      return endPos_;
    }

    public static final int CLAIM_TEXT_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private volatile java.lang.Object claimText_ = "";
    /**
     *
     *
     * <pre>
     * Text for the claim in the answer candidate. Always provided regardless of
     * whether citations or anti-citations are found.
     * </pre>
     *
     * <code>string claim_text = 3;</code>
     *
     * @return The claimText.
     */
    @java.lang.Override
    public java.lang.String getClaimText() {
      java.lang.Object ref = claimText_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        claimText_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Text for the claim in the answer candidate. Always provided regardless of
     * whether citations or anti-citations are found.
     * </pre>
     *
     * <code>string claim_text = 3;</code>
     *
     * @return The bytes for claimText.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getClaimTextBytes() {
      java.lang.Object ref = claimText_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        claimText_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int CITATION_INDICES_FIELD_NUMBER = 4;

    @SuppressWarnings("serial")
    private com.google.protobuf.Internal.IntList citationIndices_ = emptyIntList();
    /**
     *
     *
     * <pre>
     * A list of indices (into 'cited_chunks') specifying the citations
     * associated with the claim. For instance [1,3,4] means that
     * cited_chunks[1], cited_chunks[3], cited_chunks[4] are the facts cited
     * supporting for the claim. A citation to a fact indicates that the claim
     * is supported by the fact.
     * </pre>
     *
     * <code>repeated int32 citation_indices = 4;</code>
     *
     * @return A list containing the citationIndices.
     */
    @java.lang.Override
    public java.util.List<java.lang.Integer> getCitationIndicesList() {
      return citationIndices_;
    }
    /**
     *
     *
     * <pre>
     * A list of indices (into 'cited_chunks') specifying the citations
     * associated with the claim. For instance [1,3,4] means that
     * cited_chunks[1], cited_chunks[3], cited_chunks[4] are the facts cited
     * supporting for the claim. A citation to a fact indicates that the claim
     * is supported by the fact.
     * </pre>
     *
     * <code>repeated int32 citation_indices = 4;</code>
     *
     * @return The count of citationIndices.
     */
    public int getCitationIndicesCount() {
      return citationIndices_.size();
    }
    /**
     *
     *
     * <pre>
     * A list of indices (into 'cited_chunks') specifying the citations
     * associated with the claim. For instance [1,3,4] means that
     * cited_chunks[1], cited_chunks[3], cited_chunks[4] are the facts cited
     * supporting for the claim. A citation to a fact indicates that the claim
     * is supported by the fact.
     * </pre>
     *
     * <code>repeated int32 citation_indices = 4;</code>
     *
     * @param index The index of the element to return.
     * @return The citationIndices at the given index.
     */
    public int getCitationIndices(int index) {
      return citationIndices_.getInt(index);
    }

    private int citationIndicesMemoizedSerializedSize = -1;

    public static final int GROUNDING_CHECK_REQUIRED_FIELD_NUMBER = 6;
    private boolean groundingCheckRequired_ = false;
    /**
     *
     *
     * <pre>
     * Indicates that this claim required grounding check. When the system
     * decided this claim doesn't require attribution/grounding check, this
     * field will be set to false. In that case, no grounding check was done for
     * the claim and therefore
     * [citation_indices][google.cloud.discoveryengine.v1beta.CheckGroundingResponse.Claim.citation_indices],
     * and
     * [anti_citation_indices][google.cloud.discoveryengine.v1beta.CheckGroundingResponse.Claim.anti_citation_indices]
     * should not be returned.
     * </pre>
     *
     * <code>optional bool grounding_check_required = 6;</code>
     *
     * @return Whether the groundingCheckRequired field is set.
     */
    @java.lang.Override
    public boolean hasGroundingCheckRequired() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Indicates that this claim required grounding check. When the system
     * decided this claim doesn't require attribution/grounding check, this
     * field will be set to false. In that case, no grounding check was done for
     * the claim and therefore
     * [citation_indices][google.cloud.discoveryengine.v1beta.CheckGroundingResponse.Claim.citation_indices],
     * and
     * [anti_citation_indices][google.cloud.discoveryengine.v1beta.CheckGroundingResponse.Claim.anti_citation_indices]
     * should not be returned.
     * </pre>
     *
     * <code>optional bool grounding_check_required = 6;</code>
     *
     * @return The groundingCheckRequired.
     */
    @java.lang.Override
    public boolean getGroundingCheckRequired() {
      return groundingCheckRequired_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      getSerializedSize();
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeInt32(1, startPos_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeInt32(2, endPos_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(claimText_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, claimText_);
      }
      if (getCitationIndicesList().size() > 0) {
        output.writeUInt32NoTag(34);
        output.writeUInt32NoTag(citationIndicesMemoizedSerializedSize);
      }
      for (int i = 0; i < citationIndices_.size(); i++) {
        output.writeInt32NoTag(citationIndices_.getInt(i));
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        output.writeBool(6, groundingCheckRequired_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(1, startPos_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, endPos_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(claimText_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, claimText_);
      }
      {
        int dataSize = 0;
        for (int i = 0; i < citationIndices_.size(); i++) {
          dataSize +=
              com.google.protobuf.CodedOutputStream.computeInt32SizeNoTag(
                  citationIndices_.getInt(i));
        }
        size += dataSize;
        if (!getCitationIndicesList().isEmpty()) {
          size += 1;
          size += com.google.protobuf.CodedOutputStream.computeInt32SizeNoTag(dataSize);
        }
        citationIndicesMemoizedSerializedSize = dataSize;
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(6, groundingCheckRequired_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.discoveryengine.v1beta.CheckGroundingResponse.Claim)) {
        return super.equals(obj);
      }
      com.google.cloud.discoveryengine.v1beta.CheckGroundingResponse.Claim other =
          (com.google.cloud.discoveryengine.v1beta.CheckGroundingResponse.Claim) obj;

      if (hasStartPos() != other.hasStartPos()) return false;
      if (hasStartPos()) {
        if (getStartPos() != other.getStartPos()) return false;
      }
      if (hasEndPos() != other.hasEndPos()) return false;
      if (hasEndPos()) {
        if (getEndPos() != other.getEndPos()) return false;
      }
      if (!getClaimText().equals(other.getClaimText())) return false;
      if (!getCitationIndicesList().equals(other.getCitationIndicesList())) return false;
      if (hasGroundingCheckRequired() != other.hasGroundingCheckRequired()) return false;
      if (hasGroundingCheckRequired()) {
        if (getGroundingCheckRequired() != other.getGroundingCheckRequired()) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasStartPos()) {
        hash = (37 * hash) + START_POS_FIELD_NUMBER;
        hash = (53 * hash) + getStartPos();
      }
      if (hasEndPos()) {
        hash = (37 * hash) + END_POS_FIELD_NUMBER;
        hash = (53 * hash) + getEndPos();
      }
      hash = (37 * hash) + CLAIM_TEXT_FIELD_NUMBER;
      hash = (53 * hash) + getClaimText().hashCode();
      if (getCitationIndicesCount() > 0) {
        hash = (37 * hash) + CITATION_INDICES_FIELD_NUMBER;
        hash = (53 * hash) + getCitationIndicesList().hashCode();
      }
      if (hasGroundingCheckRequired()) {
        hash = (37 * hash) + GROUNDING_CHECK_REQUIRED_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getGroundingCheckRequired());
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.discoveryengine.v1beta.CheckGroundingResponse.Claim parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.CheckGroundingResponse.Claim parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.CheckGroundingResponse.Claim parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.CheckGroundingResponse.Claim parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.CheckGroundingResponse.Claim parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.CheckGroundingResponse.Claim parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.CheckGroundingResponse.Claim parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.CheckGroundingResponse.Claim parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.CheckGroundingResponse.Claim
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.CheckGroundingResponse.Claim
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.CheckGroundingResponse.Claim parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.CheckGroundingResponse.Claim parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.discoveryengine.v1beta.CheckGroundingResponse.Claim prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Text and citation info for a claim in the answer candidate.
     * </pre>
     *
     * Protobuf type {@code google.cloud.discoveryengine.v1beta.CheckGroundingResponse.Claim}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.CheckGroundingResponse.Claim)
        com.google.cloud.discoveryengine.v1beta.CheckGroundingResponse.ClaimOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1beta.GroundedGenerationServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_CheckGroundingResponse_Claim_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1beta.GroundedGenerationServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_CheckGroundingResponse_Claim_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1beta.CheckGroundingResponse.Claim.class,
                com.google.cloud.discoveryengine.v1beta.CheckGroundingResponse.Claim.Builder.class);
      }

      // Construct using
      // com.google.cloud.discoveryengine.v1beta.CheckGroundingResponse.Claim.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        startPos_ = 0;
        endPos_ = 0;
        claimText_ = "";
        citationIndices_ = emptyIntList();
        groundingCheckRequired_ = false;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.discoveryengine.v1beta.GroundedGenerationServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_CheckGroundingResponse_Claim_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.CheckGroundingResponse.Claim
          getDefaultInstanceForType() {
        return com.google.cloud.discoveryengine.v1beta.CheckGroundingResponse.Claim
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.CheckGroundingResponse.Claim build() {
        com.google.cloud.discoveryengine.v1beta.CheckGroundingResponse.Claim result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.CheckGroundingResponse.Claim buildPartial() {
        com.google.cloud.discoveryengine.v1beta.CheckGroundingResponse.Claim result =
            new com.google.cloud.discoveryengine.v1beta.CheckGroundingResponse.Claim(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.discoveryengine.v1beta.CheckGroundingResponse.Claim result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.startPos_ = startPos_;
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.endPos_ = endPos_;
          to_bitField0_ |= 0x00000002;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.claimText_ = claimText_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          citationIndices_.makeImmutable();
          result.citationIndices_ = citationIndices_;
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.groundingCheckRequired_ = groundingCheckRequired_;
          to_bitField0_ |= 0x00000004;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.discoveryengine.v1beta.CheckGroundingResponse.Claim) {
          return mergeFrom(
              (com.google.cloud.discoveryengine.v1beta.CheckGroundingResponse.Claim) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.discoveryengine.v1beta.CheckGroundingResponse.Claim other) {
        if (other
            == com.google.cloud.discoveryengine.v1beta.CheckGroundingResponse.Claim
                .getDefaultInstance()) return this;
        if (other.hasStartPos()) {
          setStartPos(other.getStartPos());
        }
        if (other.hasEndPos()) {
          setEndPos(other.getEndPos());
        }
        if (!other.getClaimText().isEmpty()) {
          claimText_ = other.claimText_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        if (!other.citationIndices_.isEmpty()) {
          if (citationIndices_.isEmpty()) {
            citationIndices_ = other.citationIndices_;
            citationIndices_.makeImmutable();
            bitField0_ |= 0x00000008;
          } else {
            ensureCitationIndicesIsMutable();
            citationIndices_.addAll(other.citationIndices_);
          }
          onChanged();
        }
        if (other.hasGroundingCheckRequired()) {
          setGroundingCheckRequired(other.getGroundingCheckRequired());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  startPos_ = input.readInt32();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 16:
                {
                  endPos_ = input.readInt32();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              case 26:
                {
                  claimText_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              case 32:
                {
                  int v = input.readInt32();
                  ensureCitationIndicesIsMutable();
                  citationIndices_.addInt(v);
                  break;
                } // case 32
              case 34:
                {
                  int length = input.readRawVarint32();
                  int limit = input.pushLimit(length);
                  ensureCitationIndicesIsMutable();
                  while (input.getBytesUntilLimit() > 0) {
                    citationIndices_.addInt(input.readInt32());
                  }
                  input.popLimit(limit);
                  break;
                } // case 34
              case 48:
                {
                  groundingCheckRequired_ = input.readBool();
                  bitField0_ |= 0x00000010;
                  break;
                } // case 48
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int startPos_;
      /**
       *
       *
       * <pre>
       * Position indicating the start of the claim in the answer candidate,
       * measured in bytes.
       * </pre>
       *
       * <code>optional int32 start_pos = 1;</code>
       *
       * @return Whether the startPos field is set.
       */
      @java.lang.Override
      public boolean hasStartPos() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * Position indicating the start of the claim in the answer candidate,
       * measured in bytes.
       * </pre>
       *
       * <code>optional int32 start_pos = 1;</code>
       *
       * @return The startPos.
       */
      @java.lang.Override
      public int getStartPos() {
        return startPos_;
      }
      /**
       *
       *
       * <pre>
       * Position indicating the start of the claim in the answer candidate,
       * measured in bytes.
       * </pre>
       *
       * <code>optional int32 start_pos = 1;</code>
       *
       * @param value The startPos to set.
       * @return This builder for chaining.
       */
      public Builder setStartPos(int value) {

        startPos_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Position indicating the start of the claim in the answer candidate,
       * measured in bytes.
       * </pre>
       *
       * <code>optional int32 start_pos = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearStartPos() {
        bitField0_ = (bitField0_ & ~0x00000001);
        startPos_ = 0;
        onChanged();
        return this;
      }

      private int endPos_;
      /**
       *
       *
       * <pre>
       * Position indicating the end of the claim in the answer candidate,
       * exclusive.
       * </pre>
       *
       * <code>optional int32 end_pos = 2;</code>
       *
       * @return Whether the endPos field is set.
       */
      @java.lang.Override
      public boolean hasEndPos() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * Position indicating the end of the claim in the answer candidate,
       * exclusive.
       * </pre>
       *
       * <code>optional int32 end_pos = 2;</code>
       *
       * @return The endPos.
       */
      @java.lang.Override
      public int getEndPos() {
        return endPos_;
      }
      /**
       *
       *
       * <pre>
       * Position indicating the end of the claim in the answer candidate,
       * exclusive.
       * </pre>
       *
       * <code>optional int32 end_pos = 2;</code>
       *
       * @param value The endPos to set.
       * @return This builder for chaining.
       */
      public Builder setEndPos(int value) {

        endPos_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Position indicating the end of the claim in the answer candidate,
       * exclusive.
       * </pre>
       *
       * <code>optional int32 end_pos = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearEndPos() {
        bitField0_ = (bitField0_ & ~0x00000002);
        endPos_ = 0;
        onChanged();
        return this;
      }

      private java.lang.Object claimText_ = "";
      /**
       *
       *
       * <pre>
       * Text for the claim in the answer candidate. Always provided regardless of
       * whether citations or anti-citations are found.
       * </pre>
       *
       * <code>string claim_text = 3;</code>
       *
       * @return The claimText.
       */
      public java.lang.String getClaimText() {
        java.lang.Object ref = claimText_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          claimText_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Text for the claim in the answer candidate. Always provided regardless of
       * whether citations or anti-citations are found.
       * </pre>
       *
       * <code>string claim_text = 3;</code>
       *
       * @return The bytes for claimText.
       */
      public com.google.protobuf.ByteString getClaimTextBytes() {
        java.lang.Object ref = claimText_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          claimText_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Text for the claim in the answer candidate. Always provided regardless of
       * whether citations or anti-citations are found.
       * </pre>
       *
       * <code>string claim_text = 3;</code>
       *
       * @param value The claimText to set.
       * @return This builder for chaining.
       */
      public Builder setClaimText(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        claimText_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Text for the claim in the answer candidate. Always provided regardless of
       * whether citations or anti-citations are found.
       * </pre>
       *
       * <code>string claim_text = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearClaimText() {
        claimText_ = getDefaultInstance().getClaimText();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Text for the claim in the answer candidate. Always provided regardless of
       * whether citations or anti-citations are found.
       * </pre>
       *
       * <code>string claim_text = 3;</code>
       *
       * @param value The bytes for claimText to set.
       * @return This builder for chaining.
       */
      public Builder setClaimTextBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        claimText_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      private com.google.protobuf.Internal.IntList citationIndices_ = emptyIntList();

      private void ensureCitationIndicesIsMutable() {
        if (!citationIndices_.isModifiable()) {
          citationIndices_ = makeMutableCopy(citationIndices_);
        }
        bitField0_ |= 0x00000008;
      }
      /**
       *
       *
       * <pre>
       * A list of indices (into 'cited_chunks') specifying the citations
       * associated with the claim. For instance [1,3,4] means that
       * cited_chunks[1], cited_chunks[3], cited_chunks[4] are the facts cited
       * supporting for the claim. A citation to a fact indicates that the claim
       * is supported by the fact.
       * </pre>
       *
       * <code>repeated int32 citation_indices = 4;</code>
       *
       * @return A list containing the citationIndices.
       */
      public java.util.List<java.lang.Integer> getCitationIndicesList() {
        citationIndices_.makeImmutable();
        return citationIndices_;
      }
      /**
       *
       *
       * <pre>
       * A list of indices (into 'cited_chunks') specifying the citations
       * associated with the claim. For instance [1,3,4] means that
       * cited_chunks[1], cited_chunks[3], cited_chunks[4] are the facts cited
       * supporting for the claim. A citation to a fact indicates that the claim
       * is supported by the fact.
       * </pre>
       *
       * <code>repeated int32 citation_indices = 4;</code>
       *
       * @return The count of citationIndices.
       */
      public int getCitationIndicesCount() {
        return citationIndices_.size();
      }
      /**
       *
       *
       * <pre>
       * A list of indices (into 'cited_chunks') specifying the citations
       * associated with the claim. For instance [1,3,4] means that
       * cited_chunks[1], cited_chunks[3], cited_chunks[4] are the facts cited
       * supporting for the claim. A citation to a fact indicates that the claim
       * is supported by the fact.
       * </pre>
       *
       * <code>repeated int32 citation_indices = 4;</code>
       *
       * @param index The index of the element to return.
       * @return The citationIndices at the given index.
       */
      public int getCitationIndices(int index) {
        return citationIndices_.getInt(index);
      }
      /**
       *
       *
       * <pre>
       * A list of indices (into 'cited_chunks') specifying the citations
       * associated with the claim. For instance [1,3,4] means that
       * cited_chunks[1], cited_chunks[3], cited_chunks[4] are the facts cited
       * supporting for the claim. A citation to a fact indicates that the claim
       * is supported by the fact.
       * </pre>
       *
       * <code>repeated int32 citation_indices = 4;</code>
       *
       * @param index The index to set the value at.
       * @param value The citationIndices to set.
       * @return This builder for chaining.
       */
      public Builder setCitationIndices(int index, int value) {

        ensureCitationIndicesIsMutable();
        citationIndices_.setInt(index, value);
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of indices (into 'cited_chunks') specifying the citations
       * associated with the claim. For instance [1,3,4] means that
       * cited_chunks[1], cited_chunks[3], cited_chunks[4] are the facts cited
       * supporting for the claim. A citation to a fact indicates that the claim
       * is supported by the fact.
       * </pre>
       *
       * <code>repeated int32 citation_indices = 4;</code>
       *
       * @param value The citationIndices to add.
       * @return This builder for chaining.
       */
      public Builder addCitationIndices(int value) {

        ensureCitationIndicesIsMutable();
        citationIndices_.addInt(value);
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of indices (into 'cited_chunks') specifying the citations
       * associated with the claim. For instance [1,3,4] means that
       * cited_chunks[1], cited_chunks[3], cited_chunks[4] are the facts cited
       * supporting for the claim. A citation to a fact indicates that the claim
       * is supported by the fact.
       * </pre>
       *
       * <code>repeated int32 citation_indices = 4;</code>
       *
       * @param values The citationIndices to add.
       * @return This builder for chaining.
       */
      public Builder addAllCitationIndices(java.lang.Iterable<? extends java.lang.Integer> values) {
        ensureCitationIndicesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, citationIndices_);
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of indices (into 'cited_chunks') specifying the citations
       * associated with the claim. For instance [1,3,4] means that
       * cited_chunks[1], cited_chunks[3], cited_chunks[4] are the facts cited
       * supporting for the claim. A citation to a fact indicates that the claim
       * is supported by the fact.
       * </pre>
       *
       * <code>repeated int32 citation_indices = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearCitationIndices() {
        citationIndices_ = emptyIntList();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
        return this;
      }

      private boolean groundingCheckRequired_;
      /**
       *
       *
       * <pre>
       * Indicates that this claim required grounding check. When the system
       * decided this claim doesn't require attribution/grounding check, this
       * field will be set to false. In that case, no grounding check was done for
       * the claim and therefore
       * [citation_indices][google.cloud.discoveryengine.v1beta.CheckGroundingResponse.Claim.citation_indices],
       * and
       * [anti_citation_indices][google.cloud.discoveryengine.v1beta.CheckGroundingResponse.Claim.anti_citation_indices]
       * should not be returned.
       * </pre>
       *
       * <code>optional bool grounding_check_required = 6;</code>
       *
       * @return Whether the groundingCheckRequired field is set.
       */
      @java.lang.Override
      public boolean hasGroundingCheckRequired() {
        return ((bitField0_ & 0x00000010) != 0);
      }
      /**
       *
       *
       * <pre>
       * Indicates that this claim required grounding check. When the system
       * decided this claim doesn't require attribution/grounding check, this
       * field will be set to false. In that case, no grounding check was done for
       * the claim and therefore
       * [citation_indices][google.cloud.discoveryengine.v1beta.CheckGroundingResponse.Claim.citation_indices],
       * and
       * [anti_citation_indices][google.cloud.discoveryengine.v1beta.CheckGroundingResponse.Claim.anti_citation_indices]
       * should not be returned.
       * </pre>
       *
       * <code>optional bool grounding_check_required = 6;</code>
       *
       * @return The groundingCheckRequired.
       */
      @java.lang.Override
      public boolean getGroundingCheckRequired() {
        return groundingCheckRequired_;
      }
      /**
       *
       *
       * <pre>
       * Indicates that this claim required grounding check. When the system
       * decided this claim doesn't require attribution/grounding check, this
       * field will be set to false. In that case, no grounding check was done for
       * the claim and therefore
       * [citation_indices][google.cloud.discoveryengine.v1beta.CheckGroundingResponse.Claim.citation_indices],
       * and
       * [anti_citation_indices][google.cloud.discoveryengine.v1beta.CheckGroundingResponse.Claim.anti_citation_indices]
       * should not be returned.
       * </pre>
       *
       * <code>optional bool grounding_check_required = 6;</code>
       *
       * @param value The groundingCheckRequired to set.
       * @return This builder for chaining.
       */
      public Builder setGroundingCheckRequired(boolean value) {

        groundingCheckRequired_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Indicates that this claim required grounding check. When the system
       * decided this claim doesn't require attribution/grounding check, this
       * field will be set to false. In that case, no grounding check was done for
       * the claim and therefore
       * [citation_indices][google.cloud.discoveryengine.v1beta.CheckGroundingResponse.Claim.citation_indices],
       * and
       * [anti_citation_indices][google.cloud.discoveryengine.v1beta.CheckGroundingResponse.Claim.anti_citation_indices]
       * should not be returned.
       * </pre>
       *
       * <code>optional bool grounding_check_required = 6;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearGroundingCheckRequired() {
        bitField0_ = (bitField0_ & ~0x00000010);
        groundingCheckRequired_ = false;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.CheckGroundingResponse.Claim)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.CheckGroundingResponse.Claim)
    private static final com.google.cloud.discoveryengine.v1beta.CheckGroundingResponse.Claim
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.discoveryengine.v1beta.CheckGroundingResponse.Claim();
    }

    public static com.google.cloud.discoveryengine.v1beta.CheckGroundingResponse.Claim
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Claim> PARSER =
        new com.google.protobuf.AbstractParser<Claim>() {
          @java.lang.Override
          public Claim parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Claim> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Claim> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.CheckGroundingResponse.Claim
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int SUPPORT_SCORE_FIELD_NUMBER = 1;
  private float supportScore_ = 0F;
  /**
   *
   *
   * <pre>
   * The support score for the input answer candidate.
   * Higher the score, higher is the fraction of claims that are supported by
   * the provided facts. This is always set when a response is returned.
   * </pre>
   *
   * <code>optional float support_score = 1;</code>
   *
   * @return Whether the supportScore field is set.
   */
  @java.lang.Override
  public boolean hasSupportScore() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * The support score for the input answer candidate.
   * Higher the score, higher is the fraction of claims that are supported by
   * the provided facts. This is always set when a response is returned.
   * </pre>
   *
   * <code>optional float support_score = 1;</code>
   *
   * @return The supportScore.
   */
  @java.lang.Override
  public float getSupportScore() {
    return supportScore_;
  }

  public static final int CITED_CHUNKS_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.discoveryengine.v1beta.FactChunk> citedChunks_;
  /**
   *
   *
   * <pre>
   * List of facts cited across all claims in the answer candidate.
   * These are derived from the facts supplied in the request.
   * </pre>
   *
   * <code>repeated .google.cloud.discoveryengine.v1beta.FactChunk cited_chunks = 3;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.discoveryengine.v1beta.FactChunk> getCitedChunksList() {
    return citedChunks_;
  }
  /**
   *
   *
   * <pre>
   * List of facts cited across all claims in the answer candidate.
   * These are derived from the facts supplied in the request.
   * </pre>
   *
   * <code>repeated .google.cloud.discoveryengine.v1beta.FactChunk cited_chunks = 3;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.discoveryengine.v1beta.FactChunkOrBuilder>
      getCitedChunksOrBuilderList() {
    return citedChunks_;
  }
  /**
   *
   *
   * <pre>
   * List of facts cited across all claims in the answer candidate.
   * These are derived from the facts supplied in the request.
   * </pre>
   *
   * <code>repeated .google.cloud.discoveryengine.v1beta.FactChunk cited_chunks = 3;</code>
   */
  @java.lang.Override
  public int getCitedChunksCount() {
    return citedChunks_.size();
  }
  /**
   *
   *
   * <pre>
   * List of facts cited across all claims in the answer candidate.
   * These are derived from the facts supplied in the request.
   * </pre>
   *
   * <code>repeated .google.cloud.discoveryengine.v1beta.FactChunk cited_chunks = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.FactChunk getCitedChunks(int index) {
    return citedChunks_.get(index);
  }
  /**
   *
   *
   * <pre>
   * List of facts cited across all claims in the answer candidate.
   * These are derived from the facts supplied in the request.
   * </pre>
   *
   * <code>repeated .google.cloud.discoveryengine.v1beta.FactChunk cited_chunks = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.FactChunkOrBuilder getCitedChunksOrBuilder(
      int index) {
    return citedChunks_.get(index);
  }

  public static final int CLAIMS_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.discoveryengine.v1beta.CheckGroundingResponse.Claim>
      claims_;
  /**
   *
   *
   * <pre>
   * Claim texts and citation info across all claims in the answer candidate.
   * </pre>
   *
   * <code>repeated .google.cloud.discoveryengine.v1beta.CheckGroundingResponse.Claim claims = 4;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.discoveryengine.v1beta.CheckGroundingResponse.Claim>
      getClaimsList() {
    return claims_;
  }
  /**
   *
   *
   * <pre>
   * Claim texts and citation info across all claims in the answer candidate.
   * </pre>
   *
   * <code>repeated .google.cloud.discoveryengine.v1beta.CheckGroundingResponse.Claim claims = 4;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.discoveryengine.v1beta.CheckGroundingResponse.ClaimOrBuilder>
      getClaimsOrBuilderList() {
    return claims_;
  }
  /**
   *
   *
   * <pre>
   * Claim texts and citation info across all claims in the answer candidate.
   * </pre>
   *
   * <code>repeated .google.cloud.discoveryengine.v1beta.CheckGroundingResponse.Claim claims = 4;
   * </code>
   */
  @java.lang.Override
  public int getClaimsCount() {
    return claims_.size();
  }
  /**
   *
   *
   * <pre>
   * Claim texts and citation info across all claims in the answer candidate.
   * </pre>
   *
   * <code>repeated .google.cloud.discoveryengine.v1beta.CheckGroundingResponse.Claim claims = 4;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.CheckGroundingResponse.Claim getClaims(int index) {
    return claims_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Claim texts and citation info across all claims in the answer candidate.
   * </pre>
   *
   * <code>repeated .google.cloud.discoveryengine.v1beta.CheckGroundingResponse.Claim claims = 4;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.CheckGroundingResponse.ClaimOrBuilder
      getClaimsOrBuilder(int index) {
    return claims_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeFloat(1, supportScore_);
    }
    for (int i = 0; i < citedChunks_.size(); i++) {
      output.writeMessage(3, citedChunks_.get(i));
    }
    for (int i = 0; i < claims_.size(); i++) {
      output.writeMessage(4, claims_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeFloatSize(1, supportScore_);
    }
    for (int i = 0; i < citedChunks_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, citedChunks_.get(i));
    }
    for (int i = 0; i < claims_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, claims_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.discoveryengine.v1beta.CheckGroundingResponse)) {
      return super.equals(obj);
    }
    com.google.cloud.discoveryengine.v1beta.CheckGroundingResponse other =
        (com.google.cloud.discoveryengine.v1beta.CheckGroundingResponse) obj;

    if (hasSupportScore() != other.hasSupportScore()) return false;
    if (hasSupportScore()) {
      if (java.lang.Float.floatToIntBits(getSupportScore())
          != java.lang.Float.floatToIntBits(other.getSupportScore())) return false;
    }
    if (!getCitedChunksList().equals(other.getCitedChunksList())) return false;
    if (!getClaimsList().equals(other.getClaimsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasSupportScore()) {
      hash = (37 * hash) + SUPPORT_SCORE_FIELD_NUMBER;
      hash = (53 * hash) + java.lang.Float.floatToIntBits(getSupportScore());
    }
    if (getCitedChunksCount() > 0) {
      hash = (37 * hash) + CITED_CHUNKS_FIELD_NUMBER;
      hash = (53 * hash) + getCitedChunksList().hashCode();
    }
    if (getClaimsCount() > 0) {
      hash = (37 * hash) + CLAIMS_FIELD_NUMBER;
      hash = (53 * hash) + getClaimsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.discoveryengine.v1beta.CheckGroundingResponse parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1beta.CheckGroundingResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.CheckGroundingResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1beta.CheckGroundingResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.CheckGroundingResponse parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1beta.CheckGroundingResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.CheckGroundingResponse parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1beta.CheckGroundingResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.CheckGroundingResponse parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1beta.CheckGroundingResponse parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.CheckGroundingResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1beta.CheckGroundingResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.discoveryengine.v1beta.CheckGroundingResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Response message for the
   * [GroundedGenerationService.CheckGrounding][google.cloud.discoveryengine.v1beta.GroundedGenerationService.CheckGrounding]
   * method.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1beta.CheckGroundingResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.CheckGroundingResponse)
      com.google.cloud.discoveryengine.v1beta.CheckGroundingResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1beta.GroundedGenerationServiceProto
          .internal_static_google_cloud_discoveryengine_v1beta_CheckGroundingResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1beta.GroundedGenerationServiceProto
          .internal_static_google_cloud_discoveryengine_v1beta_CheckGroundingResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1beta.CheckGroundingResponse.class,
              com.google.cloud.discoveryengine.v1beta.CheckGroundingResponse.Builder.class);
    }

    // Construct using com.google.cloud.discoveryengine.v1beta.CheckGroundingResponse.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      supportScore_ = 0F;
      if (citedChunksBuilder_ == null) {
        citedChunks_ = java.util.Collections.emptyList();
      } else {
        citedChunks_ = null;
        citedChunksBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      if (claimsBuilder_ == null) {
        claims_ = java.util.Collections.emptyList();
      } else {
        claims_ = null;
        claimsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.discoveryengine.v1beta.GroundedGenerationServiceProto
          .internal_static_google_cloud_discoveryengine_v1beta_CheckGroundingResponse_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.CheckGroundingResponse
        getDefaultInstanceForType() {
      return com.google.cloud.discoveryengine.v1beta.CheckGroundingResponse.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.CheckGroundingResponse build() {
      com.google.cloud.discoveryengine.v1beta.CheckGroundingResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.CheckGroundingResponse buildPartial() {
      com.google.cloud.discoveryengine.v1beta.CheckGroundingResponse result =
          new com.google.cloud.discoveryengine.v1beta.CheckGroundingResponse(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.discoveryengine.v1beta.CheckGroundingResponse result) {
      if (citedChunksBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          citedChunks_ = java.util.Collections.unmodifiableList(citedChunks_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.citedChunks_ = citedChunks_;
      } else {
        result.citedChunks_ = citedChunksBuilder_.build();
      }
      if (claimsBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          claims_ = java.util.Collections.unmodifiableList(claims_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.claims_ = claims_;
      } else {
        result.claims_ = claimsBuilder_.build();
      }
    }

    private void buildPartial0(
        com.google.cloud.discoveryengine.v1beta.CheckGroundingResponse result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.supportScore_ = supportScore_;
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.discoveryengine.v1beta.CheckGroundingResponse) {
        return mergeFrom((com.google.cloud.discoveryengine.v1beta.CheckGroundingResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.discoveryengine.v1beta.CheckGroundingResponse other) {
      if (other
          == com.google.cloud.discoveryengine.v1beta.CheckGroundingResponse.getDefaultInstance())
        return this;
      if (other.hasSupportScore()) {
        setSupportScore(other.getSupportScore());
      }
      if (citedChunksBuilder_ == null) {
        if (!other.citedChunks_.isEmpty()) {
          if (citedChunks_.isEmpty()) {
            citedChunks_ = other.citedChunks_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureCitedChunksIsMutable();
            citedChunks_.addAll(other.citedChunks_);
          }
          onChanged();
        }
      } else {
        if (!other.citedChunks_.isEmpty()) {
          if (citedChunksBuilder_.isEmpty()) {
            citedChunksBuilder_.dispose();
            citedChunksBuilder_ = null;
            citedChunks_ = other.citedChunks_;
            bitField0_ = (bitField0_ & ~0x00000002);
            citedChunksBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getCitedChunksFieldBuilder()
                    : null;
          } else {
            citedChunksBuilder_.addAllMessages(other.citedChunks_);
          }
        }
      }
      if (claimsBuilder_ == null) {
        if (!other.claims_.isEmpty()) {
          if (claims_.isEmpty()) {
            claims_ = other.claims_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureClaimsIsMutable();
            claims_.addAll(other.claims_);
          }
          onChanged();
        }
      } else {
        if (!other.claims_.isEmpty()) {
          if (claimsBuilder_.isEmpty()) {
            claimsBuilder_.dispose();
            claimsBuilder_ = null;
            claims_ = other.claims_;
            bitField0_ = (bitField0_ & ~0x00000004);
            claimsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getClaimsFieldBuilder()
                    : null;
          } else {
            claimsBuilder_.addAllMessages(other.claims_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 13:
              {
                supportScore_ = input.readFloat();
                bitField0_ |= 0x00000001;
                break;
              } // case 13
            case 26:
              {
                com.google.cloud.discoveryengine.v1beta.FactChunk m =
                    input.readMessage(
                        com.google.cloud.discoveryengine.v1beta.FactChunk.parser(),
                        extensionRegistry);
                if (citedChunksBuilder_ == null) {
                  ensureCitedChunksIsMutable();
                  citedChunks_.add(m);
                } else {
                  citedChunksBuilder_.addMessage(m);
                }
                break;
              } // case 26
            case 34:
              {
                com.google.cloud.discoveryengine.v1beta.CheckGroundingResponse.Claim m =
                    input.readMessage(
                        com.google.cloud.discoveryengine.v1beta.CheckGroundingResponse.Claim
                            .parser(),
                        extensionRegistry);
                if (claimsBuilder_ == null) {
                  ensureClaimsIsMutable();
                  claims_.add(m);
                } else {
                  claimsBuilder_.addMessage(m);
                }
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private float supportScore_;
    /**
     *
     *
     * <pre>
     * The support score for the input answer candidate.
     * Higher the score, higher is the fraction of claims that are supported by
     * the provided facts. This is always set when a response is returned.
     * </pre>
     *
     * <code>optional float support_score = 1;</code>
     *
     * @return Whether the supportScore field is set.
     */
    @java.lang.Override
    public boolean hasSupportScore() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * The support score for the input answer candidate.
     * Higher the score, higher is the fraction of claims that are supported by
     * the provided facts. This is always set when a response is returned.
     * </pre>
     *
     * <code>optional float support_score = 1;</code>
     *
     * @return The supportScore.
     */
    @java.lang.Override
    public float getSupportScore() {
      return supportScore_;
    }
    /**
     *
     *
     * <pre>
     * The support score for the input answer candidate.
     * Higher the score, higher is the fraction of claims that are supported by
     * the provided facts. This is always set when a response is returned.
     * </pre>
     *
     * <code>optional float support_score = 1;</code>
     *
     * @param value The supportScore to set.
     * @return This builder for chaining.
     */
    public Builder setSupportScore(float value) {

      supportScore_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The support score for the input answer candidate.
     * Higher the score, higher is the fraction of claims that are supported by
     * the provided facts. This is always set when a response is returned.
     * </pre>
     *
     * <code>optional float support_score = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSupportScore() {
      bitField0_ = (bitField0_ & ~0x00000001);
      supportScore_ = 0F;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.discoveryengine.v1beta.FactChunk> citedChunks_ =
        java.util.Collections.emptyList();

    private void ensureCitedChunksIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        citedChunks_ =
            new java.util.ArrayList<com.google.cloud.discoveryengine.v1beta.FactChunk>(
                citedChunks_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.discoveryengine.v1beta.FactChunk,
            com.google.cloud.discoveryengine.v1beta.FactChunk.Builder,
            com.google.cloud.discoveryengine.v1beta.FactChunkOrBuilder>
        citedChunksBuilder_;

    /**
     *
     *
     * <pre>
     * List of facts cited across all claims in the answer candidate.
     * These are derived from the facts supplied in the request.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.FactChunk cited_chunks = 3;</code>
     */
    public java.util.List<com.google.cloud.discoveryengine.v1beta.FactChunk> getCitedChunksList() {
      if (citedChunksBuilder_ == null) {
        return java.util.Collections.unmodifiableList(citedChunks_);
      } else {
        return citedChunksBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * List of facts cited across all claims in the answer candidate.
     * These are derived from the facts supplied in the request.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.FactChunk cited_chunks = 3;</code>
     */
    public int getCitedChunksCount() {
      if (citedChunksBuilder_ == null) {
        return citedChunks_.size();
      } else {
        return citedChunksBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * List of facts cited across all claims in the answer candidate.
     * These are derived from the facts supplied in the request.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.FactChunk cited_chunks = 3;</code>
     */
    public com.google.cloud.discoveryengine.v1beta.FactChunk getCitedChunks(int index) {
      if (citedChunksBuilder_ == null) {
        return citedChunks_.get(index);
      } else {
        return citedChunksBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * List of facts cited across all claims in the answer candidate.
     * These are derived from the facts supplied in the request.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.FactChunk cited_chunks = 3;</code>
     */
    public Builder setCitedChunks(
        int index, com.google.cloud.discoveryengine.v1beta.FactChunk value) {
      if (citedChunksBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCitedChunksIsMutable();
        citedChunks_.set(index, value);
        onChanged();
      } else {
        citedChunksBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of facts cited across all claims in the answer candidate.
     * These are derived from the facts supplied in the request.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.FactChunk cited_chunks = 3;</code>
     */
    public Builder setCitedChunks(
        int index, com.google.cloud.discoveryengine.v1beta.FactChunk.Builder builderForValue) {
      if (citedChunksBuilder_ == null) {
        ensureCitedChunksIsMutable();
        citedChunks_.set(index, builderForValue.build());
        onChanged();
      } else {
        citedChunksBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of facts cited across all claims in the answer candidate.
     * These are derived from the facts supplied in the request.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.FactChunk cited_chunks = 3;</code>
     */
    public Builder addCitedChunks(com.google.cloud.discoveryengine.v1beta.FactChunk value) {
      if (citedChunksBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCitedChunksIsMutable();
        citedChunks_.add(value);
        onChanged();
      } else {
        citedChunksBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of facts cited across all claims in the answer candidate.
     * These are derived from the facts supplied in the request.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.FactChunk cited_chunks = 3;</code>
     */
    public Builder addCitedChunks(
        int index, com.google.cloud.discoveryengine.v1beta.FactChunk value) {
      if (citedChunksBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCitedChunksIsMutable();
        citedChunks_.add(index, value);
        onChanged();
      } else {
        citedChunksBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of facts cited across all claims in the answer candidate.
     * These are derived from the facts supplied in the request.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.FactChunk cited_chunks = 3;</code>
     */
    public Builder addCitedChunks(
        com.google.cloud.discoveryengine.v1beta.FactChunk.Builder builderForValue) {
      if (citedChunksBuilder_ == null) {
        ensureCitedChunksIsMutable();
        citedChunks_.add(builderForValue.build());
        onChanged();
      } else {
        citedChunksBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of facts cited across all claims in the answer candidate.
     * These are derived from the facts supplied in the request.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.FactChunk cited_chunks = 3;</code>
     */
    public Builder addCitedChunks(
        int index, com.google.cloud.discoveryengine.v1beta.FactChunk.Builder builderForValue) {
      if (citedChunksBuilder_ == null) {
        ensureCitedChunksIsMutable();
        citedChunks_.add(index, builderForValue.build());
        onChanged();
      } else {
        citedChunksBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of facts cited across all claims in the answer candidate.
     * These are derived from the facts supplied in the request.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.FactChunk cited_chunks = 3;</code>
     */
    public Builder addAllCitedChunks(
        java.lang.Iterable<? extends com.google.cloud.discoveryengine.v1beta.FactChunk> values) {
      if (citedChunksBuilder_ == null) {
        ensureCitedChunksIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, citedChunks_);
        onChanged();
      } else {
        citedChunksBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of facts cited across all claims in the answer candidate.
     * These are derived from the facts supplied in the request.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.FactChunk cited_chunks = 3;</code>
     */
    public Builder clearCitedChunks() {
      if (citedChunksBuilder_ == null) {
        citedChunks_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        citedChunksBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of facts cited across all claims in the answer candidate.
     * These are derived from the facts supplied in the request.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.FactChunk cited_chunks = 3;</code>
     */
    public Builder removeCitedChunks(int index) {
      if (citedChunksBuilder_ == null) {
        ensureCitedChunksIsMutable();
        citedChunks_.remove(index);
        onChanged();
      } else {
        citedChunksBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of facts cited across all claims in the answer candidate.
     * These are derived from the facts supplied in the request.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.FactChunk cited_chunks = 3;</code>
     */
    public com.google.cloud.discoveryengine.v1beta.FactChunk.Builder getCitedChunksBuilder(
        int index) {
      return getCitedChunksFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * List of facts cited across all claims in the answer candidate.
     * These are derived from the facts supplied in the request.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.FactChunk cited_chunks = 3;</code>
     */
    public com.google.cloud.discoveryengine.v1beta.FactChunkOrBuilder getCitedChunksOrBuilder(
        int index) {
      if (citedChunksBuilder_ == null) {
        return citedChunks_.get(index);
      } else {
        return citedChunksBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * List of facts cited across all claims in the answer candidate.
     * These are derived from the facts supplied in the request.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.FactChunk cited_chunks = 3;</code>
     */
    public java.util.List<? extends com.google.cloud.discoveryengine.v1beta.FactChunkOrBuilder>
        getCitedChunksOrBuilderList() {
      if (citedChunksBuilder_ != null) {
        return citedChunksBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(citedChunks_);
      }
    }
    /**
     *
     *
     * <pre>
     * List of facts cited across all claims in the answer candidate.
     * These are derived from the facts supplied in the request.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.FactChunk cited_chunks = 3;</code>
     */
    public com.google.cloud.discoveryengine.v1beta.FactChunk.Builder addCitedChunksBuilder() {
      return getCitedChunksFieldBuilder()
          .addBuilder(com.google.cloud.discoveryengine.v1beta.FactChunk.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * List of facts cited across all claims in the answer candidate.
     * These are derived from the facts supplied in the request.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.FactChunk cited_chunks = 3;</code>
     */
    public com.google.cloud.discoveryengine.v1beta.FactChunk.Builder addCitedChunksBuilder(
        int index) {
      return getCitedChunksFieldBuilder()
          .addBuilder(
              index, com.google.cloud.discoveryengine.v1beta.FactChunk.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * List of facts cited across all claims in the answer candidate.
     * These are derived from the facts supplied in the request.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.FactChunk cited_chunks = 3;</code>
     */
    public java.util.List<com.google.cloud.discoveryengine.v1beta.FactChunk.Builder>
        getCitedChunksBuilderList() {
      return getCitedChunksFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.discoveryengine.v1beta.FactChunk,
            com.google.cloud.discoveryengine.v1beta.FactChunk.Builder,
            com.google.cloud.discoveryengine.v1beta.FactChunkOrBuilder>
        getCitedChunksFieldBuilder() {
      if (citedChunksBuilder_ == null) {
        citedChunksBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.discoveryengine.v1beta.FactChunk,
                com.google.cloud.discoveryengine.v1beta.FactChunk.Builder,
                com.google.cloud.discoveryengine.v1beta.FactChunkOrBuilder>(
                citedChunks_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
        citedChunks_ = null;
      }
      return citedChunksBuilder_;
    }

    private java.util.List<com.google.cloud.discoveryengine.v1beta.CheckGroundingResponse.Claim>
        claims_ = java.util.Collections.emptyList();

    private void ensureClaimsIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        claims_ =
            new java.util.ArrayList<
                com.google.cloud.discoveryengine.v1beta.CheckGroundingResponse.Claim>(claims_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.discoveryengine.v1beta.CheckGroundingResponse.Claim,
            com.google.cloud.discoveryengine.v1beta.CheckGroundingResponse.Claim.Builder,
            com.google.cloud.discoveryengine.v1beta.CheckGroundingResponse.ClaimOrBuilder>
        claimsBuilder_;

    /**
     *
     *
     * <pre>
     * Claim texts and citation info across all claims in the answer candidate.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.CheckGroundingResponse.Claim claims = 4;
     * </code>
     */
    public java.util.List<com.google.cloud.discoveryengine.v1beta.CheckGroundingResponse.Claim>
        getClaimsList() {
      if (claimsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(claims_);
      } else {
        return claimsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Claim texts and citation info across all claims in the answer candidate.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.CheckGroundingResponse.Claim claims = 4;
     * </code>
     */
    public int getClaimsCount() {
      if (claimsBuilder_ == null) {
        return claims_.size();
      } else {
        return claimsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Claim texts and citation info across all claims in the answer candidate.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.CheckGroundingResponse.Claim claims = 4;
     * </code>
     */
    public com.google.cloud.discoveryengine.v1beta.CheckGroundingResponse.Claim getClaims(
        int index) {
      if (claimsBuilder_ == null) {
        return claims_.get(index);
      } else {
        return claimsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Claim texts and citation info across all claims in the answer candidate.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.CheckGroundingResponse.Claim claims = 4;
     * </code>
     */
    public Builder setClaims(
        int index, com.google.cloud.discoveryengine.v1beta.CheckGroundingResponse.Claim value) {
      if (claimsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureClaimsIsMutable();
        claims_.set(index, value);
        onChanged();
      } else {
        claimsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Claim texts and citation info across all claims in the answer candidate.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.CheckGroundingResponse.Claim claims = 4;
     * </code>
     */
    public Builder setClaims(
        int index,
        com.google.cloud.discoveryengine.v1beta.CheckGroundingResponse.Claim.Builder
            builderForValue) {
      if (claimsBuilder_ == null) {
        ensureClaimsIsMutable();
        claims_.set(index, builderForValue.build());
        onChanged();
      } else {
        claimsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Claim texts and citation info across all claims in the answer candidate.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.CheckGroundingResponse.Claim claims = 4;
     * </code>
     */
    public Builder addClaims(
        com.google.cloud.discoveryengine.v1beta.CheckGroundingResponse.Claim value) {
      if (claimsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureClaimsIsMutable();
        claims_.add(value);
        onChanged();
      } else {
        claimsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Claim texts and citation info across all claims in the answer candidate.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.CheckGroundingResponse.Claim claims = 4;
     * </code>
     */
    public Builder addClaims(
        int index, com.google.cloud.discoveryengine.v1beta.CheckGroundingResponse.Claim value) {
      if (claimsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureClaimsIsMutable();
        claims_.add(index, value);
        onChanged();
      } else {
        claimsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Claim texts and citation info across all claims in the answer candidate.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.CheckGroundingResponse.Claim claims = 4;
     * </code>
     */
    public Builder addClaims(
        com.google.cloud.discoveryengine.v1beta.CheckGroundingResponse.Claim.Builder
            builderForValue) {
      if (claimsBuilder_ == null) {
        ensureClaimsIsMutable();
        claims_.add(builderForValue.build());
        onChanged();
      } else {
        claimsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Claim texts and citation info across all claims in the answer candidate.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.CheckGroundingResponse.Claim claims = 4;
     * </code>
     */
    public Builder addClaims(
        int index,
        com.google.cloud.discoveryengine.v1beta.CheckGroundingResponse.Claim.Builder
            builderForValue) {
      if (claimsBuilder_ == null) {
        ensureClaimsIsMutable();
        claims_.add(index, builderForValue.build());
        onChanged();
      } else {
        claimsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Claim texts and citation info across all claims in the answer candidate.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.CheckGroundingResponse.Claim claims = 4;
     * </code>
     */
    public Builder addAllClaims(
        java.lang.Iterable<
                ? extends com.google.cloud.discoveryengine.v1beta.CheckGroundingResponse.Claim>
            values) {
      if (claimsBuilder_ == null) {
        ensureClaimsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, claims_);
        onChanged();
      } else {
        claimsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Claim texts and citation info across all claims in the answer candidate.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.CheckGroundingResponse.Claim claims = 4;
     * </code>
     */
    public Builder clearClaims() {
      if (claimsBuilder_ == null) {
        claims_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        claimsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Claim texts and citation info across all claims in the answer candidate.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.CheckGroundingResponse.Claim claims = 4;
     * </code>
     */
    public Builder removeClaims(int index) {
      if (claimsBuilder_ == null) {
        ensureClaimsIsMutable();
        claims_.remove(index);
        onChanged();
      } else {
        claimsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Claim texts and citation info across all claims in the answer candidate.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.CheckGroundingResponse.Claim claims = 4;
     * </code>
     */
    public com.google.cloud.discoveryengine.v1beta.CheckGroundingResponse.Claim.Builder
        getClaimsBuilder(int index) {
      return getClaimsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Claim texts and citation info across all claims in the answer candidate.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.CheckGroundingResponse.Claim claims = 4;
     * </code>
     */
    public com.google.cloud.discoveryengine.v1beta.CheckGroundingResponse.ClaimOrBuilder
        getClaimsOrBuilder(int index) {
      if (claimsBuilder_ == null) {
        return claims_.get(index);
      } else {
        return claimsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Claim texts and citation info across all claims in the answer candidate.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.CheckGroundingResponse.Claim claims = 4;
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.discoveryengine.v1beta.CheckGroundingResponse.ClaimOrBuilder>
        getClaimsOrBuilderList() {
      if (claimsBuilder_ != null) {
        return claimsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(claims_);
      }
    }
    /**
     *
     *
     * <pre>
     * Claim texts and citation info across all claims in the answer candidate.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.CheckGroundingResponse.Claim claims = 4;
     * </code>
     */
    public com.google.cloud.discoveryengine.v1beta.CheckGroundingResponse.Claim.Builder
        addClaimsBuilder() {
      return getClaimsFieldBuilder()
          .addBuilder(
              com.google.cloud.discoveryengine.v1beta.CheckGroundingResponse.Claim
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Claim texts and citation info across all claims in the answer candidate.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.CheckGroundingResponse.Claim claims = 4;
     * </code>
     */
    public com.google.cloud.discoveryengine.v1beta.CheckGroundingResponse.Claim.Builder
        addClaimsBuilder(int index) {
      return getClaimsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.discoveryengine.v1beta.CheckGroundingResponse.Claim
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Claim texts and citation info across all claims in the answer candidate.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.CheckGroundingResponse.Claim claims = 4;
     * </code>
     */
    public java.util.List<
            com.google.cloud.discoveryengine.v1beta.CheckGroundingResponse.Claim.Builder>
        getClaimsBuilderList() {
      return getClaimsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.discoveryengine.v1beta.CheckGroundingResponse.Claim,
            com.google.cloud.discoveryengine.v1beta.CheckGroundingResponse.Claim.Builder,
            com.google.cloud.discoveryengine.v1beta.CheckGroundingResponse.ClaimOrBuilder>
        getClaimsFieldBuilder() {
      if (claimsBuilder_ == null) {
        claimsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.discoveryengine.v1beta.CheckGroundingResponse.Claim,
                com.google.cloud.discoveryengine.v1beta.CheckGroundingResponse.Claim.Builder,
                com.google.cloud.discoveryengine.v1beta.CheckGroundingResponse.ClaimOrBuilder>(
                claims_, ((bitField0_ & 0x00000004) != 0), getParentForChildren(), isClean());
        claims_ = null;
      }
      return claimsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.CheckGroundingResponse)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.CheckGroundingResponse)
  private static final com.google.cloud.discoveryengine.v1beta.CheckGroundingResponse
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.discoveryengine.v1beta.CheckGroundingResponse();
  }

  public static com.google.cloud.discoveryengine.v1beta.CheckGroundingResponse
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CheckGroundingResponse> PARSER =
      new com.google.protobuf.AbstractParser<CheckGroundingResponse>() {
        @java.lang.Override
        public CheckGroundingResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<CheckGroundingResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CheckGroundingResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.CheckGroundingResponse
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
