/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/discoveryengine/v1beta/serving_config.proto

// Protobuf Java Version: 3.25.4
package com.google.cloud.discoveryengine.v1beta;

/**
 *
 *
 * <pre>
 * Configures metadata that is used to generate serving time results (e.g.
 * search results or recommendation predictions).
 * The ServingConfig is passed in the search and predict request and generates
 * results.
 * </pre>
 *
 * Protobuf type {@code google.cloud.discoveryengine.v1beta.ServingConfig}
 */
public final class ServingConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.ServingConfig)
    ServingConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ServingConfig.newBuilder() to construct.
  private ServingConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ServingConfig() {
    name_ = "";
    displayName_ = "";
    solutionType_ = 0;
    modelId_ = "";
    diversityLevel_ = "";
    rankingExpression_ = "";
    filterControlIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
    boostControlIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
    redirectControlIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
    synonymsControlIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
    onewaySynonymsControlIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
    dissociateControlIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
    replacementControlIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
    ignoreControlIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ServingConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.discoveryengine.v1beta.ServingConfigProto
        .internal_static_google_cloud_discoveryengine_v1beta_ServingConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.discoveryengine.v1beta.ServingConfigProto
        .internal_static_google_cloud_discoveryengine_v1beta_ServingConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.discoveryengine.v1beta.ServingConfig.class,
            com.google.cloud.discoveryengine.v1beta.ServingConfig.Builder.class);
  }

  public interface MediaConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1beta.ServingConfig.MediaConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Specifies the content watched percentage threshold for demotion.
     * Threshold value must be between [0, 1.0] inclusive.
     * </pre>
     *
     * <code>float content_watched_percentage_threshold = 2;</code>
     *
     * @return Whether the contentWatchedPercentageThreshold field is set.
     */
    boolean hasContentWatchedPercentageThreshold();
    /**
     *
     *
     * <pre>
     * Specifies the content watched percentage threshold for demotion.
     * Threshold value must be between [0, 1.0] inclusive.
     * </pre>
     *
     * <code>float content_watched_percentage_threshold = 2;</code>
     *
     * @return The contentWatchedPercentageThreshold.
     */
    float getContentWatchedPercentageThreshold();

    /**
     *
     *
     * <pre>
     * Specifies the content watched minutes threshold for demotion.
     * </pre>
     *
     * <code>float content_watched_seconds_threshold = 5;</code>
     *
     * @return Whether the contentWatchedSecondsThreshold field is set.
     */
    boolean hasContentWatchedSecondsThreshold();
    /**
     *
     *
     * <pre>
     * Specifies the content watched minutes threshold for demotion.
     * </pre>
     *
     * <code>float content_watched_seconds_threshold = 5;</code>
     *
     * @return The contentWatchedSecondsThreshold.
     */
    float getContentWatchedSecondsThreshold();

    /**
     *
     *
     * <pre>
     * Specifies the event type used for demoting recommendation result.
     * Currently supported values:
     *
     * * `view-item`: Item viewed.
     * * `media-play`: Start/resume watching a video, playing a song, etc.
     * * `media-complete`: Finished or stopped midway through a video, song,
     * etc.
     *
     * If unset, watch history demotion will not be applied. Content freshness
     * demotion will still be applied.
     * </pre>
     *
     * <code>string demotion_event_type = 1;</code>
     *
     * @return The demotionEventType.
     */
    java.lang.String getDemotionEventType();
    /**
     *
     *
     * <pre>
     * Specifies the event type used for demoting recommendation result.
     * Currently supported values:
     *
     * * `view-item`: Item viewed.
     * * `media-play`: Start/resume watching a video, playing a song, etc.
     * * `media-complete`: Finished or stopped midway through a video, song,
     * etc.
     *
     * If unset, watch history demotion will not be applied. Content freshness
     * demotion will still be applied.
     * </pre>
     *
     * <code>string demotion_event_type = 1;</code>
     *
     * @return The bytes for demotionEventType.
     */
    com.google.protobuf.ByteString getDemotionEventTypeBytes();

    /**
     *
     *
     * <pre>
     * Specifies the content freshness used for recommendation result.
     * Contents will be demoted if contents were published for more than content
     * freshness cutoff days.
     * </pre>
     *
     * <code>int32 content_freshness_cutoff_days = 4;</code>
     *
     * @return The contentFreshnessCutoffDays.
     */
    int getContentFreshnessCutoffDays();

    com.google.cloud.discoveryengine.v1beta.ServingConfig.MediaConfig.DemoteContentWatchedCase
        getDemoteContentWatchedCase();
  }
  /**
   *
   *
   * <pre>
   * Specifies the configurations needed for Media Discovery. Currently we
   * support:
   *
   * * `demote_content_watched`: Threshold for watched content demotion.
   * Customers can specify if using watched content demotion or use viewed
   * detail page. Using the content watched demotion, customers need to specify
   * the watched minutes or percentage exceeds the threshold, the content will
   * be demoted in the recommendation result.
   * * `promote_fresh_content`: cutoff days for fresh content promotion.
   * Customers can specify if using content freshness promotion. If the content
   * was published within the cutoff days, the content will be promoted in the
   * recommendation result.
   * Can only be set if
   * [SolutionType][google.cloud.discoveryengine.v1beta.SolutionType] is
   * [SOLUTION_TYPE_RECOMMENDATION][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_RECOMMENDATION].
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1beta.ServingConfig.MediaConfig}
   */
  public static final class MediaConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.ServingConfig.MediaConfig)
      MediaConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use MediaConfig.newBuilder() to construct.
    private MediaConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private MediaConfig() {
      demotionEventType_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new MediaConfig();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1beta.ServingConfigProto
          .internal_static_google_cloud_discoveryengine_v1beta_ServingConfig_MediaConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1beta.ServingConfigProto
          .internal_static_google_cloud_discoveryengine_v1beta_ServingConfig_MediaConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1beta.ServingConfig.MediaConfig.class,
              com.google.cloud.discoveryengine.v1beta.ServingConfig.MediaConfig.Builder.class);
    }

    private int demoteContentWatchedCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object demoteContentWatched_;

    public enum DemoteContentWatchedCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      CONTENT_WATCHED_PERCENTAGE_THRESHOLD(2),
      CONTENT_WATCHED_SECONDS_THRESHOLD(5),
      DEMOTECONTENTWATCHED_NOT_SET(0);
      private final int value;

      private DemoteContentWatchedCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static DemoteContentWatchedCase valueOf(int value) {
        return forNumber(value);
      }

      public static DemoteContentWatchedCase forNumber(int value) {
        switch (value) {
          case 2:
            return CONTENT_WATCHED_PERCENTAGE_THRESHOLD;
          case 5:
            return CONTENT_WATCHED_SECONDS_THRESHOLD;
          case 0:
            return DEMOTECONTENTWATCHED_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public DemoteContentWatchedCase getDemoteContentWatchedCase() {
      return DemoteContentWatchedCase.forNumber(demoteContentWatchedCase_);
    }

    public static final int CONTENT_WATCHED_PERCENTAGE_THRESHOLD_FIELD_NUMBER = 2;
    /**
     *
     *
     * <pre>
     * Specifies the content watched percentage threshold for demotion.
     * Threshold value must be between [0, 1.0] inclusive.
     * </pre>
     *
     * <code>float content_watched_percentage_threshold = 2;</code>
     *
     * @return Whether the contentWatchedPercentageThreshold field is set.
     */
    @java.lang.Override
    public boolean hasContentWatchedPercentageThreshold() {
      return demoteContentWatchedCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Specifies the content watched percentage threshold for demotion.
     * Threshold value must be between [0, 1.0] inclusive.
     * </pre>
     *
     * <code>float content_watched_percentage_threshold = 2;</code>
     *
     * @return The contentWatchedPercentageThreshold.
     */
    @java.lang.Override
    public float getContentWatchedPercentageThreshold() {
      if (demoteContentWatchedCase_ == 2) {
        return (java.lang.Float) demoteContentWatched_;
      }
      return 0F;
    }

    public static final int CONTENT_WATCHED_SECONDS_THRESHOLD_FIELD_NUMBER = 5;
    /**
     *
     *
     * <pre>
     * Specifies the content watched minutes threshold for demotion.
     * </pre>
     *
     * <code>float content_watched_seconds_threshold = 5;</code>
     *
     * @return Whether the contentWatchedSecondsThreshold field is set.
     */
    @java.lang.Override
    public boolean hasContentWatchedSecondsThreshold() {
      return demoteContentWatchedCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * Specifies the content watched minutes threshold for demotion.
     * </pre>
     *
     * <code>float content_watched_seconds_threshold = 5;</code>
     *
     * @return The contentWatchedSecondsThreshold.
     */
    @java.lang.Override
    public float getContentWatchedSecondsThreshold() {
      if (demoteContentWatchedCase_ == 5) {
        return (java.lang.Float) demoteContentWatched_;
      }
      return 0F;
    }

    public static final int DEMOTION_EVENT_TYPE_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object demotionEventType_ = "";
    /**
     *
     *
     * <pre>
     * Specifies the event type used for demoting recommendation result.
     * Currently supported values:
     *
     * * `view-item`: Item viewed.
     * * `media-play`: Start/resume watching a video, playing a song, etc.
     * * `media-complete`: Finished or stopped midway through a video, song,
     * etc.
     *
     * If unset, watch history demotion will not be applied. Content freshness
     * demotion will still be applied.
     * </pre>
     *
     * <code>string demotion_event_type = 1;</code>
     *
     * @return The demotionEventType.
     */
    @java.lang.Override
    public java.lang.String getDemotionEventType() {
      java.lang.Object ref = demotionEventType_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        demotionEventType_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies the event type used for demoting recommendation result.
     * Currently supported values:
     *
     * * `view-item`: Item viewed.
     * * `media-play`: Start/resume watching a video, playing a song, etc.
     * * `media-complete`: Finished or stopped midway through a video, song,
     * etc.
     *
     * If unset, watch history demotion will not be applied. Content freshness
     * demotion will still be applied.
     * </pre>
     *
     * <code>string demotion_event_type = 1;</code>
     *
     * @return The bytes for demotionEventType.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getDemotionEventTypeBytes() {
      java.lang.Object ref = demotionEventType_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        demotionEventType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int CONTENT_FRESHNESS_CUTOFF_DAYS_FIELD_NUMBER = 4;
    private int contentFreshnessCutoffDays_ = 0;
    /**
     *
     *
     * <pre>
     * Specifies the content freshness used for recommendation result.
     * Contents will be demoted if contents were published for more than content
     * freshness cutoff days.
     * </pre>
     *
     * <code>int32 content_freshness_cutoff_days = 4;</code>
     *
     * @return The contentFreshnessCutoffDays.
     */
    @java.lang.Override
    public int getContentFreshnessCutoffDays() {
      return contentFreshnessCutoffDays_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(demotionEventType_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, demotionEventType_);
      }
      if (demoteContentWatchedCase_ == 2) {
        output.writeFloat(2, (float) ((java.lang.Float) demoteContentWatched_));
      }
      if (contentFreshnessCutoffDays_ != 0) {
        output.writeInt32(4, contentFreshnessCutoffDays_);
      }
      if (demoteContentWatchedCase_ == 5) {
        output.writeFloat(5, (float) ((java.lang.Float) demoteContentWatched_));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(demotionEventType_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, demotionEventType_);
      }
      if (demoteContentWatchedCase_ == 2) {
        size +=
            com.google.protobuf.CodedOutputStream.computeFloatSize(
                2, (float) ((java.lang.Float) demoteContentWatched_));
      }
      if (contentFreshnessCutoffDays_ != 0) {
        size +=
            com.google.protobuf.CodedOutputStream.computeInt32Size(4, contentFreshnessCutoffDays_);
      }
      if (demoteContentWatchedCase_ == 5) {
        size +=
            com.google.protobuf.CodedOutputStream.computeFloatSize(
                5, (float) ((java.lang.Float) demoteContentWatched_));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.discoveryengine.v1beta.ServingConfig.MediaConfig)) {
        return super.equals(obj);
      }
      com.google.cloud.discoveryengine.v1beta.ServingConfig.MediaConfig other =
          (com.google.cloud.discoveryengine.v1beta.ServingConfig.MediaConfig) obj;

      if (!getDemotionEventType().equals(other.getDemotionEventType())) return false;
      if (getContentFreshnessCutoffDays() != other.getContentFreshnessCutoffDays()) return false;
      if (!getDemoteContentWatchedCase().equals(other.getDemoteContentWatchedCase())) return false;
      switch (demoteContentWatchedCase_) {
        case 2:
          if (java.lang.Float.floatToIntBits(getContentWatchedPercentageThreshold())
              != java.lang.Float.floatToIntBits(other.getContentWatchedPercentageThreshold()))
            return false;
          break;
        case 5:
          if (java.lang.Float.floatToIntBits(getContentWatchedSecondsThreshold())
              != java.lang.Float.floatToIntBits(other.getContentWatchedSecondsThreshold()))
            return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + DEMOTION_EVENT_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + getDemotionEventType().hashCode();
      hash = (37 * hash) + CONTENT_FRESHNESS_CUTOFF_DAYS_FIELD_NUMBER;
      hash = (53 * hash) + getContentFreshnessCutoffDays();
      switch (demoteContentWatchedCase_) {
        case 2:
          hash = (37 * hash) + CONTENT_WATCHED_PERCENTAGE_THRESHOLD_FIELD_NUMBER;
          hash =
              (53 * hash) + java.lang.Float.floatToIntBits(getContentWatchedPercentageThreshold());
          break;
        case 5:
          hash = (37 * hash) + CONTENT_WATCHED_SECONDS_THRESHOLD_FIELD_NUMBER;
          hash = (53 * hash) + java.lang.Float.floatToIntBits(getContentWatchedSecondsThreshold());
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.discoveryengine.v1beta.ServingConfig.MediaConfig parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.ServingConfig.MediaConfig parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.ServingConfig.MediaConfig parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.ServingConfig.MediaConfig parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.ServingConfig.MediaConfig parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.ServingConfig.MediaConfig parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.ServingConfig.MediaConfig parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.ServingConfig.MediaConfig parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.ServingConfig.MediaConfig
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.ServingConfig.MediaConfig
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.ServingConfig.MediaConfig parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.ServingConfig.MediaConfig parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.discoveryengine.v1beta.ServingConfig.MediaConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Specifies the configurations needed for Media Discovery. Currently we
     * support:
     *
     * * `demote_content_watched`: Threshold for watched content demotion.
     * Customers can specify if using watched content demotion or use viewed
     * detail page. Using the content watched demotion, customers need to specify
     * the watched minutes or percentage exceeds the threshold, the content will
     * be demoted in the recommendation result.
     * * `promote_fresh_content`: cutoff days for fresh content promotion.
     * Customers can specify if using content freshness promotion. If the content
     * was published within the cutoff days, the content will be promoted in the
     * recommendation result.
     * Can only be set if
     * [SolutionType][google.cloud.discoveryengine.v1beta.SolutionType] is
     * [SOLUTION_TYPE_RECOMMENDATION][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_RECOMMENDATION].
     * </pre>
     *
     * Protobuf type {@code google.cloud.discoveryengine.v1beta.ServingConfig.MediaConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.ServingConfig.MediaConfig)
        com.google.cloud.discoveryengine.v1beta.ServingConfig.MediaConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1beta.ServingConfigProto
            .internal_static_google_cloud_discoveryengine_v1beta_ServingConfig_MediaConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1beta.ServingConfigProto
            .internal_static_google_cloud_discoveryengine_v1beta_ServingConfig_MediaConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1beta.ServingConfig.MediaConfig.class,
                com.google.cloud.discoveryengine.v1beta.ServingConfig.MediaConfig.Builder.class);
      }

      // Construct using
      // com.google.cloud.discoveryengine.v1beta.ServingConfig.MediaConfig.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        demotionEventType_ = "";
        contentFreshnessCutoffDays_ = 0;
        demoteContentWatchedCase_ = 0;
        demoteContentWatched_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.discoveryengine.v1beta.ServingConfigProto
            .internal_static_google_cloud_discoveryengine_v1beta_ServingConfig_MediaConfig_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.ServingConfig.MediaConfig
          getDefaultInstanceForType() {
        return com.google.cloud.discoveryengine.v1beta.ServingConfig.MediaConfig
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.ServingConfig.MediaConfig build() {
        com.google.cloud.discoveryengine.v1beta.ServingConfig.MediaConfig result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.ServingConfig.MediaConfig buildPartial() {
        com.google.cloud.discoveryengine.v1beta.ServingConfig.MediaConfig result =
            new com.google.cloud.discoveryengine.v1beta.ServingConfig.MediaConfig(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.discoveryengine.v1beta.ServingConfig.MediaConfig result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.demotionEventType_ = demotionEventType_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.contentFreshnessCutoffDays_ = contentFreshnessCutoffDays_;
        }
      }

      private void buildPartialOneofs(
          com.google.cloud.discoveryengine.v1beta.ServingConfig.MediaConfig result) {
        result.demoteContentWatchedCase_ = demoteContentWatchedCase_;
        result.demoteContentWatched_ = this.demoteContentWatched_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.discoveryengine.v1beta.ServingConfig.MediaConfig) {
          return mergeFrom(
              (com.google.cloud.discoveryengine.v1beta.ServingConfig.MediaConfig) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.discoveryengine.v1beta.ServingConfig.MediaConfig other) {
        if (other
            == com.google.cloud.discoveryengine.v1beta.ServingConfig.MediaConfig
                .getDefaultInstance()) return this;
        if (!other.getDemotionEventType().isEmpty()) {
          demotionEventType_ = other.demotionEventType_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        if (other.getContentFreshnessCutoffDays() != 0) {
          setContentFreshnessCutoffDays(other.getContentFreshnessCutoffDays());
        }
        switch (other.getDemoteContentWatchedCase()) {
          case CONTENT_WATCHED_PERCENTAGE_THRESHOLD:
            {
              setContentWatchedPercentageThreshold(other.getContentWatchedPercentageThreshold());
              break;
            }
          case CONTENT_WATCHED_SECONDS_THRESHOLD:
            {
              setContentWatchedSecondsThreshold(other.getContentWatchedSecondsThreshold());
              break;
            }
          case DEMOTECONTENTWATCHED_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  demotionEventType_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 10
              case 21:
                {
                  demoteContentWatched_ = input.readFloat();
                  demoteContentWatchedCase_ = 2;
                  break;
                } // case 21
              case 32:
                {
                  contentFreshnessCutoffDays_ = input.readInt32();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 32
              case 45:
                {
                  demoteContentWatched_ = input.readFloat();
                  demoteContentWatchedCase_ = 5;
                  break;
                } // case 45
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int demoteContentWatchedCase_ = 0;
      private java.lang.Object demoteContentWatched_;

      public DemoteContentWatchedCase getDemoteContentWatchedCase() {
        return DemoteContentWatchedCase.forNumber(demoteContentWatchedCase_);
      }

      public Builder clearDemoteContentWatched() {
        demoteContentWatchedCase_ = 0;
        demoteContentWatched_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      /**
       *
       *
       * <pre>
       * Specifies the content watched percentage threshold for demotion.
       * Threshold value must be between [0, 1.0] inclusive.
       * </pre>
       *
       * <code>float content_watched_percentage_threshold = 2;</code>
       *
       * @return Whether the contentWatchedPercentageThreshold field is set.
       */
      public boolean hasContentWatchedPercentageThreshold() {
        return demoteContentWatchedCase_ == 2;
      }
      /**
       *
       *
       * <pre>
       * Specifies the content watched percentage threshold for demotion.
       * Threshold value must be between [0, 1.0] inclusive.
       * </pre>
       *
       * <code>float content_watched_percentage_threshold = 2;</code>
       *
       * @return The contentWatchedPercentageThreshold.
       */
      public float getContentWatchedPercentageThreshold() {
        if (demoteContentWatchedCase_ == 2) {
          return (java.lang.Float) demoteContentWatched_;
        }
        return 0F;
      }
      /**
       *
       *
       * <pre>
       * Specifies the content watched percentage threshold for demotion.
       * Threshold value must be between [0, 1.0] inclusive.
       * </pre>
       *
       * <code>float content_watched_percentage_threshold = 2;</code>
       *
       * @param value The contentWatchedPercentageThreshold to set.
       * @return This builder for chaining.
       */
      public Builder setContentWatchedPercentageThreshold(float value) {

        demoteContentWatchedCase_ = 2;
        demoteContentWatched_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specifies the content watched percentage threshold for demotion.
       * Threshold value must be between [0, 1.0] inclusive.
       * </pre>
       *
       * <code>float content_watched_percentage_threshold = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearContentWatchedPercentageThreshold() {
        if (demoteContentWatchedCase_ == 2) {
          demoteContentWatchedCase_ = 0;
          demoteContentWatched_ = null;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Specifies the content watched minutes threshold for demotion.
       * </pre>
       *
       * <code>float content_watched_seconds_threshold = 5;</code>
       *
       * @return Whether the contentWatchedSecondsThreshold field is set.
       */
      public boolean hasContentWatchedSecondsThreshold() {
        return demoteContentWatchedCase_ == 5;
      }
      /**
       *
       *
       * <pre>
       * Specifies the content watched minutes threshold for demotion.
       * </pre>
       *
       * <code>float content_watched_seconds_threshold = 5;</code>
       *
       * @return The contentWatchedSecondsThreshold.
       */
      public float getContentWatchedSecondsThreshold() {
        if (demoteContentWatchedCase_ == 5) {
          return (java.lang.Float) demoteContentWatched_;
        }
        return 0F;
      }
      /**
       *
       *
       * <pre>
       * Specifies the content watched minutes threshold for demotion.
       * </pre>
       *
       * <code>float content_watched_seconds_threshold = 5;</code>
       *
       * @param value The contentWatchedSecondsThreshold to set.
       * @return This builder for chaining.
       */
      public Builder setContentWatchedSecondsThreshold(float value) {

        demoteContentWatchedCase_ = 5;
        demoteContentWatched_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specifies the content watched minutes threshold for demotion.
       * </pre>
       *
       * <code>float content_watched_seconds_threshold = 5;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearContentWatchedSecondsThreshold() {
        if (demoteContentWatchedCase_ == 5) {
          demoteContentWatchedCase_ = 0;
          demoteContentWatched_ = null;
          onChanged();
        }
        return this;
      }

      private java.lang.Object demotionEventType_ = "";
      /**
       *
       *
       * <pre>
       * Specifies the event type used for demoting recommendation result.
       * Currently supported values:
       *
       * * `view-item`: Item viewed.
       * * `media-play`: Start/resume watching a video, playing a song, etc.
       * * `media-complete`: Finished or stopped midway through a video, song,
       * etc.
       *
       * If unset, watch history demotion will not be applied. Content freshness
       * demotion will still be applied.
       * </pre>
       *
       * <code>string demotion_event_type = 1;</code>
       *
       * @return The demotionEventType.
       */
      public java.lang.String getDemotionEventType() {
        java.lang.Object ref = demotionEventType_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          demotionEventType_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Specifies the event type used for demoting recommendation result.
       * Currently supported values:
       *
       * * `view-item`: Item viewed.
       * * `media-play`: Start/resume watching a video, playing a song, etc.
       * * `media-complete`: Finished or stopped midway through a video, song,
       * etc.
       *
       * If unset, watch history demotion will not be applied. Content freshness
       * demotion will still be applied.
       * </pre>
       *
       * <code>string demotion_event_type = 1;</code>
       *
       * @return The bytes for demotionEventType.
       */
      public com.google.protobuf.ByteString getDemotionEventTypeBytes() {
        java.lang.Object ref = demotionEventType_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          demotionEventType_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Specifies the event type used for demoting recommendation result.
       * Currently supported values:
       *
       * * `view-item`: Item viewed.
       * * `media-play`: Start/resume watching a video, playing a song, etc.
       * * `media-complete`: Finished or stopped midway through a video, song,
       * etc.
       *
       * If unset, watch history demotion will not be applied. Content freshness
       * demotion will still be applied.
       * </pre>
       *
       * <code>string demotion_event_type = 1;</code>
       *
       * @param value The demotionEventType to set.
       * @return This builder for chaining.
       */
      public Builder setDemotionEventType(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        demotionEventType_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specifies the event type used for demoting recommendation result.
       * Currently supported values:
       *
       * * `view-item`: Item viewed.
       * * `media-play`: Start/resume watching a video, playing a song, etc.
       * * `media-complete`: Finished or stopped midway through a video, song,
       * etc.
       *
       * If unset, watch history demotion will not be applied. Content freshness
       * demotion will still be applied.
       * </pre>
       *
       * <code>string demotion_event_type = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDemotionEventType() {
        demotionEventType_ = getDefaultInstance().getDemotionEventType();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specifies the event type used for demoting recommendation result.
       * Currently supported values:
       *
       * * `view-item`: Item viewed.
       * * `media-play`: Start/resume watching a video, playing a song, etc.
       * * `media-complete`: Finished or stopped midway through a video, song,
       * etc.
       *
       * If unset, watch history demotion will not be applied. Content freshness
       * demotion will still be applied.
       * </pre>
       *
       * <code>string demotion_event_type = 1;</code>
       *
       * @param value The bytes for demotionEventType to set.
       * @return This builder for chaining.
       */
      public Builder setDemotionEventTypeBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        demotionEventType_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      private int contentFreshnessCutoffDays_;
      /**
       *
       *
       * <pre>
       * Specifies the content freshness used for recommendation result.
       * Contents will be demoted if contents were published for more than content
       * freshness cutoff days.
       * </pre>
       *
       * <code>int32 content_freshness_cutoff_days = 4;</code>
       *
       * @return The contentFreshnessCutoffDays.
       */
      @java.lang.Override
      public int getContentFreshnessCutoffDays() {
        return contentFreshnessCutoffDays_;
      }
      /**
       *
       *
       * <pre>
       * Specifies the content freshness used for recommendation result.
       * Contents will be demoted if contents were published for more than content
       * freshness cutoff days.
       * </pre>
       *
       * <code>int32 content_freshness_cutoff_days = 4;</code>
       *
       * @param value The contentFreshnessCutoffDays to set.
       * @return This builder for chaining.
       */
      public Builder setContentFreshnessCutoffDays(int value) {

        contentFreshnessCutoffDays_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specifies the content freshness used for recommendation result.
       * Contents will be demoted if contents were published for more than content
       * freshness cutoff days.
       * </pre>
       *
       * <code>int32 content_freshness_cutoff_days = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearContentFreshnessCutoffDays() {
        bitField0_ = (bitField0_ & ~0x00000008);
        contentFreshnessCutoffDays_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.ServingConfig.MediaConfig)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.ServingConfig.MediaConfig)
    private static final com.google.cloud.discoveryengine.v1beta.ServingConfig.MediaConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.discoveryengine.v1beta.ServingConfig.MediaConfig();
    }

    public static com.google.cloud.discoveryengine.v1beta.ServingConfig.MediaConfig
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<MediaConfig> PARSER =
        new com.google.protobuf.AbstractParser<MediaConfig>() {
          @java.lang.Override
          public MediaConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<MediaConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<MediaConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.ServingConfig.MediaConfig
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface GenericConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1beta.ServingConfig.GenericConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Specifies the expected behavior of content search.
     * Only valid for content-search enabled data store.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec content_search_spec = 1;
     * </code>
     *
     * @return Whether the contentSearchSpec field is set.
     */
    boolean hasContentSearchSpec();
    /**
     *
     *
     * <pre>
     * Specifies the expected behavior of content search.
     * Only valid for content-search enabled data store.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec content_search_spec = 1;
     * </code>
     *
     * @return The contentSearchSpec.
     */
    com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec getContentSearchSpec();
    /**
     *
     *
     * <pre>
     * Specifies the expected behavior of content search.
     * Only valid for content-search enabled data store.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec content_search_spec = 1;
     * </code>
     */
    com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpecOrBuilder
        getContentSearchSpecOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * Specifies the configurations needed for Generic Discovery.Currently we
   * support:
   *
   * * `content_search_spec`: configuration for generic content search.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1beta.ServingConfig.GenericConfig}
   */
  public static final class GenericConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.ServingConfig.GenericConfig)
      GenericConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use GenericConfig.newBuilder() to construct.
    private GenericConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private GenericConfig() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new GenericConfig();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1beta.ServingConfigProto
          .internal_static_google_cloud_discoveryengine_v1beta_ServingConfig_GenericConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1beta.ServingConfigProto
          .internal_static_google_cloud_discoveryengine_v1beta_ServingConfig_GenericConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1beta.ServingConfig.GenericConfig.class,
              com.google.cloud.discoveryengine.v1beta.ServingConfig.GenericConfig.Builder.class);
    }

    private int bitField0_;
    public static final int CONTENT_SEARCH_SPEC_FIELD_NUMBER = 1;
    private com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
        contentSearchSpec_;
    /**
     *
     *
     * <pre>
     * Specifies the expected behavior of content search.
     * Only valid for content-search enabled data store.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec content_search_spec = 1;
     * </code>
     *
     * @return Whether the contentSearchSpec field is set.
     */
    @java.lang.Override
    public boolean hasContentSearchSpec() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Specifies the expected behavior of content search.
     * Only valid for content-search enabled data store.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec content_search_spec = 1;
     * </code>
     *
     * @return The contentSearchSpec.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
        getContentSearchSpec() {
      return contentSearchSpec_ == null
          ? com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
              .getDefaultInstance()
          : contentSearchSpec_;
    }
    /**
     *
     *
     * <pre>
     * Specifies the expected behavior of content search.
     * Only valid for content-search enabled data store.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec content_search_spec = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpecOrBuilder
        getContentSearchSpecOrBuilder() {
      return contentSearchSpec_ == null
          ? com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
              .getDefaultInstance()
          : contentSearchSpec_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getContentSearchSpec());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getContentSearchSpec());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.discoveryengine.v1beta.ServingConfig.GenericConfig)) {
        return super.equals(obj);
      }
      com.google.cloud.discoveryengine.v1beta.ServingConfig.GenericConfig other =
          (com.google.cloud.discoveryengine.v1beta.ServingConfig.GenericConfig) obj;

      if (hasContentSearchSpec() != other.hasContentSearchSpec()) return false;
      if (hasContentSearchSpec()) {
        if (!getContentSearchSpec().equals(other.getContentSearchSpec())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasContentSearchSpec()) {
        hash = (37 * hash) + CONTENT_SEARCH_SPEC_FIELD_NUMBER;
        hash = (53 * hash) + getContentSearchSpec().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.discoveryengine.v1beta.ServingConfig.GenericConfig parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.ServingConfig.GenericConfig parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.ServingConfig.GenericConfig parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.ServingConfig.GenericConfig parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.ServingConfig.GenericConfig parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.ServingConfig.GenericConfig parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.ServingConfig.GenericConfig parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.ServingConfig.GenericConfig parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.ServingConfig.GenericConfig
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.ServingConfig.GenericConfig
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.ServingConfig.GenericConfig parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.ServingConfig.GenericConfig parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.discoveryengine.v1beta.ServingConfig.GenericConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Specifies the configurations needed for Generic Discovery.Currently we
     * support:
     *
     * * `content_search_spec`: configuration for generic content search.
     * </pre>
     *
     * Protobuf type {@code google.cloud.discoveryengine.v1beta.ServingConfig.GenericConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.ServingConfig.GenericConfig)
        com.google.cloud.discoveryengine.v1beta.ServingConfig.GenericConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1beta.ServingConfigProto
            .internal_static_google_cloud_discoveryengine_v1beta_ServingConfig_GenericConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1beta.ServingConfigProto
            .internal_static_google_cloud_discoveryengine_v1beta_ServingConfig_GenericConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1beta.ServingConfig.GenericConfig.class,
                com.google.cloud.discoveryengine.v1beta.ServingConfig.GenericConfig.Builder.class);
      }

      // Construct using
      // com.google.cloud.discoveryengine.v1beta.ServingConfig.GenericConfig.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getContentSearchSpecFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        contentSearchSpec_ = null;
        if (contentSearchSpecBuilder_ != null) {
          contentSearchSpecBuilder_.dispose();
          contentSearchSpecBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.discoveryengine.v1beta.ServingConfigProto
            .internal_static_google_cloud_discoveryengine_v1beta_ServingConfig_GenericConfig_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.ServingConfig.GenericConfig
          getDefaultInstanceForType() {
        return com.google.cloud.discoveryengine.v1beta.ServingConfig.GenericConfig
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.ServingConfig.GenericConfig build() {
        com.google.cloud.discoveryengine.v1beta.ServingConfig.GenericConfig result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.ServingConfig.GenericConfig buildPartial() {
        com.google.cloud.discoveryengine.v1beta.ServingConfig.GenericConfig result =
            new com.google.cloud.discoveryengine.v1beta.ServingConfig.GenericConfig(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.discoveryengine.v1beta.ServingConfig.GenericConfig result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.contentSearchSpec_ =
              contentSearchSpecBuilder_ == null
                  ? contentSearchSpec_
                  : contentSearchSpecBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.discoveryengine.v1beta.ServingConfig.GenericConfig) {
          return mergeFrom(
              (com.google.cloud.discoveryengine.v1beta.ServingConfig.GenericConfig) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.discoveryengine.v1beta.ServingConfig.GenericConfig other) {
        if (other
            == com.google.cloud.discoveryengine.v1beta.ServingConfig.GenericConfig
                .getDefaultInstance()) return this;
        if (other.hasContentSearchSpec()) {
          mergeContentSearchSpec(other.getContentSearchSpec());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(
                      getContentSearchSpecFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
          contentSearchSpec_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec,
              com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.Builder,
              com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpecOrBuilder>
          contentSearchSpecBuilder_;
      /**
       *
       *
       * <pre>
       * Specifies the expected behavior of content search.
       * Only valid for content-search enabled data store.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec content_search_spec = 1;
       * </code>
       *
       * @return Whether the contentSearchSpec field is set.
       */
      public boolean hasContentSearchSpec() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * Specifies the expected behavior of content search.
       * Only valid for content-search enabled data store.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec content_search_spec = 1;
       * </code>
       *
       * @return The contentSearchSpec.
       */
      public com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
          getContentSearchSpec() {
        if (contentSearchSpecBuilder_ == null) {
          return contentSearchSpec_ == null
              ? com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                  .getDefaultInstance()
              : contentSearchSpec_;
        } else {
          return contentSearchSpecBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Specifies the expected behavior of content search.
       * Only valid for content-search enabled data store.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec content_search_spec = 1;
       * </code>
       */
      public Builder setContentSearchSpec(
          com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec value) {
        if (contentSearchSpecBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          contentSearchSpec_ = value;
        } else {
          contentSearchSpecBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specifies the expected behavior of content search.
       * Only valid for content-search enabled data store.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec content_search_spec = 1;
       * </code>
       */
      public Builder setContentSearchSpec(
          com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.Builder
              builderForValue) {
        if (contentSearchSpecBuilder_ == null) {
          contentSearchSpec_ = builderForValue.build();
        } else {
          contentSearchSpecBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specifies the expected behavior of content search.
       * Only valid for content-search enabled data store.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec content_search_spec = 1;
       * </code>
       */
      public Builder mergeContentSearchSpec(
          com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec value) {
        if (contentSearchSpecBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && contentSearchSpec_ != null
              && contentSearchSpec_
                  != com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                      .getDefaultInstance()) {
            getContentSearchSpecBuilder().mergeFrom(value);
          } else {
            contentSearchSpec_ = value;
          }
        } else {
          contentSearchSpecBuilder_.mergeFrom(value);
        }
        if (contentSearchSpec_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specifies the expected behavior of content search.
       * Only valid for content-search enabled data store.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec content_search_spec = 1;
       * </code>
       */
      public Builder clearContentSearchSpec() {
        bitField0_ = (bitField0_ & ~0x00000001);
        contentSearchSpec_ = null;
        if (contentSearchSpecBuilder_ != null) {
          contentSearchSpecBuilder_.dispose();
          contentSearchSpecBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specifies the expected behavior of content search.
       * Only valid for content-search enabled data store.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec content_search_spec = 1;
       * </code>
       */
      public com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.Builder
          getContentSearchSpecBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getContentSearchSpecFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Specifies the expected behavior of content search.
       * Only valid for content-search enabled data store.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec content_search_spec = 1;
       * </code>
       */
      public com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpecOrBuilder
          getContentSearchSpecOrBuilder() {
        if (contentSearchSpecBuilder_ != null) {
          return contentSearchSpecBuilder_.getMessageOrBuilder();
        } else {
          return contentSearchSpec_ == null
              ? com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                  .getDefaultInstance()
              : contentSearchSpec_;
        }
      }
      /**
       *
       *
       * <pre>
       * Specifies the expected behavior of content search.
       * Only valid for content-search enabled data store.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec content_search_spec = 1;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec,
              com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.Builder,
              com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpecOrBuilder>
          getContentSearchSpecFieldBuilder() {
        if (contentSearchSpecBuilder_ == null) {
          contentSearchSpecBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec,
                  com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.Builder,
                  com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpecOrBuilder>(
                  getContentSearchSpec(), getParentForChildren(), isClean());
          contentSearchSpec_ = null;
        }
        return contentSearchSpecBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.ServingConfig.GenericConfig)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.ServingConfig.GenericConfig)
    private static final com.google.cloud.discoveryengine.v1beta.ServingConfig.GenericConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.discoveryengine.v1beta.ServingConfig.GenericConfig();
    }

    public static com.google.cloud.discoveryengine.v1beta.ServingConfig.GenericConfig
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<GenericConfig> PARSER =
        new com.google.protobuf.AbstractParser<GenericConfig>() {
          @java.lang.Override
          public GenericConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<GenericConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<GenericConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.ServingConfig.GenericConfig
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  private int verticalConfigCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object verticalConfig_;

  public enum VerticalConfigCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    MEDIA_CONFIG(7),
    GENERIC_CONFIG(10),
    VERTICALCONFIG_NOT_SET(0);
    private final int value;

    private VerticalConfigCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static VerticalConfigCase valueOf(int value) {
      return forNumber(value);
    }

    public static VerticalConfigCase forNumber(int value) {
      switch (value) {
        case 7:
          return MEDIA_CONFIG;
        case 10:
          return GENERIC_CONFIG;
        case 0:
          return VERTICALCONFIG_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public VerticalConfigCase getVerticalConfigCase() {
    return VerticalConfigCase.forNumber(verticalConfigCase_);
  }

  public static final int MEDIA_CONFIG_FIELD_NUMBER = 7;
  /**
   *
   *
   * <pre>
   * The MediaConfig of the serving configuration.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.ServingConfig.MediaConfig media_config = 7;</code>
   *
   * @return Whether the mediaConfig field is set.
   */
  @java.lang.Override
  public boolean hasMediaConfig() {
    return verticalConfigCase_ == 7;
  }
  /**
   *
   *
   * <pre>
   * The MediaConfig of the serving configuration.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.ServingConfig.MediaConfig media_config = 7;</code>
   *
   * @return The mediaConfig.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.ServingConfig.MediaConfig getMediaConfig() {
    if (verticalConfigCase_ == 7) {
      return (com.google.cloud.discoveryengine.v1beta.ServingConfig.MediaConfig) verticalConfig_;
    }
    return com.google.cloud.discoveryengine.v1beta.ServingConfig.MediaConfig.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The MediaConfig of the serving configuration.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.ServingConfig.MediaConfig media_config = 7;</code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.ServingConfig.MediaConfigOrBuilder
      getMediaConfigOrBuilder() {
    if (verticalConfigCase_ == 7) {
      return (com.google.cloud.discoveryengine.v1beta.ServingConfig.MediaConfig) verticalConfig_;
    }
    return com.google.cloud.discoveryengine.v1beta.ServingConfig.MediaConfig.getDefaultInstance();
  }

  public static final int GENERIC_CONFIG_FIELD_NUMBER = 10;
  /**
   *
   *
   * <pre>
   * The GenericConfig of the serving configuration.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.ServingConfig.GenericConfig generic_config = 10;
   * </code>
   *
   * @return Whether the genericConfig field is set.
   */
  @java.lang.Override
  public boolean hasGenericConfig() {
    return verticalConfigCase_ == 10;
  }
  /**
   *
   *
   * <pre>
   * The GenericConfig of the serving configuration.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.ServingConfig.GenericConfig generic_config = 10;
   * </code>
   *
   * @return The genericConfig.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.ServingConfig.GenericConfig getGenericConfig() {
    if (verticalConfigCase_ == 10) {
      return (com.google.cloud.discoveryengine.v1beta.ServingConfig.GenericConfig) verticalConfig_;
    }
    return com.google.cloud.discoveryengine.v1beta.ServingConfig.GenericConfig.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The GenericConfig of the serving configuration.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.ServingConfig.GenericConfig generic_config = 10;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.ServingConfig.GenericConfigOrBuilder
      getGenericConfigOrBuilder() {
    if (verticalConfigCase_ == 10) {
      return (com.google.cloud.discoveryengine.v1beta.ServingConfig.GenericConfig) verticalConfig_;
    }
    return com.google.cloud.discoveryengine.v1beta.ServingConfig.GenericConfig.getDefaultInstance();
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Immutable. Fully qualified name
   * `projects/{project}/locations/{location}/collections/{collection_id}/engines/{engine_id}/servingConfigs/{serving_config_id}`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Immutable. Fully qualified name
   * `projects/{project}/locations/{location}/collections/{collection_id}/engines/{engine_id}/servingConfigs/{serving_config_id}`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";
  /**
   *
   *
   * <pre>
   * Required. The human readable serving config display name. Used in Discovery
   * UI.
   *
   * This field must be a UTF-8 encoded string with a length limit of 128
   * characters. Otherwise, an INVALID_ARGUMENT error is returned.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The human readable serving config display name. Used in Discovery
   * UI.
   *
   * This field must be a UTF-8 encoded string with a length limit of 128
   * characters. Otherwise, an INVALID_ARGUMENT error is returned.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SOLUTION_TYPE_FIELD_NUMBER = 3;
  private int solutionType_ = 0;
  /**
   *
   *
   * <pre>
   * Required. Immutable. Specifies the solution type that a serving config can
   * be associated with.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1beta.SolutionType solution_type = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The enum numeric value on the wire for solutionType.
   */
  @java.lang.Override
  public int getSolutionTypeValue() {
    return solutionType_;
  }
  /**
   *
   *
   * <pre>
   * Required. Immutable. Specifies the solution type that a serving config can
   * be associated with.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1beta.SolutionType solution_type = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The solutionType.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.SolutionType getSolutionType() {
    com.google.cloud.discoveryengine.v1beta.SolutionType result =
        com.google.cloud.discoveryengine.v1beta.SolutionType.forNumber(solutionType_);
    return result == null
        ? com.google.cloud.discoveryengine.v1beta.SolutionType.UNRECOGNIZED
        : result;
  }

  public static final int MODEL_ID_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object modelId_ = "";
  /**
   *
   *
   * <pre>
   * The id of the model to use at serving time.
   * Currently only RecommendationModels are supported.
   * Can be changed but only to a compatible model (e.g.
   * others-you-may-like CTR to others-you-may-like CVR).
   *
   * Required when
   * [SolutionType][google.cloud.discoveryengine.v1beta.SolutionType] is
   * [SOLUTION_TYPE_RECOMMENDATION][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_RECOMMENDATION].
   * </pre>
   *
   * <code>string model_id = 4;</code>
   *
   * @return The modelId.
   */
  @java.lang.Override
  public java.lang.String getModelId() {
    java.lang.Object ref = modelId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      modelId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The id of the model to use at serving time.
   * Currently only RecommendationModels are supported.
   * Can be changed but only to a compatible model (e.g.
   * others-you-may-like CTR to others-you-may-like CVR).
   *
   * Required when
   * [SolutionType][google.cloud.discoveryengine.v1beta.SolutionType] is
   * [SOLUTION_TYPE_RECOMMENDATION][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_RECOMMENDATION].
   * </pre>
   *
   * <code>string model_id = 4;</code>
   *
   * @return The bytes for modelId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getModelIdBytes() {
    java.lang.Object ref = modelId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      modelId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DIVERSITY_LEVEL_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object diversityLevel_ = "";
  /**
   *
   *
   * <pre>
   * How much diversity to use in recommendation model results e.g.
   * `medium-diversity` or `high-diversity`. Currently supported values:
   *
   * * `no-diversity`
   * * `low-diversity`
   * * `medium-diversity`
   * * `high-diversity`
   * * `auto-diversity`
   *
   * If not specified, we choose default based on recommendation model
   * type. Default value: `no-diversity`.
   *
   * Can only be set if
   * [SolutionType][google.cloud.discoveryengine.v1beta.SolutionType] is
   * [SOLUTION_TYPE_RECOMMENDATION][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_RECOMMENDATION].
   * </pre>
   *
   * <code>string diversity_level = 5;</code>
   *
   * @return The diversityLevel.
   */
  @java.lang.Override
  public java.lang.String getDiversityLevel() {
    java.lang.Object ref = diversityLevel_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      diversityLevel_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * How much diversity to use in recommendation model results e.g.
   * `medium-diversity` or `high-diversity`. Currently supported values:
   *
   * * `no-diversity`
   * * `low-diversity`
   * * `medium-diversity`
   * * `high-diversity`
   * * `auto-diversity`
   *
   * If not specified, we choose default based on recommendation model
   * type. Default value: `no-diversity`.
   *
   * Can only be set if
   * [SolutionType][google.cloud.discoveryengine.v1beta.SolutionType] is
   * [SOLUTION_TYPE_RECOMMENDATION][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_RECOMMENDATION].
   * </pre>
   *
   * <code>string diversity_level = 5;</code>
   *
   * @return The bytes for diversityLevel.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDiversityLevelBytes() {
    java.lang.Object ref = diversityLevel_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      diversityLevel_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int EMBEDDING_CONFIG_FIELD_NUMBER = 20;
  private com.google.cloud.discoveryengine.v1beta.EmbeddingConfig embeddingConfig_;
  /**
   *
   *
   * <pre>
   * Bring your own embedding config. The config is used for search semantic
   * retrieval. The retrieval is based on the dot product of
   * [SearchRequest.EmbeddingSpec.EmbeddingVector.vector][google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.EmbeddingVector.vector]
   * and the document embeddings that are provided by this EmbeddingConfig. If
   * [SearchRequest.EmbeddingSpec.EmbeddingVector.vector][google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.EmbeddingVector.vector]
   * is provided, it overrides this
   * [ServingConfig.embedding_config][google.cloud.discoveryengine.v1beta.ServingConfig.embedding_config].
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.EmbeddingConfig embedding_config = 20;</code>
   *
   * @return Whether the embeddingConfig field is set.
   */
  @java.lang.Override
  public boolean hasEmbeddingConfig() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Bring your own embedding config. The config is used for search semantic
   * retrieval. The retrieval is based on the dot product of
   * [SearchRequest.EmbeddingSpec.EmbeddingVector.vector][google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.EmbeddingVector.vector]
   * and the document embeddings that are provided by this EmbeddingConfig. If
   * [SearchRequest.EmbeddingSpec.EmbeddingVector.vector][google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.EmbeddingVector.vector]
   * is provided, it overrides this
   * [ServingConfig.embedding_config][google.cloud.discoveryengine.v1beta.ServingConfig.embedding_config].
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.EmbeddingConfig embedding_config = 20;</code>
   *
   * @return The embeddingConfig.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.EmbeddingConfig getEmbeddingConfig() {
    return embeddingConfig_ == null
        ? com.google.cloud.discoveryengine.v1beta.EmbeddingConfig.getDefaultInstance()
        : embeddingConfig_;
  }
  /**
   *
   *
   * <pre>
   * Bring your own embedding config. The config is used for search semantic
   * retrieval. The retrieval is based on the dot product of
   * [SearchRequest.EmbeddingSpec.EmbeddingVector.vector][google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.EmbeddingVector.vector]
   * and the document embeddings that are provided by this EmbeddingConfig. If
   * [SearchRequest.EmbeddingSpec.EmbeddingVector.vector][google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.EmbeddingVector.vector]
   * is provided, it overrides this
   * [ServingConfig.embedding_config][google.cloud.discoveryengine.v1beta.ServingConfig.embedding_config].
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.EmbeddingConfig embedding_config = 20;</code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.EmbeddingConfigOrBuilder
      getEmbeddingConfigOrBuilder() {
    return embeddingConfig_ == null
        ? com.google.cloud.discoveryengine.v1beta.EmbeddingConfig.getDefaultInstance()
        : embeddingConfig_;
  }

  public static final int RANKING_EXPRESSION_FIELD_NUMBER = 21;

  @SuppressWarnings("serial")
  private volatile java.lang.Object rankingExpression_ = "";
  /**
   *
   *
   * <pre>
   * The ranking expression controls the customized ranking on retrieval
   * documents. To leverage this, document embedding is required. The ranking
   * expression setting in ServingConfig applies to all search requests served
   * by the serving config. However, if
   * [SearchRequest.ranking_expression][google.cloud.discoveryengine.v1beta.SearchRequest.ranking_expression]
   * is specified, it overrides the ServingConfig ranking expression.
   *
   * The ranking expression is a single function or multiple functions that are
   * joined by "+".
   *
   *   * ranking_expression = function, { " + ", function };
   *
   * Supported functions:
   *
   *   * double * relevance_score
   *   * double * dotProduct(embedding_field_path)
   *
   * Function variables:
   *
   *   * `relevance_score`: pre-defined keywords, used for measure relevance
   *   between query and document.
   *   * `embedding_field_path`: the document embedding field
   *   used with query embedding vector.
   *   * `dotProduct`: embedding function between embedding_field_path and query
   *   embedding vector.
   *
   *  Example ranking expression:
   *
   *    If document has an embedding field doc_embedding, the ranking expression
   *    could be `0.5 * relevance_score + 0.3 * dotProduct(doc_embedding)`.
   * </pre>
   *
   * <code>string ranking_expression = 21;</code>
   *
   * @return The rankingExpression.
   */
  @java.lang.Override
  public java.lang.String getRankingExpression() {
    java.lang.Object ref = rankingExpression_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      rankingExpression_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The ranking expression controls the customized ranking on retrieval
   * documents. To leverage this, document embedding is required. The ranking
   * expression setting in ServingConfig applies to all search requests served
   * by the serving config. However, if
   * [SearchRequest.ranking_expression][google.cloud.discoveryengine.v1beta.SearchRequest.ranking_expression]
   * is specified, it overrides the ServingConfig ranking expression.
   *
   * The ranking expression is a single function or multiple functions that are
   * joined by "+".
   *
   *   * ranking_expression = function, { " + ", function };
   *
   * Supported functions:
   *
   *   * double * relevance_score
   *   * double * dotProduct(embedding_field_path)
   *
   * Function variables:
   *
   *   * `relevance_score`: pre-defined keywords, used for measure relevance
   *   between query and document.
   *   * `embedding_field_path`: the document embedding field
   *   used with query embedding vector.
   *   * `dotProduct`: embedding function between embedding_field_path and query
   *   embedding vector.
   *
   *  Example ranking expression:
   *
   *    If document has an embedding field doc_embedding, the ranking expression
   *    could be `0.5 * relevance_score + 0.3 * dotProduct(doc_embedding)`.
   * </pre>
   *
   * <code>string ranking_expression = 21;</code>
   *
   * @return The bytes for rankingExpression.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRankingExpressionBytes() {
    java.lang.Object ref = rankingExpression_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      rankingExpression_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 8;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. ServingConfig created timestamp.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. ServingConfig created timestamp.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. ServingConfig created timestamp.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 9;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. ServingConfig updated timestamp.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. ServingConfig updated timestamp.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. ServingConfig updated timestamp.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int FILTER_CONTROL_IDS_FIELD_NUMBER = 11;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList filterControlIds_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Filter controls to use in serving path.
   * All triggered filter controls will be applied.
   * Filter controls must be in the same data store as the serving config.
   * Maximum of 20 filter controls.
   * </pre>
   *
   * <code>repeated string filter_control_ids = 11;</code>
   *
   * @return A list containing the filterControlIds.
   */
  public com.google.protobuf.ProtocolStringList getFilterControlIdsList() {
    return filterControlIds_;
  }
  /**
   *
   *
   * <pre>
   * Filter controls to use in serving path.
   * All triggered filter controls will be applied.
   * Filter controls must be in the same data store as the serving config.
   * Maximum of 20 filter controls.
   * </pre>
   *
   * <code>repeated string filter_control_ids = 11;</code>
   *
   * @return The count of filterControlIds.
   */
  public int getFilterControlIdsCount() {
    return filterControlIds_.size();
  }
  /**
   *
   *
   * <pre>
   * Filter controls to use in serving path.
   * All triggered filter controls will be applied.
   * Filter controls must be in the same data store as the serving config.
   * Maximum of 20 filter controls.
   * </pre>
   *
   * <code>repeated string filter_control_ids = 11;</code>
   *
   * @param index The index of the element to return.
   * @return The filterControlIds at the given index.
   */
  public java.lang.String getFilterControlIds(int index) {
    return filterControlIds_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Filter controls to use in serving path.
   * All triggered filter controls will be applied.
   * Filter controls must be in the same data store as the serving config.
   * Maximum of 20 filter controls.
   * </pre>
   *
   * <code>repeated string filter_control_ids = 11;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the filterControlIds at the given index.
   */
  public com.google.protobuf.ByteString getFilterControlIdsBytes(int index) {
    return filterControlIds_.getByteString(index);
  }

  public static final int BOOST_CONTROL_IDS_FIELD_NUMBER = 12;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList boostControlIds_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Boost controls to use in serving path.
   * All triggered boost controls will be applied.
   * Boost controls must be in the same data store as the serving config.
   * Maximum of 20 boost controls.
   * </pre>
   *
   * <code>repeated string boost_control_ids = 12;</code>
   *
   * @return A list containing the boostControlIds.
   */
  public com.google.protobuf.ProtocolStringList getBoostControlIdsList() {
    return boostControlIds_;
  }
  /**
   *
   *
   * <pre>
   * Boost controls to use in serving path.
   * All triggered boost controls will be applied.
   * Boost controls must be in the same data store as the serving config.
   * Maximum of 20 boost controls.
   * </pre>
   *
   * <code>repeated string boost_control_ids = 12;</code>
   *
   * @return The count of boostControlIds.
   */
  public int getBoostControlIdsCount() {
    return boostControlIds_.size();
  }
  /**
   *
   *
   * <pre>
   * Boost controls to use in serving path.
   * All triggered boost controls will be applied.
   * Boost controls must be in the same data store as the serving config.
   * Maximum of 20 boost controls.
   * </pre>
   *
   * <code>repeated string boost_control_ids = 12;</code>
   *
   * @param index The index of the element to return.
   * @return The boostControlIds at the given index.
   */
  public java.lang.String getBoostControlIds(int index) {
    return boostControlIds_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Boost controls to use in serving path.
   * All triggered boost controls will be applied.
   * Boost controls must be in the same data store as the serving config.
   * Maximum of 20 boost controls.
   * </pre>
   *
   * <code>repeated string boost_control_ids = 12;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the boostControlIds at the given index.
   */
  public com.google.protobuf.ByteString getBoostControlIdsBytes(int index) {
    return boostControlIds_.getByteString(index);
  }

  public static final int REDIRECT_CONTROL_IDS_FIELD_NUMBER = 14;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList redirectControlIds_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * IDs of the redirect controls. Only the first triggered redirect
   * action is applied, even if multiple apply. Maximum number of
   * specifications is 100.
   *
   * Can only be set if
   * [SolutionType][google.cloud.discoveryengine.v1beta.SolutionType] is
   * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH].
   * </pre>
   *
   * <code>repeated string redirect_control_ids = 14;</code>
   *
   * @return A list containing the redirectControlIds.
   */
  public com.google.protobuf.ProtocolStringList getRedirectControlIdsList() {
    return redirectControlIds_;
  }
  /**
   *
   *
   * <pre>
   * IDs of the redirect controls. Only the first triggered redirect
   * action is applied, even if multiple apply. Maximum number of
   * specifications is 100.
   *
   * Can only be set if
   * [SolutionType][google.cloud.discoveryengine.v1beta.SolutionType] is
   * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH].
   * </pre>
   *
   * <code>repeated string redirect_control_ids = 14;</code>
   *
   * @return The count of redirectControlIds.
   */
  public int getRedirectControlIdsCount() {
    return redirectControlIds_.size();
  }
  /**
   *
   *
   * <pre>
   * IDs of the redirect controls. Only the first triggered redirect
   * action is applied, even if multiple apply. Maximum number of
   * specifications is 100.
   *
   * Can only be set if
   * [SolutionType][google.cloud.discoveryengine.v1beta.SolutionType] is
   * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH].
   * </pre>
   *
   * <code>repeated string redirect_control_ids = 14;</code>
   *
   * @param index The index of the element to return.
   * @return The redirectControlIds at the given index.
   */
  public java.lang.String getRedirectControlIds(int index) {
    return redirectControlIds_.get(index);
  }
  /**
   *
   *
   * <pre>
   * IDs of the redirect controls. Only the first triggered redirect
   * action is applied, even if multiple apply. Maximum number of
   * specifications is 100.
   *
   * Can only be set if
   * [SolutionType][google.cloud.discoveryengine.v1beta.SolutionType] is
   * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH].
   * </pre>
   *
   * <code>repeated string redirect_control_ids = 14;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the redirectControlIds at the given index.
   */
  public com.google.protobuf.ByteString getRedirectControlIdsBytes(int index) {
    return redirectControlIds_.getByteString(index);
  }

  public static final int SYNONYMS_CONTROL_IDS_FIELD_NUMBER = 15;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList synonymsControlIds_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Condition synonyms specifications. If multiple synonyms conditions
   * match, all matching synonyms controls in the list will execute.
   * Maximum number of specifications is 100.
   *
   * Can only be set if
   * [SolutionType][google.cloud.discoveryengine.v1beta.SolutionType] is
   * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH].
   * </pre>
   *
   * <code>repeated string synonyms_control_ids = 15;</code>
   *
   * @return A list containing the synonymsControlIds.
   */
  public com.google.protobuf.ProtocolStringList getSynonymsControlIdsList() {
    return synonymsControlIds_;
  }
  /**
   *
   *
   * <pre>
   * Condition synonyms specifications. If multiple synonyms conditions
   * match, all matching synonyms controls in the list will execute.
   * Maximum number of specifications is 100.
   *
   * Can only be set if
   * [SolutionType][google.cloud.discoveryengine.v1beta.SolutionType] is
   * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH].
   * </pre>
   *
   * <code>repeated string synonyms_control_ids = 15;</code>
   *
   * @return The count of synonymsControlIds.
   */
  public int getSynonymsControlIdsCount() {
    return synonymsControlIds_.size();
  }
  /**
   *
   *
   * <pre>
   * Condition synonyms specifications. If multiple synonyms conditions
   * match, all matching synonyms controls in the list will execute.
   * Maximum number of specifications is 100.
   *
   * Can only be set if
   * [SolutionType][google.cloud.discoveryengine.v1beta.SolutionType] is
   * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH].
   * </pre>
   *
   * <code>repeated string synonyms_control_ids = 15;</code>
   *
   * @param index The index of the element to return.
   * @return The synonymsControlIds at the given index.
   */
  public java.lang.String getSynonymsControlIds(int index) {
    return synonymsControlIds_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Condition synonyms specifications. If multiple synonyms conditions
   * match, all matching synonyms controls in the list will execute.
   * Maximum number of specifications is 100.
   *
   * Can only be set if
   * [SolutionType][google.cloud.discoveryengine.v1beta.SolutionType] is
   * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH].
   * </pre>
   *
   * <code>repeated string synonyms_control_ids = 15;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the synonymsControlIds at the given index.
   */
  public com.google.protobuf.ByteString getSynonymsControlIdsBytes(int index) {
    return synonymsControlIds_.getByteString(index);
  }

  public static final int ONEWAY_SYNONYMS_CONTROL_IDS_FIELD_NUMBER = 16;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList onewaySynonymsControlIds_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Condition oneway synonyms specifications. If multiple oneway synonyms
   * conditions match, all matching oneway synonyms controls in the list
   * will execute. Maximum number of specifications is 100.
   *
   * Can only be set if
   * [SolutionType][google.cloud.discoveryengine.v1beta.SolutionType] is
   * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH].
   * </pre>
   *
   * <code>repeated string oneway_synonyms_control_ids = 16;</code>
   *
   * @return A list containing the onewaySynonymsControlIds.
   */
  public com.google.protobuf.ProtocolStringList getOnewaySynonymsControlIdsList() {
    return onewaySynonymsControlIds_;
  }
  /**
   *
   *
   * <pre>
   * Condition oneway synonyms specifications. If multiple oneway synonyms
   * conditions match, all matching oneway synonyms controls in the list
   * will execute. Maximum number of specifications is 100.
   *
   * Can only be set if
   * [SolutionType][google.cloud.discoveryengine.v1beta.SolutionType] is
   * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH].
   * </pre>
   *
   * <code>repeated string oneway_synonyms_control_ids = 16;</code>
   *
   * @return The count of onewaySynonymsControlIds.
   */
  public int getOnewaySynonymsControlIdsCount() {
    return onewaySynonymsControlIds_.size();
  }
  /**
   *
   *
   * <pre>
   * Condition oneway synonyms specifications. If multiple oneway synonyms
   * conditions match, all matching oneway synonyms controls in the list
   * will execute. Maximum number of specifications is 100.
   *
   * Can only be set if
   * [SolutionType][google.cloud.discoveryengine.v1beta.SolutionType] is
   * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH].
   * </pre>
   *
   * <code>repeated string oneway_synonyms_control_ids = 16;</code>
   *
   * @param index The index of the element to return.
   * @return The onewaySynonymsControlIds at the given index.
   */
  public java.lang.String getOnewaySynonymsControlIds(int index) {
    return onewaySynonymsControlIds_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Condition oneway synonyms specifications. If multiple oneway synonyms
   * conditions match, all matching oneway synonyms controls in the list
   * will execute. Maximum number of specifications is 100.
   *
   * Can only be set if
   * [SolutionType][google.cloud.discoveryengine.v1beta.SolutionType] is
   * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH].
   * </pre>
   *
   * <code>repeated string oneway_synonyms_control_ids = 16;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the onewaySynonymsControlIds at the given index.
   */
  public com.google.protobuf.ByteString getOnewaySynonymsControlIdsBytes(int index) {
    return onewaySynonymsControlIds_.getByteString(index);
  }

  public static final int DISSOCIATE_CONTROL_IDS_FIELD_NUMBER = 17;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList dissociateControlIds_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Condition do not associate specifications. If multiple do not
   * associate conditions match, all matching do not associate controls in
   * the list will execute.
   * Order does not matter.
   * Maximum number of specifications is 100.
   *
   * Can only be set if
   * [SolutionType][google.cloud.discoveryengine.v1beta.SolutionType] is
   * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH].
   * </pre>
   *
   * <code>repeated string dissociate_control_ids = 17;</code>
   *
   * @return A list containing the dissociateControlIds.
   */
  public com.google.protobuf.ProtocolStringList getDissociateControlIdsList() {
    return dissociateControlIds_;
  }
  /**
   *
   *
   * <pre>
   * Condition do not associate specifications. If multiple do not
   * associate conditions match, all matching do not associate controls in
   * the list will execute.
   * Order does not matter.
   * Maximum number of specifications is 100.
   *
   * Can only be set if
   * [SolutionType][google.cloud.discoveryengine.v1beta.SolutionType] is
   * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH].
   * </pre>
   *
   * <code>repeated string dissociate_control_ids = 17;</code>
   *
   * @return The count of dissociateControlIds.
   */
  public int getDissociateControlIdsCount() {
    return dissociateControlIds_.size();
  }
  /**
   *
   *
   * <pre>
   * Condition do not associate specifications. If multiple do not
   * associate conditions match, all matching do not associate controls in
   * the list will execute.
   * Order does not matter.
   * Maximum number of specifications is 100.
   *
   * Can only be set if
   * [SolutionType][google.cloud.discoveryengine.v1beta.SolutionType] is
   * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH].
   * </pre>
   *
   * <code>repeated string dissociate_control_ids = 17;</code>
   *
   * @param index The index of the element to return.
   * @return The dissociateControlIds at the given index.
   */
  public java.lang.String getDissociateControlIds(int index) {
    return dissociateControlIds_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Condition do not associate specifications. If multiple do not
   * associate conditions match, all matching do not associate controls in
   * the list will execute.
   * Order does not matter.
   * Maximum number of specifications is 100.
   *
   * Can only be set if
   * [SolutionType][google.cloud.discoveryengine.v1beta.SolutionType] is
   * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH].
   * </pre>
   *
   * <code>repeated string dissociate_control_ids = 17;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the dissociateControlIds at the given index.
   */
  public com.google.protobuf.ByteString getDissociateControlIdsBytes(int index) {
    return dissociateControlIds_.getByteString(index);
  }

  public static final int REPLACEMENT_CONTROL_IDS_FIELD_NUMBER = 18;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList replacementControlIds_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Condition replacement specifications.
   * Applied according to the order in the list.
   * A previously replaced term can not be re-replaced.
   * Maximum number of specifications is 100.
   *
   * Can only be set if
   * [SolutionType][google.cloud.discoveryengine.v1beta.SolutionType] is
   * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH].
   * </pre>
   *
   * <code>repeated string replacement_control_ids = 18;</code>
   *
   * @return A list containing the replacementControlIds.
   */
  public com.google.protobuf.ProtocolStringList getReplacementControlIdsList() {
    return replacementControlIds_;
  }
  /**
   *
   *
   * <pre>
   * Condition replacement specifications.
   * Applied according to the order in the list.
   * A previously replaced term can not be re-replaced.
   * Maximum number of specifications is 100.
   *
   * Can only be set if
   * [SolutionType][google.cloud.discoveryengine.v1beta.SolutionType] is
   * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH].
   * </pre>
   *
   * <code>repeated string replacement_control_ids = 18;</code>
   *
   * @return The count of replacementControlIds.
   */
  public int getReplacementControlIdsCount() {
    return replacementControlIds_.size();
  }
  /**
   *
   *
   * <pre>
   * Condition replacement specifications.
   * Applied according to the order in the list.
   * A previously replaced term can not be re-replaced.
   * Maximum number of specifications is 100.
   *
   * Can only be set if
   * [SolutionType][google.cloud.discoveryengine.v1beta.SolutionType] is
   * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH].
   * </pre>
   *
   * <code>repeated string replacement_control_ids = 18;</code>
   *
   * @param index The index of the element to return.
   * @return The replacementControlIds at the given index.
   */
  public java.lang.String getReplacementControlIds(int index) {
    return replacementControlIds_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Condition replacement specifications.
   * Applied according to the order in the list.
   * A previously replaced term can not be re-replaced.
   * Maximum number of specifications is 100.
   *
   * Can only be set if
   * [SolutionType][google.cloud.discoveryengine.v1beta.SolutionType] is
   * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH].
   * </pre>
   *
   * <code>repeated string replacement_control_ids = 18;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the replacementControlIds at the given index.
   */
  public com.google.protobuf.ByteString getReplacementControlIdsBytes(int index) {
    return replacementControlIds_.getByteString(index);
  }

  public static final int IGNORE_CONTROL_IDS_FIELD_NUMBER = 19;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList ignoreControlIds_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Condition ignore specifications. If multiple ignore
   * conditions match, all matching ignore controls in the list will
   * execute.
   * Order does not matter.
   * Maximum number of specifications is 100.
   * </pre>
   *
   * <code>repeated string ignore_control_ids = 19;</code>
   *
   * @return A list containing the ignoreControlIds.
   */
  public com.google.protobuf.ProtocolStringList getIgnoreControlIdsList() {
    return ignoreControlIds_;
  }
  /**
   *
   *
   * <pre>
   * Condition ignore specifications. If multiple ignore
   * conditions match, all matching ignore controls in the list will
   * execute.
   * Order does not matter.
   * Maximum number of specifications is 100.
   * </pre>
   *
   * <code>repeated string ignore_control_ids = 19;</code>
   *
   * @return The count of ignoreControlIds.
   */
  public int getIgnoreControlIdsCount() {
    return ignoreControlIds_.size();
  }
  /**
   *
   *
   * <pre>
   * Condition ignore specifications. If multiple ignore
   * conditions match, all matching ignore controls in the list will
   * execute.
   * Order does not matter.
   * Maximum number of specifications is 100.
   * </pre>
   *
   * <code>repeated string ignore_control_ids = 19;</code>
   *
   * @param index The index of the element to return.
   * @return The ignoreControlIds at the given index.
   */
  public java.lang.String getIgnoreControlIds(int index) {
    return ignoreControlIds_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Condition ignore specifications. If multiple ignore
   * conditions match, all matching ignore controls in the list will
   * execute.
   * Order does not matter.
   * Maximum number of specifications is 100.
   * </pre>
   *
   * <code>repeated string ignore_control_ids = 19;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the ignoreControlIds at the given index.
   */
  public com.google.protobuf.ByteString getIgnoreControlIdsBytes(int index) {
    return ignoreControlIds_.getByteString(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, displayName_);
    }
    if (solutionType_
        != com.google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(3, solutionType_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(modelId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, modelId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(diversityLevel_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, diversityLevel_);
    }
    if (verticalConfigCase_ == 7) {
      output.writeMessage(
          7, (com.google.cloud.discoveryengine.v1beta.ServingConfig.MediaConfig) verticalConfig_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(8, getCreateTime());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(9, getUpdateTime());
    }
    if (verticalConfigCase_ == 10) {
      output.writeMessage(
          10,
          (com.google.cloud.discoveryengine.v1beta.ServingConfig.GenericConfig) verticalConfig_);
    }
    for (int i = 0; i < filterControlIds_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 11, filterControlIds_.getRaw(i));
    }
    for (int i = 0; i < boostControlIds_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 12, boostControlIds_.getRaw(i));
    }
    for (int i = 0; i < redirectControlIds_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 14, redirectControlIds_.getRaw(i));
    }
    for (int i = 0; i < synonymsControlIds_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 15, synonymsControlIds_.getRaw(i));
    }
    for (int i = 0; i < onewaySynonymsControlIds_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 16, onewaySynonymsControlIds_.getRaw(i));
    }
    for (int i = 0; i < dissociateControlIds_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 17, dissociateControlIds_.getRaw(i));
    }
    for (int i = 0; i < replacementControlIds_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 18, replacementControlIds_.getRaw(i));
    }
    for (int i = 0; i < ignoreControlIds_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 19, ignoreControlIds_.getRaw(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(20, getEmbeddingConfig());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(rankingExpression_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 21, rankingExpression_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, displayName_);
    }
    if (solutionType_
        != com.google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, solutionType_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(modelId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, modelId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(diversityLevel_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, diversityLevel_);
    }
    if (verticalConfigCase_ == 7) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              7,
              (com.google.cloud.discoveryengine.v1beta.ServingConfig.MediaConfig) verticalConfig_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getCreateTime());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getUpdateTime());
    }
    if (verticalConfigCase_ == 10) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              10,
              (com.google.cloud.discoveryengine.v1beta.ServingConfig.GenericConfig)
                  verticalConfig_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < filterControlIds_.size(); i++) {
        dataSize += computeStringSizeNoTag(filterControlIds_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getFilterControlIdsList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < boostControlIds_.size(); i++) {
        dataSize += computeStringSizeNoTag(boostControlIds_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getBoostControlIdsList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < redirectControlIds_.size(); i++) {
        dataSize += computeStringSizeNoTag(redirectControlIds_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getRedirectControlIdsList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < synonymsControlIds_.size(); i++) {
        dataSize += computeStringSizeNoTag(synonymsControlIds_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getSynonymsControlIdsList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < onewaySynonymsControlIds_.size(); i++) {
        dataSize += computeStringSizeNoTag(onewaySynonymsControlIds_.getRaw(i));
      }
      size += dataSize;
      size += 2 * getOnewaySynonymsControlIdsList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < dissociateControlIds_.size(); i++) {
        dataSize += computeStringSizeNoTag(dissociateControlIds_.getRaw(i));
      }
      size += dataSize;
      size += 2 * getDissociateControlIdsList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < replacementControlIds_.size(); i++) {
        dataSize += computeStringSizeNoTag(replacementControlIds_.getRaw(i));
      }
      size += dataSize;
      size += 2 * getReplacementControlIdsList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < ignoreControlIds_.size(); i++) {
        dataSize += computeStringSizeNoTag(ignoreControlIds_.getRaw(i));
      }
      size += dataSize;
      size += 2 * getIgnoreControlIdsList().size();
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(20, getEmbeddingConfig());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(rankingExpression_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(21, rankingExpression_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.discoveryengine.v1beta.ServingConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.discoveryengine.v1beta.ServingConfig other =
        (com.google.cloud.discoveryengine.v1beta.ServingConfig) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (solutionType_ != other.solutionType_) return false;
    if (!getModelId().equals(other.getModelId())) return false;
    if (!getDiversityLevel().equals(other.getDiversityLevel())) return false;
    if (hasEmbeddingConfig() != other.hasEmbeddingConfig()) return false;
    if (hasEmbeddingConfig()) {
      if (!getEmbeddingConfig().equals(other.getEmbeddingConfig())) return false;
    }
    if (!getRankingExpression().equals(other.getRankingExpression())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (!getFilterControlIdsList().equals(other.getFilterControlIdsList())) return false;
    if (!getBoostControlIdsList().equals(other.getBoostControlIdsList())) return false;
    if (!getRedirectControlIdsList().equals(other.getRedirectControlIdsList())) return false;
    if (!getSynonymsControlIdsList().equals(other.getSynonymsControlIdsList())) return false;
    if (!getOnewaySynonymsControlIdsList().equals(other.getOnewaySynonymsControlIdsList()))
      return false;
    if (!getDissociateControlIdsList().equals(other.getDissociateControlIdsList())) return false;
    if (!getReplacementControlIdsList().equals(other.getReplacementControlIdsList())) return false;
    if (!getIgnoreControlIdsList().equals(other.getIgnoreControlIdsList())) return false;
    if (!getVerticalConfigCase().equals(other.getVerticalConfigCase())) return false;
    switch (verticalConfigCase_) {
      case 7:
        if (!getMediaConfig().equals(other.getMediaConfig())) return false;
        break;
      case 10:
        if (!getGenericConfig().equals(other.getGenericConfig())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    hash = (37 * hash) + SOLUTION_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + solutionType_;
    hash = (37 * hash) + MODEL_ID_FIELD_NUMBER;
    hash = (53 * hash) + getModelId().hashCode();
    hash = (37 * hash) + DIVERSITY_LEVEL_FIELD_NUMBER;
    hash = (53 * hash) + getDiversityLevel().hashCode();
    if (hasEmbeddingConfig()) {
      hash = (37 * hash) + EMBEDDING_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getEmbeddingConfig().hashCode();
    }
    hash = (37 * hash) + RANKING_EXPRESSION_FIELD_NUMBER;
    hash = (53 * hash) + getRankingExpression().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    if (getFilterControlIdsCount() > 0) {
      hash = (37 * hash) + FILTER_CONTROL_IDS_FIELD_NUMBER;
      hash = (53 * hash) + getFilterControlIdsList().hashCode();
    }
    if (getBoostControlIdsCount() > 0) {
      hash = (37 * hash) + BOOST_CONTROL_IDS_FIELD_NUMBER;
      hash = (53 * hash) + getBoostControlIdsList().hashCode();
    }
    if (getRedirectControlIdsCount() > 0) {
      hash = (37 * hash) + REDIRECT_CONTROL_IDS_FIELD_NUMBER;
      hash = (53 * hash) + getRedirectControlIdsList().hashCode();
    }
    if (getSynonymsControlIdsCount() > 0) {
      hash = (37 * hash) + SYNONYMS_CONTROL_IDS_FIELD_NUMBER;
      hash = (53 * hash) + getSynonymsControlIdsList().hashCode();
    }
    if (getOnewaySynonymsControlIdsCount() > 0) {
      hash = (37 * hash) + ONEWAY_SYNONYMS_CONTROL_IDS_FIELD_NUMBER;
      hash = (53 * hash) + getOnewaySynonymsControlIdsList().hashCode();
    }
    if (getDissociateControlIdsCount() > 0) {
      hash = (37 * hash) + DISSOCIATE_CONTROL_IDS_FIELD_NUMBER;
      hash = (53 * hash) + getDissociateControlIdsList().hashCode();
    }
    if (getReplacementControlIdsCount() > 0) {
      hash = (37 * hash) + REPLACEMENT_CONTROL_IDS_FIELD_NUMBER;
      hash = (53 * hash) + getReplacementControlIdsList().hashCode();
    }
    if (getIgnoreControlIdsCount() > 0) {
      hash = (37 * hash) + IGNORE_CONTROL_IDS_FIELD_NUMBER;
      hash = (53 * hash) + getIgnoreControlIdsList().hashCode();
    }
    switch (verticalConfigCase_) {
      case 7:
        hash = (37 * hash) + MEDIA_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getMediaConfig().hashCode();
        break;
      case 10:
        hash = (37 * hash) + GENERIC_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getGenericConfig().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.discoveryengine.v1beta.ServingConfig parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1beta.ServingConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.ServingConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1beta.ServingConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.ServingConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1beta.ServingConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.ServingConfig parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1beta.ServingConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.ServingConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1beta.ServingConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.ServingConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1beta.ServingConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.discoveryengine.v1beta.ServingConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Configures metadata that is used to generate serving time results (e.g.
   * search results or recommendation predictions).
   * The ServingConfig is passed in the search and predict request and generates
   * results.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1beta.ServingConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.ServingConfig)
      com.google.cloud.discoveryengine.v1beta.ServingConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1beta.ServingConfigProto
          .internal_static_google_cloud_discoveryengine_v1beta_ServingConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1beta.ServingConfigProto
          .internal_static_google_cloud_discoveryengine_v1beta_ServingConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1beta.ServingConfig.class,
              com.google.cloud.discoveryengine.v1beta.ServingConfig.Builder.class);
    }

    // Construct using com.google.cloud.discoveryengine.v1beta.ServingConfig.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getEmbeddingConfigFieldBuilder();
        getCreateTimeFieldBuilder();
        getUpdateTimeFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (mediaConfigBuilder_ != null) {
        mediaConfigBuilder_.clear();
      }
      if (genericConfigBuilder_ != null) {
        genericConfigBuilder_.clear();
      }
      name_ = "";
      displayName_ = "";
      solutionType_ = 0;
      modelId_ = "";
      diversityLevel_ = "";
      embeddingConfig_ = null;
      if (embeddingConfigBuilder_ != null) {
        embeddingConfigBuilder_.dispose();
        embeddingConfigBuilder_ = null;
      }
      rankingExpression_ = "";
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      filterControlIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
      boostControlIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
      redirectControlIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
      synonymsControlIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
      onewaySynonymsControlIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
      dissociateControlIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
      replacementControlIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
      ignoreControlIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
      verticalConfigCase_ = 0;
      verticalConfig_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.discoveryengine.v1beta.ServingConfigProto
          .internal_static_google_cloud_discoveryengine_v1beta_ServingConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.ServingConfig getDefaultInstanceForType() {
      return com.google.cloud.discoveryengine.v1beta.ServingConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.ServingConfig build() {
      com.google.cloud.discoveryengine.v1beta.ServingConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.ServingConfig buildPartial() {
      com.google.cloud.discoveryengine.v1beta.ServingConfig result =
          new com.google.cloud.discoveryengine.v1beta.ServingConfig(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.discoveryengine.v1beta.ServingConfig result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.displayName_ = displayName_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.solutionType_ = solutionType_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.modelId_ = modelId_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.diversityLevel_ = diversityLevel_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.embeddingConfig_ =
            embeddingConfigBuilder_ == null ? embeddingConfig_ : embeddingConfigBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.rankingExpression_ = rankingExpression_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        filterControlIds_.makeImmutable();
        result.filterControlIds_ = filterControlIds_;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        boostControlIds_.makeImmutable();
        result.boostControlIds_ = boostControlIds_;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        redirectControlIds_.makeImmutable();
        result.redirectControlIds_ = redirectControlIds_;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        synonymsControlIds_.makeImmutable();
        result.synonymsControlIds_ = synonymsControlIds_;
      }
      if (((from_bitField0_ & 0x00008000) != 0)) {
        onewaySynonymsControlIds_.makeImmutable();
        result.onewaySynonymsControlIds_ = onewaySynonymsControlIds_;
      }
      if (((from_bitField0_ & 0x00010000) != 0)) {
        dissociateControlIds_.makeImmutable();
        result.dissociateControlIds_ = dissociateControlIds_;
      }
      if (((from_bitField0_ & 0x00020000) != 0)) {
        replacementControlIds_.makeImmutable();
        result.replacementControlIds_ = replacementControlIds_;
      }
      if (((from_bitField0_ & 0x00040000) != 0)) {
        ignoreControlIds_.makeImmutable();
        result.ignoreControlIds_ = ignoreControlIds_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.cloud.discoveryengine.v1beta.ServingConfig result) {
      result.verticalConfigCase_ = verticalConfigCase_;
      result.verticalConfig_ = this.verticalConfig_;
      if (verticalConfigCase_ == 7 && mediaConfigBuilder_ != null) {
        result.verticalConfig_ = mediaConfigBuilder_.build();
      }
      if (verticalConfigCase_ == 10 && genericConfigBuilder_ != null) {
        result.verticalConfig_ = genericConfigBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.discoveryengine.v1beta.ServingConfig) {
        return mergeFrom((com.google.cloud.discoveryengine.v1beta.ServingConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.discoveryengine.v1beta.ServingConfig other) {
      if (other == com.google.cloud.discoveryengine.v1beta.ServingConfig.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.solutionType_ != 0) {
        setSolutionTypeValue(other.getSolutionTypeValue());
      }
      if (!other.getModelId().isEmpty()) {
        modelId_ = other.modelId_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (!other.getDiversityLevel().isEmpty()) {
        diversityLevel_ = other.diversityLevel_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (other.hasEmbeddingConfig()) {
        mergeEmbeddingConfig(other.getEmbeddingConfig());
      }
      if (!other.getRankingExpression().isEmpty()) {
        rankingExpression_ = other.rankingExpression_;
        bitField0_ |= 0x00000100;
        onChanged();
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      if (!other.filterControlIds_.isEmpty()) {
        if (filterControlIds_.isEmpty()) {
          filterControlIds_ = other.filterControlIds_;
          bitField0_ |= 0x00000800;
        } else {
          ensureFilterControlIdsIsMutable();
          filterControlIds_.addAll(other.filterControlIds_);
        }
        onChanged();
      }
      if (!other.boostControlIds_.isEmpty()) {
        if (boostControlIds_.isEmpty()) {
          boostControlIds_ = other.boostControlIds_;
          bitField0_ |= 0x00001000;
        } else {
          ensureBoostControlIdsIsMutable();
          boostControlIds_.addAll(other.boostControlIds_);
        }
        onChanged();
      }
      if (!other.redirectControlIds_.isEmpty()) {
        if (redirectControlIds_.isEmpty()) {
          redirectControlIds_ = other.redirectControlIds_;
          bitField0_ |= 0x00002000;
        } else {
          ensureRedirectControlIdsIsMutable();
          redirectControlIds_.addAll(other.redirectControlIds_);
        }
        onChanged();
      }
      if (!other.synonymsControlIds_.isEmpty()) {
        if (synonymsControlIds_.isEmpty()) {
          synonymsControlIds_ = other.synonymsControlIds_;
          bitField0_ |= 0x00004000;
        } else {
          ensureSynonymsControlIdsIsMutable();
          synonymsControlIds_.addAll(other.synonymsControlIds_);
        }
        onChanged();
      }
      if (!other.onewaySynonymsControlIds_.isEmpty()) {
        if (onewaySynonymsControlIds_.isEmpty()) {
          onewaySynonymsControlIds_ = other.onewaySynonymsControlIds_;
          bitField0_ |= 0x00008000;
        } else {
          ensureOnewaySynonymsControlIdsIsMutable();
          onewaySynonymsControlIds_.addAll(other.onewaySynonymsControlIds_);
        }
        onChanged();
      }
      if (!other.dissociateControlIds_.isEmpty()) {
        if (dissociateControlIds_.isEmpty()) {
          dissociateControlIds_ = other.dissociateControlIds_;
          bitField0_ |= 0x00010000;
        } else {
          ensureDissociateControlIdsIsMutable();
          dissociateControlIds_.addAll(other.dissociateControlIds_);
        }
        onChanged();
      }
      if (!other.replacementControlIds_.isEmpty()) {
        if (replacementControlIds_.isEmpty()) {
          replacementControlIds_ = other.replacementControlIds_;
          bitField0_ |= 0x00020000;
        } else {
          ensureReplacementControlIdsIsMutable();
          replacementControlIds_.addAll(other.replacementControlIds_);
        }
        onChanged();
      }
      if (!other.ignoreControlIds_.isEmpty()) {
        if (ignoreControlIds_.isEmpty()) {
          ignoreControlIds_ = other.ignoreControlIds_;
          bitField0_ |= 0x00040000;
        } else {
          ensureIgnoreControlIdsIsMutable();
          ignoreControlIds_.addAll(other.ignoreControlIds_);
        }
        onChanged();
      }
      switch (other.getVerticalConfigCase()) {
        case MEDIA_CONFIG:
          {
            mergeMediaConfig(other.getMediaConfig());
            break;
          }
        case GENERIC_CONFIG:
          {
            mergeGenericConfig(other.getGenericConfig());
            break;
          }
        case VERTICALCONFIG_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 10
            case 18:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 18
            case 24:
              {
                solutionType_ = input.readEnum();
                bitField0_ |= 0x00000010;
                break;
              } // case 24
            case 34:
              {
                modelId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 34
            case 42:
              {
                diversityLevel_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 42
            case 58:
              {
                input.readMessage(getMediaConfigFieldBuilder().getBuilder(), extensionRegistry);
                verticalConfigCase_ = 7;
                break;
              } // case 58
            case 66:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000200;
                break;
              } // case 66
            case 74:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000400;
                break;
              } // case 74
            case 82:
              {
                input.readMessage(getGenericConfigFieldBuilder().getBuilder(), extensionRegistry);
                verticalConfigCase_ = 10;
                break;
              } // case 82
            case 90:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureFilterControlIdsIsMutable();
                filterControlIds_.add(s);
                break;
              } // case 90
            case 98:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureBoostControlIdsIsMutable();
                boostControlIds_.add(s);
                break;
              } // case 98
            case 114:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureRedirectControlIdsIsMutable();
                redirectControlIds_.add(s);
                break;
              } // case 114
            case 122:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureSynonymsControlIdsIsMutable();
                synonymsControlIds_.add(s);
                break;
              } // case 122
            case 130:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureOnewaySynonymsControlIdsIsMutable();
                onewaySynonymsControlIds_.add(s);
                break;
              } // case 130
            case 138:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureDissociateControlIdsIsMutable();
                dissociateControlIds_.add(s);
                break;
              } // case 138
            case 146:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureReplacementControlIdsIsMutable();
                replacementControlIds_.add(s);
                break;
              } // case 146
            case 154:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureIgnoreControlIdsIsMutable();
                ignoreControlIds_.add(s);
                break;
              } // case 154
            case 162:
              {
                input.readMessage(getEmbeddingConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 162
            case 170:
              {
                rankingExpression_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000100;
                break;
              } // case 170
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int verticalConfigCase_ = 0;
    private java.lang.Object verticalConfig_;

    public VerticalConfigCase getVerticalConfigCase() {
      return VerticalConfigCase.forNumber(verticalConfigCase_);
    }

    public Builder clearVerticalConfig() {
      verticalConfigCase_ = 0;
      verticalConfig_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1beta.ServingConfig.MediaConfig,
            com.google.cloud.discoveryengine.v1beta.ServingConfig.MediaConfig.Builder,
            com.google.cloud.discoveryengine.v1beta.ServingConfig.MediaConfigOrBuilder>
        mediaConfigBuilder_;
    /**
     *
     *
     * <pre>
     * The MediaConfig of the serving configuration.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.ServingConfig.MediaConfig media_config = 7;</code>
     *
     * @return Whether the mediaConfig field is set.
     */
    @java.lang.Override
    public boolean hasMediaConfig() {
      return verticalConfigCase_ == 7;
    }
    /**
     *
     *
     * <pre>
     * The MediaConfig of the serving configuration.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.ServingConfig.MediaConfig media_config = 7;</code>
     *
     * @return The mediaConfig.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.ServingConfig.MediaConfig getMediaConfig() {
      if (mediaConfigBuilder_ == null) {
        if (verticalConfigCase_ == 7) {
          return (com.google.cloud.discoveryengine.v1beta.ServingConfig.MediaConfig)
              verticalConfig_;
        }
        return com.google.cloud.discoveryengine.v1beta.ServingConfig.MediaConfig
            .getDefaultInstance();
      } else {
        if (verticalConfigCase_ == 7) {
          return mediaConfigBuilder_.getMessage();
        }
        return com.google.cloud.discoveryengine.v1beta.ServingConfig.MediaConfig
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The MediaConfig of the serving configuration.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.ServingConfig.MediaConfig media_config = 7;</code>
     */
    public Builder setMediaConfig(
        com.google.cloud.discoveryengine.v1beta.ServingConfig.MediaConfig value) {
      if (mediaConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        verticalConfig_ = value;
        onChanged();
      } else {
        mediaConfigBuilder_.setMessage(value);
      }
      verticalConfigCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The MediaConfig of the serving configuration.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.ServingConfig.MediaConfig media_config = 7;</code>
     */
    public Builder setMediaConfig(
        com.google.cloud.discoveryengine.v1beta.ServingConfig.MediaConfig.Builder builderForValue) {
      if (mediaConfigBuilder_ == null) {
        verticalConfig_ = builderForValue.build();
        onChanged();
      } else {
        mediaConfigBuilder_.setMessage(builderForValue.build());
      }
      verticalConfigCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The MediaConfig of the serving configuration.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.ServingConfig.MediaConfig media_config = 7;</code>
     */
    public Builder mergeMediaConfig(
        com.google.cloud.discoveryengine.v1beta.ServingConfig.MediaConfig value) {
      if (mediaConfigBuilder_ == null) {
        if (verticalConfigCase_ == 7
            && verticalConfig_
                != com.google.cloud.discoveryengine.v1beta.ServingConfig.MediaConfig
                    .getDefaultInstance()) {
          verticalConfig_ =
              com.google.cloud.discoveryengine.v1beta.ServingConfig.MediaConfig.newBuilder(
                      (com.google.cloud.discoveryengine.v1beta.ServingConfig.MediaConfig)
                          verticalConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          verticalConfig_ = value;
        }
        onChanged();
      } else {
        if (verticalConfigCase_ == 7) {
          mediaConfigBuilder_.mergeFrom(value);
        } else {
          mediaConfigBuilder_.setMessage(value);
        }
      }
      verticalConfigCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The MediaConfig of the serving configuration.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.ServingConfig.MediaConfig media_config = 7;</code>
     */
    public Builder clearMediaConfig() {
      if (mediaConfigBuilder_ == null) {
        if (verticalConfigCase_ == 7) {
          verticalConfigCase_ = 0;
          verticalConfig_ = null;
          onChanged();
        }
      } else {
        if (verticalConfigCase_ == 7) {
          verticalConfigCase_ = 0;
          verticalConfig_ = null;
        }
        mediaConfigBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The MediaConfig of the serving configuration.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.ServingConfig.MediaConfig media_config = 7;</code>
     */
    public com.google.cloud.discoveryengine.v1beta.ServingConfig.MediaConfig.Builder
        getMediaConfigBuilder() {
      return getMediaConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The MediaConfig of the serving configuration.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.ServingConfig.MediaConfig media_config = 7;</code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.ServingConfig.MediaConfigOrBuilder
        getMediaConfigOrBuilder() {
      if ((verticalConfigCase_ == 7) && (mediaConfigBuilder_ != null)) {
        return mediaConfigBuilder_.getMessageOrBuilder();
      } else {
        if (verticalConfigCase_ == 7) {
          return (com.google.cloud.discoveryengine.v1beta.ServingConfig.MediaConfig)
              verticalConfig_;
        }
        return com.google.cloud.discoveryengine.v1beta.ServingConfig.MediaConfig
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The MediaConfig of the serving configuration.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.ServingConfig.MediaConfig media_config = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1beta.ServingConfig.MediaConfig,
            com.google.cloud.discoveryengine.v1beta.ServingConfig.MediaConfig.Builder,
            com.google.cloud.discoveryengine.v1beta.ServingConfig.MediaConfigOrBuilder>
        getMediaConfigFieldBuilder() {
      if (mediaConfigBuilder_ == null) {
        if (!(verticalConfigCase_ == 7)) {
          verticalConfig_ =
              com.google.cloud.discoveryengine.v1beta.ServingConfig.MediaConfig
                  .getDefaultInstance();
        }
        mediaConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1beta.ServingConfig.MediaConfig,
                com.google.cloud.discoveryengine.v1beta.ServingConfig.MediaConfig.Builder,
                com.google.cloud.discoveryengine.v1beta.ServingConfig.MediaConfigOrBuilder>(
                (com.google.cloud.discoveryengine.v1beta.ServingConfig.MediaConfig) verticalConfig_,
                getParentForChildren(),
                isClean());
        verticalConfig_ = null;
      }
      verticalConfigCase_ = 7;
      onChanged();
      return mediaConfigBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1beta.ServingConfig.GenericConfig,
            com.google.cloud.discoveryengine.v1beta.ServingConfig.GenericConfig.Builder,
            com.google.cloud.discoveryengine.v1beta.ServingConfig.GenericConfigOrBuilder>
        genericConfigBuilder_;
    /**
     *
     *
     * <pre>
     * The GenericConfig of the serving configuration.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.ServingConfig.GenericConfig generic_config = 10;
     * </code>
     *
     * @return Whether the genericConfig field is set.
     */
    @java.lang.Override
    public boolean hasGenericConfig() {
      return verticalConfigCase_ == 10;
    }
    /**
     *
     *
     * <pre>
     * The GenericConfig of the serving configuration.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.ServingConfig.GenericConfig generic_config = 10;
     * </code>
     *
     * @return The genericConfig.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.ServingConfig.GenericConfig getGenericConfig() {
      if (genericConfigBuilder_ == null) {
        if (verticalConfigCase_ == 10) {
          return (com.google.cloud.discoveryengine.v1beta.ServingConfig.GenericConfig)
              verticalConfig_;
        }
        return com.google.cloud.discoveryengine.v1beta.ServingConfig.GenericConfig
            .getDefaultInstance();
      } else {
        if (verticalConfigCase_ == 10) {
          return genericConfigBuilder_.getMessage();
        }
        return com.google.cloud.discoveryengine.v1beta.ServingConfig.GenericConfig
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The GenericConfig of the serving configuration.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.ServingConfig.GenericConfig generic_config = 10;
     * </code>
     */
    public Builder setGenericConfig(
        com.google.cloud.discoveryengine.v1beta.ServingConfig.GenericConfig value) {
      if (genericConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        verticalConfig_ = value;
        onChanged();
      } else {
        genericConfigBuilder_.setMessage(value);
      }
      verticalConfigCase_ = 10;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The GenericConfig of the serving configuration.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.ServingConfig.GenericConfig generic_config = 10;
     * </code>
     */
    public Builder setGenericConfig(
        com.google.cloud.discoveryengine.v1beta.ServingConfig.GenericConfig.Builder
            builderForValue) {
      if (genericConfigBuilder_ == null) {
        verticalConfig_ = builderForValue.build();
        onChanged();
      } else {
        genericConfigBuilder_.setMessage(builderForValue.build());
      }
      verticalConfigCase_ = 10;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The GenericConfig of the serving configuration.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.ServingConfig.GenericConfig generic_config = 10;
     * </code>
     */
    public Builder mergeGenericConfig(
        com.google.cloud.discoveryengine.v1beta.ServingConfig.GenericConfig value) {
      if (genericConfigBuilder_ == null) {
        if (verticalConfigCase_ == 10
            && verticalConfig_
                != com.google.cloud.discoveryengine.v1beta.ServingConfig.GenericConfig
                    .getDefaultInstance()) {
          verticalConfig_ =
              com.google.cloud.discoveryengine.v1beta.ServingConfig.GenericConfig.newBuilder(
                      (com.google.cloud.discoveryengine.v1beta.ServingConfig.GenericConfig)
                          verticalConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          verticalConfig_ = value;
        }
        onChanged();
      } else {
        if (verticalConfigCase_ == 10) {
          genericConfigBuilder_.mergeFrom(value);
        } else {
          genericConfigBuilder_.setMessage(value);
        }
      }
      verticalConfigCase_ = 10;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The GenericConfig of the serving configuration.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.ServingConfig.GenericConfig generic_config = 10;
     * </code>
     */
    public Builder clearGenericConfig() {
      if (genericConfigBuilder_ == null) {
        if (verticalConfigCase_ == 10) {
          verticalConfigCase_ = 0;
          verticalConfig_ = null;
          onChanged();
        }
      } else {
        if (verticalConfigCase_ == 10) {
          verticalConfigCase_ = 0;
          verticalConfig_ = null;
        }
        genericConfigBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The GenericConfig of the serving configuration.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.ServingConfig.GenericConfig generic_config = 10;
     * </code>
     */
    public com.google.cloud.discoveryengine.v1beta.ServingConfig.GenericConfig.Builder
        getGenericConfigBuilder() {
      return getGenericConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The GenericConfig of the serving configuration.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.ServingConfig.GenericConfig generic_config = 10;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.ServingConfig.GenericConfigOrBuilder
        getGenericConfigOrBuilder() {
      if ((verticalConfigCase_ == 10) && (genericConfigBuilder_ != null)) {
        return genericConfigBuilder_.getMessageOrBuilder();
      } else {
        if (verticalConfigCase_ == 10) {
          return (com.google.cloud.discoveryengine.v1beta.ServingConfig.GenericConfig)
              verticalConfig_;
        }
        return com.google.cloud.discoveryengine.v1beta.ServingConfig.GenericConfig
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The GenericConfig of the serving configuration.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.ServingConfig.GenericConfig generic_config = 10;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1beta.ServingConfig.GenericConfig,
            com.google.cloud.discoveryengine.v1beta.ServingConfig.GenericConfig.Builder,
            com.google.cloud.discoveryengine.v1beta.ServingConfig.GenericConfigOrBuilder>
        getGenericConfigFieldBuilder() {
      if (genericConfigBuilder_ == null) {
        if (!(verticalConfigCase_ == 10)) {
          verticalConfig_ =
              com.google.cloud.discoveryengine.v1beta.ServingConfig.GenericConfig
                  .getDefaultInstance();
        }
        genericConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1beta.ServingConfig.GenericConfig,
                com.google.cloud.discoveryengine.v1beta.ServingConfig.GenericConfig.Builder,
                com.google.cloud.discoveryengine.v1beta.ServingConfig.GenericConfigOrBuilder>(
                (com.google.cloud.discoveryengine.v1beta.ServingConfig.GenericConfig)
                    verticalConfig_,
                getParentForChildren(),
                isClean());
        verticalConfig_ = null;
      }
      verticalConfigCase_ = 10;
      onChanged();
      return genericConfigBuilder_;
    }

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Immutable. Fully qualified name
     * `projects/{project}/locations/{location}/collections/{collection_id}/engines/{engine_id}/servingConfigs/{serving_config_id}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. Fully qualified name
     * `projects/{project}/locations/{location}/collections/{collection_id}/engines/{engine_id}/servingConfigs/{serving_config_id}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. Fully qualified name
     * `projects/{project}/locations/{location}/collections/{collection_id}/engines/{engine_id}/servingConfigs/{serving_config_id}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. Fully qualified name
     * `projects/{project}/locations/{location}/collections/{collection_id}/engines/{engine_id}/servingConfigs/{serving_config_id}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. Fully qualified name
     * `projects/{project}/locations/{location}/collections/{collection_id}/engines/{engine_id}/servingConfigs/{serving_config_id}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * Required. The human readable serving config display name. Used in Discovery
     * UI.
     *
     * This field must be a UTF-8 encoded string with a length limit of 128
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The human readable serving config display name. Used in Discovery
     * UI.
     *
     * This field must be a UTF-8 encoded string with a length limit of 128
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The human readable serving config display name. Used in Discovery
     * UI.
     *
     * This field must be a UTF-8 encoded string with a length limit of 128
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The human readable serving config display name. Used in Discovery
     * UI.
     *
     * This field must be a UTF-8 encoded string with a length limit of 128
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The human readable serving config display name. Used in Discovery
     * UI.
     *
     * This field must be a UTF-8 encoded string with a length limit of 128
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private int solutionType_ = 0;
    /**
     *
     *
     * <pre>
     * Required. Immutable. Specifies the solution type that a serving config can
     * be associated with.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.SolutionType solution_type = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The enum numeric value on the wire for solutionType.
     */
    @java.lang.Override
    public int getSolutionTypeValue() {
      return solutionType_;
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. Specifies the solution type that a serving config can
     * be associated with.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.SolutionType solution_type = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param value The enum numeric value on the wire for solutionType to set.
     * @return This builder for chaining.
     */
    public Builder setSolutionTypeValue(int value) {
      solutionType_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. Specifies the solution type that a serving config can
     * be associated with.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.SolutionType solution_type = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The solutionType.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.SolutionType getSolutionType() {
      com.google.cloud.discoveryengine.v1beta.SolutionType result =
          com.google.cloud.discoveryengine.v1beta.SolutionType.forNumber(solutionType_);
      return result == null
          ? com.google.cloud.discoveryengine.v1beta.SolutionType.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. Specifies the solution type that a serving config can
     * be associated with.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.SolutionType solution_type = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param value The solutionType to set.
     * @return This builder for chaining.
     */
    public Builder setSolutionType(com.google.cloud.discoveryengine.v1beta.SolutionType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000010;
      solutionType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. Specifies the solution type that a serving config can
     * be associated with.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.SolutionType solution_type = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSolutionType() {
      bitField0_ = (bitField0_ & ~0x00000010);
      solutionType_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object modelId_ = "";
    /**
     *
     *
     * <pre>
     * The id of the model to use at serving time.
     * Currently only RecommendationModels are supported.
     * Can be changed but only to a compatible model (e.g.
     * others-you-may-like CTR to others-you-may-like CVR).
     *
     * Required when
     * [SolutionType][google.cloud.discoveryengine.v1beta.SolutionType] is
     * [SOLUTION_TYPE_RECOMMENDATION][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_RECOMMENDATION].
     * </pre>
     *
     * <code>string model_id = 4;</code>
     *
     * @return The modelId.
     */
    public java.lang.String getModelId() {
      java.lang.Object ref = modelId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        modelId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The id of the model to use at serving time.
     * Currently only RecommendationModels are supported.
     * Can be changed but only to a compatible model (e.g.
     * others-you-may-like CTR to others-you-may-like CVR).
     *
     * Required when
     * [SolutionType][google.cloud.discoveryengine.v1beta.SolutionType] is
     * [SOLUTION_TYPE_RECOMMENDATION][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_RECOMMENDATION].
     * </pre>
     *
     * <code>string model_id = 4;</code>
     *
     * @return The bytes for modelId.
     */
    public com.google.protobuf.ByteString getModelIdBytes() {
      java.lang.Object ref = modelId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        modelId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The id of the model to use at serving time.
     * Currently only RecommendationModels are supported.
     * Can be changed but only to a compatible model (e.g.
     * others-you-may-like CTR to others-you-may-like CVR).
     *
     * Required when
     * [SolutionType][google.cloud.discoveryengine.v1beta.SolutionType] is
     * [SOLUTION_TYPE_RECOMMENDATION][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_RECOMMENDATION].
     * </pre>
     *
     * <code>string model_id = 4;</code>
     *
     * @param value The modelId to set.
     * @return This builder for chaining.
     */
    public Builder setModelId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      modelId_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The id of the model to use at serving time.
     * Currently only RecommendationModels are supported.
     * Can be changed but only to a compatible model (e.g.
     * others-you-may-like CTR to others-you-may-like CVR).
     *
     * Required when
     * [SolutionType][google.cloud.discoveryengine.v1beta.SolutionType] is
     * [SOLUTION_TYPE_RECOMMENDATION][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_RECOMMENDATION].
     * </pre>
     *
     * <code>string model_id = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearModelId() {
      modelId_ = getDefaultInstance().getModelId();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The id of the model to use at serving time.
     * Currently only RecommendationModels are supported.
     * Can be changed but only to a compatible model (e.g.
     * others-you-may-like CTR to others-you-may-like CVR).
     *
     * Required when
     * [SolutionType][google.cloud.discoveryengine.v1beta.SolutionType] is
     * [SOLUTION_TYPE_RECOMMENDATION][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_RECOMMENDATION].
     * </pre>
     *
     * <code>string model_id = 4;</code>
     *
     * @param value The bytes for modelId to set.
     * @return This builder for chaining.
     */
    public Builder setModelIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      modelId_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private java.lang.Object diversityLevel_ = "";
    /**
     *
     *
     * <pre>
     * How much diversity to use in recommendation model results e.g.
     * `medium-diversity` or `high-diversity`. Currently supported values:
     *
     * * `no-diversity`
     * * `low-diversity`
     * * `medium-diversity`
     * * `high-diversity`
     * * `auto-diversity`
     *
     * If not specified, we choose default based on recommendation model
     * type. Default value: `no-diversity`.
     *
     * Can only be set if
     * [SolutionType][google.cloud.discoveryengine.v1beta.SolutionType] is
     * [SOLUTION_TYPE_RECOMMENDATION][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_RECOMMENDATION].
     * </pre>
     *
     * <code>string diversity_level = 5;</code>
     *
     * @return The diversityLevel.
     */
    public java.lang.String getDiversityLevel() {
      java.lang.Object ref = diversityLevel_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        diversityLevel_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * How much diversity to use in recommendation model results e.g.
     * `medium-diversity` or `high-diversity`. Currently supported values:
     *
     * * `no-diversity`
     * * `low-diversity`
     * * `medium-diversity`
     * * `high-diversity`
     * * `auto-diversity`
     *
     * If not specified, we choose default based on recommendation model
     * type. Default value: `no-diversity`.
     *
     * Can only be set if
     * [SolutionType][google.cloud.discoveryengine.v1beta.SolutionType] is
     * [SOLUTION_TYPE_RECOMMENDATION][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_RECOMMENDATION].
     * </pre>
     *
     * <code>string diversity_level = 5;</code>
     *
     * @return The bytes for diversityLevel.
     */
    public com.google.protobuf.ByteString getDiversityLevelBytes() {
      java.lang.Object ref = diversityLevel_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        diversityLevel_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * How much diversity to use in recommendation model results e.g.
     * `medium-diversity` or `high-diversity`. Currently supported values:
     *
     * * `no-diversity`
     * * `low-diversity`
     * * `medium-diversity`
     * * `high-diversity`
     * * `auto-diversity`
     *
     * If not specified, we choose default based on recommendation model
     * type. Default value: `no-diversity`.
     *
     * Can only be set if
     * [SolutionType][google.cloud.discoveryengine.v1beta.SolutionType] is
     * [SOLUTION_TYPE_RECOMMENDATION][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_RECOMMENDATION].
     * </pre>
     *
     * <code>string diversity_level = 5;</code>
     *
     * @param value The diversityLevel to set.
     * @return This builder for chaining.
     */
    public Builder setDiversityLevel(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      diversityLevel_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * How much diversity to use in recommendation model results e.g.
     * `medium-diversity` or `high-diversity`. Currently supported values:
     *
     * * `no-diversity`
     * * `low-diversity`
     * * `medium-diversity`
     * * `high-diversity`
     * * `auto-diversity`
     *
     * If not specified, we choose default based on recommendation model
     * type. Default value: `no-diversity`.
     *
     * Can only be set if
     * [SolutionType][google.cloud.discoveryengine.v1beta.SolutionType] is
     * [SOLUTION_TYPE_RECOMMENDATION][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_RECOMMENDATION].
     * </pre>
     *
     * <code>string diversity_level = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDiversityLevel() {
      diversityLevel_ = getDefaultInstance().getDiversityLevel();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * How much diversity to use in recommendation model results e.g.
     * `medium-diversity` or `high-diversity`. Currently supported values:
     *
     * * `no-diversity`
     * * `low-diversity`
     * * `medium-diversity`
     * * `high-diversity`
     * * `auto-diversity`
     *
     * If not specified, we choose default based on recommendation model
     * type. Default value: `no-diversity`.
     *
     * Can only be set if
     * [SolutionType][google.cloud.discoveryengine.v1beta.SolutionType] is
     * [SOLUTION_TYPE_RECOMMENDATION][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_RECOMMENDATION].
     * </pre>
     *
     * <code>string diversity_level = 5;</code>
     *
     * @param value The bytes for diversityLevel to set.
     * @return This builder for chaining.
     */
    public Builder setDiversityLevelBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      diversityLevel_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private com.google.cloud.discoveryengine.v1beta.EmbeddingConfig embeddingConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1beta.EmbeddingConfig,
            com.google.cloud.discoveryengine.v1beta.EmbeddingConfig.Builder,
            com.google.cloud.discoveryengine.v1beta.EmbeddingConfigOrBuilder>
        embeddingConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Bring your own embedding config. The config is used for search semantic
     * retrieval. The retrieval is based on the dot product of
     * [SearchRequest.EmbeddingSpec.EmbeddingVector.vector][google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.EmbeddingVector.vector]
     * and the document embeddings that are provided by this EmbeddingConfig. If
     * [SearchRequest.EmbeddingSpec.EmbeddingVector.vector][google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.EmbeddingVector.vector]
     * is provided, it overrides this
     * [ServingConfig.embedding_config][google.cloud.discoveryengine.v1beta.ServingConfig.embedding_config].
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.EmbeddingConfig embedding_config = 20;</code>
     *
     * @return Whether the embeddingConfig field is set.
     */
    public boolean hasEmbeddingConfig() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * Bring your own embedding config. The config is used for search semantic
     * retrieval. The retrieval is based on the dot product of
     * [SearchRequest.EmbeddingSpec.EmbeddingVector.vector][google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.EmbeddingVector.vector]
     * and the document embeddings that are provided by this EmbeddingConfig. If
     * [SearchRequest.EmbeddingSpec.EmbeddingVector.vector][google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.EmbeddingVector.vector]
     * is provided, it overrides this
     * [ServingConfig.embedding_config][google.cloud.discoveryengine.v1beta.ServingConfig.embedding_config].
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.EmbeddingConfig embedding_config = 20;</code>
     *
     * @return The embeddingConfig.
     */
    public com.google.cloud.discoveryengine.v1beta.EmbeddingConfig getEmbeddingConfig() {
      if (embeddingConfigBuilder_ == null) {
        return embeddingConfig_ == null
            ? com.google.cloud.discoveryengine.v1beta.EmbeddingConfig.getDefaultInstance()
            : embeddingConfig_;
      } else {
        return embeddingConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Bring your own embedding config. The config is used for search semantic
     * retrieval. The retrieval is based on the dot product of
     * [SearchRequest.EmbeddingSpec.EmbeddingVector.vector][google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.EmbeddingVector.vector]
     * and the document embeddings that are provided by this EmbeddingConfig. If
     * [SearchRequest.EmbeddingSpec.EmbeddingVector.vector][google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.EmbeddingVector.vector]
     * is provided, it overrides this
     * [ServingConfig.embedding_config][google.cloud.discoveryengine.v1beta.ServingConfig.embedding_config].
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.EmbeddingConfig embedding_config = 20;</code>
     */
    public Builder setEmbeddingConfig(
        com.google.cloud.discoveryengine.v1beta.EmbeddingConfig value) {
      if (embeddingConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        embeddingConfig_ = value;
      } else {
        embeddingConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Bring your own embedding config. The config is used for search semantic
     * retrieval. The retrieval is based on the dot product of
     * [SearchRequest.EmbeddingSpec.EmbeddingVector.vector][google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.EmbeddingVector.vector]
     * and the document embeddings that are provided by this EmbeddingConfig. If
     * [SearchRequest.EmbeddingSpec.EmbeddingVector.vector][google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.EmbeddingVector.vector]
     * is provided, it overrides this
     * [ServingConfig.embedding_config][google.cloud.discoveryengine.v1beta.ServingConfig.embedding_config].
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.EmbeddingConfig embedding_config = 20;</code>
     */
    public Builder setEmbeddingConfig(
        com.google.cloud.discoveryengine.v1beta.EmbeddingConfig.Builder builderForValue) {
      if (embeddingConfigBuilder_ == null) {
        embeddingConfig_ = builderForValue.build();
      } else {
        embeddingConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Bring your own embedding config. The config is used for search semantic
     * retrieval. The retrieval is based on the dot product of
     * [SearchRequest.EmbeddingSpec.EmbeddingVector.vector][google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.EmbeddingVector.vector]
     * and the document embeddings that are provided by this EmbeddingConfig. If
     * [SearchRequest.EmbeddingSpec.EmbeddingVector.vector][google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.EmbeddingVector.vector]
     * is provided, it overrides this
     * [ServingConfig.embedding_config][google.cloud.discoveryengine.v1beta.ServingConfig.embedding_config].
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.EmbeddingConfig embedding_config = 20;</code>
     */
    public Builder mergeEmbeddingConfig(
        com.google.cloud.discoveryengine.v1beta.EmbeddingConfig value) {
      if (embeddingConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && embeddingConfig_ != null
            && embeddingConfig_
                != com.google.cloud.discoveryengine.v1beta.EmbeddingConfig.getDefaultInstance()) {
          getEmbeddingConfigBuilder().mergeFrom(value);
        } else {
          embeddingConfig_ = value;
        }
      } else {
        embeddingConfigBuilder_.mergeFrom(value);
      }
      if (embeddingConfig_ != null) {
        bitField0_ |= 0x00000080;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Bring your own embedding config. The config is used for search semantic
     * retrieval. The retrieval is based on the dot product of
     * [SearchRequest.EmbeddingSpec.EmbeddingVector.vector][google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.EmbeddingVector.vector]
     * and the document embeddings that are provided by this EmbeddingConfig. If
     * [SearchRequest.EmbeddingSpec.EmbeddingVector.vector][google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.EmbeddingVector.vector]
     * is provided, it overrides this
     * [ServingConfig.embedding_config][google.cloud.discoveryengine.v1beta.ServingConfig.embedding_config].
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.EmbeddingConfig embedding_config = 20;</code>
     */
    public Builder clearEmbeddingConfig() {
      bitField0_ = (bitField0_ & ~0x00000080);
      embeddingConfig_ = null;
      if (embeddingConfigBuilder_ != null) {
        embeddingConfigBuilder_.dispose();
        embeddingConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Bring your own embedding config. The config is used for search semantic
     * retrieval. The retrieval is based on the dot product of
     * [SearchRequest.EmbeddingSpec.EmbeddingVector.vector][google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.EmbeddingVector.vector]
     * and the document embeddings that are provided by this EmbeddingConfig. If
     * [SearchRequest.EmbeddingSpec.EmbeddingVector.vector][google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.EmbeddingVector.vector]
     * is provided, it overrides this
     * [ServingConfig.embedding_config][google.cloud.discoveryengine.v1beta.ServingConfig.embedding_config].
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.EmbeddingConfig embedding_config = 20;</code>
     */
    public com.google.cloud.discoveryengine.v1beta.EmbeddingConfig.Builder
        getEmbeddingConfigBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getEmbeddingConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Bring your own embedding config. The config is used for search semantic
     * retrieval. The retrieval is based on the dot product of
     * [SearchRequest.EmbeddingSpec.EmbeddingVector.vector][google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.EmbeddingVector.vector]
     * and the document embeddings that are provided by this EmbeddingConfig. If
     * [SearchRequest.EmbeddingSpec.EmbeddingVector.vector][google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.EmbeddingVector.vector]
     * is provided, it overrides this
     * [ServingConfig.embedding_config][google.cloud.discoveryengine.v1beta.ServingConfig.embedding_config].
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.EmbeddingConfig embedding_config = 20;</code>
     */
    public com.google.cloud.discoveryengine.v1beta.EmbeddingConfigOrBuilder
        getEmbeddingConfigOrBuilder() {
      if (embeddingConfigBuilder_ != null) {
        return embeddingConfigBuilder_.getMessageOrBuilder();
      } else {
        return embeddingConfig_ == null
            ? com.google.cloud.discoveryengine.v1beta.EmbeddingConfig.getDefaultInstance()
            : embeddingConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Bring your own embedding config. The config is used for search semantic
     * retrieval. The retrieval is based on the dot product of
     * [SearchRequest.EmbeddingSpec.EmbeddingVector.vector][google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.EmbeddingVector.vector]
     * and the document embeddings that are provided by this EmbeddingConfig. If
     * [SearchRequest.EmbeddingSpec.EmbeddingVector.vector][google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.EmbeddingVector.vector]
     * is provided, it overrides this
     * [ServingConfig.embedding_config][google.cloud.discoveryengine.v1beta.ServingConfig.embedding_config].
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.EmbeddingConfig embedding_config = 20;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1beta.EmbeddingConfig,
            com.google.cloud.discoveryengine.v1beta.EmbeddingConfig.Builder,
            com.google.cloud.discoveryengine.v1beta.EmbeddingConfigOrBuilder>
        getEmbeddingConfigFieldBuilder() {
      if (embeddingConfigBuilder_ == null) {
        embeddingConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1beta.EmbeddingConfig,
                com.google.cloud.discoveryengine.v1beta.EmbeddingConfig.Builder,
                com.google.cloud.discoveryengine.v1beta.EmbeddingConfigOrBuilder>(
                getEmbeddingConfig(), getParentForChildren(), isClean());
        embeddingConfig_ = null;
      }
      return embeddingConfigBuilder_;
    }

    private java.lang.Object rankingExpression_ = "";
    /**
     *
     *
     * <pre>
     * The ranking expression controls the customized ranking on retrieval
     * documents. To leverage this, document embedding is required. The ranking
     * expression setting in ServingConfig applies to all search requests served
     * by the serving config. However, if
     * [SearchRequest.ranking_expression][google.cloud.discoveryengine.v1beta.SearchRequest.ranking_expression]
     * is specified, it overrides the ServingConfig ranking expression.
     *
     * The ranking expression is a single function or multiple functions that are
     * joined by "+".
     *
     *   * ranking_expression = function, { " + ", function };
     *
     * Supported functions:
     *
     *   * double * relevance_score
     *   * double * dotProduct(embedding_field_path)
     *
     * Function variables:
     *
     *   * `relevance_score`: pre-defined keywords, used for measure relevance
     *   between query and document.
     *   * `embedding_field_path`: the document embedding field
     *   used with query embedding vector.
     *   * `dotProduct`: embedding function between embedding_field_path and query
     *   embedding vector.
     *
     *  Example ranking expression:
     *
     *    If document has an embedding field doc_embedding, the ranking expression
     *    could be `0.5 * relevance_score + 0.3 * dotProduct(doc_embedding)`.
     * </pre>
     *
     * <code>string ranking_expression = 21;</code>
     *
     * @return The rankingExpression.
     */
    public java.lang.String getRankingExpression() {
      java.lang.Object ref = rankingExpression_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        rankingExpression_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The ranking expression controls the customized ranking on retrieval
     * documents. To leverage this, document embedding is required. The ranking
     * expression setting in ServingConfig applies to all search requests served
     * by the serving config. However, if
     * [SearchRequest.ranking_expression][google.cloud.discoveryengine.v1beta.SearchRequest.ranking_expression]
     * is specified, it overrides the ServingConfig ranking expression.
     *
     * The ranking expression is a single function or multiple functions that are
     * joined by "+".
     *
     *   * ranking_expression = function, { " + ", function };
     *
     * Supported functions:
     *
     *   * double * relevance_score
     *   * double * dotProduct(embedding_field_path)
     *
     * Function variables:
     *
     *   * `relevance_score`: pre-defined keywords, used for measure relevance
     *   between query and document.
     *   * `embedding_field_path`: the document embedding field
     *   used with query embedding vector.
     *   * `dotProduct`: embedding function between embedding_field_path and query
     *   embedding vector.
     *
     *  Example ranking expression:
     *
     *    If document has an embedding field doc_embedding, the ranking expression
     *    could be `0.5 * relevance_score + 0.3 * dotProduct(doc_embedding)`.
     * </pre>
     *
     * <code>string ranking_expression = 21;</code>
     *
     * @return The bytes for rankingExpression.
     */
    public com.google.protobuf.ByteString getRankingExpressionBytes() {
      java.lang.Object ref = rankingExpression_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        rankingExpression_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The ranking expression controls the customized ranking on retrieval
     * documents. To leverage this, document embedding is required. The ranking
     * expression setting in ServingConfig applies to all search requests served
     * by the serving config. However, if
     * [SearchRequest.ranking_expression][google.cloud.discoveryengine.v1beta.SearchRequest.ranking_expression]
     * is specified, it overrides the ServingConfig ranking expression.
     *
     * The ranking expression is a single function or multiple functions that are
     * joined by "+".
     *
     *   * ranking_expression = function, { " + ", function };
     *
     * Supported functions:
     *
     *   * double * relevance_score
     *   * double * dotProduct(embedding_field_path)
     *
     * Function variables:
     *
     *   * `relevance_score`: pre-defined keywords, used for measure relevance
     *   between query and document.
     *   * `embedding_field_path`: the document embedding field
     *   used with query embedding vector.
     *   * `dotProduct`: embedding function between embedding_field_path and query
     *   embedding vector.
     *
     *  Example ranking expression:
     *
     *    If document has an embedding field doc_embedding, the ranking expression
     *    could be `0.5 * relevance_score + 0.3 * dotProduct(doc_embedding)`.
     * </pre>
     *
     * <code>string ranking_expression = 21;</code>
     *
     * @param value The rankingExpression to set.
     * @return This builder for chaining.
     */
    public Builder setRankingExpression(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      rankingExpression_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The ranking expression controls the customized ranking on retrieval
     * documents. To leverage this, document embedding is required. The ranking
     * expression setting in ServingConfig applies to all search requests served
     * by the serving config. However, if
     * [SearchRequest.ranking_expression][google.cloud.discoveryengine.v1beta.SearchRequest.ranking_expression]
     * is specified, it overrides the ServingConfig ranking expression.
     *
     * The ranking expression is a single function or multiple functions that are
     * joined by "+".
     *
     *   * ranking_expression = function, { " + ", function };
     *
     * Supported functions:
     *
     *   * double * relevance_score
     *   * double * dotProduct(embedding_field_path)
     *
     * Function variables:
     *
     *   * `relevance_score`: pre-defined keywords, used for measure relevance
     *   between query and document.
     *   * `embedding_field_path`: the document embedding field
     *   used with query embedding vector.
     *   * `dotProduct`: embedding function between embedding_field_path and query
     *   embedding vector.
     *
     *  Example ranking expression:
     *
     *    If document has an embedding field doc_embedding, the ranking expression
     *    could be `0.5 * relevance_score + 0.3 * dotProduct(doc_embedding)`.
     * </pre>
     *
     * <code>string ranking_expression = 21;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRankingExpression() {
      rankingExpression_ = getDefaultInstance().getRankingExpression();
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The ranking expression controls the customized ranking on retrieval
     * documents. To leverage this, document embedding is required. The ranking
     * expression setting in ServingConfig applies to all search requests served
     * by the serving config. However, if
     * [SearchRequest.ranking_expression][google.cloud.discoveryengine.v1beta.SearchRequest.ranking_expression]
     * is specified, it overrides the ServingConfig ranking expression.
     *
     * The ranking expression is a single function or multiple functions that are
     * joined by "+".
     *
     *   * ranking_expression = function, { " + ", function };
     *
     * Supported functions:
     *
     *   * double * relevance_score
     *   * double * dotProduct(embedding_field_path)
     *
     * Function variables:
     *
     *   * `relevance_score`: pre-defined keywords, used for measure relevance
     *   between query and document.
     *   * `embedding_field_path`: the document embedding field
     *   used with query embedding vector.
     *   * `dotProduct`: embedding function between embedding_field_path and query
     *   embedding vector.
     *
     *  Example ranking expression:
     *
     *    If document has an embedding field doc_embedding, the ranking expression
     *    could be `0.5 * relevance_score + 0.3 * dotProduct(doc_embedding)`.
     * </pre>
     *
     * <code>string ranking_expression = 21;</code>
     *
     * @param value The bytes for rankingExpression to set.
     * @return This builder for chaining.
     */
    public Builder setRankingExpressionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      rankingExpression_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. ServingConfig created timestamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000200) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. ServingConfig created timestamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. ServingConfig created timestamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. ServingConfig created timestamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. ServingConfig created timestamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000200;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. ServingConfig created timestamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000200);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. ServingConfig created timestamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000200;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. ServingConfig created timestamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. ServingConfig created timestamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. ServingConfig updated timestamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000400) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. ServingConfig updated timestamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. ServingConfig updated timestamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. ServingConfig updated timestamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. ServingConfig updated timestamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000400) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      if (updateTime_ != null) {
        bitField0_ |= 0x00000400;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. ServingConfig updated timestamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000400);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. ServingConfig updated timestamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000400;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. ServingConfig updated timestamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. ServingConfig updated timestamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private com.google.protobuf.LazyStringArrayList filterControlIds_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureFilterControlIdsIsMutable() {
      if (!filterControlIds_.isModifiable()) {
        filterControlIds_ = new com.google.protobuf.LazyStringArrayList(filterControlIds_);
      }
      bitField0_ |= 0x00000800;
    }
    /**
     *
     *
     * <pre>
     * Filter controls to use in serving path.
     * All triggered filter controls will be applied.
     * Filter controls must be in the same data store as the serving config.
     * Maximum of 20 filter controls.
     * </pre>
     *
     * <code>repeated string filter_control_ids = 11;</code>
     *
     * @return A list containing the filterControlIds.
     */
    public com.google.protobuf.ProtocolStringList getFilterControlIdsList() {
      filterControlIds_.makeImmutable();
      return filterControlIds_;
    }
    /**
     *
     *
     * <pre>
     * Filter controls to use in serving path.
     * All triggered filter controls will be applied.
     * Filter controls must be in the same data store as the serving config.
     * Maximum of 20 filter controls.
     * </pre>
     *
     * <code>repeated string filter_control_ids = 11;</code>
     *
     * @return The count of filterControlIds.
     */
    public int getFilterControlIdsCount() {
      return filterControlIds_.size();
    }
    /**
     *
     *
     * <pre>
     * Filter controls to use in serving path.
     * All triggered filter controls will be applied.
     * Filter controls must be in the same data store as the serving config.
     * Maximum of 20 filter controls.
     * </pre>
     *
     * <code>repeated string filter_control_ids = 11;</code>
     *
     * @param index The index of the element to return.
     * @return The filterControlIds at the given index.
     */
    public java.lang.String getFilterControlIds(int index) {
      return filterControlIds_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Filter controls to use in serving path.
     * All triggered filter controls will be applied.
     * Filter controls must be in the same data store as the serving config.
     * Maximum of 20 filter controls.
     * </pre>
     *
     * <code>repeated string filter_control_ids = 11;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the filterControlIds at the given index.
     */
    public com.google.protobuf.ByteString getFilterControlIdsBytes(int index) {
      return filterControlIds_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Filter controls to use in serving path.
     * All triggered filter controls will be applied.
     * Filter controls must be in the same data store as the serving config.
     * Maximum of 20 filter controls.
     * </pre>
     *
     * <code>repeated string filter_control_ids = 11;</code>
     *
     * @param index The index to set the value at.
     * @param value The filterControlIds to set.
     * @return This builder for chaining.
     */
    public Builder setFilterControlIds(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureFilterControlIdsIsMutable();
      filterControlIds_.set(index, value);
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Filter controls to use in serving path.
     * All triggered filter controls will be applied.
     * Filter controls must be in the same data store as the serving config.
     * Maximum of 20 filter controls.
     * </pre>
     *
     * <code>repeated string filter_control_ids = 11;</code>
     *
     * @param value The filterControlIds to add.
     * @return This builder for chaining.
     */
    public Builder addFilterControlIds(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureFilterControlIdsIsMutable();
      filterControlIds_.add(value);
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Filter controls to use in serving path.
     * All triggered filter controls will be applied.
     * Filter controls must be in the same data store as the serving config.
     * Maximum of 20 filter controls.
     * </pre>
     *
     * <code>repeated string filter_control_ids = 11;</code>
     *
     * @param values The filterControlIds to add.
     * @return This builder for chaining.
     */
    public Builder addAllFilterControlIds(java.lang.Iterable<java.lang.String> values) {
      ensureFilterControlIdsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, filterControlIds_);
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Filter controls to use in serving path.
     * All triggered filter controls will be applied.
     * Filter controls must be in the same data store as the serving config.
     * Maximum of 20 filter controls.
     * </pre>
     *
     * <code>repeated string filter_control_ids = 11;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFilterControlIds() {
      filterControlIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000800);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Filter controls to use in serving path.
     * All triggered filter controls will be applied.
     * Filter controls must be in the same data store as the serving config.
     * Maximum of 20 filter controls.
     * </pre>
     *
     * <code>repeated string filter_control_ids = 11;</code>
     *
     * @param value The bytes of the filterControlIds to add.
     * @return This builder for chaining.
     */
    public Builder addFilterControlIdsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureFilterControlIdsIsMutable();
      filterControlIds_.add(value);
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList boostControlIds_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureBoostControlIdsIsMutable() {
      if (!boostControlIds_.isModifiable()) {
        boostControlIds_ = new com.google.protobuf.LazyStringArrayList(boostControlIds_);
      }
      bitField0_ |= 0x00001000;
    }
    /**
     *
     *
     * <pre>
     * Boost controls to use in serving path.
     * All triggered boost controls will be applied.
     * Boost controls must be in the same data store as the serving config.
     * Maximum of 20 boost controls.
     * </pre>
     *
     * <code>repeated string boost_control_ids = 12;</code>
     *
     * @return A list containing the boostControlIds.
     */
    public com.google.protobuf.ProtocolStringList getBoostControlIdsList() {
      boostControlIds_.makeImmutable();
      return boostControlIds_;
    }
    /**
     *
     *
     * <pre>
     * Boost controls to use in serving path.
     * All triggered boost controls will be applied.
     * Boost controls must be in the same data store as the serving config.
     * Maximum of 20 boost controls.
     * </pre>
     *
     * <code>repeated string boost_control_ids = 12;</code>
     *
     * @return The count of boostControlIds.
     */
    public int getBoostControlIdsCount() {
      return boostControlIds_.size();
    }
    /**
     *
     *
     * <pre>
     * Boost controls to use in serving path.
     * All triggered boost controls will be applied.
     * Boost controls must be in the same data store as the serving config.
     * Maximum of 20 boost controls.
     * </pre>
     *
     * <code>repeated string boost_control_ids = 12;</code>
     *
     * @param index The index of the element to return.
     * @return The boostControlIds at the given index.
     */
    public java.lang.String getBoostControlIds(int index) {
      return boostControlIds_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Boost controls to use in serving path.
     * All triggered boost controls will be applied.
     * Boost controls must be in the same data store as the serving config.
     * Maximum of 20 boost controls.
     * </pre>
     *
     * <code>repeated string boost_control_ids = 12;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the boostControlIds at the given index.
     */
    public com.google.protobuf.ByteString getBoostControlIdsBytes(int index) {
      return boostControlIds_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Boost controls to use in serving path.
     * All triggered boost controls will be applied.
     * Boost controls must be in the same data store as the serving config.
     * Maximum of 20 boost controls.
     * </pre>
     *
     * <code>repeated string boost_control_ids = 12;</code>
     *
     * @param index The index to set the value at.
     * @param value The boostControlIds to set.
     * @return This builder for chaining.
     */
    public Builder setBoostControlIds(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureBoostControlIdsIsMutable();
      boostControlIds_.set(index, value);
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Boost controls to use in serving path.
     * All triggered boost controls will be applied.
     * Boost controls must be in the same data store as the serving config.
     * Maximum of 20 boost controls.
     * </pre>
     *
     * <code>repeated string boost_control_ids = 12;</code>
     *
     * @param value The boostControlIds to add.
     * @return This builder for chaining.
     */
    public Builder addBoostControlIds(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureBoostControlIdsIsMutable();
      boostControlIds_.add(value);
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Boost controls to use in serving path.
     * All triggered boost controls will be applied.
     * Boost controls must be in the same data store as the serving config.
     * Maximum of 20 boost controls.
     * </pre>
     *
     * <code>repeated string boost_control_ids = 12;</code>
     *
     * @param values The boostControlIds to add.
     * @return This builder for chaining.
     */
    public Builder addAllBoostControlIds(java.lang.Iterable<java.lang.String> values) {
      ensureBoostControlIdsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, boostControlIds_);
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Boost controls to use in serving path.
     * All triggered boost controls will be applied.
     * Boost controls must be in the same data store as the serving config.
     * Maximum of 20 boost controls.
     * </pre>
     *
     * <code>repeated string boost_control_ids = 12;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBoostControlIds() {
      boostControlIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00001000);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Boost controls to use in serving path.
     * All triggered boost controls will be applied.
     * Boost controls must be in the same data store as the serving config.
     * Maximum of 20 boost controls.
     * </pre>
     *
     * <code>repeated string boost_control_ids = 12;</code>
     *
     * @param value The bytes of the boostControlIds to add.
     * @return This builder for chaining.
     */
    public Builder addBoostControlIdsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureBoostControlIdsIsMutable();
      boostControlIds_.add(value);
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList redirectControlIds_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureRedirectControlIdsIsMutable() {
      if (!redirectControlIds_.isModifiable()) {
        redirectControlIds_ = new com.google.protobuf.LazyStringArrayList(redirectControlIds_);
      }
      bitField0_ |= 0x00002000;
    }
    /**
     *
     *
     * <pre>
     * IDs of the redirect controls. Only the first triggered redirect
     * action is applied, even if multiple apply. Maximum number of
     * specifications is 100.
     *
     * Can only be set if
     * [SolutionType][google.cloud.discoveryengine.v1beta.SolutionType] is
     * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string redirect_control_ids = 14;</code>
     *
     * @return A list containing the redirectControlIds.
     */
    public com.google.protobuf.ProtocolStringList getRedirectControlIdsList() {
      redirectControlIds_.makeImmutable();
      return redirectControlIds_;
    }
    /**
     *
     *
     * <pre>
     * IDs of the redirect controls. Only the first triggered redirect
     * action is applied, even if multiple apply. Maximum number of
     * specifications is 100.
     *
     * Can only be set if
     * [SolutionType][google.cloud.discoveryengine.v1beta.SolutionType] is
     * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string redirect_control_ids = 14;</code>
     *
     * @return The count of redirectControlIds.
     */
    public int getRedirectControlIdsCount() {
      return redirectControlIds_.size();
    }
    /**
     *
     *
     * <pre>
     * IDs of the redirect controls. Only the first triggered redirect
     * action is applied, even if multiple apply. Maximum number of
     * specifications is 100.
     *
     * Can only be set if
     * [SolutionType][google.cloud.discoveryengine.v1beta.SolutionType] is
     * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string redirect_control_ids = 14;</code>
     *
     * @param index The index of the element to return.
     * @return The redirectControlIds at the given index.
     */
    public java.lang.String getRedirectControlIds(int index) {
      return redirectControlIds_.get(index);
    }
    /**
     *
     *
     * <pre>
     * IDs of the redirect controls. Only the first triggered redirect
     * action is applied, even if multiple apply. Maximum number of
     * specifications is 100.
     *
     * Can only be set if
     * [SolutionType][google.cloud.discoveryengine.v1beta.SolutionType] is
     * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string redirect_control_ids = 14;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the redirectControlIds at the given index.
     */
    public com.google.protobuf.ByteString getRedirectControlIdsBytes(int index) {
      return redirectControlIds_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * IDs of the redirect controls. Only the first triggered redirect
     * action is applied, even if multiple apply. Maximum number of
     * specifications is 100.
     *
     * Can only be set if
     * [SolutionType][google.cloud.discoveryengine.v1beta.SolutionType] is
     * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string redirect_control_ids = 14;</code>
     *
     * @param index The index to set the value at.
     * @param value The redirectControlIds to set.
     * @return This builder for chaining.
     */
    public Builder setRedirectControlIds(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureRedirectControlIdsIsMutable();
      redirectControlIds_.set(index, value);
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * IDs of the redirect controls. Only the first triggered redirect
     * action is applied, even if multiple apply. Maximum number of
     * specifications is 100.
     *
     * Can only be set if
     * [SolutionType][google.cloud.discoveryengine.v1beta.SolutionType] is
     * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string redirect_control_ids = 14;</code>
     *
     * @param value The redirectControlIds to add.
     * @return This builder for chaining.
     */
    public Builder addRedirectControlIds(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureRedirectControlIdsIsMutable();
      redirectControlIds_.add(value);
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * IDs of the redirect controls. Only the first triggered redirect
     * action is applied, even if multiple apply. Maximum number of
     * specifications is 100.
     *
     * Can only be set if
     * [SolutionType][google.cloud.discoveryengine.v1beta.SolutionType] is
     * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string redirect_control_ids = 14;</code>
     *
     * @param values The redirectControlIds to add.
     * @return This builder for chaining.
     */
    public Builder addAllRedirectControlIds(java.lang.Iterable<java.lang.String> values) {
      ensureRedirectControlIdsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, redirectControlIds_);
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * IDs of the redirect controls. Only the first triggered redirect
     * action is applied, even if multiple apply. Maximum number of
     * specifications is 100.
     *
     * Can only be set if
     * [SolutionType][google.cloud.discoveryengine.v1beta.SolutionType] is
     * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string redirect_control_ids = 14;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRedirectControlIds() {
      redirectControlIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00002000);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * IDs of the redirect controls. Only the first triggered redirect
     * action is applied, even if multiple apply. Maximum number of
     * specifications is 100.
     *
     * Can only be set if
     * [SolutionType][google.cloud.discoveryengine.v1beta.SolutionType] is
     * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string redirect_control_ids = 14;</code>
     *
     * @param value The bytes of the redirectControlIds to add.
     * @return This builder for chaining.
     */
    public Builder addRedirectControlIdsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureRedirectControlIdsIsMutable();
      redirectControlIds_.add(value);
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList synonymsControlIds_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureSynonymsControlIdsIsMutable() {
      if (!synonymsControlIds_.isModifiable()) {
        synonymsControlIds_ = new com.google.protobuf.LazyStringArrayList(synonymsControlIds_);
      }
      bitField0_ |= 0x00004000;
    }
    /**
     *
     *
     * <pre>
     * Condition synonyms specifications. If multiple synonyms conditions
     * match, all matching synonyms controls in the list will execute.
     * Maximum number of specifications is 100.
     *
     * Can only be set if
     * [SolutionType][google.cloud.discoveryengine.v1beta.SolutionType] is
     * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string synonyms_control_ids = 15;</code>
     *
     * @return A list containing the synonymsControlIds.
     */
    public com.google.protobuf.ProtocolStringList getSynonymsControlIdsList() {
      synonymsControlIds_.makeImmutable();
      return synonymsControlIds_;
    }
    /**
     *
     *
     * <pre>
     * Condition synonyms specifications. If multiple synonyms conditions
     * match, all matching synonyms controls in the list will execute.
     * Maximum number of specifications is 100.
     *
     * Can only be set if
     * [SolutionType][google.cloud.discoveryengine.v1beta.SolutionType] is
     * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string synonyms_control_ids = 15;</code>
     *
     * @return The count of synonymsControlIds.
     */
    public int getSynonymsControlIdsCount() {
      return synonymsControlIds_.size();
    }
    /**
     *
     *
     * <pre>
     * Condition synonyms specifications. If multiple synonyms conditions
     * match, all matching synonyms controls in the list will execute.
     * Maximum number of specifications is 100.
     *
     * Can only be set if
     * [SolutionType][google.cloud.discoveryengine.v1beta.SolutionType] is
     * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string synonyms_control_ids = 15;</code>
     *
     * @param index The index of the element to return.
     * @return The synonymsControlIds at the given index.
     */
    public java.lang.String getSynonymsControlIds(int index) {
      return synonymsControlIds_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Condition synonyms specifications. If multiple synonyms conditions
     * match, all matching synonyms controls in the list will execute.
     * Maximum number of specifications is 100.
     *
     * Can only be set if
     * [SolutionType][google.cloud.discoveryengine.v1beta.SolutionType] is
     * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string synonyms_control_ids = 15;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the synonymsControlIds at the given index.
     */
    public com.google.protobuf.ByteString getSynonymsControlIdsBytes(int index) {
      return synonymsControlIds_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Condition synonyms specifications. If multiple synonyms conditions
     * match, all matching synonyms controls in the list will execute.
     * Maximum number of specifications is 100.
     *
     * Can only be set if
     * [SolutionType][google.cloud.discoveryengine.v1beta.SolutionType] is
     * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string synonyms_control_ids = 15;</code>
     *
     * @param index The index to set the value at.
     * @param value The synonymsControlIds to set.
     * @return This builder for chaining.
     */
    public Builder setSynonymsControlIds(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSynonymsControlIdsIsMutable();
      synonymsControlIds_.set(index, value);
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Condition synonyms specifications. If multiple synonyms conditions
     * match, all matching synonyms controls in the list will execute.
     * Maximum number of specifications is 100.
     *
     * Can only be set if
     * [SolutionType][google.cloud.discoveryengine.v1beta.SolutionType] is
     * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string synonyms_control_ids = 15;</code>
     *
     * @param value The synonymsControlIds to add.
     * @return This builder for chaining.
     */
    public Builder addSynonymsControlIds(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSynonymsControlIdsIsMutable();
      synonymsControlIds_.add(value);
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Condition synonyms specifications. If multiple synonyms conditions
     * match, all matching synonyms controls in the list will execute.
     * Maximum number of specifications is 100.
     *
     * Can only be set if
     * [SolutionType][google.cloud.discoveryengine.v1beta.SolutionType] is
     * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string synonyms_control_ids = 15;</code>
     *
     * @param values The synonymsControlIds to add.
     * @return This builder for chaining.
     */
    public Builder addAllSynonymsControlIds(java.lang.Iterable<java.lang.String> values) {
      ensureSynonymsControlIdsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, synonymsControlIds_);
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Condition synonyms specifications. If multiple synonyms conditions
     * match, all matching synonyms controls in the list will execute.
     * Maximum number of specifications is 100.
     *
     * Can only be set if
     * [SolutionType][google.cloud.discoveryengine.v1beta.SolutionType] is
     * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string synonyms_control_ids = 15;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSynonymsControlIds() {
      synonymsControlIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00004000);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Condition synonyms specifications. If multiple synonyms conditions
     * match, all matching synonyms controls in the list will execute.
     * Maximum number of specifications is 100.
     *
     * Can only be set if
     * [SolutionType][google.cloud.discoveryengine.v1beta.SolutionType] is
     * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string synonyms_control_ids = 15;</code>
     *
     * @param value The bytes of the synonymsControlIds to add.
     * @return This builder for chaining.
     */
    public Builder addSynonymsControlIdsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureSynonymsControlIdsIsMutable();
      synonymsControlIds_.add(value);
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList onewaySynonymsControlIds_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureOnewaySynonymsControlIdsIsMutable() {
      if (!onewaySynonymsControlIds_.isModifiable()) {
        onewaySynonymsControlIds_ =
            new com.google.protobuf.LazyStringArrayList(onewaySynonymsControlIds_);
      }
      bitField0_ |= 0x00008000;
    }
    /**
     *
     *
     * <pre>
     * Condition oneway synonyms specifications. If multiple oneway synonyms
     * conditions match, all matching oneway synonyms controls in the list
     * will execute. Maximum number of specifications is 100.
     *
     * Can only be set if
     * [SolutionType][google.cloud.discoveryengine.v1beta.SolutionType] is
     * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string oneway_synonyms_control_ids = 16;</code>
     *
     * @return A list containing the onewaySynonymsControlIds.
     */
    public com.google.protobuf.ProtocolStringList getOnewaySynonymsControlIdsList() {
      onewaySynonymsControlIds_.makeImmutable();
      return onewaySynonymsControlIds_;
    }
    /**
     *
     *
     * <pre>
     * Condition oneway synonyms specifications. If multiple oneway synonyms
     * conditions match, all matching oneway synonyms controls in the list
     * will execute. Maximum number of specifications is 100.
     *
     * Can only be set if
     * [SolutionType][google.cloud.discoveryengine.v1beta.SolutionType] is
     * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string oneway_synonyms_control_ids = 16;</code>
     *
     * @return The count of onewaySynonymsControlIds.
     */
    public int getOnewaySynonymsControlIdsCount() {
      return onewaySynonymsControlIds_.size();
    }
    /**
     *
     *
     * <pre>
     * Condition oneway synonyms specifications. If multiple oneway synonyms
     * conditions match, all matching oneway synonyms controls in the list
     * will execute. Maximum number of specifications is 100.
     *
     * Can only be set if
     * [SolutionType][google.cloud.discoveryengine.v1beta.SolutionType] is
     * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string oneway_synonyms_control_ids = 16;</code>
     *
     * @param index The index of the element to return.
     * @return The onewaySynonymsControlIds at the given index.
     */
    public java.lang.String getOnewaySynonymsControlIds(int index) {
      return onewaySynonymsControlIds_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Condition oneway synonyms specifications. If multiple oneway synonyms
     * conditions match, all matching oneway synonyms controls in the list
     * will execute. Maximum number of specifications is 100.
     *
     * Can only be set if
     * [SolutionType][google.cloud.discoveryengine.v1beta.SolutionType] is
     * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string oneway_synonyms_control_ids = 16;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the onewaySynonymsControlIds at the given index.
     */
    public com.google.protobuf.ByteString getOnewaySynonymsControlIdsBytes(int index) {
      return onewaySynonymsControlIds_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Condition oneway synonyms specifications. If multiple oneway synonyms
     * conditions match, all matching oneway synonyms controls in the list
     * will execute. Maximum number of specifications is 100.
     *
     * Can only be set if
     * [SolutionType][google.cloud.discoveryengine.v1beta.SolutionType] is
     * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string oneway_synonyms_control_ids = 16;</code>
     *
     * @param index The index to set the value at.
     * @param value The onewaySynonymsControlIds to set.
     * @return This builder for chaining.
     */
    public Builder setOnewaySynonymsControlIds(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureOnewaySynonymsControlIdsIsMutable();
      onewaySynonymsControlIds_.set(index, value);
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Condition oneway synonyms specifications. If multiple oneway synonyms
     * conditions match, all matching oneway synonyms controls in the list
     * will execute. Maximum number of specifications is 100.
     *
     * Can only be set if
     * [SolutionType][google.cloud.discoveryengine.v1beta.SolutionType] is
     * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string oneway_synonyms_control_ids = 16;</code>
     *
     * @param value The onewaySynonymsControlIds to add.
     * @return This builder for chaining.
     */
    public Builder addOnewaySynonymsControlIds(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureOnewaySynonymsControlIdsIsMutable();
      onewaySynonymsControlIds_.add(value);
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Condition oneway synonyms specifications. If multiple oneway synonyms
     * conditions match, all matching oneway synonyms controls in the list
     * will execute. Maximum number of specifications is 100.
     *
     * Can only be set if
     * [SolutionType][google.cloud.discoveryengine.v1beta.SolutionType] is
     * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string oneway_synonyms_control_ids = 16;</code>
     *
     * @param values The onewaySynonymsControlIds to add.
     * @return This builder for chaining.
     */
    public Builder addAllOnewaySynonymsControlIds(java.lang.Iterable<java.lang.String> values) {
      ensureOnewaySynonymsControlIdsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, onewaySynonymsControlIds_);
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Condition oneway synonyms specifications. If multiple oneway synonyms
     * conditions match, all matching oneway synonyms controls in the list
     * will execute. Maximum number of specifications is 100.
     *
     * Can only be set if
     * [SolutionType][google.cloud.discoveryengine.v1beta.SolutionType] is
     * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string oneway_synonyms_control_ids = 16;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearOnewaySynonymsControlIds() {
      onewaySynonymsControlIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00008000);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Condition oneway synonyms specifications. If multiple oneway synonyms
     * conditions match, all matching oneway synonyms controls in the list
     * will execute. Maximum number of specifications is 100.
     *
     * Can only be set if
     * [SolutionType][google.cloud.discoveryengine.v1beta.SolutionType] is
     * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string oneway_synonyms_control_ids = 16;</code>
     *
     * @param value The bytes of the onewaySynonymsControlIds to add.
     * @return This builder for chaining.
     */
    public Builder addOnewaySynonymsControlIdsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureOnewaySynonymsControlIdsIsMutable();
      onewaySynonymsControlIds_.add(value);
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList dissociateControlIds_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureDissociateControlIdsIsMutable() {
      if (!dissociateControlIds_.isModifiable()) {
        dissociateControlIds_ = new com.google.protobuf.LazyStringArrayList(dissociateControlIds_);
      }
      bitField0_ |= 0x00010000;
    }
    /**
     *
     *
     * <pre>
     * Condition do not associate specifications. If multiple do not
     * associate conditions match, all matching do not associate controls in
     * the list will execute.
     * Order does not matter.
     * Maximum number of specifications is 100.
     *
     * Can only be set if
     * [SolutionType][google.cloud.discoveryengine.v1beta.SolutionType] is
     * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string dissociate_control_ids = 17;</code>
     *
     * @return A list containing the dissociateControlIds.
     */
    public com.google.protobuf.ProtocolStringList getDissociateControlIdsList() {
      dissociateControlIds_.makeImmutable();
      return dissociateControlIds_;
    }
    /**
     *
     *
     * <pre>
     * Condition do not associate specifications. If multiple do not
     * associate conditions match, all matching do not associate controls in
     * the list will execute.
     * Order does not matter.
     * Maximum number of specifications is 100.
     *
     * Can only be set if
     * [SolutionType][google.cloud.discoveryengine.v1beta.SolutionType] is
     * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string dissociate_control_ids = 17;</code>
     *
     * @return The count of dissociateControlIds.
     */
    public int getDissociateControlIdsCount() {
      return dissociateControlIds_.size();
    }
    /**
     *
     *
     * <pre>
     * Condition do not associate specifications. If multiple do not
     * associate conditions match, all matching do not associate controls in
     * the list will execute.
     * Order does not matter.
     * Maximum number of specifications is 100.
     *
     * Can only be set if
     * [SolutionType][google.cloud.discoveryengine.v1beta.SolutionType] is
     * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string dissociate_control_ids = 17;</code>
     *
     * @param index The index of the element to return.
     * @return The dissociateControlIds at the given index.
     */
    public java.lang.String getDissociateControlIds(int index) {
      return dissociateControlIds_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Condition do not associate specifications. If multiple do not
     * associate conditions match, all matching do not associate controls in
     * the list will execute.
     * Order does not matter.
     * Maximum number of specifications is 100.
     *
     * Can only be set if
     * [SolutionType][google.cloud.discoveryengine.v1beta.SolutionType] is
     * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string dissociate_control_ids = 17;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the dissociateControlIds at the given index.
     */
    public com.google.protobuf.ByteString getDissociateControlIdsBytes(int index) {
      return dissociateControlIds_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Condition do not associate specifications. If multiple do not
     * associate conditions match, all matching do not associate controls in
     * the list will execute.
     * Order does not matter.
     * Maximum number of specifications is 100.
     *
     * Can only be set if
     * [SolutionType][google.cloud.discoveryengine.v1beta.SolutionType] is
     * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string dissociate_control_ids = 17;</code>
     *
     * @param index The index to set the value at.
     * @param value The dissociateControlIds to set.
     * @return This builder for chaining.
     */
    public Builder setDissociateControlIds(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureDissociateControlIdsIsMutable();
      dissociateControlIds_.set(index, value);
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Condition do not associate specifications. If multiple do not
     * associate conditions match, all matching do not associate controls in
     * the list will execute.
     * Order does not matter.
     * Maximum number of specifications is 100.
     *
     * Can only be set if
     * [SolutionType][google.cloud.discoveryengine.v1beta.SolutionType] is
     * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string dissociate_control_ids = 17;</code>
     *
     * @param value The dissociateControlIds to add.
     * @return This builder for chaining.
     */
    public Builder addDissociateControlIds(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureDissociateControlIdsIsMutable();
      dissociateControlIds_.add(value);
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Condition do not associate specifications. If multiple do not
     * associate conditions match, all matching do not associate controls in
     * the list will execute.
     * Order does not matter.
     * Maximum number of specifications is 100.
     *
     * Can only be set if
     * [SolutionType][google.cloud.discoveryengine.v1beta.SolutionType] is
     * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string dissociate_control_ids = 17;</code>
     *
     * @param values The dissociateControlIds to add.
     * @return This builder for chaining.
     */
    public Builder addAllDissociateControlIds(java.lang.Iterable<java.lang.String> values) {
      ensureDissociateControlIdsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, dissociateControlIds_);
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Condition do not associate specifications. If multiple do not
     * associate conditions match, all matching do not associate controls in
     * the list will execute.
     * Order does not matter.
     * Maximum number of specifications is 100.
     *
     * Can only be set if
     * [SolutionType][google.cloud.discoveryengine.v1beta.SolutionType] is
     * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string dissociate_control_ids = 17;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDissociateControlIds() {
      dissociateControlIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00010000);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Condition do not associate specifications. If multiple do not
     * associate conditions match, all matching do not associate controls in
     * the list will execute.
     * Order does not matter.
     * Maximum number of specifications is 100.
     *
     * Can only be set if
     * [SolutionType][google.cloud.discoveryengine.v1beta.SolutionType] is
     * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string dissociate_control_ids = 17;</code>
     *
     * @param value The bytes of the dissociateControlIds to add.
     * @return This builder for chaining.
     */
    public Builder addDissociateControlIdsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureDissociateControlIdsIsMutable();
      dissociateControlIds_.add(value);
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList replacementControlIds_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureReplacementControlIdsIsMutable() {
      if (!replacementControlIds_.isModifiable()) {
        replacementControlIds_ =
            new com.google.protobuf.LazyStringArrayList(replacementControlIds_);
      }
      bitField0_ |= 0x00020000;
    }
    /**
     *
     *
     * <pre>
     * Condition replacement specifications.
     * Applied according to the order in the list.
     * A previously replaced term can not be re-replaced.
     * Maximum number of specifications is 100.
     *
     * Can only be set if
     * [SolutionType][google.cloud.discoveryengine.v1beta.SolutionType] is
     * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string replacement_control_ids = 18;</code>
     *
     * @return A list containing the replacementControlIds.
     */
    public com.google.protobuf.ProtocolStringList getReplacementControlIdsList() {
      replacementControlIds_.makeImmutable();
      return replacementControlIds_;
    }
    /**
     *
     *
     * <pre>
     * Condition replacement specifications.
     * Applied according to the order in the list.
     * A previously replaced term can not be re-replaced.
     * Maximum number of specifications is 100.
     *
     * Can only be set if
     * [SolutionType][google.cloud.discoveryengine.v1beta.SolutionType] is
     * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string replacement_control_ids = 18;</code>
     *
     * @return The count of replacementControlIds.
     */
    public int getReplacementControlIdsCount() {
      return replacementControlIds_.size();
    }
    /**
     *
     *
     * <pre>
     * Condition replacement specifications.
     * Applied according to the order in the list.
     * A previously replaced term can not be re-replaced.
     * Maximum number of specifications is 100.
     *
     * Can only be set if
     * [SolutionType][google.cloud.discoveryengine.v1beta.SolutionType] is
     * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string replacement_control_ids = 18;</code>
     *
     * @param index The index of the element to return.
     * @return The replacementControlIds at the given index.
     */
    public java.lang.String getReplacementControlIds(int index) {
      return replacementControlIds_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Condition replacement specifications.
     * Applied according to the order in the list.
     * A previously replaced term can not be re-replaced.
     * Maximum number of specifications is 100.
     *
     * Can only be set if
     * [SolutionType][google.cloud.discoveryengine.v1beta.SolutionType] is
     * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string replacement_control_ids = 18;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the replacementControlIds at the given index.
     */
    public com.google.protobuf.ByteString getReplacementControlIdsBytes(int index) {
      return replacementControlIds_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Condition replacement specifications.
     * Applied according to the order in the list.
     * A previously replaced term can not be re-replaced.
     * Maximum number of specifications is 100.
     *
     * Can only be set if
     * [SolutionType][google.cloud.discoveryengine.v1beta.SolutionType] is
     * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string replacement_control_ids = 18;</code>
     *
     * @param index The index to set the value at.
     * @param value The replacementControlIds to set.
     * @return This builder for chaining.
     */
    public Builder setReplacementControlIds(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureReplacementControlIdsIsMutable();
      replacementControlIds_.set(index, value);
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Condition replacement specifications.
     * Applied according to the order in the list.
     * A previously replaced term can not be re-replaced.
     * Maximum number of specifications is 100.
     *
     * Can only be set if
     * [SolutionType][google.cloud.discoveryengine.v1beta.SolutionType] is
     * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string replacement_control_ids = 18;</code>
     *
     * @param value The replacementControlIds to add.
     * @return This builder for chaining.
     */
    public Builder addReplacementControlIds(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureReplacementControlIdsIsMutable();
      replacementControlIds_.add(value);
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Condition replacement specifications.
     * Applied according to the order in the list.
     * A previously replaced term can not be re-replaced.
     * Maximum number of specifications is 100.
     *
     * Can only be set if
     * [SolutionType][google.cloud.discoveryengine.v1beta.SolutionType] is
     * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string replacement_control_ids = 18;</code>
     *
     * @param values The replacementControlIds to add.
     * @return This builder for chaining.
     */
    public Builder addAllReplacementControlIds(java.lang.Iterable<java.lang.String> values) {
      ensureReplacementControlIdsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, replacementControlIds_);
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Condition replacement specifications.
     * Applied according to the order in the list.
     * A previously replaced term can not be re-replaced.
     * Maximum number of specifications is 100.
     *
     * Can only be set if
     * [SolutionType][google.cloud.discoveryengine.v1beta.SolutionType] is
     * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string replacement_control_ids = 18;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearReplacementControlIds() {
      replacementControlIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00020000);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Condition replacement specifications.
     * Applied according to the order in the list.
     * A previously replaced term can not be re-replaced.
     * Maximum number of specifications is 100.
     *
     * Can only be set if
     * [SolutionType][google.cloud.discoveryengine.v1beta.SolutionType] is
     * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string replacement_control_ids = 18;</code>
     *
     * @param value The bytes of the replacementControlIds to add.
     * @return This builder for chaining.
     */
    public Builder addReplacementControlIdsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureReplacementControlIdsIsMutable();
      replacementControlIds_.add(value);
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList ignoreControlIds_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureIgnoreControlIdsIsMutable() {
      if (!ignoreControlIds_.isModifiable()) {
        ignoreControlIds_ = new com.google.protobuf.LazyStringArrayList(ignoreControlIds_);
      }
      bitField0_ |= 0x00040000;
    }
    /**
     *
     *
     * <pre>
     * Condition ignore specifications. If multiple ignore
     * conditions match, all matching ignore controls in the list will
     * execute.
     * Order does not matter.
     * Maximum number of specifications is 100.
     * </pre>
     *
     * <code>repeated string ignore_control_ids = 19;</code>
     *
     * @return A list containing the ignoreControlIds.
     */
    public com.google.protobuf.ProtocolStringList getIgnoreControlIdsList() {
      ignoreControlIds_.makeImmutable();
      return ignoreControlIds_;
    }
    /**
     *
     *
     * <pre>
     * Condition ignore specifications. If multiple ignore
     * conditions match, all matching ignore controls in the list will
     * execute.
     * Order does not matter.
     * Maximum number of specifications is 100.
     * </pre>
     *
     * <code>repeated string ignore_control_ids = 19;</code>
     *
     * @return The count of ignoreControlIds.
     */
    public int getIgnoreControlIdsCount() {
      return ignoreControlIds_.size();
    }
    /**
     *
     *
     * <pre>
     * Condition ignore specifications. If multiple ignore
     * conditions match, all matching ignore controls in the list will
     * execute.
     * Order does not matter.
     * Maximum number of specifications is 100.
     * </pre>
     *
     * <code>repeated string ignore_control_ids = 19;</code>
     *
     * @param index The index of the element to return.
     * @return The ignoreControlIds at the given index.
     */
    public java.lang.String getIgnoreControlIds(int index) {
      return ignoreControlIds_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Condition ignore specifications. If multiple ignore
     * conditions match, all matching ignore controls in the list will
     * execute.
     * Order does not matter.
     * Maximum number of specifications is 100.
     * </pre>
     *
     * <code>repeated string ignore_control_ids = 19;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the ignoreControlIds at the given index.
     */
    public com.google.protobuf.ByteString getIgnoreControlIdsBytes(int index) {
      return ignoreControlIds_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Condition ignore specifications. If multiple ignore
     * conditions match, all matching ignore controls in the list will
     * execute.
     * Order does not matter.
     * Maximum number of specifications is 100.
     * </pre>
     *
     * <code>repeated string ignore_control_ids = 19;</code>
     *
     * @param index The index to set the value at.
     * @param value The ignoreControlIds to set.
     * @return This builder for chaining.
     */
    public Builder setIgnoreControlIds(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureIgnoreControlIdsIsMutable();
      ignoreControlIds_.set(index, value);
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Condition ignore specifications. If multiple ignore
     * conditions match, all matching ignore controls in the list will
     * execute.
     * Order does not matter.
     * Maximum number of specifications is 100.
     * </pre>
     *
     * <code>repeated string ignore_control_ids = 19;</code>
     *
     * @param value The ignoreControlIds to add.
     * @return This builder for chaining.
     */
    public Builder addIgnoreControlIds(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureIgnoreControlIdsIsMutable();
      ignoreControlIds_.add(value);
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Condition ignore specifications. If multiple ignore
     * conditions match, all matching ignore controls in the list will
     * execute.
     * Order does not matter.
     * Maximum number of specifications is 100.
     * </pre>
     *
     * <code>repeated string ignore_control_ids = 19;</code>
     *
     * @param values The ignoreControlIds to add.
     * @return This builder for chaining.
     */
    public Builder addAllIgnoreControlIds(java.lang.Iterable<java.lang.String> values) {
      ensureIgnoreControlIdsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, ignoreControlIds_);
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Condition ignore specifications. If multiple ignore
     * conditions match, all matching ignore controls in the list will
     * execute.
     * Order does not matter.
     * Maximum number of specifications is 100.
     * </pre>
     *
     * <code>repeated string ignore_control_ids = 19;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIgnoreControlIds() {
      ignoreControlIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00040000);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Condition ignore specifications. If multiple ignore
     * conditions match, all matching ignore controls in the list will
     * execute.
     * Order does not matter.
     * Maximum number of specifications is 100.
     * </pre>
     *
     * <code>repeated string ignore_control_ids = 19;</code>
     *
     * @param value The bytes of the ignoreControlIds to add.
     * @return This builder for chaining.
     */
    public Builder addIgnoreControlIdsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureIgnoreControlIdsIsMutable();
      ignoreControlIds_.add(value);
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.ServingConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.ServingConfig)
  private static final com.google.cloud.discoveryengine.v1beta.ServingConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.discoveryengine.v1beta.ServingConfig();
  }

  public static com.google.cloud.discoveryengine.v1beta.ServingConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ServingConfig> PARSER =
      new com.google.protobuf.AbstractParser<ServingConfig>() {
        @java.lang.Override
        public ServingConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ServingConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ServingConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.ServingConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
