/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/discoveryengine/v1beta/data_store.proto

// Protobuf Java Version: 3.25.4
package com.google.cloud.discoveryengine.v1beta;

/**
 *
 *
 * <pre>
 * DataStore captures global settings and configs at the DataStore level.
 * </pre>
 *
 * Protobuf type {@code google.cloud.discoveryengine.v1beta.DataStore}
 */
public final class DataStore extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.DataStore)
    DataStoreOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use DataStore.newBuilder() to construct.
  private DataStore(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private DataStore() {
    name_ = "";
    displayName_ = "";
    industryVertical_ = 0;
    solutionTypes_ = java.util.Collections.emptyList();
    defaultSchemaId_ = "";
    contentConfig_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new DataStore();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.discoveryengine.v1beta.DataStoreProto
        .internal_static_google_cloud_discoveryengine_v1beta_DataStore_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.discoveryengine.v1beta.DataStoreProto
        .internal_static_google_cloud_discoveryengine_v1beta_DataStore_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.discoveryengine.v1beta.DataStore.class,
            com.google.cloud.discoveryengine.v1beta.DataStore.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Content config of the data store.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.discoveryengine.v1beta.DataStore.ContentConfig}
   */
  public enum ContentConfig implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Default value.
     * </pre>
     *
     * <code>CONTENT_CONFIG_UNSPECIFIED = 0;</code>
     */
    CONTENT_CONFIG_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Only contains documents without any
     * [Document.content][google.cloud.discoveryengine.v1beta.Document.content].
     * </pre>
     *
     * <code>NO_CONTENT = 1;</code>
     */
    NO_CONTENT(1),
    /**
     *
     *
     * <pre>
     * Only contains documents with
     * [Document.content][google.cloud.discoveryengine.v1beta.Document.content].
     * </pre>
     *
     * <code>CONTENT_REQUIRED = 2;</code>
     */
    CONTENT_REQUIRED(2),
    /**
     *
     *
     * <pre>
     * The data store is used for public website search.
     * </pre>
     *
     * <code>PUBLIC_WEBSITE = 3;</code>
     */
    PUBLIC_WEBSITE(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Default value.
     * </pre>
     *
     * <code>CONTENT_CONFIG_UNSPECIFIED = 0;</code>
     */
    public static final int CONTENT_CONFIG_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Only contains documents without any
     * [Document.content][google.cloud.discoveryengine.v1beta.Document.content].
     * </pre>
     *
     * <code>NO_CONTENT = 1;</code>
     */
    public static final int NO_CONTENT_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Only contains documents with
     * [Document.content][google.cloud.discoveryengine.v1beta.Document.content].
     * </pre>
     *
     * <code>CONTENT_REQUIRED = 2;</code>
     */
    public static final int CONTENT_REQUIRED_VALUE = 2;
    /**
     *
     *
     * <pre>
     * The data store is used for public website search.
     * </pre>
     *
     * <code>PUBLIC_WEBSITE = 3;</code>
     */
    public static final int PUBLIC_WEBSITE_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ContentConfig valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static ContentConfig forNumber(int value) {
      switch (value) {
        case 0:
          return CONTENT_CONFIG_UNSPECIFIED;
        case 1:
          return NO_CONTENT;
        case 2:
          return CONTENT_REQUIRED;
        case 3:
          return PUBLIC_WEBSITE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ContentConfig> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<ContentConfig> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<ContentConfig>() {
          public ContentConfig findValueByNumber(int number) {
            return ContentConfig.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1beta.DataStore.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final ContentConfig[] VALUES = values();

    public static ContentConfig valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ContentConfig(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.discoveryengine.v1beta.DataStore.ContentConfig)
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Immutable. The full resource name of the data store.
   * Format:
   * `projects/{project}/locations/{location}/collections/{collection_id}/dataStores/{data_store_id}`.
   *
   * This field must be a UTF-8 encoded string with a length limit of 1024
   * characters.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Immutable. The full resource name of the data store.
   * Format:
   * `projects/{project}/locations/{location}/collections/{collection_id}/dataStores/{data_store_id}`.
   *
   * This field must be a UTF-8 encoded string with a length limit of 1024
   * characters.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";
  /**
   *
   *
   * <pre>
   * Required. The data store display name.
   *
   * This field must be a UTF-8 encoded string with a length limit of 128
   * characters. Otherwise, an INVALID_ARGUMENT error is returned.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The data store display name.
   *
   * This field must be a UTF-8 encoded string with a length limit of 128
   * characters. Otherwise, an INVALID_ARGUMENT error is returned.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int INDUSTRY_VERTICAL_FIELD_NUMBER = 3;
  private int industryVertical_ = 0;
  /**
   *
   *
   * <pre>
   * Immutable. The industry vertical that the data store registers.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1beta.IndustryVertical industry_vertical = 3 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The enum numeric value on the wire for industryVertical.
   */
  @java.lang.Override
  public int getIndustryVerticalValue() {
    return industryVertical_;
  }
  /**
   *
   *
   * <pre>
   * Immutable. The industry vertical that the data store registers.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1beta.IndustryVertical industry_vertical = 3 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The industryVertical.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.IndustryVertical getIndustryVertical() {
    com.google.cloud.discoveryengine.v1beta.IndustryVertical result =
        com.google.cloud.discoveryengine.v1beta.IndustryVertical.forNumber(industryVertical_);
    return result == null
        ? com.google.cloud.discoveryengine.v1beta.IndustryVertical.UNRECOGNIZED
        : result;
  }

  public static final int SOLUTION_TYPES_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private java.util.List<java.lang.Integer> solutionTypes_;

  private static final com.google.protobuf.Internal.ListAdapter.Converter<
          java.lang.Integer, com.google.cloud.discoveryengine.v1beta.SolutionType>
      solutionTypes_converter_ =
          new com.google.protobuf.Internal.ListAdapter.Converter<
              java.lang.Integer, com.google.cloud.discoveryengine.v1beta.SolutionType>() {
            public com.google.cloud.discoveryengine.v1beta.SolutionType convert(
                java.lang.Integer from) {
              com.google.cloud.discoveryengine.v1beta.SolutionType result =
                  com.google.cloud.discoveryengine.v1beta.SolutionType.forNumber(from);
              return result == null
                  ? com.google.cloud.discoveryengine.v1beta.SolutionType.UNRECOGNIZED
                  : result;
            }
          };
  /**
   *
   *
   * <pre>
   * The solutions that the data store enrolls. Available solutions for each
   * [industry_vertical][google.cloud.discoveryengine.v1beta.DataStore.industry_vertical]:
   *
   * * `MEDIA`: `SOLUTION_TYPE_RECOMMENDATION` and `SOLUTION_TYPE_SEARCH`.
   * * `SITE_SEARCH`: `SOLUTION_TYPE_SEARCH` is automatically enrolled. Other
   *   solutions cannot be enrolled.
   * </pre>
   *
   * <code>repeated .google.cloud.discoveryengine.v1beta.SolutionType solution_types = 5;</code>
   *
   * @return A list containing the solutionTypes.
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.discoveryengine.v1beta.SolutionType>
      getSolutionTypesList() {
    return new com.google.protobuf.Internal.ListAdapter<
        java.lang.Integer, com.google.cloud.discoveryengine.v1beta.SolutionType>(
        solutionTypes_, solutionTypes_converter_);
  }
  /**
   *
   *
   * <pre>
   * The solutions that the data store enrolls. Available solutions for each
   * [industry_vertical][google.cloud.discoveryengine.v1beta.DataStore.industry_vertical]:
   *
   * * `MEDIA`: `SOLUTION_TYPE_RECOMMENDATION` and `SOLUTION_TYPE_SEARCH`.
   * * `SITE_SEARCH`: `SOLUTION_TYPE_SEARCH` is automatically enrolled. Other
   *   solutions cannot be enrolled.
   * </pre>
   *
   * <code>repeated .google.cloud.discoveryengine.v1beta.SolutionType solution_types = 5;</code>
   *
   * @return The count of solutionTypes.
   */
  @java.lang.Override
  public int getSolutionTypesCount() {
    return solutionTypes_.size();
  }
  /**
   *
   *
   * <pre>
   * The solutions that the data store enrolls. Available solutions for each
   * [industry_vertical][google.cloud.discoveryengine.v1beta.DataStore.industry_vertical]:
   *
   * * `MEDIA`: `SOLUTION_TYPE_RECOMMENDATION` and `SOLUTION_TYPE_SEARCH`.
   * * `SITE_SEARCH`: `SOLUTION_TYPE_SEARCH` is automatically enrolled. Other
   *   solutions cannot be enrolled.
   * </pre>
   *
   * <code>repeated .google.cloud.discoveryengine.v1beta.SolutionType solution_types = 5;</code>
   *
   * @param index The index of the element to return.
   * @return The solutionTypes at the given index.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.SolutionType getSolutionTypes(int index) {
    return solutionTypes_converter_.convert(solutionTypes_.get(index));
  }
  /**
   *
   *
   * <pre>
   * The solutions that the data store enrolls. Available solutions for each
   * [industry_vertical][google.cloud.discoveryengine.v1beta.DataStore.industry_vertical]:
   *
   * * `MEDIA`: `SOLUTION_TYPE_RECOMMENDATION` and `SOLUTION_TYPE_SEARCH`.
   * * `SITE_SEARCH`: `SOLUTION_TYPE_SEARCH` is automatically enrolled. Other
   *   solutions cannot be enrolled.
   * </pre>
   *
   * <code>repeated .google.cloud.discoveryengine.v1beta.SolutionType solution_types = 5;</code>
   *
   * @return A list containing the enum numeric values on the wire for solutionTypes.
   */
  @java.lang.Override
  public java.util.List<java.lang.Integer> getSolutionTypesValueList() {
    return solutionTypes_;
  }
  /**
   *
   *
   * <pre>
   * The solutions that the data store enrolls. Available solutions for each
   * [industry_vertical][google.cloud.discoveryengine.v1beta.DataStore.industry_vertical]:
   *
   * * `MEDIA`: `SOLUTION_TYPE_RECOMMENDATION` and `SOLUTION_TYPE_SEARCH`.
   * * `SITE_SEARCH`: `SOLUTION_TYPE_SEARCH` is automatically enrolled. Other
   *   solutions cannot be enrolled.
   * </pre>
   *
   * <code>repeated .google.cloud.discoveryengine.v1beta.SolutionType solution_types = 5;</code>
   *
   * @param index The index of the value to return.
   * @return The enum numeric value on the wire of solutionTypes at the given index.
   */
  @java.lang.Override
  public int getSolutionTypesValue(int index) {
    return solutionTypes_.get(index);
  }

  private int solutionTypesMemoizedSerializedSize;

  public static final int DEFAULT_SCHEMA_ID_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private volatile java.lang.Object defaultSchemaId_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The id of the default
   * [Schema][google.cloud.discoveryengine.v1beta.Schema] asscociated to this
   * data store.
   * </pre>
   *
   * <code>string default_schema_id = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The defaultSchemaId.
   */
  @java.lang.Override
  public java.lang.String getDefaultSchemaId() {
    java.lang.Object ref = defaultSchemaId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      defaultSchemaId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The id of the default
   * [Schema][google.cloud.discoveryengine.v1beta.Schema] asscociated to this
   * data store.
   * </pre>
   *
   * <code>string default_schema_id = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for defaultSchemaId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDefaultSchemaIdBytes() {
    java.lang.Object ref = defaultSchemaId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      defaultSchemaId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CONTENT_CONFIG_FIELD_NUMBER = 6;
  private int contentConfig_ = 0;
  /**
   *
   *
   * <pre>
   * Immutable. The content config of the data store. If this field is unset,
   * the server behavior defaults to
   * [ContentConfig.NO_CONTENT][google.cloud.discoveryengine.v1beta.DataStore.ContentConfig.NO_CONTENT].
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1beta.DataStore.ContentConfig content_config = 6 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The enum numeric value on the wire for contentConfig.
   */
  @java.lang.Override
  public int getContentConfigValue() {
    return contentConfig_;
  }
  /**
   *
   *
   * <pre>
   * Immutable. The content config of the data store. If this field is unset,
   * the server behavior defaults to
   * [ContentConfig.NO_CONTENT][google.cloud.discoveryengine.v1beta.DataStore.ContentConfig.NO_CONTENT].
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1beta.DataStore.ContentConfig content_config = 6 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The contentConfig.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.DataStore.ContentConfig getContentConfig() {
    com.google.cloud.discoveryengine.v1beta.DataStore.ContentConfig result =
        com.google.cloud.discoveryengine.v1beta.DataStore.ContentConfig.forNumber(contentConfig_);
    return result == null
        ? com.google.cloud.discoveryengine.v1beta.DataStore.ContentConfig.UNRECOGNIZED
        : result;
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 4;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. Timestamp the
   * [DataStore][google.cloud.discoveryengine.v1beta.DataStore] was created at.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp the
   * [DataStore][google.cloud.discoveryengine.v1beta.DataStore] was created at.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp the
   * [DataStore][google.cloud.discoveryengine.v1beta.DataStore] was created at.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int LANGUAGE_INFO_FIELD_NUMBER = 14;
  private com.google.cloud.discoveryengine.v1beta.LanguageInfo languageInfo_;
  /**
   *
   *
   * <pre>
   * Language info for DataStore.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.LanguageInfo language_info = 14;</code>
   *
   * @return Whether the languageInfo field is set.
   */
  @java.lang.Override
  public boolean hasLanguageInfo() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Language info for DataStore.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.LanguageInfo language_info = 14;</code>
   *
   * @return The languageInfo.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.LanguageInfo getLanguageInfo() {
    return languageInfo_ == null
        ? com.google.cloud.discoveryengine.v1beta.LanguageInfo.getDefaultInstance()
        : languageInfo_;
  }
  /**
   *
   *
   * <pre>
   * Language info for DataStore.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.LanguageInfo language_info = 14;</code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.LanguageInfoOrBuilder getLanguageInfoOrBuilder() {
    return languageInfo_ == null
        ? com.google.cloud.discoveryengine.v1beta.LanguageInfo.getDefaultInstance()
        : languageInfo_;
  }

  public static final int DOCUMENT_PROCESSING_CONFIG_FIELD_NUMBER = 27;
  private com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig
      documentProcessingConfig_;
  /**
   *
   *
   * <pre>
   * Configuration for Document understanding and enrichment.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1beta.DocumentProcessingConfig document_processing_config = 27;
   * </code>
   *
   * @return Whether the documentProcessingConfig field is set.
   */
  @java.lang.Override
  public boolean hasDocumentProcessingConfig() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Configuration for Document understanding and enrichment.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1beta.DocumentProcessingConfig document_processing_config = 27;
   * </code>
   *
   * @return The documentProcessingConfig.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig
      getDocumentProcessingConfig() {
    return documentProcessingConfig_ == null
        ? com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.getDefaultInstance()
        : documentProcessingConfig_;
  }
  /**
   *
   *
   * <pre>
   * Configuration for Document understanding and enrichment.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1beta.DocumentProcessingConfig document_processing_config = 27;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfigOrBuilder
      getDocumentProcessingConfigOrBuilder() {
    return documentProcessingConfig_ == null
        ? com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.getDefaultInstance()
        : documentProcessingConfig_;
  }

  public static final int STARTING_SCHEMA_FIELD_NUMBER = 28;
  private com.google.cloud.discoveryengine.v1beta.Schema startingSchema_;
  /**
   *
   *
   * <pre>
   * The start schema to use for this
   * [DataStore][google.cloud.discoveryengine.v1beta.DataStore] when
   * provisioning it. If unset, a default vertical specialized schema will be
   * used.
   *
   * This field is only used by [CreateDataStore][] API, and will be ignored if
   * used in other APIs. This field will be omitted from all API responses
   * including [CreateDataStore][] API. To retrieve a schema of a
   * [DataStore][google.cloud.discoveryengine.v1beta.DataStore], use
   * [SchemaService.GetSchema][google.cloud.discoveryengine.v1beta.SchemaService.GetSchema]
   * API instead.
   *
   * The provided schema will be validated against certain rules on schema.
   * Learn more from [this
   * doc](https://cloud.google.com/generative-ai-app-builder/docs/provide-schema).
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.Schema starting_schema = 28;</code>
   *
   * @return Whether the startingSchema field is set.
   */
  @java.lang.Override
  public boolean hasStartingSchema() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * The start schema to use for this
   * [DataStore][google.cloud.discoveryengine.v1beta.DataStore] when
   * provisioning it. If unset, a default vertical specialized schema will be
   * used.
   *
   * This field is only used by [CreateDataStore][] API, and will be ignored if
   * used in other APIs. This field will be omitted from all API responses
   * including [CreateDataStore][] API. To retrieve a schema of a
   * [DataStore][google.cloud.discoveryengine.v1beta.DataStore], use
   * [SchemaService.GetSchema][google.cloud.discoveryengine.v1beta.SchemaService.GetSchema]
   * API instead.
   *
   * The provided schema will be validated against certain rules on schema.
   * Learn more from [this
   * doc](https://cloud.google.com/generative-ai-app-builder/docs/provide-schema).
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.Schema starting_schema = 28;</code>
   *
   * @return The startingSchema.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.Schema getStartingSchema() {
    return startingSchema_ == null
        ? com.google.cloud.discoveryengine.v1beta.Schema.getDefaultInstance()
        : startingSchema_;
  }
  /**
   *
   *
   * <pre>
   * The start schema to use for this
   * [DataStore][google.cloud.discoveryengine.v1beta.DataStore] when
   * provisioning it. If unset, a default vertical specialized schema will be
   * used.
   *
   * This field is only used by [CreateDataStore][] API, and will be ignored if
   * used in other APIs. This field will be omitted from all API responses
   * including [CreateDataStore][] API. To retrieve a schema of a
   * [DataStore][google.cloud.discoveryengine.v1beta.DataStore], use
   * [SchemaService.GetSchema][google.cloud.discoveryengine.v1beta.SchemaService.GetSchema]
   * API instead.
   *
   * The provided schema will be validated against certain rules on schema.
   * Learn more from [this
   * doc](https://cloud.google.com/generative-ai-app-builder/docs/provide-schema).
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.Schema starting_schema = 28;</code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.SchemaOrBuilder getStartingSchemaOrBuilder() {
    return startingSchema_ == null
        ? com.google.cloud.discoveryengine.v1beta.Schema.getDefaultInstance()
        : startingSchema_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    getSerializedSize();
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, displayName_);
    }
    if (industryVertical_
        != com.google.cloud.discoveryengine.v1beta.IndustryVertical.INDUSTRY_VERTICAL_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(3, industryVertical_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(4, getCreateTime());
    }
    if (getSolutionTypesList().size() > 0) {
      output.writeUInt32NoTag(42);
      output.writeUInt32NoTag(solutionTypesMemoizedSerializedSize);
    }
    for (int i = 0; i < solutionTypes_.size(); i++) {
      output.writeEnumNoTag(solutionTypes_.get(i));
    }
    if (contentConfig_
        != com.google.cloud.discoveryengine.v1beta.DataStore.ContentConfig
            .CONTENT_CONFIG_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(6, contentConfig_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(defaultSchemaId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, defaultSchemaId_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(14, getLanguageInfo());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(27, getDocumentProcessingConfig());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(28, getStartingSchema());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, displayName_);
    }
    if (industryVertical_
        != com.google.cloud.discoveryengine.v1beta.IndustryVertical.INDUSTRY_VERTICAL_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, industryVertical_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getCreateTime());
    }
    {
      int dataSize = 0;
      for (int i = 0; i < solutionTypes_.size(); i++) {
        dataSize +=
            com.google.protobuf.CodedOutputStream.computeEnumSizeNoTag(solutionTypes_.get(i));
      }
      size += dataSize;
      if (!getSolutionTypesList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(dataSize);
      }
      solutionTypesMemoizedSerializedSize = dataSize;
    }
    if (contentConfig_
        != com.google.cloud.discoveryengine.v1beta.DataStore.ContentConfig
            .CONTENT_CONFIG_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(6, contentConfig_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(defaultSchemaId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, defaultSchemaId_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(14, getLanguageInfo());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              27, getDocumentProcessingConfig());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(28, getStartingSchema());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.discoveryengine.v1beta.DataStore)) {
      return super.equals(obj);
    }
    com.google.cloud.discoveryengine.v1beta.DataStore other =
        (com.google.cloud.discoveryengine.v1beta.DataStore) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (industryVertical_ != other.industryVertical_) return false;
    if (!solutionTypes_.equals(other.solutionTypes_)) return false;
    if (!getDefaultSchemaId().equals(other.getDefaultSchemaId())) return false;
    if (contentConfig_ != other.contentConfig_) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasLanguageInfo() != other.hasLanguageInfo()) return false;
    if (hasLanguageInfo()) {
      if (!getLanguageInfo().equals(other.getLanguageInfo())) return false;
    }
    if (hasDocumentProcessingConfig() != other.hasDocumentProcessingConfig()) return false;
    if (hasDocumentProcessingConfig()) {
      if (!getDocumentProcessingConfig().equals(other.getDocumentProcessingConfig())) return false;
    }
    if (hasStartingSchema() != other.hasStartingSchema()) return false;
    if (hasStartingSchema()) {
      if (!getStartingSchema().equals(other.getStartingSchema())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    hash = (37 * hash) + INDUSTRY_VERTICAL_FIELD_NUMBER;
    hash = (53 * hash) + industryVertical_;
    if (getSolutionTypesCount() > 0) {
      hash = (37 * hash) + SOLUTION_TYPES_FIELD_NUMBER;
      hash = (53 * hash) + solutionTypes_.hashCode();
    }
    hash = (37 * hash) + DEFAULT_SCHEMA_ID_FIELD_NUMBER;
    hash = (53 * hash) + getDefaultSchemaId().hashCode();
    hash = (37 * hash) + CONTENT_CONFIG_FIELD_NUMBER;
    hash = (53 * hash) + contentConfig_;
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasLanguageInfo()) {
      hash = (37 * hash) + LANGUAGE_INFO_FIELD_NUMBER;
      hash = (53 * hash) + getLanguageInfo().hashCode();
    }
    if (hasDocumentProcessingConfig()) {
      hash = (37 * hash) + DOCUMENT_PROCESSING_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getDocumentProcessingConfig().hashCode();
    }
    if (hasStartingSchema()) {
      hash = (37 * hash) + STARTING_SCHEMA_FIELD_NUMBER;
      hash = (53 * hash) + getStartingSchema().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.discoveryengine.v1beta.DataStore parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1beta.DataStore parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.DataStore parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1beta.DataStore parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.DataStore parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1beta.DataStore parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.DataStore parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1beta.DataStore parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.DataStore parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1beta.DataStore parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.DataStore parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1beta.DataStore parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.discoveryengine.v1beta.DataStore prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * DataStore captures global settings and configs at the DataStore level.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1beta.DataStore}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.DataStore)
      com.google.cloud.discoveryengine.v1beta.DataStoreOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1beta.DataStoreProto
          .internal_static_google_cloud_discoveryengine_v1beta_DataStore_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1beta.DataStoreProto
          .internal_static_google_cloud_discoveryengine_v1beta_DataStore_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1beta.DataStore.class,
              com.google.cloud.discoveryengine.v1beta.DataStore.Builder.class);
    }

    // Construct using com.google.cloud.discoveryengine.v1beta.DataStore.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getCreateTimeFieldBuilder();
        getLanguageInfoFieldBuilder();
        getDocumentProcessingConfigFieldBuilder();
        getStartingSchemaFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      displayName_ = "";
      industryVertical_ = 0;
      solutionTypes_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000008);
      defaultSchemaId_ = "";
      contentConfig_ = 0;
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      languageInfo_ = null;
      if (languageInfoBuilder_ != null) {
        languageInfoBuilder_.dispose();
        languageInfoBuilder_ = null;
      }
      documentProcessingConfig_ = null;
      if (documentProcessingConfigBuilder_ != null) {
        documentProcessingConfigBuilder_.dispose();
        documentProcessingConfigBuilder_ = null;
      }
      startingSchema_ = null;
      if (startingSchemaBuilder_ != null) {
        startingSchemaBuilder_.dispose();
        startingSchemaBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.discoveryengine.v1beta.DataStoreProto
          .internal_static_google_cloud_discoveryengine_v1beta_DataStore_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.DataStore getDefaultInstanceForType() {
      return com.google.cloud.discoveryengine.v1beta.DataStore.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.DataStore build() {
      com.google.cloud.discoveryengine.v1beta.DataStore result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.DataStore buildPartial() {
      com.google.cloud.discoveryengine.v1beta.DataStore result =
          new com.google.cloud.discoveryengine.v1beta.DataStore(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.discoveryengine.v1beta.DataStore result) {
      if (((bitField0_ & 0x00000008) != 0)) {
        solutionTypes_ = java.util.Collections.unmodifiableList(solutionTypes_);
        bitField0_ = (bitField0_ & ~0x00000008);
      }
      result.solutionTypes_ = solutionTypes_;
    }

    private void buildPartial0(com.google.cloud.discoveryengine.v1beta.DataStore result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.displayName_ = displayName_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.industryVertical_ = industryVertical_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.defaultSchemaId_ = defaultSchemaId_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.contentConfig_ = contentConfig_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.languageInfo_ =
            languageInfoBuilder_ == null ? languageInfo_ : languageInfoBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.documentProcessingConfig_ =
            documentProcessingConfigBuilder_ == null
                ? documentProcessingConfig_
                : documentProcessingConfigBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.startingSchema_ =
            startingSchemaBuilder_ == null ? startingSchema_ : startingSchemaBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.discoveryengine.v1beta.DataStore) {
        return mergeFrom((com.google.cloud.discoveryengine.v1beta.DataStore) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.discoveryengine.v1beta.DataStore other) {
      if (other == com.google.cloud.discoveryengine.v1beta.DataStore.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.industryVertical_ != 0) {
        setIndustryVerticalValue(other.getIndustryVerticalValue());
      }
      if (!other.solutionTypes_.isEmpty()) {
        if (solutionTypes_.isEmpty()) {
          solutionTypes_ = other.solutionTypes_;
          bitField0_ = (bitField0_ & ~0x00000008);
        } else {
          ensureSolutionTypesIsMutable();
          solutionTypes_.addAll(other.solutionTypes_);
        }
        onChanged();
      }
      if (!other.getDefaultSchemaId().isEmpty()) {
        defaultSchemaId_ = other.defaultSchemaId_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (other.contentConfig_ != 0) {
        setContentConfigValue(other.getContentConfigValue());
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasLanguageInfo()) {
        mergeLanguageInfo(other.getLanguageInfo());
      }
      if (other.hasDocumentProcessingConfig()) {
        mergeDocumentProcessingConfig(other.getDocumentProcessingConfig());
      }
      if (other.hasStartingSchema()) {
        mergeStartingSchema(other.getStartingSchema());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 24:
              {
                industryVertical_ = input.readEnum();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 34:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 34
            case 40:
              {
                int tmpRaw = input.readEnum();
                ensureSolutionTypesIsMutable();
                solutionTypes_.add(tmpRaw);
                break;
              } // case 40
            case 42:
              {
                int length = input.readRawVarint32();
                int oldLimit = input.pushLimit(length);
                while (input.getBytesUntilLimit() > 0) {
                  int tmpRaw = input.readEnum();
                  ensureSolutionTypesIsMutable();
                  solutionTypes_.add(tmpRaw);
                }
                input.popLimit(oldLimit);
                break;
              } // case 42
            case 48:
              {
                contentConfig_ = input.readEnum();
                bitField0_ |= 0x00000020;
                break;
              } // case 48
            case 58:
              {
                defaultSchemaId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 58
            case 114:
              {
                input.readMessage(getLanguageInfoFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 114
            case 218:
              {
                input.readMessage(
                    getDocumentProcessingConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 218
            case 226:
              {
                input.readMessage(getStartingSchemaFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000200;
                break;
              } // case 226
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Immutable. The full resource name of the data store.
     * Format:
     * `projects/{project}/locations/{location}/collections/{collection_id}/dataStores/{data_store_id}`.
     *
     * This field must be a UTF-8 encoded string with a length limit of 1024
     * characters.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. The full resource name of the data store.
     * Format:
     * `projects/{project}/locations/{location}/collections/{collection_id}/dataStores/{data_store_id}`.
     *
     * This field must be a UTF-8 encoded string with a length limit of 1024
     * characters.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. The full resource name of the data store.
     * Format:
     * `projects/{project}/locations/{location}/collections/{collection_id}/dataStores/{data_store_id}`.
     *
     * This field must be a UTF-8 encoded string with a length limit of 1024
     * characters.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The full resource name of the data store.
     * Format:
     * `projects/{project}/locations/{location}/collections/{collection_id}/dataStores/{data_store_id}`.
     *
     * This field must be a UTF-8 encoded string with a length limit of 1024
     * characters.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The full resource name of the data store.
     * Format:
     * `projects/{project}/locations/{location}/collections/{collection_id}/dataStores/{data_store_id}`.
     *
     * This field must be a UTF-8 encoded string with a length limit of 1024
     * characters.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * Required. The data store display name.
     *
     * This field must be a UTF-8 encoded string with a length limit of 128
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The data store display name.
     *
     * This field must be a UTF-8 encoded string with a length limit of 128
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The data store display name.
     *
     * This field must be a UTF-8 encoded string with a length limit of 128
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The data store display name.
     *
     * This field must be a UTF-8 encoded string with a length limit of 128
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The data store display name.
     *
     * This field must be a UTF-8 encoded string with a length limit of 128
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private int industryVertical_ = 0;
    /**
     *
     *
     * <pre>
     * Immutable. The industry vertical that the data store registers.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.IndustryVertical industry_vertical = 3 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The enum numeric value on the wire for industryVertical.
     */
    @java.lang.Override
    public int getIndustryVerticalValue() {
      return industryVertical_;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The industry vertical that the data store registers.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.IndustryVertical industry_vertical = 3 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param value The enum numeric value on the wire for industryVertical to set.
     * @return This builder for chaining.
     */
    public Builder setIndustryVerticalValue(int value) {
      industryVertical_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The industry vertical that the data store registers.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.IndustryVertical industry_vertical = 3 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The industryVertical.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.IndustryVertical getIndustryVertical() {
      com.google.cloud.discoveryengine.v1beta.IndustryVertical result =
          com.google.cloud.discoveryengine.v1beta.IndustryVertical.forNumber(industryVertical_);
      return result == null
          ? com.google.cloud.discoveryengine.v1beta.IndustryVertical.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The industry vertical that the data store registers.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.IndustryVertical industry_vertical = 3 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param value The industryVertical to set.
     * @return This builder for chaining.
     */
    public Builder setIndustryVertical(
        com.google.cloud.discoveryengine.v1beta.IndustryVertical value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000004;
      industryVertical_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The industry vertical that the data store registers.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.IndustryVertical industry_vertical = 3 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIndustryVertical() {
      bitField0_ = (bitField0_ & ~0x00000004);
      industryVertical_ = 0;
      onChanged();
      return this;
    }

    private java.util.List<java.lang.Integer> solutionTypes_ = java.util.Collections.emptyList();

    private void ensureSolutionTypesIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        solutionTypes_ = new java.util.ArrayList<java.lang.Integer>(solutionTypes_);
        bitField0_ |= 0x00000008;
      }
    }
    /**
     *
     *
     * <pre>
     * The solutions that the data store enrolls. Available solutions for each
     * [industry_vertical][google.cloud.discoveryengine.v1beta.DataStore.industry_vertical]:
     *
     * * `MEDIA`: `SOLUTION_TYPE_RECOMMENDATION` and `SOLUTION_TYPE_SEARCH`.
     * * `SITE_SEARCH`: `SOLUTION_TYPE_SEARCH` is automatically enrolled. Other
     *   solutions cannot be enrolled.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.SolutionType solution_types = 5;</code>
     *
     * @return A list containing the solutionTypes.
     */
    public java.util.List<com.google.cloud.discoveryengine.v1beta.SolutionType>
        getSolutionTypesList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer, com.google.cloud.discoveryengine.v1beta.SolutionType>(
          solutionTypes_, solutionTypes_converter_);
    }
    /**
     *
     *
     * <pre>
     * The solutions that the data store enrolls. Available solutions for each
     * [industry_vertical][google.cloud.discoveryengine.v1beta.DataStore.industry_vertical]:
     *
     * * `MEDIA`: `SOLUTION_TYPE_RECOMMENDATION` and `SOLUTION_TYPE_SEARCH`.
     * * `SITE_SEARCH`: `SOLUTION_TYPE_SEARCH` is automatically enrolled. Other
     *   solutions cannot be enrolled.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.SolutionType solution_types = 5;</code>
     *
     * @return The count of solutionTypes.
     */
    public int getSolutionTypesCount() {
      return solutionTypes_.size();
    }
    /**
     *
     *
     * <pre>
     * The solutions that the data store enrolls. Available solutions for each
     * [industry_vertical][google.cloud.discoveryengine.v1beta.DataStore.industry_vertical]:
     *
     * * `MEDIA`: `SOLUTION_TYPE_RECOMMENDATION` and `SOLUTION_TYPE_SEARCH`.
     * * `SITE_SEARCH`: `SOLUTION_TYPE_SEARCH` is automatically enrolled. Other
     *   solutions cannot be enrolled.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.SolutionType solution_types = 5;</code>
     *
     * @param index The index of the element to return.
     * @return The solutionTypes at the given index.
     */
    public com.google.cloud.discoveryengine.v1beta.SolutionType getSolutionTypes(int index) {
      return solutionTypes_converter_.convert(solutionTypes_.get(index));
    }
    /**
     *
     *
     * <pre>
     * The solutions that the data store enrolls. Available solutions for each
     * [industry_vertical][google.cloud.discoveryengine.v1beta.DataStore.industry_vertical]:
     *
     * * `MEDIA`: `SOLUTION_TYPE_RECOMMENDATION` and `SOLUTION_TYPE_SEARCH`.
     * * `SITE_SEARCH`: `SOLUTION_TYPE_SEARCH` is automatically enrolled. Other
     *   solutions cannot be enrolled.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.SolutionType solution_types = 5;</code>
     *
     * @param index The index to set the value at.
     * @param value The solutionTypes to set.
     * @return This builder for chaining.
     */
    public Builder setSolutionTypes(
        int index, com.google.cloud.discoveryengine.v1beta.SolutionType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSolutionTypesIsMutable();
      solutionTypes_.set(index, value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The solutions that the data store enrolls. Available solutions for each
     * [industry_vertical][google.cloud.discoveryengine.v1beta.DataStore.industry_vertical]:
     *
     * * `MEDIA`: `SOLUTION_TYPE_RECOMMENDATION` and `SOLUTION_TYPE_SEARCH`.
     * * `SITE_SEARCH`: `SOLUTION_TYPE_SEARCH` is automatically enrolled. Other
     *   solutions cannot be enrolled.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.SolutionType solution_types = 5;</code>
     *
     * @param value The solutionTypes to add.
     * @return This builder for chaining.
     */
    public Builder addSolutionTypes(com.google.cloud.discoveryengine.v1beta.SolutionType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSolutionTypesIsMutable();
      solutionTypes_.add(value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The solutions that the data store enrolls. Available solutions for each
     * [industry_vertical][google.cloud.discoveryengine.v1beta.DataStore.industry_vertical]:
     *
     * * `MEDIA`: `SOLUTION_TYPE_RECOMMENDATION` and `SOLUTION_TYPE_SEARCH`.
     * * `SITE_SEARCH`: `SOLUTION_TYPE_SEARCH` is automatically enrolled. Other
     *   solutions cannot be enrolled.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.SolutionType solution_types = 5;</code>
     *
     * @param values The solutionTypes to add.
     * @return This builder for chaining.
     */
    public Builder addAllSolutionTypes(
        java.lang.Iterable<? extends com.google.cloud.discoveryengine.v1beta.SolutionType> values) {
      ensureSolutionTypesIsMutable();
      for (com.google.cloud.discoveryengine.v1beta.SolutionType value : values) {
        solutionTypes_.add(value.getNumber());
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The solutions that the data store enrolls. Available solutions for each
     * [industry_vertical][google.cloud.discoveryengine.v1beta.DataStore.industry_vertical]:
     *
     * * `MEDIA`: `SOLUTION_TYPE_RECOMMENDATION` and `SOLUTION_TYPE_SEARCH`.
     * * `SITE_SEARCH`: `SOLUTION_TYPE_SEARCH` is automatically enrolled. Other
     *   solutions cannot be enrolled.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.SolutionType solution_types = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSolutionTypes() {
      solutionTypes_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The solutions that the data store enrolls. Available solutions for each
     * [industry_vertical][google.cloud.discoveryengine.v1beta.DataStore.industry_vertical]:
     *
     * * `MEDIA`: `SOLUTION_TYPE_RECOMMENDATION` and `SOLUTION_TYPE_SEARCH`.
     * * `SITE_SEARCH`: `SOLUTION_TYPE_SEARCH` is automatically enrolled. Other
     *   solutions cannot be enrolled.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.SolutionType solution_types = 5;</code>
     *
     * @return A list containing the enum numeric values on the wire for solutionTypes.
     */
    public java.util.List<java.lang.Integer> getSolutionTypesValueList() {
      return java.util.Collections.unmodifiableList(solutionTypes_);
    }
    /**
     *
     *
     * <pre>
     * The solutions that the data store enrolls. Available solutions for each
     * [industry_vertical][google.cloud.discoveryengine.v1beta.DataStore.industry_vertical]:
     *
     * * `MEDIA`: `SOLUTION_TYPE_RECOMMENDATION` and `SOLUTION_TYPE_SEARCH`.
     * * `SITE_SEARCH`: `SOLUTION_TYPE_SEARCH` is automatically enrolled. Other
     *   solutions cannot be enrolled.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.SolutionType solution_types = 5;</code>
     *
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of solutionTypes at the given index.
     */
    public int getSolutionTypesValue(int index) {
      return solutionTypes_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The solutions that the data store enrolls. Available solutions for each
     * [industry_vertical][google.cloud.discoveryengine.v1beta.DataStore.industry_vertical]:
     *
     * * `MEDIA`: `SOLUTION_TYPE_RECOMMENDATION` and `SOLUTION_TYPE_SEARCH`.
     * * `SITE_SEARCH`: `SOLUTION_TYPE_SEARCH` is automatically enrolled. Other
     *   solutions cannot be enrolled.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.SolutionType solution_types = 5;</code>
     *
     * @param index The index to set the value at.
     * @param value The enum numeric value on the wire for solutionTypes to set.
     * @return This builder for chaining.
     */
    public Builder setSolutionTypesValue(int index, int value) {
      ensureSolutionTypesIsMutable();
      solutionTypes_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The solutions that the data store enrolls. Available solutions for each
     * [industry_vertical][google.cloud.discoveryengine.v1beta.DataStore.industry_vertical]:
     *
     * * `MEDIA`: `SOLUTION_TYPE_RECOMMENDATION` and `SOLUTION_TYPE_SEARCH`.
     * * `SITE_SEARCH`: `SOLUTION_TYPE_SEARCH` is automatically enrolled. Other
     *   solutions cannot be enrolled.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.SolutionType solution_types = 5;</code>
     *
     * @param value The enum numeric value on the wire for solutionTypes to add.
     * @return This builder for chaining.
     */
    public Builder addSolutionTypesValue(int value) {
      ensureSolutionTypesIsMutable();
      solutionTypes_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The solutions that the data store enrolls. Available solutions for each
     * [industry_vertical][google.cloud.discoveryengine.v1beta.DataStore.industry_vertical]:
     *
     * * `MEDIA`: `SOLUTION_TYPE_RECOMMENDATION` and `SOLUTION_TYPE_SEARCH`.
     * * `SITE_SEARCH`: `SOLUTION_TYPE_SEARCH` is automatically enrolled. Other
     *   solutions cannot be enrolled.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.SolutionType solution_types = 5;</code>
     *
     * @param values The enum numeric values on the wire for solutionTypes to add.
     * @return This builder for chaining.
     */
    public Builder addAllSolutionTypesValue(java.lang.Iterable<java.lang.Integer> values) {
      ensureSolutionTypesIsMutable();
      for (int value : values) {
        solutionTypes_.add(value);
      }
      onChanged();
      return this;
    }

    private java.lang.Object defaultSchemaId_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The id of the default
     * [Schema][google.cloud.discoveryengine.v1beta.Schema] asscociated to this
     * data store.
     * </pre>
     *
     * <code>string default_schema_id = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The defaultSchemaId.
     */
    public java.lang.String getDefaultSchemaId() {
      java.lang.Object ref = defaultSchemaId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        defaultSchemaId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The id of the default
     * [Schema][google.cloud.discoveryengine.v1beta.Schema] asscociated to this
     * data store.
     * </pre>
     *
     * <code>string default_schema_id = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for defaultSchemaId.
     */
    public com.google.protobuf.ByteString getDefaultSchemaIdBytes() {
      java.lang.Object ref = defaultSchemaId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        defaultSchemaId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The id of the default
     * [Schema][google.cloud.discoveryengine.v1beta.Schema] asscociated to this
     * data store.
     * </pre>
     *
     * <code>string default_schema_id = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The defaultSchemaId to set.
     * @return This builder for chaining.
     */
    public Builder setDefaultSchemaId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      defaultSchemaId_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The id of the default
     * [Schema][google.cloud.discoveryengine.v1beta.Schema] asscociated to this
     * data store.
     * </pre>
     *
     * <code>string default_schema_id = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDefaultSchemaId() {
      defaultSchemaId_ = getDefaultInstance().getDefaultSchemaId();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The id of the default
     * [Schema][google.cloud.discoveryengine.v1beta.Schema] asscociated to this
     * data store.
     * </pre>
     *
     * <code>string default_schema_id = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for defaultSchemaId to set.
     * @return This builder for chaining.
     */
    public Builder setDefaultSchemaIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      defaultSchemaId_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private int contentConfig_ = 0;
    /**
     *
     *
     * <pre>
     * Immutable. The content config of the data store. If this field is unset,
     * the server behavior defaults to
     * [ContentConfig.NO_CONTENT][google.cloud.discoveryengine.v1beta.DataStore.ContentConfig.NO_CONTENT].
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.DataStore.ContentConfig content_config = 6 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The enum numeric value on the wire for contentConfig.
     */
    @java.lang.Override
    public int getContentConfigValue() {
      return contentConfig_;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The content config of the data store. If this field is unset,
     * the server behavior defaults to
     * [ContentConfig.NO_CONTENT][google.cloud.discoveryengine.v1beta.DataStore.ContentConfig.NO_CONTENT].
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.DataStore.ContentConfig content_config = 6 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param value The enum numeric value on the wire for contentConfig to set.
     * @return This builder for chaining.
     */
    public Builder setContentConfigValue(int value) {
      contentConfig_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The content config of the data store. If this field is unset,
     * the server behavior defaults to
     * [ContentConfig.NO_CONTENT][google.cloud.discoveryengine.v1beta.DataStore.ContentConfig.NO_CONTENT].
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.DataStore.ContentConfig content_config = 6 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The contentConfig.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.DataStore.ContentConfig getContentConfig() {
      com.google.cloud.discoveryengine.v1beta.DataStore.ContentConfig result =
          com.google.cloud.discoveryengine.v1beta.DataStore.ContentConfig.forNumber(contentConfig_);
      return result == null
          ? com.google.cloud.discoveryengine.v1beta.DataStore.ContentConfig.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The content config of the data store. If this field is unset,
     * the server behavior defaults to
     * [ContentConfig.NO_CONTENT][google.cloud.discoveryengine.v1beta.DataStore.ContentConfig.NO_CONTENT].
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.DataStore.ContentConfig content_config = 6 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param value The contentConfig to set.
     * @return This builder for chaining.
     */
    public Builder setContentConfig(
        com.google.cloud.discoveryengine.v1beta.DataStore.ContentConfig value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000020;
      contentConfig_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The content config of the data store. If this field is unset,
     * the server behavior defaults to
     * [ContentConfig.NO_CONTENT][google.cloud.discoveryengine.v1beta.DataStore.ContentConfig.NO_CONTENT].
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.DataStore.ContentConfig content_config = 6 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearContentConfig() {
      bitField0_ = (bitField0_ & ~0x00000020);
      contentConfig_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Timestamp the
     * [DataStore][google.cloud.discoveryengine.v1beta.DataStore] was created at.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp the
     * [DataStore][google.cloud.discoveryengine.v1beta.DataStore] was created at.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp the
     * [DataStore][google.cloud.discoveryengine.v1beta.DataStore] was created at.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp the
     * [DataStore][google.cloud.discoveryengine.v1beta.DataStore] was created at.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp the
     * [DataStore][google.cloud.discoveryengine.v1beta.DataStore] was created at.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000040;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp the
     * [DataStore][google.cloud.discoveryengine.v1beta.DataStore] was created at.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000040);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp the
     * [DataStore][google.cloud.discoveryengine.v1beta.DataStore] was created at.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp the
     * [DataStore][google.cloud.discoveryengine.v1beta.DataStore] was created at.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp the
     * [DataStore][google.cloud.discoveryengine.v1beta.DataStore] was created at.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.cloud.discoveryengine.v1beta.LanguageInfo languageInfo_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1beta.LanguageInfo,
            com.google.cloud.discoveryengine.v1beta.LanguageInfo.Builder,
            com.google.cloud.discoveryengine.v1beta.LanguageInfoOrBuilder>
        languageInfoBuilder_;
    /**
     *
     *
     * <pre>
     * Language info for DataStore.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.LanguageInfo language_info = 14;</code>
     *
     * @return Whether the languageInfo field is set.
     */
    public boolean hasLanguageInfo() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * Language info for DataStore.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.LanguageInfo language_info = 14;</code>
     *
     * @return The languageInfo.
     */
    public com.google.cloud.discoveryengine.v1beta.LanguageInfo getLanguageInfo() {
      if (languageInfoBuilder_ == null) {
        return languageInfo_ == null
            ? com.google.cloud.discoveryengine.v1beta.LanguageInfo.getDefaultInstance()
            : languageInfo_;
      } else {
        return languageInfoBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Language info for DataStore.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.LanguageInfo language_info = 14;</code>
     */
    public Builder setLanguageInfo(com.google.cloud.discoveryengine.v1beta.LanguageInfo value) {
      if (languageInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        languageInfo_ = value;
      } else {
        languageInfoBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Language info for DataStore.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.LanguageInfo language_info = 14;</code>
     */
    public Builder setLanguageInfo(
        com.google.cloud.discoveryengine.v1beta.LanguageInfo.Builder builderForValue) {
      if (languageInfoBuilder_ == null) {
        languageInfo_ = builderForValue.build();
      } else {
        languageInfoBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Language info for DataStore.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.LanguageInfo language_info = 14;</code>
     */
    public Builder mergeLanguageInfo(com.google.cloud.discoveryengine.v1beta.LanguageInfo value) {
      if (languageInfoBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && languageInfo_ != null
            && languageInfo_
                != com.google.cloud.discoveryengine.v1beta.LanguageInfo.getDefaultInstance()) {
          getLanguageInfoBuilder().mergeFrom(value);
        } else {
          languageInfo_ = value;
        }
      } else {
        languageInfoBuilder_.mergeFrom(value);
      }
      if (languageInfo_ != null) {
        bitField0_ |= 0x00000080;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Language info for DataStore.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.LanguageInfo language_info = 14;</code>
     */
    public Builder clearLanguageInfo() {
      bitField0_ = (bitField0_ & ~0x00000080);
      languageInfo_ = null;
      if (languageInfoBuilder_ != null) {
        languageInfoBuilder_.dispose();
        languageInfoBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Language info for DataStore.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.LanguageInfo language_info = 14;</code>
     */
    public com.google.cloud.discoveryengine.v1beta.LanguageInfo.Builder getLanguageInfoBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getLanguageInfoFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Language info for DataStore.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.LanguageInfo language_info = 14;</code>
     */
    public com.google.cloud.discoveryengine.v1beta.LanguageInfoOrBuilder
        getLanguageInfoOrBuilder() {
      if (languageInfoBuilder_ != null) {
        return languageInfoBuilder_.getMessageOrBuilder();
      } else {
        return languageInfo_ == null
            ? com.google.cloud.discoveryengine.v1beta.LanguageInfo.getDefaultInstance()
            : languageInfo_;
      }
    }
    /**
     *
     *
     * <pre>
     * Language info for DataStore.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.LanguageInfo language_info = 14;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1beta.LanguageInfo,
            com.google.cloud.discoveryengine.v1beta.LanguageInfo.Builder,
            com.google.cloud.discoveryengine.v1beta.LanguageInfoOrBuilder>
        getLanguageInfoFieldBuilder() {
      if (languageInfoBuilder_ == null) {
        languageInfoBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1beta.LanguageInfo,
                com.google.cloud.discoveryengine.v1beta.LanguageInfo.Builder,
                com.google.cloud.discoveryengine.v1beta.LanguageInfoOrBuilder>(
                getLanguageInfo(), getParentForChildren(), isClean());
        languageInfo_ = null;
      }
      return languageInfoBuilder_;
    }

    private com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig
        documentProcessingConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig,
            com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.Builder,
            com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfigOrBuilder>
        documentProcessingConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Configuration for Document understanding and enrichment.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.DocumentProcessingConfig document_processing_config = 27;
     * </code>
     *
     * @return Whether the documentProcessingConfig field is set.
     */
    public boolean hasDocumentProcessingConfig() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * Configuration for Document understanding and enrichment.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.DocumentProcessingConfig document_processing_config = 27;
     * </code>
     *
     * @return The documentProcessingConfig.
     */
    public com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig
        getDocumentProcessingConfig() {
      if (documentProcessingConfigBuilder_ == null) {
        return documentProcessingConfig_ == null
            ? com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.getDefaultInstance()
            : documentProcessingConfig_;
      } else {
        return documentProcessingConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for Document understanding and enrichment.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.DocumentProcessingConfig document_processing_config = 27;
     * </code>
     */
    public Builder setDocumentProcessingConfig(
        com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig value) {
      if (documentProcessingConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        documentProcessingConfig_ = value;
      } else {
        documentProcessingConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for Document understanding and enrichment.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.DocumentProcessingConfig document_processing_config = 27;
     * </code>
     */
    public Builder setDocumentProcessingConfig(
        com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.Builder builderForValue) {
      if (documentProcessingConfigBuilder_ == null) {
        documentProcessingConfig_ = builderForValue.build();
      } else {
        documentProcessingConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for Document understanding and enrichment.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.DocumentProcessingConfig document_processing_config = 27;
     * </code>
     */
    public Builder mergeDocumentProcessingConfig(
        com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig value) {
      if (documentProcessingConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && documentProcessingConfig_ != null
            && documentProcessingConfig_
                != com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig
                    .getDefaultInstance()) {
          getDocumentProcessingConfigBuilder().mergeFrom(value);
        } else {
          documentProcessingConfig_ = value;
        }
      } else {
        documentProcessingConfigBuilder_.mergeFrom(value);
      }
      if (documentProcessingConfig_ != null) {
        bitField0_ |= 0x00000100;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for Document understanding and enrichment.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.DocumentProcessingConfig document_processing_config = 27;
     * </code>
     */
    public Builder clearDocumentProcessingConfig() {
      bitField0_ = (bitField0_ & ~0x00000100);
      documentProcessingConfig_ = null;
      if (documentProcessingConfigBuilder_ != null) {
        documentProcessingConfigBuilder_.dispose();
        documentProcessingConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for Document understanding and enrichment.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.DocumentProcessingConfig document_processing_config = 27;
     * </code>
     */
    public com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.Builder
        getDocumentProcessingConfigBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getDocumentProcessingConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configuration for Document understanding and enrichment.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.DocumentProcessingConfig document_processing_config = 27;
     * </code>
     */
    public com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfigOrBuilder
        getDocumentProcessingConfigOrBuilder() {
      if (documentProcessingConfigBuilder_ != null) {
        return documentProcessingConfigBuilder_.getMessageOrBuilder();
      } else {
        return documentProcessingConfig_ == null
            ? com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.getDefaultInstance()
            : documentProcessingConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for Document understanding and enrichment.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.DocumentProcessingConfig document_processing_config = 27;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig,
            com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.Builder,
            com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfigOrBuilder>
        getDocumentProcessingConfigFieldBuilder() {
      if (documentProcessingConfigBuilder_ == null) {
        documentProcessingConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig,
                com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfig.Builder,
                com.google.cloud.discoveryengine.v1beta.DocumentProcessingConfigOrBuilder>(
                getDocumentProcessingConfig(), getParentForChildren(), isClean());
        documentProcessingConfig_ = null;
      }
      return documentProcessingConfigBuilder_;
    }

    private com.google.cloud.discoveryengine.v1beta.Schema startingSchema_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1beta.Schema,
            com.google.cloud.discoveryengine.v1beta.Schema.Builder,
            com.google.cloud.discoveryengine.v1beta.SchemaOrBuilder>
        startingSchemaBuilder_;
    /**
     *
     *
     * <pre>
     * The start schema to use for this
     * [DataStore][google.cloud.discoveryengine.v1beta.DataStore] when
     * provisioning it. If unset, a default vertical specialized schema will be
     * used.
     *
     * This field is only used by [CreateDataStore][] API, and will be ignored if
     * used in other APIs. This field will be omitted from all API responses
     * including [CreateDataStore][] API. To retrieve a schema of a
     * [DataStore][google.cloud.discoveryengine.v1beta.DataStore], use
     * [SchemaService.GetSchema][google.cloud.discoveryengine.v1beta.SchemaService.GetSchema]
     * API instead.
     *
     * The provided schema will be validated against certain rules on schema.
     * Learn more from [this
     * doc](https://cloud.google.com/generative-ai-app-builder/docs/provide-schema).
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.Schema starting_schema = 28;</code>
     *
     * @return Whether the startingSchema field is set.
     */
    public boolean hasStartingSchema() {
      return ((bitField0_ & 0x00000200) != 0);
    }
    /**
     *
     *
     * <pre>
     * The start schema to use for this
     * [DataStore][google.cloud.discoveryengine.v1beta.DataStore] when
     * provisioning it. If unset, a default vertical specialized schema will be
     * used.
     *
     * This field is only used by [CreateDataStore][] API, and will be ignored if
     * used in other APIs. This field will be omitted from all API responses
     * including [CreateDataStore][] API. To retrieve a schema of a
     * [DataStore][google.cloud.discoveryengine.v1beta.DataStore], use
     * [SchemaService.GetSchema][google.cloud.discoveryengine.v1beta.SchemaService.GetSchema]
     * API instead.
     *
     * The provided schema will be validated against certain rules on schema.
     * Learn more from [this
     * doc](https://cloud.google.com/generative-ai-app-builder/docs/provide-schema).
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.Schema starting_schema = 28;</code>
     *
     * @return The startingSchema.
     */
    public com.google.cloud.discoveryengine.v1beta.Schema getStartingSchema() {
      if (startingSchemaBuilder_ == null) {
        return startingSchema_ == null
            ? com.google.cloud.discoveryengine.v1beta.Schema.getDefaultInstance()
            : startingSchema_;
      } else {
        return startingSchemaBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The start schema to use for this
     * [DataStore][google.cloud.discoveryengine.v1beta.DataStore] when
     * provisioning it. If unset, a default vertical specialized schema will be
     * used.
     *
     * This field is only used by [CreateDataStore][] API, and will be ignored if
     * used in other APIs. This field will be omitted from all API responses
     * including [CreateDataStore][] API. To retrieve a schema of a
     * [DataStore][google.cloud.discoveryengine.v1beta.DataStore], use
     * [SchemaService.GetSchema][google.cloud.discoveryengine.v1beta.SchemaService.GetSchema]
     * API instead.
     *
     * The provided schema will be validated against certain rules on schema.
     * Learn more from [this
     * doc](https://cloud.google.com/generative-ai-app-builder/docs/provide-schema).
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.Schema starting_schema = 28;</code>
     */
    public Builder setStartingSchema(com.google.cloud.discoveryengine.v1beta.Schema value) {
      if (startingSchemaBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        startingSchema_ = value;
      } else {
        startingSchemaBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The start schema to use for this
     * [DataStore][google.cloud.discoveryengine.v1beta.DataStore] when
     * provisioning it. If unset, a default vertical specialized schema will be
     * used.
     *
     * This field is only used by [CreateDataStore][] API, and will be ignored if
     * used in other APIs. This field will be omitted from all API responses
     * including [CreateDataStore][] API. To retrieve a schema of a
     * [DataStore][google.cloud.discoveryengine.v1beta.DataStore], use
     * [SchemaService.GetSchema][google.cloud.discoveryengine.v1beta.SchemaService.GetSchema]
     * API instead.
     *
     * The provided schema will be validated against certain rules on schema.
     * Learn more from [this
     * doc](https://cloud.google.com/generative-ai-app-builder/docs/provide-schema).
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.Schema starting_schema = 28;</code>
     */
    public Builder setStartingSchema(
        com.google.cloud.discoveryengine.v1beta.Schema.Builder builderForValue) {
      if (startingSchemaBuilder_ == null) {
        startingSchema_ = builderForValue.build();
      } else {
        startingSchemaBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The start schema to use for this
     * [DataStore][google.cloud.discoveryengine.v1beta.DataStore] when
     * provisioning it. If unset, a default vertical specialized schema will be
     * used.
     *
     * This field is only used by [CreateDataStore][] API, and will be ignored if
     * used in other APIs. This field will be omitted from all API responses
     * including [CreateDataStore][] API. To retrieve a schema of a
     * [DataStore][google.cloud.discoveryengine.v1beta.DataStore], use
     * [SchemaService.GetSchema][google.cloud.discoveryengine.v1beta.SchemaService.GetSchema]
     * API instead.
     *
     * The provided schema will be validated against certain rules on schema.
     * Learn more from [this
     * doc](https://cloud.google.com/generative-ai-app-builder/docs/provide-schema).
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.Schema starting_schema = 28;</code>
     */
    public Builder mergeStartingSchema(com.google.cloud.discoveryengine.v1beta.Schema value) {
      if (startingSchemaBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)
            && startingSchema_ != null
            && startingSchema_
                != com.google.cloud.discoveryengine.v1beta.Schema.getDefaultInstance()) {
          getStartingSchemaBuilder().mergeFrom(value);
        } else {
          startingSchema_ = value;
        }
      } else {
        startingSchemaBuilder_.mergeFrom(value);
      }
      if (startingSchema_ != null) {
        bitField0_ |= 0x00000200;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The start schema to use for this
     * [DataStore][google.cloud.discoveryengine.v1beta.DataStore] when
     * provisioning it. If unset, a default vertical specialized schema will be
     * used.
     *
     * This field is only used by [CreateDataStore][] API, and will be ignored if
     * used in other APIs. This field will be omitted from all API responses
     * including [CreateDataStore][] API. To retrieve a schema of a
     * [DataStore][google.cloud.discoveryengine.v1beta.DataStore], use
     * [SchemaService.GetSchema][google.cloud.discoveryengine.v1beta.SchemaService.GetSchema]
     * API instead.
     *
     * The provided schema will be validated against certain rules on schema.
     * Learn more from [this
     * doc](https://cloud.google.com/generative-ai-app-builder/docs/provide-schema).
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.Schema starting_schema = 28;</code>
     */
    public Builder clearStartingSchema() {
      bitField0_ = (bitField0_ & ~0x00000200);
      startingSchema_ = null;
      if (startingSchemaBuilder_ != null) {
        startingSchemaBuilder_.dispose();
        startingSchemaBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The start schema to use for this
     * [DataStore][google.cloud.discoveryengine.v1beta.DataStore] when
     * provisioning it. If unset, a default vertical specialized schema will be
     * used.
     *
     * This field is only used by [CreateDataStore][] API, and will be ignored if
     * used in other APIs. This field will be omitted from all API responses
     * including [CreateDataStore][] API. To retrieve a schema of a
     * [DataStore][google.cloud.discoveryengine.v1beta.DataStore], use
     * [SchemaService.GetSchema][google.cloud.discoveryengine.v1beta.SchemaService.GetSchema]
     * API instead.
     *
     * The provided schema will be validated against certain rules on schema.
     * Learn more from [this
     * doc](https://cloud.google.com/generative-ai-app-builder/docs/provide-schema).
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.Schema starting_schema = 28;</code>
     */
    public com.google.cloud.discoveryengine.v1beta.Schema.Builder getStartingSchemaBuilder() {
      bitField0_ |= 0x00000200;
      onChanged();
      return getStartingSchemaFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The start schema to use for this
     * [DataStore][google.cloud.discoveryengine.v1beta.DataStore] when
     * provisioning it. If unset, a default vertical specialized schema will be
     * used.
     *
     * This field is only used by [CreateDataStore][] API, and will be ignored if
     * used in other APIs. This field will be omitted from all API responses
     * including [CreateDataStore][] API. To retrieve a schema of a
     * [DataStore][google.cloud.discoveryengine.v1beta.DataStore], use
     * [SchemaService.GetSchema][google.cloud.discoveryengine.v1beta.SchemaService.GetSchema]
     * API instead.
     *
     * The provided schema will be validated against certain rules on schema.
     * Learn more from [this
     * doc](https://cloud.google.com/generative-ai-app-builder/docs/provide-schema).
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.Schema starting_schema = 28;</code>
     */
    public com.google.cloud.discoveryengine.v1beta.SchemaOrBuilder getStartingSchemaOrBuilder() {
      if (startingSchemaBuilder_ != null) {
        return startingSchemaBuilder_.getMessageOrBuilder();
      } else {
        return startingSchema_ == null
            ? com.google.cloud.discoveryengine.v1beta.Schema.getDefaultInstance()
            : startingSchema_;
      }
    }
    /**
     *
     *
     * <pre>
     * The start schema to use for this
     * [DataStore][google.cloud.discoveryengine.v1beta.DataStore] when
     * provisioning it. If unset, a default vertical specialized schema will be
     * used.
     *
     * This field is only used by [CreateDataStore][] API, and will be ignored if
     * used in other APIs. This field will be omitted from all API responses
     * including [CreateDataStore][] API. To retrieve a schema of a
     * [DataStore][google.cloud.discoveryengine.v1beta.DataStore], use
     * [SchemaService.GetSchema][google.cloud.discoveryengine.v1beta.SchemaService.GetSchema]
     * API instead.
     *
     * The provided schema will be validated against certain rules on schema.
     * Learn more from [this
     * doc](https://cloud.google.com/generative-ai-app-builder/docs/provide-schema).
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.Schema starting_schema = 28;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1beta.Schema,
            com.google.cloud.discoveryengine.v1beta.Schema.Builder,
            com.google.cloud.discoveryengine.v1beta.SchemaOrBuilder>
        getStartingSchemaFieldBuilder() {
      if (startingSchemaBuilder_ == null) {
        startingSchemaBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1beta.Schema,
                com.google.cloud.discoveryengine.v1beta.Schema.Builder,
                com.google.cloud.discoveryengine.v1beta.SchemaOrBuilder>(
                getStartingSchema(), getParentForChildren(), isClean());
        startingSchema_ = null;
      }
      return startingSchemaBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.DataStore)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.DataStore)
  private static final com.google.cloud.discoveryengine.v1beta.DataStore DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.discoveryengine.v1beta.DataStore();
  }

  public static com.google.cloud.discoveryengine.v1beta.DataStore getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<DataStore> PARSER =
      new com.google.protobuf.AbstractParser<DataStore>() {
        @java.lang.Override
        public DataStore parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<DataStore> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<DataStore> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.DataStore getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
