/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/discoveryengine/v1beta/evaluation.proto

// Protobuf Java Version: 3.25.4
package com.google.cloud.discoveryengine.v1beta;

/**
 *
 *
 * <pre>
 * Describes the metrics produced by the evaluation.
 * </pre>
 *
 * Protobuf type {@code google.cloud.discoveryengine.v1beta.QualityMetrics}
 */
public final class QualityMetrics extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.QualityMetrics)
    QualityMetricsOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use QualityMetrics.newBuilder() to construct.
  private QualityMetrics(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private QualityMetrics() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new QualityMetrics();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.discoveryengine.v1beta.EvaluationProto
        .internal_static_google_cloud_discoveryengine_v1beta_QualityMetrics_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.discoveryengine.v1beta.EvaluationProto
        .internal_static_google_cloud_discoveryengine_v1beta_QualityMetrics_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.discoveryengine.v1beta.QualityMetrics.class,
            com.google.cloud.discoveryengine.v1beta.QualityMetrics.Builder.class);
  }

  public interface TopkMetricsOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The top-1 value.
     * </pre>
     *
     * <code>double top_1 = 1;</code>
     *
     * @return The top1.
     */
    double getTop1();

    /**
     *
     *
     * <pre>
     * The top-3 value.
     * </pre>
     *
     * <code>double top_3 = 2;</code>
     *
     * @return The top3.
     */
    double getTop3();

    /**
     *
     *
     * <pre>
     * The top-5 value.
     * </pre>
     *
     * <code>double top_5 = 3;</code>
     *
     * @return The top5.
     */
    double getTop5();

    /**
     *
     *
     * <pre>
     * The top-10 value.
     * </pre>
     *
     * <code>double top_10 = 4;</code>
     *
     * @return The top10.
     */
    double getTop10();
  }
  /**
   *
   *
   * <pre>
   * Stores the metric values at specific top-k levels.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics}
   */
  public static final class TopkMetrics extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics)
      TopkMetricsOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use TopkMetrics.newBuilder() to construct.
    private TopkMetrics(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private TopkMetrics() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new TopkMetrics();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1beta.EvaluationProto
          .internal_static_google_cloud_discoveryengine_v1beta_QualityMetrics_TopkMetrics_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1beta.EvaluationProto
          .internal_static_google_cloud_discoveryengine_v1beta_QualityMetrics_TopkMetrics_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics.class,
              com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics.Builder.class);
    }

    public static final int TOP_1_FIELD_NUMBER = 1;
    private double top1_ = 0D;
    /**
     *
     *
     * <pre>
     * The top-1 value.
     * </pre>
     *
     * <code>double top_1 = 1;</code>
     *
     * @return The top1.
     */
    @java.lang.Override
    public double getTop1() {
      return top1_;
    }

    public static final int TOP_3_FIELD_NUMBER = 2;
    private double top3_ = 0D;
    /**
     *
     *
     * <pre>
     * The top-3 value.
     * </pre>
     *
     * <code>double top_3 = 2;</code>
     *
     * @return The top3.
     */
    @java.lang.Override
    public double getTop3() {
      return top3_;
    }

    public static final int TOP_5_FIELD_NUMBER = 3;
    private double top5_ = 0D;
    /**
     *
     *
     * <pre>
     * The top-5 value.
     * </pre>
     *
     * <code>double top_5 = 3;</code>
     *
     * @return The top5.
     */
    @java.lang.Override
    public double getTop5() {
      return top5_;
    }

    public static final int TOP_10_FIELD_NUMBER = 4;
    private double top10_ = 0D;
    /**
     *
     *
     * <pre>
     * The top-10 value.
     * </pre>
     *
     * <code>double top_10 = 4;</code>
     *
     * @return The top10.
     */
    @java.lang.Override
    public double getTop10() {
      return top10_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (java.lang.Double.doubleToRawLongBits(top1_) != 0) {
        output.writeDouble(1, top1_);
      }
      if (java.lang.Double.doubleToRawLongBits(top3_) != 0) {
        output.writeDouble(2, top3_);
      }
      if (java.lang.Double.doubleToRawLongBits(top5_) != 0) {
        output.writeDouble(3, top5_);
      }
      if (java.lang.Double.doubleToRawLongBits(top10_) != 0) {
        output.writeDouble(4, top10_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (java.lang.Double.doubleToRawLongBits(top1_) != 0) {
        size += com.google.protobuf.CodedOutputStream.computeDoubleSize(1, top1_);
      }
      if (java.lang.Double.doubleToRawLongBits(top3_) != 0) {
        size += com.google.protobuf.CodedOutputStream.computeDoubleSize(2, top3_);
      }
      if (java.lang.Double.doubleToRawLongBits(top5_) != 0) {
        size += com.google.protobuf.CodedOutputStream.computeDoubleSize(3, top5_);
      }
      if (java.lang.Double.doubleToRawLongBits(top10_) != 0) {
        size += com.google.protobuf.CodedOutputStream.computeDoubleSize(4, top10_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics)) {
        return super.equals(obj);
      }
      com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics other =
          (com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics) obj;

      if (java.lang.Double.doubleToLongBits(getTop1())
          != java.lang.Double.doubleToLongBits(other.getTop1())) return false;
      if (java.lang.Double.doubleToLongBits(getTop3())
          != java.lang.Double.doubleToLongBits(other.getTop3())) return false;
      if (java.lang.Double.doubleToLongBits(getTop5())
          != java.lang.Double.doubleToLongBits(other.getTop5())) return false;
      if (java.lang.Double.doubleToLongBits(getTop10())
          != java.lang.Double.doubleToLongBits(other.getTop10())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + TOP_1_FIELD_NUMBER;
      hash =
          (53 * hash)
              + com.google.protobuf.Internal.hashLong(java.lang.Double.doubleToLongBits(getTop1()));
      hash = (37 * hash) + TOP_3_FIELD_NUMBER;
      hash =
          (53 * hash)
              + com.google.protobuf.Internal.hashLong(java.lang.Double.doubleToLongBits(getTop3()));
      hash = (37 * hash) + TOP_5_FIELD_NUMBER;
      hash =
          (53 * hash)
              + com.google.protobuf.Internal.hashLong(java.lang.Double.doubleToLongBits(getTop5()));
      hash = (37 * hash) + TOP_10_FIELD_NUMBER;
      hash =
          (53 * hash)
              + com.google.protobuf.Internal.hashLong(
                  java.lang.Double.doubleToLongBits(getTop10()));
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Stores the metric values at specific top-k levels.
     * </pre>
     *
     * Protobuf type {@code google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics)
        com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetricsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1beta.EvaluationProto
            .internal_static_google_cloud_discoveryengine_v1beta_QualityMetrics_TopkMetrics_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1beta.EvaluationProto
            .internal_static_google_cloud_discoveryengine_v1beta_QualityMetrics_TopkMetrics_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics.class,
                com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics.Builder.class);
      }

      // Construct using
      // com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        top1_ = 0D;
        top3_ = 0D;
        top5_ = 0D;
        top10_ = 0D;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.discoveryengine.v1beta.EvaluationProto
            .internal_static_google_cloud_discoveryengine_v1beta_QualityMetrics_TopkMetrics_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics
          getDefaultInstanceForType() {
        return com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics build() {
        com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics buildPartial() {
        com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics result =
            new com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.top1_ = top1_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.top3_ = top3_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.top5_ = top5_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.top10_ = top10_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics) {
          return mergeFrom(
              (com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics other) {
        if (other
            == com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics
                .getDefaultInstance()) return this;
        if (other.getTop1() != 0D) {
          setTop1(other.getTop1());
        }
        if (other.getTop3() != 0D) {
          setTop3(other.getTop3());
        }
        if (other.getTop5() != 0D) {
          setTop5(other.getTop5());
        }
        if (other.getTop10() != 0D) {
          setTop10(other.getTop10());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 9:
                {
                  top1_ = input.readDouble();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 9
              case 17:
                {
                  top3_ = input.readDouble();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 17
              case 25:
                {
                  top5_ = input.readDouble();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 25
              case 33:
                {
                  top10_ = input.readDouble();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 33
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private double top1_;
      /**
       *
       *
       * <pre>
       * The top-1 value.
       * </pre>
       *
       * <code>double top_1 = 1;</code>
       *
       * @return The top1.
       */
      @java.lang.Override
      public double getTop1() {
        return top1_;
      }
      /**
       *
       *
       * <pre>
       * The top-1 value.
       * </pre>
       *
       * <code>double top_1 = 1;</code>
       *
       * @param value The top1 to set.
       * @return This builder for chaining.
       */
      public Builder setTop1(double value) {

        top1_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The top-1 value.
       * </pre>
       *
       * <code>double top_1 = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTop1() {
        bitField0_ = (bitField0_ & ~0x00000001);
        top1_ = 0D;
        onChanged();
        return this;
      }

      private double top3_;
      /**
       *
       *
       * <pre>
       * The top-3 value.
       * </pre>
       *
       * <code>double top_3 = 2;</code>
       *
       * @return The top3.
       */
      @java.lang.Override
      public double getTop3() {
        return top3_;
      }
      /**
       *
       *
       * <pre>
       * The top-3 value.
       * </pre>
       *
       * <code>double top_3 = 2;</code>
       *
       * @param value The top3 to set.
       * @return This builder for chaining.
       */
      public Builder setTop3(double value) {

        top3_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The top-3 value.
       * </pre>
       *
       * <code>double top_3 = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTop3() {
        bitField0_ = (bitField0_ & ~0x00000002);
        top3_ = 0D;
        onChanged();
        return this;
      }

      private double top5_;
      /**
       *
       *
       * <pre>
       * The top-5 value.
       * </pre>
       *
       * <code>double top_5 = 3;</code>
       *
       * @return The top5.
       */
      @java.lang.Override
      public double getTop5() {
        return top5_;
      }
      /**
       *
       *
       * <pre>
       * The top-5 value.
       * </pre>
       *
       * <code>double top_5 = 3;</code>
       *
       * @param value The top5 to set.
       * @return This builder for chaining.
       */
      public Builder setTop5(double value) {

        top5_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The top-5 value.
       * </pre>
       *
       * <code>double top_5 = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTop5() {
        bitField0_ = (bitField0_ & ~0x00000004);
        top5_ = 0D;
        onChanged();
        return this;
      }

      private double top10_;
      /**
       *
       *
       * <pre>
       * The top-10 value.
       * </pre>
       *
       * <code>double top_10 = 4;</code>
       *
       * @return The top10.
       */
      @java.lang.Override
      public double getTop10() {
        return top10_;
      }
      /**
       *
       *
       * <pre>
       * The top-10 value.
       * </pre>
       *
       * <code>double top_10 = 4;</code>
       *
       * @param value The top10 to set.
       * @return This builder for chaining.
       */
      public Builder setTop10(double value) {

        top10_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The top-10 value.
       * </pre>
       *
       * <code>double top_10 = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTop10() {
        bitField0_ = (bitField0_ & ~0x00000008);
        top10_ = 0D;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics)
    private static final com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics();
    }

    public static com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<TopkMetrics> PARSER =
        new com.google.protobuf.AbstractParser<TopkMetrics>() {
          @java.lang.Override
          public TopkMetrics parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<TopkMetrics> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<TopkMetrics> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int DOC_RECALL_FIELD_NUMBER = 1;
  private com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics docRecall_;
  /**
   *
   *
   * <pre>
   * Recall per document, at various top-k cutoff levels.
   *
   * Recall is the fraction of relevant documents retrieved out of all
   * relevant documents.
   *
   * Example (top-5):
   *  * For a single
   *  [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery], If 3 out
   *  of 5 relevant documents are retrieved in the top-5, recall&#64;5 = 3/5 = 0.6
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics doc_recall = 1;</code>
   *
   * @return Whether the docRecall field is set.
   */
  @java.lang.Override
  public boolean hasDocRecall() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Recall per document, at various top-k cutoff levels.
   *
   * Recall is the fraction of relevant documents retrieved out of all
   * relevant documents.
   *
   * Example (top-5):
   *  * For a single
   *  [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery], If 3 out
   *  of 5 relevant documents are retrieved in the top-5, recall&#64;5 = 3/5 = 0.6
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics doc_recall = 1;</code>
   *
   * @return The docRecall.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics getDocRecall() {
    return docRecall_ == null
        ? com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics.getDefaultInstance()
        : docRecall_;
  }
  /**
   *
   *
   * <pre>
   * Recall per document, at various top-k cutoff levels.
   *
   * Recall is the fraction of relevant documents retrieved out of all
   * relevant documents.
   *
   * Example (top-5):
   *  * For a single
   *  [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery], If 3 out
   *  of 5 relevant documents are retrieved in the top-5, recall&#64;5 = 3/5 = 0.6
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics doc_recall = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetricsOrBuilder
      getDocRecallOrBuilder() {
    return docRecall_ == null
        ? com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics.getDefaultInstance()
        : docRecall_;
  }

  public static final int DOC_PRECISION_FIELD_NUMBER = 2;
  private com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics docPrecision_;
  /**
   *
   *
   * <pre>
   * Precision per document, at various top-k cutoff levels.
   *
   * Precision is the fraction of retrieved documents that are relevant.
   *
   * Example (top-5):
   *  * For a single
   *  [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery], If 4 out
   *  of 5 retrieved documents in the top-5 are relevant, precision&#64;5 = 4/5 =
   *  0.8
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics doc_precision = 2;</code>
   *
   * @return Whether the docPrecision field is set.
   */
  @java.lang.Override
  public boolean hasDocPrecision() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Precision per document, at various top-k cutoff levels.
   *
   * Precision is the fraction of retrieved documents that are relevant.
   *
   * Example (top-5):
   *  * For a single
   *  [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery], If 4 out
   *  of 5 retrieved documents in the top-5 are relevant, precision&#64;5 = 4/5 =
   *  0.8
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics doc_precision = 2;</code>
   *
   * @return The docPrecision.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics getDocPrecision() {
    return docPrecision_ == null
        ? com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics.getDefaultInstance()
        : docPrecision_;
  }
  /**
   *
   *
   * <pre>
   * Precision per document, at various top-k cutoff levels.
   *
   * Precision is the fraction of retrieved documents that are relevant.
   *
   * Example (top-5):
   *  * For a single
   *  [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery], If 4 out
   *  of 5 retrieved documents in the top-5 are relevant, precision&#64;5 = 4/5 =
   *  0.8
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics doc_precision = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetricsOrBuilder
      getDocPrecisionOrBuilder() {
    return docPrecision_ == null
        ? com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics.getDefaultInstance()
        : docPrecision_;
  }

  public static final int DOC_NDCG_FIELD_NUMBER = 3;
  private com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics docNdcg_;
  /**
   *
   *
   * <pre>
   * Normalized discounted cumulative gain (NDCG) per document, at various top-k
   * cutoff levels.
   *
   * NDCG measures the ranking quality, giving higher relevance to top
   * results.
   *
   * Example (top-3):
   *  Suppose [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery]
   *  with three retrieved documents (D1, D2, D3) and binary relevance
   *  judgements (1 for relevant, 0 for not relevant):
   *
   *   Retrieved:  [D3 (0), D1 (1), D2 (1)]
   *   Ideal:      [D1 (1), D2 (1), D3 (0)]
   *
   *   Calculate NDCG&#64;3 for each
   *   [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery]:
   *    * DCG&#64;3: 0/log2(1+1) + 1/log2(2+1) + 1/log2(3+1) = 1.13
   *    * Ideal DCG&#64;3: 1/log2(1+1) + 1/log2(2+1) + 0/log2(3+1) = 1.63
   *    * NDCG&#64;3: 1.13/1.63 = 0.693
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics doc_ndcg = 3;</code>
   *
   * @return Whether the docNdcg field is set.
   */
  @java.lang.Override
  public boolean hasDocNdcg() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Normalized discounted cumulative gain (NDCG) per document, at various top-k
   * cutoff levels.
   *
   * NDCG measures the ranking quality, giving higher relevance to top
   * results.
   *
   * Example (top-3):
   *  Suppose [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery]
   *  with three retrieved documents (D1, D2, D3) and binary relevance
   *  judgements (1 for relevant, 0 for not relevant):
   *
   *   Retrieved:  [D3 (0), D1 (1), D2 (1)]
   *   Ideal:      [D1 (1), D2 (1), D3 (0)]
   *
   *   Calculate NDCG&#64;3 for each
   *   [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery]:
   *    * DCG&#64;3: 0/log2(1+1) + 1/log2(2+1) + 1/log2(3+1) = 1.13
   *    * Ideal DCG&#64;3: 1/log2(1+1) + 1/log2(2+1) + 0/log2(3+1) = 1.63
   *    * NDCG&#64;3: 1.13/1.63 = 0.693
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics doc_ndcg = 3;</code>
   *
   * @return The docNdcg.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics getDocNdcg() {
    return docNdcg_ == null
        ? com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics.getDefaultInstance()
        : docNdcg_;
  }
  /**
   *
   *
   * <pre>
   * Normalized discounted cumulative gain (NDCG) per document, at various top-k
   * cutoff levels.
   *
   * NDCG measures the ranking quality, giving higher relevance to top
   * results.
   *
   * Example (top-3):
   *  Suppose [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery]
   *  with three retrieved documents (D1, D2, D3) and binary relevance
   *  judgements (1 for relevant, 0 for not relevant):
   *
   *   Retrieved:  [D3 (0), D1 (1), D2 (1)]
   *   Ideal:      [D1 (1), D2 (1), D3 (0)]
   *
   *   Calculate NDCG&#64;3 for each
   *   [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery]:
   *    * DCG&#64;3: 0/log2(1+1) + 1/log2(2+1) + 1/log2(3+1) = 1.13
   *    * Ideal DCG&#64;3: 1/log2(1+1) + 1/log2(2+1) + 0/log2(3+1) = 1.63
   *    * NDCG&#64;3: 1.13/1.63 = 0.693
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics doc_ndcg = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetricsOrBuilder
      getDocNdcgOrBuilder() {
    return docNdcg_ == null
        ? com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics.getDefaultInstance()
        : docNdcg_;
  }

  public static final int PAGE_RECALL_FIELD_NUMBER = 4;
  private com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics pageRecall_;
  /**
   *
   *
   * <pre>
   * Recall per page, at various top-k cutoff levels.
   *
   * Recall is the fraction of relevant pages retrieved out of all relevant
   * pages.
   *
   * Example (top-5):
   *  * For a single
   *  [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery], if 3 out
   *  of 5 relevant pages are retrieved in the top-5, recall&#64;5 = 3/5 = 0.6
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics page_recall = 4;</code>
   *
   * @return Whether the pageRecall field is set.
   */
  @java.lang.Override
  public boolean hasPageRecall() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * Recall per page, at various top-k cutoff levels.
   *
   * Recall is the fraction of relevant pages retrieved out of all relevant
   * pages.
   *
   * Example (top-5):
   *  * For a single
   *  [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery], if 3 out
   *  of 5 relevant pages are retrieved in the top-5, recall&#64;5 = 3/5 = 0.6
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics page_recall = 4;</code>
   *
   * @return The pageRecall.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics getPageRecall() {
    return pageRecall_ == null
        ? com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics.getDefaultInstance()
        : pageRecall_;
  }
  /**
   *
   *
   * <pre>
   * Recall per page, at various top-k cutoff levels.
   *
   * Recall is the fraction of relevant pages retrieved out of all relevant
   * pages.
   *
   * Example (top-5):
   *  * For a single
   *  [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery], if 3 out
   *  of 5 relevant pages are retrieved in the top-5, recall&#64;5 = 3/5 = 0.6
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics page_recall = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetricsOrBuilder
      getPageRecallOrBuilder() {
    return pageRecall_ == null
        ? com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics.getDefaultInstance()
        : pageRecall_;
  }

  public static final int PAGE_NDCG_FIELD_NUMBER = 5;
  private com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics pageNdcg_;
  /**
   *
   *
   * <pre>
   * Normalized discounted cumulative gain (NDCG) per page, at various top-k
   * cutoff levels.
   *
   * NDCG measures the ranking quality, giving higher relevance to top
   * results.
   *
   * Example (top-3):
   *  Suppose [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery]
   *  with three retrieved pages (P1, P2, P3) and binary relevance judgements (1
   *  for relevant, 0 for not relevant):
   *
   *   Retrieved:  [P3 (0), P1 (1), P2 (1)]
   *   Ideal:      [P1 (1), P2 (1), P3 (0)]
   *
   *   Calculate NDCG&#64;3 for
   *   [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery]:
   *    * DCG&#64;3: 0/log2(1+1) + 1/log2(2+1) + 1/log2(3+1) = 1.13
   *    * Ideal DCG&#64;3: 1/log2(1+1) + 1/log2(2+1) + 0/log2(3+1) = 1.63
   *    * NDCG&#64;3: 1.13/1.63 = 0.693
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics page_ndcg = 5;</code>
   *
   * @return Whether the pageNdcg field is set.
   */
  @java.lang.Override
  public boolean hasPageNdcg() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   *
   *
   * <pre>
   * Normalized discounted cumulative gain (NDCG) per page, at various top-k
   * cutoff levels.
   *
   * NDCG measures the ranking quality, giving higher relevance to top
   * results.
   *
   * Example (top-3):
   *  Suppose [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery]
   *  with three retrieved pages (P1, P2, P3) and binary relevance judgements (1
   *  for relevant, 0 for not relevant):
   *
   *   Retrieved:  [P3 (0), P1 (1), P2 (1)]
   *   Ideal:      [P1 (1), P2 (1), P3 (0)]
   *
   *   Calculate NDCG&#64;3 for
   *   [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery]:
   *    * DCG&#64;3: 0/log2(1+1) + 1/log2(2+1) + 1/log2(3+1) = 1.13
   *    * Ideal DCG&#64;3: 1/log2(1+1) + 1/log2(2+1) + 0/log2(3+1) = 1.63
   *    * NDCG&#64;3: 1.13/1.63 = 0.693
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics page_ndcg = 5;</code>
   *
   * @return The pageNdcg.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics getPageNdcg() {
    return pageNdcg_ == null
        ? com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics.getDefaultInstance()
        : pageNdcg_;
  }
  /**
   *
   *
   * <pre>
   * Normalized discounted cumulative gain (NDCG) per page, at various top-k
   * cutoff levels.
   *
   * NDCG measures the ranking quality, giving higher relevance to top
   * results.
   *
   * Example (top-3):
   *  Suppose [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery]
   *  with three retrieved pages (P1, P2, P3) and binary relevance judgements (1
   *  for relevant, 0 for not relevant):
   *
   *   Retrieved:  [P3 (0), P1 (1), P2 (1)]
   *   Ideal:      [P1 (1), P2 (1), P3 (0)]
   *
   *   Calculate NDCG&#64;3 for
   *   [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery]:
   *    * DCG&#64;3: 0/log2(1+1) + 1/log2(2+1) + 1/log2(3+1) = 1.13
   *    * Ideal DCG&#64;3: 1/log2(1+1) + 1/log2(2+1) + 0/log2(3+1) = 1.63
   *    * NDCG&#64;3: 1.13/1.63 = 0.693
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics page_ndcg = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetricsOrBuilder
      getPageNdcgOrBuilder() {
    return pageNdcg_ == null
        ? com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics.getDefaultInstance()
        : pageNdcg_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getDocRecall());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(2, getDocPrecision());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(3, getDocNdcg());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(4, getPageRecall());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeMessage(5, getPageNdcg());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getDocRecall());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getDocPrecision());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getDocNdcg());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getPageRecall());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getPageNdcg());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.discoveryengine.v1beta.QualityMetrics)) {
      return super.equals(obj);
    }
    com.google.cloud.discoveryengine.v1beta.QualityMetrics other =
        (com.google.cloud.discoveryengine.v1beta.QualityMetrics) obj;

    if (hasDocRecall() != other.hasDocRecall()) return false;
    if (hasDocRecall()) {
      if (!getDocRecall().equals(other.getDocRecall())) return false;
    }
    if (hasDocPrecision() != other.hasDocPrecision()) return false;
    if (hasDocPrecision()) {
      if (!getDocPrecision().equals(other.getDocPrecision())) return false;
    }
    if (hasDocNdcg() != other.hasDocNdcg()) return false;
    if (hasDocNdcg()) {
      if (!getDocNdcg().equals(other.getDocNdcg())) return false;
    }
    if (hasPageRecall() != other.hasPageRecall()) return false;
    if (hasPageRecall()) {
      if (!getPageRecall().equals(other.getPageRecall())) return false;
    }
    if (hasPageNdcg() != other.hasPageNdcg()) return false;
    if (hasPageNdcg()) {
      if (!getPageNdcg().equals(other.getPageNdcg())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasDocRecall()) {
      hash = (37 * hash) + DOC_RECALL_FIELD_NUMBER;
      hash = (53 * hash) + getDocRecall().hashCode();
    }
    if (hasDocPrecision()) {
      hash = (37 * hash) + DOC_PRECISION_FIELD_NUMBER;
      hash = (53 * hash) + getDocPrecision().hashCode();
    }
    if (hasDocNdcg()) {
      hash = (37 * hash) + DOC_NDCG_FIELD_NUMBER;
      hash = (53 * hash) + getDocNdcg().hashCode();
    }
    if (hasPageRecall()) {
      hash = (37 * hash) + PAGE_RECALL_FIELD_NUMBER;
      hash = (53 * hash) + getPageRecall().hashCode();
    }
    if (hasPageNdcg()) {
      hash = (37 * hash) + PAGE_NDCG_FIELD_NUMBER;
      hash = (53 * hash) + getPageNdcg().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.discoveryengine.v1beta.QualityMetrics parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1beta.QualityMetrics parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.QualityMetrics parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1beta.QualityMetrics parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.QualityMetrics parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1beta.QualityMetrics parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.QualityMetrics parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1beta.QualityMetrics parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.QualityMetrics parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1beta.QualityMetrics parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.QualityMetrics parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1beta.QualityMetrics parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.discoveryengine.v1beta.QualityMetrics prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Describes the metrics produced by the evaluation.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1beta.QualityMetrics}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.QualityMetrics)
      com.google.cloud.discoveryengine.v1beta.QualityMetricsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1beta.EvaluationProto
          .internal_static_google_cloud_discoveryengine_v1beta_QualityMetrics_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1beta.EvaluationProto
          .internal_static_google_cloud_discoveryengine_v1beta_QualityMetrics_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1beta.QualityMetrics.class,
              com.google.cloud.discoveryengine.v1beta.QualityMetrics.Builder.class);
    }

    // Construct using com.google.cloud.discoveryengine.v1beta.QualityMetrics.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getDocRecallFieldBuilder();
        getDocPrecisionFieldBuilder();
        getDocNdcgFieldBuilder();
        getPageRecallFieldBuilder();
        getPageNdcgFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      docRecall_ = null;
      if (docRecallBuilder_ != null) {
        docRecallBuilder_.dispose();
        docRecallBuilder_ = null;
      }
      docPrecision_ = null;
      if (docPrecisionBuilder_ != null) {
        docPrecisionBuilder_.dispose();
        docPrecisionBuilder_ = null;
      }
      docNdcg_ = null;
      if (docNdcgBuilder_ != null) {
        docNdcgBuilder_.dispose();
        docNdcgBuilder_ = null;
      }
      pageRecall_ = null;
      if (pageRecallBuilder_ != null) {
        pageRecallBuilder_.dispose();
        pageRecallBuilder_ = null;
      }
      pageNdcg_ = null;
      if (pageNdcgBuilder_ != null) {
        pageNdcgBuilder_.dispose();
        pageNdcgBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.discoveryengine.v1beta.EvaluationProto
          .internal_static_google_cloud_discoveryengine_v1beta_QualityMetrics_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.QualityMetrics getDefaultInstanceForType() {
      return com.google.cloud.discoveryengine.v1beta.QualityMetrics.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.QualityMetrics build() {
      com.google.cloud.discoveryengine.v1beta.QualityMetrics result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.QualityMetrics buildPartial() {
      com.google.cloud.discoveryengine.v1beta.QualityMetrics result =
          new com.google.cloud.discoveryengine.v1beta.QualityMetrics(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.discoveryengine.v1beta.QualityMetrics result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.docRecall_ = docRecallBuilder_ == null ? docRecall_ : docRecallBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.docPrecision_ =
            docPrecisionBuilder_ == null ? docPrecision_ : docPrecisionBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.docNdcg_ = docNdcgBuilder_ == null ? docNdcg_ : docNdcgBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.pageRecall_ = pageRecallBuilder_ == null ? pageRecall_ : pageRecallBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.pageNdcg_ = pageNdcgBuilder_ == null ? pageNdcg_ : pageNdcgBuilder_.build();
        to_bitField0_ |= 0x00000010;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.discoveryengine.v1beta.QualityMetrics) {
        return mergeFrom((com.google.cloud.discoveryengine.v1beta.QualityMetrics) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.discoveryengine.v1beta.QualityMetrics other) {
      if (other == com.google.cloud.discoveryengine.v1beta.QualityMetrics.getDefaultInstance())
        return this;
      if (other.hasDocRecall()) {
        mergeDocRecall(other.getDocRecall());
      }
      if (other.hasDocPrecision()) {
        mergeDocPrecision(other.getDocPrecision());
      }
      if (other.hasDocNdcg()) {
        mergeDocNdcg(other.getDocNdcg());
      }
      if (other.hasPageRecall()) {
        mergePageRecall(other.getPageRecall());
      }
      if (other.hasPageNdcg()) {
        mergePageNdcg(other.getPageNdcg());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getDocRecallFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getDocPrecisionFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getDocNdcgFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getPageRecallFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getPageNdcgFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics docRecall_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics,
            com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics.Builder,
            com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetricsOrBuilder>
        docRecallBuilder_;
    /**
     *
     *
     * <pre>
     * Recall per document, at various top-k cutoff levels.
     *
     * Recall is the fraction of relevant documents retrieved out of all
     * relevant documents.
     *
     * Example (top-5):
     *  * For a single
     *  [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery], If 3 out
     *  of 5 relevant documents are retrieved in the top-5, recall&#64;5 = 3/5 = 0.6
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics doc_recall = 1;</code>
     *
     * @return Whether the docRecall field is set.
     */
    public boolean hasDocRecall() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Recall per document, at various top-k cutoff levels.
     *
     * Recall is the fraction of relevant documents retrieved out of all
     * relevant documents.
     *
     * Example (top-5):
     *  * For a single
     *  [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery], If 3 out
     *  of 5 relevant documents are retrieved in the top-5, recall&#64;5 = 3/5 = 0.6
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics doc_recall = 1;</code>
     *
     * @return The docRecall.
     */
    public com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics getDocRecall() {
      if (docRecallBuilder_ == null) {
        return docRecall_ == null
            ? com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics
                .getDefaultInstance()
            : docRecall_;
      } else {
        return docRecallBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Recall per document, at various top-k cutoff levels.
     *
     * Recall is the fraction of relevant documents retrieved out of all
     * relevant documents.
     *
     * Example (top-5):
     *  * For a single
     *  [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery], If 3 out
     *  of 5 relevant documents are retrieved in the top-5, recall&#64;5 = 3/5 = 0.6
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics doc_recall = 1;</code>
     */
    public Builder setDocRecall(
        com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics value) {
      if (docRecallBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        docRecall_ = value;
      } else {
        docRecallBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Recall per document, at various top-k cutoff levels.
     *
     * Recall is the fraction of relevant documents retrieved out of all
     * relevant documents.
     *
     * Example (top-5):
     *  * For a single
     *  [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery], If 3 out
     *  of 5 relevant documents are retrieved in the top-5, recall&#64;5 = 3/5 = 0.6
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics doc_recall = 1;</code>
     */
    public Builder setDocRecall(
        com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics.Builder
            builderForValue) {
      if (docRecallBuilder_ == null) {
        docRecall_ = builderForValue.build();
      } else {
        docRecallBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Recall per document, at various top-k cutoff levels.
     *
     * Recall is the fraction of relevant documents retrieved out of all
     * relevant documents.
     *
     * Example (top-5):
     *  * For a single
     *  [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery], If 3 out
     *  of 5 relevant documents are retrieved in the top-5, recall&#64;5 = 3/5 = 0.6
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics doc_recall = 1;</code>
     */
    public Builder mergeDocRecall(
        com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics value) {
      if (docRecallBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && docRecall_ != null
            && docRecall_
                != com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics
                    .getDefaultInstance()) {
          getDocRecallBuilder().mergeFrom(value);
        } else {
          docRecall_ = value;
        }
      } else {
        docRecallBuilder_.mergeFrom(value);
      }
      if (docRecall_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Recall per document, at various top-k cutoff levels.
     *
     * Recall is the fraction of relevant documents retrieved out of all
     * relevant documents.
     *
     * Example (top-5):
     *  * For a single
     *  [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery], If 3 out
     *  of 5 relevant documents are retrieved in the top-5, recall&#64;5 = 3/5 = 0.6
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics doc_recall = 1;</code>
     */
    public Builder clearDocRecall() {
      bitField0_ = (bitField0_ & ~0x00000001);
      docRecall_ = null;
      if (docRecallBuilder_ != null) {
        docRecallBuilder_.dispose();
        docRecallBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Recall per document, at various top-k cutoff levels.
     *
     * Recall is the fraction of relevant documents retrieved out of all
     * relevant documents.
     *
     * Example (top-5):
     *  * For a single
     *  [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery], If 3 out
     *  of 5 relevant documents are retrieved in the top-5, recall&#64;5 = 3/5 = 0.6
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics doc_recall = 1;</code>
     */
    public com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics.Builder
        getDocRecallBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getDocRecallFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Recall per document, at various top-k cutoff levels.
     *
     * Recall is the fraction of relevant documents retrieved out of all
     * relevant documents.
     *
     * Example (top-5):
     *  * For a single
     *  [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery], If 3 out
     *  of 5 relevant documents are retrieved in the top-5, recall&#64;5 = 3/5 = 0.6
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics doc_recall = 1;</code>
     */
    public com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetricsOrBuilder
        getDocRecallOrBuilder() {
      if (docRecallBuilder_ != null) {
        return docRecallBuilder_.getMessageOrBuilder();
      } else {
        return docRecall_ == null
            ? com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics
                .getDefaultInstance()
            : docRecall_;
      }
    }
    /**
     *
     *
     * <pre>
     * Recall per document, at various top-k cutoff levels.
     *
     * Recall is the fraction of relevant documents retrieved out of all
     * relevant documents.
     *
     * Example (top-5):
     *  * For a single
     *  [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery], If 3 out
     *  of 5 relevant documents are retrieved in the top-5, recall&#64;5 = 3/5 = 0.6
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics doc_recall = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics,
            com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics.Builder,
            com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetricsOrBuilder>
        getDocRecallFieldBuilder() {
      if (docRecallBuilder_ == null) {
        docRecallBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics,
                com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics.Builder,
                com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetricsOrBuilder>(
                getDocRecall(), getParentForChildren(), isClean());
        docRecall_ = null;
      }
      return docRecallBuilder_;
    }

    private com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics docPrecision_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics,
            com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics.Builder,
            com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetricsOrBuilder>
        docPrecisionBuilder_;
    /**
     *
     *
     * <pre>
     * Precision per document, at various top-k cutoff levels.
     *
     * Precision is the fraction of retrieved documents that are relevant.
     *
     * Example (top-5):
     *  * For a single
     *  [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery], If 4 out
     *  of 5 retrieved documents in the top-5 are relevant, precision&#64;5 = 4/5 =
     *  0.8
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics doc_precision = 2;
     * </code>
     *
     * @return Whether the docPrecision field is set.
     */
    public boolean hasDocPrecision() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Precision per document, at various top-k cutoff levels.
     *
     * Precision is the fraction of retrieved documents that are relevant.
     *
     * Example (top-5):
     *  * For a single
     *  [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery], If 4 out
     *  of 5 retrieved documents in the top-5 are relevant, precision&#64;5 = 4/5 =
     *  0.8
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics doc_precision = 2;
     * </code>
     *
     * @return The docPrecision.
     */
    public com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics getDocPrecision() {
      if (docPrecisionBuilder_ == null) {
        return docPrecision_ == null
            ? com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics
                .getDefaultInstance()
            : docPrecision_;
      } else {
        return docPrecisionBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Precision per document, at various top-k cutoff levels.
     *
     * Precision is the fraction of retrieved documents that are relevant.
     *
     * Example (top-5):
     *  * For a single
     *  [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery], If 4 out
     *  of 5 retrieved documents in the top-5 are relevant, precision&#64;5 = 4/5 =
     *  0.8
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics doc_precision = 2;
     * </code>
     */
    public Builder setDocPrecision(
        com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics value) {
      if (docPrecisionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        docPrecision_ = value;
      } else {
        docPrecisionBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Precision per document, at various top-k cutoff levels.
     *
     * Precision is the fraction of retrieved documents that are relevant.
     *
     * Example (top-5):
     *  * For a single
     *  [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery], If 4 out
     *  of 5 retrieved documents in the top-5 are relevant, precision&#64;5 = 4/5 =
     *  0.8
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics doc_precision = 2;
     * </code>
     */
    public Builder setDocPrecision(
        com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics.Builder
            builderForValue) {
      if (docPrecisionBuilder_ == null) {
        docPrecision_ = builderForValue.build();
      } else {
        docPrecisionBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Precision per document, at various top-k cutoff levels.
     *
     * Precision is the fraction of retrieved documents that are relevant.
     *
     * Example (top-5):
     *  * For a single
     *  [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery], If 4 out
     *  of 5 retrieved documents in the top-5 are relevant, precision&#64;5 = 4/5 =
     *  0.8
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics doc_precision = 2;
     * </code>
     */
    public Builder mergeDocPrecision(
        com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics value) {
      if (docPrecisionBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && docPrecision_ != null
            && docPrecision_
                != com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics
                    .getDefaultInstance()) {
          getDocPrecisionBuilder().mergeFrom(value);
        } else {
          docPrecision_ = value;
        }
      } else {
        docPrecisionBuilder_.mergeFrom(value);
      }
      if (docPrecision_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Precision per document, at various top-k cutoff levels.
     *
     * Precision is the fraction of retrieved documents that are relevant.
     *
     * Example (top-5):
     *  * For a single
     *  [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery], If 4 out
     *  of 5 retrieved documents in the top-5 are relevant, precision&#64;5 = 4/5 =
     *  0.8
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics doc_precision = 2;
     * </code>
     */
    public Builder clearDocPrecision() {
      bitField0_ = (bitField0_ & ~0x00000002);
      docPrecision_ = null;
      if (docPrecisionBuilder_ != null) {
        docPrecisionBuilder_.dispose();
        docPrecisionBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Precision per document, at various top-k cutoff levels.
     *
     * Precision is the fraction of retrieved documents that are relevant.
     *
     * Example (top-5):
     *  * For a single
     *  [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery], If 4 out
     *  of 5 retrieved documents in the top-5 are relevant, precision&#64;5 = 4/5 =
     *  0.8
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics doc_precision = 2;
     * </code>
     */
    public com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics.Builder
        getDocPrecisionBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getDocPrecisionFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Precision per document, at various top-k cutoff levels.
     *
     * Precision is the fraction of retrieved documents that are relevant.
     *
     * Example (top-5):
     *  * For a single
     *  [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery], If 4 out
     *  of 5 retrieved documents in the top-5 are relevant, precision&#64;5 = 4/5 =
     *  0.8
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics doc_precision = 2;
     * </code>
     */
    public com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetricsOrBuilder
        getDocPrecisionOrBuilder() {
      if (docPrecisionBuilder_ != null) {
        return docPrecisionBuilder_.getMessageOrBuilder();
      } else {
        return docPrecision_ == null
            ? com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics
                .getDefaultInstance()
            : docPrecision_;
      }
    }
    /**
     *
     *
     * <pre>
     * Precision per document, at various top-k cutoff levels.
     *
     * Precision is the fraction of retrieved documents that are relevant.
     *
     * Example (top-5):
     *  * For a single
     *  [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery], If 4 out
     *  of 5 retrieved documents in the top-5 are relevant, precision&#64;5 = 4/5 =
     *  0.8
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics doc_precision = 2;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics,
            com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics.Builder,
            com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetricsOrBuilder>
        getDocPrecisionFieldBuilder() {
      if (docPrecisionBuilder_ == null) {
        docPrecisionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics,
                com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics.Builder,
                com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetricsOrBuilder>(
                getDocPrecision(), getParentForChildren(), isClean());
        docPrecision_ = null;
      }
      return docPrecisionBuilder_;
    }

    private com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics docNdcg_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics,
            com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics.Builder,
            com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetricsOrBuilder>
        docNdcgBuilder_;
    /**
     *
     *
     * <pre>
     * Normalized discounted cumulative gain (NDCG) per document, at various top-k
     * cutoff levels.
     *
     * NDCG measures the ranking quality, giving higher relevance to top
     * results.
     *
     * Example (top-3):
     *  Suppose [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery]
     *  with three retrieved documents (D1, D2, D3) and binary relevance
     *  judgements (1 for relevant, 0 for not relevant):
     *
     *   Retrieved:  [D3 (0), D1 (1), D2 (1)]
     *   Ideal:      [D1 (1), D2 (1), D3 (0)]
     *
     *   Calculate NDCG&#64;3 for each
     *   [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery]:
     *    * DCG&#64;3: 0/log2(1+1) + 1/log2(2+1) + 1/log2(3+1) = 1.13
     *    * Ideal DCG&#64;3: 1/log2(1+1) + 1/log2(2+1) + 0/log2(3+1) = 1.63
     *    * NDCG&#64;3: 1.13/1.63 = 0.693
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics doc_ndcg = 3;</code>
     *
     * @return Whether the docNdcg field is set.
     */
    public boolean hasDocNdcg() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Normalized discounted cumulative gain (NDCG) per document, at various top-k
     * cutoff levels.
     *
     * NDCG measures the ranking quality, giving higher relevance to top
     * results.
     *
     * Example (top-3):
     *  Suppose [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery]
     *  with three retrieved documents (D1, D2, D3) and binary relevance
     *  judgements (1 for relevant, 0 for not relevant):
     *
     *   Retrieved:  [D3 (0), D1 (1), D2 (1)]
     *   Ideal:      [D1 (1), D2 (1), D3 (0)]
     *
     *   Calculate NDCG&#64;3 for each
     *   [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery]:
     *    * DCG&#64;3: 0/log2(1+1) + 1/log2(2+1) + 1/log2(3+1) = 1.13
     *    * Ideal DCG&#64;3: 1/log2(1+1) + 1/log2(2+1) + 0/log2(3+1) = 1.63
     *    * NDCG&#64;3: 1.13/1.63 = 0.693
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics doc_ndcg = 3;</code>
     *
     * @return The docNdcg.
     */
    public com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics getDocNdcg() {
      if (docNdcgBuilder_ == null) {
        return docNdcg_ == null
            ? com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics
                .getDefaultInstance()
            : docNdcg_;
      } else {
        return docNdcgBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Normalized discounted cumulative gain (NDCG) per document, at various top-k
     * cutoff levels.
     *
     * NDCG measures the ranking quality, giving higher relevance to top
     * results.
     *
     * Example (top-3):
     *  Suppose [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery]
     *  with three retrieved documents (D1, D2, D3) and binary relevance
     *  judgements (1 for relevant, 0 for not relevant):
     *
     *   Retrieved:  [D3 (0), D1 (1), D2 (1)]
     *   Ideal:      [D1 (1), D2 (1), D3 (0)]
     *
     *   Calculate NDCG&#64;3 for each
     *   [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery]:
     *    * DCG&#64;3: 0/log2(1+1) + 1/log2(2+1) + 1/log2(3+1) = 1.13
     *    * Ideal DCG&#64;3: 1/log2(1+1) + 1/log2(2+1) + 0/log2(3+1) = 1.63
     *    * NDCG&#64;3: 1.13/1.63 = 0.693
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics doc_ndcg = 3;</code>
     */
    public Builder setDocNdcg(
        com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics value) {
      if (docNdcgBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        docNdcg_ = value;
      } else {
        docNdcgBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Normalized discounted cumulative gain (NDCG) per document, at various top-k
     * cutoff levels.
     *
     * NDCG measures the ranking quality, giving higher relevance to top
     * results.
     *
     * Example (top-3):
     *  Suppose [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery]
     *  with three retrieved documents (D1, D2, D3) and binary relevance
     *  judgements (1 for relevant, 0 for not relevant):
     *
     *   Retrieved:  [D3 (0), D1 (1), D2 (1)]
     *   Ideal:      [D1 (1), D2 (1), D3 (0)]
     *
     *   Calculate NDCG&#64;3 for each
     *   [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery]:
     *    * DCG&#64;3: 0/log2(1+1) + 1/log2(2+1) + 1/log2(3+1) = 1.13
     *    * Ideal DCG&#64;3: 1/log2(1+1) + 1/log2(2+1) + 0/log2(3+1) = 1.63
     *    * NDCG&#64;3: 1.13/1.63 = 0.693
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics doc_ndcg = 3;</code>
     */
    public Builder setDocNdcg(
        com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics.Builder
            builderForValue) {
      if (docNdcgBuilder_ == null) {
        docNdcg_ = builderForValue.build();
      } else {
        docNdcgBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Normalized discounted cumulative gain (NDCG) per document, at various top-k
     * cutoff levels.
     *
     * NDCG measures the ranking quality, giving higher relevance to top
     * results.
     *
     * Example (top-3):
     *  Suppose [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery]
     *  with three retrieved documents (D1, D2, D3) and binary relevance
     *  judgements (1 for relevant, 0 for not relevant):
     *
     *   Retrieved:  [D3 (0), D1 (1), D2 (1)]
     *   Ideal:      [D1 (1), D2 (1), D3 (0)]
     *
     *   Calculate NDCG&#64;3 for each
     *   [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery]:
     *    * DCG&#64;3: 0/log2(1+1) + 1/log2(2+1) + 1/log2(3+1) = 1.13
     *    * Ideal DCG&#64;3: 1/log2(1+1) + 1/log2(2+1) + 0/log2(3+1) = 1.63
     *    * NDCG&#64;3: 1.13/1.63 = 0.693
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics doc_ndcg = 3;</code>
     */
    public Builder mergeDocNdcg(
        com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics value) {
      if (docNdcgBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && docNdcg_ != null
            && docNdcg_
                != com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics
                    .getDefaultInstance()) {
          getDocNdcgBuilder().mergeFrom(value);
        } else {
          docNdcg_ = value;
        }
      } else {
        docNdcgBuilder_.mergeFrom(value);
      }
      if (docNdcg_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Normalized discounted cumulative gain (NDCG) per document, at various top-k
     * cutoff levels.
     *
     * NDCG measures the ranking quality, giving higher relevance to top
     * results.
     *
     * Example (top-3):
     *  Suppose [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery]
     *  with three retrieved documents (D1, D2, D3) and binary relevance
     *  judgements (1 for relevant, 0 for not relevant):
     *
     *   Retrieved:  [D3 (0), D1 (1), D2 (1)]
     *   Ideal:      [D1 (1), D2 (1), D3 (0)]
     *
     *   Calculate NDCG&#64;3 for each
     *   [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery]:
     *    * DCG&#64;3: 0/log2(1+1) + 1/log2(2+1) + 1/log2(3+1) = 1.13
     *    * Ideal DCG&#64;3: 1/log2(1+1) + 1/log2(2+1) + 0/log2(3+1) = 1.63
     *    * NDCG&#64;3: 1.13/1.63 = 0.693
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics doc_ndcg = 3;</code>
     */
    public Builder clearDocNdcg() {
      bitField0_ = (bitField0_ & ~0x00000004);
      docNdcg_ = null;
      if (docNdcgBuilder_ != null) {
        docNdcgBuilder_.dispose();
        docNdcgBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Normalized discounted cumulative gain (NDCG) per document, at various top-k
     * cutoff levels.
     *
     * NDCG measures the ranking quality, giving higher relevance to top
     * results.
     *
     * Example (top-3):
     *  Suppose [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery]
     *  with three retrieved documents (D1, D2, D3) and binary relevance
     *  judgements (1 for relevant, 0 for not relevant):
     *
     *   Retrieved:  [D3 (0), D1 (1), D2 (1)]
     *   Ideal:      [D1 (1), D2 (1), D3 (0)]
     *
     *   Calculate NDCG&#64;3 for each
     *   [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery]:
     *    * DCG&#64;3: 0/log2(1+1) + 1/log2(2+1) + 1/log2(3+1) = 1.13
     *    * Ideal DCG&#64;3: 1/log2(1+1) + 1/log2(2+1) + 0/log2(3+1) = 1.63
     *    * NDCG&#64;3: 1.13/1.63 = 0.693
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics doc_ndcg = 3;</code>
     */
    public com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics.Builder
        getDocNdcgBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getDocNdcgFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Normalized discounted cumulative gain (NDCG) per document, at various top-k
     * cutoff levels.
     *
     * NDCG measures the ranking quality, giving higher relevance to top
     * results.
     *
     * Example (top-3):
     *  Suppose [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery]
     *  with three retrieved documents (D1, D2, D3) and binary relevance
     *  judgements (1 for relevant, 0 for not relevant):
     *
     *   Retrieved:  [D3 (0), D1 (1), D2 (1)]
     *   Ideal:      [D1 (1), D2 (1), D3 (0)]
     *
     *   Calculate NDCG&#64;3 for each
     *   [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery]:
     *    * DCG&#64;3: 0/log2(1+1) + 1/log2(2+1) + 1/log2(3+1) = 1.13
     *    * Ideal DCG&#64;3: 1/log2(1+1) + 1/log2(2+1) + 0/log2(3+1) = 1.63
     *    * NDCG&#64;3: 1.13/1.63 = 0.693
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics doc_ndcg = 3;</code>
     */
    public com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetricsOrBuilder
        getDocNdcgOrBuilder() {
      if (docNdcgBuilder_ != null) {
        return docNdcgBuilder_.getMessageOrBuilder();
      } else {
        return docNdcg_ == null
            ? com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics
                .getDefaultInstance()
            : docNdcg_;
      }
    }
    /**
     *
     *
     * <pre>
     * Normalized discounted cumulative gain (NDCG) per document, at various top-k
     * cutoff levels.
     *
     * NDCG measures the ranking quality, giving higher relevance to top
     * results.
     *
     * Example (top-3):
     *  Suppose [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery]
     *  with three retrieved documents (D1, D2, D3) and binary relevance
     *  judgements (1 for relevant, 0 for not relevant):
     *
     *   Retrieved:  [D3 (0), D1 (1), D2 (1)]
     *   Ideal:      [D1 (1), D2 (1), D3 (0)]
     *
     *   Calculate NDCG&#64;3 for each
     *   [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery]:
     *    * DCG&#64;3: 0/log2(1+1) + 1/log2(2+1) + 1/log2(3+1) = 1.13
     *    * Ideal DCG&#64;3: 1/log2(1+1) + 1/log2(2+1) + 0/log2(3+1) = 1.63
     *    * NDCG&#64;3: 1.13/1.63 = 0.693
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics doc_ndcg = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics,
            com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics.Builder,
            com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetricsOrBuilder>
        getDocNdcgFieldBuilder() {
      if (docNdcgBuilder_ == null) {
        docNdcgBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics,
                com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics.Builder,
                com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetricsOrBuilder>(
                getDocNdcg(), getParentForChildren(), isClean());
        docNdcg_ = null;
      }
      return docNdcgBuilder_;
    }

    private com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics pageRecall_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics,
            com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics.Builder,
            com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetricsOrBuilder>
        pageRecallBuilder_;
    /**
     *
     *
     * <pre>
     * Recall per page, at various top-k cutoff levels.
     *
     * Recall is the fraction of relevant pages retrieved out of all relevant
     * pages.
     *
     * Example (top-5):
     *  * For a single
     *  [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery], if 3 out
     *  of 5 relevant pages are retrieved in the top-5, recall&#64;5 = 3/5 = 0.6
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics page_recall = 4;</code>
     *
     * @return Whether the pageRecall field is set.
     */
    public boolean hasPageRecall() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Recall per page, at various top-k cutoff levels.
     *
     * Recall is the fraction of relevant pages retrieved out of all relevant
     * pages.
     *
     * Example (top-5):
     *  * For a single
     *  [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery], if 3 out
     *  of 5 relevant pages are retrieved in the top-5, recall&#64;5 = 3/5 = 0.6
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics page_recall = 4;</code>
     *
     * @return The pageRecall.
     */
    public com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics getPageRecall() {
      if (pageRecallBuilder_ == null) {
        return pageRecall_ == null
            ? com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics
                .getDefaultInstance()
            : pageRecall_;
      } else {
        return pageRecallBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Recall per page, at various top-k cutoff levels.
     *
     * Recall is the fraction of relevant pages retrieved out of all relevant
     * pages.
     *
     * Example (top-5):
     *  * For a single
     *  [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery], if 3 out
     *  of 5 relevant pages are retrieved in the top-5, recall&#64;5 = 3/5 = 0.6
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics page_recall = 4;</code>
     */
    public Builder setPageRecall(
        com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics value) {
      if (pageRecallBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        pageRecall_ = value;
      } else {
        pageRecallBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Recall per page, at various top-k cutoff levels.
     *
     * Recall is the fraction of relevant pages retrieved out of all relevant
     * pages.
     *
     * Example (top-5):
     *  * For a single
     *  [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery], if 3 out
     *  of 5 relevant pages are retrieved in the top-5, recall&#64;5 = 3/5 = 0.6
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics page_recall = 4;</code>
     */
    public Builder setPageRecall(
        com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics.Builder
            builderForValue) {
      if (pageRecallBuilder_ == null) {
        pageRecall_ = builderForValue.build();
      } else {
        pageRecallBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Recall per page, at various top-k cutoff levels.
     *
     * Recall is the fraction of relevant pages retrieved out of all relevant
     * pages.
     *
     * Example (top-5):
     *  * For a single
     *  [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery], if 3 out
     *  of 5 relevant pages are retrieved in the top-5, recall&#64;5 = 3/5 = 0.6
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics page_recall = 4;</code>
     */
    public Builder mergePageRecall(
        com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics value) {
      if (pageRecallBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && pageRecall_ != null
            && pageRecall_
                != com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics
                    .getDefaultInstance()) {
          getPageRecallBuilder().mergeFrom(value);
        } else {
          pageRecall_ = value;
        }
      } else {
        pageRecallBuilder_.mergeFrom(value);
      }
      if (pageRecall_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Recall per page, at various top-k cutoff levels.
     *
     * Recall is the fraction of relevant pages retrieved out of all relevant
     * pages.
     *
     * Example (top-5):
     *  * For a single
     *  [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery], if 3 out
     *  of 5 relevant pages are retrieved in the top-5, recall&#64;5 = 3/5 = 0.6
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics page_recall = 4;</code>
     */
    public Builder clearPageRecall() {
      bitField0_ = (bitField0_ & ~0x00000008);
      pageRecall_ = null;
      if (pageRecallBuilder_ != null) {
        pageRecallBuilder_.dispose();
        pageRecallBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Recall per page, at various top-k cutoff levels.
     *
     * Recall is the fraction of relevant pages retrieved out of all relevant
     * pages.
     *
     * Example (top-5):
     *  * For a single
     *  [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery], if 3 out
     *  of 5 relevant pages are retrieved in the top-5, recall&#64;5 = 3/5 = 0.6
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics page_recall = 4;</code>
     */
    public com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics.Builder
        getPageRecallBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getPageRecallFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Recall per page, at various top-k cutoff levels.
     *
     * Recall is the fraction of relevant pages retrieved out of all relevant
     * pages.
     *
     * Example (top-5):
     *  * For a single
     *  [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery], if 3 out
     *  of 5 relevant pages are retrieved in the top-5, recall&#64;5 = 3/5 = 0.6
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics page_recall = 4;</code>
     */
    public com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetricsOrBuilder
        getPageRecallOrBuilder() {
      if (pageRecallBuilder_ != null) {
        return pageRecallBuilder_.getMessageOrBuilder();
      } else {
        return pageRecall_ == null
            ? com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics
                .getDefaultInstance()
            : pageRecall_;
      }
    }
    /**
     *
     *
     * <pre>
     * Recall per page, at various top-k cutoff levels.
     *
     * Recall is the fraction of relevant pages retrieved out of all relevant
     * pages.
     *
     * Example (top-5):
     *  * For a single
     *  [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery], if 3 out
     *  of 5 relevant pages are retrieved in the top-5, recall&#64;5 = 3/5 = 0.6
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics page_recall = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics,
            com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics.Builder,
            com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetricsOrBuilder>
        getPageRecallFieldBuilder() {
      if (pageRecallBuilder_ == null) {
        pageRecallBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics,
                com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics.Builder,
                com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetricsOrBuilder>(
                getPageRecall(), getParentForChildren(), isClean());
        pageRecall_ = null;
      }
      return pageRecallBuilder_;
    }

    private com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics pageNdcg_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics,
            com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics.Builder,
            com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetricsOrBuilder>
        pageNdcgBuilder_;
    /**
     *
     *
     * <pre>
     * Normalized discounted cumulative gain (NDCG) per page, at various top-k
     * cutoff levels.
     *
     * NDCG measures the ranking quality, giving higher relevance to top
     * results.
     *
     * Example (top-3):
     *  Suppose [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery]
     *  with three retrieved pages (P1, P2, P3) and binary relevance judgements (1
     *  for relevant, 0 for not relevant):
     *
     *   Retrieved:  [P3 (0), P1 (1), P2 (1)]
     *   Ideal:      [P1 (1), P2 (1), P3 (0)]
     *
     *   Calculate NDCG&#64;3 for
     *   [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery]:
     *    * DCG&#64;3: 0/log2(1+1) + 1/log2(2+1) + 1/log2(3+1) = 1.13
     *    * Ideal DCG&#64;3: 1/log2(1+1) + 1/log2(2+1) + 0/log2(3+1) = 1.63
     *    * NDCG&#64;3: 1.13/1.63 = 0.693
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics page_ndcg = 5;</code>
     *
     * @return Whether the pageNdcg field is set.
     */
    public boolean hasPageNdcg() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Normalized discounted cumulative gain (NDCG) per page, at various top-k
     * cutoff levels.
     *
     * NDCG measures the ranking quality, giving higher relevance to top
     * results.
     *
     * Example (top-3):
     *  Suppose [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery]
     *  with three retrieved pages (P1, P2, P3) and binary relevance judgements (1
     *  for relevant, 0 for not relevant):
     *
     *   Retrieved:  [P3 (0), P1 (1), P2 (1)]
     *   Ideal:      [P1 (1), P2 (1), P3 (0)]
     *
     *   Calculate NDCG&#64;3 for
     *   [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery]:
     *    * DCG&#64;3: 0/log2(1+1) + 1/log2(2+1) + 1/log2(3+1) = 1.13
     *    * Ideal DCG&#64;3: 1/log2(1+1) + 1/log2(2+1) + 0/log2(3+1) = 1.63
     *    * NDCG&#64;3: 1.13/1.63 = 0.693
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics page_ndcg = 5;</code>
     *
     * @return The pageNdcg.
     */
    public com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics getPageNdcg() {
      if (pageNdcgBuilder_ == null) {
        return pageNdcg_ == null
            ? com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics
                .getDefaultInstance()
            : pageNdcg_;
      } else {
        return pageNdcgBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Normalized discounted cumulative gain (NDCG) per page, at various top-k
     * cutoff levels.
     *
     * NDCG measures the ranking quality, giving higher relevance to top
     * results.
     *
     * Example (top-3):
     *  Suppose [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery]
     *  with three retrieved pages (P1, P2, P3) and binary relevance judgements (1
     *  for relevant, 0 for not relevant):
     *
     *   Retrieved:  [P3 (0), P1 (1), P2 (1)]
     *   Ideal:      [P1 (1), P2 (1), P3 (0)]
     *
     *   Calculate NDCG&#64;3 for
     *   [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery]:
     *    * DCG&#64;3: 0/log2(1+1) + 1/log2(2+1) + 1/log2(3+1) = 1.13
     *    * Ideal DCG&#64;3: 1/log2(1+1) + 1/log2(2+1) + 0/log2(3+1) = 1.63
     *    * NDCG&#64;3: 1.13/1.63 = 0.693
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics page_ndcg = 5;</code>
     */
    public Builder setPageNdcg(
        com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics value) {
      if (pageNdcgBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        pageNdcg_ = value;
      } else {
        pageNdcgBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Normalized discounted cumulative gain (NDCG) per page, at various top-k
     * cutoff levels.
     *
     * NDCG measures the ranking quality, giving higher relevance to top
     * results.
     *
     * Example (top-3):
     *  Suppose [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery]
     *  with three retrieved pages (P1, P2, P3) and binary relevance judgements (1
     *  for relevant, 0 for not relevant):
     *
     *   Retrieved:  [P3 (0), P1 (1), P2 (1)]
     *   Ideal:      [P1 (1), P2 (1), P3 (0)]
     *
     *   Calculate NDCG&#64;3 for
     *   [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery]:
     *    * DCG&#64;3: 0/log2(1+1) + 1/log2(2+1) + 1/log2(3+1) = 1.13
     *    * Ideal DCG&#64;3: 1/log2(1+1) + 1/log2(2+1) + 0/log2(3+1) = 1.63
     *    * NDCG&#64;3: 1.13/1.63 = 0.693
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics page_ndcg = 5;</code>
     */
    public Builder setPageNdcg(
        com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics.Builder
            builderForValue) {
      if (pageNdcgBuilder_ == null) {
        pageNdcg_ = builderForValue.build();
      } else {
        pageNdcgBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Normalized discounted cumulative gain (NDCG) per page, at various top-k
     * cutoff levels.
     *
     * NDCG measures the ranking quality, giving higher relevance to top
     * results.
     *
     * Example (top-3):
     *  Suppose [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery]
     *  with three retrieved pages (P1, P2, P3) and binary relevance judgements (1
     *  for relevant, 0 for not relevant):
     *
     *   Retrieved:  [P3 (0), P1 (1), P2 (1)]
     *   Ideal:      [P1 (1), P2 (1), P3 (0)]
     *
     *   Calculate NDCG&#64;3 for
     *   [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery]:
     *    * DCG&#64;3: 0/log2(1+1) + 1/log2(2+1) + 1/log2(3+1) = 1.13
     *    * Ideal DCG&#64;3: 1/log2(1+1) + 1/log2(2+1) + 0/log2(3+1) = 1.63
     *    * NDCG&#64;3: 1.13/1.63 = 0.693
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics page_ndcg = 5;</code>
     */
    public Builder mergePageNdcg(
        com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics value) {
      if (pageNdcgBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && pageNdcg_ != null
            && pageNdcg_
                != com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics
                    .getDefaultInstance()) {
          getPageNdcgBuilder().mergeFrom(value);
        } else {
          pageNdcg_ = value;
        }
      } else {
        pageNdcgBuilder_.mergeFrom(value);
      }
      if (pageNdcg_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Normalized discounted cumulative gain (NDCG) per page, at various top-k
     * cutoff levels.
     *
     * NDCG measures the ranking quality, giving higher relevance to top
     * results.
     *
     * Example (top-3):
     *  Suppose [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery]
     *  with three retrieved pages (P1, P2, P3) and binary relevance judgements (1
     *  for relevant, 0 for not relevant):
     *
     *   Retrieved:  [P3 (0), P1 (1), P2 (1)]
     *   Ideal:      [P1 (1), P2 (1), P3 (0)]
     *
     *   Calculate NDCG&#64;3 for
     *   [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery]:
     *    * DCG&#64;3: 0/log2(1+1) + 1/log2(2+1) + 1/log2(3+1) = 1.13
     *    * Ideal DCG&#64;3: 1/log2(1+1) + 1/log2(2+1) + 0/log2(3+1) = 1.63
     *    * NDCG&#64;3: 1.13/1.63 = 0.693
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics page_ndcg = 5;</code>
     */
    public Builder clearPageNdcg() {
      bitField0_ = (bitField0_ & ~0x00000010);
      pageNdcg_ = null;
      if (pageNdcgBuilder_ != null) {
        pageNdcgBuilder_.dispose();
        pageNdcgBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Normalized discounted cumulative gain (NDCG) per page, at various top-k
     * cutoff levels.
     *
     * NDCG measures the ranking quality, giving higher relevance to top
     * results.
     *
     * Example (top-3):
     *  Suppose [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery]
     *  with three retrieved pages (P1, P2, P3) and binary relevance judgements (1
     *  for relevant, 0 for not relevant):
     *
     *   Retrieved:  [P3 (0), P1 (1), P2 (1)]
     *   Ideal:      [P1 (1), P2 (1), P3 (0)]
     *
     *   Calculate NDCG&#64;3 for
     *   [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery]:
     *    * DCG&#64;3: 0/log2(1+1) + 1/log2(2+1) + 1/log2(3+1) = 1.13
     *    * Ideal DCG&#64;3: 1/log2(1+1) + 1/log2(2+1) + 0/log2(3+1) = 1.63
     *    * NDCG&#64;3: 1.13/1.63 = 0.693
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics page_ndcg = 5;</code>
     */
    public com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics.Builder
        getPageNdcgBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getPageNdcgFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Normalized discounted cumulative gain (NDCG) per page, at various top-k
     * cutoff levels.
     *
     * NDCG measures the ranking quality, giving higher relevance to top
     * results.
     *
     * Example (top-3):
     *  Suppose [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery]
     *  with three retrieved pages (P1, P2, P3) and binary relevance judgements (1
     *  for relevant, 0 for not relevant):
     *
     *   Retrieved:  [P3 (0), P1 (1), P2 (1)]
     *   Ideal:      [P1 (1), P2 (1), P3 (0)]
     *
     *   Calculate NDCG&#64;3 for
     *   [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery]:
     *    * DCG&#64;3: 0/log2(1+1) + 1/log2(2+1) + 1/log2(3+1) = 1.13
     *    * Ideal DCG&#64;3: 1/log2(1+1) + 1/log2(2+1) + 0/log2(3+1) = 1.63
     *    * NDCG&#64;3: 1.13/1.63 = 0.693
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics page_ndcg = 5;</code>
     */
    public com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetricsOrBuilder
        getPageNdcgOrBuilder() {
      if (pageNdcgBuilder_ != null) {
        return pageNdcgBuilder_.getMessageOrBuilder();
      } else {
        return pageNdcg_ == null
            ? com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics
                .getDefaultInstance()
            : pageNdcg_;
      }
    }
    /**
     *
     *
     * <pre>
     * Normalized discounted cumulative gain (NDCG) per page, at various top-k
     * cutoff levels.
     *
     * NDCG measures the ranking quality, giving higher relevance to top
     * results.
     *
     * Example (top-3):
     *  Suppose [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery]
     *  with three retrieved pages (P1, P2, P3) and binary relevance judgements (1
     *  for relevant, 0 for not relevant):
     *
     *   Retrieved:  [P3 (0), P1 (1), P2 (1)]
     *   Ideal:      [P1 (1), P2 (1), P3 (0)]
     *
     *   Calculate NDCG&#64;3 for
     *   [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery]:
     *    * DCG&#64;3: 0/log2(1+1) + 1/log2(2+1) + 1/log2(3+1) = 1.13
     *    * Ideal DCG&#64;3: 1/log2(1+1) + 1/log2(2+1) + 0/log2(3+1) = 1.63
     *    * NDCG&#64;3: 1.13/1.63 = 0.693
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics page_ndcg = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics,
            com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics.Builder,
            com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetricsOrBuilder>
        getPageNdcgFieldBuilder() {
      if (pageNdcgBuilder_ == null) {
        pageNdcgBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics,
                com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics.Builder,
                com.google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetricsOrBuilder>(
                getPageNdcg(), getParentForChildren(), isClean());
        pageNdcg_ = null;
      }
      return pageNdcgBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.QualityMetrics)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.QualityMetrics)
  private static final com.google.cloud.discoveryengine.v1beta.QualityMetrics DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.discoveryengine.v1beta.QualityMetrics();
  }

  public static com.google.cloud.discoveryengine.v1beta.QualityMetrics getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<QualityMetrics> PARSER =
      new com.google.protobuf.AbstractParser<QualityMetrics>() {
        @java.lang.Override
        public QualityMetrics parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<QualityMetrics> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<QualityMetrics> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.QualityMetrics getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
