/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/discoveryengine/v1beta/user_event.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.discoveryengine.v1beta;

/**
 *
 *
 * <pre>
 * Detailed document information associated with a user event.
 * </pre>
 *
 * Protobuf type {@code google.cloud.discoveryengine.v1beta.DocumentInfo}
 */
public final class DocumentInfo extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.DocumentInfo)
    DocumentInfoOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use DocumentInfo.newBuilder() to construct.
  private DocumentInfo(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private DocumentInfo() {
    promotionIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new DocumentInfo();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.discoveryengine.v1beta.UserEventProto
        .internal_static_google_cloud_discoveryengine_v1beta_DocumentInfo_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.discoveryengine.v1beta.UserEventProto
        .internal_static_google_cloud_discoveryengine_v1beta_DocumentInfo_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.discoveryengine.v1beta.DocumentInfo.class,
            com.google.cloud.discoveryengine.v1beta.DocumentInfo.Builder.class);
  }

  private int bitField0_;
  private int documentDescriptorCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object documentDescriptor_;

  public enum DocumentDescriptorCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    ID(1),
    NAME(2),
    URI(6),
    DOCUMENTDESCRIPTOR_NOT_SET(0);
    private final int value;

    private DocumentDescriptorCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static DocumentDescriptorCase valueOf(int value) {
      return forNumber(value);
    }

    public static DocumentDescriptorCase forNumber(int value) {
      switch (value) {
        case 1:
          return ID;
        case 2:
          return NAME;
        case 6:
          return URI;
        case 0:
          return DOCUMENTDESCRIPTOR_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public DocumentDescriptorCase getDocumentDescriptorCase() {
    return DocumentDescriptorCase.forNumber(documentDescriptorCase_);
  }

  public static final int ID_FIELD_NUMBER = 1;
  /**
   *
   *
   * <pre>
   * The [Document][google.cloud.discoveryengine.v1beta.Document] resource ID.
   * </pre>
   *
   * <code>string id = 1;</code>
   *
   * @return Whether the id field is set.
   */
  public boolean hasId() {
    return documentDescriptorCase_ == 1;
  }
  /**
   *
   *
   * <pre>
   * The [Document][google.cloud.discoveryengine.v1beta.Document] resource ID.
   * </pre>
   *
   * <code>string id = 1;</code>
   *
   * @return The id.
   */
  public java.lang.String getId() {
    java.lang.Object ref = "";
    if (documentDescriptorCase_ == 1) {
      ref = documentDescriptor_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (documentDescriptorCase_ == 1) {
        documentDescriptor_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The [Document][google.cloud.discoveryengine.v1beta.Document] resource ID.
   * </pre>
   *
   * <code>string id = 1;</code>
   *
   * @return The bytes for id.
   */
  public com.google.protobuf.ByteString getIdBytes() {
    java.lang.Object ref = "";
    if (documentDescriptorCase_ == 1) {
      ref = documentDescriptor_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (documentDescriptorCase_ == 1) {
        documentDescriptor_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NAME_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * The [Document][google.cloud.discoveryengine.v1beta.Document] resource
   * full name, of the form:
   * `projects/{project_id}/locations/{location}/collections/{collection_id}/dataStores/{data_store_id}/branches/{branch_id}/documents/{document_id}`
   * </pre>
   *
   * <code>string name = 2 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return Whether the name field is set.
   */
  public boolean hasName() {
    return documentDescriptorCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * The [Document][google.cloud.discoveryengine.v1beta.Document] resource
   * full name, of the form:
   * `projects/{project_id}/locations/{location}/collections/{collection_id}/dataStores/{data_store_id}/branches/{branch_id}/documents/{document_id}`
   * </pre>
   *
   * <code>string name = 2 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The name.
   */
  public java.lang.String getName() {
    java.lang.Object ref = "";
    if (documentDescriptorCase_ == 2) {
      ref = documentDescriptor_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (documentDescriptorCase_ == 2) {
        documentDescriptor_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The [Document][google.cloud.discoveryengine.v1beta.Document] resource
   * full name, of the form:
   * `projects/{project_id}/locations/{location}/collections/{collection_id}/dataStores/{data_store_id}/branches/{branch_id}/documents/{document_id}`
   * </pre>
   *
   * <code>string name = 2 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for name.
   */
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = "";
    if (documentDescriptorCase_ == 2) {
      ref = documentDescriptor_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (documentDescriptorCase_ == 2) {
        documentDescriptor_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int URI_FIELD_NUMBER = 6;
  /**
   *
   *
   * <pre>
   * The [Document][google.cloud.discoveryengine.v1beta.Document] URI - only
   * allowed for website data stores.
   * </pre>
   *
   * <code>string uri = 6;</code>
   *
   * @return Whether the uri field is set.
   */
  public boolean hasUri() {
    return documentDescriptorCase_ == 6;
  }
  /**
   *
   *
   * <pre>
   * The [Document][google.cloud.discoveryengine.v1beta.Document] URI - only
   * allowed for website data stores.
   * </pre>
   *
   * <code>string uri = 6;</code>
   *
   * @return The uri.
   */
  public java.lang.String getUri() {
    java.lang.Object ref = "";
    if (documentDescriptorCase_ == 6) {
      ref = documentDescriptor_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (documentDescriptorCase_ == 6) {
        documentDescriptor_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The [Document][google.cloud.discoveryengine.v1beta.Document] URI - only
   * allowed for website data stores.
   * </pre>
   *
   * <code>string uri = 6;</code>
   *
   * @return The bytes for uri.
   */
  public com.google.protobuf.ByteString getUriBytes() {
    java.lang.Object ref = "";
    if (documentDescriptorCase_ == 6) {
      ref = documentDescriptor_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (documentDescriptorCase_ == 6) {
        documentDescriptor_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int QUANTITY_FIELD_NUMBER = 3;
  private int quantity_ = 0;
  /**
   *
   *
   * <pre>
   * Quantity of the Document associated with the user event. Defaults to 1.
   *
   * For example, this field is 2 if two quantities of the same Document
   * are involved in a `add-to-cart` event.
   *
   * Required for events of the following event types:
   *
   * * `add-to-cart`
   * * `purchase`
   * </pre>
   *
   * <code>optional int32 quantity = 3;</code>
   *
   * @return Whether the quantity field is set.
   */
  @java.lang.Override
  public boolean hasQuantity() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Quantity of the Document associated with the user event. Defaults to 1.
   *
   * For example, this field is 2 if two quantities of the same Document
   * are involved in a `add-to-cart` event.
   *
   * Required for events of the following event types:
   *
   * * `add-to-cart`
   * * `purchase`
   * </pre>
   *
   * <code>optional int32 quantity = 3;</code>
   *
   * @return The quantity.
   */
  @java.lang.Override
  public int getQuantity() {
    return quantity_;
  }

  public static final int PROMOTION_IDS_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList promotionIds_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * The promotion IDs associated with this Document.
   * Currently, this field is restricted to at most one ID.
   * </pre>
   *
   * <code>repeated string promotion_ids = 4;</code>
   *
   * @return A list containing the promotionIds.
   */
  public com.google.protobuf.ProtocolStringList getPromotionIdsList() {
    return promotionIds_;
  }
  /**
   *
   *
   * <pre>
   * The promotion IDs associated with this Document.
   * Currently, this field is restricted to at most one ID.
   * </pre>
   *
   * <code>repeated string promotion_ids = 4;</code>
   *
   * @return The count of promotionIds.
   */
  public int getPromotionIdsCount() {
    return promotionIds_.size();
  }
  /**
   *
   *
   * <pre>
   * The promotion IDs associated with this Document.
   * Currently, this field is restricted to at most one ID.
   * </pre>
   *
   * <code>repeated string promotion_ids = 4;</code>
   *
   * @param index The index of the element to return.
   * @return The promotionIds at the given index.
   */
  public java.lang.String getPromotionIds(int index) {
    return promotionIds_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The promotion IDs associated with this Document.
   * Currently, this field is restricted to at most one ID.
   * </pre>
   *
   * <code>repeated string promotion_ids = 4;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the promotionIds at the given index.
   */
  public com.google.protobuf.ByteString getPromotionIdsBytes(int index) {
    return promotionIds_.getByteString(index);
  }

  public static final int JOINED_FIELD_NUMBER = 5;
  private boolean joined_ = false;
  /**
   *
   *
   * <pre>
   * Output only. Whether the referenced Document can be found in the data
   * store.
   * </pre>
   *
   * <code>bool joined = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The joined.
   */
  @java.lang.Override
  public boolean getJoined() {
    return joined_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (documentDescriptorCase_ == 1) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, documentDescriptor_);
    }
    if (documentDescriptorCase_ == 2) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, documentDescriptor_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeInt32(3, quantity_);
    }
    for (int i = 0; i < promotionIds_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, promotionIds_.getRaw(i));
    }
    if (joined_ != false) {
      output.writeBool(5, joined_);
    }
    if (documentDescriptorCase_ == 6) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, documentDescriptor_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (documentDescriptorCase_ == 1) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, documentDescriptor_);
    }
    if (documentDescriptorCase_ == 2) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, documentDescriptor_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(3, quantity_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < promotionIds_.size(); i++) {
        dataSize += computeStringSizeNoTag(promotionIds_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getPromotionIdsList().size();
    }
    if (joined_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(5, joined_);
    }
    if (documentDescriptorCase_ == 6) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, documentDescriptor_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.discoveryengine.v1beta.DocumentInfo)) {
      return super.equals(obj);
    }
    com.google.cloud.discoveryengine.v1beta.DocumentInfo other =
        (com.google.cloud.discoveryengine.v1beta.DocumentInfo) obj;

    if (hasQuantity() != other.hasQuantity()) return false;
    if (hasQuantity()) {
      if (getQuantity() != other.getQuantity()) return false;
    }
    if (!getPromotionIdsList().equals(other.getPromotionIdsList())) return false;
    if (getJoined() != other.getJoined()) return false;
    if (!getDocumentDescriptorCase().equals(other.getDocumentDescriptorCase())) return false;
    switch (documentDescriptorCase_) {
      case 1:
        if (!getId().equals(other.getId())) return false;
        break;
      case 2:
        if (!getName().equals(other.getName())) return false;
        break;
      case 6:
        if (!getUri().equals(other.getUri())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasQuantity()) {
      hash = (37 * hash) + QUANTITY_FIELD_NUMBER;
      hash = (53 * hash) + getQuantity();
    }
    if (getPromotionIdsCount() > 0) {
      hash = (37 * hash) + PROMOTION_IDS_FIELD_NUMBER;
      hash = (53 * hash) + getPromotionIdsList().hashCode();
    }
    hash = (37 * hash) + JOINED_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getJoined());
    switch (documentDescriptorCase_) {
      case 1:
        hash = (37 * hash) + ID_FIELD_NUMBER;
        hash = (53 * hash) + getId().hashCode();
        break;
      case 2:
        hash = (37 * hash) + NAME_FIELD_NUMBER;
        hash = (53 * hash) + getName().hashCode();
        break;
      case 6:
        hash = (37 * hash) + URI_FIELD_NUMBER;
        hash = (53 * hash) + getUri().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.discoveryengine.v1beta.DocumentInfo parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1beta.DocumentInfo parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.DocumentInfo parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1beta.DocumentInfo parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.DocumentInfo parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1beta.DocumentInfo parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.DocumentInfo parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1beta.DocumentInfo parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.DocumentInfo parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1beta.DocumentInfo parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.DocumentInfo parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1beta.DocumentInfo parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.discoveryengine.v1beta.DocumentInfo prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Detailed document information associated with a user event.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1beta.DocumentInfo}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.DocumentInfo)
      com.google.cloud.discoveryengine.v1beta.DocumentInfoOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1beta.UserEventProto
          .internal_static_google_cloud_discoveryengine_v1beta_DocumentInfo_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1beta.UserEventProto
          .internal_static_google_cloud_discoveryengine_v1beta_DocumentInfo_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1beta.DocumentInfo.class,
              com.google.cloud.discoveryengine.v1beta.DocumentInfo.Builder.class);
    }

    // Construct using com.google.cloud.discoveryengine.v1beta.DocumentInfo.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      quantity_ = 0;
      promotionIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
      joined_ = false;
      documentDescriptorCase_ = 0;
      documentDescriptor_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.discoveryengine.v1beta.UserEventProto
          .internal_static_google_cloud_discoveryengine_v1beta_DocumentInfo_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.DocumentInfo getDefaultInstanceForType() {
      return com.google.cloud.discoveryengine.v1beta.DocumentInfo.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.DocumentInfo build() {
      com.google.cloud.discoveryengine.v1beta.DocumentInfo result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.DocumentInfo buildPartial() {
      com.google.cloud.discoveryengine.v1beta.DocumentInfo result =
          new com.google.cloud.discoveryengine.v1beta.DocumentInfo(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.discoveryengine.v1beta.DocumentInfo result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.quantity_ = quantity_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        promotionIds_.makeImmutable();
        result.promotionIds_ = promotionIds_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.joined_ = joined_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.cloud.discoveryengine.v1beta.DocumentInfo result) {
      result.documentDescriptorCase_ = documentDescriptorCase_;
      result.documentDescriptor_ = this.documentDescriptor_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.discoveryengine.v1beta.DocumentInfo) {
        return mergeFrom((com.google.cloud.discoveryengine.v1beta.DocumentInfo) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.discoveryengine.v1beta.DocumentInfo other) {
      if (other == com.google.cloud.discoveryengine.v1beta.DocumentInfo.getDefaultInstance())
        return this;
      if (other.hasQuantity()) {
        setQuantity(other.getQuantity());
      }
      if (!other.promotionIds_.isEmpty()) {
        if (promotionIds_.isEmpty()) {
          promotionIds_ = other.promotionIds_;
          bitField0_ |= 0x00000010;
        } else {
          ensurePromotionIdsIsMutable();
          promotionIds_.addAll(other.promotionIds_);
        }
        onChanged();
      }
      if (other.getJoined() != false) {
        setJoined(other.getJoined());
      }
      switch (other.getDocumentDescriptorCase()) {
        case ID:
          {
            documentDescriptorCase_ = 1;
            documentDescriptor_ = other.documentDescriptor_;
            onChanged();
            break;
          }
        case NAME:
          {
            documentDescriptorCase_ = 2;
            documentDescriptor_ = other.documentDescriptor_;
            onChanged();
            break;
          }
        case URI:
          {
            documentDescriptorCase_ = 6;
            documentDescriptor_ = other.documentDescriptor_;
            onChanged();
            break;
          }
        case DOCUMENTDESCRIPTOR_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                java.lang.String s = input.readStringRequireUtf8();
                documentDescriptorCase_ = 1;
                documentDescriptor_ = s;
                break;
              } // case 10
            case 18:
              {
                java.lang.String s = input.readStringRequireUtf8();
                documentDescriptorCase_ = 2;
                documentDescriptor_ = s;
                break;
              } // case 18
            case 24:
              {
                quantity_ = input.readInt32();
                bitField0_ |= 0x00000008;
                break;
              } // case 24
            case 34:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensurePromotionIdsIsMutable();
                promotionIds_.add(s);
                break;
              } // case 34
            case 40:
              {
                joined_ = input.readBool();
                bitField0_ |= 0x00000020;
                break;
              } // case 40
            case 50:
              {
                java.lang.String s = input.readStringRequireUtf8();
                documentDescriptorCase_ = 6;
                documentDescriptor_ = s;
                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int documentDescriptorCase_ = 0;
    private java.lang.Object documentDescriptor_;

    public DocumentDescriptorCase getDocumentDescriptorCase() {
      return DocumentDescriptorCase.forNumber(documentDescriptorCase_);
    }

    public Builder clearDocumentDescriptor() {
      documentDescriptorCase_ = 0;
      documentDescriptor_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    /**
     *
     *
     * <pre>
     * The [Document][google.cloud.discoveryengine.v1beta.Document] resource ID.
     * </pre>
     *
     * <code>string id = 1;</code>
     *
     * @return Whether the id field is set.
     */
    @java.lang.Override
    public boolean hasId() {
      return documentDescriptorCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * The [Document][google.cloud.discoveryengine.v1beta.Document] resource ID.
     * </pre>
     *
     * <code>string id = 1;</code>
     *
     * @return The id.
     */
    @java.lang.Override
    public java.lang.String getId() {
      java.lang.Object ref = "";
      if (documentDescriptorCase_ == 1) {
        ref = documentDescriptor_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (documentDescriptorCase_ == 1) {
          documentDescriptor_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The [Document][google.cloud.discoveryengine.v1beta.Document] resource ID.
     * </pre>
     *
     * <code>string id = 1;</code>
     *
     * @return The bytes for id.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getIdBytes() {
      java.lang.Object ref = "";
      if (documentDescriptorCase_ == 1) {
        ref = documentDescriptor_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (documentDescriptorCase_ == 1) {
          documentDescriptor_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The [Document][google.cloud.discoveryengine.v1beta.Document] resource ID.
     * </pre>
     *
     * <code>string id = 1;</code>
     *
     * @param value The id to set.
     * @return This builder for chaining.
     */
    public Builder setId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      documentDescriptorCase_ = 1;
      documentDescriptor_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The [Document][google.cloud.discoveryengine.v1beta.Document] resource ID.
     * </pre>
     *
     * <code>string id = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearId() {
      if (documentDescriptorCase_ == 1) {
        documentDescriptorCase_ = 0;
        documentDescriptor_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The [Document][google.cloud.discoveryengine.v1beta.Document] resource ID.
     * </pre>
     *
     * <code>string id = 1;</code>
     *
     * @param value The bytes for id to set.
     * @return This builder for chaining.
     */
    public Builder setIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      documentDescriptorCase_ = 1;
      documentDescriptor_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The [Document][google.cloud.discoveryengine.v1beta.Document] resource
     * full name, of the form:
     * `projects/{project_id}/locations/{location}/collections/{collection_id}/dataStores/{data_store_id}/branches/{branch_id}/documents/{document_id}`
     * </pre>
     *
     * <code>string name = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return Whether the name field is set.
     */
    @java.lang.Override
    public boolean hasName() {
      return documentDescriptorCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * The [Document][google.cloud.discoveryengine.v1beta.Document] resource
     * full name, of the form:
     * `projects/{project_id}/locations/{location}/collections/{collection_id}/dataStores/{data_store_id}/branches/{branch_id}/documents/{document_id}`
     * </pre>
     *
     * <code>string name = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The name.
     */
    @java.lang.Override
    public java.lang.String getName() {
      java.lang.Object ref = "";
      if (documentDescriptorCase_ == 2) {
        ref = documentDescriptor_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (documentDescriptorCase_ == 2) {
          documentDescriptor_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The [Document][google.cloud.discoveryengine.v1beta.Document] resource
     * full name, of the form:
     * `projects/{project_id}/locations/{location}/collections/{collection_id}/dataStores/{data_store_id}/branches/{branch_id}/documents/{document_id}`
     * </pre>
     *
     * <code>string name = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for name.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = "";
      if (documentDescriptorCase_ == 2) {
        ref = documentDescriptor_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (documentDescriptorCase_ == 2) {
          documentDescriptor_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The [Document][google.cloud.discoveryengine.v1beta.Document] resource
     * full name, of the form:
     * `projects/{project_id}/locations/{location}/collections/{collection_id}/dataStores/{data_store_id}/branches/{branch_id}/documents/{document_id}`
     * </pre>
     *
     * <code>string name = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      documentDescriptorCase_ = 2;
      documentDescriptor_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The [Document][google.cloud.discoveryengine.v1beta.Document] resource
     * full name, of the form:
     * `projects/{project_id}/locations/{location}/collections/{collection_id}/dataStores/{data_store_id}/branches/{branch_id}/documents/{document_id}`
     * </pre>
     *
     * <code>string name = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      if (documentDescriptorCase_ == 2) {
        documentDescriptorCase_ = 0;
        documentDescriptor_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The [Document][google.cloud.discoveryengine.v1beta.Document] resource
     * full name, of the form:
     * `projects/{project_id}/locations/{location}/collections/{collection_id}/dataStores/{data_store_id}/branches/{branch_id}/documents/{document_id}`
     * </pre>
     *
     * <code>string name = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      documentDescriptorCase_ = 2;
      documentDescriptor_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The [Document][google.cloud.discoveryengine.v1beta.Document] URI - only
     * allowed for website data stores.
     * </pre>
     *
     * <code>string uri = 6;</code>
     *
     * @return Whether the uri field is set.
     */
    @java.lang.Override
    public boolean hasUri() {
      return documentDescriptorCase_ == 6;
    }
    /**
     *
     *
     * <pre>
     * The [Document][google.cloud.discoveryengine.v1beta.Document] URI - only
     * allowed for website data stores.
     * </pre>
     *
     * <code>string uri = 6;</code>
     *
     * @return The uri.
     */
    @java.lang.Override
    public java.lang.String getUri() {
      java.lang.Object ref = "";
      if (documentDescriptorCase_ == 6) {
        ref = documentDescriptor_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (documentDescriptorCase_ == 6) {
          documentDescriptor_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The [Document][google.cloud.discoveryengine.v1beta.Document] URI - only
     * allowed for website data stores.
     * </pre>
     *
     * <code>string uri = 6;</code>
     *
     * @return The bytes for uri.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getUriBytes() {
      java.lang.Object ref = "";
      if (documentDescriptorCase_ == 6) {
        ref = documentDescriptor_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (documentDescriptorCase_ == 6) {
          documentDescriptor_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The [Document][google.cloud.discoveryengine.v1beta.Document] URI - only
     * allowed for website data stores.
     * </pre>
     *
     * <code>string uri = 6;</code>
     *
     * @param value The uri to set.
     * @return This builder for chaining.
     */
    public Builder setUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      documentDescriptorCase_ = 6;
      documentDescriptor_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The [Document][google.cloud.discoveryengine.v1beta.Document] URI - only
     * allowed for website data stores.
     * </pre>
     *
     * <code>string uri = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUri() {
      if (documentDescriptorCase_ == 6) {
        documentDescriptorCase_ = 0;
        documentDescriptor_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The [Document][google.cloud.discoveryengine.v1beta.Document] URI - only
     * allowed for website data stores.
     * </pre>
     *
     * <code>string uri = 6;</code>
     *
     * @param value The bytes for uri to set.
     * @return This builder for chaining.
     */
    public Builder setUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      documentDescriptorCase_ = 6;
      documentDescriptor_ = value;
      onChanged();
      return this;
    }

    private int quantity_;
    /**
     *
     *
     * <pre>
     * Quantity of the Document associated with the user event. Defaults to 1.
     *
     * For example, this field is 2 if two quantities of the same Document
     * are involved in a `add-to-cart` event.
     *
     * Required for events of the following event types:
     *
     * * `add-to-cart`
     * * `purchase`
     * </pre>
     *
     * <code>optional int32 quantity = 3;</code>
     *
     * @return Whether the quantity field is set.
     */
    @java.lang.Override
    public boolean hasQuantity() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Quantity of the Document associated with the user event. Defaults to 1.
     *
     * For example, this field is 2 if two quantities of the same Document
     * are involved in a `add-to-cart` event.
     *
     * Required for events of the following event types:
     *
     * * `add-to-cart`
     * * `purchase`
     * </pre>
     *
     * <code>optional int32 quantity = 3;</code>
     *
     * @return The quantity.
     */
    @java.lang.Override
    public int getQuantity() {
      return quantity_;
    }
    /**
     *
     *
     * <pre>
     * Quantity of the Document associated with the user event. Defaults to 1.
     *
     * For example, this field is 2 if two quantities of the same Document
     * are involved in a `add-to-cart` event.
     *
     * Required for events of the following event types:
     *
     * * `add-to-cart`
     * * `purchase`
     * </pre>
     *
     * <code>optional int32 quantity = 3;</code>
     *
     * @param value The quantity to set.
     * @return This builder for chaining.
     */
    public Builder setQuantity(int value) {

      quantity_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Quantity of the Document associated with the user event. Defaults to 1.
     *
     * For example, this field is 2 if two quantities of the same Document
     * are involved in a `add-to-cart` event.
     *
     * Required for events of the following event types:
     *
     * * `add-to-cart`
     * * `purchase`
     * </pre>
     *
     * <code>optional int32 quantity = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearQuantity() {
      bitField0_ = (bitField0_ & ~0x00000008);
      quantity_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList promotionIds_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensurePromotionIdsIsMutable() {
      if (!promotionIds_.isModifiable()) {
        promotionIds_ = new com.google.protobuf.LazyStringArrayList(promotionIds_);
      }
      bitField0_ |= 0x00000010;
    }
    /**
     *
     *
     * <pre>
     * The promotion IDs associated with this Document.
     * Currently, this field is restricted to at most one ID.
     * </pre>
     *
     * <code>repeated string promotion_ids = 4;</code>
     *
     * @return A list containing the promotionIds.
     */
    public com.google.protobuf.ProtocolStringList getPromotionIdsList() {
      promotionIds_.makeImmutable();
      return promotionIds_;
    }
    /**
     *
     *
     * <pre>
     * The promotion IDs associated with this Document.
     * Currently, this field is restricted to at most one ID.
     * </pre>
     *
     * <code>repeated string promotion_ids = 4;</code>
     *
     * @return The count of promotionIds.
     */
    public int getPromotionIdsCount() {
      return promotionIds_.size();
    }
    /**
     *
     *
     * <pre>
     * The promotion IDs associated with this Document.
     * Currently, this field is restricted to at most one ID.
     * </pre>
     *
     * <code>repeated string promotion_ids = 4;</code>
     *
     * @param index The index of the element to return.
     * @return The promotionIds at the given index.
     */
    public java.lang.String getPromotionIds(int index) {
      return promotionIds_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The promotion IDs associated with this Document.
     * Currently, this field is restricted to at most one ID.
     * </pre>
     *
     * <code>repeated string promotion_ids = 4;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the promotionIds at the given index.
     */
    public com.google.protobuf.ByteString getPromotionIdsBytes(int index) {
      return promotionIds_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * The promotion IDs associated with this Document.
     * Currently, this field is restricted to at most one ID.
     * </pre>
     *
     * <code>repeated string promotion_ids = 4;</code>
     *
     * @param index The index to set the value at.
     * @param value The promotionIds to set.
     * @return This builder for chaining.
     */
    public Builder setPromotionIds(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensurePromotionIdsIsMutable();
      promotionIds_.set(index, value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The promotion IDs associated with this Document.
     * Currently, this field is restricted to at most one ID.
     * </pre>
     *
     * <code>repeated string promotion_ids = 4;</code>
     *
     * @param value The promotionIds to add.
     * @return This builder for chaining.
     */
    public Builder addPromotionIds(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensurePromotionIdsIsMutable();
      promotionIds_.add(value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The promotion IDs associated with this Document.
     * Currently, this field is restricted to at most one ID.
     * </pre>
     *
     * <code>repeated string promotion_ids = 4;</code>
     *
     * @param values The promotionIds to add.
     * @return This builder for chaining.
     */
    public Builder addAllPromotionIds(java.lang.Iterable<java.lang.String> values) {
      ensurePromotionIdsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, promotionIds_);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The promotion IDs associated with this Document.
     * Currently, this field is restricted to at most one ID.
     * </pre>
     *
     * <code>repeated string promotion_ids = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPromotionIds() {
      promotionIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000010);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The promotion IDs associated with this Document.
     * Currently, this field is restricted to at most one ID.
     * </pre>
     *
     * <code>repeated string promotion_ids = 4;</code>
     *
     * @param value The bytes of the promotionIds to add.
     * @return This builder for chaining.
     */
    public Builder addPromotionIdsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensurePromotionIdsIsMutable();
      promotionIds_.add(value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private boolean joined_;
    /**
     *
     *
     * <pre>
     * Output only. Whether the referenced Document can be found in the data
     * store.
     * </pre>
     *
     * <code>bool joined = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The joined.
     */
    @java.lang.Override
    public boolean getJoined() {
      return joined_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Whether the referenced Document can be found in the data
     * store.
     * </pre>
     *
     * <code>bool joined = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The joined to set.
     * @return This builder for chaining.
     */
    public Builder setJoined(boolean value) {

      joined_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Whether the referenced Document can be found in the data
     * store.
     * </pre>
     *
     * <code>bool joined = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearJoined() {
      bitField0_ = (bitField0_ & ~0x00000020);
      joined_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.DocumentInfo)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.DocumentInfo)
  private static final com.google.cloud.discoveryengine.v1beta.DocumentInfo DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.discoveryengine.v1beta.DocumentInfo();
  }

  public static com.google.cloud.discoveryengine.v1beta.DocumentInfo getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<DocumentInfo> PARSER =
      new com.google.protobuf.AbstractParser<DocumentInfo>() {
        @java.lang.Override
        public DocumentInfo parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<DocumentInfo> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<DocumentInfo> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.DocumentInfo getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
