/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/discoveryengine/v1beta/project.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.discoveryengine.v1beta;

/**
 *
 *
 * <pre>
 * Metadata and configurations for a Google Cloud project in the service.
 * </pre>
 *
 * Protobuf type {@code google.cloud.discoveryengine.v1beta.Project}
 */
public final class Project extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.Project)
    ProjectOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Project.newBuilder() to construct.
  private Project(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Project() {
    name_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Project();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.discoveryengine.v1beta.ProjectProto
        .internal_static_google_cloud_discoveryengine_v1beta_Project_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 4:
        return internalGetServiceTermsMap();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.discoveryengine.v1beta.ProjectProto
        .internal_static_google_cloud_discoveryengine_v1beta_Project_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.discoveryengine.v1beta.Project.class,
            com.google.cloud.discoveryengine.v1beta.Project.Builder.class);
  }

  public interface ServiceTermsOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1beta.Project.ServiceTerms)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The unique identifier of this terms of service.
     * Available terms:
     *
     * * `GA_DATA_USE_TERMS`: [Terms for data
     * use](https://cloud.google.com/retail/data-use-terms). When using this as
     * `id`, the acceptable
     * [version][google.cloud.discoveryengine.v1beta.Project.ServiceTerms.version]
     * to provide is `2022-11-23`.
     * </pre>
     *
     * <code>string id = 1;</code>
     *
     * @return The id.
     */
    java.lang.String getId();
    /**
     *
     *
     * <pre>
     * The unique identifier of this terms of service.
     * Available terms:
     *
     * * `GA_DATA_USE_TERMS`: [Terms for data
     * use](https://cloud.google.com/retail/data-use-terms). When using this as
     * `id`, the acceptable
     * [version][google.cloud.discoveryengine.v1beta.Project.ServiceTerms.version]
     * to provide is `2022-11-23`.
     * </pre>
     *
     * <code>string id = 1;</code>
     *
     * @return The bytes for id.
     */
    com.google.protobuf.ByteString getIdBytes();

    /**
     *
     *
     * <pre>
     * The version string of the terms of service.
     * For acceptable values, see the comments for
     * [id][google.cloud.discoveryengine.v1beta.Project.ServiceTerms.id] above.
     * </pre>
     *
     * <code>string version = 2;</code>
     *
     * @return The version.
     */
    java.lang.String getVersion();
    /**
     *
     *
     * <pre>
     * The version string of the terms of service.
     * For acceptable values, see the comments for
     * [id][google.cloud.discoveryengine.v1beta.Project.ServiceTerms.id] above.
     * </pre>
     *
     * <code>string version = 2;</code>
     *
     * @return The bytes for version.
     */
    com.google.protobuf.ByteString getVersionBytes();

    /**
     *
     *
     * <pre>
     * Whether the project has accepted/rejected the service terms or it is
     * still pending.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.Project.ServiceTerms.State state = 4;</code>
     *
     * @return The enum numeric value on the wire for state.
     */
    int getStateValue();
    /**
     *
     *
     * <pre>
     * Whether the project has accepted/rejected the service terms or it is
     * still pending.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.Project.ServiceTerms.State state = 4;</code>
     *
     * @return The state.
     */
    com.google.cloud.discoveryengine.v1beta.Project.ServiceTerms.State getState();

    /**
     *
     *
     * <pre>
     * The last time when the project agreed to the terms of service.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp accept_time = 5;</code>
     *
     * @return Whether the acceptTime field is set.
     */
    boolean hasAcceptTime();
    /**
     *
     *
     * <pre>
     * The last time when the project agreed to the terms of service.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp accept_time = 5;</code>
     *
     * @return The acceptTime.
     */
    com.google.protobuf.Timestamp getAcceptTime();
    /**
     *
     *
     * <pre>
     * The last time when the project agreed to the terms of service.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp accept_time = 5;</code>
     */
    com.google.protobuf.TimestampOrBuilder getAcceptTimeOrBuilder();

    /**
     *
     *
     * <pre>
     * The last time when the project declined or revoked the agreement to terms
     * of service.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp decline_time = 6;</code>
     *
     * @return Whether the declineTime field is set.
     */
    boolean hasDeclineTime();
    /**
     *
     *
     * <pre>
     * The last time when the project declined or revoked the agreement to terms
     * of service.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp decline_time = 6;</code>
     *
     * @return The declineTime.
     */
    com.google.protobuf.Timestamp getDeclineTime();
    /**
     *
     *
     * <pre>
     * The last time when the project declined or revoked the agreement to terms
     * of service.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp decline_time = 6;</code>
     */
    com.google.protobuf.TimestampOrBuilder getDeclineTimeOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * Metadata about the terms of service.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1beta.Project.ServiceTerms}
   */
  public static final class ServiceTerms extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.Project.ServiceTerms)
      ServiceTermsOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ServiceTerms.newBuilder() to construct.
    private ServiceTerms(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ServiceTerms() {
      id_ = "";
      version_ = "";
      state_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ServiceTerms();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1beta.ProjectProto
          .internal_static_google_cloud_discoveryengine_v1beta_Project_ServiceTerms_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1beta.ProjectProto
          .internal_static_google_cloud_discoveryengine_v1beta_Project_ServiceTerms_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1beta.Project.ServiceTerms.class,
              com.google.cloud.discoveryengine.v1beta.Project.ServiceTerms.Builder.class);
    }

    /**
     *
     *
     * <pre>
     * The agreement states this terms of service.
     * </pre>
     *
     * Protobuf enum {@code google.cloud.discoveryengine.v1beta.Project.ServiceTerms.State}
     */
    public enum State implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * The default value of the enum. This value is not actually used.
       * </pre>
       *
       * <code>STATE_UNSPECIFIED = 0;</code>
       */
      STATE_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * The project has given consent to the terms of service.
       * </pre>
       *
       * <code>TERMS_ACCEPTED = 1;</code>
       */
      TERMS_ACCEPTED(1),
      /**
       *
       *
       * <pre>
       * The project is pending to review and accept the terms of service.
       * </pre>
       *
       * <code>TERMS_PENDING = 2;</code>
       */
      TERMS_PENDING(2),
      /**
       *
       *
       * <pre>
       * The project has declined or revoked the agreement to terms of service.
       * </pre>
       *
       * <code>TERMS_DECLINED = 3;</code>
       */
      TERMS_DECLINED(3),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * The default value of the enum. This value is not actually used.
       * </pre>
       *
       * <code>STATE_UNSPECIFIED = 0;</code>
       */
      public static final int STATE_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * The project has given consent to the terms of service.
       * </pre>
       *
       * <code>TERMS_ACCEPTED = 1;</code>
       */
      public static final int TERMS_ACCEPTED_VALUE = 1;
      /**
       *
       *
       * <pre>
       * The project is pending to review and accept the terms of service.
       * </pre>
       *
       * <code>TERMS_PENDING = 2;</code>
       */
      public static final int TERMS_PENDING_VALUE = 2;
      /**
       *
       *
       * <pre>
       * The project has declined or revoked the agreement to terms of service.
       * </pre>
       *
       * <code>TERMS_DECLINED = 3;</code>
       */
      public static final int TERMS_DECLINED_VALUE = 3;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static State valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static State forNumber(int value) {
        switch (value) {
          case 0:
            return STATE_UNSPECIFIED;
          case 1:
            return TERMS_ACCEPTED;
          case 2:
            return TERMS_PENDING;
          case 3:
            return TERMS_DECLINED;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<State>() {
            public State findValueByNumber(int number) {
              return State.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1beta.Project.ServiceTerms.getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final State[] VALUES = values();

      public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private State(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.cloud.discoveryengine.v1beta.Project.ServiceTerms.State)
    }

    private int bitField0_;
    public static final int ID_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object id_ = "";
    /**
     *
     *
     * <pre>
     * The unique identifier of this terms of service.
     * Available terms:
     *
     * * `GA_DATA_USE_TERMS`: [Terms for data
     * use](https://cloud.google.com/retail/data-use-terms). When using this as
     * `id`, the acceptable
     * [version][google.cloud.discoveryengine.v1beta.Project.ServiceTerms.version]
     * to provide is `2022-11-23`.
     * </pre>
     *
     * <code>string id = 1;</code>
     *
     * @return The id.
     */
    @java.lang.Override
    public java.lang.String getId() {
      java.lang.Object ref = id_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        id_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The unique identifier of this terms of service.
     * Available terms:
     *
     * * `GA_DATA_USE_TERMS`: [Terms for data
     * use](https://cloud.google.com/retail/data-use-terms). When using this as
     * `id`, the acceptable
     * [version][google.cloud.discoveryengine.v1beta.Project.ServiceTerms.version]
     * to provide is `2022-11-23`.
     * </pre>
     *
     * <code>string id = 1;</code>
     *
     * @return The bytes for id.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getIdBytes() {
      java.lang.Object ref = id_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        id_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int VERSION_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object version_ = "";
    /**
     *
     *
     * <pre>
     * The version string of the terms of service.
     * For acceptable values, see the comments for
     * [id][google.cloud.discoveryengine.v1beta.Project.ServiceTerms.id] above.
     * </pre>
     *
     * <code>string version = 2;</code>
     *
     * @return The version.
     */
    @java.lang.Override
    public java.lang.String getVersion() {
      java.lang.Object ref = version_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        version_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The version string of the terms of service.
     * For acceptable values, see the comments for
     * [id][google.cloud.discoveryengine.v1beta.Project.ServiceTerms.id] above.
     * </pre>
     *
     * <code>string version = 2;</code>
     *
     * @return The bytes for version.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getVersionBytes() {
      java.lang.Object ref = version_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        version_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int STATE_FIELD_NUMBER = 4;
    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Whether the project has accepted/rejected the service terms or it is
     * still pending.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.Project.ServiceTerms.State state = 4;</code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Whether the project has accepted/rejected the service terms or it is
     * still pending.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.Project.ServiceTerms.State state = 4;</code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.Project.ServiceTerms.State getState() {
      com.google.cloud.discoveryengine.v1beta.Project.ServiceTerms.State result =
          com.google.cloud.discoveryengine.v1beta.Project.ServiceTerms.State.forNumber(state_);
      return result == null
          ? com.google.cloud.discoveryengine.v1beta.Project.ServiceTerms.State.UNRECOGNIZED
          : result;
    }

    public static final int ACCEPT_TIME_FIELD_NUMBER = 5;
    private com.google.protobuf.Timestamp acceptTime_;
    /**
     *
     *
     * <pre>
     * The last time when the project agreed to the terms of service.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp accept_time = 5;</code>
     *
     * @return Whether the acceptTime field is set.
     */
    @java.lang.Override
    public boolean hasAcceptTime() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * The last time when the project agreed to the terms of service.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp accept_time = 5;</code>
     *
     * @return The acceptTime.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getAcceptTime() {
      return acceptTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : acceptTime_;
    }
    /**
     *
     *
     * <pre>
     * The last time when the project agreed to the terms of service.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp accept_time = 5;</code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getAcceptTimeOrBuilder() {
      return acceptTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : acceptTime_;
    }

    public static final int DECLINE_TIME_FIELD_NUMBER = 6;
    private com.google.protobuf.Timestamp declineTime_;
    /**
     *
     *
     * <pre>
     * The last time when the project declined or revoked the agreement to terms
     * of service.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp decline_time = 6;</code>
     *
     * @return Whether the declineTime field is set.
     */
    @java.lang.Override
    public boolean hasDeclineTime() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * The last time when the project declined or revoked the agreement to terms
     * of service.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp decline_time = 6;</code>
     *
     * @return The declineTime.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getDeclineTime() {
      return declineTime_ == null
          ? com.google.protobuf.Timestamp.getDefaultInstance()
          : declineTime_;
    }
    /**
     *
     *
     * <pre>
     * The last time when the project declined or revoked the agreement to terms
     * of service.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp decline_time = 6;</code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getDeclineTimeOrBuilder() {
      return declineTime_ == null
          ? com.google.protobuf.Timestamp.getDefaultInstance()
          : declineTime_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, id_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(version_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, version_);
      }
      if (state_
          != com.google.cloud.discoveryengine.v1beta.Project.ServiceTerms.State.STATE_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(4, state_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(5, getAcceptTime());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeMessage(6, getDeclineTime());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, id_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(version_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, version_);
      }
      if (state_
          != com.google.cloud.discoveryengine.v1beta.Project.ServiceTerms.State.STATE_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, state_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getAcceptTime());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getDeclineTime());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.discoveryengine.v1beta.Project.ServiceTerms)) {
        return super.equals(obj);
      }
      com.google.cloud.discoveryengine.v1beta.Project.ServiceTerms other =
          (com.google.cloud.discoveryengine.v1beta.Project.ServiceTerms) obj;

      if (!getId().equals(other.getId())) return false;
      if (!getVersion().equals(other.getVersion())) return false;
      if (state_ != other.state_) return false;
      if (hasAcceptTime() != other.hasAcceptTime()) return false;
      if (hasAcceptTime()) {
        if (!getAcceptTime().equals(other.getAcceptTime())) return false;
      }
      if (hasDeclineTime() != other.hasDeclineTime()) return false;
      if (hasDeclineTime()) {
        if (!getDeclineTime().equals(other.getDeclineTime())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ID_FIELD_NUMBER;
      hash = (53 * hash) + getId().hashCode();
      hash = (37 * hash) + VERSION_FIELD_NUMBER;
      hash = (53 * hash) + getVersion().hashCode();
      hash = (37 * hash) + STATE_FIELD_NUMBER;
      hash = (53 * hash) + state_;
      if (hasAcceptTime()) {
        hash = (37 * hash) + ACCEPT_TIME_FIELD_NUMBER;
        hash = (53 * hash) + getAcceptTime().hashCode();
      }
      if (hasDeclineTime()) {
        hash = (37 * hash) + DECLINE_TIME_FIELD_NUMBER;
        hash = (53 * hash) + getDeclineTime().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.discoveryengine.v1beta.Project.ServiceTerms parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.Project.ServiceTerms parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.Project.ServiceTerms parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.Project.ServiceTerms parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.Project.ServiceTerms parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.Project.ServiceTerms parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.Project.ServiceTerms parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.Project.ServiceTerms parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.Project.ServiceTerms parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.Project.ServiceTerms parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.Project.ServiceTerms parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.Project.ServiceTerms parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.discoveryengine.v1beta.Project.ServiceTerms prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Metadata about the terms of service.
     * </pre>
     *
     * Protobuf type {@code google.cloud.discoveryengine.v1beta.Project.ServiceTerms}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.Project.ServiceTerms)
        com.google.cloud.discoveryengine.v1beta.Project.ServiceTermsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1beta.ProjectProto
            .internal_static_google_cloud_discoveryengine_v1beta_Project_ServiceTerms_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1beta.ProjectProto
            .internal_static_google_cloud_discoveryengine_v1beta_Project_ServiceTerms_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1beta.Project.ServiceTerms.class,
                com.google.cloud.discoveryengine.v1beta.Project.ServiceTerms.Builder.class);
      }

      // Construct using com.google.cloud.discoveryengine.v1beta.Project.ServiceTerms.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getAcceptTimeFieldBuilder();
          getDeclineTimeFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        id_ = "";
        version_ = "";
        state_ = 0;
        acceptTime_ = null;
        if (acceptTimeBuilder_ != null) {
          acceptTimeBuilder_.dispose();
          acceptTimeBuilder_ = null;
        }
        declineTime_ = null;
        if (declineTimeBuilder_ != null) {
          declineTimeBuilder_.dispose();
          declineTimeBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.discoveryengine.v1beta.ProjectProto
            .internal_static_google_cloud_discoveryengine_v1beta_Project_ServiceTerms_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.Project.ServiceTerms
          getDefaultInstanceForType() {
        return com.google.cloud.discoveryengine.v1beta.Project.ServiceTerms.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.Project.ServiceTerms build() {
        com.google.cloud.discoveryengine.v1beta.Project.ServiceTerms result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.Project.ServiceTerms buildPartial() {
        com.google.cloud.discoveryengine.v1beta.Project.ServiceTerms result =
            new com.google.cloud.discoveryengine.v1beta.Project.ServiceTerms(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.discoveryengine.v1beta.Project.ServiceTerms result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.id_ = id_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.version_ = version_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.state_ = state_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.acceptTime_ =
              acceptTimeBuilder_ == null ? acceptTime_ : acceptTimeBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.declineTime_ =
              declineTimeBuilder_ == null ? declineTime_ : declineTimeBuilder_.build();
          to_bitField0_ |= 0x00000002;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.discoveryengine.v1beta.Project.ServiceTerms) {
          return mergeFrom((com.google.cloud.discoveryengine.v1beta.Project.ServiceTerms) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.discoveryengine.v1beta.Project.ServiceTerms other) {
        if (other
            == com.google.cloud.discoveryengine.v1beta.Project.ServiceTerms.getDefaultInstance())
          return this;
        if (!other.getId().isEmpty()) {
          id_ = other.id_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getVersion().isEmpty()) {
          version_ = other.version_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (other.state_ != 0) {
          setStateValue(other.getStateValue());
        }
        if (other.hasAcceptTime()) {
          mergeAcceptTime(other.getAcceptTime());
        }
        if (other.hasDeclineTime()) {
          mergeDeclineTime(other.getDeclineTime());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  id_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  version_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 32:
                {
                  state_ = input.readEnum();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 32
              case 42:
                {
                  input.readMessage(getAcceptTimeFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000008;
                  break;
                } // case 42
              case 50:
                {
                  input.readMessage(getDeclineTimeFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000010;
                  break;
                } // case 50
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object id_ = "";
      /**
       *
       *
       * <pre>
       * The unique identifier of this terms of service.
       * Available terms:
       *
       * * `GA_DATA_USE_TERMS`: [Terms for data
       * use](https://cloud.google.com/retail/data-use-terms). When using this as
       * `id`, the acceptable
       * [version][google.cloud.discoveryengine.v1beta.Project.ServiceTerms.version]
       * to provide is `2022-11-23`.
       * </pre>
       *
       * <code>string id = 1;</code>
       *
       * @return The id.
       */
      public java.lang.String getId() {
        java.lang.Object ref = id_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          id_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The unique identifier of this terms of service.
       * Available terms:
       *
       * * `GA_DATA_USE_TERMS`: [Terms for data
       * use](https://cloud.google.com/retail/data-use-terms). When using this as
       * `id`, the acceptable
       * [version][google.cloud.discoveryengine.v1beta.Project.ServiceTerms.version]
       * to provide is `2022-11-23`.
       * </pre>
       *
       * <code>string id = 1;</code>
       *
       * @return The bytes for id.
       */
      public com.google.protobuf.ByteString getIdBytes() {
        java.lang.Object ref = id_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          id_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The unique identifier of this terms of service.
       * Available terms:
       *
       * * `GA_DATA_USE_TERMS`: [Terms for data
       * use](https://cloud.google.com/retail/data-use-terms). When using this as
       * `id`, the acceptable
       * [version][google.cloud.discoveryengine.v1beta.Project.ServiceTerms.version]
       * to provide is `2022-11-23`.
       * </pre>
       *
       * <code>string id = 1;</code>
       *
       * @param value The id to set.
       * @return This builder for chaining.
       */
      public Builder setId(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        id_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The unique identifier of this terms of service.
       * Available terms:
       *
       * * `GA_DATA_USE_TERMS`: [Terms for data
       * use](https://cloud.google.com/retail/data-use-terms). When using this as
       * `id`, the acceptable
       * [version][google.cloud.discoveryengine.v1beta.Project.ServiceTerms.version]
       * to provide is `2022-11-23`.
       * </pre>
       *
       * <code>string id = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearId() {
        id_ = getDefaultInstance().getId();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The unique identifier of this terms of service.
       * Available terms:
       *
       * * `GA_DATA_USE_TERMS`: [Terms for data
       * use](https://cloud.google.com/retail/data-use-terms). When using this as
       * `id`, the acceptable
       * [version][google.cloud.discoveryengine.v1beta.Project.ServiceTerms.version]
       * to provide is `2022-11-23`.
       * </pre>
       *
       * <code>string id = 1;</code>
       *
       * @param value The bytes for id to set.
       * @return This builder for chaining.
       */
      public Builder setIdBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        id_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object version_ = "";
      /**
       *
       *
       * <pre>
       * The version string of the terms of service.
       * For acceptable values, see the comments for
       * [id][google.cloud.discoveryengine.v1beta.Project.ServiceTerms.id] above.
       * </pre>
       *
       * <code>string version = 2;</code>
       *
       * @return The version.
       */
      public java.lang.String getVersion() {
        java.lang.Object ref = version_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          version_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The version string of the terms of service.
       * For acceptable values, see the comments for
       * [id][google.cloud.discoveryengine.v1beta.Project.ServiceTerms.id] above.
       * </pre>
       *
       * <code>string version = 2;</code>
       *
       * @return The bytes for version.
       */
      public com.google.protobuf.ByteString getVersionBytes() {
        java.lang.Object ref = version_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          version_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The version string of the terms of service.
       * For acceptable values, see the comments for
       * [id][google.cloud.discoveryengine.v1beta.Project.ServiceTerms.id] above.
       * </pre>
       *
       * <code>string version = 2;</code>
       *
       * @param value The version to set.
       * @return This builder for chaining.
       */
      public Builder setVersion(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        version_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The version string of the terms of service.
       * For acceptable values, see the comments for
       * [id][google.cloud.discoveryengine.v1beta.Project.ServiceTerms.id] above.
       * </pre>
       *
       * <code>string version = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearVersion() {
        version_ = getDefaultInstance().getVersion();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The version string of the terms of service.
       * For acceptable values, see the comments for
       * [id][google.cloud.discoveryengine.v1beta.Project.ServiceTerms.id] above.
       * </pre>
       *
       * <code>string version = 2;</code>
       *
       * @param value The bytes for version to set.
       * @return This builder for chaining.
       */
      public Builder setVersionBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        version_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private int state_ = 0;
      /**
       *
       *
       * <pre>
       * Whether the project has accepted/rejected the service terms or it is
       * still pending.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1beta.Project.ServiceTerms.State state = 4;</code>
       *
       * @return The enum numeric value on the wire for state.
       */
      @java.lang.Override
      public int getStateValue() {
        return state_;
      }
      /**
       *
       *
       * <pre>
       * Whether the project has accepted/rejected the service terms or it is
       * still pending.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1beta.Project.ServiceTerms.State state = 4;</code>
       *
       * @param value The enum numeric value on the wire for state to set.
       * @return This builder for chaining.
       */
      public Builder setStateValue(int value) {
        state_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Whether the project has accepted/rejected the service terms or it is
       * still pending.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1beta.Project.ServiceTerms.State state = 4;</code>
       *
       * @return The state.
       */
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.Project.ServiceTerms.State getState() {
        com.google.cloud.discoveryengine.v1beta.Project.ServiceTerms.State result =
            com.google.cloud.discoveryengine.v1beta.Project.ServiceTerms.State.forNumber(state_);
        return result == null
            ? com.google.cloud.discoveryengine.v1beta.Project.ServiceTerms.State.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * Whether the project has accepted/rejected the service terms or it is
       * still pending.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1beta.Project.ServiceTerms.State state = 4;</code>
       *
       * @param value The state to set.
       * @return This builder for chaining.
       */
      public Builder setState(
          com.google.cloud.discoveryengine.v1beta.Project.ServiceTerms.State value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000004;
        state_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Whether the project has accepted/rejected the service terms or it is
       * still pending.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1beta.Project.ServiceTerms.State state = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearState() {
        bitField0_ = (bitField0_ & ~0x00000004);
        state_ = 0;
        onChanged();
        return this;
      }

      private com.google.protobuf.Timestamp acceptTime_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          acceptTimeBuilder_;
      /**
       *
       *
       * <pre>
       * The last time when the project agreed to the terms of service.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp accept_time = 5;</code>
       *
       * @return Whether the acceptTime field is set.
       */
      public boolean hasAcceptTime() {
        return ((bitField0_ & 0x00000008) != 0);
      }
      /**
       *
       *
       * <pre>
       * The last time when the project agreed to the terms of service.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp accept_time = 5;</code>
       *
       * @return The acceptTime.
       */
      public com.google.protobuf.Timestamp getAcceptTime() {
        if (acceptTimeBuilder_ == null) {
          return acceptTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : acceptTime_;
        } else {
          return acceptTimeBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The last time when the project agreed to the terms of service.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp accept_time = 5;</code>
       */
      public Builder setAcceptTime(com.google.protobuf.Timestamp value) {
        if (acceptTimeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          acceptTime_ = value;
        } else {
          acceptTimeBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The last time when the project agreed to the terms of service.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp accept_time = 5;</code>
       */
      public Builder setAcceptTime(com.google.protobuf.Timestamp.Builder builderForValue) {
        if (acceptTimeBuilder_ == null) {
          acceptTime_ = builderForValue.build();
        } else {
          acceptTimeBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The last time when the project agreed to the terms of service.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp accept_time = 5;</code>
       */
      public Builder mergeAcceptTime(com.google.protobuf.Timestamp value) {
        if (acceptTimeBuilder_ == null) {
          if (((bitField0_ & 0x00000008) != 0)
              && acceptTime_ != null
              && acceptTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
            getAcceptTimeBuilder().mergeFrom(value);
          } else {
            acceptTime_ = value;
          }
        } else {
          acceptTimeBuilder_.mergeFrom(value);
        }
        if (acceptTime_ != null) {
          bitField0_ |= 0x00000008;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The last time when the project agreed to the terms of service.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp accept_time = 5;</code>
       */
      public Builder clearAcceptTime() {
        bitField0_ = (bitField0_ & ~0x00000008);
        acceptTime_ = null;
        if (acceptTimeBuilder_ != null) {
          acceptTimeBuilder_.dispose();
          acceptTimeBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The last time when the project agreed to the terms of service.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp accept_time = 5;</code>
       */
      public com.google.protobuf.Timestamp.Builder getAcceptTimeBuilder() {
        bitField0_ |= 0x00000008;
        onChanged();
        return getAcceptTimeFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The last time when the project agreed to the terms of service.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp accept_time = 5;</code>
       */
      public com.google.protobuf.TimestampOrBuilder getAcceptTimeOrBuilder() {
        if (acceptTimeBuilder_ != null) {
          return acceptTimeBuilder_.getMessageOrBuilder();
        } else {
          return acceptTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : acceptTime_;
        }
      }
      /**
       *
       *
       * <pre>
       * The last time when the project agreed to the terms of service.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp accept_time = 5;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          getAcceptTimeFieldBuilder() {
        if (acceptTimeBuilder_ == null) {
          acceptTimeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Timestamp,
                  com.google.protobuf.Timestamp.Builder,
                  com.google.protobuf.TimestampOrBuilder>(
                  getAcceptTime(), getParentForChildren(), isClean());
          acceptTime_ = null;
        }
        return acceptTimeBuilder_;
      }

      private com.google.protobuf.Timestamp declineTime_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          declineTimeBuilder_;
      /**
       *
       *
       * <pre>
       * The last time when the project declined or revoked the agreement to terms
       * of service.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp decline_time = 6;</code>
       *
       * @return Whether the declineTime field is set.
       */
      public boolean hasDeclineTime() {
        return ((bitField0_ & 0x00000010) != 0);
      }
      /**
       *
       *
       * <pre>
       * The last time when the project declined or revoked the agreement to terms
       * of service.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp decline_time = 6;</code>
       *
       * @return The declineTime.
       */
      public com.google.protobuf.Timestamp getDeclineTime() {
        if (declineTimeBuilder_ == null) {
          return declineTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : declineTime_;
        } else {
          return declineTimeBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The last time when the project declined or revoked the agreement to terms
       * of service.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp decline_time = 6;</code>
       */
      public Builder setDeclineTime(com.google.protobuf.Timestamp value) {
        if (declineTimeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          declineTime_ = value;
        } else {
          declineTimeBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The last time when the project declined or revoked the agreement to terms
       * of service.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp decline_time = 6;</code>
       */
      public Builder setDeclineTime(com.google.protobuf.Timestamp.Builder builderForValue) {
        if (declineTimeBuilder_ == null) {
          declineTime_ = builderForValue.build();
        } else {
          declineTimeBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The last time when the project declined or revoked the agreement to terms
       * of service.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp decline_time = 6;</code>
       */
      public Builder mergeDeclineTime(com.google.protobuf.Timestamp value) {
        if (declineTimeBuilder_ == null) {
          if (((bitField0_ & 0x00000010) != 0)
              && declineTime_ != null
              && declineTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
            getDeclineTimeBuilder().mergeFrom(value);
          } else {
            declineTime_ = value;
          }
        } else {
          declineTimeBuilder_.mergeFrom(value);
        }
        if (declineTime_ != null) {
          bitField0_ |= 0x00000010;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The last time when the project declined or revoked the agreement to terms
       * of service.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp decline_time = 6;</code>
       */
      public Builder clearDeclineTime() {
        bitField0_ = (bitField0_ & ~0x00000010);
        declineTime_ = null;
        if (declineTimeBuilder_ != null) {
          declineTimeBuilder_.dispose();
          declineTimeBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The last time when the project declined or revoked the agreement to terms
       * of service.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp decline_time = 6;</code>
       */
      public com.google.protobuf.Timestamp.Builder getDeclineTimeBuilder() {
        bitField0_ |= 0x00000010;
        onChanged();
        return getDeclineTimeFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The last time when the project declined or revoked the agreement to terms
       * of service.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp decline_time = 6;</code>
       */
      public com.google.protobuf.TimestampOrBuilder getDeclineTimeOrBuilder() {
        if (declineTimeBuilder_ != null) {
          return declineTimeBuilder_.getMessageOrBuilder();
        } else {
          return declineTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : declineTime_;
        }
      }
      /**
       *
       *
       * <pre>
       * The last time when the project declined or revoked the agreement to terms
       * of service.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp decline_time = 6;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          getDeclineTimeFieldBuilder() {
        if (declineTimeBuilder_ == null) {
          declineTimeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Timestamp,
                  com.google.protobuf.Timestamp.Builder,
                  com.google.protobuf.TimestampOrBuilder>(
                  getDeclineTime(), getParentForChildren(), isClean());
          declineTime_ = null;
        }
        return declineTimeBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.Project.ServiceTerms)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.Project.ServiceTerms)
    private static final com.google.cloud.discoveryengine.v1beta.Project.ServiceTerms
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.discoveryengine.v1beta.Project.ServiceTerms();
    }

    public static com.google.cloud.discoveryengine.v1beta.Project.ServiceTerms
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ServiceTerms> PARSER =
        new com.google.protobuf.AbstractParser<ServiceTerms>() {
          @java.lang.Override
          public ServiceTerms parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ServiceTerms> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ServiceTerms> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.Project.ServiceTerms
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Full resource name of the project, for example
   * `projects/{project_number}`.
   * Note that when making requests, project number and project id are both
   * acceptable, but the server will always respond in project number.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Full resource name of the project, for example
   * `projects/{project_number}`.
   * Note that when making requests, project number and project id are both
   * acceptable, but the server will always respond in project number.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 2;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. The timestamp when this project is created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The timestamp when this project is created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The timestamp when this project is created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int PROVISION_COMPLETION_TIME_FIELD_NUMBER = 3;
  private com.google.protobuf.Timestamp provisionCompletionTime_;
  /**
   *
   *
   * <pre>
   * Output only. The timestamp when this project is successfully provisioned.
   * Empty value means this project is still provisioning and is not ready for
   * use.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp provision_completion_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the provisionCompletionTime field is set.
   */
  @java.lang.Override
  public boolean hasProvisionCompletionTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The timestamp when this project is successfully provisioned.
   * Empty value means this project is still provisioning and is not ready for
   * use.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp provision_completion_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The provisionCompletionTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getProvisionCompletionTime() {
    return provisionCompletionTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : provisionCompletionTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The timestamp when this project is successfully provisioned.
   * Empty value means this project is still provisioning and is not ready for
   * use.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp provision_completion_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getProvisionCompletionTimeOrBuilder() {
    return provisionCompletionTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : provisionCompletionTime_;
  }

  public static final int SERVICE_TERMS_MAP_FIELD_NUMBER = 4;

  private static final class ServiceTermsMapDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<
            java.lang.String, com.google.cloud.discoveryengine.v1beta.Project.ServiceTerms>
        defaultEntry =
            com.google.protobuf.MapEntry
                .<java.lang.String, com.google.cloud.discoveryengine.v1beta.Project.ServiceTerms>
                    newDefaultInstance(
                        com.google.cloud.discoveryengine.v1beta.ProjectProto
                            .internal_static_google_cloud_discoveryengine_v1beta_Project_ServiceTermsMapEntry_descriptor,
                        com.google.protobuf.WireFormat.FieldType.STRING,
                        "",
                        com.google.protobuf.WireFormat.FieldType.MESSAGE,
                        com.google.cloud.discoveryengine.v1beta.Project.ServiceTerms
                            .getDefaultInstance());
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<
          java.lang.String, com.google.cloud.discoveryengine.v1beta.Project.ServiceTerms>
      serviceTermsMap_;

  private com.google.protobuf.MapField<
          java.lang.String, com.google.cloud.discoveryengine.v1beta.Project.ServiceTerms>
      internalGetServiceTermsMap() {
    if (serviceTermsMap_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          ServiceTermsMapDefaultEntryHolder.defaultEntry);
    }
    return serviceTermsMap_;
  }

  public int getServiceTermsMapCount() {
    return internalGetServiceTermsMap().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Output only. A map of terms of services. The key is the `id` of
   * [ServiceTerms][google.cloud.discoveryengine.v1beta.Project.ServiceTerms].
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.discoveryengine.v1beta.Project.ServiceTerms&gt; service_terms_map = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public boolean containsServiceTermsMap(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetServiceTermsMap().getMap().containsKey(key);
  }
  /** Use {@link #getServiceTermsMapMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<
          java.lang.String, com.google.cloud.discoveryengine.v1beta.Project.ServiceTerms>
      getServiceTermsMap() {
    return getServiceTermsMapMap();
  }
  /**
   *
   *
   * <pre>
   * Output only. A map of terms of services. The key is the `id` of
   * [ServiceTerms][google.cloud.discoveryengine.v1beta.Project.ServiceTerms].
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.discoveryengine.v1beta.Project.ServiceTerms&gt; service_terms_map = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.Map<
          java.lang.String, com.google.cloud.discoveryengine.v1beta.Project.ServiceTerms>
      getServiceTermsMapMap() {
    return internalGetServiceTermsMap().getMap();
  }
  /**
   *
   *
   * <pre>
   * Output only. A map of terms of services. The key is the `id` of
   * [ServiceTerms][google.cloud.discoveryengine.v1beta.Project.ServiceTerms].
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.discoveryengine.v1beta.Project.ServiceTerms&gt; service_terms_map = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public /* nullable */ com.google.cloud.discoveryengine.v1beta.Project.ServiceTerms
      getServiceTermsMapOrDefault(
          java.lang.String key,
          /* nullable */
          com.google.cloud.discoveryengine.v1beta.Project.ServiceTerms defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.cloud.discoveryengine.v1beta.Project.ServiceTerms>
        map = internalGetServiceTermsMap().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Output only. A map of terms of services. The key is the `id` of
   * [ServiceTerms][google.cloud.discoveryengine.v1beta.Project.ServiceTerms].
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.discoveryengine.v1beta.Project.ServiceTerms&gt; service_terms_map = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.Project.ServiceTerms getServiceTermsMapOrThrow(
      java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.cloud.discoveryengine.v1beta.Project.ServiceTerms>
        map = internalGetServiceTermsMap().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(2, getCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(3, getProvisionCompletionTime());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetServiceTermsMap(), ServiceTermsMapDefaultEntryHolder.defaultEntry, 4);
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(3, getProvisionCompletionTime());
    }
    for (java.util.Map.Entry<
            java.lang.String, com.google.cloud.discoveryengine.v1beta.Project.ServiceTerms>
        entry : internalGetServiceTermsMap().getMap().entrySet()) {
      com.google.protobuf.MapEntry<
              java.lang.String, com.google.cloud.discoveryengine.v1beta.Project.ServiceTerms>
          serviceTermsMap__ =
              ServiceTermsMapDefaultEntryHolder.defaultEntry
                  .newBuilderForType()
                  .setKey(entry.getKey())
                  .setValue(entry.getValue())
                  .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, serviceTermsMap__);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.discoveryengine.v1beta.Project)) {
      return super.equals(obj);
    }
    com.google.cloud.discoveryengine.v1beta.Project other =
        (com.google.cloud.discoveryengine.v1beta.Project) obj;

    if (!getName().equals(other.getName())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasProvisionCompletionTime() != other.hasProvisionCompletionTime()) return false;
    if (hasProvisionCompletionTime()) {
      if (!getProvisionCompletionTime().equals(other.getProvisionCompletionTime())) return false;
    }
    if (!internalGetServiceTermsMap().equals(other.internalGetServiceTermsMap())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasProvisionCompletionTime()) {
      hash = (37 * hash) + PROVISION_COMPLETION_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getProvisionCompletionTime().hashCode();
    }
    if (!internalGetServiceTermsMap().getMap().isEmpty()) {
      hash = (37 * hash) + SERVICE_TERMS_MAP_FIELD_NUMBER;
      hash = (53 * hash) + internalGetServiceTermsMap().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.discoveryengine.v1beta.Project parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1beta.Project parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.Project parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1beta.Project parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.Project parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1beta.Project parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.Project parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1beta.Project parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.Project parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1beta.Project parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.Project parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1beta.Project parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.discoveryengine.v1beta.Project prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Metadata and configurations for a Google Cloud project in the service.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1beta.Project}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.Project)
      com.google.cloud.discoveryengine.v1beta.ProjectOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1beta.ProjectProto
          .internal_static_google_cloud_discoveryengine_v1beta_Project_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 4:
          return internalGetServiceTermsMap();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 4:
          return internalGetMutableServiceTermsMap();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1beta.ProjectProto
          .internal_static_google_cloud_discoveryengine_v1beta_Project_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1beta.Project.class,
              com.google.cloud.discoveryengine.v1beta.Project.Builder.class);
    }

    // Construct using com.google.cloud.discoveryengine.v1beta.Project.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getCreateTimeFieldBuilder();
        getProvisionCompletionTimeFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      provisionCompletionTime_ = null;
      if (provisionCompletionTimeBuilder_ != null) {
        provisionCompletionTimeBuilder_.dispose();
        provisionCompletionTimeBuilder_ = null;
      }
      internalGetMutableServiceTermsMap().clear();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.discoveryengine.v1beta.ProjectProto
          .internal_static_google_cloud_discoveryengine_v1beta_Project_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.Project getDefaultInstanceForType() {
      return com.google.cloud.discoveryengine.v1beta.Project.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.Project build() {
      com.google.cloud.discoveryengine.v1beta.Project result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.Project buildPartial() {
      com.google.cloud.discoveryengine.v1beta.Project result =
          new com.google.cloud.discoveryengine.v1beta.Project(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.discoveryengine.v1beta.Project result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.provisionCompletionTime_ =
            provisionCompletionTimeBuilder_ == null
                ? provisionCompletionTime_
                : provisionCompletionTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.serviceTermsMap_ =
            internalGetServiceTermsMap().build(ServiceTermsMapDefaultEntryHolder.defaultEntry);
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.discoveryengine.v1beta.Project) {
        return mergeFrom((com.google.cloud.discoveryengine.v1beta.Project) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.discoveryengine.v1beta.Project other) {
      if (other == com.google.cloud.discoveryengine.v1beta.Project.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasProvisionCompletionTime()) {
        mergeProvisionCompletionTime(other.getProvisionCompletionTime());
      }
      internalGetMutableServiceTermsMap().mergeFrom(other.internalGetServiceTermsMap());
      bitField0_ |= 0x00000008;
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(
                    getProvisionCompletionTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                com.google.protobuf.MapEntry<
                        java.lang.String,
                        com.google.cloud.discoveryengine.v1beta.Project.ServiceTerms>
                    serviceTermsMap__ =
                        input.readMessage(
                            ServiceTermsMapDefaultEntryHolder.defaultEntry.getParserForType(),
                            extensionRegistry);
                internalGetMutableServiceTermsMap()
                    .ensureBuilderMap()
                    .put(serviceTermsMap__.getKey(), serviceTermsMap__.getValue());
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Full resource name of the project, for example
     * `projects/{project_number}`.
     * Note that when making requests, project number and project id are both
     * acceptable, but the server will always respond in project number.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Full resource name of the project, for example
     * `projects/{project_number}`.
     * Note that when making requests, project number and project id are both
     * acceptable, but the server will always respond in project number.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Full resource name of the project, for example
     * `projects/{project_number}`.
     * Note that when making requests, project number and project id are both
     * acceptable, but the server will always respond in project number.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Full resource name of the project, for example
     * `projects/{project_number}`.
     * Note that when making requests, project number and project id are both
     * acceptable, but the server will always respond in project number.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Full resource name of the project, for example
     * `projects/{project_number}`.
     * Note that when making requests, project number and project id are both
     * acceptable, but the server will always respond in project number.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when this project is created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when this project is created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when this project is created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when this project is created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when this project is created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when this project is created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000002);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when this project is created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when this project is created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when this project is created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp provisionCompletionTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        provisionCompletionTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when this project is successfully provisioned.
     * Empty value means this project is still provisioning and is not ready for
     * use.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp provision_completion_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the provisionCompletionTime field is set.
     */
    public boolean hasProvisionCompletionTime() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when this project is successfully provisioned.
     * Empty value means this project is still provisioning and is not ready for
     * use.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp provision_completion_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The provisionCompletionTime.
     */
    public com.google.protobuf.Timestamp getProvisionCompletionTime() {
      if (provisionCompletionTimeBuilder_ == null) {
        return provisionCompletionTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : provisionCompletionTime_;
      } else {
        return provisionCompletionTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when this project is successfully provisioned.
     * Empty value means this project is still provisioning and is not ready for
     * use.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp provision_completion_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setProvisionCompletionTime(com.google.protobuf.Timestamp value) {
      if (provisionCompletionTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        provisionCompletionTime_ = value;
      } else {
        provisionCompletionTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when this project is successfully provisioned.
     * Empty value means this project is still provisioning and is not ready for
     * use.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp provision_completion_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setProvisionCompletionTime(
        com.google.protobuf.Timestamp.Builder builderForValue) {
      if (provisionCompletionTimeBuilder_ == null) {
        provisionCompletionTime_ = builderForValue.build();
      } else {
        provisionCompletionTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when this project is successfully provisioned.
     * Empty value means this project is still provisioning and is not ready for
     * use.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp provision_completion_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeProvisionCompletionTime(com.google.protobuf.Timestamp value) {
      if (provisionCompletionTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && provisionCompletionTime_ != null
            && provisionCompletionTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getProvisionCompletionTimeBuilder().mergeFrom(value);
        } else {
          provisionCompletionTime_ = value;
        }
      } else {
        provisionCompletionTimeBuilder_.mergeFrom(value);
      }
      if (provisionCompletionTime_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when this project is successfully provisioned.
     * Empty value means this project is still provisioning and is not ready for
     * use.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp provision_completion_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearProvisionCompletionTime() {
      bitField0_ = (bitField0_ & ~0x00000004);
      provisionCompletionTime_ = null;
      if (provisionCompletionTimeBuilder_ != null) {
        provisionCompletionTimeBuilder_.dispose();
        provisionCompletionTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when this project is successfully provisioned.
     * Empty value means this project is still provisioning and is not ready for
     * use.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp provision_completion_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getProvisionCompletionTimeBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getProvisionCompletionTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when this project is successfully provisioned.
     * Empty value means this project is still provisioning and is not ready for
     * use.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp provision_completion_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getProvisionCompletionTimeOrBuilder() {
      if (provisionCompletionTimeBuilder_ != null) {
        return provisionCompletionTimeBuilder_.getMessageOrBuilder();
      } else {
        return provisionCompletionTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : provisionCompletionTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when this project is successfully provisioned.
     * Empty value means this project is still provisioning and is not ready for
     * use.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp provision_completion_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getProvisionCompletionTimeFieldBuilder() {
      if (provisionCompletionTimeBuilder_ == null) {
        provisionCompletionTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getProvisionCompletionTime(), getParentForChildren(), isClean());
        provisionCompletionTime_ = null;
      }
      return provisionCompletionTimeBuilder_;
    }

    private static final class ServiceTermsMapConverter
        implements com.google.protobuf.MapFieldBuilder.Converter<
            java.lang.String,
            com.google.cloud.discoveryengine.v1beta.Project.ServiceTermsOrBuilder,
            com.google.cloud.discoveryengine.v1beta.Project.ServiceTerms> {
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.Project.ServiceTerms build(
          com.google.cloud.discoveryengine.v1beta.Project.ServiceTermsOrBuilder val) {
        if (val instanceof com.google.cloud.discoveryengine.v1beta.Project.ServiceTerms) {
          return (com.google.cloud.discoveryengine.v1beta.Project.ServiceTerms) val;
        }
        return ((com.google.cloud.discoveryengine.v1beta.Project.ServiceTerms.Builder) val).build();
      }

      @java.lang.Override
      public com.google.protobuf.MapEntry<
              java.lang.String, com.google.cloud.discoveryengine.v1beta.Project.ServiceTerms>
          defaultEntry() {
        return ServiceTermsMapDefaultEntryHolder.defaultEntry;
      }
    };

    private static final ServiceTermsMapConverter serviceTermsMapConverter =
        new ServiceTermsMapConverter();

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.cloud.discoveryengine.v1beta.Project.ServiceTermsOrBuilder,
            com.google.cloud.discoveryengine.v1beta.Project.ServiceTerms,
            com.google.cloud.discoveryengine.v1beta.Project.ServiceTerms.Builder>
        serviceTermsMap_;

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.cloud.discoveryengine.v1beta.Project.ServiceTermsOrBuilder,
            com.google.cloud.discoveryengine.v1beta.Project.ServiceTerms,
            com.google.cloud.discoveryengine.v1beta.Project.ServiceTerms.Builder>
        internalGetServiceTermsMap() {
      if (serviceTermsMap_ == null) {
        return new com.google.protobuf.MapFieldBuilder<>(serviceTermsMapConverter);
      }
      return serviceTermsMap_;
    }

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.cloud.discoveryengine.v1beta.Project.ServiceTermsOrBuilder,
            com.google.cloud.discoveryengine.v1beta.Project.ServiceTerms,
            com.google.cloud.discoveryengine.v1beta.Project.ServiceTerms.Builder>
        internalGetMutableServiceTermsMap() {
      if (serviceTermsMap_ == null) {
        serviceTermsMap_ = new com.google.protobuf.MapFieldBuilder<>(serviceTermsMapConverter);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return serviceTermsMap_;
    }

    public int getServiceTermsMapCount() {
      return internalGetServiceTermsMap().ensureBuilderMap().size();
    }
    /**
     *
     *
     * <pre>
     * Output only. A map of terms of services. The key is the `id` of
     * [ServiceTerms][google.cloud.discoveryengine.v1beta.Project.ServiceTerms].
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.discoveryengine.v1beta.Project.ServiceTerms&gt; service_terms_map = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public boolean containsServiceTermsMap(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetServiceTermsMap().ensureBuilderMap().containsKey(key);
    }
    /** Use {@link #getServiceTermsMapMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<
            java.lang.String, com.google.cloud.discoveryengine.v1beta.Project.ServiceTerms>
        getServiceTermsMap() {
      return getServiceTermsMapMap();
    }
    /**
     *
     *
     * <pre>
     * Output only. A map of terms of services. The key is the `id` of
     * [ServiceTerms][google.cloud.discoveryengine.v1beta.Project.ServiceTerms].
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.discoveryengine.v1beta.Project.ServiceTerms&gt; service_terms_map = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public java.util.Map<
            java.lang.String, com.google.cloud.discoveryengine.v1beta.Project.ServiceTerms>
        getServiceTermsMapMap() {
      return internalGetServiceTermsMap().getImmutableMap();
    }
    /**
     *
     *
     * <pre>
     * Output only. A map of terms of services. The key is the `id` of
     * [ServiceTerms][google.cloud.discoveryengine.v1beta.Project.ServiceTerms].
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.discoveryengine.v1beta.Project.ServiceTerms&gt; service_terms_map = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public /* nullable */ com.google.cloud.discoveryengine.v1beta.Project.ServiceTerms
        getServiceTermsMapOrDefault(
            java.lang.String key,
            /* nullable */
            com.google.cloud.discoveryengine.v1beta.Project.ServiceTerms defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<
              java.lang.String,
              com.google.cloud.discoveryengine.v1beta.Project.ServiceTermsOrBuilder>
          map = internalGetMutableServiceTermsMap().ensureBuilderMap();
      return map.containsKey(key) ? serviceTermsMapConverter.build(map.get(key)) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Output only. A map of terms of services. The key is the `id` of
     * [ServiceTerms][google.cloud.discoveryengine.v1beta.Project.ServiceTerms].
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.discoveryengine.v1beta.Project.ServiceTerms&gt; service_terms_map = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.Project.ServiceTerms getServiceTermsMapOrThrow(
        java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<
              java.lang.String,
              com.google.cloud.discoveryengine.v1beta.Project.ServiceTermsOrBuilder>
          map = internalGetMutableServiceTermsMap().ensureBuilderMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return serviceTermsMapConverter.build(map.get(key));
    }

    public Builder clearServiceTermsMap() {
      bitField0_ = (bitField0_ & ~0x00000008);
      internalGetMutableServiceTermsMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A map of terms of services. The key is the `id` of
     * [ServiceTerms][google.cloud.discoveryengine.v1beta.Project.ServiceTerms].
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.discoveryengine.v1beta.Project.ServiceTerms&gt; service_terms_map = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeServiceTermsMap(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableServiceTermsMap().ensureBuilderMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<
            java.lang.String, com.google.cloud.discoveryengine.v1beta.Project.ServiceTerms>
        getMutableServiceTermsMap() {
      bitField0_ |= 0x00000008;
      return internalGetMutableServiceTermsMap().ensureMessageMap();
    }
    /**
     *
     *
     * <pre>
     * Output only. A map of terms of services. The key is the `id` of
     * [ServiceTerms][google.cloud.discoveryengine.v1beta.Project.ServiceTerms].
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.discoveryengine.v1beta.Project.ServiceTerms&gt; service_terms_map = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder putServiceTermsMap(
        java.lang.String key, com.google.cloud.discoveryengine.v1beta.Project.ServiceTerms value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableServiceTermsMap().ensureBuilderMap().put(key, value);
      bitField0_ |= 0x00000008;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A map of terms of services. The key is the `id` of
     * [ServiceTerms][google.cloud.discoveryengine.v1beta.Project.ServiceTerms].
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.discoveryengine.v1beta.Project.ServiceTerms&gt; service_terms_map = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder putAllServiceTermsMap(
        java.util.Map<
                java.lang.String, com.google.cloud.discoveryengine.v1beta.Project.ServiceTerms>
            values) {
      for (java.util.Map.Entry<
              java.lang.String, com.google.cloud.discoveryengine.v1beta.Project.ServiceTerms>
          e : values.entrySet()) {
        if (e.getKey() == null || e.getValue() == null) {
          throw new NullPointerException();
        }
      }
      internalGetMutableServiceTermsMap().ensureBuilderMap().putAll(values);
      bitField0_ |= 0x00000008;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A map of terms of services. The key is the `id` of
     * [ServiceTerms][google.cloud.discoveryengine.v1beta.Project.ServiceTerms].
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.discoveryengine.v1beta.Project.ServiceTerms&gt; service_terms_map = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.discoveryengine.v1beta.Project.ServiceTerms.Builder
        putServiceTermsMapBuilderIfAbsent(java.lang.String key) {
      java.util.Map<
              java.lang.String,
              com.google.cloud.discoveryengine.v1beta.Project.ServiceTermsOrBuilder>
          builderMap = internalGetMutableServiceTermsMap().ensureBuilderMap();
      com.google.cloud.discoveryengine.v1beta.Project.ServiceTermsOrBuilder entry =
          builderMap.get(key);
      if (entry == null) {
        entry = com.google.cloud.discoveryengine.v1beta.Project.ServiceTerms.newBuilder();
        builderMap.put(key, entry);
      }
      if (entry instanceof com.google.cloud.discoveryengine.v1beta.Project.ServiceTerms) {
        entry = ((com.google.cloud.discoveryengine.v1beta.Project.ServiceTerms) entry).toBuilder();
        builderMap.put(key, entry);
      }
      return (com.google.cloud.discoveryengine.v1beta.Project.ServiceTerms.Builder) entry;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.Project)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.Project)
  private static final com.google.cloud.discoveryengine.v1beta.Project DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.discoveryengine.v1beta.Project();
  }

  public static com.google.cloud.discoveryengine.v1beta.Project getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Project> PARSER =
      new com.google.protobuf.AbstractParser<Project>() {
        @java.lang.Override
        public Project parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Project> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Project> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.Project getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
