/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/discoveryengine/v1beta/sample_query.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.discoveryengine.v1beta;

/**
 *
 *
 * <pre>
 * Sample Query captures metadata to be used for evaluation.
 * </pre>
 *
 * Protobuf type {@code google.cloud.discoveryengine.v1beta.SampleQuery}
 */
public final class SampleQuery extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.SampleQuery)
    SampleQueryOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use SampleQuery.newBuilder() to construct.
  private SampleQuery(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private SampleQuery() {
    name_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new SampleQuery();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.discoveryengine.v1beta.SampleQueryProto
        .internal_static_google_cloud_discoveryengine_v1beta_SampleQuery_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.discoveryengine.v1beta.SampleQueryProto
        .internal_static_google_cloud_discoveryengine_v1beta_SampleQuery_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.discoveryengine.v1beta.SampleQuery.class,
            com.google.cloud.discoveryengine.v1beta.SampleQuery.Builder.class);
  }

  public interface QueryEntryOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. The query.
     * </pre>
     *
     * <code>string query = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The query.
     */
    java.lang.String getQuery();
    /**
     *
     *
     * <pre>
     * Required. The query.
     * </pre>
     *
     * <code>string query = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for query.
     */
    com.google.protobuf.ByteString getQueryBytes();

    /**
     *
     *
     * <pre>
     * List of targets for the query.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.Target targets = 3;
     * </code>
     */
    java.util.List<com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.Target>
        getTargetsList();
    /**
     *
     *
     * <pre>
     * List of targets for the query.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.Target targets = 3;
     * </code>
     */
    com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.Target getTargets(int index);
    /**
     *
     *
     * <pre>
     * List of targets for the query.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.Target targets = 3;
     * </code>
     */
    int getTargetsCount();
    /**
     *
     *
     * <pre>
     * List of targets for the query.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.Target targets = 3;
     * </code>
     */
    java.util.List<
            ? extends
                com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.TargetOrBuilder>
        getTargetsOrBuilderList();
    /**
     *
     *
     * <pre>
     * List of targets for the query.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.Target targets = 3;
     * </code>
     */
    com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.TargetOrBuilder
        getTargetsOrBuilder(int index);
  }
  /**
   *
   *
   * <pre>
   * Query Entry captures metadata to be used for search evaluation.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry}
   */
  public static final class QueryEntry extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry)
      QueryEntryOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use QueryEntry.newBuilder() to construct.
    private QueryEntry(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private QueryEntry() {
      query_ = "";
      targets_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new QueryEntry();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1beta.SampleQueryProto
          .internal_static_google_cloud_discoveryengine_v1beta_SampleQuery_QueryEntry_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1beta.SampleQueryProto
          .internal_static_google_cloud_discoveryengine_v1beta_SampleQuery_QueryEntry_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.class,
              com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.Builder.class);
    }

    public interface TargetOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.Target)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Expected uri of the target.
       *
       * This field must be a UTF-8 encoded string with a length limit of 2048
       * characters.
       *
       * Example of valid uris: `https://example.com/abc`,
       * `gcs://example/example.pdf`.
       * </pre>
       *
       * <code>string uri = 1;</code>
       *
       * @return The uri.
       */
      java.lang.String getUri();
      /**
       *
       *
       * <pre>
       * Expected uri of the target.
       *
       * This field must be a UTF-8 encoded string with a length limit of 2048
       * characters.
       *
       * Example of valid uris: `https://example.com/abc`,
       * `gcs://example/example.pdf`.
       * </pre>
       *
       * <code>string uri = 1;</code>
       *
       * @return The bytes for uri.
       */
      com.google.protobuf.ByteString getUriBytes();

      /**
       *
       *
       * <pre>
       * Expected page numbers of the target.
       *
       * Each page number must be non negative.
       * </pre>
       *
       * <code>repeated int32 page_numbers = 2;</code>
       *
       * @return A list containing the pageNumbers.
       */
      java.util.List<java.lang.Integer> getPageNumbersList();
      /**
       *
       *
       * <pre>
       * Expected page numbers of the target.
       *
       * Each page number must be non negative.
       * </pre>
       *
       * <code>repeated int32 page_numbers = 2;</code>
       *
       * @return The count of pageNumbers.
       */
      int getPageNumbersCount();
      /**
       *
       *
       * <pre>
       * Expected page numbers of the target.
       *
       * Each page number must be non negative.
       * </pre>
       *
       * <code>repeated int32 page_numbers = 2;</code>
       *
       * @param index The index of the element to return.
       * @return The pageNumbers at the given index.
       */
      int getPageNumbers(int index);

      /**
       *
       *
       * <pre>
       * Relevance score of the target.
       * </pre>
       *
       * <code>optional double score = 3;</code>
       *
       * @return Whether the score field is set.
       */
      boolean hasScore();
      /**
       *
       *
       * <pre>
       * Relevance score of the target.
       * </pre>
       *
       * <code>optional double score = 3;</code>
       *
       * @return The score.
       */
      double getScore();
    }
    /**
     *
     *
     * <pre>
     * Defines the parameters of the query's expected outcome.
     * </pre>
     *
     * Protobuf type {@code google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.Target}
     */
    public static final class Target extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.Target)
        TargetOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use Target.newBuilder() to construct.
      private Target(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private Target() {
        uri_ = "";
        pageNumbers_ = emptyIntList();
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new Target();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1beta.SampleQueryProto
            .internal_static_google_cloud_discoveryengine_v1beta_SampleQuery_QueryEntry_Target_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1beta.SampleQueryProto
            .internal_static_google_cloud_discoveryengine_v1beta_SampleQuery_QueryEntry_Target_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.Target.class,
                com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.Target.Builder
                    .class);
      }

      private int bitField0_;
      public static final int URI_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private volatile java.lang.Object uri_ = "";
      /**
       *
       *
       * <pre>
       * Expected uri of the target.
       *
       * This field must be a UTF-8 encoded string with a length limit of 2048
       * characters.
       *
       * Example of valid uris: `https://example.com/abc`,
       * `gcs://example/example.pdf`.
       * </pre>
       *
       * <code>string uri = 1;</code>
       *
       * @return The uri.
       */
      @java.lang.Override
      public java.lang.String getUri() {
        java.lang.Object ref = uri_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          uri_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Expected uri of the target.
       *
       * This field must be a UTF-8 encoded string with a length limit of 2048
       * characters.
       *
       * Example of valid uris: `https://example.com/abc`,
       * `gcs://example/example.pdf`.
       * </pre>
       *
       * <code>string uri = 1;</code>
       *
       * @return The bytes for uri.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getUriBytes() {
        java.lang.Object ref = uri_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          uri_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int PAGE_NUMBERS_FIELD_NUMBER = 2;

      @SuppressWarnings("serial")
      private com.google.protobuf.Internal.IntList pageNumbers_ = emptyIntList();
      /**
       *
       *
       * <pre>
       * Expected page numbers of the target.
       *
       * Each page number must be non negative.
       * </pre>
       *
       * <code>repeated int32 page_numbers = 2;</code>
       *
       * @return A list containing the pageNumbers.
       */
      @java.lang.Override
      public java.util.List<java.lang.Integer> getPageNumbersList() {
        return pageNumbers_;
      }
      /**
       *
       *
       * <pre>
       * Expected page numbers of the target.
       *
       * Each page number must be non negative.
       * </pre>
       *
       * <code>repeated int32 page_numbers = 2;</code>
       *
       * @return The count of pageNumbers.
       */
      public int getPageNumbersCount() {
        return pageNumbers_.size();
      }
      /**
       *
       *
       * <pre>
       * Expected page numbers of the target.
       *
       * Each page number must be non negative.
       * </pre>
       *
       * <code>repeated int32 page_numbers = 2;</code>
       *
       * @param index The index of the element to return.
       * @return The pageNumbers at the given index.
       */
      public int getPageNumbers(int index) {
        return pageNumbers_.getInt(index);
      }

      private int pageNumbersMemoizedSerializedSize = -1;

      public static final int SCORE_FIELD_NUMBER = 3;
      private double score_ = 0D;
      /**
       *
       *
       * <pre>
       * Relevance score of the target.
       * </pre>
       *
       * <code>optional double score = 3;</code>
       *
       * @return Whether the score field is set.
       */
      @java.lang.Override
      public boolean hasScore() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * Relevance score of the target.
       * </pre>
       *
       * <code>optional double score = 3;</code>
       *
       * @return The score.
       */
      @java.lang.Override
      public double getScore() {
        return score_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        getSerializedSize();
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uri_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, uri_);
        }
        if (getPageNumbersList().size() > 0) {
          output.writeUInt32NoTag(18);
          output.writeUInt32NoTag(pageNumbersMemoizedSerializedSize);
        }
        for (int i = 0; i < pageNumbers_.size(); i++) {
          output.writeInt32NoTag(pageNumbers_.getInt(i));
        }
        if (((bitField0_ & 0x00000001) != 0)) {
          output.writeDouble(3, score_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uri_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, uri_);
        }
        {
          int dataSize = 0;
          for (int i = 0; i < pageNumbers_.size(); i++) {
            dataSize +=
                com.google.protobuf.CodedOutputStream.computeInt32SizeNoTag(pageNumbers_.getInt(i));
          }
          size += dataSize;
          if (!getPageNumbersList().isEmpty()) {
            size += 1;
            size += com.google.protobuf.CodedOutputStream.computeInt32SizeNoTag(dataSize);
          }
          pageNumbersMemoizedSerializedSize = dataSize;
        }
        if (((bitField0_ & 0x00000001) != 0)) {
          size += com.google.protobuf.CodedOutputStream.computeDoubleSize(3, score_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.Target)) {
          return super.equals(obj);
        }
        com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.Target other =
            (com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.Target) obj;

        if (!getUri().equals(other.getUri())) return false;
        if (!getPageNumbersList().equals(other.getPageNumbersList())) return false;
        if (hasScore() != other.hasScore()) return false;
        if (hasScore()) {
          if (java.lang.Double.doubleToLongBits(getScore())
              != java.lang.Double.doubleToLongBits(other.getScore())) return false;
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + URI_FIELD_NUMBER;
        hash = (53 * hash) + getUri().hashCode();
        if (getPageNumbersCount() > 0) {
          hash = (37 * hash) + PAGE_NUMBERS_FIELD_NUMBER;
          hash = (53 * hash) + getPageNumbersList().hashCode();
        }
        if (hasScore()) {
          hash = (37 * hash) + SCORE_FIELD_NUMBER;
          hash =
              (53 * hash)
                  + com.google.protobuf.Internal.hashLong(
                      java.lang.Double.doubleToLongBits(getScore()));
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.Target parseFrom(
          java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.Target parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.Target parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.Target parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.Target parseFrom(
          byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.Target parseFrom(
          byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.Target parseFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.Target parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.Target
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.Target
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.Target parseFrom(
          com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.Target parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.Target prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Defines the parameters of the query's expected outcome.
       * </pre>
       *
       * Protobuf type {@code google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.Target}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.Target)
          com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.TargetOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.discoveryengine.v1beta.SampleQueryProto
              .internal_static_google_cloud_discoveryengine_v1beta_SampleQuery_QueryEntry_Target_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.discoveryengine.v1beta.SampleQueryProto
              .internal_static_google_cloud_discoveryengine_v1beta_SampleQuery_QueryEntry_Target_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.Target.class,
                  com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.Target.Builder
                      .class);
        }

        // Construct using
        // com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.Target.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          uri_ = "";
          pageNumbers_ = emptyIntList();
          score_ = 0D;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.discoveryengine.v1beta.SampleQueryProto
              .internal_static_google_cloud_discoveryengine_v1beta_SampleQuery_QueryEntry_Target_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.Target
            getDefaultInstanceForType() {
          return com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.Target
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.Target build() {
          com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.Target result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.Target
            buildPartial() {
          com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.Target result =
              new com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.Target(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.Target result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.uri_ = uri_;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            pageNumbers_.makeImmutable();
            result.pageNumbers_ = pageNumbers_;
          }
          int to_bitField0_ = 0;
          if (((from_bitField0_ & 0x00000004) != 0)) {
            result.score_ = score_;
            to_bitField0_ |= 0x00000001;
          }
          result.bitField0_ |= to_bitField0_;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.Target) {
            return mergeFrom(
                (com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.Target) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.Target other) {
          if (other
              == com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.Target
                  .getDefaultInstance()) return this;
          if (!other.getUri().isEmpty()) {
            uri_ = other.uri_;
            bitField0_ |= 0x00000001;
            onChanged();
          }
          if (!other.pageNumbers_.isEmpty()) {
            if (pageNumbers_.isEmpty()) {
              pageNumbers_ = other.pageNumbers_;
              pageNumbers_.makeImmutable();
              bitField0_ |= 0x00000002;
            } else {
              ensurePageNumbersIsMutable();
              pageNumbers_.addAll(other.pageNumbers_);
            }
            onChanged();
          }
          if (other.hasScore()) {
            setScore(other.getScore());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    uri_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                case 16:
                  {
                    int v = input.readInt32();
                    ensurePageNumbersIsMutable();
                    pageNumbers_.addInt(v);
                    break;
                  } // case 16
                case 18:
                  {
                    int length = input.readRawVarint32();
                    int limit = input.pushLimit(length);
                    ensurePageNumbersIsMutable();
                    while (input.getBytesUntilLimit() > 0) {
                      pageNumbers_.addInt(input.readInt32());
                    }
                    input.popLimit(limit);
                    break;
                  } // case 18
                case 25:
                  {
                    score_ = input.readDouble();
                    bitField0_ |= 0x00000004;
                    break;
                  } // case 25
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.lang.Object uri_ = "";
        /**
         *
         *
         * <pre>
         * Expected uri of the target.
         *
         * This field must be a UTF-8 encoded string with a length limit of 2048
         * characters.
         *
         * Example of valid uris: `https://example.com/abc`,
         * `gcs://example/example.pdf`.
         * </pre>
         *
         * <code>string uri = 1;</code>
         *
         * @return The uri.
         */
        public java.lang.String getUri() {
          java.lang.Object ref = uri_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            uri_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Expected uri of the target.
         *
         * This field must be a UTF-8 encoded string with a length limit of 2048
         * characters.
         *
         * Example of valid uris: `https://example.com/abc`,
         * `gcs://example/example.pdf`.
         * </pre>
         *
         * <code>string uri = 1;</code>
         *
         * @return The bytes for uri.
         */
        public com.google.protobuf.ByteString getUriBytes() {
          java.lang.Object ref = uri_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            uri_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Expected uri of the target.
         *
         * This field must be a UTF-8 encoded string with a length limit of 2048
         * characters.
         *
         * Example of valid uris: `https://example.com/abc`,
         * `gcs://example/example.pdf`.
         * </pre>
         *
         * <code>string uri = 1;</code>
         *
         * @param value The uri to set.
         * @return This builder for chaining.
         */
        public Builder setUri(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          uri_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Expected uri of the target.
         *
         * This field must be a UTF-8 encoded string with a length limit of 2048
         * characters.
         *
         * Example of valid uris: `https://example.com/abc`,
         * `gcs://example/example.pdf`.
         * </pre>
         *
         * <code>string uri = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearUri() {
          uri_ = getDefaultInstance().getUri();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Expected uri of the target.
         *
         * This field must be a UTF-8 encoded string with a length limit of 2048
         * characters.
         *
         * Example of valid uris: `https://example.com/abc`,
         * `gcs://example/example.pdf`.
         * </pre>
         *
         * <code>string uri = 1;</code>
         *
         * @param value The bytes for uri to set.
         * @return This builder for chaining.
         */
        public Builder setUriBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          uri_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        private com.google.protobuf.Internal.IntList pageNumbers_ = emptyIntList();

        private void ensurePageNumbersIsMutable() {
          if (!pageNumbers_.isModifiable()) {
            pageNumbers_ = makeMutableCopy(pageNumbers_);
          }
          bitField0_ |= 0x00000002;
        }
        /**
         *
         *
         * <pre>
         * Expected page numbers of the target.
         *
         * Each page number must be non negative.
         * </pre>
         *
         * <code>repeated int32 page_numbers = 2;</code>
         *
         * @return A list containing the pageNumbers.
         */
        public java.util.List<java.lang.Integer> getPageNumbersList() {
          pageNumbers_.makeImmutable();
          return pageNumbers_;
        }
        /**
         *
         *
         * <pre>
         * Expected page numbers of the target.
         *
         * Each page number must be non negative.
         * </pre>
         *
         * <code>repeated int32 page_numbers = 2;</code>
         *
         * @return The count of pageNumbers.
         */
        public int getPageNumbersCount() {
          return pageNumbers_.size();
        }
        /**
         *
         *
         * <pre>
         * Expected page numbers of the target.
         *
         * Each page number must be non negative.
         * </pre>
         *
         * <code>repeated int32 page_numbers = 2;</code>
         *
         * @param index The index of the element to return.
         * @return The pageNumbers at the given index.
         */
        public int getPageNumbers(int index) {
          return pageNumbers_.getInt(index);
        }
        /**
         *
         *
         * <pre>
         * Expected page numbers of the target.
         *
         * Each page number must be non negative.
         * </pre>
         *
         * <code>repeated int32 page_numbers = 2;</code>
         *
         * @param index The index to set the value at.
         * @param value The pageNumbers to set.
         * @return This builder for chaining.
         */
        public Builder setPageNumbers(int index, int value) {

          ensurePageNumbersIsMutable();
          pageNumbers_.setInt(index, value);
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Expected page numbers of the target.
         *
         * Each page number must be non negative.
         * </pre>
         *
         * <code>repeated int32 page_numbers = 2;</code>
         *
         * @param value The pageNumbers to add.
         * @return This builder for chaining.
         */
        public Builder addPageNumbers(int value) {

          ensurePageNumbersIsMutable();
          pageNumbers_.addInt(value);
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Expected page numbers of the target.
         *
         * Each page number must be non negative.
         * </pre>
         *
         * <code>repeated int32 page_numbers = 2;</code>
         *
         * @param values The pageNumbers to add.
         * @return This builder for chaining.
         */
        public Builder addAllPageNumbers(java.lang.Iterable<? extends java.lang.Integer> values) {
          ensurePageNumbersIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, pageNumbers_);
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Expected page numbers of the target.
         *
         * Each page number must be non negative.
         * </pre>
         *
         * <code>repeated int32 page_numbers = 2;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearPageNumbers() {
          pageNumbers_ = emptyIntList();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
          return this;
        }

        private double score_;
        /**
         *
         *
         * <pre>
         * Relevance score of the target.
         * </pre>
         *
         * <code>optional double score = 3;</code>
         *
         * @return Whether the score field is set.
         */
        @java.lang.Override
        public boolean hasScore() {
          return ((bitField0_ & 0x00000004) != 0);
        }
        /**
         *
         *
         * <pre>
         * Relevance score of the target.
         * </pre>
         *
         * <code>optional double score = 3;</code>
         *
         * @return The score.
         */
        @java.lang.Override
        public double getScore() {
          return score_;
        }
        /**
         *
         *
         * <pre>
         * Relevance score of the target.
         * </pre>
         *
         * <code>optional double score = 3;</code>
         *
         * @param value The score to set.
         * @return This builder for chaining.
         */
        public Builder setScore(double value) {

          score_ = value;
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Relevance score of the target.
         * </pre>
         *
         * <code>optional double score = 3;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearScore() {
          bitField0_ = (bitField0_ & ~0x00000004);
          score_ = 0D;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.Target)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.Target)
      private static final com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.Target
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.Target();
      }

      public static com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.Target
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<Target> PARSER =
          new com.google.protobuf.AbstractParser<Target>() {
            @java.lang.Override
            public Target parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<Target> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<Target> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.Target
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public static final int QUERY_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object query_ = "";
    /**
     *
     *
     * <pre>
     * Required. The query.
     * </pre>
     *
     * <code>string query = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The query.
     */
    @java.lang.Override
    public java.lang.String getQuery() {
      java.lang.Object ref = query_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        query_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The query.
     * </pre>
     *
     * <code>string query = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for query.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getQueryBytes() {
      java.lang.Object ref = query_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        query_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int TARGETS_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private java.util.List<com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.Target>
        targets_;
    /**
     *
     *
     * <pre>
     * List of targets for the query.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.Target targets = 3;
     * </code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.Target>
        getTargetsList() {
      return targets_;
    }
    /**
     *
     *
     * <pre>
     * List of targets for the query.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.Target targets = 3;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends
                com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.TargetOrBuilder>
        getTargetsOrBuilderList() {
      return targets_;
    }
    /**
     *
     *
     * <pre>
     * List of targets for the query.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.Target targets = 3;
     * </code>
     */
    @java.lang.Override
    public int getTargetsCount() {
      return targets_.size();
    }
    /**
     *
     *
     * <pre>
     * List of targets for the query.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.Target targets = 3;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.Target getTargets(
        int index) {
      return targets_.get(index);
    }
    /**
     *
     *
     * <pre>
     * List of targets for the query.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.Target targets = 3;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.TargetOrBuilder
        getTargetsOrBuilder(int index) {
      return targets_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(query_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, query_);
      }
      for (int i = 0; i < targets_.size(); i++) {
        output.writeMessage(3, targets_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(query_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, query_);
      }
      for (int i = 0; i < targets_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, targets_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry)) {
        return super.equals(obj);
      }
      com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry other =
          (com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry) obj;

      if (!getQuery().equals(other.getQuery())) return false;
      if (!getTargetsList().equals(other.getTargetsList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + QUERY_FIELD_NUMBER;
      hash = (53 * hash) + getQuery().hashCode();
      if (getTargetsCount() > 0) {
        hash = (37 * hash) + TARGETS_FIELD_NUMBER;
        hash = (53 * hash) + getTargetsList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Query Entry captures metadata to be used for search evaluation.
     * </pre>
     *
     * Protobuf type {@code google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry)
        com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntryOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1beta.SampleQueryProto
            .internal_static_google_cloud_discoveryengine_v1beta_SampleQuery_QueryEntry_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1beta.SampleQueryProto
            .internal_static_google_cloud_discoveryengine_v1beta_SampleQuery_QueryEntry_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.class,
                com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.Builder.class);
      }

      // Construct using com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        query_ = "";
        if (targetsBuilder_ == null) {
          targets_ = java.util.Collections.emptyList();
        } else {
          targets_ = null;
          targetsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.discoveryengine.v1beta.SampleQueryProto
            .internal_static_google_cloud_discoveryengine_v1beta_SampleQuery_QueryEntry_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry
          getDefaultInstanceForType() {
        return com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry build() {
        com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry buildPartial() {
        com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry result =
            new com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry result) {
        if (targetsBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)) {
            targets_ = java.util.Collections.unmodifiableList(targets_);
            bitField0_ = (bitField0_ & ~0x00000002);
          }
          result.targets_ = targets_;
        } else {
          result.targets_ = targetsBuilder_.build();
        }
      }

      private void buildPartial0(
          com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.query_ = query_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry) {
          return mergeFrom((com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry other) {
        if (other
            == com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.getDefaultInstance())
          return this;
        if (!other.getQuery().isEmpty()) {
          query_ = other.query_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (targetsBuilder_ == null) {
          if (!other.targets_.isEmpty()) {
            if (targets_.isEmpty()) {
              targets_ = other.targets_;
              bitField0_ = (bitField0_ & ~0x00000002);
            } else {
              ensureTargetsIsMutable();
              targets_.addAll(other.targets_);
            }
            onChanged();
          }
        } else {
          if (!other.targets_.isEmpty()) {
            if (targetsBuilder_.isEmpty()) {
              targetsBuilder_.dispose();
              targetsBuilder_ = null;
              targets_ = other.targets_;
              bitField0_ = (bitField0_ & ~0x00000002);
              targetsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getTargetsFieldBuilder()
                      : null;
            } else {
              targetsBuilder_.addAllMessages(other.targets_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  query_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 26:
                {
                  com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.Target m =
                      input.readMessage(
                          com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.Target
                              .parser(),
                          extensionRegistry);
                  if (targetsBuilder_ == null) {
                    ensureTargetsIsMutable();
                    targets_.add(m);
                  } else {
                    targetsBuilder_.addMessage(m);
                  }
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object query_ = "";
      /**
       *
       *
       * <pre>
       * Required. The query.
       * </pre>
       *
       * <code>string query = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The query.
       */
      public java.lang.String getQuery() {
        java.lang.Object ref = query_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          query_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The query.
       * </pre>
       *
       * <code>string query = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for query.
       */
      public com.google.protobuf.ByteString getQueryBytes() {
        java.lang.Object ref = query_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          query_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The query.
       * </pre>
       *
       * <code>string query = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The query to set.
       * @return This builder for chaining.
       */
      public Builder setQuery(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        query_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The query.
       * </pre>
       *
       * <code>string query = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearQuery() {
        query_ = getDefaultInstance().getQuery();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The query.
       * </pre>
       *
       * <code>string query = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for query to set.
       * @return This builder for chaining.
       */
      public Builder setQueryBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        query_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.util.List<com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.Target>
          targets_ = java.util.Collections.emptyList();

      private void ensureTargetsIsMutable() {
        if (!((bitField0_ & 0x00000002) != 0)) {
          targets_ =
              new java.util.ArrayList<
                  com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.Target>(targets_);
          bitField0_ |= 0x00000002;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.Target,
              com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.Target.Builder,
              com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.TargetOrBuilder>
          targetsBuilder_;

      /**
       *
       *
       * <pre>
       * List of targets for the query.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.Target targets = 3;
       * </code>
       */
      public java.util.List<com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.Target>
          getTargetsList() {
        if (targetsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(targets_);
        } else {
          return targetsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * List of targets for the query.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.Target targets = 3;
       * </code>
       */
      public int getTargetsCount() {
        if (targetsBuilder_ == null) {
          return targets_.size();
        } else {
          return targetsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * List of targets for the query.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.Target targets = 3;
       * </code>
       */
      public com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.Target getTargets(
          int index) {
        if (targetsBuilder_ == null) {
          return targets_.get(index);
        } else {
          return targetsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * List of targets for the query.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.Target targets = 3;
       * </code>
       */
      public Builder setTargets(
          int index, com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.Target value) {
        if (targetsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureTargetsIsMutable();
          targets_.set(index, value);
          onChanged();
        } else {
          targetsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of targets for the query.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.Target targets = 3;
       * </code>
       */
      public Builder setTargets(
          int index,
          com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.Target.Builder
              builderForValue) {
        if (targetsBuilder_ == null) {
          ensureTargetsIsMutable();
          targets_.set(index, builderForValue.build());
          onChanged();
        } else {
          targetsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of targets for the query.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.Target targets = 3;
       * </code>
       */
      public Builder addTargets(
          com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.Target value) {
        if (targetsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureTargetsIsMutable();
          targets_.add(value);
          onChanged();
        } else {
          targetsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of targets for the query.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.Target targets = 3;
       * </code>
       */
      public Builder addTargets(
          int index, com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.Target value) {
        if (targetsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureTargetsIsMutable();
          targets_.add(index, value);
          onChanged();
        } else {
          targetsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of targets for the query.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.Target targets = 3;
       * </code>
       */
      public Builder addTargets(
          com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.Target.Builder
              builderForValue) {
        if (targetsBuilder_ == null) {
          ensureTargetsIsMutable();
          targets_.add(builderForValue.build());
          onChanged();
        } else {
          targetsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of targets for the query.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.Target targets = 3;
       * </code>
       */
      public Builder addTargets(
          int index,
          com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.Target.Builder
              builderForValue) {
        if (targetsBuilder_ == null) {
          ensureTargetsIsMutable();
          targets_.add(index, builderForValue.build());
          onChanged();
        } else {
          targetsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of targets for the query.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.Target targets = 3;
       * </code>
       */
      public Builder addAllTargets(
          java.lang.Iterable<
                  ? extends com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.Target>
              values) {
        if (targetsBuilder_ == null) {
          ensureTargetsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, targets_);
          onChanged();
        } else {
          targetsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of targets for the query.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.Target targets = 3;
       * </code>
       */
      public Builder clearTargets() {
        if (targetsBuilder_ == null) {
          targets_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
        } else {
          targetsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of targets for the query.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.Target targets = 3;
       * </code>
       */
      public Builder removeTargets(int index) {
        if (targetsBuilder_ == null) {
          ensureTargetsIsMutable();
          targets_.remove(index);
          onChanged();
        } else {
          targetsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of targets for the query.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.Target targets = 3;
       * </code>
       */
      public com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.Target.Builder
          getTargetsBuilder(int index) {
        return getTargetsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * List of targets for the query.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.Target targets = 3;
       * </code>
       */
      public com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.TargetOrBuilder
          getTargetsOrBuilder(int index) {
        if (targetsBuilder_ == null) {
          return targets_.get(index);
        } else {
          return targetsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * List of targets for the query.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.Target targets = 3;
       * </code>
       */
      public java.util.List<
              ? extends
                  com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.TargetOrBuilder>
          getTargetsOrBuilderList() {
        if (targetsBuilder_ != null) {
          return targetsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(targets_);
        }
      }
      /**
       *
       *
       * <pre>
       * List of targets for the query.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.Target targets = 3;
       * </code>
       */
      public com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.Target.Builder
          addTargetsBuilder() {
        return getTargetsFieldBuilder()
            .addBuilder(
                com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.Target
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * List of targets for the query.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.Target targets = 3;
       * </code>
       */
      public com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.Target.Builder
          addTargetsBuilder(int index) {
        return getTargetsFieldBuilder()
            .addBuilder(
                index,
                com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.Target
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * List of targets for the query.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.Target targets = 3;
       * </code>
       */
      public java.util.List<
              com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.Target.Builder>
          getTargetsBuilderList() {
        return getTargetsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.Target,
              com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.Target.Builder,
              com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.TargetOrBuilder>
          getTargetsFieldBuilder() {
        if (targetsBuilder_ == null) {
          targetsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.Target,
                  com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.Target.Builder,
                  com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.TargetOrBuilder>(
                  targets_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
          targets_ = null;
        }
        return targetsBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry)
    private static final com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry();
    }

    public static com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<QueryEntry> PARSER =
        new com.google.protobuf.AbstractParser<QueryEntry>() {
          @java.lang.Override
          public QueryEntry parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<QueryEntry> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<QueryEntry> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  private int contentCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object content_;

  public enum ContentCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    QUERY_ENTRY(2),
    CONTENT_NOT_SET(0);
    private final int value;

    private ContentCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ContentCase valueOf(int value) {
      return forNumber(value);
    }

    public static ContentCase forNumber(int value) {
      switch (value) {
        case 2:
          return QUERY_ENTRY;
        case 0:
          return CONTENT_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public ContentCase getContentCase() {
    return ContentCase.forNumber(contentCase_);
  }

  public static final int QUERY_ENTRY_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * The query entry.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry query_entry = 2;</code>
   *
   * @return Whether the queryEntry field is set.
   */
  @java.lang.Override
  public boolean hasQueryEntry() {
    return contentCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * The query entry.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry query_entry = 2;</code>
   *
   * @return The queryEntry.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry getQueryEntry() {
    if (contentCase_ == 2) {
      return (com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry) content_;
    }
    return com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The query entry.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry query_entry = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntryOrBuilder
      getQueryEntryOrBuilder() {
    if (contentCase_ == 2) {
      return (com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry) content_;
    }
    return com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.getDefaultInstance();
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Identifier. The full resource name of the sample query, in the format of
   * `projects/{project}/locations/{location}/sampleQuerySets/{sample_query_set}/sampleQueries/{sample_query}`.
   *
   * This field must be a UTF-8 encoded string with a length limit of 1024
   * characters.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Identifier. The full resource name of the sample query, in the format of
   * `projects/{project}/locations/{location}/sampleQuerySets/{sample_query_set}/sampleQueries/{sample_query}`.
   *
   * This field must be a UTF-8 encoded string with a length limit of 1024
   * characters.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 3;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. Timestamp the
   * [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery] was created
   * at.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp the
   * [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery] was created
   * at.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp the
   * [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery] was created
   * at.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (contentCase_ == 2) {
      output.writeMessage(
          2, (com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry) content_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3, getCreateTime());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (contentCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry) content_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getCreateTime());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.discoveryengine.v1beta.SampleQuery)) {
      return super.equals(obj);
    }
    com.google.cloud.discoveryengine.v1beta.SampleQuery other =
        (com.google.cloud.discoveryengine.v1beta.SampleQuery) obj;

    if (!getName().equals(other.getName())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (!getContentCase().equals(other.getContentCase())) return false;
    switch (contentCase_) {
      case 2:
        if (!getQueryEntry().equals(other.getQueryEntry())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    switch (contentCase_) {
      case 2:
        hash = (37 * hash) + QUERY_ENTRY_FIELD_NUMBER;
        hash = (53 * hash) + getQueryEntry().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.discoveryengine.v1beta.SampleQuery parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1beta.SampleQuery parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.SampleQuery parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1beta.SampleQuery parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.SampleQuery parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1beta.SampleQuery parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.SampleQuery parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1beta.SampleQuery parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.SampleQuery parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1beta.SampleQuery parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.SampleQuery parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1beta.SampleQuery parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.discoveryengine.v1beta.SampleQuery prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Sample Query captures metadata to be used for evaluation.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1beta.SampleQuery}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.SampleQuery)
      com.google.cloud.discoveryengine.v1beta.SampleQueryOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1beta.SampleQueryProto
          .internal_static_google_cloud_discoveryengine_v1beta_SampleQuery_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1beta.SampleQueryProto
          .internal_static_google_cloud_discoveryengine_v1beta_SampleQuery_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1beta.SampleQuery.class,
              com.google.cloud.discoveryengine.v1beta.SampleQuery.Builder.class);
    }

    // Construct using com.google.cloud.discoveryengine.v1beta.SampleQuery.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getCreateTimeFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (queryEntryBuilder_ != null) {
        queryEntryBuilder_.clear();
      }
      name_ = "";
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      contentCase_ = 0;
      content_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.discoveryengine.v1beta.SampleQueryProto
          .internal_static_google_cloud_discoveryengine_v1beta_SampleQuery_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.SampleQuery getDefaultInstanceForType() {
      return com.google.cloud.discoveryengine.v1beta.SampleQuery.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.SampleQuery build() {
      com.google.cloud.discoveryengine.v1beta.SampleQuery result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.SampleQuery buildPartial() {
      com.google.cloud.discoveryengine.v1beta.SampleQuery result =
          new com.google.cloud.discoveryengine.v1beta.SampleQuery(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.discoveryengine.v1beta.SampleQuery result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.name_ = name_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.cloud.discoveryengine.v1beta.SampleQuery result) {
      result.contentCase_ = contentCase_;
      result.content_ = this.content_;
      if (contentCase_ == 2 && queryEntryBuilder_ != null) {
        result.content_ = queryEntryBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.discoveryengine.v1beta.SampleQuery) {
        return mergeFrom((com.google.cloud.discoveryengine.v1beta.SampleQuery) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.discoveryengine.v1beta.SampleQuery other) {
      if (other == com.google.cloud.discoveryengine.v1beta.SampleQuery.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      switch (other.getContentCase()) {
        case QUERY_ENTRY:
          {
            mergeQueryEntry(other.getQueryEntry());
            break;
          }
        case CONTENT_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getQueryEntryFieldBuilder().getBuilder(), extensionRegistry);
                contentCase_ = 2;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int contentCase_ = 0;
    private java.lang.Object content_;

    public ContentCase getContentCase() {
      return ContentCase.forNumber(contentCase_);
    }

    public Builder clearContent() {
      contentCase_ = 0;
      content_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry,
            com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.Builder,
            com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntryOrBuilder>
        queryEntryBuilder_;
    /**
     *
     *
     * <pre>
     * The query entry.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry query_entry = 2;</code>
     *
     * @return Whether the queryEntry field is set.
     */
    @java.lang.Override
    public boolean hasQueryEntry() {
      return contentCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * The query entry.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry query_entry = 2;</code>
     *
     * @return The queryEntry.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry getQueryEntry() {
      if (queryEntryBuilder_ == null) {
        if (contentCase_ == 2) {
          return (com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry) content_;
        }
        return com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.getDefaultInstance();
      } else {
        if (contentCase_ == 2) {
          return queryEntryBuilder_.getMessage();
        }
        return com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The query entry.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry query_entry = 2;</code>
     */
    public Builder setQueryEntry(
        com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry value) {
      if (queryEntryBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        content_ = value;
        onChanged();
      } else {
        queryEntryBuilder_.setMessage(value);
      }
      contentCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The query entry.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry query_entry = 2;</code>
     */
    public Builder setQueryEntry(
        com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.Builder builderForValue) {
      if (queryEntryBuilder_ == null) {
        content_ = builderForValue.build();
        onChanged();
      } else {
        queryEntryBuilder_.setMessage(builderForValue.build());
      }
      contentCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The query entry.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry query_entry = 2;</code>
     */
    public Builder mergeQueryEntry(
        com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry value) {
      if (queryEntryBuilder_ == null) {
        if (contentCase_ == 2
            && content_
                != com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry
                    .getDefaultInstance()) {
          content_ =
              com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.newBuilder(
                      (com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry) content_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          content_ = value;
        }
        onChanged();
      } else {
        if (contentCase_ == 2) {
          queryEntryBuilder_.mergeFrom(value);
        } else {
          queryEntryBuilder_.setMessage(value);
        }
      }
      contentCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The query entry.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry query_entry = 2;</code>
     */
    public Builder clearQueryEntry() {
      if (queryEntryBuilder_ == null) {
        if (contentCase_ == 2) {
          contentCase_ = 0;
          content_ = null;
          onChanged();
        }
      } else {
        if (contentCase_ == 2) {
          contentCase_ = 0;
          content_ = null;
        }
        queryEntryBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The query entry.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry query_entry = 2;</code>
     */
    public com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.Builder
        getQueryEntryBuilder() {
      return getQueryEntryFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The query entry.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry query_entry = 2;</code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntryOrBuilder
        getQueryEntryOrBuilder() {
      if ((contentCase_ == 2) && (queryEntryBuilder_ != null)) {
        return queryEntryBuilder_.getMessageOrBuilder();
      } else {
        if (contentCase_ == 2) {
          return (com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry) content_;
        }
        return com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The query entry.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry query_entry = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry,
            com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.Builder,
            com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntryOrBuilder>
        getQueryEntryFieldBuilder() {
      if (queryEntryBuilder_ == null) {
        if (!(contentCase_ == 2)) {
          content_ =
              com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.getDefaultInstance();
        }
        queryEntryBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry,
                com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry.Builder,
                com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntryOrBuilder>(
                (com.google.cloud.discoveryengine.v1beta.SampleQuery.QueryEntry) content_,
                getParentForChildren(),
                isClean());
        content_ = null;
      }
      contentCase_ = 2;
      onChanged();
      return queryEntryBuilder_;
    }

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Identifier. The full resource name of the sample query, in the format of
     * `projects/{project}/locations/{location}/sampleQuerySets/{sample_query_set}/sampleQueries/{sample_query}`.
     *
     * This field must be a UTF-8 encoded string with a length limit of 1024
     * characters.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Identifier. The full resource name of the sample query, in the format of
     * `projects/{project}/locations/{location}/sampleQuerySets/{sample_query_set}/sampleQueries/{sample_query}`.
     *
     * This field must be a UTF-8 encoded string with a length limit of 1024
     * characters.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Identifier. The full resource name of the sample query, in the format of
     * `projects/{project}/locations/{location}/sampleQuerySets/{sample_query_set}/sampleQueries/{sample_query}`.
     *
     * This field must be a UTF-8 encoded string with a length limit of 1024
     * characters.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Identifier. The full resource name of the sample query, in the format of
     * `projects/{project}/locations/{location}/sampleQuerySets/{sample_query_set}/sampleQueries/{sample_query}`.
     *
     * This field must be a UTF-8 encoded string with a length limit of 1024
     * characters.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Identifier. The full resource name of the sample query, in the format of
     * `projects/{project}/locations/{location}/sampleQuerySets/{sample_query_set}/sampleQueries/{sample_query}`.
     *
     * This field must be a UTF-8 encoded string with a length limit of 1024
     * characters.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Timestamp the
     * [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery] was created
     * at.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp the
     * [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery] was created
     * at.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp the
     * [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery] was created
     * at.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp the
     * [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery] was created
     * at.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp the
     * [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery] was created
     * at.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp the
     * [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery] was created
     * at.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000004);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp the
     * [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery] was created
     * at.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp the
     * [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery] was created
     * at.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp the
     * [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery] was created
     * at.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.SampleQuery)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.SampleQuery)
  private static final com.google.cloud.discoveryengine.v1beta.SampleQuery DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.discoveryengine.v1beta.SampleQuery();
  }

  public static com.google.cloud.discoveryengine.v1beta.SampleQuery getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<SampleQuery> PARSER =
      new com.google.protobuf.AbstractParser<SampleQuery>() {
        @java.lang.Override
        public SampleQuery parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<SampleQuery> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SampleQuery> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.SampleQuery getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
