/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/discoveryengine/v1beta/search_service.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.discoveryengine.v1beta;

public interface SearchRequestOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1beta.SearchRequest)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Required. The resource name of the Search serving config, such as
   * `projects/&#42;&#47;locations/global/collections/default_collection/engines/&#42;&#47;servingConfigs/default_serving_config`,
   * or
   * `projects/&#42;&#47;locations/global/collections/default_collection/dataStores/default_data_store/servingConfigs/default_serving_config`.
   * This field is used to identify the serving configuration name, set
   * of models used to make the search.
   * </pre>
   *
   * <code>
   * string serving_config = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The servingConfig.
   */
  java.lang.String getServingConfig();
  /**
   *
   *
   * <pre>
   * Required. The resource name of the Search serving config, such as
   * `projects/&#42;&#47;locations/global/collections/default_collection/engines/&#42;&#47;servingConfigs/default_serving_config`,
   * or
   * `projects/&#42;&#47;locations/global/collections/default_collection/dataStores/default_data_store/servingConfigs/default_serving_config`.
   * This field is used to identify the serving configuration name, set
   * of models used to make the search.
   * </pre>
   *
   * <code>
   * string serving_config = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for servingConfig.
   */
  com.google.protobuf.ByteString getServingConfigBytes();

  /**
   *
   *
   * <pre>
   * The branch resource name, such as
   * `projects/&#42;&#47;locations/global/collections/default_collection/dataStores/default_data_store/branches/0`.
   *
   * Use `default_branch` as the branch ID or leave this field empty, to search
   * documents under the default branch.
   * </pre>
   *
   * <code>string branch = 2 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The branch.
   */
  java.lang.String getBranch();
  /**
   *
   *
   * <pre>
   * The branch resource name, such as
   * `projects/&#42;&#47;locations/global/collections/default_collection/dataStores/default_data_store/branches/0`.
   *
   * Use `default_branch` as the branch ID or leave this field empty, to search
   * documents under the default branch.
   * </pre>
   *
   * <code>string branch = 2 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for branch.
   */
  com.google.protobuf.ByteString getBranchBytes();

  /**
   *
   *
   * <pre>
   * Raw search query.
   * </pre>
   *
   * <code>string query = 3;</code>
   *
   * @return The query.
   */
  java.lang.String getQuery();
  /**
   *
   *
   * <pre>
   * Raw search query.
   * </pre>
   *
   * <code>string query = 3;</code>
   *
   * @return The bytes for query.
   */
  com.google.protobuf.ByteString getQueryBytes();

  /**
   *
   *
   * <pre>
   * Raw image query.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.SearchRequest.ImageQuery image_query = 19;</code>
   *
   * @return Whether the imageQuery field is set.
   */
  boolean hasImageQuery();
  /**
   *
   *
   * <pre>
   * Raw image query.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.SearchRequest.ImageQuery image_query = 19;</code>
   *
   * @return The imageQuery.
   */
  com.google.cloud.discoveryengine.v1beta.SearchRequest.ImageQuery getImageQuery();
  /**
   *
   *
   * <pre>
   * Raw image query.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.SearchRequest.ImageQuery image_query = 19;</code>
   */
  com.google.cloud.discoveryengine.v1beta.SearchRequest.ImageQueryOrBuilder
      getImageQueryOrBuilder();

  /**
   *
   *
   * <pre>
   * Maximum number of [Document][google.cloud.discoveryengine.v1beta.Document]s
   * to return. The maximum allowed value depends on the data type. Values above
   * the maximum value are coerced to the maximum value.
   *
   * * Websites with basic indexing: Default `10`, Maximum `25`.
   * * Websites with advanced indexing: Default `25`, Maximum `50`.
   * * Other: Default `50`, Maximum `100`.
   *
   * If this field is negative, an  `INVALID_ARGUMENT` is returned.
   * </pre>
   *
   * <code>int32 page_size = 4;</code>
   *
   * @return The pageSize.
   */
  int getPageSize();

  /**
   *
   *
   * <pre>
   * A page token received from a previous
   * [SearchService.Search][google.cloud.discoveryengine.v1beta.SearchService.Search]
   * call. Provide this to retrieve the subsequent page.
   *
   * When paginating, all other parameters provided to
   * [SearchService.Search][google.cloud.discoveryengine.v1beta.SearchService.Search]
   * must match the call that provided the page token. Otherwise, an
   *  `INVALID_ARGUMENT`  error is returned.
   * </pre>
   *
   * <code>string page_token = 5;</code>
   *
   * @return The pageToken.
   */
  java.lang.String getPageToken();
  /**
   *
   *
   * <pre>
   * A page token received from a previous
   * [SearchService.Search][google.cloud.discoveryengine.v1beta.SearchService.Search]
   * call. Provide this to retrieve the subsequent page.
   *
   * When paginating, all other parameters provided to
   * [SearchService.Search][google.cloud.discoveryengine.v1beta.SearchService.Search]
   * must match the call that provided the page token. Otherwise, an
   *  `INVALID_ARGUMENT`  error is returned.
   * </pre>
   *
   * <code>string page_token = 5;</code>
   *
   * @return The bytes for pageToken.
   */
  com.google.protobuf.ByteString getPageTokenBytes();

  /**
   *
   *
   * <pre>
   * A 0-indexed integer that specifies the current offset (that is, starting
   * result location, amongst the
   * [Document][google.cloud.discoveryengine.v1beta.Document]s deemed by the API
   * as relevant) in search results. This field is only considered if
   * [page_token][google.cloud.discoveryengine.v1beta.SearchRequest.page_token]
   * is unset.
   *
   * If this field is negative, an  `INVALID_ARGUMENT`  is returned.
   * </pre>
   *
   * <code>int32 offset = 6;</code>
   *
   * @return The offset.
   */
  int getOffset();

  /**
   *
   *
   * <pre>
   * Specs defining dataStores to filter on in a search call and configurations
   * for those dataStores. This is only considered for engines with multiple
   * dataStores use case. For single dataStore within an engine, they should
   * use the specs at the top level.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpec data_store_specs = 32;
   * </code>
   */
  java.util.List<com.google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpec>
      getDataStoreSpecsList();
  /**
   *
   *
   * <pre>
   * Specs defining dataStores to filter on in a search call and configurations
   * for those dataStores. This is only considered for engines with multiple
   * dataStores use case. For single dataStore within an engine, they should
   * use the specs at the top level.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpec data_store_specs = 32;
   * </code>
   */
  com.google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpec getDataStoreSpecs(int index);
  /**
   *
   *
   * <pre>
   * Specs defining dataStores to filter on in a search call and configurations
   * for those dataStores. This is only considered for engines with multiple
   * dataStores use case. For single dataStore within an engine, they should
   * use the specs at the top level.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpec data_store_specs = 32;
   * </code>
   */
  int getDataStoreSpecsCount();
  /**
   *
   *
   * <pre>
   * Specs defining dataStores to filter on in a search call and configurations
   * for those dataStores. This is only considered for engines with multiple
   * dataStores use case. For single dataStore within an engine, they should
   * use the specs at the top level.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpec data_store_specs = 32;
   * </code>
   */
  java.util.List<
          ? extends com.google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpecOrBuilder>
      getDataStoreSpecsOrBuilderList();
  /**
   *
   *
   * <pre>
   * Specs defining dataStores to filter on in a search call and configurations
   * for those dataStores. This is only considered for engines with multiple
   * dataStores use case. For single dataStore within an engine, they should
   * use the specs at the top level.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpec data_store_specs = 32;
   * </code>
   */
  com.google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpecOrBuilder
      getDataStoreSpecsOrBuilder(int index);

  /**
   *
   *
   * <pre>
   * The filter syntax consists of an expression language for constructing a
   * predicate from one or more fields of the documents being filtered. Filter
   * expression is case-sensitive.
   *
   * If this field is unrecognizable, an  `INVALID_ARGUMENT`  is returned.
   *
   * Filtering in Vertex AI Search is done by mapping the LHS filter key to a
   * key property defined in the Vertex AI Search backend -- this mapping is
   * defined by the customer in their schema. For example a media customer might
   * have a field 'name' in their schema. In this case the filter would look
   * like this: filter --&gt; name:'ANY("king kong")'
   *
   * For more information about filtering including syntax and filter
   * operators, see
   * [Filter](https://cloud.google.com/generative-ai-app-builder/docs/filter-search-metadata)
   * </pre>
   *
   * <code>string filter = 7;</code>
   *
   * @return The filter.
   */
  java.lang.String getFilter();
  /**
   *
   *
   * <pre>
   * The filter syntax consists of an expression language for constructing a
   * predicate from one or more fields of the documents being filtered. Filter
   * expression is case-sensitive.
   *
   * If this field is unrecognizable, an  `INVALID_ARGUMENT`  is returned.
   *
   * Filtering in Vertex AI Search is done by mapping the LHS filter key to a
   * key property defined in the Vertex AI Search backend -- this mapping is
   * defined by the customer in their schema. For example a media customer might
   * have a field 'name' in their schema. In this case the filter would look
   * like this: filter --&gt; name:'ANY("king kong")'
   *
   * For more information about filtering including syntax and filter
   * operators, see
   * [Filter](https://cloud.google.com/generative-ai-app-builder/docs/filter-search-metadata)
   * </pre>
   *
   * <code>string filter = 7;</code>
   *
   * @return The bytes for filter.
   */
  com.google.protobuf.ByteString getFilterBytes();

  /**
   *
   *
   * <pre>
   * The default filter that is applied when a user performs a search without
   * checking any filters on the search page.
   *
   * The filter applied to every search request when quality improvement such as
   * query expansion is needed. In the case a query does not have a sufficient
   * amount of results this filter will be used to determine whether or not to
   * enable the query expansion flow. The original filter will still be used for
   * the query expanded search.
   * This field is strongly recommended to achieve high search quality.
   *
   * For more information about filter syntax, see
   * [SearchRequest.filter][google.cloud.discoveryengine.v1beta.SearchRequest.filter].
   * </pre>
   *
   * <code>string canonical_filter = 29;</code>
   *
   * @return The canonicalFilter.
   */
  java.lang.String getCanonicalFilter();
  /**
   *
   *
   * <pre>
   * The default filter that is applied when a user performs a search without
   * checking any filters on the search page.
   *
   * The filter applied to every search request when quality improvement such as
   * query expansion is needed. In the case a query does not have a sufficient
   * amount of results this filter will be used to determine whether or not to
   * enable the query expansion flow. The original filter will still be used for
   * the query expanded search.
   * This field is strongly recommended to achieve high search quality.
   *
   * For more information about filter syntax, see
   * [SearchRequest.filter][google.cloud.discoveryengine.v1beta.SearchRequest.filter].
   * </pre>
   *
   * <code>string canonical_filter = 29;</code>
   *
   * @return The bytes for canonicalFilter.
   */
  com.google.protobuf.ByteString getCanonicalFilterBytes();

  /**
   *
   *
   * <pre>
   * The order in which documents are returned. Documents can be ordered by
   * a field in an [Document][google.cloud.discoveryengine.v1beta.Document]
   * object. Leave it unset if ordered by relevance. `order_by` expression is
   * case-sensitive.
   *
   * For more information on ordering the website search results, see
   * [Order web search
   * results](https://cloud.google.com/generative-ai-app-builder/docs/order-web-search-results).
   * For more information on ordering the healthcare search results, see
   * [Order healthcare search
   * results](https://cloud.google.com/generative-ai-app-builder/docs/order-hc-results).
   * If this field is unrecognizable, an `INVALID_ARGUMENT` is returned.
   * </pre>
   *
   * <code>string order_by = 8;</code>
   *
   * @return The orderBy.
   */
  java.lang.String getOrderBy();
  /**
   *
   *
   * <pre>
   * The order in which documents are returned. Documents can be ordered by
   * a field in an [Document][google.cloud.discoveryengine.v1beta.Document]
   * object. Leave it unset if ordered by relevance. `order_by` expression is
   * case-sensitive.
   *
   * For more information on ordering the website search results, see
   * [Order web search
   * results](https://cloud.google.com/generative-ai-app-builder/docs/order-web-search-results).
   * For more information on ordering the healthcare search results, see
   * [Order healthcare search
   * results](https://cloud.google.com/generative-ai-app-builder/docs/order-hc-results).
   * If this field is unrecognizable, an `INVALID_ARGUMENT` is returned.
   * </pre>
   *
   * <code>string order_by = 8;</code>
   *
   * @return The bytes for orderBy.
   */
  com.google.protobuf.ByteString getOrderByBytes();

  /**
   *
   *
   * <pre>
   * Information about the end user.
   * Highly recommended for analytics.
   * [UserInfo.user_agent][google.cloud.discoveryengine.v1beta.UserInfo.user_agent]
   * is used to deduce `device_type` for analytics.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.UserInfo user_info = 21;</code>
   *
   * @return Whether the userInfo field is set.
   */
  boolean hasUserInfo();
  /**
   *
   *
   * <pre>
   * Information about the end user.
   * Highly recommended for analytics.
   * [UserInfo.user_agent][google.cloud.discoveryengine.v1beta.UserInfo.user_agent]
   * is used to deduce `device_type` for analytics.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.UserInfo user_info = 21;</code>
   *
   * @return The userInfo.
   */
  com.google.cloud.discoveryengine.v1beta.UserInfo getUserInfo();
  /**
   *
   *
   * <pre>
   * Information about the end user.
   * Highly recommended for analytics.
   * [UserInfo.user_agent][google.cloud.discoveryengine.v1beta.UserInfo.user_agent]
   * is used to deduce `device_type` for analytics.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.UserInfo user_info = 21;</code>
   */
  com.google.cloud.discoveryengine.v1beta.UserInfoOrBuilder getUserInfoOrBuilder();

  /**
   *
   *
   * <pre>
   * The BCP-47 language code, such as "en-US" or "sr-Latn". For more
   * information, see [Standard
   * fields](https://cloud.google.com/apis/design/standard_fields). This field
   * helps to better interpret the query. If a value isn't specified, the query
   * language code is automatically detected, which may not be accurate.
   * </pre>
   *
   * <code>string language_code = 35;</code>
   *
   * @return The languageCode.
   */
  java.lang.String getLanguageCode();
  /**
   *
   *
   * <pre>
   * The BCP-47 language code, such as "en-US" or "sr-Latn". For more
   * information, see [Standard
   * fields](https://cloud.google.com/apis/design/standard_fields). This field
   * helps to better interpret the query. If a value isn't specified, the query
   * language code is automatically detected, which may not be accurate.
   * </pre>
   *
   * <code>string language_code = 35;</code>
   *
   * @return The bytes for languageCode.
   */
  com.google.protobuf.ByteString getLanguageCodeBytes();

  /**
   *
   *
   * <pre>
   * The Unicode country/region code (CLDR) of a location, such as "US" and
   * "419". For more information, see [Standard
   * fields](https://cloud.google.com/apis/design/standard_fields). If set,
   * then results will be boosted based on the region_code provided.
   * </pre>
   *
   * <code>string region_code = 36;</code>
   *
   * @return The regionCode.
   */
  java.lang.String getRegionCode();
  /**
   *
   *
   * <pre>
   * The Unicode country/region code (CLDR) of a location, such as "US" and
   * "419". For more information, see [Standard
   * fields](https://cloud.google.com/apis/design/standard_fields). If set,
   * then results will be boosted based on the region_code provided.
   * </pre>
   *
   * <code>string region_code = 36;</code>
   *
   * @return The bytes for regionCode.
   */
  com.google.protobuf.ByteString getRegionCodeBytes();

  /**
   *
   *
   * <pre>
   * Facet specifications for faceted search. If empty, no facets are returned.
   *
   * A maximum of 100 values are allowed. Otherwise, an  `INVALID_ARGUMENT`
   * error is returned.
   * </pre>
   *
   * <code>repeated .google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec facet_specs = 9;
   * </code>
   */
  java.util.List<com.google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec>
      getFacetSpecsList();
  /**
   *
   *
   * <pre>
   * Facet specifications for faceted search. If empty, no facets are returned.
   *
   * A maximum of 100 values are allowed. Otherwise, an  `INVALID_ARGUMENT`
   * error is returned.
   * </pre>
   *
   * <code>repeated .google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec facet_specs = 9;
   * </code>
   */
  com.google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec getFacetSpecs(int index);
  /**
   *
   *
   * <pre>
   * Facet specifications for faceted search. If empty, no facets are returned.
   *
   * A maximum of 100 values are allowed. Otherwise, an  `INVALID_ARGUMENT`
   * error is returned.
   * </pre>
   *
   * <code>repeated .google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec facet_specs = 9;
   * </code>
   */
  int getFacetSpecsCount();
  /**
   *
   *
   * <pre>
   * Facet specifications for faceted search. If empty, no facets are returned.
   *
   * A maximum of 100 values are allowed. Otherwise, an  `INVALID_ARGUMENT`
   * error is returned.
   * </pre>
   *
   * <code>repeated .google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec facet_specs = 9;
   * </code>
   */
  java.util.List<? extends com.google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpecOrBuilder>
      getFacetSpecsOrBuilderList();
  /**
   *
   *
   * <pre>
   * Facet specifications for faceted search. If empty, no facets are returned.
   *
   * A maximum of 100 values are allowed. Otherwise, an  `INVALID_ARGUMENT`
   * error is returned.
   * </pre>
   *
   * <code>repeated .google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec facet_specs = 9;
   * </code>
   */
  com.google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpecOrBuilder getFacetSpecsOrBuilder(
      int index);

  /**
   *
   *
   * <pre>
   * Boost specification to boost certain documents.
   * For more information on boosting, see
   * [Boosting](https://cloud.google.com/generative-ai-app-builder/docs/boost-search-results)
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec boost_spec = 10;</code>
   *
   * @return Whether the boostSpec field is set.
   */
  boolean hasBoostSpec();
  /**
   *
   *
   * <pre>
   * Boost specification to boost certain documents.
   * For more information on boosting, see
   * [Boosting](https://cloud.google.com/generative-ai-app-builder/docs/boost-search-results)
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec boost_spec = 10;</code>
   *
   * @return The boostSpec.
   */
  com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec getBoostSpec();
  /**
   *
   *
   * <pre>
   * Boost specification to boost certain documents.
   * For more information on boosting, see
   * [Boosting](https://cloud.google.com/generative-ai-app-builder/docs/boost-search-results)
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec boost_spec = 10;</code>
   */
  com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpecOrBuilder getBoostSpecOrBuilder();

  /**
   *
   *
   * <pre>
   * Additional search parameters.
   *
   * For public website search only, supported values are:
   *
   * * `user_country_code`: string. Default empty. If set to non-empty, results
   *    are restricted or boosted based on the location provided.
   *    For example, `user_country_code: "au"`
   *
   *    For available codes see [Country
   *    Codes](https://developers.google.com/custom-search/docs/json_api_reference#countryCodes)
   *
   * * `search_type`: double. Default empty. Enables non-webpage searching
   *    depending on the value. The only valid non-default value is 1,
   *    which enables image searching.
   *    For example, `search_type: 1`
   * </pre>
   *
   * <code>map&lt;string, .google.protobuf.Value&gt; params = 11;</code>
   */
  int getParamsCount();
  /**
   *
   *
   * <pre>
   * Additional search parameters.
   *
   * For public website search only, supported values are:
   *
   * * `user_country_code`: string. Default empty. If set to non-empty, results
   *    are restricted or boosted based on the location provided.
   *    For example, `user_country_code: "au"`
   *
   *    For available codes see [Country
   *    Codes](https://developers.google.com/custom-search/docs/json_api_reference#countryCodes)
   *
   * * `search_type`: double. Default empty. Enables non-webpage searching
   *    depending on the value. The only valid non-default value is 1,
   *    which enables image searching.
   *    For example, `search_type: 1`
   * </pre>
   *
   * <code>map&lt;string, .google.protobuf.Value&gt; params = 11;</code>
   */
  boolean containsParams(java.lang.String key);
  /** Use {@link #getParamsMap()} instead. */
  @java.lang.Deprecated
  java.util.Map<java.lang.String, com.google.protobuf.Value> getParams();
  /**
   *
   *
   * <pre>
   * Additional search parameters.
   *
   * For public website search only, supported values are:
   *
   * * `user_country_code`: string. Default empty. If set to non-empty, results
   *    are restricted or boosted based on the location provided.
   *    For example, `user_country_code: "au"`
   *
   *    For available codes see [Country
   *    Codes](https://developers.google.com/custom-search/docs/json_api_reference#countryCodes)
   *
   * * `search_type`: double. Default empty. Enables non-webpage searching
   *    depending on the value. The only valid non-default value is 1,
   *    which enables image searching.
   *    For example, `search_type: 1`
   * </pre>
   *
   * <code>map&lt;string, .google.protobuf.Value&gt; params = 11;</code>
   */
  java.util.Map<java.lang.String, com.google.protobuf.Value> getParamsMap();
  /**
   *
   *
   * <pre>
   * Additional search parameters.
   *
   * For public website search only, supported values are:
   *
   * * `user_country_code`: string. Default empty. If set to non-empty, results
   *    are restricted or boosted based on the location provided.
   *    For example, `user_country_code: "au"`
   *
   *    For available codes see [Country
   *    Codes](https://developers.google.com/custom-search/docs/json_api_reference#countryCodes)
   *
   * * `search_type`: double. Default empty. Enables non-webpage searching
   *    depending on the value. The only valid non-default value is 1,
   *    which enables image searching.
   *    For example, `search_type: 1`
   * </pre>
   *
   * <code>map&lt;string, .google.protobuf.Value&gt; params = 11;</code>
   */
  /* nullable */
  com.google.protobuf.Value getParamsOrDefault(
      java.lang.String key,
      /* nullable */
      com.google.protobuf.Value defaultValue);
  /**
   *
   *
   * <pre>
   * Additional search parameters.
   *
   * For public website search only, supported values are:
   *
   * * `user_country_code`: string. Default empty. If set to non-empty, results
   *    are restricted or boosted based on the location provided.
   *    For example, `user_country_code: "au"`
   *
   *    For available codes see [Country
   *    Codes](https://developers.google.com/custom-search/docs/json_api_reference#countryCodes)
   *
   * * `search_type`: double. Default empty. Enables non-webpage searching
   *    depending on the value. The only valid non-default value is 1,
   *    which enables image searching.
   *    For example, `search_type: 1`
   * </pre>
   *
   * <code>map&lt;string, .google.protobuf.Value&gt; params = 11;</code>
   */
  com.google.protobuf.Value getParamsOrThrow(java.lang.String key);

  /**
   *
   *
   * <pre>
   * The query expansion specification that specifies the conditions under which
   * query expansion occurs.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1beta.SearchRequest.QueryExpansionSpec query_expansion_spec = 13;
   * </code>
   *
   * @return Whether the queryExpansionSpec field is set.
   */
  boolean hasQueryExpansionSpec();
  /**
   *
   *
   * <pre>
   * The query expansion specification that specifies the conditions under which
   * query expansion occurs.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1beta.SearchRequest.QueryExpansionSpec query_expansion_spec = 13;
   * </code>
   *
   * @return The queryExpansionSpec.
   */
  com.google.cloud.discoveryengine.v1beta.SearchRequest.QueryExpansionSpec getQueryExpansionSpec();
  /**
   *
   *
   * <pre>
   * The query expansion specification that specifies the conditions under which
   * query expansion occurs.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1beta.SearchRequest.QueryExpansionSpec query_expansion_spec = 13;
   * </code>
   */
  com.google.cloud.discoveryengine.v1beta.SearchRequest.QueryExpansionSpecOrBuilder
      getQueryExpansionSpecOrBuilder();

  /**
   *
   *
   * <pre>
   * The spell correction specification that specifies the mode under
   * which spell correction takes effect.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1beta.SearchRequest.SpellCorrectionSpec spell_correction_spec = 14;
   * </code>
   *
   * @return Whether the spellCorrectionSpec field is set.
   */
  boolean hasSpellCorrectionSpec();
  /**
   *
   *
   * <pre>
   * The spell correction specification that specifies the mode under
   * which spell correction takes effect.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1beta.SearchRequest.SpellCorrectionSpec spell_correction_spec = 14;
   * </code>
   *
   * @return The spellCorrectionSpec.
   */
  com.google.cloud.discoveryengine.v1beta.SearchRequest.SpellCorrectionSpec
      getSpellCorrectionSpec();
  /**
   *
   *
   * <pre>
   * The spell correction specification that specifies the mode under
   * which spell correction takes effect.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1beta.SearchRequest.SpellCorrectionSpec spell_correction_spec = 14;
   * </code>
   */
  com.google.cloud.discoveryengine.v1beta.SearchRequest.SpellCorrectionSpecOrBuilder
      getSpellCorrectionSpecOrBuilder();

  /**
   *
   *
   * <pre>
   * A unique identifier for tracking visitors. For example, this could be
   * implemented with an HTTP cookie, which should be able to uniquely identify
   * a visitor on a single device. This unique identifier should not change if
   * the visitor logs in or out of the website.
   *
   * This field should NOT have a fixed value such as `unknown_visitor`.
   *
   * This should be the same identifier as
   * [UserEvent.user_pseudo_id][google.cloud.discoveryengine.v1beta.UserEvent.user_pseudo_id]
   * and
   * [CompleteQueryRequest.user_pseudo_id][google.cloud.discoveryengine.v1beta.CompleteQueryRequest.user_pseudo_id]
   *
   * The field must be a UTF-8 encoded string with a length limit of 128
   * characters. Otherwise, an  `INVALID_ARGUMENT`  error is returned.
   * </pre>
   *
   * <code>string user_pseudo_id = 15;</code>
   *
   * @return The userPseudoId.
   */
  java.lang.String getUserPseudoId();
  /**
   *
   *
   * <pre>
   * A unique identifier for tracking visitors. For example, this could be
   * implemented with an HTTP cookie, which should be able to uniquely identify
   * a visitor on a single device. This unique identifier should not change if
   * the visitor logs in or out of the website.
   *
   * This field should NOT have a fixed value such as `unknown_visitor`.
   *
   * This should be the same identifier as
   * [UserEvent.user_pseudo_id][google.cloud.discoveryengine.v1beta.UserEvent.user_pseudo_id]
   * and
   * [CompleteQueryRequest.user_pseudo_id][google.cloud.discoveryengine.v1beta.CompleteQueryRequest.user_pseudo_id]
   *
   * The field must be a UTF-8 encoded string with a length limit of 128
   * characters. Otherwise, an  `INVALID_ARGUMENT`  error is returned.
   * </pre>
   *
   * <code>string user_pseudo_id = 15;</code>
   *
   * @return The bytes for userPseudoId.
   */
  com.google.protobuf.ByteString getUserPseudoIdBytes();

  /**
   *
   *
   * <pre>
   * A specification for configuring the behavior of content search.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec content_search_spec = 24;
   * </code>
   *
   * @return Whether the contentSearchSpec field is set.
   */
  boolean hasContentSearchSpec();
  /**
   *
   *
   * <pre>
   * A specification for configuring the behavior of content search.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec content_search_spec = 24;
   * </code>
   *
   * @return The contentSearchSpec.
   */
  com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec getContentSearchSpec();
  /**
   *
   *
   * <pre>
   * A specification for configuring the behavior of content search.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec content_search_spec = 24;
   * </code>
   */
  com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpecOrBuilder
      getContentSearchSpecOrBuilder();

  /**
   *
   *
   * <pre>
   * Uses the provided embedding to do additional semantic document retrieval.
   * The retrieval is based on the dot product of
   * [SearchRequest.EmbeddingSpec.EmbeddingVector.vector][google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.EmbeddingVector.vector]
   * and the document embedding that is provided in
   * [SearchRequest.EmbeddingSpec.EmbeddingVector.field_path][google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.EmbeddingVector.field_path].
   *
   * If
   * [SearchRequest.EmbeddingSpec.EmbeddingVector.field_path][google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.EmbeddingVector.field_path]
   * is not provided, it will use
   * [ServingConfig.EmbeddingConfig.field_path][google.cloud.discoveryengine.v1beta.ServingConfig.embedding_config].
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec embedding_spec = 23;
   * </code>
   *
   * @return Whether the embeddingSpec field is set.
   */
  boolean hasEmbeddingSpec();
  /**
   *
   *
   * <pre>
   * Uses the provided embedding to do additional semantic document retrieval.
   * The retrieval is based on the dot product of
   * [SearchRequest.EmbeddingSpec.EmbeddingVector.vector][google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.EmbeddingVector.vector]
   * and the document embedding that is provided in
   * [SearchRequest.EmbeddingSpec.EmbeddingVector.field_path][google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.EmbeddingVector.field_path].
   *
   * If
   * [SearchRequest.EmbeddingSpec.EmbeddingVector.field_path][google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.EmbeddingVector.field_path]
   * is not provided, it will use
   * [ServingConfig.EmbeddingConfig.field_path][google.cloud.discoveryengine.v1beta.ServingConfig.embedding_config].
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec embedding_spec = 23;
   * </code>
   *
   * @return The embeddingSpec.
   */
  com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec getEmbeddingSpec();
  /**
   *
   *
   * <pre>
   * Uses the provided embedding to do additional semantic document retrieval.
   * The retrieval is based on the dot product of
   * [SearchRequest.EmbeddingSpec.EmbeddingVector.vector][google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.EmbeddingVector.vector]
   * and the document embedding that is provided in
   * [SearchRequest.EmbeddingSpec.EmbeddingVector.field_path][google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.EmbeddingVector.field_path].
   *
   * If
   * [SearchRequest.EmbeddingSpec.EmbeddingVector.field_path][google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec.EmbeddingVector.field_path]
   * is not provided, it will use
   * [ServingConfig.EmbeddingConfig.field_path][google.cloud.discoveryengine.v1beta.ServingConfig.embedding_config].
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpec embedding_spec = 23;
   * </code>
   */
  com.google.cloud.discoveryengine.v1beta.SearchRequest.EmbeddingSpecOrBuilder
      getEmbeddingSpecOrBuilder();

  /**
   *
   *
   * <pre>
   * The ranking expression controls the customized ranking on retrieval
   * documents. This overrides
   * [ServingConfig.ranking_expression][google.cloud.discoveryengine.v1beta.ServingConfig.ranking_expression].
   * The ranking expression is a single function or multiple functions that are
   * joined by "+".
   *
   *   * ranking_expression = function, { " + ", function };
   *
   * Supported functions:
   *
   *   * double * relevance_score
   *   * double * dotProduct(embedding_field_path)
   *
   * Function variables:
   *
   *   * `relevance_score`: pre-defined keywords, used for measure relevance
   *   between query and document.
   *   * `embedding_field_path`: the document embedding field
   *   used with query embedding vector.
   *   * `dotProduct`: embedding function between embedding_field_path and query
   *   embedding vector.
   *
   *  Example ranking expression:
   *
   *    If document has an embedding field doc_embedding, the ranking expression
   *    could be `0.5 * relevance_score + 0.3 * dotProduct(doc_embedding)`.
   * </pre>
   *
   * <code>string ranking_expression = 26;</code>
   *
   * @return The rankingExpression.
   */
  java.lang.String getRankingExpression();
  /**
   *
   *
   * <pre>
   * The ranking expression controls the customized ranking on retrieval
   * documents. This overrides
   * [ServingConfig.ranking_expression][google.cloud.discoveryengine.v1beta.ServingConfig.ranking_expression].
   * The ranking expression is a single function or multiple functions that are
   * joined by "+".
   *
   *   * ranking_expression = function, { " + ", function };
   *
   * Supported functions:
   *
   *   * double * relevance_score
   *   * double * dotProduct(embedding_field_path)
   *
   * Function variables:
   *
   *   * `relevance_score`: pre-defined keywords, used for measure relevance
   *   between query and document.
   *   * `embedding_field_path`: the document embedding field
   *   used with query embedding vector.
   *   * `dotProduct`: embedding function between embedding_field_path and query
   *   embedding vector.
   *
   *  Example ranking expression:
   *
   *    If document has an embedding field doc_embedding, the ranking expression
   *    could be `0.5 * relevance_score + 0.3 * dotProduct(doc_embedding)`.
   * </pre>
   *
   * <code>string ranking_expression = 26;</code>
   *
   * @return The bytes for rankingExpression.
   */
  com.google.protobuf.ByteString getRankingExpressionBytes();

  /**
   *
   *
   * <pre>
   * Whether to turn on safe search. This is only supported for
   * website search.
   * </pre>
   *
   * <code>bool safe_search = 20;</code>
   *
   * @return The safeSearch.
   */
  boolean getSafeSearch();

  /**
   *
   *
   * <pre>
   * The user labels applied to a resource must meet the following requirements:
   *
   * * Each resource can have multiple labels, up to a maximum of 64.
   * * Each label must be a key-value pair.
   * * Keys have a minimum length of 1 character and a maximum length of 63
   *   characters and cannot be empty. Values can be empty and have a maximum
   *   length of 63 characters.
   * * Keys and values can contain only lowercase letters, numeric characters,
   *   underscores, and dashes. All characters must use UTF-8 encoding, and
   *   international characters are allowed.
   * * The key portion of a label must be unique. However, you can use the same
   *   key with multiple resources.
   * * Keys must start with a lowercase letter or international character.
   *
   * See [Google Cloud
   * Document](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
   * for more details.
   * </pre>
   *
   * <code>map&lt;string, string&gt; user_labels = 22;</code>
   */
  int getUserLabelsCount();
  /**
   *
   *
   * <pre>
   * The user labels applied to a resource must meet the following requirements:
   *
   * * Each resource can have multiple labels, up to a maximum of 64.
   * * Each label must be a key-value pair.
   * * Keys have a minimum length of 1 character and a maximum length of 63
   *   characters and cannot be empty. Values can be empty and have a maximum
   *   length of 63 characters.
   * * Keys and values can contain only lowercase letters, numeric characters,
   *   underscores, and dashes. All characters must use UTF-8 encoding, and
   *   international characters are allowed.
   * * The key portion of a label must be unique. However, you can use the same
   *   key with multiple resources.
   * * Keys must start with a lowercase letter or international character.
   *
   * See [Google Cloud
   * Document](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
   * for more details.
   * </pre>
   *
   * <code>map&lt;string, string&gt; user_labels = 22;</code>
   */
  boolean containsUserLabels(java.lang.String key);
  /** Use {@link #getUserLabelsMap()} instead. */
  @java.lang.Deprecated
  java.util.Map<java.lang.String, java.lang.String> getUserLabels();
  /**
   *
   *
   * <pre>
   * The user labels applied to a resource must meet the following requirements:
   *
   * * Each resource can have multiple labels, up to a maximum of 64.
   * * Each label must be a key-value pair.
   * * Keys have a minimum length of 1 character and a maximum length of 63
   *   characters and cannot be empty. Values can be empty and have a maximum
   *   length of 63 characters.
   * * Keys and values can contain only lowercase letters, numeric characters,
   *   underscores, and dashes. All characters must use UTF-8 encoding, and
   *   international characters are allowed.
   * * The key portion of a label must be unique. However, you can use the same
   *   key with multiple resources.
   * * Keys must start with a lowercase letter or international character.
   *
   * See [Google Cloud
   * Document](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
   * for more details.
   * </pre>
   *
   * <code>map&lt;string, string&gt; user_labels = 22;</code>
   */
  java.util.Map<java.lang.String, java.lang.String> getUserLabelsMap();
  /**
   *
   *
   * <pre>
   * The user labels applied to a resource must meet the following requirements:
   *
   * * Each resource can have multiple labels, up to a maximum of 64.
   * * Each label must be a key-value pair.
   * * Keys have a minimum length of 1 character and a maximum length of 63
   *   characters and cannot be empty. Values can be empty and have a maximum
   *   length of 63 characters.
   * * Keys and values can contain only lowercase letters, numeric characters,
   *   underscores, and dashes. All characters must use UTF-8 encoding, and
   *   international characters are allowed.
   * * The key portion of a label must be unique. However, you can use the same
   *   key with multiple resources.
   * * Keys must start with a lowercase letter or international character.
   *
   * See [Google Cloud
   * Document](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
   * for more details.
   * </pre>
   *
   * <code>map&lt;string, string&gt; user_labels = 22;</code>
   */
  /* nullable */
  java.lang.String getUserLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue);
  /**
   *
   *
   * <pre>
   * The user labels applied to a resource must meet the following requirements:
   *
   * * Each resource can have multiple labels, up to a maximum of 64.
   * * Each label must be a key-value pair.
   * * Keys have a minimum length of 1 character and a maximum length of 63
   *   characters and cannot be empty. Values can be empty and have a maximum
   *   length of 63 characters.
   * * Keys and values can contain only lowercase letters, numeric characters,
   *   underscores, and dashes. All characters must use UTF-8 encoding, and
   *   international characters are allowed.
   * * The key portion of a label must be unique. However, you can use the same
   *   key with multiple resources.
   * * Keys must start with a lowercase letter or international character.
   *
   * See [Google Cloud
   * Document](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
   * for more details.
   * </pre>
   *
   * <code>map&lt;string, string&gt; user_labels = 22;</code>
   */
  java.lang.String getUserLabelsOrThrow(java.lang.String key);

  /**
   *
   *
   * <pre>
   * If `naturalLanguageQueryUnderstandingSpec` is not specified, no additional
   * natural language query understanding will be done.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1beta.SearchRequest.NaturalLanguageQueryUnderstandingSpec natural_language_query_understanding_spec = 28;
   * </code>
   *
   * @return Whether the naturalLanguageQueryUnderstandingSpec field is set.
   */
  boolean hasNaturalLanguageQueryUnderstandingSpec();
  /**
   *
   *
   * <pre>
   * If `naturalLanguageQueryUnderstandingSpec` is not specified, no additional
   * natural language query understanding will be done.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1beta.SearchRequest.NaturalLanguageQueryUnderstandingSpec natural_language_query_understanding_spec = 28;
   * </code>
   *
   * @return The naturalLanguageQueryUnderstandingSpec.
   */
  com.google.cloud.discoveryengine.v1beta.SearchRequest.NaturalLanguageQueryUnderstandingSpec
      getNaturalLanguageQueryUnderstandingSpec();
  /**
   *
   *
   * <pre>
   * If `naturalLanguageQueryUnderstandingSpec` is not specified, no additional
   * natural language query understanding will be done.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1beta.SearchRequest.NaturalLanguageQueryUnderstandingSpec natural_language_query_understanding_spec = 28;
   * </code>
   */
  com.google.cloud.discoveryengine.v1beta.SearchRequest
          .NaturalLanguageQueryUnderstandingSpecOrBuilder
      getNaturalLanguageQueryUnderstandingSpecOrBuilder();

  /**
   *
   *
   * <pre>
   * Search as you type configuration. Only supported for the
   * [IndustryVertical.MEDIA][google.cloud.discoveryengine.v1beta.IndustryVertical.MEDIA]
   * vertical.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1beta.SearchRequest.SearchAsYouTypeSpec search_as_you_type_spec = 31;
   * </code>
   *
   * @return Whether the searchAsYouTypeSpec field is set.
   */
  boolean hasSearchAsYouTypeSpec();
  /**
   *
   *
   * <pre>
   * Search as you type configuration. Only supported for the
   * [IndustryVertical.MEDIA][google.cloud.discoveryengine.v1beta.IndustryVertical.MEDIA]
   * vertical.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1beta.SearchRequest.SearchAsYouTypeSpec search_as_you_type_spec = 31;
   * </code>
   *
   * @return The searchAsYouTypeSpec.
   */
  com.google.cloud.discoveryengine.v1beta.SearchRequest.SearchAsYouTypeSpec
      getSearchAsYouTypeSpec();
  /**
   *
   *
   * <pre>
   * Search as you type configuration. Only supported for the
   * [IndustryVertical.MEDIA][google.cloud.discoveryengine.v1beta.IndustryVertical.MEDIA]
   * vertical.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1beta.SearchRequest.SearchAsYouTypeSpec search_as_you_type_spec = 31;
   * </code>
   */
  com.google.cloud.discoveryengine.v1beta.SearchRequest.SearchAsYouTypeSpecOrBuilder
      getSearchAsYouTypeSpecOrBuilder();

  /**
   *
   *
   * <pre>
   * The session resource name. Optional.
   *
   * Session allows users to do multi-turn /search API calls or coordination
   * between /search API calls and /answer API calls.
   *
   * Example #1 (multi-turn /search API calls):
   *   1. Call /search API with the auto-session mode (see below).
   *   2. Call /search API with the session ID generated in the first call.
   *      Here, the previous search query gets considered in query
   *      standing. I.e., if the first query is "How did Alphabet do in 2022?"
   *      and the current query is "How about 2023?", the current query will
   *      be interpreted as "How did Alphabet do in 2023?".
   *
   * Example #2 (coordination between /search API calls and /answer API calls):
   *   1. Call /search API with the auto-session mode (see below).
   *   2. Call /answer API with the session ID generated in the first call.
   *      Here, the answer generation happens in the context of the search
   *      results from the first search call.
   *
   * Auto-session mode: when `projects/.../sessions/-` is used, a new session
   * gets automatically created. Otherwise, users can use the create-session API
   * to create a session manually.
   *
   * Multi-turn Search feature is currently at private GA stage. Please use
   * v1alpha or v1beta version instead before we launch this feature to public
   * GA. Or ask for allowlisting through Google Support team.
   * </pre>
   *
   * <code>string session = 41 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The session.
   */
  java.lang.String getSession();
  /**
   *
   *
   * <pre>
   * The session resource name. Optional.
   *
   * Session allows users to do multi-turn /search API calls or coordination
   * between /search API calls and /answer API calls.
   *
   * Example #1 (multi-turn /search API calls):
   *   1. Call /search API with the auto-session mode (see below).
   *   2. Call /search API with the session ID generated in the first call.
   *      Here, the previous search query gets considered in query
   *      standing. I.e., if the first query is "How did Alphabet do in 2022?"
   *      and the current query is "How about 2023?", the current query will
   *      be interpreted as "How did Alphabet do in 2023?".
   *
   * Example #2 (coordination between /search API calls and /answer API calls):
   *   1. Call /search API with the auto-session mode (see below).
   *   2. Call /answer API with the session ID generated in the first call.
   *      Here, the answer generation happens in the context of the search
   *      results from the first search call.
   *
   * Auto-session mode: when `projects/.../sessions/-` is used, a new session
   * gets automatically created. Otherwise, users can use the create-session API
   * to create a session manually.
   *
   * Multi-turn Search feature is currently at private GA stage. Please use
   * v1alpha or v1beta version instead before we launch this feature to public
   * GA. Or ask for allowlisting through Google Support team.
   * </pre>
   *
   * <code>string session = 41 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for session.
   */
  com.google.protobuf.ByteString getSessionBytes();

  /**
   *
   *
   * <pre>
   * Session specification.
   *
   * Can be used only when `session` is set.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.SearchRequest.SessionSpec session_spec = 42;</code>
   *
   * @return Whether the sessionSpec field is set.
   */
  boolean hasSessionSpec();
  /**
   *
   *
   * <pre>
   * Session specification.
   *
   * Can be used only when `session` is set.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.SearchRequest.SessionSpec session_spec = 42;</code>
   *
   * @return The sessionSpec.
   */
  com.google.cloud.discoveryengine.v1beta.SearchRequest.SessionSpec getSessionSpec();
  /**
   *
   *
   * <pre>
   * Session specification.
   *
   * Can be used only when `session` is set.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.SearchRequest.SessionSpec session_spec = 42;</code>
   */
  com.google.cloud.discoveryengine.v1beta.SearchRequest.SessionSpecOrBuilder
      getSessionSpecOrBuilder();

  /**
   *
   *
   * <pre>
   * The relevance threshold of the search results.
   *
   * Default to Google defined threshold, leveraging a balance of
   * precision and recall to deliver both highly accurate results and
   * comprehensive coverage of relevant information.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1beta.SearchRequest.RelevanceThreshold relevance_threshold = 44;
   * </code>
   *
   * @return The enum numeric value on the wire for relevanceThreshold.
   */
  int getRelevanceThresholdValue();
  /**
   *
   *
   * <pre>
   * The relevance threshold of the search results.
   *
   * Default to Google defined threshold, leveraging a balance of
   * precision and recall to deliver both highly accurate results and
   * comprehensive coverage of relevant information.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1beta.SearchRequest.RelevanceThreshold relevance_threshold = 44;
   * </code>
   *
   * @return The relevanceThreshold.
   */
  com.google.cloud.discoveryengine.v1beta.SearchRequest.RelevanceThreshold getRelevanceThreshold();
}
