/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/discoveryengine/v1beta/session.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.discoveryengine.v1beta;

/**
 *
 *
 * <pre>
 * External session proto definition.
 * </pre>
 *
 * Protobuf type {@code google.cloud.discoveryengine.v1beta.Session}
 */
public final class Session extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.Session)
    SessionOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Session.newBuilder() to construct.
  private Session(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Session() {
    name_ = "";
    state_ = 0;
    userPseudoId_ = "";
    turns_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Session();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.discoveryengine.v1beta.SessionProto
        .internal_static_google_cloud_discoveryengine_v1beta_Session_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.discoveryengine.v1beta.SessionProto
        .internal_static_google_cloud_discoveryengine_v1beta_Session_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.discoveryengine.v1beta.Session.class,
            com.google.cloud.discoveryengine.v1beta.Session.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Enumeration of the state of the session.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.discoveryengine.v1beta.Session.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * State is unspecified.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The session is currently open.
     * </pre>
     *
     * <code>IN_PROGRESS = 1;</code>
     */
    IN_PROGRESS(1),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * State is unspecified.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    public static final int STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The session is currently open.
     * </pre>
     *
     * <code>IN_PROGRESS = 1;</code>
     */
    public static final int IN_PROGRESS_VALUE = 1;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return STATE_UNSPECIFIED;
        case 1:
          return IN_PROGRESS;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1beta.Session.getDescriptor().getEnumTypes().get(0);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.discoveryengine.v1beta.Session.State)
  }

  public interface TurnOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1beta.Session.Turn)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The user query.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.Query query = 1;</code>
     *
     * @return Whether the query field is set.
     */
    boolean hasQuery();
    /**
     *
     *
     * <pre>
     * The user query.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.Query query = 1;</code>
     *
     * @return The query.
     */
    com.google.cloud.discoveryengine.v1beta.Query getQuery();
    /**
     *
     *
     * <pre>
     * The user query.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.Query query = 1;</code>
     */
    com.google.cloud.discoveryengine.v1beta.QueryOrBuilder getQueryOrBuilder();

    /**
     *
     *
     * <pre>
     * The resource name of the answer to the user query.
     *
     * Only set if the answer generation (/answer API call) happened in this
     * turn.
     * </pre>
     *
     * <code>string answer = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The answer.
     */
    java.lang.String getAnswer();
    /**
     *
     *
     * <pre>
     * The resource name of the answer to the user query.
     *
     * Only set if the answer generation (/answer API call) happened in this
     * turn.
     * </pre>
     *
     * <code>string answer = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for answer.
     */
    com.google.protobuf.ByteString getAnswerBytes();
  }
  /**
   *
   *
   * <pre>
   * Represents a turn, including a query from the user and a
   * answer from service.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1beta.Session.Turn}
   */
  public static final class Turn extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.Session.Turn)
      TurnOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Turn.newBuilder() to construct.
    private Turn(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Turn() {
      answer_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Turn();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1beta.SessionProto
          .internal_static_google_cloud_discoveryengine_v1beta_Session_Turn_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1beta.SessionProto
          .internal_static_google_cloud_discoveryengine_v1beta_Session_Turn_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1beta.Session.Turn.class,
              com.google.cloud.discoveryengine.v1beta.Session.Turn.Builder.class);
    }

    private int bitField0_;
    public static final int QUERY_FIELD_NUMBER = 1;
    private com.google.cloud.discoveryengine.v1beta.Query query_;
    /**
     *
     *
     * <pre>
     * The user query.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.Query query = 1;</code>
     *
     * @return Whether the query field is set.
     */
    @java.lang.Override
    public boolean hasQuery() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * The user query.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.Query query = 1;</code>
     *
     * @return The query.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.Query getQuery() {
      return query_ == null
          ? com.google.cloud.discoveryengine.v1beta.Query.getDefaultInstance()
          : query_;
    }
    /**
     *
     *
     * <pre>
     * The user query.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.Query query = 1;</code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.QueryOrBuilder getQueryOrBuilder() {
      return query_ == null
          ? com.google.cloud.discoveryengine.v1beta.Query.getDefaultInstance()
          : query_;
    }

    public static final int ANSWER_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object answer_ = "";
    /**
     *
     *
     * <pre>
     * The resource name of the answer to the user query.
     *
     * Only set if the answer generation (/answer API call) happened in this
     * turn.
     * </pre>
     *
     * <code>string answer = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The answer.
     */
    @java.lang.Override
    public java.lang.String getAnswer() {
      java.lang.Object ref = answer_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        answer_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of the answer to the user query.
     *
     * Only set if the answer generation (/answer API call) happened in this
     * turn.
     * </pre>
     *
     * <code>string answer = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for answer.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getAnswerBytes() {
      java.lang.Object ref = answer_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        answer_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getQuery());
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(answer_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, answer_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getQuery());
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(answer_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, answer_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.discoveryengine.v1beta.Session.Turn)) {
        return super.equals(obj);
      }
      com.google.cloud.discoveryengine.v1beta.Session.Turn other =
          (com.google.cloud.discoveryengine.v1beta.Session.Turn) obj;

      if (hasQuery() != other.hasQuery()) return false;
      if (hasQuery()) {
        if (!getQuery().equals(other.getQuery())) return false;
      }
      if (!getAnswer().equals(other.getAnswer())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasQuery()) {
        hash = (37 * hash) + QUERY_FIELD_NUMBER;
        hash = (53 * hash) + getQuery().hashCode();
      }
      hash = (37 * hash) + ANSWER_FIELD_NUMBER;
      hash = (53 * hash) + getAnswer().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.discoveryengine.v1beta.Session.Turn parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.Session.Turn parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.Session.Turn parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.Session.Turn parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.Session.Turn parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.Session.Turn parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.Session.Turn parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.Session.Turn parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.Session.Turn parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.Session.Turn parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.Session.Turn parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.Session.Turn parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.discoveryengine.v1beta.Session.Turn prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Represents a turn, including a query from the user and a
     * answer from service.
     * </pre>
     *
     * Protobuf type {@code google.cloud.discoveryengine.v1beta.Session.Turn}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.Session.Turn)
        com.google.cloud.discoveryengine.v1beta.Session.TurnOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1beta.SessionProto
            .internal_static_google_cloud_discoveryengine_v1beta_Session_Turn_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1beta.SessionProto
            .internal_static_google_cloud_discoveryengine_v1beta_Session_Turn_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1beta.Session.Turn.class,
                com.google.cloud.discoveryengine.v1beta.Session.Turn.Builder.class);
      }

      // Construct using com.google.cloud.discoveryengine.v1beta.Session.Turn.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getQueryFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        query_ = null;
        if (queryBuilder_ != null) {
          queryBuilder_.dispose();
          queryBuilder_ = null;
        }
        answer_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.discoveryengine.v1beta.SessionProto
            .internal_static_google_cloud_discoveryengine_v1beta_Session_Turn_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.Session.Turn getDefaultInstanceForType() {
        return com.google.cloud.discoveryengine.v1beta.Session.Turn.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.Session.Turn build() {
        com.google.cloud.discoveryengine.v1beta.Session.Turn result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.Session.Turn buildPartial() {
        com.google.cloud.discoveryengine.v1beta.Session.Turn result =
            new com.google.cloud.discoveryengine.v1beta.Session.Turn(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.discoveryengine.v1beta.Session.Turn result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.query_ = queryBuilder_ == null ? query_ : queryBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.answer_ = answer_;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.discoveryengine.v1beta.Session.Turn) {
          return mergeFrom((com.google.cloud.discoveryengine.v1beta.Session.Turn) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.discoveryengine.v1beta.Session.Turn other) {
        if (other == com.google.cloud.discoveryengine.v1beta.Session.Turn.getDefaultInstance())
          return this;
        if (other.hasQuery()) {
          mergeQuery(other.getQuery());
        }
        if (!other.getAnswer().isEmpty()) {
          answer_ = other.answer_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getQueryFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  answer_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.cloud.discoveryengine.v1beta.Query query_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.discoveryengine.v1beta.Query,
              com.google.cloud.discoveryengine.v1beta.Query.Builder,
              com.google.cloud.discoveryengine.v1beta.QueryOrBuilder>
          queryBuilder_;
      /**
       *
       *
       * <pre>
       * The user query.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1beta.Query query = 1;</code>
       *
       * @return Whether the query field is set.
       */
      public boolean hasQuery() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * The user query.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1beta.Query query = 1;</code>
       *
       * @return The query.
       */
      public com.google.cloud.discoveryengine.v1beta.Query getQuery() {
        if (queryBuilder_ == null) {
          return query_ == null
              ? com.google.cloud.discoveryengine.v1beta.Query.getDefaultInstance()
              : query_;
        } else {
          return queryBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The user query.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1beta.Query query = 1;</code>
       */
      public Builder setQuery(com.google.cloud.discoveryengine.v1beta.Query value) {
        if (queryBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          query_ = value;
        } else {
          queryBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The user query.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1beta.Query query = 1;</code>
       */
      public Builder setQuery(
          com.google.cloud.discoveryengine.v1beta.Query.Builder builderForValue) {
        if (queryBuilder_ == null) {
          query_ = builderForValue.build();
        } else {
          queryBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The user query.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1beta.Query query = 1;</code>
       */
      public Builder mergeQuery(com.google.cloud.discoveryengine.v1beta.Query value) {
        if (queryBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && query_ != null
              && query_ != com.google.cloud.discoveryengine.v1beta.Query.getDefaultInstance()) {
            getQueryBuilder().mergeFrom(value);
          } else {
            query_ = value;
          }
        } else {
          queryBuilder_.mergeFrom(value);
        }
        if (query_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The user query.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1beta.Query query = 1;</code>
       */
      public Builder clearQuery() {
        bitField0_ = (bitField0_ & ~0x00000001);
        query_ = null;
        if (queryBuilder_ != null) {
          queryBuilder_.dispose();
          queryBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The user query.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1beta.Query query = 1;</code>
       */
      public com.google.cloud.discoveryengine.v1beta.Query.Builder getQueryBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getQueryFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The user query.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1beta.Query query = 1;</code>
       */
      public com.google.cloud.discoveryengine.v1beta.QueryOrBuilder getQueryOrBuilder() {
        if (queryBuilder_ != null) {
          return queryBuilder_.getMessageOrBuilder();
        } else {
          return query_ == null
              ? com.google.cloud.discoveryengine.v1beta.Query.getDefaultInstance()
              : query_;
        }
      }
      /**
       *
       *
       * <pre>
       * The user query.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1beta.Query query = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.discoveryengine.v1beta.Query,
              com.google.cloud.discoveryengine.v1beta.Query.Builder,
              com.google.cloud.discoveryengine.v1beta.QueryOrBuilder>
          getQueryFieldBuilder() {
        if (queryBuilder_ == null) {
          queryBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.discoveryengine.v1beta.Query,
                  com.google.cloud.discoveryengine.v1beta.Query.Builder,
                  com.google.cloud.discoveryengine.v1beta.QueryOrBuilder>(
                  getQuery(), getParentForChildren(), isClean());
          query_ = null;
        }
        return queryBuilder_;
      }

      private java.lang.Object answer_ = "";
      /**
       *
       *
       * <pre>
       * The resource name of the answer to the user query.
       *
       * Only set if the answer generation (/answer API call) happened in this
       * turn.
       * </pre>
       *
       * <code>string answer = 2 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return The answer.
       */
      public java.lang.String getAnswer() {
        java.lang.Object ref = answer_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          answer_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The resource name of the answer to the user query.
       *
       * Only set if the answer generation (/answer API call) happened in this
       * turn.
       * </pre>
       *
       * <code>string answer = 2 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return The bytes for answer.
       */
      public com.google.protobuf.ByteString getAnswerBytes() {
        java.lang.Object ref = answer_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          answer_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The resource name of the answer to the user query.
       *
       * Only set if the answer generation (/answer API call) happened in this
       * turn.
       * </pre>
       *
       * <code>string answer = 2 [(.google.api.resource_reference) = { ... }</code>
       *
       * @param value The answer to set.
       * @return This builder for chaining.
       */
      public Builder setAnswer(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        answer_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The resource name of the answer to the user query.
       *
       * Only set if the answer generation (/answer API call) happened in this
       * turn.
       * </pre>
       *
       * <code>string answer = 2 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAnswer() {
        answer_ = getDefaultInstance().getAnswer();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The resource name of the answer to the user query.
       *
       * Only set if the answer generation (/answer API call) happened in this
       * turn.
       * </pre>
       *
       * <code>string answer = 2 [(.google.api.resource_reference) = { ... }</code>
       *
       * @param value The bytes for answer to set.
       * @return This builder for chaining.
       */
      public Builder setAnswerBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        answer_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.Session.Turn)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.Session.Turn)
    private static final com.google.cloud.discoveryengine.v1beta.Session.Turn DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.discoveryengine.v1beta.Session.Turn();
    }

    public static com.google.cloud.discoveryengine.v1beta.Session.Turn getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Turn> PARSER =
        new com.google.protobuf.AbstractParser<Turn>() {
          @java.lang.Override
          public Turn parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Turn> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Turn> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.Session.Turn getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Immutable. Fully qualified name
   * `projects/{project}/locations/global/collections/{collection}/engines/{engine}/sessions/&#42;`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Immutable. Fully qualified name
   * `projects/{project}/locations/global/collections/{collection}/engines/{engine}/sessions/&#42;`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STATE_FIELD_NUMBER = 2;
  private int state_ = 0;
  /**
   *
   *
   * <pre>
   * The state of the session.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.Session.State state = 2;</code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * The state of the session.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.Session.State state = 2;</code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.Session.State getState() {
    com.google.cloud.discoveryengine.v1beta.Session.State result =
        com.google.cloud.discoveryengine.v1beta.Session.State.forNumber(state_);
    return result == null
        ? com.google.cloud.discoveryengine.v1beta.Session.State.UNRECOGNIZED
        : result;
  }

  public static final int USER_PSEUDO_ID_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object userPseudoId_ = "";
  /**
   *
   *
   * <pre>
   * A unique identifier for tracking users.
   * </pre>
   *
   * <code>string user_pseudo_id = 3;</code>
   *
   * @return The userPseudoId.
   */
  @java.lang.Override
  public java.lang.String getUserPseudoId() {
    java.lang.Object ref = userPseudoId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      userPseudoId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A unique identifier for tracking users.
   * </pre>
   *
   * <code>string user_pseudo_id = 3;</code>
   *
   * @return The bytes for userPseudoId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getUserPseudoIdBytes() {
    java.lang.Object ref = userPseudoId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      userPseudoId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TURNS_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.discoveryengine.v1beta.Session.Turn> turns_;
  /**
   *
   *
   * <pre>
   * Turns.
   * </pre>
   *
   * <code>repeated .google.cloud.discoveryengine.v1beta.Session.Turn turns = 4;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.discoveryengine.v1beta.Session.Turn> getTurnsList() {
    return turns_;
  }
  /**
   *
   *
   * <pre>
   * Turns.
   * </pre>
   *
   * <code>repeated .google.cloud.discoveryengine.v1beta.Session.Turn turns = 4;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.discoveryengine.v1beta.Session.TurnOrBuilder>
      getTurnsOrBuilderList() {
    return turns_;
  }
  /**
   *
   *
   * <pre>
   * Turns.
   * </pre>
   *
   * <code>repeated .google.cloud.discoveryengine.v1beta.Session.Turn turns = 4;</code>
   */
  @java.lang.Override
  public int getTurnsCount() {
    return turns_.size();
  }
  /**
   *
   *
   * <pre>
   * Turns.
   * </pre>
   *
   * <code>repeated .google.cloud.discoveryengine.v1beta.Session.Turn turns = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.Session.Turn getTurns(int index) {
    return turns_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Turns.
   * </pre>
   *
   * <code>repeated .google.cloud.discoveryengine.v1beta.Session.Turn turns = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.Session.TurnOrBuilder getTurnsOrBuilder(
      int index) {
    return turns_.get(index);
  }

  public static final int START_TIME_FIELD_NUMBER = 5;
  private com.google.protobuf.Timestamp startTime_;
  /**
   *
   *
   * <pre>
   * Output only. The time the session started.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the startTime field is set.
   */
  @java.lang.Override
  public boolean hasStartTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The time the session started.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The startTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getStartTime() {
    return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time the session started.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
    return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
  }

  public static final int END_TIME_FIELD_NUMBER = 6;
  private com.google.protobuf.Timestamp endTime_;
  /**
   *
   *
   * <pre>
   * Output only. The time the session finished.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the endTime field is set.
   */
  @java.lang.Override
  public boolean hasEndTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The time the session finished.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The endTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getEndTime() {
    return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time the session finished.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
    return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (state_
        != com.google.cloud.discoveryengine.v1beta.Session.State.STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(2, state_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(userPseudoId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, userPseudoId_);
    }
    for (int i = 0; i < turns_.size(); i++) {
      output.writeMessage(4, turns_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(5, getStartTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(6, getEndTime());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (state_
        != com.google.cloud.discoveryengine.v1beta.Session.State.STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, state_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(userPseudoId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, userPseudoId_);
    }
    for (int i = 0; i < turns_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, turns_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getStartTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getEndTime());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.discoveryengine.v1beta.Session)) {
      return super.equals(obj);
    }
    com.google.cloud.discoveryengine.v1beta.Session other =
        (com.google.cloud.discoveryengine.v1beta.Session) obj;

    if (!getName().equals(other.getName())) return false;
    if (state_ != other.state_) return false;
    if (!getUserPseudoId().equals(other.getUserPseudoId())) return false;
    if (!getTurnsList().equals(other.getTurnsList())) return false;
    if (hasStartTime() != other.hasStartTime()) return false;
    if (hasStartTime()) {
      if (!getStartTime().equals(other.getStartTime())) return false;
    }
    if (hasEndTime() != other.hasEndTime()) return false;
    if (hasEndTime()) {
      if (!getEndTime().equals(other.getEndTime())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    hash = (37 * hash) + USER_PSEUDO_ID_FIELD_NUMBER;
    hash = (53 * hash) + getUserPseudoId().hashCode();
    if (getTurnsCount() > 0) {
      hash = (37 * hash) + TURNS_FIELD_NUMBER;
      hash = (53 * hash) + getTurnsList().hashCode();
    }
    if (hasStartTime()) {
      hash = (37 * hash) + START_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getStartTime().hashCode();
    }
    if (hasEndTime()) {
      hash = (37 * hash) + END_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getEndTime().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.discoveryengine.v1beta.Session parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1beta.Session parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.Session parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1beta.Session parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.Session parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1beta.Session parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.Session parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1beta.Session parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.Session parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1beta.Session parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.Session parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1beta.Session parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.discoveryengine.v1beta.Session prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * External session proto definition.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1beta.Session}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.Session)
      com.google.cloud.discoveryengine.v1beta.SessionOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1beta.SessionProto
          .internal_static_google_cloud_discoveryengine_v1beta_Session_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1beta.SessionProto
          .internal_static_google_cloud_discoveryengine_v1beta_Session_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1beta.Session.class,
              com.google.cloud.discoveryengine.v1beta.Session.Builder.class);
    }

    // Construct using com.google.cloud.discoveryengine.v1beta.Session.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getTurnsFieldBuilder();
        getStartTimeFieldBuilder();
        getEndTimeFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      state_ = 0;
      userPseudoId_ = "";
      if (turnsBuilder_ == null) {
        turns_ = java.util.Collections.emptyList();
      } else {
        turns_ = null;
        turnsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000008);
      startTime_ = null;
      if (startTimeBuilder_ != null) {
        startTimeBuilder_.dispose();
        startTimeBuilder_ = null;
      }
      endTime_ = null;
      if (endTimeBuilder_ != null) {
        endTimeBuilder_.dispose();
        endTimeBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.discoveryengine.v1beta.SessionProto
          .internal_static_google_cloud_discoveryengine_v1beta_Session_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.Session getDefaultInstanceForType() {
      return com.google.cloud.discoveryengine.v1beta.Session.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.Session build() {
      com.google.cloud.discoveryengine.v1beta.Session result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.Session buildPartial() {
      com.google.cloud.discoveryengine.v1beta.Session result =
          new com.google.cloud.discoveryengine.v1beta.Session(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.discoveryengine.v1beta.Session result) {
      if (turnsBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)) {
          turns_ = java.util.Collections.unmodifiableList(turns_);
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.turns_ = turns_;
      } else {
        result.turns_ = turnsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.discoveryengine.v1beta.Session result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.state_ = state_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.userPseudoId_ = userPseudoId_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.startTime_ = startTimeBuilder_ == null ? startTime_ : startTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.endTime_ = endTimeBuilder_ == null ? endTime_ : endTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.discoveryengine.v1beta.Session) {
        return mergeFrom((com.google.cloud.discoveryengine.v1beta.Session) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.discoveryengine.v1beta.Session other) {
      if (other == com.google.cloud.discoveryengine.v1beta.Session.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (!other.getUserPseudoId().isEmpty()) {
        userPseudoId_ = other.userPseudoId_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (turnsBuilder_ == null) {
        if (!other.turns_.isEmpty()) {
          if (turns_.isEmpty()) {
            turns_ = other.turns_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensureTurnsIsMutable();
            turns_.addAll(other.turns_);
          }
          onChanged();
        }
      } else {
        if (!other.turns_.isEmpty()) {
          if (turnsBuilder_.isEmpty()) {
            turnsBuilder_.dispose();
            turnsBuilder_ = null;
            turns_ = other.turns_;
            bitField0_ = (bitField0_ & ~0x00000008);
            turnsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getTurnsFieldBuilder()
                    : null;
          } else {
            turnsBuilder_.addAllMessages(other.turns_);
          }
        }
      }
      if (other.hasStartTime()) {
        mergeStartTime(other.getStartTime());
      }
      if (other.hasEndTime()) {
        mergeEndTime(other.getEndTime());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                state_ = input.readEnum();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 26:
              {
                userPseudoId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                com.google.cloud.discoveryengine.v1beta.Session.Turn m =
                    input.readMessage(
                        com.google.cloud.discoveryengine.v1beta.Session.Turn.parser(),
                        extensionRegistry);
                if (turnsBuilder_ == null) {
                  ensureTurnsIsMutable();
                  turns_.add(m);
                } else {
                  turnsBuilder_.addMessage(m);
                }
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getStartTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getEndTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Immutable. Fully qualified name
     * `projects/{project}/locations/global/collections/{collection}/engines/{engine}/sessions/&#42;`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. Fully qualified name
     * `projects/{project}/locations/global/collections/{collection}/engines/{engine}/sessions/&#42;`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. Fully qualified name
     * `projects/{project}/locations/global/collections/{collection}/engines/{engine}/sessions/&#42;`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. Fully qualified name
     * `projects/{project}/locations/global/collections/{collection}/engines/{engine}/sessions/&#42;`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. Fully qualified name
     * `projects/{project}/locations/global/collections/{collection}/engines/{engine}/sessions/&#42;`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * The state of the session.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.Session.State state = 2;</code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * The state of the session.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.Session.State state = 2;</code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {
      state_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The state of the session.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.Session.State state = 2;</code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.Session.State getState() {
      com.google.cloud.discoveryengine.v1beta.Session.State result =
          com.google.cloud.discoveryengine.v1beta.Session.State.forNumber(state_);
      return result == null
          ? com.google.cloud.discoveryengine.v1beta.Session.State.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * The state of the session.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.Session.State state = 2;</code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.cloud.discoveryengine.v1beta.Session.State value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000002;
      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The state of the session.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.Session.State state = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      bitField0_ = (bitField0_ & ~0x00000002);
      state_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object userPseudoId_ = "";
    /**
     *
     *
     * <pre>
     * A unique identifier for tracking users.
     * </pre>
     *
     * <code>string user_pseudo_id = 3;</code>
     *
     * @return The userPseudoId.
     */
    public java.lang.String getUserPseudoId() {
      java.lang.Object ref = userPseudoId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        userPseudoId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A unique identifier for tracking users.
     * </pre>
     *
     * <code>string user_pseudo_id = 3;</code>
     *
     * @return The bytes for userPseudoId.
     */
    public com.google.protobuf.ByteString getUserPseudoIdBytes() {
      java.lang.Object ref = userPseudoId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        userPseudoId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A unique identifier for tracking users.
     * </pre>
     *
     * <code>string user_pseudo_id = 3;</code>
     *
     * @param value The userPseudoId to set.
     * @return This builder for chaining.
     */
    public Builder setUserPseudoId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      userPseudoId_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A unique identifier for tracking users.
     * </pre>
     *
     * <code>string user_pseudo_id = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUserPseudoId() {
      userPseudoId_ = getDefaultInstance().getUserPseudoId();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A unique identifier for tracking users.
     * </pre>
     *
     * <code>string user_pseudo_id = 3;</code>
     *
     * @param value The bytes for userPseudoId to set.
     * @return This builder for chaining.
     */
    public Builder setUserPseudoIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      userPseudoId_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.discoveryengine.v1beta.Session.Turn> turns_ =
        java.util.Collections.emptyList();

    private void ensureTurnsIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        turns_ =
            new java.util.ArrayList<com.google.cloud.discoveryengine.v1beta.Session.Turn>(turns_);
        bitField0_ |= 0x00000008;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.discoveryengine.v1beta.Session.Turn,
            com.google.cloud.discoveryengine.v1beta.Session.Turn.Builder,
            com.google.cloud.discoveryengine.v1beta.Session.TurnOrBuilder>
        turnsBuilder_;

    /**
     *
     *
     * <pre>
     * Turns.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.Session.Turn turns = 4;</code>
     */
    public java.util.List<com.google.cloud.discoveryengine.v1beta.Session.Turn> getTurnsList() {
      if (turnsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(turns_);
      } else {
        return turnsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Turns.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.Session.Turn turns = 4;</code>
     */
    public int getTurnsCount() {
      if (turnsBuilder_ == null) {
        return turns_.size();
      } else {
        return turnsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Turns.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.Session.Turn turns = 4;</code>
     */
    public com.google.cloud.discoveryengine.v1beta.Session.Turn getTurns(int index) {
      if (turnsBuilder_ == null) {
        return turns_.get(index);
      } else {
        return turnsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Turns.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.Session.Turn turns = 4;</code>
     */
    public Builder setTurns(int index, com.google.cloud.discoveryengine.v1beta.Session.Turn value) {
      if (turnsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTurnsIsMutable();
        turns_.set(index, value);
        onChanged();
      } else {
        turnsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Turns.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.Session.Turn turns = 4;</code>
     */
    public Builder setTurns(
        int index, com.google.cloud.discoveryengine.v1beta.Session.Turn.Builder builderForValue) {
      if (turnsBuilder_ == null) {
        ensureTurnsIsMutable();
        turns_.set(index, builderForValue.build());
        onChanged();
      } else {
        turnsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Turns.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.Session.Turn turns = 4;</code>
     */
    public Builder addTurns(com.google.cloud.discoveryengine.v1beta.Session.Turn value) {
      if (turnsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTurnsIsMutable();
        turns_.add(value);
        onChanged();
      } else {
        turnsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Turns.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.Session.Turn turns = 4;</code>
     */
    public Builder addTurns(int index, com.google.cloud.discoveryengine.v1beta.Session.Turn value) {
      if (turnsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTurnsIsMutable();
        turns_.add(index, value);
        onChanged();
      } else {
        turnsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Turns.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.Session.Turn turns = 4;</code>
     */
    public Builder addTurns(
        com.google.cloud.discoveryengine.v1beta.Session.Turn.Builder builderForValue) {
      if (turnsBuilder_ == null) {
        ensureTurnsIsMutable();
        turns_.add(builderForValue.build());
        onChanged();
      } else {
        turnsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Turns.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.Session.Turn turns = 4;</code>
     */
    public Builder addTurns(
        int index, com.google.cloud.discoveryengine.v1beta.Session.Turn.Builder builderForValue) {
      if (turnsBuilder_ == null) {
        ensureTurnsIsMutable();
        turns_.add(index, builderForValue.build());
        onChanged();
      } else {
        turnsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Turns.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.Session.Turn turns = 4;</code>
     */
    public Builder addAllTurns(
        java.lang.Iterable<? extends com.google.cloud.discoveryengine.v1beta.Session.Turn> values) {
      if (turnsBuilder_ == null) {
        ensureTurnsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, turns_);
        onChanged();
      } else {
        turnsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Turns.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.Session.Turn turns = 4;</code>
     */
    public Builder clearTurns() {
      if (turnsBuilder_ == null) {
        turns_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
      } else {
        turnsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Turns.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.Session.Turn turns = 4;</code>
     */
    public Builder removeTurns(int index) {
      if (turnsBuilder_ == null) {
        ensureTurnsIsMutable();
        turns_.remove(index);
        onChanged();
      } else {
        turnsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Turns.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.Session.Turn turns = 4;</code>
     */
    public com.google.cloud.discoveryengine.v1beta.Session.Turn.Builder getTurnsBuilder(int index) {
      return getTurnsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Turns.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.Session.Turn turns = 4;</code>
     */
    public com.google.cloud.discoveryengine.v1beta.Session.TurnOrBuilder getTurnsOrBuilder(
        int index) {
      if (turnsBuilder_ == null) {
        return turns_.get(index);
      } else {
        return turnsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Turns.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.Session.Turn turns = 4;</code>
     */
    public java.util.List<? extends com.google.cloud.discoveryengine.v1beta.Session.TurnOrBuilder>
        getTurnsOrBuilderList() {
      if (turnsBuilder_ != null) {
        return turnsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(turns_);
      }
    }
    /**
     *
     *
     * <pre>
     * Turns.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.Session.Turn turns = 4;</code>
     */
    public com.google.cloud.discoveryengine.v1beta.Session.Turn.Builder addTurnsBuilder() {
      return getTurnsFieldBuilder()
          .addBuilder(com.google.cloud.discoveryengine.v1beta.Session.Turn.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Turns.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.Session.Turn turns = 4;</code>
     */
    public com.google.cloud.discoveryengine.v1beta.Session.Turn.Builder addTurnsBuilder(int index) {
      return getTurnsFieldBuilder()
          .addBuilder(
              index, com.google.cloud.discoveryengine.v1beta.Session.Turn.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Turns.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.Session.Turn turns = 4;</code>
     */
    public java.util.List<com.google.cloud.discoveryengine.v1beta.Session.Turn.Builder>
        getTurnsBuilderList() {
      return getTurnsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.discoveryengine.v1beta.Session.Turn,
            com.google.cloud.discoveryengine.v1beta.Session.Turn.Builder,
            com.google.cloud.discoveryengine.v1beta.Session.TurnOrBuilder>
        getTurnsFieldBuilder() {
      if (turnsBuilder_ == null) {
        turnsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.discoveryengine.v1beta.Session.Turn,
                com.google.cloud.discoveryengine.v1beta.Session.Turn.Builder,
                com.google.cloud.discoveryengine.v1beta.Session.TurnOrBuilder>(
                turns_, ((bitField0_ & 0x00000008) != 0), getParentForChildren(), isClean());
        turns_ = null;
      }
      return turnsBuilder_;
    }

    private com.google.protobuf.Timestamp startTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        startTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The time the session started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the startTime field is set.
     */
    public boolean hasStartTime() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the session started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The startTime.
     */
    public com.google.protobuf.Timestamp getStartTime() {
      if (startTimeBuilder_ == null) {
        return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
      } else {
        return startTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the session started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setStartTime(com.google.protobuf.Timestamp value) {
      if (startTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        startTime_ = value;
      } else {
        startTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the session started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setStartTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (startTimeBuilder_ == null) {
        startTime_ = builderForValue.build();
      } else {
        startTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the session started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeStartTime(com.google.protobuf.Timestamp value) {
      if (startTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && startTime_ != null
            && startTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getStartTimeBuilder().mergeFrom(value);
        } else {
          startTime_ = value;
        }
      } else {
        startTimeBuilder_.mergeFrom(value);
      }
      if (startTime_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the session started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearStartTime() {
      bitField0_ = (bitField0_ & ~0x00000010);
      startTime_ = null;
      if (startTimeBuilder_ != null) {
        startTimeBuilder_.dispose();
        startTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the session started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getStartTimeBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getStartTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the session started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
      if (startTimeBuilder_ != null) {
        return startTimeBuilder_.getMessageOrBuilder();
      } else {
        return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the session started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getStartTimeFieldBuilder() {
      if (startTimeBuilder_ == null) {
        startTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getStartTime(), getParentForChildren(), isClean());
        startTime_ = null;
      }
      return startTimeBuilder_;
    }

    private com.google.protobuf.Timestamp endTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        endTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The time the session finished.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the endTime field is set.
     */
    public boolean hasEndTime() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the session finished.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The endTime.
     */
    public com.google.protobuf.Timestamp getEndTime() {
      if (endTimeBuilder_ == null) {
        return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
      } else {
        return endTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the session finished.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setEndTime(com.google.protobuf.Timestamp value) {
      if (endTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        endTime_ = value;
      } else {
        endTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the session finished.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setEndTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (endTimeBuilder_ == null) {
        endTime_ = builderForValue.build();
      } else {
        endTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the session finished.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeEndTime(com.google.protobuf.Timestamp value) {
      if (endTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && endTime_ != null
            && endTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getEndTimeBuilder().mergeFrom(value);
        } else {
          endTime_ = value;
        }
      } else {
        endTimeBuilder_.mergeFrom(value);
      }
      if (endTime_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the session finished.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearEndTime() {
      bitField0_ = (bitField0_ & ~0x00000020);
      endTime_ = null;
      if (endTimeBuilder_ != null) {
        endTimeBuilder_.dispose();
        endTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the session finished.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getEndTimeBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getEndTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the session finished.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
      if (endTimeBuilder_ != null) {
        return endTimeBuilder_.getMessageOrBuilder();
      } else {
        return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the session finished.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getEndTimeFieldBuilder() {
      if (endTimeBuilder_ == null) {
        endTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getEndTime(), getParentForChildren(), isClean());
        endTime_ = null;
      }
      return endTimeBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.Session)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.Session)
  private static final com.google.cloud.discoveryengine.v1beta.Session DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.discoveryengine.v1beta.Session();
  }

  public static com.google.cloud.discoveryengine.v1beta.Session getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Session> PARSER =
      new com.google.protobuf.AbstractParser<Session>() {
        @java.lang.Override
        public Session parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Session> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Session> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.Session getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
