/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/discoveryengine/v1beta/site_search_engine.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.discoveryengine.v1beta;

/**
 *
 *
 * <pre>
 * A target site for the SiteSearchEngine.
 * </pre>
 *
 * Protobuf type {@code google.cloud.discoveryengine.v1beta.TargetSite}
 */
public final class TargetSite extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.TargetSite)
    TargetSiteOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use TargetSite.newBuilder() to construct.
  private TargetSite(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private TargetSite() {
    name_ = "";
    providedUriPattern_ = "";
    type_ = 0;
    generatedUriPattern_ = "";
    rootDomainUri_ = "";
    indexingStatus_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new TargetSite();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.discoveryengine.v1beta.SiteSearchEngineProto
        .internal_static_google_cloud_discoveryengine_v1beta_TargetSite_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.discoveryengine.v1beta.SiteSearchEngineProto
        .internal_static_google_cloud_discoveryengine_v1beta_TargetSite_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.discoveryengine.v1beta.TargetSite.class,
            com.google.cloud.discoveryengine.v1beta.TargetSite.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Possible target site types.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.discoveryengine.v1beta.TargetSite.Type}
   */
  public enum Type implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * This value is unused. In this case, server behavior defaults to
     * [Type.INCLUDE][google.cloud.discoveryengine.v1beta.TargetSite.Type.INCLUDE].
     * </pre>
     *
     * <code>TYPE_UNSPECIFIED = 0;</code>
     */
    TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Include the target site.
     * </pre>
     *
     * <code>INCLUDE = 1;</code>
     */
    INCLUDE(1),
    /**
     *
     *
     * <pre>
     * Exclude the target site.
     * </pre>
     *
     * <code>EXCLUDE = 2;</code>
     */
    EXCLUDE(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * This value is unused. In this case, server behavior defaults to
     * [Type.INCLUDE][google.cloud.discoveryengine.v1beta.TargetSite.Type.INCLUDE].
     * </pre>
     *
     * <code>TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int TYPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Include the target site.
     * </pre>
     *
     * <code>INCLUDE = 1;</code>
     */
    public static final int INCLUDE_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Exclude the target site.
     * </pre>
     *
     * <code>EXCLUDE = 2;</code>
     */
    public static final int EXCLUDE_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Type valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Type forNumber(int value) {
      switch (value) {
        case 0:
          return TYPE_UNSPECIFIED;
        case 1:
          return INCLUDE;
        case 2:
          return EXCLUDE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Type> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Type> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Type>() {
          public Type findValueByNumber(int number) {
            return Type.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1beta.TargetSite.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final Type[] VALUES = values();

    public static Type valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Type(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.discoveryengine.v1beta.TargetSite.Type)
  }

  /**
   *
   *
   * <pre>
   * Target site indexing status enumeration.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.discoveryengine.v1beta.TargetSite.IndexingStatus}
   */
  public enum IndexingStatus implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Defaults to SUCCEEDED.
     * </pre>
     *
     * <code>INDEXING_STATUS_UNSPECIFIED = 0;</code>
     */
    INDEXING_STATUS_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The target site is in the update queue and will be picked up by indexing
     * pipeline.
     * </pre>
     *
     * <code>PENDING = 1;</code>
     */
    PENDING(1),
    /**
     *
     *
     * <pre>
     * The target site fails to be indexed.
     * </pre>
     *
     * <code>FAILED = 2;</code>
     */
    FAILED(2),
    /**
     *
     *
     * <pre>
     * The target site has been indexed.
     * </pre>
     *
     * <code>SUCCEEDED = 3;</code>
     */
    SUCCEEDED(3),
    /**
     *
     *
     * <pre>
     * The previously indexed target site has been marked to be deleted. This is
     * a transitioning state which will resulted in either:
     * 1. target site deleted if unindexing is successful;
     * 2. state reverts to SUCCEEDED if the unindexing fails.
     * </pre>
     *
     * <code>DELETING = 4;</code>
     */
    DELETING(4),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Defaults to SUCCEEDED.
     * </pre>
     *
     * <code>INDEXING_STATUS_UNSPECIFIED = 0;</code>
     */
    public static final int INDEXING_STATUS_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The target site is in the update queue and will be picked up by indexing
     * pipeline.
     * </pre>
     *
     * <code>PENDING = 1;</code>
     */
    public static final int PENDING_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The target site fails to be indexed.
     * </pre>
     *
     * <code>FAILED = 2;</code>
     */
    public static final int FAILED_VALUE = 2;
    /**
     *
     *
     * <pre>
     * The target site has been indexed.
     * </pre>
     *
     * <code>SUCCEEDED = 3;</code>
     */
    public static final int SUCCEEDED_VALUE = 3;
    /**
     *
     *
     * <pre>
     * The previously indexed target site has been marked to be deleted. This is
     * a transitioning state which will resulted in either:
     * 1. target site deleted if unindexing is successful;
     * 2. state reverts to SUCCEEDED if the unindexing fails.
     * </pre>
     *
     * <code>DELETING = 4;</code>
     */
    public static final int DELETING_VALUE = 4;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static IndexingStatus valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static IndexingStatus forNumber(int value) {
      switch (value) {
        case 0:
          return INDEXING_STATUS_UNSPECIFIED;
        case 1:
          return PENDING;
        case 2:
          return FAILED;
        case 3:
          return SUCCEEDED;
        case 4:
          return DELETING;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<IndexingStatus> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<IndexingStatus> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<IndexingStatus>() {
          public IndexingStatus findValueByNumber(int number) {
            return IndexingStatus.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1beta.TargetSite.getDescriptor()
          .getEnumTypes()
          .get(1);
    }

    private static final IndexingStatus[] VALUES = values();

    public static IndexingStatus valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private IndexingStatus(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.discoveryengine.v1beta.TargetSite.IndexingStatus)
  }

  public interface FailureReasonOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1beta.TargetSite.FailureReason)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Failed due to insufficient quota.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.TargetSite.FailureReason.QuotaFailure quota_failure = 1;
     * </code>
     *
     * @return Whether the quotaFailure field is set.
     */
    boolean hasQuotaFailure();
    /**
     *
     *
     * <pre>
     * Failed due to insufficient quota.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.TargetSite.FailureReason.QuotaFailure quota_failure = 1;
     * </code>
     *
     * @return The quotaFailure.
     */
    com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason.QuotaFailure getQuotaFailure();
    /**
     *
     *
     * <pre>
     * Failed due to insufficient quota.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.TargetSite.FailureReason.QuotaFailure quota_failure = 1;
     * </code>
     */
    com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason.QuotaFailureOrBuilder
        getQuotaFailureOrBuilder();

    com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason.FailureCase getFailureCase();
  }
  /**
   *
   *
   * <pre>
   * Site search indexing failure reasons.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1beta.TargetSite.FailureReason}
   */
  public static final class FailureReason extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.TargetSite.FailureReason)
      FailureReasonOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use FailureReason.newBuilder() to construct.
    private FailureReason(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private FailureReason() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new FailureReason();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1beta.SiteSearchEngineProto
          .internal_static_google_cloud_discoveryengine_v1beta_TargetSite_FailureReason_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1beta.SiteSearchEngineProto
          .internal_static_google_cloud_discoveryengine_v1beta_TargetSite_FailureReason_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason.class,
              com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason.Builder.class);
    }

    public interface QuotaFailureOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1beta.TargetSite.FailureReason.QuotaFailure)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * This number is an estimation on how much total quota this project needs
       * to successfully complete indexing.
       * </pre>
       *
       * <code>int64 total_required_quota = 1;</code>
       *
       * @return The totalRequiredQuota.
       */
      long getTotalRequiredQuota();
    }
    /**
     *
     *
     * <pre>
     * Failed due to insufficient quota.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.discoveryengine.v1beta.TargetSite.FailureReason.QuotaFailure}
     */
    public static final class QuotaFailure extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.TargetSite.FailureReason.QuotaFailure)
        QuotaFailureOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use QuotaFailure.newBuilder() to construct.
      private QuotaFailure(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private QuotaFailure() {}

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new QuotaFailure();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1beta.SiteSearchEngineProto
            .internal_static_google_cloud_discoveryengine_v1beta_TargetSite_FailureReason_QuotaFailure_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1beta.SiteSearchEngineProto
            .internal_static_google_cloud_discoveryengine_v1beta_TargetSite_FailureReason_QuotaFailure_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason.QuotaFailure.class,
                com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason.QuotaFailure
                    .Builder.class);
      }

      public static final int TOTAL_REQUIRED_QUOTA_FIELD_NUMBER = 1;
      private long totalRequiredQuota_ = 0L;
      /**
       *
       *
       * <pre>
       * This number is an estimation on how much total quota this project needs
       * to successfully complete indexing.
       * </pre>
       *
       * <code>int64 total_required_quota = 1;</code>
       *
       * @return The totalRequiredQuota.
       */
      @java.lang.Override
      public long getTotalRequiredQuota() {
        return totalRequiredQuota_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (totalRequiredQuota_ != 0L) {
          output.writeInt64(1, totalRequiredQuota_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (totalRequiredQuota_ != 0L) {
          size += com.google.protobuf.CodedOutputStream.computeInt64Size(1, totalRequiredQuota_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason.QuotaFailure)) {
          return super.equals(obj);
        }
        com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason.QuotaFailure other =
            (com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason.QuotaFailure) obj;

        if (getTotalRequiredQuota() != other.getTotalRequiredQuota()) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + TOTAL_REQUIRED_QUOTA_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getTotalRequiredQuota());
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason.QuotaFailure
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason.QuotaFailure
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason.QuotaFailure
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason.QuotaFailure
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason.QuotaFailure
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason.QuotaFailure
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason.QuotaFailure
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason.QuotaFailure
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason.QuotaFailure
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason.QuotaFailure
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason.QuotaFailure
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason.QuotaFailure
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason.QuotaFailure prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Failed due to insufficient quota.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.discoveryengine.v1beta.TargetSite.FailureReason.QuotaFailure}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.TargetSite.FailureReason.QuotaFailure)
          com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason.QuotaFailureOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.discoveryengine.v1beta.SiteSearchEngineProto
              .internal_static_google_cloud_discoveryengine_v1beta_TargetSite_FailureReason_QuotaFailure_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.discoveryengine.v1beta.SiteSearchEngineProto
              .internal_static_google_cloud_discoveryengine_v1beta_TargetSite_FailureReason_QuotaFailure_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason.QuotaFailure
                      .class,
                  com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason.QuotaFailure
                      .Builder.class);
        }

        // Construct using
        // com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason.QuotaFailure.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          totalRequiredQuota_ = 0L;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.discoveryengine.v1beta.SiteSearchEngineProto
              .internal_static_google_cloud_discoveryengine_v1beta_TargetSite_FailureReason_QuotaFailure_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason.QuotaFailure
            getDefaultInstanceForType() {
          return com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason.QuotaFailure
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason.QuotaFailure
            build() {
          com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason.QuotaFailure result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason.QuotaFailure
            buildPartial() {
          com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason.QuotaFailure result =
              new com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason.QuotaFailure(
                  this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason.QuotaFailure result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.totalRequiredQuota_ = totalRequiredQuota_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason.QuotaFailure) {
            return mergeFrom(
                (com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason.QuotaFailure)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason.QuotaFailure other) {
          if (other
              == com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason.QuotaFailure
                  .getDefaultInstance()) return this;
          if (other.getTotalRequiredQuota() != 0L) {
            setTotalRequiredQuota(other.getTotalRequiredQuota());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 8:
                  {
                    totalRequiredQuota_ = input.readInt64();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 8
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private long totalRequiredQuota_;
        /**
         *
         *
         * <pre>
         * This number is an estimation on how much total quota this project needs
         * to successfully complete indexing.
         * </pre>
         *
         * <code>int64 total_required_quota = 1;</code>
         *
         * @return The totalRequiredQuota.
         */
        @java.lang.Override
        public long getTotalRequiredQuota() {
          return totalRequiredQuota_;
        }
        /**
         *
         *
         * <pre>
         * This number is an estimation on how much total quota this project needs
         * to successfully complete indexing.
         * </pre>
         *
         * <code>int64 total_required_quota = 1;</code>
         *
         * @param value The totalRequiredQuota to set.
         * @return This builder for chaining.
         */
        public Builder setTotalRequiredQuota(long value) {

          totalRequiredQuota_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * This number is an estimation on how much total quota this project needs
         * to successfully complete indexing.
         * </pre>
         *
         * <code>int64 total_required_quota = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearTotalRequiredQuota() {
          bitField0_ = (bitField0_ & ~0x00000001);
          totalRequiredQuota_ = 0L;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.TargetSite.FailureReason.QuotaFailure)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.TargetSite.FailureReason.QuotaFailure)
      private static final com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason
              .QuotaFailure
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason.QuotaFailure();
      }

      public static com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason.QuotaFailure
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<QuotaFailure> PARSER =
          new com.google.protobuf.AbstractParser<QuotaFailure>() {
            @java.lang.Override
            public QuotaFailure parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<QuotaFailure> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<QuotaFailure> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason.QuotaFailure
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    private int failureCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object failure_;

    public enum FailureCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      QUOTA_FAILURE(1),
      FAILURE_NOT_SET(0);
      private final int value;

      private FailureCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static FailureCase valueOf(int value) {
        return forNumber(value);
      }

      public static FailureCase forNumber(int value) {
        switch (value) {
          case 1:
            return QUOTA_FAILURE;
          case 0:
            return FAILURE_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public FailureCase getFailureCase() {
      return FailureCase.forNumber(failureCase_);
    }

    public static final int QUOTA_FAILURE_FIELD_NUMBER = 1;
    /**
     *
     *
     * <pre>
     * Failed due to insufficient quota.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.TargetSite.FailureReason.QuotaFailure quota_failure = 1;
     * </code>
     *
     * @return Whether the quotaFailure field is set.
     */
    @java.lang.Override
    public boolean hasQuotaFailure() {
      return failureCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * Failed due to insufficient quota.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.TargetSite.FailureReason.QuotaFailure quota_failure = 1;
     * </code>
     *
     * @return The quotaFailure.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason.QuotaFailure
        getQuotaFailure() {
      if (failureCase_ == 1) {
        return (com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason.QuotaFailure)
            failure_;
      }
      return com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason.QuotaFailure
          .getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * Failed due to insufficient quota.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.TargetSite.FailureReason.QuotaFailure quota_failure = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason.QuotaFailureOrBuilder
        getQuotaFailureOrBuilder() {
      if (failureCase_ == 1) {
        return (com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason.QuotaFailure)
            failure_;
      }
      return com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason.QuotaFailure
          .getDefaultInstance();
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (failureCase_ == 1) {
        output.writeMessage(
            1,
            (com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason.QuotaFailure)
                failure_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (failureCase_ == 1) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                1,
                (com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason.QuotaFailure)
                    failure_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason)) {
        return super.equals(obj);
      }
      com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason other =
          (com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason) obj;

      if (!getFailureCase().equals(other.getFailureCase())) return false;
      switch (failureCase_) {
        case 1:
          if (!getQuotaFailure().equals(other.getQuotaFailure())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      switch (failureCase_) {
        case 1:
          hash = (37 * hash) + QUOTA_FAILURE_FIELD_NUMBER;
          hash = (53 * hash) + getQuotaFailure().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Site search indexing failure reasons.
     * </pre>
     *
     * Protobuf type {@code google.cloud.discoveryengine.v1beta.TargetSite.FailureReason}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.TargetSite.FailureReason)
        com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReasonOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1beta.SiteSearchEngineProto
            .internal_static_google_cloud_discoveryengine_v1beta_TargetSite_FailureReason_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1beta.SiteSearchEngineProto
            .internal_static_google_cloud_discoveryengine_v1beta_TargetSite_FailureReason_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason.class,
                com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason.Builder.class);
      }

      // Construct using
      // com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (quotaFailureBuilder_ != null) {
          quotaFailureBuilder_.clear();
        }
        failureCase_ = 0;
        failure_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.discoveryengine.v1beta.SiteSearchEngineProto
            .internal_static_google_cloud_discoveryengine_v1beta_TargetSite_FailureReason_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason
          getDefaultInstanceForType() {
        return com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason build() {
        com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason buildPartial() {
        com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason result =
            new com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason result) {
        int from_bitField0_ = bitField0_;
      }

      private void buildPartialOneofs(
          com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason result) {
        result.failureCase_ = failureCase_;
        result.failure_ = this.failure_;
        if (failureCase_ == 1 && quotaFailureBuilder_ != null) {
          result.failure_ = quotaFailureBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason) {
          return mergeFrom(
              (com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason other) {
        if (other
            == com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason
                .getDefaultInstance()) return this;
        switch (other.getFailureCase()) {
          case QUOTA_FAILURE:
            {
              mergeQuotaFailure(other.getQuotaFailure());
              break;
            }
          case FAILURE_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getQuotaFailureFieldBuilder().getBuilder(), extensionRegistry);
                  failureCase_ = 1;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int failureCase_ = 0;
      private java.lang.Object failure_;

      public FailureCase getFailureCase() {
        return FailureCase.forNumber(failureCase_);
      }

      public Builder clearFailure() {
        failureCase_ = 0;
        failure_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason.QuotaFailure,
              com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason.QuotaFailure.Builder,
              com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason
                  .QuotaFailureOrBuilder>
          quotaFailureBuilder_;
      /**
       *
       *
       * <pre>
       * Failed due to insufficient quota.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.TargetSite.FailureReason.QuotaFailure quota_failure = 1;
       * </code>
       *
       * @return Whether the quotaFailure field is set.
       */
      @java.lang.Override
      public boolean hasQuotaFailure() {
        return failureCase_ == 1;
      }
      /**
       *
       *
       * <pre>
       * Failed due to insufficient quota.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.TargetSite.FailureReason.QuotaFailure quota_failure = 1;
       * </code>
       *
       * @return The quotaFailure.
       */
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason.QuotaFailure
          getQuotaFailure() {
        if (quotaFailureBuilder_ == null) {
          if (failureCase_ == 1) {
            return (com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason.QuotaFailure)
                failure_;
          }
          return com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason.QuotaFailure
              .getDefaultInstance();
        } else {
          if (failureCase_ == 1) {
            return quotaFailureBuilder_.getMessage();
          }
          return com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason.QuotaFailure
              .getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Failed due to insufficient quota.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.TargetSite.FailureReason.QuotaFailure quota_failure = 1;
       * </code>
       */
      public Builder setQuotaFailure(
          com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason.QuotaFailure value) {
        if (quotaFailureBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          failure_ = value;
          onChanged();
        } else {
          quotaFailureBuilder_.setMessage(value);
        }
        failureCase_ = 1;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Failed due to insufficient quota.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.TargetSite.FailureReason.QuotaFailure quota_failure = 1;
       * </code>
       */
      public Builder setQuotaFailure(
          com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason.QuotaFailure.Builder
              builderForValue) {
        if (quotaFailureBuilder_ == null) {
          failure_ = builderForValue.build();
          onChanged();
        } else {
          quotaFailureBuilder_.setMessage(builderForValue.build());
        }
        failureCase_ = 1;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Failed due to insufficient quota.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.TargetSite.FailureReason.QuotaFailure quota_failure = 1;
       * </code>
       */
      public Builder mergeQuotaFailure(
          com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason.QuotaFailure value) {
        if (quotaFailureBuilder_ == null) {
          if (failureCase_ == 1
              && failure_
                  != com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason.QuotaFailure
                      .getDefaultInstance()) {
            failure_ =
                com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason.QuotaFailure
                    .newBuilder(
                        (com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason
                                .QuotaFailure)
                            failure_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            failure_ = value;
          }
          onChanged();
        } else {
          if (failureCase_ == 1) {
            quotaFailureBuilder_.mergeFrom(value);
          } else {
            quotaFailureBuilder_.setMessage(value);
          }
        }
        failureCase_ = 1;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Failed due to insufficient quota.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.TargetSite.FailureReason.QuotaFailure quota_failure = 1;
       * </code>
       */
      public Builder clearQuotaFailure() {
        if (quotaFailureBuilder_ == null) {
          if (failureCase_ == 1) {
            failureCase_ = 0;
            failure_ = null;
            onChanged();
          }
        } else {
          if (failureCase_ == 1) {
            failureCase_ = 0;
            failure_ = null;
          }
          quotaFailureBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Failed due to insufficient quota.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.TargetSite.FailureReason.QuotaFailure quota_failure = 1;
       * </code>
       */
      public com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason.QuotaFailure.Builder
          getQuotaFailureBuilder() {
        return getQuotaFailureFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Failed due to insufficient quota.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.TargetSite.FailureReason.QuotaFailure quota_failure = 1;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason.QuotaFailureOrBuilder
          getQuotaFailureOrBuilder() {
        if ((failureCase_ == 1) && (quotaFailureBuilder_ != null)) {
          return quotaFailureBuilder_.getMessageOrBuilder();
        } else {
          if (failureCase_ == 1) {
            return (com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason.QuotaFailure)
                failure_;
          }
          return com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason.QuotaFailure
              .getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Failed due to insufficient quota.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.TargetSite.FailureReason.QuotaFailure quota_failure = 1;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason.QuotaFailure,
              com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason.QuotaFailure.Builder,
              com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason
                  .QuotaFailureOrBuilder>
          getQuotaFailureFieldBuilder() {
        if (quotaFailureBuilder_ == null) {
          if (!(failureCase_ == 1)) {
            failure_ =
                com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason.QuotaFailure
                    .getDefaultInstance();
          }
          quotaFailureBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason.QuotaFailure,
                  com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason.QuotaFailure
                      .Builder,
                  com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason
                      .QuotaFailureOrBuilder>(
                  (com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason.QuotaFailure)
                      failure_,
                  getParentForChildren(),
                  isClean());
          failure_ = null;
        }
        failureCase_ = 1;
        onChanged();
        return quotaFailureBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.TargetSite.FailureReason)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.TargetSite.FailureReason)
    private static final com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason();
    }

    public static com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<FailureReason> PARSER =
        new com.google.protobuf.AbstractParser<FailureReason>() {
          @java.lang.Override
          public FailureReason parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<FailureReason> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<FailureReason> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The fully qualified resource name of the target site.
   * `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/siteSearchEngine/targetSites/{target_site}`
   * The `target_site_id` is system-generated.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The fully qualified resource name of the target site.
   * `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/siteSearchEngine/targetSites/{target_site}`
   * The `target_site_id` is system-generated.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PROVIDED_URI_PATTERN_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object providedUriPattern_ = "";
  /**
   *
   *
   * <pre>
   * Required. Input only. The user provided URI pattern from which the
   * `generated_uri_pattern` is generated.
   * </pre>
   *
   * <code>
   * string provided_uri_pattern = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = INPUT_ONLY];
   * </code>
   *
   * @return The providedUriPattern.
   */
  @java.lang.Override
  public java.lang.String getProvidedUriPattern() {
    java.lang.Object ref = providedUriPattern_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      providedUriPattern_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Input only. The user provided URI pattern from which the
   * `generated_uri_pattern` is generated.
   * </pre>
   *
   * <code>
   * string provided_uri_pattern = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = INPUT_ONLY];
   * </code>
   *
   * @return The bytes for providedUriPattern.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getProvidedUriPatternBytes() {
    java.lang.Object ref = providedUriPattern_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      providedUriPattern_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TYPE_FIELD_NUMBER = 3;
  private int type_ = 0;
  /**
   *
   *
   * <pre>
   * The type of the target site, e.g., whether the site is to be included or
   * excluded.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.TargetSite.Type type = 3;</code>
   *
   * @return The enum numeric value on the wire for type.
   */
  @java.lang.Override
  public int getTypeValue() {
    return type_;
  }
  /**
   *
   *
   * <pre>
   * The type of the target site, e.g., whether the site is to be included or
   * excluded.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.TargetSite.Type type = 3;</code>
   *
   * @return The type.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.TargetSite.Type getType() {
    com.google.cloud.discoveryengine.v1beta.TargetSite.Type result =
        com.google.cloud.discoveryengine.v1beta.TargetSite.Type.forNumber(type_);
    return result == null
        ? com.google.cloud.discoveryengine.v1beta.TargetSite.Type.UNRECOGNIZED
        : result;
  }

  public static final int EXACT_MATCH_FIELD_NUMBER = 6;
  private boolean exactMatch_ = false;
  /**
   *
   *
   * <pre>
   * Input only. If set to false, a uri_pattern is generated to include all
   * pages whose address contains the provided_uri_pattern. If set to true, an
   * uri_pattern is generated to try to be an exact match of the
   * provided_uri_pattern or just the specific page if the provided_uri_pattern
   * is a specific one. provided_uri_pattern is always normalized to
   * generate the URI pattern to be used by the search engine.
   * </pre>
   *
   * <code>bool exact_match = 6 [(.google.api.field_behavior) = INPUT_ONLY];</code>
   *
   * @return The exactMatch.
   */
  @java.lang.Override
  public boolean getExactMatch() {
    return exactMatch_;
  }

  public static final int GENERATED_URI_PATTERN_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object generatedUriPattern_ = "";
  /**
   *
   *
   * <pre>
   * Output only. This is system-generated based on the provided_uri_pattern.
   * </pre>
   *
   * <code>string generated_uri_pattern = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The generatedUriPattern.
   */
  @java.lang.Override
  public java.lang.String getGeneratedUriPattern() {
    java.lang.Object ref = generatedUriPattern_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      generatedUriPattern_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. This is system-generated based on the provided_uri_pattern.
   * </pre>
   *
   * <code>string generated_uri_pattern = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for generatedUriPattern.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getGeneratedUriPatternBytes() {
    java.lang.Object ref = generatedUriPattern_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      generatedUriPattern_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ROOT_DOMAIN_URI_FIELD_NUMBER = 10;

  @SuppressWarnings("serial")
  private volatile java.lang.Object rootDomainUri_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Root domain of the provided_uri_pattern.
   * </pre>
   *
   * <code>string root_domain_uri = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The rootDomainUri.
   */
  @java.lang.Override
  public java.lang.String getRootDomainUri() {
    java.lang.Object ref = rootDomainUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      rootDomainUri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Root domain of the provided_uri_pattern.
   * </pre>
   *
   * <code>string root_domain_uri = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for rootDomainUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRootDomainUriBytes() {
    java.lang.Object ref = rootDomainUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      rootDomainUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SITE_VERIFICATION_INFO_FIELD_NUMBER = 7;
  private com.google.cloud.discoveryengine.v1beta.SiteVerificationInfo siteVerificationInfo_;
  /**
   *
   *
   * <pre>
   * Output only. Site ownership and validity verification status.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1beta.SiteVerificationInfo site_verification_info = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the siteVerificationInfo field is set.
   */
  @java.lang.Override
  public boolean hasSiteVerificationInfo() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Site ownership and validity verification status.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1beta.SiteVerificationInfo site_verification_info = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The siteVerificationInfo.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.SiteVerificationInfo getSiteVerificationInfo() {
    return siteVerificationInfo_ == null
        ? com.google.cloud.discoveryengine.v1beta.SiteVerificationInfo.getDefaultInstance()
        : siteVerificationInfo_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Site ownership and validity verification status.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1beta.SiteVerificationInfo site_verification_info = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.SiteVerificationInfoOrBuilder
      getSiteVerificationInfoOrBuilder() {
    return siteVerificationInfo_ == null
        ? com.google.cloud.discoveryengine.v1beta.SiteVerificationInfo.getDefaultInstance()
        : siteVerificationInfo_;
  }

  public static final int INDEXING_STATUS_FIELD_NUMBER = 8;
  private int indexingStatus_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. Indexing status.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1beta.TargetSite.IndexingStatus indexing_status = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for indexingStatus.
   */
  @java.lang.Override
  public int getIndexingStatusValue() {
    return indexingStatus_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Indexing status.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1beta.TargetSite.IndexingStatus indexing_status = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The indexingStatus.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.TargetSite.IndexingStatus getIndexingStatus() {
    com.google.cloud.discoveryengine.v1beta.TargetSite.IndexingStatus result =
        com.google.cloud.discoveryengine.v1beta.TargetSite.IndexingStatus.forNumber(
            indexingStatus_);
    return result == null
        ? com.google.cloud.discoveryengine.v1beta.TargetSite.IndexingStatus.UNRECOGNIZED
        : result;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 5;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. The target site's last updated time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The target site's last updated time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The target site's last updated time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int FAILURE_REASON_FIELD_NUMBER = 9;
  private com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason failureReason_;
  /**
   *
   *
   * <pre>
   * Output only. Failure reason.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1beta.TargetSite.FailureReason failure_reason = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the failureReason field is set.
   */
  @java.lang.Override
  public boolean hasFailureReason() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Failure reason.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1beta.TargetSite.FailureReason failure_reason = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The failureReason.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason getFailureReason() {
    return failureReason_ == null
        ? com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason.getDefaultInstance()
        : failureReason_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Failure reason.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1beta.TargetSite.FailureReason failure_reason = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReasonOrBuilder
      getFailureReasonOrBuilder() {
    return failureReason_ == null
        ? com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason.getDefaultInstance()
        : failureReason_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(providedUriPattern_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, providedUriPattern_);
    }
    if (type_
        != com.google.cloud.discoveryengine.v1beta.TargetSite.Type.TYPE_UNSPECIFIED.getNumber()) {
      output.writeEnum(3, type_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(generatedUriPattern_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, generatedUriPattern_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(5, getUpdateTime());
    }
    if (exactMatch_ != false) {
      output.writeBool(6, exactMatch_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(7, getSiteVerificationInfo());
    }
    if (indexingStatus_
        != com.google.cloud.discoveryengine.v1beta.TargetSite.IndexingStatus
            .INDEXING_STATUS_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(8, indexingStatus_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(9, getFailureReason());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(rootDomainUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 10, rootDomainUri_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(providedUriPattern_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, providedUriPattern_);
    }
    if (type_
        != com.google.cloud.discoveryengine.v1beta.TargetSite.Type.TYPE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, type_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(generatedUriPattern_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, generatedUriPattern_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getUpdateTime());
    }
    if (exactMatch_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(6, exactMatch_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(7, getSiteVerificationInfo());
    }
    if (indexingStatus_
        != com.google.cloud.discoveryengine.v1beta.TargetSite.IndexingStatus
            .INDEXING_STATUS_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(8, indexingStatus_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getFailureReason());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(rootDomainUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(10, rootDomainUri_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.discoveryengine.v1beta.TargetSite)) {
      return super.equals(obj);
    }
    com.google.cloud.discoveryengine.v1beta.TargetSite other =
        (com.google.cloud.discoveryengine.v1beta.TargetSite) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getProvidedUriPattern().equals(other.getProvidedUriPattern())) return false;
    if (type_ != other.type_) return false;
    if (getExactMatch() != other.getExactMatch()) return false;
    if (!getGeneratedUriPattern().equals(other.getGeneratedUriPattern())) return false;
    if (!getRootDomainUri().equals(other.getRootDomainUri())) return false;
    if (hasSiteVerificationInfo() != other.hasSiteVerificationInfo()) return false;
    if (hasSiteVerificationInfo()) {
      if (!getSiteVerificationInfo().equals(other.getSiteVerificationInfo())) return false;
    }
    if (indexingStatus_ != other.indexingStatus_) return false;
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (hasFailureReason() != other.hasFailureReason()) return false;
    if (hasFailureReason()) {
      if (!getFailureReason().equals(other.getFailureReason())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + PROVIDED_URI_PATTERN_FIELD_NUMBER;
    hash = (53 * hash) + getProvidedUriPattern().hashCode();
    hash = (37 * hash) + TYPE_FIELD_NUMBER;
    hash = (53 * hash) + type_;
    hash = (37 * hash) + EXACT_MATCH_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getExactMatch());
    hash = (37 * hash) + GENERATED_URI_PATTERN_FIELD_NUMBER;
    hash = (53 * hash) + getGeneratedUriPattern().hashCode();
    hash = (37 * hash) + ROOT_DOMAIN_URI_FIELD_NUMBER;
    hash = (53 * hash) + getRootDomainUri().hashCode();
    if (hasSiteVerificationInfo()) {
      hash = (37 * hash) + SITE_VERIFICATION_INFO_FIELD_NUMBER;
      hash = (53 * hash) + getSiteVerificationInfo().hashCode();
    }
    hash = (37 * hash) + INDEXING_STATUS_FIELD_NUMBER;
    hash = (53 * hash) + indexingStatus_;
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    if (hasFailureReason()) {
      hash = (37 * hash) + FAILURE_REASON_FIELD_NUMBER;
      hash = (53 * hash) + getFailureReason().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.discoveryengine.v1beta.TargetSite parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1beta.TargetSite parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.TargetSite parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1beta.TargetSite parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.TargetSite parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1beta.TargetSite parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.TargetSite parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1beta.TargetSite parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.TargetSite parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1beta.TargetSite parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.TargetSite parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1beta.TargetSite parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.discoveryengine.v1beta.TargetSite prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A target site for the SiteSearchEngine.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1beta.TargetSite}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.TargetSite)
      com.google.cloud.discoveryengine.v1beta.TargetSiteOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1beta.SiteSearchEngineProto
          .internal_static_google_cloud_discoveryengine_v1beta_TargetSite_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1beta.SiteSearchEngineProto
          .internal_static_google_cloud_discoveryengine_v1beta_TargetSite_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1beta.TargetSite.class,
              com.google.cloud.discoveryengine.v1beta.TargetSite.Builder.class);
    }

    // Construct using com.google.cloud.discoveryengine.v1beta.TargetSite.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getSiteVerificationInfoFieldBuilder();
        getUpdateTimeFieldBuilder();
        getFailureReasonFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      providedUriPattern_ = "";
      type_ = 0;
      exactMatch_ = false;
      generatedUriPattern_ = "";
      rootDomainUri_ = "";
      siteVerificationInfo_ = null;
      if (siteVerificationInfoBuilder_ != null) {
        siteVerificationInfoBuilder_.dispose();
        siteVerificationInfoBuilder_ = null;
      }
      indexingStatus_ = 0;
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      failureReason_ = null;
      if (failureReasonBuilder_ != null) {
        failureReasonBuilder_.dispose();
        failureReasonBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.discoveryengine.v1beta.SiteSearchEngineProto
          .internal_static_google_cloud_discoveryengine_v1beta_TargetSite_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.TargetSite getDefaultInstanceForType() {
      return com.google.cloud.discoveryengine.v1beta.TargetSite.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.TargetSite build() {
      com.google.cloud.discoveryengine.v1beta.TargetSite result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.TargetSite buildPartial() {
      com.google.cloud.discoveryengine.v1beta.TargetSite result =
          new com.google.cloud.discoveryengine.v1beta.TargetSite(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.discoveryengine.v1beta.TargetSite result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.providedUriPattern_ = providedUriPattern_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.type_ = type_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.exactMatch_ = exactMatch_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.generatedUriPattern_ = generatedUriPattern_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.rootDomainUri_ = rootDomainUri_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.siteVerificationInfo_ =
            siteVerificationInfoBuilder_ == null
                ? siteVerificationInfo_
                : siteVerificationInfoBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.indexingStatus_ = indexingStatus_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.failureReason_ =
            failureReasonBuilder_ == null ? failureReason_ : failureReasonBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.discoveryengine.v1beta.TargetSite) {
        return mergeFrom((com.google.cloud.discoveryengine.v1beta.TargetSite) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.discoveryengine.v1beta.TargetSite other) {
      if (other == com.google.cloud.discoveryengine.v1beta.TargetSite.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getProvidedUriPattern().isEmpty()) {
        providedUriPattern_ = other.providedUriPattern_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.type_ != 0) {
        setTypeValue(other.getTypeValue());
      }
      if (other.getExactMatch() != false) {
        setExactMatch(other.getExactMatch());
      }
      if (!other.getGeneratedUriPattern().isEmpty()) {
        generatedUriPattern_ = other.generatedUriPattern_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (!other.getRootDomainUri().isEmpty()) {
        rootDomainUri_ = other.rootDomainUri_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (other.hasSiteVerificationInfo()) {
        mergeSiteVerificationInfo(other.getSiteVerificationInfo());
      }
      if (other.indexingStatus_ != 0) {
        setIndexingStatusValue(other.getIndexingStatusValue());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      if (other.hasFailureReason()) {
        mergeFailureReason(other.getFailureReason());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                providedUriPattern_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 24:
              {
                type_ = input.readEnum();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 34:
              {
                generatedUriPattern_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 42
            case 48:
              {
                exactMatch_ = input.readBool();
                bitField0_ |= 0x00000008;
                break;
              } // case 48
            case 58:
              {
                input.readMessage(
                    getSiteVerificationInfoFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            case 64:
              {
                indexingStatus_ = input.readEnum();
                bitField0_ |= 0x00000080;
                break;
              } // case 64
            case 74:
              {
                input.readMessage(getFailureReasonFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000200;
                break;
              } // case 74
            case 82:
              {
                rootDomainUri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 82
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The fully qualified resource name of the target site.
     * `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/siteSearchEngine/targetSites/{target_site}`
     * The `target_site_id` is system-generated.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The fully qualified resource name of the target site.
     * `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/siteSearchEngine/targetSites/{target_site}`
     * The `target_site_id` is system-generated.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The fully qualified resource name of the target site.
     * `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/siteSearchEngine/targetSites/{target_site}`
     * The `target_site_id` is system-generated.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The fully qualified resource name of the target site.
     * `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/siteSearchEngine/targetSites/{target_site}`
     * The `target_site_id` is system-generated.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The fully qualified resource name of the target site.
     * `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/siteSearchEngine/targetSites/{target_site}`
     * The `target_site_id` is system-generated.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object providedUriPattern_ = "";
    /**
     *
     *
     * <pre>
     * Required. Input only. The user provided URI pattern from which the
     * `generated_uri_pattern` is generated.
     * </pre>
     *
     * <code>
     * string provided_uri_pattern = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     *
     * @return The providedUriPattern.
     */
    public java.lang.String getProvidedUriPattern() {
      java.lang.Object ref = providedUriPattern_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        providedUriPattern_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Input only. The user provided URI pattern from which the
     * `generated_uri_pattern` is generated.
     * </pre>
     *
     * <code>
     * string provided_uri_pattern = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     *
     * @return The bytes for providedUriPattern.
     */
    public com.google.protobuf.ByteString getProvidedUriPatternBytes() {
      java.lang.Object ref = providedUriPattern_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        providedUriPattern_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Input only. The user provided URI pattern from which the
     * `generated_uri_pattern` is generated.
     * </pre>
     *
     * <code>
     * string provided_uri_pattern = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     *
     * @param value The providedUriPattern to set.
     * @return This builder for chaining.
     */
    public Builder setProvidedUriPattern(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      providedUriPattern_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Input only. The user provided URI pattern from which the
     * `generated_uri_pattern` is generated.
     * </pre>
     *
     * <code>
     * string provided_uri_pattern = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProvidedUriPattern() {
      providedUriPattern_ = getDefaultInstance().getProvidedUriPattern();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Input only. The user provided URI pattern from which the
     * `generated_uri_pattern` is generated.
     * </pre>
     *
     * <code>
     * string provided_uri_pattern = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     *
     * @param value The bytes for providedUriPattern to set.
     * @return This builder for chaining.
     */
    public Builder setProvidedUriPatternBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      providedUriPattern_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private int type_ = 0;
    /**
     *
     *
     * <pre>
     * The type of the target site, e.g., whether the site is to be included or
     * excluded.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.TargetSite.Type type = 3;</code>
     *
     * @return The enum numeric value on the wire for type.
     */
    @java.lang.Override
    public int getTypeValue() {
      return type_;
    }
    /**
     *
     *
     * <pre>
     * The type of the target site, e.g., whether the site is to be included or
     * excluded.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.TargetSite.Type type = 3;</code>
     *
     * @param value The enum numeric value on the wire for type to set.
     * @return This builder for chaining.
     */
    public Builder setTypeValue(int value) {
      type_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The type of the target site, e.g., whether the site is to be included or
     * excluded.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.TargetSite.Type type = 3;</code>
     *
     * @return The type.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.TargetSite.Type getType() {
      com.google.cloud.discoveryengine.v1beta.TargetSite.Type result =
          com.google.cloud.discoveryengine.v1beta.TargetSite.Type.forNumber(type_);
      return result == null
          ? com.google.cloud.discoveryengine.v1beta.TargetSite.Type.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * The type of the target site, e.g., whether the site is to be included or
     * excluded.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.TargetSite.Type type = 3;</code>
     *
     * @param value The type to set.
     * @return This builder for chaining.
     */
    public Builder setType(com.google.cloud.discoveryengine.v1beta.TargetSite.Type value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000004;
      type_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The type of the target site, e.g., whether the site is to be included or
     * excluded.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.TargetSite.Type type = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearType() {
      bitField0_ = (bitField0_ & ~0x00000004);
      type_ = 0;
      onChanged();
      return this;
    }

    private boolean exactMatch_;
    /**
     *
     *
     * <pre>
     * Input only. If set to false, a uri_pattern is generated to include all
     * pages whose address contains the provided_uri_pattern. If set to true, an
     * uri_pattern is generated to try to be an exact match of the
     * provided_uri_pattern or just the specific page if the provided_uri_pattern
     * is a specific one. provided_uri_pattern is always normalized to
     * generate the URI pattern to be used by the search engine.
     * </pre>
     *
     * <code>bool exact_match = 6 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     *
     * @return The exactMatch.
     */
    @java.lang.Override
    public boolean getExactMatch() {
      return exactMatch_;
    }
    /**
     *
     *
     * <pre>
     * Input only. If set to false, a uri_pattern is generated to include all
     * pages whose address contains the provided_uri_pattern. If set to true, an
     * uri_pattern is generated to try to be an exact match of the
     * provided_uri_pattern or just the specific page if the provided_uri_pattern
     * is a specific one. provided_uri_pattern is always normalized to
     * generate the URI pattern to be used by the search engine.
     * </pre>
     *
     * <code>bool exact_match = 6 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     *
     * @param value The exactMatch to set.
     * @return This builder for chaining.
     */
    public Builder setExactMatch(boolean value) {

      exactMatch_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input only. If set to false, a uri_pattern is generated to include all
     * pages whose address contains the provided_uri_pattern. If set to true, an
     * uri_pattern is generated to try to be an exact match of the
     * provided_uri_pattern or just the specific page if the provided_uri_pattern
     * is a specific one. provided_uri_pattern is always normalized to
     * generate the URI pattern to be used by the search engine.
     * </pre>
     *
     * <code>bool exact_match = 6 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearExactMatch() {
      bitField0_ = (bitField0_ & ~0x00000008);
      exactMatch_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object generatedUriPattern_ = "";
    /**
     *
     *
     * <pre>
     * Output only. This is system-generated based on the provided_uri_pattern.
     * </pre>
     *
     * <code>string generated_uri_pattern = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The generatedUriPattern.
     */
    public java.lang.String getGeneratedUriPattern() {
      java.lang.Object ref = generatedUriPattern_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        generatedUriPattern_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. This is system-generated based on the provided_uri_pattern.
     * </pre>
     *
     * <code>string generated_uri_pattern = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for generatedUriPattern.
     */
    public com.google.protobuf.ByteString getGeneratedUriPatternBytes() {
      java.lang.Object ref = generatedUriPattern_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        generatedUriPattern_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. This is system-generated based on the provided_uri_pattern.
     * </pre>
     *
     * <code>string generated_uri_pattern = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The generatedUriPattern to set.
     * @return This builder for chaining.
     */
    public Builder setGeneratedUriPattern(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      generatedUriPattern_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. This is system-generated based on the provided_uri_pattern.
     * </pre>
     *
     * <code>string generated_uri_pattern = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearGeneratedUriPattern() {
      generatedUriPattern_ = getDefaultInstance().getGeneratedUriPattern();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. This is system-generated based on the provided_uri_pattern.
     * </pre>
     *
     * <code>string generated_uri_pattern = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for generatedUriPattern to set.
     * @return This builder for chaining.
     */
    public Builder setGeneratedUriPatternBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      generatedUriPattern_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.lang.Object rootDomainUri_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Root domain of the provided_uri_pattern.
     * </pre>
     *
     * <code>string root_domain_uri = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The rootDomainUri.
     */
    public java.lang.String getRootDomainUri() {
      java.lang.Object ref = rootDomainUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        rootDomainUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Root domain of the provided_uri_pattern.
     * </pre>
     *
     * <code>string root_domain_uri = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for rootDomainUri.
     */
    public com.google.protobuf.ByteString getRootDomainUriBytes() {
      java.lang.Object ref = rootDomainUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        rootDomainUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Root domain of the provided_uri_pattern.
     * </pre>
     *
     * <code>string root_domain_uri = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The rootDomainUri to set.
     * @return This builder for chaining.
     */
    public Builder setRootDomainUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      rootDomainUri_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Root domain of the provided_uri_pattern.
     * </pre>
     *
     * <code>string root_domain_uri = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRootDomainUri() {
      rootDomainUri_ = getDefaultInstance().getRootDomainUri();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Root domain of the provided_uri_pattern.
     * </pre>
     *
     * <code>string root_domain_uri = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for rootDomainUri to set.
     * @return This builder for chaining.
     */
    public Builder setRootDomainUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      rootDomainUri_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private com.google.cloud.discoveryengine.v1beta.SiteVerificationInfo siteVerificationInfo_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1beta.SiteVerificationInfo,
            com.google.cloud.discoveryengine.v1beta.SiteVerificationInfo.Builder,
            com.google.cloud.discoveryengine.v1beta.SiteVerificationInfoOrBuilder>
        siteVerificationInfoBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Site ownership and validity verification status.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.SiteVerificationInfo site_verification_info = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the siteVerificationInfo field is set.
     */
    public boolean hasSiteVerificationInfo() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Site ownership and validity verification status.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.SiteVerificationInfo site_verification_info = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The siteVerificationInfo.
     */
    public com.google.cloud.discoveryengine.v1beta.SiteVerificationInfo getSiteVerificationInfo() {
      if (siteVerificationInfoBuilder_ == null) {
        return siteVerificationInfo_ == null
            ? com.google.cloud.discoveryengine.v1beta.SiteVerificationInfo.getDefaultInstance()
            : siteVerificationInfo_;
      } else {
        return siteVerificationInfoBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Site ownership and validity verification status.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.SiteVerificationInfo site_verification_info = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setSiteVerificationInfo(
        com.google.cloud.discoveryengine.v1beta.SiteVerificationInfo value) {
      if (siteVerificationInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        siteVerificationInfo_ = value;
      } else {
        siteVerificationInfoBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Site ownership and validity verification status.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.SiteVerificationInfo site_verification_info = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setSiteVerificationInfo(
        com.google.cloud.discoveryengine.v1beta.SiteVerificationInfo.Builder builderForValue) {
      if (siteVerificationInfoBuilder_ == null) {
        siteVerificationInfo_ = builderForValue.build();
      } else {
        siteVerificationInfoBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Site ownership and validity verification status.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.SiteVerificationInfo site_verification_info = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeSiteVerificationInfo(
        com.google.cloud.discoveryengine.v1beta.SiteVerificationInfo value) {
      if (siteVerificationInfoBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && siteVerificationInfo_ != null
            && siteVerificationInfo_
                != com.google.cloud.discoveryengine.v1beta.SiteVerificationInfo
                    .getDefaultInstance()) {
          getSiteVerificationInfoBuilder().mergeFrom(value);
        } else {
          siteVerificationInfo_ = value;
        }
      } else {
        siteVerificationInfoBuilder_.mergeFrom(value);
      }
      if (siteVerificationInfo_ != null) {
        bitField0_ |= 0x00000040;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Site ownership and validity verification status.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.SiteVerificationInfo site_verification_info = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearSiteVerificationInfo() {
      bitField0_ = (bitField0_ & ~0x00000040);
      siteVerificationInfo_ = null;
      if (siteVerificationInfoBuilder_ != null) {
        siteVerificationInfoBuilder_.dispose();
        siteVerificationInfoBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Site ownership and validity verification status.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.SiteVerificationInfo site_verification_info = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.discoveryengine.v1beta.SiteVerificationInfo.Builder
        getSiteVerificationInfoBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getSiteVerificationInfoFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Site ownership and validity verification status.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.SiteVerificationInfo site_verification_info = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.discoveryengine.v1beta.SiteVerificationInfoOrBuilder
        getSiteVerificationInfoOrBuilder() {
      if (siteVerificationInfoBuilder_ != null) {
        return siteVerificationInfoBuilder_.getMessageOrBuilder();
      } else {
        return siteVerificationInfo_ == null
            ? com.google.cloud.discoveryengine.v1beta.SiteVerificationInfo.getDefaultInstance()
            : siteVerificationInfo_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Site ownership and validity verification status.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.SiteVerificationInfo site_verification_info = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1beta.SiteVerificationInfo,
            com.google.cloud.discoveryengine.v1beta.SiteVerificationInfo.Builder,
            com.google.cloud.discoveryengine.v1beta.SiteVerificationInfoOrBuilder>
        getSiteVerificationInfoFieldBuilder() {
      if (siteVerificationInfoBuilder_ == null) {
        siteVerificationInfoBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1beta.SiteVerificationInfo,
                com.google.cloud.discoveryengine.v1beta.SiteVerificationInfo.Builder,
                com.google.cloud.discoveryengine.v1beta.SiteVerificationInfoOrBuilder>(
                getSiteVerificationInfo(), getParentForChildren(), isClean());
        siteVerificationInfo_ = null;
      }
      return siteVerificationInfoBuilder_;
    }

    private int indexingStatus_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. Indexing status.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.TargetSite.IndexingStatus indexing_status = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for indexingStatus.
     */
    @java.lang.Override
    public int getIndexingStatusValue() {
      return indexingStatus_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Indexing status.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.TargetSite.IndexingStatus indexing_status = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for indexingStatus to set.
     * @return This builder for chaining.
     */
    public Builder setIndexingStatusValue(int value) {
      indexingStatus_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Indexing status.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.TargetSite.IndexingStatus indexing_status = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The indexingStatus.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.TargetSite.IndexingStatus getIndexingStatus() {
      com.google.cloud.discoveryengine.v1beta.TargetSite.IndexingStatus result =
          com.google.cloud.discoveryengine.v1beta.TargetSite.IndexingStatus.forNumber(
              indexingStatus_);
      return result == null
          ? com.google.cloud.discoveryengine.v1beta.TargetSite.IndexingStatus.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. Indexing status.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.TargetSite.IndexingStatus indexing_status = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The indexingStatus to set.
     * @return This builder for chaining.
     */
    public Builder setIndexingStatus(
        com.google.cloud.discoveryengine.v1beta.TargetSite.IndexingStatus value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000080;
      indexingStatus_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Indexing status.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.TargetSite.IndexingStatus indexing_status = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIndexingStatus() {
      bitField0_ = (bitField0_ & ~0x00000080);
      indexingStatus_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The target site's last updated time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The target site's last updated time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The target site's last updated time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The target site's last updated time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The target site's last updated time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      if (updateTime_ != null) {
        bitField0_ |= 0x00000100;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The target site's last updated time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000100);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The target site's last updated time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The target site's last updated time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The target site's last updated time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason failureReason_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason,
            com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason.Builder,
            com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReasonOrBuilder>
        failureReasonBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Failure reason.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.TargetSite.FailureReason failure_reason = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the failureReason field is set.
     */
    public boolean hasFailureReason() {
      return ((bitField0_ & 0x00000200) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Failure reason.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.TargetSite.FailureReason failure_reason = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The failureReason.
     */
    public com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason getFailureReason() {
      if (failureReasonBuilder_ == null) {
        return failureReason_ == null
            ? com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason.getDefaultInstance()
            : failureReason_;
      } else {
        return failureReasonBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Failure reason.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.TargetSite.FailureReason failure_reason = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setFailureReason(
        com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason value) {
      if (failureReasonBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        failureReason_ = value;
      } else {
        failureReasonBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Failure reason.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.TargetSite.FailureReason failure_reason = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setFailureReason(
        com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason.Builder builderForValue) {
      if (failureReasonBuilder_ == null) {
        failureReason_ = builderForValue.build();
      } else {
        failureReasonBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Failure reason.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.TargetSite.FailureReason failure_reason = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeFailureReason(
        com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason value) {
      if (failureReasonBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)
            && failureReason_ != null
            && failureReason_
                != com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason
                    .getDefaultInstance()) {
          getFailureReasonBuilder().mergeFrom(value);
        } else {
          failureReason_ = value;
        }
      } else {
        failureReasonBuilder_.mergeFrom(value);
      }
      if (failureReason_ != null) {
        bitField0_ |= 0x00000200;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Failure reason.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.TargetSite.FailureReason failure_reason = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearFailureReason() {
      bitField0_ = (bitField0_ & ~0x00000200);
      failureReason_ = null;
      if (failureReasonBuilder_ != null) {
        failureReasonBuilder_.dispose();
        failureReasonBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Failure reason.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.TargetSite.FailureReason failure_reason = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason.Builder
        getFailureReasonBuilder() {
      bitField0_ |= 0x00000200;
      onChanged();
      return getFailureReasonFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Failure reason.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.TargetSite.FailureReason failure_reason = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReasonOrBuilder
        getFailureReasonOrBuilder() {
      if (failureReasonBuilder_ != null) {
        return failureReasonBuilder_.getMessageOrBuilder();
      } else {
        return failureReason_ == null
            ? com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason.getDefaultInstance()
            : failureReason_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Failure reason.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.TargetSite.FailureReason failure_reason = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason,
            com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason.Builder,
            com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReasonOrBuilder>
        getFailureReasonFieldBuilder() {
      if (failureReasonBuilder_ == null) {
        failureReasonBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason,
                com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReason.Builder,
                com.google.cloud.discoveryengine.v1beta.TargetSite.FailureReasonOrBuilder>(
                getFailureReason(), getParentForChildren(), isClean());
        failureReason_ = null;
      }
      return failureReasonBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.TargetSite)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.TargetSite)
  private static final com.google.cloud.discoveryengine.v1beta.TargetSite DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.discoveryengine.v1beta.TargetSite();
  }

  public static com.google.cloud.discoveryengine.v1beta.TargetSite getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<TargetSite> PARSER =
      new com.google.protobuf.AbstractParser<TargetSite>() {
        @java.lang.Override
        public TargetSite parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<TargetSite> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<TargetSite> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.TargetSite getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
