/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/discoveryengine/v1beta/search_tuning_service.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.discoveryengine.v1beta;

/**
 *
 *
 * <pre>
 * Response of the
 * [TrainCustomModelRequest][google.cloud.discoveryengine.v1beta.TrainCustomModelRequest].
 * This message is returned by the google.longrunning.Operations.response field.
 * </pre>
 *
 * Protobuf type {@code google.cloud.discoveryengine.v1beta.TrainCustomModelResponse}
 */
public final class TrainCustomModelResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.TrainCustomModelResponse)
    TrainCustomModelResponseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use TrainCustomModelResponse.newBuilder() to construct.
  private TrainCustomModelResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private TrainCustomModelResponse() {
    errorSamples_ = java.util.Collections.emptyList();
    modelStatus_ = "";
    modelName_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new TrainCustomModelResponse();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.discoveryengine.v1beta.SearchTuningServiceProto
        .internal_static_google_cloud_discoveryengine_v1beta_TrainCustomModelResponse_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 4:
        return internalGetMetrics();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.discoveryengine.v1beta.SearchTuningServiceProto
        .internal_static_google_cloud_discoveryengine_v1beta_TrainCustomModelResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.discoveryengine.v1beta.TrainCustomModelResponse.class,
            com.google.cloud.discoveryengine.v1beta.TrainCustomModelResponse.Builder.class);
  }

  private int bitField0_;
  public static final int ERROR_SAMPLES_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<com.google.rpc.Status> errorSamples_;
  /**
   *
   *
   * <pre>
   * A sample of errors encountered while processing the data.
   * </pre>
   *
   * <code>repeated .google.rpc.Status error_samples = 1;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.rpc.Status> getErrorSamplesList() {
    return errorSamples_;
  }
  /**
   *
   *
   * <pre>
   * A sample of errors encountered while processing the data.
   * </pre>
   *
   * <code>repeated .google.rpc.Status error_samples = 1;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.rpc.StatusOrBuilder> getErrorSamplesOrBuilderList() {
    return errorSamples_;
  }
  /**
   *
   *
   * <pre>
   * A sample of errors encountered while processing the data.
   * </pre>
   *
   * <code>repeated .google.rpc.Status error_samples = 1;</code>
   */
  @java.lang.Override
  public int getErrorSamplesCount() {
    return errorSamples_.size();
  }
  /**
   *
   *
   * <pre>
   * A sample of errors encountered while processing the data.
   * </pre>
   *
   * <code>repeated .google.rpc.Status error_samples = 1;</code>
   */
  @java.lang.Override
  public com.google.rpc.Status getErrorSamples(int index) {
    return errorSamples_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A sample of errors encountered while processing the data.
   * </pre>
   *
   * <code>repeated .google.rpc.Status error_samples = 1;</code>
   */
  @java.lang.Override
  public com.google.rpc.StatusOrBuilder getErrorSamplesOrBuilder(int index) {
    return errorSamples_.get(index);
  }

  public static final int ERROR_CONFIG_FIELD_NUMBER = 2;
  private com.google.cloud.discoveryengine.v1beta.ImportErrorConfig errorConfig_;
  /**
   *
   *
   * <pre>
   * Echoes the destination for the complete errors in the request if set.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.ImportErrorConfig error_config = 2;</code>
   *
   * @return Whether the errorConfig field is set.
   */
  @java.lang.Override
  public boolean hasErrorConfig() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Echoes the destination for the complete errors in the request if set.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.ImportErrorConfig error_config = 2;</code>
   *
   * @return The errorConfig.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.ImportErrorConfig getErrorConfig() {
    return errorConfig_ == null
        ? com.google.cloud.discoveryengine.v1beta.ImportErrorConfig.getDefaultInstance()
        : errorConfig_;
  }
  /**
   *
   *
   * <pre>
   * Echoes the destination for the complete errors in the request if set.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.ImportErrorConfig error_config = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.ImportErrorConfigOrBuilder
      getErrorConfigOrBuilder() {
    return errorConfig_ == null
        ? com.google.cloud.discoveryengine.v1beta.ImportErrorConfig.getDefaultInstance()
        : errorConfig_;
  }

  public static final int MODEL_STATUS_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object modelStatus_ = "";
  /**
   *
   *
   * <pre>
   * The trained model status. Possible values are:
   *
   *  * **bad-data**: The training data quality is bad.
   *  * **no-improvement**: Tuning didn't improve performance. Won't deploy.
   *  * **in-progress**: Model training job creation is in progress.
   *  * **training**: Model is actively training.
   *  * **evaluating**: The model is evaluating trained metrics.
   *  * **indexing**: The model trained metrics are indexing.
   *  * **ready**: The model is ready for serving.
   * </pre>
   *
   * <code>string model_status = 3;</code>
   *
   * @return The modelStatus.
   */
  @java.lang.Override
  public java.lang.String getModelStatus() {
    java.lang.Object ref = modelStatus_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      modelStatus_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The trained model status. Possible values are:
   *
   *  * **bad-data**: The training data quality is bad.
   *  * **no-improvement**: Tuning didn't improve performance. Won't deploy.
   *  * **in-progress**: Model training job creation is in progress.
   *  * **training**: Model is actively training.
   *  * **evaluating**: The model is evaluating trained metrics.
   *  * **indexing**: The model trained metrics are indexing.
   *  * **ready**: The model is ready for serving.
   * </pre>
   *
   * <code>string model_status = 3;</code>
   *
   * @return The bytes for modelStatus.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getModelStatusBytes() {
    java.lang.Object ref = modelStatus_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      modelStatus_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int METRICS_FIELD_NUMBER = 4;

  private static final class MetricsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.Double> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.Double>newDefaultInstance(
            com.google.cloud.discoveryengine.v1beta.SearchTuningServiceProto
                .internal_static_google_cloud_discoveryengine_v1beta_TrainCustomModelResponse_MetricsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.DOUBLE,
            0D);
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.Double> metrics_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.Double> internalGetMetrics() {
    if (metrics_ == null) {
      return com.google.protobuf.MapField.emptyMapField(MetricsDefaultEntryHolder.defaultEntry);
    }
    return metrics_;
  }

  public int getMetricsCount() {
    return internalGetMetrics().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * The metrics of the trained model.
   * </pre>
   *
   * <code>map&lt;string, double&gt; metrics = 4;</code>
   */
  @java.lang.Override
  public boolean containsMetrics(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetMetrics().getMap().containsKey(key);
  }
  /** Use {@link #getMetricsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.Double> getMetrics() {
    return getMetricsMap();
  }
  /**
   *
   *
   * <pre>
   * The metrics of the trained model.
   * </pre>
   *
   * <code>map&lt;string, double&gt; metrics = 4;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.Double> getMetricsMap() {
    return internalGetMetrics().getMap();
  }
  /**
   *
   *
   * <pre>
   * The metrics of the trained model.
   * </pre>
   *
   * <code>map&lt;string, double&gt; metrics = 4;</code>
   */
  @java.lang.Override
  public double getMetricsOrDefault(java.lang.String key, double defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.Double> map = internalGetMetrics().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * The metrics of the trained model.
   * </pre>
   *
   * <code>map&lt;string, double&gt; metrics = 4;</code>
   */
  @java.lang.Override
  public double getMetricsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.Double> map = internalGetMetrics().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int MODEL_NAME_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object modelName_ = "";
  /**
   *
   *
   * <pre>
   * Fully qualified name of the CustomTuningModel.
   * </pre>
   *
   * <code>string model_name = 5;</code>
   *
   * @return The modelName.
   */
  @java.lang.Override
  public java.lang.String getModelName() {
    java.lang.Object ref = modelName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      modelName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Fully qualified name of the CustomTuningModel.
   * </pre>
   *
   * <code>string model_name = 5;</code>
   *
   * @return The bytes for modelName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getModelNameBytes() {
    java.lang.Object ref = modelName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      modelName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < errorSamples_.size(); i++) {
      output.writeMessage(1, errorSamples_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(2, getErrorConfig());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(modelStatus_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, modelStatus_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetMetrics(), MetricsDefaultEntryHolder.defaultEntry, 4);
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(modelName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, modelName_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < errorSamples_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, errorSamples_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getErrorConfig());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(modelStatus_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, modelStatus_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.Double> entry :
        internalGetMetrics().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.Double> metrics__ =
          MetricsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, metrics__);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(modelName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, modelName_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.discoveryengine.v1beta.TrainCustomModelResponse)) {
      return super.equals(obj);
    }
    com.google.cloud.discoveryengine.v1beta.TrainCustomModelResponse other =
        (com.google.cloud.discoveryengine.v1beta.TrainCustomModelResponse) obj;

    if (!getErrorSamplesList().equals(other.getErrorSamplesList())) return false;
    if (hasErrorConfig() != other.hasErrorConfig()) return false;
    if (hasErrorConfig()) {
      if (!getErrorConfig().equals(other.getErrorConfig())) return false;
    }
    if (!getModelStatus().equals(other.getModelStatus())) return false;
    if (!internalGetMetrics().equals(other.internalGetMetrics())) return false;
    if (!getModelName().equals(other.getModelName())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getErrorSamplesCount() > 0) {
      hash = (37 * hash) + ERROR_SAMPLES_FIELD_NUMBER;
      hash = (53 * hash) + getErrorSamplesList().hashCode();
    }
    if (hasErrorConfig()) {
      hash = (37 * hash) + ERROR_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getErrorConfig().hashCode();
    }
    hash = (37 * hash) + MODEL_STATUS_FIELD_NUMBER;
    hash = (53 * hash) + getModelStatus().hashCode();
    if (!internalGetMetrics().getMap().isEmpty()) {
      hash = (37 * hash) + METRICS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetMetrics().hashCode();
    }
    hash = (37 * hash) + MODEL_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getModelName().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.discoveryengine.v1beta.TrainCustomModelResponse parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1beta.TrainCustomModelResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.TrainCustomModelResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1beta.TrainCustomModelResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.TrainCustomModelResponse parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1beta.TrainCustomModelResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.TrainCustomModelResponse parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1beta.TrainCustomModelResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.TrainCustomModelResponse parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1beta.TrainCustomModelResponse parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.TrainCustomModelResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1beta.TrainCustomModelResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.discoveryengine.v1beta.TrainCustomModelResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Response of the
   * [TrainCustomModelRequest][google.cloud.discoveryengine.v1beta.TrainCustomModelRequest].
   * This message is returned by the google.longrunning.Operations.response field.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1beta.TrainCustomModelResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.TrainCustomModelResponse)
      com.google.cloud.discoveryengine.v1beta.TrainCustomModelResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1beta.SearchTuningServiceProto
          .internal_static_google_cloud_discoveryengine_v1beta_TrainCustomModelResponse_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 4:
          return internalGetMetrics();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 4:
          return internalGetMutableMetrics();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1beta.SearchTuningServiceProto
          .internal_static_google_cloud_discoveryengine_v1beta_TrainCustomModelResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1beta.TrainCustomModelResponse.class,
              com.google.cloud.discoveryengine.v1beta.TrainCustomModelResponse.Builder.class);
    }

    // Construct using com.google.cloud.discoveryengine.v1beta.TrainCustomModelResponse.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getErrorSamplesFieldBuilder();
        getErrorConfigFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (errorSamplesBuilder_ == null) {
        errorSamples_ = java.util.Collections.emptyList();
      } else {
        errorSamples_ = null;
        errorSamplesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      errorConfig_ = null;
      if (errorConfigBuilder_ != null) {
        errorConfigBuilder_.dispose();
        errorConfigBuilder_ = null;
      }
      modelStatus_ = "";
      internalGetMutableMetrics().clear();
      modelName_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.discoveryengine.v1beta.SearchTuningServiceProto
          .internal_static_google_cloud_discoveryengine_v1beta_TrainCustomModelResponse_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.TrainCustomModelResponse
        getDefaultInstanceForType() {
      return com.google.cloud.discoveryengine.v1beta.TrainCustomModelResponse.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.TrainCustomModelResponse build() {
      com.google.cloud.discoveryengine.v1beta.TrainCustomModelResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.TrainCustomModelResponse buildPartial() {
      com.google.cloud.discoveryengine.v1beta.TrainCustomModelResponse result =
          new com.google.cloud.discoveryengine.v1beta.TrainCustomModelResponse(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.discoveryengine.v1beta.TrainCustomModelResponse result) {
      if (errorSamplesBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          errorSamples_ = java.util.Collections.unmodifiableList(errorSamples_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.errorSamples_ = errorSamples_;
      } else {
        result.errorSamples_ = errorSamplesBuilder_.build();
      }
    }

    private void buildPartial0(
        com.google.cloud.discoveryengine.v1beta.TrainCustomModelResponse result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.errorConfig_ =
            errorConfigBuilder_ == null ? errorConfig_ : errorConfigBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.modelStatus_ = modelStatus_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.metrics_ = internalGetMetrics();
        result.metrics_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.modelName_ = modelName_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.discoveryengine.v1beta.TrainCustomModelResponse) {
        return mergeFrom((com.google.cloud.discoveryengine.v1beta.TrainCustomModelResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.discoveryengine.v1beta.TrainCustomModelResponse other) {
      if (other
          == com.google.cloud.discoveryengine.v1beta.TrainCustomModelResponse.getDefaultInstance())
        return this;
      if (errorSamplesBuilder_ == null) {
        if (!other.errorSamples_.isEmpty()) {
          if (errorSamples_.isEmpty()) {
            errorSamples_ = other.errorSamples_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureErrorSamplesIsMutable();
            errorSamples_.addAll(other.errorSamples_);
          }
          onChanged();
        }
      } else {
        if (!other.errorSamples_.isEmpty()) {
          if (errorSamplesBuilder_.isEmpty()) {
            errorSamplesBuilder_.dispose();
            errorSamplesBuilder_ = null;
            errorSamples_ = other.errorSamples_;
            bitField0_ = (bitField0_ & ~0x00000001);
            errorSamplesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getErrorSamplesFieldBuilder()
                    : null;
          } else {
            errorSamplesBuilder_.addAllMessages(other.errorSamples_);
          }
        }
      }
      if (other.hasErrorConfig()) {
        mergeErrorConfig(other.getErrorConfig());
      }
      if (!other.getModelStatus().isEmpty()) {
        modelStatus_ = other.modelStatus_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      internalGetMutableMetrics().mergeFrom(other.internalGetMetrics());
      bitField0_ |= 0x00000008;
      if (!other.getModelName().isEmpty()) {
        modelName_ = other.modelName_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.rpc.Status m =
                    input.readMessage(com.google.rpc.Status.parser(), extensionRegistry);
                if (errorSamplesBuilder_ == null) {
                  ensureErrorSamplesIsMutable();
                  errorSamples_.add(m);
                } else {
                  errorSamplesBuilder_.addMessage(m);
                }
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getErrorConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                modelStatus_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.Double> metrics__ =
                    input.readMessage(
                        MetricsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableMetrics()
                    .getMutableMap()
                    .put(metrics__.getKey(), metrics__.getValue());
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                modelName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.rpc.Status> errorSamples_ = java.util.Collections.emptyList();

    private void ensureErrorSamplesIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        errorSamples_ = new java.util.ArrayList<com.google.rpc.Status>(errorSamples_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        errorSamplesBuilder_;

    /**
     *
     *
     * <pre>
     * A sample of errors encountered while processing the data.
     * </pre>
     *
     * <code>repeated .google.rpc.Status error_samples = 1;</code>
     */
    public java.util.List<com.google.rpc.Status> getErrorSamplesList() {
      if (errorSamplesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(errorSamples_);
      } else {
        return errorSamplesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * A sample of errors encountered while processing the data.
     * </pre>
     *
     * <code>repeated .google.rpc.Status error_samples = 1;</code>
     */
    public int getErrorSamplesCount() {
      if (errorSamplesBuilder_ == null) {
        return errorSamples_.size();
      } else {
        return errorSamplesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * A sample of errors encountered while processing the data.
     * </pre>
     *
     * <code>repeated .google.rpc.Status error_samples = 1;</code>
     */
    public com.google.rpc.Status getErrorSamples(int index) {
      if (errorSamplesBuilder_ == null) {
        return errorSamples_.get(index);
      } else {
        return errorSamplesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A sample of errors encountered while processing the data.
     * </pre>
     *
     * <code>repeated .google.rpc.Status error_samples = 1;</code>
     */
    public Builder setErrorSamples(int index, com.google.rpc.Status value) {
      if (errorSamplesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureErrorSamplesIsMutable();
        errorSamples_.set(index, value);
        onChanged();
      } else {
        errorSamplesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A sample of errors encountered while processing the data.
     * </pre>
     *
     * <code>repeated .google.rpc.Status error_samples = 1;</code>
     */
    public Builder setErrorSamples(int index, com.google.rpc.Status.Builder builderForValue) {
      if (errorSamplesBuilder_ == null) {
        ensureErrorSamplesIsMutable();
        errorSamples_.set(index, builderForValue.build());
        onChanged();
      } else {
        errorSamplesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A sample of errors encountered while processing the data.
     * </pre>
     *
     * <code>repeated .google.rpc.Status error_samples = 1;</code>
     */
    public Builder addErrorSamples(com.google.rpc.Status value) {
      if (errorSamplesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureErrorSamplesIsMutable();
        errorSamples_.add(value);
        onChanged();
      } else {
        errorSamplesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A sample of errors encountered while processing the data.
     * </pre>
     *
     * <code>repeated .google.rpc.Status error_samples = 1;</code>
     */
    public Builder addErrorSamples(int index, com.google.rpc.Status value) {
      if (errorSamplesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureErrorSamplesIsMutable();
        errorSamples_.add(index, value);
        onChanged();
      } else {
        errorSamplesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A sample of errors encountered while processing the data.
     * </pre>
     *
     * <code>repeated .google.rpc.Status error_samples = 1;</code>
     */
    public Builder addErrorSamples(com.google.rpc.Status.Builder builderForValue) {
      if (errorSamplesBuilder_ == null) {
        ensureErrorSamplesIsMutable();
        errorSamples_.add(builderForValue.build());
        onChanged();
      } else {
        errorSamplesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A sample of errors encountered while processing the data.
     * </pre>
     *
     * <code>repeated .google.rpc.Status error_samples = 1;</code>
     */
    public Builder addErrorSamples(int index, com.google.rpc.Status.Builder builderForValue) {
      if (errorSamplesBuilder_ == null) {
        ensureErrorSamplesIsMutable();
        errorSamples_.add(index, builderForValue.build());
        onChanged();
      } else {
        errorSamplesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A sample of errors encountered while processing the data.
     * </pre>
     *
     * <code>repeated .google.rpc.Status error_samples = 1;</code>
     */
    public Builder addAllErrorSamples(java.lang.Iterable<? extends com.google.rpc.Status> values) {
      if (errorSamplesBuilder_ == null) {
        ensureErrorSamplesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, errorSamples_);
        onChanged();
      } else {
        errorSamplesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A sample of errors encountered while processing the data.
     * </pre>
     *
     * <code>repeated .google.rpc.Status error_samples = 1;</code>
     */
    public Builder clearErrorSamples() {
      if (errorSamplesBuilder_ == null) {
        errorSamples_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        errorSamplesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A sample of errors encountered while processing the data.
     * </pre>
     *
     * <code>repeated .google.rpc.Status error_samples = 1;</code>
     */
    public Builder removeErrorSamples(int index) {
      if (errorSamplesBuilder_ == null) {
        ensureErrorSamplesIsMutable();
        errorSamples_.remove(index);
        onChanged();
      } else {
        errorSamplesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A sample of errors encountered while processing the data.
     * </pre>
     *
     * <code>repeated .google.rpc.Status error_samples = 1;</code>
     */
    public com.google.rpc.Status.Builder getErrorSamplesBuilder(int index) {
      return getErrorSamplesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * A sample of errors encountered while processing the data.
     * </pre>
     *
     * <code>repeated .google.rpc.Status error_samples = 1;</code>
     */
    public com.google.rpc.StatusOrBuilder getErrorSamplesOrBuilder(int index) {
      if (errorSamplesBuilder_ == null) {
        return errorSamples_.get(index);
      } else {
        return errorSamplesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A sample of errors encountered while processing the data.
     * </pre>
     *
     * <code>repeated .google.rpc.Status error_samples = 1;</code>
     */
    public java.util.List<? extends com.google.rpc.StatusOrBuilder> getErrorSamplesOrBuilderList() {
      if (errorSamplesBuilder_ != null) {
        return errorSamplesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(errorSamples_);
      }
    }
    /**
     *
     *
     * <pre>
     * A sample of errors encountered while processing the data.
     * </pre>
     *
     * <code>repeated .google.rpc.Status error_samples = 1;</code>
     */
    public com.google.rpc.Status.Builder addErrorSamplesBuilder() {
      return getErrorSamplesFieldBuilder().addBuilder(com.google.rpc.Status.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A sample of errors encountered while processing the data.
     * </pre>
     *
     * <code>repeated .google.rpc.Status error_samples = 1;</code>
     */
    public com.google.rpc.Status.Builder addErrorSamplesBuilder(int index) {
      return getErrorSamplesFieldBuilder()
          .addBuilder(index, com.google.rpc.Status.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A sample of errors encountered while processing the data.
     * </pre>
     *
     * <code>repeated .google.rpc.Status error_samples = 1;</code>
     */
    public java.util.List<com.google.rpc.Status.Builder> getErrorSamplesBuilderList() {
      return getErrorSamplesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        getErrorSamplesFieldBuilder() {
      if (errorSamplesBuilder_ == null) {
        errorSamplesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.rpc.Status,
                com.google.rpc.Status.Builder,
                com.google.rpc.StatusOrBuilder>(
                errorSamples_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        errorSamples_ = null;
      }
      return errorSamplesBuilder_;
    }

    private com.google.cloud.discoveryengine.v1beta.ImportErrorConfig errorConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1beta.ImportErrorConfig,
            com.google.cloud.discoveryengine.v1beta.ImportErrorConfig.Builder,
            com.google.cloud.discoveryengine.v1beta.ImportErrorConfigOrBuilder>
        errorConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Echoes the destination for the complete errors in the request if set.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.ImportErrorConfig error_config = 2;</code>
     *
     * @return Whether the errorConfig field is set.
     */
    public boolean hasErrorConfig() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Echoes the destination for the complete errors in the request if set.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.ImportErrorConfig error_config = 2;</code>
     *
     * @return The errorConfig.
     */
    public com.google.cloud.discoveryengine.v1beta.ImportErrorConfig getErrorConfig() {
      if (errorConfigBuilder_ == null) {
        return errorConfig_ == null
            ? com.google.cloud.discoveryengine.v1beta.ImportErrorConfig.getDefaultInstance()
            : errorConfig_;
      } else {
        return errorConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Echoes the destination for the complete errors in the request if set.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.ImportErrorConfig error_config = 2;</code>
     */
    public Builder setErrorConfig(com.google.cloud.discoveryengine.v1beta.ImportErrorConfig value) {
      if (errorConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        errorConfig_ = value;
      } else {
        errorConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Echoes the destination for the complete errors in the request if set.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.ImportErrorConfig error_config = 2;</code>
     */
    public Builder setErrorConfig(
        com.google.cloud.discoveryengine.v1beta.ImportErrorConfig.Builder builderForValue) {
      if (errorConfigBuilder_ == null) {
        errorConfig_ = builderForValue.build();
      } else {
        errorConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Echoes the destination for the complete errors in the request if set.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.ImportErrorConfig error_config = 2;</code>
     */
    public Builder mergeErrorConfig(
        com.google.cloud.discoveryengine.v1beta.ImportErrorConfig value) {
      if (errorConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && errorConfig_ != null
            && errorConfig_
                != com.google.cloud.discoveryengine.v1beta.ImportErrorConfig.getDefaultInstance()) {
          getErrorConfigBuilder().mergeFrom(value);
        } else {
          errorConfig_ = value;
        }
      } else {
        errorConfigBuilder_.mergeFrom(value);
      }
      if (errorConfig_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Echoes the destination for the complete errors in the request if set.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.ImportErrorConfig error_config = 2;</code>
     */
    public Builder clearErrorConfig() {
      bitField0_ = (bitField0_ & ~0x00000002);
      errorConfig_ = null;
      if (errorConfigBuilder_ != null) {
        errorConfigBuilder_.dispose();
        errorConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Echoes the destination for the complete errors in the request if set.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.ImportErrorConfig error_config = 2;</code>
     */
    public com.google.cloud.discoveryengine.v1beta.ImportErrorConfig.Builder
        getErrorConfigBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getErrorConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Echoes the destination for the complete errors in the request if set.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.ImportErrorConfig error_config = 2;</code>
     */
    public com.google.cloud.discoveryengine.v1beta.ImportErrorConfigOrBuilder
        getErrorConfigOrBuilder() {
      if (errorConfigBuilder_ != null) {
        return errorConfigBuilder_.getMessageOrBuilder();
      } else {
        return errorConfig_ == null
            ? com.google.cloud.discoveryengine.v1beta.ImportErrorConfig.getDefaultInstance()
            : errorConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Echoes the destination for the complete errors in the request if set.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.ImportErrorConfig error_config = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1beta.ImportErrorConfig,
            com.google.cloud.discoveryengine.v1beta.ImportErrorConfig.Builder,
            com.google.cloud.discoveryengine.v1beta.ImportErrorConfigOrBuilder>
        getErrorConfigFieldBuilder() {
      if (errorConfigBuilder_ == null) {
        errorConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1beta.ImportErrorConfig,
                com.google.cloud.discoveryengine.v1beta.ImportErrorConfig.Builder,
                com.google.cloud.discoveryengine.v1beta.ImportErrorConfigOrBuilder>(
                getErrorConfig(), getParentForChildren(), isClean());
        errorConfig_ = null;
      }
      return errorConfigBuilder_;
    }

    private java.lang.Object modelStatus_ = "";
    /**
     *
     *
     * <pre>
     * The trained model status. Possible values are:
     *
     *  * **bad-data**: The training data quality is bad.
     *  * **no-improvement**: Tuning didn't improve performance. Won't deploy.
     *  * **in-progress**: Model training job creation is in progress.
     *  * **training**: Model is actively training.
     *  * **evaluating**: The model is evaluating trained metrics.
     *  * **indexing**: The model trained metrics are indexing.
     *  * **ready**: The model is ready for serving.
     * </pre>
     *
     * <code>string model_status = 3;</code>
     *
     * @return The modelStatus.
     */
    public java.lang.String getModelStatus() {
      java.lang.Object ref = modelStatus_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        modelStatus_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The trained model status. Possible values are:
     *
     *  * **bad-data**: The training data quality is bad.
     *  * **no-improvement**: Tuning didn't improve performance. Won't deploy.
     *  * **in-progress**: Model training job creation is in progress.
     *  * **training**: Model is actively training.
     *  * **evaluating**: The model is evaluating trained metrics.
     *  * **indexing**: The model trained metrics are indexing.
     *  * **ready**: The model is ready for serving.
     * </pre>
     *
     * <code>string model_status = 3;</code>
     *
     * @return The bytes for modelStatus.
     */
    public com.google.protobuf.ByteString getModelStatusBytes() {
      java.lang.Object ref = modelStatus_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        modelStatus_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The trained model status. Possible values are:
     *
     *  * **bad-data**: The training data quality is bad.
     *  * **no-improvement**: Tuning didn't improve performance. Won't deploy.
     *  * **in-progress**: Model training job creation is in progress.
     *  * **training**: Model is actively training.
     *  * **evaluating**: The model is evaluating trained metrics.
     *  * **indexing**: The model trained metrics are indexing.
     *  * **ready**: The model is ready for serving.
     * </pre>
     *
     * <code>string model_status = 3;</code>
     *
     * @param value The modelStatus to set.
     * @return This builder for chaining.
     */
    public Builder setModelStatus(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      modelStatus_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The trained model status. Possible values are:
     *
     *  * **bad-data**: The training data quality is bad.
     *  * **no-improvement**: Tuning didn't improve performance. Won't deploy.
     *  * **in-progress**: Model training job creation is in progress.
     *  * **training**: Model is actively training.
     *  * **evaluating**: The model is evaluating trained metrics.
     *  * **indexing**: The model trained metrics are indexing.
     *  * **ready**: The model is ready for serving.
     * </pre>
     *
     * <code>string model_status = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearModelStatus() {
      modelStatus_ = getDefaultInstance().getModelStatus();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The trained model status. Possible values are:
     *
     *  * **bad-data**: The training data quality is bad.
     *  * **no-improvement**: Tuning didn't improve performance. Won't deploy.
     *  * **in-progress**: Model training job creation is in progress.
     *  * **training**: Model is actively training.
     *  * **evaluating**: The model is evaluating trained metrics.
     *  * **indexing**: The model trained metrics are indexing.
     *  * **ready**: The model is ready for serving.
     * </pre>
     *
     * <code>string model_status = 3;</code>
     *
     * @param value The bytes for modelStatus to set.
     * @return This builder for chaining.
     */
    public Builder setModelStatusBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      modelStatus_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.Double> metrics_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.Double> internalGetMetrics() {
      if (metrics_ == null) {
        return com.google.protobuf.MapField.emptyMapField(MetricsDefaultEntryHolder.defaultEntry);
      }
      return metrics_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.Double>
        internalGetMutableMetrics() {
      if (metrics_ == null) {
        metrics_ = com.google.protobuf.MapField.newMapField(MetricsDefaultEntryHolder.defaultEntry);
      }
      if (!metrics_.isMutable()) {
        metrics_ = metrics_.copy();
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return metrics_;
    }

    public int getMetricsCount() {
      return internalGetMetrics().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * The metrics of the trained model.
     * </pre>
     *
     * <code>map&lt;string, double&gt; metrics = 4;</code>
     */
    @java.lang.Override
    public boolean containsMetrics(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetMetrics().getMap().containsKey(key);
    }
    /** Use {@link #getMetricsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.Double> getMetrics() {
      return getMetricsMap();
    }
    /**
     *
     *
     * <pre>
     * The metrics of the trained model.
     * </pre>
     *
     * <code>map&lt;string, double&gt; metrics = 4;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.Double> getMetricsMap() {
      return internalGetMetrics().getMap();
    }
    /**
     *
     *
     * <pre>
     * The metrics of the trained model.
     * </pre>
     *
     * <code>map&lt;string, double&gt; metrics = 4;</code>
     */
    @java.lang.Override
    public double getMetricsOrDefault(java.lang.String key, double defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.Double> map = internalGetMetrics().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * The metrics of the trained model.
     * </pre>
     *
     * <code>map&lt;string, double&gt; metrics = 4;</code>
     */
    @java.lang.Override
    public double getMetricsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.Double> map = internalGetMetrics().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearMetrics() {
      bitField0_ = (bitField0_ & ~0x00000008);
      internalGetMutableMetrics().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The metrics of the trained model.
     * </pre>
     *
     * <code>map&lt;string, double&gt; metrics = 4;</code>
     */
    public Builder removeMetrics(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableMetrics().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.Double> getMutableMetrics() {
      bitField0_ |= 0x00000008;
      return internalGetMutableMetrics().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * The metrics of the trained model.
     * </pre>
     *
     * <code>map&lt;string, double&gt; metrics = 4;</code>
     */
    public Builder putMetrics(java.lang.String key, double value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }

      internalGetMutableMetrics().getMutableMap().put(key, value);
      bitField0_ |= 0x00000008;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The metrics of the trained model.
     * </pre>
     *
     * <code>map&lt;string, double&gt; metrics = 4;</code>
     */
    public Builder putAllMetrics(java.util.Map<java.lang.String, java.lang.Double> values) {
      internalGetMutableMetrics().getMutableMap().putAll(values);
      bitField0_ |= 0x00000008;
      return this;
    }

    private java.lang.Object modelName_ = "";
    /**
     *
     *
     * <pre>
     * Fully qualified name of the CustomTuningModel.
     * </pre>
     *
     * <code>string model_name = 5;</code>
     *
     * @return The modelName.
     */
    public java.lang.String getModelName() {
      java.lang.Object ref = modelName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        modelName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Fully qualified name of the CustomTuningModel.
     * </pre>
     *
     * <code>string model_name = 5;</code>
     *
     * @return The bytes for modelName.
     */
    public com.google.protobuf.ByteString getModelNameBytes() {
      java.lang.Object ref = modelName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        modelName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Fully qualified name of the CustomTuningModel.
     * </pre>
     *
     * <code>string model_name = 5;</code>
     *
     * @param value The modelName to set.
     * @return This builder for chaining.
     */
    public Builder setModelName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      modelName_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Fully qualified name of the CustomTuningModel.
     * </pre>
     *
     * <code>string model_name = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearModelName() {
      modelName_ = getDefaultInstance().getModelName();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Fully qualified name of the CustomTuningModel.
     * </pre>
     *
     * <code>string model_name = 5;</code>
     *
     * @param value The bytes for modelName to set.
     * @return This builder for chaining.
     */
    public Builder setModelNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      modelName_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.TrainCustomModelResponse)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.TrainCustomModelResponse)
  private static final com.google.cloud.discoveryengine.v1beta.TrainCustomModelResponse
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.discoveryengine.v1beta.TrainCustomModelResponse();
  }

  public static com.google.cloud.discoveryengine.v1beta.TrainCustomModelResponse
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<TrainCustomModelResponse> PARSER =
      new com.google.protobuf.AbstractParser<TrainCustomModelResponse>() {
        @java.lang.Override
        public TrainCustomModelResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<TrainCustomModelResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<TrainCustomModelResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.TrainCustomModelResponse
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
