/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/discoveryengine/v1beta/import_config.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.discoveryengine.v1beta;

/**
 *
 *
 * <pre>
 * BigQuery source import data from.
 * </pre>
 *
 * Protobuf type {@code google.cloud.discoveryengine.v1beta.BigQuerySource}
 */
public final class BigQuerySource extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.BigQuerySource)
    BigQuerySourceOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use BigQuerySource.newBuilder() to construct.
  private BigQuerySource(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private BigQuerySource() {
    projectId_ = "";
    datasetId_ = "";
    tableId_ = "";
    gcsStagingDir_ = "";
    dataSchema_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new BigQuerySource();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.discoveryengine.v1beta.ImportConfigProto
        .internal_static_google_cloud_discoveryengine_v1beta_BigQuerySource_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.discoveryengine.v1beta.ImportConfigProto
        .internal_static_google_cloud_discoveryengine_v1beta_BigQuerySource_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.discoveryengine.v1beta.BigQuerySource.class,
            com.google.cloud.discoveryengine.v1beta.BigQuerySource.Builder.class);
  }

  private int partitionCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object partition_;

  public enum PartitionCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    PARTITION_DATE(5),
    PARTITION_NOT_SET(0);
    private final int value;

    private PartitionCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static PartitionCase valueOf(int value) {
      return forNumber(value);
    }

    public static PartitionCase forNumber(int value) {
      switch (value) {
        case 5:
          return PARTITION_DATE;
        case 0:
          return PARTITION_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public PartitionCase getPartitionCase() {
    return PartitionCase.forNumber(partitionCase_);
  }

  public static final int PARTITION_DATE_FIELD_NUMBER = 5;
  /**
   *
   *
   * <pre>
   * BigQuery time partitioned table's _PARTITIONDATE in YYYY-MM-DD format.
   * </pre>
   *
   * <code>.google.type.Date partition_date = 5;</code>
   *
   * @return Whether the partitionDate field is set.
   */
  @java.lang.Override
  public boolean hasPartitionDate() {
    return partitionCase_ == 5;
  }
  /**
   *
   *
   * <pre>
   * BigQuery time partitioned table's _PARTITIONDATE in YYYY-MM-DD format.
   * </pre>
   *
   * <code>.google.type.Date partition_date = 5;</code>
   *
   * @return The partitionDate.
   */
  @java.lang.Override
  public com.google.type.Date getPartitionDate() {
    if (partitionCase_ == 5) {
      return (com.google.type.Date) partition_;
    }
    return com.google.type.Date.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * BigQuery time partitioned table's _PARTITIONDATE in YYYY-MM-DD format.
   * </pre>
   *
   * <code>.google.type.Date partition_date = 5;</code>
   */
  @java.lang.Override
  public com.google.type.DateOrBuilder getPartitionDateOrBuilder() {
    if (partitionCase_ == 5) {
      return (com.google.type.Date) partition_;
    }
    return com.google.type.Date.getDefaultInstance();
  }

  public static final int PROJECT_ID_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object projectId_ = "";
  /**
   *
   *
   * <pre>
   * The project ID or the project number that contains the BigQuery source. Has
   * a length limit of 128 characters. If not specified, inherits the project
   * ID from the parent request.
   * </pre>
   *
   * <code>string project_id = 1;</code>
   *
   * @return The projectId.
   */
  @java.lang.Override
  public java.lang.String getProjectId() {
    java.lang.Object ref = projectId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      projectId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The project ID or the project number that contains the BigQuery source. Has
   * a length limit of 128 characters. If not specified, inherits the project
   * ID from the parent request.
   * </pre>
   *
   * <code>string project_id = 1;</code>
   *
   * @return The bytes for projectId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getProjectIdBytes() {
    java.lang.Object ref = projectId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      projectId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DATASET_ID_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object datasetId_ = "";
  /**
   *
   *
   * <pre>
   * Required. The BigQuery data set to copy the data from with a length limit
   * of 1,024 characters.
   * </pre>
   *
   * <code>string dataset_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The datasetId.
   */
  @java.lang.Override
  public java.lang.String getDatasetId() {
    java.lang.Object ref = datasetId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      datasetId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The BigQuery data set to copy the data from with a length limit
   * of 1,024 characters.
   * </pre>
   *
   * <code>string dataset_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for datasetId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDatasetIdBytes() {
    java.lang.Object ref = datasetId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      datasetId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TABLE_ID_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object tableId_ = "";
  /**
   *
   *
   * <pre>
   * Required. The BigQuery table to copy the data from with a length limit of
   * 1,024 characters.
   * </pre>
   *
   * <code>string table_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The tableId.
   */
  @java.lang.Override
  public java.lang.String getTableId() {
    java.lang.Object ref = tableId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      tableId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The BigQuery table to copy the data from with a length limit of
   * 1,024 characters.
   * </pre>
   *
   * <code>string table_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for tableId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTableIdBytes() {
    java.lang.Object ref = tableId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      tableId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int GCS_STAGING_DIR_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object gcsStagingDir_ = "";
  /**
   *
   *
   * <pre>
   * Intermediate Cloud Storage directory used for the import with a length
   * limit of 2,000 characters. Can be specified if one wants to have the
   * BigQuery export to a specific Cloud Storage directory.
   * </pre>
   *
   * <code>string gcs_staging_dir = 4;</code>
   *
   * @return The gcsStagingDir.
   */
  @java.lang.Override
  public java.lang.String getGcsStagingDir() {
    java.lang.Object ref = gcsStagingDir_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      gcsStagingDir_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Intermediate Cloud Storage directory used for the import with a length
   * limit of 2,000 characters. Can be specified if one wants to have the
   * BigQuery export to a specific Cloud Storage directory.
   * </pre>
   *
   * <code>string gcs_staging_dir = 4;</code>
   *
   * @return The bytes for gcsStagingDir.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getGcsStagingDirBytes() {
    java.lang.Object ref = gcsStagingDir_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      gcsStagingDir_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DATA_SCHEMA_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object dataSchema_ = "";
  /**
   *
   *
   * <pre>
   * The schema to use when parsing the data from the source.
   *
   * Supported values for user event imports:
   *
   * * `user_event` (default): One
   * [UserEvent][google.cloud.discoveryengine.v1beta.UserEvent] per row.
   *
   * Supported values for document imports:
   *
   * * `document` (default): One
   * [Document][google.cloud.discoveryengine.v1beta.Document] format per
   *   row. Each document must have a valid
   *   [Document.id][google.cloud.discoveryengine.v1beta.Document.id] and one of
   *   [Document.json_data][google.cloud.discoveryengine.v1beta.Document.json_data]
   *   or
   *   [Document.struct_data][google.cloud.discoveryengine.v1beta.Document.struct_data].
   * * `custom`: One custom data per row in arbitrary format that conforms to
   *   the defined [Schema][google.cloud.discoveryengine.v1beta.Schema] of the
   *   data store. This can only be used by the GENERIC Data Store vertical.
   * </pre>
   *
   * <code>string data_schema = 6;</code>
   *
   * @return The dataSchema.
   */
  @java.lang.Override
  public java.lang.String getDataSchema() {
    java.lang.Object ref = dataSchema_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      dataSchema_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The schema to use when parsing the data from the source.
   *
   * Supported values for user event imports:
   *
   * * `user_event` (default): One
   * [UserEvent][google.cloud.discoveryengine.v1beta.UserEvent] per row.
   *
   * Supported values for document imports:
   *
   * * `document` (default): One
   * [Document][google.cloud.discoveryengine.v1beta.Document] format per
   *   row. Each document must have a valid
   *   [Document.id][google.cloud.discoveryengine.v1beta.Document.id] and one of
   *   [Document.json_data][google.cloud.discoveryengine.v1beta.Document.json_data]
   *   or
   *   [Document.struct_data][google.cloud.discoveryengine.v1beta.Document.struct_data].
   * * `custom`: One custom data per row in arbitrary format that conforms to
   *   the defined [Schema][google.cloud.discoveryengine.v1beta.Schema] of the
   *   data store. This can only be used by the GENERIC Data Store vertical.
   * </pre>
   *
   * <code>string data_schema = 6;</code>
   *
   * @return The bytes for dataSchema.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDataSchemaBytes() {
    java.lang.Object ref = dataSchema_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      dataSchema_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(projectId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, projectId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(datasetId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, datasetId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(tableId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, tableId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(gcsStagingDir_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, gcsStagingDir_);
    }
    if (partitionCase_ == 5) {
      output.writeMessage(5, (com.google.type.Date) partition_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dataSchema_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, dataSchema_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(projectId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, projectId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(datasetId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, datasetId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(tableId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, tableId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(gcsStagingDir_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, gcsStagingDir_);
    }
    if (partitionCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5, (com.google.type.Date) partition_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dataSchema_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, dataSchema_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.discoveryengine.v1beta.BigQuerySource)) {
      return super.equals(obj);
    }
    com.google.cloud.discoveryengine.v1beta.BigQuerySource other =
        (com.google.cloud.discoveryengine.v1beta.BigQuerySource) obj;

    if (!getProjectId().equals(other.getProjectId())) return false;
    if (!getDatasetId().equals(other.getDatasetId())) return false;
    if (!getTableId().equals(other.getTableId())) return false;
    if (!getGcsStagingDir().equals(other.getGcsStagingDir())) return false;
    if (!getDataSchema().equals(other.getDataSchema())) return false;
    if (!getPartitionCase().equals(other.getPartitionCase())) return false;
    switch (partitionCase_) {
      case 5:
        if (!getPartitionDate().equals(other.getPartitionDate())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PROJECT_ID_FIELD_NUMBER;
    hash = (53 * hash) + getProjectId().hashCode();
    hash = (37 * hash) + DATASET_ID_FIELD_NUMBER;
    hash = (53 * hash) + getDatasetId().hashCode();
    hash = (37 * hash) + TABLE_ID_FIELD_NUMBER;
    hash = (53 * hash) + getTableId().hashCode();
    hash = (37 * hash) + GCS_STAGING_DIR_FIELD_NUMBER;
    hash = (53 * hash) + getGcsStagingDir().hashCode();
    hash = (37 * hash) + DATA_SCHEMA_FIELD_NUMBER;
    hash = (53 * hash) + getDataSchema().hashCode();
    switch (partitionCase_) {
      case 5:
        hash = (37 * hash) + PARTITION_DATE_FIELD_NUMBER;
        hash = (53 * hash) + getPartitionDate().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.discoveryengine.v1beta.BigQuerySource parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1beta.BigQuerySource parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.BigQuerySource parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1beta.BigQuerySource parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.BigQuerySource parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1beta.BigQuerySource parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.BigQuerySource parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1beta.BigQuerySource parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.BigQuerySource parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1beta.BigQuerySource parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.BigQuerySource parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1beta.BigQuerySource parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.discoveryengine.v1beta.BigQuerySource prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * BigQuery source import data from.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1beta.BigQuerySource}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.BigQuerySource)
      com.google.cloud.discoveryengine.v1beta.BigQuerySourceOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1beta.ImportConfigProto
          .internal_static_google_cloud_discoveryengine_v1beta_BigQuerySource_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1beta.ImportConfigProto
          .internal_static_google_cloud_discoveryengine_v1beta_BigQuerySource_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1beta.BigQuerySource.class,
              com.google.cloud.discoveryengine.v1beta.BigQuerySource.Builder.class);
    }

    // Construct using com.google.cloud.discoveryengine.v1beta.BigQuerySource.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (partitionDateBuilder_ != null) {
        partitionDateBuilder_.clear();
      }
      projectId_ = "";
      datasetId_ = "";
      tableId_ = "";
      gcsStagingDir_ = "";
      dataSchema_ = "";
      partitionCase_ = 0;
      partition_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.discoveryengine.v1beta.ImportConfigProto
          .internal_static_google_cloud_discoveryengine_v1beta_BigQuerySource_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.BigQuerySource getDefaultInstanceForType() {
      return com.google.cloud.discoveryengine.v1beta.BigQuerySource.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.BigQuerySource build() {
      com.google.cloud.discoveryengine.v1beta.BigQuerySource result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.BigQuerySource buildPartial() {
      com.google.cloud.discoveryengine.v1beta.BigQuerySource result =
          new com.google.cloud.discoveryengine.v1beta.BigQuerySource(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.discoveryengine.v1beta.BigQuerySource result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.projectId_ = projectId_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.datasetId_ = datasetId_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.tableId_ = tableId_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.gcsStagingDir_ = gcsStagingDir_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.dataSchema_ = dataSchema_;
      }
    }

    private void buildPartialOneofs(com.google.cloud.discoveryengine.v1beta.BigQuerySource result) {
      result.partitionCase_ = partitionCase_;
      result.partition_ = this.partition_;
      if (partitionCase_ == 5 && partitionDateBuilder_ != null) {
        result.partition_ = partitionDateBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.discoveryengine.v1beta.BigQuerySource) {
        return mergeFrom((com.google.cloud.discoveryengine.v1beta.BigQuerySource) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.discoveryengine.v1beta.BigQuerySource other) {
      if (other == com.google.cloud.discoveryengine.v1beta.BigQuerySource.getDefaultInstance())
        return this;
      if (!other.getProjectId().isEmpty()) {
        projectId_ = other.projectId_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getDatasetId().isEmpty()) {
        datasetId_ = other.datasetId_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getTableId().isEmpty()) {
        tableId_ = other.tableId_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.getGcsStagingDir().isEmpty()) {
        gcsStagingDir_ = other.gcsStagingDir_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (!other.getDataSchema().isEmpty()) {
        dataSchema_ = other.dataSchema_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      switch (other.getPartitionCase()) {
        case PARTITION_DATE:
          {
            mergePartitionDate(other.getPartitionDate());
            break;
          }
        case PARTITION_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                projectId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 10
            case 18:
              {
                datasetId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 18
            case 26:
              {
                tableId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 26
            case 34:
              {
                gcsStagingDir_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getPartitionDateFieldBuilder().getBuilder(), extensionRegistry);
                partitionCase_ = 5;
                break;
              } // case 42
            case 50:
              {
                dataSchema_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int partitionCase_ = 0;
    private java.lang.Object partition_;

    public PartitionCase getPartitionCase() {
      return PartitionCase.forNumber(partitionCase_);
    }

    public Builder clearPartition() {
      partitionCase_ = 0;
      partition_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.type.Date, com.google.type.Date.Builder, com.google.type.DateOrBuilder>
        partitionDateBuilder_;
    /**
     *
     *
     * <pre>
     * BigQuery time partitioned table's _PARTITIONDATE in YYYY-MM-DD format.
     * </pre>
     *
     * <code>.google.type.Date partition_date = 5;</code>
     *
     * @return Whether the partitionDate field is set.
     */
    @java.lang.Override
    public boolean hasPartitionDate() {
      return partitionCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * BigQuery time partitioned table's _PARTITIONDATE in YYYY-MM-DD format.
     * </pre>
     *
     * <code>.google.type.Date partition_date = 5;</code>
     *
     * @return The partitionDate.
     */
    @java.lang.Override
    public com.google.type.Date getPartitionDate() {
      if (partitionDateBuilder_ == null) {
        if (partitionCase_ == 5) {
          return (com.google.type.Date) partition_;
        }
        return com.google.type.Date.getDefaultInstance();
      } else {
        if (partitionCase_ == 5) {
          return partitionDateBuilder_.getMessage();
        }
        return com.google.type.Date.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * BigQuery time partitioned table's _PARTITIONDATE in YYYY-MM-DD format.
     * </pre>
     *
     * <code>.google.type.Date partition_date = 5;</code>
     */
    public Builder setPartitionDate(com.google.type.Date value) {
      if (partitionDateBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        partition_ = value;
        onChanged();
      } else {
        partitionDateBuilder_.setMessage(value);
      }
      partitionCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * BigQuery time partitioned table's _PARTITIONDATE in YYYY-MM-DD format.
     * </pre>
     *
     * <code>.google.type.Date partition_date = 5;</code>
     */
    public Builder setPartitionDate(com.google.type.Date.Builder builderForValue) {
      if (partitionDateBuilder_ == null) {
        partition_ = builderForValue.build();
        onChanged();
      } else {
        partitionDateBuilder_.setMessage(builderForValue.build());
      }
      partitionCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * BigQuery time partitioned table's _PARTITIONDATE in YYYY-MM-DD format.
     * </pre>
     *
     * <code>.google.type.Date partition_date = 5;</code>
     */
    public Builder mergePartitionDate(com.google.type.Date value) {
      if (partitionDateBuilder_ == null) {
        if (partitionCase_ == 5 && partition_ != com.google.type.Date.getDefaultInstance()) {
          partition_ =
              com.google.type.Date.newBuilder((com.google.type.Date) partition_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          partition_ = value;
        }
        onChanged();
      } else {
        if (partitionCase_ == 5) {
          partitionDateBuilder_.mergeFrom(value);
        } else {
          partitionDateBuilder_.setMessage(value);
        }
      }
      partitionCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * BigQuery time partitioned table's _PARTITIONDATE in YYYY-MM-DD format.
     * </pre>
     *
     * <code>.google.type.Date partition_date = 5;</code>
     */
    public Builder clearPartitionDate() {
      if (partitionDateBuilder_ == null) {
        if (partitionCase_ == 5) {
          partitionCase_ = 0;
          partition_ = null;
          onChanged();
        }
      } else {
        if (partitionCase_ == 5) {
          partitionCase_ = 0;
          partition_ = null;
        }
        partitionDateBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * BigQuery time partitioned table's _PARTITIONDATE in YYYY-MM-DD format.
     * </pre>
     *
     * <code>.google.type.Date partition_date = 5;</code>
     */
    public com.google.type.Date.Builder getPartitionDateBuilder() {
      return getPartitionDateFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * BigQuery time partitioned table's _PARTITIONDATE in YYYY-MM-DD format.
     * </pre>
     *
     * <code>.google.type.Date partition_date = 5;</code>
     */
    @java.lang.Override
    public com.google.type.DateOrBuilder getPartitionDateOrBuilder() {
      if ((partitionCase_ == 5) && (partitionDateBuilder_ != null)) {
        return partitionDateBuilder_.getMessageOrBuilder();
      } else {
        if (partitionCase_ == 5) {
          return (com.google.type.Date) partition_;
        }
        return com.google.type.Date.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * BigQuery time partitioned table's _PARTITIONDATE in YYYY-MM-DD format.
     * </pre>
     *
     * <code>.google.type.Date partition_date = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.type.Date, com.google.type.Date.Builder, com.google.type.DateOrBuilder>
        getPartitionDateFieldBuilder() {
      if (partitionDateBuilder_ == null) {
        if (!(partitionCase_ == 5)) {
          partition_ = com.google.type.Date.getDefaultInstance();
        }
        partitionDateBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.type.Date, com.google.type.Date.Builder, com.google.type.DateOrBuilder>(
                (com.google.type.Date) partition_, getParentForChildren(), isClean());
        partition_ = null;
      }
      partitionCase_ = 5;
      onChanged();
      return partitionDateBuilder_;
    }

    private java.lang.Object projectId_ = "";
    /**
     *
     *
     * <pre>
     * The project ID or the project number that contains the BigQuery source. Has
     * a length limit of 128 characters. If not specified, inherits the project
     * ID from the parent request.
     * </pre>
     *
     * <code>string project_id = 1;</code>
     *
     * @return The projectId.
     */
    public java.lang.String getProjectId() {
      java.lang.Object ref = projectId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        projectId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The project ID or the project number that contains the BigQuery source. Has
     * a length limit of 128 characters. If not specified, inherits the project
     * ID from the parent request.
     * </pre>
     *
     * <code>string project_id = 1;</code>
     *
     * @return The bytes for projectId.
     */
    public com.google.protobuf.ByteString getProjectIdBytes() {
      java.lang.Object ref = projectId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        projectId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The project ID or the project number that contains the BigQuery source. Has
     * a length limit of 128 characters. If not specified, inherits the project
     * ID from the parent request.
     * </pre>
     *
     * <code>string project_id = 1;</code>
     *
     * @param value The projectId to set.
     * @return This builder for chaining.
     */
    public Builder setProjectId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      projectId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The project ID or the project number that contains the BigQuery source. Has
     * a length limit of 128 characters. If not specified, inherits the project
     * ID from the parent request.
     * </pre>
     *
     * <code>string project_id = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProjectId() {
      projectId_ = getDefaultInstance().getProjectId();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The project ID or the project number that contains the BigQuery source. Has
     * a length limit of 128 characters. If not specified, inherits the project
     * ID from the parent request.
     * </pre>
     *
     * <code>string project_id = 1;</code>
     *
     * @param value The bytes for projectId to set.
     * @return This builder for chaining.
     */
    public Builder setProjectIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      projectId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object datasetId_ = "";
    /**
     *
     *
     * <pre>
     * Required. The BigQuery data set to copy the data from with a length limit
     * of 1,024 characters.
     * </pre>
     *
     * <code>string dataset_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The datasetId.
     */
    public java.lang.String getDatasetId() {
      java.lang.Object ref = datasetId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        datasetId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The BigQuery data set to copy the data from with a length limit
     * of 1,024 characters.
     * </pre>
     *
     * <code>string dataset_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for datasetId.
     */
    public com.google.protobuf.ByteString getDatasetIdBytes() {
      java.lang.Object ref = datasetId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        datasetId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The BigQuery data set to copy the data from with a length limit
     * of 1,024 characters.
     * </pre>
     *
     * <code>string dataset_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The datasetId to set.
     * @return This builder for chaining.
     */
    public Builder setDatasetId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      datasetId_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The BigQuery data set to copy the data from with a length limit
     * of 1,024 characters.
     * </pre>
     *
     * <code>string dataset_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDatasetId() {
      datasetId_ = getDefaultInstance().getDatasetId();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The BigQuery data set to copy the data from with a length limit
     * of 1,024 characters.
     * </pre>
     *
     * <code>string dataset_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for datasetId to set.
     * @return This builder for chaining.
     */
    public Builder setDatasetIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      datasetId_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object tableId_ = "";
    /**
     *
     *
     * <pre>
     * Required. The BigQuery table to copy the data from with a length limit of
     * 1,024 characters.
     * </pre>
     *
     * <code>string table_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The tableId.
     */
    public java.lang.String getTableId() {
      java.lang.Object ref = tableId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        tableId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The BigQuery table to copy the data from with a length limit of
     * 1,024 characters.
     * </pre>
     *
     * <code>string table_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for tableId.
     */
    public com.google.protobuf.ByteString getTableIdBytes() {
      java.lang.Object ref = tableId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        tableId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The BigQuery table to copy the data from with a length limit of
     * 1,024 characters.
     * </pre>
     *
     * <code>string table_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The tableId to set.
     * @return This builder for chaining.
     */
    public Builder setTableId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      tableId_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The BigQuery table to copy the data from with a length limit of
     * 1,024 characters.
     * </pre>
     *
     * <code>string table_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTableId() {
      tableId_ = getDefaultInstance().getTableId();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The BigQuery table to copy the data from with a length limit of
     * 1,024 characters.
     * </pre>
     *
     * <code>string table_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for tableId to set.
     * @return This builder for chaining.
     */
    public Builder setTableIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      tableId_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object gcsStagingDir_ = "";
    /**
     *
     *
     * <pre>
     * Intermediate Cloud Storage directory used for the import with a length
     * limit of 2,000 characters. Can be specified if one wants to have the
     * BigQuery export to a specific Cloud Storage directory.
     * </pre>
     *
     * <code>string gcs_staging_dir = 4;</code>
     *
     * @return The gcsStagingDir.
     */
    public java.lang.String getGcsStagingDir() {
      java.lang.Object ref = gcsStagingDir_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        gcsStagingDir_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Intermediate Cloud Storage directory used for the import with a length
     * limit of 2,000 characters. Can be specified if one wants to have the
     * BigQuery export to a specific Cloud Storage directory.
     * </pre>
     *
     * <code>string gcs_staging_dir = 4;</code>
     *
     * @return The bytes for gcsStagingDir.
     */
    public com.google.protobuf.ByteString getGcsStagingDirBytes() {
      java.lang.Object ref = gcsStagingDir_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        gcsStagingDir_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Intermediate Cloud Storage directory used for the import with a length
     * limit of 2,000 characters. Can be specified if one wants to have the
     * BigQuery export to a specific Cloud Storage directory.
     * </pre>
     *
     * <code>string gcs_staging_dir = 4;</code>
     *
     * @param value The gcsStagingDir to set.
     * @return This builder for chaining.
     */
    public Builder setGcsStagingDir(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      gcsStagingDir_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Intermediate Cloud Storage directory used for the import with a length
     * limit of 2,000 characters. Can be specified if one wants to have the
     * BigQuery export to a specific Cloud Storage directory.
     * </pre>
     *
     * <code>string gcs_staging_dir = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearGcsStagingDir() {
      gcsStagingDir_ = getDefaultInstance().getGcsStagingDir();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Intermediate Cloud Storage directory used for the import with a length
     * limit of 2,000 characters. Can be specified if one wants to have the
     * BigQuery export to a specific Cloud Storage directory.
     * </pre>
     *
     * <code>string gcs_staging_dir = 4;</code>
     *
     * @param value The bytes for gcsStagingDir to set.
     * @return This builder for chaining.
     */
    public Builder setGcsStagingDirBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      gcsStagingDir_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.lang.Object dataSchema_ = "";
    /**
     *
     *
     * <pre>
     * The schema to use when parsing the data from the source.
     *
     * Supported values for user event imports:
     *
     * * `user_event` (default): One
     * [UserEvent][google.cloud.discoveryengine.v1beta.UserEvent] per row.
     *
     * Supported values for document imports:
     *
     * * `document` (default): One
     * [Document][google.cloud.discoveryengine.v1beta.Document] format per
     *   row. Each document must have a valid
     *   [Document.id][google.cloud.discoveryengine.v1beta.Document.id] and one of
     *   [Document.json_data][google.cloud.discoveryengine.v1beta.Document.json_data]
     *   or
     *   [Document.struct_data][google.cloud.discoveryengine.v1beta.Document.struct_data].
     * * `custom`: One custom data per row in arbitrary format that conforms to
     *   the defined [Schema][google.cloud.discoveryengine.v1beta.Schema] of the
     *   data store. This can only be used by the GENERIC Data Store vertical.
     * </pre>
     *
     * <code>string data_schema = 6;</code>
     *
     * @return The dataSchema.
     */
    public java.lang.String getDataSchema() {
      java.lang.Object ref = dataSchema_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        dataSchema_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The schema to use when parsing the data from the source.
     *
     * Supported values for user event imports:
     *
     * * `user_event` (default): One
     * [UserEvent][google.cloud.discoveryengine.v1beta.UserEvent] per row.
     *
     * Supported values for document imports:
     *
     * * `document` (default): One
     * [Document][google.cloud.discoveryengine.v1beta.Document] format per
     *   row. Each document must have a valid
     *   [Document.id][google.cloud.discoveryengine.v1beta.Document.id] and one of
     *   [Document.json_data][google.cloud.discoveryengine.v1beta.Document.json_data]
     *   or
     *   [Document.struct_data][google.cloud.discoveryengine.v1beta.Document.struct_data].
     * * `custom`: One custom data per row in arbitrary format that conforms to
     *   the defined [Schema][google.cloud.discoveryengine.v1beta.Schema] of the
     *   data store. This can only be used by the GENERIC Data Store vertical.
     * </pre>
     *
     * <code>string data_schema = 6;</code>
     *
     * @return The bytes for dataSchema.
     */
    public com.google.protobuf.ByteString getDataSchemaBytes() {
      java.lang.Object ref = dataSchema_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        dataSchema_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The schema to use when parsing the data from the source.
     *
     * Supported values for user event imports:
     *
     * * `user_event` (default): One
     * [UserEvent][google.cloud.discoveryengine.v1beta.UserEvent] per row.
     *
     * Supported values for document imports:
     *
     * * `document` (default): One
     * [Document][google.cloud.discoveryengine.v1beta.Document] format per
     *   row. Each document must have a valid
     *   [Document.id][google.cloud.discoveryengine.v1beta.Document.id] and one of
     *   [Document.json_data][google.cloud.discoveryengine.v1beta.Document.json_data]
     *   or
     *   [Document.struct_data][google.cloud.discoveryengine.v1beta.Document.struct_data].
     * * `custom`: One custom data per row in arbitrary format that conforms to
     *   the defined [Schema][google.cloud.discoveryengine.v1beta.Schema] of the
     *   data store. This can only be used by the GENERIC Data Store vertical.
     * </pre>
     *
     * <code>string data_schema = 6;</code>
     *
     * @param value The dataSchema to set.
     * @return This builder for chaining.
     */
    public Builder setDataSchema(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      dataSchema_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The schema to use when parsing the data from the source.
     *
     * Supported values for user event imports:
     *
     * * `user_event` (default): One
     * [UserEvent][google.cloud.discoveryengine.v1beta.UserEvent] per row.
     *
     * Supported values for document imports:
     *
     * * `document` (default): One
     * [Document][google.cloud.discoveryengine.v1beta.Document] format per
     *   row. Each document must have a valid
     *   [Document.id][google.cloud.discoveryengine.v1beta.Document.id] and one of
     *   [Document.json_data][google.cloud.discoveryengine.v1beta.Document.json_data]
     *   or
     *   [Document.struct_data][google.cloud.discoveryengine.v1beta.Document.struct_data].
     * * `custom`: One custom data per row in arbitrary format that conforms to
     *   the defined [Schema][google.cloud.discoveryengine.v1beta.Schema] of the
     *   data store. This can only be used by the GENERIC Data Store vertical.
     * </pre>
     *
     * <code>string data_schema = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDataSchema() {
      dataSchema_ = getDefaultInstance().getDataSchema();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The schema to use when parsing the data from the source.
     *
     * Supported values for user event imports:
     *
     * * `user_event` (default): One
     * [UserEvent][google.cloud.discoveryengine.v1beta.UserEvent] per row.
     *
     * Supported values for document imports:
     *
     * * `document` (default): One
     * [Document][google.cloud.discoveryengine.v1beta.Document] format per
     *   row. Each document must have a valid
     *   [Document.id][google.cloud.discoveryengine.v1beta.Document.id] and one of
     *   [Document.json_data][google.cloud.discoveryengine.v1beta.Document.json_data]
     *   or
     *   [Document.struct_data][google.cloud.discoveryengine.v1beta.Document.struct_data].
     * * `custom`: One custom data per row in arbitrary format that conforms to
     *   the defined [Schema][google.cloud.discoveryengine.v1beta.Schema] of the
     *   data store. This can only be used by the GENERIC Data Store vertical.
     * </pre>
     *
     * <code>string data_schema = 6;</code>
     *
     * @param value The bytes for dataSchema to set.
     * @return This builder for chaining.
     */
    public Builder setDataSchemaBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      dataSchema_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.BigQuerySource)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.BigQuerySource)
  private static final com.google.cloud.discoveryengine.v1beta.BigQuerySource DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.discoveryengine.v1beta.BigQuerySource();
  }

  public static com.google.cloud.discoveryengine.v1beta.BigQuerySource getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<BigQuerySource> PARSER =
      new com.google.protobuf.AbstractParser<BigQuerySource>() {
        @java.lang.Override
        public BigQuerySource parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<BigQuerySource> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<BigQuerySource> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.BigQuerySource getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
