/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/discoveryengine/v1beta/completion_service.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.discoveryengine.v1beta;

/**
 *
 *
 * <pre>
 * Request message for
 * [CompletionService.CompleteQuery][google.cloud.discoveryengine.v1beta.CompletionService.CompleteQuery]
 * method.
 * </pre>
 *
 * Protobuf type {@code google.cloud.discoveryengine.v1beta.CompleteQueryRequest}
 */
public final class CompleteQueryRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.CompleteQueryRequest)
    CompleteQueryRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use CompleteQueryRequest.newBuilder() to construct.
  private CompleteQueryRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private CompleteQueryRequest() {
    dataStore_ = "";
    query_ = "";
    queryModel_ = "";
    userPseudoId_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new CompleteQueryRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.discoveryengine.v1beta.CompletionServiceProto
        .internal_static_google_cloud_discoveryengine_v1beta_CompleteQueryRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.discoveryengine.v1beta.CompletionServiceProto
        .internal_static_google_cloud_discoveryengine_v1beta_CompleteQueryRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.discoveryengine.v1beta.CompleteQueryRequest.class,
            com.google.cloud.discoveryengine.v1beta.CompleteQueryRequest.Builder.class);
  }

  public static final int DATA_STORE_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object dataStore_ = "";
  /**
   *
   *
   * <pre>
   * Required. The parent data store resource name for which the completion is
   * performed, such as
   * `projects/&#42;&#47;locations/global/collections/default_collection/dataStores/default_data_store`.
   * </pre>
   *
   * <code>
   * string data_store = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The dataStore.
   */
  @java.lang.Override
  public java.lang.String getDataStore() {
    java.lang.Object ref = dataStore_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      dataStore_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The parent data store resource name for which the completion is
   * performed, such as
   * `projects/&#42;&#47;locations/global/collections/default_collection/dataStores/default_data_store`.
   * </pre>
   *
   * <code>
   * string data_store = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for dataStore.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDataStoreBytes() {
    java.lang.Object ref = dataStore_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      dataStore_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int QUERY_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object query_ = "";
  /**
   *
   *
   * <pre>
   * Required. The typeahead input used to fetch suggestions. Maximum length is
   * 128 characters.
   * </pre>
   *
   * <code>string query = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The query.
   */
  @java.lang.Override
  public java.lang.String getQuery() {
    java.lang.Object ref = query_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      query_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The typeahead input used to fetch suggestions. Maximum length is
   * 128 characters.
   * </pre>
   *
   * <code>string query = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for query.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getQueryBytes() {
    java.lang.Object ref = query_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      query_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int QUERY_MODEL_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object queryModel_ = "";
  /**
   *
   *
   * <pre>
   * Specifies the autocomplete data model. This overrides any model specified
   * in the Configuration &gt; Autocomplete section of the Cloud console. Currently
   * supported values:
   *
   * * `document` - Using suggestions generated from user-imported documents.
   * * `search-history` - Using suggestions generated from the past history of
   * [SearchService.Search][google.cloud.discoveryengine.v1beta.SearchService.Search]
   * API calls. Do not use it when there is no traffic for Search API.
   * * `user-event` - Using suggestions generated from user-imported search
   * events.
   * * `document-completable` - Using suggestions taken directly from
   * user-imported document fields marked as completable.
   *
   * Default values:
   *
   * * `document` is the default model for regular dataStores.
   * * `search-history` is the default model for site search dataStores.
   * </pre>
   *
   * <code>string query_model = 3;</code>
   *
   * @return The queryModel.
   */
  @java.lang.Override
  public java.lang.String getQueryModel() {
    java.lang.Object ref = queryModel_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      queryModel_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Specifies the autocomplete data model. This overrides any model specified
   * in the Configuration &gt; Autocomplete section of the Cloud console. Currently
   * supported values:
   *
   * * `document` - Using suggestions generated from user-imported documents.
   * * `search-history` - Using suggestions generated from the past history of
   * [SearchService.Search][google.cloud.discoveryengine.v1beta.SearchService.Search]
   * API calls. Do not use it when there is no traffic for Search API.
   * * `user-event` - Using suggestions generated from user-imported search
   * events.
   * * `document-completable` - Using suggestions taken directly from
   * user-imported document fields marked as completable.
   *
   * Default values:
   *
   * * `document` is the default model for regular dataStores.
   * * `search-history` is the default model for site search dataStores.
   * </pre>
   *
   * <code>string query_model = 3;</code>
   *
   * @return The bytes for queryModel.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getQueryModelBytes() {
    java.lang.Object ref = queryModel_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      queryModel_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int USER_PSEUDO_ID_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object userPseudoId_ = "";
  /**
   *
   *
   * <pre>
   * A unique identifier for tracking visitors. For example, this could be
   * implemented with an HTTP cookie, which should be able to uniquely identify
   * a visitor on a single device. This unique identifier should not change if
   * the visitor logs in or out of the website.
   *
   * This field should NOT have a fixed value such as `unknown_visitor`.
   *
   * This should be the same identifier as
   * [UserEvent.user_pseudo_id][google.cloud.discoveryengine.v1beta.UserEvent.user_pseudo_id]
   * and
   * [SearchRequest.user_pseudo_id][google.cloud.discoveryengine.v1beta.SearchRequest.user_pseudo_id].
   *
   * The field must be a UTF-8 encoded string with a length limit of 128
   * characters. Otherwise, an `INVALID_ARGUMENT` error is returned.
   * </pre>
   *
   * <code>string user_pseudo_id = 4;</code>
   *
   * @return The userPseudoId.
   */
  @java.lang.Override
  public java.lang.String getUserPseudoId() {
    java.lang.Object ref = userPseudoId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      userPseudoId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A unique identifier for tracking visitors. For example, this could be
   * implemented with an HTTP cookie, which should be able to uniquely identify
   * a visitor on a single device. This unique identifier should not change if
   * the visitor logs in or out of the website.
   *
   * This field should NOT have a fixed value such as `unknown_visitor`.
   *
   * This should be the same identifier as
   * [UserEvent.user_pseudo_id][google.cloud.discoveryengine.v1beta.UserEvent.user_pseudo_id]
   * and
   * [SearchRequest.user_pseudo_id][google.cloud.discoveryengine.v1beta.SearchRequest.user_pseudo_id].
   *
   * The field must be a UTF-8 encoded string with a length limit of 128
   * characters. Otherwise, an `INVALID_ARGUMENT` error is returned.
   * </pre>
   *
   * <code>string user_pseudo_id = 4;</code>
   *
   * @return The bytes for userPseudoId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getUserPseudoIdBytes() {
    java.lang.Object ref = userPseudoId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      userPseudoId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int INCLUDE_TAIL_SUGGESTIONS_FIELD_NUMBER = 5;
  private boolean includeTailSuggestions_ = false;
  /**
   *
   *
   * <pre>
   * Indicates if tail suggestions should be returned if there are no
   * suggestions that match the full query. Even if set to true, if there are
   * suggestions that match the full query, those are returned and no
   * tail suggestions are returned.
   * </pre>
   *
   * <code>bool include_tail_suggestions = 5;</code>
   *
   * @return The includeTailSuggestions.
   */
  @java.lang.Override
  public boolean getIncludeTailSuggestions() {
    return includeTailSuggestions_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dataStore_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, dataStore_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(query_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, query_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(queryModel_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, queryModel_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(userPseudoId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, userPseudoId_);
    }
    if (includeTailSuggestions_ != false) {
      output.writeBool(5, includeTailSuggestions_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dataStore_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, dataStore_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(query_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, query_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(queryModel_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, queryModel_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(userPseudoId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, userPseudoId_);
    }
    if (includeTailSuggestions_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(5, includeTailSuggestions_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.discoveryengine.v1beta.CompleteQueryRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.discoveryengine.v1beta.CompleteQueryRequest other =
        (com.google.cloud.discoveryengine.v1beta.CompleteQueryRequest) obj;

    if (!getDataStore().equals(other.getDataStore())) return false;
    if (!getQuery().equals(other.getQuery())) return false;
    if (!getQueryModel().equals(other.getQueryModel())) return false;
    if (!getUserPseudoId().equals(other.getUserPseudoId())) return false;
    if (getIncludeTailSuggestions() != other.getIncludeTailSuggestions()) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + DATA_STORE_FIELD_NUMBER;
    hash = (53 * hash) + getDataStore().hashCode();
    hash = (37 * hash) + QUERY_FIELD_NUMBER;
    hash = (53 * hash) + getQuery().hashCode();
    hash = (37 * hash) + QUERY_MODEL_FIELD_NUMBER;
    hash = (53 * hash) + getQueryModel().hashCode();
    hash = (37 * hash) + USER_PSEUDO_ID_FIELD_NUMBER;
    hash = (53 * hash) + getUserPseudoId().hashCode();
    hash = (37 * hash) + INCLUDE_TAIL_SUGGESTIONS_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getIncludeTailSuggestions());
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.discoveryengine.v1beta.CompleteQueryRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1beta.CompleteQueryRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.CompleteQueryRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1beta.CompleteQueryRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.CompleteQueryRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1beta.CompleteQueryRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.CompleteQueryRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1beta.CompleteQueryRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.CompleteQueryRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1beta.CompleteQueryRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.CompleteQueryRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1beta.CompleteQueryRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.discoveryengine.v1beta.CompleteQueryRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request message for
   * [CompletionService.CompleteQuery][google.cloud.discoveryengine.v1beta.CompletionService.CompleteQuery]
   * method.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1beta.CompleteQueryRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.CompleteQueryRequest)
      com.google.cloud.discoveryengine.v1beta.CompleteQueryRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1beta.CompletionServiceProto
          .internal_static_google_cloud_discoveryengine_v1beta_CompleteQueryRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1beta.CompletionServiceProto
          .internal_static_google_cloud_discoveryengine_v1beta_CompleteQueryRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1beta.CompleteQueryRequest.class,
              com.google.cloud.discoveryengine.v1beta.CompleteQueryRequest.Builder.class);
    }

    // Construct using com.google.cloud.discoveryengine.v1beta.CompleteQueryRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      dataStore_ = "";
      query_ = "";
      queryModel_ = "";
      userPseudoId_ = "";
      includeTailSuggestions_ = false;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.discoveryengine.v1beta.CompletionServiceProto
          .internal_static_google_cloud_discoveryengine_v1beta_CompleteQueryRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.CompleteQueryRequest
        getDefaultInstanceForType() {
      return com.google.cloud.discoveryengine.v1beta.CompleteQueryRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.CompleteQueryRequest build() {
      com.google.cloud.discoveryengine.v1beta.CompleteQueryRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.CompleteQueryRequest buildPartial() {
      com.google.cloud.discoveryengine.v1beta.CompleteQueryRequest result =
          new com.google.cloud.discoveryengine.v1beta.CompleteQueryRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.discoveryengine.v1beta.CompleteQueryRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.dataStore_ = dataStore_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.query_ = query_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.queryModel_ = queryModel_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.userPseudoId_ = userPseudoId_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.includeTailSuggestions_ = includeTailSuggestions_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.discoveryengine.v1beta.CompleteQueryRequest) {
        return mergeFrom((com.google.cloud.discoveryengine.v1beta.CompleteQueryRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.discoveryengine.v1beta.CompleteQueryRequest other) {
      if (other
          == com.google.cloud.discoveryengine.v1beta.CompleteQueryRequest.getDefaultInstance())
        return this;
      if (!other.getDataStore().isEmpty()) {
        dataStore_ = other.dataStore_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getQuery().isEmpty()) {
        query_ = other.query_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getQueryModel().isEmpty()) {
        queryModel_ = other.queryModel_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getUserPseudoId().isEmpty()) {
        userPseudoId_ = other.userPseudoId_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.getIncludeTailSuggestions() != false) {
        setIncludeTailSuggestions(other.getIncludeTailSuggestions());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                dataStore_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                query_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                queryModel_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                userPseudoId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 40:
              {
                includeTailSuggestions_ = input.readBool();
                bitField0_ |= 0x00000010;
                break;
              } // case 40
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object dataStore_ = "";
    /**
     *
     *
     * <pre>
     * Required. The parent data store resource name for which the completion is
     * performed, such as
     * `projects/&#42;&#47;locations/global/collections/default_collection/dataStores/default_data_store`.
     * </pre>
     *
     * <code>
     * string data_store = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The dataStore.
     */
    public java.lang.String getDataStore() {
      java.lang.Object ref = dataStore_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        dataStore_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The parent data store resource name for which the completion is
     * performed, such as
     * `projects/&#42;&#47;locations/global/collections/default_collection/dataStores/default_data_store`.
     * </pre>
     *
     * <code>
     * string data_store = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for dataStore.
     */
    public com.google.protobuf.ByteString getDataStoreBytes() {
      java.lang.Object ref = dataStore_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        dataStore_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The parent data store resource name for which the completion is
     * performed, such as
     * `projects/&#42;&#47;locations/global/collections/default_collection/dataStores/default_data_store`.
     * </pre>
     *
     * <code>
     * string data_store = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The dataStore to set.
     * @return This builder for chaining.
     */
    public Builder setDataStore(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      dataStore_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The parent data store resource name for which the completion is
     * performed, such as
     * `projects/&#42;&#47;locations/global/collections/default_collection/dataStores/default_data_store`.
     * </pre>
     *
     * <code>
     * string data_store = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDataStore() {
      dataStore_ = getDefaultInstance().getDataStore();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The parent data store resource name for which the completion is
     * performed, such as
     * `projects/&#42;&#47;locations/global/collections/default_collection/dataStores/default_data_store`.
     * </pre>
     *
     * <code>
     * string data_store = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for dataStore to set.
     * @return This builder for chaining.
     */
    public Builder setDataStoreBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      dataStore_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object query_ = "";
    /**
     *
     *
     * <pre>
     * Required. The typeahead input used to fetch suggestions. Maximum length is
     * 128 characters.
     * </pre>
     *
     * <code>string query = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The query.
     */
    public java.lang.String getQuery() {
      java.lang.Object ref = query_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        query_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The typeahead input used to fetch suggestions. Maximum length is
     * 128 characters.
     * </pre>
     *
     * <code>string query = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for query.
     */
    public com.google.protobuf.ByteString getQueryBytes() {
      java.lang.Object ref = query_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        query_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The typeahead input used to fetch suggestions. Maximum length is
     * 128 characters.
     * </pre>
     *
     * <code>string query = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The query to set.
     * @return This builder for chaining.
     */
    public Builder setQuery(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      query_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The typeahead input used to fetch suggestions. Maximum length is
     * 128 characters.
     * </pre>
     *
     * <code>string query = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearQuery() {
      query_ = getDefaultInstance().getQuery();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The typeahead input used to fetch suggestions. Maximum length is
     * 128 characters.
     * </pre>
     *
     * <code>string query = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for query to set.
     * @return This builder for chaining.
     */
    public Builder setQueryBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      query_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object queryModel_ = "";
    /**
     *
     *
     * <pre>
     * Specifies the autocomplete data model. This overrides any model specified
     * in the Configuration &gt; Autocomplete section of the Cloud console. Currently
     * supported values:
     *
     * * `document` - Using suggestions generated from user-imported documents.
     * * `search-history` - Using suggestions generated from the past history of
     * [SearchService.Search][google.cloud.discoveryengine.v1beta.SearchService.Search]
     * API calls. Do not use it when there is no traffic for Search API.
     * * `user-event` - Using suggestions generated from user-imported search
     * events.
     * * `document-completable` - Using suggestions taken directly from
     * user-imported document fields marked as completable.
     *
     * Default values:
     *
     * * `document` is the default model for regular dataStores.
     * * `search-history` is the default model for site search dataStores.
     * </pre>
     *
     * <code>string query_model = 3;</code>
     *
     * @return The queryModel.
     */
    public java.lang.String getQueryModel() {
      java.lang.Object ref = queryModel_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        queryModel_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies the autocomplete data model. This overrides any model specified
     * in the Configuration &gt; Autocomplete section of the Cloud console. Currently
     * supported values:
     *
     * * `document` - Using suggestions generated from user-imported documents.
     * * `search-history` - Using suggestions generated from the past history of
     * [SearchService.Search][google.cloud.discoveryengine.v1beta.SearchService.Search]
     * API calls. Do not use it when there is no traffic for Search API.
     * * `user-event` - Using suggestions generated from user-imported search
     * events.
     * * `document-completable` - Using suggestions taken directly from
     * user-imported document fields marked as completable.
     *
     * Default values:
     *
     * * `document` is the default model for regular dataStores.
     * * `search-history` is the default model for site search dataStores.
     * </pre>
     *
     * <code>string query_model = 3;</code>
     *
     * @return The bytes for queryModel.
     */
    public com.google.protobuf.ByteString getQueryModelBytes() {
      java.lang.Object ref = queryModel_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        queryModel_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies the autocomplete data model. This overrides any model specified
     * in the Configuration &gt; Autocomplete section of the Cloud console. Currently
     * supported values:
     *
     * * `document` - Using suggestions generated from user-imported documents.
     * * `search-history` - Using suggestions generated from the past history of
     * [SearchService.Search][google.cloud.discoveryengine.v1beta.SearchService.Search]
     * API calls. Do not use it when there is no traffic for Search API.
     * * `user-event` - Using suggestions generated from user-imported search
     * events.
     * * `document-completable` - Using suggestions taken directly from
     * user-imported document fields marked as completable.
     *
     * Default values:
     *
     * * `document` is the default model for regular dataStores.
     * * `search-history` is the default model for site search dataStores.
     * </pre>
     *
     * <code>string query_model = 3;</code>
     *
     * @param value The queryModel to set.
     * @return This builder for chaining.
     */
    public Builder setQueryModel(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      queryModel_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the autocomplete data model. This overrides any model specified
     * in the Configuration &gt; Autocomplete section of the Cloud console. Currently
     * supported values:
     *
     * * `document` - Using suggestions generated from user-imported documents.
     * * `search-history` - Using suggestions generated from the past history of
     * [SearchService.Search][google.cloud.discoveryengine.v1beta.SearchService.Search]
     * API calls. Do not use it when there is no traffic for Search API.
     * * `user-event` - Using suggestions generated from user-imported search
     * events.
     * * `document-completable` - Using suggestions taken directly from
     * user-imported document fields marked as completable.
     *
     * Default values:
     *
     * * `document` is the default model for regular dataStores.
     * * `search-history` is the default model for site search dataStores.
     * </pre>
     *
     * <code>string query_model = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearQueryModel() {
      queryModel_ = getDefaultInstance().getQueryModel();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the autocomplete data model. This overrides any model specified
     * in the Configuration &gt; Autocomplete section of the Cloud console. Currently
     * supported values:
     *
     * * `document` - Using suggestions generated from user-imported documents.
     * * `search-history` - Using suggestions generated from the past history of
     * [SearchService.Search][google.cloud.discoveryengine.v1beta.SearchService.Search]
     * API calls. Do not use it when there is no traffic for Search API.
     * * `user-event` - Using suggestions generated from user-imported search
     * events.
     * * `document-completable` - Using suggestions taken directly from
     * user-imported document fields marked as completable.
     *
     * Default values:
     *
     * * `document` is the default model for regular dataStores.
     * * `search-history` is the default model for site search dataStores.
     * </pre>
     *
     * <code>string query_model = 3;</code>
     *
     * @param value The bytes for queryModel to set.
     * @return This builder for chaining.
     */
    public Builder setQueryModelBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      queryModel_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object userPseudoId_ = "";
    /**
     *
     *
     * <pre>
     * A unique identifier for tracking visitors. For example, this could be
     * implemented with an HTTP cookie, which should be able to uniquely identify
     * a visitor on a single device. This unique identifier should not change if
     * the visitor logs in or out of the website.
     *
     * This field should NOT have a fixed value such as `unknown_visitor`.
     *
     * This should be the same identifier as
     * [UserEvent.user_pseudo_id][google.cloud.discoveryengine.v1beta.UserEvent.user_pseudo_id]
     * and
     * [SearchRequest.user_pseudo_id][google.cloud.discoveryengine.v1beta.SearchRequest.user_pseudo_id].
     *
     * The field must be a UTF-8 encoded string with a length limit of 128
     * characters. Otherwise, an `INVALID_ARGUMENT` error is returned.
     * </pre>
     *
     * <code>string user_pseudo_id = 4;</code>
     *
     * @return The userPseudoId.
     */
    public java.lang.String getUserPseudoId() {
      java.lang.Object ref = userPseudoId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        userPseudoId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A unique identifier for tracking visitors. For example, this could be
     * implemented with an HTTP cookie, which should be able to uniquely identify
     * a visitor on a single device. This unique identifier should not change if
     * the visitor logs in or out of the website.
     *
     * This field should NOT have a fixed value such as `unknown_visitor`.
     *
     * This should be the same identifier as
     * [UserEvent.user_pseudo_id][google.cloud.discoveryengine.v1beta.UserEvent.user_pseudo_id]
     * and
     * [SearchRequest.user_pseudo_id][google.cloud.discoveryengine.v1beta.SearchRequest.user_pseudo_id].
     *
     * The field must be a UTF-8 encoded string with a length limit of 128
     * characters. Otherwise, an `INVALID_ARGUMENT` error is returned.
     * </pre>
     *
     * <code>string user_pseudo_id = 4;</code>
     *
     * @return The bytes for userPseudoId.
     */
    public com.google.protobuf.ByteString getUserPseudoIdBytes() {
      java.lang.Object ref = userPseudoId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        userPseudoId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A unique identifier for tracking visitors. For example, this could be
     * implemented with an HTTP cookie, which should be able to uniquely identify
     * a visitor on a single device. This unique identifier should not change if
     * the visitor logs in or out of the website.
     *
     * This field should NOT have a fixed value such as `unknown_visitor`.
     *
     * This should be the same identifier as
     * [UserEvent.user_pseudo_id][google.cloud.discoveryengine.v1beta.UserEvent.user_pseudo_id]
     * and
     * [SearchRequest.user_pseudo_id][google.cloud.discoveryengine.v1beta.SearchRequest.user_pseudo_id].
     *
     * The field must be a UTF-8 encoded string with a length limit of 128
     * characters. Otherwise, an `INVALID_ARGUMENT` error is returned.
     * </pre>
     *
     * <code>string user_pseudo_id = 4;</code>
     *
     * @param value The userPseudoId to set.
     * @return This builder for chaining.
     */
    public Builder setUserPseudoId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      userPseudoId_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A unique identifier for tracking visitors. For example, this could be
     * implemented with an HTTP cookie, which should be able to uniquely identify
     * a visitor on a single device. This unique identifier should not change if
     * the visitor logs in or out of the website.
     *
     * This field should NOT have a fixed value such as `unknown_visitor`.
     *
     * This should be the same identifier as
     * [UserEvent.user_pseudo_id][google.cloud.discoveryengine.v1beta.UserEvent.user_pseudo_id]
     * and
     * [SearchRequest.user_pseudo_id][google.cloud.discoveryengine.v1beta.SearchRequest.user_pseudo_id].
     *
     * The field must be a UTF-8 encoded string with a length limit of 128
     * characters. Otherwise, an `INVALID_ARGUMENT` error is returned.
     * </pre>
     *
     * <code>string user_pseudo_id = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUserPseudoId() {
      userPseudoId_ = getDefaultInstance().getUserPseudoId();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A unique identifier for tracking visitors. For example, this could be
     * implemented with an HTTP cookie, which should be able to uniquely identify
     * a visitor on a single device. This unique identifier should not change if
     * the visitor logs in or out of the website.
     *
     * This field should NOT have a fixed value such as `unknown_visitor`.
     *
     * This should be the same identifier as
     * [UserEvent.user_pseudo_id][google.cloud.discoveryengine.v1beta.UserEvent.user_pseudo_id]
     * and
     * [SearchRequest.user_pseudo_id][google.cloud.discoveryengine.v1beta.SearchRequest.user_pseudo_id].
     *
     * The field must be a UTF-8 encoded string with a length limit of 128
     * characters. Otherwise, an `INVALID_ARGUMENT` error is returned.
     * </pre>
     *
     * <code>string user_pseudo_id = 4;</code>
     *
     * @param value The bytes for userPseudoId to set.
     * @return This builder for chaining.
     */
    public Builder setUserPseudoIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      userPseudoId_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private boolean includeTailSuggestions_;
    /**
     *
     *
     * <pre>
     * Indicates if tail suggestions should be returned if there are no
     * suggestions that match the full query. Even if set to true, if there are
     * suggestions that match the full query, those are returned and no
     * tail suggestions are returned.
     * </pre>
     *
     * <code>bool include_tail_suggestions = 5;</code>
     *
     * @return The includeTailSuggestions.
     */
    @java.lang.Override
    public boolean getIncludeTailSuggestions() {
      return includeTailSuggestions_;
    }
    /**
     *
     *
     * <pre>
     * Indicates if tail suggestions should be returned if there are no
     * suggestions that match the full query. Even if set to true, if there are
     * suggestions that match the full query, those are returned and no
     * tail suggestions are returned.
     * </pre>
     *
     * <code>bool include_tail_suggestions = 5;</code>
     *
     * @param value The includeTailSuggestions to set.
     * @return This builder for chaining.
     */
    public Builder setIncludeTailSuggestions(boolean value) {

      includeTailSuggestions_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indicates if tail suggestions should be returned if there are no
     * suggestions that match the full query. Even if set to true, if there are
     * suggestions that match the full query, those are returned and no
     * tail suggestions are returned.
     * </pre>
     *
     * <code>bool include_tail_suggestions = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIncludeTailSuggestions() {
      bitField0_ = (bitField0_ & ~0x00000010);
      includeTailSuggestions_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.CompleteQueryRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.CompleteQueryRequest)
  private static final com.google.cloud.discoveryengine.v1beta.CompleteQueryRequest
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.discoveryengine.v1beta.CompleteQueryRequest();
  }

  public static com.google.cloud.discoveryengine.v1beta.CompleteQueryRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CompleteQueryRequest> PARSER =
      new com.google.protobuf.AbstractParser<CompleteQueryRequest>() {
        @java.lang.Override
        public CompleteQueryRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<CompleteQueryRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CompleteQueryRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.CompleteQueryRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
