/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/discoveryengine/v1beta/completion.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.discoveryengine.v1beta;

/**
 *
 *
 * <pre>
 * Autocomplete suggestions that are imported from Customer.
 * </pre>
 *
 * Protobuf type {@code google.cloud.discoveryengine.v1beta.CompletionSuggestion}
 */
public final class CompletionSuggestion extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.CompletionSuggestion)
    CompletionSuggestionOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use CompletionSuggestion.newBuilder() to construct.
  private CompletionSuggestion(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private CompletionSuggestion() {
    suggestion_ = "";
    languageCode_ = "";
    groupId_ = "";
    alternativePhrases_ = com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new CompletionSuggestion();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.discoveryengine.v1beta.CompletionProto
        .internal_static_google_cloud_discoveryengine_v1beta_CompletionSuggestion_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.discoveryengine.v1beta.CompletionProto
        .internal_static_google_cloud_discoveryengine_v1beta_CompletionSuggestion_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.discoveryengine.v1beta.CompletionSuggestion.class,
            com.google.cloud.discoveryengine.v1beta.CompletionSuggestion.Builder.class);
  }

  private int rankingInfoCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object rankingInfo_;

  public enum RankingInfoCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    GLOBAL_SCORE(2),
    FREQUENCY(3),
    RANKINGINFO_NOT_SET(0);
    private final int value;

    private RankingInfoCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static RankingInfoCase valueOf(int value) {
      return forNumber(value);
    }

    public static RankingInfoCase forNumber(int value) {
      switch (value) {
        case 2:
          return GLOBAL_SCORE;
        case 3:
          return FREQUENCY;
        case 0:
          return RANKINGINFO_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public RankingInfoCase getRankingInfoCase() {
    return RankingInfoCase.forNumber(rankingInfoCase_);
  }

  public static final int GLOBAL_SCORE_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * Global score of this suggestion. Control how this suggestion would be
   * scored / ranked.
   * </pre>
   *
   * <code>double global_score = 2;</code>
   *
   * @return Whether the globalScore field is set.
   */
  @java.lang.Override
  public boolean hasGlobalScore() {
    return rankingInfoCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * Global score of this suggestion. Control how this suggestion would be
   * scored / ranked.
   * </pre>
   *
   * <code>double global_score = 2;</code>
   *
   * @return The globalScore.
   */
  @java.lang.Override
  public double getGlobalScore() {
    if (rankingInfoCase_ == 2) {
      return (java.lang.Double) rankingInfo_;
    }
    return 0D;
  }

  public static final int FREQUENCY_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * Frequency of this suggestion. Will be used to rank suggestions when score
   * is not available.
   * </pre>
   *
   * <code>int64 frequency = 3;</code>
   *
   * @return Whether the frequency field is set.
   */
  @java.lang.Override
  public boolean hasFrequency() {
    return rankingInfoCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * Frequency of this suggestion. Will be used to rank suggestions when score
   * is not available.
   * </pre>
   *
   * <code>int64 frequency = 3;</code>
   *
   * @return The frequency.
   */
  @java.lang.Override
  public long getFrequency() {
    if (rankingInfoCase_ == 3) {
      return (java.lang.Long) rankingInfo_;
    }
    return 0L;
  }

  public static final int SUGGESTION_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object suggestion_ = "";
  /**
   *
   *
   * <pre>
   * Required. The suggestion text.
   * </pre>
   *
   * <code>string suggestion = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The suggestion.
   */
  @java.lang.Override
  public java.lang.String getSuggestion() {
    java.lang.Object ref = suggestion_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      suggestion_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The suggestion text.
   * </pre>
   *
   * <code>string suggestion = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for suggestion.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSuggestionBytes() {
    java.lang.Object ref = suggestion_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      suggestion_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LANGUAGE_CODE_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object languageCode_ = "";
  /**
   *
   *
   * <pre>
   * BCP-47 language code of this suggestion.
   * </pre>
   *
   * <code>string language_code = 4;</code>
   *
   * @return The languageCode.
   */
  @java.lang.Override
  public java.lang.String getLanguageCode() {
    java.lang.Object ref = languageCode_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      languageCode_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * BCP-47 language code of this suggestion.
   * </pre>
   *
   * <code>string language_code = 4;</code>
   *
   * @return The bytes for languageCode.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLanguageCodeBytes() {
    java.lang.Object ref = languageCode_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      languageCode_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int GROUP_ID_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object groupId_ = "";
  /**
   *
   *
   * <pre>
   * If two suggestions have the same groupId, they will not be
   * returned together. Instead the one ranked higher will be returned. This can
   * be used to deduplicate semantically identical suggestions.
   * </pre>
   *
   * <code>string group_id = 5;</code>
   *
   * @return The groupId.
   */
  @java.lang.Override
  public java.lang.String getGroupId() {
    java.lang.Object ref = groupId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      groupId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * If two suggestions have the same groupId, they will not be
   * returned together. Instead the one ranked higher will be returned. This can
   * be used to deduplicate semantically identical suggestions.
   * </pre>
   *
   * <code>string group_id = 5;</code>
   *
   * @return The bytes for groupId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getGroupIdBytes() {
    java.lang.Object ref = groupId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      groupId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int GROUP_SCORE_FIELD_NUMBER = 6;
  private double groupScore_ = 0D;
  /**
   *
   *
   * <pre>
   * The score of this suggestion within its group.
   * </pre>
   *
   * <code>double group_score = 6;</code>
   *
   * @return The groupScore.
   */
  @java.lang.Override
  public double getGroupScore() {
    return groupScore_;
  }

  public static final int ALTERNATIVE_PHRASES_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList alternativePhrases_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Alternative matching phrases for this suggestion.
   * </pre>
   *
   * <code>repeated string alternative_phrases = 7;</code>
   *
   * @return A list containing the alternativePhrases.
   */
  public com.google.protobuf.ProtocolStringList getAlternativePhrasesList() {
    return alternativePhrases_;
  }
  /**
   *
   *
   * <pre>
   * Alternative matching phrases for this suggestion.
   * </pre>
   *
   * <code>repeated string alternative_phrases = 7;</code>
   *
   * @return The count of alternativePhrases.
   */
  public int getAlternativePhrasesCount() {
    return alternativePhrases_.size();
  }
  /**
   *
   *
   * <pre>
   * Alternative matching phrases for this suggestion.
   * </pre>
   *
   * <code>repeated string alternative_phrases = 7;</code>
   *
   * @param index The index of the element to return.
   * @return The alternativePhrases at the given index.
   */
  public java.lang.String getAlternativePhrases(int index) {
    return alternativePhrases_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Alternative matching phrases for this suggestion.
   * </pre>
   *
   * <code>repeated string alternative_phrases = 7;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the alternativePhrases at the given index.
   */
  public com.google.protobuf.ByteString getAlternativePhrasesBytes(int index) {
    return alternativePhrases_.getByteString(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(suggestion_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, suggestion_);
    }
    if (rankingInfoCase_ == 2) {
      output.writeDouble(2, (double) ((java.lang.Double) rankingInfo_));
    }
    if (rankingInfoCase_ == 3) {
      output.writeInt64(3, (long) ((java.lang.Long) rankingInfo_));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(languageCode_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, languageCode_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(groupId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, groupId_);
    }
    if (java.lang.Double.doubleToRawLongBits(groupScore_) != 0) {
      output.writeDouble(6, groupScore_);
    }
    for (int i = 0; i < alternativePhrases_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, alternativePhrases_.getRaw(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(suggestion_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, suggestion_);
    }
    if (rankingInfoCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeDoubleSize(
              2, (double) ((java.lang.Double) rankingInfo_));
    }
    if (rankingInfoCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeInt64Size(
              3, (long) ((java.lang.Long) rankingInfo_));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(languageCode_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, languageCode_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(groupId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, groupId_);
    }
    if (java.lang.Double.doubleToRawLongBits(groupScore_) != 0) {
      size += com.google.protobuf.CodedOutputStream.computeDoubleSize(6, groupScore_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < alternativePhrases_.size(); i++) {
        dataSize += computeStringSizeNoTag(alternativePhrases_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getAlternativePhrasesList().size();
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.discoveryengine.v1beta.CompletionSuggestion)) {
      return super.equals(obj);
    }
    com.google.cloud.discoveryengine.v1beta.CompletionSuggestion other =
        (com.google.cloud.discoveryengine.v1beta.CompletionSuggestion) obj;

    if (!getSuggestion().equals(other.getSuggestion())) return false;
    if (!getLanguageCode().equals(other.getLanguageCode())) return false;
    if (!getGroupId().equals(other.getGroupId())) return false;
    if (java.lang.Double.doubleToLongBits(getGroupScore())
        != java.lang.Double.doubleToLongBits(other.getGroupScore())) return false;
    if (!getAlternativePhrasesList().equals(other.getAlternativePhrasesList())) return false;
    if (!getRankingInfoCase().equals(other.getRankingInfoCase())) return false;
    switch (rankingInfoCase_) {
      case 2:
        if (java.lang.Double.doubleToLongBits(getGlobalScore())
            != java.lang.Double.doubleToLongBits(other.getGlobalScore())) return false;
        break;
      case 3:
        if (getFrequency() != other.getFrequency()) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + SUGGESTION_FIELD_NUMBER;
    hash = (53 * hash) + getSuggestion().hashCode();
    hash = (37 * hash) + LANGUAGE_CODE_FIELD_NUMBER;
    hash = (53 * hash) + getLanguageCode().hashCode();
    hash = (37 * hash) + GROUP_ID_FIELD_NUMBER;
    hash = (53 * hash) + getGroupId().hashCode();
    hash = (37 * hash) + GROUP_SCORE_FIELD_NUMBER;
    hash =
        (53 * hash)
            + com.google.protobuf.Internal.hashLong(
                java.lang.Double.doubleToLongBits(getGroupScore()));
    if (getAlternativePhrasesCount() > 0) {
      hash = (37 * hash) + ALTERNATIVE_PHRASES_FIELD_NUMBER;
      hash = (53 * hash) + getAlternativePhrasesList().hashCode();
    }
    switch (rankingInfoCase_) {
      case 2:
        hash = (37 * hash) + GLOBAL_SCORE_FIELD_NUMBER;
        hash =
            (53 * hash)
                + com.google.protobuf.Internal.hashLong(
                    java.lang.Double.doubleToLongBits(getGlobalScore()));
        break;
      case 3:
        hash = (37 * hash) + FREQUENCY_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getFrequency());
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.discoveryengine.v1beta.CompletionSuggestion parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1beta.CompletionSuggestion parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.CompletionSuggestion parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1beta.CompletionSuggestion parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.CompletionSuggestion parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1beta.CompletionSuggestion parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.CompletionSuggestion parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1beta.CompletionSuggestion parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.CompletionSuggestion parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1beta.CompletionSuggestion parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.CompletionSuggestion parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1beta.CompletionSuggestion parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.discoveryengine.v1beta.CompletionSuggestion prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Autocomplete suggestions that are imported from Customer.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1beta.CompletionSuggestion}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.CompletionSuggestion)
      com.google.cloud.discoveryengine.v1beta.CompletionSuggestionOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1beta.CompletionProto
          .internal_static_google_cloud_discoveryengine_v1beta_CompletionSuggestion_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1beta.CompletionProto
          .internal_static_google_cloud_discoveryengine_v1beta_CompletionSuggestion_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1beta.CompletionSuggestion.class,
              com.google.cloud.discoveryengine.v1beta.CompletionSuggestion.Builder.class);
    }

    // Construct using com.google.cloud.discoveryengine.v1beta.CompletionSuggestion.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      suggestion_ = "";
      languageCode_ = "";
      groupId_ = "";
      groupScore_ = 0D;
      alternativePhrases_ = com.google.protobuf.LazyStringArrayList.emptyList();
      rankingInfoCase_ = 0;
      rankingInfo_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.discoveryengine.v1beta.CompletionProto
          .internal_static_google_cloud_discoveryengine_v1beta_CompletionSuggestion_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.CompletionSuggestion
        getDefaultInstanceForType() {
      return com.google.cloud.discoveryengine.v1beta.CompletionSuggestion.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.CompletionSuggestion build() {
      com.google.cloud.discoveryengine.v1beta.CompletionSuggestion result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.CompletionSuggestion buildPartial() {
      com.google.cloud.discoveryengine.v1beta.CompletionSuggestion result =
          new com.google.cloud.discoveryengine.v1beta.CompletionSuggestion(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.discoveryengine.v1beta.CompletionSuggestion result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.suggestion_ = suggestion_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.languageCode_ = languageCode_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.groupId_ = groupId_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.groupScore_ = groupScore_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        alternativePhrases_.makeImmutable();
        result.alternativePhrases_ = alternativePhrases_;
      }
    }

    private void buildPartialOneofs(
        com.google.cloud.discoveryengine.v1beta.CompletionSuggestion result) {
      result.rankingInfoCase_ = rankingInfoCase_;
      result.rankingInfo_ = this.rankingInfo_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.discoveryengine.v1beta.CompletionSuggestion) {
        return mergeFrom((com.google.cloud.discoveryengine.v1beta.CompletionSuggestion) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.discoveryengine.v1beta.CompletionSuggestion other) {
      if (other
          == com.google.cloud.discoveryengine.v1beta.CompletionSuggestion.getDefaultInstance())
        return this;
      if (!other.getSuggestion().isEmpty()) {
        suggestion_ = other.suggestion_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getLanguageCode().isEmpty()) {
        languageCode_ = other.languageCode_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.getGroupId().isEmpty()) {
        groupId_ = other.groupId_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (other.getGroupScore() != 0D) {
        setGroupScore(other.getGroupScore());
      }
      if (!other.alternativePhrases_.isEmpty()) {
        if (alternativePhrases_.isEmpty()) {
          alternativePhrases_ = other.alternativePhrases_;
          bitField0_ |= 0x00000040;
        } else {
          ensureAlternativePhrasesIsMutable();
          alternativePhrases_.addAll(other.alternativePhrases_);
        }
        onChanged();
      }
      switch (other.getRankingInfoCase()) {
        case GLOBAL_SCORE:
          {
            setGlobalScore(other.getGlobalScore());
            break;
          }
        case FREQUENCY:
          {
            setFrequency(other.getFrequency());
            break;
          }
        case RANKINGINFO_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                suggestion_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 10
            case 17:
              {
                rankingInfo_ = input.readDouble();
                rankingInfoCase_ = 2;
                break;
              } // case 17
            case 24:
              {
                rankingInfo_ = input.readInt64();
                rankingInfoCase_ = 3;
                break;
              } // case 24
            case 34:
              {
                languageCode_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                groupId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 49:
              {
                groupScore_ = input.readDouble();
                bitField0_ |= 0x00000020;
                break;
              } // case 49
            case 58:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureAlternativePhrasesIsMutable();
                alternativePhrases_.add(s);
                break;
              } // case 58
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int rankingInfoCase_ = 0;
    private java.lang.Object rankingInfo_;

    public RankingInfoCase getRankingInfoCase() {
      return RankingInfoCase.forNumber(rankingInfoCase_);
    }

    public Builder clearRankingInfo() {
      rankingInfoCase_ = 0;
      rankingInfo_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    /**
     *
     *
     * <pre>
     * Global score of this suggestion. Control how this suggestion would be
     * scored / ranked.
     * </pre>
     *
     * <code>double global_score = 2;</code>
     *
     * @return Whether the globalScore field is set.
     */
    public boolean hasGlobalScore() {
      return rankingInfoCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Global score of this suggestion. Control how this suggestion would be
     * scored / ranked.
     * </pre>
     *
     * <code>double global_score = 2;</code>
     *
     * @return The globalScore.
     */
    public double getGlobalScore() {
      if (rankingInfoCase_ == 2) {
        return (java.lang.Double) rankingInfo_;
      }
      return 0D;
    }
    /**
     *
     *
     * <pre>
     * Global score of this suggestion. Control how this suggestion would be
     * scored / ranked.
     * </pre>
     *
     * <code>double global_score = 2;</code>
     *
     * @param value The globalScore to set.
     * @return This builder for chaining.
     */
    public Builder setGlobalScore(double value) {

      rankingInfoCase_ = 2;
      rankingInfo_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Global score of this suggestion. Control how this suggestion would be
     * scored / ranked.
     * </pre>
     *
     * <code>double global_score = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearGlobalScore() {
      if (rankingInfoCase_ == 2) {
        rankingInfoCase_ = 0;
        rankingInfo_ = null;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Frequency of this suggestion. Will be used to rank suggestions when score
     * is not available.
     * </pre>
     *
     * <code>int64 frequency = 3;</code>
     *
     * @return Whether the frequency field is set.
     */
    public boolean hasFrequency() {
      return rankingInfoCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * Frequency of this suggestion. Will be used to rank suggestions when score
     * is not available.
     * </pre>
     *
     * <code>int64 frequency = 3;</code>
     *
     * @return The frequency.
     */
    public long getFrequency() {
      if (rankingInfoCase_ == 3) {
        return (java.lang.Long) rankingInfo_;
      }
      return 0L;
    }
    /**
     *
     *
     * <pre>
     * Frequency of this suggestion. Will be used to rank suggestions when score
     * is not available.
     * </pre>
     *
     * <code>int64 frequency = 3;</code>
     *
     * @param value The frequency to set.
     * @return This builder for chaining.
     */
    public Builder setFrequency(long value) {

      rankingInfoCase_ = 3;
      rankingInfo_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Frequency of this suggestion. Will be used to rank suggestions when score
     * is not available.
     * </pre>
     *
     * <code>int64 frequency = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFrequency() {
      if (rankingInfoCase_ == 3) {
        rankingInfoCase_ = 0;
        rankingInfo_ = null;
        onChanged();
      }
      return this;
    }

    private java.lang.Object suggestion_ = "";
    /**
     *
     *
     * <pre>
     * Required. The suggestion text.
     * </pre>
     *
     * <code>string suggestion = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The suggestion.
     */
    public java.lang.String getSuggestion() {
      java.lang.Object ref = suggestion_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        suggestion_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The suggestion text.
     * </pre>
     *
     * <code>string suggestion = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for suggestion.
     */
    public com.google.protobuf.ByteString getSuggestionBytes() {
      java.lang.Object ref = suggestion_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        suggestion_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The suggestion text.
     * </pre>
     *
     * <code>string suggestion = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The suggestion to set.
     * @return This builder for chaining.
     */
    public Builder setSuggestion(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      suggestion_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The suggestion text.
     * </pre>
     *
     * <code>string suggestion = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSuggestion() {
      suggestion_ = getDefaultInstance().getSuggestion();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The suggestion text.
     * </pre>
     *
     * <code>string suggestion = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for suggestion to set.
     * @return This builder for chaining.
     */
    public Builder setSuggestionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      suggestion_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object languageCode_ = "";
    /**
     *
     *
     * <pre>
     * BCP-47 language code of this suggestion.
     * </pre>
     *
     * <code>string language_code = 4;</code>
     *
     * @return The languageCode.
     */
    public java.lang.String getLanguageCode() {
      java.lang.Object ref = languageCode_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        languageCode_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * BCP-47 language code of this suggestion.
     * </pre>
     *
     * <code>string language_code = 4;</code>
     *
     * @return The bytes for languageCode.
     */
    public com.google.protobuf.ByteString getLanguageCodeBytes() {
      java.lang.Object ref = languageCode_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        languageCode_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * BCP-47 language code of this suggestion.
     * </pre>
     *
     * <code>string language_code = 4;</code>
     *
     * @param value The languageCode to set.
     * @return This builder for chaining.
     */
    public Builder setLanguageCode(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      languageCode_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * BCP-47 language code of this suggestion.
     * </pre>
     *
     * <code>string language_code = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLanguageCode() {
      languageCode_ = getDefaultInstance().getLanguageCode();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * BCP-47 language code of this suggestion.
     * </pre>
     *
     * <code>string language_code = 4;</code>
     *
     * @param value The bytes for languageCode to set.
     * @return This builder for chaining.
     */
    public Builder setLanguageCodeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      languageCode_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object groupId_ = "";
    /**
     *
     *
     * <pre>
     * If two suggestions have the same groupId, they will not be
     * returned together. Instead the one ranked higher will be returned. This can
     * be used to deduplicate semantically identical suggestions.
     * </pre>
     *
     * <code>string group_id = 5;</code>
     *
     * @return The groupId.
     */
    public java.lang.String getGroupId() {
      java.lang.Object ref = groupId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        groupId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * If two suggestions have the same groupId, they will not be
     * returned together. Instead the one ranked higher will be returned. This can
     * be used to deduplicate semantically identical suggestions.
     * </pre>
     *
     * <code>string group_id = 5;</code>
     *
     * @return The bytes for groupId.
     */
    public com.google.protobuf.ByteString getGroupIdBytes() {
      java.lang.Object ref = groupId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        groupId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * If two suggestions have the same groupId, they will not be
     * returned together. Instead the one ranked higher will be returned. This can
     * be used to deduplicate semantically identical suggestions.
     * </pre>
     *
     * <code>string group_id = 5;</code>
     *
     * @param value The groupId to set.
     * @return This builder for chaining.
     */
    public Builder setGroupId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      groupId_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If two suggestions have the same groupId, they will not be
     * returned together. Instead the one ranked higher will be returned. This can
     * be used to deduplicate semantically identical suggestions.
     * </pre>
     *
     * <code>string group_id = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearGroupId() {
      groupId_ = getDefaultInstance().getGroupId();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If two suggestions have the same groupId, they will not be
     * returned together. Instead the one ranked higher will be returned. This can
     * be used to deduplicate semantically identical suggestions.
     * </pre>
     *
     * <code>string group_id = 5;</code>
     *
     * @param value The bytes for groupId to set.
     * @return This builder for chaining.
     */
    public Builder setGroupIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      groupId_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private double groupScore_;
    /**
     *
     *
     * <pre>
     * The score of this suggestion within its group.
     * </pre>
     *
     * <code>double group_score = 6;</code>
     *
     * @return The groupScore.
     */
    @java.lang.Override
    public double getGroupScore() {
      return groupScore_;
    }
    /**
     *
     *
     * <pre>
     * The score of this suggestion within its group.
     * </pre>
     *
     * <code>double group_score = 6;</code>
     *
     * @param value The groupScore to set.
     * @return This builder for chaining.
     */
    public Builder setGroupScore(double value) {

      groupScore_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The score of this suggestion within its group.
     * </pre>
     *
     * <code>double group_score = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearGroupScore() {
      bitField0_ = (bitField0_ & ~0x00000020);
      groupScore_ = 0D;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList alternativePhrases_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureAlternativePhrasesIsMutable() {
      if (!alternativePhrases_.isModifiable()) {
        alternativePhrases_ = new com.google.protobuf.LazyStringArrayList(alternativePhrases_);
      }
      bitField0_ |= 0x00000040;
    }
    /**
     *
     *
     * <pre>
     * Alternative matching phrases for this suggestion.
     * </pre>
     *
     * <code>repeated string alternative_phrases = 7;</code>
     *
     * @return A list containing the alternativePhrases.
     */
    public com.google.protobuf.ProtocolStringList getAlternativePhrasesList() {
      alternativePhrases_.makeImmutable();
      return alternativePhrases_;
    }
    /**
     *
     *
     * <pre>
     * Alternative matching phrases for this suggestion.
     * </pre>
     *
     * <code>repeated string alternative_phrases = 7;</code>
     *
     * @return The count of alternativePhrases.
     */
    public int getAlternativePhrasesCount() {
      return alternativePhrases_.size();
    }
    /**
     *
     *
     * <pre>
     * Alternative matching phrases for this suggestion.
     * </pre>
     *
     * <code>repeated string alternative_phrases = 7;</code>
     *
     * @param index The index of the element to return.
     * @return The alternativePhrases at the given index.
     */
    public java.lang.String getAlternativePhrases(int index) {
      return alternativePhrases_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Alternative matching phrases for this suggestion.
     * </pre>
     *
     * <code>repeated string alternative_phrases = 7;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the alternativePhrases at the given index.
     */
    public com.google.protobuf.ByteString getAlternativePhrasesBytes(int index) {
      return alternativePhrases_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Alternative matching phrases for this suggestion.
     * </pre>
     *
     * <code>repeated string alternative_phrases = 7;</code>
     *
     * @param index The index to set the value at.
     * @param value The alternativePhrases to set.
     * @return This builder for chaining.
     */
    public Builder setAlternativePhrases(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureAlternativePhrasesIsMutable();
      alternativePhrases_.set(index, value);
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Alternative matching phrases for this suggestion.
     * </pre>
     *
     * <code>repeated string alternative_phrases = 7;</code>
     *
     * @param value The alternativePhrases to add.
     * @return This builder for chaining.
     */
    public Builder addAlternativePhrases(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureAlternativePhrasesIsMutable();
      alternativePhrases_.add(value);
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Alternative matching phrases for this suggestion.
     * </pre>
     *
     * <code>repeated string alternative_phrases = 7;</code>
     *
     * @param values The alternativePhrases to add.
     * @return This builder for chaining.
     */
    public Builder addAllAlternativePhrases(java.lang.Iterable<java.lang.String> values) {
      ensureAlternativePhrasesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, alternativePhrases_);
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Alternative matching phrases for this suggestion.
     * </pre>
     *
     * <code>repeated string alternative_phrases = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAlternativePhrases() {
      alternativePhrases_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000040);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Alternative matching phrases for this suggestion.
     * </pre>
     *
     * <code>repeated string alternative_phrases = 7;</code>
     *
     * @param value The bytes of the alternativePhrases to add.
     * @return This builder for chaining.
     */
    public Builder addAlternativePhrasesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureAlternativePhrasesIsMutable();
      alternativePhrases_.add(value);
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.CompletionSuggestion)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.CompletionSuggestion)
  private static final com.google.cloud.discoveryengine.v1beta.CompletionSuggestion
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.discoveryengine.v1beta.CompletionSuggestion();
  }

  public static com.google.cloud.discoveryengine.v1beta.CompletionSuggestion getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CompletionSuggestion> PARSER =
      new com.google.protobuf.AbstractParser<CompletionSuggestion>() {
        @java.lang.Override
        public CompletionSuggestion parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<CompletionSuggestion> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CompletionSuggestion> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.CompletionSuggestion getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
