/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/discoveryengine/v1beta/evaluation.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.discoveryengine.v1beta;

/**
 *
 *
 * <pre>
 * An evaluation is a single execution (or run) of an evaluation process. It
 * encapsulates the state of the evaluation and the resulting data.
 * </pre>
 *
 * Protobuf type {@code google.cloud.discoveryengine.v1beta.Evaluation}
 */
public final class Evaluation extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.Evaluation)
    EvaluationOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Evaluation.newBuilder() to construct.
  private Evaluation(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Evaluation() {
    name_ = "";
    state_ = 0;
    errorSamples_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Evaluation();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.discoveryengine.v1beta.EvaluationProto
        .internal_static_google_cloud_discoveryengine_v1beta_Evaluation_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.discoveryengine.v1beta.EvaluationProto
        .internal_static_google_cloud_discoveryengine_v1beta_Evaluation_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.discoveryengine.v1beta.Evaluation.class,
            com.google.cloud.discoveryengine.v1beta.Evaluation.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Describes the state of an evaluation.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.discoveryengine.v1beta.Evaluation.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * The evaluation is unspecified.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The service is preparing to run the evaluation.
     * </pre>
     *
     * <code>PENDING = 1;</code>
     */
    PENDING(1),
    /**
     *
     *
     * <pre>
     * The evaluation is in progress.
     * </pre>
     *
     * <code>RUNNING = 2;</code>
     */
    RUNNING(2),
    /**
     *
     *
     * <pre>
     * The evaluation completed successfully.
     * </pre>
     *
     * <code>SUCCEEDED = 3;</code>
     */
    SUCCEEDED(3),
    /**
     *
     *
     * <pre>
     * The evaluation failed.
     * </pre>
     *
     * <code>FAILED = 4;</code>
     */
    FAILED(4),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * The evaluation is unspecified.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    public static final int STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The service is preparing to run the evaluation.
     * </pre>
     *
     * <code>PENDING = 1;</code>
     */
    public static final int PENDING_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The evaluation is in progress.
     * </pre>
     *
     * <code>RUNNING = 2;</code>
     */
    public static final int RUNNING_VALUE = 2;
    /**
     *
     *
     * <pre>
     * The evaluation completed successfully.
     * </pre>
     *
     * <code>SUCCEEDED = 3;</code>
     */
    public static final int SUCCEEDED_VALUE = 3;
    /**
     *
     *
     * <pre>
     * The evaluation failed.
     * </pre>
     *
     * <code>FAILED = 4;</code>
     */
    public static final int FAILED_VALUE = 4;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return STATE_UNSPECIFIED;
        case 1:
          return PENDING;
        case 2:
          return RUNNING;
        case 3:
          return SUCCEEDED;
        case 4:
          return FAILED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1beta.Evaluation.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.discoveryengine.v1beta.Evaluation.State)
  }

  public interface EvaluationSpecOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. The search request that is used to perform the evaluation.
     *
     * Only the following fields within SearchRequest are supported; if any
     * other fields are provided, an UNSUPPORTED error will be returned:
     *
     * * [SearchRequest.serving_config][google.cloud.discoveryengine.v1beta.SearchRequest.serving_config]
     * * [SearchRequest.branch][google.cloud.discoveryengine.v1beta.SearchRequest.branch]
     * * [SearchRequest.canonical_filter][google.cloud.discoveryengine.v1beta.SearchRequest.canonical_filter]
     * * [SearchRequest.query_expansion_spec][google.cloud.discoveryengine.v1beta.SearchRequest.query_expansion_spec]
     * * [SearchRequest.spell_correction_spec][google.cloud.discoveryengine.v1beta.SearchRequest.spell_correction_spec]
     * * [SearchRequest.content_search_spec][google.cloud.discoveryengine.v1beta.SearchRequest.content_search_spec]
     * * [SearchRequest.user_pseudo_id][google.cloud.discoveryengine.v1beta.SearchRequest.user_pseudo_id]
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.SearchRequest search_request = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the searchRequest field is set.
     */
    boolean hasSearchRequest();
    /**
     *
     *
     * <pre>
     * Required. The search request that is used to perform the evaluation.
     *
     * Only the following fields within SearchRequest are supported; if any
     * other fields are provided, an UNSUPPORTED error will be returned:
     *
     * * [SearchRequest.serving_config][google.cloud.discoveryengine.v1beta.SearchRequest.serving_config]
     * * [SearchRequest.branch][google.cloud.discoveryengine.v1beta.SearchRequest.branch]
     * * [SearchRequest.canonical_filter][google.cloud.discoveryengine.v1beta.SearchRequest.canonical_filter]
     * * [SearchRequest.query_expansion_spec][google.cloud.discoveryengine.v1beta.SearchRequest.query_expansion_spec]
     * * [SearchRequest.spell_correction_spec][google.cloud.discoveryengine.v1beta.SearchRequest.spell_correction_spec]
     * * [SearchRequest.content_search_spec][google.cloud.discoveryengine.v1beta.SearchRequest.content_search_spec]
     * * [SearchRequest.user_pseudo_id][google.cloud.discoveryengine.v1beta.SearchRequest.user_pseudo_id]
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.SearchRequest search_request = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The searchRequest.
     */
    com.google.cloud.discoveryengine.v1beta.SearchRequest getSearchRequest();
    /**
     *
     *
     * <pre>
     * Required. The search request that is used to perform the evaluation.
     *
     * Only the following fields within SearchRequest are supported; if any
     * other fields are provided, an UNSUPPORTED error will be returned:
     *
     * * [SearchRequest.serving_config][google.cloud.discoveryengine.v1beta.SearchRequest.serving_config]
     * * [SearchRequest.branch][google.cloud.discoveryengine.v1beta.SearchRequest.branch]
     * * [SearchRequest.canonical_filter][google.cloud.discoveryengine.v1beta.SearchRequest.canonical_filter]
     * * [SearchRequest.query_expansion_spec][google.cloud.discoveryengine.v1beta.SearchRequest.query_expansion_spec]
     * * [SearchRequest.spell_correction_spec][google.cloud.discoveryengine.v1beta.SearchRequest.spell_correction_spec]
     * * [SearchRequest.content_search_spec][google.cloud.discoveryengine.v1beta.SearchRequest.content_search_spec]
     * * [SearchRequest.user_pseudo_id][google.cloud.discoveryengine.v1beta.SearchRequest.user_pseudo_id]
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.SearchRequest search_request = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    com.google.cloud.discoveryengine.v1beta.SearchRequestOrBuilder getSearchRequestOrBuilder();

    /**
     *
     *
     * <pre>
     * Required. The specification of the query set.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec.QuerySetSpec query_set_spec = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the querySetSpec field is set.
     */
    boolean hasQuerySetSpec();
    /**
     *
     *
     * <pre>
     * Required. The specification of the query set.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec.QuerySetSpec query_set_spec = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The querySetSpec.
     */
    com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec.QuerySetSpec
        getQuerySetSpec();
    /**
     *
     *
     * <pre>
     * Required. The specification of the query set.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec.QuerySetSpec query_set_spec = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec.QuerySetSpecOrBuilder
        getQuerySetSpecOrBuilder();

    com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec.SearchSpecCase
        getSearchSpecCase();
  }
  /**
   *
   *
   * <pre>
   * Describes the specification of the evaluation.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec}
   */
  public static final class EvaluationSpec extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec)
      EvaluationSpecOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use EvaluationSpec.newBuilder() to construct.
    private EvaluationSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private EvaluationSpec() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new EvaluationSpec();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1beta.EvaluationProto
          .internal_static_google_cloud_discoveryengine_v1beta_Evaluation_EvaluationSpec_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1beta.EvaluationProto
          .internal_static_google_cloud_discoveryengine_v1beta_Evaluation_EvaluationSpec_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec.class,
              com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec.Builder.class);
    }

    public interface QuerySetSpecOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec.QuerySetSpec)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Required. The full resource name of the
       * [SampleQuerySet][google.cloud.discoveryengine.v1beta.SampleQuerySet]
       * used for the evaluation, in the format of
       * `projects/{project}/locations/{location}/sampleQuerySets/{sampleQuerySet}`.
       * </pre>
       *
       * <code>
       * string sample_query_set = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The sampleQuerySet.
       */
      java.lang.String getSampleQuerySet();
      /**
       *
       *
       * <pre>
       * Required. The full resource name of the
       * [SampleQuerySet][google.cloud.discoveryengine.v1beta.SampleQuerySet]
       * used for the evaluation, in the format of
       * `projects/{project}/locations/{location}/sampleQuerySets/{sampleQuerySet}`.
       * </pre>
       *
       * <code>
       * string sample_query_set = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The bytes for sampleQuerySet.
       */
      com.google.protobuf.ByteString getSampleQuerySetBytes();
    }
    /**
     *
     *
     * <pre>
     * Describes the specification of the query set.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec.QuerySetSpec}
     */
    public static final class QuerySetSpec extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec.QuerySetSpec)
        QuerySetSpecOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use QuerySetSpec.newBuilder() to construct.
      private QuerySetSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private QuerySetSpec() {
        sampleQuerySet_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new QuerySetSpec();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1beta.EvaluationProto
            .internal_static_google_cloud_discoveryengine_v1beta_Evaluation_EvaluationSpec_QuerySetSpec_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1beta.EvaluationProto
            .internal_static_google_cloud_discoveryengine_v1beta_Evaluation_EvaluationSpec_QuerySetSpec_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec.QuerySetSpec
                    .class,
                com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec.QuerySetSpec
                    .Builder.class);
      }

      public static final int SAMPLE_QUERY_SET_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private volatile java.lang.Object sampleQuerySet_ = "";
      /**
       *
       *
       * <pre>
       * Required. The full resource name of the
       * [SampleQuerySet][google.cloud.discoveryengine.v1beta.SampleQuerySet]
       * used for the evaluation, in the format of
       * `projects/{project}/locations/{location}/sampleQuerySets/{sampleQuerySet}`.
       * </pre>
       *
       * <code>
       * string sample_query_set = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The sampleQuerySet.
       */
      @java.lang.Override
      public java.lang.String getSampleQuerySet() {
        java.lang.Object ref = sampleQuerySet_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          sampleQuerySet_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The full resource name of the
       * [SampleQuerySet][google.cloud.discoveryengine.v1beta.SampleQuerySet]
       * used for the evaluation, in the format of
       * `projects/{project}/locations/{location}/sampleQuerySets/{sampleQuerySet}`.
       * </pre>
       *
       * <code>
       * string sample_query_set = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The bytes for sampleQuerySet.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getSampleQuerySetBytes() {
        java.lang.Object ref = sampleQuerySet_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          sampleQuerySet_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sampleQuerySet_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, sampleQuerySet_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sampleQuerySet_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, sampleQuerySet_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec.QuerySetSpec)) {
          return super.equals(obj);
        }
        com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec.QuerySetSpec other =
            (com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec.QuerySetSpec) obj;

        if (!getSampleQuerySet().equals(other.getSampleQuerySet())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + SAMPLE_QUERY_SET_FIELD_NUMBER;
        hash = (53 * hash) + getSampleQuerySet().hashCode();
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec.QuerySetSpec
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec.QuerySetSpec
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec.QuerySetSpec
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec.QuerySetSpec
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec.QuerySetSpec
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec.QuerySetSpec
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec.QuerySetSpec
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec.QuerySetSpec
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec.QuerySetSpec
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec.QuerySetSpec
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec.QuerySetSpec
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec.QuerySetSpec
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec.QuerySetSpec
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Describes the specification of the query set.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec.QuerySetSpec}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec.QuerySetSpec)
          com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec.QuerySetSpecOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.discoveryengine.v1beta.EvaluationProto
              .internal_static_google_cloud_discoveryengine_v1beta_Evaluation_EvaluationSpec_QuerySetSpec_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.discoveryengine.v1beta.EvaluationProto
              .internal_static_google_cloud_discoveryengine_v1beta_Evaluation_EvaluationSpec_QuerySetSpec_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec.QuerySetSpec
                      .class,
                  com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec.QuerySetSpec
                      .Builder.class);
        }

        // Construct using
        // com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec.QuerySetSpec.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          sampleQuerySet_ = "";
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.discoveryengine.v1beta.EvaluationProto
              .internal_static_google_cloud_discoveryengine_v1beta_Evaluation_EvaluationSpec_QuerySetSpec_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec.QuerySetSpec
            getDefaultInstanceForType() {
          return com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec.QuerySetSpec
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec.QuerySetSpec
            build() {
          com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec.QuerySetSpec result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec.QuerySetSpec
            buildPartial() {
          com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec.QuerySetSpec result =
              new com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec.QuerySetSpec(
                  this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec.QuerySetSpec result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.sampleQuerySet_ = sampleQuerySet_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec.QuerySetSpec) {
            return mergeFrom(
                (com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec.QuerySetSpec)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec.QuerySetSpec other) {
          if (other
              == com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec.QuerySetSpec
                  .getDefaultInstance()) return this;
          if (!other.getSampleQuerySet().isEmpty()) {
            sampleQuerySet_ = other.sampleQuerySet_;
            bitField0_ |= 0x00000001;
            onChanged();
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    sampleQuerySet_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.lang.Object sampleQuerySet_ = "";
        /**
         *
         *
         * <pre>
         * Required. The full resource name of the
         * [SampleQuerySet][google.cloud.discoveryengine.v1beta.SampleQuerySet]
         * used for the evaluation, in the format of
         * `projects/{project}/locations/{location}/sampleQuerySets/{sampleQuerySet}`.
         * </pre>
         *
         * <code>
         * string sample_query_set = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
         * </code>
         *
         * @return The sampleQuerySet.
         */
        public java.lang.String getSampleQuerySet() {
          java.lang.Object ref = sampleQuerySet_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            sampleQuerySet_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. The full resource name of the
         * [SampleQuerySet][google.cloud.discoveryengine.v1beta.SampleQuerySet]
         * used for the evaluation, in the format of
         * `projects/{project}/locations/{location}/sampleQuerySets/{sampleQuerySet}`.
         * </pre>
         *
         * <code>
         * string sample_query_set = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
         * </code>
         *
         * @return The bytes for sampleQuerySet.
         */
        public com.google.protobuf.ByteString getSampleQuerySetBytes() {
          java.lang.Object ref = sampleQuerySet_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            sampleQuerySet_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. The full resource name of the
         * [SampleQuerySet][google.cloud.discoveryengine.v1beta.SampleQuerySet]
         * used for the evaluation, in the format of
         * `projects/{project}/locations/{location}/sampleQuerySets/{sampleQuerySet}`.
         * </pre>
         *
         * <code>
         * string sample_query_set = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
         * </code>
         *
         * @param value The sampleQuerySet to set.
         * @return This builder for chaining.
         */
        public Builder setSampleQuerySet(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          sampleQuerySet_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The full resource name of the
         * [SampleQuerySet][google.cloud.discoveryengine.v1beta.SampleQuerySet]
         * used for the evaluation, in the format of
         * `projects/{project}/locations/{location}/sampleQuerySets/{sampleQuerySet}`.
         * </pre>
         *
         * <code>
         * string sample_query_set = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
         * </code>
         *
         * @return This builder for chaining.
         */
        public Builder clearSampleQuerySet() {
          sampleQuerySet_ = getDefaultInstance().getSampleQuerySet();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The full resource name of the
         * [SampleQuerySet][google.cloud.discoveryengine.v1beta.SampleQuerySet]
         * used for the evaluation, in the format of
         * `projects/{project}/locations/{location}/sampleQuerySets/{sampleQuerySet}`.
         * </pre>
         *
         * <code>
         * string sample_query_set = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
         * </code>
         *
         * @param value The bytes for sampleQuerySet to set.
         * @return This builder for chaining.
         */
        public Builder setSampleQuerySetBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          sampleQuerySet_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec.QuerySetSpec)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec.QuerySetSpec)
      private static final com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec
              .QuerySetSpec
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec.QuerySetSpec();
      }

      public static com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec.QuerySetSpec
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<QuerySetSpec> PARSER =
          new com.google.protobuf.AbstractParser<QuerySetSpec>() {
            @java.lang.Override
            public QuerySetSpec parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<QuerySetSpec> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<QuerySetSpec> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec.QuerySetSpec
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    private int bitField0_;
    private int searchSpecCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object searchSpec_;

    public enum SearchSpecCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      SEARCH_REQUEST(2),
      SEARCHSPEC_NOT_SET(0);
      private final int value;

      private SearchSpecCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static SearchSpecCase valueOf(int value) {
        return forNumber(value);
      }

      public static SearchSpecCase forNumber(int value) {
        switch (value) {
          case 2:
            return SEARCH_REQUEST;
          case 0:
            return SEARCHSPEC_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public SearchSpecCase getSearchSpecCase() {
      return SearchSpecCase.forNumber(searchSpecCase_);
    }

    public static final int SEARCH_REQUEST_FIELD_NUMBER = 2;
    /**
     *
     *
     * <pre>
     * Required. The search request that is used to perform the evaluation.
     *
     * Only the following fields within SearchRequest are supported; if any
     * other fields are provided, an UNSUPPORTED error will be returned:
     *
     * * [SearchRequest.serving_config][google.cloud.discoveryengine.v1beta.SearchRequest.serving_config]
     * * [SearchRequest.branch][google.cloud.discoveryengine.v1beta.SearchRequest.branch]
     * * [SearchRequest.canonical_filter][google.cloud.discoveryengine.v1beta.SearchRequest.canonical_filter]
     * * [SearchRequest.query_expansion_spec][google.cloud.discoveryengine.v1beta.SearchRequest.query_expansion_spec]
     * * [SearchRequest.spell_correction_spec][google.cloud.discoveryengine.v1beta.SearchRequest.spell_correction_spec]
     * * [SearchRequest.content_search_spec][google.cloud.discoveryengine.v1beta.SearchRequest.content_search_spec]
     * * [SearchRequest.user_pseudo_id][google.cloud.discoveryengine.v1beta.SearchRequest.user_pseudo_id]
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.SearchRequest search_request = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the searchRequest field is set.
     */
    @java.lang.Override
    public boolean hasSearchRequest() {
      return searchSpecCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Required. The search request that is used to perform the evaluation.
     *
     * Only the following fields within SearchRequest are supported; if any
     * other fields are provided, an UNSUPPORTED error will be returned:
     *
     * * [SearchRequest.serving_config][google.cloud.discoveryengine.v1beta.SearchRequest.serving_config]
     * * [SearchRequest.branch][google.cloud.discoveryengine.v1beta.SearchRequest.branch]
     * * [SearchRequest.canonical_filter][google.cloud.discoveryengine.v1beta.SearchRequest.canonical_filter]
     * * [SearchRequest.query_expansion_spec][google.cloud.discoveryengine.v1beta.SearchRequest.query_expansion_spec]
     * * [SearchRequest.spell_correction_spec][google.cloud.discoveryengine.v1beta.SearchRequest.spell_correction_spec]
     * * [SearchRequest.content_search_spec][google.cloud.discoveryengine.v1beta.SearchRequest.content_search_spec]
     * * [SearchRequest.user_pseudo_id][google.cloud.discoveryengine.v1beta.SearchRequest.user_pseudo_id]
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.SearchRequest search_request = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The searchRequest.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.SearchRequest getSearchRequest() {
      if (searchSpecCase_ == 2) {
        return (com.google.cloud.discoveryengine.v1beta.SearchRequest) searchSpec_;
      }
      return com.google.cloud.discoveryengine.v1beta.SearchRequest.getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * Required. The search request that is used to perform the evaluation.
     *
     * Only the following fields within SearchRequest are supported; if any
     * other fields are provided, an UNSUPPORTED error will be returned:
     *
     * * [SearchRequest.serving_config][google.cloud.discoveryengine.v1beta.SearchRequest.serving_config]
     * * [SearchRequest.branch][google.cloud.discoveryengine.v1beta.SearchRequest.branch]
     * * [SearchRequest.canonical_filter][google.cloud.discoveryengine.v1beta.SearchRequest.canonical_filter]
     * * [SearchRequest.query_expansion_spec][google.cloud.discoveryengine.v1beta.SearchRequest.query_expansion_spec]
     * * [SearchRequest.spell_correction_spec][google.cloud.discoveryengine.v1beta.SearchRequest.spell_correction_spec]
     * * [SearchRequest.content_search_spec][google.cloud.discoveryengine.v1beta.SearchRequest.content_search_spec]
     * * [SearchRequest.user_pseudo_id][google.cloud.discoveryengine.v1beta.SearchRequest.user_pseudo_id]
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.SearchRequest search_request = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.SearchRequestOrBuilder
        getSearchRequestOrBuilder() {
      if (searchSpecCase_ == 2) {
        return (com.google.cloud.discoveryengine.v1beta.SearchRequest) searchSpec_;
      }
      return com.google.cloud.discoveryengine.v1beta.SearchRequest.getDefaultInstance();
    }

    public static final int QUERY_SET_SPEC_FIELD_NUMBER = 1;
    private com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec.QuerySetSpec
        querySetSpec_;
    /**
     *
     *
     * <pre>
     * Required. The specification of the query set.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec.QuerySetSpec query_set_spec = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the querySetSpec field is set.
     */
    @java.lang.Override
    public boolean hasQuerySetSpec() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. The specification of the query set.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec.QuerySetSpec query_set_spec = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The querySetSpec.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec.QuerySetSpec
        getQuerySetSpec() {
      return querySetSpec_ == null
          ? com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec.QuerySetSpec
              .getDefaultInstance()
          : querySetSpec_;
    }
    /**
     *
     *
     * <pre>
     * Required. The specification of the query set.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec.QuerySetSpec query_set_spec = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec.QuerySetSpecOrBuilder
        getQuerySetSpecOrBuilder() {
      return querySetSpec_ == null
          ? com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec.QuerySetSpec
              .getDefaultInstance()
          : querySetSpec_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getQuerySetSpec());
      }
      if (searchSpecCase_ == 2) {
        output.writeMessage(2, (com.google.cloud.discoveryengine.v1beta.SearchRequest) searchSpec_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getQuerySetSpec());
      }
      if (searchSpecCase_ == 2) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                2, (com.google.cloud.discoveryengine.v1beta.SearchRequest) searchSpec_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec)) {
        return super.equals(obj);
      }
      com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec other =
          (com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec) obj;

      if (hasQuerySetSpec() != other.hasQuerySetSpec()) return false;
      if (hasQuerySetSpec()) {
        if (!getQuerySetSpec().equals(other.getQuerySetSpec())) return false;
      }
      if (!getSearchSpecCase().equals(other.getSearchSpecCase())) return false;
      switch (searchSpecCase_) {
        case 2:
          if (!getSearchRequest().equals(other.getSearchRequest())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasQuerySetSpec()) {
        hash = (37 * hash) + QUERY_SET_SPEC_FIELD_NUMBER;
        hash = (53 * hash) + getQuerySetSpec().hashCode();
      }
      switch (searchSpecCase_) {
        case 2:
          hash = (37 * hash) + SEARCH_REQUEST_FIELD_NUMBER;
          hash = (53 * hash) + getSearchRequest().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Describes the specification of the evaluation.
     * </pre>
     *
     * Protobuf type {@code google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec)
        com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpecOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1beta.EvaluationProto
            .internal_static_google_cloud_discoveryengine_v1beta_Evaluation_EvaluationSpec_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1beta.EvaluationProto
            .internal_static_google_cloud_discoveryengine_v1beta_Evaluation_EvaluationSpec_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec.class,
                com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec.Builder.class);
      }

      // Construct using
      // com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getQuerySetSpecFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (searchRequestBuilder_ != null) {
          searchRequestBuilder_.clear();
        }
        querySetSpec_ = null;
        if (querySetSpecBuilder_ != null) {
          querySetSpecBuilder_.dispose();
          querySetSpecBuilder_ = null;
        }
        searchSpecCase_ = 0;
        searchSpec_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.discoveryengine.v1beta.EvaluationProto
            .internal_static_google_cloud_discoveryengine_v1beta_Evaluation_EvaluationSpec_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec
          getDefaultInstanceForType() {
        return com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec build() {
        com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec buildPartial() {
        com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec result =
            new com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.querySetSpec_ =
              querySetSpecBuilder_ == null ? querySetSpec_ : querySetSpecBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      private void buildPartialOneofs(
          com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec result) {
        result.searchSpecCase_ = searchSpecCase_;
        result.searchSpec_ = this.searchSpec_;
        if (searchSpecCase_ == 2 && searchRequestBuilder_ != null) {
          result.searchSpec_ = searchRequestBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec) {
          return mergeFrom(
              (com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec other) {
        if (other
            == com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec
                .getDefaultInstance()) return this;
        if (other.hasQuerySetSpec()) {
          mergeQuerySetSpec(other.getQuerySetSpec());
        }
        switch (other.getSearchSpecCase()) {
          case SEARCH_REQUEST:
            {
              mergeSearchRequest(other.getSearchRequest());
              break;
            }
          case SEARCHSPEC_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getQuerySetSpecFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(getSearchRequestFieldBuilder().getBuilder(), extensionRegistry);
                  searchSpecCase_ = 2;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int searchSpecCase_ = 0;
      private java.lang.Object searchSpec_;

      public SearchSpecCase getSearchSpecCase() {
        return SearchSpecCase.forNumber(searchSpecCase_);
      }

      public Builder clearSearchSpec() {
        searchSpecCase_ = 0;
        searchSpec_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.discoveryengine.v1beta.SearchRequest,
              com.google.cloud.discoveryengine.v1beta.SearchRequest.Builder,
              com.google.cloud.discoveryengine.v1beta.SearchRequestOrBuilder>
          searchRequestBuilder_;
      /**
       *
       *
       * <pre>
       * Required. The search request that is used to perform the evaluation.
       *
       * Only the following fields within SearchRequest are supported; if any
       * other fields are provided, an UNSUPPORTED error will be returned:
       *
       * * [SearchRequest.serving_config][google.cloud.discoveryengine.v1beta.SearchRequest.serving_config]
       * * [SearchRequest.branch][google.cloud.discoveryengine.v1beta.SearchRequest.branch]
       * * [SearchRequest.canonical_filter][google.cloud.discoveryengine.v1beta.SearchRequest.canonical_filter]
       * * [SearchRequest.query_expansion_spec][google.cloud.discoveryengine.v1beta.SearchRequest.query_expansion_spec]
       * * [SearchRequest.spell_correction_spec][google.cloud.discoveryengine.v1beta.SearchRequest.spell_correction_spec]
       * * [SearchRequest.content_search_spec][google.cloud.discoveryengine.v1beta.SearchRequest.content_search_spec]
       * * [SearchRequest.user_pseudo_id][google.cloud.discoveryengine.v1beta.SearchRequest.user_pseudo_id]
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.SearchRequest search_request = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return Whether the searchRequest field is set.
       */
      @java.lang.Override
      public boolean hasSearchRequest() {
        return searchSpecCase_ == 2;
      }
      /**
       *
       *
       * <pre>
       * Required. The search request that is used to perform the evaluation.
       *
       * Only the following fields within SearchRequest are supported; if any
       * other fields are provided, an UNSUPPORTED error will be returned:
       *
       * * [SearchRequest.serving_config][google.cloud.discoveryengine.v1beta.SearchRequest.serving_config]
       * * [SearchRequest.branch][google.cloud.discoveryengine.v1beta.SearchRequest.branch]
       * * [SearchRequest.canonical_filter][google.cloud.discoveryengine.v1beta.SearchRequest.canonical_filter]
       * * [SearchRequest.query_expansion_spec][google.cloud.discoveryengine.v1beta.SearchRequest.query_expansion_spec]
       * * [SearchRequest.spell_correction_spec][google.cloud.discoveryengine.v1beta.SearchRequest.spell_correction_spec]
       * * [SearchRequest.content_search_spec][google.cloud.discoveryengine.v1beta.SearchRequest.content_search_spec]
       * * [SearchRequest.user_pseudo_id][google.cloud.discoveryengine.v1beta.SearchRequest.user_pseudo_id]
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.SearchRequest search_request = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The searchRequest.
       */
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.SearchRequest getSearchRequest() {
        if (searchRequestBuilder_ == null) {
          if (searchSpecCase_ == 2) {
            return (com.google.cloud.discoveryengine.v1beta.SearchRequest) searchSpec_;
          }
          return com.google.cloud.discoveryengine.v1beta.SearchRequest.getDefaultInstance();
        } else {
          if (searchSpecCase_ == 2) {
            return searchRequestBuilder_.getMessage();
          }
          return com.google.cloud.discoveryengine.v1beta.SearchRequest.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The search request that is used to perform the evaluation.
       *
       * Only the following fields within SearchRequest are supported; if any
       * other fields are provided, an UNSUPPORTED error will be returned:
       *
       * * [SearchRequest.serving_config][google.cloud.discoveryengine.v1beta.SearchRequest.serving_config]
       * * [SearchRequest.branch][google.cloud.discoveryengine.v1beta.SearchRequest.branch]
       * * [SearchRequest.canonical_filter][google.cloud.discoveryengine.v1beta.SearchRequest.canonical_filter]
       * * [SearchRequest.query_expansion_spec][google.cloud.discoveryengine.v1beta.SearchRequest.query_expansion_spec]
       * * [SearchRequest.spell_correction_spec][google.cloud.discoveryengine.v1beta.SearchRequest.spell_correction_spec]
       * * [SearchRequest.content_search_spec][google.cloud.discoveryengine.v1beta.SearchRequest.content_search_spec]
       * * [SearchRequest.user_pseudo_id][google.cloud.discoveryengine.v1beta.SearchRequest.user_pseudo_id]
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.SearchRequest search_request = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setSearchRequest(com.google.cloud.discoveryengine.v1beta.SearchRequest value) {
        if (searchRequestBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          searchSpec_ = value;
          onChanged();
        } else {
          searchRequestBuilder_.setMessage(value);
        }
        searchSpecCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The search request that is used to perform the evaluation.
       *
       * Only the following fields within SearchRequest are supported; if any
       * other fields are provided, an UNSUPPORTED error will be returned:
       *
       * * [SearchRequest.serving_config][google.cloud.discoveryengine.v1beta.SearchRequest.serving_config]
       * * [SearchRequest.branch][google.cloud.discoveryengine.v1beta.SearchRequest.branch]
       * * [SearchRequest.canonical_filter][google.cloud.discoveryengine.v1beta.SearchRequest.canonical_filter]
       * * [SearchRequest.query_expansion_spec][google.cloud.discoveryengine.v1beta.SearchRequest.query_expansion_spec]
       * * [SearchRequest.spell_correction_spec][google.cloud.discoveryengine.v1beta.SearchRequest.spell_correction_spec]
       * * [SearchRequest.content_search_spec][google.cloud.discoveryengine.v1beta.SearchRequest.content_search_spec]
       * * [SearchRequest.user_pseudo_id][google.cloud.discoveryengine.v1beta.SearchRequest.user_pseudo_id]
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.SearchRequest search_request = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setSearchRequest(
          com.google.cloud.discoveryengine.v1beta.SearchRequest.Builder builderForValue) {
        if (searchRequestBuilder_ == null) {
          searchSpec_ = builderForValue.build();
          onChanged();
        } else {
          searchRequestBuilder_.setMessage(builderForValue.build());
        }
        searchSpecCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The search request that is used to perform the evaluation.
       *
       * Only the following fields within SearchRequest are supported; if any
       * other fields are provided, an UNSUPPORTED error will be returned:
       *
       * * [SearchRequest.serving_config][google.cloud.discoveryengine.v1beta.SearchRequest.serving_config]
       * * [SearchRequest.branch][google.cloud.discoveryengine.v1beta.SearchRequest.branch]
       * * [SearchRequest.canonical_filter][google.cloud.discoveryengine.v1beta.SearchRequest.canonical_filter]
       * * [SearchRequest.query_expansion_spec][google.cloud.discoveryengine.v1beta.SearchRequest.query_expansion_spec]
       * * [SearchRequest.spell_correction_spec][google.cloud.discoveryengine.v1beta.SearchRequest.spell_correction_spec]
       * * [SearchRequest.content_search_spec][google.cloud.discoveryengine.v1beta.SearchRequest.content_search_spec]
       * * [SearchRequest.user_pseudo_id][google.cloud.discoveryengine.v1beta.SearchRequest.user_pseudo_id]
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.SearchRequest search_request = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder mergeSearchRequest(
          com.google.cloud.discoveryengine.v1beta.SearchRequest value) {
        if (searchRequestBuilder_ == null) {
          if (searchSpecCase_ == 2
              && searchSpec_
                  != com.google.cloud.discoveryengine.v1beta.SearchRequest.getDefaultInstance()) {
            searchSpec_ =
                com.google.cloud.discoveryengine.v1beta.SearchRequest.newBuilder(
                        (com.google.cloud.discoveryengine.v1beta.SearchRequest) searchSpec_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            searchSpec_ = value;
          }
          onChanged();
        } else {
          if (searchSpecCase_ == 2) {
            searchRequestBuilder_.mergeFrom(value);
          } else {
            searchRequestBuilder_.setMessage(value);
          }
        }
        searchSpecCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The search request that is used to perform the evaluation.
       *
       * Only the following fields within SearchRequest are supported; if any
       * other fields are provided, an UNSUPPORTED error will be returned:
       *
       * * [SearchRequest.serving_config][google.cloud.discoveryengine.v1beta.SearchRequest.serving_config]
       * * [SearchRequest.branch][google.cloud.discoveryengine.v1beta.SearchRequest.branch]
       * * [SearchRequest.canonical_filter][google.cloud.discoveryengine.v1beta.SearchRequest.canonical_filter]
       * * [SearchRequest.query_expansion_spec][google.cloud.discoveryengine.v1beta.SearchRequest.query_expansion_spec]
       * * [SearchRequest.spell_correction_spec][google.cloud.discoveryengine.v1beta.SearchRequest.spell_correction_spec]
       * * [SearchRequest.content_search_spec][google.cloud.discoveryengine.v1beta.SearchRequest.content_search_spec]
       * * [SearchRequest.user_pseudo_id][google.cloud.discoveryengine.v1beta.SearchRequest.user_pseudo_id]
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.SearchRequest search_request = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder clearSearchRequest() {
        if (searchRequestBuilder_ == null) {
          if (searchSpecCase_ == 2) {
            searchSpecCase_ = 0;
            searchSpec_ = null;
            onChanged();
          }
        } else {
          if (searchSpecCase_ == 2) {
            searchSpecCase_ = 0;
            searchSpec_ = null;
          }
          searchRequestBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The search request that is used to perform the evaluation.
       *
       * Only the following fields within SearchRequest are supported; if any
       * other fields are provided, an UNSUPPORTED error will be returned:
       *
       * * [SearchRequest.serving_config][google.cloud.discoveryengine.v1beta.SearchRequest.serving_config]
       * * [SearchRequest.branch][google.cloud.discoveryengine.v1beta.SearchRequest.branch]
       * * [SearchRequest.canonical_filter][google.cloud.discoveryengine.v1beta.SearchRequest.canonical_filter]
       * * [SearchRequest.query_expansion_spec][google.cloud.discoveryengine.v1beta.SearchRequest.query_expansion_spec]
       * * [SearchRequest.spell_correction_spec][google.cloud.discoveryengine.v1beta.SearchRequest.spell_correction_spec]
       * * [SearchRequest.content_search_spec][google.cloud.discoveryengine.v1beta.SearchRequest.content_search_spec]
       * * [SearchRequest.user_pseudo_id][google.cloud.discoveryengine.v1beta.SearchRequest.user_pseudo_id]
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.SearchRequest search_request = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.discoveryengine.v1beta.SearchRequest.Builder
          getSearchRequestBuilder() {
        return getSearchRequestFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Required. The search request that is used to perform the evaluation.
       *
       * Only the following fields within SearchRequest are supported; if any
       * other fields are provided, an UNSUPPORTED error will be returned:
       *
       * * [SearchRequest.serving_config][google.cloud.discoveryengine.v1beta.SearchRequest.serving_config]
       * * [SearchRequest.branch][google.cloud.discoveryengine.v1beta.SearchRequest.branch]
       * * [SearchRequest.canonical_filter][google.cloud.discoveryengine.v1beta.SearchRequest.canonical_filter]
       * * [SearchRequest.query_expansion_spec][google.cloud.discoveryengine.v1beta.SearchRequest.query_expansion_spec]
       * * [SearchRequest.spell_correction_spec][google.cloud.discoveryengine.v1beta.SearchRequest.spell_correction_spec]
       * * [SearchRequest.content_search_spec][google.cloud.discoveryengine.v1beta.SearchRequest.content_search_spec]
       * * [SearchRequest.user_pseudo_id][google.cloud.discoveryengine.v1beta.SearchRequest.user_pseudo_id]
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.SearchRequest search_request = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.SearchRequestOrBuilder
          getSearchRequestOrBuilder() {
        if ((searchSpecCase_ == 2) && (searchRequestBuilder_ != null)) {
          return searchRequestBuilder_.getMessageOrBuilder();
        } else {
          if (searchSpecCase_ == 2) {
            return (com.google.cloud.discoveryengine.v1beta.SearchRequest) searchSpec_;
          }
          return com.google.cloud.discoveryengine.v1beta.SearchRequest.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The search request that is used to perform the evaluation.
       *
       * Only the following fields within SearchRequest are supported; if any
       * other fields are provided, an UNSUPPORTED error will be returned:
       *
       * * [SearchRequest.serving_config][google.cloud.discoveryengine.v1beta.SearchRequest.serving_config]
       * * [SearchRequest.branch][google.cloud.discoveryengine.v1beta.SearchRequest.branch]
       * * [SearchRequest.canonical_filter][google.cloud.discoveryengine.v1beta.SearchRequest.canonical_filter]
       * * [SearchRequest.query_expansion_spec][google.cloud.discoveryengine.v1beta.SearchRequest.query_expansion_spec]
       * * [SearchRequest.spell_correction_spec][google.cloud.discoveryengine.v1beta.SearchRequest.spell_correction_spec]
       * * [SearchRequest.content_search_spec][google.cloud.discoveryengine.v1beta.SearchRequest.content_search_spec]
       * * [SearchRequest.user_pseudo_id][google.cloud.discoveryengine.v1beta.SearchRequest.user_pseudo_id]
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.SearchRequest search_request = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.discoveryengine.v1beta.SearchRequest,
              com.google.cloud.discoveryengine.v1beta.SearchRequest.Builder,
              com.google.cloud.discoveryengine.v1beta.SearchRequestOrBuilder>
          getSearchRequestFieldBuilder() {
        if (searchRequestBuilder_ == null) {
          if (!(searchSpecCase_ == 2)) {
            searchSpec_ =
                com.google.cloud.discoveryengine.v1beta.SearchRequest.getDefaultInstance();
          }
          searchRequestBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.discoveryengine.v1beta.SearchRequest,
                  com.google.cloud.discoveryengine.v1beta.SearchRequest.Builder,
                  com.google.cloud.discoveryengine.v1beta.SearchRequestOrBuilder>(
                  (com.google.cloud.discoveryengine.v1beta.SearchRequest) searchSpec_,
                  getParentForChildren(),
                  isClean());
          searchSpec_ = null;
        }
        searchSpecCase_ = 2;
        onChanged();
        return searchRequestBuilder_;
      }

      private com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec.QuerySetSpec
          querySetSpec_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec.QuerySetSpec,
              com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec.QuerySetSpec
                  .Builder,
              com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec
                  .QuerySetSpecOrBuilder>
          querySetSpecBuilder_;
      /**
       *
       *
       * <pre>
       * Required. The specification of the query set.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec.QuerySetSpec query_set_spec = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return Whether the querySetSpec field is set.
       */
      public boolean hasQuerySetSpec() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * Required. The specification of the query set.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec.QuerySetSpec query_set_spec = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The querySetSpec.
       */
      public com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec.QuerySetSpec
          getQuerySetSpec() {
        if (querySetSpecBuilder_ == null) {
          return querySetSpec_ == null
              ? com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec.QuerySetSpec
                  .getDefaultInstance()
              : querySetSpec_;
        } else {
          return querySetSpecBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The specification of the query set.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec.QuerySetSpec query_set_spec = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setQuerySetSpec(
          com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec.QuerySetSpec value) {
        if (querySetSpecBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          querySetSpec_ = value;
        } else {
          querySetSpecBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The specification of the query set.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec.QuerySetSpec query_set_spec = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setQuerySetSpec(
          com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec.QuerySetSpec.Builder
              builderForValue) {
        if (querySetSpecBuilder_ == null) {
          querySetSpec_ = builderForValue.build();
        } else {
          querySetSpecBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The specification of the query set.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec.QuerySetSpec query_set_spec = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder mergeQuerySetSpec(
          com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec.QuerySetSpec value) {
        if (querySetSpecBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && querySetSpec_ != null
              && querySetSpec_
                  != com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec.QuerySetSpec
                      .getDefaultInstance()) {
            getQuerySetSpecBuilder().mergeFrom(value);
          } else {
            querySetSpec_ = value;
          }
        } else {
          querySetSpecBuilder_.mergeFrom(value);
        }
        if (querySetSpec_ != null) {
          bitField0_ |= 0x00000002;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The specification of the query set.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec.QuerySetSpec query_set_spec = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder clearQuerySetSpec() {
        bitField0_ = (bitField0_ & ~0x00000002);
        querySetSpec_ = null;
        if (querySetSpecBuilder_ != null) {
          querySetSpecBuilder_.dispose();
          querySetSpecBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The specification of the query set.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec.QuerySetSpec query_set_spec = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec.QuerySetSpec.Builder
          getQuerySetSpecBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getQuerySetSpecFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Required. The specification of the query set.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec.QuerySetSpec query_set_spec = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec.QuerySetSpecOrBuilder
          getQuerySetSpecOrBuilder() {
        if (querySetSpecBuilder_ != null) {
          return querySetSpecBuilder_.getMessageOrBuilder();
        } else {
          return querySetSpec_ == null
              ? com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec.QuerySetSpec
                  .getDefaultInstance()
              : querySetSpec_;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The specification of the query set.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec.QuerySetSpec query_set_spec = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec.QuerySetSpec,
              com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec.QuerySetSpec
                  .Builder,
              com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec
                  .QuerySetSpecOrBuilder>
          getQuerySetSpecFieldBuilder() {
        if (querySetSpecBuilder_ == null) {
          querySetSpecBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec.QuerySetSpec,
                  com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec.QuerySetSpec
                      .Builder,
                  com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec
                      .QuerySetSpecOrBuilder>(getQuerySetSpec(), getParentForChildren(), isClean());
          querySetSpec_ = null;
        }
        return querySetSpecBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec)
    private static final com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec();
    }

    public static com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<EvaluationSpec> PARSER =
        new com.google.protobuf.AbstractParser<EvaluationSpec>() {
          @java.lang.Override
          public EvaluationSpec parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<EvaluationSpec> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<EvaluationSpec> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Identifier. The full resource name of the
   * [Evaluation][google.cloud.discoveryengine.v1beta.Evaluation], in the format
   * of `projects/{project}/locations/{location}/evaluations/{evaluation}`.
   *
   * This field must be a UTF-8 encoded string with a length limit of 1024
   * characters.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Identifier. The full resource name of the
   * [Evaluation][google.cloud.discoveryengine.v1beta.Evaluation], in the format
   * of `projects/{project}/locations/{location}/evaluations/{evaluation}`.
   *
   * This field must be a UTF-8 encoded string with a length limit of 1024
   * characters.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int EVALUATION_SPEC_FIELD_NUMBER = 2;
  private com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec evaluationSpec_;
  /**
   *
   *
   * <pre>
   * Required. The specification of the evaluation.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec evaluation_spec = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the evaluationSpec field is set.
   */
  @java.lang.Override
  public boolean hasEvaluationSpec() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Required. The specification of the evaluation.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec evaluation_spec = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The evaluationSpec.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec getEvaluationSpec() {
    return evaluationSpec_ == null
        ? com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec.getDefaultInstance()
        : evaluationSpec_;
  }
  /**
   *
   *
   * <pre>
   * Required. The specification of the evaluation.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec evaluation_spec = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpecOrBuilder
      getEvaluationSpecOrBuilder() {
    return evaluationSpec_ == null
        ? com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec.getDefaultInstance()
        : evaluationSpec_;
  }

  public static final int QUALITY_METRICS_FIELD_NUMBER = 3;
  private com.google.cloud.discoveryengine.v1beta.QualityMetrics qualityMetrics_;
  /**
   *
   *
   * <pre>
   * Output only. The metrics produced by the evaluation, averaged across all
   * [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery]s in the
   * [SampleQuerySet][google.cloud.discoveryengine.v1beta.SampleQuerySet].
   *
   * Only populated when the evaluation's state is SUCCEEDED.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1beta.QualityMetrics quality_metrics = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the qualityMetrics field is set.
   */
  @java.lang.Override
  public boolean hasQualityMetrics() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The metrics produced by the evaluation, averaged across all
   * [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery]s in the
   * [SampleQuerySet][google.cloud.discoveryengine.v1beta.SampleQuerySet].
   *
   * Only populated when the evaluation's state is SUCCEEDED.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1beta.QualityMetrics quality_metrics = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The qualityMetrics.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.QualityMetrics getQualityMetrics() {
    return qualityMetrics_ == null
        ? com.google.cloud.discoveryengine.v1beta.QualityMetrics.getDefaultInstance()
        : qualityMetrics_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The metrics produced by the evaluation, averaged across all
   * [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery]s in the
   * [SampleQuerySet][google.cloud.discoveryengine.v1beta.SampleQuerySet].
   *
   * Only populated when the evaluation's state is SUCCEEDED.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1beta.QualityMetrics quality_metrics = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.QualityMetricsOrBuilder
      getQualityMetricsOrBuilder() {
    return qualityMetrics_ == null
        ? com.google.cloud.discoveryengine.v1beta.QualityMetrics.getDefaultInstance()
        : qualityMetrics_;
  }

  public static final int STATE_FIELD_NUMBER = 4;
  private int state_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. The state of the evaluation.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1beta.Evaluation.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The state of the evaluation.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1beta.Evaluation.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.Evaluation.State getState() {
    com.google.cloud.discoveryengine.v1beta.Evaluation.State result =
        com.google.cloud.discoveryengine.v1beta.Evaluation.State.forNumber(state_);
    return result == null
        ? com.google.cloud.discoveryengine.v1beta.Evaluation.State.UNRECOGNIZED
        : result;
  }

  public static final int ERROR_FIELD_NUMBER = 5;
  private com.google.rpc.Status error_;
  /**
   *
   *
   * <pre>
   * Output only. The error that occurred during evaluation. Only populated when
   * the evaluation's state is FAILED.
   * </pre>
   *
   * <code>.google.rpc.Status error = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return Whether the error field is set.
   */
  @java.lang.Override
  public boolean hasError() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The error that occurred during evaluation. Only populated when
   * the evaluation's state is FAILED.
   * </pre>
   *
   * <code>.google.rpc.Status error = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The error.
   */
  @java.lang.Override
  public com.google.rpc.Status getError() {
    return error_ == null ? com.google.rpc.Status.getDefaultInstance() : error_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The error that occurred during evaluation. Only populated when
   * the evaluation's state is FAILED.
   * </pre>
   *
   * <code>.google.rpc.Status error = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   */
  @java.lang.Override
  public com.google.rpc.StatusOrBuilder getErrorOrBuilder() {
    return error_ == null ? com.google.rpc.Status.getDefaultInstance() : error_;
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 6;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. Timestamp the
   * [Evaluation][google.cloud.discoveryengine.v1beta.Evaluation] was created
   * at.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp the
   * [Evaluation][google.cloud.discoveryengine.v1beta.Evaluation] was created
   * at.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp the
   * [Evaluation][google.cloud.discoveryengine.v1beta.Evaluation] was created
   * at.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int END_TIME_FIELD_NUMBER = 7;
  private com.google.protobuf.Timestamp endTime_;
  /**
   *
   *
   * <pre>
   * Output only. Timestamp the
   * [Evaluation][google.cloud.discoveryengine.v1beta.Evaluation] was completed
   * at.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the endTime field is set.
   */
  @java.lang.Override
  public boolean hasEndTime() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp the
   * [Evaluation][google.cloud.discoveryengine.v1beta.Evaluation] was completed
   * at.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The endTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getEndTime() {
    return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp the
   * [Evaluation][google.cloud.discoveryengine.v1beta.Evaluation] was completed
   * at.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
    return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
  }

  public static final int ERROR_SAMPLES_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private java.util.List<com.google.rpc.Status> errorSamples_;
  /**
   *
   *
   * <pre>
   * Output only. A sample of errors encountered while processing the request.
   * </pre>
   *
   * <code>
   * repeated .google.rpc.Status error_samples = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.rpc.Status> getErrorSamplesList() {
    return errorSamples_;
  }
  /**
   *
   *
   * <pre>
   * Output only. A sample of errors encountered while processing the request.
   * </pre>
   *
   * <code>
   * repeated .google.rpc.Status error_samples = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.rpc.StatusOrBuilder> getErrorSamplesOrBuilderList() {
    return errorSamples_;
  }
  /**
   *
   *
   * <pre>
   * Output only. A sample of errors encountered while processing the request.
   * </pre>
   *
   * <code>
   * repeated .google.rpc.Status error_samples = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public int getErrorSamplesCount() {
    return errorSamples_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. A sample of errors encountered while processing the request.
   * </pre>
   *
   * <code>
   * repeated .google.rpc.Status error_samples = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.rpc.Status getErrorSamples(int index) {
    return errorSamples_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. A sample of errors encountered while processing the request.
   * </pre>
   *
   * <code>
   * repeated .google.rpc.Status error_samples = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.rpc.StatusOrBuilder getErrorSamplesOrBuilder(int index) {
    return errorSamples_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(2, getEvaluationSpec());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(3, getQualityMetrics());
    }
    if (state_
        != com.google.cloud.discoveryengine.v1beta.Evaluation.State.STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(4, state_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(5, getError());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(6, getCreateTime());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeMessage(7, getEndTime());
    }
    for (int i = 0; i < errorSamples_.size(); i++) {
      output.writeMessage(8, errorSamples_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getEvaluationSpec());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getQualityMetrics());
    }
    if (state_
        != com.google.cloud.discoveryengine.v1beta.Evaluation.State.STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, state_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getError());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getCreateTime());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getEndTime());
    }
    for (int i = 0; i < errorSamples_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, errorSamples_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.discoveryengine.v1beta.Evaluation)) {
      return super.equals(obj);
    }
    com.google.cloud.discoveryengine.v1beta.Evaluation other =
        (com.google.cloud.discoveryengine.v1beta.Evaluation) obj;

    if (!getName().equals(other.getName())) return false;
    if (hasEvaluationSpec() != other.hasEvaluationSpec()) return false;
    if (hasEvaluationSpec()) {
      if (!getEvaluationSpec().equals(other.getEvaluationSpec())) return false;
    }
    if (hasQualityMetrics() != other.hasQualityMetrics()) return false;
    if (hasQualityMetrics()) {
      if (!getQualityMetrics().equals(other.getQualityMetrics())) return false;
    }
    if (state_ != other.state_) return false;
    if (hasError() != other.hasError()) return false;
    if (hasError()) {
      if (!getError().equals(other.getError())) return false;
    }
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasEndTime() != other.hasEndTime()) return false;
    if (hasEndTime()) {
      if (!getEndTime().equals(other.getEndTime())) return false;
    }
    if (!getErrorSamplesList().equals(other.getErrorSamplesList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasEvaluationSpec()) {
      hash = (37 * hash) + EVALUATION_SPEC_FIELD_NUMBER;
      hash = (53 * hash) + getEvaluationSpec().hashCode();
    }
    if (hasQualityMetrics()) {
      hash = (37 * hash) + QUALITY_METRICS_FIELD_NUMBER;
      hash = (53 * hash) + getQualityMetrics().hashCode();
    }
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    if (hasError()) {
      hash = (37 * hash) + ERROR_FIELD_NUMBER;
      hash = (53 * hash) + getError().hashCode();
    }
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasEndTime()) {
      hash = (37 * hash) + END_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getEndTime().hashCode();
    }
    if (getErrorSamplesCount() > 0) {
      hash = (37 * hash) + ERROR_SAMPLES_FIELD_NUMBER;
      hash = (53 * hash) + getErrorSamplesList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.discoveryengine.v1beta.Evaluation parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1beta.Evaluation parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.Evaluation parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1beta.Evaluation parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.Evaluation parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1beta.Evaluation parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.Evaluation parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1beta.Evaluation parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.Evaluation parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1beta.Evaluation parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.Evaluation parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1beta.Evaluation parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.discoveryengine.v1beta.Evaluation prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * An evaluation is a single execution (or run) of an evaluation process. It
   * encapsulates the state of the evaluation and the resulting data.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1beta.Evaluation}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.Evaluation)
      com.google.cloud.discoveryengine.v1beta.EvaluationOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1beta.EvaluationProto
          .internal_static_google_cloud_discoveryengine_v1beta_Evaluation_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1beta.EvaluationProto
          .internal_static_google_cloud_discoveryengine_v1beta_Evaluation_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1beta.Evaluation.class,
              com.google.cloud.discoveryengine.v1beta.Evaluation.Builder.class);
    }

    // Construct using com.google.cloud.discoveryengine.v1beta.Evaluation.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getEvaluationSpecFieldBuilder();
        getQualityMetricsFieldBuilder();
        getErrorFieldBuilder();
        getCreateTimeFieldBuilder();
        getEndTimeFieldBuilder();
        getErrorSamplesFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      evaluationSpec_ = null;
      if (evaluationSpecBuilder_ != null) {
        evaluationSpecBuilder_.dispose();
        evaluationSpecBuilder_ = null;
      }
      qualityMetrics_ = null;
      if (qualityMetricsBuilder_ != null) {
        qualityMetricsBuilder_.dispose();
        qualityMetricsBuilder_ = null;
      }
      state_ = 0;
      error_ = null;
      if (errorBuilder_ != null) {
        errorBuilder_.dispose();
        errorBuilder_ = null;
      }
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      endTime_ = null;
      if (endTimeBuilder_ != null) {
        endTimeBuilder_.dispose();
        endTimeBuilder_ = null;
      }
      if (errorSamplesBuilder_ == null) {
        errorSamples_ = java.util.Collections.emptyList();
      } else {
        errorSamples_ = null;
        errorSamplesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000080);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.discoveryengine.v1beta.EvaluationProto
          .internal_static_google_cloud_discoveryengine_v1beta_Evaluation_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.Evaluation getDefaultInstanceForType() {
      return com.google.cloud.discoveryengine.v1beta.Evaluation.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.Evaluation build() {
      com.google.cloud.discoveryengine.v1beta.Evaluation result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.Evaluation buildPartial() {
      com.google.cloud.discoveryengine.v1beta.Evaluation result =
          new com.google.cloud.discoveryengine.v1beta.Evaluation(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.discoveryengine.v1beta.Evaluation result) {
      if (errorSamplesBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)) {
          errorSamples_ = java.util.Collections.unmodifiableList(errorSamples_);
          bitField0_ = (bitField0_ & ~0x00000080);
        }
        result.errorSamples_ = errorSamples_;
      } else {
        result.errorSamples_ = errorSamplesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.discoveryengine.v1beta.Evaluation result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.evaluationSpec_ =
            evaluationSpecBuilder_ == null ? evaluationSpec_ : evaluationSpecBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.qualityMetrics_ =
            qualityMetricsBuilder_ == null ? qualityMetrics_ : qualityMetricsBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.state_ = state_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.error_ = errorBuilder_ == null ? error_ : errorBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.endTime_ = endTimeBuilder_ == null ? endTime_ : endTimeBuilder_.build();
        to_bitField0_ |= 0x00000010;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.discoveryengine.v1beta.Evaluation) {
        return mergeFrom((com.google.cloud.discoveryengine.v1beta.Evaluation) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.discoveryengine.v1beta.Evaluation other) {
      if (other == com.google.cloud.discoveryengine.v1beta.Evaluation.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasEvaluationSpec()) {
        mergeEvaluationSpec(other.getEvaluationSpec());
      }
      if (other.hasQualityMetrics()) {
        mergeQualityMetrics(other.getQualityMetrics());
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (other.hasError()) {
        mergeError(other.getError());
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasEndTime()) {
        mergeEndTime(other.getEndTime());
      }
      if (errorSamplesBuilder_ == null) {
        if (!other.errorSamples_.isEmpty()) {
          if (errorSamples_.isEmpty()) {
            errorSamples_ = other.errorSamples_;
            bitField0_ = (bitField0_ & ~0x00000080);
          } else {
            ensureErrorSamplesIsMutable();
            errorSamples_.addAll(other.errorSamples_);
          }
          onChanged();
        }
      } else {
        if (!other.errorSamples_.isEmpty()) {
          if (errorSamplesBuilder_.isEmpty()) {
            errorSamplesBuilder_.dispose();
            errorSamplesBuilder_ = null;
            errorSamples_ = other.errorSamples_;
            bitField0_ = (bitField0_ & ~0x00000080);
            errorSamplesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getErrorSamplesFieldBuilder()
                    : null;
          } else {
            errorSamplesBuilder_.addAllMessages(other.errorSamples_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getEvaluationSpecFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getQualityMetricsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 32:
              {
                state_ = input.readEnum();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            case 42:
              {
                input.readMessage(getErrorFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getEndTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            case 66:
              {
                com.google.rpc.Status m =
                    input.readMessage(com.google.rpc.Status.parser(), extensionRegistry);
                if (errorSamplesBuilder_ == null) {
                  ensureErrorSamplesIsMutable();
                  errorSamples_.add(m);
                } else {
                  errorSamplesBuilder_.addMessage(m);
                }
                break;
              } // case 66
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Identifier. The full resource name of the
     * [Evaluation][google.cloud.discoveryengine.v1beta.Evaluation], in the format
     * of `projects/{project}/locations/{location}/evaluations/{evaluation}`.
     *
     * This field must be a UTF-8 encoded string with a length limit of 1024
     * characters.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Identifier. The full resource name of the
     * [Evaluation][google.cloud.discoveryengine.v1beta.Evaluation], in the format
     * of `projects/{project}/locations/{location}/evaluations/{evaluation}`.
     *
     * This field must be a UTF-8 encoded string with a length limit of 1024
     * characters.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Identifier. The full resource name of the
     * [Evaluation][google.cloud.discoveryengine.v1beta.Evaluation], in the format
     * of `projects/{project}/locations/{location}/evaluations/{evaluation}`.
     *
     * This field must be a UTF-8 encoded string with a length limit of 1024
     * characters.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Identifier. The full resource name of the
     * [Evaluation][google.cloud.discoveryengine.v1beta.Evaluation], in the format
     * of `projects/{project}/locations/{location}/evaluations/{evaluation}`.
     *
     * This field must be a UTF-8 encoded string with a length limit of 1024
     * characters.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Identifier. The full resource name of the
     * [Evaluation][google.cloud.discoveryengine.v1beta.Evaluation], in the format
     * of `projects/{project}/locations/{location}/evaluations/{evaluation}`.
     *
     * This field must be a UTF-8 encoded string with a length limit of 1024
     * characters.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec evaluationSpec_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec,
            com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec.Builder,
            com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpecOrBuilder>
        evaluationSpecBuilder_;
    /**
     *
     *
     * <pre>
     * Required. The specification of the evaluation.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec evaluation_spec = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the evaluationSpec field is set.
     */
    public boolean hasEvaluationSpec() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. The specification of the evaluation.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec evaluation_spec = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The evaluationSpec.
     */
    public com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec getEvaluationSpec() {
      if (evaluationSpecBuilder_ == null) {
        return evaluationSpec_ == null
            ? com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec.getDefaultInstance()
            : evaluationSpec_;
      } else {
        return evaluationSpecBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The specification of the evaluation.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec evaluation_spec = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setEvaluationSpec(
        com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec value) {
      if (evaluationSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        evaluationSpec_ = value;
      } else {
        evaluationSpecBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The specification of the evaluation.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec evaluation_spec = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setEvaluationSpec(
        com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec.Builder builderForValue) {
      if (evaluationSpecBuilder_ == null) {
        evaluationSpec_ = builderForValue.build();
      } else {
        evaluationSpecBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The specification of the evaluation.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec evaluation_spec = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeEvaluationSpec(
        com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec value) {
      if (evaluationSpecBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && evaluationSpec_ != null
            && evaluationSpec_
                != com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec
                    .getDefaultInstance()) {
          getEvaluationSpecBuilder().mergeFrom(value);
        } else {
          evaluationSpec_ = value;
        }
      } else {
        evaluationSpecBuilder_.mergeFrom(value);
      }
      if (evaluationSpec_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The specification of the evaluation.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec evaluation_spec = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearEvaluationSpec() {
      bitField0_ = (bitField0_ & ~0x00000002);
      evaluationSpec_ = null;
      if (evaluationSpecBuilder_ != null) {
        evaluationSpecBuilder_.dispose();
        evaluationSpecBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The specification of the evaluation.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec evaluation_spec = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec.Builder
        getEvaluationSpecBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getEvaluationSpecFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. The specification of the evaluation.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec evaluation_spec = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpecOrBuilder
        getEvaluationSpecOrBuilder() {
      if (evaluationSpecBuilder_ != null) {
        return evaluationSpecBuilder_.getMessageOrBuilder();
      } else {
        return evaluationSpec_ == null
            ? com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec.getDefaultInstance()
            : evaluationSpec_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The specification of the evaluation.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec evaluation_spec = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec,
            com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec.Builder,
            com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpecOrBuilder>
        getEvaluationSpecFieldBuilder() {
      if (evaluationSpecBuilder_ == null) {
        evaluationSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec,
                com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec.Builder,
                com.google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpecOrBuilder>(
                getEvaluationSpec(), getParentForChildren(), isClean());
        evaluationSpec_ = null;
      }
      return evaluationSpecBuilder_;
    }

    private com.google.cloud.discoveryengine.v1beta.QualityMetrics qualityMetrics_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1beta.QualityMetrics,
            com.google.cloud.discoveryengine.v1beta.QualityMetrics.Builder,
            com.google.cloud.discoveryengine.v1beta.QualityMetricsOrBuilder>
        qualityMetricsBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The metrics produced by the evaluation, averaged across all
     * [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery]s in the
     * [SampleQuerySet][google.cloud.discoveryengine.v1beta.SampleQuerySet].
     *
     * Only populated when the evaluation's state is SUCCEEDED.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.QualityMetrics quality_metrics = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the qualityMetrics field is set.
     */
    public boolean hasQualityMetrics() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The metrics produced by the evaluation, averaged across all
     * [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery]s in the
     * [SampleQuerySet][google.cloud.discoveryengine.v1beta.SampleQuerySet].
     *
     * Only populated when the evaluation's state is SUCCEEDED.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.QualityMetrics quality_metrics = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The qualityMetrics.
     */
    public com.google.cloud.discoveryengine.v1beta.QualityMetrics getQualityMetrics() {
      if (qualityMetricsBuilder_ == null) {
        return qualityMetrics_ == null
            ? com.google.cloud.discoveryengine.v1beta.QualityMetrics.getDefaultInstance()
            : qualityMetrics_;
      } else {
        return qualityMetricsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The metrics produced by the evaluation, averaged across all
     * [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery]s in the
     * [SampleQuerySet][google.cloud.discoveryengine.v1beta.SampleQuerySet].
     *
     * Only populated when the evaluation's state is SUCCEEDED.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.QualityMetrics quality_metrics = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setQualityMetrics(com.google.cloud.discoveryengine.v1beta.QualityMetrics value) {
      if (qualityMetricsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        qualityMetrics_ = value;
      } else {
        qualityMetricsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The metrics produced by the evaluation, averaged across all
     * [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery]s in the
     * [SampleQuerySet][google.cloud.discoveryengine.v1beta.SampleQuerySet].
     *
     * Only populated when the evaluation's state is SUCCEEDED.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.QualityMetrics quality_metrics = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setQualityMetrics(
        com.google.cloud.discoveryengine.v1beta.QualityMetrics.Builder builderForValue) {
      if (qualityMetricsBuilder_ == null) {
        qualityMetrics_ = builderForValue.build();
      } else {
        qualityMetricsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The metrics produced by the evaluation, averaged across all
     * [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery]s in the
     * [SampleQuerySet][google.cloud.discoveryengine.v1beta.SampleQuerySet].
     *
     * Only populated when the evaluation's state is SUCCEEDED.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.QualityMetrics quality_metrics = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeQualityMetrics(
        com.google.cloud.discoveryengine.v1beta.QualityMetrics value) {
      if (qualityMetricsBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && qualityMetrics_ != null
            && qualityMetrics_
                != com.google.cloud.discoveryengine.v1beta.QualityMetrics.getDefaultInstance()) {
          getQualityMetricsBuilder().mergeFrom(value);
        } else {
          qualityMetrics_ = value;
        }
      } else {
        qualityMetricsBuilder_.mergeFrom(value);
      }
      if (qualityMetrics_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The metrics produced by the evaluation, averaged across all
     * [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery]s in the
     * [SampleQuerySet][google.cloud.discoveryengine.v1beta.SampleQuerySet].
     *
     * Only populated when the evaluation's state is SUCCEEDED.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.QualityMetrics quality_metrics = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearQualityMetrics() {
      bitField0_ = (bitField0_ & ~0x00000004);
      qualityMetrics_ = null;
      if (qualityMetricsBuilder_ != null) {
        qualityMetricsBuilder_.dispose();
        qualityMetricsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The metrics produced by the evaluation, averaged across all
     * [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery]s in the
     * [SampleQuerySet][google.cloud.discoveryengine.v1beta.SampleQuerySet].
     *
     * Only populated when the evaluation's state is SUCCEEDED.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.QualityMetrics quality_metrics = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.discoveryengine.v1beta.QualityMetrics.Builder
        getQualityMetricsBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getQualityMetricsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The metrics produced by the evaluation, averaged across all
     * [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery]s in the
     * [SampleQuerySet][google.cloud.discoveryengine.v1beta.SampleQuerySet].
     *
     * Only populated when the evaluation's state is SUCCEEDED.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.QualityMetrics quality_metrics = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.discoveryengine.v1beta.QualityMetricsOrBuilder
        getQualityMetricsOrBuilder() {
      if (qualityMetricsBuilder_ != null) {
        return qualityMetricsBuilder_.getMessageOrBuilder();
      } else {
        return qualityMetrics_ == null
            ? com.google.cloud.discoveryengine.v1beta.QualityMetrics.getDefaultInstance()
            : qualityMetrics_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The metrics produced by the evaluation, averaged across all
     * [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery]s in the
     * [SampleQuerySet][google.cloud.discoveryengine.v1beta.SampleQuerySet].
     *
     * Only populated when the evaluation's state is SUCCEEDED.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.QualityMetrics quality_metrics = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1beta.QualityMetrics,
            com.google.cloud.discoveryengine.v1beta.QualityMetrics.Builder,
            com.google.cloud.discoveryengine.v1beta.QualityMetricsOrBuilder>
        getQualityMetricsFieldBuilder() {
      if (qualityMetricsBuilder_ == null) {
        qualityMetricsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1beta.QualityMetrics,
                com.google.cloud.discoveryengine.v1beta.QualityMetrics.Builder,
                com.google.cloud.discoveryengine.v1beta.QualityMetricsOrBuilder>(
                getQualityMetrics(), getParentForChildren(), isClean());
        qualityMetrics_ = null;
      }
      return qualityMetricsBuilder_;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. The state of the evaluation.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.Evaluation.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The state of the evaluation.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.Evaluation.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {
      state_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The state of the evaluation.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.Evaluation.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.Evaluation.State getState() {
      com.google.cloud.discoveryengine.v1beta.Evaluation.State result =
          com.google.cloud.discoveryengine.v1beta.Evaluation.State.forNumber(state_);
      return result == null
          ? com.google.cloud.discoveryengine.v1beta.Evaluation.State.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. The state of the evaluation.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.Evaluation.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.cloud.discoveryengine.v1beta.Evaluation.State value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000008;
      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The state of the evaluation.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.Evaluation.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      bitField0_ = (bitField0_ & ~0x00000008);
      state_ = 0;
      onChanged();
      return this;
    }

    private com.google.rpc.Status error_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        errorBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The error that occurred during evaluation. Only populated when
     * the evaluation's state is FAILED.
     * </pre>
     *
     * <code>.google.rpc.Status error = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return Whether the error field is set.
     */
    public boolean hasError() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The error that occurred during evaluation. Only populated when
     * the evaluation's state is FAILED.
     * </pre>
     *
     * <code>.google.rpc.Status error = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The error.
     */
    public com.google.rpc.Status getError() {
      if (errorBuilder_ == null) {
        return error_ == null ? com.google.rpc.Status.getDefaultInstance() : error_;
      } else {
        return errorBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The error that occurred during evaluation. Only populated when
     * the evaluation's state is FAILED.
     * </pre>
     *
     * <code>.google.rpc.Status error = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setError(com.google.rpc.Status value) {
      if (errorBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        error_ = value;
      } else {
        errorBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The error that occurred during evaluation. Only populated when
     * the evaluation's state is FAILED.
     * </pre>
     *
     * <code>.google.rpc.Status error = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setError(com.google.rpc.Status.Builder builderForValue) {
      if (errorBuilder_ == null) {
        error_ = builderForValue.build();
      } else {
        errorBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The error that occurred during evaluation. Only populated when
     * the evaluation's state is FAILED.
     * </pre>
     *
     * <code>.google.rpc.Status error = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder mergeError(com.google.rpc.Status value) {
      if (errorBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && error_ != null
            && error_ != com.google.rpc.Status.getDefaultInstance()) {
          getErrorBuilder().mergeFrom(value);
        } else {
          error_ = value;
        }
      } else {
        errorBuilder_.mergeFrom(value);
      }
      if (error_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The error that occurred during evaluation. Only populated when
     * the evaluation's state is FAILED.
     * </pre>
     *
     * <code>.google.rpc.Status error = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder clearError() {
      bitField0_ = (bitField0_ & ~0x00000010);
      error_ = null;
      if (errorBuilder_ != null) {
        errorBuilder_.dispose();
        errorBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The error that occurred during evaluation. Only populated when
     * the evaluation's state is FAILED.
     * </pre>
     *
     * <code>.google.rpc.Status error = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public com.google.rpc.Status.Builder getErrorBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getErrorFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The error that occurred during evaluation. Only populated when
     * the evaluation's state is FAILED.
     * </pre>
     *
     * <code>.google.rpc.Status error = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public com.google.rpc.StatusOrBuilder getErrorOrBuilder() {
      if (errorBuilder_ != null) {
        return errorBuilder_.getMessageOrBuilder();
      } else {
        return error_ == null ? com.google.rpc.Status.getDefaultInstance() : error_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The error that occurred during evaluation. Only populated when
     * the evaluation's state is FAILED.
     * </pre>
     *
     * <code>.google.rpc.Status error = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        getErrorFieldBuilder() {
      if (errorBuilder_ == null) {
        errorBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.rpc.Status,
                com.google.rpc.Status.Builder,
                com.google.rpc.StatusOrBuilder>(getError(), getParentForChildren(), isClean());
        error_ = null;
      }
      return errorBuilder_;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Timestamp the
     * [Evaluation][google.cloud.discoveryengine.v1beta.Evaluation] was created
     * at.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp the
     * [Evaluation][google.cloud.discoveryengine.v1beta.Evaluation] was created
     * at.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp the
     * [Evaluation][google.cloud.discoveryengine.v1beta.Evaluation] was created
     * at.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp the
     * [Evaluation][google.cloud.discoveryengine.v1beta.Evaluation] was created
     * at.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp the
     * [Evaluation][google.cloud.discoveryengine.v1beta.Evaluation] was created
     * at.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp the
     * [Evaluation][google.cloud.discoveryengine.v1beta.Evaluation] was created
     * at.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000020);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp the
     * [Evaluation][google.cloud.discoveryengine.v1beta.Evaluation] was created
     * at.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp the
     * [Evaluation][google.cloud.discoveryengine.v1beta.Evaluation] was created
     * at.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp the
     * [Evaluation][google.cloud.discoveryengine.v1beta.Evaluation] was created
     * at.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp endTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        endTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Timestamp the
     * [Evaluation][google.cloud.discoveryengine.v1beta.Evaluation] was completed
     * at.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the endTime field is set.
     */
    public boolean hasEndTime() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp the
     * [Evaluation][google.cloud.discoveryengine.v1beta.Evaluation] was completed
     * at.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The endTime.
     */
    public com.google.protobuf.Timestamp getEndTime() {
      if (endTimeBuilder_ == null) {
        return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
      } else {
        return endTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp the
     * [Evaluation][google.cloud.discoveryengine.v1beta.Evaluation] was completed
     * at.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setEndTime(com.google.protobuf.Timestamp value) {
      if (endTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        endTime_ = value;
      } else {
        endTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp the
     * [Evaluation][google.cloud.discoveryengine.v1beta.Evaluation] was completed
     * at.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setEndTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (endTimeBuilder_ == null) {
        endTime_ = builderForValue.build();
      } else {
        endTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp the
     * [Evaluation][google.cloud.discoveryengine.v1beta.Evaluation] was completed
     * at.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeEndTime(com.google.protobuf.Timestamp value) {
      if (endTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && endTime_ != null
            && endTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getEndTimeBuilder().mergeFrom(value);
        } else {
          endTime_ = value;
        }
      } else {
        endTimeBuilder_.mergeFrom(value);
      }
      if (endTime_ != null) {
        bitField0_ |= 0x00000040;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp the
     * [Evaluation][google.cloud.discoveryengine.v1beta.Evaluation] was completed
     * at.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearEndTime() {
      bitField0_ = (bitField0_ & ~0x00000040);
      endTime_ = null;
      if (endTimeBuilder_ != null) {
        endTimeBuilder_.dispose();
        endTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp the
     * [Evaluation][google.cloud.discoveryengine.v1beta.Evaluation] was completed
     * at.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getEndTimeBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getEndTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp the
     * [Evaluation][google.cloud.discoveryengine.v1beta.Evaluation] was completed
     * at.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
      if (endTimeBuilder_ != null) {
        return endTimeBuilder_.getMessageOrBuilder();
      } else {
        return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp the
     * [Evaluation][google.cloud.discoveryengine.v1beta.Evaluation] was completed
     * at.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getEndTimeFieldBuilder() {
      if (endTimeBuilder_ == null) {
        endTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getEndTime(), getParentForChildren(), isClean());
        endTime_ = null;
      }
      return endTimeBuilder_;
    }

    private java.util.List<com.google.rpc.Status> errorSamples_ = java.util.Collections.emptyList();

    private void ensureErrorSamplesIsMutable() {
      if (!((bitField0_ & 0x00000080) != 0)) {
        errorSamples_ = new java.util.ArrayList<com.google.rpc.Status>(errorSamples_);
        bitField0_ |= 0x00000080;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        errorSamplesBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. A sample of errors encountered while processing the request.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status error_samples = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.rpc.Status> getErrorSamplesList() {
      if (errorSamplesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(errorSamples_);
      } else {
        return errorSamplesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A sample of errors encountered while processing the request.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status error_samples = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public int getErrorSamplesCount() {
      if (errorSamplesBuilder_ == null) {
        return errorSamples_.size();
      } else {
        return errorSamplesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A sample of errors encountered while processing the request.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status error_samples = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.rpc.Status getErrorSamples(int index) {
      if (errorSamplesBuilder_ == null) {
        return errorSamples_.get(index);
      } else {
        return errorSamplesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A sample of errors encountered while processing the request.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status error_samples = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setErrorSamples(int index, com.google.rpc.Status value) {
      if (errorSamplesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureErrorSamplesIsMutable();
        errorSamples_.set(index, value);
        onChanged();
      } else {
        errorSamplesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A sample of errors encountered while processing the request.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status error_samples = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setErrorSamples(int index, com.google.rpc.Status.Builder builderForValue) {
      if (errorSamplesBuilder_ == null) {
        ensureErrorSamplesIsMutable();
        errorSamples_.set(index, builderForValue.build());
        onChanged();
      } else {
        errorSamplesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A sample of errors encountered while processing the request.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status error_samples = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addErrorSamples(com.google.rpc.Status value) {
      if (errorSamplesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureErrorSamplesIsMutable();
        errorSamples_.add(value);
        onChanged();
      } else {
        errorSamplesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A sample of errors encountered while processing the request.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status error_samples = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addErrorSamples(int index, com.google.rpc.Status value) {
      if (errorSamplesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureErrorSamplesIsMutable();
        errorSamples_.add(index, value);
        onChanged();
      } else {
        errorSamplesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A sample of errors encountered while processing the request.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status error_samples = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addErrorSamples(com.google.rpc.Status.Builder builderForValue) {
      if (errorSamplesBuilder_ == null) {
        ensureErrorSamplesIsMutable();
        errorSamples_.add(builderForValue.build());
        onChanged();
      } else {
        errorSamplesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A sample of errors encountered while processing the request.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status error_samples = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addErrorSamples(int index, com.google.rpc.Status.Builder builderForValue) {
      if (errorSamplesBuilder_ == null) {
        ensureErrorSamplesIsMutable();
        errorSamples_.add(index, builderForValue.build());
        onChanged();
      } else {
        errorSamplesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A sample of errors encountered while processing the request.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status error_samples = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAllErrorSamples(java.lang.Iterable<? extends com.google.rpc.Status> values) {
      if (errorSamplesBuilder_ == null) {
        ensureErrorSamplesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, errorSamples_);
        onChanged();
      } else {
        errorSamplesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A sample of errors encountered while processing the request.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status error_samples = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearErrorSamples() {
      if (errorSamplesBuilder_ == null) {
        errorSamples_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000080);
        onChanged();
      } else {
        errorSamplesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A sample of errors encountered while processing the request.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status error_samples = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeErrorSamples(int index) {
      if (errorSamplesBuilder_ == null) {
        ensureErrorSamplesIsMutable();
        errorSamples_.remove(index);
        onChanged();
      } else {
        errorSamplesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A sample of errors encountered while processing the request.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status error_samples = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.rpc.Status.Builder getErrorSamplesBuilder(int index) {
      return getErrorSamplesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. A sample of errors encountered while processing the request.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status error_samples = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.rpc.StatusOrBuilder getErrorSamplesOrBuilder(int index) {
      if (errorSamplesBuilder_ == null) {
        return errorSamples_.get(index);
      } else {
        return errorSamplesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A sample of errors encountered while processing the request.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status error_samples = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<? extends com.google.rpc.StatusOrBuilder> getErrorSamplesOrBuilderList() {
      if (errorSamplesBuilder_ != null) {
        return errorSamplesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(errorSamples_);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A sample of errors encountered while processing the request.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status error_samples = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.rpc.Status.Builder addErrorSamplesBuilder() {
      return getErrorSamplesFieldBuilder().addBuilder(com.google.rpc.Status.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. A sample of errors encountered while processing the request.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status error_samples = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.rpc.Status.Builder addErrorSamplesBuilder(int index) {
      return getErrorSamplesFieldBuilder()
          .addBuilder(index, com.google.rpc.Status.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. A sample of errors encountered while processing the request.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status error_samples = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.rpc.Status.Builder> getErrorSamplesBuilderList() {
      return getErrorSamplesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        getErrorSamplesFieldBuilder() {
      if (errorSamplesBuilder_ == null) {
        errorSamplesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.rpc.Status,
                com.google.rpc.Status.Builder,
                com.google.rpc.StatusOrBuilder>(
                errorSamples_, ((bitField0_ & 0x00000080) != 0), getParentForChildren(), isClean());
        errorSamples_ = null;
      }
      return errorSamplesBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.Evaluation)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.Evaluation)
  private static final com.google.cloud.discoveryengine.v1beta.Evaluation DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.discoveryengine.v1beta.Evaluation();
  }

  public static com.google.cloud.discoveryengine.v1beta.Evaluation getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Evaluation> PARSER =
      new com.google.protobuf.AbstractParser<Evaluation>() {
        @java.lang.Override
        public Evaluation parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Evaluation> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Evaluation> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.Evaluation getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
