/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/discoveryengine/v1beta/completion_service.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.discoveryengine.v1beta;

/**
 *
 *
 * <pre>
 * Request message for
 * [CompletionService.AdvancedCompleteQuery][google.cloud.discoveryengine.v1beta.CompletionService.AdvancedCompleteQuery]
 * method.
 * .
 * </pre>
 *
 * Protobuf type {@code google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest}
 */
public final class AdvancedCompleteQueryRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest)
    AdvancedCompleteQueryRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use AdvancedCompleteQueryRequest.newBuilder() to construct.
  private AdvancedCompleteQueryRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private AdvancedCompleteQueryRequest() {
    completionConfig_ = "";
    query_ = "";
    queryModel_ = "";
    userPseudoId_ = "";
    suggestionTypes_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new AdvancedCompleteQueryRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.discoveryengine.v1beta.CompletionServiceProto
        .internal_static_google_cloud_discoveryengine_v1beta_AdvancedCompleteQueryRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.discoveryengine.v1beta.CompletionServiceProto
        .internal_static_google_cloud_discoveryengine_v1beta_AdvancedCompleteQueryRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.class,
            com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Suggestion type to return.
   * </pre>
   *
   * Protobuf enum {@code
   * google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.SuggestionType}
   */
  public enum SuggestionType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Default value.
     * </pre>
     *
     * <code>SUGGESTION_TYPE_UNSPECIFIED = 0;</code>
     */
    SUGGESTION_TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Returns query suggestions.
     * </pre>
     *
     * <code>QUERY = 1;</code>
     */
    QUERY(1),
    /**
     *
     *
     * <pre>
     * Returns people suggestions.
     * </pre>
     *
     * <code>PEOPLE = 2;</code>
     */
    PEOPLE(2),
    /**
     *
     *
     * <pre>
     * Returns content suggestions.
     * </pre>
     *
     * <code>CONTENT = 3;</code>
     */
    CONTENT(3),
    /**
     *
     *
     * <pre>
     * Returns recent search suggestions.
     * </pre>
     *
     * <code>RECENT_SEARCH = 4;</code>
     */
    RECENT_SEARCH(4),
    /**
     *
     *
     * <pre>
     * Returns Google Workspace suggestions.
     * </pre>
     *
     * <code>GOOGLE_WORKSPACE = 5;</code>
     */
    GOOGLE_WORKSPACE(5),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Default value.
     * </pre>
     *
     * <code>SUGGESTION_TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int SUGGESTION_TYPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Returns query suggestions.
     * </pre>
     *
     * <code>QUERY = 1;</code>
     */
    public static final int QUERY_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Returns people suggestions.
     * </pre>
     *
     * <code>PEOPLE = 2;</code>
     */
    public static final int PEOPLE_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Returns content suggestions.
     * </pre>
     *
     * <code>CONTENT = 3;</code>
     */
    public static final int CONTENT_VALUE = 3;
    /**
     *
     *
     * <pre>
     * Returns recent search suggestions.
     * </pre>
     *
     * <code>RECENT_SEARCH = 4;</code>
     */
    public static final int RECENT_SEARCH_VALUE = 4;
    /**
     *
     *
     * <pre>
     * Returns Google Workspace suggestions.
     * </pre>
     *
     * <code>GOOGLE_WORKSPACE = 5;</code>
     */
    public static final int GOOGLE_WORKSPACE_VALUE = 5;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SuggestionType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static SuggestionType forNumber(int value) {
      switch (value) {
        case 0:
          return SUGGESTION_TYPE_UNSPECIFIED;
        case 1:
          return QUERY;
        case 2:
          return PEOPLE;
        case 3:
          return CONTENT;
        case 4:
          return RECENT_SEARCH;
        case 5:
          return GOOGLE_WORKSPACE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<SuggestionType> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<SuggestionType> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<SuggestionType>() {
          public SuggestionType findValueByNumber(int number) {
            return SuggestionType.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final SuggestionType[] VALUES = values();

    public static SuggestionType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private SuggestionType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.SuggestionType)
  }

  public interface BoostSpecOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Condition boost specifications. If a suggestion matches multiple
     * conditions in the specifictions, boost values from these specifications
     * are all applied and combined in a non-linear way. Maximum number of
     * specifications is 20.
     *
     * Note: Currently only support language condition boost.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec.ConditionBoostSpec condition_boost_specs = 1;
     * </code>
     */
    java.util.List<
            com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec
                .ConditionBoostSpec>
        getConditionBoostSpecsList();
    /**
     *
     *
     * <pre>
     * Condition boost specifications. If a suggestion matches multiple
     * conditions in the specifictions, boost values from these specifications
     * are all applied and combined in a non-linear way. Maximum number of
     * specifications is 20.
     *
     * Note: Currently only support language condition boost.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec.ConditionBoostSpec condition_boost_specs = 1;
     * </code>
     */
    com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec
            .ConditionBoostSpec
        getConditionBoostSpecs(int index);
    /**
     *
     *
     * <pre>
     * Condition boost specifications. If a suggestion matches multiple
     * conditions in the specifictions, boost values from these specifications
     * are all applied and combined in a non-linear way. Maximum number of
     * specifications is 20.
     *
     * Note: Currently only support language condition boost.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec.ConditionBoostSpec condition_boost_specs = 1;
     * </code>
     */
    int getConditionBoostSpecsCount();
    /**
     *
     *
     * <pre>
     * Condition boost specifications. If a suggestion matches multiple
     * conditions in the specifictions, boost values from these specifications
     * are all applied and combined in a non-linear way. Maximum number of
     * specifications is 20.
     *
     * Note: Currently only support language condition boost.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec.ConditionBoostSpec condition_boost_specs = 1;
     * </code>
     */
    java.util.List<
            ? extends
                com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec
                    .ConditionBoostSpecOrBuilder>
        getConditionBoostSpecsOrBuilderList();
    /**
     *
     *
     * <pre>
     * Condition boost specifications. If a suggestion matches multiple
     * conditions in the specifictions, boost values from these specifications
     * are all applied and combined in a non-linear way. Maximum number of
     * specifications is 20.
     *
     * Note: Currently only support language condition boost.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec.ConditionBoostSpec condition_boost_specs = 1;
     * </code>
     */
    com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec
            .ConditionBoostSpecOrBuilder
        getConditionBoostSpecsOrBuilder(int index);
  }
  /**
   *
   *
   * <pre>
   * Specification to boost suggestions based on the condtion of the suggestion.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec}
   */
  public static final class BoostSpec extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec)
      BoostSpecOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use BoostSpec.newBuilder() to construct.
    private BoostSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private BoostSpec() {
      conditionBoostSpecs_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new BoostSpec();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1beta.CompletionServiceProto
          .internal_static_google_cloud_discoveryengine_v1beta_AdvancedCompleteQueryRequest_BoostSpec_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1beta.CompletionServiceProto
          .internal_static_google_cloud_discoveryengine_v1beta_AdvancedCompleteQueryRequest_BoostSpec_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec.class,
              com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec.Builder
                  .class);
    }

    public interface ConditionBoostSpecOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec.ConditionBoostSpec)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * An expression which specifies a boost condition. The syntax is the same
       * as [filter expression
       * syntax](https://cloud.google.com/generative-ai-app-builder/docs/filter-search-metadata#filter-expression-syntax).
       * Currently, the only supported condition is a list of BCP-47 lang codes.
       *
       * Example:
       *
       * * To boost suggestions in languages `en` or `fr`:
       * `(lang_code: ANY("en", "fr"))`
       * </pre>
       *
       * <code>string condition = 1;</code>
       *
       * @return The condition.
       */
      java.lang.String getCondition();
      /**
       *
       *
       * <pre>
       * An expression which specifies a boost condition. The syntax is the same
       * as [filter expression
       * syntax](https://cloud.google.com/generative-ai-app-builder/docs/filter-search-metadata#filter-expression-syntax).
       * Currently, the only supported condition is a list of BCP-47 lang codes.
       *
       * Example:
       *
       * * To boost suggestions in languages `en` or `fr`:
       * `(lang_code: ANY("en", "fr"))`
       * </pre>
       *
       * <code>string condition = 1;</code>
       *
       * @return The bytes for condition.
       */
      com.google.protobuf.ByteString getConditionBytes();

      /**
       *
       *
       * <pre>
       * Strength of the boost, which should be in [-1, 1].
       * Negative boost means demotion. Default is 0.0.
       *
       * Setting to 1.0 gives the suggestions a big promotion. However, it does
       * not necessarily mean that the top result will be a boosted suggestion.
       *
       * Setting to -1.0 gives the suggestions a big demotion. However, other
       * suggestions that are relevant might still be shown.
       *
       * Setting to 0.0 means no boost applied. The boosting condition is
       * ignored.
       * </pre>
       *
       * <code>float boost = 2;</code>
       *
       * @return The boost.
       */
      float getBoost();
    }
    /**
     *
     *
     * <pre>
     * Boost applies to suggestions which match a condition.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec.ConditionBoostSpec}
     */
    public static final class ConditionBoostSpec extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec.ConditionBoostSpec)
        ConditionBoostSpecOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use ConditionBoostSpec.newBuilder() to construct.
      private ConditionBoostSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private ConditionBoostSpec() {
        condition_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new ConditionBoostSpec();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1beta.CompletionServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_AdvancedCompleteQueryRequest_BoostSpec_ConditionBoostSpec_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1beta.CompletionServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_AdvancedCompleteQueryRequest_BoostSpec_ConditionBoostSpec_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec
                    .ConditionBoostSpec.class,
                com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec
                    .ConditionBoostSpec.Builder.class);
      }

      public static final int CONDITION_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private volatile java.lang.Object condition_ = "";
      /**
       *
       *
       * <pre>
       * An expression which specifies a boost condition. The syntax is the same
       * as [filter expression
       * syntax](https://cloud.google.com/generative-ai-app-builder/docs/filter-search-metadata#filter-expression-syntax).
       * Currently, the only supported condition is a list of BCP-47 lang codes.
       *
       * Example:
       *
       * * To boost suggestions in languages `en` or `fr`:
       * `(lang_code: ANY("en", "fr"))`
       * </pre>
       *
       * <code>string condition = 1;</code>
       *
       * @return The condition.
       */
      @java.lang.Override
      public java.lang.String getCondition() {
        java.lang.Object ref = condition_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          condition_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * An expression which specifies a boost condition. The syntax is the same
       * as [filter expression
       * syntax](https://cloud.google.com/generative-ai-app-builder/docs/filter-search-metadata#filter-expression-syntax).
       * Currently, the only supported condition is a list of BCP-47 lang codes.
       *
       * Example:
       *
       * * To boost suggestions in languages `en` or `fr`:
       * `(lang_code: ANY("en", "fr"))`
       * </pre>
       *
       * <code>string condition = 1;</code>
       *
       * @return The bytes for condition.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getConditionBytes() {
        java.lang.Object ref = condition_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          condition_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int BOOST_FIELD_NUMBER = 2;
      private float boost_ = 0F;
      /**
       *
       *
       * <pre>
       * Strength of the boost, which should be in [-1, 1].
       * Negative boost means demotion. Default is 0.0.
       *
       * Setting to 1.0 gives the suggestions a big promotion. However, it does
       * not necessarily mean that the top result will be a boosted suggestion.
       *
       * Setting to -1.0 gives the suggestions a big demotion. However, other
       * suggestions that are relevant might still be shown.
       *
       * Setting to 0.0 means no boost applied. The boosting condition is
       * ignored.
       * </pre>
       *
       * <code>float boost = 2;</code>
       *
       * @return The boost.
       */
      @java.lang.Override
      public float getBoost() {
        return boost_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(condition_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, condition_);
        }
        if (java.lang.Float.floatToRawIntBits(boost_) != 0) {
          output.writeFloat(2, boost_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(condition_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, condition_);
        }
        if (java.lang.Float.floatToRawIntBits(boost_) != 0) {
          size += com.google.protobuf.CodedOutputStream.computeFloatSize(2, boost_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec
                .ConditionBoostSpec)) {
          return super.equals(obj);
        }
        com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec
                .ConditionBoostSpec
            other =
                (com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec
                        .ConditionBoostSpec)
                    obj;

        if (!getCondition().equals(other.getCondition())) return false;
        if (java.lang.Float.floatToIntBits(getBoost())
            != java.lang.Float.floatToIntBits(other.getBoost())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + CONDITION_FIELD_NUMBER;
        hash = (53 * hash) + getCondition().hashCode();
        hash = (37 * hash) + BOOST_FIELD_NUMBER;
        hash = (53 * hash) + java.lang.Float.floatToIntBits(getBoost());
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec
              .ConditionBoostSpec
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec
              .ConditionBoostSpec
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec
              .ConditionBoostSpec
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec
              .ConditionBoostSpec
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec
              .ConditionBoostSpec
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec
              .ConditionBoostSpec
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec
              .ConditionBoostSpec
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec
              .ConditionBoostSpec
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec
              .ConditionBoostSpec
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec
              .ConditionBoostSpec
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec
              .ConditionBoostSpec
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec
              .ConditionBoostSpec
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec
                  .ConditionBoostSpec
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Boost applies to suggestions which match a condition.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec.ConditionBoostSpec}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec.ConditionBoostSpec)
          com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec
              .ConditionBoostSpecOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.discoveryengine.v1beta.CompletionServiceProto
              .internal_static_google_cloud_discoveryengine_v1beta_AdvancedCompleteQueryRequest_BoostSpec_ConditionBoostSpec_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.discoveryengine.v1beta.CompletionServiceProto
              .internal_static_google_cloud_discoveryengine_v1beta_AdvancedCompleteQueryRequest_BoostSpec_ConditionBoostSpec_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec
                      .ConditionBoostSpec.class,
                  com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec
                      .ConditionBoostSpec.Builder.class);
        }

        // Construct using
        // com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec.ConditionBoostSpec.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          condition_ = "";
          boost_ = 0F;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.discoveryengine.v1beta.CompletionServiceProto
              .internal_static_google_cloud_discoveryengine_v1beta_AdvancedCompleteQueryRequest_BoostSpec_ConditionBoostSpec_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec
                .ConditionBoostSpec
            getDefaultInstanceForType() {
          return com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec
              .ConditionBoostSpec.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec
                .ConditionBoostSpec
            build() {
          com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec
                  .ConditionBoostSpec
              result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec
                .ConditionBoostSpec
            buildPartial() {
          com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec
                  .ConditionBoostSpec
              result =
                  new com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec
                      .ConditionBoostSpec(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec
                    .ConditionBoostSpec
                result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.condition_ = condition_;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.boost_ = boost_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec
                  .ConditionBoostSpec) {
            return mergeFrom(
                (com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec
                        .ConditionBoostSpec)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec
                    .ConditionBoostSpec
                other) {
          if (other
              == com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec
                  .ConditionBoostSpec.getDefaultInstance()) return this;
          if (!other.getCondition().isEmpty()) {
            condition_ = other.condition_;
            bitField0_ |= 0x00000001;
            onChanged();
          }
          if (other.getBoost() != 0F) {
            setBoost(other.getBoost());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    condition_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                case 21:
                  {
                    boost_ = input.readFloat();
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 21
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.lang.Object condition_ = "";
        /**
         *
         *
         * <pre>
         * An expression which specifies a boost condition. The syntax is the same
         * as [filter expression
         * syntax](https://cloud.google.com/generative-ai-app-builder/docs/filter-search-metadata#filter-expression-syntax).
         * Currently, the only supported condition is a list of BCP-47 lang codes.
         *
         * Example:
         *
         * * To boost suggestions in languages `en` or `fr`:
         * `(lang_code: ANY("en", "fr"))`
         * </pre>
         *
         * <code>string condition = 1;</code>
         *
         * @return The condition.
         */
        public java.lang.String getCondition() {
          java.lang.Object ref = condition_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            condition_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * An expression which specifies a boost condition. The syntax is the same
         * as [filter expression
         * syntax](https://cloud.google.com/generative-ai-app-builder/docs/filter-search-metadata#filter-expression-syntax).
         * Currently, the only supported condition is a list of BCP-47 lang codes.
         *
         * Example:
         *
         * * To boost suggestions in languages `en` or `fr`:
         * `(lang_code: ANY("en", "fr"))`
         * </pre>
         *
         * <code>string condition = 1;</code>
         *
         * @return The bytes for condition.
         */
        public com.google.protobuf.ByteString getConditionBytes() {
          java.lang.Object ref = condition_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            condition_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * An expression which specifies a boost condition. The syntax is the same
         * as [filter expression
         * syntax](https://cloud.google.com/generative-ai-app-builder/docs/filter-search-metadata#filter-expression-syntax).
         * Currently, the only supported condition is a list of BCP-47 lang codes.
         *
         * Example:
         *
         * * To boost suggestions in languages `en` or `fr`:
         * `(lang_code: ANY("en", "fr"))`
         * </pre>
         *
         * <code>string condition = 1;</code>
         *
         * @param value The condition to set.
         * @return This builder for chaining.
         */
        public Builder setCondition(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          condition_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * An expression which specifies a boost condition. The syntax is the same
         * as [filter expression
         * syntax](https://cloud.google.com/generative-ai-app-builder/docs/filter-search-metadata#filter-expression-syntax).
         * Currently, the only supported condition is a list of BCP-47 lang codes.
         *
         * Example:
         *
         * * To boost suggestions in languages `en` or `fr`:
         * `(lang_code: ANY("en", "fr"))`
         * </pre>
         *
         * <code>string condition = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearCondition() {
          condition_ = getDefaultInstance().getCondition();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * An expression which specifies a boost condition. The syntax is the same
         * as [filter expression
         * syntax](https://cloud.google.com/generative-ai-app-builder/docs/filter-search-metadata#filter-expression-syntax).
         * Currently, the only supported condition is a list of BCP-47 lang codes.
         *
         * Example:
         *
         * * To boost suggestions in languages `en` or `fr`:
         * `(lang_code: ANY("en", "fr"))`
         * </pre>
         *
         * <code>string condition = 1;</code>
         *
         * @param value The bytes for condition to set.
         * @return This builder for chaining.
         */
        public Builder setConditionBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          condition_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        private float boost_;
        /**
         *
         *
         * <pre>
         * Strength of the boost, which should be in [-1, 1].
         * Negative boost means demotion. Default is 0.0.
         *
         * Setting to 1.0 gives the suggestions a big promotion. However, it does
         * not necessarily mean that the top result will be a boosted suggestion.
         *
         * Setting to -1.0 gives the suggestions a big demotion. However, other
         * suggestions that are relevant might still be shown.
         *
         * Setting to 0.0 means no boost applied. The boosting condition is
         * ignored.
         * </pre>
         *
         * <code>float boost = 2;</code>
         *
         * @return The boost.
         */
        @java.lang.Override
        public float getBoost() {
          return boost_;
        }
        /**
         *
         *
         * <pre>
         * Strength of the boost, which should be in [-1, 1].
         * Negative boost means demotion. Default is 0.0.
         *
         * Setting to 1.0 gives the suggestions a big promotion. However, it does
         * not necessarily mean that the top result will be a boosted suggestion.
         *
         * Setting to -1.0 gives the suggestions a big demotion. However, other
         * suggestions that are relevant might still be shown.
         *
         * Setting to 0.0 means no boost applied. The boosting condition is
         * ignored.
         * </pre>
         *
         * <code>float boost = 2;</code>
         *
         * @param value The boost to set.
         * @return This builder for chaining.
         */
        public Builder setBoost(float value) {

          boost_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Strength of the boost, which should be in [-1, 1].
         * Negative boost means demotion. Default is 0.0.
         *
         * Setting to 1.0 gives the suggestions a big promotion. However, it does
         * not necessarily mean that the top result will be a boosted suggestion.
         *
         * Setting to -1.0 gives the suggestions a big demotion. However, other
         * suggestions that are relevant might still be shown.
         *
         * Setting to 0.0 means no boost applied. The boosting condition is
         * ignored.
         * </pre>
         *
         * <code>float boost = 2;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearBoost() {
          bitField0_ = (bitField0_ & ~0x00000002);
          boost_ = 0F;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec.ConditionBoostSpec)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec.ConditionBoostSpec)
      private static final com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest
              .BoostSpec.ConditionBoostSpec
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec
                .ConditionBoostSpec();
      }

      public static com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec
              .ConditionBoostSpec
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<ConditionBoostSpec> PARSER =
          new com.google.protobuf.AbstractParser<ConditionBoostSpec>() {
            @java.lang.Override
            public ConditionBoostSpec parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<ConditionBoostSpec> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<ConditionBoostSpec> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec
              .ConditionBoostSpec
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public static final int CONDITION_BOOST_SPECS_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private java.util.List<
            com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec
                .ConditionBoostSpec>
        conditionBoostSpecs_;
    /**
     *
     *
     * <pre>
     * Condition boost specifications. If a suggestion matches multiple
     * conditions in the specifictions, boost values from these specifications
     * are all applied and combined in a non-linear way. Maximum number of
     * specifications is 20.
     *
     * Note: Currently only support language condition boost.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec.ConditionBoostSpec condition_boost_specs = 1;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec
                .ConditionBoostSpec>
        getConditionBoostSpecsList() {
      return conditionBoostSpecs_;
    }
    /**
     *
     *
     * <pre>
     * Condition boost specifications. If a suggestion matches multiple
     * conditions in the specifictions, boost values from these specifications
     * are all applied and combined in a non-linear way. Maximum number of
     * specifications is 20.
     *
     * Note: Currently only support language condition boost.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec.ConditionBoostSpec condition_boost_specs = 1;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends
                com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec
                    .ConditionBoostSpecOrBuilder>
        getConditionBoostSpecsOrBuilderList() {
      return conditionBoostSpecs_;
    }
    /**
     *
     *
     * <pre>
     * Condition boost specifications. If a suggestion matches multiple
     * conditions in the specifictions, boost values from these specifications
     * are all applied and combined in a non-linear way. Maximum number of
     * specifications is 20.
     *
     * Note: Currently only support language condition boost.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec.ConditionBoostSpec condition_boost_specs = 1;
     * </code>
     */
    @java.lang.Override
    public int getConditionBoostSpecsCount() {
      return conditionBoostSpecs_.size();
    }
    /**
     *
     *
     * <pre>
     * Condition boost specifications. If a suggestion matches multiple
     * conditions in the specifictions, boost values from these specifications
     * are all applied and combined in a non-linear way. Maximum number of
     * specifications is 20.
     *
     * Note: Currently only support language condition boost.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec.ConditionBoostSpec condition_boost_specs = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec
            .ConditionBoostSpec
        getConditionBoostSpecs(int index) {
      return conditionBoostSpecs_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Condition boost specifications. If a suggestion matches multiple
     * conditions in the specifictions, boost values from these specifications
     * are all applied and combined in a non-linear way. Maximum number of
     * specifications is 20.
     *
     * Note: Currently only support language condition boost.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec.ConditionBoostSpec condition_boost_specs = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec
            .ConditionBoostSpecOrBuilder
        getConditionBoostSpecsOrBuilder(int index) {
      return conditionBoostSpecs_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < conditionBoostSpecs_.size(); i++) {
        output.writeMessage(1, conditionBoostSpecs_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < conditionBoostSpecs_.size(); i++) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                1, conditionBoostSpecs_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec)) {
        return super.equals(obj);
      }
      com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec other =
          (com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec) obj;

      if (!getConditionBoostSpecsList().equals(other.getConditionBoostSpecsList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getConditionBoostSpecsCount() > 0) {
        hash = (37 * hash) + CONDITION_BOOST_SPECS_FIELD_NUMBER;
        hash = (53 * hash) + getConditionBoostSpecsList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Specification to boost suggestions based on the condtion of the suggestion.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec)
        com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpecOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1beta.CompletionServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_AdvancedCompleteQueryRequest_BoostSpec_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1beta.CompletionServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_AdvancedCompleteQueryRequest_BoostSpec_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec
                    .class,
                com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec
                    .Builder.class);
      }

      // Construct using
      // com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (conditionBoostSpecsBuilder_ == null) {
          conditionBoostSpecs_ = java.util.Collections.emptyList();
        } else {
          conditionBoostSpecs_ = null;
          conditionBoostSpecsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.discoveryengine.v1beta.CompletionServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_AdvancedCompleteQueryRequest_BoostSpec_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec
          getDefaultInstanceForType() {
        return com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec
          build() {
        com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec
          buildPartial() {
        com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec result =
            new com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec(
                this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec result) {
        if (conditionBoostSpecsBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            conditionBoostSpecs_ = java.util.Collections.unmodifiableList(conditionBoostSpecs_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.conditionBoostSpecs_ = conditionBoostSpecs_;
        } else {
          result.conditionBoostSpecs_ = conditionBoostSpecsBuilder_.build();
        }
      }

      private void buildPartial0(
          com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec result) {
        int from_bitField0_ = bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec) {
          return mergeFrom(
              (com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec other) {
        if (other
            == com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec
                .getDefaultInstance()) return this;
        if (conditionBoostSpecsBuilder_ == null) {
          if (!other.conditionBoostSpecs_.isEmpty()) {
            if (conditionBoostSpecs_.isEmpty()) {
              conditionBoostSpecs_ = other.conditionBoostSpecs_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureConditionBoostSpecsIsMutable();
              conditionBoostSpecs_.addAll(other.conditionBoostSpecs_);
            }
            onChanged();
          }
        } else {
          if (!other.conditionBoostSpecs_.isEmpty()) {
            if (conditionBoostSpecsBuilder_.isEmpty()) {
              conditionBoostSpecsBuilder_.dispose();
              conditionBoostSpecsBuilder_ = null;
              conditionBoostSpecs_ = other.conditionBoostSpecs_;
              bitField0_ = (bitField0_ & ~0x00000001);
              conditionBoostSpecsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getConditionBoostSpecsFieldBuilder()
                      : null;
            } else {
              conditionBoostSpecsBuilder_.addAllMessages(other.conditionBoostSpecs_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec
                          .ConditionBoostSpec
                      m =
                          input.readMessage(
                              com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest
                                  .BoostSpec.ConditionBoostSpec.parser(),
                              extensionRegistry);
                  if (conditionBoostSpecsBuilder_ == null) {
                    ensureConditionBoostSpecsIsMutable();
                    conditionBoostSpecs_.add(m);
                  } else {
                    conditionBoostSpecsBuilder_.addMessage(m);
                  }
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.util.List<
              com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec
                  .ConditionBoostSpec>
          conditionBoostSpecs_ = java.util.Collections.emptyList();

      private void ensureConditionBoostSpecsIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          conditionBoostSpecs_ =
              new java.util.ArrayList<
                  com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec
                      .ConditionBoostSpec>(conditionBoostSpecs_);
          bitField0_ |= 0x00000001;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec
                  .ConditionBoostSpec,
              com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec
                  .ConditionBoostSpec.Builder,
              com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec
                  .ConditionBoostSpecOrBuilder>
          conditionBoostSpecsBuilder_;

      /**
       *
       *
       * <pre>
       * Condition boost specifications. If a suggestion matches multiple
       * conditions in the specifictions, boost values from these specifications
       * are all applied and combined in a non-linear way. Maximum number of
       * specifications is 20.
       *
       * Note: Currently only support language condition boost.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec.ConditionBoostSpec condition_boost_specs = 1;
       * </code>
       */
      public java.util.List<
              com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec
                  .ConditionBoostSpec>
          getConditionBoostSpecsList() {
        if (conditionBoostSpecsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(conditionBoostSpecs_);
        } else {
          return conditionBoostSpecsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * Condition boost specifications. If a suggestion matches multiple
       * conditions in the specifictions, boost values from these specifications
       * are all applied and combined in a non-linear way. Maximum number of
       * specifications is 20.
       *
       * Note: Currently only support language condition boost.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec.ConditionBoostSpec condition_boost_specs = 1;
       * </code>
       */
      public int getConditionBoostSpecsCount() {
        if (conditionBoostSpecsBuilder_ == null) {
          return conditionBoostSpecs_.size();
        } else {
          return conditionBoostSpecsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * Condition boost specifications. If a suggestion matches multiple
       * conditions in the specifictions, boost values from these specifications
       * are all applied and combined in a non-linear way. Maximum number of
       * specifications is 20.
       *
       * Note: Currently only support language condition boost.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec.ConditionBoostSpec condition_boost_specs = 1;
       * </code>
       */
      public com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec
              .ConditionBoostSpec
          getConditionBoostSpecs(int index) {
        if (conditionBoostSpecsBuilder_ == null) {
          return conditionBoostSpecs_.get(index);
        } else {
          return conditionBoostSpecsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Condition boost specifications. If a suggestion matches multiple
       * conditions in the specifictions, boost values from these specifications
       * are all applied and combined in a non-linear way. Maximum number of
       * specifications is 20.
       *
       * Note: Currently only support language condition boost.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec.ConditionBoostSpec condition_boost_specs = 1;
       * </code>
       */
      public Builder setConditionBoostSpecs(
          int index,
          com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec
                  .ConditionBoostSpec
              value) {
        if (conditionBoostSpecsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureConditionBoostSpecsIsMutable();
          conditionBoostSpecs_.set(index, value);
          onChanged();
        } else {
          conditionBoostSpecsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Condition boost specifications. If a suggestion matches multiple
       * conditions in the specifictions, boost values from these specifications
       * are all applied and combined in a non-linear way. Maximum number of
       * specifications is 20.
       *
       * Note: Currently only support language condition boost.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec.ConditionBoostSpec condition_boost_specs = 1;
       * </code>
       */
      public Builder setConditionBoostSpecs(
          int index,
          com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec
                  .ConditionBoostSpec.Builder
              builderForValue) {
        if (conditionBoostSpecsBuilder_ == null) {
          ensureConditionBoostSpecsIsMutable();
          conditionBoostSpecs_.set(index, builderForValue.build());
          onChanged();
        } else {
          conditionBoostSpecsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Condition boost specifications. If a suggestion matches multiple
       * conditions in the specifictions, boost values from these specifications
       * are all applied and combined in a non-linear way. Maximum number of
       * specifications is 20.
       *
       * Note: Currently only support language condition boost.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec.ConditionBoostSpec condition_boost_specs = 1;
       * </code>
       */
      public Builder addConditionBoostSpecs(
          com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec
                  .ConditionBoostSpec
              value) {
        if (conditionBoostSpecsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureConditionBoostSpecsIsMutable();
          conditionBoostSpecs_.add(value);
          onChanged();
        } else {
          conditionBoostSpecsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Condition boost specifications. If a suggestion matches multiple
       * conditions in the specifictions, boost values from these specifications
       * are all applied and combined in a non-linear way. Maximum number of
       * specifications is 20.
       *
       * Note: Currently only support language condition boost.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec.ConditionBoostSpec condition_boost_specs = 1;
       * </code>
       */
      public Builder addConditionBoostSpecs(
          int index,
          com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec
                  .ConditionBoostSpec
              value) {
        if (conditionBoostSpecsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureConditionBoostSpecsIsMutable();
          conditionBoostSpecs_.add(index, value);
          onChanged();
        } else {
          conditionBoostSpecsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Condition boost specifications. If a suggestion matches multiple
       * conditions in the specifictions, boost values from these specifications
       * are all applied and combined in a non-linear way. Maximum number of
       * specifications is 20.
       *
       * Note: Currently only support language condition boost.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec.ConditionBoostSpec condition_boost_specs = 1;
       * </code>
       */
      public Builder addConditionBoostSpecs(
          com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec
                  .ConditionBoostSpec.Builder
              builderForValue) {
        if (conditionBoostSpecsBuilder_ == null) {
          ensureConditionBoostSpecsIsMutable();
          conditionBoostSpecs_.add(builderForValue.build());
          onChanged();
        } else {
          conditionBoostSpecsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Condition boost specifications. If a suggestion matches multiple
       * conditions in the specifictions, boost values from these specifications
       * are all applied and combined in a non-linear way. Maximum number of
       * specifications is 20.
       *
       * Note: Currently only support language condition boost.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec.ConditionBoostSpec condition_boost_specs = 1;
       * </code>
       */
      public Builder addConditionBoostSpecs(
          int index,
          com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec
                  .ConditionBoostSpec.Builder
              builderForValue) {
        if (conditionBoostSpecsBuilder_ == null) {
          ensureConditionBoostSpecsIsMutable();
          conditionBoostSpecs_.add(index, builderForValue.build());
          onChanged();
        } else {
          conditionBoostSpecsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Condition boost specifications. If a suggestion matches multiple
       * conditions in the specifictions, boost values from these specifications
       * are all applied and combined in a non-linear way. Maximum number of
       * specifications is 20.
       *
       * Note: Currently only support language condition boost.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec.ConditionBoostSpec condition_boost_specs = 1;
       * </code>
       */
      public Builder addAllConditionBoostSpecs(
          java.lang.Iterable<
                  ? extends
                      com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec
                          .ConditionBoostSpec>
              values) {
        if (conditionBoostSpecsBuilder_ == null) {
          ensureConditionBoostSpecsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, conditionBoostSpecs_);
          onChanged();
        } else {
          conditionBoostSpecsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Condition boost specifications. If a suggestion matches multiple
       * conditions in the specifictions, boost values from these specifications
       * are all applied and combined in a non-linear way. Maximum number of
       * specifications is 20.
       *
       * Note: Currently only support language condition boost.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec.ConditionBoostSpec condition_boost_specs = 1;
       * </code>
       */
      public Builder clearConditionBoostSpecs() {
        if (conditionBoostSpecsBuilder_ == null) {
          conditionBoostSpecs_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          conditionBoostSpecsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Condition boost specifications. If a suggestion matches multiple
       * conditions in the specifictions, boost values from these specifications
       * are all applied and combined in a non-linear way. Maximum number of
       * specifications is 20.
       *
       * Note: Currently only support language condition boost.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec.ConditionBoostSpec condition_boost_specs = 1;
       * </code>
       */
      public Builder removeConditionBoostSpecs(int index) {
        if (conditionBoostSpecsBuilder_ == null) {
          ensureConditionBoostSpecsIsMutable();
          conditionBoostSpecs_.remove(index);
          onChanged();
        } else {
          conditionBoostSpecsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Condition boost specifications. If a suggestion matches multiple
       * conditions in the specifictions, boost values from these specifications
       * are all applied and combined in a non-linear way. Maximum number of
       * specifications is 20.
       *
       * Note: Currently only support language condition boost.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec.ConditionBoostSpec condition_boost_specs = 1;
       * </code>
       */
      public com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec
              .ConditionBoostSpec.Builder
          getConditionBoostSpecsBuilder(int index) {
        return getConditionBoostSpecsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * Condition boost specifications. If a suggestion matches multiple
       * conditions in the specifictions, boost values from these specifications
       * are all applied and combined in a non-linear way. Maximum number of
       * specifications is 20.
       *
       * Note: Currently only support language condition boost.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec.ConditionBoostSpec condition_boost_specs = 1;
       * </code>
       */
      public com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec
              .ConditionBoostSpecOrBuilder
          getConditionBoostSpecsOrBuilder(int index) {
        if (conditionBoostSpecsBuilder_ == null) {
          return conditionBoostSpecs_.get(index);
        } else {
          return conditionBoostSpecsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Condition boost specifications. If a suggestion matches multiple
       * conditions in the specifictions, boost values from these specifications
       * are all applied and combined in a non-linear way. Maximum number of
       * specifications is 20.
       *
       * Note: Currently only support language condition boost.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec.ConditionBoostSpec condition_boost_specs = 1;
       * </code>
       */
      public java.util.List<
              ? extends
                  com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec
                      .ConditionBoostSpecOrBuilder>
          getConditionBoostSpecsOrBuilderList() {
        if (conditionBoostSpecsBuilder_ != null) {
          return conditionBoostSpecsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(conditionBoostSpecs_);
        }
      }
      /**
       *
       *
       * <pre>
       * Condition boost specifications. If a suggestion matches multiple
       * conditions in the specifictions, boost values from these specifications
       * are all applied and combined in a non-linear way. Maximum number of
       * specifications is 20.
       *
       * Note: Currently only support language condition boost.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec.ConditionBoostSpec condition_boost_specs = 1;
       * </code>
       */
      public com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec
              .ConditionBoostSpec.Builder
          addConditionBoostSpecsBuilder() {
        return getConditionBoostSpecsFieldBuilder()
            .addBuilder(
                com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec
                    .ConditionBoostSpec.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Condition boost specifications. If a suggestion matches multiple
       * conditions in the specifictions, boost values from these specifications
       * are all applied and combined in a non-linear way. Maximum number of
       * specifications is 20.
       *
       * Note: Currently only support language condition boost.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec.ConditionBoostSpec condition_boost_specs = 1;
       * </code>
       */
      public com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec
              .ConditionBoostSpec.Builder
          addConditionBoostSpecsBuilder(int index) {
        return getConditionBoostSpecsFieldBuilder()
            .addBuilder(
                index,
                com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec
                    .ConditionBoostSpec.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Condition boost specifications. If a suggestion matches multiple
       * conditions in the specifictions, boost values from these specifications
       * are all applied and combined in a non-linear way. Maximum number of
       * specifications is 20.
       *
       * Note: Currently only support language condition boost.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec.ConditionBoostSpec condition_boost_specs = 1;
       * </code>
       */
      public java.util.List<
              com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec
                  .ConditionBoostSpec.Builder>
          getConditionBoostSpecsBuilderList() {
        return getConditionBoostSpecsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec
                  .ConditionBoostSpec,
              com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec
                  .ConditionBoostSpec.Builder,
              com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec
                  .ConditionBoostSpecOrBuilder>
          getConditionBoostSpecsFieldBuilder() {
        if (conditionBoostSpecsBuilder_ == null) {
          conditionBoostSpecsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec
                      .ConditionBoostSpec,
                  com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec
                      .ConditionBoostSpec.Builder,
                  com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec
                      .ConditionBoostSpecOrBuilder>(
                  conditionBoostSpecs_,
                  ((bitField0_ & 0x00000001) != 0),
                  getParentForChildren(),
                  isClean());
          conditionBoostSpecs_ = null;
        }
        return conditionBoostSpecsBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec)
    private static final com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest
            .BoostSpec
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec();
    }

    public static com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<BoostSpec> PARSER =
        new com.google.protobuf.AbstractParser<BoostSpec>() {
          @java.lang.Override
          public BoostSpec parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<BoostSpec> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<BoostSpec> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int COMPLETION_CONFIG_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object completionConfig_ = "";
  /**
   *
   *
   * <pre>
   * Required. The completion_config of the parent dataStore or engine resource
   * name for which the completion is performed, such as
   * `projects/&#42;&#47;locations/global/collections/default_collection/dataStores/&#42;&#47;completionConfig`
   * `projects/&#42;&#47;locations/global/collections/default_collection/engines/&#42;&#47;completionConfig`.
   * </pre>
   *
   * <code>
   * string completion_config = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The completionConfig.
   */
  @java.lang.Override
  public java.lang.String getCompletionConfig() {
    java.lang.Object ref = completionConfig_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      completionConfig_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The completion_config of the parent dataStore or engine resource
   * name for which the completion is performed, such as
   * `projects/&#42;&#47;locations/global/collections/default_collection/dataStores/&#42;&#47;completionConfig`
   * `projects/&#42;&#47;locations/global/collections/default_collection/engines/&#42;&#47;completionConfig`.
   * </pre>
   *
   * <code>
   * string completion_config = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for completionConfig.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCompletionConfigBytes() {
    java.lang.Object ref = completionConfig_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      completionConfig_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int QUERY_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object query_ = "";
  /**
   *
   *
   * <pre>
   * Required. The typeahead input used to fetch suggestions. Maximum length is
   * 128 characters.
   *
   * The query can not be empty for most of the suggestion types. If it is
   * empty, an `INVALID_ARGUMENT` error is returned. The exception is when the
   * suggestion_types contains only the type `RECENT_SEARCH`, the query can
   * be an empty string. The is called "zero prefix" feature, which returns
   * user's recently searched queries given the empty query.
   * </pre>
   *
   * <code>string query = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The query.
   */
  @java.lang.Override
  public java.lang.String getQuery() {
    java.lang.Object ref = query_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      query_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The typeahead input used to fetch suggestions. Maximum length is
   * 128 characters.
   *
   * The query can not be empty for most of the suggestion types. If it is
   * empty, an `INVALID_ARGUMENT` error is returned. The exception is when the
   * suggestion_types contains only the type `RECENT_SEARCH`, the query can
   * be an empty string. The is called "zero prefix" feature, which returns
   * user's recently searched queries given the empty query.
   * </pre>
   *
   * <code>string query = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for query.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getQueryBytes() {
    java.lang.Object ref = query_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      query_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int QUERY_MODEL_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object queryModel_ = "";
  /**
   *
   *
   * <pre>
   * Specifies the autocomplete data model. This overrides any model specified
   * in the Configuration &gt; Autocomplete section of the Cloud console. Currently
   * supported values:
   *
   * * `document` - Using suggestions generated from user-imported documents.
   * * `search-history` - Using suggestions generated from the past history of
   * [SearchService.Search][google.cloud.discoveryengine.v1beta.SearchService.Search]
   * API calls. Do not use it when there is no traffic for Search API.
   * * `user-event` - Using suggestions generated from user-imported search
   * events.
   * * `document-completable` - Using suggestions taken directly from
   * user-imported document fields marked as completable.
   *
   * Default values:
   *
   * * `document` is the default model for regular dataStores.
   * * `search-history` is the default model for site search dataStores.
   * </pre>
   *
   * <code>string query_model = 3;</code>
   *
   * @return The queryModel.
   */
  @java.lang.Override
  public java.lang.String getQueryModel() {
    java.lang.Object ref = queryModel_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      queryModel_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Specifies the autocomplete data model. This overrides any model specified
   * in the Configuration &gt; Autocomplete section of the Cloud console. Currently
   * supported values:
   *
   * * `document` - Using suggestions generated from user-imported documents.
   * * `search-history` - Using suggestions generated from the past history of
   * [SearchService.Search][google.cloud.discoveryengine.v1beta.SearchService.Search]
   * API calls. Do not use it when there is no traffic for Search API.
   * * `user-event` - Using suggestions generated from user-imported search
   * events.
   * * `document-completable` - Using suggestions taken directly from
   * user-imported document fields marked as completable.
   *
   * Default values:
   *
   * * `document` is the default model for regular dataStores.
   * * `search-history` is the default model for site search dataStores.
   * </pre>
   *
   * <code>string query_model = 3;</code>
   *
   * @return The bytes for queryModel.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getQueryModelBytes() {
    java.lang.Object ref = queryModel_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      queryModel_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int USER_PSEUDO_ID_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object userPseudoId_ = "";
  /**
   *
   *
   * <pre>
   * A unique identifier for tracking visitors. For example, this could be
   * implemented with an HTTP cookie, which should be able to uniquely identify
   * a visitor on a single device. This unique identifier should not change if
   * the visitor logs in or out of the website.
   *
   * This field should NOT have a fixed value such as `unknown_visitor`.
   *
   * This should be the same identifier as
   * [UserEvent.user_pseudo_id][google.cloud.discoveryengine.v1beta.UserEvent.user_pseudo_id]
   * and
   * [SearchRequest.user_pseudo_id][google.cloud.discoveryengine.v1beta.SearchRequest.user_pseudo_id].
   *
   * The field must be a UTF-8 encoded string with a length limit of 128
   * </pre>
   *
   * <code>string user_pseudo_id = 4;</code>
   *
   * @return The userPseudoId.
   */
  @java.lang.Override
  public java.lang.String getUserPseudoId() {
    java.lang.Object ref = userPseudoId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      userPseudoId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A unique identifier for tracking visitors. For example, this could be
   * implemented with an HTTP cookie, which should be able to uniquely identify
   * a visitor on a single device. This unique identifier should not change if
   * the visitor logs in or out of the website.
   *
   * This field should NOT have a fixed value such as `unknown_visitor`.
   *
   * This should be the same identifier as
   * [UserEvent.user_pseudo_id][google.cloud.discoveryengine.v1beta.UserEvent.user_pseudo_id]
   * and
   * [SearchRequest.user_pseudo_id][google.cloud.discoveryengine.v1beta.SearchRequest.user_pseudo_id].
   *
   * The field must be a UTF-8 encoded string with a length limit of 128
   * </pre>
   *
   * <code>string user_pseudo_id = 4;</code>
   *
   * @return The bytes for userPseudoId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getUserPseudoIdBytes() {
    java.lang.Object ref = userPseudoId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      userPseudoId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int USER_INFO_FIELD_NUMBER = 9;
  private com.google.cloud.discoveryengine.v1beta.UserInfo userInfo_;
  /**
   *
   *
   * <pre>
   * Optional. Information about the end user.
   *
   * This should be the same identifier information as
   * [UserEvent.user_info][google.cloud.discoveryengine.v1beta.UserEvent.user_info]
   * and
   * [SearchRequest.user_info][google.cloud.discoveryengine.v1beta.SearchRequest.user_info].
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1beta.UserInfo user_info = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the userInfo field is set.
   */
  @java.lang.Override
  public boolean hasUserInfo() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. Information about the end user.
   *
   * This should be the same identifier information as
   * [UserEvent.user_info][google.cloud.discoveryengine.v1beta.UserEvent.user_info]
   * and
   * [SearchRequest.user_info][google.cloud.discoveryengine.v1beta.SearchRequest.user_info].
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1beta.UserInfo user_info = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The userInfo.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.UserInfo getUserInfo() {
    return userInfo_ == null
        ? com.google.cloud.discoveryengine.v1beta.UserInfo.getDefaultInstance()
        : userInfo_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Information about the end user.
   *
   * This should be the same identifier information as
   * [UserEvent.user_info][google.cloud.discoveryengine.v1beta.UserEvent.user_info]
   * and
   * [SearchRequest.user_info][google.cloud.discoveryengine.v1beta.SearchRequest.user_info].
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1beta.UserInfo user_info = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.UserInfoOrBuilder getUserInfoOrBuilder() {
    return userInfo_ == null
        ? com.google.cloud.discoveryengine.v1beta.UserInfo.getDefaultInstance()
        : userInfo_;
  }

  public static final int INCLUDE_TAIL_SUGGESTIONS_FIELD_NUMBER = 5;
  private boolean includeTailSuggestions_ = false;
  /**
   *
   *
   * <pre>
   * Indicates if tail suggestions should be returned if there are no
   * suggestions that match the full query. Even if set to true, if there are
   * suggestions that match the full query, those are returned and no
   * tail suggestions are returned.
   * </pre>
   *
   * <code>bool include_tail_suggestions = 5;</code>
   *
   * @return The includeTailSuggestions.
   */
  @java.lang.Override
  public boolean getIncludeTailSuggestions() {
    return includeTailSuggestions_;
  }

  public static final int BOOST_SPEC_FIELD_NUMBER = 6;
  private com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec boostSpec_;
  /**
   *
   *
   * <pre>
   * Optional. Specification to boost suggestions matching the condition.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec boost_spec = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the boostSpec field is set.
   */
  @java.lang.Override
  public boolean hasBoostSpec() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. Specification to boost suggestions matching the condition.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec boost_spec = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The boostSpec.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec
      getBoostSpec() {
    return boostSpec_ == null
        ? com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec
            .getDefaultInstance()
        : boostSpec_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Specification to boost suggestions matching the condition.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec boost_spec = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpecOrBuilder
      getBoostSpecOrBuilder() {
    return boostSpec_ == null
        ? com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec
            .getDefaultInstance()
        : boostSpec_;
  }

  public static final int SUGGESTION_TYPES_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private java.util.List<java.lang.Integer> suggestionTypes_;

  private static final com.google.protobuf.Internal.ListAdapter.Converter<
          java.lang.Integer,
          com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.SuggestionType>
      suggestionTypes_converter_ =
          new com.google.protobuf.Internal.ListAdapter.Converter<
              java.lang.Integer,
              com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest
                  .SuggestionType>() {
            public com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest
                    .SuggestionType
                convert(java.lang.Integer from) {
              com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.SuggestionType
                  result =
                      com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest
                          .SuggestionType.forNumber(from);
              return result == null
                  ? com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest
                      .SuggestionType.UNRECOGNIZED
                  : result;
            }
          };
  /**
   *
   *
   * <pre>
   * Optional. Suggestion types to return. If empty or unspecified, query
   * suggestions are returned. Only one suggestion type is supported at the
   * moment.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.SuggestionType suggestion_types = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return A list containing the suggestionTypes.
   */
  @java.lang.Override
  public java.util.List<
          com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.SuggestionType>
      getSuggestionTypesList() {
    return new com.google.protobuf.Internal.ListAdapter<
        java.lang.Integer,
        com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.SuggestionType>(
        suggestionTypes_, suggestionTypes_converter_);
  }
  /**
   *
   *
   * <pre>
   * Optional. Suggestion types to return. If empty or unspecified, query
   * suggestions are returned. Only one suggestion type is supported at the
   * moment.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.SuggestionType suggestion_types = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The count of suggestionTypes.
   */
  @java.lang.Override
  public int getSuggestionTypesCount() {
    return suggestionTypes_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. Suggestion types to return. If empty or unspecified, query
   * suggestions are returned. Only one suggestion type is supported at the
   * moment.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.SuggestionType suggestion_types = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @param index The index of the element to return.
   * @return The suggestionTypes at the given index.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.SuggestionType
      getSuggestionTypes(int index) {
    return suggestionTypes_converter_.convert(suggestionTypes_.get(index));
  }
  /**
   *
   *
   * <pre>
   * Optional. Suggestion types to return. If empty or unspecified, query
   * suggestions are returned. Only one suggestion type is supported at the
   * moment.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.SuggestionType suggestion_types = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return A list containing the enum numeric values on the wire for suggestionTypes.
   */
  @java.lang.Override
  public java.util.List<java.lang.Integer> getSuggestionTypesValueList() {
    return suggestionTypes_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Suggestion types to return. If empty or unspecified, query
   * suggestions are returned. Only one suggestion type is supported at the
   * moment.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.SuggestionType suggestion_types = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @param index The index of the value to return.
   * @return The enum numeric value on the wire of suggestionTypes at the given index.
   */
  @java.lang.Override
  public int getSuggestionTypesValue(int index) {
    return suggestionTypes_.get(index);
  }

  private int suggestionTypesMemoizedSerializedSize;

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    getSerializedSize();
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(completionConfig_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, completionConfig_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(query_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, query_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(queryModel_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, queryModel_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(userPseudoId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, userPseudoId_);
    }
    if (includeTailSuggestions_ != false) {
      output.writeBool(5, includeTailSuggestions_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(6, getBoostSpec());
    }
    if (getSuggestionTypesList().size() > 0) {
      output.writeUInt32NoTag(58);
      output.writeUInt32NoTag(suggestionTypesMemoizedSerializedSize);
    }
    for (int i = 0; i < suggestionTypes_.size(); i++) {
      output.writeEnumNoTag(suggestionTypes_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(9, getUserInfo());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(completionConfig_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, completionConfig_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(query_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, query_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(queryModel_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, queryModel_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(userPseudoId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, userPseudoId_);
    }
    if (includeTailSuggestions_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(5, includeTailSuggestions_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getBoostSpec());
    }
    {
      int dataSize = 0;
      for (int i = 0; i < suggestionTypes_.size(); i++) {
        dataSize +=
            com.google.protobuf.CodedOutputStream.computeEnumSizeNoTag(suggestionTypes_.get(i));
      }
      size += dataSize;
      if (!getSuggestionTypesList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(dataSize);
      }
      suggestionTypesMemoizedSerializedSize = dataSize;
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getUserInfo());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest other =
        (com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest) obj;

    if (!getCompletionConfig().equals(other.getCompletionConfig())) return false;
    if (!getQuery().equals(other.getQuery())) return false;
    if (!getQueryModel().equals(other.getQueryModel())) return false;
    if (!getUserPseudoId().equals(other.getUserPseudoId())) return false;
    if (hasUserInfo() != other.hasUserInfo()) return false;
    if (hasUserInfo()) {
      if (!getUserInfo().equals(other.getUserInfo())) return false;
    }
    if (getIncludeTailSuggestions() != other.getIncludeTailSuggestions()) return false;
    if (hasBoostSpec() != other.hasBoostSpec()) return false;
    if (hasBoostSpec()) {
      if (!getBoostSpec().equals(other.getBoostSpec())) return false;
    }
    if (!suggestionTypes_.equals(other.suggestionTypes_)) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + COMPLETION_CONFIG_FIELD_NUMBER;
    hash = (53 * hash) + getCompletionConfig().hashCode();
    hash = (37 * hash) + QUERY_FIELD_NUMBER;
    hash = (53 * hash) + getQuery().hashCode();
    hash = (37 * hash) + QUERY_MODEL_FIELD_NUMBER;
    hash = (53 * hash) + getQueryModel().hashCode();
    hash = (37 * hash) + USER_PSEUDO_ID_FIELD_NUMBER;
    hash = (53 * hash) + getUserPseudoId().hashCode();
    if (hasUserInfo()) {
      hash = (37 * hash) + USER_INFO_FIELD_NUMBER;
      hash = (53 * hash) + getUserInfo().hashCode();
    }
    hash = (37 * hash) + INCLUDE_TAIL_SUGGESTIONS_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getIncludeTailSuggestions());
    if (hasBoostSpec()) {
      hash = (37 * hash) + BOOST_SPEC_FIELD_NUMBER;
      hash = (53 * hash) + getBoostSpec().hashCode();
    }
    if (getSuggestionTypesCount() > 0) {
      hash = (37 * hash) + SUGGESTION_TYPES_FIELD_NUMBER;
      hash = (53 * hash) + suggestionTypes_.hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request message for
   * [CompletionService.AdvancedCompleteQuery][google.cloud.discoveryengine.v1beta.CompletionService.AdvancedCompleteQuery]
   * method.
   * .
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest)
      com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1beta.CompletionServiceProto
          .internal_static_google_cloud_discoveryengine_v1beta_AdvancedCompleteQueryRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1beta.CompletionServiceProto
          .internal_static_google_cloud_discoveryengine_v1beta_AdvancedCompleteQueryRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.class,
              com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.Builder.class);
    }

    // Construct using
    // com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getUserInfoFieldBuilder();
        getBoostSpecFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      completionConfig_ = "";
      query_ = "";
      queryModel_ = "";
      userPseudoId_ = "";
      userInfo_ = null;
      if (userInfoBuilder_ != null) {
        userInfoBuilder_.dispose();
        userInfoBuilder_ = null;
      }
      includeTailSuggestions_ = false;
      boostSpec_ = null;
      if (boostSpecBuilder_ != null) {
        boostSpecBuilder_.dispose();
        boostSpecBuilder_ = null;
      }
      suggestionTypes_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000080);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.discoveryengine.v1beta.CompletionServiceProto
          .internal_static_google_cloud_discoveryengine_v1beta_AdvancedCompleteQueryRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest
        getDefaultInstanceForType() {
      return com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest
          .getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest build() {
      com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest buildPartial() {
      com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest result =
          new com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest result) {
      if (((bitField0_ & 0x00000080) != 0)) {
        suggestionTypes_ = java.util.Collections.unmodifiableList(suggestionTypes_);
        bitField0_ = (bitField0_ & ~0x00000080);
      }
      result.suggestionTypes_ = suggestionTypes_;
    }

    private void buildPartial0(
        com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.completionConfig_ = completionConfig_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.query_ = query_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.queryModel_ = queryModel_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.userPseudoId_ = userPseudoId_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.userInfo_ = userInfoBuilder_ == null ? userInfo_ : userInfoBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.includeTailSuggestions_ = includeTailSuggestions_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.boostSpec_ = boostSpecBuilder_ == null ? boostSpec_ : boostSpecBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest) {
        return mergeFrom(
            (com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest other) {
      if (other
          == com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest
              .getDefaultInstance()) return this;
      if (!other.getCompletionConfig().isEmpty()) {
        completionConfig_ = other.completionConfig_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getQuery().isEmpty()) {
        query_ = other.query_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getQueryModel().isEmpty()) {
        queryModel_ = other.queryModel_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getUserPseudoId().isEmpty()) {
        userPseudoId_ = other.userPseudoId_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.hasUserInfo()) {
        mergeUserInfo(other.getUserInfo());
      }
      if (other.getIncludeTailSuggestions() != false) {
        setIncludeTailSuggestions(other.getIncludeTailSuggestions());
      }
      if (other.hasBoostSpec()) {
        mergeBoostSpec(other.getBoostSpec());
      }
      if (!other.suggestionTypes_.isEmpty()) {
        if (suggestionTypes_.isEmpty()) {
          suggestionTypes_ = other.suggestionTypes_;
          bitField0_ = (bitField0_ & ~0x00000080);
        } else {
          ensureSuggestionTypesIsMutable();
          suggestionTypes_.addAll(other.suggestionTypes_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                completionConfig_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                query_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                queryModel_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                userPseudoId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 40:
              {
                includeTailSuggestions_ = input.readBool();
                bitField0_ |= 0x00000020;
                break;
              } // case 40
            case 50:
              {
                input.readMessage(getBoostSpecFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 50
            case 56:
              {
                int tmpRaw = input.readEnum();
                ensureSuggestionTypesIsMutable();
                suggestionTypes_.add(tmpRaw);
                break;
              } // case 56
            case 58:
              {
                int length = input.readRawVarint32();
                int oldLimit = input.pushLimit(length);
                while (input.getBytesUntilLimit() > 0) {
                  int tmpRaw = input.readEnum();
                  ensureSuggestionTypesIsMutable();
                  suggestionTypes_.add(tmpRaw);
                }
                input.popLimit(oldLimit);
                break;
              } // case 58
            case 74:
              {
                input.readMessage(getUserInfoFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 74
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object completionConfig_ = "";
    /**
     *
     *
     * <pre>
     * Required. The completion_config of the parent dataStore or engine resource
     * name for which the completion is performed, such as
     * `projects/&#42;&#47;locations/global/collections/default_collection/dataStores/&#42;&#47;completionConfig`
     * `projects/&#42;&#47;locations/global/collections/default_collection/engines/&#42;&#47;completionConfig`.
     * </pre>
     *
     * <code>
     * string completion_config = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The completionConfig.
     */
    public java.lang.String getCompletionConfig() {
      java.lang.Object ref = completionConfig_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        completionConfig_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The completion_config of the parent dataStore or engine resource
     * name for which the completion is performed, such as
     * `projects/&#42;&#47;locations/global/collections/default_collection/dataStores/&#42;&#47;completionConfig`
     * `projects/&#42;&#47;locations/global/collections/default_collection/engines/&#42;&#47;completionConfig`.
     * </pre>
     *
     * <code>
     * string completion_config = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for completionConfig.
     */
    public com.google.protobuf.ByteString getCompletionConfigBytes() {
      java.lang.Object ref = completionConfig_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        completionConfig_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The completion_config of the parent dataStore or engine resource
     * name for which the completion is performed, such as
     * `projects/&#42;&#47;locations/global/collections/default_collection/dataStores/&#42;&#47;completionConfig`
     * `projects/&#42;&#47;locations/global/collections/default_collection/engines/&#42;&#47;completionConfig`.
     * </pre>
     *
     * <code>
     * string completion_config = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The completionConfig to set.
     * @return This builder for chaining.
     */
    public Builder setCompletionConfig(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      completionConfig_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The completion_config of the parent dataStore or engine resource
     * name for which the completion is performed, such as
     * `projects/&#42;&#47;locations/global/collections/default_collection/dataStores/&#42;&#47;completionConfig`
     * `projects/&#42;&#47;locations/global/collections/default_collection/engines/&#42;&#47;completionConfig`.
     * </pre>
     *
     * <code>
     * string completion_config = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCompletionConfig() {
      completionConfig_ = getDefaultInstance().getCompletionConfig();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The completion_config of the parent dataStore or engine resource
     * name for which the completion is performed, such as
     * `projects/&#42;&#47;locations/global/collections/default_collection/dataStores/&#42;&#47;completionConfig`
     * `projects/&#42;&#47;locations/global/collections/default_collection/engines/&#42;&#47;completionConfig`.
     * </pre>
     *
     * <code>
     * string completion_config = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for completionConfig to set.
     * @return This builder for chaining.
     */
    public Builder setCompletionConfigBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      completionConfig_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object query_ = "";
    /**
     *
     *
     * <pre>
     * Required. The typeahead input used to fetch suggestions. Maximum length is
     * 128 characters.
     *
     * The query can not be empty for most of the suggestion types. If it is
     * empty, an `INVALID_ARGUMENT` error is returned. The exception is when the
     * suggestion_types contains only the type `RECENT_SEARCH`, the query can
     * be an empty string. The is called "zero prefix" feature, which returns
     * user's recently searched queries given the empty query.
     * </pre>
     *
     * <code>string query = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The query.
     */
    public java.lang.String getQuery() {
      java.lang.Object ref = query_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        query_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The typeahead input used to fetch suggestions. Maximum length is
     * 128 characters.
     *
     * The query can not be empty for most of the suggestion types. If it is
     * empty, an `INVALID_ARGUMENT` error is returned. The exception is when the
     * suggestion_types contains only the type `RECENT_SEARCH`, the query can
     * be an empty string. The is called "zero prefix" feature, which returns
     * user's recently searched queries given the empty query.
     * </pre>
     *
     * <code>string query = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for query.
     */
    public com.google.protobuf.ByteString getQueryBytes() {
      java.lang.Object ref = query_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        query_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The typeahead input used to fetch suggestions. Maximum length is
     * 128 characters.
     *
     * The query can not be empty for most of the suggestion types. If it is
     * empty, an `INVALID_ARGUMENT` error is returned. The exception is when the
     * suggestion_types contains only the type `RECENT_SEARCH`, the query can
     * be an empty string. The is called "zero prefix" feature, which returns
     * user's recently searched queries given the empty query.
     * </pre>
     *
     * <code>string query = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The query to set.
     * @return This builder for chaining.
     */
    public Builder setQuery(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      query_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The typeahead input used to fetch suggestions. Maximum length is
     * 128 characters.
     *
     * The query can not be empty for most of the suggestion types. If it is
     * empty, an `INVALID_ARGUMENT` error is returned. The exception is when the
     * suggestion_types contains only the type `RECENT_SEARCH`, the query can
     * be an empty string. The is called "zero prefix" feature, which returns
     * user's recently searched queries given the empty query.
     * </pre>
     *
     * <code>string query = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearQuery() {
      query_ = getDefaultInstance().getQuery();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The typeahead input used to fetch suggestions. Maximum length is
     * 128 characters.
     *
     * The query can not be empty for most of the suggestion types. If it is
     * empty, an `INVALID_ARGUMENT` error is returned. The exception is when the
     * suggestion_types contains only the type `RECENT_SEARCH`, the query can
     * be an empty string. The is called "zero prefix" feature, which returns
     * user's recently searched queries given the empty query.
     * </pre>
     *
     * <code>string query = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for query to set.
     * @return This builder for chaining.
     */
    public Builder setQueryBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      query_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object queryModel_ = "";
    /**
     *
     *
     * <pre>
     * Specifies the autocomplete data model. This overrides any model specified
     * in the Configuration &gt; Autocomplete section of the Cloud console. Currently
     * supported values:
     *
     * * `document` - Using suggestions generated from user-imported documents.
     * * `search-history` - Using suggestions generated from the past history of
     * [SearchService.Search][google.cloud.discoveryengine.v1beta.SearchService.Search]
     * API calls. Do not use it when there is no traffic for Search API.
     * * `user-event` - Using suggestions generated from user-imported search
     * events.
     * * `document-completable` - Using suggestions taken directly from
     * user-imported document fields marked as completable.
     *
     * Default values:
     *
     * * `document` is the default model for regular dataStores.
     * * `search-history` is the default model for site search dataStores.
     * </pre>
     *
     * <code>string query_model = 3;</code>
     *
     * @return The queryModel.
     */
    public java.lang.String getQueryModel() {
      java.lang.Object ref = queryModel_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        queryModel_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies the autocomplete data model. This overrides any model specified
     * in the Configuration &gt; Autocomplete section of the Cloud console. Currently
     * supported values:
     *
     * * `document` - Using suggestions generated from user-imported documents.
     * * `search-history` - Using suggestions generated from the past history of
     * [SearchService.Search][google.cloud.discoveryengine.v1beta.SearchService.Search]
     * API calls. Do not use it when there is no traffic for Search API.
     * * `user-event` - Using suggestions generated from user-imported search
     * events.
     * * `document-completable` - Using suggestions taken directly from
     * user-imported document fields marked as completable.
     *
     * Default values:
     *
     * * `document` is the default model for regular dataStores.
     * * `search-history` is the default model for site search dataStores.
     * </pre>
     *
     * <code>string query_model = 3;</code>
     *
     * @return The bytes for queryModel.
     */
    public com.google.protobuf.ByteString getQueryModelBytes() {
      java.lang.Object ref = queryModel_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        queryModel_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies the autocomplete data model. This overrides any model specified
     * in the Configuration &gt; Autocomplete section of the Cloud console. Currently
     * supported values:
     *
     * * `document` - Using suggestions generated from user-imported documents.
     * * `search-history` - Using suggestions generated from the past history of
     * [SearchService.Search][google.cloud.discoveryengine.v1beta.SearchService.Search]
     * API calls. Do not use it when there is no traffic for Search API.
     * * `user-event` - Using suggestions generated from user-imported search
     * events.
     * * `document-completable` - Using suggestions taken directly from
     * user-imported document fields marked as completable.
     *
     * Default values:
     *
     * * `document` is the default model for regular dataStores.
     * * `search-history` is the default model for site search dataStores.
     * </pre>
     *
     * <code>string query_model = 3;</code>
     *
     * @param value The queryModel to set.
     * @return This builder for chaining.
     */
    public Builder setQueryModel(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      queryModel_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the autocomplete data model. This overrides any model specified
     * in the Configuration &gt; Autocomplete section of the Cloud console. Currently
     * supported values:
     *
     * * `document` - Using suggestions generated from user-imported documents.
     * * `search-history` - Using suggestions generated from the past history of
     * [SearchService.Search][google.cloud.discoveryengine.v1beta.SearchService.Search]
     * API calls. Do not use it when there is no traffic for Search API.
     * * `user-event` - Using suggestions generated from user-imported search
     * events.
     * * `document-completable` - Using suggestions taken directly from
     * user-imported document fields marked as completable.
     *
     * Default values:
     *
     * * `document` is the default model for regular dataStores.
     * * `search-history` is the default model for site search dataStores.
     * </pre>
     *
     * <code>string query_model = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearQueryModel() {
      queryModel_ = getDefaultInstance().getQueryModel();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the autocomplete data model. This overrides any model specified
     * in the Configuration &gt; Autocomplete section of the Cloud console. Currently
     * supported values:
     *
     * * `document` - Using suggestions generated from user-imported documents.
     * * `search-history` - Using suggestions generated from the past history of
     * [SearchService.Search][google.cloud.discoveryengine.v1beta.SearchService.Search]
     * API calls. Do not use it when there is no traffic for Search API.
     * * `user-event` - Using suggestions generated from user-imported search
     * events.
     * * `document-completable` - Using suggestions taken directly from
     * user-imported document fields marked as completable.
     *
     * Default values:
     *
     * * `document` is the default model for regular dataStores.
     * * `search-history` is the default model for site search dataStores.
     * </pre>
     *
     * <code>string query_model = 3;</code>
     *
     * @param value The bytes for queryModel to set.
     * @return This builder for chaining.
     */
    public Builder setQueryModelBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      queryModel_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object userPseudoId_ = "";
    /**
     *
     *
     * <pre>
     * A unique identifier for tracking visitors. For example, this could be
     * implemented with an HTTP cookie, which should be able to uniquely identify
     * a visitor on a single device. This unique identifier should not change if
     * the visitor logs in or out of the website.
     *
     * This field should NOT have a fixed value such as `unknown_visitor`.
     *
     * This should be the same identifier as
     * [UserEvent.user_pseudo_id][google.cloud.discoveryengine.v1beta.UserEvent.user_pseudo_id]
     * and
     * [SearchRequest.user_pseudo_id][google.cloud.discoveryengine.v1beta.SearchRequest.user_pseudo_id].
     *
     * The field must be a UTF-8 encoded string with a length limit of 128
     * </pre>
     *
     * <code>string user_pseudo_id = 4;</code>
     *
     * @return The userPseudoId.
     */
    public java.lang.String getUserPseudoId() {
      java.lang.Object ref = userPseudoId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        userPseudoId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A unique identifier for tracking visitors. For example, this could be
     * implemented with an HTTP cookie, which should be able to uniquely identify
     * a visitor on a single device. This unique identifier should not change if
     * the visitor logs in or out of the website.
     *
     * This field should NOT have a fixed value such as `unknown_visitor`.
     *
     * This should be the same identifier as
     * [UserEvent.user_pseudo_id][google.cloud.discoveryengine.v1beta.UserEvent.user_pseudo_id]
     * and
     * [SearchRequest.user_pseudo_id][google.cloud.discoveryengine.v1beta.SearchRequest.user_pseudo_id].
     *
     * The field must be a UTF-8 encoded string with a length limit of 128
     * </pre>
     *
     * <code>string user_pseudo_id = 4;</code>
     *
     * @return The bytes for userPseudoId.
     */
    public com.google.protobuf.ByteString getUserPseudoIdBytes() {
      java.lang.Object ref = userPseudoId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        userPseudoId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A unique identifier for tracking visitors. For example, this could be
     * implemented with an HTTP cookie, which should be able to uniquely identify
     * a visitor on a single device. This unique identifier should not change if
     * the visitor logs in or out of the website.
     *
     * This field should NOT have a fixed value such as `unknown_visitor`.
     *
     * This should be the same identifier as
     * [UserEvent.user_pseudo_id][google.cloud.discoveryengine.v1beta.UserEvent.user_pseudo_id]
     * and
     * [SearchRequest.user_pseudo_id][google.cloud.discoveryengine.v1beta.SearchRequest.user_pseudo_id].
     *
     * The field must be a UTF-8 encoded string with a length limit of 128
     * </pre>
     *
     * <code>string user_pseudo_id = 4;</code>
     *
     * @param value The userPseudoId to set.
     * @return This builder for chaining.
     */
    public Builder setUserPseudoId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      userPseudoId_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A unique identifier for tracking visitors. For example, this could be
     * implemented with an HTTP cookie, which should be able to uniquely identify
     * a visitor on a single device. This unique identifier should not change if
     * the visitor logs in or out of the website.
     *
     * This field should NOT have a fixed value such as `unknown_visitor`.
     *
     * This should be the same identifier as
     * [UserEvent.user_pseudo_id][google.cloud.discoveryengine.v1beta.UserEvent.user_pseudo_id]
     * and
     * [SearchRequest.user_pseudo_id][google.cloud.discoveryengine.v1beta.SearchRequest.user_pseudo_id].
     *
     * The field must be a UTF-8 encoded string with a length limit of 128
     * </pre>
     *
     * <code>string user_pseudo_id = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUserPseudoId() {
      userPseudoId_ = getDefaultInstance().getUserPseudoId();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A unique identifier for tracking visitors. For example, this could be
     * implemented with an HTTP cookie, which should be able to uniquely identify
     * a visitor on a single device. This unique identifier should not change if
     * the visitor logs in or out of the website.
     *
     * This field should NOT have a fixed value such as `unknown_visitor`.
     *
     * This should be the same identifier as
     * [UserEvent.user_pseudo_id][google.cloud.discoveryengine.v1beta.UserEvent.user_pseudo_id]
     * and
     * [SearchRequest.user_pseudo_id][google.cloud.discoveryengine.v1beta.SearchRequest.user_pseudo_id].
     *
     * The field must be a UTF-8 encoded string with a length limit of 128
     * </pre>
     *
     * <code>string user_pseudo_id = 4;</code>
     *
     * @param value The bytes for userPseudoId to set.
     * @return This builder for chaining.
     */
    public Builder setUserPseudoIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      userPseudoId_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private com.google.cloud.discoveryengine.v1beta.UserInfo userInfo_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1beta.UserInfo,
            com.google.cloud.discoveryengine.v1beta.UserInfo.Builder,
            com.google.cloud.discoveryengine.v1beta.UserInfoOrBuilder>
        userInfoBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Information about the end user.
     *
     * This should be the same identifier information as
     * [UserEvent.user_info][google.cloud.discoveryengine.v1beta.UserEvent.user_info]
     * and
     * [SearchRequest.user_info][google.cloud.discoveryengine.v1beta.SearchRequest.user_info].
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.UserInfo user_info = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the userInfo field is set.
     */
    public boolean hasUserInfo() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Information about the end user.
     *
     * This should be the same identifier information as
     * [UserEvent.user_info][google.cloud.discoveryengine.v1beta.UserEvent.user_info]
     * and
     * [SearchRequest.user_info][google.cloud.discoveryengine.v1beta.SearchRequest.user_info].
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.UserInfo user_info = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The userInfo.
     */
    public com.google.cloud.discoveryengine.v1beta.UserInfo getUserInfo() {
      if (userInfoBuilder_ == null) {
        return userInfo_ == null
            ? com.google.cloud.discoveryengine.v1beta.UserInfo.getDefaultInstance()
            : userInfo_;
      } else {
        return userInfoBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Information about the end user.
     *
     * This should be the same identifier information as
     * [UserEvent.user_info][google.cloud.discoveryengine.v1beta.UserEvent.user_info]
     * and
     * [SearchRequest.user_info][google.cloud.discoveryengine.v1beta.SearchRequest.user_info].
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.UserInfo user_info = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setUserInfo(com.google.cloud.discoveryengine.v1beta.UserInfo value) {
      if (userInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        userInfo_ = value;
      } else {
        userInfoBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Information about the end user.
     *
     * This should be the same identifier information as
     * [UserEvent.user_info][google.cloud.discoveryengine.v1beta.UserEvent.user_info]
     * and
     * [SearchRequest.user_info][google.cloud.discoveryengine.v1beta.SearchRequest.user_info].
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.UserInfo user_info = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setUserInfo(
        com.google.cloud.discoveryengine.v1beta.UserInfo.Builder builderForValue) {
      if (userInfoBuilder_ == null) {
        userInfo_ = builderForValue.build();
      } else {
        userInfoBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Information about the end user.
     *
     * This should be the same identifier information as
     * [UserEvent.user_info][google.cloud.discoveryengine.v1beta.UserEvent.user_info]
     * and
     * [SearchRequest.user_info][google.cloud.discoveryengine.v1beta.SearchRequest.user_info].
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.UserInfo user_info = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeUserInfo(com.google.cloud.discoveryengine.v1beta.UserInfo value) {
      if (userInfoBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && userInfo_ != null
            && userInfo_ != com.google.cloud.discoveryengine.v1beta.UserInfo.getDefaultInstance()) {
          getUserInfoBuilder().mergeFrom(value);
        } else {
          userInfo_ = value;
        }
      } else {
        userInfoBuilder_.mergeFrom(value);
      }
      if (userInfo_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Information about the end user.
     *
     * This should be the same identifier information as
     * [UserEvent.user_info][google.cloud.discoveryengine.v1beta.UserEvent.user_info]
     * and
     * [SearchRequest.user_info][google.cloud.discoveryengine.v1beta.SearchRequest.user_info].
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.UserInfo user_info = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearUserInfo() {
      bitField0_ = (bitField0_ & ~0x00000010);
      userInfo_ = null;
      if (userInfoBuilder_ != null) {
        userInfoBuilder_.dispose();
        userInfoBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Information about the end user.
     *
     * This should be the same identifier information as
     * [UserEvent.user_info][google.cloud.discoveryengine.v1beta.UserEvent.user_info]
     * and
     * [SearchRequest.user_info][google.cloud.discoveryengine.v1beta.SearchRequest.user_info].
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.UserInfo user_info = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.discoveryengine.v1beta.UserInfo.Builder getUserInfoBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getUserInfoFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Information about the end user.
     *
     * This should be the same identifier information as
     * [UserEvent.user_info][google.cloud.discoveryengine.v1beta.UserEvent.user_info]
     * and
     * [SearchRequest.user_info][google.cloud.discoveryengine.v1beta.SearchRequest.user_info].
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.UserInfo user_info = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.discoveryengine.v1beta.UserInfoOrBuilder getUserInfoOrBuilder() {
      if (userInfoBuilder_ != null) {
        return userInfoBuilder_.getMessageOrBuilder();
      } else {
        return userInfo_ == null
            ? com.google.cloud.discoveryengine.v1beta.UserInfo.getDefaultInstance()
            : userInfo_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Information about the end user.
     *
     * This should be the same identifier information as
     * [UserEvent.user_info][google.cloud.discoveryengine.v1beta.UserEvent.user_info]
     * and
     * [SearchRequest.user_info][google.cloud.discoveryengine.v1beta.SearchRequest.user_info].
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.UserInfo user_info = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1beta.UserInfo,
            com.google.cloud.discoveryengine.v1beta.UserInfo.Builder,
            com.google.cloud.discoveryengine.v1beta.UserInfoOrBuilder>
        getUserInfoFieldBuilder() {
      if (userInfoBuilder_ == null) {
        userInfoBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1beta.UserInfo,
                com.google.cloud.discoveryengine.v1beta.UserInfo.Builder,
                com.google.cloud.discoveryengine.v1beta.UserInfoOrBuilder>(
                getUserInfo(), getParentForChildren(), isClean());
        userInfo_ = null;
      }
      return userInfoBuilder_;
    }

    private boolean includeTailSuggestions_;
    /**
     *
     *
     * <pre>
     * Indicates if tail suggestions should be returned if there are no
     * suggestions that match the full query. Even if set to true, if there are
     * suggestions that match the full query, those are returned and no
     * tail suggestions are returned.
     * </pre>
     *
     * <code>bool include_tail_suggestions = 5;</code>
     *
     * @return The includeTailSuggestions.
     */
    @java.lang.Override
    public boolean getIncludeTailSuggestions() {
      return includeTailSuggestions_;
    }
    /**
     *
     *
     * <pre>
     * Indicates if tail suggestions should be returned if there are no
     * suggestions that match the full query. Even if set to true, if there are
     * suggestions that match the full query, those are returned and no
     * tail suggestions are returned.
     * </pre>
     *
     * <code>bool include_tail_suggestions = 5;</code>
     *
     * @param value The includeTailSuggestions to set.
     * @return This builder for chaining.
     */
    public Builder setIncludeTailSuggestions(boolean value) {

      includeTailSuggestions_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indicates if tail suggestions should be returned if there are no
     * suggestions that match the full query. Even if set to true, if there are
     * suggestions that match the full query, those are returned and no
     * tail suggestions are returned.
     * </pre>
     *
     * <code>bool include_tail_suggestions = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIncludeTailSuggestions() {
      bitField0_ = (bitField0_ & ~0x00000020);
      includeTailSuggestions_ = false;
      onChanged();
      return this;
    }

    private com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec
        boostSpec_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec,
            com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec.Builder,
            com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpecOrBuilder>
        boostSpecBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Specification to boost suggestions matching the condition.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec boost_spec = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the boostSpec field is set.
     */
    public boolean hasBoostSpec() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Specification to boost suggestions matching the condition.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec boost_spec = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The boostSpec.
     */
    public com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec
        getBoostSpec() {
      if (boostSpecBuilder_ == null) {
        return boostSpec_ == null
            ? com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec
                .getDefaultInstance()
            : boostSpec_;
      } else {
        return boostSpecBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Specification to boost suggestions matching the condition.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec boost_spec = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setBoostSpec(
        com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec value) {
      if (boostSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        boostSpec_ = value;
      } else {
        boostSpecBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specification to boost suggestions matching the condition.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec boost_spec = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setBoostSpec(
        com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec.Builder
            builderForValue) {
      if (boostSpecBuilder_ == null) {
        boostSpec_ = builderForValue.build();
      } else {
        boostSpecBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specification to boost suggestions matching the condition.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec boost_spec = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeBoostSpec(
        com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec value) {
      if (boostSpecBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && boostSpec_ != null
            && boostSpec_
                != com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec
                    .getDefaultInstance()) {
          getBoostSpecBuilder().mergeFrom(value);
        } else {
          boostSpec_ = value;
        }
      } else {
        boostSpecBuilder_.mergeFrom(value);
      }
      if (boostSpec_ != null) {
        bitField0_ |= 0x00000040;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specification to boost suggestions matching the condition.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec boost_spec = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearBoostSpec() {
      bitField0_ = (bitField0_ & ~0x00000040);
      boostSpec_ = null;
      if (boostSpecBuilder_ != null) {
        boostSpecBuilder_.dispose();
        boostSpecBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specification to boost suggestions matching the condition.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec boost_spec = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec.Builder
        getBoostSpecBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getBoostSpecFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Specification to boost suggestions matching the condition.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec boost_spec = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpecOrBuilder
        getBoostSpecOrBuilder() {
      if (boostSpecBuilder_ != null) {
        return boostSpecBuilder_.getMessageOrBuilder();
      } else {
        return boostSpec_ == null
            ? com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec
                .getDefaultInstance()
            : boostSpec_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Specification to boost suggestions matching the condition.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec boost_spec = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec,
            com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec.Builder,
            com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpecOrBuilder>
        getBoostSpecFieldBuilder() {
      if (boostSpecBuilder_ == null) {
        boostSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec,
                com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec
                    .Builder,
                com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest
                    .BoostSpecOrBuilder>(getBoostSpec(), getParentForChildren(), isClean());
        boostSpec_ = null;
      }
      return boostSpecBuilder_;
    }

    private java.util.List<java.lang.Integer> suggestionTypes_ = java.util.Collections.emptyList();

    private void ensureSuggestionTypesIsMutable() {
      if (!((bitField0_ & 0x00000080) != 0)) {
        suggestionTypes_ = new java.util.ArrayList<java.lang.Integer>(suggestionTypes_);
        bitField0_ |= 0x00000080;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Suggestion types to return. If empty or unspecified, query
     * suggestions are returned. Only one suggestion type is supported at the
     * moment.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.SuggestionType suggestion_types = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return A list containing the suggestionTypes.
     */
    public java.util.List<
            com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.SuggestionType>
        getSuggestionTypesList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer,
          com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.SuggestionType>(
          suggestionTypes_, suggestionTypes_converter_);
    }
    /**
     *
     *
     * <pre>
     * Optional. Suggestion types to return. If empty or unspecified, query
     * suggestions are returned. Only one suggestion type is supported at the
     * moment.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.SuggestionType suggestion_types = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The count of suggestionTypes.
     */
    public int getSuggestionTypesCount() {
      return suggestionTypes_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. Suggestion types to return. If empty or unspecified, query
     * suggestions are returned. Only one suggestion type is supported at the
     * moment.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.SuggestionType suggestion_types = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index of the element to return.
     * @return The suggestionTypes at the given index.
     */
    public com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.SuggestionType
        getSuggestionTypes(int index) {
      return suggestionTypes_converter_.convert(suggestionTypes_.get(index));
    }
    /**
     *
     *
     * <pre>
     * Optional. Suggestion types to return. If empty or unspecified, query
     * suggestions are returned. Only one suggestion type is supported at the
     * moment.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.SuggestionType suggestion_types = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The suggestionTypes to set.
     * @return This builder for chaining.
     */
    public Builder setSuggestionTypes(
        int index,
        com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.SuggestionType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSuggestionTypesIsMutable();
      suggestionTypes_.set(index, value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Suggestion types to return. If empty or unspecified, query
     * suggestions are returned. Only one suggestion type is supported at the
     * moment.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.SuggestionType suggestion_types = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The suggestionTypes to add.
     * @return This builder for chaining.
     */
    public Builder addSuggestionTypes(
        com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.SuggestionType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSuggestionTypesIsMutable();
      suggestionTypes_.add(value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Suggestion types to return. If empty or unspecified, query
     * suggestions are returned. Only one suggestion type is supported at the
     * moment.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.SuggestionType suggestion_types = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param values The suggestionTypes to add.
     * @return This builder for chaining.
     */
    public Builder addAllSuggestionTypes(
        java.lang.Iterable<
                ? extends
                    com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest
                        .SuggestionType>
            values) {
      ensureSuggestionTypesIsMutable();
      for (com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.SuggestionType
          value : values) {
        suggestionTypes_.add(value.getNumber());
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Suggestion types to return. If empty or unspecified, query
     * suggestions are returned. Only one suggestion type is supported at the
     * moment.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.SuggestionType suggestion_types = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSuggestionTypes() {
      suggestionTypes_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Suggestion types to return. If empty or unspecified, query
     * suggestions are returned. Only one suggestion type is supported at the
     * moment.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.SuggestionType suggestion_types = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return A list containing the enum numeric values on the wire for suggestionTypes.
     */
    public java.util.List<java.lang.Integer> getSuggestionTypesValueList() {
      return java.util.Collections.unmodifiableList(suggestionTypes_);
    }
    /**
     *
     *
     * <pre>
     * Optional. Suggestion types to return. If empty or unspecified, query
     * suggestions are returned. Only one suggestion type is supported at the
     * moment.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.SuggestionType suggestion_types = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of suggestionTypes at the given index.
     */
    public int getSuggestionTypesValue(int index) {
      return suggestionTypes_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. Suggestion types to return. If empty or unspecified, query
     * suggestions are returned. Only one suggestion type is supported at the
     * moment.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.SuggestionType suggestion_types = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The enum numeric value on the wire for suggestionTypes to set.
     * @return This builder for chaining.
     */
    public Builder setSuggestionTypesValue(int index, int value) {
      ensureSuggestionTypesIsMutable();
      suggestionTypes_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Suggestion types to return. If empty or unspecified, query
     * suggestions are returned. Only one suggestion type is supported at the
     * moment.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.SuggestionType suggestion_types = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The enum numeric value on the wire for suggestionTypes to add.
     * @return This builder for chaining.
     */
    public Builder addSuggestionTypesValue(int value) {
      ensureSuggestionTypesIsMutable();
      suggestionTypes_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Suggestion types to return. If empty or unspecified, query
     * suggestions are returned. Only one suggestion type is supported at the
     * moment.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.SuggestionType suggestion_types = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param values The enum numeric values on the wire for suggestionTypes to add.
     * @return This builder for chaining.
     */
    public Builder addAllSuggestionTypesValue(java.lang.Iterable<java.lang.Integer> values) {
      ensureSuggestionTypesIsMutable();
      for (int value : values) {
        suggestionTypes_.add(value);
      }
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest)
  private static final com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest();
  }

  public static com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<AdvancedCompleteQueryRequest> PARSER =
      new com.google.protobuf.AbstractParser<AdvancedCompleteQueryRequest>() {
        @java.lang.Override
        public AdvancedCompleteQueryRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<AdvancedCompleteQueryRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<AdvancedCompleteQueryRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
