/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/discoveryengine/v1beta/completion_service.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.discoveryengine.v1beta;

/**
 *
 *
 * <pre>
 * Response message for
 * [CompletionService.AdvancedCompleteQuery][google.cloud.discoveryengine.v1beta.CompletionService.AdvancedCompleteQuery]
 * method.
 * </pre>
 *
 * Protobuf type {@code google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse}
 */
public final class AdvancedCompleteQueryResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse)
    AdvancedCompleteQueryResponseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use AdvancedCompleteQueryResponse.newBuilder() to construct.
  private AdvancedCompleteQueryResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private AdvancedCompleteQueryResponse() {
    querySuggestions_ = java.util.Collections.emptyList();
    peopleSuggestions_ = java.util.Collections.emptyList();
    contentSuggestions_ = java.util.Collections.emptyList();
    recentSearchSuggestions_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new AdvancedCompleteQueryResponse();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.discoveryengine.v1beta.CompletionServiceProto
        .internal_static_google_cloud_discoveryengine_v1beta_AdvancedCompleteQueryResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.discoveryengine.v1beta.CompletionServiceProto
        .internal_static_google_cloud_discoveryengine_v1beta_AdvancedCompleteQueryResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.class,
            com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.Builder.class);
  }

  public interface QuerySuggestionOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.QuerySuggestion)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The suggestion for the query.
     * </pre>
     *
     * <code>string suggestion = 1;</code>
     *
     * @return The suggestion.
     */
    java.lang.String getSuggestion();
    /**
     *
     *
     * <pre>
     * The suggestion for the query.
     * </pre>
     *
     * <code>string suggestion = 1;</code>
     *
     * @return The bytes for suggestion.
     */
    com.google.protobuf.ByteString getSuggestionBytes();

    /**
     *
     *
     * <pre>
     * The unique document field paths that serve as the source of this
     * suggestion if it was generated from completable fields.
     *
     * This field is only populated for the document-completable model.
     * </pre>
     *
     * <code>repeated string completable_field_paths = 2;</code>
     *
     * @return A list containing the completableFieldPaths.
     */
    java.util.List<java.lang.String> getCompletableFieldPathsList();
    /**
     *
     *
     * <pre>
     * The unique document field paths that serve as the source of this
     * suggestion if it was generated from completable fields.
     *
     * This field is only populated for the document-completable model.
     * </pre>
     *
     * <code>repeated string completable_field_paths = 2;</code>
     *
     * @return The count of completableFieldPaths.
     */
    int getCompletableFieldPathsCount();
    /**
     *
     *
     * <pre>
     * The unique document field paths that serve as the source of this
     * suggestion if it was generated from completable fields.
     *
     * This field is only populated for the document-completable model.
     * </pre>
     *
     * <code>repeated string completable_field_paths = 2;</code>
     *
     * @param index The index of the element to return.
     * @return The completableFieldPaths at the given index.
     */
    java.lang.String getCompletableFieldPaths(int index);
    /**
     *
     *
     * <pre>
     * The unique document field paths that serve as the source of this
     * suggestion if it was generated from completable fields.
     *
     * This field is only populated for the document-completable model.
     * </pre>
     *
     * <code>repeated string completable_field_paths = 2;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the completableFieldPaths at the given index.
     */
    com.google.protobuf.ByteString getCompletableFieldPathsBytes(int index);

    /**
     *
     *
     * <pre>
     * The name of the dataStore that this suggestion belongs to.
     * </pre>
     *
     * <code>repeated string data_store = 3;</code>
     *
     * @return A list containing the dataStore.
     */
    java.util.List<java.lang.String> getDataStoreList();
    /**
     *
     *
     * <pre>
     * The name of the dataStore that this suggestion belongs to.
     * </pre>
     *
     * <code>repeated string data_store = 3;</code>
     *
     * @return The count of dataStore.
     */
    int getDataStoreCount();
    /**
     *
     *
     * <pre>
     * The name of the dataStore that this suggestion belongs to.
     * </pre>
     *
     * <code>repeated string data_store = 3;</code>
     *
     * @param index The index of the element to return.
     * @return The dataStore at the given index.
     */
    java.lang.String getDataStore(int index);
    /**
     *
     *
     * <pre>
     * The name of the dataStore that this suggestion belongs to.
     * </pre>
     *
     * <code>repeated string data_store = 3;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the dataStore at the given index.
     */
    com.google.protobuf.ByteString getDataStoreBytes(int index);
  }
  /**
   *
   *
   * <pre>
   * Suggestions as search queries.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.QuerySuggestion}
   */
  public static final class QuerySuggestion extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.QuerySuggestion)
      QuerySuggestionOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use QuerySuggestion.newBuilder() to construct.
    private QuerySuggestion(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private QuerySuggestion() {
      suggestion_ = "";
      completableFieldPaths_ = com.google.protobuf.LazyStringArrayList.emptyList();
      dataStore_ = com.google.protobuf.LazyStringArrayList.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new QuerySuggestion();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1beta.CompletionServiceProto
          .internal_static_google_cloud_discoveryengine_v1beta_AdvancedCompleteQueryResponse_QuerySuggestion_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1beta.CompletionServiceProto
          .internal_static_google_cloud_discoveryengine_v1beta_AdvancedCompleteQueryResponse_QuerySuggestion_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.QuerySuggestion
                  .class,
              com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.QuerySuggestion
                  .Builder.class);
    }

    public static final int SUGGESTION_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object suggestion_ = "";
    /**
     *
     *
     * <pre>
     * The suggestion for the query.
     * </pre>
     *
     * <code>string suggestion = 1;</code>
     *
     * @return The suggestion.
     */
    @java.lang.Override
    public java.lang.String getSuggestion() {
      java.lang.Object ref = suggestion_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        suggestion_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The suggestion for the query.
     * </pre>
     *
     * <code>string suggestion = 1;</code>
     *
     * @return The bytes for suggestion.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getSuggestionBytes() {
      java.lang.Object ref = suggestion_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        suggestion_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int COMPLETABLE_FIELD_PATHS_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList completableFieldPaths_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    /**
     *
     *
     * <pre>
     * The unique document field paths that serve as the source of this
     * suggestion if it was generated from completable fields.
     *
     * This field is only populated for the document-completable model.
     * </pre>
     *
     * <code>repeated string completable_field_paths = 2;</code>
     *
     * @return A list containing the completableFieldPaths.
     */
    public com.google.protobuf.ProtocolStringList getCompletableFieldPathsList() {
      return completableFieldPaths_;
    }
    /**
     *
     *
     * <pre>
     * The unique document field paths that serve as the source of this
     * suggestion if it was generated from completable fields.
     *
     * This field is only populated for the document-completable model.
     * </pre>
     *
     * <code>repeated string completable_field_paths = 2;</code>
     *
     * @return The count of completableFieldPaths.
     */
    public int getCompletableFieldPathsCount() {
      return completableFieldPaths_.size();
    }
    /**
     *
     *
     * <pre>
     * The unique document field paths that serve as the source of this
     * suggestion if it was generated from completable fields.
     *
     * This field is only populated for the document-completable model.
     * </pre>
     *
     * <code>repeated string completable_field_paths = 2;</code>
     *
     * @param index The index of the element to return.
     * @return The completableFieldPaths at the given index.
     */
    public java.lang.String getCompletableFieldPaths(int index) {
      return completableFieldPaths_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The unique document field paths that serve as the source of this
     * suggestion if it was generated from completable fields.
     *
     * This field is only populated for the document-completable model.
     * </pre>
     *
     * <code>repeated string completable_field_paths = 2;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the completableFieldPaths at the given index.
     */
    public com.google.protobuf.ByteString getCompletableFieldPathsBytes(int index) {
      return completableFieldPaths_.getByteString(index);
    }

    public static final int DATA_STORE_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList dataStore_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    /**
     *
     *
     * <pre>
     * The name of the dataStore that this suggestion belongs to.
     * </pre>
     *
     * <code>repeated string data_store = 3;</code>
     *
     * @return A list containing the dataStore.
     */
    public com.google.protobuf.ProtocolStringList getDataStoreList() {
      return dataStore_;
    }
    /**
     *
     *
     * <pre>
     * The name of the dataStore that this suggestion belongs to.
     * </pre>
     *
     * <code>repeated string data_store = 3;</code>
     *
     * @return The count of dataStore.
     */
    public int getDataStoreCount() {
      return dataStore_.size();
    }
    /**
     *
     *
     * <pre>
     * The name of the dataStore that this suggestion belongs to.
     * </pre>
     *
     * <code>repeated string data_store = 3;</code>
     *
     * @param index The index of the element to return.
     * @return The dataStore at the given index.
     */
    public java.lang.String getDataStore(int index) {
      return dataStore_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The name of the dataStore that this suggestion belongs to.
     * </pre>
     *
     * <code>repeated string data_store = 3;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the dataStore at the given index.
     */
    public com.google.protobuf.ByteString getDataStoreBytes(int index) {
      return dataStore_.getByteString(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(suggestion_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, suggestion_);
      }
      for (int i = 0; i < completableFieldPaths_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(
            output, 2, completableFieldPaths_.getRaw(i));
      }
      for (int i = 0; i < dataStore_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, dataStore_.getRaw(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(suggestion_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, suggestion_);
      }
      {
        int dataSize = 0;
        for (int i = 0; i < completableFieldPaths_.size(); i++) {
          dataSize += computeStringSizeNoTag(completableFieldPaths_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getCompletableFieldPathsList().size();
      }
      {
        int dataSize = 0;
        for (int i = 0; i < dataStore_.size(); i++) {
          dataSize += computeStringSizeNoTag(dataStore_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getDataStoreList().size();
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.QuerySuggestion)) {
        return super.equals(obj);
      }
      com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.QuerySuggestion other =
          (com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.QuerySuggestion)
              obj;

      if (!getSuggestion().equals(other.getSuggestion())) return false;
      if (!getCompletableFieldPathsList().equals(other.getCompletableFieldPathsList()))
        return false;
      if (!getDataStoreList().equals(other.getDataStoreList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + SUGGESTION_FIELD_NUMBER;
      hash = (53 * hash) + getSuggestion().hashCode();
      if (getCompletableFieldPathsCount() > 0) {
        hash = (37 * hash) + COMPLETABLE_FIELD_PATHS_FIELD_NUMBER;
        hash = (53 * hash) + getCompletableFieldPathsList().hashCode();
      }
      if (getDataStoreCount() > 0) {
        hash = (37 * hash) + DATA_STORE_FIELD_NUMBER;
        hash = (53 * hash) + getDataStoreList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
            .QuerySuggestion
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
            .QuerySuggestion
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
            .QuerySuggestion
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
            .QuerySuggestion
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
            .QuerySuggestion
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
            .QuerySuggestion
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
            .QuerySuggestion
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
            .QuerySuggestion
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
            .QuerySuggestion
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
            .QuerySuggestion
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
            .QuerySuggestion
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
            .QuerySuggestion
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.QuerySuggestion
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Suggestions as search queries.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.QuerySuggestion}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.QuerySuggestion)
        com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
            .QuerySuggestionOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1beta.CompletionServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_AdvancedCompleteQueryResponse_QuerySuggestion_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1beta.CompletionServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_AdvancedCompleteQueryResponse_QuerySuggestion_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
                    .QuerySuggestion.class,
                com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
                    .QuerySuggestion.Builder.class);
      }

      // Construct using
      // com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.QuerySuggestion.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        suggestion_ = "";
        completableFieldPaths_ = com.google.protobuf.LazyStringArrayList.emptyList();
        dataStore_ = com.google.protobuf.LazyStringArrayList.emptyList();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.discoveryengine.v1beta.CompletionServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_AdvancedCompleteQueryResponse_QuerySuggestion_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.QuerySuggestion
          getDefaultInstanceForType() {
        return com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.QuerySuggestion
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.QuerySuggestion
          build() {
        com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.QuerySuggestion
            result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.QuerySuggestion
          buildPartial() {
        com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.QuerySuggestion
            result =
                new com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
                    .QuerySuggestion(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.QuerySuggestion
              result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.suggestion_ = suggestion_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          completableFieldPaths_.makeImmutable();
          result.completableFieldPaths_ = completableFieldPaths_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          dataStore_.makeImmutable();
          result.dataStore_ = dataStore_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.QuerySuggestion) {
          return mergeFrom(
              (com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
                      .QuerySuggestion)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.QuerySuggestion
              other) {
        if (other
            == com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.QuerySuggestion
                .getDefaultInstance()) return this;
        if (!other.getSuggestion().isEmpty()) {
          suggestion_ = other.suggestion_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.completableFieldPaths_.isEmpty()) {
          if (completableFieldPaths_.isEmpty()) {
            completableFieldPaths_ = other.completableFieldPaths_;
            bitField0_ |= 0x00000002;
          } else {
            ensureCompletableFieldPathsIsMutable();
            completableFieldPaths_.addAll(other.completableFieldPaths_);
          }
          onChanged();
        }
        if (!other.dataStore_.isEmpty()) {
          if (dataStore_.isEmpty()) {
            dataStore_ = other.dataStore_;
            bitField0_ |= 0x00000004;
          } else {
            ensureDataStoreIsMutable();
            dataStore_.addAll(other.dataStore_);
          }
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  suggestion_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureCompletableFieldPathsIsMutable();
                  completableFieldPaths_.add(s);
                  break;
                } // case 18
              case 26:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureDataStoreIsMutable();
                  dataStore_.add(s);
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object suggestion_ = "";
      /**
       *
       *
       * <pre>
       * The suggestion for the query.
       * </pre>
       *
       * <code>string suggestion = 1;</code>
       *
       * @return The suggestion.
       */
      public java.lang.String getSuggestion() {
        java.lang.Object ref = suggestion_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          suggestion_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The suggestion for the query.
       * </pre>
       *
       * <code>string suggestion = 1;</code>
       *
       * @return The bytes for suggestion.
       */
      public com.google.protobuf.ByteString getSuggestionBytes() {
        java.lang.Object ref = suggestion_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          suggestion_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The suggestion for the query.
       * </pre>
       *
       * <code>string suggestion = 1;</code>
       *
       * @param value The suggestion to set.
       * @return This builder for chaining.
       */
      public Builder setSuggestion(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        suggestion_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The suggestion for the query.
       * </pre>
       *
       * <code>string suggestion = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearSuggestion() {
        suggestion_ = getDefaultInstance().getSuggestion();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The suggestion for the query.
       * </pre>
       *
       * <code>string suggestion = 1;</code>
       *
       * @param value The bytes for suggestion to set.
       * @return This builder for chaining.
       */
      public Builder setSuggestionBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        suggestion_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringArrayList completableFieldPaths_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureCompletableFieldPathsIsMutable() {
        if (!completableFieldPaths_.isModifiable()) {
          completableFieldPaths_ =
              new com.google.protobuf.LazyStringArrayList(completableFieldPaths_);
        }
        bitField0_ |= 0x00000002;
      }
      /**
       *
       *
       * <pre>
       * The unique document field paths that serve as the source of this
       * suggestion if it was generated from completable fields.
       *
       * This field is only populated for the document-completable model.
       * </pre>
       *
       * <code>repeated string completable_field_paths = 2;</code>
       *
       * @return A list containing the completableFieldPaths.
       */
      public com.google.protobuf.ProtocolStringList getCompletableFieldPathsList() {
        completableFieldPaths_.makeImmutable();
        return completableFieldPaths_;
      }
      /**
       *
       *
       * <pre>
       * The unique document field paths that serve as the source of this
       * suggestion if it was generated from completable fields.
       *
       * This field is only populated for the document-completable model.
       * </pre>
       *
       * <code>repeated string completable_field_paths = 2;</code>
       *
       * @return The count of completableFieldPaths.
       */
      public int getCompletableFieldPathsCount() {
        return completableFieldPaths_.size();
      }
      /**
       *
       *
       * <pre>
       * The unique document field paths that serve as the source of this
       * suggestion if it was generated from completable fields.
       *
       * This field is only populated for the document-completable model.
       * </pre>
       *
       * <code>repeated string completable_field_paths = 2;</code>
       *
       * @param index The index of the element to return.
       * @return The completableFieldPaths at the given index.
       */
      public java.lang.String getCompletableFieldPaths(int index) {
        return completableFieldPaths_.get(index);
      }
      /**
       *
       *
       * <pre>
       * The unique document field paths that serve as the source of this
       * suggestion if it was generated from completable fields.
       *
       * This field is only populated for the document-completable model.
       * </pre>
       *
       * <code>repeated string completable_field_paths = 2;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the completableFieldPaths at the given index.
       */
      public com.google.protobuf.ByteString getCompletableFieldPathsBytes(int index) {
        return completableFieldPaths_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * The unique document field paths that serve as the source of this
       * suggestion if it was generated from completable fields.
       *
       * This field is only populated for the document-completable model.
       * </pre>
       *
       * <code>repeated string completable_field_paths = 2;</code>
       *
       * @param index The index to set the value at.
       * @param value The completableFieldPaths to set.
       * @return This builder for chaining.
       */
      public Builder setCompletableFieldPaths(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCompletableFieldPathsIsMutable();
        completableFieldPaths_.set(index, value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The unique document field paths that serve as the source of this
       * suggestion if it was generated from completable fields.
       *
       * This field is only populated for the document-completable model.
       * </pre>
       *
       * <code>repeated string completable_field_paths = 2;</code>
       *
       * @param value The completableFieldPaths to add.
       * @return This builder for chaining.
       */
      public Builder addCompletableFieldPaths(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCompletableFieldPathsIsMutable();
        completableFieldPaths_.add(value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The unique document field paths that serve as the source of this
       * suggestion if it was generated from completable fields.
       *
       * This field is only populated for the document-completable model.
       * </pre>
       *
       * <code>repeated string completable_field_paths = 2;</code>
       *
       * @param values The completableFieldPaths to add.
       * @return This builder for chaining.
       */
      public Builder addAllCompletableFieldPaths(java.lang.Iterable<java.lang.String> values) {
        ensureCompletableFieldPathsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, completableFieldPaths_);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The unique document field paths that serve as the source of this
       * suggestion if it was generated from completable fields.
       *
       * This field is only populated for the document-completable model.
       * </pre>
       *
       * <code>repeated string completable_field_paths = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearCompletableFieldPaths() {
        completableFieldPaths_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        ;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The unique document field paths that serve as the source of this
       * suggestion if it was generated from completable fields.
       *
       * This field is only populated for the document-completable model.
       * </pre>
       *
       * <code>repeated string completable_field_paths = 2;</code>
       *
       * @param value The bytes of the completableFieldPaths to add.
       * @return This builder for chaining.
       */
      public Builder addCompletableFieldPathsBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureCompletableFieldPathsIsMutable();
        completableFieldPaths_.add(value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringArrayList dataStore_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureDataStoreIsMutable() {
        if (!dataStore_.isModifiable()) {
          dataStore_ = new com.google.protobuf.LazyStringArrayList(dataStore_);
        }
        bitField0_ |= 0x00000004;
      }
      /**
       *
       *
       * <pre>
       * The name of the dataStore that this suggestion belongs to.
       * </pre>
       *
       * <code>repeated string data_store = 3;</code>
       *
       * @return A list containing the dataStore.
       */
      public com.google.protobuf.ProtocolStringList getDataStoreList() {
        dataStore_.makeImmutable();
        return dataStore_;
      }
      /**
       *
       *
       * <pre>
       * The name of the dataStore that this suggestion belongs to.
       * </pre>
       *
       * <code>repeated string data_store = 3;</code>
       *
       * @return The count of dataStore.
       */
      public int getDataStoreCount() {
        return dataStore_.size();
      }
      /**
       *
       *
       * <pre>
       * The name of the dataStore that this suggestion belongs to.
       * </pre>
       *
       * <code>repeated string data_store = 3;</code>
       *
       * @param index The index of the element to return.
       * @return The dataStore at the given index.
       */
      public java.lang.String getDataStore(int index) {
        return dataStore_.get(index);
      }
      /**
       *
       *
       * <pre>
       * The name of the dataStore that this suggestion belongs to.
       * </pre>
       *
       * <code>repeated string data_store = 3;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the dataStore at the given index.
       */
      public com.google.protobuf.ByteString getDataStoreBytes(int index) {
        return dataStore_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * The name of the dataStore that this suggestion belongs to.
       * </pre>
       *
       * <code>repeated string data_store = 3;</code>
       *
       * @param index The index to set the value at.
       * @param value The dataStore to set.
       * @return This builder for chaining.
       */
      public Builder setDataStore(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDataStoreIsMutable();
        dataStore_.set(index, value);
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The name of the dataStore that this suggestion belongs to.
       * </pre>
       *
       * <code>repeated string data_store = 3;</code>
       *
       * @param value The dataStore to add.
       * @return This builder for chaining.
       */
      public Builder addDataStore(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDataStoreIsMutable();
        dataStore_.add(value);
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The name of the dataStore that this suggestion belongs to.
       * </pre>
       *
       * <code>repeated string data_store = 3;</code>
       *
       * @param values The dataStore to add.
       * @return This builder for chaining.
       */
      public Builder addAllDataStore(java.lang.Iterable<java.lang.String> values) {
        ensureDataStoreIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, dataStore_);
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The name of the dataStore that this suggestion belongs to.
       * </pre>
       *
       * <code>repeated string data_store = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDataStore() {
        dataStore_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        ;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The name of the dataStore that this suggestion belongs to.
       * </pre>
       *
       * <code>repeated string data_store = 3;</code>
       *
       * @param value The bytes of the dataStore to add.
       * @return This builder for chaining.
       */
      public Builder addDataStoreBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureDataStoreIsMutable();
        dataStore_.add(value);
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.QuerySuggestion)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.QuerySuggestion)
    private static final com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
            .QuerySuggestion
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
              .QuerySuggestion();
    }

    public static com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
            .QuerySuggestion
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<QuerySuggestion> PARSER =
        new com.google.protobuf.AbstractParser<QuerySuggestion>() {
          @java.lang.Override
          public QuerySuggestion parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<QuerySuggestion> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<QuerySuggestion> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.QuerySuggestion
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface PersonSuggestionOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.PersonSuggestion)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The suggestion for the query.
     * </pre>
     *
     * <code>string suggestion = 1;</code>
     *
     * @return The suggestion.
     */
    java.lang.String getSuggestion();
    /**
     *
     *
     * <pre>
     * The suggestion for the query.
     * </pre>
     *
     * <code>string suggestion = 1;</code>
     *
     * @return The bytes for suggestion.
     */
    com.google.protobuf.ByteString getSuggestionBytes();

    /**
     *
     *
     * <pre>
     * The type of the person.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.PersonSuggestion.PersonType person_type = 2;
     * </code>
     *
     * @return The enum numeric value on the wire for personType.
     */
    int getPersonTypeValue();
    /**
     *
     *
     * <pre>
     * The type of the person.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.PersonSuggestion.PersonType person_type = 2;
     * </code>
     *
     * @return The personType.
     */
    com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.PersonSuggestion
            .PersonType
        getPersonType();

    /**
     *
     *
     * <pre>
     * The document data snippet in the suggestion. Only a subset of fields is
     * populated.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.Document document = 4;</code>
     *
     * @return Whether the document field is set.
     */
    boolean hasDocument();
    /**
     *
     *
     * <pre>
     * The document data snippet in the suggestion. Only a subset of fields is
     * populated.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.Document document = 4;</code>
     *
     * @return The document.
     */
    com.google.cloud.discoveryengine.v1beta.Document getDocument();
    /**
     *
     *
     * <pre>
     * The document data snippet in the suggestion. Only a subset of fields is
     * populated.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.Document document = 4;</code>
     */
    com.google.cloud.discoveryengine.v1beta.DocumentOrBuilder getDocumentOrBuilder();

    /**
     *
     *
     * <pre>
     * The name of the dataStore that this suggestion belongs to.
     * </pre>
     *
     * <code>string data_store = 5 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The dataStore.
     */
    java.lang.String getDataStore();
    /**
     *
     *
     * <pre>
     * The name of the dataStore that this suggestion belongs to.
     * </pre>
     *
     * <code>string data_store = 5 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for dataStore.
     */
    com.google.protobuf.ByteString getDataStoreBytes();
  }
  /**
   *
   *
   * <pre>
   * Suggestions as people.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.PersonSuggestion}
   */
  public static final class PersonSuggestion extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.PersonSuggestion)
      PersonSuggestionOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use PersonSuggestion.newBuilder() to construct.
    private PersonSuggestion(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private PersonSuggestion() {
      suggestion_ = "";
      personType_ = 0;
      dataStore_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new PersonSuggestion();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1beta.CompletionServiceProto
          .internal_static_google_cloud_discoveryengine_v1beta_AdvancedCompleteQueryResponse_PersonSuggestion_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1beta.CompletionServiceProto
          .internal_static_google_cloud_discoveryengine_v1beta_AdvancedCompleteQueryResponse_PersonSuggestion_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.PersonSuggestion
                  .class,
              com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.PersonSuggestion
                  .Builder.class);
    }

    /**
     *
     *
     * <pre>
     * The type of the person based on the source.
     * </pre>
     *
     * Protobuf enum {@code
     * google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.PersonSuggestion.PersonType}
     */
    public enum PersonType implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Default value.
       * </pre>
       *
       * <code>PERSON_TYPE_UNSPECIFIED = 0;</code>
       */
      PERSON_TYPE_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * The suggestion is from a GOOGLE_IDENTITY source.
       * </pre>
       *
       * <code>CLOUD_IDENTITY = 1;</code>
       */
      CLOUD_IDENTITY(1),
      /**
       *
       *
       * <pre>
       * The suggestion is from a THIRD_PARTY_IDENTITY source.
       * </pre>
       *
       * <code>THIRD_PARTY_IDENTITY = 2;</code>
       */
      THIRD_PARTY_IDENTITY(2),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Default value.
       * </pre>
       *
       * <code>PERSON_TYPE_UNSPECIFIED = 0;</code>
       */
      public static final int PERSON_TYPE_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * The suggestion is from a GOOGLE_IDENTITY source.
       * </pre>
       *
       * <code>CLOUD_IDENTITY = 1;</code>
       */
      public static final int CLOUD_IDENTITY_VALUE = 1;
      /**
       *
       *
       * <pre>
       * The suggestion is from a THIRD_PARTY_IDENTITY source.
       * </pre>
       *
       * <code>THIRD_PARTY_IDENTITY = 2;</code>
       */
      public static final int THIRD_PARTY_IDENTITY_VALUE = 2;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static PersonType valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static PersonType forNumber(int value) {
        switch (value) {
          case 0:
            return PERSON_TYPE_UNSPECIFIED;
          case 1:
            return CLOUD_IDENTITY;
          case 2:
            return THIRD_PARTY_IDENTITY;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<PersonType> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<PersonType> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<PersonType>() {
            public PersonType findValueByNumber(int number) {
              return PersonType.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
            .PersonSuggestion.getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final PersonType[] VALUES = values();

      public static PersonType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private PersonType(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.PersonSuggestion.PersonType)
    }

    private int bitField0_;
    public static final int SUGGESTION_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object suggestion_ = "";
    /**
     *
     *
     * <pre>
     * The suggestion for the query.
     * </pre>
     *
     * <code>string suggestion = 1;</code>
     *
     * @return The suggestion.
     */
    @java.lang.Override
    public java.lang.String getSuggestion() {
      java.lang.Object ref = suggestion_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        suggestion_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The suggestion for the query.
     * </pre>
     *
     * <code>string suggestion = 1;</code>
     *
     * @return The bytes for suggestion.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getSuggestionBytes() {
      java.lang.Object ref = suggestion_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        suggestion_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int PERSON_TYPE_FIELD_NUMBER = 2;
    private int personType_ = 0;
    /**
     *
     *
     * <pre>
     * The type of the person.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.PersonSuggestion.PersonType person_type = 2;
     * </code>
     *
     * @return The enum numeric value on the wire for personType.
     */
    @java.lang.Override
    public int getPersonTypeValue() {
      return personType_;
    }
    /**
     *
     *
     * <pre>
     * The type of the person.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.PersonSuggestion.PersonType person_type = 2;
     * </code>
     *
     * @return The personType.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.PersonSuggestion
            .PersonType
        getPersonType() {
      com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.PersonSuggestion
              .PersonType
          result =
              com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.PersonSuggestion
                  .PersonType.forNumber(personType_);
      return result == null
          ? com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.PersonSuggestion
              .PersonType.UNRECOGNIZED
          : result;
    }

    public static final int DOCUMENT_FIELD_NUMBER = 4;
    private com.google.cloud.discoveryengine.v1beta.Document document_;
    /**
     *
     *
     * <pre>
     * The document data snippet in the suggestion. Only a subset of fields is
     * populated.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.Document document = 4;</code>
     *
     * @return Whether the document field is set.
     */
    @java.lang.Override
    public boolean hasDocument() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * The document data snippet in the suggestion. Only a subset of fields is
     * populated.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.Document document = 4;</code>
     *
     * @return The document.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.Document getDocument() {
      return document_ == null
          ? com.google.cloud.discoveryengine.v1beta.Document.getDefaultInstance()
          : document_;
    }
    /**
     *
     *
     * <pre>
     * The document data snippet in the suggestion. Only a subset of fields is
     * populated.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.Document document = 4;</code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.DocumentOrBuilder getDocumentOrBuilder() {
      return document_ == null
          ? com.google.cloud.discoveryengine.v1beta.Document.getDefaultInstance()
          : document_;
    }

    public static final int DATA_STORE_FIELD_NUMBER = 5;

    @SuppressWarnings("serial")
    private volatile java.lang.Object dataStore_ = "";
    /**
     *
     *
     * <pre>
     * The name of the dataStore that this suggestion belongs to.
     * </pre>
     *
     * <code>string data_store = 5 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The dataStore.
     */
    @java.lang.Override
    public java.lang.String getDataStore() {
      java.lang.Object ref = dataStore_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        dataStore_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the dataStore that this suggestion belongs to.
     * </pre>
     *
     * <code>string data_store = 5 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for dataStore.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getDataStoreBytes() {
      java.lang.Object ref = dataStore_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        dataStore_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(suggestion_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, suggestion_);
      }
      if (personType_
          != com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.PersonSuggestion
              .PersonType.PERSON_TYPE_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(2, personType_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(4, getDocument());
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dataStore_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 5, dataStore_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(suggestion_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, suggestion_);
      }
      if (personType_
          != com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.PersonSuggestion
              .PersonType.PERSON_TYPE_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, personType_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getDocument());
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dataStore_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, dataStore_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.PersonSuggestion)) {
        return super.equals(obj);
      }
      com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.PersonSuggestion other =
          (com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.PersonSuggestion)
              obj;

      if (!getSuggestion().equals(other.getSuggestion())) return false;
      if (personType_ != other.personType_) return false;
      if (hasDocument() != other.hasDocument()) return false;
      if (hasDocument()) {
        if (!getDocument().equals(other.getDocument())) return false;
      }
      if (!getDataStore().equals(other.getDataStore())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + SUGGESTION_FIELD_NUMBER;
      hash = (53 * hash) + getSuggestion().hashCode();
      hash = (37 * hash) + PERSON_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + personType_;
      if (hasDocument()) {
        hash = (37 * hash) + DOCUMENT_FIELD_NUMBER;
        hash = (53 * hash) + getDocument().hashCode();
      }
      hash = (37 * hash) + DATA_STORE_FIELD_NUMBER;
      hash = (53 * hash) + getDataStore().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
            .PersonSuggestion
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
            .PersonSuggestion
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
            .PersonSuggestion
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
            .PersonSuggestion
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
            .PersonSuggestion
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
            .PersonSuggestion
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
            .PersonSuggestion
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
            .PersonSuggestion
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
            .PersonSuggestion
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
            .PersonSuggestion
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
            .PersonSuggestion
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
            .PersonSuggestion
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.PersonSuggestion
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Suggestions as people.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.PersonSuggestion}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.PersonSuggestion)
        com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
            .PersonSuggestionOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1beta.CompletionServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_AdvancedCompleteQueryResponse_PersonSuggestion_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1beta.CompletionServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_AdvancedCompleteQueryResponse_PersonSuggestion_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
                    .PersonSuggestion.class,
                com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
                    .PersonSuggestion.Builder.class);
      }

      // Construct using
      // com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.PersonSuggestion.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getDocumentFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        suggestion_ = "";
        personType_ = 0;
        document_ = null;
        if (documentBuilder_ != null) {
          documentBuilder_.dispose();
          documentBuilder_ = null;
        }
        dataStore_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.discoveryengine.v1beta.CompletionServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_AdvancedCompleteQueryResponse_PersonSuggestion_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.PersonSuggestion
          getDefaultInstanceForType() {
        return com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
            .PersonSuggestion.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.PersonSuggestion
          build() {
        com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.PersonSuggestion
            result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.PersonSuggestion
          buildPartial() {
        com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.PersonSuggestion
            result =
                new com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
                    .PersonSuggestion(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.PersonSuggestion
              result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.suggestion_ = suggestion_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.personType_ = personType_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.document_ = documentBuilder_ == null ? document_ : documentBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.dataStore_ = dataStore_;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
                .PersonSuggestion) {
          return mergeFrom(
              (com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
                      .PersonSuggestion)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.PersonSuggestion
              other) {
        if (other
            == com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
                .PersonSuggestion.getDefaultInstance()) return this;
        if (!other.getSuggestion().isEmpty()) {
          suggestion_ = other.suggestion_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (other.personType_ != 0) {
          setPersonTypeValue(other.getPersonTypeValue());
        }
        if (other.hasDocument()) {
          mergeDocument(other.getDocument());
        }
        if (!other.getDataStore().isEmpty()) {
          dataStore_ = other.dataStore_;
          bitField0_ |= 0x00000008;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  suggestion_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 16:
                {
                  personType_ = input.readEnum();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              case 34:
                {
                  input.readMessage(getDocumentFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000004;
                  break;
                } // case 34
              case 42:
                {
                  dataStore_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 42
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object suggestion_ = "";
      /**
       *
       *
       * <pre>
       * The suggestion for the query.
       * </pre>
       *
       * <code>string suggestion = 1;</code>
       *
       * @return The suggestion.
       */
      public java.lang.String getSuggestion() {
        java.lang.Object ref = suggestion_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          suggestion_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The suggestion for the query.
       * </pre>
       *
       * <code>string suggestion = 1;</code>
       *
       * @return The bytes for suggestion.
       */
      public com.google.protobuf.ByteString getSuggestionBytes() {
        java.lang.Object ref = suggestion_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          suggestion_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The suggestion for the query.
       * </pre>
       *
       * <code>string suggestion = 1;</code>
       *
       * @param value The suggestion to set.
       * @return This builder for chaining.
       */
      public Builder setSuggestion(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        suggestion_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The suggestion for the query.
       * </pre>
       *
       * <code>string suggestion = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearSuggestion() {
        suggestion_ = getDefaultInstance().getSuggestion();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The suggestion for the query.
       * </pre>
       *
       * <code>string suggestion = 1;</code>
       *
       * @param value The bytes for suggestion to set.
       * @return This builder for chaining.
       */
      public Builder setSuggestionBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        suggestion_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private int personType_ = 0;
      /**
       *
       *
       * <pre>
       * The type of the person.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.PersonSuggestion.PersonType person_type = 2;
       * </code>
       *
       * @return The enum numeric value on the wire for personType.
       */
      @java.lang.Override
      public int getPersonTypeValue() {
        return personType_;
      }
      /**
       *
       *
       * <pre>
       * The type of the person.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.PersonSuggestion.PersonType person_type = 2;
       * </code>
       *
       * @param value The enum numeric value on the wire for personType to set.
       * @return This builder for chaining.
       */
      public Builder setPersonTypeValue(int value) {
        personType_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The type of the person.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.PersonSuggestion.PersonType person_type = 2;
       * </code>
       *
       * @return The personType.
       */
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.PersonSuggestion
              .PersonType
          getPersonType() {
        com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.PersonSuggestion
                .PersonType
            result =
                com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
                    .PersonSuggestion.PersonType.forNumber(personType_);
        return result == null
            ? com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.PersonSuggestion
                .PersonType.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * The type of the person.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.PersonSuggestion.PersonType person_type = 2;
       * </code>
       *
       * @param value The personType to set.
       * @return This builder for chaining.
       */
      public Builder setPersonType(
          com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.PersonSuggestion
                  .PersonType
              value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000002;
        personType_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The type of the person.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.PersonSuggestion.PersonType person_type = 2;
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPersonType() {
        bitField0_ = (bitField0_ & ~0x00000002);
        personType_ = 0;
        onChanged();
        return this;
      }

      private com.google.cloud.discoveryengine.v1beta.Document document_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.discoveryengine.v1beta.Document,
              com.google.cloud.discoveryengine.v1beta.Document.Builder,
              com.google.cloud.discoveryengine.v1beta.DocumentOrBuilder>
          documentBuilder_;
      /**
       *
       *
       * <pre>
       * The document data snippet in the suggestion. Only a subset of fields is
       * populated.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1beta.Document document = 4;</code>
       *
       * @return Whether the document field is set.
       */
      public boolean hasDocument() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       *
       *
       * <pre>
       * The document data snippet in the suggestion. Only a subset of fields is
       * populated.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1beta.Document document = 4;</code>
       *
       * @return The document.
       */
      public com.google.cloud.discoveryengine.v1beta.Document getDocument() {
        if (documentBuilder_ == null) {
          return document_ == null
              ? com.google.cloud.discoveryengine.v1beta.Document.getDefaultInstance()
              : document_;
        } else {
          return documentBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The document data snippet in the suggestion. Only a subset of fields is
       * populated.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1beta.Document document = 4;</code>
       */
      public Builder setDocument(com.google.cloud.discoveryengine.v1beta.Document value) {
        if (documentBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          document_ = value;
        } else {
          documentBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The document data snippet in the suggestion. Only a subset of fields is
       * populated.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1beta.Document document = 4;</code>
       */
      public Builder setDocument(
          com.google.cloud.discoveryengine.v1beta.Document.Builder builderForValue) {
        if (documentBuilder_ == null) {
          document_ = builderForValue.build();
        } else {
          documentBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The document data snippet in the suggestion. Only a subset of fields is
       * populated.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1beta.Document document = 4;</code>
       */
      public Builder mergeDocument(com.google.cloud.discoveryengine.v1beta.Document value) {
        if (documentBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)
              && document_ != null
              && document_
                  != com.google.cloud.discoveryengine.v1beta.Document.getDefaultInstance()) {
            getDocumentBuilder().mergeFrom(value);
          } else {
            document_ = value;
          }
        } else {
          documentBuilder_.mergeFrom(value);
        }
        if (document_ != null) {
          bitField0_ |= 0x00000004;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The document data snippet in the suggestion. Only a subset of fields is
       * populated.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1beta.Document document = 4;</code>
       */
      public Builder clearDocument() {
        bitField0_ = (bitField0_ & ~0x00000004);
        document_ = null;
        if (documentBuilder_ != null) {
          documentBuilder_.dispose();
          documentBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The document data snippet in the suggestion. Only a subset of fields is
       * populated.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1beta.Document document = 4;</code>
       */
      public com.google.cloud.discoveryengine.v1beta.Document.Builder getDocumentBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getDocumentFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The document data snippet in the suggestion. Only a subset of fields is
       * populated.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1beta.Document document = 4;</code>
       */
      public com.google.cloud.discoveryengine.v1beta.DocumentOrBuilder getDocumentOrBuilder() {
        if (documentBuilder_ != null) {
          return documentBuilder_.getMessageOrBuilder();
        } else {
          return document_ == null
              ? com.google.cloud.discoveryengine.v1beta.Document.getDefaultInstance()
              : document_;
        }
      }
      /**
       *
       *
       * <pre>
       * The document data snippet in the suggestion. Only a subset of fields is
       * populated.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1beta.Document document = 4;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.discoveryengine.v1beta.Document,
              com.google.cloud.discoveryengine.v1beta.Document.Builder,
              com.google.cloud.discoveryengine.v1beta.DocumentOrBuilder>
          getDocumentFieldBuilder() {
        if (documentBuilder_ == null) {
          documentBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.discoveryengine.v1beta.Document,
                  com.google.cloud.discoveryengine.v1beta.Document.Builder,
                  com.google.cloud.discoveryengine.v1beta.DocumentOrBuilder>(
                  getDocument(), getParentForChildren(), isClean());
          document_ = null;
        }
        return documentBuilder_;
      }

      private java.lang.Object dataStore_ = "";
      /**
       *
       *
       * <pre>
       * The name of the dataStore that this suggestion belongs to.
       * </pre>
       *
       * <code>string data_store = 5 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return The dataStore.
       */
      public java.lang.String getDataStore() {
        java.lang.Object ref = dataStore_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          dataStore_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The name of the dataStore that this suggestion belongs to.
       * </pre>
       *
       * <code>string data_store = 5 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return The bytes for dataStore.
       */
      public com.google.protobuf.ByteString getDataStoreBytes() {
        java.lang.Object ref = dataStore_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          dataStore_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The name of the dataStore that this suggestion belongs to.
       * </pre>
       *
       * <code>string data_store = 5 [(.google.api.resource_reference) = { ... }</code>
       *
       * @param value The dataStore to set.
       * @return This builder for chaining.
       */
      public Builder setDataStore(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        dataStore_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The name of the dataStore that this suggestion belongs to.
       * </pre>
       *
       * <code>string data_store = 5 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDataStore() {
        dataStore_ = getDefaultInstance().getDataStore();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The name of the dataStore that this suggestion belongs to.
       * </pre>
       *
       * <code>string data_store = 5 [(.google.api.resource_reference) = { ... }</code>
       *
       * @param value The bytes for dataStore to set.
       * @return This builder for chaining.
       */
      public Builder setDataStoreBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        dataStore_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.PersonSuggestion)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.PersonSuggestion)
    private static final com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
            .PersonSuggestion
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
              .PersonSuggestion();
    }

    public static com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
            .PersonSuggestion
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<PersonSuggestion> PARSER =
        new com.google.protobuf.AbstractParser<PersonSuggestion>() {
          @java.lang.Override
          public PersonSuggestion parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<PersonSuggestion> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<PersonSuggestion> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.PersonSuggestion
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ContentSuggestionOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.ContentSuggestion)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The suggestion for the query.
     * </pre>
     *
     * <code>string suggestion = 1;</code>
     *
     * @return The suggestion.
     */
    java.lang.String getSuggestion();
    /**
     *
     *
     * <pre>
     * The suggestion for the query.
     * </pre>
     *
     * <code>string suggestion = 1;</code>
     *
     * @return The bytes for suggestion.
     */
    com.google.protobuf.ByteString getSuggestionBytes();

    /**
     *
     *
     * <pre>
     * The type of the content suggestion.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.ContentSuggestion.ContentType content_type = 2;
     * </code>
     *
     * @return The enum numeric value on the wire for contentType.
     */
    int getContentTypeValue();
    /**
     *
     *
     * <pre>
     * The type of the content suggestion.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.ContentSuggestion.ContentType content_type = 2;
     * </code>
     *
     * @return The contentType.
     */
    com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.ContentSuggestion
            .ContentType
        getContentType();

    /**
     *
     *
     * <pre>
     * The document data snippet in the suggestion. Only a subset of fields will
     * be populated.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.Document document = 4;</code>
     *
     * @return Whether the document field is set.
     */
    boolean hasDocument();
    /**
     *
     *
     * <pre>
     * The document data snippet in the suggestion. Only a subset of fields will
     * be populated.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.Document document = 4;</code>
     *
     * @return The document.
     */
    com.google.cloud.discoveryengine.v1beta.Document getDocument();
    /**
     *
     *
     * <pre>
     * The document data snippet in the suggestion. Only a subset of fields will
     * be populated.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.Document document = 4;</code>
     */
    com.google.cloud.discoveryengine.v1beta.DocumentOrBuilder getDocumentOrBuilder();

    /**
     *
     *
     * <pre>
     * The name of the dataStore that this suggestion belongs to.
     * </pre>
     *
     * <code>string data_store = 5 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The dataStore.
     */
    java.lang.String getDataStore();
    /**
     *
     *
     * <pre>
     * The name of the dataStore that this suggestion belongs to.
     * </pre>
     *
     * <code>string data_store = 5 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for dataStore.
     */
    com.google.protobuf.ByteString getDataStoreBytes();
  }
  /**
   *
   *
   * <pre>
   * Suggestions as content.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.ContentSuggestion}
   */
  public static final class ContentSuggestion extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.ContentSuggestion)
      ContentSuggestionOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ContentSuggestion.newBuilder() to construct.
    private ContentSuggestion(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ContentSuggestion() {
      suggestion_ = "";
      contentType_ = 0;
      dataStore_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ContentSuggestion();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1beta.CompletionServiceProto
          .internal_static_google_cloud_discoveryengine_v1beta_AdvancedCompleteQueryResponse_ContentSuggestion_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1beta.CompletionServiceProto
          .internal_static_google_cloud_discoveryengine_v1beta_AdvancedCompleteQueryResponse_ContentSuggestion_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
                  .ContentSuggestion.class,
              com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
                  .ContentSuggestion.Builder.class);
    }

    /**
     *
     *
     * <pre>
     * The type of the content returned for content suggestions.
     * </pre>
     *
     * Protobuf enum {@code
     * google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.ContentSuggestion.ContentType}
     */
    public enum ContentType implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Default value.
       * </pre>
       *
       * <code>CONTENT_TYPE_UNSPECIFIED = 0;</code>
       */
      CONTENT_TYPE_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * The suggestion is from a Google Workspace source.
       * </pre>
       *
       * <code>GOOGLE_WORKSPACE = 1;</code>
       */
      GOOGLE_WORKSPACE(1),
      /**
       *
       *
       * <pre>
       * The suggestion is from a third party source.
       * </pre>
       *
       * <code>THIRD_PARTY = 2;</code>
       */
      THIRD_PARTY(2),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Default value.
       * </pre>
       *
       * <code>CONTENT_TYPE_UNSPECIFIED = 0;</code>
       */
      public static final int CONTENT_TYPE_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * The suggestion is from a Google Workspace source.
       * </pre>
       *
       * <code>GOOGLE_WORKSPACE = 1;</code>
       */
      public static final int GOOGLE_WORKSPACE_VALUE = 1;
      /**
       *
       *
       * <pre>
       * The suggestion is from a third party source.
       * </pre>
       *
       * <code>THIRD_PARTY = 2;</code>
       */
      public static final int THIRD_PARTY_VALUE = 2;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static ContentType valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static ContentType forNumber(int value) {
        switch (value) {
          case 0:
            return CONTENT_TYPE_UNSPECIFIED;
          case 1:
            return GOOGLE_WORKSPACE;
          case 2:
            return THIRD_PARTY;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<ContentType> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<ContentType> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<ContentType>() {
            public ContentType findValueByNumber(int number) {
              return ContentType.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
            .ContentSuggestion.getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final ContentType[] VALUES = values();

      public static ContentType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private ContentType(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.ContentSuggestion.ContentType)
    }

    private int bitField0_;
    public static final int SUGGESTION_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object suggestion_ = "";
    /**
     *
     *
     * <pre>
     * The suggestion for the query.
     * </pre>
     *
     * <code>string suggestion = 1;</code>
     *
     * @return The suggestion.
     */
    @java.lang.Override
    public java.lang.String getSuggestion() {
      java.lang.Object ref = suggestion_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        suggestion_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The suggestion for the query.
     * </pre>
     *
     * <code>string suggestion = 1;</code>
     *
     * @return The bytes for suggestion.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getSuggestionBytes() {
      java.lang.Object ref = suggestion_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        suggestion_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int CONTENT_TYPE_FIELD_NUMBER = 2;
    private int contentType_ = 0;
    /**
     *
     *
     * <pre>
     * The type of the content suggestion.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.ContentSuggestion.ContentType content_type = 2;
     * </code>
     *
     * @return The enum numeric value on the wire for contentType.
     */
    @java.lang.Override
    public int getContentTypeValue() {
      return contentType_;
    }
    /**
     *
     *
     * <pre>
     * The type of the content suggestion.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.ContentSuggestion.ContentType content_type = 2;
     * </code>
     *
     * @return The contentType.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.ContentSuggestion
            .ContentType
        getContentType() {
      com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.ContentSuggestion
              .ContentType
          result =
              com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
                  .ContentSuggestion.ContentType.forNumber(contentType_);
      return result == null
          ? com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.ContentSuggestion
              .ContentType.UNRECOGNIZED
          : result;
    }

    public static final int DOCUMENT_FIELD_NUMBER = 4;
    private com.google.cloud.discoveryengine.v1beta.Document document_;
    /**
     *
     *
     * <pre>
     * The document data snippet in the suggestion. Only a subset of fields will
     * be populated.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.Document document = 4;</code>
     *
     * @return Whether the document field is set.
     */
    @java.lang.Override
    public boolean hasDocument() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * The document data snippet in the suggestion. Only a subset of fields will
     * be populated.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.Document document = 4;</code>
     *
     * @return The document.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.Document getDocument() {
      return document_ == null
          ? com.google.cloud.discoveryengine.v1beta.Document.getDefaultInstance()
          : document_;
    }
    /**
     *
     *
     * <pre>
     * The document data snippet in the suggestion. Only a subset of fields will
     * be populated.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.Document document = 4;</code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.DocumentOrBuilder getDocumentOrBuilder() {
      return document_ == null
          ? com.google.cloud.discoveryengine.v1beta.Document.getDefaultInstance()
          : document_;
    }

    public static final int DATA_STORE_FIELD_NUMBER = 5;

    @SuppressWarnings("serial")
    private volatile java.lang.Object dataStore_ = "";
    /**
     *
     *
     * <pre>
     * The name of the dataStore that this suggestion belongs to.
     * </pre>
     *
     * <code>string data_store = 5 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The dataStore.
     */
    @java.lang.Override
    public java.lang.String getDataStore() {
      java.lang.Object ref = dataStore_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        dataStore_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the dataStore that this suggestion belongs to.
     * </pre>
     *
     * <code>string data_store = 5 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for dataStore.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getDataStoreBytes() {
      java.lang.Object ref = dataStore_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        dataStore_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(suggestion_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, suggestion_);
      }
      if (contentType_
          != com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.ContentSuggestion
              .ContentType.CONTENT_TYPE_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(2, contentType_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(4, getDocument());
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dataStore_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 5, dataStore_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(suggestion_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, suggestion_);
      }
      if (contentType_
          != com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.ContentSuggestion
              .ContentType.CONTENT_TYPE_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, contentType_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getDocument());
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dataStore_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, dataStore_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
              .ContentSuggestion)) {
        return super.equals(obj);
      }
      com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.ContentSuggestion
          other =
              (com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
                      .ContentSuggestion)
                  obj;

      if (!getSuggestion().equals(other.getSuggestion())) return false;
      if (contentType_ != other.contentType_) return false;
      if (hasDocument() != other.hasDocument()) return false;
      if (hasDocument()) {
        if (!getDocument().equals(other.getDocument())) return false;
      }
      if (!getDataStore().equals(other.getDataStore())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + SUGGESTION_FIELD_NUMBER;
      hash = (53 * hash) + getSuggestion().hashCode();
      hash = (37 * hash) + CONTENT_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + contentType_;
      if (hasDocument()) {
        hash = (37 * hash) + DOCUMENT_FIELD_NUMBER;
        hash = (53 * hash) + getDocument().hashCode();
      }
      hash = (37 * hash) + DATA_STORE_FIELD_NUMBER;
      hash = (53 * hash) + getDataStore().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
            .ContentSuggestion
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
            .ContentSuggestion
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
            .ContentSuggestion
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
            .ContentSuggestion
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
            .ContentSuggestion
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
            .ContentSuggestion
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
            .ContentSuggestion
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
            .ContentSuggestion
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
            .ContentSuggestion
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
            .ContentSuggestion
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
            .ContentSuggestion
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
            .ContentSuggestion
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.ContentSuggestion
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Suggestions as content.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.ContentSuggestion}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.ContentSuggestion)
        com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
            .ContentSuggestionOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1beta.CompletionServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_AdvancedCompleteQueryResponse_ContentSuggestion_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1beta.CompletionServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_AdvancedCompleteQueryResponse_ContentSuggestion_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
                    .ContentSuggestion.class,
                com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
                    .ContentSuggestion.Builder.class);
      }

      // Construct using
      // com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.ContentSuggestion.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getDocumentFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        suggestion_ = "";
        contentType_ = 0;
        document_ = null;
        if (documentBuilder_ != null) {
          documentBuilder_.dispose();
          documentBuilder_ = null;
        }
        dataStore_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.discoveryengine.v1beta.CompletionServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_AdvancedCompleteQueryResponse_ContentSuggestion_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.ContentSuggestion
          getDefaultInstanceForType() {
        return com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
            .ContentSuggestion.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.ContentSuggestion
          build() {
        com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.ContentSuggestion
            result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.ContentSuggestion
          buildPartial() {
        com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.ContentSuggestion
            result =
                new com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
                    .ContentSuggestion(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.ContentSuggestion
              result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.suggestion_ = suggestion_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.contentType_ = contentType_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.document_ = documentBuilder_ == null ? document_ : documentBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.dataStore_ = dataStore_;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
                .ContentSuggestion) {
          return mergeFrom(
              (com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
                      .ContentSuggestion)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.ContentSuggestion
              other) {
        if (other
            == com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
                .ContentSuggestion.getDefaultInstance()) return this;
        if (!other.getSuggestion().isEmpty()) {
          suggestion_ = other.suggestion_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (other.contentType_ != 0) {
          setContentTypeValue(other.getContentTypeValue());
        }
        if (other.hasDocument()) {
          mergeDocument(other.getDocument());
        }
        if (!other.getDataStore().isEmpty()) {
          dataStore_ = other.dataStore_;
          bitField0_ |= 0x00000008;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  suggestion_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 16:
                {
                  contentType_ = input.readEnum();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              case 34:
                {
                  input.readMessage(getDocumentFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000004;
                  break;
                } // case 34
              case 42:
                {
                  dataStore_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 42
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object suggestion_ = "";
      /**
       *
       *
       * <pre>
       * The suggestion for the query.
       * </pre>
       *
       * <code>string suggestion = 1;</code>
       *
       * @return The suggestion.
       */
      public java.lang.String getSuggestion() {
        java.lang.Object ref = suggestion_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          suggestion_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The suggestion for the query.
       * </pre>
       *
       * <code>string suggestion = 1;</code>
       *
       * @return The bytes for suggestion.
       */
      public com.google.protobuf.ByteString getSuggestionBytes() {
        java.lang.Object ref = suggestion_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          suggestion_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The suggestion for the query.
       * </pre>
       *
       * <code>string suggestion = 1;</code>
       *
       * @param value The suggestion to set.
       * @return This builder for chaining.
       */
      public Builder setSuggestion(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        suggestion_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The suggestion for the query.
       * </pre>
       *
       * <code>string suggestion = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearSuggestion() {
        suggestion_ = getDefaultInstance().getSuggestion();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The suggestion for the query.
       * </pre>
       *
       * <code>string suggestion = 1;</code>
       *
       * @param value The bytes for suggestion to set.
       * @return This builder for chaining.
       */
      public Builder setSuggestionBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        suggestion_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private int contentType_ = 0;
      /**
       *
       *
       * <pre>
       * The type of the content suggestion.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.ContentSuggestion.ContentType content_type = 2;
       * </code>
       *
       * @return The enum numeric value on the wire for contentType.
       */
      @java.lang.Override
      public int getContentTypeValue() {
        return contentType_;
      }
      /**
       *
       *
       * <pre>
       * The type of the content suggestion.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.ContentSuggestion.ContentType content_type = 2;
       * </code>
       *
       * @param value The enum numeric value on the wire for contentType to set.
       * @return This builder for chaining.
       */
      public Builder setContentTypeValue(int value) {
        contentType_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The type of the content suggestion.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.ContentSuggestion.ContentType content_type = 2;
       * </code>
       *
       * @return The contentType.
       */
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.ContentSuggestion
              .ContentType
          getContentType() {
        com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.ContentSuggestion
                .ContentType
            result =
                com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
                    .ContentSuggestion.ContentType.forNumber(contentType_);
        return result == null
            ? com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
                .ContentSuggestion.ContentType.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * The type of the content suggestion.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.ContentSuggestion.ContentType content_type = 2;
       * </code>
       *
       * @param value The contentType to set.
       * @return This builder for chaining.
       */
      public Builder setContentType(
          com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.ContentSuggestion
                  .ContentType
              value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000002;
        contentType_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The type of the content suggestion.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.ContentSuggestion.ContentType content_type = 2;
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearContentType() {
        bitField0_ = (bitField0_ & ~0x00000002);
        contentType_ = 0;
        onChanged();
        return this;
      }

      private com.google.cloud.discoveryengine.v1beta.Document document_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.discoveryengine.v1beta.Document,
              com.google.cloud.discoveryengine.v1beta.Document.Builder,
              com.google.cloud.discoveryengine.v1beta.DocumentOrBuilder>
          documentBuilder_;
      /**
       *
       *
       * <pre>
       * The document data snippet in the suggestion. Only a subset of fields will
       * be populated.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1beta.Document document = 4;</code>
       *
       * @return Whether the document field is set.
       */
      public boolean hasDocument() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       *
       *
       * <pre>
       * The document data snippet in the suggestion. Only a subset of fields will
       * be populated.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1beta.Document document = 4;</code>
       *
       * @return The document.
       */
      public com.google.cloud.discoveryengine.v1beta.Document getDocument() {
        if (documentBuilder_ == null) {
          return document_ == null
              ? com.google.cloud.discoveryengine.v1beta.Document.getDefaultInstance()
              : document_;
        } else {
          return documentBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The document data snippet in the suggestion. Only a subset of fields will
       * be populated.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1beta.Document document = 4;</code>
       */
      public Builder setDocument(com.google.cloud.discoveryengine.v1beta.Document value) {
        if (documentBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          document_ = value;
        } else {
          documentBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The document data snippet in the suggestion. Only a subset of fields will
       * be populated.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1beta.Document document = 4;</code>
       */
      public Builder setDocument(
          com.google.cloud.discoveryengine.v1beta.Document.Builder builderForValue) {
        if (documentBuilder_ == null) {
          document_ = builderForValue.build();
        } else {
          documentBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The document data snippet in the suggestion. Only a subset of fields will
       * be populated.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1beta.Document document = 4;</code>
       */
      public Builder mergeDocument(com.google.cloud.discoveryengine.v1beta.Document value) {
        if (documentBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)
              && document_ != null
              && document_
                  != com.google.cloud.discoveryengine.v1beta.Document.getDefaultInstance()) {
            getDocumentBuilder().mergeFrom(value);
          } else {
            document_ = value;
          }
        } else {
          documentBuilder_.mergeFrom(value);
        }
        if (document_ != null) {
          bitField0_ |= 0x00000004;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The document data snippet in the suggestion. Only a subset of fields will
       * be populated.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1beta.Document document = 4;</code>
       */
      public Builder clearDocument() {
        bitField0_ = (bitField0_ & ~0x00000004);
        document_ = null;
        if (documentBuilder_ != null) {
          documentBuilder_.dispose();
          documentBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The document data snippet in the suggestion. Only a subset of fields will
       * be populated.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1beta.Document document = 4;</code>
       */
      public com.google.cloud.discoveryengine.v1beta.Document.Builder getDocumentBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getDocumentFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The document data snippet in the suggestion. Only a subset of fields will
       * be populated.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1beta.Document document = 4;</code>
       */
      public com.google.cloud.discoveryengine.v1beta.DocumentOrBuilder getDocumentOrBuilder() {
        if (documentBuilder_ != null) {
          return documentBuilder_.getMessageOrBuilder();
        } else {
          return document_ == null
              ? com.google.cloud.discoveryengine.v1beta.Document.getDefaultInstance()
              : document_;
        }
      }
      /**
       *
       *
       * <pre>
       * The document data snippet in the suggestion. Only a subset of fields will
       * be populated.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1beta.Document document = 4;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.discoveryengine.v1beta.Document,
              com.google.cloud.discoveryengine.v1beta.Document.Builder,
              com.google.cloud.discoveryengine.v1beta.DocumentOrBuilder>
          getDocumentFieldBuilder() {
        if (documentBuilder_ == null) {
          documentBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.discoveryengine.v1beta.Document,
                  com.google.cloud.discoveryengine.v1beta.Document.Builder,
                  com.google.cloud.discoveryengine.v1beta.DocumentOrBuilder>(
                  getDocument(), getParentForChildren(), isClean());
          document_ = null;
        }
        return documentBuilder_;
      }

      private java.lang.Object dataStore_ = "";
      /**
       *
       *
       * <pre>
       * The name of the dataStore that this suggestion belongs to.
       * </pre>
       *
       * <code>string data_store = 5 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return The dataStore.
       */
      public java.lang.String getDataStore() {
        java.lang.Object ref = dataStore_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          dataStore_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The name of the dataStore that this suggestion belongs to.
       * </pre>
       *
       * <code>string data_store = 5 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return The bytes for dataStore.
       */
      public com.google.protobuf.ByteString getDataStoreBytes() {
        java.lang.Object ref = dataStore_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          dataStore_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The name of the dataStore that this suggestion belongs to.
       * </pre>
       *
       * <code>string data_store = 5 [(.google.api.resource_reference) = { ... }</code>
       *
       * @param value The dataStore to set.
       * @return This builder for chaining.
       */
      public Builder setDataStore(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        dataStore_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The name of the dataStore that this suggestion belongs to.
       * </pre>
       *
       * <code>string data_store = 5 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDataStore() {
        dataStore_ = getDefaultInstance().getDataStore();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The name of the dataStore that this suggestion belongs to.
       * </pre>
       *
       * <code>string data_store = 5 [(.google.api.resource_reference) = { ... }</code>
       *
       * @param value The bytes for dataStore to set.
       * @return This builder for chaining.
       */
      public Builder setDataStoreBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        dataStore_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.ContentSuggestion)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.ContentSuggestion)
    private static final com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
            .ContentSuggestion
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
              .ContentSuggestion();
    }

    public static com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
            .ContentSuggestion
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ContentSuggestion> PARSER =
        new com.google.protobuf.AbstractParser<ContentSuggestion>() {
          @java.lang.Override
          public ContentSuggestion parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ContentSuggestion> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ContentSuggestion> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.ContentSuggestion
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface RecentSearchSuggestionOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.RecentSearchSuggestion)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The suggestion for the query.
     * </pre>
     *
     * <code>string suggestion = 1;</code>
     *
     * @return The suggestion.
     */
    java.lang.String getSuggestion();
    /**
     *
     *
     * <pre>
     * The suggestion for the query.
     * </pre>
     *
     * <code>string suggestion = 1;</code>
     *
     * @return The bytes for suggestion.
     */
    com.google.protobuf.ByteString getSuggestionBytes();

    /**
     *
     *
     * <pre>
     * The time when this recent rearch happened.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp recent_search_time = 2;</code>
     *
     * @return Whether the recentSearchTime field is set.
     */
    boolean hasRecentSearchTime();
    /**
     *
     *
     * <pre>
     * The time when this recent rearch happened.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp recent_search_time = 2;</code>
     *
     * @return The recentSearchTime.
     */
    com.google.protobuf.Timestamp getRecentSearchTime();
    /**
     *
     *
     * <pre>
     * The time when this recent rearch happened.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp recent_search_time = 2;</code>
     */
    com.google.protobuf.TimestampOrBuilder getRecentSearchTimeOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * Suggestions from recent search history.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.RecentSearchSuggestion}
   */
  public static final class RecentSearchSuggestion extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.RecentSearchSuggestion)
      RecentSearchSuggestionOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use RecentSearchSuggestion.newBuilder() to construct.
    private RecentSearchSuggestion(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private RecentSearchSuggestion() {
      suggestion_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new RecentSearchSuggestion();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1beta.CompletionServiceProto
          .internal_static_google_cloud_discoveryengine_v1beta_AdvancedCompleteQueryResponse_RecentSearchSuggestion_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1beta.CompletionServiceProto
          .internal_static_google_cloud_discoveryengine_v1beta_AdvancedCompleteQueryResponse_RecentSearchSuggestion_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
                  .RecentSearchSuggestion.class,
              com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
                  .RecentSearchSuggestion.Builder.class);
    }

    private int bitField0_;
    public static final int SUGGESTION_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object suggestion_ = "";
    /**
     *
     *
     * <pre>
     * The suggestion for the query.
     * </pre>
     *
     * <code>string suggestion = 1;</code>
     *
     * @return The suggestion.
     */
    @java.lang.Override
    public java.lang.String getSuggestion() {
      java.lang.Object ref = suggestion_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        suggestion_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The suggestion for the query.
     * </pre>
     *
     * <code>string suggestion = 1;</code>
     *
     * @return The bytes for suggestion.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getSuggestionBytes() {
      java.lang.Object ref = suggestion_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        suggestion_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int RECENT_SEARCH_TIME_FIELD_NUMBER = 2;
    private com.google.protobuf.Timestamp recentSearchTime_;
    /**
     *
     *
     * <pre>
     * The time when this recent rearch happened.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp recent_search_time = 2;</code>
     *
     * @return Whether the recentSearchTime field is set.
     */
    @java.lang.Override
    public boolean hasRecentSearchTime() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * The time when this recent rearch happened.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp recent_search_time = 2;</code>
     *
     * @return The recentSearchTime.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getRecentSearchTime() {
      return recentSearchTime_ == null
          ? com.google.protobuf.Timestamp.getDefaultInstance()
          : recentSearchTime_;
    }
    /**
     *
     *
     * <pre>
     * The time when this recent rearch happened.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp recent_search_time = 2;</code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getRecentSearchTimeOrBuilder() {
      return recentSearchTime_ == null
          ? com.google.protobuf.Timestamp.getDefaultInstance()
          : recentSearchTime_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(suggestion_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, suggestion_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(2, getRecentSearchTime());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(suggestion_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, suggestion_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getRecentSearchTime());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
              .RecentSearchSuggestion)) {
        return super.equals(obj);
      }
      com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.RecentSearchSuggestion
          other =
              (com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
                      .RecentSearchSuggestion)
                  obj;

      if (!getSuggestion().equals(other.getSuggestion())) return false;
      if (hasRecentSearchTime() != other.hasRecentSearchTime()) return false;
      if (hasRecentSearchTime()) {
        if (!getRecentSearchTime().equals(other.getRecentSearchTime())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + SUGGESTION_FIELD_NUMBER;
      hash = (53 * hash) + getSuggestion().hashCode();
      if (hasRecentSearchTime()) {
        hash = (37 * hash) + RECENT_SEARCH_TIME_FIELD_NUMBER;
        hash = (53 * hash) + getRecentSearchTime().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
            .RecentSearchSuggestion
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
            .RecentSearchSuggestion
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
            .RecentSearchSuggestion
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
            .RecentSearchSuggestion
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
            .RecentSearchSuggestion
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
            .RecentSearchSuggestion
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
            .RecentSearchSuggestion
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
            .RecentSearchSuggestion
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
            .RecentSearchSuggestion
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
            .RecentSearchSuggestion
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
            .RecentSearchSuggestion
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
            .RecentSearchSuggestion
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.RecentSearchSuggestion
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Suggestions from recent search history.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.RecentSearchSuggestion}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.RecentSearchSuggestion)
        com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
            .RecentSearchSuggestionOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1beta.CompletionServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_AdvancedCompleteQueryResponse_RecentSearchSuggestion_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1beta.CompletionServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_AdvancedCompleteQueryResponse_RecentSearchSuggestion_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
                    .RecentSearchSuggestion.class,
                com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
                    .RecentSearchSuggestion.Builder.class);
      }

      // Construct using
      // com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.RecentSearchSuggestion.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getRecentSearchTimeFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        suggestion_ = "";
        recentSearchTime_ = null;
        if (recentSearchTimeBuilder_ != null) {
          recentSearchTimeBuilder_.dispose();
          recentSearchTimeBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.discoveryengine.v1beta.CompletionServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_AdvancedCompleteQueryResponse_RecentSearchSuggestion_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
              .RecentSearchSuggestion
          getDefaultInstanceForType() {
        return com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
            .RecentSearchSuggestion.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
              .RecentSearchSuggestion
          build() {
        com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.RecentSearchSuggestion
            result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
              .RecentSearchSuggestion
          buildPartial() {
        com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.RecentSearchSuggestion
            result =
                new com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
                    .RecentSearchSuggestion(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
                  .RecentSearchSuggestion
              result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.suggestion_ = suggestion_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.recentSearchTime_ =
              recentSearchTimeBuilder_ == null
                  ? recentSearchTime_
                  : recentSearchTimeBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
                .RecentSearchSuggestion) {
          return mergeFrom(
              (com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
                      .RecentSearchSuggestion)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
                  .RecentSearchSuggestion
              other) {
        if (other
            == com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
                .RecentSearchSuggestion.getDefaultInstance()) return this;
        if (!other.getSuggestion().isEmpty()) {
          suggestion_ = other.suggestion_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (other.hasRecentSearchTime()) {
          mergeRecentSearchTime(other.getRecentSearchTime());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  suggestion_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(
                      getRecentSearchTimeFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object suggestion_ = "";
      /**
       *
       *
       * <pre>
       * The suggestion for the query.
       * </pre>
       *
       * <code>string suggestion = 1;</code>
       *
       * @return The suggestion.
       */
      public java.lang.String getSuggestion() {
        java.lang.Object ref = suggestion_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          suggestion_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The suggestion for the query.
       * </pre>
       *
       * <code>string suggestion = 1;</code>
       *
       * @return The bytes for suggestion.
       */
      public com.google.protobuf.ByteString getSuggestionBytes() {
        java.lang.Object ref = suggestion_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          suggestion_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The suggestion for the query.
       * </pre>
       *
       * <code>string suggestion = 1;</code>
       *
       * @param value The suggestion to set.
       * @return This builder for chaining.
       */
      public Builder setSuggestion(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        suggestion_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The suggestion for the query.
       * </pre>
       *
       * <code>string suggestion = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearSuggestion() {
        suggestion_ = getDefaultInstance().getSuggestion();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The suggestion for the query.
       * </pre>
       *
       * <code>string suggestion = 1;</code>
       *
       * @param value The bytes for suggestion to set.
       * @return This builder for chaining.
       */
      public Builder setSuggestionBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        suggestion_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private com.google.protobuf.Timestamp recentSearchTime_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          recentSearchTimeBuilder_;
      /**
       *
       *
       * <pre>
       * The time when this recent rearch happened.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp recent_search_time = 2;</code>
       *
       * @return Whether the recentSearchTime field is set.
       */
      public boolean hasRecentSearchTime() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * The time when this recent rearch happened.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp recent_search_time = 2;</code>
       *
       * @return The recentSearchTime.
       */
      public com.google.protobuf.Timestamp getRecentSearchTime() {
        if (recentSearchTimeBuilder_ == null) {
          return recentSearchTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : recentSearchTime_;
        } else {
          return recentSearchTimeBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The time when this recent rearch happened.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp recent_search_time = 2;</code>
       */
      public Builder setRecentSearchTime(com.google.protobuf.Timestamp value) {
        if (recentSearchTimeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          recentSearchTime_ = value;
        } else {
          recentSearchTimeBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The time when this recent rearch happened.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp recent_search_time = 2;</code>
       */
      public Builder setRecentSearchTime(com.google.protobuf.Timestamp.Builder builderForValue) {
        if (recentSearchTimeBuilder_ == null) {
          recentSearchTime_ = builderForValue.build();
        } else {
          recentSearchTimeBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The time when this recent rearch happened.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp recent_search_time = 2;</code>
       */
      public Builder mergeRecentSearchTime(com.google.protobuf.Timestamp value) {
        if (recentSearchTimeBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && recentSearchTime_ != null
              && recentSearchTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
            getRecentSearchTimeBuilder().mergeFrom(value);
          } else {
            recentSearchTime_ = value;
          }
        } else {
          recentSearchTimeBuilder_.mergeFrom(value);
        }
        if (recentSearchTime_ != null) {
          bitField0_ |= 0x00000002;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The time when this recent rearch happened.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp recent_search_time = 2;</code>
       */
      public Builder clearRecentSearchTime() {
        bitField0_ = (bitField0_ & ~0x00000002);
        recentSearchTime_ = null;
        if (recentSearchTimeBuilder_ != null) {
          recentSearchTimeBuilder_.dispose();
          recentSearchTimeBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The time when this recent rearch happened.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp recent_search_time = 2;</code>
       */
      public com.google.protobuf.Timestamp.Builder getRecentSearchTimeBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getRecentSearchTimeFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The time when this recent rearch happened.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp recent_search_time = 2;</code>
       */
      public com.google.protobuf.TimestampOrBuilder getRecentSearchTimeOrBuilder() {
        if (recentSearchTimeBuilder_ != null) {
          return recentSearchTimeBuilder_.getMessageOrBuilder();
        } else {
          return recentSearchTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : recentSearchTime_;
        }
      }
      /**
       *
       *
       * <pre>
       * The time when this recent rearch happened.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp recent_search_time = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          getRecentSearchTimeFieldBuilder() {
        if (recentSearchTimeBuilder_ == null) {
          recentSearchTimeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Timestamp,
                  com.google.protobuf.Timestamp.Builder,
                  com.google.protobuf.TimestampOrBuilder>(
                  getRecentSearchTime(), getParentForChildren(), isClean());
          recentSearchTime_ = null;
        }
        return recentSearchTimeBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.RecentSearchSuggestion)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.RecentSearchSuggestion)
    private static final com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
            .RecentSearchSuggestion
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
              .RecentSearchSuggestion();
    }

    public static com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
            .RecentSearchSuggestion
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<RecentSearchSuggestion> PARSER =
        new com.google.protobuf.AbstractParser<RecentSearchSuggestion>() {
          @java.lang.Override
          public RecentSearchSuggestion parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<RecentSearchSuggestion> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<RecentSearchSuggestion> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
            .RecentSearchSuggestion
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int QUERY_SUGGESTIONS_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<
          com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.QuerySuggestion>
      querySuggestions_;
  /**
   *
   *
   * <pre>
   * Results of the matched query suggestions. The result list is ordered and
   * the first result is a top suggestion.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.QuerySuggestion query_suggestions = 1;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.QuerySuggestion>
      getQuerySuggestionsList() {
    return querySuggestions_;
  }
  /**
   *
   *
   * <pre>
   * Results of the matched query suggestions. The result list is ordered and
   * the first result is a top suggestion.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.QuerySuggestion query_suggestions = 1;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends
              com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
                  .QuerySuggestionOrBuilder>
      getQuerySuggestionsOrBuilderList() {
    return querySuggestions_;
  }
  /**
   *
   *
   * <pre>
   * Results of the matched query suggestions. The result list is ordered and
   * the first result is a top suggestion.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.QuerySuggestion query_suggestions = 1;
   * </code>
   */
  @java.lang.Override
  public int getQuerySuggestionsCount() {
    return querySuggestions_.size();
  }
  /**
   *
   *
   * <pre>
   * Results of the matched query suggestions. The result list is ordered and
   * the first result is a top suggestion.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.QuerySuggestion query_suggestions = 1;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.QuerySuggestion
      getQuerySuggestions(int index) {
    return querySuggestions_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Results of the matched query suggestions. The result list is ordered and
   * the first result is a top suggestion.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.QuerySuggestion query_suggestions = 1;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
          .QuerySuggestionOrBuilder
      getQuerySuggestionsOrBuilder(int index) {
    return querySuggestions_.get(index);
  }

  public static final int TAIL_MATCH_TRIGGERED_FIELD_NUMBER = 2;
  private boolean tailMatchTriggered_ = false;
  /**
   *
   *
   * <pre>
   * True if the returned suggestions are all tail suggestions.
   *
   * For tail matching to be triggered, include_tail_suggestions in the request
   * must be true and there must be no suggestions that match the full query.
   * </pre>
   *
   * <code>bool tail_match_triggered = 2;</code>
   *
   * @return The tailMatchTriggered.
   */
  @java.lang.Override
  public boolean getTailMatchTriggered() {
    return tailMatchTriggered_;
  }

  public static final int PEOPLE_SUGGESTIONS_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private java.util.List<
          com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.PersonSuggestion>
      peopleSuggestions_;
  /**
   *
   *
   * <pre>
   * Results of the matched people suggestions. The result list is ordered and
   * the first result is the top suggestion.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.PersonSuggestion people_suggestions = 3;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.PersonSuggestion>
      getPeopleSuggestionsList() {
    return peopleSuggestions_;
  }
  /**
   *
   *
   * <pre>
   * Results of the matched people suggestions. The result list is ordered and
   * the first result is the top suggestion.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.PersonSuggestion people_suggestions = 3;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends
              com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
                  .PersonSuggestionOrBuilder>
      getPeopleSuggestionsOrBuilderList() {
    return peopleSuggestions_;
  }
  /**
   *
   *
   * <pre>
   * Results of the matched people suggestions. The result list is ordered and
   * the first result is the top suggestion.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.PersonSuggestion people_suggestions = 3;
   * </code>
   */
  @java.lang.Override
  public int getPeopleSuggestionsCount() {
    return peopleSuggestions_.size();
  }
  /**
   *
   *
   * <pre>
   * Results of the matched people suggestions. The result list is ordered and
   * the first result is the top suggestion.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.PersonSuggestion people_suggestions = 3;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.PersonSuggestion
      getPeopleSuggestions(int index) {
    return peopleSuggestions_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Results of the matched people suggestions. The result list is ordered and
   * the first result is the top suggestion.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.PersonSuggestion people_suggestions = 3;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
          .PersonSuggestionOrBuilder
      getPeopleSuggestionsOrBuilder(int index) {
    return peopleSuggestions_.get(index);
  }

  public static final int CONTENT_SUGGESTIONS_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private java.util.List<
          com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.ContentSuggestion>
      contentSuggestions_;
  /**
   *
   *
   * <pre>
   * Results of the matched content suggestions. The result list is ordered and
   * the first result is the top suggestion.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.ContentSuggestion content_suggestions = 4;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.ContentSuggestion>
      getContentSuggestionsList() {
    return contentSuggestions_;
  }
  /**
   *
   *
   * <pre>
   * Results of the matched content suggestions. The result list is ordered and
   * the first result is the top suggestion.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.ContentSuggestion content_suggestions = 4;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends
              com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
                  .ContentSuggestionOrBuilder>
      getContentSuggestionsOrBuilderList() {
    return contentSuggestions_;
  }
  /**
   *
   *
   * <pre>
   * Results of the matched content suggestions. The result list is ordered and
   * the first result is the top suggestion.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.ContentSuggestion content_suggestions = 4;
   * </code>
   */
  @java.lang.Override
  public int getContentSuggestionsCount() {
    return contentSuggestions_.size();
  }
  /**
   *
   *
   * <pre>
   * Results of the matched content suggestions. The result list is ordered and
   * the first result is the top suggestion.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.ContentSuggestion content_suggestions = 4;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.ContentSuggestion
      getContentSuggestions(int index) {
    return contentSuggestions_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Results of the matched content suggestions. The result list is ordered and
   * the first result is the top suggestion.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.ContentSuggestion content_suggestions = 4;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
          .ContentSuggestionOrBuilder
      getContentSuggestionsOrBuilder(int index) {
    return contentSuggestions_.get(index);
  }

  public static final int RECENT_SEARCH_SUGGESTIONS_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private java.util.List<
          com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
              .RecentSearchSuggestion>
      recentSearchSuggestions_;
  /**
   *
   *
   * <pre>
   * Results of the matched "recent search" suggestions. The result list is
   * ordered and the first result is the top suggestion.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.RecentSearchSuggestion recent_search_suggestions = 5;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
              .RecentSearchSuggestion>
      getRecentSearchSuggestionsList() {
    return recentSearchSuggestions_;
  }
  /**
   *
   *
   * <pre>
   * Results of the matched "recent search" suggestions. The result list is
   * ordered and the first result is the top suggestion.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.RecentSearchSuggestion recent_search_suggestions = 5;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends
              com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
                  .RecentSearchSuggestionOrBuilder>
      getRecentSearchSuggestionsOrBuilderList() {
    return recentSearchSuggestions_;
  }
  /**
   *
   *
   * <pre>
   * Results of the matched "recent search" suggestions. The result list is
   * ordered and the first result is the top suggestion.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.RecentSearchSuggestion recent_search_suggestions = 5;
   * </code>
   */
  @java.lang.Override
  public int getRecentSearchSuggestionsCount() {
    return recentSearchSuggestions_.size();
  }
  /**
   *
   *
   * <pre>
   * Results of the matched "recent search" suggestions. The result list is
   * ordered and the first result is the top suggestion.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.RecentSearchSuggestion recent_search_suggestions = 5;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
          .RecentSearchSuggestion
      getRecentSearchSuggestions(int index) {
    return recentSearchSuggestions_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Results of the matched "recent search" suggestions. The result list is
   * ordered and the first result is the top suggestion.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.RecentSearchSuggestion recent_search_suggestions = 5;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
          .RecentSearchSuggestionOrBuilder
      getRecentSearchSuggestionsOrBuilder(int index) {
    return recentSearchSuggestions_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < querySuggestions_.size(); i++) {
      output.writeMessage(1, querySuggestions_.get(i));
    }
    if (tailMatchTriggered_ != false) {
      output.writeBool(2, tailMatchTriggered_);
    }
    for (int i = 0; i < peopleSuggestions_.size(); i++) {
      output.writeMessage(3, peopleSuggestions_.get(i));
    }
    for (int i = 0; i < contentSuggestions_.size(); i++) {
      output.writeMessage(4, contentSuggestions_.get(i));
    }
    for (int i = 0; i < recentSearchSuggestions_.size(); i++) {
      output.writeMessage(5, recentSearchSuggestions_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < querySuggestions_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, querySuggestions_.get(i));
    }
    if (tailMatchTriggered_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(2, tailMatchTriggered_);
    }
    for (int i = 0; i < peopleSuggestions_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(3, peopleSuggestions_.get(i));
    }
    for (int i = 0; i < contentSuggestions_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(4, contentSuggestions_.get(i));
    }
    for (int i = 0; i < recentSearchSuggestions_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5, recentSearchSuggestions_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse)) {
      return super.equals(obj);
    }
    com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse other =
        (com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse) obj;

    if (!getQuerySuggestionsList().equals(other.getQuerySuggestionsList())) return false;
    if (getTailMatchTriggered() != other.getTailMatchTriggered()) return false;
    if (!getPeopleSuggestionsList().equals(other.getPeopleSuggestionsList())) return false;
    if (!getContentSuggestionsList().equals(other.getContentSuggestionsList())) return false;
    if (!getRecentSearchSuggestionsList().equals(other.getRecentSearchSuggestionsList()))
      return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getQuerySuggestionsCount() > 0) {
      hash = (37 * hash) + QUERY_SUGGESTIONS_FIELD_NUMBER;
      hash = (53 * hash) + getQuerySuggestionsList().hashCode();
    }
    hash = (37 * hash) + TAIL_MATCH_TRIGGERED_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getTailMatchTriggered());
    if (getPeopleSuggestionsCount() > 0) {
      hash = (37 * hash) + PEOPLE_SUGGESTIONS_FIELD_NUMBER;
      hash = (53 * hash) + getPeopleSuggestionsList().hashCode();
    }
    if (getContentSuggestionsCount() > 0) {
      hash = (37 * hash) + CONTENT_SUGGESTIONS_FIELD_NUMBER;
      hash = (53 * hash) + getContentSuggestionsList().hashCode();
    }
    if (getRecentSearchSuggestionsCount() > 0) {
      hash = (37 * hash) + RECENT_SEARCH_SUGGESTIONS_FIELD_NUMBER;
      hash = (53 * hash) + getRecentSearchSuggestionsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Response message for
   * [CompletionService.AdvancedCompleteQuery][google.cloud.discoveryengine.v1beta.CompletionService.AdvancedCompleteQuery]
   * method.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse)
      com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1beta.CompletionServiceProto
          .internal_static_google_cloud_discoveryengine_v1beta_AdvancedCompleteQueryResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1beta.CompletionServiceProto
          .internal_static_google_cloud_discoveryengine_v1beta_AdvancedCompleteQueryResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.class,
              com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.Builder.class);
    }

    // Construct using
    // com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (querySuggestionsBuilder_ == null) {
        querySuggestions_ = java.util.Collections.emptyList();
      } else {
        querySuggestions_ = null;
        querySuggestionsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      tailMatchTriggered_ = false;
      if (peopleSuggestionsBuilder_ == null) {
        peopleSuggestions_ = java.util.Collections.emptyList();
      } else {
        peopleSuggestions_ = null;
        peopleSuggestionsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      if (contentSuggestionsBuilder_ == null) {
        contentSuggestions_ = java.util.Collections.emptyList();
      } else {
        contentSuggestions_ = null;
        contentSuggestionsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000008);
      if (recentSearchSuggestionsBuilder_ == null) {
        recentSearchSuggestions_ = java.util.Collections.emptyList();
      } else {
        recentSearchSuggestions_ = null;
        recentSearchSuggestionsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000010);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.discoveryengine.v1beta.CompletionServiceProto
          .internal_static_google_cloud_discoveryengine_v1beta_AdvancedCompleteQueryResponse_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
        getDefaultInstanceForType() {
      return com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
          .getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse build() {
      com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse buildPartial() {
      com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse result =
          new com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse result) {
      if (querySuggestionsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          querySuggestions_ = java.util.Collections.unmodifiableList(querySuggestions_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.querySuggestions_ = querySuggestions_;
      } else {
        result.querySuggestions_ = querySuggestionsBuilder_.build();
      }
      if (peopleSuggestionsBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          peopleSuggestions_ = java.util.Collections.unmodifiableList(peopleSuggestions_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.peopleSuggestions_ = peopleSuggestions_;
      } else {
        result.peopleSuggestions_ = peopleSuggestionsBuilder_.build();
      }
      if (contentSuggestionsBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)) {
          contentSuggestions_ = java.util.Collections.unmodifiableList(contentSuggestions_);
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.contentSuggestions_ = contentSuggestions_;
      } else {
        result.contentSuggestions_ = contentSuggestionsBuilder_.build();
      }
      if (recentSearchSuggestionsBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)) {
          recentSearchSuggestions_ =
              java.util.Collections.unmodifiableList(recentSearchSuggestions_);
          bitField0_ = (bitField0_ & ~0x00000010);
        }
        result.recentSearchSuggestions_ = recentSearchSuggestions_;
      } else {
        result.recentSearchSuggestions_ = recentSearchSuggestionsBuilder_.build();
      }
    }

    private void buildPartial0(
        com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.tailMatchTriggered_ = tailMatchTriggered_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse) {
        return mergeFrom(
            (com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse other) {
      if (other
          == com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
              .getDefaultInstance()) return this;
      if (querySuggestionsBuilder_ == null) {
        if (!other.querySuggestions_.isEmpty()) {
          if (querySuggestions_.isEmpty()) {
            querySuggestions_ = other.querySuggestions_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureQuerySuggestionsIsMutable();
            querySuggestions_.addAll(other.querySuggestions_);
          }
          onChanged();
        }
      } else {
        if (!other.querySuggestions_.isEmpty()) {
          if (querySuggestionsBuilder_.isEmpty()) {
            querySuggestionsBuilder_.dispose();
            querySuggestionsBuilder_ = null;
            querySuggestions_ = other.querySuggestions_;
            bitField0_ = (bitField0_ & ~0x00000001);
            querySuggestionsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getQuerySuggestionsFieldBuilder()
                    : null;
          } else {
            querySuggestionsBuilder_.addAllMessages(other.querySuggestions_);
          }
        }
      }
      if (other.getTailMatchTriggered() != false) {
        setTailMatchTriggered(other.getTailMatchTriggered());
      }
      if (peopleSuggestionsBuilder_ == null) {
        if (!other.peopleSuggestions_.isEmpty()) {
          if (peopleSuggestions_.isEmpty()) {
            peopleSuggestions_ = other.peopleSuggestions_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensurePeopleSuggestionsIsMutable();
            peopleSuggestions_.addAll(other.peopleSuggestions_);
          }
          onChanged();
        }
      } else {
        if (!other.peopleSuggestions_.isEmpty()) {
          if (peopleSuggestionsBuilder_.isEmpty()) {
            peopleSuggestionsBuilder_.dispose();
            peopleSuggestionsBuilder_ = null;
            peopleSuggestions_ = other.peopleSuggestions_;
            bitField0_ = (bitField0_ & ~0x00000004);
            peopleSuggestionsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getPeopleSuggestionsFieldBuilder()
                    : null;
          } else {
            peopleSuggestionsBuilder_.addAllMessages(other.peopleSuggestions_);
          }
        }
      }
      if (contentSuggestionsBuilder_ == null) {
        if (!other.contentSuggestions_.isEmpty()) {
          if (contentSuggestions_.isEmpty()) {
            contentSuggestions_ = other.contentSuggestions_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensureContentSuggestionsIsMutable();
            contentSuggestions_.addAll(other.contentSuggestions_);
          }
          onChanged();
        }
      } else {
        if (!other.contentSuggestions_.isEmpty()) {
          if (contentSuggestionsBuilder_.isEmpty()) {
            contentSuggestionsBuilder_.dispose();
            contentSuggestionsBuilder_ = null;
            contentSuggestions_ = other.contentSuggestions_;
            bitField0_ = (bitField0_ & ~0x00000008);
            contentSuggestionsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getContentSuggestionsFieldBuilder()
                    : null;
          } else {
            contentSuggestionsBuilder_.addAllMessages(other.contentSuggestions_);
          }
        }
      }
      if (recentSearchSuggestionsBuilder_ == null) {
        if (!other.recentSearchSuggestions_.isEmpty()) {
          if (recentSearchSuggestions_.isEmpty()) {
            recentSearchSuggestions_ = other.recentSearchSuggestions_;
            bitField0_ = (bitField0_ & ~0x00000010);
          } else {
            ensureRecentSearchSuggestionsIsMutable();
            recentSearchSuggestions_.addAll(other.recentSearchSuggestions_);
          }
          onChanged();
        }
      } else {
        if (!other.recentSearchSuggestions_.isEmpty()) {
          if (recentSearchSuggestionsBuilder_.isEmpty()) {
            recentSearchSuggestionsBuilder_.dispose();
            recentSearchSuggestionsBuilder_ = null;
            recentSearchSuggestions_ = other.recentSearchSuggestions_;
            bitField0_ = (bitField0_ & ~0x00000010);
            recentSearchSuggestionsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getRecentSearchSuggestionsFieldBuilder()
                    : null;
          } else {
            recentSearchSuggestionsBuilder_.addAllMessages(other.recentSearchSuggestions_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
                        .QuerySuggestion
                    m =
                        input.readMessage(
                            com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
                                .QuerySuggestion.parser(),
                            extensionRegistry);
                if (querySuggestionsBuilder_ == null) {
                  ensureQuerySuggestionsIsMutable();
                  querySuggestions_.add(m);
                } else {
                  querySuggestionsBuilder_.addMessage(m);
                }
                break;
              } // case 10
            case 16:
              {
                tailMatchTriggered_ = input.readBool();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 26:
              {
                com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
                        .PersonSuggestion
                    m =
                        input.readMessage(
                            com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
                                .PersonSuggestion.parser(),
                            extensionRegistry);
                if (peopleSuggestionsBuilder_ == null) {
                  ensurePeopleSuggestionsIsMutable();
                  peopleSuggestions_.add(m);
                } else {
                  peopleSuggestionsBuilder_.addMessage(m);
                }
                break;
              } // case 26
            case 34:
              {
                com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
                        .ContentSuggestion
                    m =
                        input.readMessage(
                            com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
                                .ContentSuggestion.parser(),
                            extensionRegistry);
                if (contentSuggestionsBuilder_ == null) {
                  ensureContentSuggestionsIsMutable();
                  contentSuggestions_.add(m);
                } else {
                  contentSuggestionsBuilder_.addMessage(m);
                }
                break;
              } // case 34
            case 42:
              {
                com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
                        .RecentSearchSuggestion
                    m =
                        input.readMessage(
                            com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
                                .RecentSearchSuggestion.parser(),
                            extensionRegistry);
                if (recentSearchSuggestionsBuilder_ == null) {
                  ensureRecentSearchSuggestionsIsMutable();
                  recentSearchSuggestions_.add(m);
                } else {
                  recentSearchSuggestionsBuilder_.addMessage(m);
                }
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<
            com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.QuerySuggestion>
        querySuggestions_ = java.util.Collections.emptyList();

    private void ensureQuerySuggestionsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        querySuggestions_ =
            new java.util.ArrayList<
                com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
                    .QuerySuggestion>(querySuggestions_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.QuerySuggestion,
            com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.QuerySuggestion
                .Builder,
            com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
                .QuerySuggestionOrBuilder>
        querySuggestionsBuilder_;

    /**
     *
     *
     * <pre>
     * Results of the matched query suggestions. The result list is ordered and
     * the first result is a top suggestion.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.QuerySuggestion query_suggestions = 1;
     * </code>
     */
    public java.util.List<
            com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.QuerySuggestion>
        getQuerySuggestionsList() {
      if (querySuggestionsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(querySuggestions_);
      } else {
        return querySuggestionsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Results of the matched query suggestions. The result list is ordered and
     * the first result is a top suggestion.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.QuerySuggestion query_suggestions = 1;
     * </code>
     */
    public int getQuerySuggestionsCount() {
      if (querySuggestionsBuilder_ == null) {
        return querySuggestions_.size();
      } else {
        return querySuggestionsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Results of the matched query suggestions. The result list is ordered and
     * the first result is a top suggestion.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.QuerySuggestion query_suggestions = 1;
     * </code>
     */
    public com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.QuerySuggestion
        getQuerySuggestions(int index) {
      if (querySuggestionsBuilder_ == null) {
        return querySuggestions_.get(index);
      } else {
        return querySuggestionsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Results of the matched query suggestions. The result list is ordered and
     * the first result is a top suggestion.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.QuerySuggestion query_suggestions = 1;
     * </code>
     */
    public Builder setQuerySuggestions(
        int index,
        com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.QuerySuggestion
            value) {
      if (querySuggestionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureQuerySuggestionsIsMutable();
        querySuggestions_.set(index, value);
        onChanged();
      } else {
        querySuggestionsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Results of the matched query suggestions. The result list is ordered and
     * the first result is a top suggestion.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.QuerySuggestion query_suggestions = 1;
     * </code>
     */
    public Builder setQuerySuggestions(
        int index,
        com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.QuerySuggestion
                .Builder
            builderForValue) {
      if (querySuggestionsBuilder_ == null) {
        ensureQuerySuggestionsIsMutable();
        querySuggestions_.set(index, builderForValue.build());
        onChanged();
      } else {
        querySuggestionsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Results of the matched query suggestions. The result list is ordered and
     * the first result is a top suggestion.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.QuerySuggestion query_suggestions = 1;
     * </code>
     */
    public Builder addQuerySuggestions(
        com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.QuerySuggestion
            value) {
      if (querySuggestionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureQuerySuggestionsIsMutable();
        querySuggestions_.add(value);
        onChanged();
      } else {
        querySuggestionsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Results of the matched query suggestions. The result list is ordered and
     * the first result is a top suggestion.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.QuerySuggestion query_suggestions = 1;
     * </code>
     */
    public Builder addQuerySuggestions(
        int index,
        com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.QuerySuggestion
            value) {
      if (querySuggestionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureQuerySuggestionsIsMutable();
        querySuggestions_.add(index, value);
        onChanged();
      } else {
        querySuggestionsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Results of the matched query suggestions. The result list is ordered and
     * the first result is a top suggestion.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.QuerySuggestion query_suggestions = 1;
     * </code>
     */
    public Builder addQuerySuggestions(
        com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.QuerySuggestion
                .Builder
            builderForValue) {
      if (querySuggestionsBuilder_ == null) {
        ensureQuerySuggestionsIsMutable();
        querySuggestions_.add(builderForValue.build());
        onChanged();
      } else {
        querySuggestionsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Results of the matched query suggestions. The result list is ordered and
     * the first result is a top suggestion.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.QuerySuggestion query_suggestions = 1;
     * </code>
     */
    public Builder addQuerySuggestions(
        int index,
        com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.QuerySuggestion
                .Builder
            builderForValue) {
      if (querySuggestionsBuilder_ == null) {
        ensureQuerySuggestionsIsMutable();
        querySuggestions_.add(index, builderForValue.build());
        onChanged();
      } else {
        querySuggestionsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Results of the matched query suggestions. The result list is ordered and
     * the first result is a top suggestion.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.QuerySuggestion query_suggestions = 1;
     * </code>
     */
    public Builder addAllQuerySuggestions(
        java.lang.Iterable<
                ? extends
                    com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
                        .QuerySuggestion>
            values) {
      if (querySuggestionsBuilder_ == null) {
        ensureQuerySuggestionsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, querySuggestions_);
        onChanged();
      } else {
        querySuggestionsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Results of the matched query suggestions. The result list is ordered and
     * the first result is a top suggestion.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.QuerySuggestion query_suggestions = 1;
     * </code>
     */
    public Builder clearQuerySuggestions() {
      if (querySuggestionsBuilder_ == null) {
        querySuggestions_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        querySuggestionsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Results of the matched query suggestions. The result list is ordered and
     * the first result is a top suggestion.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.QuerySuggestion query_suggestions = 1;
     * </code>
     */
    public Builder removeQuerySuggestions(int index) {
      if (querySuggestionsBuilder_ == null) {
        ensureQuerySuggestionsIsMutable();
        querySuggestions_.remove(index);
        onChanged();
      } else {
        querySuggestionsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Results of the matched query suggestions. The result list is ordered and
     * the first result is a top suggestion.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.QuerySuggestion query_suggestions = 1;
     * </code>
     */
    public com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.QuerySuggestion
            .Builder
        getQuerySuggestionsBuilder(int index) {
      return getQuerySuggestionsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Results of the matched query suggestions. The result list is ordered and
     * the first result is a top suggestion.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.QuerySuggestion query_suggestions = 1;
     * </code>
     */
    public com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
            .QuerySuggestionOrBuilder
        getQuerySuggestionsOrBuilder(int index) {
      if (querySuggestionsBuilder_ == null) {
        return querySuggestions_.get(index);
      } else {
        return querySuggestionsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Results of the matched query suggestions. The result list is ordered and
     * the first result is a top suggestion.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.QuerySuggestion query_suggestions = 1;
     * </code>
     */
    public java.util.List<
            ? extends
                com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
                    .QuerySuggestionOrBuilder>
        getQuerySuggestionsOrBuilderList() {
      if (querySuggestionsBuilder_ != null) {
        return querySuggestionsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(querySuggestions_);
      }
    }
    /**
     *
     *
     * <pre>
     * Results of the matched query suggestions. The result list is ordered and
     * the first result is a top suggestion.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.QuerySuggestion query_suggestions = 1;
     * </code>
     */
    public com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.QuerySuggestion
            .Builder
        addQuerySuggestionsBuilder() {
      return getQuerySuggestionsFieldBuilder()
          .addBuilder(
              com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.QuerySuggestion
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Results of the matched query suggestions. The result list is ordered and
     * the first result is a top suggestion.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.QuerySuggestion query_suggestions = 1;
     * </code>
     */
    public com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.QuerySuggestion
            .Builder
        addQuerySuggestionsBuilder(int index) {
      return getQuerySuggestionsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.QuerySuggestion
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Results of the matched query suggestions. The result list is ordered and
     * the first result is a top suggestion.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.QuerySuggestion query_suggestions = 1;
     * </code>
     */
    public java.util.List<
            com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.QuerySuggestion
                .Builder>
        getQuerySuggestionsBuilderList() {
      return getQuerySuggestionsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.QuerySuggestion,
            com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.QuerySuggestion
                .Builder,
            com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
                .QuerySuggestionOrBuilder>
        getQuerySuggestionsFieldBuilder() {
      if (querySuggestionsBuilder_ == null) {
        querySuggestionsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
                    .QuerySuggestion,
                com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
                    .QuerySuggestion.Builder,
                com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
                    .QuerySuggestionOrBuilder>(
                querySuggestions_,
                ((bitField0_ & 0x00000001) != 0),
                getParentForChildren(),
                isClean());
        querySuggestions_ = null;
      }
      return querySuggestionsBuilder_;
    }

    private boolean tailMatchTriggered_;
    /**
     *
     *
     * <pre>
     * True if the returned suggestions are all tail suggestions.
     *
     * For tail matching to be triggered, include_tail_suggestions in the request
     * must be true and there must be no suggestions that match the full query.
     * </pre>
     *
     * <code>bool tail_match_triggered = 2;</code>
     *
     * @return The tailMatchTriggered.
     */
    @java.lang.Override
    public boolean getTailMatchTriggered() {
      return tailMatchTriggered_;
    }
    /**
     *
     *
     * <pre>
     * True if the returned suggestions are all tail suggestions.
     *
     * For tail matching to be triggered, include_tail_suggestions in the request
     * must be true and there must be no suggestions that match the full query.
     * </pre>
     *
     * <code>bool tail_match_triggered = 2;</code>
     *
     * @param value The tailMatchTriggered to set.
     * @return This builder for chaining.
     */
    public Builder setTailMatchTriggered(boolean value) {

      tailMatchTriggered_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * True if the returned suggestions are all tail suggestions.
     *
     * For tail matching to be triggered, include_tail_suggestions in the request
     * must be true and there must be no suggestions that match the full query.
     * </pre>
     *
     * <code>bool tail_match_triggered = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTailMatchTriggered() {
      bitField0_ = (bitField0_ & ~0x00000002);
      tailMatchTriggered_ = false;
      onChanged();
      return this;
    }

    private java.util.List<
            com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.PersonSuggestion>
        peopleSuggestions_ = java.util.Collections.emptyList();

    private void ensurePeopleSuggestionsIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        peopleSuggestions_ =
            new java.util.ArrayList<
                com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
                    .PersonSuggestion>(peopleSuggestions_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.PersonSuggestion,
            com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.PersonSuggestion
                .Builder,
            com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
                .PersonSuggestionOrBuilder>
        peopleSuggestionsBuilder_;

    /**
     *
     *
     * <pre>
     * Results of the matched people suggestions. The result list is ordered and
     * the first result is the top suggestion.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.PersonSuggestion people_suggestions = 3;
     * </code>
     */
    public java.util.List<
            com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.PersonSuggestion>
        getPeopleSuggestionsList() {
      if (peopleSuggestionsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(peopleSuggestions_);
      } else {
        return peopleSuggestionsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Results of the matched people suggestions. The result list is ordered and
     * the first result is the top suggestion.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.PersonSuggestion people_suggestions = 3;
     * </code>
     */
    public int getPeopleSuggestionsCount() {
      if (peopleSuggestionsBuilder_ == null) {
        return peopleSuggestions_.size();
      } else {
        return peopleSuggestionsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Results of the matched people suggestions. The result list is ordered and
     * the first result is the top suggestion.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.PersonSuggestion people_suggestions = 3;
     * </code>
     */
    public com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.PersonSuggestion
        getPeopleSuggestions(int index) {
      if (peopleSuggestionsBuilder_ == null) {
        return peopleSuggestions_.get(index);
      } else {
        return peopleSuggestionsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Results of the matched people suggestions. The result list is ordered and
     * the first result is the top suggestion.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.PersonSuggestion people_suggestions = 3;
     * </code>
     */
    public Builder setPeopleSuggestions(
        int index,
        com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.PersonSuggestion
            value) {
      if (peopleSuggestionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePeopleSuggestionsIsMutable();
        peopleSuggestions_.set(index, value);
        onChanged();
      } else {
        peopleSuggestionsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Results of the matched people suggestions. The result list is ordered and
     * the first result is the top suggestion.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.PersonSuggestion people_suggestions = 3;
     * </code>
     */
    public Builder setPeopleSuggestions(
        int index,
        com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.PersonSuggestion
                .Builder
            builderForValue) {
      if (peopleSuggestionsBuilder_ == null) {
        ensurePeopleSuggestionsIsMutable();
        peopleSuggestions_.set(index, builderForValue.build());
        onChanged();
      } else {
        peopleSuggestionsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Results of the matched people suggestions. The result list is ordered and
     * the first result is the top suggestion.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.PersonSuggestion people_suggestions = 3;
     * </code>
     */
    public Builder addPeopleSuggestions(
        com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.PersonSuggestion
            value) {
      if (peopleSuggestionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePeopleSuggestionsIsMutable();
        peopleSuggestions_.add(value);
        onChanged();
      } else {
        peopleSuggestionsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Results of the matched people suggestions. The result list is ordered and
     * the first result is the top suggestion.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.PersonSuggestion people_suggestions = 3;
     * </code>
     */
    public Builder addPeopleSuggestions(
        int index,
        com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.PersonSuggestion
            value) {
      if (peopleSuggestionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePeopleSuggestionsIsMutable();
        peopleSuggestions_.add(index, value);
        onChanged();
      } else {
        peopleSuggestionsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Results of the matched people suggestions. The result list is ordered and
     * the first result is the top suggestion.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.PersonSuggestion people_suggestions = 3;
     * </code>
     */
    public Builder addPeopleSuggestions(
        com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.PersonSuggestion
                .Builder
            builderForValue) {
      if (peopleSuggestionsBuilder_ == null) {
        ensurePeopleSuggestionsIsMutable();
        peopleSuggestions_.add(builderForValue.build());
        onChanged();
      } else {
        peopleSuggestionsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Results of the matched people suggestions. The result list is ordered and
     * the first result is the top suggestion.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.PersonSuggestion people_suggestions = 3;
     * </code>
     */
    public Builder addPeopleSuggestions(
        int index,
        com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.PersonSuggestion
                .Builder
            builderForValue) {
      if (peopleSuggestionsBuilder_ == null) {
        ensurePeopleSuggestionsIsMutable();
        peopleSuggestions_.add(index, builderForValue.build());
        onChanged();
      } else {
        peopleSuggestionsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Results of the matched people suggestions. The result list is ordered and
     * the first result is the top suggestion.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.PersonSuggestion people_suggestions = 3;
     * </code>
     */
    public Builder addAllPeopleSuggestions(
        java.lang.Iterable<
                ? extends
                    com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
                        .PersonSuggestion>
            values) {
      if (peopleSuggestionsBuilder_ == null) {
        ensurePeopleSuggestionsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, peopleSuggestions_);
        onChanged();
      } else {
        peopleSuggestionsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Results of the matched people suggestions. The result list is ordered and
     * the first result is the top suggestion.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.PersonSuggestion people_suggestions = 3;
     * </code>
     */
    public Builder clearPeopleSuggestions() {
      if (peopleSuggestionsBuilder_ == null) {
        peopleSuggestions_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        peopleSuggestionsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Results of the matched people suggestions. The result list is ordered and
     * the first result is the top suggestion.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.PersonSuggestion people_suggestions = 3;
     * </code>
     */
    public Builder removePeopleSuggestions(int index) {
      if (peopleSuggestionsBuilder_ == null) {
        ensurePeopleSuggestionsIsMutable();
        peopleSuggestions_.remove(index);
        onChanged();
      } else {
        peopleSuggestionsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Results of the matched people suggestions. The result list is ordered and
     * the first result is the top suggestion.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.PersonSuggestion people_suggestions = 3;
     * </code>
     */
    public com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.PersonSuggestion
            .Builder
        getPeopleSuggestionsBuilder(int index) {
      return getPeopleSuggestionsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Results of the matched people suggestions. The result list is ordered and
     * the first result is the top suggestion.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.PersonSuggestion people_suggestions = 3;
     * </code>
     */
    public com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
            .PersonSuggestionOrBuilder
        getPeopleSuggestionsOrBuilder(int index) {
      if (peopleSuggestionsBuilder_ == null) {
        return peopleSuggestions_.get(index);
      } else {
        return peopleSuggestionsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Results of the matched people suggestions. The result list is ordered and
     * the first result is the top suggestion.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.PersonSuggestion people_suggestions = 3;
     * </code>
     */
    public java.util.List<
            ? extends
                com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
                    .PersonSuggestionOrBuilder>
        getPeopleSuggestionsOrBuilderList() {
      if (peopleSuggestionsBuilder_ != null) {
        return peopleSuggestionsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(peopleSuggestions_);
      }
    }
    /**
     *
     *
     * <pre>
     * Results of the matched people suggestions. The result list is ordered and
     * the first result is the top suggestion.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.PersonSuggestion people_suggestions = 3;
     * </code>
     */
    public com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.PersonSuggestion
            .Builder
        addPeopleSuggestionsBuilder() {
      return getPeopleSuggestionsFieldBuilder()
          .addBuilder(
              com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.PersonSuggestion
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Results of the matched people suggestions. The result list is ordered and
     * the first result is the top suggestion.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.PersonSuggestion people_suggestions = 3;
     * </code>
     */
    public com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.PersonSuggestion
            .Builder
        addPeopleSuggestionsBuilder(int index) {
      return getPeopleSuggestionsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.PersonSuggestion
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Results of the matched people suggestions. The result list is ordered and
     * the first result is the top suggestion.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.PersonSuggestion people_suggestions = 3;
     * </code>
     */
    public java.util.List<
            com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.PersonSuggestion
                .Builder>
        getPeopleSuggestionsBuilderList() {
      return getPeopleSuggestionsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.PersonSuggestion,
            com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.PersonSuggestion
                .Builder,
            com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
                .PersonSuggestionOrBuilder>
        getPeopleSuggestionsFieldBuilder() {
      if (peopleSuggestionsBuilder_ == null) {
        peopleSuggestionsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
                    .PersonSuggestion,
                com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
                    .PersonSuggestion.Builder,
                com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
                    .PersonSuggestionOrBuilder>(
                peopleSuggestions_,
                ((bitField0_ & 0x00000004) != 0),
                getParentForChildren(),
                isClean());
        peopleSuggestions_ = null;
      }
      return peopleSuggestionsBuilder_;
    }

    private java.util.List<
            com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.ContentSuggestion>
        contentSuggestions_ = java.util.Collections.emptyList();

    private void ensureContentSuggestionsIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        contentSuggestions_ =
            new java.util.ArrayList<
                com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
                    .ContentSuggestion>(contentSuggestions_);
        bitField0_ |= 0x00000008;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.ContentSuggestion,
            com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.ContentSuggestion
                .Builder,
            com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
                .ContentSuggestionOrBuilder>
        contentSuggestionsBuilder_;

    /**
     *
     *
     * <pre>
     * Results of the matched content suggestions. The result list is ordered and
     * the first result is the top suggestion.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.ContentSuggestion content_suggestions = 4;
     * </code>
     */
    public java.util.List<
            com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.ContentSuggestion>
        getContentSuggestionsList() {
      if (contentSuggestionsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(contentSuggestions_);
      } else {
        return contentSuggestionsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Results of the matched content suggestions. The result list is ordered and
     * the first result is the top suggestion.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.ContentSuggestion content_suggestions = 4;
     * </code>
     */
    public int getContentSuggestionsCount() {
      if (contentSuggestionsBuilder_ == null) {
        return contentSuggestions_.size();
      } else {
        return contentSuggestionsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Results of the matched content suggestions. The result list is ordered and
     * the first result is the top suggestion.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.ContentSuggestion content_suggestions = 4;
     * </code>
     */
    public com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.ContentSuggestion
        getContentSuggestions(int index) {
      if (contentSuggestionsBuilder_ == null) {
        return contentSuggestions_.get(index);
      } else {
        return contentSuggestionsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Results of the matched content suggestions. The result list is ordered and
     * the first result is the top suggestion.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.ContentSuggestion content_suggestions = 4;
     * </code>
     */
    public Builder setContentSuggestions(
        int index,
        com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.ContentSuggestion
            value) {
      if (contentSuggestionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureContentSuggestionsIsMutable();
        contentSuggestions_.set(index, value);
        onChanged();
      } else {
        contentSuggestionsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Results of the matched content suggestions. The result list is ordered and
     * the first result is the top suggestion.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.ContentSuggestion content_suggestions = 4;
     * </code>
     */
    public Builder setContentSuggestions(
        int index,
        com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.ContentSuggestion
                .Builder
            builderForValue) {
      if (contentSuggestionsBuilder_ == null) {
        ensureContentSuggestionsIsMutable();
        contentSuggestions_.set(index, builderForValue.build());
        onChanged();
      } else {
        contentSuggestionsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Results of the matched content suggestions. The result list is ordered and
     * the first result is the top suggestion.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.ContentSuggestion content_suggestions = 4;
     * </code>
     */
    public Builder addContentSuggestions(
        com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.ContentSuggestion
            value) {
      if (contentSuggestionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureContentSuggestionsIsMutable();
        contentSuggestions_.add(value);
        onChanged();
      } else {
        contentSuggestionsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Results of the matched content suggestions. The result list is ordered and
     * the first result is the top suggestion.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.ContentSuggestion content_suggestions = 4;
     * </code>
     */
    public Builder addContentSuggestions(
        int index,
        com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.ContentSuggestion
            value) {
      if (contentSuggestionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureContentSuggestionsIsMutable();
        contentSuggestions_.add(index, value);
        onChanged();
      } else {
        contentSuggestionsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Results of the matched content suggestions. The result list is ordered and
     * the first result is the top suggestion.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.ContentSuggestion content_suggestions = 4;
     * </code>
     */
    public Builder addContentSuggestions(
        com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.ContentSuggestion
                .Builder
            builderForValue) {
      if (contentSuggestionsBuilder_ == null) {
        ensureContentSuggestionsIsMutable();
        contentSuggestions_.add(builderForValue.build());
        onChanged();
      } else {
        contentSuggestionsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Results of the matched content suggestions. The result list is ordered and
     * the first result is the top suggestion.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.ContentSuggestion content_suggestions = 4;
     * </code>
     */
    public Builder addContentSuggestions(
        int index,
        com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.ContentSuggestion
                .Builder
            builderForValue) {
      if (contentSuggestionsBuilder_ == null) {
        ensureContentSuggestionsIsMutable();
        contentSuggestions_.add(index, builderForValue.build());
        onChanged();
      } else {
        contentSuggestionsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Results of the matched content suggestions. The result list is ordered and
     * the first result is the top suggestion.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.ContentSuggestion content_suggestions = 4;
     * </code>
     */
    public Builder addAllContentSuggestions(
        java.lang.Iterable<
                ? extends
                    com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
                        .ContentSuggestion>
            values) {
      if (contentSuggestionsBuilder_ == null) {
        ensureContentSuggestionsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, contentSuggestions_);
        onChanged();
      } else {
        contentSuggestionsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Results of the matched content suggestions. The result list is ordered and
     * the first result is the top suggestion.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.ContentSuggestion content_suggestions = 4;
     * </code>
     */
    public Builder clearContentSuggestions() {
      if (contentSuggestionsBuilder_ == null) {
        contentSuggestions_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
      } else {
        contentSuggestionsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Results of the matched content suggestions. The result list is ordered and
     * the first result is the top suggestion.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.ContentSuggestion content_suggestions = 4;
     * </code>
     */
    public Builder removeContentSuggestions(int index) {
      if (contentSuggestionsBuilder_ == null) {
        ensureContentSuggestionsIsMutable();
        contentSuggestions_.remove(index);
        onChanged();
      } else {
        contentSuggestionsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Results of the matched content suggestions. The result list is ordered and
     * the first result is the top suggestion.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.ContentSuggestion content_suggestions = 4;
     * </code>
     */
    public com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.ContentSuggestion
            .Builder
        getContentSuggestionsBuilder(int index) {
      return getContentSuggestionsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Results of the matched content suggestions. The result list is ordered and
     * the first result is the top suggestion.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.ContentSuggestion content_suggestions = 4;
     * </code>
     */
    public com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
            .ContentSuggestionOrBuilder
        getContentSuggestionsOrBuilder(int index) {
      if (contentSuggestionsBuilder_ == null) {
        return contentSuggestions_.get(index);
      } else {
        return contentSuggestionsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Results of the matched content suggestions. The result list is ordered and
     * the first result is the top suggestion.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.ContentSuggestion content_suggestions = 4;
     * </code>
     */
    public java.util.List<
            ? extends
                com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
                    .ContentSuggestionOrBuilder>
        getContentSuggestionsOrBuilderList() {
      if (contentSuggestionsBuilder_ != null) {
        return contentSuggestionsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(contentSuggestions_);
      }
    }
    /**
     *
     *
     * <pre>
     * Results of the matched content suggestions. The result list is ordered and
     * the first result is the top suggestion.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.ContentSuggestion content_suggestions = 4;
     * </code>
     */
    public com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.ContentSuggestion
            .Builder
        addContentSuggestionsBuilder() {
      return getContentSuggestionsFieldBuilder()
          .addBuilder(
              com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
                  .ContentSuggestion.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Results of the matched content suggestions. The result list is ordered and
     * the first result is the top suggestion.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.ContentSuggestion content_suggestions = 4;
     * </code>
     */
    public com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.ContentSuggestion
            .Builder
        addContentSuggestionsBuilder(int index) {
      return getContentSuggestionsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
                  .ContentSuggestion.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Results of the matched content suggestions. The result list is ordered and
     * the first result is the top suggestion.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.ContentSuggestion content_suggestions = 4;
     * </code>
     */
    public java.util.List<
            com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.ContentSuggestion
                .Builder>
        getContentSuggestionsBuilderList() {
      return getContentSuggestionsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.ContentSuggestion,
            com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.ContentSuggestion
                .Builder,
            com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
                .ContentSuggestionOrBuilder>
        getContentSuggestionsFieldBuilder() {
      if (contentSuggestionsBuilder_ == null) {
        contentSuggestionsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
                    .ContentSuggestion,
                com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
                    .ContentSuggestion.Builder,
                com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
                    .ContentSuggestionOrBuilder>(
                contentSuggestions_,
                ((bitField0_ & 0x00000008) != 0),
                getParentForChildren(),
                isClean());
        contentSuggestions_ = null;
      }
      return contentSuggestionsBuilder_;
    }

    private java.util.List<
            com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
                .RecentSearchSuggestion>
        recentSearchSuggestions_ = java.util.Collections.emptyList();

    private void ensureRecentSearchSuggestionsIsMutable() {
      if (!((bitField0_ & 0x00000010) != 0)) {
        recentSearchSuggestions_ =
            new java.util.ArrayList<
                com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
                    .RecentSearchSuggestion>(recentSearchSuggestions_);
        bitField0_ |= 0x00000010;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
                .RecentSearchSuggestion,
            com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
                .RecentSearchSuggestion.Builder,
            com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
                .RecentSearchSuggestionOrBuilder>
        recentSearchSuggestionsBuilder_;

    /**
     *
     *
     * <pre>
     * Results of the matched "recent search" suggestions. The result list is
     * ordered and the first result is the top suggestion.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.RecentSearchSuggestion recent_search_suggestions = 5;
     * </code>
     */
    public java.util.List<
            com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
                .RecentSearchSuggestion>
        getRecentSearchSuggestionsList() {
      if (recentSearchSuggestionsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(recentSearchSuggestions_);
      } else {
        return recentSearchSuggestionsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Results of the matched "recent search" suggestions. The result list is
     * ordered and the first result is the top suggestion.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.RecentSearchSuggestion recent_search_suggestions = 5;
     * </code>
     */
    public int getRecentSearchSuggestionsCount() {
      if (recentSearchSuggestionsBuilder_ == null) {
        return recentSearchSuggestions_.size();
      } else {
        return recentSearchSuggestionsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Results of the matched "recent search" suggestions. The result list is
     * ordered and the first result is the top suggestion.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.RecentSearchSuggestion recent_search_suggestions = 5;
     * </code>
     */
    public com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
            .RecentSearchSuggestion
        getRecentSearchSuggestions(int index) {
      if (recentSearchSuggestionsBuilder_ == null) {
        return recentSearchSuggestions_.get(index);
      } else {
        return recentSearchSuggestionsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Results of the matched "recent search" suggestions. The result list is
     * ordered and the first result is the top suggestion.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.RecentSearchSuggestion recent_search_suggestions = 5;
     * </code>
     */
    public Builder setRecentSearchSuggestions(
        int index,
        com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.RecentSearchSuggestion
            value) {
      if (recentSearchSuggestionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRecentSearchSuggestionsIsMutable();
        recentSearchSuggestions_.set(index, value);
        onChanged();
      } else {
        recentSearchSuggestionsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Results of the matched "recent search" suggestions. The result list is
     * ordered and the first result is the top suggestion.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.RecentSearchSuggestion recent_search_suggestions = 5;
     * </code>
     */
    public Builder setRecentSearchSuggestions(
        int index,
        com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.RecentSearchSuggestion
                .Builder
            builderForValue) {
      if (recentSearchSuggestionsBuilder_ == null) {
        ensureRecentSearchSuggestionsIsMutable();
        recentSearchSuggestions_.set(index, builderForValue.build());
        onChanged();
      } else {
        recentSearchSuggestionsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Results of the matched "recent search" suggestions. The result list is
     * ordered and the first result is the top suggestion.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.RecentSearchSuggestion recent_search_suggestions = 5;
     * </code>
     */
    public Builder addRecentSearchSuggestions(
        com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.RecentSearchSuggestion
            value) {
      if (recentSearchSuggestionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRecentSearchSuggestionsIsMutable();
        recentSearchSuggestions_.add(value);
        onChanged();
      } else {
        recentSearchSuggestionsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Results of the matched "recent search" suggestions. The result list is
     * ordered and the first result is the top suggestion.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.RecentSearchSuggestion recent_search_suggestions = 5;
     * </code>
     */
    public Builder addRecentSearchSuggestions(
        int index,
        com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.RecentSearchSuggestion
            value) {
      if (recentSearchSuggestionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRecentSearchSuggestionsIsMutable();
        recentSearchSuggestions_.add(index, value);
        onChanged();
      } else {
        recentSearchSuggestionsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Results of the matched "recent search" suggestions. The result list is
     * ordered and the first result is the top suggestion.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.RecentSearchSuggestion recent_search_suggestions = 5;
     * </code>
     */
    public Builder addRecentSearchSuggestions(
        com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.RecentSearchSuggestion
                .Builder
            builderForValue) {
      if (recentSearchSuggestionsBuilder_ == null) {
        ensureRecentSearchSuggestionsIsMutable();
        recentSearchSuggestions_.add(builderForValue.build());
        onChanged();
      } else {
        recentSearchSuggestionsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Results of the matched "recent search" suggestions. The result list is
     * ordered and the first result is the top suggestion.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.RecentSearchSuggestion recent_search_suggestions = 5;
     * </code>
     */
    public Builder addRecentSearchSuggestions(
        int index,
        com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.RecentSearchSuggestion
                .Builder
            builderForValue) {
      if (recentSearchSuggestionsBuilder_ == null) {
        ensureRecentSearchSuggestionsIsMutable();
        recentSearchSuggestions_.add(index, builderForValue.build());
        onChanged();
      } else {
        recentSearchSuggestionsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Results of the matched "recent search" suggestions. The result list is
     * ordered and the first result is the top suggestion.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.RecentSearchSuggestion recent_search_suggestions = 5;
     * </code>
     */
    public Builder addAllRecentSearchSuggestions(
        java.lang.Iterable<
                ? extends
                    com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
                        .RecentSearchSuggestion>
            values) {
      if (recentSearchSuggestionsBuilder_ == null) {
        ensureRecentSearchSuggestionsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, recentSearchSuggestions_);
        onChanged();
      } else {
        recentSearchSuggestionsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Results of the matched "recent search" suggestions. The result list is
     * ordered and the first result is the top suggestion.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.RecentSearchSuggestion recent_search_suggestions = 5;
     * </code>
     */
    public Builder clearRecentSearchSuggestions() {
      if (recentSearchSuggestionsBuilder_ == null) {
        recentSearchSuggestions_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
      } else {
        recentSearchSuggestionsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Results of the matched "recent search" suggestions. The result list is
     * ordered and the first result is the top suggestion.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.RecentSearchSuggestion recent_search_suggestions = 5;
     * </code>
     */
    public Builder removeRecentSearchSuggestions(int index) {
      if (recentSearchSuggestionsBuilder_ == null) {
        ensureRecentSearchSuggestionsIsMutable();
        recentSearchSuggestions_.remove(index);
        onChanged();
      } else {
        recentSearchSuggestionsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Results of the matched "recent search" suggestions. The result list is
     * ordered and the first result is the top suggestion.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.RecentSearchSuggestion recent_search_suggestions = 5;
     * </code>
     */
    public com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
            .RecentSearchSuggestion.Builder
        getRecentSearchSuggestionsBuilder(int index) {
      return getRecentSearchSuggestionsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Results of the matched "recent search" suggestions. The result list is
     * ordered and the first result is the top suggestion.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.RecentSearchSuggestion recent_search_suggestions = 5;
     * </code>
     */
    public com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
            .RecentSearchSuggestionOrBuilder
        getRecentSearchSuggestionsOrBuilder(int index) {
      if (recentSearchSuggestionsBuilder_ == null) {
        return recentSearchSuggestions_.get(index);
      } else {
        return recentSearchSuggestionsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Results of the matched "recent search" suggestions. The result list is
     * ordered and the first result is the top suggestion.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.RecentSearchSuggestion recent_search_suggestions = 5;
     * </code>
     */
    public java.util.List<
            ? extends
                com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
                    .RecentSearchSuggestionOrBuilder>
        getRecentSearchSuggestionsOrBuilderList() {
      if (recentSearchSuggestionsBuilder_ != null) {
        return recentSearchSuggestionsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(recentSearchSuggestions_);
      }
    }
    /**
     *
     *
     * <pre>
     * Results of the matched "recent search" suggestions. The result list is
     * ordered and the first result is the top suggestion.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.RecentSearchSuggestion recent_search_suggestions = 5;
     * </code>
     */
    public com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
            .RecentSearchSuggestion.Builder
        addRecentSearchSuggestionsBuilder() {
      return getRecentSearchSuggestionsFieldBuilder()
          .addBuilder(
              com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
                  .RecentSearchSuggestion.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Results of the matched "recent search" suggestions. The result list is
     * ordered and the first result is the top suggestion.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.RecentSearchSuggestion recent_search_suggestions = 5;
     * </code>
     */
    public com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
            .RecentSearchSuggestion.Builder
        addRecentSearchSuggestionsBuilder(int index) {
      return getRecentSearchSuggestionsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
                  .RecentSearchSuggestion.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Results of the matched "recent search" suggestions. The result list is
     * ordered and the first result is the top suggestion.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.RecentSearchSuggestion recent_search_suggestions = 5;
     * </code>
     */
    public java.util.List<
            com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
                .RecentSearchSuggestion.Builder>
        getRecentSearchSuggestionsBuilderList() {
      return getRecentSearchSuggestionsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
                .RecentSearchSuggestion,
            com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
                .RecentSearchSuggestion.Builder,
            com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
                .RecentSearchSuggestionOrBuilder>
        getRecentSearchSuggestionsFieldBuilder() {
      if (recentSearchSuggestionsBuilder_ == null) {
        recentSearchSuggestionsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
                    .RecentSearchSuggestion,
                com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
                    .RecentSearchSuggestion.Builder,
                com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
                    .RecentSearchSuggestionOrBuilder>(
                recentSearchSuggestions_,
                ((bitField0_ & 0x00000010) != 0),
                getParentForChildren(),
                isClean());
        recentSearchSuggestions_ = null;
      }
      return recentSearchSuggestionsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse)
  private static final com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse();
  }

  public static com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<AdvancedCompleteQueryResponse> PARSER =
      new com.google.protobuf.AbstractParser<AdvancedCompleteQueryResponse>() {
        @java.lang.Override
        public AdvancedCompleteQueryResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<AdvancedCompleteQueryResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<AdvancedCompleteQueryResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
