/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/discoveryengine/v1beta/conversational_search_service.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.discoveryengine.v1beta;

/**
 *
 *
 * <pre>
 * Request message for
 * [ConversationalSearchService.AnswerQuery][google.cloud.discoveryengine.v1beta.ConversationalSearchService.AnswerQuery]
 * method.
 * </pre>
 *
 * Protobuf type {@code google.cloud.discoveryengine.v1beta.AnswerQueryRequest}
 */
public final class AnswerQueryRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.AnswerQueryRequest)
    AnswerQueryRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use AnswerQueryRequest.newBuilder() to construct.
  private AnswerQueryRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private AnswerQueryRequest() {
    servingConfig_ = "";
    session_ = "";
    userPseudoId_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new AnswerQueryRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.discoveryengine.v1beta.ConversationalSearchServiceProto
        .internal_static_google_cloud_discoveryengine_v1beta_AnswerQueryRequest_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 13:
        return internalGetUserLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.discoveryengine.v1beta.ConversationalSearchServiceProto
        .internal_static_google_cloud_discoveryengine_v1beta_AnswerQueryRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.class,
            com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.Builder.class);
  }

  public interface SafetySpecOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SafetySpec)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Enable the safety filtering on the answer response. It is false by
     * default.
     * </pre>
     *
     * <code>bool enable = 1;</code>
     *
     * @return The enable.
     */
    boolean getEnable();
  }
  /**
   *
   *
   * <pre>
   * Safety specification.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SafetySpec}
   */
  public static final class SafetySpec extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SafetySpec)
      SafetySpecOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use SafetySpec.newBuilder() to construct.
    private SafetySpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private SafetySpec() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new SafetySpec();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1beta.ConversationalSearchServiceProto
          .internal_static_google_cloud_discoveryengine_v1beta_AnswerQueryRequest_SafetySpec_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1beta.ConversationalSearchServiceProto
          .internal_static_google_cloud_discoveryengine_v1beta_AnswerQueryRequest_SafetySpec_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SafetySpec.class,
              com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SafetySpec.Builder.class);
    }

    public static final int ENABLE_FIELD_NUMBER = 1;
    private boolean enable_ = false;
    /**
     *
     *
     * <pre>
     * Enable the safety filtering on the answer response. It is false by
     * default.
     * </pre>
     *
     * <code>bool enable = 1;</code>
     *
     * @return The enable.
     */
    @java.lang.Override
    public boolean getEnable() {
      return enable_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (enable_ != false) {
        output.writeBool(1, enable_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (enable_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(1, enable_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SafetySpec)) {
        return super.equals(obj);
      }
      com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SafetySpec other =
          (com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SafetySpec) obj;

      if (getEnable() != other.getEnable()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ENABLE_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnable());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SafetySpec parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SafetySpec parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SafetySpec parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SafetySpec parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SafetySpec parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SafetySpec parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SafetySpec parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SafetySpec parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SafetySpec
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SafetySpec
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SafetySpec parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SafetySpec parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SafetySpec prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Safety specification.
     * </pre>
     *
     * Protobuf type {@code google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SafetySpec}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SafetySpec)
        com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SafetySpecOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1beta.ConversationalSearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_AnswerQueryRequest_SafetySpec_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1beta.ConversationalSearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_AnswerQueryRequest_SafetySpec_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SafetySpec.class,
                com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SafetySpec.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SafetySpec.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        enable_ = false;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.discoveryengine.v1beta.ConversationalSearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_AnswerQueryRequest_SafetySpec_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SafetySpec
          getDefaultInstanceForType() {
        return com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SafetySpec
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SafetySpec build() {
        com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SafetySpec result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SafetySpec buildPartial() {
        com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SafetySpec result =
            new com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SafetySpec(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SafetySpec result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.enable_ = enable_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SafetySpec) {
          return mergeFrom(
              (com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SafetySpec) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SafetySpec other) {
        if (other
            == com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SafetySpec
                .getDefaultInstance()) return this;
        if (other.getEnable() != false) {
          setEnable(other.getEnable());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  enable_ = input.readBool();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private boolean enable_;
      /**
       *
       *
       * <pre>
       * Enable the safety filtering on the answer response. It is false by
       * default.
       * </pre>
       *
       * <code>bool enable = 1;</code>
       *
       * @return The enable.
       */
      @java.lang.Override
      public boolean getEnable() {
        return enable_;
      }
      /**
       *
       *
       * <pre>
       * Enable the safety filtering on the answer response. It is false by
       * default.
       * </pre>
       *
       * <code>bool enable = 1;</code>
       *
       * @param value The enable to set.
       * @return This builder for chaining.
       */
      public Builder setEnable(boolean value) {

        enable_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Enable the safety filtering on the answer response. It is false by
       * default.
       * </pre>
       *
       * <code>bool enable = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearEnable() {
        bitField0_ = (bitField0_ & ~0x00000001);
        enable_ = false;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SafetySpec)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SafetySpec)
    private static final com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SafetySpec
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SafetySpec();
    }

    public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SafetySpec
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<SafetySpec> PARSER =
        new com.google.protobuf.AbstractParser<SafetySpec>() {
          @java.lang.Override
          public SafetySpec parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<SafetySpec> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<SafetySpec> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SafetySpec
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface RelatedQuestionsSpecOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1beta.AnswerQueryRequest.RelatedQuestionsSpec)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Enable related questions feature if true.
     * </pre>
     *
     * <code>bool enable = 1;</code>
     *
     * @return The enable.
     */
    boolean getEnable();
  }
  /**
   *
   *
   * <pre>
   * Related questions specification.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.discoveryengine.v1beta.AnswerQueryRequest.RelatedQuestionsSpec}
   */
  public static final class RelatedQuestionsSpec extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.AnswerQueryRequest.RelatedQuestionsSpec)
      RelatedQuestionsSpecOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use RelatedQuestionsSpec.newBuilder() to construct.
    private RelatedQuestionsSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private RelatedQuestionsSpec() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new RelatedQuestionsSpec();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1beta.ConversationalSearchServiceProto
          .internal_static_google_cloud_discoveryengine_v1beta_AnswerQueryRequest_RelatedQuestionsSpec_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1beta.ConversationalSearchServiceProto
          .internal_static_google_cloud_discoveryengine_v1beta_AnswerQueryRequest_RelatedQuestionsSpec_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.RelatedQuestionsSpec.class,
              com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.RelatedQuestionsSpec
                  .Builder.class);
    }

    public static final int ENABLE_FIELD_NUMBER = 1;
    private boolean enable_ = false;
    /**
     *
     *
     * <pre>
     * Enable related questions feature if true.
     * </pre>
     *
     * <code>bool enable = 1;</code>
     *
     * @return The enable.
     */
    @java.lang.Override
    public boolean getEnable() {
      return enable_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (enable_ != false) {
        output.writeBool(1, enable_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (enable_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(1, enable_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.RelatedQuestionsSpec)) {
        return super.equals(obj);
      }
      com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.RelatedQuestionsSpec other =
          (com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.RelatedQuestionsSpec) obj;

      if (getEnable() != other.getEnable()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ENABLE_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnable());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.RelatedQuestionsSpec
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.RelatedQuestionsSpec
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.RelatedQuestionsSpec
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.RelatedQuestionsSpec
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.RelatedQuestionsSpec
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.RelatedQuestionsSpec
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.RelatedQuestionsSpec
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.RelatedQuestionsSpec
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.RelatedQuestionsSpec
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.RelatedQuestionsSpec
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.RelatedQuestionsSpec
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.RelatedQuestionsSpec
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.RelatedQuestionsSpec prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Related questions specification.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.discoveryengine.v1beta.AnswerQueryRequest.RelatedQuestionsSpec}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.AnswerQueryRequest.RelatedQuestionsSpec)
        com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.RelatedQuestionsSpecOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1beta.ConversationalSearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_AnswerQueryRequest_RelatedQuestionsSpec_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1beta.ConversationalSearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_AnswerQueryRequest_RelatedQuestionsSpec_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.RelatedQuestionsSpec
                    .class,
                com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.RelatedQuestionsSpec
                    .Builder.class);
      }

      // Construct using
      // com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.RelatedQuestionsSpec.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        enable_ = false;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.discoveryengine.v1beta.ConversationalSearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_AnswerQueryRequest_RelatedQuestionsSpec_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.RelatedQuestionsSpec
          getDefaultInstanceForType() {
        return com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.RelatedQuestionsSpec
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.RelatedQuestionsSpec
          build() {
        com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.RelatedQuestionsSpec result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.RelatedQuestionsSpec
          buildPartial() {
        com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.RelatedQuestionsSpec result =
            new com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.RelatedQuestionsSpec(
                this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.RelatedQuestionsSpec result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.enable_ = enable_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.RelatedQuestionsSpec) {
          return mergeFrom(
              (com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.RelatedQuestionsSpec)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.RelatedQuestionsSpec other) {
        if (other
            == com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.RelatedQuestionsSpec
                .getDefaultInstance()) return this;
        if (other.getEnable() != false) {
          setEnable(other.getEnable());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  enable_ = input.readBool();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private boolean enable_;
      /**
       *
       *
       * <pre>
       * Enable related questions feature if true.
       * </pre>
       *
       * <code>bool enable = 1;</code>
       *
       * @return The enable.
       */
      @java.lang.Override
      public boolean getEnable() {
        return enable_;
      }
      /**
       *
       *
       * <pre>
       * Enable related questions feature if true.
       * </pre>
       *
       * <code>bool enable = 1;</code>
       *
       * @param value The enable to set.
       * @return This builder for chaining.
       */
      public Builder setEnable(boolean value) {

        enable_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Enable related questions feature if true.
       * </pre>
       *
       * <code>bool enable = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearEnable() {
        bitField0_ = (bitField0_ & ~0x00000001);
        enable_ = false;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.AnswerQueryRequest.RelatedQuestionsSpec)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.AnswerQueryRequest.RelatedQuestionsSpec)
    private static final com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest
            .RelatedQuestionsSpec
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.RelatedQuestionsSpec();
    }

    public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.RelatedQuestionsSpec
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<RelatedQuestionsSpec> PARSER =
        new com.google.protobuf.AbstractParser<RelatedQuestionsSpec>() {
          @java.lang.Override
          public RelatedQuestionsSpec parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<RelatedQuestionsSpec> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<RelatedQuestionsSpec> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.RelatedQuestionsSpec
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface GroundingSpecOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1beta.AnswerQueryRequest.GroundingSpec)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Optional. Specifies whether to include grounding_supports in the answer.
     * The default value is `false`.
     *
     * When this field is set to `true`, returned answer will have
     * `grounding_score` and will contain GroundingSupports for each claim.
     * </pre>
     *
     * <code>bool include_grounding_supports = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The includeGroundingSupports.
     */
    boolean getIncludeGroundingSupports();

    /**
     *
     *
     * <pre>
     * Optional. Specifies whether to enable the filtering based on grounding
     * score and at what level.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.GroundingSpec.FilteringLevel filtering_level = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enum numeric value on the wire for filteringLevel.
     */
    int getFilteringLevelValue();
    /**
     *
     *
     * <pre>
     * Optional. Specifies whether to enable the filtering based on grounding
     * score and at what level.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.GroundingSpec.FilteringLevel filtering_level = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The filteringLevel.
     */
    com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.GroundingSpec.FilteringLevel
        getFilteringLevel();
  }
  /**
   *
   *
   * <pre>
   * Grounding specification.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1beta.AnswerQueryRequest.GroundingSpec}
   */
  public static final class GroundingSpec extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.AnswerQueryRequest.GroundingSpec)
      GroundingSpecOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use GroundingSpec.newBuilder() to construct.
    private GroundingSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private GroundingSpec() {
      filteringLevel_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new GroundingSpec();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1beta.ConversationalSearchServiceProto
          .internal_static_google_cloud_discoveryengine_v1beta_AnswerQueryRequest_GroundingSpec_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1beta.ConversationalSearchServiceProto
          .internal_static_google_cloud_discoveryengine_v1beta_AnswerQueryRequest_GroundingSpec_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.GroundingSpec.class,
              com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.GroundingSpec.Builder
                  .class);
    }

    /**
     *
     *
     * <pre>
     * Level to filter based on answer grounding.
     * </pre>
     *
     * Protobuf enum {@code
     * google.cloud.discoveryengine.v1beta.AnswerQueryRequest.GroundingSpec.FilteringLevel}
     */
    public enum FilteringLevel implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Default is no filter
       * </pre>
       *
       * <code>FILTERING_LEVEL_UNSPECIFIED = 0;</code>
       */
      FILTERING_LEVEL_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * Filter answers based on a low threshold.
       * </pre>
       *
       * <code>FILTERING_LEVEL_LOW = 1;</code>
       */
      FILTERING_LEVEL_LOW(1),
      /**
       *
       *
       * <pre>
       * Filter answers based on a high threshold.
       * </pre>
       *
       * <code>FILTERING_LEVEL_HIGH = 2;</code>
       */
      FILTERING_LEVEL_HIGH(2),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Default is no filter
       * </pre>
       *
       * <code>FILTERING_LEVEL_UNSPECIFIED = 0;</code>
       */
      public static final int FILTERING_LEVEL_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * Filter answers based on a low threshold.
       * </pre>
       *
       * <code>FILTERING_LEVEL_LOW = 1;</code>
       */
      public static final int FILTERING_LEVEL_LOW_VALUE = 1;
      /**
       *
       *
       * <pre>
       * Filter answers based on a high threshold.
       * </pre>
       *
       * <code>FILTERING_LEVEL_HIGH = 2;</code>
       */
      public static final int FILTERING_LEVEL_HIGH_VALUE = 2;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static FilteringLevel valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static FilteringLevel forNumber(int value) {
        switch (value) {
          case 0:
            return FILTERING_LEVEL_UNSPECIFIED;
          case 1:
            return FILTERING_LEVEL_LOW;
          case 2:
            return FILTERING_LEVEL_HIGH;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<FilteringLevel> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<FilteringLevel>
          internalValueMap =
              new com.google.protobuf.Internal.EnumLiteMap<FilteringLevel>() {
                public FilteringLevel findValueByNumber(int number) {
                  return FilteringLevel.forNumber(number);
                }
              };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.GroundingSpec
            .getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final FilteringLevel[] VALUES = values();

      public static FilteringLevel valueOf(
          com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private FilteringLevel(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.cloud.discoveryengine.v1beta.AnswerQueryRequest.GroundingSpec.FilteringLevel)
    }

    public static final int INCLUDE_GROUNDING_SUPPORTS_FIELD_NUMBER = 2;
    private boolean includeGroundingSupports_ = false;
    /**
     *
     *
     * <pre>
     * Optional. Specifies whether to include grounding_supports in the answer.
     * The default value is `false`.
     *
     * When this field is set to `true`, returned answer will have
     * `grounding_score` and will contain GroundingSupports for each claim.
     * </pre>
     *
     * <code>bool include_grounding_supports = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The includeGroundingSupports.
     */
    @java.lang.Override
    public boolean getIncludeGroundingSupports() {
      return includeGroundingSupports_;
    }

    public static final int FILTERING_LEVEL_FIELD_NUMBER = 3;
    private int filteringLevel_ = 0;
    /**
     *
     *
     * <pre>
     * Optional. Specifies whether to enable the filtering based on grounding
     * score and at what level.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.GroundingSpec.FilteringLevel filtering_level = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enum numeric value on the wire for filteringLevel.
     */
    @java.lang.Override
    public int getFilteringLevelValue() {
      return filteringLevel_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specifies whether to enable the filtering based on grounding
     * score and at what level.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.GroundingSpec.FilteringLevel filtering_level = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The filteringLevel.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.GroundingSpec.FilteringLevel
        getFilteringLevel() {
      com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.GroundingSpec.FilteringLevel
          result =
              com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.GroundingSpec
                  .FilteringLevel.forNumber(filteringLevel_);
      return result == null
          ? com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.GroundingSpec.FilteringLevel
              .UNRECOGNIZED
          : result;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (includeGroundingSupports_ != false) {
        output.writeBool(2, includeGroundingSupports_);
      }
      if (filteringLevel_
          != com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.GroundingSpec.FilteringLevel
              .FILTERING_LEVEL_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(3, filteringLevel_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (includeGroundingSupports_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(2, includeGroundingSupports_);
      }
      if (filteringLevel_
          != com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.GroundingSpec.FilteringLevel
              .FILTERING_LEVEL_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, filteringLevel_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.GroundingSpec)) {
        return super.equals(obj);
      }
      com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.GroundingSpec other =
          (com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.GroundingSpec) obj;

      if (getIncludeGroundingSupports() != other.getIncludeGroundingSupports()) return false;
      if (filteringLevel_ != other.filteringLevel_) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + INCLUDE_GROUNDING_SUPPORTS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getIncludeGroundingSupports());
      hash = (37 * hash) + FILTERING_LEVEL_FIELD_NUMBER;
      hash = (53 * hash) + filteringLevel_;
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.GroundingSpec
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.GroundingSpec
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.GroundingSpec
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.GroundingSpec
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.GroundingSpec
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.GroundingSpec
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.GroundingSpec
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.GroundingSpec
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.GroundingSpec
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.GroundingSpec
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.GroundingSpec
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.GroundingSpec
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.GroundingSpec prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Grounding specification.
     * </pre>
     *
     * Protobuf type {@code google.cloud.discoveryengine.v1beta.AnswerQueryRequest.GroundingSpec}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.AnswerQueryRequest.GroundingSpec)
        com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.GroundingSpecOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1beta.ConversationalSearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_AnswerQueryRequest_GroundingSpec_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1beta.ConversationalSearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_AnswerQueryRequest_GroundingSpec_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.GroundingSpec.class,
                com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.GroundingSpec.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.GroundingSpec.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        includeGroundingSupports_ = false;
        filteringLevel_ = 0;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.discoveryengine.v1beta.ConversationalSearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_AnswerQueryRequest_GroundingSpec_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.GroundingSpec
          getDefaultInstanceForType() {
        return com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.GroundingSpec
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.GroundingSpec build() {
        com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.GroundingSpec result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.GroundingSpec
          buildPartial() {
        com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.GroundingSpec result =
            new com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.GroundingSpec(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.GroundingSpec result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.includeGroundingSupports_ = includeGroundingSupports_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.filteringLevel_ = filteringLevel_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.GroundingSpec) {
          return mergeFrom(
              (com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.GroundingSpec) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.GroundingSpec other) {
        if (other
            == com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.GroundingSpec
                .getDefaultInstance()) return this;
        if (other.getIncludeGroundingSupports() != false) {
          setIncludeGroundingSupports(other.getIncludeGroundingSupports());
        }
        if (other.filteringLevel_ != 0) {
          setFilteringLevelValue(other.getFilteringLevelValue());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 16:
                {
                  includeGroundingSupports_ = input.readBool();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 16
              case 24:
                {
                  filteringLevel_ = input.readEnum();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 24
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private boolean includeGroundingSupports_;
      /**
       *
       *
       * <pre>
       * Optional. Specifies whether to include grounding_supports in the answer.
       * The default value is `false`.
       *
       * When this field is set to `true`, returned answer will have
       * `grounding_score` and will contain GroundingSupports for each claim.
       * </pre>
       *
       * <code>bool include_grounding_supports = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The includeGroundingSupports.
       */
      @java.lang.Override
      public boolean getIncludeGroundingSupports() {
        return includeGroundingSupports_;
      }
      /**
       *
       *
       * <pre>
       * Optional. Specifies whether to include grounding_supports in the answer.
       * The default value is `false`.
       *
       * When this field is set to `true`, returned answer will have
       * `grounding_score` and will contain GroundingSupports for each claim.
       * </pre>
       *
       * <code>bool include_grounding_supports = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The includeGroundingSupports to set.
       * @return This builder for chaining.
       */
      public Builder setIncludeGroundingSupports(boolean value) {

        includeGroundingSupports_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Specifies whether to include grounding_supports in the answer.
       * The default value is `false`.
       *
       * When this field is set to `true`, returned answer will have
       * `grounding_score` and will contain GroundingSupports for each claim.
       * </pre>
       *
       * <code>bool include_grounding_supports = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearIncludeGroundingSupports() {
        bitField0_ = (bitField0_ & ~0x00000001);
        includeGroundingSupports_ = false;
        onChanged();
        return this;
      }

      private int filteringLevel_ = 0;
      /**
       *
       *
       * <pre>
       * Optional. Specifies whether to enable the filtering based on grounding
       * score and at what level.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.GroundingSpec.FilteringLevel filtering_level = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The enum numeric value on the wire for filteringLevel.
       */
      @java.lang.Override
      public int getFilteringLevelValue() {
        return filteringLevel_;
      }
      /**
       *
       *
       * <pre>
       * Optional. Specifies whether to enable the filtering based on grounding
       * score and at what level.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.GroundingSpec.FilteringLevel filtering_level = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param value The enum numeric value on the wire for filteringLevel to set.
       * @return This builder for chaining.
       */
      public Builder setFilteringLevelValue(int value) {
        filteringLevel_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Specifies whether to enable the filtering based on grounding
       * score and at what level.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.GroundingSpec.FilteringLevel filtering_level = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The filteringLevel.
       */
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.GroundingSpec.FilteringLevel
          getFilteringLevel() {
        com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.GroundingSpec.FilteringLevel
            result =
                com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.GroundingSpec
                    .FilteringLevel.forNumber(filteringLevel_);
        return result == null
            ? com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.GroundingSpec
                .FilteringLevel.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * Optional. Specifies whether to enable the filtering based on grounding
       * score and at what level.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.GroundingSpec.FilteringLevel filtering_level = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param value The filteringLevel to set.
       * @return This builder for chaining.
       */
      public Builder setFilteringLevel(
          com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.GroundingSpec.FilteringLevel
              value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000002;
        filteringLevel_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Specifies whether to enable the filtering based on grounding
       * score and at what level.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.GroundingSpec.FilteringLevel filtering_level = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearFilteringLevel() {
        bitField0_ = (bitField0_ & ~0x00000002);
        filteringLevel_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.AnswerQueryRequest.GroundingSpec)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.AnswerQueryRequest.GroundingSpec)
    private static final com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.GroundingSpec
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.GroundingSpec();
    }

    public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.GroundingSpec
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<GroundingSpec> PARSER =
        new com.google.protobuf.AbstractParser<GroundingSpec>() {
          @java.lang.Override
          public GroundingSpec parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<GroundingSpec> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<GroundingSpec> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.GroundingSpec
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface AnswerGenerationSpecOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Answer generation model specification.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec.ModelSpec model_spec = 1;
     * </code>
     *
     * @return Whether the modelSpec field is set.
     */
    boolean hasModelSpec();
    /**
     *
     *
     * <pre>
     * Answer generation model specification.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec.ModelSpec model_spec = 1;
     * </code>
     *
     * @return The modelSpec.
     */
    com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec.ModelSpec
        getModelSpec();
    /**
     *
     *
     * <pre>
     * Answer generation model specification.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec.ModelSpec model_spec = 1;
     * </code>
     */
    com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
            .ModelSpecOrBuilder
        getModelSpecOrBuilder();

    /**
     *
     *
     * <pre>
     * Answer generation prompt specification.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec.PromptSpec prompt_spec = 2;
     * </code>
     *
     * @return Whether the promptSpec field is set.
     */
    boolean hasPromptSpec();
    /**
     *
     *
     * <pre>
     * Answer generation prompt specification.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec.PromptSpec prompt_spec = 2;
     * </code>
     *
     * @return The promptSpec.
     */
    com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec.PromptSpec
        getPromptSpec();
    /**
     *
     *
     * <pre>
     * Answer generation prompt specification.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec.PromptSpec prompt_spec = 2;
     * </code>
     */
    com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
            .PromptSpecOrBuilder
        getPromptSpecOrBuilder();

    /**
     *
     *
     * <pre>
     * Specifies whether to include citation metadata in the answer. The default
     * value is `false`.
     * </pre>
     *
     * <code>bool include_citations = 3;</code>
     *
     * @return The includeCitations.
     */
    boolean getIncludeCitations();

    /**
     *
     *
     * <pre>
     * Language code for Answer. Use language tags defined by
     * [BCP47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt).
     * Note: This is an experimental feature.
     * </pre>
     *
     * <code>string answer_language_code = 4;</code>
     *
     * @return The answerLanguageCode.
     */
    java.lang.String getAnswerLanguageCode();
    /**
     *
     *
     * <pre>
     * Language code for Answer. Use language tags defined by
     * [BCP47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt).
     * Note: This is an experimental feature.
     * </pre>
     *
     * <code>string answer_language_code = 4;</code>
     *
     * @return The bytes for answerLanguageCode.
     */
    com.google.protobuf.ByteString getAnswerLanguageCodeBytes();

    /**
     *
     *
     * <pre>
     * Specifies whether to filter out adversarial queries. The default value
     * is `false`.
     *
     * Google employs search-query classification to detect adversarial
     * queries. No answer is returned if the search query is classified as an
     * adversarial query. For example, a user might ask a question regarding
     * negative comments about the company or submit a query designed to
     * generate unsafe, policy-violating output. If this field is set to
     * `true`, we skip generating answers for adversarial queries and return
     * fallback messages instead.
     * </pre>
     *
     * <code>bool ignore_adversarial_query = 5;</code>
     *
     * @return The ignoreAdversarialQuery.
     */
    boolean getIgnoreAdversarialQuery();

    /**
     *
     *
     * <pre>
     * Specifies whether to filter out queries that are not answer-seeking.
     * The default value is `false`.
     *
     * Google employs search-query classification to detect answer-seeking
     * queries. No answer is returned if the search query is classified as a
     * non-answer seeking query. If this field is set to `true`, we skip
     * generating answers for non-answer seeking queries and return
     * fallback messages instead.
     * </pre>
     *
     * <code>bool ignore_non_answer_seeking_query = 6;</code>
     *
     * @return The ignoreNonAnswerSeekingQuery.
     */
    boolean getIgnoreNonAnswerSeekingQuery();

    /**
     *
     *
     * <pre>
     * Specifies whether to filter out queries that have low relevance.
     *
     * If this field is set to `false`, all search results are used regardless
     * of relevance to generate answers. If set to `true` or unset, the behavior
     * will be determined automatically by the service.
     * </pre>
     *
     * <code>optional bool ignore_low_relevant_content = 7;</code>
     *
     * @return Whether the ignoreLowRelevantContent field is set.
     */
    boolean hasIgnoreLowRelevantContent();
    /**
     *
     *
     * <pre>
     * Specifies whether to filter out queries that have low relevance.
     *
     * If this field is set to `false`, all search results are used regardless
     * of relevance to generate answers. If set to `true` or unset, the behavior
     * will be determined automatically by the service.
     * </pre>
     *
     * <code>optional bool ignore_low_relevant_content = 7;</code>
     *
     * @return The ignoreLowRelevantContent.
     */
    boolean getIgnoreLowRelevantContent();

    /**
     *
     *
     * <pre>
     * Optional. Specifies whether to filter out jail-breaking queries. The
     * default value is `false`.
     *
     * Google employs search-query classification to detect jail-breaking
     * queries. No summary is returned if the search query is classified as a
     * jail-breaking query. A user might add instructions to the query to
     * change the tone, style, language, content of the answer, or ask the
     * model to act as a different entity, e.g. "Reply in the tone of a
     * competing company's CEO". If this field is set to `true`, we skip
     * generating summaries for jail-breaking queries and return fallback
     * messages instead.
     * </pre>
     *
     * <code>bool ignore_jail_breaking_query = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The ignoreJailBreakingQuery.
     */
    boolean getIgnoreJailBreakingQuery();
  }
  /**
   *
   *
   * <pre>
   * Answer generation specification.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec}
   */
  public static final class AnswerGenerationSpec extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec)
      AnswerGenerationSpecOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use AnswerGenerationSpec.newBuilder() to construct.
    private AnswerGenerationSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private AnswerGenerationSpec() {
      answerLanguageCode_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new AnswerGenerationSpec();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1beta.ConversationalSearchServiceProto
          .internal_static_google_cloud_discoveryengine_v1beta_AnswerQueryRequest_AnswerGenerationSpec_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1beta.ConversationalSearchServiceProto
          .internal_static_google_cloud_discoveryengine_v1beta_AnswerQueryRequest_AnswerGenerationSpec_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec.class,
              com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
                  .Builder.class);
    }

    public interface ModelSpecOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec.ModelSpec)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Model version. If not set, it will use the default stable model.
       * Allowed values are: stable, preview.
       * </pre>
       *
       * <code>string model_version = 1;</code>
       *
       * @return The modelVersion.
       */
      java.lang.String getModelVersion();
      /**
       *
       *
       * <pre>
       * Model version. If not set, it will use the default stable model.
       * Allowed values are: stable, preview.
       * </pre>
       *
       * <code>string model_version = 1;</code>
       *
       * @return The bytes for modelVersion.
       */
      com.google.protobuf.ByteString getModelVersionBytes();
    }
    /**
     *
     *
     * <pre>
     * Answer Generation Model specification.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec.ModelSpec}
     */
    public static final class ModelSpec extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec.ModelSpec)
        ModelSpecOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use ModelSpec.newBuilder() to construct.
      private ModelSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private ModelSpec() {
        modelVersion_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new ModelSpec();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1beta.ConversationalSearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_AnswerQueryRequest_AnswerGenerationSpec_ModelSpec_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1beta.ConversationalSearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_AnswerQueryRequest_AnswerGenerationSpec_ModelSpec_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
                    .ModelSpec.class,
                com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
                    .ModelSpec.Builder.class);
      }

      public static final int MODEL_VERSION_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private volatile java.lang.Object modelVersion_ = "";
      /**
       *
       *
       * <pre>
       * Model version. If not set, it will use the default stable model.
       * Allowed values are: stable, preview.
       * </pre>
       *
       * <code>string model_version = 1;</code>
       *
       * @return The modelVersion.
       */
      @java.lang.Override
      public java.lang.String getModelVersion() {
        java.lang.Object ref = modelVersion_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          modelVersion_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Model version. If not set, it will use the default stable model.
       * Allowed values are: stable, preview.
       * </pre>
       *
       * <code>string model_version = 1;</code>
       *
       * @return The bytes for modelVersion.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getModelVersionBytes() {
        java.lang.Object ref = modelVersion_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          modelVersion_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(modelVersion_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, modelVersion_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(modelVersion_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, modelVersion_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
                .ModelSpec)) {
          return super.equals(obj);
        }
        com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec.ModelSpec
            other =
                (com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
                        .ModelSpec)
                    obj;

        if (!getModelVersion().equals(other.getModelVersion())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + MODEL_VERSION_FIELD_NUMBER;
        hash = (53 * hash) + getModelVersion().hashCode();
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
              .ModelSpec
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
              .ModelSpec
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
              .ModelSpec
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
              .ModelSpec
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
              .ModelSpec
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
              .ModelSpec
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
              .ModelSpec
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
              .ModelSpec
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
              .ModelSpec
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
              .ModelSpec
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
              .ModelSpec
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
              .ModelSpec
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec.ModelSpec
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Answer Generation Model specification.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec.ModelSpec}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec.ModelSpec)
          com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
              .ModelSpecOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.discoveryengine.v1beta.ConversationalSearchServiceProto
              .internal_static_google_cloud_discoveryengine_v1beta_AnswerQueryRequest_AnswerGenerationSpec_ModelSpec_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.discoveryengine.v1beta.ConversationalSearchServiceProto
              .internal_static_google_cloud_discoveryengine_v1beta_AnswerQueryRequest_AnswerGenerationSpec_ModelSpec_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
                      .ModelSpec.class,
                  com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
                      .ModelSpec.Builder.class);
        }

        // Construct using
        // com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec.ModelSpec.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          modelVersion_ = "";
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.discoveryengine.v1beta.ConversationalSearchServiceProto
              .internal_static_google_cloud_discoveryengine_v1beta_AnswerQueryRequest_AnswerGenerationSpec_ModelSpec_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
                .ModelSpec
            getDefaultInstanceForType() {
          return com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
              .ModelSpec.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
                .ModelSpec
            build() {
          com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec.ModelSpec
              result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
                .ModelSpec
            buildPartial() {
          com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec.ModelSpec
              result =
                  new com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest
                      .AnswerGenerationSpec.ModelSpec(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
                    .ModelSpec
                result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.modelVersion_ = modelVersion_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
                  .ModelSpec) {
            return mergeFrom(
                (com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
                        .ModelSpec)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
                    .ModelSpec
                other) {
          if (other
              == com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
                  .ModelSpec.getDefaultInstance()) return this;
          if (!other.getModelVersion().isEmpty()) {
            modelVersion_ = other.modelVersion_;
            bitField0_ |= 0x00000001;
            onChanged();
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    modelVersion_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.lang.Object modelVersion_ = "";
        /**
         *
         *
         * <pre>
         * Model version. If not set, it will use the default stable model.
         * Allowed values are: stable, preview.
         * </pre>
         *
         * <code>string model_version = 1;</code>
         *
         * @return The modelVersion.
         */
        public java.lang.String getModelVersion() {
          java.lang.Object ref = modelVersion_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            modelVersion_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Model version. If not set, it will use the default stable model.
         * Allowed values are: stable, preview.
         * </pre>
         *
         * <code>string model_version = 1;</code>
         *
         * @return The bytes for modelVersion.
         */
        public com.google.protobuf.ByteString getModelVersionBytes() {
          java.lang.Object ref = modelVersion_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            modelVersion_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Model version. If not set, it will use the default stable model.
         * Allowed values are: stable, preview.
         * </pre>
         *
         * <code>string model_version = 1;</code>
         *
         * @param value The modelVersion to set.
         * @return This builder for chaining.
         */
        public Builder setModelVersion(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          modelVersion_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Model version. If not set, it will use the default stable model.
         * Allowed values are: stable, preview.
         * </pre>
         *
         * <code>string model_version = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearModelVersion() {
          modelVersion_ = getDefaultInstance().getModelVersion();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Model version. If not set, it will use the default stable model.
         * Allowed values are: stable, preview.
         * </pre>
         *
         * <code>string model_version = 1;</code>
         *
         * @param value The bytes for modelVersion to set.
         * @return This builder for chaining.
         */
        public Builder setModelVersionBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          modelVersion_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec.ModelSpec)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec.ModelSpec)
      private static final com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest
              .AnswerGenerationSpec.ModelSpec
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
                .ModelSpec();
      }

      public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
              .ModelSpec
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<ModelSpec> PARSER =
          new com.google.protobuf.AbstractParser<ModelSpec>() {
            @java.lang.Override
            public ModelSpec parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<ModelSpec> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<ModelSpec> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
              .ModelSpec
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface PromptSpecOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec.PromptSpec)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Customized preamble.
       * </pre>
       *
       * <code>string preamble = 1;</code>
       *
       * @return The preamble.
       */
      java.lang.String getPreamble();
      /**
       *
       *
       * <pre>
       * Customized preamble.
       * </pre>
       *
       * <code>string preamble = 1;</code>
       *
       * @return The bytes for preamble.
       */
      com.google.protobuf.ByteString getPreambleBytes();
    }
    /**
     *
     *
     * <pre>
     * Answer generation prompt specification.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec.PromptSpec}
     */
    public static final class PromptSpec extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec.PromptSpec)
        PromptSpecOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use PromptSpec.newBuilder() to construct.
      private PromptSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private PromptSpec() {
        preamble_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new PromptSpec();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1beta.ConversationalSearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_AnswerQueryRequest_AnswerGenerationSpec_PromptSpec_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1beta.ConversationalSearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_AnswerQueryRequest_AnswerGenerationSpec_PromptSpec_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
                    .PromptSpec.class,
                com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
                    .PromptSpec.Builder.class);
      }

      public static final int PREAMBLE_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private volatile java.lang.Object preamble_ = "";
      /**
       *
       *
       * <pre>
       * Customized preamble.
       * </pre>
       *
       * <code>string preamble = 1;</code>
       *
       * @return The preamble.
       */
      @java.lang.Override
      public java.lang.String getPreamble() {
        java.lang.Object ref = preamble_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          preamble_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Customized preamble.
       * </pre>
       *
       * <code>string preamble = 1;</code>
       *
       * @return The bytes for preamble.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getPreambleBytes() {
        java.lang.Object ref = preamble_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          preamble_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(preamble_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, preamble_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(preamble_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, preamble_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
                .PromptSpec)) {
          return super.equals(obj);
        }
        com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec.PromptSpec
            other =
                (com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
                        .PromptSpec)
                    obj;

        if (!getPreamble().equals(other.getPreamble())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + PREAMBLE_FIELD_NUMBER;
        hash = (53 * hash) + getPreamble().hashCode();
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
              .PromptSpec
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
              .PromptSpec
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
              .PromptSpec
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
              .PromptSpec
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
              .PromptSpec
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
              .PromptSpec
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
              .PromptSpec
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
              .PromptSpec
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
              .PromptSpec
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
              .PromptSpec
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
              .PromptSpec
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
              .PromptSpec
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec.PromptSpec
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Answer generation prompt specification.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec.PromptSpec}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec.PromptSpec)
          com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
              .PromptSpecOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.discoveryengine.v1beta.ConversationalSearchServiceProto
              .internal_static_google_cloud_discoveryengine_v1beta_AnswerQueryRequest_AnswerGenerationSpec_PromptSpec_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.discoveryengine.v1beta.ConversationalSearchServiceProto
              .internal_static_google_cloud_discoveryengine_v1beta_AnswerQueryRequest_AnswerGenerationSpec_PromptSpec_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
                      .PromptSpec.class,
                  com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
                      .PromptSpec.Builder.class);
        }

        // Construct using
        // com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec.PromptSpec.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          preamble_ = "";
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.discoveryengine.v1beta.ConversationalSearchServiceProto
              .internal_static_google_cloud_discoveryengine_v1beta_AnswerQueryRequest_AnswerGenerationSpec_PromptSpec_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
                .PromptSpec
            getDefaultInstanceForType() {
          return com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
              .PromptSpec.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
                .PromptSpec
            build() {
          com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec.PromptSpec
              result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
                .PromptSpec
            buildPartial() {
          com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec.PromptSpec
              result =
                  new com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest
                      .AnswerGenerationSpec.PromptSpec(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
                    .PromptSpec
                result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.preamble_ = preamble_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
                  .PromptSpec) {
            return mergeFrom(
                (com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
                        .PromptSpec)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
                    .PromptSpec
                other) {
          if (other
              == com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
                  .PromptSpec.getDefaultInstance()) return this;
          if (!other.getPreamble().isEmpty()) {
            preamble_ = other.preamble_;
            bitField0_ |= 0x00000001;
            onChanged();
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    preamble_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.lang.Object preamble_ = "";
        /**
         *
         *
         * <pre>
         * Customized preamble.
         * </pre>
         *
         * <code>string preamble = 1;</code>
         *
         * @return The preamble.
         */
        public java.lang.String getPreamble() {
          java.lang.Object ref = preamble_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            preamble_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Customized preamble.
         * </pre>
         *
         * <code>string preamble = 1;</code>
         *
         * @return The bytes for preamble.
         */
        public com.google.protobuf.ByteString getPreambleBytes() {
          java.lang.Object ref = preamble_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            preamble_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Customized preamble.
         * </pre>
         *
         * <code>string preamble = 1;</code>
         *
         * @param value The preamble to set.
         * @return This builder for chaining.
         */
        public Builder setPreamble(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          preamble_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Customized preamble.
         * </pre>
         *
         * <code>string preamble = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearPreamble() {
          preamble_ = getDefaultInstance().getPreamble();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Customized preamble.
         * </pre>
         *
         * <code>string preamble = 1;</code>
         *
         * @param value The bytes for preamble to set.
         * @return This builder for chaining.
         */
        public Builder setPreambleBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          preamble_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec.PromptSpec)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec.PromptSpec)
      private static final com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest
              .AnswerGenerationSpec.PromptSpec
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
                .PromptSpec();
      }

      public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
              .PromptSpec
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<PromptSpec> PARSER =
          new com.google.protobuf.AbstractParser<PromptSpec>() {
            @java.lang.Override
            public PromptSpec parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<PromptSpec> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<PromptSpec> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
              .PromptSpec
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    private int bitField0_;
    public static final int MODEL_SPEC_FIELD_NUMBER = 1;
    private com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
            .ModelSpec
        modelSpec_;
    /**
     *
     *
     * <pre>
     * Answer generation model specification.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec.ModelSpec model_spec = 1;
     * </code>
     *
     * @return Whether the modelSpec field is set.
     */
    @java.lang.Override
    public boolean hasModelSpec() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Answer generation model specification.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec.ModelSpec model_spec = 1;
     * </code>
     *
     * @return The modelSpec.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec.ModelSpec
        getModelSpec() {
      return modelSpec_ == null
          ? com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
              .ModelSpec.getDefaultInstance()
          : modelSpec_;
    }
    /**
     *
     *
     * <pre>
     * Answer generation model specification.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec.ModelSpec model_spec = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
            .ModelSpecOrBuilder
        getModelSpecOrBuilder() {
      return modelSpec_ == null
          ? com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
              .ModelSpec.getDefaultInstance()
          : modelSpec_;
    }

    public static final int PROMPT_SPEC_FIELD_NUMBER = 2;
    private com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
            .PromptSpec
        promptSpec_;
    /**
     *
     *
     * <pre>
     * Answer generation prompt specification.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec.PromptSpec prompt_spec = 2;
     * </code>
     *
     * @return Whether the promptSpec field is set.
     */
    @java.lang.Override
    public boolean hasPromptSpec() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Answer generation prompt specification.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec.PromptSpec prompt_spec = 2;
     * </code>
     *
     * @return The promptSpec.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
            .PromptSpec
        getPromptSpec() {
      return promptSpec_ == null
          ? com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
              .PromptSpec.getDefaultInstance()
          : promptSpec_;
    }
    /**
     *
     *
     * <pre>
     * Answer generation prompt specification.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec.PromptSpec prompt_spec = 2;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
            .PromptSpecOrBuilder
        getPromptSpecOrBuilder() {
      return promptSpec_ == null
          ? com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
              .PromptSpec.getDefaultInstance()
          : promptSpec_;
    }

    public static final int INCLUDE_CITATIONS_FIELD_NUMBER = 3;
    private boolean includeCitations_ = false;
    /**
     *
     *
     * <pre>
     * Specifies whether to include citation metadata in the answer. The default
     * value is `false`.
     * </pre>
     *
     * <code>bool include_citations = 3;</code>
     *
     * @return The includeCitations.
     */
    @java.lang.Override
    public boolean getIncludeCitations() {
      return includeCitations_;
    }

    public static final int ANSWER_LANGUAGE_CODE_FIELD_NUMBER = 4;

    @SuppressWarnings("serial")
    private volatile java.lang.Object answerLanguageCode_ = "";
    /**
     *
     *
     * <pre>
     * Language code for Answer. Use language tags defined by
     * [BCP47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt).
     * Note: This is an experimental feature.
     * </pre>
     *
     * <code>string answer_language_code = 4;</code>
     *
     * @return The answerLanguageCode.
     */
    @java.lang.Override
    public java.lang.String getAnswerLanguageCode() {
      java.lang.Object ref = answerLanguageCode_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        answerLanguageCode_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Language code for Answer. Use language tags defined by
     * [BCP47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt).
     * Note: This is an experimental feature.
     * </pre>
     *
     * <code>string answer_language_code = 4;</code>
     *
     * @return The bytes for answerLanguageCode.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getAnswerLanguageCodeBytes() {
      java.lang.Object ref = answerLanguageCode_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        answerLanguageCode_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int IGNORE_ADVERSARIAL_QUERY_FIELD_NUMBER = 5;
    private boolean ignoreAdversarialQuery_ = false;
    /**
     *
     *
     * <pre>
     * Specifies whether to filter out adversarial queries. The default value
     * is `false`.
     *
     * Google employs search-query classification to detect adversarial
     * queries. No answer is returned if the search query is classified as an
     * adversarial query. For example, a user might ask a question regarding
     * negative comments about the company or submit a query designed to
     * generate unsafe, policy-violating output. If this field is set to
     * `true`, we skip generating answers for adversarial queries and return
     * fallback messages instead.
     * </pre>
     *
     * <code>bool ignore_adversarial_query = 5;</code>
     *
     * @return The ignoreAdversarialQuery.
     */
    @java.lang.Override
    public boolean getIgnoreAdversarialQuery() {
      return ignoreAdversarialQuery_;
    }

    public static final int IGNORE_NON_ANSWER_SEEKING_QUERY_FIELD_NUMBER = 6;
    private boolean ignoreNonAnswerSeekingQuery_ = false;
    /**
     *
     *
     * <pre>
     * Specifies whether to filter out queries that are not answer-seeking.
     * The default value is `false`.
     *
     * Google employs search-query classification to detect answer-seeking
     * queries. No answer is returned if the search query is classified as a
     * non-answer seeking query. If this field is set to `true`, we skip
     * generating answers for non-answer seeking queries and return
     * fallback messages instead.
     * </pre>
     *
     * <code>bool ignore_non_answer_seeking_query = 6;</code>
     *
     * @return The ignoreNonAnswerSeekingQuery.
     */
    @java.lang.Override
    public boolean getIgnoreNonAnswerSeekingQuery() {
      return ignoreNonAnswerSeekingQuery_;
    }

    public static final int IGNORE_LOW_RELEVANT_CONTENT_FIELD_NUMBER = 7;
    private boolean ignoreLowRelevantContent_ = false;
    /**
     *
     *
     * <pre>
     * Specifies whether to filter out queries that have low relevance.
     *
     * If this field is set to `false`, all search results are used regardless
     * of relevance to generate answers. If set to `true` or unset, the behavior
     * will be determined automatically by the service.
     * </pre>
     *
     * <code>optional bool ignore_low_relevant_content = 7;</code>
     *
     * @return Whether the ignoreLowRelevantContent field is set.
     */
    @java.lang.Override
    public boolean hasIgnoreLowRelevantContent() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Specifies whether to filter out queries that have low relevance.
     *
     * If this field is set to `false`, all search results are used regardless
     * of relevance to generate answers. If set to `true` or unset, the behavior
     * will be determined automatically by the service.
     * </pre>
     *
     * <code>optional bool ignore_low_relevant_content = 7;</code>
     *
     * @return The ignoreLowRelevantContent.
     */
    @java.lang.Override
    public boolean getIgnoreLowRelevantContent() {
      return ignoreLowRelevantContent_;
    }

    public static final int IGNORE_JAIL_BREAKING_QUERY_FIELD_NUMBER = 8;
    private boolean ignoreJailBreakingQuery_ = false;
    /**
     *
     *
     * <pre>
     * Optional. Specifies whether to filter out jail-breaking queries. The
     * default value is `false`.
     *
     * Google employs search-query classification to detect jail-breaking
     * queries. No summary is returned if the search query is classified as a
     * jail-breaking query. A user might add instructions to the query to
     * change the tone, style, language, content of the answer, or ask the
     * model to act as a different entity, e.g. "Reply in the tone of a
     * competing company's CEO". If this field is set to `true`, we skip
     * generating summaries for jail-breaking queries and return fallback
     * messages instead.
     * </pre>
     *
     * <code>bool ignore_jail_breaking_query = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The ignoreJailBreakingQuery.
     */
    @java.lang.Override
    public boolean getIgnoreJailBreakingQuery() {
      return ignoreJailBreakingQuery_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getModelSpec());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeMessage(2, getPromptSpec());
      }
      if (includeCitations_ != false) {
        output.writeBool(3, includeCitations_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(answerLanguageCode_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, answerLanguageCode_);
      }
      if (ignoreAdversarialQuery_ != false) {
        output.writeBool(5, ignoreAdversarialQuery_);
      }
      if (ignoreNonAnswerSeekingQuery_ != false) {
        output.writeBool(6, ignoreNonAnswerSeekingQuery_);
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        output.writeBool(7, ignoreLowRelevantContent_);
      }
      if (ignoreJailBreakingQuery_ != false) {
        output.writeBool(8, ignoreJailBreakingQuery_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getModelSpec());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getPromptSpec());
      }
      if (includeCitations_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(3, includeCitations_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(answerLanguageCode_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, answerLanguageCode_);
      }
      if (ignoreAdversarialQuery_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(5, ignoreAdversarialQuery_);
      }
      if (ignoreNonAnswerSeekingQuery_ != false) {
        size +=
            com.google.protobuf.CodedOutputStream.computeBoolSize(6, ignoreNonAnswerSeekingQuery_);
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(7, ignoreLowRelevantContent_);
      }
      if (ignoreJailBreakingQuery_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(8, ignoreJailBreakingQuery_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec)) {
        return super.equals(obj);
      }
      com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec other =
          (com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec) obj;

      if (hasModelSpec() != other.hasModelSpec()) return false;
      if (hasModelSpec()) {
        if (!getModelSpec().equals(other.getModelSpec())) return false;
      }
      if (hasPromptSpec() != other.hasPromptSpec()) return false;
      if (hasPromptSpec()) {
        if (!getPromptSpec().equals(other.getPromptSpec())) return false;
      }
      if (getIncludeCitations() != other.getIncludeCitations()) return false;
      if (!getAnswerLanguageCode().equals(other.getAnswerLanguageCode())) return false;
      if (getIgnoreAdversarialQuery() != other.getIgnoreAdversarialQuery()) return false;
      if (getIgnoreNonAnswerSeekingQuery() != other.getIgnoreNonAnswerSeekingQuery()) return false;
      if (hasIgnoreLowRelevantContent() != other.hasIgnoreLowRelevantContent()) return false;
      if (hasIgnoreLowRelevantContent()) {
        if (getIgnoreLowRelevantContent() != other.getIgnoreLowRelevantContent()) return false;
      }
      if (getIgnoreJailBreakingQuery() != other.getIgnoreJailBreakingQuery()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasModelSpec()) {
        hash = (37 * hash) + MODEL_SPEC_FIELD_NUMBER;
        hash = (53 * hash) + getModelSpec().hashCode();
      }
      if (hasPromptSpec()) {
        hash = (37 * hash) + PROMPT_SPEC_FIELD_NUMBER;
        hash = (53 * hash) + getPromptSpec().hashCode();
      }
      hash = (37 * hash) + INCLUDE_CITATIONS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getIncludeCitations());
      hash = (37 * hash) + ANSWER_LANGUAGE_CODE_FIELD_NUMBER;
      hash = (53 * hash) + getAnswerLanguageCode().hashCode();
      hash = (37 * hash) + IGNORE_ADVERSARIAL_QUERY_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getIgnoreAdversarialQuery());
      hash = (37 * hash) + IGNORE_NON_ANSWER_SEEKING_QUERY_FIELD_NUMBER;
      hash =
          (53 * hash) + com.google.protobuf.Internal.hashBoolean(getIgnoreNonAnswerSeekingQuery());
      if (hasIgnoreLowRelevantContent()) {
        hash = (37 * hash) + IGNORE_LOW_RELEVANT_CONTENT_FIELD_NUMBER;
        hash =
            (53 * hash) + com.google.protobuf.Internal.hashBoolean(getIgnoreLowRelevantContent());
      }
      hash = (37 * hash) + IGNORE_JAIL_BREAKING_QUERY_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getIgnoreJailBreakingQuery());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Answer generation specification.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec)
        com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpecOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1beta.ConversationalSearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_AnswerQueryRequest_AnswerGenerationSpec_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1beta.ConversationalSearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_AnswerQueryRequest_AnswerGenerationSpec_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
                    .class,
                com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
                    .Builder.class);
      }

      // Construct using
      // com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getModelSpecFieldBuilder();
          getPromptSpecFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        modelSpec_ = null;
        if (modelSpecBuilder_ != null) {
          modelSpecBuilder_.dispose();
          modelSpecBuilder_ = null;
        }
        promptSpec_ = null;
        if (promptSpecBuilder_ != null) {
          promptSpecBuilder_.dispose();
          promptSpecBuilder_ = null;
        }
        includeCitations_ = false;
        answerLanguageCode_ = "";
        ignoreAdversarialQuery_ = false;
        ignoreNonAnswerSeekingQuery_ = false;
        ignoreLowRelevantContent_ = false;
        ignoreJailBreakingQuery_ = false;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.discoveryengine.v1beta.ConversationalSearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_AnswerQueryRequest_AnswerGenerationSpec_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
          getDefaultInstanceForType() {
        return com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
          build() {
        com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
          buildPartial() {
        com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec result =
            new com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec(
                this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.modelSpec_ = modelSpecBuilder_ == null ? modelSpec_ : modelSpecBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.promptSpec_ =
              promptSpecBuilder_ == null ? promptSpec_ : promptSpecBuilder_.build();
          to_bitField0_ |= 0x00000002;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.includeCitations_ = includeCitations_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.answerLanguageCode_ = answerLanguageCode_;
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.ignoreAdversarialQuery_ = ignoreAdversarialQuery_;
        }
        if (((from_bitField0_ & 0x00000020) != 0)) {
          result.ignoreNonAnswerSeekingQuery_ = ignoreNonAnswerSeekingQuery_;
        }
        if (((from_bitField0_ & 0x00000040) != 0)) {
          result.ignoreLowRelevantContent_ = ignoreLowRelevantContent_;
          to_bitField0_ |= 0x00000004;
        }
        if (((from_bitField0_ & 0x00000080) != 0)) {
          result.ignoreJailBreakingQuery_ = ignoreJailBreakingQuery_;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec) {
          return mergeFrom(
              (com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec other) {
        if (other
            == com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
                .getDefaultInstance()) return this;
        if (other.hasModelSpec()) {
          mergeModelSpec(other.getModelSpec());
        }
        if (other.hasPromptSpec()) {
          mergePromptSpec(other.getPromptSpec());
        }
        if (other.getIncludeCitations() != false) {
          setIncludeCitations(other.getIncludeCitations());
        }
        if (!other.getAnswerLanguageCode().isEmpty()) {
          answerLanguageCode_ = other.answerLanguageCode_;
          bitField0_ |= 0x00000008;
          onChanged();
        }
        if (other.getIgnoreAdversarialQuery() != false) {
          setIgnoreAdversarialQuery(other.getIgnoreAdversarialQuery());
        }
        if (other.getIgnoreNonAnswerSeekingQuery() != false) {
          setIgnoreNonAnswerSeekingQuery(other.getIgnoreNonAnswerSeekingQuery());
        }
        if (other.hasIgnoreLowRelevantContent()) {
          setIgnoreLowRelevantContent(other.getIgnoreLowRelevantContent());
        }
        if (other.getIgnoreJailBreakingQuery() != false) {
          setIgnoreJailBreakingQuery(other.getIgnoreJailBreakingQuery());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getModelSpecFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(getPromptSpecFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 24:
                {
                  includeCitations_ = input.readBool();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 24
              case 34:
                {
                  answerLanguageCode_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 34
              case 40:
                {
                  ignoreAdversarialQuery_ = input.readBool();
                  bitField0_ |= 0x00000010;
                  break;
                } // case 40
              case 48:
                {
                  ignoreNonAnswerSeekingQuery_ = input.readBool();
                  bitField0_ |= 0x00000020;
                  break;
                } // case 48
              case 56:
                {
                  ignoreLowRelevantContent_ = input.readBool();
                  bitField0_ |= 0x00000040;
                  break;
                } // case 56
              case 64:
                {
                  ignoreJailBreakingQuery_ = input.readBool();
                  bitField0_ |= 0x00000080;
                  break;
                } // case 64
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
              .ModelSpec
          modelSpec_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
                  .ModelSpec,
              com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
                  .ModelSpec.Builder,
              com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
                  .ModelSpecOrBuilder>
          modelSpecBuilder_;
      /**
       *
       *
       * <pre>
       * Answer generation model specification.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec.ModelSpec model_spec = 1;
       * </code>
       *
       * @return Whether the modelSpec field is set.
       */
      public boolean hasModelSpec() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * Answer generation model specification.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec.ModelSpec model_spec = 1;
       * </code>
       *
       * @return The modelSpec.
       */
      public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
              .ModelSpec
          getModelSpec() {
        if (modelSpecBuilder_ == null) {
          return modelSpec_ == null
              ? com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
                  .ModelSpec.getDefaultInstance()
              : modelSpec_;
        } else {
          return modelSpecBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Answer generation model specification.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec.ModelSpec model_spec = 1;
       * </code>
       */
      public Builder setModelSpec(
          com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec.ModelSpec
              value) {
        if (modelSpecBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          modelSpec_ = value;
        } else {
          modelSpecBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Answer generation model specification.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec.ModelSpec model_spec = 1;
       * </code>
       */
      public Builder setModelSpec(
          com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec.ModelSpec
                  .Builder
              builderForValue) {
        if (modelSpecBuilder_ == null) {
          modelSpec_ = builderForValue.build();
        } else {
          modelSpecBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Answer generation model specification.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec.ModelSpec model_spec = 1;
       * </code>
       */
      public Builder mergeModelSpec(
          com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec.ModelSpec
              value) {
        if (modelSpecBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && modelSpec_ != null
              && modelSpec_
                  != com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
                      .ModelSpec.getDefaultInstance()) {
            getModelSpecBuilder().mergeFrom(value);
          } else {
            modelSpec_ = value;
          }
        } else {
          modelSpecBuilder_.mergeFrom(value);
        }
        if (modelSpec_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Answer generation model specification.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec.ModelSpec model_spec = 1;
       * </code>
       */
      public Builder clearModelSpec() {
        bitField0_ = (bitField0_ & ~0x00000001);
        modelSpec_ = null;
        if (modelSpecBuilder_ != null) {
          modelSpecBuilder_.dispose();
          modelSpecBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Answer generation model specification.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec.ModelSpec model_spec = 1;
       * </code>
       */
      public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
              .ModelSpec.Builder
          getModelSpecBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getModelSpecFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Answer generation model specification.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec.ModelSpec model_spec = 1;
       * </code>
       */
      public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
              .ModelSpecOrBuilder
          getModelSpecOrBuilder() {
        if (modelSpecBuilder_ != null) {
          return modelSpecBuilder_.getMessageOrBuilder();
        } else {
          return modelSpec_ == null
              ? com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
                  .ModelSpec.getDefaultInstance()
              : modelSpec_;
        }
      }
      /**
       *
       *
       * <pre>
       * Answer generation model specification.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec.ModelSpec model_spec = 1;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
                  .ModelSpec,
              com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
                  .ModelSpec.Builder,
              com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
                  .ModelSpecOrBuilder>
          getModelSpecFieldBuilder() {
        if (modelSpecBuilder_ == null) {
          modelSpecBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
                      .ModelSpec,
                  com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
                      .ModelSpec.Builder,
                  com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
                      .ModelSpecOrBuilder>(getModelSpec(), getParentForChildren(), isClean());
          modelSpec_ = null;
        }
        return modelSpecBuilder_;
      }

      private com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
              .PromptSpec
          promptSpec_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
                  .PromptSpec,
              com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
                  .PromptSpec.Builder,
              com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
                  .PromptSpecOrBuilder>
          promptSpecBuilder_;
      /**
       *
       *
       * <pre>
       * Answer generation prompt specification.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec.PromptSpec prompt_spec = 2;
       * </code>
       *
       * @return Whether the promptSpec field is set.
       */
      public boolean hasPromptSpec() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * Answer generation prompt specification.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec.PromptSpec prompt_spec = 2;
       * </code>
       *
       * @return The promptSpec.
       */
      public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
              .PromptSpec
          getPromptSpec() {
        if (promptSpecBuilder_ == null) {
          return promptSpec_ == null
              ? com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
                  .PromptSpec.getDefaultInstance()
              : promptSpec_;
        } else {
          return promptSpecBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Answer generation prompt specification.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec.PromptSpec prompt_spec = 2;
       * </code>
       */
      public Builder setPromptSpec(
          com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec.PromptSpec
              value) {
        if (promptSpecBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          promptSpec_ = value;
        } else {
          promptSpecBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Answer generation prompt specification.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec.PromptSpec prompt_spec = 2;
       * </code>
       */
      public Builder setPromptSpec(
          com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec.PromptSpec
                  .Builder
              builderForValue) {
        if (promptSpecBuilder_ == null) {
          promptSpec_ = builderForValue.build();
        } else {
          promptSpecBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Answer generation prompt specification.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec.PromptSpec prompt_spec = 2;
       * </code>
       */
      public Builder mergePromptSpec(
          com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec.PromptSpec
              value) {
        if (promptSpecBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && promptSpec_ != null
              && promptSpec_
                  != com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
                      .PromptSpec.getDefaultInstance()) {
            getPromptSpecBuilder().mergeFrom(value);
          } else {
            promptSpec_ = value;
          }
        } else {
          promptSpecBuilder_.mergeFrom(value);
        }
        if (promptSpec_ != null) {
          bitField0_ |= 0x00000002;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Answer generation prompt specification.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec.PromptSpec prompt_spec = 2;
       * </code>
       */
      public Builder clearPromptSpec() {
        bitField0_ = (bitField0_ & ~0x00000002);
        promptSpec_ = null;
        if (promptSpecBuilder_ != null) {
          promptSpecBuilder_.dispose();
          promptSpecBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Answer generation prompt specification.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec.PromptSpec prompt_spec = 2;
       * </code>
       */
      public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
              .PromptSpec.Builder
          getPromptSpecBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getPromptSpecFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Answer generation prompt specification.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec.PromptSpec prompt_spec = 2;
       * </code>
       */
      public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
              .PromptSpecOrBuilder
          getPromptSpecOrBuilder() {
        if (promptSpecBuilder_ != null) {
          return promptSpecBuilder_.getMessageOrBuilder();
        } else {
          return promptSpec_ == null
              ? com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
                  .PromptSpec.getDefaultInstance()
              : promptSpec_;
        }
      }
      /**
       *
       *
       * <pre>
       * Answer generation prompt specification.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec.PromptSpec prompt_spec = 2;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
                  .PromptSpec,
              com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
                  .PromptSpec.Builder,
              com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
                  .PromptSpecOrBuilder>
          getPromptSpecFieldBuilder() {
        if (promptSpecBuilder_ == null) {
          promptSpecBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
                      .PromptSpec,
                  com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
                      .PromptSpec.Builder,
                  com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
                      .PromptSpecOrBuilder>(getPromptSpec(), getParentForChildren(), isClean());
          promptSpec_ = null;
        }
        return promptSpecBuilder_;
      }

      private boolean includeCitations_;
      /**
       *
       *
       * <pre>
       * Specifies whether to include citation metadata in the answer. The default
       * value is `false`.
       * </pre>
       *
       * <code>bool include_citations = 3;</code>
       *
       * @return The includeCitations.
       */
      @java.lang.Override
      public boolean getIncludeCitations() {
        return includeCitations_;
      }
      /**
       *
       *
       * <pre>
       * Specifies whether to include citation metadata in the answer. The default
       * value is `false`.
       * </pre>
       *
       * <code>bool include_citations = 3;</code>
       *
       * @param value The includeCitations to set.
       * @return This builder for chaining.
       */
      public Builder setIncludeCitations(boolean value) {

        includeCitations_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specifies whether to include citation metadata in the answer. The default
       * value is `false`.
       * </pre>
       *
       * <code>bool include_citations = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearIncludeCitations() {
        bitField0_ = (bitField0_ & ~0x00000004);
        includeCitations_ = false;
        onChanged();
        return this;
      }

      private java.lang.Object answerLanguageCode_ = "";
      /**
       *
       *
       * <pre>
       * Language code for Answer. Use language tags defined by
       * [BCP47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt).
       * Note: This is an experimental feature.
       * </pre>
       *
       * <code>string answer_language_code = 4;</code>
       *
       * @return The answerLanguageCode.
       */
      public java.lang.String getAnswerLanguageCode() {
        java.lang.Object ref = answerLanguageCode_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          answerLanguageCode_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Language code for Answer. Use language tags defined by
       * [BCP47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt).
       * Note: This is an experimental feature.
       * </pre>
       *
       * <code>string answer_language_code = 4;</code>
       *
       * @return The bytes for answerLanguageCode.
       */
      public com.google.protobuf.ByteString getAnswerLanguageCodeBytes() {
        java.lang.Object ref = answerLanguageCode_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          answerLanguageCode_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Language code for Answer. Use language tags defined by
       * [BCP47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt).
       * Note: This is an experimental feature.
       * </pre>
       *
       * <code>string answer_language_code = 4;</code>
       *
       * @param value The answerLanguageCode to set.
       * @return This builder for chaining.
       */
      public Builder setAnswerLanguageCode(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        answerLanguageCode_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Language code for Answer. Use language tags defined by
       * [BCP47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt).
       * Note: This is an experimental feature.
       * </pre>
       *
       * <code>string answer_language_code = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAnswerLanguageCode() {
        answerLanguageCode_ = getDefaultInstance().getAnswerLanguageCode();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Language code for Answer. Use language tags defined by
       * [BCP47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt).
       * Note: This is an experimental feature.
       * </pre>
       *
       * <code>string answer_language_code = 4;</code>
       *
       * @param value The bytes for answerLanguageCode to set.
       * @return This builder for chaining.
       */
      public Builder setAnswerLanguageCodeBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        answerLanguageCode_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      private boolean ignoreAdversarialQuery_;
      /**
       *
       *
       * <pre>
       * Specifies whether to filter out adversarial queries. The default value
       * is `false`.
       *
       * Google employs search-query classification to detect adversarial
       * queries. No answer is returned if the search query is classified as an
       * adversarial query. For example, a user might ask a question regarding
       * negative comments about the company or submit a query designed to
       * generate unsafe, policy-violating output. If this field is set to
       * `true`, we skip generating answers for adversarial queries and return
       * fallback messages instead.
       * </pre>
       *
       * <code>bool ignore_adversarial_query = 5;</code>
       *
       * @return The ignoreAdversarialQuery.
       */
      @java.lang.Override
      public boolean getIgnoreAdversarialQuery() {
        return ignoreAdversarialQuery_;
      }
      /**
       *
       *
       * <pre>
       * Specifies whether to filter out adversarial queries. The default value
       * is `false`.
       *
       * Google employs search-query classification to detect adversarial
       * queries. No answer is returned if the search query is classified as an
       * adversarial query. For example, a user might ask a question regarding
       * negative comments about the company or submit a query designed to
       * generate unsafe, policy-violating output. If this field is set to
       * `true`, we skip generating answers for adversarial queries and return
       * fallback messages instead.
       * </pre>
       *
       * <code>bool ignore_adversarial_query = 5;</code>
       *
       * @param value The ignoreAdversarialQuery to set.
       * @return This builder for chaining.
       */
      public Builder setIgnoreAdversarialQuery(boolean value) {

        ignoreAdversarialQuery_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specifies whether to filter out adversarial queries. The default value
       * is `false`.
       *
       * Google employs search-query classification to detect adversarial
       * queries. No answer is returned if the search query is classified as an
       * adversarial query. For example, a user might ask a question regarding
       * negative comments about the company or submit a query designed to
       * generate unsafe, policy-violating output. If this field is set to
       * `true`, we skip generating answers for adversarial queries and return
       * fallback messages instead.
       * </pre>
       *
       * <code>bool ignore_adversarial_query = 5;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearIgnoreAdversarialQuery() {
        bitField0_ = (bitField0_ & ~0x00000010);
        ignoreAdversarialQuery_ = false;
        onChanged();
        return this;
      }

      private boolean ignoreNonAnswerSeekingQuery_;
      /**
       *
       *
       * <pre>
       * Specifies whether to filter out queries that are not answer-seeking.
       * The default value is `false`.
       *
       * Google employs search-query classification to detect answer-seeking
       * queries. No answer is returned if the search query is classified as a
       * non-answer seeking query. If this field is set to `true`, we skip
       * generating answers for non-answer seeking queries and return
       * fallback messages instead.
       * </pre>
       *
       * <code>bool ignore_non_answer_seeking_query = 6;</code>
       *
       * @return The ignoreNonAnswerSeekingQuery.
       */
      @java.lang.Override
      public boolean getIgnoreNonAnswerSeekingQuery() {
        return ignoreNonAnswerSeekingQuery_;
      }
      /**
       *
       *
       * <pre>
       * Specifies whether to filter out queries that are not answer-seeking.
       * The default value is `false`.
       *
       * Google employs search-query classification to detect answer-seeking
       * queries. No answer is returned if the search query is classified as a
       * non-answer seeking query. If this field is set to `true`, we skip
       * generating answers for non-answer seeking queries and return
       * fallback messages instead.
       * </pre>
       *
       * <code>bool ignore_non_answer_seeking_query = 6;</code>
       *
       * @param value The ignoreNonAnswerSeekingQuery to set.
       * @return This builder for chaining.
       */
      public Builder setIgnoreNonAnswerSeekingQuery(boolean value) {

        ignoreNonAnswerSeekingQuery_ = value;
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specifies whether to filter out queries that are not answer-seeking.
       * The default value is `false`.
       *
       * Google employs search-query classification to detect answer-seeking
       * queries. No answer is returned if the search query is classified as a
       * non-answer seeking query. If this field is set to `true`, we skip
       * generating answers for non-answer seeking queries and return
       * fallback messages instead.
       * </pre>
       *
       * <code>bool ignore_non_answer_seeking_query = 6;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearIgnoreNonAnswerSeekingQuery() {
        bitField0_ = (bitField0_ & ~0x00000020);
        ignoreNonAnswerSeekingQuery_ = false;
        onChanged();
        return this;
      }

      private boolean ignoreLowRelevantContent_;
      /**
       *
       *
       * <pre>
       * Specifies whether to filter out queries that have low relevance.
       *
       * If this field is set to `false`, all search results are used regardless
       * of relevance to generate answers. If set to `true` or unset, the behavior
       * will be determined automatically by the service.
       * </pre>
       *
       * <code>optional bool ignore_low_relevant_content = 7;</code>
       *
       * @return Whether the ignoreLowRelevantContent field is set.
       */
      @java.lang.Override
      public boolean hasIgnoreLowRelevantContent() {
        return ((bitField0_ & 0x00000040) != 0);
      }
      /**
       *
       *
       * <pre>
       * Specifies whether to filter out queries that have low relevance.
       *
       * If this field is set to `false`, all search results are used regardless
       * of relevance to generate answers. If set to `true` or unset, the behavior
       * will be determined automatically by the service.
       * </pre>
       *
       * <code>optional bool ignore_low_relevant_content = 7;</code>
       *
       * @return The ignoreLowRelevantContent.
       */
      @java.lang.Override
      public boolean getIgnoreLowRelevantContent() {
        return ignoreLowRelevantContent_;
      }
      /**
       *
       *
       * <pre>
       * Specifies whether to filter out queries that have low relevance.
       *
       * If this field is set to `false`, all search results are used regardless
       * of relevance to generate answers. If set to `true` or unset, the behavior
       * will be determined automatically by the service.
       * </pre>
       *
       * <code>optional bool ignore_low_relevant_content = 7;</code>
       *
       * @param value The ignoreLowRelevantContent to set.
       * @return This builder for chaining.
       */
      public Builder setIgnoreLowRelevantContent(boolean value) {

        ignoreLowRelevantContent_ = value;
        bitField0_ |= 0x00000040;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specifies whether to filter out queries that have low relevance.
       *
       * If this field is set to `false`, all search results are used regardless
       * of relevance to generate answers. If set to `true` or unset, the behavior
       * will be determined automatically by the service.
       * </pre>
       *
       * <code>optional bool ignore_low_relevant_content = 7;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearIgnoreLowRelevantContent() {
        bitField0_ = (bitField0_ & ~0x00000040);
        ignoreLowRelevantContent_ = false;
        onChanged();
        return this;
      }

      private boolean ignoreJailBreakingQuery_;
      /**
       *
       *
       * <pre>
       * Optional. Specifies whether to filter out jail-breaking queries. The
       * default value is `false`.
       *
       * Google employs search-query classification to detect jail-breaking
       * queries. No summary is returned if the search query is classified as a
       * jail-breaking query. A user might add instructions to the query to
       * change the tone, style, language, content of the answer, or ask the
       * model to act as a different entity, e.g. "Reply in the tone of a
       * competing company's CEO". If this field is set to `true`, we skip
       * generating summaries for jail-breaking queries and return fallback
       * messages instead.
       * </pre>
       *
       * <code>bool ignore_jail_breaking_query = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The ignoreJailBreakingQuery.
       */
      @java.lang.Override
      public boolean getIgnoreJailBreakingQuery() {
        return ignoreJailBreakingQuery_;
      }
      /**
       *
       *
       * <pre>
       * Optional. Specifies whether to filter out jail-breaking queries. The
       * default value is `false`.
       *
       * Google employs search-query classification to detect jail-breaking
       * queries. No summary is returned if the search query is classified as a
       * jail-breaking query. A user might add instructions to the query to
       * change the tone, style, language, content of the answer, or ask the
       * model to act as a different entity, e.g. "Reply in the tone of a
       * competing company's CEO". If this field is set to `true`, we skip
       * generating summaries for jail-breaking queries and return fallback
       * messages instead.
       * </pre>
       *
       * <code>bool ignore_jail_breaking_query = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The ignoreJailBreakingQuery to set.
       * @return This builder for chaining.
       */
      public Builder setIgnoreJailBreakingQuery(boolean value) {

        ignoreJailBreakingQuery_ = value;
        bitField0_ |= 0x00000080;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Specifies whether to filter out jail-breaking queries. The
       * default value is `false`.
       *
       * Google employs search-query classification to detect jail-breaking
       * queries. No summary is returned if the search query is classified as a
       * jail-breaking query. A user might add instructions to the query to
       * change the tone, style, language, content of the answer, or ask the
       * model to act as a different entity, e.g. "Reply in the tone of a
       * competing company's CEO". If this field is set to `true`, we skip
       * generating summaries for jail-breaking queries and return fallback
       * messages instead.
       * </pre>
       *
       * <code>bool ignore_jail_breaking_query = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearIgnoreJailBreakingQuery() {
        bitField0_ = (bitField0_ & ~0x00000080);
        ignoreJailBreakingQuery_ = false;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec)
    private static final com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest
            .AnswerGenerationSpec
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec();
    }

    public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<AnswerGenerationSpec> PARSER =
        new com.google.protobuf.AbstractParser<AnswerGenerationSpec>() {
          @java.lang.Override
          public AnswerGenerationSpec parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<AnswerGenerationSpec> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<AnswerGenerationSpec> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface SearchSpecOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Search parameters.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchParams search_params = 1;
     * </code>
     *
     * @return Whether the searchParams field is set.
     */
    boolean hasSearchParams();
    /**
     *
     *
     * <pre>
     * Search parameters.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchParams search_params = 1;
     * </code>
     *
     * @return The searchParams.
     */
    com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchParams
        getSearchParams();
    /**
     *
     *
     * <pre>
     * Search parameters.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchParams search_params = 1;
     * </code>
     */
    com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchParamsOrBuilder
        getSearchParamsOrBuilder();

    /**
     *
     *
     * <pre>
     * Search result list.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList search_result_list = 2;
     * </code>
     *
     * @return Whether the searchResultList field is set.
     */
    boolean hasSearchResultList();
    /**
     *
     *
     * <pre>
     * Search result list.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList search_result_list = 2;
     * </code>
     *
     * @return The searchResultList.
     */
    com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList
        getSearchResultList();
    /**
     *
     *
     * <pre>
     * Search result list.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList search_result_list = 2;
     * </code>
     */
    com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultListOrBuilder
        getSearchResultListOrBuilder();

    com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.InputCase getInputCase();
  }
  /**
   *
   *
   * <pre>
   * Search specification.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec}
   */
  public static final class SearchSpec extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec)
      SearchSpecOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use SearchSpec.newBuilder() to construct.
    private SearchSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private SearchSpec() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new SearchSpec();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1beta.ConversationalSearchServiceProto
          .internal_static_google_cloud_discoveryengine_v1beta_AnswerQueryRequest_SearchSpec_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1beta.ConversationalSearchServiceProto
          .internal_static_google_cloud_discoveryengine_v1beta_AnswerQueryRequest_SearchSpec_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.class,
              com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.Builder.class);
    }

    public interface SearchParamsOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchParams)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Number of search results to return.
       * The default value is 10.
       * </pre>
       *
       * <code>int32 max_return_results = 1;</code>
       *
       * @return The maxReturnResults.
       */
      int getMaxReturnResults();

      /**
       *
       *
       * <pre>
       * The filter syntax consists of an expression language for constructing
       * a predicate from one or more fields of the documents being filtered.
       * Filter expression is case-sensitive. This will be used to filter
       * search results which may affect the Answer response.
       *
       * If this field is unrecognizable, an  `INVALID_ARGUMENT`  is returned.
       *
       * Filtering in Vertex AI Search is done by mapping the LHS filter key
       * to a key property defined in the Vertex AI Search backend -- this
       * mapping is defined by the customer in their schema. For example a
       * media customers might have a field 'name' in their schema. In this
       * case the filter would look like this: filter --&gt; name:'ANY("king
       * kong")'
       *
       * For more information about filtering including syntax and filter
       * operators, see
       * [Filter](https://cloud.google.com/generative-ai-app-builder/docs/filter-search-metadata)
       * </pre>
       *
       * <code>string filter = 2;</code>
       *
       * @return The filter.
       */
      java.lang.String getFilter();
      /**
       *
       *
       * <pre>
       * The filter syntax consists of an expression language for constructing
       * a predicate from one or more fields of the documents being filtered.
       * Filter expression is case-sensitive. This will be used to filter
       * search results which may affect the Answer response.
       *
       * If this field is unrecognizable, an  `INVALID_ARGUMENT`  is returned.
       *
       * Filtering in Vertex AI Search is done by mapping the LHS filter key
       * to a key property defined in the Vertex AI Search backend -- this
       * mapping is defined by the customer in their schema. For example a
       * media customers might have a field 'name' in their schema. In this
       * case the filter would look like this: filter --&gt; name:'ANY("king
       * kong")'
       *
       * For more information about filtering including syntax and filter
       * operators, see
       * [Filter](https://cloud.google.com/generative-ai-app-builder/docs/filter-search-metadata)
       * </pre>
       *
       * <code>string filter = 2;</code>
       *
       * @return The bytes for filter.
       */
      com.google.protobuf.ByteString getFilterBytes();

      /**
       *
       *
       * <pre>
       * Boost specification to boost certain documents in search results which
       * may affect the answer query response. For more information on boosting,
       * see [Boosting](https://cloud.google.com/retail/docs/boosting#boost)
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec boost_spec = 3;</code>
       *
       * @return Whether the boostSpec field is set.
       */
      boolean hasBoostSpec();
      /**
       *
       *
       * <pre>
       * Boost specification to boost certain documents in search results which
       * may affect the answer query response. For more information on boosting,
       * see [Boosting](https://cloud.google.com/retail/docs/boosting#boost)
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec boost_spec = 3;</code>
       *
       * @return The boostSpec.
       */
      com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec getBoostSpec();
      /**
       *
       *
       * <pre>
       * Boost specification to boost certain documents in search results which
       * may affect the answer query response. For more information on boosting,
       * see [Boosting](https://cloud.google.com/retail/docs/boosting#boost)
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec boost_spec = 3;</code>
       */
      com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpecOrBuilder
          getBoostSpecOrBuilder();

      /**
       *
       *
       * <pre>
       * The order in which documents are returned. Documents can be ordered
       * by a field in an
       * [Document][google.cloud.discoveryengine.v1beta.Document] object. Leave
       * it unset if ordered by relevance. `order_by` expression is
       * case-sensitive. For more information on ordering, see
       * [Ordering](https://cloud.google.com/retail/docs/filter-and-order#order)
       *
       * If this field is unrecognizable, an `INVALID_ARGUMENT` is returned.
       * </pre>
       *
       * <code>string order_by = 4;</code>
       *
       * @return The orderBy.
       */
      java.lang.String getOrderBy();
      /**
       *
       *
       * <pre>
       * The order in which documents are returned. Documents can be ordered
       * by a field in an
       * [Document][google.cloud.discoveryengine.v1beta.Document] object. Leave
       * it unset if ordered by relevance. `order_by` expression is
       * case-sensitive. For more information on ordering, see
       * [Ordering](https://cloud.google.com/retail/docs/filter-and-order#order)
       *
       * If this field is unrecognizable, an `INVALID_ARGUMENT` is returned.
       * </pre>
       *
       * <code>string order_by = 4;</code>
       *
       * @return The bytes for orderBy.
       */
      com.google.protobuf.ByteString getOrderByBytes();

      /**
       *
       *
       * <pre>
       * Specifies the search result mode. If unspecified, the
       * search result mode defaults to `DOCUMENTS`.
       * See [parse and chunk
       * documents](https://cloud.google.com/generative-ai-app-builder/docs/parse-chunk-documents)
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SearchResultMode search_result_mode = 5;
       * </code>
       *
       * @return The enum numeric value on the wire for searchResultMode.
       */
      int getSearchResultModeValue();
      /**
       *
       *
       * <pre>
       * Specifies the search result mode. If unspecified, the
       * search result mode defaults to `DOCUMENTS`.
       * See [parse and chunk
       * documents](https://cloud.google.com/generative-ai-app-builder/docs/parse-chunk-documents)
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SearchResultMode search_result_mode = 5;
       * </code>
       *
       * @return The searchResultMode.
       */
      com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SearchResultMode
          getSearchResultMode();

      /**
       *
       *
       * <pre>
       * Specs defining dataStores to filter on in a search call and
       * configurations for those dataStores. This is only considered for
       * engines with multiple dataStores use case. For single dataStore within
       * an engine, they should use the specs at the top level.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpec data_store_specs = 7;
       * </code>
       */
      java.util.List<com.google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpec>
          getDataStoreSpecsList();
      /**
       *
       *
       * <pre>
       * Specs defining dataStores to filter on in a search call and
       * configurations for those dataStores. This is only considered for
       * engines with multiple dataStores use case. For single dataStore within
       * an engine, they should use the specs at the top level.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpec data_store_specs = 7;
       * </code>
       */
      com.google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpec getDataStoreSpecs(
          int index);
      /**
       *
       *
       * <pre>
       * Specs defining dataStores to filter on in a search call and
       * configurations for those dataStores. This is only considered for
       * engines with multiple dataStores use case. For single dataStore within
       * an engine, they should use the specs at the top level.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpec data_store_specs = 7;
       * </code>
       */
      int getDataStoreSpecsCount();
      /**
       *
       *
       * <pre>
       * Specs defining dataStores to filter on in a search call and
       * configurations for those dataStores. This is only considered for
       * engines with multiple dataStores use case. For single dataStore within
       * an engine, they should use the specs at the top level.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpec data_store_specs = 7;
       * </code>
       */
      java.util.List<
              ? extends
                  com.google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpecOrBuilder>
          getDataStoreSpecsOrBuilderList();
      /**
       *
       *
       * <pre>
       * Specs defining dataStores to filter on in a search call and
       * configurations for those dataStores. This is only considered for
       * engines with multiple dataStores use case. For single dataStore within
       * an engine, they should use the specs at the top level.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpec data_store_specs = 7;
       * </code>
       */
      com.google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpecOrBuilder
          getDataStoreSpecsOrBuilder(int index);

      /**
       *
       *
       * <pre>
       * Optional. Specification to enable natural language understanding
       * capabilities for search requests.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.SearchRequest.NaturalLanguageQueryUnderstandingSpec natural_language_query_understanding_spec = 8 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the naturalLanguageQueryUnderstandingSpec field is set.
       */
      boolean hasNaturalLanguageQueryUnderstandingSpec();
      /**
       *
       *
       * <pre>
       * Optional. Specification to enable natural language understanding
       * capabilities for search requests.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.SearchRequest.NaturalLanguageQueryUnderstandingSpec natural_language_query_understanding_spec = 8 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The naturalLanguageQueryUnderstandingSpec.
       */
      com.google.cloud.discoveryengine.v1beta.SearchRequest.NaturalLanguageQueryUnderstandingSpec
          getNaturalLanguageQueryUnderstandingSpec();
      /**
       *
       *
       * <pre>
       * Optional. Specification to enable natural language understanding
       * capabilities for search requests.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.SearchRequest.NaturalLanguageQueryUnderstandingSpec natural_language_query_understanding_spec = 8 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      com.google.cloud.discoveryengine.v1beta.SearchRequest
              .NaturalLanguageQueryUnderstandingSpecOrBuilder
          getNaturalLanguageQueryUnderstandingSpecOrBuilder();
    }
    /**
     *
     *
     * <pre>
     * Search parameters.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchParams}
     */
    public static final class SearchParams extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchParams)
        SearchParamsOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use SearchParams.newBuilder() to construct.
      private SearchParams(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private SearchParams() {
        filter_ = "";
        orderBy_ = "";
        searchResultMode_ = 0;
        dataStoreSpecs_ = java.util.Collections.emptyList();
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new SearchParams();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1beta.ConversationalSearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_AnswerQueryRequest_SearchSpec_SearchParams_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1beta.ConversationalSearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_AnswerQueryRequest_SearchSpec_SearchParams_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchParams
                    .class,
                com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchParams
                    .Builder.class);
      }

      private int bitField0_;
      public static final int MAX_RETURN_RESULTS_FIELD_NUMBER = 1;
      private int maxReturnResults_ = 0;
      /**
       *
       *
       * <pre>
       * Number of search results to return.
       * The default value is 10.
       * </pre>
       *
       * <code>int32 max_return_results = 1;</code>
       *
       * @return The maxReturnResults.
       */
      @java.lang.Override
      public int getMaxReturnResults() {
        return maxReturnResults_;
      }

      public static final int FILTER_FIELD_NUMBER = 2;

      @SuppressWarnings("serial")
      private volatile java.lang.Object filter_ = "";
      /**
       *
       *
       * <pre>
       * The filter syntax consists of an expression language for constructing
       * a predicate from one or more fields of the documents being filtered.
       * Filter expression is case-sensitive. This will be used to filter
       * search results which may affect the Answer response.
       *
       * If this field is unrecognizable, an  `INVALID_ARGUMENT`  is returned.
       *
       * Filtering in Vertex AI Search is done by mapping the LHS filter key
       * to a key property defined in the Vertex AI Search backend -- this
       * mapping is defined by the customer in their schema. For example a
       * media customers might have a field 'name' in their schema. In this
       * case the filter would look like this: filter --&gt; name:'ANY("king
       * kong")'
       *
       * For more information about filtering including syntax and filter
       * operators, see
       * [Filter](https://cloud.google.com/generative-ai-app-builder/docs/filter-search-metadata)
       * </pre>
       *
       * <code>string filter = 2;</code>
       *
       * @return The filter.
       */
      @java.lang.Override
      public java.lang.String getFilter() {
        java.lang.Object ref = filter_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          filter_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * The filter syntax consists of an expression language for constructing
       * a predicate from one or more fields of the documents being filtered.
       * Filter expression is case-sensitive. This will be used to filter
       * search results which may affect the Answer response.
       *
       * If this field is unrecognizable, an  `INVALID_ARGUMENT`  is returned.
       *
       * Filtering in Vertex AI Search is done by mapping the LHS filter key
       * to a key property defined in the Vertex AI Search backend -- this
       * mapping is defined by the customer in their schema. For example a
       * media customers might have a field 'name' in their schema. In this
       * case the filter would look like this: filter --&gt; name:'ANY("king
       * kong")'
       *
       * For more information about filtering including syntax and filter
       * operators, see
       * [Filter](https://cloud.google.com/generative-ai-app-builder/docs/filter-search-metadata)
       * </pre>
       *
       * <code>string filter = 2;</code>
       *
       * @return The bytes for filter.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getFilterBytes() {
        java.lang.Object ref = filter_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          filter_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int BOOST_SPEC_FIELD_NUMBER = 3;
      private com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec boostSpec_;
      /**
       *
       *
       * <pre>
       * Boost specification to boost certain documents in search results which
       * may affect the answer query response. For more information on boosting,
       * see [Boosting](https://cloud.google.com/retail/docs/boosting#boost)
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec boost_spec = 3;</code>
       *
       * @return Whether the boostSpec field is set.
       */
      @java.lang.Override
      public boolean hasBoostSpec() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * Boost specification to boost certain documents in search results which
       * may affect the answer query response. For more information on boosting,
       * see [Boosting](https://cloud.google.com/retail/docs/boosting#boost)
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec boost_spec = 3;</code>
       *
       * @return The boostSpec.
       */
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec getBoostSpec() {
        return boostSpec_ == null
            ? com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.getDefaultInstance()
            : boostSpec_;
      }
      /**
       *
       *
       * <pre>
       * Boost specification to boost certain documents in search results which
       * may affect the answer query response. For more information on boosting,
       * see [Boosting](https://cloud.google.com/retail/docs/boosting#boost)
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec boost_spec = 3;</code>
       */
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpecOrBuilder
          getBoostSpecOrBuilder() {
        return boostSpec_ == null
            ? com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.getDefaultInstance()
            : boostSpec_;
      }

      public static final int ORDER_BY_FIELD_NUMBER = 4;

      @SuppressWarnings("serial")
      private volatile java.lang.Object orderBy_ = "";
      /**
       *
       *
       * <pre>
       * The order in which documents are returned. Documents can be ordered
       * by a field in an
       * [Document][google.cloud.discoveryengine.v1beta.Document] object. Leave
       * it unset if ordered by relevance. `order_by` expression is
       * case-sensitive. For more information on ordering, see
       * [Ordering](https://cloud.google.com/retail/docs/filter-and-order#order)
       *
       * If this field is unrecognizable, an `INVALID_ARGUMENT` is returned.
       * </pre>
       *
       * <code>string order_by = 4;</code>
       *
       * @return The orderBy.
       */
      @java.lang.Override
      public java.lang.String getOrderBy() {
        java.lang.Object ref = orderBy_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          orderBy_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * The order in which documents are returned. Documents can be ordered
       * by a field in an
       * [Document][google.cloud.discoveryengine.v1beta.Document] object. Leave
       * it unset if ordered by relevance. `order_by` expression is
       * case-sensitive. For more information on ordering, see
       * [Ordering](https://cloud.google.com/retail/docs/filter-and-order#order)
       *
       * If this field is unrecognizable, an `INVALID_ARGUMENT` is returned.
       * </pre>
       *
       * <code>string order_by = 4;</code>
       *
       * @return The bytes for orderBy.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getOrderByBytes() {
        java.lang.Object ref = orderBy_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          orderBy_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int SEARCH_RESULT_MODE_FIELD_NUMBER = 5;
      private int searchResultMode_ = 0;
      /**
       *
       *
       * <pre>
       * Specifies the search result mode. If unspecified, the
       * search result mode defaults to `DOCUMENTS`.
       * See [parse and chunk
       * documents](https://cloud.google.com/generative-ai-app-builder/docs/parse-chunk-documents)
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SearchResultMode search_result_mode = 5;
       * </code>
       *
       * @return The enum numeric value on the wire for searchResultMode.
       */
      @java.lang.Override
      public int getSearchResultModeValue() {
        return searchResultMode_;
      }
      /**
       *
       *
       * <pre>
       * Specifies the search result mode. If unspecified, the
       * search result mode defaults to `DOCUMENTS`.
       * See [parse and chunk
       * documents](https://cloud.google.com/generative-ai-app-builder/docs/parse-chunk-documents)
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SearchResultMode search_result_mode = 5;
       * </code>
       *
       * @return The searchResultMode.
       */
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
              .SearchResultMode
          getSearchResultMode() {
        com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SearchResultMode
            result =
                com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                    .SearchResultMode.forNumber(searchResultMode_);
        return result == null
            ? com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                .SearchResultMode.UNRECOGNIZED
            : result;
      }

      public static final int DATA_STORE_SPECS_FIELD_NUMBER = 7;

      @SuppressWarnings("serial")
      private java.util.List<com.google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpec>
          dataStoreSpecs_;
      /**
       *
       *
       * <pre>
       * Specs defining dataStores to filter on in a search call and
       * configurations for those dataStores. This is only considered for
       * engines with multiple dataStores use case. For single dataStore within
       * an engine, they should use the specs at the top level.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpec data_store_specs = 7;
       * </code>
       */
      @java.lang.Override
      public java.util.List<com.google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpec>
          getDataStoreSpecsList() {
        return dataStoreSpecs_;
      }
      /**
       *
       *
       * <pre>
       * Specs defining dataStores to filter on in a search call and
       * configurations for those dataStores. This is only considered for
       * engines with multiple dataStores use case. For single dataStore within
       * an engine, they should use the specs at the top level.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpec data_store_specs = 7;
       * </code>
       */
      @java.lang.Override
      public java.util.List<
              ? extends
                  com.google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpecOrBuilder>
          getDataStoreSpecsOrBuilderList() {
        return dataStoreSpecs_;
      }
      /**
       *
       *
       * <pre>
       * Specs defining dataStores to filter on in a search call and
       * configurations for those dataStores. This is only considered for
       * engines with multiple dataStores use case. For single dataStore within
       * an engine, they should use the specs at the top level.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpec data_store_specs = 7;
       * </code>
       */
      @java.lang.Override
      public int getDataStoreSpecsCount() {
        return dataStoreSpecs_.size();
      }
      /**
       *
       *
       * <pre>
       * Specs defining dataStores to filter on in a search call and
       * configurations for those dataStores. This is only considered for
       * engines with multiple dataStores use case. For single dataStore within
       * an engine, they should use the specs at the top level.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpec data_store_specs = 7;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpec getDataStoreSpecs(
          int index) {
        return dataStoreSpecs_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Specs defining dataStores to filter on in a search call and
       * configurations for those dataStores. This is only considered for
       * engines with multiple dataStores use case. For single dataStore within
       * an engine, they should use the specs at the top level.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpec data_store_specs = 7;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpecOrBuilder
          getDataStoreSpecsOrBuilder(int index) {
        return dataStoreSpecs_.get(index);
      }

      public static final int NATURAL_LANGUAGE_QUERY_UNDERSTANDING_SPEC_FIELD_NUMBER = 8;
      private com.google.cloud.discoveryengine.v1beta.SearchRequest
              .NaturalLanguageQueryUnderstandingSpec
          naturalLanguageQueryUnderstandingSpec_;
      /**
       *
       *
       * <pre>
       * Optional. Specification to enable natural language understanding
       * capabilities for search requests.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.SearchRequest.NaturalLanguageQueryUnderstandingSpec natural_language_query_understanding_spec = 8 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the naturalLanguageQueryUnderstandingSpec field is set.
       */
      @java.lang.Override
      public boolean hasNaturalLanguageQueryUnderstandingSpec() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * Optional. Specification to enable natural language understanding
       * capabilities for search requests.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.SearchRequest.NaturalLanguageQueryUnderstandingSpec natural_language_query_understanding_spec = 8 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The naturalLanguageQueryUnderstandingSpec.
       */
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.SearchRequest
              .NaturalLanguageQueryUnderstandingSpec
          getNaturalLanguageQueryUnderstandingSpec() {
        return naturalLanguageQueryUnderstandingSpec_ == null
            ? com.google.cloud.discoveryengine.v1beta.SearchRequest
                .NaturalLanguageQueryUnderstandingSpec.getDefaultInstance()
            : naturalLanguageQueryUnderstandingSpec_;
      }
      /**
       *
       *
       * <pre>
       * Optional. Specification to enable natural language understanding
       * capabilities for search requests.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.SearchRequest.NaturalLanguageQueryUnderstandingSpec natural_language_query_understanding_spec = 8 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.SearchRequest
              .NaturalLanguageQueryUnderstandingSpecOrBuilder
          getNaturalLanguageQueryUnderstandingSpecOrBuilder() {
        return naturalLanguageQueryUnderstandingSpec_ == null
            ? com.google.cloud.discoveryengine.v1beta.SearchRequest
                .NaturalLanguageQueryUnderstandingSpec.getDefaultInstance()
            : naturalLanguageQueryUnderstandingSpec_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (maxReturnResults_ != 0) {
          output.writeInt32(1, maxReturnResults_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(filter_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 2, filter_);
        }
        if (((bitField0_ & 0x00000001) != 0)) {
          output.writeMessage(3, getBoostSpec());
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(orderBy_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 4, orderBy_);
        }
        if (searchResultMode_
            != com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                .SearchResultMode.SEARCH_RESULT_MODE_UNSPECIFIED
                .getNumber()) {
          output.writeEnum(5, searchResultMode_);
        }
        for (int i = 0; i < dataStoreSpecs_.size(); i++) {
          output.writeMessage(7, dataStoreSpecs_.get(i));
        }
        if (((bitField0_ & 0x00000002) != 0)) {
          output.writeMessage(8, getNaturalLanguageQueryUnderstandingSpec());
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (maxReturnResults_ != 0) {
          size += com.google.protobuf.CodedOutputStream.computeInt32Size(1, maxReturnResults_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(filter_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, filter_);
        }
        if (((bitField0_ & 0x00000001) != 0)) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getBoostSpec());
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(orderBy_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, orderBy_);
        }
        if (searchResultMode_
            != com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                .SearchResultMode.SEARCH_RESULT_MODE_UNSPECIFIED
                .getNumber()) {
          size += com.google.protobuf.CodedOutputStream.computeEnumSize(5, searchResultMode_);
        }
        for (int i = 0; i < dataStoreSpecs_.size(); i++) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(7, dataStoreSpecs_.get(i));
        }
        if (((bitField0_ & 0x00000002) != 0)) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(
                  8, getNaturalLanguageQueryUnderstandingSpec());
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchParams)) {
          return super.equals(obj);
        }
        com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchParams other =
            (com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchParams)
                obj;

        if (getMaxReturnResults() != other.getMaxReturnResults()) return false;
        if (!getFilter().equals(other.getFilter())) return false;
        if (hasBoostSpec() != other.hasBoostSpec()) return false;
        if (hasBoostSpec()) {
          if (!getBoostSpec().equals(other.getBoostSpec())) return false;
        }
        if (!getOrderBy().equals(other.getOrderBy())) return false;
        if (searchResultMode_ != other.searchResultMode_) return false;
        if (!getDataStoreSpecsList().equals(other.getDataStoreSpecsList())) return false;
        if (hasNaturalLanguageQueryUnderstandingSpec()
            != other.hasNaturalLanguageQueryUnderstandingSpec()) return false;
        if (hasNaturalLanguageQueryUnderstandingSpec()) {
          if (!getNaturalLanguageQueryUnderstandingSpec()
              .equals(other.getNaturalLanguageQueryUnderstandingSpec())) return false;
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + MAX_RETURN_RESULTS_FIELD_NUMBER;
        hash = (53 * hash) + getMaxReturnResults();
        hash = (37 * hash) + FILTER_FIELD_NUMBER;
        hash = (53 * hash) + getFilter().hashCode();
        if (hasBoostSpec()) {
          hash = (37 * hash) + BOOST_SPEC_FIELD_NUMBER;
          hash = (53 * hash) + getBoostSpec().hashCode();
        }
        hash = (37 * hash) + ORDER_BY_FIELD_NUMBER;
        hash = (53 * hash) + getOrderBy().hashCode();
        hash = (37 * hash) + SEARCH_RESULT_MODE_FIELD_NUMBER;
        hash = (53 * hash) + searchResultMode_;
        if (getDataStoreSpecsCount() > 0) {
          hash = (37 * hash) + DATA_STORE_SPECS_FIELD_NUMBER;
          hash = (53 * hash) + getDataStoreSpecsList().hashCode();
        }
        if (hasNaturalLanguageQueryUnderstandingSpec()) {
          hash = (37 * hash) + NATURAL_LANGUAGE_QUERY_UNDERSTANDING_SPEC_FIELD_NUMBER;
          hash = (53 * hash) + getNaturalLanguageQueryUnderstandingSpec().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
              .SearchParams
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
              .SearchParams
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
              .SearchParams
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
              .SearchParams
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
              .SearchParams
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
              .SearchParams
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
              .SearchParams
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
              .SearchParams
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
              .SearchParams
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
              .SearchParams
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
              .SearchParams
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
              .SearchParams
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchParams
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Search parameters.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchParams}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchParams)
          com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
              .SearchParamsOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.discoveryengine.v1beta.ConversationalSearchServiceProto
              .internal_static_google_cloud_discoveryengine_v1beta_AnswerQueryRequest_SearchSpec_SearchParams_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.discoveryengine.v1beta.ConversationalSearchServiceProto
              .internal_static_google_cloud_discoveryengine_v1beta_AnswerQueryRequest_SearchSpec_SearchParams_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchParams
                      .class,
                  com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchParams
                      .Builder.class);
        }

        // Construct using
        // com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchParams.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
            getBoostSpecFieldBuilder();
            getDataStoreSpecsFieldBuilder();
            getNaturalLanguageQueryUnderstandingSpecFieldBuilder();
          }
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          maxReturnResults_ = 0;
          filter_ = "";
          boostSpec_ = null;
          if (boostSpecBuilder_ != null) {
            boostSpecBuilder_.dispose();
            boostSpecBuilder_ = null;
          }
          orderBy_ = "";
          searchResultMode_ = 0;
          if (dataStoreSpecsBuilder_ == null) {
            dataStoreSpecs_ = java.util.Collections.emptyList();
          } else {
            dataStoreSpecs_ = null;
            dataStoreSpecsBuilder_.clear();
          }
          bitField0_ = (bitField0_ & ~0x00000020);
          naturalLanguageQueryUnderstandingSpec_ = null;
          if (naturalLanguageQueryUnderstandingSpecBuilder_ != null) {
            naturalLanguageQueryUnderstandingSpecBuilder_.dispose();
            naturalLanguageQueryUnderstandingSpecBuilder_ = null;
          }
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.discoveryengine.v1beta.ConversationalSearchServiceProto
              .internal_static_google_cloud_discoveryengine_v1beta_AnswerQueryRequest_SearchSpec_SearchParams_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchParams
            getDefaultInstanceForType() {
          return com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchParams
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchParams
            build() {
          com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchParams
              result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchParams
            buildPartial() {
          com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchParams
              result =
                  new com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                      .SearchParams(this);
          buildPartialRepeatedFields(result);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartialRepeatedFields(
            com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchParams
                result) {
          if (dataStoreSpecsBuilder_ == null) {
            if (((bitField0_ & 0x00000020) != 0)) {
              dataStoreSpecs_ = java.util.Collections.unmodifiableList(dataStoreSpecs_);
              bitField0_ = (bitField0_ & ~0x00000020);
            }
            result.dataStoreSpecs_ = dataStoreSpecs_;
          } else {
            result.dataStoreSpecs_ = dataStoreSpecsBuilder_.build();
          }
        }

        private void buildPartial0(
            com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchParams
                result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.maxReturnResults_ = maxReturnResults_;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.filter_ = filter_;
          }
          int to_bitField0_ = 0;
          if (((from_bitField0_ & 0x00000004) != 0)) {
            result.boostSpec_ = boostSpecBuilder_ == null ? boostSpec_ : boostSpecBuilder_.build();
            to_bitField0_ |= 0x00000001;
          }
          if (((from_bitField0_ & 0x00000008) != 0)) {
            result.orderBy_ = orderBy_;
          }
          if (((from_bitField0_ & 0x00000010) != 0)) {
            result.searchResultMode_ = searchResultMode_;
          }
          if (((from_bitField0_ & 0x00000040) != 0)) {
            result.naturalLanguageQueryUnderstandingSpec_ =
                naturalLanguageQueryUnderstandingSpecBuilder_ == null
                    ? naturalLanguageQueryUnderstandingSpec_
                    : naturalLanguageQueryUnderstandingSpecBuilder_.build();
            to_bitField0_ |= 0x00000002;
          }
          result.bitField0_ |= to_bitField0_;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchParams) {
            return mergeFrom(
                (com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchParams)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchParams
                other) {
          if (other
              == com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchParams
                  .getDefaultInstance()) return this;
          if (other.getMaxReturnResults() != 0) {
            setMaxReturnResults(other.getMaxReturnResults());
          }
          if (!other.getFilter().isEmpty()) {
            filter_ = other.filter_;
            bitField0_ |= 0x00000002;
            onChanged();
          }
          if (other.hasBoostSpec()) {
            mergeBoostSpec(other.getBoostSpec());
          }
          if (!other.getOrderBy().isEmpty()) {
            orderBy_ = other.orderBy_;
            bitField0_ |= 0x00000008;
            onChanged();
          }
          if (other.searchResultMode_ != 0) {
            setSearchResultModeValue(other.getSearchResultModeValue());
          }
          if (dataStoreSpecsBuilder_ == null) {
            if (!other.dataStoreSpecs_.isEmpty()) {
              if (dataStoreSpecs_.isEmpty()) {
                dataStoreSpecs_ = other.dataStoreSpecs_;
                bitField0_ = (bitField0_ & ~0x00000020);
              } else {
                ensureDataStoreSpecsIsMutable();
                dataStoreSpecs_.addAll(other.dataStoreSpecs_);
              }
              onChanged();
            }
          } else {
            if (!other.dataStoreSpecs_.isEmpty()) {
              if (dataStoreSpecsBuilder_.isEmpty()) {
                dataStoreSpecsBuilder_.dispose();
                dataStoreSpecsBuilder_ = null;
                dataStoreSpecs_ = other.dataStoreSpecs_;
                bitField0_ = (bitField0_ & ~0x00000020);
                dataStoreSpecsBuilder_ =
                    com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                        ? getDataStoreSpecsFieldBuilder()
                        : null;
              } else {
                dataStoreSpecsBuilder_.addAllMessages(other.dataStoreSpecs_);
              }
            }
          }
          if (other.hasNaturalLanguageQueryUnderstandingSpec()) {
            mergeNaturalLanguageQueryUnderstandingSpec(
                other.getNaturalLanguageQueryUnderstandingSpec());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 8:
                  {
                    maxReturnResults_ = input.readInt32();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 8
                case 18:
                  {
                    filter_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 18
                case 26:
                  {
                    input.readMessage(getBoostSpecFieldBuilder().getBuilder(), extensionRegistry);
                    bitField0_ |= 0x00000004;
                    break;
                  } // case 26
                case 34:
                  {
                    orderBy_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000008;
                    break;
                  } // case 34
                case 40:
                  {
                    searchResultMode_ = input.readEnum();
                    bitField0_ |= 0x00000010;
                    break;
                  } // case 40
                case 58:
                  {
                    com.google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpec m =
                        input.readMessage(
                            com.google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpec
                                .parser(),
                            extensionRegistry);
                    if (dataStoreSpecsBuilder_ == null) {
                      ensureDataStoreSpecsIsMutable();
                      dataStoreSpecs_.add(m);
                    } else {
                      dataStoreSpecsBuilder_.addMessage(m);
                    }
                    break;
                  } // case 58
                case 66:
                  {
                    input.readMessage(
                        getNaturalLanguageQueryUnderstandingSpecFieldBuilder().getBuilder(),
                        extensionRegistry);
                    bitField0_ |= 0x00000040;
                    break;
                  } // case 66
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private int maxReturnResults_;
        /**
         *
         *
         * <pre>
         * Number of search results to return.
         * The default value is 10.
         * </pre>
         *
         * <code>int32 max_return_results = 1;</code>
         *
         * @return The maxReturnResults.
         */
        @java.lang.Override
        public int getMaxReturnResults() {
          return maxReturnResults_;
        }
        /**
         *
         *
         * <pre>
         * Number of search results to return.
         * The default value is 10.
         * </pre>
         *
         * <code>int32 max_return_results = 1;</code>
         *
         * @param value The maxReturnResults to set.
         * @return This builder for chaining.
         */
        public Builder setMaxReturnResults(int value) {

          maxReturnResults_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Number of search results to return.
         * The default value is 10.
         * </pre>
         *
         * <code>int32 max_return_results = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearMaxReturnResults() {
          bitField0_ = (bitField0_ & ~0x00000001);
          maxReturnResults_ = 0;
          onChanged();
          return this;
        }

        private java.lang.Object filter_ = "";
        /**
         *
         *
         * <pre>
         * The filter syntax consists of an expression language for constructing
         * a predicate from one or more fields of the documents being filtered.
         * Filter expression is case-sensitive. This will be used to filter
         * search results which may affect the Answer response.
         *
         * If this field is unrecognizable, an  `INVALID_ARGUMENT`  is returned.
         *
         * Filtering in Vertex AI Search is done by mapping the LHS filter key
         * to a key property defined in the Vertex AI Search backend -- this
         * mapping is defined by the customer in their schema. For example a
         * media customers might have a field 'name' in their schema. In this
         * case the filter would look like this: filter --&gt; name:'ANY("king
         * kong")'
         *
         * For more information about filtering including syntax and filter
         * operators, see
         * [Filter](https://cloud.google.com/generative-ai-app-builder/docs/filter-search-metadata)
         * </pre>
         *
         * <code>string filter = 2;</code>
         *
         * @return The filter.
         */
        public java.lang.String getFilter() {
          java.lang.Object ref = filter_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            filter_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * The filter syntax consists of an expression language for constructing
         * a predicate from one or more fields of the documents being filtered.
         * Filter expression is case-sensitive. This will be used to filter
         * search results which may affect the Answer response.
         *
         * If this field is unrecognizable, an  `INVALID_ARGUMENT`  is returned.
         *
         * Filtering in Vertex AI Search is done by mapping the LHS filter key
         * to a key property defined in the Vertex AI Search backend -- this
         * mapping is defined by the customer in their schema. For example a
         * media customers might have a field 'name' in their schema. In this
         * case the filter would look like this: filter --&gt; name:'ANY("king
         * kong")'
         *
         * For more information about filtering including syntax and filter
         * operators, see
         * [Filter](https://cloud.google.com/generative-ai-app-builder/docs/filter-search-metadata)
         * </pre>
         *
         * <code>string filter = 2;</code>
         *
         * @return The bytes for filter.
         */
        public com.google.protobuf.ByteString getFilterBytes() {
          java.lang.Object ref = filter_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            filter_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * The filter syntax consists of an expression language for constructing
         * a predicate from one or more fields of the documents being filtered.
         * Filter expression is case-sensitive. This will be used to filter
         * search results which may affect the Answer response.
         *
         * If this field is unrecognizable, an  `INVALID_ARGUMENT`  is returned.
         *
         * Filtering in Vertex AI Search is done by mapping the LHS filter key
         * to a key property defined in the Vertex AI Search backend -- this
         * mapping is defined by the customer in their schema. For example a
         * media customers might have a field 'name' in their schema. In this
         * case the filter would look like this: filter --&gt; name:'ANY("king
         * kong")'
         *
         * For more information about filtering including syntax and filter
         * operators, see
         * [Filter](https://cloud.google.com/generative-ai-app-builder/docs/filter-search-metadata)
         * </pre>
         *
         * <code>string filter = 2;</code>
         *
         * @param value The filter to set.
         * @return This builder for chaining.
         */
        public Builder setFilter(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          filter_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The filter syntax consists of an expression language for constructing
         * a predicate from one or more fields of the documents being filtered.
         * Filter expression is case-sensitive. This will be used to filter
         * search results which may affect the Answer response.
         *
         * If this field is unrecognizable, an  `INVALID_ARGUMENT`  is returned.
         *
         * Filtering in Vertex AI Search is done by mapping the LHS filter key
         * to a key property defined in the Vertex AI Search backend -- this
         * mapping is defined by the customer in their schema. For example a
         * media customers might have a field 'name' in their schema. In this
         * case the filter would look like this: filter --&gt; name:'ANY("king
         * kong")'
         *
         * For more information about filtering including syntax and filter
         * operators, see
         * [Filter](https://cloud.google.com/generative-ai-app-builder/docs/filter-search-metadata)
         * </pre>
         *
         * <code>string filter = 2;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearFilter() {
          filter_ = getDefaultInstance().getFilter();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The filter syntax consists of an expression language for constructing
         * a predicate from one or more fields of the documents being filtered.
         * Filter expression is case-sensitive. This will be used to filter
         * search results which may affect the Answer response.
         *
         * If this field is unrecognizable, an  `INVALID_ARGUMENT`  is returned.
         *
         * Filtering in Vertex AI Search is done by mapping the LHS filter key
         * to a key property defined in the Vertex AI Search backend -- this
         * mapping is defined by the customer in their schema. For example a
         * media customers might have a field 'name' in their schema. In this
         * case the filter would look like this: filter --&gt; name:'ANY("king
         * kong")'
         *
         * For more information about filtering including syntax and filter
         * operators, see
         * [Filter](https://cloud.google.com/generative-ai-app-builder/docs/filter-search-metadata)
         * </pre>
         *
         * <code>string filter = 2;</code>
         *
         * @param value The bytes for filter to set.
         * @return This builder for chaining.
         */
        public Builder setFilterBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          filter_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }

        private com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec boostSpec_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec,
                com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.Builder,
                com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpecOrBuilder>
            boostSpecBuilder_;
        /**
         *
         *
         * <pre>
         * Boost specification to boost certain documents in search results which
         * may affect the answer query response. For more information on boosting,
         * see [Boosting](https://cloud.google.com/retail/docs/boosting#boost)
         * </pre>
         *
         * <code>.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec boost_spec = 3;</code>
         *
         * @return Whether the boostSpec field is set.
         */
        public boolean hasBoostSpec() {
          return ((bitField0_ & 0x00000004) != 0);
        }
        /**
         *
         *
         * <pre>
         * Boost specification to boost certain documents in search results which
         * may affect the answer query response. For more information on boosting,
         * see [Boosting](https://cloud.google.com/retail/docs/boosting#boost)
         * </pre>
         *
         * <code>.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec boost_spec = 3;</code>
         *
         * @return The boostSpec.
         */
        public com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec getBoostSpec() {
          if (boostSpecBuilder_ == null) {
            return boostSpec_ == null
                ? com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec
                    .getDefaultInstance()
                : boostSpec_;
          } else {
            return boostSpecBuilder_.getMessage();
          }
        }
        /**
         *
         *
         * <pre>
         * Boost specification to boost certain documents in search results which
         * may affect the answer query response. For more information on boosting,
         * see [Boosting](https://cloud.google.com/retail/docs/boosting#boost)
         * </pre>
         *
         * <code>.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec boost_spec = 3;</code>
         */
        public Builder setBoostSpec(
            com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec value) {
          if (boostSpecBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            boostSpec_ = value;
          } else {
            boostSpecBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Boost specification to boost certain documents in search results which
         * may affect the answer query response. For more information on boosting,
         * see [Boosting](https://cloud.google.com/retail/docs/boosting#boost)
         * </pre>
         *
         * <code>.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec boost_spec = 3;</code>
         */
        public Builder setBoostSpec(
            com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.Builder
                builderForValue) {
          if (boostSpecBuilder_ == null) {
            boostSpec_ = builderForValue.build();
          } else {
            boostSpecBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Boost specification to boost certain documents in search results which
         * may affect the answer query response. For more information on boosting,
         * see [Boosting](https://cloud.google.com/retail/docs/boosting#boost)
         * </pre>
         *
         * <code>.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec boost_spec = 3;</code>
         */
        public Builder mergeBoostSpec(
            com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec value) {
          if (boostSpecBuilder_ == null) {
            if (((bitField0_ & 0x00000004) != 0)
                && boostSpec_ != null
                && boostSpec_
                    != com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec
                        .getDefaultInstance()) {
              getBoostSpecBuilder().mergeFrom(value);
            } else {
              boostSpec_ = value;
            }
          } else {
            boostSpecBuilder_.mergeFrom(value);
          }
          if (boostSpec_ != null) {
            bitField0_ |= 0x00000004;
            onChanged();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Boost specification to boost certain documents in search results which
         * may affect the answer query response. For more information on boosting,
         * see [Boosting](https://cloud.google.com/retail/docs/boosting#boost)
         * </pre>
         *
         * <code>.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec boost_spec = 3;</code>
         */
        public Builder clearBoostSpec() {
          bitField0_ = (bitField0_ & ~0x00000004);
          boostSpec_ = null;
          if (boostSpecBuilder_ != null) {
            boostSpecBuilder_.dispose();
            boostSpecBuilder_ = null;
          }
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Boost specification to boost certain documents in search results which
         * may affect the answer query response. For more information on boosting,
         * see [Boosting](https://cloud.google.com/retail/docs/boosting#boost)
         * </pre>
         *
         * <code>.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec boost_spec = 3;</code>
         */
        public com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.Builder
            getBoostSpecBuilder() {
          bitField0_ |= 0x00000004;
          onChanged();
          return getBoostSpecFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * Boost specification to boost certain documents in search results which
         * may affect the answer query response. For more information on boosting,
         * see [Boosting](https://cloud.google.com/retail/docs/boosting#boost)
         * </pre>
         *
         * <code>.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec boost_spec = 3;</code>
         */
        public com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpecOrBuilder
            getBoostSpecOrBuilder() {
          if (boostSpecBuilder_ != null) {
            return boostSpecBuilder_.getMessageOrBuilder();
          } else {
            return boostSpec_ == null
                ? com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec
                    .getDefaultInstance()
                : boostSpec_;
          }
        }
        /**
         *
         *
         * <pre>
         * Boost specification to boost certain documents in search results which
         * may affect the answer query response. For more information on boosting,
         * see [Boosting](https://cloud.google.com/retail/docs/boosting#boost)
         * </pre>
         *
         * <code>.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec boost_spec = 3;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec,
                com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.Builder,
                com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpecOrBuilder>
            getBoostSpecFieldBuilder() {
          if (boostSpecBuilder_ == null) {
            boostSpecBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec,
                    com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.Builder,
                    com.google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpecOrBuilder>(
                    getBoostSpec(), getParentForChildren(), isClean());
            boostSpec_ = null;
          }
          return boostSpecBuilder_;
        }

        private java.lang.Object orderBy_ = "";
        /**
         *
         *
         * <pre>
         * The order in which documents are returned. Documents can be ordered
         * by a field in an
         * [Document][google.cloud.discoveryengine.v1beta.Document] object. Leave
         * it unset if ordered by relevance. `order_by` expression is
         * case-sensitive. For more information on ordering, see
         * [Ordering](https://cloud.google.com/retail/docs/filter-and-order#order)
         *
         * If this field is unrecognizable, an `INVALID_ARGUMENT` is returned.
         * </pre>
         *
         * <code>string order_by = 4;</code>
         *
         * @return The orderBy.
         */
        public java.lang.String getOrderBy() {
          java.lang.Object ref = orderBy_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            orderBy_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * The order in which documents are returned. Documents can be ordered
         * by a field in an
         * [Document][google.cloud.discoveryengine.v1beta.Document] object. Leave
         * it unset if ordered by relevance. `order_by` expression is
         * case-sensitive. For more information on ordering, see
         * [Ordering](https://cloud.google.com/retail/docs/filter-and-order#order)
         *
         * If this field is unrecognizable, an `INVALID_ARGUMENT` is returned.
         * </pre>
         *
         * <code>string order_by = 4;</code>
         *
         * @return The bytes for orderBy.
         */
        public com.google.protobuf.ByteString getOrderByBytes() {
          java.lang.Object ref = orderBy_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            orderBy_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * The order in which documents are returned. Documents can be ordered
         * by a field in an
         * [Document][google.cloud.discoveryengine.v1beta.Document] object. Leave
         * it unset if ordered by relevance. `order_by` expression is
         * case-sensitive. For more information on ordering, see
         * [Ordering](https://cloud.google.com/retail/docs/filter-and-order#order)
         *
         * If this field is unrecognizable, an `INVALID_ARGUMENT` is returned.
         * </pre>
         *
         * <code>string order_by = 4;</code>
         *
         * @param value The orderBy to set.
         * @return This builder for chaining.
         */
        public Builder setOrderBy(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          orderBy_ = value;
          bitField0_ |= 0x00000008;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The order in which documents are returned. Documents can be ordered
         * by a field in an
         * [Document][google.cloud.discoveryengine.v1beta.Document] object. Leave
         * it unset if ordered by relevance. `order_by` expression is
         * case-sensitive. For more information on ordering, see
         * [Ordering](https://cloud.google.com/retail/docs/filter-and-order#order)
         *
         * If this field is unrecognizable, an `INVALID_ARGUMENT` is returned.
         * </pre>
         *
         * <code>string order_by = 4;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearOrderBy() {
          orderBy_ = getDefaultInstance().getOrderBy();
          bitField0_ = (bitField0_ & ~0x00000008);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The order in which documents are returned. Documents can be ordered
         * by a field in an
         * [Document][google.cloud.discoveryengine.v1beta.Document] object. Leave
         * it unset if ordered by relevance. `order_by` expression is
         * case-sensitive. For more information on ordering, see
         * [Ordering](https://cloud.google.com/retail/docs/filter-and-order#order)
         *
         * If this field is unrecognizable, an `INVALID_ARGUMENT` is returned.
         * </pre>
         *
         * <code>string order_by = 4;</code>
         *
         * @param value The bytes for orderBy to set.
         * @return This builder for chaining.
         */
        public Builder setOrderByBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          orderBy_ = value;
          bitField0_ |= 0x00000008;
          onChanged();
          return this;
        }

        private int searchResultMode_ = 0;
        /**
         *
         *
         * <pre>
         * Specifies the search result mode. If unspecified, the
         * search result mode defaults to `DOCUMENTS`.
         * See [parse and chunk
         * documents](https://cloud.google.com/generative-ai-app-builder/docs/parse-chunk-documents)
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SearchResultMode search_result_mode = 5;
         * </code>
         *
         * @return The enum numeric value on the wire for searchResultMode.
         */
        @java.lang.Override
        public int getSearchResultModeValue() {
          return searchResultMode_;
        }
        /**
         *
         *
         * <pre>
         * Specifies the search result mode. If unspecified, the
         * search result mode defaults to `DOCUMENTS`.
         * See [parse and chunk
         * documents](https://cloud.google.com/generative-ai-app-builder/docs/parse-chunk-documents)
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SearchResultMode search_result_mode = 5;
         * </code>
         *
         * @param value The enum numeric value on the wire for searchResultMode to set.
         * @return This builder for chaining.
         */
        public Builder setSearchResultModeValue(int value) {
          searchResultMode_ = value;
          bitField0_ |= 0x00000010;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Specifies the search result mode. If unspecified, the
         * search result mode defaults to `DOCUMENTS`.
         * See [parse and chunk
         * documents](https://cloud.google.com/generative-ai-app-builder/docs/parse-chunk-documents)
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SearchResultMode search_result_mode = 5;
         * </code>
         *
         * @return The searchResultMode.
         */
        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                .SearchResultMode
            getSearchResultMode() {
          com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SearchResultMode
              result =
                  com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                      .SearchResultMode.forNumber(searchResultMode_);
          return result == null
              ? com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
                  .SearchResultMode.UNRECOGNIZED
              : result;
        }
        /**
         *
         *
         * <pre>
         * Specifies the search result mode. If unspecified, the
         * search result mode defaults to `DOCUMENTS`.
         * See [parse and chunk
         * documents](https://cloud.google.com/generative-ai-app-builder/docs/parse-chunk-documents)
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SearchResultMode search_result_mode = 5;
         * </code>
         *
         * @param value The searchResultMode to set.
         * @return This builder for chaining.
         */
        public Builder setSearchResultMode(
            com.google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SearchResultMode
                value) {
          if (value == null) {
            throw new NullPointerException();
          }
          bitField0_ |= 0x00000010;
          searchResultMode_ = value.getNumber();
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Specifies the search result mode. If unspecified, the
         * search result mode defaults to `DOCUMENTS`.
         * See [parse and chunk
         * documents](https://cloud.google.com/generative-ai-app-builder/docs/parse-chunk-documents)
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SearchResultMode search_result_mode = 5;
         * </code>
         *
         * @return This builder for chaining.
         */
        public Builder clearSearchResultMode() {
          bitField0_ = (bitField0_ & ~0x00000010);
          searchResultMode_ = 0;
          onChanged();
          return this;
        }

        private java.util.List<com.google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpec>
            dataStoreSpecs_ = java.util.Collections.emptyList();

        private void ensureDataStoreSpecsIsMutable() {
          if (!((bitField0_ & 0x00000020) != 0)) {
            dataStoreSpecs_ =
                new java.util.ArrayList<
                    com.google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpec>(
                    dataStoreSpecs_);
            bitField0_ |= 0x00000020;
          }
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpec,
                com.google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpec.Builder,
                com.google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpecOrBuilder>
            dataStoreSpecsBuilder_;

        /**
         *
         *
         * <pre>
         * Specs defining dataStores to filter on in a search call and
         * configurations for those dataStores. This is only considered for
         * engines with multiple dataStores use case. For single dataStore within
         * an engine, they should use the specs at the top level.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpec data_store_specs = 7;
         * </code>
         */
        public java.util.List<com.google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpec>
            getDataStoreSpecsList() {
          if (dataStoreSpecsBuilder_ == null) {
            return java.util.Collections.unmodifiableList(dataStoreSpecs_);
          } else {
            return dataStoreSpecsBuilder_.getMessageList();
          }
        }
        /**
         *
         *
         * <pre>
         * Specs defining dataStores to filter on in a search call and
         * configurations for those dataStores. This is only considered for
         * engines with multiple dataStores use case. For single dataStore within
         * an engine, they should use the specs at the top level.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpec data_store_specs = 7;
         * </code>
         */
        public int getDataStoreSpecsCount() {
          if (dataStoreSpecsBuilder_ == null) {
            return dataStoreSpecs_.size();
          } else {
            return dataStoreSpecsBuilder_.getCount();
          }
        }
        /**
         *
         *
         * <pre>
         * Specs defining dataStores to filter on in a search call and
         * configurations for those dataStores. This is only considered for
         * engines with multiple dataStores use case. For single dataStore within
         * an engine, they should use the specs at the top level.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpec data_store_specs = 7;
         * </code>
         */
        public com.google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpec
            getDataStoreSpecs(int index) {
          if (dataStoreSpecsBuilder_ == null) {
            return dataStoreSpecs_.get(index);
          } else {
            return dataStoreSpecsBuilder_.getMessage(index);
          }
        }
        /**
         *
         *
         * <pre>
         * Specs defining dataStores to filter on in a search call and
         * configurations for those dataStores. This is only considered for
         * engines with multiple dataStores use case. For single dataStore within
         * an engine, they should use the specs at the top level.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpec data_store_specs = 7;
         * </code>
         */
        public Builder setDataStoreSpecs(
            int index, com.google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpec value) {
          if (dataStoreSpecsBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureDataStoreSpecsIsMutable();
            dataStoreSpecs_.set(index, value);
            onChanged();
          } else {
            dataStoreSpecsBuilder_.setMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Specs defining dataStores to filter on in a search call and
         * configurations for those dataStores. This is only considered for
         * engines with multiple dataStores use case. For single dataStore within
         * an engine, they should use the specs at the top level.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpec data_store_specs = 7;
         * </code>
         */
        public Builder setDataStoreSpecs(
            int index,
            com.google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpec.Builder
                builderForValue) {
          if (dataStoreSpecsBuilder_ == null) {
            ensureDataStoreSpecsIsMutable();
            dataStoreSpecs_.set(index, builderForValue.build());
            onChanged();
          } else {
            dataStoreSpecsBuilder_.setMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Specs defining dataStores to filter on in a search call and
         * configurations for those dataStores. This is only considered for
         * engines with multiple dataStores use case. For single dataStore within
         * an engine, they should use the specs at the top level.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpec data_store_specs = 7;
         * </code>
         */
        public Builder addDataStoreSpecs(
            com.google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpec value) {
          if (dataStoreSpecsBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureDataStoreSpecsIsMutable();
            dataStoreSpecs_.add(value);
            onChanged();
          } else {
            dataStoreSpecsBuilder_.addMessage(value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Specs defining dataStores to filter on in a search call and
         * configurations for those dataStores. This is only considered for
         * engines with multiple dataStores use case. For single dataStore within
         * an engine, they should use the specs at the top level.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpec data_store_specs = 7;
         * </code>
         */
        public Builder addDataStoreSpecs(
            int index, com.google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpec value) {
          if (dataStoreSpecsBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureDataStoreSpecsIsMutable();
            dataStoreSpecs_.add(index, value);
            onChanged();
          } else {
            dataStoreSpecsBuilder_.addMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Specs defining dataStores to filter on in a search call and
         * configurations for those dataStores. This is only considered for
         * engines with multiple dataStores use case. For single dataStore within
         * an engine, they should use the specs at the top level.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpec data_store_specs = 7;
         * </code>
         */
        public Builder addDataStoreSpecs(
            com.google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpec.Builder
                builderForValue) {
          if (dataStoreSpecsBuilder_ == null) {
            ensureDataStoreSpecsIsMutable();
            dataStoreSpecs_.add(builderForValue.build());
            onChanged();
          } else {
            dataStoreSpecsBuilder_.addMessage(builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Specs defining dataStores to filter on in a search call and
         * configurations for those dataStores. This is only considered for
         * engines with multiple dataStores use case. For single dataStore within
         * an engine, they should use the specs at the top level.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpec data_store_specs = 7;
         * </code>
         */
        public Builder addDataStoreSpecs(
            int index,
            com.google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpec.Builder
                builderForValue) {
          if (dataStoreSpecsBuilder_ == null) {
            ensureDataStoreSpecsIsMutable();
            dataStoreSpecs_.add(index, builderForValue.build());
            onChanged();
          } else {
            dataStoreSpecsBuilder_.addMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Specs defining dataStores to filter on in a search call and
         * configurations for those dataStores. This is only considered for
         * engines with multiple dataStores use case. For single dataStore within
         * an engine, they should use the specs at the top level.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpec data_store_specs = 7;
         * </code>
         */
        public Builder addAllDataStoreSpecs(
            java.lang.Iterable<
                    ? extends com.google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpec>
                values) {
          if (dataStoreSpecsBuilder_ == null) {
            ensureDataStoreSpecsIsMutable();
            com.google.protobuf.AbstractMessageLite.Builder.addAll(values, dataStoreSpecs_);
            onChanged();
          } else {
            dataStoreSpecsBuilder_.addAllMessages(values);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Specs defining dataStores to filter on in a search call and
         * configurations for those dataStores. This is only considered for
         * engines with multiple dataStores use case. For single dataStore within
         * an engine, they should use the specs at the top level.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpec data_store_specs = 7;
         * </code>
         */
        public Builder clearDataStoreSpecs() {
          if (dataStoreSpecsBuilder_ == null) {
            dataStoreSpecs_ = java.util.Collections.emptyList();
            bitField0_ = (bitField0_ & ~0x00000020);
            onChanged();
          } else {
            dataStoreSpecsBuilder_.clear();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Specs defining dataStores to filter on in a search call and
         * configurations for those dataStores. This is only considered for
         * engines with multiple dataStores use case. For single dataStore within
         * an engine, they should use the specs at the top level.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpec data_store_specs = 7;
         * </code>
         */
        public Builder removeDataStoreSpecs(int index) {
          if (dataStoreSpecsBuilder_ == null) {
            ensureDataStoreSpecsIsMutable();
            dataStoreSpecs_.remove(index);
            onChanged();
          } else {
            dataStoreSpecsBuilder_.remove(index);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Specs defining dataStores to filter on in a search call and
         * configurations for those dataStores. This is only considered for
         * engines with multiple dataStores use case. For single dataStore within
         * an engine, they should use the specs at the top level.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpec data_store_specs = 7;
         * </code>
         */
        public com.google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpec.Builder
            getDataStoreSpecsBuilder(int index) {
          return getDataStoreSpecsFieldBuilder().getBuilder(index);
        }
        /**
         *
         *
         * <pre>
         * Specs defining dataStores to filter on in a search call and
         * configurations for those dataStores. This is only considered for
         * engines with multiple dataStores use case. For single dataStore within
         * an engine, they should use the specs at the top level.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpec data_store_specs = 7;
         * </code>
         */
        public com.google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpecOrBuilder
            getDataStoreSpecsOrBuilder(int index) {
          if (dataStoreSpecsBuilder_ == null) {
            return dataStoreSpecs_.get(index);
          } else {
            return dataStoreSpecsBuilder_.getMessageOrBuilder(index);
          }
        }
        /**
         *
         *
         * <pre>
         * Specs defining dataStores to filter on in a search call and
         * configurations for those dataStores. This is only considered for
         * engines with multiple dataStores use case. For single dataStore within
         * an engine, they should use the specs at the top level.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpec data_store_specs = 7;
         * </code>
         */
        public java.util.List<
                ? extends
                    com.google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpecOrBuilder>
            getDataStoreSpecsOrBuilderList() {
          if (dataStoreSpecsBuilder_ != null) {
            return dataStoreSpecsBuilder_.getMessageOrBuilderList();
          } else {
            return java.util.Collections.unmodifiableList(dataStoreSpecs_);
          }
        }
        /**
         *
         *
         * <pre>
         * Specs defining dataStores to filter on in a search call and
         * configurations for those dataStores. This is only considered for
         * engines with multiple dataStores use case. For single dataStore within
         * an engine, they should use the specs at the top level.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpec data_store_specs = 7;
         * </code>
         */
        public com.google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpec.Builder
            addDataStoreSpecsBuilder() {
          return getDataStoreSpecsFieldBuilder()
              .addBuilder(
                  com.google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpec
                      .getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * Specs defining dataStores to filter on in a search call and
         * configurations for those dataStores. This is only considered for
         * engines with multiple dataStores use case. For single dataStore within
         * an engine, they should use the specs at the top level.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpec data_store_specs = 7;
         * </code>
         */
        public com.google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpec.Builder
            addDataStoreSpecsBuilder(int index) {
          return getDataStoreSpecsFieldBuilder()
              .addBuilder(
                  index,
                  com.google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpec
                      .getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * Specs defining dataStores to filter on in a search call and
         * configurations for those dataStores. This is only considered for
         * engines with multiple dataStores use case. For single dataStore within
         * an engine, they should use the specs at the top level.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpec data_store_specs = 7;
         * </code>
         */
        public java.util.List<
                com.google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpec.Builder>
            getDataStoreSpecsBuilderList() {
          return getDataStoreSpecsFieldBuilder().getBuilderList();
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpec,
                com.google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpec.Builder,
                com.google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpecOrBuilder>
            getDataStoreSpecsFieldBuilder() {
          if (dataStoreSpecsBuilder_ == null) {
            dataStoreSpecsBuilder_ =
                new com.google.protobuf.RepeatedFieldBuilderV3<
                    com.google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpec,
                    com.google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpec.Builder,
                    com.google.cloud.discoveryengine.v1beta.SearchRequest.DataStoreSpecOrBuilder>(
                    dataStoreSpecs_,
                    ((bitField0_ & 0x00000020) != 0),
                    getParentForChildren(),
                    isClean());
            dataStoreSpecs_ = null;
          }
          return dataStoreSpecsBuilder_;
        }

        private com.google.cloud.discoveryengine.v1beta.SearchRequest
                .NaturalLanguageQueryUnderstandingSpec
            naturalLanguageQueryUnderstandingSpec_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1beta.SearchRequest
                    .NaturalLanguageQueryUnderstandingSpec,
                com.google.cloud.discoveryengine.v1beta.SearchRequest
                    .NaturalLanguageQueryUnderstandingSpec.Builder,
                com.google.cloud.discoveryengine.v1beta.SearchRequest
                    .NaturalLanguageQueryUnderstandingSpecOrBuilder>
            naturalLanguageQueryUnderstandingSpecBuilder_;
        /**
         *
         *
         * <pre>
         * Optional. Specification to enable natural language understanding
         * capabilities for search requests.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.SearchRequest.NaturalLanguageQueryUnderstandingSpec natural_language_query_understanding_spec = 8 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return Whether the naturalLanguageQueryUnderstandingSpec field is set.
         */
        public boolean hasNaturalLanguageQueryUnderstandingSpec() {
          return ((bitField0_ & 0x00000040) != 0);
        }
        /**
         *
         *
         * <pre>
         * Optional. Specification to enable natural language understanding
         * capabilities for search requests.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.SearchRequest.NaturalLanguageQueryUnderstandingSpec natural_language_query_understanding_spec = 8 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return The naturalLanguageQueryUnderstandingSpec.
         */
        public com.google.cloud.discoveryengine.v1beta.SearchRequest
                .NaturalLanguageQueryUnderstandingSpec
            getNaturalLanguageQueryUnderstandingSpec() {
          if (naturalLanguageQueryUnderstandingSpecBuilder_ == null) {
            return naturalLanguageQueryUnderstandingSpec_ == null
                ? com.google.cloud.discoveryengine.v1beta.SearchRequest
                    .NaturalLanguageQueryUnderstandingSpec.getDefaultInstance()
                : naturalLanguageQueryUnderstandingSpec_;
          } else {
            return naturalLanguageQueryUnderstandingSpecBuilder_.getMessage();
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. Specification to enable natural language understanding
         * capabilities for search requests.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.SearchRequest.NaturalLanguageQueryUnderstandingSpec natural_language_query_understanding_spec = 8 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder setNaturalLanguageQueryUnderstandingSpec(
            com.google.cloud.discoveryengine.v1beta.SearchRequest
                    .NaturalLanguageQueryUnderstandingSpec
                value) {
          if (naturalLanguageQueryUnderstandingSpecBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            naturalLanguageQueryUnderstandingSpec_ = value;
          } else {
            naturalLanguageQueryUnderstandingSpecBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000040;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. Specification to enable natural language understanding
         * capabilities for search requests.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.SearchRequest.NaturalLanguageQueryUnderstandingSpec natural_language_query_understanding_spec = 8 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder setNaturalLanguageQueryUnderstandingSpec(
            com.google.cloud.discoveryengine.v1beta.SearchRequest
                    .NaturalLanguageQueryUnderstandingSpec.Builder
                builderForValue) {
          if (naturalLanguageQueryUnderstandingSpecBuilder_ == null) {
            naturalLanguageQueryUnderstandingSpec_ = builderForValue.build();
          } else {
            naturalLanguageQueryUnderstandingSpecBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000040;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. Specification to enable natural language understanding
         * capabilities for search requests.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.SearchRequest.NaturalLanguageQueryUnderstandingSpec natural_language_query_understanding_spec = 8 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder mergeNaturalLanguageQueryUnderstandingSpec(
            com.google.cloud.discoveryengine.v1beta.SearchRequest
                    .NaturalLanguageQueryUnderstandingSpec
                value) {
          if (naturalLanguageQueryUnderstandingSpecBuilder_ == null) {
            if (((bitField0_ & 0x00000040) != 0)
                && naturalLanguageQueryUnderstandingSpec_ != null
                && naturalLanguageQueryUnderstandingSpec_
                    != com.google.cloud.discoveryengine.v1beta.SearchRequest
                        .NaturalLanguageQueryUnderstandingSpec.getDefaultInstance()) {
              getNaturalLanguageQueryUnderstandingSpecBuilder().mergeFrom(value);
            } else {
              naturalLanguageQueryUnderstandingSpec_ = value;
            }
          } else {
            naturalLanguageQueryUnderstandingSpecBuilder_.mergeFrom(value);
          }
          if (naturalLanguageQueryUnderstandingSpec_ != null) {
            bitField0_ |= 0x00000040;
            onChanged();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. Specification to enable natural language understanding
         * capabilities for search requests.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.SearchRequest.NaturalLanguageQueryUnderstandingSpec natural_language_query_understanding_spec = 8 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder clearNaturalLanguageQueryUnderstandingSpec() {
          bitField0_ = (bitField0_ & ~0x00000040);
          naturalLanguageQueryUnderstandingSpec_ = null;
          if (naturalLanguageQueryUnderstandingSpecBuilder_ != null) {
            naturalLanguageQueryUnderstandingSpecBuilder_.dispose();
            naturalLanguageQueryUnderstandingSpecBuilder_ = null;
          }
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. Specification to enable natural language understanding
         * capabilities for search requests.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.SearchRequest.NaturalLanguageQueryUnderstandingSpec natural_language_query_understanding_spec = 8 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public com.google.cloud.discoveryengine.v1beta.SearchRequest
                .NaturalLanguageQueryUnderstandingSpec.Builder
            getNaturalLanguageQueryUnderstandingSpecBuilder() {
          bitField0_ |= 0x00000040;
          onChanged();
          return getNaturalLanguageQueryUnderstandingSpecFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * Optional. Specification to enable natural language understanding
         * capabilities for search requests.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.SearchRequest.NaturalLanguageQueryUnderstandingSpec natural_language_query_understanding_spec = 8 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public com.google.cloud.discoveryengine.v1beta.SearchRequest
                .NaturalLanguageQueryUnderstandingSpecOrBuilder
            getNaturalLanguageQueryUnderstandingSpecOrBuilder() {
          if (naturalLanguageQueryUnderstandingSpecBuilder_ != null) {
            return naturalLanguageQueryUnderstandingSpecBuilder_.getMessageOrBuilder();
          } else {
            return naturalLanguageQueryUnderstandingSpec_ == null
                ? com.google.cloud.discoveryengine.v1beta.SearchRequest
                    .NaturalLanguageQueryUnderstandingSpec.getDefaultInstance()
                : naturalLanguageQueryUnderstandingSpec_;
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. Specification to enable natural language understanding
         * capabilities for search requests.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.SearchRequest.NaturalLanguageQueryUnderstandingSpec natural_language_query_understanding_spec = 8 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1beta.SearchRequest
                    .NaturalLanguageQueryUnderstandingSpec,
                com.google.cloud.discoveryengine.v1beta.SearchRequest
                    .NaturalLanguageQueryUnderstandingSpec.Builder,
                com.google.cloud.discoveryengine.v1beta.SearchRequest
                    .NaturalLanguageQueryUnderstandingSpecOrBuilder>
            getNaturalLanguageQueryUnderstandingSpecFieldBuilder() {
          if (naturalLanguageQueryUnderstandingSpecBuilder_ == null) {
            naturalLanguageQueryUnderstandingSpecBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.discoveryengine.v1beta.SearchRequest
                        .NaturalLanguageQueryUnderstandingSpec,
                    com.google.cloud.discoveryengine.v1beta.SearchRequest
                        .NaturalLanguageQueryUnderstandingSpec.Builder,
                    com.google.cloud.discoveryengine.v1beta.SearchRequest
                        .NaturalLanguageQueryUnderstandingSpecOrBuilder>(
                    getNaturalLanguageQueryUnderstandingSpec(), getParentForChildren(), isClean());
            naturalLanguageQueryUnderstandingSpec_ = null;
          }
          return naturalLanguageQueryUnderstandingSpecBuilder_;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchParams)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchParams)
      private static final com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
              .SearchParams
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                .SearchParams();
      }

      public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
              .SearchParams
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<SearchParams> PARSER =
          new com.google.protobuf.AbstractParser<SearchParams>() {
            @java.lang.Override
            public SearchParams parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<SearchParams> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<SearchParams> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchParams
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface SearchResultListOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Search results.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult search_results = 1;
       * </code>
       */
      java.util.List<
              com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList
                  .SearchResult>
          getSearchResultsList();
      /**
       *
       *
       * <pre>
       * Search results.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult search_results = 1;
       * </code>
       */
      com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList
              .SearchResult
          getSearchResults(int index);
      /**
       *
       *
       * <pre>
       * Search results.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult search_results = 1;
       * </code>
       */
      int getSearchResultsCount();
      /**
       *
       *
       * <pre>
       * Search results.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult search_results = 1;
       * </code>
       */
      java.util.List<
              ? extends
                  com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                      .SearchResultList.SearchResultOrBuilder>
          getSearchResultsOrBuilderList();
      /**
       *
       *
       * <pre>
       * Search results.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult search_results = 1;
       * </code>
       */
      com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList
              .SearchResultOrBuilder
          getSearchResultsOrBuilder(int index);
    }
    /**
     *
     *
     * <pre>
     * Search result list.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList}
     */
    public static final class SearchResultList extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList)
        SearchResultListOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use SearchResultList.newBuilder() to construct.
      private SearchResultList(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private SearchResultList() {
        searchResults_ = java.util.Collections.emptyList();
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new SearchResultList();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1beta.ConversationalSearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_AnswerQueryRequest_SearchSpec_SearchResultList_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1beta.ConversationalSearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_AnswerQueryRequest_SearchSpec_SearchResultList_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                    .SearchResultList.class,
                com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                    .SearchResultList.Builder.class);
      }

      public interface SearchResultOrBuilder
          extends
          // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult)
          com.google.protobuf.MessageOrBuilder {

        /**
         *
         *
         * <pre>
         * Unstructured document information.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo unstructured_document_info = 1;
         * </code>
         *
         * @return Whether the unstructuredDocumentInfo field is set.
         */
        boolean hasUnstructuredDocumentInfo();
        /**
         *
         *
         * <pre>
         * Unstructured document information.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo unstructured_document_info = 1;
         * </code>
         *
         * @return The unstructuredDocumentInfo.
         */
        com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList
                .SearchResult.UnstructuredDocumentInfo
            getUnstructuredDocumentInfo();
        /**
         *
         *
         * <pre>
         * Unstructured document information.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo unstructured_document_info = 1;
         * </code>
         */
        com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList
                .SearchResult.UnstructuredDocumentInfoOrBuilder
            getUnstructuredDocumentInfoOrBuilder();

        /**
         *
         *
         * <pre>
         * Chunk information.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.ChunkInfo chunk_info = 2;
         * </code>
         *
         * @return Whether the chunkInfo field is set.
         */
        boolean hasChunkInfo();
        /**
         *
         *
         * <pre>
         * Chunk information.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.ChunkInfo chunk_info = 2;
         * </code>
         *
         * @return The chunkInfo.
         */
        com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList
                .SearchResult.ChunkInfo
            getChunkInfo();
        /**
         *
         *
         * <pre>
         * Chunk information.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.ChunkInfo chunk_info = 2;
         * </code>
         */
        com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList
                .SearchResult.ChunkInfoOrBuilder
            getChunkInfoOrBuilder();

        com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList
                .SearchResult.ContentCase
            getContentCase();
      }
      /**
       *
       *
       * <pre>
       * Search result.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult}
       */
      public static final class SearchResult extends com.google.protobuf.GeneratedMessageV3
          implements
          // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult)
          SearchResultOrBuilder {
        private static final long serialVersionUID = 0L;
        // Use SearchResult.newBuilder() to construct.
        private SearchResult(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
          super(builder);
        }

        private SearchResult() {}

        @java.lang.Override
        @SuppressWarnings({"unused"})
        protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
          return new SearchResult();
        }

        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.discoveryengine.v1beta.ConversationalSearchServiceProto
              .internal_static_google_cloud_discoveryengine_v1beta_AnswerQueryRequest_SearchSpec_SearchResultList_SearchResult_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.discoveryengine.v1beta.ConversationalSearchServiceProto
              .internal_static_google_cloud_discoveryengine_v1beta_AnswerQueryRequest_SearchSpec_SearchResultList_SearchResult_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                      .SearchResultList.SearchResult.class,
                  com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                      .SearchResultList.SearchResult.Builder.class);
        }

        public interface UnstructuredDocumentInfoOrBuilder
            extends
            // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo)
            com.google.protobuf.MessageOrBuilder {

          /**
           *
           *
           * <pre>
           * Document resource name.
           * </pre>
           *
           * <code>string document = 1 [(.google.api.resource_reference) = { ... }</code>
           *
           * @return The document.
           */
          java.lang.String getDocument();
          /**
           *
           *
           * <pre>
           * Document resource name.
           * </pre>
           *
           * <code>string document = 1 [(.google.api.resource_reference) = { ... }</code>
           *
           * @return The bytes for document.
           */
          com.google.protobuf.ByteString getDocumentBytes();

          /**
           *
           *
           * <pre>
           * URI for the document.
           * </pre>
           *
           * <code>string uri = 2;</code>
           *
           * @return The uri.
           */
          java.lang.String getUri();
          /**
           *
           *
           * <pre>
           * URI for the document.
           * </pre>
           *
           * <code>string uri = 2;</code>
           *
           * @return The bytes for uri.
           */
          com.google.protobuf.ByteString getUriBytes();

          /**
           *
           *
           * <pre>
           * Title.
           * </pre>
           *
           * <code>string title = 3;</code>
           *
           * @return The title.
           */
          java.lang.String getTitle();
          /**
           *
           *
           * <pre>
           * Title.
           * </pre>
           *
           * <code>string title = 3;</code>
           *
           * @return The bytes for title.
           */
          com.google.protobuf.ByteString getTitleBytes();

          /**
           *
           *
           * <pre>
           * List of document contexts. The content will be used for Answer
           * Generation. This is supposed to be the main content of the document
           * that can be long and comprehensive.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo.DocumentContext document_contexts = 4;
           * </code>
           */
          java.util.List<
                  com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                      .SearchResultList.SearchResult.UnstructuredDocumentInfo.DocumentContext>
              getDocumentContextsList();
          /**
           *
           *
           * <pre>
           * List of document contexts. The content will be used for Answer
           * Generation. This is supposed to be the main content of the document
           * that can be long and comprehensive.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo.DocumentContext document_contexts = 4;
           * </code>
           */
          com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList
                  .SearchResult.UnstructuredDocumentInfo.DocumentContext
              getDocumentContexts(int index);
          /**
           *
           *
           * <pre>
           * List of document contexts. The content will be used for Answer
           * Generation. This is supposed to be the main content of the document
           * that can be long and comprehensive.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo.DocumentContext document_contexts = 4;
           * </code>
           */
          int getDocumentContextsCount();
          /**
           *
           *
           * <pre>
           * List of document contexts. The content will be used for Answer
           * Generation. This is supposed to be the main content of the document
           * that can be long and comprehensive.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo.DocumentContext document_contexts = 4;
           * </code>
           */
          java.util.List<
                  ? extends
                      com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                          .SearchResultList.SearchResult.UnstructuredDocumentInfo
                          .DocumentContextOrBuilder>
              getDocumentContextsOrBuilderList();
          /**
           *
           *
           * <pre>
           * List of document contexts. The content will be used for Answer
           * Generation. This is supposed to be the main content of the document
           * that can be long and comprehensive.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo.DocumentContext document_contexts = 4;
           * </code>
           */
          com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList
                  .SearchResult.UnstructuredDocumentInfo.DocumentContextOrBuilder
              getDocumentContextsOrBuilder(int index);

          /**
           *
           *
           * <pre>
           * List of extractive segments.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveSegment extractive_segments = 5;
           * </code>
           */
          java.util.List<
                  com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                      .SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveSegment>
              getExtractiveSegmentsList();
          /**
           *
           *
           * <pre>
           * List of extractive segments.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveSegment extractive_segments = 5;
           * </code>
           */
          com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList
                  .SearchResult.UnstructuredDocumentInfo.ExtractiveSegment
              getExtractiveSegments(int index);
          /**
           *
           *
           * <pre>
           * List of extractive segments.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveSegment extractive_segments = 5;
           * </code>
           */
          int getExtractiveSegmentsCount();
          /**
           *
           *
           * <pre>
           * List of extractive segments.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveSegment extractive_segments = 5;
           * </code>
           */
          java.util.List<
                  ? extends
                      com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                          .SearchResultList.SearchResult.UnstructuredDocumentInfo
                          .ExtractiveSegmentOrBuilder>
              getExtractiveSegmentsOrBuilderList();
          /**
           *
           *
           * <pre>
           * List of extractive segments.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveSegment extractive_segments = 5;
           * </code>
           */
          com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList
                  .SearchResult.UnstructuredDocumentInfo.ExtractiveSegmentOrBuilder
              getExtractiveSegmentsOrBuilder(int index);

          /**
           *
           *
           * <pre>
           * Deprecated: This field is deprecated and will have no effect on
           * the Answer generation.
           * Please use document_contexts and extractive_segments fields.
           * List of extractive answers.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveAnswer extractive_answers = 6 [deprecated = true];
           * </code>
           */
          @java.lang.Deprecated
          java.util.List<
                  com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                      .SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveAnswer>
              getExtractiveAnswersList();
          /**
           *
           *
           * <pre>
           * Deprecated: This field is deprecated and will have no effect on
           * the Answer generation.
           * Please use document_contexts and extractive_segments fields.
           * List of extractive answers.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveAnswer extractive_answers = 6 [deprecated = true];
           * </code>
           */
          @java.lang.Deprecated
          com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList
                  .SearchResult.UnstructuredDocumentInfo.ExtractiveAnswer
              getExtractiveAnswers(int index);
          /**
           *
           *
           * <pre>
           * Deprecated: This field is deprecated and will have no effect on
           * the Answer generation.
           * Please use document_contexts and extractive_segments fields.
           * List of extractive answers.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveAnswer extractive_answers = 6 [deprecated = true];
           * </code>
           */
          @java.lang.Deprecated
          int getExtractiveAnswersCount();
          /**
           *
           *
           * <pre>
           * Deprecated: This field is deprecated and will have no effect on
           * the Answer generation.
           * Please use document_contexts and extractive_segments fields.
           * List of extractive answers.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveAnswer extractive_answers = 6 [deprecated = true];
           * </code>
           */
          @java.lang.Deprecated
          java.util.List<
                  ? extends
                      com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                          .SearchResultList.SearchResult.UnstructuredDocumentInfo
                          .ExtractiveAnswerOrBuilder>
              getExtractiveAnswersOrBuilderList();
          /**
           *
           *
           * <pre>
           * Deprecated: This field is deprecated and will have no effect on
           * the Answer generation.
           * Please use document_contexts and extractive_segments fields.
           * List of extractive answers.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveAnswer extractive_answers = 6 [deprecated = true];
           * </code>
           */
          @java.lang.Deprecated
          com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList
                  .SearchResult.UnstructuredDocumentInfo.ExtractiveAnswerOrBuilder
              getExtractiveAnswersOrBuilder(int index);
        }
        /**
         *
         *
         * <pre>
         * Unstructured document information.
         * </pre>
         *
         * Protobuf type {@code
         * google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo}
         */
        public static final class UnstructuredDocumentInfo
            extends com.google.protobuf.GeneratedMessageV3
            implements
            // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo)
            UnstructuredDocumentInfoOrBuilder {
          private static final long serialVersionUID = 0L;
          // Use UnstructuredDocumentInfo.newBuilder() to construct.
          private UnstructuredDocumentInfo(
              com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
            super(builder);
          }

          private UnstructuredDocumentInfo() {
            document_ = "";
            uri_ = "";
            title_ = "";
            documentContexts_ = java.util.Collections.emptyList();
            extractiveSegments_ = java.util.Collections.emptyList();
            extractiveAnswers_ = java.util.Collections.emptyList();
          }

          @java.lang.Override
          @SuppressWarnings({"unused"})
          protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
            return new UnstructuredDocumentInfo();
          }

          public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
            return com.google.cloud.discoveryengine.v1beta.ConversationalSearchServiceProto
                .internal_static_google_cloud_discoveryengine_v1beta_AnswerQueryRequest_SearchSpec_SearchResultList_SearchResult_UnstructuredDocumentInfo_descriptor;
          }

          @java.lang.Override
          protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
              internalGetFieldAccessorTable() {
            return com.google.cloud.discoveryengine.v1beta.ConversationalSearchServiceProto
                .internal_static_google_cloud_discoveryengine_v1beta_AnswerQueryRequest_SearchSpec_SearchResultList_SearchResult_UnstructuredDocumentInfo_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                        .SearchResultList.SearchResult.UnstructuredDocumentInfo.class,
                    com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                        .SearchResultList.SearchResult.UnstructuredDocumentInfo.Builder.class);
          }

          public interface DocumentContextOrBuilder
              extends
              // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo.DocumentContext)
              com.google.protobuf.MessageOrBuilder {

            /**
             *
             *
             * <pre>
             * Page identifier.
             * </pre>
             *
             * <code>string page_identifier = 1;</code>
             *
             * @return The pageIdentifier.
             */
            java.lang.String getPageIdentifier();
            /**
             *
             *
             * <pre>
             * Page identifier.
             * </pre>
             *
             * <code>string page_identifier = 1;</code>
             *
             * @return The bytes for pageIdentifier.
             */
            com.google.protobuf.ByteString getPageIdentifierBytes();

            /**
             *
             *
             * <pre>
             * Document content to be used for answer generation.
             * </pre>
             *
             * <code>string content = 2;</code>
             *
             * @return The content.
             */
            java.lang.String getContent();
            /**
             *
             *
             * <pre>
             * Document content to be used for answer generation.
             * </pre>
             *
             * <code>string content = 2;</code>
             *
             * @return The bytes for content.
             */
            com.google.protobuf.ByteString getContentBytes();
          }
          /**
           *
           *
           * <pre>
           * Document context.
           * </pre>
           *
           * Protobuf type {@code
           * google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo.DocumentContext}
           */
          public static final class DocumentContext extends com.google.protobuf.GeneratedMessageV3
              implements
              // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo.DocumentContext)
              DocumentContextOrBuilder {
            private static final long serialVersionUID = 0L;
            // Use DocumentContext.newBuilder() to construct.
            private DocumentContext(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
              super(builder);
            }

            private DocumentContext() {
              pageIdentifier_ = "";
              content_ = "";
            }

            @java.lang.Override
            @SuppressWarnings({"unused"})
            protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
              return new DocumentContext();
            }

            public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
              return com.google.cloud.discoveryengine.v1beta.ConversationalSearchServiceProto
                  .internal_static_google_cloud_discoveryengine_v1beta_AnswerQueryRequest_SearchSpec_SearchResultList_SearchResult_UnstructuredDocumentInfo_DocumentContext_descriptor;
            }

            @java.lang.Override
            protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
                internalGetFieldAccessorTable() {
              return com.google.cloud.discoveryengine.v1beta.ConversationalSearchServiceProto
                  .internal_static_google_cloud_discoveryengine_v1beta_AnswerQueryRequest_SearchSpec_SearchResultList_SearchResult_UnstructuredDocumentInfo_DocumentContext_fieldAccessorTable
                  .ensureFieldAccessorsInitialized(
                      com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                          .SearchResultList.SearchResult.UnstructuredDocumentInfo.DocumentContext
                          .class,
                      com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                          .SearchResultList.SearchResult.UnstructuredDocumentInfo.DocumentContext
                          .Builder.class);
            }

            public static final int PAGE_IDENTIFIER_FIELD_NUMBER = 1;

            @SuppressWarnings("serial")
            private volatile java.lang.Object pageIdentifier_ = "";
            /**
             *
             *
             * <pre>
             * Page identifier.
             * </pre>
             *
             * <code>string page_identifier = 1;</code>
             *
             * @return The pageIdentifier.
             */
            @java.lang.Override
            public java.lang.String getPageIdentifier() {
              java.lang.Object ref = pageIdentifier_;
              if (ref instanceof java.lang.String) {
                return (java.lang.String) ref;
              } else {
                com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
                java.lang.String s = bs.toStringUtf8();
                pageIdentifier_ = s;
                return s;
              }
            }
            /**
             *
             *
             * <pre>
             * Page identifier.
             * </pre>
             *
             * <code>string page_identifier = 1;</code>
             *
             * @return The bytes for pageIdentifier.
             */
            @java.lang.Override
            public com.google.protobuf.ByteString getPageIdentifierBytes() {
              java.lang.Object ref = pageIdentifier_;
              if (ref instanceof java.lang.String) {
                com.google.protobuf.ByteString b =
                    com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
                pageIdentifier_ = b;
                return b;
              } else {
                return (com.google.protobuf.ByteString) ref;
              }
            }

            public static final int CONTENT_FIELD_NUMBER = 2;

            @SuppressWarnings("serial")
            private volatile java.lang.Object content_ = "";
            /**
             *
             *
             * <pre>
             * Document content to be used for answer generation.
             * </pre>
             *
             * <code>string content = 2;</code>
             *
             * @return The content.
             */
            @java.lang.Override
            public java.lang.String getContent() {
              java.lang.Object ref = content_;
              if (ref instanceof java.lang.String) {
                return (java.lang.String) ref;
              } else {
                com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
                java.lang.String s = bs.toStringUtf8();
                content_ = s;
                return s;
              }
            }
            /**
             *
             *
             * <pre>
             * Document content to be used for answer generation.
             * </pre>
             *
             * <code>string content = 2;</code>
             *
             * @return The bytes for content.
             */
            @java.lang.Override
            public com.google.protobuf.ByteString getContentBytes() {
              java.lang.Object ref = content_;
              if (ref instanceof java.lang.String) {
                com.google.protobuf.ByteString b =
                    com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
                content_ = b;
                return b;
              } else {
                return (com.google.protobuf.ByteString) ref;
              }
            }

            private byte memoizedIsInitialized = -1;

            @java.lang.Override
            public final boolean isInitialized() {
              byte isInitialized = memoizedIsInitialized;
              if (isInitialized == 1) return true;
              if (isInitialized == 0) return false;

              memoizedIsInitialized = 1;
              return true;
            }

            @java.lang.Override
            public void writeTo(com.google.protobuf.CodedOutputStream output)
                throws java.io.IOException {
              if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pageIdentifier_)) {
                com.google.protobuf.GeneratedMessageV3.writeString(output, 1, pageIdentifier_);
              }
              if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(content_)) {
                com.google.protobuf.GeneratedMessageV3.writeString(output, 2, content_);
              }
              getUnknownFields().writeTo(output);
            }

            @java.lang.Override
            public int getSerializedSize() {
              int size = memoizedSize;
              if (size != -1) return size;

              size = 0;
              if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pageIdentifier_)) {
                size +=
                    com.google.protobuf.GeneratedMessageV3.computeStringSize(1, pageIdentifier_);
              }
              if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(content_)) {
                size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, content_);
              }
              size += getUnknownFields().getSerializedSize();
              memoizedSize = size;
              return size;
            }

            @java.lang.Override
            public boolean equals(final java.lang.Object obj) {
              if (obj == this) {
                return true;
              }
              if (!(obj
                  instanceof
                  com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                      .SearchResultList.SearchResult.UnstructuredDocumentInfo.DocumentContext)) {
                return super.equals(obj);
              }
              com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList
                      .SearchResult.UnstructuredDocumentInfo.DocumentContext
                  other =
                      (com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                              .SearchResultList.SearchResult.UnstructuredDocumentInfo
                              .DocumentContext)
                          obj;

              if (!getPageIdentifier().equals(other.getPageIdentifier())) return false;
              if (!getContent().equals(other.getContent())) return false;
              if (!getUnknownFields().equals(other.getUnknownFields())) return false;
              return true;
            }

            @java.lang.Override
            public int hashCode() {
              if (memoizedHashCode != 0) {
                return memoizedHashCode;
              }
              int hash = 41;
              hash = (19 * hash) + getDescriptor().hashCode();
              hash = (37 * hash) + PAGE_IDENTIFIER_FIELD_NUMBER;
              hash = (53 * hash) + getPageIdentifier().hashCode();
              hash = (37 * hash) + CONTENT_FIELD_NUMBER;
              hash = (53 * hash) + getContent().hashCode();
              hash = (29 * hash) + getUnknownFields().hashCode();
              memoizedHashCode = hash;
              return hash;
            }

            public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                    .SearchResultList.SearchResult.UnstructuredDocumentInfo.DocumentContext
                parseFrom(java.nio.ByteBuffer data)
                    throws com.google.protobuf.InvalidProtocolBufferException {
              return PARSER.parseFrom(data);
            }

            public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                    .SearchResultList.SearchResult.UnstructuredDocumentInfo.DocumentContext
                parseFrom(
                    java.nio.ByteBuffer data,
                    com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                    throws com.google.protobuf.InvalidProtocolBufferException {
              return PARSER.parseFrom(data, extensionRegistry);
            }

            public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                    .SearchResultList.SearchResult.UnstructuredDocumentInfo.DocumentContext
                parseFrom(com.google.protobuf.ByteString data)
                    throws com.google.protobuf.InvalidProtocolBufferException {
              return PARSER.parseFrom(data);
            }

            public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                    .SearchResultList.SearchResult.UnstructuredDocumentInfo.DocumentContext
                parseFrom(
                    com.google.protobuf.ByteString data,
                    com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                    throws com.google.protobuf.InvalidProtocolBufferException {
              return PARSER.parseFrom(data, extensionRegistry);
            }

            public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                    .SearchResultList.SearchResult.UnstructuredDocumentInfo.DocumentContext
                parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
              return PARSER.parseFrom(data);
            }

            public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                    .SearchResultList.SearchResult.UnstructuredDocumentInfo.DocumentContext
                parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                    throws com.google.protobuf.InvalidProtocolBufferException {
              return PARSER.parseFrom(data, extensionRegistry);
            }

            public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                    .SearchResultList.SearchResult.UnstructuredDocumentInfo.DocumentContext
                parseFrom(java.io.InputStream input) throws java.io.IOException {
              return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
            }

            public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                    .SearchResultList.SearchResult.UnstructuredDocumentInfo.DocumentContext
                parseFrom(
                    java.io.InputStream input,
                    com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                    throws java.io.IOException {
              return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
                  PARSER, input, extensionRegistry);
            }

            public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                    .SearchResultList.SearchResult.UnstructuredDocumentInfo.DocumentContext
                parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
              return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
                  PARSER, input);
            }

            public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                    .SearchResultList.SearchResult.UnstructuredDocumentInfo.DocumentContext
                parseDelimitedFrom(
                    java.io.InputStream input,
                    com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                    throws java.io.IOException {
              return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
                  PARSER, input, extensionRegistry);
            }

            public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                    .SearchResultList.SearchResult.UnstructuredDocumentInfo.DocumentContext
                parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
              return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
            }

            public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                    .SearchResultList.SearchResult.UnstructuredDocumentInfo.DocumentContext
                parseFrom(
                    com.google.protobuf.CodedInputStream input,
                    com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                    throws java.io.IOException {
              return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
                  PARSER, input, extensionRegistry);
            }

            @java.lang.Override
            public Builder newBuilderForType() {
              return newBuilder();
            }

            public static Builder newBuilder() {
              return DEFAULT_INSTANCE.toBuilder();
            }

            public static Builder newBuilder(
                com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                        .SearchResultList.SearchResult.UnstructuredDocumentInfo.DocumentContext
                    prototype) {
              return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
            }

            @java.lang.Override
            public Builder toBuilder() {
              return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
            }

            @java.lang.Override
            protected Builder newBuilderForType(
                com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
              Builder builder = new Builder(parent);
              return builder;
            }
            /**
             *
             *
             * <pre>
             * Document context.
             * </pre>
             *
             * Protobuf type {@code
             * google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo.DocumentContext}
             */
            public static final class Builder
                extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
                implements
                // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo.DocumentContext)
                com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                    .SearchResultList.SearchResult.UnstructuredDocumentInfo
                    .DocumentContextOrBuilder {
              public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
                return com.google.cloud.discoveryengine.v1beta.ConversationalSearchServiceProto
                    .internal_static_google_cloud_discoveryengine_v1beta_AnswerQueryRequest_SearchSpec_SearchResultList_SearchResult_UnstructuredDocumentInfo_DocumentContext_descriptor;
              }

              @java.lang.Override
              protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
                  internalGetFieldAccessorTable() {
                return com.google.cloud.discoveryengine.v1beta.ConversationalSearchServiceProto
                    .internal_static_google_cloud_discoveryengine_v1beta_AnswerQueryRequest_SearchSpec_SearchResultList_SearchResult_UnstructuredDocumentInfo_DocumentContext_fieldAccessorTable
                    .ensureFieldAccessorsInitialized(
                        com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                            .SearchResultList.SearchResult.UnstructuredDocumentInfo.DocumentContext
                            .class,
                        com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                            .SearchResultList.SearchResult.UnstructuredDocumentInfo.DocumentContext
                            .Builder.class);
              }

              // Construct using
              // com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo.DocumentContext.newBuilder()
              private Builder() {}

              private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
                super(parent);
              }

              @java.lang.Override
              public Builder clear() {
                super.clear();
                bitField0_ = 0;
                pageIdentifier_ = "";
                content_ = "";
                return this;
              }

              @java.lang.Override
              public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
                return com.google.cloud.discoveryengine.v1beta.ConversationalSearchServiceProto
                    .internal_static_google_cloud_discoveryengine_v1beta_AnswerQueryRequest_SearchSpec_SearchResultList_SearchResult_UnstructuredDocumentInfo_DocumentContext_descriptor;
              }

              @java.lang.Override
              public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                      .SearchResultList.SearchResult.UnstructuredDocumentInfo.DocumentContext
                  getDefaultInstanceForType() {
                return com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                    .SearchResultList.SearchResult.UnstructuredDocumentInfo.DocumentContext
                    .getDefaultInstance();
              }

              @java.lang.Override
              public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                      .SearchResultList.SearchResult.UnstructuredDocumentInfo.DocumentContext
                  build() {
                com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                        .SearchResultList.SearchResult.UnstructuredDocumentInfo.DocumentContext
                    result = buildPartial();
                if (!result.isInitialized()) {
                  throw newUninitializedMessageException(result);
                }
                return result;
              }

              @java.lang.Override
              public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                      .SearchResultList.SearchResult.UnstructuredDocumentInfo.DocumentContext
                  buildPartial() {
                com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                        .SearchResultList.SearchResult.UnstructuredDocumentInfo.DocumentContext
                    result =
                        new com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                            .SearchResultList.SearchResult.UnstructuredDocumentInfo.DocumentContext(
                            this);
                if (bitField0_ != 0) {
                  buildPartial0(result);
                }
                onBuilt();
                return result;
              }

              private void buildPartial0(
                  com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                          .SearchResultList.SearchResult.UnstructuredDocumentInfo.DocumentContext
                      result) {
                int from_bitField0_ = bitField0_;
                if (((from_bitField0_ & 0x00000001) != 0)) {
                  result.pageIdentifier_ = pageIdentifier_;
                }
                if (((from_bitField0_ & 0x00000002) != 0)) {
                  result.content_ = content_;
                }
              }

              @java.lang.Override
              public Builder clone() {
                return super.clone();
              }

              @java.lang.Override
              public Builder setField(
                  com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
                return super.setField(field, value);
              }

              @java.lang.Override
              public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
                return super.clearField(field);
              }

              @java.lang.Override
              public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
                return super.clearOneof(oneof);
              }

              @java.lang.Override
              public Builder setRepeatedField(
                  com.google.protobuf.Descriptors.FieldDescriptor field,
                  int index,
                  java.lang.Object value) {
                return super.setRepeatedField(field, index, value);
              }

              @java.lang.Override
              public Builder addRepeatedField(
                  com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
                return super.addRepeatedField(field, value);
              }

              @java.lang.Override
              public Builder mergeFrom(com.google.protobuf.Message other) {
                if (other
                    instanceof
                    com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                        .SearchResultList.SearchResult.UnstructuredDocumentInfo.DocumentContext) {
                  return mergeFrom(
                      (com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                              .SearchResultList.SearchResult.UnstructuredDocumentInfo
                              .DocumentContext)
                          other);
                } else {
                  super.mergeFrom(other);
                  return this;
                }
              }

              public Builder mergeFrom(
                  com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                          .SearchResultList.SearchResult.UnstructuredDocumentInfo.DocumentContext
                      other) {
                if (other
                    == com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                        .SearchResultList.SearchResult.UnstructuredDocumentInfo.DocumentContext
                        .getDefaultInstance()) return this;
                if (!other.getPageIdentifier().isEmpty()) {
                  pageIdentifier_ = other.pageIdentifier_;
                  bitField0_ |= 0x00000001;
                  onChanged();
                }
                if (!other.getContent().isEmpty()) {
                  content_ = other.content_;
                  bitField0_ |= 0x00000002;
                  onChanged();
                }
                this.mergeUnknownFields(other.getUnknownFields());
                onChanged();
                return this;
              }

              @java.lang.Override
              public final boolean isInitialized() {
                return true;
              }

              @java.lang.Override
              public Builder mergeFrom(
                  com.google.protobuf.CodedInputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws java.io.IOException {
                if (extensionRegistry == null) {
                  throw new java.lang.NullPointerException();
                }
                try {
                  boolean done = false;
                  while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                      case 0:
                        done = true;
                        break;
                      case 10:
                        {
                          pageIdentifier_ = input.readStringRequireUtf8();
                          bitField0_ |= 0x00000001;
                          break;
                        } // case 10
                      case 18:
                        {
                          content_ = input.readStringRequireUtf8();
                          bitField0_ |= 0x00000002;
                          break;
                        } // case 18
                      default:
                        {
                          if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                            done = true; // was an endgroup tag
                          }
                          break;
                        } // default:
                    } // switch (tag)
                  } // while (!done)
                } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                  throw e.unwrapIOException();
                } finally {
                  onChanged();
                } // finally
                return this;
              }

              private int bitField0_;

              private java.lang.Object pageIdentifier_ = "";
              /**
               *
               *
               * <pre>
               * Page identifier.
               * </pre>
               *
               * <code>string page_identifier = 1;</code>
               *
               * @return The pageIdentifier.
               */
              public java.lang.String getPageIdentifier() {
                java.lang.Object ref = pageIdentifier_;
                if (!(ref instanceof java.lang.String)) {
                  com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
                  java.lang.String s = bs.toStringUtf8();
                  pageIdentifier_ = s;
                  return s;
                } else {
                  return (java.lang.String) ref;
                }
              }
              /**
               *
               *
               * <pre>
               * Page identifier.
               * </pre>
               *
               * <code>string page_identifier = 1;</code>
               *
               * @return The bytes for pageIdentifier.
               */
              public com.google.protobuf.ByteString getPageIdentifierBytes() {
                java.lang.Object ref = pageIdentifier_;
                if (ref instanceof String) {
                  com.google.protobuf.ByteString b =
                      com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
                  pageIdentifier_ = b;
                  return b;
                } else {
                  return (com.google.protobuf.ByteString) ref;
                }
              }
              /**
               *
               *
               * <pre>
               * Page identifier.
               * </pre>
               *
               * <code>string page_identifier = 1;</code>
               *
               * @param value The pageIdentifier to set.
               * @return This builder for chaining.
               */
              public Builder setPageIdentifier(java.lang.String value) {
                if (value == null) {
                  throw new NullPointerException();
                }
                pageIdentifier_ = value;
                bitField0_ |= 0x00000001;
                onChanged();
                return this;
              }
              /**
               *
               *
               * <pre>
               * Page identifier.
               * </pre>
               *
               * <code>string page_identifier = 1;</code>
               *
               * @return This builder for chaining.
               */
              public Builder clearPageIdentifier() {
                pageIdentifier_ = getDefaultInstance().getPageIdentifier();
                bitField0_ = (bitField0_ & ~0x00000001);
                onChanged();
                return this;
              }
              /**
               *
               *
               * <pre>
               * Page identifier.
               * </pre>
               *
               * <code>string page_identifier = 1;</code>
               *
               * @param value The bytes for pageIdentifier to set.
               * @return This builder for chaining.
               */
              public Builder setPageIdentifierBytes(com.google.protobuf.ByteString value) {
                if (value == null) {
                  throw new NullPointerException();
                }
                checkByteStringIsUtf8(value);
                pageIdentifier_ = value;
                bitField0_ |= 0x00000001;
                onChanged();
                return this;
              }

              private java.lang.Object content_ = "";
              /**
               *
               *
               * <pre>
               * Document content to be used for answer generation.
               * </pre>
               *
               * <code>string content = 2;</code>
               *
               * @return The content.
               */
              public java.lang.String getContent() {
                java.lang.Object ref = content_;
                if (!(ref instanceof java.lang.String)) {
                  com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
                  java.lang.String s = bs.toStringUtf8();
                  content_ = s;
                  return s;
                } else {
                  return (java.lang.String) ref;
                }
              }
              /**
               *
               *
               * <pre>
               * Document content to be used for answer generation.
               * </pre>
               *
               * <code>string content = 2;</code>
               *
               * @return The bytes for content.
               */
              public com.google.protobuf.ByteString getContentBytes() {
                java.lang.Object ref = content_;
                if (ref instanceof String) {
                  com.google.protobuf.ByteString b =
                      com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
                  content_ = b;
                  return b;
                } else {
                  return (com.google.protobuf.ByteString) ref;
                }
              }
              /**
               *
               *
               * <pre>
               * Document content to be used for answer generation.
               * </pre>
               *
               * <code>string content = 2;</code>
               *
               * @param value The content to set.
               * @return This builder for chaining.
               */
              public Builder setContent(java.lang.String value) {
                if (value == null) {
                  throw new NullPointerException();
                }
                content_ = value;
                bitField0_ |= 0x00000002;
                onChanged();
                return this;
              }
              /**
               *
               *
               * <pre>
               * Document content to be used for answer generation.
               * </pre>
               *
               * <code>string content = 2;</code>
               *
               * @return This builder for chaining.
               */
              public Builder clearContent() {
                content_ = getDefaultInstance().getContent();
                bitField0_ = (bitField0_ & ~0x00000002);
                onChanged();
                return this;
              }
              /**
               *
               *
               * <pre>
               * Document content to be used for answer generation.
               * </pre>
               *
               * <code>string content = 2;</code>
               *
               * @param value The bytes for content to set.
               * @return This builder for chaining.
               */
              public Builder setContentBytes(com.google.protobuf.ByteString value) {
                if (value == null) {
                  throw new NullPointerException();
                }
                checkByteStringIsUtf8(value);
                content_ = value;
                bitField0_ |= 0x00000002;
                onChanged();
                return this;
              }

              @java.lang.Override
              public final Builder setUnknownFields(
                  final com.google.protobuf.UnknownFieldSet unknownFields) {
                return super.setUnknownFields(unknownFields);
              }

              @java.lang.Override
              public final Builder mergeUnknownFields(
                  final com.google.protobuf.UnknownFieldSet unknownFields) {
                return super.mergeUnknownFields(unknownFields);
              }

              // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo.DocumentContext)
            }

            // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo.DocumentContext)
            private static final com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest
                    .SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo
                    .DocumentContext
                DEFAULT_INSTANCE;

            static {
              DEFAULT_INSTANCE =
                  new com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                      .SearchResultList.SearchResult.UnstructuredDocumentInfo.DocumentContext();
            }

            public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                    .SearchResultList.SearchResult.UnstructuredDocumentInfo.DocumentContext
                getDefaultInstance() {
              return DEFAULT_INSTANCE;
            }

            private static final com.google.protobuf.Parser<DocumentContext> PARSER =
                new com.google.protobuf.AbstractParser<DocumentContext>() {
                  @java.lang.Override
                  public DocumentContext parsePartialFrom(
                      com.google.protobuf.CodedInputStream input,
                      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                      throws com.google.protobuf.InvalidProtocolBufferException {
                    Builder builder = newBuilder();
                    try {
                      builder.mergeFrom(input, extensionRegistry);
                    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                      throw e.setUnfinishedMessage(builder.buildPartial());
                    } catch (com.google.protobuf.UninitializedMessageException e) {
                      throw e.asInvalidProtocolBufferException()
                          .setUnfinishedMessage(builder.buildPartial());
                    } catch (java.io.IOException e) {
                      throw new com.google.protobuf.InvalidProtocolBufferException(e)
                          .setUnfinishedMessage(builder.buildPartial());
                    }
                    return builder.buildPartial();
                  }
                };

            public static com.google.protobuf.Parser<DocumentContext> parser() {
              return PARSER;
            }

            @java.lang.Override
            public com.google.protobuf.Parser<DocumentContext> getParserForType() {
              return PARSER;
            }

            @java.lang.Override
            public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                    .SearchResultList.SearchResult.UnstructuredDocumentInfo.DocumentContext
                getDefaultInstanceForType() {
              return DEFAULT_INSTANCE;
            }
          }

          public interface ExtractiveSegmentOrBuilder
              extends
              // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveSegment)
              com.google.protobuf.MessageOrBuilder {

            /**
             *
             *
             * <pre>
             * Page identifier.
             * </pre>
             *
             * <code>string page_identifier = 1;</code>
             *
             * @return The pageIdentifier.
             */
            java.lang.String getPageIdentifier();
            /**
             *
             *
             * <pre>
             * Page identifier.
             * </pre>
             *
             * <code>string page_identifier = 1;</code>
             *
             * @return The bytes for pageIdentifier.
             */
            com.google.protobuf.ByteString getPageIdentifierBytes();

            /**
             *
             *
             * <pre>
             * Extractive segment content.
             * </pre>
             *
             * <code>string content = 2;</code>
             *
             * @return The content.
             */
            java.lang.String getContent();
            /**
             *
             *
             * <pre>
             * Extractive segment content.
             * </pre>
             *
             * <code>string content = 2;</code>
             *
             * @return The bytes for content.
             */
            com.google.protobuf.ByteString getContentBytes();
          }
          /**
           *
           *
           * <pre>
           * Extractive segment.
           * [Guide](https://cloud.google.com/generative-ai-app-builder/docs/snippets#extractive-segments)
           * Answer generation will only use it if document_contexts is empty.
           * This is supposed to be shorter snippets.
           * </pre>
           *
           * Protobuf type {@code
           * google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveSegment}
           */
          public static final class ExtractiveSegment extends com.google.protobuf.GeneratedMessageV3
              implements
              // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveSegment)
              ExtractiveSegmentOrBuilder {
            private static final long serialVersionUID = 0L;
            // Use ExtractiveSegment.newBuilder() to construct.
            private ExtractiveSegment(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
              super(builder);
            }

            private ExtractiveSegment() {
              pageIdentifier_ = "";
              content_ = "";
            }

            @java.lang.Override
            @SuppressWarnings({"unused"})
            protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
              return new ExtractiveSegment();
            }

            public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
              return com.google.cloud.discoveryengine.v1beta.ConversationalSearchServiceProto
                  .internal_static_google_cloud_discoveryengine_v1beta_AnswerQueryRequest_SearchSpec_SearchResultList_SearchResult_UnstructuredDocumentInfo_ExtractiveSegment_descriptor;
            }

            @java.lang.Override
            protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
                internalGetFieldAccessorTable() {
              return com.google.cloud.discoveryengine.v1beta.ConversationalSearchServiceProto
                  .internal_static_google_cloud_discoveryengine_v1beta_AnswerQueryRequest_SearchSpec_SearchResultList_SearchResult_UnstructuredDocumentInfo_ExtractiveSegment_fieldAccessorTable
                  .ensureFieldAccessorsInitialized(
                      com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                          .SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveSegment
                          .class,
                      com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                          .SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveSegment
                          .Builder.class);
            }

            public static final int PAGE_IDENTIFIER_FIELD_NUMBER = 1;

            @SuppressWarnings("serial")
            private volatile java.lang.Object pageIdentifier_ = "";
            /**
             *
             *
             * <pre>
             * Page identifier.
             * </pre>
             *
             * <code>string page_identifier = 1;</code>
             *
             * @return The pageIdentifier.
             */
            @java.lang.Override
            public java.lang.String getPageIdentifier() {
              java.lang.Object ref = pageIdentifier_;
              if (ref instanceof java.lang.String) {
                return (java.lang.String) ref;
              } else {
                com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
                java.lang.String s = bs.toStringUtf8();
                pageIdentifier_ = s;
                return s;
              }
            }
            /**
             *
             *
             * <pre>
             * Page identifier.
             * </pre>
             *
             * <code>string page_identifier = 1;</code>
             *
             * @return The bytes for pageIdentifier.
             */
            @java.lang.Override
            public com.google.protobuf.ByteString getPageIdentifierBytes() {
              java.lang.Object ref = pageIdentifier_;
              if (ref instanceof java.lang.String) {
                com.google.protobuf.ByteString b =
                    com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
                pageIdentifier_ = b;
                return b;
              } else {
                return (com.google.protobuf.ByteString) ref;
              }
            }

            public static final int CONTENT_FIELD_NUMBER = 2;

            @SuppressWarnings("serial")
            private volatile java.lang.Object content_ = "";
            /**
             *
             *
             * <pre>
             * Extractive segment content.
             * </pre>
             *
             * <code>string content = 2;</code>
             *
             * @return The content.
             */
            @java.lang.Override
            public java.lang.String getContent() {
              java.lang.Object ref = content_;
              if (ref instanceof java.lang.String) {
                return (java.lang.String) ref;
              } else {
                com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
                java.lang.String s = bs.toStringUtf8();
                content_ = s;
                return s;
              }
            }
            /**
             *
             *
             * <pre>
             * Extractive segment content.
             * </pre>
             *
             * <code>string content = 2;</code>
             *
             * @return The bytes for content.
             */
            @java.lang.Override
            public com.google.protobuf.ByteString getContentBytes() {
              java.lang.Object ref = content_;
              if (ref instanceof java.lang.String) {
                com.google.protobuf.ByteString b =
                    com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
                content_ = b;
                return b;
              } else {
                return (com.google.protobuf.ByteString) ref;
              }
            }

            private byte memoizedIsInitialized = -1;

            @java.lang.Override
            public final boolean isInitialized() {
              byte isInitialized = memoizedIsInitialized;
              if (isInitialized == 1) return true;
              if (isInitialized == 0) return false;

              memoizedIsInitialized = 1;
              return true;
            }

            @java.lang.Override
            public void writeTo(com.google.protobuf.CodedOutputStream output)
                throws java.io.IOException {
              if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pageIdentifier_)) {
                com.google.protobuf.GeneratedMessageV3.writeString(output, 1, pageIdentifier_);
              }
              if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(content_)) {
                com.google.protobuf.GeneratedMessageV3.writeString(output, 2, content_);
              }
              getUnknownFields().writeTo(output);
            }

            @java.lang.Override
            public int getSerializedSize() {
              int size = memoizedSize;
              if (size != -1) return size;

              size = 0;
              if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pageIdentifier_)) {
                size +=
                    com.google.protobuf.GeneratedMessageV3.computeStringSize(1, pageIdentifier_);
              }
              if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(content_)) {
                size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, content_);
              }
              size += getUnknownFields().getSerializedSize();
              memoizedSize = size;
              return size;
            }

            @java.lang.Override
            public boolean equals(final java.lang.Object obj) {
              if (obj == this) {
                return true;
              }
              if (!(obj
                  instanceof
                  com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                      .SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveSegment)) {
                return super.equals(obj);
              }
              com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList
                      .SearchResult.UnstructuredDocumentInfo.ExtractiveSegment
                  other =
                      (com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                              .SearchResultList.SearchResult.UnstructuredDocumentInfo
                              .ExtractiveSegment)
                          obj;

              if (!getPageIdentifier().equals(other.getPageIdentifier())) return false;
              if (!getContent().equals(other.getContent())) return false;
              if (!getUnknownFields().equals(other.getUnknownFields())) return false;
              return true;
            }

            @java.lang.Override
            public int hashCode() {
              if (memoizedHashCode != 0) {
                return memoizedHashCode;
              }
              int hash = 41;
              hash = (19 * hash) + getDescriptor().hashCode();
              hash = (37 * hash) + PAGE_IDENTIFIER_FIELD_NUMBER;
              hash = (53 * hash) + getPageIdentifier().hashCode();
              hash = (37 * hash) + CONTENT_FIELD_NUMBER;
              hash = (53 * hash) + getContent().hashCode();
              hash = (29 * hash) + getUnknownFields().hashCode();
              memoizedHashCode = hash;
              return hash;
            }

            public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                    .SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveSegment
                parseFrom(java.nio.ByteBuffer data)
                    throws com.google.protobuf.InvalidProtocolBufferException {
              return PARSER.parseFrom(data);
            }

            public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                    .SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveSegment
                parseFrom(
                    java.nio.ByteBuffer data,
                    com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                    throws com.google.protobuf.InvalidProtocolBufferException {
              return PARSER.parseFrom(data, extensionRegistry);
            }

            public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                    .SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveSegment
                parseFrom(com.google.protobuf.ByteString data)
                    throws com.google.protobuf.InvalidProtocolBufferException {
              return PARSER.parseFrom(data);
            }

            public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                    .SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveSegment
                parseFrom(
                    com.google.protobuf.ByteString data,
                    com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                    throws com.google.protobuf.InvalidProtocolBufferException {
              return PARSER.parseFrom(data, extensionRegistry);
            }

            public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                    .SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveSegment
                parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
              return PARSER.parseFrom(data);
            }

            public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                    .SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveSegment
                parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                    throws com.google.protobuf.InvalidProtocolBufferException {
              return PARSER.parseFrom(data, extensionRegistry);
            }

            public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                    .SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveSegment
                parseFrom(java.io.InputStream input) throws java.io.IOException {
              return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
            }

            public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                    .SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveSegment
                parseFrom(
                    java.io.InputStream input,
                    com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                    throws java.io.IOException {
              return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
                  PARSER, input, extensionRegistry);
            }

            public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                    .SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveSegment
                parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
              return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
                  PARSER, input);
            }

            public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                    .SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveSegment
                parseDelimitedFrom(
                    java.io.InputStream input,
                    com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                    throws java.io.IOException {
              return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
                  PARSER, input, extensionRegistry);
            }

            public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                    .SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveSegment
                parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
              return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
            }

            public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                    .SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveSegment
                parseFrom(
                    com.google.protobuf.CodedInputStream input,
                    com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                    throws java.io.IOException {
              return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
                  PARSER, input, extensionRegistry);
            }

            @java.lang.Override
            public Builder newBuilderForType() {
              return newBuilder();
            }

            public static Builder newBuilder() {
              return DEFAULT_INSTANCE.toBuilder();
            }

            public static Builder newBuilder(
                com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                        .SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveSegment
                    prototype) {
              return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
            }

            @java.lang.Override
            public Builder toBuilder() {
              return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
            }

            @java.lang.Override
            protected Builder newBuilderForType(
                com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
              Builder builder = new Builder(parent);
              return builder;
            }
            /**
             *
             *
             * <pre>
             * Extractive segment.
             * [Guide](https://cloud.google.com/generative-ai-app-builder/docs/snippets#extractive-segments)
             * Answer generation will only use it if document_contexts is empty.
             * This is supposed to be shorter snippets.
             * </pre>
             *
             * Protobuf type {@code
             * google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveSegment}
             */
            public static final class Builder
                extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
                implements
                // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveSegment)
                com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                    .SearchResultList.SearchResult.UnstructuredDocumentInfo
                    .ExtractiveSegmentOrBuilder {
              public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
                return com.google.cloud.discoveryengine.v1beta.ConversationalSearchServiceProto
                    .internal_static_google_cloud_discoveryengine_v1beta_AnswerQueryRequest_SearchSpec_SearchResultList_SearchResult_UnstructuredDocumentInfo_ExtractiveSegment_descriptor;
              }

              @java.lang.Override
              protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
                  internalGetFieldAccessorTable() {
                return com.google.cloud.discoveryengine.v1beta.ConversationalSearchServiceProto
                    .internal_static_google_cloud_discoveryengine_v1beta_AnswerQueryRequest_SearchSpec_SearchResultList_SearchResult_UnstructuredDocumentInfo_ExtractiveSegment_fieldAccessorTable
                    .ensureFieldAccessorsInitialized(
                        com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                            .SearchResultList.SearchResult.UnstructuredDocumentInfo
                            .ExtractiveSegment.class,
                        com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                            .SearchResultList.SearchResult.UnstructuredDocumentInfo
                            .ExtractiveSegment.Builder.class);
              }

              // Construct using
              // com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveSegment.newBuilder()
              private Builder() {}

              private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
                super(parent);
              }

              @java.lang.Override
              public Builder clear() {
                super.clear();
                bitField0_ = 0;
                pageIdentifier_ = "";
                content_ = "";
                return this;
              }

              @java.lang.Override
              public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
                return com.google.cloud.discoveryengine.v1beta.ConversationalSearchServiceProto
                    .internal_static_google_cloud_discoveryengine_v1beta_AnswerQueryRequest_SearchSpec_SearchResultList_SearchResult_UnstructuredDocumentInfo_ExtractiveSegment_descriptor;
              }

              @java.lang.Override
              public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                      .SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveSegment
                  getDefaultInstanceForType() {
                return com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                    .SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveSegment
                    .getDefaultInstance();
              }

              @java.lang.Override
              public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                      .SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveSegment
                  build() {
                com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                        .SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveSegment
                    result = buildPartial();
                if (!result.isInitialized()) {
                  throw newUninitializedMessageException(result);
                }
                return result;
              }

              @java.lang.Override
              public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                      .SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveSegment
                  buildPartial() {
                com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                        .SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveSegment
                    result =
                        new com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                            .SearchResultList.SearchResult.UnstructuredDocumentInfo
                            .ExtractiveSegment(this);
                if (bitField0_ != 0) {
                  buildPartial0(result);
                }
                onBuilt();
                return result;
              }

              private void buildPartial0(
                  com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                          .SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveSegment
                      result) {
                int from_bitField0_ = bitField0_;
                if (((from_bitField0_ & 0x00000001) != 0)) {
                  result.pageIdentifier_ = pageIdentifier_;
                }
                if (((from_bitField0_ & 0x00000002) != 0)) {
                  result.content_ = content_;
                }
              }

              @java.lang.Override
              public Builder clone() {
                return super.clone();
              }

              @java.lang.Override
              public Builder setField(
                  com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
                return super.setField(field, value);
              }

              @java.lang.Override
              public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
                return super.clearField(field);
              }

              @java.lang.Override
              public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
                return super.clearOneof(oneof);
              }

              @java.lang.Override
              public Builder setRepeatedField(
                  com.google.protobuf.Descriptors.FieldDescriptor field,
                  int index,
                  java.lang.Object value) {
                return super.setRepeatedField(field, index, value);
              }

              @java.lang.Override
              public Builder addRepeatedField(
                  com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
                return super.addRepeatedField(field, value);
              }

              @java.lang.Override
              public Builder mergeFrom(com.google.protobuf.Message other) {
                if (other
                    instanceof
                    com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                        .SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveSegment) {
                  return mergeFrom(
                      (com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                              .SearchResultList.SearchResult.UnstructuredDocumentInfo
                              .ExtractiveSegment)
                          other);
                } else {
                  super.mergeFrom(other);
                  return this;
                }
              }

              public Builder mergeFrom(
                  com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                          .SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveSegment
                      other) {
                if (other
                    == com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                        .SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveSegment
                        .getDefaultInstance()) return this;
                if (!other.getPageIdentifier().isEmpty()) {
                  pageIdentifier_ = other.pageIdentifier_;
                  bitField0_ |= 0x00000001;
                  onChanged();
                }
                if (!other.getContent().isEmpty()) {
                  content_ = other.content_;
                  bitField0_ |= 0x00000002;
                  onChanged();
                }
                this.mergeUnknownFields(other.getUnknownFields());
                onChanged();
                return this;
              }

              @java.lang.Override
              public final boolean isInitialized() {
                return true;
              }

              @java.lang.Override
              public Builder mergeFrom(
                  com.google.protobuf.CodedInputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws java.io.IOException {
                if (extensionRegistry == null) {
                  throw new java.lang.NullPointerException();
                }
                try {
                  boolean done = false;
                  while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                      case 0:
                        done = true;
                        break;
                      case 10:
                        {
                          pageIdentifier_ = input.readStringRequireUtf8();
                          bitField0_ |= 0x00000001;
                          break;
                        } // case 10
                      case 18:
                        {
                          content_ = input.readStringRequireUtf8();
                          bitField0_ |= 0x00000002;
                          break;
                        } // case 18
                      default:
                        {
                          if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                            done = true; // was an endgroup tag
                          }
                          break;
                        } // default:
                    } // switch (tag)
                  } // while (!done)
                } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                  throw e.unwrapIOException();
                } finally {
                  onChanged();
                } // finally
                return this;
              }

              private int bitField0_;

              private java.lang.Object pageIdentifier_ = "";
              /**
               *
               *
               * <pre>
               * Page identifier.
               * </pre>
               *
               * <code>string page_identifier = 1;</code>
               *
               * @return The pageIdentifier.
               */
              public java.lang.String getPageIdentifier() {
                java.lang.Object ref = pageIdentifier_;
                if (!(ref instanceof java.lang.String)) {
                  com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
                  java.lang.String s = bs.toStringUtf8();
                  pageIdentifier_ = s;
                  return s;
                } else {
                  return (java.lang.String) ref;
                }
              }
              /**
               *
               *
               * <pre>
               * Page identifier.
               * </pre>
               *
               * <code>string page_identifier = 1;</code>
               *
               * @return The bytes for pageIdentifier.
               */
              public com.google.protobuf.ByteString getPageIdentifierBytes() {
                java.lang.Object ref = pageIdentifier_;
                if (ref instanceof String) {
                  com.google.protobuf.ByteString b =
                      com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
                  pageIdentifier_ = b;
                  return b;
                } else {
                  return (com.google.protobuf.ByteString) ref;
                }
              }
              /**
               *
               *
               * <pre>
               * Page identifier.
               * </pre>
               *
               * <code>string page_identifier = 1;</code>
               *
               * @param value The pageIdentifier to set.
               * @return This builder for chaining.
               */
              public Builder setPageIdentifier(java.lang.String value) {
                if (value == null) {
                  throw new NullPointerException();
                }
                pageIdentifier_ = value;
                bitField0_ |= 0x00000001;
                onChanged();
                return this;
              }
              /**
               *
               *
               * <pre>
               * Page identifier.
               * </pre>
               *
               * <code>string page_identifier = 1;</code>
               *
               * @return This builder for chaining.
               */
              public Builder clearPageIdentifier() {
                pageIdentifier_ = getDefaultInstance().getPageIdentifier();
                bitField0_ = (bitField0_ & ~0x00000001);
                onChanged();
                return this;
              }
              /**
               *
               *
               * <pre>
               * Page identifier.
               * </pre>
               *
               * <code>string page_identifier = 1;</code>
               *
               * @param value The bytes for pageIdentifier to set.
               * @return This builder for chaining.
               */
              public Builder setPageIdentifierBytes(com.google.protobuf.ByteString value) {
                if (value == null) {
                  throw new NullPointerException();
                }
                checkByteStringIsUtf8(value);
                pageIdentifier_ = value;
                bitField0_ |= 0x00000001;
                onChanged();
                return this;
              }

              private java.lang.Object content_ = "";
              /**
               *
               *
               * <pre>
               * Extractive segment content.
               * </pre>
               *
               * <code>string content = 2;</code>
               *
               * @return The content.
               */
              public java.lang.String getContent() {
                java.lang.Object ref = content_;
                if (!(ref instanceof java.lang.String)) {
                  com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
                  java.lang.String s = bs.toStringUtf8();
                  content_ = s;
                  return s;
                } else {
                  return (java.lang.String) ref;
                }
              }
              /**
               *
               *
               * <pre>
               * Extractive segment content.
               * </pre>
               *
               * <code>string content = 2;</code>
               *
               * @return The bytes for content.
               */
              public com.google.protobuf.ByteString getContentBytes() {
                java.lang.Object ref = content_;
                if (ref instanceof String) {
                  com.google.protobuf.ByteString b =
                      com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
                  content_ = b;
                  return b;
                } else {
                  return (com.google.protobuf.ByteString) ref;
                }
              }
              /**
               *
               *
               * <pre>
               * Extractive segment content.
               * </pre>
               *
               * <code>string content = 2;</code>
               *
               * @param value The content to set.
               * @return This builder for chaining.
               */
              public Builder setContent(java.lang.String value) {
                if (value == null) {
                  throw new NullPointerException();
                }
                content_ = value;
                bitField0_ |= 0x00000002;
                onChanged();
                return this;
              }
              /**
               *
               *
               * <pre>
               * Extractive segment content.
               * </pre>
               *
               * <code>string content = 2;</code>
               *
               * @return This builder for chaining.
               */
              public Builder clearContent() {
                content_ = getDefaultInstance().getContent();
                bitField0_ = (bitField0_ & ~0x00000002);
                onChanged();
                return this;
              }
              /**
               *
               *
               * <pre>
               * Extractive segment content.
               * </pre>
               *
               * <code>string content = 2;</code>
               *
               * @param value The bytes for content to set.
               * @return This builder for chaining.
               */
              public Builder setContentBytes(com.google.protobuf.ByteString value) {
                if (value == null) {
                  throw new NullPointerException();
                }
                checkByteStringIsUtf8(value);
                content_ = value;
                bitField0_ |= 0x00000002;
                onChanged();
                return this;
              }

              @java.lang.Override
              public final Builder setUnknownFields(
                  final com.google.protobuf.UnknownFieldSet unknownFields) {
                return super.setUnknownFields(unknownFields);
              }

              @java.lang.Override
              public final Builder mergeUnknownFields(
                  final com.google.protobuf.UnknownFieldSet unknownFields) {
                return super.mergeUnknownFields(unknownFields);
              }

              // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveSegment)
            }

            // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveSegment)
            private static final com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest
                    .SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo
                    .ExtractiveSegment
                DEFAULT_INSTANCE;

            static {
              DEFAULT_INSTANCE =
                  new com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                      .SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveSegment();
            }

            public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                    .SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveSegment
                getDefaultInstance() {
              return DEFAULT_INSTANCE;
            }

            private static final com.google.protobuf.Parser<ExtractiveSegment> PARSER =
                new com.google.protobuf.AbstractParser<ExtractiveSegment>() {
                  @java.lang.Override
                  public ExtractiveSegment parsePartialFrom(
                      com.google.protobuf.CodedInputStream input,
                      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                      throws com.google.protobuf.InvalidProtocolBufferException {
                    Builder builder = newBuilder();
                    try {
                      builder.mergeFrom(input, extensionRegistry);
                    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                      throw e.setUnfinishedMessage(builder.buildPartial());
                    } catch (com.google.protobuf.UninitializedMessageException e) {
                      throw e.asInvalidProtocolBufferException()
                          .setUnfinishedMessage(builder.buildPartial());
                    } catch (java.io.IOException e) {
                      throw new com.google.protobuf.InvalidProtocolBufferException(e)
                          .setUnfinishedMessage(builder.buildPartial());
                    }
                    return builder.buildPartial();
                  }
                };

            public static com.google.protobuf.Parser<ExtractiveSegment> parser() {
              return PARSER;
            }

            @java.lang.Override
            public com.google.protobuf.Parser<ExtractiveSegment> getParserForType() {
              return PARSER;
            }

            @java.lang.Override
            public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                    .SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveSegment
                getDefaultInstanceForType() {
              return DEFAULT_INSTANCE;
            }
          }

          public interface ExtractiveAnswerOrBuilder
              extends
              // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveAnswer)
              com.google.protobuf.MessageOrBuilder {

            /**
             *
             *
             * <pre>
             * Page identifier.
             * </pre>
             *
             * <code>string page_identifier = 1;</code>
             *
             * @return The pageIdentifier.
             */
            java.lang.String getPageIdentifier();
            /**
             *
             *
             * <pre>
             * Page identifier.
             * </pre>
             *
             * <code>string page_identifier = 1;</code>
             *
             * @return The bytes for pageIdentifier.
             */
            com.google.protobuf.ByteString getPageIdentifierBytes();

            /**
             *
             *
             * <pre>
             * Extractive answer content.
             * </pre>
             *
             * <code>string content = 2;</code>
             *
             * @return The content.
             */
            java.lang.String getContent();
            /**
             *
             *
             * <pre>
             * Extractive answer content.
             * </pre>
             *
             * <code>string content = 2;</code>
             *
             * @return The bytes for content.
             */
            com.google.protobuf.ByteString getContentBytes();
          }
          /**
           *
           *
           * <pre>
           * Extractive answer.
           * [Guide](https://cloud.google.com/generative-ai-app-builder/docs/snippets#get-answers)
           * </pre>
           *
           * Protobuf type {@code
           * google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveAnswer}
           */
          public static final class ExtractiveAnswer extends com.google.protobuf.GeneratedMessageV3
              implements
              // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveAnswer)
              ExtractiveAnswerOrBuilder {
            private static final long serialVersionUID = 0L;
            // Use ExtractiveAnswer.newBuilder() to construct.
            private ExtractiveAnswer(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
              super(builder);
            }

            private ExtractiveAnswer() {
              pageIdentifier_ = "";
              content_ = "";
            }

            @java.lang.Override
            @SuppressWarnings({"unused"})
            protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
              return new ExtractiveAnswer();
            }

            public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
              return com.google.cloud.discoveryengine.v1beta.ConversationalSearchServiceProto
                  .internal_static_google_cloud_discoveryengine_v1beta_AnswerQueryRequest_SearchSpec_SearchResultList_SearchResult_UnstructuredDocumentInfo_ExtractiveAnswer_descriptor;
            }

            @java.lang.Override
            protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
                internalGetFieldAccessorTable() {
              return com.google.cloud.discoveryengine.v1beta.ConversationalSearchServiceProto
                  .internal_static_google_cloud_discoveryengine_v1beta_AnswerQueryRequest_SearchSpec_SearchResultList_SearchResult_UnstructuredDocumentInfo_ExtractiveAnswer_fieldAccessorTable
                  .ensureFieldAccessorsInitialized(
                      com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                          .SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveAnswer
                          .class,
                      com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                          .SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveAnswer
                          .Builder.class);
            }

            public static final int PAGE_IDENTIFIER_FIELD_NUMBER = 1;

            @SuppressWarnings("serial")
            private volatile java.lang.Object pageIdentifier_ = "";
            /**
             *
             *
             * <pre>
             * Page identifier.
             * </pre>
             *
             * <code>string page_identifier = 1;</code>
             *
             * @return The pageIdentifier.
             */
            @java.lang.Override
            public java.lang.String getPageIdentifier() {
              java.lang.Object ref = pageIdentifier_;
              if (ref instanceof java.lang.String) {
                return (java.lang.String) ref;
              } else {
                com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
                java.lang.String s = bs.toStringUtf8();
                pageIdentifier_ = s;
                return s;
              }
            }
            /**
             *
             *
             * <pre>
             * Page identifier.
             * </pre>
             *
             * <code>string page_identifier = 1;</code>
             *
             * @return The bytes for pageIdentifier.
             */
            @java.lang.Override
            public com.google.protobuf.ByteString getPageIdentifierBytes() {
              java.lang.Object ref = pageIdentifier_;
              if (ref instanceof java.lang.String) {
                com.google.protobuf.ByteString b =
                    com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
                pageIdentifier_ = b;
                return b;
              } else {
                return (com.google.protobuf.ByteString) ref;
              }
            }

            public static final int CONTENT_FIELD_NUMBER = 2;

            @SuppressWarnings("serial")
            private volatile java.lang.Object content_ = "";
            /**
             *
             *
             * <pre>
             * Extractive answer content.
             * </pre>
             *
             * <code>string content = 2;</code>
             *
             * @return The content.
             */
            @java.lang.Override
            public java.lang.String getContent() {
              java.lang.Object ref = content_;
              if (ref instanceof java.lang.String) {
                return (java.lang.String) ref;
              } else {
                com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
                java.lang.String s = bs.toStringUtf8();
                content_ = s;
                return s;
              }
            }
            /**
             *
             *
             * <pre>
             * Extractive answer content.
             * </pre>
             *
             * <code>string content = 2;</code>
             *
             * @return The bytes for content.
             */
            @java.lang.Override
            public com.google.protobuf.ByteString getContentBytes() {
              java.lang.Object ref = content_;
              if (ref instanceof java.lang.String) {
                com.google.protobuf.ByteString b =
                    com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
                content_ = b;
                return b;
              } else {
                return (com.google.protobuf.ByteString) ref;
              }
            }

            private byte memoizedIsInitialized = -1;

            @java.lang.Override
            public final boolean isInitialized() {
              byte isInitialized = memoizedIsInitialized;
              if (isInitialized == 1) return true;
              if (isInitialized == 0) return false;

              memoizedIsInitialized = 1;
              return true;
            }

            @java.lang.Override
            public void writeTo(com.google.protobuf.CodedOutputStream output)
                throws java.io.IOException {
              if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pageIdentifier_)) {
                com.google.protobuf.GeneratedMessageV3.writeString(output, 1, pageIdentifier_);
              }
              if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(content_)) {
                com.google.protobuf.GeneratedMessageV3.writeString(output, 2, content_);
              }
              getUnknownFields().writeTo(output);
            }

            @java.lang.Override
            public int getSerializedSize() {
              int size = memoizedSize;
              if (size != -1) return size;

              size = 0;
              if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pageIdentifier_)) {
                size +=
                    com.google.protobuf.GeneratedMessageV3.computeStringSize(1, pageIdentifier_);
              }
              if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(content_)) {
                size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, content_);
              }
              size += getUnknownFields().getSerializedSize();
              memoizedSize = size;
              return size;
            }

            @java.lang.Override
            public boolean equals(final java.lang.Object obj) {
              if (obj == this) {
                return true;
              }
              if (!(obj
                  instanceof
                  com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                      .SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveAnswer)) {
                return super.equals(obj);
              }
              com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList
                      .SearchResult.UnstructuredDocumentInfo.ExtractiveAnswer
                  other =
                      (com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                              .SearchResultList.SearchResult.UnstructuredDocumentInfo
                              .ExtractiveAnswer)
                          obj;

              if (!getPageIdentifier().equals(other.getPageIdentifier())) return false;
              if (!getContent().equals(other.getContent())) return false;
              if (!getUnknownFields().equals(other.getUnknownFields())) return false;
              return true;
            }

            @java.lang.Override
            public int hashCode() {
              if (memoizedHashCode != 0) {
                return memoizedHashCode;
              }
              int hash = 41;
              hash = (19 * hash) + getDescriptor().hashCode();
              hash = (37 * hash) + PAGE_IDENTIFIER_FIELD_NUMBER;
              hash = (53 * hash) + getPageIdentifier().hashCode();
              hash = (37 * hash) + CONTENT_FIELD_NUMBER;
              hash = (53 * hash) + getContent().hashCode();
              hash = (29 * hash) + getUnknownFields().hashCode();
              memoizedHashCode = hash;
              return hash;
            }

            public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                    .SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveAnswer
                parseFrom(java.nio.ByteBuffer data)
                    throws com.google.protobuf.InvalidProtocolBufferException {
              return PARSER.parseFrom(data);
            }

            public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                    .SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveAnswer
                parseFrom(
                    java.nio.ByteBuffer data,
                    com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                    throws com.google.protobuf.InvalidProtocolBufferException {
              return PARSER.parseFrom(data, extensionRegistry);
            }

            public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                    .SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveAnswer
                parseFrom(com.google.protobuf.ByteString data)
                    throws com.google.protobuf.InvalidProtocolBufferException {
              return PARSER.parseFrom(data);
            }

            public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                    .SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveAnswer
                parseFrom(
                    com.google.protobuf.ByteString data,
                    com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                    throws com.google.protobuf.InvalidProtocolBufferException {
              return PARSER.parseFrom(data, extensionRegistry);
            }

            public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                    .SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveAnswer
                parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
              return PARSER.parseFrom(data);
            }

            public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                    .SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveAnswer
                parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                    throws com.google.protobuf.InvalidProtocolBufferException {
              return PARSER.parseFrom(data, extensionRegistry);
            }

            public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                    .SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveAnswer
                parseFrom(java.io.InputStream input) throws java.io.IOException {
              return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
            }

            public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                    .SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveAnswer
                parseFrom(
                    java.io.InputStream input,
                    com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                    throws java.io.IOException {
              return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
                  PARSER, input, extensionRegistry);
            }

            public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                    .SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveAnswer
                parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
              return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
                  PARSER, input);
            }

            public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                    .SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveAnswer
                parseDelimitedFrom(
                    java.io.InputStream input,
                    com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                    throws java.io.IOException {
              return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
                  PARSER, input, extensionRegistry);
            }

            public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                    .SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveAnswer
                parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
              return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
            }

            public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                    .SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveAnswer
                parseFrom(
                    com.google.protobuf.CodedInputStream input,
                    com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                    throws java.io.IOException {
              return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
                  PARSER, input, extensionRegistry);
            }

            @java.lang.Override
            public Builder newBuilderForType() {
              return newBuilder();
            }

            public static Builder newBuilder() {
              return DEFAULT_INSTANCE.toBuilder();
            }

            public static Builder newBuilder(
                com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                        .SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveAnswer
                    prototype) {
              return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
            }

            @java.lang.Override
            public Builder toBuilder() {
              return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
            }

            @java.lang.Override
            protected Builder newBuilderForType(
                com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
              Builder builder = new Builder(parent);
              return builder;
            }
            /**
             *
             *
             * <pre>
             * Extractive answer.
             * [Guide](https://cloud.google.com/generative-ai-app-builder/docs/snippets#get-answers)
             * </pre>
             *
             * Protobuf type {@code
             * google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveAnswer}
             */
            public static final class Builder
                extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
                implements
                // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveAnswer)
                com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                    .SearchResultList.SearchResult.UnstructuredDocumentInfo
                    .ExtractiveAnswerOrBuilder {
              public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
                return com.google.cloud.discoveryengine.v1beta.ConversationalSearchServiceProto
                    .internal_static_google_cloud_discoveryengine_v1beta_AnswerQueryRequest_SearchSpec_SearchResultList_SearchResult_UnstructuredDocumentInfo_ExtractiveAnswer_descriptor;
              }

              @java.lang.Override
              protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
                  internalGetFieldAccessorTable() {
                return com.google.cloud.discoveryengine.v1beta.ConversationalSearchServiceProto
                    .internal_static_google_cloud_discoveryengine_v1beta_AnswerQueryRequest_SearchSpec_SearchResultList_SearchResult_UnstructuredDocumentInfo_ExtractiveAnswer_fieldAccessorTable
                    .ensureFieldAccessorsInitialized(
                        com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                            .SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveAnswer
                            .class,
                        com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                            .SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveAnswer
                            .Builder.class);
              }

              // Construct using
              // com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveAnswer.newBuilder()
              private Builder() {}

              private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
                super(parent);
              }

              @java.lang.Override
              public Builder clear() {
                super.clear();
                bitField0_ = 0;
                pageIdentifier_ = "";
                content_ = "";
                return this;
              }

              @java.lang.Override
              public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
                return com.google.cloud.discoveryengine.v1beta.ConversationalSearchServiceProto
                    .internal_static_google_cloud_discoveryengine_v1beta_AnswerQueryRequest_SearchSpec_SearchResultList_SearchResult_UnstructuredDocumentInfo_ExtractiveAnswer_descriptor;
              }

              @java.lang.Override
              public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                      .SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveAnswer
                  getDefaultInstanceForType() {
                return com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                    .SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveAnswer
                    .getDefaultInstance();
              }

              @java.lang.Override
              public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                      .SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveAnswer
                  build() {
                com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                        .SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveAnswer
                    result = buildPartial();
                if (!result.isInitialized()) {
                  throw newUninitializedMessageException(result);
                }
                return result;
              }

              @java.lang.Override
              public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                      .SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveAnswer
                  buildPartial() {
                com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                        .SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveAnswer
                    result =
                        new com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                            .SearchResultList.SearchResult.UnstructuredDocumentInfo
                            .ExtractiveAnswer(this);
                if (bitField0_ != 0) {
                  buildPartial0(result);
                }
                onBuilt();
                return result;
              }

              private void buildPartial0(
                  com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                          .SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveAnswer
                      result) {
                int from_bitField0_ = bitField0_;
                if (((from_bitField0_ & 0x00000001) != 0)) {
                  result.pageIdentifier_ = pageIdentifier_;
                }
                if (((from_bitField0_ & 0x00000002) != 0)) {
                  result.content_ = content_;
                }
              }

              @java.lang.Override
              public Builder clone() {
                return super.clone();
              }

              @java.lang.Override
              public Builder setField(
                  com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
                return super.setField(field, value);
              }

              @java.lang.Override
              public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
                return super.clearField(field);
              }

              @java.lang.Override
              public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
                return super.clearOneof(oneof);
              }

              @java.lang.Override
              public Builder setRepeatedField(
                  com.google.protobuf.Descriptors.FieldDescriptor field,
                  int index,
                  java.lang.Object value) {
                return super.setRepeatedField(field, index, value);
              }

              @java.lang.Override
              public Builder addRepeatedField(
                  com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
                return super.addRepeatedField(field, value);
              }

              @java.lang.Override
              public Builder mergeFrom(com.google.protobuf.Message other) {
                if (other
                    instanceof
                    com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                        .SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveAnswer) {
                  return mergeFrom(
                      (com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                              .SearchResultList.SearchResult.UnstructuredDocumentInfo
                              .ExtractiveAnswer)
                          other);
                } else {
                  super.mergeFrom(other);
                  return this;
                }
              }

              public Builder mergeFrom(
                  com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                          .SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveAnswer
                      other) {
                if (other
                    == com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                        .SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveAnswer
                        .getDefaultInstance()) return this;
                if (!other.getPageIdentifier().isEmpty()) {
                  pageIdentifier_ = other.pageIdentifier_;
                  bitField0_ |= 0x00000001;
                  onChanged();
                }
                if (!other.getContent().isEmpty()) {
                  content_ = other.content_;
                  bitField0_ |= 0x00000002;
                  onChanged();
                }
                this.mergeUnknownFields(other.getUnknownFields());
                onChanged();
                return this;
              }

              @java.lang.Override
              public final boolean isInitialized() {
                return true;
              }

              @java.lang.Override
              public Builder mergeFrom(
                  com.google.protobuf.CodedInputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws java.io.IOException {
                if (extensionRegistry == null) {
                  throw new java.lang.NullPointerException();
                }
                try {
                  boolean done = false;
                  while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                      case 0:
                        done = true;
                        break;
                      case 10:
                        {
                          pageIdentifier_ = input.readStringRequireUtf8();
                          bitField0_ |= 0x00000001;
                          break;
                        } // case 10
                      case 18:
                        {
                          content_ = input.readStringRequireUtf8();
                          bitField0_ |= 0x00000002;
                          break;
                        } // case 18
                      default:
                        {
                          if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                            done = true; // was an endgroup tag
                          }
                          break;
                        } // default:
                    } // switch (tag)
                  } // while (!done)
                } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                  throw e.unwrapIOException();
                } finally {
                  onChanged();
                } // finally
                return this;
              }

              private int bitField0_;

              private java.lang.Object pageIdentifier_ = "";
              /**
               *
               *
               * <pre>
               * Page identifier.
               * </pre>
               *
               * <code>string page_identifier = 1;</code>
               *
               * @return The pageIdentifier.
               */
              public java.lang.String getPageIdentifier() {
                java.lang.Object ref = pageIdentifier_;
                if (!(ref instanceof java.lang.String)) {
                  com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
                  java.lang.String s = bs.toStringUtf8();
                  pageIdentifier_ = s;
                  return s;
                } else {
                  return (java.lang.String) ref;
                }
              }
              /**
               *
               *
               * <pre>
               * Page identifier.
               * </pre>
               *
               * <code>string page_identifier = 1;</code>
               *
               * @return The bytes for pageIdentifier.
               */
              public com.google.protobuf.ByteString getPageIdentifierBytes() {
                java.lang.Object ref = pageIdentifier_;
                if (ref instanceof String) {
                  com.google.protobuf.ByteString b =
                      com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
                  pageIdentifier_ = b;
                  return b;
                } else {
                  return (com.google.protobuf.ByteString) ref;
                }
              }
              /**
               *
               *
               * <pre>
               * Page identifier.
               * </pre>
               *
               * <code>string page_identifier = 1;</code>
               *
               * @param value The pageIdentifier to set.
               * @return This builder for chaining.
               */
              public Builder setPageIdentifier(java.lang.String value) {
                if (value == null) {
                  throw new NullPointerException();
                }
                pageIdentifier_ = value;
                bitField0_ |= 0x00000001;
                onChanged();
                return this;
              }
              /**
               *
               *
               * <pre>
               * Page identifier.
               * </pre>
               *
               * <code>string page_identifier = 1;</code>
               *
               * @return This builder for chaining.
               */
              public Builder clearPageIdentifier() {
                pageIdentifier_ = getDefaultInstance().getPageIdentifier();
                bitField0_ = (bitField0_ & ~0x00000001);
                onChanged();
                return this;
              }
              /**
               *
               *
               * <pre>
               * Page identifier.
               * </pre>
               *
               * <code>string page_identifier = 1;</code>
               *
               * @param value The bytes for pageIdentifier to set.
               * @return This builder for chaining.
               */
              public Builder setPageIdentifierBytes(com.google.protobuf.ByteString value) {
                if (value == null) {
                  throw new NullPointerException();
                }
                checkByteStringIsUtf8(value);
                pageIdentifier_ = value;
                bitField0_ |= 0x00000001;
                onChanged();
                return this;
              }

              private java.lang.Object content_ = "";
              /**
               *
               *
               * <pre>
               * Extractive answer content.
               * </pre>
               *
               * <code>string content = 2;</code>
               *
               * @return The content.
               */
              public java.lang.String getContent() {
                java.lang.Object ref = content_;
                if (!(ref instanceof java.lang.String)) {
                  com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
                  java.lang.String s = bs.toStringUtf8();
                  content_ = s;
                  return s;
                } else {
                  return (java.lang.String) ref;
                }
              }
              /**
               *
               *
               * <pre>
               * Extractive answer content.
               * </pre>
               *
               * <code>string content = 2;</code>
               *
               * @return The bytes for content.
               */
              public com.google.protobuf.ByteString getContentBytes() {
                java.lang.Object ref = content_;
                if (ref instanceof String) {
                  com.google.protobuf.ByteString b =
                      com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
                  content_ = b;
                  return b;
                } else {
                  return (com.google.protobuf.ByteString) ref;
                }
              }
              /**
               *
               *
               * <pre>
               * Extractive answer content.
               * </pre>
               *
               * <code>string content = 2;</code>
               *
               * @param value The content to set.
               * @return This builder for chaining.
               */
              public Builder setContent(java.lang.String value) {
                if (value == null) {
                  throw new NullPointerException();
                }
                content_ = value;
                bitField0_ |= 0x00000002;
                onChanged();
                return this;
              }
              /**
               *
               *
               * <pre>
               * Extractive answer content.
               * </pre>
               *
               * <code>string content = 2;</code>
               *
               * @return This builder for chaining.
               */
              public Builder clearContent() {
                content_ = getDefaultInstance().getContent();
                bitField0_ = (bitField0_ & ~0x00000002);
                onChanged();
                return this;
              }
              /**
               *
               *
               * <pre>
               * Extractive answer content.
               * </pre>
               *
               * <code>string content = 2;</code>
               *
               * @param value The bytes for content to set.
               * @return This builder for chaining.
               */
              public Builder setContentBytes(com.google.protobuf.ByteString value) {
                if (value == null) {
                  throw new NullPointerException();
                }
                checkByteStringIsUtf8(value);
                content_ = value;
                bitField0_ |= 0x00000002;
                onChanged();
                return this;
              }

              @java.lang.Override
              public final Builder setUnknownFields(
                  final com.google.protobuf.UnknownFieldSet unknownFields) {
                return super.setUnknownFields(unknownFields);
              }

              @java.lang.Override
              public final Builder mergeUnknownFields(
                  final com.google.protobuf.UnknownFieldSet unknownFields) {
                return super.mergeUnknownFields(unknownFields);
              }

              // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveAnswer)
            }

            // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveAnswer)
            private static final com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest
                    .SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo
                    .ExtractiveAnswer
                DEFAULT_INSTANCE;

            static {
              DEFAULT_INSTANCE =
                  new com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                      .SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveAnswer();
            }

            public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                    .SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveAnswer
                getDefaultInstance() {
              return DEFAULT_INSTANCE;
            }

            private static final com.google.protobuf.Parser<ExtractiveAnswer> PARSER =
                new com.google.protobuf.AbstractParser<ExtractiveAnswer>() {
                  @java.lang.Override
                  public ExtractiveAnswer parsePartialFrom(
                      com.google.protobuf.CodedInputStream input,
                      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                      throws com.google.protobuf.InvalidProtocolBufferException {
                    Builder builder = newBuilder();
                    try {
                      builder.mergeFrom(input, extensionRegistry);
                    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                      throw e.setUnfinishedMessage(builder.buildPartial());
                    } catch (com.google.protobuf.UninitializedMessageException e) {
                      throw e.asInvalidProtocolBufferException()
                          .setUnfinishedMessage(builder.buildPartial());
                    } catch (java.io.IOException e) {
                      throw new com.google.protobuf.InvalidProtocolBufferException(e)
                          .setUnfinishedMessage(builder.buildPartial());
                    }
                    return builder.buildPartial();
                  }
                };

            public static com.google.protobuf.Parser<ExtractiveAnswer> parser() {
              return PARSER;
            }

            @java.lang.Override
            public com.google.protobuf.Parser<ExtractiveAnswer> getParserForType() {
              return PARSER;
            }

            @java.lang.Override
            public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                    .SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveAnswer
                getDefaultInstanceForType() {
              return DEFAULT_INSTANCE;
            }
          }

          public static final int DOCUMENT_FIELD_NUMBER = 1;

          @SuppressWarnings("serial")
          private volatile java.lang.Object document_ = "";
          /**
           *
           *
           * <pre>
           * Document resource name.
           * </pre>
           *
           * <code>string document = 1 [(.google.api.resource_reference) = { ... }</code>
           *
           * @return The document.
           */
          @java.lang.Override
          public java.lang.String getDocument() {
            java.lang.Object ref = document_;
            if (ref instanceof java.lang.String) {
              return (java.lang.String) ref;
            } else {
              com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
              java.lang.String s = bs.toStringUtf8();
              document_ = s;
              return s;
            }
          }
          /**
           *
           *
           * <pre>
           * Document resource name.
           * </pre>
           *
           * <code>string document = 1 [(.google.api.resource_reference) = { ... }</code>
           *
           * @return The bytes for document.
           */
          @java.lang.Override
          public com.google.protobuf.ByteString getDocumentBytes() {
            java.lang.Object ref = document_;
            if (ref instanceof java.lang.String) {
              com.google.protobuf.ByteString b =
                  com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
              document_ = b;
              return b;
            } else {
              return (com.google.protobuf.ByteString) ref;
            }
          }

          public static final int URI_FIELD_NUMBER = 2;

          @SuppressWarnings("serial")
          private volatile java.lang.Object uri_ = "";
          /**
           *
           *
           * <pre>
           * URI for the document.
           * </pre>
           *
           * <code>string uri = 2;</code>
           *
           * @return The uri.
           */
          @java.lang.Override
          public java.lang.String getUri() {
            java.lang.Object ref = uri_;
            if (ref instanceof java.lang.String) {
              return (java.lang.String) ref;
            } else {
              com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
              java.lang.String s = bs.toStringUtf8();
              uri_ = s;
              return s;
            }
          }
          /**
           *
           *
           * <pre>
           * URI for the document.
           * </pre>
           *
           * <code>string uri = 2;</code>
           *
           * @return The bytes for uri.
           */
          @java.lang.Override
          public com.google.protobuf.ByteString getUriBytes() {
            java.lang.Object ref = uri_;
            if (ref instanceof java.lang.String) {
              com.google.protobuf.ByteString b =
                  com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
              uri_ = b;
              return b;
            } else {
              return (com.google.protobuf.ByteString) ref;
            }
          }

          public static final int TITLE_FIELD_NUMBER = 3;

          @SuppressWarnings("serial")
          private volatile java.lang.Object title_ = "";
          /**
           *
           *
           * <pre>
           * Title.
           * </pre>
           *
           * <code>string title = 3;</code>
           *
           * @return The title.
           */
          @java.lang.Override
          public java.lang.String getTitle() {
            java.lang.Object ref = title_;
            if (ref instanceof java.lang.String) {
              return (java.lang.String) ref;
            } else {
              com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
              java.lang.String s = bs.toStringUtf8();
              title_ = s;
              return s;
            }
          }
          /**
           *
           *
           * <pre>
           * Title.
           * </pre>
           *
           * <code>string title = 3;</code>
           *
           * @return The bytes for title.
           */
          @java.lang.Override
          public com.google.protobuf.ByteString getTitleBytes() {
            java.lang.Object ref = title_;
            if (ref instanceof java.lang.String) {
              com.google.protobuf.ByteString b =
                  com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
              title_ = b;
              return b;
            } else {
              return (com.google.protobuf.ByteString) ref;
            }
          }

          public static final int DOCUMENT_CONTEXTS_FIELD_NUMBER = 4;

          @SuppressWarnings("serial")
          private java.util.List<
                  com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                      .SearchResultList.SearchResult.UnstructuredDocumentInfo.DocumentContext>
              documentContexts_;
          /**
           *
           *
           * <pre>
           * List of document contexts. The content will be used for Answer
           * Generation. This is supposed to be the main content of the document
           * that can be long and comprehensive.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo.DocumentContext document_contexts = 4;
           * </code>
           */
          @java.lang.Override
          public java.util.List<
                  com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                      .SearchResultList.SearchResult.UnstructuredDocumentInfo.DocumentContext>
              getDocumentContextsList() {
            return documentContexts_;
          }
          /**
           *
           *
           * <pre>
           * List of document contexts. The content will be used for Answer
           * Generation. This is supposed to be the main content of the document
           * that can be long and comprehensive.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo.DocumentContext document_contexts = 4;
           * </code>
           */
          @java.lang.Override
          public java.util.List<
                  ? extends
                      com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                          .SearchResultList.SearchResult.UnstructuredDocumentInfo
                          .DocumentContextOrBuilder>
              getDocumentContextsOrBuilderList() {
            return documentContexts_;
          }
          /**
           *
           *
           * <pre>
           * List of document contexts. The content will be used for Answer
           * Generation. This is supposed to be the main content of the document
           * that can be long and comprehensive.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo.DocumentContext document_contexts = 4;
           * </code>
           */
          @java.lang.Override
          public int getDocumentContextsCount() {
            return documentContexts_.size();
          }
          /**
           *
           *
           * <pre>
           * List of document contexts. The content will be used for Answer
           * Generation. This is supposed to be the main content of the document
           * that can be long and comprehensive.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo.DocumentContext document_contexts = 4;
           * </code>
           */
          @java.lang.Override
          public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                  .SearchResultList.SearchResult.UnstructuredDocumentInfo.DocumentContext
              getDocumentContexts(int index) {
            return documentContexts_.get(index);
          }
          /**
           *
           *
           * <pre>
           * List of document contexts. The content will be used for Answer
           * Generation. This is supposed to be the main content of the document
           * that can be long and comprehensive.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo.DocumentContext document_contexts = 4;
           * </code>
           */
          @java.lang.Override
          public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                  .SearchResultList.SearchResult.UnstructuredDocumentInfo.DocumentContextOrBuilder
              getDocumentContextsOrBuilder(int index) {
            return documentContexts_.get(index);
          }

          public static final int EXTRACTIVE_SEGMENTS_FIELD_NUMBER = 5;

          @SuppressWarnings("serial")
          private java.util.List<
                  com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                      .SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveSegment>
              extractiveSegments_;
          /**
           *
           *
           * <pre>
           * List of extractive segments.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveSegment extractive_segments = 5;
           * </code>
           */
          @java.lang.Override
          public java.util.List<
                  com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                      .SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveSegment>
              getExtractiveSegmentsList() {
            return extractiveSegments_;
          }
          /**
           *
           *
           * <pre>
           * List of extractive segments.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveSegment extractive_segments = 5;
           * </code>
           */
          @java.lang.Override
          public java.util.List<
                  ? extends
                      com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                          .SearchResultList.SearchResult.UnstructuredDocumentInfo
                          .ExtractiveSegmentOrBuilder>
              getExtractiveSegmentsOrBuilderList() {
            return extractiveSegments_;
          }
          /**
           *
           *
           * <pre>
           * List of extractive segments.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveSegment extractive_segments = 5;
           * </code>
           */
          @java.lang.Override
          public int getExtractiveSegmentsCount() {
            return extractiveSegments_.size();
          }
          /**
           *
           *
           * <pre>
           * List of extractive segments.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveSegment extractive_segments = 5;
           * </code>
           */
          @java.lang.Override
          public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                  .SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveSegment
              getExtractiveSegments(int index) {
            return extractiveSegments_.get(index);
          }
          /**
           *
           *
           * <pre>
           * List of extractive segments.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveSegment extractive_segments = 5;
           * </code>
           */
          @java.lang.Override
          public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                  .SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveSegmentOrBuilder
              getExtractiveSegmentsOrBuilder(int index) {
            return extractiveSegments_.get(index);
          }

          public static final int EXTRACTIVE_ANSWERS_FIELD_NUMBER = 6;

          @SuppressWarnings("serial")
          private java.util.List<
                  com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                      .SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveAnswer>
              extractiveAnswers_;
          /**
           *
           *
           * <pre>
           * Deprecated: This field is deprecated and will have no effect on
           * the Answer generation.
           * Please use document_contexts and extractive_segments fields.
           * List of extractive answers.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveAnswer extractive_answers = 6 [deprecated = true];
           * </code>
           */
          @java.lang.Override
          @java.lang.Deprecated
          public java.util.List<
                  com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                      .SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveAnswer>
              getExtractiveAnswersList() {
            return extractiveAnswers_;
          }
          /**
           *
           *
           * <pre>
           * Deprecated: This field is deprecated and will have no effect on
           * the Answer generation.
           * Please use document_contexts and extractive_segments fields.
           * List of extractive answers.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveAnswer extractive_answers = 6 [deprecated = true];
           * </code>
           */
          @java.lang.Override
          @java.lang.Deprecated
          public java.util.List<
                  ? extends
                      com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                          .SearchResultList.SearchResult.UnstructuredDocumentInfo
                          .ExtractiveAnswerOrBuilder>
              getExtractiveAnswersOrBuilderList() {
            return extractiveAnswers_;
          }
          /**
           *
           *
           * <pre>
           * Deprecated: This field is deprecated and will have no effect on
           * the Answer generation.
           * Please use document_contexts and extractive_segments fields.
           * List of extractive answers.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveAnswer extractive_answers = 6 [deprecated = true];
           * </code>
           */
          @java.lang.Override
          @java.lang.Deprecated
          public int getExtractiveAnswersCount() {
            return extractiveAnswers_.size();
          }
          /**
           *
           *
           * <pre>
           * Deprecated: This field is deprecated and will have no effect on
           * the Answer generation.
           * Please use document_contexts and extractive_segments fields.
           * List of extractive answers.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveAnswer extractive_answers = 6 [deprecated = true];
           * </code>
           */
          @java.lang.Override
          @java.lang.Deprecated
          public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                  .SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveAnswer
              getExtractiveAnswers(int index) {
            return extractiveAnswers_.get(index);
          }
          /**
           *
           *
           * <pre>
           * Deprecated: This field is deprecated and will have no effect on
           * the Answer generation.
           * Please use document_contexts and extractive_segments fields.
           * List of extractive answers.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveAnswer extractive_answers = 6 [deprecated = true];
           * </code>
           */
          @java.lang.Override
          @java.lang.Deprecated
          public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                  .SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveAnswerOrBuilder
              getExtractiveAnswersOrBuilder(int index) {
            return extractiveAnswers_.get(index);
          }

          private byte memoizedIsInitialized = -1;

          @java.lang.Override
          public final boolean isInitialized() {
            byte isInitialized = memoizedIsInitialized;
            if (isInitialized == 1) return true;
            if (isInitialized == 0) return false;

            memoizedIsInitialized = 1;
            return true;
          }

          @java.lang.Override
          public void writeTo(com.google.protobuf.CodedOutputStream output)
              throws java.io.IOException {
            if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(document_)) {
              com.google.protobuf.GeneratedMessageV3.writeString(output, 1, document_);
            }
            if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uri_)) {
              com.google.protobuf.GeneratedMessageV3.writeString(output, 2, uri_);
            }
            if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(title_)) {
              com.google.protobuf.GeneratedMessageV3.writeString(output, 3, title_);
            }
            for (int i = 0; i < documentContexts_.size(); i++) {
              output.writeMessage(4, documentContexts_.get(i));
            }
            for (int i = 0; i < extractiveSegments_.size(); i++) {
              output.writeMessage(5, extractiveSegments_.get(i));
            }
            for (int i = 0; i < extractiveAnswers_.size(); i++) {
              output.writeMessage(6, extractiveAnswers_.get(i));
            }
            getUnknownFields().writeTo(output);
          }

          @java.lang.Override
          public int getSerializedSize() {
            int size = memoizedSize;
            if (size != -1) return size;

            size = 0;
            if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(document_)) {
              size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, document_);
            }
            if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uri_)) {
              size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, uri_);
            }
            if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(title_)) {
              size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, title_);
            }
            for (int i = 0; i < documentContexts_.size(); i++) {
              size +=
                  com.google.protobuf.CodedOutputStream.computeMessageSize(
                      4, documentContexts_.get(i));
            }
            for (int i = 0; i < extractiveSegments_.size(); i++) {
              size +=
                  com.google.protobuf.CodedOutputStream.computeMessageSize(
                      5, extractiveSegments_.get(i));
            }
            for (int i = 0; i < extractiveAnswers_.size(); i++) {
              size +=
                  com.google.protobuf.CodedOutputStream.computeMessageSize(
                      6, extractiveAnswers_.get(i));
            }
            size += getUnknownFields().getSerializedSize();
            memoizedSize = size;
            return size;
          }

          @java.lang.Override
          public boolean equals(final java.lang.Object obj) {
            if (obj == this) {
              return true;
            }
            if (!(obj
                instanceof
                com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                    .SearchResultList.SearchResult.UnstructuredDocumentInfo)) {
              return super.equals(obj);
            }
            com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList
                    .SearchResult.UnstructuredDocumentInfo
                other =
                    (com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                            .SearchResultList.SearchResult.UnstructuredDocumentInfo)
                        obj;

            if (!getDocument().equals(other.getDocument())) return false;
            if (!getUri().equals(other.getUri())) return false;
            if (!getTitle().equals(other.getTitle())) return false;
            if (!getDocumentContextsList().equals(other.getDocumentContextsList())) return false;
            if (!getExtractiveSegmentsList().equals(other.getExtractiveSegmentsList()))
              return false;
            if (!getExtractiveAnswersList().equals(other.getExtractiveAnswersList())) return false;
            if (!getUnknownFields().equals(other.getUnknownFields())) return false;
            return true;
          }

          @java.lang.Override
          public int hashCode() {
            if (memoizedHashCode != 0) {
              return memoizedHashCode;
            }
            int hash = 41;
            hash = (19 * hash) + getDescriptor().hashCode();
            hash = (37 * hash) + DOCUMENT_FIELD_NUMBER;
            hash = (53 * hash) + getDocument().hashCode();
            hash = (37 * hash) + URI_FIELD_NUMBER;
            hash = (53 * hash) + getUri().hashCode();
            hash = (37 * hash) + TITLE_FIELD_NUMBER;
            hash = (53 * hash) + getTitle().hashCode();
            if (getDocumentContextsCount() > 0) {
              hash = (37 * hash) + DOCUMENT_CONTEXTS_FIELD_NUMBER;
              hash = (53 * hash) + getDocumentContextsList().hashCode();
            }
            if (getExtractiveSegmentsCount() > 0) {
              hash = (37 * hash) + EXTRACTIVE_SEGMENTS_FIELD_NUMBER;
              hash = (53 * hash) + getExtractiveSegmentsList().hashCode();
            }
            if (getExtractiveAnswersCount() > 0) {
              hash = (37 * hash) + EXTRACTIVE_ANSWERS_FIELD_NUMBER;
              hash = (53 * hash) + getExtractiveAnswersList().hashCode();
            }
            hash = (29 * hash) + getUnknownFields().hashCode();
            memoizedHashCode = hash;
            return hash;
          }

          public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                  .SearchResultList.SearchResult.UnstructuredDocumentInfo
              parseFrom(java.nio.ByteBuffer data)
                  throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data);
          }

          public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                  .SearchResultList.SearchResult.UnstructuredDocumentInfo
              parseFrom(
                  java.nio.ByteBuffer data,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data, extensionRegistry);
          }

          public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                  .SearchResultList.SearchResult.UnstructuredDocumentInfo
              parseFrom(com.google.protobuf.ByteString data)
                  throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data);
          }

          public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                  .SearchResultList.SearchResult.UnstructuredDocumentInfo
              parseFrom(
                  com.google.protobuf.ByteString data,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data, extensionRegistry);
          }

          public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                  .SearchResultList.SearchResult.UnstructuredDocumentInfo
              parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data);
          }

          public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                  .SearchResultList.SearchResult.UnstructuredDocumentInfo
              parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data, extensionRegistry);
          }

          public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                  .SearchResultList.SearchResult.UnstructuredDocumentInfo
              parseFrom(java.io.InputStream input) throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
          }

          public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                  .SearchResultList.SearchResult.UnstructuredDocumentInfo
              parseFrom(
                  java.io.InputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
                PARSER, input, extensionRegistry);
          }

          public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                  .SearchResultList.SearchResult.UnstructuredDocumentInfo
              parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
                PARSER, input);
          }

          public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                  .SearchResultList.SearchResult.UnstructuredDocumentInfo
              parseDelimitedFrom(
                  java.io.InputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
                PARSER, input, extensionRegistry);
          }

          public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                  .SearchResultList.SearchResult.UnstructuredDocumentInfo
              parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
          }

          public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                  .SearchResultList.SearchResult.UnstructuredDocumentInfo
              parseFrom(
                  com.google.protobuf.CodedInputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
                PARSER, input, extensionRegistry);
          }

          @java.lang.Override
          public Builder newBuilderForType() {
            return newBuilder();
          }

          public static Builder newBuilder() {
            return DEFAULT_INSTANCE.toBuilder();
          }

          public static Builder newBuilder(
              com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList
                      .SearchResult.UnstructuredDocumentInfo
                  prototype) {
            return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
          }

          @java.lang.Override
          public Builder toBuilder() {
            return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
          }

          @java.lang.Override
          protected Builder newBuilderForType(
              com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            Builder builder = new Builder(parent);
            return builder;
          }
          /**
           *
           *
           * <pre>
           * Unstructured document information.
           * </pre>
           *
           * Protobuf type {@code
           * google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo}
           */
          public static final class Builder
              extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
              implements
              // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo)
              com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList
                  .SearchResult.UnstructuredDocumentInfoOrBuilder {
            public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
              return com.google.cloud.discoveryengine.v1beta.ConversationalSearchServiceProto
                  .internal_static_google_cloud_discoveryengine_v1beta_AnswerQueryRequest_SearchSpec_SearchResultList_SearchResult_UnstructuredDocumentInfo_descriptor;
            }

            @java.lang.Override
            protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
                internalGetFieldAccessorTable() {
              return com.google.cloud.discoveryengine.v1beta.ConversationalSearchServiceProto
                  .internal_static_google_cloud_discoveryengine_v1beta_AnswerQueryRequest_SearchSpec_SearchResultList_SearchResult_UnstructuredDocumentInfo_fieldAccessorTable
                  .ensureFieldAccessorsInitialized(
                      com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                          .SearchResultList.SearchResult.UnstructuredDocumentInfo.class,
                      com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                          .SearchResultList.SearchResult.UnstructuredDocumentInfo.Builder.class);
            }

            // Construct using
            // com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo.newBuilder()
            private Builder() {}

            private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
              super(parent);
            }

            @java.lang.Override
            public Builder clear() {
              super.clear();
              bitField0_ = 0;
              document_ = "";
              uri_ = "";
              title_ = "";
              if (documentContextsBuilder_ == null) {
                documentContexts_ = java.util.Collections.emptyList();
              } else {
                documentContexts_ = null;
                documentContextsBuilder_.clear();
              }
              bitField0_ = (bitField0_ & ~0x00000008);
              if (extractiveSegmentsBuilder_ == null) {
                extractiveSegments_ = java.util.Collections.emptyList();
              } else {
                extractiveSegments_ = null;
                extractiveSegmentsBuilder_.clear();
              }
              bitField0_ = (bitField0_ & ~0x00000010);
              if (extractiveAnswersBuilder_ == null) {
                extractiveAnswers_ = java.util.Collections.emptyList();
              } else {
                extractiveAnswers_ = null;
                extractiveAnswersBuilder_.clear();
              }
              bitField0_ = (bitField0_ & ~0x00000020);
              return this;
            }

            @java.lang.Override
            public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
              return com.google.cloud.discoveryengine.v1beta.ConversationalSearchServiceProto
                  .internal_static_google_cloud_discoveryengine_v1beta_AnswerQueryRequest_SearchSpec_SearchResultList_SearchResult_UnstructuredDocumentInfo_descriptor;
            }

            @java.lang.Override
            public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                    .SearchResultList.SearchResult.UnstructuredDocumentInfo
                getDefaultInstanceForType() {
              return com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                  .SearchResultList.SearchResult.UnstructuredDocumentInfo.getDefaultInstance();
            }

            @java.lang.Override
            public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                    .SearchResultList.SearchResult.UnstructuredDocumentInfo
                build() {
              com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList
                      .SearchResult.UnstructuredDocumentInfo
                  result = buildPartial();
              if (!result.isInitialized()) {
                throw newUninitializedMessageException(result);
              }
              return result;
            }

            @java.lang.Override
            public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                    .SearchResultList.SearchResult.UnstructuredDocumentInfo
                buildPartial() {
              com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList
                      .SearchResult.UnstructuredDocumentInfo
                  result =
                      new com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                          .SearchResultList.SearchResult.UnstructuredDocumentInfo(this);
              buildPartialRepeatedFields(result);
              if (bitField0_ != 0) {
                buildPartial0(result);
              }
              onBuilt();
              return result;
            }

            private void buildPartialRepeatedFields(
                com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                        .SearchResultList.SearchResult.UnstructuredDocumentInfo
                    result) {
              if (documentContextsBuilder_ == null) {
                if (((bitField0_ & 0x00000008) != 0)) {
                  documentContexts_ = java.util.Collections.unmodifiableList(documentContexts_);
                  bitField0_ = (bitField0_ & ~0x00000008);
                }
                result.documentContexts_ = documentContexts_;
              } else {
                result.documentContexts_ = documentContextsBuilder_.build();
              }
              if (extractiveSegmentsBuilder_ == null) {
                if (((bitField0_ & 0x00000010) != 0)) {
                  extractiveSegments_ = java.util.Collections.unmodifiableList(extractiveSegments_);
                  bitField0_ = (bitField0_ & ~0x00000010);
                }
                result.extractiveSegments_ = extractiveSegments_;
              } else {
                result.extractiveSegments_ = extractiveSegmentsBuilder_.build();
              }
              if (extractiveAnswersBuilder_ == null) {
                if (((bitField0_ & 0x00000020) != 0)) {
                  extractiveAnswers_ = java.util.Collections.unmodifiableList(extractiveAnswers_);
                  bitField0_ = (bitField0_ & ~0x00000020);
                }
                result.extractiveAnswers_ = extractiveAnswers_;
              } else {
                result.extractiveAnswers_ = extractiveAnswersBuilder_.build();
              }
            }

            private void buildPartial0(
                com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                        .SearchResultList.SearchResult.UnstructuredDocumentInfo
                    result) {
              int from_bitField0_ = bitField0_;
              if (((from_bitField0_ & 0x00000001) != 0)) {
                result.document_ = document_;
              }
              if (((from_bitField0_ & 0x00000002) != 0)) {
                result.uri_ = uri_;
              }
              if (((from_bitField0_ & 0x00000004) != 0)) {
                result.title_ = title_;
              }
            }

            @java.lang.Override
            public Builder clone() {
              return super.clone();
            }

            @java.lang.Override
            public Builder setField(
                com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
              return super.setField(field, value);
            }

            @java.lang.Override
            public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
              return super.clearField(field);
            }

            @java.lang.Override
            public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
              return super.clearOneof(oneof);
            }

            @java.lang.Override
            public Builder setRepeatedField(
                com.google.protobuf.Descriptors.FieldDescriptor field,
                int index,
                java.lang.Object value) {
              return super.setRepeatedField(field, index, value);
            }

            @java.lang.Override
            public Builder addRepeatedField(
                com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
              return super.addRepeatedField(field, value);
            }

            @java.lang.Override
            public Builder mergeFrom(com.google.protobuf.Message other) {
              if (other
                  instanceof
                  com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                      .SearchResultList.SearchResult.UnstructuredDocumentInfo) {
                return mergeFrom(
                    (com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                            .SearchResultList.SearchResult.UnstructuredDocumentInfo)
                        other);
              } else {
                super.mergeFrom(other);
                return this;
              }
            }

            public Builder mergeFrom(
                com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                        .SearchResultList.SearchResult.UnstructuredDocumentInfo
                    other) {
              if (other
                  == com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                      .SearchResultList.SearchResult.UnstructuredDocumentInfo.getDefaultInstance())
                return this;
              if (!other.getDocument().isEmpty()) {
                document_ = other.document_;
                bitField0_ |= 0x00000001;
                onChanged();
              }
              if (!other.getUri().isEmpty()) {
                uri_ = other.uri_;
                bitField0_ |= 0x00000002;
                onChanged();
              }
              if (!other.getTitle().isEmpty()) {
                title_ = other.title_;
                bitField0_ |= 0x00000004;
                onChanged();
              }
              if (documentContextsBuilder_ == null) {
                if (!other.documentContexts_.isEmpty()) {
                  if (documentContexts_.isEmpty()) {
                    documentContexts_ = other.documentContexts_;
                    bitField0_ = (bitField0_ & ~0x00000008);
                  } else {
                    ensureDocumentContextsIsMutable();
                    documentContexts_.addAll(other.documentContexts_);
                  }
                  onChanged();
                }
              } else {
                if (!other.documentContexts_.isEmpty()) {
                  if (documentContextsBuilder_.isEmpty()) {
                    documentContextsBuilder_.dispose();
                    documentContextsBuilder_ = null;
                    documentContexts_ = other.documentContexts_;
                    bitField0_ = (bitField0_ & ~0x00000008);
                    documentContextsBuilder_ =
                        com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                            ? getDocumentContextsFieldBuilder()
                            : null;
                  } else {
                    documentContextsBuilder_.addAllMessages(other.documentContexts_);
                  }
                }
              }
              if (extractiveSegmentsBuilder_ == null) {
                if (!other.extractiveSegments_.isEmpty()) {
                  if (extractiveSegments_.isEmpty()) {
                    extractiveSegments_ = other.extractiveSegments_;
                    bitField0_ = (bitField0_ & ~0x00000010);
                  } else {
                    ensureExtractiveSegmentsIsMutable();
                    extractiveSegments_.addAll(other.extractiveSegments_);
                  }
                  onChanged();
                }
              } else {
                if (!other.extractiveSegments_.isEmpty()) {
                  if (extractiveSegmentsBuilder_.isEmpty()) {
                    extractiveSegmentsBuilder_.dispose();
                    extractiveSegmentsBuilder_ = null;
                    extractiveSegments_ = other.extractiveSegments_;
                    bitField0_ = (bitField0_ & ~0x00000010);
                    extractiveSegmentsBuilder_ =
                        com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                            ? getExtractiveSegmentsFieldBuilder()
                            : null;
                  } else {
                    extractiveSegmentsBuilder_.addAllMessages(other.extractiveSegments_);
                  }
                }
              }
              if (extractiveAnswersBuilder_ == null) {
                if (!other.extractiveAnswers_.isEmpty()) {
                  if (extractiveAnswers_.isEmpty()) {
                    extractiveAnswers_ = other.extractiveAnswers_;
                    bitField0_ = (bitField0_ & ~0x00000020);
                  } else {
                    ensureExtractiveAnswersIsMutable();
                    extractiveAnswers_.addAll(other.extractiveAnswers_);
                  }
                  onChanged();
                }
              } else {
                if (!other.extractiveAnswers_.isEmpty()) {
                  if (extractiveAnswersBuilder_.isEmpty()) {
                    extractiveAnswersBuilder_.dispose();
                    extractiveAnswersBuilder_ = null;
                    extractiveAnswers_ = other.extractiveAnswers_;
                    bitField0_ = (bitField0_ & ~0x00000020);
                    extractiveAnswersBuilder_ =
                        com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                            ? getExtractiveAnswersFieldBuilder()
                            : null;
                  } else {
                    extractiveAnswersBuilder_.addAllMessages(other.extractiveAnswers_);
                  }
                }
              }
              this.mergeUnknownFields(other.getUnknownFields());
              onChanged();
              return this;
            }

            @java.lang.Override
            public final boolean isInitialized() {
              return true;
            }

            @java.lang.Override
            public Builder mergeFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
              if (extensionRegistry == null) {
                throw new java.lang.NullPointerException();
              }
              try {
                boolean done = false;
                while (!done) {
                  int tag = input.readTag();
                  switch (tag) {
                    case 0:
                      done = true;
                      break;
                    case 10:
                      {
                        document_ = input.readStringRequireUtf8();
                        bitField0_ |= 0x00000001;
                        break;
                      } // case 10
                    case 18:
                      {
                        uri_ = input.readStringRequireUtf8();
                        bitField0_ |= 0x00000002;
                        break;
                      } // case 18
                    case 26:
                      {
                        title_ = input.readStringRequireUtf8();
                        bitField0_ |= 0x00000004;
                        break;
                      } // case 26
                    case 34:
                      {
                        com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                                .SearchResultList.SearchResult.UnstructuredDocumentInfo
                                .DocumentContext
                            m =
                                input.readMessage(
                                    com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest
                                        .SearchSpec.SearchResultList.SearchResult
                                        .UnstructuredDocumentInfo.DocumentContext.parser(),
                                    extensionRegistry);
                        if (documentContextsBuilder_ == null) {
                          ensureDocumentContextsIsMutable();
                          documentContexts_.add(m);
                        } else {
                          documentContextsBuilder_.addMessage(m);
                        }
                        break;
                      } // case 34
                    case 42:
                      {
                        com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                                .SearchResultList.SearchResult.UnstructuredDocumentInfo
                                .ExtractiveSegment
                            m =
                                input.readMessage(
                                    com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest
                                        .SearchSpec.SearchResultList.SearchResult
                                        .UnstructuredDocumentInfo.ExtractiveSegment.parser(),
                                    extensionRegistry);
                        if (extractiveSegmentsBuilder_ == null) {
                          ensureExtractiveSegmentsIsMutable();
                          extractiveSegments_.add(m);
                        } else {
                          extractiveSegmentsBuilder_.addMessage(m);
                        }
                        break;
                      } // case 42
                    case 50:
                      {
                        com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                                .SearchResultList.SearchResult.UnstructuredDocumentInfo
                                .ExtractiveAnswer
                            m =
                                input.readMessage(
                                    com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest
                                        .SearchSpec.SearchResultList.SearchResult
                                        .UnstructuredDocumentInfo.ExtractiveAnswer.parser(),
                                    extensionRegistry);
                        if (extractiveAnswersBuilder_ == null) {
                          ensureExtractiveAnswersIsMutable();
                          extractiveAnswers_.add(m);
                        } else {
                          extractiveAnswersBuilder_.addMessage(m);
                        }
                        break;
                      } // case 50
                    default:
                      {
                        if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                          done = true; // was an endgroup tag
                        }
                        break;
                      } // default:
                  } // switch (tag)
                } // while (!done)
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
              } finally {
                onChanged();
              } // finally
              return this;
            }

            private int bitField0_;

            private java.lang.Object document_ = "";
            /**
             *
             *
             * <pre>
             * Document resource name.
             * </pre>
             *
             * <code>string document = 1 [(.google.api.resource_reference) = { ... }</code>
             *
             * @return The document.
             */
            public java.lang.String getDocument() {
              java.lang.Object ref = document_;
              if (!(ref instanceof java.lang.String)) {
                com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
                java.lang.String s = bs.toStringUtf8();
                document_ = s;
                return s;
              } else {
                return (java.lang.String) ref;
              }
            }
            /**
             *
             *
             * <pre>
             * Document resource name.
             * </pre>
             *
             * <code>string document = 1 [(.google.api.resource_reference) = { ... }</code>
             *
             * @return The bytes for document.
             */
            public com.google.protobuf.ByteString getDocumentBytes() {
              java.lang.Object ref = document_;
              if (ref instanceof String) {
                com.google.protobuf.ByteString b =
                    com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
                document_ = b;
                return b;
              } else {
                return (com.google.protobuf.ByteString) ref;
              }
            }
            /**
             *
             *
             * <pre>
             * Document resource name.
             * </pre>
             *
             * <code>string document = 1 [(.google.api.resource_reference) = { ... }</code>
             *
             * @param value The document to set.
             * @return This builder for chaining.
             */
            public Builder setDocument(java.lang.String value) {
              if (value == null) {
                throw new NullPointerException();
              }
              document_ = value;
              bitField0_ |= 0x00000001;
              onChanged();
              return this;
            }
            /**
             *
             *
             * <pre>
             * Document resource name.
             * </pre>
             *
             * <code>string document = 1 [(.google.api.resource_reference) = { ... }</code>
             *
             * @return This builder for chaining.
             */
            public Builder clearDocument() {
              document_ = getDefaultInstance().getDocument();
              bitField0_ = (bitField0_ & ~0x00000001);
              onChanged();
              return this;
            }
            /**
             *
             *
             * <pre>
             * Document resource name.
             * </pre>
             *
             * <code>string document = 1 [(.google.api.resource_reference) = { ... }</code>
             *
             * @param value The bytes for document to set.
             * @return This builder for chaining.
             */
            public Builder setDocumentBytes(com.google.protobuf.ByteString value) {
              if (value == null) {
                throw new NullPointerException();
              }
              checkByteStringIsUtf8(value);
              document_ = value;
              bitField0_ |= 0x00000001;
              onChanged();
              return this;
            }

            private java.lang.Object uri_ = "";
            /**
             *
             *
             * <pre>
             * URI for the document.
             * </pre>
             *
             * <code>string uri = 2;</code>
             *
             * @return The uri.
             */
            public java.lang.String getUri() {
              java.lang.Object ref = uri_;
              if (!(ref instanceof java.lang.String)) {
                com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
                java.lang.String s = bs.toStringUtf8();
                uri_ = s;
                return s;
              } else {
                return (java.lang.String) ref;
              }
            }
            /**
             *
             *
             * <pre>
             * URI for the document.
             * </pre>
             *
             * <code>string uri = 2;</code>
             *
             * @return The bytes for uri.
             */
            public com.google.protobuf.ByteString getUriBytes() {
              java.lang.Object ref = uri_;
              if (ref instanceof String) {
                com.google.protobuf.ByteString b =
                    com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
                uri_ = b;
                return b;
              } else {
                return (com.google.protobuf.ByteString) ref;
              }
            }
            /**
             *
             *
             * <pre>
             * URI for the document.
             * </pre>
             *
             * <code>string uri = 2;</code>
             *
             * @param value The uri to set.
             * @return This builder for chaining.
             */
            public Builder setUri(java.lang.String value) {
              if (value == null) {
                throw new NullPointerException();
              }
              uri_ = value;
              bitField0_ |= 0x00000002;
              onChanged();
              return this;
            }
            /**
             *
             *
             * <pre>
             * URI for the document.
             * </pre>
             *
             * <code>string uri = 2;</code>
             *
             * @return This builder for chaining.
             */
            public Builder clearUri() {
              uri_ = getDefaultInstance().getUri();
              bitField0_ = (bitField0_ & ~0x00000002);
              onChanged();
              return this;
            }
            /**
             *
             *
             * <pre>
             * URI for the document.
             * </pre>
             *
             * <code>string uri = 2;</code>
             *
             * @param value The bytes for uri to set.
             * @return This builder for chaining.
             */
            public Builder setUriBytes(com.google.protobuf.ByteString value) {
              if (value == null) {
                throw new NullPointerException();
              }
              checkByteStringIsUtf8(value);
              uri_ = value;
              bitField0_ |= 0x00000002;
              onChanged();
              return this;
            }

            private java.lang.Object title_ = "";
            /**
             *
             *
             * <pre>
             * Title.
             * </pre>
             *
             * <code>string title = 3;</code>
             *
             * @return The title.
             */
            public java.lang.String getTitle() {
              java.lang.Object ref = title_;
              if (!(ref instanceof java.lang.String)) {
                com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
                java.lang.String s = bs.toStringUtf8();
                title_ = s;
                return s;
              } else {
                return (java.lang.String) ref;
              }
            }
            /**
             *
             *
             * <pre>
             * Title.
             * </pre>
             *
             * <code>string title = 3;</code>
             *
             * @return The bytes for title.
             */
            public com.google.protobuf.ByteString getTitleBytes() {
              java.lang.Object ref = title_;
              if (ref instanceof String) {
                com.google.protobuf.ByteString b =
                    com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
                title_ = b;
                return b;
              } else {
                return (com.google.protobuf.ByteString) ref;
              }
            }
            /**
             *
             *
             * <pre>
             * Title.
             * </pre>
             *
             * <code>string title = 3;</code>
             *
             * @param value The title to set.
             * @return This builder for chaining.
             */
            public Builder setTitle(java.lang.String value) {
              if (value == null) {
                throw new NullPointerException();
              }
              title_ = value;
              bitField0_ |= 0x00000004;
              onChanged();
              return this;
            }
            /**
             *
             *
             * <pre>
             * Title.
             * </pre>
             *
             * <code>string title = 3;</code>
             *
             * @return This builder for chaining.
             */
            public Builder clearTitle() {
              title_ = getDefaultInstance().getTitle();
              bitField0_ = (bitField0_ & ~0x00000004);
              onChanged();
              return this;
            }
            /**
             *
             *
             * <pre>
             * Title.
             * </pre>
             *
             * <code>string title = 3;</code>
             *
             * @param value The bytes for title to set.
             * @return This builder for chaining.
             */
            public Builder setTitleBytes(com.google.protobuf.ByteString value) {
              if (value == null) {
                throw new NullPointerException();
              }
              checkByteStringIsUtf8(value);
              title_ = value;
              bitField0_ |= 0x00000004;
              onChanged();
              return this;
            }

            private java.util.List<
                    com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                        .SearchResultList.SearchResult.UnstructuredDocumentInfo.DocumentContext>
                documentContexts_ = java.util.Collections.emptyList();

            private void ensureDocumentContextsIsMutable() {
              if (!((bitField0_ & 0x00000008) != 0)) {
                documentContexts_ =
                    new java.util.ArrayList<
                        com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                            .SearchResultList.SearchResult.UnstructuredDocumentInfo
                            .DocumentContext>(documentContexts_);
                bitField0_ |= 0x00000008;
              }
            }

            private com.google.protobuf.RepeatedFieldBuilderV3<
                    com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                        .SearchResultList.SearchResult.UnstructuredDocumentInfo.DocumentContext,
                    com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                        .SearchResultList.SearchResult.UnstructuredDocumentInfo.DocumentContext
                        .Builder,
                    com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                        .SearchResultList.SearchResult.UnstructuredDocumentInfo
                        .DocumentContextOrBuilder>
                documentContextsBuilder_;

            /**
             *
             *
             * <pre>
             * List of document contexts. The content will be used for Answer
             * Generation. This is supposed to be the main content of the document
             * that can be long and comprehensive.
             * </pre>
             *
             * <code>
             * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo.DocumentContext document_contexts = 4;
             * </code>
             */
            public java.util.List<
                    com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                        .SearchResultList.SearchResult.UnstructuredDocumentInfo.DocumentContext>
                getDocumentContextsList() {
              if (documentContextsBuilder_ == null) {
                return java.util.Collections.unmodifiableList(documentContexts_);
              } else {
                return documentContextsBuilder_.getMessageList();
              }
            }
            /**
             *
             *
             * <pre>
             * List of document contexts. The content will be used for Answer
             * Generation. This is supposed to be the main content of the document
             * that can be long and comprehensive.
             * </pre>
             *
             * <code>
             * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo.DocumentContext document_contexts = 4;
             * </code>
             */
            public int getDocumentContextsCount() {
              if (documentContextsBuilder_ == null) {
                return documentContexts_.size();
              } else {
                return documentContextsBuilder_.getCount();
              }
            }
            /**
             *
             *
             * <pre>
             * List of document contexts. The content will be used for Answer
             * Generation. This is supposed to be the main content of the document
             * that can be long and comprehensive.
             * </pre>
             *
             * <code>
             * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo.DocumentContext document_contexts = 4;
             * </code>
             */
            public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                    .SearchResultList.SearchResult.UnstructuredDocumentInfo.DocumentContext
                getDocumentContexts(int index) {
              if (documentContextsBuilder_ == null) {
                return documentContexts_.get(index);
              } else {
                return documentContextsBuilder_.getMessage(index);
              }
            }
            /**
             *
             *
             * <pre>
             * List of document contexts. The content will be used for Answer
             * Generation. This is supposed to be the main content of the document
             * that can be long and comprehensive.
             * </pre>
             *
             * <code>
             * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo.DocumentContext document_contexts = 4;
             * </code>
             */
            public Builder setDocumentContexts(
                int index,
                com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                        .SearchResultList.SearchResult.UnstructuredDocumentInfo.DocumentContext
                    value) {
              if (documentContextsBuilder_ == null) {
                if (value == null) {
                  throw new NullPointerException();
                }
                ensureDocumentContextsIsMutable();
                documentContexts_.set(index, value);
                onChanged();
              } else {
                documentContextsBuilder_.setMessage(index, value);
              }
              return this;
            }
            /**
             *
             *
             * <pre>
             * List of document contexts. The content will be used for Answer
             * Generation. This is supposed to be the main content of the document
             * that can be long and comprehensive.
             * </pre>
             *
             * <code>
             * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo.DocumentContext document_contexts = 4;
             * </code>
             */
            public Builder setDocumentContexts(
                int index,
                com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                        .SearchResultList.SearchResult.UnstructuredDocumentInfo.DocumentContext
                        .Builder
                    builderForValue) {
              if (documentContextsBuilder_ == null) {
                ensureDocumentContextsIsMutable();
                documentContexts_.set(index, builderForValue.build());
                onChanged();
              } else {
                documentContextsBuilder_.setMessage(index, builderForValue.build());
              }
              return this;
            }
            /**
             *
             *
             * <pre>
             * List of document contexts. The content will be used for Answer
             * Generation. This is supposed to be the main content of the document
             * that can be long and comprehensive.
             * </pre>
             *
             * <code>
             * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo.DocumentContext document_contexts = 4;
             * </code>
             */
            public Builder addDocumentContexts(
                com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                        .SearchResultList.SearchResult.UnstructuredDocumentInfo.DocumentContext
                    value) {
              if (documentContextsBuilder_ == null) {
                if (value == null) {
                  throw new NullPointerException();
                }
                ensureDocumentContextsIsMutable();
                documentContexts_.add(value);
                onChanged();
              } else {
                documentContextsBuilder_.addMessage(value);
              }
              return this;
            }
            /**
             *
             *
             * <pre>
             * List of document contexts. The content will be used for Answer
             * Generation. This is supposed to be the main content of the document
             * that can be long and comprehensive.
             * </pre>
             *
             * <code>
             * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo.DocumentContext document_contexts = 4;
             * </code>
             */
            public Builder addDocumentContexts(
                int index,
                com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                        .SearchResultList.SearchResult.UnstructuredDocumentInfo.DocumentContext
                    value) {
              if (documentContextsBuilder_ == null) {
                if (value == null) {
                  throw new NullPointerException();
                }
                ensureDocumentContextsIsMutable();
                documentContexts_.add(index, value);
                onChanged();
              } else {
                documentContextsBuilder_.addMessage(index, value);
              }
              return this;
            }
            /**
             *
             *
             * <pre>
             * List of document contexts. The content will be used for Answer
             * Generation. This is supposed to be the main content of the document
             * that can be long and comprehensive.
             * </pre>
             *
             * <code>
             * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo.DocumentContext document_contexts = 4;
             * </code>
             */
            public Builder addDocumentContexts(
                com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                        .SearchResultList.SearchResult.UnstructuredDocumentInfo.DocumentContext
                        .Builder
                    builderForValue) {
              if (documentContextsBuilder_ == null) {
                ensureDocumentContextsIsMutable();
                documentContexts_.add(builderForValue.build());
                onChanged();
              } else {
                documentContextsBuilder_.addMessage(builderForValue.build());
              }
              return this;
            }
            /**
             *
             *
             * <pre>
             * List of document contexts. The content will be used for Answer
             * Generation. This is supposed to be the main content of the document
             * that can be long and comprehensive.
             * </pre>
             *
             * <code>
             * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo.DocumentContext document_contexts = 4;
             * </code>
             */
            public Builder addDocumentContexts(
                int index,
                com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                        .SearchResultList.SearchResult.UnstructuredDocumentInfo.DocumentContext
                        .Builder
                    builderForValue) {
              if (documentContextsBuilder_ == null) {
                ensureDocumentContextsIsMutable();
                documentContexts_.add(index, builderForValue.build());
                onChanged();
              } else {
                documentContextsBuilder_.addMessage(index, builderForValue.build());
              }
              return this;
            }
            /**
             *
             *
             * <pre>
             * List of document contexts. The content will be used for Answer
             * Generation. This is supposed to be the main content of the document
             * that can be long and comprehensive.
             * </pre>
             *
             * <code>
             * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo.DocumentContext document_contexts = 4;
             * </code>
             */
            public Builder addAllDocumentContexts(
                java.lang.Iterable<
                        ? extends
                            com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                                .SearchResultList.SearchResult.UnstructuredDocumentInfo
                                .DocumentContext>
                    values) {
              if (documentContextsBuilder_ == null) {
                ensureDocumentContextsIsMutable();
                com.google.protobuf.AbstractMessageLite.Builder.addAll(values, documentContexts_);
                onChanged();
              } else {
                documentContextsBuilder_.addAllMessages(values);
              }
              return this;
            }
            /**
             *
             *
             * <pre>
             * List of document contexts. The content will be used for Answer
             * Generation. This is supposed to be the main content of the document
             * that can be long and comprehensive.
             * </pre>
             *
             * <code>
             * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo.DocumentContext document_contexts = 4;
             * </code>
             */
            public Builder clearDocumentContexts() {
              if (documentContextsBuilder_ == null) {
                documentContexts_ = java.util.Collections.emptyList();
                bitField0_ = (bitField0_ & ~0x00000008);
                onChanged();
              } else {
                documentContextsBuilder_.clear();
              }
              return this;
            }
            /**
             *
             *
             * <pre>
             * List of document contexts. The content will be used for Answer
             * Generation. This is supposed to be the main content of the document
             * that can be long and comprehensive.
             * </pre>
             *
             * <code>
             * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo.DocumentContext document_contexts = 4;
             * </code>
             */
            public Builder removeDocumentContexts(int index) {
              if (documentContextsBuilder_ == null) {
                ensureDocumentContextsIsMutable();
                documentContexts_.remove(index);
                onChanged();
              } else {
                documentContextsBuilder_.remove(index);
              }
              return this;
            }
            /**
             *
             *
             * <pre>
             * List of document contexts. The content will be used for Answer
             * Generation. This is supposed to be the main content of the document
             * that can be long and comprehensive.
             * </pre>
             *
             * <code>
             * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo.DocumentContext document_contexts = 4;
             * </code>
             */
            public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                    .SearchResultList.SearchResult.UnstructuredDocumentInfo.DocumentContext.Builder
                getDocumentContextsBuilder(int index) {
              return getDocumentContextsFieldBuilder().getBuilder(index);
            }
            /**
             *
             *
             * <pre>
             * List of document contexts. The content will be used for Answer
             * Generation. This is supposed to be the main content of the document
             * that can be long and comprehensive.
             * </pre>
             *
             * <code>
             * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo.DocumentContext document_contexts = 4;
             * </code>
             */
            public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                    .SearchResultList.SearchResult.UnstructuredDocumentInfo.DocumentContextOrBuilder
                getDocumentContextsOrBuilder(int index) {
              if (documentContextsBuilder_ == null) {
                return documentContexts_.get(index);
              } else {
                return documentContextsBuilder_.getMessageOrBuilder(index);
              }
            }
            /**
             *
             *
             * <pre>
             * List of document contexts. The content will be used for Answer
             * Generation. This is supposed to be the main content of the document
             * that can be long and comprehensive.
             * </pre>
             *
             * <code>
             * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo.DocumentContext document_contexts = 4;
             * </code>
             */
            public java.util.List<
                    ? extends
                        com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                            .SearchResultList.SearchResult.UnstructuredDocumentInfo
                            .DocumentContextOrBuilder>
                getDocumentContextsOrBuilderList() {
              if (documentContextsBuilder_ != null) {
                return documentContextsBuilder_.getMessageOrBuilderList();
              } else {
                return java.util.Collections.unmodifiableList(documentContexts_);
              }
            }
            /**
             *
             *
             * <pre>
             * List of document contexts. The content will be used for Answer
             * Generation. This is supposed to be the main content of the document
             * that can be long and comprehensive.
             * </pre>
             *
             * <code>
             * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo.DocumentContext document_contexts = 4;
             * </code>
             */
            public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                    .SearchResultList.SearchResult.UnstructuredDocumentInfo.DocumentContext.Builder
                addDocumentContextsBuilder() {
              return getDocumentContextsFieldBuilder()
                  .addBuilder(
                      com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                          .SearchResultList.SearchResult.UnstructuredDocumentInfo.DocumentContext
                          .getDefaultInstance());
            }
            /**
             *
             *
             * <pre>
             * List of document contexts. The content will be used for Answer
             * Generation. This is supposed to be the main content of the document
             * that can be long and comprehensive.
             * </pre>
             *
             * <code>
             * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo.DocumentContext document_contexts = 4;
             * </code>
             */
            public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                    .SearchResultList.SearchResult.UnstructuredDocumentInfo.DocumentContext.Builder
                addDocumentContextsBuilder(int index) {
              return getDocumentContextsFieldBuilder()
                  .addBuilder(
                      index,
                      com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                          .SearchResultList.SearchResult.UnstructuredDocumentInfo.DocumentContext
                          .getDefaultInstance());
            }
            /**
             *
             *
             * <pre>
             * List of document contexts. The content will be used for Answer
             * Generation. This is supposed to be the main content of the document
             * that can be long and comprehensive.
             * </pre>
             *
             * <code>
             * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo.DocumentContext document_contexts = 4;
             * </code>
             */
            public java.util.List<
                    com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                        .SearchResultList.SearchResult.UnstructuredDocumentInfo.DocumentContext
                        .Builder>
                getDocumentContextsBuilderList() {
              return getDocumentContextsFieldBuilder().getBuilderList();
            }

            private com.google.protobuf.RepeatedFieldBuilderV3<
                    com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                        .SearchResultList.SearchResult.UnstructuredDocumentInfo.DocumentContext,
                    com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                        .SearchResultList.SearchResult.UnstructuredDocumentInfo.DocumentContext
                        .Builder,
                    com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                        .SearchResultList.SearchResult.UnstructuredDocumentInfo
                        .DocumentContextOrBuilder>
                getDocumentContextsFieldBuilder() {
              if (documentContextsBuilder_ == null) {
                documentContextsBuilder_ =
                    new com.google.protobuf.RepeatedFieldBuilderV3<
                        com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                            .SearchResultList.SearchResult.UnstructuredDocumentInfo.DocumentContext,
                        com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                            .SearchResultList.SearchResult.UnstructuredDocumentInfo.DocumentContext
                            .Builder,
                        com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                            .SearchResultList.SearchResult.UnstructuredDocumentInfo
                            .DocumentContextOrBuilder>(
                        documentContexts_,
                        ((bitField0_ & 0x00000008) != 0),
                        getParentForChildren(),
                        isClean());
                documentContexts_ = null;
              }
              return documentContextsBuilder_;
            }

            private java.util.List<
                    com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                        .SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveSegment>
                extractiveSegments_ = java.util.Collections.emptyList();

            private void ensureExtractiveSegmentsIsMutable() {
              if (!((bitField0_ & 0x00000010) != 0)) {
                extractiveSegments_ =
                    new java.util.ArrayList<
                        com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                            .SearchResultList.SearchResult.UnstructuredDocumentInfo
                            .ExtractiveSegment>(extractiveSegments_);
                bitField0_ |= 0x00000010;
              }
            }

            private com.google.protobuf.RepeatedFieldBuilderV3<
                    com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                        .SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveSegment,
                    com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                        .SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveSegment
                        .Builder,
                    com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                        .SearchResultList.SearchResult.UnstructuredDocumentInfo
                        .ExtractiveSegmentOrBuilder>
                extractiveSegmentsBuilder_;

            /**
             *
             *
             * <pre>
             * List of extractive segments.
             * </pre>
             *
             * <code>
             * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveSegment extractive_segments = 5;
             * </code>
             */
            public java.util.List<
                    com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                        .SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveSegment>
                getExtractiveSegmentsList() {
              if (extractiveSegmentsBuilder_ == null) {
                return java.util.Collections.unmodifiableList(extractiveSegments_);
              } else {
                return extractiveSegmentsBuilder_.getMessageList();
              }
            }
            /**
             *
             *
             * <pre>
             * List of extractive segments.
             * </pre>
             *
             * <code>
             * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveSegment extractive_segments = 5;
             * </code>
             */
            public int getExtractiveSegmentsCount() {
              if (extractiveSegmentsBuilder_ == null) {
                return extractiveSegments_.size();
              } else {
                return extractiveSegmentsBuilder_.getCount();
              }
            }
            /**
             *
             *
             * <pre>
             * List of extractive segments.
             * </pre>
             *
             * <code>
             * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveSegment extractive_segments = 5;
             * </code>
             */
            public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                    .SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveSegment
                getExtractiveSegments(int index) {
              if (extractiveSegmentsBuilder_ == null) {
                return extractiveSegments_.get(index);
              } else {
                return extractiveSegmentsBuilder_.getMessage(index);
              }
            }
            /**
             *
             *
             * <pre>
             * List of extractive segments.
             * </pre>
             *
             * <code>
             * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveSegment extractive_segments = 5;
             * </code>
             */
            public Builder setExtractiveSegments(
                int index,
                com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                        .SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveSegment
                    value) {
              if (extractiveSegmentsBuilder_ == null) {
                if (value == null) {
                  throw new NullPointerException();
                }
                ensureExtractiveSegmentsIsMutable();
                extractiveSegments_.set(index, value);
                onChanged();
              } else {
                extractiveSegmentsBuilder_.setMessage(index, value);
              }
              return this;
            }
            /**
             *
             *
             * <pre>
             * List of extractive segments.
             * </pre>
             *
             * <code>
             * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveSegment extractive_segments = 5;
             * </code>
             */
            public Builder setExtractiveSegments(
                int index,
                com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                        .SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveSegment
                        .Builder
                    builderForValue) {
              if (extractiveSegmentsBuilder_ == null) {
                ensureExtractiveSegmentsIsMutable();
                extractiveSegments_.set(index, builderForValue.build());
                onChanged();
              } else {
                extractiveSegmentsBuilder_.setMessage(index, builderForValue.build());
              }
              return this;
            }
            /**
             *
             *
             * <pre>
             * List of extractive segments.
             * </pre>
             *
             * <code>
             * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveSegment extractive_segments = 5;
             * </code>
             */
            public Builder addExtractiveSegments(
                com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                        .SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveSegment
                    value) {
              if (extractiveSegmentsBuilder_ == null) {
                if (value == null) {
                  throw new NullPointerException();
                }
                ensureExtractiveSegmentsIsMutable();
                extractiveSegments_.add(value);
                onChanged();
              } else {
                extractiveSegmentsBuilder_.addMessage(value);
              }
              return this;
            }
            /**
             *
             *
             * <pre>
             * List of extractive segments.
             * </pre>
             *
             * <code>
             * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveSegment extractive_segments = 5;
             * </code>
             */
            public Builder addExtractiveSegments(
                int index,
                com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                        .SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveSegment
                    value) {
              if (extractiveSegmentsBuilder_ == null) {
                if (value == null) {
                  throw new NullPointerException();
                }
                ensureExtractiveSegmentsIsMutable();
                extractiveSegments_.add(index, value);
                onChanged();
              } else {
                extractiveSegmentsBuilder_.addMessage(index, value);
              }
              return this;
            }
            /**
             *
             *
             * <pre>
             * List of extractive segments.
             * </pre>
             *
             * <code>
             * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveSegment extractive_segments = 5;
             * </code>
             */
            public Builder addExtractiveSegments(
                com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                        .SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveSegment
                        .Builder
                    builderForValue) {
              if (extractiveSegmentsBuilder_ == null) {
                ensureExtractiveSegmentsIsMutable();
                extractiveSegments_.add(builderForValue.build());
                onChanged();
              } else {
                extractiveSegmentsBuilder_.addMessage(builderForValue.build());
              }
              return this;
            }
            /**
             *
             *
             * <pre>
             * List of extractive segments.
             * </pre>
             *
             * <code>
             * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveSegment extractive_segments = 5;
             * </code>
             */
            public Builder addExtractiveSegments(
                int index,
                com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                        .SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveSegment
                        .Builder
                    builderForValue) {
              if (extractiveSegmentsBuilder_ == null) {
                ensureExtractiveSegmentsIsMutable();
                extractiveSegments_.add(index, builderForValue.build());
                onChanged();
              } else {
                extractiveSegmentsBuilder_.addMessage(index, builderForValue.build());
              }
              return this;
            }
            /**
             *
             *
             * <pre>
             * List of extractive segments.
             * </pre>
             *
             * <code>
             * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveSegment extractive_segments = 5;
             * </code>
             */
            public Builder addAllExtractiveSegments(
                java.lang.Iterable<
                        ? extends
                            com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                                .SearchResultList.SearchResult.UnstructuredDocumentInfo
                                .ExtractiveSegment>
                    values) {
              if (extractiveSegmentsBuilder_ == null) {
                ensureExtractiveSegmentsIsMutable();
                com.google.protobuf.AbstractMessageLite.Builder.addAll(values, extractiveSegments_);
                onChanged();
              } else {
                extractiveSegmentsBuilder_.addAllMessages(values);
              }
              return this;
            }
            /**
             *
             *
             * <pre>
             * List of extractive segments.
             * </pre>
             *
             * <code>
             * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveSegment extractive_segments = 5;
             * </code>
             */
            public Builder clearExtractiveSegments() {
              if (extractiveSegmentsBuilder_ == null) {
                extractiveSegments_ = java.util.Collections.emptyList();
                bitField0_ = (bitField0_ & ~0x00000010);
                onChanged();
              } else {
                extractiveSegmentsBuilder_.clear();
              }
              return this;
            }
            /**
             *
             *
             * <pre>
             * List of extractive segments.
             * </pre>
             *
             * <code>
             * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveSegment extractive_segments = 5;
             * </code>
             */
            public Builder removeExtractiveSegments(int index) {
              if (extractiveSegmentsBuilder_ == null) {
                ensureExtractiveSegmentsIsMutable();
                extractiveSegments_.remove(index);
                onChanged();
              } else {
                extractiveSegmentsBuilder_.remove(index);
              }
              return this;
            }
            /**
             *
             *
             * <pre>
             * List of extractive segments.
             * </pre>
             *
             * <code>
             * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveSegment extractive_segments = 5;
             * </code>
             */
            public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                    .SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveSegment
                    .Builder
                getExtractiveSegmentsBuilder(int index) {
              return getExtractiveSegmentsFieldBuilder().getBuilder(index);
            }
            /**
             *
             *
             * <pre>
             * List of extractive segments.
             * </pre>
             *
             * <code>
             * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveSegment extractive_segments = 5;
             * </code>
             */
            public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                    .SearchResultList.SearchResult.UnstructuredDocumentInfo
                    .ExtractiveSegmentOrBuilder
                getExtractiveSegmentsOrBuilder(int index) {
              if (extractiveSegmentsBuilder_ == null) {
                return extractiveSegments_.get(index);
              } else {
                return extractiveSegmentsBuilder_.getMessageOrBuilder(index);
              }
            }
            /**
             *
             *
             * <pre>
             * List of extractive segments.
             * </pre>
             *
             * <code>
             * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveSegment extractive_segments = 5;
             * </code>
             */
            public java.util.List<
                    ? extends
                        com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                            .SearchResultList.SearchResult.UnstructuredDocumentInfo
                            .ExtractiveSegmentOrBuilder>
                getExtractiveSegmentsOrBuilderList() {
              if (extractiveSegmentsBuilder_ != null) {
                return extractiveSegmentsBuilder_.getMessageOrBuilderList();
              } else {
                return java.util.Collections.unmodifiableList(extractiveSegments_);
              }
            }
            /**
             *
             *
             * <pre>
             * List of extractive segments.
             * </pre>
             *
             * <code>
             * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveSegment extractive_segments = 5;
             * </code>
             */
            public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                    .SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveSegment
                    .Builder
                addExtractiveSegmentsBuilder() {
              return getExtractiveSegmentsFieldBuilder()
                  .addBuilder(
                      com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                          .SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveSegment
                          .getDefaultInstance());
            }
            /**
             *
             *
             * <pre>
             * List of extractive segments.
             * </pre>
             *
             * <code>
             * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveSegment extractive_segments = 5;
             * </code>
             */
            public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                    .SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveSegment
                    .Builder
                addExtractiveSegmentsBuilder(int index) {
              return getExtractiveSegmentsFieldBuilder()
                  .addBuilder(
                      index,
                      com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                          .SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveSegment
                          .getDefaultInstance());
            }
            /**
             *
             *
             * <pre>
             * List of extractive segments.
             * </pre>
             *
             * <code>
             * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveSegment extractive_segments = 5;
             * </code>
             */
            public java.util.List<
                    com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                        .SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveSegment
                        .Builder>
                getExtractiveSegmentsBuilderList() {
              return getExtractiveSegmentsFieldBuilder().getBuilderList();
            }

            private com.google.protobuf.RepeatedFieldBuilderV3<
                    com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                        .SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveSegment,
                    com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                        .SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveSegment
                        .Builder,
                    com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                        .SearchResultList.SearchResult.UnstructuredDocumentInfo
                        .ExtractiveSegmentOrBuilder>
                getExtractiveSegmentsFieldBuilder() {
              if (extractiveSegmentsBuilder_ == null) {
                extractiveSegmentsBuilder_ =
                    new com.google.protobuf.RepeatedFieldBuilderV3<
                        com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                            .SearchResultList.SearchResult.UnstructuredDocumentInfo
                            .ExtractiveSegment,
                        com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                            .SearchResultList.SearchResult.UnstructuredDocumentInfo
                            .ExtractiveSegment.Builder,
                        com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                            .SearchResultList.SearchResult.UnstructuredDocumentInfo
                            .ExtractiveSegmentOrBuilder>(
                        extractiveSegments_,
                        ((bitField0_ & 0x00000010) != 0),
                        getParentForChildren(),
                        isClean());
                extractiveSegments_ = null;
              }
              return extractiveSegmentsBuilder_;
            }

            private java.util.List<
                    com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                        .SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveAnswer>
                extractiveAnswers_ = java.util.Collections.emptyList();

            private void ensureExtractiveAnswersIsMutable() {
              if (!((bitField0_ & 0x00000020) != 0)) {
                extractiveAnswers_ =
                    new java.util.ArrayList<
                        com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                            .SearchResultList.SearchResult.UnstructuredDocumentInfo
                            .ExtractiveAnswer>(extractiveAnswers_);
                bitField0_ |= 0x00000020;
              }
            }

            private com.google.protobuf.RepeatedFieldBuilderV3<
                    com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                        .SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveAnswer,
                    com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                        .SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveAnswer
                        .Builder,
                    com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                        .SearchResultList.SearchResult.UnstructuredDocumentInfo
                        .ExtractiveAnswerOrBuilder>
                extractiveAnswersBuilder_;

            /**
             *
             *
             * <pre>
             * Deprecated: This field is deprecated and will have no effect on
             * the Answer generation.
             * Please use document_contexts and extractive_segments fields.
             * List of extractive answers.
             * </pre>
             *
             * <code>
             * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveAnswer extractive_answers = 6 [deprecated = true];
             * </code>
             */
            @java.lang.Deprecated
            public java.util.List<
                    com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                        .SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveAnswer>
                getExtractiveAnswersList() {
              if (extractiveAnswersBuilder_ == null) {
                return java.util.Collections.unmodifiableList(extractiveAnswers_);
              } else {
                return extractiveAnswersBuilder_.getMessageList();
              }
            }
            /**
             *
             *
             * <pre>
             * Deprecated: This field is deprecated and will have no effect on
             * the Answer generation.
             * Please use document_contexts and extractive_segments fields.
             * List of extractive answers.
             * </pre>
             *
             * <code>
             * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveAnswer extractive_answers = 6 [deprecated = true];
             * </code>
             */
            @java.lang.Deprecated
            public int getExtractiveAnswersCount() {
              if (extractiveAnswersBuilder_ == null) {
                return extractiveAnswers_.size();
              } else {
                return extractiveAnswersBuilder_.getCount();
              }
            }
            /**
             *
             *
             * <pre>
             * Deprecated: This field is deprecated and will have no effect on
             * the Answer generation.
             * Please use document_contexts and extractive_segments fields.
             * List of extractive answers.
             * </pre>
             *
             * <code>
             * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveAnswer extractive_answers = 6 [deprecated = true];
             * </code>
             */
            @java.lang.Deprecated
            public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                    .SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveAnswer
                getExtractiveAnswers(int index) {
              if (extractiveAnswersBuilder_ == null) {
                return extractiveAnswers_.get(index);
              } else {
                return extractiveAnswersBuilder_.getMessage(index);
              }
            }
            /**
             *
             *
             * <pre>
             * Deprecated: This field is deprecated and will have no effect on
             * the Answer generation.
             * Please use document_contexts and extractive_segments fields.
             * List of extractive answers.
             * </pre>
             *
             * <code>
             * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveAnswer extractive_answers = 6 [deprecated = true];
             * </code>
             */
            @java.lang.Deprecated
            public Builder setExtractiveAnswers(
                int index,
                com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                        .SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveAnswer
                    value) {
              if (extractiveAnswersBuilder_ == null) {
                if (value == null) {
                  throw new NullPointerException();
                }
                ensureExtractiveAnswersIsMutable();
                extractiveAnswers_.set(index, value);
                onChanged();
              } else {
                extractiveAnswersBuilder_.setMessage(index, value);
              }
              return this;
            }
            /**
             *
             *
             * <pre>
             * Deprecated: This field is deprecated and will have no effect on
             * the Answer generation.
             * Please use document_contexts and extractive_segments fields.
             * List of extractive answers.
             * </pre>
             *
             * <code>
             * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveAnswer extractive_answers = 6 [deprecated = true];
             * </code>
             */
            @java.lang.Deprecated
            public Builder setExtractiveAnswers(
                int index,
                com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                        .SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveAnswer
                        .Builder
                    builderForValue) {
              if (extractiveAnswersBuilder_ == null) {
                ensureExtractiveAnswersIsMutable();
                extractiveAnswers_.set(index, builderForValue.build());
                onChanged();
              } else {
                extractiveAnswersBuilder_.setMessage(index, builderForValue.build());
              }
              return this;
            }
            /**
             *
             *
             * <pre>
             * Deprecated: This field is deprecated and will have no effect on
             * the Answer generation.
             * Please use document_contexts and extractive_segments fields.
             * List of extractive answers.
             * </pre>
             *
             * <code>
             * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveAnswer extractive_answers = 6 [deprecated = true];
             * </code>
             */
            @java.lang.Deprecated
            public Builder addExtractiveAnswers(
                com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                        .SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveAnswer
                    value) {
              if (extractiveAnswersBuilder_ == null) {
                if (value == null) {
                  throw new NullPointerException();
                }
                ensureExtractiveAnswersIsMutable();
                extractiveAnswers_.add(value);
                onChanged();
              } else {
                extractiveAnswersBuilder_.addMessage(value);
              }
              return this;
            }
            /**
             *
             *
             * <pre>
             * Deprecated: This field is deprecated and will have no effect on
             * the Answer generation.
             * Please use document_contexts and extractive_segments fields.
             * List of extractive answers.
             * </pre>
             *
             * <code>
             * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveAnswer extractive_answers = 6 [deprecated = true];
             * </code>
             */
            @java.lang.Deprecated
            public Builder addExtractiveAnswers(
                int index,
                com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                        .SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveAnswer
                    value) {
              if (extractiveAnswersBuilder_ == null) {
                if (value == null) {
                  throw new NullPointerException();
                }
                ensureExtractiveAnswersIsMutable();
                extractiveAnswers_.add(index, value);
                onChanged();
              } else {
                extractiveAnswersBuilder_.addMessage(index, value);
              }
              return this;
            }
            /**
             *
             *
             * <pre>
             * Deprecated: This field is deprecated and will have no effect on
             * the Answer generation.
             * Please use document_contexts and extractive_segments fields.
             * List of extractive answers.
             * </pre>
             *
             * <code>
             * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveAnswer extractive_answers = 6 [deprecated = true];
             * </code>
             */
            @java.lang.Deprecated
            public Builder addExtractiveAnswers(
                com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                        .SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveAnswer
                        .Builder
                    builderForValue) {
              if (extractiveAnswersBuilder_ == null) {
                ensureExtractiveAnswersIsMutable();
                extractiveAnswers_.add(builderForValue.build());
                onChanged();
              } else {
                extractiveAnswersBuilder_.addMessage(builderForValue.build());
              }
              return this;
            }
            /**
             *
             *
             * <pre>
             * Deprecated: This field is deprecated and will have no effect on
             * the Answer generation.
             * Please use document_contexts and extractive_segments fields.
             * List of extractive answers.
             * </pre>
             *
             * <code>
             * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveAnswer extractive_answers = 6 [deprecated = true];
             * </code>
             */
            @java.lang.Deprecated
            public Builder addExtractiveAnswers(
                int index,
                com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                        .SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveAnswer
                        .Builder
                    builderForValue) {
              if (extractiveAnswersBuilder_ == null) {
                ensureExtractiveAnswersIsMutable();
                extractiveAnswers_.add(index, builderForValue.build());
                onChanged();
              } else {
                extractiveAnswersBuilder_.addMessage(index, builderForValue.build());
              }
              return this;
            }
            /**
             *
             *
             * <pre>
             * Deprecated: This field is deprecated and will have no effect on
             * the Answer generation.
             * Please use document_contexts and extractive_segments fields.
             * List of extractive answers.
             * </pre>
             *
             * <code>
             * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveAnswer extractive_answers = 6 [deprecated = true];
             * </code>
             */
            @java.lang.Deprecated
            public Builder addAllExtractiveAnswers(
                java.lang.Iterable<
                        ? extends
                            com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                                .SearchResultList.SearchResult.UnstructuredDocumentInfo
                                .ExtractiveAnswer>
                    values) {
              if (extractiveAnswersBuilder_ == null) {
                ensureExtractiveAnswersIsMutable();
                com.google.protobuf.AbstractMessageLite.Builder.addAll(values, extractiveAnswers_);
                onChanged();
              } else {
                extractiveAnswersBuilder_.addAllMessages(values);
              }
              return this;
            }
            /**
             *
             *
             * <pre>
             * Deprecated: This field is deprecated and will have no effect on
             * the Answer generation.
             * Please use document_contexts and extractive_segments fields.
             * List of extractive answers.
             * </pre>
             *
             * <code>
             * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveAnswer extractive_answers = 6 [deprecated = true];
             * </code>
             */
            @java.lang.Deprecated
            public Builder clearExtractiveAnswers() {
              if (extractiveAnswersBuilder_ == null) {
                extractiveAnswers_ = java.util.Collections.emptyList();
                bitField0_ = (bitField0_ & ~0x00000020);
                onChanged();
              } else {
                extractiveAnswersBuilder_.clear();
              }
              return this;
            }
            /**
             *
             *
             * <pre>
             * Deprecated: This field is deprecated and will have no effect on
             * the Answer generation.
             * Please use document_contexts and extractive_segments fields.
             * List of extractive answers.
             * </pre>
             *
             * <code>
             * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveAnswer extractive_answers = 6 [deprecated = true];
             * </code>
             */
            @java.lang.Deprecated
            public Builder removeExtractiveAnswers(int index) {
              if (extractiveAnswersBuilder_ == null) {
                ensureExtractiveAnswersIsMutable();
                extractiveAnswers_.remove(index);
                onChanged();
              } else {
                extractiveAnswersBuilder_.remove(index);
              }
              return this;
            }
            /**
             *
             *
             * <pre>
             * Deprecated: This field is deprecated and will have no effect on
             * the Answer generation.
             * Please use document_contexts and extractive_segments fields.
             * List of extractive answers.
             * </pre>
             *
             * <code>
             * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveAnswer extractive_answers = 6 [deprecated = true];
             * </code>
             */
            @java.lang.Deprecated
            public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                    .SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveAnswer.Builder
                getExtractiveAnswersBuilder(int index) {
              return getExtractiveAnswersFieldBuilder().getBuilder(index);
            }
            /**
             *
             *
             * <pre>
             * Deprecated: This field is deprecated and will have no effect on
             * the Answer generation.
             * Please use document_contexts and extractive_segments fields.
             * List of extractive answers.
             * </pre>
             *
             * <code>
             * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveAnswer extractive_answers = 6 [deprecated = true];
             * </code>
             */
            @java.lang.Deprecated
            public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                    .SearchResultList.SearchResult.UnstructuredDocumentInfo
                    .ExtractiveAnswerOrBuilder
                getExtractiveAnswersOrBuilder(int index) {
              if (extractiveAnswersBuilder_ == null) {
                return extractiveAnswers_.get(index);
              } else {
                return extractiveAnswersBuilder_.getMessageOrBuilder(index);
              }
            }
            /**
             *
             *
             * <pre>
             * Deprecated: This field is deprecated and will have no effect on
             * the Answer generation.
             * Please use document_contexts and extractive_segments fields.
             * List of extractive answers.
             * </pre>
             *
             * <code>
             * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveAnswer extractive_answers = 6 [deprecated = true];
             * </code>
             */
            @java.lang.Deprecated
            public java.util.List<
                    ? extends
                        com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                            .SearchResultList.SearchResult.UnstructuredDocumentInfo
                            .ExtractiveAnswerOrBuilder>
                getExtractiveAnswersOrBuilderList() {
              if (extractiveAnswersBuilder_ != null) {
                return extractiveAnswersBuilder_.getMessageOrBuilderList();
              } else {
                return java.util.Collections.unmodifiableList(extractiveAnswers_);
              }
            }
            /**
             *
             *
             * <pre>
             * Deprecated: This field is deprecated and will have no effect on
             * the Answer generation.
             * Please use document_contexts and extractive_segments fields.
             * List of extractive answers.
             * </pre>
             *
             * <code>
             * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveAnswer extractive_answers = 6 [deprecated = true];
             * </code>
             */
            @java.lang.Deprecated
            public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                    .SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveAnswer.Builder
                addExtractiveAnswersBuilder() {
              return getExtractiveAnswersFieldBuilder()
                  .addBuilder(
                      com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                          .SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveAnswer
                          .getDefaultInstance());
            }
            /**
             *
             *
             * <pre>
             * Deprecated: This field is deprecated and will have no effect on
             * the Answer generation.
             * Please use document_contexts and extractive_segments fields.
             * List of extractive answers.
             * </pre>
             *
             * <code>
             * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveAnswer extractive_answers = 6 [deprecated = true];
             * </code>
             */
            @java.lang.Deprecated
            public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                    .SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveAnswer.Builder
                addExtractiveAnswersBuilder(int index) {
              return getExtractiveAnswersFieldBuilder()
                  .addBuilder(
                      index,
                      com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                          .SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveAnswer
                          .getDefaultInstance());
            }
            /**
             *
             *
             * <pre>
             * Deprecated: This field is deprecated and will have no effect on
             * the Answer generation.
             * Please use document_contexts and extractive_segments fields.
             * List of extractive answers.
             * </pre>
             *
             * <code>
             * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveAnswer extractive_answers = 6 [deprecated = true];
             * </code>
             */
            @java.lang.Deprecated
            public java.util.List<
                    com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                        .SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveAnswer
                        .Builder>
                getExtractiveAnswersBuilderList() {
              return getExtractiveAnswersFieldBuilder().getBuilderList();
            }

            private com.google.protobuf.RepeatedFieldBuilderV3<
                    com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                        .SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveAnswer,
                    com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                        .SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveAnswer
                        .Builder,
                    com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                        .SearchResultList.SearchResult.UnstructuredDocumentInfo
                        .ExtractiveAnswerOrBuilder>
                getExtractiveAnswersFieldBuilder() {
              if (extractiveAnswersBuilder_ == null) {
                extractiveAnswersBuilder_ =
                    new com.google.protobuf.RepeatedFieldBuilderV3<
                        com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                            .SearchResultList.SearchResult.UnstructuredDocumentInfo
                            .ExtractiveAnswer,
                        com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                            .SearchResultList.SearchResult.UnstructuredDocumentInfo.ExtractiveAnswer
                            .Builder,
                        com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                            .SearchResultList.SearchResult.UnstructuredDocumentInfo
                            .ExtractiveAnswerOrBuilder>(
                        extractiveAnswers_,
                        ((bitField0_ & 0x00000020) != 0),
                        getParentForChildren(),
                        isClean());
                extractiveAnswers_ = null;
              }
              return extractiveAnswersBuilder_;
            }

            @java.lang.Override
            public final Builder setUnknownFields(
                final com.google.protobuf.UnknownFieldSet unknownFields) {
              return super.setUnknownFields(unknownFields);
            }

            @java.lang.Override
            public final Builder mergeUnknownFields(
                final com.google.protobuf.UnknownFieldSet unknownFields) {
              return super.mergeUnknownFields(unknownFields);
            }

            // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo)
          }

          // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo)
          private static final com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                  .SearchResultList.SearchResult.UnstructuredDocumentInfo
              DEFAULT_INSTANCE;

          static {
            DEFAULT_INSTANCE =
                new com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                    .SearchResultList.SearchResult.UnstructuredDocumentInfo();
          }

          public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                  .SearchResultList.SearchResult.UnstructuredDocumentInfo
              getDefaultInstance() {
            return DEFAULT_INSTANCE;
          }

          private static final com.google.protobuf.Parser<UnstructuredDocumentInfo> PARSER =
              new com.google.protobuf.AbstractParser<UnstructuredDocumentInfo>() {
                @java.lang.Override
                public UnstructuredDocumentInfo parsePartialFrom(
                    com.google.protobuf.CodedInputStream input,
                    com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                    throws com.google.protobuf.InvalidProtocolBufferException {
                  Builder builder = newBuilder();
                  try {
                    builder.mergeFrom(input, extensionRegistry);
                  } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                    throw e.setUnfinishedMessage(builder.buildPartial());
                  } catch (com.google.protobuf.UninitializedMessageException e) {
                    throw e.asInvalidProtocolBufferException()
                        .setUnfinishedMessage(builder.buildPartial());
                  } catch (java.io.IOException e) {
                    throw new com.google.protobuf.InvalidProtocolBufferException(e)
                        .setUnfinishedMessage(builder.buildPartial());
                  }
                  return builder.buildPartial();
                }
              };

          public static com.google.protobuf.Parser<UnstructuredDocumentInfo> parser() {
            return PARSER;
          }

          @java.lang.Override
          public com.google.protobuf.Parser<UnstructuredDocumentInfo> getParserForType() {
            return PARSER;
          }

          @java.lang.Override
          public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                  .SearchResultList.SearchResult.UnstructuredDocumentInfo
              getDefaultInstanceForType() {
            return DEFAULT_INSTANCE;
          }
        }

        public interface ChunkInfoOrBuilder
            extends
            // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.ChunkInfo)
            com.google.protobuf.MessageOrBuilder {

          /**
           *
           *
           * <pre>
           * Chunk resource name.
           * </pre>
           *
           * <code>string chunk = 1 [(.google.api.resource_reference) = { ... }</code>
           *
           * @return The chunk.
           */
          java.lang.String getChunk();
          /**
           *
           *
           * <pre>
           * Chunk resource name.
           * </pre>
           *
           * <code>string chunk = 1 [(.google.api.resource_reference) = { ... }</code>
           *
           * @return The bytes for chunk.
           */
          com.google.protobuf.ByteString getChunkBytes();

          /**
           *
           *
           * <pre>
           * Chunk textual content.
           * </pre>
           *
           * <code>string content = 2;</code>
           *
           * @return The content.
           */
          java.lang.String getContent();
          /**
           *
           *
           * <pre>
           * Chunk textual content.
           * </pre>
           *
           * <code>string content = 2;</code>
           *
           * @return The bytes for content.
           */
          com.google.protobuf.ByteString getContentBytes();

          /**
           *
           *
           * <pre>
           * Metadata of the document from the current chunk.
           * </pre>
           *
           * <code>
           * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.ChunkInfo.DocumentMetadata document_metadata = 4;
           * </code>
           *
           * @return Whether the documentMetadata field is set.
           */
          boolean hasDocumentMetadata();
          /**
           *
           *
           * <pre>
           * Metadata of the document from the current chunk.
           * </pre>
           *
           * <code>
           * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.ChunkInfo.DocumentMetadata document_metadata = 4;
           * </code>
           *
           * @return The documentMetadata.
           */
          com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList
                  .SearchResult.ChunkInfo.DocumentMetadata
              getDocumentMetadata();
          /**
           *
           *
           * <pre>
           * Metadata of the document from the current chunk.
           * </pre>
           *
           * <code>
           * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.ChunkInfo.DocumentMetadata document_metadata = 4;
           * </code>
           */
          com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList
                  .SearchResult.ChunkInfo.DocumentMetadataOrBuilder
              getDocumentMetadataOrBuilder();
        }
        /**
         *
         *
         * <pre>
         * Chunk information.
         * </pre>
         *
         * Protobuf type {@code
         * google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.ChunkInfo}
         */
        public static final class ChunkInfo extends com.google.protobuf.GeneratedMessageV3
            implements
            // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.ChunkInfo)
            ChunkInfoOrBuilder {
          private static final long serialVersionUID = 0L;
          // Use ChunkInfo.newBuilder() to construct.
          private ChunkInfo(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
            super(builder);
          }

          private ChunkInfo() {
            chunk_ = "";
            content_ = "";
          }

          @java.lang.Override
          @SuppressWarnings({"unused"})
          protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
            return new ChunkInfo();
          }

          public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
            return com.google.cloud.discoveryengine.v1beta.ConversationalSearchServiceProto
                .internal_static_google_cloud_discoveryengine_v1beta_AnswerQueryRequest_SearchSpec_SearchResultList_SearchResult_ChunkInfo_descriptor;
          }

          @java.lang.Override
          protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
              internalGetFieldAccessorTable() {
            return com.google.cloud.discoveryengine.v1beta.ConversationalSearchServiceProto
                .internal_static_google_cloud_discoveryengine_v1beta_AnswerQueryRequest_SearchSpec_SearchResultList_SearchResult_ChunkInfo_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                        .SearchResultList.SearchResult.ChunkInfo.class,
                    com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                        .SearchResultList.SearchResult.ChunkInfo.Builder.class);
          }

          public interface DocumentMetadataOrBuilder
              extends
              // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.ChunkInfo.DocumentMetadata)
              com.google.protobuf.MessageOrBuilder {

            /**
             *
             *
             * <pre>
             * Uri of the document.
             * </pre>
             *
             * <code>string uri = 1;</code>
             *
             * @return The uri.
             */
            java.lang.String getUri();
            /**
             *
             *
             * <pre>
             * Uri of the document.
             * </pre>
             *
             * <code>string uri = 1;</code>
             *
             * @return The bytes for uri.
             */
            com.google.protobuf.ByteString getUriBytes();

            /**
             *
             *
             * <pre>
             * Title of the document.
             * </pre>
             *
             * <code>string title = 2;</code>
             *
             * @return The title.
             */
            java.lang.String getTitle();
            /**
             *
             *
             * <pre>
             * Title of the document.
             * </pre>
             *
             * <code>string title = 2;</code>
             *
             * @return The bytes for title.
             */
            com.google.protobuf.ByteString getTitleBytes();
          }
          /**
           *
           *
           * <pre>
           * Document metadata contains the information of the document of the
           * current chunk.
           * </pre>
           *
           * Protobuf type {@code
           * google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.ChunkInfo.DocumentMetadata}
           */
          public static final class DocumentMetadata extends com.google.protobuf.GeneratedMessageV3
              implements
              // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.ChunkInfo.DocumentMetadata)
              DocumentMetadataOrBuilder {
            private static final long serialVersionUID = 0L;
            // Use DocumentMetadata.newBuilder() to construct.
            private DocumentMetadata(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
              super(builder);
            }

            private DocumentMetadata() {
              uri_ = "";
              title_ = "";
            }

            @java.lang.Override
            @SuppressWarnings({"unused"})
            protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
              return new DocumentMetadata();
            }

            public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
              return com.google.cloud.discoveryengine.v1beta.ConversationalSearchServiceProto
                  .internal_static_google_cloud_discoveryengine_v1beta_AnswerQueryRequest_SearchSpec_SearchResultList_SearchResult_ChunkInfo_DocumentMetadata_descriptor;
            }

            @java.lang.Override
            protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
                internalGetFieldAccessorTable() {
              return com.google.cloud.discoveryengine.v1beta.ConversationalSearchServiceProto
                  .internal_static_google_cloud_discoveryengine_v1beta_AnswerQueryRequest_SearchSpec_SearchResultList_SearchResult_ChunkInfo_DocumentMetadata_fieldAccessorTable
                  .ensureFieldAccessorsInitialized(
                      com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                          .SearchResultList.SearchResult.ChunkInfo.DocumentMetadata.class,
                      com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                          .SearchResultList.SearchResult.ChunkInfo.DocumentMetadata.Builder.class);
            }

            public static final int URI_FIELD_NUMBER = 1;

            @SuppressWarnings("serial")
            private volatile java.lang.Object uri_ = "";
            /**
             *
             *
             * <pre>
             * Uri of the document.
             * </pre>
             *
             * <code>string uri = 1;</code>
             *
             * @return The uri.
             */
            @java.lang.Override
            public java.lang.String getUri() {
              java.lang.Object ref = uri_;
              if (ref instanceof java.lang.String) {
                return (java.lang.String) ref;
              } else {
                com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
                java.lang.String s = bs.toStringUtf8();
                uri_ = s;
                return s;
              }
            }
            /**
             *
             *
             * <pre>
             * Uri of the document.
             * </pre>
             *
             * <code>string uri = 1;</code>
             *
             * @return The bytes for uri.
             */
            @java.lang.Override
            public com.google.protobuf.ByteString getUriBytes() {
              java.lang.Object ref = uri_;
              if (ref instanceof java.lang.String) {
                com.google.protobuf.ByteString b =
                    com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
                uri_ = b;
                return b;
              } else {
                return (com.google.protobuf.ByteString) ref;
              }
            }

            public static final int TITLE_FIELD_NUMBER = 2;

            @SuppressWarnings("serial")
            private volatile java.lang.Object title_ = "";
            /**
             *
             *
             * <pre>
             * Title of the document.
             * </pre>
             *
             * <code>string title = 2;</code>
             *
             * @return The title.
             */
            @java.lang.Override
            public java.lang.String getTitle() {
              java.lang.Object ref = title_;
              if (ref instanceof java.lang.String) {
                return (java.lang.String) ref;
              } else {
                com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
                java.lang.String s = bs.toStringUtf8();
                title_ = s;
                return s;
              }
            }
            /**
             *
             *
             * <pre>
             * Title of the document.
             * </pre>
             *
             * <code>string title = 2;</code>
             *
             * @return The bytes for title.
             */
            @java.lang.Override
            public com.google.protobuf.ByteString getTitleBytes() {
              java.lang.Object ref = title_;
              if (ref instanceof java.lang.String) {
                com.google.protobuf.ByteString b =
                    com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
                title_ = b;
                return b;
              } else {
                return (com.google.protobuf.ByteString) ref;
              }
            }

            private byte memoizedIsInitialized = -1;

            @java.lang.Override
            public final boolean isInitialized() {
              byte isInitialized = memoizedIsInitialized;
              if (isInitialized == 1) return true;
              if (isInitialized == 0) return false;

              memoizedIsInitialized = 1;
              return true;
            }

            @java.lang.Override
            public void writeTo(com.google.protobuf.CodedOutputStream output)
                throws java.io.IOException {
              if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uri_)) {
                com.google.protobuf.GeneratedMessageV3.writeString(output, 1, uri_);
              }
              if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(title_)) {
                com.google.protobuf.GeneratedMessageV3.writeString(output, 2, title_);
              }
              getUnknownFields().writeTo(output);
            }

            @java.lang.Override
            public int getSerializedSize() {
              int size = memoizedSize;
              if (size != -1) return size;

              size = 0;
              if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uri_)) {
                size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, uri_);
              }
              if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(title_)) {
                size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, title_);
              }
              size += getUnknownFields().getSerializedSize();
              memoizedSize = size;
              return size;
            }

            @java.lang.Override
            public boolean equals(final java.lang.Object obj) {
              if (obj == this) {
                return true;
              }
              if (!(obj
                  instanceof
                  com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                      .SearchResultList.SearchResult.ChunkInfo.DocumentMetadata)) {
                return super.equals(obj);
              }
              com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList
                      .SearchResult.ChunkInfo.DocumentMetadata
                  other =
                      (com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                              .SearchResultList.SearchResult.ChunkInfo.DocumentMetadata)
                          obj;

              if (!getUri().equals(other.getUri())) return false;
              if (!getTitle().equals(other.getTitle())) return false;
              if (!getUnknownFields().equals(other.getUnknownFields())) return false;
              return true;
            }

            @java.lang.Override
            public int hashCode() {
              if (memoizedHashCode != 0) {
                return memoizedHashCode;
              }
              int hash = 41;
              hash = (19 * hash) + getDescriptor().hashCode();
              hash = (37 * hash) + URI_FIELD_NUMBER;
              hash = (53 * hash) + getUri().hashCode();
              hash = (37 * hash) + TITLE_FIELD_NUMBER;
              hash = (53 * hash) + getTitle().hashCode();
              hash = (29 * hash) + getUnknownFields().hashCode();
              memoizedHashCode = hash;
              return hash;
            }

            public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                    .SearchResultList.SearchResult.ChunkInfo.DocumentMetadata
                parseFrom(java.nio.ByteBuffer data)
                    throws com.google.protobuf.InvalidProtocolBufferException {
              return PARSER.parseFrom(data);
            }

            public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                    .SearchResultList.SearchResult.ChunkInfo.DocumentMetadata
                parseFrom(
                    java.nio.ByteBuffer data,
                    com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                    throws com.google.protobuf.InvalidProtocolBufferException {
              return PARSER.parseFrom(data, extensionRegistry);
            }

            public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                    .SearchResultList.SearchResult.ChunkInfo.DocumentMetadata
                parseFrom(com.google.protobuf.ByteString data)
                    throws com.google.protobuf.InvalidProtocolBufferException {
              return PARSER.parseFrom(data);
            }

            public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                    .SearchResultList.SearchResult.ChunkInfo.DocumentMetadata
                parseFrom(
                    com.google.protobuf.ByteString data,
                    com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                    throws com.google.protobuf.InvalidProtocolBufferException {
              return PARSER.parseFrom(data, extensionRegistry);
            }

            public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                    .SearchResultList.SearchResult.ChunkInfo.DocumentMetadata
                parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
              return PARSER.parseFrom(data);
            }

            public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                    .SearchResultList.SearchResult.ChunkInfo.DocumentMetadata
                parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                    throws com.google.protobuf.InvalidProtocolBufferException {
              return PARSER.parseFrom(data, extensionRegistry);
            }

            public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                    .SearchResultList.SearchResult.ChunkInfo.DocumentMetadata
                parseFrom(java.io.InputStream input) throws java.io.IOException {
              return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
            }

            public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                    .SearchResultList.SearchResult.ChunkInfo.DocumentMetadata
                parseFrom(
                    java.io.InputStream input,
                    com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                    throws java.io.IOException {
              return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
                  PARSER, input, extensionRegistry);
            }

            public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                    .SearchResultList.SearchResult.ChunkInfo.DocumentMetadata
                parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
              return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
                  PARSER, input);
            }

            public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                    .SearchResultList.SearchResult.ChunkInfo.DocumentMetadata
                parseDelimitedFrom(
                    java.io.InputStream input,
                    com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                    throws java.io.IOException {
              return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
                  PARSER, input, extensionRegistry);
            }

            public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                    .SearchResultList.SearchResult.ChunkInfo.DocumentMetadata
                parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
              return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
            }

            public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                    .SearchResultList.SearchResult.ChunkInfo.DocumentMetadata
                parseFrom(
                    com.google.protobuf.CodedInputStream input,
                    com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                    throws java.io.IOException {
              return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
                  PARSER, input, extensionRegistry);
            }

            @java.lang.Override
            public Builder newBuilderForType() {
              return newBuilder();
            }

            public static Builder newBuilder() {
              return DEFAULT_INSTANCE.toBuilder();
            }

            public static Builder newBuilder(
                com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                        .SearchResultList.SearchResult.ChunkInfo.DocumentMetadata
                    prototype) {
              return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
            }

            @java.lang.Override
            public Builder toBuilder() {
              return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
            }

            @java.lang.Override
            protected Builder newBuilderForType(
                com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
              Builder builder = new Builder(parent);
              return builder;
            }
            /**
             *
             *
             * <pre>
             * Document metadata contains the information of the document of the
             * current chunk.
             * </pre>
             *
             * Protobuf type {@code
             * google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.ChunkInfo.DocumentMetadata}
             */
            public static final class Builder
                extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
                implements
                // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.ChunkInfo.DocumentMetadata)
                com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                    .SearchResultList.SearchResult.ChunkInfo.DocumentMetadataOrBuilder {
              public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
                return com.google.cloud.discoveryengine.v1beta.ConversationalSearchServiceProto
                    .internal_static_google_cloud_discoveryengine_v1beta_AnswerQueryRequest_SearchSpec_SearchResultList_SearchResult_ChunkInfo_DocumentMetadata_descriptor;
              }

              @java.lang.Override
              protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
                  internalGetFieldAccessorTable() {
                return com.google.cloud.discoveryengine.v1beta.ConversationalSearchServiceProto
                    .internal_static_google_cloud_discoveryengine_v1beta_AnswerQueryRequest_SearchSpec_SearchResultList_SearchResult_ChunkInfo_DocumentMetadata_fieldAccessorTable
                    .ensureFieldAccessorsInitialized(
                        com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                            .SearchResultList.SearchResult.ChunkInfo.DocumentMetadata.class,
                        com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                            .SearchResultList.SearchResult.ChunkInfo.DocumentMetadata.Builder
                            .class);
              }

              // Construct using
              // com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.ChunkInfo.DocumentMetadata.newBuilder()
              private Builder() {}

              private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
                super(parent);
              }

              @java.lang.Override
              public Builder clear() {
                super.clear();
                bitField0_ = 0;
                uri_ = "";
                title_ = "";
                return this;
              }

              @java.lang.Override
              public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
                return com.google.cloud.discoveryengine.v1beta.ConversationalSearchServiceProto
                    .internal_static_google_cloud_discoveryengine_v1beta_AnswerQueryRequest_SearchSpec_SearchResultList_SearchResult_ChunkInfo_DocumentMetadata_descriptor;
              }

              @java.lang.Override
              public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                      .SearchResultList.SearchResult.ChunkInfo.DocumentMetadata
                  getDefaultInstanceForType() {
                return com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                    .SearchResultList.SearchResult.ChunkInfo.DocumentMetadata.getDefaultInstance();
              }

              @java.lang.Override
              public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                      .SearchResultList.SearchResult.ChunkInfo.DocumentMetadata
                  build() {
                com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                        .SearchResultList.SearchResult.ChunkInfo.DocumentMetadata
                    result = buildPartial();
                if (!result.isInitialized()) {
                  throw newUninitializedMessageException(result);
                }
                return result;
              }

              @java.lang.Override
              public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                      .SearchResultList.SearchResult.ChunkInfo.DocumentMetadata
                  buildPartial() {
                com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                        .SearchResultList.SearchResult.ChunkInfo.DocumentMetadata
                    result =
                        new com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                            .SearchResultList.SearchResult.ChunkInfo.DocumentMetadata(this);
                if (bitField0_ != 0) {
                  buildPartial0(result);
                }
                onBuilt();
                return result;
              }

              private void buildPartial0(
                  com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                          .SearchResultList.SearchResult.ChunkInfo.DocumentMetadata
                      result) {
                int from_bitField0_ = bitField0_;
                if (((from_bitField0_ & 0x00000001) != 0)) {
                  result.uri_ = uri_;
                }
                if (((from_bitField0_ & 0x00000002) != 0)) {
                  result.title_ = title_;
                }
              }

              @java.lang.Override
              public Builder clone() {
                return super.clone();
              }

              @java.lang.Override
              public Builder setField(
                  com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
                return super.setField(field, value);
              }

              @java.lang.Override
              public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
                return super.clearField(field);
              }

              @java.lang.Override
              public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
                return super.clearOneof(oneof);
              }

              @java.lang.Override
              public Builder setRepeatedField(
                  com.google.protobuf.Descriptors.FieldDescriptor field,
                  int index,
                  java.lang.Object value) {
                return super.setRepeatedField(field, index, value);
              }

              @java.lang.Override
              public Builder addRepeatedField(
                  com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
                return super.addRepeatedField(field, value);
              }

              @java.lang.Override
              public Builder mergeFrom(com.google.protobuf.Message other) {
                if (other
                    instanceof
                    com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                        .SearchResultList.SearchResult.ChunkInfo.DocumentMetadata) {
                  return mergeFrom(
                      (com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                              .SearchResultList.SearchResult.ChunkInfo.DocumentMetadata)
                          other);
                } else {
                  super.mergeFrom(other);
                  return this;
                }
              }

              public Builder mergeFrom(
                  com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                          .SearchResultList.SearchResult.ChunkInfo.DocumentMetadata
                      other) {
                if (other
                    == com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                        .SearchResultList.SearchResult.ChunkInfo.DocumentMetadata
                        .getDefaultInstance()) return this;
                if (!other.getUri().isEmpty()) {
                  uri_ = other.uri_;
                  bitField0_ |= 0x00000001;
                  onChanged();
                }
                if (!other.getTitle().isEmpty()) {
                  title_ = other.title_;
                  bitField0_ |= 0x00000002;
                  onChanged();
                }
                this.mergeUnknownFields(other.getUnknownFields());
                onChanged();
                return this;
              }

              @java.lang.Override
              public final boolean isInitialized() {
                return true;
              }

              @java.lang.Override
              public Builder mergeFrom(
                  com.google.protobuf.CodedInputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws java.io.IOException {
                if (extensionRegistry == null) {
                  throw new java.lang.NullPointerException();
                }
                try {
                  boolean done = false;
                  while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                      case 0:
                        done = true;
                        break;
                      case 10:
                        {
                          uri_ = input.readStringRequireUtf8();
                          bitField0_ |= 0x00000001;
                          break;
                        } // case 10
                      case 18:
                        {
                          title_ = input.readStringRequireUtf8();
                          bitField0_ |= 0x00000002;
                          break;
                        } // case 18
                      default:
                        {
                          if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                            done = true; // was an endgroup tag
                          }
                          break;
                        } // default:
                    } // switch (tag)
                  } // while (!done)
                } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                  throw e.unwrapIOException();
                } finally {
                  onChanged();
                } // finally
                return this;
              }

              private int bitField0_;

              private java.lang.Object uri_ = "";
              /**
               *
               *
               * <pre>
               * Uri of the document.
               * </pre>
               *
               * <code>string uri = 1;</code>
               *
               * @return The uri.
               */
              public java.lang.String getUri() {
                java.lang.Object ref = uri_;
                if (!(ref instanceof java.lang.String)) {
                  com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
                  java.lang.String s = bs.toStringUtf8();
                  uri_ = s;
                  return s;
                } else {
                  return (java.lang.String) ref;
                }
              }
              /**
               *
               *
               * <pre>
               * Uri of the document.
               * </pre>
               *
               * <code>string uri = 1;</code>
               *
               * @return The bytes for uri.
               */
              public com.google.protobuf.ByteString getUriBytes() {
                java.lang.Object ref = uri_;
                if (ref instanceof String) {
                  com.google.protobuf.ByteString b =
                      com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
                  uri_ = b;
                  return b;
                } else {
                  return (com.google.protobuf.ByteString) ref;
                }
              }
              /**
               *
               *
               * <pre>
               * Uri of the document.
               * </pre>
               *
               * <code>string uri = 1;</code>
               *
               * @param value The uri to set.
               * @return This builder for chaining.
               */
              public Builder setUri(java.lang.String value) {
                if (value == null) {
                  throw new NullPointerException();
                }
                uri_ = value;
                bitField0_ |= 0x00000001;
                onChanged();
                return this;
              }
              /**
               *
               *
               * <pre>
               * Uri of the document.
               * </pre>
               *
               * <code>string uri = 1;</code>
               *
               * @return This builder for chaining.
               */
              public Builder clearUri() {
                uri_ = getDefaultInstance().getUri();
                bitField0_ = (bitField0_ & ~0x00000001);
                onChanged();
                return this;
              }
              /**
               *
               *
               * <pre>
               * Uri of the document.
               * </pre>
               *
               * <code>string uri = 1;</code>
               *
               * @param value The bytes for uri to set.
               * @return This builder for chaining.
               */
              public Builder setUriBytes(com.google.protobuf.ByteString value) {
                if (value == null) {
                  throw new NullPointerException();
                }
                checkByteStringIsUtf8(value);
                uri_ = value;
                bitField0_ |= 0x00000001;
                onChanged();
                return this;
              }

              private java.lang.Object title_ = "";
              /**
               *
               *
               * <pre>
               * Title of the document.
               * </pre>
               *
               * <code>string title = 2;</code>
               *
               * @return The title.
               */
              public java.lang.String getTitle() {
                java.lang.Object ref = title_;
                if (!(ref instanceof java.lang.String)) {
                  com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
                  java.lang.String s = bs.toStringUtf8();
                  title_ = s;
                  return s;
                } else {
                  return (java.lang.String) ref;
                }
              }
              /**
               *
               *
               * <pre>
               * Title of the document.
               * </pre>
               *
               * <code>string title = 2;</code>
               *
               * @return The bytes for title.
               */
              public com.google.protobuf.ByteString getTitleBytes() {
                java.lang.Object ref = title_;
                if (ref instanceof String) {
                  com.google.protobuf.ByteString b =
                      com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
                  title_ = b;
                  return b;
                } else {
                  return (com.google.protobuf.ByteString) ref;
                }
              }
              /**
               *
               *
               * <pre>
               * Title of the document.
               * </pre>
               *
               * <code>string title = 2;</code>
               *
               * @param value The title to set.
               * @return This builder for chaining.
               */
              public Builder setTitle(java.lang.String value) {
                if (value == null) {
                  throw new NullPointerException();
                }
                title_ = value;
                bitField0_ |= 0x00000002;
                onChanged();
                return this;
              }
              /**
               *
               *
               * <pre>
               * Title of the document.
               * </pre>
               *
               * <code>string title = 2;</code>
               *
               * @return This builder for chaining.
               */
              public Builder clearTitle() {
                title_ = getDefaultInstance().getTitle();
                bitField0_ = (bitField0_ & ~0x00000002);
                onChanged();
                return this;
              }
              /**
               *
               *
               * <pre>
               * Title of the document.
               * </pre>
               *
               * <code>string title = 2;</code>
               *
               * @param value The bytes for title to set.
               * @return This builder for chaining.
               */
              public Builder setTitleBytes(com.google.protobuf.ByteString value) {
                if (value == null) {
                  throw new NullPointerException();
                }
                checkByteStringIsUtf8(value);
                title_ = value;
                bitField0_ |= 0x00000002;
                onChanged();
                return this;
              }

              @java.lang.Override
              public final Builder setUnknownFields(
                  final com.google.protobuf.UnknownFieldSet unknownFields) {
                return super.setUnknownFields(unknownFields);
              }

              @java.lang.Override
              public final Builder mergeUnknownFields(
                  final com.google.protobuf.UnknownFieldSet unknownFields) {
                return super.mergeUnknownFields(unknownFields);
              }

              // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.ChunkInfo.DocumentMetadata)
            }

            // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.ChunkInfo.DocumentMetadata)
            private static final com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest
                    .SearchSpec.SearchResultList.SearchResult.ChunkInfo.DocumentMetadata
                DEFAULT_INSTANCE;

            static {
              DEFAULT_INSTANCE =
                  new com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                      .SearchResultList.SearchResult.ChunkInfo.DocumentMetadata();
            }

            public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                    .SearchResultList.SearchResult.ChunkInfo.DocumentMetadata
                getDefaultInstance() {
              return DEFAULT_INSTANCE;
            }

            private static final com.google.protobuf.Parser<DocumentMetadata> PARSER =
                new com.google.protobuf.AbstractParser<DocumentMetadata>() {
                  @java.lang.Override
                  public DocumentMetadata parsePartialFrom(
                      com.google.protobuf.CodedInputStream input,
                      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                      throws com.google.protobuf.InvalidProtocolBufferException {
                    Builder builder = newBuilder();
                    try {
                      builder.mergeFrom(input, extensionRegistry);
                    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                      throw e.setUnfinishedMessage(builder.buildPartial());
                    } catch (com.google.protobuf.UninitializedMessageException e) {
                      throw e.asInvalidProtocolBufferException()
                          .setUnfinishedMessage(builder.buildPartial());
                    } catch (java.io.IOException e) {
                      throw new com.google.protobuf.InvalidProtocolBufferException(e)
                          .setUnfinishedMessage(builder.buildPartial());
                    }
                    return builder.buildPartial();
                  }
                };

            public static com.google.protobuf.Parser<DocumentMetadata> parser() {
              return PARSER;
            }

            @java.lang.Override
            public com.google.protobuf.Parser<DocumentMetadata> getParserForType() {
              return PARSER;
            }

            @java.lang.Override
            public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                    .SearchResultList.SearchResult.ChunkInfo.DocumentMetadata
                getDefaultInstanceForType() {
              return DEFAULT_INSTANCE;
            }
          }

          private int bitField0_;
          public static final int CHUNK_FIELD_NUMBER = 1;

          @SuppressWarnings("serial")
          private volatile java.lang.Object chunk_ = "";
          /**
           *
           *
           * <pre>
           * Chunk resource name.
           * </pre>
           *
           * <code>string chunk = 1 [(.google.api.resource_reference) = { ... }</code>
           *
           * @return The chunk.
           */
          @java.lang.Override
          public java.lang.String getChunk() {
            java.lang.Object ref = chunk_;
            if (ref instanceof java.lang.String) {
              return (java.lang.String) ref;
            } else {
              com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
              java.lang.String s = bs.toStringUtf8();
              chunk_ = s;
              return s;
            }
          }
          /**
           *
           *
           * <pre>
           * Chunk resource name.
           * </pre>
           *
           * <code>string chunk = 1 [(.google.api.resource_reference) = { ... }</code>
           *
           * @return The bytes for chunk.
           */
          @java.lang.Override
          public com.google.protobuf.ByteString getChunkBytes() {
            java.lang.Object ref = chunk_;
            if (ref instanceof java.lang.String) {
              com.google.protobuf.ByteString b =
                  com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
              chunk_ = b;
              return b;
            } else {
              return (com.google.protobuf.ByteString) ref;
            }
          }

          public static final int CONTENT_FIELD_NUMBER = 2;

          @SuppressWarnings("serial")
          private volatile java.lang.Object content_ = "";
          /**
           *
           *
           * <pre>
           * Chunk textual content.
           * </pre>
           *
           * <code>string content = 2;</code>
           *
           * @return The content.
           */
          @java.lang.Override
          public java.lang.String getContent() {
            java.lang.Object ref = content_;
            if (ref instanceof java.lang.String) {
              return (java.lang.String) ref;
            } else {
              com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
              java.lang.String s = bs.toStringUtf8();
              content_ = s;
              return s;
            }
          }
          /**
           *
           *
           * <pre>
           * Chunk textual content.
           * </pre>
           *
           * <code>string content = 2;</code>
           *
           * @return The bytes for content.
           */
          @java.lang.Override
          public com.google.protobuf.ByteString getContentBytes() {
            java.lang.Object ref = content_;
            if (ref instanceof java.lang.String) {
              com.google.protobuf.ByteString b =
                  com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
              content_ = b;
              return b;
            } else {
              return (com.google.protobuf.ByteString) ref;
            }
          }

          public static final int DOCUMENT_METADATA_FIELD_NUMBER = 4;
          private com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                  .SearchResultList.SearchResult.ChunkInfo.DocumentMetadata
              documentMetadata_;
          /**
           *
           *
           * <pre>
           * Metadata of the document from the current chunk.
           * </pre>
           *
           * <code>
           * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.ChunkInfo.DocumentMetadata document_metadata = 4;
           * </code>
           *
           * @return Whether the documentMetadata field is set.
           */
          @java.lang.Override
          public boolean hasDocumentMetadata() {
            return ((bitField0_ & 0x00000001) != 0);
          }
          /**
           *
           *
           * <pre>
           * Metadata of the document from the current chunk.
           * </pre>
           *
           * <code>
           * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.ChunkInfo.DocumentMetadata document_metadata = 4;
           * </code>
           *
           * @return The documentMetadata.
           */
          @java.lang.Override
          public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                  .SearchResultList.SearchResult.ChunkInfo.DocumentMetadata
              getDocumentMetadata() {
            return documentMetadata_ == null
                ? com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                    .SearchResultList.SearchResult.ChunkInfo.DocumentMetadata.getDefaultInstance()
                : documentMetadata_;
          }
          /**
           *
           *
           * <pre>
           * Metadata of the document from the current chunk.
           * </pre>
           *
           * <code>
           * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.ChunkInfo.DocumentMetadata document_metadata = 4;
           * </code>
           */
          @java.lang.Override
          public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                  .SearchResultList.SearchResult.ChunkInfo.DocumentMetadataOrBuilder
              getDocumentMetadataOrBuilder() {
            return documentMetadata_ == null
                ? com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                    .SearchResultList.SearchResult.ChunkInfo.DocumentMetadata.getDefaultInstance()
                : documentMetadata_;
          }

          private byte memoizedIsInitialized = -1;

          @java.lang.Override
          public final boolean isInitialized() {
            byte isInitialized = memoizedIsInitialized;
            if (isInitialized == 1) return true;
            if (isInitialized == 0) return false;

            memoizedIsInitialized = 1;
            return true;
          }

          @java.lang.Override
          public void writeTo(com.google.protobuf.CodedOutputStream output)
              throws java.io.IOException {
            if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(chunk_)) {
              com.google.protobuf.GeneratedMessageV3.writeString(output, 1, chunk_);
            }
            if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(content_)) {
              com.google.protobuf.GeneratedMessageV3.writeString(output, 2, content_);
            }
            if (((bitField0_ & 0x00000001) != 0)) {
              output.writeMessage(4, getDocumentMetadata());
            }
            getUnknownFields().writeTo(output);
          }

          @java.lang.Override
          public int getSerializedSize() {
            int size = memoizedSize;
            if (size != -1) return size;

            size = 0;
            if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(chunk_)) {
              size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, chunk_);
            }
            if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(content_)) {
              size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, content_);
            }
            if (((bitField0_ & 0x00000001) != 0)) {
              size +=
                  com.google.protobuf.CodedOutputStream.computeMessageSize(
                      4, getDocumentMetadata());
            }
            size += getUnknownFields().getSerializedSize();
            memoizedSize = size;
            return size;
          }

          @java.lang.Override
          public boolean equals(final java.lang.Object obj) {
            if (obj == this) {
              return true;
            }
            if (!(obj
                instanceof
                com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                    .SearchResultList.SearchResult.ChunkInfo)) {
              return super.equals(obj);
            }
            com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList
                    .SearchResult.ChunkInfo
                other =
                    (com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                            .SearchResultList.SearchResult.ChunkInfo)
                        obj;

            if (!getChunk().equals(other.getChunk())) return false;
            if (!getContent().equals(other.getContent())) return false;
            if (hasDocumentMetadata() != other.hasDocumentMetadata()) return false;
            if (hasDocumentMetadata()) {
              if (!getDocumentMetadata().equals(other.getDocumentMetadata())) return false;
            }
            if (!getUnknownFields().equals(other.getUnknownFields())) return false;
            return true;
          }

          @java.lang.Override
          public int hashCode() {
            if (memoizedHashCode != 0) {
              return memoizedHashCode;
            }
            int hash = 41;
            hash = (19 * hash) + getDescriptor().hashCode();
            hash = (37 * hash) + CHUNK_FIELD_NUMBER;
            hash = (53 * hash) + getChunk().hashCode();
            hash = (37 * hash) + CONTENT_FIELD_NUMBER;
            hash = (53 * hash) + getContent().hashCode();
            if (hasDocumentMetadata()) {
              hash = (37 * hash) + DOCUMENT_METADATA_FIELD_NUMBER;
              hash = (53 * hash) + getDocumentMetadata().hashCode();
            }
            hash = (29 * hash) + getUnknownFields().hashCode();
            memoizedHashCode = hash;
            return hash;
          }

          public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                  .SearchResultList.SearchResult.ChunkInfo
              parseFrom(java.nio.ByteBuffer data)
                  throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data);
          }

          public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                  .SearchResultList.SearchResult.ChunkInfo
              parseFrom(
                  java.nio.ByteBuffer data,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data, extensionRegistry);
          }

          public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                  .SearchResultList.SearchResult.ChunkInfo
              parseFrom(com.google.protobuf.ByteString data)
                  throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data);
          }

          public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                  .SearchResultList.SearchResult.ChunkInfo
              parseFrom(
                  com.google.protobuf.ByteString data,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data, extensionRegistry);
          }

          public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                  .SearchResultList.SearchResult.ChunkInfo
              parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data);
          }

          public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                  .SearchResultList.SearchResult.ChunkInfo
              parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data, extensionRegistry);
          }

          public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                  .SearchResultList.SearchResult.ChunkInfo
              parseFrom(java.io.InputStream input) throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
          }

          public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                  .SearchResultList.SearchResult.ChunkInfo
              parseFrom(
                  java.io.InputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
                PARSER, input, extensionRegistry);
          }

          public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                  .SearchResultList.SearchResult.ChunkInfo
              parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
                PARSER, input);
          }

          public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                  .SearchResultList.SearchResult.ChunkInfo
              parseDelimitedFrom(
                  java.io.InputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
                PARSER, input, extensionRegistry);
          }

          public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                  .SearchResultList.SearchResult.ChunkInfo
              parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
          }

          public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                  .SearchResultList.SearchResult.ChunkInfo
              parseFrom(
                  com.google.protobuf.CodedInputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
                PARSER, input, extensionRegistry);
          }

          @java.lang.Override
          public Builder newBuilderForType() {
            return newBuilder();
          }

          public static Builder newBuilder() {
            return DEFAULT_INSTANCE.toBuilder();
          }

          public static Builder newBuilder(
              com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList
                      .SearchResult.ChunkInfo
                  prototype) {
            return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
          }

          @java.lang.Override
          public Builder toBuilder() {
            return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
          }

          @java.lang.Override
          protected Builder newBuilderForType(
              com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            Builder builder = new Builder(parent);
            return builder;
          }
          /**
           *
           *
           * <pre>
           * Chunk information.
           * </pre>
           *
           * Protobuf type {@code
           * google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.ChunkInfo}
           */
          public static final class Builder
              extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
              implements
              // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.ChunkInfo)
              com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList
                  .SearchResult.ChunkInfoOrBuilder {
            public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
              return com.google.cloud.discoveryengine.v1beta.ConversationalSearchServiceProto
                  .internal_static_google_cloud_discoveryengine_v1beta_AnswerQueryRequest_SearchSpec_SearchResultList_SearchResult_ChunkInfo_descriptor;
            }

            @java.lang.Override
            protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
                internalGetFieldAccessorTable() {
              return com.google.cloud.discoveryengine.v1beta.ConversationalSearchServiceProto
                  .internal_static_google_cloud_discoveryengine_v1beta_AnswerQueryRequest_SearchSpec_SearchResultList_SearchResult_ChunkInfo_fieldAccessorTable
                  .ensureFieldAccessorsInitialized(
                      com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                          .SearchResultList.SearchResult.ChunkInfo.class,
                      com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                          .SearchResultList.SearchResult.ChunkInfo.Builder.class);
            }

            // Construct using
            // com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.ChunkInfo.newBuilder()
            private Builder() {
              maybeForceBuilderInitialization();
            }

            private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
              super(parent);
              maybeForceBuilderInitialization();
            }

            private void maybeForceBuilderInitialization() {
              if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
                getDocumentMetadataFieldBuilder();
              }
            }

            @java.lang.Override
            public Builder clear() {
              super.clear();
              bitField0_ = 0;
              chunk_ = "";
              content_ = "";
              documentMetadata_ = null;
              if (documentMetadataBuilder_ != null) {
                documentMetadataBuilder_.dispose();
                documentMetadataBuilder_ = null;
              }
              return this;
            }

            @java.lang.Override
            public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
              return com.google.cloud.discoveryengine.v1beta.ConversationalSearchServiceProto
                  .internal_static_google_cloud_discoveryengine_v1beta_AnswerQueryRequest_SearchSpec_SearchResultList_SearchResult_ChunkInfo_descriptor;
            }

            @java.lang.Override
            public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                    .SearchResultList.SearchResult.ChunkInfo
                getDefaultInstanceForType() {
              return com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                  .SearchResultList.SearchResult.ChunkInfo.getDefaultInstance();
            }

            @java.lang.Override
            public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                    .SearchResultList.SearchResult.ChunkInfo
                build() {
              com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList
                      .SearchResult.ChunkInfo
                  result = buildPartial();
              if (!result.isInitialized()) {
                throw newUninitializedMessageException(result);
              }
              return result;
            }

            @java.lang.Override
            public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                    .SearchResultList.SearchResult.ChunkInfo
                buildPartial() {
              com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList
                      .SearchResult.ChunkInfo
                  result =
                      new com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                          .SearchResultList.SearchResult.ChunkInfo(this);
              if (bitField0_ != 0) {
                buildPartial0(result);
              }
              onBuilt();
              return result;
            }

            private void buildPartial0(
                com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                        .SearchResultList.SearchResult.ChunkInfo
                    result) {
              int from_bitField0_ = bitField0_;
              if (((from_bitField0_ & 0x00000001) != 0)) {
                result.chunk_ = chunk_;
              }
              if (((from_bitField0_ & 0x00000002) != 0)) {
                result.content_ = content_;
              }
              int to_bitField0_ = 0;
              if (((from_bitField0_ & 0x00000004) != 0)) {
                result.documentMetadata_ =
                    documentMetadataBuilder_ == null
                        ? documentMetadata_
                        : documentMetadataBuilder_.build();
                to_bitField0_ |= 0x00000001;
              }
              result.bitField0_ |= to_bitField0_;
            }

            @java.lang.Override
            public Builder clone() {
              return super.clone();
            }

            @java.lang.Override
            public Builder setField(
                com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
              return super.setField(field, value);
            }

            @java.lang.Override
            public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
              return super.clearField(field);
            }

            @java.lang.Override
            public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
              return super.clearOneof(oneof);
            }

            @java.lang.Override
            public Builder setRepeatedField(
                com.google.protobuf.Descriptors.FieldDescriptor field,
                int index,
                java.lang.Object value) {
              return super.setRepeatedField(field, index, value);
            }

            @java.lang.Override
            public Builder addRepeatedField(
                com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
              return super.addRepeatedField(field, value);
            }

            @java.lang.Override
            public Builder mergeFrom(com.google.protobuf.Message other) {
              if (other
                  instanceof
                  com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                      .SearchResultList.SearchResult.ChunkInfo) {
                return mergeFrom(
                    (com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                            .SearchResultList.SearchResult.ChunkInfo)
                        other);
              } else {
                super.mergeFrom(other);
                return this;
              }
            }

            public Builder mergeFrom(
                com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                        .SearchResultList.SearchResult.ChunkInfo
                    other) {
              if (other
                  == com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                      .SearchResultList.SearchResult.ChunkInfo.getDefaultInstance()) return this;
              if (!other.getChunk().isEmpty()) {
                chunk_ = other.chunk_;
                bitField0_ |= 0x00000001;
                onChanged();
              }
              if (!other.getContent().isEmpty()) {
                content_ = other.content_;
                bitField0_ |= 0x00000002;
                onChanged();
              }
              if (other.hasDocumentMetadata()) {
                mergeDocumentMetadata(other.getDocumentMetadata());
              }
              this.mergeUnknownFields(other.getUnknownFields());
              onChanged();
              return this;
            }

            @java.lang.Override
            public final boolean isInitialized() {
              return true;
            }

            @java.lang.Override
            public Builder mergeFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
              if (extensionRegistry == null) {
                throw new java.lang.NullPointerException();
              }
              try {
                boolean done = false;
                while (!done) {
                  int tag = input.readTag();
                  switch (tag) {
                    case 0:
                      done = true;
                      break;
                    case 10:
                      {
                        chunk_ = input.readStringRequireUtf8();
                        bitField0_ |= 0x00000001;
                        break;
                      } // case 10
                    case 18:
                      {
                        content_ = input.readStringRequireUtf8();
                        bitField0_ |= 0x00000002;
                        break;
                      } // case 18
                    case 34:
                      {
                        input.readMessage(
                            getDocumentMetadataFieldBuilder().getBuilder(), extensionRegistry);
                        bitField0_ |= 0x00000004;
                        break;
                      } // case 34
                    default:
                      {
                        if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                          done = true; // was an endgroup tag
                        }
                        break;
                      } // default:
                  } // switch (tag)
                } // while (!done)
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
              } finally {
                onChanged();
              } // finally
              return this;
            }

            private int bitField0_;

            private java.lang.Object chunk_ = "";
            /**
             *
             *
             * <pre>
             * Chunk resource name.
             * </pre>
             *
             * <code>string chunk = 1 [(.google.api.resource_reference) = { ... }</code>
             *
             * @return The chunk.
             */
            public java.lang.String getChunk() {
              java.lang.Object ref = chunk_;
              if (!(ref instanceof java.lang.String)) {
                com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
                java.lang.String s = bs.toStringUtf8();
                chunk_ = s;
                return s;
              } else {
                return (java.lang.String) ref;
              }
            }
            /**
             *
             *
             * <pre>
             * Chunk resource name.
             * </pre>
             *
             * <code>string chunk = 1 [(.google.api.resource_reference) = { ... }</code>
             *
             * @return The bytes for chunk.
             */
            public com.google.protobuf.ByteString getChunkBytes() {
              java.lang.Object ref = chunk_;
              if (ref instanceof String) {
                com.google.protobuf.ByteString b =
                    com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
                chunk_ = b;
                return b;
              } else {
                return (com.google.protobuf.ByteString) ref;
              }
            }
            /**
             *
             *
             * <pre>
             * Chunk resource name.
             * </pre>
             *
             * <code>string chunk = 1 [(.google.api.resource_reference) = { ... }</code>
             *
             * @param value The chunk to set.
             * @return This builder for chaining.
             */
            public Builder setChunk(java.lang.String value) {
              if (value == null) {
                throw new NullPointerException();
              }
              chunk_ = value;
              bitField0_ |= 0x00000001;
              onChanged();
              return this;
            }
            /**
             *
             *
             * <pre>
             * Chunk resource name.
             * </pre>
             *
             * <code>string chunk = 1 [(.google.api.resource_reference) = { ... }</code>
             *
             * @return This builder for chaining.
             */
            public Builder clearChunk() {
              chunk_ = getDefaultInstance().getChunk();
              bitField0_ = (bitField0_ & ~0x00000001);
              onChanged();
              return this;
            }
            /**
             *
             *
             * <pre>
             * Chunk resource name.
             * </pre>
             *
             * <code>string chunk = 1 [(.google.api.resource_reference) = { ... }</code>
             *
             * @param value The bytes for chunk to set.
             * @return This builder for chaining.
             */
            public Builder setChunkBytes(com.google.protobuf.ByteString value) {
              if (value == null) {
                throw new NullPointerException();
              }
              checkByteStringIsUtf8(value);
              chunk_ = value;
              bitField0_ |= 0x00000001;
              onChanged();
              return this;
            }

            private java.lang.Object content_ = "";
            /**
             *
             *
             * <pre>
             * Chunk textual content.
             * </pre>
             *
             * <code>string content = 2;</code>
             *
             * @return The content.
             */
            public java.lang.String getContent() {
              java.lang.Object ref = content_;
              if (!(ref instanceof java.lang.String)) {
                com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
                java.lang.String s = bs.toStringUtf8();
                content_ = s;
                return s;
              } else {
                return (java.lang.String) ref;
              }
            }
            /**
             *
             *
             * <pre>
             * Chunk textual content.
             * </pre>
             *
             * <code>string content = 2;</code>
             *
             * @return The bytes for content.
             */
            public com.google.protobuf.ByteString getContentBytes() {
              java.lang.Object ref = content_;
              if (ref instanceof String) {
                com.google.protobuf.ByteString b =
                    com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
                content_ = b;
                return b;
              } else {
                return (com.google.protobuf.ByteString) ref;
              }
            }
            /**
             *
             *
             * <pre>
             * Chunk textual content.
             * </pre>
             *
             * <code>string content = 2;</code>
             *
             * @param value The content to set.
             * @return This builder for chaining.
             */
            public Builder setContent(java.lang.String value) {
              if (value == null) {
                throw new NullPointerException();
              }
              content_ = value;
              bitField0_ |= 0x00000002;
              onChanged();
              return this;
            }
            /**
             *
             *
             * <pre>
             * Chunk textual content.
             * </pre>
             *
             * <code>string content = 2;</code>
             *
             * @return This builder for chaining.
             */
            public Builder clearContent() {
              content_ = getDefaultInstance().getContent();
              bitField0_ = (bitField0_ & ~0x00000002);
              onChanged();
              return this;
            }
            /**
             *
             *
             * <pre>
             * Chunk textual content.
             * </pre>
             *
             * <code>string content = 2;</code>
             *
             * @param value The bytes for content to set.
             * @return This builder for chaining.
             */
            public Builder setContentBytes(com.google.protobuf.ByteString value) {
              if (value == null) {
                throw new NullPointerException();
              }
              checkByteStringIsUtf8(value);
              content_ = value;
              bitField0_ |= 0x00000002;
              onChanged();
              return this;
            }

            private com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                    .SearchResultList.SearchResult.ChunkInfo.DocumentMetadata
                documentMetadata_;
            private com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                        .SearchResultList.SearchResult.ChunkInfo.DocumentMetadata,
                    com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                        .SearchResultList.SearchResult.ChunkInfo.DocumentMetadata.Builder,
                    com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                        .SearchResultList.SearchResult.ChunkInfo.DocumentMetadataOrBuilder>
                documentMetadataBuilder_;
            /**
             *
             *
             * <pre>
             * Metadata of the document from the current chunk.
             * </pre>
             *
             * <code>
             * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.ChunkInfo.DocumentMetadata document_metadata = 4;
             * </code>
             *
             * @return Whether the documentMetadata field is set.
             */
            public boolean hasDocumentMetadata() {
              return ((bitField0_ & 0x00000004) != 0);
            }
            /**
             *
             *
             * <pre>
             * Metadata of the document from the current chunk.
             * </pre>
             *
             * <code>
             * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.ChunkInfo.DocumentMetadata document_metadata = 4;
             * </code>
             *
             * @return The documentMetadata.
             */
            public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                    .SearchResultList.SearchResult.ChunkInfo.DocumentMetadata
                getDocumentMetadata() {
              if (documentMetadataBuilder_ == null) {
                return documentMetadata_ == null
                    ? com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                        .SearchResultList.SearchResult.ChunkInfo.DocumentMetadata
                        .getDefaultInstance()
                    : documentMetadata_;
              } else {
                return documentMetadataBuilder_.getMessage();
              }
            }
            /**
             *
             *
             * <pre>
             * Metadata of the document from the current chunk.
             * </pre>
             *
             * <code>
             * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.ChunkInfo.DocumentMetadata document_metadata = 4;
             * </code>
             */
            public Builder setDocumentMetadata(
                com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                        .SearchResultList.SearchResult.ChunkInfo.DocumentMetadata
                    value) {
              if (documentMetadataBuilder_ == null) {
                if (value == null) {
                  throw new NullPointerException();
                }
                documentMetadata_ = value;
              } else {
                documentMetadataBuilder_.setMessage(value);
              }
              bitField0_ |= 0x00000004;
              onChanged();
              return this;
            }
            /**
             *
             *
             * <pre>
             * Metadata of the document from the current chunk.
             * </pre>
             *
             * <code>
             * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.ChunkInfo.DocumentMetadata document_metadata = 4;
             * </code>
             */
            public Builder setDocumentMetadata(
                com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                        .SearchResultList.SearchResult.ChunkInfo.DocumentMetadata.Builder
                    builderForValue) {
              if (documentMetadataBuilder_ == null) {
                documentMetadata_ = builderForValue.build();
              } else {
                documentMetadataBuilder_.setMessage(builderForValue.build());
              }
              bitField0_ |= 0x00000004;
              onChanged();
              return this;
            }
            /**
             *
             *
             * <pre>
             * Metadata of the document from the current chunk.
             * </pre>
             *
             * <code>
             * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.ChunkInfo.DocumentMetadata document_metadata = 4;
             * </code>
             */
            public Builder mergeDocumentMetadata(
                com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                        .SearchResultList.SearchResult.ChunkInfo.DocumentMetadata
                    value) {
              if (documentMetadataBuilder_ == null) {
                if (((bitField0_ & 0x00000004) != 0)
                    && documentMetadata_ != null
                    && documentMetadata_
                        != com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                            .SearchResultList.SearchResult.ChunkInfo.DocumentMetadata
                            .getDefaultInstance()) {
                  getDocumentMetadataBuilder().mergeFrom(value);
                } else {
                  documentMetadata_ = value;
                }
              } else {
                documentMetadataBuilder_.mergeFrom(value);
              }
              if (documentMetadata_ != null) {
                bitField0_ |= 0x00000004;
                onChanged();
              }
              return this;
            }
            /**
             *
             *
             * <pre>
             * Metadata of the document from the current chunk.
             * </pre>
             *
             * <code>
             * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.ChunkInfo.DocumentMetadata document_metadata = 4;
             * </code>
             */
            public Builder clearDocumentMetadata() {
              bitField0_ = (bitField0_ & ~0x00000004);
              documentMetadata_ = null;
              if (documentMetadataBuilder_ != null) {
                documentMetadataBuilder_.dispose();
                documentMetadataBuilder_ = null;
              }
              onChanged();
              return this;
            }
            /**
             *
             *
             * <pre>
             * Metadata of the document from the current chunk.
             * </pre>
             *
             * <code>
             * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.ChunkInfo.DocumentMetadata document_metadata = 4;
             * </code>
             */
            public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                    .SearchResultList.SearchResult.ChunkInfo.DocumentMetadata.Builder
                getDocumentMetadataBuilder() {
              bitField0_ |= 0x00000004;
              onChanged();
              return getDocumentMetadataFieldBuilder().getBuilder();
            }
            /**
             *
             *
             * <pre>
             * Metadata of the document from the current chunk.
             * </pre>
             *
             * <code>
             * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.ChunkInfo.DocumentMetadata document_metadata = 4;
             * </code>
             */
            public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                    .SearchResultList.SearchResult.ChunkInfo.DocumentMetadataOrBuilder
                getDocumentMetadataOrBuilder() {
              if (documentMetadataBuilder_ != null) {
                return documentMetadataBuilder_.getMessageOrBuilder();
              } else {
                return documentMetadata_ == null
                    ? com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                        .SearchResultList.SearchResult.ChunkInfo.DocumentMetadata
                        .getDefaultInstance()
                    : documentMetadata_;
              }
            }
            /**
             *
             *
             * <pre>
             * Metadata of the document from the current chunk.
             * </pre>
             *
             * <code>
             * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.ChunkInfo.DocumentMetadata document_metadata = 4;
             * </code>
             */
            private com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                        .SearchResultList.SearchResult.ChunkInfo.DocumentMetadata,
                    com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                        .SearchResultList.SearchResult.ChunkInfo.DocumentMetadata.Builder,
                    com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                        .SearchResultList.SearchResult.ChunkInfo.DocumentMetadataOrBuilder>
                getDocumentMetadataFieldBuilder() {
              if (documentMetadataBuilder_ == null) {
                documentMetadataBuilder_ =
                    new com.google.protobuf.SingleFieldBuilderV3<
                        com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                            .SearchResultList.SearchResult.ChunkInfo.DocumentMetadata,
                        com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                            .SearchResultList.SearchResult.ChunkInfo.DocumentMetadata.Builder,
                        com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                            .SearchResultList.SearchResult.ChunkInfo.DocumentMetadataOrBuilder>(
                        getDocumentMetadata(), getParentForChildren(), isClean());
                documentMetadata_ = null;
              }
              return documentMetadataBuilder_;
            }

            @java.lang.Override
            public final Builder setUnknownFields(
                final com.google.protobuf.UnknownFieldSet unknownFields) {
              return super.setUnknownFields(unknownFields);
            }

            @java.lang.Override
            public final Builder mergeUnknownFields(
                final com.google.protobuf.UnknownFieldSet unknownFields) {
              return super.mergeUnknownFields(unknownFields);
            }

            // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.ChunkInfo)
          }

          // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.ChunkInfo)
          private static final com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                  .SearchResultList.SearchResult.ChunkInfo
              DEFAULT_INSTANCE;

          static {
            DEFAULT_INSTANCE =
                new com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                    .SearchResultList.SearchResult.ChunkInfo();
          }

          public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                  .SearchResultList.SearchResult.ChunkInfo
              getDefaultInstance() {
            return DEFAULT_INSTANCE;
          }

          private static final com.google.protobuf.Parser<ChunkInfo> PARSER =
              new com.google.protobuf.AbstractParser<ChunkInfo>() {
                @java.lang.Override
                public ChunkInfo parsePartialFrom(
                    com.google.protobuf.CodedInputStream input,
                    com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                    throws com.google.protobuf.InvalidProtocolBufferException {
                  Builder builder = newBuilder();
                  try {
                    builder.mergeFrom(input, extensionRegistry);
                  } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                    throw e.setUnfinishedMessage(builder.buildPartial());
                  } catch (com.google.protobuf.UninitializedMessageException e) {
                    throw e.asInvalidProtocolBufferException()
                        .setUnfinishedMessage(builder.buildPartial());
                  } catch (java.io.IOException e) {
                    throw new com.google.protobuf.InvalidProtocolBufferException(e)
                        .setUnfinishedMessage(builder.buildPartial());
                  }
                  return builder.buildPartial();
                }
              };

          public static com.google.protobuf.Parser<ChunkInfo> parser() {
            return PARSER;
          }

          @java.lang.Override
          public com.google.protobuf.Parser<ChunkInfo> getParserForType() {
            return PARSER;
          }

          @java.lang.Override
          public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                  .SearchResultList.SearchResult.ChunkInfo
              getDefaultInstanceForType() {
            return DEFAULT_INSTANCE;
          }
        }

        private int contentCase_ = 0;

        @SuppressWarnings("serial")
        private java.lang.Object content_;

        public enum ContentCase
            implements
                com.google.protobuf.Internal.EnumLite,
                com.google.protobuf.AbstractMessage.InternalOneOfEnum {
          UNSTRUCTURED_DOCUMENT_INFO(1),
          CHUNK_INFO(2),
          CONTENT_NOT_SET(0);
          private final int value;

          private ContentCase(int value) {
            this.value = value;
          }
          /**
           * @param value The number of the enum to look for.
           * @return The enum associated with the given number.
           * @deprecated Use {@link #forNumber(int)} instead.
           */
          @java.lang.Deprecated
          public static ContentCase valueOf(int value) {
            return forNumber(value);
          }

          public static ContentCase forNumber(int value) {
            switch (value) {
              case 1:
                return UNSTRUCTURED_DOCUMENT_INFO;
              case 2:
                return CHUNK_INFO;
              case 0:
                return CONTENT_NOT_SET;
              default:
                return null;
            }
          }

          public int getNumber() {
            return this.value;
          }
        };

        public ContentCase getContentCase() {
          return ContentCase.forNumber(contentCase_);
        }

        public static final int UNSTRUCTURED_DOCUMENT_INFO_FIELD_NUMBER = 1;
        /**
         *
         *
         * <pre>
         * Unstructured document information.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo unstructured_document_info = 1;
         * </code>
         *
         * @return Whether the unstructuredDocumentInfo field is set.
         */
        @java.lang.Override
        public boolean hasUnstructuredDocumentInfo() {
          return contentCase_ == 1;
        }
        /**
         *
         *
         * <pre>
         * Unstructured document information.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo unstructured_document_info = 1;
         * </code>
         *
         * @return The unstructuredDocumentInfo.
         */
        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                .SearchResultList.SearchResult.UnstructuredDocumentInfo
            getUnstructuredDocumentInfo() {
          if (contentCase_ == 1) {
            return (com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                    .SearchResultList.SearchResult.UnstructuredDocumentInfo)
                content_;
          }
          return com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
              .SearchResultList.SearchResult.UnstructuredDocumentInfo.getDefaultInstance();
        }
        /**
         *
         *
         * <pre>
         * Unstructured document information.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo unstructured_document_info = 1;
         * </code>
         */
        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                .SearchResultList.SearchResult.UnstructuredDocumentInfoOrBuilder
            getUnstructuredDocumentInfoOrBuilder() {
          if (contentCase_ == 1) {
            return (com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                    .SearchResultList.SearchResult.UnstructuredDocumentInfo)
                content_;
          }
          return com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
              .SearchResultList.SearchResult.UnstructuredDocumentInfo.getDefaultInstance();
        }

        public static final int CHUNK_INFO_FIELD_NUMBER = 2;
        /**
         *
         *
         * <pre>
         * Chunk information.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.ChunkInfo chunk_info = 2;
         * </code>
         *
         * @return Whether the chunkInfo field is set.
         */
        @java.lang.Override
        public boolean hasChunkInfo() {
          return contentCase_ == 2;
        }
        /**
         *
         *
         * <pre>
         * Chunk information.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.ChunkInfo chunk_info = 2;
         * </code>
         *
         * @return The chunkInfo.
         */
        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                .SearchResultList.SearchResult.ChunkInfo
            getChunkInfo() {
          if (contentCase_ == 2) {
            return (com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                    .SearchResultList.SearchResult.ChunkInfo)
                content_;
          }
          return com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
              .SearchResultList.SearchResult.ChunkInfo.getDefaultInstance();
        }
        /**
         *
         *
         * <pre>
         * Chunk information.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.ChunkInfo chunk_info = 2;
         * </code>
         */
        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                .SearchResultList.SearchResult.ChunkInfoOrBuilder
            getChunkInfoOrBuilder() {
          if (contentCase_ == 2) {
            return (com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                    .SearchResultList.SearchResult.ChunkInfo)
                content_;
          }
          return com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
              .SearchResultList.SearchResult.ChunkInfo.getDefaultInstance();
        }

        private byte memoizedIsInitialized = -1;

        @java.lang.Override
        public final boolean isInitialized() {
          byte isInitialized = memoizedIsInitialized;
          if (isInitialized == 1) return true;
          if (isInitialized == 0) return false;

          memoizedIsInitialized = 1;
          return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
            throws java.io.IOException {
          if (contentCase_ == 1) {
            output.writeMessage(
                1,
                (com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                        .SearchResultList.SearchResult.UnstructuredDocumentInfo)
                    content_);
          }
          if (contentCase_ == 2) {
            output.writeMessage(
                2,
                (com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                        .SearchResultList.SearchResult.ChunkInfo)
                    content_);
          }
          getUnknownFields().writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
          int size = memoizedSize;
          if (size != -1) return size;

          size = 0;
          if (contentCase_ == 1) {
            size +=
                com.google.protobuf.CodedOutputStream.computeMessageSize(
                    1,
                    (com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                            .SearchResultList.SearchResult.UnstructuredDocumentInfo)
                        content_);
          }
          if (contentCase_ == 2) {
            size +=
                com.google.protobuf.CodedOutputStream.computeMessageSize(
                    2,
                    (com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                            .SearchResultList.SearchResult.ChunkInfo)
                        content_);
          }
          size += getUnknownFields().getSerializedSize();
          memoizedSize = size;
          return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
          if (obj == this) {
            return true;
          }
          if (!(obj
              instanceof
              com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList
                  .SearchResult)) {
            return super.equals(obj);
          }
          com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList
                  .SearchResult
              other =
                  (com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                          .SearchResultList.SearchResult)
                      obj;

          if (!getContentCase().equals(other.getContentCase())) return false;
          switch (contentCase_) {
            case 1:
              if (!getUnstructuredDocumentInfo().equals(other.getUnstructuredDocumentInfo()))
                return false;
              break;
            case 2:
              if (!getChunkInfo().equals(other.getChunkInfo())) return false;
              break;
            case 0:
            default:
          }
          if (!getUnknownFields().equals(other.getUnknownFields())) return false;
          return true;
        }

        @java.lang.Override
        public int hashCode() {
          if (memoizedHashCode != 0) {
            return memoizedHashCode;
          }
          int hash = 41;
          hash = (19 * hash) + getDescriptor().hashCode();
          switch (contentCase_) {
            case 1:
              hash = (37 * hash) + UNSTRUCTURED_DOCUMENT_INFO_FIELD_NUMBER;
              hash = (53 * hash) + getUnstructuredDocumentInfo().hashCode();
              break;
            case 2:
              hash = (37 * hash) + CHUNK_INFO_FIELD_NUMBER;
              hash = (53 * hash) + getChunkInfo().hashCode();
              break;
            case 0:
            default:
          }
          hash = (29 * hash) + getUnknownFields().hashCode();
          memoizedHashCode = hash;
          return hash;
        }

        public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                .SearchResultList.SearchResult
            parseFrom(java.nio.ByteBuffer data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                .SearchResultList.SearchResult
            parseFrom(
                java.nio.ByteBuffer data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                .SearchResultList.SearchResult
            parseFrom(com.google.protobuf.ByteString data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                .SearchResultList.SearchResult
            parseFrom(
                com.google.protobuf.ByteString data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                .SearchResultList.SearchResult
            parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                .SearchResultList.SearchResult
            parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                .SearchResultList.SearchResult
            parseFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                .SearchResultList.SearchResult
            parseFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                .SearchResultList.SearchResult
            parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input);
        }

        public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                .SearchResultList.SearchResult
            parseDelimitedFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                .SearchResultList.SearchResult
            parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                .SearchResultList.SearchResult
            parseFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() {
          return newBuilder();
        }

        public static Builder newBuilder() {
          return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(
            com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList
                    .SearchResult
                prototype) {
          return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @java.lang.Override
        public Builder toBuilder() {
          return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          Builder builder = new Builder(parent);
          return builder;
        }
        /**
         *
         *
         * <pre>
         * Search result.
         * </pre>
         *
         * Protobuf type {@code
         * google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult}
         */
        public static final class Builder
            extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
            implements
            // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult)
            com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList
                .SearchResultOrBuilder {
          public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
            return com.google.cloud.discoveryengine.v1beta.ConversationalSearchServiceProto
                .internal_static_google_cloud_discoveryengine_v1beta_AnswerQueryRequest_SearchSpec_SearchResultList_SearchResult_descriptor;
          }

          @java.lang.Override
          protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
              internalGetFieldAccessorTable() {
            return com.google.cloud.discoveryengine.v1beta.ConversationalSearchServiceProto
                .internal_static_google_cloud_discoveryengine_v1beta_AnswerQueryRequest_SearchSpec_SearchResultList_SearchResult_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                        .SearchResultList.SearchResult.class,
                    com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                        .SearchResultList.SearchResult.Builder.class);
          }

          // Construct using
          // com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.newBuilder()
          private Builder() {}

          private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            super(parent);
          }

          @java.lang.Override
          public Builder clear() {
            super.clear();
            bitField0_ = 0;
            if (unstructuredDocumentInfoBuilder_ != null) {
              unstructuredDocumentInfoBuilder_.clear();
            }
            if (chunkInfoBuilder_ != null) {
              chunkInfoBuilder_.clear();
            }
            contentCase_ = 0;
            content_ = null;
            return this;
          }

          @java.lang.Override
          public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
            return com.google.cloud.discoveryengine.v1beta.ConversationalSearchServiceProto
                .internal_static_google_cloud_discoveryengine_v1beta_AnswerQueryRequest_SearchSpec_SearchResultList_SearchResult_descriptor;
          }

          @java.lang.Override
          public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                  .SearchResultList.SearchResult
              getDefaultInstanceForType() {
            return com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                .SearchResultList.SearchResult.getDefaultInstance();
          }

          @java.lang.Override
          public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                  .SearchResultList.SearchResult
              build() {
            com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList
                    .SearchResult
                result = buildPartial();
            if (!result.isInitialized()) {
              throw newUninitializedMessageException(result);
            }
            return result;
          }

          @java.lang.Override
          public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                  .SearchResultList.SearchResult
              buildPartial() {
            com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList
                    .SearchResult
                result =
                    new com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                        .SearchResultList.SearchResult(this);
            if (bitField0_ != 0) {
              buildPartial0(result);
            }
            buildPartialOneofs(result);
            onBuilt();
            return result;
          }

          private void buildPartial0(
              com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList
                      .SearchResult
                  result) {
            int from_bitField0_ = bitField0_;
          }

          private void buildPartialOneofs(
              com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList
                      .SearchResult
                  result) {
            result.contentCase_ = contentCase_;
            result.content_ = this.content_;
            if (contentCase_ == 1 && unstructuredDocumentInfoBuilder_ != null) {
              result.content_ = unstructuredDocumentInfoBuilder_.build();
            }
            if (contentCase_ == 2 && chunkInfoBuilder_ != null) {
              result.content_ = chunkInfoBuilder_.build();
            }
          }

          @java.lang.Override
          public Builder clone() {
            return super.clone();
          }

          @java.lang.Override
          public Builder setField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.setField(field, value);
          }

          @java.lang.Override
          public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
            return super.clearField(field);
          }

          @java.lang.Override
          public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
            return super.clearOneof(oneof);
          }

          @java.lang.Override
          public Builder setRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field,
              int index,
              java.lang.Object value) {
            return super.setRepeatedField(field, index, value);
          }

          @java.lang.Override
          public Builder addRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.addRepeatedField(field, value);
          }

          @java.lang.Override
          public Builder mergeFrom(com.google.protobuf.Message other) {
            if (other
                instanceof
                com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                    .SearchResultList.SearchResult) {
              return mergeFrom(
                  (com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                          .SearchResultList.SearchResult)
                      other);
            } else {
              super.mergeFrom(other);
              return this;
            }
          }

          public Builder mergeFrom(
              com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList
                      .SearchResult
                  other) {
            if (other
                == com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                    .SearchResultList.SearchResult.getDefaultInstance()) return this;
            switch (other.getContentCase()) {
              case UNSTRUCTURED_DOCUMENT_INFO:
                {
                  mergeUnstructuredDocumentInfo(other.getUnstructuredDocumentInfo());
                  break;
                }
              case CHUNK_INFO:
                {
                  mergeChunkInfo(other.getChunkInfo());
                  break;
                }
              case CONTENT_NOT_SET:
                {
                  break;
                }
            }
            this.mergeUnknownFields(other.getUnknownFields());
            onChanged();
            return this;
          }

          @java.lang.Override
          public final boolean isInitialized() {
            return true;
          }

          @java.lang.Override
          public Builder mergeFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
            if (extensionRegistry == null) {
              throw new java.lang.NullPointerException();
            }
            try {
              boolean done = false;
              while (!done) {
                int tag = input.readTag();
                switch (tag) {
                  case 0:
                    done = true;
                    break;
                  case 10:
                    {
                      input.readMessage(
                          getUnstructuredDocumentInfoFieldBuilder().getBuilder(),
                          extensionRegistry);
                      contentCase_ = 1;
                      break;
                    } // case 10
                  case 18:
                    {
                      input.readMessage(getChunkInfoFieldBuilder().getBuilder(), extensionRegistry);
                      contentCase_ = 2;
                      break;
                    } // case 18
                  default:
                    {
                      if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                        done = true; // was an endgroup tag
                      }
                      break;
                    } // default:
                } // switch (tag)
              } // while (!done)
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.unwrapIOException();
            } finally {
              onChanged();
            } // finally
            return this;
          }

          private int contentCase_ = 0;
          private java.lang.Object content_;

          public ContentCase getContentCase() {
            return ContentCase.forNumber(contentCase_);
          }

          public Builder clearContent() {
            contentCase_ = 0;
            content_ = null;
            onChanged();
            return this;
          }

          private int bitField0_;

          private com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                      .SearchResultList.SearchResult.UnstructuredDocumentInfo,
                  com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                      .SearchResultList.SearchResult.UnstructuredDocumentInfo.Builder,
                  com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                      .SearchResultList.SearchResult.UnstructuredDocumentInfoOrBuilder>
              unstructuredDocumentInfoBuilder_;
          /**
           *
           *
           * <pre>
           * Unstructured document information.
           * </pre>
           *
           * <code>
           * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo unstructured_document_info = 1;
           * </code>
           *
           * @return Whether the unstructuredDocumentInfo field is set.
           */
          @java.lang.Override
          public boolean hasUnstructuredDocumentInfo() {
            return contentCase_ == 1;
          }
          /**
           *
           *
           * <pre>
           * Unstructured document information.
           * </pre>
           *
           * <code>
           * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo unstructured_document_info = 1;
           * </code>
           *
           * @return The unstructuredDocumentInfo.
           */
          @java.lang.Override
          public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                  .SearchResultList.SearchResult.UnstructuredDocumentInfo
              getUnstructuredDocumentInfo() {
            if (unstructuredDocumentInfoBuilder_ == null) {
              if (contentCase_ == 1) {
                return (com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                        .SearchResultList.SearchResult.UnstructuredDocumentInfo)
                    content_;
              }
              return com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                  .SearchResultList.SearchResult.UnstructuredDocumentInfo.getDefaultInstance();
            } else {
              if (contentCase_ == 1) {
                return unstructuredDocumentInfoBuilder_.getMessage();
              }
              return com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                  .SearchResultList.SearchResult.UnstructuredDocumentInfo.getDefaultInstance();
            }
          }
          /**
           *
           *
           * <pre>
           * Unstructured document information.
           * </pre>
           *
           * <code>
           * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo unstructured_document_info = 1;
           * </code>
           */
          public Builder setUnstructuredDocumentInfo(
              com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList
                      .SearchResult.UnstructuredDocumentInfo
                  value) {
            if (unstructuredDocumentInfoBuilder_ == null) {
              if (value == null) {
                throw new NullPointerException();
              }
              content_ = value;
              onChanged();
            } else {
              unstructuredDocumentInfoBuilder_.setMessage(value);
            }
            contentCase_ = 1;
            return this;
          }
          /**
           *
           *
           * <pre>
           * Unstructured document information.
           * </pre>
           *
           * <code>
           * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo unstructured_document_info = 1;
           * </code>
           */
          public Builder setUnstructuredDocumentInfo(
              com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList
                      .SearchResult.UnstructuredDocumentInfo.Builder
                  builderForValue) {
            if (unstructuredDocumentInfoBuilder_ == null) {
              content_ = builderForValue.build();
              onChanged();
            } else {
              unstructuredDocumentInfoBuilder_.setMessage(builderForValue.build());
            }
            contentCase_ = 1;
            return this;
          }
          /**
           *
           *
           * <pre>
           * Unstructured document information.
           * </pre>
           *
           * <code>
           * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo unstructured_document_info = 1;
           * </code>
           */
          public Builder mergeUnstructuredDocumentInfo(
              com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList
                      .SearchResult.UnstructuredDocumentInfo
                  value) {
            if (unstructuredDocumentInfoBuilder_ == null) {
              if (contentCase_ == 1
                  && content_
                      != com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                          .SearchResultList.SearchResult.UnstructuredDocumentInfo
                          .getDefaultInstance()) {
                content_ =
                    com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                        .SearchResultList.SearchResult.UnstructuredDocumentInfo.newBuilder(
                            (com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                                    .SearchResultList.SearchResult.UnstructuredDocumentInfo)
                                content_)
                        .mergeFrom(value)
                        .buildPartial();
              } else {
                content_ = value;
              }
              onChanged();
            } else {
              if (contentCase_ == 1) {
                unstructuredDocumentInfoBuilder_.mergeFrom(value);
              } else {
                unstructuredDocumentInfoBuilder_.setMessage(value);
              }
            }
            contentCase_ = 1;
            return this;
          }
          /**
           *
           *
           * <pre>
           * Unstructured document information.
           * </pre>
           *
           * <code>
           * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo unstructured_document_info = 1;
           * </code>
           */
          public Builder clearUnstructuredDocumentInfo() {
            if (unstructuredDocumentInfoBuilder_ == null) {
              if (contentCase_ == 1) {
                contentCase_ = 0;
                content_ = null;
                onChanged();
              }
            } else {
              if (contentCase_ == 1) {
                contentCase_ = 0;
                content_ = null;
              }
              unstructuredDocumentInfoBuilder_.clear();
            }
            return this;
          }
          /**
           *
           *
           * <pre>
           * Unstructured document information.
           * </pre>
           *
           * <code>
           * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo unstructured_document_info = 1;
           * </code>
           */
          public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                  .SearchResultList.SearchResult.UnstructuredDocumentInfo.Builder
              getUnstructuredDocumentInfoBuilder() {
            return getUnstructuredDocumentInfoFieldBuilder().getBuilder();
          }
          /**
           *
           *
           * <pre>
           * Unstructured document information.
           * </pre>
           *
           * <code>
           * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo unstructured_document_info = 1;
           * </code>
           */
          @java.lang.Override
          public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                  .SearchResultList.SearchResult.UnstructuredDocumentInfoOrBuilder
              getUnstructuredDocumentInfoOrBuilder() {
            if ((contentCase_ == 1) && (unstructuredDocumentInfoBuilder_ != null)) {
              return unstructuredDocumentInfoBuilder_.getMessageOrBuilder();
            } else {
              if (contentCase_ == 1) {
                return (com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                        .SearchResultList.SearchResult.UnstructuredDocumentInfo)
                    content_;
              }
              return com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                  .SearchResultList.SearchResult.UnstructuredDocumentInfo.getDefaultInstance();
            }
          }
          /**
           *
           *
           * <pre>
           * Unstructured document information.
           * </pre>
           *
           * <code>
           * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.UnstructuredDocumentInfo unstructured_document_info = 1;
           * </code>
           */
          private com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                      .SearchResultList.SearchResult.UnstructuredDocumentInfo,
                  com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                      .SearchResultList.SearchResult.UnstructuredDocumentInfo.Builder,
                  com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                      .SearchResultList.SearchResult.UnstructuredDocumentInfoOrBuilder>
              getUnstructuredDocumentInfoFieldBuilder() {
            if (unstructuredDocumentInfoBuilder_ == null) {
              if (!(contentCase_ == 1)) {
                content_ =
                    com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                        .SearchResultList.SearchResult.UnstructuredDocumentInfo
                        .getDefaultInstance();
              }
              unstructuredDocumentInfoBuilder_ =
                  new com.google.protobuf.SingleFieldBuilderV3<
                      com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                          .SearchResultList.SearchResult.UnstructuredDocumentInfo,
                      com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                          .SearchResultList.SearchResult.UnstructuredDocumentInfo.Builder,
                      com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                          .SearchResultList.SearchResult.UnstructuredDocumentInfoOrBuilder>(
                      (com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                              .SearchResultList.SearchResult.UnstructuredDocumentInfo)
                          content_,
                      getParentForChildren(),
                      isClean());
              content_ = null;
            }
            contentCase_ = 1;
            onChanged();
            return unstructuredDocumentInfoBuilder_;
          }

          private com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                      .SearchResultList.SearchResult.ChunkInfo,
                  com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                      .SearchResultList.SearchResult.ChunkInfo.Builder,
                  com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                      .SearchResultList.SearchResult.ChunkInfoOrBuilder>
              chunkInfoBuilder_;
          /**
           *
           *
           * <pre>
           * Chunk information.
           * </pre>
           *
           * <code>
           * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.ChunkInfo chunk_info = 2;
           * </code>
           *
           * @return Whether the chunkInfo field is set.
           */
          @java.lang.Override
          public boolean hasChunkInfo() {
            return contentCase_ == 2;
          }
          /**
           *
           *
           * <pre>
           * Chunk information.
           * </pre>
           *
           * <code>
           * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.ChunkInfo chunk_info = 2;
           * </code>
           *
           * @return The chunkInfo.
           */
          @java.lang.Override
          public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                  .SearchResultList.SearchResult.ChunkInfo
              getChunkInfo() {
            if (chunkInfoBuilder_ == null) {
              if (contentCase_ == 2) {
                return (com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                        .SearchResultList.SearchResult.ChunkInfo)
                    content_;
              }
              return com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                  .SearchResultList.SearchResult.ChunkInfo.getDefaultInstance();
            } else {
              if (contentCase_ == 2) {
                return chunkInfoBuilder_.getMessage();
              }
              return com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                  .SearchResultList.SearchResult.ChunkInfo.getDefaultInstance();
            }
          }
          /**
           *
           *
           * <pre>
           * Chunk information.
           * </pre>
           *
           * <code>
           * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.ChunkInfo chunk_info = 2;
           * </code>
           */
          public Builder setChunkInfo(
              com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList
                      .SearchResult.ChunkInfo
                  value) {
            if (chunkInfoBuilder_ == null) {
              if (value == null) {
                throw new NullPointerException();
              }
              content_ = value;
              onChanged();
            } else {
              chunkInfoBuilder_.setMessage(value);
            }
            contentCase_ = 2;
            return this;
          }
          /**
           *
           *
           * <pre>
           * Chunk information.
           * </pre>
           *
           * <code>
           * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.ChunkInfo chunk_info = 2;
           * </code>
           */
          public Builder setChunkInfo(
              com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList
                      .SearchResult.ChunkInfo.Builder
                  builderForValue) {
            if (chunkInfoBuilder_ == null) {
              content_ = builderForValue.build();
              onChanged();
            } else {
              chunkInfoBuilder_.setMessage(builderForValue.build());
            }
            contentCase_ = 2;
            return this;
          }
          /**
           *
           *
           * <pre>
           * Chunk information.
           * </pre>
           *
           * <code>
           * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.ChunkInfo chunk_info = 2;
           * </code>
           */
          public Builder mergeChunkInfo(
              com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList
                      .SearchResult.ChunkInfo
                  value) {
            if (chunkInfoBuilder_ == null) {
              if (contentCase_ == 2
                  && content_
                      != com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                          .SearchResultList.SearchResult.ChunkInfo.getDefaultInstance()) {
                content_ =
                    com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                        .SearchResultList.SearchResult.ChunkInfo.newBuilder(
                            (com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                                    .SearchResultList.SearchResult.ChunkInfo)
                                content_)
                        .mergeFrom(value)
                        .buildPartial();
              } else {
                content_ = value;
              }
              onChanged();
            } else {
              if (contentCase_ == 2) {
                chunkInfoBuilder_.mergeFrom(value);
              } else {
                chunkInfoBuilder_.setMessage(value);
              }
            }
            contentCase_ = 2;
            return this;
          }
          /**
           *
           *
           * <pre>
           * Chunk information.
           * </pre>
           *
           * <code>
           * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.ChunkInfo chunk_info = 2;
           * </code>
           */
          public Builder clearChunkInfo() {
            if (chunkInfoBuilder_ == null) {
              if (contentCase_ == 2) {
                contentCase_ = 0;
                content_ = null;
                onChanged();
              }
            } else {
              if (contentCase_ == 2) {
                contentCase_ = 0;
                content_ = null;
              }
              chunkInfoBuilder_.clear();
            }
            return this;
          }
          /**
           *
           *
           * <pre>
           * Chunk information.
           * </pre>
           *
           * <code>
           * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.ChunkInfo chunk_info = 2;
           * </code>
           */
          public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                  .SearchResultList.SearchResult.ChunkInfo.Builder
              getChunkInfoBuilder() {
            return getChunkInfoFieldBuilder().getBuilder();
          }
          /**
           *
           *
           * <pre>
           * Chunk information.
           * </pre>
           *
           * <code>
           * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.ChunkInfo chunk_info = 2;
           * </code>
           */
          @java.lang.Override
          public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                  .SearchResultList.SearchResult.ChunkInfoOrBuilder
              getChunkInfoOrBuilder() {
            if ((contentCase_ == 2) && (chunkInfoBuilder_ != null)) {
              return chunkInfoBuilder_.getMessageOrBuilder();
            } else {
              if (contentCase_ == 2) {
                return (com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                        .SearchResultList.SearchResult.ChunkInfo)
                    content_;
              }
              return com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                  .SearchResultList.SearchResult.ChunkInfo.getDefaultInstance();
            }
          }
          /**
           *
           *
           * <pre>
           * Chunk information.
           * </pre>
           *
           * <code>
           * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult.ChunkInfo chunk_info = 2;
           * </code>
           */
          private com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                      .SearchResultList.SearchResult.ChunkInfo,
                  com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                      .SearchResultList.SearchResult.ChunkInfo.Builder,
                  com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                      .SearchResultList.SearchResult.ChunkInfoOrBuilder>
              getChunkInfoFieldBuilder() {
            if (chunkInfoBuilder_ == null) {
              if (!(contentCase_ == 2)) {
                content_ =
                    com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                        .SearchResultList.SearchResult.ChunkInfo.getDefaultInstance();
              }
              chunkInfoBuilder_ =
                  new com.google.protobuf.SingleFieldBuilderV3<
                      com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                          .SearchResultList.SearchResult.ChunkInfo,
                      com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                          .SearchResultList.SearchResult.ChunkInfo.Builder,
                      com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                          .SearchResultList.SearchResult.ChunkInfoOrBuilder>(
                      (com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                              .SearchResultList.SearchResult.ChunkInfo)
                          content_,
                      getParentForChildren(),
                      isClean());
              content_ = null;
            }
            contentCase_ = 2;
            onChanged();
            return chunkInfoBuilder_;
          }

          @java.lang.Override
          public final Builder setUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.setUnknownFields(unknownFields);
          }

          @java.lang.Override
          public final Builder mergeUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.mergeUnknownFields(unknownFields);
          }

          // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult)
        }

        // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult)
        private static final com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                .SearchResultList.SearchResult
            DEFAULT_INSTANCE;

        static {
          DEFAULT_INSTANCE =
              new com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                  .SearchResultList.SearchResult();
        }

        public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                .SearchResultList.SearchResult
            getDefaultInstance() {
          return DEFAULT_INSTANCE;
        }

        private static final com.google.protobuf.Parser<SearchResult> PARSER =
            new com.google.protobuf.AbstractParser<SearchResult>() {
              @java.lang.Override
              public SearchResult parsePartialFrom(
                  com.google.protobuf.CodedInputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
                Builder builder = newBuilder();
                try {
                  builder.mergeFrom(input, extensionRegistry);
                } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                  throw e.setUnfinishedMessage(builder.buildPartial());
                } catch (com.google.protobuf.UninitializedMessageException e) {
                  throw e.asInvalidProtocolBufferException()
                      .setUnfinishedMessage(builder.buildPartial());
                } catch (java.io.IOException e) {
                  throw new com.google.protobuf.InvalidProtocolBufferException(e)
                      .setUnfinishedMessage(builder.buildPartial());
                }
                return builder.buildPartial();
              }
            };

        public static com.google.protobuf.Parser<SearchResult> parser() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.protobuf.Parser<SearchResult> getParserForType() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                .SearchResultList.SearchResult
            getDefaultInstanceForType() {
          return DEFAULT_INSTANCE;
        }
      }

      public static final int SEARCH_RESULTS_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private java.util.List<
              com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList
                  .SearchResult>
          searchResults_;
      /**
       *
       *
       * <pre>
       * Search results.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult search_results = 1;
       * </code>
       */
      @java.lang.Override
      public java.util.List<
              com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList
                  .SearchResult>
          getSearchResultsList() {
        return searchResults_;
      }
      /**
       *
       *
       * <pre>
       * Search results.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult search_results = 1;
       * </code>
       */
      @java.lang.Override
      public java.util.List<
              ? extends
                  com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                      .SearchResultList.SearchResultOrBuilder>
          getSearchResultsOrBuilderList() {
        return searchResults_;
      }
      /**
       *
       *
       * <pre>
       * Search results.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult search_results = 1;
       * </code>
       */
      @java.lang.Override
      public int getSearchResultsCount() {
        return searchResults_.size();
      }
      /**
       *
       *
       * <pre>
       * Search results.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult search_results = 1;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList
              .SearchResult
          getSearchResults(int index) {
        return searchResults_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Search results.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult search_results = 1;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList
              .SearchResultOrBuilder
          getSearchResultsOrBuilder(int index) {
        return searchResults_.get(index);
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        for (int i = 0; i < searchResults_.size(); i++) {
          output.writeMessage(1, searchResults_.get(i));
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        for (int i = 0; i < searchResults_.size(); i++) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(1, searchResults_.get(i));
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                .SearchResultList)) {
          return super.equals(obj);
        }
        com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList
            other =
                (com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                        .SearchResultList)
                    obj;

        if (!getSearchResultsList().equals(other.getSearchResultsList())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (getSearchResultsCount() > 0) {
          hash = (37 * hash) + SEARCH_RESULTS_FIELD_NUMBER;
          hash = (53 * hash) + getSearchResultsList().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
              .SearchResultList
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
              .SearchResultList
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
              .SearchResultList
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
              .SearchResultList
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
              .SearchResultList
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
              .SearchResultList
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
              .SearchResultList
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
              .SearchResultList
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
              .SearchResultList
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
              .SearchResultList
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
              .SearchResultList
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
              .SearchResultList
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Search result list.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList)
          com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
              .SearchResultListOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.discoveryengine.v1beta.ConversationalSearchServiceProto
              .internal_static_google_cloud_discoveryengine_v1beta_AnswerQueryRequest_SearchSpec_SearchResultList_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.discoveryengine.v1beta.ConversationalSearchServiceProto
              .internal_static_google_cloud_discoveryengine_v1beta_AnswerQueryRequest_SearchSpec_SearchResultList_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                      .SearchResultList.class,
                  com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                      .SearchResultList.Builder.class);
        }

        // Construct using
        // com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          if (searchResultsBuilder_ == null) {
            searchResults_ = java.util.Collections.emptyList();
          } else {
            searchResults_ = null;
            searchResultsBuilder_.clear();
          }
          bitField0_ = (bitField0_ & ~0x00000001);
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.discoveryengine.v1beta.ConversationalSearchServiceProto
              .internal_static_google_cloud_discoveryengine_v1beta_AnswerQueryRequest_SearchSpec_SearchResultList_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                .SearchResultList
            getDefaultInstanceForType() {
          return com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
              .SearchResultList.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                .SearchResultList
            build() {
          com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList
              result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                .SearchResultList
            buildPartial() {
          com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList
              result =
                  new com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                      .SearchResultList(this);
          buildPartialRepeatedFields(result);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartialRepeatedFields(
            com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList
                result) {
          if (searchResultsBuilder_ == null) {
            if (((bitField0_ & 0x00000001) != 0)) {
              searchResults_ = java.util.Collections.unmodifiableList(searchResults_);
              bitField0_ = (bitField0_ & ~0x00000001);
            }
            result.searchResults_ = searchResults_;
          } else {
            result.searchResults_ = searchResultsBuilder_.build();
          }
        }

        private void buildPartial0(
            com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList
                result) {
          int from_bitField0_ = bitField0_;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                  .SearchResultList) {
            return mergeFrom(
                (com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                        .SearchResultList)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList
                other) {
          if (other
              == com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                  .SearchResultList.getDefaultInstance()) return this;
          if (searchResultsBuilder_ == null) {
            if (!other.searchResults_.isEmpty()) {
              if (searchResults_.isEmpty()) {
                searchResults_ = other.searchResults_;
                bitField0_ = (bitField0_ & ~0x00000001);
              } else {
                ensureSearchResultsIsMutable();
                searchResults_.addAll(other.searchResults_);
              }
              onChanged();
            }
          } else {
            if (!other.searchResults_.isEmpty()) {
              if (searchResultsBuilder_.isEmpty()) {
                searchResultsBuilder_.dispose();
                searchResultsBuilder_ = null;
                searchResults_ = other.searchResults_;
                bitField0_ = (bitField0_ & ~0x00000001);
                searchResultsBuilder_ =
                    com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                        ? getSearchResultsFieldBuilder()
                        : null;
              } else {
                searchResultsBuilder_.addAllMessages(other.searchResults_);
              }
            }
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                            .SearchResultList.SearchResult
                        m =
                            input.readMessage(
                                com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest
                                    .SearchSpec.SearchResultList.SearchResult.parser(),
                                extensionRegistry);
                    if (searchResultsBuilder_ == null) {
                      ensureSearchResultsIsMutable();
                      searchResults_.add(m);
                    } else {
                      searchResultsBuilder_.addMessage(m);
                    }
                    break;
                  } // case 10
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.util.List<
                com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                    .SearchResultList.SearchResult>
            searchResults_ = java.util.Collections.emptyList();

        private void ensureSearchResultsIsMutable() {
          if (!((bitField0_ & 0x00000001) != 0)) {
            searchResults_ =
                new java.util.ArrayList<
                    com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                        .SearchResultList.SearchResult>(searchResults_);
            bitField0_ |= 0x00000001;
          }
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                    .SearchResultList.SearchResult,
                com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                    .SearchResultList.SearchResult.Builder,
                com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                    .SearchResultList.SearchResultOrBuilder>
            searchResultsBuilder_;

        /**
         *
         *
         * <pre>
         * Search results.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult search_results = 1;
         * </code>
         */
        public java.util.List<
                com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                    .SearchResultList.SearchResult>
            getSearchResultsList() {
          if (searchResultsBuilder_ == null) {
            return java.util.Collections.unmodifiableList(searchResults_);
          } else {
            return searchResultsBuilder_.getMessageList();
          }
        }
        /**
         *
         *
         * <pre>
         * Search results.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult search_results = 1;
         * </code>
         */
        public int getSearchResultsCount() {
          if (searchResultsBuilder_ == null) {
            return searchResults_.size();
          } else {
            return searchResultsBuilder_.getCount();
          }
        }
        /**
         *
         *
         * <pre>
         * Search results.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult search_results = 1;
         * </code>
         */
        public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                .SearchResultList.SearchResult
            getSearchResults(int index) {
          if (searchResultsBuilder_ == null) {
            return searchResults_.get(index);
          } else {
            return searchResultsBuilder_.getMessage(index);
          }
        }
        /**
         *
         *
         * <pre>
         * Search results.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult search_results = 1;
         * </code>
         */
        public Builder setSearchResults(
            int index,
            com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList
                    .SearchResult
                value) {
          if (searchResultsBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureSearchResultsIsMutable();
            searchResults_.set(index, value);
            onChanged();
          } else {
            searchResultsBuilder_.setMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Search results.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult search_results = 1;
         * </code>
         */
        public Builder setSearchResults(
            int index,
            com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList
                    .SearchResult.Builder
                builderForValue) {
          if (searchResultsBuilder_ == null) {
            ensureSearchResultsIsMutable();
            searchResults_.set(index, builderForValue.build());
            onChanged();
          } else {
            searchResultsBuilder_.setMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Search results.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult search_results = 1;
         * </code>
         */
        public Builder addSearchResults(
            com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList
                    .SearchResult
                value) {
          if (searchResultsBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureSearchResultsIsMutable();
            searchResults_.add(value);
            onChanged();
          } else {
            searchResultsBuilder_.addMessage(value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Search results.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult search_results = 1;
         * </code>
         */
        public Builder addSearchResults(
            int index,
            com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList
                    .SearchResult
                value) {
          if (searchResultsBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureSearchResultsIsMutable();
            searchResults_.add(index, value);
            onChanged();
          } else {
            searchResultsBuilder_.addMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Search results.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult search_results = 1;
         * </code>
         */
        public Builder addSearchResults(
            com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList
                    .SearchResult.Builder
                builderForValue) {
          if (searchResultsBuilder_ == null) {
            ensureSearchResultsIsMutable();
            searchResults_.add(builderForValue.build());
            onChanged();
          } else {
            searchResultsBuilder_.addMessage(builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Search results.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult search_results = 1;
         * </code>
         */
        public Builder addSearchResults(
            int index,
            com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList
                    .SearchResult.Builder
                builderForValue) {
          if (searchResultsBuilder_ == null) {
            ensureSearchResultsIsMutable();
            searchResults_.add(index, builderForValue.build());
            onChanged();
          } else {
            searchResultsBuilder_.addMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Search results.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult search_results = 1;
         * </code>
         */
        public Builder addAllSearchResults(
            java.lang.Iterable<
                    ? extends
                        com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                            .SearchResultList.SearchResult>
                values) {
          if (searchResultsBuilder_ == null) {
            ensureSearchResultsIsMutable();
            com.google.protobuf.AbstractMessageLite.Builder.addAll(values, searchResults_);
            onChanged();
          } else {
            searchResultsBuilder_.addAllMessages(values);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Search results.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult search_results = 1;
         * </code>
         */
        public Builder clearSearchResults() {
          if (searchResultsBuilder_ == null) {
            searchResults_ = java.util.Collections.emptyList();
            bitField0_ = (bitField0_ & ~0x00000001);
            onChanged();
          } else {
            searchResultsBuilder_.clear();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Search results.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult search_results = 1;
         * </code>
         */
        public Builder removeSearchResults(int index) {
          if (searchResultsBuilder_ == null) {
            ensureSearchResultsIsMutable();
            searchResults_.remove(index);
            onChanged();
          } else {
            searchResultsBuilder_.remove(index);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Search results.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult search_results = 1;
         * </code>
         */
        public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                .SearchResultList.SearchResult.Builder
            getSearchResultsBuilder(int index) {
          return getSearchResultsFieldBuilder().getBuilder(index);
        }
        /**
         *
         *
         * <pre>
         * Search results.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult search_results = 1;
         * </code>
         */
        public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                .SearchResultList.SearchResultOrBuilder
            getSearchResultsOrBuilder(int index) {
          if (searchResultsBuilder_ == null) {
            return searchResults_.get(index);
          } else {
            return searchResultsBuilder_.getMessageOrBuilder(index);
          }
        }
        /**
         *
         *
         * <pre>
         * Search results.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult search_results = 1;
         * </code>
         */
        public java.util.List<
                ? extends
                    com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                        .SearchResultList.SearchResultOrBuilder>
            getSearchResultsOrBuilderList() {
          if (searchResultsBuilder_ != null) {
            return searchResultsBuilder_.getMessageOrBuilderList();
          } else {
            return java.util.Collections.unmodifiableList(searchResults_);
          }
        }
        /**
         *
         *
         * <pre>
         * Search results.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult search_results = 1;
         * </code>
         */
        public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                .SearchResultList.SearchResult.Builder
            addSearchResultsBuilder() {
          return getSearchResultsFieldBuilder()
              .addBuilder(
                  com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                      .SearchResultList.SearchResult.getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * Search results.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult search_results = 1;
         * </code>
         */
        public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                .SearchResultList.SearchResult.Builder
            addSearchResultsBuilder(int index) {
          return getSearchResultsFieldBuilder()
              .addBuilder(
                  index,
                  com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                      .SearchResultList.SearchResult.getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * Search results.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList.SearchResult search_results = 1;
         * </code>
         */
        public java.util.List<
                com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                    .SearchResultList.SearchResult.Builder>
            getSearchResultsBuilderList() {
          return getSearchResultsFieldBuilder().getBuilderList();
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                    .SearchResultList.SearchResult,
                com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                    .SearchResultList.SearchResult.Builder,
                com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                    .SearchResultList.SearchResultOrBuilder>
            getSearchResultsFieldBuilder() {
          if (searchResultsBuilder_ == null) {
            searchResultsBuilder_ =
                new com.google.protobuf.RepeatedFieldBuilderV3<
                    com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                        .SearchResultList.SearchResult,
                    com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                        .SearchResultList.SearchResult.Builder,
                    com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                        .SearchResultList.SearchResultOrBuilder>(
                    searchResults_,
                    ((bitField0_ & 0x00000001) != 0),
                    getParentForChildren(),
                    isClean());
            searchResults_ = null;
          }
          return searchResultsBuilder_;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList)
      private static final com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
              .SearchResultList
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                .SearchResultList();
      }

      public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
              .SearchResultList
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<SearchResultList> PARSER =
          new com.google.protobuf.AbstractParser<SearchResultList>() {
            @java.lang.Override
            public SearchResultList parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<SearchResultList> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<SearchResultList> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    private int inputCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object input_;

    public enum InputCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      SEARCH_PARAMS(1),
      SEARCH_RESULT_LIST(2),
      INPUT_NOT_SET(0);
      private final int value;

      private InputCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static InputCase valueOf(int value) {
        return forNumber(value);
      }

      public static InputCase forNumber(int value) {
        switch (value) {
          case 1:
            return SEARCH_PARAMS;
          case 2:
            return SEARCH_RESULT_LIST;
          case 0:
            return INPUT_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public InputCase getInputCase() {
      return InputCase.forNumber(inputCase_);
    }

    public static final int SEARCH_PARAMS_FIELD_NUMBER = 1;
    /**
     *
     *
     * <pre>
     * Search parameters.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchParams search_params = 1;
     * </code>
     *
     * @return Whether the searchParams field is set.
     */
    @java.lang.Override
    public boolean hasSearchParams() {
      return inputCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * Search parameters.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchParams search_params = 1;
     * </code>
     *
     * @return The searchParams.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchParams
        getSearchParams() {
      if (inputCase_ == 1) {
        return (com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchParams)
            input_;
      }
      return com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchParams
          .getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * Search parameters.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchParams search_params = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
            .SearchParamsOrBuilder
        getSearchParamsOrBuilder() {
      if (inputCase_ == 1) {
        return (com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchParams)
            input_;
      }
      return com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchParams
          .getDefaultInstance();
    }

    public static final int SEARCH_RESULT_LIST_FIELD_NUMBER = 2;
    /**
     *
     *
     * <pre>
     * Search result list.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList search_result_list = 2;
     * </code>
     *
     * @return Whether the searchResultList field is set.
     */
    @java.lang.Override
    public boolean hasSearchResultList() {
      return inputCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Search result list.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList search_result_list = 2;
     * </code>
     *
     * @return The searchResultList.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList
        getSearchResultList() {
      if (inputCase_ == 2) {
        return (com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                .SearchResultList)
            input_;
      }
      return com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList
          .getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * Search result list.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList search_result_list = 2;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
            .SearchResultListOrBuilder
        getSearchResultListOrBuilder() {
      if (inputCase_ == 2) {
        return (com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                .SearchResultList)
            input_;
      }
      return com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList
          .getDefaultInstance();
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (inputCase_ == 1) {
        output.writeMessage(
            1,
            (com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchParams)
                input_);
      }
      if (inputCase_ == 2) {
        output.writeMessage(
            2,
            (com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList)
                input_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (inputCase_ == 1) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                1,
                (com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchParams)
                    input_);
      }
      if (inputCase_ == 2) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                2,
                (com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                        .SearchResultList)
                    input_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec)) {
        return super.equals(obj);
      }
      com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec other =
          (com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec) obj;

      if (!getInputCase().equals(other.getInputCase())) return false;
      switch (inputCase_) {
        case 1:
          if (!getSearchParams().equals(other.getSearchParams())) return false;
          break;
        case 2:
          if (!getSearchResultList().equals(other.getSearchResultList())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      switch (inputCase_) {
        case 1:
          hash = (37 * hash) + SEARCH_PARAMS_FIELD_NUMBER;
          hash = (53 * hash) + getSearchParams().hashCode();
          break;
        case 2:
          hash = (37 * hash) + SEARCH_RESULT_LIST_FIELD_NUMBER;
          hash = (53 * hash) + getSearchResultList().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Search specification.
     * </pre>
     *
     * Protobuf type {@code google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec)
        com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpecOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1beta.ConversationalSearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_AnswerQueryRequest_SearchSpec_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1beta.ConversationalSearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_AnswerQueryRequest_SearchSpec_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.class,
                com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (searchParamsBuilder_ != null) {
          searchParamsBuilder_.clear();
        }
        if (searchResultListBuilder_ != null) {
          searchResultListBuilder_.clear();
        }
        inputCase_ = 0;
        input_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.discoveryengine.v1beta.ConversationalSearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_AnswerQueryRequest_SearchSpec_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
          getDefaultInstanceForType() {
        return com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec build() {
        com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec buildPartial() {
        com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec result =
            new com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec result) {
        int from_bitField0_ = bitField0_;
      }

      private void buildPartialOneofs(
          com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec result) {
        result.inputCase_ = inputCase_;
        result.input_ = this.input_;
        if (inputCase_ == 1 && searchParamsBuilder_ != null) {
          result.input_ = searchParamsBuilder_.build();
        }
        if (inputCase_ == 2 && searchResultListBuilder_ != null) {
          result.input_ = searchResultListBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec) {
          return mergeFrom(
              (com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec other) {
        if (other
            == com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                .getDefaultInstance()) return this;
        switch (other.getInputCase()) {
          case SEARCH_PARAMS:
            {
              mergeSearchParams(other.getSearchParams());
              break;
            }
          case SEARCH_RESULT_LIST:
            {
              mergeSearchResultList(other.getSearchResultList());
              break;
            }
          case INPUT_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getSearchParamsFieldBuilder().getBuilder(), extensionRegistry);
                  inputCase_ = 1;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(
                      getSearchResultListFieldBuilder().getBuilder(), extensionRegistry);
                  inputCase_ = 2;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int inputCase_ = 0;
      private java.lang.Object input_;

      public InputCase getInputCase() {
        return InputCase.forNumber(inputCase_);
      }

      public Builder clearInput() {
        inputCase_ = 0;
        input_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchParams,
              com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchParams
                  .Builder,
              com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                  .SearchParamsOrBuilder>
          searchParamsBuilder_;
      /**
       *
       *
       * <pre>
       * Search parameters.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchParams search_params = 1;
       * </code>
       *
       * @return Whether the searchParams field is set.
       */
      @java.lang.Override
      public boolean hasSearchParams() {
        return inputCase_ == 1;
      }
      /**
       *
       *
       * <pre>
       * Search parameters.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchParams search_params = 1;
       * </code>
       *
       * @return The searchParams.
       */
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchParams
          getSearchParams() {
        if (searchParamsBuilder_ == null) {
          if (inputCase_ == 1) {
            return (com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                    .SearchParams)
                input_;
          }
          return com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchParams
              .getDefaultInstance();
        } else {
          if (inputCase_ == 1) {
            return searchParamsBuilder_.getMessage();
          }
          return com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchParams
              .getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Search parameters.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchParams search_params = 1;
       * </code>
       */
      public Builder setSearchParams(
          com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchParams
              value) {
        if (searchParamsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          input_ = value;
          onChanged();
        } else {
          searchParamsBuilder_.setMessage(value);
        }
        inputCase_ = 1;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Search parameters.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchParams search_params = 1;
       * </code>
       */
      public Builder setSearchParams(
          com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchParams.Builder
              builderForValue) {
        if (searchParamsBuilder_ == null) {
          input_ = builderForValue.build();
          onChanged();
        } else {
          searchParamsBuilder_.setMessage(builderForValue.build());
        }
        inputCase_ = 1;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Search parameters.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchParams search_params = 1;
       * </code>
       */
      public Builder mergeSearchParams(
          com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchParams
              value) {
        if (searchParamsBuilder_ == null) {
          if (inputCase_ == 1
              && input_
                  != com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                      .SearchParams.getDefaultInstance()) {
            input_ =
                com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchParams
                    .newBuilder(
                        (com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                                .SearchParams)
                            input_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            input_ = value;
          }
          onChanged();
        } else {
          if (inputCase_ == 1) {
            searchParamsBuilder_.mergeFrom(value);
          } else {
            searchParamsBuilder_.setMessage(value);
          }
        }
        inputCase_ = 1;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Search parameters.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchParams search_params = 1;
       * </code>
       */
      public Builder clearSearchParams() {
        if (searchParamsBuilder_ == null) {
          if (inputCase_ == 1) {
            inputCase_ = 0;
            input_ = null;
            onChanged();
          }
        } else {
          if (inputCase_ == 1) {
            inputCase_ = 0;
            input_ = null;
          }
          searchParamsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Search parameters.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchParams search_params = 1;
       * </code>
       */
      public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchParams
              .Builder
          getSearchParamsBuilder() {
        return getSearchParamsFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Search parameters.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchParams search_params = 1;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
              .SearchParamsOrBuilder
          getSearchParamsOrBuilder() {
        if ((inputCase_ == 1) && (searchParamsBuilder_ != null)) {
          return searchParamsBuilder_.getMessageOrBuilder();
        } else {
          if (inputCase_ == 1) {
            return (com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                    .SearchParams)
                input_;
          }
          return com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchParams
              .getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Search parameters.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchParams search_params = 1;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchParams,
              com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchParams
                  .Builder,
              com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                  .SearchParamsOrBuilder>
          getSearchParamsFieldBuilder() {
        if (searchParamsBuilder_ == null) {
          if (!(inputCase_ == 1)) {
            input_ =
                com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchParams
                    .getDefaultInstance();
          }
          searchParamsBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                      .SearchParams,
                  com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchParams
                      .Builder,
                  com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                      .SearchParamsOrBuilder>(
                  (com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                          .SearchParams)
                      input_,
                  getParentForChildren(),
                  isClean());
          input_ = null;
        }
        inputCase_ = 1;
        onChanged();
        return searchParamsBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                  .SearchResultList,
              com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList
                  .Builder,
              com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                  .SearchResultListOrBuilder>
          searchResultListBuilder_;
      /**
       *
       *
       * <pre>
       * Search result list.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList search_result_list = 2;
       * </code>
       *
       * @return Whether the searchResultList field is set.
       */
      @java.lang.Override
      public boolean hasSearchResultList() {
        return inputCase_ == 2;
      }
      /**
       *
       *
       * <pre>
       * Search result list.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList search_result_list = 2;
       * </code>
       *
       * @return The searchResultList.
       */
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList
          getSearchResultList() {
        if (searchResultListBuilder_ == null) {
          if (inputCase_ == 2) {
            return (com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                    .SearchResultList)
                input_;
          }
          return com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
              .SearchResultList.getDefaultInstance();
        } else {
          if (inputCase_ == 2) {
            return searchResultListBuilder_.getMessage();
          }
          return com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
              .SearchResultList.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Search result list.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList search_result_list = 2;
       * </code>
       */
      public Builder setSearchResultList(
          com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList
              value) {
        if (searchResultListBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          input_ = value;
          onChanged();
        } else {
          searchResultListBuilder_.setMessage(value);
        }
        inputCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Search result list.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList search_result_list = 2;
       * </code>
       */
      public Builder setSearchResultList(
          com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList
                  .Builder
              builderForValue) {
        if (searchResultListBuilder_ == null) {
          input_ = builderForValue.build();
          onChanged();
        } else {
          searchResultListBuilder_.setMessage(builderForValue.build());
        }
        inputCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Search result list.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList search_result_list = 2;
       * </code>
       */
      public Builder mergeSearchResultList(
          com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList
              value) {
        if (searchResultListBuilder_ == null) {
          if (inputCase_ == 2
              && input_
                  != com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                      .SearchResultList.getDefaultInstance()) {
            input_ =
                com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                    .SearchResultList.newBuilder(
                        (com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                                .SearchResultList)
                            input_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            input_ = value;
          }
          onChanged();
        } else {
          if (inputCase_ == 2) {
            searchResultListBuilder_.mergeFrom(value);
          } else {
            searchResultListBuilder_.setMessage(value);
          }
        }
        inputCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Search result list.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList search_result_list = 2;
       * </code>
       */
      public Builder clearSearchResultList() {
        if (searchResultListBuilder_ == null) {
          if (inputCase_ == 2) {
            inputCase_ = 0;
            input_ = null;
            onChanged();
          }
        } else {
          if (inputCase_ == 2) {
            inputCase_ = 0;
            input_ = null;
          }
          searchResultListBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Search result list.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList search_result_list = 2;
       * </code>
       */
      public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList
              .Builder
          getSearchResultListBuilder() {
        return getSearchResultListFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Search result list.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList search_result_list = 2;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
              .SearchResultListOrBuilder
          getSearchResultListOrBuilder() {
        if ((inputCase_ == 2) && (searchResultListBuilder_ != null)) {
          return searchResultListBuilder_.getMessageOrBuilder();
        } else {
          if (inputCase_ == 2) {
            return (com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                    .SearchResultList)
                input_;
          }
          return com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
              .SearchResultList.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Search result list.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList search_result_list = 2;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                  .SearchResultList,
              com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.SearchResultList
                  .Builder,
              com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                  .SearchResultListOrBuilder>
          getSearchResultListFieldBuilder() {
        if (searchResultListBuilder_ == null) {
          if (!(inputCase_ == 2)) {
            input_ =
                com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                    .SearchResultList.getDefaultInstance();
          }
          searchResultListBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                      .SearchResultList,
                  com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                      .SearchResultList.Builder,
                  com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                      .SearchResultListOrBuilder>(
                  (com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
                          .SearchResultList)
                      input_,
                  getParentForChildren(),
                  isClean());
          input_ = null;
        }
        inputCase_ = 2;
        onChanged();
        return searchResultListBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec)
    private static final com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec();
    }

    public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<SearchSpec> PARSER =
        new com.google.protobuf.AbstractParser<SearchSpec>() {
          @java.lang.Override
          public SearchSpec parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<SearchSpec> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<SearchSpec> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface QueryUnderstandingSpecOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Query classification specification.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec.QueryClassificationSpec query_classification_spec = 1;
     * </code>
     *
     * @return Whether the queryClassificationSpec field is set.
     */
    boolean hasQueryClassificationSpec();
    /**
     *
     *
     * <pre>
     * Query classification specification.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec.QueryClassificationSpec query_classification_spec = 1;
     * </code>
     *
     * @return The queryClassificationSpec.
     */
    com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
            .QueryClassificationSpec
        getQueryClassificationSpec();
    /**
     *
     *
     * <pre>
     * Query classification specification.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec.QueryClassificationSpec query_classification_spec = 1;
     * </code>
     */
    com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
            .QueryClassificationSpecOrBuilder
        getQueryClassificationSpecOrBuilder();

    /**
     *
     *
     * <pre>
     * Query rephraser specification.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec.QueryRephraserSpec query_rephraser_spec = 2;
     * </code>
     *
     * @return Whether the queryRephraserSpec field is set.
     */
    boolean hasQueryRephraserSpec();
    /**
     *
     *
     * <pre>
     * Query rephraser specification.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec.QueryRephraserSpec query_rephraser_spec = 2;
     * </code>
     *
     * @return The queryRephraserSpec.
     */
    com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
            .QueryRephraserSpec
        getQueryRephraserSpec();
    /**
     *
     *
     * <pre>
     * Query rephraser specification.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec.QueryRephraserSpec query_rephraser_spec = 2;
     * </code>
     */
    com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
            .QueryRephraserSpecOrBuilder
        getQueryRephraserSpecOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * Query understanding specification.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec}
   */
  public static final class QueryUnderstandingSpec extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec)
      QueryUnderstandingSpecOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use QueryUnderstandingSpec.newBuilder() to construct.
    private QueryUnderstandingSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private QueryUnderstandingSpec() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new QueryUnderstandingSpec();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1beta.ConversationalSearchServiceProto
          .internal_static_google_cloud_discoveryengine_v1beta_AnswerQueryRequest_QueryUnderstandingSpec_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1beta.ConversationalSearchServiceProto
          .internal_static_google_cloud_discoveryengine_v1beta_AnswerQueryRequest_QueryUnderstandingSpec_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
                  .class,
              com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
                  .Builder.class);
    }

    public interface QueryClassificationSpecOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec.QueryClassificationSpec)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Enabled query classification types.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec.QueryClassificationSpec.Type types = 1;
       * </code>
       *
       * @return A list containing the types.
       */
      java.util.List<
              com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
                  .QueryClassificationSpec.Type>
          getTypesList();
      /**
       *
       *
       * <pre>
       * Enabled query classification types.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec.QueryClassificationSpec.Type types = 1;
       * </code>
       *
       * @return The count of types.
       */
      int getTypesCount();
      /**
       *
       *
       * <pre>
       * Enabled query classification types.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec.QueryClassificationSpec.Type types = 1;
       * </code>
       *
       * @param index The index of the element to return.
       * @return The types at the given index.
       */
      com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
              .QueryClassificationSpec.Type
          getTypes(int index);
      /**
       *
       *
       * <pre>
       * Enabled query classification types.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec.QueryClassificationSpec.Type types = 1;
       * </code>
       *
       * @return A list containing the enum numeric values on the wire for types.
       */
      java.util.List<java.lang.Integer> getTypesValueList();
      /**
       *
       *
       * <pre>
       * Enabled query classification types.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec.QueryClassificationSpec.Type types = 1;
       * </code>
       *
       * @param index The index of the value to return.
       * @return The enum numeric value on the wire of types at the given index.
       */
      int getTypesValue(int index);
    }
    /**
     *
     *
     * <pre>
     * Query classification specification.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec.QueryClassificationSpec}
     */
    public static final class QueryClassificationSpec extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec.QueryClassificationSpec)
        QueryClassificationSpecOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use QueryClassificationSpec.newBuilder() to construct.
      private QueryClassificationSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private QueryClassificationSpec() {
        types_ = java.util.Collections.emptyList();
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new QueryClassificationSpec();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1beta.ConversationalSearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_AnswerQueryRequest_QueryUnderstandingSpec_QueryClassificationSpec_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1beta.ConversationalSearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_AnswerQueryRequest_QueryUnderstandingSpec_QueryClassificationSpec_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
                    .QueryClassificationSpec.class,
                com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
                    .QueryClassificationSpec.Builder.class);
      }

      /**
       *
       *
       * <pre>
       * Query classification types.
       * </pre>
       *
       * Protobuf enum {@code
       * google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec.QueryClassificationSpec.Type}
       */
      public enum Type implements com.google.protobuf.ProtocolMessageEnum {
        /**
         *
         *
         * <pre>
         * Unspecified query classification type.
         * </pre>
         *
         * <code>TYPE_UNSPECIFIED = 0;</code>
         */
        TYPE_UNSPECIFIED(0),
        /**
         *
         *
         * <pre>
         * Adversarial query classification type.
         * </pre>
         *
         * <code>ADVERSARIAL_QUERY = 1;</code>
         */
        ADVERSARIAL_QUERY(1),
        /**
         *
         *
         * <pre>
         * Non-answer-seeking query classification type, for chit chat.
         * </pre>
         *
         * <code>NON_ANSWER_SEEKING_QUERY = 2;</code>
         */
        NON_ANSWER_SEEKING_QUERY(2),
        /**
         *
         *
         * <pre>
         * Jail-breaking query classification type.
         * </pre>
         *
         * <code>JAIL_BREAKING_QUERY = 3;</code>
         */
        JAIL_BREAKING_QUERY(3),
        /**
         *
         *
         * <pre>
         * Non-answer-seeking query classification type, for no clear intent.
         * </pre>
         *
         * <code>NON_ANSWER_SEEKING_QUERY_V2 = 4;</code>
         */
        NON_ANSWER_SEEKING_QUERY_V2(4),
        UNRECOGNIZED(-1),
        ;

        /**
         *
         *
         * <pre>
         * Unspecified query classification type.
         * </pre>
         *
         * <code>TYPE_UNSPECIFIED = 0;</code>
         */
        public static final int TYPE_UNSPECIFIED_VALUE = 0;
        /**
         *
         *
         * <pre>
         * Adversarial query classification type.
         * </pre>
         *
         * <code>ADVERSARIAL_QUERY = 1;</code>
         */
        public static final int ADVERSARIAL_QUERY_VALUE = 1;
        /**
         *
         *
         * <pre>
         * Non-answer-seeking query classification type, for chit chat.
         * </pre>
         *
         * <code>NON_ANSWER_SEEKING_QUERY = 2;</code>
         */
        public static final int NON_ANSWER_SEEKING_QUERY_VALUE = 2;
        /**
         *
         *
         * <pre>
         * Jail-breaking query classification type.
         * </pre>
         *
         * <code>JAIL_BREAKING_QUERY = 3;</code>
         */
        public static final int JAIL_BREAKING_QUERY_VALUE = 3;
        /**
         *
         *
         * <pre>
         * Non-answer-seeking query classification type, for no clear intent.
         * </pre>
         *
         * <code>NON_ANSWER_SEEKING_QUERY_V2 = 4;</code>
         */
        public static final int NON_ANSWER_SEEKING_QUERY_V2_VALUE = 4;

        public final int getNumber() {
          if (this == UNRECOGNIZED) {
            throw new java.lang.IllegalArgumentException(
                "Can't get the number of an unknown enum value.");
          }
          return value;
        }

        /**
         * @param value The numeric wire value of the corresponding enum entry.
         * @return The enum associated with the given numeric wire value.
         * @deprecated Use {@link #forNumber(int)} instead.
         */
        @java.lang.Deprecated
        public static Type valueOf(int value) {
          return forNumber(value);
        }

        /**
         * @param value The numeric wire value of the corresponding enum entry.
         * @return The enum associated with the given numeric wire value.
         */
        public static Type forNumber(int value) {
          switch (value) {
            case 0:
              return TYPE_UNSPECIFIED;
            case 1:
              return ADVERSARIAL_QUERY;
            case 2:
              return NON_ANSWER_SEEKING_QUERY;
            case 3:
              return JAIL_BREAKING_QUERY;
            case 4:
              return NON_ANSWER_SEEKING_QUERY_V2;
            default:
              return null;
          }
        }

        public static com.google.protobuf.Internal.EnumLiteMap<Type> internalGetValueMap() {
          return internalValueMap;
        }

        private static final com.google.protobuf.Internal.EnumLiteMap<Type> internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<Type>() {
              public Type findValueByNumber(int number) {
                return Type.forNumber(number);
              }
            };

        public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
          if (this == UNRECOGNIZED) {
            throw new java.lang.IllegalStateException(
                "Can't get the descriptor of an unrecognized enum value.");
          }
          return getDescriptor().getValues().get(ordinal());
        }

        public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
          return getDescriptor();
        }

        public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
          return com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
              .QueryClassificationSpec.getDescriptor()
              .getEnumTypes()
              .get(0);
        }

        private static final Type[] VALUES = values();

        public static Type valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
          if (desc.getType() != getDescriptor()) {
            throw new java.lang.IllegalArgumentException(
                "EnumValueDescriptor is not for this type.");
          }
          if (desc.getIndex() == -1) {
            return UNRECOGNIZED;
          }
          return VALUES[desc.getIndex()];
        }

        private final int value;

        private Type(int value) {
          this.value = value;
        }

        // @@protoc_insertion_point(enum_scope:google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec.QueryClassificationSpec.Type)
      }

      public static final int TYPES_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private java.util.List<java.lang.Integer> types_;

      private static final com.google.protobuf.Internal.ListAdapter.Converter<
              java.lang.Integer,
              com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
                  .QueryClassificationSpec.Type>
          types_converter_ =
              new com.google.protobuf.Internal.ListAdapter.Converter<
                  java.lang.Integer,
                  com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
                      .QueryClassificationSpec.Type>() {
                public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest
                        .QueryUnderstandingSpec.QueryClassificationSpec.Type
                    convert(java.lang.Integer from) {
                  com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
                          .QueryClassificationSpec.Type
                      result =
                          com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest
                              .QueryUnderstandingSpec.QueryClassificationSpec.Type.forNumber(from);
                  return result == null
                      ? com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest
                          .QueryUnderstandingSpec.QueryClassificationSpec.Type.UNRECOGNIZED
                      : result;
                }
              };
      /**
       *
       *
       * <pre>
       * Enabled query classification types.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec.QueryClassificationSpec.Type types = 1;
       * </code>
       *
       * @return A list containing the types.
       */
      @java.lang.Override
      public java.util.List<
              com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
                  .QueryClassificationSpec.Type>
          getTypesList() {
        return new com.google.protobuf.Internal.ListAdapter<
            java.lang.Integer,
            com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
                .QueryClassificationSpec.Type>(types_, types_converter_);
      }
      /**
       *
       *
       * <pre>
       * Enabled query classification types.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec.QueryClassificationSpec.Type types = 1;
       * </code>
       *
       * @return The count of types.
       */
      @java.lang.Override
      public int getTypesCount() {
        return types_.size();
      }
      /**
       *
       *
       * <pre>
       * Enabled query classification types.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec.QueryClassificationSpec.Type types = 1;
       * </code>
       *
       * @param index The index of the element to return.
       * @return The types at the given index.
       */
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
              .QueryClassificationSpec.Type
          getTypes(int index) {
        return types_converter_.convert(types_.get(index));
      }
      /**
       *
       *
       * <pre>
       * Enabled query classification types.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec.QueryClassificationSpec.Type types = 1;
       * </code>
       *
       * @return A list containing the enum numeric values on the wire for types.
       */
      @java.lang.Override
      public java.util.List<java.lang.Integer> getTypesValueList() {
        return types_;
      }
      /**
       *
       *
       * <pre>
       * Enabled query classification types.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec.QueryClassificationSpec.Type types = 1;
       * </code>
       *
       * @param index The index of the value to return.
       * @return The enum numeric value on the wire of types at the given index.
       */
      @java.lang.Override
      public int getTypesValue(int index) {
        return types_.get(index);
      }

      private int typesMemoizedSerializedSize;

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        getSerializedSize();
        if (getTypesList().size() > 0) {
          output.writeUInt32NoTag(10);
          output.writeUInt32NoTag(typesMemoizedSerializedSize);
        }
        for (int i = 0; i < types_.size(); i++) {
          output.writeEnumNoTag(types_.get(i));
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        {
          int dataSize = 0;
          for (int i = 0; i < types_.size(); i++) {
            dataSize += com.google.protobuf.CodedOutputStream.computeEnumSizeNoTag(types_.get(i));
          }
          size += dataSize;
          if (!getTypesList().isEmpty()) {
            size += 1;
            size += com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(dataSize);
          }
          typesMemoizedSerializedSize = dataSize;
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
                .QueryClassificationSpec)) {
          return super.equals(obj);
        }
        com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
                .QueryClassificationSpec
            other =
                (com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
                        .QueryClassificationSpec)
                    obj;

        if (!types_.equals(other.types_)) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (getTypesCount() > 0) {
          hash = (37 * hash) + TYPES_FIELD_NUMBER;
          hash = (53 * hash) + types_.hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest
              .QueryUnderstandingSpec.QueryClassificationSpec
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest
              .QueryUnderstandingSpec.QueryClassificationSpec
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest
              .QueryUnderstandingSpec.QueryClassificationSpec
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest
              .QueryUnderstandingSpec.QueryClassificationSpec
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest
              .QueryUnderstandingSpec.QueryClassificationSpec
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest
              .QueryUnderstandingSpec.QueryClassificationSpec
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest
              .QueryUnderstandingSpec.QueryClassificationSpec
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest
              .QueryUnderstandingSpec.QueryClassificationSpec
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest
              .QueryUnderstandingSpec.QueryClassificationSpec
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest
              .QueryUnderstandingSpec.QueryClassificationSpec
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest
              .QueryUnderstandingSpec.QueryClassificationSpec
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest
              .QueryUnderstandingSpec.QueryClassificationSpec
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
                  .QueryClassificationSpec
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Query classification specification.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec.QueryClassificationSpec}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec.QueryClassificationSpec)
          com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
              .QueryClassificationSpecOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.discoveryengine.v1beta.ConversationalSearchServiceProto
              .internal_static_google_cloud_discoveryengine_v1beta_AnswerQueryRequest_QueryUnderstandingSpec_QueryClassificationSpec_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.discoveryengine.v1beta.ConversationalSearchServiceProto
              .internal_static_google_cloud_discoveryengine_v1beta_AnswerQueryRequest_QueryUnderstandingSpec_QueryClassificationSpec_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
                      .QueryClassificationSpec.class,
                  com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
                      .QueryClassificationSpec.Builder.class);
        }

        // Construct using
        // com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec.QueryClassificationSpec.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          types_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.discoveryengine.v1beta.ConversationalSearchServiceProto
              .internal_static_google_cloud_discoveryengine_v1beta_AnswerQueryRequest_QueryUnderstandingSpec_QueryClassificationSpec_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
                .QueryClassificationSpec
            getDefaultInstanceForType() {
          return com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
              .QueryClassificationSpec.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
                .QueryClassificationSpec
            build() {
          com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
                  .QueryClassificationSpec
              result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
                .QueryClassificationSpec
            buildPartial() {
          com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
                  .QueryClassificationSpec
              result =
                  new com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest
                      .QueryUnderstandingSpec.QueryClassificationSpec(this);
          buildPartialRepeatedFields(result);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartialRepeatedFields(
            com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
                    .QueryClassificationSpec
                result) {
          if (((bitField0_ & 0x00000001) != 0)) {
            types_ = java.util.Collections.unmodifiableList(types_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.types_ = types_;
        }

        private void buildPartial0(
            com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
                    .QueryClassificationSpec
                result) {
          int from_bitField0_ = bitField0_;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
                  .QueryClassificationSpec) {
            return mergeFrom(
                (com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
                        .QueryClassificationSpec)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
                    .QueryClassificationSpec
                other) {
          if (other
              == com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
                  .QueryClassificationSpec.getDefaultInstance()) return this;
          if (!other.types_.isEmpty()) {
            if (types_.isEmpty()) {
              types_ = other.types_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureTypesIsMutable();
              types_.addAll(other.types_);
            }
            onChanged();
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 8:
                  {
                    int tmpRaw = input.readEnum();
                    ensureTypesIsMutable();
                    types_.add(tmpRaw);
                    break;
                  } // case 8
                case 10:
                  {
                    int length = input.readRawVarint32();
                    int oldLimit = input.pushLimit(length);
                    while (input.getBytesUntilLimit() > 0) {
                      int tmpRaw = input.readEnum();
                      ensureTypesIsMutable();
                      types_.add(tmpRaw);
                    }
                    input.popLimit(oldLimit);
                    break;
                  } // case 10
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.util.List<java.lang.Integer> types_ = java.util.Collections.emptyList();

        private void ensureTypesIsMutable() {
          if (!((bitField0_ & 0x00000001) != 0)) {
            types_ = new java.util.ArrayList<java.lang.Integer>(types_);
            bitField0_ |= 0x00000001;
          }
        }
        /**
         *
         *
         * <pre>
         * Enabled query classification types.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec.QueryClassificationSpec.Type types = 1;
         * </code>
         *
         * @return A list containing the types.
         */
        public java.util.List<
                com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
                    .QueryClassificationSpec.Type>
            getTypesList() {
          return new com.google.protobuf.Internal.ListAdapter<
              java.lang.Integer,
              com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
                  .QueryClassificationSpec.Type>(types_, types_converter_);
        }
        /**
         *
         *
         * <pre>
         * Enabled query classification types.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec.QueryClassificationSpec.Type types = 1;
         * </code>
         *
         * @return The count of types.
         */
        public int getTypesCount() {
          return types_.size();
        }
        /**
         *
         *
         * <pre>
         * Enabled query classification types.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec.QueryClassificationSpec.Type types = 1;
         * </code>
         *
         * @param index The index of the element to return.
         * @return The types at the given index.
         */
        public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
                .QueryClassificationSpec.Type
            getTypes(int index) {
          return types_converter_.convert(types_.get(index));
        }
        /**
         *
         *
         * <pre>
         * Enabled query classification types.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec.QueryClassificationSpec.Type types = 1;
         * </code>
         *
         * @param index The index to set the value at.
         * @param value The types to set.
         * @return This builder for chaining.
         */
        public Builder setTypes(
            int index,
            com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
                    .QueryClassificationSpec.Type
                value) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureTypesIsMutable();
          types_.set(index, value.getNumber());
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Enabled query classification types.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec.QueryClassificationSpec.Type types = 1;
         * </code>
         *
         * @param value The types to add.
         * @return This builder for chaining.
         */
        public Builder addTypes(
            com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
                    .QueryClassificationSpec.Type
                value) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureTypesIsMutable();
          types_.add(value.getNumber());
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Enabled query classification types.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec.QueryClassificationSpec.Type types = 1;
         * </code>
         *
         * @param values The types to add.
         * @return This builder for chaining.
         */
        public Builder addAllTypes(
            java.lang.Iterable<
                    ? extends
                        com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest
                            .QueryUnderstandingSpec.QueryClassificationSpec.Type>
                values) {
          ensureTypesIsMutable();
          for (com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
                  .QueryClassificationSpec.Type
              value : values) {
            types_.add(value.getNumber());
          }
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Enabled query classification types.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec.QueryClassificationSpec.Type types = 1;
         * </code>
         *
         * @return This builder for chaining.
         */
        public Builder clearTypes() {
          types_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Enabled query classification types.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec.QueryClassificationSpec.Type types = 1;
         * </code>
         *
         * @return A list containing the enum numeric values on the wire for types.
         */
        public java.util.List<java.lang.Integer> getTypesValueList() {
          return java.util.Collections.unmodifiableList(types_);
        }
        /**
         *
         *
         * <pre>
         * Enabled query classification types.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec.QueryClassificationSpec.Type types = 1;
         * </code>
         *
         * @param index The index of the value to return.
         * @return The enum numeric value on the wire of types at the given index.
         */
        public int getTypesValue(int index) {
          return types_.get(index);
        }
        /**
         *
         *
         * <pre>
         * Enabled query classification types.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec.QueryClassificationSpec.Type types = 1;
         * </code>
         *
         * @param index The index to set the value at.
         * @param value The enum numeric value on the wire for types to set.
         * @return This builder for chaining.
         */
        public Builder setTypesValue(int index, int value) {
          ensureTypesIsMutable();
          types_.set(index, value);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Enabled query classification types.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec.QueryClassificationSpec.Type types = 1;
         * </code>
         *
         * @param value The enum numeric value on the wire for types to add.
         * @return This builder for chaining.
         */
        public Builder addTypesValue(int value) {
          ensureTypesIsMutable();
          types_.add(value);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Enabled query classification types.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec.QueryClassificationSpec.Type types = 1;
         * </code>
         *
         * @param values The enum numeric values on the wire for types to add.
         * @return This builder for chaining.
         */
        public Builder addAllTypesValue(java.lang.Iterable<java.lang.Integer> values) {
          ensureTypesIsMutable();
          for (int value : values) {
            types_.add(value);
          }
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec.QueryClassificationSpec)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec.QueryClassificationSpec)
      private static final com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest
              .QueryUnderstandingSpec.QueryClassificationSpec
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
                .QueryClassificationSpec();
      }

      public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest
              .QueryUnderstandingSpec.QueryClassificationSpec
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<QueryClassificationSpec> PARSER =
          new com.google.protobuf.AbstractParser<QueryClassificationSpec>() {
            @java.lang.Override
            public QueryClassificationSpec parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<QueryClassificationSpec> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<QueryClassificationSpec> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
              .QueryClassificationSpec
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface QueryRephraserSpecOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec.QueryRephraserSpec)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Disable query rephraser.
       * </pre>
       *
       * <code>bool disable = 1;</code>
       *
       * @return The disable.
       */
      boolean getDisable();

      /**
       *
       *
       * <pre>
       * Max rephrase steps.
       * The max number is 5 steps.
       * If not set or set to &lt; 1, it will be set to 1 by default.
       * </pre>
       *
       * <code>int32 max_rephrase_steps = 2;</code>
       *
       * @return The maxRephraseSteps.
       */
      int getMaxRephraseSteps();
    }
    /**
     *
     *
     * <pre>
     * Query rephraser specification.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec.QueryRephraserSpec}
     */
    public static final class QueryRephraserSpec extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec.QueryRephraserSpec)
        QueryRephraserSpecOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use QueryRephraserSpec.newBuilder() to construct.
      private QueryRephraserSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private QueryRephraserSpec() {}

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new QueryRephraserSpec();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1beta.ConversationalSearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_AnswerQueryRequest_QueryUnderstandingSpec_QueryRephraserSpec_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1beta.ConversationalSearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_AnswerQueryRequest_QueryUnderstandingSpec_QueryRephraserSpec_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
                    .QueryRephraserSpec.class,
                com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
                    .QueryRephraserSpec.Builder.class);
      }

      public static final int DISABLE_FIELD_NUMBER = 1;
      private boolean disable_ = false;
      /**
       *
       *
       * <pre>
       * Disable query rephraser.
       * </pre>
       *
       * <code>bool disable = 1;</code>
       *
       * @return The disable.
       */
      @java.lang.Override
      public boolean getDisable() {
        return disable_;
      }

      public static final int MAX_REPHRASE_STEPS_FIELD_NUMBER = 2;
      private int maxRephraseSteps_ = 0;
      /**
       *
       *
       * <pre>
       * Max rephrase steps.
       * The max number is 5 steps.
       * If not set or set to &lt; 1, it will be set to 1 by default.
       * </pre>
       *
       * <code>int32 max_rephrase_steps = 2;</code>
       *
       * @return The maxRephraseSteps.
       */
      @java.lang.Override
      public int getMaxRephraseSteps() {
        return maxRephraseSteps_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (disable_ != false) {
          output.writeBool(1, disable_);
        }
        if (maxRephraseSteps_ != 0) {
          output.writeInt32(2, maxRephraseSteps_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (disable_ != false) {
          size += com.google.protobuf.CodedOutputStream.computeBoolSize(1, disable_);
        }
        if (maxRephraseSteps_ != 0) {
          size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, maxRephraseSteps_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
                .QueryRephraserSpec)) {
          return super.equals(obj);
        }
        com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
                .QueryRephraserSpec
            other =
                (com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
                        .QueryRephraserSpec)
                    obj;

        if (getDisable() != other.getDisable()) return false;
        if (getMaxRephraseSteps() != other.getMaxRephraseSteps()) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + DISABLE_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getDisable());
        hash = (37 * hash) + MAX_REPHRASE_STEPS_FIELD_NUMBER;
        hash = (53 * hash) + getMaxRephraseSteps();
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest
              .QueryUnderstandingSpec.QueryRephraserSpec
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest
              .QueryUnderstandingSpec.QueryRephraserSpec
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest
              .QueryUnderstandingSpec.QueryRephraserSpec
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest
              .QueryUnderstandingSpec.QueryRephraserSpec
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest
              .QueryUnderstandingSpec.QueryRephraserSpec
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest
              .QueryUnderstandingSpec.QueryRephraserSpec
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest
              .QueryUnderstandingSpec.QueryRephraserSpec
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest
              .QueryUnderstandingSpec.QueryRephraserSpec
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest
              .QueryUnderstandingSpec.QueryRephraserSpec
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest
              .QueryUnderstandingSpec.QueryRephraserSpec
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest
              .QueryUnderstandingSpec.QueryRephraserSpec
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest
              .QueryUnderstandingSpec.QueryRephraserSpec
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
                  .QueryRephraserSpec
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Query rephraser specification.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec.QueryRephraserSpec}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec.QueryRephraserSpec)
          com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
              .QueryRephraserSpecOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.discoveryengine.v1beta.ConversationalSearchServiceProto
              .internal_static_google_cloud_discoveryengine_v1beta_AnswerQueryRequest_QueryUnderstandingSpec_QueryRephraserSpec_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.discoveryengine.v1beta.ConversationalSearchServiceProto
              .internal_static_google_cloud_discoveryengine_v1beta_AnswerQueryRequest_QueryUnderstandingSpec_QueryRephraserSpec_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
                      .QueryRephraserSpec.class,
                  com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
                      .QueryRephraserSpec.Builder.class);
        }

        // Construct using
        // com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec.QueryRephraserSpec.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          disable_ = false;
          maxRephraseSteps_ = 0;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.discoveryengine.v1beta.ConversationalSearchServiceProto
              .internal_static_google_cloud_discoveryengine_v1beta_AnswerQueryRequest_QueryUnderstandingSpec_QueryRephraserSpec_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
                .QueryRephraserSpec
            getDefaultInstanceForType() {
          return com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
              .QueryRephraserSpec.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
                .QueryRephraserSpec
            build() {
          com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
                  .QueryRephraserSpec
              result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
                .QueryRephraserSpec
            buildPartial() {
          com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
                  .QueryRephraserSpec
              result =
                  new com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest
                      .QueryUnderstandingSpec.QueryRephraserSpec(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
                    .QueryRephraserSpec
                result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.disable_ = disable_;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.maxRephraseSteps_ = maxRephraseSteps_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
                  .QueryRephraserSpec) {
            return mergeFrom(
                (com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
                        .QueryRephraserSpec)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
                    .QueryRephraserSpec
                other) {
          if (other
              == com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
                  .QueryRephraserSpec.getDefaultInstance()) return this;
          if (other.getDisable() != false) {
            setDisable(other.getDisable());
          }
          if (other.getMaxRephraseSteps() != 0) {
            setMaxRephraseSteps(other.getMaxRephraseSteps());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 8:
                  {
                    disable_ = input.readBool();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 8
                case 16:
                  {
                    maxRephraseSteps_ = input.readInt32();
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 16
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private boolean disable_;
        /**
         *
         *
         * <pre>
         * Disable query rephraser.
         * </pre>
         *
         * <code>bool disable = 1;</code>
         *
         * @return The disable.
         */
        @java.lang.Override
        public boolean getDisable() {
          return disable_;
        }
        /**
         *
         *
         * <pre>
         * Disable query rephraser.
         * </pre>
         *
         * <code>bool disable = 1;</code>
         *
         * @param value The disable to set.
         * @return This builder for chaining.
         */
        public Builder setDisable(boolean value) {

          disable_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Disable query rephraser.
         * </pre>
         *
         * <code>bool disable = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearDisable() {
          bitField0_ = (bitField0_ & ~0x00000001);
          disable_ = false;
          onChanged();
          return this;
        }

        private int maxRephraseSteps_;
        /**
         *
         *
         * <pre>
         * Max rephrase steps.
         * The max number is 5 steps.
         * If not set or set to &lt; 1, it will be set to 1 by default.
         * </pre>
         *
         * <code>int32 max_rephrase_steps = 2;</code>
         *
         * @return The maxRephraseSteps.
         */
        @java.lang.Override
        public int getMaxRephraseSteps() {
          return maxRephraseSteps_;
        }
        /**
         *
         *
         * <pre>
         * Max rephrase steps.
         * The max number is 5 steps.
         * If not set or set to &lt; 1, it will be set to 1 by default.
         * </pre>
         *
         * <code>int32 max_rephrase_steps = 2;</code>
         *
         * @param value The maxRephraseSteps to set.
         * @return This builder for chaining.
         */
        public Builder setMaxRephraseSteps(int value) {

          maxRephraseSteps_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Max rephrase steps.
         * The max number is 5 steps.
         * If not set or set to &lt; 1, it will be set to 1 by default.
         * </pre>
         *
         * <code>int32 max_rephrase_steps = 2;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearMaxRephraseSteps() {
          bitField0_ = (bitField0_ & ~0x00000002);
          maxRephraseSteps_ = 0;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec.QueryRephraserSpec)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec.QueryRephraserSpec)
      private static final com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest
              .QueryUnderstandingSpec.QueryRephraserSpec
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
                .QueryRephraserSpec();
      }

      public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest
              .QueryUnderstandingSpec.QueryRephraserSpec
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<QueryRephraserSpec> PARSER =
          new com.google.protobuf.AbstractParser<QueryRephraserSpec>() {
            @java.lang.Override
            public QueryRephraserSpec parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<QueryRephraserSpec> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<QueryRephraserSpec> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
              .QueryRephraserSpec
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    private int bitField0_;
    public static final int QUERY_CLASSIFICATION_SPEC_FIELD_NUMBER = 1;
    private com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
            .QueryClassificationSpec
        queryClassificationSpec_;
    /**
     *
     *
     * <pre>
     * Query classification specification.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec.QueryClassificationSpec query_classification_spec = 1;
     * </code>
     *
     * @return Whether the queryClassificationSpec field is set.
     */
    @java.lang.Override
    public boolean hasQueryClassificationSpec() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Query classification specification.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec.QueryClassificationSpec query_classification_spec = 1;
     * </code>
     *
     * @return The queryClassificationSpec.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
            .QueryClassificationSpec
        getQueryClassificationSpec() {
      return queryClassificationSpec_ == null
          ? com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
              .QueryClassificationSpec.getDefaultInstance()
          : queryClassificationSpec_;
    }
    /**
     *
     *
     * <pre>
     * Query classification specification.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec.QueryClassificationSpec query_classification_spec = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
            .QueryClassificationSpecOrBuilder
        getQueryClassificationSpecOrBuilder() {
      return queryClassificationSpec_ == null
          ? com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
              .QueryClassificationSpec.getDefaultInstance()
          : queryClassificationSpec_;
    }

    public static final int QUERY_REPHRASER_SPEC_FIELD_NUMBER = 2;
    private com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
            .QueryRephraserSpec
        queryRephraserSpec_;
    /**
     *
     *
     * <pre>
     * Query rephraser specification.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec.QueryRephraserSpec query_rephraser_spec = 2;
     * </code>
     *
     * @return Whether the queryRephraserSpec field is set.
     */
    @java.lang.Override
    public boolean hasQueryRephraserSpec() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Query rephraser specification.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec.QueryRephraserSpec query_rephraser_spec = 2;
     * </code>
     *
     * @return The queryRephraserSpec.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
            .QueryRephraserSpec
        getQueryRephraserSpec() {
      return queryRephraserSpec_ == null
          ? com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
              .QueryRephraserSpec.getDefaultInstance()
          : queryRephraserSpec_;
    }
    /**
     *
     *
     * <pre>
     * Query rephraser specification.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec.QueryRephraserSpec query_rephraser_spec = 2;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
            .QueryRephraserSpecOrBuilder
        getQueryRephraserSpecOrBuilder() {
      return queryRephraserSpec_ == null
          ? com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
              .QueryRephraserSpec.getDefaultInstance()
          : queryRephraserSpec_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getQueryClassificationSpec());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeMessage(2, getQueryRephraserSpec());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                1, getQueryClassificationSpec());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(2, getQueryRephraserSpec());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec)) {
        return super.equals(obj);
      }
      com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec other =
          (com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec) obj;

      if (hasQueryClassificationSpec() != other.hasQueryClassificationSpec()) return false;
      if (hasQueryClassificationSpec()) {
        if (!getQueryClassificationSpec().equals(other.getQueryClassificationSpec())) return false;
      }
      if (hasQueryRephraserSpec() != other.hasQueryRephraserSpec()) return false;
      if (hasQueryRephraserSpec()) {
        if (!getQueryRephraserSpec().equals(other.getQueryRephraserSpec())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasQueryClassificationSpec()) {
        hash = (37 * hash) + QUERY_CLASSIFICATION_SPEC_FIELD_NUMBER;
        hash = (53 * hash) + getQueryClassificationSpec().hashCode();
      }
      if (hasQueryRephraserSpec()) {
        hash = (37 * hash) + QUERY_REPHRASER_SPEC_FIELD_NUMBER;
        hash = (53 * hash) + getQueryRephraserSpec().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Query understanding specification.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec)
        com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpecOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1beta.ConversationalSearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_AnswerQueryRequest_QueryUnderstandingSpec_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1beta.ConversationalSearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_AnswerQueryRequest_QueryUnderstandingSpec_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
                    .class,
                com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
                    .Builder.class);
      }

      // Construct using
      // com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getQueryClassificationSpecFieldBuilder();
          getQueryRephraserSpecFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        queryClassificationSpec_ = null;
        if (queryClassificationSpecBuilder_ != null) {
          queryClassificationSpecBuilder_.dispose();
          queryClassificationSpecBuilder_ = null;
        }
        queryRephraserSpec_ = null;
        if (queryRephraserSpecBuilder_ != null) {
          queryRephraserSpecBuilder_.dispose();
          queryRephraserSpecBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.discoveryengine.v1beta.ConversationalSearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_AnswerQueryRequest_QueryUnderstandingSpec_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
          getDefaultInstanceForType() {
        return com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
          build() {
        com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
          buildPartial() {
        com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec result =
            new com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec(
                this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
              result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.queryClassificationSpec_ =
              queryClassificationSpecBuilder_ == null
                  ? queryClassificationSpec_
                  : queryClassificationSpecBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.queryRephraserSpec_ =
              queryRephraserSpecBuilder_ == null
                  ? queryRephraserSpec_
                  : queryRephraserSpecBuilder_.build();
          to_bitField0_ |= 0x00000002;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec) {
          return mergeFrom(
              (com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec other) {
        if (other
            == com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
                .getDefaultInstance()) return this;
        if (other.hasQueryClassificationSpec()) {
          mergeQueryClassificationSpec(other.getQueryClassificationSpec());
        }
        if (other.hasQueryRephraserSpec()) {
          mergeQueryRephraserSpec(other.getQueryRephraserSpec());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(
                      getQueryClassificationSpecFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(
                      getQueryRephraserSpecFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
              .QueryClassificationSpec
          queryClassificationSpec_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
                  .QueryClassificationSpec,
              com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
                  .QueryClassificationSpec.Builder,
              com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
                  .QueryClassificationSpecOrBuilder>
          queryClassificationSpecBuilder_;
      /**
       *
       *
       * <pre>
       * Query classification specification.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec.QueryClassificationSpec query_classification_spec = 1;
       * </code>
       *
       * @return Whether the queryClassificationSpec field is set.
       */
      public boolean hasQueryClassificationSpec() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * Query classification specification.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec.QueryClassificationSpec query_classification_spec = 1;
       * </code>
       *
       * @return The queryClassificationSpec.
       */
      public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
              .QueryClassificationSpec
          getQueryClassificationSpec() {
        if (queryClassificationSpecBuilder_ == null) {
          return queryClassificationSpec_ == null
              ? com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
                  .QueryClassificationSpec.getDefaultInstance()
              : queryClassificationSpec_;
        } else {
          return queryClassificationSpecBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Query classification specification.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec.QueryClassificationSpec query_classification_spec = 1;
       * </code>
       */
      public Builder setQueryClassificationSpec(
          com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
                  .QueryClassificationSpec
              value) {
        if (queryClassificationSpecBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          queryClassificationSpec_ = value;
        } else {
          queryClassificationSpecBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Query classification specification.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec.QueryClassificationSpec query_classification_spec = 1;
       * </code>
       */
      public Builder setQueryClassificationSpec(
          com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
                  .QueryClassificationSpec.Builder
              builderForValue) {
        if (queryClassificationSpecBuilder_ == null) {
          queryClassificationSpec_ = builderForValue.build();
        } else {
          queryClassificationSpecBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Query classification specification.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec.QueryClassificationSpec query_classification_spec = 1;
       * </code>
       */
      public Builder mergeQueryClassificationSpec(
          com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
                  .QueryClassificationSpec
              value) {
        if (queryClassificationSpecBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && queryClassificationSpec_ != null
              && queryClassificationSpec_
                  != com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest
                      .QueryUnderstandingSpec.QueryClassificationSpec.getDefaultInstance()) {
            getQueryClassificationSpecBuilder().mergeFrom(value);
          } else {
            queryClassificationSpec_ = value;
          }
        } else {
          queryClassificationSpecBuilder_.mergeFrom(value);
        }
        if (queryClassificationSpec_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Query classification specification.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec.QueryClassificationSpec query_classification_spec = 1;
       * </code>
       */
      public Builder clearQueryClassificationSpec() {
        bitField0_ = (bitField0_ & ~0x00000001);
        queryClassificationSpec_ = null;
        if (queryClassificationSpecBuilder_ != null) {
          queryClassificationSpecBuilder_.dispose();
          queryClassificationSpecBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Query classification specification.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec.QueryClassificationSpec query_classification_spec = 1;
       * </code>
       */
      public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
              .QueryClassificationSpec.Builder
          getQueryClassificationSpecBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getQueryClassificationSpecFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Query classification specification.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec.QueryClassificationSpec query_classification_spec = 1;
       * </code>
       */
      public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
              .QueryClassificationSpecOrBuilder
          getQueryClassificationSpecOrBuilder() {
        if (queryClassificationSpecBuilder_ != null) {
          return queryClassificationSpecBuilder_.getMessageOrBuilder();
        } else {
          return queryClassificationSpec_ == null
              ? com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
                  .QueryClassificationSpec.getDefaultInstance()
              : queryClassificationSpec_;
        }
      }
      /**
       *
       *
       * <pre>
       * Query classification specification.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec.QueryClassificationSpec query_classification_spec = 1;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
                  .QueryClassificationSpec,
              com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
                  .QueryClassificationSpec.Builder,
              com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
                  .QueryClassificationSpecOrBuilder>
          getQueryClassificationSpecFieldBuilder() {
        if (queryClassificationSpecBuilder_ == null) {
          queryClassificationSpecBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
                      .QueryClassificationSpec,
                  com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
                      .QueryClassificationSpec.Builder,
                  com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
                      .QueryClassificationSpecOrBuilder>(
                  getQueryClassificationSpec(), getParentForChildren(), isClean());
          queryClassificationSpec_ = null;
        }
        return queryClassificationSpecBuilder_;
      }

      private com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
              .QueryRephraserSpec
          queryRephraserSpec_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
                  .QueryRephraserSpec,
              com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
                  .QueryRephraserSpec.Builder,
              com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
                  .QueryRephraserSpecOrBuilder>
          queryRephraserSpecBuilder_;
      /**
       *
       *
       * <pre>
       * Query rephraser specification.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec.QueryRephraserSpec query_rephraser_spec = 2;
       * </code>
       *
       * @return Whether the queryRephraserSpec field is set.
       */
      public boolean hasQueryRephraserSpec() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * Query rephraser specification.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec.QueryRephraserSpec query_rephraser_spec = 2;
       * </code>
       *
       * @return The queryRephraserSpec.
       */
      public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
              .QueryRephraserSpec
          getQueryRephraserSpec() {
        if (queryRephraserSpecBuilder_ == null) {
          return queryRephraserSpec_ == null
              ? com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
                  .QueryRephraserSpec.getDefaultInstance()
              : queryRephraserSpec_;
        } else {
          return queryRephraserSpecBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Query rephraser specification.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec.QueryRephraserSpec query_rephraser_spec = 2;
       * </code>
       */
      public Builder setQueryRephraserSpec(
          com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
                  .QueryRephraserSpec
              value) {
        if (queryRephraserSpecBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          queryRephraserSpec_ = value;
        } else {
          queryRephraserSpecBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Query rephraser specification.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec.QueryRephraserSpec query_rephraser_spec = 2;
       * </code>
       */
      public Builder setQueryRephraserSpec(
          com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
                  .QueryRephraserSpec.Builder
              builderForValue) {
        if (queryRephraserSpecBuilder_ == null) {
          queryRephraserSpec_ = builderForValue.build();
        } else {
          queryRephraserSpecBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Query rephraser specification.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec.QueryRephraserSpec query_rephraser_spec = 2;
       * </code>
       */
      public Builder mergeQueryRephraserSpec(
          com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
                  .QueryRephraserSpec
              value) {
        if (queryRephraserSpecBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && queryRephraserSpec_ != null
              && queryRephraserSpec_
                  != com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest
                      .QueryUnderstandingSpec.QueryRephraserSpec.getDefaultInstance()) {
            getQueryRephraserSpecBuilder().mergeFrom(value);
          } else {
            queryRephraserSpec_ = value;
          }
        } else {
          queryRephraserSpecBuilder_.mergeFrom(value);
        }
        if (queryRephraserSpec_ != null) {
          bitField0_ |= 0x00000002;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Query rephraser specification.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec.QueryRephraserSpec query_rephraser_spec = 2;
       * </code>
       */
      public Builder clearQueryRephraserSpec() {
        bitField0_ = (bitField0_ & ~0x00000002);
        queryRephraserSpec_ = null;
        if (queryRephraserSpecBuilder_ != null) {
          queryRephraserSpecBuilder_.dispose();
          queryRephraserSpecBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Query rephraser specification.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec.QueryRephraserSpec query_rephraser_spec = 2;
       * </code>
       */
      public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
              .QueryRephraserSpec.Builder
          getQueryRephraserSpecBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getQueryRephraserSpecFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Query rephraser specification.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec.QueryRephraserSpec query_rephraser_spec = 2;
       * </code>
       */
      public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
              .QueryRephraserSpecOrBuilder
          getQueryRephraserSpecOrBuilder() {
        if (queryRephraserSpecBuilder_ != null) {
          return queryRephraserSpecBuilder_.getMessageOrBuilder();
        } else {
          return queryRephraserSpec_ == null
              ? com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
                  .QueryRephraserSpec.getDefaultInstance()
              : queryRephraserSpec_;
        }
      }
      /**
       *
       *
       * <pre>
       * Query rephraser specification.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec.QueryRephraserSpec query_rephraser_spec = 2;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
                  .QueryRephraserSpec,
              com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
                  .QueryRephraserSpec.Builder,
              com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
                  .QueryRephraserSpecOrBuilder>
          getQueryRephraserSpecFieldBuilder() {
        if (queryRephraserSpecBuilder_ == null) {
          queryRephraserSpecBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
                      .QueryRephraserSpec,
                  com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
                      .QueryRephraserSpec.Builder,
                  com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
                      .QueryRephraserSpecOrBuilder>(
                  getQueryRephraserSpec(), getParentForChildren(), isClean());
          queryRephraserSpec_ = null;
        }
        return queryRephraserSpecBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec)
    private static final com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest
            .QueryUnderstandingSpec
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec();
    }

    public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<QueryUnderstandingSpec> PARSER =
        new com.google.protobuf.AbstractParser<QueryUnderstandingSpec>() {
          @java.lang.Override
          public QueryUnderstandingSpec parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<QueryUnderstandingSpec> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<QueryUnderstandingSpec> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int SERVING_CONFIG_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object servingConfig_ = "";
  /**
   *
   *
   * <pre>
   * Required. The resource name of the Search serving config, such as
   * `projects/&#42;&#47;locations/global/collections/default_collection/engines/&#42;&#47;servingConfigs/default_serving_config`,
   * or
   * `projects/&#42;&#47;locations/global/collections/default_collection/dataStores/&#42;&#47;servingConfigs/default_serving_config`.
   * This field is used to identify the serving configuration name, set
   * of models used to make the search.
   * </pre>
   *
   * <code>
   * string serving_config = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The servingConfig.
   */
  @java.lang.Override
  public java.lang.String getServingConfig() {
    java.lang.Object ref = servingConfig_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      servingConfig_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The resource name of the Search serving config, such as
   * `projects/&#42;&#47;locations/global/collections/default_collection/engines/&#42;&#47;servingConfigs/default_serving_config`,
   * or
   * `projects/&#42;&#47;locations/global/collections/default_collection/dataStores/&#42;&#47;servingConfigs/default_serving_config`.
   * This field is used to identify the serving configuration name, set
   * of models used to make the search.
   * </pre>
   *
   * <code>
   * string serving_config = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for servingConfig.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getServingConfigBytes() {
    java.lang.Object ref = servingConfig_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      servingConfig_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int QUERY_FIELD_NUMBER = 2;
  private com.google.cloud.discoveryengine.v1beta.Query query_;
  /**
   *
   *
   * <pre>
   * Required. Current user query.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1beta.Query query = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the query field is set.
   */
  @java.lang.Override
  public boolean hasQuery() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Required. Current user query.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1beta.Query query = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The query.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.Query getQuery() {
    return query_ == null
        ? com.google.cloud.discoveryengine.v1beta.Query.getDefaultInstance()
        : query_;
  }
  /**
   *
   *
   * <pre>
   * Required. Current user query.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1beta.Query query = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.QueryOrBuilder getQueryOrBuilder() {
    return query_ == null
        ? com.google.cloud.discoveryengine.v1beta.Query.getDefaultInstance()
        : query_;
  }

  public static final int SESSION_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object session_ = "";
  /**
   *
   *
   * <pre>
   * The session resource name. Not required.
   *
   * When session field is not set, the API is in sessionless mode.
   *
   * We support auto session mode: users can use the wildcard symbol `-` as
   * session ID.  A new ID will be automatically generated and assigned.
   * </pre>
   *
   * <code>string session = 3 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The session.
   */
  @java.lang.Override
  public java.lang.String getSession() {
    java.lang.Object ref = session_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      session_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The session resource name. Not required.
   *
   * When session field is not set, the API is in sessionless mode.
   *
   * We support auto session mode: users can use the wildcard symbol `-` as
   * session ID.  A new ID will be automatically generated and assigned.
   * </pre>
   *
   * <code>string session = 3 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for session.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSessionBytes() {
    java.lang.Object ref = session_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      session_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SAFETY_SPEC_FIELD_NUMBER = 4;
  private com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SafetySpec safetySpec_;
  /**
   *
   *
   * <pre>
   * Model specification.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SafetySpec safety_spec = 4;
   * </code>
   *
   * @return Whether the safetySpec field is set.
   */
  @java.lang.Override
  public boolean hasSafetySpec() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Model specification.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SafetySpec safety_spec = 4;
   * </code>
   *
   * @return The safetySpec.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SafetySpec getSafetySpec() {
    return safetySpec_ == null
        ? com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SafetySpec.getDefaultInstance()
        : safetySpec_;
  }
  /**
   *
   *
   * <pre>
   * Model specification.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SafetySpec safety_spec = 4;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SafetySpecOrBuilder
      getSafetySpecOrBuilder() {
    return safetySpec_ == null
        ? com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SafetySpec.getDefaultInstance()
        : safetySpec_;
  }

  public static final int RELATED_QUESTIONS_SPEC_FIELD_NUMBER = 5;
  private com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.RelatedQuestionsSpec
      relatedQuestionsSpec_;
  /**
   *
   *
   * <pre>
   * Related questions specification.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.RelatedQuestionsSpec related_questions_spec = 5;
   * </code>
   *
   * @return Whether the relatedQuestionsSpec field is set.
   */
  @java.lang.Override
  public boolean hasRelatedQuestionsSpec() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Related questions specification.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.RelatedQuestionsSpec related_questions_spec = 5;
   * </code>
   *
   * @return The relatedQuestionsSpec.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.RelatedQuestionsSpec
      getRelatedQuestionsSpec() {
    return relatedQuestionsSpec_ == null
        ? com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.RelatedQuestionsSpec
            .getDefaultInstance()
        : relatedQuestionsSpec_;
  }
  /**
   *
   *
   * <pre>
   * Related questions specification.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.RelatedQuestionsSpec related_questions_spec = 5;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.RelatedQuestionsSpecOrBuilder
      getRelatedQuestionsSpecOrBuilder() {
    return relatedQuestionsSpec_ == null
        ? com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.RelatedQuestionsSpec
            .getDefaultInstance()
        : relatedQuestionsSpec_;
  }

  public static final int GROUNDING_SPEC_FIELD_NUMBER = 6;
  private com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.GroundingSpec groundingSpec_;
  /**
   *
   *
   * <pre>
   * Optional. Grounding specification.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.GroundingSpec grounding_spec = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the groundingSpec field is set.
   */
  @java.lang.Override
  public boolean hasGroundingSpec() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. Grounding specification.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.GroundingSpec grounding_spec = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The groundingSpec.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.GroundingSpec
      getGroundingSpec() {
    return groundingSpec_ == null
        ? com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.GroundingSpec
            .getDefaultInstance()
        : groundingSpec_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Grounding specification.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.GroundingSpec grounding_spec = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.GroundingSpecOrBuilder
      getGroundingSpecOrBuilder() {
    return groundingSpec_ == null
        ? com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.GroundingSpec
            .getDefaultInstance()
        : groundingSpec_;
  }

  public static final int ANSWER_GENERATION_SPEC_FIELD_NUMBER = 7;
  private com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
      answerGenerationSpec_;
  /**
   *
   *
   * <pre>
   * Answer generation specification.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec answer_generation_spec = 7;
   * </code>
   *
   * @return Whether the answerGenerationSpec field is set.
   */
  @java.lang.Override
  public boolean hasAnswerGenerationSpec() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   *
   *
   * <pre>
   * Answer generation specification.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec answer_generation_spec = 7;
   * </code>
   *
   * @return The answerGenerationSpec.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
      getAnswerGenerationSpec() {
    return answerGenerationSpec_ == null
        ? com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
            .getDefaultInstance()
        : answerGenerationSpec_;
  }
  /**
   *
   *
   * <pre>
   * Answer generation specification.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec answer_generation_spec = 7;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpecOrBuilder
      getAnswerGenerationSpecOrBuilder() {
    return answerGenerationSpec_ == null
        ? com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.AnswerGenerationSpec
            .getDefaultInstance()
        : answerGenerationSpec_;
  }

  public static final int SEARCH_SPEC_FIELD_NUMBER = 8;
  private com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec searchSpec_;
  /**
   *
   *
   * <pre>
   * Search specification.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec search_spec = 8;
   * </code>
   *
   * @return Whether the searchSpec field is set.
   */
  @java.lang.Override
  public boolean hasSearchSpec() {
    return ((bitField0_ & 0x00000020) != 0);
  }
  /**
   *
   *
   * <pre>
   * Search specification.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec search_spec = 8;
   * </code>
   *
   * @return The searchSpec.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec getSearchSpec() {
    return searchSpec_ == null
        ? com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.getDefaultInstance()
        : searchSpec_;
  }
  /**
   *
   *
   * <pre>
   * Search specification.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec search_spec = 8;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpecOrBuilder
      getSearchSpecOrBuilder() {
    return searchSpec_ == null
        ? com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.SearchSpec.getDefaultInstance()
        : searchSpec_;
  }

  public static final int QUERY_UNDERSTANDING_SPEC_FIELD_NUMBER = 9;
  private com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
      queryUnderstandingSpec_;
  /**
   *
   *
   * <pre>
   * Query understanding specification.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec query_understanding_spec = 9;
   * </code>
   *
   * @return Whether the queryUnderstandingSpec field is set.
   */
  @java.lang.Override
  public boolean hasQueryUnderstandingSpec() {
    return ((bitField0_ & 0x00000040) != 0);
  }
  /**
   *
   *
   * <pre>
   * Query understanding specification.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec query_understanding_spec = 9;
   * </code>
   *
   * @return The queryUnderstandingSpec.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
      getQueryUnderstandingSpec() {
    return queryUnderstandingSpec_ == null
        ? com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
            .getDefaultInstance()
        : queryUnderstandingSpec_;
  }
  /**
   *
   *
   * <pre>
   * Query understanding specification.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec query_understanding_spec = 9;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpecOrBuilder
      getQueryUnderstandingSpecOrBuilder() {
    return queryUnderstandingSpec_ == null
        ? com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.QueryUnderstandingSpec
            .getDefaultInstance()
        : queryUnderstandingSpec_;
  }

  public static final int ASYNCHRONOUS_MODE_FIELD_NUMBER = 10;
  private boolean asynchronousMode_ = false;
  /**
   *
   *
   * <pre>
   * Deprecated: This field is deprecated. Streaming Answer API will be
   * supported.
   *
   * Asynchronous mode control.
   *
   * If enabled, the response will be returned with answer/session resource
   * name without final answer. The API users need to do the polling to get
   * the latest status of answer/session by calling
   * [ConversationalSearchService.GetAnswer][google.cloud.discoveryengine.v1beta.ConversationalSearchService.GetAnswer]
   * or
   * [ConversationalSearchService.GetSession][google.cloud.discoveryengine.v1beta.ConversationalSearchService.GetSession]
   * method.
   * </pre>
   *
   * <code>bool asynchronous_mode = 10 [deprecated = true];</code>
   *
   * @deprecated google.cloud.discoveryengine.v1beta.AnswerQueryRequest.asynchronous_mode is
   *     deprecated. See
   *     google/cloud/discoveryengine/v1beta/conversational_search_service.proto;l=861
   * @return The asynchronousMode.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public boolean getAsynchronousMode() {
    return asynchronousMode_;
  }

  public static final int USER_PSEUDO_ID_FIELD_NUMBER = 12;

  @SuppressWarnings("serial")
  private volatile java.lang.Object userPseudoId_ = "";
  /**
   *
   *
   * <pre>
   * A unique identifier for tracking visitors. For example, this could be
   * implemented with an HTTP cookie, which should be able to uniquely identify
   * a visitor on a single device. This unique identifier should not change if
   * the visitor logs in or out of the website.
   *
   * This field should NOT have a fixed value such as `unknown_visitor`.
   *
   * The field must be a UTF-8 encoded string with a length limit of 128
   * characters. Otherwise, an  `INVALID_ARGUMENT`  error is returned.
   * </pre>
   *
   * <code>string user_pseudo_id = 12;</code>
   *
   * @return The userPseudoId.
   */
  @java.lang.Override
  public java.lang.String getUserPseudoId() {
    java.lang.Object ref = userPseudoId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      userPseudoId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A unique identifier for tracking visitors. For example, this could be
   * implemented with an HTTP cookie, which should be able to uniquely identify
   * a visitor on a single device. This unique identifier should not change if
   * the visitor logs in or out of the website.
   *
   * This field should NOT have a fixed value such as `unknown_visitor`.
   *
   * The field must be a UTF-8 encoded string with a length limit of 128
   * characters. Otherwise, an  `INVALID_ARGUMENT`  error is returned.
   * </pre>
   *
   * <code>string user_pseudo_id = 12;</code>
   *
   * @return The bytes for userPseudoId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getUserPseudoIdBytes() {
    java.lang.Object ref = userPseudoId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      userPseudoId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int USER_LABELS_FIELD_NUMBER = 13;

  private static final class UserLabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.discoveryengine.v1beta.ConversationalSearchServiceProto
                .internal_static_google_cloud_discoveryengine_v1beta_AnswerQueryRequest_UserLabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> userLabels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetUserLabels() {
    if (userLabels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(UserLabelsDefaultEntryHolder.defaultEntry);
    }
    return userLabels_;
  }

  public int getUserLabelsCount() {
    return internalGetUserLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * The user labels applied to a resource must meet the following requirements:
   *
   * * Each resource can have multiple labels, up to a maximum of 64.
   * * Each label must be a key-value pair.
   * * Keys have a minimum length of 1 character and a maximum length of 63
   *   characters and cannot be empty. Values can be empty and have a maximum
   *   length of 63 characters.
   * * Keys and values can contain only lowercase letters, numeric characters,
   *   underscores, and dashes. All characters must use UTF-8 encoding, and
   *   international characters are allowed.
   * * The key portion of a label must be unique. However, you can use the same
   *   key with multiple resources.
   * * Keys must start with a lowercase letter or international character.
   *
   * See [Google Cloud
   * Document](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
   * for more details.
   * </pre>
   *
   * <code>map&lt;string, string&gt; user_labels = 13;</code>
   */
  @java.lang.Override
  public boolean containsUserLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetUserLabels().getMap().containsKey(key);
  }
  /** Use {@link #getUserLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getUserLabels() {
    return getUserLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * The user labels applied to a resource must meet the following requirements:
   *
   * * Each resource can have multiple labels, up to a maximum of 64.
   * * Each label must be a key-value pair.
   * * Keys have a minimum length of 1 character and a maximum length of 63
   *   characters and cannot be empty. Values can be empty and have a maximum
   *   length of 63 characters.
   * * Keys and values can contain only lowercase letters, numeric characters,
   *   underscores, and dashes. All characters must use UTF-8 encoding, and
   *   international characters are allowed.
   * * The key portion of a label must be unique. However, you can use the same
   *   key with multiple resources.
   * * Keys must start with a lowercase letter or international character.
   *
   * See [Google Cloud
   * Document](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
   * for more details.
   * </pre>
   *
   * <code>map&lt;string, string&gt; user_labels = 13;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getUserLabelsMap() {
    return internalGetUserLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * The user labels applied to a resource must meet the following requirements:
   *
   * * Each resource can have multiple labels, up to a maximum of 64.
   * * Each label must be a key-value pair.
   * * Keys have a minimum length of 1 character and a maximum length of 63
   *   characters and cannot be empty. Values can be empty and have a maximum
   *   length of 63 characters.
   * * Keys and values can contain only lowercase letters, numeric characters,
   *   underscores, and dashes. All characters must use UTF-8 encoding, and
   *   international characters are allowed.
   * * The key portion of a label must be unique. However, you can use the same
   *   key with multiple resources.
   * * Keys must start with a lowercase letter or international character.
   *
   * See [Google Cloud
   * Document](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
   * for more details.
   * </pre>
   *
   * <code>map&lt;string, string&gt; user_labels = 13;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getUserLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetUserLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * The user labels applied to a resource must meet the following requirements:
   *
   * * Each resource can have multiple labels, up to a maximum of 64.
   * * Each label must be a key-value pair.
   * * Keys have a minimum length of 1 character and a maximum length of 63
   *   characters and cannot be empty. Values can be empty and have a maximum
   *   length of 63 characters.
   * * Keys and values can contain only lowercase letters, numeric characters,
   *   underscores, and dashes. All characters must use UTF-8 encoding, and
   *   international characters are allowed.
   * * The key portion of a label must be unique. However, you can use the same
   *   key with multiple resources.
   * * Keys must start with a lowercase letter or international character.
   *
   * See [Google Cloud
   * Document](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
   * for more details.
   * </pre>
   *
   * <code>map&lt;string, string&gt; user_labels = 13;</code>
   */
  @java.lang.Override
  public java.lang.String getUserLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetUserLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(servingConfig_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, servingConfig_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(2, getQuery());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(session_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, session_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(4, getSafetySpec());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(5, getRelatedQuestionsSpec());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(6, getGroundingSpec());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeMessage(7, getAnswerGenerationSpec());
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      output.writeMessage(8, getSearchSpec());
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      output.writeMessage(9, getQueryUnderstandingSpec());
    }
    if (asynchronousMode_ != false) {
      output.writeBool(10, asynchronousMode_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(userPseudoId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 12, userPseudoId_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetUserLabels(), UserLabelsDefaultEntryHolder.defaultEntry, 13);
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(servingConfig_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, servingConfig_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getQuery());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(session_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, session_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getSafetySpec());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(5, getRelatedQuestionsSpec());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getGroundingSpec());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(7, getAnswerGenerationSpec());
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getSearchSpec());
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(9, getQueryUnderstandingSpec());
    }
    if (asynchronousMode_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(10, asynchronousMode_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(userPseudoId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(12, userPseudoId_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetUserLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> userLabels__ =
          UserLabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(13, userLabels__);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest other =
        (com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest) obj;

    if (!getServingConfig().equals(other.getServingConfig())) return false;
    if (hasQuery() != other.hasQuery()) return false;
    if (hasQuery()) {
      if (!getQuery().equals(other.getQuery())) return false;
    }
    if (!getSession().equals(other.getSession())) return false;
    if (hasSafetySpec() != other.hasSafetySpec()) return false;
    if (hasSafetySpec()) {
      if (!getSafetySpec().equals(other.getSafetySpec())) return false;
    }
    if (hasRelatedQuestionsSpec() != other.hasRelatedQuestionsSpec()) return false;
    if (hasRelatedQuestionsSpec()) {
      if (!getRelatedQuestionsSpec().equals(other.getRelatedQuestionsSpec())) return false;
    }
    if (hasGroundingSpec() != other.hasGroundingSpec()) return false;
    if (hasGroundingSpec()) {
      if (!getGroundingSpec().equals(other.getGroundingSpec())) return false;
    }
    if (hasAnswerGenerationSpec() != other.hasAnswerGenerationSpec()) return false;
    if (hasAnswerGenerationSpec()) {
      if (!getAnswerGenerationSpec().equals(other.getAnswerGenerationSpec())) return false;
    }
    if (hasSearchSpec() != other.hasSearchSpec()) return false;
    if (hasSearchSpec()) {
      if (!getSearchSpec().equals(other.getSearchSpec())) return false;
    }
    if (hasQueryUnderstandingSpec() != other.hasQueryUnderstandingSpec()) return false;
    if (hasQueryUnderstandingSpec()) {
      if (!getQueryUnderstandingSpec().equals(other.getQueryUnderstandingSpec())) return false;
    }
    if (getAsynchronousMode() != other.getAsynchronousMode()) return false;
    if (!getUserPseudoId().equals(other.getUserPseudoId())) return false;
    if (!internalGetUserLabels().equals(other.internalGetUserLabels())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + SERVING_CONFIG_FIELD_NUMBER;
    hash = (53 * hash) + getServingConfig().hashCode();
    if (hasQuery()) {
      hash = (37 * hash) + QUERY_FIELD_NUMBER;
      hash = (53 * hash) + getQuery().hashCode();
    }
    hash = (37 * hash) + SESSION_FIELD_NUMBER;
    hash = (53 * hash) + getSession().hashCode();
    if (hasSafetySpec()) {
      hash = (37 * hash) + SAFETY_SPEC_FIELD_NUMBER;
      hash = (53 * hash) + getSafetySpec().hashCode();
    }
    if (hasRelatedQuestionsSpec()) {
      hash = (37 * hash) + RELATED_QUESTIONS_SPEC_FIELD_NUMBER;
      hash = (53 * hash) + getRelatedQuestionsSpec().hashCode();
    }
    if (hasGroundingSpec()) {
      hash = (37 * hash) + GROUNDING_SPEC_FIELD_NUMBER;
      hash = (53 * hash) + getGroundingSpec().hashCode();
    }
    if (hasAnswerGenerationSpec()) {
      hash = (37 * hash) + ANSWER_GENERATION_SPEC_FIELD_NUMBER;
      hash = (53 * hash) + getAnswerGenerationSpec().hashCode();
    }
    if (hasSearchSpec()) {
      hash = (37 * hash) + SEARCH_SPEC_FIELD_NUMBER;
      hash = (53 * hash) + getSearchSpec().hashCode();
    }
    if (hasQueryUnderstandingSpec()) {
      hash = (37 * hash) + QUERY_UNDERSTANDING_SPEC_FIELD_NUMBER;
      hash = (53 * hash) + getQueryUnderstandingSpec().hashCode();
    }
    hash = (37 * hash) + ASYNCHRONOUS_MODE_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getAsynchronousMode());
    hash = (37 * hash) + USER_PSEUDO_ID_FIELD_NUMBER;
    hash = (53 * hash) + getUserPseudoId().hashCode();
    if (!internalGetUserLabels().getMap().isEmpty()) {
      hash = (37 * hash) + USER_LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetUserLabels().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request message for
   * [ConversationalSearchService.AnswerQuery][google.cloud.discoveryengine.v1beta.ConversationalSearchService.AnswerQuery]
   * method.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1beta.AnswerQueryRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.AnswerQueryRequest)
      com.google.cloud.discoveryengine.v1beta.AnswerQueryRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1beta.ConversationalSearchServiceProto
          .internal_static_google_cloud_discoveryengine_v1beta_AnswerQueryRequest_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 13:
          return internalGetUserLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 13:
          return internalGetMutableUserLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1beta.ConversationalSearchServiceProto
          .internal_static_google_cloud_discoveryengine_v1beta_AnswerQueryRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.class,
              com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.Builder.class);
    }

    // Construct using com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getQueryFieldBuilder();
        getSafetySpecFieldBuilder();
        getRelatedQuestionsSpecFieldBuilder();
        getGroundingSpecFieldBuilder();
        getAnswerGenerationSpecFieldBuilder();
        getSearchSpecFieldBuilder();
        getQueryUnderstandingSpecFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      servingConfig_ = "";
      query_ = null;
      if (queryBuilder_ != null) {
        queryBuilder_.dispose();
        queryBuilder_ = null;
      }
      session_ = "";
      safetySpec_ = null;
      if (safetySpecBuilder_ != null) {
        safetySpecBuilder_.dispose();
        safetySpecBuilder_ = null;
      }
      relatedQuestionsSpec_ = null;
      if (relatedQuestionsSpecBuilder_ != null) {
        relatedQuestionsSpecBuilder_.dispose();
        relatedQuestionsSpecBuilder_ = null;
      }
      groundingSpec_ = null;
      if (groundingSpecBuilder_ != null) {
        groundingSpecBuilder_.dispose();
        groundingSpecBuilder_ = null;
      }
      answerGenerationSpec_ = null;
      if (answerGenerationSpecBuilder_ != null) {
        answerGenerationSpecBuilder_.dispose();
        answerGenerationSpecBuilder_ = null;
      }
      searchSpec_ = null;
      if (searchSpecBuilder_ != null) {
        searchSpecBuilder_.dispose();
        searchSpecBuilder_ = null;
      }
      queryUnderstandingSpec_ = null;
      if (queryUnderstandingSpecBuilder_ != null) {
        queryUnderstandingSpecBuilder_.dispose();
        queryUnderstandingSpecBuilder_ = null;
      }
      asynchronousMode_ = false;
      userPseudoId_ = "";
      internalGetMutableUserLabels().clear();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.discoveryengine.v1beta.ConversationalSearchServiceProto
          .internal_static_google_cloud_discoveryengine_v1beta_AnswerQueryRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest getDefaultInstanceForType() {
      return com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest build() {
      com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest buildPartial() {
      com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest result =
          new com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.servingConfig_ = servingConfig_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.query_ = queryBuilder_ == null ? query_ : queryBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.session_ = session_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.safetySpec_ = safetySpecBuilder_ == null ? safetySpec_ : safetySpecBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.relatedQuestionsSpec_ =
            relatedQuestionsSpecBuilder_ == null
                ? relatedQuestionsSpec_
                : relatedQuestionsSpecBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.groundingSpec_ =
            groundingSpecBuilder_ == null ? groundingSpec_ : groundingSpecBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.answerGenerationSpec_ =
            answerGenerationSpecBuilder_ == null
                ? answerGenerationSpec_
                : answerGenerationSpecBuilder_.build();
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.searchSpec_ = searchSpecBuilder_ == null ? searchSpec_ : searchSpecBuilder_.build();
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.queryUnderstandingSpec_ =
            queryUnderstandingSpecBuilder_ == null
                ? queryUnderstandingSpec_
                : queryUnderstandingSpecBuilder_.build();
        to_bitField0_ |= 0x00000040;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.asynchronousMode_ = asynchronousMode_;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.userPseudoId_ = userPseudoId_;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.userLabels_ = internalGetUserLabels();
        result.userLabels_.makeImmutable();
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest) {
        return mergeFrom((com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest other) {
      if (other == com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest.getDefaultInstance())
        return this;
      if (!other.getServingConfig().isEmpty()) {
        servingConfig_ = other.servingConfig_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasQuery()) {
        mergeQuery(other.getQuery());
      }
      if (!other.getSession().isEmpty()) {
        session_ = other.session_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasSafetySpec()) {
        mergeSafetySpec(other.getSafetySpec());
      }
      if (other.hasRelatedQuestionsSpec()) {
        mergeRelatedQuestionsSpec(other.getRelatedQuestionsSpec());
      }
      if (other.hasGroundingSpec()) {
        mergeGroundingSpec(other.getGroundingSpec());
      }
      if (other.hasAnswerGenerationSpec()) {
        mergeAnswerGenerationSpec(other.getAnswerGenerationSpec());
      }
      if (other.hasSearchSpec()) {
        mergeSearchSpec(other.getSearchSpec());
      }
      if (other.hasQueryUnderstandingSpec()) {
        mergeQueryUnderstandingSpec(other.getQueryUnderstandingSpec());
      }
      if (other.getAsynchronousMode() != false) {
        setAsynchronousMode(other.getAsynchronousMode());
      }
      if (!other.getUserPseudoId().isEmpty()) {
        userPseudoId_ = other.userPseudoId_;
        bitField0_ |= 0x00000400;
        onChanged();
      }
      internalGetMutableUserLabels().mergeFrom(other.internalGetUserLabels());
      bitField0_ |= 0x00000800;
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                servingConfig_ = input.readStringRequireUtf