/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/edgecontainer/v1/resources.proto

package com.google.cloud.edgecontainer.v1;

/**
 *
 *
 * <pre>
 * A Google Distributed Cloud Edge Kubernetes cluster.
 * </pre>
 *
 * Protobuf type {@code google.cloud.edgecontainer.v1.Cluster}
 */
public final class Cluster extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.edgecontainer.v1.Cluster)
    ClusterOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Cluster.newBuilder() to construct.
  private Cluster(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Cluster() {
    name_ = "";
    endpoint_ = "";
    clusterCaCertificate_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Cluster();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.edgecontainer.v1.ResourcesProto
        .internal_static_google_cloud_edgecontainer_v1_Cluster_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 4:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.edgecontainer.v1.ResourcesProto
        .internal_static_google_cloud_edgecontainer_v1_Cluster_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.edgecontainer.v1.Cluster.class,
            com.google.cloud.edgecontainer.v1.Cluster.Builder.class);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Required. The resource name of the cluster.
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The resource name of the cluster.
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 2;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. The time when the cluster was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time when the cluster was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time when the cluster was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 3;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. The time when the cluster was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return updateTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time when the cluster was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time when the cluster was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int LABELS_FIELD_NUMBER = 4;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.edgecontainer.v1.ResourcesProto
                .internal_static_google_cloud_edgecontainer_v1_Cluster_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Labels associated with this resource.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * Labels associated with this resource.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * Labels associated with this resource.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Labels associated with this resource.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int FLEET_FIELD_NUMBER = 11;
  private com.google.cloud.edgecontainer.v1.Fleet fleet_;
  /**
   *
   *
   * <pre>
   * Optional. Fleet configuration.
   * </pre>
   *
   * <code>
   * .google.cloud.edgecontainer.v1.Fleet fleet = 11 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the fleet field is set.
   */
  @java.lang.Override
  public boolean hasFleet() {
    return fleet_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. Fleet configuration.
   * </pre>
   *
   * <code>
   * .google.cloud.edgecontainer.v1.Fleet fleet = 11 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The fleet.
   */
  @java.lang.Override
  public com.google.cloud.edgecontainer.v1.Fleet getFleet() {
    return fleet_ == null ? com.google.cloud.edgecontainer.v1.Fleet.getDefaultInstance() : fleet_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Fleet configuration.
   * </pre>
   *
   * <code>
   * .google.cloud.edgecontainer.v1.Fleet fleet = 11 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.edgecontainer.v1.FleetOrBuilder getFleetOrBuilder() {
    return fleet_ == null ? com.google.cloud.edgecontainer.v1.Fleet.getDefaultInstance() : fleet_;
  }

  public static final int NETWORKING_FIELD_NUMBER = 7;
  private com.google.cloud.edgecontainer.v1.ClusterNetworking networking_;
  /**
   *
   *
   * <pre>
   * Required. Cluster-wide networking configuration.
   * </pre>
   *
   * <code>
   * .google.cloud.edgecontainer.v1.ClusterNetworking networking = 7 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the networking field is set.
   */
  @java.lang.Override
  public boolean hasNetworking() {
    return networking_ != null;
  }
  /**
   *
   *
   * <pre>
   * Required. Cluster-wide networking configuration.
   * </pre>
   *
   * <code>
   * .google.cloud.edgecontainer.v1.ClusterNetworking networking = 7 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The networking.
   */
  @java.lang.Override
  public com.google.cloud.edgecontainer.v1.ClusterNetworking getNetworking() {
    return networking_ == null
        ? com.google.cloud.edgecontainer.v1.ClusterNetworking.getDefaultInstance()
        : networking_;
  }
  /**
   *
   *
   * <pre>
   * Required. Cluster-wide networking configuration.
   * </pre>
   *
   * <code>
   * .google.cloud.edgecontainer.v1.ClusterNetworking networking = 7 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.edgecontainer.v1.ClusterNetworkingOrBuilder getNetworkingOrBuilder() {
    return networking_ == null
        ? com.google.cloud.edgecontainer.v1.ClusterNetworking.getDefaultInstance()
        : networking_;
  }

  public static final int AUTHORIZATION_FIELD_NUMBER = 9;
  private com.google.cloud.edgecontainer.v1.Authorization authorization_;
  /**
   *
   *
   * <pre>
   * Required. Immutable. RBAC policy that will be applied and managed by GEC.
   * </pre>
   *
   * <code>
   * .google.cloud.edgecontainer.v1.Authorization authorization = 9 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return Whether the authorization field is set.
   */
  @java.lang.Override
  public boolean hasAuthorization() {
    return authorization_ != null;
  }
  /**
   *
   *
   * <pre>
   * Required. Immutable. RBAC policy that will be applied and managed by GEC.
   * </pre>
   *
   * <code>
   * .google.cloud.edgecontainer.v1.Authorization authorization = 9 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The authorization.
   */
  @java.lang.Override
  public com.google.cloud.edgecontainer.v1.Authorization getAuthorization() {
    return authorization_ == null
        ? com.google.cloud.edgecontainer.v1.Authorization.getDefaultInstance()
        : authorization_;
  }
  /**
   *
   *
   * <pre>
   * Required. Immutable. RBAC policy that will be applied and managed by GEC.
   * </pre>
   *
   * <code>
   * .google.cloud.edgecontainer.v1.Authorization authorization = 9 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.edgecontainer.v1.AuthorizationOrBuilder getAuthorizationOrBuilder() {
    return authorization_ == null
        ? com.google.cloud.edgecontainer.v1.Authorization.getDefaultInstance()
        : authorization_;
  }

  public static final int DEFAULT_MAX_PODS_PER_NODE_FIELD_NUMBER = 8;
  private int defaultMaxPodsPerNode_ = 0;
  /**
   *
   *
   * <pre>
   * Optional. The default maximum number of pods per node used if a maximum value is not
   * specified explicitly for a node pool in this cluster. If unspecified, the
   * Kubernetes default value will be used.
   * </pre>
   *
   * <code>int32 default_max_pods_per_node = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The defaultMaxPodsPerNode.
   */
  @java.lang.Override
  public int getDefaultMaxPodsPerNode() {
    return defaultMaxPodsPerNode_;
  }

  public static final int ENDPOINT_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object endpoint_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The IP address of the Kubernetes API server.
   * </pre>
   *
   * <code>string endpoint = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The endpoint.
   */
  @java.lang.Override
  public java.lang.String getEndpoint() {
    java.lang.Object ref = endpoint_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      endpoint_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The IP address of the Kubernetes API server.
   * </pre>
   *
   * <code>string endpoint = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for endpoint.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEndpointBytes() {
    java.lang.Object ref = endpoint_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      endpoint_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CLUSTER_CA_CERTIFICATE_FIELD_NUMBER = 10;

  @SuppressWarnings("serial")
  private volatile java.lang.Object clusterCaCertificate_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The PEM-encoded public certificate of the cluster's CA.
   * </pre>
   *
   * <code>string cluster_ca_certificate = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The clusterCaCertificate.
   */
  @java.lang.Override
  public java.lang.String getClusterCaCertificate() {
    java.lang.Object ref = clusterCaCertificate_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      clusterCaCertificate_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The PEM-encoded public certificate of the cluster's CA.
   * </pre>
   *
   * <code>string cluster_ca_certificate = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for clusterCaCertificate.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getClusterCaCertificateBytes() {
    java.lang.Object ref = clusterCaCertificate_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      clusterCaCertificate_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MAINTENANCE_POLICY_FIELD_NUMBER = 12;
  private com.google.cloud.edgecontainer.v1.MaintenancePolicy maintenancePolicy_;
  /**
   *
   *
   * <pre>
   * Optional. Cluster-wide maintenance policy configuration.
   * </pre>
   *
   * <code>
   * .google.cloud.edgecontainer.v1.MaintenancePolicy maintenance_policy = 12 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the maintenancePolicy field is set.
   */
  @java.lang.Override
  public boolean hasMaintenancePolicy() {
    return maintenancePolicy_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. Cluster-wide maintenance policy configuration.
   * </pre>
   *
   * <code>
   * .google.cloud.edgecontainer.v1.MaintenancePolicy maintenance_policy = 12 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The maintenancePolicy.
   */
  @java.lang.Override
  public com.google.cloud.edgecontainer.v1.MaintenancePolicy getMaintenancePolicy() {
    return maintenancePolicy_ == null
        ? com.google.cloud.edgecontainer.v1.MaintenancePolicy.getDefaultInstance()
        : maintenancePolicy_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Cluster-wide maintenance policy configuration.
   * </pre>
   *
   * <code>
   * .google.cloud.edgecontainer.v1.MaintenancePolicy maintenance_policy = 12 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.edgecontainer.v1.MaintenancePolicyOrBuilder
      getMaintenancePolicyOrBuilder() {
    return maintenancePolicy_ == null
        ? com.google.cloud.edgecontainer.v1.MaintenancePolicy.getDefaultInstance()
        : maintenancePolicy_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (createTime_ != null) {
      output.writeMessage(2, getCreateTime());
    }
    if (updateTime_ != null) {
      output.writeMessage(3, getUpdateTime());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 4);
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(endpoint_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, endpoint_);
    }
    if (networking_ != null) {
      output.writeMessage(7, getNetworking());
    }
    if (defaultMaxPodsPerNode_ != 0) {
      output.writeInt32(8, defaultMaxPodsPerNode_);
    }
    if (authorization_ != null) {
      output.writeMessage(9, getAuthorization());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(clusterCaCertificate_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 10, clusterCaCertificate_);
    }
    if (fleet_ != null) {
      output.writeMessage(11, getFleet());
    }
    if (maintenancePolicy_ != null) {
      output.writeMessage(12, getMaintenancePolicy());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getCreateTime());
    }
    if (updateTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getUpdateTime());
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, labels__);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(endpoint_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, endpoint_);
    }
    if (networking_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getNetworking());
    }
    if (defaultMaxPodsPerNode_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(8, defaultMaxPodsPerNode_);
    }
    if (authorization_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getAuthorization());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(clusterCaCertificate_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(10, clusterCaCertificate_);
    }
    if (fleet_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(11, getFleet());
    }
    if (maintenancePolicy_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(12, getMaintenancePolicy());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.edgecontainer.v1.Cluster)) {
      return super.equals(obj);
    }
    com.google.cloud.edgecontainer.v1.Cluster other =
        (com.google.cloud.edgecontainer.v1.Cluster) obj;

    if (!getName().equals(other.getName())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (hasFleet() != other.hasFleet()) return false;
    if (hasFleet()) {
      if (!getFleet().equals(other.getFleet())) return false;
    }
    if (hasNetworking() != other.hasNetworking()) return false;
    if (hasNetworking()) {
      if (!getNetworking().equals(other.getNetworking())) return false;
    }
    if (hasAuthorization() != other.hasAuthorization()) return false;
    if (hasAuthorization()) {
      if (!getAuthorization().equals(other.getAuthorization())) return false;
    }
    if (getDefaultMaxPodsPerNode() != other.getDefaultMaxPodsPerNode()) return false;
    if (!getEndpoint().equals(other.getEndpoint())) return false;
    if (!getClusterCaCertificate().equals(other.getClusterCaCertificate())) return false;
    if (hasMaintenancePolicy() != other.hasMaintenancePolicy()) return false;
    if (hasMaintenancePolicy()) {
      if (!getMaintenancePolicy().equals(other.getMaintenancePolicy())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    if (hasFleet()) {
      hash = (37 * hash) + FLEET_FIELD_NUMBER;
      hash = (53 * hash) + getFleet().hashCode();
    }
    if (hasNetworking()) {
      hash = (37 * hash) + NETWORKING_FIELD_NUMBER;
      hash = (53 * hash) + getNetworking().hashCode();
    }
    if (hasAuthorization()) {
      hash = (37 * hash) + AUTHORIZATION_FIELD_NUMBER;
      hash = (53 * hash) + getAuthorization().hashCode();
    }
    hash = (37 * hash) + DEFAULT_MAX_PODS_PER_NODE_FIELD_NUMBER;
    hash = (53 * hash) + getDefaultMaxPodsPerNode();
    hash = (37 * hash) + ENDPOINT_FIELD_NUMBER;
    hash = (53 * hash) + getEndpoint().hashCode();
    hash = (37 * hash) + CLUSTER_CA_CERTIFICATE_FIELD_NUMBER;
    hash = (53 * hash) + getClusterCaCertificate().hashCode();
    if (hasMaintenancePolicy()) {
      hash = (37 * hash) + MAINTENANCE_POLICY_FIELD_NUMBER;
      hash = (53 * hash) + getMaintenancePolicy().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.edgecontainer.v1.Cluster parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.edgecontainer.v1.Cluster parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.edgecontainer.v1.Cluster parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.edgecontainer.v1.Cluster parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.edgecontainer.v1.Cluster parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.edgecontainer.v1.Cluster parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.edgecontainer.v1.Cluster parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.edgecontainer.v1.Cluster parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.edgecontainer.v1.Cluster parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.edgecontainer.v1.Cluster parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.edgecontainer.v1.Cluster parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.edgecontainer.v1.Cluster parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.edgecontainer.v1.Cluster prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A Google Distributed Cloud Edge Kubernetes cluster.
   * </pre>
   *
   * Protobuf type {@code google.cloud.edgecontainer.v1.Cluster}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.edgecontainer.v1.Cluster)
      com.google.cloud.edgecontainer.v1.ClusterOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.edgecontainer.v1.ResourcesProto
          .internal_static_google_cloud_edgecontainer_v1_Cluster_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 4:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 4:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.edgecontainer.v1.ResourcesProto
          .internal_static_google_cloud_edgecontainer_v1_Cluster_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.edgecontainer.v1.Cluster.class,
              com.google.cloud.edgecontainer.v1.Cluster.Builder.class);
    }

    // Construct using com.google.cloud.edgecontainer.v1.Cluster.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      internalGetMutableLabels().clear();
      fleet_ = null;
      if (fleetBuilder_ != null) {
        fleetBuilder_.dispose();
        fleetBuilder_ = null;
      }
      networking_ = null;
      if (networkingBuilder_ != null) {
        networkingBuilder_.dispose();
        networkingBuilder_ = null;
      }
      authorization_ = null;
      if (authorizationBuilder_ != null) {
        authorizationBuilder_.dispose();
        authorizationBuilder_ = null;
      }
      defaultMaxPodsPerNode_ = 0;
      endpoint_ = "";
      clusterCaCertificate_ = "";
      maintenancePolicy_ = null;
      if (maintenancePolicyBuilder_ != null) {
        maintenancePolicyBuilder_.dispose();
        maintenancePolicyBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.edgecontainer.v1.ResourcesProto
          .internal_static_google_cloud_edgecontainer_v1_Cluster_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.edgecontainer.v1.Cluster getDefaultInstanceForType() {
      return com.google.cloud.edgecontainer.v1.Cluster.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.edgecontainer.v1.Cluster build() {
      com.google.cloud.edgecontainer.v1.Cluster result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.edgecontainer.v1.Cluster buildPartial() {
      com.google.cloud.edgecontainer.v1.Cluster result =
          new com.google.cloud.edgecontainer.v1.Cluster(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.edgecontainer.v1.Cluster result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.fleet_ = fleetBuilder_ == null ? fleet_ : fleetBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.networking_ = networkingBuilder_ == null ? networking_ : networkingBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.authorization_ =
            authorizationBuilder_ == null ? authorization_ : authorizationBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.defaultMaxPodsPerNode_ = defaultMaxPodsPerNode_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.endpoint_ = endpoint_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.clusterCaCertificate_ = clusterCaCertificate_;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.maintenancePolicy_ =
            maintenancePolicyBuilder_ == null
                ? maintenancePolicy_
                : maintenancePolicyBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.edgecontainer.v1.Cluster) {
        return mergeFrom((com.google.cloud.edgecontainer.v1.Cluster) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.edgecontainer.v1.Cluster other) {
      if (other == com.google.cloud.edgecontainer.v1.Cluster.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00000008;
      if (other.hasFleet()) {
        mergeFleet(other.getFleet());
      }
      if (other.hasNetworking()) {
        mergeNetworking(other.getNetworking());
      }
      if (other.hasAuthorization()) {
        mergeAuthorization(other.getAuthorization());
      }
      if (other.getDefaultMaxPodsPerNode() != 0) {
        setDefaultMaxPodsPerNode(other.getDefaultMaxPodsPerNode());
      }
      if (!other.getEndpoint().isEmpty()) {
        endpoint_ = other.endpoint_;
        bitField0_ |= 0x00000100;
        onChanged();
      }
      if (!other.getClusterCaCertificate().isEmpty()) {
        clusterCaCertificate_ = other.clusterCaCertificate_;
        bitField0_ |= 0x00000200;
        onChanged();
      }
      if (other.hasMaintenancePolicy()) {
        mergeMaintenancePolicy(other.getMaintenancePolicy());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 50:
              {
                endpoint_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000100;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getNetworkingFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 58
            case 64:
              {
                defaultMaxPodsPerNode_ = input.readInt32();
                bitField0_ |= 0x00000080;
                break;
              } // case 64
            case 74:
              {
                input.readMessage(getAuthorizationFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 74
            case 82:
              {
                clusterCaCertificate_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000200;
                break;
              } // case 82
            case 90:
              {
                input.readMessage(getFleetFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 90
            case 98:
              {
                input.readMessage(
                    getMaintenancePolicyFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000400;
                break;
              } // case 98
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Required. The resource name of the cluster.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the cluster.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the cluster.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the cluster.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the cluster.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The time when the cluster was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the cluster was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the cluster was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the cluster was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the cluster was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the cluster was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000002);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the cluster was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the cluster was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the cluster was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The time when the cluster was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the cluster was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the cluster was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the cluster was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the cluster was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the cluster was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000004);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the cluster was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the cluster was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the cluster was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Labels associated with this resource.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * Labels associated with this resource.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * Labels associated with this resource.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Labels associated with this resource.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00000008);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Labels associated with this resource.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x00000008;
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Labels associated with this resource.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00000008;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Labels associated with this resource.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00000008;
      return this;
    }

    private com.google.cloud.edgecontainer.v1.Fleet fleet_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.edgecontainer.v1.Fleet,
            com.google.cloud.edgecontainer.v1.Fleet.Builder,
            com.google.cloud.edgecontainer.v1.FleetOrBuilder>
        fleetBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Fleet configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.edgecontainer.v1.Fleet fleet = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the fleet field is set.
     */
    public boolean hasFleet() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Fleet configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.edgecontainer.v1.Fleet fleet = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The fleet.
     */
    public com.google.cloud.edgecontainer.v1.Fleet getFleet() {
      if (fleetBuilder_ == null) {
        return fleet_ == null
            ? com.google.cloud.edgecontainer.v1.Fleet.getDefaultInstance()
            : fleet_;
      } else {
        return fleetBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Fleet configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.edgecontainer.v1.Fleet fleet = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setFleet(com.google.cloud.edgecontainer.v1.Fleet value) {
      if (fleetBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        fleet_ = value;
      } else {
        fleetBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Fleet configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.edgecontainer.v1.Fleet fleet = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setFleet(com.google.cloud.edgecontainer.v1.Fleet.Builder builderForValue) {
      if (fleetBuilder_ == null) {
        fleet_ = builderForValue.build();
      } else {
        fleetBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Fleet configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.edgecontainer.v1.Fleet fleet = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeFleet(com.google.cloud.edgecontainer.v1.Fleet value) {
      if (fleetBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && fleet_ != null
            && fleet_ != com.google.cloud.edgecontainer.v1.Fleet.getDefaultInstance()) {
          getFleetBuilder().mergeFrom(value);
        } else {
          fleet_ = value;
        }
      } else {
        fleetBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Fleet configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.edgecontainer.v1.Fleet fleet = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearFleet() {
      bitField0_ = (bitField0_ & ~0x00000010);
      fleet_ = null;
      if (fleetBuilder_ != null) {
        fleetBuilder_.dispose();
        fleetBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Fleet configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.edgecontainer.v1.Fleet fleet = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.edgecontainer.v1.Fleet.Builder getFleetBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getFleetFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Fleet configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.edgecontainer.v1.Fleet fleet = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.edgecontainer.v1.FleetOrBuilder getFleetOrBuilder() {
      if (fleetBuilder_ != null) {
        return fleetBuilder_.getMessageOrBuilder();
      } else {
        return fleet_ == null
            ? com.google.cloud.edgecontainer.v1.Fleet.getDefaultInstance()
            : fleet_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Fleet configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.edgecontainer.v1.Fleet fleet = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.edgecontainer.v1.Fleet,
            com.google.cloud.edgecontainer.v1.Fleet.Builder,
            com.google.cloud.edgecontainer.v1.FleetOrBuilder>
        getFleetFieldBuilder() {
      if (fleetBuilder_ == null) {
        fleetBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.edgecontainer.v1.Fleet,
                com.google.cloud.edgecontainer.v1.Fleet.Builder,
                com.google.cloud.edgecontainer.v1.FleetOrBuilder>(
                getFleet(), getParentForChildren(), isClean());
        fleet_ = null;
      }
      return fleetBuilder_;
    }

    private com.google.cloud.edgecontainer.v1.ClusterNetworking networking_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.edgecontainer.v1.ClusterNetworking,
            com.google.cloud.edgecontainer.v1.ClusterNetworking.Builder,
            com.google.cloud.edgecontainer.v1.ClusterNetworkingOrBuilder>
        networkingBuilder_;
    /**
     *
     *
     * <pre>
     * Required. Cluster-wide networking configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.edgecontainer.v1.ClusterNetworking networking = 7 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the networking field is set.
     */
    public boolean hasNetworking() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. Cluster-wide networking configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.edgecontainer.v1.ClusterNetworking networking = 7 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The networking.
     */
    public com.google.cloud.edgecontainer.v1.ClusterNetworking getNetworking() {
      if (networkingBuilder_ == null) {
        return networking_ == null
            ? com.google.cloud.edgecontainer.v1.ClusterNetworking.getDefaultInstance()
            : networking_;
      } else {
        return networkingBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Cluster-wide networking configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.edgecontainer.v1.ClusterNetworking networking = 7 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setNetworking(com.google.cloud.edgecontainer.v1.ClusterNetworking value) {
      if (networkingBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        networking_ = value;
      } else {
        networkingBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Cluster-wide networking configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.edgecontainer.v1.ClusterNetworking networking = 7 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setNetworking(
        com.google.cloud.edgecontainer.v1.ClusterNetworking.Builder builderForValue) {
      if (networkingBuilder_ == null) {
        networking_ = builderForValue.build();
      } else {
        networkingBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Cluster-wide networking configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.edgecontainer.v1.ClusterNetworking networking = 7 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeNetworking(com.google.cloud.edgecontainer.v1.ClusterNetworking value) {
      if (networkingBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && networking_ != null
            && networking_
                != com.google.cloud.edgecontainer.v1.ClusterNetworking.getDefaultInstance()) {
          getNetworkingBuilder().mergeFrom(value);
        } else {
          networking_ = value;
        }
      } else {
        networkingBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Cluster-wide networking configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.edgecontainer.v1.ClusterNetworking networking = 7 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearNetworking() {
      bitField0_ = (bitField0_ & ~0x00000020);
      networking_ = null;
      if (networkingBuilder_ != null) {
        networkingBuilder_.dispose();
        networkingBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Cluster-wide networking configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.edgecontainer.v1.ClusterNetworking networking = 7 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.edgecontainer.v1.ClusterNetworking.Builder getNetworkingBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getNetworkingFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. Cluster-wide networking configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.edgecontainer.v1.ClusterNetworking networking = 7 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.edgecontainer.v1.ClusterNetworkingOrBuilder getNetworkingOrBuilder() {
      if (networkingBuilder_ != null) {
        return networkingBuilder_.getMessageOrBuilder();
      } else {
        return networking_ == null
            ? com.google.cloud.edgecontainer.v1.ClusterNetworking.getDefaultInstance()
            : networking_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Cluster-wide networking configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.edgecontainer.v1.ClusterNetworking networking = 7 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.edgecontainer.v1.ClusterNetworking,
            com.google.cloud.edgecontainer.v1.ClusterNetworking.Builder,
            com.google.cloud.edgecontainer.v1.ClusterNetworkingOrBuilder>
        getNetworkingFieldBuilder() {
      if (networkingBuilder_ == null) {
        networkingBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.edgecontainer.v1.ClusterNetworking,
                com.google.cloud.edgecontainer.v1.ClusterNetworking.Builder,
                com.google.cloud.edgecontainer.v1.ClusterNetworkingOrBuilder>(
                getNetworking(), getParentForChildren(), isClean());
        networking_ = null;
      }
      return networkingBuilder_;
    }

    private com.google.cloud.edgecontainer.v1.Authorization authorization_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.edgecontainer.v1.Authorization,
            com.google.cloud.edgecontainer.v1.Authorization.Builder,
            com.google.cloud.edgecontainer.v1.AuthorizationOrBuilder>
        authorizationBuilder_;
    /**
     *
     *
     * <pre>
     * Required. Immutable. RBAC policy that will be applied and managed by GEC.
     * </pre>
     *
     * <code>
     * .google.cloud.edgecontainer.v1.Authorization authorization = 9 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return Whether the authorization field is set.
     */
    public boolean hasAuthorization() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. RBAC policy that will be applied and managed by GEC.
     * </pre>
     *
     * <code>
     * .google.cloud.edgecontainer.v1.Authorization authorization = 9 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The authorization.
     */
    public com.google.cloud.edgecontainer.v1.Authorization getAuthorization() {
      if (authorizationBuilder_ == null) {
        return authorization_ == null
            ? com.google.cloud.edgecontainer.v1.Authorization.getDefaultInstance()
            : authorization_;
      } else {
        return authorizationBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. RBAC policy that will be applied and managed by GEC.
     * </pre>
     *
     * <code>
     * .google.cloud.edgecontainer.v1.Authorization authorization = 9 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder setAuthorization(com.google.cloud.edgecontainer.v1.Authorization value) {
      if (authorizationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        authorization_ = value;
      } else {
        authorizationBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. RBAC policy that will be applied and managed by GEC.
     * </pre>
     *
     * <code>
     * .google.cloud.edgecontainer.v1.Authorization authorization = 9 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder setAuthorization(
        com.google.cloud.edgecontainer.v1.Authorization.Builder builderForValue) {
      if (authorizationBuilder_ == null) {
        authorization_ = builderForValue.build();
      } else {
        authorizationBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. RBAC policy that will be applied and managed by GEC.
     * </pre>
     *
     * <code>
     * .google.cloud.edgecontainer.v1.Authorization authorization = 9 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder mergeAuthorization(com.google.cloud.edgecontainer.v1.Authorization value) {
      if (authorizationBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && authorization_ != null
            && authorization_
                != com.google.cloud.edgecontainer.v1.Authorization.getDefaultInstance()) {
          getAuthorizationBuilder().mergeFrom(value);
        } else {
          authorization_ = value;
        }
      } else {
        authorizationBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. RBAC policy that will be applied and managed by GEC.
     * </pre>
     *
     * <code>
     * .google.cloud.edgecontainer.v1.Authorization authorization = 9 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder clearAuthorization() {
      bitField0_ = (bitField0_ & ~0x00000040);
      authorization_ = null;
      if (authorizationBuilder_ != null) {
        authorizationBuilder_.dispose();
        authorizationBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. RBAC policy that will be applied and managed by GEC.
     * </pre>
     *
     * <code>
     * .google.cloud.edgecontainer.v1.Authorization authorization = 9 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public com.google.cloud.edgecontainer.v1.Authorization.Builder getAuthorizationBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getAuthorizationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. RBAC policy that will be applied and managed by GEC.
     * </pre>
     *
     * <code>
     * .google.cloud.edgecontainer.v1.Authorization authorization = 9 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public com.google.cloud.edgecontainer.v1.AuthorizationOrBuilder getAuthorizationOrBuilder() {
      if (authorizationBuilder_ != null) {
        return authorizationBuilder_.getMessageOrBuilder();
      } else {
        return authorization_ == null
            ? com.google.cloud.edgecontainer.v1.Authorization.getDefaultInstance()
            : authorization_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. RBAC policy that will be applied and managed by GEC.
     * </pre>
     *
     * <code>
     * .google.cloud.edgecontainer.v1.Authorization authorization = 9 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.edgecontainer.v1.Authorization,
            com.google.cloud.edgecontainer.v1.Authorization.Builder,
            com.google.cloud.edgecontainer.v1.AuthorizationOrBuilder>
        getAuthorizationFieldBuilder() {
      if (authorizationBuilder_ == null) {
        authorizationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.edgecontainer.v1.Authorization,
                com.google.cloud.edgecontainer.v1.Authorization.Builder,
                com.google.cloud.edgecontainer.v1.AuthorizationOrBuilder>(
                getAuthorization(), getParentForChildren(), isClean());
        authorization_ = null;
      }
      return authorizationBuilder_;
    }

    private int defaultMaxPodsPerNode_;
    /**
     *
     *
     * <pre>
     * Optional. The default maximum number of pods per node used if a maximum value is not
     * specified explicitly for a node pool in this cluster. If unspecified, the
     * Kubernetes default value will be used.
     * </pre>
     *
     * <code>int32 default_max_pods_per_node = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The defaultMaxPodsPerNode.
     */
    @java.lang.Override
    public int getDefaultMaxPodsPerNode() {
      return defaultMaxPodsPerNode_;
    }
    /**
     *
     *
     * <pre>
     * Optional. The default maximum number of pods per node used if a maximum value is not
     * specified explicitly for a node pool in this cluster. If unspecified, the
     * Kubernetes default value will be used.
     * </pre>
     *
     * <code>int32 default_max_pods_per_node = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The defaultMaxPodsPerNode to set.
     * @return This builder for chaining.
     */
    public Builder setDefaultMaxPodsPerNode(int value) {

      defaultMaxPodsPerNode_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The default maximum number of pods per node used if a maximum value is not
     * specified explicitly for a node pool in this cluster. If unspecified, the
     * Kubernetes default value will be used.
     * </pre>
     *
     * <code>int32 default_max_pods_per_node = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDefaultMaxPodsPerNode() {
      bitField0_ = (bitField0_ & ~0x00000080);
      defaultMaxPodsPerNode_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object endpoint_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The IP address of the Kubernetes API server.
     * </pre>
     *
     * <code>string endpoint = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The endpoint.
     */
    public java.lang.String getEndpoint() {
      java.lang.Object ref = endpoint_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        endpoint_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The IP address of the Kubernetes API server.
     * </pre>
     *
     * <code>string endpoint = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for endpoint.
     */
    public com.google.protobuf.ByteString getEndpointBytes() {
      java.lang.Object ref = endpoint_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        endpoint_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The IP address of the Kubernetes API server.
     * </pre>
     *
     * <code>string endpoint = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The endpoint to set.
     * @return This builder for chaining.
     */
    public Builder setEndpoint(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      endpoint_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The IP address of the Kubernetes API server.
     * </pre>
     *
     * <code>string endpoint = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEndpoint() {
      endpoint_ = getDefaultInstance().getEndpoint();
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The IP address of the Kubernetes API server.
     * </pre>
     *
     * <code>string endpoint = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for endpoint to set.
     * @return This builder for chaining.
     */
    public Builder setEndpointBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      endpoint_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    private java.lang.Object clusterCaCertificate_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The PEM-encoded public certificate of the cluster's CA.
     * </pre>
     *
     * <code>string cluster_ca_certificate = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The clusterCaCertificate.
     */
    public java.lang.String getClusterCaCertificate() {
      java.lang.Object ref = clusterCaCertificate_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        clusterCaCertificate_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The PEM-encoded public certificate of the cluster's CA.
     * </pre>
     *
     * <code>string cluster_ca_certificate = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for clusterCaCertificate.
     */
    public com.google.protobuf.ByteString getClusterCaCertificateBytes() {
      java.lang.Object ref = clusterCaCertificate_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        clusterCaCertificate_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The PEM-encoded public certificate of the cluster's CA.
     * </pre>
     *
     * <code>string cluster_ca_certificate = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The clusterCaCertificate to set.
     * @return This builder for chaining.
     */
    public Builder setClusterCaCertificate(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      clusterCaCertificate_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The PEM-encoded public certificate of the cluster's CA.
     * </pre>
     *
     * <code>string cluster_ca_certificate = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearClusterCaCertificate() {
      clusterCaCertificate_ = getDefaultInstance().getClusterCaCertificate();
      bitField0_ = (bitField0_ & ~0x00000200);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The PEM-encoded public certificate of the cluster's CA.
     * </pre>
     *
     * <code>string cluster_ca_certificate = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for clusterCaCertificate to set.
     * @return This builder for chaining.
     */
    public Builder setClusterCaCertificateBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      clusterCaCertificate_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    private com.google.cloud.edgecontainer.v1.MaintenancePolicy maintenancePolicy_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.edgecontainer.v1.MaintenancePolicy,
            com.google.cloud.edgecontainer.v1.MaintenancePolicy.Builder,
            com.google.cloud.edgecontainer.v1.MaintenancePolicyOrBuilder>
        maintenancePolicyBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Cluster-wide maintenance policy configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.edgecontainer.v1.MaintenancePolicy maintenance_policy = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the maintenancePolicy field is set.
     */
    public boolean hasMaintenancePolicy() {
      return ((bitField0_ & 0x00000400) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Cluster-wide maintenance policy configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.edgecontainer.v1.MaintenancePolicy maintenance_policy = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The maintenancePolicy.
     */
    public com.google.cloud.edgecontainer.v1.MaintenancePolicy getMaintenancePolicy() {
      if (maintenancePolicyBuilder_ == null) {
        return maintenancePolicy_ == null
            ? com.google.cloud.edgecontainer.v1.MaintenancePolicy.getDefaultInstance()
            : maintenancePolicy_;
      } else {
        return maintenancePolicyBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Cluster-wide maintenance policy configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.edgecontainer.v1.MaintenancePolicy maintenance_policy = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setMaintenancePolicy(com.google.cloud.edgecontainer.v1.MaintenancePolicy value) {
      if (maintenancePolicyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        maintenancePolicy_ = value;
      } else {
        maintenancePolicyBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Cluster-wide maintenance policy configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.edgecontainer.v1.MaintenancePolicy maintenance_policy = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setMaintenancePolicy(
        com.google.cloud.edgecontainer.v1.MaintenancePolicy.Builder builderForValue) {
      if (maintenancePolicyBuilder_ == null) {
        maintenancePolicy_ = builderForValue.build();
      } else {
        maintenancePolicyBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Cluster-wide maintenance policy configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.edgecontainer.v1.MaintenancePolicy maintenance_policy = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeMaintenancePolicy(
        com.google.cloud.edgecontainer.v1.MaintenancePolicy value) {
      if (maintenancePolicyBuilder_ == null) {
        if (((bitField0_ & 0x00000400) != 0)
            && maintenancePolicy_ != null
            && maintenancePolicy_
                != com.google.cloud.edgecontainer.v1.MaintenancePolicy.getDefaultInstance()) {
          getMaintenancePolicyBuilder().mergeFrom(value);
        } else {
          maintenancePolicy_ = value;
        }
      } else {
        maintenancePolicyBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Cluster-wide maintenance policy configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.edgecontainer.v1.MaintenancePolicy maintenance_policy = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearMaintenancePolicy() {
      bitField0_ = (bitField0_ & ~0x00000400);
      maintenancePolicy_ = null;
      if (maintenancePolicyBuilder_ != null) {
        maintenancePolicyBuilder_.dispose();
        maintenancePolicyBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Cluster-wide maintenance policy configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.edgecontainer.v1.MaintenancePolicy maintenance_policy = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.edgecontainer.v1.MaintenancePolicy.Builder
        getMaintenancePolicyBuilder() {
      bitField0_ |= 0x00000400;
      onChanged();
      return getMaintenancePolicyFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Cluster-wide maintenance policy configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.edgecontainer.v1.MaintenancePolicy maintenance_policy = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.edgecontainer.v1.MaintenancePolicyOrBuilder
        getMaintenancePolicyOrBuilder() {
      if (maintenancePolicyBuilder_ != null) {
        return maintenancePolicyBuilder_.getMessageOrBuilder();
      } else {
        return maintenancePolicy_ == null
            ? com.google.cloud.edgecontainer.v1.MaintenancePolicy.getDefaultInstance()
            : maintenancePolicy_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Cluster-wide maintenance policy configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.edgecontainer.v1.MaintenancePolicy maintenance_policy = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.edgecontainer.v1.MaintenancePolicy,
            com.google.cloud.edgecontainer.v1.MaintenancePolicy.Builder,
            com.google.cloud.edgecontainer.v1.MaintenancePolicyOrBuilder>
        getMaintenancePolicyFieldBuilder() {
      if (maintenancePolicyBuilder_ == null) {
        maintenancePolicyBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.edgecontainer.v1.MaintenancePolicy,
                com.google.cloud.edgecontainer.v1.MaintenancePolicy.Builder,
                com.google.cloud.edgecontainer.v1.MaintenancePolicyOrBuilder>(
                getMaintenancePolicy(), getParentForChildren(), isClean());
        maintenancePolicy_ = null;
      }
      return maintenancePolicyBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.edgecontainer.v1.Cluster)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.edgecontainer.v1.Cluster)
  private static final com.google.cloud.edgecontainer.v1.Cluster DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.edgecontainer.v1.Cluster();
  }

  public static com.google.cloud.edgecontainer.v1.Cluster getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Cluster> PARSER =
      new com.google.protobuf.AbstractParser<Cluster>() {
        @java.lang.Override
        public Cluster parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Cluster> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Cluster> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.edgecontainer.v1.Cluster getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
