/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/edgecontainer/v1/resources.proto

package com.google.cloud.edgecontainer.v1;

/**
 *
 *
 * <pre>
 * Cluster-wide networking configuration.
 * </pre>
 *
 * Protobuf type {@code google.cloud.edgecontainer.v1.ClusterNetworking}
 */
public final class ClusterNetworking extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.edgecontainer.v1.ClusterNetworking)
    ClusterNetworkingOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ClusterNetworking.newBuilder() to construct.
  private ClusterNetworking(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ClusterNetworking() {
    clusterIpv4CidrBlocks_ = com.google.protobuf.LazyStringArrayList.emptyList();
    servicesIpv4CidrBlocks_ = com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ClusterNetworking();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.edgecontainer.v1.ResourcesProto
        .internal_static_google_cloud_edgecontainer_v1_ClusterNetworking_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.edgecontainer.v1.ResourcesProto
        .internal_static_google_cloud_edgecontainer_v1_ClusterNetworking_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.edgecontainer.v1.ClusterNetworking.class,
            com.google.cloud.edgecontainer.v1.ClusterNetworking.Builder.class);
  }

  public static final int CLUSTER_IPV4_CIDR_BLOCKS_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList clusterIpv4CidrBlocks_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Required. All pods in the cluster are assigned an RFC1918 IPv4 address from these
   * blocks. Only a single block is supported. This field cannot be changed
   * after creation.
   * </pre>
   *
   * <code>repeated string cluster_ipv4_cidr_blocks = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return A list containing the clusterIpv4CidrBlocks.
   */
  public com.google.protobuf.ProtocolStringList getClusterIpv4CidrBlocksList() {
    return clusterIpv4CidrBlocks_;
  }
  /**
   *
   *
   * <pre>
   * Required. All pods in the cluster are assigned an RFC1918 IPv4 address from these
   * blocks. Only a single block is supported. This field cannot be changed
   * after creation.
   * </pre>
   *
   * <code>repeated string cluster_ipv4_cidr_blocks = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The count of clusterIpv4CidrBlocks.
   */
  public int getClusterIpv4CidrBlocksCount() {
    return clusterIpv4CidrBlocks_.size();
  }
  /**
   *
   *
   * <pre>
   * Required. All pods in the cluster are assigned an RFC1918 IPv4 address from these
   * blocks. Only a single block is supported. This field cannot be changed
   * after creation.
   * </pre>
   *
   * <code>repeated string cluster_ipv4_cidr_blocks = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @param index The index of the element to return.
   * @return The clusterIpv4CidrBlocks at the given index.
   */
  public java.lang.String getClusterIpv4CidrBlocks(int index) {
    return clusterIpv4CidrBlocks_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Required. All pods in the cluster are assigned an RFC1918 IPv4 address from these
   * blocks. Only a single block is supported. This field cannot be changed
   * after creation.
   * </pre>
   *
   * <code>repeated string cluster_ipv4_cidr_blocks = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the clusterIpv4CidrBlocks at the given index.
   */
  public com.google.protobuf.ByteString getClusterIpv4CidrBlocksBytes(int index) {
    return clusterIpv4CidrBlocks_.getByteString(index);
  }

  public static final int SERVICES_IPV4_CIDR_BLOCKS_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList servicesIpv4CidrBlocks_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Required. All services in the cluster are assigned an RFC1918 IPv4 address from these
   * blocks. Only a single block is supported. This field cannot be changed
   * after creation.
   * </pre>
   *
   * <code>repeated string services_ipv4_cidr_blocks = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return A list containing the servicesIpv4CidrBlocks.
   */
  public com.google.protobuf.ProtocolStringList getServicesIpv4CidrBlocksList() {
    return servicesIpv4CidrBlocks_;
  }
  /**
   *
   *
   * <pre>
   * Required. All services in the cluster are assigned an RFC1918 IPv4 address from these
   * blocks. Only a single block is supported. This field cannot be changed
   * after creation.
   * </pre>
   *
   * <code>repeated string services_ipv4_cidr_blocks = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The count of servicesIpv4CidrBlocks.
   */
  public int getServicesIpv4CidrBlocksCount() {
    return servicesIpv4CidrBlocks_.size();
  }
  /**
   *
   *
   * <pre>
   * Required. All services in the cluster are assigned an RFC1918 IPv4 address from these
   * blocks. Only a single block is supported. This field cannot be changed
   * after creation.
   * </pre>
   *
   * <code>repeated string services_ipv4_cidr_blocks = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @param index The index of the element to return.
   * @return The servicesIpv4CidrBlocks at the given index.
   */
  public java.lang.String getServicesIpv4CidrBlocks(int index) {
    return servicesIpv4CidrBlocks_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Required. All services in the cluster are assigned an RFC1918 IPv4 address from these
   * blocks. Only a single block is supported. This field cannot be changed
   * after creation.
   * </pre>
   *
   * <code>repeated string services_ipv4_cidr_blocks = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the servicesIpv4CidrBlocks at the given index.
   */
  public com.google.protobuf.ByteString getServicesIpv4CidrBlocksBytes(int index) {
    return servicesIpv4CidrBlocks_.getByteString(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < clusterIpv4CidrBlocks_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 1, clusterIpv4CidrBlocks_.getRaw(i));
    }
    for (int i = 0; i < servicesIpv4CidrBlocks_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 2, servicesIpv4CidrBlocks_.getRaw(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    {
      int dataSize = 0;
      for (int i = 0; i < clusterIpv4CidrBlocks_.size(); i++) {
        dataSize += computeStringSizeNoTag(clusterIpv4CidrBlocks_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getClusterIpv4CidrBlocksList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < servicesIpv4CidrBlocks_.size(); i++) {
        dataSize += computeStringSizeNoTag(servicesIpv4CidrBlocks_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getServicesIpv4CidrBlocksList().size();
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.edgecontainer.v1.ClusterNetworking)) {
      return super.equals(obj);
    }
    com.google.cloud.edgecontainer.v1.ClusterNetworking other =
        (com.google.cloud.edgecontainer.v1.ClusterNetworking) obj;

    if (!getClusterIpv4CidrBlocksList().equals(other.getClusterIpv4CidrBlocksList())) return false;
    if (!getServicesIpv4CidrBlocksList().equals(other.getServicesIpv4CidrBlocksList()))
      return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getClusterIpv4CidrBlocksCount() > 0) {
      hash = (37 * hash) + CLUSTER_IPV4_CIDR_BLOCKS_FIELD_NUMBER;
      hash = (53 * hash) + getClusterIpv4CidrBlocksList().hashCode();
    }
    if (getServicesIpv4CidrBlocksCount() > 0) {
      hash = (37 * hash) + SERVICES_IPV4_CIDR_BLOCKS_FIELD_NUMBER;
      hash = (53 * hash) + getServicesIpv4CidrBlocksList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.edgecontainer.v1.ClusterNetworking parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.edgecontainer.v1.ClusterNetworking parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.edgecontainer.v1.ClusterNetworking parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.edgecontainer.v1.ClusterNetworking parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.edgecontainer.v1.ClusterNetworking parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.edgecontainer.v1.ClusterNetworking parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.edgecontainer.v1.ClusterNetworking parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.edgecontainer.v1.ClusterNetworking parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.edgecontainer.v1.ClusterNetworking parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.edgecontainer.v1.ClusterNetworking parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.edgecontainer.v1.ClusterNetworking parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.edgecontainer.v1.ClusterNetworking parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.edgecontainer.v1.ClusterNetworking prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Cluster-wide networking configuration.
   * </pre>
   *
   * Protobuf type {@code google.cloud.edgecontainer.v1.ClusterNetworking}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.edgecontainer.v1.ClusterNetworking)
      com.google.cloud.edgecontainer.v1.ClusterNetworkingOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.edgecontainer.v1.ResourcesProto
          .internal_static_google_cloud_edgecontainer_v1_ClusterNetworking_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.edgecontainer.v1.ResourcesProto
          .internal_static_google_cloud_edgecontainer_v1_ClusterNetworking_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.edgecontainer.v1.ClusterNetworking.class,
              com.google.cloud.edgecontainer.v1.ClusterNetworking.Builder.class);
    }

    // Construct using com.google.cloud.edgecontainer.v1.ClusterNetworking.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      clusterIpv4CidrBlocks_ = com.google.protobuf.LazyStringArrayList.emptyList();
      servicesIpv4CidrBlocks_ = com.google.protobuf.LazyStringArrayList.emptyList();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.edgecontainer.v1.ResourcesProto
          .internal_static_google_cloud_edgecontainer_v1_ClusterNetworking_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.edgecontainer.v1.ClusterNetworking getDefaultInstanceForType() {
      return com.google.cloud.edgecontainer.v1.ClusterNetworking.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.edgecontainer.v1.ClusterNetworking build() {
      com.google.cloud.edgecontainer.v1.ClusterNetworking result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.edgecontainer.v1.ClusterNetworking buildPartial() {
      com.google.cloud.edgecontainer.v1.ClusterNetworking result =
          new com.google.cloud.edgecontainer.v1.ClusterNetworking(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.edgecontainer.v1.ClusterNetworking result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        clusterIpv4CidrBlocks_.makeImmutable();
        result.clusterIpv4CidrBlocks_ = clusterIpv4CidrBlocks_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        servicesIpv4CidrBlocks_.makeImmutable();
        result.servicesIpv4CidrBlocks_ = servicesIpv4CidrBlocks_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.edgecontainer.v1.ClusterNetworking) {
        return mergeFrom((com.google.cloud.edgecontainer.v1.ClusterNetworking) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.edgecontainer.v1.ClusterNetworking other) {
      if (other == com.google.cloud.edgecontainer.v1.ClusterNetworking.getDefaultInstance())
        return this;
      if (!other.clusterIpv4CidrBlocks_.isEmpty()) {
        if (clusterIpv4CidrBlocks_.isEmpty()) {
          clusterIpv4CidrBlocks_ = other.clusterIpv4CidrBlocks_;
          bitField0_ |= 0x00000001;
        } else {
          ensureClusterIpv4CidrBlocksIsMutable();
          clusterIpv4CidrBlocks_.addAll(other.clusterIpv4CidrBlocks_);
        }
        onChanged();
      }
      if (!other.servicesIpv4CidrBlocks_.isEmpty()) {
        if (servicesIpv4CidrBlocks_.isEmpty()) {
          servicesIpv4CidrBlocks_ = other.servicesIpv4CidrBlocks_;
          bitField0_ |= 0x00000002;
        } else {
          ensureServicesIpv4CidrBlocksIsMutable();
          servicesIpv4CidrBlocks_.addAll(other.servicesIpv4CidrBlocks_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureClusterIpv4CidrBlocksIsMutable();
                clusterIpv4CidrBlocks_.add(s);
                break;
              } // case 10
            case 18:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureServicesIpv4CidrBlocksIsMutable();
                servicesIpv4CidrBlocks_.add(s);
                break;
              } // case 18
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.LazyStringArrayList clusterIpv4CidrBlocks_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureClusterIpv4CidrBlocksIsMutable() {
      if (!clusterIpv4CidrBlocks_.isModifiable()) {
        clusterIpv4CidrBlocks_ =
            new com.google.protobuf.LazyStringArrayList(clusterIpv4CidrBlocks_);
      }
      bitField0_ |= 0x00000001;
    }
    /**
     *
     *
     * <pre>
     * Required. All pods in the cluster are assigned an RFC1918 IPv4 address from these
     * blocks. Only a single block is supported. This field cannot be changed
     * after creation.
     * </pre>
     *
     * <code>repeated string cluster_ipv4_cidr_blocks = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return A list containing the clusterIpv4CidrBlocks.
     */
    public com.google.protobuf.ProtocolStringList getClusterIpv4CidrBlocksList() {
      clusterIpv4CidrBlocks_.makeImmutable();
      return clusterIpv4CidrBlocks_;
    }
    /**
     *
     *
     * <pre>
     * Required. All pods in the cluster are assigned an RFC1918 IPv4 address from these
     * blocks. Only a single block is supported. This field cannot be changed
     * after creation.
     * </pre>
     *
     * <code>repeated string cluster_ipv4_cidr_blocks = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The count of clusterIpv4CidrBlocks.
     */
    public int getClusterIpv4CidrBlocksCount() {
      return clusterIpv4CidrBlocks_.size();
    }
    /**
     *
     *
     * <pre>
     * Required. All pods in the cluster are assigned an RFC1918 IPv4 address from these
     * blocks. Only a single block is supported. This field cannot be changed
     * after creation.
     * </pre>
     *
     * <code>repeated string cluster_ipv4_cidr_blocks = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param index The index of the element to return.
     * @return The clusterIpv4CidrBlocks at the given index.
     */
    public java.lang.String getClusterIpv4CidrBlocks(int index) {
      return clusterIpv4CidrBlocks_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Required. All pods in the cluster are assigned an RFC1918 IPv4 address from these
     * blocks. Only a single block is supported. This field cannot be changed
     * after creation.
     * </pre>
     *
     * <code>repeated string cluster_ipv4_cidr_blocks = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the clusterIpv4CidrBlocks at the given index.
     */
    public com.google.protobuf.ByteString getClusterIpv4CidrBlocksBytes(int index) {
      return clusterIpv4CidrBlocks_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Required. All pods in the cluster are assigned an RFC1918 IPv4 address from these
     * blocks. Only a single block is supported. This field cannot be changed
     * after creation.
     * </pre>
     *
     * <code>repeated string cluster_ipv4_cidr_blocks = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The clusterIpv4CidrBlocks to set.
     * @return This builder for chaining.
     */
    public Builder setClusterIpv4CidrBlocks(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureClusterIpv4CidrBlocksIsMutable();
      clusterIpv4CidrBlocks_.set(index, value);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. All pods in the cluster are assigned an RFC1918 IPv4 address from these
     * blocks. Only a single block is supported. This field cannot be changed
     * after creation.
     * </pre>
     *
     * <code>repeated string cluster_ipv4_cidr_blocks = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The clusterIpv4CidrBlocks to add.
     * @return This builder for chaining.
     */
    public Builder addClusterIpv4CidrBlocks(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureClusterIpv4CidrBlocksIsMutable();
      clusterIpv4CidrBlocks_.add(value);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. All pods in the cluster are assigned an RFC1918 IPv4 address from these
     * blocks. Only a single block is supported. This field cannot be changed
     * after creation.
     * </pre>
     *
     * <code>repeated string cluster_ipv4_cidr_blocks = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param values The clusterIpv4CidrBlocks to add.
     * @return This builder for chaining.
     */
    public Builder addAllClusterIpv4CidrBlocks(java.lang.Iterable<java.lang.String> values) {
      ensureClusterIpv4CidrBlocksIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, clusterIpv4CidrBlocks_);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. All pods in the cluster are assigned an RFC1918 IPv4 address from these
     * blocks. Only a single block is supported. This field cannot be changed
     * after creation.
     * </pre>
     *
     * <code>repeated string cluster_ipv4_cidr_blocks = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearClusterIpv4CidrBlocks() {
      clusterIpv4CidrBlocks_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000001);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. All pods in the cluster are assigned an RFC1918 IPv4 address from these
     * blocks. Only a single block is supported. This field cannot be changed
     * after creation.
     * </pre>
     *
     * <code>repeated string cluster_ipv4_cidr_blocks = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The bytes of the clusterIpv4CidrBlocks to add.
     * @return This builder for chaining.
     */
    public Builder addClusterIpv4CidrBlocksBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureClusterIpv4CidrBlocksIsMutable();
      clusterIpv4CidrBlocks_.add(value);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList servicesIpv4CidrBlocks_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureServicesIpv4CidrBlocksIsMutable() {
      if (!servicesIpv4CidrBlocks_.isModifiable()) {
        servicesIpv4CidrBlocks_ =
            new com.google.protobuf.LazyStringArrayList(servicesIpv4CidrBlocks_);
      }
      bitField0_ |= 0x00000002;
    }
    /**
     *
     *
     * <pre>
     * Required. All services in the cluster are assigned an RFC1918 IPv4 address from these
     * blocks. Only a single block is supported. This field cannot be changed
     * after creation.
     * </pre>
     *
     * <code>
     * repeated string services_ipv4_cidr_blocks = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return A list containing the servicesIpv4CidrBlocks.
     */
    public com.google.protobuf.ProtocolStringList getServicesIpv4CidrBlocksList() {
      servicesIpv4CidrBlocks_.makeImmutable();
      return servicesIpv4CidrBlocks_;
    }
    /**
     *
     *
     * <pre>
     * Required. All services in the cluster are assigned an RFC1918 IPv4 address from these
     * blocks. Only a single block is supported. This field cannot be changed
     * after creation.
     * </pre>
     *
     * <code>
     * repeated string services_ipv4_cidr_blocks = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The count of servicesIpv4CidrBlocks.
     */
    public int getServicesIpv4CidrBlocksCount() {
      return servicesIpv4CidrBlocks_.size();
    }
    /**
     *
     *
     * <pre>
     * Required. All services in the cluster are assigned an RFC1918 IPv4 address from these
     * blocks. Only a single block is supported. This field cannot be changed
     * after creation.
     * </pre>
     *
     * <code>
     * repeated string services_ipv4_cidr_blocks = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param index The index of the element to return.
     * @return The servicesIpv4CidrBlocks at the given index.
     */
    public java.lang.String getServicesIpv4CidrBlocks(int index) {
      return servicesIpv4CidrBlocks_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Required. All services in the cluster are assigned an RFC1918 IPv4 address from these
     * blocks. Only a single block is supported. This field cannot be changed
     * after creation.
     * </pre>
     *
     * <code>
     * repeated string services_ipv4_cidr_blocks = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the servicesIpv4CidrBlocks at the given index.
     */
    public com.google.protobuf.ByteString getServicesIpv4CidrBlocksBytes(int index) {
      return servicesIpv4CidrBlocks_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Required. All services in the cluster are assigned an RFC1918 IPv4 address from these
     * blocks. Only a single block is supported. This field cannot be changed
     * after creation.
     * </pre>
     *
     * <code>
     * repeated string services_ipv4_cidr_blocks = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The servicesIpv4CidrBlocks to set.
     * @return This builder for chaining.
     */
    public Builder setServicesIpv4CidrBlocks(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureServicesIpv4CidrBlocksIsMutable();
      servicesIpv4CidrBlocks_.set(index, value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. All services in the cluster are assigned an RFC1918 IPv4 address from these
     * blocks. Only a single block is supported. This field cannot be changed
     * after creation.
     * </pre>
     *
     * <code>
     * repeated string services_ipv4_cidr_blocks = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The servicesIpv4CidrBlocks to add.
     * @return This builder for chaining.
     */
    public Builder addServicesIpv4CidrBlocks(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureServicesIpv4CidrBlocksIsMutable();
      servicesIpv4CidrBlocks_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. All services in the cluster are assigned an RFC1918 IPv4 address from these
     * blocks. Only a single block is supported. This field cannot be changed
     * after creation.
     * </pre>
     *
     * <code>
     * repeated string services_ipv4_cidr_blocks = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param values The servicesIpv4CidrBlocks to add.
     * @return This builder for chaining.
     */
    public Builder addAllServicesIpv4CidrBlocks(java.lang.Iterable<java.lang.String> values) {
      ensureServicesIpv4CidrBlocksIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, servicesIpv4CidrBlocks_);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. All services in the cluster are assigned an RFC1918 IPv4 address from these
     * blocks. Only a single block is supported. This field cannot be changed
     * after creation.
     * </pre>
     *
     * <code>
     * repeated string services_ipv4_cidr_blocks = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearServicesIpv4CidrBlocks() {
      servicesIpv4CidrBlocks_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000002);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. All services in the cluster are assigned an RFC1918 IPv4 address from these
     * blocks. Only a single block is supported. This field cannot be changed
     * after creation.
     * </pre>
     *
     * <code>
     * repeated string services_ipv4_cidr_blocks = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The bytes of the servicesIpv4CidrBlocks to add.
     * @return This builder for chaining.
     */
    public Builder addServicesIpv4CidrBlocksBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureServicesIpv4CidrBlocksIsMutable();
      servicesIpv4CidrBlocks_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.edgecontainer.v1.ClusterNetworking)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.edgecontainer.v1.ClusterNetworking)
  private static final com.google.cloud.edgecontainer.v1.ClusterNetworking DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.edgecontainer.v1.ClusterNetworking();
  }

  public static com.google.cloud.edgecontainer.v1.ClusterNetworking getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ClusterNetworking> PARSER =
      new com.google.protobuf.AbstractParser<ClusterNetworking>() {
        @java.lang.Override
        public ClusterNetworking parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ClusterNetworking> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ClusterNetworking> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.edgecontainer.v1.ClusterNetworking getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
