/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/edgecontainer/v1/resources.proto

package com.google.cloud.edgecontainer.v1;

/**
 *
 *
 * <pre>
 * A set of Kubernetes nodes in a cluster with common configuration and
 * specification.
 * </pre>
 *
 * Protobuf type {@code google.cloud.edgecontainer.v1.NodePool}
 */
public final class NodePool extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.edgecontainer.v1.NodePool)
    NodePoolOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use NodePool.newBuilder() to construct.
  private NodePool(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private NodePool() {
    name_ = "";
    nodeLocation_ = "";
    machineFilter_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new NodePool();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.edgecontainer.v1.ResourcesProto
        .internal_static_google_cloud_edgecontainer_v1_NodePool_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 4:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.edgecontainer.v1.ResourcesProto
        .internal_static_google_cloud_edgecontainer_v1_NodePool_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.edgecontainer.v1.NodePool.class,
            com.google.cloud.edgecontainer.v1.NodePool.Builder.class);
  }

  public interface LocalDiskEncryptionOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.edgecontainer.v1.NodePool.LocalDiskEncryption)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Immutable. The Cloud KMS CryptoKey e.g.
     * projects/{project}/locations/{location}/keyRings/{keyRing}/cryptoKeys/{cryptoKey}
     * to use for protecting node local disks. If not specified, a
     * Google-managed key will be used instead.
     * </pre>
     *
     * <code>
     * string kms_key = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The kmsKey.
     */
    java.lang.String getKmsKey();
    /**
     *
     *
     * <pre>
     * Immutable. The Cloud KMS CryptoKey e.g.
     * projects/{project}/locations/{location}/keyRings/{keyRing}/cryptoKeys/{cryptoKey}
     * to use for protecting node local disks. If not specified, a
     * Google-managed key will be used instead.
     * </pre>
     *
     * <code>
     * string kms_key = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for kmsKey.
     */
    com.google.protobuf.ByteString getKmsKeyBytes();

    /**
     *
     *
     * <pre>
     * Output only. The Cloud KMS CryptoKeyVersion currently in use for protecting node local
     * disks. Only applicable if kms_key is set.
     * </pre>
     *
     * <code>
     * string kms_key_active_version = 2 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The kmsKeyActiveVersion.
     */
    java.lang.String getKmsKeyActiveVersion();
    /**
     *
     *
     * <pre>
     * Output only. The Cloud KMS CryptoKeyVersion currently in use for protecting node local
     * disks. Only applicable if kms_key is set.
     * </pre>
     *
     * <code>
     * string kms_key_active_version = 2 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for kmsKeyActiveVersion.
     */
    com.google.protobuf.ByteString getKmsKeyActiveVersionBytes();

    /**
     *
     *
     * <pre>
     * Output only. Availability of the Cloud KMS CryptoKey. If not `KEY_AVAILABLE`, then
     * nodes may go offline as they cannot access their local data. This can be
     * caused by a lack of permissions to use the key, or if the key is disabled
     * or deleted.
     * </pre>
     *
     * <code>
     * .google.cloud.edgecontainer.v1.KmsKeyState kms_key_state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for kmsKeyState.
     */
    int getKmsKeyStateValue();
    /**
     *
     *
     * <pre>
     * Output only. Availability of the Cloud KMS CryptoKey. If not `KEY_AVAILABLE`, then
     * nodes may go offline as they cannot access their local data. This can be
     * caused by a lack of permissions to use the key, or if the key is disabled
     * or deleted.
     * </pre>
     *
     * <code>
     * .google.cloud.edgecontainer.v1.KmsKeyState kms_key_state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The kmsKeyState.
     */
    com.google.cloud.edgecontainer.v1.KmsKeyState getKmsKeyState();

    /**
     *
     *
     * <pre>
     * Output only. Error status returned by Cloud KMS when using this key. This field may be
     * populated only if `kms_key_state` is not `KMS_KEY_STATE_KEY_AVAILABLE`.
     * If populated, this field contains the error status reported by Cloud KMS.
     * </pre>
     *
     * <code>.google.rpc.Status kms_status = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return Whether the kmsStatus field is set.
     */
    boolean hasKmsStatus();
    /**
     *
     *
     * <pre>
     * Output only. Error status returned by Cloud KMS when using this key. This field may be
     * populated only if `kms_key_state` is not `KMS_KEY_STATE_KEY_AVAILABLE`.
     * If populated, this field contains the error status reported by Cloud KMS.
     * </pre>
     *
     * <code>.google.rpc.Status kms_status = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The kmsStatus.
     */
    com.google.rpc.Status getKmsStatus();
    /**
     *
     *
     * <pre>
     * Output only. Error status returned by Cloud KMS when using this key. This field may be
     * populated only if `kms_key_state` is not `KMS_KEY_STATE_KEY_AVAILABLE`.
     * If populated, this field contains the error status reported by Cloud KMS.
     * </pre>
     *
     * <code>.google.rpc.Status kms_status = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    com.google.rpc.StatusOrBuilder getKmsStatusOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * Configuration for CMEK support for edge machine local disk encryption.
   * </pre>
   *
   * Protobuf type {@code google.cloud.edgecontainer.v1.NodePool.LocalDiskEncryption}
   */
  public static final class LocalDiskEncryption extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.edgecontainer.v1.NodePool.LocalDiskEncryption)
      LocalDiskEncryptionOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use LocalDiskEncryption.newBuilder() to construct.
    private LocalDiskEncryption(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private LocalDiskEncryption() {
      kmsKey_ = "";
      kmsKeyActiveVersion_ = "";
      kmsKeyState_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new LocalDiskEncryption();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.edgecontainer.v1.ResourcesProto
          .internal_static_google_cloud_edgecontainer_v1_NodePool_LocalDiskEncryption_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.edgecontainer.v1.ResourcesProto
          .internal_static_google_cloud_edgecontainer_v1_NodePool_LocalDiskEncryption_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.edgecontainer.v1.NodePool.LocalDiskEncryption.class,
              com.google.cloud.edgecontainer.v1.NodePool.LocalDiskEncryption.Builder.class);
    }

    public static final int KMS_KEY_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object kmsKey_ = "";
    /**
     *
     *
     * <pre>
     * Immutable. The Cloud KMS CryptoKey e.g.
     * projects/{project}/locations/{location}/keyRings/{keyRing}/cryptoKeys/{cryptoKey}
     * to use for protecting node local disks. If not specified, a
     * Google-managed key will be used instead.
     * </pre>
     *
     * <code>
     * string kms_key = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The kmsKey.
     */
    @java.lang.Override
    public java.lang.String getKmsKey() {
      java.lang.Object ref = kmsKey_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        kmsKey_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. The Cloud KMS CryptoKey e.g.
     * projects/{project}/locations/{location}/keyRings/{keyRing}/cryptoKeys/{cryptoKey}
     * to use for protecting node local disks. If not specified, a
     * Google-managed key will be used instead.
     * </pre>
     *
     * <code>
     * string kms_key = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for kmsKey.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getKmsKeyBytes() {
      java.lang.Object ref = kmsKey_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        kmsKey_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int KMS_KEY_ACTIVE_VERSION_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object kmsKeyActiveVersion_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The Cloud KMS CryptoKeyVersion currently in use for protecting node local
     * disks. Only applicable if kms_key is set.
     * </pre>
     *
     * <code>
     * string kms_key_active_version = 2 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The kmsKeyActiveVersion.
     */
    @java.lang.Override
    public java.lang.String getKmsKeyActiveVersion() {
      java.lang.Object ref = kmsKeyActiveVersion_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        kmsKeyActiveVersion_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The Cloud KMS CryptoKeyVersion currently in use for protecting node local
     * disks. Only applicable if kms_key is set.
     * </pre>
     *
     * <code>
     * string kms_key_active_version = 2 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for kmsKeyActiveVersion.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getKmsKeyActiveVersionBytes() {
      java.lang.Object ref = kmsKeyActiveVersion_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        kmsKeyActiveVersion_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int KMS_KEY_STATE_FIELD_NUMBER = 3;
    private int kmsKeyState_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. Availability of the Cloud KMS CryptoKey. If not `KEY_AVAILABLE`, then
     * nodes may go offline as they cannot access their local data. This can be
     * caused by a lack of permissions to use the key, or if the key is disabled
     * or deleted.
     * </pre>
     *
     * <code>
     * .google.cloud.edgecontainer.v1.KmsKeyState kms_key_state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for kmsKeyState.
     */
    @java.lang.Override
    public int getKmsKeyStateValue() {
      return kmsKeyState_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Availability of the Cloud KMS CryptoKey. If not `KEY_AVAILABLE`, then
     * nodes may go offline as they cannot access their local data. This can be
     * caused by a lack of permissions to use the key, or if the key is disabled
     * or deleted.
     * </pre>
     *
     * <code>
     * .google.cloud.edgecontainer.v1.KmsKeyState kms_key_state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The kmsKeyState.
     */
    @java.lang.Override
    public com.google.cloud.edgecontainer.v1.KmsKeyState getKmsKeyState() {
      com.google.cloud.edgecontainer.v1.KmsKeyState result =
          com.google.cloud.edgecontainer.v1.KmsKeyState.forNumber(kmsKeyState_);
      return result == null ? com.google.cloud.edgecontainer.v1.KmsKeyState.UNRECOGNIZED : result;
    }

    public static final int KMS_STATUS_FIELD_NUMBER = 4;
    private com.google.rpc.Status kmsStatus_;
    /**
     *
     *
     * <pre>
     * Output only. Error status returned by Cloud KMS when using this key. This field may be
     * populated only if `kms_key_state` is not `KMS_KEY_STATE_KEY_AVAILABLE`.
     * If populated, this field contains the error status reported by Cloud KMS.
     * </pre>
     *
     * <code>.google.rpc.Status kms_status = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return Whether the kmsStatus field is set.
     */
    @java.lang.Override
    public boolean hasKmsStatus() {
      return kmsStatus_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. Error status returned by Cloud KMS when using this key. This field may be
     * populated only if `kms_key_state` is not `KMS_KEY_STATE_KEY_AVAILABLE`.
     * If populated, this field contains the error status reported by Cloud KMS.
     * </pre>
     *
     * <code>.google.rpc.Status kms_status = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The kmsStatus.
     */
    @java.lang.Override
    public com.google.rpc.Status getKmsStatus() {
      return kmsStatus_ == null ? com.google.rpc.Status.getDefaultInstance() : kmsStatus_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Error status returned by Cloud KMS when using this key. This field may be
     * populated only if `kms_key_state` is not `KMS_KEY_STATE_KEY_AVAILABLE`.
     * If populated, this field contains the error status reported by Cloud KMS.
     * </pre>
     *
     * <code>.google.rpc.Status kms_status = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    @java.lang.Override
    public com.google.rpc.StatusOrBuilder getKmsStatusOrBuilder() {
      return kmsStatus_ == null ? com.google.rpc.Status.getDefaultInstance() : kmsStatus_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(kmsKey_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, kmsKey_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(kmsKeyActiveVersion_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, kmsKeyActiveVersion_);
      }
      if (kmsKeyState_
          != com.google.cloud.edgecontainer.v1.KmsKeyState.KMS_KEY_STATE_UNSPECIFIED.getNumber()) {
        output.writeEnum(3, kmsKeyState_);
      }
      if (kmsStatus_ != null) {
        output.writeMessage(4, getKmsStatus());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(kmsKey_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, kmsKey_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(kmsKeyActiveVersion_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, kmsKeyActiveVersion_);
      }
      if (kmsKeyState_
          != com.google.cloud.edgecontainer.v1.KmsKeyState.KMS_KEY_STATE_UNSPECIFIED.getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, kmsKeyState_);
      }
      if (kmsStatus_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getKmsStatus());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.edgecontainer.v1.NodePool.LocalDiskEncryption)) {
        return super.equals(obj);
      }
      com.google.cloud.edgecontainer.v1.NodePool.LocalDiskEncryption other =
          (com.google.cloud.edgecontainer.v1.NodePool.LocalDiskEncryption) obj;

      if (!getKmsKey().equals(other.getKmsKey())) return false;
      if (!getKmsKeyActiveVersion().equals(other.getKmsKeyActiveVersion())) return false;
      if (kmsKeyState_ != other.kmsKeyState_) return false;
      if (hasKmsStatus() != other.hasKmsStatus()) return false;
      if (hasKmsStatus()) {
        if (!getKmsStatus().equals(other.getKmsStatus())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + KMS_KEY_FIELD_NUMBER;
      hash = (53 * hash) + getKmsKey().hashCode();
      hash = (37 * hash) + KMS_KEY_ACTIVE_VERSION_FIELD_NUMBER;
      hash = (53 * hash) + getKmsKeyActiveVersion().hashCode();
      hash = (37 * hash) + KMS_KEY_STATE_FIELD_NUMBER;
      hash = (53 * hash) + kmsKeyState_;
      if (hasKmsStatus()) {
        hash = (37 * hash) + KMS_STATUS_FIELD_NUMBER;
        hash = (53 * hash) + getKmsStatus().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.edgecontainer.v1.NodePool.LocalDiskEncryption parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.edgecontainer.v1.NodePool.LocalDiskEncryption parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.edgecontainer.v1.NodePool.LocalDiskEncryption parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.edgecontainer.v1.NodePool.LocalDiskEncryption parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.edgecontainer.v1.NodePool.LocalDiskEncryption parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.edgecontainer.v1.NodePool.LocalDiskEncryption parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.edgecontainer.v1.NodePool.LocalDiskEncryption parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.edgecontainer.v1.NodePool.LocalDiskEncryption parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.edgecontainer.v1.NodePool.LocalDiskEncryption parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.edgecontainer.v1.NodePool.LocalDiskEncryption parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.edgecontainer.v1.NodePool.LocalDiskEncryption parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.edgecontainer.v1.NodePool.LocalDiskEncryption parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.edgecontainer.v1.NodePool.LocalDiskEncryption prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Configuration for CMEK support for edge machine local disk encryption.
     * </pre>
     *
     * Protobuf type {@code google.cloud.edgecontainer.v1.NodePool.LocalDiskEncryption}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.edgecontainer.v1.NodePool.LocalDiskEncryption)
        com.google.cloud.edgecontainer.v1.NodePool.LocalDiskEncryptionOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.edgecontainer.v1.ResourcesProto
            .internal_static_google_cloud_edgecontainer_v1_NodePool_LocalDiskEncryption_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.edgecontainer.v1.ResourcesProto
            .internal_static_google_cloud_edgecontainer_v1_NodePool_LocalDiskEncryption_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.edgecontainer.v1.NodePool.LocalDiskEncryption.class,
                com.google.cloud.edgecontainer.v1.NodePool.LocalDiskEncryption.Builder.class);
      }

      // Construct using com.google.cloud.edgecontainer.v1.NodePool.LocalDiskEncryption.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        kmsKey_ = "";
        kmsKeyActiveVersion_ = "";
        kmsKeyState_ = 0;
        kmsStatus_ = null;
        if (kmsStatusBuilder_ != null) {
          kmsStatusBuilder_.dispose();
          kmsStatusBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.edgecontainer.v1.ResourcesProto
            .internal_static_google_cloud_edgecontainer_v1_NodePool_LocalDiskEncryption_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.edgecontainer.v1.NodePool.LocalDiskEncryption
          getDefaultInstanceForType() {
        return com.google.cloud.edgecontainer.v1.NodePool.LocalDiskEncryption.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.edgecontainer.v1.NodePool.LocalDiskEncryption build() {
        com.google.cloud.edgecontainer.v1.NodePool.LocalDiskEncryption result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.edgecontainer.v1.NodePool.LocalDiskEncryption buildPartial() {
        com.google.cloud.edgecontainer.v1.NodePool.LocalDiskEncryption result =
            new com.google.cloud.edgecontainer.v1.NodePool.LocalDiskEncryption(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.edgecontainer.v1.NodePool.LocalDiskEncryption result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.kmsKey_ = kmsKey_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.kmsKeyActiveVersion_ = kmsKeyActiveVersion_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.kmsKeyState_ = kmsKeyState_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.kmsStatus_ = kmsStatusBuilder_ == null ? kmsStatus_ : kmsStatusBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.edgecontainer.v1.NodePool.LocalDiskEncryption) {
          return mergeFrom((com.google.cloud.edgecontainer.v1.NodePool.LocalDiskEncryption) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.edgecontainer.v1.NodePool.LocalDiskEncryption other) {
        if (other
            == com.google.cloud.edgecontainer.v1.NodePool.LocalDiskEncryption.getDefaultInstance())
          return this;
        if (!other.getKmsKey().isEmpty()) {
          kmsKey_ = other.kmsKey_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getKmsKeyActiveVersion().isEmpty()) {
          kmsKeyActiveVersion_ = other.kmsKeyActiveVersion_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (other.kmsKeyState_ != 0) {
          setKmsKeyStateValue(other.getKmsKeyStateValue());
        }
        if (other.hasKmsStatus()) {
          mergeKmsStatus(other.getKmsStatus());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  kmsKey_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  kmsKeyActiveVersion_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 24:
                {
                  kmsKeyState_ = input.readEnum();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 24
              case 34:
                {
                  input.readMessage(getKmsStatusFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000008;
                  break;
                } // case 34
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object kmsKey_ = "";
      /**
       *
       *
       * <pre>
       * Immutable. The Cloud KMS CryptoKey e.g.
       * projects/{project}/locations/{location}/keyRings/{keyRing}/cryptoKeys/{cryptoKey}
       * to use for protecting node local disks. If not specified, a
       * Google-managed key will be used instead.
       * </pre>
       *
       * <code>
       * string kms_key = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The kmsKey.
       */
      public java.lang.String getKmsKey() {
        java.lang.Object ref = kmsKey_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          kmsKey_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Immutable. The Cloud KMS CryptoKey e.g.
       * projects/{project}/locations/{location}/keyRings/{keyRing}/cryptoKeys/{cryptoKey}
       * to use for protecting node local disks. If not specified, a
       * Google-managed key will be used instead.
       * </pre>
       *
       * <code>
       * string kms_key = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The bytes for kmsKey.
       */
      public com.google.protobuf.ByteString getKmsKeyBytes() {
        java.lang.Object ref = kmsKey_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          kmsKey_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Immutable. The Cloud KMS CryptoKey e.g.
       * projects/{project}/locations/{location}/keyRings/{keyRing}/cryptoKeys/{cryptoKey}
       * to use for protecting node local disks. If not specified, a
       * Google-managed key will be used instead.
       * </pre>
       *
       * <code>
       * string kms_key = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The kmsKey to set.
       * @return This builder for chaining.
       */
      public Builder setKmsKey(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        kmsKey_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Immutable. The Cloud KMS CryptoKey e.g.
       * projects/{project}/locations/{location}/keyRings/{keyRing}/cryptoKeys/{cryptoKey}
       * to use for protecting node local disks. If not specified, a
       * Google-managed key will be used instead.
       * </pre>
       *
       * <code>
       * string kms_key = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearKmsKey() {
        kmsKey_ = getDefaultInstance().getKmsKey();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Immutable. The Cloud KMS CryptoKey e.g.
       * projects/{project}/locations/{location}/keyRings/{keyRing}/cryptoKeys/{cryptoKey}
       * to use for protecting node local disks. If not specified, a
       * Google-managed key will be used instead.
       * </pre>
       *
       * <code>
       * string kms_key = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The bytes for kmsKey to set.
       * @return This builder for chaining.
       */
      public Builder setKmsKeyBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        kmsKey_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object kmsKeyActiveVersion_ = "";
      /**
       *
       *
       * <pre>
       * Output only. The Cloud KMS CryptoKeyVersion currently in use for protecting node local
       * disks. Only applicable if kms_key is set.
       * </pre>
       *
       * <code>
       * string kms_key_active_version = 2 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The kmsKeyActiveVersion.
       */
      public java.lang.String getKmsKeyActiveVersion() {
        java.lang.Object ref = kmsKeyActiveVersion_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          kmsKeyActiveVersion_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The Cloud KMS CryptoKeyVersion currently in use for protecting node local
       * disks. Only applicable if kms_key is set.
       * </pre>
       *
       * <code>
       * string kms_key_active_version = 2 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The bytes for kmsKeyActiveVersion.
       */
      public com.google.protobuf.ByteString getKmsKeyActiveVersionBytes() {
        java.lang.Object ref = kmsKeyActiveVersion_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          kmsKeyActiveVersion_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The Cloud KMS CryptoKeyVersion currently in use for protecting node local
       * disks. Only applicable if kms_key is set.
       * </pre>
       *
       * <code>
       * string kms_key_active_version = 2 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The kmsKeyActiveVersion to set.
       * @return This builder for chaining.
       */
      public Builder setKmsKeyActiveVersion(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        kmsKeyActiveVersion_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The Cloud KMS CryptoKeyVersion currently in use for protecting node local
       * disks. Only applicable if kms_key is set.
       * </pre>
       *
       * <code>
       * string kms_key_active_version = 2 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearKmsKeyActiveVersion() {
        kmsKeyActiveVersion_ = getDefaultInstance().getKmsKeyActiveVersion();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The Cloud KMS CryptoKeyVersion currently in use for protecting node local
       * disks. Only applicable if kms_key is set.
       * </pre>
       *
       * <code>
       * string kms_key_active_version = 2 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The bytes for kmsKeyActiveVersion to set.
       * @return This builder for chaining.
       */
      public Builder setKmsKeyActiveVersionBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        kmsKeyActiveVersion_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private int kmsKeyState_ = 0;
      /**
       *
       *
       * <pre>
       * Output only. Availability of the Cloud KMS CryptoKey. If not `KEY_AVAILABLE`, then
       * nodes may go offline as they cannot access their local data. This can be
       * caused by a lack of permissions to use the key, or if the key is disabled
       * or deleted.
       * </pre>
       *
       * <code>
       * .google.cloud.edgecontainer.v1.KmsKeyState kms_key_state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The enum numeric value on the wire for kmsKeyState.
       */
      @java.lang.Override
      public int getKmsKeyStateValue() {
        return kmsKeyState_;
      }
      /**
       *
       *
       * <pre>
       * Output only. Availability of the Cloud KMS CryptoKey. If not `KEY_AVAILABLE`, then
       * nodes may go offline as they cannot access their local data. This can be
       * caused by a lack of permissions to use the key, or if the key is disabled
       * or deleted.
       * </pre>
       *
       * <code>
       * .google.cloud.edgecontainer.v1.KmsKeyState kms_key_state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @param value The enum numeric value on the wire for kmsKeyState to set.
       * @return This builder for chaining.
       */
      public Builder setKmsKeyStateValue(int value) {
        kmsKeyState_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Availability of the Cloud KMS CryptoKey. If not `KEY_AVAILABLE`, then
       * nodes may go offline as they cannot access their local data. This can be
       * caused by a lack of permissions to use the key, or if the key is disabled
       * or deleted.
       * </pre>
       *
       * <code>
       * .google.cloud.edgecontainer.v1.KmsKeyState kms_key_state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The kmsKeyState.
       */
      @java.lang.Override
      public com.google.cloud.edgecontainer.v1.KmsKeyState getKmsKeyState() {
        com.google.cloud.edgecontainer.v1.KmsKeyState result =
            com.google.cloud.edgecontainer.v1.KmsKeyState.forNumber(kmsKeyState_);
        return result == null ? com.google.cloud.edgecontainer.v1.KmsKeyState.UNRECOGNIZED : result;
      }
      /**
       *
       *
       * <pre>
       * Output only. Availability of the Cloud KMS CryptoKey. If not `KEY_AVAILABLE`, then
       * nodes may go offline as they cannot access their local data. This can be
       * caused by a lack of permissions to use the key, or if the key is disabled
       * or deleted.
       * </pre>
       *
       * <code>
       * .google.cloud.edgecontainer.v1.KmsKeyState kms_key_state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @param value The kmsKeyState to set.
       * @return This builder for chaining.
       */
      public Builder setKmsKeyState(com.google.cloud.edgecontainer.v1.KmsKeyState value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000004;
        kmsKeyState_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Availability of the Cloud KMS CryptoKey. If not `KEY_AVAILABLE`, then
       * nodes may go offline as they cannot access their local data. This can be
       * caused by a lack of permissions to use the key, or if the key is disabled
       * or deleted.
       * </pre>
       *
       * <code>
       * .google.cloud.edgecontainer.v1.KmsKeyState kms_key_state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearKmsKeyState() {
        bitField0_ = (bitField0_ & ~0x00000004);
        kmsKeyState_ = 0;
        onChanged();
        return this;
      }

      private com.google.rpc.Status kmsStatus_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
          kmsStatusBuilder_;
      /**
       *
       *
       * <pre>
       * Output only. Error status returned by Cloud KMS when using this key. This field may be
       * populated only if `kms_key_state` is not `KMS_KEY_STATE_KEY_AVAILABLE`.
       * If populated, this field contains the error status reported by Cloud KMS.
       * </pre>
       *
       * <code>.google.rpc.Status kms_status = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return Whether the kmsStatus field is set.
       */
      public boolean hasKmsStatus() {
        return ((bitField0_ & 0x00000008) != 0);
      }
      /**
       *
       *
       * <pre>
       * Output only. Error status returned by Cloud KMS when using this key. This field may be
       * populated only if `kms_key_state` is not `KMS_KEY_STATE_KEY_AVAILABLE`.
       * If populated, this field contains the error status reported by Cloud KMS.
       * </pre>
       *
       * <code>.google.rpc.Status kms_status = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The kmsStatus.
       */
      public com.google.rpc.Status getKmsStatus() {
        if (kmsStatusBuilder_ == null) {
          return kmsStatus_ == null ? com.google.rpc.Status.getDefaultInstance() : kmsStatus_;
        } else {
          return kmsStatusBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. Error status returned by Cloud KMS when using this key. This field may be
       * populated only if `kms_key_state` is not `KMS_KEY_STATE_KEY_AVAILABLE`.
       * If populated, this field contains the error status reported by Cloud KMS.
       * </pre>
       *
       * <code>.google.rpc.Status kms_status = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder setKmsStatus(com.google.rpc.Status value) {
        if (kmsStatusBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          kmsStatus_ = value;
        } else {
          kmsStatusBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Error status returned by Cloud KMS when using this key. This field may be
       * populated only if `kms_key_state` is not `KMS_KEY_STATE_KEY_AVAILABLE`.
       * If populated, this field contains the error status reported by Cloud KMS.
       * </pre>
       *
       * <code>.google.rpc.Status kms_status = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder setKmsStatus(com.google.rpc.Status.Builder builderForValue) {
        if (kmsStatusBuilder_ == null) {
          kmsStatus_ = builderForValue.build();
        } else {
          kmsStatusBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Error status returned by Cloud KMS when using this key. This field may be
       * populated only if `kms_key_state` is not `KMS_KEY_STATE_KEY_AVAILABLE`.
       * If populated, this field contains the error status reported by Cloud KMS.
       * </pre>
       *
       * <code>.google.rpc.Status kms_status = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder mergeKmsStatus(com.google.rpc.Status value) {
        if (kmsStatusBuilder_ == null) {
          if (((bitField0_ & 0x00000008) != 0)
              && kmsStatus_ != null
              && kmsStatus_ != com.google.rpc.Status.getDefaultInstance()) {
            getKmsStatusBuilder().mergeFrom(value);
          } else {
            kmsStatus_ = value;
          }
        } else {
          kmsStatusBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Error status returned by Cloud KMS when using this key. This field may be
       * populated only if `kms_key_state` is not `KMS_KEY_STATE_KEY_AVAILABLE`.
       * If populated, this field contains the error status reported by Cloud KMS.
       * </pre>
       *
       * <code>.google.rpc.Status kms_status = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder clearKmsStatus() {
        bitField0_ = (bitField0_ & ~0x00000008);
        kmsStatus_ = null;
        if (kmsStatusBuilder_ != null) {
          kmsStatusBuilder_.dispose();
          kmsStatusBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Error status returned by Cloud KMS when using this key. This field may be
       * populated only if `kms_key_state` is not `KMS_KEY_STATE_KEY_AVAILABLE`.
       * If populated, this field contains the error status reported by Cloud KMS.
       * </pre>
       *
       * <code>.google.rpc.Status kms_status = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.rpc.Status.Builder getKmsStatusBuilder() {
        bitField0_ |= 0x00000008;
        onChanged();
        return getKmsStatusFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Output only. Error status returned by Cloud KMS when using this key. This field may be
       * populated only if `kms_key_state` is not `KMS_KEY_STATE_KEY_AVAILABLE`.
       * If populated, this field contains the error status reported by Cloud KMS.
       * </pre>
       *
       * <code>.google.rpc.Status kms_status = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.rpc.StatusOrBuilder getKmsStatusOrBuilder() {
        if (kmsStatusBuilder_ != null) {
          return kmsStatusBuilder_.getMessageOrBuilder();
        } else {
          return kmsStatus_ == null ? com.google.rpc.Status.getDefaultInstance() : kmsStatus_;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. Error status returned by Cloud KMS when using this key. This field may be
       * populated only if `kms_key_state` is not `KMS_KEY_STATE_KEY_AVAILABLE`.
       * If populated, this field contains the error status reported by Cloud KMS.
       * </pre>
       *
       * <code>.google.rpc.Status kms_status = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
          getKmsStatusFieldBuilder() {
        if (kmsStatusBuilder_ == null) {
          kmsStatusBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.rpc.Status,
                  com.google.rpc.Status.Builder,
                  com.google.rpc.StatusOrBuilder>(
                  getKmsStatus(), getParentForChildren(), isClean());
          kmsStatus_ = null;
        }
        return kmsStatusBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.edgecontainer.v1.NodePool.LocalDiskEncryption)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.edgecontainer.v1.NodePool.LocalDiskEncryption)
    private static final com.google.cloud.edgecontainer.v1.NodePool.LocalDiskEncryption
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.edgecontainer.v1.NodePool.LocalDiskEncryption();
    }

    public static com.google.cloud.edgecontainer.v1.NodePool.LocalDiskEncryption
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<LocalDiskEncryption> PARSER =
        new com.google.protobuf.AbstractParser<LocalDiskEncryption>() {
          @java.lang.Override
          public LocalDiskEncryption parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<LocalDiskEncryption> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<LocalDiskEncryption> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.edgecontainer.v1.NodePool.LocalDiskEncryption
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Required. The resource name of the node pool.
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The resource name of the node pool.
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 2;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. The time when the node pool was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time when the node pool was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time when the node pool was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 3;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. The time when the node pool was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return updateTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time when the node pool was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time when the node pool was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int LABELS_FIELD_NUMBER = 4;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.edgecontainer.v1.ResourcesProto
                .internal_static_google_cloud_edgecontainer_v1_NodePool_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Labels associated with this resource.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * Labels associated with this resource.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * Labels associated with this resource.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Labels associated with this resource.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int NODE_LOCATION_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private volatile java.lang.Object nodeLocation_ = "";
  /**
   *
   *
   * <pre>
   * Name of the Google Distributed Cloud Edge zone where this node pool will be
   * created. For example: `us-central1-edge-customer-a`.
   * </pre>
   *
   * <code>string node_location = 8;</code>
   *
   * @return The nodeLocation.
   */
  @java.lang.Override
  public java.lang.String getNodeLocation() {
    java.lang.Object ref = nodeLocation_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      nodeLocation_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Name of the Google Distributed Cloud Edge zone where this node pool will be
   * created. For example: `us-central1-edge-customer-a`.
   * </pre>
   *
   * <code>string node_location = 8;</code>
   *
   * @return The bytes for nodeLocation.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNodeLocationBytes() {
    java.lang.Object ref = nodeLocation_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      nodeLocation_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NODE_COUNT_FIELD_NUMBER = 6;
  private int nodeCount_ = 0;
  /**
   *
   *
   * <pre>
   * Required. The number of nodes in the pool.
   * </pre>
   *
   * <code>int32 node_count = 6 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The nodeCount.
   */
  @java.lang.Override
  public int getNodeCount() {
    return nodeCount_;
  }

  public static final int MACHINE_FILTER_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private volatile java.lang.Object machineFilter_ = "";
  /**
   *
   *
   * <pre>
   * Only machines matching this filter will be allowed to join the node pool.
   * The filtering language accepts strings like "name=&lt;name&gt;", and is
   * documented in more detail in [AIP-160](https://google.aip.dev/160).
   * </pre>
   *
   * <code>string machine_filter = 7;</code>
   *
   * @return The machineFilter.
   */
  @java.lang.Override
  public java.lang.String getMachineFilter() {
    java.lang.Object ref = machineFilter_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      machineFilter_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Only machines matching this filter will be allowed to join the node pool.
   * The filtering language accepts strings like "name=&lt;name&gt;", and is
   * documented in more detail in [AIP-160](https://google.aip.dev/160).
   * </pre>
   *
   * <code>string machine_filter = 7;</code>
   *
   * @return The bytes for machineFilter.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getMachineFilterBytes() {
    java.lang.Object ref = machineFilter_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      machineFilter_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LOCAL_DISK_ENCRYPTION_FIELD_NUMBER = 9;
  private com.google.cloud.edgecontainer.v1.NodePool.LocalDiskEncryption localDiskEncryption_;
  /**
   *
   *
   * <pre>
   * Optional. Local disk encryption options. This field is only used when enabling CMEK
   * support.
   * </pre>
   *
   * <code>
   * .google.cloud.edgecontainer.v1.NodePool.LocalDiskEncryption local_disk_encryption = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the localDiskEncryption field is set.
   */
  @java.lang.Override
  public boolean hasLocalDiskEncryption() {
    return localDiskEncryption_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. Local disk encryption options. This field is only used when enabling CMEK
   * support.
   * </pre>
   *
   * <code>
   * .google.cloud.edgecontainer.v1.NodePool.LocalDiskEncryption local_disk_encryption = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The localDiskEncryption.
   */
  @java.lang.Override
  public com.google.cloud.edgecontainer.v1.NodePool.LocalDiskEncryption getLocalDiskEncryption() {
    return localDiskEncryption_ == null
        ? com.google.cloud.edgecontainer.v1.NodePool.LocalDiskEncryption.getDefaultInstance()
        : localDiskEncryption_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Local disk encryption options. This field is only used when enabling CMEK
   * support.
   * </pre>
   *
   * <code>
   * .google.cloud.edgecontainer.v1.NodePool.LocalDiskEncryption local_disk_encryption = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.edgecontainer.v1.NodePool.LocalDiskEncryptionOrBuilder
      getLocalDiskEncryptionOrBuilder() {
    return localDiskEncryption_ == null
        ? com.google.cloud.edgecontainer.v1.NodePool.LocalDiskEncryption.getDefaultInstance()
        : localDiskEncryption_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (createTime_ != null) {
      output.writeMessage(2, getCreateTime());
    }
    if (updateTime_ != null) {
      output.writeMessage(3, getUpdateTime());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 4);
    if (nodeCount_ != 0) {
      output.writeInt32(6, nodeCount_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(machineFilter_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, machineFilter_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(nodeLocation_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, nodeLocation_);
    }
    if (localDiskEncryption_ != null) {
      output.writeMessage(9, getLocalDiskEncryption());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getCreateTime());
    }
    if (updateTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getUpdateTime());
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, labels__);
    }
    if (nodeCount_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(6, nodeCount_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(machineFilter_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, machineFilter_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(nodeLocation_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, nodeLocation_);
    }
    if (localDiskEncryption_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getLocalDiskEncryption());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.edgecontainer.v1.NodePool)) {
      return super.equals(obj);
    }
    com.google.cloud.edgecontainer.v1.NodePool other =
        (com.google.cloud.edgecontainer.v1.NodePool) obj;

    if (!getName().equals(other.getName())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (!getNodeLocation().equals(other.getNodeLocation())) return false;
    if (getNodeCount() != other.getNodeCount()) return false;
    if (!getMachineFilter().equals(other.getMachineFilter())) return false;
    if (hasLocalDiskEncryption() != other.hasLocalDiskEncryption()) return false;
    if (hasLocalDiskEncryption()) {
      if (!getLocalDiskEncryption().equals(other.getLocalDiskEncryption())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    hash = (37 * hash) + NODE_LOCATION_FIELD_NUMBER;
    hash = (53 * hash) + getNodeLocation().hashCode();
    hash = (37 * hash) + NODE_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + getNodeCount();
    hash = (37 * hash) + MACHINE_FILTER_FIELD_NUMBER;
    hash = (53 * hash) + getMachineFilter().hashCode();
    if (hasLocalDiskEncryption()) {
      hash = (37 * hash) + LOCAL_DISK_ENCRYPTION_FIELD_NUMBER;
      hash = (53 * hash) + getLocalDiskEncryption().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.edgecontainer.v1.NodePool parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.edgecontainer.v1.NodePool parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.edgecontainer.v1.NodePool parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.edgecontainer.v1.NodePool parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.edgecontainer.v1.NodePool parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.edgecontainer.v1.NodePool parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.edgecontainer.v1.NodePool parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.edgecontainer.v1.NodePool parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.edgecontainer.v1.NodePool parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.edgecontainer.v1.NodePool parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.edgecontainer.v1.NodePool parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.edgecontainer.v1.NodePool parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.edgecontainer.v1.NodePool prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A set of Kubernetes nodes in a cluster with common configuration and
   * specification.
   * </pre>
   *
   * Protobuf type {@code google.cloud.edgecontainer.v1.NodePool}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.edgecontainer.v1.NodePool)
      com.google.cloud.edgecontainer.v1.NodePoolOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.edgecontainer.v1.ResourcesProto
          .internal_static_google_cloud_edgecontainer_v1_NodePool_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 4:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 4:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.edgecontainer.v1.ResourcesProto
          .internal_static_google_cloud_edgecontainer_v1_NodePool_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.edgecontainer.v1.NodePool.class,
              com.google.cloud.edgecontainer.v1.NodePool.Builder.class);
    }

    // Construct using com.google.cloud.edgecontainer.v1.NodePool.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      internalGetMutableLabels().clear();
      nodeLocation_ = "";
      nodeCount_ = 0;
      machineFilter_ = "";
      localDiskEncryption_ = null;
      if (localDiskEncryptionBuilder_ != null) {
        localDiskEncryptionBuilder_.dispose();
        localDiskEncryptionBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.edgecontainer.v1.ResourcesProto
          .internal_static_google_cloud_edgecontainer_v1_NodePool_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.edgecontainer.v1.NodePool getDefaultInstanceForType() {
      return com.google.cloud.edgecontainer.v1.NodePool.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.edgecontainer.v1.NodePool build() {
      com.google.cloud.edgecontainer.v1.NodePool result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.edgecontainer.v1.NodePool buildPartial() {
      com.google.cloud.edgecontainer.v1.NodePool result =
          new com.google.cloud.edgecontainer.v1.NodePool(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.edgecontainer.v1.NodePool result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.nodeLocation_ = nodeLocation_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.nodeCount_ = nodeCount_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.machineFilter_ = machineFilter_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.localDiskEncryption_ =
            localDiskEncryptionBuilder_ == null
                ? localDiskEncryption_
                : localDiskEncryptionBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.edgecontainer.v1.NodePool) {
        return mergeFrom((com.google.cloud.edgecontainer.v1.NodePool) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.edgecontainer.v1.NodePool other) {
      if (other == com.google.cloud.edgecontainer.v1.NodePool.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00000008;
      if (!other.getNodeLocation().isEmpty()) {
        nodeLocation_ = other.nodeLocation_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (other.getNodeCount() != 0) {
        setNodeCount(other.getNodeCount());
      }
      if (!other.getMachineFilter().isEmpty()) {
        machineFilter_ = other.machineFilter_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (other.hasLocalDiskEncryption()) {
        mergeLocalDiskEncryption(other.getLocalDiskEncryption());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 48:
              {
                nodeCount_ = input.readInt32();
                bitField0_ |= 0x00000020;
                break;
              } // case 48
            case 58:
              {
                machineFilter_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            case 66:
              {
                nodeLocation_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 66
            case 74:
              {
                input.readMessage(
                    getLocalDiskEncryptionFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 74
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Required. The resource name of the node pool.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the node pool.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the node pool.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the node pool.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the node pool.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The time when the node pool was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the node pool was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the node pool was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the node pool was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the node pool was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the node pool was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000002);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the node pool was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the node pool was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the node pool was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The time when the node pool was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the node pool was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the node pool was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the node pool was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the node pool was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the node pool was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000004);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the node pool was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the node pool was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the node pool was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Labels associated with this resource.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * Labels associated with this resource.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * Labels associated with this resource.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Labels associated with this resource.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00000008);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Labels associated with this resource.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x00000008;
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Labels associated with this resource.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00000008;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Labels associated with this resource.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00000008;
      return this;
    }

    private java.lang.Object nodeLocation_ = "";
    /**
     *
     *
     * <pre>
     * Name of the Google Distributed Cloud Edge zone where this node pool will be
     * created. For example: `us-central1-edge-customer-a`.
     * </pre>
     *
     * <code>string node_location = 8;</code>
     *
     * @return The nodeLocation.
     */
    public java.lang.String getNodeLocation() {
      java.lang.Object ref = nodeLocation_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        nodeLocation_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of the Google Distributed Cloud Edge zone where this node pool will be
     * created. For example: `us-central1-edge-customer-a`.
     * </pre>
     *
     * <code>string node_location = 8;</code>
     *
     * @return The bytes for nodeLocation.
     */
    public com.google.protobuf.ByteString getNodeLocationBytes() {
      java.lang.Object ref = nodeLocation_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        nodeLocation_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of the Google Distributed Cloud Edge zone where this node pool will be
     * created. For example: `us-central1-edge-customer-a`.
     * </pre>
     *
     * <code>string node_location = 8;</code>
     *
     * @param value The nodeLocation to set.
     * @return This builder for chaining.
     */
    public Builder setNodeLocation(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      nodeLocation_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of the Google Distributed Cloud Edge zone where this node pool will be
     * created. For example: `us-central1-edge-customer-a`.
     * </pre>
     *
     * <code>string node_location = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNodeLocation() {
      nodeLocation_ = getDefaultInstance().getNodeLocation();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of the Google Distributed Cloud Edge zone where this node pool will be
     * created. For example: `us-central1-edge-customer-a`.
     * </pre>
     *
     * <code>string node_location = 8;</code>
     *
     * @param value The bytes for nodeLocation to set.
     * @return This builder for chaining.
     */
    public Builder setNodeLocationBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      nodeLocation_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private int nodeCount_;
    /**
     *
     *
     * <pre>
     * Required. The number of nodes in the pool.
     * </pre>
     *
     * <code>int32 node_count = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The nodeCount.
     */
    @java.lang.Override
    public int getNodeCount() {
      return nodeCount_;
    }
    /**
     *
     *
     * <pre>
     * Required. The number of nodes in the pool.
     * </pre>
     *
     * <code>int32 node_count = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The nodeCount to set.
     * @return This builder for chaining.
     */
    public Builder setNodeCount(int value) {

      nodeCount_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The number of nodes in the pool.
     * </pre>
     *
     * <code>int32 node_count = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNodeCount() {
      bitField0_ = (bitField0_ & ~0x00000020);
      nodeCount_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object machineFilter_ = "";
    /**
     *
     *
     * <pre>
     * Only machines matching this filter will be allowed to join the node pool.
     * The filtering language accepts strings like "name=&lt;name&gt;", and is
     * documented in more detail in [AIP-160](https://google.aip.dev/160).
     * </pre>
     *
     * <code>string machine_filter = 7;</code>
     *
     * @return The machineFilter.
     */
    public java.lang.String getMachineFilter() {
      java.lang.Object ref = machineFilter_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        machineFilter_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Only machines matching this filter will be allowed to join the node pool.
     * The filtering language accepts strings like "name=&lt;name&gt;", and is
     * documented in more detail in [AIP-160](https://google.aip.dev/160).
     * </pre>
     *
     * <code>string machine_filter = 7;</code>
     *
     * @return The bytes for machineFilter.
     */
    public com.google.protobuf.ByteString getMachineFilterBytes() {
      java.lang.Object ref = machineFilter_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        machineFilter_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Only machines matching this filter will be allowed to join the node pool.
     * The filtering language accepts strings like "name=&lt;name&gt;", and is
     * documented in more detail in [AIP-160](https://google.aip.dev/160).
     * </pre>
     *
     * <code>string machine_filter = 7;</code>
     *
     * @param value The machineFilter to set.
     * @return This builder for chaining.
     */
    public Builder setMachineFilter(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      machineFilter_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Only machines matching this filter will be allowed to join the node pool.
     * The filtering language accepts strings like "name=&lt;name&gt;", and is
     * documented in more detail in [AIP-160](https://google.aip.dev/160).
     * </pre>
     *
     * <code>string machine_filter = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMachineFilter() {
      machineFilter_ = getDefaultInstance().getMachineFilter();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Only machines matching this filter will be allowed to join the node pool.
     * The filtering language accepts strings like "name=&lt;name&gt;", and is
     * documented in more detail in [AIP-160](https://google.aip.dev/160).
     * </pre>
     *
     * <code>string machine_filter = 7;</code>
     *
     * @param value The bytes for machineFilter to set.
     * @return This builder for chaining.
     */
    public Builder setMachineFilterBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      machineFilter_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private com.google.cloud.edgecontainer.v1.NodePool.LocalDiskEncryption localDiskEncryption_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.edgecontainer.v1.NodePool.LocalDiskEncryption,
            com.google.cloud.edgecontainer.v1.NodePool.LocalDiskEncryption.Builder,
            com.google.cloud.edgecontainer.v1.NodePool.LocalDiskEncryptionOrBuilder>
        localDiskEncryptionBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Local disk encryption options. This field is only used when enabling CMEK
     * support.
     * </pre>
     *
     * <code>
     * .google.cloud.edgecontainer.v1.NodePool.LocalDiskEncryption local_disk_encryption = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the localDiskEncryption field is set.
     */
    public boolean hasLocalDiskEncryption() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Local disk encryption options. This field is only used when enabling CMEK
     * support.
     * </pre>
     *
     * <code>
     * .google.cloud.edgecontainer.v1.NodePool.LocalDiskEncryption local_disk_encryption = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The localDiskEncryption.
     */
    public com.google.cloud.edgecontainer.v1.NodePool.LocalDiskEncryption getLocalDiskEncryption() {
      if (localDiskEncryptionBuilder_ == null) {
        return localDiskEncryption_ == null
            ? com.google.cloud.edgecontainer.v1.NodePool.LocalDiskEncryption.getDefaultInstance()
            : localDiskEncryption_;
      } else {
        return localDiskEncryptionBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Local disk encryption options. This field is only used when enabling CMEK
     * support.
     * </pre>
     *
     * <code>
     * .google.cloud.edgecontainer.v1.NodePool.LocalDiskEncryption local_disk_encryption = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setLocalDiskEncryption(
        com.google.cloud.edgecontainer.v1.NodePool.LocalDiskEncryption value) {
      if (localDiskEncryptionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        localDiskEncryption_ = value;
      } else {
        localDiskEncryptionBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Local disk encryption options. This field is only used when enabling CMEK
     * support.
     * </pre>
     *
     * <code>
     * .google.cloud.edgecontainer.v1.NodePool.LocalDiskEncryption local_disk_encryption = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setLocalDiskEncryption(
        com.google.cloud.edgecontainer.v1.NodePool.LocalDiskEncryption.Builder builderForValue) {
      if (localDiskEncryptionBuilder_ == null) {
        localDiskEncryption_ = builderForValue.build();
      } else {
        localDiskEncryptionBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Local disk encryption options. This field is only used when enabling CMEK
     * support.
     * </pre>
     *
     * <code>
     * .google.cloud.edgecontainer.v1.NodePool.LocalDiskEncryption local_disk_encryption = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeLocalDiskEncryption(
        com.google.cloud.edgecontainer.v1.NodePool.LocalDiskEncryption value) {
      if (localDiskEncryptionBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && localDiskEncryption_ != null
            && localDiskEncryption_
                != com.google.cloud.edgecontainer.v1.NodePool.LocalDiskEncryption
                    .getDefaultInstance()) {
          getLocalDiskEncryptionBuilder().mergeFrom(value);
        } else {
          localDiskEncryption_ = value;
        }
      } else {
        localDiskEncryptionBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Local disk encryption options. This field is only used when enabling CMEK
     * support.
     * </pre>
     *
     * <code>
     * .google.cloud.edgecontainer.v1.NodePool.LocalDiskEncryption local_disk_encryption = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearLocalDiskEncryption() {
      bitField0_ = (bitField0_ & ~0x00000080);
      localDiskEncryption_ = null;
      if (localDiskEncryptionBuilder_ != null) {
        localDiskEncryptionBuilder_.dispose();
        localDiskEncryptionBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Local disk encryption options. This field is only used when enabling CMEK
     * support.
     * </pre>
     *
     * <code>
     * .google.cloud.edgecontainer.v1.NodePool.LocalDiskEncryption local_disk_encryption = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.edgecontainer.v1.NodePool.LocalDiskEncryption.Builder
        getLocalDiskEncryptionBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getLocalDiskEncryptionFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Local disk encryption options. This field is only used when enabling CMEK
     * support.
     * </pre>
     *
     * <code>
     * .google.cloud.edgecontainer.v1.NodePool.LocalDiskEncryption local_disk_encryption = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.edgecontainer.v1.NodePool.LocalDiskEncryptionOrBuilder
        getLocalDiskEncryptionOrBuilder() {
      if (localDiskEncryptionBuilder_ != null) {
        return localDiskEncryptionBuilder_.getMessageOrBuilder();
      } else {
        return localDiskEncryption_ == null
            ? com.google.cloud.edgecontainer.v1.NodePool.LocalDiskEncryption.getDefaultInstance()
            : localDiskEncryption_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Local disk encryption options. This field is only used when enabling CMEK
     * support.
     * </pre>
     *
     * <code>
     * .google.cloud.edgecontainer.v1.NodePool.LocalDiskEncryption local_disk_encryption = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.edgecontainer.v1.NodePool.LocalDiskEncryption,
            com.google.cloud.edgecontainer.v1.NodePool.LocalDiskEncryption.Builder,
            com.google.cloud.edgecontainer.v1.NodePool.LocalDiskEncryptionOrBuilder>
        getLocalDiskEncryptionFieldBuilder() {
      if (localDiskEncryptionBuilder_ == null) {
        localDiskEncryptionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.edgecontainer.v1.NodePool.LocalDiskEncryption,
                com.google.cloud.edgecontainer.v1.NodePool.LocalDiskEncryption.Builder,
                com.google.cloud.edgecontainer.v1.NodePool.LocalDiskEncryptionOrBuilder>(
                getLocalDiskEncryption(), getParentForChildren(), isClean());
        localDiskEncryption_ = null;
      }
      return localDiskEncryptionBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.edgecontainer.v1.NodePool)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.edgecontainer.v1.NodePool)
  private static final com.google.cloud.edgecontainer.v1.NodePool DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.edgecontainer.v1.NodePool();
  }

  public static com.google.cloud.edgecontainer.v1.NodePool getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<NodePool> PARSER =
      new com.google.protobuf.AbstractParser<NodePool>() {
        @java.lang.Override
        public NodePool parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<NodePool> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<NodePool> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.edgecontainer.v1.NodePool getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
