/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/edgecontainer/v1/resources.proto

package com.google.cloud.edgecontainer.v1;

public interface NodePoolOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.edgecontainer.v1.NodePool)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Required. The resource name of the node pool.
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The name.
   */
  java.lang.String getName();
  /**
   *
   *
   * <pre>
   * Required. The resource name of the node pool.
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for name.
   */
  com.google.protobuf.ByteString getNameBytes();

  /**
   *
   *
   * <pre>
   * Output only. The time when the node pool was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  boolean hasCreateTime();
  /**
   *
   *
   * <pre>
   * Output only. The time when the node pool was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  com.google.protobuf.Timestamp getCreateTime();
  /**
   *
   *
   * <pre>
   * Output only. The time when the node pool was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * Output only. The time when the node pool was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  boolean hasUpdateTime();
  /**
   *
   *
   * <pre>
   * Output only. The time when the node pool was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  com.google.protobuf.Timestamp getUpdateTime();
  /**
   *
   *
   * <pre>
   * Output only. The time when the node pool was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * Labels associated with this resource.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */
  int getLabelsCount();
  /**
   *
   *
   * <pre>
   * Labels associated with this resource.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */
  boolean containsLabels(java.lang.String key);
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Deprecated
  java.util.Map<java.lang.String, java.lang.String> getLabels();
  /**
   *
   *
   * <pre>
   * Labels associated with this resource.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */
  java.util.Map<java.lang.String, java.lang.String> getLabelsMap();
  /**
   *
   *
   * <pre>
   * Labels associated with this resource.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */
  /* nullable */
  java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue);
  /**
   *
   *
   * <pre>
   * Labels associated with this resource.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */
  java.lang.String getLabelsOrThrow(java.lang.String key);

  /**
   *
   *
   * <pre>
   * Name of the Google Distributed Cloud Edge zone where this node pool will be
   * created. For example: `us-central1-edge-customer-a`.
   * </pre>
   *
   * <code>string node_location = 8;</code>
   *
   * @return The nodeLocation.
   */
  java.lang.String getNodeLocation();
  /**
   *
   *
   * <pre>
   * Name of the Google Distributed Cloud Edge zone where this node pool will be
   * created. For example: `us-central1-edge-customer-a`.
   * </pre>
   *
   * <code>string node_location = 8;</code>
   *
   * @return The bytes for nodeLocation.
   */
  com.google.protobuf.ByteString getNodeLocationBytes();

  /**
   *
   *
   * <pre>
   * Required. The number of nodes in the pool.
   * </pre>
   *
   * <code>int32 node_count = 6 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The nodeCount.
   */
  int getNodeCount();

  /**
   *
   *
   * <pre>
   * Only machines matching this filter will be allowed to join the node pool.
   * The filtering language accepts strings like "name=&lt;name&gt;", and is
   * documented in more detail in [AIP-160](https://google.aip.dev/160).
   * </pre>
   *
   * <code>string machine_filter = 7;</code>
   *
   * @return The machineFilter.
   */
  java.lang.String getMachineFilter();
  /**
   *
   *
   * <pre>
   * Only machines matching this filter will be allowed to join the node pool.
   * The filtering language accepts strings like "name=&lt;name&gt;", and is
   * documented in more detail in [AIP-160](https://google.aip.dev/160).
   * </pre>
   *
   * <code>string machine_filter = 7;</code>
   *
   * @return The bytes for machineFilter.
   */
  com.google.protobuf.ByteString getMachineFilterBytes();

  /**
   *
   *
   * <pre>
   * Optional. Local disk encryption options. This field is only used when enabling CMEK
   * support.
   * </pre>
   *
   * <code>
   * .google.cloud.edgecontainer.v1.NodePool.LocalDiskEncryption local_disk_encryption = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the localDiskEncryption field is set.
   */
  boolean hasLocalDiskEncryption();
  /**
   *
   *
   * <pre>
   * Optional. Local disk encryption options. This field is only used when enabling CMEK
   * support.
   * </pre>
   *
   * <code>
   * .google.cloud.edgecontainer.v1.NodePool.LocalDiskEncryption local_disk_encryption = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The localDiskEncryption.
   */
  com.google.cloud.edgecontainer.v1.NodePool.LocalDiskEncryption getLocalDiskEncryption();
  /**
   *
   *
   * <pre>
   * Optional. Local disk encryption options. This field is only used when enabling CMEK
   * support.
   * </pre>
   *
   * <code>
   * .google.cloud.edgecontainer.v1.NodePool.LocalDiskEncryption local_disk_encryption = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.cloud.edgecontainer.v1.NodePool.LocalDiskEncryptionOrBuilder
      getLocalDiskEncryptionOrBuilder();
}
