/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/edgecontainer/v1/resources.proto

package com.google.cloud.edgecontainer.v1;

/**
 *
 *
 * <pre>
 * A VPN connection .
 * </pre>
 *
 * Protobuf type {@code google.cloud.edgecontainer.v1.VpnConnection}
 */
public final class VpnConnection extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.edgecontainer.v1.VpnConnection)
    VpnConnectionOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use VpnConnection.newBuilder() to construct.
  private VpnConnection(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private VpnConnection() {
    name_ = "";
    natGatewayIp_ = "";
    bgpRoutingMode_ = 0;
    cluster_ = "";
    vpc_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new VpnConnection();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.edgecontainer.v1.ResourcesProto
        .internal_static_google_cloud_edgecontainer_v1_VpnConnection_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 4:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.edgecontainer.v1.ResourcesProto
        .internal_static_google_cloud_edgecontainer_v1_VpnConnection_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.edgecontainer.v1.VpnConnection.class,
            com.google.cloud.edgecontainer.v1.VpnConnection.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Routing mode.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.edgecontainer.v1.VpnConnection.BgpRoutingMode}
   */
  public enum BgpRoutingMode implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unknown.
     * </pre>
     *
     * <code>BGP_ROUTING_MODE_UNSPECIFIED = 0;</code>
     */
    BGP_ROUTING_MODE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Regional mode.
     * </pre>
     *
     * <code>REGIONAL = 1;</code>
     */
    REGIONAL(1),
    /**
     *
     *
     * <pre>
     * Global mode.
     * </pre>
     *
     * <code>GLOBAL = 2;</code>
     */
    GLOBAL(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unknown.
     * </pre>
     *
     * <code>BGP_ROUTING_MODE_UNSPECIFIED = 0;</code>
     */
    public static final int BGP_ROUTING_MODE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Regional mode.
     * </pre>
     *
     * <code>REGIONAL = 1;</code>
     */
    public static final int REGIONAL_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Global mode.
     * </pre>
     *
     * <code>GLOBAL = 2;</code>
     */
    public static final int GLOBAL_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static BgpRoutingMode valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static BgpRoutingMode forNumber(int value) {
      switch (value) {
        case 0:
          return BGP_ROUTING_MODE_UNSPECIFIED;
        case 1:
          return REGIONAL;
        case 2:
          return GLOBAL;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<BgpRoutingMode> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<BgpRoutingMode> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<BgpRoutingMode>() {
          public BgpRoutingMode findValueByNumber(int number) {
            return BgpRoutingMode.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.edgecontainer.v1.VpnConnection.getDescriptor().getEnumTypes().get(0);
    }

    private static final BgpRoutingMode[] VALUES = values();

    public static BgpRoutingMode valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private BgpRoutingMode(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.edgecontainer.v1.VpnConnection.BgpRoutingMode)
  }

  public interface VpcProjectOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.edgecontainer.v1.VpnConnection.VpcProject)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The project of the VPC to connect to. If not specified, it is the same as
     * the cluster project.
     * </pre>
     *
     * <code>string project_id = 1;</code>
     *
     * @return The projectId.
     */
    java.lang.String getProjectId();
    /**
     *
     *
     * <pre>
     * The project of the VPC to connect to. If not specified, it is the same as
     * the cluster project.
     * </pre>
     *
     * <code>string project_id = 1;</code>
     *
     * @return The bytes for projectId.
     */
    com.google.protobuf.ByteString getProjectIdBytes();

    /**
     *
     *
     * <pre>
     * Optional. The service account in the VPC project configured by user. It is used to
     * create/delete Cloud Router and Cloud HA VPNs for VPN connection. If this
     * SA is changed during/after a VPN connection is created, you need to
     * remove the Cloud Router and Cloud VPN resources in |project_id|.
     * It is in the form of
     * service-{project_number}&#64;gcp-sa-edgecontainer.iam.gserviceaccount.com.
     * </pre>
     *
     * <code>string service_account = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The serviceAccount.
     */
    java.lang.String getServiceAccount();
    /**
     *
     *
     * <pre>
     * Optional. The service account in the VPC project configured by user. It is used to
     * create/delete Cloud Router and Cloud HA VPNs for VPN connection. If this
     * SA is changed during/after a VPN connection is created, you need to
     * remove the Cloud Router and Cloud VPN resources in |project_id|.
     * It is in the form of
     * service-{project_number}&#64;gcp-sa-edgecontainer.iam.gserviceaccount.com.
     * </pre>
     *
     * <code>string service_account = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for serviceAccount.
     */
    com.google.protobuf.ByteString getServiceAccountBytes();
  }
  /**
   *
   *
   * <pre>
   * Project detail of the VPC network.
   * </pre>
   *
   * Protobuf type {@code google.cloud.edgecontainer.v1.VpnConnection.VpcProject}
   */
  public static final class VpcProject extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.edgecontainer.v1.VpnConnection.VpcProject)
      VpcProjectOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use VpcProject.newBuilder() to construct.
    private VpcProject(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private VpcProject() {
      projectId_ = "";
      serviceAccount_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new VpcProject();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.edgecontainer.v1.ResourcesProto
          .internal_static_google_cloud_edgecontainer_v1_VpnConnection_VpcProject_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.edgecontainer.v1.ResourcesProto
          .internal_static_google_cloud_edgecontainer_v1_VpnConnection_VpcProject_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.edgecontainer.v1.VpnConnection.VpcProject.class,
              com.google.cloud.edgecontainer.v1.VpnConnection.VpcProject.Builder.class);
    }

    public static final int PROJECT_ID_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object projectId_ = "";
    /**
     *
     *
     * <pre>
     * The project of the VPC to connect to. If not specified, it is the same as
     * the cluster project.
     * </pre>
     *
     * <code>string project_id = 1;</code>
     *
     * @return The projectId.
     */
    @java.lang.Override
    public java.lang.String getProjectId() {
      java.lang.Object ref = projectId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        projectId_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The project of the VPC to connect to. If not specified, it is the same as
     * the cluster project.
     * </pre>
     *
     * <code>string project_id = 1;</code>
     *
     * @return The bytes for projectId.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getProjectIdBytes() {
      java.lang.Object ref = projectId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        projectId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int SERVICE_ACCOUNT_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object serviceAccount_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The service account in the VPC project configured by user. It is used to
     * create/delete Cloud Router and Cloud HA VPNs for VPN connection. If this
     * SA is changed during/after a VPN connection is created, you need to
     * remove the Cloud Router and Cloud VPN resources in |project_id|.
     * It is in the form of
     * service-{project_number}&#64;gcp-sa-edgecontainer.iam.gserviceaccount.com.
     * </pre>
     *
     * <code>string service_account = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The serviceAccount.
     */
    @java.lang.Override
    public java.lang.String getServiceAccount() {
      java.lang.Object ref = serviceAccount_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        serviceAccount_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The service account in the VPC project configured by user. It is used to
     * create/delete Cloud Router and Cloud HA VPNs for VPN connection. If this
     * SA is changed during/after a VPN connection is created, you need to
     * remove the Cloud Router and Cloud VPN resources in |project_id|.
     * It is in the form of
     * service-{project_number}&#64;gcp-sa-edgecontainer.iam.gserviceaccount.com.
     * </pre>
     *
     * <code>string service_account = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for serviceAccount.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getServiceAccountBytes() {
      java.lang.Object ref = serviceAccount_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        serviceAccount_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(projectId_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, projectId_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceAccount_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, serviceAccount_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(projectId_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, projectId_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceAccount_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, serviceAccount_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.edgecontainer.v1.VpnConnection.VpcProject)) {
        return super.equals(obj);
      }
      com.google.cloud.edgecontainer.v1.VpnConnection.VpcProject other =
          (com.google.cloud.edgecontainer.v1.VpnConnection.VpcProject) obj;

      if (!getProjectId().equals(other.getProjectId())) return false;
      if (!getServiceAccount().equals(other.getServiceAccount())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + PROJECT_ID_FIELD_NUMBER;
      hash = (53 * hash) + getProjectId().hashCode();
      hash = (37 * hash) + SERVICE_ACCOUNT_FIELD_NUMBER;
      hash = (53 * hash) + getServiceAccount().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.edgecontainer.v1.VpnConnection.VpcProject parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.edgecontainer.v1.VpnConnection.VpcProject parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.edgecontainer.v1.VpnConnection.VpcProject parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.edgecontainer.v1.VpnConnection.VpcProject parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.edgecontainer.v1.VpnConnection.VpcProject parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.edgecontainer.v1.VpnConnection.VpcProject parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.edgecontainer.v1.VpnConnection.VpcProject parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.edgecontainer.v1.VpnConnection.VpcProject parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.edgecontainer.v1.VpnConnection.VpcProject parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.edgecontainer.v1.VpnConnection.VpcProject parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.edgecontainer.v1.VpnConnection.VpcProject parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.edgecontainer.v1.VpnConnection.VpcProject parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.edgecontainer.v1.VpnConnection.VpcProject prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Project detail of the VPC network.
     * </pre>
     *
     * Protobuf type {@code google.cloud.edgecontainer.v1.VpnConnection.VpcProject}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.edgecontainer.v1.VpnConnection.VpcProject)
        com.google.cloud.edgecontainer.v1.VpnConnection.VpcProjectOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.edgecontainer.v1.ResourcesProto
            .internal_static_google_cloud_edgecontainer_v1_VpnConnection_VpcProject_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.edgecontainer.v1.ResourcesProto
            .internal_static_google_cloud_edgecontainer_v1_VpnConnection_VpcProject_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.edgecontainer.v1.VpnConnection.VpcProject.class,
                com.google.cloud.edgecontainer.v1.VpnConnection.VpcProject.Builder.class);
      }

      // Construct using com.google.cloud.edgecontainer.v1.VpnConnection.VpcProject.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        projectId_ = "";
        serviceAccount_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.edgecontainer.v1.ResourcesProto
            .internal_static_google_cloud_edgecontainer_v1_VpnConnection_VpcProject_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.edgecontainer.v1.VpnConnection.VpcProject
          getDefaultInstanceForType() {
        return com.google.cloud.edgecontainer.v1.VpnConnection.VpcProject.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.edgecontainer.v1.VpnConnection.VpcProject build() {
        com.google.cloud.edgecontainer.v1.VpnConnection.VpcProject result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.edgecontainer.v1.VpnConnection.VpcProject buildPartial() {
        com.google.cloud.edgecontainer.v1.VpnConnection.VpcProject result =
            new com.google.cloud.edgecontainer.v1.VpnConnection.VpcProject(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.edgecontainer.v1.VpnConnection.VpcProject result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.projectId_ = projectId_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.serviceAccount_ = serviceAccount_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.edgecontainer.v1.VpnConnection.VpcProject) {
          return mergeFrom((com.google.cloud.edgecontainer.v1.VpnConnection.VpcProject) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.edgecontainer.v1.VpnConnection.VpcProject other) {
        if (other
            == com.google.cloud.edgecontainer.v1.VpnConnection.VpcProject.getDefaultInstance())
          return this;
        if (!other.getProjectId().isEmpty()) {
          projectId_ = other.projectId_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getServiceAccount().isEmpty()) {
          serviceAccount_ = other.serviceAccount_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  projectId_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  serviceAccount_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object projectId_ = "";
      /**
       *
       *
       * <pre>
       * The project of the VPC to connect to. If not specified, it is the same as
       * the cluster project.
       * </pre>
       *
       * <code>string project_id = 1;</code>
       *
       * @return The projectId.
       */
      public java.lang.String getProjectId() {
        java.lang.Object ref = projectId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          projectId_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The project of the VPC to connect to. If not specified, it is the same as
       * the cluster project.
       * </pre>
       *
       * <code>string project_id = 1;</code>
       *
       * @return The bytes for projectId.
       */
      public com.google.protobuf.ByteString getProjectIdBytes() {
        java.lang.Object ref = projectId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          projectId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The project of the VPC to connect to. If not specified, it is the same as
       * the cluster project.
       * </pre>
       *
       * <code>string project_id = 1;</code>
       *
       * @param value The projectId to set.
       * @return This builder for chaining.
       */
      public Builder setProjectId(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        projectId_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The project of the VPC to connect to. If not specified, it is the same as
       * the cluster project.
       * </pre>
       *
       * <code>string project_id = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearProjectId() {
        projectId_ = getDefaultInstance().getProjectId();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The project of the VPC to connect to. If not specified, it is the same as
       * the cluster project.
       * </pre>
       *
       * <code>string project_id = 1;</code>
       *
       * @param value The bytes for projectId to set.
       * @return This builder for chaining.
       */
      public Builder setProjectIdBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        projectId_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object serviceAccount_ = "";
      /**
       *
       *
       * <pre>
       * Optional. The service account in the VPC project configured by user. It is used to
       * create/delete Cloud Router and Cloud HA VPNs for VPN connection. If this
       * SA is changed during/after a VPN connection is created, you need to
       * remove the Cloud Router and Cloud VPN resources in |project_id|.
       * It is in the form of
       * service-{project_number}&#64;gcp-sa-edgecontainer.iam.gserviceaccount.com.
       * </pre>
       *
       * <code>string service_account = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The serviceAccount.
       */
      public java.lang.String getServiceAccount() {
        java.lang.Object ref = serviceAccount_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          serviceAccount_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The service account in the VPC project configured by user. It is used to
       * create/delete Cloud Router and Cloud HA VPNs for VPN connection. If this
       * SA is changed during/after a VPN connection is created, you need to
       * remove the Cloud Router and Cloud VPN resources in |project_id|.
       * It is in the form of
       * service-{project_number}&#64;gcp-sa-edgecontainer.iam.gserviceaccount.com.
       * </pre>
       *
       * <code>string service_account = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for serviceAccount.
       */
      public com.google.protobuf.ByteString getServiceAccountBytes() {
        java.lang.Object ref = serviceAccount_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          serviceAccount_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The service account in the VPC project configured by user. It is used to
       * create/delete Cloud Router and Cloud HA VPNs for VPN connection. If this
       * SA is changed during/after a VPN connection is created, you need to
       * remove the Cloud Router and Cloud VPN resources in |project_id|.
       * It is in the form of
       * service-{project_number}&#64;gcp-sa-edgecontainer.iam.gserviceaccount.com.
       * </pre>
       *
       * <code>string service_account = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The serviceAccount to set.
       * @return This builder for chaining.
       */
      public Builder setServiceAccount(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        serviceAccount_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The service account in the VPC project configured by user. It is used to
       * create/delete Cloud Router and Cloud HA VPNs for VPN connection. If this
       * SA is changed during/after a VPN connection is created, you need to
       * remove the Cloud Router and Cloud VPN resources in |project_id|.
       * It is in the form of
       * service-{project_number}&#64;gcp-sa-edgecontainer.iam.gserviceaccount.com.
       * </pre>
       *
       * <code>string service_account = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearServiceAccount() {
        serviceAccount_ = getDefaultInstance().getServiceAccount();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The service account in the VPC project configured by user. It is used to
       * create/delete Cloud Router and Cloud HA VPNs for VPN connection. If this
       * SA is changed during/after a VPN connection is created, you need to
       * remove the Cloud Router and Cloud VPN resources in |project_id|.
       * It is in the form of
       * service-{project_number}&#64;gcp-sa-edgecontainer.iam.gserviceaccount.com.
       * </pre>
       *
       * <code>string service_account = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes for serviceAccount to set.
       * @return This builder for chaining.
       */
      public Builder setServiceAccountBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        serviceAccount_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.edgecontainer.v1.VpnConnection.VpcProject)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.edgecontainer.v1.VpnConnection.VpcProject)
    private static final com.google.cloud.edgecontainer.v1.VpnConnection.VpcProject
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.edgecontainer.v1.VpnConnection.VpcProject();
    }

    public static com.google.cloud.edgecontainer.v1.VpnConnection.VpcProject getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<VpcProject> PARSER =
        new com.google.protobuf.AbstractParser<VpcProject>() {
          @java.lang.Override
          public VpcProject parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<VpcProject> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<VpcProject> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.edgecontainer.v1.VpnConnection.VpcProject getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface DetailsOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.edgecontainer.v1.VpnConnection.Details)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The state of this connection.
     * </pre>
     *
     * <code>.google.cloud.edgecontainer.v1.VpnConnection.Details.State state = 1;</code>
     *
     * @return The enum numeric value on the wire for state.
     */
    int getStateValue();
    /**
     *
     *
     * <pre>
     * The state of this connection.
     * </pre>
     *
     * <code>.google.cloud.edgecontainer.v1.VpnConnection.Details.State state = 1;</code>
     *
     * @return The state.
     */
    com.google.cloud.edgecontainer.v1.VpnConnection.Details.State getState();

    /**
     *
     *
     * <pre>
     * The error message. This is only populated when state=ERROR.
     * </pre>
     *
     * <code>string error = 2;</code>
     *
     * @return The error.
     */
    java.lang.String getError();
    /**
     *
     *
     * <pre>
     * The error message. This is only populated when state=ERROR.
     * </pre>
     *
     * <code>string error = 2;</code>
     *
     * @return The bytes for error.
     */
    com.google.protobuf.ByteString getErrorBytes();

    /**
     *
     *
     * <pre>
     * The Cloud Router info.
     * </pre>
     *
     * <code>.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudRouter cloud_router = 3;
     * </code>
     *
     * @return Whether the cloudRouter field is set.
     */
    boolean hasCloudRouter();
    /**
     *
     *
     * <pre>
     * The Cloud Router info.
     * </pre>
     *
     * <code>.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudRouter cloud_router = 3;
     * </code>
     *
     * @return The cloudRouter.
     */
    com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudRouter getCloudRouter();
    /**
     *
     *
     * <pre>
     * The Cloud Router info.
     * </pre>
     *
     * <code>.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudRouter cloud_router = 3;
     * </code>
     */
    com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudRouterOrBuilder
        getCloudRouterOrBuilder();

    /**
     *
     *
     * <pre>
     * Each connection has multiple Cloud VPN gateways.
     * </pre>
     *
     * <code>repeated .google.cloud.edgecontainer.v1.VpnConnection.Details.CloudVpn cloud_vpns = 4;
     * </code>
     */
    java.util.List<com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudVpn>
        getCloudVpnsList();
    /**
     *
     *
     * <pre>
     * Each connection has multiple Cloud VPN gateways.
     * </pre>
     *
     * <code>repeated .google.cloud.edgecontainer.v1.VpnConnection.Details.CloudVpn cloud_vpns = 4;
     * </code>
     */
    com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudVpn getCloudVpns(int index);
    /**
     *
     *
     * <pre>
     * Each connection has multiple Cloud VPN gateways.
     * </pre>
     *
     * <code>repeated .google.cloud.edgecontainer.v1.VpnConnection.Details.CloudVpn cloud_vpns = 4;
     * </code>
     */
    int getCloudVpnsCount();
    /**
     *
     *
     * <pre>
     * Each connection has multiple Cloud VPN gateways.
     * </pre>
     *
     * <code>repeated .google.cloud.edgecontainer.v1.VpnConnection.Details.CloudVpn cloud_vpns = 4;
     * </code>
     */
    java.util.List<
            ? extends com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudVpnOrBuilder>
        getCloudVpnsOrBuilderList();
    /**
     *
     *
     * <pre>
     * Each connection has multiple Cloud VPN gateways.
     * </pre>
     *
     * <code>repeated .google.cloud.edgecontainer.v1.VpnConnection.Details.CloudVpn cloud_vpns = 4;
     * </code>
     */
    com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudVpnOrBuilder getCloudVpnsOrBuilder(
        int index);
  }
  /**
   *
   *
   * <pre>
   * The created connection details.
   * </pre>
   *
   * Protobuf type {@code google.cloud.edgecontainer.v1.VpnConnection.Details}
   */
  public static final class Details extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.edgecontainer.v1.VpnConnection.Details)
      DetailsOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Details.newBuilder() to construct.
    private Details(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Details() {
      state_ = 0;
      error_ = "";
      cloudVpns_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Details();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.edgecontainer.v1.ResourcesProto
          .internal_static_google_cloud_edgecontainer_v1_VpnConnection_Details_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.edgecontainer.v1.ResourcesProto
          .internal_static_google_cloud_edgecontainer_v1_VpnConnection_Details_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.edgecontainer.v1.VpnConnection.Details.class,
              com.google.cloud.edgecontainer.v1.VpnConnection.Details.Builder.class);
    }

    /**
     *
     *
     * <pre>
     * The current connection state.
     * </pre>
     *
     * Protobuf enum {@code google.cloud.edgecontainer.v1.VpnConnection.Details.State}
     */
    public enum State implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Unknown.
       * </pre>
       *
       * <code>STATE_UNSPECIFIED = 0;</code>
       */
      STATE_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * Connected.
       * </pre>
       *
       * <code>STATE_CONNECTED = 1;</code>
       */
      STATE_CONNECTED(1),
      /**
       *
       *
       * <pre>
       * Still connecting.
       * </pre>
       *
       * <code>STATE_CONNECTING = 2;</code>
       */
      STATE_CONNECTING(2),
      /**
       *
       *
       * <pre>
       * Error occurred.
       * </pre>
       *
       * <code>STATE_ERROR = 3;</code>
       */
      STATE_ERROR(3),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Unknown.
       * </pre>
       *
       * <code>STATE_UNSPECIFIED = 0;</code>
       */
      public static final int STATE_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * Connected.
       * </pre>
       *
       * <code>STATE_CONNECTED = 1;</code>
       */
      public static final int STATE_CONNECTED_VALUE = 1;
      /**
       *
       *
       * <pre>
       * Still connecting.
       * </pre>
       *
       * <code>STATE_CONNECTING = 2;</code>
       */
      public static final int STATE_CONNECTING_VALUE = 2;
      /**
       *
       *
       * <pre>
       * Error occurred.
       * </pre>
       *
       * <code>STATE_ERROR = 3;</code>
       */
      public static final int STATE_ERROR_VALUE = 3;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static State valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static State forNumber(int value) {
        switch (value) {
          case 0:
            return STATE_UNSPECIFIED;
          case 1:
            return STATE_CONNECTED;
          case 2:
            return STATE_CONNECTING;
          case 3:
            return STATE_ERROR;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<State>() {
            public State findValueByNumber(int number) {
              return State.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.cloud.edgecontainer.v1.VpnConnection.Details.getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final State[] VALUES = values();

      public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private State(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.cloud.edgecontainer.v1.VpnConnection.Details.State)
    }

    public interface CloudRouterOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.edgecontainer.v1.VpnConnection.Details.CloudRouter)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * The created Cloud Router name.
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @return The name.
       */
      java.lang.String getName();
      /**
       *
       *
       * <pre>
       * The created Cloud Router name.
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @return The bytes for name.
       */
      com.google.protobuf.ByteString getNameBytes();
    }
    /**
     *
     *
     * <pre>
     * The Cloud Router info.
     * </pre>
     *
     * Protobuf type {@code google.cloud.edgecontainer.v1.VpnConnection.Details.CloudRouter}
     */
    public static final class CloudRouter extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.edgecontainer.v1.VpnConnection.Details.CloudRouter)
        CloudRouterOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use CloudRouter.newBuilder() to construct.
      private CloudRouter(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private CloudRouter() {
        name_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new CloudRouter();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.edgecontainer.v1.ResourcesProto
            .internal_static_google_cloud_edgecontainer_v1_VpnConnection_Details_CloudRouter_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.edgecontainer.v1.ResourcesProto
            .internal_static_google_cloud_edgecontainer_v1_VpnConnection_Details_CloudRouter_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudRouter.class,
                com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudRouter.Builder.class);
      }

      public static final int NAME_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private volatile java.lang.Object name_ = "";
      /**
       *
       *
       * <pre>
       * The created Cloud Router name.
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @return The name.
       */
      @java.lang.Override
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          name_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * The created Cloud Router name.
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @return The bytes for name.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj instanceof com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudRouter)) {
          return super.equals(obj);
        }
        com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudRouter other =
            (com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudRouter) obj;

        if (!getName().equals(other.getName())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + NAME_FIELD_NUMBER;
        hash = (53 * hash) + getName().hashCode();
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudRouter parseFrom(
          java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudRouter parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudRouter parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudRouter parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudRouter parseFrom(
          byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudRouter parseFrom(
          byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudRouter parseFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudRouter parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudRouter
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudRouter
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudRouter parseFrom(
          com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudRouter parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudRouter prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * The Cloud Router info.
       * </pre>
       *
       * Protobuf type {@code google.cloud.edgecontainer.v1.VpnConnection.Details.CloudRouter}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.edgecontainer.v1.VpnConnection.Details.CloudRouter)
          com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudRouterOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.edgecontainer.v1.ResourcesProto
              .internal_static_google_cloud_edgecontainer_v1_VpnConnection_Details_CloudRouter_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.edgecontainer.v1.ResourcesProto
              .internal_static_google_cloud_edgecontainer_v1_VpnConnection_Details_CloudRouter_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudRouter.class,
                  com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudRouter.Builder
                      .class);
        }

        // Construct using
        // com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudRouter.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          name_ = "";
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.edgecontainer.v1.ResourcesProto
              .internal_static_google_cloud_edgecontainer_v1_VpnConnection_Details_CloudRouter_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudRouter
            getDefaultInstanceForType() {
          return com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudRouter
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudRouter build() {
          com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudRouter result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudRouter buildPartial() {
          com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudRouter result =
              new com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudRouter(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudRouter result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.name_ = name_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudRouter) {
            return mergeFrom(
                (com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudRouter) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudRouter other) {
          if (other
              == com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudRouter
                  .getDefaultInstance()) return this;
          if (!other.getName().isEmpty()) {
            name_ = other.name_;
            bitField0_ |= 0x00000001;
            onChanged();
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    name_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.lang.Object name_ = "";
        /**
         *
         *
         * <pre>
         * The created Cloud Router name.
         * </pre>
         *
         * <code>string name = 1;</code>
         *
         * @return The name.
         */
        public java.lang.String getName() {
          java.lang.Object ref = name_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            name_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * The created Cloud Router name.
         * </pre>
         *
         * <code>string name = 1;</code>
         *
         * @return The bytes for name.
         */
        public com.google.protobuf.ByteString getNameBytes() {
          java.lang.Object ref = name_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            name_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * The created Cloud Router name.
         * </pre>
         *
         * <code>string name = 1;</code>
         *
         * @param value The name to set.
         * @return This builder for chaining.
         */
        public Builder setName(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          name_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The created Cloud Router name.
         * </pre>
         *
         * <code>string name = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearName() {
          name_ = getDefaultInstance().getName();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The created Cloud Router name.
         * </pre>
         *
         * <code>string name = 1;</code>
         *
         * @param value The bytes for name to set.
         * @return This builder for chaining.
         */
        public Builder setNameBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          name_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.edgecontainer.v1.VpnConnection.Details.CloudRouter)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.edgecontainer.v1.VpnConnection.Details.CloudRouter)
      private static final com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudRouter
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudRouter();
      }

      public static com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudRouter
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<CloudRouter> PARSER =
          new com.google.protobuf.AbstractParser<CloudRouter>() {
            @java.lang.Override
            public CloudRouter parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<CloudRouter> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<CloudRouter> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudRouter
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface CloudVpnOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.edgecontainer.v1.VpnConnection.Details.CloudVpn)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * The created Cloud VPN gateway name.
       * </pre>
       *
       * <code>string gateway = 1;</code>
       *
       * @return The gateway.
       */
      java.lang.String getGateway();
      /**
       *
       *
       * <pre>
       * The created Cloud VPN gateway name.
       * </pre>
       *
       * <code>string gateway = 1;</code>
       *
       * @return The bytes for gateway.
       */
      com.google.protobuf.ByteString getGatewayBytes();
    }
    /**
     *
     *
     * <pre>
     * The Cloud VPN info.
     * </pre>
     *
     * Protobuf type {@code google.cloud.edgecontainer.v1.VpnConnection.Details.CloudVpn}
     */
    public static final class CloudVpn extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.edgecontainer.v1.VpnConnection.Details.CloudVpn)
        CloudVpnOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use CloudVpn.newBuilder() to construct.
      private CloudVpn(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private CloudVpn() {
        gateway_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new CloudVpn();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.edgecontainer.v1.ResourcesProto
            .internal_static_google_cloud_edgecontainer_v1_VpnConnection_Details_CloudVpn_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.edgecontainer.v1.ResourcesProto
            .internal_static_google_cloud_edgecontainer_v1_VpnConnection_Details_CloudVpn_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudVpn.class,
                com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudVpn.Builder.class);
      }

      public static final int GATEWAY_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private volatile java.lang.Object gateway_ = "";
      /**
       *
       *
       * <pre>
       * The created Cloud VPN gateway name.
       * </pre>
       *
       * <code>string gateway = 1;</code>
       *
       * @return The gateway.
       */
      @java.lang.Override
      public java.lang.String getGateway() {
        java.lang.Object ref = gateway_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          gateway_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * The created Cloud VPN gateway name.
       * </pre>
       *
       * <code>string gateway = 1;</code>
       *
       * @return The bytes for gateway.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getGatewayBytes() {
        java.lang.Object ref = gateway_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          gateway_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(gateway_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, gateway_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(gateway_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, gateway_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj instanceof com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudVpn)) {
          return super.equals(obj);
        }
        com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudVpn other =
            (com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudVpn) obj;

        if (!getGateway().equals(other.getGateway())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + GATEWAY_FIELD_NUMBER;
        hash = (53 * hash) + getGateway().hashCode();
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudVpn parseFrom(
          java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudVpn parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudVpn parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudVpn parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudVpn parseFrom(
          byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudVpn parseFrom(
          byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudVpn parseFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudVpn parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudVpn
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudVpn
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudVpn parseFrom(
          com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudVpn parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudVpn prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * The Cloud VPN info.
       * </pre>
       *
       * Protobuf type {@code google.cloud.edgecontainer.v1.VpnConnection.Details.CloudVpn}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.edgecontainer.v1.VpnConnection.Details.CloudVpn)
          com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudVpnOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.edgecontainer.v1.ResourcesProto
              .internal_static_google_cloud_edgecontainer_v1_VpnConnection_Details_CloudVpn_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.edgecontainer.v1.ResourcesProto
              .internal_static_google_cloud_edgecontainer_v1_VpnConnection_Details_CloudVpn_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudVpn.class,
                  com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudVpn.Builder.class);
        }

        // Construct using
        // com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudVpn.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          gateway_ = "";
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.edgecontainer.v1.ResourcesProto
              .internal_static_google_cloud_edgecontainer_v1_VpnConnection_Details_CloudVpn_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudVpn
            getDefaultInstanceForType() {
          return com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudVpn
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudVpn build() {
          com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudVpn result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudVpn buildPartial() {
          com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudVpn result =
              new com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudVpn(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudVpn result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.gateway_ = gateway_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudVpn) {
            return mergeFrom(
                (com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudVpn) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudVpn other) {
          if (other
              == com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudVpn
                  .getDefaultInstance()) return this;
          if (!other.getGateway().isEmpty()) {
            gateway_ = other.gateway_;
            bitField0_ |= 0x00000001;
            onChanged();
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    gateway_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.lang.Object gateway_ = "";
        /**
         *
         *
         * <pre>
         * The created Cloud VPN gateway name.
         * </pre>
         *
         * <code>string gateway = 1;</code>
         *
         * @return The gateway.
         */
        public java.lang.String getGateway() {
          java.lang.Object ref = gateway_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            gateway_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * The created Cloud VPN gateway name.
         * </pre>
         *
         * <code>string gateway = 1;</code>
         *
         * @return The bytes for gateway.
         */
        public com.google.protobuf.ByteString getGatewayBytes() {
          java.lang.Object ref = gateway_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            gateway_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * The created Cloud VPN gateway name.
         * </pre>
         *
         * <code>string gateway = 1;</code>
         *
         * @param value The gateway to set.
         * @return This builder for chaining.
         */
        public Builder setGateway(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          gateway_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The created Cloud VPN gateway name.
         * </pre>
         *
         * <code>string gateway = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearGateway() {
          gateway_ = getDefaultInstance().getGateway();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The created Cloud VPN gateway name.
         * </pre>
         *
         * <code>string gateway = 1;</code>
         *
         * @param value The bytes for gateway to set.
         * @return This builder for chaining.
         */
        public Builder setGatewayBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          gateway_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.edgecontainer.v1.VpnConnection.Details.CloudVpn)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.edgecontainer.v1.VpnConnection.Details.CloudVpn)
      private static final com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudVpn
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE = new com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudVpn();
      }

      public static com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudVpn
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<CloudVpn> PARSER =
          new com.google.protobuf.AbstractParser<CloudVpn>() {
            @java.lang.Override
            public CloudVpn parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<CloudVpn> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<CloudVpn> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudVpn
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public static final int STATE_FIELD_NUMBER = 1;
    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * The state of this connection.
     * </pre>
     *
     * <code>.google.cloud.edgecontainer.v1.VpnConnection.Details.State state = 1;</code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * The state of this connection.
     * </pre>
     *
     * <code>.google.cloud.edgecontainer.v1.VpnConnection.Details.State state = 1;</code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.edgecontainer.v1.VpnConnection.Details.State getState() {
      com.google.cloud.edgecontainer.v1.VpnConnection.Details.State result =
          com.google.cloud.edgecontainer.v1.VpnConnection.Details.State.forNumber(state_);
      return result == null
          ? com.google.cloud.edgecontainer.v1.VpnConnection.Details.State.UNRECOGNIZED
          : result;
    }

    public static final int ERROR_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object error_ = "";
    /**
     *
     *
     * <pre>
     * The error message. This is only populated when state=ERROR.
     * </pre>
     *
     * <code>string error = 2;</code>
     *
     * @return The error.
     */
    @java.lang.Override
    public java.lang.String getError() {
      java.lang.Object ref = error_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        error_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The error message. This is only populated when state=ERROR.
     * </pre>
     *
     * <code>string error = 2;</code>
     *
     * @return The bytes for error.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getErrorBytes() {
      java.lang.Object ref = error_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        error_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int CLOUD_ROUTER_FIELD_NUMBER = 3;
    private com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudRouter cloudRouter_;
    /**
     *
     *
     * <pre>
     * The Cloud Router info.
     * </pre>
     *
     * <code>.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudRouter cloud_router = 3;
     * </code>
     *
     * @return Whether the cloudRouter field is set.
     */
    @java.lang.Override
    public boolean hasCloudRouter() {
      return cloudRouter_ != null;
    }
    /**
     *
     *
     * <pre>
     * The Cloud Router info.
     * </pre>
     *
     * <code>.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudRouter cloud_router = 3;
     * </code>
     *
     * @return The cloudRouter.
     */
    @java.lang.Override
    public com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudRouter getCloudRouter() {
      return cloudRouter_ == null
          ? com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudRouter.getDefaultInstance()
          : cloudRouter_;
    }
    /**
     *
     *
     * <pre>
     * The Cloud Router info.
     * </pre>
     *
     * <code>.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudRouter cloud_router = 3;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudRouterOrBuilder
        getCloudRouterOrBuilder() {
      return cloudRouter_ == null
          ? com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudRouter.getDefaultInstance()
          : cloudRouter_;
    }

    public static final int CLOUD_VPNS_FIELD_NUMBER = 4;

    @SuppressWarnings("serial")
    private java.util.List<com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudVpn>
        cloudVpns_;
    /**
     *
     *
     * <pre>
     * Each connection has multiple Cloud VPN gateways.
     * </pre>
     *
     * <code>repeated .google.cloud.edgecontainer.v1.VpnConnection.Details.CloudVpn cloud_vpns = 4;
     * </code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudVpn>
        getCloudVpnsList() {
      return cloudVpns_;
    }
    /**
     *
     *
     * <pre>
     * Each connection has multiple Cloud VPN gateways.
     * </pre>
     *
     * <code>repeated .google.cloud.edgecontainer.v1.VpnConnection.Details.CloudVpn cloud_vpns = 4;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudVpnOrBuilder>
        getCloudVpnsOrBuilderList() {
      return cloudVpns_;
    }
    /**
     *
     *
     * <pre>
     * Each connection has multiple Cloud VPN gateways.
     * </pre>
     *
     * <code>repeated .google.cloud.edgecontainer.v1.VpnConnection.Details.CloudVpn cloud_vpns = 4;
     * </code>
     */
    @java.lang.Override
    public int getCloudVpnsCount() {
      return cloudVpns_.size();
    }
    /**
     *
     *
     * <pre>
     * Each connection has multiple Cloud VPN gateways.
     * </pre>
     *
     * <code>repeated .google.cloud.edgecontainer.v1.VpnConnection.Details.CloudVpn cloud_vpns = 4;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudVpn getCloudVpns(
        int index) {
      return cloudVpns_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Each connection has multiple Cloud VPN gateways.
     * </pre>
     *
     * <code>repeated .google.cloud.edgecontainer.v1.VpnConnection.Details.CloudVpn cloud_vpns = 4;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudVpnOrBuilder
        getCloudVpnsOrBuilder(int index) {
      return cloudVpns_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (state_
          != com.google.cloud.edgecontainer.v1.VpnConnection.Details.State.STATE_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(1, state_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(error_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, error_);
      }
      if (cloudRouter_ != null) {
        output.writeMessage(3, getCloudRouter());
      }
      for (int i = 0; i < cloudVpns_.size(); i++) {
        output.writeMessage(4, cloudVpns_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (state_
          != com.google.cloud.edgecontainer.v1.VpnConnection.Details.State.STATE_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, state_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(error_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, error_);
      }
      if (cloudRouter_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getCloudRouter());
      }
      for (int i = 0; i < cloudVpns_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, cloudVpns_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.edgecontainer.v1.VpnConnection.Details)) {
        return super.equals(obj);
      }
      com.google.cloud.edgecontainer.v1.VpnConnection.Details other =
          (com.google.cloud.edgecontainer.v1.VpnConnection.Details) obj;

      if (state_ != other.state_) return false;
      if (!getError().equals(other.getError())) return false;
      if (hasCloudRouter() != other.hasCloudRouter()) return false;
      if (hasCloudRouter()) {
        if (!getCloudRouter().equals(other.getCloudRouter())) return false;
      }
      if (!getCloudVpnsList().equals(other.getCloudVpnsList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + STATE_FIELD_NUMBER;
      hash = (53 * hash) + state_;
      hash = (37 * hash) + ERROR_FIELD_NUMBER;
      hash = (53 * hash) + getError().hashCode();
      if (hasCloudRouter()) {
        hash = (37 * hash) + CLOUD_ROUTER_FIELD_NUMBER;
        hash = (53 * hash) + getCloudRouter().hashCode();
      }
      if (getCloudVpnsCount() > 0) {
        hash = (37 * hash) + CLOUD_VPNS_FIELD_NUMBER;
        hash = (53 * hash) + getCloudVpnsList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.edgecontainer.v1.VpnConnection.Details parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.edgecontainer.v1.VpnConnection.Details parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.edgecontainer.v1.VpnConnection.Details parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.edgecontainer.v1.VpnConnection.Details parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.edgecontainer.v1.VpnConnection.Details parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.edgecontainer.v1.VpnConnection.Details parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.edgecontainer.v1.VpnConnection.Details parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.edgecontainer.v1.VpnConnection.Details parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.edgecontainer.v1.VpnConnection.Details parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.edgecontainer.v1.VpnConnection.Details parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.edgecontainer.v1.VpnConnection.Details parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.edgecontainer.v1.VpnConnection.Details parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.edgecontainer.v1.VpnConnection.Details prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * The created connection details.
     * </pre>
     *
     * Protobuf type {@code google.cloud.edgecontainer.v1.VpnConnection.Details}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.edgecontainer.v1.VpnConnection.Details)
        com.google.cloud.edgecontainer.v1.VpnConnection.DetailsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.edgecontainer.v1.ResourcesProto
            .internal_static_google_cloud_edgecontainer_v1_VpnConnection_Details_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.edgecontainer.v1.ResourcesProto
            .internal_static_google_cloud_edgecontainer_v1_VpnConnection_Details_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.edgecontainer.v1.VpnConnection.Details.class,
                com.google.cloud.edgecontainer.v1.VpnConnection.Details.Builder.class);
      }

      // Construct using com.google.cloud.edgecontainer.v1.VpnConnection.Details.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        state_ = 0;
        error_ = "";
        cloudRouter_ = null;
        if (cloudRouterBuilder_ != null) {
          cloudRouterBuilder_.dispose();
          cloudRouterBuilder_ = null;
        }
        if (cloudVpnsBuilder_ == null) {
          cloudVpns_ = java.util.Collections.emptyList();
        } else {
          cloudVpns_ = null;
          cloudVpnsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000008);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.edgecontainer.v1.ResourcesProto
            .internal_static_google_cloud_edgecontainer_v1_VpnConnection_Details_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.edgecontainer.v1.VpnConnection.Details getDefaultInstanceForType() {
        return com.google.cloud.edgecontainer.v1.VpnConnection.Details.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.edgecontainer.v1.VpnConnection.Details build() {
        com.google.cloud.edgecontainer.v1.VpnConnection.Details result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.edgecontainer.v1.VpnConnection.Details buildPartial() {
        com.google.cloud.edgecontainer.v1.VpnConnection.Details result =
            new com.google.cloud.edgecontainer.v1.VpnConnection.Details(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.edgecontainer.v1.VpnConnection.Details result) {
        if (cloudVpnsBuilder_ == null) {
          if (((bitField0_ & 0x00000008) != 0)) {
            cloudVpns_ = java.util.Collections.unmodifiableList(cloudVpns_);
            bitField0_ = (bitField0_ & ~0x00000008);
          }
          result.cloudVpns_ = cloudVpns_;
        } else {
          result.cloudVpns_ = cloudVpnsBuilder_.build();
        }
      }

      private void buildPartial0(com.google.cloud.edgecontainer.v1.VpnConnection.Details result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.state_ = state_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.error_ = error_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.cloudRouter_ =
              cloudRouterBuilder_ == null ? cloudRouter_ : cloudRouterBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.edgecontainer.v1.VpnConnection.Details) {
          return mergeFrom((com.google.cloud.edgecontainer.v1.VpnConnection.Details) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.edgecontainer.v1.VpnConnection.Details other) {
        if (other == com.google.cloud.edgecontainer.v1.VpnConnection.Details.getDefaultInstance())
          return this;
        if (other.state_ != 0) {
          setStateValue(other.getStateValue());
        }
        if (!other.getError().isEmpty()) {
          error_ = other.error_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (other.hasCloudRouter()) {
          mergeCloudRouter(other.getCloudRouter());
        }
        if (cloudVpnsBuilder_ == null) {
          if (!other.cloudVpns_.isEmpty()) {
            if (cloudVpns_.isEmpty()) {
              cloudVpns_ = other.cloudVpns_;
              bitField0_ = (bitField0_ & ~0x00000008);
            } else {
              ensureCloudVpnsIsMutable();
              cloudVpns_.addAll(other.cloudVpns_);
            }
            onChanged();
          }
        } else {
          if (!other.cloudVpns_.isEmpty()) {
            if (cloudVpnsBuilder_.isEmpty()) {
              cloudVpnsBuilder_.dispose();
              cloudVpnsBuilder_ = null;
              cloudVpns_ = other.cloudVpns_;
              bitField0_ = (bitField0_ & ~0x00000008);
              cloudVpnsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getCloudVpnsFieldBuilder()
                      : null;
            } else {
              cloudVpnsBuilder_.addAllMessages(other.cloudVpns_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  state_ = input.readEnum();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 18:
                {
                  error_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  input.readMessage(getCloudRouterFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              case 34:
                {
                  com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudVpn m =
                      input.readMessage(
                          com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudVpn.parser(),
                          extensionRegistry);
                  if (cloudVpnsBuilder_ == null) {
                    ensureCloudVpnsIsMutable();
                    cloudVpns_.add(m);
                  } else {
                    cloudVpnsBuilder_.addMessage(m);
                  }
                  break;
                } // case 34
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int state_ = 0;
      /**
       *
       *
       * <pre>
       * The state of this connection.
       * </pre>
       *
       * <code>.google.cloud.edgecontainer.v1.VpnConnection.Details.State state = 1;</code>
       *
       * @return The enum numeric value on the wire for state.
       */
      @java.lang.Override
      public int getStateValue() {
        return state_;
      }
      /**
       *
       *
       * <pre>
       * The state of this connection.
       * </pre>
       *
       * <code>.google.cloud.edgecontainer.v1.VpnConnection.Details.State state = 1;</code>
       *
       * @param value The enum numeric value on the wire for state to set.
       * @return This builder for chaining.
       */
      public Builder setStateValue(int value) {
        state_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The state of this connection.
       * </pre>
       *
       * <code>.google.cloud.edgecontainer.v1.VpnConnection.Details.State state = 1;</code>
       *
       * @return The state.
       */
      @java.lang.Override
      public com.google.cloud.edgecontainer.v1.VpnConnection.Details.State getState() {
        com.google.cloud.edgecontainer.v1.VpnConnection.Details.State result =
            com.google.cloud.edgecontainer.v1.VpnConnection.Details.State.forNumber(state_);
        return result == null
            ? com.google.cloud.edgecontainer.v1.VpnConnection.Details.State.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * The state of this connection.
       * </pre>
       *
       * <code>.google.cloud.edgecontainer.v1.VpnConnection.Details.State state = 1;</code>
       *
       * @param value The state to set.
       * @return This builder for chaining.
       */
      public Builder setState(com.google.cloud.edgecontainer.v1.VpnConnection.Details.State value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        state_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The state of this connection.
       * </pre>
       *
       * <code>.google.cloud.edgecontainer.v1.VpnConnection.Details.State state = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearState() {
        bitField0_ = (bitField0_ & ~0x00000001);
        state_ = 0;
        onChanged();
        return this;
      }

      private java.lang.Object error_ = "";
      /**
       *
       *
       * <pre>
       * The error message. This is only populated when state=ERROR.
       * </pre>
       *
       * <code>string error = 2;</code>
       *
       * @return The error.
       */
      public java.lang.String getError() {
        java.lang.Object ref = error_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          error_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The error message. This is only populated when state=ERROR.
       * </pre>
       *
       * <code>string error = 2;</code>
       *
       * @return The bytes for error.
       */
      public com.google.protobuf.ByteString getErrorBytes() {
        java.lang.Object ref = error_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          error_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The error message. This is only populated when state=ERROR.
       * </pre>
       *
       * <code>string error = 2;</code>
       *
       * @param value The error to set.
       * @return This builder for chaining.
       */
      public Builder setError(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        error_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The error message. This is only populated when state=ERROR.
       * </pre>
       *
       * <code>string error = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearError() {
        error_ = getDefaultInstance().getError();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The error message. This is only populated when state=ERROR.
       * </pre>
       *
       * <code>string error = 2;</code>
       *
       * @param value The bytes for error to set.
       * @return This builder for chaining.
       */
      public Builder setErrorBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        error_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudRouter cloudRouter_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudRouter,
              com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudRouter.Builder,
              com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudRouterOrBuilder>
          cloudRouterBuilder_;
      /**
       *
       *
       * <pre>
       * The Cloud Router info.
       * </pre>
       *
       * <code>.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudRouter cloud_router = 3;
       * </code>
       *
       * @return Whether the cloudRouter field is set.
       */
      public boolean hasCloudRouter() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       *
       *
       * <pre>
       * The Cloud Router info.
       * </pre>
       *
       * <code>.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudRouter cloud_router = 3;
       * </code>
       *
       * @return The cloudRouter.
       */
      public com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudRouter getCloudRouter() {
        if (cloudRouterBuilder_ == null) {
          return cloudRouter_ == null
              ? com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudRouter
                  .getDefaultInstance()
              : cloudRouter_;
        } else {
          return cloudRouterBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The Cloud Router info.
       * </pre>
       *
       * <code>.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudRouter cloud_router = 3;
       * </code>
       */
      public Builder setCloudRouter(
          com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudRouter value) {
        if (cloudRouterBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          cloudRouter_ = value;
        } else {
          cloudRouterBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The Cloud Router info.
       * </pre>
       *
       * <code>.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudRouter cloud_router = 3;
       * </code>
       */
      public Builder setCloudRouter(
          com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudRouter.Builder
              builderForValue) {
        if (cloudRouterBuilder_ == null) {
          cloudRouter_ = builderForValue.build();
        } else {
          cloudRouterBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The Cloud Router info.
       * </pre>
       *
       * <code>.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudRouter cloud_router = 3;
       * </code>
       */
      public Builder mergeCloudRouter(
          com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudRouter value) {
        if (cloudRouterBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)
              && cloudRouter_ != null
              && cloudRouter_
                  != com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudRouter
                      .getDefaultInstance()) {
            getCloudRouterBuilder().mergeFrom(value);
          } else {
            cloudRouter_ = value;
          }
        } else {
          cloudRouterBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The Cloud Router info.
       * </pre>
       *
       * <code>.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudRouter cloud_router = 3;
       * </code>
       */
      public Builder clearCloudRouter() {
        bitField0_ = (bitField0_ & ~0x00000004);
        cloudRouter_ = null;
        if (cloudRouterBuilder_ != null) {
          cloudRouterBuilder_.dispose();
          cloudRouterBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The Cloud Router info.
       * </pre>
       *
       * <code>.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudRouter cloud_router = 3;
       * </code>
       */
      public com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudRouter.Builder
          getCloudRouterBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getCloudRouterFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The Cloud Router info.
       * </pre>
       *
       * <code>.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudRouter cloud_router = 3;
       * </code>
       */
      public com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudRouterOrBuilder
          getCloudRouterOrBuilder() {
        if (cloudRouterBuilder_ != null) {
          return cloudRouterBuilder_.getMessageOrBuilder();
        } else {
          return cloudRouter_ == null
              ? com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudRouter
                  .getDefaultInstance()
              : cloudRouter_;
        }
      }
      /**
       *
       *
       * <pre>
       * The Cloud Router info.
       * </pre>
       *
       * <code>.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudRouter cloud_router = 3;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudRouter,
              com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudRouter.Builder,
              com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudRouterOrBuilder>
          getCloudRouterFieldBuilder() {
        if (cloudRouterBuilder_ == null) {
          cloudRouterBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudRouter,
                  com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudRouter.Builder,
                  com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudRouterOrBuilder>(
                  getCloudRouter(), getParentForChildren(), isClean());
          cloudRouter_ = null;
        }
        return cloudRouterBuilder_;
      }

      private java.util.List<com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudVpn>
          cloudVpns_ = java.util.Collections.emptyList();

      private void ensureCloudVpnsIsMutable() {
        if (!((bitField0_ & 0x00000008) != 0)) {
          cloudVpns_ =
              new java.util.ArrayList<
                  com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudVpn>(cloudVpns_);
          bitField0_ |= 0x00000008;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudVpn,
              com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudVpn.Builder,
              com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudVpnOrBuilder>
          cloudVpnsBuilder_;

      /**
       *
       *
       * <pre>
       * Each connection has multiple Cloud VPN gateways.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.edgecontainer.v1.VpnConnection.Details.CloudVpn cloud_vpns = 4;
       * </code>
       */
      public java.util.List<com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudVpn>
          getCloudVpnsList() {
        if (cloudVpnsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(cloudVpns_);
        } else {
          return cloudVpnsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * Each connection has multiple Cloud VPN gateways.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.edgecontainer.v1.VpnConnection.Details.CloudVpn cloud_vpns = 4;
       * </code>
       */
      public int getCloudVpnsCount() {
        if (cloudVpnsBuilder_ == null) {
          return cloudVpns_.size();
        } else {
          return cloudVpnsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * Each connection has multiple Cloud VPN gateways.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.edgecontainer.v1.VpnConnection.Details.CloudVpn cloud_vpns = 4;
       * </code>
       */
      public com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudVpn getCloudVpns(
          int index) {
        if (cloudVpnsBuilder_ == null) {
          return cloudVpns_.get(index);
        } else {
          return cloudVpnsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Each connection has multiple Cloud VPN gateways.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.edgecontainer.v1.VpnConnection.Details.CloudVpn cloud_vpns = 4;
       * </code>
       */
      public Builder setCloudVpns(
          int index, com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudVpn value) {
        if (cloudVpnsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureCloudVpnsIsMutable();
          cloudVpns_.set(index, value);
          onChanged();
        } else {
          cloudVpnsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Each connection has multiple Cloud VPN gateways.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.edgecontainer.v1.VpnConnection.Details.CloudVpn cloud_vpns = 4;
       * </code>
       */
      public Builder setCloudVpns(
          int index,
          com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudVpn.Builder
              builderForValue) {
        if (cloudVpnsBuilder_ == null) {
          ensureCloudVpnsIsMutable();
          cloudVpns_.set(index, builderForValue.build());
          onChanged();
        } else {
          cloudVpnsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Each connection has multiple Cloud VPN gateways.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.edgecontainer.v1.VpnConnection.Details.CloudVpn cloud_vpns = 4;
       * </code>
       */
      public Builder addCloudVpns(
          com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudVpn value) {
        if (cloudVpnsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureCloudVpnsIsMutable();
          cloudVpns_.add(value);
          onChanged();
        } else {
          cloudVpnsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Each connection has multiple Cloud VPN gateways.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.edgecontainer.v1.VpnConnection.Details.CloudVpn cloud_vpns = 4;
       * </code>
       */
      public Builder addCloudVpns(
          int index, com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudVpn value) {
        if (cloudVpnsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureCloudVpnsIsMutable();
          cloudVpns_.add(index, value);
          onChanged();
        } else {
          cloudVpnsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Each connection has multiple Cloud VPN gateways.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.edgecontainer.v1.VpnConnection.Details.CloudVpn cloud_vpns = 4;
       * </code>
       */
      public Builder addCloudVpns(
          com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudVpn.Builder
              builderForValue) {
        if (cloudVpnsBuilder_ == null) {
          ensureCloudVpnsIsMutable();
          cloudVpns_.add(builderForValue.build());
          onChanged();
        } else {
          cloudVpnsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Each connection has multiple Cloud VPN gateways.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.edgecontainer.v1.VpnConnection.Details.CloudVpn cloud_vpns = 4;
       * </code>
       */
      public Builder addCloudVpns(
          int index,
          com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudVpn.Builder
              builderForValue) {
        if (cloudVpnsBuilder_ == null) {
          ensureCloudVpnsIsMutable();
          cloudVpns_.add(index, builderForValue.build());
          onChanged();
        } else {
          cloudVpnsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Each connection has multiple Cloud VPN gateways.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.edgecontainer.v1.VpnConnection.Details.CloudVpn cloud_vpns = 4;
       * </code>
       */
      public Builder addAllCloudVpns(
          java.lang.Iterable<
                  ? extends com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudVpn>
              values) {
        if (cloudVpnsBuilder_ == null) {
          ensureCloudVpnsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, cloudVpns_);
          onChanged();
        } else {
          cloudVpnsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Each connection has multiple Cloud VPN gateways.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.edgecontainer.v1.VpnConnection.Details.CloudVpn cloud_vpns = 4;
       * </code>
       */
      public Builder clearCloudVpns() {
        if (cloudVpnsBuilder_ == null) {
          cloudVpns_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000008);
          onChanged();
        } else {
          cloudVpnsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Each connection has multiple Cloud VPN gateways.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.edgecontainer.v1.VpnConnection.Details.CloudVpn cloud_vpns = 4;
       * </code>
       */
      public Builder removeCloudVpns(int index) {
        if (cloudVpnsBuilder_ == null) {
          ensureCloudVpnsIsMutable();
          cloudVpns_.remove(index);
          onChanged();
        } else {
          cloudVpnsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Each connection has multiple Cloud VPN gateways.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.edgecontainer.v1.VpnConnection.Details.CloudVpn cloud_vpns = 4;
       * </code>
       */
      public com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudVpn.Builder
          getCloudVpnsBuilder(int index) {
        return getCloudVpnsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * Each connection has multiple Cloud VPN gateways.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.edgecontainer.v1.VpnConnection.Details.CloudVpn cloud_vpns = 4;
       * </code>
       */
      public com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudVpnOrBuilder
          getCloudVpnsOrBuilder(int index) {
        if (cloudVpnsBuilder_ == null) {
          return cloudVpns_.get(index);
        } else {
          return cloudVpnsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Each connection has multiple Cloud VPN gateways.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.edgecontainer.v1.VpnConnection.Details.CloudVpn cloud_vpns = 4;
       * </code>
       */
      public java.util.List<
              ? extends com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudVpnOrBuilder>
          getCloudVpnsOrBuilderList() {
        if (cloudVpnsBuilder_ != null) {
          return cloudVpnsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(cloudVpns_);
        }
      }
      /**
       *
       *
       * <pre>
       * Each connection has multiple Cloud VPN gateways.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.edgecontainer.v1.VpnConnection.Details.CloudVpn cloud_vpns = 4;
       * </code>
       */
      public com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudVpn.Builder
          addCloudVpnsBuilder() {
        return getCloudVpnsFieldBuilder()
            .addBuilder(
                com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudVpn
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Each connection has multiple Cloud VPN gateways.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.edgecontainer.v1.VpnConnection.Details.CloudVpn cloud_vpns = 4;
       * </code>
       */
      public com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudVpn.Builder
          addCloudVpnsBuilder(int index) {
        return getCloudVpnsFieldBuilder()
            .addBuilder(
                index,
                com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudVpn
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Each connection has multiple Cloud VPN gateways.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.edgecontainer.v1.VpnConnection.Details.CloudVpn cloud_vpns = 4;
       * </code>
       */
      public java.util.List<
              com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudVpn.Builder>
          getCloudVpnsBuilderList() {
        return getCloudVpnsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudVpn,
              com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudVpn.Builder,
              com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudVpnOrBuilder>
          getCloudVpnsFieldBuilder() {
        if (cloudVpnsBuilder_ == null) {
          cloudVpnsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudVpn,
                  com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudVpn.Builder,
                  com.google.cloud.edgecontainer.v1.VpnConnection.Details.CloudVpnOrBuilder>(
                  cloudVpns_, ((bitField0_ & 0x00000008) != 0), getParentForChildren(), isClean());
          cloudVpns_ = null;
        }
        return cloudVpnsBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.edgecontainer.v1.VpnConnection.Details)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.edgecontainer.v1.VpnConnection.Details)
    private static final com.google.cloud.edgecontainer.v1.VpnConnection.Details DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.edgecontainer.v1.VpnConnection.Details();
    }

    public static com.google.cloud.edgecontainer.v1.VpnConnection.Details getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Details> PARSER =
        new com.google.protobuf.AbstractParser<Details>() {
          @java.lang.Override
          public Details parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Details> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Details> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.edgecontainer.v1.VpnConnection.Details getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Required. The resource name of VPN connection
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The resource name of VPN connection
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 2;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. The time when the VPN connection was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time when the VPN connection was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time when the VPN connection was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 3;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. The time when the VPN connection was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return updateTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time when the VPN connection was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time when the VPN connection was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int LABELS_FIELD_NUMBER = 4;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.edgecontainer.v1.ResourcesProto
                .internal_static_google_cloud_edgecontainer_v1_VpnConnection_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Labels associated with this resource.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * Labels associated with this resource.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * Labels associated with this resource.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Labels associated with this resource.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int NAT_GATEWAY_IP_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object natGatewayIp_ = "";
  /**
   *
   *
   * <pre>
   * NAT gateway IP, or WAN IP address. If a customer has multiple NAT IPs, the
   * customer needs to configure NAT such that only one external IP maps to the
   * GMEC Anthos cluster. This is empty if NAT is not used.
   * </pre>
   *
   * <code>string nat_gateway_ip = 5;</code>
   *
   * @return The natGatewayIp.
   */
  @java.lang.Override
  public java.lang.String getNatGatewayIp() {
    java.lang.Object ref = natGatewayIp_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      natGatewayIp_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * NAT gateway IP, or WAN IP address. If a customer has multiple NAT IPs, the
   * customer needs to configure NAT such that only one external IP maps to the
   * GMEC Anthos cluster. This is empty if NAT is not used.
   * </pre>
   *
   * <code>string nat_gateway_ip = 5;</code>
   *
   * @return The bytes for natGatewayIp.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNatGatewayIpBytes() {
    java.lang.Object ref = natGatewayIp_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      natGatewayIp_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int BGP_ROUTING_MODE_FIELD_NUMBER = 6;
  private int bgpRoutingMode_ = 0;
  /**
   *
   *
   * <pre>
   * Dynamic routing mode of the VPC network, `regional` or `global`.
   * </pre>
   *
   * <code>
   * .google.cloud.edgecontainer.v1.VpnConnection.BgpRoutingMode bgp_routing_mode = 6 [deprecated = true];
   * </code>
   *
   * @deprecated google.cloud.edgecontainer.v1.VpnConnection.bgp_routing_mode is deprecated. See
   *     google/cloud/edgecontainer/v1/resources.proto;l=361
   * @return The enum numeric value on the wire for bgpRoutingMode.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public int getBgpRoutingModeValue() {
    return bgpRoutingMode_;
  }
  /**
   *
   *
   * <pre>
   * Dynamic routing mode of the VPC network, `regional` or `global`.
   * </pre>
   *
   * <code>
   * .google.cloud.edgecontainer.v1.VpnConnection.BgpRoutingMode bgp_routing_mode = 6 [deprecated = true];
   * </code>
   *
   * @deprecated google.cloud.edgecontainer.v1.VpnConnection.bgp_routing_mode is deprecated. See
   *     google/cloud/edgecontainer/v1/resources.proto;l=361
   * @return The bgpRoutingMode.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.cloud.edgecontainer.v1.VpnConnection.BgpRoutingMode getBgpRoutingMode() {
    com.google.cloud.edgecontainer.v1.VpnConnection.BgpRoutingMode result =
        com.google.cloud.edgecontainer.v1.VpnConnection.BgpRoutingMode.forNumber(bgpRoutingMode_);
    return result == null
        ? com.google.cloud.edgecontainer.v1.VpnConnection.BgpRoutingMode.UNRECOGNIZED
        : result;
  }

  public static final int CLUSTER_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private volatile java.lang.Object cluster_ = "";
  /**
   *
   *
   * <pre>
   * The canonical Cluster name to connect to. It is in the form of
   * projects/{project}/locations/{location}/clusters/{cluster}.
   * </pre>
   *
   * <code>string cluster = 7 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The cluster.
   */
  @java.lang.Override
  public java.lang.String getCluster() {
    java.lang.Object ref = cluster_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      cluster_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The canonical Cluster name to connect to. It is in the form of
   * projects/{project}/locations/{location}/clusters/{cluster}.
   * </pre>
   *
   * <code>string cluster = 7 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for cluster.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getClusterBytes() {
    java.lang.Object ref = cluster_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      cluster_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int VPC_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private volatile java.lang.Object vpc_ = "";
  /**
   *
   *
   * <pre>
   * The network ID of VPC to connect to.
   * </pre>
   *
   * <code>string vpc = 8;</code>
   *
   * @return The vpc.
   */
  @java.lang.Override
  public java.lang.String getVpc() {
    java.lang.Object ref = vpc_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      vpc_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The network ID of VPC to connect to.
   * </pre>
   *
   * <code>string vpc = 8;</code>
   *
   * @return The bytes for vpc.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getVpcBytes() {
    java.lang.Object ref = vpc_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      vpc_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int VPC_PROJECT_FIELD_NUMBER = 11;
  private com.google.cloud.edgecontainer.v1.VpnConnection.VpcProject vpcProject_;
  /**
   *
   *
   * <pre>
   * Optional. Project detail of the VPC network. Required if VPC is in a different
   * project than the cluster project.
   * </pre>
   *
   * <code>
   * .google.cloud.edgecontainer.v1.VpnConnection.VpcProject vpc_project = 11 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the vpcProject field is set.
   */
  @java.lang.Override
  public boolean hasVpcProject() {
    return vpcProject_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. Project detail of the VPC network. Required if VPC is in a different
   * project than the cluster project.
   * </pre>
   *
   * <code>
   * .google.cloud.edgecontainer.v1.VpnConnection.VpcProject vpc_project = 11 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The vpcProject.
   */
  @java.lang.Override
  public com.google.cloud.edgecontainer.v1.VpnConnection.VpcProject getVpcProject() {
    return vpcProject_ == null
        ? com.google.cloud.edgecontainer.v1.VpnConnection.VpcProject.getDefaultInstance()
        : vpcProject_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Project detail of the VPC network. Required if VPC is in a different
   * project than the cluster project.
   * </pre>
   *
   * <code>
   * .google.cloud.edgecontainer.v1.VpnConnection.VpcProject vpc_project = 11 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.edgecontainer.v1.VpnConnection.VpcProjectOrBuilder
      getVpcProjectOrBuilder() {
    return vpcProject_ == null
        ? com.google.cloud.edgecontainer.v1.VpnConnection.VpcProject.getDefaultInstance()
        : vpcProject_;
  }

  public static final int ENABLE_HIGH_AVAILABILITY_FIELD_NUMBER = 9;
  private boolean enableHighAvailability_ = false;
  /**
   *
   *
   * <pre>
   * Whether this VPN connection has HA enabled on cluster side. If enabled,
   * when creating VPN connection we will attempt to use 2 ANG floating IPs.
   * </pre>
   *
   * <code>bool enable_high_availability = 9;</code>
   *
   * @return The enableHighAvailability.
   */
  @java.lang.Override
  public boolean getEnableHighAvailability() {
    return enableHighAvailability_;
  }

  public static final int DETAILS_FIELD_NUMBER = 10;
  private com.google.cloud.edgecontainer.v1.VpnConnection.Details details_;
  /**
   *
   *
   * <pre>
   * Output only. The created connection details.
   * </pre>
   *
   * <code>
   * .google.cloud.edgecontainer.v1.VpnConnection.Details details = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the details field is set.
   */
  @java.lang.Override
  public boolean hasDetails() {
    return details_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The created connection details.
   * </pre>
   *
   * <code>
   * .google.cloud.edgecontainer.v1.VpnConnection.Details details = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The details.
   */
  @java.lang.Override
  public com.google.cloud.edgecontainer.v1.VpnConnection.Details getDetails() {
    return details_ == null
        ? com.google.cloud.edgecontainer.v1.VpnConnection.Details.getDefaultInstance()
        : details_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The created connection details.
   * </pre>
   *
   * <code>
   * .google.cloud.edgecontainer.v1.VpnConnection.Details details = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.edgecontainer.v1.VpnConnection.DetailsOrBuilder getDetailsOrBuilder() {
    return details_ == null
        ? com.google.cloud.edgecontainer.v1.VpnConnection.Details.getDefaultInstance()
        : details_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (createTime_ != null) {
      output.writeMessage(2, getCreateTime());
    }
    if (updateTime_ != null) {
      output.writeMessage(3, getUpdateTime());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 4);
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(natGatewayIp_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, natGatewayIp_);
    }
    if (bgpRoutingMode_
        != com.google.cloud.edgecontainer.v1.VpnConnection.BgpRoutingMode
            .BGP_ROUTING_MODE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(6, bgpRoutingMode_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(cluster_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, cluster_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(vpc_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, vpc_);
    }
    if (enableHighAvailability_ != false) {
      output.writeBool(9, enableHighAvailability_);
    }
    if (details_ != null) {
      output.writeMessage(10, getDetails());
    }
    if (vpcProject_ != null) {
      output.writeMessage(11, getVpcProject());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getCreateTime());
    }
    if (updateTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getUpdateTime());
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, labels__);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(natGatewayIp_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, natGatewayIp_);
    }
    if (bgpRoutingMode_
        != com.google.cloud.edgecontainer.v1.VpnConnection.BgpRoutingMode
            .BGP_ROUTING_MODE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(6, bgpRoutingMode_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(cluster_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, cluster_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(vpc_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, vpc_);
    }
    if (enableHighAvailability_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(9, enableHighAvailability_);
    }
    if (details_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, getDetails());
    }
    if (vpcProject_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(11, getVpcProject());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.edgecontainer.v1.VpnConnection)) {
      return super.equals(obj);
    }
    com.google.cloud.edgecontainer.v1.VpnConnection other =
        (com.google.cloud.edgecontainer.v1.VpnConnection) obj;

    if (!getName().equals(other.getName())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (!getNatGatewayIp().equals(other.getNatGatewayIp())) return false;
    if (bgpRoutingMode_ != other.bgpRoutingMode_) return false;
    if (!getCluster().equals(other.getCluster())) return false;
    if (!getVpc().equals(other.getVpc())) return false;
    if (hasVpcProject() != other.hasVpcProject()) return false;
    if (hasVpcProject()) {
      if (!getVpcProject().equals(other.getVpcProject())) return false;
    }
    if (getEnableHighAvailability() != other.getEnableHighAvailability()) return false;
    if (hasDetails() != other.hasDetails()) return false;
    if (hasDetails()) {
      if (!getDetails().equals(other.getDetails())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    hash = (37 * hash) + NAT_GATEWAY_IP_FIELD_NUMBER;
    hash = (53 * hash) + getNatGatewayIp().hashCode();
    hash = (37 * hash) + BGP_ROUTING_MODE_FIELD_NUMBER;
    hash = (53 * hash) + bgpRoutingMode_;
    hash = (37 * hash) + CLUSTER_FIELD_NUMBER;
    hash = (53 * hash) + getCluster().hashCode();
    hash = (37 * hash) + VPC_FIELD_NUMBER;
    hash = (53 * hash) + getVpc().hashCode();
    if (hasVpcProject()) {
      hash = (37 * hash) + VPC_PROJECT_FIELD_NUMBER;
      hash = (53 * hash) + getVpcProject().hashCode();
    }
    hash = (37 * hash) + ENABLE_HIGH_AVAILABILITY_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnableHighAvailability());
    if (hasDetails()) {
      hash = (37 * hash) + DETAILS_FIELD_NUMBER;
      hash = (53 * hash) + getDetails().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.edgecontainer.v1.VpnConnection parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.edgecontainer.v1.VpnConnection parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.edgecontainer.v1.VpnConnection parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.edgecontainer.v1.VpnConnection parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.edgecontainer.v1.VpnConnection parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.edgecontainer.v1.VpnConnection parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.edgecontainer.v1.VpnConnection parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.edgecontainer.v1.VpnConnection parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.edgecontainer.v1.VpnConnection parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.edgecontainer.v1.VpnConnection parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.edgecontainer.v1.VpnConnection parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.edgecontainer.v1.VpnConnection parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.edgecontainer.v1.VpnConnection prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A VPN connection .
   * </pre>
   *
   * Protobuf type {@code google.cloud.edgecontainer.v1.VpnConnection}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.edgecontainer.v1.VpnConnection)
      com.google.cloud.edgecontainer.v1.VpnConnectionOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.edgecontainer.v1.ResourcesProto
          .internal_static_google_cloud_edgecontainer_v1_VpnConnection_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 4:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 4:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.edgecontainer.v1.ResourcesProto
          .internal_static_google_cloud_edgecontainer_v1_VpnConnection_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.edgecontainer.v1.VpnConnection.class,
              com.google.cloud.edgecontainer.v1.VpnConnection.Builder.class);
    }

    // Construct using com.google.cloud.edgecontainer.v1.VpnConnection.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      internalGetMutableLabels().clear();
      natGatewayIp_ = "";
      bgpRoutingMode_ = 0;
      cluster_ = "";
      vpc_ = "";
      vpcProject_ = null;
      if (vpcProjectBuilder_ != null) {
        vpcProjectBuilder_.dispose();
        vpcProjectBuilder_ = null;
      }
      enableHighAvailability_ = false;
      details_ = null;
      if (detailsBuilder_ != null) {
        detailsBuilder_.dispose();
        detailsBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.edgecontainer.v1.ResourcesProto
          .internal_static_google_cloud_edgecontainer_v1_VpnConnection_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.edgecontainer.v1.VpnConnection getDefaultInstanceForType() {
      return com.google.cloud.edgecontainer.v1.VpnConnection.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.edgecontainer.v1.VpnConnection build() {
      com.google.cloud.edgecontainer.v1.VpnConnection result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.edgecontainer.v1.VpnConnection buildPartial() {
      com.google.cloud.edgecontainer.v1.VpnConnection result =
          new com.google.cloud.edgecontainer.v1.VpnConnection(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.edgecontainer.v1.VpnConnection result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.natGatewayIp_ = natGatewayIp_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.bgpRoutingMode_ = bgpRoutingMode_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.cluster_ = cluster_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.vpc_ = vpc_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.vpcProject_ = vpcProjectBuilder_ == null ? vpcProject_ : vpcProjectBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.enableHighAvailability_ = enableHighAvailability_;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.details_ = detailsBuilder_ == null ? details_ : detailsBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.edgecontainer.v1.VpnConnection) {
        return mergeFrom((com.google.cloud.edgecontainer.v1.VpnConnection) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.edgecontainer.v1.VpnConnection other) {
      if (other == com.google.cloud.edgecontainer.v1.VpnConnection.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00000008;
      if (!other.getNatGatewayIp().isEmpty()) {
        natGatewayIp_ = other.natGatewayIp_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (other.bgpRoutingMode_ != 0) {
        setBgpRoutingModeValue(other.getBgpRoutingModeValue());
      }
      if (!other.getCluster().isEmpty()) {
        cluster_ = other.cluster_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (!other.getVpc().isEmpty()) {
        vpc_ = other.vpc_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      if (other.hasVpcProject()) {
        mergeVpcProject(other.getVpcProject());
      }
      if (other.getEnableHighAvailability() != false) {
        setEnableHighAvailability(other.getEnableHighAvailability());
      }
      if (other.hasDetails()) {
        mergeDetails(other.getDetails());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                natGatewayIp_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 48:
              {
                bgpRoutingMode_ = input.readEnum();
                bitField0_ |= 0x00000020;
                break;
              } // case 48
            case 58:
              {
                cluster_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            case 66:
              {
                vpc_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000080;
                break;
              } // case 66
            case 72:
              {
                enableHighAvailability_ = input.readBool();
                bitField0_ |= 0x00000200;
                break;
              } // case 72
            case 82:
              {
                input.readMessage(getDetailsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000400;
                break;
              } // case 82
            case 90:
              {
                input.readMessage(getVpcProjectFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 90
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Required. The resource name of VPN connection
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of VPN connection
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of VPN connection
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of VPN connection
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of VPN connection
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The time when the VPN connection was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the VPN connection was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the VPN connection was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the VPN connection was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the VPN connection was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the VPN connection was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000002);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the VPN connection was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the VPN connection was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the VPN connection was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The time when the VPN connection was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the VPN connection was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the VPN connection was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the VPN connection was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the VPN connection was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the VPN connection was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000004);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the VPN connection was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the VPN connection was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the VPN connection was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Labels associated with this resource.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * Labels associated with this resource.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * Labels associated with this resource.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Labels associated with this resource.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00000008);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Labels associated with this resource.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x00000008;
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Labels associated with this resource.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00000008;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Labels associated with this resource.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00000008;
      return this;
    }

    private java.lang.Object natGatewayIp_ = "";
    /**
     *
     *
     * <pre>
     * NAT gateway IP, or WAN IP address. If a customer has multiple NAT IPs, the
     * customer needs to configure NAT such that only one external IP maps to the
     * GMEC Anthos cluster. This is empty if NAT is not used.
     * </pre>
     *
     * <code>string nat_gateway_ip = 5;</code>
     *
     * @return The natGatewayIp.
     */
    public java.lang.String getNatGatewayIp() {
      java.lang.Object ref = natGatewayIp_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        natGatewayIp_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * NAT gateway IP, or WAN IP address. If a customer has multiple NAT IPs, the
     * customer needs to configure NAT such that only one external IP maps to the
     * GMEC Anthos cluster. This is empty if NAT is not used.
     * </pre>
     *
     * <code>string nat_gateway_ip = 5;</code>
     *
     * @return The bytes for natGatewayIp.
     */
    public com.google.protobuf.ByteString getNatGatewayIpBytes() {
      java.lang.Object ref = natGatewayIp_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        natGatewayIp_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * NAT gateway IP, or WAN IP address. If a customer has multiple NAT IPs, the
     * customer needs to configure NAT such that only one external IP maps to the
     * GMEC Anthos cluster. This is empty if NAT is not used.
     * </pre>
     *
     * <code>string nat_gateway_ip = 5;</code>
     *
     * @param value The natGatewayIp to set.
     * @return This builder for chaining.
     */
    public Builder setNatGatewayIp(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      natGatewayIp_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * NAT gateway IP, or WAN IP address. If a customer has multiple NAT IPs, the
     * customer needs to configure NAT such that only one external IP maps to the
     * GMEC Anthos cluster. This is empty if NAT is not used.
     * </pre>
     *
     * <code>string nat_gateway_ip = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNatGatewayIp() {
      natGatewayIp_ = getDefaultInstance().getNatGatewayIp();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * NAT gateway IP, or WAN IP address. If a customer has multiple NAT IPs, the
     * customer needs to configure NAT such that only one external IP maps to the
     * GMEC Anthos cluster. This is empty if NAT is not used.
     * </pre>
     *
     * <code>string nat_gateway_ip = 5;</code>
     *
     * @param value The bytes for natGatewayIp to set.
     * @return This builder for chaining.
     */
    public Builder setNatGatewayIpBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      natGatewayIp_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private int bgpRoutingMode_ = 0;
    /**
     *
     *
     * <pre>
     * Dynamic routing mode of the VPC network, `regional` or `global`.
     * </pre>
     *
     * <code>
     * .google.cloud.edgecontainer.v1.VpnConnection.BgpRoutingMode bgp_routing_mode = 6 [deprecated = true];
     * </code>
     *
     * @deprecated google.cloud.edgecontainer.v1.VpnConnection.bgp_routing_mode is deprecated. See
     *     google/cloud/edgecontainer/v1/resources.proto;l=361
     * @return The enum numeric value on the wire for bgpRoutingMode.
     */
    @java.lang.Override
    @java.lang.Deprecated
    public int getBgpRoutingModeValue() {
      return bgpRoutingMode_;
    }
    /**
     *
     *
     * <pre>
     * Dynamic routing mode of the VPC network, `regional` or `global`.
     * </pre>
     *
     * <code>
     * .google.cloud.edgecontainer.v1.VpnConnection.BgpRoutingMode bgp_routing_mode = 6 [deprecated = true];
     * </code>
     *
     * @deprecated google.cloud.edgecontainer.v1.VpnConnection.bgp_routing_mode is deprecated. See
     *     google/cloud/edgecontainer/v1/resources.proto;l=361
     * @param value The enum numeric value on the wire for bgpRoutingMode to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setBgpRoutingModeValue(int value) {
      bgpRoutingMode_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Dynamic routing mode of the VPC network, `regional` or `global`.
     * </pre>
     *
     * <code>
     * .google.cloud.edgecontainer.v1.VpnConnection.BgpRoutingMode bgp_routing_mode = 6 [deprecated = true];
     * </code>
     *
     * @deprecated google.cloud.edgecontainer.v1.VpnConnection.bgp_routing_mode is deprecated. See
     *     google/cloud/edgecontainer/v1/resources.proto;l=361
     * @return The bgpRoutingMode.
     */
    @java.lang.Override
    @java.lang.Deprecated
    public com.google.cloud.edgecontainer.v1.VpnConnection.BgpRoutingMode getBgpRoutingMode() {
      com.google.cloud.edgecontainer.v1.VpnConnection.BgpRoutingMode result =
          com.google.cloud.edgecontainer.v1.VpnConnection.BgpRoutingMode.forNumber(bgpRoutingMode_);
      return result == null
          ? com.google.cloud.edgecontainer.v1.VpnConnection.BgpRoutingMode.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Dynamic routing mode of the VPC network, `regional` or `global`.
     * </pre>
     *
     * <code>
     * .google.cloud.edgecontainer.v1.VpnConnection.BgpRoutingMode bgp_routing_mode = 6 [deprecated = true];
     * </code>
     *
     * @deprecated google.cloud.edgecontainer.v1.VpnConnection.bgp_routing_mode is deprecated. See
     *     google/cloud/edgecontainer/v1/resources.proto;l=361
     * @param value The bgpRoutingMode to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setBgpRoutingMode(
        com.google.cloud.edgecontainer.v1.VpnConnection.BgpRoutingMode value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000020;
      bgpRoutingMode_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Dynamic routing mode of the VPC network, `regional` or `global`.
     * </pre>
     *
     * <code>
     * .google.cloud.edgecontainer.v1.VpnConnection.BgpRoutingMode bgp_routing_mode = 6 [deprecated = true];
     * </code>
     *
     * @deprecated google.cloud.edgecontainer.v1.VpnConnection.bgp_routing_mode is deprecated. See
     *     google/cloud/edgecontainer/v1/resources.proto;l=361
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder clearBgpRoutingMode() {
      bitField0_ = (bitField0_ & ~0x00000020);
      bgpRoutingMode_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object cluster_ = "";
    /**
     *
     *
     * <pre>
     * The canonical Cluster name to connect to. It is in the form of
     * projects/{project}/locations/{location}/clusters/{cluster}.
     * </pre>
     *
     * <code>string cluster = 7 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The cluster.
     */
    public java.lang.String getCluster() {
      java.lang.Object ref = cluster_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        cluster_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The canonical Cluster name to connect to. It is in the form of
     * projects/{project}/locations/{location}/clusters/{cluster}.
     * </pre>
     *
     * <code>string cluster = 7 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for cluster.
     */
    public com.google.protobuf.ByteString getClusterBytes() {
      java.lang.Object ref = cluster_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        cluster_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The canonical Cluster name to connect to. It is in the form of
     * projects/{project}/locations/{location}/clusters/{cluster}.
     * </pre>
     *
     * <code>string cluster = 7 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The cluster to set.
     * @return This builder for chaining.
     */
    public Builder setCluster(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      cluster_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The canonical Cluster name to connect to. It is in the form of
     * projects/{project}/locations/{location}/clusters/{cluster}.
     * </pre>
     *
     * <code>string cluster = 7 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCluster() {
      cluster_ = getDefaultInstance().getCluster();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The canonical Cluster name to connect to. It is in the form of
     * projects/{project}/locations/{location}/clusters/{cluster}.
     * </pre>
     *
     * <code>string cluster = 7 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The bytes for cluster to set.
     * @return This builder for chaining.
     */
    public Builder setClusterBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      cluster_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private java.lang.Object vpc_ = "";
    /**
     *
     *
     * <pre>
     * The network ID of VPC to connect to.
     * </pre>
     *
     * <code>string vpc = 8;</code>
     *
     * @return The vpc.
     */
    public java.lang.String getVpc() {
      java.lang.Object ref = vpc_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        vpc_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The network ID of VPC to connect to.
     * </pre>
     *
     * <code>string vpc = 8;</code>
     *
     * @return The bytes for vpc.
     */
    public com.google.protobuf.ByteString getVpcBytes() {
      java.lang.Object ref = vpc_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        vpc_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The network ID of VPC to connect to.
     * </pre>
     *
     * <code>string vpc = 8;</code>
     *
     * @param value The vpc to set.
     * @return This builder for chaining.
     */
    public Builder setVpc(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      vpc_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The network ID of VPC to connect to.
     * </pre>
     *
     * <code>string vpc = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearVpc() {
      vpc_ = getDefaultInstance().getVpc();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The network ID of VPC to connect to.
     * </pre>
     *
     * <code>string vpc = 8;</code>
     *
     * @param value The bytes for vpc to set.
     * @return This builder for chaining.
     */
    public Builder setVpcBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      vpc_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private com.google.cloud.edgecontainer.v1.VpnConnection.VpcProject vpcProject_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.edgecontainer.v1.VpnConnection.VpcProject,
            com.google.cloud.edgecontainer.v1.VpnConnection.VpcProject.Builder,
            com.google.cloud.edgecontainer.v1.VpnConnection.VpcProjectOrBuilder>
        vpcProjectBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Project detail of the VPC network. Required if VPC is in a different
     * project than the cluster project.
     * </pre>
     *
     * <code>
     * .google.cloud.edgecontainer.v1.VpnConnection.VpcProject vpc_project = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the vpcProject field is set.
     */
    public boolean hasVpcProject() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Project detail of the VPC network. Required if VPC is in a different
     * project than the cluster project.
     * </pre>
     *
     * <code>
     * .google.cloud.edgecontainer.v1.VpnConnection.VpcProject vpc_project = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The vpcProject.
     */
    public com.google.cloud.edgecontainer.v1.VpnConnection.VpcProject getVpcProject() {
      if (vpcProjectBuilder_ == null) {
        return vpcProject_ == null
            ? com.google.cloud.edgecontainer.v1.VpnConnection.VpcProject.getDefaultInstance()
            : vpcProject_;
      } else {
        return vpcProjectBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Project detail of the VPC network. Required if VPC is in a different
     * project than the cluster project.
     * </pre>
     *
     * <code>
     * .google.cloud.edgecontainer.v1.VpnConnection.VpcProject vpc_project = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setVpcProject(com.google.cloud.edgecontainer.v1.VpnConnection.VpcProject value) {
      if (vpcProjectBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        vpcProject_ = value;
      } else {
        vpcProjectBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Project detail of the VPC network. Required if VPC is in a different
     * project than the cluster project.
     * </pre>
     *
     * <code>
     * .google.cloud.edgecontainer.v1.VpnConnection.VpcProject vpc_project = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setVpcProject(
        com.google.cloud.edgecontainer.v1.VpnConnection.VpcProject.Builder builderForValue) {
      if (vpcProjectBuilder_ == null) {
        vpcProject_ = builderForValue.build();
      } else {
        vpcProjectBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Project detail of the VPC network. Required if VPC is in a different
     * project than the cluster project.
     * </pre>
     *
     * <code>
     * .google.cloud.edgecontainer.v1.VpnConnection.VpcProject vpc_project = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeVpcProject(
        com.google.cloud.edgecontainer.v1.VpnConnection.VpcProject value) {
      if (vpcProjectBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && vpcProject_ != null
            && vpcProject_
                != com.google.cloud.edgecontainer.v1.VpnConnection.VpcProject
                    .getDefaultInstance()) {
          getVpcProjectBuilder().mergeFrom(value);
        } else {
          vpcProject_ = value;
        }
      } else {
        vpcProjectBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Project detail of the VPC network. Required if VPC is in a different
     * project than the cluster project.
     * </pre>
     *
     * <code>
     * .google.cloud.edgecontainer.v1.VpnConnection.VpcProject vpc_project = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearVpcProject() {
      bitField0_ = (bitField0_ & ~0x00000100);
      vpcProject_ = null;
      if (vpcProjectBuilder_ != null) {
        vpcProjectBuilder_.dispose();
        vpcProjectBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Project detail of the VPC network. Required if VPC is in a different
     * project than the cluster project.
     * </pre>
     *
     * <code>
     * .google.cloud.edgecontainer.v1.VpnConnection.VpcProject vpc_project = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.edgecontainer.v1.VpnConnection.VpcProject.Builder
        getVpcProjectBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getVpcProjectFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Project detail of the VPC network. Required if VPC is in a different
     * project than the cluster project.
     * </pre>
     *
     * <code>
     * .google.cloud.edgecontainer.v1.VpnConnection.VpcProject vpc_project = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.edgecontainer.v1.VpnConnection.VpcProjectOrBuilder
        getVpcProjectOrBuilder() {
      if (vpcProjectBuilder_ != null) {
        return vpcProjectBuilder_.getMessageOrBuilder();
      } else {
        return vpcProject_ == null
            ? com.google.cloud.edgecontainer.v1.VpnConnection.VpcProject.getDefaultInstance()
            : vpcProject_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Project detail of the VPC network. Required if VPC is in a different
     * project than the cluster project.
     * </pre>
     *
     * <code>
     * .google.cloud.edgecontainer.v1.VpnConnection.VpcProject vpc_project = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.edgecontainer.v1.VpnConnection.VpcProject,
            com.google.cloud.edgecontainer.v1.VpnConnection.VpcProject.Builder,
            com.google.cloud.edgecontainer.v1.VpnConnection.VpcProjectOrBuilder>
        getVpcProjectFieldBuilder() {
      if (vpcProjectBuilder_ == null) {
        vpcProjectBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.edgecontainer.v1.VpnConnection.VpcProject,
                com.google.cloud.edgecontainer.v1.VpnConnection.VpcProject.Builder,
                com.google.cloud.edgecontainer.v1.VpnConnection.VpcProjectOrBuilder>(
                getVpcProject(), getParentForChildren(), isClean());
        vpcProject_ = null;
      }
      return vpcProjectBuilder_;
    }

    private boolean enableHighAvailability_;
    /**
     *
     *
     * <pre>
     * Whether this VPN connection has HA enabled on cluster side. If enabled,
     * when creating VPN connection we will attempt to use 2 ANG floating IPs.
     * </pre>
     *
     * <code>bool enable_high_availability = 9;</code>
     *
     * @return The enableHighAvailability.
     */
    @java.lang.Override
    public boolean getEnableHighAvailability() {
      return enableHighAvailability_;
    }
    /**
     *
     *
     * <pre>
     * Whether this VPN connection has HA enabled on cluster side. If enabled,
     * when creating VPN connection we will attempt to use 2 ANG floating IPs.
     * </pre>
     *
     * <code>bool enable_high_availability = 9;</code>
     *
     * @param value The enableHighAvailability to set.
     * @return This builder for chaining.
     */
    public Builder setEnableHighAvailability(boolean value) {

      enableHighAvailability_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Whether this VPN connection has HA enabled on cluster side. If enabled,
     * when creating VPN connection we will attempt to use 2 ANG floating IPs.
     * </pre>
     *
     * <code>bool enable_high_availability = 9;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEnableHighAvailability() {
      bitField0_ = (bitField0_ & ~0x00000200);
      enableHighAvailability_ = false;
      onChanged();
      return this;
    }

    private com.google.cloud.edgecontainer.v1.VpnConnection.Details details_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.edgecontainer.v1.VpnConnection.Details,
            com.google.cloud.edgecontainer.v1.VpnConnection.Details.Builder,
            com.google.cloud.edgecontainer.v1.VpnConnection.DetailsOrBuilder>
        detailsBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The created connection details.
     * </pre>
     *
     * <code>
     * .google.cloud.edgecontainer.v1.VpnConnection.Details details = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the details field is set.
     */
    public boolean hasDetails() {
      return ((bitField0_ & 0x00000400) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The created connection details.
     * </pre>
     *
     * <code>
     * .google.cloud.edgecontainer.v1.VpnConnection.Details details = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The details.
     */
    public com.google.cloud.edgecontainer.v1.VpnConnection.Details getDetails() {
      if (detailsBuilder_ == null) {
        return details_ == null
            ? com.google.cloud.edgecontainer.v1.VpnConnection.Details.getDefaultInstance()
            : details_;
      } else {
        return detailsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The created connection details.
     * </pre>
     *
     * <code>
     * .google.cloud.edgecontainer.v1.VpnConnection.Details details = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setDetails(com.google.cloud.edgecontainer.v1.VpnConnection.Details value) {
      if (detailsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        details_ = value;
      } else {
        detailsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The created connection details.
     * </pre>
     *
     * <code>
     * .google.cloud.edgecontainer.v1.VpnConnection.Details details = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setDetails(
        com.google.cloud.edgecontainer.v1.VpnConnection.Details.Builder builderForValue) {
      if (detailsBuilder_ == null) {
        details_ = builderForValue.build();
      } else {
        detailsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The created connection details.
     * </pre>
     *
     * <code>
     * .google.cloud.edgecontainer.v1.VpnConnection.Details details = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeDetails(com.google.cloud.edgecontainer.v1.VpnConnection.Details value) {
      if (detailsBuilder_ == null) {
        if (((bitField0_ & 0x00000400) != 0)
            && details_ != null
            && details_
                != com.google.cloud.edgecontainer.v1.VpnConnection.Details.getDefaultInstance()) {
          getDetailsBuilder().mergeFrom(value);
        } else {
          details_ = value;
        }
      } else {
        detailsBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The created connection details.
     * </pre>
     *
     * <code>
     * .google.cloud.edgecontainer.v1.VpnConnection.Details details = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearDetails() {
      bitField0_ = (bitField0_ & ~0x00000400);
      details_ = null;
      if (detailsBuilder_ != null) {
        detailsBuilder_.dispose();
        detailsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The created connection details.
     * </pre>
     *
     * <code>
     * .google.cloud.edgecontainer.v1.VpnConnection.Details details = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.edgecontainer.v1.VpnConnection.Details.Builder getDetailsBuilder() {
      bitField0_ |= 0x00000400;
      onChanged();
      return getDetailsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The created connection details.
     * </pre>
     *
     * <code>
     * .google.cloud.edgecontainer.v1.VpnConnection.Details details = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.edgecontainer.v1.VpnConnection.DetailsOrBuilder getDetailsOrBuilder() {
      if (detailsBuilder_ != null) {
        return detailsBuilder_.getMessageOrBuilder();
      } else {
        return details_ == null
            ? com.google.cloud.edgecontainer.v1.VpnConnection.Details.getDefaultInstance()
            : details_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The created connection details.
     * </pre>
     *
     * <code>
     * .google.cloud.edgecontainer.v1.VpnConnection.Details details = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.edgecontainer.v1.VpnConnection.Details,
            com.google.cloud.edgecontainer.v1.VpnConnection.Details.Builder,
            com.google.cloud.edgecontainer.v1.VpnConnection.DetailsOrBuilder>
        getDetailsFieldBuilder() {
      if (detailsBuilder_ == null) {
        detailsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.edgecontainer.v1.VpnConnection.Details,
                com.google.cloud.edgecontainer.v1.VpnConnection.Details.Builder,
                com.google.cloud.edgecontainer.v1.VpnConnection.DetailsOrBuilder>(
                getDetails(), getParentForChildren(), isClean());
        details_ = null;
      }
      return detailsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.edgecontainer.v1.VpnConnection)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.edgecontainer.v1.VpnConnection)
  private static final com.google.cloud.edgecontainer.v1.VpnConnection DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.edgecontainer.v1.VpnConnection();
  }

  public static com.google.cloud.edgecontainer.v1.VpnConnection getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<VpnConnection> PARSER =
      new com.google.protobuf.AbstractParser<VpnConnection>() {
        @java.lang.Override
        public VpnConnection parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<VpnConnection> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<VpnConnection> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.edgecontainer.v1.VpnConnection getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
