/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/privacy/dlp/v2/dlp.proto

// Protobuf Java Version: 3.25.3
package com.google.privacy.dlp.v2;

/**
 *
 *
 * <pre>
 * A task to execute on the completion of a job.
 * See https://cloud.google.com/sensitive-data-protection/docs/concepts-actions
 * to learn more.
 * </pre>
 *
 * Protobuf type {@code google.privacy.dlp.v2.Action}
 */
public final class Action extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.privacy.dlp.v2.Action)
    ActionOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Action.newBuilder() to construct.
  private Action(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Action() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Action();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.privacy.dlp.v2.DlpProto
        .internal_static_google_privacy_dlp_v2_Action_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.privacy.dlp.v2.DlpProto
        .internal_static_google_privacy_dlp_v2_Action_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.privacy.dlp.v2.Action.class, com.google.privacy.dlp.v2.Action.Builder.class);
  }

  public interface SaveFindingsOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.privacy.dlp.v2.Action.SaveFindings)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Location to store findings outside of DLP.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.OutputStorageConfig output_config = 1;</code>
     *
     * @return Whether the outputConfig field is set.
     */
    boolean hasOutputConfig();
    /**
     *
     *
     * <pre>
     * Location to store findings outside of DLP.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.OutputStorageConfig output_config = 1;</code>
     *
     * @return The outputConfig.
     */
    com.google.privacy.dlp.v2.OutputStorageConfig getOutputConfig();
    /**
     *
     *
     * <pre>
     * Location to store findings outside of DLP.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.OutputStorageConfig output_config = 1;</code>
     */
    com.google.privacy.dlp.v2.OutputStorageConfigOrBuilder getOutputConfigOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * If set, the detailed findings will be persisted to the specified
   * OutputStorageConfig. Only a single instance of this action can be
   * specified.
   * Compatible with: Inspect, Risk
   * </pre>
   *
   * Protobuf type {@code google.privacy.dlp.v2.Action.SaveFindings}
   */
  public static final class SaveFindings extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.privacy.dlp.v2.Action.SaveFindings)
      SaveFindingsOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use SaveFindings.newBuilder() to construct.
    private SaveFindings(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private SaveFindings() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new SaveFindings();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_Action_SaveFindings_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_Action_SaveFindings_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.privacy.dlp.v2.Action.SaveFindings.class,
              com.google.privacy.dlp.v2.Action.SaveFindings.Builder.class);
    }

    private int bitField0_;
    public static final int OUTPUT_CONFIG_FIELD_NUMBER = 1;
    private com.google.privacy.dlp.v2.OutputStorageConfig outputConfig_;
    /**
     *
     *
     * <pre>
     * Location to store findings outside of DLP.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.OutputStorageConfig output_config = 1;</code>
     *
     * @return Whether the outputConfig field is set.
     */
    @java.lang.Override
    public boolean hasOutputConfig() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Location to store findings outside of DLP.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.OutputStorageConfig output_config = 1;</code>
     *
     * @return The outputConfig.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.OutputStorageConfig getOutputConfig() {
      return outputConfig_ == null
          ? com.google.privacy.dlp.v2.OutputStorageConfig.getDefaultInstance()
          : outputConfig_;
    }
    /**
     *
     *
     * <pre>
     * Location to store findings outside of DLP.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.OutputStorageConfig output_config = 1;</code>
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.OutputStorageConfigOrBuilder getOutputConfigOrBuilder() {
      return outputConfig_ == null
          ? com.google.privacy.dlp.v2.OutputStorageConfig.getDefaultInstance()
          : outputConfig_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getOutputConfig());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getOutputConfig());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.privacy.dlp.v2.Action.SaveFindings)) {
        return super.equals(obj);
      }
      com.google.privacy.dlp.v2.Action.SaveFindings other =
          (com.google.privacy.dlp.v2.Action.SaveFindings) obj;

      if (hasOutputConfig() != other.hasOutputConfig()) return false;
      if (hasOutputConfig()) {
        if (!getOutputConfig().equals(other.getOutputConfig())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasOutputConfig()) {
        hash = (37 * hash) + OUTPUT_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getOutputConfig().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.privacy.dlp.v2.Action.SaveFindings parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.privacy.dlp.v2.Action.SaveFindings parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.Action.SaveFindings parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.privacy.dlp.v2.Action.SaveFindings parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.Action.SaveFindings parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.privacy.dlp.v2.Action.SaveFindings parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.Action.SaveFindings parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.privacy.dlp.v2.Action.SaveFindings parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.Action.SaveFindings parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.privacy.dlp.v2.Action.SaveFindings parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.Action.SaveFindings parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.privacy.dlp.v2.Action.SaveFindings parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.privacy.dlp.v2.Action.SaveFindings prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * If set, the detailed findings will be persisted to the specified
     * OutputStorageConfig. Only a single instance of this action can be
     * specified.
     * Compatible with: Inspect, Risk
     * </pre>
     *
     * Protobuf type {@code google.privacy.dlp.v2.Action.SaveFindings}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.privacy.dlp.v2.Action.SaveFindings)
        com.google.privacy.dlp.v2.Action.SaveFindingsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.privacy.dlp.v2.DlpProto
            .internal_static_google_privacy_dlp_v2_Action_SaveFindings_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.privacy.dlp.v2.DlpProto
            .internal_static_google_privacy_dlp_v2_Action_SaveFindings_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.privacy.dlp.v2.Action.SaveFindings.class,
                com.google.privacy.dlp.v2.Action.SaveFindings.Builder.class);
      }

      // Construct using com.google.privacy.dlp.v2.Action.SaveFindings.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getOutputConfigFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        outputConfig_ = null;
        if (outputConfigBuilder_ != null) {
          outputConfigBuilder_.dispose();
          outputConfigBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.privacy.dlp.v2.DlpProto
            .internal_static_google_privacy_dlp_v2_Action_SaveFindings_descriptor;
      }

      @java.lang.Override
      public com.google.privacy.dlp.v2.Action.SaveFindings getDefaultInstanceForType() {
        return com.google.privacy.dlp.v2.Action.SaveFindings.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.privacy.dlp.v2.Action.SaveFindings build() {
        com.google.privacy.dlp.v2.Action.SaveFindings result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.privacy.dlp.v2.Action.SaveFindings buildPartial() {
        com.google.privacy.dlp.v2.Action.SaveFindings result =
            new com.google.privacy.dlp.v2.Action.SaveFindings(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.privacy.dlp.v2.Action.SaveFindings result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.outputConfig_ =
              outputConfigBuilder_ == null ? outputConfig_ : outputConfigBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.privacy.dlp.v2.Action.SaveFindings) {
          return mergeFrom((com.google.privacy.dlp.v2.Action.SaveFindings) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.privacy.dlp.v2.Action.SaveFindings other) {
        if (other == com.google.privacy.dlp.v2.Action.SaveFindings.getDefaultInstance())
          return this;
        if (other.hasOutputConfig()) {
          mergeOutputConfig(other.getOutputConfig());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getOutputConfigFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.privacy.dlp.v2.OutputStorageConfig outputConfig_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.privacy.dlp.v2.OutputStorageConfig,
              com.google.privacy.dlp.v2.OutputStorageConfig.Builder,
              com.google.privacy.dlp.v2.OutputStorageConfigOrBuilder>
          outputConfigBuilder_;
      /**
       *
       *
       * <pre>
       * Location to store findings outside of DLP.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.OutputStorageConfig output_config = 1;</code>
       *
       * @return Whether the outputConfig field is set.
       */
      public boolean hasOutputConfig() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * Location to store findings outside of DLP.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.OutputStorageConfig output_config = 1;</code>
       *
       * @return The outputConfig.
       */
      public com.google.privacy.dlp.v2.OutputStorageConfig getOutputConfig() {
        if (outputConfigBuilder_ == null) {
          return outputConfig_ == null
              ? com.google.privacy.dlp.v2.OutputStorageConfig.getDefaultInstance()
              : outputConfig_;
        } else {
          return outputConfigBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Location to store findings outside of DLP.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.OutputStorageConfig output_config = 1;</code>
       */
      public Builder setOutputConfig(com.google.privacy.dlp.v2.OutputStorageConfig value) {
        if (outputConfigBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          outputConfig_ = value;
        } else {
          outputConfigBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Location to store findings outside of DLP.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.OutputStorageConfig output_config = 1;</code>
       */
      public Builder setOutputConfig(
          com.google.privacy.dlp.v2.OutputStorageConfig.Builder builderForValue) {
        if (outputConfigBuilder_ == null) {
          outputConfig_ = builderForValue.build();
        } else {
          outputConfigBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Location to store findings outside of DLP.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.OutputStorageConfig output_config = 1;</code>
       */
      public Builder mergeOutputConfig(com.google.privacy.dlp.v2.OutputStorageConfig value) {
        if (outputConfigBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && outputConfig_ != null
              && outputConfig_
                  != com.google.privacy.dlp.v2.OutputStorageConfig.getDefaultInstance()) {
            getOutputConfigBuilder().mergeFrom(value);
          } else {
            outputConfig_ = value;
          }
        } else {
          outputConfigBuilder_.mergeFrom(value);
        }
        if (outputConfig_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Location to store findings outside of DLP.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.OutputStorageConfig output_config = 1;</code>
       */
      public Builder clearOutputConfig() {
        bitField0_ = (bitField0_ & ~0x00000001);
        outputConfig_ = null;
        if (outputConfigBuilder_ != null) {
          outputConfigBuilder_.dispose();
          outputConfigBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Location to store findings outside of DLP.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.OutputStorageConfig output_config = 1;</code>
       */
      public com.google.privacy.dlp.v2.OutputStorageConfig.Builder getOutputConfigBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getOutputConfigFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Location to store findings outside of DLP.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.OutputStorageConfig output_config = 1;</code>
       */
      public com.google.privacy.dlp.v2.OutputStorageConfigOrBuilder getOutputConfigOrBuilder() {
        if (outputConfigBuilder_ != null) {
          return outputConfigBuilder_.getMessageOrBuilder();
        } else {
          return outputConfig_ == null
              ? com.google.privacy.dlp.v2.OutputStorageConfig.getDefaultInstance()
              : outputConfig_;
        }
      }
      /**
       *
       *
       * <pre>
       * Location to store findings outside of DLP.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.OutputStorageConfig output_config = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.privacy.dlp.v2.OutputStorageConfig,
              com.google.privacy.dlp.v2.OutputStorageConfig.Builder,
              com.google.privacy.dlp.v2.OutputStorageConfigOrBuilder>
          getOutputConfigFieldBuilder() {
        if (outputConfigBuilder_ == null) {
          outputConfigBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.privacy.dlp.v2.OutputStorageConfig,
                  com.google.privacy.dlp.v2.OutputStorageConfig.Builder,
                  com.google.privacy.dlp.v2.OutputStorageConfigOrBuilder>(
                  getOutputConfig(), getParentForChildren(), isClean());
          outputConfig_ = null;
        }
        return outputConfigBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.privacy.dlp.v2.Action.SaveFindings)
    }

    // @@protoc_insertion_point(class_scope:google.privacy.dlp.v2.Action.SaveFindings)
    private static final com.google.privacy.dlp.v2.Action.SaveFindings DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.privacy.dlp.v2.Action.SaveFindings();
    }

    public static com.google.privacy.dlp.v2.Action.SaveFindings getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<SaveFindings> PARSER =
        new com.google.protobuf.AbstractParser<SaveFindings>() {
          @java.lang.Override
          public SaveFindings parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<SaveFindings> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<SaveFindings> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.Action.SaveFindings getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface PublishToPubSubOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.privacy.dlp.v2.Action.PublishToPubSub)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Cloud Pub/Sub topic to send notifications to. The topic must have given
     * publishing access rights to the DLP API service account executing
     * the long running DlpJob sending the notifications.
     * Format is projects/{project}/topics/{topic}.
     * </pre>
     *
     * <code>string topic = 1;</code>
     *
     * @return The topic.
     */
    java.lang.String getTopic();
    /**
     *
     *
     * <pre>
     * Cloud Pub/Sub topic to send notifications to. The topic must have given
     * publishing access rights to the DLP API service account executing
     * the long running DlpJob sending the notifications.
     * Format is projects/{project}/topics/{topic}.
     * </pre>
     *
     * <code>string topic = 1;</code>
     *
     * @return The bytes for topic.
     */
    com.google.protobuf.ByteString getTopicBytes();
  }
  /**
   *
   *
   * <pre>
   * Publish a message into a given Pub/Sub topic when DlpJob has completed. The
   * message contains a single field, `DlpJobName`, which is equal to the
   * finished job's
   * [`DlpJob.name`](https://cloud.google.com/sensitive-data-protection/docs/reference/rest/v2/projects.dlpJobs#DlpJob).
   * Compatible with: Inspect, Risk
   * </pre>
   *
   * Protobuf type {@code google.privacy.dlp.v2.Action.PublishToPubSub}
   */
  public static final class PublishToPubSub extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.privacy.dlp.v2.Action.PublishToPubSub)
      PublishToPubSubOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use PublishToPubSub.newBuilder() to construct.
    private PublishToPubSub(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private PublishToPubSub() {
      topic_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new PublishToPubSub();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_Action_PublishToPubSub_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_Action_PublishToPubSub_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.privacy.dlp.v2.Action.PublishToPubSub.class,
              com.google.privacy.dlp.v2.Action.PublishToPubSub.Builder.class);
    }

    public static final int TOPIC_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object topic_ = "";
    /**
     *
     *
     * <pre>
     * Cloud Pub/Sub topic to send notifications to. The topic must have given
     * publishing access rights to the DLP API service account executing
     * the long running DlpJob sending the notifications.
     * Format is projects/{project}/topics/{topic}.
     * </pre>
     *
     * <code>string topic = 1;</code>
     *
     * @return The topic.
     */
    @java.lang.Override
    public java.lang.String getTopic() {
      java.lang.Object ref = topic_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        topic_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Cloud Pub/Sub topic to send notifications to. The topic must have given
     * publishing access rights to the DLP API service account executing
     * the long running DlpJob sending the notifications.
     * Format is projects/{project}/topics/{topic}.
     * </pre>
     *
     * <code>string topic = 1;</code>
     *
     * @return The bytes for topic.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getTopicBytes() {
      java.lang.Object ref = topic_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        topic_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(topic_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, topic_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(topic_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, topic_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.privacy.dlp.v2.Action.PublishToPubSub)) {
        return super.equals(obj);
      }
      com.google.privacy.dlp.v2.Action.PublishToPubSub other =
          (com.google.privacy.dlp.v2.Action.PublishToPubSub) obj;

      if (!getTopic().equals(other.getTopic())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + TOPIC_FIELD_NUMBER;
      hash = (53 * hash) + getTopic().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.privacy.dlp.v2.Action.PublishToPubSub parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.privacy.dlp.v2.Action.PublishToPubSub parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.Action.PublishToPubSub parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.privacy.dlp.v2.Action.PublishToPubSub parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.Action.PublishToPubSub parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.privacy.dlp.v2.Action.PublishToPubSub parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.Action.PublishToPubSub parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.privacy.dlp.v2.Action.PublishToPubSub parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.Action.PublishToPubSub parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.privacy.dlp.v2.Action.PublishToPubSub parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.Action.PublishToPubSub parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.privacy.dlp.v2.Action.PublishToPubSub parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.privacy.dlp.v2.Action.PublishToPubSub prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Publish a message into a given Pub/Sub topic when DlpJob has completed. The
     * message contains a single field, `DlpJobName`, which is equal to the
     * finished job's
     * [`DlpJob.name`](https://cloud.google.com/sensitive-data-protection/docs/reference/rest/v2/projects.dlpJobs#DlpJob).
     * Compatible with: Inspect, Risk
     * </pre>
     *
     * Protobuf type {@code google.privacy.dlp.v2.Action.PublishToPubSub}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.privacy.dlp.v2.Action.PublishToPubSub)
        com.google.privacy.dlp.v2.Action.PublishToPubSubOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.privacy.dlp.v2.DlpProto
            .internal_static_google_privacy_dlp_v2_Action_PublishToPubSub_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.privacy.dlp.v2.DlpProto
            .internal_static_google_privacy_dlp_v2_Action_PublishToPubSub_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.privacy.dlp.v2.Action.PublishToPubSub.class,
                com.google.privacy.dlp.v2.Action.PublishToPubSub.Builder.class);
      }

      // Construct using com.google.privacy.dlp.v2.Action.PublishToPubSub.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        topic_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.privacy.dlp.v2.DlpProto
            .internal_static_google_privacy_dlp_v2_Action_PublishToPubSub_descriptor;
      }

      @java.lang.Override
      public com.google.privacy.dlp.v2.Action.PublishToPubSub getDefaultInstanceForType() {
        return com.google.privacy.dlp.v2.Action.PublishToPubSub.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.privacy.dlp.v2.Action.PublishToPubSub build() {
        com.google.privacy.dlp.v2.Action.PublishToPubSub result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.privacy.dlp.v2.Action.PublishToPubSub buildPartial() {
        com.google.privacy.dlp.v2.Action.PublishToPubSub result =
            new com.google.privacy.dlp.v2.Action.PublishToPubSub(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.privacy.dlp.v2.Action.PublishToPubSub result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.topic_ = topic_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.privacy.dlp.v2.Action.PublishToPubSub) {
          return mergeFrom((com.google.privacy.dlp.v2.Action.PublishToPubSub) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.privacy.dlp.v2.Action.PublishToPubSub other) {
        if (other == com.google.privacy.dlp.v2.Action.PublishToPubSub.getDefaultInstance())
          return this;
        if (!other.getTopic().isEmpty()) {
          topic_ = other.topic_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  topic_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object topic_ = "";
      /**
       *
       *
       * <pre>
       * Cloud Pub/Sub topic to send notifications to. The topic must have given
       * publishing access rights to the DLP API service account executing
       * the long running DlpJob sending the notifications.
       * Format is projects/{project}/topics/{topic}.
       * </pre>
       *
       * <code>string topic = 1;</code>
       *
       * @return The topic.
       */
      public java.lang.String getTopic() {
        java.lang.Object ref = topic_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          topic_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Cloud Pub/Sub topic to send notifications to. The topic must have given
       * publishing access rights to the DLP API service account executing
       * the long running DlpJob sending the notifications.
       * Format is projects/{project}/topics/{topic}.
       * </pre>
       *
       * <code>string topic = 1;</code>
       *
       * @return The bytes for topic.
       */
      public com.google.protobuf.ByteString getTopicBytes() {
        java.lang.Object ref = topic_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          topic_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Cloud Pub/Sub topic to send notifications to. The topic must have given
       * publishing access rights to the DLP API service account executing
       * the long running DlpJob sending the notifications.
       * Format is projects/{project}/topics/{topic}.
       * </pre>
       *
       * <code>string topic = 1;</code>
       *
       * @param value The topic to set.
       * @return This builder for chaining.
       */
      public Builder setTopic(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        topic_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Cloud Pub/Sub topic to send notifications to. The topic must have given
       * publishing access rights to the DLP API service account executing
       * the long running DlpJob sending the notifications.
       * Format is projects/{project}/topics/{topic}.
       * </pre>
       *
       * <code>string topic = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTopic() {
        topic_ = getDefaultInstance().getTopic();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Cloud Pub/Sub topic to send notifications to. The topic must have given
       * publishing access rights to the DLP API service account executing
       * the long running DlpJob sending the notifications.
       * Format is projects/{project}/topics/{topic}.
       * </pre>
       *
       * <code>string topic = 1;</code>
       *
       * @param value The bytes for topic to set.
       * @return This builder for chaining.
       */
      public Builder setTopicBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        topic_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.privacy.dlp.v2.Action.PublishToPubSub)
    }

    // @@protoc_insertion_point(class_scope:google.privacy.dlp.v2.Action.PublishToPubSub)
    private static final com.google.privacy.dlp.v2.Action.PublishToPubSub DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.privacy.dlp.v2.Action.PublishToPubSub();
    }

    public static com.google.privacy.dlp.v2.Action.PublishToPubSub getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<PublishToPubSub> PARSER =
        new com.google.protobuf.AbstractParser<PublishToPubSub>() {
          @java.lang.Override
          public PublishToPubSub parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<PublishToPubSub> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<PublishToPubSub> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.Action.PublishToPubSub getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface PublishSummaryToCsccOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.privacy.dlp.v2.Action.PublishSummaryToCscc)
      com.google.protobuf.MessageOrBuilder {}
  /**
   *
   *
   * <pre>
   * Publish the result summary of a DlpJob to [Security Command
   * Center](https://cloud.google.com/security-command-center). This action is
   * available for only projects that belong to an organization. This action
   * publishes the count of finding instances and their infoTypes. The summary
   * of findings are persisted in Security Command Center and are governed by
   * [service-specific policies for Security Command
   * Center](https://cloud.google.com/terms/service-terms). Only a single
   * instance of this action can be specified. Compatible with: Inspect
   * </pre>
   *
   * Protobuf type {@code google.privacy.dlp.v2.Action.PublishSummaryToCscc}
   */
  public static final class PublishSummaryToCscc extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.privacy.dlp.v2.Action.PublishSummaryToCscc)
      PublishSummaryToCsccOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use PublishSummaryToCscc.newBuilder() to construct.
    private PublishSummaryToCscc(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private PublishSummaryToCscc() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new PublishSummaryToCscc();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_Action_PublishSummaryToCscc_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_Action_PublishSummaryToCscc_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.privacy.dlp.v2.Action.PublishSummaryToCscc.class,
              com.google.privacy.dlp.v2.Action.PublishSummaryToCscc.Builder.class);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.privacy.dlp.v2.Action.PublishSummaryToCscc)) {
        return super.equals(obj);
      }
      com.google.privacy.dlp.v2.Action.PublishSummaryToCscc other =
          (com.google.privacy.dlp.v2.Action.PublishSummaryToCscc) obj;

      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.privacy.dlp.v2.Action.PublishSummaryToCscc parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.privacy.dlp.v2.Action.PublishSummaryToCscc parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.Action.PublishSummaryToCscc parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.privacy.dlp.v2.Action.PublishSummaryToCscc parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.Action.PublishSummaryToCscc parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.privacy.dlp.v2.Action.PublishSummaryToCscc parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.Action.PublishSummaryToCscc parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.privacy.dlp.v2.Action.PublishSummaryToCscc parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.Action.PublishSummaryToCscc parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.privacy.dlp.v2.Action.PublishSummaryToCscc parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.Action.PublishSummaryToCscc parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.privacy.dlp.v2.Action.PublishSummaryToCscc parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.privacy.dlp.v2.Action.PublishSummaryToCscc prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Publish the result summary of a DlpJob to [Security Command
     * Center](https://cloud.google.com/security-command-center). This action is
     * available for only projects that belong to an organization. This action
     * publishes the count of finding instances and their infoTypes. The summary
     * of findings are persisted in Security Command Center and are governed by
     * [service-specific policies for Security Command
     * Center](https://cloud.google.com/terms/service-terms). Only a single
     * instance of this action can be specified. Compatible with: Inspect
     * </pre>
     *
     * Protobuf type {@code google.privacy.dlp.v2.Action.PublishSummaryToCscc}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.privacy.dlp.v2.Action.PublishSummaryToCscc)
        com.google.privacy.dlp.v2.Action.PublishSummaryToCsccOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.privacy.dlp.v2.DlpProto
            .internal_static_google_privacy_dlp_v2_Action_PublishSummaryToCscc_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.privacy.dlp.v2.DlpProto
            .internal_static_google_privacy_dlp_v2_Action_PublishSummaryToCscc_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.privacy.dlp.v2.Action.PublishSummaryToCscc.class,
                com.google.privacy.dlp.v2.Action.PublishSummaryToCscc.Builder.class);
      }

      // Construct using com.google.privacy.dlp.v2.Action.PublishSummaryToCscc.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.privacy.dlp.v2.DlpProto
            .internal_static_google_privacy_dlp_v2_Action_PublishSummaryToCscc_descriptor;
      }

      @java.lang.Override
      public com.google.privacy.dlp.v2.Action.PublishSummaryToCscc getDefaultInstanceForType() {
        return com.google.privacy.dlp.v2.Action.PublishSummaryToCscc.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.privacy.dlp.v2.Action.PublishSummaryToCscc build() {
        com.google.privacy.dlp.v2.Action.PublishSummaryToCscc result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.privacy.dlp.v2.Action.PublishSummaryToCscc buildPartial() {
        com.google.privacy.dlp.v2.Action.PublishSummaryToCscc result =
            new com.google.privacy.dlp.v2.Action.PublishSummaryToCscc(this);
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.privacy.dlp.v2.Action.PublishSummaryToCscc) {
          return mergeFrom((com.google.privacy.dlp.v2.Action.PublishSummaryToCscc) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.privacy.dlp.v2.Action.PublishSummaryToCscc other) {
        if (other == com.google.privacy.dlp.v2.Action.PublishSummaryToCscc.getDefaultInstance())
          return this;
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.privacy.dlp.v2.Action.PublishSummaryToCscc)
    }

    // @@protoc_insertion_point(class_scope:google.privacy.dlp.v2.Action.PublishSummaryToCscc)
    private static final com.google.privacy.dlp.v2.Action.PublishSummaryToCscc DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.privacy.dlp.v2.Action.PublishSummaryToCscc();
    }

    public static com.google.privacy.dlp.v2.Action.PublishSummaryToCscc getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<PublishSummaryToCscc> PARSER =
        new com.google.protobuf.AbstractParser<PublishSummaryToCscc>() {
          @java.lang.Override
          public PublishSummaryToCscc parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<PublishSummaryToCscc> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<PublishSummaryToCscc> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.Action.PublishSummaryToCscc getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface PublishFindingsToCloudDataCatalogOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.privacy.dlp.v2.Action.PublishFindingsToCloudDataCatalog)
      com.google.protobuf.MessageOrBuilder {}
  /**
   *
   *
   * <pre>
   * Publish findings of a DlpJob to Data Catalog. In Data Catalog, tag
   * templates are applied to the resource that Cloud DLP scanned. Data
   * Catalog tag templates are stored in the same project and region where the
   * BigQuery table exists. For Cloud DLP to create and apply the tag template,
   * the Cloud DLP service agent must have the
   * `roles/datacatalog.tagTemplateOwner` permission on the project. The tag
   * template contains fields summarizing the results of the DlpJob. Any field
   * values previously written by another DlpJob are deleted. [InfoType naming
   * patterns][google.privacy.dlp.v2.InfoType] are strictly enforced when using
   * this feature.
   *
   * Findings are persisted in Data Catalog storage and are governed by
   * service-specific policies for Data Catalog. For more information, see
   * [Service Specific Terms](https://cloud.google.com/terms/service-terms).
   *
   * Only a single instance of this action can be specified. This action is
   * allowed only if all resources being scanned are BigQuery tables.
   * Compatible with: Inspect
   * </pre>
   *
   * Protobuf type {@code google.privacy.dlp.v2.Action.PublishFindingsToCloudDataCatalog}
   */
  public static final class PublishFindingsToCloudDataCatalog
      extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.privacy.dlp.v2.Action.PublishFindingsToCloudDataCatalog)
      PublishFindingsToCloudDataCatalogOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use PublishFindingsToCloudDataCatalog.newBuilder() to construct.
    private PublishFindingsToCloudDataCatalog(
        com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private PublishFindingsToCloudDataCatalog() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new PublishFindingsToCloudDataCatalog();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_Action_PublishFindingsToCloudDataCatalog_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_Action_PublishFindingsToCloudDataCatalog_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.privacy.dlp.v2.Action.PublishFindingsToCloudDataCatalog.class,
              com.google.privacy.dlp.v2.Action.PublishFindingsToCloudDataCatalog.Builder.class);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.privacy.dlp.v2.Action.PublishFindingsToCloudDataCatalog)) {
        return super.equals(obj);
      }
      com.google.privacy.dlp.v2.Action.PublishFindingsToCloudDataCatalog other =
          (com.google.privacy.dlp.v2.Action.PublishFindingsToCloudDataCatalog) obj;

      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.privacy.dlp.v2.Action.PublishFindingsToCloudDataCatalog parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.privacy.dlp.v2.Action.PublishFindingsToCloudDataCatalog parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.Action.PublishFindingsToCloudDataCatalog parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.privacy.dlp.v2.Action.PublishFindingsToCloudDataCatalog parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.Action.PublishFindingsToCloudDataCatalog parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.privacy.dlp.v2.Action.PublishFindingsToCloudDataCatalog parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.Action.PublishFindingsToCloudDataCatalog parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.privacy.dlp.v2.Action.PublishFindingsToCloudDataCatalog parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.Action.PublishFindingsToCloudDataCatalog
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.privacy.dlp.v2.Action.PublishFindingsToCloudDataCatalog
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.Action.PublishFindingsToCloudDataCatalog parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.privacy.dlp.v2.Action.PublishFindingsToCloudDataCatalog parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.privacy.dlp.v2.Action.PublishFindingsToCloudDataCatalog prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Publish findings of a DlpJob to Data Catalog. In Data Catalog, tag
     * templates are applied to the resource that Cloud DLP scanned. Data
     * Catalog tag templates are stored in the same project and region where the
     * BigQuery table exists. For Cloud DLP to create and apply the tag template,
     * the Cloud DLP service agent must have the
     * `roles/datacatalog.tagTemplateOwner` permission on the project. The tag
     * template contains fields summarizing the results of the DlpJob. Any field
     * values previously written by another DlpJob are deleted. [InfoType naming
     * patterns][google.privacy.dlp.v2.InfoType] are strictly enforced when using
     * this feature.
     *
     * Findings are persisted in Data Catalog storage and are governed by
     * service-specific policies for Data Catalog. For more information, see
     * [Service Specific Terms](https://cloud.google.com/terms/service-terms).
     *
     * Only a single instance of this action can be specified. This action is
     * allowed only if all resources being scanned are BigQuery tables.
     * Compatible with: Inspect
     * </pre>
     *
     * Protobuf type {@code google.privacy.dlp.v2.Action.PublishFindingsToCloudDataCatalog}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.privacy.dlp.v2.Action.PublishFindingsToCloudDataCatalog)
        com.google.privacy.dlp.v2.Action.PublishFindingsToCloudDataCatalogOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.privacy.dlp.v2.DlpProto
            .internal_static_google_privacy_dlp_v2_Action_PublishFindingsToCloudDataCatalog_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.privacy.dlp.v2.DlpProto
            .internal_static_google_privacy_dlp_v2_Action_PublishFindingsToCloudDataCatalog_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.privacy.dlp.v2.Action.PublishFindingsToCloudDataCatalog.class,
                com.google.privacy.dlp.v2.Action.PublishFindingsToCloudDataCatalog.Builder.class);
      }

      // Construct using
      // com.google.privacy.dlp.v2.Action.PublishFindingsToCloudDataCatalog.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.privacy.dlp.v2.DlpProto
            .internal_static_google_privacy_dlp_v2_Action_PublishFindingsToCloudDataCatalog_descriptor;
      }

      @java.lang.Override
      public com.google.privacy.dlp.v2.Action.PublishFindingsToCloudDataCatalog
          getDefaultInstanceForType() {
        return com.google.privacy.dlp.v2.Action.PublishFindingsToCloudDataCatalog
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.privacy.dlp.v2.Action.PublishFindingsToCloudDataCatalog build() {
        com.google.privacy.dlp.v2.Action.PublishFindingsToCloudDataCatalog result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.privacy.dlp.v2.Action.PublishFindingsToCloudDataCatalog buildPartial() {
        com.google.privacy.dlp.v2.Action.PublishFindingsToCloudDataCatalog result =
            new com.google.privacy.dlp.v2.Action.PublishFindingsToCloudDataCatalog(this);
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.privacy.dlp.v2.Action.PublishFindingsToCloudDataCatalog) {
          return mergeFrom(
              (com.google.privacy.dlp.v2.Action.PublishFindingsToCloudDataCatalog) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.privacy.dlp.v2.Action.PublishFindingsToCloudDataCatalog other) {
        if (other
            == com.google.privacy.dlp.v2.Action.PublishFindingsToCloudDataCatalog
                .getDefaultInstance()) return this;
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.privacy.dlp.v2.Action.PublishFindingsToCloudDataCatalog)
    }

    // @@protoc_insertion_point(class_scope:google.privacy.dlp.v2.Action.PublishFindingsToCloudDataCatalog)
    private static final com.google.privacy.dlp.v2.Action.PublishFindingsToCloudDataCatalog
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.privacy.dlp.v2.Action.PublishFindingsToCloudDataCatalog();
    }

    public static com.google.privacy.dlp.v2.Action.PublishFindingsToCloudDataCatalog
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<PublishFindingsToCloudDataCatalog> PARSER =
        new com.google.protobuf.AbstractParser<PublishFindingsToCloudDataCatalog>() {
          @java.lang.Override
          public PublishFindingsToCloudDataCatalog parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<PublishFindingsToCloudDataCatalog> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<PublishFindingsToCloudDataCatalog> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.Action.PublishFindingsToCloudDataCatalog
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface DeidentifyOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.privacy.dlp.v2.Action.Deidentify)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * User specified deidentify templates and configs for structured,
     * unstructured, and image files.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.TransformationConfig transformation_config = 7;</code>
     *
     * @return Whether the transformationConfig field is set.
     */
    boolean hasTransformationConfig();
    /**
     *
     *
     * <pre>
     * User specified deidentify templates and configs for structured,
     * unstructured, and image files.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.TransformationConfig transformation_config = 7;</code>
     *
     * @return The transformationConfig.
     */
    com.google.privacy.dlp.v2.TransformationConfig getTransformationConfig();
    /**
     *
     *
     * <pre>
     * User specified deidentify templates and configs for structured,
     * unstructured, and image files.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.TransformationConfig transformation_config = 7;</code>
     */
    com.google.privacy.dlp.v2.TransformationConfigOrBuilder getTransformationConfigOrBuilder();

    /**
     *
     *
     * <pre>
     * Config for storing transformation details. This is separate from the
     * de-identified content, and contains metadata about the successful
     * transformations and/or failures that occurred while de-identifying. This
     * needs to be set in order for users to access information about the status
     * of each transformation (see
     * [TransformationDetails][google.privacy.dlp.v2.TransformationDetails]
     * message for more information about what is noted).
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.TransformationDetailsStorageConfig transformation_details_storage_config = 3;
     * </code>
     *
     * @return Whether the transformationDetailsStorageConfig field is set.
     */
    boolean hasTransformationDetailsStorageConfig();
    /**
     *
     *
     * <pre>
     * Config for storing transformation details. This is separate from the
     * de-identified content, and contains metadata about the successful
     * transformations and/or failures that occurred while de-identifying. This
     * needs to be set in order for users to access information about the status
     * of each transformation (see
     * [TransformationDetails][google.privacy.dlp.v2.TransformationDetails]
     * message for more information about what is noted).
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.TransformationDetailsStorageConfig transformation_details_storage_config = 3;
     * </code>
     *
     * @return The transformationDetailsStorageConfig.
     */
    com.google.privacy.dlp.v2.TransformationDetailsStorageConfig
        getTransformationDetailsStorageConfig();
    /**
     *
     *
     * <pre>
     * Config for storing transformation details. This is separate from the
     * de-identified content, and contains metadata about the successful
     * transformations and/or failures that occurred while de-identifying. This
     * needs to be set in order for users to access information about the status
     * of each transformation (see
     * [TransformationDetails][google.privacy.dlp.v2.TransformationDetails]
     * message for more information about what is noted).
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.TransformationDetailsStorageConfig transformation_details_storage_config = 3;
     * </code>
     */
    com.google.privacy.dlp.v2.TransformationDetailsStorageConfigOrBuilder
        getTransformationDetailsStorageConfigOrBuilder();

    /**
     *
     *
     * <pre>
     * Required. User settable Cloud Storage bucket and folders to store
     * de-identified files. This field must be set for cloud storage
     * deidentification. The output Cloud Storage bucket must be different
     * from the input bucket. De-identified files will overwrite files in the
     * output path.
     *
     * Form of: gs://bucket/folder/ or gs://bucket
     * </pre>
     *
     * <code>string cloud_storage_output = 9 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return Whether the cloudStorageOutput field is set.
     */
    boolean hasCloudStorageOutput();
    /**
     *
     *
     * <pre>
     * Required. User settable Cloud Storage bucket and folders to store
     * de-identified files. This field must be set for cloud storage
     * deidentification. The output Cloud Storage bucket must be different
     * from the input bucket. De-identified files will overwrite files in the
     * output path.
     *
     * Form of: gs://bucket/folder/ or gs://bucket
     * </pre>
     *
     * <code>string cloud_storage_output = 9 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The cloudStorageOutput.
     */
    java.lang.String getCloudStorageOutput();
    /**
     *
     *
     * <pre>
     * Required. User settable Cloud Storage bucket and folders to store
     * de-identified files. This field must be set for cloud storage
     * deidentification. The output Cloud Storage bucket must be different
     * from the input bucket. De-identified files will overwrite files in the
     * output path.
     *
     * Form of: gs://bucket/folder/ or gs://bucket
     * </pre>
     *
     * <code>string cloud_storage_output = 9 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for cloudStorageOutput.
     */
    com.google.protobuf.ByteString getCloudStorageOutputBytes();

    /**
     *
     *
     * <pre>
     * List of user-specified file type groups to transform. If specified, only
     * the files with these filetypes will be transformed. If empty, all
     * supported files will be transformed. Supported types may be automatically
     * added over time. If a file type is set in this field that isn't supported
     * by the Deidentify action then the job will fail and will not be
     * successfully created/started. Currently the only filetypes supported are:
     * IMAGES, TEXT_FILES, CSV, TSV.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.FileType file_types_to_transform = 8;</code>
     *
     * @return A list containing the fileTypesToTransform.
     */
    java.util.List<com.google.privacy.dlp.v2.FileType> getFileTypesToTransformList();
    /**
     *
     *
     * <pre>
     * List of user-specified file type groups to transform. If specified, only
     * the files with these filetypes will be transformed. If empty, all
     * supported files will be transformed. Supported types may be automatically
     * added over time. If a file type is set in this field that isn't supported
     * by the Deidentify action then the job will fail and will not be
     * successfully created/started. Currently the only filetypes supported are:
     * IMAGES, TEXT_FILES, CSV, TSV.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.FileType file_types_to_transform = 8;</code>
     *
     * @return The count of fileTypesToTransform.
     */
    int getFileTypesToTransformCount();
    /**
     *
     *
     * <pre>
     * List of user-specified file type groups to transform. If specified, only
     * the files with these filetypes will be transformed. If empty, all
     * supported files will be transformed. Supported types may be automatically
     * added over time. If a file type is set in this field that isn't supported
     * by the Deidentify action then the job will fail and will not be
     * successfully created/started. Currently the only filetypes supported are:
     * IMAGES, TEXT_FILES, CSV, TSV.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.FileType file_types_to_transform = 8;</code>
     *
     * @param index The index of the element to return.
     * @return The fileTypesToTransform at the given index.
     */
    com.google.privacy.dlp.v2.FileType getFileTypesToTransform(int index);
    /**
     *
     *
     * <pre>
     * List of user-specified file type groups to transform. If specified, only
     * the files with these filetypes will be transformed. If empty, all
     * supported files will be transformed. Supported types may be automatically
     * added over time. If a file type is set in this field that isn't supported
     * by the Deidentify action then the job will fail and will not be
     * successfully created/started. Currently the only filetypes supported are:
     * IMAGES, TEXT_FILES, CSV, TSV.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.FileType file_types_to_transform = 8;</code>
     *
     * @return A list containing the enum numeric values on the wire for fileTypesToTransform.
     */
    java.util.List<java.lang.Integer> getFileTypesToTransformValueList();
    /**
     *
     *
     * <pre>
     * List of user-specified file type groups to transform. If specified, only
     * the files with these filetypes will be transformed. If empty, all
     * supported files will be transformed. Supported types may be automatically
     * added over time. If a file type is set in this field that isn't supported
     * by the Deidentify action then the job will fail and will not be
     * successfully created/started. Currently the only filetypes supported are:
     * IMAGES, TEXT_FILES, CSV, TSV.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.FileType file_types_to_transform = 8;</code>
     *
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of fileTypesToTransform at the given index.
     */
    int getFileTypesToTransformValue(int index);

    com.google.privacy.dlp.v2.Action.Deidentify.OutputCase getOutputCase();
  }
  /**
   *
   *
   * <pre>
   * Create a de-identified copy of the requested table or files.
   *
   * A TransformationDetail will be created for each transformation.
   *
   * If any rows in BigQuery are skipped during de-identification
   * (transformation errors or row size exceeds BigQuery insert API limits) they
   * are placed in the failure output table. If the original row exceeds
   * the BigQuery insert API limit it will be truncated when written to the
   * failure output table. The failure output table can be set in the
   * action.deidentify.output.big_query_output.deidentified_failure_output_table
   * field, if no table is set, a table will be automatically created in the
   * same project and dataset as the original table.
   *
   * Compatible with: Inspect
   * </pre>
   *
   * Protobuf type {@code google.privacy.dlp.v2.Action.Deidentify}
   */
  public static final class Deidentify extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.privacy.dlp.v2.Action.Deidentify)
      DeidentifyOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Deidentify.newBuilder() to construct.
    private Deidentify(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Deidentify() {
      fileTypesToTransform_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Deidentify();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_Action_Deidentify_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_Action_Deidentify_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.privacy.dlp.v2.Action.Deidentify.class,
              com.google.privacy.dlp.v2.Action.Deidentify.Builder.class);
    }

    private int bitField0_;
    private int outputCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object output_;

    public enum OutputCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      CLOUD_STORAGE_OUTPUT(9),
      OUTPUT_NOT_SET(0);
      private final int value;

      private OutputCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static OutputCase valueOf(int value) {
        return forNumber(value);
      }

      public static OutputCase forNumber(int value) {
        switch (value) {
          case 9:
            return CLOUD_STORAGE_OUTPUT;
          case 0:
            return OUTPUT_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public OutputCase getOutputCase() {
      return OutputCase.forNumber(outputCase_);
    }

    public static final int TRANSFORMATION_CONFIG_FIELD_NUMBER = 7;
    private com.google.privacy.dlp.v2.TransformationConfig transformationConfig_;
    /**
     *
     *
     * <pre>
     * User specified deidentify templates and configs for structured,
     * unstructured, and image files.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.TransformationConfig transformation_config = 7;</code>
     *
     * @return Whether the transformationConfig field is set.
     */
    @java.lang.Override
    public boolean hasTransformationConfig() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * User specified deidentify templates and configs for structured,
     * unstructured, and image files.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.TransformationConfig transformation_config = 7;</code>
     *
     * @return The transformationConfig.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.TransformationConfig getTransformationConfig() {
      return transformationConfig_ == null
          ? com.google.privacy.dlp.v2.TransformationConfig.getDefaultInstance()
          : transformationConfig_;
    }
    /**
     *
     *
     * <pre>
     * User specified deidentify templates and configs for structured,
     * unstructured, and image files.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.TransformationConfig transformation_config = 7;</code>
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.TransformationConfigOrBuilder
        getTransformationConfigOrBuilder() {
      return transformationConfig_ == null
          ? com.google.privacy.dlp.v2.TransformationConfig.getDefaultInstance()
          : transformationConfig_;
    }

    public static final int TRANSFORMATION_DETAILS_STORAGE_CONFIG_FIELD_NUMBER = 3;
    private com.google.privacy.dlp.v2.TransformationDetailsStorageConfig
        transformationDetailsStorageConfig_;
    /**
     *
     *
     * <pre>
     * Config for storing transformation details. This is separate from the
     * de-identified content, and contains metadata about the successful
     * transformations and/or failures that occurred while de-identifying. This
     * needs to be set in order for users to access information about the status
     * of each transformation (see
     * [TransformationDetails][google.privacy.dlp.v2.TransformationDetails]
     * message for more information about what is noted).
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.TransformationDetailsStorageConfig transformation_details_storage_config = 3;
     * </code>
     *
     * @return Whether the transformationDetailsStorageConfig field is set.
     */
    @java.lang.Override
    public boolean hasTransformationDetailsStorageConfig() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Config for storing transformation details. This is separate from the
     * de-identified content, and contains metadata about the successful
     * transformations and/or failures that occurred while de-identifying. This
     * needs to be set in order for users to access information about the status
     * of each transformation (see
     * [TransformationDetails][google.privacy.dlp.v2.TransformationDetails]
     * message for more information about what is noted).
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.TransformationDetailsStorageConfig transformation_details_storage_config = 3;
     * </code>
     *
     * @return The transformationDetailsStorageConfig.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.TransformationDetailsStorageConfig
        getTransformationDetailsStorageConfig() {
      return transformationDetailsStorageConfig_ == null
          ? com.google.privacy.dlp.v2.TransformationDetailsStorageConfig.getDefaultInstance()
          : transformationDetailsStorageConfig_;
    }
    /**
     *
     *
     * <pre>
     * Config for storing transformation details. This is separate from the
     * de-identified content, and contains metadata about the successful
     * transformations and/or failures that occurred while de-identifying. This
     * needs to be set in order for users to access information about the status
     * of each transformation (see
     * [TransformationDetails][google.privacy.dlp.v2.TransformationDetails]
     * message for more information about what is noted).
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.TransformationDetailsStorageConfig transformation_details_storage_config = 3;
     * </code>
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.TransformationDetailsStorageConfigOrBuilder
        getTransformationDetailsStorageConfigOrBuilder() {
      return transformationDetailsStorageConfig_ == null
          ? com.google.privacy.dlp.v2.TransformationDetailsStorageConfig.getDefaultInstance()
          : transformationDetailsStorageConfig_;
    }

    public static final int CLOUD_STORAGE_OUTPUT_FIELD_NUMBER = 9;
    /**
     *
     *
     * <pre>
     * Required. User settable Cloud Storage bucket and folders to store
     * de-identified files. This field must be set for cloud storage
     * deidentification. The output Cloud Storage bucket must be different
     * from the input bucket. De-identified files will overwrite files in the
     * output path.
     *
     * Form of: gs://bucket/folder/ or gs://bucket
     * </pre>
     *
     * <code>string cloud_storage_output = 9 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return Whether the cloudStorageOutput field is set.
     */
    public boolean hasCloudStorageOutput() {
      return outputCase_ == 9;
    }
    /**
     *
     *
     * <pre>
     * Required. User settable Cloud Storage bucket and folders to store
     * de-identified files. This field must be set for cloud storage
     * deidentification. The output Cloud Storage bucket must be different
     * from the input bucket. De-identified files will overwrite files in the
     * output path.
     *
     * Form of: gs://bucket/folder/ or gs://bucket
     * </pre>
     *
     * <code>string cloud_storage_output = 9 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The cloudStorageOutput.
     */
    public java.lang.String getCloudStorageOutput() {
      java.lang.Object ref = "";
      if (outputCase_ == 9) {
        ref = output_;
      }
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (outputCase_ == 9) {
          output_ = s;
        }
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. User settable Cloud Storage bucket and folders to store
     * de-identified files. This field must be set for cloud storage
     * deidentification. The output Cloud Storage bucket must be different
     * from the input bucket. De-identified files will overwrite files in the
     * output path.
     *
     * Form of: gs://bucket/folder/ or gs://bucket
     * </pre>
     *
     * <code>string cloud_storage_output = 9 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for cloudStorageOutput.
     */
    public com.google.protobuf.ByteString getCloudStorageOutputBytes() {
      java.lang.Object ref = "";
      if (outputCase_ == 9) {
        ref = output_;
      }
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (outputCase_ == 9) {
          output_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int FILE_TYPES_TO_TRANSFORM_FIELD_NUMBER = 8;

    @SuppressWarnings("serial")
    private java.util.List<java.lang.Integer> fileTypesToTransform_;

    private static final com.google.protobuf.Internal.ListAdapter.Converter<
            java.lang.Integer, com.google.privacy.dlp.v2.FileType>
        fileTypesToTransform_converter_ =
            new com.google.protobuf.Internal.ListAdapter.Converter<
                java.lang.Integer, com.google.privacy.dlp.v2.FileType>() {
              public com.google.privacy.dlp.v2.FileType convert(java.lang.Integer from) {
                com.google.privacy.dlp.v2.FileType result =
                    com.google.privacy.dlp.v2.FileType.forNumber(from);
                return result == null ? com.google.privacy.dlp.v2.FileType.UNRECOGNIZED : result;
              }
            };
    /**
     *
     *
     * <pre>
     * List of user-specified file type groups to transform. If specified, only
     * the files with these filetypes will be transformed. If empty, all
     * supported files will be transformed. Supported types may be automatically
     * added over time. If a file type is set in this field that isn't supported
     * by the Deidentify action then the job will fail and will not be
     * successfully created/started. Currently the only filetypes supported are:
     * IMAGES, TEXT_FILES, CSV, TSV.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.FileType file_types_to_transform = 8;</code>
     *
     * @return A list containing the fileTypesToTransform.
     */
    @java.lang.Override
    public java.util.List<com.google.privacy.dlp.v2.FileType> getFileTypesToTransformList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer, com.google.privacy.dlp.v2.FileType>(
          fileTypesToTransform_, fileTypesToTransform_converter_);
    }
    /**
     *
     *
     * <pre>
     * List of user-specified file type groups to transform. If specified, only
     * the files with these filetypes will be transformed. If empty, all
     * supported files will be transformed. Supported types may be automatically
     * added over time. If a file type is set in this field that isn't supported
     * by the Deidentify action then the job will fail and will not be
     * successfully created/started. Currently the only filetypes supported are:
     * IMAGES, TEXT_FILES, CSV, TSV.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.FileType file_types_to_transform = 8;</code>
     *
     * @return The count of fileTypesToTransform.
     */
    @java.lang.Override
    public int getFileTypesToTransformCount() {
      return fileTypesToTransform_.size();
    }
    /**
     *
     *
     * <pre>
     * List of user-specified file type groups to transform. If specified, only
     * the files with these filetypes will be transformed. If empty, all
     * supported files will be transformed. Supported types may be automatically
     * added over time. If a file type is set in this field that isn't supported
     * by the Deidentify action then the job will fail and will not be
     * successfully created/started. Currently the only filetypes supported are:
     * IMAGES, TEXT_FILES, CSV, TSV.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.FileType file_types_to_transform = 8;</code>
     *
     * @param index The index of the element to return.
     * @return The fileTypesToTransform at the given index.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.FileType getFileTypesToTransform(int index) {
      return fileTypesToTransform_converter_.convert(fileTypesToTransform_.get(index));
    }
    /**
     *
     *
     * <pre>
     * List of user-specified file type groups to transform. If specified, only
     * the files with these filetypes will be transformed. If empty, all
     * supported files will be transformed. Supported types may be automatically
     * added over time. If a file type is set in this field that isn't supported
     * by the Deidentify action then the job will fail and will not be
     * successfully created/started. Currently the only filetypes supported are:
     * IMAGES, TEXT_FILES, CSV, TSV.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.FileType file_types_to_transform = 8;</code>
     *
     * @return A list containing the enum numeric values on the wire for fileTypesToTransform.
     */
    @java.lang.Override
    public java.util.List<java.lang.Integer> getFileTypesToTransformValueList() {
      return fileTypesToTransform_;
    }
    /**
     *
     *
     * <pre>
     * List of user-specified file type groups to transform. If specified, only
     * the files with these filetypes will be transformed. If empty, all
     * supported files will be transformed. Supported types may be automatically
     * added over time. If a file type is set in this field that isn't supported
     * by the Deidentify action then the job will fail and will not be
     * successfully created/started. Currently the only filetypes supported are:
     * IMAGES, TEXT_FILES, CSV, TSV.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.FileType file_types_to_transform = 8;</code>
     *
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of fileTypesToTransform at the given index.
     */
    @java.lang.Override
    public int getFileTypesToTransformValue(int index) {
      return fileTypesToTransform_.get(index);
    }

    private int fileTypesToTransformMemoizedSerializedSize;

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      getSerializedSize();
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeMessage(3, getTransformationDetailsStorageConfig());
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(7, getTransformationConfig());
      }
      if (getFileTypesToTransformList().size() > 0) {
        output.writeUInt32NoTag(66);
        output.writeUInt32NoTag(fileTypesToTransformMemoizedSerializedSize);
      }
      for (int i = 0; i < fileTypesToTransform_.size(); i++) {
        output.writeEnumNoTag(fileTypesToTransform_.get(i));
      }
      if (outputCase_ == 9) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 9, output_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000002) != 0)) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                3, getTransformationDetailsStorageConfig());
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(7, getTransformationConfig());
      }
      {
        int dataSize = 0;
        for (int i = 0; i < fileTypesToTransform_.size(); i++) {
          dataSize +=
              com.google.protobuf.CodedOutputStream.computeEnumSizeNoTag(
                  fileTypesToTransform_.get(i));
        }
        size += dataSize;
        if (!getFileTypesToTransformList().isEmpty()) {
          size += 1;
          size += com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(dataSize);
        }
        fileTypesToTransformMemoizedSerializedSize = dataSize;
      }
      if (outputCase_ == 9) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(9, output_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.privacy.dlp.v2.Action.Deidentify)) {
        return super.equals(obj);
      }
      com.google.privacy.dlp.v2.Action.Deidentify other =
          (com.google.privacy.dlp.v2.Action.Deidentify) obj;

      if (hasTransformationConfig() != other.hasTransformationConfig()) return false;
      if (hasTransformationConfig()) {
        if (!getTransformationConfig().equals(other.getTransformationConfig())) return false;
      }
      if (hasTransformationDetailsStorageConfig() != other.hasTransformationDetailsStorageConfig())
        return false;
      if (hasTransformationDetailsStorageConfig()) {
        if (!getTransformationDetailsStorageConfig()
            .equals(other.getTransformationDetailsStorageConfig())) return false;
      }
      if (!fileTypesToTransform_.equals(other.fileTypesToTransform_)) return false;
      if (!getOutputCase().equals(other.getOutputCase())) return false;
      switch (outputCase_) {
        case 9:
          if (!getCloudStorageOutput().equals(other.getCloudStorageOutput())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasTransformationConfig()) {
        hash = (37 * hash) + TRANSFORMATION_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getTransformationConfig().hashCode();
      }
      if (hasTransformationDetailsStorageConfig()) {
        hash = (37 * hash) + TRANSFORMATION_DETAILS_STORAGE_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getTransformationDetailsStorageConfig().hashCode();
      }
      if (getFileTypesToTransformCount() > 0) {
        hash = (37 * hash) + FILE_TYPES_TO_TRANSFORM_FIELD_NUMBER;
        hash = (53 * hash) + fileTypesToTransform_.hashCode();
      }
      switch (outputCase_) {
        case 9:
          hash = (37 * hash) + CLOUD_STORAGE_OUTPUT_FIELD_NUMBER;
          hash = (53 * hash) + getCloudStorageOutput().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.privacy.dlp.v2.Action.Deidentify parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.privacy.dlp.v2.Action.Deidentify parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.Action.Deidentify parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.privacy.dlp.v2.Action.Deidentify parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.Action.Deidentify parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.privacy.dlp.v2.Action.Deidentify parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.Action.Deidentify parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.privacy.dlp.v2.Action.Deidentify parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.Action.Deidentify parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.privacy.dlp.v2.Action.Deidentify parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.Action.Deidentify parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.privacy.dlp.v2.Action.Deidentify parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.privacy.dlp.v2.Action.Deidentify prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Create a de-identified copy of the requested table or files.
     *
     * A TransformationDetail will be created for each transformation.
     *
     * If any rows in BigQuery are skipped during de-identification
     * (transformation errors or row size exceeds BigQuery insert API limits) they
     * are placed in the failure output table. If the original row exceeds
     * the BigQuery insert API limit it will be truncated when written to the
     * failure output table. The failure output table can be set in the
     * action.deidentify.output.big_query_output.deidentified_failure_output_table
     * field, if no table is set, a table will be automatically created in the
     * same project and dataset as the original table.
     *
     * Compatible with: Inspect
     * </pre>
     *
     * Protobuf type {@code google.privacy.dlp.v2.Action.Deidentify}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.privacy.dlp.v2.Action.Deidentify)
        com.google.privacy.dlp.v2.Action.DeidentifyOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.privacy.dlp.v2.DlpProto
            .internal_static_google_privacy_dlp_v2_Action_Deidentify_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.privacy.dlp.v2.DlpProto
            .internal_static_google_privacy_dlp_v2_Action_Deidentify_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.privacy.dlp.v2.Action.Deidentify.class,
                com.google.privacy.dlp.v2.Action.Deidentify.Builder.class);
      }

      // Construct using com.google.privacy.dlp.v2.Action.Deidentify.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getTransformationConfigFieldBuilder();
          getTransformationDetailsStorageConfigFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        transformationConfig_ = null;
        if (transformationConfigBuilder_ != null) {
          transformationConfigBuilder_.dispose();
          transformationConfigBuilder_ = null;
        }
        transformationDetailsStorageConfig_ = null;
        if (transformationDetailsStorageConfigBuilder_ != null) {
          transformationDetailsStorageConfigBuilder_.dispose();
          transformationDetailsStorageConfigBuilder_ = null;
        }
        fileTypesToTransform_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        outputCase_ = 0;
        output_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.privacy.dlp.v2.DlpProto
            .internal_static_google_privacy_dlp_v2_Action_Deidentify_descriptor;
      }

      @java.lang.Override
      public com.google.privacy.dlp.v2.Action.Deidentify getDefaultInstanceForType() {
        return com.google.privacy.dlp.v2.Action.Deidentify.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.privacy.dlp.v2.Action.Deidentify build() {
        com.google.privacy.dlp.v2.Action.Deidentify result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.privacy.dlp.v2.Action.Deidentify buildPartial() {
        com.google.privacy.dlp.v2.Action.Deidentify result =
            new com.google.privacy.dlp.v2.Action.Deidentify(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(com.google.privacy.dlp.v2.Action.Deidentify result) {
        if (((bitField0_ & 0x00000008) != 0)) {
          fileTypesToTransform_ = java.util.Collections.unmodifiableList(fileTypesToTransform_);
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.fileTypesToTransform_ = fileTypesToTransform_;
      }

      private void buildPartial0(com.google.privacy.dlp.v2.Action.Deidentify result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.transformationConfig_ =
              transformationConfigBuilder_ == null
                  ? transformationConfig_
                  : transformationConfigBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.transformationDetailsStorageConfig_ =
              transformationDetailsStorageConfigBuilder_ == null
                  ? transformationDetailsStorageConfig_
                  : transformationDetailsStorageConfigBuilder_.build();
          to_bitField0_ |= 0x00000002;
        }
        result.bitField0_ |= to_bitField0_;
      }

      private void buildPartialOneofs(com.google.privacy.dlp.v2.Action.Deidentify result) {
        result.outputCase_ = outputCase_;
        result.output_ = this.output_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.privacy.dlp.v2.Action.Deidentify) {
          return mergeFrom((com.google.privacy.dlp.v2.Action.Deidentify) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.privacy.dlp.v2.Action.Deidentify other) {
        if (other == com.google.privacy.dlp.v2.Action.Deidentify.getDefaultInstance()) return this;
        if (other.hasTransformationConfig()) {
          mergeTransformationConfig(other.getTransformationConfig());
        }
        if (other.hasTransformationDetailsStorageConfig()) {
          mergeTransformationDetailsStorageConfig(other.getTransformationDetailsStorageConfig());
        }
        if (!other.fileTypesToTransform_.isEmpty()) {
          if (fileTypesToTransform_.isEmpty()) {
            fileTypesToTransform_ = other.fileTypesToTransform_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensureFileTypesToTransformIsMutable();
            fileTypesToTransform_.addAll(other.fileTypesToTransform_);
          }
          onChanged();
        }
        switch (other.getOutputCase()) {
          case CLOUD_STORAGE_OUTPUT:
            {
              outputCase_ = 9;
              output_ = other.output_;
              onChanged();
              break;
            }
          case OUTPUT_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 26:
                {
                  input.readMessage(
                      getTransformationDetailsStorageConfigFieldBuilder().getBuilder(),
                      extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 26
              case 58:
                {
                  input.readMessage(
                      getTransformationConfigFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 58
              case 64:
                {
                  int tmpRaw = input.readEnum();
                  ensureFileTypesToTransformIsMutable();
                  fileTypesToTransform_.add(tmpRaw);
                  break;
                } // case 64
              case 66:
                {
                  int length = input.readRawVarint32();
                  int oldLimit = input.pushLimit(length);
                  while (input.getBytesUntilLimit() > 0) {
                    int tmpRaw = input.readEnum();
                    ensureFileTypesToTransformIsMutable();
                    fileTypesToTransform_.add(tmpRaw);
                  }
                  input.popLimit(oldLimit);
                  break;
                } // case 66
              case 74:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  outputCase_ = 9;
                  output_ = s;
                  break;
                } // case 74
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int outputCase_ = 0;
      private java.lang.Object output_;

      public OutputCase getOutputCase() {
        return OutputCase.forNumber(outputCase_);
      }

      public Builder clearOutput() {
        outputCase_ = 0;
        output_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      private com.google.privacy.dlp.v2.TransformationConfig transformationConfig_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.privacy.dlp.v2.TransformationConfig,
              com.google.privacy.dlp.v2.TransformationConfig.Builder,
              com.google.privacy.dlp.v2.TransformationConfigOrBuilder>
          transformationConfigBuilder_;
      /**
       *
       *
       * <pre>
       * User specified deidentify templates and configs for structured,
       * unstructured, and image files.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.TransformationConfig transformation_config = 7;</code>
       *
       * @return Whether the transformationConfig field is set.
       */
      public boolean hasTransformationConfig() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * User specified deidentify templates and configs for structured,
       * unstructured, and image files.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.TransformationConfig transformation_config = 7;</code>
       *
       * @return The transformationConfig.
       */
      public com.google.privacy.dlp.v2.TransformationConfig getTransformationConfig() {
        if (transformationConfigBuilder_ == null) {
          return transformationConfig_ == null
              ? com.google.privacy.dlp.v2.TransformationConfig.getDefaultInstance()
              : transformationConfig_;
        } else {
          return transformationConfigBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * User specified deidentify templates and configs for structured,
       * unstructured, and image files.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.TransformationConfig transformation_config = 7;</code>
       */
      public Builder setTransformationConfig(com.google.privacy.dlp.v2.TransformationConfig value) {
        if (transformationConfigBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          transformationConfig_ = value;
        } else {
          transformationConfigBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * User specified deidentify templates and configs for structured,
       * unstructured, and image files.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.TransformationConfig transformation_config = 7;</code>
       */
      public Builder setTransformationConfig(
          com.google.privacy.dlp.v2.TransformationConfig.Builder builderForValue) {
        if (transformationConfigBuilder_ == null) {
          transformationConfig_ = builderForValue.build();
        } else {
          transformationConfigBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * User specified deidentify templates and configs for structured,
       * unstructured, and image files.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.TransformationConfig transformation_config = 7;</code>
       */
      public Builder mergeTransformationConfig(
          com.google.privacy.dlp.v2.TransformationConfig value) {
        if (transformationConfigBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && transformationConfig_ != null
              && transformationConfig_
                  != com.google.privacy.dlp.v2.TransformationConfig.getDefaultInstance()) {
            getTransformationConfigBuilder().mergeFrom(value);
          } else {
            transformationConfig_ = value;
          }
        } else {
          transformationConfigBuilder_.mergeFrom(value);
        }
        if (transformationConfig_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * User specified deidentify templates and configs for structured,
       * unstructured, and image files.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.TransformationConfig transformation_config = 7;</code>
       */
      public Builder clearTransformationConfig() {
        bitField0_ = (bitField0_ & ~0x00000001);
        transformationConfig_ = null;
        if (transformationConfigBuilder_ != null) {
          transformationConfigBuilder_.dispose();
          transformationConfigBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * User specified deidentify templates and configs for structured,
       * unstructured, and image files.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.TransformationConfig transformation_config = 7;</code>
       */
      public com.google.privacy.dlp.v2.TransformationConfig.Builder
          getTransformationConfigBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getTransformationConfigFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * User specified deidentify templates and configs for structured,
       * unstructured, and image files.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.TransformationConfig transformation_config = 7;</code>
       */
      public com.google.privacy.dlp.v2.TransformationConfigOrBuilder
          getTransformationConfigOrBuilder() {
        if (transformationConfigBuilder_ != null) {
          return transformationConfigBuilder_.getMessageOrBuilder();
        } else {
          return transformationConfig_ == null
              ? com.google.privacy.dlp.v2.TransformationConfig.getDefaultInstance()
              : transformationConfig_;
        }
      }
      /**
       *
       *
       * <pre>
       * User specified deidentify templates and configs for structured,
       * unstructured, and image files.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.TransformationConfig transformation_config = 7;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.privacy.dlp.v2.TransformationConfig,
              com.google.privacy.dlp.v2.TransformationConfig.Builder,
              com.google.privacy.dlp.v2.TransformationConfigOrBuilder>
          getTransformationConfigFieldBuilder() {
        if (transformationConfigBuilder_ == null) {
          transformationConfigBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.privacy.dlp.v2.TransformationConfig,
                  com.google.privacy.dlp.v2.TransformationConfig.Builder,
                  com.google.privacy.dlp.v2.TransformationConfigOrBuilder>(
                  getTransformationConfig(), getParentForChildren(), isClean());
          transformationConfig_ = null;
        }
        return transformationConfigBuilder_;
      }

      private com.google.privacy.dlp.v2.TransformationDetailsStorageConfig
          transformationDetailsStorageConfig_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.privacy.dlp.v2.TransformationDetailsStorageConfig,
              com.google.privacy.dlp.v2.TransformationDetailsStorageConfig.Builder,
              com.google.privacy.dlp.v2.TransformationDetailsStorageConfigOrBuilder>
          transformationDetailsStorageConfigBuilder_;
      /**
       *
       *
       * <pre>
       * Config for storing transformation details. This is separate from the
       * de-identified content, and contains metadata about the successful
       * transformations and/or failures that occurred while de-identifying. This
       * needs to be set in order for users to access information about the status
       * of each transformation (see
       * [TransformationDetails][google.privacy.dlp.v2.TransformationDetails]
       * message for more information about what is noted).
       * </pre>
       *
       * <code>
       * .google.privacy.dlp.v2.TransformationDetailsStorageConfig transformation_details_storage_config = 3;
       * </code>
       *
       * @return Whether the transformationDetailsStorageConfig field is set.
       */
      public boolean hasTransformationDetailsStorageConfig() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * Config for storing transformation details. This is separate from the
       * de-identified content, and contains metadata about the successful
       * transformations and/or failures that occurred while de-identifying. This
       * needs to be set in order for users to access information about the status
       * of each transformation (see
       * [TransformationDetails][google.privacy.dlp.v2.TransformationDetails]
       * message for more information about what is noted).
       * </pre>
       *
       * <code>
       * .google.privacy.dlp.v2.TransformationDetailsStorageConfig transformation_details_storage_config = 3;
       * </code>
       *
       * @return The transformationDetailsStorageConfig.
       */
      public com.google.privacy.dlp.v2.TransformationDetailsStorageConfig
          getTransformationDetailsStorageConfig() {
        if (transformationDetailsStorageConfigBuilder_ == null) {
          return transformationDetailsStorageConfig_ == null
              ? com.google.privacy.dlp.v2.TransformationDetailsStorageConfig.getDefaultInstance()
              : transformationDetailsStorageConfig_;
        } else {
          return transformationDetailsStorageConfigBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Config for storing transformation details. This is separate from the
       * de-identified content, and contains metadata about the successful
       * transformations and/or failures that occurred while de-identifying. This
       * needs to be set in order for users to access information about the status
       * of each transformation (see
       * [TransformationDetails][google.privacy.dlp.v2.TransformationDetails]
       * message for more information about what is noted).
       * </pre>
       *
       * <code>
       * .google.privacy.dlp.v2.TransformationDetailsStorageConfig transformation_details_storage_config = 3;
       * </code>
       */
      public Builder setTransformationDetailsStorageConfig(
          com.google.privacy.dlp.v2.TransformationDetailsStorageConfig value) {
        if (transformationDetailsStorageConfigBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          transformationDetailsStorageConfig_ = value;
        } else {
          transformationDetailsStorageConfigBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Config for storing transformation details. This is separate from the
       * de-identified content, and contains metadata about the successful
       * transformations and/or failures that occurred while de-identifying. This
       * needs to be set in order for users to access information about the status
       * of each transformation (see
       * [TransformationDetails][google.privacy.dlp.v2.TransformationDetails]
       * message for more information about what is noted).
       * </pre>
       *
       * <code>
       * .google.privacy.dlp.v2.TransformationDetailsStorageConfig transformation_details_storage_config = 3;
       * </code>
       */
      public Builder setTransformationDetailsStorageConfig(
          com.google.privacy.dlp.v2.TransformationDetailsStorageConfig.Builder builderForValue) {
        if (transformationDetailsStorageConfigBuilder_ == null) {
          transformationDetailsStorageConfig_ = builderForValue.build();
        } else {
          transformationDetailsStorageConfigBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Config for storing transformation details. This is separate from the
       * de-identified content, and contains metadata about the successful
       * transformations and/or failures that occurred while de-identifying. This
       * needs to be set in order for users to access information about the status
       * of each transformation (see
       * [TransformationDetails][google.privacy.dlp.v2.TransformationDetails]
       * message for more information about what is noted).
       * </pre>
       *
       * <code>
       * .google.privacy.dlp.v2.TransformationDetailsStorageConfig transformation_details_storage_config = 3;
       * </code>
       */
      public Builder mergeTransformationDetailsStorageConfig(
          com.google.privacy.dlp.v2.TransformationDetailsStorageConfig value) {
        if (transformationDetailsStorageConfigBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && transformationDetailsStorageConfig_ != null
              && transformationDetailsStorageConfig_
                  != com.google.privacy.dlp.v2.TransformationDetailsStorageConfig
                      .getDefaultInstance()) {
            getTransformationDetailsStorageConfigBuilder().mergeFrom(value);
          } else {
            transformationDetailsStorageConfig_ = value;
          }
        } else {
          transformationDetailsStorageConfigBuilder_.mergeFrom(value);
        }
        if (transformationDetailsStorageConfig_ != null) {
          bitField0_ |= 0x00000002;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Config for storing transformation details. This is separate from the
       * de-identified content, and contains metadata about the successful
       * transformations and/or failures that occurred while de-identifying. This
       * needs to be set in order for users to access information about the status
       * of each transformation (see
       * [TransformationDetails][google.privacy.dlp.v2.TransformationDetails]
       * message for more information about what is noted).
       * </pre>
       *
       * <code>
       * .google.privacy.dlp.v2.TransformationDetailsStorageConfig transformation_details_storage_config = 3;
       * </code>
       */
      public Builder clearTransformationDetailsStorageConfig() {
        bitField0_ = (bitField0_ & ~0x00000002);
        transformationDetailsStorageConfig_ = null;
        if (transformationDetailsStorageConfigBuilder_ != null) {
          transformationDetailsStorageConfigBuilder_.dispose();
          transformationDetailsStorageConfigBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Config for storing transformation details. This is separate from the
       * de-identified content, and contains metadata about the successful
       * transformations and/or failures that occurred while de-identifying. This
       * needs to be set in order for users to access information about the status
       * of each transformation (see
       * [TransformationDetails][google.privacy.dlp.v2.TransformationDetails]
       * message for more information about what is noted).
       * </pre>
       *
       * <code>
       * .google.privacy.dlp.v2.TransformationDetailsStorageConfig transformation_details_storage_config = 3;
       * </code>
       */
      public com.google.privacy.dlp.v2.TransformationDetailsStorageConfig.Builder
          getTransformationDetailsStorageConfigBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getTransformationDetailsStorageConfigFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Config for storing transformation details. This is separate from the
       * de-identified content, and contains metadata about the successful
       * transformations and/or failures that occurred while de-identifying. This
       * needs to be set in order for users to access information about the status
       * of each transformation (see
       * [TransformationDetails][google.privacy.dlp.v2.TransformationDetails]
       * message for more information about what is noted).
       * </pre>
       *
       * <code>
       * .google.privacy.dlp.v2.TransformationDetailsStorageConfig transformation_details_storage_config = 3;
       * </code>
       */
      public com.google.privacy.dlp.v2.TransformationDetailsStorageConfigOrBuilder
          getTransformationDetailsStorageConfigOrBuilder() {
        if (transformationDetailsStorageConfigBuilder_ != null) {
          return transformationDetailsStorageConfigBuilder_.getMessageOrBuilder();
        } else {
          return transformationDetailsStorageConfig_ == null
              ? com.google.privacy.dlp.v2.TransformationDetailsStorageConfig.getDefaultInstance()
              : transformationDetailsStorageConfig_;
        }
      }
      /**
       *
       *
       * <pre>
       * Config for storing transformation details. This is separate from the
       * de-identified content, and contains metadata about the successful
       * transformations and/or failures that occurred while de-identifying. This
       * needs to be set in order for users to access information about the status
       * of each transformation (see
       * [TransformationDetails][google.privacy.dlp.v2.TransformationDetails]
       * message for more information about what is noted).
       * </pre>
       *
       * <code>
       * .google.privacy.dlp.v2.TransformationDetailsStorageConfig transformation_details_storage_config = 3;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.privacy.dlp.v2.TransformationDetailsStorageConfig,
              com.google.privacy.dlp.v2.TransformationDetailsStorageConfig.Builder,
              com.google.privacy.dlp.v2.TransformationDetailsStorageConfigOrBuilder>
          getTransformationDetailsStorageConfigFieldBuilder() {
        if (transformationDetailsStorageConfigBuilder_ == null) {
          transformationDetailsStorageConfigBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.privacy.dlp.v2.TransformationDetailsStorageConfig,
                  com.google.privacy.dlp.v2.TransformationDetailsStorageConfig.Builder,
                  com.google.privacy.dlp.v2.TransformationDetailsStorageConfigOrBuilder>(
                  getTransformationDetailsStorageConfig(), getParentForChildren(), isClean());
          transformationDetailsStorageConfig_ = null;
        }
        return transformationDetailsStorageConfigBuilder_;
      }

      /**
       *
       *
       * <pre>
       * Required. User settable Cloud Storage bucket and folders to store
       * de-identified files. This field must be set for cloud storage
       * deidentification. The output Cloud Storage bucket must be different
       * from the input bucket. De-identified files will overwrite files in the
       * output path.
       *
       * Form of: gs://bucket/folder/ or gs://bucket
       * </pre>
       *
       * <code>string cloud_storage_output = 9 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return Whether the cloudStorageOutput field is set.
       */
      @java.lang.Override
      public boolean hasCloudStorageOutput() {
        return outputCase_ == 9;
      }
      /**
       *
       *
       * <pre>
       * Required. User settable Cloud Storage bucket and folders to store
       * de-identified files. This field must be set for cloud storage
       * deidentification. The output Cloud Storage bucket must be different
       * from the input bucket. De-identified files will overwrite files in the
       * output path.
       *
       * Form of: gs://bucket/folder/ or gs://bucket
       * </pre>
       *
       * <code>string cloud_storage_output = 9 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The cloudStorageOutput.
       */
      @java.lang.Override
      public java.lang.String getCloudStorageOutput() {
        java.lang.Object ref = "";
        if (outputCase_ == 9) {
          ref = output_;
        }
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (outputCase_ == 9) {
            output_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. User settable Cloud Storage bucket and folders to store
       * de-identified files. This field must be set for cloud storage
       * deidentification. The output Cloud Storage bucket must be different
       * from the input bucket. De-identified files will overwrite files in the
       * output path.
       *
       * Form of: gs://bucket/folder/ or gs://bucket
       * </pre>
       *
       * <code>string cloud_storage_output = 9 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for cloudStorageOutput.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getCloudStorageOutputBytes() {
        java.lang.Object ref = "";
        if (outputCase_ == 9) {
          ref = output_;
        }
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          if (outputCase_ == 9) {
            output_ = b;
          }
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. User settable Cloud Storage bucket and folders to store
       * de-identified files. This field must be set for cloud storage
       * deidentification. The output Cloud Storage bucket must be different
       * from the input bucket. De-identified files will overwrite files in the
       * output path.
       *
       * Form of: gs://bucket/folder/ or gs://bucket
       * </pre>
       *
       * <code>string cloud_storage_output = 9 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The cloudStorageOutput to set.
       * @return This builder for chaining.
       */
      public Builder setCloudStorageOutput(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        outputCase_ = 9;
        output_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. User settable Cloud Storage bucket and folders to store
       * de-identified files. This field must be set for cloud storage
       * deidentification. The output Cloud Storage bucket must be different
       * from the input bucket. De-identified files will overwrite files in the
       * output path.
       *
       * Form of: gs://bucket/folder/ or gs://bucket
       * </pre>
       *
       * <code>string cloud_storage_output = 9 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearCloudStorageOutput() {
        if (outputCase_ == 9) {
          outputCase_ = 0;
          output_ = null;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. User settable Cloud Storage bucket and folders to store
       * de-identified files. This field must be set for cloud storage
       * deidentification. The output Cloud Storage bucket must be different
       * from the input bucket. De-identified files will overwrite files in the
       * output path.
       *
       * Form of: gs://bucket/folder/ or gs://bucket
       * </pre>
       *
       * <code>string cloud_storage_output = 9 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for cloudStorageOutput to set.
       * @return This builder for chaining.
       */
      public Builder setCloudStorageOutputBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        outputCase_ = 9;
        output_ = value;
        onChanged();
        return this;
      }

      private java.util.List<java.lang.Integer> fileTypesToTransform_ =
          java.util.Collections.emptyList();

      private void ensureFileTypesToTransformIsMutable() {
        if (!((bitField0_ & 0x00000008) != 0)) {
          fileTypesToTransform_ = new java.util.ArrayList<java.lang.Integer>(fileTypesToTransform_);
          bitField0_ |= 0x00000008;
        }
      }
      /**
       *
       *
       * <pre>
       * List of user-specified file type groups to transform. If specified, only
       * the files with these filetypes will be transformed. If empty, all
       * supported files will be transformed. Supported types may be automatically
       * added over time. If a file type is set in this field that isn't supported
       * by the Deidentify action then the job will fail and will not be
       * successfully created/started. Currently the only filetypes supported are:
       * IMAGES, TEXT_FILES, CSV, TSV.
       * </pre>
       *
       * <code>repeated .google.privacy.dlp.v2.FileType file_types_to_transform = 8;</code>
       *
       * @return A list containing the fileTypesToTransform.
       */
      public java.util.List<com.google.privacy.dlp.v2.FileType> getFileTypesToTransformList() {
        return new com.google.protobuf.Internal.ListAdapter<
            java.lang.Integer, com.google.privacy.dlp.v2.FileType>(
            fileTypesToTransform_, fileTypesToTransform_converter_);
      }
      /**
       *
       *
       * <pre>
       * List of user-specified file type groups to transform. If specified, only
       * the files with these filetypes will be transformed. If empty, all
       * supported files will be transformed. Supported types may be automatically
       * added over time. If a file type is set in this field that isn't supported
       * by the Deidentify action then the job will fail and will not be
       * successfully created/started. Currently the only filetypes supported are:
       * IMAGES, TEXT_FILES, CSV, TSV.
       * </pre>
       *
       * <code>repeated .google.privacy.dlp.v2.FileType file_types_to_transform = 8;</code>
       *
       * @return The count of fileTypesToTransform.
       */
      public int getFileTypesToTransformCount() {
        return fileTypesToTransform_.size();
      }
      /**
       *
       *
       * <pre>
       * List of user-specified file type groups to transform. If specified, only
       * the files with these filetypes will be transformed. If empty, all
       * supported files will be transformed. Supported types may be automatically
       * added over time. If a file type is set in this field that isn't supported
       * by the Deidentify action then the job will fail and will not be
       * successfully created/started. Currently the only filetypes supported are:
       * IMAGES, TEXT_FILES, CSV, TSV.
       * </pre>
       *
       * <code>repeated .google.privacy.dlp.v2.FileType file_types_to_transform = 8;</code>
       *
       * @param index The index of the element to return.
       * @return The fileTypesToTransform at the given index.
       */
      public com.google.privacy.dlp.v2.FileType getFileTypesToTransform(int index) {
        return fileTypesToTransform_converter_.convert(fileTypesToTransform_.get(index));
      }
      /**
       *
       *
       * <pre>
       * List of user-specified file type groups to transform. If specified, only
       * the files with these filetypes will be transformed. If empty, all
       * supported files will be transformed. Supported types may be automatically
       * added over time. If a file type is set in this field that isn't supported
       * by the Deidentify action then the job will fail and will not be
       * successfully created/started. Currently the only filetypes supported are:
       * IMAGES, TEXT_FILES, CSV, TSV.
       * </pre>
       *
       * <code>repeated .google.privacy.dlp.v2.FileType file_types_to_transform = 8;</code>
       *
       * @param index The index to set the value at.
       * @param value The fileTypesToTransform to set.
       * @return This builder for chaining.
       */
      public Builder setFileTypesToTransform(int index, com.google.privacy.dlp.v2.FileType value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFileTypesToTransformIsMutable();
        fileTypesToTransform_.set(index, value.getNumber());
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of user-specified file type groups to transform. If specified, only
       * the files with these filetypes will be transformed. If empty, all
       * supported files will be transformed. Supported types may be automatically
       * added over time. If a file type is set in this field that isn't supported
       * by the Deidentify action then the job will fail and will not be
       * successfully created/started. Currently the only filetypes supported are:
       * IMAGES, TEXT_FILES, CSV, TSV.
       * </pre>
       *
       * <code>repeated .google.privacy.dlp.v2.FileType file_types_to_transform = 8;</code>
       *
       * @param value The fileTypesToTransform to add.
       * @return This builder for chaining.
       */
      public Builder addFileTypesToTransform(com.google.privacy.dlp.v2.FileType value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFileTypesToTransformIsMutable();
        fileTypesToTransform_.add(value.getNumber());
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of user-specified file type groups to transform. If specified, only
       * the files with these filetypes will be transformed. If empty, all
       * supported files will be transformed. Supported types may be automatically
       * added over time. If a file type is set in this field that isn't supported
       * by the Deidentify action then the job will fail and will not be
       * successfully created/started. Currently the only filetypes supported are:
       * IMAGES, TEXT_FILES, CSV, TSV.
       * </pre>
       *
       * <code>repeated .google.privacy.dlp.v2.FileType file_types_to_transform = 8;</code>
       *
       * @param values The fileTypesToTransform to add.
       * @return This builder for chaining.
       */
      public Builder addAllFileTypesToTransform(
          java.lang.Iterable<? extends com.google.privacy.dlp.v2.FileType> values) {
        ensureFileTypesToTransformIsMutable();
        for (com.google.privacy.dlp.v2.FileType value : values) {
          fileTypesToTransform_.add(value.getNumber());
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of user-specified file type groups to transform. If specified, only
       * the files with these filetypes will be transformed. If empty, all
       * supported files will be transformed. Supported types may be automatically
       * added over time. If a file type is set in this field that isn't supported
       * by the Deidentify action then the job will fail and will not be
       * successfully created/started. Currently the only filetypes supported are:
       * IMAGES, TEXT_FILES, CSV, TSV.
       * </pre>
       *
       * <code>repeated .google.privacy.dlp.v2.FileType file_types_to_transform = 8;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearFileTypesToTransform() {
        fileTypesToTransform_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of user-specified file type groups to transform. If specified, only
       * the files with these filetypes will be transformed. If empty, all
       * supported files will be transformed. Supported types may be automatically
       * added over time. If a file type is set in this field that isn't supported
       * by the Deidentify action then the job will fail and will not be
       * successfully created/started. Currently the only filetypes supported are:
       * IMAGES, TEXT_FILES, CSV, TSV.
       * </pre>
       *
       * <code>repeated .google.privacy.dlp.v2.FileType file_types_to_transform = 8;</code>
       *
       * @return A list containing the enum numeric values on the wire for fileTypesToTransform.
       */
      public java.util.List<java.lang.Integer> getFileTypesToTransformValueList() {
        return java.util.Collections.unmodifiableList(fileTypesToTransform_);
      }
      /**
       *
       *
       * <pre>
       * List of user-specified file type groups to transform. If specified, only
       * the files with these filetypes will be transformed. If empty, all
       * supported files will be transformed. Supported types may be automatically
       * added over time. If a file type is set in this field that isn't supported
       * by the Deidentify action then the job will fail and will not be
       * successfully created/started. Currently the only filetypes supported are:
       * IMAGES, TEXT_FILES, CSV, TSV.
       * </pre>
       *
       * <code>repeated .google.privacy.dlp.v2.FileType file_types_to_transform = 8;</code>
       *
       * @param index The index of the value to return.
       * @return The enum numeric value on the wire of fileTypesToTransform at the given index.
       */
      public int getFileTypesToTransformValue(int index) {
        return fileTypesToTransform_.get(index);
      }
      /**
       *
       *
       * <pre>
       * List of user-specified file type groups to transform. If specified, only
       * the files with these filetypes will be transformed. If empty, all
       * supported files will be transformed. Supported types may be automatically
       * added over time. If a file type is set in this field that isn't supported
       * by the Deidentify action then the job will fail and will not be
       * successfully created/started. Currently the only filetypes supported are:
       * IMAGES, TEXT_FILES, CSV, TSV.
       * </pre>
       *
       * <code>repeated .google.privacy.dlp.v2.FileType file_types_to_transform = 8;</code>
       *
       * @param index The index to set the value at.
       * @param value The enum numeric value on the wire for fileTypesToTransform to set.
       * @return This builder for chaining.
       */
      public Builder setFileTypesToTransformValue(int index, int value) {
        ensureFileTypesToTransformIsMutable();
        fileTypesToTransform_.set(index, value);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of user-specified file type groups to transform. If specified, only
       * the files with these filetypes will be transformed. If empty, all
       * supported files will be transformed. Supported types may be automatically
       * added over time. If a file type is set in this field that isn't supported
       * by the Deidentify action then the job will fail and will not be
       * successfully created/started. Currently the only filetypes supported are:
       * IMAGES, TEXT_FILES, CSV, TSV.
       * </pre>
       *
       * <code>repeated .google.privacy.dlp.v2.FileType file_types_to_transform = 8;</code>
       *
       * @param value The enum numeric value on the wire for fileTypesToTransform to add.
       * @return This builder for chaining.
       */
      public Builder addFileTypesToTransformValue(int value) {
        ensureFileTypesToTransformIsMutable();
        fileTypesToTransform_.add(value);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of user-specified file type groups to transform. If specified, only
       * the files with these filetypes will be transformed. If empty, all
       * supported files will be transformed. Supported types may be automatically
       * added over time. If a file type is set in this field that isn't supported
       * by the Deidentify action then the job will fail and will not be
       * successfully created/started. Currently the only filetypes supported are:
       * IMAGES, TEXT_FILES, CSV, TSV.
       * </pre>
       *
       * <code>repeated .google.privacy.dlp.v2.FileType file_types_to_transform = 8;</code>
       *
       * @param values The enum numeric values on the wire for fileTypesToTransform to add.
       * @return This builder for chaining.
       */
      public Builder addAllFileTypesToTransformValue(java.lang.Iterable<java.lang.Integer> values) {
        ensureFileTypesToTransformIsMutable();
        for (int value : values) {
          fileTypesToTransform_.add(value);
        }
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.privacy.dlp.v2.Action.Deidentify)
    }

    // @@protoc_insertion_point(class_scope:google.privacy.dlp.v2.Action.Deidentify)
    private static final com.google.privacy.dlp.v2.Action.Deidentify DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.privacy.dlp.v2.Action.Deidentify();
    }

    public static com.google.privacy.dlp.v2.Action.Deidentify getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Deidentify> PARSER =
        new com.google.protobuf.AbstractParser<Deidentify>() {
          @java.lang.Override
          public Deidentify parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Deidentify> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Deidentify> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.Action.Deidentify getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface JobNotificationEmailsOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.privacy.dlp.v2.Action.JobNotificationEmails)
      com.google.protobuf.MessageOrBuilder {}
  /**
   *
   *
   * <pre>
   * Sends an email when the job completes. The email goes to IAM project owners
   * and technical [Essential
   * Contacts](https://cloud.google.com/resource-manager/docs/managing-notification-contacts).
   * </pre>
   *
   * Protobuf type {@code google.privacy.dlp.v2.Action.JobNotificationEmails}
   */
  public static final class JobNotificationEmails extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.privacy.dlp.v2.Action.JobNotificationEmails)
      JobNotificationEmailsOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use JobNotificationEmails.newBuilder() to construct.
    private JobNotificationEmails(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private JobNotificationEmails() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new JobNotificationEmails();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_Action_JobNotificationEmails_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_Action_JobNotificationEmails_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.privacy.dlp.v2.Action.JobNotificationEmails.class,
              com.google.privacy.dlp.v2.Action.JobNotificationEmails.Builder.class);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.privacy.dlp.v2.Action.JobNotificationEmails)) {
        return super.equals(obj);
      }
      com.google.privacy.dlp.v2.Action.JobNotificationEmails other =
          (com.google.privacy.dlp.v2.Action.JobNotificationEmails) obj;

      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.privacy.dlp.v2.Action.JobNotificationEmails parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.privacy.dlp.v2.Action.JobNotificationEmails parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.Action.JobNotificationEmails parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.privacy.dlp.v2.Action.JobNotificationEmails parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.Action.JobNotificationEmails parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.privacy.dlp.v2.Action.JobNotificationEmails parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.Action.JobNotificationEmails parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.privacy.dlp.v2.Action.JobNotificationEmails parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.Action.JobNotificationEmails parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.privacy.dlp.v2.Action.JobNotificationEmails parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.Action.JobNotificationEmails parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.privacy.dlp.v2.Action.JobNotificationEmails parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.privacy.dlp.v2.Action.JobNotificationEmails prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Sends an email when the job completes. The email goes to IAM project owners
     * and technical [Essential
     * Contacts](https://cloud.google.com/resource-manager/docs/managing-notification-contacts).
     * </pre>
     *
     * Protobuf type {@code google.privacy.dlp.v2.Action.JobNotificationEmails}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.privacy.dlp.v2.Action.JobNotificationEmails)
        com.google.privacy.dlp.v2.Action.JobNotificationEmailsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.privacy.dlp.v2.DlpProto
            .internal_static_google_privacy_dlp_v2_Action_JobNotificationEmails_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.privacy.dlp.v2.DlpProto
            .internal_static_google_privacy_dlp_v2_Action_JobNotificationEmails_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.privacy.dlp.v2.Action.JobNotificationEmails.class,
                com.google.privacy.dlp.v2.Action.JobNotificationEmails.Builder.class);
      }

      // Construct using com.google.privacy.dlp.v2.Action.JobNotificationEmails.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.privacy.dlp.v2.DlpProto
            .internal_static_google_privacy_dlp_v2_Action_JobNotificationEmails_descriptor;
      }

      @java.lang.Override
      public com.google.privacy.dlp.v2.Action.JobNotificationEmails getDefaultInstanceForType() {
        return com.google.privacy.dlp.v2.Action.JobNotificationEmails.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.privacy.dlp.v2.Action.JobNotificationEmails build() {
        com.google.privacy.dlp.v2.Action.JobNotificationEmails result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.privacy.dlp.v2.Action.JobNotificationEmails buildPartial() {
        com.google.privacy.dlp.v2.Action.JobNotificationEmails result =
            new com.google.privacy.dlp.v2.Action.JobNotificationEmails(this);
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.privacy.dlp.v2.Action.JobNotificationEmails) {
          return mergeFrom((com.google.privacy.dlp.v2.Action.JobNotificationEmails) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.privacy.dlp.v2.Action.JobNotificationEmails other) {
        if (other == com.google.privacy.dlp.v2.Action.JobNotificationEmails.getDefaultInstance())
          return this;
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.privacy.dlp.v2.Action.JobNotificationEmails)
    }

    // @@protoc_insertion_point(class_scope:google.privacy.dlp.v2.Action.JobNotificationEmails)
    private static final com.google.privacy.dlp.v2.Action.JobNotificationEmails DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.privacy.dlp.v2.Action.JobNotificationEmails();
    }

    public static com.google.privacy.dlp.v2.Action.JobNotificationEmails getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<JobNotificationEmails> PARSER =
        new com.google.protobuf.AbstractParser<JobNotificationEmails>() {
          @java.lang.Override
          public JobNotificationEmails parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<JobNotificationEmails> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<JobNotificationEmails> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.Action.JobNotificationEmails getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface PublishToStackdriverOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.privacy.dlp.v2.Action.PublishToStackdriver)
      com.google.protobuf.MessageOrBuilder {}
  /**
   *
   *
   * <pre>
   * Enable Stackdriver metric dlp.googleapis.com/finding_count. This
   * will publish a metric to stack driver on each infotype requested and
   * how many findings were found for it. CustomDetectors will be bucketed
   * as 'Custom' under the Stackdriver label 'info_type'.
   * </pre>
   *
   * Protobuf type {@code google.privacy.dlp.v2.Action.PublishToStackdriver}
   */
  public static final class PublishToStackdriver extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.privacy.dlp.v2.Action.PublishToStackdriver)
      PublishToStackdriverOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use PublishToStackdriver.newBuilder() to construct.
    private PublishToStackdriver(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private PublishToStackdriver() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new PublishToStackdriver();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_Action_PublishToStackdriver_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_Action_PublishToStackdriver_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.privacy.dlp.v2.Action.PublishToStackdriver.class,
              com.google.privacy.dlp.v2.Action.PublishToStackdriver.Builder.class);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.privacy.dlp.v2.Action.PublishToStackdriver)) {
        return super.equals(obj);
      }
      com.google.privacy.dlp.v2.Action.PublishToStackdriver other =
          (com.google.privacy.dlp.v2.Action.PublishToStackdriver) obj;

      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.privacy.dlp.v2.Action.PublishToStackdriver parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.privacy.dlp.v2.Action.PublishToStackdriver parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.Action.PublishToStackdriver parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.privacy.dlp.v2.Action.PublishToStackdriver parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.Action.PublishToStackdriver parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.privacy.dlp.v2.Action.PublishToStackdriver parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.Action.PublishToStackdriver parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.privacy.dlp.v2.Action.PublishToStackdriver parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.Action.PublishToStackdriver parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.privacy.dlp.v2.Action.PublishToStackdriver parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.Action.PublishToStackdriver parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.privacy.dlp.v2.Action.PublishToStackdriver parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.privacy.dlp.v2.Action.PublishToStackdriver prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Enable Stackdriver metric dlp.googleapis.com/finding_count. This
     * will publish a metric to stack driver on each infotype requested and
     * how many findings were found for it. CustomDetectors will be bucketed
     * as 'Custom' under the Stackdriver label 'info_type'.
     * </pre>
     *
     * Protobuf type {@code google.privacy.dlp.v2.Action.PublishToStackdriver}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.privacy.dlp.v2.Action.PublishToStackdriver)
        com.google.privacy.dlp.v2.Action.PublishToStackdriverOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.privacy.dlp.v2.DlpProto
            .internal_static_google_privacy_dlp_v2_Action_PublishToStackdriver_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.privacy.dlp.v2.DlpProto
            .internal_static_google_privacy_dlp_v2_Action_PublishToStackdriver_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.privacy.dlp.v2.Action.PublishToStackdriver.class,
                com.google.privacy.dlp.v2.Action.PublishToStackdriver.Builder.class);
      }

      // Construct using com.google.privacy.dlp.v2.Action.PublishToStackdriver.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.privacy.dlp.v2.DlpProto
            .internal_static_google_privacy_dlp_v2_Action_PublishToStackdriver_descriptor;
      }

      @java.lang.Override
      public com.google.privacy.dlp.v2.Action.PublishToStackdriver getDefaultInstanceForType() {
        return com.google.privacy.dlp.v2.Action.PublishToStackdriver.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.privacy.dlp.v2.Action.PublishToStackdriver build() {
        com.google.privacy.dlp.v2.Action.PublishToStackdriver result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.privacy.dlp.v2.Action.PublishToStackdriver buildPartial() {
        com.google.privacy.dlp.v2.Action.PublishToStackdriver result =
            new com.google.privacy.dlp.v2.Action.PublishToStackdriver(this);
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.privacy.dlp.v2.Action.PublishToStackdriver) {
          return mergeFrom((com.google.privacy.dlp.v2.Action.PublishToStackdriver) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.privacy.dlp.v2.Action.PublishToStackdriver other) {
        if (other == com.google.privacy.dlp.v2.Action.PublishToStackdriver.getDefaultInstance())
          return this;
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.privacy.dlp.v2.Action.PublishToStackdriver)
    }

    // @@protoc_insertion_point(class_scope:google.privacy.dlp.v2.Action.PublishToStackdriver)
    private static final com.google.privacy.dlp.v2.Action.PublishToStackdriver DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.privacy.dlp.v2.Action.PublishToStackdriver();
    }

    public static com.google.privacy.dlp.v2.Action.PublishToStackdriver getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<PublishToStackdriver> PARSER =
        new com.google.protobuf.AbstractParser<PublishToStackdriver>() {
          @java.lang.Override
          public PublishToStackdriver parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<PublishToStackdriver> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<PublishToStackdriver> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.Action.PublishToStackdriver getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int actionCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object action_;

  public enum ActionCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    SAVE_FINDINGS(1),
    PUB_SUB(2),
    PUBLISH_SUMMARY_TO_CSCC(3),
    PUBLISH_FINDINGS_TO_CLOUD_DATA_CATALOG(5),
    DEIDENTIFY(7),
    JOB_NOTIFICATION_EMAILS(8),
    PUBLISH_TO_STACKDRIVER(9),
    ACTION_NOT_SET(0);
    private final int value;

    private ActionCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ActionCase valueOf(int value) {
      return forNumber(value);
    }

    public static ActionCase forNumber(int value) {
      switch (value) {
        case 1:
          return SAVE_FINDINGS;
        case 2:
          return PUB_SUB;
        case 3:
          return PUBLISH_SUMMARY_TO_CSCC;
        case 5:
          return PUBLISH_FINDINGS_TO_CLOUD_DATA_CATALOG;
        case 7:
          return DEIDENTIFY;
        case 8:
          return JOB_NOTIFICATION_EMAILS;
        case 9:
          return PUBLISH_TO_STACKDRIVER;
        case 0:
          return ACTION_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public ActionCase getActionCase() {
    return ActionCase.forNumber(actionCase_);
  }

  public static final int SAVE_FINDINGS_FIELD_NUMBER = 1;
  /**
   *
   *
   * <pre>
   * Save resulting findings in a provided location.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.Action.SaveFindings save_findings = 1;</code>
   *
   * @return Whether the saveFindings field is set.
   */
  @java.lang.Override
  public boolean hasSaveFindings() {
    return actionCase_ == 1;
  }
  /**
   *
   *
   * <pre>
   * Save resulting findings in a provided location.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.Action.SaveFindings save_findings = 1;</code>
   *
   * @return The saveFindings.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.Action.SaveFindings getSaveFindings() {
    if (actionCase_ == 1) {
      return (com.google.privacy.dlp.v2.Action.SaveFindings) action_;
    }
    return com.google.privacy.dlp.v2.Action.SaveFindings.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Save resulting findings in a provided location.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.Action.SaveFindings save_findings = 1;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.Action.SaveFindingsOrBuilder getSaveFindingsOrBuilder() {
    if (actionCase_ == 1) {
      return (com.google.privacy.dlp.v2.Action.SaveFindings) action_;
    }
    return com.google.privacy.dlp.v2.Action.SaveFindings.getDefaultInstance();
  }

  public static final int PUB_SUB_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * Publish a notification to a Pub/Sub topic.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.Action.PublishToPubSub pub_sub = 2;</code>
   *
   * @return Whether the pubSub field is set.
   */
  @java.lang.Override
  public boolean hasPubSub() {
    return actionCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * Publish a notification to a Pub/Sub topic.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.Action.PublishToPubSub pub_sub = 2;</code>
   *
   * @return The pubSub.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.Action.PublishToPubSub getPubSub() {
    if (actionCase_ == 2) {
      return (com.google.privacy.dlp.v2.Action.PublishToPubSub) action_;
    }
    return com.google.privacy.dlp.v2.Action.PublishToPubSub.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Publish a notification to a Pub/Sub topic.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.Action.PublishToPubSub pub_sub = 2;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.Action.PublishToPubSubOrBuilder getPubSubOrBuilder() {
    if (actionCase_ == 2) {
      return (com.google.privacy.dlp.v2.Action.PublishToPubSub) action_;
    }
    return com.google.privacy.dlp.v2.Action.PublishToPubSub.getDefaultInstance();
  }

  public static final int PUBLISH_SUMMARY_TO_CSCC_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * Publish summary to Cloud Security Command Center (Alpha).
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.Action.PublishSummaryToCscc publish_summary_to_cscc = 3;</code>
   *
   * @return Whether the publishSummaryToCscc field is set.
   */
  @java.lang.Override
  public boolean hasPublishSummaryToCscc() {
    return actionCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * Publish summary to Cloud Security Command Center (Alpha).
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.Action.PublishSummaryToCscc publish_summary_to_cscc = 3;</code>
   *
   * @return The publishSummaryToCscc.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.Action.PublishSummaryToCscc getPublishSummaryToCscc() {
    if (actionCase_ == 3) {
      return (com.google.privacy.dlp.v2.Action.PublishSummaryToCscc) action_;
    }
    return com.google.privacy.dlp.v2.Action.PublishSummaryToCscc.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Publish summary to Cloud Security Command Center (Alpha).
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.Action.PublishSummaryToCscc publish_summary_to_cscc = 3;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.Action.PublishSummaryToCsccOrBuilder
      getPublishSummaryToCsccOrBuilder() {
    if (actionCase_ == 3) {
      return (com.google.privacy.dlp.v2.Action.PublishSummaryToCscc) action_;
    }
    return com.google.privacy.dlp.v2.Action.PublishSummaryToCscc.getDefaultInstance();
  }

  public static final int PUBLISH_FINDINGS_TO_CLOUD_DATA_CATALOG_FIELD_NUMBER = 5;
  /**
   *
   *
   * <pre>
   * Publish findings to Cloud Datahub.
   * </pre>
   *
   * <code>
   * .google.privacy.dlp.v2.Action.PublishFindingsToCloudDataCatalog publish_findings_to_cloud_data_catalog = 5;
   * </code>
   *
   * @return Whether the publishFindingsToCloudDataCatalog field is set.
   */
  @java.lang.Override
  public boolean hasPublishFindingsToCloudDataCatalog() {
    return actionCase_ == 5;
  }
  /**
   *
   *
   * <pre>
   * Publish findings to Cloud Datahub.
   * </pre>
   *
   * <code>
   * .google.privacy.dlp.v2.Action.PublishFindingsToCloudDataCatalog publish_findings_to_cloud_data_catalog = 5;
   * </code>
   *
   * @return The publishFindingsToCloudDataCatalog.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.Action.PublishFindingsToCloudDataCatalog
      getPublishFindingsToCloudDataCatalog() {
    if (actionCase_ == 5) {
      return (com.google.privacy.dlp.v2.Action.PublishFindingsToCloudDataCatalog) action_;
    }
    return com.google.privacy.dlp.v2.Action.PublishFindingsToCloudDataCatalog.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Publish findings to Cloud Datahub.
   * </pre>
   *
   * <code>
   * .google.privacy.dlp.v2.Action.PublishFindingsToCloudDataCatalog publish_findings_to_cloud_data_catalog = 5;
   * </code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.Action.PublishFindingsToCloudDataCatalogOrBuilder
      getPublishFindingsToCloudDataCatalogOrBuilder() {
    if (actionCase_ == 5) {
      return (com.google.privacy.dlp.v2.Action.PublishFindingsToCloudDataCatalog) action_;
    }
    return com.google.privacy.dlp.v2.Action.PublishFindingsToCloudDataCatalog.getDefaultInstance();
  }

  public static final int DEIDENTIFY_FIELD_NUMBER = 7;
  /**
   *
   *
   * <pre>
   * Create a de-identified copy of the input data.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.Action.Deidentify deidentify = 7;</code>
   *
   * @return Whether the deidentify field is set.
   */
  @java.lang.Override
  public boolean hasDeidentify() {
    return actionCase_ == 7;
  }
  /**
   *
   *
   * <pre>
   * Create a de-identified copy of the input data.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.Action.Deidentify deidentify = 7;</code>
   *
   * @return The deidentify.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.Action.Deidentify getDeidentify() {
    if (actionCase_ == 7) {
      return (com.google.privacy.dlp.v2.Action.Deidentify) action_;
    }
    return com.google.privacy.dlp.v2.Action.Deidentify.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Create a de-identified copy of the input data.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.Action.Deidentify deidentify = 7;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.Action.DeidentifyOrBuilder getDeidentifyOrBuilder() {
    if (actionCase_ == 7) {
      return (com.google.privacy.dlp.v2.Action.Deidentify) action_;
    }
    return com.google.privacy.dlp.v2.Action.Deidentify.getDefaultInstance();
  }

  public static final int JOB_NOTIFICATION_EMAILS_FIELD_NUMBER = 8;
  /**
   *
   *
   * <pre>
   * Sends an email when the job completes. The email goes to IAM project
   * owners and technical [Essential
   * Contacts](https://cloud.google.com/resource-manager/docs/managing-notification-contacts).
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.Action.JobNotificationEmails job_notification_emails = 8;</code>
   *
   * @return Whether the jobNotificationEmails field is set.
   */
  @java.lang.Override
  public boolean hasJobNotificationEmails() {
    return actionCase_ == 8;
  }
  /**
   *
   *
   * <pre>
   * Sends an email when the job completes. The email goes to IAM project
   * owners and technical [Essential
   * Contacts](https://cloud.google.com/resource-manager/docs/managing-notification-contacts).
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.Action.JobNotificationEmails job_notification_emails = 8;</code>
   *
   * @return The jobNotificationEmails.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.Action.JobNotificationEmails getJobNotificationEmails() {
    if (actionCase_ == 8) {
      return (com.google.privacy.dlp.v2.Action.JobNotificationEmails) action_;
    }
    return com.google.privacy.dlp.v2.Action.JobNotificationEmails.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Sends an email when the job completes. The email goes to IAM project
   * owners and technical [Essential
   * Contacts](https://cloud.google.com/resource-manager/docs/managing-notification-contacts).
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.Action.JobNotificationEmails job_notification_emails = 8;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.Action.JobNotificationEmailsOrBuilder
      getJobNotificationEmailsOrBuilder() {
    if (actionCase_ == 8) {
      return (com.google.privacy.dlp.v2.Action.JobNotificationEmails) action_;
    }
    return com.google.privacy.dlp.v2.Action.JobNotificationEmails.getDefaultInstance();
  }

  public static final int PUBLISH_TO_STACKDRIVER_FIELD_NUMBER = 9;
  /**
   *
   *
   * <pre>
   * Enable Stackdriver metric dlp.googleapis.com/finding_count.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.Action.PublishToStackdriver publish_to_stackdriver = 9;</code>
   *
   * @return Whether the publishToStackdriver field is set.
   */
  @java.lang.Override
  public boolean hasPublishToStackdriver() {
    return actionCase_ == 9;
  }
  /**
   *
   *
   * <pre>
   * Enable Stackdriver metric dlp.googleapis.com/finding_count.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.Action.PublishToStackdriver publish_to_stackdriver = 9;</code>
   *
   * @return The publishToStackdriver.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.Action.PublishToStackdriver getPublishToStackdriver() {
    if (actionCase_ == 9) {
      return (com.google.privacy.dlp.v2.Action.PublishToStackdriver) action_;
    }
    return com.google.privacy.dlp.v2.Action.PublishToStackdriver.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Enable Stackdriver metric dlp.googleapis.com/finding_count.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.Action.PublishToStackdriver publish_to_stackdriver = 9;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.Action.PublishToStackdriverOrBuilder
      getPublishToStackdriverOrBuilder() {
    if (actionCase_ == 9) {
      return (com.google.privacy.dlp.v2.Action.PublishToStackdriver) action_;
    }
    return com.google.privacy.dlp.v2.Action.PublishToStackdriver.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (actionCase_ == 1) {
      output.writeMessage(1, (com.google.privacy.dlp.v2.Action.SaveFindings) action_);
    }
    if (actionCase_ == 2) {
      output.writeMessage(2, (com.google.privacy.dlp.v2.Action.PublishToPubSub) action_);
    }
    if (actionCase_ == 3) {
      output.writeMessage(3, (com.google.privacy.dlp.v2.Action.PublishSummaryToCscc) action_);
    }
    if (actionCase_ == 5) {
      output.writeMessage(
          5, (com.google.privacy.dlp.v2.Action.PublishFindingsToCloudDataCatalog) action_);
    }
    if (actionCase_ == 7) {
      output.writeMessage(7, (com.google.privacy.dlp.v2.Action.Deidentify) action_);
    }
    if (actionCase_ == 8) {
      output.writeMessage(8, (com.google.privacy.dlp.v2.Action.JobNotificationEmails) action_);
    }
    if (actionCase_ == 9) {
      output.writeMessage(9, (com.google.privacy.dlp.v2.Action.PublishToStackdriver) action_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (actionCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              1, (com.google.privacy.dlp.v2.Action.SaveFindings) action_);
    }
    if (actionCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.privacy.dlp.v2.Action.PublishToPubSub) action_);
    }
    if (actionCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.privacy.dlp.v2.Action.PublishSummaryToCscc) action_);
    }
    if (actionCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5, (com.google.privacy.dlp.v2.Action.PublishFindingsToCloudDataCatalog) action_);
    }
    if (actionCase_ == 7) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              7, (com.google.privacy.dlp.v2.Action.Deidentify) action_);
    }
    if (actionCase_ == 8) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              8, (com.google.privacy.dlp.v2.Action.JobNotificationEmails) action_);
    }
    if (actionCase_ == 9) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              9, (com.google.privacy.dlp.v2.Action.PublishToStackdriver) action_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.privacy.dlp.v2.Action)) {
      return super.equals(obj);
    }
    com.google.privacy.dlp.v2.Action other = (com.google.privacy.dlp.v2.Action) obj;

    if (!getActionCase().equals(other.getActionCase())) return false;
    switch (actionCase_) {
      case 1:
        if (!getSaveFindings().equals(other.getSaveFindings())) return false;
        break;
      case 2:
        if (!getPubSub().equals(other.getPubSub())) return false;
        break;
      case 3:
        if (!getPublishSummaryToCscc().equals(other.getPublishSummaryToCscc())) return false;
        break;
      case 5:
        if (!getPublishFindingsToCloudDataCatalog()
            .equals(other.getPublishFindingsToCloudDataCatalog())) return false;
        break;
      case 7:
        if (!getDeidentify().equals(other.getDeidentify())) return false;
        break;
      case 8:
        if (!getJobNotificationEmails().equals(other.getJobNotificationEmails())) return false;
        break;
      case 9:
        if (!getPublishToStackdriver().equals(other.getPublishToStackdriver())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    switch (actionCase_) {
      case 1:
        hash = (37 * hash) + SAVE_FINDINGS_FIELD_NUMBER;
        hash = (53 * hash) + getSaveFindings().hashCode();
        break;
      case 2:
        hash = (37 * hash) + PUB_SUB_FIELD_NUMBER;
        hash = (53 * hash) + getPubSub().hashCode();
        break;
      case 3:
        hash = (37 * hash) + PUBLISH_SUMMARY_TO_CSCC_FIELD_NUMBER;
        hash = (53 * hash) + getPublishSummaryToCscc().hashCode();
        break;
      case 5:
        hash = (37 * hash) + PUBLISH_FINDINGS_TO_CLOUD_DATA_CATALOG_FIELD_NUMBER;
        hash = (53 * hash) + getPublishFindingsToCloudDataCatalog().hashCode();
        break;
      case 7:
        hash = (37 * hash) + DEIDENTIFY_FIELD_NUMBER;
        hash = (53 * hash) + getDeidentify().hashCode();
        break;
      case 8:
        hash = (37 * hash) + JOB_NOTIFICATION_EMAILS_FIELD_NUMBER;
        hash = (53 * hash) + getJobNotificationEmails().hashCode();
        break;
      case 9:
        hash = (37 * hash) + PUBLISH_TO_STACKDRIVER_FIELD_NUMBER;
        hash = (53 * hash) + getPublishToStackdriver().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.privacy.dlp.v2.Action parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.Action parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.Action parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.Action parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.Action parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.Action parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.Action parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.Action parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.Action parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.Action parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.Action parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.Action parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.privacy.dlp.v2.Action prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A task to execute on the completion of a job.
   * See https://cloud.google.com/sensitive-data-protection/docs/concepts-actions
   * to learn more.
   * </pre>
   *
   * Protobuf type {@code google.privacy.dlp.v2.Action}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.privacy.dlp.v2.Action)
      com.google.privacy.dlp.v2.ActionOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_Action_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_Action_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.privacy.dlp.v2.Action.class,
              com.google.privacy.dlp.v2.Action.Builder.class);
    }

    // Construct using com.google.privacy.dlp.v2.Action.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (saveFindingsBuilder_ != null) {
        saveFindingsBuilder_.clear();
      }
      if (pubSubBuilder_ != null) {
        pubSubBuilder_.clear();
      }
      if (publishSummaryToCsccBuilder_ != null) {
        publishSummaryToCsccBuilder_.clear();
      }
      if (publishFindingsToCloudDataCatalogBuilder_ != null) {
        publishFindingsToCloudDataCatalogBuilder_.clear();
      }
      if (deidentifyBuilder_ != null) {
        deidentifyBuilder_.clear();
      }
      if (jobNotificationEmailsBuilder_ != null) {
        jobNotificationEmailsBuilder_.clear();
      }
      if (publishToStackdriverBuilder_ != null) {
        publishToStackdriverBuilder_.clear();
      }
      actionCase_ = 0;
      action_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_Action_descriptor;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.Action getDefaultInstanceForType() {
      return com.google.privacy.dlp.v2.Action.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.Action build() {
      com.google.privacy.dlp.v2.Action result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.Action buildPartial() {
      com.google.privacy.dlp.v2.Action result = new com.google.privacy.dlp.v2.Action(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.privacy.dlp.v2.Action result) {
      int from_bitField0_ = bitField0_;
    }

    private void buildPartialOneofs(com.google.privacy.dlp.v2.Action result) {
      result.actionCase_ = actionCase_;
      result.action_ = this.action_;
      if (actionCase_ == 1 && saveFindingsBuilder_ != null) {
        result.action_ = saveFindingsBuilder_.build();
      }
      if (actionCase_ == 2 && pubSubBuilder_ != null) {
        result.action_ = pubSubBuilder_.build();
      }
      if (actionCase_ == 3 && publishSummaryToCsccBuilder_ != null) {
        result.action_ = publishSummaryToCsccBuilder_.build();
      }
      if (actionCase_ == 5 && publishFindingsToCloudDataCatalogBuilder_ != null) {
        result.action_ = publishFindingsToCloudDataCatalogBuilder_.build();
      }
      if (actionCase_ == 7 && deidentifyBuilder_ != null) {
        result.action_ = deidentifyBuilder_.build();
      }
      if (actionCase_ == 8 && jobNotificationEmailsBuilder_ != null) {
        result.action_ = jobNotificationEmailsBuilder_.build();
      }
      if (actionCase_ == 9 && publishToStackdriverBuilder_ != null) {
        result.action_ = publishToStackdriverBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.privacy.dlp.v2.Action) {
        return mergeFrom((com.google.privacy.dlp.v2.Action) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.privacy.dlp.v2.Action other) {
      if (other == com.google.privacy.dlp.v2.Action.getDefaultInstance()) return this;
      switch (other.getActionCase()) {
        case SAVE_FINDINGS:
          {
            mergeSaveFindings(other.getSaveFindings());
            break;
          }
        case PUB_SUB:
          {
            mergePubSub(other.getPubSub());
            break;
          }
        case PUBLISH_SUMMARY_TO_CSCC:
          {
            mergePublishSummaryToCscc(other.getPublishSummaryToCscc());
            break;
          }
        case PUBLISH_FINDINGS_TO_CLOUD_DATA_CATALOG:
          {
            mergePublishFindingsToCloudDataCatalog(other.getPublishFindingsToCloudDataCatalog());
            break;
          }
        case DEIDENTIFY:
          {
            mergeDeidentify(other.getDeidentify());
            break;
          }
        case JOB_NOTIFICATION_EMAILS:
          {
            mergeJobNotificationEmails(other.getJobNotificationEmails());
            break;
          }
        case PUBLISH_TO_STACKDRIVER:
          {
            mergePublishToStackdriver(other.getPublishToStackdriver());
            break;
          }
        case ACTION_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getSaveFindingsFieldBuilder().getBuilder(), extensionRegistry);
                actionCase_ = 1;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getPubSubFieldBuilder().getBuilder(), extensionRegistry);
                actionCase_ = 2;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(
                    getPublishSummaryToCsccFieldBuilder().getBuilder(), extensionRegistry);
                actionCase_ = 3;
                break;
              } // case 26
            case 42:
              {
                input.readMessage(
                    getPublishFindingsToCloudDataCatalogFieldBuilder().getBuilder(),
                    extensionRegistry);
                actionCase_ = 5;
                break;
              } // case 42
            case 58:
              {
                input.readMessage(getDeidentifyFieldBuilder().getBuilder(), extensionRegistry);
                actionCase_ = 7;
                break;
              } // case 58
            case 66:
              {
                input.readMessage(
                    getJobNotificationEmailsFieldBuilder().getBuilder(), extensionRegistry);
                actionCase_ = 8;
                break;
              } // case 66
            case 74:
              {
                input.readMessage(
                    getPublishToStackdriverFieldBuilder().getBuilder(), extensionRegistry);
                actionCase_ = 9;
                break;
              } // case 74
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int actionCase_ = 0;
    private java.lang.Object action_;

    public ActionCase getActionCase() {
      return ActionCase.forNumber(actionCase_);
    }

    public Builder clearAction() {
      actionCase_ = 0;
      action_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.Action.SaveFindings,
            com.google.privacy.dlp.v2.Action.SaveFindings.Builder,
            com.google.privacy.dlp.v2.Action.SaveFindingsOrBuilder>
        saveFindingsBuilder_;
    /**
     *
     *
     * <pre>
     * Save resulting findings in a provided location.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Action.SaveFindings save_findings = 1;</code>
     *
     * @return Whether the saveFindings field is set.
     */
    @java.lang.Override
    public boolean hasSaveFindings() {
      return actionCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * Save resulting findings in a provided location.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Action.SaveFindings save_findings = 1;</code>
     *
     * @return The saveFindings.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.Action.SaveFindings getSaveFindings() {
      if (saveFindingsBuilder_ == null) {
        if (actionCase_ == 1) {
          return (com.google.privacy.dlp.v2.Action.SaveFindings) action_;
        }
        return com.google.privacy.dlp.v2.Action.SaveFindings.getDefaultInstance();
      } else {
        if (actionCase_ == 1) {
          return saveFindingsBuilder_.getMessage();
        }
        return com.google.privacy.dlp.v2.Action.SaveFindings.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Save resulting findings in a provided location.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Action.SaveFindings save_findings = 1;</code>
     */
    public Builder setSaveFindings(com.google.privacy.dlp.v2.Action.SaveFindings value) {
      if (saveFindingsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        action_ = value;
        onChanged();
      } else {
        saveFindingsBuilder_.setMessage(value);
      }
      actionCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Save resulting findings in a provided location.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Action.SaveFindings save_findings = 1;</code>
     */
    public Builder setSaveFindings(
        com.google.privacy.dlp.v2.Action.SaveFindings.Builder builderForValue) {
      if (saveFindingsBuilder_ == null) {
        action_ = builderForValue.build();
        onChanged();
      } else {
        saveFindingsBuilder_.setMessage(builderForValue.build());
      }
      actionCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Save resulting findings in a provided location.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Action.SaveFindings save_findings = 1;</code>
     */
    public Builder mergeSaveFindings(com.google.privacy.dlp.v2.Action.SaveFindings value) {
      if (saveFindingsBuilder_ == null) {
        if (actionCase_ == 1
            && action_ != com.google.privacy.dlp.v2.Action.SaveFindings.getDefaultInstance()) {
          action_ =
              com.google.privacy.dlp.v2.Action.SaveFindings.newBuilder(
                      (com.google.privacy.dlp.v2.Action.SaveFindings) action_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          action_ = value;
        }
        onChanged();
      } else {
        if (actionCase_ == 1) {
          saveFindingsBuilder_.mergeFrom(value);
        } else {
          saveFindingsBuilder_.setMessage(value);
        }
      }
      actionCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Save resulting findings in a provided location.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Action.SaveFindings save_findings = 1;</code>
     */
    public Builder clearSaveFindings() {
      if (saveFindingsBuilder_ == null) {
        if (actionCase_ == 1) {
          actionCase_ = 0;
          action_ = null;
          onChanged();
        }
      } else {
        if (actionCase_ == 1) {
          actionCase_ = 0;
          action_ = null;
        }
        saveFindingsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Save resulting findings in a provided location.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Action.SaveFindings save_findings = 1;</code>
     */
    public com.google.privacy.dlp.v2.Action.SaveFindings.Builder getSaveFindingsBuilder() {
      return getSaveFindingsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Save resulting findings in a provided location.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Action.SaveFindings save_findings = 1;</code>
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.Action.SaveFindingsOrBuilder getSaveFindingsOrBuilder() {
      if ((actionCase_ == 1) && (saveFindingsBuilder_ != null)) {
        return saveFindingsBuilder_.getMessageOrBuilder();
      } else {
        if (actionCase_ == 1) {
          return (com.google.privacy.dlp.v2.Action.SaveFindings) action_;
        }
        return com.google.privacy.dlp.v2.Action.SaveFindings.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Save resulting findings in a provided location.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Action.SaveFindings save_findings = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.Action.SaveFindings,
            com.google.privacy.dlp.v2.Action.SaveFindings.Builder,
            com.google.privacy.dlp.v2.Action.SaveFindingsOrBuilder>
        getSaveFindingsFieldBuilder() {
      if (saveFindingsBuilder_ == null) {
        if (!(actionCase_ == 1)) {
          action_ = com.google.privacy.dlp.v2.Action.SaveFindings.getDefaultInstance();
        }
        saveFindingsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.Action.SaveFindings,
                com.google.privacy.dlp.v2.Action.SaveFindings.Builder,
                com.google.privacy.dlp.v2.Action.SaveFindingsOrBuilder>(
                (com.google.privacy.dlp.v2.Action.SaveFindings) action_,
                getParentForChildren(),
                isClean());
        action_ = null;
      }
      actionCase_ = 1;
      onChanged();
      return saveFindingsBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.Action.PublishToPubSub,
            com.google.privacy.dlp.v2.Action.PublishToPubSub.Builder,
            com.google.privacy.dlp.v2.Action.PublishToPubSubOrBuilder>
        pubSubBuilder_;
    /**
     *
     *
     * <pre>
     * Publish a notification to a Pub/Sub topic.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Action.PublishToPubSub pub_sub = 2;</code>
     *
     * @return Whether the pubSub field is set.
     */
    @java.lang.Override
    public boolean hasPubSub() {
      return actionCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Publish a notification to a Pub/Sub topic.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Action.PublishToPubSub pub_sub = 2;</code>
     *
     * @return The pubSub.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.Action.PublishToPubSub getPubSub() {
      if (pubSubBuilder_ == null) {
        if (actionCase_ == 2) {
          return (com.google.privacy.dlp.v2.Action.PublishToPubSub) action_;
        }
        return com.google.privacy.dlp.v2.Action.PublishToPubSub.getDefaultInstance();
      } else {
        if (actionCase_ == 2) {
          return pubSubBuilder_.getMessage();
        }
        return com.google.privacy.dlp.v2.Action.PublishToPubSub.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Publish a notification to a Pub/Sub topic.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Action.PublishToPubSub pub_sub = 2;</code>
     */
    public Builder setPubSub(com.google.privacy.dlp.v2.Action.PublishToPubSub value) {
      if (pubSubBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        action_ = value;
        onChanged();
      } else {
        pubSubBuilder_.setMessage(value);
      }
      actionCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Publish a notification to a Pub/Sub topic.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Action.PublishToPubSub pub_sub = 2;</code>
     */
    public Builder setPubSub(
        com.google.privacy.dlp.v2.Action.PublishToPubSub.Builder builderForValue) {
      if (pubSubBuilder_ == null) {
        action_ = builderForValue.build();
        onChanged();
      } else {
        pubSubBuilder_.setMessage(builderForValue.build());
      }
      actionCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Publish a notification to a Pub/Sub topic.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Action.PublishToPubSub pub_sub = 2;</code>
     */
    public Builder mergePubSub(com.google.privacy.dlp.v2.Action.PublishToPubSub value) {
      if (pubSubBuilder_ == null) {
        if (actionCase_ == 2
            && action_ != com.google.privacy.dlp.v2.Action.PublishToPubSub.getDefaultInstance()) {
          action_ =
              com.google.privacy.dlp.v2.Action.PublishToPubSub.newBuilder(
                      (com.google.privacy.dlp.v2.Action.PublishToPubSub) action_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          action_ = value;
        }
        onChanged();
      } else {
        if (actionCase_ == 2) {
          pubSubBuilder_.mergeFrom(value);
        } else {
          pubSubBuilder_.setMessage(value);
        }
      }
      actionCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Publish a notification to a Pub/Sub topic.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Action.PublishToPubSub pub_sub = 2;</code>
     */
    public Builder clearPubSub() {
      if (pubSubBuilder_ == null) {
        if (actionCase_ == 2) {
          actionCase_ = 0;
          action_ = null;
          onChanged();
        }
      } else {
        if (actionCase_ == 2) {
          actionCase_ = 0;
          action_ = null;
        }
        pubSubBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Publish a notification to a Pub/Sub topic.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Action.PublishToPubSub pub_sub = 2;</code>
     */
    public com.google.privacy.dlp.v2.Action.PublishToPubSub.Builder getPubSubBuilder() {
      return getPubSubFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Publish a notification to a Pub/Sub topic.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Action.PublishToPubSub pub_sub = 2;</code>
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.Action.PublishToPubSubOrBuilder getPubSubOrBuilder() {
      if ((actionCase_ == 2) && (pubSubBuilder_ != null)) {
        return pubSubBuilder_.getMessageOrBuilder();
      } else {
        if (actionCase_ == 2) {
          return (com.google.privacy.dlp.v2.Action.PublishToPubSub) action_;
        }
        return com.google.privacy.dlp.v2.Action.PublishToPubSub.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Publish a notification to a Pub/Sub topic.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Action.PublishToPubSub pub_sub = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.Action.PublishToPubSub,
            com.google.privacy.dlp.v2.Action.PublishToPubSub.Builder,
            com.google.privacy.dlp.v2.Action.PublishToPubSubOrBuilder>
        getPubSubFieldBuilder() {
      if (pubSubBuilder_ == null) {
        if (!(actionCase_ == 2)) {
          action_ = com.google.privacy.dlp.v2.Action.PublishToPubSub.getDefaultInstance();
        }
        pubSubBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.Action.PublishToPubSub,
                com.google.privacy.dlp.v2.Action.PublishToPubSub.Builder,
                com.google.privacy.dlp.v2.Action.PublishToPubSubOrBuilder>(
                (com.google.privacy.dlp.v2.Action.PublishToPubSub) action_,
                getParentForChildren(),
                isClean());
        action_ = null;
      }
      actionCase_ = 2;
      onChanged();
      return pubSubBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.Action.PublishSummaryToCscc,
            com.google.privacy.dlp.v2.Action.PublishSummaryToCscc.Builder,
            com.google.privacy.dlp.v2.Action.PublishSummaryToCsccOrBuilder>
        publishSummaryToCsccBuilder_;
    /**
     *
     *
     * <pre>
     * Publish summary to Cloud Security Command Center (Alpha).
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Action.PublishSummaryToCscc publish_summary_to_cscc = 3;</code>
     *
     * @return Whether the publishSummaryToCscc field is set.
     */
    @java.lang.Override
    public boolean hasPublishSummaryToCscc() {
      return actionCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * Publish summary to Cloud Security Command Center (Alpha).
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Action.PublishSummaryToCscc publish_summary_to_cscc = 3;</code>
     *
     * @return The publishSummaryToCscc.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.Action.PublishSummaryToCscc getPublishSummaryToCscc() {
      if (publishSummaryToCsccBuilder_ == null) {
        if (actionCase_ == 3) {
          return (com.google.privacy.dlp.v2.Action.PublishSummaryToCscc) action_;
        }
        return com.google.privacy.dlp.v2.Action.PublishSummaryToCscc.getDefaultInstance();
      } else {
        if (actionCase_ == 3) {
          return publishSummaryToCsccBuilder_.getMessage();
        }
        return com.google.privacy.dlp.v2.Action.PublishSummaryToCscc.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Publish summary to Cloud Security Command Center (Alpha).
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Action.PublishSummaryToCscc publish_summary_to_cscc = 3;</code>
     */
    public Builder setPublishSummaryToCscc(
        com.google.privacy.dlp.v2.Action.PublishSummaryToCscc value) {
      if (publishSummaryToCsccBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        action_ = value;
        onChanged();
      } else {
        publishSummaryToCsccBuilder_.setMessage(value);
      }
      actionCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Publish summary to Cloud Security Command Center (Alpha).
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Action.PublishSummaryToCscc publish_summary_to_cscc = 3;</code>
     */
    public Builder setPublishSummaryToCscc(
        com.google.privacy.dlp.v2.Action.PublishSummaryToCscc.Builder builderForValue) {
      if (publishSummaryToCsccBuilder_ == null) {
        action_ = builderForValue.build();
        onChanged();
      } else {
        publishSummaryToCsccBuilder_.setMessage(builderForValue.build());
      }
      actionCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Publish summary to Cloud Security Command Center (Alpha).
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Action.PublishSummaryToCscc publish_summary_to_cscc = 3;</code>
     */
    public Builder mergePublishSummaryToCscc(
        com.google.privacy.dlp.v2.Action.PublishSummaryToCscc value) {
      if (publishSummaryToCsccBuilder_ == null) {
        if (actionCase_ == 3
            && action_
                != com.google.privacy.dlp.v2.Action.PublishSummaryToCscc.getDefaultInstance()) {
          action_ =
              com.google.privacy.dlp.v2.Action.PublishSummaryToCscc.newBuilder(
                      (com.google.privacy.dlp.v2.Action.PublishSummaryToCscc) action_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          action_ = value;
        }
        onChanged();
      } else {
        if (actionCase_ == 3) {
          publishSummaryToCsccBuilder_.mergeFrom(value);
        } else {
          publishSummaryToCsccBuilder_.setMessage(value);
        }
      }
      actionCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Publish summary to Cloud Security Command Center (Alpha).
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Action.PublishSummaryToCscc publish_summary_to_cscc = 3;</code>
     */
    public Builder clearPublishSummaryToCscc() {
      if (publishSummaryToCsccBuilder_ == null) {
        if (actionCase_ == 3) {
          actionCase_ = 0;
          action_ = null;
          onChanged();
        }
      } else {
        if (actionCase_ == 3) {
          actionCase_ = 0;
          action_ = null;
        }
        publishSummaryToCsccBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Publish summary to Cloud Security Command Center (Alpha).
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Action.PublishSummaryToCscc publish_summary_to_cscc = 3;</code>
     */
    public com.google.privacy.dlp.v2.Action.PublishSummaryToCscc.Builder
        getPublishSummaryToCsccBuilder() {
      return getPublishSummaryToCsccFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Publish summary to Cloud Security Command Center (Alpha).
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Action.PublishSummaryToCscc publish_summary_to_cscc = 3;</code>
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.Action.PublishSummaryToCsccOrBuilder
        getPublishSummaryToCsccOrBuilder() {
      if ((actionCase_ == 3) && (publishSummaryToCsccBuilder_ != null)) {
        return publishSummaryToCsccBuilder_.getMessageOrBuilder();
      } else {
        if (actionCase_ == 3) {
          return (com.google.privacy.dlp.v2.Action.PublishSummaryToCscc) action_;
        }
        return com.google.privacy.dlp.v2.Action.PublishSummaryToCscc.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Publish summary to Cloud Security Command Center (Alpha).
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Action.PublishSummaryToCscc publish_summary_to_cscc = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.Action.PublishSummaryToCscc,
            com.google.privacy.dlp.v2.Action.PublishSummaryToCscc.Builder,
            com.google.privacy.dlp.v2.Action.PublishSummaryToCsccOrBuilder>
        getPublishSummaryToCsccFieldBuilder() {
      if (publishSummaryToCsccBuilder_ == null) {
        if (!(actionCase_ == 3)) {
          action_ = com.google.privacy.dlp.v2.Action.PublishSummaryToCscc.getDefaultInstance();
        }
        publishSummaryToCsccBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.Action.PublishSummaryToCscc,
                com.google.privacy.dlp.v2.Action.PublishSummaryToCscc.Builder,
                com.google.privacy.dlp.v2.Action.PublishSummaryToCsccOrBuilder>(
                (com.google.privacy.dlp.v2.Action.PublishSummaryToCscc) action_,
                getParentForChildren(),
                isClean());
        action_ = null;
      }
      actionCase_ = 3;
      onChanged();
      return publishSummaryToCsccBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.Action.PublishFindingsToCloudDataCatalog,
            com.google.privacy.dlp.v2.Action.PublishFindingsToCloudDataCatalog.Builder,
            com.google.privacy.dlp.v2.Action.PublishFindingsToCloudDataCatalogOrBuilder>
        publishFindingsToCloudDataCatalogBuilder_;
    /**
     *
     *
     * <pre>
     * Publish findings to Cloud Datahub.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.Action.PublishFindingsToCloudDataCatalog publish_findings_to_cloud_data_catalog = 5;
     * </code>
     *
     * @return Whether the publishFindingsToCloudDataCatalog field is set.
     */
    @java.lang.Override
    public boolean hasPublishFindingsToCloudDataCatalog() {
      return actionCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * Publish findings to Cloud Datahub.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.Action.PublishFindingsToCloudDataCatalog publish_findings_to_cloud_data_catalog = 5;
     * </code>
     *
     * @return The publishFindingsToCloudDataCatalog.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.Action.PublishFindingsToCloudDataCatalog
        getPublishFindingsToCloudDataCatalog() {
      if (publishFindingsToCloudDataCatalogBuilder_ == null) {
        if (actionCase_ == 5) {
          return (com.google.privacy.dlp.v2.Action.PublishFindingsToCloudDataCatalog) action_;
        }
        return com.google.privacy.dlp.v2.Action.PublishFindingsToCloudDataCatalog
            .getDefaultInstance();
      } else {
        if (actionCase_ == 5) {
          return publishFindingsToCloudDataCatalogBuilder_.getMessage();
        }
        return com.google.privacy.dlp.v2.Action.PublishFindingsToCloudDataCatalog
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Publish findings to Cloud Datahub.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.Action.PublishFindingsToCloudDataCatalog publish_findings_to_cloud_data_catalog = 5;
     * </code>
     */
    public Builder setPublishFindingsToCloudDataCatalog(
        com.google.privacy.dlp.v2.Action.PublishFindingsToCloudDataCatalog value) {
      if (publishFindingsToCloudDataCatalogBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        action_ = value;
        onChanged();
      } else {
        publishFindingsToCloudDataCatalogBuilder_.setMessage(value);
      }
      actionCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Publish findings to Cloud Datahub.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.Action.PublishFindingsToCloudDataCatalog publish_findings_to_cloud_data_catalog = 5;
     * </code>
     */
    public Builder setPublishFindingsToCloudDataCatalog(
        com.google.privacy.dlp.v2.Action.PublishFindingsToCloudDataCatalog.Builder
            builderForValue) {
      if (publishFindingsToCloudDataCatalogBuilder_ == null) {
        action_ = builderForValue.build();
        onChanged();
      } else {
        publishFindingsToCloudDataCatalogBuilder_.setMessage(builderForValue.build());
      }
      actionCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Publish findings to Cloud Datahub.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.Action.PublishFindingsToCloudDataCatalog publish_findings_to_cloud_data_catalog = 5;
     * </code>
     */
    public Builder mergePublishFindingsToCloudDataCatalog(
        com.google.privacy.dlp.v2.Action.PublishFindingsToCloudDataCatalog value) {
      if (publishFindingsToCloudDataCatalogBuilder_ == null) {
        if (actionCase_ == 5
            && action_
                != com.google.privacy.dlp.v2.Action.PublishFindingsToCloudDataCatalog
                    .getDefaultInstance()) {
          action_ =
              com.google.privacy.dlp.v2.Action.PublishFindingsToCloudDataCatalog.newBuilder(
                      (com.google.privacy.dlp.v2.Action.PublishFindingsToCloudDataCatalog) action_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          action_ = value;
        }
        onChanged();
      } else {
        if (actionCase_ == 5) {
          publishFindingsToCloudDataCatalogBuilder_.mergeFrom(value);
        } else {
          publishFindingsToCloudDataCatalogBuilder_.setMessage(value);
        }
      }
      actionCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Publish findings to Cloud Datahub.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.Action.PublishFindingsToCloudDataCatalog publish_findings_to_cloud_data_catalog = 5;
     * </code>
     */
    public Builder clearPublishFindingsToCloudDataCatalog() {
      if (publishFindingsToCloudDataCatalogBuilder_ == null) {
        if (actionCase_ == 5) {
          actionCase_ = 0;
          action_ = null;
          onChanged();
        }
      } else {
        if (actionCase_ == 5) {
          actionCase_ = 0;
          action_ = null;
        }
        publishFindingsToCloudDataCatalogBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Publish findings to Cloud Datahub.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.Action.PublishFindingsToCloudDataCatalog publish_findings_to_cloud_data_catalog = 5;
     * </code>
     */
    public com.google.privacy.dlp.v2.Action.PublishFindingsToCloudDataCatalog.Builder
        getPublishFindingsToCloudDataCatalogBuilder() {
      return getPublishFindingsToCloudDataCatalogFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Publish findings to Cloud Datahub.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.Action.PublishFindingsToCloudDataCatalog publish_findings_to_cloud_data_catalog = 5;
     * </code>
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.Action.PublishFindingsToCloudDataCatalogOrBuilder
        getPublishFindingsToCloudDataCatalogOrBuilder() {
      if ((actionCase_ == 5) && (publishFindingsToCloudDataCatalogBuilder_ != null)) {
        return publishFindingsToCloudDataCatalogBuilder_.getMessageOrBuilder();
      } else {
        if (actionCase_ == 5) {
          return (com.google.privacy.dlp.v2.Action.PublishFindingsToCloudDataCatalog) action_;
        }
        return com.google.privacy.dlp.v2.Action.PublishFindingsToCloudDataCatalog
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Publish findings to Cloud Datahub.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.Action.PublishFindingsToCloudDataCatalog publish_findings_to_cloud_data_catalog = 5;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.Action.PublishFindingsToCloudDataCatalog,
            com.google.privacy.dlp.v2.Action.PublishFindingsToCloudDataCatalog.Builder,
            com.google.privacy.dlp.v2.Action.PublishFindingsToCloudDataCatalogOrBuilder>
        getPublishFindingsToCloudDataCatalogFieldBuilder() {
      if (publishFindingsToCloudDataCatalogBuilder_ == null) {
        if (!(actionCase_ == 5)) {
          action_ =
              com.google.privacy.dlp.v2.Action.PublishFindingsToCloudDataCatalog
                  .getDefaultInstance();
        }
        publishFindingsToCloudDataCatalogBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.Action.PublishFindingsToCloudDataCatalog,
                com.google.privacy.dlp.v2.Action.PublishFindingsToCloudDataCatalog.Builder,
                com.google.privacy.dlp.v2.Action.PublishFindingsToCloudDataCatalogOrBuilder>(
                (com.google.privacy.dlp.v2.Action.PublishFindingsToCloudDataCatalog) action_,
                getParentForChildren(),
                isClean());
        action_ = null;
      }
      actionCase_ = 5;
      onChanged();
      return publishFindingsToCloudDataCatalogBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.Action.Deidentify,
            com.google.privacy.dlp.v2.Action.Deidentify.Builder,
            com.google.privacy.dlp.v2.Action.DeidentifyOrBuilder>
        deidentifyBuilder_;
    /**
     *
     *
     * <pre>
     * Create a de-identified copy of the input data.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Action.Deidentify deidentify = 7;</code>
     *
     * @return Whether the deidentify field is set.
     */
    @java.lang.Override
    public boolean hasDeidentify() {
      return actionCase_ == 7;
    }
    /**
     *
     *
     * <pre>
     * Create a de-identified copy of the input data.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Action.Deidentify deidentify = 7;</code>
     *
     * @return The deidentify.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.Action.Deidentify getDeidentify() {
      if (deidentifyBuilder_ == null) {
        if (actionCase_ == 7) {
          return (com.google.privacy.dlp.v2.Action.Deidentify) action_;
        }
        return com.google.privacy.dlp.v2.Action.Deidentify.getDefaultInstance();
      } else {
        if (actionCase_ == 7) {
          return deidentifyBuilder_.getMessage();
        }
        return com.google.privacy.dlp.v2.Action.Deidentify.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Create a de-identified copy of the input data.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Action.Deidentify deidentify = 7;</code>
     */
    public Builder setDeidentify(com.google.privacy.dlp.v2.Action.Deidentify value) {
      if (deidentifyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        action_ = value;
        onChanged();
      } else {
        deidentifyBuilder_.setMessage(value);
      }
      actionCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Create a de-identified copy of the input data.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Action.Deidentify deidentify = 7;</code>
     */
    public Builder setDeidentify(
        com.google.privacy.dlp.v2.Action.Deidentify.Builder builderForValue) {
      if (deidentifyBuilder_ == null) {
        action_ = builderForValue.build();
        onChanged();
      } else {
        deidentifyBuilder_.setMessage(builderForValue.build());
      }
      actionCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Create a de-identified copy of the input data.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Action.Deidentify deidentify = 7;</code>
     */
    public Builder mergeDeidentify(com.google.privacy.dlp.v2.Action.Deidentify value) {
      if (deidentifyBuilder_ == null) {
        if (actionCase_ == 7
            && action_ != com.google.privacy.dlp.v2.Action.Deidentify.getDefaultInstance()) {
          action_ =
              com.google.privacy.dlp.v2.Action.Deidentify.newBuilder(
                      (com.google.privacy.dlp.v2.Action.Deidentify) action_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          action_ = value;
        }
        onChanged();
      } else {
        if (actionCase_ == 7) {
          deidentifyBuilder_.mergeFrom(value);
        } else {
          deidentifyBuilder_.setMessage(value);
        }
      }
      actionCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Create a de-identified copy of the input data.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Action.Deidentify deidentify = 7;</code>
     */
    public Builder clearDeidentify() {
      if (deidentifyBuilder_ == null) {
        if (actionCase_ == 7) {
          actionCase_ = 0;
          action_ = null;
          onChanged();
        }
      } else {
        if (actionCase_ == 7) {
          actionCase_ = 0;
          action_ = null;
        }
        deidentifyBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Create a de-identified copy of the input data.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Action.Deidentify deidentify = 7;</code>
     */
    public com.google.privacy.dlp.v2.Action.Deidentify.Builder getDeidentifyBuilder() {
      return getDeidentifyFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Create a de-identified copy of the input data.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Action.Deidentify deidentify = 7;</code>
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.Action.DeidentifyOrBuilder getDeidentifyOrBuilder() {
      if ((actionCase_ == 7) && (deidentifyBuilder_ != null)) {
        return deidentifyBuilder_.getMessageOrBuilder();
      } else {
        if (actionCase_ == 7) {
          return (com.google.privacy.dlp.v2.Action.Deidentify) action_;
        }
        return com.google.privacy.dlp.v2.Action.Deidentify.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Create a de-identified copy of the input data.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Action.Deidentify deidentify = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.Action.Deidentify,
            com.google.privacy.dlp.v2.Action.Deidentify.Builder,
            com.google.privacy.dlp.v2.Action.DeidentifyOrBuilder>
        getDeidentifyFieldBuilder() {
      if (deidentifyBuilder_ == null) {
        if (!(actionCase_ == 7)) {
          action_ = com.google.privacy.dlp.v2.Action.Deidentify.getDefaultInstance();
        }
        deidentifyBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.Action.Deidentify,
                com.google.privacy.dlp.v2.Action.Deidentify.Builder,
                com.google.privacy.dlp.v2.Action.DeidentifyOrBuilder>(
                (com.google.privacy.dlp.v2.Action.Deidentify) action_,
                getParentForChildren(),
                isClean());
        action_ = null;
      }
      actionCase_ = 7;
      onChanged();
      return deidentifyBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.Action.JobNotificationEmails,
            com.google.privacy.dlp.v2.Action.JobNotificationEmails.Builder,
            com.google.privacy.dlp.v2.Action.JobNotificationEmailsOrBuilder>
        jobNotificationEmailsBuilder_;
    /**
     *
     *
     * <pre>
     * Sends an email when the job completes. The email goes to IAM project
     * owners and technical [Essential
     * Contacts](https://cloud.google.com/resource-manager/docs/managing-notification-contacts).
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Action.JobNotificationEmails job_notification_emails = 8;</code>
     *
     * @return Whether the jobNotificationEmails field is set.
     */
    @java.lang.Override
    public boolean hasJobNotificationEmails() {
      return actionCase_ == 8;
    }
    /**
     *
     *
     * <pre>
     * Sends an email when the job completes. The email goes to IAM project
     * owners and technical [Essential
     * Contacts](https://cloud.google.com/resource-manager/docs/managing-notification-contacts).
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Action.JobNotificationEmails job_notification_emails = 8;</code>
     *
     * @return The jobNotificationEmails.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.Action.JobNotificationEmails getJobNotificationEmails() {
      if (jobNotificationEmailsBuilder_ == null) {
        if (actionCase_ == 8) {
          return (com.google.privacy.dlp.v2.Action.JobNotificationEmails) action_;
        }
        return com.google.privacy.dlp.v2.Action.JobNotificationEmails.getDefaultInstance();
      } else {
        if (actionCase_ == 8) {
          return jobNotificationEmailsBuilder_.getMessage();
        }
        return com.google.privacy.dlp.v2.Action.JobNotificationEmails.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Sends an email when the job completes. The email goes to IAM project
     * owners and technical [Essential
     * Contacts](https://cloud.google.com/resource-manager/docs/managing-notification-contacts).
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Action.JobNotificationEmails job_notification_emails = 8;</code>
     */
    public Builder setJobNotificationEmails(
        com.google.privacy.dlp.v2.Action.JobNotificationEmails value) {
      if (jobNotificationEmailsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        action_ = value;
        onChanged();
      } else {
        jobNotificationEmailsBuilder_.setMessage(value);
      }
      actionCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Sends an email when the job completes. The email goes to IAM project
     * owners and technical [Essential
     * Contacts](https://cloud.google.com/resource-manager/docs/managing-notification-contacts).
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Action.JobNotificationEmails job_notification_emails = 8;</code>
     */
    public Builder setJobNotificationEmails(
        com.google.privacy.dlp.v2.Action.JobNotificationEmails.Builder builderForValue) {
      if (jobNotificationEmailsBuilder_ == null) {
        action_ = builderForValue.build();
        onChanged();
      } else {
        jobNotificationEmailsBuilder_.setMessage(builderForValue.build());
      }
      actionCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Sends an email when the job completes. The email goes to IAM project
     * owners and technical [Essential
     * Contacts](https://cloud.google.com/resource-manager/docs/managing-notification-contacts).
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Action.JobNotificationEmails job_notification_emails = 8;</code>
     */
    public Builder mergeJobNotificationEmails(
        com.google.privacy.dlp.v2.Action.JobNotificationEmails value) {
      if (jobNotificationEmailsBuilder_ == null) {
        if (actionCase_ == 8
            && action_
                != com.google.privacy.dlp.v2.Action.JobNotificationEmails.getDefaultInstance()) {
          action_ =
              com.google.privacy.dlp.v2.Action.JobNotificationEmails.newBuilder(
                      (com.google.privacy.dlp.v2.Action.JobNotificationEmails) action_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          action_ = value;
        }
        onChanged();
      } else {
        if (actionCase_ == 8) {
          jobNotificationEmailsBuilder_.mergeFrom(value);
        } else {
          jobNotificationEmailsBuilder_.setMessage(value);
        }
      }
      actionCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Sends an email when the job completes. The email goes to IAM project
     * owners and technical [Essential
     * Contacts](https://cloud.google.com/resource-manager/docs/managing-notification-contacts).
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Action.JobNotificationEmails job_notification_emails = 8;</code>
     */
    public Builder clearJobNotificationEmails() {
      if (jobNotificationEmailsBuilder_ == null) {
        if (actionCase_ == 8) {
          actionCase_ = 0;
          action_ = null;
          onChanged();
        }
      } else {
        if (actionCase_ == 8) {
          actionCase_ = 0;
          action_ = null;
        }
        jobNotificationEmailsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Sends an email when the job completes. The email goes to IAM project
     * owners and technical [Essential
     * Contacts](https://cloud.google.com/resource-manager/docs/managing-notification-contacts).
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Action.JobNotificationEmails job_notification_emails = 8;</code>
     */
    public com.google.privacy.dlp.v2.Action.JobNotificationEmails.Builder
        getJobNotificationEmailsBuilder() {
      return getJobNotificationEmailsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Sends an email when the job completes. The email goes to IAM project
     * owners and technical [Essential
     * Contacts](https://cloud.google.com/resource-manager/docs/managing-notification-contacts).
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Action.JobNotificationEmails job_notification_emails = 8;</code>
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.Action.JobNotificationEmailsOrBuilder
        getJobNotificationEmailsOrBuilder() {
      if ((actionCase_ == 8) && (jobNotificationEmailsBuilder_ != null)) {
        return jobNotificationEmailsBuilder_.getMessageOrBuilder();
      } else {
        if (actionCase_ == 8) {
          return (com.google.privacy.dlp.v2.Action.JobNotificationEmails) action_;
        }
        return com.google.privacy.dlp.v2.Action.JobNotificationEmails.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Sends an email when the job completes. The email goes to IAM project
     * owners and technical [Essential
     * Contacts](https://cloud.google.com/resource-manager/docs/managing-notification-contacts).
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Action.JobNotificationEmails job_notification_emails = 8;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.Action.JobNotificationEmails,
            com.google.privacy.dlp.v2.Action.JobNotificationEmails.Builder,
            com.google.privacy.dlp.v2.Action.JobNotificationEmailsOrBuilder>
        getJobNotificationEmailsFieldBuilder() {
      if (jobNotificationEmailsBuilder_ == null) {
        if (!(actionCase_ == 8)) {
          action_ = com.google.privacy.dlp.v2.Action.JobNotificationEmails.getDefaultInstance();
        }
        jobNotificationEmailsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.Action.JobNotificationEmails,
                com.google.privacy.dlp.v2.Action.JobNotificationEmails.Builder,
                com.google.privacy.dlp.v2.Action.JobNotificationEmailsOrBuilder>(
                (com.google.privacy.dlp.v2.Action.JobNotificationEmails) action_,
                getParentForChildren(),
                isClean());
        action_ = null;
      }
      actionCase_ = 8;
      onChanged();
      return jobNotificationEmailsBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.Action.PublishToStackdriver,
            com.google.privacy.dlp.v2.Action.PublishToStackdriver.Builder,
            com.google.privacy.dlp.v2.Action.PublishToStackdriverOrBuilder>
        publishToStackdriverBuilder_;
    /**
     *
     *
     * <pre>
     * Enable Stackdriver metric dlp.googleapis.com/finding_count.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Action.PublishToStackdriver publish_to_stackdriver = 9;</code>
     *
     * @return Whether the publishToStackdriver field is set.
     */
    @java.lang.Override
    public boolean hasPublishToStackdriver() {
      return actionCase_ == 9;
    }
    /**
     *
     *
     * <pre>
     * Enable Stackdriver metric dlp.googleapis.com/finding_count.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Action.PublishToStackdriver publish_to_stackdriver = 9;</code>
     *
     * @return The publishToStackdriver.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.Action.PublishToStackdriver getPublishToStackdriver() {
      if (publishToStackdriverBuilder_ == null) {
        if (actionCase_ == 9) {
          return (com.google.privacy.dlp.v2.Action.PublishToStackdriver) action_;
        }
        return com.google.privacy.dlp.v2.Action.PublishToStackdriver.getDefaultInstance();
      } else {
        if (actionCase_ == 9) {
          return publishToStackdriverBuilder_.getMessage();
        }
        return com.google.privacy.dlp.v2.Action.PublishToStackdriver.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Enable Stackdriver metric dlp.googleapis.com/finding_count.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Action.PublishToStackdriver publish_to_stackdriver = 9;</code>
     */
    public Builder setPublishToStackdriver(
        com.google.privacy.dlp.v2.Action.PublishToStackdriver value) {
      if (publishToStackdriverBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        action_ = value;
        onChanged();
      } else {
        publishToStackdriverBuilder_.setMessage(value);
      }
      actionCase_ = 9;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Enable Stackdriver metric dlp.googleapis.com/finding_count.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Action.PublishToStackdriver publish_to_stackdriver = 9;</code>
     */
    public Builder setPublishToStackdriver(
        com.google.privacy.dlp.v2.Action.PublishToStackdriver.Builder builderForValue) {
      if (publishToStackdriverBuilder_ == null) {
        action_ = builderForValue.build();
        onChanged();
      } else {
        publishToStackdriverBuilder_.setMessage(builderForValue.build());
      }
      actionCase_ = 9;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Enable Stackdriver metric dlp.googleapis.com/finding_count.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Action.PublishToStackdriver publish_to_stackdriver = 9;</code>
     */
    public Builder mergePublishToStackdriver(
        com.google.privacy.dlp.v2.Action.PublishToStackdriver value) {
      if (publishToStackdriverBuilder_ == null) {
        if (actionCase_ == 9
            && action_
                != com.google.privacy.dlp.v2.Action.PublishToStackdriver.getDefaultInstance()) {
          action_ =
              com.google.privacy.dlp.v2.Action.PublishToStackdriver.newBuilder(
                      (com.google.privacy.dlp.v2.Action.PublishToStackdriver) action_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          action_ = value;
        }
        onChanged();
      } else {
        if (actionCase_ == 9) {
          publishToStackdriverBuilder_.mergeFrom(value);
        } else {
          publishToStackdriverBuilder_.setMessage(value);
        }
      }
      actionCase_ = 9;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Enable Stackdriver metric dlp.googleapis.com/finding_count.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Action.PublishToStackdriver publish_to_stackdriver = 9;</code>
     */
    public Builder clearPublishToStackdriver() {
      if (publishToStackdriverBuilder_ == null) {
        if (actionCase_ == 9) {
          actionCase_ = 0;
          action_ = null;
          onChanged();
        }
      } else {
        if (actionCase_ == 9) {
          actionCase_ = 0;
          action_ = null;
        }
        publishToStackdriverBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Enable Stackdriver metric dlp.googleapis.com/finding_count.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Action.PublishToStackdriver publish_to_stackdriver = 9;</code>
     */
    public com.google.privacy.dlp.v2.Action.PublishToStackdriver.Builder
        getPublishToStackdriverBuilder() {
      return getPublishToStackdriverFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Enable Stackdriver metric dlp.googleapis.com/finding_count.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Action.PublishToStackdriver publish_to_stackdriver = 9;</code>
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.Action.PublishToStackdriverOrBuilder
        getPublishToStackdriverOrBuilder() {
      if ((actionCase_ == 9) && (publishToStackdriverBuilder_ != null)) {
        return publishToStackdriverBuilder_.getMessageOrBuilder();
      } else {
        if (actionCase_ == 9) {
          return (com.google.privacy.dlp.v2.Action.PublishToStackdriver) action_;
        }
        return com.google.privacy.dlp.v2.Action.PublishToStackdriver.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Enable Stackdriver metric dlp.googleapis.com/finding_count.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Action.PublishToStackdriver publish_to_stackdriver = 9;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.Action.PublishToStackdriver,
            com.google.privacy.dlp.v2.Action.PublishToStackdriver.Builder,
            com.google.privacy.dlp.v2.Action.PublishToStackdriverOrBuilder>
        getPublishToStackdriverFieldBuilder() {
      if (publishToStackdriverBuilder_ == null) {
        if (!(actionCase_ == 9)) {
          action_ = com.google.privacy.dlp.v2.Action.PublishToStackdriver.getDefaultInstance();
        }
        publishToStackdriverBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.Action.PublishToStackdriver,
                com.google.privacy.dlp.v2.Action.PublishToStackdriver.Builder,
                com.google.privacy.dlp.v2.Action.PublishToStackdriverOrBuilder>(
                (com.google.privacy.dlp.v2.Action.PublishToStackdriver) action_,
                getParentForChildren(),
                isClean());
        action_ = null;
      }
      actionCase_ = 9;
      onChanged();
      return publishToStackdriverBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.privacy.dlp.v2.Action)
  }

  // @@protoc_insertion_point(class_scope:google.privacy.dlp.v2.Action)
  private static final com.google.privacy.dlp.v2.Action DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.privacy.dlp.v2.Action();
  }

  public static com.google.privacy.dlp.v2.Action getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Action> PARSER =
      new com.google.protobuf.AbstractParser<Action>() {
        @java.lang.Override
        public Action parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Action> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Action> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.privacy.dlp.v2.Action getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
