/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/privacy/dlp/v2/dlp.proto

// Protobuf Java Version: 3.25.3
package com.google.privacy.dlp.v2;

/**
 *
 *
 * <pre>
 * Target used to match against for discovery with BigQuery tables
 * </pre>
 *
 * Protobuf type {@code google.privacy.dlp.v2.BigQueryDiscoveryTarget}
 */
public final class BigQueryDiscoveryTarget extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.privacy.dlp.v2.BigQueryDiscoveryTarget)
    BigQueryDiscoveryTargetOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use BigQueryDiscoveryTarget.newBuilder() to construct.
  private BigQueryDiscoveryTarget(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private BigQueryDiscoveryTarget() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new BigQueryDiscoveryTarget();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.privacy.dlp.v2.DlpProto
        .internal_static_google_privacy_dlp_v2_BigQueryDiscoveryTarget_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.privacy.dlp.v2.DlpProto
        .internal_static_google_privacy_dlp_v2_BigQueryDiscoveryTarget_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.privacy.dlp.v2.BigQueryDiscoveryTarget.class,
            com.google.privacy.dlp.v2.BigQueryDiscoveryTarget.Builder.class);
  }

  private int bitField0_;
  private int frequencyCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object frequency_;

  public enum FrequencyCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    CADENCE(3),
    DISABLED(4),
    FREQUENCY_NOT_SET(0);
    private final int value;

    private FrequencyCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static FrequencyCase valueOf(int value) {
      return forNumber(value);
    }

    public static FrequencyCase forNumber(int value) {
      switch (value) {
        case 3:
          return CADENCE;
        case 4:
          return DISABLED;
        case 0:
          return FREQUENCY_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public FrequencyCase getFrequencyCase() {
    return FrequencyCase.forNumber(frequencyCase_);
  }

  public static final int FILTER_FIELD_NUMBER = 1;
  private com.google.privacy.dlp.v2.DiscoveryBigQueryFilter filter_;
  /**
   *
   *
   * <pre>
   * Required. The tables the discovery cadence applies to. The first target
   * with a matching filter will be the one to apply to a table.
   * </pre>
   *
   * <code>
   * .google.privacy.dlp.v2.DiscoveryBigQueryFilter filter = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the filter field is set.
   */
  @java.lang.Override
  public boolean hasFilter() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Required. The tables the discovery cadence applies to. The first target
   * with a matching filter will be the one to apply to a table.
   * </pre>
   *
   * <code>
   * .google.privacy.dlp.v2.DiscoveryBigQueryFilter filter = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The filter.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.DiscoveryBigQueryFilter getFilter() {
    return filter_ == null
        ? com.google.privacy.dlp.v2.DiscoveryBigQueryFilter.getDefaultInstance()
        : filter_;
  }
  /**
   *
   *
   * <pre>
   * Required. The tables the discovery cadence applies to. The first target
   * with a matching filter will be the one to apply to a table.
   * </pre>
   *
   * <code>
   * .google.privacy.dlp.v2.DiscoveryBigQueryFilter filter = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.DiscoveryBigQueryFilterOrBuilder getFilterOrBuilder() {
    return filter_ == null
        ? com.google.privacy.dlp.v2.DiscoveryBigQueryFilter.getDefaultInstance()
        : filter_;
  }

  public static final int CONDITIONS_FIELD_NUMBER = 2;
  private com.google.privacy.dlp.v2.DiscoveryBigQueryConditions conditions_;
  /**
   *
   *
   * <pre>
   * In addition to matching the filter, these conditions must be true
   * before a profile is generated.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.DiscoveryBigQueryConditions conditions = 2;</code>
   *
   * @return Whether the conditions field is set.
   */
  @java.lang.Override
  public boolean hasConditions() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * In addition to matching the filter, these conditions must be true
   * before a profile is generated.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.DiscoveryBigQueryConditions conditions = 2;</code>
   *
   * @return The conditions.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.DiscoveryBigQueryConditions getConditions() {
    return conditions_ == null
        ? com.google.privacy.dlp.v2.DiscoveryBigQueryConditions.getDefaultInstance()
        : conditions_;
  }
  /**
   *
   *
   * <pre>
   * In addition to matching the filter, these conditions must be true
   * before a profile is generated.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.DiscoveryBigQueryConditions conditions = 2;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.DiscoveryBigQueryConditionsOrBuilder getConditionsOrBuilder() {
    return conditions_ == null
        ? com.google.privacy.dlp.v2.DiscoveryBigQueryConditions.getDefaultInstance()
        : conditions_;
  }

  public static final int CADENCE_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * How often and when to update profiles. New tables that match both the
   * filter and conditions are scanned as quickly as possible depending on
   * system capacity.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.DiscoveryGenerationCadence cadence = 3;</code>
   *
   * @return Whether the cadence field is set.
   */
  @java.lang.Override
  public boolean hasCadence() {
    return frequencyCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * How often and when to update profiles. New tables that match both the
   * filter and conditions are scanned as quickly as possible depending on
   * system capacity.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.DiscoveryGenerationCadence cadence = 3;</code>
   *
   * @return The cadence.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.DiscoveryGenerationCadence getCadence() {
    if (frequencyCase_ == 3) {
      return (com.google.privacy.dlp.v2.DiscoveryGenerationCadence) frequency_;
    }
    return com.google.privacy.dlp.v2.DiscoveryGenerationCadence.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * How often and when to update profiles. New tables that match both the
   * filter and conditions are scanned as quickly as possible depending on
   * system capacity.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.DiscoveryGenerationCadence cadence = 3;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.DiscoveryGenerationCadenceOrBuilder getCadenceOrBuilder() {
    if (frequencyCase_ == 3) {
      return (com.google.privacy.dlp.v2.DiscoveryGenerationCadence) frequency_;
    }
    return com.google.privacy.dlp.v2.DiscoveryGenerationCadence.getDefaultInstance();
  }

  public static final int DISABLED_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * Tables that match this filter will not have profiles created.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.Disabled disabled = 4;</code>
   *
   * @return Whether the disabled field is set.
   */
  @java.lang.Override
  public boolean hasDisabled() {
    return frequencyCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * Tables that match this filter will not have profiles created.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.Disabled disabled = 4;</code>
   *
   * @return The disabled.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.Disabled getDisabled() {
    if (frequencyCase_ == 4) {
      return (com.google.privacy.dlp.v2.Disabled) frequency_;
    }
    return com.google.privacy.dlp.v2.Disabled.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Tables that match this filter will not have profiles created.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.Disabled disabled = 4;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.DisabledOrBuilder getDisabledOrBuilder() {
    if (frequencyCase_ == 4) {
      return (com.google.privacy.dlp.v2.Disabled) frequency_;
    }
    return com.google.privacy.dlp.v2.Disabled.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getFilter());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(2, getConditions());
    }
    if (frequencyCase_ == 3) {
      output.writeMessage(3, (com.google.privacy.dlp.v2.DiscoveryGenerationCadence) frequency_);
    }
    if (frequencyCase_ == 4) {
      output.writeMessage(4, (com.google.privacy.dlp.v2.Disabled) frequency_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getFilter());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getConditions());
    }
    if (frequencyCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.privacy.dlp.v2.DiscoveryGenerationCadence) frequency_);
    }
    if (frequencyCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, (com.google.privacy.dlp.v2.Disabled) frequency_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.privacy.dlp.v2.BigQueryDiscoveryTarget)) {
      return super.equals(obj);
    }
    com.google.privacy.dlp.v2.BigQueryDiscoveryTarget other =
        (com.google.privacy.dlp.v2.BigQueryDiscoveryTarget) obj;

    if (hasFilter() != other.hasFilter()) return false;
    if (hasFilter()) {
      if (!getFilter().equals(other.getFilter())) return false;
    }
    if (hasConditions() != other.hasConditions()) return false;
    if (hasConditions()) {
      if (!getConditions().equals(other.getConditions())) return false;
    }
    if (!getFrequencyCase().equals(other.getFrequencyCase())) return false;
    switch (frequencyCase_) {
      case 3:
        if (!getCadence().equals(other.getCadence())) return false;
        break;
      case 4:
        if (!getDisabled().equals(other.getDisabled())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasFilter()) {
      hash = (37 * hash) + FILTER_FIELD_NUMBER;
      hash = (53 * hash) + getFilter().hashCode();
    }
    if (hasConditions()) {
      hash = (37 * hash) + CONDITIONS_FIELD_NUMBER;
      hash = (53 * hash) + getConditions().hashCode();
    }
    switch (frequencyCase_) {
      case 3:
        hash = (37 * hash) + CADENCE_FIELD_NUMBER;
        hash = (53 * hash) + getCadence().hashCode();
        break;
      case 4:
        hash = (37 * hash) + DISABLED_FIELD_NUMBER;
        hash = (53 * hash) + getDisabled().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.privacy.dlp.v2.BigQueryDiscoveryTarget parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.BigQueryDiscoveryTarget parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.BigQueryDiscoveryTarget parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.BigQueryDiscoveryTarget parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.BigQueryDiscoveryTarget parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.BigQueryDiscoveryTarget parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.BigQueryDiscoveryTarget parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.BigQueryDiscoveryTarget parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.BigQueryDiscoveryTarget parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.BigQueryDiscoveryTarget parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.BigQueryDiscoveryTarget parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.BigQueryDiscoveryTarget parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.privacy.dlp.v2.BigQueryDiscoveryTarget prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Target used to match against for discovery with BigQuery tables
   * </pre>
   *
   * Protobuf type {@code google.privacy.dlp.v2.BigQueryDiscoveryTarget}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.privacy.dlp.v2.BigQueryDiscoveryTarget)
      com.google.privacy.dlp.v2.BigQueryDiscoveryTargetOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_BigQueryDiscoveryTarget_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_BigQueryDiscoveryTarget_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.privacy.dlp.v2.BigQueryDiscoveryTarget.class,
              com.google.privacy.dlp.v2.BigQueryDiscoveryTarget.Builder.class);
    }

    // Construct using com.google.privacy.dlp.v2.BigQueryDiscoveryTarget.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getFilterFieldBuilder();
        getConditionsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      filter_ = null;
      if (filterBuilder_ != null) {
        filterBuilder_.dispose();
        filterBuilder_ = null;
      }
      conditions_ = null;
      if (conditionsBuilder_ != null) {
        conditionsBuilder_.dispose();
        conditionsBuilder_ = null;
      }
      if (cadenceBuilder_ != null) {
        cadenceBuilder_.clear();
      }
      if (disabledBuilder_ != null) {
        disabledBuilder_.clear();
      }
      frequencyCase_ = 0;
      frequency_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_BigQueryDiscoveryTarget_descriptor;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.BigQueryDiscoveryTarget getDefaultInstanceForType() {
      return com.google.privacy.dlp.v2.BigQueryDiscoveryTarget.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.BigQueryDiscoveryTarget build() {
      com.google.privacy.dlp.v2.BigQueryDiscoveryTarget result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.BigQueryDiscoveryTarget buildPartial() {
      com.google.privacy.dlp.v2.BigQueryDiscoveryTarget result =
          new com.google.privacy.dlp.v2.BigQueryDiscoveryTarget(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.privacy.dlp.v2.BigQueryDiscoveryTarget result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.filter_ = filterBuilder_ == null ? filter_ : filterBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.conditions_ = conditionsBuilder_ == null ? conditions_ : conditionsBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.privacy.dlp.v2.BigQueryDiscoveryTarget result) {
      result.frequencyCase_ = frequencyCase_;
      result.frequency_ = this.frequency_;
      if (frequencyCase_ == 3 && cadenceBuilder_ != null) {
        result.frequency_ = cadenceBuilder_.build();
      }
      if (frequencyCase_ == 4 && disabledBuilder_ != null) {
        result.frequency_ = disabledBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.privacy.dlp.v2.BigQueryDiscoveryTarget) {
        return mergeFrom((com.google.privacy.dlp.v2.BigQueryDiscoveryTarget) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.privacy.dlp.v2.BigQueryDiscoveryTarget other) {
      if (other == com.google.privacy.dlp.v2.BigQueryDiscoveryTarget.getDefaultInstance())
        return this;
      if (other.hasFilter()) {
        mergeFilter(other.getFilter());
      }
      if (other.hasConditions()) {
        mergeConditions(other.getConditions());
      }
      switch (other.getFrequencyCase()) {
        case CADENCE:
          {
            mergeCadence(other.getCadence());
            break;
          }
        case DISABLED:
          {
            mergeDisabled(other.getDisabled());
            break;
          }
        case FREQUENCY_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getFilterFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getConditionsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getCadenceFieldBuilder().getBuilder(), extensionRegistry);
                frequencyCase_ = 3;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getDisabledFieldBuilder().getBuilder(), extensionRegistry);
                frequencyCase_ = 4;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int frequencyCase_ = 0;
    private java.lang.Object frequency_;

    public FrequencyCase getFrequencyCase() {
      return FrequencyCase.forNumber(frequencyCase_);
    }

    public Builder clearFrequency() {
      frequencyCase_ = 0;
      frequency_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.privacy.dlp.v2.DiscoveryBigQueryFilter filter_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.DiscoveryBigQueryFilter,
            com.google.privacy.dlp.v2.DiscoveryBigQueryFilter.Builder,
            com.google.privacy.dlp.v2.DiscoveryBigQueryFilterOrBuilder>
        filterBuilder_;
    /**
     *
     *
     * <pre>
     * Required. The tables the discovery cadence applies to. The first target
     * with a matching filter will be the one to apply to a table.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.DiscoveryBigQueryFilter filter = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the filter field is set.
     */
    public boolean hasFilter() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. The tables the discovery cadence applies to. The first target
     * with a matching filter will be the one to apply to a table.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.DiscoveryBigQueryFilter filter = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The filter.
     */
    public com.google.privacy.dlp.v2.DiscoveryBigQueryFilter getFilter() {
      if (filterBuilder_ == null) {
        return filter_ == null
            ? com.google.privacy.dlp.v2.DiscoveryBigQueryFilter.getDefaultInstance()
            : filter_;
      } else {
        return filterBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The tables the discovery cadence applies to. The first target
     * with a matching filter will be the one to apply to a table.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.DiscoveryBigQueryFilter filter = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setFilter(com.google.privacy.dlp.v2.DiscoveryBigQueryFilter value) {
      if (filterBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        filter_ = value;
      } else {
        filterBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The tables the discovery cadence applies to. The first target
     * with a matching filter will be the one to apply to a table.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.DiscoveryBigQueryFilter filter = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setFilter(
        com.google.privacy.dlp.v2.DiscoveryBigQueryFilter.Builder builderForValue) {
      if (filterBuilder_ == null) {
        filter_ = builderForValue.build();
      } else {
        filterBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The tables the discovery cadence applies to. The first target
     * with a matching filter will be the one to apply to a table.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.DiscoveryBigQueryFilter filter = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeFilter(com.google.privacy.dlp.v2.DiscoveryBigQueryFilter value) {
      if (filterBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && filter_ != null
            && filter_ != com.google.privacy.dlp.v2.DiscoveryBigQueryFilter.getDefaultInstance()) {
          getFilterBuilder().mergeFrom(value);
        } else {
          filter_ = value;
        }
      } else {
        filterBuilder_.mergeFrom(value);
      }
      if (filter_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The tables the discovery cadence applies to. The first target
     * with a matching filter will be the one to apply to a table.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.DiscoveryBigQueryFilter filter = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearFilter() {
      bitField0_ = (bitField0_ & ~0x00000001);
      filter_ = null;
      if (filterBuilder_ != null) {
        filterBuilder_.dispose();
        filterBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The tables the discovery cadence applies to. The first target
     * with a matching filter will be the one to apply to a table.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.DiscoveryBigQueryFilter filter = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.privacy.dlp.v2.DiscoveryBigQueryFilter.Builder getFilterBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getFilterFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. The tables the discovery cadence applies to. The first target
     * with a matching filter will be the one to apply to a table.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.DiscoveryBigQueryFilter filter = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.privacy.dlp.v2.DiscoveryBigQueryFilterOrBuilder getFilterOrBuilder() {
      if (filterBuilder_ != null) {
        return filterBuilder_.getMessageOrBuilder();
      } else {
        return filter_ == null
            ? com.google.privacy.dlp.v2.DiscoveryBigQueryFilter.getDefaultInstance()
            : filter_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The tables the discovery cadence applies to. The first target
     * with a matching filter will be the one to apply to a table.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.DiscoveryBigQueryFilter filter = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.DiscoveryBigQueryFilter,
            com.google.privacy.dlp.v2.DiscoveryBigQueryFilter.Builder,
            com.google.privacy.dlp.v2.DiscoveryBigQueryFilterOrBuilder>
        getFilterFieldBuilder() {
      if (filterBuilder_ == null) {
        filterBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.DiscoveryBigQueryFilter,
                com.google.privacy.dlp.v2.DiscoveryBigQueryFilter.Builder,
                com.google.privacy.dlp.v2.DiscoveryBigQueryFilterOrBuilder>(
                getFilter(), getParentForChildren(), isClean());
        filter_ = null;
      }
      return filterBuilder_;
    }

    private com.google.privacy.dlp.v2.DiscoveryBigQueryConditions conditions_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.DiscoveryBigQueryConditions,
            com.google.privacy.dlp.v2.DiscoveryBigQueryConditions.Builder,
            com.google.privacy.dlp.v2.DiscoveryBigQueryConditionsOrBuilder>
        conditionsBuilder_;
    /**
     *
     *
     * <pre>
     * In addition to matching the filter, these conditions must be true
     * before a profile is generated.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DiscoveryBigQueryConditions conditions = 2;</code>
     *
     * @return Whether the conditions field is set.
     */
    public boolean hasConditions() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * In addition to matching the filter, these conditions must be true
     * before a profile is generated.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DiscoveryBigQueryConditions conditions = 2;</code>
     *
     * @return The conditions.
     */
    public com.google.privacy.dlp.v2.DiscoveryBigQueryConditions getConditions() {
      if (conditionsBuilder_ == null) {
        return conditions_ == null
            ? com.google.privacy.dlp.v2.DiscoveryBigQueryConditions.getDefaultInstance()
            : conditions_;
      } else {
        return conditionsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * In addition to matching the filter, these conditions must be true
     * before a profile is generated.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DiscoveryBigQueryConditions conditions = 2;</code>
     */
    public Builder setConditions(com.google.privacy.dlp.v2.DiscoveryBigQueryConditions value) {
      if (conditionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        conditions_ = value;
      } else {
        conditionsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * In addition to matching the filter, these conditions must be true
     * before a profile is generated.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DiscoveryBigQueryConditions conditions = 2;</code>
     */
    public Builder setConditions(
        com.google.privacy.dlp.v2.DiscoveryBigQueryConditions.Builder builderForValue) {
      if (conditionsBuilder_ == null) {
        conditions_ = builderForValue.build();
      } else {
        conditionsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * In addition to matching the filter, these conditions must be true
     * before a profile is generated.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DiscoveryBigQueryConditions conditions = 2;</code>
     */
    public Builder mergeConditions(com.google.privacy.dlp.v2.DiscoveryBigQueryConditions value) {
      if (conditionsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && conditions_ != null
            && conditions_
                != com.google.privacy.dlp.v2.DiscoveryBigQueryConditions.getDefaultInstance()) {
          getConditionsBuilder().mergeFrom(value);
        } else {
          conditions_ = value;
        }
      } else {
        conditionsBuilder_.mergeFrom(value);
      }
      if (conditions_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * In addition to matching the filter, these conditions must be true
     * before a profile is generated.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DiscoveryBigQueryConditions conditions = 2;</code>
     */
    public Builder clearConditions() {
      bitField0_ = (bitField0_ & ~0x00000002);
      conditions_ = null;
      if (conditionsBuilder_ != null) {
        conditionsBuilder_.dispose();
        conditionsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * In addition to matching the filter, these conditions must be true
     * before a profile is generated.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DiscoveryBigQueryConditions conditions = 2;</code>
     */
    public com.google.privacy.dlp.v2.DiscoveryBigQueryConditions.Builder getConditionsBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getConditionsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * In addition to matching the filter, these conditions must be true
     * before a profile is generated.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DiscoveryBigQueryConditions conditions = 2;</code>
     */
    public com.google.privacy.dlp.v2.DiscoveryBigQueryConditionsOrBuilder getConditionsOrBuilder() {
      if (conditionsBuilder_ != null) {
        return conditionsBuilder_.getMessageOrBuilder();
      } else {
        return conditions_ == null
            ? com.google.privacy.dlp.v2.DiscoveryBigQueryConditions.getDefaultInstance()
            : conditions_;
      }
    }
    /**
     *
     *
     * <pre>
     * In addition to matching the filter, these conditions must be true
     * before a profile is generated.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DiscoveryBigQueryConditions conditions = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.DiscoveryBigQueryConditions,
            com.google.privacy.dlp.v2.DiscoveryBigQueryConditions.Builder,
            com.google.privacy.dlp.v2.DiscoveryBigQueryConditionsOrBuilder>
        getConditionsFieldBuilder() {
      if (conditionsBuilder_ == null) {
        conditionsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.DiscoveryBigQueryConditions,
                com.google.privacy.dlp.v2.DiscoveryBigQueryConditions.Builder,
                com.google.privacy.dlp.v2.DiscoveryBigQueryConditionsOrBuilder>(
                getConditions(), getParentForChildren(), isClean());
        conditions_ = null;
      }
      return conditionsBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.DiscoveryGenerationCadence,
            com.google.privacy.dlp.v2.DiscoveryGenerationCadence.Builder,
            com.google.privacy.dlp.v2.DiscoveryGenerationCadenceOrBuilder>
        cadenceBuilder_;
    /**
     *
     *
     * <pre>
     * How often and when to update profiles. New tables that match both the
     * filter and conditions are scanned as quickly as possible depending on
     * system capacity.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DiscoveryGenerationCadence cadence = 3;</code>
     *
     * @return Whether the cadence field is set.
     */
    @java.lang.Override
    public boolean hasCadence() {
      return frequencyCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * How often and when to update profiles. New tables that match both the
     * filter and conditions are scanned as quickly as possible depending on
     * system capacity.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DiscoveryGenerationCadence cadence = 3;</code>
     *
     * @return The cadence.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.DiscoveryGenerationCadence getCadence() {
      if (cadenceBuilder_ == null) {
        if (frequencyCase_ == 3) {
          return (com.google.privacy.dlp.v2.DiscoveryGenerationCadence) frequency_;
        }
        return com.google.privacy.dlp.v2.DiscoveryGenerationCadence.getDefaultInstance();
      } else {
        if (frequencyCase_ == 3) {
          return cadenceBuilder_.getMessage();
        }
        return com.google.privacy.dlp.v2.DiscoveryGenerationCadence.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * How often and when to update profiles. New tables that match both the
     * filter and conditions are scanned as quickly as possible depending on
     * system capacity.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DiscoveryGenerationCadence cadence = 3;</code>
     */
    public Builder setCadence(com.google.privacy.dlp.v2.DiscoveryGenerationCadence value) {
      if (cadenceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        frequency_ = value;
        onChanged();
      } else {
        cadenceBuilder_.setMessage(value);
      }
      frequencyCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * How often and when to update profiles. New tables that match both the
     * filter and conditions are scanned as quickly as possible depending on
     * system capacity.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DiscoveryGenerationCadence cadence = 3;</code>
     */
    public Builder setCadence(
        com.google.privacy.dlp.v2.DiscoveryGenerationCadence.Builder builderForValue) {
      if (cadenceBuilder_ == null) {
        frequency_ = builderForValue.build();
        onChanged();
      } else {
        cadenceBuilder_.setMessage(builderForValue.build());
      }
      frequencyCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * How often and when to update profiles. New tables that match both the
     * filter and conditions are scanned as quickly as possible depending on
     * system capacity.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DiscoveryGenerationCadence cadence = 3;</code>
     */
    public Builder mergeCadence(com.google.privacy.dlp.v2.DiscoveryGenerationCadence value) {
      if (cadenceBuilder_ == null) {
        if (frequencyCase_ == 3
            && frequency_
                != com.google.privacy.dlp.v2.DiscoveryGenerationCadence.getDefaultInstance()) {
          frequency_ =
              com.google.privacy.dlp.v2.DiscoveryGenerationCadence.newBuilder(
                      (com.google.privacy.dlp.v2.DiscoveryGenerationCadence) frequency_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          frequency_ = value;
        }
        onChanged();
      } else {
        if (frequencyCase_ == 3) {
          cadenceBuilder_.mergeFrom(value);
        } else {
          cadenceBuilder_.setMessage(value);
        }
      }
      frequencyCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * How often and when to update profiles. New tables that match both the
     * filter and conditions are scanned as quickly as possible depending on
     * system capacity.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DiscoveryGenerationCadence cadence = 3;</code>
     */
    public Builder clearCadence() {
      if (cadenceBuilder_ == null) {
        if (frequencyCase_ == 3) {
          frequencyCase_ = 0;
          frequency_ = null;
          onChanged();
        }
      } else {
        if (frequencyCase_ == 3) {
          frequencyCase_ = 0;
          frequency_ = null;
        }
        cadenceBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * How often and when to update profiles. New tables that match both the
     * filter and conditions are scanned as quickly as possible depending on
     * system capacity.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DiscoveryGenerationCadence cadence = 3;</code>
     */
    public com.google.privacy.dlp.v2.DiscoveryGenerationCadence.Builder getCadenceBuilder() {
      return getCadenceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * How often and when to update profiles. New tables that match both the
     * filter and conditions are scanned as quickly as possible depending on
     * system capacity.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DiscoveryGenerationCadence cadence = 3;</code>
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.DiscoveryGenerationCadenceOrBuilder getCadenceOrBuilder() {
      if ((frequencyCase_ == 3) && (cadenceBuilder_ != null)) {
        return cadenceBuilder_.getMessageOrBuilder();
      } else {
        if (frequencyCase_ == 3) {
          return (com.google.privacy.dlp.v2.DiscoveryGenerationCadence) frequency_;
        }
        return com.google.privacy.dlp.v2.DiscoveryGenerationCadence.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * How often and when to update profiles. New tables that match both the
     * filter and conditions are scanned as quickly as possible depending on
     * system capacity.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DiscoveryGenerationCadence cadence = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.DiscoveryGenerationCadence,
            com.google.privacy.dlp.v2.DiscoveryGenerationCadence.Builder,
            com.google.privacy.dlp.v2.DiscoveryGenerationCadenceOrBuilder>
        getCadenceFieldBuilder() {
      if (cadenceBuilder_ == null) {
        if (!(frequencyCase_ == 3)) {
          frequency_ = com.google.privacy.dlp.v2.DiscoveryGenerationCadence.getDefaultInstance();
        }
        cadenceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.DiscoveryGenerationCadence,
                com.google.privacy.dlp.v2.DiscoveryGenerationCadence.Builder,
                com.google.privacy.dlp.v2.DiscoveryGenerationCadenceOrBuilder>(
                (com.google.privacy.dlp.v2.DiscoveryGenerationCadence) frequency_,
                getParentForChildren(),
                isClean());
        frequency_ = null;
      }
      frequencyCase_ = 3;
      onChanged();
      return cadenceBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.Disabled,
            com.google.privacy.dlp.v2.Disabled.Builder,
            com.google.privacy.dlp.v2.DisabledOrBuilder>
        disabledBuilder_;
    /**
     *
     *
     * <pre>
     * Tables that match this filter will not have profiles created.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Disabled disabled = 4;</code>
     *
     * @return Whether the disabled field is set.
     */
    @java.lang.Override
    public boolean hasDisabled() {
      return frequencyCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * Tables that match this filter will not have profiles created.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Disabled disabled = 4;</code>
     *
     * @return The disabled.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.Disabled getDisabled() {
      if (disabledBuilder_ == null) {
        if (frequencyCase_ == 4) {
          return (com.google.privacy.dlp.v2.Disabled) frequency_;
        }
        return com.google.privacy.dlp.v2.Disabled.getDefaultInstance();
      } else {
        if (frequencyCase_ == 4) {
          return disabledBuilder_.getMessage();
        }
        return com.google.privacy.dlp.v2.Disabled.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Tables that match this filter will not have profiles created.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Disabled disabled = 4;</code>
     */
    public Builder setDisabled(com.google.privacy.dlp.v2.Disabled value) {
      if (disabledBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        frequency_ = value;
        onChanged();
      } else {
        disabledBuilder_.setMessage(value);
      }
      frequencyCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Tables that match this filter will not have profiles created.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Disabled disabled = 4;</code>
     */
    public Builder setDisabled(com.google.privacy.dlp.v2.Disabled.Builder builderForValue) {
      if (disabledBuilder_ == null) {
        frequency_ = builderForValue.build();
        onChanged();
      } else {
        disabledBuilder_.setMessage(builderForValue.build());
      }
      frequencyCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Tables that match this filter will not have profiles created.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Disabled disabled = 4;</code>
     */
    public Builder mergeDisabled(com.google.privacy.dlp.v2.Disabled value) {
      if (disabledBuilder_ == null) {
        if (frequencyCase_ == 4
            && frequency_ != com.google.privacy.dlp.v2.Disabled.getDefaultInstance()) {
          frequency_ =
              com.google.privacy.dlp.v2.Disabled.newBuilder(
                      (com.google.privacy.dlp.v2.Disabled) frequency_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          frequency_ = value;
        }
        onChanged();
      } else {
        if (frequencyCase_ == 4) {
          disabledBuilder_.mergeFrom(value);
        } else {
          disabledBuilder_.setMessage(value);
        }
      }
      frequencyCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Tables that match this filter will not have profiles created.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Disabled disabled = 4;</code>
     */
    public Builder clearDisabled() {
      if (disabledBuilder_ == null) {
        if (frequencyCase_ == 4) {
          frequencyCase_ = 0;
          frequency_ = null;
          onChanged();
        }
      } else {
        if (frequencyCase_ == 4) {
          frequencyCase_ = 0;
          frequency_ = null;
        }
        disabledBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Tables that match this filter will not have profiles created.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Disabled disabled = 4;</code>
     */
    public com.google.privacy.dlp.v2.Disabled.Builder getDisabledBuilder() {
      return getDisabledFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Tables that match this filter will not have profiles created.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Disabled disabled = 4;</code>
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.DisabledOrBuilder getDisabledOrBuilder() {
      if ((frequencyCase_ == 4) && (disabledBuilder_ != null)) {
        return disabledBuilder_.getMessageOrBuilder();
      } else {
        if (frequencyCase_ == 4) {
          return (com.google.privacy.dlp.v2.Disabled) frequency_;
        }
        return com.google.privacy.dlp.v2.Disabled.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Tables that match this filter will not have profiles created.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Disabled disabled = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.Disabled,
            com.google.privacy.dlp.v2.Disabled.Builder,
            com.google.privacy.dlp.v2.DisabledOrBuilder>
        getDisabledFieldBuilder() {
      if (disabledBuilder_ == null) {
        if (!(frequencyCase_ == 4)) {
          frequency_ = com.google.privacy.dlp.v2.Disabled.getDefaultInstance();
        }
        disabledBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.Disabled,
                com.google.privacy.dlp.v2.Disabled.Builder,
                com.google.privacy.dlp.v2.DisabledOrBuilder>(
                (com.google.privacy.dlp.v2.Disabled) frequency_, getParentForChildren(), isClean());
        frequency_ = null;
      }
      frequencyCase_ = 4;
      onChanged();
      return disabledBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.privacy.dlp.v2.BigQueryDiscoveryTarget)
  }

  // @@protoc_insertion_point(class_scope:google.privacy.dlp.v2.BigQueryDiscoveryTarget)
  private static final com.google.privacy.dlp.v2.BigQueryDiscoveryTarget DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.privacy.dlp.v2.BigQueryDiscoveryTarget();
  }

  public static com.google.privacy.dlp.v2.BigQueryDiscoveryTarget getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<BigQueryDiscoveryTarget> PARSER =
      new com.google.protobuf.AbstractParser<BigQueryDiscoveryTarget>() {
        @java.lang.Override
        public BigQueryDiscoveryTarget parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<BigQueryDiscoveryTarget> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<BigQueryDiscoveryTarget> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.privacy.dlp.v2.BigQueryDiscoveryTarget getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
