/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/privacy/dlp/v2/storage.proto

// Protobuf Java Version: 3.25.3
package com.google.privacy.dlp.v2;

/**
 *
 *
 * <pre>
 * Options defining BigQuery table and row identifiers.
 * </pre>
 *
 * Protobuf type {@code google.privacy.dlp.v2.BigQueryOptions}
 */
public final class BigQueryOptions extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.privacy.dlp.v2.BigQueryOptions)
    BigQueryOptionsOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use BigQueryOptions.newBuilder() to construct.
  private BigQueryOptions(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private BigQueryOptions() {
    identifyingFields_ = java.util.Collections.emptyList();
    sampleMethod_ = 0;
    excludedFields_ = java.util.Collections.emptyList();
    includedFields_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new BigQueryOptions();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.privacy.dlp.v2.DlpStorage
        .internal_static_google_privacy_dlp_v2_BigQueryOptions_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.privacy.dlp.v2.DlpStorage
        .internal_static_google_privacy_dlp_v2_BigQueryOptions_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.privacy.dlp.v2.BigQueryOptions.class,
            com.google.privacy.dlp.v2.BigQueryOptions.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * How to sample rows if not all rows are scanned. Meaningful only when used
   * in conjunction with either rows_limit or rows_limit_percent. If not
   * specified, rows are scanned in the order BigQuery reads them.
   * </pre>
   *
   * Protobuf enum {@code google.privacy.dlp.v2.BigQueryOptions.SampleMethod}
   */
  public enum SampleMethod implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * No sampling.
     * </pre>
     *
     * <code>SAMPLE_METHOD_UNSPECIFIED = 0;</code>
     */
    SAMPLE_METHOD_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Scan groups of rows in the order BigQuery provides (default). Multiple
     * groups of rows may be scanned in parallel, so results may not appear in
     * the same order the rows are read.
     * </pre>
     *
     * <code>TOP = 1;</code>
     */
    TOP(1),
    /**
     *
     *
     * <pre>
     * Randomly pick groups of rows to scan.
     * </pre>
     *
     * <code>RANDOM_START = 2;</code>
     */
    RANDOM_START(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * No sampling.
     * </pre>
     *
     * <code>SAMPLE_METHOD_UNSPECIFIED = 0;</code>
     */
    public static final int SAMPLE_METHOD_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Scan groups of rows in the order BigQuery provides (default). Multiple
     * groups of rows may be scanned in parallel, so results may not appear in
     * the same order the rows are read.
     * </pre>
     *
     * <code>TOP = 1;</code>
     */
    public static final int TOP_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Randomly pick groups of rows to scan.
     * </pre>
     *
     * <code>RANDOM_START = 2;</code>
     */
    public static final int RANDOM_START_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SampleMethod valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static SampleMethod forNumber(int value) {
      switch (value) {
        case 0:
          return SAMPLE_METHOD_UNSPECIFIED;
        case 1:
          return TOP;
        case 2:
          return RANDOM_START;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<SampleMethod> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<SampleMethod> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<SampleMethod>() {
          public SampleMethod findValueByNumber(int number) {
            return SampleMethod.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.privacy.dlp.v2.BigQueryOptions.getDescriptor().getEnumTypes().get(0);
    }

    private static final SampleMethod[] VALUES = values();

    public static SampleMethod valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private SampleMethod(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.privacy.dlp.v2.BigQueryOptions.SampleMethod)
  }

  private int bitField0_;
  public static final int TABLE_REFERENCE_FIELD_NUMBER = 1;
  private com.google.privacy.dlp.v2.BigQueryTable tableReference_;
  /**
   *
   *
   * <pre>
   * Complete BigQuery table reference.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.BigQueryTable table_reference = 1;</code>
   *
   * @return Whether the tableReference field is set.
   */
  @java.lang.Override
  public boolean hasTableReference() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Complete BigQuery table reference.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.BigQueryTable table_reference = 1;</code>
   *
   * @return The tableReference.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.BigQueryTable getTableReference() {
    return tableReference_ == null
        ? com.google.privacy.dlp.v2.BigQueryTable.getDefaultInstance()
        : tableReference_;
  }
  /**
   *
   *
   * <pre>
   * Complete BigQuery table reference.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.BigQueryTable table_reference = 1;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.BigQueryTableOrBuilder getTableReferenceOrBuilder() {
    return tableReference_ == null
        ? com.google.privacy.dlp.v2.BigQueryTable.getDefaultInstance()
        : tableReference_;
  }

  public static final int IDENTIFYING_FIELDS_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<com.google.privacy.dlp.v2.FieldId> identifyingFields_;
  /**
   *
   *
   * <pre>
   * Table fields that may uniquely identify a row within the table. When
   * `actions.saveFindings.outputConfig.table` is specified, the values of
   * columns specified here are available in the output table under
   * `location.content_locations.record_location.record_key.id_values`. Nested
   * fields such as `person.birthdate.year` are allowed.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.FieldId identifying_fields = 2;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.privacy.dlp.v2.FieldId> getIdentifyingFieldsList() {
    return identifyingFields_;
  }
  /**
   *
   *
   * <pre>
   * Table fields that may uniquely identify a row within the table. When
   * `actions.saveFindings.outputConfig.table` is specified, the values of
   * columns specified here are available in the output table under
   * `location.content_locations.record_location.record_key.id_values`. Nested
   * fields such as `person.birthdate.year` are allowed.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.FieldId identifying_fields = 2;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.privacy.dlp.v2.FieldIdOrBuilder>
      getIdentifyingFieldsOrBuilderList() {
    return identifyingFields_;
  }
  /**
   *
   *
   * <pre>
   * Table fields that may uniquely identify a row within the table. When
   * `actions.saveFindings.outputConfig.table` is specified, the values of
   * columns specified here are available in the output table under
   * `location.content_locations.record_location.record_key.id_values`. Nested
   * fields such as `person.birthdate.year` are allowed.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.FieldId identifying_fields = 2;</code>
   */
  @java.lang.Override
  public int getIdentifyingFieldsCount() {
    return identifyingFields_.size();
  }
  /**
   *
   *
   * <pre>
   * Table fields that may uniquely identify a row within the table. When
   * `actions.saveFindings.outputConfig.table` is specified, the values of
   * columns specified here are available in the output table under
   * `location.content_locations.record_location.record_key.id_values`. Nested
   * fields such as `person.birthdate.year` are allowed.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.FieldId identifying_fields = 2;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.FieldId getIdentifyingFields(int index) {
    return identifyingFields_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Table fields that may uniquely identify a row within the table. When
   * `actions.saveFindings.outputConfig.table` is specified, the values of
   * columns specified here are available in the output table under
   * `location.content_locations.record_location.record_key.id_values`. Nested
   * fields such as `person.birthdate.year` are allowed.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.FieldId identifying_fields = 2;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.FieldIdOrBuilder getIdentifyingFieldsOrBuilder(int index) {
    return identifyingFields_.get(index);
  }

  public static final int ROWS_LIMIT_FIELD_NUMBER = 3;
  private long rowsLimit_ = 0L;
  /**
   *
   *
   * <pre>
   * Max number of rows to scan. If the table has more rows than this value, the
   * rest of the rows are omitted. If not set, or if set to 0, all rows will be
   * scanned. Only one of rows_limit and rows_limit_percent can be specified.
   * Cannot be used in conjunction with TimespanConfig.
   * </pre>
   *
   * <code>int64 rows_limit = 3;</code>
   *
   * @return The rowsLimit.
   */
  @java.lang.Override
  public long getRowsLimit() {
    return rowsLimit_;
  }

  public static final int ROWS_LIMIT_PERCENT_FIELD_NUMBER = 6;
  private int rowsLimitPercent_ = 0;
  /**
   *
   *
   * <pre>
   * Max percentage of rows to scan. The rest are omitted. The number of rows
   * scanned is rounded down. Must be between 0 and 100, inclusively. Both 0 and
   * 100 means no limit. Defaults to 0. Only one of rows_limit and
   * rows_limit_percent can be specified. Cannot be used in conjunction with
   * TimespanConfig.
   *
   * Caution: A [known
   * issue](https://cloud.google.com/sensitive-data-protection/docs/known-issues#bq-sampling)
   * is causing the `rowsLimitPercent` field to behave unexpectedly. We
   * recommend using `rowsLimit` instead.
   * </pre>
   *
   * <code>int32 rows_limit_percent = 6;</code>
   *
   * @return The rowsLimitPercent.
   */
  @java.lang.Override
  public int getRowsLimitPercent() {
    return rowsLimitPercent_;
  }

  public static final int SAMPLE_METHOD_FIELD_NUMBER = 4;
  private int sampleMethod_ = 0;
  /**
   *
   *
   * <pre>
   * How to sample the data.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.BigQueryOptions.SampleMethod sample_method = 4;</code>
   *
   * @return The enum numeric value on the wire for sampleMethod.
   */
  @java.lang.Override
  public int getSampleMethodValue() {
    return sampleMethod_;
  }
  /**
   *
   *
   * <pre>
   * How to sample the data.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.BigQueryOptions.SampleMethod sample_method = 4;</code>
   *
   * @return The sampleMethod.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.BigQueryOptions.SampleMethod getSampleMethod() {
    com.google.privacy.dlp.v2.BigQueryOptions.SampleMethod result =
        com.google.privacy.dlp.v2.BigQueryOptions.SampleMethod.forNumber(sampleMethod_);
    return result == null
        ? com.google.privacy.dlp.v2.BigQueryOptions.SampleMethod.UNRECOGNIZED
        : result;
  }

  public static final int EXCLUDED_FIELDS_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private java.util.List<com.google.privacy.dlp.v2.FieldId> excludedFields_;
  /**
   *
   *
   * <pre>
   * References to fields excluded from scanning. This allows you to skip
   * inspection of entire columns which you know have no findings.
   * When inspecting a table, we recommend that you inspect all columns.
   * Otherwise, findings might be affected because hints from excluded columns
   * will not be used.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.FieldId excluded_fields = 5;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.privacy.dlp.v2.FieldId> getExcludedFieldsList() {
    return excludedFields_;
  }
  /**
   *
   *
   * <pre>
   * References to fields excluded from scanning. This allows you to skip
   * inspection of entire columns which you know have no findings.
   * When inspecting a table, we recommend that you inspect all columns.
   * Otherwise, findings might be affected because hints from excluded columns
   * will not be used.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.FieldId excluded_fields = 5;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.privacy.dlp.v2.FieldIdOrBuilder>
      getExcludedFieldsOrBuilderList() {
    return excludedFields_;
  }
  /**
   *
   *
   * <pre>
   * References to fields excluded from scanning. This allows you to skip
   * inspection of entire columns which you know have no findings.
   * When inspecting a table, we recommend that you inspect all columns.
   * Otherwise, findings might be affected because hints from excluded columns
   * will not be used.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.FieldId excluded_fields = 5;</code>
   */
  @java.lang.Override
  public int getExcludedFieldsCount() {
    return excludedFields_.size();
  }
  /**
   *
   *
   * <pre>
   * References to fields excluded from scanning. This allows you to skip
   * inspection of entire columns which you know have no findings.
   * When inspecting a table, we recommend that you inspect all columns.
   * Otherwise, findings might be affected because hints from excluded columns
   * will not be used.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.FieldId excluded_fields = 5;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.FieldId getExcludedFields(int index) {
    return excludedFields_.get(index);
  }
  /**
   *
   *
   * <pre>
   * References to fields excluded from scanning. This allows you to skip
   * inspection of entire columns which you know have no findings.
   * When inspecting a table, we recommend that you inspect all columns.
   * Otherwise, findings might be affected because hints from excluded columns
   * will not be used.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.FieldId excluded_fields = 5;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.FieldIdOrBuilder getExcludedFieldsOrBuilder(int index) {
    return excludedFields_.get(index);
  }

  public static final int INCLUDED_FIELDS_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private java.util.List<com.google.privacy.dlp.v2.FieldId> includedFields_;
  /**
   *
   *
   * <pre>
   * Limit scanning only to these fields.
   * When inspecting a table, we recommend that you inspect all columns.
   * Otherwise, findings might be affected because hints from excluded columns
   * will not be used.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.FieldId included_fields = 7;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.privacy.dlp.v2.FieldId> getIncludedFieldsList() {
    return includedFields_;
  }
  /**
   *
   *
   * <pre>
   * Limit scanning only to these fields.
   * When inspecting a table, we recommend that you inspect all columns.
   * Otherwise, findings might be affected because hints from excluded columns
   * will not be used.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.FieldId included_fields = 7;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.privacy.dlp.v2.FieldIdOrBuilder>
      getIncludedFieldsOrBuilderList() {
    return includedFields_;
  }
  /**
   *
   *
   * <pre>
   * Limit scanning only to these fields.
   * When inspecting a table, we recommend that you inspect all columns.
   * Otherwise, findings might be affected because hints from excluded columns
   * will not be used.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.FieldId included_fields = 7;</code>
   */
  @java.lang.Override
  public int getIncludedFieldsCount() {
    return includedFields_.size();
  }
  /**
   *
   *
   * <pre>
   * Limit scanning only to these fields.
   * When inspecting a table, we recommend that you inspect all columns.
   * Otherwise, findings might be affected because hints from excluded columns
   * will not be used.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.FieldId included_fields = 7;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.FieldId getIncludedFields(int index) {
    return includedFields_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Limit scanning only to these fields.
   * When inspecting a table, we recommend that you inspect all columns.
   * Otherwise, findings might be affected because hints from excluded columns
   * will not be used.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.FieldId included_fields = 7;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.FieldIdOrBuilder getIncludedFieldsOrBuilder(int index) {
    return includedFields_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getTableReference());
    }
    for (int i = 0; i < identifyingFields_.size(); i++) {
      output.writeMessage(2, identifyingFields_.get(i));
    }
    if (rowsLimit_ != 0L) {
      output.writeInt64(3, rowsLimit_);
    }
    if (sampleMethod_
        != com.google.privacy.dlp.v2.BigQueryOptions.SampleMethod.SAMPLE_METHOD_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(4, sampleMethod_);
    }
    for (int i = 0; i < excludedFields_.size(); i++) {
      output.writeMessage(5, excludedFields_.get(i));
    }
    if (rowsLimitPercent_ != 0) {
      output.writeInt32(6, rowsLimitPercent_);
    }
    for (int i = 0; i < includedFields_.size(); i++) {
      output.writeMessage(7, includedFields_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getTableReference());
    }
    for (int i = 0; i < identifyingFields_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(2, identifyingFields_.get(i));
    }
    if (rowsLimit_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(3, rowsLimit_);
    }
    if (sampleMethod_
        != com.google.privacy.dlp.v2.BigQueryOptions.SampleMethod.SAMPLE_METHOD_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, sampleMethod_);
    }
    for (int i = 0; i < excludedFields_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, excludedFields_.get(i));
    }
    if (rowsLimitPercent_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(6, rowsLimitPercent_);
    }
    for (int i = 0; i < includedFields_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, includedFields_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.privacy.dlp.v2.BigQueryOptions)) {
      return super.equals(obj);
    }
    com.google.privacy.dlp.v2.BigQueryOptions other =
        (com.google.privacy.dlp.v2.BigQueryOptions) obj;

    if (hasTableReference() != other.hasTableReference()) return false;
    if (hasTableReference()) {
      if (!getTableReference().equals(other.getTableReference())) return false;
    }
    if (!getIdentifyingFieldsList().equals(other.getIdentifyingFieldsList())) return false;
    if (getRowsLimit() != other.getRowsLimit()) return false;
    if (getRowsLimitPercent() != other.getRowsLimitPercent()) return false;
    if (sampleMethod_ != other.sampleMethod_) return false;
    if (!getExcludedFieldsList().equals(other.getExcludedFieldsList())) return false;
    if (!getIncludedFieldsList().equals(other.getIncludedFieldsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasTableReference()) {
      hash = (37 * hash) + TABLE_REFERENCE_FIELD_NUMBER;
      hash = (53 * hash) + getTableReference().hashCode();
    }
    if (getIdentifyingFieldsCount() > 0) {
      hash = (37 * hash) + IDENTIFYING_FIELDS_FIELD_NUMBER;
      hash = (53 * hash) + getIdentifyingFieldsList().hashCode();
    }
    hash = (37 * hash) + ROWS_LIMIT_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getRowsLimit());
    hash = (37 * hash) + ROWS_LIMIT_PERCENT_FIELD_NUMBER;
    hash = (53 * hash) + getRowsLimitPercent();
    hash = (37 * hash) + SAMPLE_METHOD_FIELD_NUMBER;
    hash = (53 * hash) + sampleMethod_;
    if (getExcludedFieldsCount() > 0) {
      hash = (37 * hash) + EXCLUDED_FIELDS_FIELD_NUMBER;
      hash = (53 * hash) + getExcludedFieldsList().hashCode();
    }
    if (getIncludedFieldsCount() > 0) {
      hash = (37 * hash) + INCLUDED_FIELDS_FIELD_NUMBER;
      hash = (53 * hash) + getIncludedFieldsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.privacy.dlp.v2.BigQueryOptions parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.BigQueryOptions parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.BigQueryOptions parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.BigQueryOptions parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.BigQueryOptions parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.BigQueryOptions parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.BigQueryOptions parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.BigQueryOptions parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.BigQueryOptions parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.BigQueryOptions parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.BigQueryOptions parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.BigQueryOptions parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.privacy.dlp.v2.BigQueryOptions prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Options defining BigQuery table and row identifiers.
   * </pre>
   *
   * Protobuf type {@code google.privacy.dlp.v2.BigQueryOptions}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.privacy.dlp.v2.BigQueryOptions)
      com.google.privacy.dlp.v2.BigQueryOptionsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.privacy.dlp.v2.DlpStorage
          .internal_static_google_privacy_dlp_v2_BigQueryOptions_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.privacy.dlp.v2.DlpStorage
          .internal_static_google_privacy_dlp_v2_BigQueryOptions_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.privacy.dlp.v2.BigQueryOptions.class,
              com.google.privacy.dlp.v2.BigQueryOptions.Builder.class);
    }

    // Construct using com.google.privacy.dlp.v2.BigQueryOptions.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getTableReferenceFieldBuilder();
        getIdentifyingFieldsFieldBuilder();
        getExcludedFieldsFieldBuilder();
        getIncludedFieldsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      tableReference_ = null;
      if (tableReferenceBuilder_ != null) {
        tableReferenceBuilder_.dispose();
        tableReferenceBuilder_ = null;
      }
      if (identifyingFieldsBuilder_ == null) {
        identifyingFields_ = java.util.Collections.emptyList();
      } else {
        identifyingFields_ = null;
        identifyingFieldsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      rowsLimit_ = 0L;
      rowsLimitPercent_ = 0;
      sampleMethod_ = 0;
      if (excludedFieldsBuilder_ == null) {
        excludedFields_ = java.util.Collections.emptyList();
      } else {
        excludedFields_ = null;
        excludedFieldsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000020);
      if (includedFieldsBuilder_ == null) {
        includedFields_ = java.util.Collections.emptyList();
      } else {
        includedFields_ = null;
        includedFieldsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000040);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.privacy.dlp.v2.DlpStorage
          .internal_static_google_privacy_dlp_v2_BigQueryOptions_descriptor;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.BigQueryOptions getDefaultInstanceForType() {
      return com.google.privacy.dlp.v2.BigQueryOptions.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.BigQueryOptions build() {
      com.google.privacy.dlp.v2.BigQueryOptions result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.BigQueryOptions buildPartial() {
      com.google.privacy.dlp.v2.BigQueryOptions result =
          new com.google.privacy.dlp.v2.BigQueryOptions(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.privacy.dlp.v2.BigQueryOptions result) {
      if (identifyingFieldsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          identifyingFields_ = java.util.Collections.unmodifiableList(identifyingFields_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.identifyingFields_ = identifyingFields_;
      } else {
        result.identifyingFields_ = identifyingFieldsBuilder_.build();
      }
      if (excludedFieldsBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)) {
          excludedFields_ = java.util.Collections.unmodifiableList(excludedFields_);
          bitField0_ = (bitField0_ & ~0x00000020);
        }
        result.excludedFields_ = excludedFields_;
      } else {
        result.excludedFields_ = excludedFieldsBuilder_.build();
      }
      if (includedFieldsBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)) {
          includedFields_ = java.util.Collections.unmodifiableList(includedFields_);
          bitField0_ = (bitField0_ & ~0x00000040);
        }
        result.includedFields_ = includedFields_;
      } else {
        result.includedFields_ = includedFieldsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.privacy.dlp.v2.BigQueryOptions result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.tableReference_ =
            tableReferenceBuilder_ == null ? tableReference_ : tableReferenceBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.rowsLimit_ = rowsLimit_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.rowsLimitPercent_ = rowsLimitPercent_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.sampleMethod_ = sampleMethod_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.privacy.dlp.v2.BigQueryOptions) {
        return mergeFrom((com.google.privacy.dlp.v2.BigQueryOptions) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.privacy.dlp.v2.BigQueryOptions other) {
      if (other == com.google.privacy.dlp.v2.BigQueryOptions.getDefaultInstance()) return this;
      if (other.hasTableReference()) {
        mergeTableReference(other.getTableReference());
      }
      if (identifyingFieldsBuilder_ == null) {
        if (!other.identifyingFields_.isEmpty()) {
          if (identifyingFields_.isEmpty()) {
            identifyingFields_ = other.identifyingFields_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureIdentifyingFieldsIsMutable();
            identifyingFields_.addAll(other.identifyingFields_);
          }
          onChanged();
        }
      } else {
        if (!other.identifyingFields_.isEmpty()) {
          if (identifyingFieldsBuilder_.isEmpty()) {
            identifyingFieldsBuilder_.dispose();
            identifyingFieldsBuilder_ = null;
            identifyingFields_ = other.identifyingFields_;
            bitField0_ = (bitField0_ & ~0x00000002);
            identifyingFieldsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getIdentifyingFieldsFieldBuilder()
                    : null;
          } else {
            identifyingFieldsBuilder_.addAllMessages(other.identifyingFields_);
          }
        }
      }
      if (other.getRowsLimit() != 0L) {
        setRowsLimit(other.getRowsLimit());
      }
      if (other.getRowsLimitPercent() != 0) {
        setRowsLimitPercent(other.getRowsLimitPercent());
      }
      if (other.sampleMethod_ != 0) {
        setSampleMethodValue(other.getSampleMethodValue());
      }
      if (excludedFieldsBuilder_ == null) {
        if (!other.excludedFields_.isEmpty()) {
          if (excludedFields_.isEmpty()) {
            excludedFields_ = other.excludedFields_;
            bitField0_ = (bitField0_ & ~0x00000020);
          } else {
            ensureExcludedFieldsIsMutable();
            excludedFields_.addAll(other.excludedFields_);
          }
          onChanged();
        }
      } else {
        if (!other.excludedFields_.isEmpty()) {
          if (excludedFieldsBuilder_.isEmpty()) {
            excludedFieldsBuilder_.dispose();
            excludedFieldsBuilder_ = null;
            excludedFields_ = other.excludedFields_;
            bitField0_ = (bitField0_ & ~0x00000020);
            excludedFieldsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getExcludedFieldsFieldBuilder()
                    : null;
          } else {
            excludedFieldsBuilder_.addAllMessages(other.excludedFields_);
          }
        }
      }
      if (includedFieldsBuilder_ == null) {
        if (!other.includedFields_.isEmpty()) {
          if (includedFields_.isEmpty()) {
            includedFields_ = other.includedFields_;
            bitField0_ = (bitField0_ & ~0x00000040);
          } else {
            ensureIncludedFieldsIsMutable();
            includedFields_.addAll(other.includedFields_);
          }
          onChanged();
        }
      } else {
        if (!other.includedFields_.isEmpty()) {
          if (includedFieldsBuilder_.isEmpty()) {
            includedFieldsBuilder_.dispose();
            includedFieldsBuilder_ = null;
            includedFields_ = other.includedFields_;
            bitField0_ = (bitField0_ & ~0x00000040);
            includedFieldsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getIncludedFieldsFieldBuilder()
                    : null;
          } else {
            includedFieldsBuilder_.addAllMessages(other.includedFields_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getTableReferenceFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                com.google.privacy.dlp.v2.FieldId m =
                    input.readMessage(
                        com.google.privacy.dlp.v2.FieldId.parser(), extensionRegistry);
                if (identifyingFieldsBuilder_ == null) {
                  ensureIdentifyingFieldsIsMutable();
                  identifyingFields_.add(m);
                } else {
                  identifyingFieldsBuilder_.addMessage(m);
                }
                break;
              } // case 18
            case 24:
              {
                rowsLimit_ = input.readInt64();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 32:
              {
                sampleMethod_ = input.readEnum();
                bitField0_ |= 0x00000010;
                break;
              } // case 32
            case 42:
              {
                com.google.privacy.dlp.v2.FieldId m =
                    input.readMessage(
                        com.google.privacy.dlp.v2.FieldId.parser(), extensionRegistry);
                if (excludedFieldsBuilder_ == null) {
                  ensureExcludedFieldsIsMutable();
                  excludedFields_.add(m);
                } else {
                  excludedFieldsBuilder_.addMessage(m);
                }
                break;
              } // case 42
            case 48:
              {
                rowsLimitPercent_ = input.readInt32();
                bitField0_ |= 0x00000008;
                break;
              } // case 48
            case 58:
              {
                com.google.privacy.dlp.v2.FieldId m =
                    input.readMessage(
                        com.google.privacy.dlp.v2.FieldId.parser(), extensionRegistry);
                if (includedFieldsBuilder_ == null) {
                  ensureIncludedFieldsIsMutable();
                  includedFields_.add(m);
                } else {
                  includedFieldsBuilder_.addMessage(m);
                }
                break;
              } // case 58
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.privacy.dlp.v2.BigQueryTable tableReference_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.BigQueryTable,
            com.google.privacy.dlp.v2.BigQueryTable.Builder,
            com.google.privacy.dlp.v2.BigQueryTableOrBuilder>
        tableReferenceBuilder_;
    /**
     *
     *
     * <pre>
     * Complete BigQuery table reference.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.BigQueryTable table_reference = 1;</code>
     *
     * @return Whether the tableReference field is set.
     */
    public boolean hasTableReference() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Complete BigQuery table reference.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.BigQueryTable table_reference = 1;</code>
     *
     * @return The tableReference.
     */
    public com.google.privacy.dlp.v2.BigQueryTable getTableReference() {
      if (tableReferenceBuilder_ == null) {
        return tableReference_ == null
            ? com.google.privacy.dlp.v2.BigQueryTable.getDefaultInstance()
            : tableReference_;
      } else {
        return tableReferenceBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Complete BigQuery table reference.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.BigQueryTable table_reference = 1;</code>
     */
    public Builder setTableReference(com.google.privacy.dlp.v2.BigQueryTable value) {
      if (tableReferenceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        tableReference_ = value;
      } else {
        tableReferenceBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Complete BigQuery table reference.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.BigQueryTable table_reference = 1;</code>
     */
    public Builder setTableReference(
        com.google.privacy.dlp.v2.BigQueryTable.Builder builderForValue) {
      if (tableReferenceBuilder_ == null) {
        tableReference_ = builderForValue.build();
      } else {
        tableReferenceBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Complete BigQuery table reference.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.BigQueryTable table_reference = 1;</code>
     */
    public Builder mergeTableReference(com.google.privacy.dlp.v2.BigQueryTable value) {
      if (tableReferenceBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && tableReference_ != null
            && tableReference_ != com.google.privacy.dlp.v2.BigQueryTable.getDefaultInstance()) {
          getTableReferenceBuilder().mergeFrom(value);
        } else {
          tableReference_ = value;
        }
      } else {
        tableReferenceBuilder_.mergeFrom(value);
      }
      if (tableReference_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Complete BigQuery table reference.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.BigQueryTable table_reference = 1;</code>
     */
    public Builder clearTableReference() {
      bitField0_ = (bitField0_ & ~0x00000001);
      tableReference_ = null;
      if (tableReferenceBuilder_ != null) {
        tableReferenceBuilder_.dispose();
        tableReferenceBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Complete BigQuery table reference.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.BigQueryTable table_reference = 1;</code>
     */
    public com.google.privacy.dlp.v2.BigQueryTable.Builder getTableReferenceBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getTableReferenceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Complete BigQuery table reference.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.BigQueryTable table_reference = 1;</code>
     */
    public com.google.privacy.dlp.v2.BigQueryTableOrBuilder getTableReferenceOrBuilder() {
      if (tableReferenceBuilder_ != null) {
        return tableReferenceBuilder_.getMessageOrBuilder();
      } else {
        return tableReference_ == null
            ? com.google.privacy.dlp.v2.BigQueryTable.getDefaultInstance()
            : tableReference_;
      }
    }
    /**
     *
     *
     * <pre>
     * Complete BigQuery table reference.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.BigQueryTable table_reference = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.BigQueryTable,
            com.google.privacy.dlp.v2.BigQueryTable.Builder,
            com.google.privacy.dlp.v2.BigQueryTableOrBuilder>
        getTableReferenceFieldBuilder() {
      if (tableReferenceBuilder_ == null) {
        tableReferenceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.BigQueryTable,
                com.google.privacy.dlp.v2.BigQueryTable.Builder,
                com.google.privacy.dlp.v2.BigQueryTableOrBuilder>(
                getTableReference(), getParentForChildren(), isClean());
        tableReference_ = null;
      }
      return tableReferenceBuilder_;
    }

    private java.util.List<com.google.privacy.dlp.v2.FieldId> identifyingFields_ =
        java.util.Collections.emptyList();

    private void ensureIdentifyingFieldsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        identifyingFields_ =
            new java.util.ArrayList<com.google.privacy.dlp.v2.FieldId>(identifyingFields_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.privacy.dlp.v2.FieldId,
            com.google.privacy.dlp.v2.FieldId.Builder,
            com.google.privacy.dlp.v2.FieldIdOrBuilder>
        identifyingFieldsBuilder_;

    /**
     *
     *
     * <pre>
     * Table fields that may uniquely identify a row within the table. When
     * `actions.saveFindings.outputConfig.table` is specified, the values of
     * columns specified here are available in the output table under
     * `location.content_locations.record_location.record_key.id_values`. Nested
     * fields such as `person.birthdate.year` are allowed.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.FieldId identifying_fields = 2;</code>
     */
    public java.util.List<com.google.privacy.dlp.v2.FieldId> getIdentifyingFieldsList() {
      if (identifyingFieldsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(identifyingFields_);
      } else {
        return identifyingFieldsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Table fields that may uniquely identify a row within the table. When
     * `actions.saveFindings.outputConfig.table` is specified, the values of
     * columns specified here are available in the output table under
     * `location.content_locations.record_location.record_key.id_values`. Nested
     * fields such as `person.birthdate.year` are allowed.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.FieldId identifying_fields = 2;</code>
     */
    public int getIdentifyingFieldsCount() {
      if (identifyingFieldsBuilder_ == null) {
        return identifyingFields_.size();
      } else {
        return identifyingFieldsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Table fields that may uniquely identify a row within the table. When
     * `actions.saveFindings.outputConfig.table` is specified, the values of
     * columns specified here are available in the output table under
     * `location.content_locations.record_location.record_key.id_values`. Nested
     * fields such as `person.birthdate.year` are allowed.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.FieldId identifying_fields = 2;</code>
     */
    public com.google.privacy.dlp.v2.FieldId getIdentifyingFields(int index) {
      if (identifyingFieldsBuilder_ == null) {
        return identifyingFields_.get(index);
      } else {
        return identifyingFieldsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Table fields that may uniquely identify a row within the table. When
     * `actions.saveFindings.outputConfig.table` is specified, the values of
     * columns specified here are available in the output table under
     * `location.content_locations.record_location.record_key.id_values`. Nested
     * fields such as `person.birthdate.year` are allowed.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.FieldId identifying_fields = 2;</code>
     */
    public Builder setIdentifyingFields(int index, com.google.privacy.dlp.v2.FieldId value) {
      if (identifyingFieldsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureIdentifyingFieldsIsMutable();
        identifyingFields_.set(index, value);
        onChanged();
      } else {
        identifyingFieldsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Table fields that may uniquely identify a row within the table. When
     * `actions.saveFindings.outputConfig.table` is specified, the values of
     * columns specified here are available in the output table under
     * `location.content_locations.record_location.record_key.id_values`. Nested
     * fields such as `person.birthdate.year` are allowed.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.FieldId identifying_fields = 2;</code>
     */
    public Builder setIdentifyingFields(
        int index, com.google.privacy.dlp.v2.FieldId.Builder builderForValue) {
      if (identifyingFieldsBuilder_ == null) {
        ensureIdentifyingFieldsIsMutable();
        identifyingFields_.set(index, builderForValue.build());
        onChanged();
      } else {
        identifyingFieldsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Table fields that may uniquely identify a row within the table. When
     * `actions.saveFindings.outputConfig.table` is specified, the values of
     * columns specified here are available in the output table under
     * `location.content_locations.record_location.record_key.id_values`. Nested
     * fields such as `person.birthdate.year` are allowed.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.FieldId identifying_fields = 2;</code>
     */
    public Builder addIdentifyingFields(com.google.privacy.dlp.v2.FieldId value) {
      if (identifyingFieldsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureIdentifyingFieldsIsMutable();
        identifyingFields_.add(value);
        onChanged();
      } else {
        identifyingFieldsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Table fields that may uniquely identify a row within the table. When
     * `actions.saveFindings.outputConfig.table` is specified, the values of
     * columns specified here are available in the output table under
     * `location.content_locations.record_location.record_key.id_values`. Nested
     * fields such as `person.birthdate.year` are allowed.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.FieldId identifying_fields = 2;</code>
     */
    public Builder addIdentifyingFields(int index, com.google.privacy.dlp.v2.FieldId value) {
      if (identifyingFieldsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureIdentifyingFieldsIsMutable();
        identifyingFields_.add(index, value);
        onChanged();
      } else {
        identifyingFieldsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Table fields that may uniquely identify a row within the table. When
     * `actions.saveFindings.outputConfig.table` is specified, the values of
     * columns specified here are available in the output table under
     * `location.content_locations.record_location.record_key.id_values`. Nested
     * fields such as `person.birthdate.year` are allowed.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.FieldId identifying_fields = 2;</code>
     */
    public Builder addIdentifyingFields(com.google.privacy.dlp.v2.FieldId.Builder builderForValue) {
      if (identifyingFieldsBuilder_ == null) {
        ensureIdentifyingFieldsIsMutable();
        identifyingFields_.add(builderForValue.build());
        onChanged();
      } else {
        identifyingFieldsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Table fields that may uniquely identify a row within the table. When
     * `actions.saveFindings.outputConfig.table` is specified, the values of
     * columns specified here are available in the output table under
     * `location.content_locations.record_location.record_key.id_values`. Nested
     * fields such as `person.birthdate.year` are allowed.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.FieldId identifying_fields = 2;</code>
     */
    public Builder addIdentifyingFields(
        int index, com.google.privacy.dlp.v2.FieldId.Builder builderForValue) {
      if (identifyingFieldsBuilder_ == null) {
        ensureIdentifyingFieldsIsMutable();
        identifyingFields_.add(index, builderForValue.build());
        onChanged();
      } else {
        identifyingFieldsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Table fields that may uniquely identify a row within the table. When
     * `actions.saveFindings.outputConfig.table` is specified, the values of
     * columns specified here are available in the output table under
     * `location.content_locations.record_location.record_key.id_values`. Nested
     * fields such as `person.birthdate.year` are allowed.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.FieldId identifying_fields = 2;</code>
     */
    public Builder addAllIdentifyingFields(
        java.lang.Iterable<? extends com.google.privacy.dlp.v2.FieldId> values) {
      if (identifyingFieldsBuilder_ == null) {
        ensureIdentifyingFieldsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, identifyingFields_);
        onChanged();
      } else {
        identifyingFieldsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Table fields that may uniquely identify a row within the table. When
     * `actions.saveFindings.outputConfig.table` is specified, the values of
     * columns specified here are available in the output table under
     * `location.content_locations.record_location.record_key.id_values`. Nested
     * fields such as `person.birthdate.year` are allowed.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.FieldId identifying_fields = 2;</code>
     */
    public Builder clearIdentifyingFields() {
      if (identifyingFieldsBuilder_ == null) {
        identifyingFields_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        identifyingFieldsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Table fields that may uniquely identify a row within the table. When
     * `actions.saveFindings.outputConfig.table` is specified, the values of
     * columns specified here are available in the output table under
     * `location.content_locations.record_location.record_key.id_values`. Nested
     * fields such as `person.birthdate.year` are allowed.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.FieldId identifying_fields = 2;</code>
     */
    public Builder removeIdentifyingFields(int index) {
      if (identifyingFieldsBuilder_ == null) {
        ensureIdentifyingFieldsIsMutable();
        identifyingFields_.remove(index);
        onChanged();
      } else {
        identifyingFieldsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Table fields that may uniquely identify a row within the table. When
     * `actions.saveFindings.outputConfig.table` is specified, the values of
     * columns specified here are available in the output table under
     * `location.content_locations.record_location.record_key.id_values`. Nested
     * fields such as `person.birthdate.year` are allowed.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.FieldId identifying_fields = 2;</code>
     */
    public com.google.privacy.dlp.v2.FieldId.Builder getIdentifyingFieldsBuilder(int index) {
      return getIdentifyingFieldsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Table fields that may uniquely identify a row within the table. When
     * `actions.saveFindings.outputConfig.table` is specified, the values of
     * columns specified here are available in the output table under
     * `location.content_locations.record_location.record_key.id_values`. Nested
     * fields such as `person.birthdate.year` are allowed.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.FieldId identifying_fields = 2;</code>
     */
    public com.google.privacy.dlp.v2.FieldIdOrBuilder getIdentifyingFieldsOrBuilder(int index) {
      if (identifyingFieldsBuilder_ == null) {
        return identifyingFields_.get(index);
      } else {
        return identifyingFieldsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Table fields that may uniquely identify a row within the table. When
     * `actions.saveFindings.outputConfig.table` is specified, the values of
     * columns specified here are available in the output table under
     * `location.content_locations.record_location.record_key.id_values`. Nested
     * fields such as `person.birthdate.year` are allowed.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.FieldId identifying_fields = 2;</code>
     */
    public java.util.List<? extends com.google.privacy.dlp.v2.FieldIdOrBuilder>
        getIdentifyingFieldsOrBuilderList() {
      if (identifyingFieldsBuilder_ != null) {
        return identifyingFieldsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(identifyingFields_);
      }
    }
    /**
     *
     *
     * <pre>
     * Table fields that may uniquely identify a row within the table. When
     * `actions.saveFindings.outputConfig.table` is specified, the values of
     * columns specified here are available in the output table under
     * `location.content_locations.record_location.record_key.id_values`. Nested
     * fields such as `person.birthdate.year` are allowed.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.FieldId identifying_fields = 2;</code>
     */
    public com.google.privacy.dlp.v2.FieldId.Builder addIdentifyingFieldsBuilder() {
      return getIdentifyingFieldsFieldBuilder()
          .addBuilder(com.google.privacy.dlp.v2.FieldId.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Table fields that may uniquely identify a row within the table. When
     * `actions.saveFindings.outputConfig.table` is specified, the values of
     * columns specified here are available in the output table under
     * `location.content_locations.record_location.record_key.id_values`. Nested
     * fields such as `person.birthdate.year` are allowed.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.FieldId identifying_fields = 2;</code>
     */
    public com.google.privacy.dlp.v2.FieldId.Builder addIdentifyingFieldsBuilder(int index) {
      return getIdentifyingFieldsFieldBuilder()
          .addBuilder(index, com.google.privacy.dlp.v2.FieldId.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Table fields that may uniquely identify a row within the table. When
     * `actions.saveFindings.outputConfig.table` is specified, the values of
     * columns specified here are available in the output table under
     * `location.content_locations.record_location.record_key.id_values`. Nested
     * fields such as `person.birthdate.year` are allowed.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.FieldId identifying_fields = 2;</code>
     */
    public java.util.List<com.google.privacy.dlp.v2.FieldId.Builder>
        getIdentifyingFieldsBuilderList() {
      return getIdentifyingFieldsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.privacy.dlp.v2.FieldId,
            com.google.privacy.dlp.v2.FieldId.Builder,
            com.google.privacy.dlp.v2.FieldIdOrBuilder>
        getIdentifyingFieldsFieldBuilder() {
      if (identifyingFieldsBuilder_ == null) {
        identifyingFieldsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.privacy.dlp.v2.FieldId,
                com.google.privacy.dlp.v2.FieldId.Builder,
                com.google.privacy.dlp.v2.FieldIdOrBuilder>(
                identifyingFields_,
                ((bitField0_ & 0x00000002) != 0),
                getParentForChildren(),
                isClean());
        identifyingFields_ = null;
      }
      return identifyingFieldsBuilder_;
    }

    private long rowsLimit_;
    /**
     *
     *
     * <pre>
     * Max number of rows to scan. If the table has more rows than this value, the
     * rest of the rows are omitted. If not set, or if set to 0, all rows will be
     * scanned. Only one of rows_limit and rows_limit_percent can be specified.
     * Cannot be used in conjunction with TimespanConfig.
     * </pre>
     *
     * <code>int64 rows_limit = 3;</code>
     *
     * @return The rowsLimit.
     */
    @java.lang.Override
    public long getRowsLimit() {
      return rowsLimit_;
    }
    /**
     *
     *
     * <pre>
     * Max number of rows to scan. If the table has more rows than this value, the
     * rest of the rows are omitted. If not set, or if set to 0, all rows will be
     * scanned. Only one of rows_limit and rows_limit_percent can be specified.
     * Cannot be used in conjunction with TimespanConfig.
     * </pre>
     *
     * <code>int64 rows_limit = 3;</code>
     *
     * @param value The rowsLimit to set.
     * @return This builder for chaining.
     */
    public Builder setRowsLimit(long value) {

      rowsLimit_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Max number of rows to scan. If the table has more rows than this value, the
     * rest of the rows are omitted. If not set, or if set to 0, all rows will be
     * scanned. Only one of rows_limit and rows_limit_percent can be specified.
     * Cannot be used in conjunction with TimespanConfig.
     * </pre>
     *
     * <code>int64 rows_limit = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRowsLimit() {
      bitField0_ = (bitField0_ & ~0x00000004);
      rowsLimit_ = 0L;
      onChanged();
      return this;
    }

    private int rowsLimitPercent_;
    /**
     *
     *
     * <pre>
     * Max percentage of rows to scan. The rest are omitted. The number of rows
     * scanned is rounded down. Must be between 0 and 100, inclusively. Both 0 and
     * 100 means no limit. Defaults to 0. Only one of rows_limit and
     * rows_limit_percent can be specified. Cannot be used in conjunction with
     * TimespanConfig.
     *
     * Caution: A [known
     * issue](https://cloud.google.com/sensitive-data-protection/docs/known-issues#bq-sampling)
     * is causing the `rowsLimitPercent` field to behave unexpectedly. We
     * recommend using `rowsLimit` instead.
     * </pre>
     *
     * <code>int32 rows_limit_percent = 6;</code>
     *
     * @return The rowsLimitPercent.
     */
    @java.lang.Override
    public int getRowsLimitPercent() {
      return rowsLimitPercent_;
    }
    /**
     *
     *
     * <pre>
     * Max percentage of rows to scan. The rest are omitted. The number of rows
     * scanned is rounded down. Must be between 0 and 100, inclusively. Both 0 and
     * 100 means no limit. Defaults to 0. Only one of rows_limit and
     * rows_limit_percent can be specified. Cannot be used in conjunction with
     * TimespanConfig.
     *
     * Caution: A [known
     * issue](https://cloud.google.com/sensitive-data-protection/docs/known-issues#bq-sampling)
     * is causing the `rowsLimitPercent` field to behave unexpectedly. We
     * recommend using `rowsLimit` instead.
     * </pre>
     *
     * <code>int32 rows_limit_percent = 6;</code>
     *
     * @param value The rowsLimitPercent to set.
     * @return This builder for chaining.
     */
    public Builder setRowsLimitPercent(int value) {

      rowsLimitPercent_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Max percentage of rows to scan. The rest are omitted. The number of rows
     * scanned is rounded down. Must be between 0 and 100, inclusively. Both 0 and
     * 100 means no limit. Defaults to 0. Only one of rows_limit and
     * rows_limit_percent can be specified. Cannot be used in conjunction with
     * TimespanConfig.
     *
     * Caution: A [known
     * issue](https://cloud.google.com/sensitive-data-protection/docs/known-issues#bq-sampling)
     * is causing the `rowsLimitPercent` field to behave unexpectedly. We
     * recommend using `rowsLimit` instead.
     * </pre>
     *
     * <code>int32 rows_limit_percent = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRowsLimitPercent() {
      bitField0_ = (bitField0_ & ~0x00000008);
      rowsLimitPercent_ = 0;
      onChanged();
      return this;
    }

    private int sampleMethod_ = 0;
    /**
     *
     *
     * <pre>
     * How to sample the data.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.BigQueryOptions.SampleMethod sample_method = 4;</code>
     *
     * @return The enum numeric value on the wire for sampleMethod.
     */
    @java.lang.Override
    public int getSampleMethodValue() {
      return sampleMethod_;
    }
    /**
     *
     *
     * <pre>
     * How to sample the data.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.BigQueryOptions.SampleMethod sample_method = 4;</code>
     *
     * @param value The enum numeric value on the wire for sampleMethod to set.
     * @return This builder for chaining.
     */
    public Builder setSampleMethodValue(int value) {
      sampleMethod_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * How to sample the data.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.BigQueryOptions.SampleMethod sample_method = 4;</code>
     *
     * @return The sampleMethod.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.BigQueryOptions.SampleMethod getSampleMethod() {
      com.google.privacy.dlp.v2.BigQueryOptions.SampleMethod result =
          com.google.privacy.dlp.v2.BigQueryOptions.SampleMethod.forNumber(sampleMethod_);
      return result == null
          ? com.google.privacy.dlp.v2.BigQueryOptions.SampleMethod.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * How to sample the data.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.BigQueryOptions.SampleMethod sample_method = 4;</code>
     *
     * @param value The sampleMethod to set.
     * @return This builder for chaining.
     */
    public Builder setSampleMethod(com.google.privacy.dlp.v2.BigQueryOptions.SampleMethod value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000010;
      sampleMethod_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * How to sample the data.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.BigQueryOptions.SampleMethod sample_method = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSampleMethod() {
      bitField0_ = (bitField0_ & ~0x00000010);
      sampleMethod_ = 0;
      onChanged();
      return this;
    }

    private java.util.List<com.google.privacy.dlp.v2.FieldId> excludedFields_ =
        java.util.Collections.emptyList();

    private void ensureExcludedFieldsIsMutable() {
      if (!((bitField0_ & 0x00000020) != 0)) {
        excludedFields_ =
            new java.util.ArrayList<com.google.privacy.dlp.v2.FieldId>(excludedFields_);
        bitField0_ |= 0x00000020;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.privacy.dlp.v2.FieldId,
            com.google.privacy.dlp.v2.FieldId.Builder,
            com.google.privacy.dlp.v2.FieldIdOrBuilder>
        excludedFieldsBuilder_;

    /**
     *
     *
     * <pre>
     * References to fields excluded from scanning. This allows you to skip
     * inspection of entire columns which you know have no findings.
     * When inspecting a table, we recommend that you inspect all columns.
     * Otherwise, findings might be affected because hints from excluded columns
     * will not be used.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.FieldId excluded_fields = 5;</code>
     */
    public java.util.List<com.google.privacy.dlp.v2.FieldId> getExcludedFieldsList() {
      if (excludedFieldsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(excludedFields_);
      } else {
        return excludedFieldsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * References to fields excluded from scanning. This allows you to skip
     * inspection of entire columns which you know have no findings.
     * When inspecting a table, we recommend that you inspect all columns.
     * Otherwise, findings might be affected because hints from excluded columns
     * will not be used.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.FieldId excluded_fields = 5;</code>
     */
    public int getExcludedFieldsCount() {
      if (excludedFieldsBuilder_ == null) {
        return excludedFields_.size();
      } else {
        return excludedFieldsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * References to fields excluded from scanning. This allows you to skip
     * inspection of entire columns which you know have no findings.
     * When inspecting a table, we recommend that you inspect all columns.
     * Otherwise, findings might be affected because hints from excluded columns
     * will not be used.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.FieldId excluded_fields = 5;</code>
     */
    public com.google.privacy.dlp.v2.FieldId getExcludedFields(int index) {
      if (excludedFieldsBuilder_ == null) {
        return excludedFields_.get(index);
      } else {
        return excludedFieldsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * References to fields excluded from scanning. This allows you to skip
     * inspection of entire columns which you know have no findings.
     * When inspecting a table, we recommend that you inspect all columns.
     * Otherwise, findings might be affected because hints from excluded columns
     * will not be used.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.FieldId excluded_fields = 5;</code>
     */
    public Builder setExcludedFields(int index, com.google.privacy.dlp.v2.FieldId value) {
      if (excludedFieldsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureExcludedFieldsIsMutable();
        excludedFields_.set(index, value);
        onChanged();
      } else {
        excludedFieldsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * References to fields excluded from scanning. This allows you to skip
     * inspection of entire columns which you know have no findings.
     * When inspecting a table, we recommend that you inspect all columns.
     * Otherwise, findings might be affected because hints from excluded columns
     * will not be used.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.FieldId excluded_fields = 5;</code>
     */
    public Builder setExcludedFields(
        int index, com.google.privacy.dlp.v2.FieldId.Builder builderForValue) {
      if (excludedFieldsBuilder_ == null) {
        ensureExcludedFieldsIsMutable();
        excludedFields_.set(index, builderForValue.build());
        onChanged();
      } else {
        excludedFieldsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * References to fields excluded from scanning. This allows you to skip
     * inspection of entire columns which you know have no findings.
     * When inspecting a table, we recommend that you inspect all columns.
     * Otherwise, findings might be affected because hints from excluded columns
     * will not be used.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.FieldId excluded_fields = 5;</code>
     */
    public Builder addExcludedFields(com.google.privacy.dlp.v2.FieldId value) {
      if (excludedFieldsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureExcludedFieldsIsMutable();
        excludedFields_.add(value);
        onChanged();
      } else {
        excludedFieldsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * References to fields excluded from scanning. This allows you to skip
     * inspection of entire columns which you know have no findings.
     * When inspecting a table, we recommend that you inspect all columns.
     * Otherwise, findings might be affected because hints from excluded columns
     * will not be used.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.FieldId excluded_fields = 5;</code>
     */
    public Builder addExcludedFields(int index, com.google.privacy.dlp.v2.FieldId value) {
      if (excludedFieldsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureExcludedFieldsIsMutable();
        excludedFields_.add(index, value);
        onChanged();
      } else {
        excludedFieldsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * References to fields excluded from scanning. This allows you to skip
     * inspection of entire columns which you know have no findings.
     * When inspecting a table, we recommend that you inspect all columns.
     * Otherwise, findings might be affected because hints from excluded columns
     * will not be used.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.FieldId excluded_fields = 5;</code>
     */
    public Builder addExcludedFields(com.google.privacy.dlp.v2.FieldId.Builder builderForValue) {
      if (excludedFieldsBuilder_ == null) {
        ensureExcludedFieldsIsMutable();
        excludedFields_.add(builderForValue.build());
        onChanged();
      } else {
        excludedFieldsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * References to fields excluded from scanning. This allows you to skip
     * inspection of entire columns which you know have no findings.
     * When inspecting a table, we recommend that you inspect all columns.
     * Otherwise, findings might be affected because hints from excluded columns
     * will not be used.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.FieldId excluded_fields = 5;</code>
     */
    public Builder addExcludedFields(
        int index, com.google.privacy.dlp.v2.FieldId.Builder builderForValue) {
      if (excludedFieldsBuilder_ == null) {
        ensureExcludedFieldsIsMutable();
        excludedFields_.add(index, builderForValue.build());
        onChanged();
      } else {
        excludedFieldsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * References to fields excluded from scanning. This allows you to skip
     * inspection of entire columns which you know have no findings.
     * When inspecting a table, we recommend that you inspect all columns.
     * Otherwise, findings might be affected because hints from excluded columns
     * will not be used.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.FieldId excluded_fields = 5;</code>
     */
    public Builder addAllExcludedFields(
        java.lang.Iterable<? extends com.google.privacy.dlp.v2.FieldId> values) {
      if (excludedFieldsBuilder_ == null) {
        ensureExcludedFieldsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, excludedFields_);
        onChanged();
      } else {
        excludedFieldsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * References to fields excluded from scanning. This allows you to skip
     * inspection of entire columns which you know have no findings.
     * When inspecting a table, we recommend that you inspect all columns.
     * Otherwise, findings might be affected because hints from excluded columns
     * will not be used.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.FieldId excluded_fields = 5;</code>
     */
    public Builder clearExcludedFields() {
      if (excludedFieldsBuilder_ == null) {
        excludedFields_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000020);
        onChanged();
      } else {
        excludedFieldsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * References to fields excluded from scanning. This allows you to skip
     * inspection of entire columns which you know have no findings.
     * When inspecting a table, we recommend that you inspect all columns.
     * Otherwise, findings might be affected because hints from excluded columns
     * will not be used.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.FieldId excluded_fields = 5;</code>
     */
    public Builder removeExcludedFields(int index) {
      if (excludedFieldsBuilder_ == null) {
        ensureExcludedFieldsIsMutable();
        excludedFields_.remove(index);
        onChanged();
      } else {
        excludedFieldsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * References to fields excluded from scanning. This allows you to skip
     * inspection of entire columns which you know have no findings.
     * When inspecting a table, we recommend that you inspect all columns.
     * Otherwise, findings might be affected because hints from excluded columns
     * will not be used.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.FieldId excluded_fields = 5;</code>
     */
    public com.google.privacy.dlp.v2.FieldId.Builder getExcludedFieldsBuilder(int index) {
      return getExcludedFieldsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * References to fields excluded from scanning. This allows you to skip
     * inspection of entire columns which you know have no findings.
     * When inspecting a table, we recommend that you inspect all columns.
     * Otherwise, findings might be affected because hints from excluded columns
     * will not be used.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.FieldId excluded_fields = 5;</code>
     */
    public com.google.privacy.dlp.v2.FieldIdOrBuilder getExcludedFieldsOrBuilder(int index) {
      if (excludedFieldsBuilder_ == null) {
        return excludedFields_.get(index);
      } else {
        return excludedFieldsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * References to fields excluded from scanning. This allows you to skip
     * inspection of entire columns which you know have no findings.
     * When inspecting a table, we recommend that you inspect all columns.
     * Otherwise, findings might be affected because hints from excluded columns
     * will not be used.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.FieldId excluded_fields = 5;</code>
     */
    public java.util.List<? extends com.google.privacy.dlp.v2.FieldIdOrBuilder>
        getExcludedFieldsOrBuilderList() {
      if (excludedFieldsBuilder_ != null) {
        return excludedFieldsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(excludedFields_);
      }
    }
    /**
     *
     *
     * <pre>
     * References to fields excluded from scanning. This allows you to skip
     * inspection of entire columns which you know have no findings.
     * When inspecting a table, we recommend that you inspect all columns.
     * Otherwise, findings might be affected because hints from excluded columns
     * will not be used.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.FieldId excluded_fields = 5;</code>
     */
    public com.google.privacy.dlp.v2.FieldId.Builder addExcludedFieldsBuilder() {
      return getExcludedFieldsFieldBuilder()
          .addBuilder(com.google.privacy.dlp.v2.FieldId.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * References to fields excluded from scanning. This allows you to skip
     * inspection of entire columns which you know have no findings.
     * When inspecting a table, we recommend that you inspect all columns.
     * Otherwise, findings might be affected because hints from excluded columns
     * will not be used.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.FieldId excluded_fields = 5;</code>
     */
    public com.google.privacy.dlp.v2.FieldId.Builder addExcludedFieldsBuilder(int index) {
      return getExcludedFieldsFieldBuilder()
          .addBuilder(index, com.google.privacy.dlp.v2.FieldId.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * References to fields excluded from scanning. This allows you to skip
     * inspection of entire columns which you know have no findings.
     * When inspecting a table, we recommend that you inspect all columns.
     * Otherwise, findings might be affected because hints from excluded columns
     * will not be used.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.FieldId excluded_fields = 5;</code>
     */
    public java.util.List<com.google.privacy.dlp.v2.FieldId.Builder>
        getExcludedFieldsBuilderList() {
      return getExcludedFieldsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.privacy.dlp.v2.FieldId,
            com.google.privacy.dlp.v2.FieldId.Builder,
            com.google.privacy.dlp.v2.FieldIdOrBuilder>
        getExcludedFieldsFieldBuilder() {
      if (excludedFieldsBuilder_ == null) {
        excludedFieldsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.privacy.dlp.v2.FieldId,
                com.google.privacy.dlp.v2.FieldId.Builder,
                com.google.privacy.dlp.v2.FieldIdOrBuilder>(
                excludedFields_,
                ((bitField0_ & 0x00000020) != 0),
                getParentForChildren(),
                isClean());
        excludedFields_ = null;
      }
      return excludedFieldsBuilder_;
    }

    private java.util.List<com.google.privacy.dlp.v2.FieldId> includedFields_ =
        java.util.Collections.emptyList();

    private void ensureIncludedFieldsIsMutable() {
      if (!((bitField0_ & 0x00000040) != 0)) {
        includedFields_ =
            new java.util.ArrayList<com.google.privacy.dlp.v2.FieldId>(includedFields_);
        bitField0_ |= 0x00000040;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.privacy.dlp.v2.FieldId,
            com.google.privacy.dlp.v2.FieldId.Builder,
            com.google.privacy.dlp.v2.FieldIdOrBuilder>
        includedFieldsBuilder_;

    /**
     *
     *
     * <pre>
     * Limit scanning only to these fields.
     * When inspecting a table, we recommend that you inspect all columns.
     * Otherwise, findings might be affected because hints from excluded columns
     * will not be used.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.FieldId included_fields = 7;</code>
     */
    public java.util.List<com.google.privacy.dlp.v2.FieldId> getIncludedFieldsList() {
      if (includedFieldsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(includedFields_);
      } else {
        return includedFieldsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Limit scanning only to these fields.
     * When inspecting a table, we recommend that you inspect all columns.
     * Otherwise, findings might be affected because hints from excluded columns
     * will not be used.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.FieldId included_fields = 7;</code>
     */
    public int getIncludedFieldsCount() {
      if (includedFieldsBuilder_ == null) {
        return includedFields_.size();
      } else {
        return includedFieldsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Limit scanning only to these fields.
     * When inspecting a table, we recommend that you inspect all columns.
     * Otherwise, findings might be affected because hints from excluded columns
     * will not be used.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.FieldId included_fields = 7;</code>
     */
    public com.google.privacy.dlp.v2.FieldId getIncludedFields(int index) {
      if (includedFieldsBuilder_ == null) {
        return includedFields_.get(index);
      } else {
        return includedFieldsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Limit scanning only to these fields.
     * When inspecting a table, we recommend that you inspect all columns.
     * Otherwise, findings might be affected because hints from excluded columns
     * will not be used.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.FieldId included_fields = 7;</code>
     */
    public Builder setIncludedFields(int index, com.google.privacy.dlp.v2.FieldId value) {
      if (includedFieldsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureIncludedFieldsIsMutable();
        includedFields_.set(index, value);
        onChanged();
      } else {
        includedFieldsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Limit scanning only to these fields.
     * When inspecting a table, we recommend that you inspect all columns.
     * Otherwise, findings might be affected because hints from excluded columns
     * will not be used.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.FieldId included_fields = 7;</code>
     */
    public Builder setIncludedFields(
        int index, com.google.privacy.dlp.v2.FieldId.Builder builderForValue) {
      if (includedFieldsBuilder_ == null) {
        ensureIncludedFieldsIsMutable();
        includedFields_.set(index, builderForValue.build());
        onChanged();
      } else {
        includedFieldsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Limit scanning only to these fields.
     * When inspecting a table, we recommend that you inspect all columns.
     * Otherwise, findings might be affected because hints from excluded columns
     * will not be used.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.FieldId included_fields = 7;</code>
     */
    public Builder addIncludedFields(com.google.privacy.dlp.v2.FieldId value) {
      if (includedFieldsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureIncludedFieldsIsMutable();
        includedFields_.add(value);
        onChanged();
      } else {
        includedFieldsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Limit scanning only to these fields.
     * When inspecting a table, we recommend that you inspect all columns.
     * Otherwise, findings might be affected because hints from excluded columns
     * will not be used.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.FieldId included_fields = 7;</code>
     */
    public Builder addIncludedFields(int index, com.google.privacy.dlp.v2.FieldId value) {
      if (includedFieldsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureIncludedFieldsIsMutable();
        includedFields_.add(index, value);
        onChanged();
      } else {
        includedFieldsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Limit scanning only to these fields.
     * When inspecting a table, we recommend that you inspect all columns.
     * Otherwise, findings might be affected because hints from excluded columns
     * will not be used.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.FieldId included_fields = 7;</code>
     */
    public Builder addIncludedFields(com.google.privacy.dlp.v2.FieldId.Builder builderForValue) {
      if (includedFieldsBuilder_ == null) {
        ensureIncludedFieldsIsMutable();
        includedFields_.add(builderForValue.build());
        onChanged();
      } else {
        includedFieldsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Limit scanning only to these fields.
     * When inspecting a table, we recommend that you inspect all columns.
     * Otherwise, findings might be affected because hints from excluded columns
     * will not be used.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.FieldId included_fields = 7;</code>
     */
    public Builder addIncludedFields(
        int index, com.google.privacy.dlp.v2.FieldId.Builder builderForValue) {
      if (includedFieldsBuilder_ == null) {
        ensureIncludedFieldsIsMutable();
        includedFields_.add(index, builderForValue.build());
        onChanged();
      } else {
        includedFieldsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Limit scanning only to these fields.
     * When inspecting a table, we recommend that you inspect all columns.
     * Otherwise, findings might be affected because hints from excluded columns
     * will not be used.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.FieldId included_fields = 7;</code>
     */
    public Builder addAllIncludedFields(
        java.lang.Iterable<? extends com.google.privacy.dlp.v2.FieldId> values) {
      if (includedFieldsBuilder_ == null) {
        ensureIncludedFieldsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, includedFields_);
        onChanged();
      } else {
        includedFieldsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Limit scanning only to these fields.
     * When inspecting a table, we recommend that you inspect all columns.
     * Otherwise, findings might be affected because hints from excluded columns
     * will not be used.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.FieldId included_fields = 7;</code>
     */
    public Builder clearIncludedFields() {
      if (includedFieldsBuilder_ == null) {
        includedFields_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000040);
        onChanged();
      } else {
        includedFieldsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Limit scanning only to these fields.
     * When inspecting a table, we recommend that you inspect all columns.
     * Otherwise, findings might be affected because hints from excluded columns
     * will not be used.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.FieldId included_fields = 7;</code>
     */
    public Builder removeIncludedFields(int index) {
      if (includedFieldsBuilder_ == null) {
        ensureIncludedFieldsIsMutable();
        includedFields_.remove(index);
        onChanged();
      } else {
        includedFieldsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Limit scanning only to these fields.
     * When inspecting a table, we recommend that you inspect all columns.
     * Otherwise, findings might be affected because hints from excluded columns
     * will not be used.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.FieldId included_fields = 7;</code>
     */
    public com.google.privacy.dlp.v2.FieldId.Builder getIncludedFieldsBuilder(int index) {
      return getIncludedFieldsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Limit scanning only to these fields.
     * When inspecting a table, we recommend that you inspect all columns.
     * Otherwise, findings might be affected because hints from excluded columns
     * will not be used.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.FieldId included_fields = 7;</code>
     */
    public com.google.privacy.dlp.v2.FieldIdOrBuilder getIncludedFieldsOrBuilder(int index) {
      if (includedFieldsBuilder_ == null) {
        return includedFields_.get(index);
      } else {
        return includedFieldsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Limit scanning only to these fields.
     * When inspecting a table, we recommend that you inspect all columns.
     * Otherwise, findings might be affected because hints from excluded columns
     * will not be used.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.FieldId included_fields = 7;</code>
     */
    public java.util.List<? extends com.google.privacy.dlp.v2.FieldIdOrBuilder>
        getIncludedFieldsOrBuilderList() {
      if (includedFieldsBuilder_ != null) {
        return includedFieldsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(includedFields_);
      }
    }
    /**
     *
     *
     * <pre>
     * Limit scanning only to these fields.
     * When inspecting a table, we recommend that you inspect all columns.
     * Otherwise, findings might be affected because hints from excluded columns
     * will not be used.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.FieldId included_fields = 7;</code>
     */
    public com.google.privacy.dlp.v2.FieldId.Builder addIncludedFieldsBuilder() {
      return getIncludedFieldsFieldBuilder()
          .addBuilder(com.google.privacy.dlp.v2.FieldId.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Limit scanning only to these fields.
     * When inspecting a table, we recommend that you inspect all columns.
     * Otherwise, findings might be affected because hints from excluded columns
     * will not be used.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.FieldId included_fields = 7;</code>
     */
    public com.google.privacy.dlp.v2.FieldId.Builder addIncludedFieldsBuilder(int index) {
      return getIncludedFieldsFieldBuilder()
          .addBuilder(index, com.google.privacy.dlp.v2.FieldId.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Limit scanning only to these fields.
     * When inspecting a table, we recommend that you inspect all columns.
     * Otherwise, findings might be affected because hints from excluded columns
     * will not be used.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.FieldId included_fields = 7;</code>
     */
    public java.util.List<com.google.privacy.dlp.v2.FieldId.Builder>
        getIncludedFieldsBuilderList() {
      return getIncludedFieldsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.privacy.dlp.v2.FieldId,
            com.google.privacy.dlp.v2.FieldId.Builder,
            com.google.privacy.dlp.v2.FieldIdOrBuilder>
        getIncludedFieldsFieldBuilder() {
      if (includedFieldsBuilder_ == null) {
        includedFieldsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.privacy.dlp.v2.FieldId,
                com.google.privacy.dlp.v2.FieldId.Builder,
                com.google.privacy.dlp.v2.FieldIdOrBuilder>(
                includedFields_,
                ((bitField0_ & 0x00000040) != 0),
                getParentForChildren(),
                isClean());
        includedFields_ = null;
      }
      return includedFieldsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.privacy.dlp.v2.BigQueryOptions)
  }

  // @@protoc_insertion_point(class_scope:google.privacy.dlp.v2.BigQueryOptions)
  private static final com.google.privacy.dlp.v2.BigQueryOptions DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.privacy.dlp.v2.BigQueryOptions();
  }

  public static com.google.privacy.dlp.v2.BigQueryOptions getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<BigQueryOptions> PARSER =
      new com.google.protobuf.AbstractParser<BigQueryOptions>() {
        @java.lang.Override
        public BigQueryOptions parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<BigQueryOptions> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<BigQueryOptions> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.privacy.dlp.v2.BigQueryOptions getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
