/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/privacy/dlp/v2/dlp.proto

// Protobuf Java Version: 3.25.3
package com.google.privacy.dlp.v2;

/**
 *
 *
 * <pre>
 * Generalization function that buckets values based on ranges. The ranges and
 * replacement values are dynamically provided by the user for custom behavior,
 * such as 1-30 -&gt; LOW 31-65 -&gt; MEDIUM 66-100 -&gt; HIGH
 * This can be used on
 * data of type: number, long, string, timestamp.
 * If the bound `Value` type differs from the type of data being transformed, we
 * will first attempt converting the type of the data to be transformed to match
 * the type of the bound before comparing.
 * See
 * https://cloud.google.com/sensitive-data-protection/docs/concepts-bucketing to
 * learn more.
 * </pre>
 *
 * Protobuf type {@code google.privacy.dlp.v2.BucketingConfig}
 */
public final class BucketingConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.privacy.dlp.v2.BucketingConfig)
    BucketingConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use BucketingConfig.newBuilder() to construct.
  private BucketingConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private BucketingConfig() {
    buckets_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new BucketingConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.privacy.dlp.v2.DlpProto
        .internal_static_google_privacy_dlp_v2_BucketingConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.privacy.dlp.v2.DlpProto
        .internal_static_google_privacy_dlp_v2_BucketingConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.privacy.dlp.v2.BucketingConfig.class,
            com.google.privacy.dlp.v2.BucketingConfig.Builder.class);
  }

  public interface BucketOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.privacy.dlp.v2.BucketingConfig.Bucket)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Lower bound of the range, inclusive. Type should be the same as max if
     * used.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Value min = 1;</code>
     *
     * @return Whether the min field is set.
     */
    boolean hasMin();
    /**
     *
     *
     * <pre>
     * Lower bound of the range, inclusive. Type should be the same as max if
     * used.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Value min = 1;</code>
     *
     * @return The min.
     */
    com.google.privacy.dlp.v2.Value getMin();
    /**
     *
     *
     * <pre>
     * Lower bound of the range, inclusive. Type should be the same as max if
     * used.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Value min = 1;</code>
     */
    com.google.privacy.dlp.v2.ValueOrBuilder getMinOrBuilder();

    /**
     *
     *
     * <pre>
     * Upper bound of the range, exclusive; type must match min.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Value max = 2;</code>
     *
     * @return Whether the max field is set.
     */
    boolean hasMax();
    /**
     *
     *
     * <pre>
     * Upper bound of the range, exclusive; type must match min.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Value max = 2;</code>
     *
     * @return The max.
     */
    com.google.privacy.dlp.v2.Value getMax();
    /**
     *
     *
     * <pre>
     * Upper bound of the range, exclusive; type must match min.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Value max = 2;</code>
     */
    com.google.privacy.dlp.v2.ValueOrBuilder getMaxOrBuilder();

    /**
     *
     *
     * <pre>
     * Required. Replacement value for this bucket.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.Value replacement_value = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the replacementValue field is set.
     */
    boolean hasReplacementValue();
    /**
     *
     *
     * <pre>
     * Required. Replacement value for this bucket.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.Value replacement_value = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The replacementValue.
     */
    com.google.privacy.dlp.v2.Value getReplacementValue();
    /**
     *
     *
     * <pre>
     * Required. Replacement value for this bucket.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.Value replacement_value = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    com.google.privacy.dlp.v2.ValueOrBuilder getReplacementValueOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * Bucket is represented as a range, along with replacement values.
   * </pre>
   *
   * Protobuf type {@code google.privacy.dlp.v2.BucketingConfig.Bucket}
   */
  public static final class Bucket extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.privacy.dlp.v2.BucketingConfig.Bucket)
      BucketOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Bucket.newBuilder() to construct.
    private Bucket(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Bucket() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Bucket();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_BucketingConfig_Bucket_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_BucketingConfig_Bucket_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.privacy.dlp.v2.BucketingConfig.Bucket.class,
              com.google.privacy.dlp.v2.BucketingConfig.Bucket.Builder.class);
    }

    private int bitField0_;
    public static final int MIN_FIELD_NUMBER = 1;
    private com.google.privacy.dlp.v2.Value min_;
    /**
     *
     *
     * <pre>
     * Lower bound of the range, inclusive. Type should be the same as max if
     * used.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Value min = 1;</code>
     *
     * @return Whether the min field is set.
     */
    @java.lang.Override
    public boolean hasMin() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Lower bound of the range, inclusive. Type should be the same as max if
     * used.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Value min = 1;</code>
     *
     * @return The min.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.Value getMin() {
      return min_ == null ? com.google.privacy.dlp.v2.Value.getDefaultInstance() : min_;
    }
    /**
     *
     *
     * <pre>
     * Lower bound of the range, inclusive. Type should be the same as max if
     * used.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Value min = 1;</code>
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.ValueOrBuilder getMinOrBuilder() {
      return min_ == null ? com.google.privacy.dlp.v2.Value.getDefaultInstance() : min_;
    }

    public static final int MAX_FIELD_NUMBER = 2;
    private com.google.privacy.dlp.v2.Value max_;
    /**
     *
     *
     * <pre>
     * Upper bound of the range, exclusive; type must match min.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Value max = 2;</code>
     *
     * @return Whether the max field is set.
     */
    @java.lang.Override
    public boolean hasMax() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Upper bound of the range, exclusive; type must match min.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Value max = 2;</code>
     *
     * @return The max.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.Value getMax() {
      return max_ == null ? com.google.privacy.dlp.v2.Value.getDefaultInstance() : max_;
    }
    /**
     *
     *
     * <pre>
     * Upper bound of the range, exclusive; type must match min.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Value max = 2;</code>
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.ValueOrBuilder getMaxOrBuilder() {
      return max_ == null ? com.google.privacy.dlp.v2.Value.getDefaultInstance() : max_;
    }

    public static final int REPLACEMENT_VALUE_FIELD_NUMBER = 3;
    private com.google.privacy.dlp.v2.Value replacementValue_;
    /**
     *
     *
     * <pre>
     * Required. Replacement value for this bucket.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.Value replacement_value = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the replacementValue field is set.
     */
    @java.lang.Override
    public boolean hasReplacementValue() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. Replacement value for this bucket.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.Value replacement_value = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The replacementValue.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.Value getReplacementValue() {
      return replacementValue_ == null
          ? com.google.privacy.dlp.v2.Value.getDefaultInstance()
          : replacementValue_;
    }
    /**
     *
     *
     * <pre>
     * Required. Replacement value for this bucket.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.Value replacement_value = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.ValueOrBuilder getReplacementValueOrBuilder() {
      return replacementValue_ == null
          ? com.google.privacy.dlp.v2.Value.getDefaultInstance()
          : replacementValue_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getMin());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeMessage(2, getMax());
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        output.writeMessage(3, getReplacementValue());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getMin());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getMax());
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getReplacementValue());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.privacy.dlp.v2.BucketingConfig.Bucket)) {
        return super.equals(obj);
      }
      com.google.privacy.dlp.v2.BucketingConfig.Bucket other =
          (com.google.privacy.dlp.v2.BucketingConfig.Bucket) obj;

      if (hasMin() != other.hasMin()) return false;
      if (hasMin()) {
        if (!getMin().equals(other.getMin())) return false;
      }
      if (hasMax() != other.hasMax()) return false;
      if (hasMax()) {
        if (!getMax().equals(other.getMax())) return false;
      }
      if (hasReplacementValue() != other.hasReplacementValue()) return false;
      if (hasReplacementValue()) {
        if (!getReplacementValue().equals(other.getReplacementValue())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasMin()) {
        hash = (37 * hash) + MIN_FIELD_NUMBER;
        hash = (53 * hash) + getMin().hashCode();
      }
      if (hasMax()) {
        hash = (37 * hash) + MAX_FIELD_NUMBER;
        hash = (53 * hash) + getMax().hashCode();
      }
      if (hasReplacementValue()) {
        hash = (37 * hash) + REPLACEMENT_VALUE_FIELD_NUMBER;
        hash = (53 * hash) + getReplacementValue().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.privacy.dlp.v2.BucketingConfig.Bucket parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.privacy.dlp.v2.BucketingConfig.Bucket parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.BucketingConfig.Bucket parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.privacy.dlp.v2.BucketingConfig.Bucket parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.BucketingConfig.Bucket parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.privacy.dlp.v2.BucketingConfig.Bucket parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.BucketingConfig.Bucket parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.privacy.dlp.v2.BucketingConfig.Bucket parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.BucketingConfig.Bucket parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.privacy.dlp.v2.BucketingConfig.Bucket parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.BucketingConfig.Bucket parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.privacy.dlp.v2.BucketingConfig.Bucket parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.privacy.dlp.v2.BucketingConfig.Bucket prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Bucket is represented as a range, along with replacement values.
     * </pre>
     *
     * Protobuf type {@code google.privacy.dlp.v2.BucketingConfig.Bucket}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.privacy.dlp.v2.BucketingConfig.Bucket)
        com.google.privacy.dlp.v2.BucketingConfig.BucketOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.privacy.dlp.v2.DlpProto
            .internal_static_google_privacy_dlp_v2_BucketingConfig_Bucket_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.privacy.dlp.v2.DlpProto
            .internal_static_google_privacy_dlp_v2_BucketingConfig_Bucket_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.privacy.dlp.v2.BucketingConfig.Bucket.class,
                com.google.privacy.dlp.v2.BucketingConfig.Bucket.Builder.class);
      }

      // Construct using com.google.privacy.dlp.v2.BucketingConfig.Bucket.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getMinFieldBuilder();
          getMaxFieldBuilder();
          getReplacementValueFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        min_ = null;
        if (minBuilder_ != null) {
          minBuilder_.dispose();
          minBuilder_ = null;
        }
        max_ = null;
        if (maxBuilder_ != null) {
          maxBuilder_.dispose();
          maxBuilder_ = null;
        }
        replacementValue_ = null;
        if (replacementValueBuilder_ != null) {
          replacementValueBuilder_.dispose();
          replacementValueBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.privacy.dlp.v2.DlpProto
            .internal_static_google_privacy_dlp_v2_BucketingConfig_Bucket_descriptor;
      }

      @java.lang.Override
      public com.google.privacy.dlp.v2.BucketingConfig.Bucket getDefaultInstanceForType() {
        return com.google.privacy.dlp.v2.BucketingConfig.Bucket.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.privacy.dlp.v2.BucketingConfig.Bucket build() {
        com.google.privacy.dlp.v2.BucketingConfig.Bucket result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.privacy.dlp.v2.BucketingConfig.Bucket buildPartial() {
        com.google.privacy.dlp.v2.BucketingConfig.Bucket result =
            new com.google.privacy.dlp.v2.BucketingConfig.Bucket(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.privacy.dlp.v2.BucketingConfig.Bucket result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.min_ = minBuilder_ == null ? min_ : minBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.max_ = maxBuilder_ == null ? max_ : maxBuilder_.build();
          to_bitField0_ |= 0x00000002;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.replacementValue_ =
              replacementValueBuilder_ == null
                  ? replacementValue_
                  : replacementValueBuilder_.build();
          to_bitField0_ |= 0x00000004;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.privacy.dlp.v2.BucketingConfig.Bucket) {
          return mergeFrom((com.google.privacy.dlp.v2.BucketingConfig.Bucket) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.privacy.dlp.v2.BucketingConfig.Bucket other) {
        if (other == com.google.privacy.dlp.v2.BucketingConfig.Bucket.getDefaultInstance())
          return this;
        if (other.hasMin()) {
          mergeMin(other.getMin());
        }
        if (other.hasMax()) {
          mergeMax(other.getMax());
        }
        if (other.hasReplacementValue()) {
          mergeReplacementValue(other.getReplacementValue());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getMinFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(getMaxFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  input.readMessage(
                      getReplacementValueFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.privacy.dlp.v2.Value min_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.privacy.dlp.v2.Value,
              com.google.privacy.dlp.v2.Value.Builder,
              com.google.privacy.dlp.v2.ValueOrBuilder>
          minBuilder_;
      /**
       *
       *
       * <pre>
       * Lower bound of the range, inclusive. Type should be the same as max if
       * used.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.Value min = 1;</code>
       *
       * @return Whether the min field is set.
       */
      public boolean hasMin() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * Lower bound of the range, inclusive. Type should be the same as max if
       * used.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.Value min = 1;</code>
       *
       * @return The min.
       */
      public com.google.privacy.dlp.v2.Value getMin() {
        if (minBuilder_ == null) {
          return min_ == null ? com.google.privacy.dlp.v2.Value.getDefaultInstance() : min_;
        } else {
          return minBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Lower bound of the range, inclusive. Type should be the same as max if
       * used.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.Value min = 1;</code>
       */
      public Builder setMin(com.google.privacy.dlp.v2.Value value) {
        if (minBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          min_ = value;
        } else {
          minBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Lower bound of the range, inclusive. Type should be the same as max if
       * used.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.Value min = 1;</code>
       */
      public Builder setMin(com.google.privacy.dlp.v2.Value.Builder builderForValue) {
        if (minBuilder_ == null) {
          min_ = builderForValue.build();
        } else {
          minBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Lower bound of the range, inclusive. Type should be the same as max if
       * used.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.Value min = 1;</code>
       */
      public Builder mergeMin(com.google.privacy.dlp.v2.Value value) {
        if (minBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && min_ != null
              && min_ != com.google.privacy.dlp.v2.Value.getDefaultInstance()) {
            getMinBuilder().mergeFrom(value);
          } else {
            min_ = value;
          }
        } else {
          minBuilder_.mergeFrom(value);
        }
        if (min_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Lower bound of the range, inclusive. Type should be the same as max if
       * used.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.Value min = 1;</code>
       */
      public Builder clearMin() {
        bitField0_ = (bitField0_ & ~0x00000001);
        min_ = null;
        if (minBuilder_ != null) {
          minBuilder_.dispose();
          minBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Lower bound of the range, inclusive. Type should be the same as max if
       * used.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.Value min = 1;</code>
       */
      public com.google.privacy.dlp.v2.Value.Builder getMinBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getMinFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Lower bound of the range, inclusive. Type should be the same as max if
       * used.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.Value min = 1;</code>
       */
      public com.google.privacy.dlp.v2.ValueOrBuilder getMinOrBuilder() {
        if (minBuilder_ != null) {
          return minBuilder_.getMessageOrBuilder();
        } else {
          return min_ == null ? com.google.privacy.dlp.v2.Value.getDefaultInstance() : min_;
        }
      }
      /**
       *
       *
       * <pre>
       * Lower bound of the range, inclusive. Type should be the same as max if
       * used.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.Value min = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.privacy.dlp.v2.Value,
              com.google.privacy.dlp.v2.Value.Builder,
              com.google.privacy.dlp.v2.ValueOrBuilder>
          getMinFieldBuilder() {
        if (minBuilder_ == null) {
          minBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.privacy.dlp.v2.Value,
                  com.google.privacy.dlp.v2.Value.Builder,
                  com.google.privacy.dlp.v2.ValueOrBuilder>(
                  getMin(), getParentForChildren(), isClean());
          min_ = null;
        }
        return minBuilder_;
      }

      private com.google.privacy.dlp.v2.Value max_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.privacy.dlp.v2.Value,
              com.google.privacy.dlp.v2.Value.Builder,
              com.google.privacy.dlp.v2.ValueOrBuilder>
          maxBuilder_;
      /**
       *
       *
       * <pre>
       * Upper bound of the range, exclusive; type must match min.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.Value max = 2;</code>
       *
       * @return Whether the max field is set.
       */
      public boolean hasMax() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * Upper bound of the range, exclusive; type must match min.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.Value max = 2;</code>
       *
       * @return The max.
       */
      public com.google.privacy.dlp.v2.Value getMax() {
        if (maxBuilder_ == null) {
          return max_ == null ? com.google.privacy.dlp.v2.Value.getDefaultInstance() : max_;
        } else {
          return maxBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Upper bound of the range, exclusive; type must match min.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.Value max = 2;</code>
       */
      public Builder setMax(com.google.privacy.dlp.v2.Value value) {
        if (maxBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          max_ = value;
        } else {
          maxBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Upper bound of the range, exclusive; type must match min.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.Value max = 2;</code>
       */
      public Builder setMax(com.google.privacy.dlp.v2.Value.Builder builderForValue) {
        if (maxBuilder_ == null) {
          max_ = builderForValue.build();
        } else {
          maxBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Upper bound of the range, exclusive; type must match min.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.Value max = 2;</code>
       */
      public Builder mergeMax(com.google.privacy.dlp.v2.Value value) {
        if (maxBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && max_ != null
              && max_ != com.google.privacy.dlp.v2.Value.getDefaultInstance()) {
            getMaxBuilder().mergeFrom(value);
          } else {
            max_ = value;
          }
        } else {
          maxBuilder_.mergeFrom(value);
        }
        if (max_ != null) {
          bitField0_ |= 0x00000002;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Upper bound of the range, exclusive; type must match min.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.Value max = 2;</code>
       */
      public Builder clearMax() {
        bitField0_ = (bitField0_ & ~0x00000002);
        max_ = null;
        if (maxBuilder_ != null) {
          maxBuilder_.dispose();
          maxBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Upper bound of the range, exclusive; type must match min.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.Value max = 2;</code>
       */
      public com.google.privacy.dlp.v2.Value.Builder getMaxBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getMaxFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Upper bound of the range, exclusive; type must match min.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.Value max = 2;</code>
       */
      public com.google.privacy.dlp.v2.ValueOrBuilder getMaxOrBuilder() {
        if (maxBuilder_ != null) {
          return maxBuilder_.getMessageOrBuilder();
        } else {
          return max_ == null ? com.google.privacy.dlp.v2.Value.getDefaultInstance() : max_;
        }
      }
      /**
       *
       *
       * <pre>
       * Upper bound of the range, exclusive; type must match min.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.Value max = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.privacy.dlp.v2.Value,
              com.google.privacy.dlp.v2.Value.Builder,
              com.google.privacy.dlp.v2.ValueOrBuilder>
          getMaxFieldBuilder() {
        if (maxBuilder_ == null) {
          maxBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.privacy.dlp.v2.Value,
                  com.google.privacy.dlp.v2.Value.Builder,
                  com.google.privacy.dlp.v2.ValueOrBuilder>(
                  getMax(), getParentForChildren(), isClean());
          max_ = null;
        }
        return maxBuilder_;
      }

      private com.google.privacy.dlp.v2.Value replacementValue_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.privacy.dlp.v2.Value,
              com.google.privacy.dlp.v2.Value.Builder,
              com.google.privacy.dlp.v2.ValueOrBuilder>
          replacementValueBuilder_;
      /**
       *
       *
       * <pre>
       * Required. Replacement value for this bucket.
       * </pre>
       *
       * <code>
       * .google.privacy.dlp.v2.Value replacement_value = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return Whether the replacementValue field is set.
       */
      public boolean hasReplacementValue() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       *
       *
       * <pre>
       * Required. Replacement value for this bucket.
       * </pre>
       *
       * <code>
       * .google.privacy.dlp.v2.Value replacement_value = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The replacementValue.
       */
      public com.google.privacy.dlp.v2.Value getReplacementValue() {
        if (replacementValueBuilder_ == null) {
          return replacementValue_ == null
              ? com.google.privacy.dlp.v2.Value.getDefaultInstance()
              : replacementValue_;
        } else {
          return replacementValueBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Replacement value for this bucket.
       * </pre>
       *
       * <code>
       * .google.privacy.dlp.v2.Value replacement_value = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setReplacementValue(com.google.privacy.dlp.v2.Value value) {
        if (replacementValueBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          replacementValue_ = value;
        } else {
          replacementValueBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Replacement value for this bucket.
       * </pre>
       *
       * <code>
       * .google.privacy.dlp.v2.Value replacement_value = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setReplacementValue(com.google.privacy.dlp.v2.Value.Builder builderForValue) {
        if (replacementValueBuilder_ == null) {
          replacementValue_ = builderForValue.build();
        } else {
          replacementValueBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Replacement value for this bucket.
       * </pre>
       *
       * <code>
       * .google.privacy.dlp.v2.Value replacement_value = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder mergeReplacementValue(com.google.privacy.dlp.v2.Value value) {
        if (replacementValueBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)
              && replacementValue_ != null
              && replacementValue_ != com.google.privacy.dlp.v2.Value.getDefaultInstance()) {
            getReplacementValueBuilder().mergeFrom(value);
          } else {
            replacementValue_ = value;
          }
        } else {
          replacementValueBuilder_.mergeFrom(value);
        }
        if (replacementValue_ != null) {
          bitField0_ |= 0x00000004;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Replacement value for this bucket.
       * </pre>
       *
       * <code>
       * .google.privacy.dlp.v2.Value replacement_value = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder clearReplacementValue() {
        bitField0_ = (bitField0_ & ~0x00000004);
        replacementValue_ = null;
        if (replacementValueBuilder_ != null) {
          replacementValueBuilder_.dispose();
          replacementValueBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Replacement value for this bucket.
       * </pre>
       *
       * <code>
       * .google.privacy.dlp.v2.Value replacement_value = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.privacy.dlp.v2.Value.Builder getReplacementValueBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getReplacementValueFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Required. Replacement value for this bucket.
       * </pre>
       *
       * <code>
       * .google.privacy.dlp.v2.Value replacement_value = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.privacy.dlp.v2.ValueOrBuilder getReplacementValueOrBuilder() {
        if (replacementValueBuilder_ != null) {
          return replacementValueBuilder_.getMessageOrBuilder();
        } else {
          return replacementValue_ == null
              ? com.google.privacy.dlp.v2.Value.getDefaultInstance()
              : replacementValue_;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Replacement value for this bucket.
       * </pre>
       *
       * <code>
       * .google.privacy.dlp.v2.Value replacement_value = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.privacy.dlp.v2.Value,
              com.google.privacy.dlp.v2.Value.Builder,
              com.google.privacy.dlp.v2.ValueOrBuilder>
          getReplacementValueFieldBuilder() {
        if (replacementValueBuilder_ == null) {
          replacementValueBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.privacy.dlp.v2.Value,
                  com.google.privacy.dlp.v2.Value.Builder,
                  com.google.privacy.dlp.v2.ValueOrBuilder>(
                  getReplacementValue(), getParentForChildren(), isClean());
          replacementValue_ = null;
        }
        return replacementValueBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.privacy.dlp.v2.BucketingConfig.Bucket)
    }

    // @@protoc_insertion_point(class_scope:google.privacy.dlp.v2.BucketingConfig.Bucket)
    private static final com.google.privacy.dlp.v2.BucketingConfig.Bucket DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.privacy.dlp.v2.BucketingConfig.Bucket();
    }

    public static com.google.privacy.dlp.v2.BucketingConfig.Bucket getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Bucket> PARSER =
        new com.google.protobuf.AbstractParser<Bucket>() {
          @java.lang.Override
          public Bucket parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Bucket> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Bucket> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.BucketingConfig.Bucket getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int BUCKETS_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<com.google.privacy.dlp.v2.BucketingConfig.Bucket> buckets_;
  /**
   *
   *
   * <pre>
   * Set of buckets. Ranges must be non-overlapping.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.BucketingConfig.Bucket buckets = 1;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.privacy.dlp.v2.BucketingConfig.Bucket> getBucketsList() {
    return buckets_;
  }
  /**
   *
   *
   * <pre>
   * Set of buckets. Ranges must be non-overlapping.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.BucketingConfig.Bucket buckets = 1;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.privacy.dlp.v2.BucketingConfig.BucketOrBuilder>
      getBucketsOrBuilderList() {
    return buckets_;
  }
  /**
   *
   *
   * <pre>
   * Set of buckets. Ranges must be non-overlapping.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.BucketingConfig.Bucket buckets = 1;</code>
   */
  @java.lang.Override
  public int getBucketsCount() {
    return buckets_.size();
  }
  /**
   *
   *
   * <pre>
   * Set of buckets. Ranges must be non-overlapping.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.BucketingConfig.Bucket buckets = 1;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.BucketingConfig.Bucket getBuckets(int index) {
    return buckets_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Set of buckets. Ranges must be non-overlapping.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.BucketingConfig.Bucket buckets = 1;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.BucketingConfig.BucketOrBuilder getBucketsOrBuilder(int index) {
    return buckets_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < buckets_.size(); i++) {
      output.writeMessage(1, buckets_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < buckets_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, buckets_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.privacy.dlp.v2.BucketingConfig)) {
      return super.equals(obj);
    }
    com.google.privacy.dlp.v2.BucketingConfig other =
        (com.google.privacy.dlp.v2.BucketingConfig) obj;

    if (!getBucketsList().equals(other.getBucketsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getBucketsCount() > 0) {
      hash = (37 * hash) + BUCKETS_FIELD_NUMBER;
      hash = (53 * hash) + getBucketsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.privacy.dlp.v2.BucketingConfig parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.BucketingConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.BucketingConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.BucketingConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.BucketingConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.BucketingConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.BucketingConfig parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.BucketingConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.BucketingConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.BucketingConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.BucketingConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.BucketingConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.privacy.dlp.v2.BucketingConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Generalization function that buckets values based on ranges. The ranges and
   * replacement values are dynamically provided by the user for custom behavior,
   * such as 1-30 -&gt; LOW 31-65 -&gt; MEDIUM 66-100 -&gt; HIGH
   * This can be used on
   * data of type: number, long, string, timestamp.
   * If the bound `Value` type differs from the type of data being transformed, we
   * will first attempt converting the type of the data to be transformed to match
   * the type of the bound before comparing.
   * See
   * https://cloud.google.com/sensitive-data-protection/docs/concepts-bucketing to
   * learn more.
   * </pre>
   *
   * Protobuf type {@code google.privacy.dlp.v2.BucketingConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.privacy.dlp.v2.BucketingConfig)
      com.google.privacy.dlp.v2.BucketingConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_BucketingConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_BucketingConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.privacy.dlp.v2.BucketingConfig.class,
              com.google.privacy.dlp.v2.BucketingConfig.Builder.class);
    }

    // Construct using com.google.privacy.dlp.v2.BucketingConfig.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (bucketsBuilder_ == null) {
        buckets_ = java.util.Collections.emptyList();
      } else {
        buckets_ = null;
        bucketsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_BucketingConfig_descriptor;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.BucketingConfig getDefaultInstanceForType() {
      return com.google.privacy.dlp.v2.BucketingConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.BucketingConfig build() {
      com.google.privacy.dlp.v2.BucketingConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.BucketingConfig buildPartial() {
      com.google.privacy.dlp.v2.BucketingConfig result =
          new com.google.privacy.dlp.v2.BucketingConfig(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.privacy.dlp.v2.BucketingConfig result) {
      if (bucketsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          buckets_ = java.util.Collections.unmodifiableList(buckets_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.buckets_ = buckets_;
      } else {
        result.buckets_ = bucketsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.privacy.dlp.v2.BucketingConfig result) {
      int from_bitField0_ = bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.privacy.dlp.v2.BucketingConfig) {
        return mergeFrom((com.google.privacy.dlp.v2.BucketingConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.privacy.dlp.v2.BucketingConfig other) {
      if (other == com.google.privacy.dlp.v2.BucketingConfig.getDefaultInstance()) return this;
      if (bucketsBuilder_ == null) {
        if (!other.buckets_.isEmpty()) {
          if (buckets_.isEmpty()) {
            buckets_ = other.buckets_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureBucketsIsMutable();
            buckets_.addAll(other.buckets_);
          }
          onChanged();
        }
      } else {
        if (!other.buckets_.isEmpty()) {
          if (bucketsBuilder_.isEmpty()) {
            bucketsBuilder_.dispose();
            bucketsBuilder_ = null;
            buckets_ = other.buckets_;
            bitField0_ = (bitField0_ & ~0x00000001);
            bucketsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getBucketsFieldBuilder()
                    : null;
          } else {
            bucketsBuilder_.addAllMessages(other.buckets_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.privacy.dlp.v2.BucketingConfig.Bucket m =
                    input.readMessage(
                        com.google.privacy.dlp.v2.BucketingConfig.Bucket.parser(),
                        extensionRegistry);
                if (bucketsBuilder_ == null) {
                  ensureBucketsIsMutable();
                  buckets_.add(m);
                } else {
                  bucketsBuilder_.addMessage(m);
                }
                break;
              } // case 10
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.privacy.dlp.v2.BucketingConfig.Bucket> buckets_ =
        java.util.Collections.emptyList();

    private void ensureBucketsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        buckets_ =
            new java.util.ArrayList<com.google.privacy.dlp.v2.BucketingConfig.Bucket>(buckets_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.privacy.dlp.v2.BucketingConfig.Bucket,
            com.google.privacy.dlp.v2.BucketingConfig.Bucket.Builder,
            com.google.privacy.dlp.v2.BucketingConfig.BucketOrBuilder>
        bucketsBuilder_;

    /**
     *
     *
     * <pre>
     * Set of buckets. Ranges must be non-overlapping.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.BucketingConfig.Bucket buckets = 1;</code>
     */
    public java.util.List<com.google.privacy.dlp.v2.BucketingConfig.Bucket> getBucketsList() {
      if (bucketsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(buckets_);
      } else {
        return bucketsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Set of buckets. Ranges must be non-overlapping.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.BucketingConfig.Bucket buckets = 1;</code>
     */
    public int getBucketsCount() {
      if (bucketsBuilder_ == null) {
        return buckets_.size();
      } else {
        return bucketsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Set of buckets. Ranges must be non-overlapping.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.BucketingConfig.Bucket buckets = 1;</code>
     */
    public com.google.privacy.dlp.v2.BucketingConfig.Bucket getBuckets(int index) {
      if (bucketsBuilder_ == null) {
        return buckets_.get(index);
      } else {
        return bucketsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Set of buckets. Ranges must be non-overlapping.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.BucketingConfig.Bucket buckets = 1;</code>
     */
    public Builder setBuckets(int index, com.google.privacy.dlp.v2.BucketingConfig.Bucket value) {
      if (bucketsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureBucketsIsMutable();
        buckets_.set(index, value);
        onChanged();
      } else {
        bucketsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of buckets. Ranges must be non-overlapping.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.BucketingConfig.Bucket buckets = 1;</code>
     */
    public Builder setBuckets(
        int index, com.google.privacy.dlp.v2.BucketingConfig.Bucket.Builder builderForValue) {
      if (bucketsBuilder_ == null) {
        ensureBucketsIsMutable();
        buckets_.set(index, builderForValue.build());
        onChanged();
      } else {
        bucketsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of buckets. Ranges must be non-overlapping.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.BucketingConfig.Bucket buckets = 1;</code>
     */
    public Builder addBuckets(com.google.privacy.dlp.v2.BucketingConfig.Bucket value) {
      if (bucketsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureBucketsIsMutable();
        buckets_.add(value);
        onChanged();
      } else {
        bucketsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of buckets. Ranges must be non-overlapping.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.BucketingConfig.Bucket buckets = 1;</code>
     */
    public Builder addBuckets(int index, com.google.privacy.dlp.v2.BucketingConfig.Bucket value) {
      if (bucketsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureBucketsIsMutable();
        buckets_.add(index, value);
        onChanged();
      } else {
        bucketsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of buckets. Ranges must be non-overlapping.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.BucketingConfig.Bucket buckets = 1;</code>
     */
    public Builder addBuckets(
        com.google.privacy.dlp.v2.BucketingConfig.Bucket.Builder builderForValue) {
      if (bucketsBuilder_ == null) {
        ensureBucketsIsMutable();
        buckets_.add(builderForValue.build());
        onChanged();
      } else {
        bucketsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of buckets. Ranges must be non-overlapping.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.BucketingConfig.Bucket buckets = 1;</code>
     */
    public Builder addBuckets(
        int index, com.google.privacy.dlp.v2.BucketingConfig.Bucket.Builder builderForValue) {
      if (bucketsBuilder_ == null) {
        ensureBucketsIsMutable();
        buckets_.add(index, builderForValue.build());
        onChanged();
      } else {
        bucketsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of buckets. Ranges must be non-overlapping.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.BucketingConfig.Bucket buckets = 1;</code>
     */
    public Builder addAllBuckets(
        java.lang.Iterable<? extends com.google.privacy.dlp.v2.BucketingConfig.Bucket> values) {
      if (bucketsBuilder_ == null) {
        ensureBucketsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, buckets_);
        onChanged();
      } else {
        bucketsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of buckets. Ranges must be non-overlapping.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.BucketingConfig.Bucket buckets = 1;</code>
     */
    public Builder clearBuckets() {
      if (bucketsBuilder_ == null) {
        buckets_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        bucketsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of buckets. Ranges must be non-overlapping.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.BucketingConfig.Bucket buckets = 1;</code>
     */
    public Builder removeBuckets(int index) {
      if (bucketsBuilder_ == null) {
        ensureBucketsIsMutable();
        buckets_.remove(index);
        onChanged();
      } else {
        bucketsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of buckets. Ranges must be non-overlapping.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.BucketingConfig.Bucket buckets = 1;</code>
     */
    public com.google.privacy.dlp.v2.BucketingConfig.Bucket.Builder getBucketsBuilder(int index) {
      return getBucketsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Set of buckets. Ranges must be non-overlapping.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.BucketingConfig.Bucket buckets = 1;</code>
     */
    public com.google.privacy.dlp.v2.BucketingConfig.BucketOrBuilder getBucketsOrBuilder(
        int index) {
      if (bucketsBuilder_ == null) {
        return buckets_.get(index);
      } else {
        return bucketsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Set of buckets. Ranges must be non-overlapping.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.BucketingConfig.Bucket buckets = 1;</code>
     */
    public java.util.List<? extends com.google.privacy.dlp.v2.BucketingConfig.BucketOrBuilder>
        getBucketsOrBuilderList() {
      if (bucketsBuilder_ != null) {
        return bucketsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(buckets_);
      }
    }
    /**
     *
     *
     * <pre>
     * Set of buckets. Ranges must be non-overlapping.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.BucketingConfig.Bucket buckets = 1;</code>
     */
    public com.google.privacy.dlp.v2.BucketingConfig.Bucket.Builder addBucketsBuilder() {
      return getBucketsFieldBuilder()
          .addBuilder(com.google.privacy.dlp.v2.BucketingConfig.Bucket.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Set of buckets. Ranges must be non-overlapping.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.BucketingConfig.Bucket buckets = 1;</code>
     */
    public com.google.privacy.dlp.v2.BucketingConfig.Bucket.Builder addBucketsBuilder(int index) {
      return getBucketsFieldBuilder()
          .addBuilder(index, com.google.privacy.dlp.v2.BucketingConfig.Bucket.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Set of buckets. Ranges must be non-overlapping.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.BucketingConfig.Bucket buckets = 1;</code>
     */
    public java.util.List<com.google.privacy.dlp.v2.BucketingConfig.Bucket.Builder>
        getBucketsBuilderList() {
      return getBucketsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.privacy.dlp.v2.BucketingConfig.Bucket,
            com.google.privacy.dlp.v2.BucketingConfig.Bucket.Builder,
            com.google.privacy.dlp.v2.BucketingConfig.BucketOrBuilder>
        getBucketsFieldBuilder() {
      if (bucketsBuilder_ == null) {
        bucketsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.privacy.dlp.v2.BucketingConfig.Bucket,
                com.google.privacy.dlp.v2.BucketingConfig.Bucket.Builder,
                com.google.privacy.dlp.v2.BucketingConfig.BucketOrBuilder>(
                buckets_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        buckets_ = null;
      }
      return bucketsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.privacy.dlp.v2.BucketingConfig)
  }

  // @@protoc_insertion_point(class_scope:google.privacy.dlp.v2.BucketingConfig)
  private static final com.google.privacy.dlp.v2.BucketingConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.privacy.dlp.v2.BucketingConfig();
  }

  public static com.google.privacy.dlp.v2.BucketingConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<BucketingConfig> PARSER =
      new com.google.protobuf.AbstractParser<BucketingConfig>() {
        @java.lang.Override
        public BucketingConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<BucketingConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<BucketingConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.privacy.dlp.v2.BucketingConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
