/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/privacy/dlp/v2/dlp.proto

// Protobuf Java Version: 3.25.3
package com.google.privacy.dlp.v2;

/**
 *
 *
 * <pre>
 * Container for bytes to inspect or redact.
 * </pre>
 *
 * Protobuf type {@code google.privacy.dlp.v2.ByteContentItem}
 */
public final class ByteContentItem extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.privacy.dlp.v2.ByteContentItem)
    ByteContentItemOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ByteContentItem.newBuilder() to construct.
  private ByteContentItem(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ByteContentItem() {
    type_ = 0;
    data_ = com.google.protobuf.ByteString.EMPTY;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ByteContentItem();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.privacy.dlp.v2.DlpProto
        .internal_static_google_privacy_dlp_v2_ByteContentItem_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.privacy.dlp.v2.DlpProto
        .internal_static_google_privacy_dlp_v2_ByteContentItem_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.privacy.dlp.v2.ByteContentItem.class,
            com.google.privacy.dlp.v2.ByteContentItem.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The type of data being sent for inspection. To learn more, see
   * [Supported file
   * types](https://cloud.google.com/sensitive-data-protection/docs/supported-file-types).
   * </pre>
   *
   * Protobuf enum {@code google.privacy.dlp.v2.ByteContentItem.BytesType}
   */
  public enum BytesType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unused
     * </pre>
     *
     * <code>BYTES_TYPE_UNSPECIFIED = 0;</code>
     */
    BYTES_TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Any image type.
     * </pre>
     *
     * <code>IMAGE = 6;</code>
     */
    IMAGE(6),
    /**
     *
     *
     * <pre>
     * jpeg
     * </pre>
     *
     * <code>IMAGE_JPEG = 1;</code>
     */
    IMAGE_JPEG(1),
    /**
     *
     *
     * <pre>
     * bmp
     * </pre>
     *
     * <code>IMAGE_BMP = 2;</code>
     */
    IMAGE_BMP(2),
    /**
     *
     *
     * <pre>
     * png
     * </pre>
     *
     * <code>IMAGE_PNG = 3;</code>
     */
    IMAGE_PNG(3),
    /**
     *
     *
     * <pre>
     * svg
     * </pre>
     *
     * <code>IMAGE_SVG = 4;</code>
     */
    IMAGE_SVG(4),
    /**
     *
     *
     * <pre>
     * plain text
     * </pre>
     *
     * <code>TEXT_UTF8 = 5;</code>
     */
    TEXT_UTF8(5),
    /**
     *
     *
     * <pre>
     * docx, docm, dotx, dotm
     * </pre>
     *
     * <code>WORD_DOCUMENT = 7;</code>
     */
    WORD_DOCUMENT(7),
    /**
     *
     *
     * <pre>
     * pdf
     * </pre>
     *
     * <code>PDF = 8;</code>
     */
    PDF(8),
    /**
     *
     *
     * <pre>
     * pptx, pptm, potx, potm, pot
     * </pre>
     *
     * <code>POWERPOINT_DOCUMENT = 9;</code>
     */
    POWERPOINT_DOCUMENT(9),
    /**
     *
     *
     * <pre>
     * xlsx, xlsm, xltx, xltm
     * </pre>
     *
     * <code>EXCEL_DOCUMENT = 10;</code>
     */
    EXCEL_DOCUMENT(10),
    /**
     *
     *
     * <pre>
     * avro
     * </pre>
     *
     * <code>AVRO = 11;</code>
     */
    AVRO(11),
    /**
     *
     *
     * <pre>
     * csv
     * </pre>
     *
     * <code>CSV = 12;</code>
     */
    CSV(12),
    /**
     *
     *
     * <pre>
     * tsv
     * </pre>
     *
     * <code>TSV = 13;</code>
     */
    TSV(13),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unused
     * </pre>
     *
     * <code>BYTES_TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int BYTES_TYPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Any image type.
     * </pre>
     *
     * <code>IMAGE = 6;</code>
     */
    public static final int IMAGE_VALUE = 6;
    /**
     *
     *
     * <pre>
     * jpeg
     * </pre>
     *
     * <code>IMAGE_JPEG = 1;</code>
     */
    public static final int IMAGE_JPEG_VALUE = 1;
    /**
     *
     *
     * <pre>
     * bmp
     * </pre>
     *
     * <code>IMAGE_BMP = 2;</code>
     */
    public static final int IMAGE_BMP_VALUE = 2;
    /**
     *
     *
     * <pre>
     * png
     * </pre>
     *
     * <code>IMAGE_PNG = 3;</code>
     */
    public static final int IMAGE_PNG_VALUE = 3;
    /**
     *
     *
     * <pre>
     * svg
     * </pre>
     *
     * <code>IMAGE_SVG = 4;</code>
     */
    public static final int IMAGE_SVG_VALUE = 4;
    /**
     *
     *
     * <pre>
     * plain text
     * </pre>
     *
     * <code>TEXT_UTF8 = 5;</code>
     */
    public static final int TEXT_UTF8_VALUE = 5;
    /**
     *
     *
     * <pre>
     * docx, docm, dotx, dotm
     * </pre>
     *
     * <code>WORD_DOCUMENT = 7;</code>
     */
    public static final int WORD_DOCUMENT_VALUE = 7;
    /**
     *
     *
     * <pre>
     * pdf
     * </pre>
     *
     * <code>PDF = 8;</code>
     */
    public static final int PDF_VALUE = 8;
    /**
     *
     *
     * <pre>
     * pptx, pptm, potx, potm, pot
     * </pre>
     *
     * <code>POWERPOINT_DOCUMENT = 9;</code>
     */
    public static final int POWERPOINT_DOCUMENT_VALUE = 9;
    /**
     *
     *
     * <pre>
     * xlsx, xlsm, xltx, xltm
     * </pre>
     *
     * <code>EXCEL_DOCUMENT = 10;</code>
     */
    public static final int EXCEL_DOCUMENT_VALUE = 10;
    /**
     *
     *
     * <pre>
     * avro
     * </pre>
     *
     * <code>AVRO = 11;</code>
     */
    public static final int AVRO_VALUE = 11;
    /**
     *
     *
     * <pre>
     * csv
     * </pre>
     *
     * <code>CSV = 12;</code>
     */
    public static final int CSV_VALUE = 12;
    /**
     *
     *
     * <pre>
     * tsv
     * </pre>
     *
     * <code>TSV = 13;</code>
     */
    public static final int TSV_VALUE = 13;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static BytesType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static BytesType forNumber(int value) {
      switch (value) {
        case 0:
          return BYTES_TYPE_UNSPECIFIED;
        case 6:
          return IMAGE;
        case 1:
          return IMAGE_JPEG;
        case 2:
          return IMAGE_BMP;
        case 3:
          return IMAGE_PNG;
        case 4:
          return IMAGE_SVG;
        case 5:
          return TEXT_UTF8;
        case 7:
          return WORD_DOCUMENT;
        case 8:
          return PDF;
        case 9:
          return POWERPOINT_DOCUMENT;
        case 10:
          return EXCEL_DOCUMENT;
        case 11:
          return AVRO;
        case 12:
          return CSV;
        case 13:
          return TSV;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<BytesType> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<BytesType> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<BytesType>() {
          public BytesType findValueByNumber(int number) {
            return BytesType.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.privacy.dlp.v2.ByteContentItem.getDescriptor().getEnumTypes().get(0);
    }

    private static final BytesType[] VALUES = values();

    public static BytesType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private BytesType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.privacy.dlp.v2.ByteContentItem.BytesType)
  }

  public static final int TYPE_FIELD_NUMBER = 1;
  private int type_ = 0;
  /**
   *
   *
   * <pre>
   * The type of data stored in the bytes string. Default will be TEXT_UTF8.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.ByteContentItem.BytesType type = 1;</code>
   *
   * @return The enum numeric value on the wire for type.
   */
  @java.lang.Override
  public int getTypeValue() {
    return type_;
  }
  /**
   *
   *
   * <pre>
   * The type of data stored in the bytes string. Default will be TEXT_UTF8.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.ByteContentItem.BytesType type = 1;</code>
   *
   * @return The type.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.ByteContentItem.BytesType getType() {
    com.google.privacy.dlp.v2.ByteContentItem.BytesType result =
        com.google.privacy.dlp.v2.ByteContentItem.BytesType.forNumber(type_);
    return result == null
        ? com.google.privacy.dlp.v2.ByteContentItem.BytesType.UNRECOGNIZED
        : result;
  }

  public static final int DATA_FIELD_NUMBER = 2;
  private com.google.protobuf.ByteString data_ = com.google.protobuf.ByteString.EMPTY;
  /**
   *
   *
   * <pre>
   * Content data to inspect or redact.
   * </pre>
   *
   * <code>bytes data = 2;</code>
   *
   * @return The data.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getData() {
    return data_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (type_
        != com.google.privacy.dlp.v2.ByteContentItem.BytesType.BYTES_TYPE_UNSPECIFIED.getNumber()) {
      output.writeEnum(1, type_);
    }
    if (!data_.isEmpty()) {
      output.writeBytes(2, data_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (type_
        != com.google.privacy.dlp.v2.ByteContentItem.BytesType.BYTES_TYPE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, type_);
    }
    if (!data_.isEmpty()) {
      size += com.google.protobuf.CodedOutputStream.computeBytesSize(2, data_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.privacy.dlp.v2.ByteContentItem)) {
      return super.equals(obj);
    }
    com.google.privacy.dlp.v2.ByteContentItem other =
        (com.google.privacy.dlp.v2.ByteContentItem) obj;

    if (type_ != other.type_) return false;
    if (!getData().equals(other.getData())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + TYPE_FIELD_NUMBER;
    hash = (53 * hash) + type_;
    hash = (37 * hash) + DATA_FIELD_NUMBER;
    hash = (53 * hash) + getData().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.privacy.dlp.v2.ByteContentItem parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.ByteContentItem parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.ByteContentItem parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.ByteContentItem parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.ByteContentItem parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.ByteContentItem parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.ByteContentItem parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.ByteContentItem parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.ByteContentItem parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.ByteContentItem parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.ByteContentItem parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.ByteContentItem parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.privacy.dlp.v2.ByteContentItem prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Container for bytes to inspect or redact.
   * </pre>
   *
   * Protobuf type {@code google.privacy.dlp.v2.ByteContentItem}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.privacy.dlp.v2.ByteContentItem)
      com.google.privacy.dlp.v2.ByteContentItemOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_ByteContentItem_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_ByteContentItem_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.privacy.dlp.v2.ByteContentItem.class,
              com.google.privacy.dlp.v2.ByteContentItem.Builder.class);
    }

    // Construct using com.google.privacy.dlp.v2.ByteContentItem.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      type_ = 0;
      data_ = com.google.protobuf.ByteString.EMPTY;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_ByteContentItem_descriptor;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.ByteContentItem getDefaultInstanceForType() {
      return com.google.privacy.dlp.v2.ByteContentItem.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.ByteContentItem build() {
      com.google.privacy.dlp.v2.ByteContentItem result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.ByteContentItem buildPartial() {
      com.google.privacy.dlp.v2.ByteContentItem result =
          new com.google.privacy.dlp.v2.ByteContentItem(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.privacy.dlp.v2.ByteContentItem result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.type_ = type_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.data_ = data_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.privacy.dlp.v2.ByteContentItem) {
        return mergeFrom((com.google.privacy.dlp.v2.ByteContentItem) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.privacy.dlp.v2.ByteContentItem other) {
      if (other == com.google.privacy.dlp.v2.ByteContentItem.getDefaultInstance()) return this;
      if (other.type_ != 0) {
        setTypeValue(other.getTypeValue());
      }
      if (other.getData() != com.google.protobuf.ByteString.EMPTY) {
        setData(other.getData());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                type_ = input.readEnum();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 18:
              {
                data_ = input.readBytes();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private int type_ = 0;
    /**
     *
     *
     * <pre>
     * The type of data stored in the bytes string. Default will be TEXT_UTF8.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ByteContentItem.BytesType type = 1;</code>
     *
     * @return The enum numeric value on the wire for type.
     */
    @java.lang.Override
    public int getTypeValue() {
      return type_;
    }
    /**
     *
     *
     * <pre>
     * The type of data stored in the bytes string. Default will be TEXT_UTF8.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ByteContentItem.BytesType type = 1;</code>
     *
     * @param value The enum numeric value on the wire for type to set.
     * @return This builder for chaining.
     */
    public Builder setTypeValue(int value) {
      type_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The type of data stored in the bytes string. Default will be TEXT_UTF8.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ByteContentItem.BytesType type = 1;</code>
     *
     * @return The type.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.ByteContentItem.BytesType getType() {
      com.google.privacy.dlp.v2.ByteContentItem.BytesType result =
          com.google.privacy.dlp.v2.ByteContentItem.BytesType.forNumber(type_);
      return result == null
          ? com.google.privacy.dlp.v2.ByteContentItem.BytesType.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * The type of data stored in the bytes string. Default will be TEXT_UTF8.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ByteContentItem.BytesType type = 1;</code>
     *
     * @param value The type to set.
     * @return This builder for chaining.
     */
    public Builder setType(com.google.privacy.dlp.v2.ByteContentItem.BytesType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000001;
      type_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The type of data stored in the bytes string. Default will be TEXT_UTF8.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ByteContentItem.BytesType type = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearType() {
      bitField0_ = (bitField0_ & ~0x00000001);
      type_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.ByteString data_ = com.google.protobuf.ByteString.EMPTY;
    /**
     *
     *
     * <pre>
     * Content data to inspect or redact.
     * </pre>
     *
     * <code>bytes data = 2;</code>
     *
     * @return The data.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getData() {
      return data_;
    }
    /**
     *
     *
     * <pre>
     * Content data to inspect or redact.
     * </pre>
     *
     * <code>bytes data = 2;</code>
     *
     * @param value The data to set.
     * @return This builder for chaining.
     */
    public Builder setData(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      data_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Content data to inspect or redact.
     * </pre>
     *
     * <code>bytes data = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearData() {
      bitField0_ = (bitField0_ & ~0x00000002);
      data_ = getDefaultInstance().getData();
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.privacy.dlp.v2.ByteContentItem)
  }

  // @@protoc_insertion_point(class_scope:google.privacy.dlp.v2.ByteContentItem)
  private static final com.google.privacy.dlp.v2.ByteContentItem DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.privacy.dlp.v2.ByteContentItem();
  }

  public static com.google.privacy.dlp.v2.ByteContentItem getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ByteContentItem> PARSER =
      new com.google.protobuf.AbstractParser<ByteContentItem>() {
        @java.lang.Override
        public ByteContentItem parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ByteContentItem> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ByteContentItem> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.privacy.dlp.v2.ByteContentItem getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
