/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/privacy/dlp/v2/dlp.proto

// Protobuf Java Version: 3.25.3
package com.google.privacy.dlp.v2;

/**
 *
 *
 * <pre>
 * Target used to match against for discovery with Cloud SQL tables.
 * </pre>
 *
 * Protobuf type {@code google.privacy.dlp.v2.CloudSqlDiscoveryTarget}
 */
public final class CloudSqlDiscoveryTarget extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.privacy.dlp.v2.CloudSqlDiscoveryTarget)
    CloudSqlDiscoveryTargetOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use CloudSqlDiscoveryTarget.newBuilder() to construct.
  private CloudSqlDiscoveryTarget(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private CloudSqlDiscoveryTarget() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new CloudSqlDiscoveryTarget();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.privacy.dlp.v2.DlpProto
        .internal_static_google_privacy_dlp_v2_CloudSqlDiscoveryTarget_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.privacy.dlp.v2.DlpProto
        .internal_static_google_privacy_dlp_v2_CloudSqlDiscoveryTarget_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.privacy.dlp.v2.CloudSqlDiscoveryTarget.class,
            com.google.privacy.dlp.v2.CloudSqlDiscoveryTarget.Builder.class);
  }

  private int bitField0_;
  private int cadenceCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object cadence_;

  public enum CadenceCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    GENERATION_CADENCE(3),
    DISABLED(4),
    CADENCE_NOT_SET(0);
    private final int value;

    private CadenceCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static CadenceCase valueOf(int value) {
      return forNumber(value);
    }

    public static CadenceCase forNumber(int value) {
      switch (value) {
        case 3:
          return GENERATION_CADENCE;
        case 4:
          return DISABLED;
        case 0:
          return CADENCE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public CadenceCase getCadenceCase() {
    return CadenceCase.forNumber(cadenceCase_);
  }

  public static final int FILTER_FIELD_NUMBER = 1;
  private com.google.privacy.dlp.v2.DiscoveryCloudSqlFilter filter_;
  /**
   *
   *
   * <pre>
   * Required. The tables the discovery cadence applies to. The first target
   * with a matching filter will be the one to apply to a table.
   * </pre>
   *
   * <code>
   * .google.privacy.dlp.v2.DiscoveryCloudSqlFilter filter = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the filter field is set.
   */
  @java.lang.Override
  public boolean hasFilter() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Required. The tables the discovery cadence applies to. The first target
   * with a matching filter will be the one to apply to a table.
   * </pre>
   *
   * <code>
   * .google.privacy.dlp.v2.DiscoveryCloudSqlFilter filter = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The filter.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.DiscoveryCloudSqlFilter getFilter() {
    return filter_ == null
        ? com.google.privacy.dlp.v2.DiscoveryCloudSqlFilter.getDefaultInstance()
        : filter_;
  }
  /**
   *
   *
   * <pre>
   * Required. The tables the discovery cadence applies to. The first target
   * with a matching filter will be the one to apply to a table.
   * </pre>
   *
   * <code>
   * .google.privacy.dlp.v2.DiscoveryCloudSqlFilter filter = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.DiscoveryCloudSqlFilterOrBuilder getFilterOrBuilder() {
    return filter_ == null
        ? com.google.privacy.dlp.v2.DiscoveryCloudSqlFilter.getDefaultInstance()
        : filter_;
  }

  public static final int CONDITIONS_FIELD_NUMBER = 2;
  private com.google.privacy.dlp.v2.DiscoveryCloudSqlConditions conditions_;
  /**
   *
   *
   * <pre>
   * In addition to matching the filter, these conditions must be true
   * before a profile is generated.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.DiscoveryCloudSqlConditions conditions = 2;</code>
   *
   * @return Whether the conditions field is set.
   */
  @java.lang.Override
  public boolean hasConditions() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * In addition to matching the filter, these conditions must be true
   * before a profile is generated.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.DiscoveryCloudSqlConditions conditions = 2;</code>
   *
   * @return The conditions.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.DiscoveryCloudSqlConditions getConditions() {
    return conditions_ == null
        ? com.google.privacy.dlp.v2.DiscoveryCloudSqlConditions.getDefaultInstance()
        : conditions_;
  }
  /**
   *
   *
   * <pre>
   * In addition to matching the filter, these conditions must be true
   * before a profile is generated.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.DiscoveryCloudSqlConditions conditions = 2;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.DiscoveryCloudSqlConditionsOrBuilder getConditionsOrBuilder() {
    return conditions_ == null
        ? com.google.privacy.dlp.v2.DiscoveryCloudSqlConditions.getDefaultInstance()
        : conditions_;
  }

  public static final int GENERATION_CADENCE_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * How often and when to update profiles. New tables that match both the
   * filter and conditions are scanned as quickly as possible depending on
   * system capacity.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence generation_cadence = 3;</code>
   *
   * @return Whether the generationCadence field is set.
   */
  @java.lang.Override
  public boolean hasGenerationCadence() {
    return cadenceCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * How often and when to update profiles. New tables that match both the
   * filter and conditions are scanned as quickly as possible depending on
   * system capacity.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence generation_cadence = 3;</code>
   *
   * @return The generationCadence.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence getGenerationCadence() {
    if (cadenceCase_ == 3) {
      return (com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence) cadence_;
    }
    return com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * How often and when to update profiles. New tables that match both the
   * filter and conditions are scanned as quickly as possible depending on
   * system capacity.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence generation_cadence = 3;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadenceOrBuilder
      getGenerationCadenceOrBuilder() {
    if (cadenceCase_ == 3) {
      return (com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence) cadence_;
    }
    return com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.getDefaultInstance();
  }

  public static final int DISABLED_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * Disable profiling for database resources that match this filter.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.Disabled disabled = 4;</code>
   *
   * @return Whether the disabled field is set.
   */
  @java.lang.Override
  public boolean hasDisabled() {
    return cadenceCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * Disable profiling for database resources that match this filter.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.Disabled disabled = 4;</code>
   *
   * @return The disabled.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.Disabled getDisabled() {
    if (cadenceCase_ == 4) {
      return (com.google.privacy.dlp.v2.Disabled) cadence_;
    }
    return com.google.privacy.dlp.v2.Disabled.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Disable profiling for database resources that match this filter.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.Disabled disabled = 4;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.DisabledOrBuilder getDisabledOrBuilder() {
    if (cadenceCase_ == 4) {
      return (com.google.privacy.dlp.v2.Disabled) cadence_;
    }
    return com.google.privacy.dlp.v2.Disabled.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getFilter());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(2, getConditions());
    }
    if (cadenceCase_ == 3) {
      output.writeMessage(
          3, (com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence) cadence_);
    }
    if (cadenceCase_ == 4) {
      output.writeMessage(4, (com.google.privacy.dlp.v2.Disabled) cadence_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getFilter());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getConditions());
    }
    if (cadenceCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence) cadence_);
    }
    if (cadenceCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, (com.google.privacy.dlp.v2.Disabled) cadence_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.privacy.dlp.v2.CloudSqlDiscoveryTarget)) {
      return super.equals(obj);
    }
    com.google.privacy.dlp.v2.CloudSqlDiscoveryTarget other =
        (com.google.privacy.dlp.v2.CloudSqlDiscoveryTarget) obj;

    if (hasFilter() != other.hasFilter()) return false;
    if (hasFilter()) {
      if (!getFilter().equals(other.getFilter())) return false;
    }
    if (hasConditions() != other.hasConditions()) return false;
    if (hasConditions()) {
      if (!getConditions().equals(other.getConditions())) return false;
    }
    if (!getCadenceCase().equals(other.getCadenceCase())) return false;
    switch (cadenceCase_) {
      case 3:
        if (!getGenerationCadence().equals(other.getGenerationCadence())) return false;
        break;
      case 4:
        if (!getDisabled().equals(other.getDisabled())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasFilter()) {
      hash = (37 * hash) + FILTER_FIELD_NUMBER;
      hash = (53 * hash) + getFilter().hashCode();
    }
    if (hasConditions()) {
      hash = (37 * hash) + CONDITIONS_FIELD_NUMBER;
      hash = (53 * hash) + getConditions().hashCode();
    }
    switch (cadenceCase_) {
      case 3:
        hash = (37 * hash) + GENERATION_CADENCE_FIELD_NUMBER;
        hash = (53 * hash) + getGenerationCadence().hashCode();
        break;
      case 4:
        hash = (37 * hash) + DISABLED_FIELD_NUMBER;
        hash = (53 * hash) + getDisabled().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.privacy.dlp.v2.CloudSqlDiscoveryTarget parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.CloudSqlDiscoveryTarget parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.CloudSqlDiscoveryTarget parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.CloudSqlDiscoveryTarget parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.CloudSqlDiscoveryTarget parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.CloudSqlDiscoveryTarget parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.CloudSqlDiscoveryTarget parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.CloudSqlDiscoveryTarget parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.CloudSqlDiscoveryTarget parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.CloudSqlDiscoveryTarget parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.CloudSqlDiscoveryTarget parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.CloudSqlDiscoveryTarget parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.privacy.dlp.v2.CloudSqlDiscoveryTarget prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Target used to match against for discovery with Cloud SQL tables.
   * </pre>
   *
   * Protobuf type {@code google.privacy.dlp.v2.CloudSqlDiscoveryTarget}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.privacy.dlp.v2.CloudSqlDiscoveryTarget)
      com.google.privacy.dlp.v2.CloudSqlDiscoveryTargetOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_CloudSqlDiscoveryTarget_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_CloudSqlDiscoveryTarget_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.privacy.dlp.v2.CloudSqlDiscoveryTarget.class,
              com.google.privacy.dlp.v2.CloudSqlDiscoveryTarget.Builder.class);
    }

    // Construct using com.google.privacy.dlp.v2.CloudSqlDiscoveryTarget.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getFilterFieldBuilder();
        getConditionsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      filter_ = null;
      if (filterBuilder_ != null) {
        filterBuilder_.dispose();
        filterBuilder_ = null;
      }
      conditions_ = null;
      if (conditionsBuilder_ != null) {
        conditionsBuilder_.dispose();
        conditionsBuilder_ = null;
      }
      if (generationCadenceBuilder_ != null) {
        generationCadenceBuilder_.clear();
      }
      if (disabledBuilder_ != null) {
        disabledBuilder_.clear();
      }
      cadenceCase_ = 0;
      cadence_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_CloudSqlDiscoveryTarget_descriptor;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.CloudSqlDiscoveryTarget getDefaultInstanceForType() {
      return com.google.privacy.dlp.v2.CloudSqlDiscoveryTarget.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.CloudSqlDiscoveryTarget build() {
      com.google.privacy.dlp.v2.CloudSqlDiscoveryTarget result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.CloudSqlDiscoveryTarget buildPartial() {
      com.google.privacy.dlp.v2.CloudSqlDiscoveryTarget result =
          new com.google.privacy.dlp.v2.CloudSqlDiscoveryTarget(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.privacy.dlp.v2.CloudSqlDiscoveryTarget result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.filter_ = filterBuilder_ == null ? filter_ : filterBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.conditions_ = conditionsBuilder_ == null ? conditions_ : conditionsBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.privacy.dlp.v2.CloudSqlDiscoveryTarget result) {
      result.cadenceCase_ = cadenceCase_;
      result.cadence_ = this.cadence_;
      if (cadenceCase_ == 3 && generationCadenceBuilder_ != null) {
        result.cadence_ = generationCadenceBuilder_.build();
      }
      if (cadenceCase_ == 4 && disabledBuilder_ != null) {
        result.cadence_ = disabledBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.privacy.dlp.v2.CloudSqlDiscoveryTarget) {
        return mergeFrom((com.google.privacy.dlp.v2.CloudSqlDiscoveryTarget) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.privacy.dlp.v2.CloudSqlDiscoveryTarget other) {
      if (other == com.google.privacy.dlp.v2.CloudSqlDiscoveryTarget.getDefaultInstance())
        return this;
      if (other.hasFilter()) {
        mergeFilter(other.getFilter());
      }
      if (other.hasConditions()) {
        mergeConditions(other.getConditions());
      }
      switch (other.getCadenceCase()) {
        case GENERATION_CADENCE:
          {
            mergeGenerationCadence(other.getGenerationCadence());
            break;
          }
        case DISABLED:
          {
            mergeDisabled(other.getDisabled());
            break;
          }
        case CADENCE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getFilterFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getConditionsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(
                    getGenerationCadenceFieldBuilder().getBuilder(), extensionRegistry);
                cadenceCase_ = 3;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getDisabledFieldBuilder().getBuilder(), extensionRegistry);
                cadenceCase_ = 4;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int cadenceCase_ = 0;
    private java.lang.Object cadence_;

    public CadenceCase getCadenceCase() {
      return CadenceCase.forNumber(cadenceCase_);
    }

    public Builder clearCadence() {
      cadenceCase_ = 0;
      cadence_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.privacy.dlp.v2.DiscoveryCloudSqlFilter filter_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.DiscoveryCloudSqlFilter,
            com.google.privacy.dlp.v2.DiscoveryCloudSqlFilter.Builder,
            com.google.privacy.dlp.v2.DiscoveryCloudSqlFilterOrBuilder>
        filterBuilder_;
    /**
     *
     *
     * <pre>
     * Required. The tables the discovery cadence applies to. The first target
     * with a matching filter will be the one to apply to a table.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.DiscoveryCloudSqlFilter filter = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the filter field is set.
     */
    public boolean hasFilter() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. The tables the discovery cadence applies to. The first target
     * with a matching filter will be the one to apply to a table.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.DiscoveryCloudSqlFilter filter = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The filter.
     */
    public com.google.privacy.dlp.v2.DiscoveryCloudSqlFilter getFilter() {
      if (filterBuilder_ == null) {
        return filter_ == null
            ? com.google.privacy.dlp.v2.DiscoveryCloudSqlFilter.getDefaultInstance()
            : filter_;
      } else {
        return filterBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The tables the discovery cadence applies to. The first target
     * with a matching filter will be the one to apply to a table.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.DiscoveryCloudSqlFilter filter = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setFilter(com.google.privacy.dlp.v2.DiscoveryCloudSqlFilter value) {
      if (filterBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        filter_ = value;
      } else {
        filterBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The tables the discovery cadence applies to. The first target
     * with a matching filter will be the one to apply to a table.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.DiscoveryCloudSqlFilter filter = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setFilter(
        com.google.privacy.dlp.v2.DiscoveryCloudSqlFilter.Builder builderForValue) {
      if (filterBuilder_ == null) {
        filter_ = builderForValue.build();
      } else {
        filterBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The tables the discovery cadence applies to. The first target
     * with a matching filter will be the one to apply to a table.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.DiscoveryCloudSqlFilter filter = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeFilter(com.google.privacy.dlp.v2.DiscoveryCloudSqlFilter value) {
      if (filterBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && filter_ != null
            && filter_ != com.google.privacy.dlp.v2.DiscoveryCloudSqlFilter.getDefaultInstance()) {
          getFilterBuilder().mergeFrom(value);
        } else {
          filter_ = value;
        }
      } else {
        filterBuilder_.mergeFrom(value);
      }
      if (filter_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The tables the discovery cadence applies to. The first target
     * with a matching filter will be the one to apply to a table.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.DiscoveryCloudSqlFilter filter = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearFilter() {
      bitField0_ = (bitField0_ & ~0x00000001);
      filter_ = null;
      if (filterBuilder_ != null) {
        filterBuilder_.dispose();
        filterBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The tables the discovery cadence applies to. The first target
     * with a matching filter will be the one to apply to a table.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.DiscoveryCloudSqlFilter filter = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.privacy.dlp.v2.DiscoveryCloudSqlFilter.Builder getFilterBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getFilterFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. The tables the discovery cadence applies to. The first target
     * with a matching filter will be the one to apply to a table.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.DiscoveryCloudSqlFilter filter = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.privacy.dlp.v2.DiscoveryCloudSqlFilterOrBuilder getFilterOrBuilder() {
      if (filterBuilder_ != null) {
        return filterBuilder_.getMessageOrBuilder();
      } else {
        return filter_ == null
            ? com.google.privacy.dlp.v2.DiscoveryCloudSqlFilter.getDefaultInstance()
            : filter_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The tables the discovery cadence applies to. The first target
     * with a matching filter will be the one to apply to a table.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.DiscoveryCloudSqlFilter filter = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.DiscoveryCloudSqlFilter,
            com.google.privacy.dlp.v2.DiscoveryCloudSqlFilter.Builder,
            com.google.privacy.dlp.v2.DiscoveryCloudSqlFilterOrBuilder>
        getFilterFieldBuilder() {
      if (filterBuilder_ == null) {
        filterBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.DiscoveryCloudSqlFilter,
                com.google.privacy.dlp.v2.DiscoveryCloudSqlFilter.Builder,
                com.google.privacy.dlp.v2.DiscoveryCloudSqlFilterOrBuilder>(
                getFilter(), getParentForChildren(), isClean());
        filter_ = null;
      }
      return filterBuilder_;
    }

    private com.google.privacy.dlp.v2.DiscoveryCloudSqlConditions conditions_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.DiscoveryCloudSqlConditions,
            com.google.privacy.dlp.v2.DiscoveryCloudSqlConditions.Builder,
            com.google.privacy.dlp.v2.DiscoveryCloudSqlConditionsOrBuilder>
        conditionsBuilder_;
    /**
     *
     *
     * <pre>
     * In addition to matching the filter, these conditions must be true
     * before a profile is generated.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DiscoveryCloudSqlConditions conditions = 2;</code>
     *
     * @return Whether the conditions field is set.
     */
    public boolean hasConditions() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * In addition to matching the filter, these conditions must be true
     * before a profile is generated.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DiscoveryCloudSqlConditions conditions = 2;</code>
     *
     * @return The conditions.
     */
    public com.google.privacy.dlp.v2.DiscoveryCloudSqlConditions getConditions() {
      if (conditionsBuilder_ == null) {
        return conditions_ == null
            ? com.google.privacy.dlp.v2.DiscoveryCloudSqlConditions.getDefaultInstance()
            : conditions_;
      } else {
        return conditionsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * In addition to matching the filter, these conditions must be true
     * before a profile is generated.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DiscoveryCloudSqlConditions conditions = 2;</code>
     */
    public Builder setConditions(com.google.privacy.dlp.v2.DiscoveryCloudSqlConditions value) {
      if (conditionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        conditions_ = value;
      } else {
        conditionsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * In addition to matching the filter, these conditions must be true
     * before a profile is generated.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DiscoveryCloudSqlConditions conditions = 2;</code>
     */
    public Builder setConditions(
        com.google.privacy.dlp.v2.DiscoveryCloudSqlConditions.Builder builderForValue) {
      if (conditionsBuilder_ == null) {
        conditions_ = builderForValue.build();
      } else {
        conditionsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * In addition to matching the filter, these conditions must be true
     * before a profile is generated.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DiscoveryCloudSqlConditions conditions = 2;</code>
     */
    public Builder mergeConditions(com.google.privacy.dlp.v2.DiscoveryCloudSqlConditions value) {
      if (conditionsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && conditions_ != null
            && conditions_
                != com.google.privacy.dlp.v2.DiscoveryCloudSqlConditions.getDefaultInstance()) {
          getConditionsBuilder().mergeFrom(value);
        } else {
          conditions_ = value;
        }
      } else {
        conditionsBuilder_.mergeFrom(value);
      }
      if (conditions_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * In addition to matching the filter, these conditions must be true
     * before a profile is generated.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DiscoveryCloudSqlConditions conditions = 2;</code>
     */
    public Builder clearConditions() {
      bitField0_ = (bitField0_ & ~0x00000002);
      conditions_ = null;
      if (conditionsBuilder_ != null) {
        conditionsBuilder_.dispose();
        conditionsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * In addition to matching the filter, these conditions must be true
     * before a profile is generated.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DiscoveryCloudSqlConditions conditions = 2;</code>
     */
    public com.google.privacy.dlp.v2.DiscoveryCloudSqlConditions.Builder getConditionsBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getConditionsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * In addition to matching the filter, these conditions must be true
     * before a profile is generated.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DiscoveryCloudSqlConditions conditions = 2;</code>
     */
    public com.google.privacy.dlp.v2.DiscoveryCloudSqlConditionsOrBuilder getConditionsOrBuilder() {
      if (conditionsBuilder_ != null) {
        return conditionsBuilder_.getMessageOrBuilder();
      } else {
        return conditions_ == null
            ? com.google.privacy.dlp.v2.DiscoveryCloudSqlConditions.getDefaultInstance()
            : conditions_;
      }
    }
    /**
     *
     *
     * <pre>
     * In addition to matching the filter, these conditions must be true
     * before a profile is generated.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DiscoveryCloudSqlConditions conditions = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.DiscoveryCloudSqlConditions,
            com.google.privacy.dlp.v2.DiscoveryCloudSqlConditions.Builder,
            com.google.privacy.dlp.v2.DiscoveryCloudSqlConditionsOrBuilder>
        getConditionsFieldBuilder() {
      if (conditionsBuilder_ == null) {
        conditionsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.DiscoveryCloudSqlConditions,
                com.google.privacy.dlp.v2.DiscoveryCloudSqlConditions.Builder,
                com.google.privacy.dlp.v2.DiscoveryCloudSqlConditionsOrBuilder>(
                getConditions(), getParentForChildren(), isClean());
        conditions_ = null;
      }
      return conditionsBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence,
            com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.Builder,
            com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadenceOrBuilder>
        generationCadenceBuilder_;
    /**
     *
     *
     * <pre>
     * How often and when to update profiles. New tables that match both the
     * filter and conditions are scanned as quickly as possible depending on
     * system capacity.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence generation_cadence = 3;
     * </code>
     *
     * @return Whether the generationCadence field is set.
     */
    @java.lang.Override
    public boolean hasGenerationCadence() {
      return cadenceCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * How often and when to update profiles. New tables that match both the
     * filter and conditions are scanned as quickly as possible depending on
     * system capacity.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence generation_cadence = 3;
     * </code>
     *
     * @return The generationCadence.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence getGenerationCadence() {
      if (generationCadenceBuilder_ == null) {
        if (cadenceCase_ == 3) {
          return (com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence) cadence_;
        }
        return com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.getDefaultInstance();
      } else {
        if (cadenceCase_ == 3) {
          return generationCadenceBuilder_.getMessage();
        }
        return com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * How often and when to update profiles. New tables that match both the
     * filter and conditions are scanned as quickly as possible depending on
     * system capacity.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence generation_cadence = 3;
     * </code>
     */
    public Builder setGenerationCadence(
        com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence value) {
      if (generationCadenceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        cadence_ = value;
        onChanged();
      } else {
        generationCadenceBuilder_.setMessage(value);
      }
      cadenceCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * How often and when to update profiles. New tables that match both the
     * filter and conditions are scanned as quickly as possible depending on
     * system capacity.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence generation_cadence = 3;
     * </code>
     */
    public Builder setGenerationCadence(
        com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.Builder builderForValue) {
      if (generationCadenceBuilder_ == null) {
        cadence_ = builderForValue.build();
        onChanged();
      } else {
        generationCadenceBuilder_.setMessage(builderForValue.build());
      }
      cadenceCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * How often and when to update profiles. New tables that match both the
     * filter and conditions are scanned as quickly as possible depending on
     * system capacity.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence generation_cadence = 3;
     * </code>
     */
    public Builder mergeGenerationCadence(
        com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence value) {
      if (generationCadenceBuilder_ == null) {
        if (cadenceCase_ == 3
            && cadence_
                != com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence
                    .getDefaultInstance()) {
          cadence_ =
              com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.newBuilder(
                      (com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence) cadence_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          cadence_ = value;
        }
        onChanged();
      } else {
        if (cadenceCase_ == 3) {
          generationCadenceBuilder_.mergeFrom(value);
        } else {
          generationCadenceBuilder_.setMessage(value);
        }
      }
      cadenceCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * How often and when to update profiles. New tables that match both the
     * filter and conditions are scanned as quickly as possible depending on
     * system capacity.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence generation_cadence = 3;
     * </code>
     */
    public Builder clearGenerationCadence() {
      if (generationCadenceBuilder_ == null) {
        if (cadenceCase_ == 3) {
          cadenceCase_ = 0;
          cadence_ = null;
          onChanged();
        }
      } else {
        if (cadenceCase_ == 3) {
          cadenceCase_ = 0;
          cadence_ = null;
        }
        generationCadenceBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * How often and when to update profiles. New tables that match both the
     * filter and conditions are scanned as quickly as possible depending on
     * system capacity.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence generation_cadence = 3;
     * </code>
     */
    public com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.Builder
        getGenerationCadenceBuilder() {
      return getGenerationCadenceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * How often and when to update profiles. New tables that match both the
     * filter and conditions are scanned as quickly as possible depending on
     * system capacity.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence generation_cadence = 3;
     * </code>
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadenceOrBuilder
        getGenerationCadenceOrBuilder() {
      if ((cadenceCase_ == 3) && (generationCadenceBuilder_ != null)) {
        return generationCadenceBuilder_.getMessageOrBuilder();
      } else {
        if (cadenceCase_ == 3) {
          return (com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence) cadence_;
        }
        return com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * How often and when to update profiles. New tables that match both the
     * filter and conditions are scanned as quickly as possible depending on
     * system capacity.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence generation_cadence = 3;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence,
            com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.Builder,
            com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadenceOrBuilder>
        getGenerationCadenceFieldBuilder() {
      if (generationCadenceBuilder_ == null) {
        if (!(cadenceCase_ == 3)) {
          cadence_ =
              com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.getDefaultInstance();
        }
        generationCadenceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence,
                com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence.Builder,
                com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadenceOrBuilder>(
                (com.google.privacy.dlp.v2.DiscoveryCloudSqlGenerationCadence) cadence_,
                getParentForChildren(),
                isClean());
        cadence_ = null;
      }
      cadenceCase_ = 3;
      onChanged();
      return generationCadenceBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.Disabled,
            com.google.privacy.dlp.v2.Disabled.Builder,
            com.google.privacy.dlp.v2.DisabledOrBuilder>
        disabledBuilder_;
    /**
     *
     *
     * <pre>
     * Disable profiling for database resources that match this filter.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Disabled disabled = 4;</code>
     *
     * @return Whether the disabled field is set.
     */
    @java.lang.Override
    public boolean hasDisabled() {
      return cadenceCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * Disable profiling for database resources that match this filter.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Disabled disabled = 4;</code>
     *
     * @return The disabled.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.Disabled getDisabled() {
      if (disabledBuilder_ == null) {
        if (cadenceCase_ == 4) {
          return (com.google.privacy.dlp.v2.Disabled) cadence_;
        }
        return com.google.privacy.dlp.v2.Disabled.getDefaultInstance();
      } else {
        if (cadenceCase_ == 4) {
          return disabledBuilder_.getMessage();
        }
        return com.google.privacy.dlp.v2.Disabled.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Disable profiling for database resources that match this filter.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Disabled disabled = 4;</code>
     */
    public Builder setDisabled(com.google.privacy.dlp.v2.Disabled value) {
      if (disabledBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        cadence_ = value;
        onChanged();
      } else {
        disabledBuilder_.setMessage(value);
      }
      cadenceCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Disable profiling for database resources that match this filter.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Disabled disabled = 4;</code>
     */
    public Builder setDisabled(com.google.privacy.dlp.v2.Disabled.Builder builderForValue) {
      if (disabledBuilder_ == null) {
        cadence_ = builderForValue.build();
        onChanged();
      } else {
        disabledBuilder_.setMessage(builderForValue.build());
      }
      cadenceCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Disable profiling for database resources that match this filter.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Disabled disabled = 4;</code>
     */
    public Builder mergeDisabled(com.google.privacy.dlp.v2.Disabled value) {
      if (disabledBuilder_ == null) {
        if (cadenceCase_ == 4
            && cadence_ != com.google.privacy.dlp.v2.Disabled.getDefaultInstance()) {
          cadence_ =
              com.google.privacy.dlp.v2.Disabled.newBuilder(
                      (com.google.privacy.dlp.v2.Disabled) cadence_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          cadence_ = value;
        }
        onChanged();
      } else {
        if (cadenceCase_ == 4) {
          disabledBuilder_.mergeFrom(value);
        } else {
          disabledBuilder_.setMessage(value);
        }
      }
      cadenceCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Disable profiling for database resources that match this filter.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Disabled disabled = 4;</code>
     */
    public Builder clearDisabled() {
      if (disabledBuilder_ == null) {
        if (cadenceCase_ == 4) {
          cadenceCase_ = 0;
          cadence_ = null;
          onChanged();
        }
      } else {
        if (cadenceCase_ == 4) {
          cadenceCase_ = 0;
          cadence_ = null;
        }
        disabledBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Disable profiling for database resources that match this filter.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Disabled disabled = 4;</code>
     */
    public com.google.privacy.dlp.v2.Disabled.Builder getDisabledBuilder() {
      return getDisabledFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Disable profiling for database resources that match this filter.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Disabled disabled = 4;</code>
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.DisabledOrBuilder getDisabledOrBuilder() {
      if ((cadenceCase_ == 4) && (disabledBuilder_ != null)) {
        return disabledBuilder_.getMessageOrBuilder();
      } else {
        if (cadenceCase_ == 4) {
          return (com.google.privacy.dlp.v2.Disabled) cadence_;
        }
        return com.google.privacy.dlp.v2.Disabled.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Disable profiling for database resources that match this filter.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Disabled disabled = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.Disabled,
            com.google.privacy.dlp.v2.Disabled.Builder,
            com.google.privacy.dlp.v2.DisabledOrBuilder>
        getDisabledFieldBuilder() {
      if (disabledBuilder_ == null) {
        if (!(cadenceCase_ == 4)) {
          cadence_ = com.google.privacy.dlp.v2.Disabled.getDefaultInstance();
        }
        disabledBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.Disabled,
                com.google.privacy.dlp.v2.Disabled.Builder,
                com.google.privacy.dlp.v2.DisabledOrBuilder>(
                (com.google.privacy.dlp.v2.Disabled) cadence_, getParentForChildren(), isClean());
        cadence_ = null;
      }
      cadenceCase_ = 4;
      onChanged();
      return disabledBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.privacy.dlp.v2.CloudSqlDiscoveryTarget)
  }

  // @@protoc_insertion_point(class_scope:google.privacy.dlp.v2.CloudSqlDiscoveryTarget)
  private static final com.google.privacy.dlp.v2.CloudSqlDiscoveryTarget DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.privacy.dlp.v2.CloudSqlDiscoveryTarget();
  }

  public static com.google.privacy.dlp.v2.CloudSqlDiscoveryTarget getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CloudSqlDiscoveryTarget> PARSER =
      new com.google.protobuf.AbstractParser<CloudSqlDiscoveryTarget>() {
        @java.lang.Override
        public CloudSqlDiscoveryTarget parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<CloudSqlDiscoveryTarget> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CloudSqlDiscoveryTarget> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.privacy.dlp.v2.CloudSqlDiscoveryTarget getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
