/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/privacy/dlp/v2/dlp.proto

// Protobuf Java Version: 3.25.3
package com.google.privacy.dlp.v2;

/**
 *
 *
 * <pre>
 * Cloud SQL connection properties.
 * </pre>
 *
 * Protobuf type {@code google.privacy.dlp.v2.CloudSqlProperties}
 */
public final class CloudSqlProperties extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.privacy.dlp.v2.CloudSqlProperties)
    CloudSqlPropertiesOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use CloudSqlProperties.newBuilder() to construct.
  private CloudSqlProperties(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private CloudSqlProperties() {
    connectionName_ = "";
    databaseEngine_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new CloudSqlProperties();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.privacy.dlp.v2.DlpProto
        .internal_static_google_privacy_dlp_v2_CloudSqlProperties_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.privacy.dlp.v2.DlpProto
        .internal_static_google_privacy_dlp_v2_CloudSqlProperties_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.privacy.dlp.v2.CloudSqlProperties.class,
            com.google.privacy.dlp.v2.CloudSqlProperties.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Database engine of a Cloud SQL instance.
   * New values may be added over time.
   * </pre>
   *
   * Protobuf enum {@code google.privacy.dlp.v2.CloudSqlProperties.DatabaseEngine}
   */
  public enum DatabaseEngine implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * An engine that is not currently supported by SDP.
     * </pre>
     *
     * <code>DATABASE_ENGINE_UNKNOWN = 0;</code>
     */
    DATABASE_ENGINE_UNKNOWN(0),
    /**
     *
     *
     * <pre>
     * Cloud SQL for MySQL instance.
     * </pre>
     *
     * <code>DATABASE_ENGINE_MYSQL = 1;</code>
     */
    DATABASE_ENGINE_MYSQL(1),
    /**
     *
     *
     * <pre>
     * Cloud SQL for Postgres instance.
     * </pre>
     *
     * <code>DATABASE_ENGINE_POSTGRES = 2;</code>
     */
    DATABASE_ENGINE_POSTGRES(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * An engine that is not currently supported by SDP.
     * </pre>
     *
     * <code>DATABASE_ENGINE_UNKNOWN = 0;</code>
     */
    public static final int DATABASE_ENGINE_UNKNOWN_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Cloud SQL for MySQL instance.
     * </pre>
     *
     * <code>DATABASE_ENGINE_MYSQL = 1;</code>
     */
    public static final int DATABASE_ENGINE_MYSQL_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Cloud SQL for Postgres instance.
     * </pre>
     *
     * <code>DATABASE_ENGINE_POSTGRES = 2;</code>
     */
    public static final int DATABASE_ENGINE_POSTGRES_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static DatabaseEngine valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static DatabaseEngine forNumber(int value) {
      switch (value) {
        case 0:
          return DATABASE_ENGINE_UNKNOWN;
        case 1:
          return DATABASE_ENGINE_MYSQL;
        case 2:
          return DATABASE_ENGINE_POSTGRES;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<DatabaseEngine> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<DatabaseEngine> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<DatabaseEngine>() {
          public DatabaseEngine findValueByNumber(int number) {
            return DatabaseEngine.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.privacy.dlp.v2.CloudSqlProperties.getDescriptor().getEnumTypes().get(0);
    }

    private static final DatabaseEngine[] VALUES = values();

    public static DatabaseEngine valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private DatabaseEngine(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.privacy.dlp.v2.CloudSqlProperties.DatabaseEngine)
  }

  private int credentialCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object credential_;

  public enum CredentialCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    USERNAME_PASSWORD(2),
    CLOUD_SQL_IAM(3),
    CREDENTIAL_NOT_SET(0);
    private final int value;

    private CredentialCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static CredentialCase valueOf(int value) {
      return forNumber(value);
    }

    public static CredentialCase forNumber(int value) {
      switch (value) {
        case 2:
          return USERNAME_PASSWORD;
        case 3:
          return CLOUD_SQL_IAM;
        case 0:
          return CREDENTIAL_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public CredentialCase getCredentialCase() {
    return CredentialCase.forNumber(credentialCase_);
  }

  public static final int CONNECTION_NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object connectionName_ = "";
  /**
   *
   *
   * <pre>
   * Optional. Immutable. The Cloud SQL instance for which the connection is
   * defined. Only one connection per instance is allowed. This can only be set
   * at creation time, and cannot be updated.
   *
   * It is an error to use a connection_name from different project or region
   * than the one that holds the connection.
   * For example, a Connection resource for Cloud SQL connection_name
   * `project-id:us-central1:sql-instance`
   * must be created under the parent
   * `projects/project-id/locations/us-central1`
   * </pre>
   *
   * <code>
   * string connection_name = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The connectionName.
   */
  @java.lang.Override
  public java.lang.String getConnectionName() {
    java.lang.Object ref = connectionName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      connectionName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. Immutable. The Cloud SQL instance for which the connection is
   * defined. Only one connection per instance is allowed. This can only be set
   * at creation time, and cannot be updated.
   *
   * It is an error to use a connection_name from different project or region
   * than the one that holds the connection.
   * For example, a Connection resource for Cloud SQL connection_name
   * `project-id:us-central1:sql-instance`
   * must be created under the parent
   * `projects/project-id/locations/us-central1`
   * </pre>
   *
   * <code>
   * string connection_name = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The bytes for connectionName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getConnectionNameBytes() {
    java.lang.Object ref = connectionName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      connectionName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int USERNAME_PASSWORD_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * A username and password stored in Secret Manager.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.SecretManagerCredential username_password = 2;</code>
   *
   * @return Whether the usernamePassword field is set.
   */
  @java.lang.Override
  public boolean hasUsernamePassword() {
    return credentialCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * A username and password stored in Secret Manager.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.SecretManagerCredential username_password = 2;</code>
   *
   * @return The usernamePassword.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.SecretManagerCredential getUsernamePassword() {
    if (credentialCase_ == 2) {
      return (com.google.privacy.dlp.v2.SecretManagerCredential) credential_;
    }
    return com.google.privacy.dlp.v2.SecretManagerCredential.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * A username and password stored in Secret Manager.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.SecretManagerCredential username_password = 2;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.SecretManagerCredentialOrBuilder getUsernamePasswordOrBuilder() {
    if (credentialCase_ == 2) {
      return (com.google.privacy.dlp.v2.SecretManagerCredential) credential_;
    }
    return com.google.privacy.dlp.v2.SecretManagerCredential.getDefaultInstance();
  }

  public static final int CLOUD_SQL_IAM_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * Built-in IAM authentication (must be configured in Cloud SQL).
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.CloudSqlIamCredential cloud_sql_iam = 3;</code>
   *
   * @return Whether the cloudSqlIam field is set.
   */
  @java.lang.Override
  public boolean hasCloudSqlIam() {
    return credentialCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * Built-in IAM authentication (must be configured in Cloud SQL).
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.CloudSqlIamCredential cloud_sql_iam = 3;</code>
   *
   * @return The cloudSqlIam.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.CloudSqlIamCredential getCloudSqlIam() {
    if (credentialCase_ == 3) {
      return (com.google.privacy.dlp.v2.CloudSqlIamCredential) credential_;
    }
    return com.google.privacy.dlp.v2.CloudSqlIamCredential.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Built-in IAM authentication (must be configured in Cloud SQL).
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.CloudSqlIamCredential cloud_sql_iam = 3;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.CloudSqlIamCredentialOrBuilder getCloudSqlIamOrBuilder() {
    if (credentialCase_ == 3) {
      return (com.google.privacy.dlp.v2.CloudSqlIamCredential) credential_;
    }
    return com.google.privacy.dlp.v2.CloudSqlIamCredential.getDefaultInstance();
  }

  public static final int MAX_CONNECTIONS_FIELD_NUMBER = 4;
  private int maxConnections_ = 0;
  /**
   *
   *
   * <pre>
   * Required. DLP will limit its connections to max_connections.
   * Must be 2 or greater.
   * </pre>
   *
   * <code>int32 max_connections = 4 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The maxConnections.
   */
  @java.lang.Override
  public int getMaxConnections() {
    return maxConnections_;
  }

  public static final int DATABASE_ENGINE_FIELD_NUMBER = 7;
  private int databaseEngine_ = 0;
  /**
   *
   *
   * <pre>
   * Required. The database engine used by the Cloud SQL instance that this
   * connection configures.
   * </pre>
   *
   * <code>
   * .google.privacy.dlp.v2.CloudSqlProperties.DatabaseEngine database_engine = 7 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The enum numeric value on the wire for databaseEngine.
   */
  @java.lang.Override
  public int getDatabaseEngineValue() {
    return databaseEngine_;
  }
  /**
   *
   *
   * <pre>
   * Required. The database engine used by the Cloud SQL instance that this
   * connection configures.
   * </pre>
   *
   * <code>
   * .google.privacy.dlp.v2.CloudSqlProperties.DatabaseEngine database_engine = 7 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The databaseEngine.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.CloudSqlProperties.DatabaseEngine getDatabaseEngine() {
    com.google.privacy.dlp.v2.CloudSqlProperties.DatabaseEngine result =
        com.google.privacy.dlp.v2.CloudSqlProperties.DatabaseEngine.forNumber(databaseEngine_);
    return result == null
        ? com.google.privacy.dlp.v2.CloudSqlProperties.DatabaseEngine.UNRECOGNIZED
        : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(connectionName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, connectionName_);
    }
    if (credentialCase_ == 2) {
      output.writeMessage(2, (com.google.privacy.dlp.v2.SecretManagerCredential) credential_);
    }
    if (credentialCase_ == 3) {
      output.writeMessage(3, (com.google.privacy.dlp.v2.CloudSqlIamCredential) credential_);
    }
    if (maxConnections_ != 0) {
      output.writeInt32(4, maxConnections_);
    }
    if (databaseEngine_
        != com.google.privacy.dlp.v2.CloudSqlProperties.DatabaseEngine.DATABASE_ENGINE_UNKNOWN
            .getNumber()) {
      output.writeEnum(7, databaseEngine_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(connectionName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, connectionName_);
    }
    if (credentialCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.privacy.dlp.v2.SecretManagerCredential) credential_);
    }
    if (credentialCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.privacy.dlp.v2.CloudSqlIamCredential) credential_);
    }
    if (maxConnections_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(4, maxConnections_);
    }
    if (databaseEngine_
        != com.google.privacy.dlp.v2.CloudSqlProperties.DatabaseEngine.DATABASE_ENGINE_UNKNOWN
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(7, databaseEngine_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.privacy.dlp.v2.CloudSqlProperties)) {
      return super.equals(obj);
    }
    com.google.privacy.dlp.v2.CloudSqlProperties other =
        (com.google.privacy.dlp.v2.CloudSqlProperties) obj;

    if (!getConnectionName().equals(other.getConnectionName())) return false;
    if (getMaxConnections() != other.getMaxConnections()) return false;
    if (databaseEngine_ != other.databaseEngine_) return false;
    if (!getCredentialCase().equals(other.getCredentialCase())) return false;
    switch (credentialCase_) {
      case 2:
        if (!getUsernamePassword().equals(other.getUsernamePassword())) return false;
        break;
      case 3:
        if (!getCloudSqlIam().equals(other.getCloudSqlIam())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + CONNECTION_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getConnectionName().hashCode();
    hash = (37 * hash) + MAX_CONNECTIONS_FIELD_NUMBER;
    hash = (53 * hash) + getMaxConnections();
    hash = (37 * hash) + DATABASE_ENGINE_FIELD_NUMBER;
    hash = (53 * hash) + databaseEngine_;
    switch (credentialCase_) {
      case 2:
        hash = (37 * hash) + USERNAME_PASSWORD_FIELD_NUMBER;
        hash = (53 * hash) + getUsernamePassword().hashCode();
        break;
      case 3:
        hash = (37 * hash) + CLOUD_SQL_IAM_FIELD_NUMBER;
        hash = (53 * hash) + getCloudSqlIam().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.privacy.dlp.v2.CloudSqlProperties parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.CloudSqlProperties parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.CloudSqlProperties parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.CloudSqlProperties parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.CloudSqlProperties parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.CloudSqlProperties parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.CloudSqlProperties parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.CloudSqlProperties parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.CloudSqlProperties parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.CloudSqlProperties parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.CloudSqlProperties parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.CloudSqlProperties parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.privacy.dlp.v2.CloudSqlProperties prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Cloud SQL connection properties.
   * </pre>
   *
   * Protobuf type {@code google.privacy.dlp.v2.CloudSqlProperties}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.privacy.dlp.v2.CloudSqlProperties)
      com.google.privacy.dlp.v2.CloudSqlPropertiesOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_CloudSqlProperties_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_CloudSqlProperties_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.privacy.dlp.v2.CloudSqlProperties.class,
              com.google.privacy.dlp.v2.CloudSqlProperties.Builder.class);
    }

    // Construct using com.google.privacy.dlp.v2.CloudSqlProperties.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      connectionName_ = "";
      if (usernamePasswordBuilder_ != null) {
        usernamePasswordBuilder_.clear();
      }
      if (cloudSqlIamBuilder_ != null) {
        cloudSqlIamBuilder_.clear();
      }
      maxConnections_ = 0;
      databaseEngine_ = 0;
      credentialCase_ = 0;
      credential_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_CloudSqlProperties_descriptor;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.CloudSqlProperties getDefaultInstanceForType() {
      return com.google.privacy.dlp.v2.CloudSqlProperties.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.CloudSqlProperties build() {
      com.google.privacy.dlp.v2.CloudSqlProperties result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.CloudSqlProperties buildPartial() {
      com.google.privacy.dlp.v2.CloudSqlProperties result =
          new com.google.privacy.dlp.v2.CloudSqlProperties(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.privacy.dlp.v2.CloudSqlProperties result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.connectionName_ = connectionName_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.maxConnections_ = maxConnections_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.databaseEngine_ = databaseEngine_;
      }
    }

    private void buildPartialOneofs(com.google.privacy.dlp.v2.CloudSqlProperties result) {
      result.credentialCase_ = credentialCase_;
      result.credential_ = this.credential_;
      if (credentialCase_ == 2 && usernamePasswordBuilder_ != null) {
        result.credential_ = usernamePasswordBuilder_.build();
      }
      if (credentialCase_ == 3 && cloudSqlIamBuilder_ != null) {
        result.credential_ = cloudSqlIamBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.privacy.dlp.v2.CloudSqlProperties) {
        return mergeFrom((com.google.privacy.dlp.v2.CloudSqlProperties) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.privacy.dlp.v2.CloudSqlProperties other) {
      if (other == com.google.privacy.dlp.v2.CloudSqlProperties.getDefaultInstance()) return this;
      if (!other.getConnectionName().isEmpty()) {
        connectionName_ = other.connectionName_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.getMaxConnections() != 0) {
        setMaxConnections(other.getMaxConnections());
      }
      if (other.databaseEngine_ != 0) {
        setDatabaseEngineValue(other.getDatabaseEngineValue());
      }
      switch (other.getCredentialCase()) {
        case USERNAME_PASSWORD:
          {
            mergeUsernamePassword(other.getUsernamePassword());
            break;
          }
        case CLOUD_SQL_IAM:
          {
            mergeCloudSqlIam(other.getCloudSqlIam());
            break;
          }
        case CREDENTIAL_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                connectionName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(
                    getUsernamePasswordFieldBuilder().getBuilder(), extensionRegistry);
                credentialCase_ = 2;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getCloudSqlIamFieldBuilder().getBuilder(), extensionRegistry);
                credentialCase_ = 3;
                break;
              } // case 26
            case 32:
              {
                maxConnections_ = input.readInt32();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            case 56:
              {
                databaseEngine_ = input.readEnum();
                bitField0_ |= 0x00000010;
                break;
              } // case 56
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int credentialCase_ = 0;
    private java.lang.Object credential_;

    public CredentialCase getCredentialCase() {
      return CredentialCase.forNumber(credentialCase_);
    }

    public Builder clearCredential() {
      credentialCase_ = 0;
      credential_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object connectionName_ = "";
    /**
     *
     *
     * <pre>
     * Optional. Immutable. The Cloud SQL instance for which the connection is
     * defined. Only one connection per instance is allowed. This can only be set
     * at creation time, and cannot be updated.
     *
     * It is an error to use a connection_name from different project or region
     * than the one that holds the connection.
     * For example, a Connection resource for Cloud SQL connection_name
     * `project-id:us-central1:sql-instance`
     * must be created under the parent
     * `projects/project-id/locations/us-central1`
     * </pre>
     *
     * <code>
     * string connection_name = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The connectionName.
     */
    public java.lang.String getConnectionName() {
      java.lang.Object ref = connectionName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        connectionName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Immutable. The Cloud SQL instance for which the connection is
     * defined. Only one connection per instance is allowed. This can only be set
     * at creation time, and cannot be updated.
     *
     * It is an error to use a connection_name from different project or region
     * than the one that holds the connection.
     * For example, a Connection resource for Cloud SQL connection_name
     * `project-id:us-central1:sql-instance`
     * must be created under the parent
     * `projects/project-id/locations/us-central1`
     * </pre>
     *
     * <code>
     * string connection_name = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The bytes for connectionName.
     */
    public com.google.protobuf.ByteString getConnectionNameBytes() {
      java.lang.Object ref = connectionName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        connectionName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Immutable. The Cloud SQL instance for which the connection is
     * defined. Only one connection per instance is allowed. This can only be set
     * at creation time, and cannot be updated.
     *
     * It is an error to use a connection_name from different project or region
     * than the one that holds the connection.
     * For example, a Connection resource for Cloud SQL connection_name
     * `project-id:us-central1:sql-instance`
     * must be created under the parent
     * `projects/project-id/locations/us-central1`
     * </pre>
     *
     * <code>
     * string connection_name = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The connectionName to set.
     * @return This builder for chaining.
     */
    public Builder setConnectionName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      connectionName_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Immutable. The Cloud SQL instance for which the connection is
     * defined. Only one connection per instance is allowed. This can only be set
     * at creation time, and cannot be updated.
     *
     * It is an error to use a connection_name from different project or region
     * than the one that holds the connection.
     * For example, a Connection resource for Cloud SQL connection_name
     * `project-id:us-central1:sql-instance`
     * must be created under the parent
     * `projects/project-id/locations/us-central1`
     * </pre>
     *
     * <code>
     * string connection_name = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearConnectionName() {
      connectionName_ = getDefaultInstance().getConnectionName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Immutable. The Cloud SQL instance for which the connection is
     * defined. Only one connection per instance is allowed. This can only be set
     * at creation time, and cannot be updated.
     *
     * It is an error to use a connection_name from different project or region
     * than the one that holds the connection.
     * For example, a Connection resource for Cloud SQL connection_name
     * `project-id:us-central1:sql-instance`
     * must be created under the parent
     * `projects/project-id/locations/us-central1`
     * </pre>
     *
     * <code>
     * string connection_name = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The bytes for connectionName to set.
     * @return This builder for chaining.
     */
    public Builder setConnectionNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      connectionName_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.SecretManagerCredential,
            com.google.privacy.dlp.v2.SecretManagerCredential.Builder,
            com.google.privacy.dlp.v2.SecretManagerCredentialOrBuilder>
        usernamePasswordBuilder_;
    /**
     *
     *
     * <pre>
     * A username and password stored in Secret Manager.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.SecretManagerCredential username_password = 2;</code>
     *
     * @return Whether the usernamePassword field is set.
     */
    @java.lang.Override
    public boolean hasUsernamePassword() {
      return credentialCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * A username and password stored in Secret Manager.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.SecretManagerCredential username_password = 2;</code>
     *
     * @return The usernamePassword.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.SecretManagerCredential getUsernamePassword() {
      if (usernamePasswordBuilder_ == null) {
        if (credentialCase_ == 2) {
          return (com.google.privacy.dlp.v2.SecretManagerCredential) credential_;
        }
        return com.google.privacy.dlp.v2.SecretManagerCredential.getDefaultInstance();
      } else {
        if (credentialCase_ == 2) {
          return usernamePasswordBuilder_.getMessage();
        }
        return com.google.privacy.dlp.v2.SecretManagerCredential.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A username and password stored in Secret Manager.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.SecretManagerCredential username_password = 2;</code>
     */
    public Builder setUsernamePassword(com.google.privacy.dlp.v2.SecretManagerCredential value) {
      if (usernamePasswordBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        credential_ = value;
        onChanged();
      } else {
        usernamePasswordBuilder_.setMessage(value);
      }
      credentialCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A username and password stored in Secret Manager.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.SecretManagerCredential username_password = 2;</code>
     */
    public Builder setUsernamePassword(
        com.google.privacy.dlp.v2.SecretManagerCredential.Builder builderForValue) {
      if (usernamePasswordBuilder_ == null) {
        credential_ = builderForValue.build();
        onChanged();
      } else {
        usernamePasswordBuilder_.setMessage(builderForValue.build());
      }
      credentialCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A username and password stored in Secret Manager.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.SecretManagerCredential username_password = 2;</code>
     */
    public Builder mergeUsernamePassword(com.google.privacy.dlp.v2.SecretManagerCredential value) {
      if (usernamePasswordBuilder_ == null) {
        if (credentialCase_ == 2
            && credential_
                != com.google.privacy.dlp.v2.SecretManagerCredential.getDefaultInstance()) {
          credential_ =
              com.google.privacy.dlp.v2.SecretManagerCredential.newBuilder(
                      (com.google.privacy.dlp.v2.SecretManagerCredential) credential_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          credential_ = value;
        }
        onChanged();
      } else {
        if (credentialCase_ == 2) {
          usernamePasswordBuilder_.mergeFrom(value);
        } else {
          usernamePasswordBuilder_.setMessage(value);
        }
      }
      credentialCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A username and password stored in Secret Manager.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.SecretManagerCredential username_password = 2;</code>
     */
    public Builder clearUsernamePassword() {
      if (usernamePasswordBuilder_ == null) {
        if (credentialCase_ == 2) {
          credentialCase_ = 0;
          credential_ = null;
          onChanged();
        }
      } else {
        if (credentialCase_ == 2) {
          credentialCase_ = 0;
          credential_ = null;
        }
        usernamePasswordBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A username and password stored in Secret Manager.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.SecretManagerCredential username_password = 2;</code>
     */
    public com.google.privacy.dlp.v2.SecretManagerCredential.Builder getUsernamePasswordBuilder() {
      return getUsernamePasswordFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A username and password stored in Secret Manager.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.SecretManagerCredential username_password = 2;</code>
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.SecretManagerCredentialOrBuilder
        getUsernamePasswordOrBuilder() {
      if ((credentialCase_ == 2) && (usernamePasswordBuilder_ != null)) {
        return usernamePasswordBuilder_.getMessageOrBuilder();
      } else {
        if (credentialCase_ == 2) {
          return (com.google.privacy.dlp.v2.SecretManagerCredential) credential_;
        }
        return com.google.privacy.dlp.v2.SecretManagerCredential.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A username and password stored in Secret Manager.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.SecretManagerCredential username_password = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.SecretManagerCredential,
            com.google.privacy.dlp.v2.SecretManagerCredential.Builder,
            com.google.privacy.dlp.v2.SecretManagerCredentialOrBuilder>
        getUsernamePasswordFieldBuilder() {
      if (usernamePasswordBuilder_ == null) {
        if (!(credentialCase_ == 2)) {
          credential_ = com.google.privacy.dlp.v2.SecretManagerCredential.getDefaultInstance();
        }
        usernamePasswordBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.SecretManagerCredential,
                com.google.privacy.dlp.v2.SecretManagerCredential.Builder,
                com.google.privacy.dlp.v2.SecretManagerCredentialOrBuilder>(
                (com.google.privacy.dlp.v2.SecretManagerCredential) credential_,
                getParentForChildren(),
                isClean());
        credential_ = null;
      }
      credentialCase_ = 2;
      onChanged();
      return usernamePasswordBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.CloudSqlIamCredential,
            com.google.privacy.dlp.v2.CloudSqlIamCredential.Builder,
            com.google.privacy.dlp.v2.CloudSqlIamCredentialOrBuilder>
        cloudSqlIamBuilder_;
    /**
     *
     *
     * <pre>
     * Built-in IAM authentication (must be configured in Cloud SQL).
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CloudSqlIamCredential cloud_sql_iam = 3;</code>
     *
     * @return Whether the cloudSqlIam field is set.
     */
    @java.lang.Override
    public boolean hasCloudSqlIam() {
      return credentialCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * Built-in IAM authentication (must be configured in Cloud SQL).
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CloudSqlIamCredential cloud_sql_iam = 3;</code>
     *
     * @return The cloudSqlIam.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.CloudSqlIamCredential getCloudSqlIam() {
      if (cloudSqlIamBuilder_ == null) {
        if (credentialCase_ == 3) {
          return (com.google.privacy.dlp.v2.CloudSqlIamCredential) credential_;
        }
        return com.google.privacy.dlp.v2.CloudSqlIamCredential.getDefaultInstance();
      } else {
        if (credentialCase_ == 3) {
          return cloudSqlIamBuilder_.getMessage();
        }
        return com.google.privacy.dlp.v2.CloudSqlIamCredential.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Built-in IAM authentication (must be configured in Cloud SQL).
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CloudSqlIamCredential cloud_sql_iam = 3;</code>
     */
    public Builder setCloudSqlIam(com.google.privacy.dlp.v2.CloudSqlIamCredential value) {
      if (cloudSqlIamBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        credential_ = value;
        onChanged();
      } else {
        cloudSqlIamBuilder_.setMessage(value);
      }
      credentialCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Built-in IAM authentication (must be configured in Cloud SQL).
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CloudSqlIamCredential cloud_sql_iam = 3;</code>
     */
    public Builder setCloudSqlIam(
        com.google.privacy.dlp.v2.CloudSqlIamCredential.Builder builderForValue) {
      if (cloudSqlIamBuilder_ == null) {
        credential_ = builderForValue.build();
        onChanged();
      } else {
        cloudSqlIamBuilder_.setMessage(builderForValue.build());
      }
      credentialCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Built-in IAM authentication (must be configured in Cloud SQL).
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CloudSqlIamCredential cloud_sql_iam = 3;</code>
     */
    public Builder mergeCloudSqlIam(com.google.privacy.dlp.v2.CloudSqlIamCredential value) {
      if (cloudSqlIamBuilder_ == null) {
        if (credentialCase_ == 3
            && credential_
                != com.google.privacy.dlp.v2.CloudSqlIamCredential.getDefaultInstance()) {
          credential_ =
              com.google.privacy.dlp.v2.CloudSqlIamCredential.newBuilder(
                      (com.google.privacy.dlp.v2.CloudSqlIamCredential) credential_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          credential_ = value;
        }
        onChanged();
      } else {
        if (credentialCase_ == 3) {
          cloudSqlIamBuilder_.mergeFrom(value);
        } else {
          cloudSqlIamBuilder_.setMessage(value);
        }
      }
      credentialCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Built-in IAM authentication (must be configured in Cloud SQL).
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CloudSqlIamCredential cloud_sql_iam = 3;</code>
     */
    public Builder clearCloudSqlIam() {
      if (cloudSqlIamBuilder_ == null) {
        if (credentialCase_ == 3) {
          credentialCase_ = 0;
          credential_ = null;
          onChanged();
        }
      } else {
        if (credentialCase_ == 3) {
          credentialCase_ = 0;
          credential_ = null;
        }
        cloudSqlIamBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Built-in IAM authentication (must be configured in Cloud SQL).
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CloudSqlIamCredential cloud_sql_iam = 3;</code>
     */
    public com.google.privacy.dlp.v2.CloudSqlIamCredential.Builder getCloudSqlIamBuilder() {
      return getCloudSqlIamFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Built-in IAM authentication (must be configured in Cloud SQL).
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CloudSqlIamCredential cloud_sql_iam = 3;</code>
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.CloudSqlIamCredentialOrBuilder getCloudSqlIamOrBuilder() {
      if ((credentialCase_ == 3) && (cloudSqlIamBuilder_ != null)) {
        return cloudSqlIamBuilder_.getMessageOrBuilder();
      } else {
        if (credentialCase_ == 3) {
          return (com.google.privacy.dlp.v2.CloudSqlIamCredential) credential_;
        }
        return com.google.privacy.dlp.v2.CloudSqlIamCredential.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Built-in IAM authentication (must be configured in Cloud SQL).
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CloudSqlIamCredential cloud_sql_iam = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.CloudSqlIamCredential,
            com.google.privacy.dlp.v2.CloudSqlIamCredential.Builder,
            com.google.privacy.dlp.v2.CloudSqlIamCredentialOrBuilder>
        getCloudSqlIamFieldBuilder() {
      if (cloudSqlIamBuilder_ == null) {
        if (!(credentialCase_ == 3)) {
          credential_ = com.google.privacy.dlp.v2.CloudSqlIamCredential.getDefaultInstance();
        }
        cloudSqlIamBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.CloudSqlIamCredential,
                com.google.privacy.dlp.v2.CloudSqlIamCredential.Builder,
                com.google.privacy.dlp.v2.CloudSqlIamCredentialOrBuilder>(
                (com.google.privacy.dlp.v2.CloudSqlIamCredential) credential_,
                getParentForChildren(),
                isClean());
        credential_ = null;
      }
      credentialCase_ = 3;
      onChanged();
      return cloudSqlIamBuilder_;
    }

    private int maxConnections_;
    /**
     *
     *
     * <pre>
     * Required. DLP will limit its connections to max_connections.
     * Must be 2 or greater.
     * </pre>
     *
     * <code>int32 max_connections = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The maxConnections.
     */
    @java.lang.Override
    public int getMaxConnections() {
      return maxConnections_;
    }
    /**
     *
     *
     * <pre>
     * Required. DLP will limit its connections to max_connections.
     * Must be 2 or greater.
     * </pre>
     *
     * <code>int32 max_connections = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The maxConnections to set.
     * @return This builder for chaining.
     */
    public Builder setMaxConnections(int value) {

      maxConnections_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. DLP will limit its connections to max_connections.
     * Must be 2 or greater.
     * </pre>
     *
     * <code>int32 max_connections = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMaxConnections() {
      bitField0_ = (bitField0_ & ~0x00000008);
      maxConnections_ = 0;
      onChanged();
      return this;
    }

    private int databaseEngine_ = 0;
    /**
     *
     *
     * <pre>
     * Required. The database engine used by the Cloud SQL instance that this
     * connection configures.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.CloudSqlProperties.DatabaseEngine database_engine = 7 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The enum numeric value on the wire for databaseEngine.
     */
    @java.lang.Override
    public int getDatabaseEngineValue() {
      return databaseEngine_;
    }
    /**
     *
     *
     * <pre>
     * Required. The database engine used by the Cloud SQL instance that this
     * connection configures.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.CloudSqlProperties.DatabaseEngine database_engine = 7 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The enum numeric value on the wire for databaseEngine to set.
     * @return This builder for chaining.
     */
    public Builder setDatabaseEngineValue(int value) {
      databaseEngine_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The database engine used by the Cloud SQL instance that this
     * connection configures.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.CloudSqlProperties.DatabaseEngine database_engine = 7 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The databaseEngine.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.CloudSqlProperties.DatabaseEngine getDatabaseEngine() {
      com.google.privacy.dlp.v2.CloudSqlProperties.DatabaseEngine result =
          com.google.privacy.dlp.v2.CloudSqlProperties.DatabaseEngine.forNumber(databaseEngine_);
      return result == null
          ? com.google.privacy.dlp.v2.CloudSqlProperties.DatabaseEngine.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Required. The database engine used by the Cloud SQL instance that this
     * connection configures.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.CloudSqlProperties.DatabaseEngine database_engine = 7 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The databaseEngine to set.
     * @return This builder for chaining.
     */
    public Builder setDatabaseEngine(
        com.google.privacy.dlp.v2.CloudSqlProperties.DatabaseEngine value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000010;
      databaseEngine_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The database engine used by the Cloud SQL instance that this
     * connection configures.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.CloudSqlProperties.DatabaseEngine database_engine = 7 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDatabaseEngine() {
      bitField0_ = (bitField0_ & ~0x00000010);
      databaseEngine_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.privacy.dlp.v2.CloudSqlProperties)
  }

  // @@protoc_insertion_point(class_scope:google.privacy.dlp.v2.CloudSqlProperties)
  private static final com.google.privacy.dlp.v2.CloudSqlProperties DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.privacy.dlp.v2.CloudSqlProperties();
  }

  public static com.google.privacy.dlp.v2.CloudSqlProperties getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CloudSqlProperties> PARSER =
      new com.google.protobuf.AbstractParser<CloudSqlProperties>() {
        @java.lang.Override
        public CloudSqlProperties parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<CloudSqlProperties> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CloudSqlProperties> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.privacy.dlp.v2.CloudSqlProperties getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
