/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/privacy/dlp/v2/dlp.proto

// Protobuf Java Version: 3.25.3
package com.google.privacy.dlp.v2;

public interface CloudSqlPropertiesOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.privacy.dlp.v2.CloudSqlProperties)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Optional. Immutable. The Cloud SQL instance for which the connection is
   * defined. Only one connection per instance is allowed. This can only be set
   * at creation time, and cannot be updated.
   *
   * It is an error to use a connection_name from different project or region
   * than the one that holds the connection.
   * For example, a Connection resource for Cloud SQL connection_name
   * `project-id:us-central1:sql-instance`
   * must be created under the parent
   * `projects/project-id/locations/us-central1`
   * </pre>
   *
   * <code>
   * string connection_name = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The connectionName.
   */
  java.lang.String getConnectionName();
  /**
   *
   *
   * <pre>
   * Optional. Immutable. The Cloud SQL instance for which the connection is
   * defined. Only one connection per instance is allowed. This can only be set
   * at creation time, and cannot be updated.
   *
   * It is an error to use a connection_name from different project or region
   * than the one that holds the connection.
   * For example, a Connection resource for Cloud SQL connection_name
   * `project-id:us-central1:sql-instance`
   * must be created under the parent
   * `projects/project-id/locations/us-central1`
   * </pre>
   *
   * <code>
   * string connection_name = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The bytes for connectionName.
   */
  com.google.protobuf.ByteString getConnectionNameBytes();

  /**
   *
   *
   * <pre>
   * A username and password stored in Secret Manager.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.SecretManagerCredential username_password = 2;</code>
   *
   * @return Whether the usernamePassword field is set.
   */
  boolean hasUsernamePassword();
  /**
   *
   *
   * <pre>
   * A username and password stored in Secret Manager.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.SecretManagerCredential username_password = 2;</code>
   *
   * @return The usernamePassword.
   */
  com.google.privacy.dlp.v2.SecretManagerCredential getUsernamePassword();
  /**
   *
   *
   * <pre>
   * A username and password stored in Secret Manager.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.SecretManagerCredential username_password = 2;</code>
   */
  com.google.privacy.dlp.v2.SecretManagerCredentialOrBuilder getUsernamePasswordOrBuilder();

  /**
   *
   *
   * <pre>
   * Built-in IAM authentication (must be configured in Cloud SQL).
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.CloudSqlIamCredential cloud_sql_iam = 3;</code>
   *
   * @return Whether the cloudSqlIam field is set.
   */
  boolean hasCloudSqlIam();
  /**
   *
   *
   * <pre>
   * Built-in IAM authentication (must be configured in Cloud SQL).
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.CloudSqlIamCredential cloud_sql_iam = 3;</code>
   *
   * @return The cloudSqlIam.
   */
  com.google.privacy.dlp.v2.CloudSqlIamCredential getCloudSqlIam();
  /**
   *
   *
   * <pre>
   * Built-in IAM authentication (must be configured in Cloud SQL).
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.CloudSqlIamCredential cloud_sql_iam = 3;</code>
   */
  com.google.privacy.dlp.v2.CloudSqlIamCredentialOrBuilder getCloudSqlIamOrBuilder();

  /**
   *
   *
   * <pre>
   * Required. DLP will limit its connections to max_connections.
   * Must be 2 or greater.
   * </pre>
   *
   * <code>int32 max_connections = 4 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The maxConnections.
   */
  int getMaxConnections();

  /**
   *
   *
   * <pre>
   * Required. The database engine used by the Cloud SQL instance that this
   * connection configures.
   * </pre>
   *
   * <code>
   * .google.privacy.dlp.v2.CloudSqlProperties.DatabaseEngine database_engine = 7 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The enum numeric value on the wire for databaseEngine.
   */
  int getDatabaseEngineValue();
  /**
   *
   *
   * <pre>
   * Required. The database engine used by the Cloud SQL instance that this
   * connection configures.
   * </pre>
   *
   * <code>
   * .google.privacy.dlp.v2.CloudSqlProperties.DatabaseEngine database_engine = 7 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The databaseEngine.
   */
  com.google.privacy.dlp.v2.CloudSqlProperties.DatabaseEngine getDatabaseEngine();

  com.google.privacy.dlp.v2.CloudSqlProperties.CredentialCase getCredentialCase();
}
