/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/privacy/dlp/v2/dlp.proto

// Protobuf Java Version: 3.25.3
package com.google.privacy.dlp.v2;

/**
 *
 *
 * <pre>
 * The profile for a scanned column within a table.
 * </pre>
 *
 * Protobuf type {@code google.privacy.dlp.v2.ColumnDataProfile}
 */
public final class ColumnDataProfile extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.privacy.dlp.v2.ColumnDataProfile)
    ColumnDataProfileOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ColumnDataProfile.newBuilder() to construct.
  private ColumnDataProfile(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ColumnDataProfile() {
    name_ = "";
    state_ = 0;
    tableDataProfile_ = "";
    tableFullResource_ = "";
    datasetProjectId_ = "";
    datasetLocation_ = "";
    datasetId_ = "";
    tableId_ = "";
    column_ = "";
    otherMatches_ = java.util.Collections.emptyList();
    estimatedNullPercentage_ = 0;
    estimatedUniquenessScore_ = 0;
    columnType_ = 0;
    policyState_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ColumnDataProfile();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.privacy.dlp.v2.DlpProto
        .internal_static_google_privacy_dlp_v2_ColumnDataProfile_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.privacy.dlp.v2.DlpProto
        .internal_static_google_privacy_dlp_v2_ColumnDataProfile_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.privacy.dlp.v2.ColumnDataProfile.class,
            com.google.privacy.dlp.v2.ColumnDataProfile.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Possible states of a profile. New items may be added.
   * </pre>
   *
   * Protobuf enum {@code google.privacy.dlp.v2.ColumnDataProfile.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unused.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The profile is currently running. Once a profile has finished it will
     * transition to DONE.
     * </pre>
     *
     * <code>RUNNING = 1;</code>
     */
    RUNNING(1),
    /**
     *
     *
     * <pre>
     * The profile is no longer generating.
     * If profile_status.status.code is 0, the profile succeeded, otherwise, it
     * failed.
     * </pre>
     *
     * <code>DONE = 2;</code>
     */
    DONE(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unused.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    public static final int STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The profile is currently running. Once a profile has finished it will
     * transition to DONE.
     * </pre>
     *
     * <code>RUNNING = 1;</code>
     */
    public static final int RUNNING_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The profile is no longer generating.
     * If profile_status.status.code is 0, the profile succeeded, otherwise, it
     * failed.
     * </pre>
     *
     * <code>DONE = 2;</code>
     */
    public static final int DONE_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return STATE_UNSPECIFIED;
        case 1:
          return RUNNING;
        case 2:
          return DONE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.privacy.dlp.v2.ColumnDataProfile.getDescriptor().getEnumTypes().get(0);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.privacy.dlp.v2.ColumnDataProfile.State)
  }

  /**
   *
   *
   * <pre>
   * Data types of the data in a column. Types may be added over time.
   * </pre>
   *
   * Protobuf enum {@code google.privacy.dlp.v2.ColumnDataProfile.ColumnDataType}
   */
  public enum ColumnDataType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Invalid type.
     * </pre>
     *
     * <code>COLUMN_DATA_TYPE_UNSPECIFIED = 0;</code>
     */
    COLUMN_DATA_TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Encoded as a string in decimal format.
     * </pre>
     *
     * <code>TYPE_INT64 = 1;</code>
     */
    TYPE_INT64(1),
    /**
     *
     *
     * <pre>
     * Encoded as a boolean "false" or "true".
     * </pre>
     *
     * <code>TYPE_BOOL = 2;</code>
     */
    TYPE_BOOL(2),
    /**
     *
     *
     * <pre>
     * Encoded as a number, or string "NaN", "Infinity" or "-Infinity".
     * </pre>
     *
     * <code>TYPE_FLOAT64 = 3;</code>
     */
    TYPE_FLOAT64(3),
    /**
     *
     *
     * <pre>
     * Encoded as a string value.
     * </pre>
     *
     * <code>TYPE_STRING = 4;</code>
     */
    TYPE_STRING(4),
    /**
     *
     *
     * <pre>
     * Encoded as a base64 string per RFC 4648, section 4.
     * </pre>
     *
     * <code>TYPE_BYTES = 5;</code>
     */
    TYPE_BYTES(5),
    /**
     *
     *
     * <pre>
     * Encoded as an RFC 3339 timestamp with mandatory "Z" time zone string:
     * 1985-04-12T23:20:50.52Z
     * </pre>
     *
     * <code>TYPE_TIMESTAMP = 6;</code>
     */
    TYPE_TIMESTAMP(6),
    /**
     *
     *
     * <pre>
     * Encoded as RFC 3339 full-date format string: 1985-04-12
     * </pre>
     *
     * <code>TYPE_DATE = 7;</code>
     */
    TYPE_DATE(7),
    /**
     *
     *
     * <pre>
     * Encoded as RFC 3339 partial-time format string: 23:20:50.52
     * </pre>
     *
     * <code>TYPE_TIME = 8;</code>
     */
    TYPE_TIME(8),
    /**
     *
     *
     * <pre>
     * Encoded as RFC 3339 full-date "T" partial-time: 1985-04-12T23:20:50.52
     * </pre>
     *
     * <code>TYPE_DATETIME = 9;</code>
     */
    TYPE_DATETIME(9),
    /**
     *
     *
     * <pre>
     * Encoded as WKT
     * </pre>
     *
     * <code>TYPE_GEOGRAPHY = 10;</code>
     */
    TYPE_GEOGRAPHY(10),
    /**
     *
     *
     * <pre>
     * Encoded as a decimal string.
     * </pre>
     *
     * <code>TYPE_NUMERIC = 11;</code>
     */
    TYPE_NUMERIC(11),
    /**
     *
     *
     * <pre>
     * Container of ordered fields, each with a type and field name.
     * </pre>
     *
     * <code>TYPE_RECORD = 12;</code>
     */
    TYPE_RECORD(12),
    /**
     *
     *
     * <pre>
     * Decimal type.
     * </pre>
     *
     * <code>TYPE_BIGNUMERIC = 13;</code>
     */
    TYPE_BIGNUMERIC(13),
    /**
     *
     *
     * <pre>
     * Json type.
     * </pre>
     *
     * <code>TYPE_JSON = 14;</code>
     */
    TYPE_JSON(14),
    /**
     *
     *
     * <pre>
     * Interval type.
     * </pre>
     *
     * <code>TYPE_INTERVAL = 15;</code>
     */
    TYPE_INTERVAL(15),
    /**
     *
     *
     * <pre>
     * `Range&lt;Date&gt;` type.
     * </pre>
     *
     * <code>TYPE_RANGE_DATE = 16;</code>
     */
    TYPE_RANGE_DATE(16),
    /**
     *
     *
     * <pre>
     * `Range&lt;Datetime&gt;` type.
     * </pre>
     *
     * <code>TYPE_RANGE_DATETIME = 17;</code>
     */
    TYPE_RANGE_DATETIME(17),
    /**
     *
     *
     * <pre>
     * `Range&lt;Timestamp&gt;` type.
     * </pre>
     *
     * <code>TYPE_RANGE_TIMESTAMP = 18;</code>
     */
    TYPE_RANGE_TIMESTAMP(18),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Invalid type.
     * </pre>
     *
     * <code>COLUMN_DATA_TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int COLUMN_DATA_TYPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Encoded as a string in decimal format.
     * </pre>
     *
     * <code>TYPE_INT64 = 1;</code>
     */
    public static final int TYPE_INT64_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Encoded as a boolean "false" or "true".
     * </pre>
     *
     * <code>TYPE_BOOL = 2;</code>
     */
    public static final int TYPE_BOOL_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Encoded as a number, or string "NaN", "Infinity" or "-Infinity".
     * </pre>
     *
     * <code>TYPE_FLOAT64 = 3;</code>
     */
    public static final int TYPE_FLOAT64_VALUE = 3;
    /**
     *
     *
     * <pre>
     * Encoded as a string value.
     * </pre>
     *
     * <code>TYPE_STRING = 4;</code>
     */
    public static final int TYPE_STRING_VALUE = 4;
    /**
     *
     *
     * <pre>
     * Encoded as a base64 string per RFC 4648, section 4.
     * </pre>
     *
     * <code>TYPE_BYTES = 5;</code>
     */
    public static final int TYPE_BYTES_VALUE = 5;
    /**
     *
     *
     * <pre>
     * Encoded as an RFC 3339 timestamp with mandatory "Z" time zone string:
     * 1985-04-12T23:20:50.52Z
     * </pre>
     *
     * <code>TYPE_TIMESTAMP = 6;</code>
     */
    public static final int TYPE_TIMESTAMP_VALUE = 6;
    /**
     *
     *
     * <pre>
     * Encoded as RFC 3339 full-date format string: 1985-04-12
     * </pre>
     *
     * <code>TYPE_DATE = 7;</code>
     */
    public static final int TYPE_DATE_VALUE = 7;
    /**
     *
     *
     * <pre>
     * Encoded as RFC 3339 partial-time format string: 23:20:50.52
     * </pre>
     *
     * <code>TYPE_TIME = 8;</code>
     */
    public static final int TYPE_TIME_VALUE = 8;
    /**
     *
     *
     * <pre>
     * Encoded as RFC 3339 full-date "T" partial-time: 1985-04-12T23:20:50.52
     * </pre>
     *
     * <code>TYPE_DATETIME = 9;</code>
     */
    public static final int TYPE_DATETIME_VALUE = 9;
    /**
     *
     *
     * <pre>
     * Encoded as WKT
     * </pre>
     *
     * <code>TYPE_GEOGRAPHY = 10;</code>
     */
    public static final int TYPE_GEOGRAPHY_VALUE = 10;
    /**
     *
     *
     * <pre>
     * Encoded as a decimal string.
     * </pre>
     *
     * <code>TYPE_NUMERIC = 11;</code>
     */
    public static final int TYPE_NUMERIC_VALUE = 11;
    /**
     *
     *
     * <pre>
     * Container of ordered fields, each with a type and field name.
     * </pre>
     *
     * <code>TYPE_RECORD = 12;</code>
     */
    public static final int TYPE_RECORD_VALUE = 12;
    /**
     *
     *
     * <pre>
     * Decimal type.
     * </pre>
     *
     * <code>TYPE_BIGNUMERIC = 13;</code>
     */
    public static final int TYPE_BIGNUMERIC_VALUE = 13;
    /**
     *
     *
     * <pre>
     * Json type.
     * </pre>
     *
     * <code>TYPE_JSON = 14;</code>
     */
    public static final int TYPE_JSON_VALUE = 14;
    /**
     *
     *
     * <pre>
     * Interval type.
     * </pre>
     *
     * <code>TYPE_INTERVAL = 15;</code>
     */
    public static final int TYPE_INTERVAL_VALUE = 15;
    /**
     *
     *
     * <pre>
     * `Range&lt;Date&gt;` type.
     * </pre>
     *
     * <code>TYPE_RANGE_DATE = 16;</code>
     */
    public static final int TYPE_RANGE_DATE_VALUE = 16;
    /**
     *
     *
     * <pre>
     * `Range&lt;Datetime&gt;` type.
     * </pre>
     *
     * <code>TYPE_RANGE_DATETIME = 17;</code>
     */
    public static final int TYPE_RANGE_DATETIME_VALUE = 17;
    /**
     *
     *
     * <pre>
     * `Range&lt;Timestamp&gt;` type.
     * </pre>
     *
     * <code>TYPE_RANGE_TIMESTAMP = 18;</code>
     */
    public static final int TYPE_RANGE_TIMESTAMP_VALUE = 18;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ColumnDataType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static ColumnDataType forNumber(int value) {
      switch (value) {
        case 0:
          return COLUMN_DATA_TYPE_UNSPECIFIED;
        case 1:
          return TYPE_INT64;
        case 2:
          return TYPE_BOOL;
        case 3:
          return TYPE_FLOAT64;
        case 4:
          return TYPE_STRING;
        case 5:
          return TYPE_BYTES;
        case 6:
          return TYPE_TIMESTAMP;
        case 7:
          return TYPE_DATE;
        case 8:
          return TYPE_TIME;
        case 9:
          return TYPE_DATETIME;
        case 10:
          return TYPE_GEOGRAPHY;
        case 11:
          return TYPE_NUMERIC;
        case 12:
          return TYPE_RECORD;
        case 13:
          return TYPE_BIGNUMERIC;
        case 14:
          return TYPE_JSON;
        case 15:
          return TYPE_INTERVAL;
        case 16:
          return TYPE_RANGE_DATE;
        case 17:
          return TYPE_RANGE_DATETIME;
        case 18:
          return TYPE_RANGE_TIMESTAMP;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ColumnDataType> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<ColumnDataType> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<ColumnDataType>() {
          public ColumnDataType findValueByNumber(int number) {
            return ColumnDataType.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.privacy.dlp.v2.ColumnDataProfile.getDescriptor().getEnumTypes().get(1);
    }

    private static final ColumnDataType[] VALUES = values();

    public static ColumnDataType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ColumnDataType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.privacy.dlp.v2.ColumnDataProfile.ColumnDataType)
  }

  /**
   *
   *
   * <pre>
   * The possible policy states for a column.
   * </pre>
   *
   * Protobuf enum {@code google.privacy.dlp.v2.ColumnDataProfile.ColumnPolicyState}
   */
  public enum ColumnPolicyState implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * No policy tags.
     * </pre>
     *
     * <code>COLUMN_POLICY_STATE_UNSPECIFIED = 0;</code>
     */
    COLUMN_POLICY_STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Column has policy tag applied.
     * </pre>
     *
     * <code>COLUMN_POLICY_TAGGED = 1;</code>
     */
    COLUMN_POLICY_TAGGED(1),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * No policy tags.
     * </pre>
     *
     * <code>COLUMN_POLICY_STATE_UNSPECIFIED = 0;</code>
     */
    public static final int COLUMN_POLICY_STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Column has policy tag applied.
     * </pre>
     *
     * <code>COLUMN_POLICY_TAGGED = 1;</code>
     */
    public static final int COLUMN_POLICY_TAGGED_VALUE = 1;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ColumnPolicyState valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static ColumnPolicyState forNumber(int value) {
      switch (value) {
        case 0:
          return COLUMN_POLICY_STATE_UNSPECIFIED;
        case 1:
          return COLUMN_POLICY_TAGGED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ColumnPolicyState>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<ColumnPolicyState>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<ColumnPolicyState>() {
              public ColumnPolicyState findValueByNumber(int number) {
                return ColumnPolicyState.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.privacy.dlp.v2.ColumnDataProfile.getDescriptor().getEnumTypes().get(2);
    }

    private static final ColumnPolicyState[] VALUES = values();

    public static ColumnPolicyState valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ColumnPolicyState(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.privacy.dlp.v2.ColumnDataProfile.ColumnPolicyState)
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * The name of the profile.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The name of the profile.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PROFILE_STATUS_FIELD_NUMBER = 17;
  private com.google.privacy.dlp.v2.ProfileStatus profileStatus_;
  /**
   *
   *
   * <pre>
   * Success or error status from the most recent profile generation attempt.
   * May be empty if the profile is still being generated.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.ProfileStatus profile_status = 17;</code>
   *
   * @return Whether the profileStatus field is set.
   */
  @java.lang.Override
  public boolean hasProfileStatus() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Success or error status from the most recent profile generation attempt.
   * May be empty if the profile is still being generated.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.ProfileStatus profile_status = 17;</code>
   *
   * @return The profileStatus.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.ProfileStatus getProfileStatus() {
    return profileStatus_ == null
        ? com.google.privacy.dlp.v2.ProfileStatus.getDefaultInstance()
        : profileStatus_;
  }
  /**
   *
   *
   * <pre>
   * Success or error status from the most recent profile generation attempt.
   * May be empty if the profile is still being generated.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.ProfileStatus profile_status = 17;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.ProfileStatusOrBuilder getProfileStatusOrBuilder() {
    return profileStatus_ == null
        ? com.google.privacy.dlp.v2.ProfileStatus.getDefaultInstance()
        : profileStatus_;
  }

  public static final int STATE_FIELD_NUMBER = 18;
  private int state_ = 0;
  /**
   *
   *
   * <pre>
   * State of a profile.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.ColumnDataProfile.State state = 18;</code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * State of a profile.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.ColumnDataProfile.State state = 18;</code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.ColumnDataProfile.State getState() {
    com.google.privacy.dlp.v2.ColumnDataProfile.State result =
        com.google.privacy.dlp.v2.ColumnDataProfile.State.forNumber(state_);
    return result == null ? com.google.privacy.dlp.v2.ColumnDataProfile.State.UNRECOGNIZED : result;
  }

  public static final int PROFILE_LAST_GENERATED_FIELD_NUMBER = 3;
  private com.google.protobuf.Timestamp profileLastGenerated_;
  /**
   *
   *
   * <pre>
   * The last time the profile was generated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp profile_last_generated = 3;</code>
   *
   * @return Whether the profileLastGenerated field is set.
   */
  @java.lang.Override
  public boolean hasProfileLastGenerated() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * The last time the profile was generated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp profile_last_generated = 3;</code>
   *
   * @return The profileLastGenerated.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getProfileLastGenerated() {
    return profileLastGenerated_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : profileLastGenerated_;
  }
  /**
   *
   *
   * <pre>
   * The last time the profile was generated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp profile_last_generated = 3;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getProfileLastGeneratedOrBuilder() {
    return profileLastGenerated_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : profileLastGenerated_;
  }

  public static final int TABLE_DATA_PROFILE_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object tableDataProfile_ = "";
  /**
   *
   *
   * <pre>
   * The resource name of the table data profile.
   * </pre>
   *
   * <code>string table_data_profile = 4;</code>
   *
   * @return The tableDataProfile.
   */
  @java.lang.Override
  public java.lang.String getTableDataProfile() {
    java.lang.Object ref = tableDataProfile_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      tableDataProfile_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The resource name of the table data profile.
   * </pre>
   *
   * <code>string table_data_profile = 4;</code>
   *
   * @return The bytes for tableDataProfile.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTableDataProfileBytes() {
    java.lang.Object ref = tableDataProfile_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      tableDataProfile_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TABLE_FULL_RESOURCE_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object tableFullResource_ = "";
  /**
   *
   *
   * <pre>
   * The resource name of the resource this column is within.
   * </pre>
   *
   * <code>string table_full_resource = 5;</code>
   *
   * @return The tableFullResource.
   */
  @java.lang.Override
  public java.lang.String getTableFullResource() {
    java.lang.Object ref = tableFullResource_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      tableFullResource_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The resource name of the resource this column is within.
   * </pre>
   *
   * <code>string table_full_resource = 5;</code>
   *
   * @return The bytes for tableFullResource.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTableFullResourceBytes() {
    java.lang.Object ref = tableFullResource_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      tableFullResource_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DATASET_PROJECT_ID_FIELD_NUMBER = 19;

  @SuppressWarnings("serial")
  private volatile java.lang.Object datasetProjectId_ = "";
  /**
   *
   *
   * <pre>
   * The Google Cloud project ID that owns the profiled resource.
   * </pre>
   *
   * <code>string dataset_project_id = 19;</code>
   *
   * @return The datasetProjectId.
   */
  @java.lang.Override
  public java.lang.String getDatasetProjectId() {
    java.lang.Object ref = datasetProjectId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      datasetProjectId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The Google Cloud project ID that owns the profiled resource.
   * </pre>
   *
   * <code>string dataset_project_id = 19;</code>
   *
   * @return The bytes for datasetProjectId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDatasetProjectIdBytes() {
    java.lang.Object ref = datasetProjectId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      datasetProjectId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DATASET_LOCATION_FIELD_NUMBER = 20;

  @SuppressWarnings("serial")
  private volatile java.lang.Object datasetLocation_ = "";
  /**
   *
   *
   * <pre>
   * The BigQuery location where the dataset's data is stored.
   * See https://cloud.google.com/bigquery/docs/locations for supported
   * locations.
   * </pre>
   *
   * <code>string dataset_location = 20;</code>
   *
   * @return The datasetLocation.
   */
  @java.lang.Override
  public java.lang.String getDatasetLocation() {
    java.lang.Object ref = datasetLocation_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      datasetLocation_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The BigQuery location where the dataset's data is stored.
   * See https://cloud.google.com/bigquery/docs/locations for supported
   * locations.
   * </pre>
   *
   * <code>string dataset_location = 20;</code>
   *
   * @return The bytes for datasetLocation.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDatasetLocationBytes() {
    java.lang.Object ref = datasetLocation_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      datasetLocation_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DATASET_ID_FIELD_NUMBER = 21;

  @SuppressWarnings("serial")
  private volatile java.lang.Object datasetId_ = "";
  /**
   *
   *
   * <pre>
   * The BigQuery dataset ID.
   * </pre>
   *
   * <code>string dataset_id = 21;</code>
   *
   * @return The datasetId.
   */
  @java.lang.Override
  public java.lang.String getDatasetId() {
    java.lang.Object ref = datasetId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      datasetId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The BigQuery dataset ID.
   * </pre>
   *
   * <code>string dataset_id = 21;</code>
   *
   * @return The bytes for datasetId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDatasetIdBytes() {
    java.lang.Object ref = datasetId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      datasetId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TABLE_ID_FIELD_NUMBER = 22;

  @SuppressWarnings("serial")
  private volatile java.lang.Object tableId_ = "";
  /**
   *
   *
   * <pre>
   * The BigQuery table ID.
   * </pre>
   *
   * <code>string table_id = 22;</code>
   *
   * @return The tableId.
   */
  @java.lang.Override
  public java.lang.String getTableId() {
    java.lang.Object ref = tableId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      tableId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The BigQuery table ID.
   * </pre>
   *
   * <code>string table_id = 22;</code>
   *
   * @return The bytes for tableId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTableIdBytes() {
    java.lang.Object ref = tableId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      tableId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int COLUMN_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object column_ = "";
  /**
   *
   *
   * <pre>
   * The name of the column.
   * </pre>
   *
   * <code>string column = 6;</code>
   *
   * @return The column.
   */
  @java.lang.Override
  public java.lang.String getColumn() {
    java.lang.Object ref = column_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      column_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The name of the column.
   * </pre>
   *
   * <code>string column = 6;</code>
   *
   * @return The bytes for column.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getColumnBytes() {
    java.lang.Object ref = column_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      column_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SENSITIVITY_SCORE_FIELD_NUMBER = 7;
  private com.google.privacy.dlp.v2.SensitivityScore sensitivityScore_;
  /**
   *
   *
   * <pre>
   * The sensitivity of this column.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.SensitivityScore sensitivity_score = 7;</code>
   *
   * @return Whether the sensitivityScore field is set.
   */
  @java.lang.Override
  public boolean hasSensitivityScore() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * The sensitivity of this column.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.SensitivityScore sensitivity_score = 7;</code>
   *
   * @return The sensitivityScore.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.SensitivityScore getSensitivityScore() {
    return sensitivityScore_ == null
        ? com.google.privacy.dlp.v2.SensitivityScore.getDefaultInstance()
        : sensitivityScore_;
  }
  /**
   *
   *
   * <pre>
   * The sensitivity of this column.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.SensitivityScore sensitivity_score = 7;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.SensitivityScoreOrBuilder getSensitivityScoreOrBuilder() {
    return sensitivityScore_ == null
        ? com.google.privacy.dlp.v2.SensitivityScore.getDefaultInstance()
        : sensitivityScore_;
  }

  public static final int DATA_RISK_LEVEL_FIELD_NUMBER = 8;
  private com.google.privacy.dlp.v2.DataRiskLevel dataRiskLevel_;
  /**
   *
   *
   * <pre>
   * The data risk level for this column.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.DataRiskLevel data_risk_level = 8;</code>
   *
   * @return Whether the dataRiskLevel field is set.
   */
  @java.lang.Override
  public boolean hasDataRiskLevel() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * The data risk level for this column.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.DataRiskLevel data_risk_level = 8;</code>
   *
   * @return The dataRiskLevel.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.DataRiskLevel getDataRiskLevel() {
    return dataRiskLevel_ == null
        ? com.google.privacy.dlp.v2.DataRiskLevel.getDefaultInstance()
        : dataRiskLevel_;
  }
  /**
   *
   *
   * <pre>
   * The data risk level for this column.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.DataRiskLevel data_risk_level = 8;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.DataRiskLevelOrBuilder getDataRiskLevelOrBuilder() {
    return dataRiskLevel_ == null
        ? com.google.privacy.dlp.v2.DataRiskLevel.getDefaultInstance()
        : dataRiskLevel_;
  }

  public static final int COLUMN_INFO_TYPE_FIELD_NUMBER = 9;
  private com.google.privacy.dlp.v2.InfoTypeSummary columnInfoType_;
  /**
   *
   *
   * <pre>
   * If it's been determined this column can be identified as a single type,
   * this will be set. Otherwise the column either has unidentifiable content
   * or mixed types.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.InfoTypeSummary column_info_type = 9;</code>
   *
   * @return Whether the columnInfoType field is set.
   */
  @java.lang.Override
  public boolean hasColumnInfoType() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   *
   *
   * <pre>
   * If it's been determined this column can be identified as a single type,
   * this will be set. Otherwise the column either has unidentifiable content
   * or mixed types.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.InfoTypeSummary column_info_type = 9;</code>
   *
   * @return The columnInfoType.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.InfoTypeSummary getColumnInfoType() {
    return columnInfoType_ == null
        ? com.google.privacy.dlp.v2.InfoTypeSummary.getDefaultInstance()
        : columnInfoType_;
  }
  /**
   *
   *
   * <pre>
   * If it's been determined this column can be identified as a single type,
   * this will be set. Otherwise the column either has unidentifiable content
   * or mixed types.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.InfoTypeSummary column_info_type = 9;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.InfoTypeSummaryOrBuilder getColumnInfoTypeOrBuilder() {
    return columnInfoType_ == null
        ? com.google.privacy.dlp.v2.InfoTypeSummary.getDefaultInstance()
        : columnInfoType_;
  }

  public static final int OTHER_MATCHES_FIELD_NUMBER = 10;

  @SuppressWarnings("serial")
  private java.util.List<com.google.privacy.dlp.v2.OtherInfoTypeSummary> otherMatches_;
  /**
   *
   *
   * <pre>
   * Other types found within this column. List will be unordered.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.OtherInfoTypeSummary other_matches = 10;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.privacy.dlp.v2.OtherInfoTypeSummary> getOtherMatchesList() {
    return otherMatches_;
  }
  /**
   *
   *
   * <pre>
   * Other types found within this column. List will be unordered.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.OtherInfoTypeSummary other_matches = 10;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.privacy.dlp.v2.OtherInfoTypeSummaryOrBuilder>
      getOtherMatchesOrBuilderList() {
    return otherMatches_;
  }
  /**
   *
   *
   * <pre>
   * Other types found within this column. List will be unordered.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.OtherInfoTypeSummary other_matches = 10;</code>
   */
  @java.lang.Override
  public int getOtherMatchesCount() {
    return otherMatches_.size();
  }
  /**
   *
   *
   * <pre>
   * Other types found within this column. List will be unordered.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.OtherInfoTypeSummary other_matches = 10;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.OtherInfoTypeSummary getOtherMatches(int index) {
    return otherMatches_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Other types found within this column. List will be unordered.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.OtherInfoTypeSummary other_matches = 10;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.OtherInfoTypeSummaryOrBuilder getOtherMatchesOrBuilder(
      int index) {
    return otherMatches_.get(index);
  }

  public static final int ESTIMATED_NULL_PERCENTAGE_FIELD_NUMBER = 23;
  private int estimatedNullPercentage_ = 0;
  /**
   *
   *
   * <pre>
   * Approximate percentage of entries being null in the column.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.NullPercentageLevel estimated_null_percentage = 23;</code>
   *
   * @return The enum numeric value on the wire for estimatedNullPercentage.
   */
  @java.lang.Override
  public int getEstimatedNullPercentageValue() {
    return estimatedNullPercentage_;
  }
  /**
   *
   *
   * <pre>
   * Approximate percentage of entries being null in the column.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.NullPercentageLevel estimated_null_percentage = 23;</code>
   *
   * @return The estimatedNullPercentage.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.NullPercentageLevel getEstimatedNullPercentage() {
    com.google.privacy.dlp.v2.NullPercentageLevel result =
        com.google.privacy.dlp.v2.NullPercentageLevel.forNumber(estimatedNullPercentage_);
    return result == null ? com.google.privacy.dlp.v2.NullPercentageLevel.UNRECOGNIZED : result;
  }

  public static final int ESTIMATED_UNIQUENESS_SCORE_FIELD_NUMBER = 24;
  private int estimatedUniquenessScore_ = 0;
  /**
   *
   *
   * <pre>
   * Approximate uniqueness of the column.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.UniquenessScoreLevel estimated_uniqueness_score = 24;</code>
   *
   * @return The enum numeric value on the wire for estimatedUniquenessScore.
   */
  @java.lang.Override
  public int getEstimatedUniquenessScoreValue() {
    return estimatedUniquenessScore_;
  }
  /**
   *
   *
   * <pre>
   * Approximate uniqueness of the column.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.UniquenessScoreLevel estimated_uniqueness_score = 24;</code>
   *
   * @return The estimatedUniquenessScore.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.UniquenessScoreLevel getEstimatedUniquenessScore() {
    com.google.privacy.dlp.v2.UniquenessScoreLevel result =
        com.google.privacy.dlp.v2.UniquenessScoreLevel.forNumber(estimatedUniquenessScore_);
    return result == null ? com.google.privacy.dlp.v2.UniquenessScoreLevel.UNRECOGNIZED : result;
  }

  public static final int FREE_TEXT_SCORE_FIELD_NUMBER = 13;
  private double freeTextScore_ = 0D;
  /**
   *
   *
   * <pre>
   * The likelihood that this column contains free-form text.
   * A value close to 1 may indicate the column is likely to contain
   * free-form or natural language text.
   * Range in 0-1.
   * </pre>
   *
   * <code>double free_text_score = 13;</code>
   *
   * @return The freeTextScore.
   */
  @java.lang.Override
  public double getFreeTextScore() {
    return freeTextScore_;
  }

  public static final int COLUMN_TYPE_FIELD_NUMBER = 14;
  private int columnType_ = 0;
  /**
   *
   *
   * <pre>
   * The data type of a given column.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.ColumnDataProfile.ColumnDataType column_type = 14;</code>
   *
   * @return The enum numeric value on the wire for columnType.
   */
  @java.lang.Override
  public int getColumnTypeValue() {
    return columnType_;
  }
  /**
   *
   *
   * <pre>
   * The data type of a given column.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.ColumnDataProfile.ColumnDataType column_type = 14;</code>
   *
   * @return The columnType.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.ColumnDataProfile.ColumnDataType getColumnType() {
    com.google.privacy.dlp.v2.ColumnDataProfile.ColumnDataType result =
        com.google.privacy.dlp.v2.ColumnDataProfile.ColumnDataType.forNumber(columnType_);
    return result == null
        ? com.google.privacy.dlp.v2.ColumnDataProfile.ColumnDataType.UNRECOGNIZED
        : result;
  }

  public static final int POLICY_STATE_FIELD_NUMBER = 15;
  private int policyState_ = 0;
  /**
   *
   *
   * <pre>
   * Indicates if a policy tag has been applied to the column.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.ColumnDataProfile.ColumnPolicyState policy_state = 15;</code>
   *
   * @return The enum numeric value on the wire for policyState.
   */
  @java.lang.Override
  public int getPolicyStateValue() {
    return policyState_;
  }
  /**
   *
   *
   * <pre>
   * Indicates if a policy tag has been applied to the column.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.ColumnDataProfile.ColumnPolicyState policy_state = 15;</code>
   *
   * @return The policyState.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.ColumnDataProfile.ColumnPolicyState getPolicyState() {
    com.google.privacy.dlp.v2.ColumnDataProfile.ColumnPolicyState result =
        com.google.privacy.dlp.v2.ColumnDataProfile.ColumnPolicyState.forNumber(policyState_);
    return result == null
        ? com.google.privacy.dlp.v2.ColumnDataProfile.ColumnPolicyState.UNRECOGNIZED
        : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(3, getProfileLastGenerated());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(tableDataProfile_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, tableDataProfile_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(tableFullResource_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, tableFullResource_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(column_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, column_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(7, getSensitivityScore());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(8, getDataRiskLevel());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeMessage(9, getColumnInfoType());
    }
    for (int i = 0; i < otherMatches_.size(); i++) {
      output.writeMessage(10, otherMatches_.get(i));
    }
    if (java.lang.Double.doubleToRawLongBits(freeTextScore_) != 0) {
      output.writeDouble(13, freeTextScore_);
    }
    if (columnType_
        != com.google.privacy.dlp.v2.ColumnDataProfile.ColumnDataType.COLUMN_DATA_TYPE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(14, columnType_);
    }
    if (policyState_
        != com.google.privacy.dlp.v2.ColumnDataProfile.ColumnPolicyState
            .COLUMN_POLICY_STATE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(15, policyState_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(17, getProfileStatus());
    }
    if (state_ != com.google.privacy.dlp.v2.ColumnDataProfile.State.STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(18, state_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(datasetProjectId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 19, datasetProjectId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(datasetLocation_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 20, datasetLocation_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(datasetId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 21, datasetId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(tableId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 22, tableId_);
    }
    if (estimatedNullPercentage_
        != com.google.privacy.dlp.v2.NullPercentageLevel.NULL_PERCENTAGE_LEVEL_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(23, estimatedNullPercentage_);
    }
    if (estimatedUniquenessScore_
        != com.google.privacy.dlp.v2.UniquenessScoreLevel.UNIQUENESS_SCORE_LEVEL_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(24, estimatedUniquenessScore_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(3, getProfileLastGenerated());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(tableDataProfile_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, tableDataProfile_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(tableFullResource_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, tableFullResource_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(column_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, column_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getSensitivityScore());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getDataRiskLevel());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getColumnInfoType());
    }
    for (int i = 0; i < otherMatches_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, otherMatches_.get(i));
    }
    if (java.lang.Double.doubleToRawLongBits(freeTextScore_) != 0) {
      size += com.google.protobuf.CodedOutputStream.computeDoubleSize(13, freeTextScore_);
    }
    if (columnType_
        != com.google.privacy.dlp.v2.ColumnDataProfile.ColumnDataType.COLUMN_DATA_TYPE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(14, columnType_);
    }
    if (policyState_
        != com.google.privacy.dlp.v2.ColumnDataProfile.ColumnPolicyState
            .COLUMN_POLICY_STATE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(15, policyState_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(17, getProfileStatus());
    }
    if (state_ != com.google.privacy.dlp.v2.ColumnDataProfile.State.STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(18, state_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(datasetProjectId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(19, datasetProjectId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(datasetLocation_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(20, datasetLocation_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(datasetId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(21, datasetId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(tableId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(22, tableId_);
    }
    if (estimatedNullPercentage_
        != com.google.privacy.dlp.v2.NullPercentageLevel.NULL_PERCENTAGE_LEVEL_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(23, estimatedNullPercentage_);
    }
    if (estimatedUniquenessScore_
        != com.google.privacy.dlp.v2.UniquenessScoreLevel.UNIQUENESS_SCORE_LEVEL_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(24, estimatedUniquenessScore_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.privacy.dlp.v2.ColumnDataProfile)) {
      return super.equals(obj);
    }
    com.google.privacy.dlp.v2.ColumnDataProfile other =
        (com.google.privacy.dlp.v2.ColumnDataProfile) obj;

    if (!getName().equals(other.getName())) return false;
    if (hasProfileStatus() != other.hasProfileStatus()) return false;
    if (hasProfileStatus()) {
      if (!getProfileStatus().equals(other.getProfileStatus())) return false;
    }
    if (state_ != other.state_) return false;
    if (hasProfileLastGenerated() != other.hasProfileLastGenerated()) return false;
    if (hasProfileLastGenerated()) {
      if (!getProfileLastGenerated().equals(other.getProfileLastGenerated())) return false;
    }
    if (!getTableDataProfile().equals(other.getTableDataProfile())) return false;
    if (!getTableFullResource().equals(other.getTableFullResource())) return false;
    if (!getDatasetProjectId().equals(other.getDatasetProjectId())) return false;
    if (!getDatasetLocation().equals(other.getDatasetLocation())) return false;
    if (!getDatasetId().equals(other.getDatasetId())) return false;
    if (!getTableId().equals(other.getTableId())) return false;
    if (!getColumn().equals(other.getColumn())) return false;
    if (hasSensitivityScore() != other.hasSensitivityScore()) return false;
    if (hasSensitivityScore()) {
      if (!getSensitivityScore().equals(other.getSensitivityScore())) return false;
    }
    if (hasDataRiskLevel() != other.hasDataRiskLevel()) return false;
    if (hasDataRiskLevel()) {
      if (!getDataRiskLevel().equals(other.getDataRiskLevel())) return false;
    }
    if (hasColumnInfoType() != other.hasColumnInfoType()) return false;
    if (hasColumnInfoType()) {
      if (!getColumnInfoType().equals(other.getColumnInfoType())) return false;
    }
    if (!getOtherMatchesList().equals(other.getOtherMatchesList())) return false;
    if (estimatedNullPercentage_ != other.estimatedNullPercentage_) return false;
    if (estimatedUniquenessScore_ != other.estimatedUniquenessScore_) return false;
    if (java.lang.Double.doubleToLongBits(getFreeTextScore())
        != java.lang.Double.doubleToLongBits(other.getFreeTextScore())) return false;
    if (columnType_ != other.columnType_) return false;
    if (policyState_ != other.policyState_) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasProfileStatus()) {
      hash = (37 * hash) + PROFILE_STATUS_FIELD_NUMBER;
      hash = (53 * hash) + getProfileStatus().hashCode();
    }
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    if (hasProfileLastGenerated()) {
      hash = (37 * hash) + PROFILE_LAST_GENERATED_FIELD_NUMBER;
      hash = (53 * hash) + getProfileLastGenerated().hashCode();
    }
    hash = (37 * hash) + TABLE_DATA_PROFILE_FIELD_NUMBER;
    hash = (53 * hash) + getTableDataProfile().hashCode();
    hash = (37 * hash) + TABLE_FULL_RESOURCE_FIELD_NUMBER;
    hash = (53 * hash) + getTableFullResource().hashCode();
    hash = (37 * hash) + DATASET_PROJECT_ID_FIELD_NUMBER;
    hash = (53 * hash) + getDatasetProjectId().hashCode();
    hash = (37 * hash) + DATASET_LOCATION_FIELD_NUMBER;
    hash = (53 * hash) + getDatasetLocation().hashCode();
    hash = (37 * hash) + DATASET_ID_FIELD_NUMBER;
    hash = (53 * hash) + getDatasetId().hashCode();
    hash = (37 * hash) + TABLE_ID_FIELD_NUMBER;
    hash = (53 * hash) + getTableId().hashCode();
    hash = (37 * hash) + COLUMN_FIELD_NUMBER;
    hash = (53 * hash) + getColumn().hashCode();
    if (hasSensitivityScore()) {
      hash = (37 * hash) + SENSITIVITY_SCORE_FIELD_NUMBER;
      hash = (53 * hash) + getSensitivityScore().hashCode();
    }
    if (hasDataRiskLevel()) {
      hash = (37 * hash) + DATA_RISK_LEVEL_FIELD_NUMBER;
      hash = (53 * hash) + getDataRiskLevel().hashCode();
    }
    if (hasColumnInfoType()) {
      hash = (37 * hash) + COLUMN_INFO_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + getColumnInfoType().hashCode();
    }
    if (getOtherMatchesCount() > 0) {
      hash = (37 * hash) + OTHER_MATCHES_FIELD_NUMBER;
      hash = (53 * hash) + getOtherMatchesList().hashCode();
    }
    hash = (37 * hash) + ESTIMATED_NULL_PERCENTAGE_FIELD_NUMBER;
    hash = (53 * hash) + estimatedNullPercentage_;
    hash = (37 * hash) + ESTIMATED_UNIQUENESS_SCORE_FIELD_NUMBER;
    hash = (53 * hash) + estimatedUniquenessScore_;
    hash = (37 * hash) + FREE_TEXT_SCORE_FIELD_NUMBER;
    hash =
        (53 * hash)
            + com.google.protobuf.Internal.hashLong(
                java.lang.Double.doubleToLongBits(getFreeTextScore()));
    hash = (37 * hash) + COLUMN_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + columnType_;
    hash = (37 * hash) + POLICY_STATE_FIELD_NUMBER;
    hash = (53 * hash) + policyState_;
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.privacy.dlp.v2.ColumnDataProfile parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.ColumnDataProfile parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.ColumnDataProfile parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.ColumnDataProfile parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.ColumnDataProfile parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.ColumnDataProfile parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.ColumnDataProfile parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.ColumnDataProfile parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.ColumnDataProfile parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.ColumnDataProfile parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.ColumnDataProfile parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.ColumnDataProfile parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.privacy.dlp.v2.ColumnDataProfile prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The profile for a scanned column within a table.
   * </pre>
   *
   * Protobuf type {@code google.privacy.dlp.v2.ColumnDataProfile}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.privacy.dlp.v2.ColumnDataProfile)
      com.google.privacy.dlp.v2.ColumnDataProfileOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_ColumnDataProfile_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_ColumnDataProfile_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.privacy.dlp.v2.ColumnDataProfile.class,
              com.google.privacy.dlp.v2.ColumnDataProfile.Builder.class);
    }

    // Construct using com.google.privacy.dlp.v2.ColumnDataProfile.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getProfileStatusFieldBuilder();
        getProfileLastGeneratedFieldBuilder();
        getSensitivityScoreFieldBuilder();
        getDataRiskLevelFieldBuilder();
        getColumnInfoTypeFieldBuilder();
        getOtherMatchesFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      profileStatus_ = null;
      if (profileStatusBuilder_ != null) {
        profileStatusBuilder_.dispose();
        profileStatusBuilder_ = null;
      }
      state_ = 0;
      profileLastGenerated_ = null;
      if (profileLastGeneratedBuilder_ != null) {
        profileLastGeneratedBuilder_.dispose();
        profileLastGeneratedBuilder_ = null;
      }
      tableDataProfile_ = "";
      tableFullResource_ = "";
      datasetProjectId_ = "";
      datasetLocation_ = "";
      datasetId_ = "";
      tableId_ = "";
      column_ = "";
      sensitivityScore_ = null;
      if (sensitivityScoreBuilder_ != null) {
        sensitivityScoreBuilder_.dispose();
        sensitivityScoreBuilder_ = null;
      }
      dataRiskLevel_ = null;
      if (dataRiskLevelBuilder_ != null) {
        dataRiskLevelBuilder_.dispose();
        dataRiskLevelBuilder_ = null;
      }
      columnInfoType_ = null;
      if (columnInfoTypeBuilder_ != null) {
        columnInfoTypeBuilder_.dispose();
        columnInfoTypeBuilder_ = null;
      }
      if (otherMatchesBuilder_ == null) {
        otherMatches_ = java.util.Collections.emptyList();
      } else {
        otherMatches_ = null;
        otherMatchesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00004000);
      estimatedNullPercentage_ = 0;
      estimatedUniquenessScore_ = 0;
      freeTextScore_ = 0D;
      columnType_ = 0;
      policyState_ = 0;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_ColumnDataProfile_descriptor;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.ColumnDataProfile getDefaultInstanceForType() {
      return com.google.privacy.dlp.v2.ColumnDataProfile.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.ColumnDataProfile build() {
      com.google.privacy.dlp.v2.ColumnDataProfile result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.ColumnDataProfile buildPartial() {
      com.google.privacy.dlp.v2.ColumnDataProfile result =
          new com.google.privacy.dlp.v2.ColumnDataProfile(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.privacy.dlp.v2.ColumnDataProfile result) {
      if (otherMatchesBuilder_ == null) {
        if (((bitField0_ & 0x00004000) != 0)) {
          otherMatches_ = java.util.Collections.unmodifiableList(otherMatches_);
          bitField0_ = (bitField0_ & ~0x00004000);
        }
        result.otherMatches_ = otherMatches_;
      } else {
        result.otherMatches_ = otherMatchesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.privacy.dlp.v2.ColumnDataProfile result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.profileStatus_ =
            profileStatusBuilder_ == null ? profileStatus_ : profileStatusBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.state_ = state_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.profileLastGenerated_ =
            profileLastGeneratedBuilder_ == null
                ? profileLastGenerated_
                : profileLastGeneratedBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.tableDataProfile_ = tableDataProfile_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.tableFullResource_ = tableFullResource_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.datasetProjectId_ = datasetProjectId_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.datasetLocation_ = datasetLocation_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.datasetId_ = datasetId_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.tableId_ = tableId_;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.column_ = column_;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.sensitivityScore_ =
            sensitivityScoreBuilder_ == null ? sensitivityScore_ : sensitivityScoreBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.dataRiskLevel_ =
            dataRiskLevelBuilder_ == null ? dataRiskLevel_ : dataRiskLevelBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.columnInfoType_ =
            columnInfoTypeBuilder_ == null ? columnInfoType_ : columnInfoTypeBuilder_.build();
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00008000) != 0)) {
        result.estimatedNullPercentage_ = estimatedNullPercentage_;
      }
      if (((from_bitField0_ & 0x00010000) != 0)) {
        result.estimatedUniquenessScore_ = estimatedUniquenessScore_;
      }
      if (((from_bitField0_ & 0x00020000) != 0)) {
        result.freeTextScore_ = freeTextScore_;
      }
      if (((from_bitField0_ & 0x00040000) != 0)) {
        result.columnType_ = columnType_;
      }
      if (((from_bitField0_ & 0x00080000) != 0)) {
        result.policyState_ = policyState_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.privacy.dlp.v2.ColumnDataProfile) {
        return mergeFrom((com.google.privacy.dlp.v2.ColumnDataProfile) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.privacy.dlp.v2.ColumnDataProfile other) {
      if (other == com.google.privacy.dlp.v2.ColumnDataProfile.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasProfileStatus()) {
        mergeProfileStatus(other.getProfileStatus());
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (other.hasProfileLastGenerated()) {
        mergeProfileLastGenerated(other.getProfileLastGenerated());
      }
      if (!other.getTableDataProfile().isEmpty()) {
        tableDataProfile_ = other.tableDataProfile_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (!other.getTableFullResource().isEmpty()) {
        tableFullResource_ = other.tableFullResource_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (!other.getDatasetProjectId().isEmpty()) {
        datasetProjectId_ = other.datasetProjectId_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (!other.getDatasetLocation().isEmpty()) {
        datasetLocation_ = other.datasetLocation_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      if (!other.getDatasetId().isEmpty()) {
        datasetId_ = other.datasetId_;
        bitField0_ |= 0x00000100;
        onChanged();
      }
      if (!other.getTableId().isEmpty()) {
        tableId_ = other.tableId_;
        bitField0_ |= 0x00000200;
        onChanged();
      }
      if (!other.getColumn().isEmpty()) {
        column_ = other.column_;
        bitField0_ |= 0x00000400;
        onChanged();
      }
      if (other.hasSensitivityScore()) {
        mergeSensitivityScore(other.getSensitivityScore());
      }
      if (other.hasDataRiskLevel()) {
        mergeDataRiskLevel(other.getDataRiskLevel());
      }
      if (other.hasColumnInfoType()) {
        mergeColumnInfoType(other.getColumnInfoType());
      }
      if (otherMatchesBuilder_ == null) {
        if (!other.otherMatches_.isEmpty()) {
          if (otherMatches_.isEmpty()) {
            otherMatches_ = other.otherMatches_;
            bitField0_ = (bitField0_ & ~0x00004000);
          } else {
            ensureOtherMatchesIsMutable();
            otherMatches_.addAll(other.otherMatches_);
          }
          onChanged();
        }
      } else {
        if (!other.otherMatches_.isEmpty()) {
          if (otherMatchesBuilder_.isEmpty()) {
            otherMatchesBuilder_.dispose();
            otherMatchesBuilder_ = null;
            otherMatches_ = other.otherMatches_;
            bitField0_ = (bitField0_ & ~0x00004000);
            otherMatchesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getOtherMatchesFieldBuilder()
                    : null;
          } else {
            otherMatchesBuilder_.addAllMessages(other.otherMatches_);
          }
        }
      }
      if (other.estimatedNullPercentage_ != 0) {
        setEstimatedNullPercentageValue(other.getEstimatedNullPercentageValue());
      }
      if (other.estimatedUniquenessScore_ != 0) {
        setEstimatedUniquenessScoreValue(other.getEstimatedUniquenessScoreValue());
      }
      if (other.getFreeTextScore() != 0D) {
        setFreeTextScore(other.getFreeTextScore());
      }
      if (other.columnType_ != 0) {
        setColumnTypeValue(other.getColumnTypeValue());
      }
      if (other.policyState_ != 0) {
        setPolicyStateValue(other.getPolicyStateValue());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 26:
              {
                input.readMessage(
                    getProfileLastGeneratedFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 26
            case 34:
              {
                tableDataProfile_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 34
            case 42:
              {
                tableFullResource_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 42
            case 50:
              {
                column_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000400;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(
                    getSensitivityScoreFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000800;
                break;
              } // case 58
            case 66:
              {
                input.readMessage(getDataRiskLevelFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00001000;
                break;
              } // case 66
            case 74:
              {
                input.readMessage(getColumnInfoTypeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00002000;
                break;
              } // case 74
            case 82:
              {
                com.google.privacy.dlp.v2.OtherInfoTypeSummary m =
                    input.readMessage(
                        com.google.privacy.dlp.v2.OtherInfoTypeSummary.parser(), extensionRegistry);
                if (otherMatchesBuilder_ == null) {
                  ensureOtherMatchesIsMutable();
                  otherMatches_.add(m);
                } else {
                  otherMatchesBuilder_.addMessage(m);
                }
                break;
              } // case 82
            case 105:
              {
                freeTextScore_ = input.readDouble();
                bitField0_ |= 0x00020000;
                break;
              } // case 105
            case 112:
              {
                columnType_ = input.readEnum();
                bitField0_ |= 0x00040000;
                break;
              } // case 112
            case 120:
              {
                policyState_ = input.readEnum();
                bitField0_ |= 0x00080000;
                break;
              } // case 120
            case 138:
              {
                input.readMessage(getProfileStatusFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 138
            case 144:
              {
                state_ = input.readEnum();
                bitField0_ |= 0x00000004;
                break;
              } // case 144
            case 154:
              {
                datasetProjectId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 154
            case 162:
              {
                datasetLocation_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000080;
                break;
              } // case 162
            case 170:
              {
                datasetId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000100;
                break;
              } // case 170
            case 178:
              {
                tableId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000200;
                break;
              } // case 178
            case 184:
              {
                estimatedNullPercentage_ = input.readEnum();
                bitField0_ |= 0x00008000;
                break;
              } // case 184
            case 192:
              {
                estimatedUniquenessScore_ = input.readEnum();
                bitField0_ |= 0x00010000;
                break;
              } // case 192
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The name of the profile.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the profile.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the profile.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the profile.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the profile.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.privacy.dlp.v2.ProfileStatus profileStatus_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.ProfileStatus,
            com.google.privacy.dlp.v2.ProfileStatus.Builder,
            com.google.privacy.dlp.v2.ProfileStatusOrBuilder>
        profileStatusBuilder_;
    /**
     *
     *
     * <pre>
     * Success or error status from the most recent profile generation attempt.
     * May be empty if the profile is still being generated.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ProfileStatus profile_status = 17;</code>
     *
     * @return Whether the profileStatus field is set.
     */
    public boolean hasProfileStatus() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Success or error status from the most recent profile generation attempt.
     * May be empty if the profile is still being generated.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ProfileStatus profile_status = 17;</code>
     *
     * @return The profileStatus.
     */
    public com.google.privacy.dlp.v2.ProfileStatus getProfileStatus() {
      if (profileStatusBuilder_ == null) {
        return profileStatus_ == null
            ? com.google.privacy.dlp.v2.ProfileStatus.getDefaultInstance()
            : profileStatus_;
      } else {
        return profileStatusBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Success or error status from the most recent profile generation attempt.
     * May be empty if the profile is still being generated.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ProfileStatus profile_status = 17;</code>
     */
    public Builder setProfileStatus(com.google.privacy.dlp.v2.ProfileStatus value) {
      if (profileStatusBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        profileStatus_ = value;
      } else {
        profileStatusBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Success or error status from the most recent profile generation attempt.
     * May be empty if the profile is still being generated.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ProfileStatus profile_status = 17;</code>
     */
    public Builder setProfileStatus(
        com.google.privacy.dlp.v2.ProfileStatus.Builder builderForValue) {
      if (profileStatusBuilder_ == null) {
        profileStatus_ = builderForValue.build();
      } else {
        profileStatusBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Success or error status from the most recent profile generation attempt.
     * May be empty if the profile is still being generated.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ProfileStatus profile_status = 17;</code>
     */
    public Builder mergeProfileStatus(com.google.privacy.dlp.v2.ProfileStatus value) {
      if (profileStatusBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && profileStatus_ != null
            && profileStatus_ != com.google.privacy.dlp.v2.ProfileStatus.getDefaultInstance()) {
          getProfileStatusBuilder().mergeFrom(value);
        } else {
          profileStatus_ = value;
        }
      } else {
        profileStatusBuilder_.mergeFrom(value);
      }
      if (profileStatus_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Success or error status from the most recent profile generation attempt.
     * May be empty if the profile is still being generated.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ProfileStatus profile_status = 17;</code>
     */
    public Builder clearProfileStatus() {
      bitField0_ = (bitField0_ & ~0x00000002);
      profileStatus_ = null;
      if (profileStatusBuilder_ != null) {
        profileStatusBuilder_.dispose();
        profileStatusBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Success or error status from the most recent profile generation attempt.
     * May be empty if the profile is still being generated.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ProfileStatus profile_status = 17;</code>
     */
    public com.google.privacy.dlp.v2.ProfileStatus.Builder getProfileStatusBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getProfileStatusFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Success or error status from the most recent profile generation attempt.
     * May be empty if the profile is still being generated.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ProfileStatus profile_status = 17;</code>
     */
    public com.google.privacy.dlp.v2.ProfileStatusOrBuilder getProfileStatusOrBuilder() {
      if (profileStatusBuilder_ != null) {
        return profileStatusBuilder_.getMessageOrBuilder();
      } else {
        return profileStatus_ == null
            ? com.google.privacy.dlp.v2.ProfileStatus.getDefaultInstance()
            : profileStatus_;
      }
    }
    /**
     *
     *
     * <pre>
     * Success or error status from the most recent profile generation attempt.
     * May be empty if the profile is still being generated.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ProfileStatus profile_status = 17;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.ProfileStatus,
            com.google.privacy.dlp.v2.ProfileStatus.Builder,
            com.google.privacy.dlp.v2.ProfileStatusOrBuilder>
        getProfileStatusFieldBuilder() {
      if (profileStatusBuilder_ == null) {
        profileStatusBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.ProfileStatus,
                com.google.privacy.dlp.v2.ProfileStatus.Builder,
                com.google.privacy.dlp.v2.ProfileStatusOrBuilder>(
                getProfileStatus(), getParentForChildren(), isClean());
        profileStatus_ = null;
      }
      return profileStatusBuilder_;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * State of a profile.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ColumnDataProfile.State state = 18;</code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * State of a profile.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ColumnDataProfile.State state = 18;</code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {
      state_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * State of a profile.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ColumnDataProfile.State state = 18;</code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.ColumnDataProfile.State getState() {
      com.google.privacy.dlp.v2.ColumnDataProfile.State result =
          com.google.privacy.dlp.v2.ColumnDataProfile.State.forNumber(state_);
      return result == null
          ? com.google.privacy.dlp.v2.ColumnDataProfile.State.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * State of a profile.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ColumnDataProfile.State state = 18;</code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.privacy.dlp.v2.ColumnDataProfile.State value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000004;
      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * State of a profile.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ColumnDataProfile.State state = 18;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      bitField0_ = (bitField0_ & ~0x00000004);
      state_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp profileLastGenerated_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        profileLastGeneratedBuilder_;
    /**
     *
     *
     * <pre>
     * The last time the profile was generated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp profile_last_generated = 3;</code>
     *
     * @return Whether the profileLastGenerated field is set.
     */
    public boolean hasProfileLastGenerated() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * The last time the profile was generated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp profile_last_generated = 3;</code>
     *
     * @return The profileLastGenerated.
     */
    public com.google.protobuf.Timestamp getProfileLastGenerated() {
      if (profileLastGeneratedBuilder_ == null) {
        return profileLastGenerated_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : profileLastGenerated_;
      } else {
        return profileLastGeneratedBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The last time the profile was generated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp profile_last_generated = 3;</code>
     */
    public Builder setProfileLastGenerated(com.google.protobuf.Timestamp value) {
      if (profileLastGeneratedBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        profileLastGenerated_ = value;
      } else {
        profileLastGeneratedBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The last time the profile was generated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp profile_last_generated = 3;</code>
     */
    public Builder setProfileLastGenerated(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (profileLastGeneratedBuilder_ == null) {
        profileLastGenerated_ = builderForValue.build();
      } else {
        profileLastGeneratedBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The last time the profile was generated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp profile_last_generated = 3;</code>
     */
    public Builder mergeProfileLastGenerated(com.google.protobuf.Timestamp value) {
      if (profileLastGeneratedBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && profileLastGenerated_ != null
            && profileLastGenerated_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getProfileLastGeneratedBuilder().mergeFrom(value);
        } else {
          profileLastGenerated_ = value;
        }
      } else {
        profileLastGeneratedBuilder_.mergeFrom(value);
      }
      if (profileLastGenerated_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The last time the profile was generated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp profile_last_generated = 3;</code>
     */
    public Builder clearProfileLastGenerated() {
      bitField0_ = (bitField0_ & ~0x00000008);
      profileLastGenerated_ = null;
      if (profileLastGeneratedBuilder_ != null) {
        profileLastGeneratedBuilder_.dispose();
        profileLastGeneratedBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The last time the profile was generated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp profile_last_generated = 3;</code>
     */
    public com.google.protobuf.Timestamp.Builder getProfileLastGeneratedBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getProfileLastGeneratedFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The last time the profile was generated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp profile_last_generated = 3;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getProfileLastGeneratedOrBuilder() {
      if (profileLastGeneratedBuilder_ != null) {
        return profileLastGeneratedBuilder_.getMessageOrBuilder();
      } else {
        return profileLastGenerated_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : profileLastGenerated_;
      }
    }
    /**
     *
     *
     * <pre>
     * The last time the profile was generated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp profile_last_generated = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getProfileLastGeneratedFieldBuilder() {
      if (profileLastGeneratedBuilder_ == null) {
        profileLastGeneratedBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getProfileLastGenerated(), getParentForChildren(), isClean());
        profileLastGenerated_ = null;
      }
      return profileLastGeneratedBuilder_;
    }

    private java.lang.Object tableDataProfile_ = "";
    /**
     *
     *
     * <pre>
     * The resource name of the table data profile.
     * </pre>
     *
     * <code>string table_data_profile = 4;</code>
     *
     * @return The tableDataProfile.
     */
    public java.lang.String getTableDataProfile() {
      java.lang.Object ref = tableDataProfile_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        tableDataProfile_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of the table data profile.
     * </pre>
     *
     * <code>string table_data_profile = 4;</code>
     *
     * @return The bytes for tableDataProfile.
     */
    public com.google.protobuf.ByteString getTableDataProfileBytes() {
      java.lang.Object ref = tableDataProfile_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        tableDataProfile_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of the table data profile.
     * </pre>
     *
     * <code>string table_data_profile = 4;</code>
     *
     * @param value The tableDataProfile to set.
     * @return This builder for chaining.
     */
    public Builder setTableDataProfile(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      tableDataProfile_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name of the table data profile.
     * </pre>
     *
     * <code>string table_data_profile = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTableDataProfile() {
      tableDataProfile_ = getDefaultInstance().getTableDataProfile();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name of the table data profile.
     * </pre>
     *
     * <code>string table_data_profile = 4;</code>
     *
     * @param value The bytes for tableDataProfile to set.
     * @return This builder for chaining.
     */
    public Builder setTableDataProfileBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      tableDataProfile_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.lang.Object tableFullResource_ = "";
    /**
     *
     *
     * <pre>
     * The resource name of the resource this column is within.
     * </pre>
     *
     * <code>string table_full_resource = 5;</code>
     *
     * @return The tableFullResource.
     */
    public java.lang.String getTableFullResource() {
      java.lang.Object ref = tableFullResource_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        tableFullResource_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of the resource this column is within.
     * </pre>
     *
     * <code>string table_full_resource = 5;</code>
     *
     * @return The bytes for tableFullResource.
     */
    public com.google.protobuf.ByteString getTableFullResourceBytes() {
      java.lang.Object ref = tableFullResource_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        tableFullResource_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of the resource this column is within.
     * </pre>
     *
     * <code>string table_full_resource = 5;</code>
     *
     * @param value The tableFullResource to set.
     * @return This builder for chaining.
     */
    public Builder setTableFullResource(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      tableFullResource_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name of the resource this column is within.
     * </pre>
     *
     * <code>string table_full_resource = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTableFullResource() {
      tableFullResource_ = getDefaultInstance().getTableFullResource();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name of the resource this column is within.
     * </pre>
     *
     * <code>string table_full_resource = 5;</code>
     *
     * @param value The bytes for tableFullResource to set.
     * @return This builder for chaining.
     */
    public Builder setTableFullResourceBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      tableFullResource_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private java.lang.Object datasetProjectId_ = "";
    /**
     *
     *
     * <pre>
     * The Google Cloud project ID that owns the profiled resource.
     * </pre>
     *
     * <code>string dataset_project_id = 19;</code>
     *
     * @return The datasetProjectId.
     */
    public java.lang.String getDatasetProjectId() {
      java.lang.Object ref = datasetProjectId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        datasetProjectId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The Google Cloud project ID that owns the profiled resource.
     * </pre>
     *
     * <code>string dataset_project_id = 19;</code>
     *
     * @return The bytes for datasetProjectId.
     */
    public com.google.protobuf.ByteString getDatasetProjectIdBytes() {
      java.lang.Object ref = datasetProjectId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        datasetProjectId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The Google Cloud project ID that owns the profiled resource.
     * </pre>
     *
     * <code>string dataset_project_id = 19;</code>
     *
     * @param value The datasetProjectId to set.
     * @return This builder for chaining.
     */
    public Builder setDatasetProjectId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      datasetProjectId_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Google Cloud project ID that owns the profiled resource.
     * </pre>
     *
     * <code>string dataset_project_id = 19;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDatasetProjectId() {
      datasetProjectId_ = getDefaultInstance().getDatasetProjectId();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Google Cloud project ID that owns the profiled resource.
     * </pre>
     *
     * <code>string dataset_project_id = 19;</code>
     *
     * @param value The bytes for datasetProjectId to set.
     * @return This builder for chaining.
     */
    public Builder setDatasetProjectIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      datasetProjectId_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private java.lang.Object datasetLocation_ = "";
    /**
     *
     *
     * <pre>
     * The BigQuery location where the dataset's data is stored.
     * See https://cloud.google.com/bigquery/docs/locations for supported
     * locations.
     * </pre>
     *
     * <code>string dataset_location = 20;</code>
     *
     * @return The datasetLocation.
     */
    public java.lang.String getDatasetLocation() {
      java.lang.Object ref = datasetLocation_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        datasetLocation_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The BigQuery location where the dataset's data is stored.
     * See https://cloud.google.com/bigquery/docs/locations for supported
     * locations.
     * </pre>
     *
     * <code>string dataset_location = 20;</code>
     *
     * @return The bytes for datasetLocation.
     */
    public com.google.protobuf.ByteString getDatasetLocationBytes() {
      java.lang.Object ref = datasetLocation_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        datasetLocation_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The BigQuery location where the dataset's data is stored.
     * See https://cloud.google.com/bigquery/docs/locations for supported
     * locations.
     * </pre>
     *
     * <code>string dataset_location = 20;</code>
     *
     * @param value The datasetLocation to set.
     * @return This builder for chaining.
     */
    public Builder setDatasetLocation(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      datasetLocation_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The BigQuery location where the dataset's data is stored.
     * See https://cloud.google.com/bigquery/docs/locations for supported
     * locations.
     * </pre>
     *
     * <code>string dataset_location = 20;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDatasetLocation() {
      datasetLocation_ = getDefaultInstance().getDatasetLocation();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The BigQuery location where the dataset's data is stored.
     * See https://cloud.google.com/bigquery/docs/locations for supported
     * locations.
     * </pre>
     *
     * <code>string dataset_location = 20;</code>
     *
     * @param value The bytes for datasetLocation to set.
     * @return This builder for chaining.
     */
    public Builder setDatasetLocationBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      datasetLocation_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private java.lang.Object datasetId_ = "";
    /**
     *
     *
     * <pre>
     * The BigQuery dataset ID.
     * </pre>
     *
     * <code>string dataset_id = 21;</code>
     *
     * @return The datasetId.
     */
    public java.lang.String getDatasetId() {
      java.lang.Object ref = datasetId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        datasetId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The BigQuery dataset ID.
     * </pre>
     *
     * <code>string dataset_id = 21;</code>
     *
     * @return The bytes for datasetId.
     */
    public com.google.protobuf.ByteString getDatasetIdBytes() {
      java.lang.Object ref = datasetId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        datasetId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The BigQuery dataset ID.
     * </pre>
     *
     * <code>string dataset_id = 21;</code>
     *
     * @param value The datasetId to set.
     * @return This builder for chaining.
     */
    public Builder setDatasetId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      datasetId_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The BigQuery dataset ID.
     * </pre>
     *
     * <code>string dataset_id = 21;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDatasetId() {
      datasetId_ = getDefaultInstance().getDatasetId();
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The BigQuery dataset ID.
     * </pre>
     *
     * <code>string dataset_id = 21;</code>
     *
     * @param value The bytes for datasetId to set.
     * @return This builder for chaining.
     */
    public Builder setDatasetIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      datasetId_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    private java.lang.Object tableId_ = "";
    /**
     *
     *
     * <pre>
     * The BigQuery table ID.
     * </pre>
     *
     * <code>string table_id = 22;</code>
     *
     * @return The tableId.
     */
    public java.lang.String getTableId() {
      java.lang.Object ref = tableId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        tableId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The BigQuery table ID.
     * </pre>
     *
     * <code>string table_id = 22;</code>
     *
     * @return The bytes for tableId.
     */
    public com.google.protobuf.ByteString getTableIdBytes() {
      java.lang.Object ref = tableId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        tableId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The BigQuery table ID.
     * </pre>
     *
     * <code>string table_id = 22;</code>
     *
     * @param value The tableId to set.
     * @return This builder for chaining.
     */
    public Builder setTableId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      tableId_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The BigQuery table ID.
     * </pre>
     *
     * <code>string table_id = 22;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTableId() {
      tableId_ = getDefaultInstance().getTableId();
      bitField0_ = (bitField0_ & ~0x00000200);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The BigQuery table ID.
     * </pre>
     *
     * <code>string table_id = 22;</code>
     *
     * @param value The bytes for tableId to set.
     * @return This builder for chaining.
     */
    public Builder setTableIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      tableId_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    private java.lang.Object column_ = "";
    /**
     *
     *
     * <pre>
     * The name of the column.
     * </pre>
     *
     * <code>string column = 6;</code>
     *
     * @return The column.
     */
    public java.lang.String getColumn() {
      java.lang.Object ref = column_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        column_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the column.
     * </pre>
     *
     * <code>string column = 6;</code>
     *
     * @return The bytes for column.
     */
    public com.google.protobuf.ByteString getColumnBytes() {
      java.lang.Object ref = column_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        column_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the column.
     * </pre>
     *
     * <code>string column = 6;</code>
     *
     * @param value The column to set.
     * @return This builder for chaining.
     */
    public Builder setColumn(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      column_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the column.
     * </pre>
     *
     * <code>string column = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearColumn() {
      column_ = getDefaultInstance().getColumn();
      bitField0_ = (bitField0_ & ~0x00000400);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the column.
     * </pre>
     *
     * <code>string column = 6;</code>
     *
     * @param value The bytes for column to set.
     * @return This builder for chaining.
     */
    public Builder setColumnBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      column_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    private com.google.privacy.dlp.v2.SensitivityScore sensitivityScore_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.SensitivityScore,
            com.google.privacy.dlp.v2.SensitivityScore.Builder,
            com.google.privacy.dlp.v2.SensitivityScoreOrBuilder>
        sensitivityScoreBuilder_;
    /**
     *
     *
     * <pre>
     * The sensitivity of this column.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.SensitivityScore sensitivity_score = 7;</code>
     *
     * @return Whether the sensitivityScore field is set.
     */
    public boolean hasSensitivityScore() {
      return ((bitField0_ & 0x00000800) != 0);
    }
    /**
     *
     *
     * <pre>
     * The sensitivity of this column.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.SensitivityScore sensitivity_score = 7;</code>
     *
     * @return The sensitivityScore.
     */
    public com.google.privacy.dlp.v2.SensitivityScore getSensitivityScore() {
      if (sensitivityScoreBuilder_ == null) {
        return sensitivityScore_ == null
            ? com.google.privacy.dlp.v2.SensitivityScore.getDefaultInstance()
            : sensitivityScore_;
      } else {
        return sensitivityScoreBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The sensitivity of this column.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.SensitivityScore sensitivity_score = 7;</code>
     */
    public Builder setSensitivityScore(com.google.privacy.dlp.v2.SensitivityScore value) {
      if (sensitivityScoreBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        sensitivityScore_ = value;
      } else {
        sensitivityScoreBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The sensitivity of this column.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.SensitivityScore sensitivity_score = 7;</code>
     */
    public Builder setSensitivityScore(
        com.google.privacy.dlp.v2.SensitivityScore.Builder builderForValue) {
      if (sensitivityScoreBuilder_ == null) {
        sensitivityScore_ = builderForValue.build();
      } else {
        sensitivityScoreBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The sensitivity of this column.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.SensitivityScore sensitivity_score = 7;</code>
     */
    public Builder mergeSensitivityScore(com.google.privacy.dlp.v2.SensitivityScore value) {
      if (sensitivityScoreBuilder_ == null) {
        if (((bitField0_ & 0x00000800) != 0)
            && sensitivityScore_ != null
            && sensitivityScore_
                != com.google.privacy.dlp.v2.SensitivityScore.getDefaultInstance()) {
          getSensitivityScoreBuilder().mergeFrom(value);
        } else {
          sensitivityScore_ = value;
        }
      } else {
        sensitivityScoreBuilder_.mergeFrom(value);
      }
      if (sensitivityScore_ != null) {
        bitField0_ |= 0x00000800;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The sensitivity of this column.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.SensitivityScore sensitivity_score = 7;</code>
     */
    public Builder clearSensitivityScore() {
      bitField0_ = (bitField0_ & ~0x00000800);
      sensitivityScore_ = null;
      if (sensitivityScoreBuilder_ != null) {
        sensitivityScoreBuilder_.dispose();
        sensitivityScoreBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The sensitivity of this column.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.SensitivityScore sensitivity_score = 7;</code>
     */
    public com.google.privacy.dlp.v2.SensitivityScore.Builder getSensitivityScoreBuilder() {
      bitField0_ |= 0x00000800;
      onChanged();
      return getSensitivityScoreFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The sensitivity of this column.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.SensitivityScore sensitivity_score = 7;</code>
     */
    public com.google.privacy.dlp.v2.SensitivityScoreOrBuilder getSensitivityScoreOrBuilder() {
      if (sensitivityScoreBuilder_ != null) {
        return sensitivityScoreBuilder_.getMessageOrBuilder();
      } else {
        return sensitivityScore_ == null
            ? com.google.privacy.dlp.v2.SensitivityScore.getDefaultInstance()
            : sensitivityScore_;
      }
    }
    /**
     *
     *
     * <pre>
     * The sensitivity of this column.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.SensitivityScore sensitivity_score = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.SensitivityScore,
            com.google.privacy.dlp.v2.SensitivityScore.Builder,
            com.google.privacy.dlp.v2.SensitivityScoreOrBuilder>
        getSensitivityScoreFieldBuilder() {
      if (sensitivityScoreBuilder_ == null) {
        sensitivityScoreBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.SensitivityScore,
                com.google.privacy.dlp.v2.SensitivityScore.Builder,
                com.google.privacy.dlp.v2.SensitivityScoreOrBuilder>(
                getSensitivityScore(), getParentForChildren(), isClean());
        sensitivityScore_ = null;
      }
      return sensitivityScoreBuilder_;
    }

    private com.google.privacy.dlp.v2.DataRiskLevel dataRiskLevel_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.DataRiskLevel,
            com.google.privacy.dlp.v2.DataRiskLevel.Builder,
            com.google.privacy.dlp.v2.DataRiskLevelOrBuilder>
        dataRiskLevelBuilder_;
    /**
     *
     *
     * <pre>
     * The data risk level for this column.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DataRiskLevel data_risk_level = 8;</code>
     *
     * @return Whether the dataRiskLevel field is set.
     */
    public boolean hasDataRiskLevel() {
      return ((bitField0_ & 0x00001000) != 0);
    }
    /**
     *
     *
     * <pre>
     * The data risk level for this column.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DataRiskLevel data_risk_level = 8;</code>
     *
     * @return The dataRiskLevel.
     */
    public com.google.privacy.dlp.v2.DataRiskLevel getDataRiskLevel() {
      if (dataRiskLevelBuilder_ == null) {
        return dataRiskLevel_ == null
            ? com.google.privacy.dlp.v2.DataRiskLevel.getDefaultInstance()
            : dataRiskLevel_;
      } else {
        return dataRiskLevelBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The data risk level for this column.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DataRiskLevel data_risk_level = 8;</code>
     */
    public Builder setDataRiskLevel(com.google.privacy.dlp.v2.DataRiskLevel value) {
      if (dataRiskLevelBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        dataRiskLevel_ = value;
      } else {
        dataRiskLevelBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The data risk level for this column.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DataRiskLevel data_risk_level = 8;</code>
     */
    public Builder setDataRiskLevel(
        com.google.privacy.dlp.v2.DataRiskLevel.Builder builderForValue) {
      if (dataRiskLevelBuilder_ == null) {
        dataRiskLevel_ = builderForValue.build();
      } else {
        dataRiskLevelBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The data risk level for this column.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DataRiskLevel data_risk_level = 8;</code>
     */
    public Builder mergeDataRiskLevel(com.google.privacy.dlp.v2.DataRiskLevel value) {
      if (dataRiskLevelBuilder_ == null) {
        if (((bitField0_ & 0x00001000) != 0)
            && dataRiskLevel_ != null
            && dataRiskLevel_ != com.google.privacy.dlp.v2.DataRiskLevel.getDefaultInstance()) {
          getDataRiskLevelBuilder().mergeFrom(value);
        } else {
          dataRiskLevel_ = value;
        }
      } else {
        dataRiskLevelBuilder_.mergeFrom(value);
      }
      if (dataRiskLevel_ != null) {
        bitField0_ |= 0x00001000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The data risk level for this column.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DataRiskLevel data_risk_level = 8;</code>
     */
    public Builder clearDataRiskLevel() {
      bitField0_ = (bitField0_ & ~0x00001000);
      dataRiskLevel_ = null;
      if (dataRiskLevelBuilder_ != null) {
        dataRiskLevelBuilder_.dispose();
        dataRiskLevelBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The data risk level for this column.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DataRiskLevel data_risk_level = 8;</code>
     */
    public com.google.privacy.dlp.v2.DataRiskLevel.Builder getDataRiskLevelBuilder() {
      bitField0_ |= 0x00001000;
      onChanged();
      return getDataRiskLevelFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The data risk level for this column.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DataRiskLevel data_risk_level = 8;</code>
     */
    public com.google.privacy.dlp.v2.DataRiskLevelOrBuilder getDataRiskLevelOrBuilder() {
      if (dataRiskLevelBuilder_ != null) {
        return dataRiskLevelBuilder_.getMessageOrBuilder();
      } else {
        return dataRiskLevel_ == null
            ? com.google.privacy.dlp.v2.DataRiskLevel.getDefaultInstance()
            : dataRiskLevel_;
      }
    }
    /**
     *
     *
     * <pre>
     * The data risk level for this column.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DataRiskLevel data_risk_level = 8;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.DataRiskLevel,
            com.google.privacy.dlp.v2.DataRiskLevel.Builder,
            com.google.privacy.dlp.v2.DataRiskLevelOrBuilder>
        getDataRiskLevelFieldBuilder() {
      if (dataRiskLevelBuilder_ == null) {
        dataRiskLevelBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.DataRiskLevel,
                com.google.privacy.dlp.v2.DataRiskLevel.Builder,
                com.google.privacy.dlp.v2.DataRiskLevelOrBuilder>(
                getDataRiskLevel(), getParentForChildren(), isClean());
        dataRiskLevel_ = null;
      }
      return dataRiskLevelBuilder_;
    }

    private com.google.privacy.dlp.v2.InfoTypeSummary columnInfoType_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.InfoTypeSummary,
            com.google.privacy.dlp.v2.InfoTypeSummary.Builder,
            com.google.privacy.dlp.v2.InfoTypeSummaryOrBuilder>
        columnInfoTypeBuilder_;
    /**
     *
     *
     * <pre>
     * If it's been determined this column can be identified as a single type,
     * this will be set. Otherwise the column either has unidentifiable content
     * or mixed types.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InfoTypeSummary column_info_type = 9;</code>
     *
     * @return Whether the columnInfoType field is set.
     */
    public boolean hasColumnInfoType() {
      return ((bitField0_ & 0x00002000) != 0);
    }
    /**
     *
     *
     * <pre>
     * If it's been determined this column can be identified as a single type,
     * this will be set. Otherwise the column either has unidentifiable content
     * or mixed types.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InfoTypeSummary column_info_type = 9;</code>
     *
     * @return The columnInfoType.
     */
    public com.google.privacy.dlp.v2.InfoTypeSummary getColumnInfoType() {
      if (columnInfoTypeBuilder_ == null) {
        return columnInfoType_ == null
            ? com.google.privacy.dlp.v2.InfoTypeSummary.getDefaultInstance()
            : columnInfoType_;
      } else {
        return columnInfoTypeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * If it's been determined this column can be identified as a single type,
     * this will be set. Otherwise the column either has unidentifiable content
     * or mixed types.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InfoTypeSummary column_info_type = 9;</code>
     */
    public Builder setColumnInfoType(com.google.privacy.dlp.v2.InfoTypeSummary value) {
      if (columnInfoTypeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        columnInfoType_ = value;
      } else {
        columnInfoTypeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If it's been determined this column can be identified as a single type,
     * this will be set. Otherwise the column either has unidentifiable content
     * or mixed types.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InfoTypeSummary column_info_type = 9;</code>
     */
    public Builder setColumnInfoType(
        com.google.privacy.dlp.v2.InfoTypeSummary.Builder builderForValue) {
      if (columnInfoTypeBuilder_ == null) {
        columnInfoType_ = builderForValue.build();
      } else {
        columnInfoTypeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If it's been determined this column can be identified as a single type,
     * this will be set. Otherwise the column either has unidentifiable content
     * or mixed types.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InfoTypeSummary column_info_type = 9;</code>
     */
    public Builder mergeColumnInfoType(com.google.privacy.dlp.v2.InfoTypeSummary value) {
      if (columnInfoTypeBuilder_ == null) {
        if (((bitField0_ & 0x00002000) != 0)
            && columnInfoType_ != null
            && columnInfoType_ != com.google.privacy.dlp.v2.InfoTypeSummary.getDefaultInstance()) {
          getColumnInfoTypeBuilder().mergeFrom(value);
        } else {
          columnInfoType_ = value;
        }
      } else {
        columnInfoTypeBuilder_.mergeFrom(value);
      }
      if (columnInfoType_ != null) {
        bitField0_ |= 0x00002000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If it's been determined this column can be identified as a single type,
     * this will be set. Otherwise the column either has unidentifiable content
     * or mixed types.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InfoTypeSummary column_info_type = 9;</code>
     */
    public Builder clearColumnInfoType() {
      bitField0_ = (bitField0_ & ~0x00002000);
      columnInfoType_ = null;
      if (columnInfoTypeBuilder_ != null) {
        columnInfoTypeBuilder_.dispose();
        columnInfoTypeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If it's been determined this column can be identified as a single type,
     * this will be set. Otherwise the column either has unidentifiable content
     * or mixed types.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InfoTypeSummary column_info_type = 9;</code>
     */
    public com.google.privacy.dlp.v2.InfoTypeSummary.Builder getColumnInfoTypeBuilder() {
      bitField0_ |= 0x00002000;
      onChanged();
      return getColumnInfoTypeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * If it's been determined this column can be identified as a single type,
     * this will be set. Otherwise the column either has unidentifiable content
     * or mixed types.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InfoTypeSummary column_info_type = 9;</code>
     */
    public com.google.privacy.dlp.v2.InfoTypeSummaryOrBuilder getColumnInfoTypeOrBuilder() {
      if (columnInfoTypeBuilder_ != null) {
        return columnInfoTypeBuilder_.getMessageOrBuilder();
      } else {
        return columnInfoType_ == null
            ? com.google.privacy.dlp.v2.InfoTypeSummary.getDefaultInstance()
            : columnInfoType_;
      }
    }
    /**
     *
     *
     * <pre>
     * If it's been determined this column can be identified as a single type,
     * this will be set. Otherwise the column either has unidentifiable content
     * or mixed types.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InfoTypeSummary column_info_type = 9;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.InfoTypeSummary,
            com.google.privacy.dlp.v2.InfoTypeSummary.Builder,
            com.google.privacy.dlp.v2.InfoTypeSummaryOrBuilder>
        getColumnInfoTypeFieldBuilder() {
      if (columnInfoTypeBuilder_ == null) {
        columnInfoTypeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.InfoTypeSummary,
                com.google.privacy.dlp.v2.InfoTypeSummary.Builder,
                com.google.privacy.dlp.v2.InfoTypeSummaryOrBuilder>(
                getColumnInfoType(), getParentForChildren(), isClean());
        columnInfoType_ = null;
      }
      return columnInfoTypeBuilder_;
    }

    private java.util.List<com.google.privacy.dlp.v2.OtherInfoTypeSummary> otherMatches_ =
        java.util.Collections.emptyList();

    private void ensureOtherMatchesIsMutable() {
      if (!((bitField0_ & 0x00004000) != 0)) {
        otherMatches_ =
            new java.util.ArrayList<com.google.privacy.dlp.v2.OtherInfoTypeSummary>(otherMatches_);
        bitField0_ |= 0x00004000;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.privacy.dlp.v2.OtherInfoTypeSummary,
            com.google.privacy.dlp.v2.OtherInfoTypeSummary.Builder,
            com.google.privacy.dlp.v2.OtherInfoTypeSummaryOrBuilder>
        otherMatchesBuilder_;

    /**
     *
     *
     * <pre>
     * Other types found within this column. List will be unordered.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.OtherInfoTypeSummary other_matches = 10;</code>
     */
    public java.util.List<com.google.privacy.dlp.v2.OtherInfoTypeSummary> getOtherMatchesList() {
      if (otherMatchesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(otherMatches_);
      } else {
        return otherMatchesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Other types found within this column. List will be unordered.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.OtherInfoTypeSummary other_matches = 10;</code>
     */
    public int getOtherMatchesCount() {
      if (otherMatchesBuilder_ == null) {
        return otherMatches_.size();
      } else {
        return otherMatchesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Other types found within this column. List will be unordered.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.OtherInfoTypeSummary other_matches = 10;</code>
     */
    public com.google.privacy.dlp.v2.OtherInfoTypeSummary getOtherMatches(int index) {
      if (otherMatchesBuilder_ == null) {
        return otherMatches_.get(index);
      } else {
        return otherMatchesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Other types found within this column. List will be unordered.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.OtherInfoTypeSummary other_matches = 10;</code>
     */
    public Builder setOtherMatches(
        int index, com.google.privacy.dlp.v2.OtherInfoTypeSummary value) {
      if (otherMatchesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureOtherMatchesIsMutable();
        otherMatches_.set(index, value);
        onChanged();
      } else {
        otherMatchesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Other types found within this column. List will be unordered.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.OtherInfoTypeSummary other_matches = 10;</code>
     */
    public Builder setOtherMatches(
        int index, com.google.privacy.dlp.v2.OtherInfoTypeSummary.Builder builderForValue) {
      if (otherMatchesBuilder_ == null) {
        ensureOtherMatchesIsMutable();
        otherMatches_.set(index, builderForValue.build());
        onChanged();
      } else {
        otherMatchesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Other types found within this column. List will be unordered.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.OtherInfoTypeSummary other_matches = 10;</code>
     */
    public Builder addOtherMatches(com.google.privacy.dlp.v2.OtherInfoTypeSummary value) {
      if (otherMatchesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureOtherMatchesIsMutable();
        otherMatches_.add(value);
        onChanged();
      } else {
        otherMatchesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Other types found within this column. List will be unordered.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.OtherInfoTypeSummary other_matches = 10;</code>
     */
    public Builder addOtherMatches(
        int index, com.google.privacy.dlp.v2.OtherInfoTypeSummary value) {
      if (otherMatchesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureOtherMatchesIsMutable();
        otherMatches_.add(index, value);
        onChanged();
      } else {
        otherMatchesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Other types found within this column. List will be unordered.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.OtherInfoTypeSummary other_matches = 10;</code>
     */
    public Builder addOtherMatches(
        com.google.privacy.dlp.v2.OtherInfoTypeSummary.Builder builderForValue) {
      if (otherMatchesBuilder_ == null) {
        ensureOtherMatchesIsMutable();
        otherMatches_.add(builderForValue.build());
        onChanged();
      } else {
        otherMatchesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Other types found within this column. List will be unordered.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.OtherInfoTypeSummary other_matches = 10;</code>
     */
    public Builder addOtherMatches(
        int index, com.google.privacy.dlp.v2.OtherInfoTypeSummary.Builder builderForValue) {
      if (otherMatchesBuilder_ == null) {
        ensureOtherMatchesIsMutable();
        otherMatches_.add(index, builderForValue.build());
        onChanged();
      } else {
        otherMatchesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Other types found within this column. List will be unordered.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.OtherInfoTypeSummary other_matches = 10;</code>
     */
    public Builder addAllOtherMatches(
        java.lang.Iterable<? extends com.google.privacy.dlp.v2.OtherInfoTypeSummary> values) {
      if (otherMatchesBuilder_ == null) {
        ensureOtherMatchesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, otherMatches_);
        onChanged();
      } else {
        otherMatchesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Other types found within this column. List will be unordered.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.OtherInfoTypeSummary other_matches = 10;</code>
     */
    public Builder clearOtherMatches() {
      if (otherMatchesBuilder_ == null) {
        otherMatches_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00004000);
        onChanged();
      } else {
        otherMatchesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Other types found within this column. List will be unordered.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.OtherInfoTypeSummary other_matches = 10;</code>
     */
    public Builder removeOtherMatches(int index) {
      if (otherMatchesBuilder_ == null) {
        ensureOtherMatchesIsMutable();
        otherMatches_.remove(index);
        onChanged();
      } else {
        otherMatchesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Other types found within this column. List will be unordered.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.OtherInfoTypeSummary other_matches = 10;</code>
     */
    public com.google.privacy.dlp.v2.OtherInfoTypeSummary.Builder getOtherMatchesBuilder(
        int index) {
      return getOtherMatchesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Other types found within this column. List will be unordered.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.OtherInfoTypeSummary other_matches = 10;</code>
     */
    public com.google.privacy.dlp.v2.OtherInfoTypeSummaryOrBuilder getOtherMatchesOrBuilder(
        int index) {
      if (otherMatchesBuilder_ == null) {
        return otherMatches_.get(index);
      } else {
        return otherMatchesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Other types found within this column. List will be unordered.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.OtherInfoTypeSummary other_matches = 10;</code>
     */
    public java.util.List<? extends com.google.privacy.dlp.v2.OtherInfoTypeSummaryOrBuilder>
        getOtherMatchesOrBuilderList() {
      if (otherMatchesBuilder_ != null) {
        return otherMatchesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(otherMatches_);
      }
    }
    /**
     *
     *
     * <pre>
     * Other types found within this column. List will be unordered.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.OtherInfoTypeSummary other_matches = 10;</code>
     */
    public com.google.privacy.dlp.v2.OtherInfoTypeSummary.Builder addOtherMatchesBuilder() {
      return getOtherMatchesFieldBuilder()
          .addBuilder(com.google.privacy.dlp.v2.OtherInfoTypeSummary.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Other types found within this column. List will be unordered.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.OtherInfoTypeSummary other_matches = 10;</code>
     */
    public com.google.privacy.dlp.v2.OtherInfoTypeSummary.Builder addOtherMatchesBuilder(
        int index) {
      return getOtherMatchesFieldBuilder()
          .addBuilder(index, com.google.privacy.dlp.v2.OtherInfoTypeSummary.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Other types found within this column. List will be unordered.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.OtherInfoTypeSummary other_matches = 10;</code>
     */
    public java.util.List<com.google.privacy.dlp.v2.OtherInfoTypeSummary.Builder>
        getOtherMatchesBuilderList() {
      return getOtherMatchesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.privacy.dlp.v2.OtherInfoTypeSummary,
            com.google.privacy.dlp.v2.OtherInfoTypeSummary.Builder,
            com.google.privacy.dlp.v2.OtherInfoTypeSummaryOrBuilder>
        getOtherMatchesFieldBuilder() {
      if (otherMatchesBuilder_ == null) {
        otherMatchesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.privacy.dlp.v2.OtherInfoTypeSummary,
                com.google.privacy.dlp.v2.OtherInfoTypeSummary.Builder,
                com.google.privacy.dlp.v2.OtherInfoTypeSummaryOrBuilder>(
                otherMatches_, ((bitField0_ & 0x00004000) != 0), getParentForChildren(), isClean());
        otherMatches_ = null;
      }
      return otherMatchesBuilder_;
    }

    private int estimatedNullPercentage_ = 0;
    /**
     *
     *
     * <pre>
     * Approximate percentage of entries being null in the column.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.NullPercentageLevel estimated_null_percentage = 23;</code>
     *
     * @return The enum numeric value on the wire for estimatedNullPercentage.
     */
    @java.lang.Override
    public int getEstimatedNullPercentageValue() {
      return estimatedNullPercentage_;
    }
    /**
     *
     *
     * <pre>
     * Approximate percentage of entries being null in the column.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.NullPercentageLevel estimated_null_percentage = 23;</code>
     *
     * @param value The enum numeric value on the wire for estimatedNullPercentage to set.
     * @return This builder for chaining.
     */
    public Builder setEstimatedNullPercentageValue(int value) {
      estimatedNullPercentage_ = value;
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Approximate percentage of entries being null in the column.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.NullPercentageLevel estimated_null_percentage = 23;</code>
     *
     * @return The estimatedNullPercentage.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.NullPercentageLevel getEstimatedNullPercentage() {
      com.google.privacy.dlp.v2.NullPercentageLevel result =
          com.google.privacy.dlp.v2.NullPercentageLevel.forNumber(estimatedNullPercentage_);
      return result == null ? com.google.privacy.dlp.v2.NullPercentageLevel.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Approximate percentage of entries being null in the column.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.NullPercentageLevel estimated_null_percentage = 23;</code>
     *
     * @param value The estimatedNullPercentage to set.
     * @return This builder for chaining.
     */
    public Builder setEstimatedNullPercentage(com.google.privacy.dlp.v2.NullPercentageLevel value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00008000;
      estimatedNullPercentage_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Approximate percentage of entries being null in the column.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.NullPercentageLevel estimated_null_percentage = 23;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEstimatedNullPercentage() {
      bitField0_ = (bitField0_ & ~0x00008000);
      estimatedNullPercentage_ = 0;
      onChanged();
      return this;
    }

    private int estimatedUniquenessScore_ = 0;
    /**
     *
     *
     * <pre>
     * Approximate uniqueness of the column.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.UniquenessScoreLevel estimated_uniqueness_score = 24;</code>
     *
     * @return The enum numeric value on the wire for estimatedUniquenessScore.
     */
    @java.lang.Override
    public int getEstimatedUniquenessScoreValue() {
      return estimatedUniquenessScore_;
    }
    /**
     *
     *
     * <pre>
     * Approximate uniqueness of the column.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.UniquenessScoreLevel estimated_uniqueness_score = 24;</code>
     *
     * @param value The enum numeric value on the wire for estimatedUniquenessScore to set.
     * @return This builder for chaining.
     */
    public Builder setEstimatedUniquenessScoreValue(int value) {
      estimatedUniquenessScore_ = value;
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Approximate uniqueness of the column.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.UniquenessScoreLevel estimated_uniqueness_score = 24;</code>
     *
     * @return The estimatedUniquenessScore.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.UniquenessScoreLevel getEstimatedUniquenessScore() {
      com.google.privacy.dlp.v2.UniquenessScoreLevel result =
          com.google.privacy.dlp.v2.UniquenessScoreLevel.forNumber(estimatedUniquenessScore_);
      return result == null ? com.google.privacy.dlp.v2.UniquenessScoreLevel.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Approximate uniqueness of the column.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.UniquenessScoreLevel estimated_uniqueness_score = 24;</code>
     *
     * @param value The estimatedUniquenessScore to set.
     * @return This builder for chaining.
     */
    public Builder setEstimatedUniquenessScore(
        com.google.privacy.dlp.v2.UniquenessScoreLevel value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00010000;
      estimatedUniquenessScore_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Approximate uniqueness of the column.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.UniquenessScoreLevel estimated_uniqueness_score = 24;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEstimatedUniquenessScore() {
      bitField0_ = (bitField0_ & ~0x00010000);
      estimatedUniquenessScore_ = 0;
      onChanged();
      return this;
    }

    private double freeTextScore_;
    /**
     *
     *
     * <pre>
     * The likelihood that this column contains free-form text.
     * A value close to 1 may indicate the column is likely to contain
     * free-form or natural language text.
     * Range in 0-1.
     * </pre>
     *
     * <code>double free_text_score = 13;</code>
     *
     * @return The freeTextScore.
     */
    @java.lang.Override
    public double getFreeTextScore() {
      return freeTextScore_;
    }
    /**
     *
     *
     * <pre>
     * The likelihood that this column contains free-form text.
     * A value close to 1 may indicate the column is likely to contain
     * free-form or natural language text.
     * Range in 0-1.
     * </pre>
     *
     * <code>double free_text_score = 13;</code>
     *
     * @param value The freeTextScore to set.
     * @return This builder for chaining.
     */
    public Builder setFreeTextScore(double value) {

      freeTextScore_ = value;
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The likelihood that this column contains free-form text.
     * A value close to 1 may indicate the column is likely to contain
     * free-form or natural language text.
     * Range in 0-1.
     * </pre>
     *
     * <code>double free_text_score = 13;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFreeTextScore() {
      bitField0_ = (bitField0_ & ~0x00020000);
      freeTextScore_ = 0D;
      onChanged();
      return this;
    }

    private int columnType_ = 0;
    /**
     *
     *
     * <pre>
     * The data type of a given column.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ColumnDataProfile.ColumnDataType column_type = 14;</code>
     *
     * @return The enum numeric value on the wire for columnType.
     */
    @java.lang.Override
    public int getColumnTypeValue() {
      return columnType_;
    }
    /**
     *
     *
     * <pre>
     * The data type of a given column.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ColumnDataProfile.ColumnDataType column_type = 14;</code>
     *
     * @param value The enum numeric value on the wire for columnType to set.
     * @return This builder for chaining.
     */
    public Builder setColumnTypeValue(int value) {
      columnType_ = value;
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The data type of a given column.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ColumnDataProfile.ColumnDataType column_type = 14;</code>
     *
     * @return The columnType.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.ColumnDataProfile.ColumnDataType getColumnType() {
      com.google.privacy.dlp.v2.ColumnDataProfile.ColumnDataType result =
          com.google.privacy.dlp.v2.ColumnDataProfile.ColumnDataType.forNumber(columnType_);
      return result == null
          ? com.google.privacy.dlp.v2.ColumnDataProfile.ColumnDataType.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * The data type of a given column.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ColumnDataProfile.ColumnDataType column_type = 14;</code>
     *
     * @param value The columnType to set.
     * @return This builder for chaining.
     */
    public Builder setColumnType(com.google.privacy.dlp.v2.ColumnDataProfile.ColumnDataType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00040000;
      columnType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The data type of a given column.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ColumnDataProfile.ColumnDataType column_type = 14;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearColumnType() {
      bitField0_ = (bitField0_ & ~0x00040000);
      columnType_ = 0;
      onChanged();
      return this;
    }

    private int policyState_ = 0;
    /**
     *
     *
     * <pre>
     * Indicates if a policy tag has been applied to the column.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ColumnDataProfile.ColumnPolicyState policy_state = 15;</code>
     *
     * @return The enum numeric value on the wire for policyState.
     */
    @java.lang.Override
    public int getPolicyStateValue() {
      return policyState_;
    }
    /**
     *
     *
     * <pre>
     * Indicates if a policy tag has been applied to the column.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ColumnDataProfile.ColumnPolicyState policy_state = 15;</code>
     *
     * @param value The enum numeric value on the wire for policyState to set.
     * @return This builder for chaining.
     */
    public Builder setPolicyStateValue(int value) {
      policyState_ = value;
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indicates if a policy tag has been applied to the column.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ColumnDataProfile.ColumnPolicyState policy_state = 15;</code>
     *
     * @return The policyState.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.ColumnDataProfile.ColumnPolicyState getPolicyState() {
      com.google.privacy.dlp.v2.ColumnDataProfile.ColumnPolicyState result =
          com.google.privacy.dlp.v2.ColumnDataProfile.ColumnPolicyState.forNumber(policyState_);
      return result == null
          ? com.google.privacy.dlp.v2.ColumnDataProfile.ColumnPolicyState.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Indicates if a policy tag has been applied to the column.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ColumnDataProfile.ColumnPolicyState policy_state = 15;</code>
     *
     * @param value The policyState to set.
     * @return This builder for chaining.
     */
    public Builder setPolicyState(
        com.google.privacy.dlp.v2.ColumnDataProfile.ColumnPolicyState value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00080000;
      policyState_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indicates if a policy tag has been applied to the column.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ColumnDataProfile.ColumnPolicyState policy_state = 15;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPolicyState() {
      bitField0_ = (bitField0_ & ~0x00080000);
      policyState_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.privacy.dlp.v2.ColumnDataProfile)
  }

  // @@protoc_insertion_point(class_scope:google.privacy.dlp.v2.ColumnDataProfile)
  private static final com.google.privacy.dlp.v2.ColumnDataProfile DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.privacy.dlp.v2.ColumnDataProfile();
  }

  public static com.google.privacy.dlp.v2.ColumnDataProfile getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ColumnDataProfile> PARSER =
      new com.google.protobuf.AbstractParser<ColumnDataProfile>() {
        @java.lang.Override
        public ColumnDataProfile parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ColumnDataProfile> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ColumnDataProfile> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.privacy.dlp.v2.ColumnDataProfile getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
